# Lock View
## Introduction

Lock View is a [Foundry VTT](https://foundryvtt.com/) module that provides the GM or a designated player with options to control how Foundry is displayed and controlled. The main features include:

* <b>Autoscaling</b>: Autoscaling the scene so it fills the display or scaled so the grid corresponds with physical dimensions.
* <b>Locks</b>: Pan & zoom locks to prevent users from panning or zooming, or force their view to stay within a specified bounding box.
* <b>Force Initial View</b>: Make sure that a scene loads to a specified view position and scale.
* <b>Viewbox</b>: Allows the GM to see the view of users, represented by rectangles drawn on the canvas.
* <b>Panning & Zooming User Views</b>: Move a user's view to a specific point, or offset it by a specific amount of grid spaces.
* <b>Cloning View</b>: Apply your current view to users.

### [Documentation](https://materialfoundry.github.io/LockView/)

## Module Compatibility
When 'Zoom Lock' or 'Pan Lock' are enabled, this module disables all zooming and/or panning functionality, regardless of who or what is requesting that zoom or pan. This means that, for example, modules that try to pan or zoom won't work. Lock View uses [libWrapper](https://foundryvtt.com/packages/lib-wrapper), through which incompatibilities might be prevented/fixed.

## Foundry Compatibility
This module has been tested to work with Foundry V13.<br>
Lock View versions are available for older Foundry versions, see [here](https://foundryvtt.com/packages/LockView).

## Feedback
Feel free [report an issue/suggestion](https://github.com/MaterialFoundry/LockView/issues), contact me on Discord (materialfoundry), or send me an email: info@materialfoundry.nl.

## Credits
**Author**: Material Foundry (materialfoundry on Discord)

If you enjoy using my modules, please consider supporting me on [Patreon](https://www.patreon.com/materialfoundry) or buy me a coffee through [Ko-fi](https://ko-fi.com/materialfoundry). 