Hooks.on('diceSoNiceReady', (dice3d) => {
  dice3d.addSystem({ id: "arctic", name: "🔮 Arctic", group: "Dice Soup" }, "default");
  dice3d.addSystem({ id: "cosmos", name: "🔮 Cosmos", group: "Dice Soup" }, "default");
  dice3d.addSystem({ id: "dawn", name: "🔮 Dawn", group: "Dice Soup" }, "default");
  dice3d.addSystem({ id: "lava", name: "🔮 Lava", group: "Dice Soup" }, "default");
  dice3d.addSystem({ id: "liquid-gold", name: "🔮 Liquid Gold", group: "Dice Soup" }, "default");
  dice3d.addSystem({ id: "parfait", name: "🔮 Parfait", group: "Dice Soup" }, "default");
  dice3d.addSystem({ id: "rainfall", name: "🔮 Rainfall", group: "Dice Soup" }, "default");
  dice3d.addSystem({ id: "sanguine", name: "🔮 Sanguine", group: "Dice Soup" }, "default");
  dice3d.addSystem({ id: "solar", name: "🔮 Solar Embers", group: "Dice Soup" }, "default");
  dice3d.addSystem({ id: "source-green", name: "🔮 Source - Green", group: "Dice Soup" }, "default");
  dice3d.addSystem({ id: "source-purple", name: "🔮 Source - Purple", group: "Dice Soup" }, "default");
  dice3d.addSystem({ id: "source-red", name: "🔮 Source - Red", group: "Dice Soup" }, "default");
  dice3d.addSystem({ id: "toxin", name: "🔮 Toxin", group: "Dice Soup" }, "default");


//-------------------- DICE PRESETS --------------------

//-------------------- Arctic --------------------
dice3d.addDicePreset({
    type: "d20",
    atlas: "modules/dice-soup/textures/arctic/arctic_1.json",
    labels: [
	'd20_1.webp',
	'd20_2.webp',
	'd20_3.webp',
	'd20_4.webp',
	'd20_5.webp',
	'd20_6.webp',
	'd20_7.webp',
	'd20_8.webp',
	'd20_9.webp',
	'd20_10.webp',
	'd20_11.webp',
	'd20_12.webp',
	'd20_13.webp',
	'd20_14.webp',
	'd20_15.webp',
	'd20_16.webp',
	'd20_17.webp',
	'd20_18.webp',
	'd20_19.webp',
	'd20_20.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d20_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_11.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_12.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_13.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_14.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_15.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_16.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_17.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_18.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_19.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_20.webp"
    ],
    colorset: 'arctic',
    system: "arctic"
});
dice3d.addDicePreset({
    type: "d12",
    atlas: "modules/dice-soup/textures/arctic/arctic_2.json",
    labels: [
	'd12_1.webp',
	'd12_2.webp',
	'd12_3.webp',
	'd12_4.webp',
	'd12_5.webp',
	'd12_6.webp',
	'd12_7.webp',
	'd12_8.webp',
	'd12_9.webp',
	'd12_10.webp',
	'd12_11.webp',
	'd12_12.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d12_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_11.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_12.webp"
    ],
    colorset: 'arctic',
    system: "arctic"
});
dice3d.addDicePreset({
    type: "d10",
    atlas: "modules/dice-soup/textures/arctic/arctic_2.json",
    labels: [
	'd10_1.webp',
	'd10_2.webp',
	'd10_3.webp',
	'd10_4.webp',
	'd10_5.webp',
	'd10_6.webp',
	'd10_7.webp',
	'd10_8.webp',
	'd10_9.webp',
	'd10_10.webp'     
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d10_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_10.webp"
    ],
    colorset: 'arctic',
    system: "arctic"
});
dice3d.addDicePreset({
    type: "d100",
    atlas: "modules/dice-soup/textures/arctic/arctic_2.json",
    labels: [
	'd100_10.webp',
	'd100_20.webp',
	'd100_30.webp',
	'd100_40.webp',
	'd100_50.webp',
	'd100_60.webp',
	'd100_70.webp',
	'd100_80.webp',
	'd100_90.webp',
	'd100_100.webp'    
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d100_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_20.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_30.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_40.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_50.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_60.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_70.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_80.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_90.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_100.webp"
    ],
    colorset: 'arctic',
    system: "arctic"
});
dice3d.addDicePreset({
    type: "d8",
    atlas: "modules/dice-soup/textures/arctic/arctic_2.json",
    labels: [
	'd8_1.webp',
	'd8_2.webp',
	'd8_3.webp',
	'd8_4.webp',
	'd8_5.webp',
	'd8_6.webp',
	'd8_7.webp',
	'd8_8.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d8_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_8.webp"
    ],
    colorset: 'arctic',
    system: "arctic"
});
dice3d.addDicePreset({
    type: "d6",
    atlas: "modules/dice-soup/textures/arctic/arctic_2.json",
    labels: [
	'd6_1.webp',
	'd6_2.webp',
	'd6_3.webp',
	'd6_4.webp',
	'd6_5.webp',
	'd6_6.webp' 
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d6_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_6.webp"
    ],
    colorset: 'arctic',
    system: "arctic"
});
dice3d.addDicePreset({
    type: "df",
    atlas: "modules/dice-soup/textures/arctic/arctic_2.json",
    labels: [
	'df_m.webp',
	'df_0.webp',
	'df_p.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/df_b_m.webp",,
	"modules/dice-soup/textures/bump/font_2/df_b_p.webp"
    ],
    colorset: 'arctic',
    system: "arctic"
});
dice3d.addDicePreset({
    type: "d4",
    modelFile: "modules/dice-soup/textures/arctic/arctic_d4.glb",
	system: "arctic"
});
dice3d.addDicePreset({
    type: "d2",
    atlas: "modules/dice-soup/textures/arctic/arctic_2.json",
    labels: [
	'd2_1.webp',
	'd2_2.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d2_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d2_b_2.webp"
    ],
    colorset: 'arctic',
    system: "arctic"
});
//-------------------- Cosmos --------------------
dice3d.addDicePreset({
    type: "d20",
    atlas: "modules/dice-soup/textures/cosmos/cosmos_2.json",
    labels: [
	'd20_1.webp',
	'd20_2.webp',
	'd20_3.webp',
	'd20_4.webp',
	'd20_5.webp',
	'd20_6.webp',
	'd20_7.webp',
	'd20_8.webp',
	'd20_9.webp',
	'd20_10.webp',
	'd20_11.webp',
	'd20_12.webp',
	'd20_13.webp',
	'd20_14.webp',
	'd20_15.webp',
	'd20_16.webp',
	'd20_17.webp',
	'd20_18.webp',
	'd20_19.webp',
	'd20_20.webp'
    ],
   bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d20_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_11.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_12.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_13.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_14.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_15.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_16.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_17.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_18.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_19.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_20.webp"
    ],
      emissiveMaps: [
	'd20_1.webp',
	'd20_2.webp',
	'd20_3.webp',
	'd20_4.webp',
	'd20_5.webp',
	'd20_6.webp',
	'd20_7.webp',
	'd20_8.webp',
	'd20_9.webp',
	'd20_10.webp',
	'd20_11.webp',
	'd20_12.webp',
	'd20_13.webp',
	'd20_14.webp',
	'd20_15.webp',
	'd20_16.webp',
	'd20_17.webp',
	'd20_18.webp',
	'd20_19.webp',
	'd20_20.webp'
      ],
    emissive: 0xb776db,
    emissiveIntensity: 1,
    colorset: 'black_custom',
    system: "cosmos"
});
dice3d.addDicePreset({
    type: "d12",
    atlas: "modules/dice-soup/textures/cosmos/cosmos_1.json",
    labels: [
	'd12_1.webp',
	'd12_2.webp',
	'd12_3.webp',
	'd12_4.webp',
	'd12_5.webp',
	'd12_6.webp',
	'd12_7.webp',
	'd12_8.webp',
	'd12_9.webp',
	'd12_10.webp',
	'd12_11.webp',
	'd12_12.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d12_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_11.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_12.webp"
    ],
    emissiveMaps: [
	'd12_1.webp',
	'd12_2.webp',
	'd12_3.webp',
	'd12_4.webp',
	'd12_5.webp',
	'd12_6.webp',
	'd12_7.webp',
	'd12_8.webp',
	'd12_9.webp',
	'd12_10.webp',
	'd12_11.webp',
	'd12_12.webp'
],
    emissive: 0xb776db,
    emissiveIntensity: 0.75,
    colorset: 'black_custom',
    system: "cosmos"
});
dice3d.addDicePreset({
    type: "d10",
    atlas: "modules/dice-soup/textures/cosmos/cosmos_1.json",
    labels: [
	'd10_1.webp',
	'd10_2.webp',
	'd10_3.webp',
	'd10_4.webp',
	'd10_5.webp',
	'd10_6.webp',
	'd10_7.webp',
	'd10_8.webp',
	'd10_9.webp',
	'd10_10.webp'    
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d10_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_10.webp"
    ],
    emissiveMaps: [
	'd10_1.webp',
	'd10_2.webp',
	'd10_3.webp',
	'd10_4.webp',
	'd10_5.webp',
	'd10_6.webp',
	'd10_7.webp',
	'd10_8.webp',
	'd10_9.webp',
	'd10_10.webp'    
],
    emissive: 0xb776db,
    emissiveIntensity: 0.75,
    colorset: 'black_custom',
    system: "cosmos"
});
dice3d.addDicePreset({
    type: "d100",
    atlas: "modules/dice-soup/textures/cosmos/cosmos_1.json",
    labels: [
	'd100_10.webp',
	'd100_20.webp',
	'd100_30.webp',
	'd100_40.webp',
	'd100_50.webp',
	'd100_60.webp',
	'd100_70.webp',
	'd100_80.webp',
	'd100_90.webp',
	'd100_100.webp'    
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d100_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_20.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_30.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_40.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_50.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_60.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_70.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_80.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_90.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_100.webp"
    ],
    emissiveMaps: [
	'd100_10.webp',
	'd100_20.webp',
	'd100_30.webp',
	'd100_40.webp',
	'd100_50.webp',
	'd100_60.webp',
	'd100_70.webp',
	'd100_80.webp',
	'd100_90.webp',
	'd100_100.webp'  
],
    emissive: 0xb776db,
    emissiveIntensity: 0.75,
    colorset: 'black_custom',
    system: "cosmos"
});
dice3d.addDicePreset({
    type: "d8",
    atlas: "modules/dice-soup/textures/cosmos/cosmos_1.json",
    labels: [
	'd8_1.webp',
	'd8_2.webp',
	'd8_3.webp',
	'd8_4.webp',
	'd8_5.webp',
	'd8_6.webp',
	'd8_7.webp',
	'd8_8.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d8_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_8.webp"
    ],
    emissiveMaps: [
	'd8_1.webp',
	'd8_2.webp',
	'd8_3.webp',
	'd8_4.webp',
	'd8_5.webp',
	'd8_6.webp',
	'd8_7.webp',
	'd8_8.webp'
],
    emissive: 0xb776db,
    emissiveIntensity: 0.75,
    colorset: 'black_custom',
    system: "cosmos"
});
dice3d.addDicePreset({
    type: "d6",
    atlas: "modules/dice-soup/textures/cosmos/cosmos_1.json",
    labels: [
	'd6_1.webp',
	'd6_2.webp',
	'd6_3.webp',
	'd6_4.webp',
	'd6_5.webp',
	'd6_6.webp' 
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d6_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_6.webp"
    ],
    emissiveMaps: [
	'd6_1.webp',
	'd6_2.webp',
	'd6_3.webp',
	'd6_4.webp',
	'd6_5.webp',
	'd6_6.webp' 
],
    emissive: 0xb776db,
    emissiveIntensity: 0.75,
    colorset: 'black_custom',
    system: "cosmos"
});
dice3d.addDicePreset({
    type: "df",
    atlas: "modules/dice-soup/textures/cosmos/cosmos_1.json",
    labels: [
	'df_m.webp',
	'df_0.webp',
	'df_p.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/df_b_m.webp",,
	"modules/dice-soup/textures/bump/font_2/df_b_p.webp"
    ],
    emissiveMaps: [
	'df_m.webp',
	'df_0.webp',
	'df_p.webp'
],
    emissive: 0xb776db,
    emissiveIntensity: 0.75,
    colorset: 'black_custom',
    system: "cosmos"
});
dice3d.addDicePreset({
    type: "d4",
    modelFile: "modules/dice-soup/textures/cosmos/cosmos_d4.glb",
    system: "cosmos"
});
dice3d.addDicePreset({
    type: "d2",
    atlas: "modules/dice-soup/textures/cosmos/cosmos_1.json",
    labels: [
	'd2_1.webp',
	'd2_2.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d2_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d2_b_2.webp"
    ],
    emissiveMaps: [
	'd2_1.webp',
	'd2_2.webp'
],
    emissive: 0xb776db,
    emissiveIntensity: 0.75,
    colorset: 'black_custom',
    system: "cosmos"
});
//-------------------- Dawn --------------------
dice3d.addDicePreset({
    type: "d20",
    atlas: "modules/dice-soup/textures/dawn/dawn_2.json",
    labels: [
	'd20_1.webp',
	'd20_2.webp',
	'd20_3.webp',
	'd20_4.webp',
	'd20_5.webp',
	'd20_6.webp',
	'd20_7.webp',
	'd20_8.webp',
	'd20_9.webp',
	'd20_10.webp',
	'd20_11.webp',
	'd20_12.webp',
	'd20_13.webp',
	'd20_14.webp',
	'd20_15.webp',
	'd20_16.webp',
	'd20_17.webp',
	'd20_18.webp',
	'd20_19.webp',
	'd20_20.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d20_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_11.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_12.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_13.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_14.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_15.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_16.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_17.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_18.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_19.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_20.webp"
    ],
      emissiveMaps: [
	'd20_1.webp',
	'd20_2.webp',
	'd20_3.webp',
	'd20_4.webp',
	'd20_5.webp',
	'd20_6.webp',
	'd20_7.webp',
	'd20_8.webp',
	'd20_9.webp',
	'd20_10.webp',
	'd20_11.webp',
	'd20_12.webp',
	'd20_13.webp',
	'd20_14.webp',
	'd20_15.webp',
	'd20_16.webp',
	'd20_17.webp',
	'd20_18.webp',
	'd20_19.webp',
	'd20_20.webp'
      ],
    emissive: 0xffbb00,
    emissiveIntensity: 0.25,
    colorset: 'dawn',
    system: "dawn"
});
dice3d.addDicePreset({
    type: "d12",
    atlas: "modules/dice-soup/textures/dawn/dawn_1.json",
    labels: [
	'd12_1.webp',
	'd12_2.webp',
	'd12_3.webp',
	'd12_4.webp',
	'd12_5.webp',
	'd12_6.webp',
	'd12_7.webp',
	'd12_8.webp',
	'd12_9.webp',
	'd12_10.webp',
	'd12_11.webp',
	'd12_12.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d12_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_11.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_12.webp"
    ],
    emissiveMaps: [
	'd12_1.webp',
	'd12_2.webp',
	'd12_3.webp',
	'd12_4.webp',
	'd12_5.webp',
	'd12_6.webp',
	'd12_7.webp',
	'd12_8.webp',
	'd12_9.webp',
	'd12_10.webp',
	'd12_11.webp',
	'd12_12.webp'
],
    emissive: 0xffbb00,
    emissiveIntensity: 0.18,
    colorset: 'dawn',
    system: "dawn"
});
dice3d.addDicePreset({
    type: "d10",
    atlas: "modules/dice-soup/textures/dawn/dawn_1.json",
    labels: [
	'd10_1.webp',
	'd10_2.webp',
	'd10_3.webp',
	'd10_4.webp',
	'd10_5.webp',
	'd10_6.webp',
	'd10_7.webp',
	'd10_8.webp',
	'd10_9.webp',
	'd10_10.webp' 
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d10_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_10.webp"
    ],
    emissiveMaps: [
	'd10_1.webp',
	'd10_2.webp',
	'd10_3.webp',
	'd10_4.webp',
	'd10_5.webp',
	'd10_6.webp',
	'd10_7.webp',
	'd10_8.webp',
	'd10_9.webp',
	'd10_10.webp'    
],
    emissive: 0xffbb00,
    emissiveIntensity: 0.25,
    colorset: 'dawn',
    system: "dawn"
});
dice3d.addDicePreset({
    type: "d100",
    atlas: "modules/dice-soup/textures/dawn/dawn_1.json",
    labels: [
	'd100_10.webp',
	'd100_20.webp',
	'd100_30.webp',
	'd100_40.webp',
	'd100_50.webp',
	'd100_60.webp',
	'd100_70.webp',
	'd100_80.webp',
	'd100_90.webp',
	'd100_100.webp'    
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d100_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_20.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_30.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_40.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_50.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_60.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_70.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_80.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_90.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_100.webp"
    ],
    emissiveMaps: [
	'd100_10.webp',
	'd100_20.webp',
	'd100_30.webp',
	'd100_40.webp',
	'd100_50.webp',
	'd100_60.webp',
	'd100_70.webp',
	'd100_80.webp',
	'd100_90.webp',
	'd100_100.webp'  
],
    emissive: 0xffbb00,
    emissiveIntensity: 0.18,
    colorset: 'dawn',
    system: "dawn"
});
dice3d.addDicePreset({
    type: "d8",
    atlas: "modules/dice-soup/textures/dawn/dawn_1.json",
    labels: [
	'd8_1.webp',
	'd8_2.webp',
	'd8_3.webp',
	'd8_4.webp',
	'd8_5.webp',
	'd8_6.webp',
	'd8_7.webp',
	'd8_8.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d8_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_8.webp"
    ],
    emissiveMaps: [
	'd8_1.webp',
	'd8_2.webp',
	'd8_3.webp',
	'd8_4.webp',
	'd8_5.webp',
	'd8_6.webp',
	'd8_7.webp',
	'd8_8.webp'
],
    emissive: 0xffbb00,
    emissiveIntensity: 0.18,
    colorset: 'dawn',
    system: "dawn"
});
dice3d.addDicePreset({
    type: "d6",
    atlas: "modules/dice-soup/textures/dawn/dawn_1.json",
    labels: [
	'd6_1.webp',
	'd6_2.webp',
	'd6_3.webp',
	'd6_4.webp',
	'd6_5.webp',
	'd6_6.webp' 
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d6_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_6.webp"
    ],
    emissiveMaps: [
	'd6_1.webp',
	'd6_2.webp',
	'd6_3.webp',
	'd6_4.webp',
	'd6_5.webp',
	'd6_6.webp' 
],
    emissive: 0xffbb00,
    emissiveIntensity: 0.18,
    colorset: 'dawn',
    system: "dawn"
});
dice3d.addDicePreset({
    type: "df",
    atlas: "modules/dice-soup/textures/dawn/dawn_1.json",
    labels: [
	'df_m.webp',
	'df_0.webp',
	'df_p.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/df_b_m.webp",,
	"modules/dice-soup/textures/bump/font_2/df_b_p.webp"
    ],
    emissiveMaps: [
	'df_m.webp',
	'df_0.webp',
	'df_p.webp'
],
    emissive: 0xffbb00,
    emissiveIntensity: 0.25,
    colorset: 'dawn',
    system: "dawn"
});
dice3d.addDicePreset({
    type: "d4",
    modelFile: "modules/dice-soup/textures/dawn/dawn_d4.glb",
    system: "dawn"
});
dice3d.addDicePreset({
    type: "d2",
    atlas: "modules/dice-soup/textures/dawn/dawn_1.json",
    labels: [
	'd2_1.webp',
	'd2_2.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d2_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d2_b_2.webp"
    ],
    emissiveMaps: [
	'd2_1.webp',
	'd2_2.webp'
],
    emissive: 0xffbb00,
    emissiveIntensity: 0.18,
    colorset: 'dawn',
    system: "dawn"
});
//-------------------- Lava --------------------
dice3d.addDicePreset({
    type: "d20",
    atlas: "modules/dice-soup/textures/lava/lava_2.json",
    labels: [
	'd20_1.webp',
	'd20_2.webp',
	'd20_3.webp',
	'd20_4.webp',
	'd20_5.webp',
	'd20_6.webp',
	'd20_7.webp',
	'd20_8.webp',
	'd20_9.webp',
	'd20_10.webp',
	'd20_11.webp',
	'd20_12.webp',
	'd20_13.webp',
	'd20_14.webp',
	'd20_15.webp',
	'd20_16.webp',
	'd20_17.webp',
	'd20_18.webp',
	'd20_19.webp',
	'd20_20.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d20_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_11.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_12.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_13.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_14.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_15.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_16.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_17.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_18.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_19.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_20.webp"
    ],
    emissiveMaps: [
	"modules/dice-soup/textures/bump/font_2/d20_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_11.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_12.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_13.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_14.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_15.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_16.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_17.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_18.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_19.webp",

    ],
    colorset: 'lava',
    emissive: 0xb84000,
    emissiveIntensity: 0.75,
    system: "lava"
});
dice3d.addDicePreset({
    type: "d12",
    atlas: "modules/dice-soup/textures/lava/lava_1.json",
    labels: [
	'd12_1.webp',
	'd12_2.webp',
	'd12_3.webp',
	'd12_4.webp',
	'd12_5.webp',
	'd12_6.webp',
	'd12_7.webp',
	'd12_8.webp',
	'd12_9.webp',
	'd12_10.webp',
	'd12_11.webp',
	'd12_12.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d12_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_11.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_12.webp"
    ],
    emissiveMaps: [
	"modules/dice-soup/textures/bump/font_2/d12_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_11.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_12.webp"
    ],
    colorset: 'lava',
    emissive: 0xb84000,
    emissiveIntensity: 0.75,
    system: "lava"
});
dice3d.addDicePreset({
    type: "d10",
    atlas: "modules/dice-soup/textures/lava/lava_1.json",
    labels: [
	'd10_1.webp',
	'd10_2.webp',
	'd10_3.webp',
	'd10_4.webp',
	'd10_5.webp',
	'd10_6.webp',
	'd10_7.webp',
	'd10_8.webp',
	'd10_9.webp',
	'd10_10.webp' 
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d10_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_10.webp"
    ],
    emissiveMaps: [
	"modules/dice-soup/textures/bump/font_2/d10_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_10.webp"
    ],
    colorset: 'lava',
    emissive: 0xb84000,
    emissiveIntensity: 0.75,
    system: "lava"
});
dice3d.addDicePreset({
    type: "d100",
    atlas: "modules/dice-soup/textures/lava/lava_1.json",
    labels: [
	'd100_10.webp',
	'd100_20.webp',
	'd100_30.webp',
	'd100_40.webp',
	'd100_50.webp',
	'd100_60.webp',
	'd100_70.webp',
	'd100_80.webp',
	'd100_90.webp',
	'd100_100.webp'    
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d100_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_20.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_30.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_40.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_50.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_60.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_70.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_80.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_90.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_100.webp"
    ],
    emissiveMaps: [
	"modules/dice-soup/textures/bump/font_2/d100_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_20.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_30.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_40.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_50.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_60.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_70.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_80.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_90.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_100.webp"
    ],
    colorset: 'lava',
    emissive: 0xb84000,
    emissiveIntensity: 0.75,
    system: "lava"
});
dice3d.addDicePreset({
    type: "d8",
    atlas: "modules/dice-soup/textures/lava/lava_1.json",
    labels: [
	'd8_1.webp',
	'd8_2.webp',
	'd8_3.webp',
	'd8_4.webp',
	'd8_5.webp',
	'd8_6.webp',
	'd8_7.webp',
	'd8_8.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d8_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_8.webp"
    ],
    emissiveMaps: [
	"modules/dice-soup/textures/bump/font_2/d8_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_8.webp"
    ],
    colorset: 'lava',
    emissive: 0xb84000,
    emissiveIntensity: 0.75,
    system: "lava"
});
dice3d.addDicePreset({
    type: "d6",
    atlas: "modules/dice-soup/textures/lava/lava_1.json",
    labels: [
	'd6_1.webp',
	'd6_2.webp',
	'd6_3.webp',
	'd6_4.webp',
	'd6_5.webp',
	'd6_6.webp' 
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d6_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_6.webp"
    ],
    emissiveMaps: [
	"modules/dice-soup/textures/bump/font_2/d6_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_6.webp"
    ],
    colorset: 'lava',
    emissive: 0xb84000,
    emissiveIntensity: 0.75,
    system: "lava"
});
dice3d.addDicePreset({
    type: "df",
    atlas: "modules/dice-soup/textures/lava/lava_1.json",
    labels: [
	'df_m.webp',
	'df_0.webp',
	'df_p.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/df_b_m.webp",,
	"modules/dice-soup/textures/bump/font_2/df_b_p.webp"
    ],
    emissiveMaps: [
	"modules/dice-soup/textures/bump/font_2/df_b_m.webp",,
	"modules/dice-soup/textures/bump/font_2/df_b_p.webp"
    ],
    colorset: 'lava',
    emissive: 0xb84000,
    emissiveIntensity: 0.75,
    system: "lava"
});
dice3d.addDicePreset({
    type: "d4",
    modelFile: "modules/dice-soup/textures/lava/lava_d4.glb",
    system: "lava"
});
dice3d.addDicePreset({
    type: "d2",
    atlas: "modules/dice-soup/textures/lava/lava_1.json",
    labels: [
	'd2_1.webp',
	'd2_2.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d2_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d2_b_2.webp"
    ],
    emissiveMaps: [
	"modules/dice-soup/textures/bump/font_2/d2_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d2_b_2.webp"
    ],
    colorset: 'lava',
    emissive: 0xb84000,
    emissiveIntensity: 0.75,
    system: "lava"
});
//-------------------- Liquid Gold --------------------
dice3d.addDicePreset({
    type: "d20",
    atlas: "modules/dice-soup/textures/lg/lg_2.json",
    labels: [
	'd20_1.webp',
	'd20_2.webp',
	'd20_3.webp',
	'd20_4.webp',
	'd20_5.webp',
	'd20_6.webp',
	'd20_7.webp',
	'd20_8.webp',
	'd20_9.webp',
	'd20_10.webp',
	'd20_11.webp',
	'd20_12.webp',
	'd20_13.webp',
	'd20_14.webp',
	'd20_15.webp',
	'd20_16.webp',
	'd20_17.webp',
	'd20_18.webp',
	'd20_19.webp',
	'd20_20.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d20_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_11.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_12.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_13.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_14.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_15.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_16.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_17.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_18.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_19.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_20.webp"
    ],
    colorset: 'black_custom',
    system: 'liquid-gold'
});
dice3d.addDicePreset({
    type: "d12",
    atlas: "modules/dice-soup/textures/lg/lg_1.json",
    labels: [
	'd12_1.webp',
	'd12_2.webp',
	'd12_3.webp',
	'd12_4.webp',
	'd12_5.webp',
	'd12_6.webp',
	'd12_7.webp',
	'd12_8.webp',
	'd12_9.webp',
	'd12_10.webp',
	'd12_11.webp',
	'd12_12.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d12_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_11.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_12.webp"
    ],
    colorset: 'black_custom',
    system: "liquid-gold"
});
dice3d.addDicePreset({
    type: "d10",
    atlas: "modules/dice-soup/textures/lg/lg_1.json",
    labels: [
	'd10_1.webp',
	'd10_2.webp',
	'd10_3.webp',
	'd10_4.webp',
	'd10_5.webp',
	'd10_6.webp',
	'd10_7.webp',
	'd10_8.webp',
	'd10_9.webp',
	'd10_10.webp'     
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d10_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_10.webp"
    ],
    colorset: 'black_custom',
    system: "liquid-gold"
});
dice3d.addDicePreset({
    type: "d100",
    atlas: "modules/dice-soup/textures/lg/lg_1.json",
    labels: [
	'd100_10.webp',
	'd100_20.webp',
	'd100_30.webp',
	'd100_40.webp',
	'd100_50.webp',
	'd100_60.webp',
	'd100_70.webp',
	'd100_80.webp',
	'd100_90.webp',
	'd100_100.webp'    
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d100_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_20.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_30.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_40.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_50.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_60.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_70.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_80.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_90.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_100.webp"
    ],
    colorset: 'black_custom',
    system: "liquid-gold"
});
dice3d.addDicePreset({
    type: "d8",
    atlas: "modules/dice-soup/textures/lg/lg_1.json",
    labels: [
	'd8_1.webp',
	'd8_2.webp',
	'd8_3.webp',
	'd8_4.webp',
	'd8_5.webp',
	'd8_6.webp',
	'd8_7.webp',
	'd8_8.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d8_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_8.webp"
    ],
    colorset: 'black_custom',
    system: "liquid-gold"
});
dice3d.addDicePreset({
    type: "d6",
    atlas: "modules/dice-soup/textures/lg/lg_1.json",
    labels: [
	'd6_1.webp',
	'd6_2.webp',
	'd6_3.webp',
	'd6_4.webp',
	'd6_5.webp',
	'd6_6.webp' 
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d6_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_6.webp"
    ],
    colorset: 'black_custom',
    system: "liquid-gold"
});
dice3d.addDicePreset({
    type: "df",
    atlas: "modules/dice-soup/textures/lg/lg_1.json",
    labels: [
	'df_m.webp',
	'df_0.webp',
	'df_p.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/df_b_m.webp",,
	"modules/dice-soup/textures/bump/font_2/df_b_p.webp"
    ],
    colorset: 'black_custom',
    system: "liquid-gold"
});
dice3d.addDicePreset({
    type: "d4",
    modelFile: "modules/dice-soup/textures/lg/liquidgold_d4.glb",
    system: "liquid-gold"
});
dice3d.addDicePreset({
    type: "d2",
    atlas: "modules/dice-soup/textures/lg/lg_1.json",
    labels: [
	'd2_1.webp',
	'd2_2.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d2_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d2_b_2.webp"
    ],
    colorset: 'black_custom',
    system: "liquid-gold"
});
//-------------------- Parfait --------------------
dice3d.addDicePreset({
    type: "d20",
    atlas: "modules/dice-soup/textures/parfait/parfait_2.json",
    labels: [
	'd20_1.webp',
	'd20_2.webp',
	'd20_3.webp',
	'd20_4.webp',
	'd20_5.webp',
	'd20_6.webp',
	'd20_7.webp',
	'd20_8.webp',
	'd20_9.webp',
	'd20_10.webp',
	'd20_11.webp',
	'd20_12.webp',
	'd20_13.webp',
	'd20_14.webp',
	'd20_15.webp',
	'd20_16.webp',
	'd20_17.webp',
	'd20_18.webp',
	'd20_19.webp',
	'd20_20.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_1/d20_b_1.webp",
	"modules/dice-soup/textures/bump/font_1/d20_b_2.webp",
	"modules/dice-soup/textures/bump/font_1/d20_b_3.webp",
	"modules/dice-soup/textures/bump/font_1/d20_b_4.webp",
	"modules/dice-soup/textures/bump/font_1/d20_b_5.webp",
	"modules/dice-soup/textures/bump/font_1/d20_b_6.webp",
	"modules/dice-soup/textures/bump/font_1/d20_b_7.webp",
	"modules/dice-soup/textures/bump/font_1/d20_b_8.webp",
	"modules/dice-soup/textures/bump/font_1/d20_b_9.webp",
	"modules/dice-soup/textures/bump/font_1/d20_b_10.webp",
	"modules/dice-soup/textures/bump/font_1/d20_b_11.webp",
	"modules/dice-soup/textures/bump/font_1/d20_b_12.webp",
	"modules/dice-soup/textures/bump/font_1/d20_b_13.webp",
	"modules/dice-soup/textures/bump/font_1/d20_b_14.webp",
	"modules/dice-soup/textures/bump/font_1/d20_b_15.webp",
	"modules/dice-soup/textures/bump/font_1/d20_b_16.webp",
	"modules/dice-soup/textures/bump/font_1/d20_b_17.webp",
	"modules/dice-soup/textures/bump/font_1/d20_b_18.webp",
	"modules/dice-soup/textures/bump/font_1/d20_b_19.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_20.webp"
    ],
    system: "parfait"
});
dice3d.addDicePreset({
    type: "d12",
    atlas: "modules/dice-soup/textures/parfait/parfait_1.json",
    labels: [
	'd12_1.webp',
	'd12_2.webp',
	'd12_3.webp',
	'd12_4.webp',
	'd12_5.webp',
	'd12_6.webp',
	'd12_7.webp',
	'd12_8.webp',
	'd12_9.webp',
	'd12_10.webp',
	'd12_11.webp',
	'd12_12.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_1/d12_b_1.webp",
	"modules/dice-soup/textures/bump/font_1/d12_b_2.webp",
	"modules/dice-soup/textures/bump/font_1/d12_b_3.webp",
	"modules/dice-soup/textures/bump/font_1/d12_b_4.webp",
	"modules/dice-soup/textures/bump/font_1/d12_b_5.webp",
	"modules/dice-soup/textures/bump/font_1/d12_b_6.webp",
	"modules/dice-soup/textures/bump/font_1/d12_b_7.webp",
	"modules/dice-soup/textures/bump/font_1/d12_b_8.webp",
	"modules/dice-soup/textures/bump/font_1/d12_b_9.webp",
	"modules/dice-soup/textures/bump/font_1/d12_b_10.webp",
	"modules/dice-soup/textures/bump/font_1/d12_b_11.webp",
	"modules/dice-soup/textures/bump/font_1/d12_b_12.webp"
    ],
    system: "parfait"
});
dice3d.addDicePreset({
    type: "d10",
    atlas: "modules/dice-soup/textures/parfait/parfait_1.json",
    labels: [
	'd10_1.webp',
	'd10_2.webp',
	'd10_3.webp',
	'd10_4.webp',
	'd10_5.webp',
	'd10_6.webp',
	'd10_7.webp',
	'd10_8.webp',
	'd10_9.webp',
	'd10_10.webp' 
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_1/d10_b_1.webp",
	"modules/dice-soup/textures/bump/font_1/d10_b_2.webp",
	"modules/dice-soup/textures/bump/font_1/d10_b_3.webp",
	"modules/dice-soup/textures/bump/font_1/d10_b_4.webp",
	"modules/dice-soup/textures/bump/font_1/d10_b_5.webp",
	"modules/dice-soup/textures/bump/font_1/d10_b_6.webp",
	"modules/dice-soup/textures/bump/font_1/d10_b_7.webp",
	"modules/dice-soup/textures/bump/font_1/d10_b_8.webp",
	"modules/dice-soup/textures/bump/font_1/d10_b_9.webp",
	"modules/dice-soup/textures/bump/font_1/d10_b_10.webp"
    ],
    system: "parfait"
});
dice3d.addDicePreset({
    type: "d100",
    atlas: "modules/dice-soup/textures/parfait/parfait_1.json",
    labels: [
	'd100_10.webp',
	'd100_20.webp',
	'd100_30.webp',
	'd100_40.webp',
	'd100_50.webp',
	'd100_60.webp',
	'd100_70.webp',
	'd100_80.webp',
	'd100_90.webp',
	'd100_100.webp'    
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_1/d100_b_10.webp",
	"modules/dice-soup/textures/bump/font_1/d100_b_20.webp",
	"modules/dice-soup/textures/bump/font_1/d100_b_30.webp",
	"modules/dice-soup/textures/bump/font_1/d100_b_40.webp",
	"modules/dice-soup/textures/bump/font_1/d100_b_50.webp",
	"modules/dice-soup/textures/bump/font_1/d100_b_60.webp",
	"modules/dice-soup/textures/bump/font_1/d100_b_70.webp",
	"modules/dice-soup/textures/bump/font_1/d100_b_80.webp",
	"modules/dice-soup/textures/bump/font_1/d100_b_90.webp",
	"modules/dice-soup/textures/bump/font_1/d100_b_100.webp"
    ],
    system: "parfait"
});
dice3d.addDicePreset({
    type: "d8",
    atlas: "modules/dice-soup/textures/parfait/parfait_1.json",
    labels: [
	'd8_1.webp',
	'd8_2.webp',
	'd8_3.webp',
	'd8_4.webp',
	'd8_5.webp',
	'd8_6.webp',
	'd8_7.webp',
	'd8_8.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_1/d8_b_1.webp",
	"modules/dice-soup/textures/bump/font_1/d8_b_2.webp",
	"modules/dice-soup/textures/bump/font_1/d8_b_3.webp",
	"modules/dice-soup/textures/bump/font_1/d8_b_4.webp",
	"modules/dice-soup/textures/bump/font_1/d8_b_5.webp",
	"modules/dice-soup/textures/bump/font_1/d8_b_6.webp",
	"modules/dice-soup/textures/bump/font_1/d8_b_7.webp",
	"modules/dice-soup/textures/bump/font_1/d8_b_8.webp"
    ],
    system: "parfait"
});
dice3d.addDicePreset({
    type: "d6",
    atlas: "modules/dice-soup/textures/parfait/parfait_1.json",
    labels: [
	'd6_1.webp',
	'd6_2.webp',
	'd6_3.webp',
	'd6_4.webp',
	'd6_5.webp',
	'd6_6.webp' 
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_1/d6_b_1.webp",
	"modules/dice-soup/textures/bump/font_1/d6_b_2.webp",
	"modules/dice-soup/textures/bump/font_1/d6_b_3.webp",
	"modules/dice-soup/textures/bump/font_1/d6_b_4.webp",
	"modules/dice-soup/textures/bump/font_1/d6_b_5.webp",
	"modules/dice-soup/textures/bump/font_1/d6_b_6.webp"
    ],
    system: "parfait"
});
dice3d.addDicePreset({
    type: "df",
    atlas: "modules/dice-soup/textures/parfait/parfait_1.json",
    labels: [
	'df_m.webp',
	'df_0.webp',
	'df_p.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_1/df_b_m.webp",,
	"modules/dice-soup/textures/bump/font_1/df_b_p.webp"
    ],
    system: "parfait"
});
dice3d.addDicePreset({
    type: "d4",
    modelFile: "modules/dice-soup/textures/parfait/parfait_d4.glb",
    system: "parfait"
});
dice3d.addDicePreset({
    type: "d2",
    atlas: "modules/dice-soup/textures/parfait/parfait_1.json",
    labels: [
	'd2_1.webp',
	'd2_2.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_1/d2_b_1.webp",
	"modules/dice-soup/textures/bump/font_1/d2_b_2.webp"
    ],
    system: "parfait"
});
//-------------------- Rainfall --------------------
dice3d.addDicePreset({
    type: "d20",
    atlas: "modules/dice-soup/textures/rainfall/rainfall_2.json",
    labels: [
	'd20_1.webp',
	'd20_2.webp',
	'd20_3.webp',
	'd20_4.webp',
	'd20_5.webp',
	'd20_6.webp',
	'd20_7.webp',
	'd20_8.webp',
	'd20_9.webp',
	'd20_10.webp',
	'd20_11.webp',
	'd20_12.webp',
	'd20_13.webp',
	'd20_14.webp',
	'd20_15.webp',
	'd20_16.webp',
	'd20_17.webp',
	'd20_18.webp',
	'd20_19.webp',
	'd20_20.webp'
    ],
   bumpMaps: [
	'd20_b_1.webp',
	'd20_b_2.webp',
	'd20_b_3.webp',
	'd20_b_4.webp',
	'd20_b_5.webp',
	'd20_b_6.webp',
	'd20_b_7.webp',
	'd20_b_8.webp',
	'd20_b_9.webp',
	'd20_b_10.webp',
	'd20_b_11.webp',
	'd20_b_12.webp',
	'd20_b_13.webp',
	'd20_b_14.webp',
	'd20_b_15.webp',
	'd20_b_16.webp',
	'd20_b_17.webp',
	'd20_b_18.webp',
	'd20_b_19.webp',
	'd20_b_20.webp'
    ],
    colorset: 'black_custom',
    system: "rainfall"
});
dice3d.addDicePreset({
    type: "d12",
    atlas: "modules/dice-soup/textures/rainfall/rainfall_2.json",
    labels: [
	'd12_1.webp',
	'd12_2.webp',
	'd12_3.webp',
	'd12_4.webp',
	'd12_5.webp',
	'd12_6.webp',
	'd12_7.webp',
	'd12_8.webp',
	'd12_9.webp',
	'd12_10.webp',
	'd12_11.webp',
	'd12_12.webp'
    ],
   bumpMaps: [
	'd12_b_1.webp',
	'd12_b_2.webp',
	'd12_b_3.webp',
	'd12_b_4.webp',
	'd12_b_5.webp',
	'd12_b_6.webp',
	'd12_b_7.webp',
	'd12_b_8.webp',
	'd12_b_9.webp',
	'd12_b_10.webp',
	'd12_b_11.webp',
	'd12_b_12.webp'
    ],
    colorset: 'black_custom',
    system: "rainfall"
});
dice3d.addDicePreset({
    type: "d10",
    atlas: "modules/dice-soup/textures/rainfall/rainfall_1.json",
    labels: [
	'd10_1.webp',
	'd10_2.webp',
	'd10_3.webp',
	'd10_4.webp',
	'd10_5.webp',
	'd10_6.webp',
	'd10_7.webp',
	'd10_8.webp',
	'd10_9.webp',
	'd10_10.webp'
    ],
   bumpMaps: [
	'd10_b_1.webp',
	'd10_b_2.webp',
	'd10_b_3.webp',
	'd10_b_4.webp',
	'd10_b_5.webp',
	'd10_b_6.webp',
	'd10_b_7.webp',
	'd10_b_8.webp',
	'd10_b_9.webp',
	'd10_b_10.webp'
    ],
    colorset: 'black_custom',
    system: "rainfall"
});
dice3d.addDicePreset({
    type: "d100",
    atlas: "modules/dice-soup/textures/rainfall/rainfall_3.json",
    labels: [
	'd100_10.webp',
	'd100_20.webp',
	'd100_30.webp',
	'd100_40.webp',
	'd100_50.webp',
	'd100_60.webp',
	'd100_70.webp',
	'd100_80.webp',
	'd100_90.webp',
	'd100_100.webp'
    ],
   bumpMaps: [
	'd100_b_10.webp',
	'd100_b_20.webp',
	'd100_b_30.webp',
	'd100_b_40.webp',
	'd100_b_50.webp',
	'd100_b_60.webp',
	'd100_b_70.webp',
	'd100_b_80.webp',
	'd100_b_90.webp',
	'd100_b_100.webp'
    ],
    colorset: 'black_custom',
    system: "rainfall"
});
dice3d.addDicePreset({
    type: "d8",
    atlas: "modules/dice-soup/textures/rainfall/rainfall_1.json",
    labels: [
	'd8_1.webp',
	'd8_2.webp',
	'd8_3.webp',
	'd8_4.webp',
	'd8_5.webp',
	'd8_6.webp',
	'd8_7.webp',
	'd8_8.webp'
    ],
   bumpMaps: [
	'd8_b_1.webp',
	'd8_b_2.webp',
	'd8_b_3.webp',
	'd8_b_4.webp',
	'd8_b_5.webp',
	'd8_b_6.webp',
	'd8_b_7.webp',
	'd8_b_8.webp'
    ],
    colorset: 'black_custom',
    system: "rainfall"
});
dice3d.addDicePreset({
    type: "d6",
    atlas: "modules/dice-soup/textures/rainfall/rainfall_1.json",
    labels: [
	'd6_1.webp',
	'd6_2.webp',
	'd6_3.webp',
	'd6_4.webp',
	'd6_5.webp',
	'd6_6.webp'
    ],
   bumpMaps: [
	'd6_b_1.webp',
	'd6_b_2.webp',
	'd6_b_3.webp',
	'd6_b_4.webp',
	'd6_b_5.webp',
	'd6_b_6.webp'
    ],
    colorset: 'black_custom',
    system: "rainfall"
});
dice3d.addDicePreset({
    type: "df",
    atlas: "modules/dice-soup/textures/rainfall/rainfall_1.json",
    labels: [
	'df_m.webp',
	'df_0.webp',
	'df_p.webp'
    ],
   bumpMaps: [
	'df_b_m.webp',
	'df_b_0.webp',
	'df_b_p.webp'
    ],
    colorset: 'black_custom',
    system: "rainfall"
});
dice3d.addDicePreset({
    type: "d4",
    modelFile: "modules/dice-soup/textures/rainfall/rainfall_d4.glb",
    system: "rainfall"
});
dice3d.addDicePreset({
    type: "d2",
    atlas: "modules/dice-soup/textures/rainfall/rainfall_1.json",
    labels: [
	'd2_1.webp',
	'd2_2.webp'
    ],
   bumpMaps: [
	'd2_b_1.webp',
	'd2_b_2.webp'
    ],
    colorset: 'black_custom',
    system: "rainfall"
});
//-------------------- Sanguine --------------------
dice3d.addDicePreset({
    type: "d20",
    atlas: "modules/dice-soup/textures/sanguine/sanguine_2.json",
    labels: [
	'd20_1.webp',
	'd20_2.webp',
	'd20_3.webp',
	'd20_4.webp',
	'd20_5.webp',
	'd20_6.webp',
	'd20_7.webp',
	'd20_8.webp',
	'd20_9.webp',
	'd20_10.webp',
	'd20_11.webp',
	'd20_12.webp',
	'd20_13.webp',
	'd20_14.webp',
	'd20_15.webp',
	'd20_16.webp',
	'd20_17.webp',
	'd20_18.webp',
	'd20_19.webp',
	'd20_20.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d20_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_11.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_12.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_13.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_14.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_15.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_16.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_17.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_18.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_19.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_20.webp"
    ],
    colorset: 'black_custom',
    system: "sanguine"
});
dice3d.addDicePreset({
    type: "d12",
    atlas: "modules/dice-soup/textures/sanguine/sanguine_1.json",
    labels: [
	'd12_1.webp',
	'd12_2.webp',
	'd12_3.webp',
	'd12_4.webp',
	'd12_5.webp',
	'd12_6.webp',
	'd12_7.webp',
	'd12_8.webp',
	'd12_9.webp',
	'd12_10.webp',
	'd12_11.webp',
	'd12_12.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d12_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_11.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_12.webp"
    ],
    colorset: 'black_custom',
    system: "sanguine"
});
dice3d.addDicePreset({
    type: "d10",
    atlas: "modules/dice-soup/textures/sanguine/sanguine_1.json",
    labels: [
	'd10_1.webp',
	'd10_2.webp',
	'd10_3.webp',
	'd10_4.webp',
	'd10_5.webp',
	'd10_6.webp',
	'd10_7.webp',
	'd10_8.webp',
	'd10_9.webp',
	'd10_10.webp' 
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d10_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_10.webp"
    ],
    colorset: 'black_custom',
    system: "sanguine"
});
dice3d.addDicePreset({
    type: "d100",
    atlas: "modules/dice-soup/textures/sanguine/sanguine_1.json",
    labels: [
	'd100_10.webp',
	'd100_20.webp',
	'd100_30.webp',
	'd100_40.webp',
	'd100_50.webp',
	'd100_60.webp',
	'd100_70.webp',
	'd100_80.webp',
	'd100_90.webp',
	'd100_100.webp'    
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d100_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_20.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_30.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_40.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_50.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_60.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_70.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_80.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_90.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_100.webp"
    ],
    colorset: 'black_custom',
    system: "sanguine"
});
dice3d.addDicePreset({
    type: "d8",
    atlas: "modules/dice-soup/textures/sanguine/sanguine_1.json",
    labels: [
	'd8_1.webp',
	'd8_2.webp',
	'd8_3.webp',
	'd8_4.webp',
	'd8_5.webp',
	'd8_6.webp',
	'd8_7.webp',
	'd8_8.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d8_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_8.webp"
    ],
    colorset: 'black_custom',
    system: "sanguine"
});
dice3d.addDicePreset({
    type: "d6",
    atlas: "modules/dice-soup/textures/sanguine/sanguine_1.json",
    labels: [
	'd6_1.webp',
	'd6_2.webp',
	'd6_3.webp',
	'd6_4.webp',
	'd6_5.webp',
	'd6_6.webp' 
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d6_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_6.webp"
    ],
    colorset: 'black_custom',
    system: "sanguine"
});
dice3d.addDicePreset({
    type: "df",
    atlas: "modules/dice-soup/textures/sanguine/sanguine_1.json",
    labels: [
	'df_m.webp',
	'df_0.webp',
	'df_p.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/df_b_m.webp",,
	"modules/dice-soup/textures/bump/font_2/df_b_p.webp"
    ],
    colorset: 'black_custom',
    system: "sanguine"
});
dice3d.addDicePreset({
    type: "d4",
    modelFile: "modules/dice-soup/textures/sanguine/sanguine_d4.glb",
    system: "sanguine"
});
dice3d.addDicePreset({
    type: "d2",
    atlas: "modules/dice-soup/textures/sanguine/sanguine_1.json",
    labels: [
	'd2_1.webp',
	'd2_2.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d2_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d2_b_2.webp"
    ],
    colorset: 'black_custom',
    system: "sanguine"
});

//Source - Green
dice3d.addDicePreset({
    type: "d2",
    labels: [ '1', '2'],
    emissive: 0x27b092,
    colorset: 'source-green',
    system: "source-green"
});
dice3d.addDicePreset({
    type: "d4",
    labels: [ '1', '2', '3', '4'],
    emissive: 0x27b092,
    colorset: 'source-green',
    system: "source-green"
});
dice3d.addDicePreset({
    type: "d6",
    labels: [ '1', '2', '3', '4', '5', '6'],
    emissive: 0x27b092,
    colorset: 'source-green',
    system: "source-green"
});
dice3d.addDicePreset({
    type: "df",
    labels: [ '−', ' ', '+'],
    emissive: 0x27b092,
    colorset: 'source-green',
    system: "source-green"
});
dice3d.addDicePreset({
    type: "d8",
    labels: [ '1', '2', '3', '4', '5', '6', '7', '8'],
    emissive: 0x27b092,
    colorset: 'source-green',
    system: "source-green"
});
dice3d.addDicePreset({
    type: "d10",
    labels: [ '1', '2', '3', '4', '5', '6', '7', '8', '9', '10'],
    emissive: 0x27b092,
    colorset: 'source-green',
    system: "source-green"
});
dice3d.addDicePreset({
    type: "d100",
    labels: [ '10', '20', '30', '40', '50', '60', '70', '80', '90', '00'],
    emissive: 0x27b092,
    colorset: 'source-green',
    system: "source-green"
});
dice3d.addDicePreset({
    type: "d12",
    labels: [ '1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
    emissive: 0x27b092,
    colorset: 'source-green',
    system: "source-green"
});
dice3d.addDicePreset({
    type: "d20",
    labels: [ '1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20'],
    emissive: 0x27b092,
    colorset: 'source-green',
    system: "source-green"
});

//Source - Purple
dice3d.addDicePreset({
    type: "d2",
    labels: [ '1', '2'],
    emissive: 0x8c00ff,
    colorset: 'source-purple',
    system: "source-purple"
});
dice3d.addDicePreset({
    type: "d4",
    labels: [ '1', '2', '3', '4'],
    emissive: 0x8c00ff,
    colorset: 'source-purple',
    system: "source-purple"
});
dice3d.addDicePreset({
    type: "d6",
    labels: [ '1', '2', '3', '4', '5', '6'],
    emissive: 0x8c00ff,
    colorset: 'source-purple',
    system: "source-purple"
});
dice3d.addDicePreset({
    type: "df",
    labels: [ '−', ' ', '+'],
    emissive: 0x8c00ff,
    colorset: 'source-purple',
    system: "source-purple"
});
dice3d.addDicePreset({
    type: "d8",
    labels: [ '1', '2', '3', '4', '5', '6', '7', '8'],
    emissive: 0x8c00ff,
    colorset: 'source-purple',
    system: "source-purple"
});
dice3d.addDicePreset({
    type: "d10",
    labels: [ '1', '2', '3', '4', '5', '6', '7', '8', '9', '10'],
    emissive: 0x8c00ff,
    colorset: 'source-purple',
    system: "source-purple"
});
dice3d.addDicePreset({
    type: "d100",
    labels: [ '10', '20', '30', '40', '50', '60', '70', '80', '90', '00'],
    emissive: 0x8c00ff,
    colorset: 'source-purple',
    system: "source-purple"
});
dice3d.addDicePreset({
    type: "d12",
    labels: [ '1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
    emissive: 0x8c00ff,
    colorset: 'source-purple',
    system: "source-purple"
});
dice3d.addDicePreset({
    type: "d20",
    labels: [ '1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20'],
    emissive: 0x8c00ff,
    colorset: 'source-purple',
    system: "source-purple"
});

//Source - Red
dice3d.addDicePreset({
    type: "d2",
    labels: [ '1', '2'],
    emissive: 0xff0000,
    colorset: 'source-red',
    system: "source-red"
});
dice3d.addDicePreset({
    type: "d4",
    labels: [ '1', '2', '3', '4'],
    emissive: 0xff0000,
    colorset: 'source-red',
    system: "source-red"
});
dice3d.addDicePreset({
    type: "d6",
    labels: [ '1', '2', '3', '4', '5', '6'],
    emissive: 0xff0000,
    colorset: 'source-red',
    system: "source-red"
});
dice3d.addDicePreset({
    type: "df",
    labels: [ '−', ' ', '+'],
    emissive: 0xff0000,
    colorset: 'source-red',
    system: "source-red"
});
dice3d.addDicePreset({
    type: "d8",
    labels: [ '1', '2', '3', '4', '5', '6', '7', '8'],
    emissive: 0xff0000,
    colorset: 'source-red',
    system: "source-red"
});
dice3d.addDicePreset({
    type: "d10",
    labels: [ '1', '2', '3', '4', '5', '6', '7', '8', '9', '10'],
    emissive: 0xff0000,
    colorset: 'source-red',
    system: "source-red"
});
dice3d.addDicePreset({
    type: "d100",
    labels: [ '10', '20', '30', '40', '50', '60', '70', '80', '90', '00'],
    emissive: 0xff0000,
    colorset: 'source-red',
    system: "source-red"
});
dice3d.addDicePreset({
    type: "d12",
    labels: [ '1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12'],
    emissive: 0xff0000,
    colorset: 'source-red',
    system: "source-red"
});
dice3d.addDicePreset({
    type: "d20",
    labels: [ '1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20'],
    emissive: 0xff0000,
    colorset: 'source-red',
    system: "source-red"
});
//-------------------- Solar Embers --------------------
dice3d.addDicePreset({
    type: "d20",
    atlas: "modules/dice-soup/textures/solar/solar_embers_2.json",
    labels: [
	'd20_1.webp',
	'd20_2.webp',
	'd20_3.webp',
	'd20_4.webp',
	'd20_5.webp',
	'd20_6.webp',
	'd20_7.webp',
	'd20_8.webp',
	'd20_9.webp',
	'd20_10.webp',
	'd20_11.webp',
	'd20_12.webp',
	'd20_13.webp',
	'd20_14.webp',
	'd20_15.webp',
	'd20_16.webp',
	'd20_17.webp',
	'd20_18.webp',
	'd20_19.webp',
	'd20_20.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d20_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_11.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_12.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_13.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_14.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_15.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_16.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_17.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_18.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_19.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_20.webp"
    ],
    emissiveMaps: [
	'd20_1.webp',
	"modules/dice-soup/textures/bump/font_2/d20_b_2.webp",
	'd20_3.webp',
	'd20_4.webp',
	'd20_5.webp',
	'd20_6.webp',
	'd20_7.webp',
	"modules/dice-soup/textures/bump/font_2/d20_b_8.webp",
	'd20_9.webp',
	"modules/dice-soup/textures/bump/font_2/d20_b_10.webp",
	'd20_11.webp',
	"modules/dice-soup/textures/bump/font_2/d20_b_12.webp",
	'd20_13.webp',
	'd20_14.webp',
	'd20_15.webp',
	'd20_16.webp',
	'd20_17.webp',
	"modules/dice-soup/textures/bump/font_2/d20_b_18.webp",
	'd20_19.webp',
	"modules/dice-soup/textures/bump/font_2/d20_b_20.webp"
    ],
    emissive: 0xb84000,
    emissiveIntensity: 0.75,
    colorset: 'black_custom',
    system: "solar"
});
dice3d.addDicePreset({
    type: "d12",
    atlas: "modules/dice-soup/textures/solar/solar_embers_1.json",
    labels: [
	'd12_1.webp',
	'd12_2.webp',
	'd12_3.webp',
	'd12_4.webp',
	'd12_5.webp',
	'd12_6.webp',
	'd12_7.webp',
	'd12_8.webp',
	'd12_9.webp',
	'd12_10.webp',
	'd12_11.webp',
	'd12_12.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d12_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_11.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_12.webp"
    ],
    emissiveMaps: [
	"modules/dice-soup/textures/bump/font_2/d12_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_2.webp",
	'd12_3.webp',
	"modules/dice-soup/textures/bump/font_2/d12_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_6.webp",
	'd12_7.webp',
	"modules/dice-soup/textures/bump/font_2/d12_b_8.webp",
	'd12_9.webp',
	"modules/dice-soup/textures/bump/font_2/d12_b_10.webp",
	'd12_11.webp',
	'd12_12.webp'
    ],
    emissive: 0xb84000,
    emissiveIntensity: 0.75,
    colorset: 'black_custom',
    system: "solar"
});
dice3d.addDicePreset({
    type: "d10",
    atlas: "modules/dice-soup/textures/solar/solar_embers_1.json",
    labels: [
	'd10_1.webp',
	'd10_2.webp',
	'd10_3.webp',
	'd10_4.webp',
	'd10_5.webp',
	'd10_6.webp',
	'd10_7.webp',
	'd10_8.webp',
	'd10_9.webp',
	'd10_10.webp' 
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d10_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_10.webp"
    ],
    emissiveMaps: [
	"modules/dice-soup/textures/bump/font_2/d10_b_1.webp",
	'd10_2.webp',
	'd10_3.webp',
	'd10_4.webp',
	'd10_5.webp',
	"modules/dice-soup/textures/bump/font_2/d10_b_6.webp",
	'd10_7.webp',
	'd10_8.webp',
	'd10_9.webp',
	'd10_10.webp' 
    ],
    emissive: 0xb84000,
    emissiveIntensity: 0.75,
    colorset: 'black_custom',
    system: "solar"
});
dice3d.addDicePreset({
    type: "d100",
    atlas: "modules/dice-soup/textures/solar/solar_embers_1.json",
    labels: [
	'd100_10.webp',
	'd100_20.webp',
	'd100_30.webp',
	'd100_40.webp',
	'd100_50.webp',
	'd100_60.webp',
	'd100_70.webp',
	'd100_80.webp',
	'd100_90.webp',
	'd100_100.webp'    
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d100_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_20.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_30.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_40.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_50.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_60.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_70.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_80.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_90.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_100.webp"
    ],
    emissiveMaps: [
	"modules/dice-soup/textures/bump/font_2/d100_b_10.webp",
	'd100_20.webp',
	'd100_30.webp',
	'd100_40.webp',
	'd100_50.webp',
	"modules/dice-soup/textures/bump/font_2/d100_b_60.webp",
	'd100_70.webp',
	'd100_80.webp',
	'd100_90.webp',
	'd100_100.webp' 
    ],
    emissive: 0xb84000,
    emissiveIntensity: 0.75,
    colorset: 'black_custom',
    system: "solar"
});
dice3d.addDicePreset({
    type: "d8",
    atlas: "modules/dice-soup/textures/solar/solar_embers_1.json",
    labels: [
	'd8_1.webp',
	'd8_2.webp',
	'd8_3.webp',
	'd8_4.webp',
	'd8_5.webp',
	'd8_6.webp',
	'd8_7.webp',
	'd8_8.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d8_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_8.webp"
    ],
    emissiveMaps: [
	"modules/dice-soup/textures/bump/font_2/d8_b_1.webp",
	'd8_2.webp',
	"modules/dice-soup/textures/bump/font_2/d8_b_3.webp",
	'd8_4.webp',
	'd8_5.webp',
	'd8_6.webp',
	'd8_7.webp',
	'd8_8.webp'
    ],
    emissive: 0xb84000,
    emissiveIntensity: 0.75,
    colorset: 'black_custom',
    system: "solar"
});
dice3d.addDicePreset({
    type: "d6",
    atlas: "modules/dice-soup/textures/solar/solar_embers_1.json",
    labels: [
	'd6_1.webp',
	'd6_2.webp',
	'd6_3.webp',
	'd6_4.webp',
	'd6_5.webp',
	'd6_6.webp' 
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d6_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_6.webp"
    ],
    emissiveMaps: [
	"modules/dice-soup/textures/bump/font_2/d6_b_1.webp",
	'd6_2.webp',
	"modules/dice-soup/textures/bump/font_2/d6_b_3.webp",
	'd6_4.webp',
	'd6_5.webp',
	'd6_6.webp' 
    ],
    emissive: 0xb84000,
    emissiveIntensity: 0.75,
    colorset: 'black_custom',
    system: "solar"
});
dice3d.addDicePreset({
    type: "df",
    atlas: "modules/dice-soup/textures/solar/solar_embers_1.json",
    labels: [
	'df_m.webp',
	'df_0.webp',
	'df_p.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/df_b_m.webp",,
	"modules/dice-soup/textures/bump/font_2/df_b_p.webp"
    ],
    emissiveMaps: [
	'df_m.webp',
	'df_0.webp',
	'df_p.webp'
    ],
    emissive: 0xb84000,
    emissiveIntensity: 0.75,
    colorset: 'black_custom',
    system: "solar"
});
dice3d.addDicePreset({
    type: "d4",
    modelFile: "modules/dice-soup/textures/solar/solar_embers_d4.glb",
    colorset: 'black_custom',
    system: "solar"
});
dice3d.addDicePreset({
    type: "d2",
    atlas: "modules/dice-soup/textures/solar/solar_embers_1.json",
    labels: [
	'd2_1.webp',
	'd2_2.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d2_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d2_b_2.webp"
    ],
    emissiveMaps: [
	'd2_1.webp',
	'd2_2.webp'
    ],
    emissive: 0xb84000,
    emissiveIntensity: 0.75,
    colorset: 'black_custom',
    system: "solar"
});
//-------------------- Toxin --------------------
dice3d.addDicePreset({
    type: "d20",
    atlas: "modules/dice-soup/textures/toxin/toxin_2.json",
    labels: [
	'd20_1.webp',
	'd20_2.webp',
	'd20_3.webp',
	'd20_4.webp',
	'd20_5.webp',
	'd20_6.webp',
	'd20_7.webp',
	'd20_8.webp',
	'd20_9.webp',
	'd20_10.webp',
	'd20_11.webp',
	'd20_12.webp',
	'd20_13.webp',
	'd20_14.webp',
	'd20_15.webp',
	'd20_16.webp',
	'd20_17.webp',
	'd20_18.webp',
	'd20_19.webp',
	'd20_20.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d20_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_11.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_12.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_13.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_14.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_15.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_16.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_17.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_18.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_19.webp",
	"modules/dice-soup/textures/bump/font_2/d20_b_20.webp"
    ],
    colorset: 'black_custom',
    system: "toxin"
});
dice3d.addDicePreset({
    type: "d12",
    atlas: "modules/dice-soup/textures/toxin/toxin_1.json",
    labels: [
	'd12_1.webp',
	'd12_2.webp',
	'd12_3.webp',
	'd12_4.webp',
	'd12_5.webp',
	'd12_6.webp',
	'd12_7.webp',
	'd12_8.webp',
	'd12_9.webp',
	'd12_10.webp',
	'd12_11.webp',
	'd12_12.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d12_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_11.webp",
	"modules/dice-soup/textures/bump/font_2/d12_b_12.webp"
    ],
    colorset: 'black_custom',
    system: "toxin"
});
dice3d.addDicePreset({
    type: "d10",
    atlas: "modules/dice-soup/textures/toxin/toxin_1.json",
    labels: [
	'd10_1.webp',
	'd10_2.webp',
	'd10_3.webp',
	'd10_4.webp',
	'd10_5.webp',
	'd10_6.webp',
	'd10_7.webp',
	'd10_8.webp',
	'd10_9.webp',
	'd10_10.webp' 
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d10_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_8.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_9.webp",
	"modules/dice-soup/textures/bump/font_2/d10_b_10.webp"
    ],
    colorset: 'black_custom',
    system: "toxin"
});
dice3d.addDicePreset({
    type: "d100",
    atlas: "modules/dice-soup/textures/toxin/toxin_1.json",
    labels: [
	'd100_10.webp',
	'd100_20.webp',
	'd100_30.webp',
	'd100_40.webp',
	'd100_50.webp',
	'd100_60.webp',
	'd100_70.webp',
	'd100_80.webp',
	'd100_90.webp',
	'd100_100.webp'    
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d100_b_10.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_20.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_30.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_40.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_50.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_60.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_70.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_80.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_90.webp",
	"modules/dice-soup/textures/bump/font_2/d100_b_100.webp"
    ],
    colorset: 'black_custom',
    system: "toxin"
});
dice3d.addDicePreset({
    type: "d8",
    atlas: "modules/dice-soup/textures/toxin/toxin_1.json",
    labels: [
	'd8_1.webp',
	'd8_2.webp',
	'd8_3.webp',
	'd8_4.webp',
	'd8_5.webp',
	'd8_6.webp',
	'd8_7.webp',
	'd8_8.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d8_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_6.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_7.webp",
	"modules/dice-soup/textures/bump/font_2/d8_b_8.webp"
    ],
    colorset: 'black_custom',
    system: "toxin"
});
dice3d.addDicePreset({
    type: "d6",
    atlas: "modules/dice-soup/textures/toxin/toxin_1.json",
    labels: [
	'd6_1.webp',
	'd6_2.webp',
	'd6_3.webp',
	'd6_4.webp',
	'd6_5.webp',
	'd6_6.webp' 
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d6_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_2.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_3.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_4.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_5.webp",
	"modules/dice-soup/textures/bump/font_2/d6_b_6.webp"
    ],
    colorset: 'black_custom',
    system: "toxin"
});
dice3d.addDicePreset({
    type: "df",
    atlas: "modules/dice-soup/textures/toxin/toxin_1.json",
    labels: [
	'df_m.webp',
	'df_0.webp',
	'df_p.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/df_b_m.webp",,
	"modules/dice-soup/textures/bump/font_2/df_b_p.webp"
    ],
    colorset: 'black_custom',
    system: "toxin"
});
dice3d.addDicePreset({
    type: "d4",
    modelFile: "modules/dice-soup/textures/toxin/toxin_d4.glb",
    system: "toxin"
});
dice3d.addDicePreset({
    type: "d2",
    atlas: "modules/dice-soup/textures/toxin/toxin_1.json",
    labels: [
	'd2_1.webp',
	'd2_2.webp'
    ],
    bumpMaps: [
	"modules/dice-soup/textures/bump/font_2/d2_b_1.webp",
	"modules/dice-soup/textures/bump/font_2/d2_b_2.webp"
    ],
    colorset: 'black_custom',
    system: "toxin"
});
//-------------------- TEXTURES --------------------

	dice3d.addTexture("diamondback", {
	    name: "🔮 Diamondback",
	    composite: "multiply",
            atlas: "modules/dice-soup/textures/originals.json",
	    source: 'diamondback.webp',
	    bump: 'diamondback.bmp'
	});
	dice3d.addTexture("etched", {
	    name: "🔮 Etched",
	    composite: "multiply",
            atlas: "modules/dice-soup/textures/originals.json",
	    source: 'etched.webp',
	    bump: 'etched.bmp'
	});
	dice3d.addTexture("geo1", {
	    name: "🔮 Geometric",
	    composite: "multiply",
            atlas: "modules/dice-soup/textures/originals.json",
	    source: 'geometric_1.webp',
	    bump: 'geometric_1.bmp'
	});
	dice3d.addTexture("ice-cold", {
	    name: "🔮 Ice Cold",
            atlas: "modules/dice-soup/textures/originals.json",
	    composite: "multiply",
	    source: 'ice_cold.webp'
	});
	dice3d.addTexture("ice-cold-2-color", {
	    name: "🔮 Ice Cold (🖌️)",
	    composite: "multiply",
            atlas: "modules/dice-soup/textures/originals.json",
	    source: 'ice_cold_2_colorable.webp',
	    bump: 'ice_cold_2.bmp'
	});
	dice3d.addTexture("leaf-imprints", {
	    name: "🔮 Leaf Imprints",
	    composite: "multiply",
            atlas: "modules/dice-soup/textures/originals.json",
	    source: 'leafed.webp',
	    bump: 'leafed.bmp'
	});
	dice3d.addTexture("liquid-lava", {
	    name: "🔮 Liquid Lava",
	    composite: "copy",
            atlas: "modules/dice-soup/textures/originals.json",
	    source: 'liquid_lava.webp'
	});
	dice3d.addTexture("liquid-lava-colorable", {
	    name: "🔮 Liquid Lava (🖌️)",
	    composite: "multiply",
            atlas: "modules/dice-soup/textures/originals.json",
	    source: 'liquid_lava_colorable.webp'
	});
	dice3d.addTexture("liquid-red", {
	    name: "🔮 Liquid Red",
	    composite: "copy",
            atlas: "modules/dice-soup/textures/originals.json",
	    source: 'liquid_red.webp'
	});
	dice3d.addTexture("liquid-red-colorable", {
	    name: "🔮 Liquid Red (🖌️)",
	    composite: "multiply",
            atlas: "modules/dice-soup/textures/originals.json",
	    source: 'liquid_red_colorable.webp'
	});
	dice3d.addTexture("liquid-water", {
	    name: "🔮 Liquid Water",
	    composite: "copy",
            atlas: "modules/dice-soup/textures/originals.json",
	    source: 'liquid_water.webp'
	});
	dice3d.addTexture("origami", {
	    name: "🔮 Origami",
	    composite: "multiply",
            atlas: "modules/dice-soup/textures/originals.json",
	    source: 'origami.webp',
	    bump: 'origami.bmp'
	});
	dice3d.addTexture("ornate1", {
	    name: "🔮 Ornate #1",
	    composite: "multiply",
            atlas: "modules/dice-soup/textures/originals.json",
	    source: 'ornate_1.webp',
	    bump: 'ornate_1.bmp'
	});
	dice3d.addTexture("ornate2", {
	    name: "🔮 Ornate #2",
	    composite: "multiply",
            atlas: "modules/dice-soup/textures/originals.json",
	    source: 'ornate_3.webp',
	    bump: 'ornate_3.bmp'
	});
	dice3d.addTexture("royalty", {
	    name: "🔮 Royalty",
	    composite: "multiply",
            atlas: "modules/dice-soup/textures/originals.json",
	    source: 'royalty_2.webp',
	    bump: 'royalty_2.bmp'
	});
	dice3d.addTexture("source-green", {
	    name: "🔮 Source - Green",
	    composite: "copy",
            atlas: "modules/dice-soup/textures/originals.json",
	    source: 'source_green.webp',
	    bump: 'source.bmp'
	});
	dice3d.addTexture("source-purple", {
	    name: "🔮 Source - Purple",
	    composite: "copy",
            atlas: "modules/dice-soup/textures/originals.json",
	    source: 'source_purple.webp',
	    bump: 'source.bmp'
	});
	dice3d.addTexture("source-red", {
	    name: "🔮 Source - Red",
	    composite: "copy",
            atlas: "modules/dice-soup/textures/originals.json",
	    source: 'source_red.webp',
	    bump: 'source.bmp'
	});
	dice3d.addTexture("spiral", {
	    name: "🔮 Spiraling",
	    composite: "multiply",
            atlas: "modules/dice-soup/textures/originals.json",
	    source: 'spiraling.webp',
	    bump: 'spiraling.bmp'
	});
	dice3d.addTexture("striped", {
	    name: "🔮 Striped",
	    composite: "multiply",
            atlas: "modules/dice-soup/textures/originals.json",
	    source: 'striped.webp',
	    bump: 'striped.bmp'
	});
	dice3d.addTexture("succulent", {
	    name: "🔮 Succulent",
	    composite: "multiply",
            atlas: "modules/dice-soup/textures/originals.json",
	    source: 'succulent.webp',
	    bump: 'succulent.bmp'
	});
	dice3d.addTexture("waves", {
	    name: "🔮 Waves",
	    composite: "multiply",
            atlas: "modules/dice-soup/textures/originals.json",
	    source: 'waves.webp',
	    bump: 'waves.bmp'
	})

//-------------------- COLORSETS --------------------

	.then(() => {
//Arctic
	dice3d.addColorset({
	     name: 'arctic',
	     description: "🔮 Arctic",
	     category: "Dice Soup",
	     edge: '#75a8f5',	
	     visibility: 'hidden'
	});
//Black Outline
	dice3d.addColorset({
	     name: 'black_custom',
	     description: "🔮 Black Custom",
	     category: "Dice Soup",
	     edge: '#000000',	
	     visibility: 'hidden'
	});
//Dawn
	dice3d.addColorset({
	     name: 'dawn',
	     description: "🔮 Dawn",
	     category: "Dice Soup",
	     edge: '#e3d79c',	
	     visibility: 'hidden'
	});
//Lava
	dice3d.addColorset({
	     name: 'lava',
	     description: "🔮 Lava",
	     category: "Dice Soup",
	     edge: '#383838',	
	     visibility: 'hidden'
	});
//Ornates
	dice3d.addColorset({
            name: 'ornates',
            description: "🔮 Ornates",
            category: "Dice Soup",
	    foreground: 'white',
	    background: ['#a01c35','#1c61a0','#1c8aa0','#a02a1c','#610e05','#54355a','#b083b9','#8c83b9','#83b9a9','#9eb983','#0e3567','#0e6758'],
	    outline: 'white',
	    edge: ['#a01c35','#1c61a0','#1c8aa0','#a02a1c','#610e05','#54355a','#b083b9','#8c83b9','#83b9a9','#9eb983','#0e3567','#0e6758'],	
            texture: ['ornate1','ornate2'],
	    material: 'iridescent'
	});
//Source
	dice3d.addColorset({
            name: 'source-green',
            description: "🔮 Green Source",
            category: "Dice Soup",
	    foreground: '#000000',
	    outline: '#27b092',		
            texture: 'source-green',
            material: 'chrome',
            font: 'Roboto Condensed'
	});
	dice3d.addColorset({
            name: 'source-purple',
            description: "🔮 Purple Source",
            category: "Dice Soup",
	    foreground: '#000000',
	    outline: '#94d0f5',		
            texture: 'source-purple',
            material: 'chrome',
            font: 'Roboto Condensed'
	});
	dice3d.addColorset({
            name: 'source-red',
            description: "🔮 Red Source",
            category: "Dice Soup",
	    foreground: '#000000',
	    outline: '#ff0000',	
            texture: 'source-red',
            material: 'chrome',
            font: 'Roboto Condensed'
	});
 });
});