# Modèles de Données du Système Myriad

Ce document présente les modèles de données utilisés dans le système Myriad pour Foundry VTT, comprenant les modèles d'Acteurs (personnages et PNJ) et d'Objets (objets, compétences, sorts, etc.).

## Structure Générale

Le système est construit sur une hiérarchie de modèles de données :

```
MyriadSystemDataModel (base-model.mjs)
├── MyriadSystemActorBase (base-actor.mjs)
│   ├── MyriadSystemCharacter (actor-character.mjs)
│   └── MyriadSystemNPC (actor-npc.mjs)
└── MyriadSystemItemBase (base-item.mjs)
    ├── MyriadSystemFeature (item-feature.mjs)
    ├── MyriadSystemItem (item-item.mjs)
    ├── MyriadSystemSpell (item-spell.mjs)
    ├── MyriadSystemPath (item-path.mjs) [renommé de item-voie.mjs]
    ├── MyriadSystemArt (item-art.mjs) [à implémenter]
    └── MyriadSystemDomain (item-domain.mjs) [à implémenter]
```

## Modèles d'Acteurs

### MyriadSystemActorBase

Classe de base pour tous les acteurs du système Myriad.

**Propriétés** :

- `health` : Points de vie (valeur actuelle et maximum)
- `power` : Points de pouvoir (valeur actuelle et maximum)
- `biography` : Biographie du personnage
- `supernaturalTiers` : Paliers surhumains (permettant de dépasser les limites normales)
  - `puissance` : Palier surhumain en puissance (0 = normal, 1+ = surhumain)
  - `coordination` : Palier surhumain en coordination
  - `ingeniosite` : Palier surhumain en ingéniosité
  - `perspicacite` : Palier surhumain en perspicacité

### MyriadSystemCharacter

Modèle pour les personnages joueurs. Les personnages commencent avec 200 points à répartir dans les caractéristiques (min 40, max 60 par caractéristique) et 20 XP.

**Propriétés spécifiques** :

- `characteristics` : Caractéristiques du personnage
  - `puissance` : Force physique
    - `value` : Valeur actuelle
    - `max` : Valeur maximale (100 + paliers surhumains × 20)
  - `coordination` : Agilité et précision (même structure)
  - `ingeniosite` : Intelligence et créativité (même structure)
  - `perspicacite` : Perception et intuition (même structure)
  - Les bonus et malus sont gérés via le système d'effets plutôt qu'en sous-valeurs
- `xp` : Points d'expérience
  - `value` : XP dépensés
  - `earned` : XP gagnés au total (20 XP initiaux à la création)
  - `unspent` : XP non dépensés (calculé)
  - `tempPool` : Réserve temporaire d'XP (lors de réallocation de points)
- `inventory` : Inventaire du personnage
  - `grid` : Structure de la grille d'inventaire
    - `width` : Largeur de la grille (défaut: 6)
    - `height` : Hauteur de la grille (défaut: 6)
    - `additionalCases` : Cases supplémentaires (Puissance/5)
  - `equipped` : Objets équipés (hors grille)
- `magicPoints` : Points de magie globaux du personnage
- `editMode` : Indicateurs pour le mode édition
  - `active` : Mode édition actif (oui/non)
  - `changes` : Journal des modifications
  - `xpWarning` : Avertissement en cas de dette d'XP

**Fonctions** :

- `prepareDerivedData()` : Calcule les valeurs dérivées comme les PV max basés sur la Puissance
- `getRollData()` : Prépare les données pour les jets de dés
- `calculateCharacteristicCost(charName, newValue)` : Calcule le coût en XP selon les seuils
  - 2 XP par point jusqu'à (palier max - 40)
  - 3 XP par point jusqu'à (palier max - 20)
  - 4 XP par point au-delà
- `reallocateCharacteristicPoints(fromChar, toChar, amount)` : Redistribue les points entre caractéristiques
- `calculateMagicPoints()` : Calcule les points de magie basés sur les arts et caractéristiques (2 × dizaines de la caractéristique)
- `applyTemporaryDamage(characteristic, amount)` : Applique des dégâts temporaires via le système d'effets

### MyriadSystemNPC

Modèle pour les PNJ (Personnages Non-Joueurs).

**Propriétés spécifiques** :

- `cr` : Indice de difficulté du PNJ
- `xp` : Points d'expérience accordés
- `isHostile` : Indique si le PNJ est hostile par défaut
- `racialFeatures` : Caractéristiques raciales spéciales

## Modèles d'Objets

### MyriadSystemItemBase

Classe de base pour tous les objets du système Myriad.

**Propriétés** :

- `description` : Description de l'objet
- `tags` : Tags pour catégoriser l'objet (incluant les propriétés comme "Utilisable", "Équipable", "Magique", etc.)
- `grade` : Niveau de l'objet/compétence (I à V) représenté par des chiffres romains

### MyriadSystemFeature

Modèle pour les capacités et aptitudes.

**Propriétés spécifiques** :

- `isPassive` : Indique si c'est une compétence passive
- `acquisition` : Informations sur l'acquisition
  - `prerequisites` : Prérequis pour obtenir la compétence
  - `xpCost` : Coût en points d'expérience (1 point × niveau du grade)
- `bonusType` : Type de bonus accordé (caractéristique, défense, etc.)
- `bonusValue` : Valeur du bonus accordé
- `uses` : Utilisation de la compétence
  - `value` : Utilisations actuelles
  - `max` : Utilisations maximales
  - `per` : Période de récupération (repos, jour, semaine, etc.)

### MyriadSystemItem

Modèle pour les objets physiques.

**Propriétés spécifiques** :

- `quantity` : Quantité d'objets
- `weight` : Poids de l'objet
- `dimensionCases` : Nombre de cases occupées dans la grille d'inventaire
- `shape` : Format de l'objet dans la grille ("1x1", "1x2", "2x2", etc.)
- `encumbranceType` : Type d'encombrement (Léger, Normal, Encombrant, Très encombrant)
- `equippedSlot` : Emplacement où l'objet est équipé (null si dans l'inventaire)
- `properties` : Propriétés spéciales (via tags)
  - "Utilisable" : Peut être utilisé (ex: potion)
  - "Équipable" : Peut être équipé
  - "Magique" : Contient des effets magiques
  - "Consommable" : Disparaît après usage
  - "Jetable" : Peut être utilisé comme arme improvisée

### MyriadSystemSpell

Modèle pour les sorts.

**Propriétés spécifiques** :

- `magicPointCost` : Coût du sort en points de magie (égal au grade du sort)
- `associatedArt` : Art magique associé au sort
- `associatedDomain` : Domaine magique associé au sort
- `castingTime` : Temps d'incantation
- `duration` : Durée de l'effet
- `range` : Portée du sort
- `area` : Zone d'effet
- `criticalSuccess` : Effet supplémentaire en cas de réussite critique
- `criticalFailure` : Conséquence en cas d'échec critique
- `isCustom` : Indique s'il s'agit d'un sort personnalisé créé par le joueur

### MyriadSystemPath

Modèle pour les voies (chemins de progression).

**Propriétés spécifiques** :

- `xpCost` : Coût en points d'expérience (15 XP par défaut)
- `components` : Composants de la voie
  - `features` : Capacités associées
  - `arts` : Arts associés
  - `domains` : Domaines associés
  - `items` : Objets associés
- `bonuses` : Bonus accordés par la voie
- `maluses` : Malus imposés par la voie
- `changeCost` : Coût pour changer de voie (10 XP par défaut)

## Nouveaux Modèles à Implémenter

### MyriadSystemArt

Modèle pour les arts magiques.

**Propriétés spécifiques** :

- `linkedCharacteristic` : Caractéristique liée à cet art magique (puissance, coordination, etc.)
- `benefits` : Avantages conférés par l'art
- `constraints` : Contraintes imposées par l'art
- `description` : Description détaillée de l'art

### MyriadSystemDomain

Modèle pour les domaines magiques.

**Propriétés spécifiques** :

- `type` : Type de domaine (élément, corps, immatériel, etc.)
- `effects` : Effets particuliers liés au domaine
- `description` : Description détaillée du domaine

## Types d'Objets Définis (template.json)

D'après le fichier template.json, le système définit les types d'objets suivants :

- `item` : Objets physiques
- `feature` : Capacités et aptitudes
- `spell` : Sorts
- `domain` : Domaines magiques
- `art` : Arts magiques
- `path` : Voie de progression

## Modèles Manquants ou Incomplets

Voici les modèles qui semblent manquer ou être incomplets dans l'implémentation actuelle :

1. **Modèles non implémentés** :
   - `item-domain.mjs` : Modèle pour les domaines magiques
   - `item-art.mjs` : Modèle pour les arts magiques

2. **Incohérences** :
   - Le nom du fichier `item-voie.mjs` devrait être renommé en `item-path.mjs` pour suivre la convention de nommage en anglais
   - Le modèle `MyriadSystemItemVoie` devrait être renommé en `MyriadSystemPath` pour maintenir la cohérence

## Système d'Effets

Le système Myriad utilise le système d'effets natif de Foundry VTT pour gérer tous les bonus, malus et modifications temporaires sur les caractéristiques et autres valeurs. Les effets peuvent être:

- **Temporaires** : Avec durée limitée
- **Permanents** : Sans durée spécifique
- **Conditionnels** : Activés dans certaines conditions
- **Liés à des objets** : Appliqués quand un objet est équipé
- **Liés à des compétences** : Appliqués quand une compétence est utilisée
- **Liés à des sorts** : Appliqués quand un sort est lancé

## Système de Jets de Dés

Le système Myriad utilise des jets de dés d100 avec les règles suivantes :

- **Réussite** : Résultat ≤ valeur de la caractéristique
- **Échec** : Résultat > valeur de la caractéristique
- **Réussite critique**:
  - Résultat = 1 (automatique)
  - Double réussi (11, 22, 33, 44, 55) et ≤ valeur de la caractéristique
- **Échec critique**:
  - Résultat = 100 (automatique)
  - Double raté (66, 77, 88, 99) et > valeur de la caractéristique
- **Marge de réussite/échec** : Différence entre la caractéristique et le résultat du jet (doit etre affichée sur le message dans le chat)

### Interface de Jet Contextuel

Pour tous les jets, une interface contextuelle doit permettre :

- Sélection des compétences applicables pour des bonus
- Option "Jet magique" si la caractéristique est liée à un art
- Option d'utiliser un point de magie (évite dégâts temporaires)
- Checkbox "Est-ce une attaque?" pour règles spécifiques

## Suggestions d'Amélioration

1. **Homogénéiser les noms de champs** entre les modèles JavaScript et le template.json
2. **Créer les modèles manquants** pour les types d'objets définis (MyriadSystemArt et MyriadSystemDomain)
3. **Uniformiser les noms en anglais** pour maintenir une cohérence (renommer `voie` en `path`, etc.)
4. **S'assurer que tous les types d'objets ont un champ `grade`** plutôt que level ou d'autres variantes
5. **Documenter les champs spéciaux** comme les tags et les propriétés
6. **Ajouter des validations** pour s'assurer que les données entrées respectent le format attendu
7. **Implémenter le système de jets contextuel** pour gérer toutes les règles spécifiques
8. **Développer l'interface de grille d'inventaire** avec le système de cases
9. **Ajouter un mode édition** pour la modification des caractéristiques avec calcul des coûts en XP
