/**
 * Modèle de données pour les voies (paths) dans le système Myriad.
 * @extends {MyriadSystemItemBase}
 */
import MyriadSystemItemBase from "./base-item.mjs";

export default class MyriadSystemPath extends MyriadSystemItemBase {
  /** @override */
  static defineSchema() {
    const fields = foundry.data.fields;
    const requiredInteger = { required: true, nullable: false, integer: true };
    const baseSchema = super.defineSchema();

    // Add path-specific fields (grade is defined in base item)
    const pathSchema = {
      xpCost: new fields.NumberField({ ...requiredInteger, initial: 15, min: 0 }),
      components: new fields.SchemaField({
        features: new fields.ArrayField(new fields.ObjectField()),
        arts: new fields.ArrayField(new fields.ObjectField()),
        domains: new fields.ArrayField(new fields.ObjectField()),
        items: new fields.ArrayField(new fields.ObjectField())
      })
      // Bonuses/maluses and changeCost intentionally removed per design
    };

    return foundry.utils.mergeObject(baseSchema, pathSchema);
  }
}
