export const MYRIAD_SYSTEM = {};

/**
 * The set of Characteristics used within the system.
 * @type {Object}
 */
MYRIAD_SYSTEM.characteristics = {
  puissance: "MYRIAD_SYSTEM.Characteristic.Puissance",
  coordination: "MYRIAD_SYSTEM.Characteristic.Coordination",
  ingeniosite: "MYRIAD_SYSTEM.Characteristic.Ingeniosite",
  perspicacite: "MYRIAD_SYSTEM.Characteristic.Perspicacite"
};

/**
 * The set of Magic Domains available in the system
 * @type {Object}
 */
MYRIAD_SYSTEM.magicDomains = {
  elements: "MYRIAD_SYSTEM.MagicDomain.Elements",
  corps: "MYRIAD_SYSTEM.MagicDomain.Corps",
  immateriel: "MYRIAD_SYSTEM.MagicDomain.Immateriel"
};

/**
 * Item properties
 * @type {Object}
 */
MYRIAD_SYSTEM.itemProperties = {
  utilisable: "MYRIAD_SYSTEM.ItemProperty.Utilisable",
  equipable: "MYRIAD_SYSTEM.ItemProperty.Equipable",
  magique: "MYRIAD_SYSTEM.ItemProperty.Magique",
  consommable: "MYRIAD_SYSTEM.ItemProperty.Consommable",
  jetable: "MYRIAD_SYSTEM.ItemProperty.Jetable"
};

/**
 * Item types configuration
 * @type {Object}
 */
MYRIAD_SYSTEM.itemTypes = {
  item: "MYRIAD_SYSTEM.ItemType.item",
  feature: "MYRIAD_SYSTEM.ItemType.feature",
  spell: "MYRIAD_SYSTEM.ItemType.spell",
  path: "MYRIAD_SYSTEM.ItemType.path",
  art: "MYRIAD_SYSTEM.ItemType.art",
  domain: "MYRIAD_SYSTEM.ItemType.domain"
};
