<h1 align="center">Call of Cthulhu 7th Edition for Foundry VTT</h1>
<p align="center">
  <img src="https://img.shields.io/github/repo-size/Miskatonic-Investigative-Society/CoC7-FoundryVTT.svg">
  <a href="https://github.com/Miskatonic-Investigative-Society/CoC7-FoundryVTT/commits/develop">
    <img src="https://img.shields.io/github/last-commit/Miskatonic-Investigative-Society/CoC7-FoundryVTT.svg">
  </a>
  <a href="https://github.com/Miskatonic-Investigative-Society/CoC7-FoundryVTT/issues">
    <img src="https://img.shields.io/github/issues/Miskatonic-Investigative-Society/CoC7-FoundryVTT.svg">
  </a>
  <img src="https://img.shields.io/github/license/Miskatonic-Investigative-Society/CoC7-FoundryVTT.svg">
  <img src="https://img.shields.io/github/downloads/Miskatonic-Investigative-Society/CoC7-FoundryVTT/latest/total">
  <img src="https://img.shields.io/github/downloads/Miskatonic-Investigative-Society/CoC7-FoundryVTT/total">
</p>
<p align="center">
  <a href="#usage">Usage</a>&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;
  <a href="#contributing">Contributing</a>&nbsp;&nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;
  <a href="#licenses">Licenses</a>
</p>

## Overview.

An implementation of the Call of Cthulhu 7th Edition game system for [Foundry Virtual Tabletop](http://foundryvtt.com). This provides sheets and system in addition to some compendiums as examples.

If you have any suggestions or feedback, please visit us on Discord in the `#chaosium` channel on the [Foundry Discord Server](discord.gg/foundryvtt), or see: [CONTRIBUTING](https://github.com/Miskatonic-Investigative-Society/CoC7-FoundryVTT/blob/develop/.github/CONTRIBUTING.md)

For the list of changes, see: [CHANGELOG](https://github.com/Miskatonic-Investigative-Society/CoC7-FoundryVTT/blob/develop/.github/CHANGELOG.md).

### Disclaimer.

This project does not include any materials from the official books and you will have to enter manually the weapons, skills, items, etc… to be able to play. We have just provided some basics skills that you can use as example.

## Usage.

Install in Foundry VTT from the Game Systems tab, using the following manifest:
`https://github.com/Miskatonic-Investigative-Society/CoC7-FoundryVTT/releases/latest/download/system.json`

You can also search for "Call of Cthulhu 7th edition" on the package finder.

- Compendium "Examples" contains a 1920's Character Sheet, you just need to import it to start a new Character. It contains also a NPC and a Creature as examples.
- Compendium "Skills" contains a set of basic Skills that you can use for your Characters.
- Compendium "Weapons" contains a single test Weapon.
- Compendium "Roll Requests" contains numerous links for all your needs.

## Contributing.

Thank you for being interested in making this system better. We encourage everyone to help improve this project with new features, bug fixes, or performance improvements. Please take a little bit of your time to read our guide to make this process faster and easier.

To understand how to submit an issue, commit and create pull requests, check our [Contribution Guidelines](https://github.com/Miskatonic-Investigative-Society/CoC7-FoundryVTT/blob/develop/.github/CONTRIBUTING.md). We always expect you to follow our [Code of Conduct](https://github.com/Miskatonic-Investigative-Society/CoC7-FoundryVTT/blob/develop/.github/CODE_OF_CONDUCT.md).

This system is made possible thanks to all of its contributors!

<a href="https://github.com/Miskatonic-Investigative-Society/CoC7-FoundryVTT/graphs/contributors">
  <img src="https://contrib.rocks/image?repo=Miskatonic-Investigative-Society/CoC7-FoundryVTT" />
</a>

## Licenses.

All the code on this repository is licensed under the [GNU General Public License v3.0](https://github.com/Miskatonic-Investigative-Society/CoC7-FoundryVTT/blob/develop/LICENSE).

Foundry VTT support is covered by [Limited License Agreement for Module Development](https://foundryvtt.com/article/license/).

This project uses some assets from Game Icons, thanks to its [authors](https://game-icons.net/about.html#authors).

This project uses [socketlib](https://github.com/manuelVo/foundryvtt-socketlib) by Manuel Vögele which is licensed under [MIT](lib/socketlib/LICENSE).

This system uses trademarks and/or copyrights owned by Chaosium Inc/Moon Design Publications LLC, which are used under [Chaosium Inc's Fan Material Policy](https://www.chaosium.com/fan-material-policy/). We are expressly prohibited from charging you to use or access this content. This system is not published, endorsed, or specifically approved by Chaosium Inc. For more information about Chaosium Inc's products, please visit www.chaosium.com.

> Permission is given for users to make derivative use of the work on the Foundry VTT platform. No rights for any commercial use are granted. No part of this work may be reproduced or distributed for use outside of the Foundry VTT platform. All rights are reserved with Chaosium Inc.
>
> Call of Cthulhu (tm) Chaosium, Inc. Used with permission. All rights reserved.
>
> The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
>
> THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
