(()=>{"use strict";void 0===foundry.dice&&(foundry.dice={terms:{Die,NumericTerm,ParentheticalTerm,RollTerm}}),void 0===foundry.applications&&(foundry.applications={}),void 0===foundry.appv1&&(foundry.appv1={sheets:{ActorSheet,ItemSheet}});const ECC_CLASS="enhanced-chat-card",PERMISSION_TYPE_GM="gm",PERMISSION_TYPE_NOT_GM="!gm",PERMISSION_TYPE_SPEAKER="speaker",PERMISSION_TYPE_USER="user",PERMISSION_TYPE_BLACKLIST="blacklist",STATE_ON="switched-on",STATE_OFF="switched-off";async function updateMessage(messageId,newContent){const chatMessage=game.messages.get(messageId);await chatMessage.update({content:newContent})}async function GMUpdate(data,options,cardClassName,messageId=void 0){const card=await EnhancedChatCard.fromData(data,options,cardClassName,messageId);return await card.GMUpdate(),card.toObject()}async function advise(){}class EnhancedChatCardLib{constructor(){this.types=new Map,this.socket=null}static injectCSS(){let style=$("head").find("style");style?.length||($("head").append($('<style  type="text/css"></style>')),style=$("head").find("style")),style.append(".ecc-restricted {color: red}\n    .ecc-restricted:hover {cursor: not-allowed}")}static set socket(x){game.enhancedChatCardsLib||(game.enhancedChatCardsLib=new EnhancedChatCardLib),game.enhancedChatCardsLib.socket=x}static get socket(){if(game.enhancedChatCardsLib){if(game.enhancedChatCardsLib.socket)return game.enhancedChatCardsLib.socket;ui.notifications.error("ECC no socket")}else ui.notifications.error("ECC not Initialized")}static get types(){return game.enhancedChatCardsLib||(game.enhancedChatCardsLib=new EnhancedChatCardLib),game.enhancedChatCardsLib.types}static register(cardConstructors){cardConstructors.forEach((cardConstructor=>{EnhancedChatCardLib.types.get(cardConstructor.name)||EnhancedChatCardLib.types.set(cardConstructor.name,cardConstructor)}))}}function setByPath(obj,path,value){const parts=path.split(".");let o=obj;if(parts.length>1)for(let i=0;i<parts.length-1;i++)o[parts[i]]||(o[parts[i]]={}),o=o[parts[i]];o[parts[parts.length-1]]=value}function getByPath(obj,path){const parts=path.split(".");let o=obj;if(parts.length>1)for(let i=0;i<parts.length-1;i++){if(!o[parts[i]])return;o=o[parts[i]]}return o[parts[parts.length-1]]}class EnhancedChatCard{constructor(data={},options={}){this.data=data,this.data.flags||(this.data.flags={}),this._options=options}async initialize(){}get options(){return foundry.utils.mergeObject(this.constructor.defaultOptions,this._options)}set options(x){this._options=x}get template(){return this.options.template}get cssClasses(){return this.options.classes?.join(" ")}get speaker(){return this.options.ooc?game.user:this.options.speaker&&ChatMessage.getSpeakerActor(this.options.speaker)?ChatMessage.getSpeakerActor(this.options.speaker):game.user}async getData(){return{card:this,flags:this.flags,data:this.toObject(),options:this.options,css:this.cssClasses,user:game.user,speaker:this.speaker}}toObject(){if(!this.data)return;const data={};for(const k of Object.keys(this.data)){const v=this.data[k];data[k]=v instanceof Object?v.toObject?v.toObject():foundry.utils.deepClone(v):v}return data}async toMessage(optionnalChatData={}){await this.initialize();const data=await this.getData(),html=await renderTemplate(this.template,data),htmlCardElement=$(html)[0];this.options.attachObject&&(htmlCardElement.dataset.object=escape(this.objectDataString)),htmlCardElement.dataset.eccClass=this.constructor.name,htmlCardElement.classList.add(...this.options.classes);const speaker=this.options.speaker&&!this.options.ooc?ChatMessage.getSpeaker(this.options.speaker):{},chatData=foundry.utils.mergeObject({user:game.user.id,speaker,flavor:game.i18n.localize(this.options.title),content:htmlCardElement.outerHTML},optionnalChatData);["gmroll","blindroll"].includes(this.rollMode)&&(chatData.whisper=ChatMessage.getWhisperRecipients("GM")),"selfroll"===this.rollMode&&(chatData.whisper=[game.user.id]),"blindroll"===this.rollMode&&(chatData.blind=!0),ChatMessage.create(chatData).then((msg=>msg))}async updateChatCard({attachObject=!0}={}){if(this.options.compute&&await this.localCompute(),this.options.GMUpdate&&await this.ExecuteGMUpdate(),this.messageId){const data=await this.getData(),html=await renderTemplate(this.template,data),htmlCardElement=$.parseHTML(html)[0];attachObject&&!this.data.EEC_ACTION?.detachData&&(htmlCardElement.dataset.object=escape(this.objectDataString)),htmlCardElement.dataset.eccClass=this.constructor.name,htmlCardElement.classList.add(...this.options.classes),game.enhancedChatCardsLib.socket.executeAsGM("updateMessage",this.messageId,htmlCardElement.outerHTML)}else this.toMessage()}async activateListeners(html){html.on("change","input,select,textarea",this._onChange.bind(this)),html.on("click",`.${ECC_CLASS} .ecc-switch`,this._onToggle.bind(this)),html.on("click",`.${ECC_CLASS} .submit`,this._onSubmit.bind(this)),html.on("focusout",`.${ECC_CLASS} input`,this._onChange.bind(this)),html.on("click",`.${ECC_CLASS} button`,this._onButton.bind(this)),html.on("keydown",`.${ECC_CLASS} form`,this._onKey.bind(this)),html.find("[data-ecc-visibility]").each((async(i,el)=>await this.setVisibility(el))),html.find("[data-ecc-permissions]").each((async(i,el)=>await this.setPermission(el))),html.find(`.${ECC_CLASS} .ecc-switch`).each(((i,el)=>this.setState(el))),html.find(`.${ECC_CLASS} input[type="radio"]`).each(((i,el)=>this.setRadioState(el)))}setState(element){if(element&&(element.dataset.flag&&element.classList.add(this.flags[element.dataset.flag]?STATE_ON:STATE_OFF),element.dataset.name)){const value=getByPath(this,element.dataset.name);element.classList.add(value?STATE_ON:STATE_OFF)}}setRadioState(element){if(!element||!element.name)return;const splited=element.name.split(".");"data"===splited[0].toLowerCase()&&this.data&&void 0!==this.data[splited[1]]&&this.data[splited[1]]===element.value&&(element.checked=!0)}async setVisibility(element){if(!element.dataset.eccVisibility)return;await this.hasPerm(element.dataset.eccVisibility,!0)||(element.style.display="none")}async setPermission(element){if(!element.dataset.eccPermissions)return;await this.hasPerm(element.dataset.eccPermissions)||(element.classList.add("ecc-restricted"),$(element).is("input")&&("range"===element.type?$(element).attr("disabled",!0):$(element).attr("readonly",!0)),$(element).is("select")&&$(element).attr("disabled",!0))}async hasPerm(restrictedTo,vision=!1){if(!restrictedTo.length)return!0;let permissionsArray=restrictedTo.split(" ");const whiteList=!permissionsArray.includes(PERMISSION_TYPE_BLACKLIST);if(whiteList||(permissionsArray=permissionsArray.filter((e=>e!==PERMISSION_TYPE_BLACKLIST))),game.user.isGM){if(!vision)return!0;if(permissionsArray.includes(PERMISSION_TYPE_GM))return whiteList;if(permissionsArray.includes(PERMISSION_TYPE_NOT_GM))return!whiteList}if(permissionsArray=permissionsArray.filter((e=>e!==PERMISSION_TYPE_GM)),permissionsArray=permissionsArray.filter((e=>e!==PERMISSION_TYPE_NOT_GM)),permissionsArray.includes(PERMISSION_TYPE_USER)){if(this.message.isAuthor)return whiteList;permissionsArray=permissionsArray.filter((e=>e!==PERMISSION_TYPE_USER))}if(permissionsArray.includes(PERMISSION_TYPE_SPEAKER)){const speaker=this.message.data.speaker;if(speaker.token&&speaker.scene){const actor=await fromUuid(`Scene.${speaker.scene}.Token.${speaker.token}`);if(actor&&actor.isOwner)return whiteList}else if(speaker.actor){const actor=game.actors.get(speaker.actor);if(actor&&actor.isOwner)return whiteList}permissionsArray=permissionsArray.filter((e=>e!==PERMISSION_TYPE_SPEAKER))}if(permissionsArray.length)for(let i=0;i<permissionsArray.length;i++){const uuid=permissionsArray[i];let actor=await fromUuid(uuid);if(actor||(actor=game.actors.get(uuid)),actor)return actor.isOwner;ui.notifications.error(`Unable to find actor ${uuid}`)}return!whiteList}static async bindListeners(html){const htmlCardElement=html[0].querySelector(`.${ECC_CLASS}`);if(!htmlCardElement)return;const card=await EnhancedChatCard.fromHTMLCardElement(htmlCardElement);card&&card.activateListeners(html)}get flags(){return this.data.flags}async assignObjects(){}async localCompute(){}async GMUpdate(){}async ExecuteGMUpdate(){const newData=await game.enhancedChatCardsLib.socket.executeAsGM("GMUpdate",this.toObject(),this._options,this.constructor.name,this.messageId);this.data=newData,await this.assignObjects()}async _onButton(event){event.preventDefault();const target=event.currentTarget;target.style.display="none";const action=target.dataset.action;let formUpdate,actionUpdate=!1;const card=target.closest(`.${ECC_CLASS}`);card?formUpdate=this._update(card):console.error(`Could not find a EEC class for this card: ${this.constructor.name}`);const originalDisplayStyle=target.style.display;(action||(console.warn("no action associated with this button"),formUpdate))&&(this[action]||(console.warn(`no ${action} action found for this card`),formUpdate))&&(this[action]&&(actionUpdate=await this[action]({event,updateCard:!1})),formUpdate||actionUpdate?await this.updateChatCard():target.style.display=originalDisplayStyle)}_onKey(event){return"Enter"===event.key&&this._onSubmit(event),"Enter"!==event.key}_onChange(event){if(this.options.submitOnChange)return this._onSubmit(event)}_onSubmit(event){const target=event.currentTarget;if("BUTTON"===target.tagName&&"action"in target.dataset)return;event.preventDefault();const card=target.closest(`.${ECC_CLASS}`);if(!card)return;this._update(card)&&this.updateChatCard()}_update(card){const forms=card.querySelectorAll("form");let updates=!1;for(let i=0;i<forms.length;i++){const form=forms[i],data=new(foundry.applications.ux?.FormDataExtended??FormDataExtended)(form).object;for(const[key,value]of Object.entries(data)){getByPath(this,key)!==value&&(setByPath(this,key,value),updates=!0)}}return updates}get message(){return this._message?this._message:this._messageId?game.messages.get(this._messageId):void 0}set message(x){this._message=x}get messageId(){return this._messageId?this._messageId:this._message?this._message.id:void 0}set messageId(x){this._messageId=x}static get defaultOptions(){return{attachObject:!0,classes:[ECC_CLASS],exclude:[],excludeStartWith:"_",submitOnChange:!0,speaker:ChatMessage.getSpeaker(),ooc:!1,compute:!0,GMUpdate:!1}}get objectDataString(){const saveData={data:this.data,options:this._options};return JSON.stringify(saveData,((key,value)=>{if(null!==value&&!this.options.exclude?.includes(key)&&!key.startsWith(this.options.excludeStartWith))return value}))}get rollMode(){return this._rollMode||(this._rollMode=game.settings.get("core","rollMode")),this._rollMode}set rollMode(x){!1===x&&(this._rollMode=game.settings.get("core","rollMode")),this._rollMode=x}static async fromMessageId(messageId){const message=game.messages.get(messageId);if(!message)return;const card=await this.fromMessage(message);return card.messageId=messageId,card}static async fromMessage(message){const cardElement=$(message.data.content)[0];if(!cardElement)return;const card=await this.fromHTMLCardElement(cardElement);return card.message=message,card}static async fromHTMLCardElement(htmmlCard){if(!htmmlCard)return;if(!htmmlCard.dataset.eccClass)return;if(!htmmlCard.dataset.object)return;const cardData=JSON.parse(unescape(htmmlCard.dataset.object)),message=htmmlCard.closest(".message"),messageId=message?.dataset?.messageId;return await this.fromData(cardData.data,cardData.options,htmmlCard.dataset.eccClass,messageId)}static async fromData(data,options,cardClassName,messageId=void 0){const CardClass=game.enhancedChatCardsLib.types.get(cardClassName);if(!CardClass)return void console.error(`Unknown chat card type: ${cardClassName}`);const card=new CardClass(data,options);return messageId&&(card.messageId=messageId),await card.assignObjects(),card}setData(name){(name||"string"===$.type(name))&&setByPath(this,name,!0)}unsetData(name){(name||"string"===$.type(name))&&setByPath(this,name,!1)}toggleData(name){if(!name&&"string"!==$.type(name))return;setByPath(this,name,!getByPath(this,name))}async _onToggle(event){event.preventDefault();const target=event.currentTarget;if("action"in target.dataset)return this._onButton(event);if(target&&target.classList.contains("gm-select-only")&&!game.user.isGM)return;const name=target.dataset.flag?`data.flags.${target.dataset.flag}`:target.dataset.name;if(!name)return;const toggle=target.closest(".ecc-radio");if(toggle){const buttons=toggle.querySelectorAll(".ecc-switch");for(const b of buttons){const bName=b.dataset.flag?`data.flags.${b.dataset.flag}`:b.dataset.name;this.unsetData(bName)}this.setData(name)}else this.toggleData(name);const card=target.closest(`.${ECC_CLASS}`);this.options.submitOnChange&&card&&this._update(card),await this.updateChatCard()}}class CoC7Dice{static async roll(modif=0,rollMode=null,hideDice=!1){let roll,alternativeDice="";game.modules.get("dice-so-nice")?.active&&(modif<0?alternativeDice=game.settings.get("CoC7","tenDiePenalty"):modif>0&&(alternativeDice=game.settings.get("CoC7","tenDieBonus"),"bronze"===alternativeDice&&foundry.utils.isNewerVersion(game.modules.get("dice-so-nice").version,"5.0.0")&&!foundry.utils.isNewerVersion(game.modules.get("dice-so-nice").version,"5.0.5")&&(alternativeDice="bronze01"))),roll=game.CoC7.dev.dice.alwaysCrit&&game.settings.get("CoC7","hiddendevmenu")?Roll.fromData(CoC7Dice.crit01):game.CoC7.dev.dice.alwaysFumble&&game.settings.get("CoC7","hiddendevmenu")?Roll.fromData(CoC7Dice.fumble99):await new Roll("1dt"+(""!==alternativeDice?"+1do["+alternativeDice+"]":"+1dt").repeat(Math.abs(modif))+"+1d10").roll({async:!0});const result={unit:{total:0,results:[]},tens:{total:0,results:[]},total:0,roll};rollMode&&(result.rollMode=rollMode),hideDice&&(result.hideDice=hideDice);for(const d of roll.dice)d instanceof CONFIG.Dice.terms.t?result.tens.results.push(d.total):(result.unit.total=10===d.total?0:d.total,result.unit.results.push(result.unit.total));if(modif<0)result.tens.total=0===result.unit.total&&result.tens.results.includes(0)?100:Math.max(...result.tens.results);else if(0===result.unit.total){const dice=result.tens.results.filter((t=>t>0));result.tens.total=0===dice.length?100:Math.min(...dice)}else result.tens.total=Math.min(...result.tens.results);return result.total=result.unit.total+result.tens.total,result}static async showRollDice3d(roll){if(game.modules.get("dice-so-nice")?.active){const syncDice=game.settings.get("CoC7","syncDice3d"),chatData={whisper:null,blind:!1};ChatMessage.applyRollMode(chatData,game.settings.get("core","rollMode")),await game.dice3d.showForRoll(roll,game.user,syncDice,0===chatData.whisper.length?null:chatData.whisper,chatData.blind)}}static async combinedRoll(options){options.pool=options.pool??{},options.pool[0]=!1;const keys=Object.keys(options.pool).map((v=>parseInt(v,10)));let penaltyDice=Math.abs(Math.min(0,Math.min(...keys))),bonusDice=Math.max(0,Math.max(...keys));const hasDSN=game.modules.get("dice-so-nice")?.active,pool=[];pool.push("1dt+1d10"),penaltyDice>0&&pool.push((hasDSN?"+1do["+game.settings.get("CoC7","tenDiePenalty")+"]":"+1dt").repeat(Math.abs(penaltyDice))),bonusDice>0&&pool.push((hasDSN?"+1do["+("bronze"===game.settings.get("CoC7","tenDieBonus")&&foundry.utils.isNewerVersion(game.modules.get("dice-so-nice").version,"5.0.0")&&!foundry.utils.isNewerVersion(game.modules.get("dice-so-nice").version,"5.0.5")?"bronze01":game.settings.get("CoC7","tenDieBonus"))+"]":"+1dt").repeat(Math.abs(bonusDice)));const roll=await new Roll(pool.join("")).roll({async:!0}),result={groups:{baseDie:0,penaltyDice:[],bonusDice:[]},unit:0,roll};let baseSet=!1;for(const d of roll.dice)d instanceof CONFIG.Dice.terms.t?baseSet?penaltyDice>0?(result.groups.penaltyDice.push(d.total),penaltyDice--):(result.groups.bonusDice.push(d.total),bonusDice--):(result.groups.baseDie=d.total,baseSet=!0):result.unit=10===d.total?0:d.total;const output={};for(const key in options.pool){output[key]={unit:{total:result.unit,results:[result.unit]},tens:{total:0,results:[]},total:0,roll};const modif=parseInt(key,10);let modifier=modif;output[key].tens.results.push(result.groups.baseDie);for(const offset=Math.abs(modifier);modifier<0;modifier++)output[key].tens.results.push(result.groups.penaltyDice[modifier+offset]);for(const offset=modifier;modifier>0;modifier--)output[key].tens.results.push(result.groups.bonusDice[Math.abs(modifier-offset)]);if(modif<0)output[key].tens.total=0===output[key].unit.total&&output[key].tens.results.includes(0)?100:Math.max(...output[key].tens.results);else if(0===output[key].unit.total){const dice=output[key].tens.results.filter((t=>t>0));output[key].tens.total=0===dice.length?100:Math.min(...dice)}else output[key].tens.total=Math.min(...output[key].tens.results);output[key].total=output[key].unit.total+output[key].tens.total}return output}static fumble99={class:"Roll",options:{},dice:[],formula:"1dt + 1d10",terms:[{class:"CoC7DecaderDie",options:{},evaluated:!0,number:1,faces:10,modifiers:[],results:[{result:9,active:!0}]},{class:"OperatorTerm",options:{},evaluated:!0,operator:"+"},{class:"Die",options:{},evaluated:!0,number:1,faces:10,modifiers:[],results:[{result:9,active:!0}]}],total:99,evaluated:!0};static crit01={class:"Roll",options:{},dice:[],formula:"1dt + 1d10",terms:[{class:"CoC7DecaderDie",options:{},evaluated:!0,number:1,faces:10,modifiers:[],results:[{result:10,active:!0}]},{class:"OperatorTerm",options:{},evaluated:!0,operator:"+"},{class:"Die",options:{},evaluated:!0,number:1,faces:10,modifiers:[],results:[{result:1,active:!0}]}],total:1,evaluated:!0}}const COC7={eras:{standard:"CoC7.Era1920",modern:"CoC7.EraModern",modernPulp:"CoC7.EraModernPulp",pulp:"CoC7.EraPulp",downDarkerTrails:"CoC7.EraDownDarkerTrails",downDarkerTrailsPulp:"CoC7.EraDownDarkerTrailsPulp",darkAges:"CoC7.EraDarkAges",darkAgesPulp:"CoC7.EraDarkAgesPulp",regency:"CoC7.EraRegency",regencyPulp:"CoC7.EraRegencyPulp",reignOfTerror:"CoC7.EraReignOfTerror",gasLight:"CoC7.EraGasLight",gasLightPulp:"CoC7.EraGasLightPulp",invictus:"CoC7.EraInvictus"},monetaryFormatKeys:{decimalLeft:"decimalLeft",decimalRight:"decimalRight",integerLeft:"integerLeft",integerRight:"integerRight",lsd:"lsd",roman:"roman"},monetaryFormats:{decimalLeft:"CoC7.MonetaryFormatDecimalLeft",decimalRight:"CoC7.MonetaryFormatDecimalRight",integerLeft:"CoC7.MonetaryFormatIntegerLeft",integerRight:"CoC7.MonetaryFormatIntegerRight",lsd:"CoC7.MonetaryFormatLsd",roman:"CoC7.MonetaryFormatRoman"},monetaryTypeKeys:{none:"none",asses:"asses",sestertii:"sestertii",quinarii:"quinarii",denarii:"denarii",d:"d",s:"s",value:"value",multiplier:"multiplier"},monetaryTypes:{none:{name:"CoC7.MonetaryTypeNone",filter:[]},asses:{name:"CoC7.MonetaryTypeAsses",filter:["roman"]},sestertii:{name:"CoC7.MonetaryTypeSestertii",filter:["roman"]},quinarii:{name:"CoC7.MonetaryTypeQuinarii",filter:["roman"]},denarii:{name:"CoC7.MonetaryTypeDenarii",filter:["roman"]},d:{name:"CoC7.MonetaryTypeDeniers",filter:["lsd"]},s:{name:"CoC7.MonetaryTypeSous",filter:["lsd"]},value:{name:"CoC7.MonetaryTypeOne",filter:[]},multiplier:{name:"CoC7.MonetaryTypeCreditRating",filter:[]}},characteristics:{str:"CoC7.CharacStr",con:"CoC7.CharacCon",siz:"CoC7.CharacSiz",dex:"CoC7.CharacDex",app:"CoC7.CharacApp",int:"CoC7.CharacInt",pow:"CoC7.CharacPow",edu:"CoC7.CharacEdu"},skillProperties:{noadjustments:"CoC7.SkillNoAdjustments",noxpgain:"CoC7.SkillNoXpGain",special:"CoC7.SkillSpecial",rarity:"CoC7.SkillRarity",push:"CoC7.SkillPush",combat:"CoC7.SkillCombat",fighting:"CoC7.SkillFighting",firearm:"CoC7.SkillFirearm",ranged:"CoC7.SkillRanged",requiresname:"CoC7.SkillRequiresName",keepbasevalue:"CoC7.SkillKeepBaseValue",picknameonly:"CoC7.SkillPickNameOnly",onlyone:"CoC7.SkillSpecializationIsUnique"},weaponProperties:{melee:"CoC7.Weapon.Property.Melee",rngd:"CoC7.WeaponRngd",mnvr:"CoC7.WeaponProperyManeuver",thrown:"CoC7.Weapon.Property.Thrown",shotgun:"CoC7.Weapon.Property.Shotgun",dbrl:"CoC7.WeaponDbrl",impl:"CoC7.WeaponImpl",brst:"CoC7.WeaponBrst",auto:"CoC7.WeaponAuto",ahdb:"CoC7.WeaponAhdb",addb:"CoC7.WeaponAddb",slnt:"CoC7.WeaponSlnt",spcl:"CoC7.WeaponSpcl",mont:"CoC7.WeaponMont",blst:"CoC7.WeaponBlst",stun:"CoC7.WeaponStun",rare:"CoC7.WeaponRare",burn:"CoC7.Weapon.Property.Burn"},spellProperties:{call:"CoC7.CallSpell",dismiss:"CoC7.DismissSpell",contact:"CoC7.ContactSpell",summon:"CoC7.SummonSpell",bind:"CoC7.BindSpell",enchantment:"CoC7.EnchantmentSpell",gate:"CoC7.GateSpell",combat:"CoC7.CombatSpell"},bookType:{mythos:"CoC7.MythosBook",occult:"CoC7.OccultBook",other:"CoC7.Other"},talentType:{physical:"CoC7.PhysicalTalent",mental:"CoC7.MentalTalent",combat:"CoC7.CombatTalent",miscellaneous:"CoC7.MiscellaneousTalent",basic:"CoC7.BasicTalent",insane:"CoC7.InsaneTalent",other:"CoC7.OtherTalent"},statusType:{mania:"CoC7.Mania",phobia:"CoC7.Phobia"},occupationProperties:{classic:"CoC7.Classic",lovecraftian:"CoC7.Lovecraftian",modern:"CoC7.Modern",pulp:"CoC7.Pulp"},formula:{}};COC7.formula.actor={"@STR":"this.system.characteristics.str.value","@CON":"this.system.characteristics.con.value","@SIZ":"this.system.characteristics.siz.value","@DEX":"this.system.characteristics.dex.value","@APP":"this.system.characteristics.app.value","@INT":"this.system.characteristics.int.value","@POW":"this.system.characteristics.pow.value","@EDU":"this.system.characteristics.edu.value"},COC7.formula.actorsheet={"@STR":"this.actor.system.characteristics.str.value","@CON":"this.actor.system.characteristics.con.value","@SIZ":"this.actor.system.characteristics.siz.value","@DEX":"this.actor.system.characteristics.dex.value","@APP":"this.actor.system.characteristics.app.value","@INT":"this.actor.system.characteristics.int.value","@POW":"this.actor.system.characteristics.pow.value","@EDU":"this.actor.system.characteristics.edu.value"},COC7.status={tempoInsane:"tempoInsane",indefInsane:"indefInsane",unconscious:"unconscious",criticalWounds:"criticalWounds",dying:"dying",prone:"prone",dead:"dead"},COC7.newBookName="CoC7.NewBookName",COC7.newSkillName="CoC7.NewSkillName",COC7.newSpellName="CoC7.NewSpellName",COC7.newItemName="CoC7.NewItemName",COC7.newWeaponName="CoC7.NewWeaponName",COC7.creatureFightingSkill="CoC7.creatureFightingSkill",COC7.fightingSpecializationName="CoC7.FightingSpecializationName",COC7.firearmSpecializationName="CoC7.FirearmSpecializationName",COC7.rangedSpecializationName="CoC7.RangedSpecializationName",COC7.combatCards={fightBack:"CoC7.FightBack",dodge:"CoC7.Dodge",maneuver:"CoC7.Maneuver",noResponse:"CoC7.NoResponse"};class AverageParentheticalTerm extends foundry.dice.terms.ParentheticalTerm{_evaluateSync({minimize=!1,maximize=!1}={}){const roll=this.roll||new AverageRoll(this.term);return this.roll=roll.evaluate({minimize,maximize,async:!1}),this.flavor&&this.roll.terms.forEach((t=>{t.options.flavor=t.options.flavor??this.flavor})),this}}class AverageRoll extends Roll{_evaluateSync({minimize=!1,maximize=!1}={}){return this.terms=this.terms.map((term=>{if(!(term instanceof foundry.dice.terms.RollTerm))throw new Error("Roll evaluation encountered an invalid term which was not a RollTerm instance");if(term.isIntermediate){term.evaluate({minimize,maximize,async:!1}),this._dice=this._dice.concat(term.dice);let total=term.total;return minimize&&maximize&&term.dice.length&&(total=Math.floor((term.dice[0].faces+1)/2*term.total)),new foundry.dice.terms.NumericTerm({number:total,options:term.options})}return term})),this.terms=this.constructor.simplifyTerms(this.terms),this.terms=this.terms.map((term=>{if(!term._evaluated){if(void 0!==term.faces)return new foundry.dice.terms.NumericTerm({number:Math.floor((term.faces+1)/2*term.number),options:term.options});term.evaluate({minimize,maximize,async:!1})}return term})),this._total=this._evaluateTotal(),this}static _splitParentheses(_formula){return this._splitGroup(_formula,{openRegexp:AverageParentheticalTerm.OPEN_REGEXP,closeRegexp:AverageParentheticalTerm.CLOSE_REGEXP,openSymbol:"(",closeSymbol:")",onClose:group=>{const fn=group.open.slice(0,-1),expression=group.terms.join(""),options={flavor:group.flavor?group.flavor.slice(1,-1):void 0},terms=[];if(fn in Math){const args=this._splitMathArgs(expression);terms.push(new MathTerm({fn,terms:args,options}))}else fn&&terms.push(fn),terms.push(new AverageParentheticalTerm({term:expression,options}));return terms}})}}class CoC7ActiveEffect extends ActiveEffect{apply(actor,change){"system.attribs.armor.value"===change.key?isNaN(change.value)||isNaN(actor.system.attribs.armor.value)||(actor.system.attribs.armor.value=Number(actor.system.attribs.armor.value)):"system.attribs.db.value"===change.key&&isNaN(change.value)&&!isNaN(actor.system.attribs.db.value)&&(actor.system.attribs.db.value=String(actor.system.attribs.db.value));return super.apply(actor,change)}static onManageActiveEffect(event,owner){event.preventDefault();const a=event.currentTarget,li=a.closest("li"),effect=li.dataset.effectId?owner.effects.get(li.dataset.effectId):null;switch(a.dataset.action){case"create":return owner.createEmbeddedDocuments("ActiveEffect",[{name:game.i18n.localize("CoC7.EffectNew"),img:"icons/svg/aura.svg",origin:owner.uuid,"duration.rounds":"temporary"===li.dataset.effectType?1:void 0,disabled:"inactive"===li.dataset.effectType}]);case"edit":return effect.sheet.render(!0);case"delete":return effect.delete();case"toggle":return effect.update({disabled:!effect.disabled})}}_prepareDuration(){const duration=super._prepareDuration();return"seconds"===duration.type&&(duration.seconds>3600?duration.label=new Date(1e3*duration.seconds).toISOString().slice(11,19):duration.seconds>100&&(duration.label=new Date(1e3*duration.seconds).toISOString().slice(14,19))),duration}static filterActiveEffects(effect,conditionName){return effect.statuses.has(conditionName)}static getStatusKey(effect){let options=[];return effect.statuses.size>0&&(options=[...effect.statuses.values()]),options.find((v=>Object.prototype.hasOwnProperty.call(COC7.status,v)))}get isStatus(){return"string"==typeof CoC7ActiveEffect.getStatusKey(this)}static prepareActiveEffectCategories(effects,{status=!0}={}){const categories={temporary:{type:"temporary",label:game.i18n.localize("CoC7.Temporary"),effects:[]},passive:{type:"passive",label:game.i18n.localize("CoC7.Passive"),effects:[]},inactive:{type:"inactive",label:game.i18n.localize("CoC7.Inactive"),effects:[]},suppressed:{type:"suppressed",label:game.i18n.localize("CoC7.Suppressed"),effects:[],info:[game.i18n.localize("CoC7.Unavailable")]}};status&&(categories.status={type:"status",label:game.i18n.localize("Status"),effects:[]});for(const e of effects)e.isSuppressed?categories.suppressed.effects.push(e):e.isStatus?categories.status.effects.push(e):e.disabled?categories.inactive.effects.push(e):e.isTemporary?categories.temporary.effects.push(e):categories.passive.effects.push(e);return categories.suppressed.hidden=!categories.suppressed.effects.length,categories}static prepareNPCActiveEffectCategories(effects){let count=0;const categories={active:{type:"active",label:game.i18n.localize("Active"),effects:[]},inactive:{type:"inactive",label:game.i18n.localize("Inactive"),effects:[]}};for(const e of effects)count+=1,e.isSuppressed||e.disabled?categories.inactive.effects.push(e):categories.active.effects.push(e);return count>0&&(categories.expended=!0),categories}}class CoC7ContentLinkDialog extends FormApplication{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{id:"link-creation",classes:["coc7","active-effect-sheet"],title:game.i18n.localize("CoC7.CreateLink"),dragDrop:[{dragSelector:null,dropSelector:".container"}],template:"systems/CoC7/templates/apps/link-creation.html",closeOnSubmit:!1,width:560,height:"auto",tabs:[{navSelector:".tabs",contentSelector:".effect-options",initial:"details"}]})}async getData(){const sheetData=await super.getData();return sheetData.checkType=[{key:CoC7Link.CHECK_TYPE.CHECK,label:game.i18n.localize("CoC7.Check")},{key:CoC7Link.CHECK_TYPE.SANLOSS,label:game.i18n.localize("CoC7.SanityCheck")},{key:CoC7Link.CHECK_TYPE.ITEM,label:game.i18n.localize("CoC7.ItemWeapon")},{key:CoC7Link.CHECK_TYPE.EFFECT,label:game.i18n.localize("EFFECT.TabEffects")}],sheetData.linkType=[{key:CoC7Link.LINK_TYPE.CHARACTERISTIC,label:game.i18n.localize("CoC7.Characteristic")},{key:CoC7Link.LINK_TYPE.ATTRIBUTE,label:game.i18n.localize("CoC7.Attribute")},{key:CoC7Link.LINK_TYPE.SKILL,label:game.i18n.localize("CoC7.Skill")}],sheetData.attributeType=[{key:"lck",label:game.i18n.localize("CoC7.Luck")},{key:"san",label:game.i18n.localize("CoC7.Sanity")}],sheetData.effectModes=Object.entries(CONST.ACTIVE_EFFECT_MODES).reduce(((obj,e)=>(obj[e[1]]=game.i18n.localize("EFFECT.MODE_"+e[0]),obj)),{}),sheetData.characteristicType=CoCActor.getCharacteristicDefinition(),sheetData.link=sheetData.object.link,sheetData.fromGame=sheetData.link.isItemCheck||sheetData.link.isSkillCheck,sheetData.fromDirectory="fromDirectory"===sheetData.object.hasID,sheetData.fromCompendium="fromCompendium"===sheetData.object.hasID,sheetData.isSetFromGame=sheetData.link.id&&(sheetData.fromDirectory||sheetData.fromCompendium),sheetData.difficultyLevels=[{key:CoC7Check.difficultyLevel.unknown,label:"CoC7.RollDifficultyUnknown"},{key:CoC7Check.difficultyLevel.regular,label:"CoC7.RollDifficultyRegular"},{key:CoC7Check.difficultyLevel.hard,label:"CoC7.RollDifficultyHard"},{key:CoC7Check.difficultyLevel.extreme,label:"CoC7.RollDifficultyExtreme"},{key:CoC7Check.difficultyLevel.critical,label:"CoC7.RollDifficultyCritical"}],sheetData.actorNames=sheetData.object.actors.map((a=>a.name)).join(", "),sheetData}activateListeners(html){super.activateListeners(html),html.find("select[name=type],select[name=check],select[name=attributeKey],select[name=characteristicKey],input[type=checkbox]").change(this._onChangeSubmit.bind(this)),html.find(".effect-control").click(this._onEffectControl.bind(this))}_onChangeSubmit(event){switch(event.currentTarget.name){case"fromCompendium":case"fromDirectory":this.object.hasID=event.currentTarget.name===this.object.hasID?"":event.currentTarget.name}this._onSubmit(event)}_onEffectControl(event){event.preventDefault();const button=event.currentTarget;switch(button.dataset.action){case"add":return this._addEffectChange();case"delete":button.closest(".effect-change").remove(),this._onSubmit(event)}}async _addEffectChange(){const idx=this.object.link.effect.changes.length;return this.submit({preventClose:!0,updateData:{[`effect.changes.${idx}`]:{key:"",mode:CONST.ACTIVE_EFFECT_MODES.ADD,value:""}}})}async _updateObject(event,formData){let hasEffect=!1;const effect={duration:{},changes:[]};for(const key in formData)switch(key){case"checkName":this.object.link.setValue("name",formData.checkName);break;case"blind":case"pushing":case"difficulty":case"displayName":case"icon":case"id":case"modifier":case"pack":case"sanMin":case"sanMax":case"sanReason":this.object.link.setValue(key,formData[key]);break;case"hasModifiers":case"hasLabel":case"hasIcon":this.object[key]=formData[key];break;case"effect.label":effect.label=formData[key],hasEffect=!0;break;case"effect.icon":effect.icon=formData[key],hasEffect=!0;break;case"effect.tint":effect.tint=formData[key],hasEffect=!0;break;case"effect.disabled":effect.disabled=formData[key],hasEffect=!0;break;case"effect.duration.seconds":effect.duration.seconds=formData[key],hasEffect=!0;break;case"effect.duration.rounds":effect.duration.rounds=formData[key],hasEffect=!0;break;case"effect.duration.turns":effect.duration.turns=formData[key],hasEffect=!0;break;default:{const match=key.match(/^effect\.changes\.(\d+)\.key$/);match&&(effect.changes.push({key:formData[key],mode:formData["effect.changes."+match[1]+".mode"],value:formData["effect.changes."+match[1]+".value"]}),hasEffect=!0)}}hasEffect&&this.object.link.setValue("object",effect);const target=event.currentTarget;if(target){switch(target.name){case"type":this.object.link.setValue("check",target.value),target.value===CoC7Link.CHECK_TYPE.CHECK&&(this.object.link.setValue("linkType",CoC7Link.LINK_TYPE.SKILL),this.object.link.setValue("name",""));break;case"check":this.object.link.setValue("linkType",target.value),target.value===CoC7Link.LINK_TYPE.CHARACTERISTIC?this.object.link.setValue("name",CoCActor.getCharacteristicDefinition()[0].key):target.value===CoC7Link.LINK_TYPE.ATTRIBUTE?this.object.link.setValue("name","lck"):this.object.link.setValue("name","");break;case"attributeKey":case"characteristicKey":this.object.link.setValue("name",target.value)}if("submit"===event.type){switch(event.submitter.dataset.action){case"clipboard":CoC7Utilities.copyToClipboard(this.object.link.link);break;case"chat":CoC7Link.toChatMessage(this.object.link.object);break;case"whisper-owner":CoC7Link.toWhisperMessage(this.object.link.object,this.object.actors);break;case"whisper-selected":if(!canvas.tokens.controlled.length)return void ui.notifications.warn(game.i18n.localize("CoC7.ErrorNoTokensSelected"));CoC7Link.toWhisperMessage(this.object.link.object,canvas.tokens.controlled.filter((t=>t.actor.owners.length)).map((t=>t.actor)))}return}}this.render(!0)}async _onDrop(event){const dataString=event.dataTransfer.getData("text/plain"),data=JSON.parse(dataString);if("CoC7Link"===data.type)this.setLink(await CoC7Link.fromDropData(data)),this.render(!0);else if("Folder"===data.type&&"Actor"===data.documentName||["Item","Actor"].includes(data.type)){const dataList=await CoC7Utilities.getDataFromDropEvent(event,data.documentName??data.type);data.documentName??"Actor"===data.type?(this.object.actors=dataList.filter((a=>a.owners.length)),this.render(!0)):1===dataList.length&&["skill","weapon"].includes(dataList[0].type)&&(dataList[0].pack?(this.object.hasID="fromCompendium",this.object.link.setValue("pack",dataList[0].pack)):this.object.hasID="fromDirectory",this.object.link.setValue("id",dataList[0].id),this.object.link.setValue("name",dataList[0].name),this.render(!0))}}setLink(link){return this.object.link=link,""!==link.pack?this.object.hasID="fromCompendium":""!==link.id&&(this.object.hasID="fromDirectory"),link.difficulty!==CoC7Check.difficultyLevel.regular||0!==parseInt(link.modifier,10)||link.isPushing?this.object.hasModifiers=!0:this.object.hasModifiers=!1,""!==link.displayName&&(this.object.hasLabel=!0),""!==link.icon&&(this.object.hasIcon=!0),""}static async create(linkData={},option={}){const object=foundry.utils.mergeObject({link:null,hasID:"",hasModifiers:!1,hasLabel:!1,hasIcon:!1,actors:[]},option),dialog=new CoC7ContentLinkDialog(object,{});dialog.setLink(await CoC7Link.fromDropData(linkData)),dialog.render(!0)}}function createInlineRoll(roll){const data={cls:["inline-roll"],dataset:{}};try{data.cls.push("inline-result"),data.result=roll.total,data.title=roll.formula,data.dataset.roll=escape(JSON.stringify(roll))}catch(err){return null}const a=document.createElement("a");a.classList.add(...data.cls),a.title=data.title;for(const[k,v]of Object.entries(data.dataset))a.dataset[k]=v;return a.innerHTML=`<i class="fas fa-dice-d20"></i> ${data.result}`,a}function isCtrlKey(event){return!1!==event&&(event.metaKey||event.ctrlKey||91===event.keyCode||224===event.keyCode)}class chatHelper{static hyphenToCamelCase(string){return string.replace(/-([a-z])/g,(function(string){return string[1].toUpperCase()}))}static async createMessage(title,message,options={}){const messageData={};messageData.flavor=title,messageData.speaker=options.speaker||ChatMessage.getSpeaker(),options.whisper&&(messageData.type=CONST.CHAT_MESSAGE_TYPES.WHISPER,messageData.whisper=options.whisper),void 0!==options.roll&&(messageData.roll=options.roll,messageData.type=CONST.CHAT_MESSAGE_TYPES.ROLL,messageData.rollMode=CONST.DICE_ROLL_MODES.SELF),messageData.user=game.user.id,messageData.content=message,ChatMessage.create(messageData).then((msg=>msg))}static camelCaseToHyphen(string){return string.replace(/([A-Z])/g,(function(string){return"-"+string.toLowerCase()}))}static getActorFromKey(key){if(!key)return null;if(CoC7Utilities.isDocumentUuid(key))return CoC7Utilities.isDocumentUuidPack(key)?fromUuid(key):CoC7Utilities.SfromUuid(key);if(key.includes(".")){const[sceneId,tokenId]=key.split(".");if("TOKEN"===sceneId)return game.actors.tokens[tokenId];const token=chatHelper.getTokenFromKey(key);return token?.actor}return game.actors.get(key)||null}static getSpeakerFromKey(actorKey){const speaker={},actor=chatHelper.getActorFromKey(actorKey);if(actorKey.includes(".")){const[sceneId,tokenId]=actorKey.split(".");speaker.token=tokenId,speaker.scene=sceneId,actor.token?.name&&(speaker.alias=actor.token.name),speaker.actor=actor.id}else speaker.actor=actorKey,speaker.alias=actor.name;return speaker}static attachObjectToElement(object,element,objectName=""){for(const prop of Object.keys(object))prop.startsWith("_")||("object"==typeof object[prop]?chatHelper.attachObjectToElement(object[prop],element,`${objectName}:${prop}:`):element.dataset[`${objectName}${prop}`]=object[prop])}static getObjectFromElement(object,element){function deserialize(obj,key,value){if(key.startsWith(":")){const s=key.slice(1),objProp=s.slice(s.indexOf(":")+1),objName=s.substring(0,s.indexOf(":"));void 0===obj[objName]&&(obj[objName]={}),deserialize(obj[objName],objProp,value)}else"true"===value?obj[key]=!0:"false"===value?obj[key]=!1:Number(value).toString()===value?obj[key]=Number(value):obj[key]=value}if(element&&object)for(const prop of Object.keys(element.dataset)){if("template"===prop)return;deserialize(object,prop,element.dataset[prop])}}static getTokenFromKey(key){if(!key)return null;if(key.includes(".")){const[sceneId,tokenId]=key.split(".");if("TOKEN"===sceneId){const tokenDoc=game.actors.tokens[tokenId]?.token;return tokenDoc.object}{const scene=game.scenes.get(sceneId);if(!scene)return null;const tokenData=scene.getEmbeddedDocument("Token",tokenId);if(!tokenData)return null;const token=new Token(tokenData);return token.scene||(token.scene=foundry.utils.duplicate(scene.document)),token}}{const actor=game.actors.get(key);return chatHelper.getActorToken(actor)}}static getActorToken(actor){return actor?actor.token||actor.prototypeToken:null}static getActorImgFromKey(actorKey){if(!actorKey)return null;if(game.settings.get("CoC7","useToken")){const token=chatHelper.getTokenFromKey(actorKey);if(token&&(token.document||token).texture.src&&-1===(token.document||token).texture.src.indexOf("*"))return(token.document||token).texture.src}const actor=chatHelper.getActorFromKey(actorKey);return game.settings.get("CoC7","useToken")&&actor.prototypeToken&&actor.prototypeToken.texture.src&&-1===actor.prototypeToken.texture.src?.indexOf("*")?actor.prototypeToken.texture.src:actor.img}static getDistance(startToken,endToken){if(void 0===endToken.center&&void 0!==endToken.id&&startToken.scene?.id){const scene=game.scenes.get(startToken.scene.id);if(void 0!==scene?.tokens){const tokens=scene?.tokens.filter((token=>token.actor.id===endToken.data.document.id)).map((token=>token.object));1===tokens.length&&(endToken=tokens[0])}}let distance={gridUnit:0,value:0,unit:canvas.scene.grid.units};if(void 0!==startToken&&void 0!==startToken.center&&void 0!==endToken&&void 0!==endToken.center){const ray=new Ray(startToken.center,endToken.center),segment=[{ray}];if(distance={gridUnit:ray.distance/canvas.scene.grid.size,value:canvas.grid.measureDistances(segment,{gridSpaces:game.settings.get("CoC7","gridSpaces")})[0],unit:canvas.scene.grid.units},game.settings.get("CoC7","distanceElevation")){const elevation=Math.abs((startToken.document.elevation||0)-(endToken.document.elevation||0));distance.value=Math.sqrt(distance.value*distance.value+elevation*elevation)}}else game.settings.get("CoC7","distanceTheatreOfTheMind")||ui.notifications.warn(game.i18n.localize("CoC7.MessageDistanceCalculationFailure"));return distance}static toYards(distance){return"ft"===distance.unit?distance.value/3:distance.value}}class CoC7Roll{static getFromCard(card){const rollDiv=card.querySelector("div.dice-roll");if(!rollDiv)return null;const roll=new CoC7Roll;return chatHelper.getObjectFromElement(roll,rollDiv),roll}get resultType(){switch(this.successLevel=parseInt(this.successLevel),this.successLevel){case CoC7Check.successLevel.regular:return game.i18n.format("CoC7.RegularSuccess");case CoC7Check.successLevel.hard:return game.i18n.format("CoC7.HardSuccess");case CoC7Check.successLevel.extreme:return game.i18n.format("CoC7.ExtremeSuccess");case CoC7Check.successLevel.critical:return game.i18n.format("CoC7.CriticalSuccess");case CoC7Check.successLevel.fumble:return game.i18n.format("CoC7.Fumble");case CoC7Check.successLevel.failure:return game.i18n.format("CoC7.Failure");default:return null}}get actor(){return this.actorKey?chatHelper.getActorFromKey(this.actorKey):null}get item(){return this.itemId&&this.actor?this.actor.items.get(this.itemId):null}get skill(){return this.skillId&&this.actor?this.actor.items.get(this.skillId):null}showDiceRoll(){if(game.modules.get("dice-so-nice")?.active){const diceResults=[];for(const dieResult of this.dices.tens)diceResults.push(100===dieResult.value?0:dieResult.value/10);diceResults.push(this.dices.unit.value);const diceData={formula:`${this.dices.tens.length}d100+1d10`,results:diceResults,whisper:null,blind:!1};game.dice3d.show(diceData)}}static getFromElement(element,object=null){if(!element)return;const roll=object||new CoC7Roll;chatHelper.getObjectFromElement(roll,element),roll.dices={tens:[],unit:{}},chatHelper.getObjectFromElement(roll.dices,element.querySelector(".dice-result")),roll.dices.hasBonus=0!==roll.diceModifier,roll.dices.bonus=Math.abs(roll.diceModifier),roll.dices.bonusType=roll.diceModifier<0?game.i18n.format("CoC7.DiceModifierPenalty"):game.i18n.format("CoC7.DiceModifierBonus");const tenDice=element.querySelector(".ten-dice");if(tenDice)for(const d of tenDice.querySelectorAll("li")){const die={selected:!1,isMax:!1,isMin:!1,value:-1};chatHelper.getObjectFromElement(die,d),roll.dices.tens.push(die)}const unitDie=element.querySelector(".unit-die")?element.querySelector(".unit-die").querySelector("li"):null;roll.dices.unit.value=unitDie?parseInt(unitDie.dataset.value):null,roll.increaseSuccess=[];const increaseSuccess=element.querySelector(".increase-success");if(increaseSuccess&&increaseSuccess.querySelectorAll("button"))for(const isl of increaseSuccess.querySelectorAll("button")){const newSuccesLevel={};chatHelper.getObjectFromElement(newSuccesLevel,isl),roll.increaseSuccess.push(newSuccesLevel)}return roll.luckNeeded&&(roll.luckNeededTxt=game.i18n.format("CoC7.SpendLuck",{luckNeededValue:roll.luckNeeded})),object?void 0:roll}static getFromCheck(check){const roll=new CoC7Roll;return roll.rollType=check.rollType,roll.side=check.side,roll.action=check.action,roll.refMessageId=check.refMessageId,roll.referenceMessageId=check.referenceMessageId,roll.successLevel=check.successLevel,roll.difficulty=check.difficulty,roll.skillId=check.skill?check.skill.id:null,roll.itemId=check.item?check.item.id:null,roll.diceMod=check.diceModifier,roll.value=parseInt(check.rawValue),roll.fumble=check.isFumble,roll.critical=check.isCritical,roll.characteristic=check.characteristic?check.characteristic:null,roll.result=check.dice.total,roll.actorKey=check.actor.tokenKey,check.actor.isToken?(roll.tokenId=check.actor.tokenKey,roll.actorId=null):(roll.tokenKey=null,roll.actorId=check.actor.tokenKey),roll}static attachCheckToElement(htmlElement,check){const roll=CoC7Roll.getFromCheck(check);return roll.attachToElement(htmlElement),roll}attachToElement(htmlElement){chatHelper.attachObjectToElement(this,htmlElement)}}class CoC7Damage{static getMainDie(damageString){return damageString.toLowerCase().includes("d20")?"d20":damageString.toLowerCase().includes("d12")?"d12":damageString.toLowerCase().includes("d10")?"d10":damageString.toLowerCase().includes("d8")?"d8":damageString.toLowerCase().includes("d4")?"d4":"d6"}static getFromElement(element,object=null){if(!element)return;const damage=object||{};chatHelper.getObjectFromElement(damage,element);const rolls=element.querySelector(".dice-rolls").querySelectorAll("li");damage.rolls=[];for(const r of rolls){const roll={};chatHelper.getObjectFromElement(roll,r);const group=roll.group,dice={faces:roll.faces,result:roll.result};delete roll.group,delete roll.faces,delete roll.result,void 0===damage.rolls[group]&&(roll.dice=[],damage.rolls.push(roll)),damage.rolls[group].dice.push(dice)}return object?void 0:damage}}class RollDialog{static async create(options={}){options.difficulty&&(options.difficultyLevel={},CoC7Check.difficultyLevel.unknown===options.difficulty&&(options.difficultyLevel.unknown=!0),CoC7Check.difficultyLevel.regular===options.difficulty&&(options.difficultyLevel.regular=!0),CoC7Check.difficultyLevel.hard===options.difficulty&&(options.difficultyLevel.hard=!0),CoC7Check.difficultyLevel.extreme===options.difficulty&&(options.difficultyLevel.extreme=!0)),options.name&&!options.displayName&&(options.displayName=options.name);const unknownDifficultyDefault="unknown"===game.settings.get("CoC7","defaultCheckDifficulty"),data={allowFlatDiceModifier:game.settings.get("CoC7","allowFlatDiceModifier")&&!options.disableFlatDiceModifier,allowFlatThresholdModifier:game.settings.get("CoC7","allowFlatThresholdModifier")&&!options.disableFlatThresholdModifier,difficulty:CoC7Check.difficultyLevel,unknownDifficultyDefault,hideDifficulty:options.hideDifficulty??!1,options};void 0!==options.cardType&&(!options.forcedCardType??1)&&(data.cardTypes=CoC7ChatMessage.cardTypes(options));const html=await renderTemplate("systems/CoC7/templates/apps/bonus.html",data);return new Promise((resolve=>{let formData=null;const dlg=new Dialog({title:options.displayName?game.i18n.format("CoC7.BonusSelectionWindowNamed",{name:options.displayName}):game.i18n.localize("CoC7.BonusSelectionWindow"),content:html,buttons:{roll:{label:'<i class="fa-solid fa-dice-d10"></i><i class="fa-solid fa-dice-d10"></i> '+game.i18n.localize("CoC7.RollDice"),callback:html=>(formData=new FormData(html[0].querySelector("#bonus-roll-form")),resolve(formData))}},default:"roll",close:()=>{}});dlg.render(!0)}))}}class RollCard{constructor(){this.rolls=[],this.initiator=null}static async fromMessageId(messageId){const message=game.messages.get(messageId);if(!message)return;const card=await this.fromMessage(message);return card.messageId=messageId,card}static async fromMessage(message){const cardElement=$(message.content)[0];if(!cardElement)return;const card=await this.fromHTMLCardElement(cardElement);return card.message=message,card}static async fromHTMLCardElement(card){const cardData=JSON.parse(unescape(card.dataset.object));return await this.fromData(cardData)}static async fromData(data){const card=Object.assign(new this,data);for(let index=0;index<card.rolls.length;index++)"Object"===card.rolls[index]?.constructor?.name&&(card.rolls[index]=Object.assign(new CoC7Check,card.rolls[index]),card.rolls[index].rolled&&(card.rolls[index]._htmlRoll=await card.rolls[index].getHtmlRoll()));return card}static async _onToggle(event){event.preventDefault();const span=event.target;if(span&&span.classList.contains("gm-select-only")&&!game.user.isGM)return;const message=span.closest(".chat-message"),card=await this.fromMessageId(message.dataset.messageId);if(!card)return;const flag=span.dataset.flag;if(!flag)return;const toggle=span.closest(".toggle");if(toggle){const buttons=toggle.querySelectorAll(".toggle-switch");for(const b of buttons)card.unsetFlag(b.dataset.flag);card.setFlag(flag)}else card.toggleFlag(flag);card.updateChatCard()}static async dispatch(data){if(game.user.isGM){let card,messages=ui.chat.collection.filter((message=>this.defaultConfig.type===message.getFlag("CoC7","type")&&"resolved"!==message.getFlag("CoC7","state")&&(!["combinedCard"].includes(this.defaultConfig.type)||message.getFlag("CoC7","initiator")===data.roll.initiator)));if(messages.length){const timestamp=new Date(messages[0].timestamp);86400<(new Date-timestamp)/1e3&&(await messages[0].setFlag("CoC7","state","resolved"),messages=[])}card=messages.length?await this.fromMessage(messages[0]):new this,void 0!==data._rollMode&&(card._rollMode=data._rollMode),await card.process(data)}else game.socket.emit("system.CoC7",data)}static async resolveOld(userId){const messages=ui.chat.collection.filter((message=>this.defaultConfig.type===message.getFlag("CoC7","type")&&"resolved"!==message.getFlag("CoC7","state")&&(!["combinedCard"].includes(this.defaultConfig.type)||message.getFlag("CoC7","initiator")===userId)));if(messages.length){await messages[0].setFlag("CoC7","state","resolved");const card=await this.fromMessage(messages[0]);card.closeCard(),await card.updateChatCard()}}async toMessage(){const html=await renderTemplate(this.config.template,this),htmlCardElement=$(html);htmlCardElement[0].dataset.object=escape(this.dataString);const chatData={user:game.user.id,flavor:game.i18n.localize(this.config.title),content:htmlCardElement[0].outerHTML,flags:{CoC7:{type:this.config.type,state:"initiated",initiator:this.initiator}}};["gmroll","blindroll"].includes(this.rollMode)&&(chatData.whisper=ChatMessage.getWhisperRecipients("GM")),"blindroll"===this.rollMode&&(chatData.blind=!0);return await ChatMessage.create(chatData)}async updateChatCard(){if(await this.compute(),this.messageId){const html=await renderTemplate(this.config.template,this),htmlCardElement=$.parseHTML(html)[0];htmlCardElement.dataset.object=escape(this.dataString);const chatMessage=game.messages.get(this.messageId);this.closed&&await chatMessage.setFlag("CoC7","state","resolved");const msg=await chatMessage.update({content:htmlCardElement.outerHTML});return await ui.chat.updateMessage(msg,!1),msg}await this.toMessage()}updateRoll(data){data.fromGM||Object.assign(this.rolls[data.rank],data.roll)}addRollData(data){const check=Object.assign(new CoC7Check,data.roll);this.rolls.push(check),"combinedCard"===this.config.type&&(this.initiator=data.roll.initiator)}addRoll(data){this.rolls.push(data)}removeRoll(rank){this.rolls.splice(rank,1)}setFlag(flagName){(flagName||"string"===$.type(flagName))&&(this[flagName]=!0)}unsetFlag(flagName){(flagName||"string"===$.type(flagName))&&(this[flagName]=!1)}toggleFlag(flagName){this[flagName]=!this[flagName]}get message(){return this._message?this._message:this._messageId?game.messages.get(this._messageId):void 0}set message(x){this._message=x}get messageId(){return this._messageId?this._messageId:this._message?this._message.id:void 0}set messageId(x){this._messageId=x}static get defaultConfig(){return{exclude:["_actor","_skill","_item","_message","_htmlRoll"],excludeStartWith:"__"}}get winners(){return this.rolls.filter((r=>r.winner))}get winner(){if(this.winners.length)return this.winners[0]}get loosers(){return this.rolls.filter((r=>!r.winner))}get looser(){if(this.loosers.length)return this.loosers[0]}get hasWinner(){return this.winners.length>0}get isKeeper(){return game.user.isGM}get rollMode(){return this._rollMode||(this._rollMode=game.settings.get("core","rollMode")),this._rollMode}set rollMode(x){!1===x&&(this._rollMode=game.settings.get("core","rollMode")),this._rollMode=x}get data(){return JSON.parse(this.dataString)}get dataString(){return JSON.stringify(this,((key,value)=>{if(null!==value&&!this.config.exclude?.includes(key)&&!key.startsWith(this.config.excludeStartWith))return value}))}}class CombinedCheckCard extends RollCard{static async bindListerners(html){html.on("click",".roll-card.combined .toggle-switch",this._onToggle.bind(this)),html.on("click",".roll-card.combined a",CombinedCheckCard._onClick.bind(this)),html.on("click",".roll-card.combined button",CombinedCheckCard._onClick.bind(this))}static get defaultConfig(){return foundry.utils.mergeObject(super.defaultConfig,{template:"systems/CoC7/templates/chat/cards/combined-roll.html",type:"combinedCard",title:"CoC7.CombinedRollCard"})}get config(){return CombinedCheckCard.defaultConfig}get successCount(){if(this.rolled){let count=0;for(const r of this.rolls)r.passed&&(count+=1);return count}}get mainActorKey(){return this.rolls[0]?.actor?.actorKey||void 0}get success(){if(void 0!==this.successCount)return this.any?this.successCount>0:this.all?this.successCount===this.rolls.length:void 0}get failure(){if(void 0!==this.success)return!this.success}get checkGMInitiator(){return game.users.get(this.initiator)?.isGM}async getHtmlRoll(){if(!this.rolled)return;const check=new CoC7Check;return await check._perform({roll:this._roll[check.diceModifier||0],silent:!0}),await check.getHtmlRoll({hideSuccess:!0})}process(data){switch(data.action){case"new":case"roll":this.addRollData(data);break;case"updateRoll":this.updateRoll(data);break;case"assignRoll":this.assignRoll(data)}game.user.isGM?this.updateChatCard():game.socket.emit("system.CoC7",data)}async assignRoll(data){game.user.isGM&&(this.rolled||(this.rolled=!0,this._roll=data.roll))}static async _onClick(event){event.preventDefault();const a=event.target,action=a.dataset.action,li=a.closest("li.actor-roll"),message=a.closest(".chat-message"),cardElement=a.closest("div.roll-card"),card=await CombinedCheckCard.fromHTMLCardElement(cardElement);card.messageId=message.dataset.messageId;const rank=Number(li?.dataset?.rank);switch(action){case"remove-roll":card.removeRoll(rank),await card.updateChatCard();break;case"close-card":card.closeCard(),await card.updateChatCard();break;case"roll-card":{const pool={};for(const dice of card.rolls){const diceModifier=parseInt(dice.diceModifier,10);isNaN(diceModifier)||(pool[diceModifier]=!1)}const roll=await CoC7Dice.combinedRoll({pool});roll.initiator=game.user.id;const data={type:this.defaultConfig.type,action:"assignRoll",fromGM:game.user.isGM,roll};AudioHelper.play({src:CONFIG.sounds.dice},!0),card.process(data);break}default:{const options={update:!1,data:a.dataset,classes:a.classList,target:a};await CoC7Check.alter(card.rolls[rank],action,options);const data={type:this.defaultConfig.type,action:"updateRoll",rank,fromGM:game.user.isGM,roll:{initiator:game.user.id}};game.user.isGM||(data.roll=card.rolls[rank].JSONRollData),card.process(data);break}}}async compute(){if(this._roll){this.rolls=this.rolls.filter((roll=>void 0!==roll.actor.system));for(const r of this.rolls)r.rolled||(r.modifier=r.diceModifier||0,r.difficulty=r.difficulty||CoC7Check.difficultyLevel.regular,r.flatDiceModifier=r.flatDiceModifier||0,r.flatThresholdModifier=r.flatThresholdModifier||0,await r._perform({roll:this._roll[r.modifier],silent:!0}));for(let i=0;i<this.rolls.length;i++)this.rolls[i].rolled&&(this.rolls[i]._htmlRoll=await this.rolls[i].getHtmlRoll({hideDiceResult:!0}));this._htmlRoll=await this.getHtmlRoll()}}closeCard(){this.closed=!0}}class InteractiveChatCard{constructor(options={}){this._options=options}get options(){return foundry.utils.mergeObject(this.constructor.defaultOptions,this._options)}get template(){return this.options.template}get cssClasses(){return this.options.classes}async toMessage(optionnalChatData={}){const html=await renderTemplate(this.template,this),htmlCardElement=$(html)[0];htmlCardElement.dataset.object=escape(this.dataString),htmlCardElement.dataset.cardClass=this.constructor.name,htmlCardElement.classList.add(...this.cssClasses);const chatData=foundry.utils.mergeObject({user:game.user.id,flavor:game.i18n.localize(this.options.title),content:htmlCardElement.outerHTML},optionnalChatData);["gmroll","blindroll"].includes(this.rollMode)&&(chatData.whisper=ChatMessage.getWhisperRecipients("GM")),"blindroll"===this.rollMode&&(chatData.blind=!0),ChatMessage.create(chatData).then((msg=>msg))}async updateChatCard(options={}){if(options.compute&&this.compute(),this.messageId){const html=await renderTemplate(this.template,this),htmlCardElement=$.parseHTML(html)[0];htmlCardElement.dataset.object=escape(this.dataString),htmlCardElement.dataset.cardClass=this.constructor.name,htmlCardElement.classList.add(...this.cssClasses);const chatMessage=game.messages.get(this.messageId);this.closed&&await chatMessage.setFlag("CoC7","state","resolved");const msg=await chatMessage.update({content:htmlCardElement.outerHTML});return await ui.chat.updateMessage(msg,!1),msg}this.toMessage()}activateListeners(html){html.on("click",".interactive-card .ic-radio-switch",this._onToggle.bind(this)),html.on("click",".interactive-card .ic-switch",this._onToggle.bind(this)),html.on("click",".interactive-card .submit",this._onSubmit.bind(this)),html.on("focusout","input",this._onSubmit.bind(this)),html.on("click",".interactive-card button",this._onButton.bind(this)),html.on("keydown","form",this._onKey.bind(this))}static async bindListeners(html){const htmlCardElement=html[0].querySelector(".chat-card");if(!htmlCardElement)return;if(!htmlCardElement.dataset.cardClass)return;if(!Object.getOwnPropertyNames(game.CoC7.cards).includes(htmlCardElement.dataset.cardClass))return;const card=await InteractiveChatCard.fromHTMLCardElement(htmlCardElement),typedCard=Object.assign(new game.CoC7.cards[htmlCardElement.dataset.cardClass],card);typedCard.assignObject(),typedCard.activateListeners(html)}assignObject(){}_onButton(event){const action=event.currentTarget.dataset.action;this[action]&&this[action]({event,update:!0})}_onKey(event){return"Enter"===event.key&&this._onSubmit(event),"Enter"!==event.key}_onSubmit(event){event.preventDefault();const card=event.currentTarget.closest(".interactive-card");if(!card)return;this._update(card)&&this.updateChatCard()}_update(card){const forms=card.querySelectorAll("form");let updates=!1;for(let i=0;i<forms.length;i++){const form=forms[i];let data=new FormDataExtended(form).object;data=foundry.utils.diffObject(this,foundry.utils.expandObject(data));for(const[key,value]of Object.entries(data))this[key]=value,updates=!0}return updates}get message(){return this._message?this._message:this._messageId?game.messages.get(this._messageId):void 0}set message(x){this._message=x}get messageId(){return this._messageId?this._messageId:this._message?this._message.id:void 0}set messageId(x){this._messageId=x}static get defaultOptions(){return{classes:["interactive-card"],exclude:["_actor","_skill","_item","_message","_htmlRoll"],excludeStartWith:"__"}}get data(){return JSON.parse(this.dataString)}get dataString(){return JSON.stringify(this,((key,value)=>{if(null!==value&&!this.options.exclude?.includes(key)&&!key.startsWith(this.options.excludeStartWith))return value}))}get rollMode(){return this._rollMode||(this._rollMode=game.settings.get("core","rollMode")),this._rollMode}set rollMode(x){!1===x&&(this._rollMode=game.settings.get("core","rollMode")),this._rollMode=x}static async fromMessageId(messageId){const message=game.messages.get(messageId);if(!message)return;const card=await this.fromMessage(message);return card.messageId=messageId,card}static async fromMessage(message){const cardElement=$(message.content)[0];if(!cardElement)return;const card=await this.fromHTMLCardElement(cardElement);return card.message=message,card}static async fromHTMLCardElement(card){const cardData=JSON.parse(unescape(card.dataset.object));if(!cardData.messageId){const message=card.closest(".message");cardData.messageId=message?.dataset?.messageId}return await this.fromData(cardData)}static async fromData(data){const card=Object.assign(new this,data);return await card.assignObject(),card}setFlag(flagName){(flagName||"string"===$.type(flagName))&&(this[flagName]=!0)}unsetFlag(flagName){(flagName||"string"===$.type(flagName))&&(this[flagName]=!1)}toggleFlag(flagName){this[flagName]=!this[flagName]}async _onToggle(event){event.preventDefault();const target=event.currentTarget;if("action"in target.dataset)return this._onButton(event);if(target&&target.classList.contains("gm-select-only")&&!game.user.isGM)return;const flag=target.dataset.flag;if(!flag)return;const toggle=target.closest(".ic-radio");if(toggle){const buttons=toggle.querySelectorAll(".ic-radio-switch");for(const b of buttons)this.unsetFlag(b.dataset.flag);this.setFlag(flag)}else this.toggleFlag(flag);const card=target.closest(".interactive-card");card&&this._update(card),this.updateChatCard()}get displayActorOnCard(){return game.settings.get("CoC7","displayActorOnCard")}get isBlind(){return this.rollMode?(void 0===this._isBlind&&(this._isBlind="blindroll"===this.rollMode),this._isBlind):null}set isBlind(x){this._isBlind=x}get actor(){return this.actorKey?chatHelper.getActorFromKey(this.actorKey):null}get token(){return this.actor?chatHelper.getTokenFromKey(this.actorKey):null}get item(){return this.itemId?this.actor.items.get(this.itemId):null}get weapon(){return this.item}get targetedTokens(){return[...game.user.targets]}get target(){return this.targetToken?this.targetToken:this.targetActor}get isTargetOwner(){return this.target.isOwner}get isKeeper(){return game.user.isGM}get targetToken(){return this._targetToken||(this._targetKey?this._targetToken=chatHelper.getTokenFromKey(this._targetKey):(this._targetToken=this.targetedTokens.pop(),this._targetToken?this._targetKey=`${this._targetToken.scene.id}.${this._targetToken.id}`:this._targetToken=null)),this._targetToken}get targetActor(){return this._targetActor||(this.targetToken?this._targetActor=this.targetToken.actor||this.targetToken.data.actor||this.targetToken.data.document:this._targetActor=chatHelper.getActorFromKey(this._targetKey)),this._targetActor}get targetKey(){return this.targetToken||this.targetActor?this._targetKey:null}get hasTarget(){return!(!this.targetToken&&!this.targetActor)}set targetKey(x){this._targetKey=x}get skills(){return this.actor.getWeaponSkills(this.itemId)}get targetImg(){const img=chatHelper.getActorImgFromKey(this.targetKey);return img||"../icons/svg/mystery-man-black.svg"}get name(){return this.token?this.token.name:this.actor.name}get targetName(){return this.target?this.target.name:"dummy"}get actorImg(){const img=chatHelper.getActorImgFromKey(this.actorKey);return img||"../icons/svg/mystery-man-black.svg"}}class DamageCard extends InteractiveChatCard{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{exclude:["_targetToken","_targetActor","_htmlRoll","_htmlInlineRoll"].concat(super.defaultOptions.exclude),template:"systems/CoC7/templates/chat/cards/damage.html"})}async assignObject(){this.damageRoll&&"Object"===this.damageRoll.constructor.name&&(this.damageRoll=Roll.fromData(this.damageRoll))}_onButton(event){super._onButton(event)}get critical(){return this.options.critical}set critical(x){this._options.critical=x}get impale(){return void 0===this._impale?this.weapon.impale:this._impale}set impale(x){this._impale=x}get isDamageFormula(){return"string"==typeof this.damageFormula&&(!!isNaN(Number(this.damageFormula))&&Roll.validate(this.damageFormula))}get isDamageNumber(){return!isNaN(Number(this.damageFormula))}get isArmorForula(){return"string"==typeof this.armor&&(!!isNaN(Number(this.armor))&&Roll.validate(this.armor))}get totalDamageString(){let damage=Number(this.isDamageNumber?this.damageFormula:this.roll.total);return!this.ignoreArmor&&((isNaN(Number(this.armor))||Number(this.armor)>0)&&(damage-=Number(this.armor)),!isNaN(Number(this.armor))&&damage<=0)?game.i18n.localize("CoC7.ArmorAbsorbsDamage"):damage}get noDamage(){if(this.rolled){const damage=this.isDamageNumber?this.damageFormula:this.roll.total;return this.ignoreArmor?!!(damage<=0):!isNaN(Number(this.armor))&&!!(damage-Number(this.armor)<=0)}return!1}async updateChatCard(){if(!this.options.fastForward||this.roll||this.isDamageNumber||await this.rollDamage({update:!1}),this.isDamageNumber||this.roll&&null!=this.roll.total||this.hardrolled?this.rolled=!0:this.rolled=!1,!this.options.fastForward||this.damageInflicted||this.noDamage||await this.dealDamage({update:!1}),this.rolled&&this.roll){"Object"===this.roll.constructor.name&&(this.roll=Roll.fromData(this.roll));const a=createInlineRoll(this.roll);this._htmlInlineRoll=a.outerHTML,this._htmlRoll=await this.roll.render()}await super.updateChatCard()}async rollDamage(options={update:!0}){this.roll=await new Roll(this.damageFormula||"0").evaluate({async:!0}),await CoC7Dice.showRollDice3d(this.roll),this.hardrolled=!0,options.update=void 0===options.update||options.update,options.update&&this.updateChatCard()}async rollArmor(options={update:!0}){const roll=await new Roll(this.armor).evaluate({async:!0});this.armor=roll.total,options.update=void 0===options.update||options.update,options.update&&this.updateChatCard()}async dealDamageToSelectedTarget(options={update:!0}){if(this.isArmorForula&&await this.rollArmor(),isNaN(Number(this.totalDamageString)))return void ui.notifications.error(game.i18n.localize("CoC7.ErrorEvaluatingDamage"));const targets=[],targetName=[],selectedPlayers=canvas.tokens.controlled.map((token=>token.actor));for(let index=0;index<selectedPlayers.length;index++)this.actor.id!==selectedPlayers[index].id&&(targetName.push(selectedPlayers[index].name),targets.push(selectedPlayers[index]));const data={title:" ",content:game.i18n.format("CoC7.DealDamage",{damage:this.totalDamageString,target:targetName}),buttons:{one:{icon:'<i class="fas fa-check"></i>',label:game.i18n.localize("CoC7.Proceed"),callback:()=>{this.confirmDamage(targets)}},two:{icon:'<i class="fas fa-times"></i>',label:game.i18n.localize("CoC7.Cancel"),callback:()=>{}}},default:"two"};targetName.length>0&&new Dialog(data).render(!0)}async confirmDamage(targets){for(let index=0;index<targets.length;index++)await targets[index].dealDamage(Number(this.totalDamageString),{ignoreArmor:!1}),ChatMessage.create({content:game.i18n.format("CoC7.DamageDealTo",{name:targets[index].name,damage:this.totalDamageString})})}async dealDamage(options={update:!0}){this.isArmorForula&&await this.rollArmor();let damage=this.totalDamageString;if(isNaN(Number(damage))){if(game.i18n.localize("CoC7.ArmorAbsorbsDamage")!==damage)return void ui.notifications.error("Error evaluating damage");damage=0}this.targetActor&&await this.targetActor.dealDamage(Number(damage),{ignoreArmor:!0}),this.damageInflicted=!0,options.update=void 0===options.update||options.update,options.update&&this.updateChatCard()}get range(){return this.options.range||"normal"}set range(x){["normal","long","extreme"].inclues(x.toLowerCase())&&(this._options.range=x)}get damageFormula(){const range=this.range;let formula=this.weapon?.system?.range[range]?.damage,db=this.actor.db;if(db=(""===(db??"").toString().trim()?0:db).toString().trim(),db.startsWith("-")||(db="+"+db),this.weapon.system.properties.addb&&(formula+=db),this.weapon.system.properties.ahdb&&(formula+=CoC7Utilities.halfDB(this.actor.db)),formula){const maxDamage=new Roll(formula)[foundry.utils.isNewerVersion(game.version,"12")?"evaluateSync":"evaluate"]({maximize:!0}).total;let rollString;return this.critical?this.impale?(rollString=this.weapon?.system?.range[range]?.damage+"+"+maxDamage,rollString):maxDamage:formula}}get armor(){return void 0!==this._armor&&""!==this._armor?this._armor:this.target?this.targetActor.system.attribs.armor.value:0}set armor(x){this._armor=x}}class OpposedCheckCard extends RollCard{static async bindListerners(html){html.on("click",".roll-card.opposed .toggle-switch",this._onToggle.bind(this)),html.on("click",".roll-card.opposed a",OpposedCheckCard._onClick.bind(this)),html.on("click",".roll-card.opposed button",OpposedCheckCard._onClick.bind(this))}static get defaultConfig(){return foundry.utils.mergeObject(super.defaultConfig,{template:"systems/CoC7/templates/chat/cards/opposed-roll.html",type:"opposedCard"})}get config(){return OpposedCheckCard.defaultConfig}get attackerRoll(){if(this.combat){if(this.rolls?.length){const attacker=this.rolls.filter((r=>0===r.index||r.attacker));if(attacker.length)return attacker[0]}}else;}get defenderRoll(){if(this.combat){if(this.rolls?.length){const defender=this.rolls.filter((r=>0!==r.index||!r.attacker));if(defender.length)return defender[0]}}else;}get defenderIsDodging(){return!(!this.defenderRoll?.actor?.dodgeSkill?.name||!this.defenderRoll?.skill?.name)&&this.defenderRoll.actor.dodgeSkill.name.toLowerCase()===this.defenderRoll.skill.name.toLowerCase()}get advantageAttacker(){return void 0===this._aa?!!this.defenderRoll&&!this.defenderIsDodging:this._aa}get winnerRollsDamage(){return!!(this.combat&&this.rolls.length>=2&&this.hasWinner&&"weapon"===this.winner?.item?.type)}set advantageAttacker(x){this._aa=!0,this._ad=!1}get advantageDefender(){return void 0===this._ad?this.defenderIsDodging:this._ad}set advantageDefender(x){this._ad=!0,this._aa=!1}get isTie(){return this.winnerCount>1}get needsTieBreaker(){return!!this.combat&&!(!this.attackerRoll||!this.defenderRoll||this.attackerRoll.successLevel!==this.defenderRoll.successLevel)}get winnerCount(){let count=0;for(const r of this.rolls)r.winner&&(count+=1);return count}get isAttackManeuver(){return!(!this.combat||!this.attackerRoll||this.attackerRoll?.item&&!this.attackerRoll?.item.system.properties?.mnvr)}get resultText(){if(this.combat&&this.attackerRoll&&this.defenderRoll){if(!this.attackerRoll.winner&&!this.defenderRoll.winner)return game.i18n.localize("CoC7.NoWinner");if(this.attackerRoll.winner)return this.attackerRoll.maneuver?game.i18n.format("CoC7.ManeuverSuccess",{name:this.attackerRoll.actor.name}):game.i18n.format("CoC7.AttackSuccess",{name:this.attackerRoll.actor.name});if(this.defenderRoll.winner)return this.defenderRoll.maneuver?game.i18n.format("CoC7.ManeuverSuccess",{name:this.defenderRoll.actor.name}):this.defenderIsDodging?game.i18n.format("CoC7.DodgeSuccess",{name:this.defenderRoll.actor.name}):game.i18n.format("CoC7.AttackSuccess",{name:this.defenderRoll.actor.name})}}async process(data){switch(data.action){case"new":this.rolls?.length||(this.combat=data.combat||void 0,this.combat&&(data.roll.attacker=!0)),data.roll.index=this.rolls.length,this.addRollData(data);break;case"roll":this.addRollData(data);break;case"updateRoll":this.updateRoll(data)}game.user.isGM?await this.updateChatCard():game.socket.emit("system.CoC7",data)}async roll(rank){await this.rolls[rank]._perform();const data={type:this.config.type,action:"updateRoll",rank,fromGM:game.user.isGM};return game.user.isGM||(data.roll=this.rolls[rank].JSONRollData),data}static async _onClick(event){event.preventDefault();const a=event.currentTarget,action=a.dataset.action,li=a.closest("li.actor-roll"),message=a.closest(".chat-message"),cardElement=a.closest("div.roll-card"),card=await OpposedCheckCard.fromHTMLCardElement(cardElement);card.messageId=message.dataset.messageId;const rank=Number(li?.dataset?.rank);switch(action){case"toggle-combat":card.combat=!card.combat,await card.updateChatCard();break;case"remove-roll":card.removeRoll(rank),await card.updateChatCard();break;case"close-card":card.closeCard(),await card.updateChatCard();break;case"roll-check":{const speaker=ChatMessage.getSpeaker();card.rolls[rank].actorKey||(card.rolls[rank].actorKey=`${speaker.scene}.${speaker.token}`);const data=await card.roll(rank);await card.process(data);break}case"roll-damage":{card.closeCard(),await card.updateChatCard();const damageChatCard=new DamageCard({critical:card.winner.isExtremeSuccess,fastForward:event.shiftKey});damageChatCard.actorKey=card.winner.actor.actorKey,damageChatCard.targetKey=card.looser.actor.actorKey,damageChatCard.itemId=card.winner.itemId,damageChatCard.updateChatCard();break}default:{const options={update:!1,data:a.dataset,classes:a.classList,target:a};await CoC7Check.alter(card.rolls[rank],action,options);const data={type:this.defaultConfig.type,action:"updateRoll",rank,fromGM:game.user.isGM};game.user.isGM||(data.roll=card.rolls[rank].JSONRollData),card.process(data);break}}}async compute(rank=void 0){if(this.rolls=this.rolls.filter((roll=>void 0!==roll.actor.actorKey)),rank)this.rolls[rank].rolled&&(this.rolls[rank]._htmlRoll=await this.rolls[rank].getHtmlRoll({hideDiceResult:!0}));else for(let i=0;i<this.rolls.length;i++)delete this.rolls[i].maneuver,this.combat&&(!this.rolls[i].item||this.rolls[i].item.system.properties?.mnvr)&&(this.rolls[i]?.actor?.dodgeSkill?.name&&this.rolls[i]?.skill?.name&&this.rolls[i].actor.dodgeSkill.name.toLowerCase()!==this.rolls[i].skill.name.toLowerCase()||!this.rolls[i]?.actor?.dodgeSkill?.name)&&(this.rolls[i].maneuver=!0),this.rolls[i].rolled&&(this.rolls[i]._htmlRoll=await this.rolls[i].getHtmlRoll({hideDiceResult:!0}));if(this.combat){if(this.rolls.sort(((a,b)=>a.index>b.index?1:a.index<b.index?-1:0)),this.rolls.length>1){this.rolls=[this.rolls[0],this.rolls[1]];for(const r of this.rolls)delete r.winner,delete r.tie}this.rolls[0]&&(this.rolls[0].attacker=!0),this.rolls[0]?.rolled&&this.rolls[1]?.rolled&&(this.rolls[0].passed||this.rolls[1].passed)&&(this.rolls[0].successLevel>this.rolls[1].successLevel?this.rolls[0].winner=!0:this.rolls[1].successLevel>this.rolls[0].successLevel?this.rolls[1].winner=!0:this.advantageAttacker?this.rolls[0].winner=!0:this.rolls[1].winner=!0)}else{if(this.rolls.sort(((a,b)=>{if(a.rolled&&!b.rolled)return-1;if(!a.rolled&&b.rolled)return 1;if(!a.rolled&&!b.rolled)return 0;if(a.successLevel>b.successLevel)return this.resolved=!0,-1;if(a.successLevel<b.successLevel)return this.resolved=!0,1;if(game.settings.get("CoC7","opposedRollTieBreaker")){if(a.modifiedResult>b.modifiedResult)return this.resolved=!0,-1;if(a.modifiedResult<b.modifiedResult)return this.resolved=!0,1}else{if(a.rawValue>b.rawValue)return this.resolved=!0,-1;if(a.rawValue<b.rawValue)return this.resolved=!0,1}return 0})),this.winCount=0,this.rolls[0]&&this.rolls[0].rolled&&!this.rolls[0].failed){this.winCount=1;for(let i=1;i<this.rolls.length;i++)this.rolls[i]&&this.rolls[i].rolled&&this.rolls[0].successLevel===this.rolls[i].successLevel&&(game.settings.get("CoC7","opposedRollTieBreaker")?this.rolls[0].modifiedResult===this.rolls[i].modifiedResult:this.rolls[0].rawValue===this.rolls[i].rawValue)&&(this.winCount=this.winCount+1)}for(let i=0;i<this.rolls.length;i++)this.rolls[i].winner=i<this.winCount,this.rolls[i].tie=this.rolls[i].winner&&this.winCount>1}}closeCard(){this.closed=!0}}class ChatCardActor{constructor(actorKey=null,fastForward=!1){this.actorKey=actorKey,this.fastForward=fastForward}get displayActorOnCard(){return game.settings.get("CoC7","displayActorOnCard")}get isBlind(){return this.rollMode?(void 0===this._isBlind&&(this._isBlind="blindroll"===this.rollMode),this._isBlind):null}set isBlind(x){this._isBlind=x}get rollMode(){return this._rollMode||(this._rollMode=game.settings.get("core","rollMode")),this._rollMode}set rollMode(x){this._rollMode=x}get actor(){return this.actorKey?chatHelper.getActorFromKey(this.actorKey):null}get token(){return this.actor?chatHelper.getTokenFromKey(this.actorKey):null}get item(){return this.itemId?this.actor.items.get(this.itemId):null}get weapon(){return this.item}get targetedTokens(){return[...game.user.targets]}get target(){return this.targetToken?this.targetToken:this.targetActor}get targetToken(){return this._targetToken||(this._targetKey?this._targetToken=chatHelper.getTokenFromKey(this._targetKey):(this._targetToken=this.targetedTokens.pop(),this._targetToken?this._targetKey=`${this._targetToken.scene.id}.${this._targetToken.id}`:this._targetToken=null)),this._targetToken}get targetActor(){return this._targetActor||(this.targetToken?this._targetActor=this.targetToken.actor:this._targetActor=chatHelper.getActorFromKey(this._targetKey)),this._targetActor}get targetKey(){return this.targetToken||this.targetActor?this._targetKey:null}get hasTarget(){return!(!this.targetToken&&!this.targetActor)}set targetKey(x){this._targetKey=x}get skills(){return this.actor.getWeaponSkills(this.itemId)}get targetImg(){const img=chatHelper.getActorImgFromKey(this.targetKey);return img||"../icons/svg/mystery-man-black.svg"}get name(){return this.token?this.token.name:this.actor.name}get targetName(){return this.target?this.target.name:"dummy"}get actorImg(){const img=chatHelper.getActorImgFromKey(this.actorKey);return img||"../icons/svg/mystery-man-black.svg"}async say(message,flavor=null){const speakerData={};let speaker;this.actor?(speakerData.actor=this.actor,this.token&&(speakerData.token=this.token.document),speaker=ChatMessage.getSpeaker(speakerData)):speaker=ChatMessage.getSpeaker();const chatData={user:(this.actor.user?this.actor.user:game.user).id,speaker,flavor,content:message};["gmroll","blindroll"].includes(game.settings.get("core","rollMode"))&&(chatData.whisper=ChatMessage.getWhisperRecipients("GM")),"blindroll"===this.rollMode&&(chatData.blind=!0),ChatMessage.create(chatData).then((msg=>msg))}}function replacer(key,value){if(key.startsWith("__"))return;if(["_actor"].includes(key))return;return["sanCheck","intCheck"].includes(key)?value.JSONRollData:value}class SanCheckCard extends ChatCardActor{constructor(actorKey=null,sanData={},options={}){super(actorKey,void 0!==options.fastForward&&Boolean(options.fastForward)),sanData.sanReason=sanData.sanReason??"",this.sanData=sanData,this.options=options,sanData.modifier&&!isNaN(Number(sanData.modifier))&&(this.options.sanModifier=Number(sanData.modifier)),sanData.difficulty&&!isNaN(Number(sanData.difficulty))&&(this.options.sanDifficulty=Number(sanData.difficulty)),this.state={}}get isBlind(){return void 0!==this.options.isBlind?Boolean(this.options.isBlind):super.isBlind}get difficulty(){return void 0!==this.options.difficulty?this.options.difficulty:CoC7Check.difficultyLevel.regular}get modifier(){return void 0!==this.options.modifier?this.options.modifier:0}get sanLossSource(){return this.sanData.tokenKey?chatHelper.getActorFromKey(this.sanData.tokenKey):null}get involuntaryAction(){return!(!this.state.sanRolled||!this.sanCheck.isFailure&&!this.sanCheck.isFumble)}get sanLossFormula(){return this.state.sanRolled?this.sanData.sanMax&&this.sanCheck.failed?isNaN(Number(this.sanData.sanMax))?this.sanData.sanMax:Number(this.sanData.sanMax):this.sanData.sanMin&&this.sanCheck.passed?isNaN(Number(this.sanData.sanMin))?this.sanData.sanMin:Number(this.sanData.sanMin):0:null}get sanLostToReason(){return this.actor.sanLostToReason(this.sanData.sanReason)}get maxPossibleSanLoss(){return this.actor.maxLossToSanReason(this.sanData.sanReason,this.sanData.sanMax)}get maxSanLoss(){return new Roll(this.sanData.sanMax.toString())[foundry.utils.isNewerVersion(game.version,"12")?"evaluateSync":"evaluate"]({maximize:!0}).total}get sanLossReasonEncountered(){return this.actor.sanLossReasonEncountered(this.sanData.sanReason)}get firstEncounter(){return!this.actor.mythosInsanityExperienced}get isActorLoosingSan(){return!this.actor.hasTempoInsane&&(0!==this.sanLossFormula&&(!this.sanData.sanReason||0!==this.actor.maxLossToSanReason(this.sanData.sanReason,this.sanData.sanMax)||(this.state.immuneToCreature=!0,!1)))}get boutDurationText(){if(this.boutDuration){if(this.boutRealTime)return`${this.boutDuration} ${game.i18n.localize("CoC7.rounds")}`;if(this.boutSummary)return`${this.boutDuration} ${game.i18n.localize("CoC7.hours")}`}return null}get youGainCthulhuMythosString(){return this.mythosGain?game.i18n.format("CoC7.YouGainedCthulhuMythos",{value:this.mythosGain}):null}async advanceState(state){switch(state){case"keepCreatureSanData":this.state.keepCreatureSanData=!0;break;case"involuntaryActionPerformed":this.state[state]=!0,this.isActorLoosingSan||(this.state.finish=!0);break;case"sanLossApplied":await this.applySanLoss();break;case"enterBoutOfMadnessRealTime":this.boutDuration=(await new Roll("1D10").roll({async:!0})).total,this.boutRealTime=!0,this.boutSummary=!1,this.boutResult=await this.actor.enterBoutOfMadness(!0,this.boutDuration),this.state.boutOfMadnessResolved=!0,this.state.boutOfMadnessOver=!1;break;case"enterBoutOfMadnessSummary":this.boutDuration=(await new Roll("1D10").roll({async:!0})).total,this.boutRealTime=!1,this.boutSummary=!0,this.boutResult=await this.actor.enterBoutOfMadness(!1,this.boutDuration),this.state.boutOfMadnessResolved=!0,await this.triggerInsanity();break;case"boutOfMadnessOver":await this.actor.unsetCondition(COC7.status.tempoInsane),await this.triggerInsanity();break;case"noMythosGained":this.state.cthulhuMythosAwarded=!0,this.mythosGain=0;break;case"cthulhuMythosAwarded":{let amountGained=1;this.actor.mythosInsanityExperienced||(amountGained=5,await this.actor.experienceFirstMythosInsanity()),this.state.cthulhuMythosAwarded=!0;const cthulhuMythosSkill=this.actor.cthulhuMythosSkill,oldValue=cthulhuMythosSkill.system.adjustments.experience||0;cthulhuMythosSkill&&await cthulhuMythosSkill.update({"system.adjustments.experience":oldValue+amountGained}),this.mythosGain=amountGained;break}}}async bypassRollSan(){this.isBypassed=!0,this.sanCheck=new CoC7Check,this.sanCheck.actor=this.actorKey,this.sanCheck.attribute="san",this.sanCheck.difficulty=this.options.sanDifficulty||CoC7Check.difficultyLevel.regular,this.sanCheck.diceModifier=this.options.sanModifier||0,await this.sanCheck._perform({forceDSN:!0}),this.state.sanRolled=!0,this.state.involuntaryActionPerformed=this.sanCheck.passed,this.state.sanLossRolled=!0,this.state.ignoreSanCheck=!0,this.preHardenedSanLoss=this.originalSanLoss=this.sanLossFormula,this.sanLoss=this.applyMythosHardened(this.preHardenedSanLoss)}applyMythosHardened(sanLoss){return this.actor.useMythosHardened?Math.floor(sanLoss/2):sanLoss}async rollSan(){if(this.sanCheck=new CoC7Check,this.sanCheck.actor=this.actorKey,this.sanCheck.attribute="san",this.sanCheck.difficulty=this.options.sanDifficulty||CoC7Check.difficultyLevel.regular,this.sanCheck.diceModifier=this.options.sanModifier||0,await this.sanCheck._perform({forceDSN:!0}),this.state.sanRolled=!0,this.state.involuntaryActionPerformed=this.sanCheck.passed,this.isActorLoosingSan){if("number"==typeof this.sanLossFormula)if(this.state.sanLossRolled=!0,this.originalSanLoss=this.sanLossFormula,this.sanData.sanReason){const max=this.actor.maxLossToSanReason(this.sanData.sanReason,this.sanData.sanMax);this.preHardenedSanLoss=this.originalSanLoss,this.preHardenedSanLoss>max&&(this.preHardenedSanLoss=max,this.state.limitedLossToCreature=!0)}else this.preHardenedSanLoss=this.originalSanLoss;else if(this.sanCheck.isFumble)this.state.sanLossRolled=!0,this.originalSanLoss=new Roll(this.sanData.sanMax)[foundry.utils.isNewerVersion(game.version,"12")?"evaluateSync":"evaluate"]({maximize:!0}).total,this.preHardenedSanLoss=this.actor.maxLossToSanReason(this.sanData.sanReason,this.originalSanLoss);else if(this.sanData.sanReason){new Roll(this.sanLossFormula)[foundry.utils.isNewerVersion(game.version,"12")?"evaluateSync":"evaluate"]({minimize:!0}).total>=this.actor.maxLossToSanReason(this.sanData.sanReason,this.sanData.sanMax)&&(this.state.sanLossRolled=!0,this.preHardenedSanLoss=this.originalSanLoss=this.max,this.state.limitedLossToCreature=!0)}}else this.state.finish=!0,this.actor.hasTempoInsane&&(this.state.immuneAlreadyInBout=!0,this.sanCheck.passed||(this.state.finish=!1)),this.state.sanLossRolled=!0,this.state.sanLossApplied=!0,this.state.intRolled=!0,this.state.insanity=!1,this.preHardenedSanLoss=0,this.originalSanLoss=0;this.sanLoss=this.applyMythosHardened(this.preHardenedSanLoss)}async rollSanLoss(){this.sanLossRoll=new Roll(`${this.sanLossFormula}`),await this.sanLossRoll.roll({async:!0}),await CoC7Dice.showRollDice3d(this.sanLossRoll);const max=this.actor.maxLossToSanReason(this.sanData.sanReason,this.sanData.sanMax);this.sanLossRoll.total>max&&(this.state.limitedLossToCreature=!0),this.originalSanLoss=this.sanLossRoll.total,this.preHardenedSanLoss=Math.min(this.originalSanLoss,max),this.sanLoss=this.applyMythosHardened(this.preHardenedSanLoss),this.state.sanLossRolled=!0}async applySanLoss(){if(await this.actor.looseSan(this.sanData.sanReason,this.sanLoss),this.sanLoss>0&&(this.state.actorLostSan=!0),this.state.sanLossApplied=!0,this.actor.san<=0)return this.state.intRolled=!0,this.state.boutOfMadnessOver=!0,this.state.insanity=!0,this.state.permanentlyInsane=!0,void(this.state.finish=!0);this.sanLoss<5?(this.state.intRolled=!0,this.actor.hasIndefInsane?(this.state.insanity=!0,this.state.shaken=!0,this.state.insanityTableRolled=!1,this.state.finish=!1,this.state.intRolled=!0):(this.state.insanity=!1,this.state.shaken=!0,this.state.insanityTableRolled=!0,this.state.finish=!0)):this.state.intRolled=!1,this.actor.dailySanLoss>=this.actor.dailySanLimit&&(this.state.insanity=!0,this.state.intRolled=!0,this.state.temporaryInsane=!1,this.state.indefinitelyInsane=!0,this.state.insanityTableRolled=!1,this.state.memoryRepressed=!1,this.state.finish=!1)}async rollInt(){this.intCheck=new CoC7Check,this.intCheck.actor=this.actorKey,this.intCheck.characteristic="int",this.intCheck.difficulty=this.options.intDifficulty||CoC7Check.difficultyLevel.regular,this.intCheck.diceModifier=this.options.intModifier||0,await this.intCheck._perform({forceDSN:!0}),this.state.intRolled=!0,this.intCheck.passed||this.state.alreadyInsane?(this.state.insanity=!0,this.state.temporaryInsane=!0,this.state.indefinitelyInsane=!1,this.state.memoryRepressed=!1):(this.state.insanity=!1,this.state.temporaryInsane=!1,this.state.indefinitelyInsane=!1,this.state.memoryRepressed=!0,this.state.finish=!0)}async triggerInsanity(){this.state.boutOfMadnessOver=!0,this.state.indefinitelyInsane&&await this.actor.setCondition(COC7.status.indefInsane),this.state.finish=!0}async clearSanLossReason(){await this.actor.setReasonSanLoss(this.sanData.sanReason,0),this.sanLossReasonEncountered||(this.state.keepCreatureSanData=!0)}async updateChatCard(){if(this.state.sanRolled&&(this.__inlineSanCheck=this.sanCheck.inlineCheck.outerHTML),this.sanLossRoll){const a=createInlineRoll(this.sanLossRoll);this.__inlineSanLossRoll=a.outerHTML}this.state.intRolled&&this.intCheck&&(this.__inlineIntCheck=this.intCheck.inlineCheck.outerHTML);const html=await renderTemplate(SanCheckCard.template,this),htmlCardElement=$.parseHTML(html)[0];htmlCardElement.dataset.object=escape(JSON.stringify(this,replacer));const chatMessage=game.messages.get(this.messageId),msg=await chatMessage.update({content:htmlCardElement.outerHTML});return await ui.chat.updateMessage(msg,!1),msg}static get template(){return"systems/CoC7/templates/chat/cards/san-check.html"}static checkTargets(sanData,fastForward=!1){const targets=[...game.user.targets];if(targets.length)for(const t of targets)t.actor.isToken?SanCheckCard.create(t.actor.tokenKey,sanData,{fastForward}):SanCheckCard.create(t.actor.id,sanData,{fastForward});else ui.notifications.warn(game.i18n.localize("CoC7.WarnNoTargetsSanCheck"))}static async create(...args){const chatCard=new SanCheckCard(...args);chatCard.actor.hasIndefInsane&&(chatCard.state.alreadyInsane=!0),chatCard.actor.san<=0&&(chatCard.state.intRolled=!0,chatCard.state.boutOfMadnessOver=!0,chatCard.state.insanity=!0,chatCard.state.permanentlyInsane=!0,chatCard.state.finish=!0);const html=await renderTemplate(SanCheckCard.template,chatCard),htmlCardElement=$.parseHTML(html)[0];htmlCardElement.dataset.object=escape(JSON.stringify(chatCard,replacer)),await chatCard.say(htmlCardElement.outerHTML)}static getFromMessageId(messageId){const message=game.messages.get(messageId),htmlCard=$.parseHTML(message.content)[0].querySelector(".chat-card");return SanCheckCard.getFromCard(htmlCard)}static getFromCard(card){const sanCheckCardData=JSON.parse(unescape(card.dataset.object)),sanCheckCard=new SanCheckCard;return Object.assign(sanCheckCard,sanCheckCardData),sanCheckCard.messageId||(sanCheckCard.messageId=card.closest(".message").dataset.messageId),"Object"===sanCheckCard.sanCheck?.constructor?.name&&(sanCheckCard.sanCheck=Object.assign(new CoC7Check,sanCheckCard.sanCheck)),"Object"===sanCheckCard.intCheck?.constructor?.name&&(sanCheckCard.intCheck=Object.assign(new CoC7Check,sanCheckCard.intCheck)),"Object"===sanCheckCard.sanLossRoll?.constructor?.name&&(sanCheckCard.sanLossRoll=Roll.fromData(sanCheckCard.sanLossRoll)),sanCheckCard}}class SanDataDialog extends Dialog{activateListeners(html){super.activateListeners(html),html.find(":checkbox").click((()=>this._toggleInput(html)))}_toggleInput(html){html.find('*[name="customname"]').toggle()}static async create(options={}){const html=await renderTemplate("systems/CoC7/templates/apps/sandata.html",options);return new Promise((resolve=>{let formData=null;const dlg=new SanDataDialog({title:options.displayName?game.i18n.format("CoC7.SanDataSelectionWindowNamed",{name:options.displayName}):game.i18n.localize("CoC7.SanDataSelectionWindow"),content:html,buttons:{Validate:{label:game.i18n.localize("CoC7.Validate"),callback:html=>(formData=new FormData(html[0].querySelector("#san-data-form")),resolve(formData))}},default:"Validate",close:()=>{}});dlg.render(!0)}))}}class CoC7ChatMessage{static get ROLL_TYPE_ATTRIBUTE(){return"R/AT"}static get ROLL_TYPE_CHARACTERISTIC(){return"R/CH"}static get ROLL_TYPE_COMBAT(){return"R/CO"}static get ROLL_TYPE_SKILL(){return"R/SK"}static get ROLL_TYPE_ENCOUNTER(){return"R/EC"}static get CARD_TYPE_COMBINED(){return"C/CO"}static get CARD_TYPE_GROUP(){return"C/GR"}static get CARD_TYPE_NORMAL(){return"C/NO"}static get CARD_TYPE_OPPOSED(){return"C/OP"}static get CARD_TYPE_SAN_CHECK(){return"C/SC"}static get CARD_TYPE_NONE(){return"C/NO"}static cardTypes(config){if(config.rollType===CoC7ChatMessage.ROLL_TYPE_COMBAT)return null;const select={[CoC7ChatMessage.CARD_TYPE_NORMAL]:"CoC7.RegularRollCard",[CoC7ChatMessage.CARD_TYPE_COMBINED]:"CoC7.CombinedRollCard",[CoC7ChatMessage.CARD_TYPE_OPPOSED]:"CoC7.OpposedRollCard"};return config.rollType===CoC7ChatMessage.ROLL_TYPE_ATTRIBUTE&&"san"===config.attribute&&(select[CoC7ChatMessage.CARD_TYPE_SAN_CHECK]="CoC7.SanityLossEncounter"),select}static normalizeRequest(options){if(void 0!==options.event||void 0===options.cardType||void 0===options.actor||void 0===options.skillId&&void 0===options.skillName&&void 0===options.attribute&&void 0===options.characteristic&&options.rollType!==CoC7ChatMessage.ROLL_TYPE_ENCOUNTER){if(void 0===options.event||void 0===options.cardType||void 0===options.rollType)return ui.notifications.error(game.i18n.format("CoC7.ErrorNotFound",{value:game.i18n.localize("CoC7.Roll")})),!1}else if(void 0!==options.skillId)options.actor.items.get(options.skillId)&&(options.rollType=CoC7ChatMessage.ROLL_TYPE_SKILL);else if(void 0!==options.skillName){const skillIds=options.actor.getSkillsByName(options.skillName);skillIds.length>0&&(options.skillId=skillIds[0].id,options.rollType=CoC7ChatMessage.ROLL_TYPE_SKILL)}else void 0!==options.attribute&&["lck","san"].includes(options.attribute)?options.rollType=CoC7ChatMessage.ROLL_TYPE_ATTRIBUTE:void 0!==options.characteristic&&void 0!==options.actor.system.characteristics[options.characteristic]&&(options.rollType=CoC7ChatMessage.ROLL_TYPE_CHARACTERISTIC);if(![CoC7ChatMessage.CARD_TYPE_COMBINED,CoC7ChatMessage.CARD_TYPE_GROUP,CoC7ChatMessage.CARD_TYPE_NORMAL,CoC7ChatMessage.CARD_TYPE_OPPOSED,CoC7ChatMessage.CARD_TYPE_SAN_CHECK].includes(options.cardType))return ui.notifications.error(game.i18n.format("CoC7.ErrorInvalidFormula",{value:game.i18n.localize("CoC7.ErrorInvalidCardType")})),!1;if(![CoC7ChatMessage.ROLL_TYPE_SKILL,CoC7ChatMessage.ROLL_TYPE_CHARACTERISTIC,CoC7ChatMessage.ROLL_TYPE_ATTRIBUTE,CoC7ChatMessage.ROLL_TYPE_ENCOUNTER].includes(options.rollType))return ui.notifications.error(game.i18n.format("CoC7.ErrorInvalidFormula",{value:game.i18n.localize("CoC7.ErrorInvalidRollType")})),!1;const config={options:{cardType:options.cardType,shiftKey:options.fastForward??options.event?.shiftKey??options.fastForward??!1,altKey:options.event?.altKey??!1,isCtrlKey:isCtrlKey(options.event??!1),createEncounter:options.createEncounter??!1,openLinkTool:options.openLinkTool??!1,sendToChat:options.sendToChat??!1,sendToClipboard:options.sendToClipboard??!1,isCombat:options.event?.currentTarget.classList?.contains("combat")??!1,preventStandby:options.preventStandby??!1,bonusDice:0},dialogOptions:{rollType:options.rollType,cardType:options.cardType,attribute:"",chatMessage:options.chatMessage??!0,forcedCardType:options.forcedCardType??!1,hideDifficulty:options.hideDifficulty??!1}};switch(config.dialogOptions.rollType){case CoC7ChatMessage.ROLL_TYPE_SKILL:case CoC7ChatMessage.ROLL_TYPE_CHARACTERISTIC:case CoC7ChatMessage.ROLL_TYPE_ATTRIBUTE:case CoC7ChatMessage.ROLL_TYPE_ENCOUNTER:if(config.options.skillId=options.skillId??options.event?.currentTarget.closest(".item")?.dataset.skillId,config.options.itemId=options.event?.currentTarget.closest(".item")?.dataset.itemId,config.options.characteristic=options.characteristic??options.event?.currentTarget.parentElement.dataset.characteristic,config.options.attribute=options.attribute??options.event?.currentTarget.parentElement.dataset.attrib,config.dialogOptions.attribute=config.options.attribute,config.options.actorId=options.event?.currentTarget.closest("form").dataset.actorId??options.actor.id,config.options.tokenKey=options.event?.currentTarget.closest("form").dataset.tokenId??options.actor.tokenKey,config.options.weaponAltSkill=options.event?.currentTarget.classList.contains("alternativ-skill"),config.options.actor=options.actor,config.dialogOptions.rollType===CoC7ChatMessage.ROLL_TYPE_SKILL&&config.options.isCombat){const item=config.options.actor.items.get(config.options.itemId);if(!item)return!1;"weapon"===item.type&&(config.options.weaponName=item.name,config.dialogOptions.rollType=CoC7ChatMessage.ROLL_TYPE_COMBAT)}if(void 0===config.options.actorId||void 0===config.options.tokenKey&&void 0===config.options.actor)return ui.notifications.error(game.i18n.format("CoC7.ErrorInvalidFormula",{value:game.i18n.localize("CoC7.ErrorActor")})),!1;if(config.dialogOptions.rollType===CoC7ChatMessage.ROLL_TYPE_SKILL&&void 0===config.options.skillId)return ui.notifications.error(game.i18n.format("CoC7.ErrorInvalidFormula",{value:game.i18n.localize("CoC7.Entities.Skill")})),!1;if(config.dialogOptions.rollType===CoC7ChatMessage.ROLL_TYPE_CHARACTERISTIC){if(void 0===config.options.characteristic)return ui.notifications.error(game.i18n.format("CoC7.ErrorInvalidFormula",{value:game.i18n.localize("CoC7.Characteristic")})),!1;if(!game.user.isGM&&!config.options.actor.system.characteristics[config.options.characteristic]?.value)return!1}else if(config.dialogOptions.rollType===CoC7ChatMessage.ROLL_TYPE_ATTRIBUTE){if(void 0===config.options.attribute)return ui.notifications.error(game.i18n.format("CoC7.ErrorInvalidFormula",{value:game.i18n.localize("CoC7.Attribute")})),!1;if(!game.user.isGM&&!config.options.actor.system.attribs[config.options.attribute]?.value)return!1}else if(config.dialogOptions.rollType===CoC7ChatMessage.ROLL_TYPE_COMBAT){if(void 0===config.options.itemId)return ui.notifications.error(game.i18n.format("CoC7.ErrorInvalidFormula",{value:game.i18n.localize("CoC7.Entities.Weapon")})),!1;if(config.options.altKey)return!1}config.options.hasPlayerOwner=config.options.actor.hasPlayerOwner??!1,config.dialogOptions.rollType===CoC7ChatMessage.ROLL_TYPE_CHARACTERISTIC?(config.dialogOptions.disableFlatThresholdModifier=config.options.isCtrlKey,config.dialogOptions.disableFlatDiceModifier=config.options.isCtrlKey):(config.dialogOptions.disableFlatThresholdModifier=!1,config.dialogOptions.disableFlatDiceModifier=!1),config.dialogOptions.modifier=0,config.dialogOptions.difficulty=options.difficulty??CoC7Check.difficultyLevel[game.settings.get("CoC7","defaultCheckDifficulty")],config.dialogOptions.flatDiceModifier=0,config.dialogOptions.flatThresholdModifier=0}return config}static async trigger(options={}){const config=CoC7ChatMessage.normalizeRequest(options);if(!1!==config)if(config.options.isCtrlKey&&game.user.isGM&&[CoC7ChatMessage.CARD_TYPE_NORMAL,CoC7ChatMessage.CARD_TYPE_SAN_CHECK].includes(config.dialogOptions.cardType))CoC7ChatMessage.createLink(config);else{if(!(config.options.sendToChat||config.options.sendToClipboard||config.options.openLinkTool||config.options.createEncounter)||!game.user.isGM||CoC7ChatMessage.CARD_TYPE_NONE!==config.dialogOptions.cardType){if(void 0!==config.options.actor){if(void 0!==config.options.attribute){const bonusDice=config.options.actor.system?.attribs?.[config.options.attribute]?.bonusDice;bonusDice&&(config.dialogOptions.modifier=bonusDice)}else if(void 0!==config.options.characteristic){const bonusDice=config.options.actor.system?.characteristics?.[config.options.characteristic]?.bonusDice;bonusDice&&(config.dialogOptions.modifier=bonusDice)}else if(void 0!==config.options.itemId){const itemModifiers=Object.values(config.options.actor.system.skills).find((k=>k.foundryID===config.options.itemId));void 0!==itemModifiers?.bonusDice&&(config.dialogOptions.modifier=itemModifiers.bonusDice)}config.dialogOptions.modifier=Math.min(Math.max(config.dialogOptions.modifier,-2),2)}return config.options.shiftKey||await CoC7ChatMessage.createRoll(config),CoC7ChatMessage.runRoll(config)}CoC7ChatMessage.createLink(config)}}static createLink(config){switch(config.dialogOptions.rollType){case CoC7ChatMessage.ROLL_TYPE_ATTRIBUTE:case CoC7ChatMessage.ROLL_TYPE_CHARACTERISTIC:case CoC7ChatMessage.ROLL_TYPE_COMBAT:case CoC7ChatMessage.ROLL_TYPE_SKILL:case CoC7ChatMessage.ROLL_TYPE_ENCOUNTER:{const linkData={type:"CoC7Link"};if(config.dialogOptions.rollType===CoC7ChatMessage.ROLL_TYPE_SKILL){if(linkData.check=CoC7Link.CHECK_TYPE.CHECK,linkData.linkType=CoC7Link.LINK_TYPE.SKILL,linkData.name=config.options.actor.items.get(config.options.skillId)?.shortName,!linkData.name)return}else if(config.dialogOptions.rollType===CoC7ChatMessage.ROLL_TYPE_CHARACTERISTIC)linkData.check=CoC7Link.CHECK_TYPE.CHECK,linkData.linkType=CoC7Link.LINK_TYPE.CHARACTERISTIC,linkData.name=config.options.characteristic;else if(config.dialogOptions.rollType===CoC7ChatMessage.ROLL_TYPE_ATTRIBUTE)(config.options.altKey||config.options.createEncounter)&&"san"===config.options.attribute?linkData.check=CoC7Link.CHECK_TYPE.SANLOSS:(linkData.check=CoC7Link.CHECK_TYPE.CHECK,linkData.linkType=CoC7Link.LINK_TYPE.ATTRIBUTE,linkData.name=config.options.attribute);else if(config.dialogOptions.rollType===CoC7ChatMessage.ROLL_TYPE_COMBAT)linkData.check=CoC7Link.CHECK_TYPE.ITEM,linkData.name=config.options.weaponName;else{if(config.dialogOptions.rollType!==CoC7ChatMessage.ROLL_TYPE_ENCOUNTER)return;linkData.check=CoC7Link.CHECK_TYPE.SANLOSS,linkData.sanMin=config.options.actor?.system?.special?.sanLoss?.checkPassed,linkData.sanMax=config.options.actor?.system?.special?.sanLoss?.checkFailled,linkData.sanReason=config.options.actor.system.infos.type?.length?config.options.actor.system.infos.type:config.options.actor.name}"blindroll"===game.settings.get("core","rollMode")&&(linkData.blind=!0),config.options.sendToChat?CoC7Link.toChatMessage(linkData):config.options.sendToClipboard?CoC7Link.fromDropData(linkData).then((link=>{CoC7Utilities.copyToClipboard(link.link)})):CoC7ContentLinkDialog.create(linkData,{actors:[config.options.actor].filter((a=>a.owners.length)),hasModifiers:config.options.shiftKey})}}}static async createRoll(config){const usage=await RollDialog.create(config.dialogOptions);if(usage){const cardType=usage.get("cardType");cardType&&(config.dialogOptions.cardType=cardType),config.dialogOptions.modifier=Number(usage.get("bonusDice")),config.dialogOptions.difficulty=Number(usage.get("difficulty")),config.dialogOptions.flatDiceModifier=Number(usage.get("flatDiceModifier")),config.dialogOptions.flatThresholdModifier=Number(usage.get("flatThresholdModifier"))}}static async runRoll(config){switch(config.dialogOptions.cardType){case CoC7ChatMessage.CARD_TYPE_SAN_CHECK:{const sanData=await SanDataDialog.create({promptLabel:!0});if(sanData){let sanMin=sanData.get("sanMin")||0,sanMax=sanData.get("sanMax")||0;const sanReason=sanData.get("sanReason");isNaN(Number(sanMin))||(sanMin=Number(sanMin)),isNaN(Number(sanMax))||(sanMax=Number(sanMax)),SanCheckCard.create(config.options.actor.actorKey,{sanMin,sanMax,sanReason},{sanModifier:config.dialogOptions.modifier,sanDifficulty:config.dialogOptions.difficulty,fastForward:config.options.shiftKey})}}break;case CoC7ChatMessage.CARD_TYPE_NORMAL:{const check=new CoC7Check;return check.diceModifier=config.dialogOptions.modifier,check.difficulty=config.dialogOptions.difficulty,check.actor=config.options.tokenKey?config.options.tokenKey:config.options.actorId,check.flatDiceModifier=config.dialogOptions.flatDiceModifier,check.flatThresholdModifier=config.dialogOptions.flatThresholdModifier,check.standby=!config.options.preventStandby&&game.settings.get("CoC7","stanbyGMRolls")&&game.user.isGM&&config.options.hasPlayerOwner,config.dialogOptions.rollType===CoC7ChatMessage.ROLL_TYPE_SKILL?(check.skill=config.options.skillId,check.canBePushed=check._getItemFromId(check.skill)?.system?.properties?.push??!1,await check.roll()):config.dialogOptions.rollType===CoC7ChatMessage.ROLL_TYPE_ATTRIBUTE?await check.rollAttribute(config.options.attribute):await check.rollCharacteristic(config.options.characteristic),config.dialogOptions.chatMessage&&check.toMessage(),{result:check.modifiedResult,successLevel:check.rolledSuccessLevel,isFumble:check.isFumble,isCritical:check.isCritical,successLevels:{1:check.regularThreshold,2:check.hardThreshold,3:check.extremeThreshold},passed:check.passed}}case CoC7ChatMessage.CARD_TYPE_OPPOSED:case CoC7ChatMessage.CARD_TYPE_COMBINED:{const check=new CoC7Check;check.actor=config.options.tokenKey?config.options.tokenKey:config.options.actorId,check.characteristic=config.options.characteristic,check.attribute=config.options.attribute,check.skillId=config.options.skillId,check.rollMode=game.settings.get("core","rollMode"),check.initiator=game.user.id;let data={};config.dialogOptions.cardType===CoC7ChatMessage.CARD_TYPE_OPPOSED?(data={type:OpposedCheckCard.defaultConfig.type,combat:config.options.isCombat,action:"new"},check.item=config.options.itemId,check.weaponAltSkill=config.options.weaponAltSkill,check.denyPush=!0,await check._perform()):(data={type:CombinedCheckCard.defaultConfig.type,action:"new"},check.difficulty=config.dialogOptions.difficulty),data.roll=check.JSONRollData,data._rollMode=game.settings.get("core","rollMode"),config.dialogOptions.cardType===CoC7ChatMessage.CARD_TYPE_OPPOSED?OpposedCheckCard.dispatch(data):CombinedCheckCard.dispatch(data)}}}}class CoC7ConCheck{constructor(actorId=null,difficulty=CoC7Check.difficultyLevel.regular){this.check=new CoC7Check(actorId),this.check.characteristic="con",this.check.difficulty=difficulty,this.check.denyPush=!0,this.actorId=actorId}get isBlind(){return void 0===this._isBlind&&(this._isBlind="blindroll"===this.rollMode),this._isBlind}set isBlind(x){this._isBlind=x}get rollMode(){return this._rollMode||(this._rollMode=game.settings.get("core","rollMode")),this._rollMode}set rollMode(x){!1===x&&(this._rollMode=game.settings.get("core","rollMode")),this._rollMode=x}get actor(){return this.actorId?chatHelper.getActorFromKey(this.actorId):null}set actorId(x){this._actorId=x,this.check.actor=x}get actorId(){return this._actorId?this._actorId:null}get tokenKey(){return this.actor.isToken?this.actor.tokenKey:null}get isSuccess(){return!!this.check&&this.check.isSuccess}get isRolled(){return!!(this.check&&this.check.dices&&this.check.dices.total)}static getFromCard(card){const conCheck=new CoC7ConCheck;chatHelper.getObjectFromElement(conCheck,card);const htmlCheck=card.querySelector(".roll-result");return CoC7Roll.getFromElement(htmlCheck,conCheck.check),conCheck.messageId=card.closest(".message").dataset.messageId,conCheck}async getCheckElement(){const html=await renderTemplate("systems/CoC7/templates/chat/roll-result.html",this.check),htmlElement=$.parseHTML(html)[0];return htmlElement?(htmlElement.classList.remove("chat-card","item-card","roll-card"),htmlElement):null}async toMessage(fastForward=!1){fastForward&&await this.rollCon();const html=await renderTemplate("systems/CoC7/templates/chat/con-check.html",this),htmlElement=$.parseHTML(html)[0];if(fastForward){htmlElement.querySelector(".roll-result").replaceWith(await this.getCheckElement())}const speakerData={};let speaker;this.actor?(this.token?speakerData.token=this.token:speakerData.actor=this.actor,speaker=ChatMessage.getSpeaker(speakerData)):speaker=ChatMessage.getSpeaker();const chatData={user:(this.actor.user?this.actor.user:game.user).id,speaker,flavor:this.flavor,content:htmlElement.outerHTML};["gmroll","blindroll"].includes(game.settings.get("core","rollMode"))&&(chatData.whisper=ChatMessage.getWhisperRecipients("GM")),"blindroll"===this.rollMode&&(chatData.blind=!0),ChatMessage.create(chatData).then((msg=>msg))}async rollCon(){this.check.hideDiceResult=!0,await this.check._perform(),this.isBlind||this.isRolled||this.isSuccess||(this.stayAlive?await this.actor.setCondition(COC7.status.dead):await this.actor.setCondition(COC7.status.unconscious)),this.applied=!0}async updateChatCard(){const html=await renderTemplate("systems/CoC7/templates/chat/con-check.html",this),htmlElement=$.parseHTML(html)[0];if(htmlElement.querySelector(".roll-result").replaceWith(await this.getCheckElement()),this.isBlind||!this.isRolled||this.isSuccess||(this.stayAlive?await this.actor.setCondition(COC7.status.dead):await this.actor.setCondition(COC7.status.unconscious)),!this.messageId)return;const chatMessage=game.messages.get(this.messageId),msg=await chatMessage.update({content:htmlElement.outerHTML});return await ui.chat.updateMessage(msg,!1),msg}}class SkillSelectDialog extends Dialog{activateListeners(html){super.activateListeners(html),html.find(".select-skill").click((async event=>this._onSelectSkillClicked(event)))}async _onSelectSkillClicked(event){const li=event.currentTarget.closest(".item");this.data.data.skills[Number(li.dataset.index)].selected=!0,event.currentTarget.style.display="none",this.data.data.added||(this.data.data.added=0),this.data.data.added++;event.currentTarget.closest(".skill-selector").querySelector(".count").innerText=this.data.data.added,this.data.data.added>=this.data.data.optionsCount&&this.close()}static async create(data){const html=await renderTemplate("systems/CoC7/templates/apps/skill-select.html",data);return new Promise((resolve=>{new SkillSelectDialog({title:data.title,content:html,data,buttons:{},close:()=>{if(!data.added>=data.optionsCount)return resolve(!1);const selected=data.skills.filter((skill=>skill.selected));return resolve(selected)}},{classes:["coc7","dialog","skill-select"]}).render(!0)}))}}class PointSelectDialog extends Dialog{activateListeners(html){super.activateListeners(html),html.find(".item-name").click((async event=>this._onSelectCharacteristic(event))),html.find("button").click((event=>this._onButtonClicked(event)))}async _onSelectCharacteristic(event){const li=event.currentTarget.closest(".item"),itemList=li.closest(".item-list");for(const item of itemList.querySelectorAll(".selectable"))item.classList.remove("selected"),this.data.data.characteristics[item.dataset.key].selected=!1,this.data.data.characteristics[item.dataset.key].optional=!1;$(li).toggleClass("selected"),this.data.data.characteristics[li.dataset.key].selected=!0;li.closest("#skill-selection-form").querySelector(".points").innerText=this.data.data.total+this.data.data.characteristics[li.dataset.key].multiplier*this.data.data.characteristics[li.dataset.key].value;li.closest("#skill-selection-form").querySelector("button.validate").classList.remove("inactive"),this.data.data.resolved=!0}async _onButtonClicked(event){event.preventDefault(),event.currentTarget.classList.contains("inactive")||super.close()}static async create(data){const html=await renderTemplate("systems/CoC7/templates/apps/point-select.html",data);return new Promise((resolve=>{new PointSelectDialog({title:data.title,content:html,data,buttons:{},close:()=>data.resolved?resolve(data):resolve(!1)},{classes:["coc7","dialog","char-select"]}).render(!0)}))}}class CharacSelectDialog extends Dialog{activateListeners(html){super.activateListeners(html),html.find(".item-name").click((async event=>this._onSelectCharacteristic(event)))}async _onSelectCharacteristic(event){const li=event.currentTarget.closest(".item");this.data.data.selected=li.dataset.key,this.close()}static async create(data){const html=await renderTemplate("systems/CoC7/templates/apps/char-select.html",data);return new Promise((resolve=>{new CharacSelectDialog({title:data.title,content:html,data,buttons:{},close:()=>data.selected?resolve(data.selected):resolve(!1)},{classes:["coc7","dialog","char-select"]}).render(!0)}))}}class CharacRollDialog extends Dialog{constructor(data,options){super(data,options),this.rolled=data.rolled||{}}activateListeners(html){super.activateListeners(html),html.on("change","input",this._onChangeInput.bind(this)),html.on("submit","form",this._onSubmit.bind(this)),html.on("click",".roll-characteristic",this._onRollCharacteristic.bind(this)),html.on("click",".increase-characteristic",this._onIncreaseCharacteristic.bind(this)),html.on("click",".decrease-characteristic",this._onDecreaseCharacteristic.bind(this)),html.on("click",".reset-characteristic",this._onResetCharacteristic.bind(this)),html.on("click","button",this._onButton.bind(this))}async _onRollCharacteristic(event){event.preventDefault();const characKey=event.currentTarget.closest(".item").dataset.key;await this.rollCharacteristic(characKey)}async _onIncreaseCharacteristic(event){event.preventDefault();const characKey=event.currentTarget.closest(".item").dataset.key;this.increaseCharacteristic(characKey)}async _onDecreaseCharacteristic(event){event.preventDefault();const characKey=event.currentTarget.closest(".item").dataset.key;this.decreaseCharacteristic(characKey)}async _onResetCharacteristic(event){event.preventDefault();const characKey=event.currentTarget.closest(".item").dataset.key;this.resetCharacteristic(characKey)}async _onButton(event){const action=event.currentTarget.dataset.action;if("roll"===action)for(const char of["str","con","siz","dex","app","int","pow","edu","luck"])await this.rollCharacteristic(char);this.checkTotal(),"validate"===action&&this.data.data.validate&&this.close()}async rollCharacteristic(key){const li=this._element[0].querySelector(`li.item[data-key=${key}]`),input=li?.querySelector("input"),formula=this.data.data.characteristics.rolls[key];if(input&&formula){if(isNaN(Number(formula))){const roll=new Roll(formula);await roll.evaluate({async:!0}),roll.toMessage({flavor:game.i18n.format("CoC7.MessageRollingCharacteristic",{label:this.data.data.characteristics.list[key].label,formula})}),input.value=roll.total}else input.value=Number(formula);this.data.data.characteristics.values[key]=Number(input.value),this.rolled||(this.rolled={}),this.rolled[key]=!0}this.checkTotal()}async increaseCharacteristic(key){const li=this._element[0].querySelector(`li.item[data-key=${key}]`),input=li?.querySelector("input");input&&(input.value=Number(input.value)+1,this.data.data.characteristics.values[key]=Number(input.value)),this.checkTotal()}async decreaseCharacteristic(key){const li=this._element[0].querySelector(`li.item[data-key=${key}]`),input=li?.querySelector("input");input&&Number(input.value)>0&&(input.value=Number(input.value)-1,this.data.data.characteristics.values[key]=Number(input.value)),this.checkTotal()}async resetCharacteristic(key){const li=this._element[0].querySelector(`li.item[data-key=${key}]`),input=li?.querySelector("input");input&&(input.value=null,this.data.data.characteristics.values[key]=0),this.checkTotal()}async _onChangeInput(event){event.preventDefault();const input=event.currentTarget,value=Number(input.value);isNaN(value)||(this.data.data.characteristics.values[input.name]=value),this.checkTotal()}checkTotal(){this.data.data.characteristics.points.total=0;for(const[key,value]of Object.entries(this.data.data.characteristics.values))"luck"!==key&&(this.data.data.characteristics.points.total+=value);const validation=this._element[0].querySelector(".points");if(this.data.data.characteristics.points.enabled){Number(this.data.data.characteristics.points.total)!==Number(this.data.data.characteristics.points.value)?(validation.classList.add("warning"),this.data.data.validate=!1):(validation.classList.remove("warning"),this.data.data.validate=!0);validation.querySelector(".value").innerText=this.data.data.characteristics.points.value}validation.querySelector(".total").innerText=this.data.data.characteristics.points.total,this.data.data.characteristics.rolls.enabled&&(this.data.data.validate=0===Object.values(this.data.data.characteristics.values).filter((val=>isNaN(parseInt(val)))).length)}async _onSubmit(event){event.preventDefault()}static async create(data){const rolled={};data.characteristics.points.total=0;for(const[key,value]of Object.entries(data.characteristics.values))"luck"!==key&&(data.characteristics.points.total+=value||0),!isNaN(value)&&value>0&&(rolled[key]=!0);data.characteristics.points.enabled&&Number(data.characteristics.points.total)!==Number(data.characteristics.points.value)&&(data.pointsWarning=!0);const html=await renderTemplate("systems/CoC7/templates/apps/char-roll.html",data);return new Promise((resolve=>{new CharacRollDialog({title:data.title,content:html,data,rolled,buttons:{},close:()=>data.validate?resolve(!0):resolve(!1)},{classes:["coc7","dialog","char-select"]}).render(!0)}))}}class ExperiencePackageDialog extends Dialog{constructor(data,options){super(data,options),this.templateData=options.templateData}activateListeners(html){super.activateListeners(html);new DragDrop({dropSelector:".flexcol.coc7",permissions:{drop:game.user.isGM},callbacks:{drop:this._onDrop.bind(this)}}).bind(html[0]),html.find(".rollvalue").click((event=>this._onRollValue(event))),html.find(".item-delete").click((event=>this._onDeleteItem(event))),html.find("select").change((event=>this._onChangeBackstory(event))),html.find("textarea").each(((offset,tag)=>tag.addEventListener("keyup",(event=>this._onChangeBackstoryText(event))))),html.find("input[type=checkbox]").click((event=>this._onClickCheckbox(event))),html.find(".backstoryBlock").find("input[type=text]").each(((offset,tag)=>tag.addEventListener("keyup",(event=>this._onChangeBackstoryInput(event)))))}async _onChangeBackstoryText(event){const index=event.target.closest(".backstoryBlock").dataset.index;index&&"CoC7.PromptAddInjuryScar"===this.templateData.backstory[index].type&&(this.templateData.backstory[index].value=event.target.value)}async _onChangeBackstoryInput(event){const index=event.target.closest(".backstoryBlock").dataset.index,key=event.target.dataset.name;index&&"CoC7.AddSanityLossEncounter"===this.templateData.backstory[index].type&&(this.templateData.backstory[index].value[key]=event.target.value)}async _onDrop(event){const dataString=event.dataTransfer.getData("text/plain");if(""===dataString)return!1;const data=JSON.parse(dataString);if("Item"===data.type&&"string"==typeof data.uuid){const doc=await fromUuid(data.uuid);if("spell"===doc.type&&this.templateData.system.addSpells)this.templateData.spells.find((d=>d._id===doc._id))||(this.templateData.spells.push(doc),this.refreshDialog());else if("status"===doc.type){const block=event.target.closest(".backstoryBlock");if(block){const index=block.dataset.index,doc=await fromUuid(data.uuid);index&&"status"===doc.type&&"CoC7.PromptAddStatus"===this.templateData.backstory[index].type&&(this.templateData.backstory.find((d=>d.value._id===doc._id))||(this.templateData.backstory[index].value=doc,this.refreshDialog()))}}}}async _onClickCheckbox(event){const block=event.target.closest(".backstoryBlock");if(block){const index=block.dataset.index;index&&"CoC7.AddSanityLossEncounter"===this.templateData.backstory[index].type&&(this.templateData.backstory[index].value.apply=!this.templateData.backstory[index].value.apply)}}async refreshDialog(){this.data.content=await renderTemplate("systems/CoC7/templates/apps/experience-package-dialog.hbs",this.templateData),this.render(!0)}async _onRollValue(event){if(event.preventDefault(),!1===this.templateData.rolled){let formula=!1;this.templateData.system.properties.cthulhuGain?formula=this.templateData.system.cthulhuGain:this.templateData.system.properties.sanityLoss&&(formula=this.templateData.system.sanityLoss),!1!==formula&&(this.templateData.rolled=(await new Roll(formula).evaluate()).total,this.refreshDialog())}}async _onChangeBackstory(event){const index=event.currentTarget.dataset.backstoryIndex;if(void 0!==this.templateData.backstory[index]){switch(this.templateData.backstory[index].type=event.currentTarget.value,this.templateData.backstory[index].type){case"":case"CoC7.PromptAddStatus":this.templateData.backstory[index].value=!1;break;case"CoC7.PromptAddInjuryScar":this.templateData.backstory[index].value="";break;case"CoC7.AddSanityLossEncounter":this.templateData.backstory[index].value={reason:"",points:"",apply:!0}}this.refreshDialog()}}async _onDeleteItem(event){event.preventDefault();const tag=event.currentTarget.closest(".item"),itemId=tag.dataset.itemId;switch(tag.dataset.type){case"spell":{const index=this.templateData.spells.findIndex((doc=>doc._id===itemId));index>-1&&(this.templateData.spells.splice(index,1),this.refreshDialog())}break;case"status":{const index=this.templateData.backstory.findIndex((doc=>"CoC7.PromptAddStatus"===doc.type&&doc.value._id===itemId));index>-1&&(this.templateData.backstory[index].value=!1,this.refreshDialog())}}}static async create(system){const data={backstory:[],backstoryOptions:{"CoC7.PromptAddInjuryScar":"CoC7.PromptAddInjuryScar","CoC7.PromptAddStatus":"CoC7.PromptAddStatus","CoC7.AddSanityLossEncounter":"CoC7.AddSanityLossEncounter"},rolled:!1,spells:[],system};for(let count=0;count<system.backgroundQty;count++)data.backstory.push({type:"",value:!1});const html=await renderTemplate("systems/CoC7/templates/apps/experience-package-dialog.hbs",data);return new Promise((resolve=>{const dlg=new ExperiencePackageDialog({title:game.i18n.localize("CoC7.ExperiencePackageDialogTitle"),content:html,buttons:{close:{icon:'<i class="fas fa-ban"></i>',label:game.i18n.localize("Cancel"),callback:()=>{resolve(!1)}},save:{icon:'<i class="fas fa-check"></i>',label:game.i18n.localize("CoC7.Validate"),callback:async()=>{const output={"i.skill.cthulhu-mythos":dlg.templateData.rolled&&dlg.templateData.system.properties.cthulhuGain?dlg.templateData.rolled:0,SAN:dlg.templateData.rolled&&(dlg.templateData.system.properties.sanitySame||dlg.templateData.system.properties.sanityLoss)?dlg.templateData.rolled:0,items:[],backstory:[],encounters:[]};for(const doc of dlg.templateData.spells)output.items.push(doc);for(const name of dlg.templateData.system.immunity)output.encounters.push({type:name,totalLoss:0,immunity:!0});for(const type of dlg.templateData.backstory)switch(type.type){case"CoC7.PromptAddInjuryScar":{const element=document.createElement("p"),value=document.createTextNode(type.value);element.appendChild(value),output.backstory.push(element.outerHTML)}break;case"CoC7.PromptAddStatus":type.value&&output.items.push(type.value);break;case"CoC7.AddSanityLossEncounter":console.log("CoC7.AddSanityLossEncounter",type),output.encounters.push({type:type.value.reason,totalLoss:type.value.points,immunity:!1}),type.value.apply&&(output.SAN=output.SAN+parseInt(type.value.points,10))}resolve(output)}}},default:"save"},{classes:["coc7","dialog","char-select"],templateData:data});dlg.render(!0)}))}}class SkillSpecSelectDialog{static async create(skills,specializationName,baseValue=null,name=null){const html=await renderTemplate("systems/CoC7/templates/apps/skill-spec-select.html",{hasSkills:skills.length>0,skills,base:baseValue,name});return new Promise((resolve=>{let formData=null;const dlg=new Dialog({title:name?game.i18n.format("CoC7.SkillSelectBase",{name}):game.i18n.format("CoC7.SkillSpecSelectTitle",{specialization:specializationName}),content:html,buttons:{validate:{label:game.i18n.localize("CoC7.Validate"),callback:html=>(formData=new FormData(html[0].querySelector("#skill-select-form")),resolve(formData))}},default:"validate",close:()=>resolve(!1)});dlg.render(!0)}))}}class SkillSpecializationSelectDialog extends FormApplication{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{classes:["coc7","skill-name-dialog"],title:"",template:"systems/CoC7/templates/apps/skill-specialization-select.hbs",width:400,height:"auto",closeOnSubmit:!1})}get title(){return game.i18n.format("CoC7.SkillSpecSelectTitle",{specialization:this.object.specializationName})}activateListeners(html){super.activateListeners(html),html.find(".submit-button").click(this._onClickSubmit.bind(this)),html.find("[name=existing-skill]").change(this._onSelectChange.bind(this))}async _onSelectChange(event){this.object.selected=event.currentTarget.value,this.render(!0)}async _onClickSubmit(event){if(""===this.object.selected){const obj=$(event.currentTarget).closest("form");this.object.name=obj.find("input[name=new-skill-name]").val()??"",this.object.baseValue=obj.find("input[name=base-value]").val()??""}if(""===this.object.selected&&""===this.object.name)return!1;this.object.resolve({selected:this.object.selected,name:this.object.name,baseValue:this.object.baseValue}),this.close()}async _updateObject(event,formData){}static async create({skills=[],allowCustom=!1,fixedBaseValue=!1,specializationName="",label="",baseValue=null}={}){const select=[];for(const skill of skills)select.push({id:skill.id,name:skill.name,base:skill.system.base});return await new Promise((resolve=>{new SkillSpecializationSelectDialog({specializationName,allowCustom,fixedBaseValue,allowSelect:skills.length>0,skills:select,selected:"",name:"",label,baseValue,resolve},{}).render(!0)}))}}class SkillValueDialog{static async create(name=null,baseValue=null){const html=await renderTemplate("systems/CoC7/templates/apps/skill-value.html",{base:baseValue,name});return new Promise((resolve=>{let formData=null;const dlg=new Dialog({title:game.i18n.format("CoC7.SkillValue",{name}),content:html,buttons:{validate:{label:game.i18n.localize("CoC7.Validate"),callback:html=>(formData=new FormData(html[0].querySelector("#skill-select-form")),resolve(formData))}},default:"validate",close:()=>resolve(!1)});dlg.render(!0)}))}}class CoC7MeleeResoltion{constructor(initiatorMessage=null,targetMessage=null,messageId=null){this.initiatorMessage=initiatorMessage,this.targetMessage=targetMessage,this.messageId=messageId}async preCreateMessage(){const html=await renderTemplate(this.template,this),chatData={user:game.user.id,content:html},rollMode=game.settings.get("core","rollMode");["gmroll","blindroll"].includes(rollMode)&&(chatData.whisper=ChatMessage.getWhisperRecipients("GM")),chatData.blind=!1;const chatMessage=await ChatMessage.create(chatData);return this.messageId=chatMessage.id,chatMessage}get displayActorOnCard(){return game.settings.get("CoC7","displayActorOnCard")}get target(){return this.targetMessage?CoC7MeleeTarget.getFromMessageId(this.targetMessage):null}get targetToken(){return this.target?chatHelper.getTokenFromKey(this.target.actorKey):null}get initiator(){return this.initiatorMessage?CoC7MeleeInitiator.getFromMessageId(this.initiatorMessage):null}get initiatorToken(){return this.initiator?chatHelper.getTokenFromKey(this.initiator.actorKey):null}async resolve(){if(this.target)switch(this.target.action){case"noResponse":this.initiator.roll.successLevel>0?(this.resultString=game.i18n.format("CoC7.WinnerRollDamage",{name:this.initiator.name}),this.action="roll-melee-damage",this.rollDamage=!0):(this.resultString=game.i18n.format("CoC7.InitiatorMissed",{name:this.initiator.name}),this.winner=this.initiator,this.rollDamage=!1),this.winner=this.initiator,this.winnerImg=this.initiator.weapon.img,this.winnerTitle=this.initiator.weapon.name,this.looser=this.target;break;case"dodge":this.initiator.roll.successLevel<=0&&this.target.roll.successLevel<=0?(this.resultString=game.i18n.localize("CoC7.NoWinner"),this.winner=null,this.rollDamage=!1):this.initiator.roll.successLevel>this.target.roll.successLevel?(this.resultString=game.i18n.format("CoC7.WinnerRollDamage",{name:this.initiator.name}),this.winner=this.initiator,this.winnerImg=this.initiator.weapon.img,this.winnerTitle=this.initiator.weapon.name,this.looser=this.target,this.action="roll-melee-damage",this.rollDamage=!0):this.initiator.roll.successLevel<=this.target.roll.successLevel&&(this.resultString=game.i18n.format("CoC7.DodgeSuccess",{name:this.target.name}),this.winner=this.target,this.looser=this.initiator,this.winnerImg=this.target.skill.img,this.winnerTitle=this.target.skill.name,this.action="dodge",this.rollDamage=!1);break;case"fightBack":this.initiator.roll.successLevel<=0&&this.target.roll.successLevel<=0?(this.resultString=game.i18n.localize("CoC7.NoWinner"),this.winner=null,this.rollDamage=!1):this.initiator.roll.successLevel>=this.target.roll.successLevel?(this.resultString=game.i18n.format("CoC7.WinnerRollDamage",{name:this.initiator.name}),this.winner=this.initiator,this.winnerImg=this.initiator.weapon.img,this.winnerTitle=this.initiator.weapon.name,this.looser=this.target,this.rollDamage=!0):this.initiator.roll.successLevel<=this.target.roll.successLevel&&(this.resultString=game.i18n.format("CoC7.WinnerRollDamage",{name:this.target.name}),this.winner=this.target,this.winnerImg=this.target.weapon.img,this.winnerTitle=this.target.weapon.name,this.looser=this.initiator,this.rollDamage=!0);break;case"maneuver":this.initiator.roll.successLevel<=0&&this.target.roll.successLevel<=0?(this.resultString=game.i18n.localize("CoC7.NoWinner"),this.winner=null,this.rollDamage=!1):this.initiator.roll.successLevel>=this.target.roll.successLevel?(this.resultString=game.i18n.format("CoC7.WinnerRollDamage",{name:this.initiator.name}),this.winner=this.initiator,this.winnerImg=this.initiator.weapon.img,this.winnerTitle=this.initiator.weapon.name,this.looser=this.target,this.rollDamage=!0):this.initiator.roll.successLevel<=this.target.roll.successLevel&&(this.resultString=game.i18n.format("CoC7.ManeuverSuccess",{name:this.target.name}),this.winner=this.target,this.winnerImg=this.target.skill.data.img,this.winnerTitle=this.target.skill.name,this.looser=this.initiator,this.rollDamage=!1)}else this.initiator.roll.successLevel>0?(this.resultString=game.i18n.format("CoC7.WinnerRollDamage",{name:this.initiator.name}),this.winner=this.initiator,this.rollDamage=!0):(this.resultString=game.i18n.format("CoC7.InitiatorMissed",{name:this.initiator.name}),this.winner=this.initiator,this.rollDamage=!1);this.winner&&(this.winner.roll.successLevel>=CoC7Check.successLevel.extreme&&"initiator"===this.winner.roll.side?this.winner.roll.criticalDamage=!0:this.winner.roll.criticalDamage=!1),this.resolved=!0;const html=await renderTemplate(this.template,this);if(this.messageId){const message=game.messages.get(this.messageId),speakerData={};this.winner&&(this.winner.token&&(speakerData.token=this.winner.token.documment),this.winner.actor&&(speakerData.actor=this.winner.actor));const speaker=this.winner?ChatMessage.getSpeaker(speakerData):null,user=this.winner&&this.winner.actor.user?this.winner.actor.user:game.user;let msg;return message?(msg=speaker?await message.update({user:user.id,speaker,content:html}):await message.update({user:user.id,content:html}),await ui.chat.updateMessage(msg,!1),msg):void ui.notifications.warn("Resolition card missing, was deleted ?")}}get template(){return"systems/CoC7/templates/chat/combat/melee-resolution.html"}}class CoC7MeleeTarget extends ChatCardActor{constructor(actorKey,parentMessageId=null,fastForward=!1){super(actorKey,fastForward),this.actorKey=actorKey,this.initiatorKey=null,this.parentMessageId=parentMessageId,this.fastForward=fastForward,this.resolved=!1,this.outnumbered=!1,this.surprised=!1,this.autoSuccess=!1,this.diceModifier=0,this.messageId=null,this.skillId=null,this.itemId=null,this.dodging=!1,this.notResponding=!1,this.fightingBack=!1,this.maneuvering=!1}get actionSelected(){return this.dodging||this.notResponding||this.fightingBack||this.maneuvering}get action(){return this.dodging?"dodge":this.notResponding?"noResponse":this.fightingBack?"fightBack":this.maneuvering?"maneuver":null}get weapon(){return this.actor.items.get(this.itemId)}get skill(){return this.actor.items.get(this.skillId)}set initiatorKey(x){this._initiatorKey=x,this.targetKey=x}get initiatorKey(){return this._initiatorKey||(!this._initiator&&this.parentMessageId&&(this._initiator=CoC7MeleeInitiator.getFromMessageId(this.parentMessageId)),this._initiator&&(this._initiatorKey=this._initiator.actorKey)),this._initiatorKey?this._initiatorKey:(ui.notifications.error(`No initiator found for target : ${this.actor.name}`),null)}get initiator(){if(!this.initiatorKey){if(!this.parentMessageId)return null;this._initiator=CoC7MeleeInitiator.getFromMessageId(this.parentMessageId),this.initiatorKey=this._initiator.actorKey}return chatHelper.getActorFromKey(this.initiatorKey)}get meleeInitiator(){return this._initiator||(this._initiator=CoC7MeleeInitiator.getFromMessageId(this.parentMessageId)),this._initiator}get template(){return"systems/CoC7/templates/chat/combat/melee-target.html"}static getFromMessageId(messageId){const message=game.messages.get(messageId);if(!message)return null;const card=$(message.content)[0],target=CoC7MeleeTarget.getFromCard(card,messageId);return target.messageId=messageId,target}static updateCardSwitch(event,publishUpdate=!0){const card=event.currentTarget.closest(".melee.target"),flag=event.currentTarget.dataset.flag,camelFlag=chatHelper.hyphenToCamelCase(flag);if(publishUpdate){const target=CoC7MeleeTarget.getFromCard(card);target.toggleFlag(flag),target.updateChatCard()}else card.dataset[camelFlag]="true"!==card.dataset[camelFlag],event.currentTarget.classList.toggle("switched-on"),event.currentTarget.dataset.selected=card.dataset[camelFlag]}toggleFlag(flagName){const flag=flagName.includes("-")?chatHelper.hyphenToCamelCase(flagName):flagName;switch(this[flag]=!this[flag],flag){case"outnumbered":case"surprised":this.diceModifier=Math.max(-2,Math.min(2,parseInt(this.diceModifier,10)+(this[flag]?1:-1)))}}async createChatCard(){const html=await renderTemplate(this.template,this),speakerData={},token=chatHelper.getTokenFromKey(this.actorKey);token?speakerData.token=token.document:speakerData.actor=this.actor;const speaker=ChatMessage.getSpeaker(speakerData);this.actor.isToken&&(speaker.alias=this.actor.token.name);let user=game.user;if(void 0===this.actor.user){let owners=[];const gms=game.users.filter((a=>a.isGM)).map((a=>a.id));for(const[k,v]of Object.entries(this.actor.ownership))if(v===CONST.DOCUMENT_OWNERSHIP_LEVELS.OWNER){if("default"===k){owners=game.users.map((a=>a.id));break}gms.includes(k)||owners.push(k)}let content="";switch(owners.length){case 0:break;case 1:void 0!==game.users.get(owners[0])&&(user=game.users.get(owners[0]));break;default:content="<p>"+game.i18n.localize("CoC7.MessageSelectSingleUserForTarget"),content+='<form id="selectform"><select name="user">';for(const k of owners){const user=game.users.get(k);user&&(content=content+'<option value="'+k+'">'+user.name+"</option>")}content+="</select></form></p>",await Dialog.prompt({title:game.i18n.localize("CoC7.MessageTitleSelectSingleUserForTarget"),content,callback:html=>{const formData=new FormData(html[0].querySelector("#selectform"));for(const[name,value]of formData)"user"===name&&(user=game.users.get(value))}})}}else void 0!==this.actor.user&&(user=this.actor.user);const chatData={user:user.id,speaker,content:html};["gmroll","blindroll"].includes(this.rollMode)&&(chatData.whisper=ChatMessage.getWhisperRecipients("GM")),chatData.blind=!1;const message=await ChatMessage.create(chatData);return this.messageId=message.id,message}async updateChatCard(){const message=game.messages.get(this.messageId);if(!game.user.isGM&&message.user.id!==game.user.id)return void ui.notifications.info(game.i18n.localize("CoC7.UnableToInteractWithChatCard"));const html=await renderTemplate(this.template,this),msg=await message.update({content:html});return await ui.chat.updateMessage(msg,!1),msg}async getUpdatedChatCard(){renderTemplate(this.template,this).then((html=>html))}static async updateSelected(card,event){const target=CoC7MeleeTarget.getFromCard(card);switch(event.currentTarget.dataset.action){case"dodge":target.dodging=!0,target.notResponding=!1,target.fightingBack=!1,target.maneuvering=!1,target.skillId=event.currentTarget.dataset.skillId,target.itemId=null;break;case"noResponse":target.dodging=!1,target.notResponding=!0,target.fightingBack=!1,target.maneuvering=!1,target.skillId=null,target.itemId=null;break;case"fightBack":target.dodging=!1,target.notResponding=!1,target.fightingBack=!0,target.maneuvering=!1,target.skillId=event.currentTarget.dataset.skillId,target.itemId=event.currentTarget.dataset.weaponId;break;case"maneuver":target.dodging=!1,target.notResponding=!1,target.fightingBack=!1,target.maneuvering=!0,target.skillId=event.currentTarget.dataset.skillId,target.itemId=null}return target.updateChatCard(),target}async performSkillCheck(skillId=null,publish=!1){const check=new CoC7Check;return check.isBlind=!1,check.isUnkonwn=!1,check.referenceMessageId=this.messageId,check.rollType="opposed",check.side="target",check.action=this.action,check.actor=this.actor,check.item=this.itemId,check.skill=skillId,check.difficulty=CoC7Check.difficultyLevel.regular,check.diceModifier=0,this.diceModifier&&(check.diceModifier=this.diceModifier),await check.roll(),this.check=check,this.rolled=!0,this.resolved=!0,publish&&check.toMessage(),check}async publishNoReponseResult(){this.rolled=!0,this.resolved=!0,this.notResponding=!0;const resolutionCard=new CoC7MeleeResoltion(this.parentMessageId,this.messageId),resolutionMessage=await resolutionCard.preCreateMessage();this.resolutionCard=resolutionMessage.id,await this.updateChatCard()}async publishCheckResult(check=null){if(!check&&!this.check)return null;if(check&&(this.check=check),this.roll=CoC7Roll.getFromCheck(this.check),this.rolled=!0,this.roll.rollIcons=[],this.roll.critical){this.roll.rollColor="goldenrod",this.roll.rollTitle=game.i18n.localize("CoC7.CriticalSuccess");for(let index=0;index<4;index++)this.roll.rollIcons.push("medal")}else if(this.roll.fumble){this.roll.rollColor="darkred",this.roll.rollTitle=game.i18n.localize("CoC7.Fumble");for(let index=0;index<4;index++)this.roll.rollIcons.push("spider")}else if(this.roll.success){this.roll.rollColor="goldenrod",CoC7Check.successLevel.regular===this.roll.successLevel&&(this.roll.rollTitle=game.i18n.localize("CoC7.RegularSuccess")),CoC7Check.successLevel.hard===this.roll.successLevel&&(this.roll.rollTitle=game.i18n.localize("CoC7.HardSuccess")),CoC7Check.successLevel.extreme===this.roll.successLevel&&(this.roll.rollTitle=game.i18n.localize("CoC7.ExtremeSuccess"));for(let index=0;index<this.roll.successLevel;index++)this.roll.rollIcons.push("star")}else this.roll.rollColor="black",this.roll.rollTitle=game.i18n.localize("CoC7.Failure"),this.roll.rollIcons.push("skull");const resolutionCard=new CoC7MeleeResoltion(this.parentMessageId,this.messageId),resolutionMessage=await resolutionCard.preCreateMessage();this.resolutionCard=resolutionMessage.id,await this.updateChatCard()}static getFromCard(card,messageId=null){const actorKey=card.dataset.actorKey,parentMessageId=card.dataset.parentMessageId,fastForward="true"===card.dataset.fastForward,target=new CoC7MeleeTarget(actorKey,parentMessageId,fastForward);return target.roll=CoC7Roll.getFromCard(card),chatHelper.getObjectFromElement(target,card),card.closest(".message")?target.messageId=card.closest(".message").dataset.messageId:target.messageId=messageId,target}upgradeRoll(luckAmount,newSuccessLevel,oldCard){this.actor.spendLuck(luckAmount)||ui.notifications.error(`${this.actor.name} didn't have enough luck to pass the check`),this.roll.value=null,this.roll.successLevel=newSuccessLevel,this.roll.luckSpent=!0,oldCard.dataset.processed=!1;const diceRolls=oldCard.querySelector(".dice-roll");diceRolls.dataset.value=null,diceRolls.dataset.successLevel=newSuccessLevel,diceRolls.dataset.luckSpent=!0;const resulDetails=oldCard.querySelector(".result-details"),diceTotal=oldCard.querySelector(".dice-total");switch(newSuccessLevel){case CoC7Check.successLevel.regular:diceTotal.innerText=game.i18n.localize("CoC7.RegularSuccess"),resulDetails.innerText=game.i18n.format("CoC7.RollResult.LuckSpendText",{luckAmount,successLevel:game.i18n.localize("CoC7.RegularDifficulty")});break;case CoC7Check.successLevel.hard:diceTotal.innerText=game.i18n.localize("CoC7.HardSuccess"),resulDetails.innerText=game.i18n.format("CoC7.RollResult.LuckSpendText",{luckAmount,successLevel:game.i18n.localize("CoC7.HardDifficulty")});break;case CoC7Check.successLevel.extreme:diceTotal.innerText=game.i18n.localize("CoC7.ExtremeSuccess"),resulDetails.innerText=game.i18n.format("CoC7.RollResult.LuckSpendText",{luckAmount,successLevel:game.i18n.localize("CoC7.ExtremeDifficulty")});break;case CoC7Check.successLevel.critical:diceTotal.innerText=game.i18n.localize("CoC7.CriticalSuccess"),resulDetails.innerText=game.i18n.format("CoC7.RollResult.LuckSpendText",{luckAmount,successLevel:game.i18n.localize("CoC7.CriticalDifficulty")})}diceTotal.classList.replace("failure","success"),oldCard.querySelector(".card-buttons").remove(),oldCard.querySelector(".dice-tooltip").style.display="none",CoC7Chat.updateChatCard(oldCard)}}class CoC7RangeInitiator{constructor(actorKey=null,itemId=null,fastForward=!1){this.actorKey=actorKey,this.itemId=itemId,this.fastForward=fastForward,this.resolved=!1,this.cover=!1,this.surprised=!1,this.autoSuccess=!1,this.messageId=null,this.targetCard=null,this.rolled=!1,this.singleShot=!1,this.multipleShots=!1,this.burst=!1,this.fullAuto=!1,this.tokenKey=null,this.aimed=!1,this.bonusDieA=!1,this.bonusDieB=!1,this.penaltyDieA=!1,this.penaltyDieB=!1,this.totalBulletsFired=0,this._targets=[];for(const t of[...game.user.targets]){const target=new CoC7RangeTarget(`${t.scene.id}.${t.id}`);target.token=t,this._targets.push(target)}if(this._targets.length)this._targets=[this._targets[0]],this._targets[0].active=!0;else{const target=new CoC7RangeTarget;target.active=!0,this._targets.push(target)}if(actorKey){const actor=chatHelper.getActorFromKey(actorKey);if(this.token=chatHelper.getTokenFromKey(actorKey),this.token&&(this.tokenKey=actor.tokenKey),itemId){actor.items.get(itemId)&&(this.weapon.singleShot?this.singleShot=!0:this.weapon.system.properties.auto&&(this.fullAuto=!0))}}if(this.tokenKey)for(const t of this._targets)if(t.token&&this.token){t.distance=chatHelper.getDistance(t.token,this.token),t.roundedDistance=Math.round(100*t.distance.value)/100,t.distanceUnit=t.distance.unit;const distInYd=Math.round(100*chatHelper.toYards(t.distance))/100;if(this.actor){t.pointBlankRange=!1;distInYd<=this.actor.system.characteristics.dex.value/15&&t.toggleFlag("pointBlankRange")}!0!==t.pointBlankRange&&this.weapon&&this.weapon.baseRange&&(t.baseRange=!1,t.longRange=!1,t.extremeRange=!1,t.outOfRange=!1,this.weapon.system.properties.shotgun?distInYd<=this.weapon.baseRange?t.baseRange=!0:distInYd<=this.weapon.longRange?t.longRange=!0:distInYd<=this.weapon.extremeRange?t.extremeRange=!0:t.outOfRange=!0:(distInYd<=this.weapon.baseRange&&(t.baseRange=!0),distInYd>this.weapon.baseRange&&distInYd<=2*this.weapon.baseRange&&(t.longRange=!0),distInYd>2*this.weapon.baseRange&&distInYd<=4*this.weapon.baseRange&&(t.extremeRange=!0),distInYd>4*this.weapon.baseRange&&(t.outOfRange=!0)),t.baseRange||t.longRange||t.extremeRange||t.outOfRange||(t.baseRange=!0))}else t.baseRange=!0}get displayActorOnCard(){return game.settings.get("CoC7","displayActorOnCard")}get actorImg(){const img=chatHelper.getActorImgFromKey(this.actorKey);return img||"../icons/svg/mystery-man-black.svg"}get actor(){return chatHelper.getActorFromKey(this.actorKey)}get item(){return this.actor.items.get(this.itemId)}get weapon(){return this.item}get targets(){return this._targets||(this._targets=[]),this._targets}get target(){return this.targets&&this.targets.length?this.targets.pop():null}get skills(){return this.actor.getWeaponSkills(this.itemId)}get mainWeaponSkill(){return this.actor.items.get(this.weapon.system.skill.main.id)}get autoWeaponSkill(){return this.weapon.system.skill.alternativ.id?this.actor.items.get(this.weapon.system.skill.alternativ.id):this.mainWeaponSkill}get autoFire(){return this.burst||this.fullAuto}get multiTarget(){return this.fullAuto||this.multipleShots}get aiming(){return void 0===this._aiming&&(this._aiming=this.actor.getActorFlag("aiming")),this._aiming}get activeTarget(){return this._targets.length?this._targets.find((t=>t.active)):null}get shots(){return void 0===this._shots&&(this._shots=[]),this._shots}get currentShotRank(){return this.shots.length+1}get activeTargetShotDifficulty(){return this.shotDifficulty()}set aiming(b){this._aiming=b}get didAnyShotHit(){let anyHit=!1;for(const r of this.rolls)anyHit=anyHit||r.isSuccess;return anyHit}get successfulHits(){const hits=[];for(let index=0;index<this.rolls.length;index++)if(this.rolls[index].isSuccess){const hit={roll:this.rolls[index],shot:this.shots[index]};hits.push(hit)}return 0!==hits.length?hits:null}get shotFired(){return this.shots?this.shots.length:0}get totalAmmo(){return this.weapon.getBulletLeft()}get maxShots(){return this.fullAuto?"∞":this.weapon.system.usesPerRound.max?parseInt(this.weapon.system.usesPerRound.max):1}get ignoreAmmo(){return game.settings.get("CoC7","disregardAmmo")}get ignoreUsesPerRound(){return game.settings.get("CoC7","disregardUsePerRound")}get outOfAmmo(){return!this.ignoreAmmo&&this.totalBulletsFired>=this.weapon.getBulletLeft()}get outOfShots(){return!this.ignoreUsesPerRound&&(!!this.shots&&this.shots.length>=this.maxShots)}get volleySize(){if(!this.weapon.system.properties.auto)return 1;if(this._volleySize)return this._volleySize;const size=Math.floor(this.autoWeaponSkill.value/10);return size<3?3:size}set volleySize(x){x>=Math.floor(this.autoWeaponSkill.value/10)?this._volleySize=Math.floor(this.autoWeaponSkill.value/10):x<=3&&(this._volleySize=3),this._volleySize=parseInt(x)}get isVolleyMinSize(){return 3===this.volleySize}get isVolleyMaxSize(){return(Math.floor(this.autoWeaponSkill.value/10)<3?3:Math.floor(this.autoWeaponSkill.value/10))===this.volleySize}getTargetFromKey(key){return this._targets.find((t=>key===t.actorKey))}calcTargetsDifficulty(){for(const t of this.targets)t.shotDifficulty=this.shotDifficulty(t)}get calculatedBonusDice(){return this._calculatedModifier>2?this._calculatedModifier:0}get calculatedPenaltyDice(){return this._calculatedModifier<-2?-this._calculatedModifier:0}shotDifficulty(t=null){const target=t||this.activeTarget;let damage=this.weapon.system.range.normal.damage;this.weapon.system.properties.shotgun&&(t.longRange&&(damage=this.weapon.system.range.long.damage),t.extremeRange&&(damage=this.weapon.system.range.extreme.damage));let difficulty,modifier=parseInt(target.modifier,10);difficulty=this.weapon.system.properties.shotgun?1:target.difficulty;let difficultyName="";if(this.aiming&&1===this.currentShotRank&&modifier++,this.reload&&modifier--,this.multipleShots&&!this.fullAuto&&modifier--,this.fullAuto&&(modifier-=this.currentShotRank-1),this.bonusDieA&&modifier++,this.bonusDieB&&modifier++,this.penaltyDieA&&modifier--,this.penaltyDieB&&modifier--,this._calculatedModifier=modifier,modifier<-2){difficulty+=Math.abs(modifier+2),difficulty>CoC7Check.difficultyLevel.critical&&(difficulty=CoC7Check.difficultyLevel.impossible),modifier=-2}else modifier>2&&(modifier=2);return CoC7Check.difficultyLevel.regular===difficulty&&(difficultyName=`${game.i18n.localize("CoC7.RollDifficultyRegular")}`),CoC7Check.difficultyLevel.hard===difficulty&&(difficultyName=`${game.i18n.localize("CoC7.RollDifficultyHard")}`),CoC7Check.difficultyLevel.extreme===difficulty&&(difficultyName=`${game.i18n.localize("CoC7.RollDifficultyExtreme")}`),CoC7Check.difficultyLevel.critical===difficulty&&(difficultyName=`${game.i18n.localize("CoC7.RollDifficultyCritical")}`),CoC7Check.difficultyLevel.impossible===difficulty&&(difficultyName=`${game.i18n.localize("CoC7.RollDifficultyImpossible")}`),{level:difficulty,name:difficultyName,modifier,damage,impossible:difficulty===CoC7Check.difficultyLevel.impossible}}addShotAtCurrentTarget(){this.calcTargetsDifficulty();const shot={target:this.activeTarget,extremeRange:this.activeTarget.extremeRange,actorKey:this.activeTarget.actorKey,actorName:this.activeTarget.name,difficulty:this.activeTarget.shotDifficulty.level,modifier:this.activeTarget.shotDifficulty.modifier,damage:this.activeTarget.shotDifficulty.damage,bulletsShot:1,transitBullets:0,bulletsShotTransit:1,transit:!1};let bulletLeft=this.totalAmmo-this.totalBulletsFired;if(this.fullAuto){if(this.currentShotRank>1){const previousShot=this.shots[this.currentShotRank-2];if(previousShot.actorKey!==this.activeTarget.actorKey){const distance=chatHelper.getDistance(chatHelper.getTokenFromKey(previousShot.actorKey),chatHelper.getTokenFromKey(this.activeTarget.actorKey));shot.transitBullets=Math.floor(chatHelper.toYards(distance)),shot.transitBullets>=bulletLeft&&!this.ignoreAmmo&&(shot.transitBullets=bulletLeft,bulletLeft=0),this.totalBulletsFired=parseInt(this.totalBulletsFired)+shot.transitBullets,shot.transit=!0}}shot.bulletsShot=this.volleySize,shot.bulletsShot<=3&&(shot.bulletsShot=3),shot.bulletsShot>=bulletLeft&&!this.ignoreAmmo&&(shot.bulletsShot=bulletLeft,bulletLeft=0),shot.bulletsShotTransit=shot.bulletsShot+shot.transitBullets}this.burst&&(shot.bulletsShot=parseInt(this.weapon.system.usesPerRound.burst)?parseInt(this.weapon.system.usesPerRound.burst):1,shot.bulletsShot>=bulletLeft&&!this.ignoreAmmo&&(shot.bulletsShot=bulletLeft,bulletLeft=0)),this.totalBulletsFired=parseInt(this.totalBulletsFired)+shot.bulletsShot,this.aiming&&(this.aiming=!1,this.aimed=!0),this.shots.push(shot)}get template(){return"systems/CoC7/templates/chat/combat/range-initiator.html"}async createChatCard(){this.calcTargetsDifficulty();const html=await renderTemplate(this.template,this),speakerData={},token=chatHelper.getTokenFromKey(this.actorKey);token?speakerData.token=token.document:speakerData.actor=this.actor;const speaker=ChatMessage.getSpeaker(speakerData),chatData={user:(this.actor.user?this.actor.user:game.user).id,speaker,content:html},rollMode=game.settings.get("core","rollMode");["gmroll","blindroll"].includes(rollMode)&&(chatData.whisper=ChatMessage.getWhisperRecipients("GM")),chatData.blind=!1;return await ChatMessage.create(chatData)}async updateChatCard(){this.calcTargetsDifficulty();const html=await renderTemplate(this.template,this),message=game.messages.get(this.messageId),msg=await message.update({content:html});return await ui.chat.updateMessage(msg,!1),msg}toggleFlag(flagName){const flag=flagName.includes("-")?chatHelper.hyphenToCamelCase(flagName):flagName;"singleShot"===flag||"multipleShots"===flag||"fullAuto"===flag?(this.singleShot=!1,this.multipleShots=!1,this.fullAuto=!1,"fullAuto"===flag&&(this.burst=!1),this[flag]=!0):"burst"===flag?(this.fullAuto=!1,this.singleShot||this.multipleShots||(this.singleShot=!0),this.burst=!this.burst):(this[flag]=!this[flag],console.log(flag,this[flag]))}async resolveCard(){if(this.rolls=[],this.multiTarget){let weaponMalfunction=!1,index=0;for(;!weaponMalfunction&&this.shots.length>index;){const roll=await this.shootAtTarget(this.shots[index]);roll.dice?.roll&&await CoC7Dice.showRollDice3d(roll.dice.roll),await this.weapon.shootBullets(parseInt(this.shots[index].bulletsShot)+parseInt(this.shots[index].transitBullets)),roll.hasMalfunction&&(roll.isSuccess=!1,weaponMalfunction=!0),index++,this.rolls.push(roll)}}else{const roll=await this.shootAtTarget();roll.dice?.roll&&await CoC7Dice.showRollDice3d(roll.dice.roll);let bulletFired=this.burst?parseInt(this.weapon.system.usesPerRound.burst):1;bulletFired>=this.totalAmmo&&(bulletFired=this.totalAmmo);const shot={target:this.activeTarget,extremeRange:this.activeTarget.extremeRange,actorKey:this.activeTarget.actorKey,actorName:this.activeTarget.name,difficulty:this.activeTarget.shotDifficulty.level,modifier:this.activeTarget.shotDifficulty.modifier,damage:this.activeTarget.shotDifficulty.damage,bulletsShot:bulletFired,transitBullets:0,transit:!1};await this.weapon.shootBullets(bulletFired),roll.hasMalfunction&&(roll.isSuccess=!1),this.shots.push(shot),this.rolls.push(roll)}this.resolved=!0,this.rolled=!0,await this.updateChatCard()}async shootAtTarget(shot=null){const target=shot?this.getTargetFromKey(shot.actorKey):this.activeTarget,check=new CoC7Check;return check.actorKey=this.actorKey,check.actor=this.actorKey,check.item=this.itemId,check.canBePushed=!1,check.isBlind=!1,check.isUnkonwn=!1,this.autoFire?check.skill=this.autoWeaponSkill:check.skill=this.mainWeaponSkill,this.multiTarget?(check.difficulty=shot.difficulty,check.diceModifier=shot.modifier):(this.calcTargetsDifficulty(),this.totalBulletsFired=parseInt(this.totalBulletsFired)+1,this.aiming&&(this.aiming=!1,this.aimed=!0),check.difficulty=this.activeTarget.shotDifficulty.level,check.diceModifier=this.activeTarget.shotDifficulty.modifier),check.details=`${game.i18n.localize("CoC7.Target")}: ${target.name}`,check.targetKey=target.actorKey,await check.roll(),check}static getFromMessageId(messageId){const message=game.messages.get(messageId);if(!message)return null;const card=$(message.content)[0],initiator=CoC7RangeInitiator.getFromCard(card,messageId);return initiator.messageId=messageId,initiator}changeVolleySize(x){this.volleySize=this.volleySize+x,this.updateChatCard()}static updateCardSwitch(event,publishUpdate=!0){const card=event.currentTarget.closest(".range.initiator"),flag=event.currentTarget.dataset.flag,camelFlag=chatHelper.hyphenToCamelCase(flag);if(publishUpdate){const initiator=CoC7RangeInitiator.getFromCard(card);if(event.currentTarget.classList.contains("target-flag")){const target=event.currentTarget.closest(".target"),key=parseInt(target.dataset.targetKey);initiator.targets[key].toggleFlag(camelFlag)}else initiator.toggleFlag(camelFlag);initiator.updateChatCard()}else card.dataset[camelFlag]="true"!==card.dataset[camelFlag],event.currentTarget.classList.toggle("switched-on"),event.currentTarget.dataset.selected=card.dataset[camelFlag]}passRoll(rollIndex){const roll=this.rolls[rollIndex],luckAmount=parseInt(roll.luckNeeded);this.actor.spendLuck(luckAmount)?(roll.successLevel=roll.difficulty,roll.isSuccess=!0,roll.luckSpent=!0,this.updateChatCard()):ui.notifications.error(`${this.actor.name} does not have enough luck to pass the check`)}upgradeRoll(rollIndex,upgradeindex){const roll=this.rolls[rollIndex],increasedSuccess=roll.increaseSuccess[upgradeindex],luckAmount=parseInt(increasedSuccess.luckAmount);if(!this.actor.spendLuck(luckAmount))return void ui.notifications.error(`${this.actor.name} does not have enough luck to pass the check`);const newSuccessLevel=parseInt(increasedSuccess.newSuccessLevel);roll.successLevel=newSuccessLevel,roll.difficulty<=newSuccessLevel&&(roll.isSuccess=!0),roll.luckSpent=!0,this.updateChatCard()}static getFromCard(card,messageId=null){const rangeInitiator=new CoC7RangeInitiator;rangeInitiator._targets=[],messageId?rangeInitiator.messageId=messageId:card.closest(".message")&&(rangeInitiator.messageId=card.closest(".message").dataset.messageId),chatHelper.getObjectFromElement(rangeInitiator,card);const cardTargets=card.querySelectorAll(".target");for(const t of cardTargets){const target=CoC7RangeTarget.getFromElement(t);rangeInitiator.targets.push(target)}const cardShots=card.querySelectorAll(".shot");if(cardShots)for(const s of cardShots){const shot={};chatHelper.getObjectFromElement(shot,s),rangeInitiator.shots.push(shot)}rangeInitiator.rolls=[];const rolls=card.querySelectorAll(".roll-result");for(const r of rolls){const roll=CoC7Roll.getFromElement(r);rangeInitiator.rolls.push(roll)}rangeInitiator.damage=[];const damageRolls=card.querySelectorAll(".damage-results");for(const dr of damageRolls){const damageRoll=CoC7Damage.getFromElement(dr);rangeInitiator.damage.push(damageRoll)}return rangeInitiator}async rollDamage(){this.damage=[];const hits=this.successfulHits;for(let i=0;i<hits.length;i++){const h=hits[i],volleySize=parseInt(h.shot.bulletsShot),damageRolls=[];if(volleySize>0){let damageFormula=String(h.shot.damage);damageFormula&&""!==damageFormula||(damageFormula="0");const damageWithoutDB=damageFormula;this.item.system.properties.addb&&(damageFormula=damageFormula+"+"+this.actor.db),this.item.system.properties.ahdb&&(damageFormula+=CoC7Utilities.halfDB(this.actor.db));const damageDie=CoC7Damage.getMainDie(damageFormula),maxDamage=new Roll(damageFormula)[foundry.utils.isNewerVersion(game.version,"12")?"evaluateSync":"evaluate"]({maximize:!0}).total,criticalDamageFormula=this.weapon.impale?`${damageWithoutDB} + ${maxDamage}`:`${maxDamage}`,criticalDamageDie=CoC7Damage.getMainDie(criticalDamageFormula);let impalingShots=0,successfulShots=0,critical=!1;(this.fullAuto||this.burst)&&(successfulShots=Math.floor(volleySize/2)),0===successfulShots&&(successfulShots=1),h.roll.successLevel>=CoC7Check.difficultyLevel.extreme&&(impalingShots=successfulShots,successfulShots=volleySize-impalingShots,critical=!0,CoC7Check.difficultyLevel.critical!==h.roll.successLevel&&(CoC7Check.difficultyLevel.extreme<=h.roll.difficulty||h.shot.extremeRange)&&(successfulShots=volleySize,impalingShots=0,critical=!1));let total=0;for(let index=0;index<successfulShots;index++){const roll=new Roll(damageFormula);await roll.evaluate({async:!0}),await CoC7Dice.showRollDice3d(roll);const dice=[];for(const die of roll.dice)for(const result of die.results)dice.push({faces:die.faces,result:result.result});damageRolls.push({formula:damageFormula,total:roll.total,die:damageDie,dice,critical:!1}),total+=roll.total}for(let index=0;index<impalingShots;index++){const roll=new Roll(criticalDamageFormula);await roll.evaluate(),await CoC7Dice.showRollDice3d(roll);const dice=[];for(const die of roll.dice)for(const result of die.results)dice.push({faces:die.faces,result:result.result});damageRolls.push({formula:criticalDamageFormula,total:roll.total,die:criticalDamageDie,dice,critical:!0}),total+=roll.total}let targetName="dummy",target=chatHelper.getTokenFromKey(h.roll.targetKey);target||(target=chatHelper.getActorFromKey(h.roll.targetKey)),target&&(targetName=target.name);const blastRangeDamage=[];if(this.weapon.system?.properties?.blst){const blastRadius=parseInt(this.weapon.system.blastRadius);isNaN(blastRadius)||(blastRangeDamage.push(game.i18n.format("CoC7.rangeCombatBlastDamage",{min:0,max:blastRadius,total})),blastRangeDamage.push(game.i18n.format("CoC7.rangeCombatBlastDamage",{min:blastRadius,max:2*blastRadius,total:Math.floor(total/2)})),blastRangeDamage.push(game.i18n.format("CoC7.rangeCombatBlastDamage",{min:2*blastRadius,max:3*blastRadius,total:Math.floor(total/4)})))}this.damage.push({targetKey:h.roll.targetKey,targetName,rolls:damageRolls,total,critical,dealt:!1,resultString:game.i18n.format("CoC7.rangeCombatDamage",{name:targetName,total}),blastRangeDamage})}}this.damageRolled=0!==this.damage.length,this.updateChatCard()}async dealDamage(){for(let dIndex=0;dIndex<this.damage.length;dIndex++){const actor=chatHelper.getActorFromKey(this.damage[dIndex].targetKey);if(null===actor)ui.notifications.error(game.i18n.localize("CoC7.NoTargetToDamage"));else{this.damage[dIndex].totalTaken=0,this.damage[dIndex].totalAbsorbed=0;for(let rIndex=0;rIndex<this.damage[dIndex].rolls.length;rIndex++){const dealtAmount=await actor.dealDamage(this.damage[dIndex].rolls[rIndex].total);this.damage[dIndex].totalTaken+=dealtAmount,this.damage[dIndex].rolls[rIndex].taken=dealtAmount,this.damage[dIndex].rolls[rIndex].absorbed=this.damage[dIndex].rolls[rIndex].total-dealtAmount,this.damage[dIndex].totalAbsorbed+=this.damage[dIndex].rolls[rIndex].total-dealtAmount}this.damage[dIndex].dealt=!0,this.damage[dIndex].resultString=game.i18n.format("CoC7.rangeCombatDamageArmor",{name:this.damage[dIndex].targetName,total:this.damage[dIndex].totalTaken,armor:this.damage[dIndex].totalAbsorbed})}}this.damageDealt=!0,this.updateChatCard()}}class CoC7RangeTarget{constructor(actorKey=null){this.actorKey=actorKey,this.cover=!1,this.pointBlankRange=!1,this.baseRange=!0,this.longRange=!1,this.extremeRange=!1,this.inMelee=!1}get big(){return void 0===this._big&&(this.actor&&this.actor.build?this._big=this.actor.build>=4:this._big=!1),this._big}set big(b){this._big=b}get small(){return void 0===this._small&&(this.actor&&this.actor.build?this._small=this.actor.build<=-2:this._small=!1),this._small}set small(b){this._small=b}get normal(){return!this.big&&!this.small}set normal(b){this._big=!1,this._small=!1}get isFast(){return!(!this.actor||!this.actor.mov)&&this.actor.mov>=8}get fast(){return void 0===this._fast&&(this._fast=!1),this._fast}set fast(b){this._fast=b}get actor(){return this.actorKey&&!this._actor&&(this._actor=chatHelper.getActorFromKey(this.actorKey)),this._actor}get name(){return this.token?this.token.name:this.actor?this.actor.name:"Dummy"}get img(){return this.token&&this.token.document?.texture.src?this.token.document?.texture.src:this.actor?this.actor.data.img:"../icons/svg/mystery-man-black.svg"}get token(){return!this._token&&this.actorKey&&(this._token=chatHelper.getTokenFromKey(this.actorKey)),this._token}get sizeText(){return this.big?game.i18n.localize("CoC7.rangeCombatCard.BigTargetTitle"):this.small?game.i18n.localize("CoC7.rangeCombatCard.SmallTargetTitle"):game.i18n.localize("CoC7.rangeCombatCard.NormalTargetTitle")}get sizeLabel(){return this.big?game.i18n.localize("CoC7.rangeCombatCard.BigTarget"):this.small?game.i18n.localize("CoC7.combatCard.SmallTarget"):game.i18n.localize("CoC7.rangeCombatCard.NormalTarget")}get difficulty(){return this.baseRange||this.pointBlankRange?CoC7Check.difficultyLevel.regular:this.longRange?CoC7Check.difficultyLevel.hard:this.extremeRange?CoC7Check.difficultyLevel.extreme:CoC7Check.difficultyLevel.impossible}get modifier(){let modifier=0;return this.cover&&modifier--,this.pointBlankRange&&modifier++,this.fast&&modifier--,this.small&&modifier--,this.big&&modifier++,this.inMelee&&modifier--,this.surprised&&modifier++,modifier}set token(t){this._token=t}static getFromElement(element){const target=new CoC7RangeTarget;return chatHelper.getObjectFromElement(target,element),target}static changeDisplayedTarget(event){if(!event.currentTarget.classList.contains("target-selector"))return null;return event.currentTarget.closest(".targets").querySelectorAll(".target")}attachToElement(element){chatHelper.attachObjectToElement(this,element)}toggleFlag(flag){"baseRange"===flag||"longRange"===flag||"extremeRange"===flag||"pointBlankRange"===flag?(this.pointBlankRange=!1,this.baseRange=!1,this.longRange=!1,this.extremeRange=!1,this.outOfRange=!1,this[flag]=!0):"size"===flag?this.small?(this.small=!1,this.big=!0):this.big?(this.small=!1,this.big=!1):this.small=!0:this[flag]=!this[flag],this.actor&&"fast"===flag&&this.fast&&!this.isFast&&ui.notifications.warn(game.i18n.format("CoC7.WarnFastTargetWithWrongMOV",{mov:this.actor.mov}))}}const CHAT_COC7_MESSAGE_FAKEROLL='<div class="dice-roll"><div class="dice-result"><div class="dice-formula">???</div><h4 class="dice-total">?</h4></div></div>';class CoC7Chat{static renderChatMessageHook(chatMessage,html){chatMessage.getFlag("CoC7","GMSelfRoll")&&!game.user.isGM&&(html.find(".whisper-to").remove(),html.find(".flavor-text").replaceWith(`<span class="flavor-text">${game.i18n.localize("CoC7.RollSecretDice")}</span>`),html.find(".message-content").replaceWith(`<div class="message-content">${CHAT_COC7_MESSAGE_FAKEROLL}</div>`)),chatMessage.getFlag("CoC7","removeWisperTargets")&&!game.user.isGM&&html.find(".whisper-to").remove(),chatMessage.getFlag("CoC7","fakeRoll")&&game.user.isGM&&(html.find(".flavor-text").replaceWith(game.i18n.localize("CoC7.KeeperSentDecoy")),html.find(".message-content").remove())}static fakeRollMessage(){const chatData={user:game.user.id,flavor:game.i18n.localize("CoC7.RollSecretDice"),whisper:game.users.players,type:CONST.CHAT_MESSAGE_TYPES.WHISPER,flags:{CoC7:{GMSelfRoll:!1,removeWisperTargets:!0,fakeRoll:!0}},content:CHAT_COC7_MESSAGE_FAKEROLL};ChatMessage.create(chatData)}static async chatListeners(app,htmlIn){const html=foundry.utils.isNewerVersion(game.version,"13")?$(htmlIn):htmlIn;html.on("click",".card-buttons button",CoC7Chat._onChatCardAction.bind(this)),html.on("change","input[type=range].slider",CoC7Chat._onChatCardRange.bind(this)),html.on("click",".card-title",CoC7Chat._onChatCardToggleContent.bind(this)),html.on("click",".radio-switch",CoC7Chat._onChatCardRadioSwitch.bind(this)),html.on("click",".panel-switch",CoC7Chat._onChatCardToggleSwitch.bind(this)),html.on("click",".simple-flag",CoC7Chat._onChatCardToggleSwitch.bind(this)),html.on("click",".volley-size",CoC7Chat._onChatCardVolleySize.bind(this)),html.on("click",".dropdown-element",CoC7Chat._onDropDownElementSelected.bind(this)),html.on("click",".simple-toggle",CoC7Chat._onToggleSelected.bind(this)),html.on("click",".target-selector",CoC7Chat._onTargetSelect.bind(this)),html.on("dblclick",".open-actor",CoC7Chat._onOpenActor.bind(this)),html.on("click","coc7-inline-result",CoC7Chat._onInline.bind(this)),OpposedCheckCard.bindListerners(html),CombinedCheckCard.bindListerners(html),foundry.utils.isNewerVersion(game.version,"13")&&html.on("click",".dice-roll",(event=>{event.preventDefault();const roll=event.currentTarget,message=game.messages.get(roll.closest(".message").dataset.messageId);message._rollExpanded=!message._rollExpanded;const tooltips=roll.querySelectorAll(".dice-tooltip");for(const tip of tooltips)message._rollExpanded?$(tip).slideDown(200):$(tip).slideUp(200),tip.classList.toggle("expanded",message._rollExpanded)}))}static _onOpenActor(event){event.preventDefault();const actorKey=event.currentTarget.dataset.actorKey;if(actorKey){const actor=chatHelper.getActorFromKey(actorKey);actor.isOwner&&actor.sheet.render(!0)}}static async onUpdateChatMessage(chatMessage){if(ui.chat.scrollBottom(),game.user.isGM&&(0===chatMessage.type||0===chatMessage.style)){const card=$(chatMessage.content)[0];if(card.classList.contains("melee")&&"true"===card.dataset.resolved){if(card.classList.contains("initiator"))if(card.dataset.targetCard){const initiator=CoC7MeleeInitiator.getFromMessageId(chatMessage.id),target=CoC7MeleeTarget.getFromMessageId(initiator.targetCard);if(target.resolved){const resolutionCard=new CoC7MeleeResoltion(chatMessage.id,target.messageId,target.resolutionCard);await resolutionCard.resolve(),initiator.checkRevealed||await initiator.revealCheck()}}else{const initiator=CoC7MeleeInitiator.getFromMessageId(chatMessage.id);if(initiator.resolutionCard){const resolutionCard=new CoC7MeleeResoltion(chatMessage.id,null,initiator.resolutionCard);await resolutionCard.resolve(),initiator.checkRevealed||await initiator.revealCheck()}}if(card.classList.contains("target")){const target=CoC7MeleeTarget.getFromMessageId(chatMessage.id),resolutionCard=new CoC7MeleeResoltion(target.parentMessageId,chatMessage.id,target.resolutionCard);await resolutionCard.resolve(),target.meleeInitiator.checkRevealed||await target.meleeInitiator.revealCheck()}}}}static async renderMessageHook(message,html){if(ui.chat.scrollBottom(),InteractiveChatCard.bindListeners(html),message.getFlag("CoC7","checkRevealed")&&(html.find(".dice-roll").removeClass("gm-visible-only"),html[0].dataset.checkRevealed=!0),html.find(".dropbtn").click((event=>event.currentTarget.closest(".dropdown").querySelector(".dropdown-content").classList.toggle("show"))),html.find(".dropdown").mouseleave((event=>event.currentTarget.querySelector(".dropdown-content").classList.remove("show"))),game.user.isGM){const card=html[0].querySelector(".coc7.chat-card");if(card&&card.classList.contains("roll-card")&&"true"!==card.dataset.processed&&card.dataset.refMessageId){const roll=CoC7Roll.getFromElement(card);"target"===card.dataset.side&&(roll.defendantId=card.dataset.tokenId?card.dataset.tokenId:card.dataset.actorId),"initiator"===card.dataset.side&&(roll.initiatorId=card.dataset.tokenId?card.dataset.tokenId:card.dataset.actorId),card.dataset.processed="true",CoC7Chat.updateCombatCardTarget(roll)}}const userOnly=html.find(".target-only");for(const element of userOnly)if(!game.user.isGM){element.style.display="none";const actorId=element.getAttribute("data-actor-id");actorId&&game.actors.get(actorId).isOwner&&(element.style.display="block")}const gmOnly=html.find(".gm-only");for(const zone of gmOnly)game.user.isGM||(zone.style.display="none");const userVisibleOnly=html.find(".user-visible-only");for(const elem of userVisibleOnly)game.user.isGM&&(elem.style.display="none");const gmVisibleOnly=html.find(".gm-visible-only");for(const elem of gmVisibleOnly)game.user.isGM||game.user.isTrusted&&game.settings.get("CoC7","trustedCanSeeChatCard")||(elem.style.display="none");const ownerVisibleOnly=html.find(".owner-visible-only");for(const zone of ownerVisibleOnly){let actor=CoC7Chat._getActorFromKey(zone.dataset?.actorKey);actor||(actor=CoC7Chat._getChatCardActor(zone.closest(".chat-card"))),actor||(actor=CoC7Chat._getActorFromKey(zone.parentElement.dataset.actorKey)),actor||(actor=CoC7Chat._getActorFromKey(zone.closest("[data-actor-key]")?.dataset.actorKey)),actor||(actor=CoC7Chat._getActorFromKey(zone.closest("[data-token-key]")?.dataset.actorKey)),(actor&&!actor.isOwner||game.user.isGM)&&(zone.style.display="none")}if(!game.user.isGM){const ownerOnly=html.find(".owner-only");for(const zone of ownerOnly){let actor=CoC7Chat._getActorFromKey(zone.dataset?.actorKey||zone.dataset?.actorId);actor||(actor=CoC7Chat._getChatCardActor(zone.closest(".chat-card"))),actor||(actor=CoC7Chat._getActorFromKey(zone.parentElement.dataset.actorKey)),actor||(actor=CoC7Chat._getActorFromKey(zone.closest("[data-actor-key]")?.dataset.actorKey)),actor||(actor=CoC7Chat._getActorFromKey(zone.closest("[data-token-key]")?.dataset.actorKey)),(actor&&!actor.isOwner||!actor&&!game.user.isGM)&&(zone.style.display="none")}const gmSelectOnly=html.find(".gm-select-only");if(!game.user.isTrusted||!game.settings.get("CoC7","trustedCanModfyChatCard"))for(const select of gmSelectOnly)select.classList.add("inactive"),select.classList.remove("simple-flag");const gmRangeOnly=html.find(".gm-range-only");if(!game.user.isTrusted||!game.settings.get("CoC7","trustedCanModfyChatCard"))for(const range of gmRangeOnly)range.disabled=!0}}static get actionTypeString(){return{fightBack:"CoC7.fightBack",maneuver:"CoC7.maneuver",dodging:"CoC7.dodge"}}static _onTargetSelect(event){const index=parseInt(event.currentTarget.dataset.key),targetsSelector=event.currentTarget.closest(".targets-selector");for(const i of targetsSelector.querySelectorAll("img"))i.style.border="none";targetsSelector.querySelector(`[data-key="${index}"]`).querySelector("img").style.border="1px solid #000";const targets=event.currentTarget.closest(".targets");for(const t of targets.querySelectorAll(".target"))t.style.display="none",t.dataset.active="false";const targetToDisplay=targets.querySelector(`[data-target-key="${index}"]`);targetToDisplay.style.display="block",targetToDisplay.dataset.active="true"}static _onDropDownElementSelected(event){event.preventDefault();const card=event.currentTarget.closest(".chat-card");if(card.classList.contains("target"))return void CoC7MeleeTarget.updateSelected(card,event);const dropDownBoxes=event.currentTarget.closest(".response-selection").querySelectorAll(".toggle-switch");for(const dpdnBox of dropDownBoxes)dpdnBox.classList.remove("switched-on");event.currentTarget.closest(".toggle-switch").classList.add("switched-on"),event.currentTarget.closest(".dropdown-content").classList.toggle("show");const selectedBox=event.currentTarget.closest(".defender-action-select").querySelector(".selected-action");selectedBox.style.display="block";const button=selectedBox.querySelector("button");switch(button.dataset.action="defending",button.dataset.actionType=event.currentTarget.dataset.action,button.dataset.defenderChoice=event.currentTarget.dataset.action,button.dataset.skillId=event.currentTarget.dataset.skillId,button.dataset.skillValue=event.currentTarget.dataset.skillValue,button.dataset.skillName=event.currentTarget.dataset.skillName,button.dataset.itemId=event.currentTarget.dataset.weaponId,button.dataset.itemName=event.currentTarget.dataset.weaponName,event.currentTarget.dataset.action){case"maneuver":button.innerText=`${game.i18n.localize(COC7.combatCards[event.currentTarget.dataset.action])} : ${event.currentTarget.dataset.skillName} (${event.currentTarget.dataset.skillValue}%)`;break;case"fightBack":button.innerText=`${game.i18n.localize(COC7.combatCards[event.currentTarget.dataset.action])} : ${event.currentTarget.dataset.weaponName} (${event.currentTarget.dataset.skillValue}%)`}}static async _onInline(event){event.preventDefault();const a=event.currentTarget;if(a.classList.contains("inline-result"))return a.classList.contains("expanded")?CoC7Check._collapseInlineResult(a):CoC7Check._expandInlineResult(a)}static _onToggleSelected(event){const card=event.currentTarget.closest(".chat-card");if(card.classList.contains("target"))return void CoC7MeleeTarget.updateSelected(card,event);if(""===event.currentTarget.dataset.skillId)return void ui.notifications.error(game.i18n.localize("CoC7.ErrorNoDodgeSkill"));const dropDownBoxes=event.currentTarget.closest(".response-selection").querySelectorAll(".toggle-switch");for(const dpdnBox of dropDownBoxes)dpdnBox.classList.remove("switched-on");event.currentTarget.classList.add("switched-on");const selectedBox=event.currentTarget.closest(".defender-action-select").querySelector(".selected-action");selectedBox.style.display="block";const button=selectedBox.querySelector("button");button.dataset.action="defending",button.dataset.actionType="dodging",button.dataset.defenderChoice=event.currentTarget.dataset.action,button.dataset.skillId=event.currentTarget.dataset.skillId,button.dataset.skillValue=event.currentTarget.dataset.skillValue,button.dataset.skillName=event.currentTarget.dataset.skillName,button.innerText=`${game.i18n.localize(COC7.combatCards[event.currentTarget.dataset.action])} : ${event.currentTarget.dataset.skillName} (${event.currentTarget.dataset.skillValue}%)`}static _onChatCardRadioSwitch(event){event.preventDefault();const optionList=event.currentTarget.parentElement.getElementsByClassName("radio-switch");let index;for(index=0;index<optionList.length;index++){const element=optionList[index];element.dataset.property===event.currentTarget.dataset.property?element.classList.add("switched-on"):element.classList.remove("switched-on")}event.currentTarget.parentElement.dataset.selected=event.currentTarget.dataset.property}static async _onChatCardVolleySize(event){const card=event.currentTarget.closest(".chat-card");if(card.classList.contains("range")&&card.classList.contains("initiator")){const rangeCard=CoC7RangeInitiator.getFromCard(card);event.currentTarget.classList.contains("increase")?rangeCard.changeVolleySize(1):event.currentTarget.classList.contains("decrease")&&rangeCard.changeVolleySize(-1)}}static async _onChatCardToggleSwitch(event){event.preventDefault();const card=event.currentTarget.closest(".chat-card");card.classList.contains("melee")&&(card.classList.contains("initiator")&&CoC7MeleeInitiator.updateCardSwitch(event),card.classList.contains("target")&&CoC7MeleeTarget.updateCardSwitch(event)),card.classList.contains("range")&&card.classList.contains("initiator")&&CoC7RangeInitiator.updateCardSwitch(event),card.classList.contains("damage"),card.classList.contains("roll-card")&&CoC7Check.updateCardSwitch(event)}static _getChatCardActor(card){const cardData=card.dataset.object?JSON.parse(unescape(card.dataset.object)):card.dataset;if(cardData.actorKey)return CoC7Chat._getActorFromKey(cardData.actorKey);const tokenKey=cardData.tokenId;if(tokenKey){const[sceneId,tokenId]=tokenKey.split(".");if("TOKEN"===sceneId)return game.actors.tokens[tokenId];{const scene=game.scenes.get(sceneId);if(!scene)return null;const token=scene.getEmbeddedDocument("Token",tokenId);return token?token.actor||new Token(tokenData).actor:null}}const actorId=cardData.actorId;if(actorId)return game.actors.get(actorId);const message=card.closest(".message"),messageId=message?message.dataset.messageId:null;if(messageId){const chatMessage=game.messages.get(messageId);if(chatMessage.user)return chatMessage.user.character}return null}static isCardOwner(card){const message=card.closest(".message"),messageId=message?message.dataset.messageId:null;if(messageId){return game.messages.get(messageId).ownner||!1}return!1}static _getActorFromKey(key){if(key){if(key.includes(".")){const[sceneId,tokenId]=key.split(".");if("TOKEN"===sceneId)return game.actors.tokens[tokenId];{const scene=game.scenes.get(sceneId);if(!scene)return null;const token=scene.getEmbeddedDocument("Token",tokenId);return token?token.actor||new Token(tokenData).actor:null}}return game.actors.get(key)||null}}static getActorFromToken(tokenKey){const token=CoC7Chat.getToken(tokenKey);return token?token.actor:null}static getToken(tokenKey){if(tokenKey){const[sceneId,tokenId]=tokenKey.split(".");if("TOKEN"===sceneId){const tokenDoc=game.actors.tokens[tokenId]?.token;return tokenDoc.object}{const scene=game.scenes.get(sceneId);if(!scene)return null;const token=scene.getEmbeddedDocument("Token",tokenId);return token?token||new Token(tokenData):null}}return null}static async updateChatCard(card,messId=null){const messageId=null==messId?card.closest(".message").dataset.messageId:messId,message=game.messages.get(messageId),msg=await message.update({content:card.outerHTML});return await ui.chat.updateMessage(msg,!1),msg}static async _onChatCardRange(event){event.preventDefault();const button=event.currentTarget,card=button.closest(".chat-card");if(!card)return;if(!CoC7Chat._getChatCardActor(card))return;const messageId=card.closest(".message").dataset.messageId;let messageCard;card.classList.contains("range")?messageCard=CoC7RangeInitiator.getFromCard(card):card.classList.contains("target")?messageCard=CoC7MeleeTarget.getFromCard(card):card.classList.contains("initiator")&&(messageCard=CoC7MeleeInitiator.getFromCard(card)),messageCard.diceModifier=event.currentTarget.value,await messageCard.updateChatCard(),document.querySelector('[data-message-id="'+messageId+'"]').querySelector('input[type=range][name="'+button.name+'"]').focus()}static async _onChatCardAction(event){event.preventDefault();const button=event.currentTarget,card=button.closest(".chat-card");if(!card)return;const originMessage=button.closest(".message"),action=button.dataset.action;if(CoC7Chat._getChatCardActor(card))switch(action){case"useLuck":{const luckAmount=parseInt(button.dataset.luckAmount),newSuccessLevel=parseInt(event.currentTarget.dataset.newSuccessLevel);if(card.classList.contains("melee")){let meleeCard;card.classList.contains("target")&&(meleeCard=CoC7MeleeTarget.getFromCard(card)),card.classList.contains("initiator")&&(meleeCard=CoC7MeleeInitiator.getFromCard(card)),meleeCard.upgradeRoll(luckAmount,newSuccessLevel,card)}else if(card.classList.contains("range")){const rangeCard=CoC7RangeInitiator.getFromCard(card),rollResult=button.closest(".roll-result"),rollIndex=rollResult?parseInt(rollResult.dataset.index):null;if(button.classList.contains("pass-check"))rangeCard.passRoll(rollIndex);else{const upgradeIndex=parseInt(button.dataset.index);rangeCard.upgradeRoll(rollIndex,upgradeIndex)}}else if(card.classList.contains("roll-card")||null!=card.querySelector(".roll-result")){const check=await CoC7Check.getFromCard(card);if(button.classList.contains("pass-check")){const luckAmount=parseInt(button.dataset.luckAmount);check.forcePass(luckAmount)}else{const upgradeIndex=parseInt(button.dataset.index);await check.upgradeCheck(upgradeIndex)}}else{const actor=CoC7Chat._getChatCardActor(card),detailedResultPlaceHolder=card.querySelector(".result-details");if(actor.spendLuck(luckAmount)){const result=card.querySelector(".dice-total");switch(card.dataset.successLevel=newSuccessLevel,card.dataset.processed="false",newSuccessLevel){case CoC7Check.successLevel.regular:result.innerText=game.i18n.localize("CoC7.RegularSuccess"),detailedResultPlaceHolder.innerText=game.i18n.format("CoC7.RollResult.LuckSpendText",{luckAmount,successLevel:game.i18n.localize("CoC7.RegularDifficulty")});break;case CoC7Check.successLevel.hard:result.innerText=game.i18n.localize("CoC7.HardSuccess"),detailedResultPlaceHolder.innerText=game.i18n.format("CoC7.RollResult.LuckSpendText",{luckAmount,successLevel:game.i18n.localize("CoC7.HardDifficulty")});break;case CoC7Check.successLevel.extreme:result.innerText=game.i18n.localize("CoC7.ExtremeSuccess"),detailedResultPlaceHolder.innerText=game.i18n.format("CoC7.RollResult.LuckSpendText",{luckAmount,successLevel:game.i18n.localize("CoC7.ExtremeDifficulty")});break;case CoC7Check.successLevel.critical:result.innerText=game.i18n.localize("CoC7.CriticalSuccess"),detailedResultPlaceHolder.innerText=game.i18n.format("CoC7.RollResult.LuckSpendText",{luckAmount,successLevel:game.i18n.localize("CoC7.CriticalDifficulty")})}result.classList.replace("failure","success"),result.classList.remove("fumble"),card.querySelector(".card-buttons").remove(),card.querySelector(".dice-tooltip").style.display="none",await CoC7Chat.updateChatCard(card)}else ui.notifications.error(game.i18n.format("CoC7.ErrorNotEnoughLuck",{actor:actor.name}))}break}case"push":{const newCard=card.cloneNode(!0),result=newCard.querySelector(".dice-total");result.innerText=result.innerText+game.i18n.localize("CoC7.PushingSkill"),result.classList.remove("failure"),newCard.querySelector(".card-buttons").remove(),newCard.dataset.pushedRoll=!0,await CoC7Chat.updateChatCard(newCard,originMessage.dataset.messageId),await CoC7Check.push(card);break}case"defending":{let defender,defenderKey=event.currentTarget.closest(".defender-action-select").dataset.tokenId;defenderKey?defender=this.getActorFromToken(defenderKey):(defenderKey=event.currentTarget.closest(".defender-action-select").dataset.actorId,defender=game.actors.get(defenderKey));const responseType=event.currentTarget.dataset.actionType,outnumbered="true"===event.currentTarget.dataset.outnumbered,check=new CoC7Check;switch(check.referenceMessageId=originMessage.dataset.messageId,check.rollType="opposed",check.side="target",check.action=responseType,responseType){case"dodging":check.actor=defender,check.skill=event.currentTarget.dataset.skillId,check.difficulty=CoC7Check.difficultyLevel.regular,outnumbered&&(check.diceModifier=-1),await check.roll(),check.toMessage();break;case"fightBack":check.actor=defender,check.skill=event.currentTarget.dataset.skillId,check.difficulty=CoC7Check.difficultyLevel.regular,check.item=event.currentTarget.dataset.itemId,outnumbered&&(check.diceModifier=-1),await check.roll(),check.toMessage();break;case"maneuver":{const actor=CoC7Chat._getChatCardActor(card);if(defender.build<=actor.build-3)return void ui.notifications.error(game.i18n.localize("CoC7.ErrorManeuverNotPossible"));check.actor=defender,check.skill=event.currentTarget.dataset.skillId,check.difficulty=CoC7Check.difficultyLevel.regular,outnumbered&&(check.diceModifier=-1),defender.build<actor.build&&(check.diceModifier=check.diceModifier-(actor.build-defender.build)),check.diceModifier<-2&&(check.difficulty=check.difficulty+Math.abs(check.diceModifier)-2,check.diceModifier=-2),await check.roll(),check.toMessage();break}}break}case"melee-initiator-roll":{const initiator=CoC7MeleeInitiator.getFromCard(card),check=await initiator.performSkillCheck(event.currentTarget.dataset.skill);$(button).prop("disabled",!0),await CoC7Dice.showRollDice3d(check.dice.roll),await initiator.publishCheckResult();break}case"melee-target-no-response":{const target=CoC7MeleeTarget.getFromCard(card);await target.publishNoReponseResult();break}case"melee-target-roll":{const target=CoC7MeleeTarget.getFromCard(card),check=await target.performSkillCheck(event.currentTarget.dataset.skill);$(button).prop("disabled",!0),await CoC7Dice.showRollDice3d(check.dice.roll),await target.publishCheckResult();break}case"roll-melee-damage":{const damageChatCard=new DamageCard({critical:"true"===button.dataset.critical,fastForward:event.shiftKey});damageChatCard.actorKey=button.dataset.dealer,damageChatCard.targetKey=button.dataset.target,damageChatCard.itemId=button.dataset.weapon,originMessage.dataset.messageId&&(damageChatCard.messageId=originMessage.dataset.messageId),damageChatCard.updateChatCard();break}case"range-initiator-shoot":{const rangeInitiator=CoC7RangeInitiator.getFromCard(card);rangeInitiator.addShotAtCurrentTarget(),await rangeInitiator.updateChatCard();break}case"range-initiator-roll":{const rangeInitiator=CoC7RangeInitiator.getFromCard(card);await rangeInitiator.resolveCard();break}case"roll-range-damage":{const rangeInitiator=CoC7RangeInitiator.getFromCard(card);await rangeInitiator.rollDamage();break}case"deal-melee-damage":{const targetKey=card.dataset.targetKey,amount=card.dataset.result,targetActor=chatHelper.getActorFromKey(targetKey);await targetActor.dealDamage(amount);const buttons=card.querySelector(".card-buttons"),diceTotal=card.querySelector(".dice-total");$(diceTotal).append('<i class="fas fa-check"></i>'),buttons&&buttons.remove(),await CoC7Chat.updateChatCard(card);break}case"deal-range-damage":{const rangeInitiator=CoC7RangeInitiator.getFromCard(card);await rangeInitiator.dealDamage();break}case"testcheck":(await CoC7Check.getFromCard(card)).forcePass();break;case"force-pass":(await CoC7Check.getFromCard(card)).forcePass();break;case"force-fail":(await CoC7Check.getFromCard(card)).forceFail();break;case"increase-success-level":(await CoC7Check.getFromCard(card)).increaseSuccessLevel();break;case"decrease-success-level":(await CoC7Check.getFromCard(card)).decreaseSuccessLevel();break;case"reveal-check":{const check=await CoC7Check.getFromCard(card);check.isBlind=!1,check.computeCheck(),isCtrlKey(event),check.updateChatCard({makePublic:!0});break}case"roll-check-card":{const check=await CoC7Check.getFromCard(card);check.standby=!1,await check._perform(),check.updateChatCard({forceRoll:!0});break}case"flag-for-development":{const check=await CoC7Check.getFromCard(card);await check.flagForDevelopement(),check.computeCheck(),check.updateChatCard();break}case"reset-creature-san-data":{const sanCheck=SanCheckCard.getFromCard(card);await sanCheck.clearSanLossReason(),await sanCheck.updateChatCard();break}case"roll-san-check":{const sanCheck=SanCheckCard.getFromCard(card);await sanCheck.rollSan(),await sanCheck.updateChatCard();break}case"advance-state":{const sanCheck=SanCheckCard.getFromCard(card);await sanCheck.advanceState(button.dataset.state),await sanCheck.updateChatCard();break}case"roll-san-loss":{const sanCheck=SanCheckCard.getFromCard(card);await sanCheck.rollSanLoss(),sanCheck.updateChatCard();break}case"roll-int-check":{const sanCheck=SanCheckCard.getFromCard(card);await sanCheck.rollInt(),sanCheck.updateChatCard();break}case"roll-con-check":{const conCheck=CoC7ConCheck.getFromCard(card);await conCheck.rollCon(),conCheck.updateChatCard();break}case"reveal-con-check":{const conCheck=CoC7ConCheck.getFromCard(card);conCheck.isBlind=!1,conCheck.updateChatCard();break}}}static _onChatCardToggleContent(event){event.preventDefault();const content=event.currentTarget.closest(".chat-card").querySelector(".card-content");content&&(content.style.display?content.style.display="none"===content.style.display?"block":"none":content.style.display="block")}}class CoC7MeleeInitiator extends ChatCardActor{constructor(actorKey=null,itemId=null,fastForward=!1){super(actorKey,fastForward),this.itemId=itemId,this.resolved=!1,this.outnumbered=!1,this.surprised=!1,this.autoSuccess=!1,this.diceModifier=0,this.messageId=null,this.targetCard=null,this.rolled=!1}get template(){return"systems/CoC7/templates/chat/combat/melee-initiator.html"}async revealCheck(){const chatMessage=game.messages.get(this.messageId);await chatMessage.setFlag("CoC7","checkRevealed",!0),await ui.chat.updateMessage(chatMessage,!1)}async createChatCard(){chatHelper.getActorImgFromKey(this.actorKey);const html=await renderTemplate(this.template,this),speakerData={};this.token?speakerData.token=this:speakerData.actor=this;const speaker=ChatMessage.getSpeaker(speakerData),chatData={user:(this.actor.user?this.actor.user:game.user).id,speaker,content:html};["gmroll","blindroll"].includes(this.rollMode)&&(chatData.whisper=ChatMessage.getWhisperRecipients("GM")),chatData.blind=!1;return await ChatMessage.create(chatData)}async updateChatCard(){const html=await renderTemplate(this.template,this),message=game.messages.get(this.messageId),msg=await message.update({content:html});return await ui.chat.updateMessage(msg,!1),msg}toggleFlag(flagName){const flag=flagName.includes("-")?chatHelper.hyphenToCamelCase(flagName):flagName;switch(this[flag]=!this[flag],flag){case"outnumbered":case"surprised":this.diceModifier=Math.max(-2,Math.min(2,parseInt(this.diceModifier,10)+(this[flag]?1:-1)))}}async performSkillCheck(skillId=null,publish=!1){const check=new CoC7Check;if(check.isBlind=!1,check.isUnkonwn=!1,check.referenceMessageId=this.messageId,check.rollType="opposed",check.side="initiator",check.action="attack",check.actor=this.actorKey,check.item=this.itemId,check.skill=skillId,check.canBePushed=!1,check.difficulty=CoC7Check.difficultyLevel.regular,check.diceModifier=0,game.user.isGM?this.checkRevealed=!1:this.checkRevealed=!0,this.diceModifier&&(check.diceModifier=this.diceModifier),await check.roll(),this.check=check,this.rolled=!0,this.resolved=!0,publish&&check.toMessage(),this.criticalDamage=check.successLevel===CoC7Check.successLevel.extreme||check.successLevel===CoC7Check.successLevel.critical,this.hasTarget&&!this.autoSuccess){const message=await game.CoC7socket.executeAsGM("gmcreatemessageas",{targetKey:this.targetKey,messageId:this.messageId,fastForward:this.fastForward,actorKey:this.actorKey});this.targetCard=message.id||message._id}return this.autoSuccess&&!this.check.isFumble&&this.check.forcePass(),check}async publishCheckResult(check=null){if(!check&&!this.check)return null;if(check&&(this.check=check),this.roll=CoC7Roll.getFromCheck(this.check),this.rolled=!0,this.roll.rollIcons=[],this.roll.critical){this.roll.rollColor="goldenrod",this.roll.rollTitle=game.i18n.localize("CoC7.CriticalSuccess");for(let index=0;index<4;index++)this.roll.rollIcons.push("medal")}else if(this.roll.fumble){this.roll.rollColor="darkred",this.roll.rollTitle=game.i18n.localize("CoC7.Fumble");for(let index=0;index<4;index++)this.roll.rollIcons.push("spider")}else if(this.roll.success){this.roll.rollColor="goldenrod",CoC7Check.successLevel.regular===this.roll.successLevel&&(this.roll.rollTitle=game.i18n.localize("CoC7.RegularSuccess")),CoC7Check.successLevel.hard===this.roll.successLevel&&(this.roll.rollTitle=game.i18n.localize("CoC7.HardSuccess")),CoC7Check.successLevel.extreme===this.roll.successLevel&&(this.roll.rollTitle=game.i18n.localize("CoC7.ExtremeSuccess"));for(let index=0;index<this.roll.successLevel;index++)this.roll.rollIcons.push("star")}else this.roll.rollColor="black",this.roll.rollTitle=game.i18n.localize("CoC7.Failure"),this.roll.rollIcons.push("skull");if(!this.targetCard&&!this.autoSuccess&&this.hasTarget){const resolutionCard=new CoC7MeleeResoltion(this.parentMessageId,this.messageId),resolutionMessage=await resolutionCard.preCreateMessage();this.resolutionCard=resolutionMessage.id}await this.updateChatCard()}static getFromCard(card,messageId=null){const initiator=new CoC7MeleeInitiator;return chatHelper.getObjectFromElement(initiator,card),initiator.roll=CoC7Roll.getFromCard(card),card.closest(".message")?initiator.messageId=card.closest(".message").dataset.messageId:initiator.messageId=messageId,initiator}static getFromMessageId(messageId){const message=game.messages.get(messageId);if(!message)return null;const card=$(message.content)[0],initiator=CoC7MeleeInitiator.getFromCard(card,messageId);return initiator.messageId=messageId,initiator}static updateCardSwitch(event,publishUpdate=!0){const card=event.currentTarget.closest(".melee.initiator"),flag=event.currentTarget.dataset.flag,camelFlag=chatHelper.hyphenToCamelCase(flag);if(publishUpdate){const initiator=CoC7MeleeInitiator.getFromCard(card);initiator.toggleFlag(flag),initiator.updateChatCard()}else card.dataset[camelFlag]="true"!==card.dataset[camelFlag],event.currentTarget.classList.toggle("switched-on"),event.currentTarget.dataset.selected=card.dataset[camelFlag]}upgradeRoll(luckAmount,newSuccessLevel,oldCard){this.actor.spendLuck(luckAmount)||ui.notifications.error(game.i18n.format("CoC7.LuckNotEnough",{name:this.actor.name})),this.roll.value=null,this.roll.successLevel=newSuccessLevel,this.roll.luckSpent=!0,oldCard.dataset.processed=!1;const diceRolls=oldCard.querySelector(".dice-roll");diceRolls.dataset.value=null,diceRolls.dataset.successLevel=newSuccessLevel,diceRolls.dataset.luckSpent=!0;const resulDetails=oldCard.querySelector(".result-details"),diceTotal=oldCard.querySelector(".dice-total"),rollDamageButton=oldCard.querySelector('button[data-action="roll-melee-damage"]');switch(rollDamageButton&&rollDamageButton.classList.remove("invisible"),newSuccessLevel){case CoC7Check.successLevel.regular:diceTotal.innerText=game.i18n.localize("CoC7.RegularSuccess"),resulDetails.innerText=game.i18n.format("CoC7.RollResult.LuckSpendText",{luckAmount,successLevel:game.i18n.localize("CoC7.RegularDifficulty")});break;case CoC7Check.successLevel.hard:diceTotal.innerText=game.i18n.localize("CoC7.HardSuccess"),resulDetails.innerText=game.i18n.format("CoC7.RollResult.LuckSpendText",{luckAmount,successLevel:game.i18n.localize("CoC7.HardDifficulty")});break;case CoC7Check.successLevel.extreme:rollDamageButton&&(rollDamageButton.dataset.critical=!0),diceTotal.innerText=game.i18n.localize("CoC7.ExtremeSuccess"),resulDetails.innerText=game.i18n.format("CoC7.RollResult.LuckSpendText",{luckAmount,successLevel:game.i18n.localize("CoC7.ExtremeDifficulty")});break;case CoC7Check.successLevel.critical:rollDamageButton&&(rollDamageButton.dataset.critical=!0),diceTotal.innerText=game.i18n.localize("CoC7.CriticalSuccess"),resulDetails.innerText=game.i18n.format("CoC7.RollResult.LuckSpendText",{luckAmount,successLevel:game.i18n.localize("CoC7.CriticalDifficulty")})}diceTotal.classList.replace("failure","success"),oldCard.querySelector(".card-buttons").remove(),oldCard.querySelector(".dice-tooltip").style.display="none",CoC7Chat.updateChatCard(oldCard)}}class CoCActor extends Actor{constructor(data,context){if(data.type in CONFIG.Actor.documentClasses&&!context?.extended)return new CONFIG.Actor.documentClasses[data.type](data,{extended:!0,...context});super(data,context)}async initialize(){super.initialize(),await this.creatureInit()}prepareBaseData(){if(["character","npc","creature"].includes(this.type)){this.system.skills={};for(const i of this.items)"skill"===i.type&&(this.system.skills[`${i.itemIdentifier}`]={foundryID:i.id,cocid:i.flags?.CoC7?.cocidFlag?.id,value:i.rawValue,bonusDice:i.system.bonusDice});if(void 0===this.system.attribs.san.dailyLimit)if(this.system.attribs.san.oneFifthSanity){const s=this.system.attribs.san.oneFifthSanity.split("/");s[1]&&!isNaN(Number(s[1]))?this.system.attribs.san.dailyLimit=Number(s[1]):this.system.attribs.san.dailyLimit=0}else this.system.attribs.san.dailyLimit=0;this.system.attribs.mov.value=this.rawMov,this.system.attribs.db.value=this.rawDb,this.system.attribs.build.value=this.rawBuild,this.system.attribs.build.current=this.hp}super.prepareBaseData()}prepareEmbeddedDocuments(){super.prepareEmbeddedDocuments()}prepareDerivedData(){if(["character","npc","creature"].includes(this.type)){super.prepareDerivedData(),this.system.attribs.mov.value=this.rawMov,this.system.attribs.db.value=this.rawDb,this.system.attribs.build.value=this.rawBuild,this.system.attribs.hp.max=this.rawHpMax,null===this.hp&&(this.system.attribs.hp.value=this.rawHpMax),this.system.attribs.mp.max=this.rawMpMax,null===this.mp&&(this.system.attribs.mp.value=this.rawMpMax),this.system.attribs.san.max=this.rawSanMax,null===this.san&&(this.system.attribs.san.value=this.rawSanMax);const filterMatrix=[];this.system.attribs.hp.auto&&filterMatrix.push("system.attribs.hp.max"),this.system.attribs.mp.auto&&filterMatrix.push("system.attribs.mp.max"),this.system.attribs.san.auto&&filterMatrix.push("system.attribs.san.max"),this.system.attribs.mov.auto&&filterMatrix.push("system.attribs.mov.value"),this.system.attribs.db.auto&&filterMatrix.push("system.attribs.db.value"),this.system.attribs.build.auto&&filterMatrix.push("system.attribs.build.value");const changes=this.effects.reduce(((changes,e)=>e.disabled||e.isSuppressed?changes:changes.concat(e.changes.map((c=>((c=foundry.utils.duplicate(c)).effect=e,c.priority=c.priority??10*c.mode,c))))),[]);changes.sort(((a,b)=>a.priority-b.priority));const selectChanges=changes.filter((e=>filterMatrix.includes(e.key)));for(const change of selectChanges)change.effect.apply(this,change);this.hpMax&&this.hpMax<this.hp&&(this.system.attribs.hp.value=this.hpMax),this.mpMax&&this.mpMax<this.mp&&(this.system.attribs.mp.value=this.mpMax),this.sanMax&&this.sanMax<this.san&&(this.system.attribs.san.value=this.sanMax)}}static defaultImg(type){switch(type){case"container":return"icons/svg/chest.svg";case"creature":return"systems/CoC7/assets/icons/floating-tentacles.svg";case"npc":return"systems/CoC7/assets/icons/cultist.svg"}}static async create(data,options={}){return"character"===data.type?data.prototypeToken=foundry.utils.mergeObject(data.prototypeToken||{},{actorLink:!0,disposition:1,sight:{enabled:!0}}):"npc"===data.type||"creature"===data.type?void 0!==data.img&&"icons/svg/mystery-man.svg"!==data.img||(data.img=CoCActor.defaultImg(data.type)):"container"===data.type&&(void 0!==data.img&&"icons/svg/mystery-man.svg"!==data.img||(data.img=CoCActor.defaultImg(data.type)),data.prototypeToken=foundry.utils.mergeObject(data.prototypeToken||{},{actorLink:!0})),super.create(data,options)}checkUndefinedAuto(){const returnData={attribs:{hp:{},mp:{},san:{},mov:{},db:{},build:{}}};return void 0===this.system.attribs?.hp?.auto&&(returnData.attribs.hp.auto=!0),void 0===this.system.attribs?.mp?.auto&&(returnData.attribs.mp.auto=!0),void 0===this.system.attribs?.san?.auto&&(returnData.attribs.san.auto=!0),void 0===this.system.attribs?.mov?.auto&&(returnData.attribs.mov.auto=!0),void 0===this.system.attribs?.db?.auto&&(returnData.attribs.db.auto=!0),void 0===this.system.attribs?.build?.auto&&(returnData.attribs.build.auto=!0),returnData}get characteristics(){const characteristics={str:{value:null,shortName:"CHARAC.STR",label:"CHARAC.Strength",formula:null},con:{value:null,shortName:"CHARAC.CON",label:"CHARAC.Constitution",formula:null},siz:{value:null,shortName:"CHARAC.SIZ",label:"CHARAC.Size",formula:null},dex:{value:null,shortName:"CHARAC.DEX",label:"CHARAC.Dexterity",formula:null},app:{value:null,shortName:"CHARAC.APP",label:"CHARAC.Appearance",formula:null},int:{value:null,shortName:"CHARAC.INT",label:"CHARAC.Intelligence",formula:null},pow:{value:null,shortName:"CHARAC.POW",label:"CHARAC.Power",formula:null},edu:{value:null,shortName:"CHARAC.EDU",label:"CHARAC.Education",formula:null}};if(this.system.characteristics)for(const[key,value]of Object.entries(this.system.characteristics))characteristics[key]={key,shortName:game.i18n.localize(value.short),label:game.i18n.localize(value.label),value:value.value,hard:Math.floor(value.value/2)||null,extreme:Math.floor(value.value/5)||null,formula:value.formula};return characteristics}static async initToken(createData){}get hasTempoInsane(){return this.hasConditionStatus(COC7.status.tempoInsane)}get getTempoInsaneDurationText(){return this.hasConditionValue(COC7.status.tempoInsane,"durationText")}get hasIndefInsane(){return this.hasConditionStatus(COC7.status.indefInsane)}get portrait(){return game.settings.get("CoC7","useToken")&&(this.token?.texture?.src||this.prototypeToken?.texture?.src)||this.img}async enterBoutOfMadness(realTime=!0,duration=1){let result=null;const boutOfMadnessTableId=realTime?game.settings.get("CoC7","boutOfMadnessRealTimeTable"):game.settings.get("CoC7","boutOfMadnessSummaryTable");if("none"!==boutOfMadnessTableId){result={phobia:!1,mania:!1,description:null};const boutOfMadnessTable=game.tables.get(boutOfMadnessTableId);if(result.tableRoll=await boutOfMadnessTable.roll(),void 0!==result.tableRoll.results[0]){if(CONST.TABLE_RESULT_TYPES.DOCUMENT===result.tableRoll.results[0].type){const item=game.items.get(result.tableRoll.results[0].documentId);if(void 0!==item){item.system?.type?.phobia&&(result.phobia=!0),item.system?.type?.mania&&(result.mania=!0),result.description=`${item.name}:`+await TextEditor.enrichHTML(item.system.description.value,{async:!0}),result.name=item.name;const itemData=item.toObject();delete itemData._id,await this.createEmbeddedDocuments("Item",[itemData])}else ui.notifications.error(game.i18n.localize("CoC7.MessageBoutOfMadnessItemNotFound"))}CONST.TABLE_RESULT_TYPES.TEXT===result.tableRoll.results[0].type&&(result.description=await TextEditor.enrichHTML(result.tableRoll.results[0].text,{async:!0}))}else ui.notifications.error(game.i18n.localize("CoC7.MessageBoutOfMadnessTableNotFound"))}return realTime?(this.setCondition(COC7.status.tempoInsane,{realTime,duration}),result):result}static emptySkill(skillName,value,{rarity=!1,push=!0,combat=!1,img=!1,specialization=!1}={}){const data={name:skillName,type:"skill",system:{value,skillName,specialization:"",properties:{special:!1,rarity,push,combat}}};if(!1!==img&&(data.img=img),!1!==specialization){const parts=CoC7Item.getNamePartsSpec(skillName,specialization);data.system.specialization=parts.specialization,data.system.skillName=parts.skillName,data.name=parts.name,data.system.properties.special=!0}return data}async createSkill(skillName,value,showSheet=!1){const data=CoCActor.emptySkill(skillName,value);return await this.createEmbeddedDocuments("Item",[data],{renderSheet:showSheet})}async createWeaponSkill(name,firearms=!1,base=null){const skillData=await SkillSpecSelectDialog.create([],game.i18n.localize(firearms?"CoC7.FirearmSpecializationName":"CoC7.FightingSpecializationName"),0,name);if(!1===skillData)return;const value=Number(skillData.get("base-value")),parts=CoC7Item.getNamePartsSpec(name,game.i18n.localize(firearms?"CoC7.FirearmSpecializationName":"CoC7.FightingSpecializationName")),data={name:parts.name,type:"skill",system:{base:isNaN(value)?0:value,adjustments:{personal:null,occupation:null,archetype:null,experience:null},skillName:parts.skillName,specialization:parts.specialization,properties:{special:!0,fighting:!firearms,firearm:firearms,combat:!0}}};await this.createEmbeddedDocuments("Item",[data],{renderSheet:!base});return this.getSkillsByName(name)[0]}async creatureInit(){if("creature"!==this.type)return;if(this.getActorFlag("initialized"))return;if(0===this.getSkillsByName(game.i18n.localize(COC7.creatureFightingSkill)).length){try{const parts=CoC7Item.getNamePartsSpec(game.i18n.localize(COC7.creatureFightingSkill),game.i18n.localize(COC7.fightingSpecializationName)),data={type:"skill",name:parts.name,system:{base:0,value:null,skillName:parts.skillName,specialization:parts.specialization,properties:{combat:!0,fighting:!0,special:!0},flags:{}}},skill=await this.createEmbeddedDocuments("Item",[data],{renderSheet:!1}),attack=await this.createEmbeddedDocuments("Item",[{name:"Innate attack",type:"weapon",system:{description:{value:"Creature's natural attack",chat:"Creature's natural attack"},wpnType:"innate",properties:{addb:!0,slnt:!0}}}],{renderSheet:!1});if(skill.length>0&&attack.length>0){const createdAttack=this.items.get(attack[0].id);await createdAttack.update({"system.skill.main.id":skill[0].id,"system.skill.main.name":skill[0].name})}}catch(err){console.error("Creature init: "+err.message)}await this.setActorFlag("initialized")}}async createItem(itemName,quantity=1,showSheet=!1){const data={name:itemName,type:"item",system:{quantity}};return await this.createEmbeddedDocuments("Item",[data],{renderSheet:showSheet})}async createEmptyArmor(event=null){const showSheet=!event||!event.shiftKey,data={name:game.i18n.localize("CoC7.Entities.Armor"),type:"armor",effects:[{name:game.i18n.localize("CoC7.Entities.Armor"),changes:[{key:"system.attribs.armor.value",mode:2,value:"0"}]}]};return await this.createEmbeddedDocuments("Item",[data],{renderSheet:showSheet})}async createEmptyBook(event=null){const showSheet=!event||!event.shiftKey;if(!this.getItemIdByName(game.i18n.localize(COC7.newBookName)))return this.createBook(game.i18n.localize(COC7.newBookName),showSheet);let index=0,itemName=game.i18n.localize(COC7.newBookName)+" "+index;for(;this.getItemIdByName(itemName);)index++,itemName=game.i18n.localize(COC7.newBookName)+" "+index;return this.createBook(itemName,showSheet)}async createBook(itemName,showSheet=!1){const data={name:itemName,type:"book",system:{}};return await this.createEmbeddedDocuments("Item",[data],{renderSheet:showSheet})}async createEmptySpell(event=null){const showSheet=!event||!event.shiftKey;if(!this.getItemIdByName(game.i18n.localize(COC7.newSpellName)))return this.createSpell(game.i18n.localize(COC7.newSpellName),showSheet);let index=0,itemName=game.i18n.localize(COC7.newSpellName)+" "+index;for(;this.getItemIdByName(itemName);)index++,itemName=game.i18n.localize(COC7.newSpellName)+" "+index;return this.createSpell(itemName,showSheet)}static emptySpell(itemName){return{name:itemName,type:"spell",system:{}}}async createSpell(itemName,showSheet=!1){const data=CoCActor.emptySpell(itemName);return await this.createEmbeddedDocuments("Item",[data],{renderSheet:showSheet})}async createEmptySkill(event=null){const showSheet=!event||!event.shiftKey;if(!this.getItemIdByName(game.i18n.localize(COC7.newSkillName)))return this.createSkill(game.i18n.localize(COC7.newSkillName),"character"!==this.type?1:null,showSheet);let index=0,skillName=game.i18n.localize(COC7.newSkillName)+" "+index;for(;this.getItemIdByName(skillName);)index++,skillName=game.i18n.localize(COC7.newSkillName)+" "+index;return this.createSkill(skillName,null,showSheet)}async createEmptyItem(event=null){const showSheet=!event||!event.shiftKey;if(!this.getItemIdByName(game.i18n.localize(COC7.newItemName)))return this.createItem(game.i18n.localize(COC7.newItemName),1,showSheet);let index=0,itemName=game.i18n.localize(COC7.newItemName)+" "+index;for(;this.getItemIdByName(itemName);)index++,itemName=game.i18n.localize(COC7.newItemName)+" "+index;return this.createItem(itemName,1,showSheet)}async createEmptyWeapon(event=null,properties={}){const showSheet=!event||!event.shiftKey;let weaponName=game.i18n.localize(COC7.newWeaponName);if(this.getItemIdByName(game.i18n.localize(COC7.newWeaponName))){let index=0;for(weaponName=game.i18n.localize(COC7.newWeaponName)+" "+index;this.getItemIdByName(weaponName);)index++,weaponName=game.i18n.localize(COC7.newWeaponName)+" "+index}const data={name:weaponName,type:"weapon",system:{properties:{}}};for(const[key]of Object.entries(COC7.weaponProperties))data.system.properties[key]=Object.prototype.hasOwnProperty.call(properties,key)??!1;await this.createEmbeddedDocuments("Item",[data],{renderSheet:showSheet})}async createBioSection(title=null){const bio=this.system.biography?foundry.utils.duplicate(this.system.biography):[];bio.push({title,value:null}),await this.update({"system.biography":bio},{renderSheet:!1})}async updateBioValue(index,content){const bio=foundry.utils.duplicate(this.system.biography);bio[index].value=content,await this.update({"system.biography":bio},{render:!1})}async updateBioTitle(index,title){const bio=foundry.utils.duplicate(this.system.biography);bio[index].title=title,await this.update({"system.biography":bio})}async deleteBioSection(index){const bio=foundry.utils.duplicate(this.system.biography);bio.splice(index,1),await this.update({"system.biography":bio})}async moveBioSectionUp(index){if(0===index)return;const bio=foundry.utils.duplicate(this.system.biography);if(index>=bio.length)return;const elem=bio.splice(index,1)[0];bio.splice(index-1,0,elem),await this.update({"system.biography":bio})}async moveBioSectionDown(index){const bio=foundry.utils.duplicate(this.system.biography);if(index>=bio.length-1)return;const elem=bio.splice(index,1)[0];bio.splice(index+1,0,elem),await this.update({"system.biography":bio})}async updateTextArea(textArea){const name="system."+textArea.dataset.areaName;await this.update({[name]:textArea.value})}async createEmbeddedDocuments(embeddedName,dataArray,options){const processedDataArray=[];let baseValue=0,baseCalculated=0,archetype=!1,occupation=!1;const actorChanges={},itemChanges=[];for(let data of dataArray)switch(data.type){case"skill":{if(baseValue=data.system.base,baseCalculated=await CoC7Item.calculateBase(this,data),"character"!==this.type){if(this.getItemIdByName(data.name))return;if(baseValue&&String(baseValue)!==String(data.system.value)&&(data.system.value=baseCalculated),isNaN(Number(data.system.value))){let value;try{value=(await new Roll(data.system.value,this.parseCharacteristics()).evaluate({async:!0})).total}catch(err){value=null}value&&(data.system.value=Math.floor(value))}}else data.system.value=null;let addThis=!0;if(CoC7Item.isAnySpec(data)){const isAnyButNotFlagged=(!data.system.properties?.requiresname??!1)&&!data.system.properties?.picknameonly;let skillList=[];const group=game.system.api.cocid.guessGroupFromDocument(data);if(group&&(skillList=(await game.system.api.cocid.fromCoCIDRegexBest({cocidRegExp:new RegExp("^"+CoC7Utilities.quoteRegExp(group)+".+$"),type:"i"})).filter((item=>(item.system.properties?.special??!1)&&!item.system.properties?.requiresname&&!item.system.properties?.picknameonly))),data.system?.flags?.occupation||data.system?.flags?.archetype){const existingSkills=this.skills.filter((el=>!!el.system.specialization&&((!data.system?.flags?.occupation||!el.system.flags?.occupation)&&((!data.system?.flags?.archetype||!el.system.flags?.archetype)&&data.system.specialization.toLocaleLowerCase()===el.system.specialization.toLocaleLowerCase()))));if(existingSkills.length>0)if(skillList.length>0){for(let i=existingSkills.length-1;i>=0;i--){const found=skillList.findIndex((item=>item.name===existingSkills[i].name||item.flags?.CoC7?.cocidFlag?.id===existingSkills[i].flags?.CoC7?.cocidFlag?.id));found>-1&&skillList.splice(found,1)}skillList=skillList.concat(existingSkills)}else skillList=existingSkills}skillList.length>0&&skillList.sort(CoC7Utilities.sortByNameKey);const skillData=await SkillSpecializationSelectDialog.create({skills:skillList,allowCustom:isAnyButNotFlagged||(data.system.properties?.requiresname??!1),fixedBaseValue:data.system.properties?.keepbasevalue??!1,specializationName:data.system.specialization,label:data.name,baseValue:data.system.base});if(Object.prototype.hasOwnProperty.call(skillData,"selected"))if(skillData.selected){const existingItem=this.items.get(skillData.selected);if(existingItem){const changes={};data.system.properties?.keepbasevalue||""!==skillData.baseValue&&(baseCalculated=skillData.baseValue,changes["system.value"]=baseCalculated);for(const[key,value]of Object.entries(data.system.flags))value&&(changes[`system.flags.${key}`]=!0);Object.keys(changes).length>0&&(changes._id=existingItem.id,await this.updateEmbeddedDocuments("Item",[changes])),data.name=CoC7Item.getNameWithoutSpec(existingItem),addThis=!1}else{const existing=skillList.find((i=>i.id===skillData.selected));if(existing){const flags=data.system?.flags,keepBase=data.system.properties?.keepbasevalue??!1;data=foundry.utils.duplicate(existing);for(const[key,value]of Object.entries(flags))value&&(data.system.flags[key]=!0);keepBase&&(""!==skillData.baseValue&&(data.system.base=skillData.baseValue),baseValue=skillData.baseValue,baseCalculated=await CoC7Item.calculateBase(this,data))}}}else{const parts=CoC7Item.getNamePartsSpec(skillData.name,data.system.specialization);data.system.properties?.keepbasevalue||(""!==skillData.baseValue&&(data.system.base=skillData.baseValue),baseValue=skillData.baseValue,baseCalculated=await CoC7Item.calculateBase(this,data)),data.system.skillName=parts.skillName,data.name=parts.name}}addThis&&(String(baseValue)!==String(baseCalculated)&&(data.system.base=baseCalculated),processedDataArray.push(foundry.utils.duplicate(data)));break}case"weapon":if("container"!==this.type){const mainSkill=data.system?.skill?.main?.name;if(mainSkill){let skill=this.getSkillsByName(mainSkill)[0];if(!skill){const name=mainSkill.match(/\(([^)]+)\)/)?mainSkill.match(/\(([^)]+)\)/)[1]:mainSkill;if(name.match(/i\.skill\./)){const availableSkills=await game.system.api.cocid.fromCoCIDBest({cocid:name,showLoading:!0});availableSkills.length&&(await this.addItems([availableSkills[0]]),skill=await this.getSkillsByName(mainSkill)[0])}if(!skill){const existing=game.items.find((item=>"skill"===item.type&&(item.name.toLocaleLowerCase()===name.toLocaleLowerCase()||item.system.skillName?.toLocaleLowerCase()===name.toLocaleLowerCase())));void 0!==existing?(await this.addItems([existing]),skill=await this.getSkillsByName(mainSkill)[0]):skill=await this.createWeaponSkill(name,!!data.system.properties?.rngd)}}skill&&(data.system.skill.main.id=skill.id)}const secondSkill=data.system?.skill?.alternativ?.name;if(secondSkill){let skill=this.getSkillsByName(secondSkill)[0];if(!skill){const name=secondSkill.match(/\(([^)]+)\)/)?secondSkill.match(/\(([^)]+)\)/)[1]:secondSkill;if(name.match(/i\.skill\./)){const availableSkills=await game.system.api.cocid.fromCoCIDBest({cocid:name,showLoading:!0});availableSkills.length&&(await this.addItems([availableSkills[0]]),skill=await this.getSkillsByName(secondSkill)[0])}if(!skill){const existing=game.items.find((item=>"skill"===item.type&&(item.name.toLocaleLowerCase()===name.toLocaleLowerCase()||item.system.skillName?.toLocaleLowerCase()===name.toLocaleLowerCase())));void 0!==existing?(await this.addItems([existing]),skill=await this.getSkillsByName(secondSkill)[0]):skill=await this.createWeaponSkill(name,!!data.system.properties?.rngd)}}skill&&(data.system.skill.alternativ.id=skill.id)}}processedDataArray.push(foundry.utils.duplicate(data));break;case"setup":{if(data.system.enableCharacterisitics){data.system.characteristics.list={},data.system.characteristics.list.str=this.getCharacteristic("str"),data.system.characteristics.list.con=this.getCharacteristic("con"),data.system.characteristics.list.siz=this.getCharacteristic("siz"),data.system.characteristics.list.dex=this.getCharacteristic("dex"),data.system.characteristics.list.app=this.getCharacteristic("app"),data.system.characteristics.list.int=this.getCharacteristic("int"),data.system.characteristics.list.pow=this.getCharacteristic("pow"),data.system.characteristics.list.edu=this.getCharacteristic("edu"),data.system.characteristics.list.luck={},data.system.characteristics.list.luck.value=isNaN(this.luck)?null:this.luck,data.system.characteristics.list.luck.label=game.i18n.localize("CoC7.Luck"),data.system.characteristics.list.luck.shortName=game.i18n.localize("CoC7.Luck"),data.system.characteristics.values||(data.system.characteristics.values={}),data.system.characteristics.values.str=data.system.characteristics.list.str.value,data.system.characteristics.values.con=data.system.characteristics.list.con.value,data.system.characteristics.values.siz=data.system.characteristics.list.siz.value,data.system.characteristics.values.dex=data.system.characteristics.list.dex.value,data.system.characteristics.values.app=data.system.characteristics.list.app.value,data.system.characteristics.values.int=data.system.characteristics.list.int.value,data.system.characteristics.values.pow=data.system.characteristics.list.pow.value,data.system.characteristics.values.edu=data.system.characteristics.list.edu.value,data.system.characteristics.values.luck=data.system.characteristics.list.luck.value,data.system.characteristics.points.enabled?data.system.title=game.i18n.localize("CoC7.SpendPoints"):data.system.title=game.i18n.localize("CoC7.RollCharac"),data.system.pointsWarning=!(null!==data.system.characteristics.values.str&&null!==data.system.characteristics.values.con&&null!==data.system.characteristics.values.siz&&null!==data.system.characteristics.values.dex&&null!==data.system.characteristics.values.app&&null!==data.system.characteristics.values.int&&null!==data.system.characteristics.values.pow&&null!==data.system.characteristics.values.edu);if(!await CharacRollDialog.create(data.system))return;{const updateData={};for(const key of["str","con","siz","dex","app","int","pow","edu"])data.system.characteristics.values[key]&&(updateData[`system.characteristics.${key}.value`]=data.system.characteristics.values[key],updateData[`system.characteristics.${key}.formula`]=data.system.characteristics.rolls[key]);data.system.characteristics.values.luck&&(updateData["system.attribs.lck.value"]=data.system.characteristics.values.luck),data.system.characteristics.values.pow&&(updateData["system.attribs.san.value"]=data.system.characteristics.values.pow,updateData["system.attribs.san.dailyLimit"]=Math.floor(data.system.characteristics.values.pow/5),updateData["system.attribs.mp.max"]=Math.floor(data.system.characteristics.values.pow/5)),await this.update(updateData,{renderSheet:!1}),await this.update({"system.attribs.hp.value":this.rawHpMax,"system.attribs.hp.max":this.rawHpMax},{renderSheet:!1})}}const era=Object.entries(data.flags?.CoC7?.cocidFlag?.eras).filter((e=>e[1])).map((e=>e[0])),items=await game.system.api.cocid.expandItemArray({itemList:data.system.items,era:void 0===era[0]||era[0]}),skills=items.filter((it=>"skill"===it.type)),othersItems=items.filter((it=>"skill"!==it.type));if(await this.addUniqueItems(skills),await this.addItems(othersItems),game.settings.get("CoC7","oneBlockBackstory"))await this.update({"system.backstory":data.system.backstory},{renderSheet:!1});else for(const sectionName of data.system.bioSections)!this.system.biography?.find((el=>sectionName===el.title))&&sectionName&&await this.createBioSection(game.i18n.localize(sectionName));const monetary=foundry.utils.mergeObject(this.system.monetary,foundry.utils.duplicate(data.system.monetary)),sheet=this.sheet;let state=!1;do{state=await new Promise((resolve=>setTimeout((()=>{resolve(sheet._state)}),100)))}while(state===Application.RENDER_STATES.RENDERING);await this.update({"system.monetary":monetary}),Hooks.call("setupFinishedCoC7");break}case"archetype":if("character"===this.type){if(this.archetype){let resetArchetype=!1;if(await Dialog.confirm({title:game.i18n.localize("CoC7.ResetArchetype"),content:`<p>${game.i18n.format("CoC7.ResetArchetypeHint",{name:this.name})}</p>`,yes:()=>{resetArchetype=!0},defaultYes:!1}),!resetArchetype)return;await this.resetArchetype()}const coreCharac=[];for(const entry of Object.entries(data.system.coreCharacteristics)){const[key,value]=entry;if(data.system.coreCharacteristics[key]=!1,value){const char=this.getCharacteristic(key);char.key=key,coreCharac.push(char)}}let charac;if(coreCharac.length>1){const charDialogData={};charDialogData.characteristics=coreCharac,charDialogData.title=game.i18n.localize("CoC7.SelectCoreCharac"),charac=await CharacSelectDialog.create(charDialogData)}else 1===coreCharac.length&&(charac=coreCharac[0].key);if(!charac)return;if(data.system.coreCharacteristics[charac]=!0,data.system.coreCharacteristicsFormula.enabled){let value=Number(data.system.coreCharacteristicsFormula.value);if(isNaN(value)){const char=this.getCharacteristic(charac),roll=new Roll(data.system.coreCharacteristicsFormula.value);await roll.roll({async:!0}),roll.toMessage({flavor:game.i18n.format("CoC7.MessageRollingCharacteristic",{label:char.label,formula:data.system.coreCharacteristicsFormula.value})}),value=char.value<roll.total?roll.total:char.value}await this.update({[`system.characteristics.${charac}.value`]:value})}data.system.skills=await game.system.api.cocid.expandItemArray({itemList:data.system.skills}),await this.addUniqueItems(data.system.skills,"archetype"),processedDataArray.push(foundry.utils.duplicate(data)),archetype=!0}break;case"occupation":if("character"===this.type){if(this.occupation){let resetOccupation=!1;if(await Dialog.confirm({title:game.i18n.localize("CoC7.ResetOccupation"),content:`<p>${game.i18n.format("CoC7.ResetOccupationHint",{name:this.name})}</p>`,yes:()=>{resetOccupation=!0},defaultYes:!1}),!resetOccupation)return;await this.resetOccupation()}if(data.system.skills=await game.system.api.cocid.expandItemArray({itemList:data.system.skills}),Number(data.system.creditRating.max)>0){const actorCreditRating=game.system.api.cocid.findCocIdInList("i.skill.credit-rating",data.system.skills);0===actorCreditRating.length?0===game.system.api.cocid.findCocIdInList("i.skill.credit-rating",this.items).length&&(data.system.skills.push("i.skill.credit-rating"),data.system.skills=await game.system.api.cocid.expandItemArray({itemList:data.system.skills})):0===game.system.api.cocid.findCocIdInList("i.skill.credit-rating",this.items).length&&data.system.skills.push(actorCreditRating[0])}const pointsDialogData={};pointsDialogData.characteristics=data.system.occupationSkillPoints;let total=0,optionalChar=!1;for(const entry of Object.entries(data.system.occupationSkillPoints)){const[key,value]=entry,char=this.getCharacteristic(key);pointsDialogData.characteristics[key].name=char.label,pointsDialogData.characteristics[key].value=char.value,value.selected&&(pointsDialogData.characteristics[key].total=char.value*Number(pointsDialogData.characteristics[key].multiplier),value.optional?optionalChar=!0:total+=pointsDialogData.characteristics[key].total)}if(pointsDialogData.total=total,optionalChar){if(!await PointSelectDialog.create(pointsDialogData))return}for(let index=0;index<data.system.groups.length;index++){data.system.groups[index].skills=await game.system.api.cocid.expandItemArray({itemList:data.system.groups[index].skills});const dialogData={skills:[],type:"occupation"};dialogData.actorId=this.id,dialogData.optionsCount=Number(data.system.groups[index].options),dialogData.title=game.i18n.localize("CoC7.SkillSelectionWindow");for(const value of data.system.groups[index].skills)if(CoC7Item.isAnySpec(value))dialogData.skills.push(value);else{const skill=this.items.find((item=>item.name===value.name&&"skill"===item.type));if(!skill||!skill.system.flags?.occupation){data.system.skills.find((item=>item.name===value.name))||dialogData.skills.push(value)}}if(0!==dialogData.skills.length)if(dialogData.skills.length<=dialogData.optionsCount){ui.notifications.info(game.i18n.format("CoC7.InfoLessSkillThanOptions",{skillCount:dialogData.skills.length,optionsCount:dialogData.optionsCount}));const merged=CoC7Item.mergeOptionalSkills(data.system.skills,dialogData.skills);data.system.skills=merged}else{const selected=await SkillSelectDialog.create(dialogData);if(!selected)return;const merged=CoC7Item.mergeOptionalSkills(data.system.skills,selected);data.system.skills=merged}else ui.notifications.info(game.i18n.localize("CoC7.InfoAllSkillsAlreadySelected"))}if(Number(data.system.personal)){const dialogData={skills:[],type:"occupation"};dialogData.actorId=this.id,dialogData.optionsCount=Number(data.system.personal),dialogData.title=game.i18n.format("CoC7.SelectPersonalSkills",{number:Number(data.system.personal)});for(const s of this.skills)if(!s.system.flags.occupation&&!s.system.properties.noadjustments&&!s.system.properties.noxpgain){data.system.skills.find((item=>item.name===s.name))||dialogData.skills.push(s)}if(0!==dialogData.skills.length)if(dialogData.skills.length<=dialogData.optionsCount){ui.notifications.info(game.i18n.format("CoC7.InfoLessSkillThanOptions",{skillCount:dialogData.skills.length,optionsCount:dialogData.optionsCount}));const merged=CoC7Item.mergeOptionalSkills(data.system.skills,dialogData.skills);data.system.skills=merged}else{const selected=await SkillSelectDialog.create(dialogData);if(!selected)return;const merged=CoC7Item.mergeOptionalSkills(data.system.skills,selected);data.system.skills=merged}else ui.notifications.info(game.i18n.localize("CoC7.InfoAllSkillsAlreadySelected"))}await this.addUniqueItems(data.system.skills,"occupation"),await(this.creditRatingSkill?.setItemFlag("occupation")),await(this.creditRatingSkill?.update({"system.adjustments.occupation":Number(data.system.creditRating.min)})),processedDataArray.push(foundry.utils.duplicate(data)),occupation=!0}break;case"experiencePackage":if(this.experiencePackage);else if(game.settings.get("CoC7","pulpRuleArchetype"))ui.notifications.error("CoC7.ErrorExperiencePackageArchetype",{localize:!0});else if("character"!==this.type)ui.notifications.error("CoC7.ErrorExperiencePackageNotInvestigator",{localize:!0});else if(game.user.isGM){const rolled=await ExperiencePackageDialog.create(data.system);if(rolled){data.system.skills=await game.system.api.cocid.expandItemArray({itemList:data.system.skills});for(let index=0;index<data.system.groups.length;index++){data.system.groups[index].skills=await game.system.api.cocid.expandItemArray({itemList:data.system.groups[index].skills});const dialogData={skills:[],type:"experiencePackage"};dialogData.actorId=this.id,dialogData.optionsCount=Number(data.system.groups[index].options),dialogData.title=game.i18n.localize("CoC7.SkillSelectionWindow");for(const value of data.system.groups[index].skills)if(CoC7Item.isAnySpec(value))dialogData.skills.push(value);else{const skill=this.items.find((item=>item.name===value.name&&"skill"===item.type));if(!skill||!skill.system.flags?.occupation){data.system.skills.find((item=>item.name===value.name))||dialogData.skills.push(value)}}if(0!==dialogData.skills.length)if(dialogData.skills.length<=dialogData.optionsCount){ui.notifications.info(game.i18n.format("CoC7.InfoLessSkillThanOptions",{skillCount:dialogData.skills.length,optionsCount:dialogData.optionsCount}));const merged=CoC7Item.mergeOptionalSkills(data.system.skills,dialogData.skills);data.system.skills=merged}else{const selected=await SkillSelectDialog.create(dialogData);if(!selected)return;const merged=CoC7Item.mergeOptionalSkills(data.system.skills,selected);data.system.skills=merged}else ui.notifications.info(game.i18n.localize("CoC7.InfoAllSkillsAlreadySelected"))}if(await this.addUniqueItems(data.system.skills,"experiencePackage"),rolled["i.skill.cthulhu-mythos"]>0){let skill=this.getFirstItemByCoCID("i.skill.cthulhu-mythos");if(void 0===skill){const skills=await game.system.api.cocid.fromCoCIDBest({cocid:"i.skill.cthulhu-mythos",showLoading:!0});skills.length&&(skill=foundry.utils.duplicate(skills[0]),skill.system.adjustments.experience=rolled["i.skill.cthulhu-mythos"],skill.system.value=Object.values(skill.system.adjustments).filter((v=>v)).reduce(((c,v)=>c+=parseInt(v,10)),0),console.log("skill",skill,skill.system.adjustments,skill.system.value),processedDataArray.push(skill))}else itemChanges.push({"system.adjustments.experience":parseInt(skill.system.adjustments.experience??0,10)+rolled["i.skill.cthulhu-mythos"],"system.value":Object.values(skill.system.adjustments).filter((v=>v)).reduce(((c,v)=>c+=parseInt(v,10)),rolled["i.skill.cthulhu-mythos"]),_id:skill._id})}if(rolled.SAN>0&&(actorChanges["system.attribs.san.value"]=parseInt(this.system.attribs.san.value,10)-rolled.SAN),rolled.encounters.length>0&&(actorChanges["system.sanityLossEvents"]=this.system.sanityLossEvents.concat(rolled.encounters)),rolled.backstory.length>0){actorChanges["system.biography"]=this.system.biography;const name=game.i18n.localize("CoC7.CoCIDFlag.keys.rt..backstory-injuries-and-scars"),index=actorChanges["system.biography"].findIndex((b=>b.title===name));index>-1?actorChanges["system.biography"][index].value=actorChanges["system.biography"][index].value+rolled.backstory.join(""):actorChanges["system.biography"].push({title:name,value:rolled.backstory.join("")})}for(const doc of rolled.items)processedDataArray.push(foundry.utils.duplicate(doc));actorChanges["system.development.experiencePackage"]=data.system.points,processedDataArray.push(foundry.utils.duplicate(data))}}else ui.notifications.error("CoC7.ErrorExperiencePackageNotGM",{localize:!0});break;default:processedDataArray.push(foundry.utils.duplicate(data))}if(0===processedDataArray.length)return[];const processed=await super.createEmbeddedDocuments(embeddedName,processedDataArray,options);if(archetype&&(await this.update({"system.development.archetype":this.archetypePoints}),Hooks.call("archetypeFinishedCoC7")),occupation&&(await this.update({"system.development.occupation":this.occupationPoints,"system.development.personal":this.personalPoints}),Hooks.call("occupationFinishedCoC7")),Object.keys(actorChanges).length>0||itemChanges.length>0){const actor=this;setTimeout((async function(){Object.keys(actorChanges).length>0&&await actor.update(actorChanges,{renderSheet:!0}),itemChanges.length>0&&await actor.updateEmbeddedDocuments("Item",itemChanges,{renderSheet:!0})}),1e3)}return processed}getItemIdByName(itemName){let id=null;const name=itemName.match(/\(([^)]+)\)/)?itemName.match(/\(([^)]+)\)/)[1]:itemName;for(const value of this.items)CoC7Item.getNameWithoutSpec(value).toLowerCase()===name.toLowerCase()&&(id=value.id);return id}getItemsByName(itemName){const itemList=[];for(const value of this.items)value.name===itemName&&itemList.push(value);return itemList}getSkillsByName(skillName){const skillList=[],name=skillName.match(/\(([^)]+)\)/)?skillName.match(/\(([^)]+)\)/)[1]:skillName;for(const value of this.items)CoC7Item.getNameWithoutSpec(value).toLowerCase()!==name.toLowerCase()&&value.flags?.CoC7?.cocidFlag?.id!==skillName||"skill"!==value.type||skillList.push(value);return skillList}getFirstItemByCoCID(cocid){return this.items.find((i=>i.flags?.CoC7?.cocidFlag?.id===cocid))}parseCharacteristics(){const parsed={};for(const[key,value]of Object.entries(COC7.formula.actor))key.startsWith("@")&&value.startsWith("this.")&&(parsed[key.substring(1)]=foundry.utils.getProperty(this,value.substring(5)));return parsed}static getCharacteristicDefinition(){const characteristics=[],characteristicList=foundry.utils.isNewerVersion(game.version,"12")?game.system.template.Actor.character.characteristics:game.system.template.Actor.templates.characteristics.characteristics;for(const[key,value]of Object.entries(characteristicList))characteristics.push({key,shortName:game.i18n.localize(value.short),label:game.i18n.localize(value.label)});return characteristics}getCharacteristic(charName){if(this.system.characteristics)for(const[key,value]of Object.entries(this.system.characteristics))if(game.i18n.localize(value.short).toLowerCase()===charName.toLowerCase()||game.i18n.localize(value.label).toLowerCase()===charName.toLowerCase()||key===charName.toLowerCase())return{key,shortName:game.i18n.localize(value.short),label:game.i18n.localize(value.label),value:value.value};return null}getAttribute(attribName){return["lck","luck",game.i18n.localize("CoC7.Luck").toLowerCase()].includes(attribName.toLowerCase())?{key:"lck",shortName:"luck",label:game.i18n.localize("CoC7.Luck"),value:this.system.attribs.lck.value}:["san",game.i18n.localize("CoC7.SAN").toLowerCase(),game.i18n.localize("CoC7.Sanity").toLowerCase()].includes(attribName.toLowerCase())?{key:"san",shortName:game.i18n.localize("CoC7.SAN"),label:game.i18n.localize("CoC7.Sanity"),value:this.system.attribs.san.value}:null}async runRoll(options={}){void 0===options.cardType&&(options.cardType=CoC7ChatMessage.CARD_TYPE_NORMAL),void 0===options.preventStandby&&(options.preventStandby=!0),options.actor=this;return await CoC7ChatMessage.trigger(options)}get occupation(){return this.items.filter((item=>"occupation"===item.type))[0]}get archetype(){return this.items.filter((item=>"archetype"===item.type))[0]}get experiencePackage(){return this.items.find((item=>"experiencePackage"===item.type))}async resetExperiencePackage(){const skills=this.items.filter((item=>item.getItemFlag("experiencePackage")));for(let index=0;index<skills.length;index++)await skills[index].unsetItemFlag("occupation");this.experiencePackage&&await this.experiencePackage.delete()}async resetOccupation(eraseOld=!0){if(eraseOld){const occupationSkill=this.items.filter((item=>item.getItemFlag("occupation")));for(let index=0;index<occupationSkill.length;index++)await occupationSkill[index].unsetItemFlag("occupation")}this.occupation&&await this.occupation.delete(),await this.update({"system.development.occupation":null})}async resetArchetype(eraseOld=!0){if(eraseOld){const archetypeSkill=this.items.filter((item=>item.getItemFlag("archetype")));for(let index=0;index<archetypeSkill.length;index++)await archetypeSkill[index].unsetItemFlag("archetype")}this.archetype&&await this.archetype.delete(),await this.update({"system.development.archetype":null})}get luck(){return parseInt(this.system.attribs?.lck?.value)}async setLuck(value){return await this.update({"system.attribs.lck.value":value})}async spendLuck(amount){return amount=parseInt(amount),this.luck>=amount&&this.setLuck(this.luck-amount)}get hp(){return parseInt(this.system.attribs.hp.value)}get rawHpMax(){return this.system.attribs.hp.auto?null!=this.system.characteristics.siz.value&&null!=this.system.characteristics.con.value?CoCActor.hpFromCharacteristics(this.system.characteristics,this.type):this.system.attribs.hp.max?parseInt(this.system.attribs.hp.max):null:parseInt(this.system.attribs.hp.max)}get hpMax(){return parseInt(this.system.attribs.hp.max)}async _setHp(value){return value<0&&(value=0),value>this.system.attribs.hp.max&&(value=parseInt(this.system.attribs.hp.max)),await this.update({"system.attribs.hp.value":value})}async addUniqueItems(skillList,flag=null){const processed=[];for(let skill of skillList)if(skill=foundry.utils.duplicate(skill),flag&&(Object.prototype.hasOwnProperty.call(skill.system,"flags")||(skill.system.flags={}),skill.system.flags[flag]=!0),CoC7Item.isAnySpec(skill))processed.push(skill);else{const itemId=this.getItemIdByName(skill.name);if(itemId){if(flag){const item=this.items.get(itemId);await item.setItemFlag(flag)}}else processed.push(skill)}0!==processed.length&&await this.createEmbeddedDocuments("Item",processed,{renderSheet:!1})}async addItems(itemList,flag=null){const processed=[];for(const item of itemList)flag&&(item.system.flags||(item.system.flags={}),item.system.flags[flag]=!0),processed.push(foundry.utils.duplicate(item));if(0!==processed.length)return await this.createEmbeddedDocuments("Item",processed,{renderSheet:!1})}async addUniqueItem(skill,flag=null){const itemId=this.getItemIdByName(skill.name);if(itemId){if(flag){const item=this.items.get(itemId);await item.setItemFlag(flag)}}else flag&&(skill.system.flags||(skill.system.flags={}),skill.system.flags[flag]=!0),await this.createEmbeddedDocuments("Item",[skill],{renderSheet:!1})}get rawMpMax(){return this.system.attribs.mp.auto?null!=this.system.characteristics.pow.value?CoCActor.mpFromCharacteristics(this.system.characteristics):0:parseInt(this.system.attribs.mp.max)}getReasonSanLoss(sanReason){return"string"==typeof sanReason?this.system.sanityLossEvents.filter((r=>r.type.toLocaleLowerCase()===sanReason.toLocaleLowerCase()))[0]??{type:"",totalLoss:0,immunity:!1}:{type:"",totalLoss:0,immunity:!1}}sanLostToReason(sanReason){if(sanReason){return this.getReasonSanLoss(sanReason).totalLoss}return 0}sanLossReasonEncountered(sanReason){if(sanReason){return""!==this.getReasonSanLoss(sanReason).type}return!1}setReasonSanLoss(sanReason,sanLoss){if("string"==typeof sanReason&&""!==sanReason){const sanityLossEvents=foundry.utils.duplicate(this.system.sanityLossEvents),index=sanityLossEvents.findIndex((r=>r.type.toLocaleLowerCase()===sanReason.toLocaleLowerCase()));return sanLoss>0?-1===index?sanityLossEvents.push({type:sanReason,totalLoss:sanLoss,immunity:!1}):sanityLossEvents[index].totalLoss+=sanLoss:index>-1&&(sanityLossEvents.splice(index,1),sanityLossEvents.sort((function(left,right){return left.type.localeCompare(right.type)}))),this.update({"system.sanityLossEvents":sanityLossEvents})}}maxLossToSanReason(sanReason,sanMaxFormula){const sanMax=new Roll(sanMaxFormula.toString())[foundry.utils.isNewerVersion(game.version,"12")?"evaluateSync":"evaluate"]({maximize:!0}).total,sanityLossEvent=this.getReasonSanLoss(sanReason);return sanityLossEvent.immunity?0:Math.max(0,sanMax-sanityLossEvent.totalLoss)}async looseSan(sanReason,sanLoss){return this.getReasonSanLoss(sanReason).immunity?0:(await this.setSan(this.san-sanLoss),sanLoss>0&&this.setReasonSanLoss(sanReason,sanLoss),sanLoss)}sanLoss(checkPassed){return checkPassed?this.sanLossCheckPassed:this.sanLossCheckFailled}get sanLossCheckPassed(){return this.system.special?.sanLoss?.checkPassed}get sanLossCheckFailled(){return this.system.special?.sanLoss?.checkFailled}get sanLossMax(){return this.sanLossCheckFailled?isNaN(Number(this.sanLossCheckFailled))?new Roll(this.sanLossCheckFailled)[foundry.utils.isNewerVersion(game.version,"12")?"evaluateSync":"evaluate"]({maximize:!0}).total:Number(this.sanLossCheckFailled):0}get sanLossMin(){return this.sanLossCheckPassed?isNaN(Number(this.sanLossCheckPassed))?new Roll(this.sanLossCheckPassed)[foundry.utils.isNewerVersion(game.version,"12")?"evaluateSync":"evaluate"]({maximize:!0}).total:Number(this.sanLossCheckPassed):0}get dailySanLoss(){return this.system.attribs.san?.dailyLoss||0}get dailySanLimit(){return this.system.attribs.san?.dailyLimit||0}get rawSanMax(){if(this.system.attribs)return this.system.attribs?.san?.auto?this.cthulhuMythos?Math.max(99-this.cthulhuMythos,0):99:parseInt(this.system.attribs.san.max)}get sanMax(){return parseInt(this.system.attribs.san.max)}get mp(){return parseInt(this.system.attribs.mp.value)}get mpMax(){return this.system.attribs.mp.auto?null!=this.system.characteristics.pow.value?Math.floor(this.system.characteristics.pow.value/5):0:parseInt(this.system.attribs.mp.max)}async setMp(value){return value<0&&(value=0),value>parseInt(this.system.attribs.mp.max)&&(value=parseInt(this.system.attribs.mp.max)),await this.update({"system.attribs.mp.value":value})}get san(){return parseInt(this.system.attribs.san.value)}get int(){return this.getCharacteristic("int")}get occupationPointsSpent(){let occupationPoints=0;for(const skill of this.skills)skill.system.adjustments?.occupation&&(occupationPoints+=skill.system.adjustments.occupation);return occupationPoints}get occupationPoints(){if(!this.occupation)return 0;let points=0;for(const entry of Object.entries(this.occupation.system.occupationSkillPoints)){const[key,value]=entry,char=this.getCharacteristic(key);value.selected&&(points+=char.value*Number(value.multiplier))}return points}async resetOccupationPoints(){await this.update({"system.development.occupation":this.occupationPoints})}async resetArchetypePoints(){await this.update({"system.development.archetype":this.occupationPoints})}async resetPersonalPoints(){await this.update({"system.development.personal":this.personalPoints})}get ExperiencePackagePointsSpent(){let count=0;for(const skill of this.skills)skill.system.adjustments?.experiencePackage&&(count+=skill.system.adjustments.experiencePackage);return count}get ExperiencePackagePoints(){return this.experiencePackage?this.experiencePackage.system.points:0}get archetypePointsSpent(){let archetypePoints=0;for(const skill of this.skills)skill.system.adjustments?.archetype&&(archetypePoints+=skill.system.adjustments.archetype);return archetypePoints}get archetypePoints(){return this.archetype?this.archetype.system.bonusPoints:0}get experiencePoints(){let experiencePoints=0;for(const skill of this.skills)skill.system.adjustments?.experience&&(experiencePoints+=skill.system.adjustments.experience);return experiencePoints}get personalPointsSpent(){let personalPoints=0;for(const skill of this.skills)skill.system.adjustments?.personal&&(personalPoints+=skill.system.adjustments.personal);return personalPoints}get personalPoints(){return 2*Number(this.system.characteristics.int.value)}get hasDevelopmentPhase(){for(const skill of this.skills)if(skill.system.flags?.developement)return!0;if(this.onlyRunOncePerSession)return!1;for(const sanityLossEvent of this.system.sanityLossEvents)if(!sanityLossEvent.immunity)return!0;return!1}async setSan(value){value<0&&(value=0),value>this.system.attribs.san.max&&(value=this.system.attribs.san.max);const loss=parseInt(this.system.attribs.san.value)-value;if(loss>0){let totalLoss=parseInt(this.system.attribs.san.dailyLoss)?parseInt(this.system.attribs.san.dailyLoss):0;totalLoss+=loss,loss>=5&&await this.setCondition(COC7.status.tempoInsane),totalLoss>=this.system.attribs.san.dailyLimit&&await this.setCondition(COC7.status.indefInsane),await this.update({"system.attribs.san.value":value,"system.attribs.san.dailyLoss":totalLoss})}else await this.update({"system.attribs.san.value":value});return value}async setAttribAuto(value,attrib){const updatedKey=`system.attribs.${attrib}.auto`;return await this.update({[updatedKey]:value})}async toggleAttribAuto(attrib){this.setAttribAuto(!this.system.attribs[attrib].auto,attrib)}static dbFromCharacteristics(characteristics){const sum=(characteristics.str.value??0)+(characteristics.siz.value??0);return sum<65?-2:sum<85?-1:sum<125?0:sum<165?"1D4":`${Math.floor((sum-45)/80)}D6`}static buildFromCharacteristics(characteristics){const sum=(characteristics.str.value??0)+(characteristics.siz.value??0);return sum<65?-2:sum<85?-1:sum<125?0:sum<165?1:Math.floor((sum-45)/80)+1}static hpFromCharacteristics(characteristics,type){const sum=parseInt(characteristics.siz.value??0,10)+parseInt(characteristics.con.value??0,10),divisor=game.settings.get("CoC7","pulpRuleDoubleMaxHealth")&&"character"===type?5:10;return Math.floor(sum/divisor)}static mpFromCharacteristics(characteristics){return Math.floor(characteristics.pow.value/5)}static movFromCharacteristics(characteristics,type,age){let MOV;return MOV=characteristics.dex.value>characteristics.siz.value&&characteristics.str.value>characteristics.siz.value?9:characteristics.dex.value>=characteristics.siz.value||characteristics.str.value>=characteristics.siz.value?8:7,"creature"===type||game.settings.get("CoC7","pulpRuleIgnoreAgePenalties")||isNaN(parseInt(age))||(MOV=parseInt(age)>=40?MOV-Math.floor(parseInt(age)/10)+3:MOV),Math.max(0,MOV)}get rawBuild(){return this.system.attribs&&this.system.attribs.build?("auto"===this.system.attribs.build.value&&(this.system.attribs.build.auto=!0),this.system.attribs.build.auto?CoCActor.buildFromCharacteristics(this.system.characteristics):this.system.attribs.build.value):null}get build(){return this.system.attribs.build.value}get rawDb(){return this.system.attribs&&this.system.attribs.db?("auto"===this.system.attribs.db.value&&(this.system.attribs.db.auto=!0),this.system.attribs.db.auto?CoCActor.dbFromCharacteristics(this.system.characteristics):this.system.attribs.db.value):null}get db(){return this.system.attribs.db.value}get rawMov(){if(!this.system.attribs)return null;if(!this.system.attribs.mov)return null;if("auto"===this.system.attribs.mov.value&&(this.system.attribs.mov.auto=!0),this.system.attribs.mov.auto){const MOV=CoCActor.movFromCharacteristics(this.system.characteristics,this.system.type,this.system.infos.age);if(MOV>0)return MOV}return this.system.attribs.mov.value}get mov(){return this.system.attribs.mov.value}get tokenId(){return this.token?`${this.token.scene._id}.${this.token.id}`:null}get locked(){return this.system.flags||(this.system.flags={},this.system.flags.locked=!0,this.update({"system.flags":{}}),this.update({"system.flags.locked":!1})),this.system.flags.locked}getItemsFromName(name){return this.items.filter((i=>i.name===name))}set locked(value){this.update({"system.flags.locked":value})}async toggleActorFlag(flagName){const flagValue=!this.system.flags[flagName],name=`system.flags.${flagName}`;await this.update({[name]:flagValue})}async attributeCheck(attributeName,fastForward=!1,options={}){const attrib=this.getAttribute(attributeName.toLowerCase());if(!attrib)return ui.notifications.error(game.i18n.format("CoC7.ErrorNotFound",{missing:attributeName})),null;const check=new CoC7Check;if(options.modifier&&(check.diceModifier=Number(options.modifier)),options.difficulty&&(check.difficulty=CoC7Utilities.convertDifficulty(options.difficulty)),!fastForward&&(void 0===options.difficulty||void 0===options.modifier)){const usage=await RollDialog.create(options);usage&&(check.diceModifier=Number(usage.get("bonusDice")),check.difficulty=Number(usage.get("difficulty")),check.flatDiceModifier=Number(usage.get("flatDiceModifier")),check.flatThresholdModifier=Number(usage.get("flatThresholdModifier")))}check.actor=this.tokenKey,"false"===options.blind?check.isBlind=!1:check.isBlind=!!options.blind,await check.rollAttribute(attrib.key),check.toMessage()}async characteristicCheck(characteristicName,fastForward=!1,options={}){const char=this.getCharacteristic(characteristicName);if(!char)return void ui.notifications.error(game.i18n.format("CoC7.ErrorNotFoundForActor",{missing:characteristicName,actor:this.name}));const check=new CoC7Check;if(options.modifier&&(check.diceModifier=Number(options.modifier)),options.difficulty&&(check.difficulty=CoC7Utilities.convertDifficulty(options.difficulty)),!fastForward&&(void 0===options.difficulty||void 0===options.modifier)){options.displayName=char.label;const usage=await RollDialog.create(options);usage&&(check.diceModifier=Number(usage.get("bonusDice")),check.difficulty=Number(usage.get("difficulty")),check.flatDiceModifier=Number(usage.get("flatDiceModifier")),check.flatThresholdModifier=Number(usage.get("flatThresholdModifier")))}check.actor=this.tokenKey,"false"===options.blind?check.isBlind=!1:check.isBlind=!!options.blind,await check.rollCharacteristic(char.key),check.toMessage()}static toolTipSkillText(){if(void 0!==game.CoC7Tooltips.ToolTipHover&&null!==game.CoC7Tooltips.ToolTipHover){const isCombat=game.CoC7Tooltips.ToolTipHover.classList?.contains("combat"),skillId=game.CoC7Tooltips.ToolTipHover.closest(".item")?.dataset.skillId,actorAppId=game.CoC7Tooltips.ToolTipHover.closest(".window-app")?.dataset?.appid;if(void 0!==skillId&&void 0!==actorAppId&&void 0!==ui.windows[actorAppId]?.actor?.id){const actorId=ui.windows[actorAppId].actor.id,actor=game.actors.get(actorId);if(actor){const skill=actor.items.get(skillId);if(skill){let toolTip=game.i18n.format(isCombat?"CoC7.ToolTipCombat":"CoC7.ToolTipSkill",{skill:skill.name,regular:skill.value,hard:Math.floor(skill.value/2),extreme:Math.floor(skill.value/5)});return game.user.isGM&&(toolTip+=game.i18n.format("CoC7.ToolTipKeeperSkill",{other:game.settings.get("CoC7","stanbyGMRolls")&&actor.hasPlayerOwner?game.i18n.format("CoC7.ToolTipKeeperStandbySkill",{name:actor.name}):""})),toolTip}}}}return!1}async getItemOrAdd(itemIdentifier,type="skill"){if(itemIdentifier.match(/^i\.([^\\.]+)\../)){let item=this.getFirstItemByCoCID(itemIdentifier);if(!item){const newItems=await game.system.api.cocid.fromCoCIDBest({cocid:itemIdentifier,showLoading:!0});if(1===newItems.length&&(await this.createEmbeddedDocuments("Item",newItems),item=this.getFirstItemByCoCID(itemIdentifier),item))if("skill"===item.type)ui.notifications.info(game.i18n.format("CoC7.InfoSkillAddedAtBase",{name:item.name,percent:item.value}));else if("weapon"===item.type){await item.reload();const updates={};if(""===item.system.skill.main.id&&""!==item.system.skill.main.name){const skill=await this.getItemOrAdd(item.system.skill.main.name,"skill");skill.length&&(updates["system.skill.main.id"]=skill[0].id,updates["system.skill.main.name"]=skill[0].name)}if(""===item.system.skill.alternativ.id&&""!==item.system.skill.alternativ.name){const skill=await this.getItemOrAdd(item.system.skill.alternativ.name,"skill");skill.length&&(updates["system.skill.alternativ.id"]=skill[0].id,updates["system.skill.alternativ.name"]=skill[0].name)}Object.keys(updates).length&&await item.update(updates)}}if(item)return[item]}let myItems=this.getSkillsByName(itemIdentifier);if(!myItems.length){const era=game.settings.get("CoC7","worldEra"),newItem=game.items.find((d=>{if(d.type===type&&d.name===itemIdentifier){const eras=newItem.flags?.CoC7?.cocidFlag?.eras;return!(eras&&Object.keys(eras).length>0&&!eras[era])}return!1}));if(newItem&&myItems.push(newItem),0===myItems.length)for(const pack of game.packs)if("Item"===pack.metadata?.type){await pack.getDocuments();const newItem=game.items.find((d=>{if(d.type===type&&d.name===itemIdentifier){const eras=newItem.flags?.CoC7?.cocidFlag?.eras;return!(eras&&Object.keys(eras).length>0&&!eras[era])}return!1}));newItem&&myItems.push(newItem)}if(1===myItems.length&&(await this.createEmbeddedDocuments("Item",myItems),myItems=this.getSkillsByName(itemIdentifier),1===myItems.length))if("skill"===myItems[0].type)ui.notifications.info(game.i18n.format("CoC7.InfoSkillAddedAtBase",{name:myItems[0].name,percent:myItems[0].value}));else if("weapon"===myItems[0].type){await myItems[0].reload();const updates={};if(""===myItems[0].system.skill.main.id&&""!==myItems[0].system.skill.main.name){const skill=await this.getItemOrAdd(myItems[0].system.skill.main.name,"skill");skill.length&&(updates["system.skill.main.id"]=skill[0].id,updates["system.skill.main.name"]=skill[0].name)}if(""===myItems[0].system.skill.alternativ.id&&""!==myItems[0].system.skill.alternativ.name){const skill=await this.getItemOrAdd(myItems[0].system.skill.alternativ.name,"skill");skill.length&&(updates["system.skill.alternativ.id"]=skill[0].id,updates["system.skill.alternativ.name"]=skill[0].name)}Object.keys(updates).length&&await myItems[0].update(updates)}}return myItems}async skillCheck(skillData,fastForward,options={}){const skillIdentifier=skillData.name?skillData.name:skillData;let skill=await this.getItemOrAdd(skillIdentifier,"skill");if(skill.length&&(options.name=skill[0].name),!skill.length){let item=null;if(skillData.pack){const pack=game.packs.get(skillData.pack);if("Item"!==pack.metadata.entity)return;item=await pack.getDocument(skillData.id)}else skillData.id&&(item=game.items.get(skillData.id));if(!item){const check=new CoC7Check;check._rawValue="?",await check.roll(),check.toMessage()}if(!item)return ui.notifications.warn(game.i18n.format("CoC7.NoSkill")+" "+game.i18n.format("CoC7.ErrorNotFoundForActor",{missing:skillIdentifier,actor:this.name}));let create=!1;if(await Dialog.confirm({title:`${game.i18n.localize("CoC7.AddWeapon")}`,content:`<p>${game.i18n.format("CoC7.AddWeapontHint",{weapon:skillData.name,actor:this.name})}</p>`,yes:()=>{create=!0}}),!0!==create)return;if(await this.createEmbeddedDocuments("Item",[foundry.utils.duplicate(item)]),skill=this.getSkillsByName(item.name),!skill.length)return;if(game.user.isGM){const skillValue=await SkillValueDialog.create(skill[0].name,skill[0].base),value=Number(skillValue.get("base-value"));await skill[0].updateValue(value)}}const check=new CoC7Check;if(void 0!==options.modifier&&(check.diceModifier=Number(options.modifier)),void 0!==options.difficulty&&(check.difficulty=CoC7Utilities.convertDifficulty(options.difficulty)),!fastForward&&(void 0===options.difficulty||void 0===options.modifier)){const usage=await RollDialog.create(options);usage&&(check.diceModifier=Number(usage.get("bonusDice")),check.difficulty=Number(usage.get("difficulty")),check.flatDiceModifier=Number(usage.get("flatDiceModifier")),check.flatThresholdModifier=Number(usage.get("flatThresholdModifier")))}return check.actor=this.tokenKey,check.skill=skill[0].id,"false"===options.blind?check.isBlind=!1:check.isBlind=!!options.blind,"false"===options.pushing?check.pushing=!1:check.pushing=!!options.pushing,await check.roll(),check.toMessage(check.pushing),check}async weaponCheck(weaponData,fastForward=!1){let weapon;if(void 0!==weaponData.uuid&&(weapon=await fromUuid(weaponData.uuid)),void 0!==weaponData.id&&(weapon=this.items.get(weaponData.id)),!weapon){let weapons=this.getItemsFromName(weaponData.name);if(0===weapons.length){if(!game.user.isGM)return void ui.notifications.warn(game.i18n.format("CoC7.ErrorActorHasNoWeaponNamed",{actorName:this.name,weaponName:weaponData.name}));{let item=null;const pack=weaponData.pack?game.packs.get(weaponData.pack):null;if(pack){if("Item"!==pack.metadata.entity)return;item=await pack.getDocument(weaponData.id)}else weaponData.id&&(item=game.items.get(weaponData.id));if(!item)return ui.notifications.warn(game.i18n.localize("CoC7.WarnMacroNoItemFound"));let create=!1;await Dialog.confirm({title:`${game.i18n.localize("CoC7.AddWeapon")}`,content:`<p>${game.i18n.format("CoC7.AddWeapontHint",{weapon:weaponData.name,actor:this.name})}</p>`,yes:()=>{create=!0}});const actor=void 0!==this.parent?.actor?this.parent.actor:this;if(!0!==create)return;if(await actor.createEmbeddedDocuments("Item",[item.toJSON()]),weapons=actor.getItemsFromName(item.name),!weapons.length)return;await weapons[0].reload()}}else weapons.length>1&&ui.notifications.warn(game.i18n.format("CoC7.ErrorActorHasTooManyWeaponsNamed",{actorName:this.name,weaponName:weaponData.name}));weapon=weapons[0]}if(!weapon.system.properties.rngd){game.user.targets.size>1&&ui.notifications.warn(game.i18n.localize("CoC7.WarnTooManyTarget"));new CoC7MeleeInitiator(this.tokenKey,weaponData.uuid||weapon.id,fastForward).createChatCard()}if(weapon.system.properties.rngd){new CoC7RangeInitiator(this.tokenKey,weaponData.uuid||weapon.id,fastForward).createChatCard()}}async rollInitiative(hasGun=!1){if("optional"===game.settings.get("CoC7","initiativeRule")){const roll=new CoC7Check(this.actorKey);return roll.denyPush=!0,roll.denyLuck=!0,roll.denyBlindTampering=!0,roll.hideDice=!1===game.settings.get("CoC7","displayInitDices"),roll.flavor="Initiative roll",await roll.rollCharacteristic("dex",hasGun?1:0),roll.toMessage(),roll.successLevel+this.system.characteristics.dex.value/100}return hasGun?this.system.characteristics.dex.value+50:this.system.characteristics.dex.value}getActorFlag(flagName){return this.system.flags?!!this.system.flags[flagName]&&this.system.flags[flagName]:(this.system.flags={},this.system.flags.locked=!0,this.update({"system.flags":{}}),!1)}async setActorFlag(flagName){await this.update({[`system.flags.${flagName}`]:!0})}async unsetActorFlag(flagName){await this.update({[`system.flags.${flagName}`]:!1})}getWeaponSkills(itemId){let weapon=fromUuidSync(itemId);if(weapon?void 0===weapon.system&&(weapon=game.packs.get(weapon.pack).get(weapon._id)):weapon=this.items.get(itemId),"weapon"!==weapon.type)return null;const skills=[];return weapon.system.skill.main.id&&skills.push(this.items.get(weapon.system.skill.main.id)),weapon.usesAlternativeSkill&&weapon.system.skill.alternativ.id&&skills.push(this.items.get(weapon.system.skill.alternativ.id)),skills}find(name){if(!name)return;const item=this.items.get(name);if(item)return{type:"item",value:item};const matches=/\(([^)]+)\)/.exec(name);let shortName=null;matches&&matches.length&&(shortName=matches[1]);const skill=this.skills.filter((s=>!!s.name&&(s.name.toLocaleLowerCase().replace(/\s/g,"")===name.toLocaleLowerCase().replace(/\s/g,"")||s.name.toLocaleLowerCase().replace(/\s/g,"")===name.toLocaleLowerCase().replace(/\s/g,"")||s.name.toLocaleLowerCase().replace(/\s/g,"")===shortName?.toLocaleLowerCase().replace(/\s/g,""))));if(skill.length)return{type:"item",value:skill[0]};const charKey=["str","con","siz","dex","app","int","pow","edu"];for(let i=0;i<charKey.length;i++){const char=this.getCharacteristic(charKey[i]);if(char){if(char.name=char.label,char.key?.toLocaleLowerCase()===name.toLowerCase()||char.key?.toLocaleLowerCase()===shortName?.toLowerCase())return{type:"characteristic",value:char};if(char.shortName?.toLocaleLowerCase()===name.toLowerCase()||char.shortName?.toLocaleLowerCase()===shortName?.toLowerCase())return{type:"characteristic",value:char};if(char.label?.toLocaleLowerCase()===name.toLowerCase()||char.label?.toLocaleLowerCase()===shortName?.toLowerCase())return{type:"characteristic",value:char}}}const attribKey=["lck","san"];for(let i=0;i<attribKey.length;i++){const attr=this.getAttribute(attribKey[i]);if(attr){if(attr.name=attr.label,attr.key?.toLocaleLowerCase()===name.toLowerCase()||attr.key?.toLocaleLowerCase()===shortName?.toLowerCase())return{type:"attribute",value:attr};if(attr.shortName?.toLocaleLowerCase()===name.toLowerCase()||attr.shortName?.toLocaleLowerCase()===shortName?.toLowerCase())return{type:"attribute",value:attr};if(attr.label?.toLocaleLowerCase()===name.toLowerCase()||attr.label?.toLocaleLowerCase()===shortName?.toLowerCase())return{type:"attribute",value:attr}}}}get pilotSkills(){return this.skills.filter((s=>s.system.properties?.special&&s.system.specialization?.toLocaleLowerCase()===game.i18n.localize("CoC7.PilotSpecializationName")?.toLocaleLowerCase()))}get driveSkills(){return this.skills.filter((s=>s.system.properties?.special&&s.system.specialization?.toLocaleLowerCase()===game.i18n.localize("CoC7.DriveSpecializationName")?.toLocaleLowerCase()))}get tokenUuid(){return this.sheet.token?this.sheet.token.uuid:null}get tokenKey(){return this.sheet.token?`${this.sheet.token.parent.id}.${this.sheet.token.id}`:this.id}get actorKey(){return this.prototypeToken.actorLink?this.id:this.tokenKey}static getActorFromKey(key){if(key.includes(".")){const[sceneId,tokenId]=key.split(".");if("TOKEN"===sceneId)return game.actors.tokens[tokenId];{const scene=game.scenes.get(sceneId);if(!scene)return null;const tokenData=scene.getEmbeddedDocument("Token",tokenId);if(!tokenData)return null;return new Token(tokenData).actor}}return game.actors.get(key)||null}get hasRollableCharacteristics(){if(this.system.characteristics)for(const[,value]of Object.entries(this.system.characteristics))if(isNaN(Number(value.formula)))return!0;return!1}get hosRollableSkills(){for(const skill of this.skills)if(isNaN(skill.system?.value))return!0;return!1}async rollCharacteristicsValue(){const characteristics={};for(const[key,value]of Object.entries(this.system.characteristics))if(value.formula&&!value.formula.startsWith("@")){const r=new Roll(value.formula);await r.roll({async:!0}),r.total&&(characteristics[`system.characteristics.${key}.value`]=Math.floor(r.total))}await this.update(characteristics),await this.reportCharactedriticsValue()}async averageCharacteristicsValue(){const characteristics={};for(const[key,value]of Object.entries(this.system.characteristics))if(value.formula&&!value.formula.startsWith("@")){const average=new AverageRoll("("+value.formula+")")[foundry.utils.isNewerVersion(game.version,"12")?"evaluateSync":"evaluate"]({minimize:!0,maximize:!0}).total;characteristics[`system.characteristics.${key}.value`]=average}await this.update(characteristics),await this.reportCharactedriticsValue()}async reportCharactedriticsValue(){const characteristics={};for(const[key,value]of Object.entries(this.system.characteristics))if(value.formula&&value.formula.startsWith("@")){let charValue;try{charValue=new Roll(value.formula,this.parseCharacteristics())[foundry.utils.isNewerVersion(game.version,"12")?"evaluateSync":"evaluate"]({maximize:!0}).total}catch(err){charValue=null}charValue&&(characteristics[`system.characteristics.${key}.value`]=charValue)}await this.update(characteristics)}async setCharacteristic(name,value){const characteristic={},charValue=isNaN(parseInt(value))?null:parseInt(value);if(characteristic[name]=charValue,!charValue&&value.startsWith("@")){characteristic[name.replace(".value",".formula")]=value}await this.update(characteristic),await this.reportCharactedriticsValue()}async developementPhase(fastForward=!1){const failure=[],success=[],title=game.i18n.localize("CoC7.RollAll4Dev");let skillsRolled=0,message='<p class="chat-card">';for(const item of this.items)if("skill"===item.type&&item.developementFlag){skillsRolled++;const die=await new Die({faces:100}).evaluate({async:!0}),skillValue=item.value;let augment=null,skillMasteringMessage=null;if(die.total>skillValue||die.total>=95){const augmentDie=await new Die({faces:10}).evaluate({async:!0});if(success.push(item.id),skillValue<90&&skillValue+augmentDie.total>=90){const augmentSANDie=await new Die({faces:6,number:2}).evaluate({async:!0}),sanGained=augmentSANDie.total,sanGainedMessage=`Gained 2d6 (${augmentSANDie.values[0]} + ${augmentSANDie.values[1]} = ${sanGained}) SAN`;console.debug(sanGainedMessage),skillMasteringMessage=`<span class="upgrade-success">${game.i18n.format("CoC7.SanGained",{results:`${augmentSANDie.values[0]} + ${augmentSANDie.values[1]}`,sanGained,skill:item.name,skillValue:skillValue+augmentDie.total})}</span><br>`,await this.setSan(this.san+sanGained)}augment+=augmentDie.total,message+=`<span class="upgrade-success">${game.i18n.format("CoC7.DevSuccess",{item:item.name,die:die.total,score:item.value,augment:augmentDie.total})}</span><br>`,null!==skillMasteringMessage&&(message+=skillMasteringMessage),await item.increaseExperience(augment)}else message+=`<span class="upgrade-failed">${game.i18n.format("CoC7.DevFailure",{item:item.name,die:die.total,score:item.value})}</span><br>`,failure.push(item.id);await item.unflagForDevelopement()}const sanityLossEvents=[];let changed=!1;for(const sanityLossEvent of this.system.sanityLossEvents)sanityLossEvent.immunity?sanityLossEvents.push(sanityLossEvent):sanityLossEvent.totalLoss>1?(sanityLossEvent.totalLoss--,sanityLossEvents.push(sanityLossEvent),changed=!0):changed=!0;if(changed&&(skillsRolled&&(message+="<br>"),message+=`<span>${game.i18n.format("CoC7.ReduceSanityLimits")}</span>`,await this.update({"system.sanityLossEvents":sanityLossEvents})),!fastForward){message+="</p>";const speaker={actor:this};await chatHelper.createMessage(skillsRolled?title:"",message,{speaker}),this.onlyRunOncePerSession=!0}return{failure,success}}async developLuck(fastForward=!1){const currentLuck=this.system.attribs.lck.value;currentLuck||await this.update({"system.attribs.lck.value":0});const pulpRuleDevelopmentRollLuck=game.settings.get("CoC7","pulpRuleDevelopmentRollLuck"),upgradeRoll=(await new Roll("1D100").roll({async:!0})).total,higherThanCurrentLuck=upgradeRoll>currentLuck;let augmentRoll;pulpRuleDevelopmentRollLuck?augmentRoll=higherThanCurrentLuck?"2D10+10":"1D10+5":higherThanCurrentLuck&&(augmentRoll="1D10");const title=game.i18n.localize("CoC7.RollLuck4Dev");let message='<p class="chat-card">';if(pulpRuleDevelopmentRollLuck||higherThanCurrentLuck){const augmentValue=(await new Roll(augmentRoll).roll({async:!0})).total;await this.update({"system.attribs.lck.value":this.system.attribs.lck.value+augmentValue}),message+=`<span class="upgrade-success">${game.i18n.format("CoC7.LuckIncreased",{die:upgradeRoll,score:currentLuck,augment:augmentValue})}</span>`}else message+=`<span class="upgrade-failed">${game.i18n.format("CoC7.LuckNotIncreased",{die:upgradeRoll,score:currentLuck})}</span>`;if(!fastForward){message+="</p>";const speaker={actor:this};await chatHelper.createMessage(title,message,{speaker})}}async developSkill(skillId,fastForward=!1){const skill=this.items.get(skillId);if(!skill)return;let title="",message="";const upgradeRoll=new Roll("1D100");if(await upgradeRoll.roll({async:!0}),fastForward||await CoC7Dice.showRollDice3d(upgradeRoll),upgradeRoll.total>skill.value||upgradeRoll.total>=95){const augmentRoll=new Roll("1D10");await augmentRoll.roll({async:!0}),fastForward||await CoC7Dice.showRollDice3d(augmentRoll),message=game.i18n.format("CoC7.DevSuccessDetails",{item:skill.name,augment:augmentRoll.total}),title=game.i18n.format("CoC7.DevRollTitle",{item:skill.name,die:upgradeRoll.total,score:skill.value}),await skill.increaseExperience(augmentRoll.total)}else title=game.i18n.format("CoC7.DevRollTitle",{item:skill.name,die:upgradeRoll.total,score:skill.value}),message=game.i18n.format("CoC7.DevFailureDetails",{item:skill.name});const speaker={actor:this._id};await chatHelper.createMessage(title,message,{speaker}),await skill.unflagForDevelopement()}hasConditionStatus(conditionName){const conditionValue=this.system.conditions?.[conditionName]?.value;return"boolean"==typeof conditionValue&&conditionValue}hasConditionValue(conditionName,field){if(this.hasConditionStatus(conditionName)){if(conditionName===COC7.status.tempoInsane&&"durationText"===field){const realTime=this.hasConditionValue(conditionName,"realTime"),duration=this.hasConditionValue(conditionName,"duration");if(void 0!==duration){if(!0===realTime)return duration+" "+game.i18n.localize("CoC7.rounds");if(!1===realTime)return duration+" "+game.i18n.localize("CoC7.hours")}return""}return this.system.conditions?.[conditionName]?.[field]}}async toggleCondition(conditionName){this.hasConditionStatus(conditionName)?await this.unsetCondition(conditionName):await this.setCondition(conditionName)}async setCondition(conditionName,{forceValue=!1,justThis=!1,realTime=null,duration=null}={}){if(!forceValue&&game.settings.get("CoC7","enableStatusIcons")){const effects=this.effects.filter((effect=>CoC7ActiveEffect.filterActiveEffects(effect,conditionName))).map((effect=>effect.id)),custom={};switch(conditionName){case COC7.status.dead:custom.flags={core:{overlay:!0}};break;case COC7.status.tempoInsane:custom.flags={CoC7:{realTime:void 0}},custom.duration={rounds:void 0,seconds:void 0},!0!==realTime&&!1!==realTime||(custom.flags.CoC7.realTime=realTime,custom.flags={CoC7:{realTime}},null!=duration&&(realTime?custom.duration.rounds=duration:custom.duration.seconds=3600*duration))}if(0===effects.length){const effect=CONFIG.statusEffects.filter((effect=>effect.id===conditionName));if(1===effect.length){const source={icon:effect[0].icon,disabled:!1};source.name=game.i18n.localize(effect[0].name),source.statuses=[effect[0].id];const effectData=foundry.utils.mergeObject(source,custom);await super.createEmbeddedDocuments("ActiveEffect",[effectData])}else forceValue=!0}else custom._id=effects[0],await super.updateEmbeddedDocuments("ActiveEffect",[custom]),forceValue=!0}if(forceValue||!game.settings.get("CoC7","enableStatusIcons")){switch(conditionName){case COC7.status.indefInsane:case COC7.status.unconscious:case COC7.status.criticalWounds:case COC7.status.dying:case COC7.status.prone:case COC7.status.dead:await this.update({[`system.conditions.${conditionName}.value`]:!0});break;case COC7.status.tempoInsane:{const fields={};fields[`system.conditions.${conditionName}.value`]=!0,!0!==realTime&&!1!==realTime||(fields[`system.conditions.${conditionName}.realTime`]=realTime,null!=duration&&(fields[`system.conditions.${conditionName}.duration`]=duration)),Object.prototype.hasOwnProperty.call(fields,`system.conditions.${conditionName}.realTime`)||(fields[`system.conditions.${conditionName}.-=realTime`]=null),Object.prototype.hasOwnProperty.call(fields,`system.conditions.${conditionName}.duration`)||(fields[`system.conditions.${conditionName}.-=duration`]=null),await this.update(fields)}}if(!justThis)switch(conditionName){case COC7.status.criticalWounds:if(await this.setCondition(COC7.status.prone),!this.hasConditionStatus(COC7.status.unconscious)&&!this.hasConditionStatus(COC7.status.dead)){new CoC7ConCheck(this.isToken?this.tokenKey:this.id).toMessage()}break;case COC7.status.dead:await this.unsetCondition(COC7.status.criticalWounds),await this.unsetCondition(COC7.status.dying),await this.unsetCondition(COC7.status.unconscious)}}}async unsetCondition(conditionName,{forceValue=!1}={}){if(!forceValue&&game.settings.get("CoC7","enableStatusIcons")){const effects=this.effects.filter((effect=>CoC7ActiveEffect.filterActiveEffects(effect,conditionName))).map((effect=>effect.id));effects.length>0?await super.deleteEmbeddedDocuments("ActiveEffect",effects):forceValue=!0}if(forceValue||!game.settings.get("CoC7","enableStatusIcons"))switch(conditionName){case COC7.status.tempoInsane:case COC7.status.indefInsane:case COC7.status.unconscious:case COC7.status.criticalWounds:case COC7.status.dying:case COC7.status.prone:case COC7.status.dead:await this.update({[`system.conditions.${conditionName}.-=value`]:null}),await this.update({[`system.conditions.${conditionName}.value`]:!1})}}async resetCounter(counter){await this.update({[counter]:0})}async resetDailySanity(){await this.update({"system.attribs.san.dailyLimit":Math.floor(this.system.attribs.san.value/5),"system.attribs.san.dailyLoss":0})}get fightingSkills(){const skillList=[];for(const value of this.items)"skill"===value.type&&value.system.properties.fighting&&skillList.push(value);return skillList.sort(CoC7Utilities.sortByNameKey),skillList}get closeCombatWeapons(){const weaponList=[];for(const value of this.items)if("weapon"===value.type&&!value.system.properties.rngd){const skill=this.items.get(value.system.skill.main.id);value.system.skill.main.value=skill?skill.value:0,weaponList.push(value)}return weaponList.sort(CoC7Utilities.sortByNameKey),weaponList}get firearmSkills(){const skillList=[];for(const value of this.items)"skill"===value.type&&(value.system.properties.firearm||value.system.properties.ranged||"i.skill.fighting-throw"===value.flags.CoC7?.cocidFlag?.id)&&skillList.push(value);return skillList.sort(CoC7Utilities.sortByNameKey),skillList}weaponSkillGroups(rangedFirst=!1){const skills=[];for(const item of this.items)if("skill"===item.type){let sort=3,group="CoC7.Skills",name=item.name;item.system.properties.fighting?(sort=rangedFirst?2:0,group="CoC7.SkillFighting",foundry.utils.isNewerVersion(game.version,"12")&&(name=item.system.skillName)):item.system.properties.firearm?(sort=rangedFirst?0:1,group="CoC7.SkillFirearm",foundry.utils.isNewerVersion(game.version,"12")&&(name=item.system.skillName)):item.system.properties.ranged&&(sort=rangedFirst?1:2,group="CoC7.SkillRanged",foundry.utils.isNewerVersion(game.version,"12")&&(name=item.system.skillName)),skills.push({id:item.id,name,group,sort})}return skills.sort(((a,b)=>a.sort===b.sort?a.name.normalize("NFD").replace(/[\u0300-\u036f]/g,"").toLocaleLowerCase().localeCompare(b.name.normalize("NFD").replace(/[\u0300-\u036f]/g,"").toLocaleLowerCase()):a.sort-b.sort)),skills}get user(){return game.users.find((user=>!(!user.character||user.character.id!==this.id)))}get dodgeSkill(){const skill=this.getFirstItemByCoCID("i.skill.dodge");if(skill)return skill;const skillList=this.getSkillsByName(game.i18n.localize("CoC7.CoCIDFlag.keys.i.skill.dodge"));return 0!==skillList.length?skillList[0]:null}get creditRatingSkill(){const skill=this.getFirstItemByCoCID("i.skill.credit-rating");if(skill)return skill;const skillList=this.getSkillsByName(game.i18n.localize("CoC7.CoCIDFlag.keys.i.skill.credit-rating"));return 0!==skillList.length?skillList[0]:null}get cthulhuMythosSkill(){const skill=this.getFirstItemByCoCID("i.skill.cthulhu-mythos");if(skill)return skill;const skillList=this.getSkillsByName(game.i18n.localize("CoC7.CoCIDFlag.keys.i.skill.cthulhu-mythos"));return 0!==skillList.length?skillList[0]:null}get cthulhuMythos(){const CM=this.cthulhuMythosSkill;if(CM){const value=CM.value;return value||parseInt(CM.system.value)}return 0}get mythosHardened(){return this.getFlag("CoC7","mythosHardened")||!1}get useMythosHardened(){return this.mythosHardened&&game.settings.get("CoC7","allowMythosHardened")}async setMythosHardened(){await this.setFlag("CoC7","mythosHardened",!0)}get mythosInsanityExperienced(){return this.getFlag("CoC7","mythosInsanityExperienced")||!1}async experienceFirstMythosInsanity(){await this.setFlag("CoC7","mythosInsanityExperienced",!0)}get creditRating(){const CR=this.creditRatingSkill;if(CR){const value=CR.value;return value||parseInt(CR.system.value)}return 0}static monetaryFormat(format,symbol,value){switch(format){case COC7.monetaryFormatKeys.lsd:return Math.floor(value/240)+"/"+Math.floor(value/12)%20+"/"+value%12;case COC7.monetaryFormatKeys.roman:return Math.floor(value/400)+"/"+Math.floor(value/16)%25+"/"+Math.floor(value/8)%2+"/"+Math.floor(value/4)%2+"/"+value%4;case COC7.monetaryFormatKeys.decimalLeft:return symbol+Number(value).toLocaleString(void 0,{minimumFractionDigits:2}).replace(/\.00$/,"");case COC7.monetaryFormatKeys.decimalRight:return Number(value).toLocaleString(void 0,{minimumFractionDigits:2}).replace(/\.00$/,"")+" "+symbol;case COC7.monetaryFormatKeys.integerLeft:return symbol+Number(value).toLocaleString();case COC7.monetaryFormatKeys.integerRight:return Number(value).toLocaleString()+" "+symbol}return"0"}static monetaryValue(format,values,CR,type,value){CR=CR||0;const row=values.find((r=>("object"==typeof r.min||r.min<=CR)&&("object"==typeof r.max||r.max>=CR)));if(void 0!==row&&void 0!==row[type]&&void 0!==row[value])switch(format){case COC7.monetaryFormatKeys.lsd:switch(row[type]){case COC7.monetaryTypeKeys.multiplier:return 240*CR*row[value];case COC7.monetaryTypeKeys.value:return 240*row[value];case COC7.monetaryTypeKeys.s:return 12*row[value];case COC7.monetaryTypeKeys.d:return 1*row[value]}break;case COC7.monetaryFormatKeys.roman:switch(row[type]){case COC7.monetaryTypeKeys.multiplier:return 400*CR*row[value];case COC7.monetaryTypeKeys.value:return 400*row[value];case COC7.monetaryTypeKeys.denarii:return 16*row[value];case COC7.monetaryTypeKeys.quinarii:return 8*row[value];case COC7.monetaryTypeKeys.sestertii:return 4*row[value];case COC7.monetaryTypeKeys.asses:return 1*row[value]}break;default:switch(row[type]){case COC7.monetaryTypeKeys.multiplier:return CR*row[value];case COC7.monetaryTypeKeys.value:return 1*row[value]}}return 0}get spendingLevel(){return CoCActor.monetaryValue(this.system.monetary.format,this.system.monetary.values,this.creditRating,"spendingType","spendingValue")}get cash(){return CoCActor.monetaryValue(this.system.monetary.format,this.system.monetary.values,this.creditRating,"cashType","cashValue")}get assets(){return CoCActor.monetaryValue(this.system.monetary.format,this.system.monetary.values,this.creditRating,"assetsType","assetsValue")}get skills(){const skillList=[];for(const value of this.items)"skill"===value.type&&skillList.push(value);return skillList.sort(CoC7Utilities.sortByNameKey),skillList}get owners(){return game.users.filter((u=>this.testUserPermission(u,"OWNER")&&!u.isGM))}get player(){return this.owners.filter((u=>u.character?.id===this.id))}get characterUser(){return game.users.contents.filter((u=>u.character?.id===this.id))[0]||null}async setHp(value){value<0&&(value=0),value>this.system.attribs.hp.max&&(value=this.system.attribs.hp.max);const healthBefore=this.hp;let damageTaken;return isNaN(healthBefore)||value>=healthBefore?await this._setHp(value):(damageTaken=healthBefore-value,await this.dealDamage(damageTaken,{ignoreArmor:!0})),value}async dealDamage(amount,options={}){const armorData=options.armor?options.armor:this.system.attribs.armor,grossDamage=parseInt(amount);let armorValue=0;options.ignoreArmor||null===armorData||(CoC7Utilities.isFormula(armorData)?armorValue=(await new Roll(armorData).roll({async:!0})).total:isNaN(Number(armorData))?isNaN(Number(armorData?.value))?ui.notifications.warn(game.i18n.format("CoC7.ErrorUnableToParseArmorFormula",{value:armorData})):armorValue=Number(armorData.value):armorValue=Number(armorData));const netDamage=grossDamage-armorValue;if(netDamage<=0)return 0;if(await this._setHp(this.hp-netDamage),netDamage>=this.system.attribs.hp.max)await this.setCondition(COC7.status.dead);else if(game.settings.get("CoC7","pulpRuleIgnoreMajorWounds")){if(0===this.hp)netDamage>=Math.ceil(this.system.attribs.hp.max/2)?this.setCondition(COC7.status.dying):this.setCondition(COC7.status.unconscious);else if(netDamage>=Math.ceil(this.system.attribs.hp.max/2)){new CoC7ConCheck(this.isToken?this.tokenKey:this.id).toMessage()}}else{let hasMajorWound=!1;netDamage>=Math.ceil(this.system.attribs.hp.max/2)?(await this.setCondition(COC7.status.criticalWounds),hasMajorWound=!0):hasMajorWound=this.hasConditionStatus(COC7.status.criticalWounds),0===this.hp&&(await this.setCondition(COC7.status.unconscious),hasMajorWound&&this.setCondition(COC7.status.dying))}return netDamage}get majorWound(){return this.hasConditionStatus(COC7.status.criticalWounds)}get dying(){return this.hasConditionStatus(COC7.status.dying)}get unconscious(){return this.hasConditionStatus(COC7.status.unconscious)}get dead(){return this.hasConditionStatus(COC7.status.dead)}get prone(){return this.hasConditionStatus(COC7.status.prone)}}class ActorPickerDialog extends FormApplication{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{classes:["coc7","dialog","actor-picker"],title:game.i18n.localize("CoC7.PickWhichActorTitle"),template:"systems/CoC7/templates/chat/messages/actor-picker.hbs",closeOnSubmit:!1,width:415,height:375})}activateListeners(html){super.activateListeners(html),html.on("click",".directory-item",this._onPick.bind(this)),html.find(".can-ping").hover(this._onHoverIn.bind(this),this._onHoverOut.bind(this)),html.on("click",".submit-button",this._onSubmitButton.bind(this))}_onPick(event){const li=event.currentTarget;for(const l of li.parentElement.children)l.classList.toggle("picked",l===li);this.object.selected=li.dataset.entryUuid}async _onHoverIn(event){if(event.preventDefault(),!canvas.ready)return;const li=event.currentTarget,token=(await fromUuid(li.dataset.entryUuid))?.object;token?.isVisible&&(token.controlled||(token._onHoverIn(event,{hoverOutOthers:!0}),this._highlighted=token))}_onHoverOut(event){event.preventDefault(),this._highlighted&&this._highlighted._onHoverOut(event),this._highlighted=null}async _onSubmitButton(event){this.object.resolve(await fromUuid(this.object.selected)),this.close()}static async create(){const allowedTypes=["character","npc","creature"];let found=[];if(game.user.isGM&&canvas.ready&&canvas.tokens.controlled.length>0)found=canvas.tokens.controlled.map((t=>t.document));else{canvas.ready&&(found=canvas.tokens.placeables.filter((t=>allowedTypes.includes(t.document.actor.type)&&(t.actor.ownership[game.user.id]??t.actor.ownership.default)===CONST.DOCUMENT_OWNERSHIP_LEVELS.OWNER)).map((t=>t.document)));const foundIDs=found.map((t=>t.actorId));found=found.concat(game.actors.filter((a=>allowedTypes.includes(a.type)&&!foundIDs.includes(a.id)&&(a.ownership[game.user.id]??a.ownership.default)===CONST.DOCUMENT_OWNERSHIP_LEVELS.OWNER)))}if(1===found.length)return found[0];if(found.length>1){const options=[];for(const option of found){const isTokenDocument=option instanceof TokenDocument;options.push({uuid:option.uuid,name:option.name,img:isTokenDocument?option.actor.portrait:option.portrait,canPing:isTokenDocument})}options.sort(CoC7Utilities.sortByNameKey);let selected=options[1].uuid;if(game.user.character){const defaultOption=found.find((option=>(option.actorId??option.id)===game.user.character.id));defaultOption&&(selected=defaultOption.uuid)}return new Promise((resolve=>{new ActorPickerDialog({options,selected,resolve}).render(!0)}))}return ui.notifications.warn(game.i18n.localize("CoC7.WarnNoControlledActor")),null}}class CoC7GroupMessage{static async removeRoll({messageId,msg,which}){if(void 0!==messageId&&(msg=game.messages.get(messageId)),void 0!==msg.flags?.CoC7?.["group-message"]?.rollStatuses[which]){const updates={["flags.CoC7.group-message.rollStatuses.-="+which]:null};await CoC7GroupMessage.updateTheGroupMessage({msg,updates})}}static async pushMyRoll({messageId,msg,which}){void 0!==messageId&&(msg=game.messages.get(messageId));const updates={};let gmId=!1;switch(msg.canUserModify(game.user,"update")||(gmId=CoC7Utilities.getAnIdForGm()),msg.flags.CoC7["group-message"].type){case"combined":updates["flags.CoC7.group-message.wasPushed"]=!0,CoC7GroupMessage.performCombinedRoll({msg,gmId,updates,pushing:!0});break;case"opposed":{const rolls={[which]:msg.flags.CoC7["group-message"].rollStatuses[which].roll};CoC7GroupMessage.performNormalRoll({msg,rolls,gmId,updates,pushing:!0})}}}static async spendMyLuck({messageId,msg,which,index,luckAmount}){if(void 0!==messageId&&(msg=game.messages.get(messageId)),void 0!==msg.flags?.CoC7?.["group-message"]?.rollStatuses[which].completed)switch(msg.flags.CoC7["group-message"].type){case"combined":if(!luckAmount){luckAmount=CoC7Check.fromData(msg.flags?.CoC7?.["group-message"]?.rollStatuses[which].completed).increaseSuccess[index].luckToSpend??null}if(luckAmount){const actor=await CoC7GroupMessage.getActor(msg.flags.CoC7["group-message"].actorUuid);if(!(actor instanceof TokenDocument?actor.actor:actor).spendLuck(luckAmount))return void ui.notifications.error(game.i18n.format("CoC7.ErrorNotEnoughLuck",{actor:actor.name}));const updates={};for(const which in msg.flags.CoC7["group-message"].rollStatuses){const check=CoC7Check.fromData(msg.flags.CoC7["group-message"].rollStatuses[which].completed);check.increaseLuckSpend(luckAmount),updates["flags.CoC7.group-message.rollStatuses."+which+".completed"]=check.JSONRollData}if(Object.keys(updates).length)if(msg.canUserModify(game.user,"update"))await CoC7GroupMessage.updateTheGroupMessage({msg,updates});else{const gmId=CoC7Utilities.getAnIdForGm();!1!==gmId&&game.socket.emit("system.CoC7",{listener:gmId,type:"group-message-update",messageId:msg.id,updates})}}break;case"opposed":{const check=CoC7Check.fromData(msg.flags?.CoC7?.["group-message"]?.rollStatuses[which].completed);void 0!==index?check.upgradeCheck(index,!1):void 0!==luckAmount&&check.forcePass(luckAmount,!1);const updates={["flags.CoC7.group-message.rollStatuses."+which+".completed"]:check.JSONRollData};if(Object.keys(updates).length)if(msg.canUserModify(game.user,"update"))await CoC7GroupMessage.updateTheGroupMessage({msg,updates});else{const gmId=CoC7Utilities.getAnIdForGm();!1!==gmId&&game.socket.emit("system.CoC7",{listener:gmId,type:"group-message-update",messageId:msg.id,updates})}}}else ui.notifications.error("CoC7.ErrorRollAlreadyCompleted",{localize:!0})}static async updateTheGroupMessage({msg,updates,rollData}={}){if(msg?.flags?.CoC7?.["group-message"]){if(void 0===rollData){rollData={};for(const which in msg?.flags?.CoC7?.["group-message"].rollStatuses){const roll=await CoC7GroupMessage.parseRolls({roll:msg?.flags?.CoC7?.["group-message"].rollStatuses[which].roll,quick:!0});rollData[which]=roll}}const options=Object.assign({rollData},foundry.utils.mergeObject(msg.flags.CoC7["group-message"],foundry.utils.expandObject(updates)?.flags?.CoC7?.["group-message"]??{},{performDeletions:!0}));for(const which in options.rollStatuses)options.rollStatuses[which].completed&&(options.rollStatuses[which].completed=CoC7Check.fromData(options.rollStatuses[which].completed));options.allRollsCompleted=!0;for(const which in options.rollStatuses)void 0===options.rollStatuses[which].completed&&(options.allRollsCompleted=!1);switch(updates["flags.CoC7.group-message.allRollsCompleted"]=options.allRollsCompleted,options.type){case"combined":if(options.isSuccess=!1,options.isFailure=!1,options.allRollsCompleted){let successes=0,failures=0;for(const which in options.rollStatuses)options.rollStatuses[which].completed.isSuccess?successes++:options.rollStatuses[which].completed.isFailure&&failures++;successes>0&&("any"===options.combined||0===failures&&"all"===options.combined)?options.isSuccess=!0:options.isFailure=!0}updates["flags.CoC7.group-message.isSuccess"]=options.isSuccess,updates["flags.CoC7.group-message.isFailure"]=options.isFailure;break;case"opposed":if(options.allRollsCompleted){if(options.isTie=!1,options.isCombat){options.rollOrder=Array.from(new Int8Array(options.rollOrder.map((v=>parseInt(v.substr(1),10)))).sort()).map((v=>"r"+v));const successLevels={};options.defenderIsDodging=!1;for(const which in options.rollStatuses)options.rollStatuses[which].completed.passed&&(successLevels[options.rollStatuses[which].completed.successLevel]=parseInt(successLevels[options.rollStatuses[which].completed.successLevel]??0,10)+1),options.rollStatuses[which].isDodging&&!options.rollStatuses[which].isAttacker&&(options.defenderIsDodging=!0);updates["flags.CoC7.group-message.defenderIsDodging"]=options.defenderIsDodging,!1===options.advantageAttacker&&!1===options.advantageDefender&&(options.defenderIsDodging?(options.advantageDefender=!0,updates["flags.CoC7.group-message.advantageDefender"]=options.advantageDefender):(options.advantageAttacker=!0,updates["flags.CoC7.group-message.advantageAttacker"]=options.advantageAttacker));const best=Math.max(...Object.keys(successLevels));if(options.needsTieBreaker=!1,options.resultText=game.i18n.localize("CoC7.NoWinner"),best>0)for(const which in options.rollStatuses){let rollIsWinner=!1,rollIsTie=!1;options.rollStatuses[which].completed.successLevel===best&&1===successLevels[best]?rollIsWinner=!0:options.rollStatuses[which].completed.successLevel===best&&(options.advantageAttacker&&options.rollStatuses[which].isAttacker||options.advantageDefender&&!options.rollStatuses[which].isAttacker?rollIsWinner=!0:(rollIsTie=!0,options.needsTieBreaker=!0,options.isTie=!0)),options.rollStatuses[which].isWinner=rollIsWinner,options.rollStatuses[which].isTie=rollIsTie,updates["flags.CoC7.group-message.rollStatuses."+which+".isWinner"]=rollIsWinner,updates["flags.CoC7.group-message.rollStatuses."+which+".isTie"]=rollIsTie,rollIsWinner&&!rollIsTie&&(options.rollStatuses[which].isAttacker?options.rollStatuses[which].isManeuver?options.resultText=game.i18n.format("CoC7.ManeuverSuccess",{name:rollData[which].actor.name}):options.resultText=game.i18n.format("CoC7.AttackSuccess",{name:rollData[which].actor.name}):options.rollStatuses[which].isManeuver?options.rollStatuses[which].isDodging?options.resultText=game.i18n.format("CoC7.DodgeSuccess",{name:rollData[which].actor.name}):options.resultText=game.i18n.format("CoC7.ManeuverSuccess",{name:rollData[which].actor.name}):options.resultText=game.i18n.format("CoC7.AttackSuccess",{name:rollData[which].actor.name}))}updates["flags.CoC7.group-message.needsTieBreaker"]=options.needsTieBreaker}else{const opposedRollTieBreaker=game.settings.get("CoC7","opposedRollTieBreaker");options.rollOrder.sort(((a,b)=>{if(options.rollStatuses[a].completed.successLevel>options.rollStatuses[b].completed.successLevel)return-1;if(options.rollStatuses[a].completed.successLevel<options.rollStatuses[b].completed.successLevel)return 1;if(opposedRollTieBreaker){if(options.rollStatuses[a].completed.modifiedResult>options.rollStatuses[b].completed.modifiedResult)return-1;if(options.rollStatuses[a].completed.modifiedResult<options.rollStatuses[b].completed.modifiedResult)return 1}else{if(options.rollStatuses[a].completed.rawValue>options.rollStatuses[b].completed.rawValue)return-1;if(options.rollStatuses[a].completed.rawValue<options.rollStatuses[b].completed.rawValue)return 1}return 0}));const offsetMax=options.rollOrder.length;let offset=0;const a=options.rollStatuses[options.rollOrder[0]];if(a.failed)offset=-1;else for(;offset<offsetMax;offset++){const b=options.rollStatuses[options.rollOrder[offset]];if(a.completed.successLevel!==b.completed.successLevel||(opposedRollTieBreaker?a.completed.modifiedResult!==b.completed.modifiedResult:a.completed.rawValue!==b.completed.rawValue)){offset--;break}}options.isTie=offset>0;for(let i=0;i<offsetMax;i++){let isWinner=!1,isTie=!1;i<=offset&&(isWinner=!0,isTie=options.isTie);const which=options.rollOrder[i];options.rollStatuses[which].isWinner=isWinner,options.rollStatuses[which].isTie=isTie,updates["flags.CoC7.group-message.rollStatuses."+which+".isWinner"]=isWinner,updates["flags.CoC7.group-message.rollStatuses."+which+".isTie"]=isTie}options.needsTieBreaker=!1,updates["flags.CoC7.group-message.needsTieBreaker"]=!1}updates["flags.CoC7.group-message.isTie"]=options.isTie}}const html=await renderTemplate(CoC7GroupMessage.getTemplatePath(msg.flags.CoC7["group-message"].type),options);updates.content=html,await msg.update(updates)}}static async updateTheMessage({messageId,updates}){const msg=game.messages.get(messageId);msg?.flags?.CoC7?.["group-message"]&&await CoC7GroupMessage.updateTheGroupMessage({msg,updates})}static async getCheck({msg,theRoll}){const checkData={difficulty:theRoll.difficulty,diceModifier:theRoll.bonus,actorKey:theRoll.actor.actorKey??theRoll.actor.actor.actorKey,denyPush:!1,combat:msg.flags?.CoC7?.["group-message"].isCombat??!1};switch(theRoll.type){case"characteristic":checkData.characteristic=theRoll.key,checkData.denyPush=msg.flags?.CoC7?.["group-message"].denyPush??!1;break;case"attribute":checkData.attribute=theRoll.key,checkData.denyPush=msg.flags?.CoC7?.["group-message"].denyPush??!1;break;case"skill":checkData.skill=theRoll.skill,checkData.denyPush=(msg.flags?.CoC7?.["group-message"].denyPush??!1)||!theRoll.pushable;break;case"item":checkData.item=theRoll.item,checkData.denyPush=(msg.flags?.CoC7?.["group-message"].denyPush??!1)||!theRoll.pushable}return CoC7Check.create(checkData)}static async performRoll({msg,which,roll,pushing}={}){const theRoll=await CoC7GroupMessage.parseRolls({roll,quick:!1});if(!theRoll)return{};const check=await CoC7GroupMessage.getCheck({msg,theRoll});pushing&&(check.pushing=pushing),await check._perform({forceDSN:!0});const updates={};return updates["flags.CoC7.group-message.rollStatuses."+which+".completed"]=check.JSONRollData,updates}static async performCombinedRoll({messageId,msg,gmId,updates,pushing=!1}){void 0!==messageId&&(msg=game.messages.get(messageId));const rollData={};for(const which in msg?.flags?.CoC7?.["group-message"].rollStatuses){const roll=await CoC7GroupMessage.parseRolls({roll:msg?.flags?.CoC7?.["group-message"].rollStatuses[which].roll,quick:!1});roll&&(rollData[which]=roll)}const pool={};for(const which in rollData)pool[parseInt(rollData[which].bonus??0,10)]=!1;const roll=await CoC7Dice.combinedRoll({pool});let first=!0;for(const which in rollData){const bonus=parseInt(rollData[which].bonus??0,10),check=await CoC7GroupMessage.getCheck({msg,theRoll:rollData[which]});pushing&&(check.pushing=pushing),await check._perform({roll:roll[bonus],silent:!1===first||void 0,forceDSN:first}),updates["flags.CoC7.group-message.rollStatuses."+which+".completed"]=check.JSONRollData,first=!1}if(msg.canUserModify(game.user,"update"))await CoC7GroupMessage.updateTheGroupMessage({msg,updates});else{const gmId=CoC7Utilities.getAnIdForGm();!1!==gmId&&game.socket.emit("system.CoC7",{listener:gmId,type:"group-message-update",messageId:msg.id,updates})}}static async performNormalRoll({messageId,msg,rolls,gmId,updates,pushing=!1}){void 0!==messageId&&(msg=game.messages.get(messageId));for(const which in rolls)void 0===msg.flags?.CoC7?.["group-message"]?.rollStatuses[which].completed||pushing?Object.assign(updates,await CoC7GroupMessage.performRoll({msg,which,roll:rolls[which],pushing})):ui.notifications.error("CoC7.ErrorRollAlreadyCompleted",{localize:!0});msg.canUserModify(game.user,"update")?await CoC7GroupMessage.updateTheGroupMessage({msg,updates}):!1!==gmId&&game.socket.emit("system.CoC7",{listener:gmId,type:"group-message-update",messageId:msg.id,updates})}static async performMyRolls({messageId,msg,rolls}){void 0!==messageId&&(msg=game.messages.get(messageId));const updates={};for(const which in rolls)await CoC7GroupMessage.nameRoll({which,roll:rolls[which],updates});const gmId=!msg.canUserModify(game.user,"update")&&CoC7Utilities.getAnIdForGm();switch(Object.keys(updates).length>0&&(msg.canUserModify(game.user,"update")?await CoC7GroupMessage.updateTheGroupMessage({msg,updates}):!1!==gmId&&(game.socket.emit("system.CoC7",{listener:gmId,type:"group-message-update",messageId:msg.id,updates}),await new Promise((resolve=>setTimeout(resolve,200))))),msg.flags.CoC7["group-message"].type){case"combined":CoC7GroupMessage.performCombinedRoll({msg,gmId,updates});break;case"opposed":CoC7GroupMessage.performNormalRoll({msg,rolls,gmId,updates})}}static async nameRoll({which,roll,updates}){const parsed=await CoC7GroupMessage.parseRolls({roll,quick:!1});parsed&&(updates["flags.CoC7.group-message.rollStatuses."+which+".shortName"]=parsed.shortName,updates["flags.CoC7.group-message.rollStatuses."+which+".fullName"]=parsed.fullName,updates["flags.CoC7.group-message.rollStatuses."+which+".tags"]=parsed.tags??[],updates["flags.CoC7.group-message.rollStatuses."+which+".percent"]=parsed.percent??1,updates["flags.CoC7.group-message.rollStatuses."+which+".isManeuver"]=parsed.isManeuver??!1,updates["flags.CoC7.group-message.rollStatuses."+which+".isDodging"]=parsed.isDodge??!1,updates["flags.CoC7.group-message.rollStatuses."+which+".isWeapon"]=parsed.isDodge??!1)}static async newGroupMessage({rollData,options}){if(void 0===rollData){rollData={};for(const which in options.rollStatuses){const roll=await CoC7GroupMessage.parseRolls({roll:options.rollStatuses[which].roll,quick:!0});rollData[which]=roll}}const rollsByUser={},rollRequiresName={};for(const which in rollData){let asUserId="";switch(rollData[which].autoRoll.length){case 1:if(rollData[which].autoRoll[0]!==game.user.id){asUserId=rollData[which].autoRoll[0];break}case 0:asUserId=game.user.id;break;default:options.rollStatuses[which].rolling=!1,"-"===rollData[which].shortName&&(rollRequiresName[which]=rollData[which].roll)}""!==asUserId&&(Object.prototype.hasOwnProperty.call(rollsByUser,asUserId)||(rollsByUser[asUserId]={}),rollsByUser[asUserId][which]=options.rollStatuses[which].roll,options.rollStatuses[which].rolling=asUserId)}const templateData=Object.assign({rollData},options),chatData={flags:{CoC7:{"group-message":options}},content:await renderTemplate(CoC7GroupMessage.getTemplatePath(options.type),templateData)};switch(chatData.flags?.CoC7?.["group-message"]?.type){case"opposed":chatData.speaker=Object.assign(chatData.speaker??{},{alias:game.i18n.localize("CoC7.OpposedRollCard")});break;case"combined":chatData.speaker=Object.assign(chatData.speaker??{},{alias:Object.values(rollData)[0].actor.name})}const msg=await ChatMessage.create(chatData),updates={};for(const which in rollRequiresName)await CoC7GroupMessage.nameRoll({which,roll:rollRequiresName[which],updates});Object.keys(updates).length>0&&await CoC7GroupMessage.updateTheGroupMessage({msg,updates,rollData});for(const userId in rollsByUser)userId!==game.user.id&&game.socket.emit("system.CoC7",{type:"group-message-roll",listener:userId,messageId:msg.id,rolls:rollsByUser[userId]});return Object.prototype.hasOwnProperty.call(rollsByUser,game.user.id)&&await CoC7GroupMessage.performMyRolls({msg,rolls:rollsByUser[game.user.id]}),msg}static async isUserActive({which,msg}){if(msg.flags?.CoC7?.["group-message"]?.rollStatuses[which].rolling){const user=game.users.get(msg.flags.CoC7["group-message"].rollStatuses[which].rolling);if(game.user.isGM||!user||!user.active){const updates={["flags.CoC7.group-message.rollStatuses."+which+".rolling"]:!1};if(msg.canUserModify(game.user,"update"))await CoC7GroupMessage.updateTheGroupMessage({msg,updates});else{const gmId=CoC7Utilities.getAnIdForGm();!1!==gmId&&game.socket.emit("system.CoC7",{listener:gmId,type:"group-message-update",messageId:msg.id,updates})}}}}static async _onToggle(event){event.preventDefault();const button=event.currentTarget,messageId=button.closest("li.chat-message")?.dataset.messageId,key=button.dataset.key;let value=button.dataset.value;if(messageId&&key){if(button.classList.contains("select-only-gm")&&!game.user.isGM)return;const msg=game.messages.get(messageId);if(void 0!==msg.flags?.CoC7?.["group-message"]?.[key]&&msg.canUserModify(game.user,"update")){void 0===value&&(value=!msg.flags.CoC7["group-message"][key]);const updates={["flags.CoC7.group-message."+key]:value};switch(key){case"advantageDefender":updates["flags.CoC7.group-message.advantageAttacker"]=!value;break;case"advantageAttacker":updates["flags.CoC7.group-message.advantageDefender"]=!value}await CoC7GroupMessage.updateTheGroupMessage({msg,updates})}}}static async _onClick(event){event.preventDefault();const button=event.currentTarget,action=button.dataset.action,messageId=button.closest("li.chat-message")?.dataset.messageId,which=button.dataset.which;if(messageId){const msg=game.messages.get(messageId);if(void 0!==msg)if(void 0!==which&&void 0!==msg.flags?.CoC7?.["group-message"]?.rollStatuses[which]){const actor=await fromUuid(msg.flags.CoC7["group-message"].rollStatuses[which].roll.split("#")[0]);if(!actor||!actor.canUserModify(game.user,"update"))return void ui.notifications.error("CoC7.ErrorNoActorPermission",{localize:!0});switch(action){case"impatient-roll":CoC7GroupMessage.isUserActive({which,msg});break;case"normal-roll":CoC7GroupMessage.performMyRolls({msg,rolls:{[which]:msg.flags.CoC7?.["group-message"].rollStatuses[which].roll}});break;case"use-luck":CoC7GroupMessage.spendMyLuck({which,index:button.dataset.index,luckAmount:button.dataset.luckAmount,msg});break;case"remove-roll":CoC7GroupMessage.removeRoll({which,msg});break;case"push":CoC7GroupMessage.pushMyRoll({which,msg})}}else if(void 0!==msg.flags?.CoC7?.["group-message"]?.rollStatuses){let okay=!1;for(const which in msg.flags.CoC7["group-message"].rollStatuses){if((await fromUuid(msg.flags.CoC7["group-message"].rollStatuses[which].roll.split("#")[0])).canUserModify(game.user,"update")){okay=!0;break}}if(!okay)return void ui.notifications.error("CoC7.ErrorNoActorPermission",{localize:!0});switch(action){case"roll-once":if("combined"===msg.flags.CoC7["group-message"].type){const updates={};CoC7GroupMessage.performCombinedRoll({msg,updates})}break;case"toggle":CoC7GroupMessage._onToggle(event)}}}}static async renderChatMessage(app,html,data){const canModify={gm:game.user.isGM};for(const which in app.flags?.CoC7?.["group-message"]?.rollStatuses){const actor=await fromUuid(app.flags.CoC7["group-message"].rollStatuses[which].roll.split("#")[0]);canModify[which]=actor?.canUserModify(game.user,"update")??!1}canModify.any=Object.values(canModify).filter((b=>b)).length>0;for(const key in canModify)canModify[key]?html.find(".hidden-only-"+key).remove():html.find(".visible-only-"+key).remove();html.on("click",".roll-card-v2 button:not(.toggle-switch)",CoC7GroupMessage._onClick.bind(this)),html.on("click",".roll-card-v2 a:not(.toggle-link)",CoC7GroupMessage._onClick.bind(this)),html.on("click",".roll-card-v2 button.toggle-switch",CoC7GroupMessage._onToggle.bind(this)),html.on("click",".roll-card-v2 a.toggle-link",CoC7GroupMessage._onToggle.bind(this))}static async getActor(identifier){return identifier.match(/^a\./)?(await game.system.api.cocid.fromCoCID(identifier))?.[0]??null:identifier.indexOf(".")>-1?await fromUuid(identifier):game.actors.get(identifier)??null}static async parseRolls({roll,quick=!0,defaultUuid=""}){const match=roll.match(/^(?<a>[^#]+#)?(?<t>attribute|characteristic|item|skill)#(?<k>[^#]+)(#(?<m>.*))?$/);if(match){const modifiers=(match.groups.m??"").toLowerCase().split("#"),bonus=parseInt(modifiers.find((m=>m.match(/^[+-]\d+$/)))??0,10),difficulty=modifiers.find((m=>m.match(/^\d+$/))),pushing=modifiers.filter((m=>"p"===m)).length>0,rollData={type:match.groups.t,key:match.groups.k,bonus,difficulty:"0"===(difficulty??"").toString()?CoC7Check.difficultyLevel.unknown:difficulty?parseInt(difficulty,10):"unknown"===game.settings.get("CoC7","defaultCheckDifficulty")?CoC7Check.difficultyLevel.unknown:CoC7Check.difficultyLevel.regular,pushing};if(!match.groups.a&&defaultUuid&&""!==defaultUuid&&(match.groups.a=defaultUuid+"#"),match.groups.a){const actor=await CoC7GroupMessage.getActor(match.groups.a.substr(0,match.groups.a.length-1));if(!actor)return null;rollData.actor=actor,rollData.autoRoll=game.users.filter((u=>!u.isGM&&rollData.actor.canUserModify(u,"update"))).map((u=>({id:u.id,active:u.active}))),rollData.autoRoll.length>0&&(rollData.autoRoll=rollData.autoRoll.filter((d=>d.active)).map((d=>d.id)),0===rollData.autoRoll.length&&(rollData.autoRoll=["prevent","roll"]))}else{const actor=await ActorPickerDialog.create();if(!actor)return ui.notifications.warn("CoC7.WarnNoControlledActor",{localize:!0}),null;rollData.actor=actor,game.user.isGM?(rollData.autoRoll=game.users.filter((u=>!u.isGM&&rollData.actor.canUserModify(u,"update"))).map((u=>({id:u.id,active:u.active}))),rollData.autoRoll.length>0&&(rollData.autoRoll=rollData.autoRoll.filter((d=>d.active)).map((d=>d.id)),0===rollData.autoRoll.length&&(rollData.autoRoll=["prevent","roll"]))):rollData.autoRoll=[game.user.id]}switch(rollData.roll=rollData.actor.uuid+"#"+rollData.type+"#"+rollData.key+(rollData.bonus<0?"#"+rollData.bonus:rollData.bonus>0?"#+"+rollData.bonus:"")+(0===difficulty?"#0":difficulty?"#"+parseInt(difficulty,10):""),rollData.portrait=rollData.actor instanceof TokenDocument?rollData.actor.texture.src:rollData.actor.portrait,rollData.shortName="-",rollData.fullName="-",rollData.type){case"characteristic":if(rollData.shortName=CoC7Utilities.getCharacteristicNames(rollData.key)?.short??"-",rollData.fullName=CoC7Utilities.getCharacteristicNames(rollData.key)?.label??"-",rollData.percent=(rollData.actor instanceof TokenDocument?rollData.actor.actor:rollData.actor).system?.characteristics[rollData.key]?.value??1,"-"===rollData.shortName)return null;break;case"attribute":switch(rollData.key){case"lck":rollData.shortName=game.i18n.localize("CoC7.Luck"),rollData.fullName=game.i18n.localize("CoC7.Luck");break;case"san":rollData.shortName=game.i18n.localize("CoC7.SAN"),rollData.fullName=game.i18n.localize("CoC7.Sanity");break;default:return null}rollData.percent=(rollData.actor instanceof TokenDocument?rollData.actor.actor:rollData.actor).system?.attribs[rollData.key]?.value??1;break;case"skill":if(!quick){const skills=await(rollData.actor instanceof TokenDocument?rollData.actor.actor:rollData.actor).getItemOrAdd(rollData.key,"skill");skills.length&&(rollData.skill=skills[0],rollData.shortName=skills[0].shortName,rollData.fullName=skills[0].shortName,rollData.pushable=skills[0].system.properties?.push??!1,rollData.percent=skills[0].value,rollData.isManeuver=skills[0].isDodge,rollData.isDodge=skills[0].isDodge)}break;case"item":if(!quick){const items=await(rollData.actor instanceof TokenDocument?rollData.actor.actor:rollData.actor).getItemOrAdd(rollData.key,"weapon");if(items.length){rollData.item=items[0],rollData.shortName=items[0].shortName,rollData.fullName=items[0].shortName,rollData.isManeuver=items[0].system.properties?.mnvr??!1,rollData.isWeapon=!0;const skillId=items[0].system.skill[items[0].usesAlternativeSkill?"alternativ":"main"].id;if(skillId){const skill=(rollData.actor instanceof TokenDocument?rollData.actor.actor:rollData.actor).items.find((d=>d.id===skillId));rollData.tags=[skill.name],rollData.percent=skill.value,rollData.pushable=skill.system.properties?.push??!1}}}}return rollData}return null}static getTemplatePath(type){switch(type){case"opposed":return"systems/CoC7/templates/chat/messages/opposed.hbs";case"combinedall":case"combinedany":case"combined":return"systems/CoC7/templates/chat/messages/combined.hbs"}return null}static async createGroupMessage(options){if(!CoC7GroupMessage.getTemplatePath(options.type))return null;let config=Object.assign({type:"",denyPush:!1,showCompletedRolls:!0,allRollsCompleted:!1,isCombat:!1,isEditable:!0,rollStatuses:{},rollOrder:[]},options);switch(config.type){case"opposed":config=Object.assign({denyPush:!0,isTie:!1,needsTieBreaker:!1,advantageAttacker:!1,advantageDefender:!1,defenderIsDodging:!1,winnerRollsDamage:!1},config);break;case"combinedall":case"combinedany":case"combined":config=Object.assign({combined:"combinedall"===config.type?"all":"combinedany"===config.type?"any":"",actorUuid:"",isSuccess:!1,isFailure:!1,wasPushed:!1},config),config.type="combined"}const rollData={};let count=0;for(const offset in options.rollRequisites){const which="r"+offset,roll=await CoC7GroupMessage.parseRolls({roll:options.rollRequisites[offset],quick:!0,defaultUuid:config.actorUuid??""});if(!roll)return null;if("combined"===config.type){if(""!==config.actorUuid&&config.actorUuid!==roll.actor.uuid)return ui.notifications.error("CoC7.ErrorCombinedRollsRequireSingleActor",{localize:!0}),null;config.actorUuid=roll.actor.uuid}if(rollData[which]=roll,config.rollStatuses[which]={roll:roll.roll,rollable:"combined"!==config.type,rolling:!1,shortName:roll.shortName,fullName:roll.fullName,percent:roll.percent,tags:[],isManeuver:!1,isDodging:!1,isWeapon:!1},"opposed"===config.type)config.rollStatuses[which]=Object.assign({isAttacker:0===count,isWinner:!1,isTie:!1},config.rollStatuses[which]);config.rollOrder.push(which),count++}if("opposed"===config.type&&2!==Object.keys(rollData).length)return ui.notifications.error("CoC7.ErrorOpposedRollsLimitedToTwoActors",{localize:!0}),null;if(delete config.rollRequisites,game.user.isGM)return CoC7GroupMessage.newGroupMessage({rollData,options:config});{const gmId=CoC7Utilities.getAnIdForGm();return!1===gmId?null:(game.socket.emit("system.CoC7",{type:"group-message-new",listener:gmId,options:config}),!0)}}}class CoC7Link{static get CHECK_TYPE(){return{CHECK:"check",SANLOSS:"sanloss",ITEM:"item",EFFECT:"effect"}}static get LINK_TYPE(){return{CHARACTERISTIC:"characteristic",ATTRIBUTE:"attribute",SKILL:"skill"}}static init(){CONFIG.CoC7Link={documentClass:CoC7Link};const body=$("body");body.on("click","a.coc7-link",CoC7Link._onLinkClick),body.on("dragstart","a.coc7-link",(event=>CoC7Link._onDragCoC7Link(event))),CONFIG.TextEditor.enrichers.push({pattern:new RegExp("@(coc7)\\.(check|effect|item|sanloss)\\[([^\\[\\]]*(?:\\[[^\\[\\]]*(?:\\[[^\\[\\]]*\\])*[^\\[\\]]*\\])*[^\\[\\]]*)\\](?:{([^}]+)})?","gi"),enricher:CoC7Link._createLink})}static _linkFromEvent(event){const a=event.currentTarget,i=a.querySelector("[data-link-icon]"),data=foundry.utils.duplicate(a.dataset),oldType=data.type;return data.type="CoC7Link",data.icon=null,oldType&&(data.linkType=oldType),data.object&&("string"==typeof data.object||data.object instanceof String)&&(data.object=JSON.parse(data.object)),i.dataset&&i.dataset.linkIcon&&"fas fa-dice"!==i.dataset.linkIcon&&(data.icon=i.dataset.linkIcon),data.displayName=a.dataset.displayName?a.innerText:null,data.difficulty&&(data.difficulty=CoC7Utilities.convertDifficulty(data.difficulty)),data}static _onDragCoC7Link(event){const data=CoC7Link._linkFromEvent(event);event.originalEvent.dataTransfer.setData("text/plain",JSON.stringify(data))}static async fromDropData(data,options={}){const cls=new CoC7Link;cls.object=foundry.utils.mergeObject({type:"CoC7Link",check:CoC7Link.CHECK_TYPE.CHECK,linkType:CoC7Link.LINK_TYPE.SKILL,difficulty:CoC7Check.difficultyLevel.regular,modifier:0,object:{label:game.i18n.localize("CoC7.EffectNew"),icon:"icons/svg/aura.svg",changes:[]}},data);for(const key of["name","displayName","icon","id","pack","sanMin","sanMax","sanReason"])cls.object[key]=cls.object[key]??"";return void 0!==cls.object.object.icon&&void 0!==cls.object.object.external&&["http","https"].includes(cls.object.object.external)&&(cls.object.object.icon=cls.object.object.external+"://"+cls.object.object.icon),cls.options=options,cls}static async _createLink(match){const name=match[4]??void 0,options=match[3]??void 0,type=match[2]??void 0,data={cls:["coc7-link"],dataset:{check:type},icon:null,blind:!1,name};if(type===CoC7Link.CHECK_TYPE.EFFECT)data.effect=JSON.parse(options),data.dataset.object=options,void 0!==data.effect.icon&&void 0!==data.effect.external&&["http","https"].includes(data.effect.external)&&(data.effect.icon=data.effect.external+"://"+data.effect.icon);else{const matches=options.matchAll(/[^,]+/gi);for(const match of Array.from(matches)){let[key,value]=match[0].split(":");"icon"===key&&(data.icon=value),void 0===value&&("blind"===key?(value=!0,data.blind=[CoC7Link.CHECK_TYPE.CHECK].includes(type.toLowerCase())):"pushing"===key?(value=!0,data.pushing=[CoC7Link.CHECK_TYPE.CHECK].includes(type.toLowerCase())):"combat"===key&&(value=!0,data.combat=[CoC7Link.CHECK_TYPE.CHECK].includes(type.toLowerCase()))),data.dataset[key]=value}void 0!==data.dataset.icon&&void 0!==data.dataset.external&&["http","https"].includes(data.dataset.external)&&(data.dataset.icon=data.dataset.external+"://"+data.dataset.icon,data.icon=data.dataset.icon)}let title;const difficulty=CoC7Check.difficultyString(data.dataset.difficulty);switch(type.toLowerCase()){case CoC7Link.CHECK_TYPE.CHECK:{let humanName=data.dataset.name;if(["attributes","attribute","attrib","attribs"].includes(data.dataset.type?.toLowerCase()))"lck"===data.dataset.name&&(humanName=game.i18n.localize("CoC7.Luck")),"san"===data.dataset.name&&(humanName=game.i18n.localize("CoC7.Sanity"));else if(["charac","char","characteristic","characteristics"].includes(data.dataset.type?.toLowerCase()))humanName=CoC7Utilities.getCharacteristicNames(data.dataset.name)?.label;else if(!name&&data.dataset.name.match(/^.\.[^\\.]*\..+$/)){const cocIdName=(await game.system.api.cocid.fromCoCID(data.dataset.name))?.[0]?.name;cocIdName&&(humanName=cocIdName)}title=game.i18n.format(`CoC7.LinkCheck${data.dataset.difficulty?"Diff":""}${data.dataset.modifier?"Modif":""}${data.pushing?"Pushing":""}`,{difficulty,modifier:data.dataset.modifier,name:humanName});break}case CoC7Link.CHECK_TYPE.SANLOSS:title=game.i18n.format(`CoC7.LinkSanLoss${data.dataset.difficulty?"Diff":""}${data.dataset.modifier?"Modif":""}`,{difficulty,modifier:data.dataset.modifier,sanMin:data.dataset.sanMin,sanMax:data.dataset.sanMax});break;case CoC7Link.CHECK_TYPE.ITEM:title=game.i18n.format(`CoC7.LinkItem${data.dataset.difficulty?"Diff":""}${data.dataset.modifier?"Modif":""}`,{difficulty,modifier:data.dataset.modifier,name:data.dataset.name});break;case CoC7Link.CHECK_TYPE.EFFECT:title=data.effect.label}name?data.dataset.displayName=!0:data.name=title;const a=document.createElement("a");a.title=game.user.isGM?data.name:title,a.classList.add(...data.cls);for(const[k,v]of Object.entries(data.dataset))a.dataset[k]=v;return a.draggable=!0,data.icon=data.icon??data.effect?.icon??"fas fa-dice",(data.icon.includes("\\")||data.icon.includes("."))&&(data.img=data.icon),data.blind&&(a.innerHTML+='<i class="fas fa-eye-slash"></i>'),data.img?a.innerHTML+=`<img data-link-icon="${data.icon}" src="${data.img}">`:a.innerHTML+=`<i data-link-icon="${data.icon}" class="link-icon ${data.icon}"></i>`,a.innerHTML+=`<span>${data.name}</span>`,a}_createDocumentLink(eventData,{relativeTo,label}={}){if(!eventData.check)return"";switch(eventData.check.toLowerCase()){case CoC7Link.CHECK_TYPE.CHECK:{if(!eventData.linkType||!eventData.name&&!eventData.rolls)return"";let options=`${eventData.blind?"blind,":""}${eventData.pushing?"pushing,":""}type:${eventData.linkType}`;if(eventData.name?options+=`,name:${eventData.name}`:eventData.rolls&&(options+=`,rolls:${eventData.rolls}`,eventData.combat&&(options+=",combat")),void 0!==eventData.difficulty&&eventData.difficulty!==CoC7Check.difficultyLevel.regular&&(options+=`,difficulty:${eventData.difficulty}`),void 0!==eventData.modifier&&0!==eventData.modifier&&(options+=`,modifier:${eventData.modifier}`),eventData.icon){const parts=eventData.icon.match(/^(https?):\/\/(.+)$/);options+=parts?`,external:${parts[1]},icon:${parts[2]}`:`,icon:${eventData.icon}`}eventData.pack&&(options+=`,pack:${eventData.pack}`),eventData.id&&(options+=`,id:${eventData.id}`);let link=`@coc7.check[${options}]`;const displayName=eventData.displayName??label??"";return displayName&&(link+=`{${displayName}}`),link}case CoC7Link.CHECK_TYPE.SANLOSS:{if(!eventData.sanMax||!eventData.sanMin)return"";let options=`${eventData.blind?"blind,":""}sanMax:${eventData.sanMax},sanMin:${eventData.sanMin}`;if(eventData.sanReason&&(options+=`,sanReason:${eventData.sanReason}`),eventData.difficulty&&eventData.difficulty!==CoC7Check.difficultyLevel.regular&&(options+=`,difficulty:${eventData.difficulty}`),eventData.modifier&&0!==eventData.modifier&&(options+=`,modifier:${eventData.modifier}`),eventData.icon){const parts=eventData.icon.match(/^(https?):\/\/(.+)$/);options+=parts?`,external:${parts[1]},icon:${parts[2]}`:`,icon:${eventData.icon}`}let link=`@coc7.sanloss[${options}]`;const displayName=eventData.displayName??label??"";return displayName&&(link+=`{${displayName}}`),link}case CoC7Link.CHECK_TYPE.ITEM:{if(!eventData.name)return"";let options=`${eventData.blind?"blind,":""}name:${eventData.name}`;if(eventData.icon){const parts=eventData.icon.match(/^(https?):\/\/(.+)$/);options+=parts?`,external:${parts[1]},icon:${parts[2]}`:`,icon:${eventData.icon}`}eventData.pack&&(options+=`,pack:${eventData.pack}`),eventData.id&&(options+=`,id:${eventData.id}`);let link=`@coc7.item[${options}]`;const displayName=eventData.displayName??label??"";return displayName&&(link+=`{${displayName}}`),link}case CoC7Link.CHECK_TYPE.EFFECT:{const parts=eventData.object.icon.match(/^(https?):\/\/(.+)$/);parts&&(eventData.object.external=parts[1],eventData.object.icon=parts[2]);let link=`@coc7.effect[${JSON.stringify(eventData.object)}]`;const displayName=eventData.displayName??label??"";return displayName&&(link+=`{${displayName}}`),link}}return"?"}static async _onLinkActorClick(actor,options,{shiftKey=!1}={}){switch(options.check){case CoC7Link.CHECK_TYPE.CHECK:if(["charac","char","characteristic","characteristics"].includes(options.linkType.toLowerCase()))return actor.characteristicCheck(options.name,shiftKey,options);if(["skill"].includes(options.linkType.toLowerCase()))return actor.skillCheck(options,shiftKey,options);if(["attributes","attribute","attrib","attribs"].includes(options.linkType.toLowerCase()))return actor.attributeCheck(options.name,shiftKey,options);if(["combinedall","combinedany","opposed"].includes(options.linkType.toLowerCase()))return CoC7GroupMessage.createGroupMessage({type:options.linkType.toLowerCase(),rollRequisites:options.rolls.split("&&"),isCombat:Boolean(options.combat??!1)});break;case CoC7Link.CHECK_TYPE.SANLOSS:return void SanCheckCard.create(actor.actorKey,options,{fastForward:shiftKey});case CoC7Link.CHECK_TYPE.ITEM:return actor.weaponCheck(options,shiftKey);case CoC7Link.CHECK_TYPE.EFFECT:await actor.createEmbeddedDocuments("ActiveEffect",[{label:options.object.label,icon:options.object.icon,changes:options.object.changes}])}}static toChatMessage(options){const option={speaker:{alias:game.user.name}};let message;const link=(new CoC7Link)._createDocumentLink(options);message=options.check===CoC7Link.CHECK_TYPE.EFFECT?`<div class="effect-message">${link}</div>`:game.i18n.format("CoC7.MessageCheckRequestedWait",{check:link}),chatHelper.createMessage(null,message,option)}static toWhisperMessage(options,actors){for(const actor of actors){const option={speaker:{alias:game.user.name},whisper:actor.owners.map((a=>a.id))};let message;const link=(new CoC7Link)._createDocumentLink(options);message=options.check===CoC7Link.CHECK_TYPE.EFFECT?`<div class="effect-message">${link}</div>`:game.i18n.format("CoC7.MessageTargetCheckRequested",{name:actor.name,check:link}),chatHelper.createMessage(null,message,option)}}static async makeMacroData(data){const linkObj=await CoC7Link.fromDropData(data),match=new RegExp("@(coc7)\\.(check|effect|item|sanloss)\\[([^\\[\\]]*(?:\\[[^\\[\\]]*(?:\\[[^\\[\\]]*\\])*[^\\[\\]]*\\])*[^\\[\\]]*)\\](?:{([^}]+)})?","gi").exec(linkObj.link);if(match){return{name:(await CoC7Link._createLink(match)).querySelector("span").innerHTML.trim(),type:"script",command:"game.CoC7.macros.linkMacro("+JSON.stringify(data)+")"}}return!1}static async linkMacro(data){const linkObj=await CoC7Link.fromDropData(data),match=new RegExp("@(coc7)\\.(check|effect|item|sanloss)\\[([^\\[\\]]*(?:\\[[^\\[\\]]*(?:\\[[^\\[\\]]*\\])*[^\\[\\]]*\\])*[^\\[\\]]*)\\](?:{([^}]+)})?","gi").exec(linkObj.link);return match&&CoC7Link._createLink(match).then((element=>{CoC7Link._onLinkClick({currentTarget:element})})),!1}static async _onLinkClick(event){const options=CoC7Link._linkFromEvent(event);if(game.user.isGM){if(isCtrlKey(event))return void CoC7ContentLinkDialog.create(options);if(canvas.tokens.controlled.length){for(const token of canvas.tokens.controlled)CoC7Link._onLinkActorClick(token.actor,options,{shiftKey:event.shiftKey});return}const speaker=ChatMessage.getSpeaker(),actor=ChatMessage.getSpeakerActor(speaker);return actor?void CoC7Link._onLinkActorClick(actor,options,{shiftKey:event.shiftKey}):void CoC7Link.toChatMessage(options)}{const speaker=ChatMessage.getSpeaker();let actor=ChatMessage.getSpeakerActor(speaker);if(!actor){const actors=game.actors.filter((a=>(a.ownership[game.user.id]??a.ownership.default)===CONST.DOCUMENT_OWNERSHIP_LEVELS.OWNER));if(1===actors.length)actor=actors[0];else{const actors=game.actors.filter((a=>(a.ownership[game.user.id]??a.ownership.default)===CONST.DOCUMENT_OWNERSHIP_LEVELS.OBSERVER));1===actors.length&&(actor=actors[0])}}if(actor)return void CoC7Link._onLinkActorClick(actor,options,{shiftKey:event.shiftKey})}ui.notifications.warn(game.i18n.localize("CoC7.WarnNoControlledActor"))}setValue(key,value){this.object[key]=value}get link(){return this._createDocumentLink(this.object)}get id(){return this.object.id}get pack(){return this.object.pack}get checkType(){return this.object.check}get difficulty(){return this.object.difficulty}get icon(){return this.object.icon}get displayName(){return this.object.displayName}get modifier(){return this.object.modifier}get linkType(){return this.object.linkType}get sanMin(){return this.object.sanMin}get sanMax(){return this.object.sanMax}get sanReason(){return this.object.sanReason}get effect(){return this.object.object}get checkName(){if(this.isCharacteristicCheck){const characteristics=CoCActor.getCharacteristicDefinition();return characteristics.find((c=>c.key===this.object.name||c.shortName===this.object.name||c.label===this.object.name))?.key??""}return this.object.name}get isCheck(){return this.object.check===CoC7Link.CHECK_TYPE.CHECK}get isCharacteristicCheck(){return this.isCheck&&this.object.linkType===CoC7Link.LINK_TYPE.CHARACTERISTIC}get isAttributeCheck(){return this.isCheck&&this.object.linkType===CoC7Link.LINK_TYPE.ATTRIBUTE}get isSkillCheck(){return this.isCheck&&this.object.linkType===CoC7Link.LINK_TYPE.SKILL}get isItemCheck(){return this.object.check===CoC7Link.CHECK_TYPE.ITEM}get isSanLossCheck(){return this.object.check===CoC7Link.CHECK_TYPE.SANLOSS}get isEffect(){return this.object.check===CoC7Link.CHECK_TYPE.EFFECT}get isBlind(){return this.isCheck&&this.object.blind}get isPushing(){return this.isCheck&&this.object.pushing}}class CoC7Utilities{static isFormula(x){return"string"==typeof x&&(!!isNaN(Number(x))&&Roll.validate(x))}static ParseChatEntry(html,content){const terms=content.match(/(\S+)/g);if(terms[0]?.toLowerCase().match(/^\/r(oll)?$/)&&terms[1]?.toLowerCase().startsWith("1d%"))return setTimeout((function(){CoC7Utilities._ExecCommand(content)}),200),!1}static async _ExecCommand(content){const options=content.toLowerCase().split(" ")?.join("")?.replace(/\/r(oll)?1d%/,""),check=new CoC7Check;if(options.length){let threshold,flatDiceModifier,flatThresholdModifier,escaped=options,difficulty=CoC7Check.difficultyLevel.regular,diceModifier=0,ask=!1;const thresholdStr=escaped.match(/[^(]+(?=\))/);if(thresholdStr&&thresholdStr.length){threshold=Number(thresholdStr[0]);for(const match of thresholdStr)escaped=escaped.replace(`(${match})`,"")}const difficultyStr=escaped.match(/[^[]+(?=\])/);if(difficultyStr&&difficultyStr.length){difficulty=CoC7Utilities.convertDifficulty(difficultyStr[0]);for(const match of difficultyStr)escaped=escaped.replace(`[${match}]`,"")}if(escaped.includes("?")&&(ask=!0,escaped=escaped.replace("?","")),isNaN(Number(escaped))||(diceModifier=Number(escaped)),ask){const dialogOptions={threshold,modifier:diceModifier,difficulty,askValue:!0},usage=await RollDialog.create(dialogOptions);usage&&(diceModifier=Number(usage.get("bonusDice")),difficulty=Number(usage.get("difficulty")),threshold=Number(usage.get("threshold"))||threshold,flatDiceModifier=Number(usage.get("flatDiceModifier")),flatThresholdModifier=Number(usage.get("flatThresholdModifier")))}check.diceModifier=diceModifier||0,check.difficulty=difficulty||CoC7Check.difficultyLevel.regular,check.rawValue=threshold,check.flatDiceModifier=flatDiceModifier,check.flatThresholdModifier=flatThresholdModifier,threshold&&(check.rawValue=isNaN(threshold)?void 0:threshold)}const speaker=ChatMessage.getSpeaker();if(speaker.token&&speaker.scene){const actor=chatHelper.getActorFromKey(`${speaker.scene}.${speaker.token}`);actor&&(check.actor=actor)}else if(speaker.actor){const actor=game.actors.get(speaker.actor);actor&&(check.actor=actor)}await check.roll(),check.toMessage()}static getCharacteristicNames(char){const charKey=char.toLowerCase();switch(charKey){case"str":return{short:game.i18n.localize("CHARAC.STR"),label:game.i18n.localize("CHARAC.Strength")};case"con":return{short:game.i18n.localize("CHARAC.CON"),label:game.i18n.localize("CHARAC.Constitution")};case"siz":return{short:game.i18n.localize("CHARAC.SIZ"),label:game.i18n.localize("CHARAC.Size")};case"dex":return{short:game.i18n.localize("CHARAC.DEX"),label:game.i18n.localize("CHARAC.Dexterity")};case"app":return{short:game.i18n.localize("CHARAC.APP"),label:game.i18n.localize("CHARAC.Appearance")};case"int":return{short:game.i18n.localize("CHARAC.INT"),label:game.i18n.localize("CHARAC.Intelligence")};case"pow":return{short:game.i18n.localize("CHARAC.POW"),label:game.i18n.localize("CHARAC.Power")};case"edu":return{short:game.i18n.localize("CHARAC.EDU"),label:game.i18n.localize("CHARAC.Education")};case"luck":return{short:game.i18n.localize("CoC7.Luck"),label:game.i18n.localize("CoC7.Luck")};default:{const characteristicList=foundry.utils.isNewerVersion(game.version,"12")?game.system.template.Actor.character.characteristics:game.system.template.Actor.templates.characteristics.characteristics;for(const[,value]of Object.entries(characteristicList))if(charKey===game.i18n.localize(value.short).toLowerCase())return{short:game.i18n.localize(value.short),label:game.i18n.localize(value.label)};return null}}}static convertDifficulty(difficulty){if("0"===String(difficulty))return CoC7Check.difficultyLevel.regular;if("string"!=typeof difficulty)return difficulty;if(!isNaN(Number(difficulty)))return Number(difficulty);switch(difficulty){case"?":return CoC7Check.difficultyLevel.unknown;case"+":return CoC7Check.difficultyLevel.hard;case"++":return CoC7Check.difficultyLevel.extreme;case"+++":return CoC7Check.difficultyLevel.critical;default:return CoC7Check.difficultyLevel.regular}}static async skillCheckMacro(skill,event,options={}){event.preventDefault();const speaker=ChatMessage.getSpeaker();let actor;if(speaker.token&&(actor=game.actors.tokens[speaker.token]),actor||(actor=game.actors.get(speaker.actor)),!actor)return void ui.notifications.warn(game.i18n.localize("CoC7.WarnNoActorAvailable"));const check=await actor.skillCheck(skill,event.shiftKey,options);return check?.dice?.roll?.options?.coc7Result?.successLevel}static weaponCheckMacro(weapon,event){event.preventDefault();const speaker=ChatMessage.getSpeaker();let actor;if(speaker.token&&(actor=game.actors.tokens[speaker.token]),!actor)if(speaker.scene&&speaker.token){const baseActor=game.actors.get(speaker.actor),token=game.scenes.get(speaker.scene).tokens.get(speaker.token);actor=new(getDocumentClass("Actor"))(baseActor.toJSON(),{parent:token})}else actor=game.actors.get(speaker.actor);actor?actor.weaponCheck(weapon,event.shiftKey):ui.notifications.warn(game.i18n.localize("CoC7.WarnNoActorAvailable"))}static async checkMacro(threshold=void 0,event=null){await CoC7Utilities.rollDice(event,{threshold})}static createMacro(bar,data,slot){if(!["Item","CoC7Link"].includes(data.type))return;if("CoC7Link"===data.type)return CoC7Link.makeMacroData(data).then((macroData=>{macroData&&Macro.create(macroData).then((macro=>{game.user.assignHotbarMacro(macro,slot)}))})),!1;const item=fromUuidSync(data.uuid,bar);if(!item)return ui.notifications.warn(game.i18n.localize("CoC7.WarnMacroNoItemFound"));if("weapon"!==item.type&&"skill"!==item.type)return ui.notifications.warn(game.i18n.localize("CoC7.WarnMacroIncorrectType"));let command="";if("weapon"===item.type&&(command=`game.CoC7.macros.weaponCheck({name:'${item.name}', uuid:'${data.uuid}'}, event);`),"skill"===item.type){if(CoC7Item.isAnySpec(item))return ui.notifications.warn(game.i18n.localize("CoC7.WarnNoGlobalSpec"));command=`game.CoC7.macros.skillCheck({name:'${item.name}', uuid:'${data.uuid}'}, event);`}if(""!==command){const macro=game.macros.contents.find((m=>m.name===item.name&&m.command===command));return macro?(game.user.assignHotbarMacro(macro,slot),!1):(Macro.create(foundry.utils.duplicate({name:item.name,type:"script",img:item.img,command})).then((macro=>{game.user.assignHotbarMacro(macro,slot)})),!1)}return!0}static async toggleDevPhase(toggle){await game.settings.set("CoC7","developmentEnabled",toggle),ui.notifications.info(toggle?game.i18n.localize("CoC7.DevPhaseEnabled"):game.i18n.localize("CoC7.DevPhaseDisabled")),game.socket.emit("system.CoC7",{type:"updateChar"}),CoC7Utilities.updateCharSheets()}static async toggleCharCreation(toggle){await game.settings.set("CoC7","charCreationEnabled",toggle),ui.notifications.info(toggle?game.i18n.localize("CoC7.CharCreationEnabled"):game.i18n.localize("CoC7.CharCreationDisabled")),game.socket.emit("system.CoC7",{type:"updateChar"}),CoC7Utilities.updateCharSheets(),Hooks.call("toggleCharCreation",toggle)}static async getTarget(){const users=game.users.filter((user=>user.active)),actors=game.actors;let checkOptions=`<input type="checkbox" name="COCCheckAllPC" id="COCCheckAllPC">\n\n    <label for="COCCheckAllPC">${game.i18n.localize("CoC7.allActors")}</label>`;const playerTokenIds=users.map((u=>u.character?.id)).filter((id=>void 0!==id)),selectedPlayerIds=canvas.tokens.controlled.map((token=>token.actor.id));actors.forEach((actor=>{const checked=(selectedPlayerIds.includes(actor.id)||playerTokenIds.includes(actor.id))&&"checked";checkOptions+=`\n     <br>\n     <input type="checkbox" name="${actor.id}" id="${actor.id}" value="${actor.name}" ${checked}>\n\n     <label for="${actor.id}">${actor.name}</label>\n       `})),new Dialog({title:`${game.i18n.localize("CoC7.dreaming")}`,content:`${game.i18n.localize("CoC7.restTargets")}: ${checkOptions} <br>`,buttons:{whisper:{label:`${game.i18n.localize("CoC7.startRest")}`,callback:async html=>{const targets=[];let all=!1;const users=html.find('[type="checkbox"]');for(const user of users)"COCCheckAllPC"===user.name&&user.checked&&(all=!0),(user.checked||all)&&targets.push(user.id);await CoC7Utilities.startRest(targets)}}}}).render(!0)}static async startRest(targets){if(!targets.length)return;const actors=game.actors.filter((actor=>targets.includes(actor.id)));let chatContent=`<i>${game.i18n.localize("CoC7.dreaming")}...</i><br>`;for(const actor of actors)if(["character","npc","creature"].includes(actor.type)){let quickHealer=!1;for(const item of actor.items)"talent"===item.type&&item.name===`${game.i18n.localize("CoC7.quickHealer")}`&&(quickHealer=!0);const isCriticalWounds=!game.settings.get("CoC7","pulpRuleIgnoreMajorWounds")&&actor.hasConditionStatus(COC7.status.criticalWounds),dailySanityLoss=actor.system.attribs.san.dailyLoss,hpValue=actor.system.attribs.hp.value,hpMax=actor.system.attribs.hp.max,mpValue=actor.system.attribs.mp.value,mpMax=actor.system.attribs.mp.max,pow=actor.system.characteristics.pow.value;if(chatContent+=`<br><b>${actor.name}. </b>`,hpValue<hpMax)if(!0===isCriticalWounds)chatContent+=`<b style="color:darkred">${game.i18n.localize("CoC7.hasCriticalWounds")}. </b>`;else{let healAmount=1;game.settings.get("CoC7","pulpRuleFasterRecovery")&&(healAmount=2),!0===quickHealer&&healAmount++,healAmount=Math.min(healAmount,hpMax-hpValue),chatContent+=1===healAmount?`<b style="color:darkolivegreen">${game.i18n.localize("CoC7.healthRecovered")}. </b>`:`<b style="color:darkolivegreen">${game.i18n.format("CoC7.pulpHealthRecovered",{number:healAmount})}. </b>`,actor.update({"system.attribs.hp.value":actor.system.attribs.hp.value+healAmount})}dailySanityLoss>0&&(chatContent+=`<b style="color:darkolivegreen">${game.i18n.localize("CoC7.dailySanLossRestarted")}.</b>`,actor.update({"system.attribs.san.dailyLoss":0,"system.attribs.san.dailyLimit":Math.floor(actor.system.attribs.san.value/5)}));const hours=7;if(hours>0&&mpValue<mpMax){let magicAmount=hours*Math.ceil(pow/100);magicAmount=Math.min(magicAmount,mpMax-mpValue),chatContent+=`<b style="color:darkolivegreen">${game.i18n.format("CoC7.magicPointsRecovered")}: ${magicAmount}.</b>`,actor.update({"system.attribs.mp.value":actor.system.attribs.mp.value+magicAmount})}}const chatData={user:game.user.id,speaker:ChatMessage.getSpeaker(),content:chatContent,type:CONST.CHAT_MESSAGE_TYPES.OTHER};ChatMessage.create(chatData)}static async toggleXPGain(toggle){await game.settings.set("CoC7","xpEnabled",toggle),ui.notifications.info(toggle?game.i18n.localize("CoC7.XPGainEnabled"):game.i18n.localize("CoC7.XPGainDisabled"))}static async rollDice(event,options={}){let diceModifier,difficulty,flatDiceModifier,flatThresholdModifier;options.askValue=!options.threshold;let threshold=options.threshold;if(void 0!==options.modifier&&(diceModifier=Number(options.modifier)),void 0!==options.difficulty&&(difficulty=CoC7Utilities.convertDifficulty(options.difficulty)),!event?.shiftKey&&!options.fastForward){const usage=await RollDialog.create(options);usage&&(diceModifier=Number(usage.get("bonusDice")),difficulty=Number(usage.get("difficulty")),threshold=Number(usage.get("threshold")),flatDiceModifier=Number(usage.get("flatDiceModifier")),flatThresholdModifier=Number(usage.get("flatThresholdModifier")))}const actors=[];if(game.user.isGM&&canvas.tokens.controlled.length)for(const token of canvas.tokens.controlled)actors.push(token.actor.tokenKey);else game.user.character&&actors.push(game.user.character.tokenKey);for(const tk of actors){const check=new CoC7Check;check.diceModifier=diceModifier||0,check.difficulty=difficulty||CoC7Check.difficultyLevel.regular,check.rawValue=threshold,check.flatDiceModifier=flatDiceModifier,check.flatThresholdModifier=flatThresholdModifier,check.actor=tk,await check.roll(),check.toMessage()}if(!actors.length){const check=new CoC7Check;check.diceModifier=diceModifier||0,check.difficulty=difficulty||CoC7Check.difficultyLevel.regular,check.rawValue=threshold,check.flatDiceModifier=flatDiceModifier,check.flatThresholdModifier=flatThresholdModifier,await check.roll(),check.toMessage()}}static updateCharSheets(){if(game.user.isGM)for(const a of game.actors.contents)"character"===a?.type&&a?.sheet&&a?.sheet?.rendered&&(a.update({"system.flags.locked":!0}),a.render(!1));else for(const a of game.actors.contents)a.isOwner&&(a.update({"system.flags.locked":!0}),a.render(!1))}static async getDataFromDropEvent(event,entityType="Item"){if(event.originalEvent)return[];try{const dataList=JSON.parse(event.dataTransfer.getData("text/plain"));if("Folder"===dataList.type&&dataList.documentName===entityType){const folder=await fromUuid(dataList.uuid);return folder?folder.contents:[]}if(dataList.type===entityType){const item=await fromUuid(dataList.uuid);return item?[item]:[]}return[]}catch(err){return[]}}static async copyToClipboard(text){try{if(navigator.clipboard&&window.isSecureContext)return navigator.clipboard.writeText(text);{const textArea=document.createElement("textarea");return textArea.value=text,textArea.style.position="fixed",textArea.style.left="-999px",textArea.style.top="-999px",document.body.appendChild(textArea),textArea.focus(),textArea.select(),new Promise(((resolve,reject)=>{document.execCommand("copy")?resolve():reject(new Error(game.i18n.localize("CoC7.UnableToCopyToClipboard"))),textArea.remove()})).catch((err=>ui.notifications.error(err)))}}catch(err){ui.notifications.error(game.i18n.localize("CoC7.UnableToCopyToClipboard"))}}static quoteRegExp(string){const len=string.length;let qString="";for(let current,i=0;i<len;++i)if(current=string.charAt(i),current>=" "&&current<="~")"\\"!==current&&"'"!==current||(qString+="\\"),qString+=current.replace(/[-[\]/{}()*+?.\\^$|]/g,"\\$&");else switch(current){case"\b":qString+="\\b";break;case"\f":qString+="\\f";break;case"\n":qString+="\\n";break;case"\r":qString+="\\r";break;case"\t":qString+="\\t";break;case"\v":qString+="\\v";break;default:qString+="\\u",current=current.charCodeAt(0).toString(16);for(let j=4;--j>=current.length;qString+="0");qString+=current}return qString}static SfromUuid(uuid){let doc,parts=uuid.split(".");if("Compendium"===parts[0])return null;{const[docName,docId]=parts.slice(0,2);parts=parts.slice(2);doc=CONFIG[docName].collection.instance.get(docId)}for(;doc&&parts.length>1;){const[embeddedName,embeddedId]=parts.slice(0,2);doc=doc.getEmbeddedDocument(embeddedName,embeddedId),parts=parts.slice(2)}return doc||null}static isDocumentUuidPack(uuid){return!!uuid.includes("Compendium")}static isDocumentUuid(uuid){const identifiers=["Actor","Scene","Token","Item","Compendium"];for(let i=0;i<identifiers.length;i++)if(uuid.includes(identifiers[i]))return!0;return!1}static getActorDocumentFromDropData(dropData){let docUuid,actor;return docUuid=dropData.tokenUuid?dropData.tokenUuid:void 0!==dropData.uuid?dropData.uuid:dropData.sceneId&&dropData.tokenId?`Scene.${dropData.sceneId}.Token.${dropData.tokenId}`:dropData.actorId||dropData.actorKey||dropData.id,"Token"===dropData.type?docUuid=dropData.uuid:docUuid&&(actor=CoC7Utilities.getActorFromKey(docUuid),actor||"Item"!==dropData.type||(docUuid=null)),actor&&docUuid!==actor.uuid&&(docUuid=actor.uuid),docUuid}static getDocumentFromKey(key){if(!key)return null;if(CoC7Utilities.isDocumentUuid(key))return CoC7Utilities.isDocumentUuidPack(key)?fromUuid(key):CoC7Utilities.SfromUuid(key);if(key.includes(".")){const[sceneId,tokenId]=key.split(".");if("TOKEN"===sceneId)return game.actors.tokens[tokenId];const scene=game.scenes.get(sceneId);if(!scene)return null;const tokenData=scene.getEmbeddedDocument("Token",tokenId);if(!tokenData)return null;const token=new Token(tokenData);return token.scene||(token.scene=foundry.utils.duplicate(scene)),token}return game.actors.get(key)||null}static getActorFromKey(key){const doc=CoC7Utilities.getDocumentFromKey(key);return doc?doc.actor?doc.actor:"CoCActor"===doc.constructor?.name?doc:null:null}static async createImportCharactersFolderIfNotExists(){let folderName=game.i18n.localize("CoC7.ImportedCharactersFolder");"CoC7.ImportedCharactersFolder"===folderName&&(folderName="Imported characters");let importedCharactersFolder=game.folders.find((entry=>entry.name===folderName&&"Actor"===entry.type));return null==importedCharactersFolder&&(importedCharactersFolder=await Folder.create({name:folderName,type:"Actor",parent:null}),ui.notifications.info(game.i18n.localize("CoC7.CreatedImportedCharactersFolder"))),importedCharactersFolder}static async guessItem(type,name,{combat=null,source="",fallbackAny=!1}={}){let existing=null;name=name.toLocaleLowerCase();for(let o=0,oM=source.length;o<oM;o++)switch(source.substring(o,o+1)){case"i":if(existing=game.items.find((item=>item.type===type&&item.name.toLowerCase()===name&&(null===combat||item.system.properties.combat===combat))),existing)return existing;break;case"w":case"m":case"s":for(const pack of game.packs)if("Item"===pack.metadata.type&&("w"===source[o]&&"world"===pack.metadata.package||"S"===source[o]&&"CoC7"===pack.metadata.package||"s"===source[o]&&!["world","CoC7"].includes(pack.metadata.package))){if(existing=(await pack.getDocuments()).find((item=>item.type===type&&item.name.toLowerCase()===name&&(null===combat||item.system.properties.combat===combat))),existing)return existing}}if(fallbackAny&&"skill"===type){const match=name.match(/^(.+ \()(?!any).+(\))$/);if(match)return await CoC7Utilities.guessItem(type,match[1]+"any"+match[2],{combat,source})}}static toKebabCase(s){if(!s)return"";const match=s.match(/[A-Z]{2,}(?=[A-Z][a-z]+[0-9]*|\b)|[A-Z]?[a-z]+[0-9]*|[A-Z]|[0-9]+/g);return match?match.join("-").toLowerCase():""}static sortByNameKey(a,b){return a.name.normalize("NFD").replace(/[\u0300-\u036f]/g,"").toLocaleLowerCase().localeCompare(b.name.normalize("NFD").replace(/[\u0300-\u036f]/g,"").toLocaleLowerCase())}static sortBySpecializationThenName(a,b){const normalize=str=>(str||"").normalize("NFD").replace(/[\u0300-\u036f]/g,"").toLocaleLowerCase(),sortKeyA=normalize(a.system.specialization||a.name),sortKeyB=normalize(b.system.specialization||b.name),primaryCompare=sortKeyA.localeCompare(sortKeyB);if(0!==primaryCompare)return primaryCompare;const nameA=normalize(a.name),nameB=normalize(b.name);return nameA.localeCompare(nameB)}static getAnIdForGm(){const keepers=game.users.filter((u=>u.active&&u.isGM&&u.id!==game.user.id));switch(keepers.length){case 0:return ui.notifications.error("CoC7.ErrorMissingKeeperUser",{localize:!0}),!1;case 1:return keepers[0].id}return keepers[Math.floor(Math.random()*keepers.length)].id}static halfDB(db){db=(""===(db??"").toString().trim()?0:db).toString().trim();const roll=new Roll(db);for(const term of roll.terms)foundry.utils.isNewerVersion(game.version,"12")&&term instanceof foundry.dice.terms.Die?term._faces=Math.floor(term._faces/2):term instanceof foundry.dice.terms.Die?term.faces=Math.floor(term.faces/2):term instanceof foundry.dice.terms.NumericTerm&&(term.number=term.number<0?Math.ceil(term.number/2):Math.floor(term.number/2));let formula=roll.formula.toString().trim();return formula.startsWith("-")||(formula="+"+formula),formula}}class CoCIDEditor extends FormApplication{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{classes:["coc7","dialog","coc-id-editor"],template:"systems/CoC7/templates/apps/coc-id-editor.hbs",width:900,height:"auto",title:"CoC7.CoCIDFlag.title",closeOnSubmit:!1,submitOnClose:!0,submitOnChange:!0})}async getData(){const sheetData=super.getData();sheetData.supportedLanguages=CONFIG.supportedLanguages,this.options.editable=this.object.sheet.isEditable,sheetData.guessCode=game.system.api.cocid.guessId(this.object),sheetData.idPrefix=game.system.api.cocid.getPrefix(this.object),sheetData.cocidFlag=this.object.flags?.CoC7?.cocidFlag,sheetData.id=sheetData.cocidFlag?.id||"",sheetData.lang=sheetData.cocidFlag?.lang||game.i18n.lang,sheetData.priority=sheetData.cocidFlag?.priority||0,sheetData.eras=[];for(const[key,value]of Object.entries(COC7.eras))sheetData.eras.push({id:key,name:game.i18n.localize(value),isEnabled:!0===(sheetData.cocidFlag?.eras??{})[key]});sheetData.eras.sort(CoC7Utilities.sortByNameKey);const CoCIDKeys=Object.assign(foundry.utils.flattenObject(game.i18n._fallback.CoC7?.CoCIDFlag?.keys??{}),foundry.utils.flattenObject(game.i18n.translations.CoC7?.CoCIDFlag?.keys??{})),prefix=new RegExp("^"+CoC7Utilities.quoteRegExp(sheetData.idPrefix));sheetData.existingKeys=Object.keys(CoCIDKeys).reduce(((obj,k)=>(k.match(prefix)&&obj.push({k,name:CoCIDKeys[k]}),obj)),[]).sort(CoC7Utilities.sortByNameKey),sheetData.isSystemID=void 0!==CoCIDKeys[sheetData.id];const match=sheetData.id.match(/^([^\\.]+)\.([^\\.]*)\.(.+)/);if(sheetData._existing=match&&void 0!==match[3]?match[3]:"",sheetData.id&&sheetData.lang){const worldDocuments=await game.system.api.cocid.fromCoCIDAll({cocid:sheetData.id,lang:sheetData.lang,scope:"world"}),usedEras={},uniqueWorldPriority={};sheetData.worldDocumentInfo=await Promise.all(worldDocuments.map((async d=>{d.flags.CoC7.cocidFlag.eras?Object.entries(d.flags.CoC7.cocidFlag.eras).filter((e=>e[1])).map((e=>(Object.prototype.hasOwnProperty.call(uniqueWorldPriority,d.flags.CoC7.cocidFlag.priority+"/"+e[0])||(uniqueWorldPriority[d.flags.CoC7.cocidFlag.priority+"/"+e[0]]=0),uniqueWorldPriority[d.flags.CoC7.cocidFlag.priority+"/"+e[0]]++,!1))):uniqueWorldPriority[d.flags.CoC7.cocidFlag.priority+"/*"]=1;const eras=d.flags.CoC7.cocidFlag.eras?Object.entries(d.flags.CoC7.cocidFlag.eras).filter((e=>e[1])).map((e=>e[0])).sort():[];for(const era of eras)usedEras[era]=COC7.eras[era]??"?";const folders=[];let e=d?.folder;for(;e?.name;)folders.unshift(e?.name),e=e.folder;return{eras:eras.reduce((function(all,current){return all[current]=!0,all}),{}),priority:d.flags.CoC7.cocidFlag.priority,lang:d.flags.CoC7.cocidFlag.lang??"en",link:await TextEditor.enrichHTML(d.link,{async:!0}),folder:folders.map((n=>n.indexOf(" ")>-1?'"'+n+'"':n)).join(" &gt; ")}}))),Object.entries(uniqueWorldPriority).filter((c=>c[1]>1)).length>0&&(sheetData.warnDuplicateWorldPriority=!0),sheetData.worldDuplicates=worldDocuments.length??0;const compendiumDocuments=await game.system.api.cocid.fromCoCIDAll({cocid:sheetData.id,lang:sheetData.lang,scope:"compendiums"}),uniqueCompendiumPriority={};sheetData.compendiumDocumentInfo=await Promise.all(compendiumDocuments.map((async d=>{d.flags.CoC7.cocidFlag.eras?Object.entries(d.flags.CoC7.cocidFlag.eras).filter((e=>e[1])).map((e=>(Object.prototype.hasOwnProperty.call(uniqueCompendiumPriority,d.flags.CoC7.cocidFlag.priority+"/"+e[0])||(uniqueCompendiumPriority[d.flags.CoC7.cocidFlag.priority+"/"+e[0]]=0),uniqueCompendiumPriority[d.flags.CoC7.cocidFlag.priority+"/"+e[0]]++,!1))):uniqueCompendiumPriority[d.flags.CoC7.cocidFlag.priority+"/*"]=1;const eras=d.flags.CoC7.cocidFlag.eras?Object.entries(d.flags.CoC7.cocidFlag.eras).filter((e=>e[1])).map((e=>e[0])).sort():[];for(const era of eras)usedEras[era]=COC7.eras[era]??"?";const folders=[];let e=d?.folder;for(;e?.name;)folders.unshift(e?.name),e=e.folder;for(folders.unshift(d.compendium.metadata.label),e=d?.compendium.folder;e?.name;)folders.unshift(e?.name),e=e.folder;return{eras:eras.reduce((function(all,current){return all[current]=!0,all}),{}),priority:d.flags.CoC7.cocidFlag.priority,lang:d.flags.CoC7.cocidFlag.lang??"en",link:await TextEditor.enrichHTML(d.link,{async:!0}),folder:folders.map((n=>n.indexOf(" ")>-1?'"'+n+'"':n)).join(" &gt; ")}}))),Object.entries(uniqueCompendiumPriority).filter((c=>c[1]>1)).length>0&&(sheetData.warnDuplicateCompendiumPriority=!0),sheetData.compendiumDuplicates=compendiumDocuments.length??0,sheetData.usedEras=[];for(const[key,value]of Object.entries(usedEras))sheetData.usedEras.push({id:key,name:game.i18n.localize(value)});sheetData.usedEras.sort(CoC7Utilities.sortByNameKey)}else sheetData.compendiumDocumentInfo=[],sheetData.worldDocumentInfo=[],sheetData.worldDuplicates=0,sheetData.compendiumDuplicates=0,sheetData.warnDuplicateWorldPriority=!1,sheetData.warnDuplicateCompendiumPriority=!1;return sheetData}activateListeners(html){super.activateListeners(html),html.find("a.copy-to-clipboard").click((function(e){CoC7Utilities.copyToClipboard($(this).siblings("input").val())})),this.object.sheet.isEditable&&(html.find(".toggle-switch").click(this._onClickToggle.bind(this)),html.find("input[name=_existing").change((function(e){const obj=$(this),prefix=obj.data("prefix");let value=obj.val();""!==value&&(value=prefix+CoC7Utilities.toKebabCase(value)),html.find("input[name=id]").val(value).trigger("change")})),html.find("select[name=known]").change((function(e){const obj=$(this);html.find("input[name=id]").val(obj.val())})),html.find("a[data-guess]").click((async function(e){e.preventDefault();const guess=$(this).data("guess");html.find("input[name=id]").val(guess).trigger("change")})))}static async eraToggle(document,propertyId){if("setup"===document.type){const update={[propertyId]:!0};if(void 0!==document.flags?.CoC7?.cocidFlag?.eras)for(const[key]of Object.entries(document.flags.CoC7.cocidFlag.eras))key!==propertyId&&(update["-="+key]=null);await document.update({"flags.CoC7.cocidFlag.eras":update})}else void 0===document.flags?.CoC7?.cocidFlag?.eras?.[propertyId]?void 0===document.flags?.CoC7?.cocidFlag?.eras?await document.update({"flags.CoC7.cocidFlag.eras":{[propertyId]:!0}}):await document.update({[`flags.CoC7.cocidFlag.eras.${propertyId}`]:!0}):await document.update({[`flags.CoC7.cocidFlag.eras.-=${propertyId}`]:null})}async _onClickToggle(event){event.preventDefault();const propertyId=event.currentTarget.dataset.property;await CoCIDEditor.eraToggle(this.object,propertyId);const options=foundry.utils.duplicate(this.options);await this.close(),await this.render(!0,options)}async _updateObject(event,formData){const id=formData.id||"";await this.object.update({"flags.CoC7.cocidFlag.id":id,"flags.CoC7.cocidFlag.lang":formData.lang||game.i18n.lang,"flags.CoC7.cocidFlag.priority":formData.priority||0,"flags.CoC7.cocidFlag.eras":this.object.flags?.CoC7?.cocidFlag?.eras??{}});const html=$(this.object.sheet.element).find("header.window-header a.header-button.edit-coc-id-warning,header.window-header a.header-button.edit-coc-id-exisiting");html.length&&html.css({color:id?"var(--color-text-light-highlight)":"red"}),this.render()}}class CoC7Item extends Item{constructor(data,context){if(data.type in CONFIG.Item.documentClasses&&!context?.extended)return new CONFIG.Item.documentClasses[data.type](data,{extended:!0,...context});void 0===data.img&&("skill"===data.type?data.img="systems/CoC7/assets/icons/skills.svg":"status"===data.type?data.img="icons/svg/aura.svg":"weapon"===data.type&&(data.img="icons/svg/sword.svg")),super(data,context)}async _createDocumentLink(eventData,{relativeTo,label}={}){if("string"==typeof eventData.type&&"string"==typeof eventData.uuid&&"Item"===eventData.type&&eventData.uuid.match(/^Actor\./)&&relativeTo instanceof CONFIG.JournalEntryPage.documentClass){const item=await fromUuid(eventData.uuid);if(["skill","weapon"].includes(item.type))return"@coc7.check[type:"+item.type+",name:"+item.name+"]"}return super._createDocumentLink(eventData,{relativeTo,label})}static get iconLanguage(){return"systems/CoC7/assets/icons/skills/language.svg"}static get flags(){return{malfunction:"malfc"}}async toggleProperty(propertyId,override=!1){let fighting,firearms,ranged,checkedProps={};if(void 0!==COC7.eras[propertyId])return CoCIDEditor.eraToggle(this,propertyId);if("weapon"!==this.type||override){if("skill"===this.type&&!override){let modif=!1;switch(propertyId){case"combat":this.system.properties.combat?checkedProps={"system.properties.combat":!1,"system.properties.special":!1,"system.properties.fighting":!1,"system.properties.firearm":!1,"system.properties.ranged":!1,"system.specialization":"",name:this.system.skillName}:fighting=!0,modif=!0;break;case"fighting":this.system.properties.fighting||(modif=!0,firearms=!1,ranged=!1,fighting=!0);break;case"firearm":this.system.properties.firearm||(modif=!0,firearms=!0,ranged=!1,fighting=!1),modif=!0;break;case"ranged":this.system.properties.ranged||(modif=!0,firearms=!1,ranged=!0,fighting=!1),modif=!0}if(modif)if(fighting){checkedProps={"system.properties.fighting":!0,"system.properties.firearm":!1,"system.properties.ranged":!1,"system.properties.combat":!0,"system.properties.special":!0};const parts=CoC7Item.getNamePartsSpec(this.system.skillName,game.i18n.localize(COC7.fightingSpecializationName));checkedProps.name=parts.name,checkedProps.skillName=parts.skillName,checkedProps["system.specialization"]=parts.specialization}else if(firearms){checkedProps={"system.properties.fighting":!1,"system.properties.firearm":!0,"system.properties.ranged":!1,"system.properties.combat":!0,"system.properties.special":!0};const parts=CoC7Item.getNamePartsSpec(this.system.skillName,game.i18n.localize(COC7.firearmSpecializationName));checkedProps.name=parts.name,checkedProps.skillName=parts.skillName,checkedProps["system.specialization"]=parts.specialization}else if(ranged){checkedProps={"system.properties.fighting":!1,"system.properties.firearm":!1,"system.properties.ranged":!0,"system.properties.combat":!0,"system.properties.special":!0};const parts=CoC7Item.getNamePartsSpec(this.system.skillName,game.i18n.localize(COC7.rangedSpecializationName));checkedProps.name=parts.name,checkedProps.skillName=parts.skillName,checkedProps["system.specialization"]=parts.specialization}}}else if("ahdb"===propertyId&&(checkedProps=this.system.properties.ahdb?{"system.properties.ahdb":!1}:{"system.properties.ahdb":!0,"system.properties.addb":!1}),"addb"===propertyId&&(checkedProps=this.system.properties.addb?{"system.properties.addb":!1}:{"system.properties.addb":!0,"system.properties.ahdb":!1}),"shotgun"===propertyId&&(checkedProps=this.system.properties.shotgun?{"system.properties.shotgun":!1,"system.range.extreme.value":null,"system.range.extreme.damage":null,"system.range.long.value":null,"system.range.long.damage":null}:{"system.properties.rngd":!0,"system.properties.melee":!1,"system.properties.shotgun":!0}),"melee"===propertyId||"rngd"===propertyId){let meleeWeapon;"melee"!==propertyId||this.system.properties.melee||(meleeWeapon=!0),"melee"===propertyId&&this.system.properties.melee&&(meleeWeapon=!1),"rngd"!==propertyId||this.system.properties.rngd||(meleeWeapon=!1),"rngd"===propertyId&&this.system.properties.rngd&&(meleeWeapon=!0),checkedProps=meleeWeapon?{"system.properties.melee":!0,"system.properties.rngd":!1,"system.properties.shotgun":!1,"system.properties.brst":!1,"system.properties.auto":!1,"system.properties.dbrl":!1}:{"system.properties.melee":!1,"system.properties.rngd":!0}}if("special"===propertyId&&(checkedProps=this.system.properties[propertyId]?{"system.properties.special":!1,"system.properties.fighting":!1,"system.properties.firearm":!1,"system.properties.ranged":!1,"system.properties.combat":!1,"system.specialization":"",name:this.system.skillName}:{"system.properties.special":!0,name:this.system.specialization+" ("+this.system.skillName+")"}),Object.keys(checkedProps).length>0){return await this.update(checkedProps)}{const propName=`system.properties.${propertyId}`,propValue=!this.system.properties[propertyId];await this.update({[propName]:propValue}).then((item=>item))}}hasProperty(propertyId){return this.isIncludedInSet("properties",propertyId)}get shortName(){return this.system.properties.special?this.system.skillName:this.name}async updateRoll(roll){return"updateRoll"in this.sheet?await this.sheet.updateRoll(roll):"updateRoll"in this?await this.updateRoll(roll):void 0}static getNamePartsSpec(skillName,specialization){if(!specialization)return{name:skillName,specialization:"",skillName};const specNameRegex=new RegExp("^("+CoC7Utilities.quoteRegExp(specialization)+")\\s*\\((.+)\\)$","i"),match=skillName.match(specNameRegex);return match&&(specialization=match[1],skillName=match[2]),{name:specialization+" ("+skillName+")",specialization,skillName}}static getNameWithoutSpec(item){if(item instanceof CoC7Item){if(item.system?.properties?.special&&void 0!==item.system.skillName)return item.system.skillName}else if(item.properties?.special&&void 0!==item.skillName)return item.skillName;return item.name}static isAnySpec(item){return!("skill"!==item.type||!item.system.properties?.special)&&(!(!item.system.properties?.requiresname&&!item.system.properties?.picknameonly)||[game.i18n.localize("CoC7.AnySpecName").toLowerCase(),"any"].includes(CONFIG.Item.documentClasses.skill.guessNameParts(item.name).skillName.toLowerCase()))}async checkSkillProperties(){if("skill"!==this.type)return;const checkedProps={};return this.system.properties.combat?(this.system.properties.special||(this.system.properties.special=!0,checkedProps["system.properties.special"]=!0),this.system.properties.fighting||this.system.properties.firearm||(this.system.properties.fighting=!0,checkedProps["system.properties.fighting"]=!0),!this.system.properties.fighting||this.system.specialization&&""!==this.system.specialization||(this.system.specialization=game.i18n.localize(COC7.fightingSpecializationName),checkedProps["system.specialization"]=game.i18n.localize(COC7.fightingSpecializationName)),!this.system.properties.firearm||this.system.specialization&&""!==this.system.specialization||(this.system.specialization=game.i18n.localize(COC7.firearmSpecializationName),checkedProps["system.specialization"]=game.i18n.localize(COC7.firearmSpecializationName))):(this.system.properties.fighting&&(this.system.properties.fighting=!1,checkedProps["system.properties.fighting"]=!1),this.system.properties.firearm&&(this.system.properties.firearm=!1,checkedProps["system.properties.firearm"]=!1)),Object.keys(checkedProps).length>0&&await this.update(checkedProps),checkedProps}isIncludedInSet(set,propertyId){this.system[set]||(this.system[set]=[]);return this.system[set].indexOf(propertyId)>-1}async flagForDevelopement(){(game.settings.get("CoC7","xpEnabled")||game.user.isGM)&&(this.system.flags||await this.update({"system.flags":{}}),await this.update({"system.flags.developement":!0}))}async unflagForDevelopement(){(game.settings.get("CoC7","xpEnabled")||game.user.isGM)&&(this.system.flags||await this.update({"system.flags":{}}),await this.update({"system.flags.developement":!1}))}get developementFlag(){return this.getItemFlag("developement")}async toggleItemFlag(flagName,eraseAdjustment=!0){const flagValue=!this.getItemFlag(flagName),name=`system.flags.${flagName}`;"occupation"!==flagName&&"archetype"!==flagName||flagValue||!eraseAdjustment?"developement"===flagName?game.settings.get("CoC7","xpEnabled")||game.user.isGM?await this.update({[name]:flagValue}):ui.notifications.info(game.i18n.localize("CoC7.SkillXpGainDisabled")):await this.update({[name]:flagValue}):await this.update({[`system.adjustments.${flagName}`]:null,[name]:flagValue})}async setItemFlag(flagName){await this.update({[`system.flags.${flagName}`]:!0})}async unsetItemFlag(flagName,eraseAdjustment=!0){const name=`system.flags.${flagName}`;"occupation"!==flagName&&"archetype"!==flagName||!eraseAdjustment?await this.update({[name]:!1}):await this.update({[`system.adjustments.${flagName}`]:null,[name]:!1})}getItemFlag(flagName){return this.system.flags?!!this.system.flags[flagName]&&this.system.flags[flagName]:(this.system.flags={},this.system.flags.locked=!0,this.update({"system.flags":{}}),!1)}get usesAlternativeSkill(){return"weapon"===this.type&&(!0===this.system.properties?.auto||!0===this.system.properties?.brst||!0===this.system.properties?.thrown)}get maxUsesPerRound(){if("weapon"!==this.type)return null;const multiShot=parseInt(this.system.usesPerRound.max);return isNaN(multiShot)?0:multiShot}get usesPerRound(){if("weapon"!==this.type)return null;const singleShot=parseInt(this.system.usesPerRound.normal);return isNaN(singleShot)?0:singleShot}get usesPerRoundString(){let usesPerRound;return usesPerRound=this.system.usesPerRound.normal?this.system.usesPerRound.normal:"1",this.system.usesPerRound.max&&(usesPerRound+=`(${this.system.usesPerRound.max})`),this.system.properties.auto&&(usesPerRound+=` ${game.i18n.localize("CoC7.WeaponAuto")}`),this.system.properties.brst&&(usesPerRound+=` ${game.i18n.localize("CoC7.WeaponBrst")}`,this.system.usesPerRound.burst&&(usesPerRound+=`(${this.system.usesPerRound.burst})`)),usesPerRound}get multipleShots(){return"weapon"!==this.type?null:!(this.maxUsesPerRound<=1)}get singleShot(){return"weapon"!==this.type?null:!!this.usesPerRound}get baseRange(){const result=parseInt(this.system.range.normal.value);return isNaN(result)?new Roll(this.system.range.normal.value,this.parent?.parseCharacteristics()??{}).evaluateSync().total:result}get longRange(){const result=parseInt(this.system.range.long.value);return isNaN(result)?new Roll(this.system.range.long.value,this.parent?.parseCharacteristics()??{}).evaluateSync().total:result}get extremeRange(){const result=parseInt(this.system.range.extreme.value);return isNaN(result)?new Roll(this.system.range.extreme.value,this.parent?.parseCharacteristics()??{}).evaluateSync().total:result}get skillProperties(){if("skill"!==this.type)return[];const skillProperties=[];for(const[key,value]of Object.entries(COC7.skillProperties))!0===this.system.properties[key]&&skillProperties.push(game.i18n.localize(value));return skillProperties}static async calculateBase(actor,data){if("skill"!==data.type)return null;if(String(data.system.base).includes("@")){const parsed={};for(const[key,value]of Object.entries(COC7.formula.actorsheet))key.startsWith("@")&&value.startsWith("this.actor.")&&(parsed[key.substring(1)]=foundry.utils.getProperty(actor,value.substring(11)));let value;try{value=Math.floor(new Roll(data.system.base,parsed)[foundry.utils.isNewerVersion(game.version,"12")?"evaluateSync":"evaluate"]({maximize:!0}).total)}catch(err){value=0}return value}return isNaN(parseInt(data.system.base))?null:parseInt(data.system.base)}get _base(){if("skill"!==this.type)return[null,!1];if("string"!=typeof this.system.base)return[this.system.base,!1];if(this.system.base.includes("@")){const parsed={};for(const[key,value]of Object.entries(COC7.formula.actorsheet))key.startsWith("@")&&value.startsWith("this.")&&(parsed[key.substring(1)]=foundry.utils.getProperty(this,value.substring(5)));let value;try{value=Math.floor(new Roll(this.system.base,parsed)[foundry.utils.isNewerVersion(game.version,"12")?"evaluateSync":"evaluate"]({maximize:!0}).total)}catch(err){value=0}return[value,!0]}return[isNaN(parseInt(this.system.base))?null:parseInt(this.system.base),!1]}async asyncBase(){const e=this._base;return e[1]&&(console.info(`[COC7] (${this.parent?.name}) Evaluating skill ${this.name}:${this.system.base} to ${e[0]}`),await this.update({"system.base":e[0]})),e[0]}get base(){const e=this._base;return e[1]&&this.update({"system.base":e[0]}),e[0]}getBulletLeft(){return"weapon"!==this.type?null:this.system.ammo?this.system.ammo:(this.setBullets(0),0)}async reload(){if("weapon"!==this.type)return null;const maxBullet=this.system.bullets?parseInt(this.system.bullets):1;await this.setBullets(maxBullet)}async setBullets(bullets){if("weapon"!==this.type)return null;await this.update({"system.ammo":bullets||0})}async addBullet(){if("weapon"!==this.type)return null;const bullets=await this.getBulletLeft(),maxBullets=this.system.bullets?parseInt(this.system.bullets):1;bullets+1>=maxBullets?await this.setBullets(maxBullets):await this.setBullets(bullets+1)}async shootBullets(x){if("weapon"!==this.type)return null;const bullets=await this.getBulletLeft();x>bullets?await this.setBullets(0):await this.setBullets(bullets-x)}static mergeOptionalSkills(skillList,options){return skillList.concat(options).reduce(((newArray,item)=>!CoC7Item.isAnySpec(item)&&newArray.find((skill=>skill.name===item.name))?newArray:[...newArray,item]),[]).sort(CoC7Utilities.sortByNameKey)}static _getChatCardActor(card){const tokenKey=card.dataset.tokenId;if(tokenKey){const[sceneId,tokenId]=tokenKey.split(".");if("TOKEN"===sceneId)return game.actors.tokens[tokenId];{const scene=game.scenes.get(sceneId);if(!scene)return null;const tokenData=scene.getEmbeddedDocument("Token",tokenId);if(!tokenData)return null;return new Token(tokenData).actor}}const actorId=card.dataset.actorId;return game.actors.get(actorId)||null}async getChatData(htmlOptions={}){htmlOptions.async=!0;const data=foundry.utils.duplicate(this.system);"string"==typeof data.description&&(data.description={value:data.description,special:""}),void 0===data.description.value&&(data.description.value=""),void 0===data.description.special&&(data.description.special="");const labels=[];data.description.value=await TextEditor.enrichHTML(data.description.value,htmlOptions),data.description.special=await TextEditor.enrichHTML(data.description.special,htmlOptions);const props=[],fn=this[`_${this.type}ChatData`];if(fn&&fn.bind(this)(data,labels,props,htmlOptions),"skill"===this.type)for(const[key,value]of Object.entries(COC7.skillProperties))!0===this.system.properties[key]&&props.push(value);return data.properties=props.filter((p=>!!p)),data.labels=labels,data}_weaponChatData(data,labels,props){for(const[key,value]of Object.entries(COC7.weaponProperties))!0===this.system.properties[key]&&props.push(value);let skillLabel=game.i18n.localize("CoC7.Skill"),skillName="",found=!1;if(this.system.skill.main.id){const skill=this.actor?.items.get(this.system.skill.main.id);skill&&(skillName+=CoC7Item.getNameWithoutSpec(skill),found=!0)}if(this.usesAlternativeSkill&&this.system.skill.alternativ.id){skillLabel=game.i18n.localize("CoC7.Skills");const skill=this.actor?.items.get(this.system.skill.alternativ.id);skill&&(skillName+=`/${CoC7Item.getNameWithoutSpec(skill)}`,found=!0)}found||(skillName=this.system.skill.main.name,this.usesAlternativeSkill&&this.system.skill.alternativ.name&&(skillName+=`/${this.system.skill.alternativ.name}`)),skillName&&labels.push({name:skillLabel,value:skillName}),labels.push({name:game.i18n.localize("CoC7.WeaponUsesPerRound"),value:this.usesPerRoundString}),labels.push({name:game.i18n.localize("CoC7.WeaponMalfunction"),value:this.system.malfunction?this.system.malfunction:"-"}),this.system.bullets&&labels.push({name:game.i18n.localize("CoC7.WeaponBulletsInMag"),value:this.system.bullets})}canBePushed(){return!("skill"!==this.type||!this.system.properties.push)}get impale(){return this.system.properties.impl}get isDodge(){return"skill"===this.type&&this.name.toLowerCase()===game.i18n.localize("CoC7.CoCIDFlag.keys.i.skill.dodge").toLowerCase()}}class CoC7Check{constructor(actor=null,skill=null,item=null,diceMod=0,difficulty=null,flatThresholdModifier=0,flatDiceModifier=0){if(this.actor=actor,this.skill=skill,this.item=item,this.difficulty=difficulty,this.diceModifier=diceMod,this.rawValue=0,this.successLevel=null,this.referenceMessageId=null,this.pushing=!1,this.flatDiceModifier=flatDiceModifier,this.flatThresholdModifier=flatThresholdModifier,null===difficulty){const isUnknown="unknown"===game.settings.get("CoC7","defaultCheckDifficulty");this.difficulty=isUnknown?CoC7Check.difficultyLevel.unknown:CoC7Check.difficultyLevel.regular}}static get cardType(){return"rollCard"}static get difficultyLevel(){return{unknown:-1,regular:1,hard:2,extreme:3,critical:4,impossible:9}}static get successLevel(){return{fumble:-99,failure:0,regular:1,hard:2,extreme:3,critical:4}}static get type(){return{characteristic:"characteristic",attribute:"attribute",skill:"item",item:"item",value:"value"}}static difficultyString(difficultyLevel){switch(isNaN(Number(difficultyLevel))?difficultyLevel:Number(difficultyLevel)){case"?":return game.i18n.localize("CoC7.UnknownDifficulty");case"+":return game.i18n.localize("CoC7.HardDifficulty");case"++":return game.i18n.localize("CoC7.ExtremeDifficulty");case"+++":return game.i18n.localize("CoC7.CriticalDifficulty");case 0:return game.i18n.localize("CoC7.RegularDifficulty");case CoC7Check.difficultyLevel.unknown:return game.i18n.localize("CoC7.UnknownDifficulty");case CoC7Check.difficultyLevel.regular:return game.i18n.localize("CoC7.RegularDifficulty");case CoC7Check.difficultyLevel.hard:return game.i18n.localize("CoC7.HardDifficulty");case CoC7Check.difficultyLevel.extreme:return game.i18n.localize("CoC7.ExtremeDifficulty");case CoC7Check.difficultyLevel.critical:return game.i18n.localize("CoC7.CriticalDifficulty");default:return null}}get rawValue(){if(this._rawValue||(this.characteristic&&(this.rawValue=this.actor.system.characteristics[this.characteristic].value),this.skill&&(this.rawValue=this.skill.value),this.attribute&&(this.rawValue=this.actor.system.attribs[this.attribute].value)),this._rawValue)return this.flatThresholdModifier&&game.settings.get("CoC7","allowFlatThresholdModifier")?this._rawValue+this.flatThresholdModifier<1?1:this._rawValue+this.flatThresholdModifier:this._rawValue}set rawValue(x){this._rawValue=x}set uuid(x){this._uuid=x}get uuid(){return this._uuid||(this._uuid=foundry.utils.randomID(16)),this._uuid}get hasCard(){return ui.chat.collection.filter((message=>this.uuid===message.getFlag("CoC7","uuid")&&CoC7Check.cardType===message.getFlag("CoC7","type"))).length>0}get rawValueString(){return 0===this._rawValue?"0":this._rawValue?this.flatThresholdModifier&&game.settings.get("CoC7","allowFlatThresholdModifier")?this.flatThresholdModifier<0?this._rawValue.toString()+this.flatThresholdModifier.toString():this._rawValue.toString()+"+"+this.flatThresholdModifier.toString():this._rawValue.toString():void 0}get criticalThreshold(){return 1}get regularThreshold(){return this.rawValue?this.rawValue>=100?99:parseInt(this.rawValue):null}get hardThreshold(){return this.rawValue?Math.floor(this.rawValue/2):null}get extremeThreshold(){return this.rawValue?Math.floor(this.rawValue/5):null}get fumbleThreshold(){if(this.rawValue){if(this.difficulty){if(this.difficulty>=CoC7Check.difficultyLevel.extreme)return this.extremeThreshold<50?96:100;if(this.difficulty>=CoC7Check.difficultyLevel.hard)return this.hardThreshold<50?96:100}return this.rawValue<50?96:100}return null}get succesThreshold(){if(void 0!==this.difficulty)switch(this.difficulty){case CoC7Check.difficultyLevel.extreme:return this.extremeThreshold;case CoC7Check.difficultyLevel.hard:return this.hardThreshold;case CoC7Check.difficultyLevel.regular:return this.regularThreshold;case CoC7Check.difficultyLevel.critical:return this.criticalThreshold;case CoC7Check.difficultyLevel.unknown:return-1;default:return this.rawValue}return null}get difficultyString(){if(void 0!==this.difficulty)switch(this.difficulty){case CoC7Check.difficultyLevel.extreme:return game.i18n.format("CoC7.ExtremeDifficulty");case CoC7Check.difficultyLevel.hard:return game.i18n.format("CoC7.HardDifficulty");case CoC7Check.difficultyLevel.regular:return game.i18n.format("CoC7.RegularDifficulty");case CoC7Check.difficultyLevel.critical:return game.i18n.format("CoC7.CriticalDifficulty");case CoC7Check.difficultyLevel.unknown:return game.i18n.format("CoC7.UnknownDifficulty");default:return""}return""}get modifiedResult(){if(!this.standby){if(void 0!==this._modifiedResult)return this._modifiedResult;if(this.flatDiceModifier){const modified=this.dices.total+this.flatDiceModifier;return modified<1?1:modified>100?100:modified}return this.dices.total}}set modifiedResult(x){this._modifiedResult=x}get flatDiceModifierString(){return this.flatDiceModifier?this.flatDiceModifier>0?`+${this.flatDiceModifier}`:this.flatDiceModifier.toString():null}get isFumble(){if(!this.standby&&!this.isSimpleRoll)return this.modifiedResult>=this.fumbleThreshold}get isCritical(){if(!this.standby)return 1===this.modifiedResult}get isExtremeSuccess(){if(!this.standby)return this.successLevel>=CoC7Check.successLevel.extreme}get passed(){if(!this.standby&&!this.isSimpleRoll)return this.luckSpent?this.difficulty<=this.successLevel:this.succesThreshold>=this.modifiedResult||this.isCritical}get failed(){if(!this.standby&&!this.isSimpleRoll)return!this.passed}get isSimpleRoll(){return void 0===this.rawValue}get hasBonus(){return!!(this.diceModifier&&this.diceModifier>0)}get hasPenalty(){return!!(this.diceModifier&&this.diceModifier<0)}get hasModifier(){return!(!this.diceModifier||0===this.diceModifier)}get diceModifier(){return this._diceModifier?this._diceModifier:null}set diceModifier(x){this._diceModifier=parseInt(x)}get name(){if(this.actor){if(this.skill)return this.skill.shortName;if(this.item)return this.item.name;if(this.characteristic)return CoC7Utilities.getCharacteristicNames(this.characteristic)?.label;if(this.attribute){if("lck"===this.attribute)return game.i18n.localize("CoC7.Luck");if("san"===this.attribute)return game.i18n.localize("CoC7.Sanity")}}return null}get shortName(){if(this.actor){if(this.skill)return this.skill.shortName;if(this.item)return this.item.name;if(this.characteristic)return CoC7Utilities.getCharacteristicNames(this.characteristic)?.short;if(this.attribute){if("lck"===this.attribute)return game.i18n.localize("CoC7.Luck");if("san"===this.attribute)return game.i18n.localize("CoC7.SAN")}}return null}get fullName(){const difficulty=this._difficulty!==CoC7Check.difficultyLevel.regular&&CoC7Check.difficultyString(this._difficulty),modifier=this._diceModifier>0?`+${this._diceModifier}`:this._diceModifier.toString();return game.i18n.format(`CoC7.LinkCheck${difficulty?"Diff":""}${this._diceModifier?"Modif":""}`,{difficulty,modifier,name:this.name})}get rolled(){return!!this.dice}static getFromCard(card){const rollResult=card.classList.contains("roll-result")?card:card.querySelector(".roll-result"),check=new CoC7Check;CoC7Roll.getFromElement(rollResult,check);const message=card.closest(".message");return check.messageId=message?message.dataset.messageId:null,check}static async push(card,publish=!0){const oldCheck=CoC7Check.getFromCard(card),actorId=card.dataset.tokenId?card.dataset.tokenId:card.dataset.actorId,skillId=card.dataset.skillId,charac=card.dataset.characteristic,itemId=card.dataset.itemId,diceMod=card.dataset.diceMod,difficulty=card.dataset.difficulty;let pushedRoll;if(skillId)pushedRoll=new CoC7Check(actorId,skillId,itemId,diceMod,difficulty);else{if(!charac)return;pushedRoll=new CoC7Check,pushedRoll.diceModifier=diceMod,pushedRoll.difficulty=difficulty,pushedRoll.actor=actorId,pushedRoll.characteristic=charac}if(oldCheck.uuid&&(pushedRoll.context=oldCheck.context,pushedRoll.uuid=oldCheck.uuid),oldCheck.parent&&(pushedRoll.parent=oldCheck.parent),pushedRoll.pushing=!0,await pushedRoll.roll(),oldCheck.messageId){const o=await game.messages.get(oldCheck.messageId);void 0!==o.rolls?.[0]?.options?.coc7Result&&(o.rolls[0].options.coc7Result.pushing=!0,await o.update({rolls:o.rolls}))}publish&&pushedRoll.toMessage(!0,card)}get token(){return this.actor?chatHelper.getTokenFromKey(this.actorKey):null}set actor(x){if(this.actorKey=x,null!=x){if(x instanceof Actor)return this._actor=x,this._actor.alias=this.actor.name,void(x.token&&x.token.scene&&x.token.scene.id?this.actorKey=`${x.token.scene.id}.${x.token.id}`:this.actorKey=x.id);if(x.includes(".")){const[sceneId,tokenId]=x.split(".");if("TOKEN"===sceneId)this._actor=game.actors.tokens[tokenId],this._actor.alias=this._actor.name;else{const scene=game.scenes.get(sceneId);if(!scene)return;const tokenData=scene.getEmbeddedDocument("Token",tokenId);if(!tokenData)return;const token=new Token(tokenData);this._actor=token.actor,this._actor.alias=token.name}}else this._actor=game.actors.get(x),this.actor.alias=this.actor.name}else this._actor=x}get successLevelIcons(){if(this.unknownDifficulty)return null;if(this.isSimpleRoll&&0!==this._rawValue)return null;if(this.successLevel>=this.difficulty){const icons=[];for(let index=0;index<this.successLevel-this.difficulty+1;index++)icons.push(this.isCritical?"medal":"star");const successHint=game.i18n.format("CoC7.SuccesLevelHint",{value:this.successLevel-this.difficulty+1});return{success:!0,cssClass:this.isCritical?"critical":"success",hint:successHint,icons}}{const icons=[],successLevel=this.isFumble?-1:this.successLevel;for(let index=0;index<this.difficulty-successLevel;index++)icons.push(this.isFumble?"skull":"spider");const failureHint=game.i18n.format("CoC7.FailureLevelHint",{value:this.difficulty-successLevel});return{success:!1,cssClass:this.isFumble?"fumble":"failure",hint:failureHint,icons}}}get isBlind(){return void 0===this._isBlind&&(this._isBlind="blindroll"===this.rollMode),this._isBlind}set isBlind(x){this._isBlind=x}get unknownDifficulty(){return!(this.gmDifficultyCritical||this.gmDifficultyExtreme||this.gmDifficultyHard||this.gmDifficultyRegular)&&CoC7Check.difficultyLevel.unknown===this.difficulty}get rollMode(){return this._rollMode||(this._rollMode=game.settings.get("core","rollMode")),this._rollMode}set rollMode(x){!1===x&&(this._rollMode=game.settings.get("core","rollMode")),this._rollMode=x}set skill(x){this._skill=this._getItemFromId(x),this.skillId=x}set item(x){this._item=this._getItemFromId(x),"weapon"===this._item?.type?this.itemId=x:(this._item=void 0,this.itemId=void 0)}_getItemFromId(x){return null==x?null:x instanceof Item?x:this._actor?this._actor.items.get(x):game.items.get(x)}get actor(){if(this._actor&&this._actor?.id){if("Object"===this._actor.constructor.name){const actor=new CoCActor(this._actor);this._actor=actor}}else if(this.actorKey&&(this._actor=chatHelper.getActorFromKey(this.actorKey)),this.actorId&&(this._actor=chatHelper.getActorFromKey(this.actorId)),!this._actor)return{isDummy:!0,name:this.actorName?this.actorName:void 0,id:void 0,img:"systems/CoC7/assets/icons/question-circle-regular.svg",portrait:"systems/CoC7/assets/icons/question-circle-regular.svg"};return this._actor}get skill(){return!this._skill&&this.skillId&&(this._skill=this.actor?.items.get(this.skillId)),!this._skill&&this.item&&this.item.system.skill&&(this.item.system.skill.main.id&&!this.weaponAltSkill?this._skill=this._actor.items.get(this.item.system.skill.main.id):this.item.system.skill.alternativ.id&&this.weaponAltSkill&&(this._skill=this._actor.items.get(this.item.system.skill.alternativ.id))),this._skill}get item(){return!this._item&&this.itemId&&this.actor&&(this._item=this.actor.items.get(this.itemId)),this._item}get displayResultType(){return game.settings.get("CoC7","displayResultType")}get displayCheckSuccessLevel(){return game.settings.get("CoC7","displayCheckSuccessLevel")}get displayBothSuccessLevel(){return this.displayResultType&&this.displayCheckSuccessLevel}get dontDisplaySuccessLevel(){return!this.displayResultType&&!this.displayCheckSuccessLevel}get image(){return this.skill?this.skill.img:this.item?this.item.img:void 0}get link(){return this.getLinkElement().outerHTML}get displayActorOnCard(){return game.settings.get("CoC7","displayActorOnCard")}getLinkElement(classes=null){const data={cls:["coc7-link","coc7-roll"].concat(classes),dataset:{check:"check"},icon:this.image?`<div style="background-image: url(${this.image})"></div>`:'<i class="fas fa-dice"></i>',blind:this.isBlind},difficulty=CoC7Check.difficultyString(this._difficulty),title=game.i18n.format(`CoC7.LinkCheck${this._difficulty?"Diff":""}${this._diceModifier?"Modif":""}`,{difficulty,modifier:this._diceModifier,name:this.name}),a=document.createElement("a");return a.title=title,a.classList.add(...data.cls),a.innerHTML=`${data.blind?'<i class="fas fa-eye-slash"></i>':""}${data.icon}${this.name}`,a}async roll(diceMod=null,difficulty=null,options={}){diceMod&&(this.diceModifier=diceMod),difficulty&&(this.difficulty=difficulty),this.standby||await this._perform(options)}static createFromActorRollData(rollData){const roll={};switch(rollData.difficulty&&(roll.difficulty=rollData.difficulty),rollData.diceModifier&&(roll.diceModifier=rollData.diceModifier),!0===rollData.denyPush&&(roll.denyPush=!0),rollData.flatDiceModifier&&(roll.flatDiceModifier=rollData.flatDiceModifier),rollData.flatThresholdModifier&&(roll.flatThresholdModifier=rollData.flatThresholdModifier),rollData.actor?.actorKey?roll.actorKey=rollData.actor.actorKey:rollData.actor?.name&&(roll.actorName=rollData.actor.name),rollData.type){case CoC7Check.type.characteristic:roll.characteristic=rollData.value?.key;break;case CoC7Check.type.attribute:roll.attribute=rollData.value?.key;break;case CoC7Check.type.item:roll.actorKey=rollData.value.actor.actorKey,"skill"===rollData.value?.type?roll.skill=rollData.value.id:roll.item=rollData.value.id;break;case CoC7Check.type.skill:roll.actorKey=rollData.value.actor.actorKey,roll.skill=rollData.value.id;break;case CoC7Check.type.value:roll.displayName=rollData.value.name,roll.rawValue=rollData.value.threshold}return CoC7Check.create(roll)}static create({difficulty=CoC7Check.difficultyLevel.regular,diceModifier=null,actorKey=null,characteristic=null,attribute=null,rawValue=0,item=null,skill=null,flatDiceModifier=0,flatThresholdModifier=0,displayName=null,actorName=null,denyPush}={}){const check=new CoC7Check;return check.difficulty=difficulty,!0===denyPush&&(check.denyPush=!0),diceModifier&&(check.diceModifier=diceModifier),flatDiceModifier&&(check.flatDiceModifier=flatDiceModifier),flatThresholdModifier&&(check.flatThresholdModifier=flatThresholdModifier),displayName&&(check.displayName=displayName),actorKey&&(check.actor=actorKey),actorName&&(check.actorName=actorName),isNaN(Number(rawValue))||(check.rawValue=Number(rawValue)),check.actor&&!check.actor.isDummy&&(skill?check.skill=skill:characteristic?check.characteristic=characteristic:attribute?check.attribute=attribute:item&&(check.item=item)),check}async rollCharacteristic(char,diceMod=null,difficulty=null){diceMod&&(this.diceModifier=diceMod),difficulty&&(this.difficulty=difficulty),this.characteristic=char,this.standby||await this._perform()}async rollAttribute(attrib,diceMod=null,difficulty=null){diceMod&&(this.diceModifier=diceMod),difficulty&&(this.difficulty=difficulty),this.attribute=attrib,this.standby||await this._perform()}async rollValue(val,diceMod=null,difficulty=null){diceMod&&(this.diceModifier=diceMod),difficulty&&(this.difficulty=difficulty),this.rawValue=val,this.standby||await this._perform()}get rolledSuccessLevel(){return this.successLevel}async _perform(options={}){this.dice=options.roll||await CoC7Dice.roll(this.diceModifier,this.rollMode,this.isBlind),options.silent||game.modules.get("dice-so-nice")?.active||AudioHelper.play({src:CONFIG.sounds.dice},!0),options.forceDSN&&await CoC7Dice.showRollDice3d(this.dice.roll),this.dices={tens:[],unit:{value:this.dice.unit.total},total:this.dice.total,tenResult:this.dice.total-this.dice.unit.total,hasBonus:!!this.diceModifier,bonus:Math.abs(this.diceModifier),bonusType:this.diceModifier<0?game.i18n.format("CoC7.DiceModifierPenalty"):game.i18n.format("CoC7.DiceModifierBonus"),difficulty:this.difficulty};const max=0===this.dice.unit.total?100:90,min=0===this.dice.unit.total?10:0;let selected=this.dice.total-this.dice.unit.total,firstValue=0===selected?10:Math.floor(selected/10);for(const d of this.dice.roll.dice)d instanceof CONFIG.Dice.terms.t&&(d.results[0].result===firstValue?(firstValue=-1,d.results[0].active=!0):d.results[0].active=!1);this.dice.roll._total=this.dice.total;for(let i=0;i<this.dice.tens.results.length;i++){const die={};die.value=this.dice.tens.results[i],die.value===selected?(selected=101,die.selected=!0,this.dices.hasBonus?(die.isMax=!0,die.isMin=!1):(die.isMin=!0,die.isMax=!1)):(die.value===max?die.isMax=!0:die.isMax=!1,die.value===min?die.isMin=!0:die.isMin=!1),this.dices.tens.push(die)}this.computeCheck()}async increaseLuckSpend(luckAmount){const spendingAmount=parseInt(luckAmount,10);this.totalLuckSpent=parseInt(this.totalLuckSpent??0,10)+spendingAmount;const modifiedResult=Math.max(1,this.modifiedResult-this.totalLuckSpent);1===modifiedResult?this.successLevel=CoC7Check.successLevel.critical:modifiedResult<=this.extremeThreshold?this.successLevel=CoC7Check.successLevel.extreme:modifiedResult<=this.hardThreshold?this.successLevel=CoC7Check.successLevel.hard:modifiedResult<=this.rawValue?this.successLevel=CoC7Check.successLevel.regular:this.fumbleThreshold<=modifiedResult?this.successLevel=CoC7Check.successLevel.fumble:modifiedResult>this.rawValue&&(this.successLevel=CoC7Check.successLevel.failure),this.difficulty<=this.successLevel&&(this.isSuccess=!0,this.isFailure=!1),this.luckSpent=!0;let remove=0;for(let index=0,maxIndex=this.increaseSuccess.length;index<maxIndex;index++)this.increaseSuccess[index].luckToSpend=this.increaseSuccess[index].luckToSpend-spendingAmount,this.increaseSuccess[index].luckToSpend<1&&remove++;for(let index=0;index<remove;index++)this.increaseSuccess.shift();this.computeCheck()}async computeCheck(){switch(this.isUnknown=this.unknownDifficulty,this.gmDifficultyRegular&&(this.difficulty=CoC7Check.difficultyLevel.regular),this.gmDifficultyHard&&(this.difficulty=CoC7Check.difficultyLevel.hard),this.gmDifficultyExtreme&&(this.difficulty=CoC7Check.difficultyLevel.extreme),this.gmDifficultyCritical&&(this.difficulty=CoC7Check.difficultyLevel.critical),this.tenOnlyOneDie=1===this.dices.tens.length,this.isValue=!1,this.isCharactiristic=!1,this.isSkill=!1,this.isItem=!1,this.isAttribute=!1,this.isSimpleRoll?(this.denyPush=!0,this.denyLuck=!0):null==this.actor?this.isValue=!0:(this.characteristic&&(this.isCharactiristic=!0,this.rawValue=this.actor.system.characteristics[this.characteristic].value),this.skill&&(this.isSkill=!0,this.rawValue=this.skill.value),this.attribute&&(this.isAttribute=!0,this.rawValue=this.actor.system.attribs[this.attribute].value)),this.luckSpent||this.isSimpleRoll||(this.modifiedResult<=this.rawValue&&(this.successLevel=CoC7Check.successLevel.regular),this.modifiedResult<=this.hardThreshold&&(this.successLevel=CoC7Check.successLevel.hard),this.modifiedResult<=this.extremeThreshold&&(this.successLevel=CoC7Check.successLevel.extreme),this.modifiedResult>this.rawValue&&(this.successLevel=CoC7Check.successLevel.failure),1===this.modifiedResult&&(this.successLevel=CoC7Check.successLevel.critical),this.fumbleThreshold<=this.modifiedResult&&(this.successLevel=CoC7Check.successLevel.fumble)),this.successLevel){case CoC7Check.successLevel.regular:this.resultType=game.i18n.format("CoC7.RegularSuccess");break;case CoC7Check.successLevel.hard:this.resultType=game.i18n.format("CoC7.HardSuccess");break;case CoC7Check.successLevel.extreme:this.resultType=game.i18n.format("CoC7.ExtremeSuccess");break;case CoC7Check.successLevel.critical:this.resultType=game.i18n.format("CoC7.CriticalSuccess");break;case CoC7Check.successLevel.fumble:this.resultType=game.i18n.format("CoC7.Fumble");break;case CoC7Check.successLevel.failure:this.resultType=game.i18n.format("CoC7.Failure")}if(this.unknownDifficulty?this.successRequired="":this.isSimpleRoll||(this.successRequired=game.i18n.format("CoC7.SuccessRequired",{successRequired:this.difficultyString})),1===this.modifiedResult&&(this.successLevel=CoC7Check.successLevel.critical),this.luckSpent||this.isUnknown||this.isSimpleRoll||(this.isFailure=this.failed,this.isSuccess=this.passed),this.hasMalfunction=!1,this.isFumble&&(this.successLevel=CoC7Check.successLevel.fumble),this.item&&(this.isItem=!0,this.item.system.malfunction&&Number(this.modifiedResult)>=Number(this.item.system.malfunction)&&(this.hasMalfunction=!0,this.malfunctionTxt=game.i18n.format("CoC7.Malfunction",{itemName:this.item.name}),await this.item.toggleItemFlag(CoC7Item.flags.malfunction))),void 0===this.canBePushed&&(this.canBePushed=!!this.skill&&this.skill.canBePushed(),null!=this.characteristic&&(this.canBePushed=!0),this.isFumble&&(this.canBePushed=!1),this.denyPush&&(this.canBePushed=!1)),!this.denyLuck&&this.actor){if(!(this.luckSpent||this.passed||this.isFumble||this.difficulty===CoC7Check.difficultyLevel.critical||this.unknownDifficulty)&&(this.skill||this.characteristic)){const luckNeeded=this.modifiedResult-this.succesThreshold;this.actor.luck>luckNeeded&&(this.hasEnoughLuck=!0,this.luckNeeded=luckNeeded,this.luckNeededTxt=game.i18n.format("CoC7.SpendLuck",{luckNeededValue:luckNeeded}))}if(!this.luckSpent&&(this.increaseSuccess=[],!this.pushing&&"lck"!==this.attribute&&"san"!==this.attribute)){if(this.unknownDifficulty&&this.modifiedResult>this.regularThreshold){const nextLevel={};nextLevel.difficultyName=game.i18n.localize("CoC7.RegularDifficulty"),nextLevel.difficulty=CoC7Check.difficultyLevel.regular,nextLevel.luckToSpend=this.modifiedResult-this.regularThreshold,nextLevel.hasEnoughLuck=nextLevel.luckToSpend<=this.actor.luck,nextLevel.luckToSpend<=this.actor.luck&&this.increaseSuccess.push(nextLevel)}if(this.difficulty<=CoC7Check.difficultyLevel.regular&&this.modifiedResult>this.hardThreshold){const nextLevel={};nextLevel.difficultyName=game.i18n.localize("CoC7.HardDifficulty"),nextLevel.difficulty=CoC7Check.difficultyLevel.hard,nextLevel.luckToSpend=this.modifiedResult-this.hardThreshold,nextLevel.hasEnoughLuck=nextLevel.luckToSpend<=this.actor.luck,nextLevel.luckToSpend<=this.actor.luck&&this.increaseSuccess.push(nextLevel)}if(this.difficulty<=CoC7Check.difficultyLevel.hard&&this.modifiedResult>this.extremeThreshold){const nextLevel={};nextLevel.difficultyName=game.i18n.localize("CoC7.ExtremeDifficulty"),nextLevel.difficulty=CoC7Check.difficultyLevel.extreme,nextLevel.luckToSpend=this.modifiedResult-this.extremeThreshold,nextLevel.hasEnoughLuck=nextLevel.luckToSpend<=this.actor.luck,nextLevel.luckToSpend<=this.actor.luck&&this.increaseSuccess.push(nextLevel)}}this.canIncreaseSuccess=this.increaseSuccess.length>0,this.isFumble&&(this.canIncreaseSuccess=!1)}if(this.dice)this.dice.roll.options.coc7Result={successLevel:Object.keys(CoC7Check.successLevel).find((key=>CoC7Check.successLevel[key]===this.successLevel))??"unknown",difficultySet:!this.isUnknown,passed:this.passed,pushing:!1,pushed:this.pushing,luckSpent:this.totalLuckSpent??0};else if("string"==typeof this.messageId){const o=await game.messages.get(this.messageId);void 0!==o.rolls?.[0]?.options?.coc7Result&&(o.rolls[0].options.coc7Result.luckSpent=this.totalLuckSpent??0,await o.update({rolls:o.rolls}))}if(this.canAwardExperience=this.skill&&!this.skill.system.properties.noxpgain,!(this.passed&&this.diceModifier<=0&&this.skill)||this.skill.system.properties.noxpgain||this.luckSpent||this.forced||this.isBlind||this.isUnknown||this.flagForDevelopement(),this.parent){const parent=await fromUuid(this.parent);parent&&"updateRoll"in parent&&await parent.updateRoll(this.JSONRollString)}}showDiceRoll(){if(game.modules.get("dice-so-nice")?.active){const diceResults=[];for(const dieResult of this.dices.tens)diceResults.push(100===dieResult.value?0:dieResult.value/10);diceResults.push(this.dices.unit.value);const diceData={formula:`${this.dices.tens.length}d100+1d10`,results:diceResults,whisper:null,blind:!1};game.dice3d.show(diceData)}}get cssClass(){let cssClass="";return this.isSuccess&&(cssClass="success"),this.isFailure&&(cssClass="failure"),this.isCritical&&!this.isFailure&&(cssClass="success critical"),this.isFumble&&!this.isSuccess&&(cssClass="failure fumble"),CoC7Check.successLevel.regular===this.successLevel&&(cssClass+=" regular-success"),CoC7Check.successLevel.hard===this.successLevel&&(cssClass+=" hard-success"),CoC7Check.successLevel.extreme===this.successLevel&&(cssClass+=" extreme-success"),cssClass}get cssClassList(){const cssClass=[];return this.isSuccess&&cssClass.push("success"),this.isFailure&&cssClass.push("failure"),this.isCritical&&!this.isFailure&&cssClass.push("success","critical"),this.isFumble&&!this.isSuccess&&cssClass.push("failure","fumble"),CoC7Check.successLevel.regular===this.successLevel&&cssClass.push("regular-success"),CoC7Check.successLevel.hard===this.successLevel&&cssClass.push("hard-success"),CoC7Check.successLevel.extreme===this.successLevel&&cssClass.push("extreme-success"),cssClass}get playerCssClass(){return this.isSuccess||this.forcedSuccess?"success":this.isFailure||this.forcedFailure?"failure":null}async upgradeCheck(upgradeindex,update=!0){const increasedSuccess=this.increaseSuccess[upgradeindex],luckAmount=parseInt(increasedSuccess.luckAmount)||parseInt(increasedSuccess.luckToSpend);if(!this.actor.spendLuck(luckAmount))return void ui.notifications.error(game.i18n.format("CoC7.ErrorNotEnoughLuck",{actor:this.actor.name}));this.totalLuckSpent=parseInt(this.totalLuckSpent)?parseInt(this.totalLuckSpent):0,this.totalLuckSpent+=parseInt(luckAmount);const newSuccessLevel=parseInt(increasedSuccess.newSuccessLevel)||parseInt(increasedSuccess.difficulty);this.successLevel=newSuccessLevel,this.difficulty<=newSuccessLevel&&(this.isSuccess=!0,this.isFailure=!1);for(let index=0;index<upgradeindex+1;index++)this.increaseSuccess.shift();for(const s of this.increaseSuccess)s.luckToSpend=s.luckToSpend-luckAmount;return this.luckSpent=!0,this.computeCheck(),update?await this.updateChatCard():void 0}removeUpgrades(){this.canIncreaseSuccess=!1,this.increaseSuccess=[],this.luckNeeded=0,this.luckNeededTxt=null,this.canBePushed=!1}forcePass(luckAmount=null,update=!0){if(luckAmount){this.actor.spendLuck(luckAmount),this.successLevel=this.difficulty;for(const s of this.increaseSuccess)s.luckToSpend=s.luckToSpend-luckAmount;this.luckSpent=!0,this.isSuccess=!0,this.isFailure=!1,this.totalLuckSpent=parseInt(this.totalLuckSpent)?parseInt(this.totalLuckSpent):0,this.totalLuckSpent+=parseInt(luckAmount),this.computeCheck(),update&&this.updateChatCard()}else this.forced=!0,this.forcedSuccess=!0,this.isUnknown?this.forceSuccessLevel(CoC7Check.successLevel.regular,update):this.forceSuccessLevel(this.difficulty,update)}forceFail(update=!0){this.forced=!0,this.forcedFailure=!0,this.isUnknown?this.forceSuccessLevel(CoC7Check.successLevel.failure,update):this.forceSuccessLevel(this.difficulty-1,update)}_forceCheck(high,low,update=!0){let total=Math.floor(Math.random()*(high-low))+low+1;const unitTotal=total%10;let tenTotal=Math.floor(total/10);const tens=[];let hasEnough=Math.abs(this.diceModifier)===tens.length;for(;!hasEnough;){let ten=Math.floor(10*Math.random()),roll=10*ten+unitTotal;0===roll&&(roll=100,ten=100),this.hasPenalty&&roll<=high&&(tens.push(ten),roll>total&&(total=roll)),this.hasBonus&&roll>low&&(tens.push(ten),roll<total&&(total=roll)),hasEnough=tens.length===Math.abs(this.diceModifier)}10===tenTotal&&0===unitTotal&&(tenTotal=100),tens.splice(Math.floor(Math.random()*tens.length+1),0,10===tenTotal?0:tenTotal),this.dices.tens=[],this.dices.unit.value=unitTotal,this.modifiedResult=total,this.dices.total=total,this.dices.tenResult=total-unitTotal;const max=0===unitTotal?100:90,min=0===unitTotal?10:0;let selected=total-unitTotal;for(let i=0;i<tens.length;i++){const die={};die.value=tens[i],die.value===selected?(selected=101,die.selected=!0,this.hasBonus?(die.isMax=!0,die.isMin=!1):(die.isMin=!0,die.isMax=!1)):(die.value===max?die.isMax=!0:die.isMax=!1,die.value===min?die.isMin=!0:die.isMin=!1),this.dices.tens.push(die)}this.computeCheck(),update&&this.updateChatCard()}forceSuccessLevel(successLevel,update=!0){let high,low;CoC7Check.successLevel.fumble===successLevel&&(high=100,low=this.fumbleThreshold-1),CoC7Check.successLevel.failure===successLevel&&(high=this.regularThreshold===this.fumbleThreshold-1?100:this.fumbleThreshold-1,low=this.regularThreshold),CoC7Check.successLevel.regular===successLevel&&(high=this.regularThreshold,low=this.hardThreshold),CoC7Check.successLevel.hard===successLevel&&(high=this.hardThreshold,low=this.extremeThreshold),CoC7Check.successLevel.extreme===successLevel&&(high=this.extremeThreshold,low=1),CoC7Check.successLevel.critical===successLevel&&(high=1,low=0),high===low&&low--,0===high&&(high=this.fumbleThreshold-1),this._forceCheck(high,low,update)}increaseSuccessLevel(update=!0){let high,low;CoC7Check.successLevel.fumble===this.successLevel&&(high=this.fumbleThreshold-1,low=this.regularThreshold===this.fumbleThreshold-1?this.hardThreshold:this.regularThreshold),CoC7Check.successLevel.failure===this.successLevel&&(high=this.regularThreshold,low=this.hardThreshold),CoC7Check.successLevel.regular===this.successLevel&&(high=this.hardThreshold,low=this.extremeThreshold),CoC7Check.successLevel.hard===this.successLevel&&(high=this.extremeThreshold,low=this.criticalThreshold),CoC7Check.successLevel.extreme===this.successLevel&&(high=this.criticalThreshold,low=0),high===low&&low--,this._forceCheck(high,low,update)}decreaseSuccessLevel(update=!0){let high,low;CoC7Check.successLevel.failure===this.successLevel&&(high=100,low=this.fumbleThreshold-1),CoC7Check.successLevel.regular===this.successLevel&&(high=this.fumbleThreshold-1,low=this.regularThreshold),CoC7Check.successLevel.hard===this.successLevel&&(high=this.regularThreshold,low=this.hardThreshold),CoC7Check.successLevel.extreme===this.successLevel&&(high=this.hardThreshold,low=this.extremeThreshold),CoC7Check.successLevel.critical===this.successLevel&&(high=this.extremeThreshold,low=1),0===high&&(high=this.fumbleThreshold-1),this._forceCheck(high,low,update)}async flagForDevelopement(){this.flaggedForDevelopment=!0,this.skill&&await this.skill.flagForDevelopement()}set difficulty(x){this._difficulty=parseInt(x)}get difficulty(){return this._difficulty}set flavor(x){this._flavor=x}set context(x){this._context=x}get context(){if(this._context)return this._context}set parent(x){this.uuid||(this.uuid=foundry.utils.randomID(16)),this.parentUuid=x}get parent(){if(this.parentUuid)return this.parentUuid}get flavor(){if(this._flavor)return this._flavor;let flavor="";return this.actor?.system&&(this.skill?flavor=game.i18n.format("CoC7.CheckResult",{name:this.skill.name,value:this.rawValueString,difficulty:this.difficultyString}):this.item?flavor=game.i18n.format("CoC7.ItemCheckResult",{item:this.item.name,skill:this.skill.name,value:this.rawValueString,difficulty:this.difficultyString}):this.characteristic?flavor=game.i18n.format("CoC7.CheckResult",{name:game.i18n.format(this.actor.system.characteristics[this.characteristic].label),value:this.rawValueString,difficulty:this.difficultyString}):this.attribute?flavor=game.i18n.format("CoC7.CheckResult",{name:game.i18n.format(`CoC7.${this.actor.system.attribs[this.attribute].label}`),value:this.rawValueString,difficulty:this.difficultyString}):this.displayName&&(flavor=game.i18n.format("CoC7.CheckResult",{name:this.displayName,value:this.rawValueString,difficulty:this.difficultyString}))),flavor||this.rawValue&&(flavor=this.displayName?game.i18n.format("CoC7.CheckResult",{name:this.displayName,value:this.rawValueString,difficulty:this.difficultyString}):game.i18n.format("CoC7.CheckRawValue",{rawvalue:this.rawValue,difficulty:this.difficultyString})),this.pushing&&(flavor=`${game.i18n.format("CoC7.Pushing")} ${flavor}`),flavor}get tooltipHeader(){return this.attribute?game.i18n.format(`CoC7.LinkCheck${this.difficulty===CoC7Check.difficultyLevel.regular?"":"Diff"}${this.diceModifier?"Modif":""}`,{difficulty:this.difficultyString,modifier:this.diceModifier,name:game.i18n.format(`CoC7.${this.actor.system.attribs[this.attribute].label}`)})+` (${this.actor.system.attribs[this.attribute].value}%)`:this.characteristic?game.i18n.format(`CoC7.LinkCheck${this.difficulty===CoC7Check.difficultyLevel.regular?"":"Diff"}${this.diceModifier?"Modif":""}`,{difficulty:this.difficultyString,modifier:this.diceModifier,name:game.i18n.localize(this.actor.system.characteristics[this.characteristic].label)})+` (${this.actor.system.characteristics[this.characteristic].value}%)`:this.skill?game.i18n.format(`CoC7.LinkCheck${this.difficulty===CoC7Check.difficultyLevel.regular?"":"Diff"}${this.diceModifier?"Modif":""}`,{difficulty:this.difficultyString,modifier:this.diceModifier,name:this.skill.name})+` (${this.skill.value}%)`:this.displayName?game.i18n.format(`CoC7.LinkCheck${this.difficulty===CoC7Check.difficultyLevel.regular?"":"Diff"}${this.diceModifier?"Modif":""}`,{difficulty:this.difficultyString,modifier:this.diceModifier,name:this.displayName})+` (${this.rawValueString}%)`:null}async getHtmlRollElement(options={}){this.options?this.options=foundry.utils.mergeObject(this.options,options):this.options=options;const html=await renderTemplate("systems/CoC7/templates/chat/rolls/in-card-roll.html",this);return html?$.parseHTML(html)[0]:null}async getHtmlRoll(options={}){this.options?this.options=foundry.utils.mergeObject(this.options,options):this.options=options;return await renderTemplate("systems/CoC7/templates/chat/rolls/in-card-roll.html",this)||void 0}async toMessage(pushing=!1){this.pushing=pushing;const html=await renderTemplate("systems/CoC7/templates/chat/roll-result.html",this),speakerData={};let speaker;this.actor?(this.actor.isToken?speakerData.token=this.token.document:this.actor.isDummy?this.actor.name&&(speaker={alias:this.actor.name}):speakerData.actor=this.actor,speaker=ChatMessage.getSpeaker(speakerData)):speaker=ChatMessage.getSpeaker();const chatData={user:(this.actor?.user?this.actor.user:game.user).id,speaker,flavor:this.flavor,content:html,flags:{CoC7:{type:CoC7Check.cardType}}};if(this.uuid&&(chatData.flags.CoC7.uuid=this.uuid),this.context&&(chatData.flags.CoC7.context=this.context),"selfroll"===this.rollMode)if(game.user.isGM){if(chatData.user=game.user.id,chatData.flavor=`[${this.actor.name}] ${chatData.flavor}`,chatData.flags={CoC7:{GMSelfRoll:!0}},void 0!==chatData.speaker&&(chatData.flags.CoC7.originalSpeaker=foundry.utils.duplicate(chatData.speaker)),game.user.isGM)switch(game.settings.get("CoC7","selfRollWhisperTarget")){case"owners":delete chatData.speaker,chatData.whisper=this.actor.owners,chatData.type=CONST.CHAT_MESSAGE_TYPES.WHISPER;break;case"everyone":delete chatData.speaker,chatData.whisper=game.users.players,chatData.type=CONST.CHAT_MESSAGE_TYPES.WHISPER;break;default:ChatMessage.applyRollMode(chatData,this.rollMode)}}else ChatMessage.applyRollMode(chatData,this.rollMode);["gmroll","blindroll"].includes(this.rollMode)&&(chatData.whisper=ChatMessage.getWhisperRecipients("GM")),"blindroll"===this.rollMode&&(chatData.blind=!0),this.dice?.roll&&!this.dice?.hideDice&&(chatData.rolls=[this.dice.roll],chatData.type=CONST.CHAT_MESSAGE_TYPES.ROLL,chatData.rollMode=this.isBlind?"blindroll":this.rollMode),ChatMessage.create(chatData).then((msg=>msg))}async updateChatCard({makePublic=!1,forceRoll=!1}={}){makePublic&&(this.rollMode=!1);const chatData={flavor:this.flavor};makePublic&&(chatData.whisper=[],chatData.blind=!1,ChatMessage.applyRollMode(chatData)),chatData.blind&&(this.isBlind=!0);const html=await renderTemplate("systems/CoC7/templates/chat/roll-result.html",this);let newContent=html;if(!this.messageId)return $.parseHTML(html)[0];const message=game.messages.get(this.messageId),htmlMessage=$.parseHTML(message.content)[0];if(!htmlMessage.classList.contains("roll-result")){const htmlCheck=$.parseHTML(html)[0],rollResultElement=htmlMessage.querySelector(".roll-result");null!==rollResultElement&&rollResultElement.replaceWith(htmlCheck),newContent=htmlMessage.outerHTML}chatData.content=newContent,CONST.CHAT_MESSAGE_TYPES.ROLL===message.type&&(message.whisper?.length?chatData.type=CONST.CHAT_MESSAGE_TYPES.WHISPER:chatData.type=CONST.CHAT_MESSAGE_TYPES.OTHER),forceRoll&&this.dice?.roll&&(game.user.isGM||!this.isBlind)&&await CoC7Dice.showRollDice3d(this.dice.roll);const msg=await message.update(chatData);return await ui.chat.updateMessage(msg,!1),msg}static async updateCardSwitch(event){const card=event.currentTarget.closest(".chat-card"),check=await CoC7Check.getFromCard(card);check.gmDifficultyRegular=!1,check.gmDifficultyHard=!1,check.gmDifficultyExtreme=!1,check.gmDifficultyCritical=!1,"gmDifficultyRegular"===event.currentTarget.dataset.flag&&(check.gmDifficultyRegular=!0),"gmDifficultyHard"===event.currentTarget.dataset.flag&&(check.gmDifficultyHard=!0),"gmDifficultyExtreme"===event.currentTarget.dataset.flag&&(check.gmDifficultyExtreme=!0),"gmDifficultyCritical"===event.currentTarget.dataset.flag&&(check.gmDifficultyCritical=!0),check.computeCheck(),check.updateChatCard()}get tooltip(){return renderTemplate("systems/CoC7/templates/chat/rolls/roll-tooltip.html",this)}get inlineCheck(){const a=document.createElement("a");return a.classList.add("coc7-inline-check"),a.classList.add("coc7-check-result"),a.classList.add("coc7-inline"),a.classList.add(...this.cssClassList),a.title=this.tooltipHeader,a.dataset.roll=escape(this.JSONRollString),a.innerHTML=`<i class="game-icon game-icon-d10"></i> ${this.modifiedResult||"??"}`,a}get rollToolTip(){if(this.standby)return;const parts=[],tens=this.dices.tens.map((r=>({result:r.value,selected:r.selected,classes:["die","d10",r.selected?null:"discarded",r.isMin?"min":null,r.isMax?"max":null].filter((c=>c)).join(" ")}))),unit=[{result:this.dices.unit.value,selected:!0,classes:"die d10"}];return parts.push({formula:this.tooltipHeader,total:this.modifiedResult,icons:this.successLevelIcons,class:this.cssClass,successRequired:this.successRequired,resultType:this.resultType,face:10,rolls:[...tens,...unit]}),renderTemplate("systems/CoC7/templates/chat/rolls/roll-tooltip.html",{parts})}get JSONRollData(){return JSON.parse(this.JSONRollString)}get JSONRollString(){return JSON.stringify(this,((key,value)=>{if(null===value)return;return["_actor","_skill","_item"].includes(key)?void 0:value}))}static fromData(data){return Object.assign(new CoC7Check,data)}static fromRollString(dataString){let data;try{data=JSON.parse(unescape(dataString))}catch(err){return ui.notifications.error(err.message),null}return CoC7Check.fromData(data)}static async alter(check,command,options={}){switch(command){case"useLuck":if(options.target.classList.contains("pass-check")){const luckAmount=parseInt(options.target.dataset.luckAmount);check.forcePass(luckAmount,options.update)}else{const upgradeIndex=parseInt(options.target.dataset.index);await check.upgradeCheck(upgradeIndex,options.update)}break;case"force-pass":check.forcePass(null,options.update);break;case"force-fail":check.forceFail(options.update);break;case"increase-success-level":check.increaseSuccessLevel(options.update);break;case"decrease-success-level":check.decreaseSuccessLevel(options.update);break;case"reveal-check":check.isBlind=!1,check.rollMode=!1,check.computeCheck(),options.update&&check.updateChatCard();break;case"flag-for-development":await check.flagForDevelopement(),check.computeCheck(),options.update&&check.updateChatCard();break;case"push":await check._perform(),check.pushing=!0,options.update&&check.updateChatCard()}}static async _onClickInlineRoll(event){event.preventDefault();const a=event.currentTarget;if(a.classList.contains("coc7-check-result"))return a.classList.contains("expanded")?CoC7Check._collapseInlineResult(a):CoC7Check._expandInlineResult(a)}static _collapseInlineResult(a){if(!a.classList.contains("coc7-inline-check"))return;if(!a.classList.contains("expanded"))return;const tooltip=a.querySelector(".coc7-check-tooltip");return tooltip&&tooltip.remove(),a.classList.remove("expanded")}static async _expandInlineResult(a){if(!a.classList.contains("coc7-inline-check"))return;if(a.classList.contains("expanded"))return;const check=Object.assign(new CoC7Check,JSON.parse(unescape(a.dataset.roll)));if(check.standby)return;const tip=document.createElement("div");tip.innerHTML=await check.rollToolTip;const tooltip=tip.children[0];a.appendChild(tooltip),a.classList.add("expanded");const pa=a.getBoundingClientRect(),pt=tooltip.getBoundingClientRect();tooltip.style.left=`${Math.min(pa.x,window.innerWidth-(pt.width+3))}px`,tooltip.style.top=`${Math.min(pa.y+pa.height+3,window.innerHeight-(pt.height+3))}px`;const zi=getComputedStyle(a).zIndex;tooltip.style.zIndex=Number.isNumeric(zi)?zi+1:100}}class _participant{constructor(data={}){this.data=data}_fetch(){if(!this._doc&&this.data.docUuid&&(this._doc=CoC7Utilities.getDocumentFromKey(this.data.docUuid)),!this._actor)if(this._doc)switch(this._doc.constructor?.name){case"TokenDocument":this._actor=this._doc.actor;break;case"CoCActor":this._actor=this._doc}else this._actor=CoC7Utilities.getActorFromKey(this.data.docUuid)}get actor(){return this._fetch(),this._actor}get isActor(){return this.hasActor||this.hasVehicle}get isActive(){return this.data.active||!1}get key(){return this.hasVehicle?this.vehicle.actorKey:this.hasActor?this.actor.actorKey:void 0}get icon(){return this.isActor?this.hasVehicle?this.vehicle.img:this.hasActor?this.actor.img:void 0:"systems/CoC7/assets/icons/question-circle-regular.svg"}get driver(){return this._driver||(this._driver=CoC7Utilities.getActorFromKey(this.data.docUuid)),this._driver}get vehicle(){return this.data.vehicleKey&&(this._vehicle=chatHelper.getActorFromKey(this.data.vehicleKey)),this._vehicle}get hasActor(){return!!this.actor}get hasVehicle(){return!!this.vehicle}get name(){return this.hasVehicle?this.vehicle.name:this.hasActor?this.actor.name:this.data.name||void 0}get mov(){return this.data.mov||(this.hasVehicle?this.data.mov=this.vehicle.mov:this.hasActor&&(this.data.mov=this.actor.mov)),this.data.mov&&(isNaN(Number(this.data.mov))?(this.data.hasValidMov=!1,this.data.mov=void 0):this.data.hasValidMov=!0),this.data.mov}get uuid(){return this.data.uuid}get hasMaxBonusDice(){return this.bonusDice>=2}get bonusDice(){return isNaN(this.data.bonusDice)||this.data.bonusDice<0||this.data.bonusDice>2?0:this.data.bonusDice}set bonusDice(x){isNaN(x)?ui.notifications.error("Bonus dice can Only be a number"):x>2?ui.notifications.error("Max 2 bonus dice"):x<0?ui.notifications.error("No negativ bonus dice"):this.data.bonusDice=x}get hp(){return this.data.hp||(this.data.hp=0),this.actor&&(this.data.hp=this.actor.hp),this.data.hp}set hp(x){this.data.hp=x,this.actor&&this.actor.setHp(x)}addBonusDice(){this.data.bonusDice>=2?ui.notifications.error("Already have max bonus dice"):this.data.bonusDice+=1}removeBonusDice(){this.data.bonusDice<=0?ui.notifications.error("Already have 0 bonus dice"):this.data.bonusDice-=1}resetBonusDice(){this.data.bonusDice=0}get hasBonusDice(){return this.hasOneBonusDice||this.hasTwoBonusDice}get hasOneBonusDice(){return this.bonusDice>=1}get hasTwoBonusDice(){return this.bonusDice>=2}get canAssist(){return this.assist?.length>0}get canBeCautious(){return!this.hasMaxBonusDice}get assist(){return this.data.assist||[]}get dex(){return this.data.dex||(this.hasVehicle&&this.hasDriver?this.data.dex=this.driver.characteristics.dex.value:this.hasActor&&(this.data.dex=this.actor.characteristics.dex.value)),this.data.dex&&(isNaN(Number(this.data.dex))?(this.data.hasValidDex=!1,this.data.dex=0):this.data.hasValidDex=!0),this.data.dex}get hasAGunReady(){return this.data.hasAGunReady||!1}get initiative(){let init=this.dex;return this.hasAGunReady&&(init+=50),init}get isChaser(){return!!this.data.chaser}get isPrey(){return!this.isChaser}get isValid(){return this.hasValidDex&&this.hasValidMov}get hasValidDex(){return!isNaN(Number(this.data.dex))}get hasValidMov(){return!isNaN(Number(this.data.mov))}get hasDriver(){return this.hasVehicle&&this.hasActor}get movAdjustment(){if(this.data.speedCheck?.rollDataString){const roll=CoC7Check.fromRollString(this.data.speedCheck.rollDataString);if(roll&&!roll.standby){if(roll.successLevel>=CoC7Check.successLevel.extreme)return 1;if(roll.failed)return-1}}return 0}get adjustedMov(){if(void 0!==this.mov&&!isNaN(Number(this.mov)))return Number(this.mov)+this.movAdjustment}get hasMovAdjustment(){return this.hasBonusMov||this.hasMalusMov}get hasBonusMov(){return this.data.movAdjustment>0}get hasMalusMov(){return this.data.movAdjustment<0}tooSlow(){this.data.excluded=!0}includeInChase(){this.data.excluded=!1,this.data.escaped=!1}escaped(){this.data.escaped=!0}set slowest(x){this.data.slowest=x}get slowest(){return this.data.slowest}set fastest(x){this.data.fastest=x}get fastest(){return this.data.fastest}calculateMovementActions(minMov){void 0===this.movementAction||void 0===this.adjustedMov||isNaN(minMov)?this.movementAction=0:this.movementAction=this.adjustedMov-minMov+1}set movementAction(x){this.data.movementAction=x}get movementAction(){return this.data.movementAction}set currentMovementActions(x){this.data.currentMovementActions=x}get currentMovementActions(){return this.data.currentMovementActions||0}get hasMaxMvtActions(){return this.currentMovementActions>=this.movementAction}get hasNoMvtActions(){return this.currentMovementActions<=0}addMovementActions(x=1){this.currentMovementActions+=x,this.currentMovementActions>this.movementAction&&(this.currentMovementActions=this.movementAction)}alterMovementActions(x){this.currentMovementActions+=x,this.currentMovementActions>this.movementAction&&(this.currentMovementActions=this.movementAction)}get movementActionArray(){const baseArray=Array(this.movementAction).fill("base");if(this.currentMovementActions>=0){for(let i=0;i<this.currentMovementActions;i++)baseArray[i]="base available";return baseArray}if(this.currentMovementActions<0){return Array(Math.abs(this.currentMovementActions)).fill("deficit").concat(baseArray)}}get cssClass(){const cssClasses=[];return this.isChaser?cssClasses.push("chaser"):cssClasses.push("prey"),this.data.excluded&&cssClasses.push("excluded","too_slow"),this.data.escaped&&cssClasses.push("escaped"),this.data.fastest&&cssClasses.push("fastest"),this.data.slowest&&cssClasses.push("slowest"),this.data.active&&cssClasses.push("active"),this.data.currentMovementActions<=0&&cssClasses.push("no-actions"),cssClasses.join(" ")}get speedCheck(){const check={};if(this.data.speedCheck?.name&&(check.name=this.data.speedCheck.name),this.data.speedCheck?.score&&(check.score=this.data.speedCheck.score),check.cssClasses="",this.data.speedCheck?.rollDataString&&(check.roll=CoC7Check.fromRollString(this.data.speedCheck.rollDataString),check.roll&&(check.roll.standby&&!check.roll.hasCard||(check.rolled=!0,check.inlineRoll=check.roll.inlineCheck.outerHTML,check.cssClasses+="rolled",check.roll.standby||(check.roll.successLevel>=CoC7Check.successLevel.extreme?check.modifierCss="upgrade":check.roll.failed&&(check.modifierCss="downgrade"),(check.roll.successLevel>=CoC7Check.successLevel.extreme||check.roll.failed)&&(check.hasModifier=!0))))),this.hasActor){check.options=[];for(const c of["con"]){const characteristic=this.actor.getCharacteristic(c);characteristic?.value&&check.options.push(characteristic.label)}for(const s of this.actor.driveSkills)check.options.push(s.name);for(const s of this.actor.pilotSkills)check.options.push(s.name);if(check.hasOptions=!!check.options.length,this.data.speedCheck?.id){let item=this.actor.find(this.data.speedCheck.id);if(!item){const gameItem=game.items.get(this.data.speedCheck.id);gameItem&&(item=this.actor.find(gameItem.name))}item&&("item"===item.type&&"skill"===item.value.data?.type&&(check.ref=item.value,check.name=item.value.name,check.type="skill",check.isSkill=!0,check.refSet=!0,check.score=item.value.value),"characteristic"===item.type&&(check.ref=item.value,check.name=item.value.label,check.type="characteristic",check.isCharacteristic=!0,check.refSet=!0,check.score=item.value.value),"attribute"===item.type&&(check.ref=item.value,check.name=item.value.label,check.type="attribute",check.isAttribute=!0,check.refSet=!0,check.score=item.value.value))}else if(this.data.speedCheck?.name){const item=this.actor.find(this.data.speedCheck.name);item&&("item"===item.type&&"skill"===item.value.data?.type&&(check.ref=item.value,check.name=item.value.name,check.type="skill",check.isSkill=!0,check.refSet=!0,check.score=item.value.value),"characteristic"===item.type&&(check.ref=item.value,check.name=item.value.label,check.type="characteristic",check.isCharacteristic=!0,check.refSet=!0,check.score=item.value.value),"attribute"===item.type&&(check.ref=item.value,check.name=item.value.label,check.type="attribute",check.isAttribute=!0,check.refSet=!0,check.score=item.value.value))}}else if(this.data.speedCheck?.id){const item=game.items.get(this.data.speedCheck.id);item&&"skill"===item.data?.type&&(check.ref=item,check.name=item.name,check.type="skill",check.isSkill=!0,check.refSet=!1,check.score=item.base)}else this.data.speedCheck?.name&&this.data.speedCheck?.score&&(check.name=this.data.speedCheck.name,check.score=this.data.speedCheck.score,check.refSet=!1);return check.canBeRolled=!0,check.rolled||check.score||(check.cssClasses+=" invalid",check.canBeRolled=!1),check.isValid=check.rolled&&!isNaN(check.score),check}}function sortByRoleAndDex(a,b){return!a&&b?1:!b&&a?-1:a||b?b.chaser&&!a.chaser?1:a.chaser&&!b.chaser?-1:a.dex-b.dex:0}class ChaseObstacleCard extends EnhancedChatCard{static get defaultOptions(){const options=foundry.utils.mergeObject(super.defaultOptions,{template:"systems/CoC7/templates/chat/cards/chase-obstacle.html",GMUpdate:!0});return options.classes.push("obstacle-card"),options}async getData(){const data=await super.getData();if(data.status=[],data.strings={},data.displayActorOnCard=game.settings.get("CoC7","displayActorOnCard"),data.status.push({name:game.i18n.localize("CoC7.ActionCost")+` :${this.data.totalActionCost}`}),data.card.breakableObstacle=data.data.obstacle?.barrier&&data.data.obstacle.hasHitPoints,data.card.validCheck=!1,data.data.states?.obstacleDefined&&(data.data.obstacle.hazard||data.data.obstacle.barrier&&!data.data.obstacle.hasHitPoints)&&(data.data.states.tryToNegotiate=!0,data.data.states.tryToBreak=!1,data.data.states.breakOrNegotiateDefined=!0),this.participant?.actor?(data.skill=this.participant.actor.find(data.data.obstacle.checkName),data.checkOptions=this.chase.getActorSkillsAndCharacteristics(this.data.participantUuid),data.skill?(data.validCheck=!0,data.validSkill=!0):data.data.obstacle.checkName&&data.data.checkThreshold&&(data.validCheck=!0)):(data.checkOptions=this.chase.allSkillsAndCharacteristics,data.dummyActor=!0,data.data.obstacle.checkName&&data.data.checkThreshold&&(data.validCheck=!0)),data.data.bonusDice||(data.data.bonusDice=0),data.data.bonusDice<2&&data.data.totalActionCost<data.data.movementAction&&(data.canTakeCautiousApproach=!0),data.customWeapon=!1,"0"===this.data.weaponChoice&&(data.customWeapon=!0),data.validCheck){let checkName,value;data.skill?(checkName=data.skill.value.name,value=data.skill.value.value):(checkName=data.data.obstacle.checkName,value=data.data.checkThreshold),data.strings.checkRollRequest=game.i18n.format("CoC7.AskRoll",{name:checkName,value}),0!==data.data.bonusDice&&(data.data.bonusDice>0?data.strings.checkRollRequest+=` (+${data.data.bonusDice})`:data.strings.checkRollRequest+=` (${data.data.bonusDice})`)}if(data.data.states?.obstacleDefined){if(data.strings.obstacleDefined=game.i18n.format("CoC7.FacingObstacle",{type:data.data.obstacle.barrier?game.i18n.localize("CoC7.ABarrier"):game.i18n.localize("CoC7.AHazard")}),data.data.obstacle.name&&(data.strings.obstacleDefined+=` (${data.data.obstacle.name})`),data.data.states.canAskRoll=!0,data.data.obstacle.barrier&&(data.status.push({name:game.i18n.localize("CoC7.Barrier")}),data.data.obstacle.hasHitPoints&&data.status.push({name:game.i18n.localize("CoC7.Breakable")})),data.data.obstacle.hazard&&data.status.push({name:game.i18n.localize("CoC7.Hazard")}),this.data.states.tryToNegotiate&&(data.validCheck?data.validSkill||data.status.push({name:game.i18n.localize("CoC7.NoValidSkill"),css:"warning"}):(data.status.push({name:game.i18n.localize("CoC7.NoValidCheck"),css:"error"}),data.strings.EnterValueTitle=game.i18n.format("CoC7.SkillSelectBase",{name:data.data.obstacle.checkName}),data.data.checkThreshold||(data.data.states.canAskRoll=!1))),this.data.states.tryToBreak){let damageStatus=game.i18n.localize("CoC7.BreakDown");this.data.objects?.obstacleDamageRoll?.total&&(damageStatus+=` : ${this.data.objects.obstacleDamageRoll.total}`),data.status.push({name:damageStatus}),this.data.states.obstacleDamageRolled&&(this.data.objects?.obstacleDamageRoll?.total<=0?data.strings.obstacleDamage=game.i18n.localize("CoC7.NoDamageDealt"):(data.inlineDamageRoll=createInlineRoll(this.data.objects.obstacleDamageRoll)?.outerHTML,data.strings.obstacleDamage=game.i18n.format("CoC7.DamageDealt",{value:data.inlineDamageRoll})))}if(this.data.states.tryToNegotiate&&data.status.push({name:game.i18n.localize("CoC7.Negotiate")}),this.data.totalCautiousApproach){const cautiousStatus={name:game.i18n.localize("CoC7.Cautious"),css:""};this.data.totalCautiousApproach>1?(cautiousStatus.css="strong",data.strings.cautiousApproachType=game.i18n.localize("CoC7.BeingVeryCautious")):data.strings.cautiousApproachType=game.i18n.localize("CoC7.BeingCautious"),this.data.flags.consumeBonusDice&&(cautiousStatus.css+=" consume"),data.status.push(cautiousStatus)}this.data.objects?.check&&(this.data.obstacle.hazard&&(this.data.movePlayer=!0),this.data.objects.check.passed?(void 0===this.data.movePlayer&&(this.data.movePlayer=!0),data.strings.obstaclePassed=game.i18n.localize("CoC7.ObstaclePassed"),this.data.objects.check.luckSpent&&(data.strings.obstaclePassed+=` (${game.i18n.localize("CoC7.GotLucky")})`),data.status.push({name:game.i18n.localize("CoC7.Success"),css:"success"})):this.data.objects.check.isFumble?(data.strings.checkFailed=game.i18n.localize("CoC7.ObstacleFumble"),data.status.push({name:game.i18n.localize("CoC7.Fumble"),css:"fumble"})):(data.strings.checkFailed=game.i18n.localize("CoC7.ObstacleFail"),data.status.push({name:game.i18n.localize("CoC7.Failure"),css:"failure"})))}if(this.data.states.playerActionDefined&&(this.data.obstacle.hazard?data.strings.playerIntentions=game.i18n.localize("CoC7.TryToNegotiateHazard"):this.data.obstacle.barrier&&(this.data.states.tryToNegotiate?data.strings.playerIntentions=game.i18n.localize("CoC7.TryToGetPastBarriers"):this.data.states.tryToBreak&&(data.strings.playerIntentions=game.i18n.localize("CoC7.TryToBreak")))),this.data.states.checkRolled&&(this.data.states.cardResolved?data.htmlCheck=await(this.data.objects.check.inlineCheck?.outerHTML):data.htmlCheck=await this.data.objects.check.getHtmlRoll()),this.data.states.cardResolved){data.playerDamageTaken=!1,data.obstalceDefinitionChanged=!1;this.listChanges().changes&&(data.obstalceDefinitionChanged=!0),this.data.obstacle.hasDamage&&this.data.objects?.check?.isFailure&&(data.playerDamageTaken=!0,data.inlineDamageTakenRoll=createInlineRoll(this.data.objects.failedDamageRoll)?.outerHTML,0===data.data.totalPlayerDamageTaken?data.strings.damageTaken=game.i18n.localize("CoC7.YouTakeNoDamage"):data.strings.damageTaken=game.i18n.format("CoC7.YouTakeSomeDamage",{amount:data.data.totalPlayerDamageTaken}),data.status.push({name:game.i18n.localize("CoC7.TotalDamage")+` :${data.data.totalPlayerDamageTaken}`})),this.data.obstacle.hasActionCost&&this.data.obstacle.hazard&&this.data.objects?.check?.isFailure&&(data.actionLost=!0,data.strings.actionLost=game.i18n.localize("CoC7.YouLostTime"),data.inlineActionLostRoll=createInlineRoll(this.data.objects.failedActionRoll)?.outerHTML),data.status.push({name:game.i18n.localize("CoC7.CardResolved")})}return this.data.states.closed&&(this.data.movePlayer?data.strings.finalOutcome=game.i18n.localize("CoC7.MoveToLocation"):data.strings.finalOutcome=game.i18n.localize("CoC7.DontMoveToLocation")),data}async GMUpdate(){if(game.user.isGM){if(this.data.states.cardResolved){if(this.data.objects?.failedDamageRoll?.total){const totalDamage=this.data.objects.failedDamageRoll.total,armorValue=this.data.flags.ignoreArmor?0:this.data.armor;CoC7Utilities.isFormula(armorValue)?this.data.armor=(await new Roll(armorValue).roll({async:!0})).total:isNaN(Number(armorValue))||(this.data.armor=Number(armorValue)),void 0===this.data.totalPlayerDamageTaken&&(this.data.totalPlayerDamageTaken=totalDamage-this.data.armor,this.data.totalPlayerDamageTaken<0&&(this.data.totalPlayerDamageTaken=0))}void 0===this.data.reflectObstaleChanges&&(this.data.reflectObstaleChanges=!0),void 0===this.data.movePlayer&&(this.data.movePlayer=(this.data.states.tryToNegotiate||this.data.obstacle.hazard)&&!this.data.states.failedConsequencesRolled),this.data.obstacle.barrier&&this.data.obstacle.hasHitPoints&&this.data.objects?.obstacleDamageRoll?.total&&(void 0===this.data.totalObstacleDamage&&(this.data.totalObstacleDamage=this.data.objects.obstacleDamageRoll.total),void 0===this.data.flags.obstacleDestoyed&&(this.data.flags.obstacleDestoyed=this.data.obstacle.HitPoints-this.data.totalObstacleDamage<=0))}this.data.states.closed&&(this.data.movementActionArray=foundry.utils.duplicate(this.participant.movementActionArray),this.data.EEC_ACTION={detachData:!0})}else console.error("CoC7: GMUpdate called from non GM user")}async localCompute(){}async assignObjects(){this.data.objects?.check&&"Object"===this.data.objects.check?.constructor?.name&&(this.data.objects.check=CoC7Check.fromData(this.data.objects.check)),this.data.objects?.obstacleDamageRoll&&"Object"===this.data.objects.obstacleDamageRoll?.constructor?.name&&(this.data.objects.obstacleDamageRoll=Roll.fromData(this.data.objects.obstacleDamageRoll)),this.data.objects?.failedDamageRoll&&"Object"===this.data.objects.failedDamageRoll?.constructor?.name&&(this.data.objects.failedDamageRoll=Roll.fromData(this.data.objects.failedDamageRoll)),this.data.objects?.failedActionRoll&&"Object"===this.data.objects.failedActionRoll?.constructor?.name&&(this.data.objects.failedActionRoll=Roll.fromData(this.data.objects.failedActionRoll))}async initialize(){this.chase&&void 0!==this.chase.activeParticipantData?.uuid&&(void 0===this.data&&(this.data={}),void 0===this.data.states&&(this.data.states={}),this.data.obstacle=this.location?.obstacleDetails,this.data.participantUuid=this.chase.activeParticipantData.uuid,this.participantData?.bonusDice>0&&(this.data.bonusDice=this.participantData.bonusDice,this.data.flags.consumeBonusDice=!0,this.data.flags.hasBonusDice=this.participant.hasBonusDice),this.data.movementActionArray=foundry.utils.duplicate(this.participant.movementActionArray),this.data.movementAction=this.participant.currentMovementActions,this.data.totalActionCost=0)}get participant(){if(this.participantData)return new _participant(this.participantData)}get participantData(){if(this.chase&&this.data.participantUuid)return this.chase.getParticipantData(this.data.participantUuid)}get location(){if(this.chase)return this.chase.getLocationData(this.data.locationUuid)}get obstacle(){if(this.location)return this.location.obstacleDetails}get chase(){if(this.data.chaseUuid)return this._chase||(this._chase=CoC7Utilities.SfromUuid(this.data.chaseUuid)),this._chase}get roll(){let rollData;if(this.participant.actor&&this.data.obstacle.checkName){const actorSkill=this.participant.actor.find(this.data.obstacle.checkName);rollData=void 0!==actorSkill?actorSkill:{type:"value",value:{name:this.data.obstacle.checkName,threshold:this.data.checkThreshold}},rollData.actor={actorKey:this.participant.actor.id}}else this.data.obstacle.checkName&&this.data.checkThreshold&&(rollData={type:"value",value:{name:this.data.obstacle.checkName,threshold:this.data.checkThreshold},actor:{name:this.participant.name}});return rollData&&(rollData.diceModifier=this.data?.bonusDice||0,rollData.difficulty=CoC7Check.difficultyLevel.regular,rollData.denyPush=!0),rollData||void 0}get validFailedRolls(){if(!this.data.objects?.check?.isFailure)return!1;if(this.data.obstacle.hasDamage){const damage="number"==typeof this.data.obstacle.failedCheckDamage?`${this.data.obstacle.failedCheckDamage}`:this.data.obstacle.failedCheckDamage;if(!this.data.obstacle.failedCheckDamage)return!1;if(this.data.obstacle.failedCheckDamage&&!Roll.validate(damage))return!1}if(this.data.obstacle.hazard&&this.data.obstacle.hasActionCost){const actionCost="number"==typeof this.data.obstacle.failedActionCost?`${this.data.obstacle.failedActionCost}`:this.data.obstacle.failedActionCost;if(!this.data.obstacle.failedActionCost)return!1;if(this.data.obstacle.failedActionCost&&!Roll.validate(actionCost))return!1}return!0}get weaponsOptions(){const weapons=[];if(this.participant.actor?.itemTypes?.weapon?.forEach((w=>{let formula=w.system.range.normal.damage,db=this.participant.actor.db;db=null===db||0===Number(db)?"":`${db}`,db&&!db.startsWith("-")&&(db="+"+db),w.system.properties.addb&&(formula+=db),w.system.properties.ahbd&&(formula=formula+db+"/2"),weapons.push({name:`${w.name} (${formula})`,damage:formula,uuid:w.uuid})})),weapons.sort(CoC7Utilities.sortByNameKey),!weapons.find((w=>w.name.toUpperCase().startsWith(game.i18n.localize("CoC7.UnarmedWeaponName")?.toUpperCase())))){let db="";this.participant.actor&&(db=this.participant.actor.db,db&&!db.startsWith("-")&&(db="+"+db),null!==db&&0!==Number(db)||(db="")),weapons.unshift({name:`${game.i18n.localize("CoC7.UnarmedWeaponName")} (1D3${db})`,damage:`1D3${db}`,uuid:"unarmed"})}return weapons.push({name:game.i18n.localize("CoC7.Other"),damage:this.data?.customWeaponDamage||null,uuid:0}),weapons}get usedWeapon(){if(!this.data?.weaponChoice){if(!this.weaponsOptions)return;this.data||(this.data={}),this.data.weaponChoice=this.weaponsOptions[0].uuid}if(this.data.weaponChoice){const weapon=this.weaponsOptions.find((e=>e.uuid===this.data.weaponChoice));if(weapon)return weapon}}get inflictedDamageFormula(){if(this.usedWeapon){const weapon=this.usedWeapon;return weapon&&weapon.damage&&Roll.validate(weapon.damage)?weapon.damage:void 0}}get validObstacleDamage(){return!!(this.data.obstacle.hasHitPoints&&!isNaN(Number(this.data.obstacle.HitPoints))&&Number(this.data.obstacle.HitPoints)>0&&this.inflictedDamageFormula)}get strings(){const strings={};return strings.damageRollRequest=this.usedWeapon.name,strings}async validateCard(options){let loactionChanged,participantChaged=!1;const obstacleUpdate={obstacleDetails:{}},participantUpdate={};this.data.flags.obstacleDestoyed&&(loactionChanged=!0,obstacleUpdate.obstacle=!1,obstacleUpdate.obstacleDetails.hazard=!1,obstacleUpdate.obstacleDetails.barrier=!1);const diff=this.listChanges();if(diff.changes&&this.data.reflectObstaleChanges)for(const[key,value]of Object.entries(diff.obstacle))"type"!==key&&(obstacleUpdate.obstacleDetails[value.key]=value.new,loactionChanged=!0);if(this.data.totalObstacleDamage>0&&this.data.obstacle.hasHitPoints){let remainingHp=this.data.obstacle.HitPoints;remainingHp-=this.data.totalObstacleDamage,remainingHp<0&&(remainingHp=0),this.obstacle.HitPoints!==remainingHp&&(obstacleUpdate.obstacleDetails.HitPoints=remainingHp,this.data.obstacle.HitPoints=remainingHp,loactionChanged=!0)}if(this.data.totalPlayerDamageTaken>0&&(participantChaged=!0,this.participant.actor?await this.participant.actor.dealDamage(this.data.totalPlayerDamageTaken,{ignoreArmor:!0}):(participantUpdate.hp=this.participantData.hp,participantUpdate.hp-=this.data.totalPlayerDamageTaken,participantUpdate.hp<0&&(participantUpdate.hp=0))),this.data.totalActionCost>0&&(participantChaged=!0,participantUpdate.currentMovementActions=this.participantData.currentMovementActions,participantUpdate.currentMovementActions-=this.data.totalActionCost),void 0===this.data.flags.consumeBonusDice&&(this.data.flags.consumeBonusDice=!0),this.data.flags.consumeBonusDice?(participantChaged=!0,participantUpdate.bonusDice=0):isNaN(this.data.bonusDice)||this.data.bonusDice===this.participant.bonusDice||(participantUpdate.bonusDice=this.data.bonusDice),this.data.movePlayer){let targetLocation;targetLocation=this.data.forward?this.location:this.chase.getLocationShift(this.location.uuid,{skip:-1}),targetLocation.uuid&&await this.chase.moveParticipantToLocation(this.participantData.uuid,targetLocation.uuid,{scrollToLocation:!0,activateLocation:!1,render:!1})}return loactionChanged&&await this.chase.updateLocation(this.location.uuid,obstacleUpdate,{render:!1}),participantChaged&&await this.chase.updateParticipant(this.participantData.uuid,participantUpdate,{render:!1}),this.data.states.closed=!0,await this.chase.activateNextParticipantTurn(),!0}async defineObstacle(options){return this.data.states||(this.data.states={}),this.data.states.obstacleDefined=!0,!0}async tryToNegotiateObstacle(options){return this.data.states.breakOrNegotiateDefined=!0,this.data.states.tryToNegotiate=!0,this.data.states.tryToBreak=!1,!0}async tryToBreakDownObstacle(options){return this.data.states.breakOrNegotiateDefined=!0,this.data.states.tryToNegotiate=!1,this.data.states.tryToBreak=!0,!0}async cancelObstacleDefinition(options){return this.data.states.obstacleDefined=!1,this.data.states.breakOrNegotiateDefined=!1,this.data.states.tryToNegotiate=!1,this.data.states.tryToBreak=!1,!0}async cancelBreakOrPassChoice(options){return this.data.obstacle.hasHitPoints?(this.data.states.breakOrNegotiateDefined=!1,this.data.states.tryToNegotiate=!1,this.data.states.tryToBreak=!1,!0):this.cancelObstacleDefinition()}async requestRoll(options){return this.data.states.playerActionDefined=!0,!0}async takeCautiousApproach(options){return this.data.totalCautiousApproach||(this.data.totalCautiousApproach=0),this.data.totalCautiousApproach+=1,this.data.bonusDice+=1,this.data.totalActionCost+=1,this.data.flags.consumeBonusDice||(this.data.flags.consumeBonusDice=!0),this.data.flags.hasBonusDice||(this.data.flags.hasBonusDice=!0),this.data.movementAction<=this.data.totalActionCost&&(this.data.flags.consumeBonusDice=!1,this.data.states.cardResolved=!0,this.data.movePlayer=!1),!0}async rollSkillCheck(options){const target=options.event.currentTarget;if(!target.classList.contains("disabled")){if(target.classList.toggle("disabled"),this.roll)return this.data.objects||(this.data.objects={}),this.data.objects.check=CoC7Check.createFromActorRollData(this.roll),!!this.data.objects.check&&(this.data.objects.check.denyPush=!0,await this.data.objects.check._perform({forceDSN:!0}),this.data.totalActionCost+=1,this.data.states.checkRolled=!0,target.classList.toggle("disabled"),this.data.objects.check.passed?(this.data.movePlayer=!0,this.data.states.cardResolved=!0):void 0===this.data.armor&&this.participant.actor&&(this.data.armor=this.participant.actor.system.attribs.armor.value||0),!0);ui.notifications.error(game.i18n.localize("CoC7.NothingToRoll"))}}async useLuck(options){return await CoC7Check.alter(this.data.objects.check,"useLuck",{target:options.event.currentTarget,update:!1}),this.data.objects.check.passed&&(this.data.states.cardResolved=!0,this.data.movePlayer=!0,this.data.totalActionCost+=1),!0}async rollFailConsequences(options){if(this.data.objects||(this.data.objects={}),this.data.obstacle.hasDamage&&this.data.objects.check?.isFailure){const damage="number"==typeof this.data.obstacle.failedCheckDamage?`${this.data.obstacle.failedCheckDamage}`:this.data.obstacle.failedCheckDamage;this.data.objects.failedDamageRoll=new Roll(damage),await this.data.objects.failedDamageRoll.evaluate({async:!0})}if(this.data.obstacle.hazard&&this.data.obstacle.hasActionCost&&this.data.objects.check?.isFailure){const actionCost="number"==typeof this.data.obstacle.failedActionCost?`${this.data.obstacle.failedActionCost}`:this.data.obstacle.failedActionCost;this.data.objects.failedActionRoll=new Roll(actionCost),await this.data.objects.failedActionRoll.evaluate({async:!0}),this.data.totalActionCost+=this.data.objects.failedActionRoll.total-1}return this.data.states.failedConsequencesRolled=!0,this.data.states.cardResolved=!0,!0}async askRollObstacleDamage(options){return this.data.states.playerActionDefined=!0,!0}async rollObstacleDamage(options){return this.data.objects||(this.data.objects={}),this.data.objects.obstacleDamageRoll=new Roll(this.usedWeapon?.damage),await this.data.objects.obstacleDamageRoll.evaluate({async:!0}),await CoC7Dice.showRollDice3d(this.data.objects.obstacleDamageRoll),this.data.states.obstacleDamageRolled=!0,this.data.totalActionCost+=1,this.data.states.cardResolved=!0,!0}listChanges(validate=!1){const diff={obstacle:{},player:{},changes:!1},names={barrier:game.i18n.localize("CoC7.Type"),hazard:game.i18n.localize("CoC7.Type"),hasHitPoints:game.i18n.localize("CoC7.Breakable"),HitPoints:game.i18n.localize("CoC7.HitPoints"),hasActionCost:game.i18n.localize("CoC7.ActionCost"),failedActionCost:game.i18n.localize("CoC7.ActionCost"),hasDamage:game.i18n.localize("CoC7.FightBack"),failedCheckDamage:game.i18n.localize("CoC7.WeaponDamage"),checkName:game.i18n.localize("CoC7.Check"),name:game.i18n.localize("CoC7.Name")};validate&&!this.data.validation&&(this.data.validation={});const newObstacle=foundry.utils.diffObject(this.obstacle,this.data.obstacle);for(const[key]of Object.entries(newObstacle))""===newObstacle[key]&&null===this.obstacle[key]||!isNaN(Number(newObstacle[key]))&&Number(newObstacle[key])===this.obstacle[key]||(diff.changes=!0,diff.obstacle[key]={old:this.obstacle[key],new:newObstacle[key],name:names[key],key},validate&&(this.data.validation[key]=!0));return diff}}function addCoCIDSheetHeaderButton(headerButtons,sheet){if(game.user.isGM){void 0!==sheet.options.actions&&(sheet.options.actions.cocid=()=>{new CoCIDEditor(sheet.document,{}).render(!0,{focus:!0})});const sheetCoCID=sheet.document.flags?.CoC7?.cocidFlag,CoCIDEditorButton={class:void 0===sheetCoCID||void 0===sheetCoCID.id||""===sheetCoCID.id?"edit-coc-id-warning":"edit-coc-id-exisiting",label:"CoC7.CoCIDFlag.id",icon:"fas fa-fingerprint",action:"cocid",onclick:()=>{new CoCIDEditor(sheet.document,{}).render(!0,{focus:!0})}},numberOfButtons=headerButtons.length;headerButtons.splice(numberOfButtons-1,0,CoCIDEditorButton)}}class CoC7ChaseParticipantImporter extends FormApplication{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{title:game.i18n.localize("CoC7.AddActorToChase"),template:"systems/CoC7/templates/apps/chase-participant-importer.html",classes:["coc7","dialog","chase-participant-importer"],editable:!0,resizable:!1,submitOnChange:!0,closeOnSubmit:!1,width:300,height:"auto"})}activateListeners(html){super.activateListeners(html);new(foundry.applications.ux?.DragDrop??DragDrop)({dropSelector:".form-container",permissions:{drop:game.user.isGM},callbacks:{drop:this._onDropParticipant.bind(this)}}).bind(html[0]);new(foundry.applications.ux?.DragDrop??DragDrop)({dragSelector:".chase-token",permissions:{dragstart:game.user.isGM},callbacks:{dragstart:this._onTokenSelectorDragStart.bind(this)}}).bind(html[0]),html.find(".reset-participant").click((async()=>{this.object={},this._actor=null,await this.render(!0)})),html.find(".food-chain").click((async()=>{this.object.chaser=!this.object.chaser,await this.render(!0)})),html.find("[data-action]").click(this._onAction.bind(this))}async _onTokenSelectorDragStart(event){const data={type:"getToken",appId:this.appId,callBack:"addTokenToChase"};event.dataTransfer.setData("text/plain",JSON.stringify(data))}async getData(){if(!this.object.initiative){const init=CoCActor.getCharacteristicDefinition().find((c=>"dex"===c.key));this.object.initiative=init.label}if(!this.object.speedCheck){const speedCheck=CoCActor.getCharacteristicDefinition().find((c=>"con"===c.key));this.object.speedCheck={name:speedCheck.label}}this.validateParticipant();const data=await super.getData();if(data.participant=new _participant(this.object),data.object.speedCheck.name&&this.actor){const speedCheck=this.actor.find(data.object.speedCheck.name);speedCheck?(data.object.speedCheck.score=speedCheck.value.value,data.speedCheckReadOnly=!0):data.participant.speedCheck.score&&!this.object.speedCheck?.score&&(data.object.speedCheck.score=data.participant.speedCheck.score)}if(data.object.initiative&&this.actor){const initiative=this.actor.find(data.object.initiative);initiative?(data.object.dex=initiative.value.value,data.initReadOnly=!0):data.object.dex=data.participant.initiative}return data.actor=this.actor,data.chase=this.chase,data.data=this.data,data.optionsList={},this.chase&&(data.skillsAndCharacteristicsList=this.chase.allSkillsAndCharacteristicsShort),this.actor&&(data.skillsAndCharacteristicsList=[],CoCActor.getCharacteristicDefinition().forEach((c=>data.skillsAndCharacteristicsList.push(`${c.label}`))),data.skillsAndCharacteristicsList.push(`${game.i18n.localize("CoC7.Luck")}`),data.skillsAndCharacteristicsList.push(`${game.i18n.localize("CoC7.SAN")}`),this.actor.skills.forEach((s=>data.skillsAndCharacteristicsList.push(s.name)))),data}get chase(){return this._chase||(this._chase=CoC7Utilities.SfromUuid(this.object.chaseUuid)),this._chase}get actor(){return this.object.docUuid?(this._actor||(this._actor=CoC7Utilities.getActorFromKey(this.object.docUuid)),this._actor):null}async _updateObject(event,formData){foundry.utils.mergeObject(this,formData),await this.render(!0)}async _onDropParticipant(event){const dropString=event.dataTransfer.getData("text/plain"),dropData=JSON.parse(dropString),docUuid=CoC7Utilities.getActorDocumentFromDropData(dropData);this.object.docUuid=docUuid,this.object.chaser=0===this.actor?.owners?.filter((u=>!u.isGM)).length,this.object.speedCheck.rollDataString&&delete this.object.speedCheck.rollDataString,await this.render(!0)}async addTokenToChase(tokens){1===tokens.length?(this.object.docUuid=tokens[0].document?.uuid,this.object.chaser=0===this.actor?.owners?.filter((u=>!u.isGM)).length,this.object.speedCheck.rollDataString&&delete this.object.speedCheck.rollDataString,await this.render(!0)):ui.notifications.warn(game.i18n.localize("CoC7.ErrorTokenIncorrect"))}async _onAction(event){event.preventDefault();switch(event.currentTarget.dataset.action){case"chase-cancel":this.close();break;case"chase-add":{const participant=new _participant(this.object);if(this.chase.started){if(!(participant.movementAction&&participant.movementAction>0))return void ui.notifications.warn(game.i18n.localize("CoC7.DoesNotMeetMinimumReqToBeAdded"));if(this.data.overrideMovementAction){const slowest=this.chase.slowestParticipant;isNaN(participant.adjustedMov)&&(participant.mov=slowest.adjustedMov),this.data.recalculationNeeded=!1}}await this.chase.addParticipant(participant,{locationUuid:this.object.locationUuid,recalculateMovementActions:this.data.recalculationNeeded,update:this.object.update}),this.close()}break;case"roll-speed-check":{const participant=new _participant(this.object);if(participant.speedCheck.refSet){const roll=new CoC7Check;participant.data.rolled=!0,roll.actor=participant.actor.actorKey,participant.speedCheck.isCharacteristic?(await roll.rollCharacteristic(participant.speedCheck.ref.key),participant.data.speedCheck.rollDataString=roll.JSONRollString):participant.speedCheck.isSkill?(roll.skill=participant.speedCheck.ref,await roll.roll(),participant.data.speedCheck.rollDataString=roll.JSONRollString):participant.speedCheck.isAttribute&&(await roll.rollAttribute(participant.speedCheck.ref.key),participant.data.speedCheck.rollDataString=roll.JSONRollString)}else if(participant.speedCheck.score){const rollData={rawValue:participant.speedCheck.score,displayName:participant.speedCheck.name,actorName:participant.name?participant.name:void 0};participant.hasActor&&(rollData.actor=participant.actor.actorKey);const roll=CoC7Check.create(rollData);await roll.roll(),participant.data.speedCheck.rollDataString=roll.JSONRollString,participant.data.rolled=!0}foundry.utils.mergeObject(this.object,participant.data),this.render(!0)}}}validateParticipant(){const participant=new _participant(this.object);if(this.data||(this.data={}),this.object.excluded=!1,this.object.escaped=!1,this.data.recalculationNeeded=!1,this.data.participantExcluded=!1,this.data.movementActionDelta=0,!this.data.overrideMovementAction){const slowestPrey=this.chase.slowestPrey,fastestChaser=this.chase.fastestChaser,slowest=this.chase.slowestParticipant;participant.adjustedMov<slowest?.adjustedMov?(this.data.recalculationNeeded=!0,participant.movementAction=1):(this.data.recalculationNeeded=!1,participant.calculateMovementActions(slowest?.adjustedMov)),participant.isChaser&&slowestPrey&&!this.chase.system.includeLastCommers&&participant.adjustedMov<slowestPrey.adjustedMov&&(this.object.excluded=!0,this.data.participantExcluded=!0,this.data.excludedBecause=game.i18n.localize("CoC7.TooSlow"),this.data.recalculationNeeded=!1),participant.isPrey&&fastestChaser&&!this.chase.system.includeEscaped&&participant.adjustedMov>fastestChaser.adjustedMov&&(this.object.escaped=!0,this.data.participantExcluded=!0,this.data.excludedBecause=game.i18n.localize("CoC7.TooFast"),this.data.recalculationNeeded=!1)}}static async create(data){if(data.dropData){const docUuid=CoC7Utilities.getActorDocumentFromDropData(data.dropData);docUuid&&(data.docUuid=docUuid),delete data.dropData}return new CoC7ChaseParticipantImporter(data).render(!0)}}class CoC7ChaseSheet extends foundry.appv1.sheets.ItemSheet{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{classes:["coc7","sheetV2","item","chase"],template:"systems/CoC7/templates/items/chase.html",width:550,height:500,resizable:!0,tabs:[{navSelector:".sheet-nav",contentSelector:".sheet-body",initial:"participants"}]})}static get type(){return"coc7ChaseSheet"}_getHeaderButtons(){const headerButtons=super._getHeaderButtons();return addCoCIDSheetHeaderButton(headerButtons,this),headerButtons}async getData(options={}){const sheetData=super.getData(options);return sheetData.participants=this.item.participantsObject,sheetData.participantsByInitiative=this.item.participantsByInitiative,sheetData.preys=this.item.preys,sheetData.chasers=this.item.chasers,sheetData.preysMinMov=sheetData.preys.length?sheetData.preys.reduce(((prev,current)=>prev.adjustedMov<current.adjustedMov?prev:current)).adjustedMov:-1,sheetData.preysMaxMov=sheetData.preys.length?sheetData.preys.reduce(((prev,current)=>prev.adjustedMov>current.adjustedMov?prev:current)).adjustedMov:-1,sheetData.chasersMinMov=sheetData.chasers.length?sheetData.chasers.reduce(((prev,current)=>prev.adjustedMov<current.adjustedMov?prev:current)).adjustedMov:-1,sheetData.chasersMaxMov=sheetData.chasers.length?sheetData.chasers.reduce(((prev,current)=>prev.adjustedMov>current.adjustedMov?prev:current)).adjustedMov:-1,sheetData.chasers.forEach((p=>{p.adjustedMov<sheetData.preysMinMov?p.tooSlow():p.includeInChase(),p.fastest=p.adjustedMov===sheetData.chasersMaxMov,p.slowest=p.adjustedMov===sheetData.chasersMinMov})),sheetData.preys.forEach((p=>{p.adjustedMov>sheetData.chasersMaxMov?p.escaped():p.includeInChase(),p.fastest=p.adjustedMov===sheetData.preysMaxMov,p.slowest=p.adjustedMov===sheetData.preysMinMov})),sheetData.locations=this.item.locations,sheetData.allHaveValidMov=this.allHaveValidMov,sheetData.activeLocation=this.item.activeLocation,sheetData.activeLocation&&(sheetData.activeLocation.title=sheetData.activeLocation.coordinates?game.i18n.format("CoC7.LocationCoordinate",{x:sheetData.activeLocation.coordinates.x,y:sheetData.activeLocation.coordinates.y}):game.i18n.localize("CoC7.DragOnCanvas")),sheetData.previousLocation=this.item.previousLocation,sheetData.nextLocation=this.item.nextLocation,sheetData.started=this.item.started,sheetData.isKeeper=game.user.isGM,sheetData.enrichedDescriptionKeeper=await TextEditor.enrichHTML(sheetData.data.system.description.keeper,{async:!0,secrets:sheetData.editable}),sheetData}activateListeners(html){super.activateListeners(html),html.find(".dropdown-element").on("click",(event=>this._onDropDownElementSelected(event))),html.find(".dropbtn").click((event=>{event.preventDefault(),event.stopPropagation();event.currentTarget.closest(".dropdown").querySelector(".dropdown-content").classList.toggle("show")})),html.find(".dropdown").mouseleave((event=>event.currentTarget.querySelector(".dropdown-content").classList.remove("show"))),html.on("dblclick",".open-actor",CoC7Chat._onOpenActor.bind(this)),html.find(".pin-location").contextmenu(this.clearActiveLocationCoordinates.bind(this)),html.find(".participant").on("dragenter",(event=>this._onDragEnterParticipant(event))),html.find(".participant").on("dragover",(event=>this._onDragEnterParticipant(event))),html.find(".participant").on("dragleave",(event=>this._onDragLeaveParticipant(event))),html.find(".participant").on("drop",(event=>this._onDragLeaveParticipant(event))),html.find(".p-side").click(this._onChangeSide.bind(this)),html.find(".delete-participant").click(this._onDeleteParticipant.bind(this)),html.find(".reset-roll").click(this._onResetRoll.bind(this)),html.find(".delete-driver").click(this._onDeleteDriver.bind(this)),html.find(".new-participant").on("dragenter",(event=>this._onDragEnterParticipant(event))),html.find(".new-participant").on("dragover",(event=>this._onDragEnterParticipant(event))),html.find(".new-participant").on("dragleave",(event=>this._onDragLeaveParticipant(event))),html.find(".new-participant").on("drop",(event=>this._onDragLeaveParticipant(event))),html.find(".add-sign").click(this._onAddParticipant.bind(this)),html.find(".roll-participant").click(this._onRollParticipant.bind(this)),html.find(".button").click(this._onButtonClick.bind(this)),html.find(".name-container").click(this._onLocationClick.bind(this)),html.find(".obstacle-type").click(this._onObstacleTypeClick.bind(this)),html.find(".toggle").click(this._onToggle.bind(this)),html.find(".participant-control").click(this._onParticipantControlClicked.bind(this)),html.find(".chase-control").click(this._onChaseControlClicked.bind(this)),html.find(".location-control").click(this._onLocationControlClick.bind(this));new(foundry.applications.ux?.DragDrop??DragDrop)({dragSelector:".pin-location",permissions:{dragstart:this._canPinLocationDragStart.bind(this)},callbacks:{dragstart:this._onPinLocationDragStart.bind(this)}}).bind(html[0]);new(foundry.applications.ux?.DragDrop??DragDrop)({dropSelector:".participant",callbacks:{drop:this._onDropParticipant.bind(this)}}).bind(html[0]);if(new(foundry.applications.ux?.DragDrop??DragDrop)({dropSelector:".new-participant",callbacks:{drop:this._onAddParticipant.bind(this)}}).bind(html[0]),this.item.started){html.find(".chase-location .chase-participant").click(this._onChaseParticipantClick.bind(this));new(foundry.applications.ux?.DragDrop??DragDrop)({dragSelector:".chase-participant",dropSelector:".chase-location",permissions:{dragstart:this._canChaseParticipantDragStart.bind(this),drop:this._canChaseParticipantDragDrop.bind(this)},callbacks:{dragstart:this._onChaseParticipantDragStart.bind(this),drop:this._onChaseParticipantDragDrop.bind(this),dragover:this._onDragEnter.bind(this)}}).bind(html[0]),html.find(".chase-location").on("dragleave",(event=>this._onDragLeave(event)))}}_getSubmitData(updateData={}){let data=new(foundry.applications.ux?.FormDataExtended??FormDataExtended)(this.form,{editors:this.editors}).object;if(data=updateData?foundry.utils.mergeObject(data,updateData):foundry.utils.expandObject(data),this.item.system.locations?.list?.length&&data.system.startingIndex>this.item.system.locations.list.length&&(data.system.startingIndex=this.item.system.locations.list.length),data.system.participants){const participants=foundry.utils.duplicate(this.item.system.participants);for(const[k,v]of Object.entries(data.system.participants)){const index=participants.findIndex((p=>p.uuid===k));if(-1===index)ui.notifications.error("Participant table corrupted");else{const original=participants[index],cleaned=clean(v);foundry.utils.mergeObject(original,cleaned),participants[index]=original}}data.system.participants=participants}if(data.locations){const locations=foundry.utils.duplicate(this.item.system.locations.list);for(const[key,value]of Object.entries(data.locations)){const locationIndex=locations.findIndex((l=>l.uuid===key));if(-1===locationIndex)ui.notifications.error("Locations table corrupted");else{const originalLocation=locations[locationIndex],cleaned=clean(value);foundry.utils.mergeObject(originalLocation,cleaned),locations[locationIndex]=originalLocation}}delete data.locations,data.system.locations={list:locations}}return foundry.utils.flattenObject(data)}async _updateObject(event,formData){const target=event.currentTarget,override="true"===target?.dataset?.override;if(target?.name?.includes(".hp")){const[,,uuid]=target.name.split("."),participant=this.item.getParticipant(uuid);participant&&participant.actor&&(isNaN(Number(target.value))||await participant.actor.setHp(Number(target.value)))}if(override){const[,type,uuid,subType,data]=target.name.split("."),index=this.findParticipantIndex(uuid);if("participants"===type&&!isNaN(index)&&"speed-check"===subType&&"name"===data){const participants=this.item.system.participants?foundry.utils.duplicate(this.item.system.participants):[];return participants[index].speedCheck?(delete participants[index].speedCheck.id,delete participants[index].speedCheck.type):participants[index].speedCheck={},participants[index].speedCheck.name=target.value,void await this.item.update({"system.participants":participants})}}super._updateObject(event,formData)}static async setScroll(app,html,data){if(!data.editable)return;const initialOpening=html[0].classList.contains("window-app"),chaseTrack=html[0].querySelector(".chase-track");if(!chaseTrack)return;let start=data.data.scroll?.chaseTrack.from,end=data.data.scroll?.chaseTrack.to;if(void 0===start&&(start=0),void 0===end&&(end=-1),initialOpening){const remString=$(":root").css("font-size"),remSize=Number(remString.replace("px",""));if(app.item.started){const pCount=app.item.actualParticipants?.length,width=(11.2*pCount+3)*remSize;app.activateTab("setup"),app.position.width=Math.max(width,40*remSize)}else app.position.width=45*remSize;return await app.item.activateNextParticipantTurn({html})}start&&-1!==start&&chaseTrack.scrollTo({top:0,left:start,behavior:"instant"}),-1!==end&&chaseTrack.scrollTo({top:0,left:end,behavior:"smooth"})}static onClose(app,html){app.item.update({"system.trackScrollPosition":-1})}findParticipantIndex(uuid){return this.item.system.participants.findIndex((p=>p.uuid===uuid))}findLocationIndex(uuid){return this.item.system.locations.list.findIndex((p=>p.uuid===uuid))}findLocation(uuid){return this.item.system.locations.list.find((p=>p.uuid===uuid))}findIndex(list,uuid){return list.findIndex((p=>p.uuid===uuid))}async _onDropDownElementSelected(event){event.preventDefault(),event.stopPropagation();const target=event.currentTarget;target.closest(".dropdown-content")?.classList.toggle("show");const assistantUuid=target.closest(".initiative-block")?.dataset?.uuid,beneficiaryUuid=target.dataset.beneficiaryUuid;await this.item.assistParticipant(assistantUuid,beneficiaryUuid)}async _onToggle(event){const target=event.currentTarget,toggle=target.getAttribute("toggle"),data=foundry.utils.expandObject({[toggle]:!target.classList.contains("switched-on")});if(data.locations){const locations=foundry.utils.duplicate(this.item.system.locations.list);for(const[key,value]of Object.entries(data.locations)){const locationIndex=locations.findIndex((l=>l.uuid===key));if(-1===locationIndex)ui.notifications.error("Locations table corrupted");else{const originalLocation=locations[locationIndex],cleaned=clean(value);foundry.utils.mergeObject(originalLocation,cleaned),locations[locationIndex]=originalLocation}}await this.item.updateLocationsList(locations)}}async _onObstacleTypeClick(event){const target=event.currentTarget,uuid=target.closest(".obstacle").dataset.uuid,locations=foundry.utils.duplicate(this.item.system.locations.list),locationIndex=this.findIndex(locations,uuid);locations[locationIndex].obstacleDetails||(locations[locationIndex].obstacleDetails={});const obstacle=locations[locationIndex].obstacleDetails,type=target.classList.contains("barrier")?"barrier":"hazard",active=obstacle[type];obstacle.barrier=!1,obstacle.hazard=!1,obstacle[type]=!active,locations[locationIndex].obstacle=!active,await this.item.updateLocationsList(locations)}async _onLocationClick(event){const lUuid=event.currentTarget.closest(".chase-location").dataset.uuid;await this.item.activateLocation(lUuid)}async _onLocationControlClick(event){event.preventDefault();const target=event.currentTarget;if(target.classList.contains("inactive"))return;const action=target.dataset.action,lUuid=target.closest(".chase-location").dataset.uuid;switch(action){case"remove":await this.item.removeLocation(lUuid);break;case"add-after":await this.item.insertLocation(lUuid,{shift:1});break;case"add-before":await this.item.insertLocation(lUuid,{shift:0});break;case"add-participant":CoC7ChaseParticipantImporter.create({chaseUuid:this.item.uuid,locationUuid:lUuid,dropData:{}})}}async _onChaseParticipantClick(event){const pUuid=event.currentTarget.dataset?.uuid;await this.item.activateParticipant(pUuid)}async _onParticipantControlClicked(event){event.preventDefault();const target=event.currentTarget;if(target.classList.contains("inactive"))return;if(target.classList.contains("dropdown"))return;event.stopPropagation();const participantUuid=target.closest(".initiative-block")?.dataset?.uuid;if(participantUuid){switch(target.dataset.action){case"drawGun":await this.toggleParticipantGun(participantUuid);break;case"decreaseActions":await this._onChangeMovementActions(-1,event);break;case"increaseActions":await this._onChangeMovementActions(1,event);break;case"moveBackward":await this.item.moveParticipant(participantUuid,-1,{render:!0});break;case"moveForward":await this.item.moveParticipant(participantUuid,1,{render:!0});break;case"activateParticipant":return await this.item.activateParticipant(participantUuid);case"bonusDice":{const diceNumber=target.dataset.count;await this.item.toggleBonusDice(participantUuid,diceNumber),this.item.activateNextParticipantTurn()}break;case"cautiousApproach":await this.item.cautiousApproach(participantUuid);break;case"editParticipant":{const participant=this.item.getParticipant(participantUuid),location=this.item.getParticipantLocation(participantUuid);participant.data.chaseUuid=this.item.uuid,participant.data.locationUuid=location.uuid,participant.data.update=!0,CoC7ChaseParticipantImporter.create(participant.data)}break;case"removeParticipant":await this.item.removeParticipant(participantUuid)}this.item.activateNextParticipantTurn()}}async _onChaseControlClicked(event){event.preventDefault();const target=event.currentTarget;event.stopPropagation();const locationUuid=target.closest(".obstacle")?.dataset?.uuid;if(locationUuid)return"obstacle-skill-check"===target.dataset.action?this.item.activeParticipantObstacleCheck(locationUuid):void 0}async _onChangeMovementActions(count,event){event.preventDefault(),event.stopPropagation();const target=event.currentTarget,participantUuid=target.closest(".initiative-block")?.dataset?.uuid;if(!participantUuid)return;const participants=this.item.participants,participant=participants.find((p=>participantUuid===p.uuid));participant.hasMaxMvtActions&&count>0||(participant.alterMovementActions(count),await this.item.setchaseTrackScroll({render:!1}),await this.item.updateParticipants(participants))}async _onButtonClick(event){const target=event.currentTarget,action=target.dataset?.action;if(action)switch(action){case"init":if(!isNaN(this.item.system.locations.total)&&this.item.system.locations.total>0){const locations=Array.apply(null,Array(this.item.system.locations.total)).map((function(){return{uuid:foundry.utils.randomID(16)}}));locations[0].name="Start",locations.length>1&&(locations[locations.length-1].name="End"),await this.item.updateLocationsList(locations)}break;case"reset":Dialog.confirm({title:`${game.i18n.localize("CoC7.ConfirmResetChase")}`,content:`<p>${game.i18n.localize("CoC7.ConfirmResetChaseHint")}</p>`,yes:async()=>{await this.item.updateLocationsList([]),await this.item.stop()}});break;case"cut2chase":this.item.allHaveSpeedRoll?Dialog.confirm({title:`${game.i18n.localize("CoC7.ConfirmCut2Chase")}`,content:`<p>${game.i18n.localize("CoC7.ConfirmCut2ChaseHint")}</p>`,yes:()=>this.item.cutToTheChase()}):ui.notifications.warn(game.i18n.localize("CoC7.NotAllHaveSpeedRoll"));break;case"restart":Dialog.confirm({title:`${game.i18n.localize("CoC7.ConfirmRestartChase")}`,content:`<p>${game.i18n.localize("CoC7.ConfirmRestartChaseHint")}</p>`,yes:()=>this.item.restart()});break;case"nextRound":this.item.nextActiveParticipant?Dialog.confirm({title:`${game.i18n.localize("CoC7.ConfirmNextChaseRound")}`,content:`<p>${game.i18n.localize("CoC7.ConfirmNextChaseRoundHint")}</p>`,yes:()=>this.item.progressToNextRound()}):this.item.progressToNextRound()}}_canPinLocationDragStart(selector){return!!game.user.isGM}async _onPinLocationDragStart(event){const a=event.currentTarget,i=a.querySelector("i.icon"),dragIcon=a.querySelector(".pin-image");event.dataTransfer.setDragImage(dragIcon,0,dragIcon.height);const locationElement=a.closest(".chase-location"),data={type:"locator",CoC7Type:"chase"};data.icon=i.dataset.linkIcon,data.locationUuid=locationElement.dataset.uuid,data.docUuid=this.item.uuid,data.callBack="locatorDropped",event.dataTransfer.setData("text/plain",JSON.stringify(data))}_canChaseParticipantDragStart(selector){return!!game.user.isGM}_canChaseParticipantDragDrop(selector){return!!game.user.isGM}async _onChaseParticipantDragStart(dragEvent){const dragData={uuid:dragEvent.currentTarget.dataset.uuid,type:"participant"};dragEvent.dataTransfer.setData("text/plain",JSON.stringify(dragData))}async _onChaseParticipantDragDrop(dragEvent){const dataString=dragEvent.dataTransfer.getData("text/plain"),data=JSON.parse(dataString);this._onDragLeave(dragEvent);const locationUuid=dragEvent.currentTarget.dataset.uuid;if("participant"===data.type){const oldLocation=this.findLocation(locationUuid);if(oldLocation&&oldLocation.participants?.includes(data.uuid))return;await this.item.setchaseTrackScroll({render:!1}),await this.item.moveParticipantToLocation(data.uuid,locationUuid)}else CoC7ChaseParticipantImporter.create({chaseUuid:this.item.uuid,locationUuid,dropData:data})}_onDragOver(dragEvent){this._onDragEnter(dragEvent)}_onDragEnter(dragEvent){dragEvent.currentTarget.classList.add("drag-over")}_onDragLeave(dragEvent){const target=dragEvent.currentTarget;target.classList?.remove("drag-over")}async _onDropParticipant(event){const target=event.currentTarget,uuid=target.dataset?.uuid,dataString=event.dataTransfer.getData("text/plain"),data=JSON.parse(dataString);await this.alterParticipant(data,uuid)}async _onAddParticipant(event){event.preventDefault();const data={chaseUuid:this.item.uuid};if(event.dataTransfer){const dataString=event.dataTransfer.getData("text/plain");data.dropData=JSON.parse(dataString)}CoC7ChaseParticipantImporter.create(data)}async _onRollParticipant(event){const uuid=event.currentTarget.closest(".participant").dataset.uuid,index=this.findParticipantIndex(uuid),participants=this.item.system.participants?foundry.utils.duplicate(this.item.system.participants):[],participant=new _participant(participants[index]);if(participant.speedCheck.refSet){const roll=new CoC7Check;roll.parent=this.item.uuid,participant.data.rolled=!0,participant.data.rollUuid=roll.uuid,roll.actor=participant.actor.actorKey,!event.shiftKey&&participant.actor.player&&(roll.standby=!0,roll.standbyText="CoC7.Chase",roll.standbyRightIcon="systems/CoC7/assets/icons/running-solid.svg"),participant.speedCheck.isCharacteristic?(await roll.rollCharacteristic(participant.speedCheck.ref.key),await roll.toMessage(),participant.data.speedCheck.rollDataString=roll.JSONRollString):participant.speedCheck.isSkill?(roll.skill=participant.speedCheck.ref,await roll.roll(),await roll.toMessage(),participant.data.speedCheck.rollDataString=roll.JSONRollString):participant.speedCheck.isAttribute&&(await roll.rollAttribute(participant.speedCheck.ref.key),await roll.toMessage(),participant.data.speedCheck.rollDataString=roll.JSONRollString)}else if(participant.speedCheck.score){const rollData={rawValue:participant.speedCheck.score,displayName:participant.speedCheck.name,actorName:participant.name?participant.name:void 0};participant.hasActor&&(rollData.actor=participant.actor.actorKey);const roll=CoC7Check.create(rollData);roll.parent=this.item.uuid,await roll.roll(),await roll.toMessage(),participant.data.speedCheck.rollDataString=roll.JSONRollString,participant.data.rolled=!0,participant.data.rollUuid=roll.uuid}await this.item.update({"system.participants":participants})}_onDragEnterParticipant(event){event.currentTarget.classList.add("drag-over")}_onDragLeaveParticipant(event){event.currentTarget.classList.remove("drag-over")}async _onChangeSide(event){const uuid=event.currentTarget.closest(".participant").dataset.uuid,index=this.findParticipantIndex(uuid),participants=this.item.system.participants?foundry.utils.duplicate(this.item.system.participants):[];participants[index].chaser=!participants[index].chaser,await this.item.update({"system.participants":participants})}async _onDeleteDriver(event){const uuid=event.currentTarget.closest(".driver").dataset.uuid,index=this.findParticipantIndex(uuid),participants=this.item.system.participants?foundry.utils.duplicate(this.item.system.participants):[];delete participants[index].docUuid,await this.item.update({"system.participants":participants})}async _onDeleteParticipant(event){const uuid=event.currentTarget.closest(".participant").dataset.uuid,index=this.findParticipantIndex(uuid),participants=this.item.system.participants?foundry.utils.duplicate(this.item.system.participants):[];participants.splice(index,1),await this.item.update({"system.participants":participants})}async _onResetRoll(event){const uuid=event.currentTarget.closest(".participant").dataset.uuid,index=this.findParticipantIndex(uuid),participants=this.item.system.participants?foundry.utils.duplicate(this.item.system.participants):[];delete participants[index].speedCheck.rollDataString,await this.item.update({"system.participants":participants})}async alterParticipant(data,uuid){let docUuid,actor;docUuid=data.tokenUuid?data.tokenUuid:data.sceneId&&data.tokenId?`Scene.${data.sceneId}.Token.${data.tokenId}`:data.actorId||data.actorKey||data.id,"Token"===data.type?docUuid=data.uuid:docUuid&&(actor=chatHelper.getActorFromKey(docUuid),actor||"Item"!==data.type||(docUuid=null)),actor&&docUuid!==actor.uuid&&(docUuid=actor.uuid);const participant={};switch(docUuid&&(participant.docUuid=docUuid),data.type?.toLowerCase()){case"actor":default:break;case"item":participant.speedCheck={id:data.data?._id||data.id,type:"item"};break;case"characteristic":participant.speedCheck={id:data.name,type:"characteristic"};break;case"attribute":participant.speedCheck={id:data.name,type:"attribute"}}const participants=this.item.system.participants?foundry.utils.duplicate(this.item.system.participants):[],oldParticipant=participants[this.findParticipantIndex(uuid)];oldParticipant.mov&&delete oldParticipant.mov,foundry.utils.mergeObject(oldParticipant,participant),await this.item.update({"system.participants":participants})}async clearActiveLocationCoordinates(){await this.item.clearActiveLocationCoordinates()}async addParticipant(data){let docUuid,actor;docUuid=data.tokenUuid?data.tokenUuid:data.sceneId&&data.tokenId?`Scene.${data.sceneId}.Token.${data.tokenId}`:data.actorId||data.actorKey||data.id,"Token"===data.type?docUuid=data.uuid:docUuid&&(actor=chatHelper.getActorFromKey(docUuid),actor||"Item"!==data.type||(docUuid=null)),actor&&docUuid!==actor.uuid&&(docUuid=actor.uuid);const participant={};switch(docUuid&&(participant.docUuid=docUuid),data.type?.toLowerCase()){case"actor":default:break;case"item":if(data.id){const item=game.items.get(data.id);if("skill"!==item?.data?.type)return}participant.speedCheck={id:data.data?._id||data.id,type:"item"};break;case"characteristic":participant.speedCheck={id:data.name,type:"characteristic"};break;case"attribute":participant.speedCheck={id:data.name,type:"attribute"}}participant.speedCheck||(this.item.system.vehicle?participant.speedCheck={type:"item",name:game.i18n.localize("CoC7.CoCIDFlag.keys.i.skill.drive-auto")}:participant.speedCheck={id:"con",type:"characteristic",name:game.i18n.localize("CHARAC.Constitution")});const participants=this.item.system.participants?foundry.utils.duplicate(this.item.system.participants):[];let unique=!1;for(;!unique;)participant.uuid=foundry.utils.randomID(16),unique=0===participants.filter((p=>p.uuid===participant.uuid)).length;participants.push(participant),await this.item.update({"system.participants":participants})}async toggleParticipantGun(participantUuid){const participants=this.item.system.participants?foundry.utils.duplicate(this.item.system.participants):[],participant=participants.find((p=>participantUuid===p.uuid));participant&&(participant.hasAGunReady=!participant.hasAGunReady,await this.item.setchaseTrackScroll({render:!1}),await this.item.updateParticipants(participants))}}function clean(obj){for(const propName in obj){const tp=foundry.utils.getType(obj[propName]);"Object"===tp&&(obj[propName]=clean(obj[propName])),("Object"!==tp||Object.entries(obj[propName]).length)&&("string"!==tp||obj[propName].length)?"string"!==tp||isNaN(Number(obj[propName]))||(obj[propName]=Number(obj[propName])):obj[propName]=null}return obj}class CoC7Canvas{static get COC7_TYPES_SUPPORTED(){return["CoC7Link","locator","getToken"]}static async onDropSomething(canvas,data){if(data.type&&CoC7Canvas.COC7_TYPES_SUPPORTED.includes(data.type)){const gridSize=canvas.scene.grid.size,x=data.x-gridSize/2,y=data.y-gridSize/2,height=gridSize,width=gridSize;let dropTargetTokens=canvas.tokens.placeables.filter((obj=>{const c=obj.center;return Number.between(c.x,x,x+width)&&Number.between(c.y,y,y+height)}));switch(dropTargetTokens.length||(dropTargetTokens=canvas.tokens.controlled),data.type){case"CoC7Link":if(data.check===CoC7Link.CHECK_TYPE.EFFECT){if(dropTargetTokens.length)for(const token of dropTargetTokens)CoC7Link._onLinkActorClick(token.actor,data)}else dropTargetTokens.length?CoC7Link.toWhisperMessage(data,dropTargetTokens.filter((t=>t.actor.owners.length)).map((t=>t.actor))):CoC7Link.toWhisperMessage(data,game.users.players.filter((u=>!!u.character)).map((u=>u.character)));break;case"getToken":void 0!==data.appId&&"string"==typeof data.callBack&&void 0!==ui.windows[data.appId]&&"function"==typeof ui.windows[data.appId][data.callBack]&&ui.windows[data.appId][data.callBack](dropTargetTokens);break;default:if(data.docUuid&&data.callBack){const doc=CoC7Utilities.SfromUuid(data.docUuid);if(doc[data.callBack]&&"function"==typeof doc[data.callBack])try{data.scene=canvas.scene.uuid,doc[data.callBack](data)}catch(error){console.warn(error.message)}}}}}}function get_header_controls_journal_entry_sheet(application,buttons){addCoCIDSheetHeaderButton(buttons,application)}function get_header_controls_macro_config(application,buttons){addCoCIDSheetHeaderButton(buttons,application)}function get_header_controls_playlist_config(application,buttons){addCoCIDSheetHeaderButton(buttons,application)}function get_header_controls_roll_table_sheet(application,buttons){addCoCIDSheetHeaderButton(buttons,application)}function get_header_controls_scene_config(application,buttons){addCoCIDSheetHeaderButton(buttons,application)}const nameCharacters="\\u3000\\u3400-\\u4DBF\\u3040-\\u30FF\\u4E00-\\u9FFF\\w\\(\\)\\-\\/&\"'･（）／"+CoC7Utilities.quoteRegExp("áéíóàèìòùÀÈÌÒÙáéíóúýÁÉÍÓÚÝâêîôûÂÊÎÔÛãñõÃĀÑÕäëïöüÿÄËÏÖÜŸàèçÇßØøÅåÆæœ“”«»ąćęłńóśźżĄĆĘŁŃÓŚŹŻ"),keys={en:{description:"CoC7.English",dbNone:"none",armorNone:"none",attacksPerRoundNone:"none",sanLossNone:"none",fulldb:"(Damage Bonus|DB)",halfdb:"(½|half)",sectionCombats:"\n(?:combat|fighting attacks)[:\n]",newCombatHeader:"\nCombat\n",sectionSkills:"\n(?:skills(?:\\s*\\([^\\)]+\\))?)[:\n]",sectionLangauges:"\n(?:languages)[:\n]",sectionSpells:"\n(?:spells)[:\n]",handgun:"(?<type> Gun|Revolver|Pistol|Handgun|Derringer|Beretta|Luger|Desert Eagle|(^| )\\.38)",rifle:"(?<type>Rifle|Shotgun|Carbine|Gauge |Lee-Enfield|Elephant)",smb:"(?<type>Submachine Gun|Thompson)",machineGun:"(?<type>Browning|Vickers)",launched:"(?<type>Molotov|Grenade|Dynamite)",example:"Example Character, age 27\nSTR 75 CON 60 SIZ 80 DEX 70 APP 60 INT 80\nPOW 50 EDU 85 SAN 55 HP 14 DB: 1D4\nBuild: 1 Move: 7 MP: 10 Luck: 40 Armor: 1\nAttacks per round: 3 SAN loss: 1d4/1d8\nCombat\nBite 50% (25/10), damage 1D6\nBrawl 30% (15/6), damage 1D3\nDerringer 40% (20/8), damage 1D8+1\nDodge 50% (25/10)\nSkills\nAnimal Handling 55%, Charm 30%, First Aid 25%, Disguise 20%,\nListen 50%, Medicine 45%, Persuade 25%, Psychology 75%,\nScience (Astronomy) 90%, Science (Botany) 35%, Science (Zoology) 10%,\nSpot Hidden 35%, Stealth 10%\nLanguages: English 80%, Eklo 5%.\nSpells: Summon NPC, Dispel NPC."},de:{description:"CoC7.German",dbNone:"none",armorNone:"none",attacksPerRoundNone:"none",sanLossNone:"none",diceShort:"w|d",fulldb:"(Schadensbonus|Sb)",halfdb:"(½|1/2 Schadensbonus|Sb/2)",sectionCombats:"\n(?:Kampf|Angriff:|ANGRIFFE)[:\n]",newCombatHeader:"\nKampf\n",sectionSkills:"\n(?:Fertigkeiten(?:\\s*\\([^\\)]+\\))?)[:\n]",sectionLangauges:"\n(?:Sprachen)[:\n]",sectionSpells:"\n(?:Zauber)[:\n]",handgun:"(?<type> Gun|Revolver|Pistole|Handgun|Derringer|Beretta|Luger|Desert Eagle| \\.38)",rifle:"(?<type>Gewehr|Schrotflinte|Carabiner|Karabiner|Gauge |Lee-Enfield|Elefanten)",smb:"(?<type>Submachine Gun|Thompson)",machineGun:"(?<type>Browning|Vickers)",launched:"(?<type>Molotov|Granate|Dynamit)",example:"Vorname Nachname\nAlter: 29\nBeruf: Ein Beruf\nST 50\nMA 60\nKO 60\nGE 60\nGR 55\nER 65\nIN 80\nBI 85\nTrefferpunkte: 11\nGeistige Stabilität: 60\nSchadensbonus: 0\nStatur: 0\nMagiepunkte: 12\nBewegungsweite: 8\n\nKampf\nAngriffe: 1\nHandgemenge 30% (15/6), Schaden 1D3\nMesser 30% (15/6), Schaden 1D4\nAusweichen 30% (15/6)\n\nFertigkeiten: Anthropologie 70% (35/14), Archäologie 30% (15/6), Bibliotheksnutzung 50% (25/10), Erste Hilfe 50% (25/10), Finanzkraft 40% (20/8), Geschichte 60% (30/12), Klettern 50% (25/10)\n\nSprachen: Englisch 85% (42/17); Deutsch 45% (22/9), Latein 45% (22/9)"},pl:{description:"CoC7.Polish",dbNone:"brak",armorNone:"brak",attacksPerRoundNone:"brak",sanLossNone:"brak",diceShort:"k|d",fulldb:"(Modyfikator Obrażeń|MO)",halfdb:"(½|1/2 MO|MO/2)",sectionCombats:"\n(?:Walka|Ataki)[:\n]",newCombatHeader:"\nWalka\n",sectionSkills:"\n(?:Umiejętności(?:\\s*\\([^\\)]+\\))?)[:\n]",sectionLangauges:"\n(?:Języki)[:\n]",sectionSpells:"\n(?:Zaklęcia)[:\n]",handgun:"(?<type> Pistolet|Rewolwer|Derringer|Beretta|Luger|Desert Eagle| \\.38)",rifle:"(?<type>Karabin|Strzelba|Wiatrówka|Garand|Gauge |Lee-Enfield|Strzelba na słonie)",smb:"(?<type>Pistolet maszynowy|Thompson)",machineGun:"(?<type>Browning|Vickers)",launched:"(?<type>Mołotowa|Granat|Laska dynamitu|Dynamit)",example:"Przykładowa postać, 27 lat\nBibliotekarz\nS 75 KON 60 BC 80 ZR 70 WYG 60 INT 80\nMOC 50 WYK 85 P 55 PW 14 MO: 1D4\nKrzepa: 1 Ruch: 7 PM: 10 Szczęście: 40 Pancerz: 1\nAtaki w rundzie: 3 Utrata Poczytalności: 1K4/1K8\nWalka\nUgryzienie 50% (25/10), obrażenia 1K6\nWalka 30% (15/6), obrażenia 1K3\nDerringer 40% (20/8), obrażenia 1K8+1\nUnik 50% (25/10)\nUmiejętności\nTresura Zwierząt 55%, Urok Osobisty 30%, Pierwsza Pomoc 25%, Ukrywanie 20%,\nNasłuchiwanie 50%, Medycyna 45%, Przekonywanie 25%, Psychologia 75%,\nNauka (Astronomia) 90%, Nauka (Botanika) 35%, Nauka (Zoologia) 10%,\nSpostrzegawczość 35%, Ukrywanie 10%\nJęzyki: Angielski 80%, Eklo 5%.\nZaklęcia: Przyzwanie NPC, Odesłanie NPC."},fr:{description:"CoC7.French",dbNone:"Acune",armorNone:"(?:Acune|aucune)",attacksPerRoundNone:"Acune",sanLossNone:"Acune",fulldb:"(BD|Bonus aux dommages|Impact|Imp)",halfdb:"(½|1/2 Imp|Imp/2)",sectionCombats:"\n(?:Combat|Armes|Attaques)[:\n]",newCombatHeader:"\nCombat\n",sectionSkills:"\n(?:Compétences(?:\\s*\\([^\\)]+\\))?)[:\n]",sectionLangauges:"\n(?:Langues?)\\s*[:\n]",sectionSpells:"\n(?:Sortilèges\\s*|Sorts)[:\n]",handgun:"(?<type>Revolver|Pistolet|Derringer|Beretta|Luger|Desert Eagle| \\.38)",rifle:"(?<type>Carabine|Lee-Enfield|Fusil)",smb:"(?<type>SMG|Thompson)",machineGun:"(?<type>Browning|Vickers|Mitrailleuse)",launched:"(?<type>Boomerang de guerre|Javeline|Pierre|Shuriken|Bâton de dynamite|Cocktail Molotov|Grenade à main|Molotov|Grenade|Dynamite)",example:"Example Character, 27 ans\nFOR 75 CON 60 TAI 80 DEX 70 APP 60 INT 80\nPOU 50 ÉDU 85 SAN 55 PV 14 BD: 1D4\nCarrure: 1 Mvt: 7 PM: 10 Chance: 40 Armure: 1\nAttaques par round 3 Perte de SAN: 1d4/1d8\nAttaques\nBite 50% (25/10), dommage 1D6\nBrawl 30% (15/6), dommage 1D3\nDerringer 40% (20/8), dommage 1D8+1\nEsquiver 50% (25/10)\nCompétences\nAnimal Handling 55%, Charm 30%, First Aid 25%, Disguise 20%,\nListen 50%, Medicine 45%, Persuade 25%, Psychology 75%,\nScience (Astronomy) 90%, Science (Botany) 35%, Science (Zoology) 10%,\nSpot Hidden 35%, Stealth 10%\nLangue: English 80%, Eklo 5%.\nSortilèges: Summon NPC, Dispel NPC."},es:{description:"CoC7.Spanish",dbNone:"ninguna",armorNone:"ninguna",attacksPerRoundNone:"ninguno",sanLossNone:"no",fulldb:"(BD|bd|bonificación de daño)",halfdb:"(½|medio daño|mitad|daño a la mitad)",sectionCombats:"\n(?:Combate|Armas)[:\n]",newCombatHeader:"\nCombate\n",sectionSkills:"\n(?:Habilidades(?:\\s*\\([^\\)]+\\))?)[:\n]",sectionLangauges:"\n(?:Idiomas|Lenguajes|Lenguas)[:\n]",sectionSpells:"\n(?:Conjuros|Hechizos)[:\n]",handgun:"(?<type>Revolver|Pistola|Derringer|Beretta|Luger|Desert Eagle| \\.38)",rifle:"(?<type>Rifle|Carabina|Lee-Enfield|Caza Elefantes|Fusil|Escopeta|Galga|Recortada)",smb:"(?<type>Subfusil|Thompson)",machineGun:"(?<type>Browning|Vickers|Ametralladora)",launched:"(?<type>Molotov|Granada|Dinamita)",example:"Example Character, 27 años\nFUE 75 CON 60 TAM 80 DES 70 APA 60 INT 80\nPOD 50 EDU 85 COR 55 PV 14 BD: 1D4\nCorpulencia: 1 Movimiento: 7 PM: 10 Suerte: 40 Armadura: 1\nNúmero de Ataques 3 Pérdida de cordura: 1d4/1d8\nCombate\nBite 50% (25/10), daño 1D6\nBrawl 30% (15/6), daño 1D3\nDerringer 40% (20/8), daño 1D8+1\nEsquivar 50% (25/10)\nHabilidades\nAnimal Handling 55%, Charm 30%, First Aid 25%, Disguise 20%,\nListen 50%, Medicine 45%, Persuade 25%, Psychology 75%,\nScience (Astronomy) 90%, Science (Botany) 35%, Science (Zoology) 10%,\nSpot Hidden 35%, Stealth 10%\nIdiomas: English 80%, Eklo 5%.\nConjuros: Summon NPC, Dispel NPC."},"zh-TW":{description:"CoC7.TraditionalChinese",dbNone:"none",armorNone:"none",attacksPerRoundNone:"none",sanLossNone:"none",fulldb:"(Damage Bonus|DB|傷害加值)",halfdb:"(½|half)",sectionCombats:"\n(?:combat|fighting attacks|戰鬥技能|戰鬥列表|武器)[:\n]",newCombatHeader:"\nCombat\n",sectionSkills:"\n(?:(?:Skills|技能列表)(?:\\s*\\([^\\)]+\\))?)[:\n]",sectionLangauges:"\n(?:Languages|語言)[:\n]",sectionSpells:"\n(?:spells|咒文列表|咒文)[:\n]",handgun:"(?<type> 遂發槍|\\.22短口自動手槍|\\.25短口手槍(單管)|\\.32或7\\.65mm左輪手槍|\\.32或7\\.65mm自動手槍|\\.357 Magnum左輪手槍|\\.38或9mm左輪手槍|\\.38自動手槍|貝雷塔M9|格洛克17|9mm自動手槍|魯格P08|\\.41左輪手槍|\\.44馬格南左輪手槍|\\.45左輪手槍|\\.45自動手槍|沙漠之鷹|Gun|Revolver|Pistol|Handgun|Derringer|Beretta|Luger|Desert Eagle| \\.38)",rifle:"(?<type>步槍|卡賓槍|半自動步槍|獵象槍|Rifle|Shotgun|Carbine|Gauge |Lee-Enfield|Elephant)",smb:"(?<type>Submachine Gun|Thompson|衝鋒槍)",machineGun:"(?<type>Browning|Vickers|機槍)",launched:"(?<type>Molotov|Grenade|Dynamite爆炸物|手榴彈|重武器)",example:"示範角色, 年齡 27\n力量 75 體質 60 體型 80 敏捷 70 外貎 60 智力 80\n意志 50 教育 85 SAN 55 HP 14 DB: 1D4\n體格: 1 Move: 7 MP: 10 幸運: 40 護甲: 1\n攻擊次數: 3 理智喪失: 1d4/1d8\n戰鬥列表\n咬 50% (25/10), 傷害 1D6\n空手 30% (15/6), 傷害 1D3\n手槍 40% (20/8), 傷害 1D8+1\n閃避 50% (25/10)\n技能列表\n動物馴養 55%, 取悅 30%, 急救 25%, 潛行 20%,\n聆聽 50%, 藥學 45%, 精神分析 25%, 心理學 75%,\n科學 (司法科學) 90%, 科學 (密碼學) 35%, \n偵查 35%, 喬裝 10%\n語言: 粵語 80%, 讀唇 5%.\n咒文: 召喚 NPC, 指揮 NPC."},ja:{description:"CoC7.Japanese",dbNone:"なし",armorNone:"なし",attacksPerRoundNone:"なし",sanLossNone:"なし",fulldb:"(Damage Bonus|DB|db|ダメージ(・|･)?ボーナス)",halfdb:"(½|half)",sectionCombats:"\n(?:combat|fighting attacks|戦闘|武器)[:：\n]",newCombatHeader:"\n戦闘\n",sectionSkills:"\n(?:(?:Skills|技能)\\s*(?:\\s*\\([^\\)]+\\))?)[:：\n]",sectionLangauges:"\n(?:Languages|言語)\\s*[:：\n]",sectionSpells:"\n(?:spells|呪文)\\s*[:：\n]",handgun:"(?<type>拳銃|オートマチック|リボルバー|デリンジャー|ベレッタ|ルガー|デザート(・|･)?イーグル|Gun|Revolver|Pistol|Handgun|Derringer|Beretta|Luger|Desert Eagle| \\.38)",rifle:"(?<type>ライフル|ショットガン|カービン|ゲージ|リー＝エンフィールド|エレファント(・|･)?ガン|Rifle|Shotgun|Carbine|Gauge |Lee-Enfield|Elephant)",smb:"(?<type>サブマシンガン|トンプソン|Submachine Gun|Thompson)",machineGun:"(?<type>ブローニング|ヴッカース|マシンガン|Browning|Vickers)",launched:"(?<type>モロトフ|グレネード|ダイナマイト|Molotov|Grenade|Dynamite)",example:"サンプル 太郎、27歳、記者\nSTR 75 CON 60 SIZ 80 DEX 70 APP 60 INT 80\nPOW 50 EDU 85 正気度 55 耐久力 14 ダメージ・ボーナス：1D4\nビルド：1 移動：7 マジック・ポイント：10 幸運：40 装甲：1\n1ラウンドの攻撃回数：3 正気度喪失：1D4/1D8\n戦闘\n噛みつき 50% (25/10)、ダメージ 1D6\n格闘 30% (15/6)、ダメージ 1D3+DB\nデリンジャー 40% (20/8)、ダメージ 1D8+1\n回避 50% (25/10)\n技能\n言いくるめ 25%、医学 45%、隠密 10%、\n聞き耳 50%、説得 25%、心理学 75%、\n科学 (天文学) 90%、科学 (植物学) 35%、科学 (動物学) 10%、\n動物使い 55%、変装 20%、目星 35%、魅惑 30%。\n言語：英語 80%、アクロ語 5%。\n呪文：NPCの召喚、NPCの退散。"}},translations={en:{age:"(?<![a-z])age(\\s*:)?\\s+(?<age>\\d+)[,\\s]*",occupation:"[,\\s]*Occupation(\\s*:)?\\s+(?<occupation>.+)[,\\s\n]*",str:"(?<![a-z])STR(\\s*:)?\\s*(?<str>\\d+|-)[,\\s\n]*",con:"(?<![a-z])CON(\\s*:)?\\s*(?<con>\\d+|-)[,\\s\n]*",siz:"(?<![a-z])SIZ(\\s*:)?\\s*(?<siz>\\d+|-)[,\\s\n]*",int:"(?<![a-z])INT(\\s*:)?\\s*(?<int>\\d+|-)[,\\s\n]*",pow:"(?<![a-z])POW(\\s*:)?\\s*(?<pow>\\d+|-)[,\\s\n]*",dex:"(?<![a-z])DEX(\\s*:)?\\s*(?<dex>\\d+|-)[,\\s\n]*",app:"(?<![a-z])APP(\\s*:)?\\s*(?<app>\\d+|-)[,\\s\n]*",edu:"(?<![a-z])EDU(\\s*:)?\\s*(?<edu>\\d+|-)[,\\s\n]*",san:"(?<![a-z])(?:SAN|Sanity)(\\s*:)?\\s*(?<san>\\d+|-)[,\\s\n]*",hp:"(?<![a-z])(?:HP|Hit points)(\\s*:)?\\s*(?<hp>\\d+|-)[,\\s\n]*",mp:"(?<![a-z])(?:MP|Magic points)(\\s*:)?\\s*(?<mp>\\d+|-)[,\\s\n]*",db:"(?<![a-z])(?:"+keys.en.fulldb+")(\\s*:)?\\s+(?<db>[+-]?\\d+(?:d\\d+|D\\d+)?|"+keys.en.dbNone+")[,\\s\n]*",build:"(?<![a-z])Build(\\s*:)?\\s+(?<build>[+-]?\\d+)[,\\s\n]*",armor:"(?<![a-z])Armor(\\s*:)?\\s+(?<armor>"+keys.en.armorNone+"|\\d+)[,\\s\n]*",mov:"(?<![a-z])Move(\\s*:)?\\s*(?<mov>\\d+)[,\\s\n]*",lck:"(?<![a-z])Luck(\\s*:)?\\s+(?<lck>\\d+|-)[,\\s\n]*",attacksPerRound:"(?<![a-z])(?:Attacks per round|# Attacks)(\\s*:)?\\s+(?<attacksPerRound>"+keys.en.attacksPerRoundNone+"|\\d+(?!d))[,\\s\n]*",sanLoss:"(?<![a-z])(?:Sanity loss|SAN loss)(\\s*:)?\\s+(?<sanLoss>"+keys.en.sanLossNone+"|\\dD?[+\\d]*\\/\\dD?[+\\d]*)[,\\s\n]*",weapon:"(^|\\n)(?<name>[.\\t "+nameCharacters+"]+)(\\**,?\\s+|\\*)(?:\\(|(?<percentage>\\d+)%,?(?:\\s*\\(\\d+\\/\\d+\\)\\s*,?)?)?(\\s*damage)?\\s+(?<damage>(:?(:?\\d+d)?\\d+(\\s*/\\s*|\\s*[+-]\\s*(?:"+keys.en.fulldb+"|"+keys.en.halfdb+")\\s*|\\s*[+-]\\s*(:?\\d+d)?\\d+)*)+)\\)?",weaponDodge:"(?<name>Dodge)(\\s*:)?\\s+\\(?(?<percentage>\\d+)\\)?\\s*%(?:\\s*\\(\\d+\\/\\d+\\))?",skill:"^(?<name>[:\\*.\\s"+nameCharacters+"]+(?<!The player has|but they regenerate))\\s+\\(?(?<percentage>\\d+)[^d]%?\\)?(\\s*\\(\\d+/\\d+\\))?[\\.,]?\\s*",guessStartCombat:"(^|(?<!,)\n)(Fighting|Firearms|Brawl|Bite)",name:"^(?<name>[\\.\\s"+nameCharacters+"]+)[,\\s\n]+",sections:"("+keys.en.sectionCombats+"|"+keys.en.sectionSkills+"|"+keys.en.sectionLangauges+"|"+keys.en.sectionSpells+")"},de:{age:"(?<![a-z])Alter(\\s*:)?\\s+(?<age>\\d+)[,\\s]*",occupation:"[,\\s]*Beruf(\\s*:)?\\s+(?<occupation>.+)[,\\s\n]*",str:"(?<![a-z])ST(\\s*:)?\\s*(?<str>\\d+|-)[,\\s\n]*",con:"(?<![a-z])KO(\\s*:)?\\s*(?<con>\\d+|-)[,\\s\n]*",siz:"(?<![a-z])GR(\\s*:)?\\s*(?<siz>\\d+|-)[,\\s\n]*",int:"(?<![a-z])IN(\\s*:)?\\s*(?<int>\\d+|-)[,\\s\n]*",pow:"(?<![a-z])MA(\\s*:)?\\s*(?<pow>\\d+|-)[,\\s\n]*",dex:"(?<![a-z])GE(\\s*:)?\\s*(?<dex>\\d+|-)[,\\s\n]*",app:"(?<![a-z])ER(\\s*:)?\\s*(?<app>\\d+|-)[,\\s\n]*",edu:"(?<![a-z])BI(\\s*:)?\\s*(?<edu>\\d+|-)[,\\s\n]*",san:"(?<![a-z])(?:gS|STA|Geistige Stabilität)(\\s*:)?\\s*(?<san>\\d+|-)[,\\s\n]*",hp:"(?<![a-z])(?:TP|Trefferpunkte)(\\s*:)?\\s*(?<hp>\\d+|-)[,\\s\n]*",mp:"(?<![a-z])(?:MP|Magiepunkte)(\\s*:)?\\s*(?<mp>\\d+|-)[,\\s\n]*",db:"(?<![a-z])(?:"+keys.de.fulldb+")(\\s*:)?\\s+(?<db>[+-]?\\d+(?:d\\d+|D|W\\d+)?|"+keys.de.dbNone+")[,\\s\n]*",build:"(?<![a-z])(?:Statur|Stat.)(\\s*:)?\\s+(?<build>[+-]?\\d+)[,\\s\n]*",armor:"(?<![a-z])Panzerung(\\s*:)?\\s+(?<armor>"+keys.de.armorNone+"|\\d+)[,\\s\n]*",mov:"(?<![a-z])(?:BW|Bewegungsweite)(\\s*:)?\\s*(?<mov>\\d+)[,\\s\n]*",lck:"(?<![a-z])Glück(\\s*:)?\\s+(?<lck>\\d+|-)[,\\s\n]*",attacksPerRound:"(?<![a-z])(?:Angriffe pro Runde|Angriffe|Pro Runde)(\\s*:)?\\s+(?<attacksPerRound>"+keys.de.attacksPerRoundNone+"|\\d+(?!d))[,\\s\n]*",sanLoss:"(?<![a-z])(?:Stabilitätsverlust)(\\s*:)?\\s+(?<sanLoss>"+keys.de.sanLossNone+"|\\d[DW]?[+\\d]*\\/\\d[DW]?[+\\d]*)[,\\s\n]*",weapon:"(^|\\n)(?<name>[.\\t "+nameCharacters+"]+)(\\**,?\\s+|\\*)(?:\\(|(?<percentage>\\d+)%,?(?:\\s*\\(\\d+\\/\\d+\\)\\s*,?)?)?(\\s*Schaden)?\\s+(?<damage>(:?(:?\\d+w|d)?\\d+(\\s*/\\s*|\\s*[+-]\\s*(?:"+keys.de.fulldb+"|"+keys.de.halfdb+")\\s*|\\s*[+-]\\s*(:?\\d+d|w)?\\d+)*)+)\\)?",weaponDodge:"(?<name>Ausweichen)(\\s*:)?\\s+\\(?(?<percentage>\\d+)\\)?\\s*%(?:\\s*\\(\\d+\\/\\d+\\))?",skill:"^(?<name>[:\\*.\\s"+nameCharacters+"]+(?<!The player has|but they regenerate))\\s+\\(?(?<percentage>\\d+)[^d]%?\\)?(\\s*\\(\\d+/\\d+\\))?[\\.,;]?\\s*",guessStartCombat:"(^|(?<!,)\n)(Angriffe|Handgemenge|Nahkampf|Faustfeuerwaffe|Beißen)",name:"^(?<name>[\\.\\s"+nameCharacters+"]+)[,\\s\n]+",sections:"("+keys.de.sectionCombats+"|"+keys.de.sectionSkills+"|"+keys.de.sectionLangauges+"|"+keys.de.sectionSpells+")"},pl:{age:"(?<age>\\d+)\\s+(?:lata|lat|rok)[,\\s]*",occupation:"[,\\s]*Zawód(\\s*:)?\\s+(?<occupation>.+)[,\\s\n]*",str:"(?<![a-z])S(\\s*:)?\\s*(?<str>\\d+|-)[,\\s\n]*",con:"(?<![a-z])KON(\\s*:)?\\s*(?<con>\\d+|-)[,\\s\n]*",siz:"(?<![a-z])BC(\\s*:)?\\s*(?<siz>\\d+|-)[,\\s\n]*",int:"(?<![a-z])INT(\\s*:)?\\s*(?<int>\\d+|-)[,\\s\n]*",pow:"(?<![a-z])MOC(\\s*:)?\\s*(?<pow>\\d+|-)[,\\s\n]*",dex:"(?<![a-z])ZR(\\s*:)?\\s*(?<dex>\\d+|-)[,\\s\n]*",app:"(?<![a-z])WYG(\\s*:)?\\s*(?<app>\\d+|-)[,\\s\n]*",edu:"(?<![a-z])WYK(\\s*:)?\\s*(?<edu>\\d+|-)[,\\s\n]*",san:"(?<![a-z])(?:P|Poczytalność)(\\s*:)?\\s*(?<san>\\d+|-)[,\\s\n]*",hp:"(?<![a-z])(?:PW|Punkty Wytrzymałości)(\\s*:)?\\s*(?<hp>\\d+|-)[,\\s\n]*",mp:"(?<![a-z])(?:PM|Punkty Magii)(\\s*:)?\\s*(?<mp>\\d+|-)[,\\s\n]*",db:"(?<![a-z])(?:"+keys.pl.fulldb+")(\\s*:)?\\s+(?<db>[+-]?\\d+(?:d\\d+|D|K\\d+)?|"+keys.pl.dbNone+")[,\\s\n]*",build:"(?<![a-z])Krzepa(\\s*:)?\\s+(?<build>[+-]?\\d+)[,\\s\n]*",armor:"(?<![a-z])Pancerz(\\s*:)?\\s+(?<armor>"+keys.pl.armorNone+"|\\d+)[,\\s\n]*",mov:"(?<![a-z])Ruch(\\s*:)?\\s*(?<mov>\\d+)[,\\s\n]*",lck:"(?<![a-z])Szczęście(\\s*:)?\\s+(?<lck>\\d+|-)[,\\s\n]*",attacksPerRound:"(?<![a-z])(?:Ataki w rundzie|# Ataki)(\\s*:)?\\s+(?<attacksPerRound>"+keys.pl.attacksPerRoundNone+"|\\d+(?!d))[,\\s\n]*",sanLoss:"(?<![a-z])(?:Utrata Poczytalności|utrata P)(\\s*:)?\\s+(?<sanLoss>"+keys.pl.sanLossNone+"|\\d[DK]?[+\\d]*\\/\\d[DK]?[+\\d]*)[,\\s\n]*",weapon:"(^|\\n)(?<name>[.\\t "+nameCharacters+"]+)(\\**,?\\s+|\\*)(?:\\(|(?<percentage>\\d+)%,?(?:\\s*\\(\\d+\\/\\d+\\)\\s*,?)?)?(\\s*obrażenia)?\\s+(?<damage>(:?(:?\\d+k|d)?\\d+(\\s*/\\s*|\\s*[+-]\\s*(?:"+keys.pl.fulldb+"|"+keys.pl.halfdb+")\\s*|\\s*[+-]\\s*(:?\\d+d)?\\d+)*)+)\\)?",weaponDodge:"(?<name>Unik)(\\s*:)?\\s+\\(?(?<percentage>\\d+)\\)?\\s*%(?:\\s*\\(\\d+\\/\\d+\\))?",skill:"^(?<name>[:\\*.\\s"+nameCharacters+"]+(?<!The player has|but they regenerate))\\s+\\(?(?<percentage>\\d+)[^d]%?\\)?(\\s*\\(\\d+/\\d+\\))?[\\.,]?\\s*",guessStartCombat:"(^|(?<!,)\n)(Walka|Broń Palna|Bijatyka|Ugryzienie)",name:"^(?<name>[\\.\\s"+nameCharacters+"]+)[,\\s\n]+",sections:"("+keys.pl.sectionCombats+"|"+keys.pl.sectionSkills+"|"+keys.pl.sectionLangauges+"|"+keys.pl.sectionSpells+")"},fr:{age:"(?<age>\\d+)\\s*ans(?![a-z])[,\\s]*",occupation:"[,\\s]*Occupation(\\s*:)?\\s+(?<occupation>.+)[,\\s\n]*",str:"(?<![a-z])FOR(\\s*:)?\\s*(?<str>\\d+|-)[,\\s\n]*",con:"(?<![a-z])CON(\\s*:)?\\s*(?<con>\\d+|-)[,\\s\n]*",siz:"(?<![a-z])TAI(\\s*:)?\\s*(?<siz>\\d+|-)[,\\s\n]*",int:"(?<![a-z])INT(\\s*:)?\\s*(?<int>\\d+|-)[,\\s\n]*",pow:"(?<![a-z])POU(\\s*:)?\\s*(?<pow>\\d+|-)[,\\s\n]*",dex:"(?<![a-z])DEX(\\s*:)?\\s*(?<dex>\\d+|-)[,\\s\n]*",app:"(?<![a-z])APP(\\s*:)?\\s*(?<app>\\d+|-)[,\\s\n]*",edu:"(?<![a-z])ÉDU(\\s*:)?\\s*(?<edu>\\d+|-)[,\\s\n]*",san:"(?<!([a-z]|de\\s))(?:SAN|Santé Mentale)(\\s*:)?\\s*(?<san>\\d+|-)[,\\s\n]*",hp:"(?<![a-z])(?:PV|Points de vie)(\\s*:)?\\s*(?<hp>\\d+|-)[,\\s\n]*",mp:"(?<![a-z])(?:PM|Points de magie)(\\s*:)?\\s*(?<mp>\\d+|-)[,\\s\n]*",db:"(?<![a-z])(?:"+keys.fr.fulldb+")(\\s*:)?\\s+(?<db>[+-]?\\d+(?:d\\d+|D\\d+)?|"+keys.fr.dbNone+")[,\\s\n]*",build:"(?<![a-z])Carrure(\\s*:)?\\s+(?<build>[+-]?\\d+)[,\\s\n]*",armor:"(?<![a-z])(?:Armure|Protection)(\\s*:)?\\s+(?<armor>"+keys.fr.armorNone+"|\\d+)[,\\s\n]*",mov:"(?<![a-z])(?:Mvt|Mouvement|Déplacement)(\\s*:)?\\s*(?<mov>\\d+)[,\\s\n]*",lck:"(?<![a-z])Chance(\\s*:)?\\s+(?<lck>\\d+|-)[,\\s\n]*",attacksPerRound:"(?<![a-z])(?:Attaques par round)(\\s*:)?\\s+(?<attacksPerRound>"+keys.fr.attacksPerRoundNone+"|\\d+(?!d))[,\\s\n]*",sanLoss:"(?<![a-z])(?:Perte de Santé mentale|Perte de SAN)(\\s*:)?\\s+(?<sanLoss>"+keys.fr.sanLossNone+"|\\dD?[+\\d]*\\/\\dD?[+\\d]*)[,\\s\n]*",weapon:"(^|\\n)(?<name>[.\\t "+nameCharacters+"]+)(\\**,?\\s+|\\*)(?:\\(|(?<percentage>\\d+)%,?(?:\\s*\\(\\d+\\/\\d+\\)\\s*,?)?)?(\\s*(?:dommage|dégâts))?\\s+(?<damage>(:?(:?\\d+d)?\\d+(\\s*/\\s*|\\s*[+-]\\s*(?:"+keys.fr.fulldb+"|"+keys.fr.halfdb+")\\s*|\\s*[+-]\\s*(:?\\d+d)?\\d+)*)+)\\)?",weaponDodge:"(?<name>Esquiver?)(\\s*:)?\\s+\\(?(?<percentage>\\d+)\\)?\\s*%(?:\\s*\\(\\d+\\/\\d+\\))?",skill:"^(?<name>[:\\*.\\s"+nameCharacters+"]+(?<!The player has|but they regenerate))\\s+\\(?(?<percentage>\\d+)[^d]%?\\)?(\\s*\\(\\d+/\\d+\\))?[\\.,]?\\s*",guessStartCombat:"(^|(?<!,)\n)(Au contact|À distance|Combat rapproché|Bite)",name:"^(?<name>[\\.\\s"+nameCharacters+"]+)[,\\s\n]+",sections:"("+keys.fr.sectionCombats+"|"+keys.fr.sectionSkills+"|"+keys.fr.sectionLangauges+"|"+keys.fr.sectionSpells+")"},es:{age:"(?<age>\\d+)\\s*a[ñÑ]os(?![a-z])[,\\s]*",occupation:"[,\\s]*Ocupación(\\s*:)?\\s+(?<occupation>.+)[,\\s\n]*",str:"(?<![a-z])FUE(\\s*:)?\\s*(?<str>\\d+|-)[,\\s\n]*",con:"(?<![a-z])CON(\\s*:)?\\s*(?<con>\\d+|-)[,\\s\n]*",siz:"(?<![a-z])TAM(\\s*:)?\\s*(?<siz>\\d+|-)[,\\s\n]*",int:"(?<![a-z])INT(\\s*:)?\\s*(?<int>\\d+|-)[,\\s\n]*",pow:"(?<![a-z])POD(\\s*:)?\\s*(?<pow>\\d+|-)[,\\s\n]*",dex:"(?<![a-z])DES(\\s*:)?\\s*(?<dex>\\d+|-)[,\\s\n]*",app:"(?<![a-z])APA(\\s*:)?\\s*(?<app>\\d+|-)[,\\s\n]*",edu:"(?<![a-z])EDU(\\s*:)?\\s*(?<edu>\\d+|-)[,\\s\n]*",san:"(?<![a-z])(?:COR|Cordura)(\\s*:)?\\s*(?<san>\\d+|-)[,\\s\n]*",hp:"(?<![a-z])(?:PV|Puntos de vida|P\\. ?V\\.)(\\s*:)?\\s+(?<hp>\\d+|-)[,\\s\n]*",mp:"(?<![a-z])(?:PM|Puntos Mágicos|Puntos de Magia)(\\s*:)?\\s+(?<mp>\\d+|-)[,\\s\n]*",db:"(?<![a-z])(?:"+keys.es.fulldb+")(\\s*:)?\\s+(?<db>[+-]?\\d+(?:d\\d+|D\\d+)?|"+keys.es.dbNone+")[,\\s\n]*",build:"(?<![a-z])Corpulencia(\\s*:)?\\s+(?<build>[+-]?\\d+)[,\\s\n]*",armor:"(?<![a-z])Armadura(\\s*:)?\\s+(?<armor>"+keys.es.armorNone+"|\\d+)[,\\s\n]*",mov:"(?<![a-z])Movimiento(\\s*:)?\\s*(?<mov>\\d+)[,\\s\n]*",lck:"(?<![a-z])Suerte(\\s*:)?\\s+(?<lck>\\d+|-)[,\\s\n]*",attacksPerRound:"(?<![a-z])(?:Número de Ataques)(\\s*:)?\\s+(?<attacksPerRound>"+keys.es.attacksPerRoundNone+"|\\d+(?!d))[,\\s\n]*",sanLoss:"(?<![a-z])(?:Pérdida de cordura|Pérdida de COR)(\\s*:)?\\s+(?<sanLoss>"+keys.es.sanLossNone+"|\\dD?[+\\d]*\\/\\dD?[+\\d]*)[,\\s\n]*",weapon:"(^|\\n)(?<name>[.\\t "+nameCharacters+"]+)(\\**,?\\s+|\\*)(?:\\(|(?<percentage>\\d+)%,?(?:\\s*\\(\\d+\\/\\d+\\)\\s*,?)?)?(\\s*daño)?\\s+(?<damage>(:?(:?\\d+d)?\\d+(\\s*/\\s*|\\s*[+-]\\s*(?:"+keys.es.fulldb+"|"+keys.es.halfdb+")\\s*|\\s*[+-]\\s*(:?\\d+d)?\\d+)*)+)\\)?",weaponDodge:"(?<name>Esquivar)(\\s*:)?\\s+\\(?(?<percentage>\\d+)\\)?\\s*%(?:\\s*\\(\\d+\\/\\d+\\))?",skill:"^(?<name>[:\\*.\\s"+nameCharacters+"]+(?<!The player has|but they regenerate))\\s+\\(?(?<percentage>\\d+)[^d]%?\\)?(\\s*\\(\\d+/\\d+\\))?[\\.,]?\\s*",guessStartCombat:"(^|(?<!,)\n)(Combatir|Armas de fuego|Pelea|Mordisco)",name:"^(?<name>[\\.\\s"+nameCharacters+"]+)[,\\s\n]+",sections:"("+keys.es.sectionCombats+"|"+keys.es.sectionSkills+"|"+keys.es.sectionLangauges+"|"+keys.es.sectionSpells+")"},"zh-TW":{age:"(?<![a-z])age|年齡(\\s*:)?\\s*(?<age>\\d+)[,\\s]*",occupation:"[,\\s]*Occupation(\\s*:)?\\s+(?<occupation>.+)[,\\s\n]*",str:"(?<![a-z])STR|力量(\\s*:)?\\s*(?<str>\\d+|-)[,\\s\n]*",con:"(?<![a-z])CON|體質(\\s*:)?\\s*(?<con>\\d+|-)[,\\s\n]*",siz:"(?<![a-z])SIZ|體型(\\s*:)?\\s*(?<siz>\\d+|-)[,\\s\n]*",int:"(?<![a-z])INT|智力(\\s*:)?\\s*(?<int>\\d+|-)[,\\s\n]*",pow:"(?<![a-z])POW|意志(\\s*:)?\\s*(?<pow>\\d+|-)[,\\s\n]*",dex:"(?<![a-z])DEX|敏捷(\\s*:)?\\s*(?<dex>\\d+|-)[,\\s\n]*",app:"(?<![a-z])APP|外貎(\\s*:)?\\s*(?<app>\\d+|-)[,\\s\n]*",edu:"(?<![a-z])EDU|教育(\\s*:)?\\s*(?<edu>\\d+|-)[,\\s\n]*",san:"(?<![a-z])(?:SAN|Sanity|理智)(\\s*:)?\\s*(?<san>\\d+|-)[,\\s\n]*",hp:"(?<![a-z])(?:HP|Hit points|生命)(\\s*:)?\\s*(?<hp>\\d+|-)[,\\s\n]*",mp:"(?<![a-z])(?:MP|Magic points)(\\s*:)?\\s*(?<mp>\\d+|-)[,\\s\n]*",db:"(?<![a-z])(?:"+keys["zh-TW"].fulldb+")(\\s*:)?\\s*(?<db>[+-]?\\d+(?:d\\d+|D\\d+)?|"+keys["zh-TW"].dbNone+")[,\\s\n]*",build:"(?<![a-z])Build|體格(\\s*:)?\\s*(?<build>[+-]?\\d+)[,\\s\n]*",armor:"(?<![a-z])Armor|護甲(\\s*:)?\\s*(?<armor>"+keys["zh-TW"].armorNone+"|\\d+)[,\\s\n]*",mov:"(?<![a-z])Move(\\s*:)?\\s*(?<mov>\\d+)[,\\s\n]*",lck:"(?<![a-z])Luck|幸運(\\s*:)?\\s*(?<lck>\\d+|-)[,\\s\n]*",attacksPerRound:"(?<![a-z])(?:Attacks per round|# Attacks|攻擊次數|# 攻擊)(\\s*:)?\\s*(?<attacksPerRound>"+keys["zh-TW"].attacksPerRoundNone+"|\\d+(?!d))[,\\s\n]*",sanLoss:"(?<![a-z])(?:Sanity loss|SAN loss|理智喪失|SAN值損失|SAN值喪失|扣SAN)(\\s*:)?\\s*(?<sanLoss>"+keys["zh-TW"].sanLossNone+"|\\dD?[+\\d]*\\/\\dD?[+\\d]*)[,\\s\n]*",weapon:"(^|\\n)(?<name>[.\\t "+nameCharacters+"]+)(\\**,?\\s+|\\*)(?:\\(|(?<percentage>\\d+)%,?(?:\\s*\\(\\d+\\/\\d+\\)\\s*,?)?)?(\\s*(?:damage|傷害))?\\s+(?<damage>(:?(:?\\d+d)?\\d+(\\s*/\\s*|\\s*[+-]\\s*(?:"+keys["zh-TW"].fulldb+"|"+keys["zh-TW"].halfdb+")\\s*|\\s*[+-]\\s*(:?\\d+d)?\\d+)*)+)\\)?",weaponDodge:"(?<name>Dodge|閃避|閃躲)(\\s*:)?\\s+\\(?(?<percentage>\\d+)\\)?\\s*%?(?:\\s*\\(\\d+\\/\\d+\\))?",skill:"^(?<name>[:\\*.\\s"+nameCharacters+"]+(?<!The player has|but they regenerate))\\s+\\(?(?<percentage>\\d+)[^d]%?\\)?(\\s*\\(\\d+/\\d+\\))?[\\.,]?\\s*",guessStartCombat:"(^|(?<!,)\n)(近戰技能|射擊技能|Brawl|Bite)",name:"^(?<name>[\\.\\s"+nameCharacters+"]+)[,\\s\n]+",sections:"("+keys["zh-TW"].sectionCombats+"|"+keys["zh-TW"].sectionSkills+"|"+keys["zh-TW"].sectionLangauges+"|"+keys["zh-TW"].sectionSpells+")"},ja:{age:"[(（]?(?<age>\\d+)(\\s+)*(?:歳|才)[)）]?[,、\\s]*",occupation:"[,、\\s]*(職業)?(\\s*[:：])?\\s+(?<occupation>.+)[,、\\s\n]*",str:"(?<![a-z])STR(\\s*[:：])?\\s*(?<str>\\d+|-)[,、\\s\n]*",con:"(?<![a-z])CON(\\s*[:：])?\\s*(?<con>\\d+|-)[,、\\s\n]*",siz:"(?<![a-z])SIZ(\\s*[:：])?\\s*(?<siz>\\d+|-)[,、\\s\n]*",int:"(?<![a-z])INT(\\s*[:：])?\\s*(?<int>\\d+|-)[,、\\s\n]*",pow:"(?<![a-z])POW(\\s*[:：])?\\s*(?<pow>\\d+|-)[,、\\s\n]*",dex:"(?<![a-z])DEX(\\s*[:：])?\\s*(?<dex>\\d+|-)[,、\\s\n]*",app:"(?<![a-z])APP(\\s*[:：])?\\s*(?<app>\\d+|-)[,、\\s\n]*",edu:"(?<![a-z])EDU(\\s*[:：])?\\s*(?<edu>\\d+|-)[,、\\s\n]*",san:"(?<![a-z])(?:(SAN|Sanity|正気度))(\\s*[:：])?\\s*(?<san>\\d+|-)[,、\\s\n]*",hp:"(?<![a-z])(?:(HP|Hit points|耐久力|ヒット(・|･)?ポイント))(\\s*[:：])?\\s*(?<hp>\\d+|-)[,、\\s\n]*",mp:"(?<![a-z])(?:(MP|Magic points|マジック(・|･)?ポイント))(\\s*[:：])?\\s*(?<mp>\\d+|-)[,、\\s\n]*",db:"(?<![a-z])(?:"+keys.ja.fulldb+")(\\s*[:：])?\\s*(?<db>[+-]?\\s*\\d+(?:d\\d+|D\\d+)?|"+keys.ja.dbNone+")[,、\\s\n]*",build:"(?<![a-z])(Build|ビルド)(\\s*[:：])?\\s*(?<build>[+-]?\\d+)[,、\\s\n]*",armor:"(?<![a-z])(Armor|装甲)(\\s*[:：])?\\s*(?<armor>"+keys.ja.armorNone+"|\\d+)[,、\\s\n]*",mov:"(?<![a-z])(Move|MOV|移動率?)(\\s*[:：])?\\s*(?<mov>\\d+)[,、\\s\n]*",lck:"(?<![a-z])(Luck|幸運)(\\s*[:：])?\\s*(?<lck>\\d+|-)[,、\\s\n]*",attacksPerRound:"(?<![a-z])(?:(Attacks per round|# Attacks|((1|1 |１)ラウンドの)?攻撃回数))(\\s*[:：])?\\s*(?<attacksPerRound>"+keys.ja.attacksPerRoundNone+"|\\d+(?!d))[,、\\s\n]*",sanLoss:"(?<![a-z])(?:(Sanity loss|SAN loss|正気度喪失))(\\s*[:：]\\D*)?\\s*(?<sanLoss>"+keys.ja.sanLossNone+"|\\dD?[+\\d]*[\\/／]\\dD?[+\\d]*)[,、\\s\n]*",weapon:"(^|\\n)(?<name>[.\\t\\w "+nameCharacters+"]+)(\\**[,、]?\\s+|\\*)(?:\\(|(?<percentage>\\d+)[%％][,、]?(?:\\s*[\\(（]\\d+[\\/／]\\d+[\\)）]\\s*[,、]?)?)?(\\s*(?:damage|ダメージ))?\\s*(?<damage>(:?\\d+[dD])?\\d+(\\s*/\\s*|\\s*[+-]\\s*(?:"+keys.ja.fulldb+"|"+keys.ja.halfdb+")\\s*|\\s*[+-]\\s*(:?\\d+[dD])?\\d+)*)\\)?",weaponDodge:"(?<name>(Dodge|回避))(\\s*[:：])?\\s*\\(?(?<percentage>\\d+)\\)?\\s*[%％]?(?:\\s*[\\(（]\\d+[\\/／]\\d+[\\)）])?",skill:"^(?<name>[:\\*.\\s"+nameCharacters+"]+(?<!The player has|but they regenerate|\\d))[\\s:：]*\\(?(?<percentage>\\d+)[^d][%％]?\\)?(\\s*[\\(（]\\d+[\\/／]\\d+[\\)）])?\\s?[\\.,、]?\\s*",guessStartCombat:"(^|(?<!,)\n)(近接(戦闘|格闘)|格闘|攻撃|素手|噛みつき|射撃|Brawl|Bite)",name:"^(?<name>[\\.\\s"+nameCharacters+"]+)[,、\\s\n]+",sections:"("+keys.ja.sectionCombats+"|"+keys.ja.sectionSkills+"|"+keys.ja.sectionLangauges+"|"+keys.ja.sectionSpells+")"}};class CoC7ActorImporterRegExp{static checkLanguage(lang=null){return lang||(lang=game.i18n.lang),void 0===translations[lang]&&(lang="en"),lang}static getExampleText(lang){let example=keys.en.example;return void 0!==keys[lang]&&(example=keys[lang].example),example}static getTranslations(){const output={};for(const key in keys)output[key]=keys[key].description;return output}static getKeys(lang){return keys[lang]||keys.en}static getRegularExpressions(lang){return translations[lang]||translations.en}}class CoC7ActorImporter{constructor(){this.parsed={},this.itemLocations=""}static get asNumber(){return"n"}static get asString(){return"s"}getRegEx(regex,modifiers="iu"){return"RegExp"===regex.constructor?.name?regex:new RegExp(regex,modifiers)}cleanString(s){return"CoC7.Japanese"===this.keys.description?s.replace(/(\n|\r)/g," ").replace(/^\s*/,"").replace(/\s*[(（]\s*/g," (").replace(/\s*[)）]\s*/g,")").replace(/\s*[.。]?\s*[.。]?$/,"").replace(/^[〈《]/,"").replace(/[〉》]$/,""):s.replace(/(\n|\r)/g," ").replace(/^\s*/,"").replace(/\s*\.?\s*\.?$/,"")}translateRoll(s){if(void 0===s)return s;if(void 0!==this.keys.diceShort){const regEx=new RegExp("(?<n1>\\d+)"+this.keys.diceShort+"(?<n2>\\d+)","iug");return s.replace(regEx,"$<n1>D$<n2>")}return s}toHTML(s){return 0===s.trim().length||0===(s=s.trim().split("\n").map((text=>text.trim().replace(/^[,.\s、。]+$/,""))).filter((text=>text)).join("</p><p>")).length?"":"<p>"+s+"</p>"}check(regExKey,{removeFromText=!0,saveKeys=!0,type=CoC7ActorImporter.asString,text=!1,requiredGroup=!1}={}){let output=!1,regExp=!1;if(void 0!==this.regEx[regExKey]?regExp=this.getRegEx(this.regEx[regExKey]):void 0!==this.keys[regExKey]&&(regExp=this.getRegEx(this.keys[regExKey])),!1!==regExp){!1===text&&(text=this.text);const check=regExp.exec(text);let value=null;if(null!==check&&(!1===requiredGroup||void 0!==(check.groups||{})[requiredGroup])){if(output=check.groups||{},removeFromText&&(this.text=this.text.replace(check[0].trim(),"\n").trim()),saveKeys)for(const key of Object.keys(check.groups))switch(type){case CoC7ActorImporter.asString:this.parsed[key]=String(check.groups[key]).replace("\n"," ");break;case CoC7ActorImporter.asNumber:value=Number(check.groups[key]),isNaN(value)||(this.parsed[key]=Number(check.groups[key]))}output["-source"]=check[0],output["-index"]=check.index}}return output}processCombat(text){if(0===text.trim().length)return;let weapon,dodge,newline;CONFIG.debug.CoC7Importer&&console.log("combat text",text);let lastPercent=!1,maxLoops=40;do{if(maxLoops--,text=text.trim(),dodge=this.check("weaponDodge",{saveKeys:!1,text}))text=text.replace(dodge["-source"],"\n"),void 0===this.parsed.skills&&(this.parsed.skills=[]),this.parsed.skills.push({name:this.cleanString(dodge.name),value:Number(dodge.percentage),push:!1});else if(weapon=this.check("weapon",{saveKeys:!1,text,requiredGroup:!1===lastPercent&&"percentage"})){text=text.replace(weapon["-source"],"\n");const name=this.cleanString(weapon.name||"");let damage=this.translateRoll(this.cleanString(weapon.damage||""));const isRanged=!!(this.check("handgun",{text:name,removeFromText:!1,saveKeys:!1})||this.check("rifle",{text:name,removeFromText:!1,saveKeys:!1})||this.check("smb",{text:name,removeFromText:!1,saveKeys:!1})||this.check("machineGun",{text:name,removeFromText:!1,saveKeys:!1})||this.check("launched",{text:name,removeFromText:!1,saveKeys:!1}));let found;lastPercent=null===weapon.percentage||void 0===weapon.percentage||Number(weapon.percentage);let ahdb=!1,addb=!1;do{found=this.getRegEx("\\s*[+-]?\\s*("+this.keys.halfdb+")\\s*("+this.keys.fulldb+")?[-+]?\\s*("+this.parsed.db.replace(/^[-+]/,"")+")?").exec(damage),found?(ahdb=!0,damage=damage.replace(found[0],"")):(found=this.getRegEx("\\s*[+-]?\\s*("+this.keys.fulldb+")\\s*[-+]?\\s*("+this.parsed.db.replace(/^[-+]/,"")+")?").exec(damage),found&&(addb=!0,damage=damage.replace(found[0],"")))}while(found);const damages=damage.split("/"),isShotgun=3===damages.length,data={name,type:"weapon",system:{skill:{id:lastPercent},properties:{},range:{normal:{value:isShotgun?10:0,damage:damages[0]},long:{value:isShotgun?20:0,damage:isShotgun?damages[1]:""},extreme:{value:isShotgun?50:0,damage:isShotgun?damages[2]:""}}}};data.system.properties.shotgun=isShotgun,data.system.properties.rngd=isRanged||isShotgun,data.system.properties.melee=!data.system.properties.rngd,data.system.properties.ahdb=ahdb,data.system.properties.addb=addb,void 0===this.parsed.attacks&&(this.parsed.attacks=[]),this.parsed.attacks.push(data)}else(newline=text.match(/^(.+)\n/))?text=text.replace(newline[0],"\n"):(newline=text.match(/^[^\n]+$/))&&(text="")}while(maxLoops>0&&(weapon||dodge||text));0===maxLoops&&(ui.notifications.warn(game.i18n.localize("CoC7.ErrorUnexpectedWeaponText")),console.debug("Unexpected weapons:",text))}processSkills(text,key="skills"){if(0===text.trim().length)return;const breaks=text.split(/\.\r?\n/);let skill;breaks.length>1&&(text=breaks[0]);let maxLoops=40;do{maxLoops--,text=text.trim(),skill=this.check("skill",{saveKeys:!1,text}),skill&&(text=text.replace(skill["-source"],"\n"),void 0===this.parsed[key]&&(this.parsed[key]=[]),this.parsed[key].push({name:this.cleanString(skill.name),value:Number(skill.percentage)}))}while(maxLoops>0&&skill);0===maxLoops&&(ui.notifications.warn(game.i18n.localize("CoC7.ErrorUnexpectedSkillsText")),console.debug("Unexpected skills:",text))}processSpells(text){if(0===text.trim().length)return;const breaks=text.split(/\.\r?\n/);breaks.length>1&&(text=breaks[0]);const spellsArr=text.replace(/([\n\r]+)/g," ").split(/(?<!\([^)]+)[,、]/);this.text=this.text.replace(text.trim(),"\n");for(const spell of spellsArr)void 0===this.parsed.spells&&(this.parsed.spells=[]),this.parsed.spells.push(this.cleanString(spell))}async parseCharacter(text){this.text=String(text).trim().replace(/\u2013|\u2014|\u2212/g,"-").replace(/\u2019/g,"'").replace(/[\udbc0-\udbfe][\udc00-\udfff]/g,"");let header,min=this.text.length,check=this.check("str",{type:CoC7ActorImporter.asNumber})["-index"];if(isNaN(check)||(min=Math.min(min,check)),check=this.check("con",{type:CoC7ActorImporter.asNumber})["-index"],isNaN(check)||(min=Math.min(min,check)),check=this.check("siz",{type:CoC7ActorImporter.asNumber})["-index"],isNaN(check)||(min=Math.min(min,check)),check=this.check("int",{type:CoC7ActorImporter.asNumber})["-index"],isNaN(check)||(min=Math.min(min,check)),check=this.check("pow",{type:CoC7ActorImporter.asNumber})["-index"],isNaN(check)||(min=Math.min(min,check)),check=this.check("dex",{type:CoC7ActorImporter.asNumber})["-index"],isNaN(check)||(min=Math.min(min,check)),check=this.check("app",{type:CoC7ActorImporter.asNumber})["-index"],isNaN(check)||(min=Math.min(min,check)),check=this.check("edu",{type:CoC7ActorImporter.asNumber})["-index"],isNaN(check)||(min=Math.min(min,check)),check=this.check("san",{type:CoC7ActorImporter.asNumber})["-index"],isNaN(check)||(min=Math.min(min,check)),check=this.check("hp",{type:CoC7ActorImporter.asNumber})["-index"],isNaN(check)||(min=Math.min(min,check)),check=this.check("mp",{type:CoC7ActorImporter.asNumber})["-index"],isNaN(check)||(min=Math.min(min,check)),min>0){if(header=this.text.substr(0,min),check=this.check("name",{text:header}),!1===check?this.parsed.name=game.i18n.localize("CoC7.ImportedUnnamedCharacter"):header=header.replace(check["-source"],"\n"),check=this.check("age",{text:header}),!1!==check&&(header=header.replace(check["-source"],"\n")),!this.check("occupation",{text:header})&&""!==header.trim()){let occupation=header;header.indexOf(".")>-1&&(occupation=header.substr(0,header.indexOf(".")+1)),this.parsed.occupation=occupation.replace(/([\n\r]+)/g," ").trim().replace(/,$/,""),this.text=this.text.replace(occupation.trim(),"\n")}}else this.parsed.name=game.i18n.localize("CoC7.ImportedUnnamedCharacter");if(void 0!==this.parsed.occupation&&void 0===this.parsed.age){const occupationAge=this.parsed.occupation.match(/^(?<age>\d+),(?<occupation>.+)$/);occupationAge&&(this.parsed.age=occupationAge.groups.age,this.parsed.occupation=occupationAge.groups.occupation.trim())}this.check("db")&&!this.check("dbNone",{removeFromText:!1,saveKeys:!1,text:this.parsed.db})||(this.parsed.db="0"),this.parsed.db=this.translateRoll(this.parsed.db),this.check("build"),this.check("armor")&&!this.check("armorNone",{removeFromText:!1,saveKeys:!1,text:this.parsed.armor})||(this.parsed.armor="0"),this.check("mov",{type:CoC7ActorImporter.asNumber}),this.check("lck",{type:CoC7ActorImporter.asNumber}),this.check("sanLoss"),this.parsed.sanLoss=this.translateRoll(this.parsed.sanLoss),this.check("attacksPerRound")&&this.check("attacksPerRoundNone",{removeFromText:!1,saveKeys:!1,text:this.parsed.attacksPerRound})&&(this.parsed.attacksPerRound="0"),this.text="\n"+this.text;let sections=this.getRegEx("("+this.keys.sectionCombats+")","i");null===this.text.match(sections)&&(sections=this.check("guessStartCombat",{saveKeys:!1,removeFromText:!1}),sections&&(this.text=[this.text.slice(0,sections["-index"]),this.keys.newCombatHeader,this.text.slice(sections["-index"])].join("")));const regExpSections=this.getRegEx(this.regEx.sections,"i");if(sections=this.text.split(regExpSections),null!==sections)for(let i=0,im=sections.length;i<im;i++)null!==sections[i].match(this.getRegEx("("+this.keys.sectionCombats+")","i"))&&void 0!==sections[i+1]?(this.text=("\n"+this.text+"\n").replace(sections[i],"\n").trim(),this.processCombat(sections[i+1]),i++):null!==sections[i].match(this.getRegEx("("+this.keys.sectionSkills+")","i"))&&void 0!==sections[i+1]?(this.text=("\n"+this.text+"\n").replace(sections[i],"\n").trim(),this.processSkills(sections[i+1]),i++):null!==sections[i].match(this.getRegEx("("+this.keys.sectionLangauges+")","i"))&&void 0!==sections[i+1]?(this.text=("\n"+this.text+"\n").replace(sections[i],"\n").trim(),this.processSkills(sections[i+1],"languages"),i++):null!==sections[i].match(this.getRegEx("("+this.keys.sectionSpells+")","i"))&&void 0!==sections[i+1]&&(this.text=("\n"+this.text+"\n").replace(sections[i],"\n").trim(),this.processSpells(sections[i+1]),i++);return this.parsed.gmnotes=this.toHTML(this.text),this.parsed}disableAttribAuto(key,attribValue,check,updateData){const value=Math.max(0,Number(attribValue));return value!==Number(check)&&(updateData[`system.attribs.${key}.auto`]=!1,updateData[`system.attribs.${key}.value`]=value,"build"===key?updateData[`system.attribs.${key}.current`]=value:updateData[`system.attribs.${key}.max`]=value),updateData}async createEntity(characterData,entityType){const importedCharactersFolder=await CoC7Utilities.createImportCharactersFolderIfNotExists();"npc"!==entityType&&(entityType="creature");const actorData={name:characterData.name,type:entityType,folder:importedCharactersFolder.id,system:characterData.actor},npc=await Actor.create(actorData);await npc.createEmbeddedDocuments("Item",characterData.items,{renderSheet:!1});const updateData={};let value=0;void 0!==characterData.actor.attribs.hp?.value&&this.disableAttribAuto("hp",characterData.actor.attribs.hp.value,npc.hpMax,updateData),void 0!==characterData.actor.attribs.mp?.value&&this.disableAttribAuto("mp",characterData.actor.attribs.mp.value,npc.mpMax,updateData),void 0!==characterData.actor.attribs.mov?.value&&this.disableAttribAuto("mov",characterData.actor.attribs.mov.value,npc.mov,updateData),void 0!==characterData.actor.attribs.build?.value&&this.disableAttribAuto("build",characterData.actor.attribs.build.value,npc.build,updateData),void 0!==characterData.actor.attribs.db?.value&&(value=String(characterData.actor.attribs.db.value).replace(/^\+\s*/,""),value!==String(npc.db)&&(updateData["system.attribs.db.auto"]=!1,updateData["system.attribs.db.value"]=value)),Object.keys(updateData).length>0&&(CONFIG.debug.CoC7Importer&&console.debug("updateData:",updateData),await npc.update(updateData));const updateItemData=[];let lastWeaponSkill=null;for(const pair of this.weaponSkills){!1!==pair[0]&&(lastWeaponSkill=npc.items.filter((i=>i.name===pair[0].name&&"skill"===i.type&&Number(i.system.value)===Number(pair[0].system.value))));const weapon=npc.items.filter((i=>i.name===pair[1].name&&"weapon"===i.type&&i.system.range.normal.damage===pair[1].system.range.normal.damage));lastWeaponSkill[0]&&weapon[0]&&updateItemData.push({_id:weapon[0].id,"system.skill.main.id":lastWeaponSkill[0].id,"system.skill.main.name":lastWeaponSkill[0].name})}return updateItemData.length>0&&(CONFIG.debug.CoC7Importer&&console.debug("updateItemData:",updateItemData),await npc.updateEmbeddedDocuments("Item",updateItemData)),npc}actorData(pc){const system={characteristics:{},attribs:{},infos:{},special:{},description:{keeper:""},flags:{locked:!1,displayFormula:!1}};for(const key of["str","con","siz","dex","app","int","pow","edu"])void 0!==pc[key]&&(system.characteristics[key]={value:Number(pc[key])});for(const key of["san","mov","build","armor","lck","hp","mp"])void 0!==pc[key]&&(system.attribs[key]={value:Number(pc[key])});void 0!==pc.db&&(system.attribs.db={value:pc.db});for(const key of["age","occupation"])void 0!==pc[key]&&(system.infos[key]=pc[key]);if(void 0!==pc.sanLoss){const[passed,failed]=pc.sanLoss.split(/[/／]/);system.special.sanLoss={checkPassed:passed,checkFailled:failed}}return void 0!==pc.attacksPerRound&&(system.special.attacksPerRound=Number(pc.attacksPerRound)),system.description.keeper=pc.gmnotes,CONFIG.debug.CoC7Importer&&console.debug("actorData:",system),system}async itemsData(pc){const items=[];if(this.weaponSkills=[],void 0!==pc.attacks)for(const attack of pc.attacks){let skill=!1;!0!==attack.system?.skill?.id&&(skill=await this.weaponSkill(attack),items.push(skill)),attack.system.skill.id=null,items.push(attack),this.weaponSkills.push([foundry.utils.duplicate(skill),attack])}if(void 0!==pc.skills)for(const skill of pc.skills){const existing=await CoC7Utilities.guessItem("skill",skill.name,{source:this.itemLocations});if(void 0!==existing){const cloned=existing.toObject();cloned.system.base=skill.value,void 0!==skill.push&&(cloned.system.properties.push=skill.push),items.push(foundry.utils.duplicate(cloned))}else{const options={};void 0!==skill.push&&(options.push=skill.push),items.push(CoCActor.emptySkill(skill.name,skill.value,options))}}if(void 0!==pc.languages)for(const skill of pc.languages){const existing=await CoC7Utilities.guessItem("skill",skill.name,{source:this.itemLocations});if(void 0!==existing){const cloned=existing.toObject();cloned.system.base=skill.value,items.push(foundry.utils.duplicate(cloned))}else items.push(CoCActor.emptySkill(skill.name,skill.value,{img:CoC7Item.iconLanguage,specialization:game.i18n.localize("CoC7.LanguageSpecializationName")}))}if(void 0!==pc.spells)for(const name of pc.spells){const existing=await CoC7Utilities.guessItem("spell",name,{source:this.itemLocations});if(void 0!==existing){const cloned=existing.toObject();items.push(foundry.utils.duplicate(cloned))}else items.push(CoCActor.emptySpell(name))}return items}async weaponSkill(weapon){let skill=null;const localizedFirearm=game.i18n.localize("CoC7.FirearmSpecializationName");if(this.getRegEx(this.keys.handgun).exec(weapon.name)?(skill=await CoC7Utilities.guessItem("skill",localizedFirearm+" ("+game.i18n.localize("CoC7.SkillNameHandgun")+")",{combat:!0,source:this.itemLocations}),CONFIG.debug.CoC7Importer&&console.debug(`${weapon.name} uses Handgun skill: `,skill)):this.getRegEx(this.keys.rifle).exec(weapon.name)?(skill=await CoC7Utilities.guessItem("skill",localizedFirearm+" ("+game.i18n.localize("CoC7.SkillNameRifleShotgun")+")",{combat:!0,source:this.itemLocations}),skill||(skill=await CoC7Utilities.guessItem("skill",localizedFirearm+" ("+game.i18n.localize("CoC7.SkillNameRifle")+")",{combat:!0,source:this.itemLocations}),skill||(skill=await CoC7Utilities.guessItem("skill",localizedFirearm+" ("+game.i18n.localize("CoC7.SkillNameShotgun")+")",{combat:!0,source:this.itemLocations}))),CONFIG.debug.CoC7Importer&&console.debug(`${weapon.name} uses Rifle skill: ${skill}`)):this.getRegEx(this.keys.smb).exec(weapon.name)?(skill=await CoC7Utilities.guessItem("skill",localizedFirearm+" ("+game.i18n.localize("CoC7.SkillNameSmb")+")",{combat:!0,source:this.itemLocations}),CONFIG.debug.CoC7Importer&&console.debug(`${weapon.name} uses Submachine Gun skill: ${skill}`)):this.getRegEx(this.keys.machineGun).exec(weapon.name)?(skill=await CoC7Utilities.guessItem("skill",localizedFirearm+" ("+game.i18n.localize("CoC7.SkillnameMachineGun")+")",{combat:!0,source:this.itemLocations}),CONFIG.debug.CoC7Importer&&console.debug(`${weapon.name} uses Machine Gun skill: ${skill}`)):this.getRegEx(this.keys.launched).exec(weapon.name)&&(skill=await CoC7Utilities.guessItem("skill",localizedFirearm+" ("+game.i18n.localize("CoC7.SkillnameLaunch")+")",{combat:!0,source:this.itemLocations}),CONFIG.debug.CoC7Importer&&console.debug(`${weapon.name} uses Launch skill: ${skill}`)),null!=skill){return skill.clone({system:{value:weapon.system?.skill?.id}})}const firearms=weapon.system?.properties?.rngd,parts=CoC7Item.getNamePartsSpec(weapon.name,game.i18n.localize(firearms?"CoC7.FirearmSpecializationName":"CoC7.FightingSpecializationName")),newSkill={type:"skill",name:parts.name,system:{skillName:parts.skillName,specialization:parts.specialization,properties:{special:!0,fighting:!firearms,firearm:firearms,combat:!0},base:weapon.system?.skill?.id,value:weapon.system?.skill?.id}};return CONFIG.debug.CoC7Importer&&console.debug(`Weapon skill not found for ${weapon.name}, creating a new one`,newSkill),newSkill}needsConversion(npc){let needsConversionResult=!0;for(const key of["str","con","siz","dex","app","int","pow","edu"])void 0!==npc[key]&&npc[key]>30&&(needsConversionResult=!1);return CONFIG.debug.CoC7Importer&&console.debug("needsConversion:",needsConversionResult),needsConversionResult}async createActor(inputs){CONFIG.debug.CoC7Importer&&console.debug("createActor:",inputs);const lang=CoC7ActorImporterRegExp.checkLanguage(inputs.lang);this.keys=CoC7ActorImporterRegExp.getKeys(lang),this.regEx=CoC7ActorImporterRegExp.getRegularExpressions(lang),this.itemLocations=inputs.source,CONFIG.debug.CoC7Importer&&console.debug("Regular Expressions:",lang,this.keys,this.regEx);let character=await this.parseCharacter(inputs.text);CONFIG.debug.CoC7Importer&&console.debug("parseCharacter:",character),("coc-guess"===inputs.convertFrom6E&&this.needsConversion(character)||"coc-convert"===inputs.convertFrom6E)&&(character=await this.convert7E(character));const characterData={name:character.name,actor:this.actorData(character),items:await this.itemsData(character)};if(void 0!==inputs.testMode&&!0===inputs.testMode)return characterData;return await this.createEntity(characterData,inputs.entity)}async convert7E(creature){CONFIG.debug.CoC7Importer&&console.debug("Converting npc",creature);for(const key of["str","con","siz","dex","app","int","pow"])void 0!==creature[key]&&(creature[key]*=5);return void 0!==creature.edu&&(creature.edu<=18?creature.edu*=5:creature.edu<=26?creature.edu=creature.edu+90-18:creature.edu=99),void 0!==creature.db&&("-1d4"===creature.db?creature.db=-1:"-1d6"===creature.db&&(creature.db=-2)),CONFIG.debug.CoC7Importer&&console.debug("convert7E: ",creature),creature}}class CoC7DirectoryPicker extends(foundry.applications.apps?.FilePicker??FilePicker){constructor(options={}){options.type="folder",super(options)}get title(){return game.i18n.localize("CoC7.PickDirectory")}_onSubmit(event){event.preventDefault();const path=event.target.target.value,activeSource=this.activeSource,bucket=event.target.bucket?event.target.bucket.value:null;this.field.value=CoC7DirectoryPicker.format({activeSource,bucket,path}),this.close()}static format(value){return null!==value.bucket?`[${value.activeSource}:${value.bucket}] ${value.path}`:`[${value.activeSource}] ${value.path}`}static parse(raw){const str=raw??"",matches=str.match(/^\[([^:]+)(:(.+))?\]\s*(.+)?$/u);return matches?{activeSource:matches[1],bucket:matches[3]??"",current:matches[4]}:{activeSource:"data",bucket:null,current:str}}static processHtml(html){let inputs;try{inputs=html.querySelectorAll("input[name=CoC7\\.dholeUploadDirectory]")}catch(e){inputs=html[0].querySelectorAll("input[name=CoC7\\.dholeUploadDirectory]")}for(const input of inputs)if(foundry.utils.isNewerVersion(game.version,"12")&&input.setAttribute("readonly",!0),!input.nextElementSibling){const picker=new CoC7DirectoryPicker({field:input,...CoC7DirectoryPicker.parse(input.value)}),pickerButton=document.createElement("button");pickerButton.classList.add("file-picker"),pickerButton.setAttribute("title",game.i18n.localize("CoC7.PickDirectory")),foundry.utils.isNewerVersion(game.version,"13")&&pickerButton.setAttribute("style","flex: 0 0 auto;");const pickerIcon=document.createElement("i");pickerIcon.classList.add("fas","fa-file-import","fa-fw"),pickerButton.append(pickerIcon),CoC7DirectoryPicker.createDefaultDirectory(),pickerButton.onclick=event=>{event.preventDefault(),picker.render(!0)},input.after(pickerButton)}}static async createDefaultDirectory(){const parsed=CoC7DirectoryPicker.parse(game.settings.get("CoC7","dholeUploadDirectory"));try{return await CoC7DirectoryPicker.createDirectory(parsed.activeSource,parsed.current,{bucket:parsed.bucket}),!0}catch(e){if(!e.message.startsWith("EEXIST"))return ui.notifications.error(game.i18n.localize("CoC7.ActorImporterUploadError")),!1}}static async uploadToDefaultDirectory(file,filename){const parsed=CoC7DirectoryPicker.parse(game.settings.get("CoC7","dholeUploadDirectory"));return(await FilePicker.upload(parsed.activeSource,parsed.current,new File([file],filename,{type:"image/png"}),{bucket:parsed.bucket})).path?parsed.current+"/"+filename:(ui.notifications.error(game.i18n.localize("CoC7.FileUploadError")),!1)}get canUpload(){return!1!==this.options.allowUpload&&(!!["data","s3"].includes(this.activeSource)&&(!game.user||game.user.can("FILES_UPLOAD")))}}class CoC7DholeHouseActorImporter{static getBackstory(backstoryJSON){const sections=[["description","Description"],["traits","Traits"],["ideology","Ideology"],["injurues","Injuries","injuries"],["people","People"],["phobias","Phobias"],["locations","Locations"],["tomes","Tomes"],["possessions","Possessions"],["encounters","Encounters"]],backstory={block:[],sections:[]};for(const section of sections)null!==backstoryJSON[section[0]]&&(void 0!==section[2]&&""!==section[2]||(section[2]=section[0]),backstory.block.push(`<h3>${section[1]}</h3>\n<div class="${section[2]}">\n${backstoryJSON[section[0]]}\n</div>`),backstory.sections.push({title:section[1],value:backstoryJSON[section[0]]}));return backstory.block="<h2>Backstory</h2>\n"+backstory.block.join("\n",backstory.block),backstory}static async convertDholeHouseCharacterData(dholeHouseData,options){CONFIG.debug.CoC7Importer&&console.log("Source:",dholeHouseData),dholeHouseData=dholeHouseData.Investigator;const backstories=CoC7DholeHouseActorImporter.getBackstory(dholeHouseData.Backstory??{});return{name:dholeHouseData.PersonalDetails.Name,actor:{characteristics:{str:{value:parseInt(dholeHouseData.Characteristics.STR,10)},con:{value:parseInt(dholeHouseData.Characteristics.CON,10)},siz:{value:parseInt(dholeHouseData.Characteristics.SIZ,10)},dex:{value:parseInt(dholeHouseData.Characteristics.DEX,10)},app:{value:parseInt(dholeHouseData.Characteristics.APP,10)},int:{value:parseInt(dholeHouseData.Characteristics.INT,10)},pow:{value:parseInt(dholeHouseData.Characteristics.POW,10)},edu:{value:parseInt(dholeHouseData.Characteristics.EDU,10)}},attribs:{san:{value:parseInt(dholeHouseData.Characteristics.Sanity,10),max:parseInt(dholeHouseData.Characteristics.SanityMax,10),dailyLimit:Math.floor(dholeHouseData.Characteristics.Sanity/5)},hp:{value:parseInt(dholeHouseData.Characteristics.HitPts,10),max:parseInt(dholeHouseData.Characteristics.HitPtsMax,10)},mp:{value:parseInt(dholeHouseData.Characteristics.MagicPts,10),max:parseInt(dholeHouseData.Characteristics.MagicPtsMax,10)},lck:{value:parseInt(dholeHouseData.Characteristics.Luck,10)},mov:{value:parseInt(dholeHouseData.Characteristics.Move,10),max:parseInt(dholeHouseData.Characteristics.Move,10)},db:{value:dholeHouseData.Characteristics.DamageBonus},build:{value:parseInt(dholeHouseData.Characteristics.Build,10)}},infos:{occupation:dholeHouseData.PersonalDetails.Occupation,age:dholeHouseData.PersonalDetails.Age,sex:dholeHouseData.PersonalDetails.Gender,residence:dholeHouseData.PersonalDetails.Residence,birthplace:dholeHouseData.PersonalDetails.Birthplace},backstory:backstories.block,biography:backstories.sections,description:{keeper:game.i18n.localize("CoC7.DholeHouseActorImporterSource")}},skills:await CoC7DholeHouseActorImporter.extractSkills(dholeHouseData.Skills.Skill??[],options),possesions:await CoC7DholeHouseActorImporter.extractPossessions(dholeHouseData.Possessions?.item??[],options)}}static makeSkillName(name,specialization){return"None"===specialization&&(specialization="Any"),"Language (Other)"===name||"Language (Own)"===name?name="Language":"Operate Heavy Machine"===name?name="Operate Heavy Machinery":"Throw"===name&&""===specialization&&(name="Fighting",specialization="Throw"),{skillName:""===specialization?name:specialization,specialization:""===specialization?"":name,name:name+(""===specialization?"":" ("+specialization+")")}}static async extractSkills(dholeHouseskills,options){const skills=[];for(const skill of dholeHouseskills){if("None"===skill.subskill)continue;const parts=CoC7DholeHouseActorImporter.makeSkillName(skill.name,skill.subskill??""),existing=await CoC7Utilities.guessItem("skill",parts.name,{source:options.source,fallbackAny:!0});let cloned=null;void 0!==existing?(cloned=foundry.utils.duplicate(existing.toObject()),cloned.name=parts.name,cloned.system.skillName=parts.skillName,cloned.system.specialization=parts.specialization,cloned.system.properties?.requiresname&&(cloned.system.properties.requiresname=!1),cloned.system.properties?.picknameonly&&(cloned.system.properties.picknameonly=!1)):(cloned=CoCActor.emptySkill(parts.skillName,parseInt(skill.value??0,10),{specialization:""!==parts.specialization&&parts.specialization}),cloned.system.properties=cloned.system.properties??{},"Fighting"===parts.specialization?(cloned.system.properties.fighting=!0,cloned.system.properties.combat=!0,cloned.system.properties.push=!1):"Firearms"===parts.specialization?(cloned.system.properties.firearm=!0,cloned.system.properties.combat=!0,cloned.system.properties.push=!1):"Dodge"===parts.skillName&&(cloned.system.properties.push=!1)),"Any"===cloned.system.skillName&&(cloned.name=cloned.name.replace(" (Any)"," (None)"),cloned.system.skillName="None"),cloned.system.base=parseInt(skill.value??0,10),cloned.system.value=parseInt(skill.value??0,10),cloned.system.flags=cloned.system.flags??{},cloned.system.flags.occupation=!0===skill.occupation||"true"===skill.occupation,skills.push(cloned)}return skills}static findWeaponSkillId(skillName,character){const skills=character.getEmbeddedCollection("Item"),checkName=skillName.replace(/^\((.+)\)$/,"$1");return skills.find((i=>i.system?.skillName===checkName||i.system?.skillName?.indexOf(checkName)>-1))}static async extractPossessions(dholehousePossessions,options){const items=[];Array.isArray(dholehousePossessions)||null==dholehousePossessions||(dholehousePossessions=[dholehousePossessions]);for(const item of dholehousePossessions){const existing=await CoC7Utilities.guessItem("item",item.description,{source:options.source});let cloned=null;cloned=void 0!==existing?foundry.utils.duplicate(existing.toObject()):{name:item.description,type:"item"},items.push(cloned)}return items}static async extractWeapons(dholehouseWeapons,character,options){const weapons=[];Array.isArray(dholehouseWeapons)||(dholehouseWeapons=[dholehouseWeapons]);for(const weapon of dholehouseWeapons){const skill=CoC7DholeHouseActorImporter.findWeaponSkillId(weapon.skillname,character),damage=weapon.damage.replace(/\+DB/i,""),addb=damage!==weapon.damage,existing=await CoC7Utilities.guessItem("weapon",weapon.name,{source:options.source});let cloned=null;void 0!==existing?(cloned=foundry.utils.duplicate(existing.toObject()),cloned.system.skill.main.name=skill?.name??"",cloned.system.skill.main.id=skill?.id??"",cloned.system.range=cloned.system.range??{},cloned.system.range.normal=cloned.system.range.normal??{},cloned.system.range.normal.damage=damage,cloned.system.ammo=weapon.ammo,cloned.system.malfunction=weapon.malf,cloned.system.properties=cloned.system.properties??{},cloned.system.properties.melee=skill?.system.properties?.fighting??!1,cloned.system.properties.rngd=skill?.system.properties?.firearm??!1,cloned.system.properties.addb=addb):cloned={name:weapon.name,type:"weapon",system:{skill:{main:{name:skill?.name??"",id:skill?.id??""}},range:{normal:{damage}},ammo:weapon.ammo,malfunction:weapon.malf,properties:{melee:skill?.system.properties?.fighting??!1,rngd:skill?.system.properties?.firearm??!1,addb}}},weapons.push(cloned)}return weapons}static async savePortrait(base64Portrait,fileName){const base64Response=await fetch("data:image/png;base64,"+base64Portrait),imageBlob=await base64Response.blob();return CoC7DirectoryPicker.uploadToDefaultDirectory(imageBlob,fileName)}static async createNPCFromDholeHouse(dholeHouseCharacterData,options){if(!game.user?.can("FILES_UPLOAD"))return ui.notifications.error(game.i18n.localize("CoC7.ActorImporterUploadError")),!1;const characterData=await CoC7DholeHouseActorImporter.convertDholeHouseCharacterData(dholeHouseCharacterData,options);CONFIG.debug.CoC7Importer&&console.log("Character Data:",characterData);const importedCharactersFolder=await CoC7Utilities.createImportCharactersFolderIfNotExists();if(!CoC7DirectoryPicker.createDefaultDirectory())return!1;const actorData={name:characterData.name,type:"character",folder:importedCharactersFolder.id,system:characterData.actor},npc=await Actor.create(actorData);if(dholeHouseCharacterData.Investigator.PersonalDetails.Portrait?.length>10){const fileName="avatar-"+npc.id+".png",portrait=await CoC7DholeHouseActorImporter.savePortrait(dholeHouseCharacterData.Investigator.PersonalDetails.Portrait,fileName);!1!==portrait&&npc.update({img:portrait})}CONFIG.debug.CoC7Importer&&console.log("Items: ",characterData.items),await npc.createEmbeddedDocuments("Item",characterData.skills,{renderSheet:!1}),await npc.createEmbeddedDocuments("Item",characterData.possesions,{renderSheet:!1});const weapons=await CoC7DholeHouseActorImporter.extractWeapons(dholeHouseCharacterData.Investigator.Weapons?.weapon??[],npc,options);return CONFIG.debug.CoC7Importer&&console.log("Weapons: ",weapons),await npc.createEmbeddedDocuments("Item",weapons,{renderSheet:!1}),npc}}class CoC7ActorImporterDialog extends FormApplication{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{classes:["coc7","dialog","actor-importer"],title:game.i18n.localize("CoC7.ActorImporter"),template:"systems/CoC7/templates/apps/actor-importer.html",closeOnSubmit:!1,width:600,height:"auto"})}async getData(){const data=await super.getData();return data.importType=data.object.importType,data.convert6E=data.object.convert6E,data.source=data.object.source,data.characterData=data.object.characterData,data.canUpload=game.user?.can("FILES_UPLOAD"),["npc","creature"].includes(data.importType)&&(data.languages=CoC7ActorImporterRegExp.getTranslations(),data.language=CoC7ActorImporterRegExp.checkLanguage(data.object.language),data.placeholder=CoC7ActorImporterRegExp.getExampleText(data.language)),data.importTypeOptions=[{key:"npc",label:"CoC7.NonPlayingCharacter"},{key:"creature",label:"CoC7.Creature"},{key:"dholehouse",label:"CoC7.DholeHouseActorImporter"}],data.convert6EOptions=[{key:"coc-guess",label:"CoC7.Guess"},{key:"coc-convert",label:"CoC7.Convert"},{key:"coc-no-convert",label:"CoC7.NoConvert"}],data.sourceOptions=[{key:"",label:"CoC7.ImportActorItemsNone"},{key:"i",label:"CoC7.ImportActorItemsItem"},{key:"iwms",label:"CoC7.ImportActorItemsItemWorldModuleSystem"},{key:"wmis",label:"CoC7.ImportActorItemsWorldModuleItemSystem"}],data}activateListeners(html){super.activateListeners(html),html.find("#dholehouse-character-preview").hide(),html.find("#coc-entity-type,#coc-entity-lang").change(this._onChangeSubmit.bind(this)),html.find("#dholehouse-json-file-picker").change(this._onJSONFileSelected.bind(this)),html.find("#coc-pasted-character-data").on("keyup",(function(e){const charactersTooExtended=$(this).val().match(/[\udbc0-\udbfe][\udc00-\udfff]/),prompt=$("#coc-prompt");prompt.data("extended")&&charactersTooExtended?prompt.html(game.i18n.localize("CoC7.TextFieldInvalidCharacters")).addClass("error"):prompt.html(prompt.data("text")).removeClass("error")})).trigger("keyup"),html.find(".submit-button").click(this._onClickSubmit.bind(this)),html.find("form").submit((e=>{e.preventDefault()}))}static getInputs(form){const inputs={};return inputs.entity=form.find("#coc-entity-type").val().trim(),CONFIG.debug.CoC7Importer&&console.debug("entity type:",inputs.entity),form.find("#coc-convert-6E").length>0&&(inputs.convertFrom6E=form.find("#coc-convert-6E").val().trim()),form.find("#coc-entity-lang").length>0&&(inputs.lang=CoC7ActorImporterRegExp.checkLanguage(form.find("#coc-entity-lang").val().trim())),form.find("#source").length>0&&(inputs.source=form.find("#source").val().trim()),form.find("#coc-pasted-character-data").length>0&&(inputs.text=form.find("#coc-pasted-character-data").val().trim()),CONFIG.debug.CoC7Importer&&console.debug("received text","##"+inputs.text+"##"),inputs}_onJSONFileSelected(event){const jsonFileInput=document.getElementById("dholehouse-json-file-picker"),portraitImage=document.getElementById("dholehouse-character-portrait"),characterName=document.getElementById("dholehouse-character-name"),preview=document.getElementById("dholehouse-character-preview"),file=jsonFileInput.files[0],dialog=this,fileReader=new FileReader;fileReader.onload=function(e){try{dialog.characterJSON=JSON.parse(fileReader.result)}catch(e){return $("#coc-prompt").html(game.i18n.localize("CoC7.TextFieldInvalidJSON")).addClass("error"),void event.preventDefault()}const personalDetails=dialog.characterJSON?.Investigator?.PersonalDetails;personalDetails?(characterName.textContent=personalDetails.Name,portraitImage.src="data:image/png;base64,"+personalDetails.Portrait,preview.style.display="block",$(".dialog.actor-importer").height("auto")):ui.notifications.error(game.i18n.localize("CoC7.DholeHouseInvalidActor"))},fileReader.readAsText(file)}_onChangeSubmit(event){this._onSubmit(event)}async _onClickSubmit(event){const id=event.currentTarget.dataset.button;if("no"===id)this.close();else if("getExampleNow"===id){const content=CoC7ActorImporterRegExp.getExampleText(this.object.language);CoC7Utilities.copyToClipboard(content).then((()=>ui.notifications.info(game.i18n.localize("CoC7.Copied"))))}else if("import"===id){const app=$(event.currentTarget).closest("div.dialog.actor-importer");app.hide();const form=$(event.currentTarget).closest("form"),inputs=CoC7ActorImporterDialog.getInputs(form);if("dholehouse"===inputs.entity&&this.characterJSON){const character=await CoC7DholeHouseActorImporter.createNPCFromDholeHouse(this.characterJSON,{source:inputs.source});!1!==character?(CONFIG.debug.CoC7Importer&&console.debug("character:",character),ui.notifications.info(game.i18n.format("CoC7.ActorImported",{actorType:game.i18n.localize("CoC7.Entities.Character"),actorName:character.name})),await character.sheet.render(!0),this.close()):app.show()}else inputs.text&&""!==inputs.text?(CoC7ActorImporterDialog.importActor(inputs),this.close()):app.show()}}async _updateObject(event,formData){this.object.importType=formData["coc-entity-type"],this.object.characterData=formData["coc-pasted-character-data"]?.trim(),void 0!==formData["coc-convert-6E"]&&(this.object.convert6E=formData["coc-convert-6E"]),void 0!==formData["coc-entity-lang"]&&(this.object.language=formData["coc-entity-lang"]),void 0!==formData.source&&(this.object.source=formData.source),this.render(!0)}static async importActor(inputs){"."!==inputs.text[inputs.text.length]&&(inputs.text+=".");const actor=new CoC7ActorImporter,createdActor=await actor.createActor(inputs);CONFIG.debug.CoC7Importer&&console.debug("createdActor:",createdActor),ui.notifications.info(game.i18n.format("CoC7.ActorImported",{actorType:createdActor.type?.toUpperCase(),actorName:createdActor.name})),await createdActor.sheet.render(!0)}static async create(options={}){options.importType=options.importType??"npc",options.language=options.language??CoC7ActorImporterRegExp.checkLanguage(null),options.convert6E=options.language??"coc-guess",options.source=options.source??"iwms",options.characterData=options.characterData??"",new CoC7ActorImporterDialog(options).render(!0)}}Hooks.once("ready",(()=>{game.modules.get("CoC7-Importer-Tests")?.active&&(window.CoC7ActorImporter=CoC7ActorImporter)}));class DropCoCID extends Dialog{static processForm(response,element,resolve){element.find("input").is(":checked")&&game.settings.set("CoC7","dropCoCID",response?"Y":"N"),resolve(response)}static processItem(response,item){return response&&item.flags?.CoC7?.cocidFlag?.id?item.flags.CoC7.cocidFlag.id:foundry.utils.duplicate(item)}static async create(){switch(game.settings.get("CoC7","dropCoCID")){case"":return new Promise((resolve=>{new DropCoCID({title:game.i18n.format("CoC7.Settings.DropCoCID.Name"),content:"<p>"+game.i18n.format("CoC7.Settings.DropCoCID.Dialog")+'</p><p><input type="checkbox" id="rememberthis" style="vertical-align: sub;"><label for="rememberthis">'+game.i18n.format("CoC7.Settings.DropCoCID.Remember")+"</label></p>",classes:["coc7","app","dialog"],buttons:{yes:{icon:'<i class="fas fa-check"></i>',label:game.i18n.localize("Yes"),callback:element=>{DropCoCID.processForm(!0,element,resolve)}},no:{icon:'<i class="fas fa-times"></i>',label:game.i18n.localize("No"),callback:element=>{DropCoCID.processForm(!1,element,resolve)}}}}).render(!0)}));case"Y":return!0;case"N":return!1}}}class CoC7OccupationSheet extends foundry.appv1.sheets.ItemSheet{activateListeners(html){if(super.activateListeners(html),!this.options.editable)return;html.find(".item .item-name h4").click((event=>this._onItemSummary(event,"skills"))),html.find(".item-delete").click((event=>this._onItemDelete(event,"skills"))),html.find(".group-item-delete").click(this._onGroupItemDelete.bind(this)),html.find(".group-control").click(this._onGroupControl.bind(this));new(foundry.applications.ux?.DragDrop??DragDrop)({dropSelector:".droppable",callbacks:{drop:this._onDrop.bind(this)}}).bind(html[0])}async _onDrop(event,type="skill",collectionName="skills"){event.preventDefault(),event.stopPropagation();const optionalSkill=event?.currentTarget?.classList?.contains("optional-skills"),ol=event?.currentTarget?.closest("ol"),index=ol?.dataset?.group,dataList=await CoC7Utilities.getDataFromDropEvent(event,"Item");let useCoCID=0;const collection=this.item.system[collectionName]?foundry.utils.duplicate(this.item.system[collectionName]):[],groups=this.item.system.groups?foundry.utils.duplicate(this.item.system.groups):[];for(const item of dataList)if(item&&item.system&&[type].includes(item.type))if(optionalSkill){if(!CoC7Item.isAnySpec(item)){if(collection.find((el=>el.name===item.name)))continue;if(groups[index].skills.find((el=>el.name===item.name)))continue}0===useCoCID&&(useCoCID=await DropCoCID.create()),groups[index].skills=groups[index].skills.concat([DropCoCID.processItem(useCoCID,item)])}else{if(!CoC7Item.isAnySpec(item)){if(collection.find((el=>el.name===item.name)))continue;for(let i=0;i<groups.length;i++){const index=groups[i].skills.findIndex((el=>el.name===item.name));-1!==index&&groups[i].skills.splice(index,1)}}0===useCoCID&&(useCoCID=await DropCoCID.create()),collection.push(DropCoCID.processItem(useCoCID,item))}await this.item.update({"system.groups":groups}),await this.item.update({[`system.${collectionName}`]:collection})}async _onGroupControl(event){event.preventDefault();const a=event.currentTarget;if(a.classList.contains("add-group")){await this._onSubmit(event);const groups=this.item.system.groups;await this.item.update({"system.groups":groups.concat([{options:0,skills:[]}])})}if(a.classList.contains("remove-group")){await this._onSubmit(event);const groups=foundry.utils.duplicate(this.item.system.groups),ol=a.closest(".item-list.group");groups.splice(Number(ol.dataset.group),1),await this.item.update({"system.groups":groups})}}async _onItemSummary(event,collectionName="items"){event.preventDefault();const obj=$(event.currentTarget),li=obj.parents(".item"),group=obj.closest(".group");let item;if(item=group.length?this.item.system.groups[group.data("group")][collectionName].find((s=>s._id===li.data("item-id"))):this.item.system[collectionName].find((s=>s._id===li.data("item-id"))),!item)return;const chatData=await TextEditor.enrichHTML(item.system.description.value,{async:!0,secrets:this.item.editable});if(li.hasClass("expanded")){const summary=li.children(".item-summary");summary.slideUp(200,(()=>summary.remove()))}else{const div=$(`<div class="item-summary">${chatData}</div>`),props=$('<div class="item-properties"></div>');div.append(props),li.append(div.hide()),div.slideDown(200)}li.toggleClass("expanded")}async _onItemDelete(event,collectionName="items"){const item=$(event.currentTarget).closest(".item"),itemId=item.data("item-id"),CoCId=item.data("cocid"),itemIndex=this.item.system[collectionName].findIndex((i=>itemId&&i._id===itemId||CoCId&&i===CoCId));if(itemIndex>-1){const collection=this.item.system[collectionName]?foundry.utils.duplicate(this.item.system[collectionName]):[];collection.splice(itemIndex,1),await this.item.update({[`system.${collectionName}`]:collection})}}async _onGroupItemDelete(event){const item=$(event.currentTarget).closest(".item"),group=Number(item.closest(".item-list.group").data("group")),groups=foundry.utils.duplicate(this.item.system.groups);if(void 0!==groups[group]){const itemId=item.data("item-id"),CoCId=item.data("cocid"),itemIndex=groups[group].skills.findIndex((i=>itemId&&i._id===itemId||CoCId&&i===CoCId));itemIndex>-1&&(groups[group].skills.splice(itemIndex,1),await this.item.update({"system.groups":groups}))}}static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{classes:["coc7","sheet","occupation"],template:"systems/CoC7/templates/items/occupation.html",width:525,height:480,dragDrop:[{dragSelector:".item"}],scrollY:[".tab.description"],tabs:[{navSelector:".sheet-navigation",contentSelector:".sheet-body",initial:"description"}]})}_getHeaderButtons(){const headerButtons=super._getHeaderButtons();return addCoCIDSheetHeaderButton(headerButtons,this),headerButtons}async getData(){const sheetData=super.getData();sheetData.hasOwner=!0===this.item.isEmbedded,sheetData.data.system.skills=await game.system.api.cocid.expandItemArray({itemList:sheetData.data.system.skills}),sheetData.skillListEmpty=0===sheetData.data.system.skills.length,sheetData.data.system.skills.sort(CoC7Utilities.sortByNameKey);for(let index=0,len=sheetData.data.system.groups.length;index<len;index++)sheetData.data.system.groups[index].skills=await game.system.api.cocid.expandItemArray({itemList:sheetData.data.system.groups[index].skills}),sheetData.data.system.groups[index].isEmpty=0===sheetData.data.system.groups[index].skills.length,sheetData.data.system.groups[index].skills.sort(CoC7Utilities.sortByNameKey);sheetData.occupationPointsString=CoC7OccupationSheet.occupationPointsString(sheetData.data.system.occupationSkillPoints),sheetData.itemProperties=[];for(const[key,value]of Object.entries(sheetData.data.system.type))value&&sheetData.itemProperties.push(COC7.occupationProperties[key]?COC7.occupationProperties[key]:null);return sheetData.enrichedDescriptionValue=await TextEditor.enrichHTML(sheetData.data.system.description.value,{async:!0,secrets:sheetData.editable}),sheetData.enrichedDescriptionKeeper=await TextEditor.enrichHTML(sheetData.data.system.description.keeper,{async:!0,secrets:sheetData.editable}),sheetData.isKeeper=game.user.isGM,sheetData}static occupationPointsString(occupationSkillPoints){const optionnal=[],mandatory=[];for(const[key,carac]of Object.entries(occupationSkillPoints))if(carac.multiplier){const caracName=game.i18n.localize(`CHARAC.${key.toUpperCase()}`);carac.selected&&carac.optional&&optionnal.push(`${caracName}x${carac.multiplier}`),carac.selected&&!carac.optional&&mandatory.push(`${caracName}x${carac.multiplier}`)}let occupationPointsString="";const orString=` ${game.i18n.localize("CoC7.Or")} `;return mandatory.length&&(occupationPointsString+=mandatory.join(" + ")),optionnal.length&&mandatory.length&&(occupationPointsString+=` + (${optionnal.join(orString)})`),optionnal.length&&!mandatory.length&&(occupationPointsString+=optionnal.join(orString)),occupationPointsString}_updateObject(event,formData){const system=foundry.utils.expandObject(formData)?.system;if(system.groups){formData["system.groups"]=Object.values(system.groups||[]);for(let index=0;index<this.item.system.groups.length;index++)formData[`system.groups.${index}.skills`]=foundry.utils.duplicate(this.item.system.groups[index].skills)}super._updateObject(event,formData)}}class CoC7InvestigatorWizard extends FormApplication{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{id:"investigator-wizard-application",classes:["coc7","dialog","investigator-wizard"],title:game.i18n.localize("CoC7.InvestigatorWizard.Title"),template:"systems/CoC7/templates/apps/investigator-wizard.hbs",width:520,height:600,closeOnSubmit:!1,scrollY:[".scrollsection"],dragDrop:[{dragSelector:".draggable",dropSelector:null}]})}get pageList(){return{PAGE_NONE:-1,PAGE_INTRODUCTION:0,PAGE_CONFIGURATION:1,PAGE_SETUPS:2,PAGE_ARCHETYPES:3,PAGE_CHARACTISTICS:4,PAGE_ATTRIBUTES:5,PAGE_VIEW_ATTRIBUTES:6,PAGE_OCCUPATIONS:7,PAGE_OCCUPATION_SKILLS:8,PAGE_ARCHETYPE_SKILLS:9,PAGE_POINTS_SKILLS:10,PAGE_INVESTIGATOR:11,PAGE_BACKSTORY:12,PAGE_CREATE:13}}get characteristicsMethods(){return{METHOD_DEFAULT:1,METHOD_ROLL:1,METHOD_POINTS:2,METHOD_VALUES:3,METHOD_CHOOSE:4}}get cocidCreditRating(){return"i.skill.credit-rating"}get cocidLanguageOwn(){return"i.skill.language-own"}get pageOrder(){const pages=this.pageList;let pageOrder=[pages.PAGE_INTRODUCTION];return game.user.isGM&&pageOrder.push(pages.PAGE_CONFIGURATION),""===this.object.defaultSetup&&pageOrder.push(pages.PAGE_SETUPS),game.settings.get("CoC7","pulpRuleArchetype")&&pageOrder.push(pages.PAGE_ARCHETYPES),pageOrder.push(pages.PAGE_CHARACTISTICS),game.settings.get("CoC7","pulpRuleIgnoreAgePenalties")||pageOrder.push(pages.PAGE_ATTRIBUTES),pageOrder=pageOrder.concat([pages.PAGE_VIEW_ATTRIBUTES,pages.PAGE_OCCUPATIONS,pages.PAGE_OCCUPATION_SKILLS]),game.settings.get("CoC7","pulpRuleArchetype")&&pageOrder.push(pages.PAGE_ARCHETYPE_SKILLS),pageOrder=pageOrder.concat([pages.PAGE_POINTS_SKILLS,pages.PAGE_INVESTIGATOR,pages.PAGE_BACKSTORY,pages.PAGE_CREATE]),pageOrder}static async loadCacheItemByCoCID(){return new Promise(((resolve,reject)=>{game.system.api.cocid.fromCoCIDRegexBest({cocidRegExp:/^i\./,type:"i",showLoading:!0}).then((items=>{const list={};for(const item of items)list[item.flags.CoC7.cocidFlag.id]=item;resolve(list)}))}))}async filterCacheItemByCoCID(regexp){return Object.entries(await this.object.cacheCoCID).filter((entry=>entry[0].match(regexp))).map((entry=>entry[1]))}async getCacheItemByCoCID(id){return(await this.object.cacheCoCID)[id]??!1}async expandItemArray(itemList){const items=itemList.filter((it=>"string"!=typeof it)),cocids=itemList.filter((it=>"string"==typeof it));if(cocids.length){const source=await this.object.cacheCoCID,missing=[];for(const cocid of cocids)void 0!==source[cocid]?items.push(source[cocid]):missing.push(cocid);if(missing.length){const era=game.i18n.format(COC7.eras[this.object.defaultEra]??"CoC7.CoCIDFlag.error.unknown-era",{era:this.object.defaultEra});ui.notifications.warn(game.i18n.format("CoC7.CoCIDFlag.error.documents-not-found",{cocids:missing.join(", "),lang:game.i18n.lang,era}))}}return items}getAgeAdjustments(){for(const key in this.object.setupModifiers)this.object.setupModifiers[key]=0;if(!game.settings.get("CoC7","pulpRuleIgnoreAgePenalties")){if(this.object.age>=40){const key=Math.floor(this.object.age/10);this.object.requiresAgeAdjustments={edu:{total:key-2>4?4:key-2,rolled:!1},deduct:{total:key>1?5*Math.pow(2,key-4):0,from:["str","con","dex"],values:{}},reduce:{total:5*(key-3),from:"app"}}}else this.object.age>=20?this.object.requiresAgeAdjustments={edu:{total:1,rolled:!1}}:this.object.age>=15&&(this.object.requiresAgeAdjustments={deduct:{total:5,from:["str","siz"],values:{}},reduce:{total:5,from:"edu"},luck:!0});void 0!==this.object.requiresAgeAdjustments.reduce&&(this.object.setupModifiers[this.object.requiresAgeAdjustments.reduce.from]=-this.object.requiresAgeAdjustments.reduce.total)}}async getData(){const sheetData=await super.getData();let setup,archetype,occupation;sheetData.isKeeper=game.user.isGM,sheetData.pages=this.pageList,sheetData.canNext=!1,sheetData.createButton=!1;let showMonetary=!1;switch(sheetData.object.step){case sheetData.pages.PAGE_INTRODUCTION:sheetData.era=game.i18n.format(COC7.eras[sheetData.object.defaultEra]??"CoC7.CoCIDFlag.error.unknown-era",{era:sheetData.object.defaultEra}),sheetData.canNext=!0;break;case sheetData.pages.PAGE_CONFIGURATION:if(game.user.isGM){sheetData.setups=await this.filterCacheItemByCoCID(/^i\.setup\./),sheetData.setupOptions=sheetData.setups.reduce(((c,d)=>(c.push({key:d.flags.CoC7.cocidFlag.id,name:d.name}),c)),[]),sheetData.occupations=await this.filterCacheItemByCoCID(/^i\.occupation\./),sheetData.archetypes=await this.filterCacheItemByCoCID(/^i\.archetype\./),setup=sheetData.setups.find((s=>s.flags.CoC7.cocidFlag.id===sheetData.object.defaultSetup)),void 0===setup?(sheetData.object.defaultSetup="",sheetData.object.setup=""):sheetData.description=await TextEditor.enrichHTML(setup.system.description.value,{async:!0,secrets:game.user.isGM}),sheetData.ownership={[CONST.DOCUMENT_OWNERSHIP_LEVELS.NONE]:"OWNERSHIP.NONE",[CONST.DOCUMENT_OWNERSHIP_LEVELS.LIMITED]:"OWNERSHIP.LIMITED",[CONST.DOCUMENT_OWNERSHIP_LEVELS.OBSERVER]:"OWNERSHIP.OBSERVER",[CONST.DOCUMENT_OWNERSHIP_LEVELS.OWNER]:"OWNERSHIP.OWNER"},sheetData._eras=[];for(const[key,value]of Object.entries(COC7.eras))sheetData._eras.push({id:key,name:game.i18n.localize(value)});sheetData.characteristicsMethods=this.characteristicsMethods,sheetData.characteristicsMethod=sheetData.characteristicsMethods.METHOD_DEFAULT,sheetData.object.enforcePointBuy?sheetData.characteristicsMethod=sheetData.characteristicsMethods.METHOD_POINTS:this.object.chooseRolledValues?sheetData.characteristicsMethod=sheetData.characteristicsMethods.METHOD_CHOOSE:this.object.quickFireValues.length&&(sheetData.characteristicsMethod=sheetData.characteristicsMethods.METHOD_VALUES),sheetData._eras.sort(CoC7Utilities.sortByNameKey),sheetData.hasArchetypes=game.settings.get("CoC7","pulpRuleArchetype"),sheetData.canNext=!0}break;case sheetData.pages.PAGE_SETUPS:""===sheetData.object.defaultSetup&&(sheetData.setups=await this.filterCacheItemByCoCID(/^i\.setup\./),sheetData.setups.sort(CoC7Utilities.sortByNameKey),sheetData.setupOptions=sheetData.setups.reduce(((c,d)=>(c.push({key:d.flags.CoC7.cocidFlag.id,name:d.name}),c)),[]),""!==sheetData.object.setup&&(setup=sheetData.setups.find((s=>s.flags.CoC7.cocidFlag.id===sheetData.object.setup)),void 0!==setup&&(sheetData.description=await TextEditor.enrichHTML(setup.system.description.value,{async:!0,secrets:game.user.isGM}),sheetData.canNext=!0)));break;case sheetData.pages.PAGE_ARCHETYPES:if(sheetData.archetypes=await this.filterCacheItemByCoCID(/^i\.archetype\./),0===sheetData.archetypes.length)sheetData.canNext=!0;else if(sheetData.archetypes.sort(CoC7Utilities.sortByNameKey),sheetData.archetypeOptions=sheetData.archetypes.reduce(((c,d)=>(c.push({key:d.flags.CoC7.cocidFlag.id,name:d.name}),c)),[]),""!==sheetData.object.archetype&&(archetype=sheetData.archetypes.find((s=>s.flags.CoC7.cocidFlag.id===sheetData.object.archetype)),void 0!==archetype)){sheetData.description=await TextEditor.enrichHTML(archetype.system.description.value,{async:!0,secrets:game.user.isGM}),sheetData.bonusPoints=archetype.system.bonusPoints;const coreCharacteristics=[];for(const coreCharacteristic in archetype.system.coreCharacteristics)archetype.system.coreCharacteristics[coreCharacteristic]&&coreCharacteristics.push(coreCharacteristic);0===coreCharacteristics.length?this.object.coreCharacteristic="":1===coreCharacteristics.length&&(this.object.coreCharacteristic=coreCharacteristics[0]),sheetData.coreCharacteristic=coreCharacteristics.map((c=>c.toLocaleUpperCase())).join(" "+game.i18n.localize("CoC7.Or")+" ");const skills=[];archetype.system.skills=await this.expandItemArray(archetype.system.skills);for(const skill of archetype.system.skills)skills.push(skill.name);sheetData.skills=skills.join(", "),sheetData.suggestedOccupations=await TextEditor.enrichHTML(archetype.system.suggestedOccupations,{async:!0,secrets:game.user.isGM}),sheetData.suggestedTraits=await TextEditor.enrichHTML(archetype.system.suggestedTraits,{async:!0,secrets:game.user.isGM}),sheetData.canNext=!0}break;case sheetData.pages.PAGE_CHARACTISTICS:if(sheetData.characteristicsMethods=this.characteristicsMethods,sheetData.characteristicsMethod=sheetData.characteristicsMethods.METHOD_ROLL,""!==sheetData.object.setup&&(setup=await this.getCacheItemByCoCID(this.object.setup),void 0!==setup)){if(setup.system.characteristics.points.enabled||this.object.enforcePointBuy?sheetData.characteristicsMethod=sheetData.characteristicsMethods.METHOD_POINTS:this.object.chooseRolledValues?sheetData.characteristicsMethod=sheetData.characteristicsMethods.METHOD_CHOOSE:this.object.quickFireValues.length&&(sheetData.characteristicsMethod=sheetData.characteristicsMethods.METHOD_VALUES),sheetData.setup={total:0,points:setup.system.characteristics.points.value,characteristics:[{key:"str",roll:setup.system.characteristics.rolls.str,label:"CHARAC.Strength"},{key:"con",roll:setup.system.characteristics.rolls.con,label:"CHARAC.Constitution"},{key:"siz",roll:setup.system.characteristics.rolls.siz,label:"CHARAC.Size"},{key:"dex",roll:setup.system.characteristics.rolls.dex,label:"CHARAC.Dexterity"},{key:"app",roll:setup.system.characteristics.rolls.app,label:"CHARAC.Appearance"},{key:"int",roll:setup.system.characteristics.rolls.int,label:"CHARAC.Intelligence"},{key:"pow",roll:setup.system.characteristics.rolls.pow,label:"CHARAC.Power"},{key:"edu",roll:setup.system.characteristics.rolls.edu,label:"CHARAC.Education"}],luck:{roll:setup.system.characteristics.rolls.luck,label:"CoC7.Luck"}},sheetData.coreCharacteristics=[],""!==sheetData.object.archetype&&(archetype=await this.getCacheItemByCoCID(this.object.archetype),void 0!==archetype)){for(const coreCharacteristic in archetype.system.coreCharacteristics)archetype.system.coreCharacteristics[coreCharacteristic]&&sheetData.coreCharacteristics.push({key:coreCharacteristic,name:game.i18n.format(sheetData.setup.characteristics.find((c=>c.key===coreCharacteristic))?.label??"Unknown")});sheetData.coreCharacteristics.sort(CoC7Utilities.sortByNameKey),""!==this.object.coreCharacteristic&&archetype.system.coreCharacteristicsFormula.enabled&&(sheetData.setup.characteristics.find((c=>c.key===this.object.coreCharacteristic)).roll=archetype.system.coreCharacteristicsFormula.value)}let empties=!1;for(const key in sheetData.object.setupPoints)""!==sheetData.object.setupPoints[key]?"luck"!==key&&(sheetData.setup.total+=parseInt(sheetData.object.setupPoints[key],10)):empties=!0;this.object.coreCharacteristic&&(sheetData.coreCharacteristic=this.object.coreCharacteristic.toLocaleUpperCase()),!empties&&this.object.age>=15&&([sheetData.characteristicsMethods.METHOD_ROLL,sheetData.characteristicsMethods.METHOD_VALUES,sheetData.characteristicsMethods.METHOD_CHOOSE].includes(sheetData.characteristicsMethod)||sheetData.setup.total.toString()===sheetData.setup.points.toString())&&(sheetData.canNext=!0)}break;case sheetData.pages.PAGE_ATTRIBUTES:sheetData.pulpRuleIgnoreAgePenalties=game.settings.get("CoC7","pulpRuleIgnoreAgePenalties"),sheetData.canNext=!0,sheetData.points={};for(const key in this.object.setupModifiers)sheetData.points[key]={value:parseInt(this.object.setupPoints[key],10)+parseInt(this.object.setupModifiers[key],10),min:1-parseInt(this.object.setupPoints[key],10),label:CoC7Utilities.getCharacteristicNames(key).label};if(void 0===this.object.requiresAgeAdjustments.edu||this.object.requiresAgeAdjustments.edu.rolled||(sheetData.canNext=!1),void 0!==this.object.requiresAgeAdjustments.deduct){sheetData.deductTotal=0;for(const key of this.object.requiresAgeAdjustments.deduct.from)sheetData.deductTotal=sheetData.deductTotal-parseInt(this.object.setupModifiers[key],10);sheetData.deductFrom=this.object.requiresAgeAdjustments.deduct.from.map((n=>game.i18n.localize("CHARAC."+n.toUpperCase()))).join(", ").replace(/(, )([^,]+)$/,"$1"+game.i18n.localize("CoC7.Or")+" $2").replace(/^([^,]+),([^,]+)$/,"$1$2"),sheetData.deductTotal!==this.object.requiresAgeAdjustments.deduct.total&&(sheetData.canNext=!1)}void 0!==this.object.requiresAgeAdjustments.reduce&&(sheetData.reduceFrom=game.i18n.localize("CHARAC."+this.object.requiresAgeAdjustments.reduce.from.toUpperCase())),void 0!==this.object.requiresAgeAdjustments.luck&&(sheetData.luckValue=Math.max(this.object.setupPoints.luck,this.object.setupModifiers.luck),0===this.object.setupModifiers.luck&&(sheetData.canNext=!1));break;case sheetData.pages.PAGE_VIEW_ATTRIBUTES:sheetData.points={};for(const key in this.object.setupModifiers)sheetData.points[key]={value:parseInt(this.object.setupPoints[key],10)+parseInt(this.object.setupModifiers[key],10),prefix:"",suffix:"%",label:CoC7Utilities.getCharacteristicNames(key).label};sheetData.points.db={value:CoCActor.dbFromCharacteristics(sheetData.points),prefix:"",suffix:"",label:"CoC7.BonusDamage"},(isNaN(sheetData.points.db.value)||Number(sheetData.points.db.value)>=0)&&(sheetData.points.db.prefix="+"),sheetData.points.build={value:CoCActor.buildFromCharacteristics(sheetData.points),prefix:"",suffix:"",label:"CoC7.Build"},Number(sheetData.points.build.value)>=0&&(sheetData.points.build.prefix="+"),sheetData.points.hp={value:CoCActor.hpFromCharacteristics(sheetData.points,"character"),prefix:"",suffix:"",label:"CoC7.HitPoints"},sheetData.points.hp.prefix=sheetData.points.hp.value+"/",sheetData.points.mp={value:CoCActor.mpFromCharacteristics(sheetData.points),prefix:"",suffix:"",label:"CoC7.MagicPoints"},sheetData.points.mp.prefix=sheetData.points.mp.value+"/",sheetData.points.san={value:sheetData.points.pow.value,prefix:"",suffix:"/99",label:"CoC7.Sanity"},sheetData.points.mov={value:CoCActor.movFromCharacteristics(sheetData.points,"character",this.object.age),prefix:"",suffix:"",label:"CoC7.Movement"},sheetData.canNext=!0;break;case sheetData.pages.PAGE_OCCUPATIONS:if(sheetData.occupations=await this.filterCacheItemByCoCID(/^i\.occupation\./),sheetData.occupations.sort(CoC7Utilities.sortByNameKey),sheetData.occupationOptions=sheetData.occupations.reduce(((c,d)=>(c.push({key:d.flags.CoC7.cocidFlag.id,name:d.name}),c)),[]),""!==sheetData.object.occupation&&(occupation=sheetData.occupations.find((s=>s.flags.CoC7.cocidFlag.id===sheetData.object.occupation)),void 0!==occupation)){sheetData.description=await TextEditor.enrichHTML(occupation.system.description.value,{async:!0,secrets:game.user.isGM}),sheetData.occupationPointsString=CoC7OccupationSheet.occupationPointsString(occupation.system.occupationSkillPoints),sheetData.creditRating=occupation.system.creditRating,sheetData.personal=occupation.system.personal,sheetData.personalText=occupation.system.personalText,sheetData.skills=await this.expandItemArray(occupation.system.skills),sheetData.groups={};for(let index=0;index<occupation.system.groups.length;index++)sheetData.groups[index]={options:occupation.system.groups[index].options,skills:[]},sheetData.groups[index].skills=await this.expandItemArray(occupation.system.groups[index].skills);sheetData.points=0;const options=[];for(const[key,carac]of Object.entries(occupation.system.occupationSkillPoints))carac.selected&&(carac.optional?options.push(carac.multiplier*(parseInt(this.object.setupPoints[key],10)+parseInt(this.object.setupModifiers[key],10))):sheetData.points+=carac.multiplier*(parseInt(this.object.setupPoints[key],10)+parseInt(this.object.setupModifiers[key],10)));options.length>0&&(sheetData.points+=Math.max(...options)),sheetData.canNext=!0}break;case sheetData.pages.PAGE_INVESTIGATOR:sheetData.language=void 0!==this.object.skillItems[this.cocidLanguageOwn],sheetData.language?sheetData.languageName=this.object.skillItems[this.cocidLanguageOwn].item.name:sheetData.languageName="",sheetData.canNext=!0;break;case sheetData.pages.PAGE_OCCUPATION_SKILLS:sheetData.default=0,sheetData.selected=0,sheetData.skillItems=[];for(const key in this.object.skillItems){let group="other";const rows=sheetData.object.skillItems[key].rows.length,isMultiple=sheetData.object.skillItems[key].flags.isMultiple;isMultiple&&sheetData.skillItems.push({key,index:-1,name:sheetData.object.skillItems[key].item.name,group,toggle:!1,isCreditRating:!1,isMultiple:!0,isPickable:!1});for(let index=0;index<rows;index++){let isPickable=!1;sheetData.object.skillItems[key].rows[index].isOccupationDefault?(group="default",isMultiple&&(isPickable=!0),sheetData.default++):!1!==sheetData.object.skillItems[key].rows[index].inOccupationGroup?(group=sheetData.object.skillItems[key].rows[index].inOccupationGroup,isMultiple&&(isPickable=!0)):group="other";let toggle=sheetData.object.skillItems[key].rows[index].occupationToggle;isPickable&&(toggle=!1);let specialization=sheetData.object.skillItems[key].item.system.specialization,skillName=sheetData.object.skillItems[key].item.system.skillName,picked=!1,deleteable=!1;"string"==typeof sheetData.object.skillItems[key].rows[index].selected?(picked=!0,skillName=sheetData.object.skillItems[key].rows[index].selected):!1!==sheetData.object.skillItems[key].rows[index].selected&&(picked=!0,specialization=sheetData.object.skillItems[key].rows[index].selected.system.specialization,skillName=sheetData.object.skillItems[key].rows[index].selected.system.skillName),(toggle||isPickable&&picked)&&sheetData.selected++;let name=sheetData.object.skillItems[key].item.name;(key===this.cocidLanguageOwn||!isPickable&&picked)&&(name=specialization+" ("+skillName+")"),!isPickable&&picked&&(deleteable=!sheetData.object.skillItems[key].rows[index].archetypeToggle),sheetData.skillItems.push({key,index,name,group:group.toString(),toggle,isCreditRating:sheetData.object.skillItems[key].rows[index].isCreditRating,isMultiple:!1,isPickable,picked,deleteable,specialization,skillName})}}sheetData.max=(parseInt(sheetData.default,10)||0)+(parseInt(sheetData.object.personal,10)||0)+Object.values(sheetData.object.occupationGroups).reduce(((s,v)=>s+(parseInt(v,10)||0)),0),sheetData.skillItems.sort(CoC7Utilities.sortByNameKey),sheetData.selected===sheetData.max&&(sheetData.canNext=!0);break;case sheetData.pages.PAGE_ARCHETYPE_SKILLS:sheetData.max=0,sheetData.selected=0,sheetData.skillItems=[];for(const key in this.object.skillItems){let group="other";const rows=sheetData.object.skillItems[key].rows.length,isMultiple=sheetData.object.skillItems[key].flags.isMultiple;isMultiple&&sheetData.skillItems.push({key,index:-1,name:sheetData.object.skillItems[key].item.name,group,toggle:!1,isCreditRating:!1,isMultiple:!0,isPickable:!1});for(let index=0;index<rows;index++){let isPickable=!1;sheetData.object.skillItems[key].rows[index].isArchetypeDefault?(group="default",isMultiple&&(isPickable=!0),sheetData.max++):group="other";let toggle=sheetData.object.skillItems[key].rows[index].archetypeToggle;isPickable&&(toggle=!1);let specialization=sheetData.object.skillItems[key].item.system.specialization,skillName=sheetData.object.skillItems[key].item.system.skillName,picked=!1,deleteable=!1;"string"==typeof sheetData.object.skillItems[key].rows[index].selected?(picked=!0,skillName=sheetData.object.skillItems[key].rows[index].selected):!1!==sheetData.object.skillItems[key].rows[index].selected&&(picked=!0,specialization=sheetData.object.skillItems[key].rows[index].selected.system.specialization,skillName=sheetData.object.skillItems[key].rows[index].selected.system.skillName),(toggle||isPickable&&picked)&&sheetData.selected++;let name=sheetData.object.skillItems[key].item.name;(key===this.cocidLanguageOwn||!isPickable&&picked)&&(name=specialization+" ("+skillName+")"),!isPickable&&picked&&(deleteable=!sheetData.object.skillItems[key].rows[index].occupationToggle),sheetData.skillItems.push({key,index,name,group:group.toString(),toggle,isCreditRating:!1,isMultiple:!1,isPickable,picked,deleteable,specialization,skillName})}}sheetData.skillItems.sort(CoC7Utilities.sortByNameKey),sheetData.selected===sheetData.max&&(sheetData.canNext=!0);break;case sheetData.pages.PAGE_POINTS_SKILLS:if(sheetData.skills=[],sheetData.creditRatingOkay=!(this.object.creditRating.max>0),sheetData.personal={count:0,total:2*(parseInt(this.object.setupPoints.int,10)+parseInt(this.object.setupModifiers.int,10)),remaining:0},sheetData.occupation={count:0,total:0,remaining:0},sheetData.archetype={count:0,total:0,remaining:0},""!==sheetData.object.setup&&(showMonetary=(await this.getCacheItemByCoCID(sheetData.object.setup)).system.monetary.values.length>0),""!==sheetData.object.occupation&&(occupation=await this.getCacheItemByCoCID(this.object.occupation),occupation)){const options=[];for(const[key,carac]of Object.entries(occupation.system.occupationSkillPoints))carac.selected&&(carac.optional?options.push(carac.multiplier*(parseInt(this.object.setupPoints[key],10)+parseInt(this.object.setupModifiers[key],10))):sheetData.occupation.total+=carac.multiplier*(parseInt(this.object.setupPoints[key],10)+parseInt(this.object.setupModifiers[key],10)));options.length>0&&(sheetData.occupation.total+=Math.max(...options))}if(""!==this.object.archetype){const archetype=await game.system.api.cocid.fromCoCID(this.object.archetype);1===archetype.length&&(sheetData.archetype.total=archetype[0].system.bonusPoints)}if(Object.keys(this.object.skillItems).length>0){for(const key in this.object.skillItems){const skill=this.object.skillItems[key];for(let index=0,im=skill.rows.length;index<im;index++){const row=skill.rows[index];if(!skill.flags.isMultiple||!1!==row.selected){let item=foundry.utils.duplicate(skill.item);!1!==row.selected&&"string"!=typeof row.selected&&(item=foundry.utils.duplicate(row.selected));let base=item.system.base;if(!Number.isNumeric(base))for(const key in this.object.setupPoints){const regEx=new RegExp("@"+key,"i");base=base.replace(regEx,parseInt(this.object.setupPoints[key],10)+parseInt(this.object.setupModifiers[key],10))}Number.isNumeric(base)||(base=Math.floor(new AverageRoll("("+base+")")[foundry.utils.isNewerVersion(game.version,"12")?"evaluateSync":"evaluate"]({minimize:!0,maximize:!0}).total));let totalPoints=parseInt(base,10);if(Number(row.personalPoints)>0){const num=Number(row.personalPoints);sheetData.personal.count+=num,totalPoints+=num}if(Number(row.occupationPoints)>0){const num=Number(row.occupationPoints);sheetData.occupation.count+=num,totalPoints+=num}if(Number(row.archetypePoints)>0){const num=Number(row.archetypePoints);sheetData.archetype.count+=num,totalPoints+=num}if(Number(row.experiencePoints)>0){totalPoints+=Number(row.experiencePoints)}let name=item.name;key===this.cocidLanguageOwn?name=item.system.specialization+" ("+item.system.skillName+")":skill.flags.isCreditRating?(name=name+" ["+this.object.creditRating.min+" - "+this.object.creditRating.max+"]",totalPoints>=this.object.creditRating.min&&totalPoints<=this.object.creditRating.max&&(sheetData.creditRatingOkay=!0)):"string"==typeof row.selected&&(name=item.system.specialization+" ("+row.selected+")"),sheetData.skills.push({key,index,name,isOccupation:row.occupationToggle,isArchetype:row.archetypeToggle,base,personalPoints:row.personalPoints,occupationPoints:row.occupationPoints,archetypePoints:row.archetypePoints,experiencePoints:row.experiencePoints,totalPoints,showCreditRating:showMonetary&&key===this.cocidCreditRating})}}}sheetData.skills.sort(CoC7Utilities.sortByNameKey),sheetData.creditRatingOkay&&(sheetData.canNext=!0)}sheetData.personal.remaining=sheetData.personal.total-sheetData.personal.count,sheetData.occupation.remaining=sheetData.occupation.total-sheetData.occupation.count,sheetData.archetype.remaining=sheetData.archetype.total-sheetData.archetype.count;break;case sheetData.pages.PAGE_BACKSTORY:{const allBackstories=await this.object.cacheBackstories;sheetData.backstories={};for(let index=0;index<this.object.bioSections.length;index++){let rolls="";if(this.object.bioSections[index].name.startsWith("rt.."))rolls=this.object.bioSections[index].name;else{const match=this.object.bioSections[index].name.match(/^CoC7\.CoCIDFlag\.keys\.(rt\.\..+)$/);match&&(rolls=match[1])}sheetData.backstories[index]={index,name:this.object.bioSections[index].name,rolls:""!==rolls&&game.system.api.cocid.findCocIdInList(rolls,allBackstories).length?rolls:"",value:this.object.bioSections[index].value}}}sheetData.canNext=!0,sheetData.createButton=game.user.hasPermission("ACTOR_CREATE");break;case sheetData.pages.PAGE_CREATE:sheetData.canNext=!0,sheetData.createButton=!0}return sheetData}activateListeners(html){super.activateListeners(html),html.keypress((e=>/textarea/i.test((e.target||e.srcElement).tagName)||13!==(e.keyCode||e.which||e.charCode||0))),html.find(".submit_on_change").change(this._onChangeSubmit.bind(this)),html.find(".roll-characteristic").click(this._onRollCharacteristic.bind(this)),html.find(".increase-10-characteristic").click(this._onIncreaseCharacteristic10.bind(this)),html.find(".increase-characteristic").click(this._onIncreaseCharacteristic.bind(this)),html.find(".decrease-characteristic").click(this._onDecreaseCharacteristic.bind(this)),html.find(".decrease-10-characteristic").click(this._onDecreaseCharacteristic10.bind(this)),html.find("button.roll_all").click(this._onRollAll.bind(this)),html.find("button.roll_choose").click(this._onRollChoose.bind(this)),html.find("button.roll_edu").click(this._onRollEdu.bind(this)),html.find("button.roll_luck").click(this._onRollLuck.bind(this)),html.find(".item input.submit_on_blur").blur(this._onChangeSubmit.bind(this)),html.find(".item input.save-characteristic-on-blur").blur(this._onChangeSaveCharacteristic.bind(this)),html.find(".item.toggleable").click(this._onToggleSkill.bind(this)),html.find(".item.clickable").click(this._onClickPickSkill.bind(this)),html.find(".skills-list input").click(this._onClickSkillSpecial.bind(this)),html.find(".skills-list .remove-skill").click(this._onClickRemoveSkill.bind(this)),html.find(".item input.skill-adjustment").blur(this._onChangeSkillPoints.bind(this)),html.find("textarea.backstory-text").keyup(this._onChangeBackstoryText.bind(this)),html.find("button.backstory-roll").click(this._onRollBackstory.bind(this)),html.find("button.backstory-reset").click(this._onResetBackstory.bind(this))}async rollMessage(rolls){if(rolls.length){const html=[];for(const roll of rolls)html.push(await renderTemplate(Roll.CHAT_TEMPLATE,{formula:(CoC7Utilities.getCharacteristicNames(roll[0])?.label??roll[0])+": "+roll[1],tooltip:await roll[2].getTooltip(),total:roll[2].total}));ChatMessage.create({user:game.user.id,speaker:{alias:game.user.name},content:html.join("<div>&nbsp;</div>"),whisper:ChatMessage.getWhisperRecipients("GM")})}}addItemToList(item,{isOccupationDefault=!1,inOccupationGroup=!1,occupationToggle=!1,isArchetypeDefault=!1,archetypeToggle=!1,isCreditRating=!1}={}){const key=item.flags.CoC7?.cocidFlag?.id??item.name;if("skill"!==item.type)return void this.object.investigatorItems.push(item);const isMultiple=!(!item.system.properties.special||!(item.system.properties.requiresname&&!item.system.properties.onlyone||item.system.properties.picknameonly||item.name===game.i18n.format("CoC7.AnySpecName"))),flags={isOccupationDefault,inOccupationGroup,isArchetypeDefault,isCreditRating,occupationToggle,archetypeToggle},rows={occupationPoints:"",archetypePoints:"",experiencePoints:"",personalPoints:"",selected:!1};if(void 0===this.object.skillItems[key])this.object.skillItems[key]={item,flags:foundry.utils.mergeObject(flags,{isMultiple},{inplace:!1}),rows:[]},isMultiple&&!1===isOccupationDefault&&!1===inOccupationGroup&&!1===isArchetypeDefault||this.object.skillItems[key].rows.push(foundry.utils.mergeObject(flags,rows,{inplace:!1}));else{if(isMultiple)this.object.skillItems[key].rows.push(foundry.utils.mergeObject(flags,rows,{inplace:!1}));else for(const flag in flags)this.object.skillItems[key].rows[0][flag]=this.object.skillItems[key].rows[0][flag]||flags[flag];for(const flag in flags)this.object.skillItems[key].flags[flag]=this.object.skillItems[key].flags[flag]||flags[flag]}!isMultiple&&flags.isCreditRating&&(this.object.skillItems[key].rows[0].occupationPoints=this.object.creditRating.min)}clearSetupPoints(){for(const key in this.object.setupPoints)this.object.setupPoints[key]="";this.object.rolledValues=[]}async setSkillLists(){this.object.skillItems={},this.object.occupationGroups={},this.object.investigatorItems=[],this.object.placeable=foundry.utils.duplicate(this.object.quickFireValues);const setup=await this.getCacheItemByCoCID(this.object.setup),occupation=await this.getCacheItemByCoCID(this.object.occupation);let archetype=!1;if(""!==this.object.archetype&&(archetype=await this.getCacheItemByCoCID(this.object.archetype)),setup&&occupation&&(!game.settings.get("CoC7","pulpRuleArchetype")||archetype)){this.object.bioSections=[];for(let index=0;index<setup.system.bioSections.length;index++)this.object.bioSections.push({name:setup.system.bioSections[index],value:""});this.object.personal=occupation.system.personal,this.object.personalText=occupation.system.personalText,this.object.creditRating=occupation.system.creditRating;let items=[];items=await this.expandItemArray(setup.system.items);for(let index=0,im=items.length;index<im;index++)this.addItemToList(items[index]);items=await this.expandItemArray(occupation.system.skills);for(let index=0,im=items.length;index<im;index++)this.addItemToList(items[index],{isOccupationDefault:!0,occupationToggle:!0});for(let group=0,gm=occupation.system.groups.length;group<gm;group++){this.object.occupationGroups[group]=occupation.system.groups[group].options,items=await this.expandItemArray(occupation.system.groups[group].skills);for(let index=0,im=items.length;index<im;index++)this.addItemToList(items[index],{inOccupationGroup:group})}if(archetype){items=await this.expandItemArray(archetype.system.skills);for(let index=0,im=items.length;index<im;index++)this.addItemToList(items[index],{isArchetypeDefault:!0,archetypeToggle:!0})}if(Number(this.object.creditRating.max)>0){const nameCreditRating=game.i18n.format("CoC7.CoCIDFlag.keys."+this.cocidCreditRating),flags={isOccupationDefault:!0,occupationToggle:!0,isCreditRating:!0};if(void 0!==this.object.skillItems[this.cocidCreditRating])this.addItemToList(this.object.skillItems[this.cocidCreditRating].item,flags);else if(void 0!==this.object.skillItems[nameCreditRating])this.addItemToList(this.object.skillItems[nameCreditRating].item,flags);else{const skill=await game.system.api.cocid.fromCoCID(this.cocidCreditRating);skill.length&&this.addItemToList(skill[0],flags)}}}}_onDragStart(event){if(event.currentTarget.dataset.characteristicKey){const dragData={type:"investigatorCharacteristic",key:event.currentTarget.dataset.characteristicKey,value:event.currentTarget.dataset.value};event.dataTransfer.setData("text/plain",JSON.stringify(dragData))}else if(event.currentTarget.dataset.offset){const dragData={type:"investigatorValue",offset:event.currentTarget.dataset.offset};event.dataTransfer.setData("text/plain",JSON.stringify(dragData))}}_canDragStart(selector){return!0}_canDragDrop(selector){return!0}async _onDrop(event){try{const dataList=JSON.parse(event.dataTransfer.getData("text/plain"));if("investigatorCharacteristic"===dataList.type){if(dataList.destination=event.target.closest("li").dataset.characteristicKey,void 0===dataList.destination&&(dataList.destination=event.target.closest("li").dataset.empty),dataList.okay=!1,"x"===dataList.destination){const offset=this.object.rolledValues.findIndex((i=>!0===i.assigned));offset>-1&&(this.object.rolledValues[offset]={value:this.object.setupPoints[dataList.key],assigned:!1},this.object.setupPoints[dataList.key]=""),dataList.okay=!0}else if("-"===dataList.key&&void 0!==this.object.setupPoints[dataList.destination]){const index=this.object.placeable.indexOf(parseInt(dataList.value,10));-1!==index&&this.object.placeable.splice(index,1),""!==this.object.setupPoints[dataList.destination]&&this.object.placeable.push(parseInt(this.object.setupPoints[dataList.destination],10)),this.object.setupPoints[dataList.destination]=parseInt(dataList.value,10),this.object.placeable.sort().reverse(),dataList.okay=!0}else if(void 0!==this.object.setupPoints[dataList.key]&&"-"===dataList.destination)""!==this.object.setupPoints[dataList.key]&&(this.object.placeable.push(parseInt(this.object.setupPoints[dataList.key],10)),this.object.setupPoints[dataList.key]="",this.object.placeable.sort().reverse(),dataList.okay=!0);else if(void 0!==this.object.setupPoints[dataList.key]&&void 0!==this.object.setupPoints[dataList.destination]){const temp=""===this.object.setupPoints[dataList.key]?"":parseInt(this.object.setupPoints[dataList.key],10);this.object.setupPoints[dataList.key]=""===this.object.setupPoints[dataList.destination]?"":parseInt(this.object.setupPoints[dataList.destination],10),this.object.setupPoints[dataList.destination]=temp,dataList.okay=!0}if(dataList.okay)return void this.render(!0)}else if("investigatorValue"===dataList.type){if(dataList.destination=event.target.closest("li").dataset.characteristicKey,dataList.okay=!1,void 0!==dataList.destination&&!1===this.object.rolledValues[dataList.offset].assigned){let old;""!==this.object.setupPoints[dataList.destination]&&(old=this.object.setupPoints[dataList.destination]),this.object.setupPoints[dataList.destination]=this.object.rolledValues[dataList.offset].value,void 0!==old?this.object.rolledValues[dataList.offset].value=old:this.object.rolledValues[dataList.offset].assigned=!0,dataList.okay=!0}if(dataList.okay)return void this.render(!0)}}catch(err){}const dataList=await CoC7Utilities.getDataFromDropEvent(event,"Item");if([this.pageList.PAGE_ARCHETYPE_SKILLS,this.pageList.PAGE_OCCUPATION_SKILLS].includes(this.object.step))for(const item of dataList)"skill"===item.type&&(this.addItemToList(item),this.render(!0))}_onClickSkillSpecial(event){event.stopPropagation()}_onClickRemoveSkill(event){event.stopPropagation();const key=event.currentTarget?.parentNode?.dataset?.key,index=event.currentTarget?.parentNode?.dataset?.index;void 0!==this.object.skillItems[key]?.rows[index]&&(this.object.skillItems[key].rows.splice(index,index),this.render(!0))}async _onToggleSkill(event){const key=event.currentTarget?.dataset?.key,index=event.currentTarget?.dataset?.index,toggleKey=event.currentTarget?.dataset?.toggleKey;void 0!==this.object.skillItems[key]?.rows[index]&&(this.object.skillItems[key].rows[index][toggleKey]=!this.object.skillItems[key].rows[index][toggleKey],this.render(!0))}async _onClickPickSkill(event){const key=event.currentTarget?.dataset?.key,index=event.currentTarget?.dataset?.index,toggleKey=event.currentTarget?.dataset?.toggleKey;if(void 0!==this.object.skillItems[key]){index>-1&&(this.object.skillItems[key].rows[index][toggleKey]=!1,this.object.skillItems[key].rows[index].selected=!1,this.render(!0));let skillList=[];const group=game.system.api.cocid.guessGroupFromKey(key);group&&(skillList=(await game.system.api.cocid.fromCoCIDRegexBest({cocidRegExp:new RegExp("^"+CoC7Utilities.quoteRegExp(group)+".+$"),type:"i"})).filter((item=>!(item.system.properties?.special&&(item.system.properties?.requiresname||item.system.properties?.picknameonly)))),skillList.length>1&&skillList.sort(CoC7Utilities.sortByNameKey));const skillData=await SkillSpecializationSelectDialog.create({skills:skillList,allowCustom:this.object.skillItems[key].item.system.properties?.requiresname??!1,fixedBaseValue:!0,specializationName:this.object.skillItems[key].item.system.specialization,label:this.object.skillItems[key].item.name});if(index>-1)""!==skillData.selected?(this.object.skillItems[key].rows[index].selected=skillList.find((i=>i.id===skillData.selected)),this.object.skillItems[key].rows[index][toggleKey]=!0):""!==skillData.name&&(this.object.skillItems[key].rows[index].selected=skillData.name,this.object.skillItems[key].rows[index][toggleKey]=!0);else{let selected=!1;""!==skillData.selected?selected=skillList.find((i=>i.id===skillData.selected)):""!==skillData.name&&(selected=skillData.name),this.object.skillItems[key].rows.push({isOccupationDefault:!1,inOccupationGroup:!1,isArchetypeDefault:!1,isCreditRating:!1,occupationToggle:"occupationToggle"===toggleKey,archetypeToggle:"archetypeToggle"===toggleKey,occupationPoints:"",archetypePoints:"",experiencePoints:"",personalPoints:"",selected})}this.render(!0)}}async _onChangeSkillPoints(event){const input=$(event.currentTarget),adjustment=input.data("adjustment"),li=input.closest("li"),key=li.data("key"),index=li.data("index");void 0!==this.object.skillItems[key]?.rows[index][adjustment]&&(this.object.skillItems[key].rows[index][adjustment]=input.val()),this.render(!0)}async _onChangeBackstoryText(event){const textarea=$(event.currentTarget),index=textarea.data("index");void 0!==this.object.bioSections[index]&&(this.object.bioSections[index].value=textarea.val())}async _onRollBackstory(event){const button=$(event.currentTarget),index=button.data("index"),key=button.data("key");if(void 0!==this.object.bioSections[index]){const rolltable=await game.system.api.cocid.fromCoCID(key);if(1===rolltable.length){const tableResults=await rolltable[0].roll();for(const tableResult of tableResults.results)tableResult.type===CONST.TABLE_RESULT_TYPES.TEXT&&(this.object.bioSections[index].value=(this.object.bioSections[index].value+"\n"+tableResult.text.trim()).trim())}}this.render(!0)}async _onResetBackstory(event){const index=$(event.currentTarget).data("index");void 0!==this.object.bioSections[index]&&(this.object.bioSections[index].value=""),this.render(!0)}async _onRollLuck(event){const setup=await this.getCacheItemByCoCID(this.object.setup);if(setup){const die=await new Roll(setup.system.characteristics.rolls.luck.toString()).evaluate();this.object.setupModifiers.luck=[die.total];const html=await renderTemplate(Roll.CHAT_TEMPLATE,{formula:game.i18n.localize("CoC7.InvestigatorWizard.RollTwiceForLuck")+": "+setup.system.characteristics.rolls.luck.toString(),tooltip:await die.getTooltip(),total:die.total});ChatMessage.create({user:game.user.id,speaker:{alias:game.user.name},content:html,whisper:ChatMessage.getWhisperRecipients("GM")}),this.render(!0)}}async _onRollEdu(event){if(event.preventDefault(),void 0!==this.object.requiresAgeAdjustments.edu&&!this.object.requiresAgeAdjustments.edu.rolled&&this.object.requiresAgeAdjustments.edu.total){let value=parseInt(this.object.setupPoints.edu,10);const message=[];for(let rolls=this.object.requiresAgeAdjustments.edu.total;rolls>0;rolls--){const die=await new Roll("1d100").evaluate();if(die.total>value){const augmentDie=await new Roll("1d10").evaluate();message.push(`<span class="upgrade-success">${game.i18n.format("CoC7.DevSuccess",{item:game.i18n.localize("CHARAC.Education"),die:die.total,score:value,augment:augmentDie.total})}</span><br>`),value+=parseInt(augmentDie.total,10)}else message.push(`<span class="upgrade-failed">${game.i18n.format("CoC7.DevFailure",{item:game.i18n.localize("CHARAC.Education"),die:die.total,score:value})}</span><br>`)}ChatMessage.create({flavor:game.i18n.localize("CoC7.RollAll4Dev"),user:game.user.id,speaker:{alias:game.user.name},content:message.join(""),whisper:ChatMessage.getWhisperRecipients("GM")}),this.object.setupModifiers.edu=value-parseInt(this.object.setupPoints.edu,10),this.object.requiresAgeAdjustments.edu.rolled=!0,this.render(!0)}}async _onRollAll(event){event.preventDefault();const rolls=[];for(const key of["str","con","siz","dex","app","int","pow","edu","luck"]){const result=await this.rollCharacteristic(key);!1!==result&&rolls.push(result)}this.rollMessage(rolls),this.render(!0)}async _onRollChoose(event){if(event.preventDefault(),""!==this.object.setup){const setup=await this.getCacheItemByCoCID(this.object.setup);if(void 0!==setup){const rollFormulas={};for(const key of["str","con","siz","dex","app","int","pow","edu"])rollFormulas[key]=setup.system.characteristics.rolls[key];if(""!==this.object.archetype){const archetype=await this.getCacheItemByCoCID(this.object.archetype);void 0!==archetype&&""!==this.object.coreCharacteristic&&archetype.system.coreCharacteristicsFormula.enabled&&(rollFormulas[this.object.coreCharacteristic]=archetype.system.coreCharacteristicsFormula.value)}this.object.rolledValues=[];const html=[];for(const key in rollFormulas){const roll=new Roll(rollFormulas[key].toString());await roll.evaluate(),this.object.rolledValues.push({value:roll.total,assigned:!1}),html.push(await renderTemplate(Roll.CHAT_TEMPLATE,{formula:rollFormulas[key].toString(),tooltip:await roll.getTooltip(),total:roll.total}))}ChatMessage.create({user:game.user.id,speaker:{alias:game.user.name},content:html.join("<div>&nbsp;</div>"),whisper:ChatMessage.getWhisperRecipients("GM")})}}this.render(!0)}async _onIncreaseCharacteristic10(event){event.preventDefault();const li=event.currentTarget.closest(".item");void 0!==li.dataset.offset&&void 0!==li.dataset.min&&void 0!==li.dataset.max?this.modifyOffset(li.dataset.offset,10,li.dataset.min,li.dataset.max):void 0!==li.dataset.key&&this.modifyCharacteristic(li.dataset.key,10),this.render(!0)}async _onIncreaseCharacteristic(event){event.preventDefault();const li=event.currentTarget.closest(".item");void 0!==li.dataset.offset&&void 0!==li.dataset.min&&void 0!==li.dataset.max?this.modifyOffset(li.dataset.offset,1,li.dataset.min,li.dataset.max):void 0!==li.dataset.key&&this.modifyCharacteristic(li.dataset.key,1),this.render(!0)}async _onDecreaseCharacteristic(event){event.preventDefault();const li=event.currentTarget.closest(".item");void 0!==li.dataset.offset&&void 0!==li.dataset.min&&void 0!==li.dataset.max?this.modifyOffset(li.dataset.offset,-1,li.dataset.min,li.dataset.max):void 0!==li.dataset.key&&this.modifyCharacteristic(li.dataset.key,-1),this.render(!0)}_onDecreaseCharacteristic10(event){event.preventDefault();const li=event.currentTarget.closest(".item");void 0!==li.dataset.offset&&void 0!==li.dataset.min&&void 0!==li.dataset.max?this.modifyOffset(li.dataset.offset,-10,li.dataset.min,li.dataset.max):void 0!==li.dataset.key&&this.modifyCharacteristic(li.dataset.key,-10),this.render(!0)}modifyOffset(key,value,min,max){this.object.setupModifiers[key]=Math.max(Math.min(parseInt(this.object.setupModifiers[key],10)+value,parseInt(max,10)),parseInt(min,10))}modifyCharacteristic(key,value){const li=this._element[0].querySelector(`li.item[data-key=${key}]`),input=li?.querySelector("input");input&&(input.value=Number(input.value)+value,this.object.setupPoints[key]=Number(input.value))}async _onRollCharacteristic(event){event.preventDefault();const characKey=event.currentTarget.closest(".item").dataset.key,result=await this.rollCharacteristic(characKey);!1!==result&&this.rollMessage([result]),this.render(!0)}async rollCharacteristic(key){const li=$(`#investigator-wizard-application li.item[data-key=${key}]`),input=li.find("input"),formula=li.data("roll");if(input&&formula&&(this.object.rerollsEnabled||""===this.object.setupPoints[key])){const roll=new Roll(formula.toString());return await roll.evaluate(),input.val(roll.total),this.object.setupPoints[key]=Number(roll.total),[key,formula.toString(),roll]}return!1}_onChangeSubmit(event){this._onSubmit(event)}_onChangeSaveCharacteristic(event){const obj=$(event.currentTarget),name=obj.prop("name");if(void 0!==this.object.setupPoints[name]){this.object.setupPoints[name]=obj.val();let empties=!1,total=0;for(const key in this.object.setupPoints)""!==this.object.setupPoints[key]?"luck"!==key&&(total+=parseInt(this.object.setupPoints[key],10)):empties=!0;const objTotal=obj.closest("ol.item-list").find("span.total"),max=parseInt(objTotal.siblings("span.value").text(),10);objTotal.text(total),total!==max||empties?obj.closest("form").find("button.submit-button[data-button=next]").length>0&&this.render(!0):0===obj.closest("form").find("button.submit-button[data-button=next]").length&&this.render(!0)}}getPageNumber(direction){const pageOrder=this.pageOrder,key=parseInt(Object.keys(pageOrder).find((key=>pageOrder[key]===this.object.step)),10)+direction;return pageOrder[key]}async _updateObject(event,formData){if(["back","next"].includes(event.submitter?.dataset.button)){if(event.submitter.className.indexOf("currently-submitting")>-1)return;event.submitter.className=event.submitter.className+" currently-submitting"}if(void 0!==formData["default-setup"]&&void 0!==formData["world-era"]&&void 0!==formData["default-ownership"]){if(this.object.defaultSetup!==formData["default-setup"]&&(this.object.defaultSetup=formData["default-setup"],game.settings.set("CoC7","InvestigatorWizardSetup",this.object.defaultSetup),this.object.setup=this.object.defaultSetup,this.clearSetupPoints(),await this.setSkillLists()),this.object.defaultOwnership!==formData["default-ownership"]&&(this.object.defaultOwnership=formData["default-ownership"],game.settings.set("CoC7","InvestigatorWizardOwnership",this.object.defaultOwnership)),this.object.defaultEra!==formData["world-era"]){const obj=$(this.element.find("form")),started=Date.now();obj.find(".dialog-buttons:first").hide(),obj.find(".scrollsection:first").hide(),obj.find(".erachange:first").show(),this.object.defaultEra=formData["world-era"],await game.settings.set("CoC7","worldEra",this.object.defaultEra),this.object.cacheCoCID=await CoC7InvestigatorWizard.loadCacheItemByCoCID();const buffer=500-(Date.now()-started);buffer>10&&await new Promise((resolve=>setTimeout(resolve,buffer)))}if(void 0!==formData["characteristics-method"]){const type=Number(formData["characteristics-method"]);type===this.characteristicsMethods.METHOD_DEFAULT?(this.object.enforcePointBuy=!1,this.object.chooseRolledValues=!1,this.object.quickFireValues=[]):type===this.characteristicsMethods.METHOD_POINTS?(this.object.enforcePointBuy=!0,this.object.chooseRolledValues=!1,this.object.quickFireValues=[]):type===this.characteristicsMethods.METHOD_VALUES?(this.object.enforcePointBuy=!1,this.object.chooseRolledValues=!1,game.settings.get("CoC7","pulpRuleArchetype")?this.object.quickFireValues=[90,80,70,60,60,50,50,40]:this.object.quickFireValues=[80,70,60,60,50,50,50,40]):type===this.characteristicsMethods.METHOD_CHOOSE&&(this.object.enforcePointBuy=!1,this.object.chooseRolledValues=!0,this.object.quickFireValues=[]),game.settings.set("CoC7","InvestigatorWizardPointBuy",this.object.enforcePointBuy),game.settings.set("CoC7","InvestigatorWizardQuickFire",this.object.quickFireValues),game.settings.set("CoC7","InvestigatorWizardChooseValues",this.object.chooseRolledValues)}this.object.rerollsEnabled="string"==typeof formData["rerolls-enabled"],game.settings.set("CoC7","InvestigatorWizardRerolls",this.object.rerollsEnabled);for(let i=0,im=this.object.quickFireValues.length;i<im;i++){const num=Number(formData["quick-fire-values-"+i]);num>0&&(this.object.quickFireValues[i]=num)}this.object.quickFireValues.sort().reverse(),this.object.placeable=foundry.utils.duplicate(this.object.quickFireValues),"string"==typeof formData["default-enabled"]?"0"===this.object.defaultQuantity.toString()?(this.object.defaultQuantity=1,game.settings.set("CoC7","InvestigatorWizardQuantity",this.object.defaultQuantity)):(this.object.defaultQuantity=formData["default-quantity"],game.settings.set("CoC7","InvestigatorWizardQuantity",this.object.defaultQuantity)):"0"!==this.object.defaultQuantity.toString()&&(this.object.defaultQuantity=0,game.settings.set("CoC7","InvestigatorWizardQuantity",this.object.defaultQuantity))}else if(void 0!==formData["coc-setup"])this.object.setup!==formData["coc-setup"]&&(this.object.setup=formData["coc-setup"],this.clearSetupPoints(),await this.setSkillLists());else if(void 0!==formData["coc-archetype"])this.object.archetype!==formData["coc-archetype"]&&(this.object.archetype=formData["coc-archetype"],this.object.coreCharacteristic="",this.clearSetupPoints(),await this.setSkillLists());else if(void 0!==formData["coc-occupation"])this.object.occupation!==formData["coc-occupation"]&&(this.object.occupation=formData["coc-occupation"],await this.setSkillLists());else{for(const key in this.object.setupPoints)void 0!==formData[key]&&this.object.setupPoints[key]!==formData[key]&&(this.object.setupPoints[key]=formData[key]);void 0!==formData["coc-core-characteristic"]&&this.object.coreCharacteristic!==formData["coc-core-characteristic"]&&(this.object.coreCharacteristic=formData["coc-core-characteristic"],this.clearSetupPoints(),this.object.placeable=foundry.utils.duplicate(this.object.quickFireValues))}const flatKeys=["name","age","residence","birthplace","language","avatar","token"];for(const key of flatKeys)void 0!==formData[key]&&this.object[key]!==formData[key]&&(this.object[key]=formData[key],"age"===key&&this.getAgeAdjustments());if("back"===event.submitter?.dataset.button){const pageNumber=this.getPageNumber(-1);if(void 0!==pageNumber){this.object.step=pageNumber;const obj=this.element.find(".scrollsection");obj.length&&obj[0].scrollTop&&(obj[0].scrollTop=0)}}else if("next"===event.submitter?.dataset.button){if(this.object.step===this.pageList.PAGE_CREATE||this.object.step===this.pageList.PAGE_BACKSTORY&&game.user.hasPermission("ACTOR_CREATE"))return void this.attemptToCreate();{const pageNumber=this.getPageNumber(1);if(void 0!==pageNumber){this.object.step=pageNumber;const obj=this.element.find(".scrollsection");obj.length&&obj[0].scrollTop&&(obj[0].scrollTop=0)}}}this.render(!0)}async attemptToCreate(){const actorData=await this.normalizeCharacterData(this.object);if(game.user.hasPermission("ACTOR_CREATE")){(await CoC7InvestigatorWizard.createCharacter(actorData)).sheet.render(!0),this.close()}else{const keepers=game.users.filter((u=>u.active&&u.isGM));if(keepers.length){actorData.ownership[game.user.id]=CONST.DOCUMENT_OWNERSHIP_LEVELS.OWNER;const data={type:"character-wizard",listener:keepers[0].id,payload:actorData};game.socket.emit("system.CoC7",data),ui.notifications.info(game.i18n.localize("CoC7.InvestigatorWizard.CreatingInvestigator")),this.close()}else ui.notifications.error(game.i18n.localize("CoC7.ErrorMissingKeeperUser"))}}async normalizeCharacterData(data){const weaponSkills={melee:{},rngd:{}},items=[];for(const key in data.skillItems){const skill=data.skillItems[key];for(let index=0,im=skill.rows.length;index<im;index++){const row=skill.rows[index];if(!skill.flags.isMultiple||!1!==row.selected){let item=foundry.utils.duplicate(skill.item);!1!==row.selected&&"string"!=typeof row.selected&&(item=foundry.utils.duplicate(row.selected),row.selected=!1),row.occupationToggle&&(item.system.flags.occupation=!0),row.archetypeToggle&&(item.system.flags.archetype=!0);let base=item.system.base;if(!Number.isNumeric(base))for(const key in data.setupPoints){const regEx=new RegExp("@"+key,"i");base=base.replace(regEx,parseInt(data.setupPoints[key],10)+parseInt(data.setupModifiers[key],10))}Number.isNumeric(base)||(base=Math.floor(new AverageRoll("("+base+")")[foundry.utils.isNewerVersion(game.version,"12")?"evaluateSync":"evaluate"]({minimize:!0,maximize:!0}).total)),item.system.base=base,item.system.adjustments=item.system.adjustments??{},Number(row.personalPoints)>0&&(item.system.adjustments.personal=parseInt(row.personalPoints,10)),Number(row.occupationPoints)>0&&(item.system.adjustments.occupation=parseInt(row.occupationPoints,10)),Number(row.archetypePoints)>0&&(item.system.adjustments.archetype=parseInt(row.archetypePoints,10)),Number(row.experiencePoints)>0&&(item.system.adjustments.experience=parseInt(row.experiencePoints,10)),key===this.cocidLanguageOwn?(item.system.skillName=data.language,item.name=item.system.specialization+" ("+item.system.skillName+")"):"string"==typeof row.selected&&(item.system.skillName=row.selected,item._id=foundry.utils.randomID(),item.name=item.system.specialization+" ("+item.system.skillName+")",void 0!==item.flags.CoC7?.cocidFlag?.id&&(item.flags.CoC7.cocidFlag.id=game.system.api.cocid.guessId(item))),item.system.properties?.fighting?(weaponSkills.melee[item.name]=item._id,weaponSkills.melee[item.system.skillName]=item._id):(item.system.properties?.firearm||item.system.properties?.ranged)&&(weaponSkills.rngd[item.name]=item._id,weaponSkills.rngd[item.system.skillName]=item._id),items.push(item)}}}for(const sourceItem of data.investigatorItems){const item=foundry.utils.duplicate(sourceItem);item.system.properties.melee?(void 0!==weaponSkills.melee[item.system.skill.main.name]&&(item.system.skill.main.id=weaponSkills.melee[item.system.skill.main.name]),void 0!==weaponSkills.melee[item.system.skill.alternativ.name]&&(item.system.skill.alternativ.id=weaponSkills.melee[item.system.skill.alternativ.name])):item.system.properties.rngd&&(void 0!==weaponSkills.rngd[item.system.skill.main.name]&&(item.system.skill.main.id=weaponSkills.rngd[item.system.skill.main.name]),void 0!==weaponSkills.rngd[item.system.skill.alternativ.name]&&(item.system.skill.alternativ.id=weaponSkills.rngd[item.system.skill.alternativ.name])),items.push(item)}let monetary={};const setup=await this.getCacheItemByCoCID(this.object.setup);setup&&(monetary=foundry.utils.duplicate(setup.system.monetary));const development={personal:2*(parseInt(data.setupPoints.int,10)+parseInt(data.setupModifiers.int,10)),occupation:0,archetype:0};if(""!==data.archetype){const archetype=await game.system.api.cocid.fromCoCID(data.archetype);1===archetype.length&&(items.push(archetype[0].toObject()),development.archetype=archetype[0].system.bonusPoints)}if(""!==data.occupation){const occupation=await game.system.api.cocid.fromCoCID(data.occupation);if(1===occupation.length){items.push(occupation[0].toObject());const options=[];for(const[key,carac]of Object.entries(occupation[0].system.occupationSkillPoints))carac.selected&&(carac.optional?options.push(carac.multiplier*(parseInt(data.setupPoints[key],10)+parseInt(data.setupModifiers[key],10))):development.occupation+=carac.multiplier*(parseInt(data.setupPoints[key],10)+parseInt(data.setupModifiers[key],10)));options.length>0&&(development.occupation+=Math.max(...options))}}const biography=[],backstory=[];if(game.settings.get("CoC7","oneBlockBackstory"))for(let index=0,im=data.bioSections.length;index<im;index++)backstory.push("<h3>"+game.i18n.localize(data.bioSections[index].name)+"</h3><p>"+data.bioSections[index].value.split(/[\r\n]+/).join("</p><p>")+"</p>");else for(let index=0,im=data.bioSections.length;index<im;index++)biography.push({title:game.i18n.localize(data.bioSections[index].name),value:data.bioSections[index].value});return{type:"character",name:data.name,img:data.avatar,system:{characteristics:{str:{value:parseInt(data.setupPoints.str,10)+parseInt(data.setupModifiers.str,10)},con:{value:parseInt(data.setupPoints.con,10)+parseInt(data.setupModifiers.con,10)},siz:{value:parseInt(data.setupPoints.siz,10)+parseInt(data.setupModifiers.siz,10)},dex:{value:parseInt(data.setupPoints.dex,10)+parseInt(data.setupModifiers.dex,10)},app:{value:parseInt(data.setupPoints.app,10)+parseInt(data.setupModifiers.app,10)},int:{value:parseInt(data.setupPoints.int,10)+parseInt(data.setupModifiers.int,10)},pow:{value:parseInt(data.setupPoints.pow,10)+parseInt(data.setupModifiers.pow,10)},edu:{value:parseInt(data.setupPoints.edu,10)+parseInt(data.setupModifiers.edu,10)}},attribs:{lck:{value:Math.max(parseInt(data.setupPoints.luck,10),parseInt(data.setupModifiers.luck,10))},san:{value:parseInt(data.setupPoints.pow,10)+parseInt(data.setupModifiers.pow,10)}},infos:{age:data.age,residence:data.residence,birthplace:data.birthplace},development,biography,backstory:backstory.join("<p></p>"),monetary},prototypeToken:{name:data.name,actorLink:!0,texture:{src:data.token},disposition:CONST.TOKEN_DISPOSITIONS.FRIENDLY,sight:{enabled:!0}},items,ownership:{default:parseInt(data.defaultOwnership,10)}}}static async createCharacterFromData(actorData){const actor=await CoC7InvestigatorWizard.createCharacter(actorData),functionId=Hooks.on("renderActorSheet",((app,html,data)=>{app.object.id===actor.id&&(game.socket.emit("system.CoC7",{type:"open-character",listener:Object.keys(actorData.ownership).find((k=>"default"!==k)),payload:actor.id}),Hooks.off("renderActorSheet",functionId))}));actor.sheet.render(!0)}static async createCharacter(actorData){const actor=await Actor.create(actorData);return await actor.update({"system.attribs.hp.value":actor.rawHpMax,"system.attribs.mp.value":actor.rawMpMax,"system.attribs.san.max":actor.rawMpMax}),await actor.resetDailySanity(),actor}static async create(options={}){!0!==game.settings.get("CoC7","InvestigatorWizardChooseValues")&&!1!==game.settings.get("CoC7","InvestigatorWizardChooseValues")&&await game.settings.set("CoC7","InvestigatorWizardChooseValues",game.settings.get("CoC7","InvestigatorWizardChooseValues")[0]??!1),options=foundry.utils.mergeObject({step:0,defaultSetup:game.settings.get("CoC7","InvestigatorWizardSetup"),defaultQuantity:game.settings.get("CoC7","InvestigatorWizardQuantity"),defaultOwnership:game.settings.get("CoC7","InvestigatorWizardOwnership"),defaultEra:game.settings.get("CoC7","worldEra"),rerollsEnabled:game.settings.get("CoC7","InvestigatorWizardRerolls"),enforcePointBuy:game.settings.get("CoC7","InvestigatorWizardPointBuy"),quickFireValues:game.settings.get("CoC7","InvestigatorWizardQuickFire"),chooseRolledValues:game.settings.get("CoC7","InvestigatorWizardChooseValues"),placeable:foundry.utils.duplicate(game.settings.get("CoC7","InvestigatorWizardQuickFire")),cacheCoCID:CoC7InvestigatorWizard.loadCacheItemByCoCID(),cacheBackstories:game.system.api.cocid.fromCoCIDRegexBest({cocidRegExp:/^rt\.\.backstory-/,type:"rt"}),cacheItems:{},setup:game.settings.get("CoC7","InvestigatorWizardSetup"),skillItems:{},occupationGroups:{},investigatorItems:[],setupPoints:{str:"",con:"",siz:"",dex:"",app:"",int:"",pow:"",edu:"",luck:""},setupModifiers:{str:0,con:0,siz:0,dex:0,app:0,int:0,pow:0,edu:0,luck:0},rolledValues:[],archetype:"",coreCharacteristic:"",occupation:"",bioSections:[],personal:0,personalText:"",creditRating:{min:0,max:0},name:"",age:"",requiresAgeAdjustments:!1,residence:"",birthplace:"",language:"",avatar:"icons/svg/mystery-man.svg",token:"icons/svg/mystery-man.svg"},options),new CoC7InvestigatorWizard(options).render(!0)}}class CoCIDActorUpdateItems extends FormApplication{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{id:"coc-id-actor-update-items",classes:["coc7","dialog","investigator-wizard"],title:game.i18n.localize("CoC7.ActorCoCIDItemsBest"),template:"systems/CoC7/templates/apps/coc-id-actor-update-items.hbs",width:520,height:410,closeOnSubmit:!1})}async getData(){const sheetData=await super.getData();sheetData.lang=CONFIG.supportedLanguages[game.i18n.lang]??"?";const defaultEra=game.settings.get("CoC7","worldEra");return sheetData.isEn="en"===game.i18n.lang,sheetData.era=game.i18n.format(COC7.eras[defaultEra]??"CoC7.CoCIDFlag.error.unknown-era",{era:defaultEra}),sheetData}getUpdateData(item){const output={flags:{CoC7:{cocidFlag:item.flags.CoC7.cocidFlag}},name:item.name,system:{}};for(const key of["chat","keeper","notes","opposingDifficulty","pushedFaillureConsequences","special","value"])"string"==typeof item.system.description?.[key]&&item.system.description[key].length&&(Object.prototype.hasOwnProperty.call(output.system,"description")||(output.system.description={}),output.system.description[key]=item.system.description[key]);switch(item.type){case"archetype":output.system.suggestedOccupations=item.system.suggestedOccupations,output.system.suggestedTraits=item.system.suggestedTraits;break;case"book":case"spell":case"status":case"weapon":break;case"occupation":output.system.suggestedContacts=item.system.suggestedContacts;break;case"skill":output.system.skillName=item.system.skillName,output.system.specialization=item.system.specialization}return output}async updateActors(actorList,parent,any){if(parent){const unlinkedActors=await actorList.filter((a=>!1===a.token?.actorLink)).map((a=>a.id)).filter(((a,o,v)=>v.indexOf(a)===o)).reduce((async(c,i)=>(c.push(await fromUuid("Actor."+i)),c)),[]);actorList=unlinkedActors.concat(actorList)}const ids={},anys={};for(const actor of actorList)for(const item of actor.items.contents)"string"==typeof item.flags?.CoC7?.cocidFlag?.id&&(!any&&item.flags.CoC7.cocidFlag.id.match(/-any$/)?(Object.prototype.hasOwnProperty.call(anys,item.flags.CoC7.cocidFlag.id)||(anys[item.flags.CoC7.cocidFlag.id]=[]),anys[item.flags.CoC7.cocidFlag.id].push(actor.name)):ids[item.flags.CoC7.cocidFlag.id]={});const found=await game.system.api.cocid.fromCoCIDRegexBest({cocidRegExp:game.system.api.cocid.makeGroupRegEx(Object.keys(ids)),type:"i",showLoading:!0});for(const item of found)ids[item.flags.CoC7.cocidFlag.id]=this.getUpdateData(item.toObject());Object.keys(anys).length&&console.log("Invalid any keys on Actors",anys);const actorUpdates=[],tokenUpdates=[];for(const actor of actorList){const updates=[];for(const item of actor.items.contents)Object.prototype.hasOwnProperty.call(ids,item.flags?.CoC7?.cocidFlag?.id)&&Object.keys(ids[item.flags.CoC7.cocidFlag.id]).length&&updates.push(foundry.utils.mergeObject({_id:item.id},ids[item.flags.CoC7.cocidFlag.id]));updates.length&&(actor.parent?tokenUpdates.push({updates:{_id:actor.id,items:updates},operation:{parent:actor.parent}}):actorUpdates.push({_id:actor.id,items:updates}))}actorUpdates.length&&await Actor.updateDocuments(actorUpdates);for(const tokenUpdate of tokenUpdates)await Actor.updateDocuments([tokenUpdate.updates],tokenUpdate.operation)}async _updateObject(event,formData){if("update"===event.submitter?.dataset.button){if(event.submitter.className.indexOf("currently-submitting")>-1)return;event.submitter.className=event.submitter.className+" currently-submitting";const parent="string"==typeof formData["coc-id-actor-update-items-parent"],any="string"==typeof formData["coc-id-actor-update-items-any"];switch((formData["coc-id-actor-update-items-which"]??"").toString()){case"1":await this.updateActors(canvas.scene.tokens.contents.map((d=>d.object.actor)),parent,any);break;case"2":await this.updateActors(Object.values(ui.windows).filter((s=>s instanceof ActorSheet)).map((s=>s.object)),parent,any);break;case"3":await this.updateActors(game.actors.contents,!1,any)}}this.close()}static async create(options={}){new CoCIDActorUpdateItems(options).render(!0)}}class CoCIDCompendiumPopulate extends FormApplication{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{id:"coc-id-actor-update-items",classes:["coc7","dialog","investigator-wizard"],title:game.i18n.localize("CoC7.ActorCoCIDItemsBest"),template:"systems/CoC7/templates/apps/coc-id-compendium-populate.hbs",width:520,height:250,closeOnSubmit:!1})}activateListeners(html){super.activateListeners(html),html.find("select[name=pack]").click(this._onSelectPack.bind(this)),html.find(".toggle-switch").click(this._onClickToggle.bind(this))}_onSelectPack(event){this.object.packList=event.target.value}_onClickToggle(event){const key=event.target.dataset.property;if(key){const type=this.object.types.findIndex((t=>t.id===key));this.object.types[type].toggle=!this.object.types[type].toggle,this.render(!0)}}async _updateObject(event,formData){if("update"===event.submitter?.dataset.button){if(event.submitter.className.indexOf("currently-submitting")>-1)return;event.submitter.classList.add("currently-submitting");const included=this.object.types.filter((t=>t.toggle)).map((t=>t.id)),destination=game.packs.get(this.object.packList);if(!included.length||!destination)return void event.submitter.classList.remove("currently-submitting");{const items=await game.system.api.cocid.fromCoCIDRegexBest({cocidRegExp:new RegExp("^i.("+included.join("|")+")"),type:"i",showLoading:!0}),folders=await[...new Set(items.map((d=>d.type)))].reduce((async(sc,t)=>{const name=game.i18n.localize("CoC7.Entities."+t.charAt(0).toUpperCase()+t.slice(1));let folder=destination.folders.find((d=>d.name===name));void 0===folder&&(folder=await Folder.create({name,type:"Item"},{pack:this.object.packList}));const c=await sc;return c[t]=folder.id,c}),{}),priority=1+items.map((d=>d.flags.CoC7.cocidFlag.priority??0)).reduce(((c,v)=>(v>c&&(c=v),c)),0),newDocs=items.map((d=>{const doc=d.toObject();return doc.flags.CoC7.cocidFlag.priority=priority,doc.flags.CoC7.cocidFlag.lang=game.i18n.lang,doc.folder=folders[doc.type],doc}));await Item.implementation.createDocuments(newDocs,{pack:this.object.packList}),destination.render(!0)}}this.close()}static async create(options={}){options.packLists=game.modules.contents.filter((m=>m.active&&"call-of-cthulhu-foundryvtt-investigator-wizard"!==m.id&&!m.id.match(/^cha-coc-fvtt-/))).reduce(((c,m)=>(m.packs.filter((p=>"Item"===p.type)).forEach((p=>{c.push({group:m.title,value:p.id,label:p.label+" ("+m.title+")"})})),c)),[]),options.packList=options.packLists[0].value,options.types=Object.keys(CONFIG.Item.sheetClasses).filter((t=>"base"!==t)).map((t=>({id:t,label:game.i18n.localize("CoC7.Entities."+t.charAt(0).toUpperCase()+t.slice(1)),toggle:"skill"===t}))).sort(((a,b)=>a.id.localeCompare(b.id))),new CoCIDCompendiumPopulate(options).render(!0)}}class CoC7MenuLayer extends(foundry.canvas?.layers?.PlaceablesLayer??PlaceablesLayer){constructor(){super(),this.objects={}}static get layerOptions(){return foundry.utils.mergeObject(super.layerOptions,{name:"coc7menu",zIndex:60})}static get documentName(){return"Token"}get placeables(){return[]}}class CoC7Menu{static getButtons(controls){canvas.coc7gmtools=new CoC7MenuLayer;const isKeeper=game.user.isGM,showHiddenDevMenu=game.settings.get("CoC7","hiddendevmenu"),menu={name:"coc7menu",title:"CoC7.GmTools",layer:"coc7gmtools",icon:"game-icon game-icon-tentacle-strike",activeTool:"coc7dummy",visible:isKeeper,onChange:(event,active)=>{},onToolChange:(event,tool)=>{},tools:{coc7dummy:{icon:"",name:"coc7dummy",active:!1,title:"",onChange:()=>{}},devphase:{toggle:!0,icon:"fas fa-angle-double-up",name:"devphase",active:game.settings.get("CoC7","developmentEnabled"),title:"CoC7.DevPhase",onClick:async toggle=>await CoC7Utilities.toggleDevPhase(toggle)},charcreate:{toggle:!0,icon:"fas fa-user-edit",name:"charcreate",active:game.settings.get("CoC7","charCreationEnabled"),title:"CoC7.CharCreationMode",onClick:async toggle=>await CoC7Utilities.toggleCharCreation(toggle)},"actor-coc-id-best":{button:!0,icon:"fas fa-fingerprint",name:"actor-coc-id-best",title:"CoC7.ActorCoCIDItemsBest",onClick:async()=>await CoCIDActorUpdateItems.create()},"cocid-compendium-import":{button:!0,icon:"fas fa-book-user",name:"cocid-compendium-import",title:"CoC7.CoCIDCompendiumPopulate",onClick:async()=>await CoCIDCompendiumPopulate.create()},"actor-import":{button:!0,icon:"fas fa-user-plus",name:"actor-import",title:"CoC7.ActorImporter",onClick:async()=>await CoC7ActorImporterDialog.create()},"investigator-wizard":{button:!0,icon:"fas fa-user-check",name:"investigator-wizard",title:"CoC7.InvestigatorWizard.Title",onClick:async()=>await CoC7InvestigatorWizard.create()},xptoggle:{toggle:!0,icon:"fas fa-certificate",class:"xp_toggle",name:"xptoggle",active:game.settings.get("CoC7","xpEnabled"),title:"CoC7.toggleXP",onClick:async toggle=>await CoC7Utilities.toggleXPGain(toggle)},fakeroll:{button:!0,icon:"game-icon game-icon-card-joker",name:"fakeroll",title:"CoC7.FakeRoll",onClick:CoC7Chat.fakeRollMessage},startrest:{button:!0,icon:"fas fa-moon",name:"startrest",title:"CoC7.startRest",onClick:async()=>await CoC7Utilities.getTarget()}}};if(Array.isArray(controls)?(menu.tools=Object.keys(menu.tools).reduce(((c,i)=>("coc7dummy"===i||c.push(menu.tools[i]),c)),[]),controls.push(menu)):controls.coc7menu=menu,showHiddenDevMenu){canvas.coc7DevTools=new CoC7MenuLayer;const menu={name:"coc7DevMenu",title:"Dev tools. If you don't know what it is, you don't need it and you shouldn't use it !!",layer:"coc7DevTools",icon:"game-icon game-icon-police-badge",activeTool:"alwaysCrit",visible:isKeeper,onChange:(event,active)=>{},onToolChange:()=>{},tools:[{toggle:!0,icon:"game-icon game-icon-dice-fire",name:"alwaysCrit",active:game.CoC7.dev.dice.alwaysCrit,title:"All rolls will crit",onClick:toggle=>{game.CoC7.dev.dice.alwaysFumble=!1,game.CoC7.dev.dice.alwaysCrit=toggle}},{toggle:!0,icon:"game-icon game-icon-fire-extinguisher",name:"alwaysFumble",active:game.CoC7.dev.dice.alwaysFumble,title:"All rolls will fumble",onClick:toggle=>{game.CoC7.dev.dice.alwaysFumble=toggle,game.CoC7.dev.dice.alwaysCrit=!1}}]};Array.isArray(controls)?controls.push(menu):controls.coc7DevTools=menu}}static renderControls(app,html,data){const isKeeper=game.user.isGM;if(foundry.utils.isNewerVersion(game.version,"13")){const keeperMenu=html.querySelector(".game-icon-tentacle-strike")?.parentNode;if(keeperMenu&&!keeperMenu.classList.contains("coc7-menu")){if(keeperMenu.classList.add("coc7-menu"),isKeeper){const menuLi=document.createElement("li"),menuButton=document.createElement("button");menuButton.classList.add("control","ui-control","tool","icon","coc7-menu","coc7-create-link","fas","fa-link"),menuButton.type="button",menuButton.dataset.tooltip="CoC7.CreateLink",menuLi.appendChild(menuButton),keeperMenu.insertAdjacentHTML("afterend",menuLi.outerHTML),html.querySelector("button.coc7-create-link").addEventListener("click",(event=>CoC7ContentLinkDialog.create(event)))}{const menuLi=document.createElement("li"),menuButton=document.createElement("button");menuButton.classList.add("control","ui-control","tool","icon","coc7-menu","coc7-dice-roll","game-icon","game-icon-d10"),menuButton.type="button",menuButton.dataset.tooltip="CoC7.RollDice",menuLi.appendChild(menuButton),keeperMenu.insertAdjacentHTML("afterend",menuLi.outerHTML),html.querySelector(".coc7-menu.coc7-dice-roll").addEventListener("click",(event=>CoC7Utilities.rollDice(event)))}}}else{const keeperMenu=html.find(".game-icon-tentacle-strike").parent();keeperMenu.addClass("coc7-menu"),isKeeper&&keeperMenu.after('<li class="scene-control coc7-menu coc7-create-link" title="'+game.i18n.localize("CoC7.CreateLink")+'"><i class="fas fa-link"></i></li>'),keeperMenu.after('<li class="scene-control coc7-menu coc7-dice-roll" title="'+game.i18n.localize("CoC7.RollDice")+'"><i class="game-icon game-icon-d10"></i></li>'),html.find(".coc7-menu.coc7-dice-roll").click((event=>CoC7Utilities.rollDice(event))),html.find(".coc7-menu.coc7-create-link").click((event=>CoC7ContentLinkDialog.create(event)))}}}class CoC7Spell extends CoC7Item{constructor(data,context){void 0===data.img&&(data.img="systems/CoC7/assets/icons/pentagram-rose.svg"),super(data,context),this.context=context}async cast(priv){if(!this.isOwned)return ui.notifications.error(game.i18n.localize("CoC7.NotOwned"));const costs=foundry.utils.duplicate(this.system.costs),losses=[];for(const[key,loss]of Object.entries(costs)){if(console.log("costs",key,loss),!loss||0===Number(loss))continue;let characteristicName=game.i18n.localize("CoC7.OtherCosts");switch(key){case"hitPoints":characteristicName=game.i18n.localize("CoC7.HitPoints");break;case"sanity":characteristicName=game.i18n.localize("CoC7.SanityPoints");break;case"magicPoints":characteristicName=game.i18n.localize("CoC7.MagicPoints");break;case"power":characteristicName=game.i18n.localize("CHARAC.Power")}losses.push({characteristicName,loss})}const description=this.system.description.value,html=await renderTemplate("systems/CoC7/templates/items/spell/chat.html",{description,losses});let chatData={user:game.user.id,speaker:ChatMessage.getSpeaker({actor:this.actor}),flavor:this.name,content:html};return priv&&(chatData=ChatMessage.applyRollMode(chatData,"gmroll")),await ChatMessage.create(chatData)}async grantSanityLoss(value,priv){const template=SanCheckCard.template;let html=await renderTemplate(template,{}),chatData={user:game.user.id,speaker:ChatMessage.getSpeaker({actor:this.actor}),flavor:game.i18n.format("CoC7.CastingSpell",{spell:this.name}),content:html};priv&&(chatData=ChatMessage.applyRollMode(chatData,"gmroll"));const message=await ChatMessage.create(chatData),card=await message.getHTML();if(void 0!==card.length&&1===card.length){const sanityLoss=value;html=card.find(".chat-card")[0],html.dataset.object=escape(JSON.stringify({actorKey:this.actor.id,fastForward:!1,sanData:{sanMin:sanityLoss,sanMax:sanityLoss}}));const sanityCheck=SanCheckCard.getFromCard(html);return await sanityCheck.bypassRollSan(),await sanityCheck.rollSanLoss(),await sanityCheck.updateChatCard(),sanityCheck.sanLoss}}async update(data,context){if(void 0!==this.context.parent&&void 0!==this.context.bookId){let item,book;null===this.context.parent?(item=game.items.get(this.context.bookId),book=item.toObject()):book=this.context.parent.items.get(this.context.bookId).toObject();for(let i=0,im=book.system.spells.length;i<im;i++)book.system.spells[i]._id===this.id&&(book.system.spells[i]=foundry.utils.mergeObject(book.system.spells[i],data));null===this.context.parent?(await item.update({"system.spells":book.system.spells}),this.sheet.object=new CoC7Spell(book.system.spells.find((spell=>spell._id===this.id)),this.context)):(await this.context.parent.updateEmbeddedDocuments("Item",[book]),this.sheet.object=new CoC7Spell(book.system.spells.find((spell=>spell._id===this.id)),this.context)),this.sheet.render(!0)}else await super.update(data,context)}}class CoC7Book extends CoC7Item{constructor(data,context){void 0===data.img&&(data.img="systems/CoC7/assets/icons/secret-book.svg"),super(data,context)}static convertDifficulty(difficulty){switch(difficulty){case"hard":return CoC7Check.difficultyLevel.hard;case"extreme":return CoC7Check.difficultyLevel.extreme;case"critical":return CoC7Check.difficultyLevel.critical;case"unreadable":return CoC7Check.difficultyLevel.impossible;default:return CoC7Check.difficultyLevel.regular}}async addSpells(spells){const collection=this.system.spells?foundry.utils.duplicate(this.system.spells):[];for(const spell of spells)collection.push(spell);return await this.update({"system.spells":collection})}async spellDetail(index){const isKeeper=game.user.isGM,data=this.system.spells[index],parent=this.actor?this.actor:null,spell=new CoC7Spell(data,{parent,bookId:this.id});if(isKeeper||spell.system.learned)return await spell.sheet.render(!0)}async attemptInitialReading(){const difficulty=CoC7Book.convertDifficulty(this.system.difficultyLevel),language=this.system.language,skill=this.actor?.getSkillsByName(language);if(skill){if(0===skill.length)return ui.notifications.error(game.i18n.format("CoC7.UnknownLanguage",{actor:this.actor.name}));{const check=new CoC7Check;return check.actor=this.actor,check.skill=skill[0].id,check.difficulty=difficulty,check.parent=this.uuid,check.context="INITIAL_READING",check.flavor=game.i18n.format("CoC7.ReadAttempt",{book:this.name,language,difficulty:this.system.difficultyLevel}),await check.roll(),await check.toMessage()}}return ui.notifications.error(game.i18n.localize("CoC7.NotOwned"))}async changeProgress(mode,value){if(!this.isOwned&&"reset"!==mode)return ui.notifications.error(game.i18n.localize("CoC7.NotOwned"));if(!this.system.initialReading&&"reset"!==mode)return ui.notifications.error(game.i18n.format("CoC7.InitialReadingNeeded",{actor:this.actor.name,book:this.name}));if(!this.system.type.mythos&&"reset"!==mode)return ui.notifications.error(game.i18n.localize("CoC7.NotMythosTome"));const necessary=this.system.study.necessary;let fullStudy=this.system.fullStudy,progress=this.system.study.progress;if(isNaN(progress))return await this.update({"system.study.progress":0});if(value&&progress>value)return await this.update({"system.fullStudy":++fullStudy,"system.study.progress":value}),await this.completeFullStudy();if("increase"===mode&&progress<necessary){if(!1!==await this.checkExhaustion())return;if(await this.update({"system.study.progress":++progress}),progress===necessary)return await this.update({"system.fullStudy":++fullStudy}),await this.grantFullStudy()}else if("decrease"===mode&&progress>0)return await this.update({"system.study.progress":--progress})}async checkExhaustion(){const actorMythosValue=this.actor?.cthulhuMythos,mythosRating=this.system.mythosRating;if(this.system.initialReading)return actorMythosValue>=mythosRating&&(await this.update({"system.study.progress":this.system.study.necessary}),ui.notifications.warn(game.i18n.format("CoC7.BookHasNothingMoreToTeach",{actor:this.actor.name,book:this.name})))}async grantFullStudy(){if(!this.system.type.mythos)return;if(!1!==await this.checkExhaustion())return;const actorMythosValue=this.actor.cthulhuMythos,developments=[],mythosRating=this.system.mythosRating;let mythosFinal=this.system.gains.cthulhuMythos.final;if(actorMythosValue+mythosFinal>mythosRating)for(let index=1;index<=mythosFinal;index++)actorMythosValue+mythosFinal-index<=mythosRating&&(mythosFinal-=index);return developments.push({name:game.i18n.localize("CoC7.CoCIDFlag.keys.i.skill.cthulhu-mythos"),gain:parseInt(mythosFinal)},{name:this.system.language,gain:"development"}),await this.grantSkillDevelopment(developments),await this.rollSanityLoss(),await this.update({"system.fullStudies":++this.system.fullStudies})}async grantInitialReading(){if(this.system.initialReading)return;const developments=[],mythos={gains:this.system.gains.cthulhuMythos.initial,type:this.system.type.mythos},occult={gains:this.system.gains.occult,type:this.system.type.occult},other_gains=this.system.gains.others,other_type=this.system.type.other;if(mythos.type&&mythos.gains&&developments.push({name:game.i18n.localize("CoC7.CoCIDFlag.keys.i.skill.cthulhu-mythos"),gain:parseInt(mythos.gains)}),occult.type&&occult.gains&&developments.push({name:game.i18n.localize("CoC7.Occult"),gain:parseInt(occult.gains)}),other_type)for(const skill of other_gains){const pattern=skill.name.match(/^(.+) \((.+)\)$/);pattern&&(skill.specialization=pattern[1],skill.name=pattern[2]),"development"!==skill.value&&(skill.value=(await new Roll(skill.value).roll({async:!0})).total),skill.value&&developments.push({name:skill.name,gain:skill.value,specialization:skill.specialization})}return await this.grantSkillDevelopment(developments),(mythos.type||occult.type)&&this.system.sanityLoss&&await this.rollSanityLoss(),await this.update({"system.initialReading":!0})}async grantSpellLearning(spelllearned){for(const spell of this.system.spells)if(spell._id===spelllearned._id){spell.system.learned=!0;await this.actor.items.find((item=>"spell"===item.type&&item.name===spelllearned.name))?ui.notifications.warn(game.i18n.format("CoC7.SpellAlreadyLearned",{spell:spelllearned.name,book:this.name})):spelllearned.system.learned=!0;break}await this.update({"system.spells":this.system.spells}),spelllearned.system.learned&&(ui.notifications.info(game.i18n.format("CoC7.SpellSuccessfullyLearned",{spell:spelllearned.name,book:this.name})),await this.actor.createEmbeddedDocuments("Item",[foundry.utils.duplicate(spelllearned)]))}async grantSkillDevelopment(developments){if(0!==developments.length){for(const development of developments){if(!development.gain)continue;let skill=await this.actor.getSkillsByName(development.name);if(0===skill.length){const existingSkill=await game.items.find((item=>"skill"===item.type&&item.name===development.name));existingSkill?skill=await this.actor.createEmbeddedDocuments("Item",[foundry.utils.duplicate(existingSkill)]):(skill=await this.actor.createSkill(development.name,0),development.specialization&&await skill[0].update({"system.properties.special":!0,"system.specialization":development.specialization}))}if(skill=skill[0],"development"===development.gain)await skill.flagForDevelopement();else{if(skill.value+development.gain>99)for(let index=1;index<=development.gain;index++)skill.value+development.gain-index<=99&&(development.gain-=index,await skill.increaseExperience(development.gain));await skill.increaseExperience(development.gain)}}return this.showDevelopmentsTable(developments)}}async redoFullStudy(){return await this.update({"system.study.progress":0}),await this.update({"system.study.necessary":2*this.system.study.necessary})}async rollSanityLoss(){const value=this.system.sanityLoss;if(!value||""===value)return;const template=SanCheckCard.template;let html=await renderTemplate(template,{});const message=await ChatMessage.create({user:game.user.id,speaker:ChatMessage.getSpeaker({actor:this.actor}),flavor:game.i18n.format("CoC7.ReadingMythosTome",{book:this.name}),content:html}),card=await message.getHTML();if(void 0!==card.length&&1===card.length){const sanityLoss=(await new Roll(value).roll({async:!0})).total;html=card.find(".chat-card")[0],html.dataset.object=escape(JSON.stringify({actorKey:this.actor.id,fastForward:!1,sanData:{sanMin:sanityLoss,sanMax:sanityLoss}}));const sanityCheck=SanCheckCard.getFromCard(html);await sanityCheck.bypassRollSan(),await sanityCheck.rollSanLoss(),sanityCheck.updateChatCard()}}async showDevelopmentsTable(developments){for(const development of developments)development.specialization&&(development.name=`${development.specialization} (${development.name})`),"development"===development.gain?development.gain=game.i18n.localize("CoC7.MarkedForDevelopment"):development.gain=`+${development.gain} ${game.i18n.localize("CoC7.Points")}`;const html=await renderTemplate("systems/CoC7/templates/items/book/development.html",{developments});return await ChatMessage.create({user:game.user.id,speaker:ChatMessage.getSpeaker({actor:this.actor}),flavor:game.i18n.format("CoC7.GainsForReading",{book:this.name}),content:html})}async attemptSpellLearning(id){if(!this.isOwned)return ui.notifications.error(game.i18n.localize("CoC7.NotOwned"));if(!this.system.initialReading)return ui.notifications.error(game.i18n.format("CoC7.InitialReadingNeeded",{actor:this.actor.name,book:this.name}));const spell=this.system.spells.find((spell=>spell._id===id));if(spell){const check=new CoC7Check;check.actor=this.actor,check.difficulty=CoC7Check.difficultyLevel.hard,check.parent=this.uuid,check.flavor=game.i18n.format("CoC7.LearnSpellAttempt",{book:this.name,spell:spell.name}),check.context="SPELL_LEARNING",check.spell=spell,await check.rollCharacteristic("int"),await check.toMessage()}}async updateRoll(roll){const check=CoC7Check.fromRollString(roll);if(check.passed){if("INITIAL_READING"===check.context)return await this.grantInitialReading();if("SPELL_LEARNING"===check.context)return await this.grantSpellLearning(check.spell)}}}class CoC7Chase extends CoC7Item{constructor(data,context){void 0===data.img&&(data.img="systems/CoC7/assets/icons/running-solid.svg"),super(data,context),this.context=context}get participants(){const pList=[],preys=this.system.participants.filter((p=>!p.chaser)).map((p=>new _participant(p))),chasers=this.system.participants.filter((p=>p.chaser)).map((p=>new _participant(p)));return this.system.participants.forEach((p=>{p.assist=[],p.chaser?p.assist=chasers.filter((c=>c.uuid!==p.uuid&&!c.hasMaxBonusDice)).map((c=>({uuid:c.uuid,name:c.name}))):p.assist=preys.filter((c=>c.uuid!==p.uuid&&!c.hasMaxBonusDice)).map((c=>({uuid:c.uuid,name:c.name})));const particpant=new _participant(p);pList.push(particpant)})),pList}get participantsObject(){const participants=this.participants;return participants.forEach((p=>{p.location=this.getParticipantLocation(p.uuid)})),participants}get activeParticipantData(){return this.system.participants.find((p=>p.active))}get activeActor(){const p=this.activeParticipantData;if(p)return p.docUuid?CoC7Utilities.getActorFromKey(p.docUuid):void 0}get participantsByAdjustedMov(){const pList=this.actualParticipants.sort(((a,b)=>a.adjustedMov-b.adjustedMov));return pList.forEach((p=>{p.location=this.getParticipantLocation(p.uuid)})),pList}get participantsByInitiative(){const pList=this.actualParticipants.sort(((a,b)=>b.initiative-a.initiative));return pList.forEach((p=>{p.location=this.getParticipantLocation(p.uuid)})),pList}get preys(){return this.participants.filter((p=>!p.isChaser&&p.isValid))||[]}get chasers(){return this.participants.filter((p=>p.isChaser&&p.isValid))||[]}get allHaveValidMov(){return this.participants.every((e=>e.hasValidMov))}get allHaveSpeedRoll(){return this.participants.every((p=>p.speedCheck?.rolled))}getParticipantLocation(participantUuid){if(!this.system.locations?.list?.length)return;if(!this.started)return;const location=this.locations.find((l=>{const lp=l.participants?.find((p=>participantUuid===p.uuid));return!!lp}));return location||void 0}getParticipantData(participantUuid){const participant=this.system.participants.find((p=>participantUuid===p.uuid));if(participant)return foundry.utils.duplicate(participant)}getParticipant(participantUuid){const participantData=this.getParticipantData(participantUuid);if(participantData)return new _participant(participantData)}get nextActiveParticipant(){if(this.started)return this.participantsByInitiative.find((p=>p.data.currentMovementActions>0))}get slowestPrey(){const preys=this.participants.sort(((a,b)=>a.adjustedMov-b.adjustedMov))?.filter((p=>p.isPrey));if(preys.length>0)return preys[0]}get fastestChaser(){const chasers=this.participants.sort(((a,b)=>a.adjustedMov-b.adjustedMov))?.filter((p=>p.isChaser));if(chasers.length>0)return chasers.slice(-1).pop()}get actualParticipants(){const slowestPrey=this.slowestPrey,fastestChaser=this.fastestChaser;let pList=this.participants;return!this.system.includeLatecomers&&slowestPrey&&(pList=pList.filter((p=>p.isPrey||p.isChaser&&p.adjustedMov>=slowestPrey.adjustedMov))),!this.system.includeEscaped&&fastestChaser&&(pList=pList.filter((p=>p.isChaser||p.isPrey&&p.adjustedMov<=fastestChaser.adjustedMov))),pList}get slowestParticipant(){const pList=this.participantsByAdjustedMov;if(pList.length>0)return pList[0]}async updateParticipants(list,{render=!0}={}){const participantsData=this.cleanParticipantList(list);return await this.update({"system.participants":participantsData},{render})}async updateParticipant(particiantUuid,updateData,{render=!0}={}){const participants=foundry.utils.duplicate(this.system.participants),update=foundry.utils.duplicate(updateData),participantIndex=participants.findIndex((p=>particiantUuid===p.uuid));-1!==participantIndex&&(update.uuid&&delete update.uuid,foundry.utils.mergeObject(participants[participantIndex],update,{overwrite:!0}),await this.updateParticipants(participants,{render}))}cleanParticipantList(list){const participantsData=list||foundry.utils.duplicate(this.system.participants);return list.forEach((p=>{let data;data="_participant"===p.constructor.name?p.data:p;const index=this.findIndex(participantsData,data.uuid);-1===index?(participantsData.push(data),ui.notifications.warn(game.i18n.localize("CoC7.ParticipantDataMissing"))):participantsData[index]=data})),participantsData}async assistParticipant(assistantUuid,beneficiaryUuid,{useMovementActions=!0,render=!0}={}){const assistant=this.getParticipant(assistantUuid),beneficiary=this.getParticipant(beneficiaryUuid),participantsData=foundry.utils.duplicate(this.system.participants),assistantIndex=participantsData.findIndex((p=>assistantUuid===p.uuid)),beneficiaryIndex=participantsData.findIndex((p=>beneficiaryUuid===p.uuid));if(assistant&&beneficiary)if(beneficiary.hasMaxBonusDice)ui.notifications.error(game.i18n.format("CoC7.ErrorBeneficiaryAtMaxBonus",{name:beneficiary.name}));else{if(useMovementActions){if(assistant.currentMovementActions<1)return void ui.notifications.error(game.i18n.format("CoC7.ParticipantNotEnoughMovement",{assistantUuid,actions:assistant.currentMovementActions}));assistant.alterMovementActions(-1),participantsData[assistantIndex]=foundry.utils.duplicate(assistant.data)}beneficiary.addBonusDice(),participantsData[beneficiaryIndex]=foundry.utils.duplicate(beneficiary.data),await this.update({"system.participants":participantsData},{render})}else ui.notifications.error(game.i18n.localize("CoC7.ParticipantNotFound"))}async toggleBonusDice(participantUuid,diceNumber,{render=!0}={}){const participant=this.getParticipant(participantUuid);if(!participant)return void ui.notifications.error(game.i18n.format("CoC7.ParticipantUuidNotFound",{participantUuid}));const participantsData=foundry.utils.duplicate(this.system.participants),participantIndex=participantsData.findIndex((p=>participantUuid===p.uuid));participant.bonusDice>=diceNumber?participant.removeBonusDice():participant.addBonusDice(),participantsData[participantIndex]=foundry.utils.duplicate(participant.data),await this.update({"system.participants":participantsData},{render})}async cautiousApproach(participantUuid,{useMovementActions=!0,render=!0}={}){const participant=this.getParticipant(participantUuid);if(!participant)return void ui.notifications.error(game.i18n.format("CoC7.ParticipantUuidNotFound",{participantUuid}));const participantsData=foundry.utils.duplicate(this.system.participants),participantIndex=participantsData.findIndex((p=>participantUuid===p.uuid));if(participant.hasMaxBonusDice)ui.notifications.error(game.i18n.format("CoC7.ErrorParticipantAtMaxBonus",{participantUuid}));else{if(useMovementActions){if(participant.currentMovementActions<1)return void ui.notifications.error(game.i18n.format("CoC7.ParticipantNotEnoughMovement",{assistantUuid:participantUuid,actions:participant.currentMovementActions}));participant.alterMovementActions(-1)}participant.addBonusDice(),participantsData[participantIndex]=foundry.utils.duplicate(participant.data),await this.update({"system.participants":participantsData},{render})}}async alterParticipantMovementAction(participantUuid,count,{render=!0}={}){const participant=this.getParticipant(participantUuid);if(!participant)return void ui.notifications.error(game.i18n.format("CoC7.ParticipantUuidNotFound",{participantUuid}));const participantsData=foundry.utils.duplicate(this.system.participants),participantIndex=participantsData.findIndex((p=>participantUuid===p.uuid));participant.alterMovementActions(count),participantsData[participantIndex]=foundry.utils.duplicate(participant.data),await this.update({"system.participants":participantsData},{render})}async activateNextParticipantTurn({scrollToLocation=!0,activateLocation=!0,render=!0,html=null}={}){const activeParticipant=this.nextActiveParticipant,options={scrollToLocation,activateLocation,render,html};return activeParticipant?this.activateParticipant(activeParticipant.uuid,options):this.activateParticipant(void 0,options)}async activateParticipant(participantUuid,{scrollToLocation=!0,activateLocation=!0,render=!0,html=null}={}){const dataUpdate=this.getActivateParticipantUpdateData(participantUuid,{scrollToLocation,activeLocation:activateLocation,html});await this.update(dataUpdate,{render})}getActivateParticipantUpdateData(participantUuid,{scrollToLocation=!0,activateLocation=!0,html=null}={}){const pUuid=participantUuid,participantsDataUpdate={},participants=this.system.participants?foundry.utils.duplicate(this.system.participants):[];participants.forEach((p=>{delete p.active,pUuid&&pUuid===p.uuid&&(p.active=!0)})),participantsDataUpdate["system.participants"]=participants;const participantLocation=this.getParticipantLocation(pUuid);let locationsDataUpdate=null;return participantLocation?activateLocation?locationsDataUpdate=this.getActivateLocationUpdateData(participantLocation.uuid,{scrollToLocation,html}):scrollToLocation&&(locationsDataUpdate={},locationsDataUpdate["system.scroll.chaseTrack.from"]=this.chaseTrackCurrentScrollPosition,locationsDataUpdate["system.scroll.chaseTrack.to"]=this.getChaseTrackLocationScrollPosition(participantLocation.uuid,{html})):locationsDataUpdate=this.getActivateLocationUpdateData(void 0,{scrollToLocation}),locationsDataUpdate?foundry.utils.mergeObject(participantsDataUpdate,locationsDataUpdate):participantsDataUpdate}activeParticipantObstacleCheck(locationUuid,{moveParticipant=!0}={}){new ChaseObstacleCard({chaseUuid:this.uuid,locationUuid,moveParticipant,forward:locationUuid!==this.activeLocation.uuid}).toMessage()}async progressToNextRound({render=!0}={}){const participants=this.system.participants?foundry.utils.duplicate(this.system.participants):[];participants.forEach((p=>{p.currentMovementActions<p.movementAction&&(p.currentMovementActions+=p.movementAction,p.currentMovementActions>p.movementAction&&(p.currentMovementActions=p.movementAction))})),await this.updateParticipants(participants,{render:!1}),this.activateNextParticipantTurn({render})}async updateRoll(rollString){if(game.user.isGM){const roll=CoC7Check.fromRollString(rollString),participants=this.system.participants?foundry.utils.duplicate(this.system.participants):[],index=participants.findIndex((p=>p.rollUuid===roll.uuid));index>=0&&(participants[index].speedCheck.rollDataString=roll.JSONRollString,await this.update({"system.participants":participants}))}else{const data={data:rollString,type:"invoke",method:"updateRoll",item:this.uuid};game.socket.emit("system.CoC7",data)}}get locations(){const locations=this.started?this.system.locations.list?foundry.utils.duplicate(this.system.locations.list):[]:this.initTrack;return this.processLocations(locations),locations}getLocationData(locationUuid,{duplicateData=!0}={}){return(duplicateData?foundry.utils.duplicate(this.locations):this.locations).find((l=>locationUuid===l.uuid))}processLocations(locations){if(locations?.length){locations[0].first=!0;for(let index=0;index<locations.length;index++){const classes=[],location=locations[index];location.name||classes.push("empty"),location.active&&classes.push("active"),location.init&&!this.started&&classes.push("init"),location.cssClasses=classes.join(" ")}locations.length>1&&(locations[locations.length-1].last=!0),locations.forEach((l=>{if(l.participants&&l.participants.length){l.participants=l.participants.filter((p=>!(null===p)));for(let i=0;i<l.participants.length;i++){const elem=l.participants[i];let p;"string"==typeof elem||elem instanceof String?p=this.system.participants.find((p=>elem===p.uuid)):"_participant"===elem?.constructor?.name?(p=void 0,ui.notifications.warn(game.i18n.localize("CoC7.ParticipantAlreadyProcessed"))):p=void 0,void 0!==p?l.participants[i]=new _participant(p):console.error("Undefined paticipant while processing participants array")}l.participants.sort(sortByRoleAndDex)}}))}}get initTrack(){if(!this.system.locations.list||0===this.system.locations.list.length)return;const locations=[],init=this.startingLine;let locationsIndexStart,initIndexStart,locationsLength;if(locationsIndexStart=init.length<=0||this.system.startingIndex>=init.length?0:init.length-this.system.startingIndex,initIndexStart=this.system.startingIndex<=0||this.system.startingIndex<=init.length?0:this.system.startingIndex-init.length,locationsLength=0===locationsIndexStart?this.system.locations.list.length:this.system.locations.list.length+locationsIndexStart,0!==init.length&&this.system.startingIndex<0)for(let index=0;index<Math.abs(this.system.startingIndex);index++)init.push({uuid:this.generateNewUuid(),init:!0,participants:[]});const chaseLocations=foundry.utils.duplicate(this.system.locations);for(let index=0;index<locationsLength;index++){let location={};const participants=[];index>=locationsIndexStart&&index-locationsIndexStart<chaseLocations.list.length&&(location=foundry.utils.duplicate(chaseLocations.list[index-locationsIndexStart]),location.init=!1,location.participants?.forEach((p=>{null!=p&&participants.push(p)}))),index>=initIndexStart&&index-initIndexStart<init.length&&(foundry.utils.mergeObject(location,init[index-initIndexStart],{overwrite:!1}),init[index-initIndexStart].participants?.forEach((p=>{null!=p&&participants.push(p)})),location.participants=participants),location.first=!1,location.end=!1,locations.push(location)}return locations}get startingLine(){const preys=this.system.includeEscaped?this.preys:this.preys?.filter((p=>!p.data.escaped)),chasers=this.system.includeLatecomers?this.chasers:this.chasers?.filter((c=>!c.data.excluded)),chaseTrack=[],chasersMinMov=this.findMinMov(chasers),chasersMaxMov=this.findMaxMov(chasers),preysMinMov=this.findMinMov(preys),preysMaxMov=this.findMaxMov(preys);if(-1!==chasersMinMov&&-1!==chasersMaxMov){for(let mov=chasersMinMov;mov<=chasersMaxMov;mov++){const location={uuid:this.generateNewUuid(),init:!0,participants:[]};chasers.filter((p=>mov===p.adjustedMov)).sort(((a,b)=>a.dex-b.dex)).forEach((p=>location.participants.push(p.uuid))),chaseTrack.push(location)}for(let index=0;index<this.system.startingRange;index++)chaseTrack.push({uuid:this.generateNewUuid(),init:!0,participants:[]})}if(-1!==preysMinMov&&-1!==preysMaxMov)for(let mov=preysMinMov;mov<=preysMaxMov;mov++){const location={uuid:this.generateNewUuid(),init:!0,participants:[]};preys.filter((p=>mov===p.adjustedMov)).sort(((a,b)=>a.dex-b.dex)).forEach((p=>location.participants.push(p.uuid))),chaseTrack.push(location)}return chaseTrack}async updateLocationsList(list,{render=!0}={}){const updatedList=this.cleanLocationsList(list);await this.update({"system.locations.list":updatedList},{render})}async updateLocation(locationUuid,updateData,{render=!0}={}){const locations=foundry.utils.duplicate(this.system.locations.list),update=foundry.utils.duplicate(updateData),locationIndex=locations.findIndex((l=>locationUuid===l.uuid));-1!==locationIndex&&(update.uuid&&delete update.uuid,foundry.utils.mergeObject(locations[locationIndex],update,{overwrite:!0}),await this.updateLocationsList(locations,{render}))}cleanLocationsList(list){const updatedList=foundry.utils.duplicate(list),partipantsUuidArray=this.system.participants.map((p=>p.uuid));return updatedList.forEach((l=>{if(delete l.cssClasses,delete l.first,delete l.last,delete l.end,l.participants&&l.participants.length){for(let i=0;i<l.participants.length;i++)l.participants=l.participants.filter((p=>!(null===p))),l.participants[i].data?.uuid&&(l.participants[i]=l.participants[i].data.uuid);l.participants=l.participants.filter((uuid=>partipantsUuidArray.includes(uuid)))}})),updatedList}async insertLocation(insertAtUuid,{shift=0,locData={},render=!0}={}){const locations=foundry.utils.duplicate(this.system.locations.list);locations.forEach((l=>{delete l.active}));const locationIndex=locations.findIndex((l=>insertAtUuid===l.uuid));if(-1===locationIndex)return!1;const newLocationIndex=locationIndex+shift;if(newLocationIndex>locations.length)return!1;const newLocation=foundry.utils.duplicate(locData);return newLocation.uuid=this.generateNewUuid(),newLocation.init=locations[locationIndex].init,newLocation.active=!0,locations.splice(newLocationIndex,0,newLocation),await this.updateLocationsList(locations,{render})}async removeLocation(uuid,{render=!0}={}){const locations=foundry.utils.duplicate(this.system.locations.list),locationIndex=locations.findIndex((l=>uuid===l.uuid));if(locations.splice(locationIndex,1),locations.forEach((l=>{delete l.active})),locations.length>0){let index=locationIndex-1;index<0&&(index=0),locations[index].active=!0}return await this.updateLocationsList(locations,{render})}async activateLocation(locationUuid,{scrollToLocation=!0,render=!0}={}){const updateData=this.getActivateLocationUpdateData(locationUuid,{scrollToLocation});await this.update(updateData,{render})}getClearActiveLocationUpdateData({scrollToLocation=!0,html=null}={}){const updateData={},locations=this.system.locations.list?foundry.utils.duplicate(this.system.locations.list):[];return locations.forEach((l=>{delete l.active})),updateData["system.locations.list"]=this.cleanLocationsList(locations),scrollToLocation&&(updateData["system.scroll.chaseTrack.from"]=0,updateData["system.scroll.chaseTrack.to"]=-1),updateData}getActivateLocationUpdateData(locationUuid,{scrollToLocation=!0,html=null}={}){if(!locationUuid)return this.getClearActiveLocationUpdateData({scrollToLocation});const updateData={},locations=this.system.locations.list?foundry.utils.duplicate(this.system.locations.list):[];return locations.forEach((l=>{delete l.active,locationUuid===l.uuid&&(l.active=!0)})),updateData["system.locations.list"]=this.cleanLocationsList(locations),scrollToLocation&&(updateData["system.scroll.chaseTrack.from"]=this.chaseTrackCurrentScrollPosition,updateData["system.scroll.chaseTrack.to"]=this.getChaseTrackLocationScrollPosition(locationUuid,{html})),updateData}get activeLocation(){if(!this.locations)return;const location=this.locations.find((l=>l.active));if(!location)return;location.participants?.length&&(location.hasParticipant=!0);const actor=this.activeActor;if(actor){const test=actor.find(location.obstacleDetails?.checkName);test&&(location.activeActorHasSkill=!0,location.activeActorTest=test)}return location}get previousLocation(){if(!this.locations)return;const activeIndex=this.locations.findIndex((l=>l.active));if(-1===activeIndex)return;if(0===activeIndex)return;const location=this.locations[activeIndex-1],actor=this.activeActor;if(actor){const test=actor.find(location.obstacleDetails?.checkName);test&&(location.activeActorHasSkill=!0,location.activeActorTest=test)}return location}get nextLocation(){if(!this.locations)return;const activeIndex=this.locations.findIndex((l=>l.active));if(-1===activeIndex)return;if(activeIndex===this.locations.length-1)return;const location=this.locations[activeIndex+1],actor=this.activeActor;if(actor){const test=actor.find(location.obstacleDetails?.checkName);test&&(location.activeActorHasSkill=!0,location.activeActorTest=test)}return location}async locatorDropped(data){await this.setLocationCoordinates(data.locationUuid,data.x,data.y,data.scene)}async setLocationCoordinates(locationUuid,x,y,sceneId,{render=!0}={}){const locations=foundry.utils.duplicate(this.system.locations.list),locationIndex=locations.findIndex((l=>locationUuid===l.uuid));return locations[locationIndex].coordinates={x,y,scene:sceneId},await this.updateLocationsList(locations,{render})}async clearActiveLocationCoordinates({render=!0}={}){if(this.activeLocation)return await this.clearLocationCoordinates(this.activeLocation.uuid,{render})}async clearLocationCoordinates(locationUuid,{render=!0}={}){const locations=foundry.utils.duplicate(this.system.locations.list),locationIndex=locations.findIndex((l=>locationUuid===l.uuid));return delete locations[locationIndex].coordinates,await this.updateLocationsList(locations,{render})}async cutToTheChase(){if(this.allHaveSpeedRoll){if(this.actualParticipants?.length<2)ui.notifications.warn(game.i18n.localize("CoC7.NeedMin2Participants"));else if(this.allHaveValidMov){const participants=this.participants,minMov=this.findMinMov(this.actualParticipants);participants.forEach((p=>{p.calculateMovementActions(minMov),p.currentMovementActions=p.movementAction,p.bonusDice=0})),await this.updateParticipants(participants,{render:!1}),await this.updateLocationsList(this.locations,{render:!1}),await this.start()}}else ui.notifications.warn(game.i18n.localize("CoC7.NotAllHaveSpeedRoll"))}async restart(){const locations=this.locations.filter((l=>!l.init));for(let i=0;i<locations.length;i++)locations[i].participants&&(locations[i].participants=[]),locations[i].active&&delete locations[i].active;const participantsData=this.system.participants?foundry.utils.duplicate(this.system.participants):[];for(let i=0;i<participantsData.length;i++)participantsData[i].active&&delete participantsData[i].active;await this.setchaseTrackScroll(0,0,{render:!1}),await this.updateLocationsList(locations,{render:!1}),await this.updateParticipants(participantsData,{render:!1}),await this.stop()}getLocationShift(locationUuid,{skip=1}={}){const locations=foundry.utils.duplicate(this.system.locations.list),destinationIndex=locations.findIndex((l=>locationUuid===l.uuid))+skip;return 0===locations.length?null:destinationIndex>=locations.length?locations[locations.length-1]:destinationIndex<0?locations[0]:locations[destinationIndex]}async removeParticipant(participantUuid,{render=!0}={}){const p=this.getParticipant(participantUuid);await Dialog.confirm({title:game.i18n.localize("CoC7.RemoveParticipant"),content:`<p>${game.i18n.format("CoC7.RemoveParticipantHint",{name:p.name})}</p>`,yes:async()=>{const newParticipantsData=foundry.utils.duplicate(this.system.participants).filter((p=>participantUuid!==p.uuid)),locationsData=foundry.utils.duplicate(this.system.locations.list);locationsData.forEach((l=>{l.participants&&l.participants.length&&(l.participants=l.participants.filter((uuid=>participantUuid!==uuid)))})),await this.updateParticipants(newParticipantsData,{render:!1}),await this.updateLocationsList(locationsData,{render})}})}async addParticipant(participant,{render=!0,locationUuid=null,recalculateMovementActions=!0,update=!1}={}){const participantsData=this.system.participants?foundry.utils.duplicate(this.system.participants):[];if(participant.data.chaseUuid&&delete participant.data.chaseUuid,participant.data.locationUuid&&delete participant.data.locationUuid,participant.data.update&&delete participant.data.update,!participant.uuid){let unique=!1;for(;!unique;)participant.data.uuid=foundry.utils.randomID(16),unique=0===participantsData.filter((p=>p.uuid===participant.uuid)).length}if(update){participant.currentMovementActions>participant.movementAction&&(participant.currentMovementActions=participant.movementAction);const index=participantsData.findIndex((p=>p.uuid===participant.uuid));participantsData[index]=participant.data}else participantsData.push(participant.data);if(await this.updateParticipants(participantsData,{render:render&&!this.started&&!this.recalculateMovementActions}),recalculateMovementActions){const slowest=this.slowestParticipant?.adjustedMov,participants=this.participants;participants.forEach((p=>p.calculateMovementActions(slowest))),await this.updateParticipants(participants,{render:render&&!this.started})}if(this.started&&!participant.data.escaped&&!participant.data.excluded){const locationsData=this.system.locations.list?foundry.utils.duplicate(this.system.locations.list):[];0===locationsData.length&&ui.notifications.error(game.i18n.localize("CoC7.ErrorEmptyLocationsList"));let locationIndex=locationsData.findIndex((l=>locationUuid===l.uuid));-1===locationIndex&&(locationIndex=0),locationsData[locationIndex].participants||(locationsData[locationIndex].participants=[]),-1===locationsData[locationIndex].participants.findIndex((p=>p===participant.uuid))&&locationsData[locationIndex].participants.push(participant.uuid),await this.updateLocationsList(locationsData,{render})}}async editParticipant(participantUuid,{useMovementActions=!0,scrollToLocation=!0,activateLocation=!0,activateParticipant=!0,render=!0}={}){}async moveParticipant(participantUuid,locationMoved,{useMovementActions=!0,scrollToLocation=!0,activateLocation=!0,activateParticipant=!0,render=!0}={}){let modified=!1;const locations=foundry.utils.duplicate(this.system.locations.list),originIndex=locations.findIndex((l=>l.participants?.includes(participantUuid)));let destinationIndex=originIndex+locationMoved;destinationIndex>locations.length-1&&(destinationIndex=locations.length-1),destinationIndex<0&&(destinationIndex=0);const totalMove=destinationIndex-originIndex,participant=this.getParticipant(participantUuid),participantsData=foundry.utils.duplicate(this.system.participants),participantIndex=participantsData.findIndex((p=>participantUuid===p.uuid));if(useMovementActions){if(!participant)return void ui.notifications.error(game.i18n.format("CoC7.ParticipantUuidNotFound",{participantUuid:this.participantUuid}));if(participant.currentMovementActions<Math.abs(totalMove))return void ui.notifications.error(game.i18n.format("CoC7.ParticipantNotEnoughMovement",{assistantUuid:participantUuid,actions:participant.currentMovementActions}));participant.alterMovementActions(0-Math.abs(totalMove)),participantsData[participantIndex]=foundry.utils.duplicate(participant.data),await this.update({"system.participants":participantsData},{render:!1}),modified=!0}return 0!==totalMove&&(await this.moveParticipantToLocation(participantUuid,locations[destinationIndex].uuid,{render:!1}),modified=!0),activateParticipant&&(await this.activateParticipant(participantUuid,{scrollToLocation,activateLocation,render:!1}),modified=!0),activateLocation&&!activateParticipant&&(await this.activateLocation(locations[destinationIndex].uuid,{scrollToLocation,render:!1}),modified=!0),modified&&render&&await this.sheet.render(!0),totalMove}async moveParticipantToLocation(participantUuid,locationUuid,{scrollToLocation=!0,activateLocation=!0,animate=null,moveToken=!0,render=!0}={}){const locations=foundry.utils.duplicate(this.system.locations.list),destination=locations.find((l=>locationUuid===l.uuid));if(!destination)return void console.error(`Failed to move ${participantUuid}. Location ${locationUuid} unknown`);const origin=locations.find((l=>l.participants?.includes(participantUuid)));if(!origin)return void console.error(`Failed to find ${participantUuid} in locations`);if(destination.participants||(destination.participants=[]),destination.participants.includes(participantUuid))return;destination.participants.push(participantUuid);const oldParticipantsList=origin.participants.filter((p=>participantUuid!==p));if(origin.participants=oldParticipantsList,moveToken&&destination.coordinates){const participant=this.getParticipant(participantUuid);let particpantDocument=CoC7Utilities.getDocumentFromKey(participant?.data?.docUuid);if(particpantDocument&&!(particpantDocument instanceof TokenDocument||particpantDocument?.object instanceof Token)){const foundTokens=canvas.scene.tokens.filter((d=>d.actorLink&&d.actor?.id===particpantDocument.id));1===foundTokens.length&&(particpantDocument=foundTokens[0])}if(particpantDocument&&!(particpantDocument instanceof TokenDocument||particpantDocument?.object instanceof Token))console.warn("No token associated with this actor");else if(destination.coordinates.scene!==game.scenes.viewed.uuid&&console.warn("Caution the scene is not the active scene"),particpantDocument.parent?.uuid!==destination.coordinates.scene)ui.notifications.error(game.i18n.localize("CoC7.ErrorTokenNotOnScene"));else{const scene=CoC7Utilities.getDocumentFromKey(destination.coordinates.scene);let x=destination.coordinates.x;const y=destination.coordinates.y;let targetRect=new PIXI.Rectangle(x,y,particpantDocument.object.width,particpantDocument.object.height).normalize();const update=[];let foundFreeSpace=!1;for(;!foundFreeSpace;){const overlapingToken=scene.tokens.find((t=>t.id!==particpantDocument.id&&t.object.bounds.intersects(targetRect)));overlapingToken?(x=overlapingToken.object.bounds.right+1,targetRect=new PIXI.Rectangle(x,y,particpantDocument.object.width,particpantDocument.object.height).normalize()):foundFreeSpace=!0}update.push({_id:particpantDocument.id,x,y});const showTokenMovement="boolean"==typeof animate?animate:this.system.showTokenMovement;await particpantDocument.parent.updateEmbeddedDocuments("Token",update,{animate:showTokenMovement})}}await this.updateLocationsList(locations,{render})}async setchaseTrackScroll({from,to=-1,render=!0}={}){await this.update({"system.scroll.chaseTrack.from":void 0===from?this.chaseTrackCurrentScrollPosition:from,"system.scroll.chaseTrack.to":void 0===to?this.chaseTrackCurrentScrollPosition:to},{render})}get chaseTrackCurrentScrollPosition(){const html=this.sheet?._element;if(!html)return-1;const chaseTrack=html[0].querySelector(".chase-track");return chaseTrack?chaseTrack.scrollLeft:-1}get chaseTrackActiveLocationScrollPosition(){return this.activeLocation?this.getChaseTrackLocationScrollPosition(this.activeLocation.uuid):-1}getChaseTrackLocationScrollPosition(locationUuid,{html=null}){const htmlElement=html||this.sheet?._element;if(!htmlElement||!htmlElement[0])return-1;const chaseTrack=htmlElement[0].querySelector(".chase-track");if(!chaseTrack)return-1;const activeLocationElement=chaseTrack.querySelector(`.chase-location[data-uuid="${locationUuid}"]`);if(!activeLocationElement)return-1;const leftScroll=activeLocationElement.offsetLeft+activeLocationElement.clientWidth/2-chaseTrack.clientWidth/2;return leftScroll<0?0:Math.floor(leftScroll)}findMinMov(list){return list?.length?list.reduce(((prev,current)=>prev.adjustedMov<current.adjustedMov?prev:current)).adjustedMov:-1}findMaxMov(list){return list?.length?list.reduce(((prev,current)=>prev.adjustedMov>current.adjustedMov?prev:current)).adjustedMov:-1}findIndex(list,uuid){return list.findIndex((p=>p.uuid===uuid))}get started(){return this.getFlag("CoC7","started")}async start(){const remString=$(":root").css("font-size"),remSize=Number(remString.replace("px","")),pCount=this.actualParticipants.length,width=Math.max((11.2*pCount+3)*remSize,40*remSize);this.sheet._tabs[0].active="setup",this.sheet.position.width=width,await this.setFlag("CoC7","started",!0),await this.activateNextParticipantTurn()}async stop(){return this.unsetFlag("CoC7","started")}generateNewUuid(){return foundry.utils.randomID(16)}getActorSkillsAndCharacteristics(participantUuid){const participant=this.getParticipant(participantUuid);if(!participant.actor)return;const list=[];return CoCActor.getCharacteristicDefinition().forEach((c=>list.push(`${game.i18n.localize("CoC7.Characteristics")} (${c.shortName})`))),list.push(`${game.i18n.localize("CoC7.Attribute")} (${game.i18n.localize("CoC7.Luck")})`),list.push(`${game.i18n.localize("CoC7.Attribute")} (${game.i18n.localize("CoC7.SAN")})`),participant.actor.skills.forEach((s=>list.push(s.name))),list}get activeActorSkillsAndCharacteristics(){const particicpantData=this.activeParticipantData;if(particicpantData)return this.getActorSkillsAndCharacteristics(particicpantData.uuid)}get allSkillsAndCharacteristics(){const list=[];return CoCActor.getCharacteristicDefinition().forEach((c=>list.push(`${game.i18n.localize("CoC7.Characteristics")} (${c.shortName})`))),list.push(`${game.i18n.localize("CoC7.Attribute")} (${game.i18n.localize("CoC7.Luck")})`),list.push(`${game.i18n.localize("CoC7.Attribute")} (${game.i18n.localize("CoC7.SAN")})`),game.CoC7.skillList?.forEach((s=>{list.includes(s.name)||s.name.toLowerCase().includes(`(${game.i18n.localize("CoC7.AnySpecName")})`.toLowerCase())||list.push(s.name)})),this.participants.forEach((p=>{p.actor&&p.actor.skills.forEach((s=>{list.includes(s.name)||list.push(s.name)}))})),list.sort(Intl.Collator().compare)}get allSkillsAndCharacteristicsShort(){const list=[];return CoCActor.getCharacteristicDefinition().forEach((c=>list.push(`${c.label}`))),list.push(`${game.i18n.localize("CoC7.Luck")}`),list.push(`${game.i18n.localize("CoC7.SAN")}`),game.CoC7.skillList?.forEach((s=>{list.includes(s.name)||s.name.toLowerCase().includes(`(${game.i18n.localize("CoC7.AnySpecName")})`.toLowerCase())||list.push(s.name)})),this.participants.forEach((p=>{p.actor&&p.actor.skills.forEach((s=>{list.includes(s.name)||list.push(s.name)}))})),list.sort(Intl.Collator().compare)}}class CoC7Skill extends CoC7Item{constructor(data,context){if(void 0===data.system?.skillName){const skill=CoC7Skill.guessNameParts(data.name),{name,skillName,specialization,...newProperties}=skill;data.name=name,data.system||={};const properties={...data.system.properties,...newProperties};data.system={...data.system,skillName,specialization,properties}}super(data,context)}static guessNameParts(skillName){const output={combat:!1,fighting:!1,firearm:!1,name:skillName,skillName,special:!1,specialization:""},match=skillName.match(/^(.+)\s*\(([^)]+)\)$/);if(match){output.skillName=match[2].trim(),output.special=!0;const specialization=match[1].trim();output.specialization=specialization,output.name=specialization+" ("+output.skillName+")",output.fighting=specialization===game.i18n.localize("CoC7.FightingSpecializationName"),output.firearm=specialization===game.i18n.localize("CoC7.FirearmSpecializationName"),output.ranged=specialization===game.i18n.localize("CoC7.RangedSpecializationName"),output.combat=output.fighting||output.firearm||output.ranged}return output}get hasActiveEffects(){return this.activeEffects.length>0}get activeEffects(){if(this.parent&&this.parent.effects){const effectKeyFull=`skill.${this.name}`.toLowerCase(),effectKeyShort=`skill.${this.system.skillName}`.toLowerCase();let changes=this.parent.effects.reduce(((changes,e)=>e.disabled||e.isSuppressed?changes:changes.concat(e.data.changes.map((c=>((c=foundry.utils.duplicate(c)).effect=e,c.priority=c.priority??10*c.mode,c))))),[]);return changes.sort(((a,b)=>a.priority-b.priority)),changes=changes.filter((e=>e.key.toLowerCase()===effectKeyShort||e.key.toLowerCase()===effectKeyFull)),changes}return[]}get itemIdentifier(){return this.name}get rawValue(){let value=0;return"character"===this.actor.type?(value=this.base,value+=this.system.adjustments?.personal?parseInt(this.system.adjustments?.personal):0,value+=this.system.adjustments?.occupation?parseInt(this.system.adjustments?.occupation):0,value+=this.system.adjustments?.experience?parseInt(this.system.adjustments?.experience):0,game.settings.get("CoC7","pulpRuleArchetype")&&this.system.adjustments?.archetype?value+=parseInt(this.system.adjustments?.archetype):value+=parseInt(this.system.adjustments?.experiencePackage??0,10)):value=parseInt(this.system.value),isNaN(value)?null:value}get value(){const value=this.parent?.system.skills?.[`${this.itemIdentifier}`]?.value;return value||this.rawValue}async updateValue(value){if("character"===this.actor.type){const delta=parseInt(value)-this.rawValue,exp=(this.system.adjustments?.experience?parseInt(this.system.adjustments.experience):0)+delta;await this.update({"system.adjustments.experience":exp>0?exp:0})}else await this.update({"system.value":value})}async increaseExperience(x){if("skill"!==this.type)return null;if("character"===this.actor.type){const exp=(this.system.adjustments?.experience?parseInt(this.system.adjustments.experience):0)+parseInt(x);await this.update({"system.adjustments.experience":exp>0?exp:0})}}}class CoC7Vehicle extends CoCActor{constructor(data,context){void 0===data.img&&(data.img="systems/CoC7/assets/icons/jeep.svg"),super(data,context)}get rawBuild(){return this.build}get build(){const build=parseInt(this.system.attribs.build.value);return isNaN(build)?null:build}get hp(){if(null===this.system.attribs.build.current||void 0===this.system.attribs.build.current||""===this.system.attribs.build.current)return this.build;if(this.system.attribs.build.current>this.system.attribs.build.value)return this.build;const hp=parseInt(this.system.attribs.build.current);return isNaN(hp)?null:hp}get hpMax(){return this.build}get rawHpMax(){return this.build}async setHp(value){return value>this.build&&(value=this.build),await this.update({"system.attribs.build.current":value})}get rawDb(){return this.db}get db(){const db=parseInt(this.system.attribs.db?.value);return isNaN(db)?null:db}get rawMov(){return this.mov}get mov(){const mov=parseInt(this.system.attribs.mov?.value);return isNaN(mov)?null:mov}get mpMax(){return parseInt(this.system.attribs?.mp?.max)||0}get rawMpMax(){return this.mpMax}get sanMax(){return null}get rawSanMax(){return null}}class CoC7DecaderDie extends foundry.dice.terms.Die{constructor(termData){termData.faces=10,super(termData)}get total(){const total=super.total;return 10===total?0:10*total}static get DENOMINATION(){return"t"}}class CoC7DecaderDieOther extends CoC7DecaderDie{static get DENOMINATION(){return"o"}}const SETTINGS={pulpRules:{name:"",hint:"",scope:"world",config:!1,default:!1,type:Boolean},initiativeRule:{name:"SETTINGS.InitiativeRule",hint:"SETTINGS.InitiativeRuleHint",scope:"world",config:!1,default:"basic",type:String,choices:{basic:"SETTINGS.InitiativeRuleBasic",optional:"SETTINGS.InitiativeRuleOptional"},onChange:rule=>_setInitiativeOptions(rule)},developmentRollForLuck:{name:"SETTINGS.developmentRollForLuck",hint:"SETTINGS.developmentRollForLuckHint",scope:"world",config:!1,default:!1,type:Boolean},allowMythosHardened:{name:"SETTINGS.allowMythosHardenedTitle",hint:"SETTINGS.allowMythosHardenedHint",scope:"world",config:!1,default:!1,type:Boolean},pulpRuleDoubleMaxHealth:{name:"CoC7.Settings.PulpRules.DoubleMaxHealth.Name",hint:"CoC7.Settings.PulpRules.DoubleMaxHealth.Hint",scope:"world",config:!1,default:!1,type:Boolean},pulpRuleDevelopmentRollLuck:{name:"CoC7.Settings.PulpRules.DevelopmentRollLuck.Name",hint:"CoC7.Settings.PulpRules.DevelopmentRollLuck.Hint",scope:"world",config:!1,default:!1,type:Boolean},pulpRuleArchetype:{name:"CoC7.Settings.PulpRules.Archetype.Name",hint:"CoC7.Settings.PulpRules.Archetype.Hint",scope:"world",config:!1,default:!1,type:Boolean},pulpRuleOrganization:{name:"CoC7.Settings.PulpRules.Organization.Name",hint:"CoC7.Settings.PulpRules.Organization.Hint",scope:"world",config:!1,default:!1,type:Boolean},pulpRuleTalents:{name:"CoC7.Settings.PulpRules.Talents.Name",hint:"CoC7.Settings.PulpRules.Talents.Hint",scope:"world",config:!1,default:!1,type:Boolean},pulpRuleFasterRecovery:{name:"CoC7.Settings.PulpRules.FasterRecovery.Name",hint:"CoC7.Settings.PulpRules.FasterRecovery.Hint",scope:"world",config:!1,default:!1,type:Boolean},pulpRuleIgnoreMajorWounds:{name:"CoC7.Settings.PulpRules.IgnoreMajorWounds.Name",hint:"CoC7.Settings.PulpRules.IgnoreMajorWounds.Hint",scope:"world",config:!1,default:!1,type:Boolean},pulpRuleIgnoreAgePenalties:{name:"CoC7.Settings.PulpRules.IgnoreAgePenalties.Name",hint:"CoC7.Settings.PulpRules.IgnoreAgePenalties.Hint",scope:"world",config:!1,default:!1,type:Boolean},opposedRollTieBreaker:{name:"SETTINGS.OpposedRollTieBreaker",hint:"SETTINGS.OpposedRollTieBreakerHint",scope:"world",config:!1,default:!1,type:Boolean}};function _setInitiativeOptions(rule){let decimals=0;switch(rule){case"optional":decimals=2;break;case"basic":decimals=0}CONFIG.Combat.initiative={formula:null,decimals}}class CoC7GameRuleSettings extends FormApplication{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{title:"SETTINGS.TitleRules",id:"rules-settings",template:"systems/CoC7/templates/system/rule-settings.html",width:550,height:"auto",closeOnSubmit:!0})}getData(){const options={},pulpRules={true:!1,false:!1};for(const[k,v]of Object.entries(SETTINGS))options[k]={value:game.settings.get("CoC7",k),setting:v},k.match(/^pulpRule.{2,}$/)&&(pulpRules[options[k].value]=!0);return options.pulpSelection=pulpRules.true?pulpRules.false?"some":"all":"none",options.initiativeRuleOptions=[{key:"basic",label:"SETTINGS.InitiativeRuleBasic"},{key:"optional",label:"SETTINGS.InitiativeRuleOptional"}],options.pulpSelectionOptions=[{key:"none",label:"None"},{key:"some",label:"Partial"},{key:"all",label:"All"}],options}static registerSettings(){for(const[k,v]of Object.entries(SETTINGS))game.settings.register("CoC7",k,v);_setInitiativeOptions(game.settings.get("CoC7","initiativeRule"))}activateListeners(html){super.activateListeners(html),html.find("#pulpRulesSelect").on("change",(event=>this.onChangePulpSelect(event))),html.find("input.pulpRulesSelect[type=checkbox]").on("click",(event=>this.onClickPulp(event))),html.find("button[name=reset]").on("click",(event=>this.onResetDefaults(event)))}onChangePulpSelect(event){const val=$(event.currentTarget).val();"none"!==val&&"all"!==val||$("#rules-settings").find("input.pulpRulesSelect[type=checkbox]").each((function(){const checkbox=$(this);"none"===val?checkbox.prop("checked",!1):checkbox.prop("checked",!0)}))}onClickPulp(event){const pulpRules={true:!1,false:!1};$("#rules-settings").find("input.pulpRulesSelect[type=checkbox]").each((function(){$(this).prop("checked")?pulpRules.true=!0:pulpRules.false=!0})),$("#pulpRulesSelect").val(pulpRules.true?pulpRules.false?"some":"all":"none")}async onResetDefaults(event){event.preventDefault();for await(const[k,v]of Object.entries(SETTINGS))await game.settings.set("CoC7",k,v?.default);return this.render()}async _updateObject(event,data){const pulpRules={true:!1,false:!1};for await(const key of Object.keys(SETTINGS))game.settings.set("CoC7",key,data[key]),key.match(/^pulpRule.{2,}$/)&&(pulpRules[data[key]]=!0);game.settings.set("CoC7","pulpRules",pulpRules.true&&!pulpRules.false)}}class CoC7ArchetypeSheet extends foundry.appv1.sheets.ItemSheet{activateListeners(html){super.activateListeners(html),this.options.editable&&(html.find(".item .item-name h4").click((event=>this._onItemSummary(event,"skills"))),html.find(".item-delete").click((event=>this._onItemDelete(event,"skills"))))}async _onDrop(event,type="skill",collectionName="skills"){event.preventDefault(),event.stopPropagation();const dataList=await CoC7Utilities.getDataFromDropEvent(event,"Item");let useCoCID=0;const collection=this.item.system[collectionName]?foundry.utils.duplicate(this.item.system[collectionName]):[];for(const item of dataList)item&&item.system&&[type].includes(item.type)&&(!CoC7Item.isAnySpec(item)&&collection.find((el=>el.name===item.name))||(0===useCoCID&&(useCoCID=await DropCoCID.create()),collection.push(DropCoCID.processItem(useCoCID,item))));await this.item.update({[`system.${collectionName}`]:collection})}async _onItemSummary(event,collectionName="items"){event.preventDefault();const li=$(event.currentTarget).parents(".item"),item=this.item.system[collectionName].find((s=>s._id===li.data("item-id")));if(!item)return;const chatData=await TextEditor.enrichHTML(item.system.description.value,{async:!0,secrets:this.item.editable});if(li.hasClass("expanded")){const summary=li.children(".item-summary");summary.slideUp(200,(()=>summary.remove()))}else{const div=$(`<div class="item-summary">${chatData}</div>`),props=$('<div class="item-properties"></div>');div.append(props),li.append(div.hide()),div.slideDown(200)}li.toggleClass("expanded")}async _onItemDelete(event,collectionName="items"){const item=$(event.currentTarget).closest(".item"),itemId=item.data("item-id"),CoCId=item.data("cocid"),itemIndex=this.item.system[collectionName].findIndex((i=>itemId&&i._id===itemId||CoCId&&i===CoCId));if(itemIndex>-1){const collection=this.item.system[collectionName]?foundry.utils.duplicate(this.item.system[collectionName]):[];collection.splice(itemIndex,1),await this.item.update({[`system.${collectionName}`]:collection})}}static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{classes:["coc7","sheet","occupation"],template:"systems/CoC7/templates/items/archetype.html",width:520,height:480,dragDrop:[{dragSelector:".item"}],scrollY:[".tab.description"],tabs:[{navSelector:".sheet-navigation",contentSelector:".sheet-body",initial:"description"}]})}_getHeaderButtons(){const headerButtons=super._getHeaderButtons();return addCoCIDSheetHeaderButton(headerButtons,this),headerButtons}async getData(){const sheetData=super.getData();sheetData.hasOwner=!0===this.item.isEmbedded;const coreCharacteristics=[];for(const[key,selected]of Object.entries(sheetData.data.system.coreCharacteristics))if(selected){const characName=game.i18n.localize(`CHARAC.${key.toUpperCase()}`);coreCharacteristics.push(characName)}sheetData.enrichedDescriptionValue=await TextEditor.enrichHTML(sheetData.data.system.description.value,{async:!0,secrets:sheetData.editable}),sheetData.enrichedDescriptionKeeper=await TextEditor.enrichHTML(sheetData.data.system.description.keeper,{async:!0,secrets:sheetData.editable}),sheetData.enrichedSuggestedOccupations=await TextEditor.enrichHTML(sheetData.data.system.suggestedOccupations,{async:!0,secrets:sheetData.editable}),sheetData.enrichedSuggestedTraits=await TextEditor.enrichHTML(sheetData.data.system.suggestedTraits,{async:!0,secrets:sheetData.editable}),sheetData.data.system.skills=await game.system.api.cocid.expandItemArray({itemList:sheetData.data.system.skills}),sheetData.skillListEmpty=0===sheetData.data.system.skills.length,sheetData.data.system.skills.sort(CoC7Utilities.sortByNameKey),sheetData.coreCharacteristicsString="";const orString=` ${game.i18n.localize("CoC7.Or")} `;return coreCharacteristics.length&&(sheetData.coreCharacteristicsString+=coreCharacteristics.join(orString)),sheetData.itemProperties=[],sheetData.itemProperties.push(`${game.i18n.localize("CoC7.PulpTalents")}: ${sheetData.data.system.talents}`),sheetData.itemProperties.push(`${game.i18n.localize("CoC7.BonusPoints")}: ${sheetData.data.system.bonusPoints}`),sheetData.isKeeper=game.user.isGM,sheetData}}class CoC7ArmorSheet extends foundry.appv1.sheets.ItemSheet{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{classes:["coc7","sheet","armor"],template:"systems/CoC7/templates/items/armor.hbs",width:520,height:480,dragDrop:[{dragSelector:".item"}],scrollY:[".tab.description"],tabs:[{navSelector:".sheet-navigation",contentSelector:".sheet-body",initial:"description"}]})}_getHeaderButtons(){const headerButtons=super._getHeaderButtons();return addCoCIDSheetHeaderButton(headerButtons,this),headerButtons}async getData(){const sheetData=super.getData();return sheetData.enrichedDescriptionValue=await TextEditor.enrichHTML(sheetData.data.system.description.value,{async:!0,secrets:sheetData.editable}),sheetData.enrichedDescriptionKeeper=await TextEditor.enrichHTML(sheetData.data.system.description.keeper,{async:!0,secrets:sheetData.editable}),sheetData.effects=CoC7ActiveEffect.prepareActiveEffectCategories(this.item.effects),sheetData.isKeeper=game.user.isGM,sheetData}activateListeners(html){super.activateListeners(html),html.find(".effect-control").click((ev=>CoC7ActiveEffect.onManageActiveEffect(ev,this.item)))}}class CoC7BookSheet extends foundry.appv1.sheets.ItemSheet{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{template:"systems/CoC7/templates/items/book/main.html",classes:["coc7","item","book"],width:500,height:"auto",resizable:!1,dragDrop:[{dragSelector:".spells",dropSelector:null}],scrollY:[".body"],tabs:[{navSelector:".navigation",contentSelector:".body",initial:"description"}]})}_getHeaderButtons(){const headerButtons=super._getHeaderButtons();return addCoCIDSheetHeaderButton(headerButtons,this),headerButtons}async getData(){const sheetData=super.getData();return sheetData.initialReading=this.item.system.initialReading,sheetData.isKeeper=game.user.isGM,sheetData.isOwner=this.item.isOwner,sheetData.spellsLearned=this.spellsLearned,sheetData.exhausted=!1!==await this.item.checkExhaustion(),sheetData.studyCompleted=this.item.system.study.progress===this.item.system.study.necessary,sheetData.hasOwner=!0===this.item.isEmbedded,sheetData.spellListEmpty=0===this.item.system.spells.length,sheetData.enrichedDescriptionValue=await TextEditor.enrichHTML(sheetData.data.system.description.value,{async:!0,secrets:sheetData.editable}),sheetData.enrichedDescriptionKeeper=await TextEditor.enrichHTML(sheetData.data.system.description.keeper,{async:!0,secrets:sheetData.editable}),sheetData.enrichedContent=await TextEditor.enrichHTML(sheetData.data.system.content,{async:!0,secrets:sheetData.editable}),sheetData.difficultyLevels=[{key:"regular",label:"CoC7.RollDifficultyRegular"},{key:"hard",label:"CoC7.RollDifficultyHard"},{key:"extreme",label:"CoC7.RollDifficultyExtreme"},{key:"critical",label:"CoC7.RollDifficultyCritical"},{key:"unreadable",label:"CoC7.Unreadable"}],sheetData.studyUnits=[{key:"CoC7.months",label:"CoC7.months"},{key:"CoC7.weeks",label:"CoC7.weeks"},{key:"CoC7.days",label:"CoC7.days"},{key:"CoC7.hours",label:"CoC7.hours"}],sheetData.otherGains=[{key:"development",label:"CoC7.Development"},{key:"1d6",label:"+1D6"},{key:"1d10",label:"+1D10"}],sheetData}get spellsLearned(){let amount=0;const spells=this.item.system.spells;for(const spell of spells)spell.system.learned&&amount++;return`${amount} / ${spells.length}`}activateListeners(html){super.activateListeners(html),html.find("#attempt-initial-reading").click((event=>{event.preventDefault(),this.item.attemptInitialReading()})),html.find(".delete-spell").click((event=>this._onDelete(event))),html.find(".edit-spell").click((event=>this._onSpellDetail(event))),html.find(".spell-name").click((event=>this._onSpellDetail(event))),html.find(".teach-spell").click((event=>{const id=$(event.currentTarget).parents("li").data("id");this.item.attemptSpellLearning(id)})),html.find('[name="system.study.necessary"]').change((event=>{const value=parseInt(event.currentTarget.value);this.item.changeProgress("reset",value)})),html.find("#increase-progress").click((()=>{this.item.changeProgress("increase")})),html.find("#decrease-progress").click((()=>{this.item.changeProgress("decrease")})),html.find(".add-other-gains").click((event=>{this.modifyOthersGains(event,"add")})),html.find(".change-other-gains").change((event=>{this.modifyOthersGains(event,"change")})),html.find("#redo-full-study").click((()=>{this.item.redoFullStudy()})),html.find(".remove-other-gains").click((event=>{this.modifyOthersGains(event,"remove")})),html.find(".option").click((event=>this.modifyType(event)))}async _onSpellDetail(event){event.preventDefault();const index=$(event.currentTarget).parents("li").data("index");return await this.item.spellDetail(index)}async _onDelete(event){if(!game.user.isGM)return;event.preventDefault();const index=$(event.currentTarget).parents("li").data("index"),spells=this.item.system.spells?foundry.utils.duplicate(this.item.system.spells):[];return index>=0&&spells.splice(index,1),await this.item.update({"system.spells":spells})}async _onDrop(event,type="spell"){event.preventDefault(),event.stopPropagation();const dataList=await CoC7Utilities.getDataFromDropEvent(event,"Item"),spells=[];for(const item of dataList)item&&["skill","spell"].includes(item.type)&&("spell"===item.type?spells.push(item):"skill"===item.type&&this.item.system.type.other&&this.modifyOthersGains(null,"add",{name:item.name}));await this.item.addSpells(spells)}modifyType(event){event.preventDefault(),event.stopPropagation();return $(event.currentTarget).prev().trigger("click")}async modifyOthersGains(event,mode,options={}){let index=null,element=null;event&&(event.preventDefault(),element=$(event.currentTarget),index=element.parents("tr").data("index"));const skills=this.item.system.gains.others?foundry.utils.duplicate(this.item.system.gains.others):[];switch(mode){case"add":skills.push({name:options.name||game.i18n.localize("CoC7.NewSkillName"),value:"development"});break;case"change":skills[index]={name:element.is("input")?element.val():skills[index].name,value:element.is("select")?element.val():skills[index].value};break;case"remove":index>=0&&skills.splice(index,1)}return await this.item.update({"system.gains.others":skills})}}class CoC7ContextMenu{bind(menu,html,callback){this._callback=callback,this._html=html,this._menu=menu;try{const menuTrigger=html.find(`[data-context-menu=${menu.id}]`);if(0===menuTrigger.length)return;menuTrigger.contextmenu(this._onContextMenu.bind(this));const menuElement=CoC7ContextMenu.CreateMenu(menu);menuElement.on("click",".menu-action",this._onMenuAction.bind(this)),0!==this.menu.length?this.menu.replaceWith(menuElement):this.menuContainer.append(menuElement)}catch(error){console.error(error)}}get menuContainer(){let menuContainer=this._html.find(".menu-container");return 0===menuContainer.length&&(this._html.append('<div class="menu-container"></div>'),menuContainer=this._html.find(".menu-container")),menuContainer}get menu(){return this.menuContainer.find(`.context-menu-wrapper.${this._menu.id}`)}_onMenuAction(event){return this._callback(event,this.target)}static closeAll(){$("body").find(".menu-container").find(".context-menu-wrapper").each((function(i,m){m.style.visibility="hidden"}))}_onContextMenu(event){event.preventDefault(!0),CoC7ContextMenu.closeAll();const target=event?.currentTarget;if(this.target=target,!target)return;const menuName=target.dataset?.contextMenu;if(menuName===this._menu.id){const wrapper=this.menu;if(wrapper.length>0){const subMenu=wrapper.find(".sub-menu");let left=event.clientX,top=event.clientY;const menuHeight=wrapper.outerHeight(),menuWidth=wrapper.outerWidth();window.innerHeight<menuHeight+top&&(top-=menuHeight),window.innerWidth<menuWidth+left&&(left=window.innerWidth-menuWidth),subMenu.length>0&&(window.innerWidth<menuWidth+left+subMenu.outerWidth()?subMenu.css({right:menuWidth-5+"px",left:""}):subMenu.css({left:menuWidth-5+"px",right:""})),wrapper.css({left:`${left}px`,top:`${top}px`,visibility:"visible"})}}}static canSee(visibility){switch(visibility.toLowerCase()){case"gm":return game.user.isGM;case"trusted":return game.user.isTrusted;default:return!0}}static CreateMenu(menu){const classes="string"==typeof menu.classes?[menu.classes]:menu.classes;classes.push("context-menu-wrapper");const wrapper=$("<div></div>");if(wrapper.addClass(menu.id),classes.forEach((c=>wrapper.addClass(c))),menu.section)menu.section.forEach((s=>{const section=CoC7ContextMenu.CreateSection(s,{multi:!0});section&&wrapper.append(section)}));else{const section=CoC7ContextMenu.CreateSection(menu);section&&wrapper.append(section)}return wrapper}static CreateSection(s,{multi=!1,subMenu=!1}={}){if(!s.items)return null;if(s.visibility&&!CoC7ContextMenu.canSee(s.visibility))return null;const classes=s.classes?"string"==typeof s.classes?[s.classes]:s.classes:[];multi&&classes.push("menu-section"),subMenu&&classes.push("sub-menu");const section=$("<ul></ul>");return classes.forEach((c=>section.addClass(c))),s.items.forEach((i=>{const li=$("<li></li>");if(li.addClass("menu-item"),i.action&&(li.addClass("menu-action"),li.attr("data-action",i.action)),"string"==typeof i.label?li.append(`<span>${i.label}</span>`):(i.label.icon&&li.append(`<i class="${i.label.icon}"></i>`),i.label.text&&li.append(`<span>${i.label.text}</span>`)),i.subMenu){li.addClass("sub-menu-button"),li.append('<i class="fas fa-caret-right"></i>');const sub=CoC7ContextMenu.CreateSection(i.subMenu,{subMenu:!0});sub&&li.append(sub)}section.append(li)})),section}}class CoC7ActorSheet extends foundry.appv1.sheets.ActorSheet{_getHeaderButtons(){const headerButtons=super._getHeaderButtons();return addCoCIDSheetHeaderButton(headerButtons,this),headerButtons}async getData(){const sheetData=await super.getData();if(sheetData.showHiddenDevMenu=game.settings.get("CoC7","hiddendevmenu"),sheetData.canDragToken=!!this.token&&game.user.isGM,sheetData.linkedActor=!0===this.actor.prototypeToken?.actorLink,sheetData.isToken=this.actor.isToken,sheetData.itemsByType={},sheetData.skills={},sheetData.combatSkills={},sheetData.weapons={},sheetData.rangeWpn=[],sheetData.meleeWpn=[],sheetData.actorFlags={},sheetData.effects="character"===this.actor.type?CoC7ActiveEffect.prepareActiveEffectCategories(this.actor.effects):CoC7ActiveEffect.prepareNPCActiveEffectCategories(this.actor.effects),sheetData.permissionLimited=!game.user.isGM&&(this.actor.ownership[game.user.id]??this.actor.ownership.default)===CONST.DOCUMENT_OWNERSHIP_LEVELS.LIMITED,sheetData.isKeeper=game.user.isGM,sheetData.allowUnlock="always"===game.settings.get("CoC7","playerUnlockSheetMode")||game.user.isGM||"creation"===game.settings.get("CoC7","playerUnlockSheetMode")&&game.settings.get("CoC7","charCreationEnabled"),"creation"===game.settings.get("CoC7","playerUnlockSheetMode")&&game.settings.get("CoC7","charCreationEnabled")&&(sheetData.data.system.flags.locked=!1),"vehicle"!==this.actor.type&&(sheetData.data.system.characteristics||(sheetData.data.system.characteristics={str:{value:null,short:"CHARAC.STR",label:"CHARAC.Strength",formula:null},con:{value:null,short:"CHARAC.CON",label:"CHARAC.Constitution",formula:null},siz:{value:null,short:"CHARAC.SIZ",label:"CHARAC.Size",formula:null},dex:{value:null,short:"CHARAC.DEX",label:"CHARAC.Dexterity",formula:null},app:{value:null,short:"CHARAC.APP",label:"CHARAC.Appearance",formula:null},int:{value:null,short:"CHARAC.INT",label:"CHARAC.Intelligence",formula:null},pow:{value:null,short:"CHARAC.POW",label:"CHARAC.Power",formula:null},edu:{value:null,short:"CHARAC.EDU",label:"CHARAC.Education",formula:null}}),sheetData.data.system.attribs||(sheetData.data.system.attribs={hp:{value:null,max:null,short:"HP",label:"Hit points",auto:!0},mp:{value:null,max:null,short:"HP",label:"Magic points",auto:!0},lck:{value:null,short:"LCK",label:"Luck"},san:{value:null,max:99,short:"SAN",label:"Sanity",auto:!0},mov:{value:null,short:"MOV",label:"Movement rate",auto:!0},db:{value:null,short:"DB",label:"Damage bonus",auto:!0},build:{value:null,short:"BLD",label:"Build",auto:!0},armor:{value:null,auto:!1}}),sheetData.data.system.biography||(sheetData.data.system.biography={personalDescription:{type:"string",value:""}}),sheetData.data.system.infos||(sheetData.data.system.infos={occupation:"",age:"",sex:"",residence:"",birthplace:"",archetype:"",organization:"",playername:""}),sheetData.data.system.flags||(sheetData.data.system.flags={locked:!0,manualCredit:!1}),sheetData.data.system.credit||(sheetData.data.system.credit={monetarySymbol:null,multiplier:null,spent:null,assetsDetails:null}),sheetData.data.system.development||(sheetData.data.system.development={personal:null,occupation:null,archetype:null,experiencePackage:null}),sheetData.data.system.biography||(sheetData.data.system.biography=[]),sheetData.pulpRuleArchetype=game.settings.get("CoC7","pulpRuleArchetype"),sheetData.pulpRuleOrganization=game.settings.get("CoC7","pulpRuleOrganization"),!sheetData.pulpRuleArchetype&&this.actor.experiencePackage)){const doc=this.actor.experiencePackage;sheetData.hasExperiencePackage=!0,sheetData.nameExperiencePackage=doc.name}if(sheetData.isDead=this.actor.dead,sheetData.isDying=this.actor.dying,sheetData.items){for(const item of sheetData.items){if("skill"===item.type)if(item.system.properties.special&&(item.system.properties.fighting&&!item.system.specialization&&(item.system.specialization=game.i18n.localize("CoC7.FightingSpecializationName")),item.system.properties.firearm&&!item.system.specialization&&(item.system.specialization=game.i18n.localize("CoC7.FirearmSpecializationName")),item.system.properties.ranged&&!item.system.specialization&&(item.system.specialization=game.i18n.localize("CoC7.RangedSpecializationName"))),"character"!==this.actor.type){if(isNaN(Number(item.system.value))){let value=null;const parsed={};for(const[key,value]of Object.entries(COC7.formula.actorsheet))key.startsWith("@")&&value.startsWith("this.")&&(parsed[key.substring(1)]=foundry.utils.getProperty(this,value.substring(5)));try{value=(await new Roll(item.system.value,parsed).evaluate({async:!0})).total}catch(err){console.warn(game.i18n.format("CoC7.ErrorUnableToParseSkillFormula",{value:item.system.value,name:item.name})),value=null}if(value){item.system.value=value;const itemToUpdate=this.actor.items.get(item._id);console.info(`[COC7] (Actor:${this.name}) Evaluating skill ${item.name}:${item.system.value} to ${value}`),await itemToUpdate.update({"system.value":value})}}const skill=this.actor.items.get(item._id),{base,rawValue,value}=skill.system;item.system.rawValue=rawValue||value||base,item.system.value=value||base}else{const skill=this.actor.items.get(item._id);if(item.system.base=await skill.asyncBase(),item.system.value){let updatedExp=(item.system.adjustments?.experience?parseInt(item.system.adjustments.experience):0)+parseInt(item.system.value)-skill.value;updatedExp<=0&&(updatedExp=null),console.info(`[COC7] Updating skill ${skill.name} experience. Experience missing: ${updatedExp}`),await this.actor.updateEmbeddedDocuments("Item",[{_id:item._id,"system.adjustments.experience":updatedExp,"system.value":null}]),item.system.adjustments||(item.system.adjustments={}),item.system.adjustments.experience=updatedExp,item.system.rawValue=skill.rawValue,item.system.value=skill.value}else item.system.value=skill.value,item.system.rawValue=skill.rawValue}let list=sheetData.itemsByType[item.type];list||(list=[],sheetData.itemsByType[item.type]=list),list.push(item)}for(const itemType in sheetData.itemsByType)"skill"===itemType?sheetData.itemsByType[itemType].sort(CoC7Utilities.sortBySpecializationThenName):sheetData.itemsByType[itemType].sort(CoC7Utilities.sortByNameKey);sheetData.skills=sheetData.items.filter((item=>"skill"===item.type)).sort(CoC7Utilities.sortBySpecializationThenName),sheetData.meleeSkills=sheetData.skills.filter((skill=>!0===skill.system.properties.combat&&!0===skill.system.properties.fighting)),sheetData.rangeSkills=sheetData.skills.filter((skill=>!0===skill.system.properties.combat&&(!0===skill.system.properties.firearm||!0===skill.system.properties.ranged)));const cbtSkills=sheetData.skills.filter((skill=>!0===skill.system.properties.combat));if(cbtSkills)for(const skill of cbtSkills)sheetData.combatSkills[skill._id]=skill;const weapons=sheetData.itemsByType.weapon;if(weapons)for(const weapon of weapons){if(weapon.usesAlternateSkill=!0===weapon.system.properties.auto||!0===weapon.system.properties.brst,weapon.system.ammo||(weapon.system.ammo=0),weapon.skillSet=!0,""===weapon.system.skill.main.id)weapon.skillSet=!1;else{const skill=this.actor.items.get(weapon.system.skill.main.id);if(skill?(weapon.system.skill.main.name=skill.system.skillName,weapon.system.skill.main.value=skill.value):weapon.skillSet=!1,""!==weapon.system.skill.alternativ.id){const skill=this.actor.items.get(weapon.system.skill.alternativ.id);skill&&(weapon.system.skill.alternativ.name=skill.system.skillName,weapon.system.skill.alternativ.value=skill.value)}}weapon.system._properties=[];for(const[key,value]of Object.entries(COC7.weaponProperties)){const property={};property.id=key,property.name=value,property.value=!0===weapon.system.properties[key],weapon.system._properties.push(property)}sheetData.weapons[weapon._id]=weapon,weapon.system.properties.rngd?sheetData.rangeWpn.push(weapon):sheetData.meleeWpn.push(weapon)}const token=this.token;if(sheetData.tokenId=token?`${token.parent?.id?token.parent.id:"TOKEN"}.${token.id}`:null,sheetData.hasEmptyValueWithFormula=!1,sheetData.data.system.characteristics)for(const characteristic of Object.values(sheetData.data.system.characteristics))characteristic.value||(characteristic.editable=!0),characteristic.hard=Math.floor(characteristic.value/2),characteristic.extreme=Math.floor(characteristic.value/5),characteristic.value||characteristic.formula?characteristic.display=!0:characteristic.display=!1,!characteristic.value&&characteristic.formula&&(characteristic.hasEmptyValueWithFormula=!0),sheetData.hasEmptyValueWithFormula=sheetData.hasEmptyValueWithFormula||characteristic.hasEmptyValueWithFormula}if(["vehicle","container"].includes(this.actor.type))sheetData.data.system.attribs.hp.auto=!1,sheetData.data.system.attribs.mp.auto=!1,sheetData.data.system.attribs.san.auto=!1,sheetData.data.system.attribs.mov.auto=!1,sheetData.data.system.attribs.db.auto=!1,sheetData.data.system.attribs.build.auto=!1;else{const auto=this.actor.checkUndefinedAuto();sheetData.data.system=foundry.utils.mergeObject(sheetData.data.system,auto)}return sheetData.data.system.attribs.mp.value<0&&(sheetData.data.system.attribs.mp.value=null),sheetData.data.system.attribs.san.value<0&&(sheetData.data.system.attribs.san.value=null),["vehicle"].includes(this.actor.type)||sheetData.data.system.biography instanceof Array&&sheetData.data.system.biography.length&&(sheetData.data.system.biography[0].isFirst=!0,sheetData.data.system.biography[sheetData.data.system.biography.length-1].isLast=!0),sheetData.showInventoryItems=!1,sheetData.showInventoryBooks=!1,sheetData.showInventorySpells=!1,sheetData.showInventoryTalents=!1,sheetData.showInventoryStatuses=!1,sheetData.showInventoryWeapons=!1,sheetData.showInventoryArmor=!1,sheetData.hasConditions=this.actor.effects.size>0||void 0!==this.actor.system.conditions&&Object.keys(this.actor.system.conditions).filter((condition=>this.actor.system.conditions[condition].value)).length>0,sheetData}get tokenKey(){throw ui.notifications.error("DEPRECATED SHOULD NOT HAPPEN!"),new Error("base.js get tokenKey(): DEPRECATED SHOULD NOT HAPPEN!")}onCloseSheet(){}activateListeners(html){if(super.activateListeners(html),html.find(".section-header").click(this._onSectionHeader.bind(this)),html.find(".items-header").click(this._onItemHeader.bind(this)),html.find(".inventory-header").click(this._onInventoryHeader.bind(this)),html.find(".read-only").dblclick(this._toggleReadOnly.bind(this)),html.find(".add-ammo").click(this._onAddAmo.bind(this)),html.find(".reload-weapon").click((event=>this._onReloadWeapon(event))),html.find(".reload-weapon").on("contextmenu",(event=>this._onReloadWeapon(event))),this.actor.isOwner&&!this.actor.compendium?.locked&&(html.find(".lock").click(this._onLockClicked.bind(this)),html.find(".flag").click(this._onFlagClicked.bind(this)),html.find(".formula").click(this._onFormulaClicked.bind(this)),html.find(".auto-toggle").click(this._onAutoToggle.bind(this))),this.actor.isOwner&&(null===this.actor.compendium||void 0===this.actor.compendium)){if(game.settings.get("CoC7","useContextMenus")){this.menus||(this.menus=[]);const rollMenu={id:"skill-roll",classes:"roll-menu",section:[{classes:"main",items:[{action:"roll",label:"Roll"},{action:"opposed-roll",label:"Opposed roll"},{action:"combined-roll",label:"Combined roll"}]},{classes:"keeper",visibility:"gm",items:[{label:{icon:"fas fa-link",text:"Link"},subMenu:{items:[{action:"link-tool",label:"Open in link tool"},{action:"send-chat",label:"Send to chat"},{action:"copy-to-clipboard",label:"Copy to clip-board"}]}},{action:"request-roll",label:"Request roll"}]}]},sanMenu={id:"san-roll",classes:"roll-menu",section:[{classes:"main",items:[{action:"encounter",label:"Encounter"},{action:"roll",label:"Roll"},{action:"opposed-roll",label:"Opposed roll"},{action:"combined-roll",label:"Combined roll"}]},{classes:"keeper",visibility:"trusted",items:[{action:"request-roll",label:"Request roll"},{label:{icon:"fas fa-link",text:"Link"},subMenu:{items:[{action:"link-tool",label:"Open in link tool"},{action:"send-chat",label:"Send to chat"},{action:"copy-to-clipboard",label:"Copy to clip-board"},{action:"link-encounter",label:"Encounter"}]}}]}]},rollContextMenu=new CoC7ContextMenu;rollContextMenu.bind(rollMenu,html,this._onContextMenuClick.bind(this)),this.menus.push(rollContextMenu);const sanContextMenu=new CoC7ContextMenu;sanContextMenu.bind(sanMenu,html,this._onContextMenuClick.bind(this)),this.menus.push(sanContextMenu)}else html.find(".characteristic-label").contextmenu(this._onOpposedRoll.bind(this)),html.find(".skill-name.rollable").contextmenu(this._onOpposedRoll.bind(this)),html.find(".attribute-label.rollable").contextmenu(this._onOpposedRoll.bind(this));html.find(".characteristic-label").click(this._onRollCharacteriticTest.bind(this)),html.find(".skill-name.rollable").click(this._onRollSkillTest.bind(this)),html.find(".skill-image").click(this._onRollSkillTest.bind(this)),html.find(".attribute-label.rollable").click(this._onRollAttribTest.bind(this)),html.find(".token-drag-handle").on("dragstart",this._onDragTokenStart.bind(this)),html.find(".characteristic-label").on("dragstart",(event=>this._onDragCharacteristic(event))),html.find(".attribute-label").on("dragstart",(event=>this._onDragAttribute(event))),html.find(".san-check").on("dragstart",(event=>this._onDragSanCheck(event))),html.find(".weapon-name.rollable").contextmenu(this._onOpposedRoll.bind(this)),html.find(".roll-characteritics").click(this._onRollCharacteriticsValue.bind(this)),html.find(".average-characteritics").click(this._onAverageCharacteriticsValue.bind(this)),html.find(".toggle-switch").click(this._onToggle.bind(this)),(game.user.isGM||game.settings.get("CoC7","statusPlayerEditable"))&&(html.find(".reset-counter").click(this._onResetCounter.bind(this)),html.find(".condition-monitor").click(this._onConditionToggle.bind(this)),html.find(".is-dying").click(this.heal.bind(this)),html.find(".is-dead").click(this.revive.bind(this))),html.find(".dying-check").click(this.checkForDeath.bind(this)),html.find(".item .item-image").click((event=>this._onItemRoll(event))),html.find(".weapon-name.rollable").click((event=>this._onWeaponRoll(event))),html.find(".item-name.effect-name").click((event=>this._onEffect(event))),html.find(".weapon-skill.rollable").click((async event=>this._onWeaponSkillRoll(event))),html.on("click",".weapon-damage",this._onWeaponDamage.bind(this));const wheelInputs=html.find(".attribute-value");for(const wheelInput of wheelInputs)wheelInput.addEventListener("wheel",(event=>this._onWheel(event)),{passive:!0})}this.options.editable&&(html.find(".show-detail").click((event=>this._onItemSummary(event))),html.find(".item-popup").click(this._onItemPopup.bind(this)),html.find(".show-detail").dblclick((event=>this._onRenderItemSheet(event))),html.find(".item-edit").click((event=>this._onRenderItemSheet(event))),html.find(".item-delete").click((async ev=>{const li=$(ev.currentTarget).parents(".item"),itemToDelete=this.actor.items.get(li.data("itemId"),{strict:!0});await itemToDelete.delete(),li.slideUp(200,(()=>this.render(!1)))})),html.find(".add-item").click((ev=>{switch(ev.stopPropagation(),ev.currentTarget.dataset.type){case"armor":this.actor.createEmptyArmor(ev);break;case"book":this.actor.createEmptyBook(ev);break;case"item":this.actor.createEmptyItem(ev);break;case"skill":this.actor.createEmptySkill(ev);break;case"spell":this.actor.createEmptySpell(ev);break;case"weapon":{const properties={};ev.currentTarget.dataset.melee?properties.melee=!0:ev.currentTarget.dataset.rngd&&(properties.rngd=!0),this.actor.createEmptyWeapon(ev,properties)}}})),html.find(".item-trade").click(this._onTradeItem.bind(this)),html.find(".add-new-section").click((()=>{this.actor.createBioSection(),this.render()})),html.find(".delete-section").click((ev=>{const index=parseInt(ev.currentTarget.closest(".bio-section").dataset.index);this.actor.deleteBioSection(index)})),html.find(".move-section-up").click((ev=>{const index=parseInt(ev.currentTarget.closest(".bio-section").dataset.index);this.actor.moveBioSectionUp(index)})),html.find(".move-section-down").click((ev=>{const index=parseInt(ev.currentTarget.closest(".bio-section").dataset.index);this.actor.moveBioSectionDown(index)})),html.find(".development-flag").dblclick((ev=>{this.actor.items.get(ev.currentTarget.closest(".item").dataset.itemId).toggleItemFlag("developement")})),html.find(".occupation-skill-flag.clickable").click((ev=>{this.actor.items.get(ev.currentTarget.closest(".item").dataset.itemId).toggleItemFlag("occupation")})),html.find(".archetype-skill-flag.clickable").click((ev=>{this.actor.items.get(ev.currentTarget.closest(".item").dataset.itemId).toggleItemFlag("archetype")})),html.find(".skill-developement").click((event=>{this.actor.developementPhase(event.shiftKey)})),html.find(".luck-development").click((event=>{event.detail&&1!==event.detail||this.actor.developLuck(event.shiftKey)})),html.find(".clear_conditions").click((event=>{if(void 0!==this.actor.system.conditions){const disable={};for(const condition in this.actor.system.conditions)void 0!==this.actor.system.conditions[condition].value&&!0===this.actor.system.conditions[condition].value&&(disable[`system.conditions.${condition}.value`]=!1);Object.keys(disable).length>0&&this.actor.update(disable)}const effects=this.actor.effects.map((effect=>effect.id));effects.length>0&&this.actor.deleteEmbeddedDocuments("ActiveEffect",effects)})),html.find(".test-trigger").click((async event=>{if(!game.settings.get("CoC7","hiddendevmenu"))return null})),html.find(".skill-name.rollable:not(.withouttooltip)").mouseenter(this.toolTipSkillEnter.bind(this)).mouseleave(game.CoC7Tooltips.toolTipLeave.bind(this)),html.find(".characteristic-label").mouseenter(this.toolTipCharacteristicEnter.bind(this)).mouseleave(game.CoC7Tooltips.toolTipLeave.bind(this)),html.find(".attribute-label.rollable").mouseenter(this.toolTipAttributeEnter.bind(this)).mouseleave(game.CoC7Tooltips.toolTipLeave.bind(this)),html.find(".auto-toggle").mouseenter(this.toolTipAutoEnter.bind(this)).mouseleave(game.CoC7Tooltips.toolTipLeave.bind(this)),html.find(".item-control.development-flag").mouseenter(this.toolTipFlagForDevelopment.bind(this)).mouseleave(game.CoC7Tooltips.toolTipLeave.bind(this)),html.find(".effect-control").click((ev=>CoC7ActiveEffect.onManageActiveEffect(ev,this.actor))))}toolTipSkillEnter(event){const delay=parseInt(game.settings.get("CoC7","toolTipDelay"));delay>0&&(game.CoC7Tooltips.ToolTipHover=event.currentTarget,game.CoC7Tooltips.toolTipTimer=setTimeout((()=>{const toolTip=game.actors.documentClass.toolTipSkillText();!1!==toolTip&&game.CoC7Tooltips.displayToolTip(toolTip)}),delay))}toolTipCharacteristicEnter(event){const delay=parseInt(game.settings.get("CoC7","toolTipDelay"));if(delay>0){const sheet=this;game.CoC7Tooltips.ToolTipHover=event.currentTarget,game.CoC7Tooltips.toolTipTimer=setTimeout((function(){if(void 0!==game.CoC7Tooltips.ToolTipHover&&null!==game.CoC7Tooltips.ToolTipHover){const char=game.CoC7Tooltips.ToolTipHover.closest(".char-box");if(void 0!==char&&char){const charId=char.dataset.characteristic,characteristic=sheet.actor.characteristics[charId];let toolTip=game.i18n.format("CoC7.ToolTipSkill",{skill:characteristic.label,regular:characteristic.value??0,hard:characteristic.hard??0,extreme:characteristic.extreme??0});game.user.isGM&&(toolTip+=game.i18n.format("CoC7.ToolTipKeeperSkill",{other:game.settings.get("CoC7","stanbyGMRolls")&&sheet.actor.hasPlayerOwner?game.i18n.format("CoC7.ToolTipKeeperStandbySkill",{name:sheet.actor.name}):""})),game.CoC7Tooltips.displayToolTip(toolTip)}}}),delay)}}toolTipAttributeEnter(event){const delay=parseInt(game.settings.get("CoC7","toolTipDelay"));if(delay>0){const sheet=this;game.CoC7Tooltips.ToolTipHover=event.currentTarget,game.CoC7Tooltips.toolTipTimer=setTimeout((function(){if(void 0!==game.CoC7Tooltips.ToolTipHover&&null!==game.CoC7Tooltips.ToolTipHover){const attrib=game.CoC7Tooltips.ToolTipHover.closest(".attribute");if(void 0!==attrib){const attributeId=attrib.dataset.attrib;let toolTip="";const attributes=sheet.actor.system.attribs[attributeId];switch(attributeId){case"lck":toolTip=game.i18n.format("CoC7.ToolTipSkill",{skill:attributes.label,regular:attributes.value??0,hard:Math.floor((attributes.value??0)/2),extreme:Math.floor((attributes.value??0)/5)}),game.user.isGM&&(toolTip+=game.i18n.format("CoC7.ToolTipKeeperSkill",{other:game.settings.get("CoC7","stanbyGMRolls")&&sheet.actor.hasPlayerOwner?game.i18n.format("CoC7.ToolTipKeeperStandbySkill",{name:sheet.actor.name}):""})),game.CoC7Tooltips.displayToolTip(toolTip);break;case"db":toolTip=game.i18n.localize("CoC7.ToolTipDB"),game.CoC7Tooltips.displayToolTip(toolTip);break;case"san":toolTip=game.i18n.format("CoC7.ToolTipSanity",{skill:"Sanity",regular:attributes.value??0,hard:Math.floor((attributes.value??0)/2),extreme:Math.floor((attributes.value??0)/5)}),game.user.isGM&&(toolTip+=game.i18n.format("CoC7.ToolTipKeeperSkill",{other:game.i18n.localize("CoC7.ToolTipKeeperSanity")+(game.settings.get("CoC7","stanbyGMRolls")&&sheet.actor.hasPlayerOwner?game.i18n.format("CoC7.ToolTipKeeperStandbySkill",{name:sheet.actor.name}):"")})),game.CoC7Tooltips.displayToolTip(toolTip)}}}}),delay)}}toolTipAutoEnter(event){const delay=parseInt(game.settings.get("CoC7","toolTipDelay"));delay>0&&(game.CoC7Tooltips.ToolTipHover=event.currentTarget,game.CoC7Tooltips.toolTipTimer=setTimeout((function(){if(void 0!==game.CoC7Tooltips.ToolTipHover&&null!==game.CoC7Tooltips.ToolTipHover){const toolTip=game.i18n.localize("CoC7.ToolTipAutoToggle");game.CoC7Tooltips.displayToolTip(toolTip)}}),delay))}toolTipFlagForDevelopment(event){const delay=parseInt(game.settings.get("CoC7","toolTipDelay"));if(delay>0){const sheet=this;game.CoC7Tooltips.ToolTipHover=event.currentTarget,game.CoC7Tooltips.toolTipTimer=setTimeout((function(){if(void 0!==game.CoC7Tooltips.ToolTipHover&&null!==game.CoC7Tooltips.ToolTipHover){const item=game.CoC7Tooltips.ToolTipHover.closest(".item");if(void 0!==item){const skillId=item.dataset.skillId,skill=sheet.actor.items.get(skillId),toolTip=game.i18n.format("CoC7.ToolTipSkillFlagToggle",{status:game.i18n.localize(skill.system.flags.developement?"CoC7.ToolTipSkillFlagged":"CoC7.ToolTipSkillUnflagged")});game.CoC7Tooltips.displayToolTip(toolTip)}}}),delay)}}_onContextMenuClick(event,target){const targetType=target.dataset?.targetType,rollOptions={preventStandby:!0,fastForward:!1,actor:this.actor};switch(targetType){case"skill":rollOptions.rollType=CoC7ChatMessage.ROLL_TYPE_SKILL,rollOptions.skillId=target.closest(".item")?.dataset.skillId;break;case"characteristic":rollOptions.rollType=CoC7ChatMessage.ROLL_TYPE_CHARACTERISTIC,rollOptions.characteristic=target.closest(".char-box").dataset.characteristic;break;case"attribute":rollOptions.rollType=CoC7ChatMessage.ROLL_TYPE_ATTRIBUTE,rollOptions.attribute=target.closest(".attribute").dataset.attrib}switch(event.currentTarget.dataset.action){case"roll":rollOptions.cardType=CoC7ChatMessage.CARD_TYPE_NORMAL;break;case"opposed-roll":rollOptions.cardType=CoC7ChatMessage.CARD_TYPE_OPPOSED;break;case"combined-roll":rollOptions.cardType=CoC7ChatMessage.CARD_TYPE_COMBINED;break;case"request-roll":rollOptions.cardType=CoC7ChatMessage.CARD_TYPE_NORMAL,rollOptions.preventStandby=!1;break;case"link-tool":rollOptions.cardType=CoC7ChatMessage.CARD_TYPE_NONE,rollOptions.openLinkTool=!0;break;case"send-chat":rollOptions.cardType=CoC7ChatMessage.CARD_TYPE_NONE,rollOptions.sendToChat=!0;break;case"copy-to-clipboard":rollOptions.cardType=CoC7ChatMessage.CARD_TYPE_NONE,rollOptions.sendToClipboard=!0;break;case"link-encounter":rollOptions.cardType=CoC7ChatMessage.CARD_TYPE_NONE,rollOptions.createEncounter=!0;break;case"encounter":rollOptions.cardType=CoC7ChatMessage.CARD_TYPE_SAN_CHECK,rollOptions.rollType=CoC7ChatMessage.ROLL_TYPE_ATTRIBUTE,rollOptions.fastForward=!0}CoC7ChatMessage.trigger(rollOptions)}_onRenderItemSheet(event){const li=$(event.currentTarget).parents(".item");this.actor.items.get(li.data("itemId")).sheet.render(!0)}async _onTradeItem(event){const li=$(event.currentTarget).parents(".item"),item=this.actor.items.get(li.data("itemId"));let content="<p>"+game.i18n.localize("CoC7.MessageSelectUserToGiveTo");const message={actorFrom:this.actor.id,scene:null,actorTo:this.actor.id,item:item.id};this.token?.actor&&(message.actorFrom=this.token.id,message.scene=this.token.parent.id);const actors=game.actors.filter((e=>{if(!["character","npc","creature","container"].includes(e.type))return!1;if(this.actor.id===e.id)return!1;let visible=!1;for(const[k,v]of Object.entries(e.ownership))"default"!==k&&k!==game.user.id||(visible=visible||v!==CONST.DOCUMENT_OWNERSHIP_LEVELS.NONE);return visible}));content+='<form id="selectform"><select name="user">';for(const actor of actors)content=content+'<option value="'+actor.id+'">'+actor.name+"</option>";content+="</select></form></p>",message.actorTo=await new Promise((resolve=>{new Dialog({title:game.i18n.localize("CoC7.MessageTitleSelectUserToGiveTo"),content,buttons:{confirm:{label:game.i18n.localize("CoC7.Validate"),callback:html=>{const formData=new FormData(html[0].querySelector("#selectform"));for(const[name,value]of formData)if("user"===name)return resolve(value)}}},default:"confirm",close:()=>{}}).render(!0)})),await game.CoC7socket.executeAsGM("gmtradeitemto",message)}_onDragStart(event){if(super._onDragStart(event),this.token){const dragData=JSON.parse(event.dataTransfer.getData("text/plain"));dragData.tokenUuid=this.token.uuid,dragData.tokenId=this.token.id,dragData.sceneId=this.token.parent.id,event.dataTransfer.setData("text/plain",JSON.stringify(dragData))}}_onDragCharacteristic(event){const box=event.currentTarget.parentElement,data={CoC7Type:"link",linkType:"characteristic",check:"check",type:"CoC7Link",hasPlayerOwner:this.actor.hasPlayerOwner,actorKey:this.actor.actorKey,name:box.dataset.characteristic,icon:null,document:{type:this.document.type,uuid:this.document.uuid}};event.originalEvent.dataTransfer.setData("text/plain",JSON.stringify(data))}_onDragAttribute(event){const box=event.currentTarget.parentElement,data={CoC7Type:"link",linkType:"attribute",check:"check",type:"CoC7Link",hasPlayerOwner:this.actor.hasPlayerOwner,actorKey:this.actor.actorKey,name:box.dataset.attrib,icon:null,document:{type:this.document.type,uuid:this.document.uuid}};event.originalEvent.dataTransfer.setData("text/plain",JSON.stringify(data))}_onDragSanCheck(event){const sanMin=event.currentTarget.querySelector(".san-value.pass"),sanMax=event.currentTarget.querySelector(".san-value.failed"),data={CoC7Type:"link",linkType:"coc7-link",check:"sanloss",hasPlayerOwner:this.actor.hasPlayerOwner,actorKey:this.actor.actorKey,sanMin:sanMin.innerText,sanMax:sanMax.innerText,icon:null,document:{type:this.document.type,uuid:this.document.uuid}};event.originalEvent.dataTransfer.setData("text/plain",JSON.stringify(data))}async _onDrop(event){const dataString=event.dataTransfer.getData("text/plain");if(""===dataString)return!1;const data=JSON.parse(dataString);if("CoC7Link"===data.type)data.check===CoC7Link.CHECK_TYPE.EFFECT&&CoC7Link._onLinkActorClick(this.actor,data);else if(["creature","npc"].includes(this.actor.type)&&"Macro"===data.type){const macros=this.actor.system.special.macros?foundry.utils.duplicate(this.actor.system.special.macros):[];return macros.push({uuid:data.uuid}),this.actor.update({"system.special.macros":macros}),!1}await super._onDrop(event)}async _onConditionToggle(event){event.preventDefault(),event.currentTarget.dataset.condition&&await this.actor.toggleCondition(event.currentTarget.dataset.condition)}async revive(){game.user.isGM&&this.actor.unsetCondition(COC7.status.dead)}async heal(){game.user.isGM&&this.actor.unsetCondition(COC7.status.dying)}async checkForDeath(event){const conCheck=new CoC7ConCheck(this.actor.isToken?this.actor.tokenKey:this.actor.id);conCheck.stayAlive=!0,conCheck.toMessage(event.shiftKey)}async _onDragTokenStart(event){const data={type:"Token",uuid:this.token.uuid};event.originalEvent.dataTransfer.setData("text/plain",JSON.stringify(data))}async _onResetCounter(event){event.preventDefault(),await this.actor.resetDailySanity()}async _onAutoToggle(event){if(event.currentTarget.closest(".attribute")){const attrib=event.currentTarget.closest(".attribute").dataset.attrib;this.actor.toggleAttribAuto(attrib)}}async _onToggle(event){const weapon=this.actor.items.get(event.currentTarget.closest(".item").dataset.itemId);weapon&&weapon.toggleProperty(event.currentTarget.dataset.property,isCtrlKey(event))}async _onRollCharacteriticsValue(){await this.actor.rollCharacteristicsValue()}async _onAverageCharacteriticsValue(){this.actor.averageCharacteristicsValue()}async _onLockClicked(event){event.preventDefault();const isLocked=this.actor.locked;this.actor.locked=!isLocked,Hooks.call("actorLockClickedCoC7",[!isLocked])}async _onFlagClicked(event){event.preventDefault();const flagName=event.currentTarget.dataset.flag;this.actor.toggleActorFlag(flagName)}async _onFormulaClicked(event){event.preventDefault(),this.actor.toggleActorFlag("displayFormula")}async _onWheel(event){let value=parseInt(event.currentTarget.value)||null;switch(event.deltaY>0&&(value=0===value?0:value-1),event.deltaY<0&&(value+=1),event.currentTarget.name){case"system.attribs.hp.value":case"system.attribs.build.current":this.actor.setHp(value);break;case"system.attribs.mp.value":this.actor.setMp(value);break;case"system.attribs.san.value":this.actor.setSan(value);break;case"system.attribs.lck.value":this.actor.setLuck(value)}}_toggleReadOnly(event){event.currentTarget.readOnly=!event.currentTarget.readOnly,event.currentTarget.classList.toggle("read-only")}async _onItemSummary(event){event.preventDefault();const li=$(event.currentTarget).parents(".item"),item=this.actor.items.get(li.data("item-id")),chatData=await item.getChatData({secrets:this.actor.isOwner});if(li.hasClass("expanded")){const summary=li.children(".item-summary");summary.slideUp(200,(()=>{summary.remove(),li.toggleClass("expanded")}))}else{const div=$('<div class="item-summary"></div>'),labels=$('<div class="item-labels"></div>');for(const p of chatData.labels)labels.append(`<div class="item-label"><span class="label-name">${p.name} :</span><span class="label-value">${p.value}</span></div>`);if(div.append(labels),div.append($(`<div class="item-description">${chatData.description.value}</div>`)),item.system.properties?.spcl){const specialDiv=$(`<div class="item-special">${chatData.description.special}</div>`);div.append(specialDiv)}const props=$('<div class="item-properties"></div>');for(const p of chatData.properties)props.append(`<div class="tag item-property">${game.i18n.localize(p)}</div>`);div.append(props),li.append(div.hide()),div.slideDown(200,(()=>li.toggleClass("expanded")))}}async _onSectionHeader(event){event.preventDefault();const section=event.currentTarget.closest("section"),pannelClass=event.currentTarget.dataset.pannel;if(void 0===pannelClass)return;const pannel=$(section).find(`.pannel.${pannelClass}`);pannel.hasClass("expanded")?pannel.slideUp(200,(()=>pannel.toggleClass("expanded"))):pannel.slideDown(200,(()=>pannel.toggleClass("expanded")));const camelFlag=chatHelper.hyphenToCamelCase(`data.pannel.${pannelClass}.expanded`);this.actor.update({[camelFlag]:!pannel.hasClass("expanded")},{render:!1})}_onInventoryHeader(event){event.preventDefault();const li=$(event.currentTarget).siblings("li");li.is(":visible")?li.slideUp(200):li.slideDown(200)}_onItemHeader(event){event.preventDefault();const ol=$(event.currentTarget).next("ol");ol.is(":visible")?ol.slideUp(200):ol.slideDown(200)}async _onItemPopup(event){event.preventDefault();const li=$(event.currentTarget).parents(".item"),item=this.actor.items.get(li.data("item-id"));CoC7ActorSheet.popupSkill(item)}static async popupSkill(skill){skill.system.description.enrichedValue=await TextEditor.enrichHTML(skill.system.description.value,{async:!0});new Dialog({title:game.i18n.localize("CoC7.SkillDetailsWindow"),content:skill,buttons:{},close:()=>{}},{classes:["coc7","sheet","skill"],width:520,height:480,scrollY:[".item-description"],template:"systems/CoC7/templates/apps/skill-details.html"}).render(!0)}async _onItemRoll(event){event.preventDefault()}async _onEffect(event){event.preventDefault();const effectId=event.currentTarget.closest("li").dataset.effectId,effect=this.actor.effects.get(effectId);isCtrlKey(event)&&game.user.isGM&&CoC7ContentLinkDialog.create({type:"CoC7Link",check:CoC7Link.CHECK_TYPE.EFFECT,object:effect})}async _onWeaponRoll(event){event.preventDefault();const itemId=event.currentTarget.closest("li").dataset.itemId,fastForward=event.shiftKey,weapon=this.actor.items.get(itemId);let actorKey;if(actorKey=this.token?this.actor.isToken&&game.actors.tokens[this.token.id]?`TOKEN.${this.token.id}`:`${this.token.parent.id}.${this.token.id}`:this.actor.id,isCtrlKey(event)&&game.user.isGM){const linkData={check:CoC7Link.CHECK_TYPE.ITEM,name:weapon.name};CoC7ContentLinkDialog.create(linkData,{actors:[this.actor]})}else{let proceedWithoutTarget=game.settings.get("CoC7","disregardNoTargets");if(!proceedWithoutTarget&&game.user.targets.size<=0&&(proceedWithoutTarget=await new Promise((resolve=>{const data={title:" ",content:game.i18n.format("CoC7.NoTargetSelected",{weapon:weapon.name}),buttons:{cancel:{icon:'<i class="fas fa-times"></i>',label:game.i18n.localize("CoC7.Cancel"),callback:()=>resolve(!1)},proceed:{icon:'<i class="fas fa-check"></i>',label:game.i18n.localize("CoC7.Proceed"),callback:()=>resolve(!0)}},default:"cancel",classes:["coc7","dialog"]};new Dialog(data).render(!0)}))),game.user.targets.size>0||proceedWithoutTarget){if(!weapon.system.properties.rngd){game.user.targets.size>1&&ui.notifications.warn(game.i18n.localize("CoC7.WarnTooManyTarget"));new CoC7MeleeInitiator(actorKey,itemId,fastForward).createChatCard()}if(weapon.system.properties.rngd){new CoC7RangeInitiator(actorKey,itemId,fastForward).createChatCard()}}}}async _onReloadWeapon(event){const itemId=event.currentTarget.closest(".item")?event.currentTarget.closest(".item").dataset.itemId:null;if(!itemId)return;const weapon=this.actor.items.get(itemId);0===event.button?event.shiftKey?await weapon.reload():await weapon.addBullet():2===event.button&&(event.shiftKey?await weapon.setBullets(0):await weapon.shootBullets(1))}async _onAddAmo(event){const itemId=event.currentTarget.closest(".item")?event.currentTarget.closest(".item").dataset.itemId:null;if(!itemId)return;const weapon=this.actor.items.get(itemId);await weapon.addBullet()}async _onWeaponSkillRoll(event){event.preventDefault();const skillId=event.currentTarget.dataset.skillId,actorId=event.currentTarget.closest("form").dataset.actorId,tokenKey=event.currentTarget.closest("form").dataset.tokenId,itemId=event.currentTarget.closest("li")?event.currentTarget.closest("li").dataset.itemId:null,check=new CoC7Check;if(!event.shiftKey){const usage=await RollDialog.create();usage&&(check.diceModifier=usage.get("bonusDice"),check.difficulty=usage.get("difficulty"),check.flatDiceModifier=Number(usage.get("flatDiceModifier")),check.flatThresholdModifier=Number(usage.get("flatThresholdModifier")))}check.actor=tokenKey||actorId,check.skill=skillId,check.item=itemId,await check.roll(),check.toMessage()}async _onWeaponDamage(event){event.preventDefault();const itemId=event.currentTarget.closest(".weapon").dataset.itemId,range=event.currentTarget.closest(".weapon-damage").dataset.range,damageChatCard=new DamageCard({fastForward:event.shiftKey,range});damageChatCard.actorKey=this.actor.tokenKey,damageChatCard.itemId=itemId,damageChatCard.updateChatCard()}async _onOpposedRoll(event){if(event.preventDefault(),"db"===event.currentTarget.parentElement.dataset.attrib)return;const data={rollType:CoC7ChatMessage.ROLL_TYPE_SKILL,cardType:CoC7ChatMessage.CARD_TYPE_OPPOSED,event,actor:this.actor};event.currentTarget.classList.contains("characteristic-label")?data.rollType=CoC7ChatMessage.ROLL_TYPE_CHARACTERISTIC:event.currentTarget.classList.contains("attribute-label")&&(data.rollType=CoC7ChatMessage.ROLL_TYPE_ATTRIBUTE),event.altKey&&(data.cardType=CoC7ChatMessage.CARD_TYPE_COMBINED),CoC7ChatMessage.trigger(data)}async _onRollCharacteriticTest(event){event.preventDefault(),event.currentTarget.classList.contains("flagged4dev")||(game.settings.get("CoC7","useContextMenus")?CoC7ChatMessage.trigger({rollType:CoC7ChatMessage.ROLL_TYPE_CHARACTERISTIC,cardType:CoC7ChatMessage.CARD_TYPE_NORMAL,preventStandby:!0,fastForward:!0,characteristic:event.currentTarget.closest(".char-box").dataset.characteristic,actor:this.actor}):CoC7ChatMessage.trigger({rollType:CoC7ChatMessage.ROLL_TYPE_CHARACTERISTIC,cardType:CoC7ChatMessage.CARD_TYPE_NORMAL,event,actor:this.actor}))}async _onRollAttribTest(event){event.preventDefault();const attrib=event.currentTarget.parentElement.dataset.attrib;if("db"!==attrib)game.settings.get("CoC7","useContextMenus")?CoC7ChatMessage.trigger({rollType:CoC7ChatMessage.ROLL_TYPE_CHARACTERISTIC,cardType:CoC7ChatMessage.CARD_TYPE_NORMAL,preventStandby:!0,fastForward:!0,attribute:event.currentTarget.closest(".attribute").dataset.attrib,actor:this.actor}):CoC7ChatMessage.trigger({rollType:CoC7ChatMessage.ROLL_TYPE_ATTRIBUTE,cardType:event.altKey&&"san"===attrib?CoC7ChatMessage.CARD_TYPE_SAN_CHECK:CoC7ChatMessage.CARD_TYPE_NORMAL,event,actor:this.actor});else if(!/^-{0,1}\d+$/.test(event.currentTarget.parentElement.dataset.rollFormula)){const r=new Roll(event.currentTarget.parentElement.dataset.rollFormula);await r.roll({async:!0}),isNaN(r.total)||void 0===r.total||r.toMessage({speaker:ChatMessage.getSpeaker(),flavor:game.i18n.localize("CoC7.BonusDamageRoll")})}}_onRollSkillTest(event){event.preventDefault(),event.currentTarget.classList.contains("flagged4dev")||(game.settings.get("CoC7","useContextMenus")?CoC7ChatMessage.trigger({rollType:CoC7ChatMessage.ROLL_TYPE_SKILL,cardType:CoC7ChatMessage.CARD_TYPE_NORMAL,preventStandby:!0,fastForward:!0,skillId:event?.currentTarget.closest(".item")?.dataset.skillId,actor:this.actor}):CoC7ChatMessage.trigger({rollType:CoC7ChatMessage.ROLL_TYPE_SKILL,cardType:CoC7ChatMessage.CARD_TYPE_NORMAL,event,actor:this.actor}))}async _updateObject(event,formData){const overrides=foundry.utils.flattenObject(this.actor.overrides),name=event?.currentTarget?.name;name&&overrides&&overrides[name]&&ui.notifications.warn(game.i18n.format("CoC7.EffectAppliedCantOverride",{name})),this.object.img!==formData.img&&(this.object.token??this.object.prototypeToken).texture.src===CoCActor.defaultImg(this.object.type)&&(this.object.token?this.object.token.update({"texture.src":formData.img}):this.object.prototypeToken.update({"texture.src":formData.img}));const biographyKeyRegex=/^system.biography\.(\d+)\.(.+)$/,biographyKeys=Object.keys(formData).map((k=>k.match(biographyKeyRegex))).filter((m=>m));if(biographyKeys.length){const biography=foundry.utils.duplicate(this.actor.system.biography);for(const biographyKey of biographyKeys)biography[biographyKey[1]][biographyKey[2]]=formData["system.biography."+biographyKey[1]+"."+biographyKey[2]],delete formData[biographyKey[0]];formData["system.biography"]=biography}if(event.currentTarget&&event.currentTarget.classList){if(event.currentTarget.classList.contains("skill-adjustment")){const item=this.actor.items.get(event.currentTarget.closest(".item").dataset.itemId);if(item){const value=event.currentTarget.value?parseInt(event.currentTarget.value):null;if(event.currentTarget.value?isNaN(value)||await item.update({[event.currentTarget.name]:value}):await item.update({[event.currentTarget.name]:null}),game.i18n.localize("CoC7.CoCIDFlag.keys.i.skill.credit-rating")===item.name&&void 0!==this.actor.occupation?.system?.creditRating?.max){const creditValue=(item.value||0)-(item.system.adjustments?.experience||0);(creditValue>Number(this.actor.occupation.system.creditRating.max)||creditValue<Number(this.actor.occupation.system.creditRating.min))&&ui.notifications.warn(game.i18n.format("CoC7.CreditOutOfRange",{min:Number(this.actor.occupation.system.creditRating.min),max:Number(this.actor.occupation.system.creditRating.max)}))}}}if(event.currentTarget.classList.contains("attribute-value")){if("system.attribs.san.value"===event.currentTarget.name)return await this.actor.setSan(parseInt(event.currentTarget.value)),void this.render(!0);if("system.attribs.hp.value"===event.currentTarget.name)return await this.actor.setHp(parseInt(event.currentTarget.value)),void this.render(!0)}if(event.currentTarget.classList.contains("text-area"))return void this.actor.updateTextArea(event.currentTarget);if(event.currentTarget.classList.contains("bio-section-value")){const index=parseInt(event.currentTarget.closest(".bio-section").dataset.index);await this.actor.updateBioValue(index,event.currentTarget.value)}if(event.currentTarget.classList.contains("bio-section-title")){const index=parseInt(event.currentTarget.closest(".bio-section").dataset.index);this.actor.updateBioTitle(index,event.currentTarget.value)}if(event.currentTarget.classList.contains("npc-skill-score")){const skill=this.actor.items.get(event.currentTarget.closest(".item").dataset.skillId);skill&&await skill.updateValue(event.currentTarget.value)}if(event.currentTarget.classList.contains("skill-name")||event.currentTarget.classList.contains("item-name")){const item=this.actor.items.get(event.currentTarget.closest(".item").dataset.skillId);if(item){const data={};if(item.system.properties.special){const parts=CoC7Item.getNamePartsSpec(event.currentTarget.value,item.system.specialization);data.name=parts.name,data["system.skillName"]=parts.skillName,data["system.specialization"]=parts.specialization}else data["system.skillName"]=event.currentTarget.value,data.name=event.currentTarget.value;await item.update(data)}}if(event.currentTarget.classList.contains("characteristic-formula")&&0!==event.currentTarget.value.length){const r=new Roll(event.currentTarget.value);await r.roll({async:!0}),(isNaN(r.total)||void 0===r.total)&&(ui.notifications.error(game.i18n.format("CoC7.ErrorInvalidFormula",{value:event.currentTarget.value})),formData[event.currentTarget.name]=game.i18n.format("CoC7.ErrorInvalid"))}if(event.currentTarget.classList.contains("attribute-value")&&0!==event.currentTarget.value.length&&"db"===event.currentTarget.closest(".attribute").dataset.attrib){const r=new Roll(event.currentTarget.value);await r.roll({async:!0}),(isNaN(r.total)||void 0===r.total)&&(ui.notifications.error(game.i18n.format("CoC7.ErrorInvalidFormula",{value:event.currentTarget.value})),formData[event.currentTarget.name]=game.i18n.format("CoC7.ErrorInvalid"))}if(event.currentTarget.classList.contains("weapon-skill")){const weapon=this.actor.items.get(event.currentTarget.closest(".item").dataset.itemId),skill=this.actor.items.get(event.currentTarget.options[event.currentTarget.selectedIndex].value);if(weapon&&skill)switch(event.currentTarget.dataset.skill){case"main":await weapon.update({"system.skill.main.id":skill.id,"system.skill.main.name":skill.name});break;case"alternativ":await weapon.update({"system.skill.alternativ.id":skill.id,"system.skill.alternativ.name":skill.name})}}if(event.currentTarget.classList.contains("weapon-name")){const weapon=this.actor.items.get(event.currentTarget.closest(".item").dataset.itemId);weapon&&await weapon.update({name:event.currentTarget.value})}if(event.currentTarget.classList.contains("damage-formula")){const weapon=this.actor.items.get(event.currentTarget.closest(".item").dataset.itemId);if(weapon)if(0!==event.currentTarget.value.length){const r=new Roll(event.currentTarget.value);if(await r.roll({async:!0}),isNaN(r.total)||void 0===r.total)ui.notifications.error(game.i18n.format("CoC7.ErrorUnableToParseFormula",{value:event.currentTarget.value}));else switch(event.currentTarget.dataset.range){case"normal":await weapon.update({"system.range.normal.damage":event.currentTarget.value});break;case"long":await weapon.update({"system.range.long.damage":event.currentTarget.value});break;case"extreme":await weapon.update({"system.range.extreme.damage":event.currentTarget.value})}}else switch(event.currentTarget.dataset.range){case"normal":await weapon.update({"system.range.normal.damage":null});break;case"long":await weapon.update({"system.range.long.damage":null});break;case"extreme":await weapon.update({"system.range.extreme.damage":null})}}}return this.object.update(formData)}}class CoC7CreateMythosEncounter extends FormApplication{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{classes:["coc7"],title:game.i18n.localize("CoC7.SanityLossTypeDialogTitle"),template:"systems/CoC7/templates/apps/sanity-loss-type.hbs",height:"auto"})}async getData(){const data=await super.getData();return data.isImmunity="immunity"===data.object.type,data.encounterTypes=[{key:"encounter",label:"CoC7.SanityLossEncounter"},{key:"immunity",label:"CoC7.SanityLossImmunity"}],data}activateListeners(html){html.find(".field_type").change(this._onSelectChange.bind(this)),html.find(".dialog-button").click(this._onButtonClick.bind(this)),super.activateListeners(html)}_onButtonClick(event){if("add"===event.currentTarget.dataset.button){const html=$(event.currentTarget).closest(".window-content"),type=html.find(".field_type").val(),name=html.find(".field_name").val(),value=parseInt(html.find(".field_value").val()),sanityLossEvents=this.object.actor.system.sanityLossEvents??[];sanityLossEvents.push({type:name,totalLoss:value,immunity:"immunity"===type}),sanityLossEvents.sort((function(left,right){return left.type.localeCompare(right.type)})),this.object.actor.update({"system.sanityLossEvents":sanityLossEvents})}this.close()}_onSelectChange(event){const html=$(event.currentTarget).closest(".window-content");this.object.name=html.find(".field_name").val(),this.object.type=html.find(".field_type").val(),this.render(!0)}async _updateObject(event,formData){}}class CoC7CharacterSheet extends CoC7ActorSheet{_getHeaderButtons(){if("CoC7CharacterSheet"===this.constructor.name){this.summarized||(this.summarized=!1);let buttons=super._getHeaderButtons();return buttons=[{label:this.summarized?game.i18n.localize("CoC7.Maximize"):game.i18n.localize("CoC7.Summarize"),class:"test-extra-icon",icon:this.summarized?"fas fa-window-maximize":"fas fa-window-minimize",onclick:event=>this.toggleSheetMode(event)}].concat(buttons),buttons}return super._getHeaderButtons()}async toggleSheetMode(event){this.summarized=!this.summarized;let options=foundry.utils.duplicate(CoC7CharacterSheet.defaultOptions);this.summarized&&(options=foundry.utils.mergeObject(options,{classes:["coc7","actor","character","summarized"],height:200,resizable:!1,width:700})),options.token=this.options.token,await this.close(),await this.render(!0,options)}async getData(){const sheetData=await super.getData();this.isEditable&&void 0===this.actor.getFlag("CoC7","skillListMode")&&await this.actor.setFlag("CoC7","skillListMode",!1),this.isEditable&&void 0===this.actor.getFlag("CoC7","skillShowUncommon")&&await this.actor.setFlag("CoC7","skillShowUncommon",!0),sheetData.skillListModeValue=this.actor.getFlag("CoC7","skillListMode")??!1,sheetData.skillShowUncommon=this.actor.getFlag("CoC7","skillShowUncommon")??!0,sheetData.showIconsOnly=game.settings.get("CoC7","showIconsOnly"),this.actor.occupation?(sheetData.data.system.infos.occupation=this.actor.occupation.name,sheetData.data.system.infos.occupationSet=!0):sheetData.data.system.infos.occupationSet=!1,this.actor.archetype?(sheetData.data.system.infos.archetype=this.actor.archetype.name,sheetData.data.system.infos.archetypeSet=!0):sheetData.data.system.infos.archetypeSet=!1,sheetData.totalExperience=this.actor.experiencePoints,sheetData.totalOccupation=this.actor.occupationPointsSpent,sheetData.invalidOccupationPoints=Number(this.actor.occupationPointsSpent)!==Number(this.actor.system.development?.occupation),sheetData.totalArchetype=this.actor.archetypePointsSpent,sheetData.invalidArchetypePoints=Number(this.actor.archetypePointsSpent)!==Number(this.actor.system.development?.archetype),sheetData.totalExperiencePackage=Number(this.actor.ExperiencePackagePointsSpent),sheetData.invalidExperiencePackagePoints=Number(this.actor.ExperiencePackagePointsSpent)!==Number(this.actor.ExperiencePackagePoints),sheetData.totalPersonal=this.actor.personalPointsSpent,sheetData.invalidPersonalPoints=Number(this.actor.personalPointsSpent)!==Number(this.actor.system.development?.personal),sheetData.creditRatingMax=Number(this.actor.occupation?.system.creditRating.max),sheetData.creditRatingMin=Number(this.actor.occupation?.system.creditRating.min),sheetData.invalidCreditRating=this.actor.creditRatingSkill?.system.adjustments?.occupation>sheetData.creditRatingMax||this.actor.creditRatingSkill?.system.adjustments?.occupation<sheetData.creditRatingMin,sheetData.pulpTalentCount=sheetData.itemsByType.talent?.length?sheetData.itemsByType.talent?.length:0,sheetData.minPulpTalents=this.actor.archetype?.system.talents?this.actor.archetype?.system.talents:0,sheetData.invalidPulpTalents=sheetData.pulpTalentCount<sheetData.minPulpTalents,sheetData.hasDevelopmentPhase=this.actor.hasDevelopmentPhase,sheetData.allowDevelopment=game.settings.get("CoC7","developmentEnabled"),sheetData.allowCharCreation=game.settings.get("CoC7","charCreationEnabled"),sheetData.developmentRollForLuck=game.settings.get("CoC7","developmentRollForLuck"),sheetData.showDevPannel=sheetData.allowDevelopment||sheetData.allowCharCreation,sheetData._monetaryFormats=[];for(const key in COC7.monetaryFormats)sheetData._monetaryFormats.push({key,val:game.i18n.localize(COC7.monetaryFormats[key])});sheetData.showCurrencySymbol=["decimalLeft","decimalRight","integerLeft","integerRight"].includes(sheetData.data.system.monetary.format),sheetData._monetaryTypes=[];for(const key in COC7.monetaryTypes)(0===COC7.monetaryTypes[key].filter.length||COC7.monetaryTypes[key].filter.includes(sheetData.data.system.monetary.format))&&sheetData._monetaryTypes.push({key,val:game.i18n.localize(COC7.monetaryTypes[key].name)});sheetData.manualCredit=this.actor.getActorFlag("manualCredit"),sheetData.manualCredit||(sheetData.monetary={spendingLevel:CoCActor.monetaryFormat(sheetData.data.system.monetary.format,sheetData.data.system.monetary.symbol,this.actor.spendingLevel),assets:CoCActor.monetaryFormat(sheetData.data.system.monetary.format,sheetData.data.system.monetary.symbol,this.actor.assets),cash:CoCActor.monetaryFormat(sheetData.data.system.monetary.format,sheetData.data.system.monetary.symbol,this.actor.cash)}),sheetData.oneBlockBackStory=game.settings.get("CoC7","oneBlockBackstory"),sheetData.summarized=this.summarized&&!sheetData.permissionLimited,sheetData.isSummarized=this.summarized,sheetData.skillList=[];let previousSpec="";for(const skill of sheetData.skills)!sheetData.skillShowUncommon&&skill.system.properties.rarity||(skill.system.properties.special&&previousSpec!==skill.system.specialization&&(previousSpec=skill.system.specialization,sheetData.skillList.push({isSpecialization:!0,name:skill.system.specialization})),sheetData.skillList.push(skill));if(sheetData.skillsByValue=[...sheetData.skills].sort(((a,b)=>b.system.value-a.system.value)),sheetData.topSkills=[...sheetData.skillsByValue].slice(0,14),sheetData.skillsByValue=sheetData.skillsByValue.filter((skill=>sheetData.skillShowUncommon||!skill.system.properties.rarity)),sheetData.topWeapons=[...sheetData.meleeWpn,...sheetData.rangeWpn].sort(((a,b)=>a.system.skill.main?.value-b.system.skill.main?.value)).reverse().slice(0,3),sheetData.displayPlayerName=game.settings.get("CoC7","displayPlayerNameOnSheet"),sheetData.displayPlayerName&&!sheetData.data.system.infos.playername){const user=this.actor.characterUser;user&&(sheetData.data.system.infos.playername=user.name)}return sheetData.skillListEmpty=0===sheetData.skills.length,sheetData.showInventoryItems=Object.prototype.hasOwnProperty.call(sheetData.itemsByType,"item")||!sheetData.data.system.flags.locked,sheetData.showInventoryBooks=Object.prototype.hasOwnProperty.call(sheetData.itemsByType,"book")||!sheetData.data.system.flags.locked,sheetData.showInventorySpells=Object.prototype.hasOwnProperty.call(sheetData.itemsByType,"spell")||!sheetData.data.system.flags.locked,sheetData.showInventoryTalents=Object.prototype.hasOwnProperty.call(sheetData.itemsByType,"talent")||!sheetData.data.system.flags.locked&&game.settings.get("CoC7","pulpRuleTalents"),sheetData.showInventoryStatuses=Object.prototype.hasOwnProperty.call(sheetData.itemsByType,"status")||!sheetData.data.system.flags.locked,sheetData.showInventoryArmor=Object.prototype.hasOwnProperty.call(sheetData.itemsByType,"armor")||!sheetData.data.system.flags.locked,sheetData.hasInventory=sheetData.showInventoryItems||sheetData.showInventoryBooks||sheetData.showInventorySpells||sheetData.showInventoryTalents||sheetData.showInventoryStatuses||sheetData.showInventoryWeapons||sheetData.showInventoryArmor,sheetData.enrichedBackstory=await TextEditor.enrichHTML(sheetData.data.system.backstory,{async:!0,secrets:sheetData.editable}),sheetData.enrichedDescriptionKeeper=await TextEditor.enrichHTML(sheetData.data.system.description.keeper,{async:!0,secrets:sheetData.editable}),sheetData}_saveScrollPositions(html){super._saveScrollPositions(html);this._scrollPositionsX=[".right-panel .tab.development ol"].reduce(((pos,sel)=>{const el=html.find(sel);return pos[sel]=Array.from(el).map((el=>el.scrollLeft)),pos}),{})}_restoreScrollPositions(html){super._restoreScrollPositions(html);const selectors=[".right-panel .tab.development ol"],positions=this._scrollPositionsX||{};for(const sel of selectors){html.find(sel).each(((i,el)=>{el.scrollLeft=positions[sel]?.[i]||0}))}}static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{classes:["coc7","sheetV2","actor","character"],template:"systems/CoC7/templates/actors/character/index.html",width:687,height:623,resizable:!0,dragDrop:[{dragSelector:".item",dropSelector:null}],scrollY:[".right-panel .tab"],tabs:[{navSelector:".sheet-nav",contentSelector:".sheet-body",initial:"skills"}]})}activateListeners(html){super.activateListeners(html),this.actor.isOwner&&(html.find(".skill-name.rollable.flagged4dev").click((async event=>this._onSkillDev(event))),html.find(".reset-occupation").click((async()=>await this.actor.resetOccupation())),html.find(".reset-experience-package").click((async()=>await this.actor.resetExperiencePackage())),html.find(".reset-archetype").click((async()=>await this.actor.resetArchetype())),html.find(".open-item").click((event=>this._onItemDetails(event))),html.find(".toggle-list-mode").click((event=>{this.toggleSkillListMode(event)})),html.find(".toggle-uncommon-mode").click((event=>{this.toggleSkillUncommonMode(event)})),game.user.isGM&&(html.find(".sanity-loss-type-add").click(this._onAddSanityLossReason.bind(this)),html.find(".sanity-loss-type-delete").click(this._onDeleteSanityLossReason.bind(this)),html.find(".mythosEncountersTotalLoss").blur(this._onEditSanityLossReason.bind(this)),html.find(".toggle-keeper-flags").click(this._onToggleKeeperFlags.bind(this)),html.find(".add-monetary").click(this._onAddMonetary.bind(this)),html.find(".remove-monetary").click(this._onRemoveMonetary.bind(this))))}_onAddMonetary(){const values=this.actor.system.monetary.values?foundry.utils.duplicate(this.actor.system.monetary.values):[];values.push({name:"",min:null,max:null,cashType:0,cashValue:"",assetsType:0,assetsValue:"",spendingType:0,spendingValue:""}),this.actor.update({"system.monetary.values":values})}_onRemoveMonetary(event){const div=event.currentTarget.closest(".item"),values=foundry.utils.duplicate(this.actor.system.monetary.values);values.splice(Number(div.dataset.index),1),this.actor.update({"system.monetary.values":values})}_onToggleKeeperFlags(event){switch(event.preventDefault(),event.currentTarget.dataset.flag){case"mythosInsanityExperienced":this.actor.setFlag("CoC7","mythosInsanityExperienced",!this.actor.mythosInsanityExperienced);break;case"mythosHardened":this.actor.setFlag("CoC7","mythosHardened",!this.actor.mythosHardened)}}async _onAddSanityLossReason(event){event.preventDefault(),new CoC7CreateMythosEncounter({actor:this.actor,type:event.currentTarget.dataset.type},{}).render(!0)}async _onEditSanityLossReason(event){const input=$(event.currentTarget),offset=input.closest(".flexrow-coc7").data("offset");if(void 0!==this.actor.system.sanityLossEvents?.[offset]?.totalLoss){const sanityLossEvents=foundry.utils.duplicate(this.actor.system.sanityLossEvents);sanityLossEvents[offset].totalLoss=parseInt(input.val(),10),this.actor.update({"system.sanityLossEvents":sanityLossEvents})}}_onDeleteSanityLossReason(event){event.preventDefault();const offset=$(event.currentTarget).closest(".flexrow-coc7").data("offset"),sanityLossEvents=this.actor.system.sanityLossEvents??[];sanityLossEvents.splice(offset,1),sanityLossEvents.sort((function(left,right){return left.type.localeCompare(right.type)})),this.actor.update({"system.sanityLossEvents":sanityLossEvents})}async toggleSkillListMode(event){return await this.actor.setFlag("CoC7","skillListMode",!this.actor.getFlag("CoC7","skillListMode")),await this.render(!0)}async toggleSkillUncommonMode(event){return await this.actor.setFlag("CoC7","skillShowUncommon",!this.actor.getFlag("CoC7","skillShowUncommon")),await this.render(!0)}async _onSkillDev(event){event.preventDefault();const skillId=event.currentTarget.closest(".item").dataset.itemId;await this.actor.developSkill(skillId,event.shiftKey)}_onItemDetails(event){event.preventDefault();const type=event.currentTarget.dataset.type,item=this.actor[type];item&&item.sheet.render(!0)}_updateObject(event,formData){const system=foundry.utils.expandObject(formData)?.system;system.monetary?.values&&(formData["system.monetary.values"]=Object.values(system.monetary.values||[])),super._updateObject(event,formData)}static renderSheet(sheet,html){if(game.settings.get("CoC7","overrideSheetArtwork")){if(game.settings.get("CoC7","artWorkSheetBackground"))if("null"===game.settings.get("CoC7","artWorkSheetBackground").toLowerCase())sheet.element.css("--main-sheet-bg","url( './assets/images/void.webp')");else if(sheet.element.css("--main-sheet-bg",game.settings.get("CoC7","artWorkSheetBackground")),"slice"!==game.settings.get("CoC7","artWorkSheetBackgroundType")){let styleSheet,cssRuleIndex;for(let i=0;i<document.styleSheets.length;i++)if(document.styleSheets[i].href?.endsWith("coc7g.css")){styleSheet=document.styleSheets[i];break}if(styleSheet)for(let i=0;i<styleSheet.rules.length;i++)if(".sheetV2.character form"===styleSheet.rules[i].selectorText){cssRuleIndex=i;break}if(cssRuleIndex){const CSSStyle=styleSheet.rules[cssRuleIndex].style;switch(CSSStyle.removeProperty("border-image"),CSSStyle.setProperty("background",game.settings.get("CoC7","artWorkSheetBackground")),game.settings.get("CoC7","artWorkSheetBackgroundType")){case"auto":default:CSSStyle.setProperty("background-size","auto");break;case"contain":CSSStyle.setProperty("background-size","contain");break;case"cover":CSSStyle.setProperty("background-size","cover")}}}if(game.settings.get("CoC7","artWorkOtherSheetBackground")&&("null"===game.settings.get("CoC7","artWorkOtherSheetBackground").toLowerCase()?sheet.element.css("--other-sheet-bg","url( './assets/images/void.webp')"):sheet.element.css("--other-sheet-bg",game.settings.get("CoC7","artWorkOtherSheetBackground"))),game.settings.get("CoC7","artworkSheetImage")&&("null"===game.settings.get("CoC7","artworkSheetImage").toLowerCase()?sheet.element.css("--main-sheet-image","url( './assets/images/void.webp')"):sheet.element.css("--main-sheet-image",game.settings.get("CoC7","artworkSheetImage"))),game.settings.get("CoC7","artworkFrontColor")&&sheet.element.css("--main-sheet-front-color",game.settings.get("CoC7","artworkFrontColor")),game.settings.get("CoC7","artworkBackgroundColor")&&sheet.element.css("--main-sheet-back-color",game.settings.get("CoC7","artworkBackgroundColor")),game.settings.get("CoC7","artworkInteractiveColor")&&sheet.element.css("--main-sheet-interactive-color",game.settings.get("CoC7","artworkInteractiveColor")),game.settings.get("CoC7","artworkFixedSkillLength")||(sheet.element.css("--skill-length","auto"),sheet.element.css("--skill-specialization-length","auto")),game.settings.get("CoC7","artworkMainFont")){new FontFace("customSheetFont",game.settings.get("CoC7","artworkMainFont")).load().then((function(loadedFace){document.fonts.add(loadedFace)})).catch((function(error){ui.notifications.error(error)}))}if(game.settings.get("CoC7","artworkMainFontBold")){new FontFace("customSheetFont",game.settings.get("CoC7","artworkMainFontBold"),{weight:"bold"}).load().then((function(loadedFace){document.fonts.add(loadedFace)})).catch((function(error){ui.notifications.error(error)}))}if(game.settings.get("CoC7","artworkMainFontSize")){const size=`${game.settings.get("CoC7","artworkMainFontSize")}px`;size!==$(":root").css("font-size")&&$(":root").css("font-size",size)}}if(void 0!==sheet.actor?.system.pannel)for(const[key,value]of Object.entries(sheet.actor.system.pannel)){const pannelClass=chatHelper.camelCaseToHyphen(key),pannel=html.find(`.pannel.${pannelClass}`);value.expanded?pannel.addClass("expanded"):pannel.removeClass("expanded")}}}class CoC7CharacterSheetV3 extends CoC7CharacterSheet{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{classes:["coc7","sheetV3","actor","character"],template:"systems/CoC7/templates/actors/character-sheet-v3.hbs",width:980,height:810,scrollY:[".sheet-body"]})}_getHeaderButtons(){let buttons=super._getHeaderButtons();return buttons=[{label:game.i18n.localize("CoC7.Summarize"),class:"test-extra-icon",icon:"fas fa-window-minimize",onclick:event=>this.toggleSheetMode(event)}].concat(buttons),buttons}async toggleSheetMode(event){const ClassName=CONFIG.Actor.sheetClasses.character["CoC7.CoC7CharacterSheetMinimized"]?.cls;if(void 0!==ClassName){const token=this.options.token;await this.close(),await new ClassName(this.object,{editable:this.object.isOwner}).render(!0,{token})}}async getData(){const sheetData=await super.getData(),hp=this.actor.system.attribs.hp;if(sheetData.imgSaturation=hp.value/hp.max,sheetData.biographySections=[],sheetData.data.system.biography instanceof Array&&sheetData.data.system.biography.length){for(const biography of sheetData.data.system.biography)sheetData.biographySections.push({title:biography.title,value:biography.value,enriched:await TextEditor.enrichHTML(biography.value,{async:!0,secrets:sheetData.editable})});sheetData.biographySections[0].isFirst=!0,sheetData.biographySections[sheetData.biographySections.length-1].isLast=!0}return sheetData.showPartValues=!game.settings.get("CoC7","hidePartValues"),sheetData}activateListeners(html){super.activateListeners(html),this.object.sheet.isEditable&&(html.find(".add-new-section-scroll").click((()=>{this.actor.createBioSection(),html.find(".sheet-body").each(((i,el)=>{el.scrollTop=el.scrollHeight-el.clientHeight})),this.render()})),html.find(".portrait-frame").click((()=>{this._tabs.find((t=>".sheet-nav"===t._navSelector))?.activate("portrait-frame")})),html.find(".optionbox .photo-frame").click((event=>{const objectFit=event.currentTarget.dataset.objectFit;this.actor.update({"flags.CoC7.portraitFrame":objectFit})})))}}class CoC7CharacterSheetMinimized extends CoC7CharacterSheet{constructor(options={}){super(options),this.summarized=!0}static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{classes:["coc7","actor","character","summarized"],height:200,width:700})}_getHeaderButtons(){let buttons=super._getHeaderButtons();return buttons=[{label:game.i18n.localize("CoC7.Maximize"),class:"test-extra-icon",icon:"fas fa-window-maximize",onclick:event=>this.toggleSheetMode(event)}].concat(buttons),buttons}async toggleSheetMode(event){const ClassName=CONFIG.Actor.sheetClasses.character["CoC7.CoC7CharacterSheetV3"]?.cls;if(void 0!==ClassName){const token=this.options.token;await this.close(),await new ClassName(this.object,{editable:this.object.isOwner}).render(!0,{token})}}}class CoC7ContainerSheet extends foundry.appv1.sheets.ActorSheet{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{classes:["coc7","sheet","actor","storage"],template:"systems/CoC7/templates/actors/storage-sheet.html",width:672,height:765,dragDrop:[{dragSelector:".item",dropSelector:null}],tabs:[{navSelector:".sheet-nav",contentSelector:".sheet-body",initial:"items"}]})}async _onDrop(event){event.preventDefault(),event.stopPropagation();const dataList=await CoC7Utilities.getDataFromDropEvent(event,"Item");if(!this.options.editable)return;const items=this.actor.items.toObject()||[];for(const item of dataList)item&&item.system&&["book","item","spell","weapon","armor"].includes(item.type)&&items.push(item.toObject());await this.actor.update({items})}onCloseSheet(){}_getHeaderButtons(){const headerButtons=super._getHeaderButtons();return addCoCIDSheetHeaderButton(headerButtons,this),headerButtons}async getData(){const sheetData=await super.getData();if(sheetData.isKeeper=game.user.isGM,sheetData.editable=this.isEditable,sheetData.itemsByType={},sheetData.items){for(const item of sheetData.items)Object.prototype.hasOwnProperty.call(sheetData.itemsByType,item.type)||(sheetData.itemsByType[item.type]=[]),sheetData.itemsByType[item.type].push(item);for(const itemType in sheetData.itemsByType)sheetData.itemsByType[itemType].sort(CoC7Utilities.sortByNameKey)}return sheetData.allowUnlock="always"===game.settings.get("CoC7","playerUnlockSheetMode")||game.user.isGM,sheetData.showInventoryItems=Object.prototype.hasOwnProperty.call(sheetData.itemsByType,"item")||!sheetData.data.system.flags.locked,sheetData.showInventoryBooks=Object.prototype.hasOwnProperty.call(sheetData.itemsByType,"book")||!sheetData.data.system.flags.locked,sheetData.showInventorySpells=Object.prototype.hasOwnProperty.call(sheetData.itemsByType,"spell")||!sheetData.data.system.flags.locked,sheetData.showInventoryTalents=Object.prototype.hasOwnProperty.call(sheetData.itemsByType,"talent")||!sheetData.data.system.flags.locked&&game.settings.get("CoC7","pulpRuleTalents"),sheetData.showInventoryWeapons=Object.prototype.hasOwnProperty.call(sheetData.itemsByType,"weapon")||!sheetData.data.system.flags.locked,sheetData.showInventoryArmor=Object.prototype.hasOwnProperty.call(sheetData.itemsByType,"armor")||!sheetData.data.system.flags.locked,sheetData.hasInventory=sheetData.showInventoryItems||sheetData.showInventoryBooks||sheetData.showInventorySpells||sheetData.showInventoryTalents||sheetData.showInventoryWeapons||sheetData.showInventoryArmor,sheetData.enrichedDescriptionValue=await TextEditor.enrichHTML(sheetData.data.system.description.value,{async:!0,secrets:sheetData.editable}),sheetData.enrichedDescriptionKeeper=await TextEditor.enrichHTML(sheetData.data.system.description.keeper,{async:!0,secrets:sheetData.editable}),sheetData}activateListeners(html){super.activateListeners(html),html.find(".item-edit").click((ev=>{const li=$(ev.currentTarget).parents(".item");this.actor.items.get(li.data("itemId")).sheet.render(!0)})),html.find(".inventory-header").click(this._onInventoryHeader.bind(this)),html.find(".item-trade").click(this._onTradeItem.bind(this)),html.find(".show-detail").click(this._onItemSummary.bind(this)),html.find(".item-delete").click((async ev=>{const li=$(ev.currentTarget).parents(".item"),itemToDelete=this.actor.items.get(li.data("itemId"),{strict:!0});await itemToDelete.delete(),li.slideUp(200,(()=>this.render(!1)))})),html.find(".add-item").click((ev=>{switch(ev.currentTarget.dataset.type){case"armor":this.actor.createEmptyArmor(ev);break;case"book":this.actor.createEmptyBook(ev);break;case"item":this.actor.createEmptyItem(ev);break;case"skill":this.actor.createEmptySkill(ev);break;case"spell":this.actor.createEmptySpell(ev);break;case"weapon":this.actor.createEmptyWeapon(ev)}})),html.find(".lock").click(this._onLockClicked.bind(this))}async _onLockClicked(event){event.preventDefault();const isLocked=this.actor.locked;this.actor.locked=!isLocked}async _onTradeItem(event){const li=$(event.currentTarget).parents(".item"),item=this.actor.items.get(li.data("itemId"));let content="<p>"+game.i18n.localize("CoC7.MessageSelectUserToGiveTo");const message={actorFrom:this.actor.id,scene:null,actorTo:this.actor.id,item:item.id};this.token?.actor&&(message.actorFrom=this.token.id,message.scene=this.token.parent.id);const actors=game.actors.filter((e=>{if(!["character","npc","creature","container"].includes(e.type))return!1;if(this.actor.id===e.id)return!1;let visible=!1;for(const[k,v]of Object.entries(e.ownership))"default"!==k&&k!==game.user.id||(visible=visible||v!==CONST.DOCUMENT_OWNERSHIP_LEVELS.NONE);return visible}));content+='<form id="selectform"><select name="user">';for(const actor of actors)content=content+'<option value="'+actor.id+'">'+actor.name+"</option>";content+="</select></form></p>",await Dialog.prompt({title:game.i18n.localize("CoC7.MessageTitleSelectUserToGiveTo"),content,callback:html=>{const formData=new FormData(html[0].querySelector("#selectform"));for(const[name,value]of formData)"user"===name&&(message.actorTo=value)}}),await game.CoC7socket.executeAsGM("gmtradeitemto",message)}async _onItemSummary(event){event.preventDefault();const li=$(event.currentTarget).parents(".item"),item=this.actor.items.get(li.data("item-id")),chatData=await item.getChatData({secrets:this.actor.isOwner});if(li.hasClass("expanded")){const summary=li.children(".item-summary");summary.slideUp(200,(()=>summary.remove()))}else{const div=$('<div class="item-summary"></div>'),labels=$('<div class="item-labels"></div>');for(const p of chatData.labels)labels.append(`<div class="item-label"><span class="label-name">${p.name} :</span><span class="label-value">${p.value}</span></div>`);if(div.append(labels),div.append($(`<div class="item-description">${chatData.description.value}</div>`)),item.system.properties?.spcl){const specialDiv=$(`<div class="item-special">${chatData.description.special}</div>`);div.append(specialDiv)}const props=$('<div class="item-properties"></div>');for(const p of chatData.properties)props.append(`<div class="tag item-property">${game.i18n.localize(p)}</div>`);div.append(props),li.append(div.hide()),div.slideDown(200)}li.toggleClass("expanded")}_onInventoryHeader(event){event.preventDefault(),$(event.currentTarget).siblings("li").slideToggle(200)}}class CoC7NPCSheet extends CoC7ActorSheet{async getData(){const sheetData=await super.getData();return sheetData.allowFormula=!0,sheetData.displayFormula=this.actor.getActorFlag("displayFormula")||!1,sheetData.hasSan=null!==sheetData.data.system.attribs.san.value,sheetData.hasMp=null!==sheetData.data.system.attribs.mp.value,sheetData.hasLuck=null!==sheetData.data.system.attribs.lck.value,sheetData.isCreature=!1,sheetData.showInventoryItems=Object.prototype.hasOwnProperty.call(sheetData.itemsByType,"item")||!sheetData.data.system.flags.locked,sheetData.showInventoryBooks=Object.prototype.hasOwnProperty.call(sheetData.itemsByType,"book")||!sheetData.data.system.flags.locked,sheetData.showInventorySpells=Object.prototype.hasOwnProperty.call(sheetData.itemsByType,"spell")||!sheetData.data.system.flags.locked,sheetData.showInventoryTalents=Object.prototype.hasOwnProperty.call(sheetData.itemsByType,"talent")||!sheetData.data.system.flags.locked&&game.settings.get("CoC7","pulpRuleTalents"),sheetData.showInventoryStatuses=Object.prototype.hasOwnProperty.call(sheetData.itemsByType,"status")||!sheetData.data.system.flags.locked,sheetData.showInventoryArmor=Object.prototype.hasOwnProperty.call(sheetData.itemsByType,"armor")||!sheetData.data.system.flags.locked,sheetData.showInventoryWeapons=!1,sheetData.hasInventory=sheetData.showInventoryItems||sheetData.showInventoryBooks||sheetData.showInventorySpells||sheetData.showInventoryTalents||sheetData.showInventoryStatuses||sheetData.showInventoryWeapons||sheetData.showInventoryArmor,sheetData.enrichedBiographyPersonalDescription=await TextEditor.enrichHTML(sheetData.data.system.biography.personalDescription?.value,{async:!0,secrets:sheetData.editable}),sheetData.enrichedDescriptionKeeper=await TextEditor.enrichHTML(sheetData.data.system.description.keeper,{async:!0,secrets:sheetData.editable}),sheetData.weaponSkillGroups=this.actor.weaponSkillGroups(),sheetData.movementTypes=Object.keys(CONFIG.Token.movement.actions).reduce(((c,i)=>(c.push({id:i,name:CONFIG.Token.movement.actions[i].label,order:CONFIG.Token.movement.actions[i].order}),c)),[]).sort(((a,b)=>a.order-b.order)),sheetData.macros=await this.actor.system.special.macros.reduce((async(c,i)=>{const carry=await c,macro=await fromUuid(i.uuid);return macro&&carry.push({uuid:macro.uuid,img:macro.img,name:macro.name}),carry}),[]),sheetData}activateListeners(html){if(super.activateListeners(html),game.settings.get("CoC7","useContextMenus")){this.menus||(this.menus=[]);const sanlossMenu={id:"san-loss-roll",classes:"roll-menu",section:[{classes:"main",items:[{action:"link-tool",label:"Open in link tool"},{action:"send-chat",label:"Send to chat"},{action:"copy-to-clipboard",label:"Copy to clip-board"}]}]},sanlossContextMenu=new CoC7ContextMenu;sanlossContextMenu.bind(sanlossMenu,html,this._onSanLossContextMenuClick.bind(this)),this.menus.push(sanlossContextMenu)}html.find(".roll-san").click(this._onSanCheck.bind(this)),html.find(".add-movement").click(this._onAddMovement.bind(this)),html.find(".remove-movement").click(this._onRemoveMovement.bind(this)),html.find(".remove-macro").click(this._onRemoveMacro.bind(this)),html.find(".execute-macro").click(this._onExecuteMacro.bind(this))}_onAddMovement(){const movement=this.actor.system.special.movement?foundry.utils.duplicate(this.actor.system.special.movement):[];movement.push({value:"",type:"walk"}),this.actor.update({"system.special.movement":movement})}_onRemoveMovement(event){const a=event.currentTarget;if(void 0!==a.dataset.index){const movement=foundry.utils.duplicate(this.actor.system.special.movement);movement.splice(Number(a.dataset.index),1),this.actor.update({"system.special.movement":movement})}}_onRemoveMacro(event){const a=event.currentTarget;if(void 0!==a.dataset.index){const macros=foundry.utils.duplicate(this.actor.system.special.macros);macros.splice(Number(a.dataset.index),1),this.actor.update({"system.special.macros":macros})}}async _onExecuteMacro(event){const a=event.currentTarget;if(void 0!==a.dataset.uuid){const macro=await fromUuid(a.dataset.uuid);macro&&macro.execute({speaker:ChatMessage.getSpeaker({actor:this.actor,token:this.token}),actor:this.actor,token:this.token,event})}}async _onSanLossContextMenuClick(event){const rollOptions={rollType:CoC7ChatMessage.ROLL_TYPE_ENCOUNTER,preventStandby:!0,fastForward:!1,event,cardType:CoC7ChatMessage.CARD_TYPE_SAN_CHECK,actor:this.actor};switch(event.currentTarget.dataset.action){case"link-tool":rollOptions.cardType=CoC7ChatMessage.CARD_TYPE_NONE,rollOptions.createEncounter=!0,rollOptions.openLinkTool=!0;break;case"send-chat":rollOptions.cardType=CoC7ChatMessage.CARD_TYPE_NONE,rollOptions.createEncounter=!0,rollOptions.sendToChat=!0;break;case"copy-to-clipboard":rollOptions.cardType=CoC7ChatMessage.CARD_TYPE_NONE,rollOptions.createEncounter=!0,rollOptions.sendToClipboard=!0}CoC7ChatMessage.trigger(rollOptions)}async _onSanCheck(event){if(event.preventDefault(),this.actor.system.special.sanLoss.checkPassed||this.actor.system.special.sanLoss.checkFailled)if(isCtrlKey(event)&&game.user.isGM){let difficulty,modifier;if(!event.shiftKey){const usage=await RollDialog.create({disableFlatDiceModifier:!0});usage&&(modifier=Number(usage.get("bonusDice")),difficulty=Number(usage.get("difficulty")))}const linkData={check:"sanloss",sanMin:this.actor.system.special.sanLoss.checkPassed,sanMax:this.actor.system.special.sanLoss.checkFailled,sanReason:this.actor.system.infos.type?.length?this.actor.system.infos.type:this.actor.name,tokenKey:this.actor.actorKey};"blindroll"===game.settings.get("core","rollMode")&&(linkData.blind=!0),void 0!==modifier&&(linkData.modifier=modifier),void 0!==difficulty&&(linkData.difficulty=difficulty);const link=(new CoC7Link)._createDocumentLink(linkData);link&&chatHelper.createMessage(null,game.i18n.format("CoC7.MessageCheckRequestedWait",{check:link}))}else{const sanData={sanMax:this.actor.sanLossCheckFailled,sanMin:this.actor.sanLossCheckPassed,sanReason:this.actor.system.infos.type?.length?this.actor.system.infos.type:this.actor.name,tokenKey:this.actor.actorKey};SanCheckCard.checkTargets(sanData,event.shiftKey)}}onCloseSheet(){this.actor.unsetActorFlag("displayFormula"),super.onCloseSheet()}static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{classes:["coc7","sheet","actor","npc"],dragDrop:[{dragSelector:".item",dropSelector:null}],template:"systems/CoC7/templates/actors/npc-sheet.html",width:580,resizable:!1,minimizable:!0})}async _updateObject(event,formData){if(event.currentTarget&&event.currentTarget.classList&&event.currentTarget.classList.contains("characteristic-score"))return void this.actor.setCharacteristic(event.currentTarget.name,event.currentTarget.value);const system=foundry.utils.expandObject(formData)?.system;if(system.special?.movement){const movement=foundry.utils.duplicate(this.actor.system.special.movement);for(const offset in system.special.movement)for(const key in system.special.movement[offset])movement[offset][key]=system.special.movement[offset][key];formData["system.special.movement"]=movement}return super._updateObject(event,formData)}static forceAuto(app,html){html.height("auto")}setPosition(a){super.setPosition(a),CoC7NPCSheet.forceAuto(a,this._element)}}class CoC7CreatureSheet extends CoC7NPCSheet{async getData(){const sheetData=await super.getData();return sheetData.isCreature=!0,sheetData}static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{classes:["coc7","sheet","actor","npc","creature"]})}}class CoC7ExperiencePackageSheet extends foundry.appv1.sheets.ItemSheet{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{classes:["coc7","sheet","armor"],template:"systems/CoC7/templates/items/experience-package.hbs",width:520,height:480,dragDrop:[{dragSelector:".item"}],scrollY:[".tab.description"],tabs:[{navSelector:".sheet-navigation",contentSelector:".sheet-body",initial:"description"}]})}_getHeaderButtons(){const headerButtons=super._getHeaderButtons();return addCoCIDSheetHeaderButton(headerButtons,this),headerButtons}async getData(){const sheetData=super.getData();sheetData.data.system.skills=await game.system.api.cocid.expandItemArray({itemList:sheetData.data.system.skills}),sheetData.skillListEmpty=0===sheetData.data.system.skills.length,sheetData.data.system.skills.sort(CoC7Utilities.sortByNameKey);for(let index=0,len=sheetData.data.system.groups.length;index<len;index++)sheetData.data.system.groups[index].skills=await game.system.api.cocid.expandItemArray({itemList:sheetData.data.system.groups[index].skills}),sheetData.data.system.groups[index].isEmpty=0===sheetData.data.system.groups[index].skills.length,sheetData.data.system.groups[index].skills.sort(CoC7Utilities.sortByNameKey);return sheetData.enrichedDescriptionValue=await TextEditor.enrichHTML(sheetData.data.system.description.value,{async:!0,secrets:sheetData.editable}),sheetData.enrichedDescriptionKeeper=await TextEditor.enrichHTML(sheetData.data.system.description.keeper,{async:!0,secrets:sheetData.editable}),sheetData.isKeeper=game.user.isGM,sheetData}activateListeners(html){if(super.activateListeners(html),!this.options.editable)return;html.find(".toggle-property").click(this._onPropertyClick.bind(this)),html.find(".sanity-loss-type-add").click(this._onAddSanityLossReason.bind(this)),html.find(".sanity-loss-type-delete").click(this._onDeleteSanityLossReason.bind(this)),html.find(".item-delete").click((event=>this._onItemDelete(event,"skills"))),html.find(".group-item-delete").click(this._onGroupItemDelete.bind(this)),html.find(".group-control").click(this._onGroupControl.bind(this));new DragDrop({dropSelector:".droppable",callbacks:{drop:this._onDrop.bind(this)}}).bind(html[0])}async _onDrop(event,type="skill",collectionName="skills"){event.preventDefault(),event.stopPropagation();const optionalSkill=event?.currentTarget?.classList?.contains("optional-skills"),ol=event?.currentTarget?.closest("ol"),index=ol?.dataset?.group,dataList=await CoC7Utilities.getDataFromDropEvent(event,"Item");let useCoCID=0;const collection=this.item.system[collectionName]?foundry.utils.duplicate(this.item.system[collectionName]):[],groups=this.item.system.groups?foundry.utils.duplicate(this.item.system.groups):[];for(const item of dataList)if(item&&item.system&&[type].includes(item.type))if(optionalSkill){if(!CoC7Item.isAnySpec(item)){if(collection.find((el=>el.name===item.name)))continue;if(groups[index].skills.find((el=>el.name===item.name)))continue}0===useCoCID&&(useCoCID=await DropCoCID.create()),groups[index].skills=groups[index].skills.concat([DropCoCID.processItem(useCoCID,item)])}else{if(!CoC7Item.isAnySpec(item)){if(collection.find((el=>el.name===item.name)))continue;for(let i=0;i<groups.length;i++){const index=groups[i].skills.findIndex((el=>el.name===item.name));-1!==index&&groups[i].skills.splice(index,1)}}0===useCoCID&&(useCoCID=await DropCoCID.create()),collection.push(DropCoCID.processItem(useCoCID,item))}await this.item.update({"system.groups":groups}),await this.item.update({[`system.${collectionName}`]:collection})}async _onGroupControl(event){event.preventDefault();const a=event.currentTarget;if(a.classList.contains("add-group")){await this._onSubmit(event);const groups=this.item.system.groups;await this.item.update({"system.groups":groups.concat([{options:0,skills:[]}])})}if(a.classList.contains("remove-group")){await this._onSubmit(event);const groups=foundry.utils.duplicate(this.item.system.groups),ol=a.closest(".item-list.group");groups.splice(Number(ol.dataset.group),1),await this.item.update({"system.groups":groups})}}async _onItemDelete(event,collectionName="items"){const item=$(event.currentTarget).closest(".item"),itemId=item.data("item-id"),CoCId=item.data("cocid"),itemIndex=this.item.system[collectionName].findIndex((i=>itemId&&i._id===itemId||CoCId&&i===CoCId));if(itemIndex>-1){const collection=this.item.system[collectionName]?foundry.utils.duplicate(this.item.system[collectionName]):[];collection.splice(itemIndex,1),await this.item.update({[`system.${collectionName}`]:collection})}}async _onGroupItemDelete(event){const item=$(event.currentTarget).closest(".item"),group=Number(item.closest(".item-list.group").data("group")),groups=foundry.utils.duplicate(this.item.system.groups);if(void 0!==groups[group]){const itemId=item.data("item-id"),CoCId=item.data("cocid"),itemIndex=groups[group].skills.findIndex((i=>itemId&&i._id===itemId||CoCId&&i===CoCId));itemIndex>-1&&(groups[group].skills.splice(itemIndex,1),await this.item.update({"system.groups":groups}))}}async _onPropertyClick(event){event.preventDefault();const key=event.currentTarget.dataset.property,propertyId=event.currentTarget.closest(".toggle-attributes").dataset.set,value=!this.item.system[propertyId][key],changes={["system."+propertyId+"."+key]:value};"properties"===propertyId&&"sanitySame"===key?value&&(changes["system."+propertyId+".cthulhuGain"]=!0,changes["system."+propertyId+".sanityLoss"]=!1):"properties"===propertyId&&"sanityLoss"===key?value&&(changes["system."+propertyId+".sanitySame"]=!1):"properties"===propertyId&&"cthulhuGain"===key&&(value||(changes["system."+propertyId+".sanitySame"]=!1)),await this.item.update(changes)}async _onAddSanityLossReason(event){event.preventDefault();const immunity=this.item.system.immunity??[];immunity.push(""),await this.item.update({"system.immunity":immunity})}async _onDeleteSanityLossReason(event){event.preventDefault();const index=$(event.currentTarget).closest(".form-group").data("index"),immunity=this.item.system.immunity??[];immunity.splice(index,1),await this.item.update({"system.immunity":immunity})}_updateObject(event,formData){const system=foundry.utils.expandObject(formData)?.system;if(system.immunity&&(formData["system.immunity"]=Object.values(system.immunity||[])),system.groups){formData["system.groups"]=Object.values(system.groups||[]);for(let index=0;index<this.item.system.groups.length;index++)formData[`system.groups.${index}.skills`]=foundry.utils.duplicate(this.item.system.groups[index].skills)}super._updateObject(event,formData)}}class CoC7ItemSheetV2 extends foundry.appv1.sheets.ItemSheet{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{classes:["coc7","sheet","item"],template:"systems/CoC7/templates/items/item-sheetV2.html",width:500,height:450,scrollY:[".tab.description"],tabs:[{navSelector:".sheet-navigation",contentSelector:".sheet-body",initial:"description"}]})}_getHeaderButtons(){const headerButtons=super._getHeaderButtons();return addCoCIDSheetHeaderButton(headerButtons,this),headerButtons}async getData(options={}){const sheetData=super.getData(options);sheetData.effects=CoC7ActiveEffect.prepareActiveEffectCategories(this.item.effects,{status:!1}),sheetData.enrichedDescriptionValue=await TextEditor.enrichHTML(sheetData.data.system.description.value,{async:!0,secrets:sheetData.editable}),sheetData.enrichedDescriptionKeeper=await TextEditor.enrichHTML(sheetData.data.system.description.keeper,{async:!0,secrets:sheetData.editable}),sheetData._eras=[];for(const[key,value]of Object.entries(COC7.eras))sheetData._eras.push({price:this.item.system.price[key]??0,id:key,name:game.i18n.localize(value),isEnabled:!0===(this.item.flags?.CoC7?.cocidFlag?.eras??{})[key]});return sheetData._eras.sort(CoC7Utilities.sortByNameKey),sheetData.isKeeper=game.user.isGM,sheetData.worldEra=game.settings.get("CoC7","worldEra"),sheetData}activateListeners(html){super.activateListeners(html),this.options.editable&&(html.find(".toggle-switch").click(this._onClickToggle.bind(this)),html.find(".effect-control").click((ev=>CoC7ActiveEffect.onManageActiveEffect(ev,this.item))))}async _onClickToggle(event){event.preventDefault();const propertyId=event.currentTarget.closest(".toggle-switch").dataset.property;await this.item.toggleProperty(propertyId,!1)}}class CoC7ItemSheet extends CoC7ItemSheetV2{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{width:525,height:506})}}class CoC7SetupSheet extends foundry.appv1.sheets.ItemSheet{activateListeners(html){super.activateListeners(html),this.options.editable&&(html.find(".item .item-name h4").click((event=>this._onItemSummary(event,"items"))),html.find(".item-delete").click((event=>this._onItemDelete(event,"items"))),html.find(".add-bio").click((async()=>await this._onAddBio())),html.find(".remove-section").click(this._onRemoveSection.bind(this)),html.find(".toggle-switch").click(this._onClickToggle.bind(this)),html.find(".add-monetary").click(this._onAddMonetary.bind(this)),html.find(".remove-monetary").click(this._onRemoveMonetary.bind(this)))}async _onClickToggle(event){event.preventDefault();const propertyId=event.currentTarget.dataset.property;await this.item.toggleProperty(propertyId,isCtrlKey(event))}async _onDrop(event,collectionName="items"){event.preventDefault(),event.stopPropagation();const dataList=await CoC7Utilities.getDataFromDropEvent(event,"Item");let useCoCID=0;const collection=this.item.system[collectionName]?foundry.utils.duplicate(this.item.system[collectionName]):[];for(const item of dataList)item&&item.system&&["item","weapon","skill","book","spell"].includes(item.type)&&(!CoC7Item.isAnySpec(item)&&collection.find((el=>el.name===item.name))||(0===useCoCID&&(useCoCID=await DropCoCID.create()),collection.push(DropCoCID.processItem(useCoCID,item))));await this.item.update({[`system.${collectionName}`]:collection})}async _onRemoveSection(event){const div=event.currentTarget.closest(".item"),bio=foundry.utils.duplicate(this.item.system.bioSections);bio.splice(Number(div.dataset.index),1),await this.item.update({"system.bioSections":bio})}async _onAddBio(){const bio=this.item.system.bioSections?foundry.utils.duplicate(this.item.system.bioSections):[];bio.push(null),await this.item.update({"system.bioSections":bio})}_onAddMonetary(){const values=this.item.system.monetary.values?foundry.utils.duplicate(this.item.system.monetary.values):[];values.push({name:"",min:null,max:null,cashType:0,cashValue:"",assetsType:0,assetsValue:"",spendingType:0,spendingValue:""}),this.item.update({"system.monetary.values":values})}_onRemoveMonetary(event){const div=event.currentTarget.closest(".item"),values=foundry.utils.duplicate(this.item.system.monetary.values);values.splice(Number(div.dataset.index),1),this.item.update({"system.monetary.values":values})}async _onItemSummary(event,collectionName="items"){event.preventDefault();const li=$(event.currentTarget).parents(".item"),item=this.item.system[collectionName].find((s=>s._id===li.data("item-id")));if(!item)return;const chatData=await TextEditor.enrichHTML(item.system.description.value,{async:!0,secrets:this.item.editable});if(li.hasClass("expanded")){const summary=li.children(".item-summary");summary.slideUp(200,(()=>summary.remove()))}else{const div=$(`<div class="item-summary">${chatData}</div>`),props=$('<div class="item-properties"></div>');div.append(props),li.append(div.hide()),div.slideDown(200)}li.toggleClass("expanded")}async _onItemDelete(event,collectionName="items"){const item=$(event.currentTarget).closest(".item"),itemId=item.data("item-id"),CoCId=item.data("cocid"),itemIndex=this.item.system[collectionName].findIndex((i=>itemId&&i._id===itemId||CoCId&&i===CoCId));if(itemIndex>-1){const collection=this.item.system[collectionName]?foundry.utils.duplicate(this.item.system[collectionName]):[];collection.splice(itemIndex,1),await this.item.update({[`system.${collectionName}`]:collection})}}static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{classes:["coc7","sheet","setup"],template:"systems/CoC7/templates/items/setup.html",width:565,height:530,dragDrop:[{dragSelector:".item"}],scrollY:[".tab.description"],tabs:[{navSelector:".sheet-navigation",contentSelector:".sheet-body",initial:"description"}]})}_getHeaderButtons(){const headerButtons=super._getHeaderButtons();return addCoCIDSheetHeaderButton(headerButtons,this),headerButtons}async getData(){const sheetData=super.getData();sheetData.hasOwner=!0===this.item.isEmbedded;const era=Object.entries(this.item.flags?.CoC7?.cocidFlag?.eras??{}).filter((e=>e[1])).map((e=>e[0])),items=await game.system.api.cocid.expandItemArray({itemList:this.item.system.items,era:void 0===era[0]||era[0]});sheetData.skills=items.filter((it=>"skill"===it.type)),sheetData.otherItems=items.filter((it=>"skill"!==it.type)),sheetData.skillListEmpty=0===sheetData.skills.length,sheetData.itemsListEmpty=0===sheetData.otherItems.length,sheetData.skills.sort(CoC7Utilities.sortByNameKey),sheetData._eras=[];for(const[key,value]of Object.entries(COC7.eras))sheetData._eras.push({id:key,name:game.i18n.localize(value),isEnabled:!0===(this.item.flags?.CoC7?.cocidFlag?.eras??{})[key]});sheetData._eras.sort(CoC7Utilities.sortByNameKey),sheetData._monetaryFormats=[];for(const key in COC7.monetaryFormats)sheetData._monetaryFormats.push({key,val:game.i18n.localize(COC7.monetaryFormats[key])});sheetData.showCurrencySymbol=["decimalLeft","decimalRight","integerLeft","integerRight"].includes(sheetData.data.system.monetary.format),sheetData._monetaryTypes=[];for(const key in COC7.monetaryTypes)(0===COC7.monetaryTypes[key].filter.length||COC7.monetaryTypes[key].filter.includes(sheetData.data.system.monetary.format))&&sheetData._monetaryTypes.push({key,val:game.i18n.localize(COC7.monetaryTypes[key].name)});return sheetData.oneBlockBackStory=game.settings.get("CoC7","oneBlockBackstory"),sheetData.enrichedDescriptionValue=await TextEditor.enrichHTML(sheetData.data.system.description.value,{async:!0,secrets:sheetData.editable}),sheetData.enrichedDescriptionKeeper=await TextEditor.enrichHTML(sheetData.data.system.description.keeper,{async:!0,secrets:sheetData.editable}),sheetData.enrichedBackstory=await TextEditor.enrichHTML(sheetData.data.system.backstory,{async:!0,secrets:sheetData.editable}),sheetData.isKeeper=game.user.isGM,sheetData}_updateObject(event,formData){const system=foundry.utils.expandObject(formData)?.system;system.bioSections&&(formData["system.bioSections"]=Object.values(system.bioSections||[])),system.monetary.values&&(formData["system.monetary.values"]=Object.values(system.monetary.values||[])),"system.characteristics.points.enabled"===event.currentTarget?.name&&(formData["system.characteristics.rolls.enabled"]=!event.currentTarget.checked),"system.characteristics.rolls.enabled"===event.currentTarget?.name&&(formData["system.characteristics.points.enabled"]=!event.currentTarget.checked),super._updateObject(event,formData)}}class CoC7SkillSheet extends foundry.appv1.sheets.ItemSheet{constructor(...args){super(...args),this._sheetTab="items"}static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{classes:["coc7","sheet","item"],width:520,height:480,scrollY:[".tab.description"],tabs:[{navSelector:".sheet-navigation",contentSelector:".sheet-body",initial:"description"}]})}get template(){return`systems/CoC7/templates/items/${this.item.type}-sheet.html`}_getHeaderButtons(){const headerButtons=super._getHeaderButtons();return addCoCIDSheetHeaderButton(headerButtons,this),headerButtons}async getData(){const sheetData=super.getData();sheetData.hasOwner=!0===this.item.isEmbedded,sheetData.hadNonCharacterOwner=sheetData.hasOwner&&"character"!==this.actor?.type,sheetData.effects=CoC7ActiveEffect.prepareActiveEffectCategories(this.item.effects),sheetData._properties=[];for(const[key,value]of Object.entries(COC7.skillProperties))sheetData._properties.push({id:key,name:value,isEnabled:!0===this.item.system.properties[key]});sheetData._eras=[];for(const[key,value]of Object.entries(COC7.eras))sheetData._eras.push({id:key,name:game.i18n.localize(value),isEnabled:!0===(this.item.flags?.CoC7?.cocidFlag?.eras??{})[key]});return sheetData._eras.sort(CoC7Utilities.sortByNameKey),sheetData.isSpecialized=this.item.system.properties.special,sheetData.canModifySpec=!this.item.system.properties.firearm&&!this.item.system.properties.fighting,sheetData.enrichedDescriptionValue=await TextEditor.enrichHTML(sheetData.data.system.description.value,{async:!0,secrets:sheetData.editable}),sheetData.enrichedDescriptionKeeper=await TextEditor.enrichHTML(sheetData.data.system.description.keeper,{async:!0,secrets:sheetData.editable}),sheetData.isKeeper=game.user.isGM,sheetData}activateListeners(html){super.activateListeners(html),this.options.editable&&html.find(".toggle-switch").click(this._onClickToggle.bind(this))}async _onClickToggle(event){event.preventDefault();const propertyId=event.currentTarget.closest(".toggle-switch").dataset.property;await this.item.toggleProperty(propertyId,isCtrlKey(event))}async _updateObject(event,formData){const skillName=formData["system.skillName"]||this.item.system.skillName;if(this.item.system.properties?.special){const specialization=formData["system.specialization"]||this.item.system.specialization;formData.name=specialization+" ("+skillName+")"}else formData.name=skillName;return super._updateObject(event,formData)}}class CoC7SpellSheet extends foundry.appv1.sheets.ItemSheet{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{template:"systems/CoC7/templates/items/spell/main.html",classes:["coc7","item","spell"],width:500,height:"auto",resizable:!1,scrollY:[".body"],tabs:[{navSelector:".navigation",contentSelector:".body",initial:"description"}]})}_getHeaderButtons(){const headerButtons=super._getHeaderButtons();return addCoCIDSheetHeaderButton(headerButtons,this),headerButtons}async getData(){const sheetData=super.getData();return sheetData.hasOwner=!0===this.item.isEmbedded,sheetData.isKeeper=game.user.isGM,sheetData.isOwner=this.item.isOwner,sheetData.enrichedDescriptionValue=await TextEditor.enrichHTML(sheetData.data.system.description.value,{async:!0,secrets:sheetData.editable}),sheetData.enrichedDescriptionKeeper=await TextEditor.enrichHTML(sheetData.data.system.description.keeper,{async:!0,secrets:sheetData.editable}),sheetData.enrichedDescriptionAlternativeNames=await TextEditor.enrichHTML(sheetData.data.system.description.alternativeNames,{async:!0,secrets:sheetData.editable}),sheetData}activateListeners(html){super.activateListeners(html),html.find(".option").click((event=>this.modifyType(event))),html.find("#cast-spell").click((event=>{event.preventDefault(),this.item.cast(!1)})),html.find("#cast-spell-hidden").click((event=>{event.preventDefault(),this.item.cast(!0)}))}modifyType(event){event.preventDefault(),event.stopPropagation();return $(event.currentTarget).prev().trigger("click")}}class CoC7StatusSheet extends foundry.appv1.sheets.ItemSheet{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{classes:["coc7","sheet","status"],template:"systems/CoC7/templates/items/status.html",width:525,height:480,scrollY:[".tab.description"],tabs:[{navSelector:".sheet-navigation",contentSelector:".sheet-body",initial:"description"}]})}activateListeners(html){super.activateListeners(html),html.find(".effect-control").click((ev=>CoC7ActiveEffect.onManageActiveEffect(ev,this.item)))}_getHeaderButtons(){const headerButtons=super._getHeaderButtons();return addCoCIDSheetHeaderButton(headerButtons,this),headerButtons}async getData(){const sheetData=super.getData();sheetData.effects=CoC7ActiveEffect.prepareActiveEffectCategories(this.item.effects,{status:!1}),sheetData.itemProperties=[];for(const[key,value]of Object.entries(this.item.system.type))value&&sheetData.itemProperties.push(COC7.statusType[key]?COC7.statusType[key]:null);return sheetData.enrichedDescriptionValue=await TextEditor.enrichHTML(sheetData.data.system.description.value,{async:!0,secrets:sheetData.editable}),sheetData.enrichedDescriptionNotes=await TextEditor.enrichHTML(sheetData.data.system.description.notes,{async:!0,secrets:sheetData.editable}),sheetData.enrichedDescriptionKeeper=await TextEditor.enrichHTML(sheetData.data.system.description.keeper,{async:!0,secrets:sheetData.editable}),sheetData.isKeeper=game.user.isGM,sheetData}}class CoC7TalentSheet extends foundry.appv1.sheets.ItemSheet{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{classes:["coc7","sheet","talent"],template:"systems/CoC7/templates/items/talent.html",width:525,height:480,scrollY:[".tab.description"],tabs:[{navSelector:".sheet-navigation",contentSelector:".sheet-body",initial:"description"}]})}_getHeaderButtons(){const headerButtons=super._getHeaderButtons();return addCoCIDSheetHeaderButton(headerButtons,this),headerButtons}async getData(){const sheetData=super.getData();sheetData.itemProperties=[];for(const[key,value]of Object.entries(this.item.system.type))value&&sheetData.itemProperties.push(COC7.talentType[key]?COC7.talentType[key]:null);return sheetData.enrichedDescriptionValue=await TextEditor.enrichHTML(sheetData.data.system.description.value,{async:!0,secrets:sheetData.editable}),sheetData.enrichedDescriptionNotes=await TextEditor.enrichHTML(sheetData.data.system.description.notes,{async:!0,secrets:sheetData.editable}),sheetData.enrichedDescriptionKeeper=await TextEditor.enrichHTML(sheetData.data.system.description.keeper,{async:!0,secrets:sheetData.editable}),sheetData.isKeeper=game.user.isGM,sheetData}}class CoC7VehicleSheet extends CoC7ActorSheet{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{classes:["coc7","sheetV2","actor","item","vehicle"],width:555,height:420,resizable:!0,template:"systems/CoC7/templates/actors/vehicle.html",dragDrop:[{dragSelector:".actor",dropSelector:".dropZone"}],tabs:[{navSelector:".sheet-nav",contentSelector:".sheet-body",initial:"description"}]})}async getData(){const sheetData=await super.getData();sheetData.properties=[],this.actor.system.properties.armed&&sheetData.properties.push(game.i18n.localize("CoC7.ArmedVehicle"));const expanded=this.actor.getFlag("CoC7","expanded");return sheetData.expanded=void 0===expanded||expanded,sheetData.expanded?sheetData.options.height=420:sheetData.options.height="auto",sheetData.enrichedDescriptionValue=await TextEditor.enrichHTML(sheetData.data.system.description.value,{async:!0,secrets:sheetData.editable}),sheetData.enrichedDescriptionNotes=await TextEditor.enrichHTML(sheetData.data.system.description.notes,{async:!0,secrets:sheetData.editable}),sheetData}activateListeners(html){super.activateListeners(html),html.find(".add-armor").click((async()=>await this._onAddArmor())),html.find(".remove-armor").click((async event=>await this._onRemoveArmor(event))),html.find(".expand-button").click(this._onToggleExpand.bind(this))}async _onToggleExpand(){const expanded=this.actor.getFlag("CoC7","expanded");expanded?(this.oldSize=this.position.height,this.position.height="auto"):this.position.height=this.oldSize||420,await this.actor.setFlag("CoC7","expanded",!expanded)}async _onAddArmor(){const locations=foundry.utils.duplicate(this.actor.system.attribs.armor.locations||[]);locations.push({name:null,value:null}),await this.actor.update({"system.attribs.armor.locations":locations})}async _onRemoveArmor(event){const index=event.currentTarget.closest(".armor").dataset.index,locations=foundry.utils.duplicate(this.actor.system.attribs.armor.locations||null);locations&&(locations.splice(index,1),await this.actor.update({"system.attribs.armor.locations":locations}))}onCloseSheet(){super.onCloseSheet()}_updateObject(event,formData){const system=foundry.utils.expandObject(formData)?.system;system.attribs.armor.locations&&(formData["system.attribs.armor.locations"]=Object.values(system.attribs.armor.locations||[])),super._updateObject(event,formData)}}class CoC7WeaponSheet extends foundry.appv1.sheets.ItemSheet{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{classes:["coc7","sheet","item"],width:545,height:480,tabs:[{navSelector:".sheet-tabs",contentSelector:".sheet-body",initial:"skills"}]})}get template(){return"systems/CoC7/templates/items/weapon-sheet.html"}_getHeaderButtons(){const headerButtons=super._getHeaderButtons();return addCoCIDSheetHeaderButton(headerButtons,this),headerButtons}async getData(){const sheetData=super.getData();sheetData.hasOwner=!0===this.item.isEmbedded,sheetData.hasOwner&&(sheetData.weaponSkillGroups=this.actor.weaponSkillGroups(this.item.system.properties.rngd)),sheetData._properties=[];for(const[key,value]of Object.entries(COC7.weaponProperties))sheetData._properties.push({id:key,name:value,isEnabled:!0===this.item.system.properties[key]});sheetData._eras=[];for(const[key,value]of Object.entries(COC7.eras))sheetData._eras.push({price:this.item.system.price[key]??0,id:key,name:game.i18n.localize(value),isEnabled:!0===(this.item.flags?.CoC7?.cocidFlag?.eras??{})[key]});return sheetData._eras.sort(CoC7Utilities.sortByNameKey),sheetData.usesAlternateSkill=!0===this.item.system.properties.auto||!0===this.item.system.properties.brst||!0===this.item.system.properties.thrown,sheetData.enrichedDescriptionValue=await TextEditor.enrichHTML(sheetData.data.system.description.value,{async:!0,secrets:sheetData.editable}),sheetData.enrichedDescriptionSpecial=await TextEditor.enrichHTML(sheetData.data.system.description.special,{async:!0,secrets:sheetData.editable}),sheetData.enrichedDescriptionKeeper=await TextEditor.enrichHTML(sheetData.data.system.description.keeper,{async:!0,secrets:sheetData.editable}),sheetData.isKeeper=game.user.isGM,sheetData}activateListeners(html){super.activateListeners(html),this.options.editable&&(html.find(".toggle-switch").click(this._onClickToggle.bind(this)),html.find(".weapon-property").click(this._onPropertyClick.bind(this)))}async _onClickToggle(event){event.preventDefault();const propertyId=event.currentTarget.closest(".toggle-switch").dataset.property;await this.item.toggleProperty(propertyId,isCtrlKey(event))}async _onPropertyClick(event){event.preventDefault();const propertyId=event.currentTarget.closest(".weapon-property").dataset.property;await this.item.toggleProperty(propertyId)}}class CoC7Combat{static renderCombatTracker(app,html,data){let combatants,aButton;try{combatants=html.querySelectorAll(".combatant"),aButton=document.createElement("button"),aButton.setAttribute("type","button"),aButton.classList.add("inline-control","combatant-control","icon","game-icon","game-icon-revolver"),aButton.dataset.control="drawGun"}catch(e){combatants=html[0].querySelectorAll(".combatant"),aButton=document.createElement("a"),aButton.classList.add("combatant-control"),aButton.dataset.control="drawGun",aButton.innerHTML='<i class="game-icon game-icon-revolver"></i>'}if(combatants)for(const el of combatants){const combId=el.getAttribute("data-combatant-id"),combatantControlsDiv=el.querySelector(".combatant-controls"),combatant=data.combat.combatants.get(combId),theButton=aButton.cloneNode(!0);if(combatant.getFlag("CoC7","hasGun")?(theButton.setAttribute("title",game.i18n.localize("CoC7.PutGunAway")),theButton.classList.add("active")):theButton.setAttribute("title",game.i18n.localize("CoC7.DrawGun")),combatantControlsDiv.prepend(theButton),theButton.onclick=CoC7Combat._onToggleGun,"optional"===game.settings.get("CoC7","initiativeRule")&&game.settings.get("CoC7","displayInitAsText")){if(combatant.initiative){const tokenInitiative=el.querySelector(".token-initiative");let initiativeTest=tokenInitiative.querySelector(".initiative");initiativeTest||(initiativeTest=tokenInitiative.querySelector("span"));const roll=100*combatant.initiative-100*Math.floor(combatant.initiative);switch(Math.floor(combatant.initiative)){case CoC7Check.successLevel.fumble:tokenInitiative.classList.add("fumble"),initiativeTest.innerText=game.i18n.localize("CoC7.Fumble"),initiativeTest.title=roll;break;case CoC7Check.successLevel.failure:tokenInitiative.classList.add("failure"),initiativeTest.innerText=game.i18n.localize("CoC7.Failure"),initiativeTest.title=roll;break;case CoC7Check.successLevel.regular:tokenInitiative.classList.add("regular-success"),initiativeTest.innerText=game.i18n.localize("CoC7.RollDifficultyRegular"),initiativeTest.title=roll;break;case CoC7Check.successLevel.hard:tokenInitiative.classList.add("hard-success"),initiativeTest.innerText=game.i18n.localize("CoC7.RollDifficultyHard"),initiativeTest.title=roll;break;case CoC7Check.successLevel.extreme:tokenInitiative.classList.add("extreme-success"),initiativeTest.innerText=game.i18n.localize("CoC7.RollDifficultyExtreme"),initiativeTest.title=roll;break;case CoC7Check.successLevel.critical:tokenInitiative.classList.add("critical"),initiativeTest.innerText=game.i18n.localize("CoC7.RollDifficultyCritical"),initiativeTest.title=roll}}}else if(combatant.initiative<0){let span,h4=el.querySelector(".token-name").querySelector("h4");h4?span=el.querySelector("span.initiative"):(h4=el.querySelector(".token-name").querySelector(".name"),span=el.querySelector("div.token-initiative span")),h4.style.fontWeight="900",h4.style.textShadow="1px 1px 4px darkred",span&&(span.style.fontWeight="900",span.style.textShadow="1px 1px 4px darkred"),el.style.color="darkred",el.style.background="black",el.style.fontWeight="900"}}}static async _onToggleGun(event){event.preventDefault(),event.stopPropagation();const li=event.currentTarget.closest(".combatant"),c=await game.combat.combatants.get(li.dataset.combatantId);c.actor.isOwner&&(c.getFlag("CoC7","hasGun")?await c.setFlag("CoC7","hasGun",!1):await c.setFlag("CoC7","hasGun",!0));const newInit=await c.actor.rollInitiative(!!c.getFlag("CoC7","hasGun"));c.getFlag("CoC7","hasGun")?c.initiative<newInit&&game.combat.setInitiative(c.id,newInit):game.combat.setInitiative(c.id,newInit)}}async function rollInitiative(ids,{formula=null,updateTurn=!0,messageOptions={}}={}){const updates=[];for(const[,id]of ids.entries()){const combatant=this.combatants.get(id),roll=await combatant.actor.rollInitiative(!!combatant.getFlag("CoC7","hasGun"));updates.push({_id:id,initiative:roll})}return updates.length?(await this.updateEmbeddedDocuments("Combatant",updates),this):this}let oldSearchFilter;function _onSearchFilterV12(event,query,rgx,html){if("Item"===this.collection.documentName){void 0===html&&(query=this.element[0].querySelector(this.options.filters[0].inputSelector).value,rgx=new RegExp(RegExp.escape(query),"i"),html=this.element[0].querySelector(this.options.filters[0].contentSelector));const typeSelect=this.element[0].querySelector("select[name=coc7type]"),eraSelect=this.element[0].querySelector("select[name=coc7era]"),type=typeSelect.value;let era="";switch(type){case"occupation":case"setup":case"skill":case"weapon":eraSelect.parentElement.style.display="",era=eraSelect.value;break;default:eraSelect.parentElement.style.display="hide"}const isNameSearch=!!query,isSearch=isNameSearch||""!==type||""!==era,entryIds=new Set,folderIds=new Set,autoExpandFolderIds=new Set;if(isSearch){const includeFolder=(folder,autoExpand=!0)=>{if(!folder)return;if("string"==typeof folder&&(folder=this.collection.folders.get(folder)),!folder)return;const folderId=folder._id;folderIds.has(folderId)?autoExpand&&!autoExpandFolderIds.has(folderId)&&autoExpandFolderIds.add(folderId):(folderIds.add(folderId),autoExpand&&autoExpandFolderIds.add(folderId),folder.folder&&includeFolder(folder.folder))};isNameSearch&&this._matchSearchFolders(rgx,includeFolder),function(app,isNameSearch,query,type,era,entryIds,folderIds,includeFolder){const entries=app.collection.index??app.collection.contents,matchedFolderIds=new Set(folderIds);for(const entry of entries){const entryId=app._getEntryId(entry);if(matchedFolderIds.has(entry.folder?._id??entry.folder))entryIds.add(entryId);else{const matchName=!isNameSearch||query.test(SearchFilter.cleanQuery(app._getEntryName(entry))),matchType=""===type||type===entry.type,eras=Object.keys(entry.flags?.CoC7?.cocidFlag?.eras??{}),matchEras=""===era||0===eras.length||eras.includes(era);matchName&&matchType&&matchEras&&(entryIds.add(entryId),includeFolder(entry.folder))}}}(this,isNameSearch,rgx,type,era,entryIds,folderIds,includeFolder)}for(const el of html.querySelectorAll(".directory-item"))if(!el.classList.contains("hidden"))if(el.classList.contains("folder")){const match=isSearch&&folderIds.has(el.dataset.folderId);el.style.display=!isSearch||match?"flex":"none",autoExpandFolderIds.has(el.dataset.folderId)?isSearch&&match&&el.classList.remove("collapsed"):el.classList.toggle("collapsed",!game.folders._expanded[el.dataset.uuid])}else el.style.display=!isSearch||entryIds.has(el.dataset.entryId)?"flex":"none"}else oldSearchFilter.call(this,event,query,rgx,html)}function _onSearchFilter(event,query,rgx,html){if("Item"===this.collection.documentName){const typeSelect=this.element.querySelector("select[name=coc7type]"),eraSelect=this.element.querySelector("select[name=coc7era]"),type=typeSelect.value;let era="";switch(type){case"occupation":case"setup":case"skill":case"weapon":eraSelect.parentElement.style.display="",era=eraSelect.value;break;default:eraSelect.parentElement.style.display="hide"}const isNameSearch=!!query,isSearch=isNameSearch||""!==type||""!==era,entryIds=new Set,folderIds=new Set,autoExpandIds=new Set,options={};if(isNameSearch&&this._matchSearchFolders(rgx,folderIds,autoExpandIds,options),isSearch&&(this._matchSearchEntries(rgx,entryIds,folderIds,autoExpandIds,options),entryIds.size)){const entries=this.collection.index??this.collection.contents;entryIds.forEach((entryId=>{const entry=entries.get(entryId);(""!==type&&entry.type!==type||""!==era&&!entry.flags?.CoC7?.cocidFlag?.eras?.[era])&&entryIds.delete(entryId)}))}for(const el of html.querySelectorAll(".directory-item"))if(!el.hidden)if(el.classList.contains("folder")){const{folderId,uuid}=el.dataset,match=folderIds.has(folderId);el.style.display=!query||match?"flex":"none",autoExpandIds.has(folderId)?isNameSearch&&match&&el.classList.add("expanded"):el.classList.toggle("expanded",uuid in game.folders._expanded)}else this._onMatchSearchEntry(query,entryIds,el,options)}else oldSearchFilter.call(this,event,query,rgx,html)}class CoCID{static init(){CONFIG.Actor.compendiumIndexFields.push("flags.CoC7.cocidFlag"),CONFIG.Item.compendiumIndexFields.push("flags.CoC7.cocidFlag"),CONFIG.Item.compendiumIndexFields.push("system.base"),CONFIG.Item.compendiumIndexFields.push("system.properties"),CONFIG.JournalEntry.compendiumIndexFields.push("flags.CoC7.cocidFlag"),CONFIG.Macro.compendiumIndexFields.push("flags.CoC7.cocidFlag"),CONFIG.Playlist.compendiumIndexFields.push("flags.CoC7.cocidFlag"),CONFIG.RollTable.compendiumIndexFields.push("flags.CoC7.cocidFlag"),CONFIG.Scene.compendiumIndexFields.push("flags.CoC7.cocidFlag"),game.system.api={cocid:CoCID}}static regExKey(){return new RegExp("^("+Object.keys(CoCID.gamePropertyLookup).join("|")+")\\.(.*?)\\.(.+)$")}static getPrefix(document){for(const type in CoCID.documentNameLookup)if(document instanceof CoCID.documentNameLookup[type])return type+"."+(document.type??"")+".";return""}static guessId(document){return CoCID.getPrefix(document)+CoC7Utilities.toKebabCase(document.name)}static guessGroupFromKey(id){if(id){const key=id.replace(/([^\\.-]+)$/,"");if("-"===key.substr(-1))return key}return""}static guessGroupFromDocument(document){return CoCID.guessGroupFromKey(document.flags?.CoC7?.cocidFlag?.id)}static eraText(era){return!1===era?game.i18n.localize("CoC7.Any"):(!0===era&&(era=game.settings.get("CoC7","worldEra")),game.i18n.format(COC7.eras[era]??"CoC7.CoCIDFlag.error.unknown-era",{era}))}static async expandItemArray({itemList,lang=game.i18n.lang,era=!0,langFallback=!0,showLoading=!1}={}){let items=[];const cocids=itemList.filter((it=>"string"==typeof it));if(items=itemList.filter((it=>"string"!=typeof it)),cocids.length){const found=await CoCID.fromCoCIDRegexBest({cocidRegExp:CoCID.makeGroupRegEx(cocids),type:"i",lang,era,langFallback,showLoading}),all=[];for(const cocid of cocids){const item=found.find((i=>i.flags.CoC7.cocidFlag.id===cocid));item&&all.push(item)}if(all.length<cocids.length){const notmissing=[];for(const doc of all)notmissing.push(doc.flags.CoC7.cocidFlag.id);!0===era&&(era=game.settings.get("CoC7","worldEra")),ui.notifications.warn(game.i18n.format("CoC7.CoCIDFlag.error.documents-not-found",{cocids:cocids.filter((x=>!notmissing.includes(x))).join(", "),lang,era:CoCID.eraText(era)}))}items=items.concat(all)}return items}static findCocIdInList(cocid,list){let itemName="";const CoCIDKeys=Object.assign(foundry.utils.flattenObject(game.i18n._fallback.CoC7?.CoCIDFlag?.keys??{}),foundry.utils.flattenObject(game.i18n.translations.CoC7?.CoCIDFlag?.keys??{}));return void 0!==CoCIDKeys[cocid]&&(itemName=CoCIDKeys[cocid]),(void 0===list.filter?Object.values(list):list).filter((i=>i.flags?.CoC7?.cocidFlag?.id===cocid||""!==itemName&&itemName===i.name))}static makeGroupRegEx(cocids){if("string"==typeof cocids)cocids=[cocids];else if(void 0===cocids||"function"!=typeof cocids.filter)return;const splits={},rgx=CoCID.regExKey();for(const i of cocids){const key=i.match(rgx);key&&(void 0===splits[key[1]]&&(splits[key[1]]={}),void 0===splits[key[1]][key[2]]&&(splits[key[1]][key[2]]=[]),splits[key[1]][key[2]].push(key[3]))}const regExParts=[];for(const t in splits){const row=[];for(const s in splits[t])splits[t][s].length>1?row.push(s+"\\.("+splits[t][s].join("|")+")"):row.push(s+"\\."+splits[t][s].join(""));row.length>1?regExParts.push(t+"\\.("+row.join("|")+")"):regExParts.push(t+"\\."+row.join(""))}return regExParts.length>1?new RegExp("^("+regExParts.join("|")+")$"):new RegExp("^"+regExParts.join("")+"$")}static async fromCoCIDRegexAll({cocidRegExp,type,lang=game.i18n.lang,era=!1,scope="all",langFallback=!0,showLoading=!1}={}){let candidates=await CoCID.fromCoCIDRegexAllMixed({cocidRegExp,type,lang,era,scope,langFallback,showLoading});return langFallback&&"en"!==lang&&(candidates=CoCID.filterByLanguage(candidates,lang)),candidates.sort(CoCID.compareCoCIDPrio),await CoCID.onlyDocuments(candidates,showLoading)}static async fromCoCIDAll({cocid,lang=game.i18n.lang,era=!1,scope="all",langFallback=!0,showLoading=!1}={}){if(!cocid||"string"!=typeof cocid)return[];const parts=cocid.match(CoCID.regExKey());return parts?(""===lang&&(lang=game.i18n.lang),CoCID.fromCoCIDRegexAll({cocidRegExp:new RegExp("^"+CoC7Utilities.quoteRegExp(cocid)+"$"),type:parts[1],lang,era,scope,langFallback,showLoading})):[]}static async fromCoCIDRegexBest({cocidRegExp,type,lang=game.i18n.lang,era=!0,langFallback=!0,showLoading=!1}={}){if(!1===era)return ui.notifications.error(game.i18n.format("CoC7.CoCIDFlag.error.unknown-era",{era:game.i18n.localize("CoC7.Any")})),[];let candidates=await this.fromCoCIDRegexAllMixed({cocidRegExp,type,lang,era,scope:"all",langFallback,showLoading});langFallback&&"en"!==lang&&(candidates=CoCID.filterByLanguage(candidates,lang)),candidates.sort(CoCID.compareCoCIDPrio);const ids={};for(const candidate of candidates)Object.prototype.hasOwnProperty.call(ids,candidate.flags.CoC7.cocidFlag.id)||(ids[candidate.flags.CoC7.cocidFlag.id]=candidate);return await CoCID.onlyDocuments(Object.values(ids),showLoading)}static fromCoCID(cocid,lang=game.i18n.lang,era=!0,langFallback=!0){return!1===era?(ui.notifications.error(game.i18n.format("CoC7.CoCIDFlag.error.unknown-era",{era:game.i18n.localize("CoC7.Any")})),[]):CoCID.fromCoCIDBest({cocid,lang,era,langFallback})}static fromCoCIDBest({cocid,lang=game.i18n.lang,era=!0,langFallback=!0,showLoading=!1}={}){if(!cocid||"string"!=typeof cocid)return[];if(!1===era)return ui.notifications.error(game.i18n.format("CoC7.CoCIDFlag.error.unknown-era",{era:game.i18n.localize("CoC7.Any")})),[];const type=cocid.split(".")[0],cocidRegExp=new RegExp("^"+CoC7Utilities.quoteRegExp(cocid)+"$");return CoCID.fromCoCIDRegexBest({cocidRegExp,type,lang,era,langFallback,showLoading})}static async fromCoCIDRegexAllMixed({cocidRegExp,type,lang=game.i18n.lang,era=!1,scope="all",langFallback=!0,showLoading=!1}={}){if(!cocidRegExp)return[];let results=[],count=0;return showLoading&&(["all","world"].includes(scope)&&count++,["all","compendiums"].includes(scope)&&(count+=game.packs.size)),["all","world"].includes(scope)&&(results=results.concat(await CoCID.docsFromWorld({cocidRegExp,type,lang,era,langFallback,progressBar:count}))),["all","compendiums"].includes(scope)&&(results=results.concat(await CoCID.indexesFromCompendia({cocidRegExp,type,lang,era,langFallback,progressBar:count}))),showLoading&&SceneNavigation.displayProgressBar({label:game.i18n.localize("SETUP.PackagesLoading"),pct:100}),results}static async docsFromWorld({cocidRegExp,type,lang=game.i18n.lang,era=!1,langFallback=!0,progressBar=0}={}){if(!cocidRegExp)return[];""===lang&&(lang=game.i18n.lang),!0===era&&(era=game.settings.get("CoC7","worldEra")),progressBar>0&&SceneNavigation.displayProgressBar({label:game.i18n.localize("SETUP.PackagesLoading"),pct:Math.floor(100/progressBar)});const gameProperty=CoCID.getGameProperty(`${type}..`),candidateDocuments=game[gameProperty]?.filter((d=>{const cocidFlag=d.getFlag("CoC7","cocidFlag");if(void 0===cocidFlag)return!1;const eras=cocidFlag.eras??[],matchingEras=!1===era||0===Object.entries(eras).length||Object.prototype.hasOwnProperty.call(eras,era)&&eras[era];return cocidRegExp.test(cocidFlag.id)&&[lang,langFallback?"en":"-"].includes(cocidFlag.lang)&&matchingEras}));return void 0===candidateDocuments?[]:candidateDocuments}static async indexesFromCompendia({cocidRegExp,type,lang=game.i18n.lang,era=!1,langFallback=!0,progressBar=0}){if(!cocidRegExp)return[];""===lang&&(lang=game.i18n.lang),!0===era&&(era=game.settings.get("CoC7","worldEra"));const documentType=CoCID.getDocumentType(type).name;let indexDocuments=[],count=1;for(const pack of game.packs)progressBar>0&&(SceneNavigation.displayProgressBar({label:game.i18n.localize("SETUP.PackagesLoading"),pct:Math.floor(100*count/progressBar)}),count++),pack.documentName===documentType&&(pack.indexed||await pack.getIndex(),indexDocuments=indexDocuments.concat(pack.index.filter((i=>{if("string"!=typeof i.flags?.CoC7?.cocidFlag?.id)return!1;const eras=i.flags.CoC7.cocidFlag.eras??{},matchingEras=!1===era||0===Object.entries(eras).length||Object.prototype.hasOwnProperty.call(eras,era)&&eras[era];return cocidRegExp.test(i.flags.CoC7.cocidFlag.id)&&[lang,langFallback?"en":"-"].includes(i.flags.CoC7.cocidFlag.lang)&&matchingEras}))));return indexDocuments}static compareCoCIDPrio(a,b){const ap=parseInt(a.flags.CoC7.cocidFlag.priority,10),bp=parseInt(b.flags.CoC7.cocidFlag.priority,10);if(ap===bp){const ao=a instanceof foundry.abstract.DataModel;return ao===b instanceof foundry.abstract.DataModel?0:ao?-1:1}return bp-ap}static getGameProperty(cocid){const type=cocid.split(".")[0],gameProperty=CoCID.gamePropertyLookup[type];if(!gameProperty)throw ui.notifications.warn(game.i18n.format("CoC7.CoCIDFlag.error.incorrect.type")),console.log("CoC7 | ",cocid),new Error;return gameProperty}static get gamePropertyLookup(){return{a:"actors",c:"cards",i:"items",je:"journal",m:"macros",p:"playlists",rt:"tables",s:"scenes"}}static getDocumentType(cocid){const type=cocid.split(".")[0],documentType=CoCID.documentNameLookup[type];if(!documentType)throw ui.notifications.warn(game.i18n.format("CoC7.CoCIDFlag.error.incorrect.type")),console.log("CoC7 | ",cocid),new Error;return documentType}static get documentNameLookup(){return{a:Actor,c:Card,i:Item,je:JournalEntry,m:Macro,p:Playlist,rt:RollTable,s:Scene}}static async onlyDocuments(candidates,showLoading){const len=candidates.length;if(len>0){let count=0,progressBar=!1;showLoading&&foundry.utils.isNewerVersion(game.version,"13")&&(progressBar=ui.notifications.info("SETUP.PackagesLoading",{localize:!0,progress:!0}));for(const offset in candidates)showLoading&&(progressBar?(progressBar.update({pct:count/len}),count++):(SceneNavigation.displayProgressBar({label:game.i18n.localize("SETUP.PackagesLoading"),pct:Math.floor(count/len)}),count+=100)),candidates[offset]instanceof foundry.abstract.DataModel||(candidates[offset]=await fromUuid(candidates[offset].uuid));showLoading&&(progressBar?progressBar.update({pct:1}):SceneNavigation.displayProgressBar({label:game.i18n.localize("SETUP.PackagesLoading"),pct:100}))}return candidates}static filterByLanguage(indexes,lang){const ids=indexes.reduce(((c,i)=>(c[i.flags.CoC7.cocidFlag.id]=c[i.flags.CoC7.cocidFlag.id]||i.flags.CoC7.cocidFlag.lang===lang,c)),{});return indexes.filter((i=>"en"!==i.flags.CoC7.cocidFlag.lang||!ids[i.flags.CoC7.cocidFlag.id]))}static async documentsFromWorld({cocidRegExp,type,lang=game.i18n.lang,era=!1,langFallback=!0,progressBar=0}={}){console.warn("Calling documentsFromWorld directly is depreciated");let documents=await CoCID.docsFromWorld({cocidRegExp,type,lang,era,langFallback,progressBar});return langFallback&&"en"!==lang&&(documents=CoCID.filterByLanguage(documents,lang)),documents.sort(CoCID.compareCoCIDPrio),documents}static async documentsFromCompendia({cocidRegExp,type,lang=game.i18n.lang,era=!1,langFallback=!0,progressBar=0}){console.warn("Calling documentsFromCompendia directly is depreciated");let indexes=await CoCID.indexesFromCompendia({cocidRegExp,type,lang,era,langFallback,progressBar});return langFallback&&"en"!==lang&&(indexes=CoCID.filterByLanguage(indexes,lang)),indexes.sort(CoCID.compareCoCIDPrio),await CoCID.onlyDocuments(indexes,progressBar>0)}}function dice_so_nice_ready_last(dice3d){if("function"==typeof dice3d.DiceFactory.systems.forEach)dice3d.DiceFactory.systems.forEach(((systemData,systemKey)=>{const d100=systemData.dice.get("d100");if(void 0!==d100){if(void 0===systemData.dice.get("dt")){const diceDecader=Object.assign(Object.create(Object.getPrototypeOf(d100)),d100);diceDecader.type="dt",systemData.dice.set(diceDecader.type,diceDecader)}if(void 0===systemData.dice.get("do")){const diceDecader=Object.assign(Object.create(Object.getPrototypeOf(d100)),d100);diceDecader.type="do",systemData.dice.set(diceDecader.type,diceDecader)}}}));else for(const system in dice3d.DiceFactory.systems){const d100=dice3d.DiceFactory.systems[system].dice.find((d=>"d100"===d.type));if(void 0!==d100){if(void 0===dice3d.DiceFactory.systems[system].dice.find((d=>"dt"===d.type))){const diceDecader=Object.assign(Object.create(Object.getPrototypeOf(d100)),d100);diceDecader.type="dt",dice3d.DiceFactory.systems[system].dice.push(diceDecader)}if(void 0===dice3d.DiceFactory.systems[system].dice.find((d=>"do"===d.type))){const diceDecader=Object.assign(Object.create(Object.getPrototypeOf(d100)),d100);diceDecader.type="do",dice3d.DiceFactory.systems[system].dice.push(diceDecader)}}}}const{RegionBehaviorType}=foundry.data.regionBehaviors??{},RegionBehaviorTypeClass=void 0===RegionBehaviorType?class{}:RegionBehaviorType;class CoC7ClickableEvents extends RegionBehaviorTypeClass{static initSelf(){if(!foundry.utils.isNewerVersion(game.version,"12"))return;Object.assign(CONFIG.RegionBehavior.dataModels,{coc7ClickableEvents:CoC7ClickableEvents}),Object.assign(CONFIG.RegionBehavior.typeIcons,{coc7ClickableEvents:"fa-solid fa-computer-mouse"}),DocumentSheetConfig.registerSheet(RegionBehavior,"CoC7",foundry.applications.sheets.RegionBehaviorConfig,{types:["coc7ClickableEvents"],makeDefault:!0});const polyfillTokenLayer=foundry.canvas?.layers?.TokenLayer??TokenLayer,oldOnClickLeft=polyfillTokenLayer.prototype._onClickLeft;polyfillTokenLayer.prototype._onClickLeft=function(event){if(oldOnClickLeft.call(this,event),canvas.activeLayer instanceof polyfillTokenLayer){const destination=canvas.activeLayer.toLocal(event);for(const region of canvas.scene.regions.contents)region.behaviors.filter((b=>!b.disabled)).find((b=>b.system instanceof CoC7ClickableEvents))&&region.object.polygonTree.testPoint(destination)&&region.behaviors.filter((b=>!b.disabled)).map((async b=>{!0===await b.system._handleMouseOverEvent()&&await b.system._handleLeftClickEvent()}))}};const oldOnClickRight=polyfillTokenLayer.prototype._onClickRight;polyfillTokenLayer.prototype._onClickRight=function(event){if(oldOnClickRight.call(this,event),canvas.activeLayer instanceof polyfillTokenLayer){const destination=canvas.activeLayer.toLocal(event);for(const region of canvas.scene.regions.contents)region.behaviors.filter((b=>!b.disabled)).find((b=>b.system instanceof CoC7ClickableEvents))&&region.object.polygonTree.testPoint(destination)&&region.behaviors.filter((b=>!b.disabled)).map((async b=>{!0===await b.system._handleMouseOverEvent()&&await b.system._handleRightClickEvent()}))}},document.body.addEventListener("mousemove",(async function(event){if(canvas.activeLayer instanceof polyfillTokenLayer){const pointer=canvas?.app?.renderer?.events?.pointer;if(!pointer)return;const destination=canvas.activeLayer.toLocal(event);let setPointer=!1;for(const region of canvas.scene.regions.contents)region.behaviors.filter((b=>!b.disabled)).find((b=>b.system instanceof CoC7ClickableEvents))&&region.object.polygonTree.testPoint(destination)&&(setPointer=await region.behaviors.filter((b=>!b.disabled)).reduce((async(c,b)=>{const r=await b.system._handleMouseOverEvent();return!1!==r&&!0!==r&&console.error(b.uuid+" did not return a boolean"),c=c||r}),!1));document.getElementById("board").style.cursor=setPointer?"pointer":""}}))}static defineSchema(){return{mouseOver:new foundry.data.fields.JavaScriptField({async:!0,gmOnly:!0,initial:"return false",label:"CoC7.ClickableEvents.MouseOver.Title",hint:"CoC7.ClickableEvents.MouseOver.Hint"}),leftClick:new foundry.data.fields.JavaScriptField({async:!0,gmOnly:!0,label:"CoC7.ClickableEvents.LeftClick.Title"}),rightClick:new foundry.data.fields.JavaScriptField({async:!0,gmOnly:!0,label:"CoC7.ClickableEvents.RightClick.Title"})}}async _handleMouseOverEvent(){try{const fn=new foundry.utils.AsyncFunction("scene","region","behavior",`{${this.mouseOver}\n}`);return await fn.call(globalThis,this.scene,this.region,this.behavior)}catch(err){console.error(err)}}async _handleLeftClickEvent(){try{const fn=new foundry.utils.AsyncFunction("scene","region","behavior",`{${this.leftClick}\n}`);return await fn.call(globalThis,this.scene,this.region,this.behavior)}catch(err){console.error(err)}}async _handleRightClickEvent(){try{const fn=new foundry.utils.AsyncFunction("scene","region","behavior",`{${this.rightClick}\n}`);return await fn.call(globalThis,this.scene,this.region,this.behavior)}catch(err){console.error(err)}}static async ClickRegionLeftUuid(docUuid){const doc=await fromUuid(docUuid);doc?doc.behaviors.filter((b=>!b.disabled)).map((async b=>{!0===await b.system._handleMouseOverEvent()&&await b.system._handleLeftClickEvent()})):console.error("journalPageUuids "+docUuid+" not loaded")}static async ClickRegionRightUuid(docUuid){const doc=await fromUuid(docUuid);doc?doc.behaviors.filter((b=>!b.disabled)).map((async b=>{!0===await b.system._handleMouseOverEvent()&&await b.system._handleRightClickEvent()})):console.error("journalPageUuids "+docUuid+" not loaded")}static async hasPermissionDocument(documentUuid){const doc=await fromUuid(documentUuid);return doc?.testUserPermission(game.user,CONST.DOCUMENT_OWNERSHIP_LEVELS.OBSERVER)??!1}static async InSceneRelativeTeleport(event,destinationRegion){if("tokenMoveIn"===event.name){const sourceTL=event.region.shapes.reduce(((c,p)=>{if(p instanceof foundry.data.PolygonShapeData)for(let i=0,im=p.points.length;i<im;i+=2)(!1===c[0]||p.points[i]<c[0])&&(c[0]=p.points[i]),(!1===c[1]||p.points[i+1]<c[1])&&(c[1]=p.points[i+1]);else if(p instanceof foundry.data.RectangleShapeData){const x=Math.min(p.x+p.width,p.x),y=Math.min(p.y+p.height,p.y);(!1===c[0]||x<c[0])&&(c[0]=x),(!1===c[1]||y<c[1])&&(c[1]=y)}return c}),[!1,!1]),destinationTL=(await fromUuid(destinationRegion)).shapes.reduce(((c,p)=>{if(p instanceof foundry.data.PolygonShapeData)for(let i=0,im=p.points.length;i<im;i+=2)(!1===c[0]||p.points[i]<c[0])&&(c[0]=p.points[i]),(!1===c[1]||p.points[i+1]<c[1])&&(c[1]=p.points[i+1]);else if(p instanceof foundry.data.RectangleShapeData){const x=Math.min(p.x+p.width,p.x),y=Math.min(p.y+p.height,p.y);(!1===c[0]||x<c[0])&&(c[0]=x),(!1===c[1]||y<c[1])&&(c[1]=y)}return c}),[!1,!1]),destinationX=event.data.destination.x-sourceTL[0]+destinationTL[0],destinationY=event.data.destination.y-sourceTL[1]+destinationTL[1];await event.data.token.object.stopAnimation(),event.data.token.update({x:destinationX,y:destinationY},{animate:!1})}}static async MapPinToggle(toggle,{journalPageUuids=[],noteUuids=[],permissionFalse=CONST.DOCUMENT_OWNERSHIP_LEVELS.NONE,permissionTrue=CONST.DOCUMENT_OWNERSHIP_LEVELS.OBSERVER}={}){game.socket.emit("system.CoC7",{type:"toggleMapNotes",toggle:!0}),game.settings.set("core",NotesLayer.TOGGLE_SETTING,!0);for(const docUuid of journalPageUuids){const doc=await fromUuid(docUuid);if(doc){let permission=permissionTrue;toggle||(permission=permissionFalse),await doc.update({"ownership.default":permission})}else console.error("journalPageUuids "+docUuid+" not loaded")}for(const docUuid of noteUuids){const doc=await fromUuid(docUuid);if(doc){let texture="systems/CoC7/assets/art/map-pin.svg";toggle||(texture="systems/CoC7/assets/art/map-pin-dark.svg"),await doc.update({"texture.src":texture})}else console.error("noteUuids "+docUuid+" not loaded")}}static async openDocument(documentUuid,pageId=null,anchor=null){const doc=await fromUuid(documentUuid);doc?.testUserPermission(game.user,CONST.DOCUMENT_OWNERSHIP_LEVELS.OBSERVER)&&(pageId?doc.pages.get(pageId)?.testUserPermission(game.user,CONST.DOCUMENT_OWNERSHIP_LEVELS.OBSERVER)&&doc.sheet.render(!0,{pageId,anchor}):doc.sheet.render(!0))}static async toggleTileJournalPages(active,tileUuids,journalUuids,pageUuids,{pagePermission=CONST.DOCUMENT_OWNERSHIP_LEVELS.OWNER}={}){for(const docUuid of tileUuids){const doc=await fromUuid(docUuid);doc?await doc.update({hidden:!active}):console.error("Tile "+docUuid+" not loaded")}const permission=active?pagePermission:CONST.DOCUMENT_OWNERSHIP_LEVELS.NONE;for(const docUuid of pageUuids){const doc=await fromUuid(docUuid);doc?await doc.update({"ownership.default":permission}):console.error("Journal Page "+docUuid+" not loaded")}for(const docUuid of journalUuids){const doc=await fromUuid(docUuid);doc?0!==pageUuids.length&&permission!==pagePermission&&0!==doc.pages.contents.filter((d=>d.ownership.default===pagePermission)).length||await doc.update({"ownership.default":active?CONST.DOCUMENT_OWNERSHIP_LEVELS.OWNER:CONST.DOCUMENT_OWNERSHIP_LEVELS.NONE}):console.error("Journal "+docUuid+" not loaded")}}static async toScene(sceneUuid){const doc=await fromUuid(sceneUuid);doc?setTimeout((()=>{doc.view()}),100):console.error("Scene "+sceneUuid+" not loaded")}}class CoC7SystemSocket{static async callSocket(data){if(void 0!==data.listener){if(game.user.id===data.listener)switch(data.type){case"character-wizard":CoC7InvestigatorWizard.createCharacterFromData(data.payload);break;case"open-character":game.actors.get(data.payload).sheet.render(!0);break;case"group-message-new":CoC7GroupMessage.newGroupMessage(data);break;case"group-message-roll":CoC7GroupMessage.performMyRolls(data);break;case"group-message-update":CoC7GroupMessage.updateTheMessage(data)}}else{if(game.user.isGM)switch(data.type){case OpposedCheckCard.defaultConfig.type:OpposedCheckCard.dispatch(data);break;case CombinedCheckCard.defaultConfig.type:CombinedCheckCard.dispatch(data);break;case"invoke":(await fromUuid(data.item))[data.method](data.data)}switch(data.type){case"updateChar":CoC7Utilities.updateCharSheets();break;case"toggleMapNotes":game.settings.set("core",NotesLayer.TOGGLE_SETTING,!0===data.toggle)}}}static requestKeeperAction(data){if(game.user.isGM)data.listener=game.user.id,CoC7SystemSocket.callSocket(data);else{const keepers=game.users.filter((u=>u.active&&u.isGM));keepers.length?(data.listener=keepers[0].id,game.socket.emit("system.CoC7",data)):ui.notifications.error(game.i18n.localize("CoC7.ErrorMissingKeeperUser"))}}static requestUserAction(data,{userId=null,errorIfMissing=!0,includeSelf=!0}={}){if(userId&&void 0!==userId)if(userId===game.user.id)data.listener=game.user.id,CoC7SystemSocket.callSocket(data);else{const user=game.users.get(userId);void 0!==user.id&&user.active?(data.listener=user.id,game.socket.emit("system.CoC7",data)):errorIfMissing&&ui.notifications.error(game.i18n.localize("CoC7.ErrorMissingUser"))}else includeSelf&&CoC7SystemSocket.callSocket(data),game.socket.emit("system.CoC7",data)}}class CoC7Tooltips{constructor(){this.ToolTipHover=null,this.toolTipTimer=null}displayToolTip(toolTip){if(void 0!==this.ToolTipHover){const bounds=this.ToolTipHover.getBoundingClientRect();if(!isNaN(bounds.left||"")&&!isNaN(bounds.top||"")){let left=bounds.left,top=bounds.top;const heightText=$(this.ToolTipHover).outerHeight();$("body").append('<div id="help-tooltip" class="themed theme-light">'+toolTip+"</div>");const tip=$("#help-tooltip"),heightTip=tip.outerHeight(),widthTip=tip.outerWidth();window.innerHeight<1.5*heightText+heightTip+top?top-=heightTip:top+=1.5*heightText,window.innerWidth<widthTip+left&&(left=window.innerWidth-widthTip),tip.css({left:left+"px",top:top+"px"})}}}toolTipLeave(event){game.CoC7Tooltips.ToolTipHover===event.currentTarget&&(clearTimeout(game.CoC7Tooltips.toolTipTimer),game.CoC7Tooltips.ToolTipHover=null,$("#help-tooltip").remove())}}class CoC7Tour extends(foundry.nue?.Tour??Tour){async waitForElement(selector){return new Promise(((resolve,reject)=>{if(document.querySelector(selector))return void resolve();new MutationObserver(((mutations,observer)=>{document.querySelectorAll(selector).forEach((el=>{resolve(),observer.disconnect()}))})).observe(document.body,{childList:!0,subtree:!0})}))}async _preStep(){if(await super._preStep(),0===this.stepIndex)for(const app of Object.values(ui.windows))app.close();await this.waitForElement(this.currentStep.selector),void 0!==this.currentStep.sidebarTab&&ui.sidebar.activateTab(this.currentStep.sidebarTab)}async _postStep(){if(await super._postStep(),!(this.stepIndex<0)&&this.hasNext&&this.currentStep.action)if(this.isResetting)this.isResetting=!1;else if("click"===this.currentStep.action)document.querySelector(this.currentStep.selector).click()}async reset(){"completed"!==this.status&&(this.isResetting=!0),await super.reset()}}class EnableVariantRulesEn extends CoC7Tour{constructor(config){super(foundry.utils.mergeObject({title:"Enable optional/variant rules.",description:"Learn how to enable Pulp Cthulhu rules, or other variant rules",canBeResumed:!1,display:!0,steps:[{id:"goto-settings",selector:foundry.utils.isNewerVersion(game.version,"13")?'button.ui-control[data-action="tab"][data-tab="settings"]':'.tabs>a[data-tab="settings"]',title:"COC7.Tour.GotoSettingsTitle",content:"COC7.Tour.GotoSettingsContent",sidebarTab:"settings"},{id:"goto-configure",selector:foundry.utils.isNewerVersion(game.version,"13")?'button[data-action="openApp"][data-app="configure"]':'[data-action="configure"]',title:"COC7.Tour.GotoConfigureTitle",content:"COC7.Tour.GotoConfigureContent",action:"click"},{id:"goto-system-settings",selector:'[data-tab="system"]',title:"COC7.Tour.GotoSystemSettingsTitle",content:"COC7.Tour.GotoSystemSettingsContent",action:"click"},{id:"goto-game-rules",selector:'[data-category="system"] [data-key="CoC7.gameRules"]',title:"COC7.Tour.GotoGameRulesTitle",content:"COC7.Tour.GotoGameRulesContent",action:"click"},{id:"save-game-rules",selector:"#rules-settings [name=submit]",title:"COC7.Tour.SaveGameRulesTitle",content:"COC7.Tour.SaveGameRulesContent"}],localization:{"COC7.Tour.GotoSettingsTitle":"Game Settings","COC7.Tour.GotoSettingsContent":"Go to the Game Settings tab","COC7.Tour.GotoConfigureTitle":"Configure Settings","COC7.Tour.GotoConfigureContent":"Click on the Configure Settings button","COC7.Tour.GotoSystemSettingsTitle":"System Settings","COC7.Tour.GotoSystemSettingsContent":"Go to the System Settings tab","COC7.Tour.GotoGameRulesTitle":"Configure Variant/Optional Rules","COC7.Tour.GotoGameRulesContent":"Click on the Configure Variant/Optional Rules button","COC7.Tour.SaveGameRulesTitle":"Save rule changes","COC7.Tour.SaveGameRulesContent":"Once you have made your changes click on the Save Changes button"}},config))}}class EnableVariantRulesFr extends EnableVariantRulesEn{constructor(config){super({title:"Activez les règles optionnelles.",description:"Activez les règles optionelles et Pulp Cthulhu",localization:{"COC7.Tour.GotoSettingsTitle":"Paramètres","COC7.Tour.GotoSettingsContent":'Ouvrir l\'onglet "Paramètres"',"COC7.Tour.GotoConfigureTitle":"Configuration des options","COC7.Tour.GotoConfigureContent":'Cliquez sur "Configuration des options"',"COC7.Tour.GotoSystemSettingsTitle":"Système de jeu","COC7.Tour.GotoSystemSettingsContent":'Ouvrez l\'onglet "Système de jeu"',"COC7.Tour.GotoGameRulesTitle":"Configurer les variantes/règles optionnelles","COC7.Tour.GotoGameRulesContent":'Clickez sur le boutton "Configurer les variantes/règles optionnelles"',"COC7.Tour.SaveGameRulesTitle":"Sauvegarder les modifications","COC7.Tour.SaveGameRulesContent":'Apres avoir choisis les options cliquez sur le bouton "Sauvegarder les modifications"'}})}}class CoCIDBatch extends FormApplication{static get defaultOptions(){return foundry.utils.mergeObject(super.defaultOptions,{classes:["coc7","dialog","coc-id-editor"],template:"systems/CoC7/templates/apps/coc-id-batch.hbs",width:700,height:"auto",title:"CoC7.CoCIDFlag.title",closeOnSubmit:!1,submitOnClose:!1,submitOnChange:!1})}async getData(){const sheetData=super.getData();return sheetData.foundKeys=Object.keys(sheetData.object.foundKeys).reduce(((out,key)=>(out.push({name:key,key:sheetData.object.foundKeys[key]}),out)),[]).sort(CoC7Utilities.sortByNameKey),sheetData.missingNames=Object.keys(sheetData.object.missingNames).reduce(((out,key)=>(out.push({key:sheetData.object.foundKeys[key]??"",name:key,custom:sheetData.object.missingNames[key],suffix:sheetData.object.missingNames[key].replace(this.object.suffixRegExp,"")}),out)),[]).sort(CoC7Utilities.sortByNameKey),sheetData}activateListeners(html){super.activateListeners(html),html.find(".existing").change(this.onSetName.bind(this)),html.find(".fa-wand-magic").click(this.onClickGuess.bind(this)),html.find("input").keyup(this.onKeyup.bind(this))}onSetName(event){const obj=$(event.currentTarget);this.object.missingNames[obj.closest("li").data("name")]=obj.val(),this.render(!0)}onClickGuess(event){const name=$(event.currentTarget).closest("li").data("name");this.object.missingNames[name]=this.object.idPrefix+CoC7Utilities.toKebabCase(name),this.render(!0)}onKeyup(event){const obj=$(event.currentTarget),name=obj.closest("li").data("name");this.object.missingNames[name]=this.object.idPrefix+obj.val()}async _updateObject(event,formData){event.submitter&&(this.object.typeName===game.i18n.localize("CoC7.Entities.Skill")&&(this.close(),await CoCIDBatch.processSkillKeys(this.object.updateList,this.object.missingNames)),this.object.resolve(!0))}static async processSkillKeys(updateList,missingNames){const items=[],actors={},scenes={};for(const update of updateList){update.cocidFlag.id=missingNames[update.name],void 0===update.cocidFlag.lang&&(update.cocidFlag.lang=game.i18n.lang),void 0===update.cocidFlag.priority&&(update.cocidFlag.priority=0),void 0===update.cocidFlag.eras&&(update.cocidFlag.eras={});const flags=foundry.utils.flattenObject({flags:{CoC7:{cocidFlag:update.cocidFlag}}});if(void 0!==update.scene){if(void 0===scenes[update.scene]){const scene=game.scenes.get(update.scene);scenes[update.scene]=scene.toObject()}const tokenOffset=scenes[update.scene].tokens.findIndex((t=>t._id===update.token));if(tokenOffset>-1){const itemOffset=scenes[update.scene].tokens[tokenOffset].actorData.items.findIndex((i=>i._id===update.item));if(itemOffset>-1){const expandedFlags=foundry.utils.expandObject(Object.entries(flags).reduce(((out,entry)=>(entry[0].match(/^flags\.CoC7\.cocidFlag/)&&(out[entry[0]]=entry[1]),out)),{}));scenes[update.scene].tokens[tokenOffset].actorData.items[itemOffset]=foundry.utils.mergeObject(scenes[update.scene].tokens[tokenOffset].actorData.items[itemOffset],expandedFlags)}}}else if(void 0!==update.actor){void 0===actors[update.actor]&&(actors[update.actor]=[]);const item={_id:update.item};for(const key of Object.keys(flags))key.match(/^flags\.CoC7\.cocidFlag/)&&(item[key]=flags[key]);actors[update.actor].push(item)}else{const item={_id:update.item};for(const key of Object.keys(flags))key.match(/^flags\.CoC7\.cocidFlag/)&&(item[key]=flags[key]);items.push(item)}}if(items.length&&await Item.updateDocuments(items),Object.keys(actors).length)for(const actorId of Object.keys(actors))await Item.updateDocuments(actors[actorId],{parent:game.actors.get(actorId)});if(Object.keys(scenes).length)for(const sceneId of Object.keys(scenes)){game.scenes.get(sceneId).update(scenes[sceneId])}return!0}static async populateSkillKeys(updateList,missingNames,foundKeys){for(const actor of game.actors.contents){const actorData=actor.toObject();if(actorData.items)for(const item of actorData.items){const itemData=item instanceof CONFIG.Item.documentClass?item.toObject():item;"skill"===itemData.type&&(itemData.flags.CoC7?.cocidFlag?.id?.match(/^i.skill/)?foundKeys[itemData.name]=itemData.flags.CoC7.cocidFlag.id:(void 0===missingNames[itemData.name]&&(missingNames[itemData.name]=""),updateList.push({actor:actor._id,item:itemData._id,name:itemData.name,cocidFlag:itemData.flags.CoC7?.cocidFlag??{}})))}}for(const item of game.items.contents){const itemData=item instanceof CONFIG.Item.documentClass?item.toObject():item;"skill"===itemData.type&&(itemData.flags.CoC7?.cocidFlag?.id?.match(/^i.skill/)?foundKeys[itemData.name]=itemData.flags.CoC7.cocidFlag.id:(void 0===missingNames[itemData.name]&&(missingNames[itemData.name]=""),updateList.push({item:itemData._id,name:itemData.name,cocidFlag:itemData.flags.CoC7?.cocidFlag??{}})))}for(const scene of game.scenes){const sceneData=scene.toObject();for(const token of sceneData.tokens??[])if(token.actorId&&!token.actorLink&&token.actorData){const actorData=foundry.utils.duplicate(token.actorData);for(const item of actorData.items??[]){const itemData=item instanceof CONFIG.Item.documentClass?item.toObject():item;"skill"===itemData.type&&(itemData.flags.CoC7?.cocidFlag?.id?.match(/^i.skill/)?foundKeys[itemData.name]=itemData.flags.CoC7.cocidFlag.id:(void 0===missingNames[itemData.name]&&(missingNames[itemData.name]=""),updateList.push({scene:sceneData._id,token:token._id,item:itemData._id,name:itemData.name,cocidFlag:itemData.flags.CoC7?.cocidFlag??{}})))}}}if(Object.keys(missingNames).filter((key=>""===missingNames[key])).length>0){const items=await game.system.api.cocid.fromCoCIDRegexBest({cocidRegExp:/^i\.skill\./,type:"i",era:!1});for(const item of items)foundKeys[item.name]=item.flags.CoC7.cocidFlag.id;const CoCIDKeys=Object.assign(foundry.utils.flattenObject(game.i18n._fallback.CoC7?.CoCIDFlag?.keys??{}),foundry.utils.flattenObject(game.i18n.translations.CoC7?.CoCIDFlag?.keys??{}));for(const key in CoCIDKeys)foundKeys[game.i18n.format("CoC7.CoCIDFlag.keys."+key)]=key;for(const name in missingNames)void 0!==foundKeys[name]&&(missingNames[name]=foundKeys[name])}}static async create(type){const updateList=[],missingNames={},foundKeys={};let typeName="",idPrefix="",suffixRegExp=null;return"skill"===type&&(typeName=game.i18n.localize("CoC7.Entities.Skill"),idPrefix="i.skill.",suffixRegExp=/^i\.skill\./,await CoCIDBatch.populateSkillKeys(updateList,missingNames,foundKeys),0===Object.keys(missingNames).filter((key=>""===missingNames[key])).length?(await CoCIDBatch.processSkillKeys(updateList,missingNames),!0):new Promise((resolve=>{new CoCIDBatch({typeName,idPrefix,suffixRegExp,updateList,missingNames,foundKeys,resolve}).render(!0)})))}}class Updater{static async checkForUpdate(){let systemUpdateVersion=game.settings.get("CoC7","systemUpdateVersion");game.actors.size+game.scenes.size+game.items.size+game.journal.size+game.tables.size===0&&(systemUpdateVersion=game.system.version,await game.settings.set("CoC7","systemUpdateVersion",systemUpdateVersion));const runMigrate=foundry.utils.isNewerVersion(game.system.version,systemUpdateVersion??"0");this.updatedModules=game.settings.get("CoC7","systemUpdatedModuleVersion")||{},this.currentModules={};for(const pack of game.packs)if(!["CoC7","world"].includes(pack.metadata.packageName)&&["Actor","Item","Scene"].includes(pack.metadata.type)&&!Object.prototype.hasOwnProperty.call(this.currentModules,pack.metadata.packageName)){const module=game.modules.get(pack.metadata.packageName);if(module&&(runMigrate||!Object.prototype.hasOwnProperty.call(this.updatedModules,module.id)||String(this.updatedModules[module.id])!==String(module.version))){const knownModuleVersions={"call-of-cthulhu-foundryvtt-investigator-wizard":"1.0.5","cha-coc-fvtt-en-quickstart":"5.0.5","cha-coc-fvtt-en-starterset":"5.0.5"};"string"==typeof knownModuleVersions[module.id]?foundry.utils.isNewerVersion(module.version,knownModuleVersions[module.id])&&(this.currentModules[module.id]=module.version):this.currentModules[module.id]=module.version}}(runMigrate||Object.keys(this.currentModules).length>0)&&(game.user.isGM?new Dialog({title:game.i18n.localize("CoC7.Migrate.Title"),content:game.i18n.format(0===Object.keys(this.currentModules).length?"CoC7.Migrate.Message":"CoC7.Migrate.WithModulesMessage",{version:game.system.version,modules:"<ul><li>"+Object.keys(this.currentModules).map((mod=>game.modules.get(mod).title)).join("</li><li>")+"</li></ul>"}),buttons:{update:{label:game.i18n.localize("CoC7.Migrate.ButtonUpdate"),callback:async()=>Updater.update()},skip:{label:game.i18n.localize("CoC7.Migrate.ButtonSkip")}}}).render(!0):new Dialog({title:game.i18n.localize("CoC7.Migrate.Title"),content:game.i18n.format("CoC7.Migrate.GMRequired",{version:game.system.version}),buttons:{OK:{label:game.i18n.localize("CoC7.Migrate.ButtonOkay")}}}).render(!0))}static async update(){await this.updateDocuments(),game.settings.get("CoC7","pulpRules")&&(game.settings.set("CoC7","pulpRuleDoubleMaxHealth",!0),game.settings.set("CoC7","pulpRuleDevelopmentRollLuck",!0),game.settings.set("CoC7","pulpRuleArchetype",!0),game.settings.set("CoC7","pulpRuleOrganization",!0),game.settings.set("CoC7","pulpRuleTalents",!0),game.settings.set("CoC7","pulpRuleFasterRecovery",!0),game.settings.set("CoC7","pulpRuleIgnoreMajorWounds",!0),game.settings.set("CoC7","pulpRuleIgnoreAgePenalties",!0)),await CoCIDBatch.create("skill");const settings=foundry.utils.mergeObject(this.updatedModules||{},this.currentModules);game.settings.set("CoC7","systemUpdatedModuleVersion",settings),game.settings.set("CoC7","systemUpdateVersion",game.system.version),ui.notifications.info(game.i18n.format("CoC7.Migrate.Complete"),{permanent:!0})}static async updateDocuments(){for(const actor of game.actors.contents)try{const updateData=this.migrateActorData(actor.toObject());foundry.utils.isEmpty(updateData)||(console.log(`Migrating Actor document ${actor.name}`),await actor.update(updateData,{enforceTypes:!1}))}catch(err){console.log("Error details",err),err.message=game.i18n.format("CoC7.Migrate.ErrorActor",{name:actor.name,message:err.message}),ui.notifications.error(err.message,{permanent:!0})}for(const item of game.items.contents)try{const updateData=Updater.migrateItemData(item.toObject());foundry.utils.isEmpty(updateData)||(console.log(`Migrating Item document ${item.name}`),await item.update(updateData,{enforceTypes:!1}))}catch(err){console.log("Error details",err),err.message=game.i18n.format("CoC7.Migrate.ErrorItem",{name:item.name,message:err.message}),ui.notifications.error(err.message,{permanent:!0})}for(const table of game.tables.contents)try{const updateData=Updater.migrateTableData(table.toObject());foundry.utils.isEmpty(updateData)||(console.log(`Migrating Table document ${table.name}`),await table.update(updateData,{enforceTypes:!1}))}catch(err){console.log("Error details",err),err.message=game.i18n.format("CoC7.Migrate.ErrorTable",{name:table.name,message:err.message}),ui.notifications.error(err.message,{permanent:!0})}for(const macro of game.macros.contents)try{const updateData=Updater.migrateMacroData(macro.toObject());foundry.utils.isEmpty(updateData)||(console.log(`Migrating Macro document ${macro.name}`),await macro.update(updateData,{enforceTypes:!1}))}catch(err){console.log("Error details",err),err.message=game.i18n.format("CoC7.Migrate.ErrorMacro",{name:macro.name,message:err.message}),ui.notifications.error(err.message,{permanent:!0})}for(const scene of game.scenes)try{const updateData=Updater.migrateSceneData(scene);foundry.utils.isEmpty(updateData)||(console.log(`Migrating Scene document ${scene.name}`),await scene.update(updateData,{enforceTypes:!1})),scene.tokens.forEach((t=>t._actor=null))}catch(err){console.log("Error details",err),err.message=game.i18n.format("CoC7.Migrate.ErrorScene",{name:scene.name,message:err.message}),ui.notifications.error(err.message,{permanent:!0})}for(const pack of game.packs)"CoC7"!==pack.metadata.packageName&&["Actor","Item","Macro","RollTable","Scene"].includes(pack.metadata.type)&&await Updater.migrateCompendiumData(pack)}static migrateActorData(actor){const updateData={};if(Updater._migrateActorCharacterSanity(actor,updateData),Updater._migrateActorArtwork(actor,updateData),Updater._migrateActorKeeperNotes(actor,updateData),Updater._migrateActorNpcCreature(actor,updateData),Updater._migrateActorStatusEffectActive(actor,updateData),Updater._migrateActorSanLossReasons(actor,updateData),Updater._migrateActorMonetary(actor,updateData),actor.items){const items=actor.items.reduce(((arr,i)=>{const itemData=i instanceof CONFIG.Item.documentClass?i.toObject():i,itemUpdate=Updater.migrateItemData(itemData);return foundry.utils.isEmpty(itemUpdate)||(itemUpdate._id=itemData._id,arr.push(foundry.utils.expandObject(itemUpdate))),arr}),[]);items.length>0&&(updateData.items=items)}return updateData}static async migrateCompendiumData(pack){const documentType=pack.metadata.type;if(!["Actor","Item","Macro","RollTable","Scene"].includes(documentType))return;const wasLocked=pack.locked;await pack.configure({locked:!1});try{await pack.migrate()}catch(err){console.log("pack migrate failed",pack,err)}const documents=await pack.getDocuments();for(const doc of documents){let updateData={};try{switch(documentType){case"Actor":updateData=Updater.migrateActorData(doc.toObject());break;case"Item":updateData=Updater.migrateItemData(doc.toObject());break;case"Macro":updateData=Updater.migrateMacroData(doc.toObject());break;case"RollTable":updateData=Updater.migrateTableData(doc.toObject());break;case"Scene":updateData=Updater.migrateSceneData(doc)}foundry.utils.isEmpty(updateData)||(console.log(`Migrated ${documentType} document ${doc.name} in Compendium ${pack.collection}`),await doc.update(updateData))}catch(err){console.log("Error details",err),err.message=game.i18n.format("CoC7.Migrate.ErrorDocumentPack",{name:doc.name,collection:pack.collection,message:err.message}),ui.notifications.error(err.message,{permanent:!0})}}await pack.configure({locked:wasLocked})}static migrateItemData(item){const updateData={};return Updater._migrateItemEmbeddedv10(item,updateData),Updater._migrateItemExperience(item,updateData),Updater._migrateItemArtwork(item,updateData),Updater._migrateItemBookAutomated(item,updateData),Updater._migrateItemKeeperNotes(item,updateData),Updater._migrateItemSpellAutomated(item,updateData),Updater._migrateItemKeeperNotesMerge(item,updateData),Updater._migrateItemEras(item,updateData),Updater._migrateItemv10(item,updateData),Updater._migrateItemBookUnits(item,updateData),updateData}static migrateMacroData(table){const updateData={};return Updater._migrateMacroArtwork(table,updateData),updateData}static migrateTableData(table){const updateData={};return Updater._migrateTableArtwork(table,updateData),updateData}static migrateSceneData(scene){const returns={tokens:[]};return void 0!==scene.tokens&&scene.tokens.length&&(returns.tokens=scene.tokens.map((token=>{const t=token.toObject(),updateData={};if(Updater._migrateTokenArtwork(t,updateData),Object.keys(updateData).length&&foundry.utils.mergeObject(t,updateData),!t.actorId||t.actorLink)t.actorData={};else if(game.actors.has(t.actorId)){if(!t.actorLink){const actorData=foundry.utils.duplicate(t.actorData);actorData.type=token.actor?.type;const update=Updater.migrateActorData(actorData);["items","effects"].forEach((embeddedName=>{if(!update[embeddedName]?.length)return;const updates=new Map(update[embeddedName].map((u=>[u._id,u])));t.actorData[embeddedName].forEach((original=>{const update=updates.get(original._id);update&&foundry.utils.mergeObject(original,update)})),delete update[embeddedName]})),foundry.utils.mergeObject(t.actorData,update)}}else t.actorId=null,t.actorData={};return t}))),returns}static _migrateItemKeeperNotes(item,updateData){return["archetype","chase","item","occupation","setup","skill","spell","status","talent","weapon"].includes(item.type)&&("string"==typeof item.system.description?updateData["system.description"]={value:item.system.description,keeper:""}:void 0===item.system.description||null===item.system.description?updateData["system.description"]={value:"",keeper:""}:void 0===item.system.description.keeper&&(updateData["system.description.keeper"]="")),updateData}static _migrateItemExperience(item,updateData){return"skill"===item.type&&void 0===item.system.adjustments?.experience&&(updateData["system.adjustments.experience"]=0),updateData}static _migrateItemArtwork(item,updateData){let image=String(item.img).match(/systems\/CoC7\/artwork\/icons\/(.+)/);if(null!==image&&(updateData.img="systems/CoC7/assets/icons/"+image[1]),"setup"===item.type)for(const[k,v]of Object.entries(item.system.items))"string"!=typeof v&&(image=String(v.img).match(/systems\/CoC7\/artwork\/icons\/(.+)/),null!==image&&(void 0===updateData["system.items"]&&(updateData["system.items"]=item.system.items),updateData["system.items"][k].img="systems/CoC7/assets/icons/"+image[1]));else if("occupation"===item.type){for(const[k,v]of Object.entries(item.system.skills))"string"!=typeof v&&(image=String(v.img).match(/systems\/CoC7\/artwork\/icons\/(.+)/),null!==image&&(void 0===updateData["system.skills"]&&(updateData["system.skills"]=item.system.skills),updateData["system.skills"][k].img="systems/CoC7/assets/icons/"+image[1]));for(const[o,g]of Object.entries(item.system.groups))for(const[k,v]of Object.entries(g.skills))"string"!=typeof v&&(image=String(v.img).match(/systems\/CoC7\/artwork\/icons\/(.+)/),null!==image&&(void 0===updateData["system.groups"]&&(updateData["system.groups"]=item.system.groups),updateData["system.groups"][o].skills[k].img="systems/CoC7/assets/icons/"+image[1]))}else if("book"===item.type)for(const[k,v]of Object.entries(item.system.spells))"string"!=typeof v&&(image=String(v.img).match(/systems\/CoC7\/artwork\/icons\/(.+)/),null!==image&&(void 0===updateData["system.spells"]&&(updateData["system.spells"]=item.system.spells),updateData["system.spells"][k].img="systems/CoC7/assets/icons/"+image[1]));else if("archetype"===item.type)for(const[k,v]of Object.entries(item.system.skills))"string"!=typeof v&&(image=String(v.img).match(/systems\/CoC7\/artwork\/icons\/(.+)/),null!==image&&(void 0===updateData["system.skills"]&&(updateData["system.skills"]=item.system.skills),updateData["system.skills"][k].img="systems/CoC7/assets/icons/"+image[1]));return updateData}static _migrateItemSpellAutomated(item,updateData){"spell"===item.type&&void 0!==item.system.cost&&(updateData["system.castingTime"]=item.system.castingTime||"",updateData["system.costs.hitPoints"]=item.system.cost.hp||0,updateData["system.costs.magicPoints"]=item.system.cost.mp||0,updateData["system.costs.sanity"]=item.system.cost.san||0,updateData["system.costs.power"]=item.system.cost.pow||0,updateData["system.costs.others"]="",updateData["system.-=cost"]=null,updateData["system.description.-=unidentified"]=null,updateData["system.description.-=notes"]=null)}static _migrateItemBookAutomated(item,updateData){return"book"===item.type&&void 0!==item.system.description.unidentified&&(updateData["system.author"]=item.system.author||"",updateData["system.date"]=item.system.date||"",updateData["system.language"]=item.system.language||"",updateData["system.sanityLoss"]=item.system.sanLoss||0,updateData["system.mythosRating"]=Number(item.system.mythosRating)||0,updateData["system.content"]=item.system.description.unidentified,updateData["system.description.keeper"]=item.system.description.notes,updateData["system.difficultyLevel"]="regular",updateData["system.fullStudies"]=0,updateData["system.initialReading"]=!1,updateData["system.keeperNotes"]="",updateData["system.gains.cthulhuMythos.initial"]=Number(item.system.gain.cthulhuMythos.CMI)||0,updateData["system.gains.cthulhuMythos.final"]=Number(item.system.gain.cthulhuMythos.CMF)||0,updateData["system.gains.occult"]=Number(item.system.gain.occult)||0,updateData["system.gains.others"]=[],updateData["system.study"]={necessary:Number(item.system.weeksStudyTime)||0,progress:0,units:"CoC7.weeks"},updateData["system.-=sanLoss"]=null,updateData["system.-=weeksStudyTime"]=null,updateData["system.-=gain"]=null,updateData["system.description.-=unidentified"]=null,updateData["system.description.-=notes"]=null,updateData["system.gains.-=other"]=null,updateData["system.-=properties"]=null,updateData["system.-=flags"]=null),updateData}static _migrateItemBookUnits(item,updateData){"book"===item.type&&void 0!==item.system.study.necessary&&void 0===item.system.study.units&&(updateData["system.study.units"]="CoC7.weeks")}static _migrateItemKeeperNotesMerge(item,updateData){"spell"!==item.type&&"book"!==item.type||(void 0!==item.system.notes&&(void 0!==item.system.description.keeper?updateData["system.description.keeper"]=item.system.description.keeper+item.system.notes:updateData["system.description.keeper"]=item.system.notes,updateData["system.-=notes"]=null),void 0!==item.system.keeperNotes&&(void 0!==updateData["system.description.keeper"]?updateData["system.description.keeper"]=item.system.keeperNotes+updateData["system.description.keeper"]:updateData["system.description.keeper"]=item.system.keeperNotes,updateData["system.-=keeperNotes"]=null))}static _migrateItemEmbeddedv10(item,updateData){if("occupation"===item.type){let changed=!1;for(const[o,g]of Object.entries(item.system.groups))for(const[k,v]of Object.entries(g.skills))"string"!=typeof v&&void 0===v.system&&(item.system.groups[o].skills[k].system=v.data,changed=!0);changed&&(updateData["system.groups"]=item.system.groups)}if(["setup"].includes(item.type)){let changed=!1;for(const[k,v]of Object.entries(item.system.items))"string"!=typeof v&&void 0===v.system&&(item.system.items[k].system=v.data,changed=!0);changed&&(updateData["system.items"]=item.system.items)}if(["archetype","occupation"].includes(item.type)){let changed=!1;for(const[k,v]of Object.entries(item.system.skills))"string"!=typeof v&&void 0===v.system&&(item.system.skills[k].system=v.data,changed=!0);changed&&(updateData["system.skills"]=item.system.skills)}if(["book"].includes(item.type)){let changed=!1;for(const[k,v]of Object.entries(item.system.spells))"string"!=typeof v&&void 0===v.system&&(item.system.spells[k].system=v.data,changed=!0);changed&&(updateData["system.spells"]=item.system.spells)}}static _migrateItemv10(item,updateData){if("skill"!==item.type||void 0!==item.system.skillName&&""!==item.system.skillName){if("setup"===item.type){for(const[k,v]of Object.entries(item.system.items))if("string"!=typeof v&&"skill"===v.type&&(void 0===v.system.skillName||""===v.system.skillName)){void 0===updateData["system.items"]&&(updateData["system.items"]=item.system.items),updateData["system.items"][k].name=v.name,"Uniki"===updateData["system.items"][k].name&&(updateData["system.items"][k].name="Unik");const parts=CoC7Item.getNamePartsSpec(updateData["system.items"][k].name,"string"==typeof v.system.specialization?.group?v.system.specialization.group:v.system.specialization);updateData["system.items"][k].name=parts.name,updateData["system.items"][k].system.skillName=parts.skillName,updateData["system.items"][k].system.specialization=parts.specialization}}else if("occupation"===item.type){for(const[k,v]of Object.entries(item.system.skills))if("string"!=typeof v&&"skill"===v.type&&(void 0===v.system.skillName||""===v.system.skillName)){void 0===updateData["system.skills"]&&(updateData["system.skills"]=item.system.skills),updateData["system.skills"][k].name=v.name,"Uniki"===updateData["system.skills"][k].name&&(updateData["system.skills"][k].name="Unik");const parts=CoC7Item.getNamePartsSpec(updateData["system.skills"][k].name,"string"==typeof v.system.specialization?.group?v.system.specialization.group:v.system.specialization);updateData["system.skills"][k].name=parts.name,updateData["system.skills"][k].system.skillName=parts.skillName,updateData["system.skills"][k].system.specialization=parts.specialization}for(const[o,g]of Object.entries(item.system.groups))for(const[k,v]of Object.entries(g.skills))if("string"!=typeof v&&"skill"===v.type&&(void 0===v.system.skillName||""===v.system.skillName)){void 0===updateData["system.groups"]&&(updateData["system.groups"]=item.system.groups),updateData["system.groups"][o].skills[k].name=v.name,"Uniki"===updateData["system.groups"][o].skills[k].name&&(updateData["system.groups"][o].skills[k].name="Unik");const parts=CoC7Item.getNamePartsSpec(updateData["system.groups"][o].skills[k].name,"string"==typeof v.system.specialization?.group?v.system.specialization.group:v.system.specialization);updateData["system.groups"][o].skills[k].name=parts.name,updateData["system.groups"][o].skills[k].system.skillName=parts.skillName,updateData["system.groups"][o].skills[k].system.specialization=parts.specialization}}else if("archetype"===item.type)for(const[k,v]of Object.entries(item.system.skills))if("string"!=typeof v&&"skill"===v.type&&(void 0===v.system.skillName||""===v.system.skillName)){void 0===updateData["system.skills"]&&(updateData["system.skills"]=item.system.skills),updateData["system.skills"][k].name=v.name,"Uniki"===updateData["system.skills"][k].name&&(updateData["system.skills"][k].name="Unik");const parts=CoC7Item.getNamePartsSpec(updateData["system.skills"][k].name,"string"==typeof v.system.specialization?.group?v.system.specialization.group:v.system.specialization);updateData["system.skills"][k].name=parts.name,updateData["system.skills"][k].system.skillName=parts.skillName,updateData["system.skills"][k].system.specialization=parts.specialization}}else{updateData.name=item.name,"Uniki"===updateData.name&&(updateData.name="Unik");const parts=CoC7Item.getNamePartsSpec(updateData.name,"string"==typeof item.system.specialization?.group?item.system.specialization.group:item.system.specialization);updateData.name=parts.name,updateData["system.skillName"]=parts.skillName,updateData["system.specialization"]=parts.specialization}}static _migrateItemEras(item,updateData){if(void 0!==item.system.eras){let eras={};for(const[key,value]of Object.entries(item.system.eras))if(!0===value||"string"!=typeof value&&void 0!==value.selected)switch(key){case"1920":eras.standard=!0;break;case"mdrn":eras.modern=!0,eras.modernPulp=!0;break;case"pulp":eras.pulp=!0;break;case"ddts":eras.downDarkerTrails=!0,eras.downDarkerTrailsPulp=!0;break;case"drka":eras.darkAges=!0,eras.darkAgesPulp=!0;break;case"glit":eras.gasLight=!0;break;case"nvct":eras.invictus=!0}if("setup"===item.type){const key=Object.keys(eras)[0];eras=key?{[key]:!0}:{standard:!0}}const CoC7={cocidFlag:{id:"",lang:game.i18n.lang,priority:0,eras}};void 0===item.flags?.CoC7?(item.flags.CoC7=CoC7,updateData["flags.CoC7"]=CoC7):void 0===item.flags?.CoC7?.cocidFlag?(item.flags.CoC7.cocidFlag=CoC7.cocidFlag,updateData["flags.CoC7.cocidFlag"]=CoC7.cocidFlag):(item.flags.CoC7.cocidFlag.eras=CoC7.cocidFlag.eras,updateData["flags.CoC7.cocidFlag.eras"]=CoC7.cocidFlag.eras),updateData["system.-=eras"]=null}}static _migrateActorArtwork(actor,updateData){let image=String(actor.img).match(/systems\/CoC7\/artwork\/icons\/(.+)/);if(null!==image&&(updateData.img="systems/CoC7/assets/icons/"+image[1]),void 0!==actor.prototypeToken&&void 0!==actor.prototypeToken.texture?.src&&(image=String(actor.prototypeToken.texture.src).match(/systems\/CoC7\/artwork\/icons\/(.+)/),null!==image&&(updateData["prototypeToken.texture.src"]="systems/CoC7/assets/icons/"+image[1])),void 0!==actor.effects)for(const[k,v]of Object.entries(actor.effects))image=String(v.icon).match(/systems\/CoC7\/artwork\/icons\/(.+)/),null!==image&&(void 0===updateData.effects&&(updateData.effects=actor.effects),updateData.effects[k].icon="systems/CoC7/assets/icons/"+image[1])}static _migrateActorKeeperNotes(actor,updateData){["character","npc","creature"].includes(actor.type)&&void 0!==actor.system&&void 0===actor.system.description&&(updateData["system.description"]={keeper:""})}static _migrateActorMonetary(actor,updateData){if("character"===actor.type&&void 0!==actor.system.credit?.multiplier){updateData["system.monetary.symbol"]=actor.system.credit?.monetarySymbol?actor.system.credit.monetarySymbol:"$",""===updateData["system.monetary.symbol"].toString().trim()&&(updateData["system.monetary.symbol"]="$");const multiplier=parseInt(actor.system.credit.multiplier)?parseInt(actor.system.credit.multiplier):1;if(updateData["system.monetary.spent"]=actor.system.credit.spent,updateData["system.monetary.assetsDetails"]=actor.system.credit.assetsDetails,updateData["system.monetary.spendingLevel"]=actor.system.credit.spendingLevel,updateData["system.monetary.cash"]=actor.system.credit.cash,updateData["system.monetary.assets"]=actor.system.credit.assets,updateData["system.monetary.values"]=foundry.utils.duplicate(actor.system.monetary.values),1!==multiplier)for(const value of updateData["system.monetary.values"])value.cashValue=multiplier*value.cashValue,value.assetsValue=multiplier*value.assetsValue,value.spendingValue=multiplier*value.spendingValue;updateData["system.-=credit"]=null}}static _migrateActorSanLossReasons(actor,updateData){if("character"===actor.type&&void 0!==actor.system?.encounteredCreatures){const groups={};for(const sanityLossEvent of actor.system.encounteredCreatures)sanityLossEvent.totalLoss>0&&(groups[sanityLossEvent.name]=Math.max(groups[sanityLossEvent.name]??0,sanityLossEvent.totalLoss));const sanityLossEvents=[];for(const name in groups)sanityLossEvents.push({type:name,totalLoss:groups[name],immunity:!1});updateData["system.sanityLossEvents"]=sanityLossEvents,updateData["system.-=encounteredCreatures"]=null}}static _migrateActorStatusEffectActive(actor,updateData){if(["character","npc","creature"].includes(actor.type)&&void 0!==actor.system&&(void 0!==actor.system.status||void 0===actor.system.conditions)){if(updateData["system.conditions.criticalWounds.value"]=!1,updateData["system.conditions.unconscious.value"]=!1,updateData["system.conditions.dying.value"]=!1,updateData["system.conditions.dead.value"]=!1,updateData["system.conditions.prone.value"]=!1,updateData["system.conditions.tempoInsane.value"]=!1,updateData["system.conditions.indefInsane.value"]=!1,void 0!==actor.system.status?.criticalWounds?.value&&actor.system.status?.criticalWounds.value&&(updateData["system.conditions.criticalWounds.value"]=!0),void 0!==actor.system.status?.unconscious?.value&&actor.system.status?.unconscious.value&&(updateData["system.conditions.unconscious.value"]=!0),void 0!==actor.system.status?.dying?.value&&actor.system.status?.dying.value&&(updateData["system.conditions.dying.value"]=!0),void 0!==actor.system.status?.dead?.value&&actor.system.status?.dead.value&&(updateData["system.conditions.dead.value"]=!0),void 0!==actor.system.status?.prone?.value&&actor.system.status?.prone.value&&(updateData["system.conditions.prone.value"]=!0),void 0!==actor.system.status?.tempoInsane?.value&&actor.system.status?.tempoInsane.value&&(updateData["system.conditions.tempoInsane.value"]=!0),void 0!==actor.system.status?.indefInsane?.value&&actor.system.status?.indefInsane.value&&(updateData["system.conditions.indefInsane.value"]=!0),void 0!==actor.effects){const effects=actor.effects;let changed=!1;for(let i=0,im=effects.length;i<im;i++){const effect=effects[i],match=effect.icon.match(/\/(hanging-spider|tentacles-skull|arm-sling|heart-beats|tombstone|knocked-out-stars|falling|skull|unconscious)\./);if(null!==match){let statusId="";switch(match[1]){case"hanging-spider":statusId="tempoInsane";break;case"tentacles-skull":statusId="indefInsane";break;case"arm-sling":statusId="criticalWounds";break;case"heart-beats":statusId="dying";break;case"tombstone":case"skull":statusId="dead";break;case"knocked-out-stars":case"unconscious":statusId="unconscious";break;case"falling":statusId="prone"}""!==statusId&&(updateData[`system.conditions.${statusId}.value`]||(updateData[`system.conditions.${statusId}.value`]=!0,changed=!0),effect.flags.core?.statusId!==statusId&&(effects[i]=foundry.utils.mergeObject(effect,{flags:{core:{statusId}}}),changed=!0))}}changed&&(updateData.effects=effects)}updateData["system.-=status"]=null}return updateData}static _migrateActorNpcCreature(actor,updateData){return["npc"].includes(actor.type)&&void 0!==actor.system&&(void 0===actor.system.special&&(updateData["system.special"]={checkPassed:null,checkFailled:null}),void 0===actor.system.attacksPerRound&&(updateData["system.attacksPerRound"]=1)),updateData}static _migrateActorCharacterSanity(actor,updateData){if("character"===actor.type&&void 0!==actor.system?.attribs?.san){const oneFifthSanity=Math.ceil(actor.system.attribs.san.value/5);void 0!==actor.system.attribs.san.dailyLoss&&null!==actor.system.attribs.san.dailyLoss||(updateData["system.attribs.san.dailyLoss"]=0),void 0!==actor.system.attribs.san.oneFifthSanity&&null!==actor.system.attribs.san.oneFifthSanity||(updateData["system.attribs.san.oneFifthSanity"]=" / "+oneFifthSanity),void 0!==actor.system.attribs.san.dailyLoss&&null!==actor.system.attribs.san.dailyLoss||(updateData["system.attribs.san.dailyLoss"]=0),void 0!==actor.system.indefiniteInsanityLevel&&null!==actor.system.indefiniteInsanityLevel&&void 0!==actor.system.indefiniteInsanityLevel.value&&null!==actor.system.indefiniteInsanityLevel.value||(updateData["system.indefiniteInsanityLevel.value"]=0),void 0!==actor.system.indefiniteInsanityLevel&&null!==actor.system.indefiniteInsanityLevel&&void 0!==actor.system.indefiniteInsanityLevel.max&&null!==actor.system.indefiniteInsanityLevel.max||(updateData["system.indefiniteInsanityLevel.max"]=oneFifthSanity),void 0!==actor.system.attribs.mp&&(void 0!==actor.system.attribs.mp.value&&null!==actor.system.attribs.mp.value||(updateData["system.attribs.mp.value"]=oneFifthSanity),void 0!==actor.system.attribs.mp.max&&null!==actor.system.attribs.mp.max||(updateData["system.attribs.mp.max"]=oneFifthSanity)),void 0!==actor.system.notes&&null!==actor.system.notes||(updateData["system.notes"]="")}return updateData}static _migrateMacroArtwork(table,updateData){const image=String(table.img).match(/systems\/CoC7\/artwork\/icons\/(.+)/);return null!==image&&(updateData.img="systems/CoC7/assets/icons/"+image[1]),updateData}static _migrateTableArtwork(table,updateData){let image=String(table.img).match(/systems\/CoC7\/artwork\/icons\/(.+)/);null!==image&&(updateData.img="systems/CoC7/assets/icons/"+image[1]);for(const[k,v]of Object.entries(table.results))image=String(v.img).match(/systems\/CoC7\/artwork\/icons\/(.+)/),null!==image&&(void 0===updateData.results&&(updateData.results=table.results),updateData.results[k].img="systems/CoC7/assets/icons/"+image[1]);return updateData}static _migrateTokenArtwork(token,updateData){const image=String(token.img).match(/systems\/CoC7\/artwork\/icons\/(.+)/);return null!==image&&(updateData.img="systems/CoC7/assets/icons/"+image[1]),updateData}}function _onLeftClick(event){return event.shiftKey}function showDialog(){new Dialog({title:game.i18n.localize("CoC7.Migrate.TriggerTitle"),content:game.i18n.localize("CoC7.Migrate.TriggerContents"),buttons:{migrate:{icon:'<i class="fas fa-check"></i>',label:game.i18n.localize("CoC7.Migrate.TriggerRestart"),callback:async()=>{await game.settings.set("CoC7","systemUpdateVersion",0),window.location.reload()}},close:{icon:'<i class="fas fa-ban"></i>',label:game.i18n.localize("Cancel"),callback:()=>{}}},default:"close"},{}).render(!0)}function createTitleNode(text){const title=document.createElement("h2");return title.classList.add("setting-header"),title.innerText=game.i18n.localize(text),title}async function gmcreatemessageas(data){const meleeTarget=new CoC7MeleeTarget(data.targetKey,data.messageId,data.fastForward);meleeTarget.initiatorKey=data.actorKey;return await meleeTarget.createChatCard()}async function gmtradeitemto(data){try{let actor;actor=data.scene?game.scenes.get(data.scene).tokens.get(data.actorFrom).actor:game.actors.get(data.actorFrom);const item=actor.items.get(data.item);await game.actors.get(data.actorTo).createEmbeddedDocuments("Item",[item.toJSON()])&&actor.deleteEmbeddedDocuments("Item",[item.id])}catch(e){return ui.notifications.error(e),!1}return!0}Hooks.once("init",(function(){if(foundry.utils.isNewerVersion(game.version,"13")){const link=document.createElement("link");link.setAttribute("href","https://fonts.googleapis.com/css?family=Noto%20Sans|Voltaire|Lusitana"),link.setAttribute("rel","stylesheet"),link.setAttribute("type","text/css"),link.setAttribute("media","all"),document.head.append(link)}game.CoC7={macros:{skillCheck:CoC7Utilities.skillCheckMacro,weaponCheck:CoC7Utilities.weaponCheckMacro,check:CoC7Utilities.checkMacro,linkMacro:CoC7Link.linkMacro},cards:{DamageCard},dev:{dice:{alwaysCrit:!1,alwaysFumble:!1}},eras:(era,name)=>{COC7.eras[era]=name},tables:{},ClickRegionLeftUuid:CoC7ClickableEvents.ClickRegionLeftUuid,ClickRegionRightUuid:CoC7ClickableEvents.ClickRegionRightUuid,hasPermissionDocument:CoC7ClickableEvents.hasPermissionDocument,InSceneRelativeTeleport:CoC7ClickableEvents.InSceneRelativeTeleport,MapPinToggle:CoC7ClickableEvents.MapPinToggle,openDocument:CoC7ClickableEvents.openDocument,toggleTileJournalPages:CoC7ClickableEvents.toggleTileJournalPages,toScene:CoC7ClickableEvents.toScene},Combat.prototype.rollInitiative=rollInitiative,CONFIG.ActiveEffect.documentClass=CoC7ActiveEffect,CONFIG.Actor.documentClass=CoCActor,CONFIG.Actor.documentClasses={vehicle:CoC7Vehicle},CONFIG.Item.documentClass=CoC7Item,CONFIG.Item.documentClasses={book:CoC7Book,spell:CoC7Spell,chase:CoC7Chase,skill:CoC7Skill},async function(){(foundry.applications.handlebars?.loadTemplates??loadTemplates)(["systems/CoC7/templates/actors/parts/npc-skills.html","systems/CoC7/templates/actors/parts/npc-combat.html","systems/CoC7/templates/actors/parts/actor-inventory.html","systems/CoC7/templates/actors/parts/actor-inventory-items.html","systems/CoC7/templates/actors/parts/actor-background.html","systems/CoC7/templates/common/active-effects.hbs","systems/CoC7/templates/actors/parts/actor-mythos-enounters.hbs","systems/CoC7/templates/actors/parts/actor-keeper-mythos-enounters.hbs","systems/CoC7/templates/actors/parts/actor-skills-v2.html","systems/CoC7/templates/actors/parts/character-development-v2.html","systems/CoC7/templates/actors/parts/development-controls.html","systems/CoC7/templates/actors/parts/vitals.html","systems/CoC7/templates/actors/parts/combat.html","systems/CoC7/templates/actors/character-sheet-v2.html","systems/CoC7/templates/actors/character/summary.html","systems/CoC7/templates/items/book/details.html","systems/CoC7/templates/items/spell/details.html","systems/CoC7/templates/apps/investigator-wizard/introduction.hbs","systems/CoC7/templates/apps/investigator-wizard/configuration.hbs","systems/CoC7/templates/apps/investigator-wizard/select-setup.hbs","systems/CoC7/templates/apps/investigator-wizard/select-archetype.hbs","systems/CoC7/templates/apps/investigator-wizard/select-occupation.hbs","systems/CoC7/templates/apps/investigator-wizard/set-characteristics.hbs","systems/CoC7/templates/apps/investigator-wizard/set-attributes.hbs","systems/CoC7/templates/apps/investigator-wizard/view-attributes.hbs","systems/CoC7/templates/apps/investigator-wizard/set-investigator.hbs","systems/CoC7/templates/apps/investigator-wizard/set-occupation-skills.hbs","systems/CoC7/templates/apps/investigator-wizard/toggle-skill.hbs","systems/CoC7/templates/apps/investigator-wizard/set-archetype-skills.hbs","systems/CoC7/templates/apps/investigator-wizard/points-skills.hbs","systems/CoC7/templates/apps/investigator-wizard/backstory.hbs","systems/CoC7/templates/apps/investigator-wizard/create.hbs","systems/CoC7/templates/chat/messages/roll-container.hbs","systems/CoC7/templates/chat/messages/roll-dice.hbs","systems/CoC7/templates/actors/parts/actor-picture-frame-v3.hbs","systems/CoC7/templates/actors/parts/actor-characteristics-v3.hbs","systems/CoC7/templates/actors/parts/actor-development-v3.hbs","systems/CoC7/templates/actors/parts/actor-skills-v3.hbs","systems/CoC7/templates/actors/parts/actor-combat-v3.hbs","systems/CoC7/templates/actors/parts/actor-possessions-v3.hbs","systems/CoC7/templates/actors/parts/actor-background-v3.hbs","systems/CoC7/templates/actors/parts/actor-keeper-notes-v3.hbs","systems/CoC7/templates/actors/parts/actor-active-effects-v3.hbs"])}(),function(){if(game.settings.registerMenu("CoC7","gameRules",{name:"CoC7.Settings.Rules.Name",label:"CoC7.Settings.Rules.Label",hint:"CoC7.Settings.Rules.Hint",icon:"fas fa-book",type:CoC7GameRuleSettings,restricted:!0}),CoC7GameRuleSettings.registerSettings(),game.settings.register("CoC7","useContextMenus",{name:"SETTINGS.UseContextMenus",hint:"SETTINGS.UseContextMenusHint",scope:"world",config:!0,type:Boolean,default:!1}),game.settings.register("CoC7","dholeUploadDirectory",{name:"CoC7.Settings.DholeUpload.Directory.Name",hint:"CoC7.Settings.DholeUpload.Directory.Hint",scope:"world",config:!0,type:String,default:(foundry.utils.isNewerVersion(game.version,"12")?"":"[data] ")+"worlds/"+game.world.id+"/dhole-images"}),game.settings.register("CoC7","worldEra",{name:"CoC7.Settings.WorldEra.Name",hint:"CoC7.Settings.WorldEra.Hint",scope:"world",config:!0,default:"standard",type:String,choices:COC7.eras,onChange:()=>{ui.players.render(!0)}}),game.settings.register("CoC7","showWorldEra",{name:"CoC7.Settings.ShowWorldEra.Name",hint:"CoC7.Settings.ShowWorldEra.Hint",scope:"world",config:!0,default:!0,type:Boolean,onChange:()=>{ui.players.render(!0)}}),game.settings.register("CoC7","dropCoCID",{name:"CoC7.Settings.DropCoCID.Name",hint:"CoC7.Settings.DropCoCID.Hint",scope:"world",config:!0,default:"",type:String,choices:{"":"CoC7.Settings.DropCoCID.Prompt",Y:"CoC7.Settings.DropCoCID.UseCoCID",N:"CoC7.Settings.DropCoCID.IgnoreCoCID"}}),game.settings.register("CoC7","displayInitDices",{name:"SETTINGS.displayInitDices",hint:"SETTINGS.displayInitDicesHint",scope:"world",config:!0,default:!0,type:Boolean}),game.settings.register("CoC7","displayInitAsText",{name:"SETTINGS.displayInitAsText",hint:"SETTINGS.displayInitAsTextHint",scope:"world",config:!0,default:!0,type:Boolean}),game.settings.register("CoC7","stanbyGMRolls",{name:"SETTINGS.StanbyGMRolls",hint:"SETTINGS.StanbyGMRollsHint",scope:"world",config:!0,default:!0,type:Boolean}),game.settings.register("CoC7","allowFlatDiceModifier",{name:"SETTINGS.AllowFlatDiceModifier",hint:"SETTINGS.AllowFlatDiceModifierHint",scope:"world",config:!0,default:!1,type:Boolean}),game.settings.register("CoC7","allowFlatThresholdModifier",{name:"SETTINGS.AllowFlatThresholdModifier",hint:"SETTINGS.AllowFlatThresholdModifierHint",scope:"world",config:!0,default:!1,type:Boolean}),game.settings.register("CoC7","defaultCheckDifficulty",{name:"SETTINGS.DefaultDifficulty",hint:"SETTINGS.DefaultDifficultyHint",scope:"world",config:!0,default:"regular",type:String,choices:{regular:"SETTINGS.CheckDifficultyRegular",unknown:"SETTINGS.CheckDifficultyUnknown"}}),game.settings.register("CoC7","selfRollWhisperTarget",{name:"SETTINGS.SelfRollWhisperTarget",hint:"SETTINGS.SelfRollWhisperTargetHint",scope:"world",config:!0,default:"everyone",type:String,choices:{nobody:"SETTINGS.DoNotAdvise",owners:"SETTINGS.AdviseOwnersOnly",everyone:"SETTINGS.AdviseAllPlayer"}}),game.settings.register("CoC7","trustedCanModfyChatCard",{name:"SETTINGS.TrustedCanModfyChatCard",hint:"SETTINGS.TrustedCanModfyChatCardHint",scope:"world",config:!0,default:!1,type:Boolean}),game.settings.register("CoC7","trustedCanSeeChatCard",{name:"SETTINGS.TrustedCanSeeChatCard",hint:"SETTINGS.TrustedCanSeeChatCardHint",scope:"world",config:!0,default:!1,type:Boolean}),game.settings.register("CoC7","displayActorOnCard",{name:"SETTINGS.DisplayActorOnCard",hint:"SETTINGS.DisplayActorOnCardHint",scope:"world",config:!0,default:!1,type:Boolean}),game.settings.register("CoC7","displayCheckSuccessLevel",{name:"SETTINGS.DisplayCheckSuccessLevel",scope:"client",config:!0,default:!0,type:Boolean}),game.settings.register("CoC7","displayResultType",{name:"SETTINGS.DisplayResultType",scope:"client",config:!0,default:!1,type:Boolean}),game.settings.register("CoC7","useToken",{name:"SETTINGS.UseToken",hint:"SETTINGS.UseTokenHint",scope:"world",config:!0,default:!1,type:Boolean}),game.settings.register("CoC7","enableStatusIcons",{name:"SETTINGS.EnableStatusIcons",hint:"SETTINGS.EnableStatusIconsHint",scope:"world",config:!0,type:Boolean,default:!0}),game.settings.register("CoC7","gridSpaces",{name:"SETTINGS.RestrictGridSpaces",hint:"SETTINGS.RestrictGridSpacesHint",scope:"world",config:!0,default:!1,type:Boolean}),game.settings.register("CoC7","distanceElevation",{name:"SETTINGS.CheckElevation",hint:"SETTINGS.CheckElevationHint",scope:"world",config:!0,default:!0,type:Boolean}),game.settings.register("CoC7","distanceTheatreOfTheMind",{name:"SETTINGS.SceneDistanceNotCalcualtedNoError",hint:"SETTINGS.SceneDistanceNotCalcualtedNoErrorHint",scope:"world",config:!0,default:!1,type:Boolean}),game.settings.register("CoC7","tokenDropMode",{name:"SETTINGS.TokenDropMode",hint:"SETTINGS.TokenDropModeHint",scope:"world",config:!0,default:"ask",type:String,choices:{ask:"SETTINGS.TokenDropModeAsk",roll:"SETTINGS.TokenDropModeRoll",average:"SETTINGS.TokenDropModeAverage",ignore:"SETTINGS.TokenDropModeIgnore"}}),game.settings.register("CoC7","overrideGameArtwork",{name:"SETTINGS.OverrideGameArtwork",hint:"SETTINGS.OverrideGameArtworkHint",scope:"world",config:!0,default:!1,type:Boolean}),game.settings.get("CoC7","overrideGameArtwork")&&(game.settings.register("CoC7","artPauseImage",{name:"SETTINGS.ArtPauseImage",hint:"SETTINGS.ArtPauseImageHint",scope:"world",config:!0,default:"systems/CoC7/assets/icons/time-trap.svg",type:String}),game.settings.register("CoC7","artPauseText",{name:"SETTINGS.ArtPauseText",hint:"SETTINGS.ArtPauseTextHint",scope:"world",config:!0,default:"The Blind Idiot God is dreaming...",type:String})),game.settings.register("CoC7","displayPlayerNameOnSheet",{name:"SETTINGS.displayPlayerNameOnSheet",scope:"world",config:!0,default:!1,type:Boolean}),game.settings.register("CoC7","toolTipDelay",{name:"CoC7.toolTipDelay",scope:"world",config:!0,default:1500,type:Number}),game.settings.register("CoC7","hidePartValues",{name:"SETTINGS.hidePartValues",scope:"world",config:!0,default:!1,type:Boolean}),game.settings.register("CoC7","showIconsOnly",{name:"SETTINGS.showIconsOnly",scope:"world",config:!0,default:!1,type:Boolean}),game.settings.register("CoC7","playerUnlockSheetMode",{name:"SETTINGS.PlayerUnlockSheetMode",scope:"world",config:!0,default:"always",type:String,choices:{always:"SETTINGS.AlwaysEditable",creation:"SETTINGS.CreationModeOnly",never:"SETTINGS.NeverEditable"}}),game.settings.register("CoC7","statusPlayerEditable",{name:"SETTINGS.StatusPlayerEditable",hint:"SETTINGS.StatusPlayerEditableHint",scope:"world",config:!0,default:!0,type:Boolean}),game.settings.register("CoC7","oneBlockBackstory",{name:"SETTINGS.OneBlockBackStory",hint:"SETTINGS.OneBlockBackStoryHint",scope:"world",config:!0,default:!1,type:Boolean}),game.settings.register("CoC7","overrideSheetArtwork",{name:"SETTINGS.OverrideSheetArtwork",hint:"SETTINGS.OverrideSheetArtworkHint",scope:"world",config:!0,default:!1,type:Boolean}),game.settings.get("CoC7","overrideSheetArtwork")){function _setRootFontSize(size){$(":root").css("font-size",size),ui.sidebar.render(!0);for(const[,w]of Object.entries(ui.windows))w.render(!0)}game.settings.register("CoC7","artWorkSheetBackground",{name:"SETTINGS.ArtWorkSheetBackground",hint:"SETTINGS.ArtWorkSheetBackgroundHint",scope:"world",config:!0,default:"url('./assets/images/background.webp') 4 repeat",type:String}),game.settings.register("CoC7","artWorkSheetBackgroundType",{name:"SETTINGS.ArtWorkSheetBackgroundType",scope:"world",config:!0,default:"slice",type:String,choices:{slice:"SETTINGS.BackgroundSlice",auto:"SETTINGS.BackgroundAuto",contain:"SETTINGS.BackgroundContain",cover:"SETTINGS.BackgroundCover"}}),game.settings.register("CoC7","artWorkOtherSheetBackground",{name:"SETTINGS.ArtWorkOtherSheetBackground",hint:"SETTINGS.ArtWorkOtherSheetBackgroundHint",scope:"world",config:!0,default:"url( './assets/images/background.webp')",type:String}),game.settings.register("CoC7","artworkSheetImage",{name:"SETTINGS.ArtworkSheetImage",hint:"SETTINGS.ArtworkSheetImageHint",scope:"world",config:!0,default:"url('./assets/images/tentacles.webp')",type:String}),game.settings.register("CoC7","artworkFrontColor",{name:"SETTINGS.ArtworkFrontColor",hint:"SETTINGS.ArtworkFrontColorHint",scope:"world",config:!0,default:"rgba(43,55,83,1)",type:String}),game.settings.register("CoC7","artworkBackgroundColor",{name:"SETTINGS.ArtworkBackgroundColor",hint:"SETTINGS.ArtworkBackgroundColorHint",scope:"world",config:!0,default:"rgba(103,11,11,1)",type:String}),game.settings.register("CoC7","artworkInteractiveColor",{name:"SETTINGS.ArtworkInteractiveColor",hint:"SETTINGS.ArtworkInteractiveColorHint",scope:"world",config:!0,default:"rgba(103,11,11,1)",type:String}),game.settings.register("CoC7","artworkFixedSkillLength",{name:"SETTINGS.ArtworkFixedSkillLength",hint:"SETTINGS.ArtworkFixedSkillLengthHint",scope:"world",config:!0,default:!0,type:Boolean}),game.settings.register("CoC7","artworkMainFont",{name:"SETTINGS.ArtworkMainFont",scope:"world",config:!0,default:"",type:String}),game.settings.register("CoC7","artworkMainFontBold",{name:"SETTINGS.ArtworkMainFontBold",scope:"world",config:!0,default:"",type:String}),game.settings.register("CoC7","artworkMainFontSize",{name:"SETTINGS.ArtworkMainFontSize",scope:"world",config:!0,default:16,type:Number,onChange:size=>_setRootFontSize(size)})}if(game.settings.register("CoC7","disregardUsePerRound",{name:"SETTINGS.DisregardUsePerRound",hint:"SETTINGS.DisregardUsePerRoundHint",scope:"world",config:!0,default:!1,type:Boolean}),game.settings.register("CoC7","disregardAmmo",{name:"SETTINGS.DisregardAmmo",hint:"SETTINGS.DisregardAmmoHint",scope:"world",config:!0,default:!1,type:Boolean}),game.settings.register("CoC7","disregardNoTargets",{name:"SETTINGS.DoNotPromptNoTargetSelected",hint:"SETTINGS.DoNotPromptNoTargetSelectedHit",scope:"world",config:!0,default:!1,type:Boolean}),game.modules.get("dice-so-nice")?.active){game.settings.register("CoC7","syncDice3d",{name:"SETTINGS.SyncDice3D",hint:"SETTINGS.SyncDice3DHint",scope:"world",config:!0,default:!0,type:Boolean});const[version]=game.modules.get("dice-so-nice")?.version.split(".");!isNaN(Number(version))&&Number(version)>=3&&(game.settings.register("CoC7","tenDieBonus",{name:"SETTINGS.TenDieBonus",hint:"SETTINGS.TenDieBonusHint",scope:"client",config:!0,default:"bronze",type:String}),game.settings.register("CoC7","tenDiePenalty",{name:"SETTINGS.TenDiePenalty",hint:"SETTINGS.TenDiePenaltyHint",scope:"client",config:!0,default:"bloodmoon",type:String}))}game.settings.register("CoC7","debugmode",{name:"SETTINGS.DebugMode",hint:"SETTINGS.DebugModeHint",scope:"client",config:!0,type:Boolean,default:!1}),game.settings.register("CoC7","experimentalFeatures",{name:"SETTINGS.ShowExperimentalFeatures",hint:"SETTINGS.ShowExperimentalFeaturesHint",scope:"world",config:!0,type:Boolean,default:!1}),game.settings.register("CoC7","hiddendevmenu",{name:"Hidden dev menu",hint:"Use at your own risk",scope:"world",config:!1,type:Boolean,default:!1}),game.settings.register("CoC7","developmentEnabled",{name:"Dev phased allowed",scope:"world",config:!1,type:Boolean,default:!1}),game.settings.register("CoC7","showWelcomeMessage",{name:"SETTINGS.showWelcomeMessage",hint:"SETTINGS.showWelcomeMessage",scope:"world",config:!1,default:!0,type:Boolean}),game.settings.register("CoC7","charCreationEnabled",{name:"Char creation allowed",scope:"world",config:!1,type:Boolean,default:!1}),game.settings.register("CoC7","systemUpdateVersion",{name:"System update version",scope:"world",config:!1,type:String,default:"0"}),game.settings.register("CoC7","systemUpdatedModuleVersion",{scope:"world",config:!1,default:{}}),game.settings.register("CoC7","xpEnabled",{name:"Enable XP gain",scope:"world",config:!1,type:Boolean,default:!0}),game.settings.register("CoC7","showInstructions",{name:"Show changelog/instructions",scope:"world",config:!1,type:String,default:"0"}),game.settings.register("CoC7","InvestigatorWizardSetup",{name:"Force specific setup CoC ID for Investigator Wizard",scope:"world",config:!1,type:String,default:""}),game.settings.register("CoC7","InvestigatorWizardQuantity",{name:"Number of investigators a single user without create actor rights can own",scope:"world",config:!1,type:Number,default:0}),game.settings.register("CoC7","InvestigatorWizardOwnership",{name:"Default permissions for non owner players",scope:"world",config:!1,type:Number,default:CONST.DOCUMENT_OWNERSHIP_LEVELS.NONE}),game.settings.register("CoC7","InvestigatorWizardRerolls",{name:"Allow players to reroll characteristics",scope:"world",config:!1,type:Boolean,default:!1}),game.settings.register("CoC7","InvestigatorWizardPointBuy",{name:"Force point buy instead of setup choice",scope:"world",config:!1,type:Boolean,default:!1}),game.settings.register("CoC7","InvestigatorWizardQuickFire",{name:"Quick fire setup values",scope:"world",config:!1,type:Array,default:[]}),game.settings.register("CoC7","InvestigatorWizardChooseValues",{name:"Choose where to place rolled characteristics",scope:"world",config:!1,type:Boolean,default:!1}),CONFIG.Combat.initiative={formula:"@characteristics.dex.value",decimals:4},CONFIG.debug.hooks=!!game.settings.get("CoC7","debugmode"),CONFIG.Dice.terms.t=CoC7DecaderDie,CONFIG.Dice.terms.o=CoC7DecaderDieOther}(),function(){const ActorsPolyfill=foundry.documents.collections?.Actors??Actors,ItemsPolyfill=foundry.documents.collections?.Items??Items;ActorsPolyfill.unregisterSheet("core",foundry.appv1.sheets.ActorSheet),ActorsPolyfill.registerSheet("CoC7",CoC7NPCSheet,{types:["npc"],makeDefault:!0}),ActorsPolyfill.registerSheet("CoC7",CoC7VehicleSheet,{types:["vehicle"],makeDefault:!0}),ActorsPolyfill.registerSheet("CoC7",CoC7CreatureSheet,{types:["creature"],makeDefault:!0}),ActorsPolyfill.registerSheet("CoC7",CoC7ContainerSheet,{types:["container"],makeDefault:!0}),ActorsPolyfill.registerSheet("CoC7",CoC7CharacterSheet,{types:["character"]}),ActorsPolyfill.registerSheet("CoC7",CoC7CharacterSheetMinimized,{types:["character"]}),ActorsPolyfill.registerSheet("CoC7",CoC7CharacterSheetV3,{types:["character"],makeDefault:!0}),ItemsPolyfill.unregisterSheet("core",foundry.appv1.sheets.ItemSheet),ItemsPolyfill.registerSheet("CoC7",CoC7SkillSheet,{types:["skill"],makeDefault:!0}),ItemsPolyfill.registerSheet("CoC7",CoC7WeaponSheet,{types:["weapon"],makeDefault:!0}),ItemsPolyfill.registerSheet("CoC7",CoC7BookSheet,{types:["book"],makeDefault:!0}),ItemsPolyfill.registerSheet("CoC7",CoC7SpellSheet,{types:["spell"],makeDefault:!0}),ItemsPolyfill.registerSheet("CoC7",CoC7TalentSheet,{types:["talent"],makeDefault:!0}),ItemsPolyfill.registerSheet("CoC7",CoC7StatusSheet,{types:["status"],makeDefault:!0}),ItemsPolyfill.registerSheet("CoC7",CoC7OccupationSheet,{types:["occupation"],makeDefault:!0}),ItemsPolyfill.registerSheet("CoC7",CoC7ArchetypeSheet,{types:["archetype"],makeDefault:!0}),ItemsPolyfill.registerSheet("CoC7",CoC7SetupSheet,{types:["setup"],makeDefault:!0}),ItemsPolyfill.registerSheet("CoC7",CoC7ChaseSheet,{types:["chase"],makeDefault:!0}),ItemsPolyfill.registerSheet("CoC7",CoC7ArmorSheet,{types:["armor"],makeDefault:!0}),ItemsPolyfill.registerSheet("CoC7",CoC7ExperiencePackageSheet,{types:["experiencePackage"],makeDefault:!0}),ItemsPolyfill.registerSheet("CoC7",CoC7ItemSheet,{types:["item"]}),ItemsPolyfill.registerSheet("CoC7",CoC7ItemSheetV2,{types:["item"],makeDefault:!0})}(),Handlebars.registerHelper("rollActorImg",(function(actorKey){return chatHelper.getActorImgFromKey(actorKey)||"../icons/svg/mystery-man-black.svg"})),Handlebars.registerHelper("localizeRollName",(function(options){const difficulty=options.hash.difficulty!==CoC7Check.difficultyLevel.regular&&CoC7Check.difficultyString(options.hash.difficulty),modifier=options.hash.modifier>0?`+${options.hash.modifier}`:options.hash.modifier<0&&options.hash.modifier.toString();return game.i18n.format("CoC7.LinkCheck"+(difficulty?"Diff":"")+(modifier?"Modif":"")+(options.hash.pushing?"Pushing":""),{difficulty,modifier,name:options.hash.name})})),Handlebars.registerHelper("calcHard",(function(value){return value.toString().match(/^\d+$/)?Math.floor(value/2):0})),Handlebars.registerHelper("calcExtreme",(function(value){return value.toString().match(/^\d+$/)?Math.floor(value/5):0})),Handlebars.registerHelper("selectValue",(function(choices,selected,valueAttr,labelAttr){if(void 0!==choices&&"function"==typeof choices.find){const found=choices.find((o=>o[valueAttr]===selected&&void 0!==o[labelAttr]));if(found)return found[labelAttr]}return""})),oldSearchFilter=(foundry.applications.sidebar?.apps.Compendium??Compendium).prototype._onSearchFilter,foundry.utils.isNewerVersion(game.version,"13")?(foundry.applications.sidebar?.apps.Compendium??Compendium).prototype._onSearchFilter=_onSearchFilter:(foundry.applications.sidebar?.apps.Compendium??Compendium).prototype._onSearchFilter=_onSearchFilterV12,Hooks.on("renderCompendium",(async(app,html,data)=>{if("Item"===app.collection.documentName){app.collection.indexed||await app.collection.getIndex();const types=[...new Set(app.collection.index.filter((i=>"#[CF_tempEntity]"!==i.name)).map((item=>item.type)))],select=[],selectedType=app.options.filterCoC7?.type??"",selectedEra=app.options.filterCoC7?.era??"";select.push('<option value="">'+game.i18n.localize("CoC7.All")+"</option>");const groupTypes=[{key:"archetype",name:"CoC7.Entities.Archetype"},{key:"book",name:"CoC7.Entities.Book"},{key:"item",name:"CoC7.Entities.Item"},{key:"occupation",name:"CoC7.Entities.Occupation"},{key:"setup",name:"CoC7.Entities.Setup"},{key:"skill",name:"CoC7.Entities.Skill"},{key:"spell",name:"CoC7.Entities.Spell"},{key:"status",name:"CoC7.Entities.Status"},{key:"talent",name:"CoC7.Entities.Talent"},{key:"weapon",name:"CoC7.Entities.Weapon"}];for(const groupType of groupTypes)types.includes(groupType.key)&&select.push('<option value="'+groupType.key+'"'+(selectedType===groupType.key?' selected="selected"':"")+">"+game.i18n.localize(groupType.name)+"</option>");const eras=[];eras.push('<option value="">'+game.i18n.localize("CoC7.All")+"</option>");for(const era of Object.entries(COC7.eras).map((e=>({id:e[0],name:game.i18n.localize(e[1])}))).sort(CoC7Utilities.sortByNameKey))eras.push('<option value="'+era.id+'"'+(selectedEra===era.id?' selected="selected"':"")+">"+era.name+"</option>");let uncommon=game.i18n.localize("CoC7.SkillRarityShort");"CoC7.SkillRarityShort"===uncommon&&(uncommon="??");let directoryItems=!1,keyName=!1;if(foundry.utils.isNewerVersion(game.version,"13")?(directoryItems=html.querySelectorAll("li.directory-item"),keyName="entryId"):(directoryItems=html.find("li.directory-item"),keyName="documentId"),directoryItems)for(const directoryItem of directoryItems){const item=app.collection.index.get(directoryItem.dataset[keyName]);item&&"skill"===item.type&&(directoryItem.querySelector("a").innerHTML=item.name+" ("+(item.system?.base??"?")+"%)"+(item.system?.properties?.rarity?" "+uncommon:""))}try{const header=html.querySelector("header.directory-header search");{const search=document.createElement("search");search.classList.add("compendiumSearchfilter","era_select"),search.style.display="none",search.innerHTML='<i class="fa-regular fa-calendar"></i><select name="coc7era">'+eras.join("")+"</select>",header.after(search)}{const search=document.createElement("search");search.classList.add("compendiumSearchfilter"),search.innerHTML='<i class="fas fa-layer-group"></i><select name="coc7type">'+select.join("")+"</select>",header.after(search)}const selects=html.querySelectorAll("header.directory-header search select");for(const select of selects)select.onchange=event=>{const input=event.target.closest("header").querySelector("search input"),newEvent=new Event("input",{bubbles:!0});input.dispatchEvent(newEvent)}}catch(e){const header=html[0].querySelector("header.directory-header"),search=document.createElement("search");search.classList.add("compendiumfilter"),search.innerHTML='<div class="compendiumfilter"><div class="header-search flexrow-coc7"><i class="fas fa-layer-group"></i><select name="coc7type">'+select.join("")+'</select></div><div class="header-search flexrow-coc7 era_select" style="display:none"><i class="fa-regular fa-calendar"></i><select name="coc7era">'+eras.join("")+"</select></div></div>",header.after(search),html.find("select").change(app.options.filters[0].callback.bind(app))}}})),CoCID.init(),CoC7Link.init(),Hooks.once("diceSoNiceReady",dice_so_nice_ready_last),CoC7ClickableEvents.initSelf(),CONFIG.TextEditor.enrichers.push({pattern:/@chaosiumUUID\[([^#\]]+)(?:#([^\]]+))?](?:{([^}]+)})?/gi,enricher:async(match,{relativeTo}={})=>{const[selectors,hash,name]=match.slice(1,4);let data={name,classes:["content-link","broken"],icon:"fas fa-unlink"};const parts=selectors?.split(/\s*,\s*/);if(parts){const keys=parts.reduce(((c,i)=>{const keyval=i.match(/^(([^:]+):)(.+)?$/);return keyval?c[keyval[2]]=keyval[3]:c.uuid=i,c}),{});if(keys.uuid){const doc=await fromUuid(keys.uuid,{relative:relativeTo});if(doc&&(data={name:name||doc.name||keys.uuid,classes:["content-link"],dataset:{link:"",uuid:doc.uuid,id:doc.id,type:doc.documentName},icon:keys.icon??CONFIG[doc.documentName].sidebarIcon},hash&&(data.dataset.hash=hash),keys.img)){const a=document.createElement("a");a.classList.add(data.classes);for(const[k,v]of Object.entries(data.dataset))null!=v&&(a.dataset[k]=v);return a.innerHTML=`<img src="${keys.img}" height="16px" style="vertical-align:bottom;border:0;">${data.name}`,a}}}return TextEditor.createAnchor(data)}}),void 0===CONFIG.Token.movement&&(CONFIG.Token.movement={actions:{walk:{label:"TOKEN.MOVEMENT.ACTIONS.walk.label",icon:"fa-solid fa-person-walking",order:0},fly:{label:"TOKEN.MOVEMENT.ACTIONS.fly.label",icon:"fa-solid fa-person-fairy",order:1},swim:{label:"TOKEN.MOVEMENT.ACTIONS.swim.label",icon:"fa-solid fa-person-swimming",order:2},burrow:{label:"TOKEN.MOVEMENT.ACTIONS.burrow.label",icon:"fa-solid fa-person-digging",order:3},crawl:{label:"TOKEN.MOVEMENT.ACTIONS.crawl.label",icon:"fa-solid fa-person-praying",order:4},climb:{label:"TOKEN.MOVEMENT.ACTIONS.climb.label",icon:"fa-solid fa-person-through-window",order:5},jump:{label:"TOKEN.MOVEMENT.ACTIONS.jump.label",icon:"fa-solid fa-person-running-fast",order:6},blink:{label:"TOKEN.MOVEMENT.ACTIONS.blink.label",icon:"fa-solid fa-person-from-portal",order:7},displace:{label:"TOKEN.MOVEMENT.ACTIONS.displace.label",icon:"fa-solid fa-transporter-1",order:8}}})})),Hooks.once("ready",(async function(){console.log("Call of Cthulhu 7th Edition | Ready"),game.settings.get("CoC7","showWelcomeMessage")&&game.user.isGM,game.CoC7Tooltips=new CoC7Tooltips;const instructionsVersion=game.settings.get("CoC7","showInstructions");let lang=game.i18n.lang;const readMe={de:"PIUXjbPhnfLtqw3I",en:"sxB2OXbfwV6M0nyQ",es:"35FM7ZOdzC6L2xlj",fr:"tdakyzTVOQsAMdSm",ja:"75sD0ovkj4TDpvzv",uk:"98TuflgZUmQoJdSK"};function _tableSettingsChanged(table,id){game.CoC7.tables[table]="none"===id?null:game.tables.get(id)}void 0===readMe[lang]&&(lang="en"),CONFIG.CoC7=CONFIG.CoC7??{},CONFIG.CoC7.Manual=readMe[lang],foundry.utils.isNewerVersion(game.system.version,instructionsVersion??"0")&&((await game.packs.get("CoC7.system-doc").getDocument(CONFIG.CoC7.Manual))?.sheet.render(!0),game.settings.set("CoC7","showInstructions",game.system.version)),async function(){try{let lang=game.i18n.lang;const tours={en:{"enable-variant-rules":EnableVariantRulesEn},fr:{"enable-variant-rules":EnableVariantRulesFr}};void 0===tours[lang]&&(lang="en");for(const tourName in tours[lang])game.tours.register("CoC7",tourName,new tours[lang][tourName])}catch(err){console.error("TOUR ERROR",err)}}(),await Updater.checkForUpdate(),function(){const body=$("body");document.addEventListener("click",CoC7ContextMenu.closeAll),body.on("click","a.coc7-inline-check",CoC7Check._onClickInlineRoll),document.addEventListener("mousedown",_onLeftClick)}(),game.CoC7.skillList=await(game.packs.get("CoC7.skills")?.getDocuments()),game.socket.on("system.CoC7",(async data=>{CoC7SystemSocket.callSocket(data)}));const tableChoice={none:"SETTINGS.LetKeeperDecide"};for(const t of game.tables)tableChoice[t._id]=t.name;game.settings.register("CoC7","boutOfMadnessSummaryTable",{name:"SETTINGS.BoutOfMadnessSummaryTable",scope:"world",config:!0,default:"none",type:String,choices:tableChoice,onChange:id=>_tableSettingsChanged("boutOfMadness_Summary",id)}),game.settings.register("CoC7","boutOfMadnessRealTimeTable",{name:"SETTINGS.BoutOfMadnessRealTimeTable",scope:"world",config:!0,default:"none",type:String,choices:tableChoice,onChange:id=>_tableSettingsChanged("boutOfMadness_RealTime",id)}),game.CoC7.tables={boutOfMadness_Summary:"none"===game.settings.get("CoC7","boutOfMadnessSummaryTable")?null:game.tables.get(game.settings.get("CoC7","boutOfMadnessSummaryTable")),boutOfMadness_RealTime:"none"===game.settings.get("CoC7","boutOfMadnessRealTimeTable")?null:game.tables.get(game.settings.get("CoC7","boutOfMadnessRealTimeTable"))}})),Hooks.once("setup",(function(){const toLocalize=["spellProperties","bookType","talentType","occupationProperties","statusType"];for(const o of toLocalize){const localized=Object.entries(COC7[o]).map((e=>[e[0],game.i18n.localize(e[1])]));COC7[o]=localized.reduce(((obj,e)=>(obj[e[0]]=e[1],obj)),{})}let effectIndex=CONFIG.statusEffects.findIndex((t=>t.id===COC7.status.dead));-1!==effectIndex&&(CONFIG.statusEffects[effectIndex].icon="systems/CoC7/assets/icons/tombstone.svg"),effectIndex=CONFIG.statusEffects.findIndex((t=>t.id===COC7.status.unconscious)),-1!==effectIndex&&(CONFIG.statusEffects[effectIndex].icon="systems/CoC7/assets/icons/knocked-out-stars.svg"),CONFIG.statusEffects.unshift({id:COC7.status.tempoInsane,name:"CoC7.BoutOfMadnessName",icon:"systems/CoC7/assets/icons/hanging-spider.svg"},{id:COC7.status.indefInsane,name:"CoC7.InsanityName",icon:"systems/CoC7/assets/icons/tentacles-skull.svg"},{id:COC7.status.criticalWounds,name:"CoC7.CriticalWounds",icon:"systems/CoC7/assets/icons/arm-sling.svg"},{id:COC7.status.dying,name:"CoC7.Dying",icon:"systems/CoC7/assets/icons/heart-beats.svg"})})),function(...cardclass){Hooks.on("renderChatLog",((app,html,data)=>EnhancedChatCardLib.injectCSS(app,html,data))),Hooks.once("socketlib.ready",(function(){EnhancedChatCardLib.register(cardclass),EnhancedChatCardLib.socket=socketlib.registerSystem(game.system.id),EnhancedChatCardLib.socket.register("updateMessage",updateMessage),EnhancedChatCardLib.socket.register("GMUpdate",GMUpdate),EnhancedChatCardLib.socket.register("advise",advise)})),Hooks.on("renderChatMessage",((app,html,data)=>EnhancedChatCard.bindListeners(html)))}(ChaseObstacleCard),Hooks.on("changeSidebarTab",(function(directory){if(directory instanceof(foundry.applications.sidebar?.tabs.ItemDirectory??ItemDirectory)){const item=game.items.find((i=>"__CoC7InternalItem__"===i.name));if(item){let itemElement=!1;try{itemElement=directory.element.querySelector(`[data-entry-id='${item.id}']`)}catch(e){itemElement=directory.element[0].querySelector(`[data-document-id='${item.id}']`)}itemElement&&(itemElement.style.display="none")}}})),Hooks.on("chatMessage",(function(chatLog,message,chatData){CoC7Utilities.ParseChatEntry(chatLog,message,chatData)})),Hooks.on("closeActorSheet",(function(application,html){application.onCloseSheet()})),Hooks.on("closeCoC7ChaseSheet",(function(app,html){CoC7ChaseSheet.onClose(app,html)})),Hooks.on("createActiveEffect",(function(data,options,userId){if(game.userId===userId){const statusKey=CoC7ActiveEffect.getStatusKey(data);if(statusKey)switch(statusKey){case COC7.status.indefInsane:case COC7.status.unconscious:case COC7.status.criticalWounds:case COC7.status.dying:case COC7.status.prone:case COC7.status.dead:data.parent.setCondition(statusKey,{forceValue:!0});break;case COC7.status.tempoInsane:{const realTime=data.flags.CoC7?.realTime;let duration=null;!0===realTime?duration=data.duration?.rounds:!1===realTime&&(duration=data.duration?.seconds,isNaN(duration)||(duration=Math.floor(duration/3600))),data.parent.setCondition(COC7.status.tempoInsane,{forceValue:!0,realTime,duration})}}}})),Hooks.on("createToken",(function(document,options,userId){if(game.user.id===userId&&("icons/svg/mystery-man.svg"===document.texture.src&&document.texture.src!==document._object.actor.img&&(document.texture.src=document._object.actor.img),"character"!==document._object.actor.type&&(document._object.actor.hasRollableCharacteristics||document._object.actor.hosRollableSkills)))switch(game.settings.get("CoC7","tokenDropMode")){case"ask":new Dialog({title:game.i18n.localize("CoC7.TokenCreationRoll.Title"),content:game.i18n.localize("CoC7.TokenCreationRoll.Prompt"),buttons:{roll:{label:game.i18n.localize("CoC7.TokenCreationRoll.ButtonRoll"),callback:async()=>{await document._object.actor.rollCharacteristicsValue(),ui.notifications.info(game.i18n.format("CoC7.TokenCreationRoll.Rolled",{name:document.object.actor.name})),document._object.actor.locked=!0}},average:{label:game.i18n.localize("CoC7.TokenCreationRoll.ButtonAverage"),callback:async()=>{await document._object.actor.averageCharacteristicsValue(),ui.notifications.info(game.i18n.format("CoC7.TokenCreationRoll.Averaged",{name:document.object.actor.name})),document._object.actor.locked=!0}},skip:{label:game.i18n.localize("CoC7.Migrate.ButtonSkip")}}}).render(!0);break;case"roll":document._object.actor.rollCharacteristicsValue(),ui.notifications.info(game.i18n.format("CoC7.TokenCreationRoll.Rolled",{name:document.object.actor.name})),document._object.actor.locked=!0;break;case"average":document._object.actor.averageCharacteristicsValue(),ui.notifications.info(game.i18n.format("CoC7.TokenCreationRoll.Averaged",{name:document.object.actor.name})),document._object.actor.locked=!0}})),Hooks.on("deleteActiveEffect",(function(data,options,userId){if(game.userId===userId){const statusKey=CoC7ActiveEffect.getStatusKey(data);if(statusKey)switch(statusKey){case COC7.status.tempoInsane:case COC7.status.indefInsane:case COC7.status.unconscious:case COC7.status.criticalWounds:case COC7.status.dying:case COC7.status.prone:case COC7.status.dead:data.parent.unsetCondition(statusKey,{forceValue:!0})}}})),Hooks.on("drawNote",(function(note){note.document.getFlag("CoC7","hide-background")&&note.controlIcon.bg.clear()})),Hooks.on("dropActorSheetData",(function(actor,sheet,data){if("Item"===data.type&&data.actorId){if(actor.data._id===data.actorId)return;let actorFrom=null;switch(actorFrom=data.sceneId&&data.tokenId?game.scenes.get(data.sceneId).tokens.get(data.tokenId).actor:game.actors.get(data.actorId),actor.data.type){case"character":case"npc":case"creature":if(!["chase"].includes(data.data.type))return;break;case"vehicle":return;case"container":if(!["book","item","spell","weapon"].includes(data.data.type))return}actorFrom&&actorFrom.deleteEmbeddedDocuments("Item",[data.data._id])}})),Hooks.on("dropCanvasData",(function(canvas,data){CoC7Canvas.onDropSomething(canvas,data)})),Hooks.on("getHeaderControlsJournalEntrySheet",get_header_controls_journal_entry_sheet),Hooks.on("getJournalSheetHeaderButtons",get_header_controls_journal_entry_sheet),Hooks.on("getHeaderControlsMacroConfig",get_header_controls_macro_config),Hooks.on("getMacroConfigHeaderButtons",get_header_controls_macro_config),Hooks.on("getHeaderControlsPlaylistConfig",get_header_controls_playlist_config),Hooks.on("getPlaylistConfigHeaderButtons",get_header_controls_playlist_config),Hooks.on("getHeaderControlsRollTableSheet",get_header_controls_roll_table_sheet),Hooks.on("getRollTableConfigHeaderButtons",get_header_controls_roll_table_sheet),Hooks.on("getHeaderControlsSceneConfig",get_header_controls_scene_config),Hooks.on("getSceneConfigHeaderButtons",get_header_controls_scene_config),Hooks.on("getSceneControlButtons",(function(controls){CoC7Menu.getButtons(controls)})),Hooks.on("hotbarDrop",(function(bar,data,slot){return CoC7Utilities.createMacro(bar,data,slot)})),Hooks.on("renderActorDirectory",(function(application,html,data){let allowWizard=game.user.hasPermission("ACTOR_CREATE");if(!allowWizard){const allowed=game.settings.get("CoC7","InvestigatorWizardQuantity");if(allowed>0){allowWizard=game.actors.filter((a=>[a.ownership.default,a.ownership[game.user.id]??CONST.DOCUMENT_OWNERSHIP_LEVELS.NONE].includes(CONST.DOCUMENT_OWNERSHIP_LEVELS.OWNER))).length<allowed}}if(allowWizard)if(foundry.utils.isNewerVersion(game.version,"13")){const menu=html.querySelector("footer.directory-footer"),link=document.createElement("a");link.classList.add("investigator-wizard"),link.textContent=game.i18n.localize("CoC7.InvestigatorWizard.Title"),menu.append(link),html.querySelector(".investigator-wizard").addEventListener("click",(()=>CoC7InvestigatorWizard.create()))}else html.find("footer.directory-footer").append('<a class="investigator-wizard">'+game.i18n.localize("CoC7.InvestigatorWizard.Title")+"</a>"),html.find(".investigator-wizard").click((()=>{CoC7InvestigatorWizard.create()}));if(game.user.hasPermission("ACTOR_CREATE"))if(foundry.utils.isNewerVersion(game.version,"13")){const menu=html.querySelector("footer.directory-footer"),link=document.createElement("a");link.classList.add("actor-import"),link.textContent=game.i18n.localize("CoC7.ActorImporter"),menu.append(link),html.querySelector(".actor-import").addEventListener("click",(()=>CoC7ActorImporterDialog.create()))}else html.find("footer.directory-footer").append('<a class="actor-import">'+game.i18n.localize("CoC7.ActorImporter")+"</a>"),html.find(".actor-import").click((()=>{CoC7ActorImporterDialog.create()}))})),Hooks.on("renderActorSheet",(function(app,html,data){CoC7CharacterSheet.renderSheet(app,html,data)})),Hooks.on("renderChatLog",(function(app,html,data){CoC7Chat.chatListeners(app,html,data)})),Hooks.on("renderChatMessage",(function(app,html,data){CoC7Chat.renderMessageHook(app,html,data),CoC7Chat.renderChatMessageHook(app,html,data),void 0!==app.flags?.CoC7?.["group-message"]&&CoC7GroupMessage.renderChatMessage(app,html,data),html.find("div.coc7-chat-toggler").click((function(){$(this).next("div.coc7-chat-toggled").slideToggle(200)}))})),Hooks.on("renderCoC7ChaseSheet",(function(app,html,data){CoC7ChaseSheet.setScroll(app,html,data)})),Hooks.on("renderCoC7CreatureSheet",(function(app,html,data){CoC7CreatureSheet.forceAuto(app,html,data)})),Hooks.on("renderCoC7DirectoryPicker",(function(app,html,options){let row=!1;try{row=html.querySelector("div.upload-file")}catch(e){row=html[0].querySelector("div.upload-file")}row&&row.remove()})),Hooks.on("renderCoC7NPCSheet",(function(app,html,data){CoC7NPCSheet.forceAuto(app,html,data)})),Hooks.on("renderCombatTracker",(function(app,html,data){CoC7Combat.renderCombatTracker(app,html,data)})),Hooks.on("renderDialog",(function(dialog,html){const form=html.find("form");if(form.is("#document-create")&&0!==form.find("select").length){const entityCreateSelectTag=form.find("[name='type']"),entitySortedList=[],showExperimental=!!game.settings.get("CoC7","experimentalFeatures");entityCreateSelectTag.children().each(((o,entityOption)=>{const key=entityOption.textContent?.capitalize();game.i18n.has(`CoC7.Entities.${key}`)&&(entityOption.textContent=game.i18n.localize(`CoC7.Entities.${key}`)),!showExperimental&&["vehicle"].includes(entityOption.value)||entitySortedList.push(entityOption)})),entityCreateSelectTag.empty(),entityCreateSelectTag.append(entitySortedList.sort(((first,second)=>first.innerText.localeCompare(second.innerText)))),"actor"===entityCreateSelectTag.val()?entityCreateSelectTag.val("character"):"book"===entityCreateSelectTag.val()&&entityCreateSelectTag.val("item")}})),Hooks.on("renderGamePause",(function(data,html,options){let imageReplaced=!1,textReplaced=!1;game.settings.get("CoC7","overrideGameArtwork")&&("null"===game.settings.get("CoC7","artPauseImage").toLowerCase()&&html.querySelector("img").remove(),""!==game.settings.get("CoC7","artPauseImage")&&(html.querySelector("img").setAttribute("src",game.settings.get("CoC7","artPauseImage")),imageReplaced=!0),""!==game.settings.get("CoC7","artPauseText")&&(html.querySelector("figcaption").innerHTML=game.settings.get("CoC7","artPauseText"),textReplaced=!0)),imageReplaced||html.querySelector("img").setAttribute("src","systems/CoC7/assets/images/timetrap2.webp"),textReplaced||(html.querySelector("figcaption").innerHTML=game.i18n.localize("CoC7.PauseName"))})),Hooks.on("renderItemSheet",(function(app,html,data){CoC7CharacterSheet.renderSheet(app,html,data)})),Hooks.on("renderJournalEntryPageTextSheet",(function(application,html,data){if(application.document.parent.getFlag("CoC7","css-adventure-entry")){html.classList.contains("coc7-adventure-entry")||html.classList.add("coc7-adventure-entry");const toggles=html.querySelectorAll("section.tmi-toggleable p.toggle");for(const toggle of toggles)toggle.onclick=event=>{const obj=$(event.currentTarget),section=obj.closest("section.tmi-toggleable").find("div.toggle:first");section.is(":visible")?(obj.text("Reveal"),section.slideUp()):(obj.text("Hide"),section.slideDown())}}})),Hooks.on("renderJournalEntrySheet",(function(application,html,data){if(application.document.getFlag("CoC7","css-adventure-entry")&&(html.classList.contains("coc7-adventure-entry")||html.classList.add("coc7-adventure-entry"),application.document.getFlag("CoC7","fixed-adventure-heading")&&!html.classList.contains("fixed-adventure-heading")&&(html.classList.add("fixed-adventure-heading"),"string"==typeof data.pages?.[0]?.id))){const subheading=application.document.pages.get(data.pages[0].id)?.flags?.CoC7?.["fixed-adventure-subheading"]??"";if(""===subheading){const div=document.createElement("div");div.style.padding="0.5em",document.querySelector("article.journal-entry-page.text.level1")?.before(div)}else{const short=0===subheading.trim().length,div=document.createElement("div");div.classList.add("adventure-heading-section","flexrow-coc7"),div.innerHTML='<div class="bookmark'+(short?" short":"")+'"><img src="systems/CoC7/assets/art/'+(short?"bookmarks.webp":"bookmark.webp")+'"></div><div class="adventure-heading"><div class="heading">'+application.title+"</div>"+(short?"":'<div class="subheading">'+subheading+"</div>")+"</div>",document.querySelector("article.journal-entry-page.text.level1")?.before(div)}}})),Hooks.on("renderJournalSheet",(function(application,html,data){if(application.document.getFlag("CoC7","css-adventure-entry")&&(html.hasClass("coc7-adventure-entry")||html.addClass("coc7-adventure-entry"),application.document.getFlag("CoC7","fixed-adventure-heading")&&!html.hasClass("fixed-adventure-heading"))){const obj=$(html);obj.addClass("fixed-adventure-heading");const subheading=data.pages?.[0]?.flags?.CoC7?.["fixed-adventure-subheading"]??"";if(""===subheading)obj.find("article.journal-entry-page.text.level1")?.before('<div style="padding: 0.5em;"></div>');else{const short=0===subheading.trim().length;obj.find("article.journal-entry-page.text.level1")?.before('<div class="adventure-heading-section flexrow-coc7"><div class="bookmark'+(short?" short":"")+'"><img src="systems/CoC7/assets/art/'+(short?"bookmarks.webp":"bookmark.webp")+'"></div><div class="adventure-heading"><div class="heading">'+data.title+"</div>"+(short?"":'<div class="subheading">'+subheading+"</div>")+"</div></div>")}}})),Hooks.on("renderJournalTextPageSheet",(function(application,html,data){application.object.parent.getFlag("CoC7","css-adventure-entry")&&(html.hasClass("coc7-adventure-entry")||(html.addClass("coc7-adventure-entry"),html.find("section.tmi-toggleable p.toggle").click((event=>{const obj=$(event.currentTarget),section=obj.closest("section.tmi-toggleable").find("div.toggle:first");section.is(":visible")?(obj.text("Reveal"),section.slideUp()):(obj.text("Hide"),section.slideDown())}))))})),Hooks.on("renderPause",(function(data,html,options){let imageReplaced=!1,textReplaced=!1;game.settings.get("CoC7","overrideGameArtwork")&&("null"===game.settings.get("CoC7","artPauseImage").toLowerCase()&&html.find("img").remove(),""!==game.settings.get("CoC7","artPauseImage")&&(html.find("img").attr("src",game.settings.get("CoC7","artPauseImage")),imageReplaced=!0),""!==game.settings.get("CoC7","artPauseText")&&(html.find("h3").html(game.settings.get("CoC7","artPauseText")),textReplaced=!0)),imageReplaced||html.find("img").attr("src","systems/CoC7/assets/images/timetrap2.webp"),textReplaced||html.find("figcaption").html(game.i18n.localize("CoC7.PauseName"))})),Hooks.on("renderPlayerList",(function(playerList,html,data){game.settings.get("CoC7","showWorldEra")&&$("<h4>").append('<div><i class="fa-regular fa-calendar"></i>'+game.i18n.format(COC7.eras[game.settings.get("CoC7","worldEra")]??"CoC7.CoCIDFlag.error.unknown-era",{era:game.settings.get("CoC7","worldEra")})+"</div>").insertAfter($("h3",html))})),Hooks.on("renderPlayers",(function(playerList,html,data){if(game.settings.get("CoC7","showWorldEra")){const div=document.createElement("div");div.classList.add("world-era","flexrow"),div.innerHTML='<i class="fa-regular fa-calendar"></i><div>'+game.i18n.format(COC7.eras[game.settings.get("CoC7","worldEra")]??"CoC7.CoCIDFlag.error.unknown-era",{era:game.settings.get("CoC7","worldEra")})+"</div>",html.querySelector("#performance-stats").after(div)}})),Hooks.on("renderSceneControls",(function(app,html,data){"function"==typeof html.querySelector&&html.querySelector('button[data-tool="coc7dummy"]')?.closest("li").remove(),CoC7Menu.renderControls(app,html,data)})),Hooks.on("renderSettings",(function(application,html,data){if(game.user.isGM)if(foundry.utils.isNewerVersion(game.version,"13")){{const menuButton=document.createElement("button");menuButton.classList.add("trigger-data-migration","fas","fa-wrench"),menuButton.textContent=game.i18n.localize("CoC7.Migrate.TriggerButton"),html.querySelector("section.settings").append(menuButton),html.querySelector(".trigger-data-migration").addEventListener("click",(()=>showDialog()))}{const menuButton=document.createElement("button");menuButton.classList.add("trigger-system-manual","fas","fa-books"),menuButton.textContent=game.i18n.localize("CoC7.System.Documentation"),html.querySelector("section.documentation").append(menuButton),html.querySelector(".trigger-system-manual").addEventListener("click",(async()=>{(await game.packs.get("CoC7.system-doc").getDocument(CONFIG.CoC7.Manual))?.sheet.render(!0)}))}}else html.find("#settings-game").append('<button class="trigger-data-migration"><i class="fas fa-wrench"></i> '+game.i18n.localize("CoC7.Migrate.TriggerButton")+"</button>"),html.find("#settings-documentation").append('<button class="trigger-system-manual"><i class="fas fa-books"></i> '+game.i18n.localize("CoC7.System.Documentation")+"</button>"),html.find(".trigger-data-migration").click((()=>showDialog())),html.find(".trigger-system-manual").click((async()=>{(await game.packs.get("CoC7.system-doc").getDocument(CONFIG.CoC7.Manual))?.sheet.render(!0)}))})),Hooks.on("renderSettingsConfig",(function(app,html,user){CoC7DirectoryPicker.processHtml(html);const systemTab=app.form.querySelector(".tab[data-tab=system]");systemTab.querySelector("input[name=CoC7\\.displayInitDices]").closest("div.form-group").before(createTitleNode("SETTINGS.TitleInitiative")),systemTab.querySelector("input[name=CoC7\\.stanbyGMRolls]").closest("div.form-group").before(createTitleNode("SETTINGS.TitleRoll")),systemTab.querySelector("input[name=CoC7\\.trustedCanModfyChatCard]").closest("div.form-group").before(createTitleNode("SETTINGS.TitleChatCards")),systemTab.querySelector("input[name=CoC7\\.enableStatusIcons]").closest("div.form-group").before(createTitleNode("SETTINGS.TitleScene")),systemTab.querySelector("input[name=CoC7\\.overrideGameArtwork]").closest("div.form-group").before(createTitleNode("SETTINGS.TitleGameArtwork")),systemTab.querySelector("input[name=CoC7\\.displayPlayerNameOnSheet]").closest("div.form-group").before(createTitleNode("SETTINGS.TitleSheet")),systemTab.querySelector("input[name=CoC7\\.disregardUsePerRound]").closest("div.form-group").before(createTitleNode("SETTINGS.TitleWeapon")),systemTab.querySelector("input[name=CoC7\\.syncDice3d]")?.closest("div.form-group").before(createTitleNode("SETTINGS.TitleDiceSoNice")),systemTab.querySelector("input[name=CoC7\\.debugmode]").closest("div.form-group").before(createTitleNode("SETTINGS.TitleDeveloperDebug")),systemTab.querySelector("select[name=CoC7\\.boutOfMadnessSummaryTable]").closest("div.form-group").before(createTitleNode("SETTINGS.TitleRollTable"))})),Hooks.on("updateChatMessage",(function(chatMessage,chatData,diff,speaker){CoC7Chat.onUpdateChatMessage(chatMessage,chatData,diff,speaker)})),Hooks.once("diceSoNiceReady",(function(dice3d){dice3d.addDicePreset({type:"dt",labels:["10","20","30","40","50","60","70","80","90","00"],fontScale:.75,system:"standard"}),dice3d.addDicePreset({type:"do",labels:["10","20","30","40","50","60","70","80","90","00"],fontScale:.75,system:"standard"})})),Hooks.on("PopOut:loaded",(function(app,node){const sheetClass=CONFIG.Actor.sheetClasses.character?.["CoC7.CoC7CharacterSheetV3"]?.cls;sheetClass&&app instanceof sheetClass&&(node.style.marginLeft="87px")})),Hooks.on("renderRealRoll",(function(app,html,options){for(const term in options.dieTerms)for(const input in options.dieTerms[term].inputs)if(options.dieTerms[term]instanceof CoC7DecaderDie){const tag=html.find('[name="'+term+"."+input+'"]');1===tag.length&&(tag[0].placeholder=game.i18n.localize("CoC7.RealRollDecaderPlaceholderName"))}})),Hooks.once("socketlib.ready",(function(){game.CoC7socket=socketlib.registerSystem("CoC7"),game.CoC7socket.register("gmcreatemessageas",gmcreatemessageas),game.CoC7socket.register("gmtradeitemto",gmtradeitemto)}))})();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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