import MyriadSystemItemBase from "./base-item.mjs";

export default class MyriadSystemFeature extends MyriadSystemItemBase {

  static defineSchema() {
    const fields = foundry.data.fields;
    const requiredInteger = { required: true, nullable: false, integer: true };
    const baseSchema = super.defineSchema();

    // Schéma des compétences avec les valeurs essentielles
    const featureSchema = {
      // Indique si c'est une capacité passive/unique ou une aptitude standard
      isPassive: new fields.BooleanField({ initial: false }),
      // Informations d'acquisition
      acquisition: new fields.SchemaField({
        prerequisites: new fields.ArrayField(new fields.StringField()),
        xpCost: new fields.NumberField({ ...requiredInteger, initial: 0, min: 0 })
      }),
      // Type de bonus accordé (caractéristique, défense, etc.)
      bonusType: new fields.StringField({ 
        choices: ["characteristic", "defense", "attack", "damage", "initiative", "other"],
        initial: "other"
      }),
      // Valeur du bonus accordé
      bonusValue: new fields.NumberField({ initial: 0 }),
      // Utilisation de la compétence
      uses: new fields.SchemaField({
        value: new fields.NumberField({ ...requiredInteger, initial: 1, min: 0 }),
        max: new fields.NumberField({ ...requiredInteger, initial: 1, min: 0 }),
        per: new fields.StringField({
          choices: ["rest", "day", "week", "month", "never"],
          initial: "day"
        })
      })
    };

    return foundry.utils.mergeObject(baseSchema, featureSchema);
  }
  
  prepareDerivedData() {
    super.prepareDerivedData();
    
    // Le coût en XP est égal au grade de la compétence par défaut
    if (this.acquisition && this.grade && !this.acquisition.xpCost) {
      this.acquisition.xpCost = this.grade;
    }
  }

}