export default class MyriadSystemDataModel extends foundry.abstract.TypeDataModel {
  /**
   * Convert the schema to a plain object.
   * 
   * The built in `toObject()` method will ignore derived data when using Data Models.
   * This additional method creates a safe copy of the data without circular references.
   * 
   * @returns {object} Plain object with all properties except functions and internal props.
   */
  toPlainObject() {
    // Use the built-in toObject method which is safe and handles circular references
    // This method already creates a clean copy without functions or circular references
    return this.toObject();
  }
}