import MyriadSystemDataModel from "./base-model.mjs";

export default class MyriadSystemActorBase extends MyriadSystemDataModel {

  static defineSchema() {
    const fields = foundry.data.fields;
    const requiredInteger = { required: true, nullable: false, integer: true };
    const schema = {};

    schema.health = new fields.SchemaField({
      value: new fields.NumberField({ ...requiredInteger, initial: 10, min: 0 }),
      max: new fields.NumberField({ ...requiredInteger, initial: 10 })
    });
    // Action Points (combat-only resource)
    // stance: 'defensive' => 5 AP, 'aggressive' => 10 AP
    schema.actionPoints = new fields.SchemaField({
      value: new fields.NumberField({ initial: 0, min: 0 }),
      max: new fields.NumberField({ initial: 0, min: 0 }),
      stance: new fields.StringField({ initial: 'defensive' })
    });
    schema.power = new fields.SchemaField({
      value: new fields.NumberField({ ...requiredInteger, initial: 5, min: 0 }),
      max: new fields.NumberField({ ...requiredInteger, initial: 5 })
    });
    schema.biography = new fields.StringField({ required: true, blank: true }); // equivalent to passing ({initial: ""}) for StringFields
    
    // Ajout des paliers surhumains comme décrit dans MODELES.md
    schema.supernaturalTiers = new fields.SchemaField({
      puissance: new fields.NumberField({ ...requiredInteger, initial: 50, min: 0 }),
      coordination: new fields.NumberField({ ...requiredInteger, initial: 50, min: 0 }),
      ingeniosite: new fields.NumberField({ ...requiredInteger, initial: 50, min: 0 }),
      perspicacite: new fields.NumberField({ ...requiredInteger, initial: 50, min: 0 })
    });

    return schema;
  }

}