import MyriadSystemDataModel from "./base-model.mjs";

export default class MyriadSystemItemBase extends MyriadSystemDataModel {

  static defineSchema() {
    const fields = foundry.data.fields;
    const requiredInteger = { required: true, nullable: false, integer: true };
    const schema = {};

    schema.description = new fields.HTMLField({ required: true, blank: true });
    
    // Tags pour catégoriser l'objet
    schema.tags = new fields.ArrayField(
      new fields.StringField({ required: true })
    );
    
    // Grade de l'objet/compétence (I à V, représenté par un chiffre)
    schema.grade = new fields.NumberField({
      ...requiredInteger,
      initial: 1,
      min: 1,
      max: 5
    });

    return schema;
  }
  
  /**
   * Préparation des données dérivées pour les objets.
   */
  prepareDerivedData() {
    super.prepareDerivedData();
    
    // Conversion du grade numérique en chiffres romains pour l'affichage
    this._displayGrade = this._getGradeNumeral(this.grade || 1);
  }

  /**
   * Convertit un nombre en chiffre romain (pour les grades I à V).
   * @param {number} num - Le nombre à convertir
   * @returns {string} - Le chiffre romain correspondant
   * @protected
   */
  _getGradeNumeral(num) {
    const romanNumerals = ["I", "II", "III", "IV", "V"];
    return romanNumerals[Math.max(0, Math.min(num - 1, 4))];
  }

}