export class TestHandler {
	constructor(beaversTests, result, actor) {
		this.beaversTests = beaversTests;
		this.result = result;
		this.initiatorData = {
			userId: game["user"].id,
			actorId: actor.id || "",
			sceneId: canvas?.scene?.id || "",
		};
		TestHandler.initialize(result, beaversTests);
	}
	static getMaxHits(beaversTests) {
		let max = 0;
		Object.values(beaversTests.ands).forEach((and) => {
			max += and.hits;
		});
		return max;
	}
	static initialize(result, beaversTests) {
		result._initTests(TestHandler.getMaxHits(beaversTests), beaversTests.fails);
	}
	getCurrentTestAnd() {
		let iterate = 0;
		for (const and of Object.values(this.beaversTests.ands)) {
			iterate += and.hits;
			if (this.result._tests.hits < iterate) {
				return and;
			}
		}
		throw Error("no Additional Tests found");
	}
	nextTest() {
		try {
			const currentTest = this.getCurrentTestAnd();
			if (Object.keys(currentTest.ors).length == 1) {
				const serializedTest = Object.values(currentTest.ors)[0];
				return this.getTest(serializedTest).render();
			}
			return "process";
		}
		catch (e) {
			return "process";
		}
	}
	hasAdditionalTests() {
		if (this.result.hasError()) {
			return false;
		}
		if (TestHandler.getMaxHits(this.beaversTests) <= this.result._tests.hits) {
			return false;
		}
		try {
			this.getCurrentTestAnd();
		}
		catch (e) {
			console.warn(e.message);
			return false;
		}
		return true;
	}
	async test() {
		const testOr = await this.selectTestChoice();
		const test = this.getTest(testOr);
		var result = await test.action(this.initiatorData);
		const testAnd = this.getCurrentTestAnd();
		var hits = Math.min(result.success, testAnd.hits);
		this.result.updateTests(hits, result.fail);
	}
	async selectTestChoice() {
		const choices = {};
		const testAnd = this.getCurrentTestAnd();
		//fix name for tool uuid !
		for (const [id, or] of Object.entries(testAnd.ors)) {
			choices[id] = { text: this.getTest(or).render() };
		}
		const choice = parseInt(await beaversSystemInterface.uiDialogSelect({ choices: choices }));
		return testAnd.ors[choice];
	}
	getTest(serializedTest) {
		return beaversSystemInterface.testClasses[serializedTest.type].create(serializedTest.data);
	}
}
