export class Initiator {
	actorId;
	sceneId;
	tokenId;
	userId;
	constructor(initiatorData) {
		Object.assign(this, initiatorData);
	}
	get token() {
		const token = canvas?.tokens?.get(this.tokenId || "");
		if (token instanceof Token) {
			return token;
		}
		throw new Error("Can not find token");
	}
	get actor() {
		const actor = game?.["actors"]?.get(this.actorId);
		if (actor instanceof Actor) {
			return actor;
		}
		throw new Error("Can not find actor");
	}
	get user() {
		const user = game?.["users"]?.get(this.userId);
		if (user instanceof User) {
			return user;
		}
		throw new Error("Can not find user");
	}
	get data() {
		return {
			actorId: this.actorId,
			sceneId: this.sceneId,
			tokenId: this.tokenId,
			userId: this.userId
		};
	}
}
