import { Settings } from './Settings.js';
import { fixReadySetRoll } from "./Dnd5e.js";
class ToolTest {
	constructor(choices) {
		this.type = "ToolTest";
		this._choices = {};
		this.informationField = {
			name: "type",
			type: "info",
			label: game['i18n'].localize("bsa-dnd5e.tests.toolTest.info.label"),
			note: game['i18n'].localize("bsa-dnd5e.tests.toolTest.info.note")
		};
		this.renderTypes = {
			tool: "setup",
			dc: "config"
		};
		this._choices = choices;
	}
	create(data) {
		const result = new ToolTestCustomized();
		result.data = data;
		result.parent = this;
		return result;
	}
	get customizationFields() {
		return {
			tool: {
				name: "tool",
				label: "tool",
				note: "Tool",
				type: "selection",
				choices: this._choices
			},
			dc: {
				name: "dc",
				label: "dc",
				note: "Difficulty Class ",
				defaultValue: 8,
				type: "number",
			}
		};
	}
}
class ToolTestCustomized {
	constructor() {
		this.action = async (initiatorData) => {
			const actor = beaversSystemInterface.initiator(initiatorData).actor;
			const originalItem = await beaversSystemInterface.uuidToDocument(this.data.tool);
			let actorComponent;
			if (originalItem) {
				const toolComponent = beaversSystemInterface.componentFromEntity(originalItem);
				const results = beaversSystemInterface.itemListComponentFind(actor.items, toolComponent);
				actorComponent = results.components[0];
			}
			if (actorComponent == undefined) {
				// @ts-ignore
				ui.notifications.warn("actor does not have this tool");
				throw Error("actor does not have this tool");
			}
			// @ts-ignore
			const item = await actorComponent.getEntity();
			let roll = await item.rollToolCheck();
			if (roll[0]?.total !== undefined) {
				roll = roll[0];
			}
			roll = fixReadySetRoll(roll);
			return {
				success: roll.total >= this.data.dc ? 1 : 0,
				fail: roll.total < this.data.dc ? 1 : 0
			};
		};
		this.render = () => {
			const tool = this.parent._choices[this.data.tool];
			if (!tool) {
				return `tool not found`;
			}
			return `<span style="overflow:hidden;text-overflow:ellipsis; background-image: url('${tool.img}');background-repeat:no-repeat;padding-left:22px;background-size:20px" >${tool.text}:dc ${this.data.dc}</span>`;
		};
	}
}
async function getChoices() {
	const uuids = Settings.get(Settings.TOOL_CONFIG);
	const choices = {};
	for (const uuid of uuids) {
		try {
			const item = await beaversSystemInterface.uuidToDocument(uuid);
			choices[uuid] = { img: item.img, text: item.name };
		}
		catch (e) {
			console.warn(`Tool not found ${uuid}`, e);
		}
	}
	return choices;
}
getChoices().then((choices) => {
	beaversSystemInterface.registerTestClass(new ToolTest(choices));
});
