class AbilityTest {
	constructor() {
		this.type = "AbilityTest";
		this._choices = {};
		this.informationField = {
			name: "type",
			type: "info",
			label: game['i18n'].localize("beaversSystemInterface.tests.abilityTest.info.label"),
			note: game['i18n'].localize("beaversSystemInterface.tests.abilityTest.info.note")
		};
		this._choices = beaversSystemInterface.configAbilities.reduce((object, ability) => {
			object[ability.id] = { text: ability.label };
			return object;
		}, {});
	}
	create(data) {
		const result = new AbilityTestCustomized();
		result.data = data;
		result.parent = this;
		return result;
	}
	get customizationFields() {
		return {
			ability: {
				name: "ability",
				label: "ability",
				note: "Ability",
				type: "selection",
				choices: this._choices
			},
			dc: {
				name: "dc",
				label: "dc",
				note: "Difficulty Class ",
				defaultValue: 4,
				type: "number",
			}
		};
	}
}
class AbilityTestCustomized {
	constructor() {
		this.data = { dc: 4, ability: "" };
		this.action = async (initiatorData) => {
			const actor = beaversSystemInterface.initiator(initiatorData).actor;
			const roll = await beaversSystemInterface.actorRollAbility(actor, this.data.ability);
			let dc = this.data.dc;
			if (this.data.dc <= 0) {
				dc = 1;
			}
			const success = Math.floor(roll.total / dc);
			return {
				success: success,
				fail: success > 0 ? 0 : 1
			};
		};
		this.render = () => {
			const ability = this.parent._choices[this.data.ability]?.text || "process";
			return `${ability}:dc ${this.data.dc}`;
		};
	}
}
beaversSystemInterface.registerTestClass(new AbilityTest());
