!(function () {
    "use strict";
    const e = {
        getSavePath: () =>
            game.settings.get(e.moduleNamespace, e.tokenPathSettingsKey),
        createDirectory: async () => {
            let t = e.getSavePath();
            await FilePicker.createDirectory("data", t).catch((e) => {
                if (!(e.toString().indexOf("file already exists") > 0))
                    throw (console.error(e), new Error(e));
            });
        },
        moduleNamespace: "cthulhu-architect-handout-generator",
        tokenPathSettingsKey: "handout-save-path",
    };
    class t extends Application {
        static get defaultOptions() {
            const e = super.defaultOptions;
            return (
                (e.template =
                    "/modules/cthulhu-architect-handout-generator/templates/wrapper-template.html"),
                (e.resizable = true),
                (e.width = 1185),
                (e.height = 800),
                (e.classes = ["ca-hg-wrapper"]),
                (e.title = "Cthulhu Architect Handout Generator"),
                e
            );
        }
        static createHandoutFile(e, t) {
            let a = atob(e.split(",")[1]),
                o = [];
            for (let e = 0; e < a.length; e++) o.push(a.charCodeAt(e));
            let n = new Blob([new Uint8Array(o)], { type: "image/webp" });
            return new File([n], t);
        }
        static async uploadHandout(a, o) {
            let n = t.createHandoutFile(a, o);
            return await FilePicker.upload("data", e.getSavePath(), n, {});
        }
        async close() {
            return (
                window.removeEventListener("message", this.boundCallback, !1),
                super.close()
            );
        }
        async foundryImportCallback(event) {
            if ("https://handouts.cthulhuarchitect.com" === event.origin) {
                if (event.data.action === "importHandout") {
                    let a = this;
                    let filename = slugify(event.data.name) + '-' + Date.now().toString(36).slice(-6) + ".webp";

                    let data = null;

                    data = {
                        name: event.data.name,
                        pages: [
                            {
                                name: event.data.name,
                                type: 'image',
                                src: e.getSavePath() + '/' + filename
                            },
                            {
                                name: event.data.name + ' - Text Only',
                                type: 'text',
                                text: {
                                    content: event.data.handoutTexts.join("<br/><br/>").replace(/\n/g, "<br />"),
                                    format: CONST.JOURNAL_ENTRY_PAGE_FORMATS.HTML
                                }
                            }
                        ]
                    }

                    t.uploadHandout(event.data.handoutData, filename).then(async (e) => {
                        await JournalEntry.create(data);
                        ui.notifications.info("The handout was imported");
                        a.close();
                    });
                } else if (event.data.action === "importHandoutFolder") {
                    let a = this;
                    const pages = [];

                    for (let i = 0; i < event.data.handoutData.length; i++) {
                        const handout = event.data.handoutData[i];

                        let filename = slugify(handout.name) + '-' + Date.now().toString(36).slice(-6) + ".webp";

                        pages.push({
                            name: handout.name,
                            type: 'image',
                            src: e.getSavePath() + '/' + filename
                        });
                        pages.push({
                            name: handout.name + ' - Text Only',
                            type: 'text',
                            text: {
                                content: handout.text.join("<br/><br/>").replace(/\n/g, "<br />"),
                                format: CONST.JOURNAL_ENTRY_PAGE_FORMATS.HTML
                            }
                        });

                        await t.uploadHandout(handout.image, filename);
                    }

                    const data = {
                        name: event.data.name,
                        pages: pages
                    };

                    await JournalEntry.create(data);
                    ui.notifications.info("The handout was imported");
                    a.close();

                } else if (event.data.action === "importHandoutUrl") {
                    let t = this;
                    t.close();
                }
            }
        }
        activateListeners(e) {
            super.activateListeners(e);
            (this.boundCallback = this.foundryImportCallback.bind(this)),
                window.addEventListener("message", this.boundCallback, !1),
                (t.sourceRegistered = !1);
        }
    }

    Hooks.on("ready", () => {
        game.settings.register(e.moduleNamespace, e.tokenPathSettingsKey, {
            name: "Cthulhu Architect Handout Generator Save Path",
            hint: "The path handouts are saved to when imported to Foundry.",
            scope: "world",
            config: false,
            type: String,
            default:
                "worlds/" + (game.world.name || game.world.id) + "/handout-generator",
            onChange: (t) => e.createDirectory(),
        }),
            e.createDirectory();
    });

    Hooks.once("ready", async function () {
        if (game.user.isGM && !game.user.getFlag("cthulhu-architect-handout-generator", "welcomeMessageShown")) {
            renderTemplate("modules/cthulhu-architect-handout-generator/templates/welcomeMessage.html", {}).then((html) => {
                let options = {
                    whisper: [game.user.id],
                    content: html
                };
                ChatMessage.create(options);
            });
            await game.user.setFlag("cthulhu-architect-handout-generator", "welcomeMessageShown", true);
        }
    });

    // For v13
    Hooks.on("renderJournalDirectory", async (app, html) => {
        if (!game.user.isGM) return;

        const footer = html.querySelector(".directory-footer");
        const button = document.createElement("button");
        button.classList.add("open-handout-generator");
        button.type = "button";
        button.innerHTML = "<i class='fas fa-file'></i> Handout Generator";
        button.addEventListener("click", a => {
            if (
                Object.keys(ui.windows)
                    .map((e) => ui.windows[e])
                    .some((e) => e.options.classes.some((e) => "ca-hg-wrapper" == e))
            )
                return;
            a.preventDefault();
            const n = new t();

            n.render(true);
        });

        footer.append(button);
    })

    // For V12
    Hooks.on("renderSidebarTab", async (app, html) => {
        if (app.options.classes.indexOf('journal-sidebar') > -1 && game.user.isGM) {
            let button = $("<button class='open-handout-generator'><i class='fas fa-file'></i> Handout Generator</button>")

            button.click(function (a) {
                if (
                    Object.keys(ui.windows)
                        .map((e) => ui.windows[e])
                        .some((e) => e.options.classes.some((e) => "ca-hg-wrapper" == e))
                )
                    return;
                a.preventDefault();
                const n = new t();

                n.render(true);
            });

            html.find(".directory-footer").append(button);
        }
    })
})();

function slugify(str) {
    str = str.replace(/^\s+|\s+$/g, ''); // trim leading/trailing white space
    str = str.toLowerCase(); // convert string to lowercase
    str = str.replace(/[^a-z0-9 -]/g, '') // remove any non-alphanumeric characters
        .replace(/\s+/g, '-') // replace spaces with hyphens
        .replace(/-+/g, '-'); // remove consecutive hyphens
    return str;
}