import {initConfig} from "./config.js";
import {DamageNumberHelpers} from "./helpers.js";
import {Socket} from "./lib/socket.js";

export const MODULE_ID = "damage-numbers";

initConfig();

Hooks.once("init", async function () {

    Socket.register("showNumbers", DamageNumberHelpers.executeDamageNumbersSoket);
    Socket.register("simpleNumbers", DamageNumberHelpers.executeSimpleDamageNumbers);
    Socket.register("damageNumbersApi", DamageNumberHelpers.damageNumbersApi);
    
    game.settings.register("damage-numbers", "delay", {
        name: "Delay",
        hint: "Delay in ms",
        scope: "world",
        config: true,
        type: Number,
        default: 500,
    });

    game.settings.register("damage-numbers", "dontsplit", {
        name: "Don't Split Numbers",
        hint: "Show a single number instead of splitting the damage",
        scope: "world",
        config: true,
        type: Boolean,
        default: false,
    });

    game.settings.register("damage-numbers", "overrideCore", {
        name: "Override Core Bouncing Text",
        hint: "Override Core bouncing text style with RPG Damage Number's",
        scope: "world",
        config: true,
        type: Boolean,
        default: true,
    });

    game.settings.register("damage-numbers", "showDamageText", {
        name: "Show Damage type as text",
        hint: "Show Damage type as text in addition to the color",
        scope: "world",
        config: true,
        type: Boolean,
        default: false,
    });
});

Hooks.on("dnd5e.calculateDamage", async (actor, damages, options) => {
    options.RPGDN = {damages}
});

Hooks.on("dnd5e.applyDamage", (a, b, o) => {
    if(!o.RPGDN?.damages) return;
    const damages = o.RPGDN.damages;
    const token = a.token ?? a.getActiveTokens()[0];
    if (!token) return;
    Socket.showNumbers({damageDetail: damages, token: token.uuid ?? token.document.uuid});
});