const DamageNumbers = {
  colors: {
    acid: "0x56fc03",
    bludgeoning: "0xc7c7c7",
    cold: "0x0394fc",
    fire: "0xfc5603",
    force: "0xff006a",
    lightning: "0x0313fc",
    "midi-none": "0xffffff",
    necrotic: "0x4d5e57",
    piercing: "0xc7c7c7",
    poison: "0x0b6625",
    psychic: "0x710996",
    radiant: "0xffff54",
    slashing: "0xc7c7c7",
    thunder: "0x54ffb2",
    healing: "0x09ff00"
  },
  style: {
    align: "center",
    dropShadow: true,
    //fill: this.color,
    strokeThickness: 5,
  },
};

export class DamageNumber {
  constructor(token, type, value, resistance, isCrit, isSave, text, scale) {
    this.token = token;
    this.text = text;
    this.scale = scale || 1;
    this.value = Math.abs(Math.floor(value));
    this.color = DamageNumbers.colors[type] ?? type ?? "0xffffff";
    this.colorText = CONFIG?.DND5E?.damageTypes[type]?.label || "";
    this.resistance = resistance;
    if(this.resistance == "di")this.value = 0;
    this.isCrit = isCrit ? 2:1;
    this.speed = 1+Math.random()
    this.fall = 0.003 + 0.009*Math.random()
    this.angle = Math.PI*(Math.random()*0.4+1.3);
    this.sprite = new PIXI.Sprite();
    this.sprite.zIndex = CONFIG.Canvas.groups.interface.zIndexScrollingText;
    this.sprite.position.set(token.center.x, token.center.y);
    this.sprite.anchor.set(0.5, 0.5);
    this.animate()
  }

  async animate(){
    await this.wait(Math.random()*0.6*1000);
    this.sprite.text = this.getText();
    this.sprite.addChild(this.sprite.text);
    if(this.resistance == "dr" || this.resistance== "di")this.sprite.addChild(this.getResistance())
    canvas.interface.addChild(this.sprite);
    let _this = this;
    let time = 0
    function _animate(){
      time++
      //move sprite position in the direction of this.angle
      _this.sprite.x += Math.cos(_this.angle) * _this.speed;
      _this.sprite.y += Math.sin(_this.angle) * _this.speed*1.3;
      _this.sprite.alpha -= Math.log(time) * 0.005;
      let falloff = Math.sqrt(time) * _this.fall;
      if(_this.angle > Math.PI/1.8 && _this.angle < Math.PI*2.3){
        _this.angle += _this.angle > Math.PI*1.5 ? +falloff : -falloff;
      }
      if (_this.sprite.alpha <= 0) {
        canvas.interface.removeChild(_this.sprite);
        _this.sprite.destroy();
        canvas.app.ticker.remove(_animate);
      }
    }
    canvas.app.ticker.add(_animate);
  }

  getText() {
    const style = DamageNumbers.style;
    const tokenScale = ((Math.abs(this.token.document.texture.scaleX)+Math.abs(this.token.document.texture.scaleY))/2)*Math.min(this.token.document.width, this.token.document.height)*this.scale;
    style.fontSize = tokenScale*Math.max(Math.round(canvas.dimensions.size * 0.36 * 12) / 12, 36)*(this.resistance == "dv" ? 1.8 : 1)*this.isCrit;
    style.fill = this.color;
    let text = this.text ?? this.value;
    if(this.colorText && game.settings.get("damage-numbers", "showDamageText")) text += " " + this.colorText;
    const preciseText = new PreciseText(text, style);
    preciseText.anchor.set(0.5, 0.5);
    return preciseText;
  }

  getResistance() {
    let res = PIXI.Sprite.from("modules/damage-numbers/resources/slash.webp")
    res.anchor.set(0.5, 0.5);
    res.width = this.sprite.text.width
    res.height = this.sprite.text.height
    return res
  }

  wait(ms) {
    return new Promise((resolve) => setTimeout(resolve, ms));
  }


}
