import {Socket} from "./lib/socket.js";

export function initConfig() {

    Token.prototype.showBouncingText = function a(
        text,
        options = {
            color: 0xffffff,
            broadcast: true,
            scale: 1,
        },
    ) {
        options.tokenId = this.id;
        if (options.broadcast) {
            Socket.damageNumbersApi({text, options});
        } else {
            DamageNumberHelpers.damageNumbersApi({text, options});
        }
    };

    Hooks.once("ready", () => {
        if (game.settings.get("damage-numbers", "overrideCore")) {
            libWrapper.register(
                "damage-numbers",
                "InterfaceCanvasGroup.prototype.createScrollingText",
                function st(wrapped, ...args) {
                    if (game.Levels3dPreview?._active || !Number.isNumeric(args[1])) return wrapped(...args);
                    if (game.system.id === "dnd5e" && Number.isNumeric(args[1])) return;
                    const object = canvas.tokens.placeables.find((t) => t.center.x == args[0].x && t.center.y == args[0].y);
                    if (object?.skipDamageNumbers) {
                        delete object.skipDamageNumbers;
                        return;
                    }
                    if (!object) return wrapped(...args);
                    if (!object?.visible || !object?.renderable) return;
                    if (game.settings.get("core", "scrollingStatusText") !== true) return null;
                    const split = !game.settings.get("damage-numbers", "dontsplit");
                    const isNumber = !isNaN(args[1]);
                    let sign, damage;
                    if (split && isNumber) {
                        damage = Math.abs(parseFloat(args[1]));
                        sign = args[1].startsWith("-") || args[1].startsWith("+") ? args[1][0] : parseFloat(args[1]) < 0 ? "-" : "";
                        let currentdamage = 0;
                        let damages = [];
                        while (damage > currentdamage) {
                            let damagePart = Math.floor((Math.random() * damage) / 2) + 1;
                            if (currentdamage + damagePart > damage) {
                                damagePart = damage - currentdamage;
                            }
                            damages.push(damagePart);
                            currentdamage += damagePart;
                        }
                        for (let dmg of damages) {
                            object.showBouncingText(sign + dmg, {
                                color: args[2].fill ?? 0xffffff,
                                scale: args[2].fontSize / 28,
                            });
                        }
                    } else {
                        object.showBouncingText(args[1], {
                            color: args[2].fill ?? 0xffffff,
                            scale: args[2].fontSize / 28,
                        });
                    }
                },
                "MIXED",
            );
        }
    });

}