import {DamageNumber} from "./DamageNumbers.js";

export class DamageNumberHelpers {
    static getDiDrDv(actor, dt) {
        const traits = actor.system.traits;
        if (traits.di.value.has(dt)) return "di";
        if (traits.dr.value.has(dt)) return "dr";
        if (traits.dv.value.has(dt)) return "dv";
        return "none";
    }
    static executeDamageNumbersSoket({damageDetail, token}) {
        if (typeof token == "string") token = fromUuidSync(token).object;
        token.skipDamageNumbers = true;
        if (!damageDetail) return;
        const split = game.settings.get("damage-numbers", "dontsplit");
        const actor = token.actor;
        for (let damage of damageDetail) {
            const damageValue = Math.abs(Math.floor(damage.value));
            const damageMultiplier = damage.multiplier || 1;
            if (split) {
                new DamageNumber(token, damage.type, damageValue, DamageNumberHelpers.getDiDrDv(actor, damage.type), damageMultiplier == 2, damageMultiplier < 1);
                continue;
            }
            let currentDamage = 0;
            let damages = [];
            while (damageValue != currentDamage) {
                let damagePart = Math.floor((Math.random() * damageValue) / 2) + 1;
                if (currentDamage + damagePart > damageValue) {
                    damagePart = damageValue - currentDamage;
                }
                damages.push(damagePart);
                currentDamage += damagePart;
            }
            const type = damage.type ?? (damage.value < 0 ? "healing" : "0xff0000");
            for (let dmg of damages) new DamageNumber(token, type, dmg, DamageNumberHelpers.getDiDrDv(actor, damage.type), damageMultiplier == 2, damageMultiplier < 1);
        }
    }

    static executeSimpleDamageNumbers(tokenId, healthDiff) {
        const token = canvas.tokens.get(tokenId);
        new DamageNumber(token, healthDiff > 0 ? "midi-none" : "healing", Math.abs(healthDiff), "none", false, false);
    }

    static damageNumbersApi({text, options}) {
        const token = canvas.tokens.get(options.tokenId);
        if (!token) return;
        new DamageNumber(token, options.color, 0, null, false, false, text, options.scale);
    }

    static wait(ms) {
        return new Promise((resolve) => setTimeout(resolve, ms));
    }
}
