import { MODULE_ID, isActiveGM } from "./main.js";
import { Soundscapes } from "./app/Soundscapes.js";
import { injectConfig } from "./injectConfig.js";

export function initConfig() {
    game.keybindings.register(MODULE_ID, "toggleWindow", {
        name: game.i18n.localize(`${MODULE_ID}.toggleWindow`),
        editable: [{key: "KeyS", modifiers: [KeyboardManager.MODIFIER_KEYS.SHIFT]}],
        restricted: true,
        onDown: () => {},
        onUp: () => {
            const openWindows = Object.values(ui.windows).filter(w => w instanceof Soundscapes);
            if (openWindows.length > 0) {
                openWindows.forEach(w => w.close());
            } else {
                new Soundscapes().render(true);
            }
        },
    });

    Hooks.on("ready", async () => {
        if (!isActiveGM()) return;
        await Soundscapes.checkCreateFolder();
        new Soundscapes();
    });

    Hooks.on("renderSidebarTab", (app, html) => {
        if (!isActiveGM() || !(app instanceof PlaylistDirectory)) return;
        const buttonContainer = html[0].querySelector(".header-actions.action-buttons");
        const button = document.createElement("button");
        button.innerHTML = `<i class="fa-duotone fa-speakers"></i> ${game.i18n.localize(`${MODULE_ID}.sidebarButtonText`)}`;
        button.dataset.tooltip = game.i18n.localize(`${MODULE_ID}.sidebarButtonTooltip`);
        button.onclick = async (e) => {
            const isShift = e.shiftKey;
            if(isShift) await game.settings.set(MODULE_ID, "position", {});
            new Soundscapes().render(true);
        };
        buttonContainer.appendChild(button);
    });

    Hooks.on("renderPlaylistSoundConfig", (app, html) => {
        injectConfig.inject(app, html, {
            moduleId: MODULE_ID,
            inject: `input[name="path"]`,
            icon: {
                type: "filepicker",
                label: game.i18n.localize(`${MODULE_ID}.soundIcon`),
            },
        });
    });

    Hooks.on("renderPlaylistConfig", (app, html) => {
        injectConfig.inject(app, html, {
            moduleId: MODULE_ID,
            inject: `select[name="sorting"]`,
            soundscapeLayout: {
                type: "select",
                label: game.i18n.localize(`${MODULE_ID}.soundscapeLayout`),
                options: {
                    "flex": game.i18n.localize(`${MODULE_ID}.soundscapeLayoutFlex`),
                    "rows": game.i18n.localize(`${MODULE_ID}.soundscapeLayoutRows`),
                },
            },
            mood: {
                type: "select",
                label: game.i18n.localize(`${MODULE_ID}.mood`),
                options: {
                    "moodA": game.i18n.localize(`${MODULE_ID}.block-config.conditions-moodA`),
                    "moodB": game.i18n.localize(`${MODULE_ID}.block-config.conditions-moodB`),
                    "moodC": game.i18n.localize(`${MODULE_ID}.block-config.conditions-moodC`),
                },
            },
        });
    });
}
