import { MODULE_ID, isActiveGM } from "./main.js";

export function registerSettings() {
    game.settings.register(MODULE_ID, "selectedPlaylist", {
        scope: "world",
        config: false,
        type: String,
        default: "",
        onChange: () => {},
      });
  
      game.settings.register(MODULE_ID, "playingPlaylist", {
        scope: "world",
        config: false,
        type: String,
        default: "",
        onChange: () => {
          if(isActiveGM()) game.playlists.soundscapesRandomSoundController?.setPlaylist();
        },
      });
  
      game.settings.register(MODULE_ID, "compact", {
        scope: "world",
        config: false,
        type: Boolean,
        default: false,
      });
  
      game.settings.register(MODULE_ID, "position", {
        scope: "client",
        config: false,
        type: Object,
        default: {},
      });
}