# Argon-PF2E
An implementation of the [Argon - Combat HUD](https://foundryvtt.com/packages/enhancedcombathud) (by [TheRipper93](https://theripper93.com/) and [Mouse0270](https://github.com/mouse0270)) for the [Pathfinder Second Edition](https://foundryvtt.com/packages/pf2e) system. The Argon Combat HUD (CORE) module is required for this module to work.

![image](https://github.com/Saibot393/enhancedcombathud-pf2e/assets/137942782/2be49f41-4358-4d2f-b1e9-8072ae77cfd1)
![image](https://github.com/Saibot393/enhancedcombathud-pf2e/assets/137942782/0fa0b68a-a2cb-4275-8e1b-af6417b17f0e)

<sup>All icon included in this project are from [Game-icons.net](game-icons.net), used under the [CC BY 3.0](https://creativecommons.org/licenses/by/3.0/) license</sup>

### The documentation for the core argon features can be found [here](https://api.theripper93.com/modulewiki/enhancedcombathud/free)

This module adjust various Argon features for the Pathfinder 2e system:
- **Portrait**
    - The hero points are displayed and can be adjusted via left- and rightclick
    - The character sheet can be opened via rightclick
    - The current taken can be panned to via doubleclick
    - The currently worn armor can be inspected by rightclicking the AC box
    - Qucik buttons for the party sheet and potential familiars/master can be displayed
- **Action tracking**
    - The module tracks boths actions and reactions used, including reduced actions via conditions
    - The CORE Argon action pips can be replaced by PF2e specific icons
- **Skills and Attributes**
    - Skills, lore skills and saves are displayed, including their proficiency level via color
    - The skill actions can be directly used from the skills section
- **Weapons**
    - Icons for toggles such as thrown, versatile and modular will be displayed on the hud
    - The used ammunition can be adjusted from the hud
    - The amount of weapon sets can be adjusted
- **Tooltips** will display traits, required actions and further details such as damage, range, area...
- **Movement HUD** will track different movement types (including step and crawl) and allows for check like swim or climb to be rolled
- **Special actions**
    - Certain actions like escape or drop/stand up will be tracked and switched automatically
    - Toggle options can be changed from the hud

The staff automation added by **[PF2e Dailies](https://foundryvtt.com/packages/pf2e-dailies)** can be directly used from staves in item sets.

The reload and unload actions as added by **[PF2e Ranged Combat](https://foundryvtt.com/packages/pf2e-ranged-combat)** can be used directly from ranged weapons item buttons.

### Client Customization
- **Standard action slots** several standard PF2E actions (e.g. Seek, Hide, Shove) can be chosen to be displayed on the action bar for quick use
- **Macro buttons** addtional macro buttons can be displayed, whose macros can either be set per character or per user

#### Languages:

The module contains an English, a German, a Polish (thanks to [Lioheart](https://github.com/Lioheart)), and a Brazilian Portuguese (thanks to [zengerbr](https://github.com/zengerbr)) translation. If you want additional languages to be supported [let me know](https://github.com/Saibot393/enhancedcombathud-pf2e/issues).

**If you have suggestions, questions, or requests for additional features please [let me know](https://github.com/Saibot393/enhancedcombathud-pf2e/issues).**
