import {SoundLibrary} from "./app/soundLibrary.js";
import { MODULE_ID } from "./main.js";

export function registerSettings() {
    const settings = {
        "googleApiKey": {
            name: `${MODULE_ID}.settings.googleApiKey.name`,
            hint: `${MODULE_ID}.settings.googleApiKey.hint`,
            config: true,
            scope: "world",
            type: String,
            default: "",
        },
        "currentVideo": {
            config: false,
            scope: "world",
            type: String,
            default: "",
            onChange: () => {
                ui.sidebarVideoPlayer.loadVideo();
            }
        },
        "playlists": {
            config: false,
            scope: "world",
            type: Array,
            default: [],
            onChange: () => {
                ui.sidebarVideoPlayer.renderPlaylists();
            }
        },
        "currentTime": {
            config: false,
            scope: "world",
            type: Object,
            default: {videoId: "", time: 0},
            onChange: () => {
                ui.sidebarVideoPlayer.syncTime();
            }
        },
        "windowPosition": {
            config: false,
            scope: "client",
            type: Object,
            default: {x: 0, y: 0}
        },
        "tags": {
            config: false,
            scope: "world",
            type: Object,
            default: {},
            onChange: () => {
                SoundLibrary.refresh();
            }
        },
        "soundsLibrary": {
            config: false,
            scope: "world",
            type: Object,
            default: {},
            onChange: () => {
                SoundLibrary.refresh();
            }
        },

    };

    registerSettingsArray(settings);
}

export function getSetting(key) {
    return game.settings.get(MODULE_ID, key);
}

export async function setSetting(key, value) {
    const isWorldSetting = game.settings.settings.get(`${MODULE_ID}.${key}`).scope === "world";
    if(isWorldSetting && !game.user.isGM) return ui.notifications.error("You don't have permission to change this setting. " + key);
    return await game.settings.set(MODULE_ID, key, value);
}

function registerSettingsArray(settings) {
    for(const [key, value] of Object.entries(settings)) {
        game.settings.register(MODULE_ID, key, value);
    }
}