import { initConfig } from "./config.js";
import { registerSettings, setSetting } from "./settings.js";
import {SidebarVideoPlayer} from "./app/app.js";
import { ImportExport } from "./app/ImportExport.js";
import {SoundLibrary, TrackConfiguration} from "./app/soundLibrary.js";

export const MODULE_ID = "fvtt-youtube-player";

globalThis.FVTTYouTubePlayer = {
    SoundLibrary: SoundLibrary,
    TrackConfiguration: TrackConfiguration,
}

globalThis.onYouTubeIframeAPIReady = () => {
    console.log("YouTube API Ready");
    SidebarVideoPlayer.inject();
};

Hooks.once("ready", () => {
    const tag = document.createElement("script");
    tag.src = "https://www.youtube.com/iframe_api";
    const firstScriptTag = document.getElementsByTagName("script")[0];
    firstScriptTag.parentNode.insertBefore(tag, firstScriptTag);

    if (!game.user.isGM) return;

    document.addEventListener("click", (event) => {
        if(event.target.classList.contains("fvtt-youtube-player-video-link")) {
            event.preventDefault();
            event.stopPropagation();
            setSetting("currentVideo", event.target.dataset.url);
        }
    });
});

Hooks.once("init", () => {
    initConfig();
    registerSettings();
    ImportExport.register();
});

Hooks.once("setup", () => {
    CONFIG.TextEditor.enrichers.push({
        id: MODULE_ID,
        pattern: /@YT\[(.*?)\]{(.*?)\}/g,
        enricher: (match, content) => {
            const id = match[1];
            const a = document.createElement("a");
            a.classList.add("fvtt-youtube-player-video-link");
            a.dataset.url = id;
            a.draggable = false;
            a.innerHTML = `<i class="fab fa-youtube"></i> ${match[2] || "YouTube Video"}`;
            return a;
        },
    });
});
