export function showBannerText(text, {subtitle = "", duration = 3000} = {}) {
    const banner = document.createElement("div");
    banner.classList.add("hexplorer-banner");
    banner.style.opacity = 0;
    banner.innerHTML = `<div class="text-container"><h1>${text}</h1>${subtitle ? `<p>${subtitle}</p>` : ""}</div>`;
    document.querySelector("#ui-middle").appendChild(banner);
    banner.animate([{opacity: 0}, {opacity: 1}], {duration: duration / 4, easing: "cubic-bezier(0.25, 1, 0.5, 1)"}).finished.then(() => {
        banner.style.opacity = 1;
        banner.animate([{opacity: 1}, {opacity: 0}], {duration: duration / 4, delay: duration / 2, easing: "cubic-bezier(0.25, 1, 0.5, 1)"}).finished.then(() => {
            banner.remove();
        });
    });
}