Hooks.once('init', async function() {

    game.settings.register("inactive-tokens-lmao", "autoDefeated", {
        name: "Auto set Inactive on Defeated",
        hint: "When a token is marked defeated, automatically set it as inactive (only in combat)",
        scope: "world",
        config: true,
        type: Boolean,
        default: true,
      });

});

Hooks.once('ready', async function() {

});

Hooks.on("renderTokenHUD", (app,html) => {
    if(!game.user.isGM) return;
    const token = app.object;
    const isInactive = token.document.getFlag("inactive-tokens-lmao", "isInactive") ?? false;
    const colLeft = $(html).find(".left")
    const button = $(`
    <div class="control-icon ${isInactive ? "active" : ""}" id="toggle-inactive">
        <img src="icons/svg/padlock.svg" width="36" height="36" title="Toggle Inactive State">
        </div>
    `)
    colLeft.append(button);
    button.on("click", (e) => {
        button.toggleClass("active");
        const updates = {
            flags: {
                "inactive-tokens-lmao": {
                    isInactive: !(token.document.getFlag("inactive-tokens-lmao", "isInactive") ?? false)
                }
            }
        
        }
        canvas.tokens.updateAll(updates, (t)=> t.controlled || t.id === token.id);
    })
})