var __defProp = Object.defineProperty;
var __typeError = (msg) => {
  throw TypeError(msg);
};
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value), __accessCheck = (obj, member, msg) => member.has(obj) || __typeError("Cannot " + msg);
var __privateGet = (obj, member, getter) => (__accessCheck(obj, member, "read from private field"), getter ? getter.call(obj) : member.get(obj)), __privateAdd = (obj, member, value) => member.has(obj) ? __typeError("Cannot add the same private member more than once") : member instanceof WeakSet ? member.add(obj) : member.set(obj, value);
var __privateMethod = (obj, member, method) => (__accessCheck(obj, member, "access private method"), method);
const id = "lancer-alternative-sheets", TEMPLATE_PATHS = {
  mechSheetSvelte: `modules/${id}/templates/la-mech-svelte.hbs`,
  npcSheetSvelte: `modules/${id}/templates/la-npc-svelte.hbs`,
  pilotSheetSvelte: `modules/${id}/templates/la-pilot-svelte.hbs`,
  deployableSheetSvelte: `modules/${id}/templates/la-deployable-svelte.hbs`,
  featureCard: `modules/${id}/templates/chat/feature-card.hbs`
}, preloadTemplates = /* @__PURE__ */ __name(async function() {
  return loadTemplates(Object.values(TEMPLATE_PATHS));
}, "preloadTemplates");
var LancerAlternative = /* @__PURE__ */ ((LancerAlternative2) => (LancerAlternative2.Name = "lancer-alternative-sheets", LancerAlternative2))(LancerAlternative || {});
function utf8Count(str) {
  const strLength = str.length;
  let byteLength = 0, pos = 0;
  for (; pos < strLength; ) {
    let value = str.charCodeAt(pos++);
    if (value & 4294967168)
      if (!(value & 4294965248))
        byteLength += 2;
      else {
        if (value >= 55296 && value <= 56319 && pos < strLength) {
          const extra = str.charCodeAt(pos);
          (extra & 64512) === 56320 && (++pos, value = ((value & 1023) << 10) + (extra & 1023) + 65536);
        }
        value & 4294901760 ? byteLength += 4 : byteLength += 3;
      }
    else {
      byteLength++;
      continue;
    }
  }
  return byteLength;
}
__name(utf8Count, "utf8Count");
function utf8EncodeJs(str, output, outputOffset) {
  const strLength = str.length;
  let offset = outputOffset, pos = 0;
  for (; pos < strLength; ) {
    let value = str.charCodeAt(pos++);
    if (value & 4294967168)
      if (!(value & 4294965248))
        output[offset++] = value >> 6 & 31 | 192;
      else {
        if (value >= 55296 && value <= 56319 && pos < strLength) {
          const extra = str.charCodeAt(pos);
          (extra & 64512) === 56320 && (++pos, value = ((value & 1023) << 10) + (extra & 1023) + 65536);
        }
        value & 4294901760 ? (output[offset++] = value >> 18 & 7 | 240, output[offset++] = value >> 12 & 63 | 128, output[offset++] = value >> 6 & 63 | 128) : (output[offset++] = value >> 12 & 15 | 224, output[offset++] = value >> 6 & 63 | 128);
      }
    else {
      output[offset++] = value;
      continue;
    }
    output[offset++] = value & 63 | 128;
  }
}
__name(utf8EncodeJs, "utf8EncodeJs");
const sharedTextEncoder = new TextEncoder(), TEXT_ENCODER_THRESHOLD = 50;
function utf8EncodeTE(str, output, outputOffset) {
  sharedTextEncoder.encodeInto(str, output.subarray(outputOffset));
}
__name(utf8EncodeTE, "utf8EncodeTE");
function utf8Encode(str, output, outputOffset) {
  str.length > TEXT_ENCODER_THRESHOLD ? utf8EncodeTE(str, output, outputOffset) : utf8EncodeJs(str, output, outputOffset);
}
__name(utf8Encode, "utf8Encode");
const CHUNK_SIZE = 4096;
function utf8DecodeJs(bytes, inputOffset, byteLength) {
  let offset = inputOffset;
  const end = offset + byteLength, units = [];
  let result = "";
  for (; offset < end; ) {
    const byte1 = bytes[offset++];
    if (!(byte1 & 128))
      units.push(byte1);
    else if ((byte1 & 224) === 192) {
      const byte2 = bytes[offset++] & 63;
      units.push((byte1 & 31) << 6 | byte2);
    } else if ((byte1 & 240) === 224) {
      const byte2 = bytes[offset++] & 63, byte3 = bytes[offset++] & 63;
      units.push((byte1 & 31) << 12 | byte2 << 6 | byte3);
    } else if ((byte1 & 248) === 240) {
      const byte2 = bytes[offset++] & 63, byte3 = bytes[offset++] & 63, byte4 = bytes[offset++] & 63;
      let unit = (byte1 & 7) << 18 | byte2 << 12 | byte3 << 6 | byte4;
      unit > 65535 && (unit -= 65536, units.push(unit >>> 10 & 1023 | 55296), unit = 56320 | unit & 1023), units.push(unit);
    } else
      units.push(byte1);
    units.length >= CHUNK_SIZE && (result += String.fromCharCode(...units), units.length = 0);
  }
  return units.length > 0 && (result += String.fromCharCode(...units)), result;
}
__name(utf8DecodeJs, "utf8DecodeJs");
const sharedTextDecoder = new TextDecoder(), TEXT_DECODER_THRESHOLD = 200;
function utf8DecodeTD(bytes, inputOffset, byteLength) {
  const stringBytes = bytes.subarray(inputOffset, inputOffset + byteLength);
  return sharedTextDecoder.decode(stringBytes);
}
__name(utf8DecodeTD, "utf8DecodeTD");
function utf8Decode(bytes, inputOffset, byteLength) {
  return byteLength > TEXT_DECODER_THRESHOLD ? utf8DecodeTD(bytes, inputOffset, byteLength) : utf8DecodeJs(bytes, inputOffset, byteLength);
}
__name(utf8Decode, "utf8Decode");
const _ExtData = class _ExtData {
  constructor(type, data) {
    this.type = type, this.data = data;
  }
};
__name(_ExtData, "ExtData");
let ExtData = _ExtData;
const _DecodeError = class _DecodeError extends Error {
  constructor(message) {
    super(message);
    const proto = Object.create(_DecodeError.prototype);
    Object.setPrototypeOf(this, proto), Object.defineProperty(this, "name", {
      configurable: !0,
      enumerable: !1,
      value: _DecodeError.name
    });
  }
};
__name(_DecodeError, "DecodeError");
let DecodeError = _DecodeError;
const UINT32_MAX = 4294967295;
function setUint64(view, offset, value) {
  const high = value / 4294967296, low = value;
  view.setUint32(offset, high), view.setUint32(offset + 4, low);
}
__name(setUint64, "setUint64");
function setInt64(view, offset, value) {
  const high = Math.floor(value / 4294967296), low = value;
  view.setUint32(offset, high), view.setUint32(offset + 4, low);
}
__name(setInt64, "setInt64");
function getInt64(view, offset) {
  const high = view.getInt32(offset), low = view.getUint32(offset + 4);
  return high * 4294967296 + low;
}
__name(getInt64, "getInt64");
function getUint64(view, offset) {
  const high = view.getUint32(offset), low = view.getUint32(offset + 4);
  return high * 4294967296 + low;
}
__name(getUint64, "getUint64");
const EXT_TIMESTAMP = -1, TIMESTAMP32_MAX_SEC = 4294967296 - 1, TIMESTAMP64_MAX_SEC = 17179869184 - 1;
function encodeTimeSpecToTimestamp({ sec, nsec }) {
  if (sec >= 0 && nsec >= 0 && sec <= TIMESTAMP64_MAX_SEC)
    if (nsec === 0 && sec <= TIMESTAMP32_MAX_SEC) {
      const rv = new Uint8Array(4);
      return new DataView(rv.buffer).setUint32(0, sec), rv;
    } else {
      const secHigh = sec / 4294967296, secLow = sec & 4294967295, rv = new Uint8Array(8), view = new DataView(rv.buffer);
      return view.setUint32(0, nsec << 2 | secHigh & 3), view.setUint32(4, secLow), rv;
    }
  else {
    const rv = new Uint8Array(12), view = new DataView(rv.buffer);
    return view.setUint32(0, nsec), setInt64(view, 4, sec), rv;
  }
}
__name(encodeTimeSpecToTimestamp, "encodeTimeSpecToTimestamp");
function encodeDateToTimeSpec(date) {
  const msec = date.getTime(), sec = Math.floor(msec / 1e3), nsec = (msec - sec * 1e3) * 1e6, nsecInSec = Math.floor(nsec / 1e9);
  return {
    sec: sec + nsecInSec,
    nsec: nsec - nsecInSec * 1e9
  };
}
__name(encodeDateToTimeSpec, "encodeDateToTimeSpec");
function encodeTimestampExtension(object) {
  if (object instanceof Date) {
    const timeSpec = encodeDateToTimeSpec(object);
    return encodeTimeSpecToTimestamp(timeSpec);
  } else
    return null;
}
__name(encodeTimestampExtension, "encodeTimestampExtension");
function decodeTimestampToTimeSpec(data) {
  const view = new DataView(data.buffer, data.byteOffset, data.byteLength);
  switch (data.byteLength) {
    case 4:
      return { sec: view.getUint32(0), nsec: 0 };
    case 8: {
      const nsec30AndSecHigh2 = view.getUint32(0), secLow32 = view.getUint32(4), sec = (nsec30AndSecHigh2 & 3) * 4294967296 + secLow32, nsec = nsec30AndSecHigh2 >>> 2;
      return { sec, nsec };
    }
    case 12: {
      const sec = getInt64(view, 4), nsec = view.getUint32(0);
      return { sec, nsec };
    }
    default:
      throw new DecodeError(`Unrecognized data size for timestamp (expected 4, 8, or 12): ${data.length}`);
  }
}
__name(decodeTimestampToTimeSpec, "decodeTimestampToTimeSpec");
function decodeTimestampExtension(data) {
  const timeSpec = decodeTimestampToTimeSpec(data);
  return new Date(timeSpec.sec * 1e3 + timeSpec.nsec / 1e6);
}
__name(decodeTimestampExtension, "decodeTimestampExtension");
const timestampExtension = {
  type: EXT_TIMESTAMP,
  encode: encodeTimestampExtension,
  decode: decodeTimestampExtension
}, _ExtensionCodec = class _ExtensionCodec {
  constructor() {
    this.builtInEncoders = [], this.builtInDecoders = [], this.encoders = [], this.decoders = [], this.register(timestampExtension);
  }
  register({ type, encode, decode }) {
    if (type >= 0)
      this.encoders[type] = encode, this.decoders[type] = decode;
    else {
      const index2 = -1 - type;
      this.builtInEncoders[index2] = encode, this.builtInDecoders[index2] = decode;
    }
  }
  tryToEncode(object, context) {
    for (let i2 = 0; i2 < this.builtInEncoders.length; i2++) {
      const encodeExt = this.builtInEncoders[i2];
      if (encodeExt != null) {
        const data = encodeExt(object, context);
        if (data != null) {
          const type = -1 - i2;
          return new ExtData(type, data);
        }
      }
    }
    for (let i2 = 0; i2 < this.encoders.length; i2++) {
      const encodeExt = this.encoders[i2];
      if (encodeExt != null) {
        const data = encodeExt(object, context);
        if (data != null) {
          const type = i2;
          return new ExtData(type, data);
        }
      }
    }
    return object instanceof ExtData ? object : null;
  }
  decode(data, type, context) {
    const decodeExt = type < 0 ? this.builtInDecoders[-1 - type] : this.decoders[type];
    return decodeExt ? decodeExt(data, type, context) : new ExtData(type, data);
  }
};
__name(_ExtensionCodec, "ExtensionCodec");
let ExtensionCodec = _ExtensionCodec;
ExtensionCodec.defaultCodec = new ExtensionCodec();
function isArrayBufferLike(buffer) {
  return buffer instanceof ArrayBuffer || typeof SharedArrayBuffer < "u" && buffer instanceof SharedArrayBuffer;
}
__name(isArrayBufferLike, "isArrayBufferLike");
function ensureUint8Array(buffer) {
  return buffer instanceof Uint8Array ? buffer : ArrayBuffer.isView(buffer) ? new Uint8Array(buffer.buffer, buffer.byteOffset, buffer.byteLength) : isArrayBufferLike(buffer) ? new Uint8Array(buffer) : Uint8Array.from(buffer);
}
__name(ensureUint8Array, "ensureUint8Array");
const DEFAULT_MAX_DEPTH = 100, DEFAULT_INITIAL_BUFFER_SIZE = 2048, _Encoder = class _Encoder {
  constructor(options) {
    this.entered = !1, this.extensionCodec = (options == null ? void 0 : options.extensionCodec) ?? ExtensionCodec.defaultCodec, this.context = options == null ? void 0 : options.context, this.useBigInt64 = (options == null ? void 0 : options.useBigInt64) ?? !1, this.maxDepth = (options == null ? void 0 : options.maxDepth) ?? DEFAULT_MAX_DEPTH, this.initialBufferSize = (options == null ? void 0 : options.initialBufferSize) ?? DEFAULT_INITIAL_BUFFER_SIZE, this.sortKeys = (options == null ? void 0 : options.sortKeys) ?? !1, this.forceFloat32 = (options == null ? void 0 : options.forceFloat32) ?? !1, this.ignoreUndefined = (options == null ? void 0 : options.ignoreUndefined) ?? !1, this.forceIntegerToFloat = (options == null ? void 0 : options.forceIntegerToFloat) ?? !1, this.pos = 0, this.view = new DataView(new ArrayBuffer(this.initialBufferSize)), this.bytes = new Uint8Array(this.view.buffer);
  }
  clone() {
    return new _Encoder({
      extensionCodec: this.extensionCodec,
      context: this.context,
      useBigInt64: this.useBigInt64,
      maxDepth: this.maxDepth,
      initialBufferSize: this.initialBufferSize,
      sortKeys: this.sortKeys,
      forceFloat32: this.forceFloat32,
      ignoreUndefined: this.ignoreUndefined,
      forceIntegerToFloat: this.forceIntegerToFloat
    });
  }
  reinitializeState() {
    this.pos = 0;
  }
  /**
   * This is almost equivalent to {@link Encoder#encode}, but it returns an reference of the encoder's internal buffer and thus much faster than {@link Encoder#encode}.
   *
   * @returns Encodes the object and returns a shared reference the encoder's internal buffer.
   */
  encodeSharedRef(object) {
    if (this.entered)
      return this.clone().encodeSharedRef(object);
    try {
      return this.entered = !0, this.reinitializeState(), this.doEncode(object, 1), this.bytes.subarray(0, this.pos);
    } finally {
      this.entered = !1;
    }
  }
  /**
   * @returns Encodes the object and returns a copy of the encoder's internal buffer.
   */
  encode(object) {
    if (this.entered)
      return this.clone().encode(object);
    try {
      return this.entered = !0, this.reinitializeState(), this.doEncode(object, 1), this.bytes.slice(0, this.pos);
    } finally {
      this.entered = !1;
    }
  }
  doEncode(object, depth) {
    if (depth > this.maxDepth)
      throw new Error(`Too deep objects in depth ${depth}`);
    object == null ? this.encodeNil() : typeof object == "boolean" ? this.encodeBoolean(object) : typeof object == "number" ? this.forceIntegerToFloat ? this.encodeNumberAsFloat(object) : this.encodeNumber(object) : typeof object == "string" ? this.encodeString(object) : this.useBigInt64 && typeof object == "bigint" ? this.encodeBigInt64(object) : this.encodeObject(object, depth);
  }
  ensureBufferSizeToWrite(sizeToWrite) {
    const requiredSize = this.pos + sizeToWrite;
    this.view.byteLength < requiredSize && this.resizeBuffer(requiredSize * 2);
  }
  resizeBuffer(newSize) {
    const newBuffer = new ArrayBuffer(newSize), newBytes = new Uint8Array(newBuffer), newView = new DataView(newBuffer);
    newBytes.set(this.bytes), this.view = newView, this.bytes = newBytes;
  }
  encodeNil() {
    this.writeU8(192);
  }
  encodeBoolean(object) {
    object === !1 ? this.writeU8(194) : this.writeU8(195);
  }
  encodeNumber(object) {
    !this.forceIntegerToFloat && Number.isSafeInteger(object) ? object >= 0 ? object < 128 ? this.writeU8(object) : object < 256 ? (this.writeU8(204), this.writeU8(object)) : object < 65536 ? (this.writeU8(205), this.writeU16(object)) : object < 4294967296 ? (this.writeU8(206), this.writeU32(object)) : this.useBigInt64 ? this.encodeNumberAsFloat(object) : (this.writeU8(207), this.writeU64(object)) : object >= -32 ? this.writeU8(224 | object + 32) : object >= -128 ? (this.writeU8(208), this.writeI8(object)) : object >= -32768 ? (this.writeU8(209), this.writeI16(object)) : object >= -2147483648 ? (this.writeU8(210), this.writeI32(object)) : this.useBigInt64 ? this.encodeNumberAsFloat(object) : (this.writeU8(211), this.writeI64(object)) : this.encodeNumberAsFloat(object);
  }
  encodeNumberAsFloat(object) {
    this.forceFloat32 ? (this.writeU8(202), this.writeF32(object)) : (this.writeU8(203), this.writeF64(object));
  }
  encodeBigInt64(object) {
    object >= BigInt(0) ? (this.writeU8(207), this.writeBigUint64(object)) : (this.writeU8(211), this.writeBigInt64(object));
  }
  writeStringHeader(byteLength) {
    if (byteLength < 32)
      this.writeU8(160 + byteLength);
    else if (byteLength < 256)
      this.writeU8(217), this.writeU8(byteLength);
    else if (byteLength < 65536)
      this.writeU8(218), this.writeU16(byteLength);
    else if (byteLength < 4294967296)
      this.writeU8(219), this.writeU32(byteLength);
    else
      throw new Error(`Too long string: ${byteLength} bytes in UTF-8`);
  }
  encodeString(object) {
    const byteLength = utf8Count(object);
    this.ensureBufferSizeToWrite(5 + byteLength), this.writeStringHeader(byteLength), utf8Encode(object, this.bytes, this.pos), this.pos += byteLength;
  }
  encodeObject(object, depth) {
    const ext = this.extensionCodec.tryToEncode(object, this.context);
    if (ext != null)
      this.encodeExtension(ext);
    else if (Array.isArray(object))
      this.encodeArray(object, depth);
    else if (ArrayBuffer.isView(object))
      this.encodeBinary(object);
    else if (typeof object == "object")
      this.encodeMap(object, depth);
    else
      throw new Error(`Unrecognized object: ${Object.prototype.toString.apply(object)}`);
  }
  encodeBinary(object) {
    const size = object.byteLength;
    if (size < 256)
      this.writeU8(196), this.writeU8(size);
    else if (size < 65536)
      this.writeU8(197), this.writeU16(size);
    else if (size < 4294967296)
      this.writeU8(198), this.writeU32(size);
    else
      throw new Error(`Too large binary: ${size}`);
    const bytes = ensureUint8Array(object);
    this.writeU8a(bytes);
  }
  encodeArray(object, depth) {
    const size = object.length;
    if (size < 16)
      this.writeU8(144 + size);
    else if (size < 65536)
      this.writeU8(220), this.writeU16(size);
    else if (size < 4294967296)
      this.writeU8(221), this.writeU32(size);
    else
      throw new Error(`Too large array: ${size}`);
    for (const item of object)
      this.doEncode(item, depth + 1);
  }
  countWithoutUndefined(object, keys) {
    let count = 0;
    for (const key of keys)
      object[key] !== void 0 && count++;
    return count;
  }
  encodeMap(object, depth) {
    const keys = Object.keys(object);
    this.sortKeys && keys.sort();
    const size = this.ignoreUndefined ? this.countWithoutUndefined(object, keys) : keys.length;
    if (size < 16)
      this.writeU8(128 + size);
    else if (size < 65536)
      this.writeU8(222), this.writeU16(size);
    else if (size < 4294967296)
      this.writeU8(223), this.writeU32(size);
    else
      throw new Error(`Too large map object: ${size}`);
    for (const key of keys) {
      const value = object[key];
      this.ignoreUndefined && value === void 0 || (this.encodeString(key), this.doEncode(value, depth + 1));
    }
  }
  encodeExtension(ext) {
    if (typeof ext.data == "function") {
      const data = ext.data(this.pos + 6), size2 = data.length;
      if (size2 >= 4294967296)
        throw new Error(`Too large extension object: ${size2}`);
      this.writeU8(201), this.writeU32(size2), this.writeI8(ext.type), this.writeU8a(data);
      return;
    }
    const size = ext.data.length;
    if (size === 1)
      this.writeU8(212);
    else if (size === 2)
      this.writeU8(213);
    else if (size === 4)
      this.writeU8(214);
    else if (size === 8)
      this.writeU8(215);
    else if (size === 16)
      this.writeU8(216);
    else if (size < 256)
      this.writeU8(199), this.writeU8(size);
    else if (size < 65536)
      this.writeU8(200), this.writeU16(size);
    else if (size < 4294967296)
      this.writeU8(201), this.writeU32(size);
    else
      throw new Error(`Too large extension object: ${size}`);
    this.writeI8(ext.type), this.writeU8a(ext.data);
  }
  writeU8(value) {
    this.ensureBufferSizeToWrite(1), this.view.setUint8(this.pos, value), this.pos++;
  }
  writeU8a(values) {
    const size = values.length;
    this.ensureBufferSizeToWrite(size), this.bytes.set(values, this.pos), this.pos += size;
  }
  writeI8(value) {
    this.ensureBufferSizeToWrite(1), this.view.setInt8(this.pos, value), this.pos++;
  }
  writeU16(value) {
    this.ensureBufferSizeToWrite(2), this.view.setUint16(this.pos, value), this.pos += 2;
  }
  writeI16(value) {
    this.ensureBufferSizeToWrite(2), this.view.setInt16(this.pos, value), this.pos += 2;
  }
  writeU32(value) {
    this.ensureBufferSizeToWrite(4), this.view.setUint32(this.pos, value), this.pos += 4;
  }
  writeI32(value) {
    this.ensureBufferSizeToWrite(4), this.view.setInt32(this.pos, value), this.pos += 4;
  }
  writeF32(value) {
    this.ensureBufferSizeToWrite(4), this.view.setFloat32(this.pos, value), this.pos += 4;
  }
  writeF64(value) {
    this.ensureBufferSizeToWrite(8), this.view.setFloat64(this.pos, value), this.pos += 8;
  }
  writeU64(value) {
    this.ensureBufferSizeToWrite(8), setUint64(this.view, this.pos, value), this.pos += 8;
  }
  writeI64(value) {
    this.ensureBufferSizeToWrite(8), setInt64(this.view, this.pos, value), this.pos += 8;
  }
  writeBigUint64(value) {
    this.ensureBufferSizeToWrite(8), this.view.setBigUint64(this.pos, value), this.pos += 8;
  }
  writeBigInt64(value) {
    this.ensureBufferSizeToWrite(8), this.view.setBigInt64(this.pos, value), this.pos += 8;
  }
};
__name(_Encoder, "Encoder");
let Encoder = _Encoder;
function prettyByte(byte) {
  return `${byte < 0 ? "-" : ""}0x${Math.abs(byte).toString(16).padStart(2, "0")}`;
}
__name(prettyByte, "prettyByte");
const DEFAULT_MAX_KEY_LENGTH = 16, DEFAULT_MAX_LENGTH_PER_KEY = 16, _CachedKeyDecoder = class _CachedKeyDecoder {
  constructor(maxKeyLength = DEFAULT_MAX_KEY_LENGTH, maxLengthPerKey = DEFAULT_MAX_LENGTH_PER_KEY) {
    this.hit = 0, this.miss = 0, this.maxKeyLength = maxKeyLength, this.maxLengthPerKey = maxLengthPerKey, this.caches = [];
    for (let i2 = 0; i2 < this.maxKeyLength; i2++)
      this.caches.push([]);
  }
  canBeCached(byteLength) {
    return byteLength > 0 && byteLength <= this.maxKeyLength;
  }
  find(bytes, inputOffset, byteLength) {
    const records = this.caches[byteLength - 1];
    FIND_CHUNK: for (const record of records) {
      const recordBytes = record.bytes;
      for (let j = 0; j < byteLength; j++)
        if (recordBytes[j] !== bytes[inputOffset + j])
          continue FIND_CHUNK;
      return record.str;
    }
    return null;
  }
  store(bytes, value) {
    const records = this.caches[bytes.length - 1], record = { bytes, str: value };
    records.length >= this.maxLengthPerKey ? records[Math.random() * records.length | 0] = record : records.push(record);
  }
  decode(bytes, inputOffset, byteLength) {
    const cachedValue = this.find(bytes, inputOffset, byteLength);
    if (cachedValue != null)
      return this.hit++, cachedValue;
    this.miss++;
    const str = utf8DecodeJs(bytes, inputOffset, byteLength), slicedCopyOfBytes = Uint8Array.prototype.slice.call(bytes, inputOffset, inputOffset + byteLength);
    return this.store(slicedCopyOfBytes, str), str;
  }
};
__name(_CachedKeyDecoder, "CachedKeyDecoder");
let CachedKeyDecoder = _CachedKeyDecoder;
const STATE_ARRAY = "array", STATE_MAP_KEY = "map_key", STATE_MAP_VALUE = "map_value", mapKeyConverter = /* @__PURE__ */ __name((key) => {
  if (typeof key == "string" || typeof key == "number")
    return key;
  throw new DecodeError("The type of key must be string or number but " + typeof key);
}, "mapKeyConverter"), _StackPool = class _StackPool {
  constructor() {
    this.stack = [], this.stackHeadPosition = -1;
  }
  get length() {
    return this.stackHeadPosition + 1;
  }
  top() {
    return this.stack[this.stackHeadPosition];
  }
  pushArrayState(size) {
    const state2 = this.getUninitializedStateFromPool();
    state2.type = STATE_ARRAY, state2.position = 0, state2.size = size, state2.array = new Array(size);
  }
  pushMapState(size) {
    const state2 = this.getUninitializedStateFromPool();
    state2.type = STATE_MAP_KEY, state2.readCount = 0, state2.size = size, state2.map = {};
  }
  getUninitializedStateFromPool() {
    if (this.stackHeadPosition++, this.stackHeadPosition === this.stack.length) {
      const partialState = {
        type: void 0,
        size: 0,
        array: void 0,
        position: 0,
        readCount: 0,
        map: void 0,
        key: null
      };
      this.stack.push(partialState);
    }
    return this.stack[this.stackHeadPosition];
  }
  release(state2) {
    if (this.stack[this.stackHeadPosition] !== state2)
      throw new Error("Invalid stack state. Released state is not on top of the stack.");
    if (state2.type === STATE_ARRAY) {
      const partialState = state2;
      partialState.size = 0, partialState.array = void 0, partialState.position = 0, partialState.type = void 0;
    }
    if (state2.type === STATE_MAP_KEY || state2.type === STATE_MAP_VALUE) {
      const partialState = state2;
      partialState.size = 0, partialState.map = void 0, partialState.readCount = 0, partialState.type = void 0;
    }
    this.stackHeadPosition--;
  }
  reset() {
    this.stack.length = 0, this.stackHeadPosition = -1;
  }
};
__name(_StackPool, "StackPool");
let StackPool = _StackPool;
const HEAD_BYTE_REQUIRED = -1, EMPTY_VIEW = new DataView(new ArrayBuffer(0)), EMPTY_BYTES = new Uint8Array(EMPTY_VIEW.buffer);
try {
  EMPTY_VIEW.getInt8(0);
} catch (e2) {
  if (!(e2 instanceof RangeError))
    throw new Error("This module is not supported in the current JavaScript engine because DataView does not throw RangeError on out-of-bounds access");
}
const MORE_DATA = new RangeError("Insufficient data"), sharedCachedKeyDecoder = new CachedKeyDecoder(), _Decoder = class _Decoder {
  constructor(options) {
    this.totalPos = 0, this.pos = 0, this.view = EMPTY_VIEW, this.bytes = EMPTY_BYTES, this.headByte = HEAD_BYTE_REQUIRED, this.stack = new StackPool(), this.entered = !1, this.extensionCodec = (options == null ? void 0 : options.extensionCodec) ?? ExtensionCodec.defaultCodec, this.context = options == null ? void 0 : options.context, this.useBigInt64 = (options == null ? void 0 : options.useBigInt64) ?? !1, this.rawStrings = (options == null ? void 0 : options.rawStrings) ?? !1, this.maxStrLength = (options == null ? void 0 : options.maxStrLength) ?? UINT32_MAX, this.maxBinLength = (options == null ? void 0 : options.maxBinLength) ?? UINT32_MAX, this.maxArrayLength = (options == null ? void 0 : options.maxArrayLength) ?? UINT32_MAX, this.maxMapLength = (options == null ? void 0 : options.maxMapLength) ?? UINT32_MAX, this.maxExtLength = (options == null ? void 0 : options.maxExtLength) ?? UINT32_MAX, this.keyDecoder = (options == null ? void 0 : options.keyDecoder) !== void 0 ? options.keyDecoder : sharedCachedKeyDecoder, this.mapKeyConverter = (options == null ? void 0 : options.mapKeyConverter) ?? mapKeyConverter;
  }
  clone() {
    return new _Decoder({
      extensionCodec: this.extensionCodec,
      context: this.context,
      useBigInt64: this.useBigInt64,
      rawStrings: this.rawStrings,
      maxStrLength: this.maxStrLength,
      maxBinLength: this.maxBinLength,
      maxArrayLength: this.maxArrayLength,
      maxMapLength: this.maxMapLength,
      maxExtLength: this.maxExtLength,
      keyDecoder: this.keyDecoder
    });
  }
  reinitializeState() {
    this.totalPos = 0, this.headByte = HEAD_BYTE_REQUIRED, this.stack.reset();
  }
  setBuffer(buffer) {
    const bytes = ensureUint8Array(buffer);
    this.bytes = bytes, this.view = new DataView(bytes.buffer, bytes.byteOffset, bytes.byteLength), this.pos = 0;
  }
  appendBuffer(buffer) {
    if (this.headByte === HEAD_BYTE_REQUIRED && !this.hasRemaining(1))
      this.setBuffer(buffer);
    else {
      const remainingData = this.bytes.subarray(this.pos), newData = ensureUint8Array(buffer), newBuffer = new Uint8Array(remainingData.length + newData.length);
      newBuffer.set(remainingData), newBuffer.set(newData, remainingData.length), this.setBuffer(newBuffer);
    }
  }
  hasRemaining(size) {
    return this.view.byteLength - this.pos >= size;
  }
  createExtraByteError(posToShow) {
    const { view, pos } = this;
    return new RangeError(`Extra ${view.byteLength - pos} of ${view.byteLength} byte(s) found at buffer[${posToShow}]`);
  }
  /**
   * @throws {@link DecodeError}
   * @throws {@link RangeError}
   */
  decode(buffer) {
    if (this.entered)
      return this.clone().decode(buffer);
    try {
      this.entered = !0, this.reinitializeState(), this.setBuffer(buffer);
      const object = this.doDecodeSync();
      if (this.hasRemaining(1))
        throw this.createExtraByteError(this.pos);
      return object;
    } finally {
      this.entered = !1;
    }
  }
  *decodeMulti(buffer) {
    if (this.entered) {
      yield* this.clone().decodeMulti(buffer);
      return;
    }
    try {
      for (this.entered = !0, this.reinitializeState(), this.setBuffer(buffer); this.hasRemaining(1); )
        yield this.doDecodeSync();
    } finally {
      this.entered = !1;
    }
  }
  async decodeAsync(stream) {
    if (this.entered)
      return this.clone().decodeAsync(stream);
    try {
      this.entered = !0;
      let decoded = !1, object;
      for await (const buffer of stream) {
        if (decoded)
          throw this.entered = !1, this.createExtraByteError(this.totalPos);
        this.appendBuffer(buffer);
        try {
          object = this.doDecodeSync(), decoded = !0;
        } catch (e2) {
          if (!(e2 instanceof RangeError))
            throw e2;
        }
        this.totalPos += this.pos;
      }
      if (decoded) {
        if (this.hasRemaining(1))
          throw this.createExtraByteError(this.totalPos);
        return object;
      }
      const { headByte, pos, totalPos } = this;
      throw new RangeError(`Insufficient data in parsing ${prettyByte(headByte)} at ${totalPos} (${pos} in the current buffer)`);
    } finally {
      this.entered = !1;
    }
  }
  decodeArrayStream(stream) {
    return this.decodeMultiAsync(stream, !0);
  }
  decodeStream(stream) {
    return this.decodeMultiAsync(stream, !1);
  }
  async *decodeMultiAsync(stream, isArray2) {
    if (this.entered) {
      yield* this.clone().decodeMultiAsync(stream, isArray2);
      return;
    }
    try {
      this.entered = !0;
      let isArrayHeaderRequired = isArray2, arrayItemsLeft = -1;
      for await (const buffer of stream) {
        if (isArray2 && arrayItemsLeft === 0)
          throw this.createExtraByteError(this.totalPos);
        this.appendBuffer(buffer), isArrayHeaderRequired && (arrayItemsLeft = this.readArraySize(), isArrayHeaderRequired = !1, this.complete());
        try {
          for (; yield this.doDecodeSync(), --arrayItemsLeft !== 0; )
            ;
        } catch (e2) {
          if (!(e2 instanceof RangeError))
            throw e2;
        }
        this.totalPos += this.pos;
      }
    } finally {
      this.entered = !1;
    }
  }
  doDecodeSync() {
    DECODE: for (; ; ) {
      const headByte = this.readHeadByte();
      let object;
      if (headByte >= 224)
        object = headByte - 256;
      else if (headByte < 192)
        if (headByte < 128)
          object = headByte;
        else if (headByte < 144) {
          const size = headByte - 128;
          if (size !== 0) {
            this.pushMapState(size), this.complete();
            continue DECODE;
          } else
            object = {};
        } else if (headByte < 160) {
          const size = headByte - 144;
          if (size !== 0) {
            this.pushArrayState(size), this.complete();
            continue DECODE;
          } else
            object = [];
        } else {
          const byteLength = headByte - 160;
          object = this.decodeString(byteLength, 0);
        }
      else if (headByte === 192)
        object = null;
      else if (headByte === 194)
        object = !1;
      else if (headByte === 195)
        object = !0;
      else if (headByte === 202)
        object = this.readF32();
      else if (headByte === 203)
        object = this.readF64();
      else if (headByte === 204)
        object = this.readU8();
      else if (headByte === 205)
        object = this.readU16();
      else if (headByte === 206)
        object = this.readU32();
      else if (headByte === 207)
        this.useBigInt64 ? object = this.readU64AsBigInt() : object = this.readU64();
      else if (headByte === 208)
        object = this.readI8();
      else if (headByte === 209)
        object = this.readI16();
      else if (headByte === 210)
        object = this.readI32();
      else if (headByte === 211)
        this.useBigInt64 ? object = this.readI64AsBigInt() : object = this.readI64();
      else if (headByte === 217) {
        const byteLength = this.lookU8();
        object = this.decodeString(byteLength, 1);
      } else if (headByte === 218) {
        const byteLength = this.lookU16();
        object = this.decodeString(byteLength, 2);
      } else if (headByte === 219) {
        const byteLength = this.lookU32();
        object = this.decodeString(byteLength, 4);
      } else if (headByte === 220) {
        const size = this.readU16();
        if (size !== 0) {
          this.pushArrayState(size), this.complete();
          continue DECODE;
        } else
          object = [];
      } else if (headByte === 221) {
        const size = this.readU32();
        if (size !== 0) {
          this.pushArrayState(size), this.complete();
          continue DECODE;
        } else
          object = [];
      } else if (headByte === 222) {
        const size = this.readU16();
        if (size !== 0) {
          this.pushMapState(size), this.complete();
          continue DECODE;
        } else
          object = {};
      } else if (headByte === 223) {
        const size = this.readU32();
        if (size !== 0) {
          this.pushMapState(size), this.complete();
          continue DECODE;
        } else
          object = {};
      } else if (headByte === 196) {
        const size = this.lookU8();
        object = this.decodeBinary(size, 1);
      } else if (headByte === 197) {
        const size = this.lookU16();
        object = this.decodeBinary(size, 2);
      } else if (headByte === 198) {
        const size = this.lookU32();
        object = this.decodeBinary(size, 4);
      } else if (headByte === 212)
        object = this.decodeExtension(1, 0);
      else if (headByte === 213)
        object = this.decodeExtension(2, 0);
      else if (headByte === 214)
        object = this.decodeExtension(4, 0);
      else if (headByte === 215)
        object = this.decodeExtension(8, 0);
      else if (headByte === 216)
        object = this.decodeExtension(16, 0);
      else if (headByte === 199) {
        const size = this.lookU8();
        object = this.decodeExtension(size, 1);
      } else if (headByte === 200) {
        const size = this.lookU16();
        object = this.decodeExtension(size, 2);
      } else if (headByte === 201) {
        const size = this.lookU32();
        object = this.decodeExtension(size, 4);
      } else
        throw new DecodeError(`Unrecognized type byte: ${prettyByte(headByte)}`);
      this.complete();
      const stack = this.stack;
      for (; stack.length > 0; ) {
        const state2 = stack.top();
        if (state2.type === STATE_ARRAY)
          if (state2.array[state2.position] = object, state2.position++, state2.position === state2.size)
            object = state2.array, stack.release(state2);
          else
            continue DECODE;
        else if (state2.type === STATE_MAP_KEY) {
          if (object === "__proto__")
            throw new DecodeError("The key __proto__ is not allowed");
          state2.key = this.mapKeyConverter(object), state2.type = STATE_MAP_VALUE;
          continue DECODE;
        } else if (state2.map[state2.key] = object, state2.readCount++, state2.readCount === state2.size)
          object = state2.map, stack.release(state2);
        else {
          state2.key = null, state2.type = STATE_MAP_KEY;
          continue DECODE;
        }
      }
      return object;
    }
  }
  readHeadByte() {
    return this.headByte === HEAD_BYTE_REQUIRED && (this.headByte = this.readU8()), this.headByte;
  }
  complete() {
    this.headByte = HEAD_BYTE_REQUIRED;
  }
  readArraySize() {
    const headByte = this.readHeadByte();
    switch (headByte) {
      case 220:
        return this.readU16();
      case 221:
        return this.readU32();
      default: {
        if (headByte < 160)
          return headByte - 144;
        throw new DecodeError(`Unrecognized array type byte: ${prettyByte(headByte)}`);
      }
    }
  }
  pushMapState(size) {
    if (size > this.maxMapLength)
      throw new DecodeError(`Max length exceeded: map length (${size}) > maxMapLengthLength (${this.maxMapLength})`);
    this.stack.pushMapState(size);
  }
  pushArrayState(size) {
    if (size > this.maxArrayLength)
      throw new DecodeError(`Max length exceeded: array length (${size}) > maxArrayLength (${this.maxArrayLength})`);
    this.stack.pushArrayState(size);
  }
  decodeString(byteLength, headerOffset) {
    return !this.rawStrings || this.stateIsMapKey() ? this.decodeUtf8String(byteLength, headerOffset) : this.decodeBinary(byteLength, headerOffset);
  }
  /**
   * @throws {@link RangeError}
   */
  decodeUtf8String(byteLength, headerOffset) {
    var _a;
    if (byteLength > this.maxStrLength)
      throw new DecodeError(`Max length exceeded: UTF-8 byte length (${byteLength}) > maxStrLength (${this.maxStrLength})`);
    if (this.bytes.byteLength < this.pos + headerOffset + byteLength)
      throw MORE_DATA;
    const offset = this.pos + headerOffset;
    let object;
    return this.stateIsMapKey() && ((_a = this.keyDecoder) != null && _a.canBeCached(byteLength)) ? object = this.keyDecoder.decode(this.bytes, offset, byteLength) : object = utf8Decode(this.bytes, offset, byteLength), this.pos += headerOffset + byteLength, object;
  }
  stateIsMapKey() {
    return this.stack.length > 0 ? this.stack.top().type === STATE_MAP_KEY : !1;
  }
  /**
   * @throws {@link RangeError}
   */
  decodeBinary(byteLength, headOffset) {
    if (byteLength > this.maxBinLength)
      throw new DecodeError(`Max length exceeded: bin length (${byteLength}) > maxBinLength (${this.maxBinLength})`);
    if (!this.hasRemaining(byteLength + headOffset))
      throw MORE_DATA;
    const offset = this.pos + headOffset, object = this.bytes.subarray(offset, offset + byteLength);
    return this.pos += headOffset + byteLength, object;
  }
  decodeExtension(size, headOffset) {
    if (size > this.maxExtLength)
      throw new DecodeError(`Max length exceeded: ext length (${size}) > maxExtLength (${this.maxExtLength})`);
    const extType = this.view.getInt8(this.pos + headOffset), data = this.decodeBinary(
      size,
      headOffset + 1
      /* extType */
    );
    return this.extensionCodec.decode(data, extType, this.context);
  }
  lookU8() {
    return this.view.getUint8(this.pos);
  }
  lookU16() {
    return this.view.getUint16(this.pos);
  }
  lookU32() {
    return this.view.getUint32(this.pos);
  }
  readU8() {
    const value = this.view.getUint8(this.pos);
    return this.pos++, value;
  }
  readI8() {
    const value = this.view.getInt8(this.pos);
    return this.pos++, value;
  }
  readU16() {
    const value = this.view.getUint16(this.pos);
    return this.pos += 2, value;
  }
  readI16() {
    const value = this.view.getInt16(this.pos);
    return this.pos += 2, value;
  }
  readU32() {
    const value = this.view.getUint32(this.pos);
    return this.pos += 4, value;
  }
  readI32() {
    const value = this.view.getInt32(this.pos);
    return this.pos += 4, value;
  }
  readU64() {
    const value = getUint64(this.view, this.pos);
    return this.pos += 8, value;
  }
  readI64() {
    const value = getInt64(this.view, this.pos);
    return this.pos += 8, value;
  }
  readU64AsBigInt() {
    const value = this.view.getBigUint64(this.pos);
    return this.pos += 8, value;
  }
  readI64AsBigInt() {
    const value = this.view.getBigInt64(this.pos);
    return this.pos += 8, value;
  }
  readF32() {
    const value = this.view.getFloat32(this.pos);
    return this.pos += 4, value;
  }
  readF64() {
    const value = this.view.getFloat64(this.pos);
    return this.pos += 8, value;
  }
};
__name(_Decoder, "Decoder");
let Decoder = _Decoder;
const msgPackEncoder = new Encoder(), msgPackDecoder = new Decoder();
function registerModuleSettings() {
  game.settings.register(LancerAlternative.Name, "settings-verbose-logging", {
    name: "LA.SETTINGS.debug.label",
    hint: "LA.SETTINGS.debug.subLabel",
    scope: "client",
    config: !0,
    type: Boolean,
    default: !1
  });
}
__name(registerModuleSettings, "registerModuleSettings");
function getVerboseLoggingEnabled() {
  return game.settings.get(LancerAlternative.Name, "settings-verbose-logging");
}
__name(getVerboseLoggingEnabled, "getVerboseLoggingEnabled");
const _Logger = class _Logger {
  static log(message, ...args) {
    var _a;
    getVerboseLoggingEnabled() ? ((_a = ui.notifications) == null || _a.info(message), console.log(
      `%c[${this.moduleName} ${getModuleVersion()}] ${message}`,
      "color: #00FF00; font-weight: bold;",
      ...args
    )) : console.log(
      `%c[${this.moduleName} ${getModuleVersion()}] ${message}`,
      "color: #00FF00; font-weight: bold;"
    );
  }
  static error(message, ...args) {
    var _a;
    getVerboseLoggingEnabled() ? ((_a = ui.notifications) == null || _a.error(message), console.error(
      `%c[${this.moduleName} ${getModuleVersion()}] ${message}`,
      "color: #FF0000; font-weight: bold;",
      ...args
    )) : console.error(
      `%c[${this.moduleName} ${getModuleVersion()}] ${message}`,
      "color: #FF0000; font-weight: bold;"
    );
  }
  static warn(message, ...args) {
    var _a;
    getVerboseLoggingEnabled() ? ((_a = ui.notifications) == null || _a.warn(message), console.warn(
      `%c[${this.moduleName} ${getModuleVersion()}] ${message}`,
      "color: #FFA500; font-weight: bold;",
      ...args
    )) : console.warn(
      `%c[${this.moduleName} ${getModuleVersion()}] ${message}`,
      "color: #FFA500; font-weight: bold;"
    );
  }
};
__name(_Logger, "Logger"), __publicField(_Logger, "moduleName", "LAS");
let Logger = _Logger;
function formatDotpath(path) {
  return path.replace(/\[/g, ".").replace(/]/g, "");
}
__name(formatDotpath, "formatDotpath");
function stepwiseResolveDotpath(obj, dotpath) {
  let pathlets = formatDotpath(dotpath).split("."), result = [
    {
      pathlet: null,
      val: obj
    }
  ];
  for (let pathlet of pathlets)
    obj = obj == null ? void 0 : obj[pathlet], result.push({
      pathlet,
      val: obj
    });
  return result;
}
__name(stepwiseResolveDotpath, "stepwiseResolveDotpath");
function resolveDotpath(obj, dotpath, default_ = null, opts) {
  let path = stepwiseResolveDotpath(obj, dotpath), item;
  return item = path[path.length - 1], item.val === void 0 ? default_ : item.val;
}
__name(resolveDotpath, "resolveDotpath");
const RESOLVE_FAIL = Symbol("Fail");
function resolveHelperDotpath(options, path, default_ = null, try_parent = !1) {
  var _a;
  if (try_parent) {
    let data = options.data;
    for (; data; ) {
      let resolved = resolveDotpath(data == null ? void 0 : data.root, path, RESOLVE_FAIL);
      if (resolved != RESOLVE_FAIL)
        return resolved;
      data = data._parent;
    }
    return default_;
  } else
    return resolveDotpath((_a = options.data) == null ? void 0 : _a.root, path, default_);
}
__name(resolveHelperDotpath, "resolveHelperDotpath");
function array_path_edit_changes(target, flat_path, value, mode) {
  flat_path = formatDotpath(flat_path);
  let split = flat_path.split("."), tail = split.splice(split.length - 1)[0], lead = split.join("."), index2 = parseInt(tail), array = resolveDotpath(target, lead);
  if (Array.isArray(array) && !Number.isNaN(index2))
    return index2 > array.length && (index2 = array.length), index2 < 0 && (index2 = array.length + index2 + 1, index2 < 0 && (index2 = 0)), {
      path: lead,
      new_val: [...array.slice(0, index2), ...array.slice(index2 + 1)]
      // Drop element at index
    };
  throw new Error(`Unable to insert array item "${lead}[${tail}]": not an array (or not a valid index)`);
}
__name(array_path_edit_changes, "array_path_edit_changes");
function drilldownDocument(rootDoc, path) {
  let steps = stepwiseResolveDotpath(rootDoc, path);
  for (let i2 = steps.length - 1; i2 >= 0; i2--) {
    let step = steps[i2];
    if (step.val instanceof foundry.abstract.Document) {
      let sub_path = steps.slice(i2 + 1).map((v) => v.pathlet).join(".");
      return { sub_doc: step.val, sub_path, terminus: steps[steps.length - 1].val };
    }
  }
  throw new Error("Drilldown document must have at least one document in its path");
}
__name(drilldownDocument, "drilldownDocument");
async function parse_control_val(raw_val) {
  let match = raw_val.match(/\((.*?)\)(.*)/);
  if (match) {
    let type = match[1], val = match[2];
    switch (type) {
      case "string":
        return { success: !0, val };
      case "int":
        let parsed_int = parseInt(val);
        if (!Number.isNaN(parsed_int))
          return { success: !0, val: parsed_int };
        break;
      case "float":
        let parsed_float = parseFloat(val);
        if (!Number.isNaN(parsed_float))
          return { success: !0, val: parsed_float };
        break;
      case "bool":
        if (val == "true")
          return { success: !0, val: !0 };
        if (val == "false")
          return { success: !0, val: !1 };
      case "struct":
        return { success: !1, val: "I HAVE NO MOUTH, AND I MUST SCREAM" };
    }
  }
  return { success: !1, val: null };
}
__name(parse_control_val, "parse_control_val");
const DEV = !1;
var is_array = Array.isArray, index_of = Array.prototype.indexOf, array_from = Array.from, define_property = Object.defineProperty, get_descriptor = Object.getOwnPropertyDescriptor, get_descriptors = Object.getOwnPropertyDescriptors, object_prototype = Object.prototype, array_prototype = Array.prototype, get_prototype_of = Object.getPrototypeOf;
function is_function(thing) {
  return typeof thing == "function";
}
__name(is_function, "is_function");
const noop = /* @__PURE__ */ __name(() => {
}, "noop");
function run_all(arr) {
  for (var i2 = 0; i2 < arr.length; i2++)
    arr[i2]();
}
__name(run_all, "run_all");
const DERIVED = 2, EFFECT = 4, RENDER_EFFECT = 8, BLOCK_EFFECT = 16, BRANCH_EFFECT = 32, ROOT_EFFECT = 64, BOUNDARY_EFFECT = 128, UNOWNED = 256, DISCONNECTED = 512, CLEAN = 1024, DIRTY = 2048, MAYBE_DIRTY = 4096, INERT = 8192, DESTROYED = 16384, EFFECT_RAN = 32768, EFFECT_TRANSPARENT = 65536, HEAD_EFFECT = 1 << 19, EFFECT_HAS_DERIVED = 1 << 20, STATE_SYMBOL = Symbol("$state"), LEGACY_PROPS = Symbol("legacy props"), LOADING_ATTR_SYMBOL = Symbol("");
let is_micro_task_queued$1 = !1, current_queued_micro_tasks = [];
function process_micro_tasks() {
  is_micro_task_queued$1 = !1;
  const tasks = current_queued_micro_tasks.slice();
  current_queued_micro_tasks = [], run_all(tasks);
}
__name(process_micro_tasks, "process_micro_tasks");
function queue_micro_task(fn) {
  is_micro_task_queued$1 || (is_micro_task_queued$1 = !0, queueMicrotask(process_micro_tasks)), current_queued_micro_tasks.push(fn);
}
__name(queue_micro_task, "queue_micro_task");
function flush_tasks() {
  is_micro_task_queued$1 && process_micro_tasks();
}
__name(flush_tasks, "flush_tasks");
function equals(value) {
  return value === this.v;
}
__name(equals, "equals");
function safe_not_equal(a, b) {
  return a != a ? b == b : a !== b || a !== null && typeof a == "object" || typeof a == "function";
}
__name(safe_not_equal, "safe_not_equal");
function safe_equals(value) {
  return !safe_not_equal(value, this.v);
}
__name(safe_equals, "safe_equals");
function effect_in_teardown(rune) {
  throw new Error("https://svelte.dev/e/effect_in_teardown");
}
__name(effect_in_teardown, "effect_in_teardown");
function effect_in_unowned_derived() {
  throw new Error("https://svelte.dev/e/effect_in_unowned_derived");
}
__name(effect_in_unowned_derived, "effect_in_unowned_derived");
function effect_orphan(rune) {
  throw new Error("https://svelte.dev/e/effect_orphan");
}
__name(effect_orphan, "effect_orphan");
function effect_update_depth_exceeded() {
  throw new Error("https://svelte.dev/e/effect_update_depth_exceeded");
}
__name(effect_update_depth_exceeded, "effect_update_depth_exceeded");
function state_descriptors_fixed() {
  throw new Error("https://svelte.dev/e/state_descriptors_fixed");
}
__name(state_descriptors_fixed, "state_descriptors_fixed");
function state_prototype_fixed() {
  throw new Error("https://svelte.dev/e/state_prototype_fixed");
}
__name(state_prototype_fixed, "state_prototype_fixed");
function state_unsafe_local_read() {
  throw new Error("https://svelte.dev/e/state_unsafe_local_read");
}
__name(state_unsafe_local_read, "state_unsafe_local_read");
function state_unsafe_mutation() {
  throw new Error("https://svelte.dev/e/state_unsafe_mutation");
}
__name(state_unsafe_mutation, "state_unsafe_mutation");
let legacy_mode_flag = !1, tracing_mode_flag = !1;
function enable_legacy_mode_flag() {
  legacy_mode_flag = !0;
}
__name(enable_legacy_mode_flag, "enable_legacy_mode_flag");
const EACH_ITEM_REACTIVE = 1, EACH_INDEX_REACTIVE = 2, EACH_IS_CONTROLLED = 4, EACH_IS_ANIMATED = 8, EACH_ITEM_IMMUTABLE = 16, TEMPLATE_FRAGMENT = 1, TEMPLATE_USE_IMPORT_NODE = 2, UNINITIALIZED = Symbol();
function lifecycle_outside_component(name) {
  throw new Error("https://svelte.dev/e/lifecycle_outside_component");
}
__name(lifecycle_outside_component, "lifecycle_outside_component");
let component_context = null;
function set_component_context(context) {
  component_context = context;
}
__name(set_component_context, "set_component_context");
function push(props, runes = !1, fn) {
  component_context = {
    p: component_context,
    c: null,
    e: null,
    m: !1,
    s: props,
    x: null,
    l: null
  }, legacy_mode_flag && !runes && (component_context.l = {
    s: null,
    u: null,
    r1: [],
    r2: source(!1)
  });
}
__name(push, "push");
function pop(component) {
  const context_stack_item = component_context;
  if (context_stack_item !== null) {
    component !== void 0 && (context_stack_item.x = component);
    const component_effects = context_stack_item.e;
    if (component_effects !== null) {
      var previous_effect = active_effect, previous_reaction = active_reaction;
      context_stack_item.e = null;
      try {
        for (var i2 = 0; i2 < component_effects.length; i2++) {
          var component_effect = component_effects[i2];
          set_active_effect(component_effect.effect), set_active_reaction(component_effect.reaction), effect(component_effect.fn);
        }
      } finally {
        set_active_effect(previous_effect), set_active_reaction(previous_reaction);
      }
    }
    component_context = context_stack_item.p, context_stack_item.m = !0;
  }
  return component || /** @type {T} */
  {};
}
__name(pop, "pop");
function is_runes() {
  return !legacy_mode_flag || component_context !== null && component_context.l === null;
}
__name(is_runes, "is_runes");
function source(v, stack) {
  var signal = {
    f: 0,
    // TODO ideally we could skip this altogether, but it causes type errors
    v,
    reactions: null,
    equals,
    rv: 0,
    wv: 0
  };
  return signal;
}
__name(source, "source");
function state(v) {
  return /* @__PURE__ */ push_derived_source(source(v));
}
__name(state, "state");
// @__NO_SIDE_EFFECTS__
function mutable_source(initial_value, immutable = !1) {
  var _a;
  const s2 = source(initial_value);
  return immutable || (s2.equals = safe_equals), legacy_mode_flag && component_context !== null && component_context.l !== null && ((_a = component_context.l).s ?? (_a.s = [])).push(s2), s2;
}
__name(mutable_source, "mutable_source");
// @__NO_SIDE_EFFECTS__
function push_derived_source(source2) {
  return active_reaction !== null && !untracking && active_reaction.f & DERIVED && (derived_sources === null ? set_derived_sources([source2]) : derived_sources.push(source2)), source2;
}
__name(push_derived_source, "push_derived_source");
function set(source2, value) {
  return active_reaction !== null && !untracking && is_runes() && active_reaction.f & (DERIVED | BLOCK_EFFECT) && // If the source was created locally within the current derived, then
  // we allow the mutation.
  (derived_sources === null || !derived_sources.includes(source2)) && state_unsafe_mutation(), internal_set(source2, value);
}
__name(set, "set");
function internal_set(source2, value) {
  return source2.equals(value) || (source2.v, source2.v = value, source2.wv = increment_write_version(), mark_reactions(source2, DIRTY), is_runes() && active_effect !== null && active_effect.f & CLEAN && !(active_effect.f & (BRANCH_EFFECT | ROOT_EFFECT)) && (untracked_writes === null ? set_untracked_writes([source2]) : untracked_writes.push(source2))), value;
}
__name(internal_set, "internal_set");
function mark_reactions(signal, status) {
  var reactions = signal.reactions;
  if (reactions !== null)
    for (var runes = is_runes(), length = reactions.length, i2 = 0; i2 < length; i2++) {
      var reaction = reactions[i2], flags = reaction.f;
      flags & DIRTY || !runes && reaction === active_effect || (set_signal_status(reaction, status), flags & (CLEAN | UNOWNED) && (flags & DERIVED ? mark_reactions(
        /** @type {Derived} */
        reaction,
        MAYBE_DIRTY
      ) : schedule_effect(
        /** @type {Effect} */
        reaction
      )));
    }
}
__name(mark_reactions, "mark_reactions");
// @__NO_SIDE_EFFECTS__
function derived(fn) {
  var flags = DERIVED | DIRTY, parent_derived = active_reaction !== null && active_reaction.f & DERIVED ? (
    /** @type {Derived} */
    active_reaction
  ) : null;
  return active_effect === null || parent_derived !== null && parent_derived.f & UNOWNED ? flags |= UNOWNED : active_effect.f |= EFFECT_HAS_DERIVED, {
    ctx: component_context,
    deps: null,
    effects: null,
    equals,
    f: flags,
    fn,
    reactions: null,
    rv: 0,
    v: (
      /** @type {V} */
      null
    ),
    wv: 0,
    parent: parent_derived ?? active_effect
  };
}
__name(derived, "derived");
// @__NO_SIDE_EFFECTS__
function derived_safe_equal(fn) {
  const signal = /* @__PURE__ */ derived(fn);
  return signal.equals = safe_equals, signal;
}
__name(derived_safe_equal, "derived_safe_equal");
function destroy_derived_effects(derived2) {
  var effects = derived2.effects;
  if (effects !== null) {
    derived2.effects = null;
    for (var i2 = 0; i2 < effects.length; i2 += 1)
      destroy_effect(
        /** @type {Effect} */
        effects[i2]
      );
  }
}
__name(destroy_derived_effects, "destroy_derived_effects");
function get_derived_parent_effect(derived2) {
  for (var parent = derived2.parent; parent !== null; ) {
    if (!(parent.f & DERIVED))
      return (
        /** @type {Effect} */
        parent
      );
    parent = parent.parent;
  }
  return null;
}
__name(get_derived_parent_effect, "get_derived_parent_effect");
function execute_derived(derived2) {
  var value, prev_active_effect = active_effect;
  set_active_effect(get_derived_parent_effect(derived2));
  try {
    destroy_derived_effects(derived2), value = update_reaction(derived2);
  } finally {
    set_active_effect(prev_active_effect);
  }
  return value;
}
__name(execute_derived, "execute_derived");
function update_derived(derived2) {
  var value = execute_derived(derived2), status = (skip_reaction || derived2.f & UNOWNED) && derived2.deps !== null ? MAYBE_DIRTY : CLEAN;
  set_signal_status(derived2, status), derived2.equals(value) || (derived2.v = value, derived2.wv = increment_write_version());
}
__name(update_derived, "update_derived");
let hydrating = !1;
function proxy(value, parent = null, prev) {
  if (typeof value != "object" || value === null || STATE_SYMBOL in value)
    return value;
  const prototype = get_prototype_of(value);
  if (prototype !== object_prototype && prototype !== array_prototype)
    return value;
  var sources = /* @__PURE__ */ new Map(), is_proxied_array = is_array(value), version = source(0);
  is_proxied_array && sources.set("length", source(
    /** @type {any[]} */
    value.length
  ));
  var metadata;
  return new Proxy(
    /** @type {any} */
    value,
    {
      defineProperty(_, prop2, descriptor) {
        (!("value" in descriptor) || descriptor.configurable === !1 || descriptor.enumerable === !1 || descriptor.writable === !1) && state_descriptors_fixed();
        var s2 = sources.get(prop2);
        return s2 === void 0 ? (s2 = source(descriptor.value), sources.set(prop2, s2)) : set(s2, proxy(descriptor.value, metadata)), !0;
      },
      deleteProperty(target, prop2) {
        var s2 = sources.get(prop2);
        if (s2 === void 0)
          prop2 in target && sources.set(prop2, source(UNINITIALIZED));
        else {
          if (is_proxied_array && typeof prop2 == "string") {
            var ls = (
              /** @type {Source<number>} */
              sources.get("length")
            ), n2 = Number(prop2);
            Number.isInteger(n2) && n2 < ls.v && set(ls, n2);
          }
          set(s2, UNINITIALIZED), update_version(version);
        }
        return !0;
      },
      get(target, prop2, receiver) {
        var _a;
        if (prop2 === STATE_SYMBOL)
          return value;
        var s2 = sources.get(prop2), exists = prop2 in target;
        if (s2 === void 0 && (!exists || (_a = get_descriptor(target, prop2)) != null && _a.writable) && (s2 = source(proxy(exists ? target[prop2] : UNINITIALIZED, metadata)), sources.set(prop2, s2)), s2 !== void 0) {
          var v = get$1(s2);
          return v === UNINITIALIZED ? void 0 : v;
        }
        return Reflect.get(target, prop2, receiver);
      },
      getOwnPropertyDescriptor(target, prop2) {
        var descriptor = Reflect.getOwnPropertyDescriptor(target, prop2);
        if (descriptor && "value" in descriptor) {
          var s2 = sources.get(prop2);
          s2 && (descriptor.value = get$1(s2));
        } else if (descriptor === void 0) {
          var source2 = sources.get(prop2), value2 = source2 == null ? void 0 : source2.v;
          if (source2 !== void 0 && value2 !== UNINITIALIZED)
            return {
              enumerable: !0,
              configurable: !0,
              value: value2,
              writable: !0
            };
        }
        return descriptor;
      },
      has(target, prop2) {
        var _a;
        if (prop2 === STATE_SYMBOL)
          return !0;
        var s2 = sources.get(prop2), has = s2 !== void 0 && s2.v !== UNINITIALIZED || Reflect.has(target, prop2);
        if (s2 !== void 0 || active_effect !== null && (!has || (_a = get_descriptor(target, prop2)) != null && _a.writable)) {
          s2 === void 0 && (s2 = source(has ? proxy(target[prop2], metadata) : UNINITIALIZED), sources.set(prop2, s2));
          var value2 = get$1(s2);
          if (value2 === UNINITIALIZED)
            return !1;
        }
        return has;
      },
      set(target, prop2, value2, receiver) {
        var _a;
        var s2 = sources.get(prop2), has = prop2 in target;
        if (is_proxied_array && prop2 === "length")
          for (var i2 = value2; i2 < /** @type {Source<number>} */
          s2.v; i2 += 1) {
            var other_s = sources.get(i2 + "");
            other_s !== void 0 ? set(other_s, UNINITIALIZED) : i2 in target && (other_s = source(UNINITIALIZED), sources.set(i2 + "", other_s));
          }
        s2 === void 0 ? (!has || (_a = get_descriptor(target, prop2)) != null && _a.writable) && (s2 = source(void 0), set(s2, proxy(value2, metadata)), sources.set(prop2, s2)) : (has = s2.v !== UNINITIALIZED, set(s2, proxy(value2, metadata)));
        var descriptor = Reflect.getOwnPropertyDescriptor(target, prop2);
        if (descriptor != null && descriptor.set && descriptor.set.call(receiver, value2), !has) {
          if (is_proxied_array && typeof prop2 == "string") {
            var ls = (
              /** @type {Source<number>} */
              sources.get("length")
            ), n2 = Number(prop2);
            Number.isInteger(n2) && n2 >= ls.v && set(ls, n2 + 1);
          }
          update_version(version);
        }
        return !0;
      },
      ownKeys(target) {
        get$1(version);
        var own_keys = Reflect.ownKeys(target).filter((key2) => {
          var source3 = sources.get(key2);
          return source3 === void 0 || source3.v !== UNINITIALIZED;
        });
        for (var [key, source2] of sources)
          source2.v !== UNINITIALIZED && !(key in target) && own_keys.push(key);
        return own_keys;
      },
      setPrototypeOf() {
        state_prototype_fixed();
      }
    }
  );
}
__name(proxy, "proxy");
function update_version(signal, d = 1) {
  set(signal, signal.v + d);
}
__name(update_version, "update_version");
var $window, is_firefox, first_child_getter, next_sibling_getter;
function init_operations() {
  if ($window === void 0) {
    $window = window, is_firefox = /Firefox/.test(navigator.userAgent);
    var element_prototype = Element.prototype, node_prototype = Node.prototype;
    first_child_getter = get_descriptor(node_prototype, "firstChild").get, next_sibling_getter = get_descriptor(node_prototype, "nextSibling").get, element_prototype.__click = void 0, element_prototype.__className = "", element_prototype.__attributes = null, element_prototype.__styles = null, element_prototype.__e = void 0, Text.prototype.__t = void 0;
  }
}
__name(init_operations, "init_operations");
function create_text(value = "") {
  return document.createTextNode(value);
}
__name(create_text, "create_text");
// @__NO_SIDE_EFFECTS__
function get_first_child(node) {
  return first_child_getter.call(node);
}
__name(get_first_child, "get_first_child");
// @__NO_SIDE_EFFECTS__
function get_next_sibling(node) {
  return next_sibling_getter.call(node);
}
__name(get_next_sibling, "get_next_sibling");
function child(node, is_text) {
  return /* @__PURE__ */ get_first_child(node);
}
__name(child, "child");
function first_child(fragment, is_text) {
  {
    var first = (
      /** @type {DocumentFragment} */
      /* @__PURE__ */ get_first_child(
        /** @type {Node} */
        fragment
      )
    );
    return first instanceof Comment && first.data === "" ? /* @__PURE__ */ get_next_sibling(first) : first;
  }
}
__name(first_child, "first_child");
function sibling(node, count = 1, is_text = !1) {
  let next_sibling = node;
  for (; count--; )
    next_sibling = /** @type {TemplateNode} */
    /* @__PURE__ */ get_next_sibling(next_sibling);
  return next_sibling;
}
__name(sibling, "sibling");
function clear_text_content(node) {
  node.textContent = "";
}
__name(clear_text_content, "clear_text_content");
const FLUSH_MICROTASK = 0, FLUSH_SYNC = 1;
let is_throwing_error = !1, scheduler_mode = FLUSH_MICROTASK, is_micro_task_queued = !1, last_scheduled_effect = null, is_flushing_effect = !1, is_destroying_effect = !1;
function set_is_flushing_effect(value) {
  is_flushing_effect = value;
}
__name(set_is_flushing_effect, "set_is_flushing_effect");
function set_is_destroying_effect(value) {
  is_destroying_effect = value;
}
__name(set_is_destroying_effect, "set_is_destroying_effect");
let queued_root_effects = [], flush_count = 0;
let active_reaction = null, untracking = !1;
function set_active_reaction(reaction) {
  active_reaction = reaction;
}
__name(set_active_reaction, "set_active_reaction");
let active_effect = null;
function set_active_effect(effect2) {
  active_effect = effect2;
}
__name(set_active_effect, "set_active_effect");
let derived_sources = null;
function set_derived_sources(sources) {
  derived_sources = sources;
}
__name(set_derived_sources, "set_derived_sources");
let new_deps = null, skipped_deps = 0, untracked_writes = null;
function set_untracked_writes(value) {
  untracked_writes = value;
}
__name(set_untracked_writes, "set_untracked_writes");
let write_version = 1, read_version = 0, skip_reaction = !1;
function increment_write_version() {
  return ++write_version;
}
__name(increment_write_version, "increment_write_version");
function check_dirtiness(reaction) {
  var _a;
  var flags = reaction.f;
  if (flags & DIRTY)
    return !0;
  if (flags & MAYBE_DIRTY) {
    var dependencies = reaction.deps, is_unowned = (flags & UNOWNED) !== 0;
    if (dependencies !== null) {
      var i2, dependency, is_disconnected = (flags & DISCONNECTED) !== 0, is_unowned_connected = is_unowned && active_effect !== null && !skip_reaction, length = dependencies.length;
      if (is_disconnected || is_unowned_connected) {
        var derived2 = (
          /** @type {Derived} */
          reaction
        ), parent = derived2.parent;
        for (i2 = 0; i2 < length; i2++)
          dependency = dependencies[i2], (is_disconnected || !((_a = dependency == null ? void 0 : dependency.reactions) != null && _a.includes(derived2))) && (dependency.reactions ?? (dependency.reactions = [])).push(derived2);
        is_disconnected && (derived2.f ^= DISCONNECTED), is_unowned_connected && parent !== null && !(parent.f & UNOWNED) && (derived2.f ^= UNOWNED);
      }
      for (i2 = 0; i2 < length; i2++)
        if (dependency = dependencies[i2], check_dirtiness(
          /** @type {Derived} */
          dependency
        ) && update_derived(
          /** @type {Derived} */
          dependency
        ), dependency.wv > reaction.wv)
          return !0;
    }
    (!is_unowned || active_effect !== null && !skip_reaction) && set_signal_status(reaction, CLEAN);
  }
  return !1;
}
__name(check_dirtiness, "check_dirtiness");
function propagate_error(error, effect2) {
  for (var current = effect2; current !== null; ) {
    if (current.f & BOUNDARY_EFFECT)
      try {
        current.fn(error);
        return;
      } catch {
        current.f ^= BOUNDARY_EFFECT;
      }
    current = current.parent;
  }
  throw is_throwing_error = !1, error;
}
__name(propagate_error, "propagate_error");
function should_rethrow_error(effect2) {
  return (effect2.f & DESTROYED) === 0 && (effect2.parent === null || (effect2.parent.f & BOUNDARY_EFFECT) === 0);
}
__name(should_rethrow_error, "should_rethrow_error");
function handle_error(error, effect2, previous_effect, component_context2) {
  if (is_throwing_error) {
    if (previous_effect === null && (is_throwing_error = !1), should_rethrow_error(effect2))
      throw error;
    return;
  }
  previous_effect !== null && (is_throwing_error = !0);
  {
    propagate_error(error, effect2);
    return;
  }
}
__name(handle_error, "handle_error");
function schedule_possible_effect_self_invalidation(signal, effect2, root2 = !0) {
  var reactions = signal.reactions;
  if (reactions !== null)
    for (var i2 = 0; i2 < reactions.length; i2++) {
      var reaction = reactions[i2];
      reaction.f & DERIVED ? schedule_possible_effect_self_invalidation(
        /** @type {Derived} */
        reaction,
        effect2,
        !1
      ) : effect2 === reaction && (root2 ? set_signal_status(reaction, DIRTY) : reaction.f & CLEAN && set_signal_status(reaction, MAYBE_DIRTY), schedule_effect(
        /** @type {Effect} */
        reaction
      ));
    }
}
__name(schedule_possible_effect_self_invalidation, "schedule_possible_effect_self_invalidation");
function update_reaction(reaction) {
  var _a;
  var previous_deps = new_deps, previous_skipped_deps = skipped_deps, previous_untracked_writes = untracked_writes, previous_reaction = active_reaction, previous_skip_reaction = skip_reaction, prev_derived_sources = derived_sources, previous_component_context = component_context, previous_untracking = untracking, flags = reaction.f;
  new_deps = /** @type {null | Value[]} */
  null, skipped_deps = 0, untracked_writes = null, active_reaction = flags & (BRANCH_EFFECT | ROOT_EFFECT) ? null : reaction, skip_reaction = (flags & UNOWNED) !== 0 && (!is_flushing_effect || previous_reaction === null || previous_untracking), derived_sources = null, set_component_context(reaction.ctx), untracking = !1, read_version++;
  try {
    var result = (
      /** @type {Function} */
      (0, reaction.fn)()
    ), deps = reaction.deps;
    if (new_deps !== null) {
      var i2;
      if (remove_reactions(reaction, skipped_deps), deps !== null && skipped_deps > 0)
        for (deps.length = skipped_deps + new_deps.length, i2 = 0; i2 < new_deps.length; i2++)
          deps[skipped_deps + i2] = new_deps[i2];
      else
        reaction.deps = deps = new_deps;
      if (!skip_reaction)
        for (i2 = skipped_deps; i2 < deps.length; i2++)
          ((_a = deps[i2]).reactions ?? (_a.reactions = [])).push(reaction);
    } else deps !== null && skipped_deps < deps.length && (remove_reactions(reaction, skipped_deps), deps.length = skipped_deps);
    if (is_runes() && untracked_writes !== null && !untracking && deps !== null && !(reaction.f & (DERIVED | MAYBE_DIRTY | DIRTY)))
      for (i2 = 0; i2 < /** @type {Source[]} */
      untracked_writes.length; i2++)
        schedule_possible_effect_self_invalidation(
          untracked_writes[i2],
          /** @type {Effect} */
          reaction
        );
    return previous_reaction !== null && read_version++, result;
  } finally {
    new_deps = previous_deps, skipped_deps = previous_skipped_deps, untracked_writes = previous_untracked_writes, active_reaction = previous_reaction, skip_reaction = previous_skip_reaction, derived_sources = prev_derived_sources, set_component_context(previous_component_context), untracking = previous_untracking;
  }
}
__name(update_reaction, "update_reaction");
function remove_reaction(signal, dependency) {
  let reactions = dependency.reactions;
  if (reactions !== null) {
    var index2 = index_of.call(reactions, signal);
    if (index2 !== -1) {
      var new_length = reactions.length - 1;
      new_length === 0 ? reactions = dependency.reactions = null : (reactions[index2] = reactions[new_length], reactions.pop());
    }
  }
  reactions === null && dependency.f & DERIVED && // Destroying a child effect while updating a parent effect can cause a dependency to appear
  // to be unused, when in fact it is used by the currently-updating parent. Checking `new_deps`
  // allows us to skip the expensive work of disconnecting and immediately reconnecting it
  (new_deps === null || !new_deps.includes(dependency)) && (set_signal_status(dependency, MAYBE_DIRTY), dependency.f & (UNOWNED | DISCONNECTED) || (dependency.f ^= DISCONNECTED), destroy_derived_effects(
    /** @type {Derived} **/
    dependency
  ), remove_reactions(
    /** @type {Derived} **/
    dependency,
    0
  ));
}
__name(remove_reaction, "remove_reaction");
function remove_reactions(signal, start_index) {
  var dependencies = signal.deps;
  if (dependencies !== null)
    for (var i2 = start_index; i2 < dependencies.length; i2++)
      remove_reaction(signal, dependencies[i2]);
}
__name(remove_reactions, "remove_reactions");
function update_effect(effect2) {
  var flags = effect2.f;
  if (!(flags & DESTROYED)) {
    set_signal_status(effect2, CLEAN);
    var previous_effect = active_effect, previous_component_context = component_context;
    active_effect = effect2;
    try {
      flags & BLOCK_EFFECT ? destroy_block_effect_children(effect2) : destroy_effect_children(effect2), execute_effect_teardown(effect2);
      var teardown2 = update_reaction(effect2);
      effect2.teardown = typeof teardown2 == "function" ? teardown2 : null, effect2.wv = write_version;
      var deps = effect2.deps, dep;
      DEV && tracing_mode_flag && effect2.f & DIRTY;
    } catch (error) {
      handle_error(error, effect2, previous_effect, previous_component_context || effect2.ctx);
    } finally {
      active_effect = previous_effect;
    }
  }
}
__name(update_effect, "update_effect");
function infinite_loop_guard() {
  if (flush_count > 1e3) {
    flush_count = 0;
    try {
      effect_update_depth_exceeded();
    } catch (error) {
      if (last_scheduled_effect !== null)
        handle_error(error, last_scheduled_effect, null);
      else
        throw error;
    }
  }
  flush_count++;
}
__name(infinite_loop_guard, "infinite_loop_guard");
function flush_queued_root_effects(root_effects) {
  var length = root_effects.length;
  if (length !== 0) {
    infinite_loop_guard();
    var previously_flushing_effect = is_flushing_effect;
    is_flushing_effect = !0;
    try {
      for (var i2 = 0; i2 < length; i2++) {
        var effect2 = root_effects[i2];
        effect2.f & CLEAN || (effect2.f ^= CLEAN);
        var collected_effects = process_effects(effect2);
        flush_queued_effects(collected_effects);
      }
    } finally {
      is_flushing_effect = previously_flushing_effect;
    }
  }
}
__name(flush_queued_root_effects, "flush_queued_root_effects");
function flush_queued_effects(effects) {
  var length = effects.length;
  if (length !== 0)
    for (var i2 = 0; i2 < length; i2++) {
      var effect2 = effects[i2];
      if (!(effect2.f & (DESTROYED | INERT)))
        try {
          check_dirtiness(effect2) && (update_effect(effect2), effect2.deps === null && effect2.first === null && effect2.nodes_start === null && (effect2.teardown === null ? unlink_effect(effect2) : effect2.fn = null));
        } catch (error) {
          handle_error(error, effect2, null, effect2.ctx);
        }
    }
}
__name(flush_queued_effects, "flush_queued_effects");
function process_deferred() {
  if (is_micro_task_queued = !1, flush_count > 1001)
    return;
  const previous_queued_root_effects = queued_root_effects;
  queued_root_effects = [], flush_queued_root_effects(previous_queued_root_effects), is_micro_task_queued || (flush_count = 0, last_scheduled_effect = null);
}
__name(process_deferred, "process_deferred");
function schedule_effect(signal) {
  scheduler_mode === FLUSH_MICROTASK && (is_micro_task_queued || (is_micro_task_queued = !0, queueMicrotask(process_deferred))), last_scheduled_effect = signal;
  for (var effect2 = signal; effect2.parent !== null; ) {
    effect2 = effect2.parent;
    var flags = effect2.f;
    if (flags & (ROOT_EFFECT | BRANCH_EFFECT)) {
      if (!(flags & CLEAN)) return;
      effect2.f ^= CLEAN;
    }
  }
  queued_root_effects.push(effect2);
}
__name(schedule_effect, "schedule_effect");
function process_effects(effect2) {
  var effects = [], current_effect = effect2.first;
  main_loop: for (; current_effect !== null; ) {
    var flags = current_effect.f, is_branch = (flags & BRANCH_EFFECT) !== 0, is_skippable_branch = is_branch && (flags & CLEAN) !== 0, sibling2 = current_effect.next;
    if (!is_skippable_branch && !(flags & INERT)) {
      if (flags & EFFECT)
        effects.push(current_effect);
      else if (is_branch)
        current_effect.f ^= CLEAN;
      else {
        var previous_active_reaction = active_reaction;
        try {
          active_reaction = current_effect, check_dirtiness(current_effect) && update_effect(current_effect);
        } catch (error) {
          handle_error(error, current_effect, null, current_effect.ctx);
        } finally {
          active_reaction = previous_active_reaction;
        }
      }
      var child2 = current_effect.first;
      if (child2 !== null) {
        current_effect = child2;
        continue;
      }
    }
    if (sibling2 === null) {
      let parent = current_effect.parent;
      for (; parent !== null; ) {
        if (effect2 === parent)
          break main_loop;
        var parent_sibling = parent.next;
        if (parent_sibling !== null) {
          current_effect = parent_sibling;
          continue main_loop;
        }
        parent = parent.parent;
      }
    }
    current_effect = sibling2;
  }
  return effects;
}
__name(process_effects, "process_effects");
function flush_sync(fn) {
  var previous_scheduler_mode = scheduler_mode, previous_queued_root_effects = queued_root_effects;
  try {
    infinite_loop_guard();
    const root_effects = [];
    scheduler_mode = FLUSH_SYNC, queued_root_effects = root_effects, is_micro_task_queued = !1, flush_queued_root_effects(previous_queued_root_effects);
    var result = fn == null ? void 0 : fn();
    return flush_tasks(), (queued_root_effects.length > 0 || root_effects.length > 0) && flush_sync(), flush_count = 0, last_scheduled_effect = null, result;
  } finally {
    scheduler_mode = previous_scheduler_mode, queued_root_effects = previous_queued_root_effects;
  }
}
__name(flush_sync, "flush_sync");
async function tick() {
  await Promise.resolve(), flush_sync();
}
__name(tick, "tick");
function get$1(signal) {
  var flags = signal.f, is_derived = (flags & DERIVED) !== 0;
  if (active_reaction !== null && !untracking) {
    derived_sources !== null && derived_sources.includes(signal) && state_unsafe_local_read();
    var deps = active_reaction.deps;
    signal.rv < read_version && (signal.rv = read_version, new_deps === null && deps !== null && deps[skipped_deps] === signal ? skipped_deps++ : new_deps === null ? new_deps = [signal] : (!skip_reaction || !new_deps.includes(signal)) && new_deps.push(signal));
  } else if (is_derived && /** @type {Derived} */
  signal.deps === null && /** @type {Derived} */
  signal.effects === null) {
    var derived2 = (
      /** @type {Derived} */
      signal
    ), parent = derived2.parent;
    parent !== null && !(parent.f & UNOWNED) && (derived2.f ^= UNOWNED);
  }
  return is_derived && (derived2 = /** @type {Derived} */
  signal, check_dirtiness(derived2) && update_derived(derived2)), signal.v;
}
__name(get$1, "get$1");
function untrack(fn) {
  var previous_untracking = untracking;
  try {
    return untracking = !0, fn();
  } finally {
    untracking = previous_untracking;
  }
}
__name(untrack, "untrack");
const STATUS_MASK = -7169;
function set_signal_status(signal, status) {
  signal.f = signal.f & STATUS_MASK | status;
}
__name(set_signal_status, "set_signal_status");
function validate_effect(rune) {
  active_effect === null && active_reaction === null && effect_orphan(), active_reaction !== null && active_reaction.f & UNOWNED && active_effect === null && effect_in_unowned_derived(), is_destroying_effect && effect_in_teardown();
}
__name(validate_effect, "validate_effect");
function push_effect(effect2, parent_effect) {
  var parent_last = parent_effect.last;
  parent_last === null ? parent_effect.last = parent_effect.first = effect2 : (parent_last.next = effect2, effect2.prev = parent_last, parent_effect.last = effect2);
}
__name(push_effect, "push_effect");
function create_effect(type, fn, sync, push2 = !0) {
  var is_root = (type & ROOT_EFFECT) !== 0, parent_effect = active_effect, effect2 = {
    ctx: component_context,
    deps: null,
    nodes_start: null,
    nodes_end: null,
    f: type | DIRTY,
    first: null,
    fn,
    last: null,
    next: null,
    parent: is_root ? null : parent_effect,
    prev: null,
    teardown: null,
    transitions: null,
    wv: 0
  };
  if (sync) {
    var previously_flushing_effect = is_flushing_effect;
    try {
      set_is_flushing_effect(!0), update_effect(effect2), effect2.f |= EFFECT_RAN;
    } catch (e2) {
      throw destroy_effect(effect2), e2;
    } finally {
      set_is_flushing_effect(previously_flushing_effect);
    }
  } else fn !== null && schedule_effect(effect2);
  var inert = sync && effect2.deps === null && effect2.first === null && effect2.nodes_start === null && effect2.teardown === null && (effect2.f & (EFFECT_HAS_DERIVED | BOUNDARY_EFFECT)) === 0;
  if (!inert && !is_root && push2 && (parent_effect !== null && push_effect(effect2, parent_effect), active_reaction !== null && active_reaction.f & DERIVED)) {
    var derived2 = (
      /** @type {Derived} */
      active_reaction
    );
    (derived2.effects ?? (derived2.effects = [])).push(effect2);
  }
  return effect2;
}
__name(create_effect, "create_effect");
function effect_tracking() {
  return active_reaction !== null && !untracking;
}
__name(effect_tracking, "effect_tracking");
function teardown(fn) {
  const effect2 = create_effect(RENDER_EFFECT, null, !1);
  return set_signal_status(effect2, CLEAN), effect2.teardown = fn, effect2;
}
__name(teardown, "teardown");
function user_effect(fn) {
  validate_effect();
  var defer = active_effect !== null && (active_effect.f & BRANCH_EFFECT) !== 0 && component_context !== null && !component_context.m;
  if (defer) {
    var context = (
      /** @type {ComponentContext} */
      component_context
    );
    (context.e ?? (context.e = [])).push({
      fn,
      effect: active_effect,
      reaction: active_reaction
    });
  } else {
    var signal = effect(fn);
    return signal;
  }
}
__name(user_effect, "user_effect");
function component_root(fn) {
  const effect2 = create_effect(ROOT_EFFECT, fn, !0);
  return (options = {}) => new Promise((fulfil) => {
    options.outro ? pause_effect(effect2, () => {
      destroy_effect(effect2), fulfil(void 0);
    }) : (destroy_effect(effect2), fulfil(void 0));
  });
}
__name(component_root, "component_root");
function effect(fn) {
  return create_effect(EFFECT, fn, !1);
}
__name(effect, "effect");
function render_effect(fn) {
  return create_effect(RENDER_EFFECT, fn, !0);
}
__name(render_effect, "render_effect");
function template_effect(fn, thunks = [], d = derived) {
  const deriveds = thunks.map(d);
  return block(/* @__PURE__ */ __name(() => fn(...deriveds.map(get$1)), "effect"));
}
__name(template_effect, "template_effect");
function block(fn, flags = 0) {
  return create_effect(RENDER_EFFECT | BLOCK_EFFECT | flags, fn, !0);
}
__name(block, "block");
function branch(fn, push2 = !0) {
  return create_effect(RENDER_EFFECT | BRANCH_EFFECT, fn, !0, push2);
}
__name(branch, "branch");
function execute_effect_teardown(effect2) {
  var teardown2 = effect2.teardown;
  if (teardown2 !== null) {
    const previously_destroying_effect = is_destroying_effect, previous_reaction = active_reaction;
    set_is_destroying_effect(!0), set_active_reaction(null);
    try {
      teardown2.call(null);
    } finally {
      set_is_destroying_effect(previously_destroying_effect), set_active_reaction(previous_reaction);
    }
  }
}
__name(execute_effect_teardown, "execute_effect_teardown");
function destroy_effect_children(signal, remove_dom = !1) {
  var effect2 = signal.first;
  for (signal.first = signal.last = null; effect2 !== null; ) {
    var next = effect2.next;
    destroy_effect(effect2, remove_dom), effect2 = next;
  }
}
__name(destroy_effect_children, "destroy_effect_children");
function destroy_block_effect_children(signal) {
  for (var effect2 = signal.first; effect2 !== null; ) {
    var next = effect2.next;
    effect2.f & BRANCH_EFFECT || destroy_effect(effect2), effect2 = next;
  }
}
__name(destroy_block_effect_children, "destroy_block_effect_children");
function destroy_effect(effect2, remove_dom = !0) {
  var removed = !1;
  if ((remove_dom || effect2.f & HEAD_EFFECT) && effect2.nodes_start !== null) {
    for (var node = effect2.nodes_start, end = effect2.nodes_end; node !== null; ) {
      var next = node === end ? null : (
        /** @type {TemplateNode} */
        /* @__PURE__ */ get_next_sibling(node)
      );
      node.remove(), node = next;
    }
    removed = !0;
  }
  destroy_effect_children(effect2, remove_dom && !removed), remove_reactions(effect2, 0), set_signal_status(effect2, DESTROYED);
  var transitions = effect2.transitions;
  if (transitions !== null)
    for (const transition of transitions)
      transition.stop();
  execute_effect_teardown(effect2);
  var parent = effect2.parent;
  parent !== null && parent.first !== null && unlink_effect(effect2), effect2.next = effect2.prev = effect2.teardown = effect2.ctx = effect2.deps = effect2.fn = effect2.nodes_start = effect2.nodes_end = null;
}
__name(destroy_effect, "destroy_effect");
function unlink_effect(effect2) {
  var parent = effect2.parent, prev = effect2.prev, next = effect2.next;
  prev !== null && (prev.next = next), next !== null && (next.prev = prev), parent !== null && (parent.first === effect2 && (parent.first = next), parent.last === effect2 && (parent.last = prev));
}
__name(unlink_effect, "unlink_effect");
function pause_effect(effect2, callback) {
  var transitions = [];
  pause_children(effect2, transitions, !0), run_out_transitions(transitions, () => {
    destroy_effect(effect2), callback && callback();
  });
}
__name(pause_effect, "pause_effect");
function run_out_transitions(transitions, fn) {
  var remaining = transitions.length;
  if (remaining > 0) {
    var check = /* @__PURE__ */ __name(() => --remaining || fn(), "check");
    for (var transition of transitions)
      transition.out(check);
  } else
    fn();
}
__name(run_out_transitions, "run_out_transitions");
function pause_children(effect2, transitions, local) {
  if (!(effect2.f & INERT)) {
    if (effect2.f ^= INERT, effect2.transitions !== null)
      for (const transition of effect2.transitions)
        (transition.is_global || local) && transitions.push(transition);
    for (var child2 = effect2.first; child2 !== null; ) {
      var sibling2 = child2.next, transparent = (child2.f & EFFECT_TRANSPARENT) !== 0 || (child2.f & BRANCH_EFFECT) !== 0;
      pause_children(child2, transitions, transparent ? local : !1), child2 = sibling2;
    }
  }
}
__name(pause_children, "pause_children");
function resume_effect(effect2) {
  resume_children(effect2, !0);
}
__name(resume_effect, "resume_effect");
function resume_children(effect2, local) {
  if (effect2.f & INERT) {
    effect2.f ^= INERT, effect2.f & CLEAN || (effect2.f ^= CLEAN), check_dirtiness(effect2) && (set_signal_status(effect2, DIRTY), schedule_effect(effect2));
    for (var child2 = effect2.first; child2 !== null; ) {
      var sibling2 = child2.next, transparent = (child2.f & EFFECT_TRANSPARENT) !== 0 || (child2.f & BRANCH_EFFECT) !== 0;
      resume_children(child2, transparent ? local : !1), child2 = sibling2;
    }
    if (effect2.transitions !== null)
      for (const transition of effect2.transitions)
        (transition.is_global || local) && transition.in();
  }
}
__name(resume_children, "resume_children");
const PASSIVE_EVENTS = ["touchstart", "touchmove"];
function is_passive_event(name) {
  return PASSIVE_EVENTS.includes(name);
}
__name(is_passive_event, "is_passive_event");
let listening_to_form_reset = !1;
function add_form_reset_listener() {
  listening_to_form_reset || (listening_to_form_reset = !0, document.addEventListener(
    "reset",
    (evt) => {
      Promise.resolve().then(() => {
        var _a;
        if (!evt.defaultPrevented)
          for (
            const e2 of
            /**@type {HTMLFormElement} */
            evt.target.elements
          )
            (_a = e2.__on_r) == null || _a.call(e2);
      });
    },
    // In the capture phase to guarantee we get noticed of it (no possiblity of stopPropagation)
    { capture: !0 }
  ));
}
__name(add_form_reset_listener, "add_form_reset_listener");
function without_reactive_context(fn) {
  var previous_reaction = active_reaction, previous_effect = active_effect;
  set_active_reaction(null), set_active_effect(null);
  try {
    return fn();
  } finally {
    set_active_reaction(previous_reaction), set_active_effect(previous_effect);
  }
}
__name(without_reactive_context, "without_reactive_context");
function listen_to_event_and_reset_event(element, event2, handler, on_reset = handler) {
  element.addEventListener(event2, () => without_reactive_context(handler));
  const prev = element.__on_r;
  prev ? element.__on_r = () => {
    prev(), on_reset(!0);
  } : element.__on_r = () => on_reset(!0), add_form_reset_listener();
}
__name(listen_to_event_and_reset_event, "listen_to_event_and_reset_event");
const all_registered_events = /* @__PURE__ */ new Set(), root_event_handles = /* @__PURE__ */ new Set();
function create_event(event_name, dom, handler, options = {}) {
  function target_handler(event2) {
    if (options.capture || handle_event_propagation.call(dom, event2), !event2.cancelBubble)
      return without_reactive_context(() => handler == null ? void 0 : handler.call(this, event2));
  }
  return __name(target_handler, "target_handler"), event_name.startsWith("pointer") || event_name.startsWith("touch") || event_name === "wheel" ? queue_micro_task(() => {
    dom.addEventListener(event_name, target_handler, options);
  }) : dom.addEventListener(event_name, target_handler, options), target_handler;
}
__name(create_event, "create_event");
function event(event_name, dom, handler, capture, passive) {
  var options = { capture, passive }, target_handler = create_event(event_name, dom, handler, options);
  (dom === document.body || dom === window || dom === document) && teardown(() => {
    dom.removeEventListener(event_name, target_handler, options);
  });
}
__name(event, "event");
function delegate(events) {
  for (var i2 = 0; i2 < events.length; i2++)
    all_registered_events.add(events[i2]);
  for (var fn of root_event_handles)
    fn(events);
}
__name(delegate, "delegate");
function handle_event_propagation(event2) {
  var _a;
  var handler_element = this, owner_document = (
    /** @type {Node} */
    handler_element.ownerDocument
  ), event_name = event2.type, path = ((_a = event2.composedPath) == null ? void 0 : _a.call(event2)) || [], current_target = (
    /** @type {null | Element} */
    path[0] || event2.target
  ), path_idx = 0, handled_at = event2.__root;
  if (handled_at) {
    var at_idx = path.indexOf(handled_at);
    if (at_idx !== -1 && (handler_element === document || handler_element === /** @type {any} */
    window)) {
      event2.__root = handler_element;
      return;
    }
    var handler_idx = path.indexOf(handler_element);
    if (handler_idx === -1)
      return;
    at_idx <= handler_idx && (path_idx = at_idx);
  }
  if (current_target = /** @type {Element} */
  path[path_idx] || event2.target, current_target !== handler_element) {
    define_property(event2, "currentTarget", {
      configurable: !0,
      get() {
        return current_target || owner_document;
      }
    });
    var previous_reaction = active_reaction, previous_effect = active_effect;
    set_active_reaction(null), set_active_effect(null);
    try {
      for (var throw_error, other_errors = []; current_target !== null; ) {
        var parent_element = current_target.assignedSlot || current_target.parentNode || /** @type {any} */
        current_target.host || null;
        try {
          var delegated = current_target["__" + event_name];
          if (delegated !== void 0 && !/** @type {any} */
          current_target.disabled)
            if (is_array(delegated)) {
              var [fn, ...data] = delegated;
              fn.apply(current_target, [event2, ...data]);
            } else
              delegated.call(current_target, event2);
        } catch (error) {
          throw_error ? other_errors.push(error) : throw_error = error;
        }
        if (event2.cancelBubble || parent_element === handler_element || parent_element === null)
          break;
        current_target = parent_element;
      }
      if (throw_error) {
        for (let error of other_errors)
          queueMicrotask(() => {
            throw error;
          });
        throw throw_error;
      }
    } finally {
      event2.__root = handler_element, delete event2.currentTarget, set_active_reaction(previous_reaction), set_active_effect(previous_effect);
    }
  }
}
__name(handle_event_propagation, "handle_event_propagation");
function create_fragment_from_html(html2) {
  var elem = document.createElement("template");
  return elem.innerHTML = html2, elem.content;
}
__name(create_fragment_from_html, "create_fragment_from_html");
function assign_nodes(start, end) {
  var effect2 = (
    /** @type {Effect} */
    active_effect
  );
  effect2.nodes_start === null && (effect2.nodes_start = start, effect2.nodes_end = end);
}
__name(assign_nodes, "assign_nodes");
// @__NO_SIDE_EFFECTS__
function template(content, flags) {
  var is_fragment = (flags & TEMPLATE_FRAGMENT) !== 0, use_import_node = (flags & TEMPLATE_USE_IMPORT_NODE) !== 0, node, has_start = !content.startsWith("<!>");
  return () => {
    node === void 0 && (node = create_fragment_from_html(has_start ? content : "<!>" + content), is_fragment || (node = /** @type {Node} */
    /* @__PURE__ */ get_first_child(node)));
    var clone = (
      /** @type {TemplateNode} */
      use_import_node || is_firefox ? document.importNode(node, !0) : node.cloneNode(!0)
    );
    if (is_fragment) {
      var start = (
        /** @type {TemplateNode} */
        /* @__PURE__ */ get_first_child(clone)
      ), end = (
        /** @type {TemplateNode} */
        clone.lastChild
      );
      assign_nodes(start, end);
    } else
      assign_nodes(clone, clone);
    return clone;
  };
}
__name(template, "template");
function text(value = "") {
  {
    var t2 = create_text(value + "");
    return assign_nodes(t2, t2), t2;
  }
}
__name(text, "text");
function comment() {
  var frag = document.createDocumentFragment(), start = document.createComment(""), anchor = create_text();
  return frag.append(start, anchor), assign_nodes(start, anchor), frag;
}
__name(comment, "comment");
function append(anchor, dom) {
  anchor !== null && anchor.before(
    /** @type {Node} */
    dom
  );
}
__name(append, "append");
function set_text(text2, value) {
  var str = value == null ? "" : typeof value == "object" ? value + "" : value;
  str !== (text2.__t ?? (text2.__t = text2.nodeValue)) && (text2.__t = str, text2.nodeValue = str + "");
}
__name(set_text, "set_text");
function mount(component, options) {
  return _mount(component, options);
}
__name(mount, "mount");
const document_listeners = /* @__PURE__ */ new Map();
function _mount(Component, { target, anchor, props = {}, events, context, intro = !0 }) {
  init_operations();
  var registered_events = /* @__PURE__ */ new Set(), event_handle = /* @__PURE__ */ __name((events2) => {
    for (var i2 = 0; i2 < events2.length; i2++) {
      var event_name = events2[i2];
      if (!registered_events.has(event_name)) {
        registered_events.add(event_name);
        var passive = is_passive_event(event_name);
        target.addEventListener(event_name, handle_event_propagation, { passive });
        var n2 = document_listeners.get(event_name);
        n2 === void 0 ? (document.addEventListener(event_name, handle_event_propagation, { passive }), document_listeners.set(event_name, 1)) : document_listeners.set(event_name, n2 + 1);
      }
    }
  }, "event_handle");
  event_handle(array_from(all_registered_events)), root_event_handles.add(event_handle);
  var component = void 0, unmount = component_root(() => {
    var anchor_node = anchor ?? target.appendChild(create_text());
    return branch(() => {
      if (context) {
        push({});
        var ctx = (
          /** @type {ComponentContext} */
          component_context
        );
        ctx.c = context;
      }
      events && (props.$$events = events), component = Component(anchor_node, props) || {}, context && pop();
    }), () => {
      var _a;
      for (var event_name of registered_events) {
        target.removeEventListener(event_name, handle_event_propagation);
        var n2 = (
          /** @type {number} */
          document_listeners.get(event_name)
        );
        --n2 === 0 ? (document.removeEventListener(event_name, handle_event_propagation), document_listeners.delete(event_name)) : document_listeners.set(event_name, n2);
      }
      root_event_handles.delete(event_handle), anchor_node !== anchor && ((_a = anchor_node.parentNode) == null || _a.removeChild(anchor_node));
    };
  });
  return mounted_components.set(component, unmount), component;
}
__name(_mount, "_mount");
let mounted_components = /* @__PURE__ */ new WeakMap();
function if_block(node, fn, elseif = !1) {
  var anchor = node, consequent_effect = null, alternate_effect = null, condition = UNINITIALIZED, flags = elseif ? EFFECT_TRANSPARENT : 0, has_branch = !1;
  const set_branch = /* @__PURE__ */ __name((fn2, flag = !0) => {
    has_branch = !0, update_branch(flag, fn2);
  }, "set_branch"), update_branch = /* @__PURE__ */ __name((new_condition, fn2) => {
    condition !== (condition = new_condition) && (condition ? (consequent_effect ? resume_effect(consequent_effect) : fn2 && (consequent_effect = branch(() => fn2(anchor))), alternate_effect && pause_effect(alternate_effect, () => {
      alternate_effect = null;
    })) : (alternate_effect ? resume_effect(alternate_effect) : fn2 && (alternate_effect = branch(() => fn2(anchor))), consequent_effect && pause_effect(consequent_effect, () => {
      consequent_effect = null;
    })));
  }, "update_branch");
  block(() => {
    has_branch = !1, fn(set_branch), has_branch || update_branch(null, null);
  }, flags);
}
__name(if_block, "if_block");
function index(_, i2) {
  return i2;
}
__name(index, "index");
function pause_effects(state2, items, controlled_anchor, items_map) {
  for (var transitions = [], length = items.length, i2 = 0; i2 < length; i2++)
    pause_children(items[i2].e, transitions, !0);
  var is_controlled = length > 0 && transitions.length === 0 && controlled_anchor !== null;
  if (is_controlled) {
    var parent_node = (
      /** @type {Element} */
      /** @type {Element} */
      controlled_anchor.parentNode
    );
    clear_text_content(parent_node), parent_node.append(
      /** @type {Element} */
      controlled_anchor
    ), items_map.clear(), link(state2, items[0].prev, items[length - 1].next);
  }
  run_out_transitions(transitions, () => {
    for (var i3 = 0; i3 < length; i3++) {
      var item = items[i3];
      is_controlled || (items_map.delete(item.k), link(state2, item.prev, item.next)), destroy_effect(item.e, !is_controlled);
    }
  });
}
__name(pause_effects, "pause_effects");
function each(node, flags, get_collection, get_key, render_fn, fallback_fn = null) {
  var anchor = node, state2 = { items: /* @__PURE__ */ new Map(), first: null }, is_controlled = (flags & EACH_IS_CONTROLLED) !== 0;
  if (is_controlled) {
    var parent_node = (
      /** @type {Element} */
      node
    );
    anchor = parent_node.appendChild(create_text());
  }
  var fallback = null, was_empty = !1, each_array = /* @__PURE__ */ derived_safe_equal(() => {
    var collection = get_collection();
    return is_array(collection) ? collection : collection == null ? [] : array_from(collection);
  });
  block(() => {
    var array = get$1(each_array), length = array.length;
    was_empty && length === 0 || (was_empty = length === 0, reconcile(array, state2, anchor, render_fn, flags, get_key, get_collection), fallback_fn !== null && (length === 0 ? fallback ? resume_effect(fallback) : fallback = branch(() => fallback_fn(anchor)) : fallback !== null && pause_effect(fallback, () => {
      fallback = null;
    })), get$1(each_array));
  });
}
__name(each, "each");
function reconcile(array, state2, anchor, render_fn, flags, get_key, get_collection) {
  var _a, _b, _c, _d;
  var is_animated = (flags & EACH_IS_ANIMATED) !== 0, should_update = (flags & (EACH_ITEM_REACTIVE | EACH_INDEX_REACTIVE)) !== 0, length = array.length, items = state2.items, first = state2.first, current = first, seen, prev = null, to_animate, matched = [], stashed = [], value, key, item, i2;
  if (is_animated)
    for (i2 = 0; i2 < length; i2 += 1)
      value = array[i2], key = get_key(value, i2), item = items.get(key), item !== void 0 && ((_a = item.a) == null || _a.measure(), (to_animate ?? (to_animate = /* @__PURE__ */ new Set())).add(item));
  for (i2 = 0; i2 < length; i2 += 1) {
    if (value = array[i2], key = get_key(value, i2), item = items.get(key), item === void 0) {
      var child_anchor = current ? (
        /** @type {TemplateNode} */
        current.e.nodes_start
      ) : anchor;
      prev = create_item(
        child_anchor,
        state2,
        prev,
        prev === null ? state2.first : prev.next,
        value,
        key,
        i2,
        render_fn,
        flags,
        get_collection
      ), items.set(key, prev), matched = [], stashed = [], current = prev.next;
      continue;
    }
    if (should_update && update_item(item, value, i2, flags), item.e.f & INERT && (resume_effect(item.e), is_animated && ((_b = item.a) == null || _b.unfix(), (to_animate ?? (to_animate = /* @__PURE__ */ new Set())).delete(item))), item !== current) {
      if (seen !== void 0 && seen.has(item)) {
        if (matched.length < stashed.length) {
          var start = stashed[0], j;
          prev = start.prev;
          var a = matched[0], b = matched[matched.length - 1];
          for (j = 0; j < matched.length; j += 1)
            move(matched[j], start, anchor);
          for (j = 0; j < stashed.length; j += 1)
            seen.delete(stashed[j]);
          link(state2, a.prev, b.next), link(state2, prev, a), link(state2, b, start), current = start, prev = b, i2 -= 1, matched = [], stashed = [];
        } else
          seen.delete(item), move(item, current, anchor), link(state2, item.prev, item.next), link(state2, item, prev === null ? state2.first : prev.next), link(state2, prev, item), prev = item;
        continue;
      }
      for (matched = [], stashed = []; current !== null && current.k !== key; )
        current.e.f & INERT || (seen ?? (seen = /* @__PURE__ */ new Set())).add(current), stashed.push(current), current = current.next;
      if (current === null)
        continue;
      item = current;
    }
    matched.push(item), prev = item, current = item.next;
  }
  if (current !== null || seen !== void 0) {
    for (var to_destroy = seen === void 0 ? [] : array_from(seen); current !== null; )
      current.e.f & INERT || to_destroy.push(current), current = current.next;
    var destroy_length = to_destroy.length;
    if (destroy_length > 0) {
      var controlled_anchor = flags & EACH_IS_CONTROLLED && length === 0 ? anchor : null;
      if (is_animated) {
        for (i2 = 0; i2 < destroy_length; i2 += 1)
          (_c = to_destroy[i2].a) == null || _c.measure();
        for (i2 = 0; i2 < destroy_length; i2 += 1)
          (_d = to_destroy[i2].a) == null || _d.fix();
      }
      pause_effects(state2, to_destroy, controlled_anchor, items);
    }
  }
  is_animated && queue_micro_task(() => {
    var _a2;
    if (to_animate !== void 0)
      for (item of to_animate)
        (_a2 = item.a) == null || _a2.apply();
  }), active_effect.first = state2.first && state2.first.e, active_effect.last = prev && prev.e;
}
__name(reconcile, "reconcile");
function update_item(item, value, index2, type) {
  type & EACH_ITEM_REACTIVE && internal_set(item.v, value), type & EACH_INDEX_REACTIVE ? internal_set(
    /** @type {Value<number>} */
    item.i,
    index2
  ) : item.i = index2;
}
__name(update_item, "update_item");
function create_item(anchor, state2, prev, next, value, key, index2, render_fn, flags, get_collection) {
  var reactive = (flags & EACH_ITEM_REACTIVE) !== 0, mutable = (flags & EACH_ITEM_IMMUTABLE) === 0, v = reactive ? mutable ? /* @__PURE__ */ mutable_source(value) : source(value) : value, i2 = flags & EACH_INDEX_REACTIVE ? source(index2) : index2, item = {
    i: i2,
    v,
    k: key,
    a: null,
    // @ts-expect-error
    e: null,
    prev,
    next
  };
  try {
    return item.e = branch(() => render_fn(anchor, v, i2, get_collection), hydrating), item.e.prev = prev && prev.e, item.e.next = next && next.e, prev === null ? state2.first = item : (prev.next = item, prev.e.next = item.e), next !== null && (next.prev = item, next.e.prev = item.e), item;
  } finally {
  }
}
__name(create_item, "create_item");
function move(item, next, anchor) {
  for (var end = item.next ? (
    /** @type {TemplateNode} */
    item.next.e.nodes_start
  ) : anchor, dest = next ? (
    /** @type {TemplateNode} */
    next.e.nodes_start
  ) : anchor, node = (
    /** @type {TemplateNode} */
    item.e.nodes_start
  ); node !== end; ) {
    var next_node = (
      /** @type {TemplateNode} */
      /* @__PURE__ */ get_next_sibling(node)
    );
    dest.before(node), node = next_node;
  }
}
__name(move, "move");
function link(state2, prev, next) {
  prev === null ? state2.first = next : (prev.next = next, prev.e.next = next && next.e), next !== null && (next.prev = prev, next.e.prev = prev && prev.e);
}
__name(link, "link");
function html(node, get_value, svg, mathml, skip_warning) {
  var anchor = node, value = "", effect2;
  block(() => {
    value !== (value = get_value() ?? "") && (effect2 !== void 0 && (destroy_effect(effect2), effect2 = void 0), value !== "" && (effect2 = branch(() => {
      var html2 = value + "", node2 = create_fragment_from_html(html2);
      assign_nodes(
        /** @type {TemplateNode} */
        /* @__PURE__ */ get_first_child(node2),
        /** @type {TemplateNode} */
        node2.lastChild
      ), anchor.before(node2);
    })));
  });
}
__name(html, "html");
function snippet(node, get_snippet, ...args) {
  var anchor = node, snippet2 = noop, snippet_effect;
  block(() => {
    snippet2 !== (snippet2 = get_snippet()) && (snippet_effect && (destroy_effect(snippet_effect), snippet_effect = null), snippet_effect = branch(() => (
      /** @type {SnippetFn} */
      snippet2(anchor, ...args)
    )));
  }, EFFECT_TRANSPARENT);
}
__name(snippet, "snippet");
function set_value(element, value) {
  var attributes = element.__attributes ?? (element.__attributes = {});
  attributes.value === (attributes.value = // treat null and undefined the same for the initial value
  value ?? void 0) || // @ts-expect-error
  // `progress` elements always need their value set when it's `0`
  element.value === value && (value !== 0 || element.nodeName !== "PROGRESS") || (element.value = value ?? "");
}
__name(set_value, "set_value");
function set_checked(element, checked) {
  var attributes = element.__attributes ?? (element.__attributes = {});
  attributes.checked !== (attributes.checked = // treat null and undefined the same for the initial value
  checked ?? void 0) && (element.checked = checked);
}
__name(set_checked, "set_checked");
function set_selected(element, selected) {
  selected ? element.hasAttribute("selected") || element.setAttribute("selected", "") : element.removeAttribute("selected");
}
__name(set_selected, "set_selected");
function set_attribute(element, attribute, value, skip_warning) {
  var attributes = element.__attributes ?? (element.__attributes = {});
  attributes[attribute] !== (attributes[attribute] = value) && (attribute === "style" && "__styles" in element && (element.__styles = {}), attribute === "loading" && (element[LOADING_ATTR_SYMBOL] = value), value == null ? element.removeAttribute(attribute) : typeof value != "string" && get_setters(element).includes(attribute) ? element[attribute] = value : element.setAttribute(attribute, value));
}
__name(set_attribute, "set_attribute");
var setters_cache = /* @__PURE__ */ new Map();
function get_setters(element) {
  var setters = setters_cache.get(element.nodeName);
  if (setters) return setters;
  setters_cache.set(element.nodeName, setters = []);
  for (var descriptors, proto = element, element_proto = Element.prototype; element_proto !== proto; ) {
    descriptors = get_descriptors(proto);
    for (var key in descriptors)
      descriptors[key].set && setters.push(key);
    proto = get_prototype_of(proto);
  }
  return setters;
}
__name(get_setters, "get_setters");
function set_class(dom, value, hash) {
  var prev_class_name = dom.__className, next_class_name = to_class(value);
  (prev_class_name !== next_class_name || hydrating) && (value == null ? dom.removeAttribute("class") : dom.className = next_class_name, dom.__className = next_class_name);
}
__name(set_class, "set_class");
function to_class(value, hash) {
  return (value ?? "") + "";
}
__name(to_class, "to_class");
function bind_checked(input, get2, set2 = get2) {
  listen_to_event_and_reset_event(input, "change", (is_reset) => {
    var value = is_reset ? input.defaultChecked : input.checked;
    set2(value);
  }), // If we are hydrating and the value has since changed,
  // then use the update value from the input instead.
  // If defaultChecked is set, then checked == defaultChecked
  untrack(get2) == null && set2(input.checked), render_effect(() => {
    var value = get2();
    input.checked = !!value;
  });
}
__name(bind_checked, "bind_checked");
function is_bound_this(bound_value, element_or_component) {
  return bound_value === element_or_component || (bound_value == null ? void 0 : bound_value[STATE_SYMBOL]) === element_or_component;
}
__name(is_bound_this, "is_bound_this");
function bind_this(element_or_component = {}, update, get_value, get_parts) {
  return effect(() => {
    var old_parts, parts;
    return render_effect(() => {
      old_parts = parts, parts = [], untrack(() => {
        element_or_component !== get_value(...parts) && (update(element_or_component, ...parts), old_parts && is_bound_this(get_value(...old_parts), element_or_component) && update(null, ...old_parts));
      });
    }), () => {
      queue_micro_task(() => {
        parts && is_bound_this(get_value(...parts), element_or_component) && update(null, ...parts);
      });
    };
  }), element_or_component;
}
__name(bind_this, "bind_this");
const rest_props_handler = {
  get(target, key) {
    if (!target.exclude.includes(key))
      return target.props[key];
  },
  set(target, key) {
    return !1;
  },
  getOwnPropertyDescriptor(target, key) {
    if (!target.exclude.includes(key) && key in target.props)
      return {
        enumerable: !0,
        configurable: !0,
        value: target.props[key]
      };
  },
  has(target, key) {
    return target.exclude.includes(key) ? !1 : key in target.props;
  },
  ownKeys(target) {
    return Reflect.ownKeys(target.props).filter((key) => !target.exclude.includes(key));
  }
};
// @__NO_SIDE_EFFECTS__
function rest_props(props, exclude, name) {
  return new Proxy(
    { props, exclude },
    rest_props_handler
  );
}
__name(rest_props, "rest_props");
const spread_props_handler = {
  get(target, key) {
    let i2 = target.props.length;
    for (; i2--; ) {
      let p = target.props[i2];
      if (is_function(p) && (p = p()), typeof p == "object" && p !== null && key in p) return p[key];
    }
  },
  set(target, key, value) {
    let i2 = target.props.length;
    for (; i2--; ) {
      let p = target.props[i2];
      is_function(p) && (p = p());
      const desc = get_descriptor(p, key);
      if (desc && desc.set)
        return desc.set(value), !0;
    }
    return !1;
  },
  getOwnPropertyDescriptor(target, key) {
    let i2 = target.props.length;
    for (; i2--; ) {
      let p = target.props[i2];
      if (is_function(p) && (p = p()), typeof p == "object" && p !== null && key in p) {
        const descriptor = get_descriptor(p, key);
        return descriptor && !descriptor.configurable && (descriptor.configurable = !0), descriptor;
      }
    }
  },
  has(target, key) {
    if (key === STATE_SYMBOL || key === LEGACY_PROPS) return !1;
    for (let p of target.props)
      if (is_function(p) && (p = p()), p != null && key in p) return !0;
    return !1;
  },
  ownKeys(target) {
    const keys = [];
    for (let p of target.props) {
      is_function(p) && (p = p());
      for (const key in p)
        keys.includes(key) || keys.push(key);
    }
    return keys;
  }
};
function spread_props(...props) {
  return new Proxy({ props }, spread_props_handler);
}
__name(spread_props, "spread_props");
function prop(props, key, flags, fallback) {
  var prop_value;
  prop_value = /** @type {V} */
  props[key];
  var fallback_value = (
    /** @type {V} */
    fallback
  ), fallback_dirty = !0, fallback_used = !1, get_fallback = /* @__PURE__ */ __name(() => (fallback_used = !0, fallback_dirty && (fallback_dirty = !1, fallback_value = /** @type {V} */
  fallback), fallback_value), "get_fallback"), getter;
  getter = /* @__PURE__ */ __name(() => {
    var value = (
      /** @type {V} */
      props[key]
    );
    return value === void 0 ? get_fallback() : (fallback_dirty = !0, fallback_used = !1, value);
  }, "getter");
  var from_child = !1, inner_current_value = /* @__PURE__ */ mutable_source(prop_value), current_value = /* @__PURE__ */ derived(() => {
    var parent_value = getter(), child_value = get$1(inner_current_value);
    return from_child ? (from_child = !1, child_value) : inner_current_value.v = parent_value;
  });
  return function(value, mutation) {
    if (arguments.length > 0) {
      const new_value = mutation ? get$1(current_value) : value;
      return current_value.equals(new_value) || (from_child = !0, set(inner_current_value, new_value), fallback_used && fallback_value !== void 0 && (fallback_value = new_value), untrack(() => get$1(current_value))), value;
    }
    return get$1(current_value);
  };
}
__name(prop, "prop");
function onMount(fn) {
  component_context === null && lifecycle_outside_component(), legacy_mode_flag && component_context.l !== null ? init_update_callbacks(component_context).m.push(fn) : user_effect(() => {
    const cleanup = untrack(fn);
    if (typeof cleanup == "function") return (
      /** @type {() => void} */
      cleanup
    );
  });
}
__name(onMount, "onMount");
function onDestroy(fn) {
  component_context === null && lifecycle_outside_component(), onMount(() => () => untrack(fn));
}
__name(onDestroy, "onDestroy");
function init_update_callbacks(context) {
  var l = (
    /** @type {ComponentContextLegacy} */
    context.l
  );
  return l.u ?? (l.u = { a: [], b: [], m: [] });
}
__name(init_update_callbacks, "init_update_callbacks");
function subscribe_to_store(store, run, invalidate) {
  if (store == null)
    return run(void 0), noop;
  const unsub = untrack(
    () => store.subscribe(
      run,
      // @ts-expect-error
      invalidate
    )
  );
  return unsub.unsubscribe ? () => unsub.unsubscribe() : unsub;
}
__name(subscribe_to_store, "subscribe_to_store");
const subscriber_queue = [];
function writable(value, start = noop) {
  let stop = null;
  const subscribers = /* @__PURE__ */ new Set();
  function set2(new_value) {
    if (safe_not_equal(value, new_value) && (value = new_value, stop)) {
      const run_queue = !subscriber_queue.length;
      for (const subscriber of subscribers)
        subscriber[1](), subscriber_queue.push(subscriber, value);
      if (run_queue) {
        for (let i2 = 0; i2 < subscriber_queue.length; i2 += 2)
          subscriber_queue[i2][0](subscriber_queue[i2 + 1]);
        subscriber_queue.length = 0;
      }
    }
  }
  __name(set2, "set");
  function update(fn) {
    set2(fn(
      /** @type {T} */
      value
    ));
  }
  __name(update, "update");
  function subscribe(run, invalidate = noop) {
    const subscriber = [run, invalidate];
    return subscribers.add(subscriber), subscribers.size === 1 && (stop = start(set2, update) || noop), run(
      /** @type {T} */
      value
    ), () => {
      subscribers.delete(subscriber), subscribers.size === 0 && stop && (stop(), stop = null);
    };
  }
  return __name(subscribe, "subscribe"), { set: set2, update, subscribe };
}
__name(writable, "writable");
function get(store) {
  let value;
  return subscribe_to_store(store, (_) => value = _)(), value;
}
__name(get, "get");
function increment(source2) {
  set(source2, source2.v + 1);
}
__name(increment, "increment");
function createSubscriber(start) {
  let subscribers = 0, version = source(0), stop;
  return () => {
    effect_tracking() && (get$1(version), render_effect(() => (subscribers === 0 && (stop = untrack(() => start(() => increment(version)))), subscribers += 1, () => {
      tick().then(() => {
        subscribers -= 1, subscribers === 0 && (stop == null || stop(), stop = void 0);
      });
    })));
  };
}
__name(createSubscriber, "createSubscriber");
function fromStore(store) {
  let value;
  const subscribe = createSubscriber((update) => {
    let ran = !1;
    const unsubscribe = store.subscribe((v) => {
      value = v, ran && update();
    });
    return ran = !0, unsubscribe;
  });
  function current() {
    return effect_tracking() ? (subscribe(), value) : get(store);
  }
  return __name(current, "current"), "set" in store ? {
    get current() {
      return current();
    },
    set current(v) {
      store.set(v);
    }
  } : {
    get current() {
      return current();
    }
  };
}
__name(fromStore, "fromStore");
const _SheetStore = class _SheetStore {
  static createDefaultData() {
    return {
      advancedState: !1,
      introPlayed: !1,
      headerOffsetY: 0,
      currentTheme: "",
      activeTabs: {},
      trackedHooks: {},
      tokenImageLock: !0,
      selectedTokenImage: ""
      // (#12)
    };
  }
  static get(key) {
    const store = get(_SheetStore.store);
    return key in store || (store[key] = _SheetStore.createDefaultData()), fromStore(_SheetStore.store).current[key];
  }
  static set(key, value) {
    _SheetStore.store.update((store) => (store[key] || (store[key] = _SheetStore.createDefaultData()), store[key] = { ...store[key], ...value }, store));
  }
};
__name(_SheetStore, "SheetStore"), __publicField(_SheetStore, "store", writable({}));
let SheetStore = _SheetStore;
const _PilotStore = class _PilotStore {
  static createDefaultData() {
    return {
      bondQNAMode: !1,
      selectedMech: 0
    };
  }
  static get(key) {
    const store = get(_PilotStore.store);
    return key in store || (store[key] = _PilotStore.createDefaultData()), fromStore(_PilotStore.store).current[key];
  }
  static set(key, value) {
    _PilotStore.store.update((store) => (store[key] || (store[key] = _PilotStore.createDefaultData()), store[key] = { ...store[key], ...value }, store));
  }
};
__name(_PilotStore, "PilotStore"), __publicField(_PilotStore, "store", writable({}));
let PilotStore = _PilotStore;
function getActiveTab(uuid, tab) {
  return SheetStore.get(uuid).activeTabs[tab] ?? "";
}
__name(getActiveTab, "getActiveTab");
function setActiveTab(uuid, tab, value) {
  const tabs = SheetStore.get(uuid).activeTabs;
  tabs[tab] = value, SheetStore.set(uuid, { activeTabs: tabs });
}
__name(setActiveTab, "setActiveTab");
function getAdvancedState(uuid) {
  return SheetStore.get(uuid).advancedState;
}
__name(getAdvancedState, "getAdvancedState");
function setAdvancedState(uuid, enabled) {
  SheetStore.set(uuid, { advancedState: enabled });
}
__name(setAdvancedState, "setAdvancedState");
function getSelectedTokenImage(uuid) {
  return SheetStore.get(uuid).selectedTokenImage ?? "";
}
__name(getSelectedTokenImage, "getSelectedTokenImage");
function setSelectedTokenImage(uuid, value) {
  SheetStore.set(uuid, { selectedTokenImage: value });
}
__name(setSelectedTokenImage, "setSelectedTokenImage");
function getTokenImageLock(uuid) {
  return SheetStore.get(uuid).tokenImageLock ?? !0;
}
__name(getTokenImageLock, "getTokenImageLock");
function setTokenImageLock(uuid, value) {
  SheetStore.set(uuid, { tokenImageLock: value });
}
__name(setTokenImageLock, "setTokenImageLock");
function getLocalized(key) {
  return HandlebarsHelpers.localize(key, {});
}
__name(getLocalized, "getLocalized");
function randomExtension() {
  const extensions = [".exe", ".bat", ".cmd", ".sh", ".bash", ".zsh", ".ksh", ".csh"], randomIndex = Math.floor(Math.random() * extensions.length);
  return extensions[randomIndex];
}
__name(randomExtension, "randomExtension");
function logData(path, options) {
  const data = resolveHelperDotpath(options, path);
  Logger.log("Data received", data);
}
__name(logData, "logData");
function logConsole(data, _options) {
  console.log(data);
}
__name(logConsole, "logConsole");
function isLoading(item) {
  var _a, _b;
  return ((_a = item.system.all_tags) == null ? void 0 : _a.some((t2) => t2.is_loading)) || ((_b = item.system.tags) == null ? void 0 : _b.some((t2) => t2.is_loading));
}
__name(isLoading, "isLoading");
function isRecharge(item) {
  var _a, _b;
  return ((_a = item.system.all_tags) == null ? void 0 : _a.some((t2) => t2.is_recharge)) || ((_b = item.system.tags) == null ? void 0 : _b.some((t2) => t2.is_recharge));
}
__name(isRecharge, "isRecharge");
function formatString(template2, ...values) {
  return template2.replace(/{(\d+)}/g, (match, number) => typeof values[number] < "u" ? values[number] : match);
}
__name(formatString, "formatString");
function getFoundryVersion(split = !1) {
  return split ? game.release.version.split(".") : game.release.version;
}
__name(getFoundryVersion, "getFoundryVersion");
function getLancerVersion(split = !1) {
  return split ? game.system.version.split(".") : game.system.version;
}
__name(getLancerVersion, "getLancerVersion");
function getModuleVersion(split = !1) {
  return split ? game.modules.get(LancerAlternative.Name).version.split(".") : game.modules.get(LancerAlternative.Name).version;
}
__name(getModuleVersion, "getModuleVersion");
const dataMap = {};
function forwardData(data, _options) {
  dataMap[data.actor.uuid] = data;
}
__name(forwardData, "forwardData");
function handleRelativeDataInput(event2, previous) {
  var _a;
  event2.preventDefault();
  const inputValue = (_a = event2.target) == null ? void 0 : _a.value;
  let newValue = previous;
  inputValue && (inputValue.startsWith("+") ? newValue = previous + Number(inputValue.slice(1)) : inputValue.startsWith("-") ? newValue = previous - Number(inputValue.slice(1)) : newValue = Number(inputValue)), event2.currentTarget.value = newValue.toString(), event2.currentTarget.blur();
}
__name(handleRelativeDataInput, "handleRelativeDataInput");
function isValidVideoContainer(path) {
  var _a;
  const validTypes = ["webm", "mp4", "m4v"], extension = (_a = path.split(".").pop()) == null ? void 0 : _a.toLowerCase();
  return validTypes.includes(extension ?? "");
}
__name(isValidVideoContainer, "isValidVideoContainer");
function getVideoMimeType(path) {
  var _a;
  const validTypes = ["webm", "mp4", "m4v"], extension = (_a = path.split(".").pop()) == null ? void 0 : _a.toLowerCase();
  return extension && validTypes.includes(extension) ? `video/${extension === "m4v" ? "mp4" : extension}` : null;
}
__name(getVideoMimeType, "getVideoMimeType");
function isValidImageContainer(path) {
  var _a;
  const validTypes = ["avif", "jpg", "jpeg", "png", "svg", "webp", "gif"], extension = (_a = path.split(".").pop()) == null ? void 0 : _a.toLowerCase();
  return validTypes.includes(extension ?? "");
}
__name(isValidImageContainer, "isValidImageContainer");
function browseTokenImage(event2, actor) {
  event2.stopPropagation(), new FilePicker({
    current: actor.prototypeToken.texture.src,
    type: "imagevideo",
    callback: /* @__PURE__ */ __name((path) => {
      SheetStore.get(actor.uuid).selectedTokenImage = path, actor.update({
        "prototypeToken.texture.src": path
      });
    }, "callback")
  }).render(!0);
}
__name(browseTokenImage, "browseTokenImage");
function browseActorImage(event2, actor) {
  event2.stopPropagation(), new FilePicker({
    current: actor.img,
    type: "image",
    callback: /* @__PURE__ */ __name((path) => {
      actor.update({
        img: path
      });
    }, "callback")
  }).render(!0);
}
__name(browseActorImage, "browseActorImage");
function browseActorImageSync(event2, actor) {
  event2.stopPropagation(), new FilePicker({
    current: actor.img,
    type: "image",
    callback: /* @__PURE__ */ __name((path) => {
      SheetStore.get(actor.uuid).selectedTokenImage = path, actor.update({
        img: path,
        "prototypeToken.texture.src": path
      });
    }, "callback")
  }).render(!0);
}
__name(browseActorImageSync, "browseActorImageSync");
function getCurrentOvercharge(actor) {
  const overchargeSequence = actor.system.overcharge_sequence.split(","), overchargeStage = actor.system.overcharge;
  return overchargeSequence[overchargeStage];
}
__name(getCurrentOvercharge, "getCurrentOvercharge");
function handleOverchargeIncrease(event2, actor) {
  event2.stopPropagation();
  const overchargeStage = actor.system.overcharge, overchargeSequence = actor.system.overcharge_sequence.split(",");
  actor.update({
    "system.overcharge": Math.min(overchargeStage + 1, overchargeSequence.length - 1)
  });
}
__name(handleOverchargeIncrease, "handleOverchargeIncrease");
function handleOverchargeDecrease(event2, actor) {
  event2.stopPropagation();
  const overchargeStage = actor.system.overcharge;
  actor.update({
    "system.overcharge": Math.max(overchargeStage - 1, 0)
  });
}
__name(handleOverchargeDecrease, "handleOverchargeDecrease");
async function handleToggleImageSync(event2, actor, setState) {
  const lockState = getTokenImageLock(actor.uuid);
  event2.stopPropagation(), lockState ? (setTokenImageLock(actor.uuid, !lockState), setState(actor.uuid, !lockState)) : await foundry.applications.api.DialogV2.confirm({
    window: { title: getLocalized("LA.confirm") },
    content: getLocalized("LA.advanced.link.subLabel")
  }) && (setTokenImageLock(actor.uuid, !lockState), setState(actor.uuid, !lockState), isValidImageContainer(actor.prototypeToken.texture.src) && actor.update({
    img: actor.prototypeToken.texture.src
  }));
}
__name(handleToggleImageSync, "handleToggleImageSync");
function handleEditToken(event2, actor) {
  event2.stopPropagation(), getTokenImageLock(actor.uuid) ? browseActorImageSync(event2, actor) : browseTokenImage(event2, actor);
}
__name(handleEditToken, "handleEditToken");
var ThemeKey = /* @__PURE__ */ ((ThemeKey2) => (ThemeKey2.GMS = "gms", ThemeKey2.GMSDark = "gmsDark", ThemeKey2.MSMC = "msmc", ThemeKey2.GALSIM = "gal", ThemeKey2.HORUS = "horus", ThemeKey2.HA = "ha", ThemeKey2.SSC = "ssc", ThemeKey2.IPSN = "ipsn", ThemeKey2))(ThemeKey || {}), ThemeValue = /* @__PURE__ */ ((ThemeValue2) => (ThemeValue2.GMS = "la-gms", ThemeValue2.GMSDark = "la-gmsdark", ThemeValue2.MSMC = "la-msmc", ThemeValue2.GALSIM = "la-galsim", ThemeValue2.HORUS = "la-horus", ThemeValue2.HA = "la-ha", ThemeValue2.SSC = "la-ssc", ThemeValue2.IPSN = "la-ipsn", ThemeValue2))(ThemeValue || {});
function slugify(name, dash = "_") {
  return name.trim().replace(/[:\\\/-\s]+/g, dash).toLowerCase();
}
__name(slugify, "slugify");
const THEME_MAP = {
  [ThemeKey.GMS]: ThemeValue.GMS,
  [ThemeKey.GMSDark]: ThemeValue.GMSDark,
  [ThemeKey.MSMC]: ThemeValue.MSMC,
  [ThemeKey.GALSIM]: ThemeValue.GALSIM,
  [ThemeKey.HORUS]: ThemeValue.HORUS,
  [ThemeKey.HA]: ThemeValue.HA,
  [ThemeKey.SSC]: ThemeValue.SSC,
  [ThemeKey.IPSN]: ThemeValue.IPSN
}, LIGHT_MAP = {
  [ThemeKey.GMS]: "light",
  [ThemeKey.GMSDark]: "dark",
  [ThemeKey.MSMC]: "dark",
  [ThemeKey.GALSIM]: "dark",
  [ThemeKey.HORUS]: "dark",
  [ThemeKey.HA]: "dark",
  [ThemeKey.SSC]: "light",
  [ThemeKey.IPSN]: "light"
}, THEME_LOCALIZE_MAP = {
  [ThemeKey.GMS]: "LA.advanced.theme.gms.label",
  [ThemeKey.GMSDark]: "LA.advanced.theme.gmsDark.label",
  [ThemeKey.MSMC]: "LA.advanced.theme.msmc.label",
  [ThemeKey.GALSIM]: "LA.advanced.theme.galsim.label",
  [ThemeKey.HORUS]: "LA.advanced.theme.horus.label",
  [ThemeKey.HA]: "LA.advanced.theme.ha.label",
  [ThemeKey.SSC]: "LA.advanced.theme.ssc.label",
  [ThemeKey.IPSN]: "LA.advanced.theme.ipsn.label"
}, THEME_LOCALIZE_HISTORY_MAP = {
  [ThemeKey.GMS]: "LA.pilot.history.gms",
  [ThemeKey.GMSDark]: "LA.pilot.history.gms",
  [ThemeKey.MSMC]: "LA.pilot.history.msmc",
  [ThemeKey.GALSIM]: "LA.pilot.history.gms",
  [ThemeKey.HORUS]: "LA.pilot.history.horus",
  [ThemeKey.HA]: "LA.pilot.history.ha",
  [ThemeKey.SSC]: "LA.pilot.history.ssc",
  [ThemeKey.IPSN]: "LA.pilot.history.ipsn"
};
function convertToCSSTheme(key) {
  return THEME_MAP[key];
}
__name(convertToCSSTheme, "convertToCSSTheme");
function getCSSDocumentTheme(uuid) {
  const { currentTheme } = SheetStore.get(uuid);
  return currentTheme ? THEME_MAP[currentTheme] : getCSSSystemTheme();
}
__name(getCSSDocumentTheme, "getCSSDocumentTheme");
function getCSSSystemTheme() {
  const currentTheme = game.settings.get("lancer", "uiTheme");
  return THEME_MAP[currentTheme];
}
__name(getCSSSystemTheme, "getCSSSystemTheme");
function getBrightness(theme) {
  const selectedTheme = theme || game.settings.get("lancer", "uiTheme");
  return LIGHT_MAP[selectedTheme];
}
__name(getBrightness, "getBrightness");
function getThemeName(theme) {
  const selectedTheme = theme || game.settings.get("lancer", "uiTheme");
  return getLocalized(THEME_LOCALIZE_MAP[selectedTheme]);
}
__name(getThemeName, "getThemeName");
function getThemeHistoryLabel(theme) {
  const selectedTheme = theme || game.settings.get("lancer", "uiTheme");
  return getLocalized(THEME_LOCALIZE_HISTORY_MAP[selectedTheme]);
}
__name(getThemeHistoryLabel, "getThemeHistoryLabel");
function getManufacturerColor(key, type) {
  let manufacturer = slugify(key, "-");
  return ["gms", "ips-n", "ipsn", "ssc", "horus", "ha", "msmc", "galsim"].includes(manufacturer) || (manufacturer = "primary"), manufacturer === "ips-n" && (manufacturer = "ipsn"), manufacturer === "gmsdark" && (manufacturer = "gms"), `la-${type}-${manufacturer}`;
}
__name(getManufacturerColor, "getManufacturerColor");
function applyThemeTo(html2, theme) {
  const selectedtheme = theme || game.settings.get("lancer", "uiTheme"), themeClasses = Object.values(THEME_MAP);
  html2.removeClass(themeClasses.join(" ")).addClass(THEME_MAP[selectedtheme]);
}
__name(applyThemeTo, "applyThemeTo");
const _MechSheetLocalSettings = class _MechSheetLocalSettings {
  static emptyContent() {
    return {
      sidebarRatio: 1
    };
  }
};
__name(_MechSheetLocalSettings, "MechSheetLocalSettings");
let MechSheetLocalSettings = _MechSheetLocalSettings;
var SystemButton = /* @__PURE__ */ ((SystemButton2) => (SystemButton2.Stabilize = "Stabilize", SystemButton2.Overcharge = "Overcharge", SystemButton2.BasicAttack = "BasicAttack", SystemButton2.Damage = "Damage", SystemButton2.TechAttack = "TechAttack", SystemButton2.SkillTriggerOther = "SkillTriggerOther", SystemButton2))(SystemButton || {});
const _MechSheetSettings = class _MechSheetSettings {
  static emptyContent() {
    return {
      headerImgOffsetY: 0,
      themeOverride: "",
      sidebarExes: [
        SystemButton.Stabilize,
        SystemButton.Overcharge,
        SystemButton.BasicAttack,
        SystemButton.Damage,
        SystemButton.TechAttack
      ],
      syncActorTokenImages: !0
    };
  }
};
__name(_MechSheetSettings, "MechSheetSettings");
let MechSheetSettings = _MechSheetSettings;
const _SocketManager = class _SocketManager {
  constructor() {
    __publicField(this, "socketName", `module.${LancerAlternative.Name}`);
    __publicField(this, "socket");
    __publicField(this, "registeredFunctions", /* @__PURE__ */ new Map());
    __publicField(this, "awaitingResponse", /* @__PURE__ */ new Map());
    if (!game.socket)
      throw new Error("Lancer Alternative Sheets: SocketManager initialized before Foundry socket is available.");
    this.socket = game.socket, this.socket.on(
      this.socketName,
      (data, caller) => {
        var _a;
        if (data.type === "GM" && game.user.isGM) {
          Logger.log(`GM proxy for ${data.func} requested by ${(_a = game.users) == null ? void 0 : _a.get(caller).name}`, data);
          const func = this.registeredFunctions.get(data.func);
          if (!func) {
            Logger.error(`Function ${data.func} is not registered.`);
            return;
          }
          const response = func(...data.args);
          data.responseID && this.handleResponse(response, data);
        } else if (data.type === "response") {
          const callback = this.awaitingResponse.get(data.responseID);
          if (!callback)
            return;
          Logger.log(`Response for ${data.func} received`, data.args), callback(data.args), this.awaitingResponse.delete(data.func);
        }
      }
    );
  }
  static getInstance() {
    return _SocketManager.instance || (_SocketManager.instance = new _SocketManager()), _SocketManager.instance;
  }
  handleResponse(response, data) {
    response instanceof Promise ? (Logger.log(`GM proxy for ${data.func} is a promise, waiting for resolution...`), response.then((resolvedResponse) => {
      data.responseID && this.socket.emit(
        this.socketName,
        {
          type: "response",
          func: data.func,
          args: resolvedResponse,
          responseID: data.responseID
        }
      ), Logger.log(`GM proxy for ${data.func} resolved`, resolvedResponse);
    }).catch((error) => {
      Logger.error(`Error in GM proxy function ${data.func}:`, error);
    })) : this.socket.emit(
      this.socketName,
      {
        type: "response",
        func: data.func,
        args: response,
        responseID: data.responseID
      }
    );
  }
  register(func) {
    if (this.registeredFunctions.has(func.name)) {
      Logger.error(`Function ${func.name} is already registered.`);
      return;
    }
    const wrappedCallback = /* @__PURE__ */ __name((...args) => func(...args), "wrappedCallback");
    this.registeredFunctions.set(func.name, wrappedCallback), Logger.log(`Registered socket function ${func.name}`);
  }
  unregister(func) {
    if (!this.registeredFunctions.get(func.name)) {
      Logger.error(`Function ${func.name} is not registered.`);
      return;
    }
    this.registeredFunctions.delete(func.name);
  }
  runAsGM(func, callback, ...args) {
    if (game.user.isGM) {
      const response = func(...args);
      callback && (response instanceof Promise ? response.then((resolvedResponse) => {
        callback(resolvedResponse);
      }).catch((error) => {
        Logger.error(`Error in ${func.name}:`, error);
      }) : callback(response));
      return;
    }
    if (!game.users.activeGM) {
      Logger.error("An active GM must be online to run GM-proxied functions");
      return;
    }
    Logger.log(`Requested GM proxy for ${func.name}`, args);
    let responseID;
    callback && (responseID = randomID(16), this.awaitingResponse.set(responseID, callback)), this.socket.emit(
      this.socketName,
      {
        type: "GM",
        func: func.name,
        args,
        responseID
      }
    );
  }
};
__name(_SocketManager, "SocketManager"), __publicField(_SocketManager, "instance");
let SocketManager = _SocketManager;
function registerMechSheetSettings() {
  game.settings.register(LancerAlternative.Name, "mech-settings-tip", {
    name: "LA.SETTINGS.mech.enableTooltip.label",
    hint: "LA.SETTINGS.mech.enableTooltip.subLabel",
    scope: "client",
    config: !0,
    type: Boolean,
    default: !0
  }), game.settings.register(LancerAlternative.Name, "mech-settings-log-header", {
    name: "LA.SETTINGS.mech.enableHeaderLog.label",
    hint: "LA.SETTINGS.mech.enableHeaderLog.subLabel",
    scope: "client",
    config: !0,
    type: Boolean,
    default: !0
  }), game.settings.register(LancerAlternative.Name, "mech-settings-log-action-sidebar", {
    name: "LA.SETTINGS.mech.enableSidebarActionLog.label",
    hint: "LA.SETTINGS.mech.enableSidebarActionLog.subLabel",
    scope: "client",
    config: !0,
    type: Boolean,
    default: !0
  }), game.settings.register(LancerAlternative.Name, "mech-settings-log-action-main", {
    name: "LA.SETTINGS.mech.enableMainActionLog.label",
    hint: "LA.SETTINGS.mech.enableMainActionLog.subLabel",
    scope: "client",
    config: !0,
    type: Boolean,
    default: !1
  }), game.settings.register(LancerAlternative.Name, "mech-settings-log-action-main-max-height", {
    name: "LA.SETTINGS.mech.sizeMainActionLog.label",
    hint: "LA.SETTINGS.mech.sizeMainActionLog.subLabel",
    scope: "client",
    config: !0,
    type: Number,
    range: {
      min: 10,
      max: 30,
      step: 1
    },
    default: 12
  }), game.settings.register(LancerAlternative.Name, "mech-settings-log-action-save-collapse", {
    name: "LA.SETTINGS.mech.saveCollapse.label",
    hint: "LA.SETTINGS.mech.saveCollapse.subLabel",
    scope: "client",
    config: !0,
    type: Boolean,
    default: !1
  }), game.settings.register(LancerAlternative.Name, "mech-settings-log-action-start-collapsed", {
    name: "LA.SETTINGS.mech.startCollapsed.label",
    hint: "LA.SETTINGS.mech.startCollapsed.subLabel",
    scope: "client",
    config: !0,
    type: Boolean,
    default: !0
  }), game.settings.register(LancerAlternative.Name, "_mech-settings-local", {
    scope: "client",
    config: !1,
    type: String,
    default: ""
  }), game.settings.register(LancerAlternative.Name, "_mech-settings-local-version", {
    scope: "client",
    config: !1,
    type: String,
    // JSON object
    default: ""
  }), game.settings.register(LancerAlternative.Name, "_mech-settings", {
    scope: "world",
    config: !1,
    type: Array,
    // MessagePack encoded object
    default: []
  }), game.settings.register(LancerAlternative.Name, "_mech-settings-version", {
    scope: "world",
    config: !1,
    type: String,
    default: ""
  }), SocketManager.getInstance().register(setMechSheetData);
}
__name(registerMechSheetSettings, "registerMechSheetSettings");
function getMechSheetTooltipEnabled() {
  return game.settings.get(LancerAlternative.Name, "mech-settings-tip");
}
__name(getMechSheetTooltipEnabled, "getMechSheetTooltipEnabled");
function getMechSheetLogHeaderEnabled() {
  return game.settings.get(LancerAlternative.Name, "mech-settings-log-header");
}
__name(getMechSheetLogHeaderEnabled, "getMechSheetLogHeaderEnabled");
function getMechSheetLogActionMainEnabled() {
  return game.settings.get(LancerAlternative.Name, "mech-settings-log-action-main");
}
__name(getMechSheetLogActionMainEnabled, "getMechSheetLogActionMainEnabled");
function getMechSheetLogActionMainMaxHeight() {
  return game.settings.get(LancerAlternative.Name, "mech-settings-log-action-main-max-height");
}
__name(getMechSheetLogActionMainMaxHeight, "getMechSheetLogActionMainMaxHeight");
function getMechSheetLogActionDontSaveCollapse() {
  return !game.settings.get(LancerAlternative.Name, "mech-settings-log-action-save-collapse");
}
__name(getMechSheetLogActionDontSaveCollapse, "getMechSheetLogActionDontSaveCollapse");
function getMechSheetLogActionStartCollapsed() {
  return game.settings.get(LancerAlternative.Name, "mech-settings-log-action-start-collapsed");
}
__name(getMechSheetLogActionStartCollapsed, "getMechSheetLogActionStartCollapsed");
function resetMechSheetLocalData(uuid) {
  if (uuid) {
    const data = getMechSheetLocalData();
    data[uuid] && delete data[uuid], setMechSheetLocalData(data);
  } else {
    const data = new MechSheetLocalSettings();
    setMechSheetLocalData(data);
  }
}
__name(resetMechSheetLocalData, "resetMechSheetLocalData");
function getMechSheetLocalData() {
  try {
    const settings = game.settings.get(LancerAlternative.Name, "_mech-settings-local");
    return JSON.parse(settings);
  } catch {
    return new MechSheetLocalSettings();
  }
}
__name(getMechSheetLocalData, "getMechSheetLocalData");
function setMechSheetLocalData(data) {
  const encoded = JSON.stringify(data);
  return Promise.all([
    game.settings.set(LancerAlternative.Name, "_mech-settings-local", encoded),
    game.settings.set(LancerAlternative.Name, "_mech-settings-local-version", getModuleVersion())
  ]);
}
__name(setMechSheetLocalData, "setMechSheetLocalData");
function getSidebarRatio$1(uuid) {
  var _a;
  return ((_a = getMechSheetLocalData()[uuid]) == null ? void 0 : _a.sidebarRatio) ?? 1;
}
__name(getSidebarRatio$1, "getSidebarRatio$1");
function setSidebarRatio$1(uuid, value) {
  const data = getMechSheetLocalData();
  data[uuid] || (data[uuid] = MechSheetLocalSettings.emptyContent()), data[uuid].sidebarRatio = value, setMechSheetLocalData(data);
}
__name(setSidebarRatio$1, "setSidebarRatio$1");
function resetMechSheetData(uuid) {
  var _a, _b;
  if (uuid) {
    const data = getMechSheetData();
    data[uuid] && delete data[uuid], setMechSheetData(encodeMechSheetData(data));
  } else
    game.settings.set(LancerAlternative.Name, "_mech-settings", (_a = game.settings.settings.get(`${LancerAlternative.Name}._mech-settings`)) == null ? void 0 : _a.default), game.settings.set(LancerAlternative.Name, "_mech-settings-version", (_b = game.settings.settings.get(`${LancerAlternative.Name}._mech-settings-version`)) == null ? void 0 : _b.default);
}
__name(resetMechSheetData, "resetMechSheetData");
function getMechSheetData() {
  const settings = game.settings.get(LancerAlternative.Name, "_mech-settings");
  if (!settings.length)
    return new MechSheetSettings();
  try {
    let encoded = new Uint8Array(Object.values(settings));
    return encoded.length === 1 && (Logger.log("MechSheetSettings: Decoding failed, trying legacy decode."), encoded = new Uint8Array(Object.values(settings[0]))), msgPackDecoder.decode(encoded);
  } catch {
    return Logger.error("MechSheetSettings: Decoding failed, returning empty settings."), new MechSheetSettings();
  }
}
__name(getMechSheetData, "getMechSheetData");
function migratedDefaults$3(uuid, data) {
  const defaultSettings = MechSheetSettings.emptyContent();
  return defaultSettings.syncActorTokenImages = determineActorTokenSync$3(uuid, data), defaultSettings;
}
__name(migratedDefaults$3, "migratedDefaults$3");
function encodeMechSheetData(data) {
  const encoded = msgPackEncoder.encode(data);
  return Array.from(encoded);
}
__name(encodeMechSheetData, "encodeMechSheetData");
function setMechSheetData(encoded) {
  return Promise.all([
    game.settings.set(LancerAlternative.Name, "_mech-settings", encoded),
    game.settings.set(LancerAlternative.Name, "_mech-settings-version", getModuleVersion())
  ]);
}
__name(setMechSheetData, "setMechSheetData");
function getImageOffsetY$1(uuid) {
  var _a;
  return ((_a = getMechSheetData()[uuid]) == null ? void 0 : _a.headerImgOffsetY) ?? 0;
}
__name(getImageOffsetY$1, "getImageOffsetY$1");
function setImageOffsetY(uuid, value) {
  const data = getMechSheetData();
  data[uuid] || (data[uuid] = migratedDefaults$3(uuid, data)), data[uuid].headerImgOffsetY = value, SocketManager.getInstance().runAsGM(
    setMechSheetData,
    () => {
      Logger.log(`Image offset Y set to ${value} for ${uuid}`);
    },
    encodeMechSheetData(data)
  );
}
__name(setImageOffsetY, "setImageOffsetY");
function getThemeOverride$3(uuid) {
  var _a;
  return ((_a = getMechSheetData()[uuid]) == null ? void 0 : _a.themeOverride) ?? "";
}
__name(getThemeOverride$3, "getThemeOverride$3");
function setThemeOverride$3(uuid, value) {
  const data = getMechSheetData();
  data[uuid] || (data[uuid] = migratedDefaults$3(uuid, data)), data[uuid].themeOverride = value, SocketManager.getInstance().runAsGM(
    setMechSheetData,
    () => {
      Logger.log(`Theme override set to ${value} for ${uuid}`);
    },
    encodeMechSheetData(data)
  ), Hooks.call("laOverrideTheme", uuid, value);
}
__name(setThemeOverride$3, "setThemeOverride$3");
function getSidebarExecutables$2(uuid) {
  var _a;
  const data = getMechSheetData();
  return ((_a = data[uuid]) == null ? void 0 : _a.sidebarExes) ?? migratedDefaults$3(uuid, data).sidebarExes;
}
__name(getSidebarExecutables$2, "getSidebarExecutables$2");
function setSidebarExecutables$2(uuid, macros) {
  const data = getMechSheetData();
  data[uuid] || (data[uuid] = migratedDefaults$3(uuid, data)), data[uuid].sidebarExes = macros, SocketManager.getInstance().runAsGM(
    setMechSheetData,
    () => {
      Logger.log(`Sidebar executables set to ${macros.join(", ")} for ${uuid}`);
    },
    encodeMechSheetData(data)
  );
}
__name(setSidebarExecutables$2, "setSidebarExecutables$2");
function getActorTokenSync$3(uuid) {
  const data = getMechSheetData();
  return determineActorTokenSync$3(uuid, data);
}
__name(getActorTokenSync$3, "getActorTokenSync$3");
function determineActorTokenSync$3(uuid, data) {
  var _a, _b, _c, _d;
  if (((_a = data[uuid]) == null ? void 0 : _a.syncActorTokenImages) === void 0 || ((_b = data[uuid]) == null ? void 0 : _b.syncActorTokenImages) === null) {
    Logger.log("Determining default syncActorTokenImages setting for a new or unsaved mech/old module version");
    const actor = fromUuidSync(uuid);
    return (_d = (_c = actor.prototypeToken) == null ? void 0 : _c.texture) != null && _d.src && actor.img ? actor.img === actor.prototypeToken.texture.src : !0;
  } else
    return data[uuid].syncActorTokenImages;
}
__name(determineActorTokenSync$3, "determineActorTokenSync$3");
function setActorTokenSync$3(uuid, value) {
  const data = getMechSheetData();
  data[uuid] || (data[uuid] = migratedDefaults$3(uuid, data)), data[uuid].syncActorTokenImages = value, SocketManager.getInstance().runAsGM(
    setMechSheetData,
    () => {
      Logger.log(`Sync actor-token images set to ${value} for ${uuid}`);
    },
    encodeMechSheetData(data)
  );
}
__name(setActorTokenSync$3, "setActorTokenSync$3");
function trackHook(uuid, key, value) {
  const hooks = SheetStore.get(uuid).trackedHooks;
  hooks[key] = value, SheetStore.set(uuid, { trackedHooks: hooks });
}
__name(trackHook, "trackHook");
function unregisterTrackedHooks(uuid) {
  const hooks = SheetStore.get(uuid).trackedHooks;
  for (const [key, value] of Object.entries(hooks))
    Hooks.off(value, Number(key));
  SheetStore.set(uuid, { trackedHooks: {} });
}
__name(unregisterTrackedHooks, "unregisterTrackedHooks");
function t() {
  return t = Object.assign ? Object.assign.bind() : function(t2) {
    for (var s2 = 1; s2 < arguments.length; s2++) {
      var e2 = arguments[s2];
      for (var n2 in e2) Object.prototype.hasOwnProperty.call(e2, n2) && (t2[n2] = e2[n2]);
    }
    return t2;
  }, t.apply(this, arguments);
}
__name(t, "t");
var s = { strings: ["These are the default values...", "You know what you should do?", "Use your own!", "Have a great day!"], stringsElement: null, typeSpeed: 0, startDelay: 0, backSpeed: 0, smartBackspace: !0, shuffle: !1, backDelay: 700, fadeOut: !1, fadeOutClass: "typed-fade-out", fadeOutDelay: 500, loop: !1, loopCount: 1 / 0, showCursor: !0, cursorChar: "|", autoInsertCss: !0, attr: null, bindInputFocusEvents: !1, contentType: "html", onBegin: /* @__PURE__ */ __name(function(t2) {
}, "onBegin"), onComplete: /* @__PURE__ */ __name(function(t2) {
}, "onComplete"), preStringTyped: /* @__PURE__ */ __name(function(t2, s2) {
}, "preStringTyped"), onStringTyped: /* @__PURE__ */ __name(function(t2, s2) {
}, "onStringTyped"), onLastStringBackspaced: /* @__PURE__ */ __name(function(t2) {
}, "onLastStringBackspaced"), onTypingPaused: /* @__PURE__ */ __name(function(t2, s2) {
}, "onTypingPaused"), onTypingResumed: /* @__PURE__ */ __name(function(t2, s2) {
}, "onTypingResumed"), onReset: /* @__PURE__ */ __name(function(t2) {
}, "onReset"), onStop: /* @__PURE__ */ __name(function(t2, s2) {
}, "onStop"), onStart: /* @__PURE__ */ __name(function(t2, s2) {
}, "onStart"), onDestroy: /* @__PURE__ */ __name(function(t2) {
}, "onDestroy") }, e = new (/* @__PURE__ */ function() {
  function e2() {
  }
  __name(e2, "e");
  var n2 = e2.prototype;
  return n2.load = function(e3, n3, i2) {
    if (e3.el = typeof i2 == "string" ? document.querySelector(i2) : i2, e3.options = t({}, s, n3), e3.isInput = e3.el.tagName.toLowerCase() === "input", e3.attr = e3.options.attr, e3.bindInputFocusEvents = e3.options.bindInputFocusEvents, e3.showCursor = !e3.isInput && e3.options.showCursor, e3.cursorChar = e3.options.cursorChar, e3.cursorBlinking = !0, e3.elContent = e3.attr ? e3.el.getAttribute(e3.attr) : e3.el.textContent, e3.contentType = e3.options.contentType, e3.typeSpeed = e3.options.typeSpeed, e3.startDelay = e3.options.startDelay, e3.backSpeed = e3.options.backSpeed, e3.smartBackspace = e3.options.smartBackspace, e3.backDelay = e3.options.backDelay, e3.fadeOut = e3.options.fadeOut, e3.fadeOutClass = e3.options.fadeOutClass, e3.fadeOutDelay = e3.options.fadeOutDelay, e3.isPaused = !1, e3.strings = e3.options.strings.map(function(t2) {
      return t2.trim();
    }), e3.stringsElement = typeof e3.options.stringsElement == "string" ? document.querySelector(e3.options.stringsElement) : e3.options.stringsElement, e3.stringsElement) {
      e3.strings = [], e3.stringsElement.style.cssText = "clip: rect(0 0 0 0);clip-path:inset(50%);height:1px;overflow:hidden;position:absolute;white-space:nowrap;width:1px;";
      var r = Array.prototype.slice.apply(e3.stringsElement.children), o = r.length;
      if (o) for (var a = 0; a < o; a += 1) e3.strings.push(r[a].innerHTML.trim());
    }
    for (var u in e3.strPos = 0, e3.currentElContent = this.getCurrentElContent(e3), e3.currentElContent && e3.currentElContent.length > 0 && (e3.strPos = e3.currentElContent.length - 1, e3.strings.unshift(e3.currentElContent)), e3.sequence = [], e3.strings) e3.sequence[u] = u;
    e3.arrayPos = 0, e3.stopNum = 0, e3.loop = e3.options.loop, e3.loopCount = e3.options.loopCount, e3.curLoop = 0, e3.shuffle = e3.options.shuffle, e3.pause = { status: !1, typewrite: !0, curString: "", curStrPos: 0 }, e3.typingComplete = !1, e3.autoInsertCss = e3.options.autoInsertCss, e3.autoInsertCss && (this.appendCursorAnimationCss(e3), this.appendFadeOutAnimationCss(e3));
  }, n2.getCurrentElContent = function(t2) {
    return t2.attr ? t2.el.getAttribute(t2.attr) : t2.isInput ? t2.el.value : t2.contentType === "html" ? t2.el.innerHTML : t2.el.textContent;
  }, n2.appendCursorAnimationCss = function(t2) {
    var s2 = "data-typed-js-cursor-css";
    if (t2.showCursor && !document.querySelector("[" + s2 + "]")) {
      var e3 = document.createElement("style");
      e3.setAttribute(s2, "true"), e3.innerHTML = `
        .typed-cursor{
          opacity: 1;
        }
        .typed-cursor.typed-cursor--blink{
          animation: typedjsBlink 0.7s infinite;
          -webkit-animation: typedjsBlink 0.7s infinite;
                  animation: typedjsBlink 0.7s infinite;
        }
        @keyframes typedjsBlink{
          50% { opacity: 0.0; }
        }
        @-webkit-keyframes typedjsBlink{
          0% { opacity: 1; }
          50% { opacity: 0.0; }
          100% { opacity: 1; }
        }
      `, document.body.appendChild(e3);
    }
  }, n2.appendFadeOutAnimationCss = function(t2) {
    var s2 = "data-typed-fadeout-js-css";
    if (t2.fadeOut && !document.querySelector("[" + s2 + "]")) {
      var e3 = document.createElement("style");
      e3.setAttribute(s2, "true"), e3.innerHTML = `
        .typed-fade-out{
          opacity: 0;
          transition: opacity .25s;
        }
        .typed-cursor.typed-cursor--blink.typed-fade-out{
          -webkit-animation: 0;
          animation: 0;
        }
      `, document.body.appendChild(e3);
    }
  }, e2;
}())(), n = new (/* @__PURE__ */ function() {
  function t2() {
  }
  __name(t2, "t");
  var s2 = t2.prototype;
  return s2.typeHtmlChars = function(t3, s3, e2) {
    if (e2.contentType !== "html") return s3;
    var n2 = t3.substring(s3).charAt(0);
    if (n2 === "<" || n2 === "&") {
      var i2;
      for (i2 = n2 === "<" ? ">" : ";"; t3.substring(s3 + 1).charAt(0) !== i2 && !(1 + ++s3 > t3.length); ) ;
      s3++;
    }
    return s3;
  }, s2.backSpaceHtmlChars = function(t3, s3, e2) {
    if (e2.contentType !== "html") return s3;
    var n2 = t3.substring(s3).charAt(0);
    if (n2 === ">" || n2 === ";") {
      var i2;
      for (i2 = n2 === ">" ? "<" : "&"; t3.substring(s3 - 1).charAt(0) !== i2 && !(--s3 < 0); ) ;
      s3--;
    }
    return s3;
  }, t2;
}())(), i = /* @__PURE__ */ function() {
  function t2(t3, s3) {
    e.load(this, s3, t3), this.begin();
  }
  __name(t2, "t");
  var s2 = t2.prototype;
  return s2.toggle = function() {
    this.pause.status ? this.start() : this.stop();
  }, s2.stop = function() {
    this.typingComplete || this.pause.status || (this.toggleBlinking(!0), this.pause.status = !0, this.options.onStop(this.arrayPos, this));
  }, s2.start = function() {
    this.typingComplete || this.pause.status && (this.pause.status = !1, this.pause.typewrite ? this.typewrite(this.pause.curString, this.pause.curStrPos) : this.backspace(this.pause.curString, this.pause.curStrPos), this.options.onStart(this.arrayPos, this));
  }, s2.destroy = function() {
    this.reset(!1), this.options.onDestroy(this);
  }, s2.reset = function(t3) {
    t3 === void 0 && (t3 = !0), clearInterval(this.timeout), this.replaceText(""), this.cursor && this.cursor.parentNode && (this.cursor.parentNode.removeChild(this.cursor), this.cursor = null), this.strPos = 0, this.arrayPos = 0, this.curLoop = 0, t3 && (this.insertCursor(), this.options.onReset(this), this.begin());
  }, s2.begin = function() {
    var t3 = this;
    this.options.onBegin(this), this.typingComplete = !1, this.shuffleStringsIfNeeded(this), this.insertCursor(), this.bindInputFocusEvents && this.bindFocusEvents(), this.timeout = setTimeout(function() {
      t3.strPos === 0 ? t3.typewrite(t3.strings[t3.sequence[t3.arrayPos]], t3.strPos) : t3.backspace(t3.strings[t3.sequence[t3.arrayPos]], t3.strPos);
    }, this.startDelay);
  }, s2.typewrite = function(t3, s3) {
    var e2 = this;
    this.fadeOut && this.el.classList.contains(this.fadeOutClass) && (this.el.classList.remove(this.fadeOutClass), this.cursor && this.cursor.classList.remove(this.fadeOutClass));
    var i2 = this.humanizer(this.typeSpeed), r = 1;
    this.pause.status !== !0 ? this.timeout = setTimeout(function() {
      s3 = n.typeHtmlChars(t3, s3, e2);
      var i3 = 0, o = t3.substring(s3);
      if (o.charAt(0) === "^" && /^\^\d+/.test(o)) {
        var a = 1;
        a += (o = /\d+/.exec(o)[0]).length, i3 = parseInt(o), e2.temporaryPause = !0, e2.options.onTypingPaused(e2.arrayPos, e2), t3 = t3.substring(0, s3) + t3.substring(s3 + a), e2.toggleBlinking(!0);
      }
      if (o.charAt(0) === "`") {
        for (; t3.substring(s3 + r).charAt(0) !== "`" && (r++, !(s3 + r > t3.length)); ) ;
        var u = t3.substring(0, s3), p = t3.substring(u.length + 1, s3 + r), c = t3.substring(s3 + r + 1);
        t3 = u + p + c, r--;
      }
      e2.timeout = setTimeout(function() {
        e2.toggleBlinking(!1), s3 >= t3.length ? e2.doneTyping(t3, s3) : e2.keepTyping(t3, s3, r), e2.temporaryPause && (e2.temporaryPause = !1, e2.options.onTypingResumed(e2.arrayPos, e2));
      }, i3);
    }, i2) : this.setPauseStatus(t3, s3, !0);
  }, s2.keepTyping = function(t3, s3, e2) {
    s3 === 0 && (this.toggleBlinking(!1), this.options.preStringTyped(this.arrayPos, this));
    var n2 = t3.substring(0, s3 += e2);
    this.replaceText(n2), this.typewrite(t3, s3);
  }, s2.doneTyping = function(t3, s3) {
    var e2 = this;
    this.options.onStringTyped(this.arrayPos, this), this.toggleBlinking(!0), this.arrayPos === this.strings.length - 1 && (this.complete(), this.loop === !1 || this.curLoop === this.loopCount) || (this.timeout = setTimeout(function() {
      e2.backspace(t3, s3);
    }, this.backDelay));
  }, s2.backspace = function(t3, s3) {
    var e2 = this;
    if (this.pause.status !== !0) {
      if (this.fadeOut) return this.initFadeOut();
      this.toggleBlinking(!1);
      var i2 = this.humanizer(this.backSpeed);
      this.timeout = setTimeout(function() {
        s3 = n.backSpaceHtmlChars(t3, s3, e2);
        var i3 = t3.substring(0, s3);
        if (e2.replaceText(i3), e2.smartBackspace) {
          var r = e2.strings[e2.arrayPos + 1];
          e2.stopNum = r && i3 === r.substring(0, s3) ? s3 : 0;
        }
        s3 > e2.stopNum ? (s3--, e2.backspace(t3, s3)) : s3 <= e2.stopNum && (e2.arrayPos++, e2.arrayPos === e2.strings.length ? (e2.arrayPos = 0, e2.options.onLastStringBackspaced(), e2.shuffleStringsIfNeeded(), e2.begin()) : e2.typewrite(e2.strings[e2.sequence[e2.arrayPos]], s3));
      }, i2);
    } else this.setPauseStatus(t3, s3, !1);
  }, s2.complete = function() {
    this.options.onComplete(this), this.loop ? this.curLoop++ : this.typingComplete = !0;
  }, s2.setPauseStatus = function(t3, s3, e2) {
    this.pause.typewrite = e2, this.pause.curString = t3, this.pause.curStrPos = s3;
  }, s2.toggleBlinking = function(t3) {
    this.cursor && (this.pause.status || this.cursorBlinking !== t3 && (this.cursorBlinking = t3, t3 ? this.cursor.classList.add("typed-cursor--blink") : this.cursor.classList.remove("typed-cursor--blink")));
  }, s2.humanizer = function(t3) {
    return Math.round(Math.random() * t3 / 2) + t3;
  }, s2.shuffleStringsIfNeeded = function() {
    this.shuffle && (this.sequence = this.sequence.sort(function() {
      return Math.random() - 0.5;
    }));
  }, s2.initFadeOut = function() {
    var t3 = this;
    return this.el.className += " " + this.fadeOutClass, this.cursor && (this.cursor.className += " " + this.fadeOutClass), setTimeout(function() {
      t3.arrayPos++, t3.replaceText(""), t3.strings.length > t3.arrayPos ? t3.typewrite(t3.strings[t3.sequence[t3.arrayPos]], 0) : (t3.typewrite(t3.strings[0], 0), t3.arrayPos = 0);
    }, this.fadeOutDelay);
  }, s2.replaceText = function(t3) {
    this.attr ? this.el.setAttribute(this.attr, t3) : this.isInput ? this.el.value = t3 : this.contentType === "html" ? this.el.innerHTML = t3 : this.el.textContent = t3;
  }, s2.bindFocusEvents = function() {
    var t3 = this;
    this.isInput && (this.el.addEventListener("focus", function(s3) {
      t3.stop();
    }), this.el.addEventListener("blur", function(s3) {
      t3.el.value && t3.el.value.length !== 0 || t3.start();
    }));
  }, s2.insertCursor = function() {
    this.showCursor && (this.cursor || (this.cursor = document.createElement("span"), this.cursor.className = "typed-cursor", this.cursor.setAttribute("aria-hidden", !0), this.cursor.innerHTML = this.cursorChar, this.el.parentNode && this.el.parentNode.insertBefore(this.cursor, this.el.nextSibling)));
  }, t2;
}();
const isArray = /* @__PURE__ */ __name((thing) => Array.isArray(thing), "isArray"), asArray = /* @__PURE__ */ __name((value) => isArray(value) ? value : [value], "asArray");
let Queue = /* @__PURE__ */ __name(function(initialItems) {
  let add = /* @__PURE__ */ __name(function(steps) {
    return asArray(steps).forEach((step) => {
      var _a;
      return _q.set(Symbol((_a = step.char) == null ? void 0 : _a.innerText), buildQueueItem({ ...step }));
    }), this;
  }, "add"), getTypeable = /* @__PURE__ */ __name(() => rawValues().filter((value) => value.typeable), "getTypeable"), set2 = /* @__PURE__ */ __name(function(index2, item) {
    let keys = [..._q.keys()];
    _q.set(keys[index2], buildQueueItem(item));
  }, "set"), buildQueueItem = /* @__PURE__ */ __name((queueItem) => (queueItem.shouldPauseCursor = function() {
    return !!(this.typeable || this.cursorable || this.deletable);
  }, queueItem), "buildQueueItem"), reset = /* @__PURE__ */ __name(function() {
    _q.forEach((item) => delete item.done);
  }, "reset"), wipe = /* @__PURE__ */ __name(function() {
    _q = /* @__PURE__ */ new Map(), add(initialItems);
  }, "wipe"), getQueue = /* @__PURE__ */ __name(() => _q, "getQueue"), rawValues = /* @__PURE__ */ __name(() => Array.from(_q.values()), "rawValues"), destroy = /* @__PURE__ */ __name((key) => _q.delete(key), "destroy"), getPendingQueueItems = /* @__PURE__ */ __name(() => {
    const pending = [];
    for (let [, value] of getQueue())
      value.done || pending.push(value);
    return pending;
  }, "getPendingQueueItems"), getItems = /* @__PURE__ */ __name((all = !1) => all ? rawValues() : rawValues().filter((i2) => !i2.done), "getItems"), done = /* @__PURE__ */ __name((key, shouldDestroy = !1) => shouldDestroy ? _q.delete(key) : _q.get(key).done = !0, "done"), _q = /* @__PURE__ */ new Map();
  return add(initialItems), {
    add,
    set: set2,
    wipe,
    done,
    reset,
    destroy,
    getItems,
    getQueue,
    getTypeable,
    getPendingQueueItems
  };
}, "Queue");
const DATA_ATTRIBUTE = "data-typeit-id", CURSOR_CLASS = "ti-cursor", END = "END", DEFAULT_STATUSES = {
  started: !1,
  completed: !1,
  frozen: !1,
  destroyed: !1
}, DEFAULT_OPTIONS = {
  breakLines: !0,
  cursor: {
    autoPause: !0,
    autoPauseDelay: 500,
    animation: {
      frames: [0, 0, 1].map((n2) => ({ opacity: n2 })),
      options: {
        iterations: 1 / 0,
        easing: "steps(2, start)",
        fill: "forwards"
      }
    }
  },
  cursorChar: "|",
  cursorSpeed: 1e3,
  deleteSpeed: null,
  html: !0,
  lifeLike: !0,
  loop: !1,
  loopDelay: 750,
  nextStringDelay: 750,
  speed: 100,
  startDelay: 250,
  startDelete: !1,
  strings: [],
  waitUntilVisible: !1,
  beforeString: /* @__PURE__ */ __name(() => {
  }, "beforeString"),
  afterString: /* @__PURE__ */ __name(() => {
  }, "afterString"),
  beforeStep: /* @__PURE__ */ __name(() => {
  }, "beforeStep"),
  afterStep: /* @__PURE__ */ __name(() => {
  }, "afterStep"),
  afterComplete: /* @__PURE__ */ __name(() => {
  }, "afterComplete")
}, PLACEHOLDER_CSS = `[${DATA_ATTRIBUTE}]:before {content: '.'; display: inline-block; width: 0; visibility: hidden;}`, createElement = /* @__PURE__ */ __name((el) => document.createElement(el), "createElement"), createTextNode = /* @__PURE__ */ __name((content) => document.createTextNode(content), "createTextNode"), appendStyleBlock = /* @__PURE__ */ __name((styles, id2 = "") => {
  let styleBlock = createElement("style");
  styleBlock.id = id2, styleBlock.appendChild(createTextNode(styles)), document.head.appendChild(styleBlock);
}, "appendStyleBlock"), calculateDelay = /* @__PURE__ */ __name((delayArg) => (isArray(delayArg) || (delayArg = [delayArg / 2, delayArg / 2]), delayArg), "calculateDelay"), randomInRange = /* @__PURE__ */ __name((value, range2) => Math.abs(
  Math.random() * (value + range2 - (value - range2)) + (value - range2)
), "randomInRange");
let range = /* @__PURE__ */ __name((val) => val / 2, "range");
function calculatePace(options) {
  let { speed, deleteSpeed, lifeLike } = options;
  return deleteSpeed = deleteSpeed !== null ? deleteSpeed : speed / 3, lifeLike ? [
    randomInRange(speed, range(speed)),
    randomInRange(deleteSpeed, range(deleteSpeed))
  ] : [speed, deleteSpeed];
}
__name(calculatePace, "calculatePace");
const toArray = /* @__PURE__ */ __name((val) => Array.from(val), "toArray");
let expandTextNodes = /* @__PURE__ */ __name((element) => ([...element.childNodes].forEach((child2) => {
  if (child2.nodeValue) {
    [...child2.nodeValue].forEach((c) => {
      child2.parentNode.insertBefore(createTextNode(c), child2);
    }), child2.remove();
    return;
  }
  expandTextNodes(child2);
}), element), "expandTextNodes");
const getParsedBody = /* @__PURE__ */ __name((content) => {
  let doc = document.implementation.createHTMLDocument();
  return doc.body.innerHTML = content, expandTextNodes(doc.body);
}, "getParsedBody");
function walkElementNodes(element, shouldReverse = !1, shouldIncludeCursor = !1) {
  let cursor = element.querySelector(`.${CURSOR_CLASS}`), walker = document.createTreeWalker(element, NodeFilter.SHOW_ALL, {
    acceptNode: /* @__PURE__ */ __name((node) => {
      var _a, _b;
      if (cursor && shouldIncludeCursor) {
        if ((_a = node.classList) != null && _a.contains(CURSOR_CLASS))
          return NodeFilter.FILTER_ACCEPT;
        if (cursor.contains(node))
          return NodeFilter.FILTER_REJECT;
      }
      return (_b = node.classList) != null && _b.contains(CURSOR_CLASS) ? NodeFilter.FILTER_REJECT : NodeFilter.FILTER_ACCEPT;
    }, "acceptNode")
  }), nextNode, nodes = [];
  for (; nextNode = walker.nextNode(); )
    nextNode.originalParent || (nextNode.originalParent = nextNode.parentNode), nodes.push(nextNode);
  return shouldReverse ? nodes.reverse() : nodes;
}
__name(walkElementNodes, "walkElementNodes");
function chunkStringAsHtml(string) {
  return walkElementNodes(getParsedBody(string));
}
__name(chunkStringAsHtml, "chunkStringAsHtml");
function maybeChunkStringAsHtml(str, asHtml = !0) {
  return asHtml ? chunkStringAsHtml(str) : toArray(str).map(createTextNode);
}
__name(maybeChunkStringAsHtml, "maybeChunkStringAsHtml");
const cleanUpSkipped = /* @__PURE__ */ __name(({
  index: index2,
  newIndex,
  queueItems,
  cleanUp
}) => {
  for (let i2 = index2 + 1; i2 < newIndex + 1; i2++)
    cleanUp(queueItems[i2][0]);
}, "cleanUpSkipped"), isNumber = /* @__PURE__ */ __name((value) => Number.isInteger(value), "isNumber"), countStepsToSelector = /* @__PURE__ */ __name(({
  queueItems,
  selector,
  cursorPosition,
  to
}) => {
  if (isNumber(selector))
    return selector * -1;
  let isMovingToEnd = new RegExp(END, "i").test(to), selectorIndex = selector ? [...queueItems].reverse().findIndex(({ char }) => {
    let parentElement = char.parentElement, parentMatches = parentElement.matches(selector);
    return isMovingToEnd && parentMatches ? !0 : parentMatches && parentElement.firstChild.isSameNode(char);
  }) : -1;
  selectorIndex < 0 && (selectorIndex = isMovingToEnd ? 0 : queueItems.length - 1);
  let offset = isMovingToEnd ? 0 : 1;
  return selectorIndex - cursorPosition + offset;
}, "countStepsToSelector"), destroyTimeouts = /* @__PURE__ */ __name((timeouts) => (timeouts.forEach(clearTimeout), []), "destroyTimeouts"), duplicate = /* @__PURE__ */ __name((value, times) => new Array(times).fill(value), "duplicate");
let beforePaint = /* @__PURE__ */ __name((cb) => new Promise((resolve) => {
  requestAnimationFrame(async () => {
    resolve(await cb());
  });
}), "beforePaint"), getAnimationFromElement = /* @__PURE__ */ __name((element) => element == null ? void 0 : element.getAnimations().find((animation) => animation.id === element.dataset.tiAnimationId), "getAnimationFromElement"), setCursorAnimation = /* @__PURE__ */ __name(({
  cursor,
  frames,
  options
}) => {
  let animation = cursor.animate(frames, options);
  return animation.pause(), animation.id = cursor.dataset.tiAnimationId, beforePaint(() => {
    beforePaint(() => {
      animation.play();
    });
  }), animation;
}, "setCursorAnimation"), rebuildCursorAnimation = /* @__PURE__ */ __name(({
  cursor,
  options,
  cursorOptions
}) => {
  if (!cursor || !cursorOptions) return;
  let animation = getAnimationFromElement(cursor), oldCurrentTime;
  animation && (options.delay = animation.effect.getComputedTiming().delay, oldCurrentTime = animation.currentTime, animation.cancel());
  let newAnimation = setCursorAnimation({
    cursor,
    frames: cursorOptions.animation.frames,
    options
  });
  return oldCurrentTime && (newAnimation.currentTime = oldCurrentTime), newAnimation;
}, "rebuildCursorAnimation"), execute = /* @__PURE__ */ __name((queueItem) => {
  var _a;
  return (_a = queueItem.func) == null ? void 0 : _a.call(null);
}, "execute"), fireItem = /* @__PURE__ */ __name(async ({
  index: index2,
  queueItems,
  wait: wait2,
  cursor,
  cursorOptions
}) => {
  let queueItem = queueItems[index2][1], instantQueue = [], tempIndex = index2, futureItem = queueItem, shouldBeGrouped = /* @__PURE__ */ __name(() => futureItem && !futureItem.delay, "shouldBeGrouped"), shouldPauseCursor = queueItem.shouldPauseCursor() && cursorOptions.autoPause;
  for (; shouldBeGrouped(); )
    instantQueue.push(futureItem), shouldBeGrouped() && tempIndex++, futureItem = queueItems[tempIndex] ? queueItems[tempIndex][1] : null;
  if (instantQueue.length)
    return await beforePaint(async () => {
      for (let q of instantQueue)
        await execute(q);
    }), tempIndex - 1;
  let animation = getAnimationFromElement(cursor), options;
  return animation && (options = {
    ...animation.effect.getComputedTiming(),
    delay: shouldPauseCursor ? cursorOptions.autoPauseDelay : 0
  }), await wait2(async () => {
    animation && shouldPauseCursor && animation.cancel(), await beforePaint(() => {
      execute(queueItem);
    });
  }, queueItem.delay), await rebuildCursorAnimation({
    cursor,
    options,
    cursorOptions
  }), index2;
}, "fireItem");
const fireWhenVisible = /* @__PURE__ */ __name((element, func) => {
  new IntersectionObserver(
    (entries, observer2) => {
      entries.forEach((entry) => {
        entry.isIntersecting && (func(), observer2.unobserve(element));
      });
    },
    { threshold: 1 }
  ).observe(element);
}, "fireWhenVisible"), generateHash = /* @__PURE__ */ __name(() => Math.random().toString().substring(2, 9), "generateHash"), isInput = /* @__PURE__ */ __name((el) => "value" in el, "isInput");
let getAllChars = /* @__PURE__ */ __name((element) => isInput(element) ? toArray(element.value) : walkElementNodes(element, !0).filter(
  (c) => !(c.childNodes.length > 0)
), "getAllChars"), handleFunctionalArg = /* @__PURE__ */ __name((arg) => typeof arg == "function" ? arg() : arg, "handleFunctionalArg"), select = /* @__PURE__ */ __name((selector, element = document, all = !1) => element[`querySelector${all ? "All" : ""}`](selector), "select"), isBodyElement = /* @__PURE__ */ __name((node) => /body/i.test(node == null ? void 0 : node.tagName), "isBodyElement"), insertIntoElement = /* @__PURE__ */ __name((originalTarget, character) => {
  if (isInput(originalTarget)) {
    originalTarget.value = `${originalTarget.value}${character.textContent}`;
    return;
  }
  character.innerHTML = "";
  let target = isBodyElement(character.originalParent) ? originalTarget : (
    // If we add one-off fresh elements, there will be no
    // "originalParent", so always fall back to the default target.
    character.originalParent || originalTarget
  ), cursorNode = select("." + CURSOR_CLASS, target) || null;
  cursorNode && cursorNode.parentElement !== target && (target = cursorNode.parentElement), target.insertBefore(character, cursorNode);
}, "insertIntoElement");
const isNonVoidElement = /* @__PURE__ */ __name((el) => /<(.+)>(.*?)<\/(.+)>/.test(el.outerHTML), "isNonVoidElement"), merge = /* @__PURE__ */ __name((originalObj, newObj) => Object.assign({}, originalObj, newObj), "merge");
let processCursorOptions = /* @__PURE__ */ __name((cursorOptions) => {
  var _a, _b;
  if (typeof cursorOptions == "object") {
    let newOptions = {}, { frames: defaultFrames, options: defaultOptions } = DEFAULT_OPTIONS.cursor.animation;
    return newOptions.animation = cursorOptions.animation || {}, newOptions.animation.frames = ((_a = cursorOptions.animation) == null ? void 0 : _a.frames) || defaultFrames, newOptions.animation.options = merge(
      defaultOptions,
      ((_b = cursorOptions.animation) == null ? void 0 : _b.options) || {}
    ), newOptions.autoPause = cursorOptions.autoPause ?? DEFAULT_OPTIONS.cursor.autoPause, newOptions.autoPauseDelay = cursorOptions.autoPauseDelay || DEFAULT_OPTIONS.cursor.autoPauseDelay, newOptions;
  }
  return cursorOptions === !0 ? DEFAULT_OPTIONS.cursor : cursorOptions;
}, "processCursorOptions");
const removeNode = /* @__PURE__ */ __name((node, rootElement) => {
  if (!node) return;
  let nodeParent = node.parentNode;
  (nodeParent.childNodes.length > 1 || nodeParent.isSameNode(rootElement) ? (
    // This parent still needs to exist.
    node
  ) : (
    // There's nothing else in there, so just delete the entire thing.
    // By doing this, we clean up markup as we go along.
    nodeParent
  )).remove();
}, "removeNode"), repositionCursor = /* @__PURE__ */ __name((element, allChars, newCursorPosition) => {
  let nodeToInsertBefore = allChars[newCursorPosition - 1], cursor = select(`.${CURSOR_CLASS}`, element);
  element = (nodeToInsertBefore == null ? void 0 : nodeToInsertBefore.parentNode) || element, element.insertBefore(cursor, nodeToInsertBefore || null);
}, "repositionCursor");
function selectorToElement(thing) {
  return typeof thing == "string" ? select(thing) : thing;
}
__name(selectorToElement, "selectorToElement");
let cursorFontStyles = {
  "font-family": "",
  "font-weight": "",
  "font-size": "",
  "font-style": "",
  "line-height": "",
  color: "",
  transform: "translateX(-.125em)"
}, setCursorStyles = /* @__PURE__ */ __name((id2, element) => {
  let cursorSelector = `${`[${DATA_ATTRIBUTE}='${id2}']`} .${CURSOR_CLASS}`, computedStyles = getComputedStyle(element), customProperties = Object.entries(cursorFontStyles).reduce(
    (accumulator, [item, value]) => `${accumulator} ${item}: var(--ti-cursor-${item}, ${value || computedStyles[item]});`,
    ""
  );
  appendStyleBlock(
    `${cursorSelector} { display: inline-block; width: 0; ${customProperties} }`,
    id2
  );
}, "setCursorStyles");
function splitOnBreak(str) {
  return str.replace(/<!--(.+?)-->/g, "").trim().split(/<br(?:\s*?)(?:\/)?>/);
}
__name(splitOnBreak, "splitOnBreak");
let updateCursorPosition = /* @__PURE__ */ __name((steps, cursorPosition, printedCharacters) => Math.min(
  Math.max(cursorPosition + steps, 0),
  printedCharacters.length
), "updateCursorPosition"), wait = /* @__PURE__ */ __name((callback, delay, timeouts) => new Promise((resolve) => {
  let cb = /* @__PURE__ */ __name(async () => {
    await callback(), resolve();
  }, "cb");
  timeouts.push(setTimeout(cb, delay || 0));
}), "wait");
var _TypeIt_instances, empty_fn, fire_fn, move_fn, prepLoop_fn, fireItemWithContext_fn, wait_fn, attachCursor_fn, elementIsInput_fn, queueAndReturn_fn, maybeAppendPause_fn, generateTemporaryOptionQueueItems_fn, updateOptions_fn, generateQueue_fn, _buildOptions, prependHardcodedStrings_fn, setUpCursor_fn, addSplitPause_fn, type_fn, delete_fn, removeNode_fn, getPace_fn, derivedCursorPosition_get, isInput_get, shouldRenderCursor_get, allChars_get;
const _TypeIt = class _TypeIt {
  constructor(element, options = {}) {
    __privateAdd(this, _TypeIt_instances);
    __publicField(this, "element");
    __publicField(this, "timeouts");
    __publicField(this, "cursorPosition");
    __publicField(this, "predictedCursorPosition");
    __publicField(this, "statuses", {
      started: !1,
      completed: !1,
      frozen: !1,
      destroyed: !1,
      firing: !1
    });
    __publicField(this, "opts");
    __publicField(this, "id");
    __publicField(this, "queue");
    __publicField(this, "cursor");
    __publicField(this, "flushCallback", null);
    __publicField(this, "unfreeze", /* @__PURE__ */ __name(() => {
    }, "unfreeze"));
    __publicField(this, "is", /* @__PURE__ */ __name(function(key) {
      return this.statuses[key];
    }, "is"));
    __privateAdd(this, _buildOptions, /* @__PURE__ */ __name((options) => {
      this.opts.cursor = processCursorOptions(
        options.cursor ?? DEFAULT_OPTIONS.cursor
      ), this.opts.strings = __privateMethod(this, _TypeIt_instances, prependHardcodedStrings_fn).call(this, asArray(this.opts.strings)), this.opts = merge(this.opts, {
        html: !__privateGet(this, _TypeIt_instances, isInput_get) && this.opts.html,
        nextStringDelay: calculateDelay(this.opts.nextStringDelay),
        loopDelay: calculateDelay(this.opts.loopDelay)
      });
    }, "#buildOptions"));
    this.opts = merge(DEFAULT_OPTIONS, options), this.element = selectorToElement(element), this.timeouts = [], this.cursorPosition = 0, this.unfreeze = () => {
    }, this.predictedCursorPosition = null, this.statuses = merge({}, DEFAULT_STATUSES), this.id = generateHash(), this.queue = Queue([{ delay: this.opts.startDelay }]), __privateGet(this, _buildOptions).call(this, options), this.cursor = __privateMethod(this, _TypeIt_instances, setUpCursor_fn).call(this), this.element.dataset.typeitId = this.id, appendStyleBlock(PLACEHOLDER_CSS), this.opts.strings.length && __privateMethod(this, _TypeIt_instances, generateQueue_fn).call(this);
  }
  /**
   * Can only be called once.
   */
  go() {
    return this.statuses.started ? this : (__privateMethod(this, _TypeIt_instances, attachCursor_fn).call(this), this.opts.waitUntilVisible ? (fireWhenVisible(this.element, __privateMethod(this, _TypeIt_instances, fire_fn).bind(this)), this) : (__privateMethod(this, _TypeIt_instances, fire_fn).call(this), this));
  }
  destroy(shouldRemoveCursor = !0) {
    this.timeouts = destroyTimeouts(this.timeouts), handleFunctionalArg(shouldRemoveCursor) && this.cursor && __privateMethod(this, _TypeIt_instances, removeNode_fn).call(this, this.cursor), this.statuses.destroyed = !0;
  }
  reset(rebuild) {
    !this.is("destroyed") && this.destroy(), rebuild ? (this.queue.wipe(), rebuild(this)) : this.queue.reset(), this.cursorPosition = 0;
    for (let property in this.statuses)
      this.statuses[property] = !1;
    return this.element[__privateMethod(this, _TypeIt_instances, elementIsInput_fn).call(this) ? "value" : "innerHTML"] = "", this;
  }
  type(string, actionOpts = {}) {
    string = handleFunctionalArg(string);
    let { instant } = actionOpts, bookEndQueueItems = __privateMethod(this, _TypeIt_instances, generateTemporaryOptionQueueItems_fn).call(this, actionOpts), charsAsQueueItems = maybeChunkStringAsHtml(string, this.opts.html).map((char) => ({
      func: /* @__PURE__ */ __name(() => __privateMethod(this, _TypeIt_instances, type_fn).call(this, char), "func"),
      char,
      delay: instant || isNonVoidElement(char) ? 0 : __privateMethod(this, _TypeIt_instances, getPace_fn).call(this),
      typeable: char.nodeType === Node.TEXT_NODE
    })), itemsToQueue = [
      bookEndQueueItems[0],
      { func: /* @__PURE__ */ __name(async () => await this.opts.beforeString(string, this), "func") },
      ...charsAsQueueItems,
      { func: /* @__PURE__ */ __name(async () => await this.opts.afterString(string, this), "func") },
      bookEndQueueItems[1]
    ];
    return __privateMethod(this, _TypeIt_instances, queueAndReturn_fn).call(this, itemsToQueue, actionOpts);
  }
  break(actionOpts = {}) {
    return __privateMethod(this, _TypeIt_instances, queueAndReturn_fn).call(this, {
      func: /* @__PURE__ */ __name(() => __privateMethod(this, _TypeIt_instances, type_fn).call(this, createElement("BR")), "func"),
      typeable: !0
    }, actionOpts);
  }
  move(movementArg, actionOpts = {}) {
    movementArg = handleFunctionalArg(movementArg);
    let bookEndQueueItems = __privateMethod(this, _TypeIt_instances, generateTemporaryOptionQueueItems_fn).call(this, actionOpts), { instant, to } = actionOpts, numberOfSteps = countStepsToSelector({
      queueItems: this.queue.getTypeable(),
      selector: movementArg === null ? "" : movementArg,
      to,
      cursorPosition: __privateGet(this, _TypeIt_instances, derivedCursorPosition_get)
    }), directionalStep = numberOfSteps < 0 ? -1 : 1;
    return this.predictedCursorPosition = __privateGet(this, _TypeIt_instances, derivedCursorPosition_get) + numberOfSteps, __privateMethod(this, _TypeIt_instances, queueAndReturn_fn).call(this, [
      bookEndQueueItems[0],
      ...duplicate(
        {
          func: /* @__PURE__ */ __name(() => __privateMethod(this, _TypeIt_instances, move_fn).call(this, directionalStep), "func"),
          delay: instant ? 0 : __privateMethod(this, _TypeIt_instances, getPace_fn).call(this),
          cursorable: !0
        },
        Math.abs(numberOfSteps)
      ),
      bookEndQueueItems[1]
    ], actionOpts);
  }
  exec(func, actionOpts = {}) {
    let bookEndQueueItems = __privateMethod(this, _TypeIt_instances, generateTemporaryOptionQueueItems_fn).call(this, actionOpts);
    return __privateMethod(this, _TypeIt_instances, queueAndReturn_fn).call(this, [bookEndQueueItems[0], { func: /* @__PURE__ */ __name(() => func(this), "func") }, bookEndQueueItems[1]], actionOpts);
  }
  options(opts, actionOpts = {}) {
    return opts = handleFunctionalArg(opts), __privateMethod(this, _TypeIt_instances, updateOptions_fn).call(this, opts), __privateMethod(this, _TypeIt_instances, queueAndReturn_fn).call(this, {}, actionOpts);
  }
  pause(milliseconds, actionOpts = {}) {
    return __privateMethod(this, _TypeIt_instances, queueAndReturn_fn).call(this, { delay: handleFunctionalArg(milliseconds) }, actionOpts);
  }
  delete(numCharacters = null, actionOpts = {}) {
    numCharacters = handleFunctionalArg(numCharacters);
    let bookEndQueueItems = __privateMethod(this, _TypeIt_instances, generateTemporaryOptionQueueItems_fn).call(this, actionOpts), num = numCharacters, { instant, to } = actionOpts, typeableQueueItems = this.queue.getTypeable(), rounds = num === null ? typeableQueueItems.length : isNumber(num) ? num : countStepsToSelector({
      queueItems: typeableQueueItems,
      selector: num,
      cursorPosition: __privateGet(this, _TypeIt_instances, derivedCursorPosition_get),
      to
    });
    return __privateMethod(this, _TypeIt_instances, queueAndReturn_fn).call(this, [
      bookEndQueueItems[0],
      ...duplicate(
        {
          func: __privateMethod(this, _TypeIt_instances, delete_fn).bind(this),
          delay: instant ? 0 : __privateMethod(this, _TypeIt_instances, getPace_fn).call(this, 1),
          deletable: !0
        },
        rounds
      ),
      bookEndQueueItems[1]
    ], actionOpts);
  }
  freeze() {
    this.statuses.frozen = !0;
  }
  /**
   * Like `.go()`, but more... "off the grid."
   *
   * - won't trigger `afterComplete` callback
   * - items won't be replayed after `.reset()`
   *
   * When called, all non-done items will be "flushed" --
   * that is, executed, but not remembered.
   */
  flush(cb = null) {
    return this.flushCallback = cb || this.flushCallback, this.statuses.firing ? this : (__privateMethod(this, _TypeIt_instances, attachCursor_fn).call(this), __privateMethod(this, _TypeIt_instances, fire_fn).call(this, !1).then(() => {
      if (this.queue.getPendingQueueItems().length > 0)
        return this.flush();
      this.flushCallback(), this.flushCallback = null;
    }), this);
  }
  getQueue() {
    return this.queue;
  }
  getOptions() {
    return this.opts;
  }
  updateOptions(options) {
    return __privateMethod(this, _TypeIt_instances, updateOptions_fn).call(this, options);
  }
  getElement() {
    return this.element;
  }
  empty(actionOpts = {}) {
    return __privateMethod(this, _TypeIt_instances, queueAndReturn_fn).call(this, { func: __privateMethod(this, _TypeIt_instances, empty_fn).bind(this) }, actionOpts);
  }
};
_TypeIt_instances = new WeakSet(), empty_fn = /* @__PURE__ */ __name(async function() {
  if (__privateMethod(this, _TypeIt_instances, elementIsInput_fn).call(this)) {
    this.element.value = "";
    return;
  }
  __privateGet(this, _TypeIt_instances, allChars_get).forEach(__privateMethod(this, _TypeIt_instances, removeNode_fn).bind(this));
}, "#empty"), fire_fn = /* @__PURE__ */ __name(async function(remember = !0) {
  this.statuses.started = !0, this.statuses.firing = !0;
  let cleanUp = /* @__PURE__ */ __name((qKey) => {
    this.queue.done(qKey, !remember);
  }, "cleanUp");
  try {
    let queueItems = [...this.queue.getQueue()];
    for (let index2 = 0; index2 < queueItems.length; index2++) {
      let [queueKey, queueItem] = queueItems[index2];
      if (!queueItem.done) {
        if (!queueItem.deletable || queueItem.deletable && __privateGet(this, _TypeIt_instances, allChars_get).length) {
          let newIndex = await __privateMethod(this, _TypeIt_instances, fireItemWithContext_fn).call(this, index2, queueItems);
          cleanUpSkipped({
            index: index2,
            newIndex,
            queueItems,
            cleanUp
          }), index2 = newIndex;
        }
        cleanUp(queueKey);
      }
    }
    if (!remember)
      return this.statuses.firing = !1, this;
    if (this.statuses.completed = !0, this.statuses.firing = !1, await this.opts.afterComplete(this), !this.opts.loop)
      throw "";
    let delay = this.opts.loopDelay;
    __privateMethod(this, _TypeIt_instances, wait_fn).call(this, async () => {
      await __privateMethod(this, _TypeIt_instances, prepLoop_fn).call(this, delay[0]), __privateMethod(this, _TypeIt_instances, fire_fn).call(this);
    }, delay[1]);
  } catch {
  }
  return this.statuses.firing = !1, this;
}, "#fire"), move_fn = /* @__PURE__ */ __name(async function(step) {
  this.cursorPosition = updateCursorPosition(
    step,
    this.cursorPosition,
    __privateGet(this, _TypeIt_instances, allChars_get)
  ), repositionCursor(this.element, __privateGet(this, _TypeIt_instances, allChars_get), this.cursorPosition);
}, "#move"), prepLoop_fn = /* @__PURE__ */ __name(async function(delay) {
  let derivedCursorPosition = __privateGet(this, _TypeIt_instances, derivedCursorPosition_get);
  derivedCursorPosition && await __privateMethod(this, _TypeIt_instances, move_fn).call(this, { value: derivedCursorPosition });
  let queueItems = __privateGet(this, _TypeIt_instances, allChars_get).map((c) => [
    Symbol(),
    {
      func: __privateMethod(this, _TypeIt_instances, delete_fn).bind(this),
      delay: __privateMethod(this, _TypeIt_instances, getPace_fn).call(this, 1),
      deletable: !0,
      shouldPauseCursor: /* @__PURE__ */ __name(() => !0, "shouldPauseCursor")
    }
  ]);
  for (let index2 = 0; index2 < queueItems.length; index2++)
    await __privateMethod(this, _TypeIt_instances, fireItemWithContext_fn).call(this, index2, queueItems);
  this.queue.reset(), this.queue.set(0, { delay });
}, "#prepLoop"), fireItemWithContext_fn = /* @__PURE__ */ __name(function(index2, queueItems) {
  return fireItem({
    index: index2,
    queueItems,
    wait: __privateMethod(this, _TypeIt_instances, wait_fn).bind(this),
    cursor: this.cursor,
    cursorOptions: this.opts.cursor
  });
}, "#fireItemWithContext"), wait_fn = /* @__PURE__ */ __name(async function(callback, delay, silent = !1) {
  this.statuses.frozen && await new Promise((resolve) => {
    this.unfreeze = () => {
      this.statuses.frozen = !1, resolve();
    };
  }), silent || await this.opts.beforeStep(this), await wait(callback, delay, this.timeouts), silent || await this.opts.afterStep(this);
}, "#wait"), attachCursor_fn = /* @__PURE__ */ __name(async function() {
  if (!__privateMethod(this, _TypeIt_instances, elementIsInput_fn).call(this) && this.cursor && this.element.appendChild(this.cursor), __privateGet(this, _TypeIt_instances, shouldRenderCursor_get)) {
    setCursorStyles(this.id, this.element), this.cursor.dataset.tiAnimationId = this.id;
    let { animation } = this.opts.cursor, { frames, options } = animation;
    setCursorAnimation({
      frames,
      cursor: this.cursor,
      options: {
        duration: this.opts.cursorSpeed,
        ...options
      }
    });
  }
}, "#attachCursor"), elementIsInput_fn = /* @__PURE__ */ __name(function() {
  return isInput(this.element);
}, "#elementIsInput"), queueAndReturn_fn = /* @__PURE__ */ __name(function(steps, opts) {
  return this.queue.add(steps), __privateMethod(this, _TypeIt_instances, maybeAppendPause_fn).call(this, opts), this;
}, "#queueAndReturn"), maybeAppendPause_fn = /* @__PURE__ */ __name(function(opts = {}) {
  let delay = opts.delay;
  delay && this.queue.add({ delay });
}, "#maybeAppendPause"), generateTemporaryOptionQueueItems_fn = /* @__PURE__ */ __name(function(newOptions = {}) {
  return [
    { func: /* @__PURE__ */ __name(() => __privateMethod(this, _TypeIt_instances, updateOptions_fn).call(this, newOptions), "func") },
    { func: /* @__PURE__ */ __name(() => __privateMethod(this, _TypeIt_instances, updateOptions_fn).call(this, this.opts), "func") }
  ];
}, "#generateTemporaryOptionQueueItems"), updateOptions_fn = /* @__PURE__ */ __name(async function(opts) {
  this.opts = merge(this.opts, opts);
}, "#updateOptions"), /**
 * Based on provided strings, generate a TypeIt queue
 * to be fired for each character in the string.
 */
generateQueue_fn = /* @__PURE__ */ __name(function() {
  let strings = this.opts.strings.filter((string) => !!string);
  strings.forEach((string, index2) => {
    if (this.type(string), index2 + 1 === strings.length)
      return;
    let splitItems = this.opts.breakLines ? [{ func: /* @__PURE__ */ __name(() => __privateMethod(this, _TypeIt_instances, type_fn).call(this, createElement("BR")), "func"), typeable: !0 }] : duplicate(
      {
        func: __privateMethod(this, _TypeIt_instances, delete_fn).bind(this),
        delay: __privateMethod(this, _TypeIt_instances, getPace_fn).call(this, 1)
      },
      this.queue.getTypeable().length
    );
    __privateMethod(this, _TypeIt_instances, addSplitPause_fn).call(this, splitItems);
  });
}, "#generateQueue"), _buildOptions = new WeakMap(), prependHardcodedStrings_fn = /* @__PURE__ */ __name(function(strings) {
  let existingMarkup = this.element.innerHTML;
  return existingMarkup ? (this.element.innerHTML = "", this.opts.startDelete ? (this.element.innerHTML = existingMarkup, expandTextNodes(this.element), __privateMethod(this, _TypeIt_instances, addSplitPause_fn).call(this, duplicate(
    {
      func: __privateMethod(this, _TypeIt_instances, delete_fn).bind(this),
      delay: __privateMethod(this, _TypeIt_instances, getPace_fn).call(this, 1),
      deletable: !0
    },
    __privateGet(this, _TypeIt_instances, allChars_get).length
  )), strings) : splitOnBreak(existingMarkup).concat(strings)) : strings;
}, "#prependHardcodedStrings"), /**
 * Provided it's a non-form element and the options is provided,
 * set up the cursor element for the animation.
 */
setUpCursor_fn = /* @__PURE__ */ __name(function() {
  if (__privateGet(this, _TypeIt_instances, isInput_get))
    return null;
  let cursor = createElement("span");
  return cursor.className = CURSOR_CLASS, __privateGet(this, _TypeIt_instances, shouldRenderCursor_get) ? (cursor.innerHTML = getParsedBody(this.opts.cursorChar).innerHTML, cursor) : (cursor.style.visibility = "hidden", cursor);
}, "#setUpCursor"), addSplitPause_fn = /* @__PURE__ */ __name(function(items) {
  let delay = this.opts.nextStringDelay;
  this.queue.add([{ delay: delay[0] }, ...items, { delay: delay[1] }]);
}, "#addSplitPause"), type_fn = /* @__PURE__ */ __name(function(char) {
  insertIntoElement(this.element, char);
}, "#type"), delete_fn = /* @__PURE__ */ __name(function() {
  __privateGet(this, _TypeIt_instances, allChars_get).length && (__privateGet(this, _TypeIt_instances, isInput_get) ? this.element.value = this.element.value.slice(0, -1) : __privateMethod(this, _TypeIt_instances, removeNode_fn).call(this, __privateGet(this, _TypeIt_instances, allChars_get)[this.cursorPosition]));
}, "#delete"), removeNode_fn = /* @__PURE__ */ __name(function(node) {
  removeNode(node, this.element);
}, "#removeNode"), getPace_fn = /* @__PURE__ */ __name(function(index2 = 0) {
  return calculatePace(this.opts)[index2];
}, "#getPace"), derivedCursorPosition_get = /* @__PURE__ */ __name(function() {
  return this.predictedCursorPosition ?? this.cursorPosition;
}, "#derivedCursorPosition"), isInput_get = /* @__PURE__ */ __name(function() {
  return isInput(this.element);
}, "#isInput"), shouldRenderCursor_get = /* @__PURE__ */ __name(function() {
  return !!this.opts.cursor && !__privateGet(this, _TypeIt_instances, isInput_get);
}, "#shouldRenderCursor"), allChars_get = /* @__PURE__ */ __name(function() {
  return getAllChars(this.element);
}, "#allChars"), __name(_TypeIt, "TypeIt");
let TypeIt = _TypeIt;
var TextLogIntro = /* @__PURE__ */ ((TextLogIntro2) => (TextLogIntro2[TextLogIntro2.Version = 0] = "Version", TextLogIntro2[TextLogIntro2.Header = 1] = "Header", TextLogIntro2[TextLogIntro2.Log = 2] = "Log", TextLogIntro2))(TextLogIntro || {}), TextLogHook = /* @__PURE__ */ ((TextLogHook2) => (TextLogHook2.MechHeader = "laMechHeaderLog", TextLogHook2.MechHeaderReset = "laMechHeaderLogReset", TextLogHook2.PilotHeader = "laPilotHeaderLog", TextLogHook2.PilotHeaderReset = "laPilotHeaderLogReset", TextLogHook2))(TextLogHook || {});
function setIntroRun(uuid, enabled) {
  SheetStore.set(uuid, { introPlayed: enabled });
}
__name(setIntroRun, "setIntroRun");
function getIntroRun(uuid) {
  var _a;
  return (_a = SheetStore.get(uuid)) == null ? void 0 : _a.introPlayed;
}
__name(getIntroRun, "getIntroRun");
const _TypedWriter = class _TypedWriter {
  constructor(component, hookID, hookResetID) {
    __publicField(this, "typed", null);
    __publicField(this, "garbage", null);
    __publicField(this, "component");
    __publicField(this, "hookID");
    __publicField(this, "hookResetID");
    __publicField(this, "typedOptions", {
      typeSpeed: 0,
      backSpeed: 0,
      showCursor: !0,
      cursorChar: "_",
      loop: !1
    });
    this.component = component, this.hookID = hookID, this.hookResetID = hookResetID;
  }
  registerHooks(uuid) {
    trackHook(uuid, Hooks.on(this.hookID, (text2) => {
      var _a;
      (_a = this.typed) == null || _a.destroy(), this.typed = new i(this.component, {
        strings: [text2],
        ...this.typedOptions
      });
    }), this.hookID), trackHook(uuid, Hooks.on(this.hookResetID, () => {
      var _a;
      this.garbage = this.typed, this.typed = new i(this.component, {
        strings: [""],
        ...this.typedOptions
      }), (_a = this.garbage) == null || _a.destroy();
    }), this.hookResetID);
  }
};
__name(_TypedWriter, "TypedWriter");
let TypedWriter = _TypedWriter;
const _TypeItWriter = class _TypeItWriter {
  constructor(component) {
    __publicField(this, "instance");
    this.instance = new TypeIt(component, {
      speed: 25,
      lifeLike: !1,
      cursor: !1
    });
  }
  getRandomDelay() {
    return Math.floor(Math.random() * 201);
  }
  getFormattedText(introType) {
    switch (introType) {
      case TextLogIntro.Version:
        const template2 = getLocalized("LA.mech.log.version");
        return formatString(template2, getFoundryVersion(), getLancerVersion(), getModuleVersion());
      case TextLogIntro.Header:
        return getLocalized("LA.mech.log.cc.welcome");
    }
    return "";
  }
  runIntro(introType) {
    switch (introType) {
      case TextLogIntro.Header:
        this.instance.type(formatString("COMPANION/CONCIERGE UNIT v{0}", getModuleVersion())).break().type("> INITIALIZING / INICIALIZANDO / 初期化中").type(" . ", { delay: 200 }).type(". ", { delay: 200 }).type(". ", { delay: 200 }).pause(500).break().type(">> OMNINET", { delay: this.getRandomDelay() }).pause(this.getRandomDelay()).type(" . ", { delay: this.getRandomDelay() }).type(". ", { delay: this.getRandomDelay() }).type(". ", { delay: this.getRandomDelay() }).type("CONNECTED").break().type(">> SYSTEMS", { delay: this.getRandomDelay() }).pause(this.getRandomDelay()).type(" . ", { delay: this.getRandomDelay() }).type(". ", { delay: this.getRandomDelay() }).type(". ", { delay: this.getRandomDelay() }).type("ONLINE").break().type(">> WEAPONS", { delay: this.getRandomDelay() }).pause(this.getRandomDelay()).type(" . ", { delay: this.getRandomDelay() }).type(". ", { delay: this.getRandomDelay() }).type(". ", { delay: this.getRandomDelay() }).type("ARMED").break().pause(500).type("INITIALIZATION COMPLETE / INICIALIZAÇÃO CONCLUÍDA / 初期化完了", { delay: 0 }).break().type(this.getFormattedText(TextLogIntro.Version)).break().pause(500).type(this.getFormattedText(introType)).go();
    }
  }
  getFinishedIntro(introType) {
    switch (introType) {
      case TextLogIntro.Header:
        return `
                    <span>${formatString("COMPANION/CONCIERGE UNIT v{0}", getModuleVersion())}</span><br>
                    <span>> INITIALIZING / INICIALIZANDO / 初期化中</span><br>
                    <span>>> OMNINET . . . CONNECTED</span><br>
                    <span>>> SYSTEMS . . . ONLINE</span><br>
                    <span>>> WEAPONS . . . ARMED</span><br>
                    <span>INITIALIZATION COMPLETE / INICIALIZAÇÃO CONCLUÍDA / 初期化完了</span><br>
                    <span>${this.getFormattedText(TextLogIntro.Version)}</span><br>
                    <span>${this.getFormattedText(introType)}</span>
                `;
    }
    return "";
  }
};
__name(_TypeItWriter, "TypeItWriter");
let TypeItWriter = _TypeItWriter;
function sendToLog(event2, logText, type) {
  event2.stopPropagation(), Hooks.call(type, logText);
}
__name(sendToLog, "sendToLog");
function resetLog(event2, type) {
  event2.stopPropagation(), Hooks.call(type);
}
__name(resetLog, "resetLog");
function getThemeKey(uuid) {
  return SheetStore.get(uuid).currentTheme;
}
__name(getThemeKey, "getThemeKey");
function setThemeKey(uuid, theme) {
  SheetStore.set(uuid, { currentTheme: theme });
}
__name(setThemeKey, "setThemeKey");
var ActiveTab = /* @__PURE__ */ ((ActiveTab2) => (ActiveTab2.Primary = "primary", ActiveTab2.Secondary = "secondary", ActiveTab2.Tertiary = "tertiary", ActiveTab2.Quaternary = "quaternary", ActiveTab2))(ActiveTab || {});
const PUBLIC_VERSION = "5";
typeof window < "u" && (window.__svelte || (window.__svelte = { v: /* @__PURE__ */ new Set() })).v.add(PUBLIC_VERSION);
function Tooltip($$anchor, $$props) {
  var fragment = comment(), node = first_child(fragment);
  snippet(node, () => $$props.content), append($$anchor, fragment);
}
__name(Tooltip, "Tooltip");
const _TooltipFactory = class _TooltipFactory {
  // CSS classes need to be applied via the `data-tooltip-class` attribute
  static buildTooltip(text2, header) {
    return `
            ${header ? `<h3 class="la-tooltip__header">${header}</h3>` : ""}
            <div class="la-tooltip__content">
                ${text2}
            </div>
        `;
  }
  // (#5) Locked tooltips (and potentially all tooltips created through the manager) do not 
  // work with modules such as PopOut! A custom solution would have to be rolled out
  static renderTooltip(event2, tooltipSettings) {
    const manager = game.tooltip, options = {};
    tooltipSettings.direction && (options.direction = tooltipSettings.direction), tooltipSettings.text && (options.text = tooltipSettings.text), tooltipSettings.locked && (options.locked = tooltipSettings.locked), tooltipSettings.cssClass && (options.cssClass = tooltipSettings.cssClass), manager.activate(event2.currentTarget, options);
  }
  // (#5)
  static renderTooltipSvelte(event2, props, tooltipSettings) {
    const manager = game.tooltip, mountDiv = document.createElement("div");
    mountDiv.className = "la-tooltip-mount -widthfull", mount(
      Tooltip,
      {
        target: mountDiv,
        props
      }
    );
    const options = {
      content: mountDiv
    };
    tooltipSettings.direction && (options.direction = tooltipSettings.direction), tooltipSettings.locked && (options.locked = tooltipSettings.locked), tooltipSettings.cssClass && (options.cssClass = tooltipSettings.cssClass), manager.activate(event2.currentTarget, options);
    const root2 = mountDiv.parentElement, observer = new MutationObserver((mutations) => {
      mutations.forEach((mutation) => {
        var _a;
        root2 && Array.from(mutation.removedNodes).includes(root2) && (observer.disconnect(), (_a = props.unrenderCallback) == null || _a.call(props));
      });
    });
    return root2 && root2.parentNode && observer.observe(root2.parentNode, { childList: !0 }), root2;
  }
  static unrenderTooltip(element) {
    if (!element)
      return;
    game.tooltip.dismissLockedTooltip(element);
  }
  static unrenderTooltips() {
    game.tooltip.dismissLockedTooltips();
  }
};
__name(_TooltipFactory, "TooltipFactory");
let TooltipFactory = _TooltipFactory;
var TooltipDirection = /* @__PURE__ */ ((TooltipDirection2) => (TooltipDirection2.UP = "UP", TooltipDirection2.DOWN = "DOWN", TooltipDirection2.LEFT = "LEFT", TooltipDirection2.RIGHT = "RIGHT", TooltipDirection2.CENTER = "CENTER", TooltipDirection2.TOP = "TOP", TooltipDirection2))(TooltipDirection || {}), FlowClass = /* @__PURE__ */ ((FlowClass2) => (FlowClass2.Standard = "lancer-flow-button", FlowClass2.RollAttack = "roll-attack", FlowClass2.RollDamage = "roll-damage", FlowClass2.RollStat = "roll-stat", FlowClass2.RollHASE = "roll-stat hase", FlowClass2.RollTech = "roll-tech", FlowClass2.SendToChat = "chat-flow-button", FlowClass2.SendEffectToChat = "effect-flow", FlowClass2.ResetOvercharge = "overcharge-reset", FlowClass2.CoreActivation = "activation-flow", FlowClass2.RechargeFeatures = "charge-macro", FlowClass2.ContextMenu = "lancer-context-menu", FlowClass2.ContextItem = "lancer-context-item", FlowClass2.Skill = "skill-flow", FlowClass2.GeneralControl = "gen-control", FlowClass2.BondPower = "bond-power-flow", FlowClass2.BondTallyXP = "bond-xp-button", FlowClass2.BondPowerRefresh = "refresh-powers-button", FlowClass2.DownloadFromCloud = "cloud-control", FlowClass2.EditText = "popout-text-edit-button", FlowClass2.DeleteActiveEffect = "", FlowClass2.Inventory = "", FlowClass2.None = "NO_FLOW_CLASS", FlowClass2))(FlowClass || {}), CustomFlowClass = /* @__PURE__ */ ((CustomFlowClass2) => (CustomFlowClass2.SendUnknownToChat = "SendUnknownToChat", CustomFlowClass2.RunMacro = "RunMacro", CustomFlowClass2.SkillTriggerOther = "SkillTriggerOther", CustomFlowClass2))(CustomFlowClass || {});
const FLOW_BUTTON_STYLE = " -padding1-r -padding0-tb -height3 -letterspacing0 la-text-header la-prmy-header ";
var root_1$z = /* @__PURE__ */ template('<span class="la-cmdline -fadein">>//:</span>'), root_3$x = /* @__PURE__ */ template('<span class="la-extension -lower -fadein"> </span>'), root_4$d = /* @__PURE__ */ template('<span class="la-cursor -fadein"></span>'), root$$ = /* @__PURE__ */ template("<div><!><span><!> </span><!><!></div>");
function TerminalText($$anchor, $$props) {
  push($$props, !0);
  var div = root$$(), node = child(div);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var span = root_1$z();
      append($$anchor2, span);
    }, "consequent");
    if_block(node, ($$render) => {
      $$props.disableCmdline || $$render(consequent);
    });
  }
  var span_1 = sibling(node), node_1 = child(span_1);
  {
    var consequent_1 = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment = comment(), node_2 = first_child(fragment);
      snippet(node_2, () => $$props.children), append($$anchor2, fragment);
    }, "consequent_1");
    if_block(node_1, ($$render) => {
      $$props.children && $$render(consequent_1);
    });
  }
  var text_1 = sibling(node_1, 1, !0), node_3 = sibling(span_1);
  {
    var consequent_2 = /* @__PURE__ */ __name(($$anchor2) => {
      var span_2 = root_3$x(), text_2 = child(span_2);
      template_effect(($0) => set_text(text_2, $0), [
        () => $$props.extensionText || `--${getLocalized("LA.scan.label")}`
      ]), append($$anchor2, span_2);
    }, "consequent_2");
    if_block(node_3, ($$render) => {
      $$props.disableExtension || $$render(consequent_2);
    });
  }
  var node_4 = sibling(node_3);
  {
    var consequent_3 = /* @__PURE__ */ __name(($$anchor2) => {
      var span_3 = root_4$d();
      append($$anchor2, span_3);
    }, "consequent_3");
    if_block(node_4, ($$render) => {
      $$props.disableCursor || $$render(consequent_3);
    });
  }
  template_effect(
    ($0) => {
      set_class(div, `la-terminaltext -whitespacenowrap -textoverflowellipsis -textalignleft ${$0 ?? ""}`), set_text(text_1, $$props.text);
    },
    [() => {
      var _a;
      return (_a = $$props.textStyle) == null ? void 0 : _a.join(" ");
    }]
  ), append($$anchor, div), pop();
}
__name(TerminalText, "TerminalText");
var on_click$7 = /* @__PURE__ */ __name((event2, toggleAdvancedOptions) => toggleAdvancedOptions(event2), "on_click$7"), root_1$y = /* @__PURE__ */ template('<button type="button"><i></i></button>');
function AdvancedButton($$anchor, $$props) {
  push($$props, !0);
  let advancedOptions = /* @__PURE__ */ derived(() => getAdvancedState($$props.uuid));
  const tip = TooltipFactory.buildTooltip($$props.tooltip || getLocalized("LA.advanced.tooltip"), $$props.tooltipHeader), logging = $$props.logType && $$props.logTypeReset, log = $$props.logText || getLocalized("LA.advanced.tooltip");
  function toggleAdvancedOptions(event2) {
    event2.stopPropagation(), setAdvancedState($$props.uuid, !get$1(advancedOptions));
  }
  __name(toggleAdvancedOptions, "toggleAdvancedOptions");
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var button = root_1$y();
      button.__click = [on_click$7, toggleAdvancedOptions];
      var i2 = child(button);
      template_effect(
        ($0, $1, $2) => {
          set_class(button, $0), set_attribute(button, "aria-label", $1), set_attribute(button, "data-tooltip", $$props.tooltipEnabled ? tip : void 0), set_attribute(button, "data-tooltip-class", `${$$props.tooltipClass || "clipped-bot la-tooltip"} ${$$props.tooltipTheme}`), set_attribute(button, "data-tooltip-direction", $$props.tooltipDirection || TooltipDirection.LEFT), set_class(i2, `mdi ${$2 ?? ""}
        ${(get$1(advancedOptions) ? "mdi-toggle-switch" : "mdi-toggle-switch-off") ?? ""}`);
        },
        [
          () => {
            var _a;
            return ((_a = $$props.style) == null ? void 0 : _a.join(" ")) || "-fontsize3";
          },
          () => getLocalized("LA.advanced.tooltip"),
          () => {
            var _a;
            return ((_a = $$props.iconStyle) == null ? void 0 : _a.join(" ")) || "-fontsize5 la-text-header";
          }
        ]
      ), event("pointerenter", button, function(...$$args) {
        var _a;
        (_a = logging ? (event2) => sendToLog(event2, log, $$props.logType) : void 0) == null || _a.apply(this, $$args);
      }), event("pointerleave", button, function(...$$args) {
        var _a;
        (_a = logging ? (event2) => resetLog(event2, $$props.logTypeReset) : void 0) == null || _a.apply(this, $$args);
      }), append($$anchor2, button);
    }, "consequent");
    if_block(node, ($$render) => {
      $$props.uuid && $$render(consequent);
    });
  }
  append($$anchor, fragment), pop();
}
__name(AdvancedButton, "AdvancedButton");
delegate(["click"]);
var on_pointerdown = /* @__PURE__ */ __name((event2, handlePointerDown) => handlePointerDown(event2), "on_pointerdown"), on_pointermove = /* @__PURE__ */ __name((event2, handlePointerMove) => handlePointerMove(event2), "on_pointermove"), root$_ = /* @__PURE__ */ template('<div class="la-boundimage -flex1 -widthfull -heightfull"><!> <img></div>');
function BoundImage($$anchor, $$props) {
  push($$props, !0);
  let advancedOptions = /* @__PURE__ */ derived(() => getAdvancedState($$props.uuid)), dragging = !1, offset = { x: 0, y: 0 }, position = state(proxy({
    x: $$props.xGetter ? $$props.xGetter($$props.uuid) : 0,
    y: $$props.yGetter ? $$props.yGetter($$props.uuid) : 0
  }));
  function handlePointerDown(event2) {
    get$1(advancedOptions) && (dragging = !0, offset = {
      x: event2.clientX - get$1(position).x,
      y: event2.clientY - get$1(position).y
    });
  }
  __name(handlePointerDown, "handlePointerDown");
  function handlePointerMove(event2) {
    dragging && set(position, proxy({
      x: event2.clientX - offset.x,
      y: event2.clientY - offset.y
    }));
  }
  __name(handlePointerMove, "handlePointerMove");
  function handlePointerUp(_event, callback) {
    dragging && callback && callback(), dragging = !1;
  }
  __name(handlePointerUp, "handlePointerUp");
  function handleAssignment(event2) {
    handlePointerUp(event2, () => {
      $$props.xySetter && $$props.xySetter($$props.uuid, get$1(position).x, get$1(position).y), $$props.ySetter && $$props.ySetter($$props.uuid, get$1(position).y), $$props.xSetter && $$props.xSetter($$props.uuid, get$1(position).x);
    });
  }
  __name(handleAssignment, "handleAssignment");
  var div = root$_(), node = child(div);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment = comment(), node_1 = first_child(fragment);
      snippet(node_1, () => $$props.children), append($$anchor2, fragment);
    }, "consequent");
    if_block(node, ($$render) => {
      $$props.children && $$render(consequent);
    });
  }
  var img = sibling(node, 2);
  set_attribute(img, "alt", `modules/${id}/assets/nodata.png`), img.__pointerdown = [on_pointerdown, handlePointerDown], img.__pointermove = [on_pointermove, handlePointerMove], img.__pointerup = handleAssignment, set_attribute(img, "draggable", !1), template_effect(() => {
    set_class(img, `la-boundimage__image -heightfull -overflowhidden -float-r
            ${(get$1(advancedOptions) ? "-pointermove" : "") ?? ""}`), set_attribute(img, "src", $$props.image), set_attribute(img, "style", `
            margin-top: ${($$props.xySetter || $$props.ySetter ? get$1(position).y : 0) ?? ""}px;
            margin-right: ${($$props.xySetter || $$props.xSetter ? -get$1(position).x : 0) ?? ""}px;
            mask-image: linear-gradient(to bottom, black calc(6.6rem - ${get$1(position).y ?? ""}px), transparent calc(10rem - ${get$1(position).y ?? ""}px));
            -webkit-mask-image: linear-gradient(to bottom, black calc(6.6rem - ${get$1(position).y ?? ""}px), transparent calc(10rem - ${get$1(position).y ?? ""}px));
            -moz-mask-image: linear-gradient(to bottom, black calc(6.6rem - ${get$1(position).y ?? ""}px), transparent calc(10rem - ${get$1(position).y ?? ""}px));`);
  }), event("pointerleave", img, handleAssignment), append($$anchor, div), pop();
}
__name(BoundImage, "BoundImage");
delegate(["pointerdown", "pointermove", "pointerup"]);
var root_1$x = /* @__PURE__ */ template('<div><div class="la-combine-v -gap1 la-textlog-left -aligncontentend -overflowhidden -width2"><div></div> <div class="la-textlog-left__current -widthfull"></div></div> <div class="la-combine-v la-textlog-left -justifyend -overflowhidden"><div class="la-textlog__typeit -flex1 -justifystart -aligncontentend -widthfull"></div> <div class="la-textlog__typed la-combine-h -flex0 -justifystart -widthfull">>//:&nbsp; <div>&nbsp;</div></div></div> <div class="la-combine-v -gap1 la-textlog-right -aligncontentend -overflowhidden -width2"><div></div> <div class="la-textlog-right__current -widthfull"></div></div></div>');
function TextLog($$anchor, $$props) {
  push($$props, !0);
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), {
    style,
    runIntro,
    introType,
    uuid,
    hookID,
    hookResetID
  } = props;
  let typeItComponent = state(null), typedComponent = state(null), typedWriter = null, typeItWriter = null;
  const enabled = getMechSheetLogHeaderEnabled();
  onMount(() => {
    enabled && (typedWriter = new TypedWriter(get$1(typedComponent), hookID, hookResetID), typedWriter.registerHooks(uuid), typeItWriter = new TypeItWriter(get$1(typeItComponent)), runIntro ? (typeItWriter.runIntro(introType), setIntroRun(uuid, !0)) : get$1(typeItComponent).innerHTML = typeItWriter.getFinishedIntro(introType));
  });
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var div = root_1$x(), div_1 = child(div), div_2 = child(div_1);
      set_class(div_2, `la-textlog__ruler -flex1 -widthfull ${(introType ? "" : "-visibilityhidden") ?? ""}`);
      var div_3 = sibling(div_1, 2), div_4 = child(div_3);
      bind_this(div_4, ($$value) => set(typeItComponent, $$value), () => get$1(typeItComponent));
      var div_5 = sibling(div_4, 2), div_6 = sibling(child(div_5));
      bind_this(div_6, ($$value) => set(typedComponent, $$value), () => get$1(typedComponent));
      var div_7 = sibling(div_3, 2), div_8 = child(div_7);
      set_class(div_8, `la-textlog__ruler -flex1 -widthfull ${(introType ? "" : "-visibilityhidden") ?? ""}`), template_effect(($0) => set_class(div, `la-textlog la-combine-h -justifystart ${$0 ?? ""}`), [() => style == null ? void 0 : style.join(" ")]), append($$anchor2, div);
    }, "consequent");
    if_block(node, ($$render) => {
      enabled && $$render(consequent);
    });
  }
  append($$anchor, fragment), pop();
}
__name(TextLog, "TextLog");
var root$Z = /* @__PURE__ */ template('<button type="button"><!></button>');
function GlyphButton($$anchor, $$props) {
  push($$props, !0);
  const tip = $$props.tooltip ? TooltipFactory.buildTooltip($$props.tooltip, $$props.tooltipHeader) : void 0, logging = $$props.logType && $$props.logTypeReset && $$props.logText;
  function handleOnPointerEnter(event2) {
    if ($$props.onPointerEnter && $$props.onPointerEnter(), logging) sendToLog(event2, $$props.logText, $$props.logType);
    else return;
  }
  __name(handleOnPointerEnter, "handleOnPointerEnter");
  function handleOnPointerLeave(event2) {
    if ($$props.onPointerLeave && $$props.onPointerLeave(), logging) resetLog(event2, $$props.logTypeReset);
    else return;
  }
  __name(handleOnPointerLeave, "handleOnPointerLeave");
  var button = root$Z();
  button.__click = function(...$$args) {
    var _a;
    (_a = $$props.onClick) == null || _a.apply(this, $$args);
  };
  var node = child(button);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment = comment(), node_1 = first_child(fragment);
      snippet(node_1, () => $$props.children), append($$anchor2, fragment);
    }, "consequent");
    if_block(node, ($$render) => {
      $$props.children && $$render(consequent);
    });
  }
  template_effect(
    ($0) => {
      set_class(button, `
        ${$0 ?? ""}
        ${$$props.flowClass ?? ""}`), set_attribute(button, "data-uuid", $$props.uuid), set_attribute(button, "data-path", $$props.path), set_attribute(button, "data-action", $$props.action), set_attribute(button, "data-action-value", $$props.actionValue), set_attribute(button, "data-tooltip", $$props.tooltipEnabled && !$$props.disabled ? tip : void 0), set_attribute(button, "data-tooltip-class", `${$$props.tooltipClass || "clipped-bot la-tooltip"} ${$$props.tooltipTheme}`), set_attribute(button, "data-tooltip-direction", $$props.tooltipDirection), set_attribute(button, "aria-label", $$props.tooltip), button.disabled = $$props.disabled;
    },
    [() => {
      var _a;
      return (_a = $$props.style) == null ? void 0 : _a.join(" ");
    }]
  ), event("pointerenter", button, handleOnPointerEnter), event("pointerleave", button, handleOnPointerLeave), append($$anchor, button), pop();
}
__name(GlyphButton, "GlyphButton");
delegate(["click"]);
function LockImageButton($$anchor, $$props) {
  var _a;
  push($$props, !0);
  let tokenImageLocked = /* @__PURE__ */ derived(() => getTokenImageLock($$props.actor.uuid));
  const isVideo = isValidVideoContainer((_a = $$props.actor.prototypeToken) == null ? void 0 : _a.texture.src);
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent_1 = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment_1 = comment(), node_1 = first_child(fragment_1);
      {
        var consequent = /* @__PURE__ */ __name(($$anchor3) => {
          const expression = /* @__PURE__ */ derived(() => ["mdi mdi-link-variant-remove", $$props.style]), expression_1 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_2 = /* @__PURE__ */ derived(() => getLocalized("LA.advanced.link.error")), expression_3 = /* @__PURE__ */ derived(() => $$props.tooltipDirection || TooltipDirection.UP), expression_4 = /* @__PURE__ */ derived(() => getLocalized("LA.advanced.link.error"));
          GlyphButton($$anchor3, {
            get flowClass() {
              return FlowClass.None;
            },
            get style() {
              return get$1(expression);
            },
            onClick: /* @__PURE__ */ __name((event2) => handleToggleImageSync(event2, $$props.actor, $$props.setState), "onClick"),
            get tooltipEnabled() {
              return $$props.tooltipEnabled;
            },
            get tooltipTheme() {
              return get$1(expression_1);
            },
            get tooltip() {
              return get$1(expression_2);
            },
            get tooltipDirection() {
              return get$1(expression_3);
            },
            get logText() {
              return get$1(expression_4);
            },
            get logType() {
              return $$props.logType;
            },
            get logTypeReset() {
              return $$props.logTypeReset;
            }
          });
        }, "consequent"), alternate = /* @__PURE__ */ __name(($$anchor3) => {
          const expression_5 = /* @__PURE__ */ derived(() => ["mdi mdi-link-variant", $$props.style]), expression_6 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_7 = /* @__PURE__ */ derived(() => getLocalized("LA.advanced.link.tooltip")), expression_8 = /* @__PURE__ */ derived(() => $$props.tooltipDirection || TooltipDirection.UP), expression_9 = /* @__PURE__ */ derived(() => getLocalized("LA.advanced.link.tooltip"));
          GlyphButton($$anchor3, {
            get flowClass() {
              return FlowClass.None;
            },
            get style() {
              return get$1(expression_5);
            },
            onClick: /* @__PURE__ */ __name((event2) => handleToggleImageSync(event2, $$props.actor, $$props.setState), "onClick"),
            get tooltipEnabled() {
              return $$props.tooltipEnabled;
            },
            get tooltipTheme() {
              return get$1(expression_6);
            },
            get tooltip() {
              return get$1(expression_7);
            },
            get tooltipDirection() {
              return get$1(expression_8);
            },
            get logText() {
              return get$1(expression_9);
            },
            get logType() {
              return $$props.logType;
            },
            get logTypeReset() {
              return $$props.logTypeReset;
            }
          });
        }, "alternate");
        if_block(node_1, ($$render) => {
          isVideo ? $$render(consequent) : $$render(alternate, !1);
        });
      }
      append($$anchor2, fragment_1);
    }, "consequent_1"), alternate_1 = /* @__PURE__ */ __name(($$anchor2) => {
      const expression_10 = /* @__PURE__ */ derived(() => ["mdi mdi-link-variant-off", $$props.style]), expression_11 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_12 = /* @__PURE__ */ derived(() => getLocalized("LA.advanced.unlink.tooltip")), expression_13 = /* @__PURE__ */ derived(() => $$props.tooltipDirection || TooltipDirection.UP), expression_14 = /* @__PURE__ */ derived(() => getLocalized("LA.advanced.unlink.tooltip"));
      GlyphButton($$anchor2, {
        get flowClass() {
          return FlowClass.None;
        },
        get style() {
          return get$1(expression_10);
        },
        onClick: /* @__PURE__ */ __name((event2) => handleToggleImageSync(event2, $$props.actor, $$props.setState), "onClick"),
        get tooltipEnabled() {
          return $$props.tooltipEnabled;
        },
        get tooltipTheme() {
          return get$1(expression_11);
        },
        get tooltip() {
          return get$1(expression_12);
        },
        get tooltipDirection() {
          return get$1(expression_13);
        },
        get logText() {
          return get$1(expression_14);
        },
        get logType() {
          return $$props.logType;
        },
        get logTypeReset() {
          return $$props.logTypeReset;
        }
      });
    }, "alternate_1");
    if_block(node, ($$render) => {
      get$1(tokenImageLocked) ? $$render(consequent_1) : $$render(alternate_1, !1);
    });
  }
  append($$anchor, fragment), pop();
}
__name(LockImageButton, "LockImageButton");
var root_1$w = /* @__PURE__ */ template('<i class="mdi mdi-mouse-move-vertical -fontsize4 -aligncontentcenter la-text-header -width5 -glow-prmy la-prmy-primary"></i>'), root_2$o = /* @__PURE__ */ template("<!> <!>", 1), root_4$c = /* @__PURE__ */ template('<span class="-fontsize3"> </span>'), root_5$l = /* @__PURE__ */ template("<div> </div>"), root_6$o = /* @__PURE__ */ template(`<span class="la-textlog__wrapper -left0 -positionabsolute -padding1
            -pointerdisable"><!></span>`), root$Y = /* @__PURE__ */ template(`<div class="la-header-content la-combine-h"><div class="la-combine-v -alignend la-settings__island -padding1 -positionabsolute -right0 -top0" style="z-index: 3;"><div class="la-combine-h"><!> <!></div> <!></div> <div class="la-names -margin3 -alignselfstart -flex1" style="z-index: 2;"><div class="la-combine-h"><input type="text" class="la-actorname__input la-text-header -upper -fontsize5 -bold -letterspacing1
                    charname"> <span class="-fontsize0 la-text-darken-3"> </span></div> <hr class="la-divider-h -large -spacemedium -margin0-b la-bckg-header"> <div class="la-combine-h"><span class="la-pilotcallsign__span la-combine-h -justifystart -upper la-text-header -widthfull -overflowhidden
                    ref set pilot click-open"><!></span> <span class="-fontsize0 la-text-darken-3"> </span></div> <!></div> <!> <!></div>`);
function Header$3($$anchor, $$props) {
  push($$props, !0);
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor, pilot } = props;
  let introPlayed = /* @__PURE__ */ derived(() => getIntroRun(actor.uuid)), advancedOptions = /* @__PURE__ */ derived(() => getAdvancedState(actor.uuid)), tokenImageLocked = /* @__PURE__ */ derived(() => getTokenImageLock(actor.uuid));
  const tooltipEnabled = getMechSheetTooltipEnabled();
  onMount(() => {
    setTokenImageLock(actor.uuid, getActorTokenSync$3(actor.uuid));
  });
  var div = root$Y(), div_1 = child(div), div_2 = child(div_1), node = child(div_2);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var i2 = root_1$w();
      template_effect(
        ($0, $1) => {
          set_attribute(i2, "data-tooltip", $0), set_attribute(i2, "data-tooltip-class", `clipped-bot la-tooltip ${$1 ?? ""}`), set_attribute(i2, "data-tooltip-direction", TooltipDirection.LEFT);
        },
        [
          () => TooltipFactory.buildTooltip(getLocalized("LA.advanced.imageOffset.tooltip")),
          () => getCSSDocumentTheme(actor.uuid)
        ]
      ), append($$anchor2, i2);
    }, "consequent");
    if_block(node, ($$render) => {
      get$1(advancedOptions) && $$render(consequent);
    });
  }
  var node_1 = sibling(node, 2);
  const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid));
  AdvancedButton(node_1, {
    style: [
      "-fontsize3",
      "-width5",
      "-glow-prmy",
      "la-prmy-primary"
    ],
    get uuid() {
      return actor.uuid;
    },
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression);
    },
    get logType() {
      return TextLogHook.MechHeader;
    },
    get logTypeReset() {
      return TextLogHook.MechHeaderReset;
    }
  });
  var node_2 = sibling(div_2, 2);
  {
    var consequent_2 = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment = root_2$o(), node_3 = first_child(fragment);
      LockImageButton(node_3, {
        style: "-fontsize5 la-text-header la-prmy-primary -glow-prmy",
        actor,
        setState: setActorTokenSync$3,
        tooltipEnabled,
        get tooltipDirection() {
          return TooltipDirection.LEFT;
        },
        get logType() {
          return TextLogHook.MechHeader;
        },
        get logTypeReset() {
          return TextLogHook.MechHeaderReset;
        }
      });
      var node_4 = sibling(node_3, 2);
      {
        var consequent_1 = /* @__PURE__ */ __name(($$anchor3) => {
          const expression_1 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_2 = /* @__PURE__ */ derived(() => getLocalized("LA.edit.image.actor.tooltip")), expression_3 = /* @__PURE__ */ derived(() => getLocalized("LA.edit.image.actor.tooltip"));
          GlyphButton($$anchor3, {
            get flowClass() {
              return FlowClass.None;
            },
            style: [
              "mdi mdi-image-edit",
              "-fontsize4",
              "la-text-header",
              "-width5",
              "-glow-prmy",
              "la-prmy-primary"
            ],
            onClick: /* @__PURE__ */ __name((event2) => browseActorImage(event2, actor), "onClick"),
            tooltipEnabled,
            get tooltipTheme() {
              return get$1(expression_1);
            },
            get tooltip() {
              return get$1(expression_2);
            },
            get tooltipDirection() {
              return TooltipDirection.LEFT;
            },
            get logText() {
              return get$1(expression_3);
            },
            get logType() {
              return TextLogHook.MechHeader;
            },
            get logTypeReset() {
              return TextLogHook.MechHeaderReset;
            }
          });
        }, "consequent_1");
        if_block(node_4, ($$render) => {
          get$1(tokenImageLocked) || $$render(consequent_1);
        });
      }
      append($$anchor2, fragment);
    }, "consequent_2");
    if_block(node_2, ($$render) => {
      get$1(advancedOptions) && $$render(consequent_2);
    });
  }
  var div_3 = sibling(div_1, 2), div_4 = child(div_3), input = child(div_4);
  set_attribute(input, "name", "name");
  var span = sibling(input, 2), text2 = child(span), div_5 = sibling(div_4, 4), span_1 = child(div_5);
  set_attribute(span_1, "data-path", "system.pilot"), set_attribute(span_1, "data-accept-types", "pilot");
  var node_5 = child(span_1);
  const expression_4 = /* @__PURE__ */ derived(() => (pilot == null ? void 0 : pilot.system.level) || 0), expression_5 = /* @__PURE__ */ derived(() => getLocalized("LA.search.label"));
  TerminalText(node_5, {
    get text() {
      return `LL${get$1(expression_4) ?? ""}`;
    },
    get extensionText() {
      return `--${get$1(expression_5) ?? ""}`;
    },
    textStyle: ["-fontsize1", "la-prmy-header"],
    disableCmdline: !0,
    children: /* @__PURE__ */ __name(($$anchor2, $$slotProps) => {
      var span_2 = root_4$c(), text_1 = child(span_2);
      template_effect(($0) => set_text(text_1, $0), [
        () => (pilot == null ? void 0 : pilot.system.callsign) || getLocalized("LA.pilotPlaceholder")
      ]), append($$anchor2, span_2);
    }, "children"),
    $$slots: { default: !0 }
  });
  var span_3 = sibling(span_1, 2), text_2 = child(span_3), node_6 = sibling(div_5, 2);
  {
    var consequent_3 = /* @__PURE__ */ __name(($$anchor2) => {
      var div_6 = root_5$l(), text_3 = child(div_6);
      template_effect(($0) => set_text(text_3, $0), [
        () => getLocalized("LA.mech.noPilot.label")
      ]), append($$anchor2, div_6);
    }, "consequent_3");
    if_block(node_6, ($$render) => {
      var _a, _b;
      ((_b = (_a = pilot == null ? void 0 : pilot.system.active_mech) == null ? void 0 : _a.value) == null ? void 0 : _b.uuid) !== actor.uuid && $$render(consequent_3);
    });
  }
  var node_7 = sibling(div_3, 2);
  {
    var consequent_4 = /* @__PURE__ */ __name(($$anchor2) => {
      var span_4 = root_6$o(), node_8 = child(span_4);
      const expression_6 = /* @__PURE__ */ derived(() => !get$1(introPlayed));
      TextLog(node_8, {
        style: ["-widthfull", "-heightfull"],
        get uuid() {
          return actor.uuid;
        },
        get hookID() {
          return TextLogHook.MechHeader;
        },
        get hookResetID() {
          return TextLogHook.MechHeaderReset;
        },
        get introType() {
          return TextLogIntro.Header;
        },
        get runIntro() {
          return get$1(expression_6);
        }
      }), append($$anchor2, span_4);
    }, "consequent_4");
    if_block(node_7, ($$render) => {
      var _a, _b;
      ((_b = (_a = pilot == null ? void 0 : pilot.system.active_mech) == null ? void 0 : _a.value) == null ? void 0 : _b.uuid) === actor.uuid && $$render(consequent_4);
    });
  }
  var node_9 = sibling(node_7, 2);
  BoundImage(node_9, {
    get image() {
      return actor.img;
    },
    get uuid() {
      return actor.uuid;
    },
    yGetter: getImageOffsetY$1,
    ySetter: setImageOffsetY
  }), template_effect(
    ($0, $1, $2) => {
      set_value(input, actor.name), set_attribute(input, "placeholder", $0), set_text(text2, $1), set_attribute(span_1, "data-uuid", pilot == null ? void 0 : pilot.uuid), set_text(text_2, $2);
    },
    [
      () => getLocalized("LA.namePlaceholder"),
      () => getLocalized("LA.name.label"),
      () => getLocalized("LA.pilot.label")
    ]
  ), event("pointerenter", input, (event2) => sendToLog(event2, getLocalized("LA.mech.name.tooltip"), TextLogHook.MechHeader)), event("pointerleave", input, (event2) => resetLog(event2, TextLogHook.MechHeaderReset)), event("pointerenter", span_1, (event2) => sendToLog(event2, getLocalized("LA.pilot.open.tooltip"), TextLogHook.MechHeader)), event("pointerleave", span_1, (event2) => resetLog(event2, TextLogHook.MechHeaderReset)), append($$anchor, div), pop();
}
__name(Header$3, "Header$3");
var root_1$v = /* @__PURE__ */ template('<span class="la-damage__span -fontsize0 -flexbasis13 -textalignright"> </span>'), on_change$6 = /* @__PURE__ */ __name((event2, $$props) => handleRelativeDataInput(event2, $$props.currentValue), "on_change$6"), root_2$n = /* @__PURE__ */ template("<div></div>"), root_3$w = /* @__PURE__ */ template("<div></div>"), root$X = /* @__PURE__ */ template('<div><!> <div><div class="la-bar-h-progress la-combine-h -widthfull -heightfull"><input type="number" data-dtype="Number"> <span> </span></div> <div></div> <!> <!></div></div>');
function StatusBar($$anchor, $$props) {
  push($$props, !0);
  let editing = state(!1);
  const tip = $$props.tooltip ? TooltipFactory.buildTooltip($$props.tooltip, $$props.tooltipHeader) : void 0;
  var div = root$X(), node = child(div);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var span = root_1$v(), text2 = child(span);
      template_effect(() => {
        set_attribute(span, "data-tooltip", $$props.tooltipEnabled ? tip : void 0), set_attribute(span, "data-tooltip-class", `${$$props.tooltipClass || "clipped-bot la-tooltip"} ${$$props.tooltipTheme}`), set_attribute(span, "data-tooltip-direction", $$props.tooltipDirection ? $$props.tooltipDirection : "RIGHT"), set_text(text2, $$props.name);
      }), append($$anchor2, span);
    }, "consequent");
    if_block(node, ($$render) => {
      $$props.name && $$render(consequent);
    });
  }
  var div_1 = sibling(node, 2), div_2 = child(div_1), input = child(div_2);
  input.__change = [on_change$6, $$props];
  var span_1 = sibling(input, 2), text_1 = child(span_1), div_3 = sibling(div_2, 2), node_1 = sibling(div_3, 2);
  {
    var consequent_1 = /* @__PURE__ */ __name(($$anchor2) => {
      var div_4 = root_2$n();
      template_effect(
        ($0) => {
          set_class(div_4, `la-bar-h-progress -secondary la-bar-h-current -positionabsolute -top0 -heightfull 
                ${$0 ?? ""}`), set_attribute(div_4, "style", `--la-percent:${$$props.currentValueSecondary / $$props.maxValueSecondary * 100}%`);
        },
        [
          () => {
            var _a, _b;
            return $$props.editSecondary && $$props.barEditStyleSecondary ? `${(_a = $$props.barEditStyleSecondary) == null ? void 0 : _a.join(" ")} -pulse-bckg-prmy -fast` : (_b = $$props.barStyleSecondary) == null ? void 0 : _b.join(" ");
          }
        ]
      ), append($$anchor2, div_4);
    }, "consequent_1");
    if_block(node_1, ($$render) => {
      $$props.currentValueSecondary && $$props.maxValueSecondary && $$render(consequent_1);
    });
  }
  var node_2 = sibling(node_1, 2);
  {
    var consequent_2 = /* @__PURE__ */ __name(($$anchor2) => {
      var div_5 = root_3$w();
      template_effect(
        ($0) => {
          set_class(div_5, `la-bar-h-progress -tertiary la-bar-h-current -positionabsolute -top0 -heightfull 
                ${$0 ?? ""}`), set_attribute(div_5, "style", `--la-percent:${$$props.currentValueTertiary / $$props.maxValueTertiary * 100}%`);
        },
        [
          () => {
            var _a, _b;
            return $$props.editTertiary && $$props.barEditStyleTertiary ? `${(_a = $$props.barEditStyleTertiary) == null ? void 0 : _a.join(" ")} -pulse-bckg-prmy -fast` : (_b = $$props.barStyleTertiary) == null ? void 0 : _b.join(" ");
          }
        ]
      ), append($$anchor2, div_5);
    }, "consequent_2");
    if_block(node_2, ($$render) => {
      $$props.currentValueTertiary && $$props.maxValueTertiary && $$render(consequent_2);
    });
  }
  template_effect(
    ($0, $1, $2) => {
      set_class(div, `la-statusbar la-combine-h -fontsize1 -gap2 ${$0 ?? ""}`), set_class(div_1, `la-bar-h la-bckg-darken-3 -flex1 -positionrelative -widthfull -height1 -overflowhidden ${$$props.clipPath ?? ""}`), set_class(input, `la-bar-h-progress__input -widthfull -heightfull -positionrelative -textaligncenter 
                    ${$1 ?? ""}`), set_attribute(input, "name", $$props.dataName), set_value(input, $$props.currentValue), set_class(span_1, `la-bar-h-progress__span -lineheight1 -positionabsolute -pointerdisable 
                    ${(get$1(editing) ? "-visibilityhidden" : "") ?? ""}`), set_text(text_1, `${$$props.currentValue ?? ""}/${$$props.maxValue ?? ""}`), set_class(div_3, `la-bar-h-progress la-bar-h-current -positionabsolute -top0 -heightfull 
                ${$2 ?? ""}`), set_attribute(div_3, "style", `--la-percent:${$$props.currentValue / $$props.maxValue * 100}%`);
    },
    [
      () => {
        var _a;
        return (_a = $$props.textStyle) == null ? void 0 : _a.join(" ");
      },
      () => {
        var _a;
        return get$1(editing) ? (_a = $$props.textStyle) == null ? void 0 : _a.join(" ") : "la-text-transparent";
      },
      () => {
        var _a, _b;
        return get$1(editing) && $$props.barEditStyle ? `${(_a = $$props.barEditStyle) == null ? void 0 : _a.join(" ")} -pulse-bckg-prmy -fast` : (_b = $$props.barStyle) == null ? void 0 : _b.join(" ");
      }
    ]
  ), event("focus", input, (event2) => {
    event2.currentTarget.select(), set(editing, !0);
  }), event("blur", input, () => {
    set(editing, !1);
  }), append($$anchor, div), pop();
}
__name(StatusBar, "StatusBar");
delegate(["change"]);
var EditMode = /* @__PURE__ */ ((EditMode2) => (EditMode2[EditMode2.Subtract = 0] = "Subtract", EditMode2[EditMode2.Add = 1] = "Add", EditMode2[EditMode2.Set = 2] = "Set", EditMode2))(EditMode || {}), root_1$u = /* @__PURE__ */ template('<div class="-widthfull -positionrelative"><div><!> <input type="number" class="la-text-text -bold -width3ch -height1"> <!></div> <span> </span></div>'), root_6$n = /* @__PURE__ */ template('<span class="-widthfull"> </span>'), root$W = /* @__PURE__ */ template("<div><i></i> <!> <div><!> <span> </span></div> <!></div>");
function StatComboShort($$anchor, $$props) {
  push($$props, !0);
  const renderEditable = /* @__PURE__ */ __name(($$anchor2) => {
    var div = root_1$u(), div_1 = child(div), node = child(div_1);
    GlyphButton(node, {
      style: [
        "la-bckg-secondary -width1",
        "clicker-minus-button input-update"
      ],
      get flowClass() {
        return FlowClass.None;
      },
      tooltipEnabled: !1,
      onClick: handleSubtract,
      children: /* @__PURE__ */ __name(($$anchor3, $$slotProps) => {
        var text$1 = text("-");
        append($$anchor3, text$1);
      }, "children"),
      $$slots: { default: !0 }
    });
    var input = sibling(node, 2);
    set_attribute(input, "data-dtype", "Number");
    var node_1 = sibling(input, 2);
    GlyphButton(node_1, {
      style: [
        "la-bckg-secondary -width1",
        "clicker-plus-button input-update"
      ],
      get flowClass() {
        return FlowClass.None;
      },
      tooltipEnabled: !1,
      onClick: handleAddition,
      children: /* @__PURE__ */ __name(($$anchor3, $$slotProps) => {
        var text_1 = text("+");
        append($$anchor3, text_1);
      }, "children"),
      $$slots: { default: !0 }
    });
    var span = sibling(div_1, 2), text_2 = child(span);
    template_effect(() => {
      set_class(div_1, `la-combine-h ${($$props.editable ? "" : "-displaynone") ?? ""}`), set_attribute(input, "name", $$props.valuePath), set_value(input, $$props.value), set_class(span, `-widthfull ${($$props.editable ? "-displaynone" : "") ?? ""}`), set_text(text_2, $$props.value);
    }), event("focus", input, (event2) => event2.currentTarget.select()), append($$anchor2, div);
  }, "renderEditable"), tip = $$props.tooltip ? TooltipFactory.buildTooltip($$props.tooltip, $$props.tooltipHeader) : void 0;
  function handleSubtract(event2) {
    $$props.onPointerClick && $$props.valuePath && $$props.onPointerClick(event2, $$props.value, $$props.valuePath, EditMode.Subtract);
  }
  __name(handleSubtract, "handleSubtract");
  function handleAddition(event2) {
    $$props.onPointerClick && $$props.valuePath && $$props.onPointerClick(event2, $$props.value, $$props.valuePath, EditMode.Add);
  }
  __name(handleAddition, "handleAddition");
  var div_2 = root$W(), i2 = child(div_2), node_2 = sibling(i2, 2);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment = comment(), node_3 = first_child(fragment);
      snippet(node_3, () => $$props.contentLeft), append($$anchor2, fragment);
    }, "consequent");
    if_block(node_2, ($$render) => {
      $$props.contentLeft && $$render(consequent);
    });
  }
  var div_3 = sibling(node_2, 2), node_4 = child(div_3);
  {
    var consequent_1 = /* @__PURE__ */ __name(($$anchor2) => {
      renderEditable($$anchor2);
    }, "consequent_1"), alternate = /* @__PURE__ */ __name(($$anchor2) => {
      var span_1 = root_6$n(), text_3 = child(span_1);
      template_effect(() => set_text(text_3, $$props.value)), append($$anchor2, span_1);
    }, "alternate");
    if_block(node_4, ($$render) => {
      $$props.valuePath != null && $$props.value != null && $$props.editable != null ? $$render(consequent_1) : $$render(alternate, !1);
    });
  }
  var span_2 = sibling(node_4, 2), text_4 = child(span_2), node_5 = sibling(div_3, 2);
  {
    var consequent_2 = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment_2 = comment(), node_6 = first_child(fragment_2);
      snippet(node_6, () => $$props.contentRight), append($$anchor2, fragment_2);
    }, "consequent_2");
    if_block(node_5, ($$render) => {
      $$props.contentRight && $$render(consequent_2);
    });
  }
  template_effect(
    ($0, $1) => {
      set_class(div_2, `la-shortstat la-combine-h ${$0 ?? ""}`), set_class(i2, $$props.icon), set_class(div_3, `la-combine-v ${$1 ?? ""}`), set_attribute(div_3, "data-tooltip", $$props.tooltipEnabled && !$$props.editable ? tip : void 0), set_attribute(div_3, "data-tooltip-class", `${$$props.tooltipClass || "clipped-bot la-tooltip"} ${$$props.tooltipTheme}`), set_attribute(div_3, "data-tooltip-direction", $$props.tooltipDirection ? $$props.tooltipDirection : "RIGHT"), set_text(text_4, $$props.label);
    },
    [
      () => {
        var _a;
        return (_a = $$props.outerStyle) == null ? void 0 : _a.join(" ");
      },
      () => {
        var _a;
        return (_a = $$props.innerStyle) == null ? void 0 : _a.join(" ");
      }
    ]
  ), append($$anchor, div_2), pop();
}
__name(StatComboShort, "StatComboShort");
var root$V = /* @__PURE__ */ template('<input name="system.core_energy" class="core-power-toggle mdi mdi-battery-outline la-text-repcap -fontsize6" type="checkbox" data-dtype="Boolean" data-tooltip-direction="RIGHT">');
function CoreAvailability($$anchor, $$props) {
  push($$props, !0);
  const system = prop($$props, "system"), tip = TooltipFactory.buildTooltip(getLocalized("LA.mech.core.available.tooltip"));
  var input = root$V();
  template_effect(() => {
    set_attribute(input, "data-tooltip", $$props.tooltipEnabled ? tip : void 0), set_attribute(input, "data-tooltip-class", `${$$props.tooltipClass || "clipped-bot la-tooltip"} ${$$props.tooltipTheme}`);
  }), event("pointerenter", input, (event2) => sendToLog(event2, getLocalized("LA.mech.core.available.tooltip"), TextLogHook.MechHeader)), event("pointerleave", input, (event2) => resetLog(event2, TextLogHook.MechHeaderReset)), bind_checked(input, () => system().core_energy, ($$value) => system().core_energy = $$value), append($$anchor, input), pop();
}
__name(CoreAvailability, "CoreAvailability");
const _FlowBase = class _FlowBase {
  constructor() {
    const constructor = this.constructor;
    if (_FlowBase.instances.has(constructor))
      throw new Error("Lancer Alternative Sheets: Use getInstance() to access the instance.");
    _FlowBase.instances.set(constructor, this);
  }
  static getInstance() {
    return _FlowBase.instances.has(this) || _FlowBase.instances.set(this, new this()), _FlowBase.instances.get(this);
  }
};
__name(_FlowBase, "FlowBase"), __publicField(_FlowBase, "instances", /* @__PURE__ */ new Map());
let FlowBase = _FlowBase;
const _RunMacroBase = class _RunMacroBase extends FlowBase {
  constructor() {
    super();
  }
  setupFlow() {
    var _a;
    return _a = class extends game.lancer.Flow {
      constructor(uuid, data) {
        super(uuid, data);
      }
    }, __name(_a, "RunMacro"), __publicField(_a, "steps", ["runMacroStep"]), _a;
  }
  setupFlowSteps() {
    return [
      this.runMacroStep
    ];
  }
  /**
   * Starts the flow by creating an instance of the `SendUnknownToChat` class and beginning the flow.
   *
   * @param {string} uuid - All flows require a UUID, though not all will make use of it. The matching item will be included in the data when sent.
   * @param {any} data - The data to pass to the flow
   */
  startFlow(uuid, data) {
    const flows = game.lancer.flows;
    new (flows.get(CustomFlowClass.RunMacro))(
      uuid,
      data
    ).begin();
  }
  async runMacroStep(state2) {
    var _a;
    return (_a = state2.data) != null && _a.uuid ? (fromUuid(state2.data.uuid).then((item) => {
      item.execute();
    }), !0) : (Logger.error(`Missing UUID passed to ${this.runMacroStep.name}.`), !1);
  }
};
__name(_RunMacroBase, "RunMacroBase");
let RunMacroBase = _RunMacroBase;
const _STYLE$4 = "clipped-bot-alt la-bckg-secondary";
var on_click$6 = /* @__PURE__ */ __name((event2, $$props) => $$props.onClick && $$props.onClick(event2), "on_click$6"), root$U = /* @__PURE__ */ template('<button type="button"><!></button>');
function FlowButton($$anchor, $$props) {
  push($$props, !0);
  const tip = TooltipFactory.buildTooltip($$props.tooltip || getLocalized("LA.flow.tooltip"), $$props.tooltipHeader), logging = $$props.logType && $$props.logTypeReset, log = $$props.logText || getLocalized("LA.flow.tooltip");
  var button = root$U();
  button.__click = [on_click$6, $$props];
  var node = child(button);
  const expression = /* @__PURE__ */ derived(randomExtension), expression_1 = /* @__PURE__ */ derived(() => $$props.textStyle || [FLOW_BUTTON_STYLE]);
  TerminalText(node, {
    get text() {
      return $$props.text;
    },
    get extensionText() {
      return get$1(expression);
    },
    get textStyle() {
      return get$1(expression_1);
    },
    get disableCmdline() {
      return $$props.disableCmdline;
    },
    get disableExtension() {
      return $$props.disableExtension;
    },
    get disableCursor() {
      return $$props.disableCursor;
    }
  }), template_effect(
    ($0) => {
      set_class(button, `-upper
        ${$$props.disableSlide || "la-flow"} 
        ${$0 ?? ""} 
        ${$$props.flowClass || ""}`), set_attribute(button, "data-uuid", $$props.uuid), set_attribute(button, "data-flow-type", $$props.flowType), set_attribute(button, "data-flow-args", $$props.flowArgs), set_attribute(button, "data-path", $$props.path), set_attribute(button, "data-tooltip", $$props.tooltipEnabled ? tip : void 0), set_attribute(button, "data-tooltip-class", `${$$props.tooltipClass || "clipped-bot la-tooltip"} ${$$props.tooltipTheme}`), set_attribute(button, "data-tooltip-direction", $$props.tooltipDirection || "RIGHT"), set_attribute(button, "aria-label", $$props.text);
    },
    [() => {
      var _a;
      return ((_a = $$props.style) == null ? void 0 : _a.join(" ")) || _STYLE$4;
    }]
  ), event("pointerenter", button, function(...$$args) {
    var _a;
    (_a = logging ? (event2) => sendToLog(event2, log, $$props.logType) : void 0) == null || _a.apply(this, $$args);
  }), event("pointerleave", button, function(...$$args) {
    var _a;
    (_a = logging ? (event2) => resetLog(event2, $$props.logTypeReset) : void 0) == null || _a.apply(this, $$args);
  }), append($$anchor, button), pop();
}
__name(FlowButton, "FlowButton");
delegate(["click"]);
const _ButtonFactory = class _ButtonFactory {
  /**
   * Builds and mounts a button onto the specified target element.
   *
   * @param target - The HTML element where the button will be mounted.
   * @param ownerUUID - The UUID of the actor that owns the button.
   * @param build - An optional parameter that determines the type of button to build.
   *                If provided as a `SystemButton` enum, it configures the button accordingly.
   *                If provided as a string that does not match a `SystemButton` enum, it is assumed to be a macro's UUID.
   */
  static buildFlowButton(target, ownerUUID, build) {
    if (Object.values(SystemButton).includes(build)) {
      const data = this.getSystemButtonData(build);
      this.buildSystemButton(target, ownerUUID, build, data.label, data.tip, data.tipHeader);
    } else
      this.buildMacroButton(target, ownerUUID, build);
  }
  static getSystemButtonData(build) {
    return {
      label: this.getSystemButtonLabel(build),
      tip: this.getSystemButtonTip(build),
      tipHeader: this.getSystemButtonTipHeader(build)
    };
  }
  static getSystemButtonLabel(build) {
    const labels = {
      [SystemButton.Stabilize]: "LA.flow.stabilize.label",
      [SystemButton.Overcharge]: "LA.flow.overcharge.label",
      [SystemButton.BasicAttack]: "LA.flow.rollAttack.label",
      [SystemButton.Damage]: "LA.flow.rollDamage.label",
      [SystemButton.TechAttack]: "LA.flow.rollTechAttack.label",
      [SystemButton.SkillTriggerOther]: "LA.flow.skillOther.label"
    };
    return getLocalized(labels[build] || "LA.placeholder");
  }
  static getSystemButtonTip(build, ownerUUID) {
    if (build === SystemButton.Overcharge && ownerUUID) {
      const actor = fromUuidSync(ownerUUID);
      if (actor && actor.type === "mech")
        return formatString(getLocalized("LA.flow.overcharge.tooltip"), getCurrentOvercharge(actor));
      Logger.error("Actor required to get overcharge sequence for tooltip.");
    }
    const tips = {
      [SystemButton.Stabilize]: "LA.flow.stabilize.tooltip",
      [SystemButton.Overcharge]: "LA.flow.overcharge.tooltip",
      [SystemButton.BasicAttack]: "LA.flow.rollAttack.tooltip",
      [SystemButton.Damage]: "LA.flow.rollDamage.tooltip",
      [SystemButton.TechAttack]: "LA.flow.rollTechAttack.tooltip",
      [SystemButton.SkillTriggerOther]: "LA.flow.skillOther.tooltip"
    };
    return getLocalized(tips[build] || "LA.flow.tooltip");
  }
  static getSystemButtonTipHeader(build) {
    const headers = {
      [SystemButton.Stabilize]: "LA.action.full.label",
      [SystemButton.Overcharge]: "LA.action.overcharge.label",
      [SystemButton.SkillTriggerOther]: "LA.pilot.skillTrigger.label"
    };
    return headers[build] ? getLocalized(headers[build]) : void 0;
  }
  static buildSystemButton(target, ownerUUID, type, label, tip, tipHeader) {
    mount(FlowButton, {
      target,
      props: {
        text: label,
        flowClass: FlowClass.Standard,
        uuid: ownerUUID,
        flowType: type,
        tooltip: tip,
        tooltipHeader: tipHeader,
        logText: tip,
        logType: TextLogHook.MechHeader,
        logTypeReset: TextLogHook.MechHeaderReset
      }
    });
  }
  static buildMacroButton(target, ownerUUID, macroUUID) {
    function onClickHandler(ownerUUID2, macroUUID2) {
      let macroData = {
        uuid: macroUUID2
      };
      RunMacroBase.getInstance().startFlow(ownerUUID2, macroData);
    }
    __name(onClickHandler, "onClickHandler"), fromUuid(macroUUID).then((item) => {
      mount(FlowButton, {
        target,
        props: {
          text: (item == null ? void 0 : item.name) || getLocalized("LA.placeholder"),
          flowClass: CustomFlowClass.RunMacro,
          onClick: /* @__PURE__ */ __name(() => onClickHandler(ownerUUID, macroUUID), "onClick"),
          logType: TextLogHook.MechHeader,
          logTypeReset: TextLogHook.MechHeaderReset
        }
      });
    });
  }
};
__name(_ButtonFactory, "ButtonFactory");
let ButtonFactory = _ButtonFactory;
const _SkillTriggerOtherBase = class _SkillTriggerOtherBase extends FlowBase {
  constructor() {
    super();
  }
  setupFlow() {
    var _a;
    return _a = class extends game.lancer.Flow {
      constructor(uuid, _data) {
        super(uuid, {
          title: getLocalized("LA.pilot.skillTrigger.label"),
          roll_str: "1d20",
          acc_diff: {}
          // TODO: the complexity of the AccDiffHudData class is the reason why we can't use the 'showStatRollHUD' flow step
        });
      }
    }, __name(_a, "SkillTriggerOther"), __publicField(_a, "steps", ["rollCheck", "printStatRollCard"]), _a;
  }
  setupFlowSteps() {
    return [];
  }
  /**
   * Starts the flow by creating an instance of the `SkillTriggerOther` class and beginning the flow.
   *
   * @param {string} uuid - All flows require a UUID, though not all will make use of it. The matching item will be included in the data when sent.
   * @param {any} data - The data to pass to the flow
   */
  startFlow(uuid, data) {
    const flows = game.lancer.flows;
    new (flows.get(CustomFlowClass.SkillTriggerOther))(
      uuid,
      data
    ).begin();
  }
};
__name(_SkillTriggerOtherBase, "SkillTriggerOtherBase");
let SkillTriggerOtherBase = _SkillTriggerOtherBase;
var LADataType = /* @__PURE__ */ ((LADataType2) => (LADataType2.Sorting = "LASort", LADataType2))(LADataType || {});
function handleOnDelete(event2, $$props) {
  var _a;
  event2.stopPropagation(), (_a = $$props.onDelete) == null || _a.call($$props, event2);
}
__name(handleOnDelete, "handleOnDelete");
var root_2$m = /* @__PURE__ */ template('<i style="z-index: 1;"></i>'), root_4$b = /* @__PURE__ */ template('<button type="button"></button>'), root_1$t = /* @__PURE__ */ template('<div role="mark"><!> <!> <!></div>');
function DragDropHandle($$anchor, $$props) {
  push($$props, !0);
  let component = state(null);
  const deleteTip = TooltipFactory.buildTooltip(getLocalized("LA.delete.tooltip")), logging = $$props.logType && $$props.logTypeReset;
  function handleDragStart(event2) {
    var _a, _b;
    try {
      const jsonData = JSON.stringify($$props.data);
      (_a = event2.dataTransfer) == null || _a.setData("text/plain", jsonData), (_b = $$props.onDragStart) == null || _b.call($$props, event2, $$props.data);
    } catch (error) {
      Logger.error("Failed to handle drag start", error);
    }
  }
  __name(handleDragStart, "handleDragStart");
  function handleDrop(event2) {
    var _a, _b, _c;
    event2.preventDefault();
    const dropData = (_a = event2.dataTransfer) == null ? void 0 : _a.getData("text/plain");
    if (dropData)
      try {
        const obj = JSON.parse(dropData);
        if (obj.index !== $$props.index) {
          const eventTarget = event2.target;
          get$1(component) && eventTarget && $$props.root && $$props.root.contains(get$1(component)) && $$props.root.contains(eventTarget) ? (_b = $$props.onDrop) == null || _b.call($$props, event2, obj, $$props.data) : (_c = $$props.onDropError) == null || _c.call($$props, event2, obj);
        }
      } catch (error) {
        Logger.error("Failed to parse drop data", error);
      }
  }
  __name(handleDrop, "handleDrop");
  var div = root_1$t(), node = child(div);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var i2 = root_2$m();
      template_effect(
        ($0, $1) => {
          set_class(i2, `fas fa-grip-lines -positionabsolute -left0 -pointergrab la-prmy-primary -glow-prmy-hover ${$0 ?? ""}`), set_attribute(i2, "aria-label", $1);
        },
        [
          () => {
            var _a;
            return (_a = $$props.iconStyle) == null ? void 0 : _a.join(" ");
          },
          () => getLocalized("LA.advanced.reorderMacro.tooltip")
        ]
      ), event("pointerenter", i2, function(...$$args) {
        var _a;
        (_a = logging ? (event2) => sendToLog(event2, getLocalized("LA.advanced.reorderMacro.tooltip"), $$props.logType) : void 0) == null || _a.apply(this, $$args);
      }), event("pointerleave", i2, function(...$$args) {
        var _a;
        (_a = logging ? (event2) => resetLog(event2, $$props.logTypeReset) : void 0) == null || _a.apply(this, $$args);
      }), append($$anchor2, i2);
    }, "consequent");
    if_block(node, ($$render) => {
      $$props.disabled || $$render(consequent);
    });
  }
  var node_1 = sibling(node, 2);
  {
    var consequent_1 = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment = comment(), node_2 = first_child(fragment);
      snippet(node_2, () => $$props.children), append($$anchor2, fragment);
    }, "consequent_1");
    if_block(node_1, ($$render) => {
      $$props.children && $$render(consequent_1);
    });
  }
  var node_3 = sibling(node_1, 2);
  {
    var consequent_2 = /* @__PURE__ */ __name(($$anchor2) => {
      var button = root_4$b();
      button.__click = [handleOnDelete, $$props], set_attribute(button, "data-tooltip", deleteTip), template_effect(
        ($0, $1) => {
          set_class(button, `fas fa-delete-left -positionabsolute -right0 la-prmy-primary -glow-prmy-hover ${$0 ?? ""}`), set_attribute(button, "data-tooltip-class", `${$$props.tooltipClass || "clipped-bot la-tooltip"} ${$$props.tooltipTheme}`), set_attribute(button, "data-tooltip-direction", $$props.tooltipDirection || TooltipDirection.RIGHT), set_attribute(button, "aria-label", $1);
        },
        [
          () => {
            var _a;
            return (_a = $$props.iconStyle) == null ? void 0 : _a.join(" ");
          },
          () => getLocalized("LA.delete.tooltip")
        ]
      ), event("pointerenter", button, function(...$$args) {
        var _a;
        (_a = logging ? (event2) => sendToLog(event2, getLocalized("LA.delete.tooltip"), $$props.logType) : void 0) == null || _a.apply(this, $$args);
      }), event("pointerleave", button, function(...$$args) {
        var _a;
        (_a = logging ? (event2) => resetLog(event2, $$props.logTypeReset) : void 0) == null || _a.apply(this, $$args);
      }), append($$anchor2, button);
    }, "consequent_2");
    if_block(node_3, ($$render) => {
      !$$props.disabled && !$$props.deleteDisabled && $$render(consequent_2);
    });
  }
  bind_this(div, ($$value) => set(component, $$value), () => get$1(component)), template_effect(
    ($0) => {
      set_class(div, `la-combine-h -widthfull -aligncenter -positionrelative
        ${$0 ?? ""}`), set_attribute(div, "draggable", !$$props.disabled);
    },
    [() => {
      var _a;
      return (_a = $$props.style) == null ? void 0 : _a.join(" ");
    }]
  ), event("dragstart", div, handleDragStart), event("drop", div, handleDrop), append($$anchor, div), pop();
}
__name(DragDropHandle, "DragDropHandle");
delegate(["click"]);
var root$T = /* @__PURE__ */ template('<div class="la-skilltrigger la-combine-h -justifyend"><!> <span class="la-skilltrigger__span -bordersround-rtb -small la-brdr-secondary la-bckg-darken-2"><div class="la-skilltrigger__inner -bordersround-rtb -small la-brdr-darken-2 la-text-text -fontsize2 -textaligncenter -overflowhidden -height3"><!></div></span></div>');
function SkillTriggerButton($$anchor, $$props) {
  push($$props, !0);
  var div = root$T(), node = child(div);
  const expression = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.skillTrigger.label"));
  FlowButton(node, {
    get text() {
      return $$props.item.name;
    },
    get flowClass() {
      return FlowClass.Skill;
    },
    get uuid() {
      return $$props.item.uuid;
    },
    get tooltipEnabled() {
      return $$props.tooltipEnabled;
    },
    get tooltipTheme() {
      return $$props.tooltipTheme;
    },
    get tooltipHeader() {
      return get$1(expression);
    },
    get tooltip() {
      return $$props.item.system.description;
    },
    get logText() {
      return $$props.item.system.description;
    },
    get logType() {
      return $$props.logType;
    },
    get logTypeReset() {
      return $$props.logTypeReset;
    }
  });
  var span = sibling(node, 2), div_1 = child(span), node_1 = child(div_1);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var text$1 = text();
      template_effect(() => set_text(text$1, $$props.item.system.curr_rank > 0 ? `+${$$props.item.system.curr_rank * 2}` : `${$$props.item.system.curr_rank * 2}`)), append($$anchor2, text$1);
    }, "consequent"), alternate = /* @__PURE__ */ __name(($$anchor2) => {
      var text_1 = text("0");
      append($$anchor2, text_1);
    }, "alternate");
    if_block(node_1, ($$render) => {
      $$props.item.system.curr_rank !== 0 ? $$render(consequent) : $$render(alternate, !1);
    });
  }
  append($$anchor, div), pop();
}
__name(SkillTriggerButton, "SkillTriggerButton");
var root_2$l = /* @__PURE__ */ template('<div class="la-combine-h -justifybetween -widthfull -upper -fontsize0 -letterspacing0 -padding0-lr"><i class="mdi mdi-arrow-down-left"></i> <span> </span> <i class="mdi mdi-arrow-down-right"></i></div>'), root_3$v = /* @__PURE__ */ template('<span class="la-prmy-transparent -fontsize0">&nbsp;</span>'), root_10$d = /* @__PURE__ */ template('<div class="la-skilltrigger la-combine-h -justifyend"><!> <span class="la-skilltrigger__span -bordersround-rtb -small la-brdr-secondary la-bckg-darken-2"><div class="la-skilltrigger__inner -bordersround-rtb -small la-brdr-darken-2 la-text-text -fontsize2 -textaligncenter -overflowhidden -height3">0</div></span></div>'), root_14$2 = /* @__PURE__ */ template('<span class="la-name__span -fontsize2"> </span>'), root_15$4 = /* @__PURE__ */ template('<i class="la-icon mdi mdi-card-off-outline -fontsize2 -margin1-lr"></i> <span class="la-name__span -fontsize2"> </span>', 1), root_13$2 = /* @__PURE__ */ template('<details class="la-details -widthfull la-combine-v"><summary class="la-details__summary la-combine-h clipped-bot-alt la-bckg-repcap la-text-header -padding1-l -widthfull"><div class="la-left la-combine-h"><!></div></summary></details>'), root$S = /* @__PURE__ */ template(`<div><!> <div class="la-macroflows la-dropshadow la-combine-v -widthfull
        macro-droppable"><!></div></div>`);
function MacroDropBox($$anchor, $$props) {
  push($$props, !0);
  let component = state(null), executables = proxy($$props.getExes);
  const systemTypes = Object.values(SystemButton), tipMain = TooltipFactory.buildTooltip(getLocalized("LA.advanced.addMacro.tooltip.0"), $$props.tooltipHeader), tipAlt = TooltipFactory.buildTooltip(getLocalized("LA.advanced.addMacro.tooltip.1"), $$props.tooltipHeader), logging = $$props.logType && $$props.logTypeReset, logMain = getLocalized("LA.advanced.addMacro.tooltip.0"), logAlt = getLocalized("LA.advanced.addMacro.tooltip.1"), log = $$props.allowDrop ? logAlt : logMain;
  onMount(() => {
    get$1(component) && macroDropHandler.bind(get$1(component));
  });
  function isSystemFlow(item) {
    return systemTypes.includes(item);
  }
  __name(isSystemFlow, "isSystemFlow");
  function isSkillTrigger(item) {
    var _a;
    return ((_a = fromUuidSync(item)) == null ? void 0 : _a.type) === "skill";
  }
  __name(isSkillTrigger, "isSkillTrigger");
  function handleFlowDrop(_event, dropData, thisData) {
    if (dropData.type === LADataType.Sorting) {
      const [movedItem] = executables.splice(dropData.index, 1);
      executables.splice(thisData.index, 0, movedItem), $$props.setExes($$props.uuid, executables);
    }
  }
  __name(handleFlowDrop, "handleFlowDrop");
  function buildFlowData(_button, index2) {
    return { type: LADataType.Sorting, index: index2 };
  }
  __name(buildFlowData, "buildFlowData");
  function handleDelete(event2, index2) {
    event2.stopPropagation(), executables.splice(index2, 1), $$props.setExes($$props.uuid, executables);
  }
  __name(handleDelete, "handleDelete");
  const macroDropHandler = new DragDrop({
    dropSelector: ".macro-droppable",
    callbacks: {
      drop: /* @__PURE__ */ __name((event2) => handleMacroDocumentDrop(event2), "drop")
    }
  });
  function handleMacroDocumentDrop(event2) {
    var _a;
    if (!$$props.allowDrop) return;
    const data = (_a = event2.dataTransfer) == null ? void 0 : _a.getData("text/plain");
    if (!data) return;
    const obj = JSON.parse(data);
    switch (obj.type) {
      case "Macro":
        executables.push(obj.uuid), $$props.setExes($$props.uuid, executables);
        break;
      case LADataType.Sorting:
        break;
      default:
        Logger.log("Unsupported drop type", obj);
    }
  }
  __name(handleMacroDocumentDrop, "handleMacroDocumentDrop");
  var div = root$S(), node = child(div);
  {
    var consequent_1 = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment = comment(), node_1 = first_child(fragment);
      {
        var consequent = /* @__PURE__ */ __name(($$anchor3) => {
          var div_1 = root_2$l(), span = sibling(child(div_1), 2), text2 = child(span);
          template_effect(($0) => set_text(text2, $0), [
            () => getLocalized("LA.advanced.addMacro.hint")
          ]), event("pointerenter", div_1, function(...$$args) {
            var _a;
            (_a = logging ? (event2) => sendToLog(event2, log, $$props.logType) : void 0) == null || _a.apply(this, $$args);
          }), event("pointerleave", div_1, function(...$$args) {
            var _a;
            (_a = logging ? (event2) => resetLog(event2, $$props.logTypeReset) : void 0) == null || _a.apply(this, $$args);
          }), append($$anchor3, div_1);
        }, "consequent"), alternate = /* @__PURE__ */ __name(($$anchor3) => {
          var span_1 = root_3$v();
          append($$anchor3, span_1);
        }, "alternate");
        if_block(node_1, ($$render) => {
          $$props.allowDrop ? $$render(consequent) : $$render(alternate, !1);
        });
      }
      append($$anchor2, fragment);
    }, "consequent_1");
    if_block(node, ($$render) => {
      $$props.hintDropArea && $$render(consequent_1);
    });
  }
  var div_2 = sibling(node, 2), node_2 = child(div_2);
  {
    var consequent_5 = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment_1 = comment(), node_3 = first_child(fragment_1);
      each(node_3, 17, () => executables, index, ($$anchor3, type, index2) => {
        const expression = /* @__PURE__ */ derived(() => buildFlowData(get$1(type), index2)), expression_1 = /* @__PURE__ */ derived(() => [
          "-fontsize2",
          "-padding1-lr",
          ...$$props.iconStyle || []
        ]), expression_2 = /* @__PURE__ */ derived(() => !$$props.allowDrop), expression_3 = /* @__PURE__ */ derived(() => isSystemFlow(get$1(type)) || isSkillTrigger(get$1(type)));
        DragDropHandle($$anchor3, {
          index: index2,
          get root() {
            return get$1(component);
          },
          get data() {
            return get$1(expression);
          },
          style: ["-justifyend"],
          get iconStyle() {
            return get$1(expression_1);
          },
          onDrop: handleFlowDrop,
          onDelete: /* @__PURE__ */ __name((event2) => handleDelete(event2, index2), "onDelete"),
          get disabled() {
            return get$1(expression_2);
          },
          get deleteDisabled() {
            return get$1(expression_3);
          },
          get logType() {
            return $$props.logType;
          },
          get logTypeReset() {
            return $$props.logTypeReset;
          },
          children: /* @__PURE__ */ __name(($$anchor4, $$slotProps) => {
            var fragment_3 = comment(), node_4 = first_child(fragment_3);
            {
              var consequent_2 = /* @__PURE__ */ __name(($$anchor5) => {
                const expression_4 = /* @__PURE__ */ derived(() => fromUuidSync(get$1(type))), expression_5 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.uuid));
                SkillTriggerButton($$anchor5, {
                  get item() {
                    return get$1(expression_4);
                  },
                  get tooltipEnabled() {
                    return $$props.tooltipEnabled;
                  },
                  get tooltipTheme() {
                    return get$1(expression_5);
                  },
                  get tooltipHeader() {
                    return $$props.tooltipHeader;
                  },
                  get logType() {
                    return $$props.logType;
                  },
                  get logTypeReset() {
                    return $$props.logTypeReset;
                  }
                });
              }, "consequent_2"), alternate_3 = /* @__PURE__ */ __name(($$anchor5) => {
                var fragment_5 = comment(), node_5 = first_child(fragment_5);
                {
                  var consequent_4 = /* @__PURE__ */ __name(($$anchor6) => {
                    var fragment_6 = comment(), node_6 = first_child(fragment_6);
                    {
                      var consequent_3 = /* @__PURE__ */ __name(($$anchor7) => {
                        var div_3 = root_10$d(), node_7 = child(div_3);
                        const expression_6 = /* @__PURE__ */ derived(() => ButtonFactory.getSystemButtonLabel(get$1(type))), expression_7 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.uuid)), expression_8 = /* @__PURE__ */ derived(() => ButtonFactory.getSystemButtonTipHeader(get$1(type))), expression_9 = /* @__PURE__ */ derived(() => ButtonFactory.getSystemButtonTip(get$1(type), $$props.uuid)), expression_10 = /* @__PURE__ */ derived(() => ButtonFactory.getSystemButtonTip(get$1(type), $$props.uuid));
                        FlowButton(node_7, {
                          get text() {
                            return get$1(expression_6);
                          },
                          get flowClass() {
                            return FlowClass.None;
                          },
                          get uuid() {
                            return $$props.uuid;
                          },
                          get tooltipEnabled() {
                            return $$props.tooltipEnabled;
                          },
                          get tooltipTheme() {
                            return get$1(expression_7);
                          },
                          get tooltipHeader() {
                            return get$1(expression_8);
                          },
                          get tooltip() {
                            return get$1(expression_9);
                          },
                          get logText() {
                            return get$1(expression_10);
                          },
                          get logType() {
                            return $$props.logType;
                          },
                          get logTypeReset() {
                            return $$props.logTypeReset;
                          },
                          onClick: /* @__PURE__ */ __name((event2) => {
                            event2.stopPropagation(), SkillTriggerOtherBase.getInstance().startFlow($$props.uuid, {});
                          }, "onClick")
                        }), append($$anchor7, div_3);
                      }, "consequent_3"), alternate_1 = /* @__PURE__ */ __name(($$anchor7) => {
                        const expression_11 = /* @__PURE__ */ derived(() => ButtonFactory.getSystemButtonLabel(get$1(type))), expression_12 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.uuid)), expression_13 = /* @__PURE__ */ derived(() => ButtonFactory.getSystemButtonTipHeader(get$1(type))), expression_14 = /* @__PURE__ */ derived(() => ButtonFactory.getSystemButtonTip(get$1(type), $$props.uuid)), expression_15 = /* @__PURE__ */ derived(() => ButtonFactory.getSystemButtonTip(get$1(type), $$props.uuid));
                        FlowButton($$anchor7, {
                          get text() {
                            return get$1(expression_11);
                          },
                          get flowClass() {
                            return FlowClass.Standard;
                          },
                          get uuid() {
                            return $$props.uuid;
                          },
                          get flowType() {
                            return get$1(type);
                          },
                          get tooltipEnabled() {
                            return $$props.tooltipEnabled;
                          },
                          get tooltipTheme() {
                            return get$1(expression_12);
                          },
                          get tooltipHeader() {
                            return get$1(expression_13);
                          },
                          get tooltip() {
                            return get$1(expression_14);
                          },
                          get logText() {
                            return get$1(expression_15);
                          },
                          get logType() {
                            return $$props.logType;
                          },
                          get logTypeReset() {
                            return $$props.logTypeReset;
                          }
                        });
                      }, "alternate_1");
                      if_block(node_6, ($$render) => {
                        get$1(type) === SystemButton.SkillTriggerOther ? $$render(consequent_3) : $$render(alternate_1, !1);
                      });
                    }
                    append($$anchor6, fragment_6);
                  }, "consequent_4"), alternate_2 = /* @__PURE__ */ __name(($$anchor6) => {
                    const expression_16 = /* @__PURE__ */ derived(() => [
                      "-padding1-r",
                      "-padding0-tb",
                      "-height3",
                      "-letterspacing0",
                      "la-text-header",
                      "la-prmy-header",
                      ...$$props.buttonStyle || []
                    ]), expression_17 = /* @__PURE__ */ derived(() => {
                      var _a;
                      return ((_a = fromUuidSync(get$1(type))) == null ? void 0 : _a.name) || getLocalized("LA.placeholder");
                    }), expression_18 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.uuid));
                    FlowButton($$anchor6, {
                      get textStyle() {
                        return get$1(expression_16);
                      },
                      get text() {
                        return get$1(expression_17);
                      },
                      get flowClass() {
                        return CustomFlowClass.RunMacro;
                      },
                      onClick: /* @__PURE__ */ __name((event2) => {
                        event2.stopPropagation(), RunMacroBase.getInstance().startFlow($$props.uuid, { uuid: get$1(type) });
                      }, "onClick"),
                      get tooltipEnabled() {
                        return $$props.tooltipEnabled;
                      },
                      get tooltipTheme() {
                        return get$1(expression_18);
                      },
                      get logType() {
                        return $$props.logType;
                      },
                      get logTypeReset() {
                        return $$props.logTypeReset;
                      }
                    });
                  }, "alternate_2");
                  if_block(
                    node_5,
                    ($$render) => {
                      isSystemFlow(get$1(type)) ? $$render(consequent_4) : $$render(alternate_2, !1);
                    },
                    !0
                  );
                }
                append($$anchor5, fragment_5);
              }, "alternate_3");
              if_block(node_4, ($$render) => {
                isSkillTrigger(get$1(type)) ? $$render(consequent_2) : $$render(alternate_3, !1);
              });
            }
            append($$anchor4, fragment_3);
          }, "children"),
          $$slots: { default: !0 }
        });
      }), append($$anchor2, fragment_1);
    }, "consequent_5"), alternate_5 = /* @__PURE__ */ __name(($$anchor2) => {
      var details = root_13$2(), summary = child(details), div_4 = child(summary), node_8 = child(div_4);
      {
        var consequent_6 = /* @__PURE__ */ __name(($$anchor3) => {
          var span_2 = root_14$2(), text_1 = child(span_2);
          template_effect(($0) => set_text(text_1, $0), [
            () => getLocalized("LA.advanced.addMacro.subLabel")
          ]), append($$anchor3, span_2);
        }, "consequent_6"), alternate_4 = /* @__PURE__ */ __name(($$anchor3) => {
          var fragment_9 = root_15$4(), span_3 = sibling(first_child(fragment_9), 2), text_2 = child(span_3);
          template_effect(($0) => set_text(text_2, $0), [
            () => getLocalized("LA.advanced.addMacro.label")
          ]), append($$anchor3, fragment_9);
        }, "alternate_4");
        if_block(node_8, ($$render) => {
          $$props.allowDrop ? $$render(consequent_6) : $$render(alternate_4, !1);
        });
      }
      template_effect(
        ($0) => {
          set_attribute(summary, "data-tooltip", $$props.tooltipEnabled ? $$props.allowDrop ? tipAlt : tipMain : void 0), set_attribute(summary, "data-tooltip-class", $0), set_attribute(summary, "data-tooltip-direction", $$props.tooltipDirection || TooltipDirection.UP);
        },
        [
          () => `${$$props.tooltipClass || "clipped-bot la-tooltip"} ${getCSSDocumentTheme($$props.uuid)}`
        ]
      ), event("pointerenter", summary, function(...$$args) {
        var _a;
        (_a = logging ? (event2) => sendToLog(event2, log, $$props.logType) : void 0) == null || _a.apply(this, $$args);
      }), event("pointerleave", summary, function(...$$args) {
        var _a;
        (_a = logging ? (event2) => resetLog(event2, $$props.logTypeReset) : void 0) == null || _a.apply(this, $$args);
      }), append($$anchor2, details);
    }, "alternate_5");
    if_block(node_2, ($$render) => {
      executables.length ? $$render(consequent_5) : $$render(alternate_5, !1);
    });
  }
  bind_this(div_2, ($$value) => set(component, $$value), () => get$1(component)), template_effect(() => set_class(div, `la-combine-v -widthfull ${($$props.hintDropArea ? "-divider la-prmy-accent" : "") ?? ""}`)), append($$anchor, div), pop();
}
__name(MacroDropBox, "MacroDropBox");
var root_1$s = /* @__PURE__ */ template('<video autoplay loop><track kind="captions"> <source></video>', 2), root_2$k = /* @__PURE__ */ template('<button type="button"><img class="la-actor__img"></button>'), root$R = /* @__PURE__ */ template('<div class="la-combine-h"><!></div>');
function ImageVideo($$anchor, $$props) {
  var _a;
  push($$props, !0);
  const actorImgVid = ((_a = $$props.actor.prototypeToken) == null ? void 0 : _a.texture.src) ?? $$props.actor.img, srcImage = actorImgVid === "icons/svg/mystery-man.svg" ? `modules/${id}/assets/nodata.png` : actorImgVid, tokenVideoMimeType = getVideoMimeType(actorImgVid), tip = TooltipFactory.buildTooltip($$props.tooltip || getLocalized("LA.edit.token.tooltip"), $$props.tooltipHeader), tokenErrorTip = TooltipFactory.buildTooltip(getLocalized("LA.edit.token.error")), logging = $$props.logType && $$props.logTypeReset && !$$props.editDisabled, log = $$props.logText || getLocalized("LA.edit.token.tooltip");
  var div = root$R(), node = child(div);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var video = root_1$s();
      video.__click = function(...$$args) {
        var _a2;
        (_a2 = $$props.editDisabled ? void 0 : $$props.onPointerClick) == null || _a2.apply(this, $$args);
      };
      var source2 = sibling(child(video), 2);
      set_attribute(source2, "src", actorImgVid), set_attribute(source2, "type", tokenVideoMimeType), template_effect(() => {
        set_class(video, `la-actor__img ${($$props.editDisabled ? "-pointerdisable" : "-pointercursor") ?? ""}`), set_attribute(video, "data-tooltip", $$props.tooltipEnabled ? $$props.editDisabled ? tokenErrorTip : tip : void 0), set_attribute(video, "data-tooltip-class", `${$$props.tooltipClass || "clipped-bot la-tooltip"} ${$$props.tooltipTheme}`), set_attribute(video, "data-tooltip-direction", $$props.tooltipDirection || TooltipDirection.UP);
      }), event("pointerenter", video, function(...$$args) {
        var _a2;
        (_a2 = logging ? (event2) => sendToLog(event2, log, $$props.logType) : void 0) == null || _a2.apply(this, $$args);
      }), event("pointerleave", video, function(...$$args) {
        var _a2;
        (_a2 = logging ? (event2) => resetLog(event2, $$props.logTypeReset) : void 0) == null || _a2.apply(this, $$args);
      }), append($$anchor2, video);
    }, "consequent"), alternate = /* @__PURE__ */ __name(($$anchor2) => {
      var button = root_2$k();
      button.__click = function(...$$args) {
        var _a2;
        (_a2 = $$props.editDisabled ? void 0 : $$props.onPointerClick) == null || _a2.apply(this, $$args);
      };
      var img = child(button);
      set_attribute(img, "src", srcImage), template_effect(
        ($0) => {
          set_class(button, $$props.editDisabled ? "-pointerblock" : ""), set_attribute(button, "data-tooltip", $$props.tooltipEnabled ? $$props.editDisabled ? tokenErrorTip : tip : void 0), set_attribute(button, "data-tooltip-class", `${$$props.tooltipClass || "clipped-bot la-tooltip"} ${$$props.tooltipTheme}`), set_attribute(button, "data-tooltip-direction", $$props.tooltipDirection || TooltipDirection.UP), set_attribute(img, "alt", $0);
        },
        [() => getLocalized("LA.placeholder")]
      ), event("pointerenter", button, function(...$$args) {
        var _a2;
        (_a2 = logging ? (event2) => sendToLog(event2, log, $$props.logType) : void 0) == null || _a2.apply(this, $$args);
      }), event("pointerleave", button, function(...$$args) {
        var _a2;
        (_a2 = logging ? (event2) => resetLog(event2, $$props.logTypeReset) : void 0) == null || _a2.apply(this, $$args);
      }), append($$anchor2, button);
    }, "alternate");
    if_block(node, ($$render) => {
      tokenVideoMimeType ? $$render(consequent) : $$render(alternate, !1);
    });
  }
  append($$anchor, div), pop();
}
__name(ImageVideo, "ImageVideo");
delegate(["click"]);
var root_1$r = /* @__PURE__ */ template("<i></i>"), root_2$j = /* @__PURE__ */ template("<i></i>"), on_change$5 = /* @__PURE__ */ __name((event2, system) => handleRelativeDataInput(event2, system.overshield.value), "on_change$5"), on_change_1$4 = /* @__PURE__ */ __name((event2, system) => handleRelativeDataInput(event2, system.burn), "on_change_1$4"), root$Q = /* @__PURE__ */ template('<div class="la-framename la-dropshadow -overflowhidden"><div class="la-flow -textalignleft -letterspacing0 la-bckg-primary la-text-header clipped-bot-alt -padding0-tb -height3 -margin5-t -margin1-l"><span class="la-cmdline la-text-header -fadein">>//:</span> <span class="la-extension la-text-header -lower -fadein"> </span><span class="la-cursor la-prmy-header -fadein"></span></div></div> <div class="la-actor la-dropshadow -aligncontentcenter -positionrelative"><div class="la-combine-v -positionabsolute -left0 -top0 -fontsize13"><!> <div class="la-combine-h -fontsize7"><i></i> <span> </span></div> <!></div> <!></div> <div class="la-stats la-dropshadow la-combine-h -justifyevenly"><!> <!> <!></div> <div class="la-damage la-dropshadow -margin0-lr -margin2-tb"><div class="la-combine-h -gap2"><div class="la-visuals -flex5"><!> <div class="la-spacer -tiny"></div> <!></div> <div class="la-combine-v -divider la-prmy-bar-shield -flex0 -width3ch -textaligncenter la-prmy-bar-shield -glow-prmy -margin0-r"><input class="la-damage__input la-shadow -medium -inset la-text-text -width5 -heightfull -bordersround-lrt -small -bordersoff"> <span class="la-damage__span -fontsize0 -heightfull -lineheight1"> </span></div></div> <div class="la-spacer -large"></div> <div class="la-combine-h -gap2"><div class="la-visuals -flex5"><!> <div class="la-spacer -tiny"></div> <!></div> <div class="la-combine-v -divider la-prmy-bar-burn -flex0 -width3ch -textaligncenter la-prmy-bar-burn -glow-prmy -margin0-r"><input class="la-damage__input la-shadow -medium -inset la-text-text -width5 -heightfull -bordersround-lrt -small -bordersoff"> <span class="la-damage__span -fontsize0 -heightfull -lineheight1"> </span></div></div></div> <div class="la-stats la-dropshadow la-combine-h -justifyevenly"><!> <!> <!></div> <div class="la-stats la-dropshadow la-combine-h -justifyevenly -margin1-t"><div class="la-combine-h -alignselfcenter -positionrelative"><!></div> <!></div> <!>', 1);
function Sidebar$1($$anchor, $$props) {
  var _a;
  push($$props, !0);
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { system, actor } = props;
  let advancedOptions = /* @__PURE__ */ derived(() => getAdvancedState(actor.uuid)), component = state(null), editingBurn = state(!1), editingShield = state(!1);
  const themeOverride = getBrightness(getThemeKey(actor.uuid)) === "light" ? "la-text-primary" : "la-text-text", sidebarExes = getSidebarExecutables$2(actor.uuid), frame = (_a = system.loadout.frame) == null ? void 0 : _a.value, frameName = frame ? `${frame.system.manufacturer} ${frame.name}` : getLocalized("LA.placeholder"), frameUUID = frame ? frame.uuid : "", tooltipEnabled = getMechSheetTooltipEnabled(), sizeTip = TooltipFactory.buildTooltip(getLocalized("LA.size.tooltip"), `${getLocalized("LA.size.label")} ${system.size}`), speedTip = TooltipFactory.buildTooltip(getLocalized("LA.speed.tooltip"), `${getLocalized("LA.speed.label")} ${system.speed}`), shieldTip = TooltipFactory.buildTooltip(getLocalized("LA.overshield.tooltip")), burnTip = TooltipFactory.buildTooltip(getLocalized("LA.burn.tooltip")), overchargePlusTip = TooltipFactory.buildTooltip(getLocalized("LA.overcharge.increase.tooltip")), overchargeMinusTip = TooltipFactory.buildTooltip(getLocalized("LA.overcharge.decrease.tooltip"));
  onMount(() => {
    if (get$1(component)) {
      const ratio = getSidebarRatio$1(actor.uuid), sidebar = jQuery(get$1(component)).closest(".la-root").find(".la-sidebar");
      sidebar && sidebar.css("flex", ratio.toString());
    }
  });
  var fragment = root$Q(), div = first_child(fragment), div_1 = child(div);
  set_attribute(div_1, "data-uuid", frameUUID);
  var text2 = sibling(child(div_1));
  text2.nodeValue = ` ${frameName ?? ""} `;
  var span = sibling(text2), text_1 = child(span);
  bind_this(div, ($$value) => set(component, $$value), () => get$1(component));
  var div_2 = sibling(div, 2), div_3 = child(div_2), node = child(div_3);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var i2 = root_1$r();
      set_class(i2, `cci cci-size-half ${themeOverride ?? ""} la-outl-shadow`), set_attribute(i2, "data-tooltip", tooltipEnabled ? sizeTip : void 0), template_effect(
        ($0) => {
          set_attribute(i2, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(i2, "data-tooltip-direction", TooltipDirection.RIGHT);
        },
        [() => getCSSDocumentTheme(actor.uuid)]
      ), append($$anchor2, i2);
    }, "consequent"), alternate = /* @__PURE__ */ __name(($$anchor2) => {
      var i_1 = root_2$j();
      set_attribute(i_1, "data-tooltip", tooltipEnabled ? sizeTip : void 0), template_effect(
        ($0) => {
          set_class(i_1, `cci cci-size-${system.size ?? ""} ${themeOverride ?? ""} la-outl-shadow`), set_attribute(i_1, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(i_1, "data-tooltip-direction", TooltipDirection.RIGHT);
        },
        [() => getCSSDocumentTheme(actor.uuid)]
      ), append($$anchor2, i_1);
    }, "alternate");
    if_block(node, ($$render) => {
      system.size < 1 ? $$render(consequent) : $$render(alternate, !1);
    });
  }
  var div_4 = sibling(node, 2);
  set_attribute(div_4, "data-tooltip", tooltipEnabled ? speedTip : void 0);
  var i_2 = child(div_4);
  set_class(i_2, `mdi mdi-arrow-right-bold-hexagon-outline ${themeOverride ?? ""} la-outl-shadow`);
  var span_1 = sibling(i_2, 2);
  set_class(span_1, `${themeOverride ?? ""} la-outl-shadow -bold`);
  var text_2 = child(span_1), node_1 = sibling(div_4, 2);
  const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid));
  CoreAvailability(node_1, {
    system,
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression);
    }
  });
  var node_2 = sibling(div_3, 2);
  const expression_1 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_2 = /* @__PURE__ */ derived(() => getLocalized("LA.edit.image.token.tooltip")), expression_3 = /* @__PURE__ */ derived(() => getLocalized("LA.edit.image.token.tooltip"));
  ImageVideo(node_2, {
    actor,
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_1);
    },
    get tooltip() {
      return get$1(expression_2);
    },
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    },
    get logText() {
      return get$1(expression_3);
    },
    get logType() {
      return TextLogHook.MechHeader;
    },
    get logTypeReset() {
      return TextLogHook.MechHeaderReset;
    },
    onPointerClick: /* @__PURE__ */ __name((event2) => handleEditToken(event2, actor), "onPointerClick")
  });
  var div_5 = sibling(div_2, 2), node_3 = child(div_5);
  const expression_4 = /* @__PURE__ */ derived(() => getLocalized("LA.armor.short")), expression_5 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_6 = /* @__PURE__ */ derived(() => getLocalized("LA.armor.tooltip"));
  StatComboShort(node_3, {
    icon: "cci cci-role-defender -alignselfcenter",
    get label() {
      return get$1(expression_4);
    },
    get value() {
      return system.armor;
    },
    outerStyle: ["la-text-text", "-fontsize5"],
    innerStyle: [
      "-divider",
      "-fontsize1",
      "la-prmy-accent",
      "-textaligncenter",
      "-bold"
    ],
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_5);
    },
    get tooltip() {
      return get$1(expression_6);
    },
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    }
  });
  var node_4 = sibling(node_3, 2);
  const expression_7 = /* @__PURE__ */ derived(() => getLocalized("LA.evasion.short")), expression_8 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_9 = /* @__PURE__ */ derived(() => getLocalized("LA.evasion.tooltip"));
  StatComboShort(node_4, {
    icon: "cci cci-evasion -alignselfcenter",
    get label() {
      return get$1(expression_7);
    },
    get value() {
      return system.evasion;
    },
    outerStyle: ["la-text-text", "-fontsize5"],
    innerStyle: [
      "-divider",
      "-fontsize1",
      "la-prmy-accent",
      "-textaligncenter",
      "-bold"
    ],
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_8);
    },
    get tooltip() {
      return get$1(expression_9);
    },
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    }
  });
  var node_5 = sibling(node_4, 2);
  const expression_10 = /* @__PURE__ */ derived(() => getLocalized("LA.edefense.short")), expression_11 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_12 = /* @__PURE__ */ derived(() => getLocalized("LA.edefense.tooltip"));
  StatComboShort(node_5, {
    icon: "cci cci-edef -alignselfcenter",
    get label() {
      return get$1(expression_10);
    },
    get value() {
      return system.edef;
    },
    outerStyle: ["la-text-text", "-fontsize5"],
    innerStyle: [
      "-divider",
      "-fontsize1",
      "la-prmy-accent",
      "-textaligncenter",
      "-bold"
    ],
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_11);
    },
    get tooltip() {
      return get$1(expression_12);
    },
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    }
  });
  var div_6 = sibling(div_5, 2), div_7 = child(div_6), div_8 = child(div_7), node_6 = child(div_8);
  const expression_13 = /* @__PURE__ */ derived(() => getLocalized("LA.hitpoint.short")), expression_14 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_15 = /* @__PURE__ */ derived(() => getLocalized("LA.hitpoint.tooltip"));
  StatusBar(node_6, {
    get name() {
      return get$1(expression_13);
    },
    dataName: "system.hp.value",
    get currentValue() {
      return system.hp.value;
    },
    get maxValue() {
      return system.hp.max;
    },
    barStyle: ["la-bckg-bar-health"],
    barEditStyle: ["la-prmy-bar-health"],
    get currentValueSecondary() {
      return system.overshield.value;
    },
    get maxValueSecondary() {
      return system.hp.max;
    },
    barStyleSecondary: ["la-bckg-bar-shield", "-shield"],
    barEditStyleSecondary: ["la-prmy-bar-shield"],
    textStyle: ["la-text-text"],
    clipPath: "clipped",
    get editSecondary() {
      return get$1(editingShield);
    },
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_14);
    },
    get tooltip() {
      return get$1(expression_15);
    },
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    }
  });
  var node_7 = sibling(node_6, 4);
  const expression_16 = /* @__PURE__ */ derived(() => getLocalized("LA.structure.label")), expression_17 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_18 = /* @__PURE__ */ derived(() => getLocalized("LA.structure.tooltip"));
  StatusBar(node_7, {
    get name() {
      return get$1(expression_16);
    },
    dataName: "system.structure.value",
    get currentValue() {
      return system.structure.value;
    },
    get maxValue() {
      return system.structure.max;
    },
    barStyle: ["la-bckg-bar-structure"],
    barEditStyle: ["la-prmy-bar-structure"],
    textStyle: ["la-text-text"],
    clipPath: "clipped-alt",
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_17);
    },
    get tooltip() {
      return get$1(expression_18);
    },
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    }
  });
  var div_9 = sibling(div_8, 2), input = child(div_9);
  set_attribute(input, "type", "number"), set_attribute(input, "name", "system.overshield.value"), set_attribute(input, "data-dtype", "Number"), input.__change = [on_change$5, system];
  var span_2 = sibling(input, 2);
  set_attribute(span_2, "data-tooltip", tooltipEnabled ? shieldTip : void 0);
  var text_3 = child(span_2), div_10 = sibling(div_7, 4), div_11 = child(div_10), node_8 = child(div_11);
  const expression_19 = /* @__PURE__ */ derived(() => getLocalized("LA.heat.label")), expression_20 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_21 = /* @__PURE__ */ derived(() => getLocalized("LA.heat.tooltip"));
  StatusBar(node_8, {
    get name() {
      return get$1(expression_19);
    },
    dataName: "system.heat.value",
    get currentValue() {
      return system.heat.value;
    },
    get maxValue() {
      return system.heat.max;
    },
    barStyle: ["la-bckg-bar-heat"],
    barEditStyle: ["la-prmy-bar-heat"],
    get currentValueSecondary() {
      return system.burn;
    },
    get maxValueSecondary() {
      return system.heat.max;
    },
    barStyleSecondary: ["la-bckg-bar-burn", "-burn"],
    barEditStyleSecondary: ["la-prmy-bar-burn"],
    textStyle: ["la-text-text"],
    clipPath: "clipped",
    get editSecondary() {
      return get$1(editingBurn);
    },
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_20);
    },
    get tooltip() {
      return get$1(expression_21);
    },
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    }
  });
  var node_9 = sibling(node_8, 4);
  const expression_22 = /* @__PURE__ */ derived(() => getLocalized("LA.stress.label")), expression_23 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_24 = /* @__PURE__ */ derived(() => getLocalized("LA.stress.tooltip"));
  StatusBar(node_9, {
    get name() {
      return get$1(expression_22);
    },
    dataName: "system.stress.value",
    get currentValue() {
      return system.stress.value;
    },
    get maxValue() {
      return system.stress.max;
    },
    barStyle: ["la-bckg-bar-stress"],
    barEditStyle: ["la-prmy-bar-stress"],
    textStyle: ["la-text-text"],
    clipPath: "clipped-alt",
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_23);
    },
    get tooltip() {
      return get$1(expression_24);
    },
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    }
  });
  var div_12 = sibling(div_11, 2), input_1 = child(div_12);
  set_attribute(input_1, "type", "number"), set_attribute(input_1, "name", "system.burn"), set_attribute(input_1, "data-dtype", "Number"), input_1.__change = [on_change_1$4, system];
  var span_3 = sibling(input_1, 2);
  set_attribute(span_3, "data-tooltip", tooltipEnabled ? burnTip : void 0);
  var text_4 = child(span_3), div_13 = sibling(div_6, 2), node_10 = child(div_13);
  const expression_25 = /* @__PURE__ */ derived(() => getLocalized("LA.tattack.short")), expression_26 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_27 = /* @__PURE__ */ derived(() => getLocalized("LA.tattack.tooltip"));
  StatComboShort(node_10, {
    icon: "cci cci-tech-full -alignselfcenter",
    get label() {
      return get$1(expression_25);
    },
    get value() {
      return system.tech_attack;
    },
    outerStyle: ["la-text-text", "-fontsize5"],
    innerStyle: [
      "-divider",
      "-fontsize1",
      "la-prmy-accent",
      "-textaligncenter",
      "-bold"
    ],
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_26);
    },
    get tooltip() {
      return get$1(expression_27);
    },
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    }
  });
  var node_11 = sibling(node_10, 2);
  const expression_28 = /* @__PURE__ */ derived(() => getLocalized("LA.save.short")), expression_29 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_30 = /* @__PURE__ */ derived(() => getLocalized("LA.save.tooltip"));
  StatComboShort(node_11, {
    icon: "cci cci-save -alignselfcenter",
    get label() {
      return get$1(expression_28);
    },
    get value() {
      return system.save;
    },
    outerStyle: ["la-text-text", "-fontsize5"],
    innerStyle: [
      "-divider",
      "-fontsize1",
      "la-prmy-accent",
      "-textaligncenter",
      "-bold"
    ],
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_29);
    },
    get tooltip() {
      return get$1(expression_30);
    },
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    }
  });
  var node_12 = sibling(node_11, 2);
  const expression_31 = /* @__PURE__ */ derived(() => getLocalized("LA.sensor.short")), expression_32 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_33 = /* @__PURE__ */ derived(() => getLocalized("LA.sensor.tooltip"));
  StatComboShort(node_12, {
    icon: "cci cci-sensor -alignselfcenter",
    get label() {
      return get$1(expression_31);
    },
    get value() {
      return system.sensor_range;
    },
    outerStyle: ["la-text-text", "-fontsize5"],
    innerStyle: [
      "-divider",
      "-fontsize1",
      "la-prmy-accent",
      "-textaligncenter",
      "-bold"
    ],
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_32);
    },
    get tooltip() {
      return get$1(expression_33);
    },
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    }
  });
  var div_14 = sibling(div_13, 2), div_15 = child(div_14);
  {
    const overchargeContentLeft = /* @__PURE__ */ __name(($$anchor2) => {
      const expression_34 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid));
      GlyphButton($$anchor2, {
        type: "button",
        get flowClass() {
          return FlowClass.None;
        },
        style: [
          "mdi mdi-chevron-left la-text-secondary la-prmy-primary -glow-prmy-hover -fontsize3 -alignselfcenter"
        ],
        tooltip: overchargeMinusTip,
        get tooltipTheme() {
          return get$1(expression_34);
        },
        get tooltipDirection() {
          return TooltipDirection.UP;
        },
        onClick: /* @__PURE__ */ __name((event2) => handleOverchargeDecrease(event2, actor), "onClick")
      });
    }, "overchargeContentLeft"), overchargeContentRight = /* @__PURE__ */ __name(($$anchor2) => {
      const expression_35 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid));
      GlyphButton($$anchor2, {
        type: "button",
        get flowClass() {
          return FlowClass.None;
        },
        style: [
          "mdi mdi-chevron-right la-text-secondary la-prmy-primary -glow-prmy-hover -fontsize3 -alignselfcenter"
        ],
        tooltip: overchargePlusTip,
        get tooltipTheme() {
          return get$1(expression_35);
        },
        get tooltipDirection() {
          return TooltipDirection.UP;
        },
        onClick: /* @__PURE__ */ __name((event2) => handleOverchargeIncrease(event2, actor), "onClick")
      });
    }, "overchargeContentRight");
    var node_13 = child(div_15);
    const expression_36 = /* @__PURE__ */ derived(() => getLocalized("LA.overcharge.short")), expression_37 = /* @__PURE__ */ derived(() => getCurrentOvercharge(actor)), expression_38 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_39 = /* @__PURE__ */ derived(() => getLocalized("LA.overcharge.tooltip"));
    StatComboShort(node_13, {
      icon: "cci cci-overcharge -alignselfcenter -width3",
      get label() {
        return get$1(expression_36);
      },
      get value() {
        return get$1(expression_37);
      },
      outerStyle: ["la-text-text", "-fontsize5"],
      innerStyle: [
        "-divider",
        "-fontsize1",
        "la-prmy-accent",
        "-textaligncenter",
        "-bold"
      ],
      tooltipEnabled,
      get tooltipTheme() {
        return get$1(expression_38);
      },
      get tooltip() {
        return get$1(expression_39);
      },
      get tooltipDirection() {
        return TooltipDirection.RIGHT;
      },
      contentLeft: overchargeContentLeft,
      contentRight: overchargeContentRight
    });
  }
  var node_14 = sibling(div_15, 2);
  const expression_40 = /* @__PURE__ */ derived(() => getLocalized("LA.repair.short")), expression_41 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_42 = /* @__PURE__ */ derived(() => getLocalized("LA.repair.tooltip"));
  StatComboShort(node_14, {
    icon: "cci cci-repair -alignselfcenter",
    get label() {
      return get$1(expression_40);
    },
    get value() {
      return system.repairs.value;
    },
    outerStyle: ["la-text-text", "-fontsize5"],
    innerStyle: [
      "-divider",
      "-fontsize1",
      "la-prmy-accent",
      "-textaligncenter",
      "-bold"
    ],
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_41);
    },
    get tooltip() {
      return get$1(expression_42);
    },
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    }
  });
  var node_15 = sibling(div_14, 2);
  MacroDropBox(node_15, {
    get uuid() {
      return actor.uuid;
    },
    getExes: sidebarExes,
    setExes: setSidebarExecutables$2,
    hintDropArea: !0,
    get allowDrop() {
      return get$1(advancedOptions);
    },
    tooltipEnabled,
    get logType() {
      return TextLogHook.MechHeader;
    },
    get logTypeReset() {
      return TextLogHook.MechHeaderReset;
    }
  }), template_effect(
    ($0, $1, $2, $3) => {
      set_text(text_1, `--${$0 ?? ""}`), set_attribute(div_4, "data-tooltip-class", `clipped-bot la-tooltip ${$1 ?? ""}`), set_attribute(div_4, "data-tooltip-direction", TooltipDirection.RIGHT), set_text(text_2, system.speed), set_value(input, system.overshield.value), set_attribute(span_2, "data-tooltip-class", `clipped-bot la-tooltip ${$1 ?? ""}`), set_attribute(span_2, "data-tooltip-direction", TooltipDirection.RIGHT), set_text(text_3, $2), set_value(input_1, system.burn), set_attribute(span_3, "data-tooltip-class", `clipped-bot la-tooltip ${$1 ?? ""}`), set_attribute(span_3, "data-tooltip-direction", TooltipDirection.RIGHT), set_text(text_4, $3);
    },
    [
      () => getLocalized("LA.scan.label"),
      () => getCSSDocumentTheme(actor.uuid),
      () => getLocalized("LA.overshield.short"),
      () => getLocalized("LA.burn.short")
    ]
  ), event("focus", input, (event2) => {
    event2.currentTarget.select(), set(editingShield, !0);
  }), event("blur", input, () => {
    set(editingShield, !1);
  }), event("focus", input_1, (event2) => {
    event2.currentTarget.select(), set(editingBurn, !0);
  }), event("blur", input_1, () => {
    set(editingBurn, !1);
  }), append($$anchor, fragment), pop();
}
__name(Sidebar$1, "Sidebar$1");
delegate(["change"]);
var ActionLogCollapsePrefix = /* @__PURE__ */ ((ActionLogCollapsePrefix2) => (ActionLogCollapsePrefix2.MechSheet = "mech", ActionLogCollapsePrefix2.NPCSheet = "npc", ActionLogCollapsePrefix2.PilotSheet = "pilot", ActionLogCollapsePrefix2.DeployableSheet = "deployable", ActionLogCollapsePrefix2))(ActionLogCollapsePrefix || {});
const _STYLE$3 = "la-prmy-header -glow-prmy la-scdy-primary -glow-scdy-hover -fontsize2";
var root$P = /* @__PURE__ */ template('<button type="button"><i></i></button>');
function DeleteButton($$anchor, $$props) {
  push($$props, !0);
  const tip = TooltipFactory.buildTooltip(getLocalized("LA.delete.tooltip")), logging = $$props.logType && $$props.logTypeReset, log = $$props.logText || getLocalized("LA.delete.tooltip");
  var button = root$P();
  button.__click = function(...$$args) {
    var _a;
    (_a = $$props.onClick ? (event2) => $$props.onClick(event2) : null) == null || _a.apply(this, $$args);
  };
  var i2 = child(button);
  template_effect(
    ($0, $1, $2) => {
      set_class(button, `la-delete ${$0 ?? ""}`), set_attribute(button, "data-uuid", $$props.uuid), set_attribute(button, "data-tooltip", $$props.tooltipEnabled ? tip : void 0), set_attribute(button, "data-tooltip-class", `${$$props.tooltipClass || "clipped-bot la-tooltip"} ${$$props.tooltipTheme}`), set_attribute(button, "data-tooltip-direction", $$props.tooltipDirection || TooltipDirection.UP), set_attribute(button, "aria-label", $1), set_class(i2, `mdi mdi-close-circle ${$2 ?? ""}`);
    },
    [
      () => {
        var _a;
        return ((_a = $$props.style) == null ? void 0 : _a.join(" ")) || _STYLE$3;
      },
      () => getLocalized("LA.delete.tooltip"),
      () => {
        var _a;
        return (_a = $$props.iconStyle) == null ? void 0 : _a.join(" ");
      }
    ]
  ), event("pointerenter", button, function(...$$args) {
    var _a;
    (_a = logging ? (event2) => sendToLog(event2, log, $$props.logType) : void 0) == null || _a.apply(this, $$args);
  }), event("pointerleave", button, function(...$$args) {
    var _a;
    (_a = logging ? (event2) => resetLog(event2, $$props.logTypeReset) : void 0) == null || _a.apply(this, $$args);
  }), append($$anchor, button), pop();
}
__name(DeleteButton, "DeleteButton");
delegate(["click"]);
const collapseStates = writable({});
function getCollapseState(id2) {
  return id2 ? fromStore(collapseStates).current[id2] : !1;
}
__name(getCollapseState, "getCollapseState");
function setCollapseState(id2, state2) {
  collapseStates.update((states) => (states[id2] = state2, states));
}
__name(setCollapseState, "setCollapseState");
const MAIN_HEADER_STYLE$1 = "la-text-header la-prmy-header clipped-top -padding0-tb -padding3-lr";
var root_1$q = /* @__PURE__ */ template('<div class="la-combine-h -gap2 -aligncenter"><!></div>'), root$O = /* @__PURE__ */ template("<div><h1><!> <!></h1> <div><div><!></div></div></div>");
function HeaderMain($$anchor, $$props) {
  push($$props, !0);
  let isCollapsed = /* @__PURE__ */ derived(() => getCollapseState($$props.collapseID) ?? $$props.startCollapsed ?? !1);
  const extraOptions = !!$$props.headerContent;
  onMount(() => {
    $$props.collapseID && ($$props.dontSaveCollapse ?? getCollapseState($$props.collapseID) === void 0) && setCollapseState($$props.collapseID, $$props.startCollapsed ?? !1);
  });
  function toggleCollapse(event2) {
    event2.stopPropagation(), $$props.collapseID && setCollapseState($$props.collapseID, !get$1(isCollapsed));
  }
  __name(toggleCollapse, "toggleCollapse");
  function getExtensionText() {
    if ($$props.extensionTextFunction && $$props.extensionTextFunction()) return $$props.extensionTextFunction();
    if ($$props.extensionText) return $$props.extensionText;
    if ($$props.collapseID) return get$1(isCollapsed) ? `--${getLocalized("LA.expand.label")}` : `--${getLocalized("LA.collapse.label")}`;
  }
  __name(getExtensionText, "getExtensionText");
  var div = root$O(), h1 = child(div), node = child(h1);
  const expression = /* @__PURE__ */ derived(() => $$props.collapseID || !$$props.extensionText ? `${$$props.text} ` : $$props.text), expression_1 = /* @__PURE__ */ derived(getExtensionText);
  TerminalText(node, {
    get text() {
      return get$1(expression);
    },
    get textStyle() {
      return $$props.textStyle;
    },
    get extensionText() {
      return get$1(expression_1);
    }
  });
  var node_1 = sibling(node, 2);
  {
    var consequent_1 = /* @__PURE__ */ __name(($$anchor2) => {
      var div_1 = root_1$q(), node_2 = child(div_1);
      {
        var consequent = /* @__PURE__ */ __name(($$anchor3) => {
          var fragment = comment(), node_3 = first_child(fragment);
          snippet(node_3, () => $$props.headerContent), append($$anchor3, fragment);
        }, "consequent");
        if_block(node_2, ($$render) => {
          $$props.headerContent && $$render(consequent);
        });
      }
      append($$anchor2, div_1);
    }, "consequent_1");
    if_block(node_1, ($$render) => {
      extraOptions && $$render(consequent_1);
    });
  }
  var div_2 = sibling(h1, 2), div_3 = child(div_2), node_4 = child(div_3);
  {
    var consequent_2 = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment_1 = comment(), node_5 = first_child(fragment_1);
      snippet(node_5, () => $$props.children), append($$anchor2, fragment_1);
    }, "consequent_2");
    if_block(node_4, ($$render) => {
      $$props.children && $$render(consequent_2);
    });
  }
  template_effect(
    ($0, $1, $2) => {
      set_class(div, `la-collapsegroup -widthfull ${$0 ?? ""}
        ${($$props.acceptTypes ? `ref set drop-settable ${$$props.acceptTypes}` : "") ?? ""}
        collapse-group`), set_attribute(div, "data-item-id", $$props.itemID), set_attribute(div, "data-uuid", $$props.uuid), set_attribute(div, "data-path", $$props.path), set_attribute(div, "data-accept-types", $$props.acceptTypes), set_class(h1, `la-summary la-combine-h la-dropshadow 
            -justifybetween -widthfull -whitespacenowrap 
            ${$1 ?? ""}
            ${($$props.collapseID ? "collapse-trigger" : "") ?? ""}`), set_class(div_2, `la-collapsegroup__wrapper
            ${($$props.collapseID ? "collapse-wrapper" : "") ?? ""} ${(get$1(isCollapsed) ? "collapsed" : "") ?? ""}`), set_attribute(div_2, "data-la-collapse-id", $$props.collapseID), set_class(div_3, `la-collapsecontent 
                -padding0-l -padding0-tb -bordersround-lb -widthfull -heightfull
                ${$2 ?? ""}`);
    },
    [
      () => {
        var _a;
        return (_a = $$props.rootStyle) == null ? void 0 : _a.join(" ");
      },
      () => {
        var _a;
        return ((_a = $$props.headerStyle) == null ? void 0 : _a.join(" ")) || MAIN_HEADER_STYLE$1;
      },
      () => $$props.borderStyle ? $$props.borderStyle.join(" ") : "la-brdr-primary"
    ]
  ), event("click", h1, (event2) => toggleCollapse(event2)), append($$anchor, div), pop();
}
__name(HeaderMain, "HeaderMain");
var root$N = /* @__PURE__ */ template('<details><summary class="la-empty__summary la-combine-h clipped-bot-alt la-bckg-repcap la-text-header -padding1 -pointercursor -widthfull"><div class="la-left la-combine-h"><i class="la-icon mdi mdi-card-off-outline -fontsize2 -margin1-lr"></i> <span class="la-name__span -fontsize2"> </span></div></summary> <div class="la-empty__wrapper -bordersround -bordersoff -textaligncenter -padding2"><span class="la-details__span la-text-repcap -fontsize4 -upper">[<span class="-fontsize2 -padding0-l -letterspacing0 -bold"> </span>]</span></div></details>');
function EmptyBox($$anchor, $$props) {
  var details = root$N(), summary = child(details), div = child(summary), span = sibling(child(div), 2), text2 = child(span), div_1 = sibling(summary, 2), span_1 = child(div_1), span_2 = sibling(child(span_1)), text_1 = child(span_2);
  template_effect(() => {
    set_class(details, `la-empty -widthfull la-combine-v
        ref set drop-settable ${$$props.type ?? ""}`), set_attribute(details, "data-accept-types", $$props.type), set_attribute(details, "data-path", $$props.path), set_text(text2, $$props.label), set_text(text_1, $$props.subLabel);
  }), append($$anchor, details);
}
__name(EmptyBox, "EmptyBox");
var root_4$a = /* @__PURE__ */ template('<span class="la-activeeffect"><img class="la-activeeffect__img la-dropshadow -float-l -height10" alt="Effect Icon"> <span class="la-active-effect__span -fontsize1"><!></span></span>'), root$M = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull"><!></div>');
function ActiveEffects($$anchor, $$props) {
  push($$props, !0);
  const themeOverride = getThemeKey($$props.actor.uuid);
  function getThemedIcon(effect2) {
    let theme = getBrightness(themeOverride);
    return effect2.icon ? theme === "dark" ? effect2.icon : effect2.icon.replace("/white/", "/") : theme === "dark" ? "systems/lancer/assets/icons/white/difficulty.svg" : "systems/lancer/assets/icons/difficulty.svg";
  }
  __name(getThemedIcon, "getThemedIcon");
  function deleteActiveEffect(event2) {
    if (event2.stopPropagation(), !$$props.owner) {
      Logger.error("User is not the owner of this actor.");
      return;
    }
    let id2 = event2.currentTarget.getAttribute("data-uuid");
    try {
      $$props.actor.deleteEmbeddedDocuments("ActiveEffect", [id2], {
        diff: !0,
        render: !0,
        type: "ActiveEffect"
      });
    } catch (error) {
      Logger.error("Error deleting active effect.", error);
    }
  }
  __name(deleteActiveEffect, "deleteActiveEffect");
  var div = root$M(), node = child(div);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment = comment(), node_1 = first_child(fragment);
      each(node_1, 17, () => $$props.effects, index, ($$anchor3, effect2, index2) => {
        const headerOptions = /* @__PURE__ */ __name(($$anchor4) => {
          const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
          DeleteButton($$anchor4, {
            style: [
              "la-prmy-primary -glow-prmy-hover",
              "-fontsize2",
              "-height2",
              "-lineheight2"
            ],
            iconStyle: ["-fontsize2", "la-text-header-anti"],
            get uuid() {
              return get$1(effect2)._id;
            },
            get flowClass() {
              return FlowClass.DeleteActiveEffect;
            },
            onClick: deleteActiveEffect,
            get tooltipEnabled() {
              return $$props.tooltipEnabled;
            },
            get tooltipTheme() {
              return get$1(expression);
            },
            get logType() {
              return $$props.logType;
            },
            get logTypeReset() {
              return $$props.logTypeReset;
            }
          });
        }, "headerOptions"), expression_1 = /* @__PURE__ */ derived(() => `--${getLocalized("LA.info.label")}`), expression_2 = /* @__PURE__ */ derived(() => `${$$props.actor.uuid}.status.activeEffects.${index2}`);
        HeaderMain($$anchor3, {
          get text() {
            return get$1(effect2).name;
          },
          headerStyle: [
            MAIN_HEADER_STYLE$1,
            "la-bckg-warning",
            "clipped-bot-alt"
          ],
          textStyle: [
            "la-text-header-anti",
            "la-prmy-header-anti",
            "-fontsize1",
            "-lineheight2"
          ],
          borderStyle: [
            "la-bckg-card",
            "la-brdr-warning",
            "-overflowhidden",
            "-padding1-lr"
          ],
          get extensionText() {
            return get$1(expression_1);
          },
          get collapseID() {
            return get$1(expression_2);
          },
          startCollapsed: !0,
          headerContent: headerOptions,
          children: /* @__PURE__ */ __name(($$anchor4, $$slotProps) => {
            var span = root_4$a(), img = child(span), span_1 = sibling(img, 2), node_2 = child(span_1);
            html(node_2, () => get$1(effect2).description), template_effect(($0) => set_attribute(img, "src", $0), [
              () => encodeURI(getThemedIcon(get$1(effect2)))
            ]), append($$anchor4, span);
          }, "children"),
          $$slots: { default: !0 }
        });
      }), append($$anchor2, fragment);
    }, "consequent"), alternate = /* @__PURE__ */ __name(($$anchor2) => {
      const expression_3 = /* @__PURE__ */ derived(() => getLocalized("LA.tab.status.effects.none.label")), expression_4 = /* @__PURE__ */ derived(() => getLocalized("LA.tab.status.effects.none.subLabel"));
      EmptyBox($$anchor2, {
        get label() {
          return get$1(expression_3);
        },
        get subLabel() {
          return get$1(expression_4);
        }
      });
    }, "alternate");
    if_block(node, ($$render) => {
      $$props.effects.length ? $$render(consequent) : $$render(alternate, !1);
    });
  }
  append($$anchor, div), pop();
}
__name(ActiveEffects, "ActiveEffects");
const MAIN_HEADER_STYLE = " la-prmy-header -glow-prmy la-scdy-primary -glow-scdy-hover la-text-header -fontsize3 -lineheight2 ";
var on_click$5 = /* @__PURE__ */ __name((event2, toggleCollapseAll) => toggleCollapseAll(event2), "on_click$5"), root$L = /* @__PURE__ */ template('<button type="button"><i></i></button>');
function CollapseAllButton($$anchor, $$props) {
  push($$props, !0);
  let isExpanding = /* @__PURE__ */ derived(() => !getCollapseState($$props.collapseID));
  const tip = TooltipFactory.buildTooltip(getLocalized("LA.collapseAll.tooltip")), logging = $$props.logType && $$props.logTypeReset, log = $$props.logText || getLocalized("LA.collapseAll.tooltip");
  function handleOnPointerEnter(event2) {
    if ($$props.onPointerEnter && $$props.onPointerEnter(), logging) sendToLog(event2, log, $$props.logType);
    else return;
  }
  __name(handleOnPointerEnter, "handleOnPointerEnter");
  function handleOnPointerLeave(event2) {
    if ($$props.onPointerLeave && $$props.onPointerLeave(), logging) resetLog(event2, $$props.logTypeReset);
    else return;
  }
  __name(handleOnPointerLeave, "handleOnPointerLeave");
  function toggleCollapseAll(event2) {
    if (event2.stopPropagation(), !$$props.collapseID || event2.currentTarget === null) return;
    const collapseGroup = jQuery(event2.currentTarget).closest(".collapse-group");
    collapseGroup && (collapseGroup.find("[data-la-collapse-id]").each((_, trigger) => {
      const childId = jQuery(trigger).data("la-collapse-id");
      childId !== $$props.collapseID && childId && setCollapseState(childId, get$1(isExpanding));
    }), setCollapseState($$props.collapseID, get$1(isExpanding)));
  }
  __name(toggleCollapseAll, "toggleCollapseAll");
  var button = root$L();
  button.__click = [on_click$5, toggleCollapseAll];
  var i2 = child(button);
  template_effect(
    ($0, $1, $2) => {
      set_class(button, $0), set_attribute(button, "data-tooltip", $$props.tooltipEnabled ? tip : void 0), set_attribute(button, "data-tooltip-class", `${$$props.tooltipClass || "clipped-bot la-tooltip"} ${$$props.tooltipTheme}`), set_attribute(button, "data-tooltip-direction", $$props.tooltipDirection || TooltipDirection.UP), set_attribute(button, "aria-label", $1), set_class(i2, `mdi ${(get$1(isExpanding) ? "mdi-arrow-collapse-all" : "mdi-arrow-expand-all") ?? ""} ${$2 ?? ""}}`);
    },
    [
      () => {
        var _a;
        return ((_a = $$props.style) == null ? void 0 : _a.join(" ")) || MAIN_HEADER_STYLE;
      },
      () => getLocalized("LA.collapseAll.tooltip"),
      () => {
        var _a;
        return (_a = $$props.iconStyle) == null ? void 0 : _a.join(" ");
      }
    ]
  ), event("pointerenter", button, handleOnPointerEnter), event("pointerleave", button, handleOnPointerLeave), append($$anchor, button), pop();
}
__name(CollapseAllButton, "CollapseAllButton");
delegate(["click"]);
const H2_HEADER_STYLE = "clipped-bot-alt -padding0-l -padding3-r la-text-header la-prmy-header", H2_ICON_SIZE = "-fontsize5", H2_TEXT_SIZE = "-fontsize2";
var root_2$i = /* @__PURE__ */ template('<div class="la-right la-combine-h -aligncenter"><!></div>'), root_5$k = /* @__PURE__ */ template("<div><div><!></div></div>"), root$K = /* @__PURE__ */ template('<div draggable="true"><div><div class="la-left la-combine-h -justifystart -aligncenter -gap1 -widthfull -overflowhidden"><!> <!></div> <!></div> <!> <!></div>');
function HeaderSecondary($$anchor, $$props) {
  push($$props, !0);
  let isCollapsed = /* @__PURE__ */ derived(() => getCollapseState($$props.collapseID) ?? $$props.startCollapsed ?? !1);
  const extraOptions = !!$$props.contentRight;
  onMount(() => {
    $$props.collapseID && ($$props.dontSaveCollapse || getCollapseState($$props.collapseID) === void 0) && setCollapseState($$props.collapseID, $$props.startCollapsed ?? !1);
  });
  function toggleCollapse(event2) {
    event2.stopPropagation(), $$props.collapseID && setCollapseState($$props.collapseID, !get$1(isCollapsed));
  }
  __name(toggleCollapse, "toggleCollapse");
  function getExtensionText() {
    if ($$props.extensionTextFunction && $$props.extensionTextFunction()) return $$props.extensionTextFunction();
    if ($$props.extensionText) return $$props.extensionText;
    if ($$props.collapseID) return get$1(isCollapsed) ? `--${getLocalized("LA.expand.label")}` : `--${getLocalized("LA.collapse.label")}`;
  }
  __name(getExtensionText, "getExtensionText");
  var div = root$K(), div_1 = child(div), div_2 = child(div_1), node = child(div_2);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment = comment(), node_1 = first_child(fragment);
      snippet(node_1, () => $$props.contentLeft), append($$anchor2, fragment);
    }, "consequent");
    if_block(node, ($$render) => {
      $$props.contentLeft && $$render(consequent);
    });
  }
  var node_2 = sibling(node, 2);
  const expression = /* @__PURE__ */ derived(() => $$props.collapseID || !$$props.extensionText ? `${$$props.text} ` : $$props.text), expression_1 = /* @__PURE__ */ derived(getExtensionText), expression_2 = /* @__PURE__ */ derived(() => $$props.disableCmdline || !0), expression_3 = /* @__PURE__ */ derived(() => $$props.disableCursor || !1), expression_4 = /* @__PURE__ */ derived(() => $$props.disableExtension || !1);
  TerminalText(node_2, {
    get text() {
      return get$1(expression);
    },
    get textStyle() {
      return $$props.textStyle;
    },
    get extensionText() {
      return get$1(expression_1);
    },
    get disableCmdline() {
      return get$1(expression_2);
    },
    get disableCursor() {
      return get$1(expression_3);
    },
    get disableExtension() {
      return get$1(expression_4);
    }
  });
  var node_3 = sibling(div_2, 2);
  {
    var consequent_2 = /* @__PURE__ */ __name(($$anchor2) => {
      var div_3 = root_2$i(), node_4 = child(div_3);
      {
        var consequent_1 = /* @__PURE__ */ __name(($$anchor3) => {
          var fragment_1 = comment(), node_5 = first_child(fragment_1);
          snippet(node_5, () => $$props.contentRight), append($$anchor3, fragment_1);
        }, "consequent_1");
        if_block(node_4, ($$render) => {
          $$props.contentRight && $$render(consequent_1);
        });
      }
      append($$anchor2, div_3);
    }, "consequent_2");
    if_block(node_3, ($$render) => {
      extraOptions && $$render(consequent_2);
    });
  }
  var node_6 = sibling(div_1, 2);
  {
    var consequent_3 = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment_2 = comment(), node_7 = first_child(fragment_2);
      snippet(node_7, () => $$props.renderOutsideCollapse), append($$anchor2, fragment_2);
    }, "consequent_3");
    if_block(node_6, ($$render) => {
      $$props.renderOutsideCollapse && $$render(consequent_3);
    });
  }
  var node_8 = sibling(node_6, 2);
  {
    var consequent_5 = /* @__PURE__ */ __name(($$anchor2) => {
      var div_4 = root_5$k(), div_5 = child(div_4), node_9 = child(div_5);
      {
        var consequent_4 = /* @__PURE__ */ __name(($$anchor3) => {
          var fragment_3 = comment(), node_10 = first_child(fragment_3);
          snippet(node_10, () => $$props.children), append($$anchor3, fragment_3);
        }, "consequent_4");
        if_block(node_9, ($$render) => {
          $$props.children && $$render(consequent_4);
        });
      }
      template_effect(
        ($0) => {
          set_class(div_4, `la-collapsegroup__wrapper
            ${($$props.collapseID ? "collapse-wrapper" : "") ?? ""} ${(get$1(isCollapsed) ? "collapsed" : "") ?? ""}`), set_attribute(div_4, "data-la-collapse-id", $$props.collapseID), set_class(div_5, `la-collapsecontent 
                -padding0-l -padding0-tb -bordersround-lb -widthfull -heightfull
                ${$0 ?? ""}`);
        },
        [
          () => $$props.borderStyle ? $$props.borderStyle.join(" ") : "la-brdr-primary"
        ]
      ), append($$anchor2, div_4);
    }, "consequent_5");
    if_block(node_8, ($$render) => {
      ($$props.collapseID || $$props.children) && $$render(consequent_5);
    });
  }
  template_effect(
    ($0, $1) => {
      set_class(div, `la-collapsegroup -widthfull ${$0 ?? ""}
        ${($$props.acceptTypes ? `ref set drop-settable ${$$props.acceptTypes}` : "") ?? ""}
        collapse-group`), set_attribute(div, "data-item-id", $$props.itemID), set_attribute(div, "data-uuid", $$props.uuid), set_attribute(div, "data-path", $$props.path), set_attribute(div, "data-accept-types", $$props.acceptTypes), set_class(div_1, `la-summary la-combine-h la-dropshadow 
            -justifybetween -widthfull -whitespacenowrap 
            ${$1 ?? ""}
            ${($$props.collapseID ? "collapse-trigger" : "") ?? ""}`);
    },
    [
      () => $$props.rootStyle ? $$props.rootStyle.join(" ") : "",
      () => {
        var _a;
        return ((_a = $$props.headerStyle) == null ? void 0 : _a.join(" ")) || H2_HEADER_STYLE;
      }
    ]
  ), event("click", div_1, (event2) => toggleCollapse(event2)), append($$anchor, div), pop();
}
__name(HeaderSecondary, "HeaderSecondary");
const _AppliedDamage = class _AppliedDamage {
  constructor(damageData) {
    __publicField(this, "Kinetic");
    __publicField(this, "Energy");
    __publicField(this, "Explosive");
    __publicField(this, "Burn");
    __publicField(this, "Heat");
    __publicField(this, "Variable");
    this.Kinetic = this.sum_damage(damageData, "Kinetic"), this.Energy = this.sum_damage(damageData, "Energy"), this.Explosive = this.sum_damage(damageData, "Explosive"), this.Burn = this.sum_damage(damageData, "Burn"), this.Heat = this.sum_damage(damageData, "Heat"), this.Variable = this.sum_damage(damageData, "Variable");
  }
  sum_damage(damageData, damageType) {
    return damageData.reduce((sum, d) => sum + (d.type === damageType ? parseInt(d.val) : 0), 0);
  }
};
__name(_AppliedDamage, "AppliedDamage");
let AppliedDamage = _AppliedDamage;
const _Damage = class _Damage {
  constructor(data) {
    __publicField(this, "type");
    __publicField(this, "val");
    this.type = data.type, this.val = data.val;
  }
  save() {
    return {
      type: this.type,
      val: this.val
    };
  }
  copy() {
    return new _Damage(this.save());
  }
  // Methods / getters / Various formatting options
  get icon() {
    return _Damage.IconFor(this.type);
  }
  get text() {
    return `${this.val} ${this.type} Damage`;
  }
  get discord_emoji() {
    return _Damage.DiscordEmojiFor(this.type);
  }
  get color() {
    return _Damage.ColorFor(this.type);
  }
  // Returns the css font icon corresponding to the provided damage type
  static IconFor(dt) {
    return `cci-${dt.toLowerCase()}`;
  }
  static DiscordEmojiFor(dt) {
    return `:cc_damage_${dt.toLowerCase()}:`;
  }
  // Returns the css color name corresponding to the provided damage type
  static ColorFor(dt) {
    return `damage--${dt.toLowerCase()}`;
  }
  // Convert a damage type array to a checklist. If no damage types provided, assume all
  static MakeChecklist(damages) {
    let override = damages.length == 0;
    return {
      Burn: override || damages.includes("Burn"),
      Energy: override || damages.includes("Energy"),
      Explosive: override || damages.includes("Explosive"),
      Heat: override || damages.includes("Heat"),
      Kinetic: override || damages.includes("Kinetic"),
      Variable: override || damages.includes("Variable")
    };
  }
  // Undo the above conversion
  static FlattenChecklist(damages) {
    return Object.keys(damages).filter((d) => damages[d]);
  }
  // Combine two arrays of damage. Does not edit originals
  static CombineLists(base, addition) {
    let result = base.map((d) => d.copy());
    for (let add of addition) {
      let to_be_modified = result.find((result_d) => result_d.type == add.type);
      if (to_be_modified)
        try {
          let base_formula = new Roll(to_be_modified.val), add_formula = new Roll(add.val);
          for (let add_term of add_formula.terms) {
            let added = !1;
            for (let base_term of base_formula.terms)
              if (add_term.number && base_term.number && add_term.faces === base_term.faces) {
                base_term.number += add_term.number, added = !0;
                break;
              }
            !added && !add_term.operator && (base_formula = new Roll(base_formula.formula + " + " + add_term.formula));
          }
          to_be_modified.val = base_formula.formula;
        } catch {
          to_be_modified.val += ` + ${add.val}`;
        }
      else
        result.push(add.copy());
    }
    return result;
  }
};
__name(_Damage, "Damage");
let Damage = _Damage;
function rebindButtons(messageData, messageContainer) {
  $(messageContainer).find(".lancer-button").toArray().forEach((buttonElement) => {
    const button = $(buttonElement);
    if (button.hasClass("lancer-damage-flow"))
      handleDamageFlow(messageData, button);
    else if (button.hasClass("lancer-damage-apply"))
      handleDamageApply(messageData, button);
    else if (button.hasClass("lancer-damage-undo"))
      handleDamageUndo(messageData, button);
    else if (button.hasClass("flow-button")) {
      const flowType = button.data("flow-type");
      flowType ? flowType === "cascade" ? handleCascadeFlow(messageData, button) : flowType === "secondaryStructure" ? handleSecondaryStructureFlow(messageData, button) : flowType === "check" ? handleCheckFlow(messageData, button) : Logger.warn(`Unknown flow button class: ${flowType}. Please report this to Lancer Alternative Sheets author with the action in the chat that caused it. Like for realsies.`, button) : Logger.warn("Flow button missing [data-flow-type] attribute");
    } else
      Logger.warn(`Unknown lancer button class: ${button.attr("class")}. Please report this to Lancer Alternative Sheets author with the action in the chat that caused it. No, really.`, button);
  });
}
__name(rebindButtons, "rebindButtons");
function handleDamageFlow(messageData, button) {
  async function runDamageFlow() {
    var _a;
    const attackData = (_a = messageData == null ? void 0 : messageData.flags.lancer) == null ? void 0 : _a.attackData, actor = await fromUuid(attackData == null ? void 0 : attackData.attackerUuid), item = await fromUuid(attackData == null ? void 0 : attackData.attackerItemUuid);
    if (!item && !attackData)
      return;
    const hitResults = attackData == null ? void 0 : attackData.targets.map(async (target) => {
      if (!(!target || target.documentName !== "Token"))
        return {
          target: await fromUuid(target.id),
          total: target.total,
          usedLockOn: target.setConditions.lockOn === !1,
          hit: target.hit,
          crit: target.crit
        };
    }), damage = [], bonusDamage = [];
    attackData != null && attackData.invade && damage.push({ type: "Heat", val: "2" });
    const DamageRollFlow = game.lancer.flows.get("DamageRollFlow");
    new DamageRollFlow(
      (item == null ? void 0 : item.uuid) || (attackData == null ? void 0 : attackData.attackerUuid),
      {
        title: `${(item == null ? void 0 : item.name) || (actor == null ? void 0 : actor.name)}  ${getLocalized("LA.damage.label").toUpperCase()}`,
        configurable: !0,
        invade: attackData == null ? void 0 : attackData.invade,
        hit_results: hitResults,
        has_normal_hit: hitResults == null ? void 0 : hitResults.some((hr) => hr.hit && !hr.crit),
        has_crit_hit: hitResults == null ? void 0 : hitResults.some((hr) => hr.crit),
        damage,
        bonus_damage: bonusDamage
      }
    ).begin();
  }
  __name(runDamageFlow, "runDamageFlow"), button.on("click", async () => {
    runDamageFlow();
  });
}
__name(handleDamageFlow, "handleDamageFlow");
function handleDamageApply(messageData, button) {
  async function runApplyDamageFlow(event2) {
    var _a, _b;
    const buttonGroup = event2.currentTarget.closest(".lancer-damage-button-group"), data = buttonGroup == null ? void 0 : buttonGroup.dataset, target = await fromUuid(data.target), actor = target == null ? void 0 : target.actor;
    if (!data || !actor)
      return;
    const targetDamage = ((_a = messageData == null ? void 0 : messageData.flags.lancer) == null ? void 0 : _a.damageData).targetDamageResults.map((dmgTarget) => {
      const target2 = fromUuidSync(dmgTarget.target);
      return target2 ? {
        ...dmgTarget,
        target: target2
      } : null;
    }).filter((t2) => t2 !== null).find((dmgTarget) => {
      var _a2;
      return ((_a2 = dmgTarget == null ? void 0 : dmgTarget.target) == null ? void 0 : _a2.uuid) === data.target;
    }), multiple = parseFloat((_b = buttonGroup.querySelector("select")) == null ? void 0 : _b.value) || 1;
    await actor.damageCalc(
      new AppliedDamage(targetDamage.damage.map((damage) => new Damage({
        type: damage.type,
        val: damage.amount.toString()
      }))),
      {
        multiple,
        addBurn: data.addBurn === "true",
        isCrit: data.isCrit === "true",
        isHit: data.isHit === "true",
        ap: targetDamage.ap,
        paracausal: targetDamage.paracausal
      }
    );
  }
  __name(runApplyDamageFlow, "runApplyDamageFlow"), button.on("click", async (event2) => {
    runApplyDamageFlow(event2);
  });
}
__name(handleDamageApply, "handleDamageApply");
function handleDamageUndo(_messageData, button) {
  async function runDamageUndo(event2) {
    var _a, _b;
    const overshieldDelta = parseInt(event2.currentTarget.dataset.overshieldDelta), hpDelta = parseInt(event2.currentTarget.dataset.hpDelta), heatDelta = parseInt(event2.currentTarget.dataset.heatDelta), burnDelta = event2.currentTarget.dataset.addBurn === "true" ? parseInt(event2.currentTarget.dataset.burnDelta) : 0;
    if (!overshieldDelta && !hpDelta && !burnDelta && !heatDelta) {
      (_a = ui.notifications) == null || _a.error("Damage undo button has no damage to undo!");
      return;
    }
    const target = await fromUuid(event2.currentTarget.dataset.uuid);
    if (!target) {
      (_b = ui.notifications) == null || _b.error("Damage undo button has no target");
      return;
    }
    const updateData = {
      system: {
        "overshield.value": target.system.overshield.value + overshieldDelta,
        "hp.value": target.system.hp.value + hpDelta,
        burn: target.system.burn - burnDelta
      }
    };
    (target.is_mech() || target.is_npc() || target.is_deployable()) && (updateData.system["heat.value"] = target.system.heat.value - heatDelta), await target.update(updateData);
  }
  __name(runDamageUndo, "runDamageUndo"), button.on("click", async (event2) => {
    runDamageUndo(event2);
  });
}
__name(handleDamageUndo, "handleDamageUndo");
function handleCascadeFlow(messageData, button) {
  async function runCascadeFlow() {
    const CascadeFlow = game.lancer.flows.get("CascadeFlow");
    new CascadeFlow(`Actor.${messageData.speaker.actor}`).begin();
  }
  __name(runCascadeFlow, "runCascadeFlow"), button.on("click", async () => {
    runCascadeFlow();
  });
}
__name(handleCascadeFlow, "handleCascadeFlow");
function handleSecondaryStructureFlow(messageData, button) {
  async function runSecondaryStructureFlow() {
    const SecondaryStructureFlow = game.lancer.flows.get("SecondaryStructureFlow");
    new SecondaryStructureFlow(`Actor.${messageData.speaker.actor}`).begin();
  }
  __name(runSecondaryStructureFlow, "runSecondaryStructureFlow"), button.on("click", async () => {
    runSecondaryStructureFlow();
  });
}
__name(handleSecondaryStructureFlow, "handleSecondaryStructureFlow");
function handleCheckFlow(messageData, button) {
  async function runCheckFlow() {
    const checkType = button.data("check-type"), StatRollFlow = game.lancer.flows.get("StatRollFlow");
    new StatRollFlow(`Actor.${messageData.speaker.actor}`, `system.${checkType}`).begin();
  }
  __name(runCheckFlow, "runCheckFlow"), button.on("click", async () => {
    runCheckFlow();
  });
}
__name(handleCheckFlow, "handleCheckFlow");
var root$J = /* @__PURE__ */ template('<div class="-fontsize1"><!></div>');
function ActionLogMessage($$anchor, $$props) {
  push($$props, !0);
  let component = null;
  onMount(() => {
    component && rebindButtons($$props.messageData, component);
  });
  var div = root$J(), node = child(div);
  html(node, () => $$props.messageData.content), bind_this(div, ($$value) => component = $$value, () => component), append($$anchor, div), pop();
}
__name(ActionLogMessage, "ActionLogMessage");
const headerSecondaryLeftOptions$1 = /* @__PURE__ */ __name(($$anchor) => {
  var i2 = root_1$p();
  append($$anchor, i2);
}, "headerSecondaryLeftOptions$1");
var root_1$p = /* @__PURE__ */ template('<i class="mdi mdi-message-text -fontsize1 -padding0"></i>'), root_3$u = /* @__PURE__ */ template('<span class="-fontsize0"> </span>'), root$I = /* @__PURE__ */ template('<div class="la-actionlog -main la-combine-v -gap0 -widthfull -displayflex -directioncolumnreverse"></div>');
function ActionLog($$anchor, $$props) {
  push($$props, !0);
  const idParts = $$props.uuid.split("."), messages = game.messages;
  let filteredMessages = proxy((messages == null ? void 0 : messages.filter((m) => {
    var _a;
    const msgActorID = m.speaker.token || m.speaker.actor;
    return idParts.includes(msgActorID) && ((_a = m.content) == null ? void 0 : _a.trim().startsWith("<div c"));
  })) || []), component = state(null), extractedTimes = state(proxy([])), extractedNames = proxy([]), animationFrame;
  onMount(() => {
    filteredMessages.forEach((message) => {
      get$1(extractedTimes).push(extractTime(message.timestamp)), extractedNames.push(extractName(message.content));
    }), trackHook(
      $$props.uuid,
      Hooks.on("createChatMessage", (message) => {
        var _a;
        const msgActorID = message.speaker.token || message.speaker.actor;
        idParts.includes(msgActorID) && ((_a = message.content) != null && _a.trim().startsWith("<div c")) && (filteredMessages.push(message), get$1(extractedTimes).push(extractTime(message.timestamp)), extractedNames.push(extractName(message.content)));
      }),
      "createChatMessage"
    ), trackHook(
      $$props.uuid,
      Hooks.on("deleteChatMessage", (message) => {
        const index2 = filteredMessages.findIndex((msg) => msg.id === message.id);
        index2 !== -1 && (filteredMessages.splice(index2, 1), get$1(extractedTimes).splice(index2, 1), extractedNames.splice(index2, 1));
      }),
      "deleteChatMessage"
    );
    function refreshTimes() {
      set(extractedTimes, proxy(filteredMessages.map((message) => extractTime(message.timestamp)))), animationFrame = requestAnimationFrame(() => {
        setTimeout(refreshTimes, 15e3);
      });
    }
    __name(refreshTimes, "refreshTimes"), refreshTimes();
  }), onDestroy(() => {
    cancelAnimationFrame(animationFrame);
  }), user_effect(() => {
    var _a;
    (_a = get$1(component)) == null || _a.scrollTo(0, get$1(component).scrollHeight);
  });
  function extractTime(messageTime) {
    const diff = Math.floor(Date.now()) - messageTime;
    return diff < 6e4 ? `${Math.round(diff / 1e3)}s ago` : diff < 36e5 ? `${Math.round(diff / 6e4)}m ago` : diff < 864e5 ? `${Math.round(diff / 36e5)}h ago` : `${Math.round(diff / 864e5)}d ago`;
  }
  __name(extractTime, "extractTime");
  function extractName(content) {
    var _a, _b, _c;
    const element = document.createElement("div");
    element.innerHTML = content;
    const headerElement = jQuery(element).find(".lancer-header, .lancer-stat-header").get(0);
    if (!headerElement) return getLocalized("LA.placeholder");
    const headerText = (_b = (_a = headerElement.firstChild) == null ? void 0 : _a.textContent) == null ? void 0 : _b.trim();
    if (headerText) return headerText;
    const spanElement = jQuery(headerElement).find("span").get(0);
    return ((_c = spanElement == null ? void 0 : spanElement.textContent) == null ? void 0 : _c.trim()) || getLocalized("LA.placeholder");
  }
  __name(extractName, "extractName");
  var div = root$I();
  each(div, 21, () => filteredMessages, index, ($$anchor2, message, index2) => {
    const headerSecondaryRightOptions = /* @__PURE__ */ __name(($$anchor3) => {
      var span = root_3$u(), text2 = child(span);
      template_effect(() => set_text(text2, get$1(extractedTimes)[index2])), append($$anchor3, span);
    }, "headerSecondaryRightOptions"), expression = /* @__PURE__ */ derived(() => `chat.${$$props.collapsePrefix ? $$props.collapsePrefix + "." : ""}${get$1(message).id}`);
    HeaderSecondary($$anchor2, {
      get text() {
        return extractedNames[index2];
      },
      headerStyle: [H2_HEADER_STYLE, "la-bckg-header-anti"],
      textStyle: [
        "la-text-header",
        "la-prmy-header",
        "-fontsize1",
        "-upper"
      ],
      borderStyle: ["la-brdr-header-anti"],
      get itemID() {
        return get$1(message).id;
      },
      get collapseID() {
        return get$1(expression);
      },
      get startCollapsed() {
        return $$props.startCollapsed;
      },
      get dontSaveCollapse() {
        return $$props.dontSaveCollapse;
      },
      contentLeft: headerSecondaryLeftOptions$1,
      contentRight: headerSecondaryRightOptions,
      children: /* @__PURE__ */ __name(($$anchor3, $$slotProps) => {
        ActionLogMessage($$anchor3, {
          get messageData() {
            return get$1(message);
          }
        });
      }, "children"),
      $$slots: { default: !0 }
    });
  }), bind_this(div, ($$value) => set(component, $$value), () => get$1(component)), template_effect(() => set_attribute(div, "style", $$props.maxHeight ? `max-height: ${$$props.maxHeight}rem;` : "")), append($$anchor, div), pop();
}
__name(ActionLog, "ActionLog");
var on_change$4 = /* @__PURE__ */ __name((event2, updateDocument) => updateDocument(event2, "system.structure.value"), "on_change$4"), on_change_1$3 = /* @__PURE__ */ __name((event2, updateDocument) => updateDocument(event2, "system.stress.value"), "on_change_1$3"), on_change_2$1 = /* @__PURE__ */ __name((event2, updateDocument) => updateDocument(event2, "system.burn"), "on_change_2$1"), root_5$j = /* @__PURE__ */ template('<div class="la-combine-v -widthfull -heightfull -padding0-r"><div class="la-combine-h -justifyevenly -wrapwrap -widthfull -heightfull -flex1"><div class="la-combine-h -aligncenter"><i class="cci cci-structure la-dropshadow -fontsize9 -displayinline"></i> <span class="la-label__span -fontsize1 -writingmode-v"> </span> <div class="la-combine-v -divider la-prmy-accent -fontsize4 -textaligncenter"><input class="la-top__input -width2ch la-shadow -medium -inset la-text-text" type="number"><span class="la-bottom__span"> </span></div></div> <div class="la-combine-h -aligncenter"><i class="cci cci-repair la-dropshadow -fontsize9"></i> <span class="la-label__span -fontsize1 -writingmode-v"> </span> <div class="la-combine-v -divider la-prmy-accent -fontsize4 -textaligncenter"><input class="la-top__input -width2ch la-shadow -medium -inset la-text-text" type="number" name="system.repairs.value" data-dtype="Number"> <span class="la-bottom__span"> </span></div></div> <div class="la-combine-h -aligncenter"><i class="cci cci-reactor la-dropshadow -fontsize9"></i> <span class="la-label__span -fontsize1 -writingmode-v"> </span> <div class="la-combine-v -divider la-prmy-accent -fontsize4 -textaligncenter"><input class="la-top__input -width2ch la-shadow -medium -inset la-text-text" type="number"> <span class="la-bottom__span"> </span></div></div> <div class="la-combine-h -aligncenter"><i class="cci cci-burn la-dropshadow -fontsize9"></i> <span class="la-label__span -fontsize1 -writingmode-v"> </span> <input class="la-top__input -width2ch la-shadow -fontsize4 -medium -inset la-text-text" type="number"></div> <div class="la-combine-h -aligncenter"><div class="la-combine-h -alignselfcenter -positionrelative"><i class="cci cci-overcharge la-dropshadow -fontsize9"></i> <div class="la-combine-v -divider la-prmy-accent -fontsize4 -textaligncenter"><span class="la-top__span -widthfull"><!> <!></span> <span class="la-bottom__span -fontsize1"> </span></div></div></div></div> <hr class="-widthfull"> <div class="la-combine-h -gap0 -wrapwrap -justifybetween -widthfull -heightfull -flex0"><div class="la-combine-v -gap0 la-dropshadow -flex1 -widthfull"><!> <!> <!></div> <div class="la-combine-v -gap0 la-dropshadow -flex1"><!> <!> <!> <!></div></div></div>'), root$H = /* @__PURE__ */ template('<div class="la-status__list la-combine-v -widthfull"><!> <!> <!></div>');
function Status$1($$anchor, $$props) {
  push($$props, !0);
  const headerOptions = /* @__PURE__ */ __name(($$anchor2) => {
    const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid));
    CollapseAllButton($$anchor2, {
      collapseID: collID,
      tooltipEnabled,
      get tooltipTheme() {
        return get$1(expression);
      },
      get logType() {
        return TextLogHook.MechHeader;
      },
      get logTypeReset() {
        return TextLogHook.MechHeaderReset;
      },
      onPointerEnter: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !0);
      }, "onPointerEnter"),
      onPointerLeave: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !1);
      }, "onPointerLeave")
    });
  }, "headerOptions"), props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor, system, document: document2 } = props;
  let collapseAllButtonHover = state(!1);
  const tooltipEnabled = getMechSheetTooltipEnabled(), actionLogEnabled = getMechSheetLogActionMainEnabled(), actionLogMaxHeight = getMechSheetLogActionMainMaxHeight(), actionLogSaveCollapse = getMechSheetLogActionDontSaveCollapse(), actionLogStartCollapsed = getMechSheetLogActionStartCollapsed(), overchargePlusTip = TooltipFactory.buildTooltip(getLocalized("LA.overcharge.increase.tooltip")), overchargeMinusTip = TooltipFactory.buildTooltip(getLocalized("LA.overcharge.decrease.tooltip")), overchargeText = formatString(getLocalized("LA.flow.overcharge.tooltip"), getCurrentOvercharge(actor)), collID = `${actor.uuid}.status.activeEffects`;
  function updateDocument(event2, path) {
    document2.update({ [path]: event2.currentTarget.valueAsNumber });
  }
  __name(updateDocument, "updateDocument");
  var div = root$H(), node = child(div);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      const expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.tab.status.actionLog.label")), expression_2 = /* @__PURE__ */ derived(() => `${actor.uuid}.status.actionLog`);
      HeaderMain($$anchor2, {
        get text() {
          return get$1(expression_1);
        },
        headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-primary"],
        textStyle: [
          "la-text-header",
          "-fontsize2",
          "-overflowhidden"
        ],
        borderStyle: [
          "la-bckg-card",
          "la-brdr-transparent",
          "clipped-bot-alt"
        ],
        extensionTextFunction: /* @__PURE__ */ __name(() => {
          if (get$1(collapseAllButtonHover)) return `--${getLocalized("LA.collapseAll.extension")}`;
        }, "extensionTextFunction"),
        get collapseID() {
          return get$1(expression_2);
        },
        startCollapsed: !1,
        children: /* @__PURE__ */ __name(($$anchor3, $$slotProps) => {
          ActionLog($$anchor3, {
            get uuid() {
              return actor.uuid;
            },
            maxHeight: actionLogMaxHeight,
            dontSaveCollapse: actionLogSaveCollapse,
            startCollapsed: actionLogStartCollapsed,
            get collapsePrefix() {
              return ActionLogCollapsePrefix.MechSheet;
            }
          });
        }, "children"),
        $$slots: { default: !0 }
      });
    }, "consequent");
    if_block(node, ($$render) => {
      actionLogEnabled && $$render(consequent);
    });
  }
  var node_1 = sibling(node, 2);
  const expression_3 = /* @__PURE__ */ derived(() => getLocalized("LA.tab.status.effects.label"));
  HeaderMain(node_1, {
    get text() {
      return get$1(expression_3);
    },
    headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-primary"],
    textStyle: [
      "la-text-header",
      "-fontsize2",
      "-overflowhidden"
    ],
    borderStyle: [
      "la-bckg-card",
      "la-brdr-transparent",
      "clipped-bot-alt"
    ],
    collapseID: collID,
    startCollapsed: !1,
    headerContent: headerOptions,
    children: /* @__PURE__ */ __name(($$anchor2, $$slotProps) => {
      ActiveEffects($$anchor2, spread_props(() => props, {
        tooltipEnabled,
        get logType() {
          return TextLogHook.MechHeader;
        },
        get logTypeReset() {
          return TextLogHook.MechHeaderReset;
        }
      }));
    }, "children"),
    $$slots: { default: !0 }
  });
  var node_2 = sibling(node_1, 2);
  const expression_4 = /* @__PURE__ */ derived(() => getLocalized("LA.tab.status.integrity.label")), expression_5 = /* @__PURE__ */ derived(() => `${actor.uuid}.status.integrity`);
  HeaderMain(node_2, {
    get text() {
      return get$1(expression_4);
    },
    headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-primary"],
    textStyle: [
      "la-text-header",
      "-fontsize2",
      "-overflowhidden"
    ],
    borderStyle: [
      "la-bckg-card",
      "la-brdr-transparent",
      "clipped-bot-alt"
    ],
    get collapseID() {
      return get$1(expression_5);
    },
    startCollapsed: !1,
    children: /* @__PURE__ */ __name(($$anchor2, $$slotProps) => {
      var div_1 = root_5$j(), div_2 = child(div_1), div_3 = child(div_2), span = sibling(child(div_3), 2), text2 = child(span), div_4 = sibling(span, 2), input = child(div_4);
      input.__change = [on_change$4, updateDocument];
      var span_1 = sibling(input), text_1 = child(span_1), div_5 = sibling(div_3, 2), span_2 = sibling(child(div_5), 2), text_2 = child(span_2), div_6 = sibling(span_2, 2), input_1 = child(div_6), span_3 = sibling(input_1, 2), text_3 = child(span_3), div_7 = sibling(div_5, 2), span_4 = sibling(child(div_7), 2), text_4 = child(span_4), div_8 = sibling(span_4, 2), input_2 = child(div_8);
      input_2.__change = [on_change_1$3, updateDocument];
      var span_5 = sibling(input_2, 2), text_5 = child(span_5), div_9 = sibling(div_7, 2), span_6 = sibling(child(div_9), 2), text_6 = child(span_6), input_3 = sibling(span_6, 2);
      input_3.__change = [on_change_2$1, updateDocument];
      var div_10 = sibling(div_9, 2), div_11 = child(div_10), div_12 = sibling(child(div_11), 2), span_7 = child(div_12), node_3 = child(span_7);
      const expression_6 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid));
      GlyphButton(node_3, {
        type: "button",
        get flowClass() {
          return FlowClass.None;
        },
        style: [
          "mdi mdi-chevron-left la-text-secondary la-prmy-primary -glow-prmy-hover -fontsize3 -alignselfcenter"
        ],
        tooltip: overchargeMinusTip,
        get tooltipTheme() {
          return get$1(expression_6);
        },
        get tooltipDirection() {
          return TooltipDirection.UP;
        },
        onClick: /* @__PURE__ */ __name((event2) => handleOverchargeDecrease(event2, actor), "onClick")
      });
      var text_7 = sibling(node_3), node_4 = sibling(text_7);
      const expression_7 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid));
      GlyphButton(node_4, {
        type: "button",
        get flowClass() {
          return FlowClass.None;
        },
        style: [
          "mdi mdi-chevron-right la-text-secondary la-prmy-primary -glow-prmy-hover -fontsize3 -alignselfcenter"
        ],
        tooltip: overchargePlusTip,
        get tooltipTheme() {
          return get$1(expression_7);
        },
        get tooltipDirection() {
          return TooltipDirection.UP;
        },
        onClick: /* @__PURE__ */ __name((event2) => handleOverchargeIncrease(event2, actor), "onClick")
      });
      var span_8 = sibling(span_7, 2), text_8 = child(span_8), div_13 = sibling(div_2, 4), div_14 = child(div_13), node_5 = child(div_14);
      const expression_8 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.structureDamage.label")), expression_9 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_10 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.structureDamage.tooltip")), expression_11 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.structureDamage.tooltip"));
      FlowButton(node_5, {
        style: [
          "clipped-alt",
          "-widthfull",
          "la-bckg-tabs",
          "-padding0"
        ],
        get text() {
          return get$1(expression_8);
        },
        get uuid() {
          return actor.uuid;
        },
        get flowClass() {
          return FlowClass.Standard;
        },
        flowType: "Structure",
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_9);
        },
        get tooltipDirection() {
          return TooltipDirection.LEFT;
        },
        get tooltip() {
          return get$1(expression_10);
        },
        get logText() {
          return get$1(expression_11);
        },
        get logType() {
          return TextLogHook.MechHeader;
        },
        get logTypeReset() {
          return TextLogHook.MechHeaderReset;
        }
      });
      var node_6 = sibling(node_5, 2);
      const expression_12 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.reactorStress.label")), expression_13 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_14 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.reactorStress.tooltip")), expression_15 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.reactorStress.tooltip"));
      FlowButton(node_6, {
        style: [
          "clipped-alt",
          "-widthfull",
          "la-bckg-tabs",
          "-padding0"
        ],
        get text() {
          return get$1(expression_12);
        },
        get uuid() {
          return actor.uuid;
        },
        get flowClass() {
          return FlowClass.Standard;
        },
        flowType: "Overheat",
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_13);
        },
        get tooltip() {
          return get$1(expression_14);
        },
        get tooltipDirection() {
          return TooltipDirection.LEFT;
        },
        get logText() {
          return get$1(expression_15);
        },
        get logType() {
          return TextLogHook.MechHeader;
        },
        get logTypeReset() {
          return TextLogHook.MechHeaderReset;
        }
      });
      var node_7 = sibling(node_6, 2);
      const expression_16 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.fullRepair.label")), expression_17 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_18 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.fullRepair.tooltip")), expression_19 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.fullRepair.tooltip"));
      FlowButton(node_7, {
        style: [
          "clipped-alt",
          "-widthfull",
          "la-bckg-tabs",
          "-padding0"
        ],
        get text() {
          return get$1(expression_16);
        },
        get uuid() {
          return actor.uuid;
        },
        get flowClass() {
          return FlowClass.Standard;
        },
        flowType: "FullRepair",
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_17);
        },
        get tooltip() {
          return get$1(expression_18);
        },
        get tooltipDirection() {
          return TooltipDirection.LEFT;
        },
        get logText() {
          return get$1(expression_19);
        },
        get logType() {
          return TextLogHook.MechHeader;
        },
        get logTypeReset() {
          return TextLogHook.MechHeaderReset;
        }
      });
      var div_15 = sibling(div_14, 2), node_8 = child(div_15);
      const expression_20 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.overcharge.label")), expression_21 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_22 = /* @__PURE__ */ derived(() => getLocalized("LA.action.overcharge.label"));
      FlowButton(node_8, {
        style: ["clipped", "-widthfull", "la-bckg-secondary"],
        get text() {
          return get$1(expression_20);
        },
        get uuid() {
          return actor.uuid;
        },
        get flowClass() {
          return FlowClass.Standard;
        },
        flowType: "Overcharge",
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_21);
        },
        get tooltipHeader() {
          return get$1(expression_22);
        },
        tooltip: overchargeText,
        get tooltipDirection() {
          return TooltipDirection.LEFT;
        },
        logText: overchargeText,
        get logType() {
          return TextLogHook.MechHeader;
        },
        get logTypeReset() {
          return TextLogHook.MechHeaderReset;
        }
      });
      var node_9 = sibling(node_8, 2);
      const expression_23 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.overchargeReset.label")), expression_24 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_25 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.overchargeReset.tooltip")), expression_26 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.overchargeReset.tooltip"));
      FlowButton(node_9, {
        style: ["clipped", "-widthfull", "la-bckg-secondary"],
        get text() {
          return get$1(expression_23);
        },
        get uuid() {
          return actor.uuid;
        },
        get flowClass() {
          return FlowClass.ResetOvercharge;
        },
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_24);
        },
        get tooltip() {
          return get$1(expression_25);
        },
        get tooltipDirection() {
          return TooltipDirection.LEFT;
        },
        get logText() {
          return get$1(expression_26);
        },
        get logType() {
          return TextLogHook.MechHeader;
        },
        get logTypeReset() {
          return TextLogHook.MechHeaderReset;
        }
      });
      var node_10 = sibling(node_9, 2);
      const expression_27 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.stabilize.label")), expression_28 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_29 = /* @__PURE__ */ derived(() => getLocalized("LA.action.full.label")), expression_30 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.stabilize.tooltip")), expression_31 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.stabilize.tooltip"));
      FlowButton(node_10, {
        style: ["clipped", "-widthfull", "la-bckg-secondary"],
        get text() {
          return get$1(expression_27);
        },
        get uuid() {
          return actor.uuid;
        },
        get flowClass() {
          return FlowClass.Standard;
        },
        flowType: "Stabilize",
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_28);
        },
        get tooltipHeader() {
          return get$1(expression_29);
        },
        get tooltip() {
          return get$1(expression_30);
        },
        get tooltipDirection() {
          return TooltipDirection.LEFT;
        },
        get logText() {
          return get$1(expression_31);
        },
        get logType() {
          return TextLogHook.MechHeader;
        },
        get logTypeReset() {
          return TextLogHook.MechHeaderReset;
        }
      });
      var node_11 = sibling(node_10, 2);
      const expression_32 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.extinguish.label")), expression_33 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_34 = /* @__PURE__ */ derived(() => getLocalized("LA.action.endofturn.label")), expression_35 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.extinguish.tooltip")), expression_36 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.extinguish.tooltip"));
      FlowButton(node_11, {
        style: ["clipped", "-widthfull", "la-bckg-secondary"],
        get text() {
          return get$1(expression_32);
        },
        get uuid() {
          return actor.uuid;
        },
        get flowClass() {
          return FlowClass.Standard;
        },
        flowType: "Burn",
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_33);
        },
        get tooltipHeader() {
          return get$1(expression_34);
        },
        get tooltip() {
          return get$1(expression_35);
        },
        get tooltipDirection() {
          return TooltipDirection.LEFT;
        },
        get logText() {
          return get$1(expression_36);
        },
        get logType() {
          return TextLogHook.MechHeader;
        },
        get logTypeReset() {
          return TextLogHook.MechHeaderReset;
        }
      }), template_effect(
        ($0, $1, $2, $3, $4, $5) => {
          set_text(text2, $0), set_value(input, system.structure.value), set_text(text_1, system.structure.max), set_text(text_2, $1), set_value(input_1, system.repairs.value), set_text(text_3, system.repairs.max), set_text(text_4, $2), set_value(input_2, system.stress.value), set_text(text_5, system.stress.max), set_text(text_6, $3), set_value(input_3, system.burn), set_text(text_7, ` ${$4 ?? ""} `), set_text(text_8, $5);
        },
        [
          () => getLocalized("LA.structure.label"),
          () => getLocalized("LA.flow.repair.label"),
          () => getLocalized("LA.stress.label"),
          () => getLocalized("LA.burn.label"),
          () => getCurrentOvercharge(actor),
          () => getLocalized("LA.flow.overcharge.label")
        ]
      ), event("focus", input, (event2) => event2.currentTarget.select()), event("focus", input_1, (event2) => event2.currentTarget.select()), event("focus", input_2, (event2) => event2.currentTarget.select()), event("focus", input_3, (event2) => event2.currentTarget.select()), append($$anchor2, div_1);
    }, "children"),
    $$slots: { default: !0 }
  }), append($$anchor, div), pop();
}
__name(Status$1, "Status$1");
delegate(["change"]);
var CounterBoxType = /* @__PURE__ */ ((CounterBoxType2) => (CounterBoxType2.Counter = "counter-hex", CounterBoxType2.Limited = "uses-hex", CounterBoxType2.Loaded = "la-loaded-hex", CounterBoxType2.Charged = "charged-hex", CounterBoxType2))(CounterBoxType || {});
const ACTIVATION_LOCALIZE_MAP = {
  Full: "LA.action.full.label",
  Quick: "LA.action.quick.label",
  Reaction: "LA.action.reaction.label",
  Protocol: "LA.action.protocol.label",
  Free: "LA.action.free.label",
  "Full Tech": "LA.action.fullTech.label",
  "Quick Tech": "LA.action.quickTech.label",
  Invade: "LA.action.invade.label"
}, ACTIVATION_TOOLTIP_LOCALIZE_MAP = {
  Full: "LA.action.full.tooltip",
  Quick: "LA.action.quick.tooltip",
  Reaction: "LA.action.reaction.tooltip",
  Protocol: "LA.action.protocol.tooltip",
  Free: "LA.action.free.tooltip",
  "Full Tech": "LA.action.fullTech.tooltip",
  "Quick Tech": "LA.action.quickTech.tooltip",
  Invade: "LA.action.invade.tooltip"
}, ACTIVATION_ICON_MAP = {
  Full: "cci-activation-full",
  Quick: "cci-activation-quick",
  Reaction: "cci-reaction",
  Protocol: "cci-protocol",
  Free: "cci-free-action",
  "Full Tech": "cci-tech-full",
  "Quick Tech": "cci-tech-quick",
  Invade: "cci-tech-quick"
}, ACTIVATION_COLOR_MAP = {
  Full: "la-bckg-action--full",
  Quick: "la-bckg-action--quick",
  Reaction: "la-bckg-npc--reaction",
  Protocol: "la-bckg-action--protocol",
  Free: "la-bckg-action--free",
  "Full Tech": "la-bckg-action--tech",
  "Quick Tech": "la-bckg-action--tech",
  Invade: "la-bckg-action--tech",
  Passive: "la-bckg-repcap"
}, SYSTEM_ICON_MAP = {
  Deployable: "cci-deployable",
  Drone: "cci-drone",
  Mod: "cci-mod",
  System: "cci-system",
  Tech: "cci-tech-quick"
}, MOUNT_LOCALIZE_MAP = {
  Main: "LA.mech.mount.main.label",
  Heavy: "LA.mech.mount.heavy.label",
  "Aux/Aux": "LA.mech.mount.auxAux.label",
  Aux: "LA.mech.mount.aux.label",
  "Main/Aux": "LA.mech.mount.mainAux.label",
  Flex: "LA.mech.mount.flex.label",
  Integrated: "LA.mech.mount.integrated.label",
  Superheavy: "LA.mech.mount.superheavy.label",
  Unknown: "LA.mech.mount.unknown.label"
}, MOUNT_FITTINGS = {
  Main: ["Main"],
  Heavy: ["Heavy"],
  "Aux/Aux": ["Auxiliary", "Auxiliary"],
  Aux: ["Auxiliary"],
  "Main/Aux": ["Main", "Auxiliary"],
  Flex: ["Flex"],
  Integrated: ["Integrated"],
  Superheavy: ["Superheavy"],
  Unknown: ["Integrated"]
}, SLOT_LOCALIZE_MAP = {
  Auxiliary: "LA.mech.slot.aux.label",
  Main: "LA.mech.slot.main.label",
  Flex: "LA.mech.slot.flex.label",
  Heavy: "LA.mech.slot.heavy.label",
  Superheavy: "LA.mech.slot.superheavy.label",
  Integrated: "LA.mech.slot.integrated.label"
}, SYSTEM_LOCALIZE_MAP = {
  Deployable: "LA.mech.system.deployable.label",
  Drone: "LA.mech.system.drone.label",
  Mod: "LA.mech.system.mod.label",
  System: "LA.mech.system.system.label",
  Tech: "LA.mech.system.tech.label"
}, RESERVE_ICON_MAP = {
  Resources: "cci-orbit",
  Tactical: "cci-reserve-tac",
  Mech: "cci-reserve-mech",
  Project: "cci-ship",
  Organization: "cci-orbital",
  Bonus: "cci-npc-feature"
};
var root_2$h = /* @__PURE__ */ template('<button type="button" class="fas fa-edit popout-text-edit-button -padding0-l"></button>'), root_1$o = /* @__PURE__ */ template('<div><span class="la-effectbox__span clipped-bot la-bckg-primary la-text-header -fontsize0"> <!></span> <!> <span><!> <!></span></div>');
function EffectBox($$anchor, $$props) {
  push($$props, !0);
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent_3 = /* @__PURE__ */ __name(($$anchor2) => {
      var div = root_1$o(), span = child(div), text2 = child(span), node_1 = sibling(text2);
      {
        var consequent = /* @__PURE__ */ __name(($$anchor3) => {
          var button = root_2$h();
          template_effect(
            ($0) => {
              set_attribute(button, "data-path", $$props.editPath), set_attribute(button, "aria-label", $0);
            },
            [() => getLocalized("LA.edit.label")]
          ), append($$anchor3, button);
        }, "consequent");
        if_block(node_1, ($$render) => {
          $$props.editOption && $$render(consequent);
        });
      }
      var node_2 = sibling(span, 2);
      {
        var consequent_1 = /* @__PURE__ */ __name(($$anchor3) => {
          const expression = /* @__PURE__ */ derived(() => getLocalized("LA.use.label"));
          FlowButton($$anchor3, {
            get text() {
              return get$1(expression);
            },
            get flowClass() {
              return FlowClass.SendEffectToChat;
            },
            get tooltipEnabled() {
              return $$props.tooltipEnabled;
            },
            get tooltipTheme() {
              return $$props.tooltipTheme;
            },
            get logType() {
              return $$props.logType;
            },
            get logTypeReset() {
              return $$props.logTypeReset;
            }
          });
        }, "consequent_1");
        if_block(node_2, ($$render) => {
          $$props.hasFlow && $$render(consequent_1);
        });
      }
      var span_1 = sibling(node_2, 2), node_3 = child(span_1);
      html(node_3, () => $$props.effect);
      var node_4 = sibling(node_3, 2);
      {
        var consequent_2 = /* @__PURE__ */ __name(($$anchor3) => {
          var fragment_2 = comment(), node_5 = first_child(fragment_2);
          snippet(node_5, () => $$props.children), append($$anchor3, fragment_2);
        }, "consequent_2");
        if_block(node_4, ($$render) => {
          $$props.children && $$render(consequent_2);
        });
      }
      template_effect(
        ($0, $1) => {
          set_class(div, `la-effectbox la-bckg-card la-brdr-repcap -widthfull -fontsize1 -bordersround-ltb ${$0 ?? ""}`), set_text(text2, $$props.name), set_class(span_1, $1);
        },
        [
          () => {
            var _a;
            return (_a = $$props.outerStyle) == null ? void 0 : _a.join(" ");
          },
          () => {
            var _a;
            return (_a = $$props.innerStyle) == null ? void 0 : _a.join(" ");
          }
        ]
      ), append($$anchor2, div);
    }, "consequent_3");
    if_block(node, ($$render) => {
      ($$props.effect || $$props.children) && $$render(consequent_3);
    });
  }
  append($$anchor, fragment), pop();
}
__name(EffectBox, "EffectBox");
const H4_ROOT_STYLE = " la-bckg-card ", H4_BORDER_STYLE = " la-brdr-repcap -bordersround-ltb -bordersround ";
var root$G = /* @__PURE__ */ template('<div><div><div class="-flexthird -justifystart"><!></div> <div class="-flexthird -justifycenter"><!></div> <div class="la-combine-h -flexthird -justifyend -height3"><!></div></div> <!> <div><!></div></div>');
function HeaderQuinary($$anchor, $$props) {
  push($$props, !0);
  let isCollapsed = /* @__PURE__ */ derived(() => getCollapseState($$props.collapseID) ?? $$props.startCollapsed ?? !1);
  onMount(() => {
    $$props.collapseID && ($$props.dontSaveCollapse ?? getCollapseState($$props.collapseID) === void 0) && setCollapseState($$props.collapseID, $$props.startCollapsed ?? !1);
  });
  function toggleCollapse(event2) {
    event2.stopPropagation(), $$props.collapseID && setCollapseState($$props.collapseID, !get$1(isCollapsed));
  }
  __name(toggleCollapse, "toggleCollapse");
  function getExtensionText() {
    if ($$props.extensionTextFunction && $$props.extensionTextFunction()) return $$props.extensionTextFunction();
    if ($$props.extensionText) return $$props.extensionText;
    if ($$props.collapseID) return get$1(isCollapsed) ? `--${getLocalized("LA.expand.label")}` : `--${getLocalized("LA.collapse.label")}`;
  }
  __name(getExtensionText, "getExtensionText");
  var div = root$G();
  set_attribute(div, "draggable", !0);
  var div_1 = child(div), div_2 = child(div_1), node = child(div_2);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment = comment(), node_1 = first_child(fragment);
      snippet(node_1, () => $$props.contentLeft), append($$anchor2, fragment);
    }, "consequent");
    if_block(node, ($$render) => {
      $$props.contentLeft && $$render(consequent);
    });
  }
  var div_3 = sibling(div_2, 2), node_2 = child(div_3);
  const expression = /* @__PURE__ */ derived(() => $$props.text || getLocalized("LA.placeholder")), expression_1 = /* @__PURE__ */ derived(getExtensionText);
  TerminalText(node_2, {
    get text() {
      return get$1(expression);
    },
    get textStyle() {
      return $$props.textStyle;
    },
    get extensionText() {
      return get$1(expression_1);
    }
  });
  var div_4 = sibling(div_3, 2), node_3 = child(div_4);
  {
    var consequent_1 = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment_1 = comment(), node_4 = first_child(fragment_1);
      snippet(node_4, () => $$props.contentRight), append($$anchor2, fragment_1);
    }, "consequent_1");
    if_block(node_3, ($$render) => {
      $$props.contentRight && $$render(consequent_1);
    });
  }
  var node_5 = sibling(div_1, 2);
  {
    var consequent_2 = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment_2 = comment(), node_6 = first_child(fragment_2);
      snippet(node_6, () => $$props.renderOutsideCollapse), append($$anchor2, fragment_2);
    }, "consequent_2");
    if_block(node_5, ($$render) => {
      $$props.renderOutsideCollapse && $$render(consequent_2);
    });
  }
  var div_5 = sibling(node_5, 2), node_7 = child(div_5);
  {
    var consequent_3 = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment_3 = comment(), node_8 = first_child(fragment_3);
      snippet(node_8, () => $$props.children), append($$anchor2, fragment_3);
    }, "consequent_3");
    if_block(node_7, ($$render) => {
      $$props.children && $$render(consequent_3);
    });
  }
  template_effect(
    ($0, $1, $2) => {
      set_class(div, `la-effectbox -largeheader la-collapsegroup la-combine-v -widthfull 
        ${$0 ?? ""}
        ${$1 ?? ""}
        ${($$props.acceptTypes ? `ref set drop-settable ${$$props.acceptTypes}` : "") ?? ""}
        collapse-group`), set_attribute(div, "data-item-id", $$props.itemID), set_attribute(div, "data-uuid", $$props.uuid), set_attribute(div, "data-path", $$props.path), set_attribute(div, "data-accept-types", $$props.acceptTypes), set_class(div_1, `la-actionheader la-summary la-combine-h la-text-header clipped -aligncenter
            ${$2 ?? ""}
            ${($$props.collapseID ? "collapse-trigger" : "") ?? ""}`), set_attribute(div_1, "data-la-collapse-id", $$props.collapseID), set_class(div_5, `la-collapsegroup__wrapper -widthfull
            ${($$props.collapseID ? "collapse-wrapper" : "") ?? ""} ${(get$1(isCollapsed) ? "collapsed" : "") ?? ""}`), set_attribute(div_5, "data-la-collapse-id", $$props.collapseID);
    },
    [
      () => {
        var _a;
        return ((_a = $$props.rootStyle) == null ? void 0 : _a.join(" ")) || H4_ROOT_STYLE;
      },
      () => {
        var _a;
        return ((_a = $$props.borderStyle) == null ? void 0 : _a.join(" ")) || H4_BORDER_STYLE;
      },
      () => {
        var _a;
        return (_a = $$props.headerStyle) == null ? void 0 : _a.join(" ");
      }
    ]
  ), event("click", div_1, (event2) => toggleCollapse(event2)), append($$anchor, div), pop();
}
__name(HeaderQuinary, "HeaderQuinary");
enable_legacy_mode_flag();
const CLICKABLE_HOVER = "la-scdy-primary -glow-scdy-hover la-prmy-header -glow-prmy", _ICON_BG_STYLE$2 = `${H2_ICON_SIZE} la-text-scrollbar-secondary -padding0-l`, _ICON_STYLE$1 = `${H2_ICON_SIZE}`;
var root_1$n = /* @__PURE__ */ template('<i style="z-index: -1;"></i>'), root$F = /* @__PURE__ */ template('<button type="button" style="z-index: 1;"><i></i> <!></button>');
function EffectButton($$anchor, $$props) {
  push($$props, !0);
  const tip = TooltipFactory.buildTooltip($$props.tooltip || getLocalized("LA.flow.effect.tooltip"), $$props.tooltipHeader), logging = $$props.logType && $$props.logTypeReset, log = $$props.logText || getLocalized("LA.flow.effect.tooltip");
  function handleOnPointerEnter(event2) {
    if ($$props.onPointerEnter && $$props.onPointerEnter(), logging) sendToLog(event2, log, $$props.logType);
    else return;
  }
  __name(handleOnPointerEnter, "handleOnPointerEnter");
  function handleOnPointerLeave(event2) {
    if ($$props.onPointerLeave && $$props.onPointerLeave(), logging) resetLog(event2, $$props.logTypeReset);
    else return;
  }
  __name(handleOnPointerLeave, "handleOnPointerLeave");
  var button = root$F();
  button.__click = function(...$$args) {
    var _a;
    (_a = $$props.onClick ? (event2) => $$props.onClick(event2) : void 0) == null || _a.apply(this, $$args);
  };
  var i2 = child(button), node = sibling(i2, 2);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var i_1 = root_1$n();
      template_effect(
        ($0) => set_class(i_1, `fal fa-dice-d20 -positionabsolute -left0 
            ${$0 ?? ""}`),
        [
          () => {
            var _a;
            return ((_a = $$props.iconBackgroundStyle) == null ? void 0 : _a.join(" ")) || _ICON_BG_STYLE$2;
          }
        ]
      ), append($$anchor2, i_1);
    }, "consequent");
    if_block(node, ($$render) => {
      $$props.disabled || $$render(consequent);
    });
  }
  template_effect(
    ($0, $1, $2) => {
      set_class(button, `-positionrelative
        ${$0 ?? ""}
        ${($$props.flowClass || FlowClass.SendEffectToChat) ?? ""}`), set_attribute(button, "data-uuid", $$props.uuid), set_attribute(button, "data-path", $$props.path), set_attribute(button, "data-power-index", $$props.powerIndex), set_attribute(button, "data-tooltip", $$props.tooltipEnabled && !$$props.disabled ? tip : void 0), set_attribute(button, "data-tooltip-class", `${$$props.tooltipClass || "clipped-bot la-tooltip"} ${$$props.tooltipTheme}`), set_attribute(button, "data-tooltip-direction", $$props.tooltipDirection || TooltipDirection.UP), set_attribute(button, "aria-label", $1), button.disabled = $$props.disabled || !1, set_class(i2, `
            ${($$props.disabled ? "" : CLICKABLE_HOVER) ?? ""}
            ${$2 ?? ""}`);
    },
    [
      () => {
        var _a;
        return (_a = $$props.style) == null ? void 0 : _a.join(" ");
      },
      () => $$props.tooltip || getLocalized("LA.flow.effect.tooltip"),
      () => {
        var _a;
        return ((_a = $$props.iconStyle) == null ? void 0 : _a.join(" ")) || _ICON_STYLE$1;
      }
    ]
  ), event("pointerenter", button, handleOnPointerEnter), event("pointerleave", button, handleOnPointerLeave), append($$anchor, button), pop();
}
__name(EffectButton, "EffectButton");
delegate(["click"]);
var root_7$i = /* @__PURE__ */ template('<button type="button" class="la-actionheader__button mdi mdi-pencil -fontsize3"></button> <button class="la-actionheader__button mdi mdi-delete -fontsize3" data-action="splice"></button>', 1), root_12$3 = /* @__PURE__ */ template('<!> <hr class="-widthfull">', 1), root_11$9 = /* @__PURE__ */ template("<!> <!>", 1), root_10$c = /* @__PURE__ */ template('<div class="-fontsize1"><div class="la-divider-h la-bckg-primary -margin0-tb -margin2-b"></div> <!> <!> <!></div>'), root_16$3 = /* @__PURE__ */ template('<!> <hr class="-widthfull">', 1), root_15$3 = /* @__PURE__ */ template('<div class="-fontsize1"><div class="la-divider-h la-bckg-primary -margin0-tb -margin2-b"></div> <!> <!> <!></div>');
function ActionBox($$anchor, $$props) {
  push($$props, !0);
  let effectButtonHover = state(!1);
  const defaultPlaceholder = getLocalized("LA.placeholder");
  function getActivationClass(activation) {
    return `activation-${slugify(activation, "-")}`;
  }
  __name(getActivationClass, "getActivationClass");
  function getActivationName(activation) {
    return `${getLocalized("LA.use.label")} ${getLocalized(ACTIVATION_LOCALIZE_MAP[activation])}`;
  }
  __name(getActivationName, "getActivationName");
  function getReactionTooltip(action) {
    return action.trigger ? `
                ${getLocalized("LA.trigger.label")}: ${action.trigger}
                <br><br>
                ${getLocalized("LA.mech.system.effect.label")}: ${action.detail}
                <br><br>
                ${getLocalized(ACTIVATION_TOOLTIP_LOCALIZE_MAP[action.activation])}` : `${action.detail}<br><br>${getLocalized(ACTIVATION_TOOLTIP_LOCALIZE_MAP[action.activation])}`;
  }
  __name(getReactionTooltip, "getReactionTooltip");
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent_7 = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment_1 = comment(), node_1 = first_child(fragment_1);
      each(node_1, 17, () => $$props.actions, index, ($$anchor3, action, index2) => {
        const defaultFlowButton = /* @__PURE__ */ __name(($$anchor4) => {
          const expression = /* @__PURE__ */ derived(() => getActivationName(get$1(action).activation)), expression_1 = /* @__PURE__ */ derived(() => [
            "clipped-bot",
            ACTIVATION_COLOR_MAP[get$1(action).activation]
          ]), expression_2 = /* @__PURE__ */ derived(() => `${$$props.path}.${index2}`), expression_3 = /* @__PURE__ */ derived(() => get$1(action) && $$props.uuid && $$props.path ? `${FlowClass.CoreActivation} ${getActivationClass(get$1(action).activation)}` : getActivationClass(get$1(action).activation)), expression_4 = /* @__PURE__ */ derived(() => getLocalized(ACTIVATION_LOCALIZE_MAP[get$1(action).activation])), expression_5 = /* @__PURE__ */ derived(() => getLocalized(ACTIVATION_TOOLTIP_LOCALIZE_MAP[get$1(action).activation]));
          FlowButton($$anchor4, {
            get text() {
              return get$1(expression);
            },
            get style() {
              return get$1(expression_1);
            },
            get uuid() {
              return $$props.uuid;
            },
            get path() {
              return get$1(expression_2);
            },
            get flowClass() {
              return get$1(expression_3);
            },
            get tooltipEnabled() {
              return $$props.tooltipEnabled;
            },
            get tooltipTheme() {
              return $$props.tooltipTheme;
            },
            tooltipDirection: void 0,
            get tooltipHeader() {
              return get$1(expression_4);
            },
            get tooltip() {
              return get$1(expression_5);
            },
            get logType() {
              return $$props.logType;
            },
            get logTypeReset() {
              return $$props.logTypeReset;
            }
          });
        }, "defaultFlowButton"), outercontent = /* @__PURE__ */ __name(($$anchor4) => {
          var fragment_3 = comment(), node_2 = first_child(fragment_3);
          {
            var consequent = /* @__PURE__ */ __name(($$anchor5) => {
              var fragment_4 = comment(), node_3 = first_child(fragment_4);
              snippet(node_3, () => $$props.flowButton), append($$anchor5, fragment_4);
            }, "consequent");
            if_block(node_2, ($$render) => {
              $$props.flowButton && $$render(consequent);
            });
          }
          append($$anchor4, fragment_3);
        }, "outercontent"), headerQuinaryRightOptions = /* @__PURE__ */ __name(($$anchor4) => {
          var fragment_5 = comment(), node_4 = first_child(fragment_5);
          {
            var consequent_1 = /* @__PURE__ */ __name(($$anchor5) => {
              var fragment_6 = root_7$i(), button = first_child(fragment_6), button_1 = sibling(button, 2);
              template_effect(
                ($0, $1) => {
                  set_attribute(button, "aria-label", $0), set_attribute(button_1, "data-uuid", $$props.uuid), set_attribute(button_1, "data-path", $$props.path), set_attribute(button_1, "aria-label", $1);
                },
                [
                  () => getLocalized("LA.edit.label"),
                  () => getLocalized("LA.delete.label")
                ]
              ), append($$anchor5, fragment_6);
            }, "consequent_1");
            if_block(node_4, ($$render) => {
              $$props.editable && $$render(consequent_1);
            });
          }
          append($$anchor4, fragment_5);
        }, "headerQuinaryRightOptions"), headerQuinaryLeftOptions = /* @__PURE__ */ __name(($$anchor4) => {
          const expression_6 = /* @__PURE__ */ derived(() => [
            H2_ICON_SIZE,
            ACTIVATION_ICON_MAP[get$1(action).activation]
          ]), expression_7 = /* @__PURE__ */ derived(() => $$props.onClick ? FlowClass.None : get$1(action) && $$props.uuid && $$props.path ? `${FlowClass.CoreActivation} ${getActivationClass(get$1(action).activation)}` : getActivationClass(get$1(action).activation)), expression_8 = /* @__PURE__ */ derived(() => `${$$props.path}.${index2}`), expression_9 = /* @__PURE__ */ derived(() => $$props.onClick ? (event2) => $$props.onClick(event2, get$1(action)) : void 0), expression_10 = /* @__PURE__ */ derived(() => getLocalized(ACTIVATION_LOCALIZE_MAP[get$1(action).activation])), expression_11 = /* @__PURE__ */ derived(() => getReactionTooltip(get$1(action)));
          EffectButton($$anchor4, {
            style: [
              "-positionabsolute",
              "-left0",
              "-top0",
              "-padding0-l"
            ],
            get iconStyle() {
              return get$1(expression_6);
            },
            iconBackgroundStyle: [
              H2_ICON_SIZE,
              "-padding0-l",
              "la-prmy-secondary",
              "-pulse-prmy"
            ],
            get flowClass() {
              return get$1(expression_7);
            },
            get uuid() {
              return $$props.uuid;
            },
            get path() {
              return get$1(expression_8);
            },
            get onClick() {
              return get$1(expression_9);
            },
            get tooltipEnabled() {
              return $$props.tooltipEnabled;
            },
            get tooltipTheme() {
              return $$props.tooltipTheme;
            },
            get tooltipHeader() {
              return get$1(expression_10);
            },
            get tooltip() {
              return get$1(expression_11);
            },
            get tooltipDirection() {
              return TooltipDirection.LEFT;
            },
            get logType() {
              return $$props.logType;
            },
            get logTypeReset() {
              return $$props.logTypeReset;
            },
            get disabled() {
              return $$props.disableLeftButton;
            },
            onPointerEnter: /* @__PURE__ */ __name(() => {
              set(effectButtonHover, !0);
            }, "onPointerEnter"),
            onPointerLeave: /* @__PURE__ */ __name(() => {
              set(effectButtonHover, !1);
            }, "onPointerLeave")
          });
        }, "headerQuinaryLeftOptions"), expression_12 = /* @__PURE__ */ derived(() => [
          ACTIVATION_COLOR_MAP[get$1(action).activation],
          "-padding0-l"
        ]), expression_13 = /* @__PURE__ */ derived(() => `${$$props.path}.${index2}`), expression_14 = /* @__PURE__ */ derived(() => `${$$props.collapseID}.${index2}`);
        HeaderQuinary($$anchor3, {
          get text() {
            return get$1(action).name;
          },
          get headerStyle() {
            return get$1(expression_12);
          },
          textStyle: [
            "la-text-header",
            "la-prmy-header",
            "-lineheight5"
          ],
          extensionTextFunction: /* @__PURE__ */ __name(() => {
            if (get$1(effectButtonHover)) return `--${getLocalized("LA.chat.extension")}`;
          }, "extensionTextFunction"),
          get uuid() {
            return $$props.uuid;
          },
          get path() {
            return get$1(expression_13);
          },
          get collapseID() {
            return get$1(expression_14);
          },
          get startCollapsed() {
            return $$props.startCollapsed;
          },
          contentLeft: headerQuinaryLeftOptions,
          contentRight: headerQuinaryRightOptions,
          renderOutsideCollapse: outercontent,
          children: /* @__PURE__ */ __name(($$anchor4, $$slotProps) => {
            var fragment_9 = comment(), node_5 = first_child(fragment_9);
            {
              var consequent_4 = /* @__PURE__ */ __name(($$anchor5) => {
                var div = root_10$c(), node_6 = sibling(child(div), 2);
                const expression_15 = /* @__PURE__ */ derived(() => getLocalized("LA.trigger.label"));
                EffectBox(node_6, {
                  get name() {
                    return get$1(expression_15);
                  },
                  outerStyle: ["-bordersround"],
                  get tooltipEnabled() {
                    return $$props.tooltipEnabled;
                  },
                  get logType() {
                    return $$props.logType;
                  },
                  get logTypeReset() {
                    return $$props.logTypeReset;
                  },
                  children: /* @__PURE__ */ __name(($$anchor6, $$slotProps2) => {
                    var fragment_10 = root_11$9(), node_7 = first_child(fragment_10);
                    {
                      var consequent_2 = /* @__PURE__ */ __name(($$anchor7) => {
                        var fragment_11 = root_12$3(), node_8 = first_child(fragment_11);
                        defaultFlowButton(node_8), append($$anchor7, fragment_11);
                      }, "consequent_2");
                      if_block(node_7, ($$render) => {
                        $$props.collapseID || $$render(consequent_2);
                      });
                    }
                    var node_9 = sibling(node_7, 2);
                    html(node_9, () => get$1(action).trigger || defaultPlaceholder), append($$anchor6, fragment_10);
                  }, "children"),
                  $$slots: { default: !0 }
                });
                var node_10 = sibling(node_6, 2);
                const expression_16 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.system.effect.label")), expression_17 = /* @__PURE__ */ derived(() => `${$$props.path}.detail`);
                EffectBox(node_10, {
                  get name() {
                    return get$1(expression_16);
                  },
                  outerStyle: ["-bordersround"],
                  get editOption() {
                    return $$props.editDetails;
                  },
                  get editPath() {
                    return get$1(expression_17);
                  },
                  get tooltipEnabled() {
                    return $$props.tooltipEnabled;
                  },
                  get logType() {
                    return $$props.logType;
                  },
                  get logTypeReset() {
                    return $$props.logTypeReset;
                  },
                  children: /* @__PURE__ */ __name(($$anchor6, $$slotProps2) => {
                    var fragment_12 = comment(), node_11 = first_child(fragment_12);
                    html(node_11, () => get$1(action).detail || defaultPlaceholder), append($$anchor6, fragment_12);
                  }, "children"),
                  $$slots: { default: !0 }
                });
                var node_12 = sibling(node_10, 2);
                {
                  var consequent_3 = /* @__PURE__ */ __name(($$anchor6) => {
                    var fragment_13 = comment(), node_13 = first_child(fragment_13);
                    snippet(node_13, () => $$props.children), append($$anchor6, fragment_13);
                  }, "consequent_3");
                  if_block(node_12, ($$render) => {
                    $$props.children && $$render(consequent_3);
                  });
                }
                append($$anchor5, div);
              }, "consequent_4"), alternate = /* @__PURE__ */ __name(($$anchor5) => {
                var div_1 = root_15$3(), node_14 = sibling(child(div_1), 2);
                {
                  var consequent_5 = /* @__PURE__ */ __name(($$anchor6) => {
                    var fragment_14 = root_16$3(), node_15 = first_child(fragment_14);
                    defaultFlowButton(node_15), append($$anchor6, fragment_14);
                  }, "consequent_5");
                  if_block(node_14, ($$render) => {
                    $$props.collapseID || $$render(consequent_5);
                  });
                }
                var node_16 = sibling(node_14, 2);
                const expression_18 = /* @__PURE__ */ derived(() => getLocalized(ACTIVATION_LOCALIZE_MAP[get$1(action).activation]));
                EffectBox(node_16, {
                  get name() {
                    return get$1(expression_18);
                  },
                  outerStyle: ["-bordersround"],
                  get tooltipEnabled() {
                    return $$props.tooltipEnabled;
                  },
                  get logType() {
                    return $$props.logType;
                  },
                  get logTypeReset() {
                    return $$props.logTypeReset;
                  },
                  children: /* @__PURE__ */ __name(($$anchor6, $$slotProps2) => {
                    var fragment_15 = comment(), node_17 = first_child(fragment_15);
                    html(node_17, () => get$1(action).detail || defaultPlaceholder), append($$anchor6, fragment_15);
                  }, "children"),
                  $$slots: { default: !0 }
                });
                var node_18 = sibling(node_16, 2);
                {
                  var consequent_6 = /* @__PURE__ */ __name(($$anchor6) => {
                    var fragment_16 = comment(), node_19 = first_child(fragment_16);
                    snippet(node_19, () => $$props.children), append($$anchor6, fragment_16);
                  }, "consequent_6");
                  if_block(node_18, ($$render) => {
                    $$props.children && $$render(consequent_6);
                  });
                }
                append($$anchor5, div_1);
              }, "alternate");
              if_block(node_5, ($$render) => {
                get$1(action).trigger ? $$render(consequent_4) : $$render(alternate, !1);
              });
            }
            append($$anchor4, fragment_9);
          }, "children"),
          $$slots: { default: !0 }
        });
      }), append($$anchor2, fragment_1);
    }, "consequent_7");
    if_block(node, ($$render) => {
      $$props.actions.length > 0 && $$render(consequent_7);
    });
  }
  append($$anchor, fragment), pop();
}
__name(ActionBox, "ActionBox");
let nanoid = /* @__PURE__ */ __name((size = 21) => crypto.getRandomValues(new Uint8Array(size)).reduce((id2, byte) => (byte &= 63, byte < 36 ? id2 += byte.toString(36) : byte < 62 ? id2 += (byte - 26).toString(36).toUpperCase() : byte > 62 ? id2 += "-" : id2 += "_", id2), ""), "nanoid");
async function renderTemplateStep(actor, template2, templateData, flags) {
  var _a, _b, _c;
  templateData._uuid = nanoid();
  const html2 = await renderTemplate(template2, templateData), aggregate = [];
  return templateData.roll && aggregate.push(templateData.roll), templateData.result && aggregate.push(templateData.result.roll), (((_a = templateData.attack_results) == null ? void 0 : _a.length) ?? 0) > 0 && aggregate.push(...templateData.attack_results.map((a) => a.roll)), (((_b = templateData.crit_damage_results) == null ? void 0 : _b.length) ?? 0) > 0 ? aggregate.push(...templateData.crit_damage_results.map((d) => d.roll)) : (((_c = templateData.damage_results) == null ? void 0 : _c.length) ?? 0) > 0 && aggregate.push(...templateData.damage_results.map((d) => d.roll)), templateData.self_heat_result && aggregate.push(templateData.self_heat_result.roll), createChatMessageStep(actor, html2, aggregate);
}
__name(renderTemplateStep, "renderTemplateStep");
async function createChatMessageStep(actor, html2, rolls, flags) {
  rolls && !Array.isArray(rolls) && (rolls = [rolls]);
  let chat_data = {
    type: 2,
    rolls,
    speaker: {
      actor,
      token: actor == null ? void 0 : actor.token,
      alias: actor != null && actor.token ? actor.token.name : null
    },
    content: html2,
    flags: void 0
  };
  rolls || delete chat_data.rolls;
  const cm = await ChatMessage.implementation.create(chat_data);
  cm == null || cm.render();
}
__name(createChatMessageStep, "createChatMessageStep");
const _SendUnknownToChatBase = class _SendUnknownToChatBase extends FlowBase {
  constructor() {
    super();
  }
  setupFlow() {
    var _a;
    return _a = class extends game.lancer.Flow {
      constructor(uuid, data) {
        super(uuid, {
          title: data.title,
          description: data.description,
          trigger: data.trigger,
          effect: data.effect,
          onHit: data.onHit,
          onCrit: data.onCrit,
          tags: data.tags
        });
      }
    }, __name(_a, "SendUnknownToChat"), __publicField(_a, "steps", ["printFeatureCard"]), _a;
  }
  setupFlowSteps() {
    return [
      this.printFeatureCard
    ];
  }
  /**
   * Starts the flow by creating an instance of the `SendUnknownToChat` class and beginning the flow.
   *
   * @param {string} uuid - All flows require a UUID, though not all will make use of it. The matching item will be included in the data when sent.
   * @param {any} data - The data to pass to the flow
   */
  startFlow(uuid, data) {
    const flows = game.lancer.flows;
    new (flows.get(CustomFlowClass.SendUnknownToChat))(
      uuid,
      data
    ).begin();
  }
  async printFeatureCard(state2, options) {
    if (!state2.data) throw new TypeError("Flow state missing!");
    return renderTemplateStep(
      state2.actor,
      (options == null ? void 0 : options.template) || TEMPLATE_PATHS.featureCard,
      state2.data
    ), !0;
  }
};
__name(_SendUnknownToChatBase, "SendUnknownToChatBase");
let SendUnknownToChatBase = _SendUnknownToChatBase;
var root_3$t = /* @__PURE__ */ template(`<div class="la-effectbox la-bckg-card la-brdr-repcap -widthful -bordersround-ltb
            ref set"><span class="la-effectbox__span clipped-bot la-bckg-primary la-text-header -fontsize0
                click-open -upper"> </span> <div class="la-generated -gap2 la-combine-v"><div class="-fontsize1"><div class="la-effectbox-buttons la-combine-h -justifybetween"><div class="la-combine-v -alignstart"></div> <img class="-height10 click-open la-prmy-secondary -glow-prmy la-scdy-primary -glow-scdy-hover"></div> <hr> <!></div>  <!></div></div>`);
function DeployableBox($$anchor, $$props) {
  push($$props, !0);
  const themeOverride = getThemeKey($$props.sheetUUID), tip = TooltipFactory.buildTooltip(getLocalized("LA.mech.system.deployable.tooltip")), globallyOwnedDeployables = game.actors.filter((a) => {
    var _a;
    return !!(a.is_deployable() && ((_a = a.system.owner) == null ? void 0 : _a.value) == $$props.source);
  });
  function lidSourceHasDeployable(deployable) {
    var _a;
    return ((_a = $$props.lidSource.deployables) == null ? void 0 : _a.includes(deployable.system.lid)) ?? !1;
  }
  __name(lidSourceHasDeployable, "lidSourceHasDeployable");
  const defaultImages = [
    "systems/lancer/assets/icons/deployable.svg",
    "systems/lancer/assets/icons/white/deployable.svg"
  ];
  function getThemeImg(deployable) {
    let theme = getBrightness(themeOverride);
    return deployable.img ? defaultImages.includes(deployable.img) && theme === "dark" ? deployable.img.replace("/icons/", "/icons/white/") : deployable.img : theme === "dark" ? "systems/lancer/assets/icons/white/generic_item.svg" : "systems/lancer/assets/icons/generic_item.svg";
  }
  __name(getThemeImg, "getThemeImg");
  function getDeployableActions(deployable) {
    return [
      {
        label: "LA.mech.system.deployable.activate.label",
        tooltip: "LA.mech.system.deployable.activate.tooltip",
        deployableAction: deployable.system.activation
      },
      {
        label: "LA.mech.system.deployable.deactivate.label",
        tooltip: "LA.mech.system.deployable.deactivate.tooltip",
        deployableAction: deployable.system.deactivation
      },
      {
        label: "LA.mech.system.deployable.recall.label",
        tooltip: "LA.mech.system.deployable.recall.tooltip",
        deployableAction: deployable.system.recall
      },
      {
        label: "LA.mech.system.deployable.redeploy.label",
        tooltip: "LA.mech.system.deployable.redeploy.tooltip",
        deployableAction: deployable.system.redeploy
      }
    ].filter((a) => !!a.deployableAction);
  }
  __name(getDeployableActions, "getDeployableActions");
  function sendActionToChat(event2, action) {
    if (event2.stopPropagation(), $$props.uuid && action) {
      let chatData = {
        title: action.name,
        trigger: action.trigger,
        effect: action.detail
      };
      SendUnknownToChatBase.getInstance().startFlow($$props.uuid, chatData);
    }
  }
  __name(sendActionToChat, "sendActionToChat");
  function sendDeployableActionToChat(event2, action, deployable) {
    if (event2.stopPropagation(), $$props.uuid && action) {
      const description = `${getLocalized(ACTIVATION_LOCALIZE_MAP[action.deployableAction])}: ${getLocalized(action.tooltip)}`;
      let chatData = { title: deployable.name, description };
      SendUnknownToChatBase.getInstance().startFlow($$props.uuid, chatData);
    }
  }
  __name(sendDeployableActionToChat, "sendDeployableActionToChat");
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent_2 = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment_1 = comment(), node_1 = first_child(fragment_1);
      each(node_1, 17, () => globallyOwnedDeployables, index, ($$anchor3, deployable) => {
        var fragment_2 = comment(), node_2 = first_child(fragment_2);
        {
          var consequent_1 = /* @__PURE__ */ __name(($$anchor4) => {
            var div = root_3$t(), span = child(div), text2 = child(span), div_1 = sibling(span, 2), div_2 = child(div_1), div_3 = child(div_2), div_4 = child(div_3);
            each(div_4, 21, () => getDeployableActions(get$1(deployable)), index, ($$anchor5, action) => {
              const expression = /* @__PURE__ */ derived(() => getLocalized(get$1(action).label)), expression_1 = /* @__PURE__ */ derived(() => [
                "clipped-bot",
                "-widthfull",
                ACTIVATION_COLOR_MAP[get$1(action).deployableAction]
              ]), expression_2 = /* @__PURE__ */ derived(() => `deployables.${get$1(deployable).system.lid}`), expression_3 = /* @__PURE__ */ derived(() => getLocalized(ACTIVATION_LOCALIZE_MAP[get$1(action).deployableAction])), expression_4 = /* @__PURE__ */ derived(() => `${getLocalized(get$1(action).tooltip)}<br><br>${getLocalized(ACTIVATION_TOOLTIP_LOCALIZE_MAP[get$1(action).deployableAction])}`);
              FlowButton($$anchor5, {
                get text() {
                  return get$1(expression);
                },
                get style() {
                  return get$1(expression_1);
                },
                get uuid() {
                  return get$1(deployable).uuid;
                },
                get path() {
                  return get$1(expression_2);
                },
                get flowClass() {
                  return FlowClass.None;
                },
                onClick: /* @__PURE__ */ __name((event2) => sendDeployableActionToChat(event2, get$1(action), get$1(deployable)), "onClick"),
                get tooltipEnabled() {
                  return $$props.tooltipEnabled;
                },
                get tooltipTheme() {
                  return $$props.tooltipTheme;
                },
                get tooltipDirection() {
                  return TooltipDirection.LEFT;
                },
                get tooltipHeader() {
                  return get$1(expression_3);
                },
                get tooltip() {
                  return get$1(expression_4);
                },
                get logType() {
                  return $$props.logType;
                },
                get logTypeReset() {
                  return $$props.logTypeReset;
                }
              });
            });
            var img = sibling(div_4, 2), node_3 = sibling(div_3, 4);
            html(node_3, () => get$1(deployable).system.detail);
            var node_4 = sibling(div_2, 2);
            {
              var consequent = /* @__PURE__ */ __name(($$anchor5) => {
                const expression_5 = /* @__PURE__ */ derived(() => `${get$1(deployable).uuid}.actions`), expression_6 = /* @__PURE__ */ derived(() => $$props.uuid || get$1(deployable).uuid), expression_7 = /* @__PURE__ */ derived(() => !$$props.uuid), expression_8 = /* @__PURE__ */ derived(() => $$props.uuid ? sendActionToChat : void 0);
                ActionBox($$anchor5, {
                  get actions() {
                    return get$1(deployable).system.actions;
                  },
                  get collapseID() {
                    return get$1(expression_5);
                  },
                  startCollapsed: !1,
                  get uuid() {
                    return get$1(expression_6);
                  },
                  get disableLeftButton() {
                    return get$1(expression_7);
                  },
                  get onClick() {
                    return get$1(expression_8);
                  },
                  get tooltipEnabled() {
                    return $$props.tooltipEnabled;
                  },
                  get tooltipTheme() {
                    return $$props.tooltipTheme;
                  },
                  get logType() {
                    return $$props.logType;
                  },
                  get logTypeReset() {
                    return $$props.logTypeReset;
                  }
                });
              }, "consequent");
              if_block(node_4, ($$render) => {
                get$1(deployable).system.actions.length && $$render(consequent);
              });
            }
            template_effect(
              ($0, $1) => {
                set_attribute(div, "data-uuid", get$1(deployable).uuid), set_text(text2, get$1(deployable).name ? get$1(deployable).name : ""), set_attribute(img, "src", $0), set_attribute(img, "alt", $1), set_attribute(img, "data-tooltip", $$props.tooltipEnabled ? tip : void 0), set_attribute(img, "data-tooltip-class", `${$$props.tooltipClass || "clipped-bot la-tooltip"} ${$$props.tooltipTheme}`), set_attribute(img, "data-tooltip-direction", TooltipDirection.LEFT);
              },
              [
                () => getThemeImg(get$1(deployable)),
                () => getLocalized("LA.placeholder")
              ]
            ), event("pointerenter", img, function(...$$args) {
              var _a;
              (_a = $$props.logType ? (event2) => sendToLog(event2, getLocalized("LA.mech.system.deployable.tooltip"), $$props.logType) : void 0) == null || _a.apply(this, $$args);
            }), event("pointerleave", img, function(...$$args) {
              var _a;
              (_a = $$props.logTypeReset ? (event2) => resetLog(event2, $$props.logTypeReset) : void 0) == null || _a.apply(this, $$args);
            }), append($$anchor4, div);
          }, "consequent_1");
          if_block(node_2, ($$render) => {
            lidSourceHasDeployable(get$1(deployable)) && $$render(consequent_1);
          });
        }
        append($$anchor3, fragment_2);
      }), append($$anchor2, fragment_1);
    }, "consequent_2");
    if_block(node, ($$render) => {
      $$props.source && !$$props.source.is_deployable() && !$$props.source.isToken && $$render(consequent_2);
    });
  }
  append($$anchor, fragment), pop();
}
__name(DeployableBox, "DeployableBox");
var root_3$s = /* @__PURE__ */ template('<div class="la-combine-h -widthfull -margin0-t"><button type="button"><i class="la-corepower__i cci cci-activate la-dropshadow -flexthird -textalignleft -height5 -lineheight5 -fontsize13"></i> <span></span> <div class="-flexthird"></div></button></div>'), root_4$9 = /* @__PURE__ */ template('<div class="la-divider-h la-bckg-primary -margin0-tb -margin2-b"></div> <!> <!> <!>', 1);
function FrameActivePower($$anchor, $$props) {
  push($$props, !0);
  const tooltipEnabled = getMechSheetTooltipEnabled(), frame = $$props.system.loadout.frame.value, core = frame.system.core_system, collID = `${$$props.actor.uuid}.${frame.id}.activePower`, actionCollID = `${$$props.actor.uuid}.${frame.id}.activePower.action`, name = core.active_actions.length ? core.active_actions[0].name : getLocalized("LA.activate.label"), activationClass = `activation-${slugify(core.activation, "-")}`, activationTheme = $$props.system.core_energy ? `${ACTIVATION_COLOR_MAP[core.activation]}` : "la-bckg-repcap", frameColorBckg = getManufacturerColor(frame.system.manufacturer, "bckg"), frameColorBrdr = $$props.system.core_energy ? getManufacturerColor(frame.system.manufacturer, "brdr") : "la-brdr-repcap", tip = TooltipFactory.buildTooltip(`${core.active_effect}<br><br>${getLocalized(ACTIVATION_TOOLTIP_LOCALIZE_MAP[core.activation])}`, getLocalized(ACTIVATION_LOCALIZE_MAP[core.activation]));
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      HeaderQuinary($$anchor2, {
        get text() {
          return core.name;
        },
        headerStyle: [frameColorBckg, "-padding0-l"],
        borderStyle: [H4_BORDER_STYLE, frameColorBrdr],
        textStyle: ["la-text-header", "la-prmy-header"],
        collapseID: collID,
        renderOutsideCollapse: /* @__PURE__ */ __name(($$anchor3) => {
          var div = root_3$s(), button = child(div);
          set_attribute(button, "data-path", "system.core_system"), set_attribute(button, "data-tooltip", tip), set_attribute(button, "aria-label", name);
          var span = sibling(child(button), 2);
          span.textContent = name, template_effect(
            ($0) => {
              set_class(button, `la-corepower clipped la-text-header la-combine-h -padding0-tb -fontsize3 -lineheight5 -widthfull 
            ${activationTheme ?? ""} ${($$props.system.core_energy ? "" : "la-dropshadow -disabled") ?? ""} 
            activation-flow ${activationClass ?? ""}`), set_attribute(button, "data-uuid", frame.uuid), set_attribute(button, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(button, "data-tooltip-direction", TooltipDirection.LEFT), button.disabled = !$$props.system.core_energy, set_class(span, `la-corepower__span ${($$props.system.core_energy ? "la-prmy-header -glow-prmy la-scdy-primary -glow-scdy-hover" : "la-dropshadow") ?? ""} -upper -flexthird -textwrapnowrap`);
            },
            [
              () => getCSSDocumentTheme($$props.actor.uuid)
            ]
          ), append($$anchor3, div);
        }, "outerContent"),
        contentLeft: /* @__PURE__ */ __name(($$anchor3) => {
          const expression = /* @__PURE__ */ derived(() => [
            H2_ICON_SIZE,
            "cci",
            ACTIVATION_ICON_MAP[core.activation]
          ]), expression_1 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_2 = /* @__PURE__ */ derived(() => getLocalized(ACTIVATION_LOCALIZE_MAP[core.activation])), expression_3 = /* @__PURE__ */ derived(() => $$props.system.core_energy === 0);
          EffectButton($$anchor3, {
            get iconStyle() {
              return get$1(expression);
            },
            iconBackgroundStyle: [
              H2_ICON_SIZE,
              "la-prmy-secondary",
              "-pulse-prmy"
            ],
            get flowClass() {
              return FlowClass.None;
            },
            tooltipEnabled,
            get tooltipTheme() {
              return get$1(expression_1);
            },
            get tooltipDirection() {
              return TooltipDirection.LEFT;
            },
            get tooltipHeader() {
              return get$1(expression_2);
            },
            get logType() {
              return TextLogHook.MechHeader;
            },
            get logTypeReset() {
              return TextLogHook.MechHeaderReset;
            },
            get disabled() {
              return get$1(expression_3);
            }
          });
        }, "headerQuinaryLeftOptions"),
        children: /* @__PURE__ */ __name(($$anchor3, $$slotProps) => {
          var fragment_3 = root_4$9(), node_1 = sibling(first_child(fragment_3), 2);
          const expression_4 = /* @__PURE__ */ derived(() => getLocalized(ACTIVATION_LOCALIZE_MAP[core.activation]));
          EffectBox(node_1, {
            get name() {
              return get$1(expression_4);
            },
            get effect() {
              return core.active_effect;
            },
            tooltipEnabled,
            get logType() {
              return TextLogHook.MechHeader;
            },
            get logTypeReset() {
              return TextLogHook.MechHeaderReset;
            }
          });
          var node_2 = sibling(node_1, 2);
          const expression_5 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
          ActionBox(node_2, {
            get uuid() {
              return frame.uuid;
            },
            get actions() {
              return core.active_actions;
            },
            path: "system.core_system.active_actions",
            collapseID: actionCollID,
            startCollapsed: !1,
            tooltipEnabled,
            get tooltipTheme() {
              return get$1(expression_5);
            },
            get logType() {
              return TextLogHook.MechHeader;
            },
            get logTypeReset() {
              return TextLogHook.MechHeaderReset;
            }
          });
          var node_3 = sibling(node_2, 2);
          const expression_6 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
          DeployableBox(node_3, {
            get source() {
              return $$props.actor;
            },
            lidSource: core,
            get uuid() {
              return frame.uuid;
            },
            get sheetUUID() {
              return $$props.actor.uuid;
            },
            tooltipEnabled,
            get tooltipTheme() {
              return get$1(expression_6);
            },
            get logType() {
              return TextLogHook.MechHeader;
            },
            get logTypeReset() {
              return TextLogHook.MechHeaderReset;
            }
          }), append($$anchor3, fragment_3);
        }, "children"),
        $$slots: { default: !0 }
      });
    }, "consequent");
    if_block(node, ($$render) => {
      (core.active_effect || core.active_actions.length || core.active_bonuses.length) && $$render(consequent);
    });
  }
  append($$anchor, fragment), pop();
}
__name(FrameActivePower, "FrameActivePower");
var root_3$r = /* @__PURE__ */ template('<div class="la-divider-h la-bckg-primary -margin0-tb -margin2-b"></div> <!> <!>', 1);
function FramePassivePower($$anchor, $$props) {
  push($$props, !0);
  let effectButtonHover = state(!1);
  const tooltipEnabled = getMechSheetTooltipEnabled(), frame = $$props.system.loadout.frame.value, core = frame.system.core_system, frameColorBckg = getManufacturerColor(frame.system.manufacturer, "bckg"), frameColorBrdr = getManufacturerColor(frame.system.manufacturer, "brdr"), collID = `${$$props.actor.uuid}.${frame.id}.passive`, actionCollID = `${$$props.actor.uuid}.${frame.id}.passive.action`, tip = core.passive_effect || getLocalized("LA.chat.tooltip");
  function sendToChat(event2) {
    event2.stopPropagation();
    let chatData = {
      title: core.passive_name,
      effect: core.passive_effect
    };
    SendUnknownToChatBase.getInstance().startFlow(frame.uuid, chatData);
  }
  __name(sendToChat, "sendToChat");
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent_1 = /* @__PURE__ */ __name(($$anchor2) => {
      HeaderQuinary($$anchor2, {
        get text() {
          return core.passive_name;
        },
        headerStyle: [frameColorBckg, "-padding0-l"],
        borderStyle: [H4_BORDER_STYLE, frameColorBrdr],
        textStyle: ["la-text-header", "la-prmy-header"],
        extensionTextFunction: /* @__PURE__ */ __name(() => {
          if (get$1(effectButtonHover)) return `--${getLocalized("LA.use.label")}`;
        }, "extensionTextFunction"),
        collapseID: collID,
        contentLeft: /* @__PURE__ */ __name(($$anchor3) => {
          const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
          EffectButton($$anchor3, {
            iconStyle: [H2_ICON_SIZE, "cci", "cci-corebonus"],
            iconBackgroundStyle: [
              H2_ICON_SIZE,
              "la-prmy-secondary",
              "-pulse-prmy"
            ],
            get flowClass() {
              return FlowClass.None;
            },
            onClick: sendToChat,
            tooltipEnabled,
            get tooltipTheme() {
              return get$1(expression);
            },
            get tooltipDirection() {
              return TooltipDirection.LEFT;
            },
            tooltip: tip,
            get logType() {
              return TextLogHook.MechHeader;
            },
            get logTypeReset() {
              return TextLogHook.MechHeaderReset;
            },
            onPointerEnter: /* @__PURE__ */ __name(() => {
              set(effectButtonHover, !0);
            }, "onPointerEnter"),
            onPointerLeave: /* @__PURE__ */ __name(() => {
              set(effectButtonHover, !1);
            }, "onPointerLeave")
          });
        }, "headerQuinaryLeftOptions"),
        children: /* @__PURE__ */ __name(($$anchor3, $$slotProps) => {
          var fragment_3 = root_3$r(), node_1 = sibling(first_child(fragment_3), 2);
          {
            var consequent = /* @__PURE__ */ __name(($$anchor4) => {
              const expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.core.passive.label"));
              EffectBox($$anchor4, {
                get name() {
                  return get$1(expression_1);
                },
                get effect() {
                  return core.passive_effect;
                },
                tooltipEnabled,
                get logType() {
                  return TextLogHook.MechHeader;
                },
                get logTypeReset() {
                  return TextLogHook.MechHeaderReset;
                }
              });
            }, "consequent");
            if_block(node_1, ($$render) => {
              core.passive_effect && $$render(consequent);
            });
          }
          var node_2 = sibling(node_1, 2);
          const expression_2 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
          ActionBox(node_2, {
            get uuid() {
              return frame.uuid;
            },
            get actions() {
              return core.passive_actions;
            },
            path: "system.core_system.passive_actions",
            collapseID: actionCollID,
            startCollapsed: !1,
            tooltipEnabled,
            get tooltipTheme() {
              return get$1(expression_2);
            },
            get logType() {
              return TextLogHook.MechHeader;
            },
            get logTypeReset() {
              return TextLogHook.MechHeaderReset;
            }
          }), append($$anchor3, fragment_3);
        }, "children"),
        $$slots: { default: !0 }
      });
    }, "consequent_1");
    if_block(node, ($$render) => {
      (core.passive_effect || core.passive_actions.length || core.passive_bonuses.length) && $$render(consequent_1);
    });
  }
  append($$anchor, fragment), pop();
}
__name(FramePassivePower, "FramePassivePower");
const _COUNTER_STYLE = "clipped-alt -widthfull la-bckg-header-anti";
var root_2$g = /* @__PURE__ */ template('<span class="la-counterbox__span -fontsize1"> </span>'), root_3$q = /* @__PURE__ */ template('<button type="button"></button>'), root_1$m = /* @__PURE__ */ template("<div><!> <!></div>");
function CounterBox($$anchor, $$props) {
  push($$props, !0);
  const logging = $$props.logType && $$props.logTypeReset, log = $$props.logText || getLocalized("LA.counter.tooltip");
  function handleOnClick(event2, index2) {
    event2.stopPropagation(), $$props.onPointerClick && $$props.onPointerClick(event2, index2);
  }
  __name(handleOnClick, "handleOnClick");
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent_1 = /* @__PURE__ */ __name(($$anchor2) => {
      var div = root_1$m(), node_1 = child(div);
      {
        var consequent = /* @__PURE__ */ __name(($$anchor3) => {
          var span = root_2$g(), text_1 = child(span);
          template_effect(() => set_text(text_1, $$props.text)), append($$anchor3, span);
        }, "consequent");
        if_block(node_1, ($$render) => {
          $$props.text && $$render(consequent);
        });
      }
      var node_2 = sibling(node_1, 2);
      each(node_2, 17, () => ({ length: $$props.usesMax }), index, ($$anchor3, _, index2) => {
        var button = root_3$q();
        button.__click = (event2) => handleOnClick(event2, index2), template_effect(
          ($0) => {
            set_class(button, `la-counterbox__button
            mdi ${(index2 < $$props.usesValue ? "mdi-hexagon-slice-6" : "mdi-hexagon-outline") ?? ""} 
            la-prmy-header -glow-prmy la-scdy-primary -glow-scdy-hover -fontsize5 
            ${$$props.type ?? ""}`), set_attribute(button, "data-available", index2 < $$props.usesValue), set_attribute(button, "data-path", $$props.path), set_attribute(button, "aria-label", `${$0 ?? ""} ${$$props.text ?? ""}`);
          },
          [() => getLocalized("LA.use.label")]
        ), event("pointerenter", button, function(...$$args) {
          var _a;
          (_a = logging ? (event2) => sendToLog(event2, log, $$props.logType) : void 0) == null || _a.apply(this, $$args);
        }), event("pointerleave", button, function(...$$args) {
          var _a;
          (_a = logging ? (event2) => resetLog(event2, $$props.logTypeReset) : void 0) == null || _a.apply(this, $$args);
        }), append($$anchor3, button);
      }), template_effect(
        ($0) => set_class(div, `la-counterbox la-combine-h -aligncenter la-text-header -padding1-lr
        ${$0 ?? ""}`),
        [
          () => {
            var _a;
            return (_a = $$props.style) != null && _a.join(" ") || $$props.type === CounterBoxType.Counter ? _COUNTER_STYLE : "";
          }
        ]
      ), append($$anchor2, div);
    }, "consequent_1");
    if_block(node, ($$render) => {
      $$props.usesMax && $$render(consequent_1);
    });
  }
  append($$anchor, fragment), pop();
}
__name(CounterBox, "CounterBox");
delegate(["click"]);
var root_2$f = /* @__PURE__ */ template('<div><span> </span> <div class="la-combine-h -fontsize3"> </div></div>'), root_1$l = /* @__PURE__ */ template('<div class="la-combine-h -widthfull"></div>');
function BonusBox($$anchor, $$props) {
  push($$props, !0);
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var div = root_1$l();
      each(div, 21, () => $$props.bonuses, index, ($$anchor3, bonus, index2) => {
        var div_1 = root_2$f(), span = child(div_1), text2 = child(span), div_2 = sibling(span, 2), text_1 = child(div_2);
        template_effect(() => {
          set_class(div_1, `la-effectbox la-brdr-repcap la-bckg-card la-combine-h -widthfull ${(index2 === $$props.bonuses.length - 1 ? "-bordersround-ltb" : "-bordersround") ?? ""}`), set_class(span, `la-effectbox__span clipped-bot la-bckg-primary la-text-header -upper -fontsize0
                ${($$props.editable ? "editable" : "") ?? ""}`), set_attribute(span, "data-path", `$${$$props.bonusPath ?? ""}.$${index2 ?? ""}`), set_text(text2, get$1(bonus).lid), set_text(text_1, get$1(bonus).val);
        }), append($$anchor3, div_1);
      }), append($$anchor2, div);
    }, "consequent");
    if_block(node, ($$render) => {
      $$props.bonuses.length && $$render(consequent);
    });
  }
  append($$anchor, fragment), pop();
}
__name(BonusBox, "BonusBox");
const _STYLE$2 = "la-prmy-header -glow-prmy la-scdy-primary -glow-scdy-hover -fontsize2";
var root$E = /* @__PURE__ */ template('<button type="button"><i></i></button>');
function MessageButton($$anchor, $$props) {
  push($$props, !0);
  const tip = TooltipFactory.buildTooltip(getLocalized("LA.chat.tooltip")), logging = $$props.logType && $$props.logTypeReset, log = $$props.logText || getLocalized("LA.chat.tooltip");
  function handleOnPointerEnter(event2) {
    if ($$props.onPointerEnter && $$props.onPointerEnter(), logging) sendToLog(event2, log, $$props.logType);
    else return;
  }
  __name(handleOnPointerEnter, "handleOnPointerEnter");
  function handleOnPointerLeave(event2) {
    if ($$props.onPointerLeave && $$props.onPointerLeave(), logging) resetLog(event2, $$props.logTypeReset);
    else return;
  }
  __name(handleOnPointerLeave, "handleOnPointerLeave");
  var button = root$E();
  button.__click = function(...$$args) {
    var _a;
    (_a = $$props.onClick ? (event2) => $$props.onClick(event2) : null) == null || _a.apply(this, $$args);
  };
  var i2 = child(button);
  template_effect(
    ($0, $1, $2) => {
      set_class(button, `${$$props.flowClass ?? ""} ${$0 ?? ""}`), set_attribute(button, "data-uuid", $$props.uuid), set_attribute(button, "data-type", $$props.type), set_attribute(button, "data-index", $$props.index), set_attribute(button, "data-tooltip", $$props.tooltipEnabled ? tip : void 0), set_attribute(button, "data-rank", $$props.rank), set_attribute(button, "data-tooltip-class", `${$$props.tooltipClass || "clipped-bot la-tooltip"} ${$$props.tooltipTheme}`), set_attribute(button, "data-tooltip-direction", $$props.tooltipDirection || TooltipDirection.UP), set_attribute(button, "aria-label", $1), set_class(i2, `mdi mdi-message ${$2 ?? ""}`);
    },
    [
      () => {
        var _a;
        return ((_a = $$props.style) == null ? void 0 : _a.join(" ")) || _STYLE$2;
      },
      () => getLocalized("LA.delete.tooltip"),
      () => {
        var _a;
        return (_a = $$props.iconStyle) == null ? void 0 : _a.join(" ");
      }
    ]
  ), event("pointerenter", button, handleOnPointerEnter), event("pointerleave", button, handleOnPointerLeave), append($$anchor, button), pop();
}
__name(MessageButton, "MessageButton");
delegate(["click"]);
var root_3$p = /* @__PURE__ */ template("<i></i>"), root_5$i = /* @__PURE__ */ template('<div class="la-generated -widthfull -gap2 la-combine-v"><!> <!> <!> <!> <!></div>');
function FrameTrait($$anchor, $$props) {
  push($$props, !0);
  let messageButtonHover = state(!1);
  const frame = $$props.system.loadout.frame.value, tooltipEnabled = getMechSheetTooltipEnabled();
  function getCollapseID(index2) {
    return `${$$props.actor.uuid}_${frame.id}_trait_${index2}`;
  }
  __name(getCollapseID, "getCollapseID");
  function getActionCollapseID(index2) {
    return `${$$props.actor.uuid}_${frame.id}_trait_${index2}_action`;
  }
  __name(getActionCollapseID, "getActionCollapseID");
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent_1 = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment_1 = comment(), node_1 = first_child(fragment_1);
      each(node_1, 17, () => frame.system.traits, index, ($$anchor3, trait, index$1) => {
        const headerSecondaryLeftOptions2 = /* @__PURE__ */ __name(($$anchor4) => {
          var i2 = root_3$p();
          set_class(i2, `${H2_ICON_SIZE} cci cci-frame`), append($$anchor4, i2);
        }, "headerSecondaryLeftOptions"), headerSecondaryRightOptions = /* @__PURE__ */ __name(($$anchor4) => {
          const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
          MessageButton($$anchor4, {
            get flowClass() {
              return FlowClass.SendToChat;
            },
            get uuid() {
              return frame.uuid;
            },
            type: "trait",
            index: index$1,
            tooltipEnabled,
            get tooltipTheme() {
              return get$1(expression);
            },
            get logType() {
              return TextLogHook.MechHeader;
            },
            get logTypeReset() {
              return TextLogHook.MechHeaderReset;
            },
            onPointerEnter: /* @__PURE__ */ __name(() => {
              set(messageButtonHover, !0);
            }, "onPointerEnter"),
            onPointerLeave: /* @__PURE__ */ __name(() => {
              set(messageButtonHover, !1);
            }, "onPointerLeave")
          });
        }, "headerSecondaryRightOptions"), expression_1 = /* @__PURE__ */ derived(() => getCollapseID(index$1));
        HeaderSecondary($$anchor3, {
          get text() {
            return get$1(trait).name;
          },
          headerStyle: [H2_HEADER_STYLE, "la-bckg-pilot"],
          textStyle: ["-fontsize2"],
          borderStyle: ["-bordersoff"],
          extensionTextFunction: /* @__PURE__ */ __name(() => {
            if (get$1(messageButtonHover)) return `--${getLocalized("LA.chat.extension")}`;
          }, "extensionTextFunction"),
          get collapseID() {
            return get$1(expression_1);
          },
          startCollapsed: !0,
          contentLeft: headerSecondaryLeftOptions2,
          contentRight: headerSecondaryRightOptions,
          children: /* @__PURE__ */ __name(($$anchor4, $$slotProps) => {
            var div = root_5$i(), node_2 = child(div);
            const expression_2 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.frame.trait.label"));
            EffectBox(node_2, {
              get name() {
                return get$1(expression_2);
              },
              get effect() {
                return get$1(trait).description;
              },
              tooltipEnabled,
              get logType() {
                return TextLogHook.MechHeader;
              },
              get logTypeReset() {
                return TextLogHook.MechHeaderReset;
              }
            });
            var node_3 = sibling(node_2, 2);
            {
              var consequent = /* @__PURE__ */ __name(($$anchor5) => {
                var fragment_4 = comment(), node_4 = first_child(fragment_4);
                each(node_4, 17, () => get$1(trait).counters, index, ($$anchor6, counter, jndex) => {
                  CounterBox($$anchor6, {
                    get text() {
                      return get$1(counter).name;
                    },
                    get type() {
                      return CounterBoxType.Counter;
                    },
                    get usesValue() {
                      return get$1(counter).value;
                    },
                    get usesMax() {
                      return get$1(counter).max;
                    },
                    path: `system.loadout.frame.value.system.traits.${index$1 ?? ""}.counters.${jndex ?? ""}`,
                    get logType() {
                      return TextLogHook.MechHeader;
                    },
                    get logTypeReset() {
                      return TextLogHook.MechHeaderReset;
                    }
                  });
                }), append($$anchor5, fragment_4);
              }, "consequent");
              if_block(node_3, ($$render) => {
                var _a;
                (_a = get$1(trait).counters) != null && _a.length && $$render(consequent);
              });
            }
            var node_5 = sibling(node_3, 2);
            BonusBox(node_5, {
              get bonuses() {
                return get$1(trait).bonuses;
              },
              bonusPath: `system.traits.${index$1}.bonuses`
            });
            var node_6 = sibling(node_5, 2);
            const expression_3 = /* @__PURE__ */ derived(() => getActionCollapseID(index$1)), expression_4 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
            ActionBox(node_6, {
              get uuid() {
                return frame.uuid;
              },
              get actions() {
                return get$1(trait).actions;
              },
              path: `system.traits.${index$1}.actions`,
              get collapseID() {
                return get$1(expression_3);
              },
              startCollapsed: !1,
              tooltipEnabled,
              get tooltipTheme() {
                return get$1(expression_4);
              },
              get logType() {
                return TextLogHook.MechHeader;
              },
              get logTypeReset() {
                return TextLogHook.MechHeaderReset;
              }
            });
            var node_7 = sibling(node_6, 2);
            const expression_5 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
            DeployableBox(node_7, {
              get source() {
                return $$props.actor;
              },
              get lidSource() {
                return get$1(trait);
              },
              get uuid() {
                return frame.uuid;
              },
              get sheetUUID() {
                return $$props.actor.uuid;
              },
              tooltipEnabled,
              get tooltipTheme() {
                return get$1(expression_5);
              },
              get logType() {
                return TextLogHook.MechHeader;
              },
              get logTypeReset() {
                return TextLogHook.MechHeaderReset;
              }
            }), append($$anchor4, div);
          }, "children"),
          $$slots: { default: !0 }
        });
      }), append($$anchor2, fragment_1);
    }, "consequent_1");
    if_block(node, ($$render) => {
      frame.system.traits.length && $$render(consequent_1);
    });
  }
  append($$anchor, fragment), pop();
}
__name(FrameTrait, "FrameTrait");
function compactTag(tagPath, tag, editable = !0) {
  return tagView(tagPath, tag, !0, editable);
}
__name(compactTag, "compactTag");
function tagView(tagPath, tag, compact = !0, editable = !0) {
  let interpolatedName = tag.name.replace("{VAL}", `${tag.val ?? "?"}`), interpolatedDescription = tag.description.replace("{VAL}", `${tag.val ?? "?"}`) ?? "";
  return `<div
    class="${editable ? "editable-tag-instance" : ""} ${compact ? "compact-tag flexrow" : "large-tag"}"
    ${editable ? `data-path="${tagPath}"` : ""}
    ${compact ? `data-tippy-content="${interpolatedDescription}"` : ""}
  >
    ${compact ? `
    <i class="mdi mdi-label i--s i--light"></i>
    <span style="margin: 3px;" >${interpolatedName}</span>` : `
    <div class="tag-header flexrow">
      <i class="mdi mdi-label i--s i--light"></i>
      <span style="margin: 3px;" >${interpolatedName}</span>
      ${editable ? `
      <div class="tag-controls">
        <a class="tag-edit-button fas fa-edit" data-path="${tagPath}"></a>
        <a class="gen-control fas fa-trash" data-action="splice" data-path="${tagPath}"></a>
      </div>` : ""}
    </div>
    <div class="tag-description">${interpolatedDescription}</div>`}
  </div>`;
}
__name(tagView, "tagView");
var root_1$k = /* @__PURE__ */ template("<div></div>");
function TagArray($$anchor, $$props) {
  push($$props, !0);
  function getCompactTag(tag) {
    return compactTag($$props.path, tag);
  }
  __name(getCompactTag, "getCompactTag");
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent_1 = /* @__PURE__ */ __name(($$anchor2) => {
      var div = root_1$k();
      each(div, 21, () => $$props.tags, index, ($$anchor3, tag) => {
        var fragment_1 = comment(), node_1 = first_child(fragment_1);
        {
          var consequent = /* @__PURE__ */ __name(($$anchor4) => {
            var fragment_2 = comment(), node_2 = first_child(fragment_2);
            html(node_2, () => getCompactTag(get$1(tag))), append($$anchor4, fragment_2);
          }, "consequent");
          if_block(node_1, ($$render) => {
            get$1(tag).hidden || $$render(consequent);
          });
        }
        append($$anchor3, fragment_1);
      }), template_effect(() => set_class(div, `la-combine-h -wrapwrap -widthfull -justify${$$props.justify || "center"}`)), append($$anchor2, div);
    }, "consequent_1");
    if_block(node, ($$render) => {
      $$props.tags.length > 0 && $$render(consequent_1);
    });
  }
  append($$anchor, fragment), pop();
}
__name(TagArray, "TagArray");
const headerSecondaryLeftOptions = /* @__PURE__ */ __name(($$anchor) => {
  var i2 = root_2$e();
  set_class(i2, `${H2_ICON_SIZE} cci cci-corebonus`), append($$anchor, i2);
}, "headerSecondaryLeftOptions");
var root_2$e = /* @__PURE__ */ template("<i></i>"), root_6$m = /* @__PURE__ */ template('<div class="la-combine-v -widthfull -padding2-l"></div>'), root_8$6 = /* @__PURE__ */ template('<div class="la-combine-v -widthfull -gap0"><!> <!> <!></div>'), root_4$8 = /* @__PURE__ */ template('<div class="la-generated la-combine-v -widthfull -gap0"><!> <!></div>');
function Frame($$anchor, $$props) {
  var _a;
  push($$props, !0);
  const headerOptions = /* @__PURE__ */ __name(($$anchor2) => {
    const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid));
    CollapseAllButton($$anchor2, {
      collapseID: collID,
      tooltipEnabled,
      get tooltipTheme() {
        return get$1(expression);
      },
      get logType() {
        return TextLogHook.MechHeader;
      },
      get logTypeReset() {
        return TextLogHook.MechHeaderReset;
      },
      onPointerEnter: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !0);
      }, "onPointerEnter"),
      onPointerLeave: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !1);
      }, "onPointerLeave")
    });
  }, "headerOptions"), props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor, system } = props;
  let collapseAllButtonHover = state(!1);
  const tooltipEnabled = getMechSheetTooltipEnabled(), frame = (_a = system.loadout.frame) == null ? void 0 : _a.value, core = frame == null ? void 0 : frame.system.core_system, frameName = frame ? `${frame.system.manufacturer} ${frame.name}` : getLocalized("LA.placeholder"), frameColorBckg = frame ? getManufacturerColor(frame.system.manufacturer, "bckg") : "la-bckg-frame", frameColorBrdr = frame ? getManufacturerColor(frame.system.manufacturer, "brdr") : "la-brdr-frame", collID = frame ? `${actor.uuid}.frame.${frame.id}` : `${actor.uuid}.frame.empty`, expression_1 = /* @__PURE__ */ derived(() => frame ? frameName : getLocalized("LA.placeholder"));
  HeaderMain($$anchor, {
    get text() {
      return get$1(expression_1);
    },
    headerStyle: [MAIN_HEADER_STYLE$1, frameColorBckg, "-upper"],
    textStyle: [
      "la-text-header",
      "-fontsize2",
      "-overflowhidden"
    ],
    borderStyle: [frameColorBrdr],
    extensionTextFunction: /* @__PURE__ */ __name(() => {
      if (get$1(collapseAllButtonHover)) return `--${getLocalized("LA.collapseAll.extension")}`;
    }, "extensionTextFunction"),
    collapseID: collID,
    startCollapsed: !0,
    headerContent: headerOptions,
    children: /* @__PURE__ */ __name(($$anchor2, $$slotProps) => {
      var fragment_2 = comment(), node = first_child(fragment_2);
      {
        var consequent_2 = /* @__PURE__ */ __name(($$anchor3) => {
          var div = root_4$8();
          {
            const outerContent = /* @__PURE__ */ __name(($$anchor4) => {
              var fragment_3 = comment(), node_1 = first_child(fragment_3);
              {
                var consequent = /* @__PURE__ */ __name(($$anchor5) => {
                  var div_1 = root_6$m();
                  each(div_1, 21, () => core.counters, index, ($$anchor6, counter, index2) => {
                    CounterBox($$anchor6, {
                      get text() {
                        return get$1(counter).name;
                      },
                      get type() {
                        return CounterBoxType.Counter;
                      },
                      get usesValue() {
                        return get$1(counter).value;
                      },
                      get usesMax() {
                        return get$1(counter).max;
                      },
                      path: `system.loadout.frame.value.system.core_system.counters.${index2 ?? ""}`,
                      style: [
                        "clipped-bot-alt",
                        "-widthfull",
                        "la-bckg-header-anti"
                      ],
                      get logType() {
                        return TextLogHook.MechHeader;
                      },
                      get logTypeReset() {
                        return TextLogHook.MechHeaderReset;
                      }
                    });
                  }), append($$anchor5, div_1);
                }, "consequent");
                if_block(node_1, ($$render) => {
                  var _a2;
                  (_a2 = core.counters) != null && _a2.length && $$render(consequent);
                });
              }
              append($$anchor4, fragment_3);
            }, "outerContent");
            var node_2 = child(div);
            HeaderSecondary(node_2, {
              get text() {
                return core.name;
              },
              headerStyle: [H2_HEADER_STYLE, frameColorBckg],
              textStyle: ["-fontsize2"],
              borderStyle: ["-bordersoff"],
              collapseID: `${collID}.core`,
              startCollapsed: !0,
              renderOutsideCollapse: outerContent,
              contentLeft: headerSecondaryLeftOptions,
              children: /* @__PURE__ */ __name(($$anchor4, $$slotProps2) => {
                var div_2 = root_8$6(), node_3 = child(div_2);
                FrameActivePower(node_3, spread_props(() => props));
                var node_4 = sibling(node_3, 2);
                FramePassivePower(node_4, spread_props(() => props));
                var node_5 = sibling(node_4, 2);
                {
                  var consequent_1 = /* @__PURE__ */ __name(($$anchor5) => {
                    TagArray($$anchor5, {
                      get tags() {
                        return core.tags;
                      },
                      path: "system.loadout.frame.value.system.core_system.tags"
                    });
                  }, "consequent_1");
                  if_block(node_5, ($$render) => {
                    var _a2;
                    (_a2 = core.tags) != null && _a2.length && $$render(consequent_1);
                  });
                }
                append($$anchor4, div_2);
              }, "children"),
              $$slots: { default: !0 }
            });
            var node_6 = sibling(node_2, 2);
            FrameTrait(node_6, spread_props(() => props));
          }
          append($$anchor3, div);
        }, "consequent_2"), alternate = /* @__PURE__ */ __name(($$anchor3) => {
          const expression_2 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.frame.empty.label")), expression_3 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.frame.empty.subLabel"));
          EmptyBox($$anchor3, {
            get label() {
              return get$1(expression_2);
            },
            get subLabel() {
              return get$1(expression_3);
            }
          });
        }, "alternate");
        if_block(node, ($$render) => {
          frame ? $$render(consequent_2) : $$render(alternate, !1);
        });
      }
      append($$anchor2, fragment_2);
    }, "children"),
    $$slots: { default: !0 }
  }), pop();
}
__name(Frame, "Frame");
var AcceptType = /* @__PURE__ */ ((AcceptType2) => (AcceptType2.MechWeaponMod = "weapon_mod", AcceptType2.MechWeapon = "mech_weapon", AcceptType2.MechSystem = "mech_system", AcceptType2.PilotArmor = "pilot_armor", AcceptType2.PilotGear = "pilot_gear", AcceptType2.PilotWeapon = "pilot_weapon", AcceptType2.Skill = "skill", AcceptType2.License = "license", AcceptType2.Reserve = "reserve", AcceptType2))(AcceptType || {});
const H3_ICON_SIZE = "-fontsize7", H3_HEADER_STYLE = "clipped-bot-alt -padding0-tb la-text-header la-prmy-accent";
var root_2$d = /* @__PURE__ */ template('<div class="la-right la-combine-h -aligncenter"><!></div>'), root$D = /* @__PURE__ */ template('<div draggable="true"><div><div class="la-left la-combine-h -aligncenter"><!> <div class="la-combine-v -alignstart -justifycenter -divider"><span> </span> <!></div></div> <!></div> <!> <div><div><!></div></div></div>');
function HeaderTertiary($$anchor, $$props) {
  push($$props, !0);
  let isCollapsed = /* @__PURE__ */ derived(() => getCollapseState($$props.collapseID) ?? $$props.startCollapsed ?? !1);
  const extraOptions = !!$$props.contentRight;
  onMount(() => {
    $$props.collapseID && ($$props.dontSaveCollapse ?? getCollapseState($$props.collapseID) === void 0) && setCollapseState($$props.collapseID, $$props.startCollapsed ?? !1);
  });
  function toggleCollapse(event2) {
    event2.stopPropagation(), $$props.collapseID && setCollapseState($$props.collapseID, !get$1(isCollapsed));
  }
  __name(toggleCollapse, "toggleCollapse");
  function getExtensionText() {
    if ($$props.extensionTextFunction && $$props.extensionTextFunction()) return $$props.extensionTextFunction();
    if ($$props.extensionText) return $$props.extensionText;
    if ($$props.collapseID) return get$1(isCollapsed) ? `--${getLocalized("LA.expand.label")}` : `--${getLocalized("LA.collapse.label")}`;
  }
  __name(getExtensionText, "getExtensionText");
  var div = root$D(), div_1 = child(div), div_2 = child(div_1), node = child(div_2);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment = comment(), node_1 = first_child(fragment);
      snippet(node_1, () => $$props.contentLeft), append($$anchor2, fragment);
    }, "consequent");
    if_block(node, ($$render) => {
      $$props.contentLeft && $$render(consequent);
    });
  }
  var div_3 = sibling(node, 2), span = child(div_3), text_1 = child(span), node_2 = sibling(span, 2);
  const expression = /* @__PURE__ */ derived(() => $$props.collapseID || !$$props.extensionText ? `${$$props.subText} ` : $$props.subText), expression_1 = /* @__PURE__ */ derived(() => $$props.subHeaderFontStyle || ["-fontsize0"]), expression_2 = /* @__PURE__ */ derived(getExtensionText);
  TerminalText(node_2, {
    get text() {
      return get$1(expression);
    },
    get textStyle() {
      return get$1(expression_1);
    },
    get extensionText() {
      return get$1(expression_2);
    },
    disableCmdline: !0
  });
  var node_3 = sibling(div_2, 2);
  {
    var consequent_2 = /* @__PURE__ */ __name(($$anchor2) => {
      var div_4 = root_2$d(), node_4 = child(div_4);
      {
        var consequent_1 = /* @__PURE__ */ __name(($$anchor3) => {
          var fragment_1 = comment(), node_5 = first_child(fragment_1);
          snippet(node_5, () => $$props.contentRight), append($$anchor3, fragment_1);
        }, "consequent_1");
        if_block(node_4, ($$render) => {
          $$props.contentRight && $$render(consequent_1);
        });
      }
      append($$anchor2, div_4);
    }, "consequent_2");
    if_block(node_3, ($$render) => {
      extraOptions && $$render(consequent_2);
    });
  }
  var node_6 = sibling(div_1, 2);
  {
    var consequent_3 = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment_2 = comment(), node_7 = first_child(fragment_2);
      snippet(node_7, () => $$props.renderOutsideCollapse), append($$anchor2, fragment_2);
    }, "consequent_3");
    if_block(node_6, ($$render) => {
      $$props.renderOutsideCollapse && $$render(consequent_3);
    });
  }
  var div_5 = sibling(node_6, 2), div_6 = child(div_5), node_8 = child(div_6);
  {
    var consequent_4 = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment_3 = comment(), node_9 = first_child(fragment_3);
      snippet(node_9, () => $$props.children), append($$anchor2, fragment_3);
    }, "consequent_4");
    if_block(node_8, ($$render) => {
      $$props.children && $$render(consequent_4);
    });
  }
  template_effect(
    ($0, $1, $2, $3) => {
      set_class(div, `la-collapsegroup -widthfull ${$0 ?? ""}
        ${($$props.acceptTypes ? `ref set drop-settable ${$$props.acceptTypes}` : "") ?? ""}
        collapse-group`), set_attribute(div, "data-item-id", $$props.itemID), set_attribute(div, "data-uuid", $$props.uuid), set_attribute(div, "data-path", $$props.path), set_attribute(div, "data-accept-types", $$props.acceptTypes), set_class(div_1, `la-summary la-combine-h la-dropshadow 
            -justifybetween -widthfull
            ${$1 ?? ""}
            ${($$props.collapseID ? "collapse-trigger" : "") ?? ""}`), set_class(span, `la-top__span ${$2 ?? ""}`), set_text(text_1, $$props.text), set_class(div_5, `la-collapsegroup__wrapper
            ${($$props.collapseID ? "collapse-wrapper" : "") ?? ""} ${(get$1(isCollapsed) ? "collapsed" : "") ?? ""}`), set_attribute(div_5, "data-la-collapse-id", $$props.collapseID), set_class(div_6, `la-collapsecontent 
                -padding0-l -padding0-tb -bordersround-lb -widthfull -heightfull
                ${$3 ?? ""}`);
    },
    [
      () => $$props.rootStyle ? $$props.rootStyle.join(" ") : "",
      () => {
        var _a;
        return ((_a = $$props.headerStyle) == null ? void 0 : _a.join(" ")) || H3_HEADER_STYLE;
      },
      () => {
        var _a;
        return ((_a = $$props.headerFontStyle) == null ? void 0 : _a.join(" ")) || "-fontsize3";
      },
      () => $$props.borderStyle ? $$props.borderStyle.join(" ") : "la-brdr-primary"
    ]
  ), event("click", div_1, (event2) => toggleCollapse(event2)), append($$anchor, div), pop();
}
__name(HeaderTertiary, "HeaderTertiary");
var root$C = /* @__PURE__ */ template("<div><span><!></span> <i></i></div>");
function TotalSP($$anchor, $$props) {
  push($$props, !0);
  const logging = $$props.logType && $$props.logTypeReset, log = $$props.logText || getLocalized("LA.mech.system.points.total.tooltip");
  var div = root$C(), span = child(div), node = child(span);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var text$1 = text();
      template_effect(() => set_text(text$1, `${$$props.value ?? ""} / ${$$props.max ?? ""}`)), append($$anchor2, text$1);
    }, "consequent"), alternate = /* @__PURE__ */ __name(($$anchor2) => {
      var text_1 = text();
      template_effect(() => set_text(text_1, $$props.value)), append($$anchor2, text_1);
    }, "alternate");
    if_block(node, ($$render) => {
      $$props.max ? $$render(consequent) : $$render(alternate, !1);
    });
  }
  var i2 = sibling(span, 2);
  template_effect(
    ($0, $1, $2) => {
      set_class(div, `la-combine-h -aligncenter -height2 ${$0 ?? ""}`), set_class(span, $1), set_class(i2, `cci cci-system-point ${$2 ?? ""}`);
    },
    [
      () => {
        var _a;
        return ((_a = $$props.style) == null ? void 0 : _a.join(" ")) || H2_TEXT_SIZE;
      },
      () => {
        var _a;
        return (_a = $$props.textStyle) == null ? void 0 : _a.join(" ");
      },
      () => {
        var _a;
        return ((_a = $$props.iconStyle) == null ? void 0 : _a.join(" ")) || H2_ICON_SIZE;
      }
    ]
  ), event("pointerenter", div, function(...$$args) {
    var _a;
    (_a = logging ? (event2) => sendToLog(event2, log, $$props.logType) : void 0) == null || _a.apply(this, $$args);
  }), event("pointerleave", div, function(...$$args) {
    var _a;
    (_a = logging ? (event2) => resetLog(event2, $$props.logTypeReset) : void 0) == null || _a.apply(this, $$args);
  }), append($$anchor, div), pop();
}
__name(TotalSP, "TotalSP");
const HEADER_SECONDARY_STYLE = "la-prmy-header -glow-prmy la-scdy-primary -glow-scdy-hover -fontsize2", _STYLE$1 = "la-prmy-header -glow-prmy la-scdy-primary -glow-scdy-hover -fontsize2";
var root$B = /* @__PURE__ */ template('<button type="button"><i></i></button>');
function EditButton($$anchor, $$props) {
  push($$props, !0);
  const tip = TooltipFactory.buildTooltip(getLocalized("LA.edit.tooltip")), logging = $$props.logType && $$props.logTypeReset, log = $$props.logText || getLocalized("LA.edit.tooltip");
  function handleOnPointerEnter(event2) {
    if ($$props.onPointerEnter && $$props.onPointerEnter(), logging) sendToLog(event2, log, $$props.logType);
    else return;
  }
  __name(handleOnPointerEnter, "handleOnPointerEnter");
  function handleOnPointerLeave(event2) {
    if ($$props.onPointerLeave && $$props.onPointerLeave(), logging) resetLog(event2, $$props.logTypeReset);
    else return;
  }
  __name(handleOnPointerLeave, "handleOnPointerLeave");
  var button = root$B(), i2 = child(button);
  template_effect(
    ($0, $1, $2) => {
      set_class(button, `la-combine-v ${$0 ?? ""}
        ${$$props.flowClass || "lancer-context-menu"}`), set_attribute(button, "data-path", $$props.path), set_attribute(button, "data-tooltip", $$props.tooltipEnabled ? tip : void 0), set_attribute(button, "data-tooltip-class", `${$$props.tooltipClass || "clipped-bot la-tooltip"} ${$$props.tooltipTheme}`), set_attribute(button, "data-tooltip-direction", $$props.tooltipDirection || TooltipDirection.UP), set_attribute(button, "aria-label", $1), set_class(i2, `fas fa-ellipsis-v ${$2 ?? ""}`);
    },
    [
      () => {
        var _a;
        return ((_a = $$props.style) == null ? void 0 : _a.join(" ")) || _STYLE$1;
      },
      () => getLocalized("LA.edit.tooltip"),
      () => {
        var _a;
        return (_a = $$props.iconStyle) == null ? void 0 : _a.join(" ");
      }
    ]
  ), event("pointerenter", button, handleOnPointerEnter), event("pointerleave", button, handleOnPointerLeave), append($$anchor, button), pop();
}
__name(EditButton, "EditButton");
function LimitedBox($$anchor, $$props) {
  push($$props, !0);
  const log = $$props.logText || getLocalized("LA.limited.tooltip"), expression = /* @__PURE__ */ derived(() => getLocalized("LA.limited.label"));
  CounterBox($$anchor, {
    get text() {
      return get$1(expression);
    },
    get type() {
      return CounterBoxType.Limited;
    },
    get usesValue() {
      return $$props.usesValue;
    },
    get usesMax() {
      return $$props.usesMax;
    },
    get path() {
      return $$props.path;
    },
    logText: log,
    get logType() {
      return $$props.logType;
    },
    get logTypeReset() {
      return $$props.logTypeReset;
    },
    get onPointerClick() {
      return $$props.onPointerClick;
    }
  }), pop();
}
__name(LimitedBox, "LimitedBox");
var root_2$c = /* @__PURE__ */ template("<!> <!>", 1), root_7$h = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull -padding2-l"><div class="la-combine-h clipped-bot-alt la-bckg-header-anti -widthfull"><!></div></div>'), root_9$d = /* @__PURE__ */ template('<!> <div class="la-combine-v -margin3-lr"><!> <!></div>', 1), root_12$2 = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull -padding1-l"></div>'), root_11$8 = /* @__PURE__ */ template('<div class="la-generated -widthfull -gap2 la-combine-v"><!> <!> <!> <!> <!> <!></div>'), root_5$h = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull"><!> <!></div>');
function Systems$1($$anchor, $$props) {
  var _a;
  push($$props, !0);
  const emptySystems = /* @__PURE__ */ __name(($$anchor2) => {
    const expression = /* @__PURE__ */ derived(() => system.loadout.sp.value ? getLocalized("LA.mech.system.undermounted.label") : getLocalized("LA.mech.system.empty.label")), expression_1 = /* @__PURE__ */ derived(() => system.loadout.sp.value ? formatString(getLocalized("LA.mech.system.undermounted.subLabel"), (system.loadout.sp.max - system.loadout.sp.value).toString()) : getLocalized("LA.mech.system.empty.subLabel"));
    EmptyBox($$anchor2, {
      get label() {
        return get$1(expression);
      },
      get subLabel() {
        return get$1(expression_1);
      },
      get type() {
        return AcceptType.MechSystem;
      },
      get path() {
        return `system.loadout.systems.${systemComponents.length ?? ""}.value`;
      }
    });
  }, "emptySystems"), headerOptions = /* @__PURE__ */ __name(($$anchor2) => {
    var fragment_1 = root_2$c(), node = first_child(fragment_1);
    TotalSP(node, {
      get value() {
        return system.loadout.sp.value;
      },
      get max() {
        return system.loadout.sp.max;
      },
      get logType() {
        return TextLogHook.MechHeader;
      },
      get logTypeReset() {
        return TextLogHook.MechHeaderReset;
      }
    });
    var node_1 = sibling(node, 2);
    const expression_2 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid));
    CollapseAllButton(node_1, {
      collapseID: collID,
      tooltipEnabled,
      get tooltipTheme() {
        return get$1(expression_2);
      },
      get logType() {
        return TextLogHook.MechHeader;
      },
      get logTypeReset() {
        return TextLogHook.MechHeaderReset;
      },
      onPointerEnter: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !0);
      }, "onPointerEnter"),
      onPointerLeave: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !1);
      }, "onPointerLeave")
    }), append($$anchor2, fragment_1);
  }, "headerOptions"), props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor, system } = props;
  let collapseAllButtonHover = state(!1), effectButtonHover = state(!1), editButtonHover = state(!1), messageButtonHover = state(!1);
  const tooltipEnabled = getMechSheetTooltipEnabled(), systemComponents = (_a = system == null ? void 0 : system.loadout.systems) == null ? void 0 : _a.filter((item) => item !== null), collID = systemComponents.length ? `${actor.uuid}.systems` : `${actor.uuid}.systems.empty`;
  function renderOuter(component) {
    return !isDestroyed(component) && component.value.system.uses.max;
  }
  __name(renderOuter, "renderOuter");
  function getActionCollID(index2) {
    return `${actor.uuid}.systems.${index2}.action`;
  }
  __name(getActionCollID, "getActionCollID");
  function isDestroyed(component) {
    return component.value.system.destroyed;
  }
  __name(isDestroyed, "isDestroyed");
  function getTitleStyle(component) {
    return isDestroyed(component) ? "la-text-repcap la-prmy-accent -strikethrough" : "la-text-header la-prmy-accent";
  }
  __name(getTitleStyle, "getTitleStyle");
  function getSubtitleStyle(component) {
    return isDestroyed(component) ? "la-text-error la-prmy-error horus--very--subtle" : "la-text-header la-prmy-header";
  }
  __name(getSubtitleStyle, "getSubtitleStyle");
  function getIconStyle(component) {
    let icon = SYSTEM_ICON_MAP[component.value.system.type] || "cci-system";
    return isDestroyed(component) ? `cci ${icon} la-text-repcap` : `cci ${icon} la-prmy-header -glow-prmy la-scdy-primary -glow-scdy-hover`;
  }
  __name(getIconStyle, "getIconStyle");
  function getSPStyle(component) {
    return isDestroyed(component) ? "la-text-repcap" : "la-text-header";
  }
  __name(getSPStyle, "getSPStyle");
  function getSubtitle(component) {
    return isDestroyed(component) ? getLocalized("LA.mech.system.destroyed.label") : getLocalized(SYSTEM_LOCALIZE_MAP[component.value.system.type]) || getLocalized("LA.mech.system.system.label");
  }
  __name(getSubtitle, "getSubtitle");
  function getComponentPath(index2) {
    return `system.loadout.systems.${index2}.value`;
  }
  __name(getComponentPath, "getComponentPath");
  var fragment_2 = comment(), node_2 = first_child(fragment_2);
  {
    var consequent_4 = /* @__PURE__ */ __name(($$anchor2) => {
      const expression_3 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.system.label"));
      HeaderMain($$anchor2, {
        get text() {
          return get$1(expression_3);
        },
        headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-system"],
        textStyle: [
          "la-text-header",
          "-fontsize2",
          "-overflowhidden"
        ],
        borderStyle: ["la-brdr-system"],
        extensionTextFunction: /* @__PURE__ */ __name(() => {
          if (get$1(collapseAllButtonHover)) return `--${getLocalized("LA.collapseAll.extension")}`;
        }, "extensionTextFunction"),
        collapseID: collID,
        startCollapsed: !0,
        headerContent: headerOptions,
        children: /* @__PURE__ */ __name(($$anchor3, $$slotProps) => {
          var fragment_4 = comment(), node_3 = first_child(fragment_4);
          {
            var consequent_3 = /* @__PURE__ */ __name(($$anchor4) => {
              var div = root_5$h(), node_4 = child(div);
              each(node_4, 17, () => systemComponents, index, ($$anchor5, component, index$1) => {
                const outerContent = /* @__PURE__ */ __name(($$anchor6) => {
                  var div_1 = root_7$h(), div_2 = child(div_1), node_5 = child(div_2);
                  const expression_4 = /* @__PURE__ */ derived(() => {
                    var _a2;
                    return (_a2 = get$1(component).value) == null ? void 0 : _a2.system.uses.value;
                  }), expression_5 = /* @__PURE__ */ derived(() => {
                    var _a2;
                    return (_a2 = get$1(component).value) == null ? void 0 : _a2.system.uses.max;
                  }), expression_6 = /* @__PURE__ */ derived(() => getComponentPath(index$1));
                  LimitedBox(node_5, {
                    get usesValue() {
                      return get$1(expression_4);
                    },
                    get usesMax() {
                      return get$1(expression_5);
                    },
                    get path() {
                      return get$1(expression_6);
                    },
                    get logType() {
                      return TextLogHook.MechHeader;
                    },
                    get logTypeReset() {
                      return TextLogHook.MechHeaderReset;
                    }
                  }), append($$anchor6, div_1);
                }, "outerContent"), headerTertiaryLeftOptions = /* @__PURE__ */ __name(($$anchor6) => {
                  const expression_7 = /* @__PURE__ */ derived(() => [
                    H3_ICON_SIZE,
                    getIconStyle(get$1(component))
                  ]), expression_8 = /* @__PURE__ */ derived(() => get$1(component).value.system.effect ? FlowClass.SendEffectToChat : FlowClass.SendToChat), expression_9 = /* @__PURE__ */ derived(() => getComponentPath(index$1)), expression_10 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_11 = /* @__PURE__ */ derived(() => isDestroyed(get$1(component)));
                  EffectButton($$anchor6, {
                    get iconStyle() {
                      return get$1(expression_7);
                    },
                    iconBackgroundStyle: [
                      H3_ICON_SIZE,
                      "la-prmy-secondary",
                      "-pulse-prmy"
                    ],
                    get flowClass() {
                      return get$1(expression_8);
                    },
                    get path() {
                      return get$1(expression_9);
                    },
                    tooltipEnabled,
                    get tooltipTheme() {
                      return get$1(expression_10);
                    },
                    get tooltipDirection() {
                      return TooltipDirection.LEFT;
                    },
                    get tooltip() {
                      return get$1(component).value.system.effect;
                    },
                    get logType() {
                      return TextLogHook.MechHeader;
                    },
                    get logTypeReset() {
                      return TextLogHook.MechHeaderReset;
                    },
                    get disabled() {
                      return get$1(expression_11);
                    },
                    onPointerEnter: /* @__PURE__ */ __name(() => {
                      set(effectButtonHover, !0);
                    }, "onPointerEnter"),
                    onPointerLeave: /* @__PURE__ */ __name(() => {
                      set(effectButtonHover, !1);
                    }, "onPointerLeave")
                  });
                }, "headerTertiaryLeftOptions"), headerTertiaryRightOptions = /* @__PURE__ */ __name(($$anchor6) => {
                  var fragment_6 = root_9$d(), node_6 = first_child(fragment_6);
                  const expression_12 = /* @__PURE__ */ derived(() => [getSPStyle(get$1(component))]), expression_13 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.system.points.tooltip"));
                  TotalSP(node_6, {
                    get value() {
                      return get$1(component).value.system.sp;
                    },
                    get style() {
                      return get$1(expression_12);
                    },
                    get logText() {
                      return get$1(expression_13);
                    },
                    get logType() {
                      return TextLogHook.MechHeader;
                    },
                    get logTypeReset() {
                      return TextLogHook.MechHeaderReset;
                    }
                  });
                  var div_3 = sibling(node_6, 2), node_7 = child(div_3);
                  const expression_14 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid));
                  MessageButton(node_7, {
                    get flowClass() {
                      return FlowClass.SendToChat;
                    },
                    tooltipEnabled,
                    get tooltipTheme() {
                      return get$1(expression_14);
                    },
                    get logType() {
                      return TextLogHook.MechHeader;
                    },
                    get logTypeReset() {
                      return TextLogHook.MechHeaderReset;
                    },
                    onPointerEnter: /* @__PURE__ */ __name(() => {
                      set(messageButtonHover, !0);
                    }, "onPointerEnter"),
                    onPointerLeave: /* @__PURE__ */ __name(() => {
                      set(messageButtonHover, !1);
                    }, "onPointerLeave")
                  });
                  var node_8 = sibling(node_7, 2);
                  const expression_15 = /* @__PURE__ */ derived(() => getComponentPath(index$1)), expression_16 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid));
                  EditButton(node_8, {
                    get flowClass() {
                      return FlowClass.ContextMenu;
                    },
                    get path() {
                      return get$1(expression_15);
                    },
                    tooltipEnabled,
                    get tooltipTheme() {
                      return get$1(expression_16);
                    },
                    get logType() {
                      return TextLogHook.MechHeader;
                    },
                    get logTypeReset() {
                      return TextLogHook.MechHeaderReset;
                    },
                    onPointerEnter: /* @__PURE__ */ __name(() => {
                      set(editButtonHover, !0);
                    }, "onPointerEnter"),
                    onPointerLeave: /* @__PURE__ */ __name(() => {
                      set(editButtonHover, !1);
                    }, "onPointerLeave")
                  }), append($$anchor6, fragment_6);
                }, "headerTertiaryRightOptions"), expression_17 = /* @__PURE__ */ derived(() => getComponentPath(index$1)), expression_18 = /* @__PURE__ */ derived(() => [
                  getTitleStyle(get$1(component)),
                  "-fontsize2"
                ]), expression_19 = /* @__PURE__ */ derived(() => getSubtitle(get$1(component))), expression_20 = /* @__PURE__ */ derived(() => [
                  getSubtitleStyle(get$1(component)),
                  "-fontsize0"
                ]), expression_21 = /* @__PURE__ */ derived(() => renderOuter(get$1(component)) ? outerContent : void 0);
                HeaderTertiary($$anchor5, {
                  get itemID() {
                    return get$1(component).value.id;
                  },
                  get uuid() {
                    return get$1(component).value.uuid;
                  },
                  get path() {
                    return get$1(expression_17);
                  },
                  acceptTypes: "mech_system",
                  get collapseID() {
                    return get$1(component).value.uuid;
                  },
                  startCollapsed: !0,
                  get text() {
                    return get$1(component).value.name;
                  },
                  headerStyle: [H3_HEADER_STYLE, "la-bckg-pilot"],
                  get headerFontStyle() {
                    return get$1(expression_18);
                  },
                  get subText() {
                    return get$1(expression_19);
                  },
                  get subHeaderFontStyle() {
                    return get$1(expression_20);
                  },
                  borderStyle: ["-bordersoff"],
                  extensionTextFunction: /* @__PURE__ */ __name(() => {
                    if (get$1(effectButtonHover)) return `--${getLocalized("LA.use.label")}`;
                    if (get$1(messageButtonHover)) return `--${getLocalized("LA.chat.extension")}`;
                    if (get$1(editButtonHover)) return `--${getLocalized("LA.edit.extension")}`;
                  }, "extensionTextFunction"),
                  get renderOutsideCollapse() {
                    return get$1(expression_21);
                  },
                  contentLeft: headerTertiaryLeftOptions,
                  contentRight: headerTertiaryRightOptions,
                  children: /* @__PURE__ */ __name(($$anchor6, $$slotProps2) => {
                    var fragment_8 = comment(), node_9 = first_child(fragment_8);
                    {
                      var consequent_1 = /* @__PURE__ */ __name(($$anchor7) => {
                        var div_4 = root_11$8(), node_10 = child(div_4);
                        {
                          var consequent = /* @__PURE__ */ __name(($$anchor8) => {
                            var div_5 = root_12$2();
                            each(div_5, 21, () => get$1(component).value.system.counters, index, ($$anchor9, counter, jndex) => {
                              const expression_22 = /* @__PURE__ */ derived(() => getComponentPath(index$1));
                              CounterBox($$anchor9, {
                                get text() {
                                  return get$1(counter).name;
                                },
                                get type() {
                                  return CounterBoxType.Counter;
                                },
                                get usesValue() {
                                  return get$1(counter).value;
                                },
                                get usesMax() {
                                  return get$1(counter).max;
                                },
                                get path() {
                                  return `${get$1(expression_22) ?? ""}.system.counters.${jndex ?? ""}`;
                                },
                                get logType() {
                                  return TextLogHook.MechHeader;
                                },
                                get logTypeReset() {
                                  return TextLogHook.MechHeaderReset;
                                }
                              });
                            }), append($$anchor8, div_5);
                          }, "consequent");
                          if_block(node_10, ($$render) => {
                            var _a2;
                            (_a2 = get$1(component).value.system.counters) != null && _a2.length && $$render(consequent);
                          });
                        }
                        var node_11 = sibling(node_10, 2);
                        const expression_23 = /* @__PURE__ */ derived(() => `${getComponentPath(index$1)}.system.bonuses`);
                        BonusBox(node_11, {
                          get bonuses() {
                            return get$1(component).value.system.bonuses;
                          },
                          get bonusPath() {
                            return get$1(expression_23);
                          }
                        });
                        var node_12 = sibling(node_11, 2);
                        const expression_24 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.system.effect.label"));
                        EffectBox(node_12, {
                          get name() {
                            return get$1(expression_24);
                          },
                          get effect() {
                            return get$1(component).value.system.effect;
                          },
                          tooltipEnabled,
                          get logType() {
                            return TextLogHook.MechHeader;
                          },
                          get logTypeReset() {
                            return TextLogHook.MechHeaderReset;
                          }
                        });
                        var node_13 = sibling(node_12, 2);
                        const expression_25 = /* @__PURE__ */ derived(() => getActionCollID(index$1)), expression_26 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid));
                        ActionBox(node_13, {
                          get uuid() {
                            return get$1(component).value.uuid;
                          },
                          get actions() {
                            return get$1(component).value.system.actions;
                          },
                          path: "system.actions",
                          get collapseID() {
                            return get$1(expression_25);
                          },
                          startCollapsed: !1,
                          tooltipEnabled,
                          get tooltipTheme() {
                            return get$1(expression_26);
                          },
                          get logType() {
                            return TextLogHook.MechHeader;
                          },
                          get logTypeReset() {
                            return TextLogHook.MechHeaderReset;
                          }
                        });
                        var node_14 = sibling(node_13, 2);
                        const expression_27 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid));
                        DeployableBox(node_14, {
                          source: actor,
                          get lidSource() {
                            return get$1(component).value.system;
                          },
                          get uuid() {
                            return get$1(component).value.uuid;
                          },
                          get sheetUUID() {
                            return actor.uuid;
                          },
                          tooltipEnabled,
                          get tooltipTheme() {
                            return get$1(expression_27);
                          },
                          get logType() {
                            return TextLogHook.MechHeader;
                          },
                          get logTypeReset() {
                            return TextLogHook.MechHeaderReset;
                          }
                        });
                        var node_15 = sibling(node_14, 2);
                        const expression_28 = /* @__PURE__ */ derived(() => `${getComponentPath(index$1)}.system.tags`);
                        TagArray(node_15, {
                          get tags() {
                            return get$1(component).value.system.tags;
                          },
                          get path() {
                            return get$1(expression_28);
                          },
                          justify: "start"
                        }), append($$anchor7, div_4);
                      }, "consequent_1");
                      if_block(node_9, ($$render) => {
                        isDestroyed(get$1(component)) || $$render(consequent_1);
                      });
                    }
                    append($$anchor6, fragment_8);
                  }, "children"),
                  $$slots: { default: !0 }
                });
              });
              var node_16 = sibling(node_4, 2);
              {
                var consequent_2 = /* @__PURE__ */ __name(($$anchor5) => {
                  emptySystems($$anchor5);
                }, "consequent_2");
                if_block(node_16, ($$render) => {
                  system.loadout.sp.value < system.loadout.sp.max && $$render(consequent_2);
                });
              }
              append($$anchor4, div);
            }, "consequent_3"), alternate = /* @__PURE__ */ __name(($$anchor4) => {
              emptySystems($$anchor4);
            }, "alternate");
            if_block(node_3, ($$render) => {
              systemComponents != null && systemComponents.length ? $$render(consequent_3) : $$render(alternate, !1);
            });
          }
          append($$anchor3, fragment_4);
        }, "children"),
        $$slots: { default: !0 }
      });
    }, "consequent_4");
    if_block(node_2, ($$render) => {
      system.loadout.frame && $$render(consequent_4);
    });
  }
  append($$anchor, fragment_2), pop();
}
__name(Systems$1, "Systems$1");
function LoadedBox($$anchor, $$props) {
  push($$props, !0);
  const loaded = $$props.item.system.loaded, log = $$props.logText || getLocalized("LA.loaded.tooltip");
  function handleLoadedInteraction(event2, index2) {
    $$props.item.update({ "system.loaded": !loaded }), $$props.onPointerClick && $$props.onPointerClick(event2, index2);
  }
  __name(handleLoadedInteraction, "handleLoadedInteraction");
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      const expression = /* @__PURE__ */ derived(() => getLocalized("LA.loaded.label"));
      CounterBox($$anchor2, {
        get text() {
          return get$1(expression);
        },
        get type() {
          return CounterBoxType.Loaded;
        },
        usesValue: loaded ? 1 : 0,
        usesMax: 1,
        get path() {
          return $$props.path;
        },
        get style() {
          return $$props.style;
        },
        logText: log,
        get logType() {
          return $$props.logType;
        },
        get logTypeReset() {
          return $$props.logTypeReset;
        },
        onPointerClick: handleLoadedInteraction
      });
    }, "consequent");
    if_block(node, ($$render) => {
      isLoading($$props.item) && ($$props.item.type === "mech_weapon" || $$props.item.type === "pilot_weapon" || $$props.item.type === "npc_feature") && $$render(consequent);
    });
  }
  return append($$anchor, fragment), pop({ handleLoadedInteraction });
}
__name(LoadedBox, "LoadedBox");
var root_2$b = /* @__PURE__ */ template('<span class="la-number__span"> </span><i></i>', 1), root_1$j = /* @__PURE__ */ template("<span></span>");
function DamageArray($$anchor, $$props) {
  push($$props, !0);
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var span = root_1$j();
      each(span, 21, () => $$props.damages, index, ($$anchor3, damage) => {
        var fragment_1 = root_2$b(), span_1 = first_child(fragment_1), text2 = child(span_1), i2 = sibling(span_1);
        template_effect(
          ($0, $1) => {
            set_text(text2, $0), set_class(i2, `cci ${get$1(damage).icon ?? ""} -glow-${$1 ?? ""}`);
          },
          [
            () => get$1(damage).val.replace(/\s/g, ""),
            () => get$1(damage).type.toLowerCase()
          ]
        ), append($$anchor3, fragment_1);
      }), template_effect(
        ($0) => set_class(span, `la-damage la-combine-h -justifycenter -aligncenter -lineheight1 -widthfull -flex1
    ${$0 ?? ""}`),
        [() => {
          var _a;
          return (_a = $$props.style) == null ? void 0 : _a.join(" ");
        }]
      ), append($$anchor2, span);
    }, "consequent");
    if_block(node, ($$render) => {
      $$props.damages.length && $$render(consequent);
    });
  }
  append($$anchor, fragment), pop();
}
__name(DamageArray, "DamageArray");
var root_2$a = /* @__PURE__ */ template('<span class="la-number__span"> </span> <i></i>', 1), root_1$i = /* @__PURE__ */ template("<span></span>");
function RangeArray($$anchor, $$props) {
  push($$props, !0);
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var span = root_1$i();
      each(span, 21, () => $$props.ranges, index, ($$anchor3, range2) => {
        var fragment_1 = root_2$a(), span_1 = first_child(fragment_1), text2 = child(span_1), i2 = sibling(span_1, 2);
        template_effect(() => {
          set_text(text2, get$1(range2).val), set_class(i2, `cci ${get$1(range2).icon ?? ""}`);
        }), append($$anchor3, fragment_1);
      }), template_effect(
        ($0) => set_class(span, `la-range la-combine-h -justifycenter -aligncenter -lineheight1 -widthfull -flex1 
        ${$0 ?? ""}`),
        [() => {
          var _a;
          return (_a = $$props.style) == null ? void 0 : _a.join(" ");
        }]
      ), append($$anchor2, span);
    }, "consequent");
    if_block(node, ($$render) => {
      $$props.ranges.length && $$render(consequent);
    });
  }
  append($$anchor, fragment), pop();
}
__name(RangeArray, "RangeArray");
const _ICON_BG_STYLE$1 = "-fontsize9 la-text-scrollbar-secondary";
var root_3$o = /* @__PURE__ */ template('<i style="z-index: -1;"></i>'), root$A = /* @__PURE__ */ template('<button type="button"><!> <!> <!></button>');
function DamageButton($$anchor, $$props) {
  var _a, _b, _c;
  push($$props, !0);
  const tip = TooltipFactory.buildTooltip($$props.tooltip || getLocalized("LA.flow.rollDamage.tooltip"), $$props.tooltipHeader), hasAllWeaponProperties = ((_a = $$props.damage) == null ? void 0 : _a.length) && ((_b = $$props.range) == null ? void 0 : _b.length), rollable = !$$props.disabled && ((_c = $$props.damage) == null ? void 0 : _c.length) > 0, logging = $$props.logType && $$props.logTypeReset, log = $$props.logText || getLocalized("LA.flow.rollDamage.tooltip");
  function handleOnPointerEnter(event2) {
    if ($$props.onPointerEnter && $$props.onPointerEnter(), logging) sendToLog(event2, log, $$props.logType);
    else return;
  }
  __name(handleOnPointerEnter, "handleOnPointerEnter");
  function handleOnPointerLeave(event2) {
    if ($$props.onPointerLeave && $$props.onPointerLeave(), logging) resetLog(event2, $$props.logTypeReset);
    else return;
  }
  __name(handleOnPointerLeave, "handleOnPointerLeave");
  var button = root$A();
  button.disabled = !rollable;
  var node = child(button);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      RangeArray($$anchor2, {
        get ranges() {
          return $$props.range;
        },
        get style() {
          return $$props.iconStyle;
        }
      });
    }, "consequent");
    if_block(node, ($$render) => {
      $$props.range && $$render(consequent);
    });
  }
  var node_1 = sibling(node, 2);
  {
    var consequent_1 = /* @__PURE__ */ __name(($$anchor2) => {
      const expression = /* @__PURE__ */ derived(() => [
        ...$$props.iconStyle || [],
        $$props.disabled ? "" : "la-prmy-header -glow-prmy la-scdy-primary -glow-scdy-hover"
      ]);
      DamageArray($$anchor2, {
        get damages() {
          return $$props.damage;
        },
        get style() {
          return get$1(expression);
        }
      });
    }, "consequent_1");
    if_block(node_1, ($$render) => {
      $$props.damage && $$render(consequent_1);
    });
  }
  var node_2 = sibling(node_1, 2);
  {
    var consequent_2 = /* @__PURE__ */ __name(($$anchor2) => {
      var i2 = root_3$o();
      template_effect(
        ($0) => set_class(i2, `fal fa-dice-d20 -positionabsolute 
            ${$0 ?? ""}`),
        [
          () => {
            var _a2;
            return ((_a2 = $$props.iconBackgroundStyle) == null ? void 0 : _a2.join(" ")) || _ICON_BG_STYLE$1;
          }
        ]
      ), append($$anchor2, i2);
    }, "consequent_2");
    if_block(node_2, ($$render) => {
      var _a2;
      !$$props.disabled && ((_a2 = $$props.damage) != null && _a2.length) && $$render(consequent_2);
    });
  }
  template_effect(
    ($0, $1) => {
      set_class(button, `la-properties la-combine-v -fontsize3 la-prmy-accent -justifycenter -positionrelative
        ${(hasAllWeaponProperties ? "-divider" : "") ?? ""} 
        ${$0 ?? ""}
        ${($$props.flowClass || FlowClass.RollDamage) ?? ""}`), set_attribute(button, "data-tooltip", $$props.tooltipEnabled && rollable ? tip : void 0), set_attribute(button, "data-tooltip-class", `${$$props.tooltipClass || "clipped-bot la-tooltip"} ${$$props.tooltipTheme}`), set_attribute(button, "data-tooltip-direction", $$props.tooltipDirection || TooltipDirection.UP), set_attribute(button, "aria-label", $1);
    },
    [
      () => {
        var _a2;
        return (_a2 = $$props.style) == null ? void 0 : _a2.join(" ");
      },
      () => $$props.tooltip || getLocalized("LA.flow.rollDamage.tooltip")
    ]
  ), event("pointerenter", button, handleOnPointerEnter), event("pointerleave", button, handleOnPointerLeave), append($$anchor, button), pop();
}
__name(DamageButton, "DamageButton");
const _ICON_BG_STYLE = `${H3_ICON_SIZE} la-text-scrollbar-secondary`, _ICON_STYLE = `${H3_ICON_SIZE}`;
var root_1$h = /* @__PURE__ */ template('<i style="z-index: -1;"></i>'), root$z = /* @__PURE__ */ template('<button type="button"><i></i> <!></button>');
function AttackButton($$anchor, $$props) {
  push($$props, !0);
  const tip = TooltipFactory.buildTooltip($$props.tooltip || getLocalized("LA.flow.rollAttack.tooltip"), $$props.tooltipHeader), logging = $$props.logType && $$props.logTypeReset, log = $$props.logText || getLocalized("LA.flow.rollAttack.tooltip");
  function handleOnPointerEnter(event2) {
    if ($$props.onPointerEnter && $$props.onPointerEnter(), logging) sendToLog(event2, log, $$props.logType);
    else return;
  }
  __name(handleOnPointerEnter, "handleOnPointerEnter");
  function handleOnPointerLeave(event2) {
    if ($$props.onPointerLeave && $$props.onPointerLeave(), logging) resetLog(event2, $$props.logTypeReset);
    else return;
  }
  __name(handleOnPointerLeave, "handleOnPointerLeave");
  var button = root$z(), i2 = child(button), node = sibling(i2, 2);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var i_1 = root_1$h();
      template_effect(
        ($0) => set_class(i_1, `fal fa-dice-d20 -positionabsolute -left0 
            ${$0 ?? ""}`),
        [
          () => {
            var _a;
            return ((_a = $$props.iconBackgroundStyle) == null ? void 0 : _a.join(" ")) || _ICON_BG_STYLE;
          }
        ]
      ), append($$anchor2, i_1);
    }, "consequent");
    if_block(node, ($$render) => {
      $$props.disabled || $$render(consequent);
    });
  }
  template_effect(
    ($0, $1, $2) => {
      set_class(button, `-positionrelative
        ${$0 ?? ""}
        ${($$props.flowClass || FlowClass.RollAttack) ?? ""}`), set_attribute(button, "data-tooltip", $$props.tooltipEnabled && !$$props.disabled ? tip : void 0), set_attribute(button, "data-tooltip-class", `${$$props.tooltipClass || "clipped-bot la-tooltip"} ${$$props.tooltipTheme}`), set_attribute(button, "data-tooltip-direction", $$props.tooltipDirection || TooltipDirection.LEFT), set_attribute(button, "aria-label", $1), button.disabled = $$props.disabled || !1, set_class(i2, `
            ${($$props.disabled ? "" : CLICKABLE_HOVER) ?? ""}
            ${$2 ?? ""}`);
    },
    [
      () => {
        var _a;
        return (_a = $$props.style) == null ? void 0 : _a.join(" ");
      },
      () => $$props.tooltip || getLocalized("LA.flow.rollAttack.tooltip"),
      () => {
        var _a;
        return ((_a = $$props.iconStyle) == null ? void 0 : _a.join(" ")) || _ICON_STYLE;
      }
    ]
  ), event("pointerenter", button, handleOnPointerEnter), event("pointerleave", button, handleOnPointerLeave), append($$anchor, button), pop();
}
__name(AttackButton, "AttackButton");
var root_3$n = /* @__PURE__ */ template("<!> <!>", 1), root_6$l = /* @__PURE__ */ template('<div class="la-combine-h clipped-alt la-bckg-header-anti -widthfull -margin2-l"><!></div>'), root_5$g = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull"><!> <!></div>'), root_10$b = /* @__PURE__ */ template('<div class="la-combine-h -widthfull"><!> <!></div>'), root_15$2 = /* @__PURE__ */ template("<!> <!>", 1), root_16$2 = /* @__PURE__ */ template("<!> <hr> <!>", 1), root_9$c = /* @__PURE__ */ template('<div class="la-generated -widthfull -gap2 la-combine-v"><!> <!> <!> <!> <!></div>');
function WeaponMod($$anchor, $$props) {
  push($$props, !0);
  let effectButtonHover = state(!1), editButtonHover = state(!1);
  const collID = $$props.mod ? `${$$props.mod.uuid}.action` : "empty", tooltipEnabled = getMechSheetTooltipEnabled();
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent_6 = /* @__PURE__ */ __name(($$anchor2) => {
      HeaderSecondary($$anchor2, {
        get uuid() {
          return $$props.mod.uuid;
        },
        get path() {
          return $$props.path;
        },
        acceptTypes: "weapon_mod",
        get text() {
          return $$props.mod.name;
        },
        headerStyle: [H2_HEADER_STYLE, "la-bckg-header-anti"],
        textStyle: [H2_TEXT_SIZE],
        borderStyle: ["la-brdr-weapon-mod"],
        extensionTextFunction: /* @__PURE__ */ __name(() => {
          if (get$1(effectButtonHover)) return `--${getLocalized("LA.use.label")}`;
          if (get$1(editButtonHover)) return `--${getLocalized("LA.edit.extension")}`;
        }, "extensionTextFunction"),
        get collapseID() {
          return $$props.mod.uuid;
        },
        startCollapsed: !0,
        renderOutsideCollapse: /* @__PURE__ */ __name(($$anchor3) => {
          var fragment_3 = comment(), node_3 = first_child(fragment_3);
          {
            var consequent_2 = /* @__PURE__ */ __name(($$anchor4) => {
              var div = root_5$g(), node_4 = child(div);
              {
                var consequent = /* @__PURE__ */ __name(($$anchor5) => {
                  var div_1 = root_6$l(), node_5 = child(div_1);
                  LimitedBox(node_5, {
                    get usesValue() {
                      return $$props.mod.system.uses.value;
                    },
                    get usesMax() {
                      return $$props.mod.system.uses.max;
                    },
                    get path() {
                      return $$props.path;
                    },
                    get logType() {
                      return TextLogHook.MechHeader;
                    },
                    get logTypeReset() {
                      return TextLogHook.MechHeaderReset;
                    }
                  }), append($$anchor5, div_1);
                }, "consequent");
                if_block(node_4, ($$render) => {
                  $$props.mod.system.uses.max && $$render(consequent);
                });
              }
              var node_6 = sibling(node_4, 2);
              {
                var consequent_1 = /* @__PURE__ */ __name(($$anchor5) => {
                  var fragment_4 = comment(), node_7 = first_child(fragment_4);
                  each(node_7, 17, () => $$props.mod.system.counters, index, ($$anchor6, counter, index2) => {
                    CounterBox($$anchor6, {
                      get text() {
                        return get$1(counter).name;
                      },
                      get type() {
                        return CounterBoxType.Counter;
                      },
                      get usesValue() {
                        return get$1(counter).value;
                      },
                      get usesMax() {
                        return get$1(counter).max;
                      },
                      get path() {
                        return `${$$props.path ?? ""}.system.counters.${index2 ?? ""}`;
                      },
                      get logType() {
                        return TextLogHook.MechHeader;
                      },
                      get logTypeReset() {
                        return TextLogHook.MechHeaderReset;
                      }
                    });
                  }), append($$anchor5, fragment_4);
                }, "consequent_1");
                if_block(node_6, ($$render) => {
                  $$props.mod.system.counters.length && $$render(consequent_1);
                });
              }
              append($$anchor4, div);
            }, "consequent_2");
            if_block(node_3, ($$render) => {
              ($$props.mod.system.uses.max || $$props.mod.system.counters.length) && $$render(consequent_2);
            });
          }
          append($$anchor3, fragment_3);
        }, "outerContent"),
        contentLeft: /* @__PURE__ */ __name(($$anchor3) => {
          const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_1 = /* @__PURE__ */ derived(() => $$props.mod.system.effect || getLocalized("LA.mech.mod.effect.tooltip")), expression_2 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.mod.effect.tooltip"));
          EffectButton($$anchor3, {
            iconStyle: ["cci", "cci-weaponmod", "-fontsize5"],
            iconBackgroundStyle: [
              "-fontsize5",
              "la-prmy-secondary",
              "-pulse-prmy"
            ],
            get flowClass() {
              return FlowClass.SendEffectToChat;
            },
            get path() {
              return $$props.path;
            },
            tooltipEnabled,
            get tooltipTheme() {
              return get$1(expression);
            },
            get tooltipDirection() {
              return TooltipDirection.LEFT;
            },
            get tooltip() {
              return get$1(expression_1);
            },
            get logText() {
              return get$1(expression_2);
            },
            get logType() {
              return TextLogHook.MechHeader;
            },
            get logTypeReset() {
              return TextLogHook.MechHeaderReset;
            },
            onPointerEnter: /* @__PURE__ */ __name(() => {
              set(effectButtonHover, !0);
            }, "onPointerEnter"),
            onPointerLeave: /* @__PURE__ */ __name(() => {
              set(effectButtonHover, !1);
            }, "onPointerLeave")
          });
        }, "headerSecondaryLeftOptions"),
        contentRight: /* @__PURE__ */ __name(($$anchor3) => {
          var fragment_2 = root_3$n(), node_1 = first_child(fragment_2);
          const expression_3 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.system.points.tooltip"));
          TotalSP(node_1, {
            get value() {
              return $$props.mod.system.sp;
            },
            style: [H2_TEXT_SIZE, "-margin1-r"],
            get logText() {
              return get$1(expression_3);
            },
            get logType() {
              return TextLogHook.MechHeader;
            },
            get logTypeReset() {
              return TextLogHook.MechHeaderReset;
            }
          });
          var node_2 = sibling(node_1, 2);
          const expression_4 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
          EditButton(node_2, {
            get flowClass() {
              return FlowClass.ContextMenu;
            },
            get path() {
              return $$props.path;
            },
            tooltipEnabled,
            get tooltipTheme() {
              return get$1(expression_4);
            },
            get logType() {
              return TextLogHook.MechHeader;
            },
            get logTypeReset() {
              return TextLogHook.MechHeaderReset;
            },
            onPointerEnter: /* @__PURE__ */ __name(() => {
              set(editButtonHover, !0);
            }, "onPointerEnter"),
            onPointerLeave: /* @__PURE__ */ __name(() => {
              set(editButtonHover, !1);
            }, "onPointerLeave")
          }), append($$anchor3, fragment_2);
        }, "headerSecondaryRightOptions"),
        children: /* @__PURE__ */ __name(($$anchor3, $$slotProps) => {
          var div_2 = root_9$c(), node_8 = child(div_2);
          {
            var consequent_5 = /* @__PURE__ */ __name(($$anchor4) => {
              var div_3 = root_10$b(), node_9 = child(div_3);
              {
                var consequent_3 = /* @__PURE__ */ __name(($$anchor5) => {
                  const expression_5 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.mod.range.label")), expression_6 = /* @__PURE__ */ derived(() => $$props.mod.system.added_range.length && $$props.mod.system.added_damage.length ? ["-bordersround"] : []);
                  EffectBox($$anchor5, {
                    get name() {
                      return get$1(expression_5);
                    },
                    innerStyle: ["-fontsize3"],
                    get outerStyle() {
                      return get$1(expression_6);
                    },
                    tooltipEnabled,
                    get logType() {
                      return TextLogHook.MechHeader;
                    },
                    get logTypeReset() {
                      return TextLogHook.MechHeaderReset;
                    },
                    children: /* @__PURE__ */ __name(($$anchor6, $$slotProps2) => {
                      RangeArray($$anchor6, {
                        get ranges() {
                          return $$props.mod.system.added_range;
                        }
                      });
                    }, "children"),
                    $$slots: { default: !0 }
                  });
                }, "consequent_3");
                if_block(node_9, ($$render) => {
                  $$props.mod.system.added_range.length && $$render(consequent_3);
                });
              }
              var node_10 = sibling(node_9, 2);
              {
                var consequent_4 = /* @__PURE__ */ __name(($$anchor5) => {
                  const expression_7 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.mod.damage.label"));
                  EffectBox($$anchor5, {
                    get name() {
                      return get$1(expression_7);
                    },
                    innerStyle: ["-fontsize3"],
                    tooltipEnabled,
                    get logType() {
                      return TextLogHook.MechHeader;
                    },
                    get logTypeReset() {
                      return TextLogHook.MechHeaderReset;
                    },
                    children: /* @__PURE__ */ __name(($$anchor6, $$slotProps2) => {
                      DamageArray($$anchor6, {
                        get damages() {
                          return $$props.mod.system.added_damage;
                        }
                      });
                    }, "children"),
                    $$slots: { default: !0 }
                  });
                }, "consequent_4");
                if_block(node_10, ($$render) => {
                  $$props.mod.system.added_damage.length && $$render(consequent_4);
                });
              }
              append($$anchor4, div_3);
            }, "consequent_5");
            if_block(node_8, ($$render) => {
              ($$props.mod.system.added_range.length || $$props.mod.system.added_damage.length) && $$render(consequent_5);
            });
          }
          var node_11 = sibling(node_8, 2);
          const expression_8 = /* @__PURE__ */ derived(() => `${$$props.path}.system.bonuses`);
          BonusBox(node_11, {
            get bonuses() {
              return $$props.mod.system.bonuses;
            },
            get bonusPath() {
              return get$1(expression_8);
            }
          });
          var node_12 = sibling(node_11, 2);
          const expression_9 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.mod.tags.label"));
          EffectBox(node_12, {
            get name() {
              return get$1(expression_9);
            },
            tooltipEnabled,
            get logType() {
              return TextLogHook.MechHeader;
            },
            get logTypeReset() {
              return TextLogHook.MechHeaderReset;
            },
            children: /* @__PURE__ */ __name(($$anchor4, $$slotProps2) => {
              var fragment_11 = root_15$2(), node_13 = first_child(fragment_11);
              const expression_10 = /* @__PURE__ */ derived(() => `${$$props.path}.system.added_tags`);
              TagArray(node_13, {
                get tags() {
                  return $$props.mod.system.added_tags;
                },
                get path() {
                  return get$1(expression_10);
                }
              });
              var node_14 = sibling(node_13, 2);
              const expression_11 = /* @__PURE__ */ derived(() => `${$$props.path}.system.tags`);
              TagArray(node_14, {
                get tags() {
                  return $$props.mod.system.tags;
                },
                get path() {
                  return get$1(expression_11);
                }
              }), append($$anchor4, fragment_11);
            }, "children"),
            $$slots: { default: !0 }
          });
          var node_15 = sibling(node_12, 2);
          const expression_12 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.mod.effect.label"));
          EffectBox(node_15, {
            get name() {
              return get$1(expression_12);
            },
            tooltipEnabled,
            get logType() {
              return TextLogHook.MechHeader;
            },
            get logTypeReset() {
              return TextLogHook.MechHeaderReset;
            },
            children: /* @__PURE__ */ __name(($$anchor4, $$slotProps2) => {
              var fragment_12 = root_16$2(), node_16 = first_child(fragment_12);
              const expression_13 = /* @__PURE__ */ derived(() => getLocalized("LA.use.label")), expression_14 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
              FlowButton(node_16, {
                style: ["clipped-bot", "la-bckg-secondary"],
                get text() {
                  return get$1(expression_13);
                },
                get flowClass() {
                  return FlowClass.SendEffectToChat;
                },
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_14);
                },
                get logType() {
                  return TextLogHook.MechHeader;
                },
                get logTypeReset() {
                  return TextLogHook.MechHeaderReset;
                }
              });
              var node_17 = sibling(node_16, 4);
              html(node_17, () => $$props.mod.system.effect), append($$anchor4, fragment_12);
            }, "children"),
            $$slots: { default: !0 }
          });
          var node_18 = sibling(node_15, 2);
          const expression_15 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
          ActionBox(node_18, {
            get actions() {
              return $$props.mod.system.actions;
            },
            get uuid() {
              return $$props.mod.uuid;
            },
            path: "system.actions",
            collapseID: collID,
            startCollapsed: !1,
            tooltipEnabled,
            get tooltipTheme() {
              return get$1(expression_15);
            },
            get logType() {
              return TextLogHook.MechHeader;
            },
            get logTypeReset() {
              return TextLogHook.MechHeaderReset;
            }
          }), append($$anchor3, div_2);
        }, "children"),
        $$slots: { default: !0 }
      });
    }, "consequent_6"), alternate = /* @__PURE__ */ __name(($$anchor2) => {
      const expression_16 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.mod.empty.label")), expression_17 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.mod.empty.subLabel"));
      EmptyBox($$anchor2, {
        get label() {
          return get$1(expression_16);
        },
        get subLabel() {
          return get$1(expression_17);
        },
        get type() {
          return AcceptType.MechWeaponMod;
        },
        get path() {
          return $$props.path;
        }
      });
    }, "alternate");
    if_block(node, ($$render) => {
      $$props.mod ? $$render(consequent_6) : $$render(alternate, !1);
    });
  }
  append($$anchor, fragment), pop();
}
__name(WeaponMod, "WeaponMod");
const _STYLE = " la-text-header la-bckg-pilot clipped -flex1 ";
var root_2$9 = /* @__PURE__ */ template('<button type="button" data-action="set"><span> </span></button>'), root_1$g = /* @__PURE__ */ template("<div></div>");
function ProfileBox($$anchor, $$props) {
  push($$props, !0);
  const logging = $$props.logType && $$props.logTypeReset, log = $$props.logText || getLocalized("LA.profile.tooltip");
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var div = root_1$g();
      each(div, 21, () => $$props.profiles, index, ($$anchor3, profile, index2) => {
        var button = root_2$9();
        set_attribute(button, "data-action-value", `(int)${index2 ?? ""}`);
        var span = child(button), text2 = child(span);
        template_effect(
          ($0) => {
            set_class(button, `la-prmy-primary -glow-prmy-hover -height5
            gen-control ${(index2 === $$props.weapon.system.selected_profile_index ? "-pulse-glow-prmy la-prmy-header la-bckg-secondary selected-profile -pointerdisable" : "") ?? ""}`), set_attribute(button, "data-path", $$props.path), set_attribute(button, "aria-label", $0), set_class(span, `-padding1-lr -fontsize1 -upper ${(index2 === $$props.weapon.system.selected_profile_index ? "-pulse-glow-prmy la-prmy-header -bold" : "") ?? ""}`), set_text(text2, get$1(profile).name);
          },
          [() => getLocalized("LA.use.label")]
        ), event("pointerenter", button, function(...$$args) {
          var _a;
          (_a = logging ? (event2) => sendToLog(event2, log, $$props.logType) : void 0) == null || _a.apply(this, $$args);
        }), event("pointerleave", button, function(...$$args) {
          var _a;
          (_a = logging ? (event2) => resetLog(event2, $$props.logTypeReset) : void 0) == null || _a.apply(this, $$args);
        }), append($$anchor3, button);
      }), template_effect(($0) => set_class(div, `la-limited la-combine-h ${$0 ?? ""}`), [() => {
        var _a;
        return ((_a = $$props.style) == null ? void 0 : _a.join(" ")) || _STYLE;
      }]), append($$anchor2, div);
    }, "consequent");
    if_block(node, ($$render) => {
      $$props.profiles.length > 1 && $$render(consequent);
    });
  }
  append($$anchor, fragment), pop();
}
__name(ProfileBox, "ProfileBox");
var root_1$f = /* @__PURE__ */ template('<div class="la-loading la-hexarray la-combine-h -aligncenter la-text-header -fontsize5"><span class="la-hexarray__span -fontsize4"> </span> <i class="cci cci-system-point"></i></div>');
function SPCostArray($$anchor, $$props) {
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var div = root_1$f(), span = child(div), text2 = child(span);
      template_effect(() => set_text(text2, $$props.cost)), append($$anchor2, div);
    }, "consequent");
    if_block(node, ($$render) => {
      $$props.cost && $$render(consequent);
    });
  }
  append($$anchor, fragment);
}
__name(SPCostArray, "SPCostArray");
var root_5$f = /* @__PURE__ */ template('<div class="la-combine-h clipped-alt la-bckg-header-anti -widthfull"><!> <!> <!></div>'), root_3$m = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull -padding2-l"><!> <!> <!></div>'), root_7$g = /* @__PURE__ */ template('<!> <div class="la-combine-v -margin3-lr"><!> <!></div>', 1), root_9$b = /* @__PURE__ */ template('<div class="la-generated -widthfull -gap2 la-combine-v"><!> <!> <!> <!> <!> <!> <!> <!></div>');
function Weapon$1($$anchor, $$props) {
  push($$props, !0);
  let attackButtonHover = state(!1), damageButtonHover = state(!1), messageButtonHover = state(!1), editButtonHover = state(!1);
  const tooltipEnabled = getMechSheetTooltipEnabled();
  function getSlotSize(size) {
    return size === "Flex" ? `${getLocalized(SLOT_LOCALIZE_MAP.Main)} || 2x ${getLocalized(SLOT_LOCALIZE_MAP.Auxiliary)}` : getLocalized(SLOT_LOCALIZE_MAP[size]) || "any";
  }
  __name(getSlotSize, "getSlotSize");
  function isDestroyed(weapon) {
    return weapon.system.destroyed;
  }
  __name(isDestroyed, "isDestroyed");
  function getHeaderStyle(weapon) {
    return isDestroyed(weapon) ? "la-text-repcap -strikethrough" : "la-text-header";
  }
  __name(getHeaderStyle, "getHeaderStyle");
  function getSubtitle(weapon) {
    return isDestroyed(weapon) ? getLocalized("LA.mech.slot.destroyed.label") : weapon.system.size && weapon.system.active_profile.type ? `${weapon.system.size} ${weapon.system.active_profile.type}` : getLocalized("LA.placeholder");
  }
  __name(getSubtitle, "getSubtitle");
  function getSubtitleStyle(weapon) {
    return isDestroyed(weapon) ? "la-text-error la-prmy-error horus--very--subtle -upper" : "la-text-header la-prmy-header -upper";
  }
  __name(getSubtitleStyle, "getSubtitleStyle");
  function getIconStyle(weapon) {
    return isDestroyed(weapon) ? "la-text-repcap" : "la-prmy-header -glow-prmy la-scdy-primary -glow-scdy-hover";
  }
  __name(getIconStyle, "getIconStyle");
  function getWeaponPath(index2) {
    return `system.loadout.weapon_mounts.${$$props.mountIndex}.slots.${index2}.weapon.value`;
  }
  __name(getWeaponPath, "getWeaponPath");
  function getModPath(index2) {
    return `system.loadout.weapon_mounts.${$$props.mountIndex}.slots.${index2}.mod.value`;
  }
  __name(getModPath, "getModPath");
  function getActionCollapseID(index2, profileIndex) {
    return profileIndex !== void 0 ? `${$$props.mount.uuid}.action.${index2}.profile.${profileIndex}` : `${$$props.mount.uuid}.action.${index2}`;
  }
  __name(getActionCollapseID, "getActionCollapseID");
  function renderOuter(weapon) {
    return weapon.system.sp || isLoading(weapon) || weapon.isLimited() || weapon.system.mod || weapon.system.profiles.length > 1;
  }
  __name(renderOuter, "renderOuter");
  function getRollWeaponTip(weapon) {
    return formatString(getLocalized("LA.flow.rollAttack.template.tooltip"), weapon.name);
  }
  __name(getRollWeaponTip, "getRollWeaponTip");
  function sendToChat(event2, weapon) {
    if (event2.stopPropagation(), $$props.actor && weapon) {
      let chatData = {
        title: weapon.name,
        effect: weapon.system.active_profile.effect,
        onAttack: weapon.system.active_profile.on_attack,
        onHit: weapon.system.active_profile.on_hit,
        onCrit: weapon.system.active_profile.on_crit,
        tags: weapon.system.active_profile.tags
      };
      SendUnknownToChatBase.getInstance().startFlow($$props.actor.uuid, chatData);
    }
  }
  __name(sendToChat, "sendToChat");
  var fragment = comment(), node = first_child(fragment);
  each(node, 17, () => $$props.mount.slots, index, ($$anchor2, slot, index2) => {
    var fragment_1 = comment(), node_1 = first_child(fragment_1);
    {
      var consequent_4 = /* @__PURE__ */ __name(($$anchor3) => {
        const weapon = /* @__PURE__ */ derived(() => get$1(slot).weapon.value), outerContent = /* @__PURE__ */ __name(($$anchor4) => {
          var div = root_3$m(), node_2 = child(div);
          {
            var consequent = /* @__PURE__ */ __name(($$anchor5) => {
              const expression = /* @__PURE__ */ derived(() => `${getModPath(index2)}`);
              WeaponMod($$anchor5, {
                get actor() {
                  return $$props.actor;
                },
                get mod() {
                  return get$1(weapon).system.mod;
                },
                get path() {
                  return get$1(expression);
                }
              });
            }, "consequent");
            if_block(node_2, ($$render) => {
              get$1(slot).size !== "Integrated" && get$1(weapon).system.mod && $$render(consequent);
            });
          }
          var node_3 = sibling(node_2, 2);
          {
            var consequent_1 = /* @__PURE__ */ __name(($$anchor5) => {
              var div_1 = root_5$f(), node_4 = child(div_1);
              const expression_1 = /* @__PURE__ */ derived(() => getWeaponPath(index2));
              LoadedBox(node_4, {
                get item() {
                  return get$1(weapon);
                },
                get path() {
                  return get$1(expression_1);
                },
                get logType() {
                  return TextLogHook.MechHeader;
                },
                get logTypeReset() {
                  return TextLogHook.MechHeaderReset;
                }
              });
              var node_5 = sibling(node_4, 2);
              const expression_2 = /* @__PURE__ */ derived(() => getWeaponPath(index2));
              LimitedBox(node_5, {
                get usesValue() {
                  return get$1(weapon).system.uses.value;
                },
                get usesMax() {
                  return get$1(weapon).system.uses.max;
                },
                get path() {
                  return get$1(expression_2);
                },
                get logType() {
                  return TextLogHook.MechHeader;
                },
                get logTypeReset() {
                  return TextLogHook.MechHeaderReset;
                }
              });
              var node_6 = sibling(node_5, 2);
              SPCostArray(node_6, {
                get cost() {
                  return get$1(weapon).system.sp;
                }
              }), append($$anchor5, div_1);
            }, "consequent_1");
            if_block(node_3, ($$render) => {
              (isLoading(get$1(weapon)) || get$1(weapon).isLimited() || get$1(weapon).system.sp) && $$render(consequent_1);
            });
          }
          var node_7 = sibling(node_3, 2);
          const expression_3 = /* @__PURE__ */ derived(() => `${getWeaponPath(index2)}.system.selected_profile_index`);
          ProfileBox(node_7, {
            get profiles() {
              return get$1(weapon).system.profiles;
            },
            get weapon() {
              return get$1(weapon);
            },
            get path() {
              return get$1(expression_3);
            },
            style: [
              "-widthfull",
              "la-bckg-header-anti",
              "la-text-header",
              "clipped-alt"
            ],
            get logType() {
              return TextLogHook.MechHeader;
            },
            get logTypeReset() {
              return TextLogHook.MechHeaderReset;
            }
          }), append($$anchor4, div);
        }, "outerContent"), headerTertiaryLeftOptions = /* @__PURE__ */ __name(($$anchor4) => {
          const expression_4 = /* @__PURE__ */ derived(() => [
            H3_ICON_SIZE,
            getIconStyle(get$1(weapon)),
            "cci",
            "cci-weapon"
          ]), expression_5 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_6 = /* @__PURE__ */ derived(() => getRollWeaponTip(get$1(weapon))), expression_7 = /* @__PURE__ */ derived(() => getRollWeaponTip(get$1(weapon))), expression_8 = /* @__PURE__ */ derived(() => isDestroyed(get$1(weapon)));
          AttackButton($$anchor4, {
            get iconStyle() {
              return get$1(expression_4);
            },
            iconBackgroundStyle: [
              H3_ICON_SIZE,
              "la-prmy-secondary",
              "-pulse-prmy"
            ],
            get flowClass() {
              return FlowClass.RollAttack;
            },
            path: `system.loadout.weapon_mounts.${index2}`,
            tooltipEnabled,
            get tooltipTheme() {
              return get$1(expression_5);
            },
            get tooltipDirection() {
              return TooltipDirection.LEFT;
            },
            get tooltip() {
              return get$1(expression_6);
            },
            get logText() {
              return get$1(expression_7);
            },
            get logType() {
              return TextLogHook.MechHeader;
            },
            get logTypeReset() {
              return TextLogHook.MechHeaderReset;
            },
            get disabled() {
              return get$1(expression_8);
            },
            onPointerEnter: /* @__PURE__ */ __name(() => {
              set(attackButtonHover, !0);
            }, "onPointerEnter"),
            onPointerLeave: /* @__PURE__ */ __name(() => {
              set(attackButtonHover, !1);
            }, "onPointerLeave")
          });
        }, "headerTertiaryLeftOptions"), headerTertiaryRightOptions = /* @__PURE__ */ __name(($$anchor4) => {
          var fragment_4 = root_7$g(), node_8 = first_child(fragment_4);
          const expression_9 = /* @__PURE__ */ derived(() => isDestroyed(get$1(weapon)) ? ["la-text-repcap"] : void 0), expression_10 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_11 = /* @__PURE__ */ derived(() => isDestroyed(get$1(weapon)));
          DamageButton(node_8, {
            get iconStyle() {
              return get$1(expression_9);
            },
            iconBackgroundStyle: [
              "-fontsize7",
              "la-prmy-secondary",
              "-pulse-prmy"
            ],
            get flowClass() {
              return FlowClass.RollDamage;
            },
            get range() {
              return get$1(weapon).system.active_profile.all_range;
            },
            get damage() {
              return get$1(weapon).system.active_profile.all_damage;
            },
            tooltipEnabled,
            get tooltipTheme() {
              return get$1(expression_10);
            },
            get tooltipDirection() {
              return TooltipDirection.UP;
            },
            get logType() {
              return TextLogHook.MechHeader;
            },
            get logTypeReset() {
              return TextLogHook.MechHeaderReset;
            },
            get disabled() {
              return get$1(expression_11);
            },
            onPointerEnter: /* @__PURE__ */ __name(() => {
              set(damageButtonHover, !0);
            }, "onPointerEnter"),
            onPointerLeave: /* @__PURE__ */ __name(() => {
              set(damageButtonHover, !1);
            }, "onPointerLeave")
          });
          var div_2 = sibling(node_8, 2), node_9 = child(div_2);
          const expression_12 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
          MessageButton(node_9, {
            get flowClass() {
              return FlowClass.None;
            },
            get uuid() {
              return get$1(weapon).uuid;
            },
            tooltipEnabled,
            get tooltipTheme() {
              return get$1(expression_12);
            },
            get logType() {
              return TextLogHook.MechHeader;
            },
            get logTypeReset() {
              return TextLogHook.MechHeaderReset;
            },
            onClick: /* @__PURE__ */ __name((event2) => sendToChat(event2, get$1(weapon)), "onClick"),
            onPointerEnter: /* @__PURE__ */ __name(() => {
              set(messageButtonHover, !0);
            }, "onPointerEnter"),
            onPointerLeave: /* @__PURE__ */ __name(() => {
              set(messageButtonHover, !1);
            }, "onPointerLeave")
          });
          var node_10 = sibling(node_9, 2);
          const expression_13 = /* @__PURE__ */ derived(() => getWeaponPath(index2)), expression_14 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
          EditButton(node_10, {
            get flowClass() {
              return FlowClass.ContextMenu;
            },
            get path() {
              return get$1(expression_13);
            },
            tooltipEnabled,
            get tooltipTheme() {
              return get$1(expression_14);
            },
            get logType() {
              return TextLogHook.MechHeader;
            },
            get logTypeReset() {
              return TextLogHook.MechHeaderReset;
            },
            onPointerEnter: /* @__PURE__ */ __name(() => {
              set(editButtonHover, !0);
            }, "onPointerEnter"),
            onPointerLeave: /* @__PURE__ */ __name(() => {
              set(editButtonHover, !1);
            }, "onPointerLeave")
          }), append($$anchor4, fragment_4);
        }, "headerTertiaryRightOptions"), expression_15 = /* @__PURE__ */ derived(() => getWeaponPath(index2)), expression_16 = /* @__PURE__ */ derived(() => [
          getHeaderStyle(get$1(weapon)),
          "-fontsize2"
        ]), expression_17 = /* @__PURE__ */ derived(() => getSubtitle(get$1(weapon))), expression_18 = /* @__PURE__ */ derived(() => [
          getSubtitleStyle(get$1(weapon)),
          "-fontsize0"
        ]), expression_19 = /* @__PURE__ */ derived(() => renderOuter(get$1(weapon)) ? outerContent : void 0);
        HeaderTertiary($$anchor3, {
          get itemID() {
            return get$1(weapon).id;
          },
          get uuid() {
            return get$1(weapon).uuid;
          },
          get path() {
            return get$1(expression_15);
          },
          acceptTypes: "mech_weapon",
          get collapseID() {
            return get$1(weapon).uuid;
          },
          startCollapsed: !0,
          get text() {
            return get$1(weapon).name;
          },
          headerStyle: [H3_HEADER_STYLE, "la-bckg-pilot"],
          get headerFontStyle() {
            return get$1(expression_16);
          },
          get subText() {
            return get$1(expression_17);
          },
          get subHeaderFontStyle() {
            return get$1(expression_18);
          },
          borderStyle: ["-bordersoff"],
          extensionTextFunction: /* @__PURE__ */ __name(() => {
            if (get$1(attackButtonHover)) return `--${getLocalized("LA.flow.rollAttack.extension")}`;
            if (get$1(damageButtonHover)) return `--${getLocalized("LA.flow.rollDamage.extension")}`;
            if (get$1(messageButtonHover)) return `--${getLocalized("LA.chat.extension")}`;
            if (get$1(editButtonHover)) return `--${getLocalized("LA.edit.extension")}`;
          }, "extensionTextFunction"),
          get renderOutsideCollapse() {
            return get$1(expression_19);
          },
          contentLeft: headerTertiaryLeftOptions,
          contentRight: headerTertiaryRightOptions,
          children: /* @__PURE__ */ __name(($$anchor4, $$slotProps) => {
            var fragment_6 = comment(), node_11 = first_child(fragment_6);
            {
              var consequent_3 = /* @__PURE__ */ __name(($$anchor5) => {
                var div_3 = root_9$b();
                const profile = /* @__PURE__ */ derived(() => get$1(weapon).system.active_profile);
                var node_12 = child(div_3);
                const expression_20 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.system.effect.label"));
                EffectBox(node_12, {
                  get name() {
                    return get$1(expression_20);
                  },
                  get effect() {
                    return get$1(profile).effect;
                  },
                  tooltipEnabled,
                  get logType() {
                    return TextLogHook.MechHeader;
                  },
                  get logTypeReset() {
                    return TextLogHook.MechHeaderReset;
                  }
                });
                var node_13 = sibling(node_12, 2);
                const expression_21 = /* @__PURE__ */ derived(() => getLocalized("LA.effect.attack.label"));
                EffectBox(node_13, {
                  get name() {
                    return get$1(expression_21);
                  },
                  get effect() {
                    return get$1(profile).on_attack;
                  },
                  tooltipEnabled,
                  get logType() {
                    return TextLogHook.MechHeader;
                  },
                  get logTypeReset() {
                    return TextLogHook.MechHeaderReset;
                  }
                });
                var node_14 = sibling(node_13, 2);
                const expression_22 = /* @__PURE__ */ derived(() => getLocalized("LA.effect.hit.label"));
                EffectBox(node_14, {
                  get name() {
                    return get$1(expression_22);
                  },
                  get effect() {
                    return get$1(profile).on_hit;
                  },
                  tooltipEnabled,
                  get logType() {
                    return TextLogHook.MechHeader;
                  },
                  get logTypeReset() {
                    return TextLogHook.MechHeaderReset;
                  }
                });
                var node_15 = sibling(node_14, 2);
                const expression_23 = /* @__PURE__ */ derived(() => getLocalized("LA.effect.crit.label"));
                EffectBox(node_15, {
                  get name() {
                    return get$1(expression_23);
                  },
                  get effect() {
                    return get$1(profile).on_crit;
                  },
                  tooltipEnabled,
                  get logType() {
                    return TextLogHook.MechHeader;
                  },
                  get logTypeReset() {
                    return TextLogHook.MechHeaderReset;
                  }
                });
                var node_16 = sibling(node_15, 2);
                const expression_24 = /* @__PURE__ */ derived(() => getActionCollapseID(index2)), expression_25 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
                ActionBox(node_16, {
                  get actions() {
                    return get$1(weapon).system.actions;
                  },
                  get uuid() {
                    return get$1(weapon).uuid;
                  },
                  path: "system.actions",
                  get collapseID() {
                    return get$1(expression_24);
                  },
                  startCollapsed: !1,
                  tooltipEnabled,
                  get tooltipTheme() {
                    return get$1(expression_25);
                  },
                  get logType() {
                    return TextLogHook.MechHeader;
                  },
                  get logTypeReset() {
                    return TextLogHook.MechHeaderReset;
                  }
                });
                var node_17 = sibling(node_16, 2);
                const expression_26 = /* @__PURE__ */ derived(() => getActionCollapseID(index2, get$1(weapon).system.selected_profile_index)), expression_27 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
                ActionBox(node_17, {
                  get actions() {
                    return get$1(profile).actions;
                  },
                  get uuid() {
                    return get$1(weapon).uuid;
                  },
                  path: "system.active_profile.actions",
                  get collapseID() {
                    return get$1(expression_26);
                  },
                  startCollapsed: !1,
                  tooltipEnabled,
                  get tooltipTheme() {
                    return get$1(expression_27);
                  },
                  get logType() {
                    return TextLogHook.MechHeader;
                  },
                  get logTypeReset() {
                    return TextLogHook.MechHeaderReset;
                  }
                });
                var node_18 = sibling(node_17, 2);
                {
                  var consequent_2 = /* @__PURE__ */ __name(($$anchor6) => {
                    const expression_28 = /* @__PURE__ */ derived(() => `${getModPath(index2)}`);
                    WeaponMod($$anchor6, {
                      get actor() {
                        return $$props.actor;
                      },
                      get mod() {
                        return get$1(weapon).system.mod;
                      },
                      get path() {
                        return get$1(expression_28);
                      }
                    });
                  }, "consequent_2");
                  if_block(node_18, ($$render) => {
                    get$1(slot).size !== "Integrated" && !get$1(weapon).system.mod && $$render(consequent_2);
                  });
                }
                var node_19 = sibling(node_18, 2);
                const expression_29 = /* @__PURE__ */ derived(() => `${getWeaponPath(index2)}.system.profiles.${get$1(weapon).system.selected_profile_index}.all_tags`);
                TagArray(node_19, {
                  get tags() {
                    return get$1(profile).all_tags;
                  },
                  get path() {
                    return get$1(expression_29);
                  },
                  justify: "start"
                }), append($$anchor5, div_3);
              }, "consequent_3");
              if_block(node_11, ($$render) => {
                get$1(weapon).system.destroyed || $$render(consequent_3);
              });
            }
            append($$anchor4, fragment_6);
          }, "children"),
          $$slots: { default: !0 }
        });
      }, "consequent_4"), alternate_1 = /* @__PURE__ */ __name(($$anchor3) => {
        var fragment_8 = comment(), node_20 = first_child(fragment_8);
        {
          var consequent_5 = /* @__PURE__ */ __name(($$anchor4) => {
          }, "consequent_5"), alternate = /* @__PURE__ */ __name(($$anchor4) => {
            const expression_30 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.mount.empty.label")), expression_31 = /* @__PURE__ */ derived(() => getSlotSize($$props.mount.slots[0].size)), expression_32 = /* @__PURE__ */ derived(() => getWeaponPath(index2));
            EmptyBox($$anchor4, {
              get label() {
                return get$1(expression_30);
              },
              get subLabel() {
                return get$1(expression_31);
              },
              get type() {
                return AcceptType.MechWeapon;
              },
              get path() {
                return get$1(expression_32);
              }
            });
          }, "alternate");
          if_block(node_20, ($$render) => {
            var _a;
            index2 === 1 && $$props.mount.slots[0].size === "Flex" && ((_a = $$props.mount.slots[0].weapon) == null ? void 0 : _a.value.system.size) !== "Auxiliary" ? $$render(consequent_5) : $$render(alternate, !1);
          });
        }
        append($$anchor3, fragment_8);
      }, "alternate_1");
      if_block(node_1, ($$render) => {
        var _a;
        (_a = get$1(slot).weapon) != null && _a.value ? $$render(consequent_4) : $$render(alternate_1, !1);
      });
    }
    append($$anchor2, fragment_1);
  }), append($$anchor, fragment), pop();
}
__name(Weapon$1, "Weapon$1");
var root_2$8 = /* @__PURE__ */ template("<span> </span>"), root_1$e = /* @__PURE__ */ template("<div></div>");
function MountNames($$anchor, $$props) {
  push($$props, !0);
  const logging = $$props.logType && $$props.logTypeReset, log = $$props.logText || getLocalized("LA.flow.rollAttack.tooltip");
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var div = root_1$e();
      each(div, 21, () => $$props.mountNames, index, ($$anchor3, mountName) => {
        var span = root_2$8(), text2 = child(span);
        template_effect(
          ($0) => {
            set_class(span, `-widthfull -textalignright ${$0 ?? ""}`), set_text(text2, get$1(mountName));
          },
          [() => {
            var _a;
            return (_a = $$props.textStyle) == null ? void 0 : _a.join(" ");
          }]
        ), append($$anchor3, span);
      }), template_effect(($0) => set_class(div, `la-combine-v la-text-header -gap0 -aligncenter -fontsize0 -height3 -lineheight0 ${$0 ?? ""}`), [() => {
        var _a;
        return (_a = $$props.style) == null ? void 0 : _a.join(" ");
      }]), event("pointerenter", div, function(...$$args) {
        var _a;
        (_a = logging ? (event2) => sendToLog(event2, log, $$props.logType) : void 0) == null || _a.apply(this, $$args);
      }), event("pointerleave", div, function(...$$args) {
        var _a;
        (_a = logging ? (event2) => resetLog(event2, $$props.logTypeReset) : void 0) == null || _a.apply(this, $$args);
      }), append($$anchor2, div);
    }, "consequent");
    if_block(node, ($$render) => {
      $$props.mountNames.length && $$render(consequent);
    });
  }
  append($$anchor, fragment), pop();
}
__name(MountNames, "MountNames");
var root_3$l = /* @__PURE__ */ template("<!> <!>", 1), root_6$k = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull"><!></div>');
function Mounts($$anchor, $$props) {
  push($$props, !0);
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor, system } = props;
  let collapseAllButtonHover = state(!1);
  const tooltipEnabled = getMechSheetTooltipEnabled(), weaponMounts = system.loadout.weapon_mounts;
  function getCollapseID(index2) {
    return `${actor.uuid}.mount.${index2}`;
  }
  __name(getCollapseID, "getCollapseID");
  function aggregateMountWeaponNames(mount2) {
    return mount2.slots.map((slot) => {
      var _a;
      return (_a = slot.weapon) == null ? void 0 : _a.value.name;
    }).filter((name) => name !== void 0);
  }
  __name(aggregateMountWeaponNames, "aggregateMountWeaponNames");
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent_1 = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment_1 = comment(), node_1 = first_child(fragment_1);
      each(node_1, 17, () => weaponMounts, index, ($$anchor3, mount2, index2) => {
        const headerOptions = /* @__PURE__ */ __name(($$anchor4) => {
          var fragment_2 = root_3$l(), node_2 = first_child(fragment_2);
          const expression = /* @__PURE__ */ derived(() => aggregateMountWeaponNames(get$1(mount2))), expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.mount.preview.tooltip"));
          MountNames(node_2, {
            get mountNames() {
              return get$1(expression);
            },
            get logText() {
              return get$1(expression_1);
            },
            get logType() {
              return TextLogHook.MechHeader;
            },
            get logTypeReset() {
              return TextLogHook.MechHeaderReset;
            }
          });
          var node_3 = sibling(node_2, 2);
          const expression_2 = /* @__PURE__ */ derived(() => getCollapseID(index2)), expression_3 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid));
          CollapseAllButton(node_3, {
            get collapseID() {
              return get$1(expression_2);
            },
            tooltipEnabled,
            get tooltipTheme() {
              return get$1(expression_3);
            },
            get logType() {
              return TextLogHook.MechHeader;
            },
            get logTypeReset() {
              return TextLogHook.MechHeaderReset;
            },
            onPointerEnter: /* @__PURE__ */ __name(() => {
              set(collapseAllButtonHover, !0);
            }, "onPointerEnter"),
            onPointerLeave: /* @__PURE__ */ __name(() => {
              set(collapseAllButtonHover, !1);
            }, "onPointerLeave")
          }), append($$anchor4, fragment_2);
        }, "headerOptions"), expression_4 = /* @__PURE__ */ derived(() => getLocalized(MOUNT_LOCALIZE_MAP[get$1(mount2).type])), expression_5 = /* @__PURE__ */ derived(() => getCollapseID(index2));
        HeaderMain($$anchor3, {
          get text() {
            return get$1(expression_4);
          },
          headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-primary"],
          textStyle: [
            "la-text-header",
            "-fontsize2",
            "-overflowhidden"
          ],
          borderStyle: ["la-brdr-primary"],
          extensionTextFunction: /* @__PURE__ */ __name(() => {
            if (get$1(collapseAllButtonHover)) return `--${getLocalized("LA.collapseAll.extension")}`;
          }, "extensionTextFunction"),
          get collapseID() {
            return get$1(expression_5);
          },
          startCollapsed: !0,
          headerContent: headerOptions,
          children: /* @__PURE__ */ __name(($$anchor4, $$slotProps) => {
            var fragment_4 = comment(), node_4 = first_child(fragment_4);
            {
              var consequent = /* @__PURE__ */ __name(($$anchor5) => {
                const expression_6 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.mount.locked.label")), expression_7 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.mount.locked.subLabel"));
                EmptyBox($$anchor5, {
                  get label() {
                    return get$1(expression_6);
                  },
                  get subLabel() {
                    return get$1(expression_7);
                  }
                });
              }, "consequent"), alternate = /* @__PURE__ */ __name(($$anchor5) => {
                var div = root_6$k(), node_5 = child(div);
                Weapon$1(node_5, {
                  actor,
                  get mount() {
                    return get$1(mount2);
                  },
                  mountIndex: index2
                }), append($$anchor5, div);
              }, "alternate");
              if_block(node_4, ($$render) => {
                get$1(mount2).bracing ? $$render(consequent) : $$render(alternate, !1);
              });
            }
            append($$anchor4, fragment_4);
          }, "children"),
          $$slots: { default: !0 }
        });
      }), append($$anchor2, fragment_1);
    }, "consequent_1");
    if_block(node, ($$render) => {
      system.loadout.frame && weaponMounts.length && $$render(consequent_1);
    });
  }
  append($$anchor, fragment), pop();
}
__name(Mounts, "Mounts");
const _PilotSheetLocalSettings = class _PilotSheetLocalSettings {
  static emptyContent() {
    return {
      sidebarRatio: 1
    };
  }
};
__name(_PilotSheetLocalSettings, "PilotSheetLocalSettings");
let PilotSheetLocalSettings = _PilotSheetLocalSettings;
const _PilotSheetSettings = class _PilotSheetSettings {
  static emptyContent() {
    return {
      headerImgOffsetY: 0,
      headerImgOffsetX: 0,
      themeOverride: "",
      sidebarExes: [
        SystemButton.SkillTriggerOther,
        SystemButton.BasicAttack,
        SystemButton.Damage
      ],
      bondImageSrc: "modules/lancer-alternative-sheets/assets/nobond.webp",
      syncActorTokenImages: !0
    };
  }
};
__name(_PilotSheetSettings, "PilotSheetSettings");
let PilotSheetSettings = _PilotSheetSettings;
function registerPilotSheetSettings() {
  game.settings.register(LancerAlternative.Name, "pilot-settings-tip", {
    name: "LA.SETTINGS.pilot.enableTooltip.label",
    hint: "LA.SETTINGS.pilot.enableTooltip.subLabel",
    scope: "client",
    config: !0,
    type: Boolean,
    default: !0
  }), game.settings.register(LancerAlternative.Name, "pilot-settings-log-header", {
    name: "LA.SETTINGS.pilot.enableHeaderLog.label",
    hint: "LA.SETTINGS.pilot.enableHeaderLog.subLabel",
    scope: "client",
    config: !0,
    type: Boolean,
    default: !0
  }), game.settings.register(LancerAlternative.Name, "pilot-settings-log-action-sidebar", {
    name: "LA.SETTINGS.pilot.enableSidebarActionLog.label",
    hint: "LA.SETTINGS.pilot.enableSidebarActionLog.subLabel",
    scope: "client",
    config: !0,
    type: Boolean,
    default: !0
  }), game.settings.register(LancerAlternative.Name, "pilot-settings-log-action-save-collapse", {
    name: "LA.SETTINGS.pilot.saveCollapse.label",
    hint: "LA.SETTINGS.pilot.saveCollapse.subLabel",
    scope: "client",
    config: !0,
    type: Boolean,
    default: !1
  }), game.settings.register(LancerAlternative.Name, "pilot-settings-log-action-start-collapsed", {
    name: "LA.SETTINGS.pilot.startCollapsed.label",
    hint: "LA.SETTINGS.pilot.startCollapsed.subLabel",
    scope: "client",
    config: !0,
    type: Boolean,
    default: !0
  }), game.settings.register(LancerAlternative.Name, "pilot-settings-enable-sensors", {
    name: "LA.SETTINGS.pilot.enableSensors.label",
    hint: "LA.SETTINGS.pilot.enableSensors.subLabel",
    scope: "world",
    config: !0,
    type: Boolean,
    default: !1
  }), game.settings.register(LancerAlternative.Name, "pilot-settings-enable-tech-attack", {
    name: "LA.SETTINGS.pilot.enableTechAttack.label",
    hint: "LA.SETTINGS.pilot.enableTechAttack.subLabel",
    scope: "world",
    config: !0,
    type: Boolean,
    default: !1
  }), game.settings.register(LancerAlternative.Name, "_pilot-settings-local", {
    scope: "client",
    config: !1,
    type: String,
    default: ""
  }), game.settings.register(LancerAlternative.Name, "_pilot-settings-local-version", {
    scope: "client",
    config: !1,
    type: String,
    // JSON object
    default: ""
  }), game.settings.register(LancerAlternative.Name, "_pilot-settings", {
    scope: "world",
    config: !1,
    type: Array,
    // MessagePack encoded object
    default: []
  }), game.settings.register(LancerAlternative.Name, "_pilot-settings-version", {
    scope: "world",
    config: !1,
    type: String,
    default: ""
  }), SocketManager.getInstance().register(setPilotSheetData);
}
__name(registerPilotSheetSettings, "registerPilotSheetSettings");
function getPilotSheetTooltipEnabled() {
  return game.settings.get(LancerAlternative.Name, "pilot-settings-tip");
}
__name(getPilotSheetTooltipEnabled, "getPilotSheetTooltipEnabled");
function getPilotSheetLogActionDontSaveCollapse() {
  return !game.settings.get(LancerAlternative.Name, "pilot-settings-log-action-save-collapse");
}
__name(getPilotSheetLogActionDontSaveCollapse, "getPilotSheetLogActionDontSaveCollapse");
function getPilotSheetLogActionStartCollapsed() {
  return game.settings.get(LancerAlternative.Name, "pilot-settings-log-action-start-collapsed");
}
__name(getPilotSheetLogActionStartCollapsed, "getPilotSheetLogActionStartCollapsed");
function getPilotSheetSensorsEnabled() {
  return game.settings.get(LancerAlternative.Name, "pilot-settings-enable-sensors");
}
__name(getPilotSheetSensorsEnabled, "getPilotSheetSensorsEnabled");
function getPilotSheetTechAttackEnabled() {
  return game.settings.get(LancerAlternative.Name, "pilot-settings-enable-tech-attack");
}
__name(getPilotSheetTechAttackEnabled, "getPilotSheetTechAttackEnabled");
function resetPilotSheetLocalData(uuid) {
  if (uuid) {
    const data = getPilotSheetLocalData();
    data[uuid] && delete data[uuid], setPilotSheetLocalData(data);
  } else {
    const data = new PilotSheetLocalSettings();
    setPilotSheetLocalData(data);
  }
}
__name(resetPilotSheetLocalData, "resetPilotSheetLocalData");
function getPilotSheetLocalData() {
  try {
    const settings = game.settings.get(LancerAlternative.Name, "_pilot-settings-local");
    return JSON.parse(settings);
  } catch {
    return new PilotSheetLocalSettings();
  }
}
__name(getPilotSheetLocalData, "getPilotSheetLocalData");
function setPilotSheetLocalData(data) {
  const encoded = JSON.stringify(data);
  return Promise.all([
    game.settings.set(LancerAlternative.Name, "_pilot-settings-local", encoded),
    game.settings.set(LancerAlternative.Name, "_pilot-settings-local-version", getModuleVersion())
  ]);
}
__name(setPilotSheetLocalData, "setPilotSheetLocalData");
function getSidebarRatio(uuid) {
  var _a;
  return ((_a = getPilotSheetLocalData()[uuid]) == null ? void 0 : _a.sidebarRatio) ?? 1;
}
__name(getSidebarRatio, "getSidebarRatio");
function setSidebarRatio(uuid, value) {
  const data = getPilotSheetLocalData();
  data[uuid] || (data[uuid] = PilotSheetLocalSettings.emptyContent()), data[uuid].sidebarRatio = value, setPilotSheetLocalData(data);
}
__name(setSidebarRatio, "setSidebarRatio");
function resetPilotSheetData(uuid) {
  var _a, _b;
  if (uuid) {
    const data = getPilotSheetData();
    data[uuid] && delete data[uuid], setPilotSheetData(encodePilotSheetData(data));
  } else
    game.settings.set(LancerAlternative.Name, "_pilot-settings", (_a = game.settings.settings.get(`${LancerAlternative.Name}._pilot-settings`)) == null ? void 0 : _a.default), game.settings.set(LancerAlternative.Name, "_pilot-settings-version", (_b = game.settings.settings.get(`${LancerAlternative.Name}._pilot-settings-version`)) == null ? void 0 : _b.default);
}
__name(resetPilotSheetData, "resetPilotSheetData");
function getPilotSheetData() {
  const settings = game.settings.get(LancerAlternative.Name, "_pilot-settings");
  if (!game.settings.get(LancerAlternative.Name, "_pilot-settings-version") || !settings.length)
    return new PilotSheetSettings();
  try {
    let encoded = new Uint8Array(Object.values(settings));
    return encoded.length === 1 && (Logger.log("PilotSheetSettings: Decoding failed, trying legacy decode."), encoded = new Uint8Array(Object.values(settings[0]))), msgPackDecoder.decode(encoded);
  } catch {
    return Logger.error("PilotSheetSettings: Decoding failed, returning empty settings."), new PilotSheetSettings();
  }
}
__name(getPilotSheetData, "getPilotSheetData");
function migratedDefaults$2(uuid, data) {
  const defaultSettings = PilotSheetSettings.emptyContent();
  return defaultSettings.syncActorTokenImages = determineActorTokenSync$2(uuid, data), defaultSettings;
}
__name(migratedDefaults$2, "migratedDefaults$2");
function encodePilotSheetData(data) {
  const encoded = msgPackEncoder.encode(data);
  return Array.from(encoded);
}
__name(encodePilotSheetData, "encodePilotSheetData");
function setPilotSheetData(encoded) {
  return Promise.all([
    game.settings.set(LancerAlternative.Name, "_pilot-settings", encoded),
    game.settings.set(LancerAlternative.Name, "_pilot-settings-version", getModuleVersion())
  ]);
}
__name(setPilotSheetData, "setPilotSheetData");
function setImageOffsetXY(uuid, x, y) {
  const data = getPilotSheetData();
  data[uuid] || (data[uuid] = migratedDefaults$2(uuid, data)), data[uuid].headerImgOffsetX = x, data[uuid].headerImgOffsetY = y, SocketManager.getInstance().runAsGM(
    setPilotSheetData,
    () => {
      Logger.log(`Image offset (X, Y) set to (${x}, ${y}) for ${uuid}`);
    },
    encodePilotSheetData(data)
  );
}
__name(setImageOffsetXY, "setImageOffsetXY");
function getImageOffsetY(uuid) {
  var _a;
  return ((_a = getPilotSheetData()[uuid]) == null ? void 0 : _a.headerImgOffsetY) ?? 0;
}
__name(getImageOffsetY, "getImageOffsetY");
function getImageOffsetX(uuid) {
  var _a;
  return ((_a = getPilotSheetData()[uuid]) == null ? void 0 : _a.headerImgOffsetX) ?? 0;
}
__name(getImageOffsetX, "getImageOffsetX");
function getThemeOverride$2(uuid) {
  var _a;
  return ((_a = getPilotSheetData()[uuid]) == null ? void 0 : _a.themeOverride) ?? "";
}
__name(getThemeOverride$2, "getThemeOverride$2");
function setThemeOverride$2(uuid, value) {
  const data = getPilotSheetData();
  data[uuid] || (data[uuid] = migratedDefaults$2(uuid, data)), data[uuid].themeOverride = value, SocketManager.getInstance().runAsGM(
    setPilotSheetData,
    () => {
      Logger.log(`Theme override set to ${value} for ${uuid}`);
    },
    encodePilotSheetData(data)
  ), Hooks.call("laOverrideTheme", uuid, value);
}
__name(setThemeOverride$2, "setThemeOverride$2");
function getSidebarExecutables$1(uuid) {
  var _a;
  const data = getPilotSheetData();
  return ((_a = data[uuid]) == null ? void 0 : _a.sidebarExes) ?? migratedDefaults$2(uuid, data).sidebarExes;
}
__name(getSidebarExecutables$1, "getSidebarExecutables$1");
function setSidebarExecutables$1(uuid, macros) {
  const data = getPilotSheetData();
  data[uuid] || (data[uuid] = migratedDefaults$2(uuid, data)), data[uuid].sidebarExes = macros, SocketManager.getInstance().runAsGM(
    setPilotSheetData,
    () => {
      Logger.log(`Sidebar executables set to ${macros.join(", ")} for ${uuid}`);
    },
    encodePilotSheetData(data)
  );
}
__name(setSidebarExecutables$1, "setSidebarExecutables$1");
function getBondImageSrc(uuid) {
  var _a;
  const data = getPilotSheetData();
  return ((_a = data[uuid]) == null ? void 0 : _a.bondImageSrc) ?? migratedDefaults$2(uuid, data).bondImageSrc;
}
__name(getBondImageSrc, "getBondImageSrc");
function setBondImageSrc(uuid, src) {
  const data = getPilotSheetData();
  data[uuid] || (data[uuid] = migratedDefaults$2(uuid, data)), data[uuid].bondImageSrc = src, SocketManager.getInstance().runAsGM(
    setPilotSheetData,
    () => {
      Logger.log(`Bond image src set to ${src} for ${uuid}`);
    },
    encodePilotSheetData(data)
  );
}
__name(setBondImageSrc, "setBondImageSrc");
function getActorTokenSync$2(uuid) {
  const data = getPilotSheetData();
  return determineActorTokenSync$2(uuid, data);
}
__name(getActorTokenSync$2, "getActorTokenSync$2");
function determineActorTokenSync$2(uuid, data) {
  var _a, _b, _c, _d;
  if (((_a = data[uuid]) == null ? void 0 : _a.syncActorTokenImages) === void 0 || ((_b = data[uuid]) == null ? void 0 : _b.syncActorTokenImages) === null) {
    Logger.log("Determining default syncActorTokenImages setting for a new or unsaved pilot/old module version");
    const actor = fromUuidSync(uuid);
    return (_d = (_c = actor.prototypeToken) == null ? void 0 : _c.texture) != null && _d.src && actor.img ? actor.img === actor.prototypeToken.texture.src : !0;
  } else
    return data[uuid].syncActorTokenImages;
}
__name(determineActorTokenSync$2, "determineActorTokenSync$2");
function setActorTokenSync$2(uuid, value) {
  const data = getPilotSheetData();
  data[uuid] || (data[uuid] = migratedDefaults$2(uuid, data)), data[uuid].syncActorTokenImages = value, SocketManager.getInstance().runAsGM(
    setPilotSheetData,
    () => {
      Logger.log(`Sync actor-token images set to ${value} for ${uuid}`);
    },
    encodePilotSheetData(data)
  );
}
__name(setActorTokenSync$2, "setActorTokenSync$2");
var root_6$j = /* @__PURE__ */ template('<div class="la-combine-h clipped-bot-alt la-text-header la-bckg-header-anti -widthfull -padding2-l"></div>'), root_8$5 = /* @__PURE__ */ template("<i></i>"), root_9$a = /* @__PURE__ */ template("<!> <!>", 1), root_10$a = /* @__PURE__ */ template('<div class="la-generated -widthfull -gap2 la-combine-v"><!> <!> <!> <!></div>'), root_3$k = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull"></div>');
function CoreBonus($$anchor, $$props) {
  var _a;
  push($$props, !0);
  const headerOptions = /* @__PURE__ */ __name(($$anchor2) => {
    const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_1 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeader : void 0), expression_2 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeaderReset : void 0);
    CollapseAllButton($$anchor2, {
      collapseID: collID,
      tooltipEnabled,
      get tooltipTheme() {
        return get$1(expression);
      },
      get logType() {
        return get$1(expression_1);
      },
      get logTypeReset() {
        return get$1(expression_2);
      },
      onPointerEnter: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !0);
      }, "onPointerEnter"),
      onPointerLeave: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !1);
      }, "onPointerLeave")
    });
  }, "headerOptions");
  let collapseAllButtonHover = state(!1), messageButtonHover = state(!1), editButtonHover = state(!1);
  const isMechSheet = ((_a = $$props.sheetActor) == null ? void 0 : _a.type) === "mech" || !1, tooltipEnabled = isMechSheet ? getMechSheetTooltipEnabled() : getPilotSheetTooltipEnabled(), coreBonuses = $$props.actor.itemTypes.core_bonus, collID = `${$$props.sheetActor.uuid}.coreBonus`;
  onMount(() => {
    isMechSheet && trackHook(
      $$props.sheetActor.uuid,
      Hooks.on("updateItem", (item, _caller, _options) => {
        item.type !== "core_bonus" || item.parent.uuid !== $$props.actor.uuid || Hooks.call("laForceRerender", $$props.sheetActor.uuid);
      }),
      "updateItem"
    );
  });
  function getActionCollID(index2) {
    return `${collID}.${index2}.action`;
  }
  __name(getActionCollID, "getActionCollID");
  function sendToChat(event2, action) {
    if (event2.stopPropagation(), $$props.actor && action) {
      let chatData = {
        title: action.name,
        trigger: action.trigger,
        effect: action.detail
      };
      SendUnknownToChatBase.getInstance().startFlow($$props.actor.uuid, chatData);
    }
  }
  __name(sendToChat, "sendToChat");
  var fragment_1 = comment(), node = first_child(fragment_1);
  {
    var consequent_1 = /* @__PURE__ */ __name(($$anchor2) => {
      const expression_3 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.coreBonus.label"));
      HeaderMain($$anchor2, {
        get text() {
          return get$1(expression_3);
        },
        headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-action--downtime"],
        textStyle: [
          "la-text-header",
          "-fontsize2",
          "-overflowhidden"
        ],
        borderStyle: ["la-brdr-action--downtime"],
        extensionTextFunction: /* @__PURE__ */ __name(() => {
          if (get$1(collapseAllButtonHover)) return `--${getLocalized("LA.collapseAll.extension")}`;
        }, "extensionTextFunction"),
        collapseID: collID,
        startCollapsed: !0,
        headerContent: headerOptions,
        children: /* @__PURE__ */ __name(($$anchor3, $$slotProps) => {
          var div = root_3$k();
          each(div, 21, () => coreBonuses, index, ($$anchor4, coreBonus, index$1) => {
            const outercontent = /* @__PURE__ */ __name(($$anchor5) => {
              var fragment_3 = comment(), node_1 = first_child(fragment_3);
              {
                var consequent = /* @__PURE__ */ __name(($$anchor6) => {
                  var div_1 = root_6$j();
                  each(div_1, 21, () => get$1(coreBonus).system.counters, index, ($$anchor7, counter, jndex) => {
                    const expression_4 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeader : TextLogHook.PilotHeader), expression_5 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeaderReset : TextLogHook.PilotHeaderReset);
                    CounterBox($$anchor7, {
                      get text() {
                        return get$1(counter).name;
                      },
                      get type() {
                        return CounterBoxType.Counter;
                      },
                      get usesValue() {
                        return get$1(counter).value;
                      },
                      get usesMax() {
                        return get$1(counter).max;
                      },
                      path: isMechSheet ? `system.pilot.value.itemTypes.core_bonus.${index$1}.system.counters.${jndex}` : `itemTypes.core_bonus.${index$1}.system.counters.${jndex}`,
                      style: [
                        "clipped-bot-alt",
                        "-widthfull",
                        "la-bckg-header-anti"
                      ],
                      get logType() {
                        return get$1(expression_4);
                      },
                      get logTypeReset() {
                        return get$1(expression_5);
                      }
                    });
                  }), append($$anchor6, div_1);
                }, "consequent");
                if_block(node_1, ($$render) => {
                  get$1(coreBonus).system.counters.length && $$render(consequent);
                });
              }
              append($$anchor5, fragment_3);
            }, "outercontent"), headerSecondaryLeftOptions2 = /* @__PURE__ */ __name(($$anchor5) => {
              var i2 = root_8$5();
              set_class(i2, `${H2_ICON_SIZE} cci cci-corebonus`), append($$anchor5, i2);
            }, "headerSecondaryLeftOptions"), headerSecondaryRightOptions = /* @__PURE__ */ __name(($$anchor5) => {
              var fragment_5 = root_9$a(), node_2 = first_child(fragment_5);
              const expression_6 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_7 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeader : TextLogHook.PilotHeader), expression_8 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeaderReset : TextLogHook.PilotHeaderReset);
              EditButton(node_2, {
                get flowClass() {
                  return FlowClass.ContextMenu;
                },
                path: isMechSheet ? `system.pilot.value.itemTypes.core_bonus.${index$1}` : `itemTypes.core_bonus.${index$1}`,
                iconStyle: ["-lineheight3"],
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_6);
                },
                get logType() {
                  return get$1(expression_7);
                },
                get logTypeReset() {
                  return get$1(expression_8);
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !1);
                }, "onPointerLeave")
              });
              var node_3 = sibling(node_2, 2);
              const expression_9 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_10 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeader : TextLogHook.PilotHeader), expression_11 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeaderReset : TextLogHook.PilotHeaderReset);
              MessageButton(node_3, {
                get flowClass() {
                  return FlowClass.SendToChat;
                },
                get uuid() {
                  return get$1(coreBonus).uuid;
                },
                style: [
                  HEADER_SECONDARY_STYLE,
                  "-padding0-lr"
                ],
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_9);
                },
                get logType() {
                  return get$1(expression_10);
                },
                get logTypeReset() {
                  return get$1(expression_11);
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(messageButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(messageButtonHover, !1);
                }, "onPointerLeave")
              }), append($$anchor5, fragment_5);
            }, "headerSecondaryRightOptions");
            HeaderSecondary($$anchor4, {
              get text() {
                return get$1(coreBonus).name;
              },
              headerStyle: [H2_HEADER_STYLE, "la-bckg-pilot"],
              textStyle: ["-fontsize2"],
              borderStyle: ["-bordersoff"],
              extensionTextFunction: /* @__PURE__ */ __name(() => {
                if (get$1(messageButtonHover)) return `--${getLocalized("LA.chat.extension")}`;
                if (get$1(editButtonHover)) return `--${getLocalized("LA.edit.extension")}`;
              }, "extensionTextFunction"),
              rootStyle: ["ref", "set"],
              get uuid() {
                return get$1(coreBonus).uuid;
              },
              path: isMechSheet ? `system.pilot.value.itemTypes.core_bonus.${index$1}` : `itemTypes.core_bonus.${index$1}`,
              collapseID: `${collID}.${index$1}`,
              startCollapsed: !0,
              renderOutsideCollapse: outercontent,
              contentLeft: headerSecondaryLeftOptions2,
              contentRight: headerSecondaryRightOptions,
              children: /* @__PURE__ */ __name(($$anchor5, $$slotProps2) => {
                var div_2 = root_10$a(), node_4 = child(div_2);
                BonusBox(node_4, {
                  get bonuses() {
                    return get$1(coreBonus).system.bonuses;
                  },
                  bonusPath: `itemTypes.core_bonus.${index$1}.system.bonuses`
                });
                var node_5 = sibling(node_4, 2);
                const expression_12 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.system.effect.label")), expression_13 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeader : TextLogHook.PilotHeader), expression_14 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeaderReset : TextLogHook.PilotHeaderReset);
                EffectBox(node_5, {
                  get name() {
                    return get$1(expression_12);
                  },
                  get effect() {
                    return get$1(coreBonus).system.effect;
                  },
                  tooltipEnabled,
                  get logType() {
                    return get$1(expression_13);
                  },
                  get logTypeReset() {
                    return get$1(expression_14);
                  }
                });
                var node_6 = sibling(node_5, 2);
                const expression_15 = /* @__PURE__ */ derived(() => getActionCollID(index$1)), expression_16 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.sheetActor.uuid)), expression_17 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeader : TextLogHook.PilotHeader), expression_18 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeaderReset : TextLogHook.PilotHeaderReset);
                ActionBox(node_6, {
                  get actions() {
                    return get$1(coreBonus).system.actions;
                  },
                  get uuid() {
                    return get$1(coreBonus).uuid;
                  },
                  path: isMechSheet ? `system.pilot.value.itemTypes.core_bonus.${index$1}.system.actions` : `itemTypes.core_bonus.${index$1}.system.actions`,
                  get collapseID() {
                    return get$1(expression_15);
                  },
                  startCollapsed: !1,
                  onClick: sendToChat,
                  tooltipEnabled,
                  get tooltipTheme() {
                    return get$1(expression_16);
                  },
                  get logType() {
                    return get$1(expression_17);
                  },
                  get logTypeReset() {
                    return get$1(expression_18);
                  }
                });
                var node_7 = sibling(node_6, 2);
                const expression_19 = /* @__PURE__ */ derived(() => {
                  var _a2;
                  return (_a2 = $$props.sheetActor) == null ? void 0 : _a2.uuid;
                }), expression_20 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.sheetActor.uuid)), expression_21 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeader : TextLogHook.PilotHeader), expression_22 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeaderReset : TextLogHook.PilotHeaderReset);
                DeployableBox(node_7, {
                  get source() {
                    return $$props.actor;
                  },
                  get lidSource() {
                    return get$1(coreBonus).system;
                  },
                  get uuid() {
                    return $$props.actor.uuid;
                  },
                  get sheetUUID() {
                    return get$1(expression_19);
                  },
                  tooltipEnabled,
                  get tooltipTheme() {
                    return get$1(expression_20);
                  },
                  get logType() {
                    return get$1(expression_21);
                  },
                  get logTypeReset() {
                    return get$1(expression_22);
                  }
                }), append($$anchor5, div_2);
              }, "children"),
              $$slots: { default: !0 }
            });
          }), append($$anchor3, div);
        }, "children"),
        $$slots: { default: !0 }
      });
    }, "consequent_1");
    if_block(node, ($$render) => {
      coreBonuses.length && $$render(consequent_1);
    });
  }
  append($$anchor, fragment_1), pop();
}
__name(CoreBonus, "CoreBonus");
var root_5$e = /* @__PURE__ */ template("<i></i>"), root_6$i = /* @__PURE__ */ template("<!> <!>", 1), root_11$7 = /* @__PURE__ */ template("<div></div>"), root_13$1 = /* @__PURE__ */ template("<i></i>"), root_15$1 = /* @__PURE__ */ template('<div class="la-generated -widthfull -gap2 la-combine-v"><!> <!> <!></div>'), root_7$f = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull"></div>'), root_3$j = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull"></div>');
function Talents($$anchor, $$props) {
  var _a;
  push($$props, !0);
  const headerOptions = /* @__PURE__ */ __name(($$anchor2) => {
    const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_1 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeader : void 0), expression_2 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeaderReset : void 0);
    CollapseAllButton($$anchor2, {
      collapseID: collID,
      tooltipEnabled,
      get tooltipTheme() {
        return get$1(expression);
      },
      get logType() {
        return get$1(expression_1);
      },
      get logTypeReset() {
        return get$1(expression_2);
      },
      onPointerEnter: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHoverTalent, !0);
      }, "onPointerEnter"),
      onPointerLeave: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHoverTalent, !1);
      }, "onPointerLeave")
    });
  }, "headerOptions");
  let collapseAllButtonHoverTalent = state(!1), collapseAllButtonHoverRank = state(!1), messageButtonHover = state(!1), editButtonHover = state(!1);
  const isMechSheet = ((_a = $$props.sheetActor) == null ? void 0 : _a.type) === "mech" || !1, tooltipEnabled = isMechSheet ? getMechSheetTooltipEnabled() : getPilotSheetTooltipEnabled(), talents = $$props.actor.itemTypes.talent, collID = `${$$props.sheetActor.uuid}.talents`;
  onMount(() => {
    isMechSheet && trackHook(
      $$props.sheetActor.uuid,
      Hooks.on("updateItem", (item, _caller, _options) => {
        item.type !== "talent" || item.parent.uuid !== $$props.actor.uuid || Hooks.call("laForceRerender", $$props.sheetActor.uuid);
      }),
      "updateItem"
    );
  });
  function getTalentCollID(talentIndex) {
    return `${collID}.${talentIndex}`;
  }
  __name(getTalentCollID, "getTalentCollID");
  function getRankCollID(talentIndex, rankIndex) {
    return `${collID}.${talentIndex}.ranks.${rankIndex}`;
  }
  __name(getRankCollID, "getRankCollID");
  function getActionCollID(talentIndex, rankIndex) {
    return `${collID}.${talentIndex}.ranks.${rankIndex}.action`;
  }
  __name(getActionCollID, "getActionCollID");
  var fragment_1 = comment(), node = first_child(fragment_1);
  {
    var consequent_2 = /* @__PURE__ */ __name(($$anchor2) => {
      const expression_3 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.talent.label"));
      HeaderMain($$anchor2, {
        get text() {
          return get$1(expression_3);
        },
        headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-action--downtime"],
        textStyle: [
          "la-text-header",
          "-fontsize2",
          "-overflowhidden"
        ],
        borderStyle: ["la-brdr-action--downtime"],
        extensionTextFunction: /* @__PURE__ */ __name(() => {
          if (get$1(collapseAllButtonHoverTalent)) return `--${getLocalized("LA.collapseAll.extension")}`;
        }, "extensionTextFunction"),
        collapseID: collID,
        startCollapsed: !0,
        headerContent: headerOptions,
        children: /* @__PURE__ */ __name(($$anchor3, $$slotProps) => {
          var div = root_3$j();
          each(div, 21, () => talents, index, ($$anchor4, talent, index$1) => {
            const headerSecondaryTalentLeftOptions = /* @__PURE__ */ __name(($$anchor5) => {
              var i2 = root_5$e();
              set_class(i2, `${H2_ICON_SIZE} cci cci-compendium`), append($$anchor5, i2);
            }, "headerSecondaryTalentLeftOptions"), headerSecondaryTalentRightOptions = /* @__PURE__ */ __name(($$anchor5) => {
              var fragment_3 = root_6$i(), node_1 = first_child(fragment_3);
              const expression_4 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeader : TextLogHook.PilotHeader), expression_5 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeaderReset : TextLogHook.PilotHeaderReset);
              EditButton(node_1, {
                get flowClass() {
                  return FlowClass.ContextMenu;
                },
                style: [
                  HEADER_SECONDARY_STYLE,
                  "-margin0-lr"
                ],
                iconStyle: ["-lineheight3"],
                path: isMechSheet ? `system.pilot.value.itemTypes.talent.${index$1}` : `itemTypes.talent.${index$1}`,
                tooltipEnabled,
                get logType() {
                  return get$1(expression_4);
                },
                get logTypeReset() {
                  return get$1(expression_5);
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !1);
                }, "onPointerLeave")
              });
              var node_2 = sibling(node_1, 2);
              const expression_6 = /* @__PURE__ */ derived(() => getTalentCollID(index$1)), expression_7 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_8 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeader : TextLogHook.PilotHeader), expression_9 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeaderReset : TextLogHook.PilotHeaderReset);
              CollapseAllButton(node_2, {
                get collapseID() {
                  return get$1(expression_6);
                },
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_7);
                },
                get logType() {
                  return get$1(expression_8);
                },
                get logTypeReset() {
                  return get$1(expression_9);
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(collapseAllButtonHoverRank, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(collapseAllButtonHoverRank, !1);
                }, "onPointerLeave")
              }), append($$anchor5, fragment_3);
            }, "headerSecondaryTalentRightOptions"), expression_10 = /* @__PURE__ */ derived(() => `${get$1(talent).name} ${get$1(talent).system.curr_rank}`), expression_11 = /* @__PURE__ */ derived(() => getTalentCollID(index$1));
            HeaderSecondary($$anchor4, {
              get text() {
                return get$1(expression_10);
              },
              headerStyle: [H2_HEADER_STYLE, "la-bckg-pilot"],
              textStyle: ["-fontsize2"],
              borderStyle: ["-bordersoff"],
              extensionTextFunction: /* @__PURE__ */ __name(() => {
                if (get$1(collapseAllButtonHoverRank)) return `--${getLocalized("LA.collapseAll.extension")}`;
                if (get$1(editButtonHover)) return `--${getLocalized("LA.edit.extension")}`;
              }, "extensionTextFunction"),
              rootStyle: ["ref", "set", "lancer-talent", "submajor"],
              get uuid() {
                return get$1(talent).uuid;
              },
              path: isMechSheet ? `system.pilot.value.itemTypes.talent.${index$1}` : `itemTypes.talent.${index$1}`,
              get collapseID() {
                return get$1(expression_11);
              },
              startCollapsed: !0,
              contentLeft: headerSecondaryTalentLeftOptions,
              contentRight: headerSecondaryTalentRightOptions,
              children: /* @__PURE__ */ __name(($$anchor5, $$slotProps2) => {
                var div_1 = root_7$f();
                each(div_1, 21, () => get$1(talent).system.ranks, index, ($$anchor6, rank, jndex) => {
                  var fragment_5 = comment(), node_3 = first_child(fragment_5);
                  {
                    var consequent_1 = /* @__PURE__ */ __name(($$anchor7) => {
                      const outerContent = /* @__PURE__ */ __name(($$anchor8) => {
                        var fragment_6 = comment(), node_4 = first_child(fragment_6);
                        {
                          var consequent = /* @__PURE__ */ __name(($$anchor9) => {
                            var div_2 = root_11$7();
                            each(div_2, 21, () => get$1(rank).counters, index, ($$anchor10, counter, kndex) => {
                              const expression_12 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeader : TextLogHook.PilotHeader), expression_13 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeaderReset : TextLogHook.PilotHeaderReset);
                              CounterBox($$anchor10, {
                                get text() {
                                  return get$1(counter).name;
                                },
                                get type() {
                                  return CounterBoxType.Counter;
                                },
                                get usesValue() {
                                  return get$1(counter).value;
                                },
                                get usesMax() {
                                  return get$1(counter).max;
                                },
                                path: isMechSheet ? `system.pilot.value.itemTypes.talent.${index$1}.system.ranks.${jndex}.counters.${kndex}` : `itemTypes.talent.${index$1}.system.ranks.${jndex}.counters.${kndex}`,
                                style: [
                                  "clipped-bot-alt",
                                  "-widthfull",
                                  "la-bckg-header-anti"
                                ],
                                get logType() {
                                  return get$1(expression_12);
                                },
                                get logTypeReset() {
                                  return get$1(expression_13);
                                }
                              });
                            }), template_effect(
                              ($0) => set_class(div_2, `la-combine-v -widthfull -padding2-l
                        ${$0 ?? ""}`),
                              [
                                () => getCollapseState(getRankCollID(index$1, jndex)) ? "la-brdr-transparent -borders-l" : "la-brdr-trait -borders-l -collapse-fade-out"
                              ]
                            ), append($$anchor9, div_2);
                          }, "consequent");
                          if_block(node_4, ($$render) => {
                            get$1(rank).counters.length && $$render(consequent);
                          });
                        }
                        append($$anchor8, fragment_6);
                      }, "outerContent"), headerSecondaryRankLeftOptions = /* @__PURE__ */ __name(($$anchor8) => {
                        var i_1 = root_13$1();
                        set_class(i_1, `${H2_ICON_SIZE} cci cci-talent`), append($$anchor8, i_1);
                      }, "headerSecondaryRankLeftOptions"), headerSecondaryRankRightOptions = /* @__PURE__ */ __name(($$anchor8) => {
                        const expression_14 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_15 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeader : TextLogHook.PilotHeader), expression_16 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeaderReset : TextLogHook.PilotHeaderReset);
                        MessageButton($$anchor8, {
                          get flowClass() {
                            return FlowClass.SendToChat;
                          },
                          get uuid() {
                            return get$1(talent).uuid;
                          },
                          rank: jndex,
                          tooltipEnabled,
                          get tooltipTheme() {
                            return get$1(expression_14);
                          },
                          get logType() {
                            return get$1(expression_15);
                          },
                          get logTypeReset() {
                            return get$1(expression_16);
                          },
                          onPointerEnter: /* @__PURE__ */ __name(() => {
                            set(messageButtonHover, !0);
                          }, "onPointerEnter"),
                          onPointerLeave: /* @__PURE__ */ __name(() => {
                            set(messageButtonHover, !1);
                          }, "onPointerLeave")
                        });
                      }, "headerSecondaryRankRightOptions"), expression_17 = /* @__PURE__ */ derived(() => getRankCollID(index$1, jndex));
                      HeaderSecondary($$anchor7, {
                        get text() {
                          return get$1(rank).name;
                        },
                        headerStyle: [H2_HEADER_STYLE, "la-bckg-header-anti"],
                        textStyle: ["-fontsize2"],
                        borderStyle: ["la-brdr-trait"],
                        extensionTextFunction: /* @__PURE__ */ __name(() => {
                          if (get$1(messageButtonHover)) return `--${getLocalized("LA.chat.extension")}`;
                        }, "extensionTextFunction"),
                        rootStyle: ["ref", "set"],
                        get uuid() {
                          return get$1(talent).uuid;
                        },
                        get collapseID() {
                          return get$1(expression_17);
                        },
                        startCollapsed: !1,
                        renderOutsideCollapse: outerContent,
                        contentLeft: headerSecondaryRankLeftOptions,
                        contentRight: headerSecondaryRankRightOptions,
                        children: /* @__PURE__ */ __name(($$anchor8, $$slotProps3) => {
                          var div_3 = root_15$1(), node_5 = child(div_3);
                          BonusBox(node_5, {
                            get bonuses() {
                              return get$1(rank).bonuses;
                            },
                            bonusPath: isMechSheet ? `system.pilot.value.itemTypes.talent.${index$1}.system.ranks.${jndex}.bonuses` : `itemTypes.talent.${index$1}.system.ranks.${jndex}.bonuses`
                          });
                          var node_6 = sibling(node_5, 2);
                          const expression_18 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.trait.label")), expression_19 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeader : TextLogHook.PilotHeader), expression_20 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeaderReset : TextLogHook.PilotHeaderReset);
                          EffectBox(node_6, {
                            get name() {
                              return get$1(expression_18);
                            },
                            get effect() {
                              return get$1(rank).description;
                            },
                            tooltipEnabled,
                            get logType() {
                              return get$1(expression_19);
                            },
                            get logTypeReset() {
                              return get$1(expression_20);
                            }
                          });
                          var node_7 = sibling(node_6, 2);
                          const expression_21 = /* @__PURE__ */ derived(() => getActionCollID(index$1, jndex)), expression_22 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.sheetActor.uuid)), expression_23 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeader : TextLogHook.PilotHeader), expression_24 = /* @__PURE__ */ derived(() => isMechSheet ? TextLogHook.MechHeaderReset : TextLogHook.PilotHeaderReset);
                          ActionBox(node_7, {
                            get actions() {
                              return get$1(rank).actions;
                            },
                            get uuid() {
                              return get$1(talent).uuid;
                            },
                            path: `system.ranks.${jndex}.actions`,
                            get collapseID() {
                              return get$1(expression_21);
                            },
                            startCollapsed: !1,
                            tooltipEnabled,
                            get tooltipTheme() {
                              return get$1(expression_22);
                            },
                            get logType() {
                              return get$1(expression_23);
                            },
                            get logTypeReset() {
                              return get$1(expression_24);
                            }
                          }), append($$anchor8, div_3);
                        }, "children"),
                        $$slots: { default: !0 }
                      });
                    }, "consequent_1");
                    if_block(node_3, ($$render) => {
                      jndex < get$1(talent).system.curr_rank && $$render(consequent_1);
                    });
                  }
                  append($$anchor6, fragment_5);
                }), append($$anchor5, div_1);
              }, "children"),
              $$slots: { default: !0 }
            });
          }), append($$anchor3, div);
        }, "children"),
        $$slots: { default: !0 }
      });
    }, "consequent_2");
    if_block(node, ($$render) => {
      talents.length && $$render(consequent_2);
    });
  }
  append($$anchor, fragment_1), pop();
}
__name(Talents, "Talents");
var root_1$d = /* @__PURE__ */ template("<!> <!>", 1), root$y = /* @__PURE__ */ template('<div class="la-mount__list la-combine-v -widthfull"><!> <!> <!> <!></div>');
function Loadout$1($$anchor, $$props) {
  push($$props, !0);
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]);
  var div = root$y(), node = child(div);
  Frame(node, spread_props(() => props));
  var node_1 = sibling(node, 2);
  Mounts(node_1, spread_props(() => props));
  var node_2 = sibling(node_1, 2);
  Systems$1(node_2, spread_props(() => props));
  var node_3 = sibling(node_2, 2);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment = root_1$d(), node_4 = first_child(fragment);
      CoreBonus(node_4, {
        get actor() {
          return $$props.pilot;
        },
        get sheetActor() {
          return $$props.actor;
        }
      });
      var node_5 = sibling(node_4, 2);
      Talents(node_5, {
        get actor() {
          return $$props.pilot;
        },
        get sheetActor() {
          return $$props.actor;
        }
      }), append($$anchor2, fragment);
    }, "consequent");
    if_block(node_3, ($$render) => {
      var _a;
      $$props.pilot && ((_a = $$props.pilot.system.active_mech) == null ? void 0 : _a.value.uuid) === $$props.actor.uuid && $$render(consequent);
    });
  }
  append($$anchor, div), pop();
}
__name(Loadout$1, "Loadout$1");
var root$x = /* @__PURE__ */ template('<div><div><span> </span> <button type="button"><span></span></button></div></div>');
function HexButton($$anchor, $$props) {
  push($$props, !0);
  const tip = TooltipFactory.buildTooltip($$props.tooltip || getLocalized("LA.flow.tooltip"), $$props.tooltipHeader), logging = $$props.logType && $$props.logTypeReset, log = $$props.logText || getLocalized("LA.flow.tooltip"), parsedValue = $$props.value && $$props.sign && $$props.value > 0 ? `+${$$props.value}` : $$props.value;
  var div = root$x(), div_1 = child(div), span = child(div_1), text_1 = child(span), button = sibling(span, 2), span_1 = child(button);
  span_1.textContent = parsedValue, template_effect(
    ($0, $1, $2, $3, $4) => {
      set_class(div, `la-attribute la-text-secondary mdi mdi-hexagon ${$0 ?? ""}`), set_class(div_1, `la-combine-v ${$1 ?? ""}`), set_class(span, `la-label__span ${$2 ?? ""}`), set_text(text_1, $$props.text), set_class(button, `la-value__button ${$3 ?? ""}
                ${$$props.flowClass || ""}`), set_attribute(button, "data-uuid", $$props.uuid), set_attribute(button, "data-flow-type", $$props.flowType), set_attribute(button, "data-flow-args", $$props.flowArgs), set_attribute(button, "data-path", $$props.path), set_attribute(button, "data-tooltip", $$props.tooltipEnabled ? tip : void 0), set_attribute(button, "data-tooltip-class", `${$$props.tooltipClass || "clipped-bot la-tooltip"} ${$$props.tooltipTheme}`), set_attribute(button, "data-tooltip-direction", $$props.tooltipDirection), set_attribute(button, "aria-label", $$props.text), set_class(span_1, `la-value__span ${$4 ?? ""}`);
    },
    [
      () => {
        var _a;
        return (_a = $$props.outerStyle) == null ? void 0 : _a.join(" ");
      },
      () => {
        var _a;
        return (_a = $$props.innerStyle) == null ? void 0 : _a.join(" ");
      },
      () => {
        var _a;
        return (_a = $$props.outerTextStyle) == null ? void 0 : _a.join(" ");
      },
      () => {
        var _a;
        return (_a = $$props.buttonStyle) == null ? void 0 : _a.join(" ");
      },
      () => {
        var _a;
        return (_a = $$props.innerTextStyle) == null ? void 0 : _a.join(" ");
      }
    ]
  ), event("pointerenter", button, function(...$$args) {
    var _a;
    (_a = logging ? (event2) => sendToLog(event2, log, $$props.logType) : void 0) == null || _a.apply(this, $$args);
  }), event("pointerleave", button, function(...$$args) {
    var _a;
    (_a = logging ? (event2) => resetLog(event2, $$props.logTypeReset) : void 0) == null || _a.apply(this, $$args);
  }), append($$anchor, div), pop();
}
__name(HexButton, "HexButton");
var root_1$c = /* @__PURE__ */ template('<div><div class="la-hase la-combine-v -justifybetween -heightnone"><div class="la-combine-h -aligncenter"><!></div> <div class="la-combine-h -aligncenter"><!> <!></div> <div class="la-combine-h -aligncenter"><!></div> <div class="la-combine-h -aligncenter"><div class="-eng -pointerdisable">&nbsp;</div> <!></div></div></div>');
function HaseArray($$anchor, $$props) {
  push($$props, !0);
  let activeTab = /* @__PURE__ */ derived(() => getActiveTab($$props.actor.uuid, ActiveTab.Secondary) || "statistics");
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var div = root_1$c(), div_1 = child(div), div_2 = child(div_1), node_1 = child(div_2);
      const expression = /* @__PURE__ */ derived(() => getLocalized("LA.grit.short")), expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.grit.tooltip")), expression_2 = /* @__PURE__ */ derived(() => $$props.tooltipDirection || TooltipDirection.LEFT), expression_3 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_4 = /* @__PURE__ */ derived(() => getLocalized("LA.grit.tooltip"));
      HexButton(node_1, {
        get text() {
          return get$1(expression);
        },
        get value() {
          return $$props.system.grit;
        },
        get tooltipEnabled() {
          return $$props.tooltipEnabled;
        },
        get tooltip() {
          return get$1(expression_1);
        },
        get tooltipDirection() {
          return get$1(expression_2);
        },
        get tooltipTheme() {
          return get$1(expression_3);
        },
        get logText() {
          return get$1(expression_4);
        },
        get logType() {
          return $$props.logType;
        },
        get logTypeReset() {
          return $$props.logTypeReset;
        },
        get uuid() {
          return $$props.actor.uuid;
        },
        get flowClass() {
          return FlowClass.RollStat;
        },
        path: "system.grit",
        sign: !0,
        outerStyle: ["-grit"],
        innerStyle: [
          "la-text-header",
          "-positionabsolute",
          "-divider",
          "-thickness1",
          "la-prmy-header"
        ],
        buttonStyle: [
          "-widthfull",
          "-heightfull",
          "-positionabsolute",
          "la-prmy-primary -glow-prmy-hover"
        ],
        outerTextStyle: ["-widthfull", "-textaligncenter"],
        innerTextStyle: [
          "-fontsize4",
          "-lineheight11",
          "-pulse-glow-prmy la-prmy-header"
        ]
      });
      var div_3 = sibling(div_2, 2), node_2 = child(div_3);
      const expression_5 = /* @__PURE__ */ derived(() => getLocalized("LA.hull.short")), expression_6 = /* @__PURE__ */ derived(() => getLocalized("LA.hull.tooltip")), expression_7 = /* @__PURE__ */ derived(() => $$props.tooltipDirection || TooltipDirection.LEFT), expression_8 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_9 = /* @__PURE__ */ derived(() => getLocalized("LA.hull.tooltip"));
      HexButton(node_2, {
        get text() {
          return get$1(expression_5);
        },
        get value() {
          return $$props.system.hull;
        },
        get tooltipEnabled() {
          return $$props.tooltipEnabled;
        },
        get tooltip() {
          return get$1(expression_6);
        },
        get tooltipDirection() {
          return get$1(expression_7);
        },
        get tooltipTheme() {
          return get$1(expression_8);
        },
        get logText() {
          return get$1(expression_9);
        },
        get logType() {
          return $$props.logType;
        },
        get logTypeReset() {
          return $$props.logTypeReset;
        },
        get uuid() {
          return $$props.actor.uuid;
        },
        get flowClass() {
          return FlowClass.RollHASE;
        },
        path: "system.hull",
        outerStyle: ["-hull"],
        innerStyle: [
          "la-text-header",
          "-positionabsolute",
          "-divider",
          "-thickness1",
          "la-prmy-header"
        ],
        buttonStyle: [
          "-widthfull",
          "-heightfull",
          "-positionabsolute",
          "la-prmy-primary -glow-prmy-hover"
        ],
        outerTextStyle: ["-widthfull", "-textaligncenter"],
        innerTextStyle: [
          "-fontsize3",
          "-lineheight10",
          "-pulse-glow-prmy la-prmy-header"
        ]
      });
      var node_3 = sibling(node_2, 2);
      const expression_10 = /* @__PURE__ */ derived(() => getLocalized("LA.agility.short")), expression_11 = /* @__PURE__ */ derived(() => getLocalized("LA.agility.tooltip")), expression_12 = /* @__PURE__ */ derived(() => $$props.tooltipDirection || TooltipDirection.LEFT), expression_13 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_14 = /* @__PURE__ */ derived(() => getLocalized("LA.agility.tooltip"));
      HexButton(node_3, {
        get text() {
          return get$1(expression_10);
        },
        get value() {
          return $$props.system.agi;
        },
        get tooltipEnabled() {
          return $$props.tooltipEnabled;
        },
        get tooltip() {
          return get$1(expression_11);
        },
        get tooltipDirection() {
          return get$1(expression_12);
        },
        get tooltipTheme() {
          return get$1(expression_13);
        },
        get logText() {
          return get$1(expression_14);
        },
        get logType() {
          return $$props.logType;
        },
        get logTypeReset() {
          return $$props.logTypeReset;
        },
        get uuid() {
          return $$props.actor.uuid;
        },
        get flowClass() {
          return FlowClass.RollHASE;
        },
        path: "system.agi",
        outerStyle: ["-agi"],
        innerStyle: [
          "la-text-header",
          "-positionabsolute",
          "-divider",
          "-thickness1",
          "la-prmy-header"
        ],
        buttonStyle: [
          "-widthfull",
          "-heightfull",
          "-positionabsolute",
          "la-prmy-primary -glow-prmy-hover"
        ],
        outerTextStyle: ["-widthfull", "-textaligncenter"],
        innerTextStyle: [
          "-fontsize3",
          "-lineheight10",
          "-pulse-glow-prmy la-prmy-header"
        ]
      });
      var div_4 = sibling(div_3, 2), node_4 = child(div_4);
      const expression_15 = /* @__PURE__ */ derived(() => getLocalized("LA.systems.short")), expression_16 = /* @__PURE__ */ derived(() => getLocalized("LA.systems.tooltip")), expression_17 = /* @__PURE__ */ derived(() => $$props.tooltipDirection || TooltipDirection.LEFT), expression_18 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_19 = /* @__PURE__ */ derived(() => getLocalized("LA.systems.tooltip"));
      HexButton(node_4, {
        get text() {
          return get$1(expression_15);
        },
        get value() {
          return $$props.system.sys;
        },
        get tooltipEnabled() {
          return $$props.tooltipEnabled;
        },
        get tooltip() {
          return get$1(expression_16);
        },
        get tooltipDirection() {
          return get$1(expression_17);
        },
        get tooltipTheme() {
          return get$1(expression_18);
        },
        get logText() {
          return get$1(expression_19);
        },
        get logType() {
          return $$props.logType;
        },
        get logTypeReset() {
          return $$props.logTypeReset;
        },
        get uuid() {
          return $$props.actor.uuid;
        },
        get flowClass() {
          return FlowClass.RollHASE;
        },
        path: "system.sys",
        outerStyle: ["-sys"],
        innerStyle: [
          "la-text-header",
          "-positionabsolute",
          "-divider",
          "-thickness1",
          "la-prmy-header"
        ],
        buttonStyle: [
          "-widthfull",
          "-heightfull",
          "-positionabsolute",
          "la-prmy-primary -glow-prmy-hover"
        ],
        outerTextStyle: ["-widthfull", "-textaligncenter"],
        innerTextStyle: [
          "-fontsize3",
          "-lineheight10",
          "-pulse-glow-prmy la-prmy-header"
        ]
      });
      var div_5 = sibling(div_4, 2), node_5 = sibling(child(div_5), 2);
      const expression_20 = /* @__PURE__ */ derived(() => getLocalized("LA.engineering.short")), expression_21 = /* @__PURE__ */ derived(() => getLocalized("LA.engineering.tooltip")), expression_22 = /* @__PURE__ */ derived(() => $$props.tooltipDirection || TooltipDirection.LEFT), expression_23 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_24 = /* @__PURE__ */ derived(() => getLocalized("LA.engineering.tooltip"));
      HexButton(node_5, {
        get text() {
          return get$1(expression_20);
        },
        get value() {
          return $$props.system.eng;
        },
        get tooltipEnabled() {
          return $$props.tooltipEnabled;
        },
        get tooltip() {
          return get$1(expression_21);
        },
        get tooltipDirection() {
          return get$1(expression_22);
        },
        get tooltipTheme() {
          return get$1(expression_23);
        },
        get logText() {
          return get$1(expression_24);
        },
        get logType() {
          return $$props.logType;
        },
        get logTypeReset() {
          return $$props.logTypeReset;
        },
        get uuid() {
          return $$props.actor.uuid;
        },
        get flowClass() {
          return FlowClass.RollHASE;
        },
        path: "system.eng",
        outerStyle: ["-eng"],
        innerStyle: [
          "la-text-header",
          "-positionabsolute",
          "-divider",
          "-thickness1",
          "la-prmy-header"
        ],
        buttonStyle: [
          "-widthfull",
          "-heightfull",
          "-positionabsolute",
          "la-prmy-primary -glow-prmy-hover"
        ],
        outerTextStyle: ["-widthfull", "-textaligncenter"],
        innerTextStyle: [
          "-fontsize3",
          "-lineheight10",
          "-pulse-glow-prmy la-prmy-header"
        ]
      }), template_effect(() => set_class(div, `la-hasegroup -positionabsolute -widthnone
        ${(get$1(activeTab) === "statistics" ? "" : "-displaynone") ?? ""}`)), append($$anchor2, div);
    }, "consequent");
    if_block(node, ($$render) => {
      var _a, _b;
      ($$props.actor.type === "pilot" || $$props.actor.type === "mech" && ((_b = (_a = $$props.pilot) == null ? void 0 : _a.system.active_mech) == null ? void 0 : _b.value.uuid) === $$props.actor.uuid) && $$render(consequent);
    });
  }
  append($$anchor, fragment), pop();
}
__name(HaseArray, "HaseArray");
function handleMountChange(currentMount, mountPath, selectionIndex, bracing, document2, callback) {
  var _a, _b, _c, _d, _e, _f;
  const mountTypes = Object.keys(MOUNT_FITTINGS);
  let newSlots = {
    loadout: {
      weapon_mounts: [{
        slots: [{
          weapon: null,
          mod: null,
          size: MOUNT_FITTINGS.Unknown[0]
        }],
        type: "Unknown",
        bracing: !1
      }]
    }
  }, newSlotFittings = MOUNT_FITTINGS[mountTypes[selectionIndex]];
  for (let i2 = 0; i2 < newSlotFittings.length; i2++)
    (_b = (_a = currentMount.slots[i2]) == null ? void 0 : _a.weapon) != null && _b.value ? newSlots.loadout.weapon_mounts[0].slots[i2] = {
      weapon: ((_d = (_c = currentMount.slots[i2].weapon) == null ? void 0 : _c.value) == null ? void 0 : _d.id) ?? null,
      mod: ((_f = (_e = currentMount.slots[i2].mod) == null ? void 0 : _e.value) == null ? void 0 : _f.id) ?? null,
      size: newSlotFittings[i2]
    } : newSlots.loadout.weapon_mounts[0].slots[i2] = {
      weapon: null,
      mod: null,
      size: newSlotFittings[i2]
    };
  document2.update({
    [`${mountPath}.type`]: mountTypes[selectionIndex],
    [`${mountPath}.bracing`]: bracing,
    [`${mountPath}.slots`]: newSlots.loadout.weapon_mounts[0].slots
  }), callback == null || callback(MOUNT_LOCALIZE_MAP[mountTypes[selectionIndex]]);
}
__name(handleMountChange, "handleMountChange");
async function handleMountDelete(button, doc, callback) {
  var _a;
  let raw_val = button.dataset.actionValue;
  if (raw_val) {
    let result = await parse_control_val(raw_val);
    if (result.success)
      result.val;
    else {
      Logger.error(`bad data-action-value from gen control ${raw_val}`);
      return;
    }
  }
  let path = button.dataset.path, docOverride = null, dd;
  if (button.dataset.uuid) {
    if (docOverride = await fromUuid(button.dataset.uuid), !docOverride)
      return (_a = ui.notifications) == null ? void 0 : _a.error("Bad uuid: " + button.dataset.uuid);
    dd = drilldownDocument(docOverride, path);
  } else
    dd = drilldownDocument(doc, path);
  let changes = array_path_edit_changes(dd.sub_doc, dd.sub_path);
  await dd.sub_doc.update({ [changes.path]: changes.new_val }), callback == null || callback($(button));
}
__name(handleMountDelete, "handleMountDelete");
var root_1$b = /* @__PURE__ */ template('<button type="button" class="la-bckg-scrollbar-secondary la-text-header -fontsize1 -letterspacing0 la-prmy-secondary -glow-prmy-hover la-scdy-accent -glow-scdy-focus"> </button>'), root$w = /* @__PURE__ */ template('<h3> <i class="mdi mdi-arrow-down-right"></i></h3> <div class="la-combine-v -widthfull -gap0 -padding0"><!> <div class="la-combine-h"><input type="checkbox"> <span class="-lineheight4"> </span></div></div>', 1);
function MountOptions($$anchor, $$props) {
  push($$props, !0);
  const mountNames = prop($$props, "mountNames");
  let bracing = state(!1);
  function swapMount(event2, mountIndex, morphIndex) {
    event2.stopPropagation();
    let mountPath = `system.loadout.weapon_mounts.${mountIndex}`;
    handleMountChange($$props.mount, mountPath, morphIndex, get$1(bracing), $$props.actorSheet, callback);
  }
  __name(swapMount, "swapMount");
  function callback(localizationString) {
    mountNames()[$$props.mountIndex] = localizationString;
  }
  __name(callback, "callback");
  var fragment = root$w(), h3 = first_child(fragment), text2 = child(h3), div = sibling(h3, 2), node = child(div);
  each(node, 17, () => Object.keys(MOUNT_LOCALIZE_MAP), index, ($$anchor2, mountType, morphIndex) => {
    var button = root_1$b();
    button.__click = (event2) => swapMount(event2, $$props.mountIndex, morphIndex);
    var text_1 = child(button);
    template_effect(($0) => set_text(text_1, $0), [
      () => getLocalized(MOUNT_LOCALIZE_MAP[get$1(mountType)])
    ]), append($$anchor2, button);
  });
  var div_1 = sibling(node, 2), input = child(div_1), span = sibling(input, 2), text_2 = child(span);
  template_effect(
    ($0, $1) => {
      set_text(text2, $0), set_text(text_2, $1);
    },
    [
      () => getLocalized(MOUNT_LOCALIZE_MAP[$$props.mount.type]),
      () => getLocalized("LA.mech.mount.locked.subLabel")
    ]
  ), bind_checked(input, () => get$1(bracing), ($$value) => set(bracing, $$value)), append($$anchor, fragment), pop();
}
__name(MountOptions, "MountOptions");
delegate(["click"]);
var on_click$4 = /* @__PURE__ */ __name((event2, deleteMount) => deleteMount(event2), "on_click$4"), root$v = /* @__PURE__ */ template(`<button type="button" class="la-bckg-scrollbar-secondary la-text-header -fontsize1 -letterspacing0 la-prmy-secondary -glow-prmy-hover la-scdy-accent -glow-scdy-focus
        gen-control"> <i class="mdi mdi-close-circle-outline -positionabsolute -left2 -fontsize2"></i></button>`);
function MountDelete($$anchor, $$props) {
  push($$props, !0);
  const mountIndices = prop($$props, "mountIndices");
  function deleteMount(event2) {
    event2.stopPropagation(), handleMountDelete(event2.currentTarget, $$props.actorSheet, callback);
  }
  __name(deleteMount, "deleteMount");
  function callback(button) {
    const parent = button.parent();
    if (parent.length) {
      const buttons = parent.find("button"), index2 = buttons.index(button);
      for (let i2 = index2; i2 < buttons.length; i2++)
        mountIndices()[i2] = mountIndices()[i2] - 1;
      button.css("display", "none");
    }
  }
  __name(callback, "callback");
  var button_1 = root$v();
  set_attribute(button_1, "data-action", "splice"), button_1.__click = [on_click$4, deleteMount];
  var text2 = child(button_1);
  template_effect(
    ($0) => {
      set_attribute(button_1, "data-path", `system.loadout.weapon_mounts.${$$props.mountIndex}`), set_text(text2, `${$0 ?? ""} `);
    },
    [
      () => getLocalized(MOUNT_LOCALIZE_MAP[$$props.mount.type])
    ]
  ), append($$anchor, button_1), pop();
}
__name(MountDelete, "MountDelete");
delegate(["click"]);
var on_click$3 = /* @__PURE__ */ __name((event2, addMount) => addMount(event2), "on_click$3"), root$u = /* @__PURE__ */ template('<button type="button" data-action-value="(struct)wep_mount"><i class="mdi mdi-plus-box -verticalaligntop"></i></button>');
function MountAdd($$anchor, $$props) {
  push($$props, !0);
  const tip = TooltipFactory.buildTooltip(getLocalized("LA.advanced.mount.add.tooltip"));
  function addMount(event2) {
    event2.stopPropagation(), TooltipFactory.unrenderTooltips();
  }
  __name(addMount, "addMount");
  var button = root$u();
  set_class(button, `${SETTINGS_BUTTON_STYLE$1}
        gen-control`), set_attribute(button, "data-path", "system.loadout.weapon_mounts"), set_attribute(button, "data-action", "append"), button.__click = [on_click$3, addMount], template_effect(
    ($0) => {
      set_attribute(button, "data-tooltip", $$props.tooltipEnabled ? tip : void 0), set_attribute(button, "data-tooltip-direction", TooltipDirection.RIGHT), set_attribute(button, "data-tooltip-class", `${$$props.tooltipClass || "clipped-bot la-tooltip"} ${$$props.tooltipTheme}`), set_attribute(button, "aria-label", $0);
    },
    [
      () => getLocalized("LA.advanced.mount.add.tooltip")
    ]
  ), event("pointerenter", button, (event2) => sendToLog(event2, getLocalized("LA.advanced.mount.add.tooltip"), TextLogHook.MechHeader)), event("pointerleave", button, (event2) => resetLog(event2, TextLogHook.MechHeaderReset)), append($$anchor, button), pop();
}
__name(MountAdd, "MountAdd");
delegate(["click"]);
var root_1$a = /* @__PURE__ */ template('<h3 class="-widthfull"> </h3> <div class="la-combine-v -widthfull -heightfull -gap0 -padding0"></div>', 1), root_6$h = /* @__PURE__ */ template('<i class="mdi mdi-arrow-up-drop-circle-outline -positionabsolute -left2 -fontsize2"></i>'), root_7$e = /* @__PURE__ */ template('<i class="mdi mdi-arrow-right-drop-circle-outline -positionabsolute -left2 -fontsize2"></i>'), root_4$7 = /* @__PURE__ */ template('<button type="button" class="la-bckg-scrollbar-secondary la-text-header -fontsize1 -letterspacing0 la-prmy-secondary -glow-prmy-hover la-scdy-accent -glow-scdy-focus"> <!></button>'), root_3$i = /* @__PURE__ */ template('<h3 class="-widthfull"> </h3> <div class="la-combine-v -widthfull -heightfull -gap0 -padding0"></div>', 1), on_click$2 = /* @__PURE__ */ __name((event2, handleRemove, removeMount) => handleRemove(event2, removeMount), "on_click$2"), on_click_1$1 = /* @__PURE__ */ __name((event2, handleEdit, editMount) => handleEdit(event2, editMount), "on_click_1$1"), root$t = /* @__PURE__ */ template('<div><span> </span> <div class="la-combine-v -alignstart -padding0-b -heightfull"><!> <button type="button"><i class="mdi mdi-minus-box -verticalaligntop"></i></button>  <button type="button"><i class="mdi mdi-list-box -verticalaligntop"></i></button></div></div>');
function MountSettings($$anchor, $$props) {
  push($$props, !0);
  const removeMount = /* @__PURE__ */ __name(($$anchor2) => {
    var fragment = root_1$a(), h3 = first_child(fragment), text2 = child(h3), div = sibling(h3, 2);
    each(div, 21, () => weaponMounts, index, ($$anchor3, mount2, index2) => {
      MountDelete($$anchor3, {
        get actorSheet() {
          return document2._sheet.actor;
        },
        get mount() {
          return get$1(mount2);
        },
        get mountIndex() {
          return mountIndices[index2];
        },
        get mountIndices() {
          return mountIndices;
        }
      });
    }), template_effect(($0) => set_text(text2, $0), [
      () => getLocalized("LA.advanced.mount.remove.label")
    ]), append($$anchor2, fragment);
  }, "removeMount"), editMount = /* @__PURE__ */ __name(($$anchor2) => {
    var fragment_2 = root_3$i(), h3_1 = first_child(fragment_2), text_1 = child(h3_1), div_1 = sibling(h3_1, 2);
    each(div_1, 21, () => weaponMounts, index, ($$anchor3, mount2, index2) => {
      var button = root_4$7();
      const dropdownContent = /* @__PURE__ */ __name(($$anchor4) => {
        MountOptions($$anchor4, {
          get actorSheet() {
            return document2._sheet.actor;
          },
          get mount() {
            return get$1(mount2);
          },
          mountIndex: index2,
          get mountNames() {
            return mountNames;
          }
        });
      }, "dropdownContent");
      button.__click = (event2) => handleSelection(event2, dropdownContent, index2);
      var text_2 = child(button), node = sibling(text_2);
      {
        var consequent = /* @__PURE__ */ __name(($$anchor4) => {
          var i2 = root_6$h();
          append($$anchor4, i2);
        }, "consequent"), alternate = /* @__PURE__ */ __name(($$anchor4) => {
          var i_1 = root_7$e();
          append($$anchor4, i_1);
        }, "alternate");
        if_block(node, ($$render) => {
          toggles[index2] ? $$render(consequent) : $$render(alternate, !1);
        });
      }
      template_effect(($0) => set_text(text_2, `${$0 ?? ""} `), [() => getLocalized(mountNames[index2])]), append($$anchor3, button);
    }), template_effect(($0) => set_text(text_1, $0), [
      () => getLocalized("LA.advanced.mount.edit.label")
    ]), append($$anchor2, fragment_2);
  }, "editMount"), props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor, document: document2, system } = props;
  let advancedOptions = /* @__PURE__ */ derived(() => getAdvancedState(actor.uuid)), active = /* @__PURE__ */ derived(() => getActiveTab(actor.uuid, ActiveTab.Primary) || "loadout"), toggles = proxy(new Array(system.loadout.weapon_mounts.length).fill(!1)), tooltipElements = new Array(system.loadout.weapon_mounts.length).fill(null), removeToggle = state(!1), editToggle = state(!1), removeElement = null, editElement = null, mountNames = proxy(system.loadout.weapon_mounts.map((mount2) => MOUNT_LOCALIZE_MAP[mount2.type] || "")), mountIndices = proxy(system.loadout.weapon_mounts.map((_mount2, index2) => index2));
  const weaponMounts = system.loadout.weapon_mounts, tooltipEnabled = getMechSheetTooltipEnabled(), removeTip = TooltipFactory.buildTooltip(getLocalized("LA.advanced.mount.remove.tooltip")), editTip = TooltipFactory.buildTooltip(getLocalized("LA.advanced.mount.edit.tooltip"));
  function handleSelection(event2, snippet2, index2) {
    event2.stopPropagation();
    function clearOtherToggles() {
      toggles.forEach((toggle, jndex) => {
        toggle && jndex !== index2 && (TooltipFactory.unrenderTooltip(tooltipElements[jndex]), tooltipElements[jndex] = null, toggles[jndex] = !1);
      });
    }
    __name(clearOtherToggles, "clearOtherToggles");
    function clearToggles() {
      TooltipFactory.unrenderTooltip(tooltipElements[index2]), tooltipElements[index2] = null;
    }
    __name(clearToggles, "clearToggles"), clearOtherToggles(), toggles[index2] ? clearToggles() : tooltipElements[index2] = TooltipFactory.renderTooltipSvelte(event2, { content: snippet2 }, {
      direction: TooltipDirection.UP,
      cssClass: `la-tooltip -widthfull ${getCSSDocumentTheme(actor.uuid)}`,
      locked: !0
    }), toggles[index2] = !toggles[index2];
  }
  __name(handleSelection, "handleSelection");
  function handleRemove(event2, snippet2) {
    handleToggle(event2, snippet2, "remove");
  }
  __name(handleRemove, "handleRemove");
  function handleEdit(event2, snippet2) {
    handleToggle(event2, snippet2, "edit");
  }
  __name(handleEdit, "handleEdit");
  function handleToggle(event2, snippet2, type) {
    event2.stopPropagation();
    function clearOtherToggles() {
      toggles.forEach((toggle, index2) => {
        toggle && (TooltipFactory.unrenderTooltip(tooltipElements[index2]), tooltipElements[index2] = null, toggles[index2] = !1);
      }), TooltipFactory.unrenderTooltip(removeElement), removeElement = null, set(removeToggle, !1), TooltipFactory.unrenderTooltip(editElement), editElement = null, set(editToggle, !1);
    }
    __name(clearOtherToggles, "clearOtherToggles");
    function clearToggles() {
      type === "remove" ? (TooltipFactory.unrenderTooltip(removeElement), removeElement = null) : (toggles.forEach((toggle, index2) => {
        toggle && (TooltipFactory.unrenderTooltip(tooltipElements[index2]), tooltipElements[index2] = null, toggles[index2] = !1);
      }), TooltipFactory.unrenderTooltip(editElement), editElement = null);
    }
    if (__name(clearToggles, "clearToggles"), clearOtherToggles(), type === "remove" && get$1(removeToggle) || type === "edit" && get$1(editToggle))
      clearToggles();
    else {
      const element = TooltipFactory.renderTooltipSvelte(
        event2,
        {
          content: snippet2,
          unrenderCallback: clearToggles
        },
        {
          direction: TooltipDirection.RIGHT,
          cssClass: `la-tooltip -widthfull ${getCSSDocumentTheme(actor.uuid)}`,
          locked: !0
        }
      );
      type === "remove" ? removeElement = element : editElement = element;
    }
    type === "remove" ? set(removeToggle, !get$1(removeToggle)) : set(editToggle, !get$1(editToggle));
  }
  __name(handleToggle, "handleToggle");
  var div_2 = root$t(), span = child(div_2);
  set_class(span, `${SETTINGS_HEADER_STYLE$1} -alignend`);
  var text_3 = child(span), div_3 = sibling(span, 2), node_1 = child(div_3);
  const expression = /* @__PURE__ */ derived(getMechSheetTooltipEnabled), expression_1 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid));
  MountAdd(node_1, {
    get tooltipEnabled() {
      return get$1(expression);
    },
    get tooltipTheme() {
      return get$1(expression_1);
    }
  });
  var button_1 = sibling(node_1, 2);
  set_class(button_1, SETTINGS_BUTTON_STYLE$1), set_attribute(button_1, "data-tooltip", tooltipEnabled ? removeTip : void 0), button_1.__click = [on_click$2, handleRemove, removeMount];
  var button_2 = sibling(button_1, 2);
  set_class(button_2, SETTINGS_BUTTON_STYLE$1), set_attribute(button_2, "data-tooltip", tooltipEnabled ? editTip : void 0), button_2.__click = [on_click_1$1, handleEdit, editMount], template_effect(
    ($0, $1, $2, $3) => {
      set_class(div_2, `-heightfull
    ${(get$1(advancedOptions) && get$1(active) === "loadout" ? "la-combine-h" : "-displaynone") ?? ""}`), set_text(text_3, $0), set_attribute(button_1, "data-tooltip-direction", TooltipDirection.RIGHT), set_attribute(button_1, "data-tooltip-class", `clipped-bot la-tooltip ${$1 ?? ""}`), set_attribute(button_1, "aria-label", $2), set_attribute(button_2, "data-tooltip-direction", TooltipDirection.RIGHT), set_attribute(button_2, "data-tooltip-class", `clipped-bot la-tooltip ${$1 ?? ""}`), set_attribute(button_2, "aria-label", $3);
    },
    [
      () => getLocalized("LA.advanced.mount.label"),
      () => getCSSDocumentTheme(actor.uuid),
      () => getLocalized("LA.advanced.mount.remove.tooltip"),
      () => getLocalized("LA.advanced.mount.edit.tooltip")
    ]
  ), event("pointerenter", button_1, (event2) => sendToLog(event2, getLocalized("LA.advanced.mount.remove.tooltip"), TextLogHook.MechHeader)), event("pointerleave", button_1, (event2) => resetLog(event2, TextLogHook.MechHeaderReset)), event("pointerenter", button_2, (event2) => sendToLog(event2, getLocalized("LA.advanced.mount.edit.tooltip"), TextLogHook.MechHeader)), event("pointerleave", button_2, (event2) => resetLog(event2, TextLogHook.MechHeaderReset)), append($$anchor, div_2), pop();
}
__name(MountSettings, "MountSettings");
delegate(["click"]);
var root$s = /* @__PURE__ */ template('<div class="inventory -widthfull -heightfull"><button type="button"><!></button></div>');
function InventoryButton($$anchor, $$props) {
  push($$props, !0);
  const tip = TooltipFactory.buildTooltip($$props.tooltip || getLocalized("LA.advanced.inventory.open.tooltip"), $$props.tooltipHeader), logging = $$props.logType && $$props.logTypeReset, log = $$props.logText || getLocalized("LA.advanced.inventory.open.tooltip");
  var div = root$s(), button = child(div);
  button.__click = function(...$$args) {
    var _a;
    (_a = $$props.onClick) == null || _a.apply(this, $$args);
  };
  var node = child(button);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment = comment(), node_1 = first_child(fragment);
      snippet(node_1, () => $$props.children), append($$anchor2, fragment);
    }, "consequent");
    if_block(node, ($$render) => {
      $$props.children && $$render(consequent);
    });
  }
  template_effect(
    ($0) => {
      set_class(button, `
            ${$0 ?? ""}
            ${$$props.flowClass ?? ""}`), set_attribute(button, "data-tooltip", $$props.tooltipEnabled ? tip : void 0), set_attribute(button, "data-tooltip-class", `${$$props.tooltipClass || "clipped-bot la-tooltip"} ${$$props.tooltipTheme}`), set_attribute(button, "data-tooltip-direction", $$props.tooltipDirection || TooltipDirection.RIGHT), set_attribute(button, "aria-label", $$props.tooltip), button.disabled = $$props.disabled;
    },
    [() => {
      var _a;
      return (_a = $$props.style) == null ? void 0 : _a.join(" ");
    }]
  ), event("pointerenter", button, function(...$$args) {
    var _a;
    (_a = logging ? (event2) => sendToLog(event2, log, $$props.logType) : void 0) == null || _a.apply(this, $$args);
  }), event("pointerleave", button, function(...$$args) {
    var _a;
    (_a = logging ? (event2) => resetLog(event2, $$props.logTypeReset) : void 0) == null || _a.apply(this, $$args);
  }), append($$anchor, div), pop();
}
__name(InventoryButton, "InventoryButton");
delegate(["click"]);
var root$r = /* @__PURE__ */ template('<div><span> </span> <div class="la-combine-v -alignstart -padding0-b -heightfull"><!></div></div>');
function InventorySettings($$anchor, $$props) {
  push($$props, !0);
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor } = props;
  let advancedOptions = /* @__PURE__ */ derived(() => getAdvancedState(actor.uuid)), active = /* @__PURE__ */ derived(() => getActiveTab(actor.uuid, ActiveTab.Primary) || "loadout");
  const tooltipEnabled = getMechSheetTooltipEnabled();
  var div = root$r(), span = child(div);
  set_class(span, `${SETTINGS_HEADER_STYLE$1} -alignend`);
  var text2 = child(span), div_1 = sibling(span, 2), node = child(div_1);
  const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid));
  InventoryButton(node, {
    style: [SETTINGS_BUTTON_STYLE$1, "mdi mdi-archive"],
    get flowClass() {
      return FlowClass.Inventory;
    },
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression);
    },
    get logType() {
      return TextLogHook.MechHeader;
    },
    get logTypeReset() {
      return TextLogHook.MechHeaderReset;
    }
  }), template_effect(
    ($0) => {
      set_class(div, `-heightfull
    ${(get$1(advancedOptions) && get$1(active) === "loadout" ? "la-combine-h" : "-displaynone") ?? ""}`), set_text(text2, $0);
    },
    [
      () => getLocalized("LA.advanced.inventory.label")
    ]
  ), append($$anchor, div), pop();
}
__name(InventorySettings, "InventorySettings");
const SETTINGS_BUTTON_STYLE$1 = " la-text-secondary la-prmy-primary -glow-prmy-hover -fontsize3 -height2", SETTINGS_HEADER_STYLE$1 = " la-bckg-primary la-text-header clipped-top -width5 -writingmode-v -fontsize1 -padding0-b -padding1-t ";
var root$q = /* @__PURE__ */ template("<!> <!>", 1);
function AdvancedSettings$1($$anchor, $$props) {
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]);
  var fragment = root$q(), node = first_child(fragment);
  InventorySettings(node, spread_props(() => props));
  var node_1 = sibling(node, 2);
  MountSettings(node_1, spread_props(() => props)), append($$anchor, fragment);
}
__name(AdvancedSettings$1, "AdvancedSettings$1");
var on_input = /* @__PURE__ */ __name((event2, handleOnInput) => handleOnInput(event2), "on_input"), on_pointerup = /* @__PURE__ */ __name((event2, handleOnRelease) => handleOnRelease(event2), "on_pointerup"), root$p = /* @__PURE__ */ template('<div><input type="range" class="la-prmy-primary -glow-prmy-hover"></div>');
function SidebarRatioSlider($$anchor, $$props) {
  push($$props, !0);
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), {
    uuid,
    ratioGetter,
    ratioSetter,
    style,
    tooltipEnabled,
    tooltipClass,
    tooltipTheme,
    logText,
    logType,
    logTypeReset
  } = props;
  let advancedOptions = /* @__PURE__ */ derived(() => getAdvancedState(uuid)), ratio = state(proxy(ratioGetter(uuid))), component = state(null), sidebar = null;
  const tip = TooltipFactory.buildTooltip(getLocalized("LA.advanced.sidebarRatio.tooltip")), logging = logType && logTypeReset, log = logText || getLocalized("LA.advanced.sidebarRatio.tooltip");
  onMount(() => {
    get$1(component) && (sidebar = jQuery(get$1(component)).closest(".la-root").find(".la-sidebar"));
  });
  function handleOnInput(event2) {
    const target = event2.target, value = parseFloat(target.value);
    set(ratio, proxy(value)), sidebar && sidebar.css("flex", value.toString());
  }
  __name(handleOnInput, "handleOnInput");
  function handleOnRelease(event2) {
    const target = event2.target, value = parseFloat(target.value);
    set(ratio, proxy(value)), ratioSetter(uuid, value);
  }
  __name(handleOnRelease, "handleOnRelease");
  var div = root$p(), input = child(div);
  set_attribute(input, "min", 0.5), set_attribute(input, "max", 2), set_attribute(input, "step", 0.1), set_attribute(input, "data-tooltip", tooltipEnabled ? tip : void 0), set_attribute(input, "data-tooltip-class", `${tooltipClass || "clipped-bot la-tooltip"} ${tooltipTheme}`), input.__input = [on_input, handleOnInput], input.__pointerup = [on_pointerup, handleOnRelease], bind_this(div, ($$value) => set(component, $$value), () => get$1(component)), template_effect(
    ($0, $1) => {
      set_class(div, `la-range ${$0 ?? ""}
        ${(get$1(advancedOptions) ? "-displayblock" : "-displaynone") ?? ""}`), set_value(input, get$1(ratio)), set_attribute(input, "data-tooltip-direction", TooltipDirection.UP), set_attribute(input, "aria-label", $1);
    },
    [
      () => style == null ? void 0 : style.join(" "),
      () => getLocalized("LA.advanced.sidebarRatio.tooltip")
    ]
  ), event("pointerenter", input, function(...$$args) {
    var _a;
    (_a = logging ? (event2) => sendToLog(event2, log, logType) : void 0) == null || _a.apply(this, $$args);
  }), event("pointerleave", input, function(...$$args) {
    var _a;
    (_a = logging ? (event2) => resetLog(event2, logTypeReset) : void 0) == null || _a.apply(this, $$args);
  }), append($$anchor, div), pop();
}
__name(SidebarRatioSlider, "SidebarRatioSlider");
delegate(["input", "pointerup"]);
var on_click$1 = /* @__PURE__ */ __name((event2, handleThemeOverride, theme) => handleThemeOverride(event2, get$1(theme)), "on_click$1"), root_2$7 = /* @__PURE__ */ template('<button type="button" class="la-bckg-scrollbar-secondary la-text-header -fontsize1 -letterspacing0 la-prmy-secondary -glow-prmy-hover"> </button>'), on_click_1 = /* @__PURE__ */ __name((event2, handleThemeOverride) => handleThemeOverride(event2, "default"), "on_click_1"), root_1$9 = /* @__PURE__ */ template('<h3> <i class="mdi mdi-arrow-down-right"></i></h3> <div class="la-combine-v -widthfull -gap0 -padding0"><!> <button type="button" class="la-bckg-scrollbar-secondary la-text-header -fontsize1 -letterspacing0 la-prmy-secondary -glow-prmy-hover la-scdy-accent -glow-scdy-focus"> </button></div>', 1), on_click_2 = /* @__PURE__ */ __name((event2, handleOnClick) => handleOnClick(event2), "on_click_2"), root_3$h = /* @__PURE__ */ template('<button type="button"><i></i></button>');
function ThemeOverrideButton($$anchor, $$props) {
  push($$props, !0);
  const themeOverride = /* @__PURE__ */ __name(($$anchor2) => {
    var fragment = root_1$9(), h3 = first_child(fragment), text2 = child(h3), div = sibling(h3, 2), node = child(div);
    each(node, 17, () => Object.values(ThemeKey), index, ($$anchor3, theme) => {
      var button = root_2$7();
      button.__click = [on_click$1, handleThemeOverride, theme];
      var text_1 = child(button);
      template_effect(($0) => set_text(text_1, $0), [() => getThemeName(get$1(theme))]), append($$anchor3, button);
    });
    var button_1 = sibling(node, 2);
    button_1.__click = [on_click_1, handleThemeOverride];
    var text_2 = child(button_1);
    template_effect(
      ($0, $1) => {
        set_text(text2, $0), set_text(text_2, $1);
      },
      [
        () => getLocalized("LA.advanced.themeOverride.tooltip"),
        () => getLocalized("LA.advanced.theme.default.label")
      ]
    ), append($$anchor2, fragment);
  }, "themeOverride");
  let toggle = state(!1), optionElement = null;
  const tip = TooltipFactory.buildTooltip($$props.tooltip || getLocalized("LA.advanced.themeOverride.tooltip"), $$props.tooltipHeader), logging = $$props.logType && $$props.logTypeReset, log = $$props.logText || getLocalized("LA.advanced.themeOverride.tooltip");
  function handleOnClick(event2) {
    event2.stopPropagation(), get$1(toggle) ? (TooltipFactory.unrenderTooltip(optionElement), optionElement = null) : optionElement = TooltipFactory.renderTooltipSvelte(
      event2,
      {
        content: themeOverride,
        unrenderCallback: /* @__PURE__ */ __name(() => {
          set(toggle, !1);
        }, "unrenderCallback")
      },
      {
        direction: TooltipDirection.DOWN,
        cssClass: `la-tooltip -widthfull ${getCSSDocumentTheme($$props.uuid)}`,
        locked: !0
      }
    ), set(toggle, !get$1(toggle));
  }
  __name(handleOnClick, "handleOnClick");
  function handleThemeOverride(event2, theme) {
    event2.stopPropagation();
    const selectedTheme = theme === "default" ? "" : theme;
    if (optionElement) {
      const currentThemeClass = getCSSDocumentTheme($$props.uuid);
      optionElement.classList.remove(currentThemeClass), selectedTheme ? optionElement.classList.add(convertToCSSTheme(selectedTheme)) : optionElement.classList.add(getCSSSystemTheme());
    }
    $$props.setOverride($$props.uuid, selectedTheme);
  }
  __name(handleThemeOverride, "handleThemeOverride");
  var fragment_1 = comment(), node_1 = first_child(fragment_1);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var button_2 = root_3$h();
      button_2.__click = [on_click_2, handleOnClick];
      var i2 = child(button_2);
      template_effect(
        ($0, $1, $2, $3) => {
          set_class(button_2, `${$0 ?? ""} la-prmy-primary -glow-prmy-hover`), set_attribute(button_2, "data-tooltip", $$props.tooltipEnabled ? tip : void 0), set_attribute(button_2, "data-tooltip-class", $1), set_attribute(button_2, "data-tooltip-direction", $$props.tooltipDirection || TooltipDirection.UP), set_attribute(button_2, "aria-label", $2), set_class(i2, `mdi mdi-notebook-edit ${$3 ?? ""}`);
        },
        [
          () => {
            var _a;
            return (_a = $$props.style) == null ? void 0 : _a.join(" ");
          },
          () => `${$$props.tooltipClass || "clipped-bot la-tooltip"} ${getCSSDocumentTheme($$props.uuid)}`,
          () => getLocalized("LA.advanced.themeOverride.tooltip"),
          () => {
            var _a;
            return ((_a = $$props.iconStyle) == null ? void 0 : _a.join(" ")) || "la-text-header -fontsize3";
          }
        ]
      ), event("pointerenter", button_2, function(...$$args) {
        var _a;
        (_a = logging ? (event2) => sendToLog(event2, log, $$props.logType) : void 0) == null || _a.apply(this, $$args);
      }), event("pointerleave", button_2, function(...$$args) {
        var _a;
        (_a = logging ? (event2) => resetLog(event2, $$props.logTypeReset) : void 0) == null || _a.apply(this, $$args);
      }), append($$anchor2, button_2);
    }, "consequent");
    if_block(node_1, ($$render) => {
      $$props.disabled || $$render(consequent);
    });
  }
  append($$anchor, fragment_1), pop();
}
__name(ThemeOverrideButton, "ThemeOverrideButton");
delegate(["click"]);
var root$o = /* @__PURE__ */ template("<!> <!>", 1);
function AdvancedSettingsNav$1($$anchor, $$props) {
  push($$props, !0);
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor } = props;
  let advancedOptions = /* @__PURE__ */ derived(() => getAdvancedState(actor.uuid));
  const tooltipEnabled = getMechSheetTooltipEnabled();
  var fragment = root$o(), node = first_child(fragment);
  const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid));
  SidebarRatioSlider(node, {
    get uuid() {
      return actor.uuid;
    },
    ratioGetter: getSidebarRatio$1,
    ratioSetter: setSidebarRatio$1,
    style: ["-aligncontentcenter"],
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression);
    },
    get logType() {
      return TextLogHook.MechHeader;
    },
    get logTypeReset() {
      return TextLogHook.MechHeaderReset;
    }
  });
  var node_1 = sibling(node, 2);
  const expression_1 = /* @__PURE__ */ derived(() => !get$1(advancedOptions)), expression_2 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid));
  ThemeOverrideButton(node_1, {
    get disabled() {
      return get$1(expression_1);
    },
    get uuid() {
      return actor.uuid;
    },
    style: ["-alignselfstart"],
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_2);
    },
    setOverride: setThemeOverride$3,
    get logType() {
      return TextLogHook.MechHeader;
    },
    get logTypeReset() {
      return TextLogHook.MechHeaderReset;
    }
  }), append($$anchor, fragment), pop();
}
__name(AdvancedSettingsNav$1, "AdvancedSettingsNav$1");
var root$n = /* @__PURE__ */ template('<div class="-margin5-t"><!></div>');
function Activity$3($$anchor, $$props) {
  push($$props, !0);
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor } = props, actionLogSaveCollapse = getMechSheetLogActionDontSaveCollapse(), actionLogStartCollapsed = getMechSheetLogActionStartCollapsed();
  var div = root$n(), node = child(div);
  ActionLog(node, {
    get uuid() {
      return actor.uuid;
    },
    dontSaveCollapse: actionLogSaveCollapse,
    startCollapsed: actionLogStartCollapsed,
    get collapsePrefix() {
      return ActionLogCollapsePrefix.MechSheet;
    }
  }), append($$anchor, div), pop();
}
__name(Activity$3, "Activity$3");
const _MechSheetBase = class _MechSheetBase {
  static get mergeOptions() {
    return {
      classes: [
        "la-common",
        "la-override__header",
        "clipped-alt",
        "lancer",
        "sheet",
        "actor",
        "mech",
        getCSSSystemTheme()
      ],
      template: TEMPLATE_PATHS.mechSheetSvelte,
      width: 900,
      height: 800,
      tabs: [
        {
          navSelector: ".la-tabs",
          contentSelector: ".la-content",
          initial: "loadout"
        },
        {
          navSelector: ".la-tabs-secondary",
          contentSelector: ".la-content-secondary",
          initial: "statistics"
        }
      ],
      scrollY: [".la-SCROLL-BODY", ".la-SCROLL-SIDEBAR"]
    };
  }
  static setupSheet() {
    var _a;
    const LAMechSheet = (_a = class extends game.lancer.applications.LancerMechSheet {
      constructor(...args) {
        super(...args), Hooks.on("laOverrideTheme", (uuid, theme) => {
          uuid === this.actor.uuid && (setThemeKey(this.actor.uuid, theme), this.render());
        }), Hooks.on("laForceRerender", (uuid, callback) => {
          uuid === this.actor.uuid && (this.render(), callback && callback());
        }), Hooks.on("updateActor", (document2, changes) => {
          var _a2, _b;
          document2.uuid === this.actor.uuid && ((_b = (_a2 = changes.prototypeToken) == null ? void 0 : _a2.texture) != null && _b.src) && getActorTokenSync$3(this.actor.uuid) && (setSelectedTokenImage(this.actor.uuid, changes.prototypeToken.texture.src), isValidImageContainer(changes.prototypeToken.texture.src) && this.actor.update({ img: changes.prototypeToken.texture.src }));
        }), Hooks.on("closeSettingsConfig", () => {
          this.render(), setIntroRun(this.actor.uuid, !1);
        });
      }
      static get defaultOptions() {
        return mergeObject(super.defaultOptions, _MechSheetBase.mergeOptions);
      }
      activateListeners(html2) {
        super.activateListeners(html2), this.applyTabListener(html2);
      }
      async getData() {
        return await super.getData();
      }
      /** (#10) - As of V12, there's a section of code in the Lancer system that bugs out actor/token image assignment in the AppV1 LancerActorSheet
       * ...
       * // Update token image if it matches the old actor image - keep in sync
       * if (this.actor.img === token.texture.src && this.actor.img !== formData["img"]) {
       *   formData["prototypeToken.texture.src"] = formData["img"];
       * }
       * ...
       * 
       * We need to ensure prototypeToken.texture.src exists to be set by Foundry
       */
      // @ts-expect-error We're overriding a function in LancerActorSheet
      _propagateData(formData) {
        super._propagateData(formData), delete formData["prototypeToken.texture.src"];
        const updateToken = getSelectedTokenImage(this.actor.uuid);
        updateToken && (formData["prototypeToken.texture.src"] = updateToken);
      }
      async _injectHTML(html2) {
        super._injectHTML(html2), setThemeKey(this.actor.uuid, getThemeOverride$3(this.actor.uuid)), applyThemeTo(this.element, getThemeKey(this.actor.uuid)), this.mountComponents(html2, dataMap[this.actor.uuid]);
      }
      async _replaceHTML(element, html2) {
        super._replaceHTML(element, html2), applyThemeTo(element, getThemeKey(this.actor.uuid)), this.mountComponents(html2, dataMap[this.actor.uuid]), this._restoreScrollPositions(html2);
      }
      mountComponents(html2, data) {
        unregisterTrackedHooks(this.actor.uuid), mount(Header$3, {
          target: html2.find(".la-SVELTE-HEADER")[0],
          props: data
        }), mount(AdvancedSettingsNav$1, {
          target: html2.find(".la-SVELTE-ADVANCEDNAV")[0],
          props: data
        }), mount(Sidebar$1, {
          target: html2.find(".la-SVELTE-SIDEBARSTATISTICS")[0],
          props: data
        }), mount(Activity$3, {
          target: html2.find(".la-SVELTE-SIDEBARACTIVITY")[0],
          props: data
        }), mount(Status$1, {
          target: html2.find(".la-SVELTE-STATUS")[0],
          props: data
        }), mount(AdvancedSettings$1, {
          target: html2.find(".la-SVELTE-ADVANCED")[0],
          props: data
        }), mount(Loadout$1, {
          target: html2.find(".la-SVELTE-LOADOUT")[0],
          props: data
        }), mount(HaseArray, {
          target: html2.find(".la-SVELTE-HASE")[0],
          props: {
            pilot: data.pilot,
            actor: data.actor,
            system: data.system,
            tooltipEnabled: getMechSheetTooltipEnabled(),
            logType: TextLogHook.MechHeader,
            logTypeReset: TextLogHook.MechHeaderReset
          }
        });
      }
      applyTabListener(html2) {
        html2.find(".la-nav__island>.la-tabs>.la-tab").each((_, button) => {
          $(button).on("click", (event2) => {
            const tab = $(event2.currentTarget).data("tab");
            setActiveTab(this.actor.uuid, ActiveTab.Primary, tab);
          });
        }), html2.find(".la-nav-secondary__island>.la-tabs-secondary>.la-tab").each((_, button) => {
          $(button).on("click", (event2) => {
            const tab = $(event2.currentTarget).data("tab");
            setActiveTab(this.actor.uuid, ActiveTab.Secondary, tab);
          });
        });
      }
    }, __name(_a, "LAMechSheet"), _a);
    Actors.registerSheet(LancerAlternative.Name, LAMechSheet, {
      types: ["mech"],
      label: getLocalized("LA.SHEET.mech.label"),
      makeDefault: !1
    });
  }
};
__name(_MechSheetBase, "MechSheetBase");
let MechSheetBase = _MechSheetBase;
const _NPCSheetSettings = class _NPCSheetSettings {
  static emptyContent() {
    return {
      themeOverride: "",
      sidebarExes: [],
      syncActorTokenImages: !0
    };
  }
};
__name(_NPCSheetSettings, "NPCSheetSettings");
let NPCSheetSettings = _NPCSheetSettings;
function registerNPCSheetSettings() {
  game.settings.register(LancerAlternative.Name, "npc-settings-tip", {
    name: "LA.SETTINGS.npc.enableTooltip.label",
    hint: "LA.SETTINGS.npc.enableTooltip.subLabel",
    scope: "client",
    config: !0,
    type: Boolean,
    default: !0
  }), game.settings.register(LancerAlternative.Name, "npc-settings-sheet-width", {
    name: "LA.SETTINGS.npc.sheetWidth.label",
    hint: "LA.SETTINGS.npc.sheetWidth.subLabel",
    scope: "client",
    config: !0,
    requiresReload: !0,
    // @ts-ignore
    type: Number,
    default: 500
  }), game.settings.register(LancerAlternative.Name, "npc-settings-sheet-height", {
    name: "LA.SETTINGS.npc.sheetHeight.label",
    hint: "LA.SETTINGS.npc.sheetHeight.subLabel",
    scope: "client",
    config: !0,
    requiresReload: !0,
    // @ts-ignore
    type: Number,
    default: 800
  }), game.settings.register(LancerAlternative.Name, "npc-settings-log-action-save-collapse", {
    name: "LA.SETTINGS.npc.saveCollapse.label",
    hint: "LA.SETTINGS.npc.saveCollapse.subLabel",
    scope: "client",
    config: !0,
    type: Boolean,
    default: !1
  }), game.settings.register(LancerAlternative.Name, "npc-settings-log-action-start-collapsed", {
    name: "LA.SETTINGS.npc.startCollapsed.label",
    hint: "LA.SETTINGS.npc.startCollapsed.subLabel",
    scope: "client",
    config: !0,
    type: Boolean,
    default: !0
  }), game.settings.register(LancerAlternative.Name, "_npc-settings", {
    scope: "world",
    config: !1,
    type: Array,
    // MessagePack encoded object
    default: []
  }), game.settings.register(LancerAlternative.Name, "_npc-settings-version", {
    scope: "world",
    config: !1,
    type: String,
    default: ""
  }), SocketManager.getInstance().register(setNPCSheetData);
}
__name(registerNPCSheetSettings, "registerNPCSheetSettings");
function getNPCSheetTooltipEnabled() {
  return game.settings.get(LancerAlternative.Name, "npc-settings-tip");
}
__name(getNPCSheetTooltipEnabled, "getNPCSheetTooltipEnabled");
function getNPCSheetWidth() {
  const width = game.settings.get(LancerAlternative.Name, "npc-settings-sheet-width");
  return Math.max(0, width);
}
__name(getNPCSheetWidth, "getNPCSheetWidth");
function getNPCSheetHeight() {
  const height = game.settings.get(LancerAlternative.Name, "npc-settings-sheet-height");
  return Math.max(0, height);
}
__name(getNPCSheetHeight, "getNPCSheetHeight");
function getNPCSheetLogActionDontSaveCollapse() {
  return !game.settings.get(LancerAlternative.Name, "npc-settings-log-action-save-collapse");
}
__name(getNPCSheetLogActionDontSaveCollapse, "getNPCSheetLogActionDontSaveCollapse");
function getNPCSheetLogActionStartCollapsed() {
  return game.settings.get(LancerAlternative.Name, "npc-settings-log-action-start-collapsed");
}
__name(getNPCSheetLogActionStartCollapsed, "getNPCSheetLogActionStartCollapsed");
function resetNPCSheetData(uuid) {
  var _a, _b;
  if (uuid) {
    const data = getNPCSheetData();
    data[uuid] && delete data[uuid], setNPCSheetData(encodeNPCSheetData(data));
  } else
    game.settings.set(LancerAlternative.Name, "_npc-settings", (_a = game.settings.settings.get(`${LancerAlternative.Name}._npc-settings`)) == null ? void 0 : _a.default), game.settings.set(LancerAlternative.Name, "_npc-settings-version", (_b = game.settings.settings.get(`${LancerAlternative.Name}._npc-settings-version`)) == null ? void 0 : _b.default);
}
__name(resetNPCSheetData, "resetNPCSheetData");
function getNPCSheetData() {
  const settings = game.settings.get(LancerAlternative.Name, "_npc-settings");
  if (!settings.length)
    return new NPCSheetSettings();
  try {
    let encoded = new Uint8Array(Object.values(settings));
    return encoded.length === 1 && (Logger.log("NPCSheetSettings: Decoding failed, trying legacy decode."), encoded = new Uint8Array(Object.values(settings[0]))), msgPackDecoder.decode(encoded);
  } catch {
    return Logger.error("NPCSheetSettings: Decoding failed, returning empty settings."), new NPCSheetSettings();
  }
}
__name(getNPCSheetData, "getNPCSheetData");
function getRoot$1(uuid) {
  return uuid.includes("Actor.") ? uuid.split(".").slice(-2).join(".") : null;
}
__name(getRoot$1, "getRoot$1");
function migratedDefaults$1(uuid, data) {
  const defaultSettings = NPCSheetSettings.emptyContent();
  return defaultSettings.syncActorTokenImages = determineActorTokenSync$1(uuid, data), defaultSettings;
}
__name(migratedDefaults$1, "migratedDefaults$1");
function encodeNPCSheetData(data) {
  const encoded = msgPackEncoder.encode(data);
  return Array.from(encoded);
}
__name(encodeNPCSheetData, "encodeNPCSheetData");
function setNPCSheetData(encoded) {
  return Promise.all([
    game.settings.set(LancerAlternative.Name, "_npc-settings", encoded),
    game.settings.set(LancerAlternative.Name, "_npc-settings-version", getModuleVersion())
  ]);
}
__name(setNPCSheetData, "setNPCSheetData");
function getThemeOverride$1(uuid) {
  var _a;
  const data = getNPCSheetData(), workingUUID = getRoot$1(uuid) ?? uuid;
  return ((_a = data[workingUUID]) == null ? void 0 : _a.themeOverride) ?? "";
}
__name(getThemeOverride$1, "getThemeOverride$1");
function setThemeOverride$1(uuid, value) {
  const data = getNPCSheetData(), workingUUID = getRoot$1(uuid) ?? uuid;
  data[workingUUID] || (data[workingUUID] = migratedDefaults$1(workingUUID, data)), data[workingUUID].themeOverride = value, SocketManager.getInstance().runAsGM(
    setNPCSheetData,
    () => {
      Logger.log(`Theme override set to ${value} for ${uuid}`);
    },
    encodeNPCSheetData(data)
  ), Hooks.call("laOverrideTheme", uuid, value);
}
__name(setThemeOverride$1, "setThemeOverride$1");
function getSidebarExecutables(uuid) {
  var _a;
  const data = getNPCSheetData(), workingUUID = getRoot$1(uuid) ?? uuid;
  return ((_a = data[workingUUID]) == null ? void 0 : _a.sidebarExes) ?? [];
}
__name(getSidebarExecutables, "getSidebarExecutables");
function setSidebarExecutables(uuid, macros) {
  const data = getNPCSheetData(), workingUUID = getRoot$1(uuid) ?? uuid;
  data[workingUUID] || (data[workingUUID] = migratedDefaults$1(workingUUID, data)), data[workingUUID].sidebarExes = macros, SocketManager.getInstance().runAsGM(
    setNPCSheetData,
    () => {
      Logger.log(`Sidebar executables set to ${macros.join(", ")} for ${uuid}`);
    },
    encodeNPCSheetData(data)
  );
}
__name(setSidebarExecutables, "setSidebarExecutables");
function getActorTokenSync$1(uuid) {
  const data = getNPCSheetData(), workingUUID = getRoot$1(uuid) ?? uuid;
  return determineActorTokenSync$1(workingUUID, data);
}
__name(getActorTokenSync$1, "getActorTokenSync$1");
function determineActorTokenSync$1(uuid, data) {
  var _a, _b, _c, _d;
  if (((_a = data[uuid]) == null ? void 0 : _a.syncActorTokenImages) === void 0 || ((_b = data[uuid]) == null ? void 0 : _b.syncActorTokenImages) === null) {
    Logger.log("Determining default syncActorTokenImages setting for a new or unsaved NPC/old module version");
    const actor = fromUuidSync(uuid);
    return (_d = (_c = actor.prototypeToken) == null ? void 0 : _c.texture) != null && _d.src && actor.img ? actor.img === actor.prototypeToken.texture.src : !0;
  } else
    return data[uuid].syncActorTokenImages;
}
__name(determineActorTokenSync$1, "determineActorTokenSync$1");
function setActorTokenSync$1(uuid, value) {
  const data = getNPCSheetData(), workingUUID = getRoot$1(uuid) ?? uuid;
  data[workingUUID] || (data[workingUUID] = migratedDefaults$1(workingUUID, data)), data[workingUUID].syncActorTokenImages = value, SocketManager.getInstance().runAsGM(
    setNPCSheetData,
    () => {
      Logger.log(`Sync actor-token images set to ${value} for ${uuid}`);
    },
    encodeNPCSheetData(data)
  );
}
__name(setActorTokenSync$1, "setActorTokenSync$1");
function ChargedBox($$anchor, $$props) {
  push($$props, !0);
  let charged = $$props.item.system.charged;
  const log = $$props.logText || getLocalized("LA.npc.charged.tooltip");
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      const expression = /* @__PURE__ */ derived(() => getLocalized("LA.npc.charged.label"));
      CounterBox($$anchor2, {
        get text() {
          return get$1(expression);
        },
        get type() {
          return CounterBoxType.Charged;
        },
        usesValue: charged ? 1 : 0,
        usesMax: 1,
        get path() {
          return $$props.path;
        },
        get style() {
          return $$props.style;
        },
        logText: log,
        get logType() {
          return $$props.logType;
        },
        get logTypeReset() {
          return $$props.logTypeReset;
        },
        get onPointerClick() {
          return $$props.onPointerClick;
        }
      });
    }, "consequent");
    if_block(node, ($$render) => {
      isRecharge($$props.item) && $$render(consequent);
    });
  }
  append($$anchor, fragment), pop();
}
__name(ChargedBox, "ChargedBox");
var root_6$g = /* @__PURE__ */ template('<span class="la-combine-h -justifycenter -aligncenter -fontsize3 -padding0-lr"> <i class="cci cci-accuracy -fontsize4"></i></span>'), root_7$d = /* @__PURE__ */ template('<span class="la-combine-h -justifycenter -aligncenter -fontsize3 -padding0-lr"> <i class="cci cci-reticule -fontsize2"></i></span>'), root_5$d = /* @__PURE__ */ template('<div class="-widthfull -padding2-l"><div class="la-combine-h clipped-bot-alt la-text-header la-bckg-header-anti -widthfull"><!> <!> <!> <!> <!></div></div>'), root_9$9 = /* @__PURE__ */ template('<!> <div class="la-combine-v -margin3-lr"><!> <!></div>', 1), root_10$9 = /* @__PURE__ */ template("<!> <!> <!>", 1), root_3$g = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull"></div>');
function Weapons($$anchor, $$props) {
  push($$props, !0);
  const headerOptions = /* @__PURE__ */ __name(($$anchor2) => {
    const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
    CollapseAllButton($$anchor2, {
      collapseID: collID,
      tooltipEnabled,
      get tooltipTheme() {
        return get$1(expression);
      },
      onPointerEnter: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !0);
      }, "onPointerEnter"),
      onPointerLeave: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !1);
      }, "onPointerLeave")
    });
  }, "headerOptions");
  let collapseAllButtonHover = state(!1), attackButtonHover = state(!1), damageButtonHover = state(!1), messageButtonHover = state(!1), editButtonHover = state(!1);
  const tooltipEnabled = getNPCSheetTooltipEnabled(), tier = $$props.system.tier, collID = `${$$props.actor.uuid}.weapons`, accuracyTip = TooltipFactory.buildTooltip(getLocalized("LA.npc.accuracy.tooltip")), attackTip = TooltipFactory.buildTooltip(getLocalized("LA.npc.attackBonus.tooltip"));
  function renderOuter(weapon) {
    return !isDestroyed(weapon) && (isRecharge(weapon) || weapon.system.uses.max || isLoading(weapon) || hasAccuracyBonus(weapon) || hasAttackBonus(weapon));
  }
  __name(renderOuter, "renderOuter");
  function hasAccuracyBonus(weapon) {
    return weapon.system.accuracy.some((accuracy) => accuracy !== 0);
  }
  __name(hasAccuracyBonus, "hasAccuracyBonus");
  function hasAttackBonus(weapon) {
    return weapon.system.attack_bonus.some((bonus) => bonus !== 0);
  }
  __name(hasAttackBonus, "hasAttackBonus");
  function isDestroyed(weapon) {
    return weapon.system.destroyed;
  }
  __name(isDestroyed, "isDestroyed");
  function getTitleStyle(weapon) {
    return isDestroyed(weapon) ? "la-text-repcap -strikethrough" : "la-text-header";
  }
  __name(getTitleStyle, "getTitleStyle");
  function getSubtitleStyle(weapon) {
    return isDestroyed(weapon) ? "la-text-error la-prmy-error horus--very--subtle" : "la-text-header la-prmy-header";
  }
  __name(getSubtitleStyle, "getSubtitleStyle");
  function getIconStyle(weapon) {
    return isDestroyed(weapon) ? "la-text-repcap" : "la-text-header la-prmy-header -glow-prmy la-scdy-primary -glow-scdy-hover";
  }
  __name(getIconStyle, "getIconStyle");
  function getRollWeaponTip(weapon) {
    return formatString(getLocalized("LA.flow.rollAttack.template.tooltip"), weapon.name);
  }
  __name(getRollWeaponTip, "getRollWeaponTip");
  function sendToChat(event2, weapon) {
    if (event2.stopPropagation(), $$props.actor && weapon) {
      let chatData = {
        title: weapon.name,
        trigger: weapon.system.trigger,
        effect: weapon.system.effect,
        onHit: weapon.system.on_hit,
        attackBonus: weapon.system.attack_bonus[tier - 1],
        accuracyBonus: weapon.system.accuracy[tier - 1],
        tags: weapon.system.tags
      };
      SendUnknownToChatBase.getInstance().startFlow($$props.actor.uuid, chatData);
    }
  }
  __name(sendToChat, "sendToChat");
  var fragment_1 = comment(), node = first_child(fragment_1);
  {
    var consequent_2 = /* @__PURE__ */ __name(($$anchor2) => {
      const expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.weapons.label"));
      HeaderMain($$anchor2, {
        get text() {
          return get$1(expression_1);
        },
        headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-weapon"],
        textStyle: [
          "la-text-header",
          "-fontsize2",
          "-overflowhidden"
        ],
        borderStyle: ["la-brdr-weapon", "-gap0"],
        extensionTextFunction: /* @__PURE__ */ __name(() => {
          if (get$1(collapseAllButtonHover)) return `--${getLocalized("LA.collapseAll.extension")}`;
        }, "extensionTextFunction"),
        collapseID: collID,
        startCollapsed: !0,
        headerContent: headerOptions,
        children: /* @__PURE__ */ __name(($$anchor3, $$slotProps) => {
          var div = root_3$g();
          each(div, 21, () => $$props.weapons, index, ($$anchor4, weapon, index2) => {
            const outerContent = /* @__PURE__ */ __name(($$anchor5) => {
              var div_1 = root_5$d(), div_2 = child(div_1), node_1 = child(div_2);
              {
                var consequent = /* @__PURE__ */ __name(($$anchor6) => {
                  var span = root_6$g();
                  set_attribute(span, "data-tooltip", tooltipEnabled ? accuracyTip : void 0);
                  var text2 = child(span);
                  template_effect(
                    ($0) => {
                      set_attribute(span, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(span, "data-tooltip-direction", TooltipDirection.DOWN), set_text(text2, `${get$1(weapon).system.accuracy[tier - 1] ?? ""} `);
                    },
                    [
                      () => getCSSDocumentTheme($$props.actor.uuid)
                    ]
                  ), append($$anchor6, span);
                }, "consequent");
                if_block(node_1, ($$render) => {
                  hasAccuracyBonus(get$1(weapon)) && $$render(consequent);
                });
              }
              var node_2 = sibling(node_1, 2);
              {
                var consequent_1 = /* @__PURE__ */ __name(($$anchor6) => {
                  var span_1 = root_7$d();
                  set_attribute(span_1, "data-tooltip", tooltipEnabled ? attackTip : void 0);
                  var text_1 = child(span_1);
                  template_effect(
                    ($0) => {
                      set_attribute(span_1, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(span_1, "data-tooltip-direction", TooltipDirection.DOWN), set_text(text_1, `${get$1(weapon).system.attack_bonus[tier - 1] ?? ""} `);
                    },
                    [
                      () => getCSSDocumentTheme($$props.actor.uuid)
                    ]
                  ), append($$anchor6, span_1);
                }, "consequent_1");
                if_block(node_2, ($$render) => {
                  hasAttackBonus(get$1(weapon)) && $$render(consequent_1);
                });
              }
              var node_3 = sibling(node_2, 2);
              const expression_2 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(weapon).index}.system.charged`);
              ChargedBox(node_3, {
                get item() {
                  return get$1(weapon);
                },
                get path() {
                  return get$1(expression_2);
                }
              });
              var node_4 = sibling(node_3, 2);
              const expression_3 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(weapon).index}.system.loaded`);
              LoadedBox(node_4, {
                get item() {
                  return get$1(weapon);
                },
                get path() {
                  return get$1(expression_3);
                }
              });
              var node_5 = sibling(node_4, 2);
              const expression_4 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(weapon).index}.system.uses`);
              LimitedBox(node_5, {
                get usesValue() {
                  return get$1(weapon).system.uses.value;
                },
                get usesMax() {
                  return get$1(weapon).system.uses.max;
                },
                get path() {
                  return get$1(expression_4);
                }
              }), append($$anchor5, div_1);
            }, "outerContent"), headerTertiaryLeftOptions = /* @__PURE__ */ __name(($$anchor5) => {
              const expression_5 = /* @__PURE__ */ derived(() => [
                H3_ICON_SIZE,
                getIconStyle(get$1(weapon)),
                "cci",
                "cci-weapon"
              ]), expression_6 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_7 = /* @__PURE__ */ derived(() => get$1(weapon).system.effect ? `${getRollWeaponTip(get$1(weapon))}<br><br>${get$1(weapon).system.effect}` : getRollWeaponTip(get$1(weapon))), expression_8 = /* @__PURE__ */ derived(() => isDestroyed(get$1(weapon)));
              AttackButton($$anchor5, {
                get iconStyle() {
                  return get$1(expression_5);
                },
                iconBackgroundStyle: [
                  H3_ICON_SIZE,
                  "la-prmy-secondary",
                  "-pulse-prmy"
                ],
                get flowClass() {
                  return FlowClass.RollAttack;
                },
                path: `system.loadout.weapon_mounts.${index2}`,
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_6);
                },
                get tooltipDirection() {
                  return TooltipDirection.UP;
                },
                get tooltip() {
                  return get$1(expression_7);
                },
                get disabled() {
                  return get$1(expression_8);
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(attackButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(attackButtonHover, !1);
                }, "onPointerLeave")
              });
            }, "headerTertiaryLeftOptions"), headerTertiaryRightOptions = /* @__PURE__ */ __name(($$anchor5) => {
              var fragment_4 = root_9$9(), node_6 = first_child(fragment_4);
              const expression_9 = /* @__PURE__ */ derived(() => isDestroyed(get$1(weapon)) ? ["la-text-repcap"] : void 0), expression_10 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_11 = /* @__PURE__ */ derived(() => isDestroyed(get$1(weapon)));
              DamageButton(node_6, {
                get iconStyle() {
                  return get$1(expression_9);
                },
                iconBackgroundStyle: [
                  "-fontsize7",
                  "la-prmy-secondary",
                  "-pulse-prmy"
                ],
                get flowClass() {
                  return FlowClass.RollDamage;
                },
                get range() {
                  return get$1(weapon).system.range;
                },
                get damage() {
                  return get$1(weapon).system.damage[tier - 1];
                },
                tooltipEnabled,
                get tooltipDirection() {
                  return TooltipDirection.UP;
                },
                get tooltipTheme() {
                  return get$1(expression_10);
                },
                get disabled() {
                  return get$1(expression_11);
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(damageButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(damageButtonHover, !1);
                }, "onPointerLeave")
              });
              var div_3 = sibling(node_6, 2), node_7 = child(div_3);
              const expression_12 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
              MessageButton(node_7, {
                get flowClass() {
                  return FlowClass.None;
                },
                get uuid() {
                  return get$1(weapon).uuid;
                },
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_12);
                },
                onClick: /* @__PURE__ */ __name((event2) => sendToChat(event2, get$1(weapon)), "onClick"),
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(messageButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(messageButtonHover, !1);
                }, "onPointerLeave")
              });
              var node_8 = sibling(node_7, 2);
              const expression_13 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(weapon).index}`), expression_14 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
              EditButton(node_8, {
                get flowClass() {
                  return FlowClass.ContextMenu;
                },
                get path() {
                  return get$1(expression_13);
                },
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_14);
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !1);
                }, "onPointerLeave")
              }), append($$anchor5, fragment_4);
            }, "headerTertiaryRightOptions"), expression_15 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(weapon).index}`), expression_16 = /* @__PURE__ */ derived(() => [
              getTitleStyle(get$1(weapon)),
              "-fontsize1"
            ]), expression_17 = /* @__PURE__ */ derived(() => isDestroyed(get$1(weapon)) ? getLocalized("LA.mech.slot.destroyed.label") : get$1(weapon).system.weapon_type), expression_18 = /* @__PURE__ */ derived(() => [
              getSubtitleStyle(get$1(weapon)),
              "-fontsize0"
            ]), expression_19 = /* @__PURE__ */ derived(() => renderOuter(get$1(weapon)) ? outerContent : void 0);
            HeaderTertiary($$anchor4, {
              get itemID() {
                return get$1(weapon).id;
              },
              get uuid() {
                return get$1(weapon).uuid;
              },
              get path() {
                return get$1(expression_15);
              },
              acceptTypes: "npc_feature",
              get collapseID() {
                return get$1(weapon).uuid;
              },
              startCollapsed: !0,
              get text() {
                return get$1(weapon).name;
              },
              headerStyle: [H3_HEADER_STYLE, "la-bckg-pilot"],
              get headerFontStyle() {
                return get$1(expression_16);
              },
              get subText() {
                return get$1(expression_17);
              },
              get subHeaderFontStyle() {
                return get$1(expression_18);
              },
              borderStyle: ["-bordersoff"],
              extensionTextFunction: /* @__PURE__ */ __name(() => {
                if (get$1(attackButtonHover)) return `--${getLocalized("LA.flow.rollAttack.extension")}`;
                if (get$1(damageButtonHover)) return `--${getLocalized("LA.flow.rollDamage.extension")}`;
                if (get$1(messageButtonHover)) return `--${getLocalized("LA.chat.extension")}`;
                if (get$1(editButtonHover)) return `--${getLocalized("LA.edit.extension")}`;
              }, "extensionTextFunction"),
              get renderOutsideCollapse() {
                return get$1(expression_19);
              },
              contentLeft: headerTertiaryLeftOptions,
              contentRight: headerTertiaryRightOptions,
              children: /* @__PURE__ */ __name(($$anchor5, $$slotProps2) => {
                var fragment_6 = root_10$9(), node_9 = first_child(fragment_6);
                const expression_20 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.system.effect.label"));
                EffectBox(node_9, {
                  get name() {
                    return get$1(expression_20);
                  },
                  get effect() {
                    return get$1(weapon).system.effect;
                  },
                  tooltipEnabled
                });
                var node_10 = sibling(node_9, 2);
                const expression_21 = /* @__PURE__ */ derived(() => getLocalized("LA.effect.hit.label"));
                EffectBox(node_10, {
                  get name() {
                    return get$1(expression_21);
                  },
                  get effect() {
                    return get$1(weapon).system.on_hit;
                  },
                  tooltipEnabled
                });
                var node_11 = sibling(node_10, 2);
                const expression_22 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(weapon).index}.system.all_tags`);
                TagArray(node_11, {
                  get tags() {
                    return get$1(weapon).system.tags;
                  },
                  get path() {
                    return get$1(expression_22);
                  },
                  justify: "end"
                }), append($$anchor5, fragment_6);
              }, "children"),
              $$slots: { default: !0 }
            });
          }), append($$anchor3, div);
        }, "children"),
        $$slots: { default: !0 }
      });
    }, "consequent_2");
    if_block(node, ($$render) => {
      $$props.weapons.length && $$render(consequent_2);
    });
  }
  append($$anchor, fragment_1), pop();
}
__name(Weapons, "Weapons");
var root_5$c = /* @__PURE__ */ template('<div class="-widthfull -padding2-l"><div class="la-combine-h clipped-bot-alt la-text-header la-bckg-header-anti -widthfull"><!> <!> <!></div></div>'), root_7$c = /* @__PURE__ */ template("<!> <!>", 1), root_10$8 = /* @__PURE__ */ template('<span class="la-combine-h -justifycenter -aligncenter -fontsize3 -height1"> <i class="cci cci-reticule -fontsize2"></i></span>'), root_11$6 = /* @__PURE__ */ template('<span class="la-combine-h -justifycenter -aligncenter -fontsize3 -height1"> <i class="cci cci-accuracy -fontsize4"></i></span>'), root_9$8 = /* @__PURE__ */ template('<div class="la-combine-h -gap0 -widthfull"><!> <!></div>'), root_8$4 = /* @__PURE__ */ template("<!> <!> <!> <!>", 1), root_3$f = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull"></div>');
function Systems($$anchor, $$props) {
  push($$props, !0);
  const headerOptions = /* @__PURE__ */ __name(($$anchor2) => {
    const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
    CollapseAllButton($$anchor2, {
      collapseID: collID,
      tooltipEnabled,
      get tooltipTheme() {
        return get$1(expression);
      },
      onPointerEnter: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !0);
      }, "onPointerEnter"),
      onPointerLeave: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !1);
      }, "onPointerLeave")
    });
  }, "headerOptions");
  let collapseAllButtonHover = state(!1), effectButtonHover = state(!1), editButtonHover = state(!1), messageButtonHover = state(!1);
  const tooltipEnabled = getNPCSheetTooltipEnabled(), tier = $$props.system.tier, collID = `${$$props.actor.uuid}.systems`;
  function renderOuter(component) {
    return !isDestroyed(component) && (isLoading(component) || isRecharge(component) || component.system.uses.max);
  }
  __name(renderOuter, "renderOuter");
  function hasAccuracyBonus(component) {
    return component.system.accuracy.some((accuracy) => accuracy !== 0);
  }
  __name(hasAccuracyBonus, "hasAccuracyBonus");
  function hasAttackBonus(component) {
    return component.system.attack_bonus.some((bonus) => bonus !== 0);
  }
  __name(hasAttackBonus, "hasAttackBonus");
  function isDestroyed(component) {
    return component.system.destroyed;
  }
  __name(isDestroyed, "isDestroyed");
  function getHeaderStyle(component) {
    return isDestroyed(component) ? "la-text-error la-prmy-error horus--very--subtle -strikethrough" : "la-text-header la-prmy-header";
  }
  __name(getHeaderStyle, "getHeaderStyle");
  function getIconStyle(component) {
    return isDestroyed(component) ? "la-text-repcap" : "la-text-header";
  }
  __name(getIconStyle, "getIconStyle");
  var fragment_1 = comment(), node = first_child(fragment_1);
  {
    var consequent_1 = /* @__PURE__ */ __name(($$anchor2) => {
      const expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.systems.label"));
      HeaderMain($$anchor2, {
        get text() {
          return get$1(expression_1);
        },
        headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-system"],
        textStyle: [
          "la-text-header",
          "-fontsize2",
          "-overflowhidden",
          "-upper"
        ],
        borderStyle: ["la-brdr-system", "-gap0"],
        extensionTextFunction: /* @__PURE__ */ __name(() => {
          if (get$1(collapseAllButtonHover)) return `--${getLocalized("LA.collapseAll.extension")}`;
        }, "extensionTextFunction"),
        collapseID: collID,
        startCollapsed: !0,
        headerContent: headerOptions,
        children: /* @__PURE__ */ __name(($$anchor3, $$slotProps) => {
          var div = root_3$f();
          each(div, 21, () => $$props.systems, index, ($$anchor4, component) => {
            const outerContent = /* @__PURE__ */ __name(($$anchor5) => {
              var div_1 = root_5$c(), div_2 = child(div_1), node_1 = child(div_2);
              const expression_2 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(component).index}.system.charged`);
              ChargedBox(node_1, {
                get item() {
                  return get$1(component);
                },
                get path() {
                  return get$1(expression_2);
                }
              });
              var node_2 = sibling(node_1, 2);
              const expression_3 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(component).index}.system.loaded`);
              LoadedBox(node_2, {
                get item() {
                  return get$1(component);
                },
                get path() {
                  return get$1(expression_3);
                }
              });
              var node_3 = sibling(node_2, 2);
              const expression_4 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(component).index}.system.uses`);
              LimitedBox(node_3, {
                get usesValue() {
                  return get$1(component).system.uses.value;
                },
                get usesMax() {
                  return get$1(component).system.uses.max;
                },
                get path() {
                  return get$1(expression_4);
                }
              }), append($$anchor5, div_1);
            }, "outerContent"), headerSecondaryLeftOptions2 = /* @__PURE__ */ __name(($$anchor5) => {
              const expression_5 = /* @__PURE__ */ derived(() => [
                getIconStyle(get$1(component)),
                "cci",
                "cci-system",
                "-fontsize5"
              ]), expression_6 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(component).index}`), expression_7 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_8 = /* @__PURE__ */ derived(() => get$1(component).system.effect || getLocalized("LA.mech.mod.effect.tooltip")), expression_9 = /* @__PURE__ */ derived(() => isDestroyed(get$1(component)));
              EffectButton($$anchor5, {
                get iconStyle() {
                  return get$1(expression_5);
                },
                iconBackgroundStyle: [
                  "-fontsize5",
                  "la-prmy-secondary",
                  "-pulse-prmy"
                ],
                get flowClass() {
                  return FlowClass.SendEffectToChat;
                },
                get path() {
                  return get$1(expression_6);
                },
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_7);
                },
                get tooltipDirection() {
                  return TooltipDirection.UP;
                },
                get tooltip() {
                  return get$1(expression_8);
                },
                get disabled() {
                  return get$1(expression_9);
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(effectButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(effectButtonHover, !1);
                }, "onPointerLeave")
              });
            }, "headerSecondaryLeftOptions"), headerSecondaryRightOptions = /* @__PURE__ */ __name(($$anchor5) => {
              var fragment_4 = root_7$c(), node_4 = first_child(fragment_4);
              const expression_10 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(component).index}`), expression_11 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
              EditButton(node_4, {
                get flowClass() {
                  return FlowClass.ContextMenu;
                },
                get path() {
                  return get$1(expression_10);
                },
                style: [
                  HEADER_SECONDARY_STYLE,
                  "-padding0-lr"
                ],
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_11);
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !1);
                }, "onPointerLeave")
              });
              var node_5 = sibling(node_4, 2);
              const expression_12 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
              MessageButton(node_5, {
                get flowClass() {
                  return FlowClass.SendToChat;
                },
                get uuid() {
                  return get$1(component).uuid;
                },
                style: [
                  HEADER_SECONDARY_STYLE,
                  "-padding0-lr"
                ],
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_12);
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(messageButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(messageButtonHover, !1);
                }, "onPointerLeave")
              }), append($$anchor5, fragment_4);
            }, "headerSecondaryRightOptions"), expression_13 = /* @__PURE__ */ derived(() => [
              getHeaderStyle(get$1(component)),
              "-fontsize1"
            ]), expression_14 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(component).index}`), expression_15 = /* @__PURE__ */ derived(() => renderOuter(get$1(component)) ? outerContent : void 0);
            HeaderSecondary($$anchor4, {
              get text() {
                return get$1(component).name;
              },
              headerStyle: [H2_HEADER_STYLE, "la-bckg-pilot"],
              get textStyle() {
                return get$1(expression_13);
              },
              borderStyle: ["-bordersoff"],
              extensionTextFunction: /* @__PURE__ */ __name(() => {
                if (get$1(effectButtonHover)) return `--${getLocalized("LA.use.label")}`;
                if (get$1(messageButtonHover)) return `--${getLocalized("LA.chat.extension")}`;
                if (get$1(editButtonHover)) return `--${getLocalized("LA.edit.extension")}`;
              }, "extensionTextFunction"),
              get itemID() {
                return get$1(component).id;
              },
              get uuid() {
                return get$1(component).uuid;
              },
              get path() {
                return get$1(expression_14);
              },
              acceptTypes: "npc_feature",
              get collapseID() {
                return get$1(component).uuid;
              },
              startCollapsed: !0,
              get renderOutsideCollapse() {
                return get$1(expression_15);
              },
              contentLeft: headerSecondaryLeftOptions2,
              contentRight: headerSecondaryRightOptions,
              children: /* @__PURE__ */ __name(($$anchor5, $$slotProps2) => {
                var fragment_6 = root_8$4(), node_6 = first_child(fragment_6);
                {
                  var consequent = /* @__PURE__ */ __name(($$anchor6) => {
                    var div_3 = root_9$8(), node_7 = child(div_3);
                    const expression_16 = /* @__PURE__ */ derived(() => getLocalized("LA.npc.attackBonus.label")), expression_17 = /* @__PURE__ */ derived(() => [
                      `${hasAccuracyBonus(get$1(component)) ? "-bordersround" : "-bordersround-ltb"}`
                    ]);
                    EffectBox(node_7, {
                      get name() {
                        return get$1(expression_16);
                      },
                      get outerStyle() {
                        return get$1(expression_17);
                      },
                      tooltipEnabled,
                      children: /* @__PURE__ */ __name(($$anchor7, $$slotProps3) => {
                        var span = root_10$8(), text2 = child(span);
                        template_effect(() => set_text(text2, `${get$1(component).system.attack_bonus[tier - 1] ?? ""} `)), append($$anchor7, span);
                      }, "children"),
                      $$slots: { default: !0 }
                    });
                    var node_8 = sibling(node_7, 2);
                    const expression_18 = /* @__PURE__ */ derived(() => getLocalized("LA.npc.accuracy.label"));
                    EffectBox(node_8, {
                      get name() {
                        return get$1(expression_18);
                      },
                      tooltipEnabled,
                      children: /* @__PURE__ */ __name(($$anchor7, $$slotProps3) => {
                        var span_1 = root_11$6(), text_1 = child(span_1);
                        template_effect(() => set_text(text_1, `${get$1(component).system.accuracy[tier - 1] ?? ""} `)), append($$anchor7, span_1);
                      }, "children"),
                      $$slots: { default: !0 }
                    }), append($$anchor6, div_3);
                  }, "consequent");
                  if_block(node_6, ($$render) => {
                    (hasAttackBonus(get$1(component)) || hasAccuracyBonus(get$1(component))) && $$render(consequent);
                  });
                }
                var node_9 = sibling(node_6, 2);
                const expression_19 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.system.effect.label"));
                EffectBox(node_9, {
                  get name() {
                    return get$1(expression_19);
                  },
                  tooltipEnabled,
                  children: /* @__PURE__ */ __name(($$anchor6, $$slotProps3) => {
                    var fragment_7 = comment(), node_10 = first_child(fragment_7);
                    html(node_10, () => get$1(component).system.effect), append($$anchor6, fragment_7);
                  }, "children"),
                  $$slots: { default: !0 }
                });
                var node_11 = sibling(node_9, 2);
                const expression_20 = /* @__PURE__ */ derived(() => getLocalized("LA.effect.hit.label"));
                EffectBox(node_11, {
                  get name() {
                    return get$1(expression_20);
                  },
                  get effect() {
                    return get$1(component).system.on_hit;
                  },
                  tooltipEnabled
                });
                var node_12 = sibling(node_11, 2);
                const expression_21 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(component).index}.system.tags`);
                TagArray(node_12, {
                  get tags() {
                    return get$1(component).system.tags;
                  },
                  get path() {
                    return get$1(expression_21);
                  },
                  justify: "start"
                }), append($$anchor5, fragment_6);
              }, "children"),
              $$slots: { default: !0 }
            });
          }), append($$anchor3, div);
        }, "children"),
        $$slots: { default: !0 }
      });
    }, "consequent_1");
    if_block(node, ($$render) => {
      $$props.systems.length && $$render(consequent_1);
    });
  }
  append($$anchor, fragment_1), pop();
}
__name(Systems, "Systems");
var root_5$b = /* @__PURE__ */ template('<div class="-widthfull -padding2-l"><div class="la-combine-h clipped-bot-alt la-text-header la-bckg-header-anti -widthfull"><!> <!> <!></div></div>'), root_7$b = /* @__PURE__ */ template("<!> <!>", 1), root_8$3 = /* @__PURE__ */ template("<!> <!> <!>", 1), root_3$e = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull"></div>');
function Traits($$anchor, $$props) {
  push($$props, !0);
  const headerOptions = /* @__PURE__ */ __name(($$anchor2) => {
    const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
    CollapseAllButton($$anchor2, {
      collapseID: collID,
      tooltipEnabled,
      get tooltipTheme() {
        return get$1(expression);
      },
      onPointerEnter: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !0);
      }, "onPointerEnter"),
      onPointerLeave: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !1);
      }, "onPointerLeave")
    });
  }, "headerOptions");
  let collapseAllButtonHover = state(!1), effectButtonHover = state(!1), editButtonHover = state(!1), messageButtonHover = state(!1);
  const tooltipEnabled = getNPCSheetTooltipEnabled(), collID = `${$$props.actor.uuid}.traits`;
  function renderOuter(trait) {
    return !isDestroyed(trait) && (trait.system.uses.max || isLoading(trait) || isRecharge(trait));
  }
  __name(renderOuter, "renderOuter");
  function isDestroyed(trait) {
    return trait.system.destroyed;
  }
  __name(isDestroyed, "isDestroyed");
  function getHeaderStyle(reaction) {
    return isDestroyed(reaction) ? "la-text-error la-prmy-error horus--very--subtle -strikethrough" : "la-text-header la-prmy-header";
  }
  __name(getHeaderStyle, "getHeaderStyle");
  function getIconStyle(reaction) {
    return isDestroyed(reaction) ? "la-text-repcap" : "la-text-header";
  }
  __name(getIconStyle, "getIconStyle");
  var fragment_1 = comment(), node = first_child(fragment_1);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      const expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.npc.traits.label"));
      HeaderMain($$anchor2, {
        get text() {
          return get$1(expression_1);
        },
        headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-action--downtime"],
        textStyle: [
          "la-text-header",
          "-fontsize2",
          "-overflowhidden"
        ],
        borderStyle: ["la-brdr-action--downtime"],
        extensionTextFunction: /* @__PURE__ */ __name(() => {
          if (get$1(collapseAllButtonHover)) return `--${getLocalized("LA.collapseAll.extension")}`;
        }, "extensionTextFunction"),
        collapseID: collID,
        startCollapsed: !0,
        headerContent: headerOptions,
        children: /* @__PURE__ */ __name(($$anchor3, $$slotProps) => {
          var div = root_3$e();
          each(div, 21, () => $$props.traits, index, ($$anchor4, trait) => {
            const outerContent = /* @__PURE__ */ __name(($$anchor5) => {
              var div_1 = root_5$b(), div_2 = child(div_1), node_1 = child(div_2);
              const expression_2 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(trait).index}.system.charged`);
              ChargedBox(node_1, {
                get item() {
                  return get$1(trait);
                },
                get path() {
                  return get$1(expression_2);
                }
              });
              var node_2 = sibling(node_1, 2);
              const expression_3 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(trait).index}.system.loaded`);
              LoadedBox(node_2, {
                get item() {
                  return get$1(trait);
                },
                get path() {
                  return get$1(expression_3);
                }
              });
              var node_3 = sibling(node_2, 2);
              const expression_4 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(trait).index}.system.uses`);
              LimitedBox(node_3, {
                get usesValue() {
                  return get$1(trait).system.uses.value;
                },
                get usesMax() {
                  return get$1(trait).system.uses.max;
                },
                get path() {
                  return get$1(expression_4);
                }
              }), append($$anchor5, div_1);
            }, "outerContent"), headerSecondaryLeftOptions2 = /* @__PURE__ */ __name(($$anchor5) => {
              const expression_5 = /* @__PURE__ */ derived(() => [
                getIconStyle(get$1(trait)),
                "cci",
                "cci-trait",
                "-fontsize5"
              ]), expression_6 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(trait).index}`), expression_7 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_8 = /* @__PURE__ */ derived(() => get$1(trait).system.effect || getLocalized("LA.mech.mod.effect.tooltip")), expression_9 = /* @__PURE__ */ derived(() => isDestroyed(get$1(trait)));
              EffectButton($$anchor5, {
                get iconStyle() {
                  return get$1(expression_5);
                },
                iconBackgroundStyle: [
                  "-fontsize5",
                  "la-prmy-secondary",
                  "-pulse-prmy"
                ],
                get flowClass() {
                  return FlowClass.SendEffectToChat;
                },
                get path() {
                  return get$1(expression_6);
                },
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_7);
                },
                get tooltipDirection() {
                  return TooltipDirection.UP;
                },
                get tooltip() {
                  return get$1(expression_8);
                },
                get disabled() {
                  return get$1(expression_9);
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(effectButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(effectButtonHover, !1);
                }, "onPointerLeave")
              });
            }, "headerSecondaryLeftOptions"), headerSecondaryRightOptions = /* @__PURE__ */ __name(($$anchor5) => {
              var fragment_4 = root_7$b(), node_4 = first_child(fragment_4);
              const expression_10 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(trait).index}`), expression_11 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
              EditButton(node_4, {
                get flowClass() {
                  return FlowClass.ContextMenu;
                },
                get path() {
                  return get$1(expression_10);
                },
                style: [
                  HEADER_SECONDARY_STYLE,
                  "-padding0-lr"
                ],
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_11);
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !1);
                }, "onPointerLeave")
              });
              var node_5 = sibling(node_4, 2);
              const expression_12 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
              MessageButton(node_5, {
                get flowClass() {
                  return FlowClass.SendToChat;
                },
                get uuid() {
                  return get$1(trait).uuid;
                },
                style: [
                  HEADER_SECONDARY_STYLE,
                  "-padding0-lr"
                ],
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_12);
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(messageButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(messageButtonHover, !1);
                }, "onPointerLeave")
              }), append($$anchor5, fragment_4);
            }, "headerSecondaryRightOptions"), expression_13 = /* @__PURE__ */ derived(() => [
              getHeaderStyle(get$1(trait)),
              "-fontsize1",
              "-overflowhidden"
            ]), expression_14 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(trait).index}`), expression_15 = /* @__PURE__ */ derived(() => renderOuter(get$1(trait)) ? outerContent : void 0);
            HeaderSecondary($$anchor4, {
              get text() {
                return get$1(trait).name;
              },
              headerStyle: [H2_HEADER_STYLE, "la-bckg-pilot"],
              get textStyle() {
                return get$1(expression_13);
              },
              borderStyle: ["-bordersoff"],
              extensionTextFunction: /* @__PURE__ */ __name(() => {
                if (get$1(effectButtonHover)) return `--${getLocalized("LA.use.label")}`;
                if (get$1(messageButtonHover)) return `--${getLocalized("LA.chat.extension")}`;
                if (get$1(editButtonHover)) return `--${getLocalized("LA.edit.extension")}`;
              }, "extensionTextFunction"),
              get itemID() {
                return get$1(trait).lid;
              },
              get uuid() {
                return get$1(trait).uuid;
              },
              get path() {
                return get$1(expression_14);
              },
              acceptTypes: "npc_feature",
              get collapseID() {
                return get$1(trait).uuid;
              },
              startCollapsed: !0,
              get renderOutsideCollapse() {
                return get$1(expression_15);
              },
              contentLeft: headerSecondaryLeftOptions2,
              contentRight: headerSecondaryRightOptions,
              children: /* @__PURE__ */ __name(($$anchor5, $$slotProps2) => {
                var fragment_6 = root_8$3(), node_6 = first_child(fragment_6);
                const expression_16 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.system.effect.label"));
                EffectBox(node_6, {
                  get name() {
                    return get$1(expression_16);
                  },
                  tooltipEnabled,
                  children: /* @__PURE__ */ __name(($$anchor6, $$slotProps3) => {
                    var fragment_7 = comment(), node_7 = first_child(fragment_7);
                    html(node_7, () => get$1(trait).system.effect), append($$anchor6, fragment_7);
                  }, "children"),
                  $$slots: { default: !0 }
                });
                var node_8 = sibling(node_6, 2);
                const expression_17 = /* @__PURE__ */ derived(() => getLocalized("LA.effect.hit.label"));
                EffectBox(node_8, {
                  get name() {
                    return get$1(expression_17);
                  },
                  get effect() {
                    return get$1(trait).system.on_hit;
                  },
                  tooltipEnabled
                });
                var node_9 = sibling(node_8, 2);
                const expression_18 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(trait).index}.system.tags`);
                TagArray(node_9, {
                  get tags() {
                    return get$1(trait).system.tags;
                  },
                  get path() {
                    return get$1(expression_18);
                  },
                  justify: "start"
                }), append($$anchor5, fragment_6);
              }, "children"),
              $$slots: { default: !0 }
            });
          }), append($$anchor3, div);
        }, "children"),
        $$slots: { default: !0 }
      });
    }, "consequent");
    if_block(node, ($$render) => {
      $$props.traits.length && $$render(consequent);
    });
  }
  append($$anchor, fragment_1), pop();
}
__name(Traits, "Traits");
var root_5$a = /* @__PURE__ */ template('<div class="-widthfull -padding2-l"><div class="la-combine-h clipped-bot-alt la-text-header la-bckg-header-anti -widthfull -padding2-l"><!> <!> <!></div></div>'), root_7$a = /* @__PURE__ */ template("<!> <!>", 1), root_10$7 = /* @__PURE__ */ template('<span class="la-combine-h -justifycenter -aligncenter -fontsize3 -height1"> <i class="cci cci-reticule -fontsize2"></i></span>'), root_11$5 = /* @__PURE__ */ template('<span class="la-combine-h -justifycenter -aligncenter -fontsize3 -height1"> <i class="cci cci-accuracy -fontsize4"></i></span>'), root_9$7 = /* @__PURE__ */ template('<div class="la-combine-h -gap0 -widthfull"><!> <!></div>'), root_8$2 = /* @__PURE__ */ template("<!> <!> <!> <!> <!>", 1), root_3$d = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull"></div>');
function Reactions($$anchor, $$props) {
  push($$props, !0);
  const headerOptions = /* @__PURE__ */ __name(($$anchor2) => {
    const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
    CollapseAllButton($$anchor2, {
      collapseID: collID,
      tooltipEnabled,
      get tooltipTheme() {
        return get$1(expression);
      },
      onPointerEnter: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !0);
      }, "onPointerEnter"),
      onPointerLeave: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !1);
      }, "onPointerLeave")
    });
  }, "headerOptions");
  let collapseAllButtonHover = state(!1), effectButtonHover = state(!1), editButtonHover = state(!1), messageButtonHover = state(!1);
  const tooltipEnabled = getNPCSheetTooltipEnabled(), tier = $$props.system.tier, collID = `${$$props.actor.uuid}.reactions`;
  function getReactionTooltip(reaction) {
    return reaction.system.effect ? `
                ${getLocalized("LA.trigger.label")}: ${reaction.system.trigger}
                <br><br>
                ${getLocalized("LA.mech.system.effect.label")}: ${reaction.system.effect}
                <br><br>
                ${getLocalized("LA.action.reaction.tooltip")}` : getLocalized("LA.action.reaction.tooltip");
  }
  __name(getReactionTooltip, "getReactionTooltip");
  function renderOuter(reaction) {
    return !isDestroyed(reaction) && (isLoading(reaction) || isRecharge(reaction) || reaction.system.uses.max);
  }
  __name(renderOuter, "renderOuter");
  function hasAccuracyBonus(reaction) {
    return reaction.system.accuracy.some((accuracy) => accuracy !== 0);
  }
  __name(hasAccuracyBonus, "hasAccuracyBonus");
  function hasAttackBonus(reaction) {
    return reaction.system.attack_bonus.some((bonus) => bonus !== 0);
  }
  __name(hasAttackBonus, "hasAttackBonus");
  function isDestroyed(reaction) {
    return reaction.system.destroyed;
  }
  __name(isDestroyed, "isDestroyed");
  function getHeaderStyle(reaction) {
    return isDestroyed(reaction) ? "la-text-error la-prmy-error horus--very--subtle -strikethrough" : "la-text-header la-prmy-header";
  }
  __name(getHeaderStyle, "getHeaderStyle");
  function getIconStyle(reaction) {
    return isDestroyed(reaction) ? "la-text-repcap" : "la-text-header";
  }
  __name(getIconStyle, "getIconStyle");
  function sendToChat(event2, reaction) {
    if (event2.preventDefault(), $$props.actor && reaction) {
      let chatData = {
        title: reaction.name,
        trigger: reaction.system.trigger,
        effect: reaction.system.effect,
        tags: reaction.system.tags,
        color: "lancer-reaction"
      };
      SendUnknownToChatBase.getInstance().startFlow($$props.actor.uuid, chatData);
    }
  }
  __name(sendToChat, "sendToChat");
  var fragment_1 = comment(), node = first_child(fragment_1);
  {
    var consequent_1 = /* @__PURE__ */ __name(($$anchor2) => {
      const expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.npc.reactions.label"));
      HeaderMain($$anchor2, {
        get text() {
          return get$1(expression_1);
        },
        headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-action--reaction"],
        textStyle: [
          "la-text-header",
          "-fontsize2",
          "-overflowhidden"
        ],
        borderStyle: ["la-brdr-action--reaction", "-gap0"],
        extensionTextFunction: /* @__PURE__ */ __name(() => {
          if (get$1(collapseAllButtonHover)) return `--${getLocalized("LA.collapseAll.extension")}`;
        }, "extensionTextFunction"),
        collapseID: collID,
        startCollapsed: !0,
        headerContent: headerOptions,
        children: /* @__PURE__ */ __name(($$anchor3, $$slotProps) => {
          var div = root_3$d();
          each(div, 21, () => $$props.reactions, index, ($$anchor4, reaction) => {
            const outerContent = /* @__PURE__ */ __name(($$anchor5) => {
              var div_1 = root_5$a(), div_2 = child(div_1), node_1 = child(div_2);
              const expression_2 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(reaction).index}.system.charged`);
              ChargedBox(node_1, {
                get item() {
                  return get$1(reaction);
                },
                get path() {
                  return get$1(expression_2);
                }
              });
              var node_2 = sibling(node_1, 2);
              const expression_3 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(reaction).index}.system.loaded`);
              LoadedBox(node_2, {
                get item() {
                  return get$1(reaction);
                },
                get path() {
                  return get$1(expression_3);
                }
              });
              var node_3 = sibling(node_2, 2);
              const expression_4 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(reaction).index}.system.uses`);
              LimitedBox(node_3, {
                get usesValue() {
                  return get$1(reaction).system.uses.value;
                },
                get usesMax() {
                  return get$1(reaction).system.uses.max;
                },
                get path() {
                  return get$1(expression_4);
                }
              }), append($$anchor5, div_1);
            }, "outerContent"), headerSecondaryLeftOptions2 = /* @__PURE__ */ __name(($$anchor5) => {
              const expression_5 = /* @__PURE__ */ derived(() => [
                getIconStyle(get$1(reaction)),
                "cci",
                "cci-reaction",
                "-fontsize5"
              ]), expression_6 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(reaction).index}`), expression_7 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_8 = /* @__PURE__ */ derived(() => getLocalized("LA.action.reaction.label")), expression_9 = /* @__PURE__ */ derived(() => getReactionTooltip(get$1(reaction))), expression_10 = /* @__PURE__ */ derived(() => isDestroyed(get$1(reaction)));
              EffectButton($$anchor5, {
                get iconStyle() {
                  return get$1(expression_5);
                },
                iconBackgroundStyle: [
                  "-fontsize5",
                  "la-prmy-secondary",
                  "-pulse-prmy"
                ],
                get flowClass() {
                  return FlowClass.SendEffectToChat;
                },
                get path() {
                  return get$1(expression_6);
                },
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_7);
                },
                get tooltipDirection() {
                  return TooltipDirection.UP;
                },
                get tooltipHeader() {
                  return get$1(expression_8);
                },
                get tooltip() {
                  return get$1(expression_9);
                },
                get disabled() {
                  return get$1(expression_10);
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(effectButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(effectButtonHover, !1);
                }, "onPointerLeave")
              });
            }, "headerSecondaryLeftOptions"), headerSecondaryRightOptions = /* @__PURE__ */ __name(($$anchor5) => {
              var fragment_4 = root_7$a(), node_4 = first_child(fragment_4);
              const expression_11 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(reaction).index}`), expression_12 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
              EditButton(node_4, {
                get flowClass() {
                  return FlowClass.ContextMenu;
                },
                get path() {
                  return get$1(expression_11);
                },
                style: [
                  HEADER_SECONDARY_STYLE,
                  "-padding0-lr"
                ],
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_12);
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !1);
                }, "onPointerLeave")
              });
              var node_5 = sibling(node_4, 2);
              const expression_13 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
              MessageButton(node_5, {
                get flowClass() {
                  return FlowClass.None;
                },
                get uuid() {
                  return get$1(reaction).uuid;
                },
                style: [
                  HEADER_SECONDARY_STYLE,
                  "-padding0-lr"
                ],
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_13);
                },
                onClick: /* @__PURE__ */ __name((event2) => sendToChat(event2, get$1(reaction)), "onClick"),
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(messageButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(messageButtonHover, !1);
                }, "onPointerLeave")
              }), append($$anchor5, fragment_4);
            }, "headerSecondaryRightOptions"), expression_14 = /* @__PURE__ */ derived(() => [
              getHeaderStyle(get$1(reaction)),
              "-fontsize1"
            ]), expression_15 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(reaction).index}`), expression_16 = /* @__PURE__ */ derived(() => renderOuter(get$1(reaction)) ? outerContent : void 0);
            HeaderSecondary($$anchor4, {
              get text() {
                return get$1(reaction).name;
              },
              headerStyle: [H2_HEADER_STYLE, "la-bckg-pilot"],
              get textStyle() {
                return get$1(expression_14);
              },
              borderStyle: ["-bordersoff"],
              extensionTextFunction: /* @__PURE__ */ __name(() => {
                if (get$1(effectButtonHover)) return `--${getLocalized("LA.use.label")}`;
                if (get$1(messageButtonHover)) return `--${getLocalized("LA.chat.extension")}`;
                if (get$1(editButtonHover)) return `--${getLocalized("LA.edit.extension")}`;
              }, "extensionTextFunction"),
              get itemID() {
                return get$1(reaction).id;
              },
              get uuid() {
                return get$1(reaction).uuid;
              },
              get path() {
                return get$1(expression_15);
              },
              acceptTypes: "npc_feature",
              get collapseID() {
                return get$1(reaction).uuid;
              },
              startCollapsed: !0,
              get renderOutsideCollapse() {
                return get$1(expression_16);
              },
              contentLeft: headerSecondaryLeftOptions2,
              contentRight: headerSecondaryRightOptions,
              children: /* @__PURE__ */ __name(($$anchor5, $$slotProps2) => {
                var fragment_6 = root_8$2(), node_6 = first_child(fragment_6);
                {
                  var consequent = /* @__PURE__ */ __name(($$anchor6) => {
                    var div_3 = root_9$7(), node_7 = child(div_3);
                    const expression_17 = /* @__PURE__ */ derived(() => getLocalized("LA.npc.attackBonus.label")), expression_18 = /* @__PURE__ */ derived(() => [
                      `${hasAccuracyBonus(get$1(reaction)) ? "-bordersround" : "-bordersround-ltb"}`
                    ]);
                    EffectBox(node_7, {
                      get name() {
                        return get$1(expression_17);
                      },
                      get outerStyle() {
                        return get$1(expression_18);
                      },
                      tooltipEnabled,
                      children: /* @__PURE__ */ __name(($$anchor7, $$slotProps3) => {
                        var span = root_10$7(), text2 = child(span);
                        template_effect(() => set_text(text2, `${get$1(reaction).system.attack_bonus[tier - 1] ?? ""} `)), append($$anchor7, span);
                      }, "children"),
                      $$slots: { default: !0 }
                    });
                    var node_8 = sibling(node_7, 2);
                    const expression_19 = /* @__PURE__ */ derived(() => getLocalized("LA.npc.accuracy.label"));
                    EffectBox(node_8, {
                      get name() {
                        return get$1(expression_19);
                      },
                      tooltipEnabled,
                      children: /* @__PURE__ */ __name(($$anchor7, $$slotProps3) => {
                        var span_1 = root_11$5(), text_1 = child(span_1);
                        template_effect(() => set_text(text_1, `${get$1(reaction).system.accuracy[tier - 1] ?? ""} `)), append($$anchor7, span_1);
                      }, "children"),
                      $$slots: { default: !0 }
                    }), append($$anchor6, div_3);
                  }, "consequent");
                  if_block(node_6, ($$render) => {
                    (hasAttackBonus(get$1(reaction)) || hasAccuracyBonus(get$1(reaction))) && $$render(consequent);
                  });
                }
                var node_9 = sibling(node_6, 2);
                const expression_20 = /* @__PURE__ */ derived(() => getLocalized("LA.trigger.label"));
                EffectBox(node_9, {
                  get name() {
                    return get$1(expression_20);
                  },
                  tooltipEnabled,
                  children: /* @__PURE__ */ __name(($$anchor6, $$slotProps3) => {
                    var fragment_7 = comment(), node_10 = first_child(fragment_7);
                    html(node_10, () => get$1(reaction).system.trigger), append($$anchor6, fragment_7);
                  }, "children"),
                  $$slots: { default: !0 }
                });
                var node_11 = sibling(node_9, 2);
                const expression_21 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.system.effect.label"));
                EffectBox(node_11, {
                  get name() {
                    return get$1(expression_21);
                  },
                  get effect() {
                    return get$1(reaction).system.effect;
                  },
                  tooltipEnabled
                });
                var node_12 = sibling(node_11, 2);
                const expression_22 = /* @__PURE__ */ derived(() => getLocalized("LA.effect.hit.label"));
                EffectBox(node_12, {
                  get name() {
                    return get$1(expression_22);
                  },
                  get effect() {
                    return get$1(reaction).system.on_hit;
                  },
                  tooltipEnabled
                });
                var node_13 = sibling(node_12, 2);
                const expression_23 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(reaction).index}.system.tags`);
                TagArray(node_13, {
                  get tags() {
                    return get$1(reaction).system.tags;
                  },
                  get path() {
                    return get$1(expression_23);
                  },
                  justify: "start"
                }), append($$anchor5, fragment_6);
              }, "children"),
              $$slots: { default: !0 }
            });
          }), append($$anchor3, div);
        }, "children"),
        $$slots: { default: !0 }
      });
    }, "consequent_1");
    if_block(node, ($$render) => {
      $$props.reactions.length && $$render(consequent_1);
    });
  }
  append($$anchor, fragment_1), pop();
}
__name(Reactions, "Reactions");
var root_6$f = /* @__PURE__ */ template('<span class="la-combine-h -justifycenter -aligncenter -fontsize3 -padding0-lr"> <i class="cci cci-accuracy -fontsize4"></i></span>'), root_7$9 = /* @__PURE__ */ template('<span class="la-combine-h -justifycenter -aligncenter -fontsize3 -padding0-lr"> <i class="cci cci-reticule -fontsize2"></i></span>'), root_5$9 = /* @__PURE__ */ template('<div class="-widthfull -padding2-l"><div class="la-combine-h clipped-bot-alt la-text-header la-bckg-header-anti -widthfull"><!> <!> <!> <!> <!></div></div>'), root_9$6 = /* @__PURE__ */ template("<!> <!>", 1), root_10$6 = /* @__PURE__ */ template("<!> <!> <!>", 1), root_3$c = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull"></div>');
function TechAttack($$anchor, $$props) {
  push($$props, !0);
  const headerOptions = /* @__PURE__ */ __name(($$anchor2) => {
    const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
    CollapseAllButton($$anchor2, {
      collapseID: collID,
      tooltipEnabled,
      get tooltipTheme() {
        return get$1(expression);
      },
      onPointerEnter: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !0);
      }, "onPointerEnter"),
      onPointerLeave: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !1);
      }, "onPointerLeave")
    });
  }, "headerOptions");
  let collapseAllButtonHover = state(!1), effectButtonHover = state(!1), editButtonHover = state(!1), messageButtonHover = state(!1);
  const tooltipEnabled = getNPCSheetTooltipEnabled(), tier = $$props.system.tier, collID = `${$$props.actor.uuid}.techs`, accuracyTip = TooltipFactory.buildTooltip(getLocalized("LA.npc.accuracy.tooltip")), attackTip = TooltipFactory.buildTooltip(getLocalized("LA.npc.attackBonus.tooltip"));
  function getTechIcon(tech) {
    return tech.system.tech_type === "Full" ? "cci-tech-full" : "cci-tech-quick";
  }
  __name(getTechIcon, "getTechIcon");
  function getTechTipHeader(tech) {
    return tech.system.tech_type === "Full" ? getLocalized("LA.action.fullTech.label") : getLocalized("LA.action.quickTech.label");
  }
  __name(getTechTipHeader, "getTechTipHeader");
  function renderOuter(tech) {
    return !isDestroyed(tech) && (hasAccuracyBonus(tech) || hasAttackBonus(tech) || isLoading(tech) || isRecharge(tech) || tech.system.uses.max);
  }
  __name(renderOuter, "renderOuter");
  function hasAccuracyBonus(tech) {
    return tech.system.accuracy.some((accuracy) => accuracy !== 0);
  }
  __name(hasAccuracyBonus, "hasAccuracyBonus");
  function hasAttackBonus(tech) {
    return tech.system.attack_bonus.some((bonus) => bonus !== 0);
  }
  __name(hasAttackBonus, "hasAttackBonus");
  function isDestroyed(tech) {
    return tech.system.destroyed;
  }
  __name(isDestroyed, "isDestroyed");
  function getHeaderStyle(tech) {
    return isDestroyed(tech) ? "la-text-error la-prmy-error horus--very--subtle -strikethrough" : "la-text-header la-prmy-header";
  }
  __name(getHeaderStyle, "getHeaderStyle");
  function getIconStyle(tech) {
    return isDestroyed(tech) ? "la-text-repcap" : "la-text-header";
  }
  __name(getIconStyle, "getIconStyle");
  var fragment_1 = comment(), node = first_child(fragment_1);
  {
    var consequent_2 = /* @__PURE__ */ __name(($$anchor2) => {
      const expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.npc.techAttacks.label"));
      HeaderMain($$anchor2, {
        get text() {
          return get$1(expression_1);
        },
        headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-action--tech"],
        textStyle: [
          "la-text-header",
          "-fontsize2",
          "-overflowhidden"
        ],
        borderStyle: ["la-brdr-action--tech", "-gap0"],
        extensionTextFunction: /* @__PURE__ */ __name(() => {
          if (get$1(collapseAllButtonHover)) return `--${getLocalized("LA.collapseAll.extension")}`;
        }, "extensionTextFunction"),
        collapseID: collID,
        startCollapsed: !0,
        headerContent: headerOptions,
        children: /* @__PURE__ */ __name(($$anchor3, $$slotProps) => {
          var div = root_3$c();
          each(div, 21, () => $$props.techs, index, ($$anchor4, tech) => {
            const outerContent = /* @__PURE__ */ __name(($$anchor5) => {
              var div_1 = root_5$9(), div_2 = child(div_1), node_1 = child(div_2);
              {
                var consequent = /* @__PURE__ */ __name(($$anchor6) => {
                  var span = root_6$f();
                  set_attribute(span, "data-tooltip", accuracyTip), set_attribute(span, "data-tooltip-direction", "DOWN");
                  var text2 = child(span);
                  template_effect(
                    ($0) => {
                      set_attribute(span, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_text(text2, `${get$1(tech).system.accuracy[tier - 1] ?? ""} `);
                    },
                    [
                      () => getCSSDocumentTheme($$props.actor.uuid)
                    ]
                  ), append($$anchor6, span);
                }, "consequent");
                if_block(node_1, ($$render) => {
                  hasAccuracyBonus(get$1(tech)) && $$render(consequent);
                });
              }
              var node_2 = sibling(node_1, 2);
              {
                var consequent_1 = /* @__PURE__ */ __name(($$anchor6) => {
                  var span_1 = root_7$9();
                  set_attribute(span_1, "data-tooltip", attackTip), set_attribute(span_1, "data-tooltip-direction", "DOWN");
                  var text_1 = child(span_1);
                  template_effect(
                    ($0) => {
                      set_attribute(span_1, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_text(text_1, `${get$1(tech).system.attack_bonus[tier - 1] ?? ""} `);
                    },
                    [
                      () => getCSSDocumentTheme($$props.actor.uuid)
                    ]
                  ), append($$anchor6, span_1);
                }, "consequent_1");
                if_block(node_2, ($$render) => {
                  hasAttackBonus(get$1(tech)) && $$render(consequent_1);
                });
              }
              var node_3 = sibling(node_2, 2);
              const expression_2 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(tech).index}.system.charged`);
              ChargedBox(node_3, {
                get item() {
                  return get$1(tech);
                },
                get path() {
                  return get$1(expression_2);
                }
              });
              var node_4 = sibling(node_3, 2);
              const expression_3 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(tech).index}.system.loaded`);
              LoadedBox(node_4, {
                get item() {
                  return get$1(tech);
                },
                get path() {
                  return get$1(expression_3);
                }
              });
              var node_5 = sibling(node_4, 2);
              const expression_4 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(tech).index}.system.uses`);
              LimitedBox(node_5, {
                get usesValue() {
                  return get$1(tech).system.uses.value;
                },
                get usesMax() {
                  return get$1(tech).system.uses.max;
                },
                get path() {
                  return get$1(expression_4);
                }
              }), append($$anchor5, div_1);
            }, "outerContent"), headerSecondaryLeftOptions2 = /* @__PURE__ */ __name(($$anchor5) => {
              const expression_5 = /* @__PURE__ */ derived(() => [
                getIconStyle(get$1(tech)),
                "cci",
                getTechIcon(get$1(tech)),
                "-fontsize5"
              ]), expression_6 = /* @__PURE__ */ derived(() => get$1(tech).system.attack_bonus.every((bonus) => bonus === 0) ? FlowClass.SendEffectToChat : FlowClass.RollTech), expression_7 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(tech).index}`), expression_8 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_9 = /* @__PURE__ */ derived(() => getTechTipHeader(get$1(tech))), expression_10 = /* @__PURE__ */ derived(() => get$1(tech).system.effect || getLocalized("LA.mech.mod.effect.tooltip")), expression_11 = /* @__PURE__ */ derived(() => isDestroyed(get$1(tech)));
              EffectButton($$anchor5, {
                get iconStyle() {
                  return get$1(expression_5);
                },
                iconBackgroundStyle: [
                  "-fontsize5",
                  "la-prmy-secondary",
                  "-pulse-prmy"
                ],
                get flowClass() {
                  return get$1(expression_6);
                },
                get path() {
                  return get$1(expression_7);
                },
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_8);
                },
                get tooltipDirection() {
                  return TooltipDirection.UP;
                },
                get tooltipHeader() {
                  return get$1(expression_9);
                },
                get tooltip() {
                  return get$1(expression_10);
                },
                get disabled() {
                  return get$1(expression_11);
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(effectButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(effectButtonHover, !1);
                }, "onPointerLeave")
              });
            }, "headerSecondaryLeftOptions"), headerSecondaryRightOptions = /* @__PURE__ */ __name(($$anchor5) => {
              var fragment_4 = root_9$6(), node_6 = first_child(fragment_4);
              const expression_12 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(tech).index}`), expression_13 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
              EditButton(node_6, {
                get flowClass() {
                  return FlowClass.ContextMenu;
                },
                get path() {
                  return get$1(expression_12);
                },
                style: [
                  HEADER_SECONDARY_STYLE,
                  "-padding0-lr"
                ],
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_13);
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !1);
                }, "onPointerLeave")
              });
              var node_7 = sibling(node_6, 2);
              const expression_14 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
              MessageButton(node_7, {
                get flowClass() {
                  return FlowClass.SendToChat;
                },
                get uuid() {
                  return get$1(tech).uuid;
                },
                style: [
                  HEADER_SECONDARY_STYLE,
                  "-padding0-lr"
                ],
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_14);
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(messageButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(messageButtonHover, !1);
                }, "onPointerLeave")
              }), append($$anchor5, fragment_4);
            }, "headerSecondaryRightOptions"), expression_15 = /* @__PURE__ */ derived(() => [
              getHeaderStyle(get$1(tech)),
              "-fontsize1"
            ]), expression_16 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(tech).index}`), expression_17 = /* @__PURE__ */ derived(() => renderOuter(get$1(tech)) ? outerContent : void 0);
            HeaderSecondary($$anchor4, {
              get text() {
                return get$1(tech).name;
              },
              headerStyle: [H2_HEADER_STYLE, "la-bckg-pilot"],
              get textStyle() {
                return get$1(expression_15);
              },
              borderStyle: ["-bordersoff"],
              extensionTextFunction: /* @__PURE__ */ __name(() => {
                if (get$1(effectButtonHover)) return `--${getLocalized("LA.use.label")}`;
                if (get$1(messageButtonHover)) return `--${getLocalized("LA.chat.extension")}`;
                if (get$1(editButtonHover)) return `--${getLocalized("LA.edit.extension")}`;
              }, "extensionTextFunction"),
              get itemID() {
                return get$1(tech).id;
              },
              get uuid() {
                return get$1(tech).uuid;
              },
              get path() {
                return get$1(expression_16);
              },
              acceptTypes: "npc_feature",
              get collapseID() {
                return get$1(tech).uuid;
              },
              startCollapsed: !0,
              get renderOutsideCollapse() {
                return get$1(expression_17);
              },
              contentLeft: headerSecondaryLeftOptions2,
              contentRight: headerSecondaryRightOptions,
              children: /* @__PURE__ */ __name(($$anchor5, $$slotProps2) => {
                var fragment_6 = root_10$6(), node_8 = first_child(fragment_6);
                const expression_18 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.system.effect.label"));
                EffectBox(node_8, {
                  get name() {
                    return get$1(expression_18);
                  },
                  tooltipEnabled,
                  children: /* @__PURE__ */ __name(($$anchor6, $$slotProps3) => {
                    var fragment_7 = comment(), node_9 = first_child(fragment_7);
                    html(node_9, () => get$1(tech).system.effect), append($$anchor6, fragment_7);
                  }, "children"),
                  $$slots: { default: !0 }
                });
                var node_10 = sibling(node_8, 2);
                const expression_19 = /* @__PURE__ */ derived(() => getLocalized("LA.effect.hit.label"));
                EffectBox(node_10, {
                  get name() {
                    return get$1(expression_19);
                  },
                  get effect() {
                    return get$1(tech).system.on_hit;
                  },
                  tooltipEnabled
                });
                var node_11 = sibling(node_10, 2);
                const expression_20 = /* @__PURE__ */ derived(() => `itemTypes.npc_feature.${get$1(tech).index}.system.tags`);
                TagArray(node_11, {
                  get tags() {
                    return get$1(tech).system.tags;
                  },
                  get path() {
                    return get$1(expression_20);
                  },
                  justify: "start"
                }), append($$anchor5, fragment_6);
              }, "children"),
              $$slots: { default: !0 }
            });
          }), append($$anchor3, div);
        }, "children"),
        $$slots: { default: !0 }
      });
    }, "consequent_2");
    if_block(node, ($$render) => {
      $$props.techs.length && $$render(consequent_2);
    });
  }
  append($$anchor, fragment_1), pop();
}
__name(TechAttack, "TechAttack");
var root_2$6 = /* @__PURE__ */ template('<div class="la-combine-v -widthfull"><!> <!> <!> <!> <!></div>'), root$m = /* @__PURE__ */ template("<!> <!>", 1);
function Loadout($$anchor, $$props) {
  push($$props, !0);
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { system, itemTypes } = props, traits = [], systems = [], reactions = [], weapons = [], techs = [];
  itemTypes.npc_feature.forEach((feature, index2) => {
    switch (feature.index = index2, feature.system.type) {
      case "Trait":
        traits.push(feature);
        break;
      case "System":
        systems.push(feature);
        break;
      case "Reaction":
        reactions.push(feature);
        break;
      case "Weapon":
        weapons.push(feature);
        break;
      case "Tech":
        techs.push(feature);
        break;
    }
  });
  var fragment = root$m(), node = first_child(fragment);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      const expression = /* @__PURE__ */ derived(() => getLocalized("LA.npc.empty.label")), expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.npc.empty.subLabel"));
      EmptyBox($$anchor2, {
        get label() {
          return get$1(expression);
        },
        get subLabel() {
          return get$1(expression_1);
        }
      });
    }, "consequent");
    if_block(node, ($$render) => {
      system.class || $$render(consequent);
    });
  }
  var node_1 = sibling(node, 2);
  {
    var consequent_1 = /* @__PURE__ */ __name(($$anchor2) => {
      var div = root_2$6(), node_2 = child(div);
      Weapons(node_2, spread_props({ weapons }, () => props));
      var node_3 = sibling(node_2, 2);
      TechAttack(node_3, spread_props({ techs }, () => props));
      var node_4 = sibling(node_3, 2);
      Reactions(node_4, spread_props({ reactions }, () => props));
      var node_5 = sibling(node_4, 2);
      Systems(node_5, spread_props({ systems }, () => props));
      var node_6 = sibling(node_5, 2);
      Traits(node_6, spread_props({ traits }, () => props)), append($$anchor2, div);
    }, "consequent_1");
    if_block(node_1, ($$render) => {
      itemTypes.npc_feature.length && $$render(consequent_1);
    });
  }
  append($$anchor, fragment), pop();
}
__name(Loadout, "Loadout");
var root$l = /* @__PURE__ */ template(`<div class="
        click-open ref set"><span class="-upper -fontsize2"> </span> <button type="button" class="fas fa-edit -fontsize0 -positionabsolute
            lancer-context-menu"></button></div>`);
function Template($$anchor, $$props) {
  push($$props, !0);
  var div = root$l(), span = child(div), text2 = child(span), button = sibling(span, 2);
  template_effect(
    ($0) => {
      set_attribute(div, "data-uuid", $$props.uuid), set_text(text2, $$props.name), set_attribute(button, "data-path", $$props.path), set_attribute(button, "aria-label", $0);
    },
    [() => getLocalized("LA.edit.label")]
  ), append($$anchor, div), pop();
}
__name(Template, "Template");
var root$k = /* @__PURE__ */ template('<div class="la-haseposition -positionrelative"><div class="la-hasegroup -positionabsolute -widthnone"><div class="la-hase la-combine-v -justifybetween -heightnone"><div class="la-combine-h -aligncenter"><!></div> <div class="la-combine-h -aligncenter -pointerdisable"><div class="-agi">&nbsp;</div> <!></div> <div class="la-combine-h -aligncenter"><!></div> <div class="la-combine-h -aligncenter -pointerdisable"><div class="-eng">&nbsp;</div> <!></div></div></div></div>');
function HaseDisplay($$anchor, $$props) {
  push($$props, !0);
  const tooltipEnabled = getNPCSheetTooltipEnabled();
  var div = root$k(), div_1 = child(div), div_2 = child(div_1), div_3 = child(div_2), node = child(div_3);
  const expression = /* @__PURE__ */ derived(() => getLocalized("LA.hull.short")), expression_1 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_2 = /* @__PURE__ */ derived(() => getLocalized("LA.hull.tooltip")), expression_3 = /* @__PURE__ */ derived(() => getLocalized("LA.hull.tooltip"));
  HexButton(node, {
    get text() {
      return get$1(expression);
    },
    get value() {
      return $$props.system.hull;
    },
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_1);
    },
    get tooltip() {
      return get$1(expression_2);
    },
    get logText() {
      return get$1(expression_3);
    },
    get logType() {
      return TextLogHook.MechHeader;
    },
    get logTypeReset() {
      return TextLogHook.MechHeaderReset;
    },
    get uuid() {
      return $$props.actor.uuid;
    },
    get flowClass() {
      return FlowClass.RollStat;
    },
    path: "system.hull",
    outerStyle: ["-hull"],
    innerStyle: [
      "la-text-header",
      "-positionabsolute",
      "-divider",
      "-thickness1",
      "la-prmy-header"
    ],
    buttonStyle: [
      "-widthfull",
      "-heightfull",
      "-positionabsolute",
      "la-prmy-primary -glow-prmy-hover"
    ],
    outerTextStyle: ["-widthfull", "-textaligncenter"],
    innerTextStyle: [
      "-fontsize3",
      "-lineheight10",
      "la-prmy-header -glow-prmy"
    ]
  });
  var div_4 = sibling(div_3, 2), node_1 = sibling(child(div_4), 2);
  const expression_4 = /* @__PURE__ */ derived(() => getLocalized("LA.agility.short")), expression_5 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_6 = /* @__PURE__ */ derived(() => getLocalized("LA.agility.tooltip")), expression_7 = /* @__PURE__ */ derived(() => getLocalized("LA.agility.tooltip"));
  HexButton(node_1, {
    get text() {
      return get$1(expression_4);
    },
    get value() {
      return $$props.system.agi;
    },
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_5);
    },
    get tooltip() {
      return get$1(expression_6);
    },
    get logText() {
      return get$1(expression_7);
    },
    get logType() {
      return TextLogHook.MechHeader;
    },
    get logTypeReset() {
      return TextLogHook.MechHeaderReset;
    },
    get uuid() {
      return $$props.actor.uuid;
    },
    get flowClass() {
      return FlowClass.RollStat;
    },
    path: "system.agi",
    outerStyle: ["-agi"],
    innerStyle: [
      "la-text-header",
      "-positionabsolute",
      "-divider",
      "-thickness1",
      "la-prmy-header"
    ],
    buttonStyle: [
      "-widthfull",
      "-heightfull",
      "-positionabsolute",
      "la-prmy-primary -glow-prmy-hover"
    ],
    outerTextStyle: ["-widthfull", "-textaligncenter"],
    innerTextStyle: [
      "-fontsize3",
      "-lineheight10",
      "la-prmy-header -glow-prmy"
    ]
  });
  var div_5 = sibling(div_4, 2), node_2 = child(div_5);
  const expression_8 = /* @__PURE__ */ derived(() => getLocalized("LA.systems.short")), expression_9 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_10 = /* @__PURE__ */ derived(() => getLocalized("LA.systems.tooltip")), expression_11 = /* @__PURE__ */ derived(() => getLocalized("LA.systems.tooltip"));
  HexButton(node_2, {
    get text() {
      return get$1(expression_8);
    },
    get value() {
      return $$props.system.sys;
    },
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_9);
    },
    get tooltip() {
      return get$1(expression_10);
    },
    get logText() {
      return get$1(expression_11);
    },
    get logType() {
      return TextLogHook.MechHeader;
    },
    get logTypeReset() {
      return TextLogHook.MechHeaderReset;
    },
    get uuid() {
      return $$props.actor.uuid;
    },
    get flowClass() {
      return FlowClass.RollStat;
    },
    path: "system.sys",
    outerStyle: ["-sys"],
    innerStyle: [
      "la-text-header",
      "-positionabsolute",
      "-divider",
      "-thickness1",
      "la-prmy-header"
    ],
    buttonStyle: [
      "-widthfull",
      "-heightfull",
      "-positionabsolute",
      "la-prmy-primary -glow-prmy-hover"
    ],
    outerTextStyle: ["-widthfull", "-textaligncenter"],
    innerTextStyle: [
      "-fontsize3",
      "-lineheight10",
      "la-prmy-header -glow-prmy"
    ]
  });
  var div_6 = sibling(div_5, 2), node_3 = sibling(child(div_6), 2);
  const expression_12 = /* @__PURE__ */ derived(() => getLocalized("LA.engineering.short")), expression_13 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_14 = /* @__PURE__ */ derived(() => getLocalized("LA.engineering.tooltip")), expression_15 = /* @__PURE__ */ derived(() => getLocalized("LA.engineering.tooltip"));
  HexButton(node_3, {
    get text() {
      return get$1(expression_12);
    },
    get value() {
      return $$props.system.eng;
    },
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_13);
    },
    get tooltip() {
      return get$1(expression_14);
    },
    get logText() {
      return get$1(expression_15);
    },
    get logType() {
      return TextLogHook.MechHeader;
    },
    get logTypeReset() {
      return TextLogHook.MechHeaderReset;
    },
    get uuid() {
      return $$props.actor.uuid;
    },
    get flowClass() {
      return FlowClass.RollStat;
    },
    path: "system.eng",
    outerStyle: ["-eng"],
    innerStyle: [
      "la-text-header",
      "-positionabsolute",
      "-divider",
      "-thickness1",
      "la-prmy-header"
    ],
    buttonStyle: [
      "-widthfull",
      "-heightfull",
      "-positionabsolute",
      "la-prmy-primary -glow-prmy-hover"
    ],
    outerTextStyle: ["-widthfull", "-textaligncenter"],
    innerTextStyle: [
      "-fontsize3",
      "-lineheight10",
      "la-prmy-header -glow-prmy"
    ]
  }), append($$anchor, div), pop();
}
__name(HaseDisplay, "HaseDisplay");
var root_1$8 = /* @__PURE__ */ template("<i></i>"), root_2$5 = /* @__PURE__ */ template("<i></i>"), root_6$e = /* @__PURE__ */ template('<i class="mdi mdi-creation la-text-text -fontsize2 la-prmy-warning -glow-prmy"></i>'), on_click = /* @__PURE__ */ __name((event2, handleShowNotes) => handleShowNotes(event2), "on_click"), on_change$3 = /* @__PURE__ */ __name((event2, system) => handleRelativeDataInput(event2, system.overshield.value), "on_change$3"), on_change_1$2 = /* @__PURE__ */ __name((event2, system) => handleRelativeDataInput(event2, system.burn), "on_change_1$2"), root$j = /* @__PURE__ */ template(`<div class="la-bg-scroll la-bckg-background la-shadow -medium -inset -widthfull -heightfull"><div class="la-combine-h la-dropshadow -justifyevenly"><div class="la-combine-v -gap1"><div class="la-combine-h -height2 "><div><button type="button" class="la-bckg-secondary -width2
                            clicker-minus-button input-update">-</button><input class="-height2 la-shadow -medium -inset la-text-text
                            lancer-stat minor"><button type="button" class="la-bckg-secondary -width2
                            clicker-plus-button input-update">+</button></div></div> <div class="la-combine-h -widthfull -heightfull"><div class="la-stat__island -positionrelative la-dropshadow"><div class="la-combine-v -positionabsolute -top0 -left0 -fontsize9"><i></i> <!> <div class="la-combine-h"><i></i> <span> </span></div> <div class="la-combine-h -aligncenter"><i></i> <span> </span></div> <div class="la-recharge -lineheight3 -width6 -height6 la-prmy-primary -glow-prmy-hover"><button type="button" class="mdi mdi-refresh-circle la-text-secondary -fontsize6
                                    charge-macro"></button></div></div></div> <div class="la-npc__img -aligncontentcenter
                        ref set"><!></div> <!></div></div> <div class="la-combine-h -padding1-r"><div class="la-combine-v -gap1"><div class="la-combine-h -height2 -justifybetween -widthfull"><div class="la-combine-h -gap1"><!> <!> <!> <!></div> <div class="la-combine-h -gap1"><button type="button"></button> <button type="button" class="mdi mdi-information -fontsize2 la-prmy-primary -glow-prmy-hover"></button></div></div> <div class="-flex1"><div class="la-stats la-combine-h -justifyevenly"><!> <!> <!></div> <div class="la-damage -margin0-lr -margin2-tb"><div class="la-combine-h -gap2"><div class="la-visuals -flex5"><!> <div class="la-spacer -tiny"></div> <!></div> <div class="la-combine-v -divider la-prmy-bar-shield -flex0 -width3ch -textaligncenter la-prmy-bar-shield -glow-prmy"><input type="number" class="la-damage__input la-shadow -medium -inset la-text-text -width5 -heightfull -bordersround-lrt -small -bordersoff" name="system.overshield.value" data-dtype="Number"> <span class="la-damage__span -fontsize0 -heightfull -lineheight1" data-tooltip-direction="LEFT"> </span></div></div> <div class="la-spacer -large"></div> <div class="la-combine-h -gap2"><div class="la-visuals -flex5"><!> <div class="la-spacer -tiny"></div> <!></div> <div class="la-combine-v -divider la-prmy-bar-burn -flex0 -width3ch -textaligncenter la-prmy-bar-burn -glow-prmy"><input type="number" class="la-damage__input la-shadow -medium -inset la-text-text -width5 -heightfull -bordersround-lrt -small -bordersoff" name="system.burn" data-dtype="Number"> <span class="la-damage__span -fontsize0 -heightfull -lineheight1" data-tooltip-direction="LEFT"> </span></div></div></div> <div class="la-stats la-combine-h -justifyevenly"><!> <!> <!></div></div></div></div></div></div>`);
function Stats$1($$anchor, $$props) {
  push($$props, !0);
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor, system } = props;
  let advancedOptions = /* @__PURE__ */ derived(() => getAdvancedState(actor.uuid)), tokenImageLocked = /* @__PURE__ */ derived(() => getTokenImageLock(actor.uuid)), editingBurn = state(!1), editingShield = state(!1);
  const isInstanced = actor.parent && actor.type === "npc", themeOverride = getBrightness(getThemeKey(actor.uuid)) === "light" ? "la-text-primary" : "la-text-text", tooltipEnabled = getNPCSheetTooltipEnabled(), sizeTip = TooltipFactory.buildTooltip(getLocalized("LA.size.tooltip"), `${getLocalized("LA.size.label")} ${system.size}`), speedTip = TooltipFactory.buildTooltip(getLocalized("LA.speed.tooltip"), `${getLocalized("LA.speed.label")} ${system.speed}`), activateTip = TooltipFactory.buildTooltip(getLocalized("LA.activate.tooltip"), `Activations ${system.activations}`), tierTip = TooltipFactory.buildTooltip(getLocalized("LA.npc.tier.tooltip"), `Tier ${system.tier}`), setTierTip = TooltipFactory.buildTooltip(getLocalized("LA.npc.tier.set.tooltip")), rechargeTip = TooltipFactory.buildTooltip(getLocalized("LA.npc.recharge.tooltip"), getLocalized("LA.action.startofturn.label")), notesEditTip = TooltipFactory.buildTooltip(getLocalized("LA.npc.notes.edit.tooltip")), notesTip = TooltipFactory.buildTooltip(getLocalized("LA.npc.notes.tooltip")), notesContent = TooltipFactory.buildTooltip(system.notes, getLocalized("LA.npc.notes.label")), shieldTip = TooltipFactory.buildTooltip(getLocalized("LA.overshield.tooltip")), burnTip = TooltipFactory.buildTooltip(getLocalized("LA.burn.tooltip")), tokenErrorTip = TooltipFactory.buildTooltip(getLocalized("LA.edit.token.error"));
  onMount(() => {
    setTokenImageLock(actor.uuid, getActorTokenSync$1(actor.uuid));
  });
  function handleShowNotes(event2) {
    event2.stopPropagation(), TooltipFactory.renderTooltip(event2, {
      text: notesContent,
      direction: TooltipDirection.RIGHT,
      locked: !0
    });
  }
  __name(handleShowNotes, "handleShowNotes");
  function handleEditToken2(event2) {
    event2.stopPropagation(), get$1(tokenImageLocked) ? browseActorImageSync(event2, actor) : browseTokenImage(event2, actor);
  }
  __name(handleEditToken2, "handleEditToken");
  var div = root$j(), div_1 = child(div), div_2 = child(div_1), div_3 = child(div_2), div_4 = child(div_3), button = child(div_4);
  set_attribute(button, "data-tooltip", tooltipEnabled ? setTierTip : void 0), set_attribute(button, "data-tooltip-direction", "UP");
  var input = sibling(button);
  set_attribute(input, "type", "number"), set_attribute(input, "data-dtype", "Number"), set_attribute(input, "name", "system.tier"), set_attribute(input, "data-tooltip", tooltipEnabled ? setTierTip : void 0), set_attribute(input, "data-tooltip-direction", "UP");
  var button_1 = sibling(input);
  set_attribute(button_1, "data-tooltip", tooltipEnabled ? setTierTip : void 0), set_attribute(button_1, "data-tooltip-direction", "UP");
  var div_5 = sibling(div_3, 2), div_6 = child(div_5), div_7 = child(div_6), i2 = child(div_7);
  set_attribute(i2, "data-tooltip", tooltipEnabled ? tierTip : void 0);
  var node = sibling(i2, 2);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var i_1 = root_1$8();
      set_class(i_1, `cci cci-size-half ${themeOverride ?? ""} la-outl-shadow`), set_attribute(i_1, "data-tooltip", tooltipEnabled ? sizeTip : void 0), template_effect(
        ($0) => {
          set_attribute(i_1, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(i_1, "data-tooltip-direction", TooltipDirection.RIGHT);
        },
        [() => getCSSDocumentTheme(actor.uuid)]
      ), append($$anchor2, i_1);
    }, "consequent"), alternate = /* @__PURE__ */ __name(($$anchor2) => {
      var i_2 = root_2$5();
      set_attribute(i_2, "data-tooltip", tooltipEnabled ? sizeTip : void 0), template_effect(
        ($0) => {
          set_class(i_2, `cci cci-size-${system.size ?? ""} ${themeOverride ?? ""} la-outl-shadow`), set_attribute(i_2, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(i_2, "data-tooltip-direction", TooltipDirection.RIGHT);
        },
        [() => getCSSDocumentTheme(actor.uuid)]
      ), append($$anchor2, i_2);
    }, "alternate");
    if_block(node, ($$render) => {
      system.size < 1 ? $$render(consequent) : $$render(alternate, !1);
    });
  }
  var div_8 = sibling(node, 2);
  set_attribute(div_8, "data-tooltip", tooltipEnabled ? speedTip : void 0);
  var i_3 = child(div_8);
  set_class(i_3, `mdi mdi-arrow-right-bold-hexagon-outline ${themeOverride ?? ""} la-outl-shadow -fontsize6`);
  var span = sibling(i_3, 2);
  set_class(span, `${themeOverride ?? ""} la-outl-shadow -fontsize6 -bold`);
  var text2 = child(span), div_9 = sibling(div_8, 2);
  set_attribute(div_9, "data-tooltip", tooltipEnabled ? activateTip : void 0);
  var i_4 = child(div_9);
  set_class(i_4, `cci cci-activate ${themeOverride ?? ""} la-outl-shadow -fontsize6`);
  var span_1 = sibling(i_4, 2);
  set_class(span_1, `${themeOverride ?? ""} la-outl-shadow -fontsize6 -bold`);
  var text_1 = child(span_1), div_10 = sibling(div_9, 2), button_2 = child(div_10);
  set_attribute(button_2, "data-tooltip", tooltipEnabled ? rechargeTip : void 0);
  var div_11 = sibling(div_6, 2), node_1 = child(div_11);
  const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid));
  ImageVideo(node_1, {
    actor,
    editDisabled: isInstanced,
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression);
    },
    onPointerClick: handleEditToken2
  });
  var node_2 = sibling(div_11, 2);
  HaseDisplay(node_2, spread_props(() => props));
  var div_12 = sibling(div_2, 2), div_13 = child(div_12), div_14 = child(div_13), div_15 = child(div_14), node_3 = child(div_15);
  const expression_1 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid));
  AdvancedButton(node_3, {
    get uuid() {
      return actor.uuid;
    },
    style: [
      "-lineheight3",
      "la-prmy-primary -glow-prmy-hover"
    ],
    iconStyle: ["-fontsize5"],
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_1);
    },
    get tooltipDirection() {
      return TooltipDirection.UP;
    }
  });
  var node_4 = sibling(node_3, 2);
  {
    var consequent_1 = /* @__PURE__ */ __name(($$anchor2) => {
      LockImageButton($$anchor2, {
        style: "-fontsize2 la-text-text la-prmy-primary -glow-prmy-hover",
        actor,
        setState: setActorTokenSync$1,
        tooltipEnabled
      });
    }, "consequent_1");
    if_block(node_4, ($$render) => {
      get$1(advancedOptions) && !isInstanced && $$render(consequent_1);
    });
  }
  var node_5 = sibling(node_4, 2);
  {
    var consequent_3 = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment_1 = comment(), node_6 = first_child(fragment_1);
      {
        var consequent_2 = /* @__PURE__ */ __name(($$anchor3) => {
          const expression_2 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_3 = /* @__PURE__ */ derived(() => getLocalized("LA.edit.image.actor.tooltip"));
          GlyphButton($$anchor3, {
            get flowClass() {
              return FlowClass.None;
            },
            style: [
              "mdi mdi-image-edit",
              "-fontsize2 la-text-text la-prmy-primary -glow-prmy-hover"
            ],
            onClick: /* @__PURE__ */ __name((event2) => browseActorImage(event2, actor), "onClick"),
            tooltipEnabled,
            get tooltipTheme() {
              return get$1(expression_2);
            },
            get tooltip() {
              return get$1(expression_3);
            },
            get tooltipDirection() {
              return TooltipDirection.UP;
            }
          });
        }, "consequent_2");
        if_block(node_6, ($$render) => {
          get$1(tokenImageLocked) || $$render(consequent_2);
        });
      }
      append($$anchor2, fragment_1);
    }, "consequent_3"), alternate_1 = /* @__PURE__ */ __name(($$anchor2) => {
      var i_5 = root_6$e();
      set_attribute(i_5, "data-tooltip", tooltipEnabled ? tokenErrorTip : void 0), template_effect(
        ($0) => {
          set_attribute(i_5, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(i_5, "data-tooltip-direction", TooltipDirection.DOWN);
        },
        [() => getCSSDocumentTheme(actor.uuid)]
      ), append($$anchor2, i_5);
    }, "alternate_1");
    if_block(node_5, ($$render) => {
      isInstanced ? $$render(alternate_1, !1) : $$render(consequent_3);
    });
  }
  var node_7 = sibling(node_5, 2);
  {
    var consequent_4 = /* @__PURE__ */ __name(($$anchor2) => {
      const expression_4 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid));
      ThemeOverrideButton($$anchor2, {
        get uuid() {
          return actor.uuid;
        },
        style: ["-lineheight3"],
        iconStyle: ["-fontsize2"],
        setOverride: setThemeOverride$1,
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_4);
        },
        get tooltipDirection() {
          return TooltipDirection.UP;
        }
      });
    }, "consequent_4");
    if_block(node_7, ($$render) => {
      get$1(advancedOptions) && $$render(consequent_4);
    });
  }
  var div_16 = sibling(div_15, 2), button_3 = child(div_16);
  set_attribute(button_3, "data-tooltip", notesEditTip), set_attribute(button_3, "data-path", "system.notes");
  var button_4 = sibling(button_3, 2);
  set_attribute(button_4, "data-tooltip", notesTip), button_4.__click = [on_click, handleShowNotes];
  var div_17 = sibling(div_14, 2), div_18 = child(div_17), node_8 = child(div_18);
  const expression_5 = /* @__PURE__ */ derived(() => getLocalized("LA.armor.short")), expression_6 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_7 = /* @__PURE__ */ derived(() => getLocalized("LA.armor.tooltip"));
  StatComboShort(node_8, {
    icon: "cci cci-role-defender",
    get label() {
      return get$1(expression_5);
    },
    get value() {
      return system.armor;
    },
    outerStyle: ["-fontsize5"],
    innerStyle: [
      "-divider",
      "-fontsize1",
      "la-prmy-accent",
      "-textaligncenter",
      "-bold"
    ],
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_6);
    },
    get tooltip() {
      return get$1(expression_7);
    },
    get tooltipDirection() {
      return TooltipDirection.LEFT;
    }
  });
  var node_9 = sibling(node_8, 2);
  const expression_8 = /* @__PURE__ */ derived(() => getLocalized("LA.evasion.short")), expression_9 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_10 = /* @__PURE__ */ derived(() => getLocalized("LA.evasion.tooltip"));
  StatComboShort(node_9, {
    icon: "cci cci-evasion",
    get label() {
      return get$1(expression_8);
    },
    get value() {
      return system.evasion;
    },
    outerStyle: ["-fontsize5"],
    innerStyle: [
      "-divider",
      "-fontsize1",
      "la-prmy-accent",
      "-textaligncenter",
      "-bold"
    ],
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_9);
    },
    get tooltip() {
      return get$1(expression_10);
    },
    get tooltipDirection() {
      return TooltipDirection.LEFT;
    }
  });
  var node_10 = sibling(node_9, 2);
  const expression_11 = /* @__PURE__ */ derived(() => getLocalized("LA.edefense.short")), expression_12 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_13 = /* @__PURE__ */ derived(() => getLocalized("LA.edefense.tooltip"));
  StatComboShort(node_10, {
    icon: "cci cci-edef",
    get label() {
      return get$1(expression_11);
    },
    get value() {
      return system.edef;
    },
    outerStyle: ["-fontsize5"],
    innerStyle: [
      "-divider",
      "-fontsize1",
      "la-prmy-accent",
      "-textaligncenter",
      "-bold"
    ],
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_12);
    },
    get tooltip() {
      return get$1(expression_13);
    },
    get tooltipDirection() {
      return TooltipDirection.LEFT;
    }
  });
  var div_19 = sibling(div_18, 2), div_20 = child(div_19), div_21 = child(div_20), node_11 = child(div_21);
  const expression_14 = /* @__PURE__ */ derived(() => getLocalized("LA.hitpoint.short")), expression_15 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_16 = /* @__PURE__ */ derived(() => getLocalized("LA.hitpoint.tooltip"));
  StatusBar(node_11, {
    get name() {
      return get$1(expression_14);
    },
    dataName: "system.hp.value",
    get currentValue() {
      return system.hp.value;
    },
    get maxValue() {
      return system.hp.max;
    },
    barStyle: ["la-bckg-bar-health"],
    barEditStyle: ["la-prmy-bar-health"],
    get currentValueSecondary() {
      return system.overshield.value;
    },
    get maxValueSecondary() {
      return system.hp.max;
    },
    barStyleSecondary: ["la-bckg-bar-shield", "-shield"],
    barEditStyleSecondary: ["la-prmy-bar-shield"],
    textStyle: ["la-text-text"],
    clipPath: "clipped",
    get editSecondary() {
      return get$1(editingShield);
    },
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_15);
    },
    get tooltipDirection() {
      return TooltipDirection.LEFT;
    },
    get tooltip() {
      return get$1(expression_16);
    }
  });
  var node_12 = sibling(node_11, 4);
  const expression_17 = /* @__PURE__ */ derived(() => getLocalized("LA.structure.label")), expression_18 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_19 = /* @__PURE__ */ derived(() => getLocalized("LA.structure.tooltip"));
  StatusBar(node_12, {
    get name() {
      return get$1(expression_17);
    },
    dataName: "system.structure.value",
    get currentValue() {
      return system.structure.value;
    },
    get maxValue() {
      return system.structure.max;
    },
    textStyle: ["la-text-text"],
    barStyle: ["la-bckg-bar-structure"],
    barEditStyle: ["la-prmy-bar-structure"],
    clipPath: "clipped-alt",
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_18);
    },
    get tooltipDirection() {
      return TooltipDirection.LEFT;
    },
    get tooltip() {
      return get$1(expression_19);
    }
  });
  var div_22 = sibling(div_21, 2), input_1 = child(div_22);
  input_1.__change = [on_change$3, system];
  var span_2 = sibling(input_1, 2);
  set_attribute(span_2, "data-tooltip", tooltipEnabled ? shieldTip : void 0);
  var text_2 = child(span_2), div_23 = sibling(div_20, 4), div_24 = child(div_23), node_13 = child(div_24);
  const expression_20 = /* @__PURE__ */ derived(() => getLocalized("LA.heat.label")), expression_21 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_22 = /* @__PURE__ */ derived(() => getLocalized("LA.heat.tooltip"));
  StatusBar(node_13, {
    get name() {
      return get$1(expression_20);
    },
    dataName: "system.heat.value",
    get currentValue() {
      return system.heat.value;
    },
    get maxValue() {
      return system.heat.max;
    },
    barStyle: ["la-bckg-bar-heat"],
    barEditStyle: ["la-prmy-bar-heat"],
    get currentValueSecondary() {
      return system.burn;
    },
    get maxValueSecondary() {
      return system.heat.max;
    },
    barStyleSecondary: ["la-bckg-bar-burn", "-burn"],
    barEditStyleSecondary: ["la-prmy-bar-burn"],
    textStyle: ["la-text-text"],
    clipPath: "clipped",
    get editSecondary() {
      return get$1(editingBurn);
    },
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_21);
    },
    get tooltipDirection() {
      return TooltipDirection.LEFT;
    },
    get tooltip() {
      return get$1(expression_22);
    }
  });
  var node_14 = sibling(node_13, 4);
  const expression_23 = /* @__PURE__ */ derived(() => getLocalized("LA.stress.label")), expression_24 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_25 = /* @__PURE__ */ derived(() => getLocalized("LA.stress.tooltip"));
  StatusBar(node_14, {
    get name() {
      return get$1(expression_23);
    },
    dataName: "system.stress.value",
    get currentValue() {
      return system.stress.value;
    },
    get maxValue() {
      return system.stress.max;
    },
    textStyle: ["la-text-text"],
    barStyle: ["la-bckg-bar-stress"],
    barEditStyle: ["la-prmy-bar-stress"],
    clipPath: "clipped-alt",
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_24);
    },
    get tooltipDirection() {
      return TooltipDirection.LEFT;
    },
    get tooltip() {
      return get$1(expression_25);
    }
  });
  var div_25 = sibling(div_24, 2), input_2 = child(div_25);
  input_2.__change = [on_change_1$2, system];
  var span_3 = sibling(input_2, 2);
  set_attribute(span_3, "data-tooltip", tooltipEnabled ? burnTip : void 0);
  var text_3 = child(span_3), div_26 = sibling(div_19, 2), node_15 = child(div_26);
  const expression_26 = /* @__PURE__ */ derived(() => getLocalized("LA.tattack.short")), expression_27 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_28 = /* @__PURE__ */ derived(() => getLocalized("LA.tattack.tooltip"));
  StatComboShort(node_15, {
    icon: "cci cci-tech-full",
    get label() {
      return get$1(expression_26);
    },
    get value() {
      return system.tech_attack;
    },
    outerStyle: ["-fontsize5"],
    innerStyle: [
      "-divider",
      "-fontsize1",
      "la-prmy-accent",
      "-textaligncenter",
      "-bold"
    ],
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_27);
    },
    get tooltip() {
      return get$1(expression_28);
    },
    get tooltipDirection() {
      return TooltipDirection.LEFT;
    }
  });
  var node_16 = sibling(node_15, 2);
  const expression_29 = /* @__PURE__ */ derived(() => getLocalized("LA.save.short")), expression_30 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_31 = /* @__PURE__ */ derived(() => getLocalized("LA.save.tooltip"));
  StatComboShort(node_16, {
    icon: "cci cci-save",
    get label() {
      return get$1(expression_29);
    },
    get value() {
      return system.save;
    },
    outerStyle: ["-fontsize5"],
    innerStyle: [
      "-divider",
      "-fontsize1",
      "la-prmy-accent",
      "-textaligncenter",
      "-bold"
    ],
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_30);
    },
    get tooltip() {
      return get$1(expression_31);
    },
    get tooltipDirection() {
      return TooltipDirection.LEFT;
    }
  });
  var node_17 = sibling(node_16, 2);
  const expression_32 = /* @__PURE__ */ derived(() => getLocalized("LA.sensor.short")), expression_33 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_34 = /* @__PURE__ */ derived(() => getLocalized("LA.sensor.tooltip"));
  StatComboShort(node_17, {
    icon: "cci cci-sensor",
    get label() {
      return get$1(expression_32);
    },
    get value() {
      return system.sensor_range;
    },
    outerStyle: ["-fontsize5"],
    innerStyle: [
      "-divider",
      "-fontsize1",
      "la-prmy-accent",
      "-textaligncenter",
      "-bold"
    ],
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_33);
    },
    get tooltip() {
      return get$1(expression_34);
    },
    get tooltipDirection() {
      return TooltipDirection.LEFT;
    }
  }), template_effect(
    ($0, $1, $2, $3, $4, $5, $6, $7) => {
      set_attribute(button, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(button, "aria-label", $1), set_value(input, `${system.tier}`), set_attribute(input, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(button_1, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(button_1, "aria-label", $2), set_class(i2, `cci cci-npc-tier-${system.tier ?? ""} ${themeOverride ?? ""} la-outl-shadow`), set_attribute(i2, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(i2, "data-tooltip-direction", TooltipDirection.RIGHT), set_attribute(div_8, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(div_8, "data-tooltip-direction", TooltipDirection.RIGHT), set_text(text2, system.speed), set_attribute(div_9, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(div_9, "data-tooltip-direction", TooltipDirection.RIGHT), set_text(text_1, system.activations), set_attribute(button_2, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(button_2, "data-tooltip-direction", TooltipDirection.RIGHT), set_attribute(button_2, "aria-label", $3), set_attribute(div_11, "data-uuid", actor.uuid), set_class(button_3, `mdi mdi-note-edit -fontsize2 la-prmy-primary -glow-prmy-hover ${(get$1(advancedOptions) ? "" : "-visibilityhidden") ?? ""}
                                popout-text-edit-button`), set_attribute(button_3, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(button_3, "data-tooltip-direction", TooltipDirection.UP), set_attribute(button_3, "aria-label", $4), set_attribute(button_4, "data-tooltip-class", `clipped-bot la-tooltip -scrollbar ${$0 ?? ""}`), set_attribute(button_4, "data-tooltip-direction", TooltipDirection.UP), set_attribute(button_4, "aria-label", $5), set_value(input_1, system.overshield.value), set_attribute(span_2, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_text(text_2, $6), set_value(input_2, system.burn), set_attribute(span_3, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_text(text_3, $7);
    },
    [
      () => getCSSDocumentTheme(actor.uuid),
      () => getLocalized("LA.subtract.label"),
      () => getLocalized("LA.add.label"),
      () => getLocalized("LA.npc.recharge.tooltip"),
      () => getLocalized("LA.npc.notes.tooltip"),
      () => getLocalized("LA.npc.notes.label"),
      () => getLocalized("LA.overshield.short"),
      () => getLocalized("LA.burn.short")
    ]
  ), event("focus", input_1, (event2) => {
    event2.currentTarget.select(), set(editingShield, !0);
  }), event("blur", input_1, () => {
    set(editingShield, !1);
  }), event("focus", input_2, (event2) => {
    event2.currentTarget.select(), set(editingBurn, !0);
  }), event("blur", input_2, () => {
    set(editingBurn, !1);
  }), append($$anchor, div), pop();
}
__name(Stats$1, "Stats$1");
delegate(["click", "change"]);
var root$i = /* @__PURE__ */ template('<div class="la-combine-v -widthfull -heightfull"><div class="la-bg-scroll-alt la-bckg-primary -widthfull -height10"><div class="la-combine-v -widthfull -heightfull -padding1-lr"><input type="text" class="la-actorname__input la-text-header -upper -fontsize4 -textaligncenter -heightfull" name="name"> <div class="la-combine-h -gap5 la-text-header -widthfull -textaligncenter -padding0-tb"><!> <!></div></div></div> <!></div>');
function Header$2($$anchor, $$props) {
  push($$props, !0);
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor, system, itemTypes } = props, templates = itemTypes.npc_template;
  var div = root$i(), div_1 = child(div), div_2 = child(div_1), input = child(div_2), div_3 = sibling(input, 2), node = child(div_3);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment = comment(), node_1 = first_child(fragment);
      each(node_1, 17, () => templates, index, ($$anchor3, template2, index2) => {
        Template($$anchor3, {
          get name() {
            return get$1(template2).name;
          },
          get uuid() {
            return get$1(template2).uuid;
          },
          path: `itemTypes.npc_template.${index2}`
        });
      }), append($$anchor2, fragment);
    }, "consequent");
    if_block(node, ($$render) => {
      templates.length && $$render(consequent);
    });
  }
  var node_2 = sibling(node, 2);
  {
    var consequent_1 = /* @__PURE__ */ __name(($$anchor2) => {
      Template($$anchor2, {
        get name() {
          return system.class.name;
        },
        get uuid() {
          return system.class.uuid;
        },
        path: "system.class"
      });
    }, "consequent_1");
    if_block(node_2, ($$render) => {
      system.class && $$render(consequent_1);
    });
  }
  var node_3 = sibling(div_1, 2);
  Stats$1(node_3, spread_props(() => props)), template_effect(
    ($0) => {
      set_value(input, actor.name), set_attribute(input, "placeholder", $0);
    },
    [() => getLocalized("LA.namePlaceholder")]
  ), append($$anchor, div), pop();
}
__name(Header$2, "Header$2");
function Activity$2($$anchor, $$props) {
  push($$props, !0);
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor } = props, actionLogSaveCollapse = getNPCSheetLogActionDontSaveCollapse(), actionLogStartCollapsed = getNPCSheetLogActionStartCollapsed();
  ActionLog($$anchor, {
    get uuid() {
      return actor.uuid;
    },
    dontSaveCollapse: actionLogSaveCollapse,
    startCollapsed: actionLogStartCollapsed,
    get collapsePrefix() {
      return ActionLogCollapsePrefix.NPCSheet;
    }
  }), pop();
}
__name(Activity$2, "Activity$2");
var root_3$b = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull"><!> <div class="la-combine-h -wrapwrap -widthfull -gap0"><div class="la-combine-v -gap0 -flex1 -widthfull"><!> <!></div> <div class="la-combine-v -gap0 -flex1 -widthfull"><!> <!></div></div></div>'), root$h = /* @__PURE__ */ template("<!> <!> <!>", 1);
function Status($$anchor, $$props) {
  push($$props, !0);
  const headerOptions = /* @__PURE__ */ __name(($$anchor2) => {
    const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid));
    CollapseAllButton($$anchor2, {
      collapseID: activeEffectsCollID,
      tooltipEnabled,
      get tooltipTheme() {
        return get$1(expression);
      },
      onPointerEnter: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !0);
      }, "onPointerEnter"),
      onPointerLeave: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !1);
      }, "onPointerLeave")
    });
  }, "headerOptions"), props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor } = props;
  let advancedOptions = /* @__PURE__ */ derived(() => getAdvancedState(actor.uuid)), sidebarExes = proxy(getSidebarExecutables(actor.uuid)), collapseAllButtonHover = state(!1);
  const tooltipEnabled = getNPCSheetTooltipEnabled(), activeEffectsCollID = `${actor.uuid}.status.activeEffects`, utilitiesCollID = `${actor.uuid}.status.utilities`, macrosCollID = `${actor.uuid}.status.macros`;
  var fragment_1 = root$h(), node = first_child(fragment_1);
  const expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.tab.status.effects.label"));
  HeaderMain(node, {
    get text() {
      return get$1(expression_1);
    },
    headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-pilot"],
    textStyle: [
      "la-text-header",
      "-fontsize2",
      "-overflowhidden"
    ],
    borderStyle: ["la-brdr-pilot"],
    collapseID: activeEffectsCollID,
    startCollapsed: !1,
    headerContent: headerOptions,
    children: /* @__PURE__ */ __name(($$anchor2, $$slotProps) => {
      ActiveEffects($$anchor2, spread_props(() => props, {
        tooltipEnabled,
        get logType() {
          return TextLogHook.MechHeader;
        },
        get logTypeReset() {
          return TextLogHook.MechHeaderReset;
        }
      }));
    }, "children"),
    $$slots: { default: !0 }
  });
  var node_1 = sibling(node, 2);
  const expression_2 = /* @__PURE__ */ derived(() => getLocalized("LA.npc.utilities.label"));
  HeaderMain(node_1, {
    get text() {
      return get$1(expression_2);
    },
    headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-pilot"],
    textStyle: [
      "la-text-header",
      "-fontsize2",
      "-overflowhidden"
    ],
    borderStyle: ["la-brdr-pilot"],
    extensionTextFunction: /* @__PURE__ */ __name(() => {
      if (get$1(collapseAllButtonHover)) return `--${getLocalized("LA.collapseAll.extension")}`;
    }, "extensionTextFunction"),
    collapseID: utilitiesCollID,
    startCollapsed: !1,
    children: /* @__PURE__ */ __name(($$anchor2, $$slotProps) => {
      var div = root_3$b(), node_2 = child(div);
      const expression_3 = /* @__PURE__ */ derived(() => getLocalized("LA.npc.recharge.label")), expression_4 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_5 = /* @__PURE__ */ derived(() => getLocalized("LA.npc.recharge.tooltip")), expression_6 = /* @__PURE__ */ derived(() => getLocalized("LA.action.startofturn.label"));
      FlowButton(node_2, {
        style: [
          "clipped-alt",
          "-widthfull",
          "la-bckg-header-anti",
          "-padding0"
        ],
        get text() {
          return get$1(expression_3);
        },
        get flowClass() {
          return FlowClass.RechargeFeatures;
        },
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_4);
        },
        get tooltipDirection() {
          return TooltipDirection.UP;
        },
        get tooltip() {
          return get$1(expression_5);
        },
        get tooltipHeader() {
          return get$1(expression_6);
        }
      });
      var div_1 = sibling(node_2, 2), div_2 = child(div_1), node_3 = child(div_2);
      const expression_7 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.rollAttack.label")), expression_8 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_9 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.rollAttack.tooltip"));
      FlowButton(node_3, {
        style: [
          "clipped-alt",
          "-widthfull",
          "la-bckg-secondary"
        ],
        get text() {
          return get$1(expression_7);
        },
        get uuid() {
          return actor.uuid;
        },
        get flowClass() {
          return FlowClass.Standard;
        },
        flowType: "BasicAttack",
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_8);
        },
        get tooltipDirection() {
          return TooltipDirection.UP;
        },
        get tooltip() {
          return get$1(expression_9);
        }
      });
      var node_4 = sibling(node_3, 2);
      const expression_10 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.rollDamage.label")), expression_11 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_12 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.rollDamage.tooltip"));
      FlowButton(node_4, {
        style: [
          "clipped-alt",
          "-widthfull",
          "la-bckg-secondary"
        ],
        get text() {
          return get$1(expression_10);
        },
        get uuid() {
          return actor.uuid;
        },
        get flowClass() {
          return FlowClass.Standard;
        },
        flowType: "Damage",
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_11);
        },
        get tooltipDirection() {
          return TooltipDirection.UP;
        },
        get tooltip() {
          return get$1(expression_12);
        }
      });
      var div_3 = sibling(div_2, 2), node_5 = child(div_3);
      const expression_13 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.rollTechAttack.label")), expression_14 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_15 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.rollTechAttack.tooltip"));
      FlowButton(node_5, {
        style: ["clipped", "-widthfull", "la-bckg-secondary"],
        get text() {
          return get$1(expression_13);
        },
        get uuid() {
          return actor.uuid;
        },
        get flowClass() {
          return FlowClass.Standard;
        },
        flowType: "TechAttack",
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_14);
        },
        get tooltipDirection() {
          return TooltipDirection.UP;
        },
        get tooltip() {
          return get$1(expression_15);
        }
      });
      var node_6 = sibling(node_5, 2);
      const expression_16 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.extinguish.label")), expression_17 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_18 = /* @__PURE__ */ derived(() => getLocalized("LA.action.endofturn.label")), expression_19 = /* @__PURE__ */ derived(() => getLocalized("LA.flow.extinguish.tooltip"));
      FlowButton(node_6, {
        style: ["clipped", "-widthfull", "la-bckg-secondary"],
        get text() {
          return get$1(expression_16);
        },
        get uuid() {
          return actor.uuid;
        },
        get flowClass() {
          return FlowClass.Standard;
        },
        flowType: "Burn",
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_17);
        },
        get tooltipDirection() {
          return TooltipDirection.UP;
        },
        get tooltipHeader() {
          return get$1(expression_18);
        },
        get tooltip() {
          return get$1(expression_19);
        }
      }), append($$anchor2, div);
    }, "children"),
    $$slots: { default: !0 }
  });
  var node_7 = sibling(node_1, 2);
  const expression_20 = /* @__PURE__ */ derived(() => getLocalized("LA.npc.macros.label"));
  HeaderMain(node_7, {
    get text() {
      return get$1(expression_20);
    },
    headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-pilot"],
    textStyle: [
      "la-text-header",
      "-fontsize2",
      "-overflowhidden"
    ],
    borderStyle: ["la-brdr-pilot"],
    collapseID: macrosCollID,
    startCollapsed: !1,
    children: /* @__PURE__ */ __name(($$anchor2, $$slotProps) => {
      const expression_21 = /* @__PURE__ */ derived(() => [
        `${get$1(advancedOptions) ? "-padding3-l" : ""}`
      ]);
      MacroDropBox($$anchor2, {
        get uuid() {
          return actor.uuid;
        },
        get getExes() {
          return sidebarExes;
        },
        setExes: setSidebarExecutables,
        hintDropArea: !1,
        get allowDrop() {
          return get$1(advancedOptions);
        },
        get buttonStyle() {
          return get$1(expression_21);
        },
        tooltipEnabled: !0
      });
    }, "children"),
    $$slots: { default: !0 }
  }), append($$anchor, fragment_1), pop();
}
__name(Status, "Status");
const _NPCSheetBase = class _NPCSheetBase {
  static get mergeOptions() {
    return {
      classes: [
        "la-common",
        "la-override__header",
        "clipped-alt",
        "lancer",
        "sheet",
        "actor",
        "npc",
        getCSSSystemTheme()
      ],
      template: TEMPLATE_PATHS.npcSheetSvelte,
      width: getNPCSheetWidth() || 500,
      height: getNPCSheetHeight() || 800,
      tabs: [
        {
          navSelector: ".la-tabs",
          contentSelector: ".la-content",
          initial: "loadout"
        }
      ],
      scrollY: [".la-SCROLL_BODY"]
    };
  }
  static setupSheet() {
    var _a;
    const LANPCSheet = (_a = class extends game.lancer.applications.LancerNPCSheet {
      constructor(...args) {
        super(...args), Hooks.on("laOverrideTheme", (uuid, theme) => {
          uuid === this.actor.uuid && (setThemeKey(this.actor.uuid, theme), this.render());
        }), Hooks.on("updateActor", (document2, changes) => {
          var _a2, _b;
          document2.uuid === this.actor.uuid && ((_b = (_a2 = changes.prototypeToken) == null ? void 0 : _a2.texture) != null && _b.src) && getActorTokenSync$1(this.actor.uuid) && (setSelectedTokenImage(this.actor.uuid, changes.prototypeToken.texture.src), isValidImageContainer(changes.prototypeToken.texture.src) && this.actor.update({ img: changes.prototypeToken.texture.src }));
        }), Hooks.on("closeSettingsConfig", () => {
          this.render();
        });
      }
      static get defaultOptions() {
        return mergeObject(super.defaultOptions, _NPCSheetBase.mergeOptions);
      }
      async getData() {
        return await super.getData();
      }
      // (#10)
      // @ts-expect-error We're overriding a function in LancerActorSheet
      _propagateData(formData) {
        super._propagateData(formData), delete formData["prototypeToken.texture.src"];
        const updateToken = getSelectedTokenImage(this.actor.uuid);
        updateToken && (formData["prototypeToken.texture.src"] = updateToken);
      }
      async _injectHTML(html2) {
        super._injectHTML(html2), setThemeKey(this.actor.uuid, getThemeOverride$1(this.actor.uuid)), applyThemeTo(this.element, getThemeKey(this.actor.uuid)), this.mountComponents(html2, dataMap[this.actor.uuid]);
      }
      async _replaceHTML(element, html2) {
        super._replaceHTML(element, html2), applyThemeTo(element, getThemeKey(this.actor.uuid)), this.mountComponents(html2, dataMap[this.actor.uuid]), this._restoreScrollPositions(html2);
      }
      mountComponents(html2, data) {
        unregisterTrackedHooks(this.actor.uuid), mount(
          Header$2,
          {
            target: html2.find(".la-SVELTE-HEADER")[0],
            props: data
          }
        ), mount(
          Loadout,
          {
            target: html2.find(".la-SVELTE-LOADOUT")[0],
            props: data
          }
        ), mount(
          Status,
          {
            target: html2.find(".la-SVELTE-STATUS")[0],
            props: data
          }
        ), mount(
          Activity$2,
          {
            target: html2.find(".la-SVELTE-ACTIVITY")[0],
            props: data
          }
        );
      }
    }, __name(_a, "LANPCSheet"), _a);
    Actors.registerSheet(LancerAlternative.Name, LANPCSheet, {
      types: ["npc"],
      label: getLocalized("LA.SHEET.npc.label"),
      makeDefault: !1
    });
  }
};
__name(_NPCSheetBase, "NPCSheetBase");
let NPCSheetBase = _NPCSheetBase;
var root_1$7 = /* @__PURE__ */ template('<i class="mdi mdi-mouse-move-vertical -fontsize4 -aligncontentcenter la-text-header -glow-prmy la-prmy-primary"></i>'), root_3$a = /* @__PURE__ */ template("<!> <!>", 1), root_6$d = /* @__PURE__ */ template('<i class="mdi mdi-cable-data -fontsize4"></i> <span class="-fontsize0 -aligncontentcenter"> </span>', 1), root_7$8 = /* @__PURE__ */ template('<i class="mdi mdi-cable-data -fontsize4 horus--subtle"></i> <span class="-fontsize0 -aligncontentcenter horus--subtle"> </span>', 1), root_8$1 = /* @__PURE__ */ template('<i class="mdi mdi-heart-pulse -fontsize4"></i> <span class="-fontsize0 -aligncontentcenter"> </span>', 1), root_10$5 = /* @__PURE__ */ template('<i class="mdi mdi-heart-pulse -fontsize4"></i> <span class="-fontsize0 -aligncontentcenter"> </span>', 1), root_12$1 = /* @__PURE__ */ template('<i class="mdi mdi-heart-pulse -fontsize4 horus--subtle"></i> <span class="-fontsize0 -aligncontentcenter horus--very--subtle"> </span>', 1), root_14$1 = /* @__PURE__ */ template('<i class="mdi mdi-heart-pulse -fontsize4 horus--subtle"></i> <span class="-fontsize0 -aligncontentcenter horus--very--subtle"> </span>', 1), root_16$1 = /* @__PURE__ */ template('<i class="mdi mdi-heart-pulse -fontsize4 horus--subtle"></i> <span class="-fontsize0 -aligncontentcenter horus--subtle"> </span>', 1), root_17 = /* @__PURE__ */ template('<i class="mdi mdi-heart-pulse -fontsize4 horus--subtle"></i> <span class="-fontsize0 -aligncontentcenter horus--subtle"> </span>', 1), root_5$8 = /* @__PURE__ */ template('<div class="la-pilotfluff la-combine-h -positionabsolute la-combine-v -padding0-lr"><span class="la-text-darken-2 -textalignjustify -flex1"> </span></div> <div class="-positionrelative"><div class="la-combine-v -positionabsolute -margin3-t -margin1-lr la-text-lighten-7"><div class="la-combine-h -justifystart -widthfull"><i class="mdi mdi-fingerprint -fontsize4"></i> <span class="-fontsize0 -aligncontentcenter"> </span></div> <div class="la-combine-h -justifystart -widthfull"><!></div> <div class="la-combine-h -justifystart -widthfull"><!></div></div></div>', 1), root$g = /* @__PURE__ */ template(`<div class="la-header-content la-combine-h"><div class="la-combine-v -alignend la-settings__island -padding1 -positionabsolute -right0 -top0" style="z-index: 2;"><div class="la-combine-h"><!> <!></div> <!></div> <div class="la-names -margin3-l -margin3-t -flex1"><div class="la-combine-h"><input type="text" class="la-actorname__input la-text-header -fontsize4 -upper -letterspacing1
                    charname"> <span class="-fontsize0 la-text-darken-3"> </span></div> <hr class="la-divider-h -spacemedium -margin0-b la-bckg-header"> <div class="la-combine-h"><input type="text" class="la-pilotcallsign__input la-text-header -upper -fontsize2 -letterspacing0
                    charname"> <span class="-fontsize0 la-text-darken-3"> </span></div> <div class="la-combine-h"><input type="text" class="la-pilotbackground__input la-text-header -upper -fontsize1 -letterspacing0
                    charname"> <span class="-fontsize0 la-text-darken-3"> </span></div></div> <span class="la-textlog__wrapper -left0 -positionabsolute -padding1
            -pointerdisable"><!></span> <!></div>`);
function Header$1($$anchor, $$props) {
  push($$props, !0);
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor, system, owner } = props;
  let introPlayed = /* @__PURE__ */ derived(() => getIntroRun(actor.uuid)), advancedOptions = /* @__PURE__ */ derived(() => getAdvancedState(actor.uuid)), tokenImageLocked = /* @__PURE__ */ derived(() => getTokenImageLock(actor.uuid));
  const tooltipEnabled = getPilotSheetTooltipEnabled();
  onMount(() => {
    setTokenImageLock(actor.uuid, getActorTokenSync$2(actor.uuid));
  });
  var div = root$g(), div_1 = child(div), div_2 = child(div_1), node = child(div_2);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var i2 = root_1$7();
      template_effect(
        ($0, $1) => {
          set_attribute(i2, "data-tooltip", $0), set_attribute(i2, "data-tooltip-class", `clipped-bot la-tooltip ${$1 ?? ""}`), set_attribute(i2, "data-tooltip-direction", TooltipDirection.LEFT);
        },
        [
          () => TooltipFactory.buildTooltip(getLocalized("LA.advanced.imageOffset.tooltip")),
          () => getCSSDocumentTheme(actor.uuid)
        ]
      ), append($$anchor2, i2);
    }, "consequent");
    if_block(node, ($$render) => {
      get$1(advancedOptions) && $$render(consequent);
    });
  }
  var node_1 = sibling(node, 2);
  const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid));
  AdvancedButton(node_1, {
    style: [
      "-fontsize3",
      "-glow-prmy",
      "la-prmy-primary"
    ],
    get uuid() {
      return actor.uuid;
    },
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression);
    },
    get logType() {
      return TextLogHook.PilotHeader;
    },
    get logTypeReset() {
      return TextLogHook.PilotHeaderReset;
    }
  });
  var node_2 = sibling(div_2, 2);
  {
    var consequent_3 = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment = comment(), node_3 = first_child(fragment);
      {
        var consequent_2 = /* @__PURE__ */ __name(($$anchor3) => {
          var fragment_1 = root_3$a(), node_4 = first_child(fragment_1);
          LockImageButton(node_4, {
            style: "-fontsize5 la-text-header la-prmy-primary -glow-prmy",
            actor,
            setState: setActorTokenSync$2,
            tooltipEnabled,
            get tooltipDirection() {
              return TooltipDirection.LEFT;
            },
            get logType() {
              return TextLogHook.PilotHeader;
            },
            get logTypeReset() {
              return TextLogHook.PilotHeaderReset;
            }
          });
          var node_5 = sibling(node_4, 2);
          {
            var consequent_1 = /* @__PURE__ */ __name(($$anchor4) => {
              const expression_1 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_2 = /* @__PURE__ */ derived(() => getLocalized("LA.edit.image.actor.tooltip")), expression_3 = /* @__PURE__ */ derived(() => getLocalized("LA.edit.image.actor.tooltip"));
              GlyphButton($$anchor4, {
                get flowClass() {
                  return FlowClass.None;
                },
                style: [
                  "mdi mdi-image-edit",
                  "-fontsize4",
                  "la-text-header",
                  "-width5",
                  "-glow-prmy",
                  "la-prmy-primary"
                ],
                onClick: /* @__PURE__ */ __name((event2) => browseActorImage(event2, actor), "onClick"),
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_1);
                },
                get tooltip() {
                  return get$1(expression_2);
                },
                get tooltipDirection() {
                  return TooltipDirection.LEFT;
                },
                get logText() {
                  return get$1(expression_3);
                },
                get logType() {
                  return TextLogHook.PilotHeader;
                },
                get logTypeReset() {
                  return TextLogHook.PilotHeaderReset;
                }
              });
            }, "consequent_1");
            if_block(node_5, ($$render) => {
              get$1(tokenImageLocked) || $$render(consequent_1);
            });
          }
          append($$anchor3, fragment_1);
        }, "consequent_2");
        if_block(node_3, ($$render) => {
          get$1(advancedOptions) && $$render(consequent_2);
        });
      }
      append($$anchor2, fragment);
    }, "consequent_3");
    if_block(node_2, ($$render) => {
      get$1(advancedOptions) && $$render(consequent_3);
    });
  }
  var div_3 = sibling(div_1, 2), div_4 = child(div_3), input = child(div_4);
  set_attribute(input, "name", "name");
  var span = sibling(input, 2), text2 = child(span), div_5 = sibling(div_4, 4), input_1 = child(div_5);
  set_attribute(input_1, "name", "system.callsign");
  var span_1 = sibling(input_1, 2), text_1 = child(span_1), div_6 = sibling(div_5, 2), input_2 = child(div_6);
  set_attribute(input_2, "name", "system.background");
  var span_2 = sibling(input_2, 2), text_2 = child(span_2), span_3 = sibling(div_3, 2), node_6 = child(span_3);
  const expression_4 = /* @__PURE__ */ derived(() => !get$1(introPlayed));
  TextLog(node_6, {
    style: ["-widthfull", "-heightfull"],
    get uuid() {
      return actor.uuid;
    },
    get hookID() {
      return TextLogHook.PilotHeader;
    },
    get hookResetID() {
      return TextLogHook.PilotHeaderReset;
    },
    get runIntro() {
      return get$1(expression_4);
    }
  });
  var node_7 = sibling(span_3, 2);
  BoundImage(node_7, {
    get image() {
      return actor.img;
    },
    get uuid() {
      return actor.uuid;
    },
    yGetter: getImageOffsetY,
    xGetter: getImageOffsetX,
    xySetter: setImageOffsetXY,
    children: /* @__PURE__ */ __name(($$anchor2, $$slotProps) => {
      var fragment_3 = root_5$8(), div_7 = first_child(fragment_3), span_4 = child(div_7), text_3 = child(span_4), div_8 = sibling(div_7, 2), div_9 = child(div_8), div_10 = child(div_9), span_5 = sibling(child(div_10), 2), text_4 = child(span_5), div_11 = sibling(div_10, 2), node_8 = child(div_11);
      {
        var consequent_4 = /* @__PURE__ */ __name(($$anchor3) => {
          var fragment_4 = root_6$d(), span_6 = sibling(first_child(fragment_4), 2), text_5 = child(span_6);
          template_effect(($0) => set_text(text_5, $0), [
            () => getLocalized("LA.pilot.isOwner.label")
          ]), append($$anchor3, fragment_4);
        }, "consequent_4"), alternate = /* @__PURE__ */ __name(($$anchor3) => {
          var fragment_5 = root_7$8(), span_7 = sibling(first_child(fragment_5), 2), text_6 = child(span_7);
          template_effect(($0) => set_text(text_6, $0), [
            () => getLocalized("LA.pilot.isLimited.label")
          ]), append($$anchor3, fragment_5);
        }, "alternate");
        if_block(node_8, ($$render) => {
          owner ? $$render(consequent_4) : $$render(alternate, !1);
        });
      }
      var div_12 = sibling(div_11, 2), node_9 = child(div_12);
      {
        var consequent_5 = /* @__PURE__ */ __name(($$anchor3) => {
          var fragment_6 = root_8$1(), span_8 = sibling(first_child(fragment_6), 2), text_7 = child(span_8);
          template_effect(($0) => set_text(text_7, $0), [
            () => getLocalized("LA.pilot.activity.1.label")
          ]), append($$anchor3, fragment_6);
        }, "consequent_5"), alternate_5 = /* @__PURE__ */ __name(($$anchor3) => {
          var fragment_7 = comment(), node_10 = first_child(fragment_7);
          {
            var consequent_6 = /* @__PURE__ */ __name(($$anchor4) => {
              var fragment_8 = root_10$5(), span_9 = sibling(first_child(fragment_8), 2), text_8 = child(span_9);
              template_effect(($0) => set_text(text_8, $0), [
                () => getLocalized("LA.pilot.activity.2.label")
              ]), append($$anchor4, fragment_8);
            }, "consequent_6"), alternate_4 = /* @__PURE__ */ __name(($$anchor4) => {
              var fragment_9 = comment(), node_11 = first_child(fragment_9);
              {
                var consequent_7 = /* @__PURE__ */ __name(($$anchor5) => {
                  var fragment_10 = root_12$1(), span_10 = sibling(first_child(fragment_10), 2), text_9 = child(span_10);
                  template_effect(($0) => set_text(text_9, $0), [
                    () => getLocalized("LA.pilot.activity.3.label")
                  ]), append($$anchor5, fragment_10);
                }, "consequent_7"), alternate_3 = /* @__PURE__ */ __name(($$anchor5) => {
                  var fragment_11 = comment(), node_12 = first_child(fragment_11);
                  {
                    var consequent_8 = /* @__PURE__ */ __name(($$anchor6) => {
                      var fragment_12 = root_14$1(), span_11 = sibling(first_child(fragment_12), 2), text_10 = child(span_11);
                      template_effect(($0) => set_text(text_10, $0), [
                        () => getLocalized("LA.pilot.activity.4.label")
                      ]), append($$anchor6, fragment_12);
                    }, "consequent_8"), alternate_2 = /* @__PURE__ */ __name(($$anchor6) => {
                      var fragment_13 = comment(), node_13 = first_child(fragment_13);
                      {
                        var consequent_9 = /* @__PURE__ */ __name(($$anchor7) => {
                          var fragment_14 = root_16$1(), span_12 = sibling(first_child(fragment_14), 2), text_11 = child(span_12);
                          template_effect(($0) => set_text(text_11, $0), [
                            () => getLocalized("LA.pilot.activity.5.label")
                          ]), append($$anchor7, fragment_14);
                        }, "consequent_9"), alternate_1 = /* @__PURE__ */ __name(($$anchor7) => {
                          var fragment_15 = root_17(), span_13 = sibling(first_child(fragment_15), 2), text_12 = child(span_13);
                          template_effect(($0) => set_text(text_12, $0), [
                            () => getLocalized("LA.pilot.activity.6.label")
                          ]), append($$anchor7, fragment_15);
                        }, "alternate_1");
                        if_block(
                          node_13,
                          ($$render) => {
                            system.hp.value <= system.hp.max * 0.25 && system.hp.value > 0 ? $$render(consequent_9) : $$render(alternate_1, !1);
                          },
                          !0
                        );
                      }
                      append($$anchor6, fragment_13);
                    }, "alternate_2");
                    if_block(
                      node_12,
                      ($$render) => {
                        system.hp.value <= system.hp.max * 0.5 && system.hp.value > system.hp.max * 0.25 ? $$render(consequent_8) : $$render(alternate_2, !1);
                      },
                      !0
                    );
                  }
                  append($$anchor5, fragment_11);
                }, "alternate_3");
                if_block(
                  node_11,
                  ($$render) => {
                    system.hp.value <= system.hp.max * 0.75 && system.hp.value > system.hp.max * 0.5 ? $$render(consequent_7) : $$render(alternate_3, !1);
                  },
                  !0
                );
              }
              append($$anchor4, fragment_9);
            }, "alternate_4");
            if_block(
              node_10,
              ($$render) => {
                system.hp.value <= system.hp.max && system.hp.value > system.hp.max * 0.75 ? $$render(consequent_6) : $$render(alternate_4, !1);
              },
              !0
            );
          }
          append($$anchor3, fragment_7);
        }, "alternate_5");
        if_block(node_9, ($$render) => {
          system.hp.value >= system.hp.max ? $$render(consequent_5) : $$render(alternate_5, !1);
        });
      }
      template_effect(
        ($0, $1) => {
          set_text(text_3, $0), set_text(text_4, $1);
        },
        [
          () => getLocalized("LA.pilot.fluff.1"),
          () => getLocalized("LA.pilot.fluff.2")
        ]
      ), append($$anchor2, fragment_3);
    }, "children"),
    $$slots: { default: !0 }
  }), template_effect(
    ($0, $1, $2, $3, $4) => {
      set_value(input, actor.name), set_attribute(input, "placeholder", $0), set_text(text2, $1), set_value(input_1, system.callsign), set_attribute(input_1, "placeholder", $2), set_text(text_1, $3), set_value(input_2, system.background), set_attribute(input_2, "placeholder", $2), set_text(text_2, $4);
    },
    [
      () => getLocalized("LA.namePlaceholder"),
      () => getLocalized("LA.pilot.alias.label"),
      () => getLocalized("LA.placeholder"),
      () => getLocalized("LA.pilot.callsign.label"),
      () => getLocalized("LA.pilot.background.label")
    ]
  ), event("pointerenter", input, (event2) => sendToLog(event2, getLocalized("LA.pilot.alias.tooltip"), TextLogHook.PilotHeader)), event("pointerleave", input, (event2) => resetLog(event2, TextLogHook.PilotHeaderReset)), event("pointerenter", input_1, (event2) => sendToLog(event2, getLocalized("LA.pilot.callsign.tooltip"), TextLogHook.PilotHeader)), event("pointerleave", input_1, (event2) => resetLog(event2, TextLogHook.PilotHeaderReset)), event("pointerenter", input_2, (event2) => sendToLog(event2, getLocalized("LA.pilot.background.tooltip"), TextLogHook.PilotHeader)), event("pointerleave", input_2, (event2) => resetLog(event2, TextLogHook.PilotHeaderReset)), append($$anchor, div), pop();
}
__name(Header$1, "Header$1");
var root_1$6 = /* @__PURE__ */ template("<i></i>"), root_2$4 = /* @__PURE__ */ template("<i></i>"), on_change$2 = /* @__PURE__ */ __name((event2, system) => handleRelativeDataInput(event2, system.overshield.value), "on_change$2"), on_change_1$1 = /* @__PURE__ */ __name((event2, system) => handleRelativeDataInput(event2, system.burn), "on_change_1$1"), root_3$9 = /* @__PURE__ */ template('<div class="la-combine-h -gap2"><div class="la-visuals -flex5"><!></div> <div class="la-combine-v -divider la-prmy-bar-shield -flex0 -width3ch -textaligncenter la-prmy-bar-shield -glow-prmy -margin0-r"><input class="la-damage__input la-shadow -medium -inset la-text-text -width5 -heightfull -bordersround-lrt -small -bordersoff"> <span class="la-damage__span -fontsize0 -heightfull -lineheight1"> </span></div> <div class="la-combine-v -divider la-prmy-bar-burn -flex0 -width3ch -textaligncenter la-prmy-bar-burn -glow-prmy -margin1-r"><input class="la-damage__input la-shadow -medium -inset la-text-text -width5 -heightfull -bordersround-lrt -small -bordersoff"> <span class="la-damage__span -fontsize0 -heightfull -lineheight1"> </span></div></div>'), on_change_2 = /* @__PURE__ */ __name((event2, system) => handleRelativeDataInput(event2, system.overshield.value), "on_change_2"), on_change_3 = /* @__PURE__ */ __name((event2, system) => handleRelativeDataInput(event2, system.burn), "on_change_3"), root_4$6 = /* @__PURE__ */ template('<div class="la-combine-h -gap2 -alignend"><div class="la-visuals -flex5"><!></div> <div class="la-combine-v -divider la-prmy-bar-shield -flex0 -width3ch -textaligncenter la-prmy-bar-shield -glow-prmy -margin1-r"><span class="la-damage__span -fontsize0 -heightfull -lineheight1"> </span> <input class="la-damage__input la-shadow -medium -inset la-text-text -width5 -heightfull -bordersround-lrb -small -bordersoff"></div></div> <div class="la-spacer -tiny"></div> <div class="la-combine-h -gap2"><div class="la-visuals -flex5"><div class="la-spacer -tiny"></div> <!></div> <div class="la-combine-v -divider la-prmy-bar-burn -flex0 -width3ch -textaligncenter la-prmy-bar-burn -glow-prmy -margin1-r"><input class="la-damage__input la-shadow -medium -inset la-text-text -width5 -heightfull -bordersround-lrt -small -bordersoff"> <span class="la-damage__span -fontsize0 -heightfull -lineheight1"> </span></div></div>', 1), root$f = /* @__PURE__ */ template('<div class="la-licenselevel la-dropshadow -overflowhidden"><div class="la-flow -textalignleft -letterspacing0 la-bckg-primary la-text-header clipped-bot-alt -padding0-tb -height3 -margin5-t -margin1-l"><span class="la-cmdline la-text-header -fadein">>//:</span> <span class="la-extension la-text-header -lower -fadein"> </span><span class="la-cursor la-prmy-header -fadein"></span></div></div> <div class="la-pilot__sidebar la-dropshadow -aligncontentcenter -positionrelative"><div class="la-combine-v -positionabsolute -left0 -top0 -fontsize13"><!> <div class="la-combine-h -fontsize7"><i></i> <span> </span></div></div> <!></div> <div class="la-stats la-dropshadow la-combine-h -justifyevenly"><!> <!> <!></div> <div class="la-damage la-dropshadow -margin0-lr -margin2-t -margin0-b"><!></div> <div class="la-dropshadow la-combine-h -justifyevenly"></div> <div class="la-stats la-dropshadow la-combine-h -justifyevenly"><!> <!> <!></div> <!>', 1);
function Sidebar($$anchor, $$props) {
  push($$props, !0);
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { system, actor, itemTypes } = props;
  let advancedOptions = /* @__PURE__ */ derived(() => getAdvancedState(actor.uuid)), component = state(null), editingBurn = state(!1), editingShield = state(!1);
  const themeOverride = getBrightness(getThemeKey(actor.uuid)) === "light" ? "la-text-primary" : "la-text-text", sidebarExes = getSidebarExecutables$1(actor.uuid), tooltipEnabled = getPilotSheetTooltipEnabled(), showSensors = getPilotSheetSensorsEnabled(), showTechAttack = getPilotSheetTechAttackEnabled(), sizeTip = TooltipFactory.buildTooltip(getLocalized("LA.size.tooltip"), `${getLocalized("LA.size.label")} ${system.size}`), speedTip = TooltipFactory.buildTooltip(getLocalized("LA.speed.tooltip"), `${getLocalized("LA.speed.label")} ${system.speed}`), shieldTip = TooltipFactory.buildTooltip(getLocalized("LA.overshield.tooltip")), burnTip = TooltipFactory.buildTooltip(getLocalized("LA.burn.tooltip"));
  onMount(() => {
    if (get$1(component)) {
      const ratio = getSidebarRatio(actor.uuid), sidebar = jQuery(get$1(component)).closest(".la-root").find(".la-sidebar");
      sidebar && sidebar.css("flex", ratio.toString());
    }
  });
  function checkExecutables() {
    const newUuids = itemTypes.skill.map((skill) => skill.uuid).filter((uuid) => !sidebarExes.includes(uuid));
    return sidebarExes.unshift(...newUuids), sidebarExes;
  }
  __name(checkExecutables, "checkExecutables");
  var fragment = root$f(), div = first_child(fragment), div_1 = child(div), text2 = sibling(child(div_1)), span = sibling(text2), text_1 = child(span);
  bind_this(div, ($$value) => set(component, $$value), () => get$1(component));
  var div_2 = sibling(div, 2), div_3 = child(div_2), node = child(div_3);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var i2 = root_1$6();
      set_class(i2, `cci cci-size-half ${themeOverride ?? ""} la-outl-shadow`), set_attribute(i2, "data-tooltip", tooltipEnabled ? sizeTip : void 0), template_effect(
        ($0) => {
          set_attribute(i2, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(i2, "data-tooltip-direction", TooltipDirection.RIGHT);
        },
        [() => getCSSDocumentTheme(actor.uuid)]
      ), append($$anchor2, i2);
    }, "consequent"), alternate = /* @__PURE__ */ __name(($$anchor2) => {
      var i_1 = root_2$4();
      set_attribute(i_1, "data-tooltip", tooltipEnabled ? sizeTip : void 0), template_effect(
        ($0) => {
          set_class(i_1, `cci cci-size-${system.size ?? ""} ${themeOverride ?? ""} la-outl-shadow`), set_attribute(i_1, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(i_1, "data-tooltip-direction", TooltipDirection.RIGHT);
        },
        [() => getCSSDocumentTheme(actor.uuid)]
      ), append($$anchor2, i_1);
    }, "alternate");
    if_block(node, ($$render) => {
      system.size < 1 ? $$render(consequent) : $$render(alternate, !1);
    });
  }
  var div_4 = sibling(node, 2);
  set_attribute(div_4, "data-tooltip", tooltipEnabled ? speedTip : void 0);
  var i_2 = child(div_4);
  set_class(i_2, `mdi mdi-arrow-right-bold-hexagon-outline ${themeOverride ?? ""} la-outl-shadow`);
  var span_1 = sibling(i_2, 2);
  set_class(span_1, `${themeOverride ?? ""} la-outl-shadow -bold`);
  var text_2 = child(span_1), node_1 = sibling(div_3, 2);
  const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.edit.image.token.tooltip")), expression_2 = /* @__PURE__ */ derived(() => getLocalized("LA.edit.image.token.tooltip"));
  ImageVideo(node_1, {
    actor,
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression);
    },
    get tooltip() {
      return get$1(expression_1);
    },
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    },
    get logText() {
      return get$1(expression_2);
    },
    get logType() {
      return TextLogHook.PilotHeader;
    },
    get logTypeReset() {
      return TextLogHook.PilotHeaderReset;
    },
    onPointerClick: /* @__PURE__ */ __name((event2) => handleEditToken(event2, actor), "onPointerClick")
  });
  var div_5 = sibling(div_2, 2), node_2 = child(div_5);
  const expression_3 = /* @__PURE__ */ derived(() => getLocalized("LA.armor.short")), expression_4 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_5 = /* @__PURE__ */ derived(() => getLocalized("LA.armor.tooltip"));
  StatComboShort(node_2, {
    icon: "cci cci-role-defender -alignselfcenter",
    get label() {
      return get$1(expression_3);
    },
    get value() {
      return system.armor;
    },
    outerStyle: ["la-text-text", "-fontsize5"],
    innerStyle: [
      "-divider",
      "-fontsize1",
      "la-prmy-accent",
      "-textaligncenter",
      "-bold"
    ],
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_4);
    },
    get tooltip() {
      return get$1(expression_5);
    },
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    }
  });
  var node_3 = sibling(node_2, 2);
  const expression_6 = /* @__PURE__ */ derived(() => getLocalized("LA.evasion.short")), expression_7 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_8 = /* @__PURE__ */ derived(() => getLocalized("LA.evasion.tooltip"));
  StatComboShort(node_3, {
    icon: "cci cci-evasion -alignselfcenter",
    get label() {
      return get$1(expression_6);
    },
    get value() {
      return system.evasion;
    },
    outerStyle: ["la-text-text", "-fontsize5"],
    innerStyle: [
      "-divider",
      "-fontsize1",
      "la-prmy-accent",
      "-textaligncenter",
      "-bold"
    ],
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_7);
    },
    get tooltip() {
      return get$1(expression_8);
    },
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    }
  });
  var node_4 = sibling(node_3, 2);
  const expression_9 = /* @__PURE__ */ derived(() => getLocalized("LA.edefense.short")), expression_10 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_11 = /* @__PURE__ */ derived(() => getLocalized("LA.edefense.tooltip"));
  StatComboShort(node_4, {
    icon: "cci cci-edef -alignselfcenter",
    get label() {
      return get$1(expression_9);
    },
    get value() {
      return system.edef;
    },
    outerStyle: ["la-text-text", "-fontsize5"],
    innerStyle: [
      "-divider",
      "-fontsize1",
      "la-prmy-accent",
      "-textaligncenter",
      "-bold"
    ],
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_10);
    },
    get tooltip() {
      return get$1(expression_11);
    },
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    }
  });
  var div_6 = sibling(div_5, 2), node_5 = child(div_6);
  {
    var consequent_1 = /* @__PURE__ */ __name(($$anchor2) => {
      var div_7 = root_3$9(), div_8 = child(div_7), node_6 = child(div_8);
      const expression_12 = /* @__PURE__ */ derived(() => getLocalized("LA.hitpoint.short")), expression_13 = /* @__PURE__ */ derived(() => system.bond ? void 0 : system.burn), expression_14 = /* @__PURE__ */ derived(() => system.bond ? void 0 : system.hp.max), expression_15 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_16 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.hitpoint.tooltip"));
      StatusBar(node_6, {
        get name() {
          return get$1(expression_12);
        },
        dataName: "system.hp.value",
        get currentValue() {
          return system.hp.value;
        },
        get maxValue() {
          return system.hp.max;
        },
        get currentValueSecondary() {
          return system.overshield.value;
        },
        get maxValueSecondary() {
          return system.hp.max;
        },
        get currentValueTertiary() {
          return get$1(expression_13);
        },
        get maxValueTertiary() {
          return get$1(expression_14);
        },
        barStyle: ["la-bckg-bar-health"],
        barEditStyle: ["la-prmy-bar-health"],
        barStyleSecondary: ["la-bckg-bar-shield", "-shield"],
        barEditStyleSecondary: ["la-prmy-bar-shield"],
        barStyleTertiary: ["la-bckg-bar-burn", "-burn"],
        barEditStyleTertiary: ["la-prmy-bar-burn"],
        textStyle: ["la-text-text"],
        clipPath: "clipped",
        get editSecondary() {
          return get$1(editingShield);
        },
        get editTertiary() {
          return get$1(editingBurn);
        },
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_15);
        },
        get tooltip() {
          return get$1(expression_16);
        },
        get tooltipDirection() {
          return TooltipDirection.RIGHT;
        }
      });
      var div_9 = sibling(div_8, 2), input = child(div_9);
      set_attribute(input, "type", "number"), set_attribute(input, "name", "system.overshield.value"), set_attribute(input, "data-dtype", "Number"), input.__change = [on_change$2, system];
      var span_2 = sibling(input, 2);
      set_attribute(span_2, "data-tooltip", tooltipEnabled ? shieldTip : void 0);
      var text_3 = child(span_2), div_10 = sibling(div_9, 2), input_1 = child(div_10);
      set_attribute(input_1, "type", "number"), set_attribute(input_1, "name", "system.burn"), set_attribute(input_1, "data-dtype", "Number"), input_1.__change = [on_change_1$1, system];
      var span_3 = sibling(input_1, 2);
      set_attribute(span_3, "data-tooltip", tooltipEnabled ? burnTip : void 0);
      var text_4 = child(span_3);
      template_effect(
        ($0, $1, $2) => {
          set_value(input, system.overshield.value), set_attribute(span_2, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(span_2, "data-tooltip-direction", TooltipDirection.RIGHT), set_text(text_3, $1), set_value(input_1, system.burn), set_attribute(span_3, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(span_3, "data-tooltip-direction", TooltipDirection.RIGHT), set_text(text_4, $2);
        },
        [
          () => getCSSDocumentTheme(actor.uuid),
          () => getLocalized("LA.overshield.short"),
          () => getLocalized("LA.burn.short")
        ]
      ), event("focus", input, (event2) => {
        event2.currentTarget.select(), set(editingShield, !0);
      }), event("blur", input, () => {
        set(editingShield, !1);
      }), event("focus", input_1, (event2) => {
        event2.currentTarget.select(), set(editingBurn, !0);
      }), event("blur", input_1, () => {
        set(editingBurn, !1);
      }), append($$anchor2, div_7);
    }, "consequent_1"), alternate_1 = /* @__PURE__ */ __name(($$anchor2) => {
      var fragment_1 = root_4$6(), div_11 = first_child(fragment_1), div_12 = child(div_11), node_7 = child(div_12);
      const expression_17 = /* @__PURE__ */ derived(() => getLocalized("LA.hitpoint.short")), expression_18 = /* @__PURE__ */ derived(() => system.bond ? void 0 : system.burn), expression_19 = /* @__PURE__ */ derived(() => system.bond ? void 0 : system.hp.max), expression_20 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_21 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.hitpoint.tooltip"));
      StatusBar(node_7, {
        get name() {
          return get$1(expression_17);
        },
        dataName: "system.hp.value",
        get currentValue() {
          return system.hp.value;
        },
        get maxValue() {
          return system.hp.max;
        },
        get currentValueSecondary() {
          return system.overshield.value;
        },
        get maxValueSecondary() {
          return system.hp.max;
        },
        get currentValueTertiary() {
          return get$1(expression_18);
        },
        get maxValueTertiary() {
          return get$1(expression_19);
        },
        barStyle: ["la-bckg-bar-health"],
        barEditStyle: ["la-prmy-bar-health"],
        barStyleSecondary: ["la-bckg-bar-shield", "-shield"],
        barEditStyleSecondary: ["la-prmy-bar-shield"],
        textStyle: ["la-text-text"],
        clipPath: "clipped",
        get editSecondary() {
          return get$1(editingShield);
        },
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_20);
        },
        get tooltip() {
          return get$1(expression_21);
        },
        get tooltipDirection() {
          return TooltipDirection.RIGHT;
        }
      });
      var div_13 = sibling(div_12, 2), span_4 = child(div_13);
      set_attribute(span_4, "data-tooltip", tooltipEnabled ? shieldTip : void 0);
      var text_5 = child(span_4), input_2 = sibling(span_4, 2);
      set_attribute(input_2, "type", "number"), set_attribute(input_2, "name", "system.overshield.value"), set_attribute(input_2, "data-dtype", "Number"), input_2.__change = [on_change_2, system];
      var div_14 = sibling(div_11, 4), div_15 = child(div_14), node_8 = sibling(child(div_15), 2);
      const expression_22 = /* @__PURE__ */ derived(() => getLocalized("LA.stress.label")), expression_23 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_24 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.stress.tooltip"));
      StatusBar(node_8, {
        get name() {
          return get$1(expression_22);
        },
        dataName: "system.bond_state.stress.value",
        get currentValue() {
          return system.bond_state.stress.value;
        },
        get maxValue() {
          return system.bond_state.stress.max;
        },
        get currentValueSecondary() {
          return system.burn;
        },
        get maxValueSecondary() {
          return system.bond_state.stress.max;
        },
        barStyle: ["la-bckg-bar-heat"],
        barEditStyle: ["la-prmy-bar-heat"],
        barStyleSecondary: ["la-bckg-bar-burn", "-burn"],
        barEditStyleSecondary: ["la-prmy-bar-burn"],
        textStyle: ["la-text-text"],
        clipPath: "clipped",
        get editSecondary() {
          return get$1(editingBurn);
        },
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_23);
        },
        get tooltip() {
          return get$1(expression_24);
        },
        get tooltipDirection() {
          return TooltipDirection.RIGHT;
        }
      });
      var div_16 = sibling(div_15, 2), input_3 = child(div_16);
      set_attribute(input_3, "type", "number"), set_attribute(input_3, "name", "system.burn"), set_attribute(input_3, "data-dtype", "Number"), input_3.__change = [on_change_3, system];
      var span_5 = sibling(input_3, 2);
      set_attribute(span_5, "data-tooltip", tooltipEnabled ? burnTip : void 0);
      var text_6 = child(span_5);
      template_effect(
        ($0, $1, $2) => {
          set_attribute(span_4, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(span_4, "data-tooltip-direction", TooltipDirection.RIGHT), set_text(text_5, $1), set_value(input_2, system.overshield.value), set_value(input_3, system.burn), set_attribute(span_5, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(span_5, "data-tooltip-direction", TooltipDirection.RIGHT), set_text(text_6, $2);
        },
        [
          () => getCSSDocumentTheme(actor.uuid),
          () => getLocalized("LA.overshield.short"),
          () => getLocalized("LA.burn.short")
        ]
      ), event("focus", input_2, (event2) => {
        event2.currentTarget.select(), set(editingShield, !0);
      }), event("blur", input_2, () => {
        set(editingShield, !1);
      }), event("focus", input_3, (event2) => {
        event2.currentTarget.select(), set(editingBurn, !0);
      }), event("blur", input_3, () => {
        set(editingBurn, !1);
      }), append($$anchor2, fragment_1);
    }, "alternate_1");
    if_block(node_5, ($$render) => {
      system.bond ? $$render(alternate_1, !1) : $$render(consequent_1);
    });
  }
  var div_17 = sibling(div_6, 4), node_9 = child(div_17);
  {
    var consequent_2 = /* @__PURE__ */ __name(($$anchor2) => {
      const expression_25 = /* @__PURE__ */ derived(() => getLocalized("LA.tattack.short")), expression_26 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_27 = /* @__PURE__ */ derived(() => getLocalized("LA.tattack.tooltip"));
      StatComboShort($$anchor2, {
        icon: "cci cci-tech-full -alignselfcenter",
        get label() {
          return get$1(expression_25);
        },
        get value() {
          return system.tech_attack;
        },
        outerStyle: ["la-text-text", "-fontsize5"],
        innerStyle: [
          "-divider",
          "-fontsize1",
          "la-prmy-accent",
          "-textaligncenter",
          "-bold"
        ],
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_26);
        },
        get tooltip() {
          return get$1(expression_27);
        },
        get tooltipDirection() {
          return TooltipDirection.RIGHT;
        }
      });
    }, "consequent_2");
    if_block(node_9, ($$render) => {
      showTechAttack && $$render(consequent_2);
    });
  }
  var node_10 = sibling(node_9, 2);
  const expression_28 = /* @__PURE__ */ derived(() => getLocalized("LA.save.short")), expression_29 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_30 = /* @__PURE__ */ derived(() => getLocalized("LA.save.tooltip"));
  StatComboShort(node_10, {
    icon: "cci cci-save -alignselfcenter",
    get label() {
      return get$1(expression_28);
    },
    get value() {
      return system.save;
    },
    outerStyle: ["la-text-text", "-fontsize5"],
    innerStyle: [
      "-divider",
      "-fontsize1",
      "la-prmy-accent",
      "-textaligncenter",
      "-bold"
    ],
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_29);
    },
    get tooltip() {
      return get$1(expression_30);
    },
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    }
  });
  var node_11 = sibling(node_10, 2);
  {
    var consequent_3 = /* @__PURE__ */ __name(($$anchor2) => {
      const expression_31 = /* @__PURE__ */ derived(() => getLocalized("LA.sensor.short")), expression_32 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_33 = /* @__PURE__ */ derived(() => getLocalized("LA.sensor.tooltip"));
      StatComboShort($$anchor2, {
        icon: "cci cci-sensor -alignselfcenter",
        get label() {
          return get$1(expression_31);
        },
        get value() {
          return system.sensor_range;
        },
        outerStyle: ["la-text-text", "-fontsize5"],
        innerStyle: [
          "-divider",
          "-fontsize1",
          "la-prmy-accent",
          "-textaligncenter",
          "-bold"
        ],
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_32);
        },
        get tooltip() {
          return get$1(expression_33);
        },
        get tooltipDirection() {
          return TooltipDirection.RIGHT;
        }
      });
    }, "consequent_3");
    if_block(node_11, ($$render) => {
      showSensors && $$render(consequent_3);
    });
  }
  var node_12 = sibling(div_17, 2);
  {
    var consequent_4 = /* @__PURE__ */ __name(($$anchor2) => {
      const expression_34 = /* @__PURE__ */ derived(checkExecutables);
      MacroDropBox($$anchor2, {
        get uuid() {
          return actor.uuid;
        },
        get getExes() {
          return get$1(expression_34);
        },
        setExes: setSidebarExecutables$1,
        hintDropArea: !0,
        get allowDrop() {
          return get$1(advancedOptions);
        },
        tooltipEnabled,
        get logType() {
          return TextLogHook.PilotHeader;
        },
        get logTypeReset() {
          return TextLogHook.PilotHeaderReset;
        }
      });
    }, "consequent_4");
    if_block(node_12, ($$render) => {
      itemTypes.skill.length && $$render(consequent_4);
    });
  }
  template_effect(
    ($0, $1) => {
      set_text(text2, ` LL${system.level ?? ""} - ${actor.system.callsign ?? ""} `), set_text(text_1, `--${$0 ?? ""}`), set_attribute(div_4, "data-tooltip-class", `clipped-bot la-tooltip ${$1 ?? ""}`), set_attribute(div_4, "data-tooltip-direction", TooltipDirection.RIGHT), set_text(text_2, system.speed);
    },
    [
      () => getLocalized("LA.scan.label"),
      () => getCSSDocumentTheme(actor.uuid)
    ]
  ), append($$anchor, fragment), pop();
}
__name(Sidebar, "Sidebar");
delegate(["change"]);
var root_6$c = /* @__PURE__ */ template('<div class="la-combine-h clipped-bot-alt la-bckg-header-anti -widthfull"><!> <!> <!></div>'), root_5$7 = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull -padding2-l"><!> <!></div>'), root_10$4 = /* @__PURE__ */ template('<!> <div class="la-combine-v -margin3-lr"><!> <!></div>', 1), root_11$4 = /* @__PURE__ */ template("<!> <!> <!> <!> <!> <!>", 1), root_3$8 = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull"></div>');
function Weapon($$anchor, $$props) {
  push($$props, !0);
  const headerOptions = /* @__PURE__ */ __name(($$anchor2) => {
    const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
    CollapseAllButton($$anchor2, {
      collapseID: collID,
      tooltipEnabled,
      get tooltipTheme() {
        return get$1(expression);
      },
      get logType() {
        return TextLogHook.PilotHeader;
      },
      get logTypeReset() {
        return TextLogHook.PilotHeaderReset;
      },
      onPointerEnter: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !0);
      }, "onPointerEnter"),
      onPointerLeave: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !1);
      }, "onPointerLeave")
    });
  }, "headerOptions");
  let collapseAllButtonHover = state(!1), attackButtonHover = state(!1), damageButtonHover = state(!1), messageButtonHover = state(!1), editButtonHover = state(!1);
  const collID = `${$$props.actor.uuid}.weapons`, tooltipEnabled = getPilotSheetTooltipEnabled();
  function getWeaponPath(index2) {
    return `system.loadout.weapons.${index2}.value`;
  }
  __name(getWeaponPath, "getWeaponPath");
  function getRollWeaponTip(weapon) {
    return formatString(getLocalized("LA.flow.rollAttack.template.tooltip"), weapon.name);
  }
  __name(getRollWeaponTip, "getRollWeaponTip");
  function renderOuter(weapon) {
    return weapon.system.sp || isLoading(weapon) || weapon.isLimited() || weapon.system.counters.length;
  }
  __name(renderOuter, "renderOuter");
  const expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.weapons.label"));
  HeaderMain($$anchor, {
    get text() {
      return get$1(expression_1);
    },
    headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-primary"],
    textStyle: [
      "la-text-header",
      "-fontsize2",
      "-overflowhidden"
    ],
    borderStyle: ["la-brdr-primary"],
    extensionTextFunction: /* @__PURE__ */ __name(() => {
      if (get$1(collapseAllButtonHover)) return `--${getLocalized("LA.collapseAll.extension")}`;
    }, "extensionTextFunction"),
    collapseID: collID,
    startCollapsed: !0,
    headerContent: headerOptions,
    children: /* @__PURE__ */ __name(($$anchor2, $$slotProps) => {
      var fragment_2 = comment(), node = first_child(fragment_2);
      {
        var consequent_3 = /* @__PURE__ */ __name(($$anchor3) => {
          var div = root_3$8();
          each(div, 21, () => $$props.weapons, index, ($$anchor4, weapon, index$1) => {
            const outerContent = /* @__PURE__ */ __name(($$anchor5) => {
              var div_1 = root_5$7(), node_1 = child(div_1);
              {
                var consequent = /* @__PURE__ */ __name(($$anchor6) => {
                  var div_2 = root_6$c(), node_2 = child(div_2);
                  const expression_2 = /* @__PURE__ */ derived(() => getWeaponPath(index$1));
                  LoadedBox(node_2, {
                    get item() {
                      return get$1(weapon);
                    },
                    get path() {
                      return get$1(expression_2);
                    },
                    get logType() {
                      return TextLogHook.PilotHeader;
                    },
                    get logTypeReset() {
                      return TextLogHook.PilotHeaderReset;
                    }
                  });
                  var node_3 = sibling(node_2, 2);
                  const expression_3 = /* @__PURE__ */ derived(() => getWeaponPath(index$1));
                  LimitedBox(node_3, {
                    get usesValue() {
                      return get$1(weapon).system.uses.value;
                    },
                    get usesMax() {
                      return get$1(weapon).system.uses.max;
                    },
                    get path() {
                      return get$1(expression_3);
                    },
                    get logType() {
                      return TextLogHook.PilotHeader;
                    },
                    get logTypeReset() {
                      return TextLogHook.PilotHeaderReset;
                    }
                  });
                  var node_4 = sibling(node_3, 2);
                  SPCostArray(node_4, {
                    get cost() {
                      return get$1(weapon).system.sp;
                    }
                  }), append($$anchor6, div_2);
                }, "consequent");
                if_block(node_1, ($$render) => {
                  (isLoading(get$1(weapon)) || get$1(weapon).isLimited() || get$1(weapon).system.sp) && $$render(consequent);
                });
              }
              var node_5 = sibling(node_1, 2);
              {
                var consequent_1 = /* @__PURE__ */ __name(($$anchor6) => {
                  var fragment_3 = comment(), node_6 = first_child(fragment_3);
                  each(node_6, 17, () => get$1(weapon).system.counters, index, ($$anchor7, counter, jndex) => {
                    const expression_4 = /* @__PURE__ */ derived(() => getWeaponPath(index$1));
                    CounterBox($$anchor7, {
                      get text() {
                        return get$1(counter).name;
                      },
                      get type() {
                        return CounterBoxType.Counter;
                      },
                      get usesValue() {
                        return get$1(counter).value;
                      },
                      get usesMax() {
                        return get$1(counter).max;
                      },
                      get path() {
                        return `${get$1(expression_4) ?? ""}.system.counters.${jndex ?? ""}`;
                      },
                      get logType() {
                        return TextLogHook.MechHeader;
                      },
                      get logTypeReset() {
                        return TextLogHook.MechHeaderReset;
                      }
                    });
                  }), append($$anchor6, fragment_3);
                }, "consequent_1");
                if_block(node_5, ($$render) => {
                  get$1(weapon).system.counters.length && $$render(consequent_1);
                });
              }
              append($$anchor5, div_1);
            }, "outerContent"), headerTertiaryLeftOptions = /* @__PURE__ */ __name(($$anchor5) => {
              const expression_5 = /* @__PURE__ */ derived(() => getWeaponPath(index$1)), expression_6 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_7 = /* @__PURE__ */ derived(() => getRollWeaponTip(get$1(weapon))), expression_8 = /* @__PURE__ */ derived(() => getRollWeaponTip(get$1(weapon)));
              AttackButton($$anchor5, {
                iconStyle: [
                  H3_ICON_SIZE,
                  "la-text-header",
                  "cci",
                  "cci-weapon"
                ],
                iconBackgroundStyle: [
                  H3_ICON_SIZE,
                  "la-prmy-secondary",
                  "-pulse-prmy"
                ],
                get flowClass() {
                  return FlowClass.RollAttack;
                },
                get path() {
                  return get$1(expression_5);
                },
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_6);
                },
                get tooltipDirection() {
                  return TooltipDirection.LEFT;
                },
                get tooltip() {
                  return get$1(expression_7);
                },
                get logText() {
                  return get$1(expression_8);
                },
                get logType() {
                  return TextLogHook.PilotHeader;
                },
                get logTypeReset() {
                  return TextLogHook.PilotHeaderReset;
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(attackButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(attackButtonHover, !1);
                }, "onPointerLeave")
              });
            }, "headerTertiaryLeftOptions"), headerTertiaryRightOptions = /* @__PURE__ */ __name(($$anchor5) => {
              var fragment_6 = root_10$4(), node_7 = first_child(fragment_6);
              const expression_9 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
              DamageButton(node_7, {
                iconBackgroundStyle: [
                  "-fontsize7",
                  "la-prmy-secondary",
                  "-pulse-prmy"
                ],
                get flowClass() {
                  return FlowClass.RollDamage;
                },
                get range() {
                  return get$1(weapon).system.range;
                },
                get damage() {
                  return get$1(weapon).system.damage;
                },
                tooltipEnabled,
                get tooltipDirection() {
                  return TooltipDirection.UP;
                },
                get tooltipTheme() {
                  return get$1(expression_9);
                },
                get logType() {
                  return TextLogHook.PilotHeader;
                },
                get logTypeReset() {
                  return TextLogHook.PilotHeaderReset;
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(damageButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(damageButtonHover, !1);
                }, "onPointerLeave")
              });
              var div_3 = sibling(node_7, 2), node_8 = child(div_3);
              const expression_10 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
              MessageButton(node_8, {
                get flowClass() {
                  return FlowClass.SendToChat;
                },
                get uuid() {
                  return get$1(weapon).uuid;
                },
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_10);
                },
                get logType() {
                  return TextLogHook.PilotHeader;
                },
                get logTypeReset() {
                  return TextLogHook.PilotHeaderReset;
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(messageButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(messageButtonHover, !1);
                }, "onPointerLeave")
              });
              var node_9 = sibling(node_8, 2);
              const expression_11 = /* @__PURE__ */ derived(() => getWeaponPath(index$1)), expression_12 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
              EditButton(node_9, {
                get flowClass() {
                  return FlowClass.ContextMenu;
                },
                get path() {
                  return get$1(expression_11);
                },
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_12);
                },
                get logType() {
                  return TextLogHook.PilotHeader;
                },
                get logTypeReset() {
                  return TextLogHook.PilotHeaderReset;
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !1);
                }, "onPointerLeave")
              }), append($$anchor5, fragment_6);
            }, "headerTertiaryRightOptions"), expression_13 = /* @__PURE__ */ derived(() => getLocalized("LA.weapons.label")), expression_14 = /* @__PURE__ */ derived(() => getWeaponPath(index$1)), expression_15 = /* @__PURE__ */ derived(() => renderOuter(get$1(weapon)) ? outerContent : void 0);
            HeaderTertiary($$anchor4, {
              get text() {
                return get$1(weapon).name;
              },
              get subText() {
                return get$1(expression_13);
              },
              subHeaderFontStyle: [
                "la-text-header",
                "la-prmy-header",
                "-fontsize0"
              ],
              borderStyle: ["-bordersoff"],
              extensionTextFunction: /* @__PURE__ */ __name(() => {
                if (get$1(attackButtonHover)) return `--${getLocalized("LA.flow.rollAttack.extension")}`;
                if (get$1(damageButtonHover)) return `--${getLocalized("LA.flow.rollDamage.extension")}`;
                if (get$1(messageButtonHover)) return `--${getLocalized("LA.chat.extension")}`;
                if (get$1(editButtonHover)) return `--${getLocalized("LA.edit.extension")}`;
              }, "extensionTextFunction"),
              headerStyle: [H3_HEADER_STYLE, "la-bckg-pilot"],
              headerFontStyle: ["la-text-header", "-fontsize2"],
              get itemID() {
                return get$1(weapon).id;
              },
              get uuid() {
                return get$1(weapon).uuid;
              },
              get path() {
                return get$1(expression_14);
              },
              acceptTypes: "pilot_weapon",
              get collapseID() {
                return get$1(weapon).uuid;
              },
              startCollapsed: !0,
              get renderOutsideCollapse() {
                return get$1(expression_15);
              },
              contentLeft: headerTertiaryLeftOptions,
              contentRight: headerTertiaryRightOptions,
              children: /* @__PURE__ */ __name(($$anchor5, $$slotProps2) => {
                var fragment_8 = root_11$4(), node_10 = first_child(fragment_8);
                const expression_16 = /* @__PURE__ */ derived(() => `${getWeaponPath(index$1)}.system.bonuses`);
                BonusBox(node_10, {
                  get bonuses() {
                    return get$1(weapon).system.bonuses;
                  },
                  get bonusPath() {
                    return get$1(expression_16);
                  }
                });
                var node_11 = sibling(node_10, 2);
                const expression_17 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
                DeployableBox(node_11, {
                  get source() {
                    return $$props.actor;
                  },
                  get lidSource() {
                    return get$1(weapon).system;
                  },
                  get uuid() {
                    return $$props.actor.uuid;
                  },
                  get sheetUUID() {
                    return $$props.actor.uuid;
                  },
                  tooltipEnabled,
                  get tooltipTheme() {
                    return get$1(expression_17);
                  },
                  get logType() {
                    return TextLogHook.PilotHeader;
                  },
                  get logTypeReset() {
                    return TextLogHook.PilotHeaderReset;
                  }
                });
                var node_12 = sibling(node_11, 2);
                const expression_18 = /* @__PURE__ */ derived(() => `${get$1(weapon).uuid}.actions`), expression_19 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
                ActionBox(node_12, {
                  get actions() {
                    return get$1(weapon).system.actions;
                  },
                  get uuid() {
                    return get$1(weapon).uuid;
                  },
                  path: "system.actions",
                  get collapseID() {
                    return get$1(expression_18);
                  },
                  startCollapsed: !0,
                  tooltipEnabled,
                  get tooltipTheme() {
                    return get$1(expression_19);
                  },
                  get logType() {
                    return TextLogHook.PilotHeader;
                  },
                  get logTypeReset() {
                    return TextLogHook.PilotHeaderReset;
                  }
                });
                var node_13 = sibling(node_12, 2);
                const expression_20 = /* @__PURE__ */ derived(() => getLocalized("LA.description.label"));
                EffectBox(node_13, {
                  get name() {
                    return get$1(expression_20);
                  },
                  get effect() {
                    return get$1(weapon).system.description;
                  },
                  tooltipEnabled,
                  get logType() {
                    return TextLogHook.PilotHeader;
                  },
                  get logTypeReset() {
                    return TextLogHook.PilotHeaderReset;
                  }
                });
                var node_14 = sibling(node_13, 2);
                {
                  var consequent_2 = /* @__PURE__ */ __name(($$anchor6) => {
                    const expression_21 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.system.effect.label"));
                    EffectBox($$anchor6, {
                      get name() {
                        return get$1(expression_21);
                      },
                      get effect() {
                        return get$1(weapon).system.effect;
                      },
                      tooltipEnabled,
                      get logType() {
                        return TextLogHook.PilotHeader;
                      },
                      get logTypeReset() {
                        return TextLogHook.PilotHeaderReset;
                      }
                    });
                  }, "consequent_2");
                  if_block(node_14, ($$render) => {
                    get$1(weapon).system.effect && $$render(consequent_2);
                  });
                }
                var node_15 = sibling(node_14, 2);
                const expression_22 = /* @__PURE__ */ derived(() => `${getWeaponPath(index$1)}.system.tags`);
                TagArray(node_15, {
                  get tags() {
                    return get$1(weapon).system.tags;
                  },
                  get path() {
                    return get$1(expression_22);
                  },
                  justify: "start"
                }), append($$anchor5, fragment_8);
              }, "children"),
              $$slots: { default: !0 }
            });
          }), append($$anchor3, div);
        }, "consequent_3"), alternate = /* @__PURE__ */ __name(($$anchor3) => {
          const expression_23 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.weapon.empty.label")), expression_24 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.weapon.empty.subLabel"));
          EmptyBox($$anchor3, {
            get label() {
              return get$1(expression_23);
            },
            get subLabel() {
              return get$1(expression_24);
            },
            get type() {
              return AcceptType.PilotWeapon;
            },
            get path() {
              return `system.loadout.weapons.${$$props.weapons.length ?? ""}.value`;
            }
          });
        }, "alternate");
        if_block(node, ($$render) => {
          $$props.weapons.length ? $$render(consequent_3) : $$render(alternate, !1);
        });
      }
      append($$anchor2, fragment_2);
    }, "children"),
    $$slots: { default: !0 }
  }), pop();
}
__name(Weapon, "Weapon");
var root_7$7 = /* @__PURE__ */ template('<span class="la-combine-h -justifycenter -aligncenter -fontsize3 -padding0-lr -padding0-tb la-text-header -gap0"> <i class="mdi mdi-heart-half-full -fontsize3"></i></span>'), root_8 = /* @__PURE__ */ template('<span class="la-combine-h -justifycenter -aligncenter -fontsize3 -padding0-lr la-text-header"> <i class="cci cci-role-defender -fontsize4"></i></span>'), root_9$5 = /* @__PURE__ */ template('<span class="la-combine-h -justifycenter -aligncenter -fontsize3 -padding0-lr la-text-header"> <i class="cci cci-evasion -fontsize4"></i></span>'), root_10$3 = /* @__PURE__ */ template('<span class="la-combine-h -justifycenter -aligncenter -fontsize3 -padding0-lr la-text-header"> <i class="cci cci-edef -fontsize4"></i></span>'), root_11$3 = /* @__PURE__ */ template('<span class="la-combine-h -justifycenter -aligncenter -fontsize3 -padding0-lr la-text-header"> <i class="mdi mdi-arrow-right-bold-hexagon-outline -fontsize3"></i></span>'), root_6$b = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull -padding2-l"><div class="la-combine-h clipped-bot-alt la-bckg-header-anti -widthfull -justifyevenly"><!> <!> <!> <!> <!></div> <!></div>'), root_14 = /* @__PURE__ */ template("<i></i>"), root_15 = /* @__PURE__ */ template("<!> <!>", 1), root_16 = /* @__PURE__ */ template("<!> <!> <!> <!> <!> <!>", 1), root_3$7 = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull"></div>');
function Armor($$anchor, $$props) {
  push($$props, !0);
  const headerOptions = /* @__PURE__ */ __name(($$anchor2) => {
    const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
    CollapseAllButton($$anchor2, {
      collapseID: collID,
      tooltipEnabled,
      get tooltipTheme() {
        return get$1(expression);
      },
      onPointerEnter: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !0);
      }, "onPointerEnter"),
      onPointerLeave: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !1);
      }, "onPointerLeave")
    });
  }, "headerOptions");
  let collapseAllButtonHover = state(!1), editButtonHover = state(!1), messageButtonHover = state(!1), [armorBonuses, otherBonuses] = $$props.armors.map((armor) => armor.system.bonuses.reduce(
    (bonusCategories, bonus) => {
      const categoryKey = [
        "pilot_hp",
        "pilot_armor",
        "pilot_evasion",
        "pilot_edef",
        "pilot_speed"
      ].includes(bonus.lid) ? "armorBonuses" : "otherBonuses";
      return bonusCategories[categoryKey][bonus.lid] = bonus.val, bonusCategories;
    },
    { armorBonuses: {}, otherBonuses: {} }
  )).reduce(
    ([armorBns, otherBns], { armorBonuses: armorBonuses2, otherBonuses: otherBonuses2 }) => (Object.keys(armorBonuses2).length > 0 && armorBns.push(armorBonuses2), Object.keys(otherBonuses2).length > 0 && otherBns.push(otherBonuses2), [armorBns, otherBns]),
    [[], []]
  );
  const collID = `${$$props.actor.uuid}.armors`, tooltipEnabled = getPilotSheetTooltipEnabled(), healthTip = TooltipFactory.buildTooltip(getLocalized("LA.pilot.hardsuit.health.tooltip")), evasionTip = TooltipFactory.buildTooltip(getLocalized("LA.pilot.hardsuit.evasion.tooltip")), edefenseTip = TooltipFactory.buildTooltip(getLocalized("LA.pilot.hardsuit.edefense.tooltip")), speedTip = TooltipFactory.buildTooltip(getLocalized("LA.pilot.hardsuit.speed.tooltip")), armorTip = TooltipFactory.buildTooltip(getLocalized("LA.pilot.hardsuit.armor.tooltip"));
  function getArmorPath(index2) {
    return `itemTypes.pilot_armor.${index2}`;
  }
  __name(getArmorPath, "getArmorPath");
  function sendToChat(event2, armor) {
    event2.stopPropagation();
    let chatData = {
      title: armor.name,
      description: armor.system.description
    };
    SendUnknownToChatBase.getInstance().startFlow(armor.uuid, chatData);
  }
  __name(sendToChat, "sendToChat");
  const expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.armor.label"));
  HeaderMain($$anchor, {
    get text() {
      return get$1(expression_1);
    },
    headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-weapon"],
    textStyle: [
      "la-text-header",
      "-fontsize2",
      "-overflowhidden"
    ],
    borderStyle: ["la-brdr-weapon"],
    extensionTextFunction: /* @__PURE__ */ __name(() => {
      if (get$1(collapseAllButtonHover)) return `--${getLocalized("LA.collapseAll.extension")}`;
    }, "extensionTextFunction"),
    collapseID: collID,
    startCollapsed: !0,
    headerContent: headerOptions,
    children: /* @__PURE__ */ __name(($$anchor2, $$slotProps) => {
      var fragment_2 = comment(), node = first_child(fragment_2);
      {
        var consequent_9 = /* @__PURE__ */ __name(($$anchor3) => {
          var div = root_3$7();
          each(div, 21, () => $$props.armors, index, ($$anchor4, armor, index$1) => {
            const outerContent = /* @__PURE__ */ __name(($$anchor5) => {
              var fragment_3 = comment(), node_1 = first_child(fragment_3);
              {
                var consequent_6 = /* @__PURE__ */ __name(($$anchor6) => {
                  var div_1 = root_6$b(), div_2 = child(div_1), node_2 = child(div_2);
                  {
                    var consequent = /* @__PURE__ */ __name(($$anchor7) => {
                      var span = root_7$7();
                      set_attribute(span, "data-tooltip", tooltipEnabled ? healthTip : void 0);
                      var text2 = child(span);
                      template_effect(
                        ($0) => {
                          set_attribute(span, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(span, "data-tooltip-direction", TooltipDirection.DOWN), set_text(text2, `${armorBonuses[index$1].pilot_hp ?? ""} `);
                        },
                        [
                          () => getCSSDocumentTheme($$props.actor.uuid)
                        ]
                      ), append($$anchor7, span);
                    }, "consequent");
                    if_block(node_2, ($$render) => {
                      armorBonuses[index$1].pilot_hp && $$render(consequent);
                    });
                  }
                  var node_3 = sibling(node_2, 2);
                  {
                    var consequent_1 = /* @__PURE__ */ __name(($$anchor7) => {
                      var span_1 = root_8();
                      set_attribute(span_1, "data-tooltip", tooltipEnabled ? armorTip : void 0);
                      var text_1 = child(span_1);
                      template_effect(
                        ($0) => {
                          set_attribute(span_1, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(span_1, "data-tooltip-direction", TooltipDirection.DOWN), set_text(text_1, `${armorBonuses[index$1].pilot_armor ?? ""} `);
                        },
                        [
                          () => getCSSDocumentTheme($$props.actor.uuid)
                        ]
                      ), append($$anchor7, span_1);
                    }, "consequent_1");
                    if_block(node_3, ($$render) => {
                      armorBonuses[index$1].pilot_armor && $$render(consequent_1);
                    });
                  }
                  var node_4 = sibling(node_3, 2);
                  {
                    var consequent_2 = /* @__PURE__ */ __name(($$anchor7) => {
                      var span_2 = root_9$5();
                      set_attribute(span_2, "data-tooltip", tooltipEnabled ? evasionTip : void 0);
                      var text_2 = child(span_2);
                      template_effect(
                        ($0) => {
                          set_attribute(span_2, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(span_2, "data-tooltip-direction", TooltipDirection.DOWN), set_text(text_2, `${armorBonuses[index$1].pilot_evasion ?? ""} `);
                        },
                        [
                          () => getCSSDocumentTheme($$props.actor.uuid)
                        ]
                      ), append($$anchor7, span_2);
                    }, "consequent_2");
                    if_block(node_4, ($$render) => {
                      armorBonuses[index$1].pilot_evasion && $$render(consequent_2);
                    });
                  }
                  var node_5 = sibling(node_4, 2);
                  {
                    var consequent_3 = /* @__PURE__ */ __name(($$anchor7) => {
                      var span_3 = root_10$3();
                      set_attribute(span_3, "data-tooltip", tooltipEnabled ? edefenseTip : void 0);
                      var text_3 = child(span_3);
                      template_effect(
                        ($0) => {
                          set_attribute(span_3, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(span_3, "data-tooltip-direction", TooltipDirection.DOWN), set_text(text_3, `${armorBonuses[index$1].pilot_edef ?? ""} `);
                        },
                        [
                          () => getCSSDocumentTheme($$props.actor.uuid)
                        ]
                      ), append($$anchor7, span_3);
                    }, "consequent_3");
                    if_block(node_5, ($$render) => {
                      armorBonuses[index$1].pilot_edef && $$render(consequent_3);
                    });
                  }
                  var node_6 = sibling(node_5, 2);
                  {
                    var consequent_4 = /* @__PURE__ */ __name(($$anchor7) => {
                      var span_4 = root_11$3();
                      set_attribute(span_4, "data-tooltip", tooltipEnabled ? speedTip : void 0);
                      var text_4 = child(span_4);
                      template_effect(
                        ($0) => {
                          set_attribute(span_4, "data-tooltip-class", `clipped-bot la-tooltip ${$0 ?? ""}`), set_attribute(span_4, "data-tooltip-direction", TooltipDirection.DOWN), set_text(text_4, `${armorBonuses[index$1].pilot_speed ?? ""} `);
                        },
                        [
                          () => getCSSDocumentTheme($$props.actor.uuid)
                        ]
                      ), append($$anchor7, span_4);
                    }, "consequent_4");
                    if_block(node_6, ($$render) => {
                      armorBonuses[index$1].pilot_speed && $$render(consequent_4);
                    });
                  }
                  var node_7 = sibling(div_2, 2);
                  {
                    var consequent_5 = /* @__PURE__ */ __name(($$anchor7) => {
                      var fragment_4 = comment(), node_8 = first_child(fragment_4);
                      each(node_8, 17, () => get$1(armor).system.counters, index, ($$anchor8, counter, jndex) => {
                        const expression_2 = /* @__PURE__ */ derived(() => getArmorPath(index$1));
                        CounterBox($$anchor8, {
                          get text() {
                            return get$1(counter).name;
                          },
                          get type() {
                            return CounterBoxType.Counter;
                          },
                          get usesValue() {
                            return get$1(counter).value;
                          },
                          get usesMax() {
                            return get$1(counter).max;
                          },
                          get path() {
                            return `${get$1(expression_2) ?? ""}.system.counters.${jndex ?? ""}`;
                          },
                          get logType() {
                            return TextLogHook.MechHeader;
                          },
                          get logTypeReset() {
                            return TextLogHook.MechHeaderReset;
                          }
                        });
                      }), append($$anchor7, fragment_4);
                    }, "consequent_5");
                    if_block(node_7, ($$render) => {
                      get$1(armor).system.counters.length && $$render(consequent_5);
                    });
                  }
                  append($$anchor6, div_1);
                }, "consequent_6");
                if_block(node_1, ($$render) => {
                  Object.keys(armorBonuses[index$1]).length && $$render(consequent_6);
                });
              }
              append($$anchor5, fragment_3);
            }, "outerContent"), headerSecondaryLeftOptions2 = /* @__PURE__ */ __name(($$anchor5) => {
              var i2 = root_14();
              set_class(i2, `${H2_ICON_SIZE} cci cci-pilot`), append($$anchor5, i2);
            }, "headerSecondaryLeftOptions"), headerSecondaryRightOptions = /* @__PURE__ */ __name(($$anchor5) => {
              var fragment_6 = root_15(), node_9 = first_child(fragment_6);
              const expression_3 = /* @__PURE__ */ derived(() => getArmorPath(index$1)), expression_4 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
              EditButton(node_9, {
                get flowClass() {
                  return FlowClass.ContextMenu;
                },
                get path() {
                  return get$1(expression_3);
                },
                style: [
                  HEADER_SECONDARY_STYLE,
                  "-padding0-lr"
                ],
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_4);
                },
                get logType() {
                  return TextLogHook.PilotHeader;
                },
                get logTypeReset() {
                  return TextLogHook.PilotHeaderReset;
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !1);
                }, "onPointerLeave")
              });
              var node_10 = sibling(node_9, 2);
              const expression_5 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
              MessageButton(node_10, {
                get flowClass() {
                  return FlowClass.None;
                },
                get uuid() {
                  return get$1(armor).uuid;
                },
                style: [
                  HEADER_SECONDARY_STYLE,
                  "-padding0-lr"
                ],
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_5);
                },
                get logType() {
                  return TextLogHook.PilotHeader;
                },
                get logTypeReset() {
                  return TextLogHook.PilotHeaderReset;
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(messageButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(messageButtonHover, !1);
                }, "onPointerLeave"),
                onClick: /* @__PURE__ */ __name((event2) => sendToChat(event2, get$1(armor)), "onClick")
              }), append($$anchor5, fragment_6);
            }, "headerSecondaryRightOptions"), expression_6 = /* @__PURE__ */ derived(() => getArmorPath(index$1));
            HeaderSecondary($$anchor4, {
              get text() {
                return get$1(armor).name;
              },
              headerStyle: [H2_HEADER_STYLE, "la-bckg-pilot"],
              textStyle: [
                "la-text-header",
                "la-prmy-header",
                "-fontsize2",
                "-overflowhidden"
              ],
              borderStyle: ["-bordersoff"],
              extensionTextFunction: /* @__PURE__ */ __name(() => {
                if (get$1(messageButtonHover)) return `--${getLocalized("LA.chat.extension")}`;
                if (get$1(editButtonHover)) return `--${getLocalized("LA.edit.extension")}`;
              }, "extensionTextFunction"),
              get itemID() {
                return get$1(armor).id;
              },
              get uuid() {
                return get$1(armor).uuid;
              },
              get path() {
                return get$1(expression_6);
              },
              acceptTypes: "pilot_armor",
              get collapseID() {
                return get$1(armor).uuid;
              },
              startCollapsed: !0,
              renderOutsideCollapse: outerContent,
              contentLeft: headerSecondaryLeftOptions2,
              contentRight: headerSecondaryRightOptions,
              children: /* @__PURE__ */ __name(($$anchor5, $$slotProps2) => {
                var fragment_8 = root_16(), node_11 = first_child(fragment_8);
                {
                  var consequent_7 = /* @__PURE__ */ __name(($$anchor6) => {
                    const expression_7 = /* @__PURE__ */ derived(() => `${getArmorPath(index$1)}.system.bonuses`);
                    BonusBox($$anchor6, {
                      bonuses: otherBonuses,
                      get bonusPath() {
                        return get$1(expression_7);
                      }
                    });
                  }, "consequent_7");
                  if_block(node_11, ($$render) => {
                    otherBonuses.length && $$render(consequent_7);
                  });
                }
                var node_12 = sibling(node_11, 2);
                const expression_8 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
                DeployableBox(node_12, {
                  get source() {
                    return $$props.actor;
                  },
                  get lidSource() {
                    return get$1(armor).system;
                  },
                  get uuid() {
                    return $$props.actor.uuid;
                  },
                  get sheetUUID() {
                    return $$props.actor.uuid;
                  },
                  tooltipEnabled,
                  get tooltipTheme() {
                    return get$1(expression_8);
                  },
                  get logType() {
                    return TextLogHook.PilotHeader;
                  },
                  get logTypeReset() {
                    return TextLogHook.PilotHeaderReset;
                  }
                });
                var node_13 = sibling(node_12, 2);
                const expression_9 = /* @__PURE__ */ derived(() => `${get$1(armor).uuid}.actions`), expression_10 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
                ActionBox(node_13, {
                  get actions() {
                    return get$1(armor).system.actions;
                  },
                  get uuid() {
                    return get$1(armor).uuid;
                  },
                  path: "system.actions",
                  get collapseID() {
                    return get$1(expression_9);
                  },
                  startCollapsed: !0,
                  tooltipEnabled,
                  get tooltipTheme() {
                    return get$1(expression_10);
                  },
                  get logType() {
                    return TextLogHook.PilotHeader;
                  },
                  get logTypeReset() {
                    return TextLogHook.PilotHeaderReset;
                  }
                });
                var node_14 = sibling(node_13, 2);
                const expression_11 = /* @__PURE__ */ derived(() => getLocalized("LA.description.label"));
                EffectBox(node_14, {
                  get name() {
                    return get$1(expression_11);
                  },
                  get effect() {
                    return get$1(armor).system.description;
                  },
                  tooltipEnabled,
                  get logType() {
                    return TextLogHook.PilotHeader;
                  },
                  get logTypeReset() {
                    return TextLogHook.PilotHeaderReset;
                  }
                });
                var node_15 = sibling(node_14, 2);
                {
                  var consequent_8 = /* @__PURE__ */ __name(($$anchor6) => {
                    const expression_12 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.system.effect.label"));
                    EffectBox($$anchor6, {
                      get name() {
                        return get$1(expression_12);
                      },
                      get effect() {
                        return get$1(armor).system.effect;
                      },
                      tooltipEnabled,
                      get logType() {
                        return TextLogHook.PilotHeader;
                      },
                      get logTypeReset() {
                        return TextLogHook.PilotHeaderReset;
                      }
                    });
                  }, "consequent_8");
                  if_block(node_15, ($$render) => {
                    get$1(armor).system.effect && $$render(consequent_8);
                  });
                }
                var node_16 = sibling(node_15, 2);
                const expression_13 = /* @__PURE__ */ derived(() => `${getArmorPath(index$1)}.system.tags`);
                TagArray(node_16, {
                  get tags() {
                    return get$1(armor).system.tags;
                  },
                  get path() {
                    return get$1(expression_13);
                  },
                  justify: "start"
                }), append($$anchor5, fragment_8);
              }, "children"),
              $$slots: { default: !0 }
            });
          }), append($$anchor3, div);
        }, "consequent_9"), alternate = /* @__PURE__ */ __name(($$anchor3) => {
          const expression_14 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.hardsuit.empty.label")), expression_15 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.hardsuit.empty.subLabel"));
          EmptyBox($$anchor3, {
            get label() {
              return get$1(expression_14);
            },
            get subLabel() {
              return get$1(expression_15);
            },
            get type() {
              return AcceptType.PilotArmor;
            },
            get path() {
              return `system.loadout.armor.${$$props.armors.length ?? ""}.value`;
            }
          });
        }, "alternate");
        if_block(node, ($$render) => {
          $$props.armors.length ? $$render(consequent_9) : $$render(alternate, !1);
        });
      }
      append($$anchor2, fragment_2);
    }, "children"),
    $$slots: { default: !0 }
  }), pop();
}
__name(Armor, "Armor");
var root_6$a = /* @__PURE__ */ template('<div class="la-combine-h clipped-bot-alt la-bckg-header-anti -widthfull"><!></div>'), root_5$6 = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull -padding2-l"><!> <!></div>'), root_9$4 = /* @__PURE__ */ template("<i></i>"), root_10$2 = /* @__PURE__ */ template("<!> <!>", 1), root_11$2 = /* @__PURE__ */ template("<!> <!> <!> <!> <!> <!>", 1), root_3$6 = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull"></div>');
function Gear($$anchor, $$props) {
  push($$props, !0);
  const headerOptions = /* @__PURE__ */ __name(($$anchor2) => {
    const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
    CollapseAllButton($$anchor2, {
      collapseID: collID,
      tooltipEnabled,
      get tooltipTheme() {
        return get$1(expression);
      },
      onPointerEnter: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !0);
      }, "onPointerEnter"),
      onPointerLeave: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !1);
      }, "onPointerLeave")
    });
  }, "headerOptions");
  let collapseAllButtonHover = state(!1), editButtonHover = state(!1), messageButtonHover = state(!1);
  const collID = `${$$props.actor.uuid}.gears`, tooltipEnabled = getPilotSheetTooltipEnabled();
  function getGearPath(index2) {
    return `system.loadout.gear.${index2}.value`;
  }
  __name(getGearPath, "getGearPath");
  function renderOuter(gear) {
    return gear.system.uses.max || gear.system.counters.length;
  }
  __name(renderOuter, "renderOuter");
  const expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.gear.label"));
  HeaderMain($$anchor, {
    get text() {
      return get$1(expression_1);
    },
    headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-system"],
    textStyle: [
      "la-text-header",
      "-fontsize2",
      "-overflowhidden"
    ],
    borderStyle: ["la-brdr-system"],
    extensionTextFunction: /* @__PURE__ */ __name(() => {
      if (get$1(collapseAllButtonHover)) return `--${getLocalized("LA.collapseAll.extension")}`;
    }, "extensionTextFunction"),
    collapseID: collID,
    startCollapsed: !0,
    headerContent: headerOptions,
    children: /* @__PURE__ */ __name(($$anchor2, $$slotProps) => {
      var fragment_2 = comment(), node = first_child(fragment_2);
      {
        var consequent_3 = /* @__PURE__ */ __name(($$anchor3) => {
          var div = root_3$6();
          each(div, 21, () => $$props.gears, index, ($$anchor4, gear, index$1) => {
            const outerContent = /* @__PURE__ */ __name(($$anchor5) => {
              var div_1 = root_5$6(), node_1 = child(div_1);
              {
                var consequent = /* @__PURE__ */ __name(($$anchor6) => {
                  var div_2 = root_6$a(), node_2 = child(div_2);
                  const expression_2 = /* @__PURE__ */ derived(() => getGearPath(index$1));
                  LimitedBox(node_2, {
                    get usesValue() {
                      return get$1(gear).system.uses.value;
                    },
                    get usesMax() {
                      return get$1(gear).system.uses.max;
                    },
                    get path() {
                      return get$1(expression_2);
                    },
                    get logType() {
                      return TextLogHook.MechHeader;
                    },
                    get logTypeReset() {
                      return TextLogHook.MechHeaderReset;
                    }
                  }), append($$anchor6, div_2);
                }, "consequent");
                if_block(node_1, ($$render) => {
                  get$1(gear).system.uses.max && $$render(consequent);
                });
              }
              var node_3 = sibling(node_1, 2);
              {
                var consequent_1 = /* @__PURE__ */ __name(($$anchor6) => {
                  var fragment_3 = comment(), node_4 = first_child(fragment_3);
                  each(node_4, 17, () => get$1(gear).system.counters, index, ($$anchor7, counter, jndex) => {
                    const expression_3 = /* @__PURE__ */ derived(() => getGearPath(index$1));
                    CounterBox($$anchor7, {
                      get text() {
                        return get$1(counter).name;
                      },
                      get type() {
                        return CounterBoxType.Counter;
                      },
                      get usesValue() {
                        return get$1(counter).value;
                      },
                      get usesMax() {
                        return get$1(counter).max;
                      },
                      get path() {
                        return `${get$1(expression_3) ?? ""}.system.counters.${jndex ?? ""}`;
                      },
                      get logType() {
                        return TextLogHook.MechHeader;
                      },
                      get logTypeReset() {
                        return TextLogHook.MechHeaderReset;
                      }
                    });
                  }), append($$anchor6, fragment_3);
                }, "consequent_1");
                if_block(node_3, ($$render) => {
                  get$1(gear).system.counters.length && $$render(consequent_1);
                });
              }
              append($$anchor5, div_1);
            }, "outerContent"), headerSecondaryLeftOptions2 = /* @__PURE__ */ __name(($$anchor5) => {
              var i2 = root_9$4();
              set_class(i2, `${H2_ICON_SIZE} cci cci-system`), append($$anchor5, i2);
            }, "headerSecondaryLeftOptions"), headerSecondaryRightOptions = /* @__PURE__ */ __name(($$anchor5) => {
              var fragment_5 = root_10$2(), node_5 = first_child(fragment_5);
              const expression_4 = /* @__PURE__ */ derived(() => getGearPath(index$1)), expression_5 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
              EditButton(node_5, {
                get flowClass() {
                  return FlowClass.ContextMenu;
                },
                get path() {
                  return get$1(expression_4);
                },
                style: [
                  HEADER_SECONDARY_STYLE,
                  "-padding0-lr"
                ],
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_5);
                },
                get logType() {
                  return TextLogHook.PilotHeader;
                },
                get logTypeReset() {
                  return TextLogHook.PilotHeaderReset;
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !1);
                }, "onPointerLeave")
              });
              var node_6 = sibling(node_5, 2);
              const expression_6 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
              MessageButton(node_6, {
                get flowClass() {
                  return FlowClass.SendToChat;
                },
                get uuid() {
                  return get$1(gear).uuid;
                },
                style: [
                  HEADER_SECONDARY_STYLE,
                  "-padding0-lr"
                ],
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_6);
                },
                get logType() {
                  return TextLogHook.PilotHeader;
                },
                get logTypeReset() {
                  return TextLogHook.PilotHeaderReset;
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(messageButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(messageButtonHover, !1);
                }, "onPointerLeave")
              }), append($$anchor5, fragment_5);
            }, "headerSecondaryRightOptions"), expression_7 = /* @__PURE__ */ derived(() => getGearPath(index$1)), expression_8 = /* @__PURE__ */ derived(() => renderOuter(get$1(gear)) ? outerContent : void 0);
            HeaderSecondary($$anchor4, {
              get text() {
                return get$1(gear).name;
              },
              headerStyle: [H2_HEADER_STYLE, "la-bckg-pilot"],
              textStyle: [
                "la-text-header",
                "la-prmy-header",
                "-fontsize2",
                "-overflowhidden"
              ],
              borderStyle: ["-bordersoff"],
              extensionTextFunction: /* @__PURE__ */ __name(() => {
                if (get$1(messageButtonHover)) return `--${getLocalized("LA.chat.extension")}`;
                if (get$1(editButtonHover)) return `--${getLocalized("LA.edit.extension")}`;
              }, "extensionTextFunction"),
              get itemID() {
                return get$1(gear).lid;
              },
              get uuid() {
                return get$1(gear).uuid;
              },
              get path() {
                return get$1(expression_7);
              },
              acceptTypes: "pilot_gear",
              get collapseID() {
                return get$1(gear).uuid;
              },
              startCollapsed: !0,
              get renderOutsideCollapse() {
                return get$1(expression_8);
              },
              contentLeft: headerSecondaryLeftOptions2,
              contentRight: headerSecondaryRightOptions,
              children: /* @__PURE__ */ __name(($$anchor5, $$slotProps2) => {
                var fragment_7 = root_11$2(), node_7 = first_child(fragment_7);
                const expression_9 = /* @__PURE__ */ derived(() => `${getGearPath(index$1)}.system.bonuses`);
                BonusBox(node_7, {
                  get bonuses() {
                    return get$1(gear).system.bonuses;
                  },
                  get bonusPath() {
                    return get$1(expression_9);
                  }
                });
                var node_8 = sibling(node_7, 2);
                const expression_10 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
                DeployableBox(node_8, {
                  get source() {
                    return $$props.actor;
                  },
                  get lidSource() {
                    return get$1(gear).system;
                  },
                  get uuid() {
                    return $$props.actor.uuid;
                  },
                  get sheetUUID() {
                    return $$props.actor.uuid;
                  },
                  tooltipEnabled,
                  get tooltipTheme() {
                    return get$1(expression_10);
                  },
                  get logType() {
                    return TextLogHook.PilotHeader;
                  },
                  get logTypeReset() {
                    return TextLogHook.PilotHeaderReset;
                  }
                });
                var node_9 = sibling(node_8, 2);
                const expression_11 = /* @__PURE__ */ derived(() => `${get$1(gear).uuid}.actions`), expression_12 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
                ActionBox(node_9, {
                  get actions() {
                    return get$1(gear).system.actions;
                  },
                  get uuid() {
                    return get$1(gear).uuid;
                  },
                  path: "system.actions",
                  get collapseID() {
                    return get$1(expression_11);
                  },
                  startCollapsed: !0,
                  tooltipEnabled,
                  get tooltipTheme() {
                    return get$1(expression_12);
                  },
                  get logType() {
                    return TextLogHook.PilotHeader;
                  },
                  get logTypeReset() {
                    return TextLogHook.PilotHeaderReset;
                  }
                });
                var node_10 = sibling(node_9, 2);
                const expression_13 = /* @__PURE__ */ derived(() => getLocalized("LA.description.label"));
                EffectBox(node_10, {
                  get name() {
                    return get$1(expression_13);
                  },
                  get effect() {
                    return get$1(gear).system.description;
                  },
                  tooltipEnabled,
                  get logType() {
                    return TextLogHook.PilotHeader;
                  },
                  get logTypeReset() {
                    return TextLogHook.PilotHeaderReset;
                  }
                });
                var node_11 = sibling(node_10, 2);
                {
                  var consequent_2 = /* @__PURE__ */ __name(($$anchor6) => {
                    const expression_14 = /* @__PURE__ */ derived(() => getLocalized("LA.mech.system.effect.label"));
                    EffectBox($$anchor6, {
                      get name() {
                        return get$1(expression_14);
                      },
                      get effect() {
                        return get$1(gear).system.effect;
                      },
                      tooltipEnabled,
                      get logType() {
                        return TextLogHook.PilotHeader;
                      },
                      get logTypeReset() {
                        return TextLogHook.PilotHeaderReset;
                      }
                    });
                  }, "consequent_2");
                  if_block(node_11, ($$render) => {
                    get$1(gear).system.effect && $$render(consequent_2);
                  });
                }
                var node_12 = sibling(node_11, 2);
                const expression_15 = /* @__PURE__ */ derived(() => `${getGearPath(index$1)}.system.tags`);
                TagArray(node_12, {
                  get tags() {
                    return get$1(gear).system.tags;
                  },
                  get path() {
                    return get$1(expression_15);
                  },
                  justify: "start"
                }), append($$anchor5, fragment_7);
              }, "children"),
              $$slots: { default: !0 }
            });
          }), append($$anchor3, div);
        }, "consequent_3"), alternate = /* @__PURE__ */ __name(($$anchor3) => {
          const expression_16 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.gear.empty.label")), expression_17 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.gear.empty.subLabel"));
          EmptyBox($$anchor3, {
            get label() {
              return get$1(expression_16);
            },
            get subLabel() {
              return get$1(expression_17);
            },
            get type() {
              return AcceptType.PilotGear;
            },
            get path() {
              return `system.loadout.gear.${$$props.gears.length ?? ""}.value`;
            }
          });
        }, "alternate");
        if_block(node, ($$render) => {
          $$props.gears.length ? $$render(consequent_3) : $$render(alternate, !1);
        });
      }
      append($$anchor2, fragment_2);
    }, "children"),
    $$slots: { default: !0 }
  }), pop();
}
__name(Gear, "Gear");
var root_7$6 = /* @__PURE__ */ template('<div class="la-combine-h clipped-bot-alt la-bckg-header-anti -widthfull"><!></div>'), root_6$9 = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull -padding2-l"><!> <!></div>'), root_9$3 = /* @__PURE__ */ template("<i></i>"), root_10$1 = /* @__PURE__ */ template("<!> <!>", 1), root_11$1 = /* @__PURE__ */ template("<!> <!> <!> <!> <!>", 1), root_3$5 = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull"></div>');
function Reserve($$anchor, $$props) {
  push($$props, !0);
  const headerOptions = /* @__PURE__ */ __name(($$anchor2) => {
    const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
    CollapseAllButton($$anchor2, {
      collapseID: collID,
      tooltipEnabled,
      get tooltipTheme() {
        return get$1(expression);
      },
      onPointerEnter: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !0);
      }, "onPointerEnter"),
      onPointerLeave: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !1);
      }, "onPointerLeave")
    });
  }, "headerOptions");
  let collapseAllButtonHover = state(!1), editButtonHover = state(!1), messageButtonHover = state(!1);
  const collID = `${$$props.actor.uuid}.reserves`, tooltipEnabled = getPilotSheetTooltipEnabled();
  function getReservePath(index2) {
    return `itemTypes.reserve.${index2}`;
  }
  __name(getReservePath, "getReservePath");
  function updateReserveUses(reserve) {
    reserve.system.used = !reserve.system.used, $$props.actor.updateEmbeddedDocuments("Item", reserve);
  }
  __name(updateReserveUses, "updateReserveUses");
  function getHeaderStyle(reserve) {
    return reserve.system.used ? "la-text-repcap -strikethrough" : "la-text-header";
  }
  __name(getHeaderStyle, "getHeaderStyle");
  const expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.reserve.label"));
  HeaderMain($$anchor, {
    get text() {
      return get$1(expression_1);
    },
    headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-action--downtime"],
    textStyle: [
      "la-text-header",
      "-fontsize2",
      "-overflowhidden"
    ],
    borderStyle: ["la-brdr-action--downtime"],
    extensionTextFunction: /* @__PURE__ */ __name(() => {
      if (get$1(collapseAllButtonHover)) return `--${getLocalized("LA.collapseAll.extension")}`;
    }, "extensionTextFunction"),
    collapseID: collID,
    startCollapsed: !0,
    headerContent: headerOptions,
    children: /* @__PURE__ */ __name(($$anchor2, $$slotProps) => {
      var fragment_2 = comment(), node = first_child(fragment_2);
      {
        var consequent_2 = /* @__PURE__ */ __name(($$anchor3) => {
          var div = root_3$5();
          each(div, 21, () => $$props.reserves, index, ($$anchor4, reserve, index$1) => {
            const outerContent = /* @__PURE__ */ __name(($$anchor5) => {
              var fragment_3 = comment(), node_1 = first_child(fragment_3);
              {
                var consequent_1 = /* @__PURE__ */ __name(($$anchor6) => {
                  var div_1 = root_6$9(), node_2 = child(div_1);
                  {
                    var consequent = /* @__PURE__ */ __name(($$anchor7) => {
                      var div_2 = root_7$6(), node_3 = child(div_2);
                      const expression_2 = /* @__PURE__ */ derived(() => get$1(reserve).system.used ? 0 : 1), expression_3 = /* @__PURE__ */ derived(() => getReservePath(index$1));
                      LimitedBox(node_3, {
                        get usesValue() {
                          return get$1(expression_2);
                        },
                        usesMax: 1,
                        get path() {
                          return `${get$1(expression_3) ?? ""}.system.used`;
                        },
                        onPointerClick: updateReserveUses,
                        get logType() {
                          return TextLogHook.PilotHeader;
                        },
                        get logTypeReset() {
                          return TextLogHook.PilotHeaderReset;
                        }
                      }), append($$anchor7, div_2);
                    }, "consequent");
                    if_block(node_2, ($$render) => {
                      get$1(reserve).system.consumable && $$render(consequent);
                    });
                  }
                  var node_4 = sibling(node_2, 2);
                  each(node_4, 17, () => get$1(reserve).system.counters, index, ($$anchor7, counter, jndex) => {
                    const expression_4 = /* @__PURE__ */ derived(() => getReservePath(index$1));
                    CounterBox($$anchor7, {
                      get text() {
                        return get$1(counter).name;
                      },
                      get type() {
                        return CounterBoxType.Counter;
                      },
                      get usesValue() {
                        return get$1(counter).value;
                      },
                      get usesMax() {
                        return get$1(counter).max;
                      },
                      get path() {
                        return `${get$1(expression_4) ?? ""}.system.counters.${jndex ?? ""}`;
                      },
                      get logType() {
                        return TextLogHook.MechHeader;
                      },
                      get logTypeReset() {
                        return TextLogHook.MechHeaderReset;
                      }
                    });
                  }), append($$anchor6, div_1);
                }, "consequent_1");
                if_block(node_1, ($$render) => {
                  (get$1(reserve).system.counters.length || get$1(reserve).system.consumable) && $$render(consequent_1);
                });
              }
              append($$anchor5, fragment_3);
            }, "outerContent"), headerSecondaryLeftOptions2 = /* @__PURE__ */ __name(($$anchor5) => {
              var i2 = root_9$3();
              template_effect(() => set_class(i2, `${H2_ICON_SIZE} cci ${RESERVE_ICON_MAP[get$1(reserve).system.type] ?? ""}`)), append($$anchor5, i2);
            }, "headerSecondaryLeftOptions"), headerSecondaryRightOptions = /* @__PURE__ */ __name(($$anchor5) => {
              var fragment_5 = root_10$1(), node_5 = first_child(fragment_5);
              const expression_5 = /* @__PURE__ */ derived(() => getReservePath(index$1)), expression_6 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
              EditButton(node_5, {
                get flowClass() {
                  return FlowClass.ContextMenu;
                },
                get path() {
                  return get$1(expression_5);
                },
                style: [
                  HEADER_SECONDARY_STYLE,
                  "-padding0-lr"
                ],
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_6);
                },
                get logType() {
                  return TextLogHook.PilotHeader;
                },
                get logTypeReset() {
                  return TextLogHook.PilotHeaderReset;
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !1);
                }, "onPointerLeave")
              });
              var node_6 = sibling(node_5, 2);
              const expression_7 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
              MessageButton(node_6, {
                get flowClass() {
                  return FlowClass.SendToChat;
                },
                get uuid() {
                  return get$1(reserve).uuid;
                },
                style: [
                  HEADER_SECONDARY_STYLE,
                  "-padding0-lr"
                ],
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_7);
                },
                get logType() {
                  return TextLogHook.PilotHeader;
                },
                get logTypeReset() {
                  return TextLogHook.PilotHeaderReset;
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(messageButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(messageButtonHover, !1);
                }, "onPointerLeave")
              }), append($$anchor5, fragment_5);
            }, "headerSecondaryRightOptions"), expression_8 = /* @__PURE__ */ derived(() => [
              getHeaderStyle(get$1(reserve)),
              "-fontsize2",
              "-overflowhidden"
            ]), expression_9 = /* @__PURE__ */ derived(() => getReservePath(index$1));
            HeaderSecondary($$anchor4, {
              get text() {
                return get$1(reserve).name;
              },
              headerStyle: [H2_HEADER_STYLE, "la-bckg-pilot"],
              get textStyle() {
                return get$1(expression_8);
              },
              borderStyle: ["-bordersoff"],
              extensionTextFunction: /* @__PURE__ */ __name(() => {
                if (get$1(messageButtonHover)) return `--${getLocalized("LA.chat.extension")}`;
                if (get$1(editButtonHover)) return `--${getLocalized("LA.edit.extension")}`;
              }, "extensionTextFunction"),
              get itemID() {
                return get$1(reserve).lid;
              },
              get uuid() {
                return get$1(reserve).uuid;
              },
              get path() {
                return get$1(expression_9);
              },
              acceptTypes: "reserve",
              get collapseID() {
                return get$1(reserve).uuid;
              },
              startCollapsed: !0,
              renderOutsideCollapse: outerContent,
              contentLeft: headerSecondaryLeftOptions2,
              contentRight: headerSecondaryRightOptions,
              children: /* @__PURE__ */ __name(($$anchor5, $$slotProps2) => {
                var fragment_7 = root_11$1(), node_7 = first_child(fragment_7);
                const expression_10 = /* @__PURE__ */ derived(() => `${getReservePath(index$1)}.system.bonuses`);
                BonusBox(node_7, {
                  get bonuses() {
                    return get$1(reserve).system.bonuses;
                  },
                  get bonusPath() {
                    return get$1(expression_10);
                  }
                });
                var node_8 = sibling(node_7, 2);
                const expression_11 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
                DeployableBox(node_8, {
                  get source() {
                    return $$props.actor;
                  },
                  get lidSource() {
                    return get$1(reserve).system;
                  },
                  get uuid() {
                    return $$props.actor.uuid;
                  },
                  get sheetUUID() {
                    return $$props.actor.uuid;
                  },
                  tooltipEnabled,
                  get tooltipTheme() {
                    return get$1(expression_11);
                  },
                  get logType() {
                    return TextLogHook.PilotHeader;
                  },
                  get logTypeReset() {
                    return TextLogHook.PilotHeaderReset;
                  }
                });
                var node_9 = sibling(node_8, 2);
                const expression_12 = /* @__PURE__ */ derived(() => `${get$1(reserve).uuid}.actions`), expression_13 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
                ActionBox(node_9, {
                  get actions() {
                    return get$1(reserve).system.actions;
                  },
                  get uuid() {
                    return get$1(reserve).uuid;
                  },
                  path: "system.actions",
                  get collapseID() {
                    return get$1(expression_12);
                  },
                  startCollapsed: !0,
                  tooltipEnabled,
                  get tooltipTheme() {
                    return get$1(expression_13);
                  },
                  get logType() {
                    return TextLogHook.PilotHeader;
                  },
                  get logTypeReset() {
                    return TextLogHook.PilotHeaderReset;
                  }
                });
                var node_10 = sibling(node_9, 2);
                const expression_14 = /* @__PURE__ */ derived(() => getLocalized("LA.description.label"));
                EffectBox(node_10, {
                  get name() {
                    return get$1(expression_14);
                  },
                  get effect() {
                    return get$1(reserve).system.description;
                  },
                  tooltipEnabled,
                  get logType() {
                    return TextLogHook.PilotHeader;
                  },
                  get logTypeReset() {
                    return TextLogHook.PilotHeaderReset;
                  }
                });
                var node_11 = sibling(node_10, 2);
                const expression_15 = /* @__PURE__ */ derived(() => `${getReservePath(index$1)}.system.tags`);
                TagArray(node_11, {
                  get tags() {
                    return get$1(reserve).system.tags;
                  },
                  get path() {
                    return get$1(expression_15);
                  },
                  justify: "start"
                }), append($$anchor5, fragment_7);
              }, "children"),
              $$slots: { default: !0 }
            });
          }), append($$anchor3, div);
        }, "consequent_2"), alternate = /* @__PURE__ */ __name(($$anchor3) => {
          const expression_16 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.reserve.empty.label")), expression_17 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.reserve.empty.subLabel"));
          EmptyBox($$anchor3, {
            get label() {
              return get$1(expression_16);
            },
            get subLabel() {
              return get$1(expression_17);
            },
            get type() {
              return AcceptType.Reserve;
            },
            get path() {
              return `itemTypes.reserve.${$$props.reserves.length ?? ""}`;
            }
          });
        }, "alternate");
        if_block(node, ($$render) => {
          $$props.reserves.length ? $$render(consequent_2) : $$render(alternate, !1);
        });
      }
      append($$anchor2, fragment_2);
    }, "children"),
    $$slots: { default: !0 }
  }), pop();
}
__name(Reserve, "Reserve");
var root$e = /* @__PURE__ */ template("<!> <!> <!> <!>", 1);
function Equipment($$anchor, $$props) {
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor, itemTypes } = props;
  var fragment = root$e(), node = first_child(fragment);
  Weapon(node, {
    actor,
    get weapons() {
      return itemTypes.pilot_weapon;
    }
  });
  var node_1 = sibling(node, 2);
  Armor(node_1, {
    actor,
    get armors() {
      return itemTypes.pilot_armor;
    }
  });
  var node_2 = sibling(node_1, 2);
  Gear(node_2, {
    actor,
    get gears() {
      return itemTypes.pilot_gear;
    }
  });
  var node_3 = sibling(node_2, 2);
  Reserve(node_3, {
    actor,
    get reserves() {
      return itemTypes.reserve;
    }
  }), append($$anchor, fragment);
}
__name(Equipment, "Equipment");
var root_6$8 = /* @__PURE__ */ template('<div class="-padding2-l"><!></div>'), root_7$5 = /* @__PURE__ */ template('<i class="mdi mdi-weather-night -fontsize3 -padding0"></i>'), root_5$5 = /* @__PURE__ */ template('<div class="la-combine-v -widthfull"><!></div>'), root_4$5 = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull"></div>');
function Burden($$anchor, $$props) {
  push($$props, !0);
  let editButtonHover = state(!1), addButtonHover = state(!1);
  const collID = `${$$props.actor.uuid}.burdens`, burdens = $$props.system.bond_state.burdens, addBurdenTip = TooltipFactory.buildTooltip(getLocalized("LA.pilot.bond.burden.add.tooltip")), tooltipEnabled = getPilotSheetTooltipEnabled();
  function getBurdenPath(index2) {
    return `system.bond_state.burdens.${index2}`;
  }
  __name(getBurdenPath, "getBurdenPath");
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent_1 = /* @__PURE__ */ __name(($$anchor2) => {
      const headerContent = /* @__PURE__ */ __name(($$anchor3) => {
        const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.bond.burden.add.tooltip")), expression_2 = /* @__PURE__ */ derived(() => $$props.system.bond === null);
        GlyphButton($$anchor3, {
          style: [
            "mdi mdi-plus-circle-outline",
            "-fontsize3",
            "-height2",
            "-lineheight2",
            "la-prmy-header -glow-prmy la-scdy-primary -glow-scdy-hover"
          ],
          get flowClass() {
            return FlowClass.GeneralControl;
          },
          path: "system.bond_state.burdens",
          action: "append",
          actionValue: "(struct)counter",
          tooltipEnabled,
          get tooltipTheme() {
            return get$1(expression);
          },
          tooltip: addBurdenTip,
          get tooltipDirection() {
            return TooltipDirection.UP;
          },
          get logText() {
            return get$1(expression_1);
          },
          get logType() {
            return TextLogHook.PilotHeader;
          },
          get logTypeReset() {
            return TextLogHook.PilotHeaderReset;
          },
          get disabled() {
            return get$1(expression_2);
          },
          onPointerEnter: /* @__PURE__ */ __name(() => {
            set(addButtonHover, !0);
          }, "onPointerEnter"),
          onPointerLeave: /* @__PURE__ */ __name(() => {
            set(addButtonHover, !1);
          }, "onPointerLeave")
        });
      }, "headerContent"), expression_3 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.bond.burden.label"));
      HeaderMain($$anchor2, {
        get text() {
          return get$1(expression_3);
        },
        headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-weapon"],
        textStyle: [
          "la-text-header",
          "-fontsize2",
          "-overflowhidden"
        ],
        borderStyle: ["la-brdr-weapon"],
        extensionTextFunction: /* @__PURE__ */ __name(() => {
          if (get$1(addButtonHover)) return `--${getLocalized("LA.add.extension")}`;
        }, "extensionTextFunction"),
        collapseID: collID,
        startCollapsed: !0,
        headerContent,
        children: /* @__PURE__ */ __name(($$anchor3, $$slotProps) => {
          var fragment_3 = comment(), node_1 = first_child(fragment_3);
          {
            var consequent = /* @__PURE__ */ __name(($$anchor4) => {
              var div = root_4$5();
              each(div, 21, () => burdens, index, ($$anchor5, burden, index2) => {
                var div_1 = root_5$5();
                {
                  const outerContent = /* @__PURE__ */ __name(($$anchor6) => {
                    var div_2 = root_6$8(), node_2 = child(div_2);
                    CounterBox(node_2, {
                      get type() {
                        return CounterBoxType.Counter;
                      },
                      get usesValue() {
                        return get$1(burden).value;
                      },
                      get usesMax() {
                        return get$1(burden).max;
                      },
                      path: `system.bond_state.burdens.${index2 ?? ""}`,
                      style: [
                        "clipped-bot-alt",
                        "-widthfull",
                        "la-bckg-header-anti"
                      ],
                      get logType() {
                        return TextLogHook.PilotHeader;
                      },
                      get logTypeReset() {
                        return TextLogHook.PilotHeaderReset;
                      }
                    }), append($$anchor6, div_2);
                  }, "outerContent"), headerSecondaryLeftOptions2 = /* @__PURE__ */ __name(($$anchor6) => {
                    var i2 = root_7$5();
                    append($$anchor6, i2);
                  }, "headerSecondaryLeftOptions"), headerSecondaryRightOptions = /* @__PURE__ */ __name(($$anchor6) => {
                    const expression_4 = /* @__PURE__ */ derived(() => getBurdenPath(index2)), expression_5 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
                    EditButton($$anchor6, {
                      get flowClass() {
                        return FlowClass.ContextMenu;
                      },
                      get path() {
                        return get$1(expression_4);
                      },
                      style: [
                        HEADER_SECONDARY_STYLE,
                        "-padding0-lr"
                      ],
                      tooltipEnabled,
                      get tooltipTheme() {
                        return get$1(expression_5);
                      },
                      get logType() {
                        return TextLogHook.PilotHeader;
                      },
                      get logTypeReset() {
                        return TextLogHook.PilotHeaderReset;
                      },
                      onPointerEnter: /* @__PURE__ */ __name(() => {
                        set(editButtonHover, !0);
                      }, "onPointerEnter"),
                      onPointerLeave: /* @__PURE__ */ __name(() => {
                        set(editButtonHover, !1);
                      }, "onPointerLeave")
                    });
                  }, "headerSecondaryRightOptions");
                  var node_3 = child(div_1);
                  HeaderSecondary(node_3, {
                    get text() {
                      return get$1(burden).name;
                    },
                    headerStyle: [H2_HEADER_STYLE, "la-bckg-pilot"],
                    textStyle: [
                      "la-text-header",
                      "la-prmy-header",
                      "-fontsize2",
                      "-overflowhidden"
                    ],
                    borderStyle: ["-bordersoff"],
                    extensionTextFunction: /* @__PURE__ */ __name(() => {
                      if (get$1(editButtonHover)) return `--${getLocalized("LA.edit.extension")}`;
                    }, "extensionTextFunction"),
                    get itemID() {
                      return get$1(burden).lid;
                    },
                    get uuid() {
                      return get$1(burden).uuid;
                    },
                    renderOutsideCollapse: outerContent,
                    contentLeft: headerSecondaryLeftOptions2,
                    contentRight: headerSecondaryRightOptions
                  });
                }
                append($$anchor5, div_1);
              }), append($$anchor4, div);
            }, "consequent"), alternate = /* @__PURE__ */ __name(($$anchor4) => {
              const expression_6 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.bond.burden.empty.label")), expression_7 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.bond.burden.empty.subLabel"));
              EmptyBox($$anchor4, {
                get label() {
                  return get$1(expression_6);
                },
                get subLabel() {
                  return get$1(expression_7);
                }
              });
            }, "alternate");
            if_block(node_1, ($$render) => {
              burdens.length ? $$render(consequent) : $$render(alternate, !1);
            });
          }
          append($$anchor3, fragment_3);
        }, "children"),
        $$slots: { default: !0 }
      });
    }, "consequent_1");
    if_block(node, ($$render) => {
      $$props.system.bond && $$render(consequent_1);
    });
  }
  append($$anchor, fragment), pop();
}
__name(Burden, "Burden");
var root_2$3 = /* @__PURE__ */ template('<button type="button" class="la-prmy-header -glow-prmy la-scdy-primary -glow-scdy-hover -fontsize5"><i></i></button>'), root_1$5 = /* @__PURE__ */ template(`<div class="la-limited la-combine-h la-text-header 
        -aligncenter -padding1-lr"><span class="la-hexarray__span -fontsize1"> </span> <!></div>`);
function LimitedBondBox($$anchor, $$props) {
  push($$props, !0);
  const logging = $$props.logType && $$props.logTypeReset, log = $$props.logText || getLocalized("LA.limited.tooltip");
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent = /* @__PURE__ */ __name(($$anchor2) => {
      var div = root_1$5(), span = child(div), text2 = child(span), node_1 = sibling(span, 2);
      each(node_1, 17, () => ({ length: $$props.usesMax }), index, ($$anchor3, _, index2) => {
        var button = root_2$3(), i2 = child(button);
        template_effect(
          ($0) => {
            set_attribute(button, "aria-label", $0), set_class(i2, `mdi ${(index2 < $$props.usesValue ? "mdi-hexagon-slice-6" : "mdi-hexagon-outline") ?? ""}
                power-uses-hex`), set_attribute(i2, "data-available", index2 < $$props.usesValue), set_attribute(i2, "data-uuid", $$props.uuid), set_attribute(i2, "data-power-index", $$props.power), set_attribute(i2, "data-path", `system.bond.system.powers.${$$props.power}`);
          },
          [() => getLocalized("LA.use.label")]
        ), event("pointerenter", button, function(...$$args) {
          var _a;
          (_a = logging ? (event2) => sendToLog(event2, log, $$props.logType) : void 0) == null || _a.apply(this, $$args);
        }), event("pointerleave", button, function(...$$args) {
          var _a;
          (_a = logging ? (event2) => resetLog(event2, $$props.logTypeReset) : void 0) == null || _a.apply(this, $$args);
        }), append($$anchor3, button);
      }), template_effect(($0) => set_text(text2, $0), [() => getLocalized("LA.limited.label")]), append($$anchor2, div);
    }, "consequent");
    if_block(node, ($$render) => {
      $$props.usesMax && $$render(consequent);
    });
  }
  append($$anchor, fragment), pop();
}
__name(LimitedBondBox, "LimitedBondBox");
var root_9$2 = /* @__PURE__ */ template('<span class="la-text-header -aligncontentcenter -fontsize0 -upper"> </span>'), root_7$4 = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull -padding2-l"><div class="la-combine-h clipped-bot-alt la-bckg-header-anti -widthfull"><!> <!></div></div>'), root_12 = /* @__PURE__ */ template('<span class="-fontsize0 -letterspacing0"> </span>'), root_13 = /* @__PURE__ */ template('<span class="-fontsize0 -letterspacing0"> </span>'), root_11 = /* @__PURE__ */ template('<span class="la-combine-h -gap0 -padding2-r"><!> <!></span> <!>', 1), root_4$4 = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull"></div>');
function Power($$anchor, $$props) {
  var _a, _b;
  push($$props, !0);
  let collapseAllButtonHover = state(!1), effectButtonHover = state(!1), messageButtonHover = state(!1);
  const unlockedPowers = ((_a = $$props.system.bond) == null ? void 0 : _a.system.powers.map((power, index2) => ({ ...power, index: index2 })).filter((power) => power.unlocked)) || [], tooltipEnabled = getPilotSheetTooltipEnabled(), bondUUID = (_b = $$props.system.bond) == null ? void 0 : _b.uuid, collID = `${$$props.actor.uuid}.powers`;
  function getPowerCollapseID(index2) {
    return `${$$props.actor.uuid}.powers.${index2}`;
  }
  __name(getPowerCollapseID, "getPowerCollapseID");
  function sendToChat(event2, power) {
    event2.stopPropagation();
    let chatData = {
      title: power.name,
      description: power.description
    };
    SendUnknownToChatBase.getInstance().startFlow($$props.actor.uuid, chatData);
  }
  __name(sendToChat, "sendToChat");
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent_6 = /* @__PURE__ */ __name(($$anchor2) => {
      const headerOptions = /* @__PURE__ */ __name(($$anchor3) => {
        const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
        CollapseAllButton($$anchor3, {
          collapseID: collID,
          tooltipEnabled,
          get tooltipTheme() {
            return get$1(expression);
          },
          onPointerEnter: /* @__PURE__ */ __name(() => {
            set(collapseAllButtonHover, !0);
          }, "onPointerEnter"),
          onPointerLeave: /* @__PURE__ */ __name(() => {
            set(collapseAllButtonHover, !1);
          }, "onPointerLeave")
        });
      }, "headerOptions"), expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.bond.power.label"));
      HeaderMain($$anchor2, {
        get text() {
          return get$1(expression_1);
        },
        headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-primary"],
        textStyle: [
          "la-text-header",
          "-fontsize2",
          "-overflowhidden"
        ],
        borderStyle: ["la-brdr-primary"],
        extensionTextFunction: /* @__PURE__ */ __name(() => {
          if (get$1(collapseAllButtonHover)) return `--${getLocalized("LA.collapseAll.extension")}`;
        }, "extensionTextFunction"),
        collapseID: collID,
        startCollapsed: !0,
        headerContent: headerOptions,
        children: /* @__PURE__ */ __name(($$anchor3, $$slotProps) => {
          var fragment_3 = comment(), node_1 = first_child(fragment_3);
          {
            var consequent_5 = /* @__PURE__ */ __name(($$anchor4) => {
              var div = root_4$4();
              each(div, 21, () => unlockedPowers, index, ($$anchor5, power) => {
                const outerContent = /* @__PURE__ */ __name(($$anchor6) => {
                  var fragment_4 = comment(), node_2 = first_child(fragment_4);
                  {
                    var consequent_2 = /* @__PURE__ */ __name(($$anchor7) => {
                      var div_1 = root_7$4(), div_2 = child(div_1), node_3 = child(div_2);
                      {
                        var consequent = /* @__PURE__ */ __name(($$anchor8) => {
                          LimitedBondBox($$anchor8, {
                            get usesValue() {
                              return get$1(power).uses.value;
                            },
                            get usesMax() {
                              return get$1(power).uses.max;
                            },
                            uuid: bondUUID,
                            get power() {
                              return get$1(power).index;
                            }
                          });
                        }, "consequent");
                        if_block(node_3, ($$render) => {
                          get$1(power).uses && $$render(consequent);
                        });
                      }
                      var node_4 = sibling(node_3, 2);
                      {
                        var consequent_1 = /* @__PURE__ */ __name(($$anchor8) => {
                          var span = root_9$2(), text2 = child(span);
                          template_effect(() => set_text(text2, get$1(power).frequency)), append($$anchor8, span);
                        }, "consequent_1");
                        if_block(node_4, ($$render) => {
                          get$1(power).frequency && $$render(consequent_1);
                        });
                      }
                      append($$anchor7, div_1);
                    }, "consequent_2");
                    if_block(node_2, ($$render) => {
                      (get$1(power).uses || get$1(power).frequency) && $$render(consequent_2);
                    });
                  }
                  append($$anchor6, fragment_4);
                }, "outerContent"), headerSecondaryLeftOptions2 = /* @__PURE__ */ __name(($$anchor6) => {
                  const expression_2 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_3 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.bond.power.subLabel"));
                  EffectButton($$anchor6, {
                    iconStyle: [
                      "la-text-header",
                      "-fontsize4",
                      "mdi",
                      "mdi-weather-sunny"
                    ],
                    iconBackgroundStyle: [
                      "-fontsize5",
                      "la-prmy-secondary",
                      "-pulse-prmy"
                    ],
                    get flowClass() {
                      return FlowClass.BondPower;
                    },
                    uuid: bondUUID,
                    get powerIndex() {
                      return get$1(power).index;
                    },
                    tooltipEnabled,
                    get tooltipTheme() {
                      return get$1(expression_2);
                    },
                    get tooltipDirection() {
                      return TooltipDirection.LEFT;
                    },
                    get tooltip() {
                      return get$1(power).description;
                    },
                    get tooltipHeader() {
                      return get$1(expression_3);
                    },
                    get logType() {
                      return TextLogHook.PilotHeader;
                    },
                    get logTypeReset() {
                      return TextLogHook.PilotHeaderReset;
                    },
                    onPointerEnter: /* @__PURE__ */ __name(() => {
                      set(effectButtonHover, !0);
                    }, "onPointerEnter"),
                    onPointerLeave: /* @__PURE__ */ __name(() => {
                      set(effectButtonHover, !1);
                    }, "onPointerLeave")
                  });
                }, "headerSecondaryLeftOptions"), headerSecondaryRightOptions = /* @__PURE__ */ __name(($$anchor6) => {
                  var fragment_7 = root_11(), span_1 = first_child(fragment_7), node_5 = child(span_1);
                  {
                    var consequent_3 = /* @__PURE__ */ __name(($$anchor7) => {
                      var span_2 = root_12(), text_1 = child(span_2);
                      template_effect(($0) => set_text(text_1, $0), [
                        () => getLocalized("LA.pilot.bond.power.veteran.label")
                      ]), append($$anchor7, span_2);
                    }, "consequent_3");
                    if_block(node_5, ($$render) => {
                      get$1(power).veteran && $$render(consequent_3);
                    });
                  }
                  var node_6 = sibling(node_5, 2);
                  {
                    var consequent_4 = /* @__PURE__ */ __name(($$anchor7) => {
                      var span_3 = root_13(), text_2 = child(span_3);
                      template_effect(($0) => set_text(text_2, $0), [
                        () => getLocalized("LA.pilot.bond.power.master.label")
                      ]), append($$anchor7, span_3);
                    }, "consequent_4");
                    if_block(node_6, ($$render) => {
                      get$1(power).master && $$render(consequent_4);
                    });
                  }
                  var node_7 = sibling(span_1, 2);
                  const expression_4 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
                  MessageButton(node_7, {
                    get flowClass() {
                      return FlowClass.None;
                    },
                    get uuid() {
                      return get$1(power).uuid;
                    },
                    style: [
                      HEADER_SECONDARY_STYLE,
                      "-padding0-lr"
                    ],
                    tooltipEnabled,
                    get tooltipTheme() {
                      return get$1(expression_4);
                    },
                    get logType() {
                      return TextLogHook.PilotHeader;
                    },
                    get logTypeReset() {
                      return TextLogHook.PilotHeaderReset;
                    },
                    onPointerEnter: /* @__PURE__ */ __name(() => {
                      set(messageButtonHover, !0);
                    }, "onPointerEnter"),
                    onPointerLeave: /* @__PURE__ */ __name(() => {
                      set(messageButtonHover, !1);
                    }, "onPointerLeave"),
                    onClick: /* @__PURE__ */ __name((event2) => sendToChat(event2, get$1(power)), "onClick")
                  }), append($$anchor6, fragment_7);
                }, "headerSecondaryRightOptions"), expression_5 = /* @__PURE__ */ derived(() => getPowerCollapseID(get$1(power).index));
                HeaderSecondary($$anchor5, {
                  get text() {
                    return get$1(power).name;
                  },
                  headerStyle: [H2_HEADER_STYLE, "la-bckg-pilot"],
                  textStyle: [
                    "la-text-header",
                    "la-prmy-header",
                    "-fontsize2",
                    "-overflowhidden"
                  ],
                  borderStyle: ["-bordersoff"],
                  extensionTextFunction: /* @__PURE__ */ __name(() => {
                    if (get$1(effectButtonHover)) return `--${getLocalized("LA.use.label")}`;
                    if (get$1(messageButtonHover)) return `--${getLocalized("LA.chat.extension")}`;
                  }, "extensionTextFunction"),
                  get itemID() {
                    return get$1(power).lid;
                  },
                  get uuid() {
                    return get$1(power).uuid;
                  },
                  get collapseID() {
                    return get$1(expression_5);
                  },
                  startCollapsed: !0,
                  renderOutsideCollapse: outerContent,
                  contentLeft: headerSecondaryLeftOptions2,
                  contentRight: headerSecondaryRightOptions,
                  children: /* @__PURE__ */ __name(($$anchor6, $$slotProps2) => {
                    const expression_6 = /* @__PURE__ */ derived(() => getLocalized("LA.description.label"));
                    EffectBox($$anchor6, {
                      get name() {
                        return get$1(expression_6);
                      },
                      get effect() {
                        return get$1(power).description;
                      },
                      tooltipEnabled,
                      get logType() {
                        return TextLogHook.PilotHeader;
                      },
                      get logTypeReset() {
                        return TextLogHook.PilotHeaderReset;
                      }
                    });
                  }, "children"),
                  $$slots: { default: !0 }
                });
              }), append($$anchor4, div);
            }, "consequent_5"), alternate = /* @__PURE__ */ __name(($$anchor4) => {
              const expression_7 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.bond.power.empty.label")), expression_8 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.bond.power.empty.subLabel"));
              EmptyBox($$anchor4, {
                get label() {
                  return get$1(expression_7);
                },
                get subLabel() {
                  return get$1(expression_8);
                }
              });
            }, "alternate");
            if_block(node_1, ($$render) => {
              unlockedPowers.length ? $$render(consequent_5) : $$render(alternate, !1);
            });
          }
          append($$anchor3, fragment_3);
        }, "children"),
        $$slots: { default: !0 }
      });
    }, "consequent_6");
    if_block(node, ($$render) => {
      $$props.system.bond && $$render(consequent_6);
    });
  }
  append($$anchor, fragment), pop();
}
__name(Power, "Power");
var root_5$4 = /* @__PURE__ */ template('<div class="-padding2-l"><!></div>'), root_6$7 = /* @__PURE__ */ template('<i class="mdi mdi-progress-clock -fontsize3 -padding0"></i>'), root_4$3 = /* @__PURE__ */ template('<div class="la-combine-v -widthfull"><!></div>'), root_3$4 = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull"></div>');
function Clock($$anchor, $$props) {
  push($$props, !0);
  const headerContent = /* @__PURE__ */ __name(($$anchor2) => {
    const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.bond.clock.add.tooltip"));
    GlyphButton($$anchor2, {
      style: [
        "mdi mdi-plus-circle-outline",
        "-fontsize3",
        "-height2",
        "-lineheight2",
        "la-prmy-header -glow-prmy la-scdy-primary -glow-scdy-hover"
      ],
      get flowClass() {
        return FlowClass.GeneralControl;
      },
      path: "system.bond_state.clocks",
      action: "append",
      actionValue: "(struct)counter",
      tooltipEnabled,
      get tooltipTheme() {
        return get$1(expression);
      },
      tooltip: addClockTip,
      get tooltipDirection() {
        return TooltipDirection.UP;
      },
      get logText() {
        return get$1(expression_1);
      },
      get logType() {
        return TextLogHook.PilotHeader;
      },
      get logTypeReset() {
        return TextLogHook.PilotHeaderReset;
      },
      onPointerEnter: /* @__PURE__ */ __name(() => {
        set(addButtonHover, !0);
      }, "onPointerEnter"),
      onPointerLeave: /* @__PURE__ */ __name(() => {
        set(addButtonHover, !1);
      }, "onPointerLeave")
    });
  }, "headerContent");
  let editButtonHover = state(!1), addButtonHover = state(!1);
  const collID = `${$$props.actor.uuid}.clocks`, clocks = $$props.system.bond_state.clocks, addClockTip = TooltipFactory.buildTooltip(getLocalized("LA.pilot.bond.clock.add.tooltip")), tooltipEnabled = getPilotSheetTooltipEnabled();
  function getClockPath(index2) {
    return `system.bond_state.clocks.${index2}`;
  }
  __name(getClockPath, "getClockPath");
  const expression_2 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.bond.clock.label"));
  HeaderMain($$anchor, {
    get text() {
      return get$1(expression_2);
    },
    headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-weapon"],
    textStyle: [
      "la-text-header",
      "-fontsize2",
      "-overflowhidden"
    ],
    borderStyle: ["la-brdr-weapon"],
    extensionTextFunction: /* @__PURE__ */ __name(() => {
      if (get$1(addButtonHover)) return `--${getLocalized("LA.add.extension")}`;
    }, "extensionTextFunction"),
    collapseID: collID,
    startCollapsed: !0,
    headerContent,
    children: /* @__PURE__ */ __name(($$anchor2, $$slotProps) => {
      var fragment_2 = comment(), node = first_child(fragment_2);
      {
        var consequent = /* @__PURE__ */ __name(($$anchor3) => {
          var div = root_3$4();
          each(div, 21, () => clocks, index, ($$anchor4, clock, index2) => {
            var div_1 = root_4$3();
            {
              const outerContent = /* @__PURE__ */ __name(($$anchor5) => {
                var div_2 = root_5$4(), node_1 = child(div_2);
                CounterBox(node_1, {
                  get type() {
                    return CounterBoxType.Counter;
                  },
                  get usesValue() {
                    return get$1(clock).value;
                  },
                  get usesMax() {
                    return get$1(clock).max;
                  },
                  path: `system.bond_state.clocks.${index2 ?? ""}`,
                  style: [
                    "clipped-bot-alt",
                    "-widthfull",
                    "la-bckg-header-anti"
                  ],
                  get logType() {
                    return TextLogHook.PilotHeader;
                  },
                  get logTypeReset() {
                    return TextLogHook.PilotHeaderReset;
                  }
                }), append($$anchor5, div_2);
              }, "outerContent"), headerSecondaryLeftOptions2 = /* @__PURE__ */ __name(($$anchor5) => {
                var i2 = root_6$7();
                append($$anchor5, i2);
              }, "headerSecondaryLeftOptions"), headerSecondaryRightOptions = /* @__PURE__ */ __name(($$anchor5) => {
                const expression_3 = /* @__PURE__ */ derived(() => getClockPath(index2)), expression_4 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
                EditButton($$anchor5, {
                  get flowClass() {
                    return FlowClass.ContextMenu;
                  },
                  get path() {
                    return get$1(expression_3);
                  },
                  style: [
                    HEADER_SECONDARY_STYLE,
                    "-padding0-lr"
                  ],
                  tooltipEnabled,
                  get tooltipTheme() {
                    return get$1(expression_4);
                  },
                  get logType() {
                    return TextLogHook.PilotHeader;
                  },
                  get logTypeReset() {
                    return TextLogHook.PilotHeaderReset;
                  },
                  onPointerEnter: /* @__PURE__ */ __name(() => {
                    set(editButtonHover, !0);
                  }, "onPointerEnter"),
                  onPointerLeave: /* @__PURE__ */ __name(() => {
                    set(editButtonHover, !1);
                  }, "onPointerLeave")
                });
              }, "headerSecondaryRightOptions");
              var node_2 = child(div_1);
              HeaderSecondary(node_2, {
                get text() {
                  return get$1(clock).name;
                },
                headerStyle: [H2_HEADER_STYLE, "la-bckg-pilot"],
                textStyle: [
                  "la-text-header",
                  "la-prmy-header",
                  "-fontsize2",
                  "-overflowhidden"
                ],
                borderStyle: ["-bordersoff"],
                extensionTextFunction: /* @__PURE__ */ __name(() => {
                  if (get$1(editButtonHover)) return `--${getLocalized("LA.edit.extension")}`;
                }, "extensionTextFunction"),
                get itemID() {
                  return get$1(clock).lid;
                },
                get uuid() {
                  return get$1(clock).uuid;
                },
                renderOutsideCollapse: outerContent,
                contentLeft: headerSecondaryLeftOptions2,
                contentRight: headerSecondaryRightOptions
              });
            }
            append($$anchor4, div_1);
          }), append($$anchor3, div);
        }, "consequent"), alternate = /* @__PURE__ */ __name(($$anchor3) => {
          const expression_5 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.bond.clock.empty.label")), expression_6 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.bond.clock.empty.subLabel"));
          EmptyBox($$anchor3, {
            get label() {
              return get$1(expression_5);
            },
            get subLabel() {
              return get$1(expression_6);
            }
          });
        }, "alternate");
        if_block(node, ($$render) => {
          clocks.length ? $$render(consequent) : $$render(alternate, !1);
        });
      }
      append($$anchor2, fragment_2);
    }, "children"),
    $$slots: { default: !0 }
  }), pop();
}
__name(Clock, "Clock");
function getBondQNAMode(uuid) {
  return PilotStore.get(uuid).bondQNAMode;
}
__name(getBondQNAMode, "getBondQNAMode");
function setBondQNAMode(uuid, enabled) {
  PilotStore.set(uuid, { bondQNAMode: enabled });
}
__name(setBondQNAMode, "setBondQNAMode");
var root_3$3 = /* @__PURE__ */ template('<div class="la-combine-h"><input type="checkbox"> <span class="-fontsize1 -lineheight3"> </span></div>'), root_4$2 = /* @__PURE__ */ template('<option style="color: black"> </option>'), root_2$2 = /* @__PURE__ */ template('<div class="la-bond-card__content la-combine-v -positionabsolute -margin0-tb -heightfull -justifyevenly la-reveal"><div class="la-bond-major la-combine-v -alignstart la-bckg-darken-1 clipped -widthfull -padding0 -padding1-r"></div> <div class="la-bond-minor la-combine-v -alignstart la-bckg-darken-1 clipped -widthfull -padding0 -padding1-r"><div class="la-combine-h -widthfull"><input type="checkbox" name="system.bond_state.xp_checklist.minor_ideal"> <select class="la-bond__select -fontsize1 -lineheight3 la-bckg-transparent la-text-text -widthfull" name="system.bond_state.minor_ideal" data-type="String"></select></div> <div class="la-combine-h"><input type="checkbox" name="system.bond_state.xp_checklist.veteran_power"> <span class="-fontsize1 -lineheight3"> </span></div></div></div>'), root_7$3 = /* @__PURE__ */ template("<option> </option>"), root_6$6 = /* @__PURE__ */ template('<div class="la-bond-question la-combine-v -alignstart la-bckg-darken-1 clipped -widthfull -padding2-lr -padding0-t -padding1-b"><span class="-fontsize1 -lineheight3"> </span> <select class="la-bond__select -fontsize1 -lineheight3 la-bckg-transparent la-text-text" data-type="String"></select></div>'), root_5$3 = /* @__PURE__ */ template('<div class="la-bond-card__content la-combine-v -positionabsolute -margin0-tb -heightfull -justifyevenly la-reveal"></div>'), root_1$4 = /* @__PURE__ */ template('<div class="la-bg-scroll-alt la-combine-v -widthfull -margin1-b -padding1-tb la-reveal-hover"><span class="-fontsize4 -letterspacing1 -upper"> </span> <div class="-widthhalf -padding0-tb"><!></div> <div class="la-bond-card la-combine-h -positionrelative -widthfull -aligncenter"><div class="la-bond-card__img-anchor -margin5-t -margin5-b"><img class="la-bond-card__img"></div> <!></div> <div class="la-combine-h"><!> <div><!> <!></div> <div class="la-combine-h -positionabsolute -left0 -padding3-l -gap1"><i></i> <!> <!></div></div></div>');
function Passion($$anchor, $$props) {
  push($$props, !0);
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor, system } = props;
  let advancedOptions = /* @__PURE__ */ derived(() => getAdvancedState(actor.uuid)), questionAnswer = /* @__PURE__ */ derived(() => getBondQNAMode(actor.uuid)), bondImageSrc = state(proxy(getBondImageSrc(actor.uuid)));
  const tooltipEnabled = getPilotSheetTooltipEnabled();
  function getGlowColor() {
    return getBrightness(getThemeKey(actor.uuid)) === "dark" ? "la-prmy-text" : "la-prmy-primary";
  }
  __name(getGlowColor, "getGlowColor");
  function browseImage() {
    new FilePicker({
      current: get$1(bondImageSrc),
      type: "image",
      callback: /* @__PURE__ */ __name((path) => {
        setBondImageSrc(actor.uuid, path), set(bondImageSrc, proxy(path));
      }, "callback")
    }).render(!0);
  }
  __name(browseImage, "browseImage");
  function tallyAndUpdate(event2) {
    event2.stopPropagation();
    let expTotal = 0;
    const updatedMajorIdeals = system.bond_state.xp_checklist.major_ideals.map((major) => (major === !0 && expTotal++, !1));
    system.bond_state.xp_checklist.minor_ideal === !0 && expTotal++, system.bond_state.xp_checklist.veteran_power === !0 && expTotal++, expTotal > 0 && actor.update({
      "system.bond_state.xp.value": system.bond_state.xp.value + expTotal,
      "system.bond_state.xp_checklist": {
        major_ideals: updatedMajorIdeals,
        minor_ideal: !1,
        veteran_power: !1
      }
    });
  }
  __name(tallyAndUpdate, "tallyAndUpdate");
  var fragment = comment(), node = first_child(fragment);
  {
    var consequent_1 = /* @__PURE__ */ __name(($$anchor2) => {
      var div = root_1$4(), span = child(div), text2 = child(span), div_1 = sibling(span, 2), node_1 = child(div_1);
      const expression = /* @__PURE__ */ derived(() => getLocalized("LA.hitpoint.tooltip"));
      StatusBar(node_1, {
        dataName: "system.bond_state.xp.value",
        get currentValue() {
          return system.bond_state.xp.value;
        },
        get maxValue() {
          return system.bond_state.xp.max;
        },
        barStyle: ["la-bckg-bar-health"],
        barStyleSecondary: ["la-bckg-bar-shield", "-shield"],
        barStyleTertiary: ["la-bckg-bar-burn", "-burn"],
        textStyle: ["la-text-text"],
        clipPath: "clipped",
        tooltipEnabled,
        get tooltip() {
          return get$1(expression);
        },
        get tooltipDirection() {
          return TooltipDirection.RIGHT;
        }
      });
      var div_2 = sibling(div_1, 2), div_3 = child(div_2), img = child(div_3), node_2 = sibling(div_3, 2);
      {
        var consequent = /* @__PURE__ */ __name(($$anchor3) => {
          var div_4 = root_2$2(), div_5 = child(div_4);
          each(div_5, 21, () => system.bond.system.major_ideals, index, ($$anchor4, major, index2) => {
            var div_6 = root_3$3(), input = child(div_6);
            set_attribute(input, "name", `system.bond_state.xp_checklist.major_ideals.${index2 ?? ""}`);
            var span_1 = sibling(input, 2), text_1 = child(span_1);
            template_effect(() => {
              set_checked(input, system.bond_state.xp_checklist.major_ideals[index2]), set_text(text_1, get$1(major));
            }), append($$anchor4, div_6);
          });
          var div_7 = sibling(div_5, 2), div_8 = child(div_7), input_1 = child(div_8), select2 = sibling(input_1, 2);
          each(select2, 21, () => system.bond.system.minor_ideals, index, ($$anchor4, minor) => {
            var option = root_4$2(), option_value = {}, text_2 = child(option);
            template_effect(() => {
              option_value !== (option_value = get$1(minor)) && (option.value = (option.__value = get$1(minor)) == null ? "" : get$1(minor)), set_selected(option, get$1(minor) === system.bond_state.minor_ideal), set_text(text_2, get$1(minor));
            }), append($$anchor4, option);
          });
          var div_9 = sibling(div_8, 2), input_2 = child(div_9), span_2 = sibling(input_2, 2), text_3 = child(span_2);
          template_effect(
            ($0) => {
              set_checked(input_1, system.bond_state.xp_checklist.minor_ideal), set_checked(input_2, system.bond_state.xp_checklist.veteran_power), set_text(text_3, $0);
            },
            [
              () => getLocalized("LA.pilot.bond.other.label")
            ]
          ), append($$anchor3, div_4);
        }, "consequent"), alternate = /* @__PURE__ */ __name(($$anchor3) => {
          var div_10 = root_5$3();
          each(div_10, 21, () => system.bond.system.questions, index, ($$anchor4, qna, index$1) => {
            var div_11 = root_6$6(), span_3 = child(div_11), text_4 = child(span_3), select_1 = sibling(span_3, 2);
            set_attribute(select_1, "name", `system.bond_state.answers.${index$1 ?? ""}`), each(select_1, 21, () => get$1(qna).options, index, ($$anchor5, answer) => {
              var option_1 = root_7$3(), option_1_value = {}, text_5 = child(option_1);
              template_effect(() => {
                option_1_value !== (option_1_value = get$1(answer)) && (option_1.value = (option_1.__value = get$1(answer)) == null ? "" : get$1(answer)), set_selected(option_1, get$1(answer) === system.bond_state.answers[index$1]), set_text(text_5, get$1(answer));
              }), append($$anchor5, option_1);
            }), template_effect(() => set_text(text_4, get$1(qna).question)), append($$anchor4, div_11);
          }), append($$anchor3, div_10);
        }, "alternate");
        if_block(node_2, ($$render) => {
          get$1(questionAnswer) ? $$render(alternate, !1) : $$render(consequent);
        });
      }
      var div_12 = sibling(div_2, 2), node_3 = child(div_12);
      const expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.bond.tally.label")), expression_2 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_3 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.bond.tally.tooltip")), expression_4 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.bond.tally.tooltip"));
      FlowButton(node_3, {
        get text() {
          return get$1(expression_1);
        },
        style: [
          "clipped",
          "la-bckg-secondary",
          "-padding0-tb",
          "-flex1"
        ],
        get flowClass() {
          return FlowClass.None;
        },
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_2);
        },
        get tooltipDirection() {
          return TooltipDirection.DOWN;
        },
        get tooltip() {
          return get$1(expression_3);
        },
        get logText() {
          return get$1(expression_4);
        },
        get logType() {
          return TextLogHook.PilotHeader;
        },
        get logTypeReset() {
          return TextLogHook.PilotHeaderReset;
        },
        onClick: tallyAndUpdate
      });
      var div_13 = sibling(node_3, 2), node_4 = child(div_13);
      const expression_5 = /* @__PURE__ */ derived(() => [
        "mdi mdi-image-edit",
        "la-text-secondary",
        "-fontsize5",
        "la-combine-h",
        "-justifycenter",
        "-aligncenter",
        `${"-glow-prmy la-prmy-primary -glow-prmy-hover " + getGlowColor()}`
      ]), expression_6 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_7 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.bond.changeImage.tooltip")), expression_8 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.bond.changeImage.tooltip"));
      GlyphButton(node_4, {
        get style() {
          return get$1(expression_5);
        },
        get flowClass() {
          return FlowClass.None;
        },
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_6);
        },
        get tooltip() {
          return get$1(expression_7);
        },
        get logText() {
          return get$1(expression_8);
        },
        get logType() {
          return TextLogHook.PilotHeader;
        },
        get logTypeReset() {
          return TextLogHook.PilotHeaderReset;
        },
        onClick: browseImage
      });
      var node_5 = sibling(node_4, 2);
      const expression_9 = /* @__PURE__ */ derived(() => [
        "fas fa-edit",
        "la-text-secondary",
        "-fontsize4",
        "-lineheight6",
        `${"-glow-prmy la-prmy-primary -glow-prmy-hover " + getGlowColor()}`,
        "-justifycenter",
        "-aligncenter"
      ]), expression_10 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_11 = /* @__PURE__ */ derived(() => getLocalized("LA.edit.tooltip")), expression_12 = /* @__PURE__ */ derived(() => getLocalized("LA.edit.tooltip"));
      GlyphButton(node_5, {
        get style() {
          return get$1(expression_9);
        },
        get flowClass() {
          return FlowClass.ContextMenu;
        },
        get uuid() {
          return system.bond.uuid;
        },
        path: "itemTypes.bond",
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_10);
        },
        get tooltip() {
          return get$1(expression_11);
        },
        get logText() {
          return get$1(expression_12);
        },
        get logType() {
          return TextLogHook.PilotHeader;
        },
        get logTypeReset() {
          return TextLogHook.PilotHeaderReset;
        }
      });
      var div_14 = sibling(div_13, 2), i2 = child(div_14), node_6 = sibling(i2, 2);
      const expression_13 = /* @__PURE__ */ derived(() => [
        `${get$1(questionAnswer) ? "mdi mdi-list-box" : "mdi mdi-help-circle"}`,
        "la-text-secondary",
        "-fontsize5",
        "la-combine-h",
        "-justifycenter",
        "-aligncenter",
        `${"-glow-prmy la-prmy-primary -glow-prmy-hover " + getGlowColor()}`
      ]), expression_14 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_15 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.bond.swap.tooltip")), expression_16 = /* @__PURE__ */ derived(() => getLocalized(get$1(questionAnswer) ? "LA.pilot.bond.xp.tooltip" : "LA.pilot.bond.qa.tooltip"));
      GlyphButton(node_6, {
        get style() {
          return get$1(expression_13);
        },
        get flowClass() {
          return FlowClass.None;
        },
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_14);
        },
        get tooltip() {
          return get$1(expression_15);
        },
        get logText() {
          return get$1(expression_16);
        },
        get logType() {
          return TextLogHook.PilotHeader;
        },
        get logTypeReset() {
          return TextLogHook.PilotHeaderReset;
        },
        onClick: /* @__PURE__ */ __name(() => {
          setBondQNAMode(actor.uuid, !get$1(questionAnswer));
        }, "onClick")
      });
      var node_7 = sibling(node_6, 2);
      const expression_17 = /* @__PURE__ */ derived(() => [
        "mdi mdi-refresh-circle",
        "la-text-secondary",
        "-fontsize5",
        "-justifycenter",
        `${"-glow-prmy la-prmy-primary -glow-prmy-hover " + getGlowColor()}`
      ]), expression_18 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_19 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.bond.power.refresh.tooltip")), expression_20 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.bond.power.refresh.tooltip"));
      GlyphButton(node_7, {
        get style() {
          return get$1(expression_17);
        },
        get flowClass() {
          return FlowClass.BondPowerRefresh;
        },
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_18);
        },
        get tooltip() {
          return get$1(expression_19);
        },
        get logText() {
          return get$1(expression_20);
        },
        get logType() {
          return TextLogHook.PilotHeader;
        },
        get logTypeReset() {
          return TextLogHook.PilotHeaderReset;
        },
        onClick: /* @__PURE__ */ __name(() => {
          setBondQNAMode(actor.uuid, !get$1(questionAnswer));
        }, "onClick")
      }), template_effect(
        ($0, $1) => {
          set_text(text2, system.bond.name), set_attribute(img, "src", get$1(bondImageSrc)), set_attribute(img, "alt", $0), set_class(div_13, `la-combine-h -positionabsolute -right0 -padding3-r -gap2 ${(get$1(advancedOptions) ? "" : "-visibilityhidden") ?? ""}`), set_class(i2, `mdi mdi-swap-vertical -fontsize la-text-text -positionabsolute -left0 ${$1 ?? ""}`);
        },
        [
          () => getLocalized("LA.placeholder"),
          () => "-glow-prmy la-prmy-primary -glow-prmy-hover " + getGlowColor()
        ]
      ), append($$anchor2, div);
    }, "consequent_1");
    if_block(node, ($$render) => {
      system.bond && $$render(consequent_1);
    });
  }
  append($$anchor, fragment), pop();
}
__name(Passion, "Passion");
var root$d = /* @__PURE__ */ template("<!> <!> <!> <!>", 1);
function Bond($$anchor, $$props) {
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor, system } = props;
  var fragment = root$d(), node = first_child(fragment);
  Passion(node, { actor, system });
  var node_1 = sibling(node, 2);
  Power(node_1, { actor, system });
  var node_2 = sibling(node_1, 2);
  Burden(node_2, { actor, system });
  var node_3 = sibling(node_2, 2);
  Clock(node_3, { actor, system }), append($$anchor, fragment);
}
__name(Bond, "Bond");
var root$c = /* @__PURE__ */ template('<div><span> </span> <div class="la-combine-v -alignstart -padding1-b -heightfull"><!> <!></div></div>');
function LevelSettings($$anchor, $$props) {
  push($$props, !0);
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor, document: document2, system } = props;
  let advancedOptions = /* @__PURE__ */ derived(() => getAdvancedState(actor.uuid));
  const tooltipEnabled = getPilotSheetTooltipEnabled();
  function levelUp(event2) {
    event2.stopPropagation(), document2.update({ "system.level": system.level + 1 });
  }
  __name(levelUp, "levelUp");
  function levelDown(event2) {
    event2.stopPropagation(), document2.update({
      "system.level": Math.max(system.level - 1, 0)
    });
  }
  __name(levelDown, "levelDown");
  var div = root$c(), span = child(div);
  set_class(span, `${SETTINGS_HEADER_STYLE} -alignend`);
  var text2 = child(span), div_1 = sibling(span, 2), node = child(div_1);
  const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.level.up.tooltip")), expression_2 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.level.up.tooltip"));
  GlyphButton(node, {
    style: [
      SETTINGS_BUTTON_STYLE,
      "mdi mdi-plus-box",
      "-verticalaligntop"
    ],
    get flowClass() {
      return FlowClass.None;
    },
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression);
    },
    get tooltip() {
      return get$1(expression_1);
    },
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    },
    get logText() {
      return get$1(expression_2);
    },
    get logType() {
      return TextLogHook.PilotHeader;
    },
    get logTypeReset() {
      return TextLogHook.PilotHeaderReset;
    },
    onClick: levelUp
  });
  var node_1 = sibling(node, 2);
  const expression_3 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_4 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.level.down.tooltip")), expression_5 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.level.down.tooltip"));
  GlyphButton(node_1, {
    style: [
      SETTINGS_BUTTON_STYLE,
      "mdi mdi-minus-box",
      "-verticalaligntop"
    ],
    get flowClass() {
      return FlowClass.None;
    },
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_3);
    },
    get tooltip() {
      return get$1(expression_4);
    },
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    },
    get logText() {
      return get$1(expression_5);
    },
    get logType() {
      return TextLogHook.PilotHeader;
    },
    get logTypeReset() {
      return TextLogHook.PilotHeaderReset;
    },
    onClick: levelDown
  }), template_effect(
    ($0) => {
      set_class(div, `-heightfull
    ${(get$1(advancedOptions) ? "la-combine-h" : "-displaynone") ?? ""}`), set_text(text2, $0);
    },
    [() => getLocalized("LA.pilot.level.label")]
  ), append($$anchor, div), pop();
}
__name(LevelSettings, "LevelSettings");
var root$b = /* @__PURE__ */ template('<div><span> </span> <div class="la-combine-v -alignstart -padding1-b -heightfull"><!> <!></div></div>');
function HullSettings($$anchor, $$props) {
  push($$props, !0);
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor, document: document2, system } = props;
  let advancedOptions = /* @__PURE__ */ derived(() => getAdvancedState(actor.uuid));
  const tooltipEnabled = getPilotSheetTooltipEnabled();
  function levelUp(event2) {
    event2.stopPropagation(), document2.update({ "system.hull": system.hull + 1 });
  }
  __name(levelUp, "levelUp");
  function levelDown(event2) {
    event2.stopPropagation(), document2.update({
      "system.hull": Math.max(system.hull - 1, 0)
    });
  }
  __name(levelDown, "levelDown");
  var div = root$b(), span = child(div);
  set_class(span, `${SETTINGS_HEADER_STYLE} -alignend -capitalize`);
  var text2 = child(span), div_1 = sibling(span, 2), node = child(div_1);
  const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.hull.up.tooltip")), expression_2 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.hull.up.tooltip"));
  GlyphButton(node, {
    style: [
      SETTINGS_BUTTON_STYLE,
      "mdi mdi-plus-box",
      "-verticalaligntop"
    ],
    get flowClass() {
      return FlowClass.None;
    },
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression);
    },
    get tooltip() {
      return get$1(expression_1);
    },
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    },
    get logText() {
      return get$1(expression_2);
    },
    get logType() {
      return TextLogHook.PilotHeader;
    },
    get logTypeReset() {
      return TextLogHook.PilotHeaderReset;
    },
    onClick: levelUp
  });
  var node_1 = sibling(node, 2);
  const expression_3 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_4 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.hull.down.tooltip")), expression_5 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.hull.down.tooltip"));
  GlyphButton(node_1, {
    style: [
      SETTINGS_BUTTON_STYLE,
      "mdi mdi-minus-box",
      "-verticalaligntop"
    ],
    get flowClass() {
      return FlowClass.None;
    },
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_3);
    },
    get tooltip() {
      return get$1(expression_4);
    },
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    },
    get logText() {
      return get$1(expression_5);
    },
    get logType() {
      return TextLogHook.PilotHeader;
    },
    get logTypeReset() {
      return TextLogHook.PilotHeaderReset;
    },
    onClick: levelDown
  }), template_effect(
    ($0) => {
      set_class(div, `-heightfull
    ${(get$1(advancedOptions) ? "la-combine-h" : "-displaynone") ?? ""}`), set_text(text2, $0);
    },
    [() => getLocalized("LA.hull.label")]
  ), append($$anchor, div), pop();
}
__name(HullSettings, "HullSettings");
var root$a = /* @__PURE__ */ template('<div><span> </span> <div class="la-combine-v -alignstart -padding1-b -heightfull"><!> <!></div></div>');
function AgilitySettings($$anchor, $$props) {
  push($$props, !0);
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor, document: document2, system } = props;
  let advancedOptions = /* @__PURE__ */ derived(() => getAdvancedState(actor.uuid));
  const tooltipEnabled = getPilotSheetTooltipEnabled();
  function levelUp(event2) {
    event2.stopPropagation(), document2.update({ "system.agi": system.agi + 1 });
  }
  __name(levelUp, "levelUp");
  function levelDown(event2) {
    event2.stopPropagation(), document2.update({ "system.agi": Math.max(system.agi - 1, 0) });
  }
  __name(levelDown, "levelDown");
  var div = root$a(), span = child(div);
  set_class(span, `${SETTINGS_HEADER_STYLE} -alignend -capitalize`);
  var text2 = child(span), div_1 = sibling(span, 2), node = child(div_1);
  const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.level.up.tooltip")), expression_2 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.level.up.tooltip"));
  GlyphButton(node, {
    style: [
      SETTINGS_BUTTON_STYLE,
      "mdi mdi-plus-box",
      "-verticalaligntop"
    ],
    get flowClass() {
      return FlowClass.None;
    },
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression);
    },
    get tooltip() {
      return get$1(expression_1);
    },
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    },
    get logText() {
      return get$1(expression_2);
    },
    get logType() {
      return TextLogHook.PilotHeader;
    },
    get logTypeReset() {
      return TextLogHook.PilotHeaderReset;
    },
    onClick: levelUp
  });
  var node_1 = sibling(node, 2);
  const expression_3 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_4 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.agility.down.tooltip")), expression_5 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.agility.down.tooltip"));
  GlyphButton(node_1, {
    style: [
      SETTINGS_BUTTON_STYLE,
      "mdi mdi-minus-box",
      "-verticalaligntop"
    ],
    get flowClass() {
      return FlowClass.None;
    },
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_3);
    },
    get tooltip() {
      return get$1(expression_4);
    },
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    },
    get logText() {
      return get$1(expression_5);
    },
    get logType() {
      return TextLogHook.PilotHeader;
    },
    get logTypeReset() {
      return TextLogHook.PilotHeaderReset;
    },
    onClick: levelDown
  }), template_effect(
    ($0) => {
      set_class(div, `-heightfull
    ${(get$1(advancedOptions) ? "la-combine-h" : "-displaynone") ?? ""}`), set_text(text2, $0);
    },
    [() => getLocalized("LA.agility.label")]
  ), append($$anchor, div), pop();
}
__name(AgilitySettings, "AgilitySettings");
var root$9 = /* @__PURE__ */ template('<div><span> </span> <div class="la-combine-v -alignstart -padding1-b -heightfull"><!> <!></div></div>');
function SystemsSettings($$anchor, $$props) {
  push($$props, !0);
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor, document: document2, system } = props;
  let advancedOptions = /* @__PURE__ */ derived(() => getAdvancedState(actor.uuid));
  const tooltipEnabled = getPilotSheetTooltipEnabled();
  function levelUp(event2) {
    event2.stopPropagation(), document2.update({ "system.sys": system.sys + 1 });
  }
  __name(levelUp, "levelUp");
  function levelDown(event2) {
    event2.stopPropagation(), document2.update({ "system.sys": Math.max(system.sys - 1, 0) });
  }
  __name(levelDown, "levelDown");
  var div = root$9(), span = child(div);
  set_class(span, `${SETTINGS_HEADER_STYLE} -alignend -capitalize`);
  var text2 = child(span), div_1 = sibling(span, 2), node = child(div_1);
  const expression = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.systems.up.tooltip")), expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.systems.up.tooltip"));
  GlyphButton(node, {
    style: [
      SETTINGS_BUTTON_STYLE,
      "mdi mdi-plus-box",
      "-verticalaligntop"
    ],
    get flowClass() {
      return FlowClass.None;
    },
    get tooltip() {
      return get$1(expression);
    },
    tooltipEnabled,
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    },
    get logText() {
      return get$1(expression_1);
    },
    get logType() {
      return TextLogHook.PilotHeader;
    },
    get logTypeReset() {
      return TextLogHook.PilotHeaderReset;
    },
    onClick: levelUp
  });
  var node_1 = sibling(node, 2);
  const expression_2 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.systems.down.tooltip")), expression_3 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.systems.down.tooltip"));
  GlyphButton(node_1, {
    style: [
      SETTINGS_BUTTON_STYLE,
      "mdi mdi-minus-box",
      "-verticalaligntop"
    ],
    get flowClass() {
      return FlowClass.None;
    },
    get tooltip() {
      return get$1(expression_2);
    },
    tooltipEnabled,
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    },
    get logText() {
      return get$1(expression_3);
    },
    get logType() {
      return TextLogHook.PilotHeader;
    },
    get logTypeReset() {
      return TextLogHook.PilotHeaderReset;
    },
    onClick: levelDown
  }), template_effect(
    ($0) => {
      set_class(div, `-heightfull
    ${(get$1(advancedOptions) ? "la-combine-h" : "-displaynone") ?? ""}`), set_text(text2, $0);
    },
    [() => getLocalized("LA.systems.label")]
  ), append($$anchor, div), pop();
}
__name(SystemsSettings, "SystemsSettings");
var root$8 = /* @__PURE__ */ template('<div><span> </span> <div class="la-combine-v -alignstart -padding1-b -heightfull"><!> <!></div></div>');
function EngineeringSettings($$anchor, $$props) {
  push($$props, !0);
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor, document: document2, system } = props;
  let advancedOptions = /* @__PURE__ */ derived(() => getAdvancedState(actor.uuid));
  const tooltipEnabled = getPilotSheetTooltipEnabled();
  function levelUp(event2) {
    event2.stopPropagation(), document2.update({ "system.eng": system.eng + 1 });
  }
  __name(levelUp, "levelUp");
  function levelDown(event2) {
    event2.stopPropagation(), document2.update({ "system.eng": Math.max(system.eng - 1, 0) });
  }
  __name(levelDown, "levelDown");
  var div = root$8(), span = child(div);
  set_class(span, `${SETTINGS_HEADER_STYLE} -alignend -capitalize`);
  var text2 = child(span), div_1 = sibling(span, 2), node = child(div_1);
  const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.engineering.up.tooltip")), expression_2 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.engineering.up.tooltip"));
  GlyphButton(node, {
    style: [
      SETTINGS_BUTTON_STYLE,
      "mdi mdi-plus-box",
      "-verticalaligntop"
    ],
    get flowClass() {
      return FlowClass.None;
    },
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression);
    },
    get tooltip() {
      return get$1(expression_1);
    },
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    },
    get logText() {
      return get$1(expression_2);
    },
    get logType() {
      return TextLogHook.PilotHeader;
    },
    get logTypeReset() {
      return TextLogHook.PilotHeaderReset;
    },
    onClick: levelUp
  });
  var node_1 = sibling(node, 2);
  const expression_3 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid)), expression_4 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.engineering.down.tooltip")), expression_5 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.engineering.down.tooltip"));
  GlyphButton(node_1, {
    style: [
      SETTINGS_BUTTON_STYLE,
      "mdi mdi-minus-box",
      "-verticalaligntop"
    ],
    get flowClass() {
      return FlowClass.None;
    },
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_3);
    },
    get tooltip() {
      return get$1(expression_4);
    },
    get tooltipDirection() {
      return TooltipDirection.RIGHT;
    },
    get logText() {
      return get$1(expression_5);
    },
    get logType() {
      return TextLogHook.PilotHeader;
    },
    get logTypeReset() {
      return TextLogHook.PilotHeaderReset;
    },
    onClick: levelDown
  }), template_effect(
    ($0) => {
      set_class(div, `-heightfull
    ${(get$1(advancedOptions) ? "la-combine-h" : "-displaynone") ?? ""}`), set_text(text2, $0);
    },
    [() => getLocalized("LA.engineering.label")]
  ), append($$anchor, div), pop();
}
__name(EngineeringSettings, "EngineeringSettings");
const SETTINGS_BUTTON_STYLE = " la-text-secondary la-prmy-primary -glow-prmy-hover -fontsize3 -height2", SETTINGS_HEADER_STYLE = " la-bckg-primary la-text-header clipped-top -width5 -writingmode-v -fontsize1 -padding0-b -padding1-t ";
var root$7 = /* @__PURE__ */ template("<!> <!> <!> <!> <!>", 1);
function AdvancedSettings($$anchor, $$props) {
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]);
  var fragment = root$7(), node = first_child(fragment);
  LevelSettings(node, spread_props(() => props));
  var node_1 = sibling(node, 2);
  HullSettings(node_1, spread_props(() => props));
  var node_2 = sibling(node_1, 2);
  AgilitySettings(node_2, spread_props(() => props));
  var node_3 = sibling(node_2, 2);
  SystemsSettings(node_3, spread_props(() => props));
  var node_4 = sibling(node_3, 2);
  EngineeringSettings(node_4, spread_props(() => props)), append($$anchor, fragment);
}
__name(AdvancedSettings, "AdvancedSettings");
var root$6 = /* @__PURE__ */ template("<!> <!>", 1);
function AdvancedSettingsNav($$anchor, $$props) {
  push($$props, !0);
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor } = props;
  let advancedOptions = /* @__PURE__ */ derived(() => getAdvancedState(actor.uuid));
  const tooltipEnabled = getPilotSheetTooltipEnabled();
  var fragment = root$6(), node = first_child(fragment);
  const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid));
  SidebarRatioSlider(node, {
    get uuid() {
      return actor.uuid;
    },
    ratioGetter: getSidebarRatio,
    ratioSetter: setSidebarRatio,
    style: ["-aligncontentcenter"],
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression);
    },
    get logType() {
      return TextLogHook.MechHeader;
    },
    get logTypeReset() {
      return TextLogHook.MechHeaderReset;
    }
  });
  var node_1 = sibling(node, 2);
  const expression_1 = /* @__PURE__ */ derived(() => !get$1(advancedOptions)), expression_2 = /* @__PURE__ */ derived(() => getCSSDocumentTheme(actor.uuid));
  ThemeOverrideButton(node_1, {
    get disabled() {
      return get$1(expression_1);
    },
    get uuid() {
      return actor.uuid;
    },
    style: ["-alignselfstart"],
    tooltipEnabled,
    get tooltipTheme() {
      return get$1(expression_2);
    },
    setOverride: setThemeOverride$2,
    get logType() {
      return TextLogHook.MechHeader;
    },
    get logTypeReset() {
      return TextLogHook.MechHeaderReset;
    }
  }), append($$anchor, fragment), pop();
}
__name(AdvancedSettingsNav, "AdvancedSettingsNav");
var root$5 = /* @__PURE__ */ template('<div class="-margin5-t"><!></div>');
function Activity$1($$anchor, $$props) {
  push($$props, !0);
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor } = props, actionLogSaveCollapse = getPilotSheetLogActionDontSaveCollapse(), actionLogStartCollapsed = getPilotSheetLogActionStartCollapsed();
  var div = root$5(), node = child(div);
  ActionLog(node, {
    get uuid() {
      return actor.uuid;
    },
    dontSaveCollapse: actionLogSaveCollapse,
    startCollapsed: actionLogStartCollapsed,
    get collapsePrefix() {
      return ActionLogCollapsePrefix.PilotSheet;
    }
  }), append($$anchor, div), pop();
}
__name(Activity$1, "Activity$1");
var root_7$2 = /* @__PURE__ */ template('<span class="-fontsize2">+</span>'), root_9$1 = /* @__PURE__ */ template('<span class="-fontsize2">-</span>'), root_6$5 = /* @__PURE__ */ template('<span class="la-combine-h -gap0 -padding2-r"><!> </span> <!> <!>', 1), root_10 = /* @__PURE__ */ template("<!> <!>", 1), root_3$2 = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull"></div>');
function SkillTriggers($$anchor, $$props) {
  push($$props, !0);
  const headerOptions = /* @__PURE__ */ __name(($$anchor2) => {
    const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
    CollapseAllButton($$anchor2, {
      collapseID: collID,
      tooltipEnabled,
      get tooltipTheme() {
        return get$1(expression);
      },
      onPointerEnter: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !0);
      }, "onPointerEnter"),
      onPointerLeave: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !1);
      }, "onPointerLeave")
    });
  }, "headerOptions");
  let collapseAllButtonHover = state(!1), editButtonHover = state(!1), messageButtonHover = state(!1), effectButtonHover = state(!1);
  const collID = `${$$props.actor.uuid}.skills`, tooltipEnabled = getPilotSheetTooltipEnabled();
  function getSkillPath(index2) {
    return `itemTypes.skill.${index2}`;
  }
  __name(getSkillPath, "getSkillPath");
  const expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.skill.label"));
  HeaderMain($$anchor, {
    get text() {
      return get$1(expression_1);
    },
    headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-primary"],
    textStyle: [
      "la-text-header",
      "-fontsize2",
      "-overflowhidden"
    ],
    borderStyle: ["la-brdr-primary"],
    extensionTextFunction: /* @__PURE__ */ __name(() => {
      if (get$1(collapseAllButtonHover)) return `--${getLocalized("LA.collapseAll.extension")}`;
    }, "extensionTextFunction"),
    collapseID: collID,
    startCollapsed: !0,
    headerContent: headerOptions,
    children: /* @__PURE__ */ __name(($$anchor2, $$slotProps) => {
      var fragment_2 = comment(), node = first_child(fragment_2);
      {
        var consequent_2 = /* @__PURE__ */ __name(($$anchor3) => {
          var div = root_3$2();
          each(div, 21, () => $$props.skills, index, ($$anchor4, skill, index2) => {
            const headerSecondaryLeftOptions2 = /* @__PURE__ */ __name(($$anchor5) => {
              const expression_2 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_3 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.skillTrigger.label"));
              EffectButton($$anchor5, {
                iconStyle: [
                  "la-text-header",
                  "cci",
                  "cci-skill",
                  "-fontsize5"
                ],
                iconBackgroundStyle: [
                  "-fontsize5",
                  "la-prmy-secondary",
                  "-pulse-prmy"
                ],
                get flowClass() {
                  return FlowClass.Skill;
                },
                get uuid() {
                  return get$1(skill).uuid;
                },
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_2);
                },
                get tooltipDirection() {
                  return TooltipDirection.LEFT;
                },
                get tooltip() {
                  return get$1(skill).system.description;
                },
                get tooltipHeader() {
                  return get$1(expression_3);
                },
                get logType() {
                  return TextLogHook.PilotHeader;
                },
                get logTypeReset() {
                  return TextLogHook.PilotHeaderReset;
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(effectButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(effectButtonHover, !1);
                }, "onPointerLeave")
              });
            }, "headerSecondaryLeftOptions"), headerSecondaryRightOptions = /* @__PURE__ */ __name(($$anchor5) => {
              var fragment_4 = root_6$5(), span = first_child(fragment_4), node_1 = child(span);
              {
                var consequent = /* @__PURE__ */ __name(($$anchor6) => {
                  var span_1 = root_7$2();
                  append($$anchor6, span_1);
                }, "consequent"), alternate = /* @__PURE__ */ __name(($$anchor6) => {
                  var fragment_5 = comment(), node_2 = first_child(fragment_5);
                  {
                    var consequent_1 = /* @__PURE__ */ __name(($$anchor7) => {
                      var span_2 = root_9$1();
                      append($$anchor7, span_2);
                    }, "consequent_1");
                    if_block(
                      node_2,
                      ($$render) => {
                        get$1(skill).system.curr_rank < 0 && $$render(consequent_1);
                      },
                      !0
                    );
                  }
                  append($$anchor6, fragment_5);
                }, "alternate");
                if_block(node_1, ($$render) => {
                  get$1(skill).system.curr_rank > 0 ? $$render(consequent) : $$render(alternate, !1);
                });
              }
              var text2 = sibling(node_1), node_3 = sibling(span, 2);
              const expression_4 = /* @__PURE__ */ derived(() => getSkillPath(index2)), expression_5 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
              EditButton(node_3, {
                get flowClass() {
                  return FlowClass.ContextMenu;
                },
                get path() {
                  return get$1(expression_4);
                },
                style: [
                  HEADER_SECONDARY_STYLE,
                  "-padding0-lr"
                ],
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_5);
                },
                get logType() {
                  return TextLogHook.PilotHeader;
                },
                get logTypeReset() {
                  return TextLogHook.PilotHeaderReset;
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !1);
                }, "onPointerLeave")
              });
              var node_4 = sibling(node_3, 2);
              const expression_6 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
              MessageButton(node_4, {
                get flowClass() {
                  return FlowClass.SendToChat;
                },
                get uuid() {
                  return get$1(skill).uuid;
                },
                style: [
                  HEADER_SECONDARY_STYLE,
                  "-padding0-lr"
                ],
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_6);
                },
                get logType() {
                  return TextLogHook.PilotHeader;
                },
                get logTypeReset() {
                  return TextLogHook.PilotHeaderReset;
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(messageButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(messageButtonHover, !1);
                }, "onPointerLeave")
              }), template_effect(() => set_text(text2, ` ${get$1(skill).system.curr_rank * 2}`)), append($$anchor5, fragment_4);
            }, "headerSecondaryRightOptions"), expression_7 = /* @__PURE__ */ derived(() => getSkillPath(index2));
            HeaderSecondary($$anchor4, {
              get text() {
                return get$1(skill).name;
              },
              headerStyle: [H2_HEADER_STYLE, "la-bckg-pilot"],
              textStyle: [
                "la-text-header",
                "la-prmy-header",
                "-fontsize2",
                "-overflowhidden"
              ],
              borderStyle: ["-bordersoff"],
              extensionTextFunction: /* @__PURE__ */ __name(() => {
                if (get$1(effectButtonHover)) return `--${getLocalized("LA.use.label")}`;
                if (get$1(messageButtonHover)) return `--${getLocalized("LA.chat.extension")}`;
                if (get$1(editButtonHover)) return `--${getLocalized("LA.edit.extension")}`;
              }, "extensionTextFunction"),
              get itemID() {
                return get$1(skill).lid;
              },
              get uuid() {
                return get$1(skill).uuid;
              },
              get path() {
                return get$1(expression_7);
              },
              acceptTypes: "skill",
              get collapseID() {
                return get$1(skill).uuid;
              },
              startCollapsed: !0,
              contentLeft: headerSecondaryLeftOptions2,
              contentRight: headerSecondaryRightOptions,
              children: /* @__PURE__ */ __name(($$anchor5, $$slotProps2) => {
                var fragment_7 = root_10(), node_5 = first_child(fragment_7);
                const expression_8 = /* @__PURE__ */ derived(() => getLocalized("LA.description.label"));
                EffectBox(node_5, {
                  get name() {
                    return get$1(expression_8);
                  },
                  get effect() {
                    return get$1(skill).system.description;
                  },
                  tooltipEnabled,
                  get logType() {
                    return TextLogHook.PilotHeader;
                  },
                  get logTypeReset() {
                    return TextLogHook.PilotHeaderReset;
                  }
                });
                var node_6 = sibling(node_5, 2);
                const expression_9 = /* @__PURE__ */ derived(() => getLocalized("LA.detail.label"));
                EffectBox(node_6, {
                  get name() {
                    return get$1(expression_9);
                  },
                  get effect() {
                    return get$1(skill).system.detail;
                  },
                  tooltipEnabled,
                  get logType() {
                    return TextLogHook.PilotHeader;
                  },
                  get logTypeReset() {
                    return TextLogHook.PilotHeaderReset;
                  }
                }), append($$anchor5, fragment_7);
              }, "children"),
              $$slots: { default: !0 }
            });
          }), append($$anchor3, div);
        }, "consequent_2"), alternate_1 = /* @__PURE__ */ __name(($$anchor3) => {
          const expression_10 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.skill.empty.label")), expression_11 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.skill.empty.subLabel"));
          EmptyBox($$anchor3, {
            get label() {
              return get$1(expression_10);
            },
            get subLabel() {
              return get$1(expression_11);
            },
            get type() {
              return AcceptType.Skill;
            },
            get path() {
              return `itemTypes.skill.${$$props.skills.length ?? ""}`;
            }
          });
        }, "alternate_1");
        if_block(node, ($$render) => {
          $$props.skills.length ? $$render(consequent_2) : $$render(alternate_1, !1);
        });
      }
      append($$anchor2, fragment_2);
    }, "children"),
    $$slots: { default: !0 }
  }), pop();
}
__name(SkillTriggers, "SkillTriggers");
var root_5$2 = /* @__PURE__ */ template("<i></i>"), root_6$4 = /* @__PURE__ */ template('<span class="la-combine-h -gap0 -padding2-r"><span class="-fontsize0 -letterspacing0"> </span> </span> <!> <!>', 1), root_3$1 = /* @__PURE__ */ template('<div class="la-combine-v -gap0 -widthfull"></div>');
function License($$anchor, $$props) {
  push($$props, !0);
  const headerOptions = /* @__PURE__ */ __name(($$anchor2) => {
    const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
    CollapseAllButton($$anchor2, {
      collapseID: collID,
      tooltipEnabled,
      get tooltipTheme() {
        return get$1(expression);
      },
      onPointerEnter: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !0);
      }, "onPointerEnter"),
      onPointerLeave: /* @__PURE__ */ __name(() => {
        set(collapseAllButtonHover, !1);
      }, "onPointerLeave")
    });
  }, "headerOptions");
  let collapseAllButtonHover = state(!1), editButtonHover = state(!1), messageButtonHover = state(!1), licenseDescriptions = proxy([]);
  const collID = `${$$props.actor.uuid}.licenses`, tooltipEnabled = getNPCSheetTooltipEnabled();
  onMount(() => {
    $$props.licenses.forEach((license, index2) => {
      fetchLicenseDescription(license, index2);
    });
  });
  async function fetchLicenseDescription(license, index2) {
    try {
      const item = await game.lancer.fromLid(license.system.key), frame = await fromUuid(item.uuid);
      updateLicenseDescription(index2, (frame == null ? void 0 : frame.system.description) || "");
    } catch (error) {
      console.error(`Failed to fetch license description for index ${index2}:`, error);
    }
  }
  __name(fetchLicenseDescription, "fetchLicenseDescription");
  function updateLicenseDescription(index2, description) {
    licenseDescriptions[index2] = description;
  }
  __name(updateLicenseDescription, "updateLicenseDescription");
  function getLicensePath(index2) {
    return `itemTypes.license.${index2}`;
  }
  __name(getLicensePath, "getLicensePath");
  function sendToChat(event2, license, index2) {
    event2.stopPropagation();
    let chatData = {
      title: `${license.name} ${license.system.curr_rank}`,
      description: licenseDescriptions[index2] || ""
    };
    SendUnknownToChatBase.getInstance().startFlow($$props.actor.uuid, chatData);
  }
  __name(sendToChat, "sendToChat");
  const expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.license.label"));
  HeaderMain($$anchor, {
    get text() {
      return get$1(expression_1);
    },
    headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-weapon"],
    textStyle: [
      "la-text-header",
      "-fontsize2",
      "-overflowhidden"
    ],
    borderStyle: ["la-brdr-weapon"],
    extensionTextFunction: /* @__PURE__ */ __name(() => {
      if (get$1(collapseAllButtonHover)) return `--${getLocalized("LA.collapseAll.extension")}`;
    }, "extensionTextFunction"),
    collapseID: collID,
    startCollapsed: !0,
    headerContent: headerOptions,
    children: /* @__PURE__ */ __name(($$anchor2, $$slotProps) => {
      var fragment_2 = comment(), node = first_child(fragment_2);
      {
        var consequent = /* @__PURE__ */ __name(($$anchor3) => {
          var div = root_3$1();
          each(div, 21, () => $$props.licenses, index, ($$anchor4, license, index2) => {
            const headerSecondaryLeftOptions2 = /* @__PURE__ */ __name(($$anchor5) => {
              var i2 = root_5$2();
              set_class(i2, `${H2_ICON_SIZE} cci cci-license`), append($$anchor5, i2);
            }, "headerSecondaryLeftOptions"), headerSecondaryRightOptions = /* @__PURE__ */ __name(($$anchor5) => {
              var fragment_3 = root_6$4(), span = first_child(fragment_3), span_1 = child(span), text2 = child(span_1), text_1 = sibling(span_1), node_1 = sibling(span, 2);
              const expression_2 = /* @__PURE__ */ derived(() => getLicensePath(index2)), expression_3 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
              EditButton(node_1, {
                get flowClass() {
                  return FlowClass.ContextMenu;
                },
                get path() {
                  return get$1(expression_2);
                },
                style: [
                  HEADER_SECONDARY_STYLE,
                  "-padding0-lr"
                ],
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_3);
                },
                get logType() {
                  return TextLogHook.PilotHeader;
                },
                get logTypeReset() {
                  return TextLogHook.PilotHeaderReset;
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(editButtonHover, !1);
                }, "onPointerLeave")
              });
              var node_2 = sibling(node_1, 2);
              const expression_4 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid));
              MessageButton(node_2, {
                get flowClass() {
                  return FlowClass.None;
                },
                get uuid() {
                  return get$1(license).uuid;
                },
                style: [
                  HEADER_SECONDARY_STYLE,
                  "-padding0-lr"
                ],
                tooltipEnabled,
                get tooltipTheme() {
                  return get$1(expression_4);
                },
                get logType() {
                  return TextLogHook.PilotHeader;
                },
                get logTypeReset() {
                  return TextLogHook.PilotHeaderReset;
                },
                onPointerEnter: /* @__PURE__ */ __name(() => {
                  set(messageButtonHover, !0);
                }, "onPointerEnter"),
                onPointerLeave: /* @__PURE__ */ __name(() => {
                  set(messageButtonHover, !1);
                }, "onPointerLeave"),
                onClick: /* @__PURE__ */ __name((event2) => sendToChat(event2, get$1(license), index2), "onClick")
              }), template_effect(
                ($0) => {
                  set_text(text2, $0), set_text(text_1, ` ${get$1(license).system.curr_rank ?? ""}`);
                },
                [() => getLocalized("LA.rank.label")]
              ), append($$anchor5, fragment_3);
            }, "headerSecondaryRightOptions"), expression_5 = /* @__PURE__ */ derived(() => `${get$1(license).system.manufacturer} ${get$1(license).name}`), expression_6 = /* @__PURE__ */ derived(() => getLicensePath(index2));
            HeaderSecondary($$anchor4, {
              get text() {
                return get$1(expression_5);
              },
              headerStyle: [H2_HEADER_STYLE, "la-bckg-pilot"],
              textStyle: [
                "la-text-header",
                "la-prmy-header",
                "-fontsize2",
                "-overflowhidden"
              ],
              borderStyle: ["-bordersoff"],
              extensionTextFunction: /* @__PURE__ */ __name(() => {
                if (get$1(messageButtonHover)) return `--${getLocalized("LA.chat.extension")}`;
                if (get$1(editButtonHover)) return `--${getLocalized("LA.edit.extension")}`;
              }, "extensionTextFunction"),
              get itemID() {
                return get$1(license).lid;
              },
              get uuid() {
                return get$1(license).uuid;
              },
              get path() {
                return get$1(expression_6);
              },
              acceptTypes: "license",
              get collapseID() {
                return get$1(license).uuid;
              },
              startCollapsed: !0,
              contentLeft: headerSecondaryLeftOptions2,
              contentRight: headerSecondaryRightOptions,
              children: /* @__PURE__ */ __name(($$anchor5, $$slotProps2) => {
                const expression_7 = /* @__PURE__ */ derived(() => getLocalized("LA.description.label"));
                EffectBox($$anchor5, {
                  get name() {
                    return get$1(expression_7);
                  },
                  get effect() {
                    return licenseDescriptions[index2];
                  },
                  tooltipEnabled,
                  get logType() {
                    return TextLogHook.PilotHeader;
                  },
                  get logTypeReset() {
                    return TextLogHook.PilotHeaderReset;
                  }
                });
              }, "children"),
              $$slots: { default: !0 }
            });
          }), append($$anchor3, div);
        }, "consequent"), alternate = /* @__PURE__ */ __name(($$anchor3) => {
          const expression_8 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.license.empty.label")), expression_9 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.license.empty.subLabel"));
          EmptyBox($$anchor3, {
            get label() {
              return get$1(expression_8);
            },
            get subLabel() {
              return get$1(expression_9);
            },
            get type() {
              return AcceptType.License;
            },
            get path() {
              return `itemTypes.license.${$$props.licenses.length ?? ""}`;
            }
          });
        }, "alternate");
        if_block(node, ($$render) => {
          $$props.licenses.length ? $$render(consequent) : $$render(alternate, !1);
        });
      }
      append($$anchor2, fragment_2);
    }, "children"),
    $$slots: { default: !0 }
  }), pop();
}
__name(License, "License");
var root$4 = /* @__PURE__ */ template("<!> <!> <!> <!>", 1);
function Abilities($$anchor, $$props) {
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor, itemTypes } = props;
  var fragment = root$4(), node = first_child(fragment);
  SkillTriggers(node, {
    actor,
    get skills() {
      return itemTypes.skill;
    }
  });
  var node_1 = sibling(node, 2);
  License(node_1, {
    actor,
    get licenses() {
      return itemTypes.license;
    }
  });
  var node_2 = sibling(node_1, 2);
  CoreBonus(node_2, { actor, sheetActor: actor });
  var node_3 = sibling(node_2, 2);
  Talents(node_3, { actor, sheetActor: actor }), append($$anchor, fragment);
}
__name(Abilities, "Abilities");
function History($$anchor, $$props) {
  push($$props, !0);
  const headerOptions = /* @__PURE__ */ __name(($$anchor2) => {
    const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.edit.tooltip")), expression_2 = /* @__PURE__ */ derived(() => getLocalized("LA.edit.tooltip"));
    GlyphButton($$anchor2, {
      style: [
        "fas fa-edit",
        "-fontsize2",
        "-height2",
        "-lineheight2",
        "la-prmy-header -glow-prmy la-scdy-primary -glow-scdy-hover"
      ],
      get flowClass() {
        return FlowClass.EditText;
      },
      path: "system.history",
      tooltipEnabled,
      get tooltipTheme() {
        return get$1(expression);
      },
      get tooltip() {
        return get$1(expression_1);
      },
      get tooltipDirection() {
        return TooltipDirection.UP;
      },
      get logText() {
        return get$1(expression_2);
      },
      get logType() {
        return TextLogHook.PilotHeader;
      },
      get logTypeReset() {
        return TextLogHook.PilotHeaderReset;
      },
      onPointerEnter: /* @__PURE__ */ __name(() => {
        set(editButtonHover, !0);
      }, "onPointerEnter"),
      onPointerLeave: /* @__PURE__ */ __name(() => {
        set(editButtonHover, !1);
      }, "onPointerLeave")
    });
  }, "headerOptions");
  let editButtonHover = state(!1);
  const collID = `${$$props.actor.uuid}.history`, tooltipEnabled = getPilotSheetTooltipEnabled(), expression_3 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.history.label"));
  HeaderMain($$anchor, {
    get text() {
      return get$1(expression_3);
    },
    headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-weapon"],
    textStyle: [
      "la-text-header",
      "-fontsize2",
      "-overflowhidden"
    ],
    borderStyle: ["la-brdr-weapon"],
    extensionTextFunction: /* @__PURE__ */ __name(() => {
      if (get$1(editButtonHover)) return `--${getLocalized("LA.edit.extension")}`;
    }, "extensionTextFunction"),
    collapseID: collID,
    startCollapsed: !0,
    headerContent: headerOptions,
    children: /* @__PURE__ */ __name(($$anchor2, $$slotProps) => {
      const expression_4 = /* @__PURE__ */ derived(() => getThemeHistoryLabel(getCSSDocumentTheme($$props.actor.uuid))), expression_5 = /* @__PURE__ */ derived(() => $$props.system.history ? $$props.system.history : getLocalized("LA.placeholder"));
      EffectBox($$anchor2, {
        get name() {
          return get$1(expression_4);
        },
        get effect() {
          return get$1(expression_5);
        }
      });
    }, "children"),
    $$slots: { default: !0 }
  }), pop();
}
__name(History, "History");
function Note($$anchor, $$props) {
  push($$props, !0);
  const headerOptions = /* @__PURE__ */ __name(($$anchor2) => {
    const expression = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.edit.tooltip")), expression_2 = /* @__PURE__ */ derived(() => getLocalized("LA.edit.tooltip"));
    GlyphButton($$anchor2, {
      style: [
        "fas fa-edit",
        "-fontsize2",
        "-height2",
        "-lineheight2",
        "la-prmy-header -glow-prmy la-scdy-primary -glow-scdy-hover"
      ],
      get flowClass() {
        return FlowClass.EditText;
      },
      path: "system.notes",
      tooltipEnabled,
      get tooltipTheme() {
        return get$1(expression);
      },
      get tooltip() {
        return get$1(expression_1);
      },
      get tooltipDirection() {
        return TooltipDirection.UP;
      },
      get logText() {
        return get$1(expression_2);
      },
      get logType() {
        return TextLogHook.PilotHeader;
      },
      get logTypeReset() {
        return TextLogHook.PilotHeaderReset;
      },
      onPointerEnter: /* @__PURE__ */ __name(() => {
        set(editButtonHover, !0);
      }, "onPointerEnter"),
      onPointerLeave: /* @__PURE__ */ __name(() => {
        set(editButtonHover, !1);
      }, "onPointerLeave")
    });
  }, "headerOptions");
  let editButtonHover = state(!1);
  const collID = `${$$props.actor.uuid}.notes`, tooltipEnabled = getPilotSheetTooltipEnabled(), expression_3 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.notes.label"));
  HeaderMain($$anchor, {
    get text() {
      return get$1(expression_3);
    },
    headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-weapon"],
    textStyle: [
      "la-text-header",
      "-fontsize2",
      "-overflowhidden"
    ],
    borderStyle: ["la-brdr-weapon"],
    extensionTextFunction: /* @__PURE__ */ __name(() => {
      if (get$1(editButtonHover)) return `--${getLocalized("LA.edit.extension")}`;
    }, "extensionTextFunction"),
    collapseID: collID,
    startCollapsed: !0,
    headerContent: headerOptions,
    children: /* @__PURE__ */ __name(($$anchor2, $$slotProps) => {
      const expression_4 = /* @__PURE__ */ derived(() => getThemeHistoryLabel(getCSSDocumentTheme($$props.actor.uuid))), expression_5 = /* @__PURE__ */ derived(() => $$props.system.notes ? $$props.system.notes : getLocalized("LA.placeholder"));
      EffectBox($$anchor2, {
        get name() {
          return get$1(expression_4);
        },
        get effect() {
          return get$1(expression_5);
        }
      });
    }, "children"),
    $$slots: { default: !0 }
  }), pop();
}
__name(Note, "Note");
var root_3 = /* @__PURE__ */ template('<span class="-fontsize0 -upper">SYNC</span>'), on_change$1 = /* @__PURE__ */ __name((event2, overridePilotIDWithCloudID) => overridePilotIDWithCloudID(event2), "on_change$1"), root_5$1 = /* @__PURE__ */ template("<option> </option>"), root_4$1 = /* @__PURE__ */ template('<select class="la-sync__select -textaligncenter la-bckg-transparent la-text-text la-brdr-text" name="selectCloudId" data-type="text"></select>'), root_2$1 = /* @__PURE__ */ template('<div class="la-combine-h -aligncenter -widthfull -gap1"><!> <div class="la-combine-v -widthfull -gap0"><!> <input type="text" class="-bordersround -small la-text-text -padding1-lr" name="system.cloud_id" data-dtype="string"></div></div>'), root_6$3 = /* @__PURE__ */ template(`<input type="file" class="la-text-text
                lcp-up" id="pilot-json-import" name="pilot-json-up" accept=".json">`), root_1$3 = /* @__PURE__ */ template("<!> <!>", 1);
function Sync($$anchor, $$props) {
  push($$props, !0);
  let cloudID = state(proxy($$props.system.cloud_id || ""));
  const collID = `${$$props.actor.uuid}.sync`, tooltipEnabled = getPilotSheetTooltipEnabled();
  function overridePilotIDWithCloudID(event2) {
    event2.stopPropagation(), set(cloudID, proxy(event2.target.value));
  }
  __name(overridePilotIDWithCloudID, "overridePilotIDWithCloudID");
  function getGlowColor() {
    return getBrightness(getThemeKey($$props.actor.uuid)) === "dark" ? "la-text-text" : "la-text-secondary";
  }
  __name(getGlowColor, "getGlowColor");
  const expression = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.sync.label"));
  HeaderMain($$anchor, {
    get text() {
      return get$1(expression);
    },
    headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-primary"],
    textStyle: [
      "la-text-header",
      "-fontsize2",
      "-overflowhidden"
    ],
    borderStyle: ["la-brdr-primary"],
    collapseID: collID,
    startCollapsed: !1,
    children: /* @__PURE__ */ __name(($$anchor2, $$slotProps) => {
      var fragment_1 = root_1$3(), node = first_child(fragment_1);
      const expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.sync.download.label"));
      EffectBox(node, {
        get name() {
          return get$1(expression_1);
        },
        children: /* @__PURE__ */ __name(($$anchor3, $$slotProps2) => {
          var div = root_2$1(), node_1 = child(div);
          const expression_2 = /* @__PURE__ */ derived(() => [
            "la-combine-v",
            "mdi mdi-cloud-download",
            "-fontsize5",
            getGlowColor(),
            "la-prmy-header -glow-prmy la-scdy-primary -glow-scdy-hover",
            "-padding1-lr"
          ]), expression_3 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_4 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.sync.download.tooltip")), expression_5 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.sync.download.tooltip"));
          GlyphButton(node_1, {
            get style() {
              return get$1(expression_2);
            },
            get flowClass() {
              return FlowClass.DownloadFromCloud;
            },
            action: "download",
            tooltipEnabled,
            get tooltipTheme() {
              return get$1(expression_3);
            },
            get tooltip() {
              return get$1(expression_4);
            },
            get tooltipDirection() {
              return TooltipDirection.LEFT;
            },
            get logText() {
              return get$1(expression_5);
            },
            get logType() {
              return TextLogHook.PilotHeader;
            },
            get logTypeReset() {
              return TextLogHook.PilotHeaderReset;
            },
            children: /* @__PURE__ */ __name(($$anchor4, $$slotProps3) => {
              var span = root_3();
              append($$anchor4, span);
            }, "children"),
            $$slots: { default: !0 }
          });
          var div_1 = sibling(node_1, 2), node_2 = child(div_1);
          {
            var consequent = /* @__PURE__ */ __name(($$anchor4) => {
              var select2 = root_4$1();
              select2.__change = [on_change$1, overridePilotIDWithCloudID], each(select2, 21, () => $$props.pilotCache, index, ($$anchor5, pilot) => {
                var option = root_5$1(), option_value = {}, text2 = child(option);
                template_effect(() => {
                  option_value !== (option_value = get$1(pilot).id) && (option.value = (option.__value = get$1(pilot).id) == null ? "" : get$1(pilot).id), set_selected(option, get$1(pilot).id === get$1(cloudID)), set_text(text2, `${get$1(pilot).callsign} - ${get$1(pilot).name}`);
                }), append($$anchor5, option);
              }), append($$anchor4, select2);
            }, "consequent");
            if_block(node_2, ($$render) => {
              var _a;
              (_a = $$props.pilotCache) != null && _a.length && $$render(consequent);
            });
          }
          var input = sibling(node_2, 2);
          template_effect(
            ($0) => {
              set_value(input, get$1(cloudID)), set_attribute(input, "placeholder", $0);
            },
            [
              () => getLocalized("LA.pilot.sync.download.subLabel")
            ]
          ), append($$anchor3, div);
        }, "children"),
        $$slots: { default: !0 }
      });
      var node_3 = sibling(node, 2);
      const expression_6 = /* @__PURE__ */ derived(() => getLocalized("LA.pilot.sync.import.label"));
      EffectBox(node_3, {
        get name() {
          return get$1(expression_6);
        },
        children: /* @__PURE__ */ __name(($$anchor3, $$slotProps2) => {
          var input_1 = root_6$3();
          append($$anchor3, input_1);
        }, "children"),
        $$slots: { default: !0 }
      }), append($$anchor2, fragment_1);
    }, "children"),
    $$slots: { default: !0 }
  }), pop();
}
__name(Sync, "Sync");
delegate(["change"]);
var root$3 = /* @__PURE__ */ template("<!> <!> <!> <!>", 1);
function Dossier($$anchor, $$props) {
  push($$props, !0);
  const props = /* @__PURE__ */ rest_props($$props, ["$$slots", "$$events", "$$legacy"]), { actor } = props, collID = `${actor.uuid}.status.activeEffects`;
  var fragment = root$3(), node = first_child(fragment);
  Sync(node, spread_props(() => props));
  var node_1 = sibling(node, 2);
  const expression = /* @__PURE__ */ derived(() => getLocalized("LA.tab.status.effects.label"));
  HeaderMain(node_1, {
    get text() {
      return get$1(expression);
    },
    headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-primary"],
    textStyle: [
      "la-text-header",
      "-fontsize2",
      "-overflowhidden"
    ],
    borderStyle: ["la-brdr-primary"],
    collapseID: collID,
    startCollapsed: !1,
    children: /* @__PURE__ */ __name(($$anchor2, $$slotProps) => {
      ActiveEffects($$anchor2, spread_props(() => props));
    }, "children"),
    $$slots: { default: !0 }
  });
  var node_2 = sibling(node_1, 2);
  History(node_2, spread_props(() => props));
  var node_3 = sibling(node_2, 2);
  Note(node_3, spread_props(() => props)), append($$anchor, fragment), pop();
}
__name(Dossier, "Dossier");
var root_1$2 = /* @__PURE__ */ template('<div class="la-combine-v -widthfull clipped-bot-alt"><div class="la-combine-h -justifyevenly -widthfull la-bckg-darken-1 -padding0-tb"><!> <!> <!></div> <div class="la-combine-h -justifyevenly -widthfull -padding1-tb -fontsize1 -bold"><!> <!> <!> <!></div> <div class="la-combine-h -justifyevenly -widthfull la-bckg-darken-1 -padding0-tb"><!> <!> <!></div></div>');
function MechStats($$anchor, $$props) {
  push($$props, !0);
  const tooltipEnabled = getPilotSheetTooltipEnabled(), collID = `${$$props.actor.uuid}.mechStats`, expression = /* @__PURE__ */ derived(() => getLocalized("LA.tab.statistics.label"));
  HeaderMain($$anchor, {
    get text() {
      return get$1(expression);
    },
    headerStyle: [MAIN_HEADER_STYLE$1, "la-bckg-weapon"],
    textStyle: [
      "la-text-header",
      "-fontsize2",
      "-overflowhidden"
    ],
    borderStyle: [
      "la-brdr-transparent",
      "la-bckg-card",
      "clipped-bot-alt"
    ],
    collapseID: collID,
    startCollapsed: !0,
    children: /* @__PURE__ */ __name(($$anchor2, $$slotProps) => {
      var div = root_1$2(), div_1 = child(div), node = child(div_1);
      const expression_1 = /* @__PURE__ */ derived(() => getLocalized("LA.armor.short")), expression_2 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_3 = /* @__PURE__ */ derived(() => getLocalized("LA.armor.tooltip"));
      StatComboShort(node, {
        icon: "cci cci-role-defender -alignselfcenter",
        get label() {
          return get$1(expression_1);
        },
        get value() {
          return $$props.selectedMech.system.armor;
        },
        outerStyle: ["la-text-text", "-fontsize5"],
        innerStyle: [
          "-divider",
          "-fontsize1",
          "la-prmy-accent",
          "-textaligncenter",
          "-bold"
        ],
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_2);
        },
        get tooltip() {
          return get$1(expression_3);
        },
        get tooltipDirection() {
          return TooltipDirection.LEFT;
        }
      });
      var node_1 = sibling(node, 2);
      const expression_4 = /* @__PURE__ */ derived(() => getLocalized("LA.evasion.short")), expression_5 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_6 = /* @__PURE__ */ derived(() => getLocalized("LA.evasion.tooltip"));
      StatComboShort(node_1, {
        icon: "cci cci-evasion -alignselfcenter",
        get label() {
          return get$1(expression_4);
        },
        get value() {
          return $$props.selectedMech.system.evasion;
        },
        outerStyle: ["la-text-text", "-fontsize5"],
        innerStyle: [
          "-divider",
          "-fontsize1",
          "la-prmy-accent",
          "-textaligncenter",
          "-bold"
        ],
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_5);
        },
        get tooltip() {
          return get$1(expression_6);
        },
        get tooltipDirection() {
          return TooltipDirection.LEFT;
        }
      });
      var node_2 = sibling(node_1, 2);
      const expression_7 = /* @__PURE__ */ derived(() => getLocalized("LA.edefense.short")), expression_8 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_9 = /* @__PURE__ */ derived(() => getLocalized("LA.edefense.tooltip"));
      StatComboShort(node_2, {
        icon: "cci cci-edef -alignselfcenter",
        get label() {
          return get$1(expression_7);
        },
        get value() {
          return $$props.selectedMech.system.edef;
        },
        outerStyle: ["la-text-text", "-fontsize5"],
        innerStyle: [
          "-divider",
          "-fontsize1",
          "la-prmy-accent",
          "-textaligncenter",
          "-bold"
        ],
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_8);
        },
        get tooltip() {
          return get$1(expression_9);
        },
        get tooltipDirection() {
          return TooltipDirection.LEFT;
        }
      });
      var div_2 = sibling(div_1, 2), node_3 = child(div_2);
      const expression_10 = /* @__PURE__ */ derived(() => getLocalized("LA.hitpoint.short")), expression_11 = /* @__PURE__ */ derived(() => getCSSDocumentTheme($$props.actor.uuid)), expression_12 = /* @__PURE__ */ derived(() => getLocalized("LA.hitpoint.tooltip"));
      StatComboShort(node_3, {
        icon: "mdi mdi-heart-flash -alignselfcenter",
        get label() {
          return get$1(expression_10);
        },
        get value() {
          return $$props.selectedMech.system.hp.max;
        },
        outerStyle: ["la-text-text", "-fontsize4"],
        innerStyle: [
          "-divider",
          "-fontsize1",
          "la-prmy-accent",
          "-textaligncenter",
          "-bold"
        ],
        tooltipEnabled,
        get tooltipTheme() {
          return get$1(expression_11);
        },
        get tooltip() {
          return get$1(expression_12);
        },
        get tooltipDirection() {
   