import { injectConfig } from './injectConfig.js';

Hooks.on("renderSceneConfig", (app,html)=>{

    const data = {
        "moduleId": "levels-layer-effects",
        "inject": `select[name="weather"]`,
        "enableEffects": {
            "type": "checkbox",
            "label": "Enable Levels Automatic Blur",
            "default": false,
        },
        "blurMulti": {
            type: "range",
            label: "Blur Factor",
            notes: "The value the blur effect strength is divided by - use a value that corresponds to the average hight of a level in your scene. Higher number means lower blur.",
            default: 10,
            min: 0.1,
            max: 100,
            step: 0.1,
        },
    }

    injectConfig.inject(app,html,data);
    
})

Hooks.on("init", () => { 
    game.settings.register("levels-layer-effects", "disableBlur", {
      name: game.i18n.localize(
        "levels-layer-effects.settings.disableBlur.name"
      ),
      hint: game.i18n.localize(
        "levels-layer-effects.settings.disableBlur.hint"
      ),
      scope: "client",
      config: true,
      type: Boolean,
      default: false,
    });
  });