class AutoCover {
    constructor() {
        this.CONSTS = {};
        this.CONSTS.COVER = {
            noCover: 0,
            halfCover: 1,
            threeQuartersCover: 2,
            fullCover: 3,
        };
    }

    static deleteChatMessages(ids) {
        ids = Array.isArray(ids) ? ids : [ids];
        ids.forEach((id) => this._chatMessageDeletionQueue.add(id));
        this._deleteQueuedChatMessages();
    }

    static coverToText(cover) {
        const COVERTOTEXT = [game.i18n.localize("levelsautocover.coverlevel.nocover"), game.i18n.localize("levelsautocover.coverlevel.half"), game.i18n.localize("levelsautocover.coverlevel.threequarters"), game.i18n.localize("levelsautocover.coverlevel.full")];
        return COVERTOTEXT[cover];
    }

    //define effects as 10,name|20,name
    static getCoverData() {
        try {
            const i = game.items.find((i) => i.name.includes("LevelsAutoCover"))?.effects;
            if (!i && game.settings.get("levelsautocover", "enableActiveEffect")) ui.notifications.error("LevelsAutoCover: Cover Item not Found, make sure you imported it from the compendium or created it.");
            const e = i ? Array.from(i) : [];
            let levelsautocover = game.settings.get("levelsautocover", "activeEffectDefinition");
            let effectsArray = levelsautocover.split("|");
            let effectsDb = [];
            for (let eff of effectsArray) {
                if (eff && eff != "") {
                    let stringSplit = eff.split(",");
                    let effectData = game.settings.get("levelsautocover", "enableActiveEffect") ? e.find((e) => e.label == stringSplit[1]) : null;
                    effectsDb.push({
                        percent: parseInt(stringSplit[0]),
                        name: stringSplit[1],
                        effectData: effectData,
                    });
                }
            }
            return effectsDb;
        } catch (e) {
            ui.notifications.error("LevelsAutoCover: Cover Item not Found, make sure you imported it from the compendium or created it.");
        }
    }

    static calculateCover(sourceToken, targetToken, options = {}) {
        const tokensProvideCover = options.tokensProvideCover ?? game.settings.get("levelsautocover", "tokensProvideCover");
        const ignoreFriendly = options.ignoreFriendly ?? game.settings.get("levelsautocover", "ignoreFriendly");
        const copsesProvideCover = options.copsesProvideCover ?? game.settings.get("levelsautocover", "copsesProvideCover");
        const tokenCoverAA = options.tokenCoverAA ?? game.settings.get("levelsautocover", "tokenCoverAA");
        const coverData = options.coverData ?? this.getCoverData();
        const hpDataPath = options.hpDataPath ?? game.settings.get("levelsautocover", "tokenhppath");
        const precision = options.precision ?? game.settings.get("levelsautocover", "coverRestriction");
        const apiMode = options.apiMode ?? game.settings.get("levelsautocover", "apiMode");
        const getAllObstructingTokens = options.getAllObstructingTokens ?? false;
        const DEBUG = CONFIG.Levels?.API?.DEBUG || options.DEBUG;
        const isLevels = game.modules.get("levels")?.active;

        let perfStart, perfEnd;
        if (DEBUG) {
            perfStart = performance.now();
        }
        const padd = 4;
        const sourceHeight = sourceToken.losHeight ?? sourceToken?.document?.elevation ?? 0;
        const baseZ = targetToken.document.elevation;
        const targetHeight = (targetToken.losHeight == baseZ ? baseZ + 0.001 : targetToken.losHeight) ?? sourceHeight + 0.001;
        const sourcePov = {
            x: sourceToken.center.x,
            y: sourceToken.center.y,
            z: sourceHeight,
        };
        let volPercent = 0;
        //declare points to test
        let collisionTestPoints = [];
        const targetH = targetToken.h - padd;
        const targetW = targetToken.w - padd;
        for (let zC = baseZ; zC <= targetHeight; zC += (targetHeight - baseZ) / precision) {
            for (let yC = targetToken.y + padd / 2; yC <= targetToken.y + targetH + padd / 2; yC += targetH / precision) {
                for (let xC = targetToken.x + padd / 2; xC <= targetToken.x + targetW + padd / 2; xC += targetW / precision) {
                    collisionTestPoints.push({ x: xC, y: yC, z: zC });
                }
            }
        }
        if (DEBUG) canvas.controls.debug.clear();
        const testCollision = (origin, destination) => {
            return isLevels ? CONFIG.Levels.API.testCollision(origin, destination, "sight") :  CONFIG.Canvas.polygonBackends["sight"].testCollision(origin, destination, {type: "sight", mode: "any", source: sourceToken});
        };
        for (let point of collisionTestPoints) {
            console.log(testCollision(sourcePov, point))
            if (!testCollision(sourcePov, point)) volPercent++; //if (!canvas.walls.checkCollision(sourcePov, point)) volPercent++;
            if (DEBUG) {
                let isCollision = testCollision(sourcePov, point);
                let color = isCollision ? 0xff0000 : 0x00ff08;
                let coords = [sourceToken.center.x, sourceToken.center.y, point.x, point.y];
                canvas.controls.debug.beginFill(color).lineStyle(1, color).drawPolygon(coords).endFill();
            }
        }

        let calculatedCover = (volPercent * 100) / collisionTestPoints.length;
        let isTokenCover = false;
        let obstructingToken = null;
        const obstructingTokens = [];
        const tokenCoverAAname = tokenCoverAA;
        let tokenCoverCoverData;
        for (let cover of coverData) {
            if (cover.name === tokenCoverAAname) tokenCoverCoverData = cover;
        }
        if (tokensProvideCover) {
            for (let token of canvas.tokens.placeables) {
                if (isTokenCover === true && !getAllObstructingTokens) break;
                if (ignoreFriendly && sourceToken.document.disposition === token.document.disposition) continue;
                let divideHby = 1;
                if (token.actor && foundry.utils.getProperty(token, hpDataPath) == 0) {
                    if (copsesProvideCover) {
                        divideHby = 3;
                    } else {
                        continue;
                    }
                }
                let B0 = {
                    x: token.x + padd,
                    y: token.y + padd,
                    z: token.document.elevation,
                };
                let B1 = {
                    x: token.x + token.w - padd,
                    y: token.y + token.h - padd,
                    z: token.losHeight / divideHby,
                };
                if (sourceToken.id === token.id || token.id === targetToken.id) continue;
                isTokenCover = this.segmentBoxIntersection(sourcePov, { x: targetToken.center.x, y: targetToken.center.y, z: targetHeight }, B0, B1);
                if (isTokenCover) {
                    obstructingToken = token;
                    obstructingTokens.push(token);
                }
            }
        }
        isTokenCover = isTokenCover || obstructingTokens.length > 0;
        if (isTokenCover === true) {
            //this.drawObstruction(targetToken);
            if (tokenCoverCoverData !== undefined && calculatedCover > tokenCoverCoverData.percent && isTokenCover === true) calculatedCover = tokenCoverCoverData.percent - 0.1;
        }

        if (DEBUG) {
            console.log("Total Volume Percentage:", Math.round(calculatedCover), "%");
            console.log("Points Tested:", collisionTestPoints.length);
            perfEnd = performance.now();
            console.log(`Levels 3D Cover Calc took ${perfEnd - perfStart} ms, FPS:${Math.round(canvas.app.ticker.FPS)}`);
        }
        Hooks.callAll("calculateCover", sourceToken, targetToken, calculatedCover, isTokenCover);

        if (apiMode) {
            const data = {
                rawCover: calculatedCover,
                visibleVolume: calculatedCover,
                coveredVolume: 100 - calculatedCover,
                obstructingToken: obstructingToken,
                obstructingTokens: obstructingTokens,
                cover: null,
            };
            for (let cover of coverData) {
                if (calculatedCover < cover.percent) {
                    data.cover = coverData[coverData.indexOf(cover)];
                    return data;
                }
            }
            return data;
        }

        for (let cover of coverData) {
            if (calculatedCover < cover.percent) {
                if (game.settings.get("levelsautocover", "enableActiveEffect") && !sourceToken?.actor?.flags?.levelsautocover?.noae) {
                    this.applyActiveEffects(sourceToken, cover.effectData);
                    return [coverData.indexOf(cover), isTokenCover];
                } else {
                    return [coverData.indexOf(cover), isTokenCover];
                }
            }
        }
        return [false, isTokenCover];
    }
    //deprecated to remove
    static drawCover(targetToken, coverLevel) {
        if (!game.settings.get("levelsautocover", "displayToken")) return;
        const tip = this.getCoverData()[coverLevel].name;
        const style = CONFIG.canvasTextStyle.clone();
        style.fontSize = game.settings.get("levelsautocover", "textSize") || Math.max(Math.round(canvas.dimensions.size * 0.36 * 12) / 12, 12) * 0.7;
        const text = new PreciseText(tip, style);
        text.anchor.set(0, 0);
        text.name = "levelsAutoCover";
        text.y = -canvas.scene.dimensions.size * 0.7;
        text.x = -text.width / 2 + targetToken.w / 2;
        targetToken.addChild(text);
    }

    static async displayChat(targetToken, originToken, coverLevel, isTokenCover) {
        if (!game.settings.get("levelsautocover", "displayChat")) return;
        const coverText = typeof coverLevel === "string" ? coverLevel : this.getCoverData()[coverLevel].name;
        const obstructedText = game.settings.get("levelsautocover", "tokenCoverText");
        const showName = !game.settings.get("levelsautocover", "onlyOwnedNames");
        const content = `
    <div class="levelsautocover-header">${coverText}${isTokenCover ? " - " + obstructedText : ""}</div>
    <div class="levelsautocover-content"><strong>${originToken.actor?.hasPlayerOwner || showName ? originToken.document.name : "???"}</strong><i class="fas fa-long-arrow-alt-right"></i><strong>${targetToken.actor?.hasPlayerOwner || showName ? targetToken.document.name : "???"}</strong></div>
      `.trim();

        const msg = await ChatMessage.create({
            user: game.user.id,
            content: content,
            flags: {
                levelsautocover: {
                    isCoverMessage: true,
                },
            },
            speaker: ChatMessage.getSpeaker({ token: originToken }),
            type: CONST.CHAT_MESSAGE_STYLES.OTHER,
        });
    }
    //deprecated to remove
    static drawObstruction(targetToken) {
        const tip = game.settings.get("levelsautocover", "tokenCoverText");
        const style = CONFIG.canvasTextStyle.clone();
        style.fontSize = game.settings.get("levelsautocover", "textSize") || Math.max(Math.round(canvas.dimensions.size * 0.36 * 12) / 12, 12) * 0.7;
        const text = new PreciseText(tip, style);
        text.anchor.set(0, 0);
        text.name = "levelsAutoCover";
        text.y = -(canvas.scene.dimensions.size * 0.7) - style.fontSize;
        text.x = -text.width / 2 + targetToken.w / 2;
        targetToken.addChild(text);
    }

    static clearCover(targetToken) {
        for (let child of targetToken.children) {
            if (child.name === "levelsAutoCover") {
                targetToken.removeChild(child);
                child.destroy();
            }
        }
        for (let child of targetToken.children) {
            if (child.name === "levelsAutoCover") {
                targetToken.removeChild(child);
                child.destroy();
            }
        }
    }

    static async applyActiveEffects(token, effect) {
        if (game.settings.get("levelsautocover", "enableActiveEffect") === false) return;
        setTimeout(async function () {
            await AutoCover.clearActiveEffects(token);
            await token.actor.createEmbeddedDocuments("ActiveEffect", [effect.toJSON()]);
        }, 500);
    }

    static async clearActiveEffects(token) {
        if (game.settings.get("levelsautocover", "enableActiveEffect") === false) return;
        const coverData = this.getCoverData();
        for (let cover of coverData) {
            if (!token.actor) continue;
            let effectToRemove = Array.from(token.actor.effects).find((e) => e.label == cover.name);
            if (effectToRemove?.deleteQueued) continue;
            if (effectToRemove) {
                effectToRemove.deleteQueued = true;
                await token.actor.deleteEmbeddedDocuments("ActiveEffect", [effectToRemove.id]);
            }
        }
    }

    static segmentBoxIntersection(p0, p1, b0, b1) {
        const x0 = p0.x;
        const y0 = p0.y;
        const z0 = p0.z;
        const x1 = p1.x;
        const y1 = p1.y;
        const z1 = p1.z;
        const faces = [
            [
                //Back Face
                { x: b0.x, y: b0.y, z: b0.z },
                { x: b0.x, y: b0.y, z: b1.z },
                { x: b1.x, y: b0.y, z: b1.z },
                { x: b1.x, y: b0.y, z: b0.z },
            ],
            [
                //Front Face
                { x: b0.x, y: b1.y, z: b0.z },
                { x: b0.x, y: b1.y, z: b1.z },
                { x: b1.x, y: b1.y, z: b1.z },
                { x: b1.x, y: b1.y, z: b0.z },
            ],
            [
                //Left Face
                { x: b0.x, y: b0.y, z: b0.z },
                { x: b0.x, y: b0.y, z: b1.z },
                { x: b0.x, y: b1.y, z: b1.z },
                { x: b0.x, y: b1.y, z: b0.z },
            ],
            [
                //Right Face
                { x: b1.x, y: b0.y, z: b0.z },
                { x: b1.x, y: b0.y, z: b1.z },
                { x: b1.x, y: b1.y, z: b1.z },
                { x: b1.x, y: b1.y, z: b0.z },
            ],
        ];
        //check if a line intersects a box
        function boxCollisionTest() {
            for (let face of faces) {
                //declare points in 3d space of the rectangle created by the wall
                const wx1 = face[0].x;
                const wx2 = face[1].x;
                const wx3 = face[2].x;
                const wy1 = face[0].y;
                const wy2 = face[1].y;
                const wy3 = face[2].y;
                const wz1 = face[0].z;
                const wz2 = face[1].z;
                const wz3 = face[2].z;
                const wallBotTop = [Math.min(wz1, wz2, wz3), Math.max(wz1, wz2, wz3)];

                //calculate the parameters for the infinite plane the rectangle defines
                const A = wy1 * (wz2 - wz3) + wy2 * (wz3 - wz1) + wy3 * (wz1 - wz2);
                const B = wz1 * (wx2 - wx3) + wz2 * (wx3 - wx1) + wz3 * (wx1 - wx2);
                const C = wx1 * (wy2 - wy3) + wx2 * (wy3 - wy1) + wx3 * (wy1 - wy2);
                const D = -wx1 * (wy2 * wz3 - wy3 * wz2) - wx2 * (wy3 * wz1 - wy1 * wz3) - wx3 * (wy1 * wz2 - wy2 * wz1);

                //solve for p0 p1 to check if the points are on opposite sides of the plane or not
                const P1 = A * x0 + B * y0 + C * z0 + D;
                const P2 = A * x1 + B * y1 + C * z1 + D;

                //don't do anything else if the points are on the same side of the plane
                if (P1 * P2 > 0) continue;

                //calculate intersection point
                const t = -(A * x0 + B * y0 + C * z0 + D) / (A * (x1 - x0) + B * (y1 - y0) + C * (z1 - z0)); //-(A*x0 + B*y0 + C*z0 + D) / (A*x1 + B*y1 + C*z1)
                const ix = x0 + (x1 - x0) * t;
                const iy = y0 + (y1 - y0) * t;
                const iz = Math.round(z0 + (z1 - z0) * t);

                //return true if the point is inisde the rectangle
                const isb = isBetween({ x: Math.min(wx1, wx2, wx3), y: Math.min(wy1, wy2, wy3) }, { x: Math.max(wx1, wx2, wx3), y: Math.max(wy1, wy2, wy3) }, { x: ix, y: iy });
                if (isb && iz <= wallBotTop[1] && iz >= wallBotTop[0]) return true;
            }
            return false;
        }
        //Check if a point in 2d space is betweeen 2 points
        function isBetween(a, b, c) {
            //test
            //return ((a.x<=c.x && c.x<=b.x && a.y<=c.y && c.y<=b.y) || (a.x>=c.x && c.x >=b.x && a.y>=c.y && c.y >=b.y))

            const dotproduct = (c.x - a.x) * (b.x - a.x) + (c.y - a.y) * (b.y - a.y);
            if (dotproduct < 0) return false;

            const squaredlengthba = (b.x - a.x) * (b.x - a.x) + (b.y - a.y) * (b.y - a.y);
            if (dotproduct > squaredlengthba) return false;

            return true;
        }

        return boxCollisionTest();
    }

    static computeCover(token) {
        AutoCover.clearActiveEffects(_token);
        setTimeout(() => {
            const coverData = AutoCover.calculateCover(_token, token);
            const coverLevel = coverData[0];
            if (coverLevel !== false) {
                //AutoCover.drawCover(token, coverLevel)
                AutoCover.displayChat(token, _token, coverLevel, coverData[1]);
            } else AutoCover.clearActiveEffects(_token);
        }, 1000);
    }

    static async clearAllEffects() {
        for (let token of canvas.tokens.placeables) {
            await AutoCover.clearActiveEffects(token);
        }
    }

    static async manualCoverCheck(stoken, ttarget) {
        const token = stoken ?? canvas.tokens.controlled[0] ?? _token;
        const target = ttarget ?? Array.from(game.user.targets)[0];
        if (!token || !target || target === token) return;
        if (this._currentManualCheck?.token === token && this._currentManualCheck?.target === target) return;
        this._currentManualCheck = { token, target };
        const coverData = AutoCover.calculateCover(token, target, { apiMode: true });
        const oldMessages = Array.from(game.messages).filter((m) => m.flags?.levelsautocover?.isCoverMessage && m.isOwner);
        this.deleteChatMessages(oldMessages.map((m) => m.id));
        await this.displayChat(target, token, coverData.cover?.name ?? game.i18n.localize("levelsautocover.coverlevel.nocover"), !!coverData.obstructingToken);
        this._currentManualCheck = null;
    }
}

AutoCover._chatMessageDeletionQueue = new Set();

AutoCover._deleteQueuedChatMessages = foundry.utils.debounce(() => {
    const ids = Array.from(AutoCover._chatMessageDeletionQueue);
    ChatMessage.deleteDocuments(ids);
    AutoCover._chatMessageDeletionQueue.clear();
}, 100);
