import {initConfig} from "./config.js";
import {showWelcome} from "./lib/welcome.js";
import {registerSettings} from "./settings.js";
import { mergeTiles, upload } from "./optimizer.js";
import { BloatDetector } from "./app/bloatDetector.js";

export const MODULE_ID = "media-optimizer";

Hooks.on("init", () => {
    registerSettings();
});

Hooks.on("ready", () => {
    showWelcome();
    initConfig();

    window.MediaOptimizer = {
        BloatDetector,
        API: {
            mergeTiles,
        }
    };

    libWrapper.register(MODULE_ID, "FilePicker.upload", upload, "WRAPPER");
});