import { MODULE_ID } from "./main.js";
import { TileCombiner } from "./app/TileCombiner.js";
import { FileConverter } from "./app/Converter.js";

export function initConfig() {
    if (!game.user.isGM) return;

    Hooks.on("getSceneControlButtons", (buttons) => {
        buttons
            .find((b) => b.name === "tiles")
            ?.tools?.push({
                name: "tile-combiner",
                title: game.i18n.localize(`${MODULE_ID}.tile-combiner.title`),
                icon: "fas fa-compress",
                button: true,
                visible: true,
                onClick: () => {
                    new TileCombiner().render(true);
                },
            });
    });

    Hooks.on("getFilePickerHeaderButtons", (app, buttons) => {
        buttons.unshift({
            class: "file-converter",
            icon: "fas fa-compress",
            label: game.i18n.localize(`${MODULE_ID}.file-converter.header-button`),
            onclick: () => {
                new FileConverter(app.result.files, app.result.target).render(true);
            },
        });
    });
}
