const foundryContextId = "foundryContextId", settings$1 = { users: "users", usersMenu: "usersMenu", gmCompanionUser: "gmCompanionUsers", gmCompanionMenu: "gmCompanionMenu", lastActorId: "lastActorId" };
var FoundryUserRoles$1 = ((t18) => (t18[t18.NONE = 0] = "NONE", t18[t18.PLAYER = 1] = "PLAYER", t18[t18.TRUSTED_PLAYER = 2] = "TRUSTED_PLAYER", t18[t18.ASSISTANT_GM = 3] = "ASSISTANT_GM", t18[t18.GAMEMASTER = 4] = "GAMEMASTER", t18))(FoundryUserRoles$1 || {});
function getBaseModuleId$1() {
  return "mobile-companion";
}
let callback, currentSheet, factory;
function setSubModuleId(t18) {
  callback = t18;
}
function getFullModuleId$1() {
  let t18;
  return t18 = game?.system?.id ? getBaseModuleId$1() + "-" + game.system.id : getBaseModuleId$1() + "-" + callback(), t18;
}
function saveLastActorId(t18) {
  game.settings.set(getFullModuleId$1(), settings$1.lastActorId, t18);
}
function getLastActorId() {
  return game.settings.get(getFullModuleId$1(), settings$1.lastActorId);
}
function isMobileCompanion() {
  return isUserCompanion();
}
function isUserCompanion() {
  const t18 = game.settings.get(getFullModuleId$1(), settings$1.users)[game.user.id];
  return !!t18?.enabled && checkScreenWidth(t18);
}
function checkScreenWidth(t18) {
  let e2 = false;
  return t18.screenWidth <= 0 && (e2 = true), screen.width < t18.screenWidth && (e2 = true), e2;
}
function activateSheet(t18) {
  factory = t18, checkCanvas(), popupSheet(), addEventListener("resize", onResize);
}
function onResize() {
  currentSheet?.element.css({ width: window.innerWidth, height: window.innerHeight });
}
function checkCanvas() {
  game.settings.get("core", "noCanvas") || game.settings.set("core", "noCanvas", true);
}
function popupSheet() {
  const t18 = getOwnedActors(), e2 = getLastActorId();
  if (e2) {
    const n2 = game.actors.get(e2), o2 = t18.some((t19) => t19.id === e2);
    if (n2 && (o2 || game.user.isGM)) return void switchToActor(n2);
  }
  if (!(t18?.length > 0)) throw console.error("No actor for user found."), new NoActorFoundError("No actor found!. You are not the owner of any actor. Please ask your GM to get access to the actor.");
  switchToActor(t18[0]);
}
class NoActorFoundError extends Error {
  constructor(t18 = "No actor found") {
    super(t18), this.name = "NoActorFoundError";
  }
}
function getOwnedActors() {
  return game.user.isGM ? game.actors.contents : game.actors.filter((t18) => isActorOwnedByUser(t18));
}
function isActorOwnedByUser(t18) {
  return 3 === t18.ownership[game.user.id];
}
function switchToActor(t18) {
  currentSheet && currentSheet.close(), openMobileCompanion(t18), saveLastActorId(t18.id);
}
function openMobileCompanion(t18) {
  currentSheet = factory(t18), currentSheet ? currentSheet.render(true, { focus: true }) : console.error("Mobile-Companion does not support this system. Please disable Mobile-Companion.");
}
const DOM_REMOVE = "dom-remove-or-hide", MAIN_WIDTH = "main-width", BACKGROUND_IMG = "background-img";
function getCommonSettings(t18, e2) {
  const n2 = [];
  return n2.push({ namespace: t18, key: DOM_REMOVE, options: { name: "Debug: Hide instead of remove DOM elements", hint: "Hides instead of removes non-mobile-companion DOM elements.", scope: "world", config: true, type: Boolean, default: false } }), n2.push({ namespace: t18, key: "main-width", options: { name: "App Width", hint: "Determines the width in percent of the app. If you are using quite a large device you might prefer the app not stretching the full display width.", scope: "client", range: { min: 0, max: 100, step: 1 }, config: true, type: Number, default: 100, onChange: (t19) => {
    e2.getWritableStore(MAIN_WIDTH)?.set(t19);
  } } }), n2.push({ namespace: t18, key: "background-img", options: { name: "Background Image", hint: "(Pro Feature) Set an URL to an image (animated gifs work, too) which will be displayed behind the app. Only use this if you set the app width smaller than 100.", scope: "client", config: true, type: String, onChange: (t19) => {
    e2.getWritableStore(BACKGROUND_IMG)?.set(t19);
  } } }), n2;
}
let hideInsteadOfRemove = false;
function hideAllElements() {
  hideInsteadOfRemove = game.settings.get(getFullModuleId$1(), DOM_REMOVE);
  [50, 500, 1e3].forEach((t18) => {
    setTimeout(hideOtherElements, t18);
  }), startObserver();
}
function startObserver() {
  setTimeout(() => {
    const t18 = new MutationObserver((t19) => {
      for (const e2 of t19) "childList" === e2.type && e2.addedNodes.forEach((t20) => {
        if (t20.nodeType === Node.ELEMENT_NODE) {
          const e3 = t20;
          let n2 = e3.classList.contains("window-app"), o2 = "mobile-companion" === e3.id, i2 = "client-settings" === e3.id, r2 = e3.classList.contains("mobile-companion");
          !n2 || o2 || i2 || r2 || hideOrRemoveElement(e3);
        }
      });
    });
    t18.observe(document.body, { childList: true, subtree: false });
  }, 1e3);
}
function disableSounds() {
  game.settings.set("core", "globalPlaylistVolume", 0), game.settings.set("core", "globalAmbientVolume", 0), game.settings.set("core", "globalInterfaceVolume", 0);
}
function hideOtherElements() {
  Array.from(document.body.children).forEach((t18) => {
    if (t18.id !== getBaseModuleId$1()) {
      hideOrRemoveElement(t18);
    }
  });
}
function hideOrRemoveElement(t18) {
  hideInsteadOfRemove ? t18.style.display = "none" : (t18.remove(), reapplyDummyElements());
}
function reapplyDummyElements() {
  if (!document.getElementById("navigation")) {
    const t18 = document.createElement("nav");
    t18.id = "navigation", t18.textContent = "This is an empty dummy navigation bar to prevent Foundry error", t18.style.display = "none", document.body.appendChild(t18);
  }
  if (!document.getElementById("loading")) {
    const t18 = document.createElement("div");
    t18.id = "loading", t18.textContent = "This is an empty dummy loading bar bar to prevent Foundry error", t18.style.display = "none", document.body.appendChild(t18);
  }
}
function noop$4() {
}
const identity = (t18) => t18;
function assign(t18, e2) {
  for (const n2 in e2) t18[n2] = e2[n2];
  return t18;
}
function is_promise(t18) {
  return !!t18 && ("object" == typeof t18 || "function" == typeof t18) && "function" == typeof t18.then;
}
function run(t18) {
  return t18();
}
function blank_object() {
  return /* @__PURE__ */ Object.create(null);
}
function run_all(t18) {
  t18.forEach(run);
}
function is_function(t18) {
  return "function" == typeof t18;
}
function safe_not_equal(t18, e2) {
  return t18 != t18 ? e2 == e2 : t18 !== e2 || t18 && "object" == typeof t18 || "function" == typeof t18;
}
let src_url_equal_anchor;
function src_url_equal(t18, e2) {
  return t18 === e2 || (src_url_equal_anchor || (src_url_equal_anchor = document.createElement("a")), src_url_equal_anchor.href = e2, t18 === src_url_equal_anchor.href);
}
function is_empty(t18) {
  return 0 === Object.keys(t18).length;
}
function subscribe(t18, ...e2) {
  if (null == t18) {
    for (const t19 of e2) t19(void 0);
    return noop$4;
  }
  const n2 = t18.subscribe(...e2);
  return n2.unsubscribe ? () => n2.unsubscribe() : n2;
}
function get_store_value(t18) {
  let e2;
  return subscribe(t18, (t19) => e2 = t19)(), e2;
}
function component_subscribe(t18, e2, n2) {
  t18.$$.on_destroy.push(subscribe(e2, n2));
}
function create_slot(t18, e2, n2, o2) {
  if (t18) {
    const i2 = get_slot_context(t18, e2, n2, o2);
    return t18[0](i2);
  }
}
function get_slot_context(t18, e2, n2, o2) {
  return t18[1] && o2 ? assign(n2.ctx.slice(), t18[1](o2(e2))) : n2.ctx;
}
function get_slot_changes(t18, e2, n2, o2) {
  if (t18[2] && o2) {
    const i2 = t18[2](o2(n2));
    if (void 0 === e2.dirty) return i2;
    if ("object" == typeof i2) {
      const t19 = [], n3 = Math.max(e2.dirty.length, i2.length);
      for (let o3 = 0; o3 < n3; o3 += 1) t19[o3] = e2.dirty[o3] | i2[o3];
      return t19;
    }
    return e2.dirty | i2;
  }
  return e2.dirty;
}
function update_slot_base(t18, e2, n2, o2, i2, r2) {
  if (i2) {
    const a2 = get_slot_context(e2, n2, o2, r2);
    t18.p(a2, i2);
  }
}
function get_all_dirty_from_scope(t18) {
  if (t18.ctx.length > 32) {
    const e2 = [], n2 = t18.ctx.length / 32;
    for (let t19 = 0; t19 < n2; t19++) e2[t19] = -1;
    return e2;
  }
  return -1;
}
function exclude_internal_props(t18) {
  const e2 = {};
  for (const n2 in t18) "$" !== n2[0] && (e2[n2] = t18[n2]);
  return e2;
}
function compute_rest_props(t18, e2) {
  const n2 = {};
  e2 = new Set(e2);
  for (const o2 in t18) e2.has(o2) || "$" === o2[0] || (n2[o2] = t18[o2]);
  return n2;
}
function null_to_empty(t18) {
  return null == t18 ? "" : t18;
}
function set_store_value(t18, e2, n2) {
  return t18.set(n2), e2;
}
function action_destroyer(t18) {
  return t18 && is_function(t18.destroy) ? t18.destroy : noop$4;
}
const is_client = "undefined" != typeof window;
let now$1 = is_client ? () => window.performance.now() : () => Date.now(), raf = is_client ? (t18) => requestAnimationFrame(t18) : noop$4;
const tasks = /* @__PURE__ */ new Set();
function run_tasks(t18) {
  tasks.forEach((e2) => {
    e2.c(t18) || (tasks.delete(e2), e2.f());
  }), 0 !== tasks.size && raf(run_tasks);
}
function loop(t18) {
  let e2;
  return 0 === tasks.size && raf(run_tasks), { promise: new Promise((n2) => {
    tasks.add(e2 = { c: t18, f: n2 });
  }), abort() {
    tasks.delete(e2);
  } };
}
const globals = "undefined" != typeof window ? window : "undefined" != typeof globalThis ? globalThis : global;
function append(t18, e2) {
  t18.appendChild(e2);
}
function get_root_for_style(t18) {
  if (!t18) return document;
  const e2 = t18.getRootNode ? t18.getRootNode() : t18.ownerDocument;
  return e2 && e2.host ? e2 : t18.ownerDocument;
}
function append_empty_stylesheet(t18) {
  const e2 = element("style");
  return e2.textContent = "/* empty */", append_stylesheet(get_root_for_style(t18), e2), e2.sheet;
}
function append_stylesheet(t18, e2) {
  return append(t18.head || t18, e2), e2.sheet;
}
function insert(t18, e2, n2) {
  t18.insertBefore(e2, n2 || null);
}
function detach(t18) {
  t18.parentNode && t18.parentNode.removeChild(t18);
}
function destroy_each(t18, e2) {
  for (let n2 = 0; n2 < t18.length; n2 += 1) t18[n2] && t18[n2].d(e2);
}
function element(t18) {
  return document.createElement(t18);
}
function svg_element(t18) {
  return document.createElementNS("http://www.w3.org/2000/svg", t18);
}
function text(t18) {
  return document.createTextNode(t18);
}
function space() {
  return text(" ");
}
function empty() {
  return text("");
}
function listen(t18, e2, n2, o2) {
  return t18.addEventListener(e2, n2, o2), () => t18.removeEventListener(e2, n2, o2);
}
function prevent_default(t18) {
  return function(e2) {
    return e2.preventDefault(), t18.call(this, e2);
  };
}
function stop_propagation(t18) {
  return function(e2) {
    return e2.stopPropagation(), t18.call(this, e2);
  };
}
function attr(t18, e2, n2) {
  null == n2 ? t18.removeAttribute(e2) : t18.getAttribute(e2) !== n2 && t18.setAttribute(e2, n2);
}
function set_svg_attributes(t18, e2) {
  for (const n2 in e2) attr(t18, n2, e2[n2]);
}
function to_number(t18) {
  return "" === t18 ? null : +t18;
}
function children(t18) {
  return Array.from(t18.childNodes);
}
function set_data(t18, e2) {
  e2 = "" + e2, t18.data !== e2 && (t18.data = e2);
}
function set_input_value(t18, e2) {
  t18.value = null == e2 ? "" : e2;
}
function set_style(t18, e2, n2, o2) {
  null == n2 ? t18.style.removeProperty(e2) : t18.style.setProperty(e2, n2, "");
}
function select_option(t18, e2, n2) {
  for (let n3 = 0; n3 < t18.options.length; n3 += 1) {
    const o2 = t18.options[n3];
    if (o2.__value === e2) return void (o2.selected = true);
  }
  n2 && void 0 === e2 || (t18.selectedIndex = -1);
}
function select_value(t18) {
  const e2 = t18.querySelector(":checked");
  return e2 && e2.__value;
}
function toggle_class(t18, e2, n2) {
  t18.classList.toggle(e2, !!n2);
}
function custom_event(t18, e2, { bubbles: n2 = false, cancelable: o2 = false } = {}) {
  return new CustomEvent(t18, { detail: e2, bubbles: n2, cancelable: o2 });
}
class HtmlTag {
  is_svg = false;
  e = void 0;
  n = void 0;
  t = void 0;
  a = void 0;
  constructor(t18 = false) {
    this.is_svg = t18, this.e = this.n = null;
  }
  c(t18) {
    this.h(t18);
  }
  m(t18, e2, n2 = null) {
    this.e || (this.is_svg ? this.e = svg_element(e2.nodeName) : this.e = element(11 === e2.nodeType ? "TEMPLATE" : e2.nodeName), this.t = "TEMPLATE" !== e2.tagName ? e2 : e2.content, this.c(t18)), this.i(n2);
  }
  h(t18) {
    this.e.innerHTML = t18, this.n = Array.from("TEMPLATE" === this.e.nodeName ? this.e.content.childNodes : this.e.childNodes);
  }
  i(t18) {
    for (let e2 = 0; e2 < this.n.length; e2 += 1) insert(this.t, this.n[e2], t18);
  }
  p(t18) {
    this.d(), this.h(t18), this.i(this.a);
  }
  d() {
    this.n.forEach(detach);
  }
}
function construct_svelte_component(t18, e2) {
  return new t18(e2);
}
const managed_styles = /* @__PURE__ */ new Map();
let active = 0, current_component;
function hash(t18) {
  let e2 = 5381, n2 = t18.length;
  for (; n2--; ) e2 = (e2 << 5) - e2 ^ t18.charCodeAt(n2);
  return e2 >>> 0;
}
function create_style_information(t18, e2) {
  const n2 = { stylesheet: append_empty_stylesheet(e2), rules: {} };
  return managed_styles.set(t18, n2), n2;
}
function create_rule(t18, e2, n2, o2, i2, r2, a2, s2 = 0) {
  const c2 = 16.666 / o2;
  let l2 = "{\n";
  for (let t19 = 0; t19 <= 1; t19 += c2) {
    const o3 = e2 + (n2 - e2) * r2(t19);
    l2 += 100 * t19 + `%{${a2(o3, 1 - o3)}}
`;
  }
  const u2 = l2 + `100% {${a2(n2, 1 - n2)}}
}`, p2 = `__svelte_${hash(u2)}_${s2}`, d2 = get_root_for_style(t18), { stylesheet: m2, rules: f2 } = managed_styles.get(d2) || create_style_information(d2, t18);
  f2[p2] || (f2[p2] = true, m2.insertRule(`@keyframes ${p2} ${u2}`, m2.cssRules.length));
  const h2 = t18.style.animation || "";
  return t18.style.animation = `${h2 ? `${h2}, ` : ""}${p2} ${o2}ms linear ${i2}ms 1 both`, active += 1, p2;
}
function delete_rule(t18, e2) {
  const n2 = (t18.style.animation || "").split(", "), o2 = n2.filter(e2 ? (t19) => t19.indexOf(e2) < 0 : (t19) => -1 === t19.indexOf("__svelte")), i2 = n2.length - o2.length;
  i2 && (t18.style.animation = o2.join(", "), active -= i2, active || clear_rules());
}
function clear_rules() {
  raf(() => {
    active || (managed_styles.forEach((t18) => {
      const { ownerNode: e2 } = t18.stylesheet;
      e2 && detach(e2);
    }), managed_styles.clear());
  });
}
function set_current_component(t18) {
  current_component = t18;
}
function get_current_component() {
  if (!current_component) throw new Error("Function called outside component initialization");
  return current_component;
}
function onMount(t18) {
  get_current_component().$$.on_mount.push(t18);
}
function afterUpdate(t18) {
  get_current_component().$$.after_update.push(t18);
}
function onDestroy(t18) {
  get_current_component().$$.on_destroy.push(t18);
}
function createEventDispatcher() {
  const t18 = get_current_component();
  return (e2, n2, { cancelable: o2 = false } = {}) => {
    const i2 = t18.$$.callbacks[e2];
    if (i2) {
      const r2 = custom_event(e2, n2, { cancelable: o2 });
      return i2.slice().forEach((e3) => {
        e3.call(t18, r2);
      }), !r2.defaultPrevented;
    }
    return true;
  };
}
function setContext(t18, e2) {
  return get_current_component().$$.context.set(t18, e2), e2;
}
function getContext(t18) {
  return get_current_component().$$.context.get(t18);
}
const dirty_components = [], binding_callbacks = [];
let render_callbacks = [];
const flush_callbacks = [], resolved_promise = Promise.resolve();
let update_scheduled = false;
function schedule_update() {
  update_scheduled || (update_scheduled = true, resolved_promise.then(flush));
}
function tick() {
  return schedule_update(), resolved_promise;
}
function add_render_callback(t18) {
  render_callbacks.push(t18);
}
function add_flush_callback(t18) {
  flush_callbacks.push(t18);
}
const seen_callbacks = /* @__PURE__ */ new Set();
let flushidx = 0, promise;
function flush() {
  if (0 !== flushidx) return;
  const t18 = current_component;
  do {
    try {
      for (; flushidx < dirty_components.length; ) {
        const t19 = dirty_components[flushidx];
        flushidx++, set_current_component(t19), update(t19.$$);
      }
    } catch (t19) {
      throw dirty_components.length = 0, flushidx = 0, t19;
    }
    for (set_current_component(null), dirty_components.length = 0, flushidx = 0; binding_callbacks.length; ) binding_callbacks.pop()();
    for (let t19 = 0; t19 < render_callbacks.length; t19 += 1) {
      const e2 = render_callbacks[t19];
      seen_callbacks.has(e2) || (seen_callbacks.add(e2), e2());
    }
    render_callbacks.length = 0;
  } while (dirty_components.length);
  for (; flush_callbacks.length; ) flush_callbacks.pop()();
  update_scheduled = false, seen_callbacks.clear(), set_current_component(t18);
}
function update(t18) {
  if (null !== t18.fragment) {
    t18.update(), run_all(t18.before_update);
    const e2 = t18.dirty;
    t18.dirty = [-1], t18.fragment && t18.fragment.p(t18.ctx, e2), t18.after_update.forEach(add_render_callback);
  }
}
function flush_render_callbacks(t18) {
  const e2 = [], n2 = [];
  render_callbacks.forEach((o2) => -1 === t18.indexOf(o2) ? e2.push(o2) : n2.push(o2)), n2.forEach((t19) => t19()), render_callbacks = e2;
}
function wait() {
  return promise || (promise = Promise.resolve(), promise.then(() => {
    promise = null;
  })), promise;
}
function dispatch(t18, e2, n2) {
  t18.dispatchEvent(custom_event(`${e2 ? "intro" : "outro"}${n2}`));
}
const outroing = /* @__PURE__ */ new Set();
let outros;
function group_outros() {
  outros = { r: 0, c: [], p: outros };
}
function check_outros() {
  outros.r || run_all(outros.c), outros = outros.p;
}
function transition_in(t18, e2) {
  t18 && t18.i && (outroing.delete(t18), t18.i(e2));
}
function transition_out(t18, e2, n2, o2) {
  if (t18 && t18.o) {
    if (outroing.has(t18)) return;
    outroing.add(t18), outros.c.push(() => {
      outroing.delete(t18), o2 && (n2 && t18.d(1), o2());
    }), t18.o(e2);
  } else o2 && o2();
}
const null_transition = { duration: 0 };
function create_in_transition(t18, e2, n2) {
  const o2 = { direction: "in" };
  let i2, r2, a2 = e2(t18, n2, o2), s2 = false, c2 = 0;
  function l2() {
    i2 && delete_rule(t18, i2);
  }
  function u2() {
    const { delay: e3 = 0, duration: n3 = 300, easing: o3 = identity, tick: u3 = noop$4, css: p3 } = a2 || null_transition;
    p3 && (i2 = create_rule(t18, 0, 1, n3, e3, o3, p3, c2++)), u3(0, 1);
    const d2 = now$1() + e3, m2 = d2 + n3;
    r2 && r2.abort(), s2 = true, add_render_callback(() => dispatch(t18, true, "start")), r2 = loop((e4) => {
      if (s2) {
        if (e4 >= m2) return u3(1, 0), dispatch(t18, true, "end"), l2(), s2 = false;
        if (e4 >= d2) {
          const t19 = o3((e4 - d2) / n3);
          u3(t19, 1 - t19);
        }
      }
      return s2;
    });
  }
  let p2 = false;
  return { start() {
    p2 || (p2 = true, delete_rule(t18), is_function(a2) ? (a2 = a2(o2), wait().then(u2)) : u2());
  }, invalidate() {
    p2 = false;
  }, end() {
    s2 && (l2(), s2 = false);
  } };
}
function create_out_transition(t18, e2, n2) {
  const o2 = { direction: "out" };
  let i2, r2 = e2(t18, n2, o2), a2 = true;
  const s2 = outros;
  let c2;
  function l2() {
    const { delay: e3 = 0, duration: n3 = 300, easing: o3 = identity, tick: l3 = noop$4, css: u2 } = r2 || null_transition;
    u2 && (i2 = create_rule(t18, 1, 0, n3, e3, o3, u2));
    const p2 = now$1() + e3, d2 = p2 + n3;
    add_render_callback(() => dispatch(t18, false, "start")), "inert" in t18 && (c2 = t18.inert, t18.inert = true), loop((e4) => {
      if (a2) {
        if (e4 >= d2) return l3(0, 1), dispatch(t18, false, "end"), --s2.r || run_all(s2.c), false;
        if (e4 >= p2) {
          const t19 = o3((e4 - p2) / n3);
          l3(1 - t19, t19);
        }
      }
      return a2;
    });
  }
  return s2.r += 1, is_function(r2) ? wait().then(() => {
    r2 = r2(o2), l2();
  }) : l2(), { end(e3) {
    e3 && "inert" in t18 && (t18.inert = c2), e3 && r2.tick && r2.tick(1, 0), a2 && (i2 && delete_rule(t18, i2), a2 = false);
  } };
}
function create_bidirectional_transition(t18, e2, n2, o2) {
  let i2, r2 = e2(t18, n2, { direction: "both" }), a2 = o2 ? 0 : 1, s2 = null, c2 = null, l2 = null;
  function u2() {
    l2 && delete_rule(t18, l2);
  }
  function p2(t19, e3) {
    const n3 = t19.b - a2;
    return e3 *= Math.abs(n3), { a: a2, b: t19.b, d: n3, duration: e3, start: t19.start, end: t19.start + e3, group: t19.group };
  }
  function d2(e3) {
    const { delay: n3 = 0, duration: o3 = 300, easing: d3 = identity, tick: m2 = noop$4, css: f2 } = r2 || null_transition, h2 = { start: now$1() + n3, b: e3 };
    e3 || (h2.group = outros, outros.r += 1), "inert" in t18 && (e3 ? void 0 !== i2 && (t18.inert = i2) : (i2 = t18.inert, t18.inert = true)), s2 || c2 ? c2 = h2 : (f2 && (u2(), l2 = create_rule(t18, a2, e3, o3, n3, d3, f2)), e3 && m2(0, 1), s2 = p2(h2, o3), add_render_callback(() => dispatch(t18, e3, "start")), loop((e4) => {
      if (c2 && e4 > c2.start && (s2 = p2(c2, o3), c2 = null, dispatch(t18, s2.b, "start"), f2 && (u2(), l2 = create_rule(t18, a2, s2.b, s2.duration, 0, d3, r2.css))), s2) {
        if (e4 >= s2.end) m2(a2 = s2.b, 1 - a2), dispatch(t18, s2.b, "end"), c2 || (s2.b ? u2() : --s2.group.r || run_all(s2.group.c)), s2 = null;
        else if (e4 >= s2.start) {
          const t19 = e4 - s2.start;
          a2 = s2.a + s2.d * d3(t19 / s2.duration), m2(a2, 1 - a2);
        }
      }
      return !(!s2 && !c2);
    }));
  }
  return { run(t19) {
    is_function(r2) ? wait().then(() => {
      r2 = r2({ direction: t19 ? "in" : "out" }), d2(t19);
    }) : d2(t19);
  }, end() {
    u2(), s2 = c2 = null;
  } };
}
function handle_promise(t18, e2) {
  const n2 = e2.token = {};
  function o2(t19, o3, i2, r2) {
    if (e2.token !== n2) return;
    e2.resolved = r2;
    let a2 = e2.ctx;
    void 0 !== i2 && (a2 = a2.slice(), a2[i2] = r2);
    const s2 = t19 && (e2.current = t19)(a2);
    let c2 = false;
    e2.block && (e2.blocks ? e2.blocks.forEach((t20, n3) => {
      n3 !== o3 && t20 && (group_outros(), transition_out(t20, 1, 1, () => {
        e2.blocks[n3] === t20 && (e2.blocks[n3] = null);
      }), check_outros());
    }) : e2.block.d(1), s2.c(), transition_in(s2, 1), s2.m(e2.mount(), e2.anchor), c2 = true), e2.block = s2, e2.blocks && (e2.blocks[o3] = s2), c2 && flush();
  }
  if (is_promise(t18)) {
    const n3 = get_current_component();
    if (t18.then((t19) => {
      set_current_component(n3), o2(e2.then, 1, e2.value, t19), set_current_component(null);
    }, (t19) => {
      if (set_current_component(n3), o2(e2.catch, 2, e2.error, t19), set_current_component(null), !e2.hasCatch) throw t19;
    }), e2.current !== e2.pending) return o2(e2.pending, 0), true;
  } else {
    if (e2.current !== e2.then) return o2(e2.then, 1, e2.value, t18), true;
    e2.resolved = t18;
  }
}
function update_await_block_branch(t18, e2, n2) {
  const o2 = e2.slice(), { resolved: i2 } = t18;
  t18.current === t18.then && (o2[t18.value] = i2), t18.current === t18.catch && (o2[t18.error] = i2), t18.block.p(o2, n2);
}
function ensure_array_like(t18) {
  return void 0 !== t18?.length ? t18 : Array.from(t18);
}
function destroy_block(t18, e2) {
  t18.d(1), e2.delete(t18.key);
}
function outro_and_destroy_block(t18, e2) {
  transition_out(t18, 1, 1, () => {
    e2.delete(t18.key);
  });
}
function update_keyed_each(t18, e2, n2, o2, i2, r2, a2, s2, c2, l2, u2, p2) {
  let d2 = t18.length, m2 = r2.length, f2 = d2;
  const h2 = {};
  for (; f2--; ) h2[t18[f2].key] = f2;
  const g2 = [], _ = /* @__PURE__ */ new Map(), $2 = /* @__PURE__ */ new Map(), b2 = [];
  for (f2 = m2; f2--; ) {
    const t19 = p2(i2, r2, f2), o3 = n2(t19);
    let s3 = a2.get(o3);
    s3 ? b2.push(() => s3.p(t19, e2)) : (s3 = l2(o3, t19), s3.c()), _.set(o3, g2[f2] = s3), o3 in h2 && $2.set(o3, Math.abs(f2 - h2[o3]));
  }
  const y2 = /* @__PURE__ */ new Set(), v2 = /* @__PURE__ */ new Set();
  function w2(t19) {
    transition_in(t19, 1), t19.m(s2, u2), a2.set(t19.key, t19), u2 = t19.first, m2--;
  }
  for (; d2 && m2; ) {
    const e3 = g2[m2 - 1], n3 = t18[d2 - 1], o3 = e3.key, i3 = n3.key;
    e3 === n3 ? (u2 = e3.first, d2--, m2--) : _.has(i3) ? !a2.has(o3) || y2.has(o3) ? w2(e3) : v2.has(i3) ? d2-- : $2.get(o3) > $2.get(i3) ? (v2.add(o3), w2(e3)) : (y2.add(i3), d2--) : (c2(n3, a2), d2--);
  }
  for (; d2--; ) {
    const e3 = t18[d2];
    _.has(e3.key) || c2(e3, a2);
  }
  for (; m2; ) w2(g2[m2 - 1]);
  return run_all(b2), g2;
}
function get_spread_update(t18, e2) {
  const n2 = {}, o2 = {}, i2 = { $$scope: 1 };
  let r2 = t18.length;
  for (; r2--; ) {
    const a2 = t18[r2], s2 = e2[r2];
    if (s2) {
      for (const t19 in a2) t19 in s2 || (o2[t19] = 1);
      for (const t19 in s2) i2[t19] || (n2[t19] = s2[t19], i2[t19] = 1);
      t18[r2] = s2;
    } else for (const t19 in a2) i2[t19] = 1;
  }
  for (const t19 in o2) t19 in n2 || (n2[t19] = void 0);
  return n2;
}
function get_spread_object(t18) {
  return "object" == typeof t18 && null !== t18 ? t18 : {};
}
function bind(t18, e2, n2) {
  const o2 = t18.$$.props[e2];
  void 0 !== o2 && (t18.$$.bound[o2] = n2, n2(t18.$$.ctx[o2]));
}
function create_component(t18) {
  t18 && t18.c();
}
function mount_component(t18, e2, n2) {
  const { fragment: o2, after_update: i2 } = t18.$$;
  o2 && o2.m(e2, n2), add_render_callback(() => {
    const e3 = t18.$$.on_mount.map(run).filter(is_function);
    t18.$$.on_destroy ? t18.$$.on_destroy.push(...e3) : run_all(e3), t18.$$.on_mount = [];
  }), i2.forEach(add_render_callback);
}
function destroy_component(t18, e2) {
  const n2 = t18.$$;
  null !== n2.fragment && (flush_render_callbacks(n2.after_update), run_all(n2.on_destroy), n2.fragment && n2.fragment.d(e2), n2.on_destroy = n2.fragment = null, n2.ctx = []);
}
function make_dirty(t18, e2) {
  -1 === t18.$$.dirty[0] && (dirty_components.push(t18), schedule_update(), t18.$$.dirty.fill(0)), t18.$$.dirty[e2 / 31 | 0] |= 1 << e2 % 31;
}
function init(t18, e2, n2, o2, i2, r2, a2 = null, s2 = [-1]) {
  const c2 = current_component;
  set_current_component(t18);
  const l2 = t18.$$ = { fragment: null, ctx: [], props: r2, update: noop$4, not_equal: i2, bound: blank_object(), on_mount: [], on_destroy: [], on_disconnect: [], before_update: [], after_update: [], context: new Map(e2.context || (c2 ? c2.$$.context : [])), callbacks: blank_object(), dirty: s2, skip_bound: false, root: e2.target || c2.$$.root };
  a2 && a2(l2.root);
  let u2 = false;
  if (l2.ctx = n2 ? n2(t18, e2.props || {}, (e3, n3, ...o3) => {
    const r3 = o3.length ? o3[0] : n3;
    return l2.ctx && i2(l2.ctx[e3], l2.ctx[e3] = r3) && (!l2.skip_bound && l2.bound[e3] && l2.bound[e3](r3), u2 && make_dirty(t18, e3)), n3;
  }) : [], l2.update(), u2 = true, run_all(l2.before_update), l2.fragment = !!o2 && o2(l2.ctx), e2.target) {
    if (e2.hydrate) {
      const t19 = children(e2.target);
      l2.fragment && l2.fragment.l(t19), t19.forEach(detach);
    } else l2.fragment && l2.fragment.c();
    e2.intro && transition_in(t18.$$.fragment), mount_component(t18, e2.target, e2.anchor), flush();
  }
  set_current_component(c2);
}
class SvelteComponent {
  $$ = void 0;
  $$set = void 0;
  $destroy() {
    destroy_component(this, 1), this.$destroy = noop$4;
  }
  $on(t18, e2) {
    if (!is_function(e2)) return noop$4;
    const n2 = this.$$.callbacks[t18] || (this.$$.callbacks[t18] = []);
    return n2.push(e2), () => {
      const t19 = n2.indexOf(e2);
      -1 !== t19 && n2.splice(t19, 1);
    };
  }
  $set(t18) {
    this.$$set && !is_empty(t18) && (this.$$.skip_bound = true, this.$$set(t18), this.$$.skip_bound = false);
  }
}
const PUBLIC_VERSION = "4", subscriber_queue = [];
function readable(t18, e2) {
  return { subscribe: writable(t18, e2).subscribe };
}
function writable(t18, e2 = noop$4) {
  let n2;
  const o2 = /* @__PURE__ */ new Set();
  function i2(e3) {
    if (safe_not_equal(t18, e3) && (t18 = e3, n2)) {
      const e4 = !subscriber_queue.length;
      for (const e5 of o2) e5[1](), subscriber_queue.push(e5, t18);
      if (e4) {
        for (let t19 = 0; t19 < subscriber_queue.length; t19 += 2) subscriber_queue[t19][0](subscriber_queue[t19 + 1]);
        subscriber_queue.length = 0;
      }
    }
  }
  function r2(e3) {
    i2(e3(t18));
  }
  return { set: i2, update: r2, subscribe: function(a2, s2 = noop$4) {
    const c2 = [a2, s2];
    return o2.add(c2), 1 === o2.size && (n2 = e2(i2, r2) || noop$4), a2(t18), () => {
      o2.delete(c2), 0 === o2.size && n2 && (n2(), n2 = null);
    };
  } };
}
function derived(t18, e2, n2) {
  const o2 = !Array.isArray(t18), i2 = o2 ? [t18] : t18;
  if (!i2.every(Boolean)) throw new Error("derived() expects stores as input, got a falsy value");
  const r2 = e2.length < 2;
  return readable(n2, (t19, n3) => {
    let a2 = false;
    const s2 = [];
    let c2 = 0, l2 = noop$4;
    const u2 = () => {
      if (c2) return;
      l2();
      const i3 = e2(o2 ? s2[0] : s2, t19, n3);
      r2 ? t19(i3) : l2 = is_function(i3) ? i3 : noop$4;
    }, p2 = i2.map((t20, e3) => subscribe(t20, (t21) => {
      s2[e3] = t21, c2 &= ~(1 << e3), a2 && u2();
    }, () => {
      c2 |= 1 << e3;
    }));
    return a2 = true, u2(), function() {
      run_all(p2), l2(), a2 = false;
    };
  });
}
const largeScreen = writable(false);
window.MIN_WINDOW_WIDTH = 200, window.MIN_WINDOW_HEIGHT = 50;
const LARGE_SCREEN_WIDTH = 600;
function onReady(t18) {
  isMobileCompanion() && (hideAllElements(), disableSounds(), window.addEventListener("resize", updateScreenWidth), t18());
}
function getIsLargeScreen() {
  return window.innerWidth >= LARGE_SCREEN_WIDTH;
}
const updateScreenWidth = () => {
  largeScreen.set(getIsLargeScreen());
};
function renderSettingsConfig(t18) {
  if (isMobileCompanion() && (t18.css({ zIndex: 2e3 }), window.innerWidth < 600)) {
    const e2 = t18.find(".window-content .flexrow");
    e2.removeClass("flexrow"), e2.addClass("flexcol");
  }
}
function isMinimalWritableStore$1(t18) {
  if (null == t18) return false;
  switch (typeof t18) {
    case "function":
    case "object":
      return "function" == typeof t18.subscribe && "function" == typeof t18.set;
  }
  return false;
}
function isWritableStore$1(t18) {
  if (null == t18) return false;
  switch (typeof t18) {
    case "function":
    case "object":
      return "function" == typeof t18.subscribe && "function" == typeof t18.set && "function" == typeof t18.update;
  }
  return false;
}
function subscribeIgnoreFirst$1(t18, e2) {
  let n2 = false;
  return t18.subscribe((t19) => {
    n2 ? e2(t19) : n2 = true;
  });
}
function deepMerge$1(t18, ...e2) {
  if ("[object Object]" !== Object.prototype.toString.call(t18)) throw new TypeError("deepMerge error: 'target' is not an object.");
  if (0 === e2.length) throw new TypeError("deepMerge error: 'sourceObj' is not an object.");
  for (let t19 = 0; t19 < e2.length; t19++) if ("[object Object]" !== Object.prototype.toString.call(e2[t19])) throw new TypeError(`deepMerge error: 'sourceObj[${t19}]' is not an object.`);
  if (1 === e2.length) {
    const n2 = [];
    for (const o2 of e2) n2.push({ target: t18, source: o2 });
    for (; n2.length > 0; ) {
      const { target: t19, source: e3 } = n2.pop();
      for (const o2 in e3) if (Object.hasOwn(e3, o2)) {
        const i2 = e3[o2], r2 = t19[o2];
        Object.hasOwn(t19, o2) && r2?.constructor === Object && i2?.constructor === Object ? n2.push({ target: r2, source: i2 }) : t19[o2] = i2;
      }
    }
  } else {
    const n2 = [{ target: t18, sources: e2 }];
    for (; n2.length > 0; ) {
      const { target: t19, sources: e3 } = n2.pop();
      for (const o2 of e3) for (const e4 in o2) if (Object.hasOwn(o2, e4)) {
        const i2 = o2[e4], r2 = t19[e4];
        Object.hasOwn(t19, e4) && r2?.constructor === Object && i2?.constructor === Object ? (t19[e4] = Object.assign({}, r2), n2.push({ target: t19[e4], sources: [i2] })) : t19[e4] = i2;
      }
    }
  }
  return t18;
}
function hasGetter$1(t18, e2) {
  if ("object" != typeof t18 || null == t18) return false;
  const n2 = Object.getOwnPropertyDescriptor(t18, e2);
  if (void 0 !== n2 && void 0 !== n2.get) return true;
  for (let n3 = Object.getPrototypeOf(t18); n3; n3 = Object.getPrototypeOf(n3)) {
    const t19 = Object.getOwnPropertyDescriptor(n3, e2);
    if (void 0 !== t19 && void 0 !== t19.get) return true;
  }
  return false;
}
function isIterable$1(t18) {
  return null != t18 && "object" == typeof t18 && Symbol.iterator in t18;
}
function isObject$1(t18) {
  return null !== t18 && "object" == typeof t18 && !Array.isArray(t18);
}
function isPlainObject$1(t18) {
  if ("[object Object]" !== Object.prototype.toString.call(t18)) return false;
  const e2 = Object.getPrototypeOf(t18);
  return null === e2 || e2 === Object.prototype;
}
function safeAccess$1(t18, e2, n2) {
  if ("object" != typeof t18 || null === t18) return n2;
  if ("string" != typeof e2) return n2;
  const o2 = e2.split(".");
  let i2 = t18;
  for (let t19 = 0; t19 < o2.length; t19++) {
    if (void 0 === i2[o2[t19]] || null === i2[o2[t19]]) return n2;
    i2 = i2[o2[t19]];
  }
  return i2;
}
function safeSet$1(t18, e2, n2, { operation: o2 = "set", createMissing: i2 = false } = {}) {
  if ("object" != typeof t18 || null === t18) throw new TypeError("safeSet error: 'data' is not an object.");
  if ("string" != typeof e2) throw new TypeError("safeSet error: 'accessor' is not a string.");
  if ("string" != typeof o2) throw new TypeError("safeSet error: 'options.operation' is not a string.");
  if ("add" !== o2 && "div" !== o2 && "mult" !== o2 && "set" !== o2 && "set-undefined" !== o2 && "sub" !== o2) throw new Error("safeSet error: Unknown 'options.operation'.");
  if ("boolean" != typeof i2) throw new TypeError("safeSet error: 'options.createMissing' is not a boolean.");
  const r2 = e2.split(".");
  let a2 = false;
  if (1 === r2.length && !i2 && !(r2[0] in t18)) return false;
  for (let e3 = 0; e3 < r2.length; e3++) {
    if (Array.isArray(t18)) {
      const t19 = +r2[e3];
      if (!Number.isInteger(t19) || t19 < 0) return false;
    }
    if (e3 === r2.length - 1) switch (o2) {
      case "add":
        t18[r2[e3]] += n2, a2 = true;
        break;
      case "div":
        t18[r2[e3]] /= n2, a2 = true;
        break;
      case "mult":
        t18[r2[e3]] *= n2, a2 = true;
        break;
      case "set":
        t18[r2[e3]] = n2, a2 = true;
        break;
      case "set-undefined":
        void 0 === t18[r2[e3]] && (t18[r2[e3]] = n2), a2 = true;
        break;
      case "sub":
        t18[r2[e3]] -= n2, a2 = true;
    }
    else {
      if (i2 && void 0 === t18[r2[e3]] && (t18[r2[e3]] = {}), null === t18[r2[e3]] || "object" != typeof t18[r2[e3]]) return false;
      t18 = t18[r2[e3]];
    }
  }
  return a2;
}
let CrossWindow$1 = class {
  constructor() {
  }
  static #t = ["HTMLAnchorElement", "HTMLButtonElement", "HTMLDetailsElement", "HTMLEmbedElement", "HTMLIFrameElement", "HTMLInputElement", "HTMLObjectElement", "HTMLSelectElement", "HTMLTextAreaElement"];
  static #e = /* @__PURE__ */ new Set([Node.ELEMENT_NODE, Node.TEXT_NODE, Node.COMMENT_NODE, Node.DOCUMENT_FRAGMENT_NODE]);
  static #n = /* @__PURE__ */ new Set(["MouseEvent", "PointerEvent"]);
  static #o = /* @__PURE__ */ new Set(["UIEvent", "FocusEvent", "MouseEvent", "WheelEvent", "KeyboardEvent", "PointerEvent", "TouchEvent", "InputEvent", "CompositionEvent", "DragEvent"]);
  static #i = /* @__PURE__ */ new Set(["KeyboardEvent", "MouseEvent", "PointerEvent"]);
  static #r = { throws: false };
  static getActiveElement(t18, { throws: e2 = true } = {}) {
    if (this.#e.has(t18?.nodeType)) return t18?.ownerDocument?.activeElement ?? null;
    if (this.isUIEvent(t18) && isObject$1(t18?.view)) return t18?.view?.document?.activeElement ?? null;
    if (isObject$1(t18?.defaultView)) return t18?.activeElement ?? null;
    if (isObject$1(t18?.document) && isObject$1(t18?.location)) return t18?.document?.activeElement ?? null;
    if (e2) throw new TypeError("'target' must be a DOM Node / Element, Document, UIEvent, or Window.");
  }
  static getDocument(t18, { throws: e2 = true } = {}) {
    if (this.#e.has(t18?.nodeType)) return t18?.ownerDocument;
    if (this.isUIEvent(t18) && isObject$1(t18?.view)) return t18?.view?.document;
    if (isObject$1(t18?.defaultView)) return t18;
    if (isObject$1(t18?.document) && isObject$1(t18?.location)) return t18?.document;
    if (e2) throw new TypeError("'target' must be a DOM Node / Element, Document, UIEvent, or Window.");
  }
  static getWindow(t18, { throws: e2 = true } = {}) {
    if (this.#e.has(t18?.nodeType)) return t18.ownerDocument?.defaultView ?? globalThis;
    if (this.isUIEvent(t18) && isObject$1(t18?.view)) return t18.view ?? globalThis;
    if (isObject$1(t18?.defaultView)) return t18.defaultView ?? globalThis;
    if (isObject$1(t18?.document) && isObject$1(t18?.location)) return t18;
    if (e2) throw new TypeError("'target' must be a DOM Node / Element, Document, UIEvent, or Window.");
  }
  static isDocument(t18) {
    return isObject$1(t18) && "[object Document]" === Object.prototype.toString.call(t18);
  }
  static isMap(t18) {
    return isObject$1(t18) && "[object Map]" === Object.prototype.toString.call(t18);
  }
  static isPromise(t18) {
    return isObject$1(t18) && "[object Promise]" === Object.prototype.toString.call(t18);
  }
  static isRegExp(t18) {
    return isObject$1(t18) && "[object RegExp]" === Object.prototype.toString.call(t18);
  }
  static isSet(t18) {
    return isObject$1(t18) && "[object Set]" === Object.prototype.toString.call(t18);
  }
  static isURL(t18) {
    return isObject$1(t18) && "[object URL]" === Object.prototype.toString.call(t18);
  }
  static isWindow(t18) {
    return isObject$1(t18) && "[object Window]" === Object.prototype.toString.call(t18);
  }
  static isFocusableHTMLElement(t18) {
    for (let e2 = this.#t.length; --e2 >= 0; ) if (this.#a(t18, Node.ELEMENT_NODE, this.#t[e2])) return true;
    return false;
  }
  static isDocumentFragment(t18) {
    return this.#a(t18, Node.DOCUMENT_FRAGMENT_NODE, "DocumentFragment");
  }
  static isElement(t18) {
    return this.#a(t18, Node.ELEMENT_NODE, "Element");
  }
  static isHTMLAnchorElement(t18) {
    return this.#a(t18, Node.ELEMENT_NODE, "HTMLAnchorElement");
  }
  static isHTMLElement(t18) {
    return this.#a(t18, Node.ELEMENT_NODE, "HTMLElement");
  }
  static isNode(t18) {
    if ("number" != typeof t18?.nodeType) return false;
    if (t18 instanceof globalThis.Node) return true;
    const e2 = this.getWindow(t18, this.#r), n2 = e2?.Node;
    return n2 && t18 instanceof n2;
  }
  static isShadowRoot(t18) {
    return this.#a(t18, Node.DOCUMENT_FRAGMENT_NODE, "ShadowRoot");
  }
  static isSVGElement(t18) {
    return this.#a(t18, Node.ELEMENT_NODE, "SVGElement");
  }
  static isEvent(t18, e2) {
    return "string" == typeof t18?.type && "boolean" == typeof t18?.defaultPrevented && "function" == typeof t18?.stopPropagation && (void 0 === e2 || this.isCtorName(t18, e2));
  }
  static isPointerEvent(t18) {
    return this.isEvent(t18, this.#n);
  }
  static isUIEvent(t18) {
    return this.isEvent(t18, this.#o);
  }
  static isUserInputEvent(t18) {
    return this.isEvent(t18, this.#i);
  }
  static isCtorName(t18, e2) {
    return !!isObject$1(t18) && ("string" == typeof e2 && t18?.constructor?.name === e2 || !!e2?.has(t18?.constructor?.name));
  }
  static #a(t18, e2, n2) {
    if (!isObject$1(t18)) return false;
    if (t18.nodeType !== e2) return false;
    const o2 = globalThis[n2];
    if (o2 && t18 instanceof o2) return true;
    const i2 = this.#e.has(t18.nodeType) ? t18?.ownerDocument?.defaultView : this.getWindow(t18, this.#r), r2 = i2?.[n2];
    return r2 && t18 instanceof r2;
  }
};
var _a$3;
let TJSGameSettings$1 = class {
  #s;
  #c = [];
  #l = /* @__PURE__ */ new Map();
  constructor(t18) {
    if ("string" != typeof t18) throw new TypeError("'namespace' is not a string.");
    this.#s = t18;
  }
  static #u(t18) {
    return writable(t18);
  }
  get namespace() {
    return this.#s;
  }
  #p(t18, e2) {
    let n2 = this.#l.get(t18);
    return void 0 === n2 && (n2 = _a$3.#u(e2), this.#l.set(t18, n2)), n2;
  }
  getReadableStore(t18) {
    if (!this.#l.has(t18)) return void console.warn(`TJSGameSettings - getReadableStore: '${t18}' is not a registered setting.`);
    return { subscribe: this.#p(t18).subscribe };
  }
  getStore(t18) {
    return this.getWritableStore(t18);
  }
  getWritableStore(t18) {
    if (this.#l.has(t18)) return this.#p(t18);
    console.warn(`TJSGameSettings - getWritableStore: '${t18}' is not a registered setting.`);
  }
  register(t18, e2 = true) {
    if (!isObject$1(t18)) throw new TypeError("TJSGameSettings - register: setting is not an object.");
    if (!isObject$1(t18.options)) throw new TypeError("TJSGameSettings - register: 'setting.options' attribute is not an object.");
    if ("boolean" != typeof e2) throw new TypeError("TJSGameSettings - register: 'coreConfig' is not an boolean.");
    if (void 0 !== t18.store && !isMinimalWritableStore$1(t18.store)) throw new TypeError("TJSGameSettings - register: 'setting.store' attribute is not a minimal writable store.");
    const n2 = t18.namespace ?? this.#s, o2 = t18.key, i2 = !!e2 && (t18.options.config ?? true);
    if ("string" != typeof n2) throw new TypeError("TJSGameSettings - register: 'namespace' attribute is not a string.");
    if ("string" != typeof o2) throw new TypeError("TJSGameSettings - register: 'key' attribute is not a string.");
    const r2 = t18.store, a2 = t18.options, s2 = [];
    let c2 = false;
    if (s2.push((t19) => {
      const e3 = this.#p(o2);
      e3 && !c2 && (c2 = true, e3.set(t19), c2 = false);
    }), isIterable$1(a2?.onChange)) for (const t19 of a2.onChange) "function" == typeof t19 && s2.push(t19);
    else "function" == typeof a2.onChange && s2.push(a2.onChange);
    globalThis.game.settings.register(n2, o2, { ...a2, config: i2, onChange: (t19) => {
      for (const e3 of s2) e3(t19);
    } });
    const l2 = r2 || this.#p(o2, globalThis.game.settings.get(n2, o2));
    r2 && (this.#l.set(o2, l2), r2.set(globalThis.game.settings.get(n2, o2)));
    subscribeIgnoreFirst$1(l2, async (t19) => {
      c2 || (c2 = true, await globalThis.game.settings.set(n2, o2, t19)), c2 = false;
    });
    {
      const { store: e3, ...i3 } = t18, r3 = Object.assign({}, i3, { namespace: n2, key: o2, options: a2 });
      Object.freeze(r3), this.#c.push(r3);
    }
  }
  registerAll(t18, e2) {
    if (!isIterable$1(t18)) throw new TypeError("TJSGameSettings - registerAll: settings is not iterable.");
    for (const n2 of t18) {
      if (!isObject$1(n2)) throw new TypeError("TJSGameSettings - registerAll: entry in settings is not an object.");
      if ("string" != typeof n2.namespace) throw new TypeError("TJSGameSettings - registerAll: entry in settings missing 'namespace' attribute.");
      if ("string" != typeof n2.key) throw new TypeError("TJSGameSettings - registerAll: entry in settings missing 'key' attribute.");
      if (!isObject$1(n2.options)) throw new TypeError("TJSGameSettings - registerAll: entry in settings missing 'options' attribute.");
      this.register(n2, e2);
    }
  }
  *data(t18 = void 0) {
    if (void 0 !== t18 && !CrossWindow$1.isRegExp(t18)) throw new TypeError("'regex' is not a RegExp");
    if (this.#c.length) if (t18) for (const e2 of this.#c) t18.test(e2.key) && (yield e2);
    else for (const t19 of this.#c) yield t19;
  }
  *entries(t18 = void 0) {
    if (void 0 !== t18 && !CrossWindow$1.isRegExp(t18)) throw new TypeError("'regex' is not a RegExp");
    if (this.#l.size) if (t18) for (const e2 of this.#l.keys()) t18.test(e2) && (yield [e2, this.getStore(e2)]);
    else for (const t19 of this.#l.keys()) yield [t19, this.getStore(t19)];
  }
  *keys(t18 = void 0) {
    if (void 0 !== t18 && !CrossWindow$1.isRegExp(t18)) throw new TypeError("'regex' is not a RegExp");
    if (this.#l.size) if (t18) for (const e2 of this.#l.keys()) t18.test(e2) && (yield e2);
    else for (const t19 of this.#l.keys()) yield t19;
  }
  *stores(t18 = void 0) {
    if (void 0 !== t18 && !CrossWindow$1.isRegExp(t18)) throw new TypeError("'regex' is not a RegExp");
    if (this.#l.size) if (t18) for (const e2 of this.#l.keys()) t18.test(e2) && (yield this.getStore(e2));
    else for (const t19 of this.#l.keys()) yield this.getStore(t19);
  }
};
function storeGenerator$1({ storage: t18, serialize: e2 = JSON.stringify, deserialize: n2 = JSON.parse }) {
  function o2(t19, e3, n3) {
    return { subscribe: i2(t19, e3, n3).subscribe };
  }
  function i2(o3, i3, r2) {
    if (t18) {
      const r3 = t18.getItem(o3);
      try {
        r3 && (i3 = n2(r3));
      } catch (t19) {
      }
      t18.setItem(o3, e2(i3));
    }
    const a2 = writable(i3, r2 ? function(n3) {
      return r2(function(i4) {
        return t18 && t18.setItem(o3, e2(i4)), n3(i4);
      }, function(t19) {
        s2(t19(get_store_value(a2)));
      });
    } : void 0);
    function s2(n3) {
      t18 && t18.setItem(o3, e2(n3)), a2.set(n3);
    }
    return { set: s2, update: function(t19) {
      s2(t19(get_store_value(a2)));
    }, subscribe: function(t19, e3) {
      return a2.subscribe(t19, e3);
    } };
  }
  return { readable: o2, writable: i2, derived: function(e3, i3, r2, a2) {
    const s2 = !Array.isArray(i3), c2 = s2 ? [i3] : i3;
    if (t18 && t18.getItem(e3)) try {
      a2 = n2(t18.getItem(e3));
    } catch (t19) {
    }
    return o2(e3, a2, (t19, e4) => {
      let n3 = false;
      const o3 = [];
      let i4, a3 = 0;
      const l2 = () => {
        if (a3) return;
        i4?.();
        const n4 = s2 ? o3[0] : o3;
        if (r2.length < 2) t19(r2(n4));
        else {
          const o4 = r2(n4, t19, e4);
          "function" == typeof o4 && (i4 = o4);
        }
      }, u2 = c2.map((t20, e5) => t20.subscribe((t21) => {
        o3[e5] = t21, a3 &= ~(1 << e5), n3 && l2();
      }, () => {
        a3 |= 1 << e5;
      }));
      return n3 = true, l2(), function() {
        u2.forEach((t20) => t20()), i4?.();
      };
    });
  }, storage: t18, serialize: e2, deserialize: n2 };
}
_a$3 = TJSGameSettings$1;
const sessionStores$1 = storeGenerator$1({ storage: globalThis?.sessionStorage });
let TJSWebStorage$1 = class {
  #d;
  #l = /* @__PURE__ */ new Map();
  constructor(t18) {
    this.#d = t18;
  }
  #u(t18, e2 = void 0, n2) {
    try {
      const o2 = this.#d.storage.getItem(t18);
      if (null !== o2) {
        e2 = (n2?.deserialize ?? this.#d.deserialize)(o2);
      }
    } catch (t19) {
    }
    return (n2?.writable ?? this.#d.writable)(t18, e2);
  }
  #m(t18) {
    return this.#l.get(t18)?.deserialize ?? this.#d.deserialize;
  }
  #f(t18) {
    return this.#l.get(t18)?.serialize ?? this.#d.serialize;
  }
  #p(t18, e2 = void 0, n2) {
    const o2 = this.#l.get(t18);
    if (o2) return o2.store;
    const i2 = this.#u(t18, e2, n2);
    return this.#l.set(t18, { store: i2, deserialize: n2?.deserialize, serialize: n2?.serialize }), i2;
  }
  getItem(t18, e2) {
    let n2 = e2;
    const o2 = this.#d.storage.getItem(t18);
    if (null !== o2) try {
      n2 = this.#m(t18)(o2);
    } catch (t19) {
      n2 = e2;
    }
    else if (void 0 !== e2) try {
      const n3 = this.#f(t18)(e2);
      this.#d.storage.setItem(t18, n3);
    } catch (t19) {
    }
    return n2;
  }
  getStore(t18, e2, n2) {
    return this.#p(t18, e2, n2);
  }
  hasStore(t18) {
    return this.#l.has(t18);
  }
  setItem(t18, e2) {
    this.#p(t18).set(e2);
  }
  swapItemBoolean(t18, e2) {
    const n2 = this.#p(t18, e2);
    let o2 = false;
    try {
      o2 = !!this.#m(t18)(this.#d.storage.getItem(t18));
    } catch (t19) {
    }
    const i2 = "boolean" == typeof o2 && !o2;
    return n2.set(i2), i2;
  }
  *entries(t18 = void 0) {
    if (void 0 !== t18 && !CrossWindow$1.isRegExp(t18)) throw new TypeError("'regex' is not a RegExp");
    if (this.#l.size) if (t18) for (const e2 of this.#l.keys()) t18.test(e2) && (yield [e2, this.getStore(e2)]);
    else for (const t19 of this.#l.keys()) yield [t19, this.getStore(t19)];
  }
  *keys(t18 = void 0) {
    if (void 0 !== t18 && !CrossWindow$1.isRegExp(t18)) throw new TypeError("'regex' is not a RegExp");
    if (this.#l.size) if (t18) for (const e2 of this.#l.keys()) t18.test(e2) && (yield e2);
    else for (const t19 of this.#l.keys()) yield t19;
  }
  *stores(t18 = void 0) {
    if (void 0 !== t18 && !CrossWindow$1.isRegExp(t18)) throw new TypeError("'regex' is not a RegExp");
    if (this.#l.size) if (t18) for (const e2 of this.#l.keys()) t18.test(e2) && (yield this.getStore(e2));
    else for (const t19 of this.#l.keys()) yield this.getStore(t19);
  }
}, TJSSessionStorage$1 = class extends TJSWebStorage$1 {
  constructor() {
    super(sessionStores$1);
  }
};
function writableDerived$1(t18, e2, n2, o2) {
  var i2, r2, a2 = false, s2 = n2.length >= 2, c2 = derived(t18, (t19, n3, o3) => {
    if (i2 = n3, s2 && (r2 = t19), !a2) {
      let i3 = e2(t19, n3, o3);
      if (!(e2.length < 2)) return i3;
      n3(i3);
    }
    a2 = false;
  }, o2), l2 = !Array.isArray(t18);
  var u2 = false;
  function p2(e3) {
    var o3, s3, p3, d2;
    if (u2) return d2 = e3(get_store_value(c2)), void i2(d2);
    var m2, f2 = c2.subscribe((t19) => {
      u2 ? o3 ? s3 = true : o3 = true : p3 = t19;
    });
    d2 = e3(p3), u2 = true, i2(d2), f2(), u2 = false, s3 && (d2 = get_store_value(c2)), o3 && (m2 = n2(d2, r2), l2 ? (a2 = true, t18.set(m2)) : m2.forEach((e4, n3) => {
      a2 = true, t18[n3].set(e4);
    }), a2 = false);
  }
  return { subscribe: c2.subscribe, set(t19) {
    p2(() => t19);
  }, update: p2 };
}
function propertyStore$1(t18, e2) {
  if (Array.isArray(e2)) {
    let n2 = e2.concat();
    return writableDerived$1(t18, (t19) => {
      for (let e3 = 0; e3 < n2.length; ++e3) t19 = t19[n2[e3]];
      return t19;
    }, (t19, e3) => {
      let o2 = e3;
      for (let t20 = 0; t20 < n2.length - 1; ++t20) o2 = o2[n2[t20]];
      return o2[n2[n2.length - 1]] = t19, e3;
    });
  }
  return writableDerived$1(t18, (t19) => t19[e2], (t19, n2) => (n2[e2] = t19, n2));
}
let APIConfig$1 = class {
  constructor() {
  }
  static isConfig(t18, { raiseException: e2 = false } = {}) {
    if (!isObject$1(t18)) {
      if (e2) throw new TypeError("TJSSvelte.config.isConfig error: 'config' is not an object.");
      return false;
    }
    if (!TJSSvelte$1.util.isComponent(t18.class)) {
      if (e2) throw new TypeError("TJSSvelte.config.isConfig error: 'config.class' is not a Svelte component constructor.");
      return false;
    }
    return true;
  }
  static isConfigEmbed(t18, { raiseException: e2 = false } = {}) {
    if (!isObject$1(t18)) {
      if (e2) throw new TypeError("TJSSvelte.config.isConfigEmbed error: 'config' is not an object.");
      return false;
    }
    if (!TJSSvelte$1.util.isComponent(t18.class)) {
      if (e2) throw new TypeError("TJSSvelte.config.isConfigEmbed error: 'config.class' is not a Svelte component constructor.");
      return false;
    }
    if (void 0 !== t18.props && !isObject$1(t18.props)) {
      if (e2) throw new TypeError("TJSSvelte.config.isConfigEmbed error: 'config.props' is not an object.");
      return false;
    }
    return true;
  }
  static parseConfig(t18, { contextExternal: e2 = false, thisArg: n2 } = {}) {
    if (!isObject$1(t18)) throw new TypeError(`TJSSvelte.config.parseConfig - 'config' is not an object:
${JSON.stringify(t18)}.`);
    if (!TJSSvelte$1.util.isComponent(t18.class)) throw new TypeError(`TJSSvelte.config.parseConfig - 'class' is not a Svelte component constructor for config:
${JSON.stringify(t18)}.`);
    if (void 0 !== t18.hydrate && "boolean" != typeof t18.hydrate) throw new TypeError(`TJSSvelte.config.parseConfig - 'hydrate' is not a boolean for config:
${JSON.stringify(t18)}.`);
    if (void 0 !== t18.intro && "boolean" != typeof t18.intro) throw new TypeError(`TJSSvelte.config.parseConfig - 'intro' is not a boolean for config:
${JSON.stringify(t18)}.`);
    if (void 0 !== t18.target && !CrossWindow$1.isElement(t18.target) && !CrossWindow$1.isShadowRoot(t18.target) && !CrossWindow$1.isDocumentFragment(t18.target)) throw new TypeError(`TJSSvelte.config.parseConfig - 'target' is not a Element, ShadowRoot, or DocumentFragment for config:
${JSON.stringify(t18)}.`);
    if (void 0 !== t18.anchor && !CrossWindow$1.isElement(t18.anchor) && !CrossWindow$1.isShadowRoot(t18.anchor) && !CrossWindow$1.isDocumentFragment(t18.anchor)) throw new TypeError(`TJSSvelte.config.parseConfig - 'anchor' is not a string, Element for config:
${JSON.stringify(t18)}.`);
    if (void 0 !== t18.context && "function" != typeof t18.context && !isObject$1(t18.context)) throw new TypeError(`TJSSvelte.config.parseConfig - 'context' is not a function or object for config:
${JSON.stringify(t18)}.`);
    const o2 = { ...t18 };
    let i2 = {};
    if ("function" == typeof o2.context) {
      const e3 = o2.context;
      delete o2.context;
      const r2 = e3.call(n2);
      if (!isObject$1(r2)) throw new Error(`TJSSvelte.config.parseConfig - 'context' is a function that did not return an object for config:
${JSON.stringify(t18)}`);
      i2 = { ...r2 };
    } else isObject$1(o2.context) && (i2 = o2.context, delete o2.context);
    return o2.props = this.#h(o2.props, n2, t18), e2 ? (o2.context = /* @__PURE__ */ new Map(), o2.context.set("#external", i2)) : o2.context = new Map(Object.entries(i2)), o2;
  }
  static #h(t18, e2, n2) {
    if ("function" == typeof t18) {
      const o2 = t18.call(e2);
      if (isObject$1(o2)) return o2;
      throw new Error(`TJSSvelte.config.parseConfig - 'props' is a function that did not return an object for config:
${JSON.stringify(n2)}`);
    }
    if (isObject$1(t18)) return t18;
    if (void 0 !== t18) throw new Error(`TJSSvelte.config.parseConfig - 'props' is not a function or an object for config:
${JSON.stringify(n2)}`);
    return {};
  }
};
Object.seal(APIConfig$1);
let APIUtil$1 = class {
  constructor() {
  }
  static isComponent(t18) {
    if (null == t18 || "function" != typeof t18) return false;
    const e2 = t18?.prototype?.constructor?.name;
    return !("string" != typeof e2 || !e2.startsWith("Proxy<") && "ProxyComponent" !== e2) || ("undefined" != typeof window ? "function" == typeof t18?.prototype?.$destroy && "function" == typeof t18?.prototype?.$on : "function" == typeof t18?.prototype?.render);
  }
  static isHMRProxy(t18) {
    const e2 = t18?.constructor?.name;
    if ("string" == typeof e2 && (e2.startsWith("Proxy<") || "ProxyComponent" === e2)) return true;
    const n2 = t18?.prototype?.constructor?.name;
    return "string" == typeof n2 && (n2.startsWith("Proxy<") || "ProxyComponent" === n2);
  }
  static async outroAndDestroy(t18) {
    return null == t18 ? Promise.resolve() : new Promise((e2) => {
      t18?.$$?.fragment && t18?.$$?.fragment?.o ? (group_outros(), transition_out(t18.$$.fragment, 0, 0, () => {
        t18?.$destroy?.(), e2();
      }), check_outros()) : (t18?.$destroy?.(), e2());
    });
  }
};
Object.seal(APIUtil$1);
let TJSSvelte$1 = class {
  constructor() {
  }
  static get config() {
    return APIConfig$1;
  }
  static get util() {
    return APIUtil$1;
  }
};
function backInOut(t18) {
  const e2 = 2.5949095;
  return (t18 *= 2) < 1 ? t18 * t18 * ((e2 + 1) * t18 - e2) * 0.5 : 0.5 * ((t18 -= 2) * t18 * ((e2 + 1) * t18 + e2) + 2);
}
function backIn(t18) {
  const e2 = 1.70158;
  return t18 * t18 * ((e2 + 1) * t18 - e2);
}
function backOut(t18) {
  const e2 = 1.70158;
  return --t18 * t18 * ((e2 + 1) * t18 + e2) + 1;
}
function bounceOut(t18) {
  const e2 = t18 * t18;
  return t18 < 4 / 11 ? 7.5625 * e2 : t18 < 8 / 11 ? 9.075 * e2 - 9.9 * t18 + 3.4 : t18 < 0.9 ? 4356 / 361 * e2 - 35442 / 1805 * t18 + 16061 / 1805 : 10.8 * t18 * t18 - 20.52 * t18 + 10.72;
}
function bounceInOut(t18) {
  return t18 < 0.5 ? 0.5 * (1 - bounceOut(1 - 2 * t18)) : 0.5 * bounceOut(2 * t18 - 1) + 0.5;
}
function bounceIn(t18) {
  return 1 - bounceOut(1 - t18);
}
function circInOut(t18) {
  return (t18 *= 2) < 1 ? -0.5 * (Math.sqrt(1 - t18 * t18) - 1) : 0.5 * (Math.sqrt(1 - (t18 -= 2) * t18) + 1);
}
function circIn(t18) {
  return 1 - Math.sqrt(1 - t18 * t18);
}
function circOut(t18) {
  return Math.sqrt(1 - --t18 * t18);
}
function cubicInOut(t18) {
  return t18 < 0.5 ? 4 * t18 * t18 * t18 : 0.5 * Math.pow(2 * t18 - 2, 3) + 1;
}
function cubicIn(t18) {
  return t18 * t18 * t18;
}
function cubicOut(t18) {
  const e2 = t18 - 1;
  return e2 * e2 * e2 + 1;
}
function elasticInOut(t18) {
  return t18 < 0.5 ? 0.5 * Math.sin(13 * Math.PI / 2 * 2 * t18) * Math.pow(2, 10 * (2 * t18 - 1)) : 0.5 * Math.sin(-13 * Math.PI / 2 * (2 * t18 - 1 + 1)) * Math.pow(2, -10 * (2 * t18 - 1)) + 1;
}
function elasticIn(t18) {
  return Math.sin(13 * t18 * Math.PI / 2) * Math.pow(2, 10 * (t18 - 1));
}
function elasticOut(t18) {
  return Math.sin(-13 * (t18 + 1) * Math.PI / 2) * Math.pow(2, -10 * t18) + 1;
}
function expoInOut(t18) {
  return 0 === t18 || 1 === t18 ? t18 : t18 < 0.5 ? 0.5 * Math.pow(2, 20 * t18 - 10) : -0.5 * Math.pow(2, 10 - 20 * t18) + 1;
}
function expoIn(t18) {
  return 0 === t18 ? t18 : Math.pow(2, 10 * (t18 - 1));
}
function expoOut(t18) {
  return 1 === t18 ? t18 : 1 - Math.pow(2, -10 * t18);
}
function quadInOut(t18) {
  return (t18 /= 0.5) < 1 ? 0.5 * t18 * t18 : -0.5 * (--t18 * (t18 - 2) - 1);
}
function quadIn(t18) {
  return t18 * t18;
}
function quadOut(t18) {
  return -t18 * (t18 - 2);
}
function quartInOut(t18) {
  return t18 < 0.5 ? 8 * Math.pow(t18, 4) : -8 * Math.pow(t18 - 1, 4) + 1;
}
function quartIn(t18) {
  return Math.pow(t18, 4);
}
function quartOut(t18) {
  return Math.pow(t18 - 1, 3) * (1 - t18) + 1;
}
function quintInOut(t18) {
  return (t18 *= 2) < 1 ? 0.5 * t18 * t18 * t18 * t18 * t18 : 0.5 * ((t18 -= 2) * t18 * t18 * t18 * t18 + 2);
}
function quintIn(t18) {
  return t18 * t18 * t18 * t18 * t18;
}
function quintOut(t18) {
  return --t18 * t18 * t18 * t18 * t18 + 1;
}
function sineInOut(t18) {
  return -0.5 * (Math.cos(Math.PI * t18) - 1);
}
function sineIn(t18) {
  const e2 = Math.cos(t18 * Math.PI * 0.5);
  return Math.abs(e2) < 1e-14 ? 1 : 1 - e2;
}
function sineOut(t18) {
  return Math.sin(t18 * Math.PI / 2);
}
Object.seal(TJSSvelte$1);
const svelteEasingFunc = Object.freeze(Object.defineProperty({ __proto__: null, backIn, backInOut, backOut, bounceIn, bounceInOut, bounceOut, circIn, circInOut, circOut, cubicIn, cubicInOut, cubicOut, elasticIn, elasticInOut, elasticOut, expoIn, expoInOut, expoOut, linear: identity, quadIn, quadInOut, quadOut, quartIn, quartInOut, quartOut, quintIn, quintInOut, quintOut, sineIn, sineInOut, sineOut }, Symbol.toStringTag, { value: "Module" })), easingFunc$1 = svelteEasingFunc;
function getEasingFunc$1(t18, e2) {
  if ("function" == typeof t18) return t18;
  const n2 = easingFunc$1[t18];
  return n2 || easingFunc$1[e2?.default ?? "linear"];
}
let A11yHelper$1 = class t2 {
  static #g = false;
  static get debug() {
    return this.#g;
  }
  static set debug(t18) {
    if ("boolean" != typeof t18) throw new TypeError("'debug' is not a boolean.");
    this.#g = t18;
  }
  static get prefersReducedMotion() {
    return globalThis?.matchMedia("(prefers-reduced-motion: reduce)")?.matches ?? false;
  }
  static applyFocusSource(t18) {
    if (!isObject$1(t18)) return;
    const e2 = isObject$1(t18?.focusSource) ? t18.focusSource : t18;
    setTimeout(() => {
      const t19 = "boolean" == typeof e2.debug ? this.debug || e2.debug : this.debug;
      if (isIterable$1(e2.focusEl)) {
        t19 && e2.focusEl;
        for (const t20 of e2.focusEl) {
          if (t20?.nodeType === Node.ELEMENT_NODE && t20?.isConnected) {
            t20?.focus();
            break;
          }
          if ("string" == typeof t20) {
            const e3 = document.querySelector(t20);
            if (e3?.nodeType === Node.ELEMENT_NODE && e3?.isConnected) {
              e3?.focus();
              break;
            }
          }
        }
      }
    }, 0);
  }
  static getFirstFocusableElement(t18 = document, e2) {
    const n2 = this.getFocusableElements(t18, e2);
    return n2.length > 0 ? n2[0] : void 0;
  }
  static getFocusableElements(t18 = document, { anchorHref: e2 = true, ignoreClasses: n2, ignoreElements: o2, parentHidden: i2 = false, selectors: r2 } = {}) {
    if (t18?.nodeType !== Node.ELEMENT_NODE && t18?.nodeType !== Node.DOCUMENT_NODE) throw new TypeError("'element' is not a HTMLElement, SVGElement, or Document instance.");
    if ("boolean" != typeof e2) throw new TypeError("'anchorHref' is not a boolean.");
    if (void 0 !== n2 && !isIterable$1(n2)) throw new TypeError("'ignoreClasses' is not an iterable list.");
    if (void 0 !== o2 && !CrossWindow$1.isSet(o2)) throw new TypeError("'ignoreElements' is not a Set.");
    if (void 0 !== r2 && "string" != typeof r2) throw new TypeError("'selectors' is not a string.");
    const a2 = r2 ?? this.#_(e2);
    let s2 = [...t18.querySelectorAll(a2)];
    return s2 = o2 && n2 ? s2.filter((t19) => {
      let e3 = false;
      for (const o3 of n2) if (t19.classList.contains(o3)) {
        e3 = true;
        break;
      }
      return !(e3 || o2.has(t19) || "none" === t19.style.display || "hidden" === t19.style.visibility || t19.hasAttribute("disabled") || t19.hasAttribute("inert") || "true" === t19.getAttribute("aria-hidden"));
    }) : n2 ? s2.filter((t19) => {
      let e3 = false;
      for (const o3 of n2) if (t19.classList.contains(o3)) {
        e3 = true;
        break;
      }
      return !e3 && "none" !== t19.style.display && "hidden" !== t19.style.visibility && !t19.hasAttribute("disabled") && !t19.hasAttribute("inert") && "true" !== t19.getAttribute("aria-hidden");
    }) : o2 ? s2.filter((t19) => !o2.has(t19) && "none" !== t19.style.display && "hidden" !== t19.style.visibility && !t19.hasAttribute("disabled") && !t19.hasAttribute("inert") && "true" !== t19.getAttribute("aria-hidden")) : s2.filter((t19) => "none" !== t19.style.display && "hidden" !== t19.style.visibility && !t19.hasAttribute("disabled") && !t19.hasAttribute("inert") && "true" !== t19.getAttribute("aria-hidden")), i2 && (s2 = s2.filter((e3) => !this.isParentHidden(e3, t18))), s2;
  }
  static #_(t18 = true) {
    return `button, [contenteditable=""], [contenteditable="true"], details summary:not([tabindex="-1"]), embed, a${t18 ? "[href]" : ""}, iframe, object, input:not([type=hidden]), select, textarea, [tabindex]:not([tabindex="-1"])`;
  }
  static getFocusSource({ event: e2, x: n2, y: o2, focusEl: i2, debug: r2 = false }) {
    if (void 0 !== i2 && !this.isFocusSource(i2)) throw new TypeError("A11yHelper.getFocusSource error: 'focusEl' is not a HTMLElement, SVGElement, or string.");
    if (void 0 !== r2 && "boolean" != typeof r2) throw new TypeError("A11yHelper.getFocusSource error: 'debug' is not a boolean.");
    const a2 = "boolean" == typeof r2 ? this.debug || r2 : this.debug;
    if (void 0 === e2) {
      if ("number" != typeof n2) throw new TypeError("A11yHelper.getFocusSource error: 'event' not defined and 'x' is not a number.");
      if ("number" != typeof o2) throw new TypeError("A11yHelper.getFocusSource error: 'event' not defined and 'y' is not a number.");
      const t18 = { debug: r2, focusEl: void 0 !== i2 ? [i2] : void 0, x: n2, y: o2 };
      return t18;
    }
    if (void 0 !== e2 && !CrossWindow$1.isUserInputEvent(e2)) throw new TypeError("A11yHelper.getFocusSource error: 'event' is not a KeyboardEvent, MouseEvent, or PointerEvent.");
    if (void 0 !== n2 && !Number.isInteger(n2)) throw new TypeError("A11yHelper.getFocusSource error: 'x' is not a number.");
    if (void 0 !== o2 && !Number.isInteger(o2)) throw new TypeError("A11yHelper.getFocusSource error: 'y' is not a number.");
    let s2;
    if (e2 && (t2.isFocusable(e2.target) ? s2 = e2.target : t2.isFocusable(e2.currentTarget) ? s2 = e2.currentTarget : a2 && (e2.target, e2.currentTarget), s2 && s2?.nodeType !== Node.ELEMENT_NODE && "function" != typeof s2?.focus)) throw new TypeError("A11yHelper.getFocusSource error: 'targetEl' is not an HTMLElement or SVGElement.");
    const c2 = { debug: r2 };
    if (CrossWindow$1.isPointerEvent(e2)) if (2 !== e2?.button && "contextmenu" === e2.type) {
      const t18 = (s2 ?? e2.target).getBoundingClientRect();
      c2.source = "keyboard", c2.x = n2 ?? t18.left + t18.width / 2, c2.y = o2 ?? t18.top + t18.height / 2, c2.focusEl = s2 ? [s2] : [], i2 && c2.focusEl.push(i2);
    } else c2.source = "pointer", c2.x = n2 ?? e2.pageX, c2.y = o2 ?? e2.pageY, c2.focusEl = s2 ? [s2] : [], i2 && c2.focusEl.push(i2);
    else {
      const t18 = s2 ?? e2?.target;
      if (t18) {
        const e3 = t18.getBoundingClientRect();
        c2.source = "keyboard", c2.x = n2 ?? e3.left + e3.width / 2, c2.y = o2 ?? e3.top + e3.height / 2, c2.focusEl = s2 ? [s2] : [];
      }
      i2 && c2.focusEl.push(i2);
    }
    return c2;
  }
  static getLastFocusableElement(t18 = document, e2) {
    const n2 = this.getFocusableElements(t18, e2);
    return n2.length > 0 ? n2[n2.length - 1] : void 0;
  }
  static isFocusable(t18, { anchorHref: e2 = true, ignoreClasses: n2 } = {}) {
    if (null == t18 || t18?.hidden || !t18?.isConnected || t18?.nodeType !== Node.ELEMENT_NODE || "function" != typeof t18?.focus) return false;
    if ("boolean" != typeof e2) throw new TypeError("'anchorHref' is not a boolean.");
    if (void 0 !== n2 && !isIterable$1(n2)) throw new TypeError("'ignoreClasses' is not an iterable list.");
    const o2 = t18.getAttribute("contenteditable"), i2 = "string" == typeof o2 && ("" === o2 || "true" === o2), r2 = globalThis.parseInt(t18.getAttribute("tabindex")), a2 = Number.isInteger(r2) && r2 >= 0;
    return !!(i2 || a2 || CrossWindow$1.isFocusableHTMLElement(t18)) && (!(e2 && !a2 && CrossWindow$1.isHTMLAnchorElement(t18) && "string" != typeof t18.getAttribute("href")) && ("none" !== t18.style.display && "hidden" !== t18.style.visibility && !t18.hasAttribute("disabled") && !t18.hasAttribute("inert") && "true" !== t18.getAttribute("aria-hidden")));
  }
  static isFocusSource(t18) {
    return "string" == typeof t18 || t18?.nodeType === Node.ELEMENT_NODE && "function" == typeof t18?.focus;
  }
  static isFocusTarget(t18) {
    return null != t18 && t18?.nodeType === Node.ELEMENT_NODE && "function" == typeof t18?.focus;
  }
  static isFocusWithin(t18) {
    if (!isObject$1(t18) || t18?.hidden || !t18?.isConnected) return false;
    let e2 = CrossWindow$1.getActiveElement(t18);
    if (!e2) return false;
    for (; e2; ) {
      if (e2 === t18) return true;
      e2 = e2.parentElement;
    }
    return false;
  }
  static isParentHidden(t18, e2) {
    if (!CrossWindow$1.isElement(t18)) throw new TypeError("'element' is not an Element.");
    if (e2 = e2 ?? CrossWindow$1.getDocument(t18)?.body, !CrossWindow$1.isElement(e2)) throw new TypeError("'stopElement' must be an Element.");
    let n2 = t18.parentElement;
    for (; n2 && n2 !== e2; ) {
      if (0 === n2.offsetWidth && 0 === n2.offsetHeight) return true;
      n2 = n2.parentElement;
    }
    return false;
  }
};
function clamp$1(t18 = 0, e2 = 0, n2 = 0) {
  return Math.min(Math.max(t18, e2), n2);
}
function degToRad$1(t18) {
  return t18 * (Math.PI / 180);
}
function radToDeg$1(t18) {
  return t18 * (180 / Math.PI);
}
function lerp$1(t18, e2, n2) {
  return (1 - n2) * t18 + n2 * e2;
}
var GLM_EPSILON$1 = 1e-6, Mat4$1 = class t3 extends Float32Array {
  static #$ = new Float32Array([1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1]);
  static #b = new Float32Array(3);
  constructor(...e2) {
    switch (e2.length) {
      case 16:
        super(e2);
        break;
      case 2:
        super(e2[0], e2[1], 16);
        break;
      case 1:
        const n2 = e2[0];
        "number" == typeof n2 ? super([n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2]) : super(n2, 0, 16);
        break;
      default:
        super(t3.#$);
    }
  }
  get str() {
    return t3.str(this);
  }
  copy(t18) {
    return this.set(t18), this;
  }
  identity() {
    return this.set(t3.#$), this;
  }
  multiply(e2) {
    return t3.multiply(this, this, e2);
  }
  mul(t18) {
    return this;
  }
  transpose() {
    return t3.transpose(this, this);
  }
  invert() {
    return t3.invert(this, this);
  }
  translate(e2) {
    return t3.translate(this, this, e2);
  }
  rotate(e2, n2) {
    return t3.rotate(this, this, e2, n2);
  }
  scale(e2) {
    return t3.scale(this, this, e2);
  }
  rotateX(e2) {
    return t3.rotateX(this, this, e2);
  }
  rotateY(e2) {
    return t3.rotateY(this, this, e2);
  }
  rotateZ(e2) {
    return t3.rotateZ(this, this, e2);
  }
  perspectiveNO(e2, n2, o2, i2) {
    return t3.perspectiveNO(this, e2, n2, o2, i2);
  }
  perspectiveZO(e2, n2, o2, i2) {
    return t3.perspectiveZO(this, e2, n2, o2, i2);
  }
  orthoNO(e2, n2, o2, i2, r2, a2) {
    return t3.orthoNO(this, e2, n2, o2, i2, r2, a2);
  }
  orthoZO(e2, n2, o2, i2, r2, a2) {
    return t3.orthoZO(this, e2, n2, o2, i2, r2, a2);
  }
  static get BYTE_LENGTH() {
    return 16 * Float32Array.BYTES_PER_ELEMENT;
  }
  static create() {
    return new t3();
  }
  static clone(e2) {
    return new t3(e2);
  }
  static copy(t18, e2) {
    return t18[0] = e2[0], t18[1] = e2[1], t18[2] = e2[2], t18[3] = e2[3], t18[4] = e2[4], t18[5] = e2[5], t18[6] = e2[6], t18[7] = e2[7], t18[8] = e2[8], t18[9] = e2[9], t18[10] = e2[10], t18[11] = e2[11], t18[12] = e2[12], t18[13] = e2[13], t18[14] = e2[14], t18[15] = e2[15], t18;
  }
  static fromValues(...e2) {
    return new t3(...e2);
  }
  static set(t18, ...e2) {
    return t18[0] = e2[0], t18[1] = e2[1], t18[2] = e2[2], t18[3] = e2[3], t18[4] = e2[4], t18[5] = e2[5], t18[6] = e2[6], t18[7] = e2[7], t18[8] = e2[8], t18[9] = e2[9], t18[10] = e2[10], t18[11] = e2[11], t18[12] = e2[12], t18[13] = e2[13], t18[14] = e2[14], t18[15] = e2[15], t18;
  }
  static identity(t18) {
    return t18[0] = 1, t18[1] = 0, t18[2] = 0, t18[3] = 0, t18[4] = 0, t18[5] = 1, t18[6] = 0, t18[7] = 0, t18[8] = 0, t18[9] = 0, t18[10] = 1, t18[11] = 0, t18[12] = 0, t18[13] = 0, t18[14] = 0, t18[15] = 1, t18;
  }
  static transpose(t18, e2) {
    if (t18 === e2) {
      const n2 = e2[1], o2 = e2[2], i2 = e2[3], r2 = e2[6], a2 = e2[7], s2 = e2[11];
      t18[1] = e2[4], t18[2] = e2[8], t18[3] = e2[12], t18[4] = n2, t18[6] = e2[9], t18[7] = e2[13], t18[8] = o2, t18[9] = r2, t18[11] = e2[14], t18[12] = i2, t18[13] = a2, t18[14] = s2;
    } else t18[0] = e2[0], t18[1] = e2[4], t18[2] = e2[8], t18[3] = e2[12], t18[4] = e2[1], t18[5] = e2[5], t18[6] = e2[9], t18[7] = e2[13], t18[8] = e2[2], t18[9] = e2[6], t18[10] = e2[10], t18[11] = e2[14], t18[12] = e2[3], t18[13] = e2[7], t18[14] = e2[11], t18[15] = e2[15];
    return t18;
  }
  static invert(t18, e2) {
    const n2 = e2[0], o2 = e2[1], i2 = e2[2], r2 = e2[3], a2 = e2[4], s2 = e2[5], c2 = e2[6], l2 = e2[7], u2 = e2[8], p2 = e2[9], d2 = e2[10], m2 = e2[11], f2 = e2[12], h2 = e2[13], g2 = e2[14], _ = e2[15], $2 = n2 * s2 - o2 * a2, b2 = n2 * c2 - i2 * a2, y2 = n2 * l2 - r2 * a2, v2 = o2 * c2 - i2 * s2, w2 = o2 * l2 - r2 * s2, S2 = i2 * l2 - r2 * c2, T2 = u2 * h2 - p2 * f2, k2 = u2 * g2 - d2 * f2, x2 = u2 * _ - m2 * f2, E = p2 * g2 - d2 * h2, O2 = p2 * _ - m2 * h2, A2 = d2 * _ - m2 * g2;
    let C2 = $2 * A2 - b2 * O2 + y2 * E + v2 * x2 - w2 * k2 + S2 * T2;
    return C2 ? (C2 = 1 / C2, t18[0] = (s2 * A2 - c2 * O2 + l2 * E) * C2, t18[1] = (i2 * O2 - o2 * A2 - r2 * E) * C2, t18[2] = (h2 * S2 - g2 * w2 + _ * v2) * C2, t18[3] = (d2 * w2 - p2 * S2 - m2 * v2) * C2, t18[4] = (c2 * x2 - a2 * A2 - l2 * k2) * C2, t18[5] = (n2 * A2 - i2 * x2 + r2 * k2) * C2, t18[6] = (g2 * y2 - f2 * S2 - _ * b2) * C2, t18[7] = (u2 * S2 - d2 * y2 + m2 * b2) * C2, t18[8] = (a2 * O2 - s2 * x2 + l2 * T2) * C2, t18[9] = (o2 * x2 - n2 * O2 - r2 * T2) * C2, t18[10] = (f2 * w2 - h2 * y2 + _ * $2) * C2, t18[11] = (p2 * y2 - u2 * w2 - m2 * $2) * C2, t18[12] = (s2 * k2 - a2 * E - c2 * T2) * C2, t18[13] = (n2 * E - o2 * k2 + i2 * T2) * C2, t18[14] = (h2 * b2 - f2 * v2 - g2 * $2) * C2, t18[15] = (u2 * v2 - p2 * b2 + d2 * $2) * C2, t18) : null;
  }
  static adjoint(t18, e2) {
    const n2 = e2[0], o2 = e2[1], i2 = e2[2], r2 = e2[3], a2 = e2[4], s2 = e2[5], c2 = e2[6], l2 = e2[7], u2 = e2[8], p2 = e2[9], d2 = e2[10], m2 = e2[11], f2 = e2[12], h2 = e2[13], g2 = e2[14], _ = e2[15], $2 = n2 * s2 - o2 * a2, b2 = n2 * c2 - i2 * a2, y2 = n2 * l2 - r2 * a2, v2 = o2 * c2 - i2 * s2, w2 = o2 * l2 - r2 * s2, S2 = i2 * l2 - r2 * c2, T2 = u2 * h2 - p2 * f2, k2 = u2 * g2 - d2 * f2, x2 = u2 * _ - m2 * f2, E = p2 * g2 - d2 * h2, O2 = p2 * _ - m2 * h2, A2 = d2 * _ - m2 * g2;
    return t18[0] = s2 * A2 - c2 * O2 + l2 * E, t18[1] = i2 * O2 - o2 * A2 - r2 * E, t18[2] = h2 * S2 - g2 * w2 + _ * v2, t18[3] = d2 * w2 - p2 * S2 - m2 * v2, t18[4] = c2 * x2 - a2 * A2 - l2 * k2, t18[5] = n2 * A2 - i2 * x2 + r2 * k2, t18[6] = g2 * y2 - f2 * S2 - _ * b2, t18[7] = u2 * S2 - d2 * y2 + m2 * b2, t18[8] = a2 * O2 - s2 * x2 + l2 * T2, t18[9] = o2 * x2 - n2 * O2 - r2 * T2, t18[10] = f2 * w2 - h2 * y2 + _ * $2, t18[11] = p2 * y2 - u2 * w2 - m2 * $2, t18[12] = s2 * k2 - a2 * E - c2 * T2, t18[13] = n2 * E - o2 * k2 + i2 * T2, t18[14] = h2 * b2 - f2 * v2 - g2 * $2, t18[15] = u2 * v2 - p2 * b2 + d2 * $2, t18;
  }
  static determinant(t18) {
    const e2 = t18[0], n2 = t18[1], o2 = t18[2], i2 = t18[3], r2 = t18[4], a2 = t18[5], s2 = t18[6], c2 = t18[7], l2 = t18[8], u2 = t18[9], p2 = t18[10], d2 = t18[11], m2 = t18[12], f2 = t18[13], h2 = t18[14], g2 = e2 * a2 - n2 * r2, _ = e2 * s2 - o2 * r2, $2 = n2 * s2 - o2 * a2, b2 = l2 * f2 - u2 * m2, y2 = l2 * h2 - p2 * m2, v2 = u2 * h2 - p2 * f2;
    return c2 * (e2 * v2 - n2 * y2 + o2 * b2) - i2 * (r2 * v2 - a2 * y2 + s2 * b2) + t18[15] * (l2 * $2 - u2 * _ + p2 * g2) - d2 * (m2 * $2 - f2 * _ + h2 * g2);
  }
  static multiply(t18, e2, n2) {
    const o2 = e2[0], i2 = e2[1], r2 = e2[2], a2 = e2[3], s2 = e2[4], c2 = e2[5], l2 = e2[6], u2 = e2[7], p2 = e2[8], d2 = e2[9], m2 = e2[10], f2 = e2[11], h2 = e2[12], g2 = e2[13], _ = e2[14], $2 = e2[15];
    let b2 = n2[0], y2 = n2[1], v2 = n2[2], w2 = n2[3];
    return t18[0] = b2 * o2 + y2 * s2 + v2 * p2 + w2 * h2, t18[1] = b2 * i2 + y2 * c2 + v2 * d2 + w2 * g2, t18[2] = b2 * r2 + y2 * l2 + v2 * m2 + w2 * _, t18[3] = b2 * a2 + y2 * u2 + v2 * f2 + w2 * $2, b2 = n2[4], y2 = n2[5], v2 = n2[6], w2 = n2[7], t18[4] = b2 * o2 + y2 * s2 + v2 * p2 + w2 * h2, t18[5] = b2 * i2 + y2 * c2 + v2 * d2 + w2 * g2, t18[6] = b2 * r2 + y2 * l2 + v2 * m2 + w2 * _, t18[7] = b2 * a2 + y2 * u2 + v2 * f2 + w2 * $2, b2 = n2[8], y2 = n2[9], v2 = n2[10], w2 = n2[11], t18[8] = b2 * o2 + y2 * s2 + v2 * p2 + w2 * h2, t18[9] = b2 * i2 + y2 * c2 + v2 * d2 + w2 * g2, t18[10] = b2 * r2 + y2 * l2 + v2 * m2 + w2 * _, t18[11] = b2 * a2 + y2 * u2 + v2 * f2 + w2 * $2, b2 = n2[12], y2 = n2[13], v2 = n2[14], w2 = n2[15], t18[12] = b2 * o2 + y2 * s2 + v2 * p2 + w2 * h2, t18[13] = b2 * i2 + y2 * c2 + v2 * d2 + w2 * g2, t18[14] = b2 * r2 + y2 * l2 + v2 * m2 + w2 * _, t18[15] = b2 * a2 + y2 * u2 + v2 * f2 + w2 * $2, t18;
  }
  static mul(t18, e2, n2) {
    return t18;
  }
  static translate(t18, e2, n2) {
    const o2 = n2[0], i2 = n2[1], r2 = n2[2];
    if (e2 === t18) t18[12] = e2[0] * o2 + e2[4] * i2 + e2[8] * r2 + e2[12], t18[13] = e2[1] * o2 + e2[5] * i2 + e2[9] * r2 + e2[13], t18[14] = e2[2] * o2 + e2[6] * i2 + e2[10] * r2 + e2[14], t18[15] = e2[3] * o2 + e2[7] * i2 + e2[11] * r2 + e2[15];
    else {
      const n3 = e2[0], a2 = e2[1], s2 = e2[2], c2 = e2[3], l2 = e2[4], u2 = e2[5], p2 = e2[6], d2 = e2[7], m2 = e2[8], f2 = e2[9], h2 = e2[10], g2 = e2[11];
      t18[0] = n3, t18[1] = a2, t18[2] = s2, t18[3] = c2, t18[4] = l2, t18[5] = u2, t18[6] = p2, t18[7] = d2, t18[8] = m2, t18[9] = f2, t18[10] = h2, t18[11] = g2, t18[12] = n3 * o2 + l2 * i2 + m2 * r2 + e2[12], t18[13] = a2 * o2 + u2 * i2 + f2 * r2 + e2[13], t18[14] = s2 * o2 + p2 * i2 + h2 * r2 + e2[14], t18[15] = c2 * o2 + d2 * i2 + g2 * r2 + e2[15];
    }
    return t18;
  }
  static scale(t18, e2, n2) {
    const o2 = n2[0], i2 = n2[1], r2 = n2[2];
    return t18[0] = e2[0] * o2, t18[1] = e2[1] * o2, t18[2] = e2[2] * o2, t18[3] = e2[3] * o2, t18[4] = e2[4] * i2, t18[5] = e2[5] * i2, t18[6] = e2[6] * i2, t18[7] = e2[7] * i2, t18[8] = e2[8] * r2, t18[9] = e2[9] * r2, t18[10] = e2[10] * r2, t18[11] = e2[11] * r2, t18[12] = e2[12], t18[13] = e2[13], t18[14] = e2[14], t18[15] = e2[15], t18;
  }
  static rotate(t18, e2, n2, o2) {
    let i2 = o2[0], r2 = o2[1], a2 = o2[2], s2 = Math.sqrt(i2 * i2 + r2 * r2 + a2 * a2);
    if (s2 < GLM_EPSILON$1) return null;
    s2 = 1 / s2, i2 *= s2, r2 *= s2, a2 *= s2;
    const c2 = Math.sin(n2), l2 = Math.cos(n2), u2 = 1 - l2, p2 = e2[0], d2 = e2[1], m2 = e2[2], f2 = e2[3], h2 = e2[4], g2 = e2[5], _ = e2[6], $2 = e2[7], b2 = e2[8], y2 = e2[9], v2 = e2[10], w2 = e2[11], S2 = i2 * i2 * u2 + l2, T2 = r2 * i2 * u2 + a2 * c2, k2 = a2 * i2 * u2 - r2 * c2, x2 = i2 * r2 * u2 - a2 * c2, E = r2 * r2 * u2 + l2, O2 = a2 * r2 * u2 + i2 * c2, A2 = i2 * a2 * u2 + r2 * c2, C2 = r2 * a2 * u2 - i2 * c2, M = a2 * a2 * u2 + l2;
    return t18[0] = p2 * S2 + h2 * T2 + b2 * k2, t18[1] = d2 * S2 + g2 * T2 + y2 * k2, t18[2] = m2 * S2 + _ * T2 + v2 * k2, t18[3] = f2 * S2 + $2 * T2 + w2 * k2, t18[4] = p2 * x2 + h2 * E + b2 * O2, t18[5] = d2 * x2 + g2 * E + y2 * O2, t18[6] = m2 * x2 + _ * E + v2 * O2, t18[7] = f2 * x2 + $2 * E + w2 * O2, t18[8] = p2 * A2 + h2 * C2 + b2 * M, t18[9] = d2 * A2 + g2 * C2 + y2 * M, t18[10] = m2 * A2 + _ * C2 + v2 * M, t18[11] = f2 * A2 + $2 * C2 + w2 * M, e2 !== t18 && (t18[12] = e2[12], t18[13] = e2[13], t18[14] = e2[14], t18[15] = e2[15]), t18;
  }
  static rotateX(t18, e2, n2) {
    const o2 = Math.sin(n2), i2 = Math.cos(n2), r2 = e2[4], a2 = e2[5], s2 = e2[6], c2 = e2[7], l2 = e2[8], u2 = e2[9], p2 = e2[10], d2 = e2[11];
    return e2 !== t18 && (t18[0] = e2[0], t18[1] = e2[1], t18[2] = e2[2], t18[3] = e2[3], t18[12] = e2[12], t18[13] = e2[13], t18[14] = e2[14], t18[15] = e2[15]), t18[4] = r2 * i2 + l2 * o2, t18[5] = a2 * i2 + u2 * o2, t18[6] = s2 * i2 + p2 * o2, t18[7] = c2 * i2 + d2 * o2, t18[8] = l2 * i2 - r2 * o2, t18[9] = u2 * i2 - a2 * o2, t18[10] = p2 * i2 - s2 * o2, t18[11] = d2 * i2 - c2 * o2, t18;
  }
  static rotateY(t18, e2, n2) {
    const o2 = Math.sin(n2), i2 = Math.cos(n2), r2 = e2[0], a2 = e2[1], s2 = e2[2], c2 = e2[3], l2 = e2[8], u2 = e2[9], p2 = e2[10], d2 = e2[11];
    return e2 !== t18 && (t18[4] = e2[4], t18[5] = e2[5], t18[6] = e2[6], t18[7] = e2[7], t18[12] = e2[12], t18[13] = e2[13], t18[14] = e2[14], t18[15] = e2[15]), t18[0] = r2 * i2 - l2 * o2, t18[1] = a2 * i2 - u2 * o2, t18[2] = s2 * i2 - p2 * o2, t18[3] = c2 * i2 - d2 * o2, t18[8] = r2 * o2 + l2 * i2, t18[9] = a2 * o2 + u2 * i2, t18[10] = s2 * o2 + p2 * i2, t18[11] = c2 * o2 + d2 * i2, t18;
  }
  static rotateZ(t18, e2, n2) {
    const o2 = Math.sin(n2), i2 = Math.cos(n2), r2 = e2[0], a2 = e2[1], s2 = e2[2], c2 = e2[3], l2 = e2[4], u2 = e2[5], p2 = e2[6], d2 = e2[7];
    return e2 !== t18 && (t18[8] = e2[8], t18[9] = e2[9], t18[10] = e2[10], t18[11] = e2[11], t18[12] = e2[12], t18[13] = e2[13], t18[14] = e2[14], t18[15] = e2[15]), t18[0] = r2 * i2 + l2 * o2, t18[1] = a2 * i2 + u2 * o2, t18[2] = s2 * i2 + p2 * o2, t18[3] = c2 * i2 + d2 * o2, t18[4] = l2 * i2 - r2 * o2, t18[5] = u2 * i2 - a2 * o2, t18[6] = p2 * i2 - s2 * o2, t18[7] = d2 * i2 - c2 * o2, t18;
  }
  static fromTranslation(t18, e2) {
    return t18[0] = 1, t18[1] = 0, t18[2] = 0, t18[3] = 0, t18[4] = 0, t18[5] = 1, t18[6] = 0, t18[7] = 0, t18[8] = 0, t18[9] = 0, t18[10] = 1, t18[11] = 0, t18[12] = e2[0], t18[13] = e2[1], t18[14] = e2[2], t18[15] = 1, t18;
  }
  static fromScaling(t18, e2) {
    return t18[0] = e2[0], t18[1] = 0, t18[2] = 0, t18[3] = 0, t18[4] = 0, t18[5] = e2[1], t18[6] = 0, t18[7] = 0, t18[8] = 0, t18[9] = 0, t18[10] = e2[2], t18[11] = 0, t18[12] = 0, t18[13] = 0, t18[14] = 0, t18[15] = 1, t18;
  }
  static fromRotation(t18, e2, n2) {
    let o2 = n2[0], i2 = n2[1], r2 = n2[2], a2 = Math.sqrt(o2 * o2 + i2 * i2 + r2 * r2);
    if (a2 < GLM_EPSILON$1) return null;
    a2 = 1 / a2, o2 *= a2, i2 *= a2, r2 *= a2;
    const s2 = Math.sin(e2), c2 = Math.cos(e2), l2 = 1 - c2;
    return t18[0] = o2 * o2 * l2 + c2, t18[1] = i2 * o2 * l2 + r2 * s2, t18[2] = r2 * o2 * l2 - i2 * s2, t18[3] = 0, t18[4] = o2 * i2 * l2 - r2 * s2, t18[5] = i2 * i2 * l2 + c2, t18[6] = r2 * i2 * l2 + o2 * s2, t18[7] = 0, t18[8] = o2 * r2 * l2 + i2 * s2, t18[9] = i2 * r2 * l2 - o2 * s2, t18[10] = r2 * r2 * l2 + c2, t18[11] = 0, t18[12] = 0, t18[13] = 0, t18[14] = 0, t18[15] = 1, t18;
  }
  static fromXRotation(t18, e2) {
    const n2 = Math.sin(e2), o2 = Math.cos(e2);
    return t18[0] = 1, t18[1] = 0, t18[2] = 0, t18[3] = 0, t18[4] = 0, t18[5] = o2, t18[6] = n2, t18[7] = 0, t18[8] = 0, t18[9] = -n2, t18[10] = o2, t18[11] = 0, t18[12] = 0, t18[13] = 0, t18[14] = 0, t18[15] = 1, t18;
  }
  static fromYRotation(t18, e2) {
    const n2 = Math.sin(e2), o2 = Math.cos(e2);
    return t18[0] = o2, t18[1] = 0, t18[2] = -n2, t18[3] = 0, t18[4] = 0, t18[5] = 1, t18[6] = 0, t18[7] = 0, t18[8] = n2, t18[9] = 0, t18[10] = o2, t18[11] = 0, t18[12] = 0, t18[13] = 0, t18[14] = 0, t18[15] = 1, t18;
  }
  static fromZRotation(t18, e2) {
    const n2 = Math.sin(e2), o2 = Math.cos(e2);
    return t18[0] = o2, t18[1] = n2, t18[2] = 0, t18[3] = 0, t18[4] = -n2, t18[5] = o2, t18[6] = 0, t18[7] = 0, t18[8] = 0, t18[9] = 0, t18[10] = 1, t18[11] = 0, t18[12] = 0, t18[13] = 0, t18[14] = 0, t18[15] = 1, t18;
  }
  static fromRotationTranslation(t18, e2, n2) {
    const o2 = e2[0], i2 = e2[1], r2 = e2[2], a2 = e2[3], s2 = o2 + o2, c2 = i2 + i2, l2 = r2 + r2, u2 = o2 * s2, p2 = o2 * c2, d2 = o2 * l2, m2 = i2 * c2, f2 = i2 * l2, h2 = r2 * l2, g2 = a2 * s2, _ = a2 * c2, $2 = a2 * l2;
    return t18[0] = 1 - (m2 + h2), t18[1] = p2 + $2, t18[2] = d2 - _, t18[3] = 0, t18[4] = p2 - $2, t18[5] = 1 - (u2 + h2), t18[6] = f2 + g2, t18[7] = 0, t18[8] = d2 + _, t18[9] = f2 - g2, t18[10] = 1 - (u2 + m2), t18[11] = 0, t18[12] = n2[0], t18[13] = n2[1], t18[14] = n2[2], t18[15] = 1, t18;
  }
  static fromQuat2(e2, n2) {
    const o2 = -n2[0], i2 = -n2[1], r2 = -n2[2], a2 = n2[3], s2 = n2[4], c2 = n2[5], l2 = n2[6], u2 = n2[7], p2 = o2 * o2 + i2 * i2 + r2 * r2 + a2 * a2;
    return p2 > 0 ? (t3.#b[0] = 2 * (s2 * a2 + u2 * o2 + c2 * r2 - l2 * i2) / p2, t3.#b[1] = 2 * (c2 * a2 + u2 * i2 + l2 * o2 - s2 * r2) / p2, t3.#b[2] = 2 * (l2 * a2 + u2 * r2 + s2 * i2 - c2 * o2) / p2) : (t3.#b[0] = 2 * (s2 * a2 + u2 * o2 + c2 * r2 - l2 * i2), t3.#b[1] = 2 * (c2 * a2 + u2 * i2 + l2 * o2 - s2 * r2), t3.#b[2] = 2 * (l2 * a2 + u2 * r2 + s2 * i2 - c2 * o2)), t3.fromRotationTranslation(e2, n2, t3.#b), e2;
  }
  static normalFromMat4(t18, e2) {
    const n2 = e2[0], o2 = e2[1], i2 = e2[2], r2 = e2[3], a2 = e2[4], s2 = e2[5], c2 = e2[6], l2 = e2[7], u2 = e2[8], p2 = e2[9], d2 = e2[10], m2 = e2[11], f2 = e2[12], h2 = e2[13], g2 = e2[14], _ = e2[15], $2 = n2 * s2 - o2 * a2, b2 = n2 * c2 - i2 * a2, y2 = n2 * l2 - r2 * a2, v2 = o2 * c2 - i2 * s2, w2 = o2 * l2 - r2 * s2, S2 = i2 * l2 - r2 * c2, T2 = u2 * h2 - p2 * f2, k2 = u2 * g2 - d2 * f2, x2 = u2 * _ - m2 * f2, E = p2 * g2 - d2 * h2, O2 = p2 * _ - m2 * h2, A2 = d2 * _ - m2 * g2;
    let C2 = $2 * A2 - b2 * O2 + y2 * E + v2 * x2 - w2 * k2 + S2 * T2;
    return C2 ? (C2 = 1 / C2, t18[0] = (s2 * A2 - c2 * O2 + l2 * E) * C2, t18[1] = (c2 * x2 - a2 * A2 - l2 * k2) * C2, t18[2] = (a2 * O2 - s2 * x2 + l2 * T2) * C2, t18[3] = 0, t18[4] = (i2 * O2 - o2 * A2 - r2 * E) * C2, t18[5] = (n2 * A2 - i2 * x2 + r2 * k2) * C2, t18[6] = (o2 * x2 - n2 * O2 - r2 * T2) * C2, t18[7] = 0, t18[8] = (h2 * S2 - g2 * w2 + _ * v2) * C2, t18[9] = (g2 * y2 - f2 * S2 - _ * b2) * C2, t18[10] = (f2 * w2 - h2 * y2 + _ * $2) * C2, t18[11] = 0, t18[12] = 0, t18[13] = 0, t18[14] = 0, t18[15] = 1, t18) : null;
  }
  static normalFromMat4Fast(t18, e2) {
    const n2 = e2[0], o2 = e2[1], i2 = e2[2], r2 = e2[4], a2 = e2[5], s2 = e2[6], c2 = e2[8], l2 = e2[9], u2 = e2[10];
    return t18[0] = a2 * u2 - u2 * l2, t18[1] = s2 * c2 - c2 * u2, t18[2] = r2 * l2 - l2 * c2, t18[3] = 0, t18[4] = l2 * i2 - u2 * o2, t18[5] = u2 * n2 - c2 * i2, t18[6] = c2 * o2 - l2 * n2, t18[7] = 0, t18[8] = o2 * s2 - i2 * a2, t18[9] = i2 * r2 - n2 * s2, t18[10] = n2 * a2 - o2 * r2, t18[11] = 0, t18[12] = 0, t18[13] = 0, t18[14] = 0, t18[15] = 1, t18;
  }
  static getTranslation(t18, e2) {
    return t18[0] = e2[12], t18[1] = e2[13], t18[2] = e2[14], t18;
  }
  static getScaling(t18, e2) {
    const n2 = e2[0], o2 = e2[1], i2 = e2[2], r2 = e2[4], a2 = e2[5], s2 = e2[6], c2 = e2[8], l2 = e2[9], u2 = e2[10];
    return t18[0] = Math.sqrt(n2 * n2 + o2 * o2 + i2 * i2), t18[1] = Math.sqrt(r2 * r2 + a2 * a2 + s2 * s2), t18[2] = Math.sqrt(c2 * c2 + l2 * l2 + u2 * u2), t18;
  }
  static getRotation(e2, n2) {
    t3.getScaling(t3.#b, n2);
    const o2 = 1 / t3.#b[0], i2 = 1 / t3.#b[1], r2 = 1 / t3.#b[2], a2 = n2[0] * o2, s2 = n2[1] * i2, c2 = n2[2] * r2, l2 = n2[4] * o2, u2 = n2[5] * i2, p2 = n2[6] * r2, d2 = n2[8] * o2, m2 = n2[9] * i2, f2 = n2[10] * r2, h2 = a2 + u2 + f2;
    let g2 = 0;
    return h2 > 0 ? (g2 = 2 * Math.sqrt(h2 + 1), e2[3] = 0.25 * g2, e2[0] = (p2 - m2) / g2, e2[1] = (d2 - c2) / g2, e2[2] = (s2 - l2) / g2) : a2 > u2 && a2 > f2 ? (g2 = 2 * Math.sqrt(1 + a2 - u2 - f2), e2[3] = (p2 - m2) / g2, e2[0] = 0.25 * g2, e2[1] = (s2 + l2) / g2, e2[2] = (d2 + c2) / g2) : u2 > f2 ? (g2 = 2 * Math.sqrt(1 + u2 - a2 - f2), e2[3] = (d2 - c2) / g2, e2[0] = (s2 + l2) / g2, e2[1] = 0.25 * g2, e2[2] = (p2 + m2) / g2) : (g2 = 2 * Math.sqrt(1 + f2 - a2 - u2), e2[3] = (s2 - l2) / g2, e2[0] = (d2 + c2) / g2, e2[1] = (p2 + m2) / g2, e2[2] = 0.25 * g2), e2;
  }
  static decompose(t18, e2, n2, o2) {
    e2[0] = o2[12], e2[1] = o2[13], e2[2] = o2[14];
    const i2 = o2[0], r2 = o2[1], a2 = o2[2], s2 = o2[4], c2 = o2[5], l2 = o2[6], u2 = o2[8], p2 = o2[9], d2 = o2[10];
    n2[0] = Math.sqrt(i2 * i2 + r2 * r2 + a2 * a2), n2[1] = Math.sqrt(s2 * s2 + c2 * c2 + l2 * l2), n2[2] = Math.sqrt(u2 * u2 + p2 * p2 + d2 * d2);
    const m2 = 1 / n2[0], f2 = 1 / n2[1], h2 = 1 / n2[2], g2 = i2 * m2, _ = r2 * f2, $2 = a2 * h2, b2 = s2 * m2, y2 = c2 * f2, v2 = l2 * h2, w2 = u2 * m2, S2 = p2 * f2, T2 = d2 * h2, k2 = g2 + y2 + T2;
    let x2 = 0;
    return k2 > 0 ? (x2 = 2 * Math.sqrt(k2 + 1), t18[3] = 0.25 * x2, t18[0] = (v2 - S2) / x2, t18[1] = (w2 - $2) / x2, t18[2] = (_ - b2) / x2) : g2 > y2 && g2 > T2 ? (x2 = 2 * Math.sqrt(1 + g2 - y2 - T2), t18[3] = (v2 - S2) / x2, t18[0] = 0.25 * x2, t18[1] = (_ + b2) / x2, t18[2] = (w2 + $2) / x2) : y2 > T2 ? (x2 = 2 * Math.sqrt(1 + y2 - g2 - T2), t18[3] = (w2 - $2) / x2, t18[0] = (_ + b2) / x2, t18[1] = 0.25 * x2, t18[2] = (v2 + S2) / x2) : (x2 = 2 * Math.sqrt(1 + T2 - g2 - y2), t18[3] = (_ - b2) / x2, t18[0] = (w2 + $2) / x2, t18[1] = (v2 + S2) / x2, t18[2] = 0.25 * x2), t18;
  }
  static fromRotationTranslationScale(t18, e2, n2, o2) {
    const i2 = e2[0], r2 = e2[1], a2 = e2[2], s2 = e2[3], c2 = i2 + i2, l2 = r2 + r2, u2 = a2 + a2, p2 = i2 * c2, d2 = i2 * l2, m2 = i2 * u2, f2 = r2 * l2, h2 = r2 * u2, g2 = a2 * u2, _ = s2 * c2, $2 = s2 * l2, b2 = s2 * u2, y2 = o2[0], v2 = o2[1], w2 = o2[2];
    return t18[0] = (1 - (f2 + g2)) * y2, t18[1] = (d2 + b2) * y2, t18[2] = (m2 - $2) * y2, t18[3] = 0, t18[4] = (d2 - b2) * v2, t18[5] = (1 - (p2 + g2)) * v2, t18[6] = (h2 + _) * v2, t18[7] = 0, t18[8] = (m2 + $2) * w2, t18[9] = (h2 - _) * w2, t18[10] = (1 - (p2 + f2)) * w2, t18[11] = 0, t18[12] = n2[0], t18[13] = n2[1], t18[14] = n2[2], t18[15] = 1, t18;
  }
  static fromRotationTranslationScaleOrigin(t18, e2, n2, o2, i2) {
    const r2 = e2[0], a2 = e2[1], s2 = e2[2], c2 = e2[3], l2 = r2 + r2, u2 = a2 + a2, p2 = s2 + s2, d2 = r2 * l2, m2 = r2 * u2, f2 = r2 * p2, h2 = a2 * u2, g2 = a2 * p2, _ = s2 * p2, $2 = c2 * l2, b2 = c2 * u2, y2 = c2 * p2, v2 = o2[0], w2 = o2[1], S2 = o2[2], T2 = i2[0], k2 = i2[1], x2 = i2[2], E = (1 - (h2 + _)) * v2, O2 = (m2 + y2) * v2, A2 = (f2 - b2) * v2, C2 = (m2 - y2) * w2, M = (1 - (d2 + _)) * w2, I2 = (g2 + $2) * w2, N2 = (f2 + b2) * S2, P2 = (g2 - $2) * S2, D2 = (1 - (d2 + h2)) * S2;
    return t18[0] = E, t18[1] = O2, t18[2] = A2, t18[3] = 0, t18[4] = C2, t18[5] = M, t18[6] = I2, t18[7] = 0, t18[8] = N2, t18[9] = P2, t18[10] = D2, t18[11] = 0, t18[12] = n2[0] + T2 - (E * T2 + C2 * k2 + N2 * x2), t18[13] = n2[1] + k2 - (O2 * T2 + M * k2 + P2 * x2), t18[14] = n2[2] + x2 - (A2 * T2 + I2 * k2 + D2 * x2), t18[15] = 1, t18;
  }
  static fromQuat(t18, e2) {
    const n2 = e2[0], o2 = e2[1], i2 = e2[2], r2 = e2[3], a2 = n2 + n2, s2 = o2 + o2, c2 = i2 + i2, l2 = n2 * a2, u2 = o2 * a2, p2 = o2 * s2, d2 = i2 * a2, m2 = i2 * s2, f2 = i2 * c2, h2 = r2 * a2, g2 = r2 * s2, _ = r2 * c2;
    return t18[0] = 1 - p2 - f2, t18[1] = u2 + _, t18[2] = d2 - g2, t18[3] = 0, t18[4] = u2 - _, t18[5] = 1 - l2 - f2, t18[6] = m2 + h2, t18[7] = 0, t18[8] = d2 + g2, t18[9] = m2 - h2, t18[10] = 1 - l2 - p2, t18[11] = 0, t18[12] = 0, t18[13] = 0, t18[14] = 0, t18[15] = 1, t18;
  }
  static frustumNO(t18, e2, n2, o2, i2, r2, a2 = 1 / 0) {
    const s2 = 1 / (n2 - e2), c2 = 1 / (i2 - o2);
    if (t18[0] = 2 * r2 * s2, t18[1] = 0, t18[2] = 0, t18[3] = 0, t18[4] = 0, t18[5] = 2 * r2 * c2, t18[6] = 0, t18[7] = 0, t18[8] = (n2 + e2) * s2, t18[9] = (i2 + o2) * c2, t18[11] = -1, t18[12] = 0, t18[13] = 0, t18[15] = 0, null != a2 && a2 !== 1 / 0) {
      const e3 = 1 / (r2 - a2);
      t18[10] = (a2 + r2) * e3, t18[14] = 2 * a2 * r2 * e3;
    } else t18[10] = -1, t18[14] = -2 * r2;
    return t18;
  }
  static frustum(t18, e2, n2, o2, i2, r2, a2 = 1 / 0) {
    return t18;
  }
  static frustumZO(t18, e2, n2, o2, i2, r2, a2 = 1 / 0) {
    const s2 = 1 / (n2 - e2), c2 = 1 / (i2 - o2);
    if (t18[0] = 2 * r2 * s2, t18[1] = 0, t18[2] = 0, t18[3] = 0, t18[4] = 0, t18[5] = 2 * r2 * c2, t18[6] = 0, t18[7] = 0, t18[8] = (n2 + e2) * s2, t18[9] = (i2 + o2) * c2, t18[11] = -1, t18[12] = 0, t18[13] = 0, t18[15] = 0, null != a2 && a2 !== 1 / 0) {
      const e3 = 1 / (r2 - a2);
      t18[10] = a2 * e3, t18[14] = a2 * r2 * e3;
    } else t18[10] = -1, t18[14] = -r2;
    return t18;
  }
  static perspectiveNO(t18, e2, n2, o2, i2 = 1 / 0) {
    const r2 = 1 / Math.tan(e2 / 2);
    if (t18[0] = r2 / n2, t18[1] = 0, t18[2] = 0, t18[3] = 0, t18[4] = 0, t18[5] = r2, t18[6] = 0, t18[7] = 0, t18[8] = 0, t18[9] = 0, t18[11] = -1, t18[12] = 0, t18[13] = 0, t18[15] = 0, null != i2 && i2 !== 1 / 0) {
      const e3 = 1 / (o2 - i2);
      t18[10] = (i2 + o2) * e3, t18[14] = 2 * i2 * o2 * e3;
    } else t18[10] = -1, t18[14] = -2 * o2;
    return t18;
  }
  static perspective(t18, e2, n2, o2, i2 = 1 / 0) {
    return t18;
  }
  static perspectiveZO(t18, e2, n2, o2, i2 = 1 / 0) {
    const r2 = 1 / Math.tan(e2 / 2);
    if (t18[0] = r2 / n2, t18[1] = 0, t18[2] = 0, t18[3] = 0, t18[4] = 0, t18[5] = r2, t18[6] = 0, t18[7] = 0, t18[8] = 0, t18[9] = 0, t18[11] = -1, t18[12] = 0, t18[13] = 0, t18[15] = 0, null != i2 && i2 !== 1 / 0) {
      const e3 = 1 / (o2 - i2);
      t18[10] = i2 * e3, t18[14] = i2 * o2 * e3;
    } else t18[10] = -1, t18[14] = -o2;
    return t18;
  }
  static perspectiveFromFieldOfView(t18, e2, n2, o2) {
    const i2 = Math.tan(e2.upDegrees * Math.PI / 180), r2 = Math.tan(e2.downDegrees * Math.PI / 180), a2 = Math.tan(e2.leftDegrees * Math.PI / 180), s2 = Math.tan(e2.rightDegrees * Math.PI / 180), c2 = 2 / (a2 + s2), l2 = 2 / (i2 + r2);
    return t18[0] = c2, t18[1] = 0, t18[2] = 0, t18[3] = 0, t18[4] = 0, t18[5] = l2, t18[6] = 0, t18[7] = 0, t18[8] = -(a2 - s2) * c2 * 0.5, t18[9] = (i2 - r2) * l2 * 0.5, t18[10] = o2 / (n2 - o2), t18[11] = -1, t18[12] = 0, t18[13] = 0, t18[14] = o2 * n2 / (n2 - o2), t18[15] = 0, t18;
  }
  static orthoNO(t18, e2, n2, o2, i2, r2, a2) {
    const s2 = 1 / (e2 - n2), c2 = 1 / (o2 - i2), l2 = 1 / (r2 - a2);
    return t18[0] = -2 * s2, t18[1] = 0, t18[2] = 0, t18[3] = 0, t18[4] = 0, t18[5] = -2 * c2, t18[6] = 0, t18[7] = 0, t18[8] = 0, t18[9] = 0, t18[10] = 2 * l2, t18[11] = 0, t18[12] = (e2 + n2) * s2, t18[13] = (i2 + o2) * c2, t18[14] = (a2 + r2) * l2, t18[15] = 1, t18;
  }
  static ortho(t18, e2, n2, o2, i2, r2, a2) {
    return t18;
  }
  static orthoZO(t18, e2, n2, o2, i2, r2, a2) {
    const s2 = 1 / (e2 - n2), c2 = 1 / (o2 - i2), l2 = 1 / (r2 - a2);
    return t18[0] = -2 * s2, t18[1] = 0, t18[2] = 0, t18[3] = 0, t18[4] = 0, t18[5] = -2 * c2, t18[6] = 0, t18[7] = 0, t18[8] = 0, t18[9] = 0, t18[10] = l2, t18[11] = 0, t18[12] = (e2 + n2) * s2, t18[13] = (i2 + o2) * c2, t18[14] = r2 * l2, t18[15] = 1, t18;
  }
  static lookAt(e2, n2, o2, i2) {
    const r2 = n2[0], a2 = n2[1], s2 = n2[2], c2 = i2[0], l2 = i2[1], u2 = i2[2], p2 = o2[0], d2 = o2[1], m2 = o2[2];
    if (Math.abs(r2 - p2) < GLM_EPSILON$1 && Math.abs(a2 - d2) < GLM_EPSILON$1 && Math.abs(s2 - m2) < GLM_EPSILON$1) return t3.identity(e2);
    let f2 = r2 - p2, h2 = a2 - d2, g2 = s2 - m2, _ = 1 / Math.sqrt(f2 * f2 + h2 * h2 + g2 * g2);
    f2 *= _, h2 *= _, g2 *= _;
    let $2 = l2 * g2 - u2 * h2, b2 = u2 * f2 - c2 * g2, y2 = c2 * h2 - l2 * f2;
    _ = Math.sqrt($2 * $2 + b2 * b2 + y2 * y2), _ ? (_ = 1 / _, $2 *= _, b2 *= _, y2 *= _) : ($2 = 0, b2 = 0, y2 = 0);
    let v2 = h2 * y2 - g2 * b2, w2 = g2 * $2 - f2 * y2, S2 = f2 * b2 - h2 * $2;
    return _ = Math.sqrt(v2 * v2 + w2 * w2 + S2 * S2), _ ? (_ = 1 / _, v2 *= _, w2 *= _, S2 *= _) : (v2 = 0, w2 = 0, S2 = 0), e2[0] = $2, e2[1] = v2, e2[2] = f2, e2[3] = 0, e2[4] = b2, e2[5] = w2, e2[6] = h2, e2[7] = 0, e2[8] = y2, e2[9] = S2, e2[10] = g2, e2[11] = 0, e2[12] = -($2 * r2 + b2 * a2 + y2 * s2), e2[13] = -(v2 * r2 + w2 * a2 + S2 * s2), e2[14] = -(f2 * r2 + h2 * a2 + g2 * s2), e2[15] = 1, e2;
  }
  static targetTo(t18, e2, n2, o2) {
    const i2 = e2[0], r2 = e2[1], a2 = e2[2], s2 = o2[0], c2 = o2[1], l2 = o2[2];
    let u2 = i2 - n2[0], p2 = r2 - n2[1], d2 = a2 - n2[2], m2 = u2 * u2 + p2 * p2 + d2 * d2;
    m2 > 0 && (m2 = 1 / Math.sqrt(m2), u2 *= m2, p2 *= m2, d2 *= m2);
    let f2 = c2 * d2 - l2 * p2, h2 = l2 * u2 - s2 * d2, g2 = s2 * p2 - c2 * u2;
    return m2 = f2 * f2 + h2 * h2 + g2 * g2, m2 > 0 && (m2 = 1 / Math.sqrt(m2), f2 *= m2, h2 *= m2, g2 *= m2), t18[0] = f2, t18[1] = h2, t18[2] = g2, t18[3] = 0, t18[4] = p2 * g2 - d2 * h2, t18[5] = d2 * f2 - u2 * g2, t18[6] = u2 * h2 - p2 * f2, t18[7] = 0, t18[8] = u2, t18[9] = p2, t18[10] = d2, t18[11] = 0, t18[12] = i2, t18[13] = r2, t18[14] = a2, t18[15] = 1, t18;
  }
  static frob(t18) {
    return Math.sqrt(t18[0] * t18[0] + t18[1] * t18[1] + t18[2] * t18[2] + t18[3] * t18[3] + t18[4] * t18[4] + t18[5] * t18[5] + t18[6] * t18[6] + t18[7] * t18[7] + t18[8] * t18[8] + t18[9] * t18[9] + t18[10] * t18[10] + t18[11] * t18[11] + t18[12] * t18[12] + t18[13] * t18[13] + t18[14] * t18[14] + t18[15] * t18[15]);
  }
  static add(t18, e2, n2) {
    return t18[0] = e2[0] + n2[0], t18[1] = e2[1] + n2[1], t18[2] = e2[2] + n2[2], t18[3] = e2[3] + n2[3], t18[4] = e2[4] + n2[4], t18[5] = e2[5] + n2[5], t18[6] = e2[6] + n2[6], t18[7] = e2[7] + n2[7], t18[8] = e2[8] + n2[8], t18[9] = e2[9] + n2[9], t18[10] = e2[10] + n2[10], t18[11] = e2[11] + n2[11], t18[12] = e2[12] + n2[12], t18[13] = e2[13] + n2[13], t18[14] = e2[14] + n2[14], t18[15] = e2[15] + n2[15], t18;
  }
  static subtract(t18, e2, n2) {
    return t18[0] = e2[0] - n2[0], t18[1] = e2[1] - n2[1], t18[2] = e2[2] - n2[2], t18[3] = e2[3] - n2[3], t18[4] = e2[4] - n2[4], t18[5] = e2[5] - n2[5], t18[6] = e2[6] - n2[6], t18[7] = e2[7] - n2[7], t18[8] = e2[8] - n2[8], t18[9] = e2[9] - n2[9], t18[10] = e2[10] - n2[10], t18[11] = e2[11] - n2[11], t18[12] = e2[12] - n2[12], t18[13] = e2[13] - n2[13], t18[14] = e2[14] - n2[14], t18[15] = e2[15] - n2[15], t18;
  }
  static sub(t18, e2, n2) {
    return t18;
  }
  static multiplyScalar(t18, e2, n2) {
    return t18[0] = e2[0] * n2, t18[1] = e2[1] * n2, t18[2] = e2[2] * n2, t18[3] = e2[3] * n2, t18[4] = e2[4] * n2, t18[5] = e2[5] * n2, t18[6] = e2[6] * n2, t18[7] = e2[7] * n2, t18[8] = e2[8] * n2, t18[9] = e2[9] * n2, t18[10] = e2[10] * n2, t18[11] = e2[11] * n2, t18[12] = e2[12] * n2, t18[13] = e2[13] * n2, t18[14] = e2[14] * n2, t18[15] = e2[15] * n2, t18;
  }
  static multiplyScalarAndAdd(t18, e2, n2, o2) {
    return t18[0] = e2[0] + n2[0] * o2, t18[1] = e2[1] + n2[1] * o2, t18[2] = e2[2] + n2[2] * o2, t18[3] = e2[3] + n2[3] * o2, t18[4] = e2[4] + n2[4] * o2, t18[5] = e2[5] + n2[5] * o2, t18[6] = e2[6] + n2[6] * o2, t18[7] = e2[7] + n2[7] * o2, t18[8] = e2[8] + n2[8] * o2, t18[9] = e2[9] + n2[9] * o2, t18[10] = e2[10] + n2[10] * o2, t18[11] = e2[11] + n2[11] * o2, t18[12] = e2[12] + n2[12] * o2, t18[13] = e2[13] + n2[13] * o2, t18[14] = e2[14] + n2[14] * o2, t18[15] = e2[15] + n2[15] * o2, t18;
  }
  static exactEquals(t18, e2) {
    return t18[0] === e2[0] && t18[1] === e2[1] && t18[2] === e2[2] && t18[3] === e2[3] && t18[4] === e2[4] && t18[5] === e2[5] && t18[6] === e2[6] && t18[7] === e2[7] && t18[8] === e2[8] && t18[9] === e2[9] && t18[10] === e2[10] && t18[11] === e2[11] && t18[12] === e2[12] && t18[13] === e2[13] && t18[14] === e2[14] && t18[15] === e2[15];
  }
  static equals(t18, e2) {
    const n2 = t18[0], o2 = t18[1], i2 = t18[2], r2 = t18[3], a2 = t18[4], s2 = t18[5], c2 = t18[6], l2 = t18[7], u2 = t18[8], p2 = t18[9], d2 = t18[10], m2 = t18[11], f2 = t18[12], h2 = t18[13], g2 = t18[14], _ = t18[15], $2 = e2[0], b2 = e2[1], y2 = e2[2], v2 = e2[3], w2 = e2[4], S2 = e2[5], T2 = e2[6], k2 = e2[7], x2 = e2[8], E = e2[9], O2 = e2[10], A2 = e2[11], C2 = e2[12], M = e2[13], I2 = e2[14], N2 = e2[15];
    return Math.abs(n2 - $2) <= GLM_EPSILON$1 * Math.max(1, Math.abs(n2), Math.abs($2)) && Math.abs(o2 - b2) <= GLM_EPSILON$1 * Math.max(1, Math.abs(o2), Math.abs(b2)) && Math.abs(i2 - y2) <= GLM_EPSILON$1 * Math.max(1, Math.abs(i2), Math.abs(y2)) && Math.abs(r2 - v2) <= GLM_EPSILON$1 * Math.max(1, Math.abs(r2), Math.abs(v2)) && Math.abs(a2 - w2) <= GLM_EPSILON$1 * Math.max(1, Math.abs(a2), Math.abs(w2)) && Math.abs(s2 - S2) <= GLM_EPSILON$1 * Math.max(1, Math.abs(s2), Math.abs(S2)) && Math.abs(c2 - T2) <= GLM_EPSILON$1 * Math.max(1, Math.abs(c2), Math.abs(T2)) && Math.abs(l2 - k2) <= GLM_EPSILON$1 * Math.max(1, Math.abs(l2), Math.abs(k2)) && Math.abs(u2 - x2) <= GLM_EPSILON$1 * Math.max(1, Math.abs(u2), Math.abs(x2)) && Math.abs(p2 - E) <= GLM_EPSILON$1 * Math.max(1, Math.abs(p2), Math.abs(E)) && Math.abs(d2 - O2) <= GLM_EPSILON$1 * Math.max(1, Math.abs(d2), Math.abs(O2)) && Math.abs(m2 - A2) <= GLM_EPSILON$1 * Math.max(1, Math.abs(m2), Math.abs(A2)) && Math.abs(f2 - C2) <= GLM_EPSILON$1 * Math.max(1, Math.abs(f2), Math.abs(C2)) && Math.abs(h2 - M) <= GLM_EPSILON$1 * Math.max(1, Math.abs(h2), Math.abs(M)) && Math.abs(g2 - I2) <= GLM_EPSILON$1 * Math.max(1, Math.abs(g2), Math.abs(I2)) && Math.abs(_ - N2) <= GLM_EPSILON$1 * Math.max(1, Math.abs(_), Math.abs(N2));
  }
  static str(t18) {
    return `Mat4(${t18.join(", ")})`;
  }
};
Mat4$1.prototype.mul = Mat4$1.prototype.multiply, Mat4$1.sub = Mat4$1.subtract, Mat4$1.mul = Mat4$1.multiply, Mat4$1.frustum = Mat4$1.frustumNO, Mat4$1.perspective = Mat4$1.perspectiveNO, Mat4$1.ortho = Mat4$1.orthoNO;
var Vec3$1 = class t4 extends Float32Array {
  constructor(...t18) {
    switch (t18.length) {
      case 3:
        super(t18);
        break;
      case 2:
        super(t18[0], t18[1], 3);
        break;
      case 1: {
        const e2 = t18[0];
        "number" == typeof e2 ? super([e2, e2, e2]) : super(e2, 0, 3);
        break;
      }
      default:
        super(3);
    }
  }
  get x() {
    return this[0];
  }
  set x(t18) {
    this[0] = t18;
  }
  get y() {
    return this[1];
  }
  set y(t18) {
    this[1] = t18;
  }
  get z() {
    return this[2];
  }
  set z(t18) {
    this[2] = t18;
  }
  get r() {
    return this[0];
  }
  set r(t18) {
    this[0] = t18;
  }
  get g() {
    return this[1];
  }
  set g(t18) {
    this[1] = t18;
  }
  get b() {
    return this[2];
  }
  set b(t18) {
    this[2] = t18;
  }
  get magnitude() {
    const t18 = this[0], e2 = this[1], n2 = this[2];
    return Math.sqrt(t18 * t18 + e2 * e2 + n2 * n2);
  }
  get mag() {
    return this.magnitude;
  }
  get squaredMagnitude() {
    const t18 = this[0], e2 = this[1], n2 = this[2];
    return t18 * t18 + e2 * e2 + n2 * n2;
  }
  get sqrMag() {
    return this.squaredMagnitude;
  }
  get str() {
    return t4.str(this);
  }
  copy(t18) {
    return this.set(t18), this;
  }
  add(t18) {
    return this[0] += t18[0], this[1] += t18[1], this[2] += t18[2], this;
  }
  subtract(t18) {
    return this[0] -= t18[0], this[1] -= t18[1], this[2] -= t18[2], this;
  }
  sub(t18) {
    return this;
  }
  multiply(t18) {
    return this[0] *= t18[0], this[1] *= t18[1], this[2] *= t18[2], this;
  }
  mul(t18) {
    return this;
  }
  divide(t18) {
    return this[0] /= t18[0], this[1] /= t18[1], this[2] /= t18[2], this;
  }
  div(t18) {
    return this;
  }
  scale(t18) {
    return this[0] *= t18, this[1] *= t18, this[2] *= t18, this;
  }
  scaleAndAdd(t18, e2) {
    return this[0] += t18[0] * e2, this[1] += t18[1] * e2, this[2] += t18[2] * e2, this;
  }
  distance(e2) {
    return t4.distance(this, e2);
  }
  dist(t18) {
    return 0;
  }
  squaredDistance(e2) {
    return t4.squaredDistance(this, e2);
  }
  sqrDist(t18) {
    return 0;
  }
  negate() {
    return this[0] *= -1, this[1] *= -1, this[2] *= -1, this;
  }
  invert() {
    return this[0] = 1 / this[0], this[1] = 1 / this[1], this[2] = 1 / this[2], this;
  }
  abs() {
    return this[0] = Math.abs(this[0]), this[1] = Math.abs(this[1]), this[2] = Math.abs(this[2]), this;
  }
  dot(t18) {
    return this[0] * t18[0] + this[1] * t18[1] + this[2] * t18[2];
  }
  normalize() {
    return t4.normalize(this, this);
  }
  static get BYTE_LENGTH() {
    return 3 * Float32Array.BYTES_PER_ELEMENT;
  }
  static create() {
    return new t4();
  }
  static clone(e2) {
    return new t4(e2);
  }
  static magnitude(t18) {
    const e2 = t18[0], n2 = t18[1], o2 = t18[2];
    return Math.sqrt(e2 * e2 + n2 * n2 + o2 * o2);
  }
  static mag(t18) {
    return 0;
  }
  static length(t18) {
    return 0;
  }
  static len(t18) {
    return 0;
  }
  static fromValues(e2, n2, o2) {
    return new t4(e2, n2, o2);
  }
  static copy(t18, e2) {
    return t18[0] = e2[0], t18[1] = e2[1], t18[2] = e2[2], t18;
  }
  static set(t18, e2, n2, o2) {
    return t18[0] = e2, t18[1] = n2, t18[2] = o2, t18;
  }
  static add(t18, e2, n2) {
    return t18[0] = e2[0] + n2[0], t18[1] = e2[1] + n2[1], t18[2] = e2[2] + n2[2], t18;
  }
  static subtract(t18, e2, n2) {
    return t18[0] = e2[0] - n2[0], t18[1] = e2[1] - n2[1], t18[2] = e2[2] - n2[2], t18;
  }
  static sub(t18, e2, n2) {
    return [0, 0, 0];
  }
  static multiply(t18, e2, n2) {
    return t18[0] = e2[0] * n2[0], t18[1] = e2[1] * n2[1], t18[2] = e2[2] * n2[2], t18;
  }
  static mul(t18, e2, n2) {
    return [0, 0, 0];
  }
  static divide(t18, e2, n2) {
    return t18[0] = e2[0] / n2[0], t18[1] = e2[1] / n2[1], t18[2] = e2[2] / n2[2], t18;
  }
  static div(t18, e2, n2) {
    return [0, 0, 0];
  }
  static ceil(t18, e2) {
    return t18[0] = Math.ceil(e2[0]), t18[1] = Math.ceil(e2[1]), t18[2] = Math.ceil(e2[2]), t18;
  }
  static floor(t18, e2) {
    return t18[0] = Math.floor(e2[0]), t18[1] = Math.floor(e2[1]), t18[2] = Math.floor(e2[2]), t18;
  }
  static min(t18, e2, n2) {
    return t18[0] = Math.min(e2[0], n2[0]), t18[1] = Math.min(e2[1], n2[1]), t18[2] = Math.min(e2[2], n2[2]), t18;
  }
  static max(t18, e2, n2) {
    return t18[0] = Math.max(e2[0], n2[0]), t18[1] = Math.max(e2[1], n2[1]), t18[2] = Math.max(e2[2], n2[2]), t18;
  }
  static scale(t18, e2, n2) {
    return t18[0] = e2[0] * n2, t18[1] = e2[1] * n2, t18[2] = e2[2] * n2, t18;
  }
  static scaleAndAdd(t18, e2, n2, o2) {
    return t18[0] = e2[0] + n2[0] * o2, t18[1] = e2[1] + n2[1] * o2, t18[2] = e2[2] + n2[2] * o2, t18;
  }
  static distance(t18, e2) {
    const n2 = e2[0] - t18[0], o2 = e2[1] - t18[1], i2 = e2[2] - t18[2];
    return Math.sqrt(n2 * n2 + o2 * o2 + i2 * i2);
  }
  static dist(t18, e2) {
    return 0;
  }
  static squaredDistance(t18, e2) {
    const n2 = e2[0] - t18[0], o2 = e2[1] - t18[1], i2 = e2[2] - t18[2];
    return n2 * n2 + o2 * o2 + i2 * i2;
  }
  static sqrDist(t18, e2) {
    return 0;
  }
  static squaredLength(t18) {
    const e2 = t18[0], n2 = t18[1], o2 = t18[2];
    return e2 * e2 + n2 * n2 + o2 * o2;
  }
  static sqrLen(t18, e2) {
    return 0;
  }
  static negate(t18, e2) {
    return t18[0] = -e2[0], t18[1] = -e2[1], t18[2] = -e2[2], t18;
  }
  static inverse(t18, e2) {
    return t18[0] = 1 / e2[0], t18[1] = 1 / e2[1], t18[2] = 1 / e2[2], t18;
  }
  static abs(t18, e2) {
    return t18[0] = Math.abs(e2[0]), t18[1] = Math.abs(e2[1]), t18[2] = Math.abs(e2[2]), t18;
  }
  static normalize(t18, e2) {
    const n2 = e2[0], o2 = e2[1], i2 = e2[2];
    let r2 = n2 * n2 + o2 * o2 + i2 * i2;
    return r2 > 0 && (r2 = 1 / Math.sqrt(r2)), t18[0] = e2[0] * r2, t18[1] = e2[1] * r2, t18[2] = e2[2] * r2, t18;
  }
  static dot(t18, e2) {
    return t18[0] * e2[0] + t18[1] * e2[1] + t18[2] * e2[2];
  }
  static cross(t18, e2, n2) {
    const o2 = e2[0], i2 = e2[1], r2 = e2[2], a2 = n2[0], s2 = n2[1], c2 = n2[2];
    return t18[0] = i2 * c2 - r2 * s2, t18[1] = r2 * a2 - o2 * c2, t18[2] = o2 * s2 - i2 * a2, t18;
  }
  static lerp(t18, e2, n2, o2) {
    const i2 = e2[0], r2 = e2[1], a2 = e2[2];
    return t18[0] = i2 + o2 * (n2[0] - i2), t18[1] = r2 + o2 * (n2[1] - r2), t18[2] = a2 + o2 * (n2[2] - a2), t18;
  }
  static slerp(e2, n2, o2, i2) {
    const r2 = Math.acos(Math.min(Math.max(t4.dot(n2, o2), -1), 1)), a2 = Math.sin(r2), s2 = Math.sin((1 - i2) * r2) / a2, c2 = Math.sin(i2 * r2) / a2;
    return e2[0] = s2 * n2[0] + c2 * o2[0], e2[1] = s2 * n2[1] + c2 * o2[1], e2[2] = s2 * n2[2] + c2 * o2[2], e2;
  }
  static hermite(t18, e2, n2, o2, i2, r2) {
    const a2 = r2 * r2, s2 = a2 * (2 * r2 - 3) + 1, c2 = a2 * (r2 - 2) + r2, l2 = a2 * (r2 - 1), u2 = a2 * (3 - 2 * r2);
    return t18[0] = e2[0] * s2 + n2[0] * c2 + o2[0] * l2 + i2[0] * u2, t18[1] = e2[1] * s2 + n2[1] * c2 + o2[1] * l2 + i2[1] * u2, t18[2] = e2[2] * s2 + n2[2] * c2 + o2[2] * l2 + i2[2] * u2, t18;
  }
  static bezier(t18, e2, n2, o2, i2, r2) {
    const a2 = 1 - r2, s2 = a2 * a2, c2 = r2 * r2, l2 = s2 * a2, u2 = 3 * r2 * s2, p2 = 3 * c2 * a2, d2 = c2 * r2;
    return t18[0] = e2[0] * l2 + n2[0] * u2 + o2[0] * p2 + i2[0] * d2, t18[1] = e2[1] * l2 + n2[1] * u2 + o2[1] * p2 + i2[1] * d2, t18[2] = e2[2] * l2 + n2[2] * u2 + o2[2] * p2 + i2[2] * d2, t18;
  }
  static transformMat4(t18, e2, n2) {
    const o2 = e2[0], i2 = e2[1], r2 = e2[2], a2 = n2[3] * o2 + n2[7] * i2 + n2[11] * r2 + n2[15] || 1;
    return t18[0] = (n2[0] * o2 + n2[4] * i2 + n2[8] * r2 + n2[12]) / a2, t18[1] = (n2[1] * o2 + n2[5] * i2 + n2[9] * r2 + n2[13]) / a2, t18[2] = (n2[2] * o2 + n2[6] * i2 + n2[10] * r2 + n2[14]) / a2, t18;
  }
  static transformMat3(t18, e2, n2) {
    const o2 = e2[0], i2 = e2[1], r2 = e2[2];
    return t18[0] = o2 * n2[0] + i2 * n2[3] + r2 * n2[6], t18[1] = o2 * n2[1] + i2 * n2[4] + r2 * n2[7], t18[2] = o2 * n2[2] + i2 * n2[5] + r2 * n2[8], t18;
  }
  static transformQuat(t18, e2, n2) {
    const o2 = n2[0], i2 = n2[1], r2 = n2[2], a2 = 2 * n2[3], s2 = e2[0], c2 = e2[1], l2 = e2[2], u2 = i2 * l2 - r2 * c2, p2 = r2 * s2 - o2 * l2, d2 = o2 * c2 - i2 * s2, m2 = 2 * (i2 * d2 - r2 * p2), f2 = 2 * (r2 * u2 - o2 * d2), h2 = 2 * (o2 * p2 - i2 * u2);
    return t18[0] = s2 + u2 * a2 + m2, t18[1] = c2 + p2 * a2 + f2, t18[2] = l2 + d2 * a2 + h2, t18;
  }
  static rotateX(t18, e2, n2, o2) {
    const i2 = n2[1], r2 = n2[2], a2 = e2[1] - i2, s2 = e2[2] - r2;
    return t18[0] = e2[0], t18[1] = a2 * Math.cos(o2) - s2 * Math.sin(o2) + i2, t18[2] = a2 * Math.sin(o2) + s2 * Math.cos(o2) + r2, t18;
  }
  static rotateY(t18, e2, n2, o2) {
    const i2 = n2[0], r2 = n2[2], a2 = e2[0] - i2, s2 = e2[2] - r2;
    return t18[0] = s2 * Math.sin(o2) + a2 * Math.cos(o2) + i2, t18[1] = e2[1], t18[2] = s2 * Math.cos(o2) - a2 * Math.sin(o2) + r2, t18;
  }
  static rotateZ(t18, e2, n2, o2) {
    const i2 = n2[0], r2 = n2[1], a2 = e2[0] - i2, s2 = e2[1] - r2;
    return t18[0] = a2 * Math.cos(o2) - s2 * Math.sin(o2) + i2, t18[1] = a2 * Math.sin(o2) + s2 * Math.cos(o2) + r2, t18[2] = n2[2], t18;
  }
  static angle(e2, n2) {
    const o2 = e2[0], i2 = e2[1], r2 = e2[2], a2 = n2[0], s2 = n2[1], c2 = n2[2], l2 = Math.sqrt((o2 * o2 + i2 * i2 + r2 * r2) * (a2 * a2 + s2 * s2 + c2 * c2)), u2 = l2 && t4.dot(e2, n2) / l2;
    return Math.acos(Math.min(Math.max(u2, -1), 1));
  }
  static zero(t18) {
    return t18[0] = 0, t18[1] = 0, t18[2] = 0, t18;
  }
  static str(t18) {
    return `Vec3(${t18.join(", ")})`;
  }
  static exactEquals(t18, e2) {
    return t18[0] === e2[0] && t18[1] === e2[1] && t18[2] === e2[2];
  }
  static equals(t18, e2) {
    const n2 = t18[0], o2 = t18[1], i2 = t18[2], r2 = e2[0], a2 = e2[1], s2 = e2[2];
    return Math.abs(n2 - r2) <= GLM_EPSILON$1 * Math.max(1, Math.abs(n2), Math.abs(r2)) && Math.abs(o2 - a2) <= GLM_EPSILON$1 * Math.max(1, Math.abs(o2), Math.abs(a2)) && Math.abs(i2 - s2) <= GLM_EPSILON$1 * Math.max(1, Math.abs(i2), Math.abs(s2));
  }
};
Vec3$1.prototype.sub = Vec3$1.prototype.subtract, Vec3$1.prototype.mul = Vec3$1.prototype.multiply, Vec3$1.prototype.div = Vec3$1.prototype.divide, Vec3$1.prototype.dist = Vec3$1.prototype.distance, Vec3$1.prototype.sqrDist = Vec3$1.prototype.squaredDistance, Vec3$1.sub = Vec3$1.subtract, Vec3$1.mul = Vec3$1.multiply, Vec3$1.div = Vec3$1.divide, Vec3$1.dist = Vec3$1.distance, Vec3$1.sqrDist = Vec3$1.squaredDistance, Vec3$1.sqrLen = Vec3$1.squaredLength, Vec3$1.mag = Vec3$1.magnitude, Vec3$1.length = Vec3$1.magnitude, Vec3$1.len = Vec3$1.magnitude;
let StyleParse$1 = class {
  static #y = /(\d+)\s*px/;
  static pixels(t18) {
    if ("string" != typeof t18) return;
    const e2 = this.#y.test(t18), n2 = parseInt(t18);
    return e2 && Number.isFinite(n2) ? n2 : void 0;
  }
  static remPixels(t18 = 1, { targetDocument: e2 = document } = {}) {
    return e2?.documentElement ? t18 * parseFloat(globalThis.getComputedStyle(e2.documentElement).fontSize) : void 0;
  }
}, TJSStyleManager$1 = class t5 {
  #v;
  #w;
  #S;
  #T;
  #k;
  constructor({ docKey: t18, selector: e2 = ":root", document: n2 = globalThis.document, version: o2 } = {}) {
    if ("string" != typeof t18) throw new TypeError("StyleManager error: 'docKey' is not a string.");
    if ("[object HTMLDocument]" !== Object.prototype.toString.call(n2)) throw new TypeError("TJSStyleManager error: 'document' is not an instance of HTMLDocument.");
    if ("string" != typeof e2) throw new TypeError("StyleManager error: 'selector' is not a string.");
    if (void 0 !== o2 && !Number.isSafeInteger(o2) && o2 < 1) throw new TypeError("StyleManager error: 'version' is defined and is not a positive integer >= 1.");
    if (this.#S = e2, this.#w = t18, this.#k = o2, void 0 === n2[this.#w]) this.#T = n2.createElement("style"), n2.head.append(this.#T), this.#T._STYLE_MANAGER_VERSION = o2, this.#T.sheet.insertRule(`${e2} {}`, 0), this.#v = this.#T.sheet.cssRules[0], n2[t18] = this.#T;
    else if (this.#T = n2[t18], this.#v = this.#T.sheet.cssRules[0], o2) {
      o2 > (this.#T._STYLE_MANAGER_VERSION ?? 0) && (this.#v.style.cssText = "");
    }
  }
  get cssText() {
    return this.#v.style.cssText;
  }
  get version() {
    return this.#k;
  }
  clone(e2 = globalThis.document) {
    const n2 = new t5({ selector: this.#S, docKey: this.#w, document: e2, version: this.#k });
    return n2.#v.style.cssText = this.#v.style.cssText, n2;
  }
  get() {
    const t18 = this.#v.style.cssText, e2 = {};
    if ("" !== t18) {
      for (const n2 of t18.split(";")) if ("" !== n2) {
        const t19 = n2.split(":");
        e2[t19[0].trim()] = t19[1];
      }
    }
    return e2;
  }
  getProperty(t18) {
    if ("string" != typeof t18) throw new TypeError("StyleManager error: 'key' is not a string.");
    return this.#v.style.getPropertyValue(t18);
  }
  setProperties(t18, e2 = true) {
    if (!isObject$1(t18)) throw new TypeError("StyleManager error: 'rules' is not an object.");
    if ("boolean" != typeof e2) throw new TypeError("StyleManager error: 'overwrite' is not a boolean.");
    if (e2) for (const [e3, n2] of Object.entries(t18)) this.#v.style.setProperty(e3, n2);
    else for (const [e3, n2] of Object.entries(t18)) "" === this.#v.style.getPropertyValue(e3) && this.#v.style.setProperty(e3, n2);
  }
  setProperty(t18, e2, n2 = true) {
    if ("string" != typeof t18) throw new TypeError("StyleManager error: 'key' is not a string.");
    if ("string" != typeof e2) throw new TypeError("StyleManager error: 'value' is not a string.");
    if ("boolean" != typeof n2) throw new TypeError("StyleManager error: 'overwrite' is not a boolean.");
    (n2 || "" === this.#v.style.getPropertyValue(t18)) && this.#v.style.setProperty(t18, e2);
  }
  removeProperties(t18) {
    if (!isIterable$1(t18)) throw new TypeError("StyleManager error: 'keys' is not an iterable list.");
    for (const e2 of t18) "string" == typeof e2 && this.#v.style.removeProperty(e2);
  }
  removeProperty(t18) {
    if ("string" != typeof t18) throw new TypeError("StyleManager error: 'key' is not a string.");
    return this.#v.style.removeProperty(t18);
  }
};
async function nextAnimationFrame$1(t18 = 1) {
  if (!Number.isInteger(t18) || t18 < 1) throw new TypeError("nextAnimationFrame error: 'cntr' must be a positive integer greater than 0.");
  let e2;
  for (; --t18 >= 0; ) e2 = await new Promise((t19) => requestAnimationFrame(t19));
  return e2;
}
function draggable$1(t18, { position: e2, enabled: n2 = true, button: o2 = 0, storeDragging: i2, tween: r2 = false, tweenOptions: a2 = { duration: 1, ease: "cubicOut" }, hasTargetClassList: s2, ignoreTargetClassList: c2 }) {
  if (void 0 !== s2 && !isIterable$1(s2)) throw new TypeError("'hasTargetClassList' is not iterable.");
  if (void 0 !== c2 && !isIterable$1(c2)) throw new TypeError("'ignoreTargetClassList' is not iterable.");
  const l2 = { left: 0, top: 0 };
  let u2 = e2?.position ?? e2, p2 = null, d2 = { x: 0, y: 0 }, m2 = false, f2 = u2.animate.quickTo(["top", "left"], a2);
  const h2 = { dragDown: ["pointerdown", function(e3) {
    if (e3.button !== o2 || !e3.isPrimary) return;
    if (!u2.enabled) return;
    if (void 0 !== c2 && A11yHelper$1.isFocusTarget(e3.target)) {
      for (const t19 of c2) if (e3.target.classList.contains(t19)) return;
    }
    if (void 0 !== s2 && A11yHelper$1.isFocusTarget(e3.target)) {
      let t19 = false;
      for (const n3 of s2) if (e3.target.classList.contains(n3)) {
        t19 = true;
        break;
      }
      if (!t19) return;
    }
    e3.preventDefault(), m2 = false, p2 = u2.get(), d2 = { x: e3.clientX, y: e3.clientY }, t18.addEventListener(...h2.dragMove), t18.addEventListener(...h2.dragUp), t18.setPointerCapture(e3.pointerId);
  }, false], dragMove: ["pointermove", function(t19) {
    if (!(1 & t19.buttons)) return void $2(t19);
    if (-1 !== t19.button || !t19.isPrimary) return;
    t19.preventDefault(), m2 || "function" != typeof i2?.set || (m2 = true, i2.set(true));
    const e3 = p2?.left + (t19.clientX - d2.x), n3 = p2?.top + (t19.clientY - d2.y);
    r2 ? f2(n3, e3) : (l2.left = e3, l2.top = n3, u2.set(l2));
  }, false], dragUp: ["pointerup", $2, false] };
  function g2() {
    t18.addEventListener(...h2.dragDown), t18.classList.add("draggable");
  }
  function _() {
    "function" == typeof i2?.set && i2.set(false), t18.removeEventListener(...h2.dragDown), t18.removeEventListener(...h2.dragMove), t18.removeEventListener(...h2.dragUp), t18.classList.remove("draggable");
  }
  function $2(e3) {
    e3.preventDefault(), m2 = false, "function" == typeof i2?.set && i2.set(false), t18.removeEventListener(...h2.dragMove), t18.removeEventListener(...h2.dragUp);
  }
  return n2 && g2(), { update: (t19) => {
    if (void 0 !== t19.position) {
      const e3 = t19.position?.position ?? t19.position;
      e3 !== u2 && (u2 = e3, f2 = u2.animate.quickTo(["top", "left"], a2));
    }
    if ("boolean" == typeof t19.enabled && ((n2 = t19.enabled) ? g2() : _()), "number" == typeof t19.button && (o2 = t19.button), "boolean" == typeof t19.tween && (r2 = t19.tween), isObject$1(t19.tweenOptions) && (a2 = t19.tweenOptions, f2.options(a2)), void 0 !== t19.hasTargetClassList) {
      if (!isIterable$1(t19.hasTargetClassList)) throw new TypeError("'hasTargetClassList' is not iterable.");
      s2 = t19.hasTargetClassList;
    }
    if (void 0 !== t19.ignoreTargetClassList) {
      if (!isIterable$1(t19.ignoreTargetClassList)) throw new TypeError("'ignoreTargetClassList' is not iterable.");
      c2 = t19.ignoreTargetClassList;
    }
  }, destroy: () => _() };
}
let DraggableOptionsStore$1 = class {
  tween;
  tweenOptions;
  #x;
  #E;
  #O = false;
  #A = { duration: 1, ease: "cubicOut" };
  #C = [];
  constructor({ tween: t18 = false, tweenOptions: e2 } = {}) {
    Object.defineProperty(this, "tween", { get: () => this.#O, set: (t19) => {
      if ("boolean" != typeof t19) throw new TypeError("'tween' is not a boolean.");
      this.#O = t19, this.#M();
    }, enumerable: true }), Object.defineProperty(this, "tweenOptions", { get: () => this.#A, set: (t19) => {
      if (!isObject$1(t19)) throw new TypeError("'tweenOptions' is not an object.");
      if (void 0 !== t19.duration) {
        if (!Number.isFinite(t19.duration)) throw new TypeError("'tweenOptions.duration' is not a finite number.");
        t19.duration < 0 ? this.#A.duration = 0 : this.#A.duration = t19.duration;
      }
      if (void 0 !== t19.ease) {
        if ("function" != typeof getEasingFunc$1(t19.ease)) throw new TypeError("'tweenOptions.ease' is not a function or Svelte easing function name.");
        this.#A.ease = t19.ease;
      }
      this.#M();
    }, enumerable: true }), void 0 !== t18 && (this.tween = t18), void 0 !== e2 && (this.tweenOptions = e2), this.#x = this.#O, this.#E = Object.assign({}, this.#A);
  }
  get tweenDuration() {
    return this.#A.duration;
  }
  get tweenEase() {
    return this.#A.ease;
  }
  set tweenDuration(t18) {
    if (!Number.isFinite(t18)) throw new TypeError("'duration' is not a finite number.");
    t18 < 0 && (t18 = 0), this.#A.duration = t18, this.#M();
  }
  set tweenEase(t18) {
    if ("function" != typeof getEasingFunc$1(t18)) throw new TypeError("'ease' is not a function or Svelte easing function name.");
    this.#A.ease = t18, this.#M();
  }
  reset() {
    this.#O = this.#x, this.#A = Object.assign({}, this.#E), this.#M();
  }
  resetTween() {
    this.#O = this.#x, this.#M();
  }
  resetTweenOptions() {
    this.#A = Object.assign({}, this.#E), this.#M();
  }
  subscribe(t18) {
    return -1 === this.#C.findIndex((e2) => e2 === t18) && (this.#C.push(t18), t18(this)), () => {
      const e2 = this.#C.findIndex((e3) => e3 === t18);
      -1 !== e2 && this.#C.splice(e2, 1);
    };
  }
  #M() {
    const t18 = this.#C;
    if (t18.length > 0) for (let e2 = 0; e2 < t18.length; e2++) t18[e2](this);
  }
};
draggable$1.options = (t18) => new DraggableOptionsStore$1(t18);
let AnimationControl$1 = class t6 {
  #I;
  #N;
  #P;
  static #D = new t6(null);
  static get voidControl() {
    return this.#D;
  }
  constructor(t18, e2 = false) {
    this.#I = t18, this.#P = e2, isObject$1(t18) && (t18.control = this);
  }
  get finished() {
    return CrossWindow$1.isPromise(this.#N) || (this.#N = this.#P ? new Promise((t18) => this.#I.resolve = t18) : Promise.resolve({ cancelled: false })), this.#N;
  }
  get isActive() {
    return this.#I?.active ?? false;
  }
  get isFinished() {
    return this.#I?.finished ?? true;
  }
  cancel() {
    const t18 = this.#I;
    null != t18 && (t18.cancelled = true);
  }
}, AnimationManager$1 = class t7 {
  static cancelFn = (t18) => true !== t18?.quickTo;
  static cancelAllFn = () => true;
  static #j = Object.freeze({ immediateElementUpdate: true });
  static #F = [];
  static #L = (t18) => this.animate(t18);
  static #R = [];
  static #z = false;
  static #H;
  static #W;
  static get timeFrame() {
    return this.#H;
  }
  static get timeNow() {
    return this.#W;
  }
  static add(e2) {
    e2.cancelled ? this.#U(e2) : (t7.#R.push(e2), t7.#z || (t7.#z = true, globalThis.requestAnimationFrame(this.#L)));
  }
  static animate(e2) {
    if (t7.#z = false, t7.#W = globalThis.performance.now(), t7.#H = e2, 0 !== t7.#F.length || 0 !== t7.#R.length) {
      if (t7.#R.length) for (let e3 = t7.#R.length; --e3 >= 0; ) {
        const n2 = t7.#R[e3];
        (n2.cancelled || void 0 !== n2.el && !n2.el.isConnected) && (t7.#R.splice(e3, 1), this.#U(n2)), n2.active && (n2.transformOrigin && n2.position.set({ transformOrigin: n2.transformOrigin }), n2.start = t7.#H, t7.#R.splice(e3, 1), t7.#F.push(n2));
      }
      for (let n2 = t7.#F.length; --n2 >= 0; ) {
        const o2 = t7.#F[n2];
        if (o2.cancelled || void 0 !== o2.el && !o2.el.isConnected) {
          t7.#F.splice(n2, 1), this.#U(o2);
          continue;
        }
        if (o2.current = e2 - o2.start, o2.current >= o2.duration) {
          for (let t18 = o2.keys.length; --t18 >= 0; ) {
            const e3 = o2.keys[t18];
            o2.newData[e3] = o2.destination[e3];
          }
          o2.position.set(o2.newData, t7.#j), t7.#F.splice(n2, 1), this.#U(o2);
          continue;
        }
        const i2 = o2.ease(o2.current / o2.duration);
        for (let t18 = o2.keys.length; --t18 >= 0; ) {
          const e3 = o2.keys[t18];
          o2.newData[e3] = o2.interpolate(o2.initial[e3], o2.destination[e3], i2);
        }
        o2.position.set(o2.newData, t7.#j);
      }
      globalThis.requestAnimationFrame(this.#L);
    }
  }
  static cancel(e2, n2 = t7.cancelFn) {
    for (let o2 = t7.#F.length; --o2 >= 0; ) {
      const i2 = t7.#F[o2];
      i2.position === e2 && n2(i2) && (t7.#F.splice(o2, 1), i2.cancelled = true, this.#U(i2));
    }
    for (let o2 = t7.#R.length; --o2 >= 0; ) {
      const i2 = t7.#R[o2];
      i2.position === e2 && n2(i2) && (t7.#R.splice(o2, 1), i2.cancelled = true, this.#U(i2));
    }
  }
  static cancelAll() {
    for (let e2 = t7.#F.length; --e2 >= 0; ) {
      const n2 = t7.#F[e2];
      n2.cancelled = true, this.#U(n2);
    }
    for (let e2 = t7.#R.length; --e2 >= 0; ) {
      const n2 = t7.#R[e2];
      n2.cancelled = true, this.#U(n2);
    }
    t7.#F.length = 0, t7.#R.length = 0;
  }
  static #U(t18) {
    t18.active = false, t18.finished = true, t18.transformOriginInitial && t18.position.set({ transformOrigin: t18.transformOriginInitial }), "function" == typeof t18.cleanup && t18.cleanup(t18), "function" == typeof t18.resolve && t18.resolve({ cancelled: t18.cancelled }), t18.quickTo || (t18.cleanup = void 0, t18.control = void 0, t18.destination = void 0, t18.el = void 0, t18.ease = void 0, t18.initial = void 0, t18.interpolate = void 0, t18.keys = void 0, t18.newData = void 0, t18.position = void 0, t18.resolve = void 0);
  }
  static getScheduled(e2) {
    const n2 = [];
    for (let o2 = t7.#F.length; --o2 >= 0; ) {
      const i2 = t7.#F[o2];
      i2.position === e2 && i2.control && n2.push(i2.control);
    }
    for (let o2 = t7.#R.length; --o2 >= 0; ) {
      const i2 = t7.#R[o2];
      i2.position === e2 && i2.control && n2.push(i2.control);
    }
    return n2;
  }
  static isScheduled(e2, { active: n2 = true, pending: o2 = true } = {}) {
    if (n2) {
      for (let n3 = t7.#F.length; --n3 >= 0; ) if (t7.#F[n3].position === e2) return true;
    }
    if (o2) {
      for (let n3 = t7.#R.length; --n3 >= 0; ) if (t7.#R[n3].position === e2) return true;
    }
    return false;
  }
}, TJSPositionData$1 = class {
  height;
  left;
  maxHeight;
  maxWidth;
  minHeight;
  minWidth;
  rotateX;
  rotateY;
  rotateZ;
  scale;
  top;
  transformOrigin;
  translateX;
  translateY;
  translateZ;
  width;
  zIndex;
  constructor({ height: t18 = null, left: e2 = null, maxHeight: n2 = null, maxWidth: o2 = null, minHeight: i2 = null, minWidth: r2 = null, rotateX: a2 = null, rotateY: s2 = null, rotateZ: c2 = null, scale: l2 = null, translateX: u2 = null, translateY: p2 = null, translateZ: d2 = null, top: m2 = null, transformOrigin: f2 = null, width: h2 = null, zIndex: g2 = null } = {}) {
    this.height = t18, this.left = e2, this.maxHeight = n2, this.maxWidth = o2, this.minHeight = i2, this.minWidth = r2, this.rotateX = a2, this.rotateY = s2, this.rotateZ = c2, this.scale = l2, this.top = m2, this.transformOrigin = f2, this.translateX = u2, this.translateY = p2, this.translateZ = d2, this.width = h2, this.zIndex = g2;
  }
}, TJSPositionDataUtil$1 = class {
  static #q = Object.freeze(/* @__PURE__ */ new Set(["left", "top", "maxWidth", "maxHeight", "minWidth", "minHeight", "width", "height", "rotateX", "rotateY", "rotateZ", "scale", "translateX", "translateY", "translateZ", "zIndex", "rotation"]));
  static #G = Object.freeze(/* @__PURE__ */ new Map([["rotation", "rotateZ"]]));
  static #B = Object.freeze({ height: 0, left: 0, maxHeight: null, maxWidth: null, minHeight: null, minWidth: null, top: 0, transformOrigin: null, width: 0, zIndex: null, rotateX: 0, rotateY: 0, rotateZ: 0, scale: 1, translateX: 0, translateY: 0, translateZ: 0 });
  static copyData(t18, e2 = new TJSPositionData$1()) {
    return e2.height = t18.height ?? null, e2.left = t18.left ?? null, e2.maxHeight = t18.maxHeight ?? null, e2.maxWidth = t18.maxWidth ?? null, e2.minHeight = t18.minHeight ?? null, e2.minWidth = t18.minWidth ?? null, e2.rotateX = t18.rotateX ?? null, e2.rotateY = t18.rotateY ?? null, e2.rotateZ = t18.rotateZ ?? null, e2.scale = t18.scale ?? null, e2.top = t18.top ?? null, e2.transformOrigin = t18.transformOrigin ?? null, e2.translateX = t18.translateX ?? null, e2.translateY = t18.translateY ?? null, e2.translateZ = t18.translateZ ?? null, e2.width = t18.width ?? null, e2.zIndex = t18.zIndex ?? null, e2;
  }
  static getAnimationKey(t18) {
    return this.#G.get(t18) ?? t18;
  }
  static getDataOrDefault(t18, e2) {
    return t18[e2 = this.#G.get(e2) ?? e2] ?? this.#B[e2];
  }
  static isAnimationKey(t18) {
    return this.#q.has(t18);
  }
  static setNumericDefaults(t18) {
    null === t18.rotateX && (t18.rotateX = 0), null === t18.rotateY && (t18.rotateY = 0), null === t18.rotateZ && (t18.rotateZ = 0), null === t18.translateX && (t18.translateX = 0), null === t18.translateY && (t18.translateY = 0), null === t18.translateZ && (t18.translateZ = 0), null === t18.scale && (t18.scale = 1);
  }
}, ConvertStringData$1 = class {
  static #J = { numPx: Object.freeze(/* @__PURE__ */ new Set(["left", "top", "maxWidth", "maxHeight", "minWidth", "minHeight", "width", "height", "translateX", "translateY", "translateZ"])), percentParent: Object.freeze(/* @__PURE__ */ new Set(["left", "top", "maxWidth", "maxHeight", "minWidth", "minHeight", "width", "height"])), rotationRadTurn: Object.freeze(/* @__PURE__ */ new Set(["rotateX", "rotateY", "rotateZ", "rotation"])) };
  static #Y = /^(?<operation>[-+*]=)?(?<value>-?\d*\.?\d+)(?<unit>%|%~|px|rad|turn)?$/;
  static #X = Object.seal({ operation: void 0, value: 0, unit: void 0 });
  static process(t18, e2, n2) {
    let o2 = Number.NaN, i2 = Number.NaN;
    for (const r2 in t18) if (TJSPositionDataUtil$1.isAnimationKey(r2)) {
      const a2 = t18[r2];
      if ("string" != typeof a2) continue;
      if ("auto" === a2 || "inherit" === a2) continue;
      const s2 = r2, c2 = this.#Y.exec(a2);
      let l2 = false;
      if (c2 && c2.groups) {
        const u2 = this.#X;
        u2.operation = c2.groups.operation, u2.value = parseFloat(c2.groups.value), u2.unit = c2.groups.unit;
        const p2 = TJSPositionDataUtil$1.getDataOrDefault(e2, r2);
        switch (u2.unit) {
          case "%":
            if (this.#J.percentParent.has(r2) && (Number.isNaN(o2) || Number.isNaN(i2))) {
              if (!n2?.parentElement?.isConnected) {
                o2 = 0, i2 = 0, console.warn(`TJSPosition - ConvertStringData warning: could not determine parent constraints for key '${r2}' with value '${a2}'.`), t18[r2] = void 0;
                continue;
              }
              o2 = n2.parentElement.clientHeight, i2 = n2.parentElement.clientWidth;
            }
            l2 = this.#V(s2, p2, t18, u2, o2, i2);
            break;
          case "%~":
            l2 = this.#K(s2, p2, t18, u2);
            break;
          case "px":
            l2 = !!this.#J.numPx.has(r2) && this.#Z(s2, p2, t18, u2);
            break;
          case "rad":
          case "turn":
            l2 = !!this.#J.rotationRadTurn.has(r2) && this.#Q(s2, p2, t18, u2);
            break;
          default:
            l2 = this.#Z(s2, p2, t18, u2);
        }
      }
      c2 && l2 || (console.warn(`TJSPosition - ConvertStringData warning: malformed key '${r2}' with value '${a2}'.`), t18[r2] = void 0);
    }
    return t18;
  }
  static #Z(t18, e2, n2, o2) {
    if (!o2.operation) return n2[t18] = o2.value, true;
    switch (o2.operation) {
      case "-=":
        n2[t18] = e2 - o2.value;
        break;
      case "+=":
        n2[t18] = e2 + o2.value;
        break;
      case "*=":
        n2[t18] = e2 * o2.value;
        break;
      default:
        return false;
    }
    return true;
  }
  static #V(t18, e2, n2, o2, i2, r2) {
    switch (t18) {
      case "left":
      case "maxWidth":
      case "minWidth":
      case "width":
      case "translateX":
        o2.value = r2 * (o2.value / 100);
        break;
      case "top":
      case "maxHeight":
      case "minHeight":
      case "height":
      case "translateY":
        o2.value = i2 * (o2.value / 100);
        break;
      case "rotateX":
      case "rotateY":
      case "rotateZ":
      case "rotation":
        o2.value = o2.value / 100 * 360;
        break;
      default:
        return false;
    }
    return this.#Z(t18, e2, n2, o2);
  }
  static #K(t18, e2, n2, o2) {
    if (o2.value = o2.value / 100, !o2.operation) return n2[t18] = e2 * o2.value, true;
    switch (o2.operation) {
      case "-=":
        n2[t18] = e2 - e2 * o2.value;
        break;
      case "+=":
        n2[t18] = e2 + e2 * o2.value;
        break;
      case "*=":
        n2[t18] = e2 * (e2 * o2.value);
        break;
      default:
        return false;
    }
    return true;
  }
  static #Q(t18, e2, n2, o2) {
    switch (o2.unit) {
      case "rad":
        o2.value = radToDeg$1(o2.value);
        break;
      case "turn":
        o2.value = 360 * o2.value;
    }
    return this.#Z(t18, e2, n2, o2);
  }
}, TJSTransformData$1 = class {
  constructor() {
    Object.seal(this);
  }
  #tt = new DOMRect();
  #et = [new Vec3$1(), new Vec3$1(), new Vec3$1(), new Vec3$1()];
  #nt = new Mat4$1();
  #ot = [new Mat4$1(), new Mat4$1()];
  get boundingRect() {
    return this.#tt;
  }
  get corners() {
    return this.#et;
  }
  get css() {
    return `matrix3d(${this.mat4.join(",")})`;
  }
  get mat4() {
    return this.#nt;
  }
  get originTranslations() {
    return this.#ot;
  }
}, NumberGuard$1 = class {
  constructor() {
  }
  static isFinite(t18) {
    return "number" == typeof t18 && Number.isFinite(t18);
  }
  static isFiniteOrNull(t18) {
    return null === t18 || "number" == typeof t18 && Number.isFinite(t18);
  }
}, TJSPositionStyleCache$1 = class {
  el;
  computed;
  marginLeft;
  marginTop;
  maxHeight;
  maxWidth;
  minHeight;
  minWidth;
  hasWillChange;
  stores;
  resizeObserved;
  constructor() {
    this.el = void 0, this.computed = void 0, this.marginLeft = void 0, this.marginTop = void 0, this.maxHeight = void 0, this.maxWidth = void 0, this.minHeight = void 0, this.minWidth = void 0, this.hasWillChange = false, this.resizeObserved = Object.seal({ contentHeight: void 0, contentWidth: void 0, offsetHeight: void 0, offsetWidth: void 0 });
    const t18 = writable(this.resizeObserved);
    this.stores = { element: writable(this.el), resizeContentHeight: propertyStore$1(t18, "contentHeight"), resizeContentWidth: propertyStore$1(t18, "contentWidth"), resizeObserved: t18, resizeObservable: writable(false), resizeOffsetHeight: propertyStore$1(t18, "offsetHeight"), resizeOffsetWidth: propertyStore$1(t18, "offsetWidth") };
  }
  get offsetHeight() {
    if (void 0 !== this.el && A11yHelper$1.isFocusTarget(this.el)) return void 0 !== this.resizeObserved.offsetHeight ? this.resizeObserved.offsetHeight : this.el.offsetHeight;
    throw new Error("TJSPositionStyleCache - get offsetHeight error: no element assigned.");
  }
  get offsetWidth() {
    if (void 0 !== this.el && A11yHelper$1.isFocusTarget(this.el)) return void 0 !== this.resizeObserved.offsetWidth ? this.resizeObserved.offsetWidth : this.el.offsetWidth;
    throw new Error("TJSPositionStyleCache - get offsetWidth error: no element assigned.");
  }
  hasData(t18) {
    return this.el === t18;
  }
  reset() {
    void 0 !== this.el && A11yHelper$1.isFocusTarget(this.el) && this.el.isConnected && !this.hasWillChange && (this.el.style.willChange = ""), this.el = void 0, this.computed = void 0, this.marginLeft = void 0, this.marginTop = void 0, this.maxHeight = void 0, this.maxWidth = void 0, this.minHeight = void 0, this.minWidth = void 0, this.hasWillChange = false, this.resizeObserved.contentHeight = void 0, this.resizeObserved.contentWidth = void 0, this.resizeObserved.offsetHeight = void 0, this.resizeObserved.offsetWidth = void 0, this.stores.element.set(void 0);
  }
  update(t18) {
    this.el = t18, this.computed = globalThis.getComputedStyle(t18), this.marginLeft = StyleParse$1.pixels(t18.style.marginLeft) ?? StyleParse$1.pixels(this.computed.marginLeft), this.marginTop = StyleParse$1.pixels(t18.style.marginTop) ?? StyleParse$1.pixels(this.computed.marginTop), this.maxHeight = StyleParse$1.pixels(t18.style.maxHeight) ?? StyleParse$1.pixels(this.computed.maxHeight), this.maxWidth = StyleParse$1.pixels(t18.style.maxWidth) ?? StyleParse$1.pixels(this.computed.maxWidth), this.minHeight = StyleParse$1.pixels(t18.style.minHeight) ?? StyleParse$1.pixels(this.computed.minHeight), this.minWidth = StyleParse$1.pixels(t18.style.minWidth) ?? StyleParse$1.pixels(this.computed.minWidth);
    const e2 = "" !== t18.style.willChange ? t18.style.willChange : this.computed.willChange ?? "";
    this.hasWillChange = "" !== e2 && "auto" !== e2, this.stores.element.set(t18);
  }
}, TJSTransforms$1 = class t8 {
  #it = {};
  #rt = [];
  static #at = Object.freeze(["rotateX", "rotateY", "rotateZ", "scale", "translateX", "translateY", "translateZ"]);
  static #st(t18) {
    return this.#at.includes(t18);
  }
  static #ct = Object.freeze({ rotateX: 1, rotateY: 2, rotateZ: 4, scale: 8, translateX: 16, translateY: 32, translateZ: 64 });
  static #lt = "top left";
  static #ut = Object.freeze(["top left", "top center", "top right", "center left", "center", "center right", "bottom left", "bottom center", "bottom right"]);
  static #pt = Object.freeze(new Set(this.#ut));
  static #dt = new Mat4$1();
  static #mt = new Mat4$1();
  static #ft = new Vec3$1();
  static #ht = [1, 1, 1];
  static #gt = [0, 0, 0];
  static get transformOrigins() {
    return this.#ut;
  }
  static isTransformOrigin(t18) {
    return this.#pt.has(t18);
  }
  get isActive() {
    return this.#rt.length > 0;
  }
  get rotateX() {
    return this.#it.rotateX;
  }
  get rotateY() {
    return this.#it.rotateY;
  }
  get rotateZ() {
    return this.#it.rotateZ;
  }
  get scale() {
    return this.#it.scale;
  }
  get translateX() {
    return this.#it.translateX;
  }
  get translateY() {
    return this.#it.translateY;
  }
  get translateZ() {
    return this.#it.translateZ;
  }
  set rotateX(t18) {
    if (Number.isFinite(t18)) void 0 === this.#it.rotateX && this.#rt.push("rotateX"), this.#it.rotateX = t18;
    else {
      if (void 0 !== this.#it.rotateX) {
        const t19 = this.#rt.findIndex((t20) => "rotateX" === t20);
        t19 >= 0 && this.#rt.splice(t19, 1);
      }
      delete this.#it.rotateX;
    }
  }
  set rotateY(t18) {
    if (Number.isFinite(t18)) void 0 === this.#it.rotateY && this.#rt.push("rotateY"), this.#it.rotateY = t18;
    else {
      if (void 0 !== this.#it.rotateY) {
        const t19 = this.#rt.findIndex((t20) => "rotateY" === t20);
        t19 >= 0 && this.#rt.splice(t19, 1);
      }
      delete this.#it.rotateY;
    }
  }
  set rotateZ(t18) {
    if (Number.isFinite(t18)) void 0 === this.#it.rotateZ && this.#rt.push("rotateZ"), this.#it.rotateZ = t18;
    else {
      if (void 0 !== this.#it.rotateZ) {
        const t19 = this.#rt.findIndex((t20) => "rotateZ" === t20);
        t19 >= 0 && this.#rt.splice(t19, 1);
      }
      delete this.#it.rotateZ;
    }
  }
  set scale(t18) {
    if (Number.isFinite(t18)) void 0 === this.#it.scale && this.#rt.push("scale"), this.#it.scale = t18;
    else {
      if (void 0 !== this.#it.scale) {
        const t19 = this.#rt.findIndex((t20) => "scale" === t20);
        t19 >= 0 && this.#rt.splice(t19, 1);
      }
      delete this.#it.scale;
    }
  }
  set translateX(t18) {
    if (Number.isFinite(t18)) void 0 === this.#it.translateX && this.#rt.push("translateX"), this.#it.translateX = t18;
    else {
      if (void 0 !== this.#it.translateX) {
        const t19 = this.#rt.findIndex((t20) => "translateX" === t20);
        t19 >= 0 && this.#rt.splice(t19, 1);
      }
      delete this.#it.translateX;
    }
  }
  set translateY(t18) {
    if (Number.isFinite(t18)) void 0 === this.#it.translateY && this.#rt.push("translateY"), this.#it.translateY = t18;
    else {
      if (void 0 !== this.#it.translateY) {
        const t19 = this.#rt.findIndex((t20) => "translateY" === t20);
        t19 >= 0 && this.#rt.splice(t19, 1);
      }
      delete this.#it.translateY;
    }
  }
  set translateZ(t18) {
    if (Number.isFinite(t18)) void 0 === this.#it.translateZ && this.#rt.push("translateZ"), this.#it.translateZ = t18;
    else {
      if (void 0 !== this.#it.translateZ) {
        const t19 = this.#rt.findIndex((t20) => "translateZ" === t20);
        t19 >= 0 && this.#rt.splice(t19, 1);
      }
      delete this.#it.translateZ;
    }
  }
  getCSS(e2 = this.#it) {
    return `matrix3d(${this.getMat4(e2, t8.#dt).join(",")})`;
  }
  getCSSOrtho(e2 = this.#it) {
    return `matrix3d(${this.getMat4Ortho(e2, t8.#dt).join(",")})`;
  }
  getData(e2, n2 = new TJSTransformData$1(), o2) {
    const i2 = o2?.width ?? 0, r2 = o2?.height ?? 0, a2 = o2?.offsetTop ?? o2?.marginTop ?? 0, s2 = o2?.offsetLeft ?? o2?.marginLeft ?? 0;
    e2.top += a2, e2.left += s2;
    const c2 = NumberGuard$1.isFinite(e2.width) ? e2.width : i2, l2 = NumberGuard$1.isFinite(e2.height) ? e2.height : r2, u2 = n2.corners;
    if (this.hasTransform(e2)) {
      u2[0][0] = u2[0][1] = u2[0][2] = 0, u2[1][0] = c2, u2[1][1] = u2[1][2] = 0, u2[2][0] = c2, u2[2][1] = l2, u2[2][2] = 0, u2[3][0] = 0, u2[3][1] = l2, u2[3][2] = 0;
      const o3 = this.getMat4(e2, n2.mat4), i3 = t8.#_t(e2.transformOrigin, c2, l2, n2.originTranslations);
      t8.#lt === e2.transformOrigin ? (Vec3$1.transformMat4(u2[0], u2[0], o3), Vec3$1.transformMat4(u2[1], u2[1], o3), Vec3$1.transformMat4(u2[2], u2[2], o3), Vec3$1.transformMat4(u2[3], u2[3], o3)) : (Vec3$1.transformMat4(u2[0], u2[0], i3[0]), Vec3$1.transformMat4(u2[0], u2[0], o3), Vec3$1.transformMat4(u2[0], u2[0], i3[1]), Vec3$1.transformMat4(u2[1], u2[1], i3[0]), Vec3$1.transformMat4(u2[1], u2[1], o3), Vec3$1.transformMat4(u2[1], u2[1], i3[1]), Vec3$1.transformMat4(u2[2], u2[2], i3[0]), Vec3$1.transformMat4(u2[2], u2[2], o3), Vec3$1.transformMat4(u2[2], u2[2], i3[1]), Vec3$1.transformMat4(u2[3], u2[3], i3[0]), Vec3$1.transformMat4(u2[3], u2[3], o3), Vec3$1.transformMat4(u2[3], u2[3], i3[1])), u2[0][0] = e2.left + u2[0][0], u2[0][1] = e2.top + u2[0][1], u2[1][0] = e2.left + u2[1][0], u2[1][1] = e2.top + u2[1][1], u2[2][0] = e2.left + u2[2][0], u2[2][1] = e2.top + u2[2][1], u2[3][0] = e2.left + u2[3][0], u2[3][1] = e2.top + u2[3][1];
    } else u2[0][0] = e2.left, u2[0][1] = e2.top, u2[1][0] = e2.left + c2, u2[1][1] = e2.top, u2[2][0] = e2.left + c2, u2[2][1] = e2.top + l2, u2[3][0] = e2.left, u2[3][1] = e2.top + l2, Mat4$1.identity(n2.mat4);
    let p2 = Number.MIN_SAFE_INTEGER, d2 = Number.MIN_SAFE_INTEGER, m2 = Number.MAX_SAFE_INTEGER, f2 = Number.MAX_SAFE_INTEGER;
    for (let t18 = 4; --t18 >= 0; ) u2[t18][0] > p2 && (p2 = u2[t18][0]), u2[t18][0] < m2 && (m2 = u2[t18][0]), u2[t18][1] > d2 && (d2 = u2[t18][1]), u2[t18][1] < f2 && (f2 = u2[t18][1]);
    const h2 = n2.boundingRect;
    return h2.x = m2, h2.y = f2, h2.width = p2 - m2, h2.height = d2 - f2, e2.top -= a2, e2.left -= s2, n2;
  }
  getMat4(e2 = this.#it, n2 = new Mat4$1()) {
    const o2 = Mat4$1.identity(n2);
    let i2 = 0;
    const r2 = this.#rt;
    for (let n3 = 0; n3 < r2.length; n3++) {
      const a2 = r2[n3];
      switch (a2) {
        case "rotateX":
          i2 |= t8.#ct.rotateX, Mat4$1.multiply(o2, o2, Mat4$1.fromXRotation(t8.#mt, degToRad$1(e2[a2] ?? 0)));
          break;
        case "rotateY":
          i2 |= t8.#ct.rotateY, Mat4$1.multiply(o2, o2, Mat4$1.fromYRotation(t8.#mt, degToRad$1(e2[a2] ?? 0)));
          break;
        case "rotateZ":
          i2 |= t8.#ct.rotateZ, Mat4$1.multiply(o2, o2, Mat4$1.fromZRotation(t8.#mt, degToRad$1(e2[a2] ?? 0)));
          break;
        case "scale":
          i2 |= t8.#ct.scale, t8.#ht[0] = t8.#ht[1] = e2[a2] ?? 0, Mat4$1.multiply(o2, o2, Mat4$1.fromScaling(t8.#mt, t8.#ht));
          break;
        case "translateX":
          i2 |= t8.#ct.translateX, t8.#gt[0] = e2.translateX ?? 0, t8.#gt[1] = 0, t8.#gt[2] = 0, Mat4$1.multiply(o2, o2, Mat4$1.fromTranslation(t8.#mt, t8.#gt));
          break;
        case "translateY":
          i2 |= t8.#ct.translateY, t8.#gt[0] = 0, t8.#gt[1] = e2.translateY ?? 0, t8.#gt[2] = 0, Mat4$1.multiply(o2, o2, Mat4$1.fromTranslation(t8.#mt, t8.#gt));
          break;
        case "translateZ":
          i2 |= t8.#ct.translateZ, t8.#gt[0] = 0, t8.#gt[1] = 0, t8.#gt[2] = e2.translateZ ?? 0, Mat4$1.multiply(o2, o2, Mat4$1.fromTranslation(t8.#mt, t8.#gt));
      }
    }
    if (e2 !== this.#it) for (let n3 = 0; n3 < t8.#at.length; n3++) {
      const r3 = t8.#at[n3];
      if (null === e2[r3] || (i2 & t8.#ct[r3]) > 0) continue;
      const a2 = e2[r3];
      switch (r3) {
        case "rotateX":
          Mat4$1.multiply(o2, o2, Mat4$1.fromXRotation(t8.#mt, degToRad$1(a2)));
          break;
        case "rotateY":
          Mat4$1.multiply(o2, o2, Mat4$1.fromYRotation(t8.#mt, degToRad$1(a2)));
          break;
        case "rotateZ":
          Mat4$1.multiply(o2, o2, Mat4$1.fromZRotation(t8.#mt, degToRad$1(a2)));
          break;
        case "scale":
          t8.#ht[0] = t8.#ht[1] = a2, Mat4$1.multiply(o2, o2, Mat4$1.fromScaling(t8.#mt, t8.#ht));
          break;
        case "translateX":
          t8.#gt[0] = a2, t8.#gt[1] = 0, t8.#gt[2] = 0, Mat4$1.multiply(o2, o2, Mat4$1.fromTranslation(t8.#mt, t8.#gt));
          break;
        case "translateY":
          t8.#gt[0] = 0, t8.#gt[1] = a2, t8.#gt[2] = 0, Mat4$1.multiply(o2, o2, Mat4$1.fromTranslation(t8.#mt, t8.#gt));
          break;
        case "translateZ":
          t8.#gt[0] = 0, t8.#gt[1] = 0, t8.#gt[2] = a2, Mat4$1.multiply(o2, o2, Mat4$1.fromTranslation(t8.#mt, t8.#gt));
      }
    }
    return o2;
  }
  getMat4Ortho(e2 = this.#it, n2 = new Mat4$1()) {
    const o2 = Mat4$1.identity(n2);
    if (t8.#gt[0] = (e2.left ?? 0) + (e2.translateX ?? 0), t8.#gt[1] = (e2.top ?? 0) + (e2.translateY ?? 0), t8.#gt[2] = e2.translateZ ?? 0, Mat4$1.multiply(o2, o2, Mat4$1.fromTranslation(t8.#mt, t8.#gt)), null !== e2.scale && void 0 !== e2.scale && (t8.#ht[0] = t8.#ht[1] = e2.scale, Mat4$1.multiply(o2, o2, Mat4$1.fromScaling(t8.#mt, t8.#ht))), null === e2.rotateX && null === e2.rotateY && null === e2.rotateZ) return o2;
    let i2 = 0;
    const r2 = this.#rt;
    for (let n3 = 0; n3 < r2.length; n3++) {
      const a2 = r2[n3];
      switch (a2) {
        case "rotateX":
          i2 |= t8.#ct.rotateX, Mat4$1.multiply(o2, o2, Mat4$1.fromXRotation(t8.#mt, degToRad$1(e2[a2] ?? 0)));
          break;
        case "rotateY":
          i2 |= t8.#ct.rotateY, Mat4$1.multiply(o2, o2, Mat4$1.fromYRotation(t8.#mt, degToRad$1(e2[a2] ?? 0)));
          break;
        case "rotateZ":
          i2 |= t8.#ct.rotateZ, Mat4$1.multiply(o2, o2, Mat4$1.fromZRotation(t8.#mt, degToRad$1(e2[a2] ?? 0)));
      }
    }
    if (e2 !== this.#it) for (let n3 = 0; n3 < t8.#at.length; n3++) {
      const r3 = t8.#at[n3];
      if (!(null === e2[r3] || (i2 & t8.#ct[r3]) > 0)) switch (r3) {
        case "rotateX":
          Mat4$1.multiply(o2, o2, Mat4$1.fromXRotation(t8.#mt, degToRad$1(e2[r3] ?? 0)));
          break;
        case "rotateY":
          Mat4$1.multiply(o2, o2, Mat4$1.fromYRotation(t8.#mt, degToRad$1(e2[r3] ?? 0)));
          break;
        case "rotateZ":
          Mat4$1.multiply(o2, o2, Mat4$1.fromZRotation(t8.#mt, degToRad$1(e2[r3] ?? 0)));
      }
    }
    return o2;
  }
  hasTransform(e2) {
    for (const n2 of t8.#at) if (Number.isFinite(e2[n2])) return true;
    return false;
  }
  reset(e2) {
    for (const n2 in e2) if (t8.#st(n2)) {
      const t18 = e2[n2];
      if (NumberGuard$1.isFinite(t18)) this.#it[n2] = t18;
      else {
        const t19 = this.#rt.findIndex((t20) => t20 === n2);
        t19 >= 0 && this.#rt.splice(t19, 1), delete this.#it[n2];
      }
    }
  }
  static #_t(e2, n2, o2, i2) {
    const r2 = t8.#ft;
    switch (e2) {
      case "top left":
        r2[0] = r2[1] = 0, Mat4$1.fromTranslation(i2[0], r2), Mat4$1.fromTranslation(i2[1], r2);
        break;
      case "top center":
        r2[0] = 0.5 * -n2, r2[1] = 0, Mat4$1.fromTranslation(i2[0], r2), r2[0] = 0.5 * n2, Mat4$1.fromTranslation(i2[1], r2);
        break;
      case "top right":
        r2[0] = -n2, r2[1] = 0, Mat4$1.fromTranslation(i2[0], r2), r2[0] = n2, Mat4$1.fromTranslation(i2[1], r2);
        break;
      case "center left":
        r2[0] = 0, r2[1] = 0.5 * -o2, Mat4$1.fromTranslation(i2[0], r2), r2[1] = 0.5 * o2, Mat4$1.fromTranslation(i2[1], r2);
        break;
      case null:
      case "center":
        r2[0] = 0.5 * -n2, r2[1] = 0.5 * -o2, Mat4$1.fromTranslation(i2[0], r2), r2[0] = 0.5 * n2, r2[1] = 0.5 * o2, Mat4$1.fromTranslation(i2[1], r2);
        break;
      case "center right":
        r2[0] = -n2, r2[1] = 0.5 * -o2, Mat4$1.fromTranslation(i2[0], r2), r2[0] = n2, r2[1] = 0.5 * o2, Mat4$1.fromTranslation(i2[1], r2);
        break;
      case "bottom left":
        r2[0] = 0, r2[1] = -o2, Mat4$1.fromTranslation(i2[0], r2), r2[1] = o2, Mat4$1.fromTranslation(i2[1], r2);
        break;
      case "bottom center":
        r2[0] = 0.5 * -n2, r2[1] = -o2, Mat4$1.fromTranslation(i2[0], r2), r2[0] = 0.5 * n2, r2[1] = o2, Mat4$1.fromTranslation(i2[1], r2);
        break;
      case "bottom right":
        r2[0] = -n2, r2[1] = -o2, Mat4$1.fromTranslation(i2[0], r2), r2[0] = n2, r2[1] = o2, Mat4$1.fromTranslation(i2[1], r2);
        break;
      default:
        Mat4$1.identity(i2[0]), Mat4$1.identity(i2[1]);
    }
    return i2;
  }
}, AnimationScheduler$1 = class {
  static #it = {};
  static #$t = Object.freeze({ default: false });
  static #bt(t18, e2, n2, o2, i2, r2, a2, s2 = lerp$1, c2, l2, u2) {
    TJSPositionDataUtil$1.setNumericDefaults(e2), TJSPositionDataUtil$1.setNumericDefaults(n2);
    for (const t19 in e2) Number.isFinite(e2[t19]) || delete e2[t19];
    const p2 = Object.keys(e2), d2 = Object.assign({}, e2);
    if (0 === p2.length) return null;
    const m2 = { active: true, cleanup: u2, cancelled: false, control: void 0, current: 0, destination: n2, duration: 1e3 * o2, ease: a2, el: i2, finished: false, initial: e2, interpolate: s2, keys: p2, newData: d2, position: t18, resolve: void 0, start: void 0, transformOrigin: c2, transformOriginInitial: l2, quickTo: false };
    return r2 > 0 && (m2.active = false, setTimeout(() => m2.active = true, 1e3 * r2)), AnimationManager$1.add(m2), new AnimationControl$1(m2, true);
  }
  static from(t18, e2, n2 = {}, o2) {
    if (!isObject$1(e2)) throw new TypeError("AnimationAPI.from error: 'fromData' is not an object.");
    const i2 = t18.parent;
    if (void 0 !== i2 && "boolean" == typeof i2?.options?.positionable && !i2?.options?.positionable) return null;
    let { delay: r2 = 0, duration: a2 = 1, ease: s2 = "cubicOut", strategy: c2, transformOrigin: l2 } = n2;
    if (void 0 !== c2 && null === this.#yt(t18, c2)) return null;
    const u2 = A11yHelper$1.isFocusTarget(i2) ? i2 : i2?.elementTarget, p2 = A11yHelper$1.isFocusTarget(u2) && u2.isConnected ? u2 : void 0;
    if (!Number.isFinite(r2) || r2 < 0) throw new TypeError("AnimationScheduler.from error: 'delay' is not a positive number.");
    if (!Number.isFinite(a2) || a2 < 0) throw new TypeError("AnimationScheduler.from error: 'duration' is not a positive number.");
    if (s2 = getEasingFunc$1(s2, this.#$t), "function" != typeof s2) throw new TypeError("AnimationScheduler.from error: 'ease' is not a function or valid Svelte easing function name.");
    const d2 = {}, m2 = {};
    t18.get(this.#it), l2 = TJSTransforms$1.isTransformOrigin(l2) ? l2 : void 0;
    const f2 = void 0 !== l2 ? this.#it.transformOrigin : void 0;
    for (const t19 in e2) {
      const n3 = TJSPositionDataUtil$1.getAnimationKey(t19);
      void 0 !== this.#it[n3] && e2[t19] !== this.#it[n3] && (d2[t19] = e2[t19], m2[t19] = this.#it[n3]);
    }
    return ConvertStringData$1.process(d2, this.#it, p2), this.#bt(t18, d2, m2, a2, p2, r2, s2, lerp$1, l2, f2, o2);
  }
  static fromTo(t18, e2, n2, o2 = {}, i2) {
    if (!isObject$1(e2)) throw new TypeError("AnimationScheduler.fromTo error: 'fromData' is not an object.");
    if (!isObject$1(n2)) throw new TypeError("AnimationScheduler.fromTo error: 'toData' is not an object.");
    const r2 = t18.parent;
    if (void 0 !== r2 && "boolean" == typeof r2?.options?.positionable && !r2?.options?.positionable) return null;
    let { delay: a2 = 0, duration: s2 = 1, ease: c2 = "cubicOut", strategy: l2, transformOrigin: u2 } = o2;
    if (void 0 !== l2 && null === this.#yt(t18, l2)) return null;
    const p2 = A11yHelper$1.isFocusTarget(r2) ? r2 : r2?.elementTarget, d2 = A11yHelper$1.isFocusTarget(p2) && p2.isConnected ? p2 : void 0;
    if (!Number.isFinite(a2) || a2 < 0) throw new TypeError("AnimationScheduler.fromTo error: 'delay' is not a positive number.");
    if (!Number.isFinite(s2) || s2 < 0) throw new TypeError("AnimationScheduler.fromTo error: 'duration' is not a positive number.");
    if (c2 = getEasingFunc$1(c2, this.#$t), "function" != typeof c2) throw new TypeError("AnimationScheduler.fromTo error: 'ease' is not a function or valid Svelte easing function name.");
    const m2 = {}, f2 = {};
    t18.get(this.#it), u2 = TJSTransforms$1.isTransformOrigin(u2) ? u2 : void 0;
    const h2 = void 0 !== u2 ? this.#it.transformOrigin : void 0;
    for (const t19 in e2) {
      if (void 0 === n2[t19]) {
        console.warn(`AnimationScheduler.fromTo warning: skipping key ('${t19}') from 'fromData' as it is missing in 'toData'.`);
        continue;
      }
      const o3 = TJSPositionDataUtil$1.getAnimationKey(t19);
      void 0 !== this.#it[o3] && (m2[t19] = e2[t19], f2[t19] = n2[t19]);
    }
    return ConvertStringData$1.process(m2, this.#it, d2), ConvertStringData$1.process(f2, this.#it, d2), this.#bt(t18, m2, f2, s2, d2, a2, c2, lerp$1, u2, h2, i2);
  }
  static to(t18, e2, n2, o2) {
    if (!isObject$1(e2)) throw new TypeError("AnimationScheduler.to error: 'toData' is not an object.");
    const i2 = t18.parent;
    if (void 0 !== i2 && "boolean" == typeof i2?.options?.positionable && !i2?.options?.positionable) return null;
    let { delay: r2 = 0, duration: a2 = 1, ease: s2 = "cubicOut", strategy: c2, transformOrigin: l2 } = n2;
    if (void 0 !== c2 && null === this.#yt(t18, c2)) return null;
    const u2 = A11yHelper$1.isFocusTarget(i2) ? i2 : i2?.elementTarget, p2 = A11yHelper$1.isFocusTarget(u2) && u2.isConnected ? u2 : void 0;
    if (!Number.isFinite(r2) || r2 < 0) throw new TypeError("AnimationScheduler.to error: 'delay' is not a positive number.");
    if (!Number.isFinite(a2) || a2 < 0) throw new TypeError("AnimationScheduler.to error: 'duration' is not a positive number.");
    if (s2 = getEasingFunc$1(s2, this.#$t), "function" != typeof s2) throw new TypeError("AnimationScheduler.to error: 'ease' is not a function or valid Svelte easing function name.");
    const d2 = {}, m2 = {};
    t18.get(this.#it), l2 = TJSTransforms$1.isTransformOrigin(l2) ? l2 : void 0;
    const f2 = void 0 !== l2 ? this.#it.transformOrigin : void 0;
    for (const t19 in e2) {
      const n3 = TJSPositionDataUtil$1.getAnimationKey(t19);
      void 0 !== this.#it[n3] && e2[t19] !== this.#it[n3] && (m2[t19] = e2[t19], d2[t19] = this.#it[n3]);
    }
    return ConvertStringData$1.process(m2, this.#it, p2), this.#bt(t18, d2, m2, a2, p2, r2, s2, lerp$1, l2, f2, o2);
  }
  static #yt(t18, e2) {
    switch (e2) {
      case "cancel":
        AnimationManager$1.isScheduled(t18) && AnimationManager$1.cancel(t18);
        break;
      case "cancelAll":
        AnimationManager$1.isScheduled(t18) && AnimationManager$1.cancel(t18, AnimationManager$1.cancelAllFn);
        break;
      case "exclusive":
        if (AnimationManager$1.isScheduled(t18)) return null;
        break;
      default:
        return console.warn("AnimationScheduler error: 'strategy' is not 'cancel', 'cancelAll', or 'exclusive'."), null;
    }
  }
}, AnimationAPIImpl$1 = class t9 {
  static #$t = Object.freeze({ default: false });
  #it;
  #vt;
  constructor(t18, e2) {
    this.#vt = t18, this.#it = e2, Object.seal(this);
  }
  get isScheduled() {
    return AnimationManager$1.isScheduled(this.#vt);
  }
  cancel() {
    AnimationManager$1.cancel(this.#vt, AnimationManager$1.cancelAllFn);
  }
  getScheduled() {
    return AnimationManager$1.getScheduled(this.#vt);
  }
  from(t18, e2) {
    const n2 = AnimationScheduler$1.from(this.#vt, t18, e2);
    return n2 || AnimationControl$1.voidControl;
  }
  fromTo(t18, e2, n2) {
    const o2 = AnimationScheduler$1.fromTo(this.#vt, t18, e2, n2);
    return o2 || AnimationControl$1.voidControl;
  }
  to(t18, e2) {
    const n2 = AnimationScheduler$1.to(this.#vt, t18, e2);
    return n2 || AnimationControl$1.voidControl;
  }
  quickTo(e2, n2 = {}) {
    if (!isIterable$1(e2)) throw new TypeError("AnimationAPI.quickTo error: 'keys' is not an iterable list.");
    const o2 = this.#vt.parent;
    if (void 0 !== o2 && "boolean" == typeof o2?.options?.positionable && !o2?.options?.positionable) throw new Error("AnimationAPI.quickTo error: 'parent' is not positionable.");
    let { duration: i2 = 1, ease: r2 = "cubicOut" } = n2;
    if (!Number.isFinite(i2) || i2 < 0) throw new TypeError("AnimationAPI.quickTo error: 'duration' is not a positive number.");
    if (r2 = getEasingFunc$1(r2, t9.#$t), "function" != typeof r2) throw new TypeError("AnimationAPI.quickTo error: 'ease' is not a function or valid Svelte easing function name.");
    const a2 = {}, s2 = {}, c2 = this.#it;
    for (const t18 of e2) {
      if ("string" != typeof t18) throw new TypeError(`AnimationAPI.quickTo error: key ('${t18}') is not a string.`);
      if (!TJSPositionDataUtil$1.isAnimationKey(t18)) throw new Error(`AnimationAPI.quickTo error: key ('${t18}') is not animatable.`);
      const e3 = TJSPositionDataUtil$1.getDataOrDefault(c2, t18);
      null !== e3 && (s2[t18] = e3, a2[t18] = e3);
    }
    const l2 = [...e2];
    Object.freeze(l2);
    const u2 = Object.assign({}, a2), p2 = { active: true, cancelled: false, control: void 0, current: 0, destination: s2, duration: 1e3 * i2, ease: r2, el: void 0, finished: true, initial: a2, interpolate: lerp$1, keys: l2, newData: u2, position: this.#vt, resolve: void 0, start: 0, quickTo: true }, d2 = (...t18) => {
      const e3 = t18.length;
      if (0 === e3) return;
      for (let t19 = l2.length; --t19 >= 0; ) {
        const e4 = l2[t19], n4 = TJSPositionDataUtil$1.getAnimationKey(e4);
        void 0 !== c2[n4] && (a2[e4] = c2[n4]);
      }
      if (isObject$1(t18[0])) {
        const e4 = t18[0];
        for (const t19 in e4) void 0 !== s2[t19] && (s2[t19] = e4[t19]);
      } else for (let n4 = 0; n4 < e3 && n4 < l2.length; n4++) {
        const e4 = l2[n4];
        void 0 !== s2[e4] && (s2[e4] = t18[n4]);
      }
      TJSPositionDataUtil$1.setNumericDefaults(a2), TJSPositionDataUtil$1.setNumericDefaults(s2);
      const n3 = A11yHelper$1.isFocusTarget(o2) ? o2 : o2?.elementTarget;
      if (p2.el = A11yHelper$1.isFocusTarget(n3) && n3.isConnected ? n3 : void 0, ConvertStringData$1.process(s2, c2, p2.el), p2.finished) p2.cancelled = false, p2.finished = false, p2.active = true, p2.current = 0, AnimationManager$1.add(p2);
      else {
        const t19 = globalThis.performance.now();
        p2.cancelled = false, p2.current = 0, p2.start = t19 + (AnimationManager$1.timeNow - t19);
      }
    };
    return Object.defineProperty(d2, "keys", { value: l2, writable: false, configurable: false }), Object.defineProperty(d2, "options", { value: (e3) => {
      let { duration: n3, ease: o3 } = e3;
      if (void 0 !== n3 && (!Number.isFinite(n3) || n3 < 0)) throw new TypeError("AnimationAPI.quickTo.options error: 'duration' is not a positive number.");
      if (o3 = getEasingFunc$1(o3, t9.#$t), void 0 !== o3 && "function" != typeof o3) throw new TypeError("AnimationAPI.quickTo.options error: 'ease' is not a function or valid Svelte easing function name.");
      return NumberGuard$1.isFinite(n3) && n3 >= 0 && (p2.duration = 1e3 * n3), o3 && (p2.ease = o3), d2;
    }, writable: false, configurable: false }), d2;
  }
}, AnimationGroupControl$1 = class t10 {
  #wt;
  #N;
  static #D = new t10(null);
  static get voidControl() {
    return this.#D;
  }
  constructor(t18) {
    this.#wt = t18;
  }
  get finished() {
    const t18 = this.#wt;
    if (!CrossWindow$1.isPromise(this.#N)) if (null == t18 || 0 === t18.size) this.#N = Promise.resolve({ cancelled: false });
    else {
      const e2 = [];
      for (const n2 of t18) e2.push(n2.finished);
      this.#N = Promise.allSettled(e2).then((t19) => ({ cancelled: t19.some((t20) => "rejected" === t20.status || "fulfilled" === t20.status && t20.value.cancelled) }));
    }
    return this.#N;
  }
  get isActive() {
    const t18 = this.#wt;
    if (null == t18 || 0 === t18.size) return false;
    for (const e2 of t18) if (e2.isActive) return true;
    return false;
  }
  get isFinished() {
    const t18 = this.#wt;
    if (null == t18 || 0 === t18.size) return true;
    for (const e2 of t18) if (!e2.isFinished) return false;
    return true;
  }
  cancel() {
    const t18 = this.#wt;
    if (null != t18 && 0 !== t18.size) for (const e2 of t18) e2.cancel();
  }
}, AnimationGroupAPIImpl$1 = class {
  constructor() {
  }
  static #St(t18) {
    return isObject$1(t18) ? t18.animate instanceof AnimationAPIImpl$1 ? t18 : t18.position?.animate instanceof AnimationAPIImpl$1 ? t18.position : null : null;
  }
  static cancel(t18) {
    if (isIterable$1(t18)) {
      let e2 = -1;
      for (const n2 of t18) {
        e2++;
        const t19 = this.#St(n2);
        t19 ? AnimationManager$1.cancel(t19) : console.warn(`AnimationGroupAPI.cancel warning: No TJSPosition instance found at index: ${e2}.`);
      }
    } else {
      const e2 = this.#St(t18);
      if (!e2) return void console.warn("AnimationGroupAPI.cancel warning: No TJSPosition instance found.");
      AnimationManager$1.cancel(e2);
    }
  }
  static cancelAll() {
    AnimationManager$1.cancelAll();
  }
  static getScheduled(t18) {
    const e2 = [];
    if (isIterable$1(t18)) {
      let n2 = -1;
      for (const o2 of t18) {
        n2++;
        const t19 = this.#St(o2);
        if (!t19) {
          console.warn(`AnimationGroupAPI.getScheduled warning: No TJSPosition instance found at index: ${n2}.`);
          continue;
        }
        const i2 = AnimationManager$1.getScheduled(t19);
        e2.push({ position: t19, entry: t19 !== o2 ? o2 : void 0, controls: i2 });
      }
    } else {
      const n2 = this.#St(t18);
      if (!n2) return console.warn("AnimationGroupAPI.getScheduled warning: No TJSPosition instance found."), e2;
      const o2 = AnimationManager$1.getScheduled(n2);
      e2.push({ position: n2, entry: n2 !== t18 ? t18 : void 0, controls: o2 });
    }
    return e2;
  }
  static isAnimationKey(t18) {
    return TJSPositionDataUtil$1.isAnimationKey(t18);
  }
  static isScheduled(t18, e2) {
    if (isIterable$1(t18)) {
      let n2 = -1;
      for (const o2 of t18) {
        n2++;
        const t19 = this.#St(o2);
        if (t19) {
          if (!AnimationManager$1.isScheduled(t19, e2)) return false;
        } else console.warn(`AnimationGroupAPI.isScheduled warning: No TJSPosition instance found at index: ${n2}.`);
      }
    } else {
      const n2 = this.#St(t18);
      if (!n2) return console.warn("AnimationGroupAPI.isScheduled warning: No TJSPosition instance found."), false;
      if (!AnimationManager$1.isScheduled(n2, e2)) return false;
    }
    return true;
  }
  static from(t18, e2, n2) {
    if (!isObject$1(e2) && "function" != typeof e2) throw new TypeError("AnimationGroupAPI.from error: 'fromData' is not an object or function.");
    if (void 0 !== n2 && !isObject$1(n2) && "function" != typeof n2) throw new TypeError("AnimationGroupAPI.from error: 'options' is not an object or function.");
    const o2 = /* @__PURE__ */ new Set(), i2 = (t19) => o2.delete(t19.control);
    let r2, a2 = -1;
    const s2 = "function" == typeof e2, c2 = "function" == typeof n2, l2 = s2 || c2;
    l2 && (r2 = { index: a2, position: void 0, entry: void 0 });
    let u2 = e2, p2 = isObject$1(n2) ? n2 : void 0;
    if (isIterable$1(t18)) for (const d2 of t18) {
      a2++;
      const t19 = this.#St(d2);
      if (!t19) {
        console.warn(`AnimationGroupAPI.from warning: No TJSPosition instance found at index: ${a2}.`);
        continue;
      }
      if (l2 && (r2.index = a2, r2.position = t19, r2.entry = t19 !== d2 ? d2 : void 0), s2 && "function" == typeof e2) {
        if (u2 = e2(r2), null == u2) continue;
        if (!isObject$1(u2)) throw new TypeError(`AnimationGroupAPI.from error: 'fromData' callback function iteration(${a2}) failed to return an object.`);
      }
      if (c2 && "function" == typeof n2) {
        if (p2 = n2(r2), null == p2) continue;
        if (!isObject$1(p2)) throw new TypeError(`AnimationGroupAPI.from error: 'options' callback function iteration(${a2}) failed to return an object.`);
      }
      const m2 = AnimationScheduler$1.from(t19, u2, p2, i2);
      m2 && o2.add(m2);
    }
    else {
      const a3 = this.#St(t18);
      if (!a3) return console.warn("AnimationGroupAPI.from warning: No TJSPosition instance found."), AnimationGroupControl$1.voidControl;
      if (l2 && (r2.index = 0, r2.position = a3, r2.entry = a3 !== t18 ? t18 : void 0), s2 && "function" == typeof e2) {
        if (u2 = e2(r2), null == u2) return AnimationGroupControl$1.voidControl;
        if (!isObject$1(u2)) throw new TypeError("AnimationGroupAPI.from error: 'fromData' callback function failed to return an object.");
      }
      if (c2 && "function" == typeof n2) {
        if (p2 = n2(r2), null == p2) return AnimationGroupControl$1.voidControl;
        if (!isObject$1(p2)) throw new TypeError("AnimationGroupAPI.from error: 'options' callback function failed to return an object.");
      }
      const d2 = AnimationScheduler$1.from(a3, u2, p2, i2);
      d2 && o2.add(d2);
    }
    return new AnimationGroupControl$1(o2);
  }
  static fromTo(t18, e2, n2, o2) {
    if (!isObject$1(e2) && "function" != typeof e2) throw new TypeError("AnimationGroupAPI.fromTo error: 'fromData' is not an object or function.");
    if (!isObject$1(n2) && "function" != typeof n2) throw new TypeError("AnimationGroupAPI.fromTo error: 'toData' is not an object or function.");
    if (void 0 !== o2 && !isObject$1(o2) && "function" != typeof o2) throw new TypeError("AnimationGroupAPI.fromTo error: 'options' is not an object or function.");
    const i2 = /* @__PURE__ */ new Set(), r2 = (t19) => i2.delete(t19.control);
    let a2, s2 = -1;
    const c2 = "function" == typeof e2, l2 = "function" == typeof n2, u2 = "function" == typeof o2, p2 = c2 || l2 || u2;
    p2 && (a2 = { index: s2, position: void 0, entry: void 0 });
    let d2 = e2, m2 = n2, f2 = isObject$1(o2) ? o2 : void 0;
    if (isIterable$1(t18)) for (const h2 of t18) {
      s2++;
      const t19 = this.#St(h2);
      if (!t19) {
        console.warn(`AnimationGroupAPI.fromTo warning: No TJSPosition instance found at index: ${s2}.`);
        continue;
      }
      if (p2 && (a2.index = s2, a2.position = t19, a2.entry = t19 !== h2 ? h2 : void 0), c2 && "function" == typeof e2) {
        if (d2 = e2(a2), null == d2) continue;
        if (!isObject$1(d2)) throw new TypeError(`AnimationGroupAPI.fromTo error: 'fromData' callback function iteration(${s2}) failed to return an object.`);
      }
      if (l2 && "function" == typeof n2) {
        if (m2 = n2(a2), null == m2) continue;
        if (!isObject$1(m2)) throw new TypeError(`AnimationGroupAPI.fromTo error: 'toData' callback function iteration(${s2}) failed to return an object.`);
      }
      if (u2 && "function" == typeof o2) {
        if (f2 = o2(a2), null == f2) continue;
        if (!isObject$1(f2)) throw new TypeError(`AnimationGroupAPI.fromTo error: 'options' callback function iteration(${s2}) failed to return an object.`);
      }
      const g2 = AnimationScheduler$1.fromTo(t19, d2, m2, f2, r2);
      g2 && i2.add(g2);
    }
    else {
      const s3 = this.#St(t18);
      if (!s3) return console.warn("AnimationGroupAPI.fromTo warning: No TJSPosition instance found."), AnimationGroupControl$1.voidControl;
      if (p2 && (a2.index = 0, a2.position = s3, a2.entry = s3 !== t18 ? t18 : void 0), c2 && "function" == typeof e2) {
        if (d2 = e2(a2), null == d2) return AnimationGroupControl$1.voidControl;
        if (!isObject$1(d2)) throw new TypeError("AnimationGroupAPI.fromTo error: 'fromData' callback function failed to return an object.");
      }
      if (l2 && "function" == typeof n2) {
        if (m2 = n2(a2), null == m2) return AnimationGroupControl$1.voidControl;
        if (!isObject$1(m2)) throw new TypeError("AnimationGroupAPI.fromTo error: 'toData' callback function failed to return an object.");
      }
      if (u2 && "function" == typeof o2) {
        if (f2 = o2(a2), null == f2) return AnimationGroupControl$1.voidControl;
        if (!isObject$1(f2)) throw new TypeError("AnimationGroupAPI.fromTo error: 'options' callback function failed to return an object.");
      }
      const h2 = AnimationScheduler$1.fromTo(s3, d2, m2, f2, r2);
      h2 && i2.add(h2);
    }
    return new AnimationGroupControl$1(i2);
  }
  static to(t18, e2, n2) {
    if (!isObject$1(e2) && "function" != typeof e2) throw new TypeError("AnimationGroupAPI.to error: 'toData' is not an object or function.");
    if (void 0 !== n2 && !isObject$1(n2) && "function" != typeof n2) throw new TypeError("AnimationGroupAPI.to error: 'options' is not an object or function.");
    const o2 = /* @__PURE__ */ new Set(), i2 = (t19) => o2.delete(t19.control);
    let r2, a2 = -1;
    const s2 = "function" == typeof e2, c2 = "function" == typeof n2, l2 = s2 || c2;
    l2 && (r2 = { index: a2, position: void 0, entry: void 0 });
    let u2 = e2, p2 = isObject$1(n2) ? n2 : void 0;
    if (isIterable$1(t18)) for (const d2 of t18) {
      a2++;
      const t19 = this.#St(d2);
      if (!t19) {
        console.warn(`AnimationGroupAPI.to warning: No TJSPosition instance found at index: ${a2}.`);
        continue;
      }
      if (l2 && (r2.index = a2, r2.position = t19, r2.entry = t19 !== d2 ? d2 : void 0), s2 && "function" == typeof e2) {
        if (u2 = e2(r2), null == u2) continue;
        if (!isObject$1(u2)) throw new TypeError(`AnimationGroupAPI.to error: 'toData' callback function iteration(${a2}) failed to return an object.`);
      }
      if (c2 && "function" == typeof n2) {
        if (p2 = n2(r2), null == p2) continue;
        if (!isObject$1(p2)) throw new TypeError(`AnimationGroupAPI.to error: 'options' callback function iteration(${a2}) failed to return an object.`);
      }
      const m2 = AnimationScheduler$1.to(t19, u2, p2, i2);
      m2 && o2.add(m2);
    }
    else {
      const a3 = this.#St(t18);
      if (!a3) return console.warn("AnimationGroupAPI.to warning: No TJSPosition instance found."), AnimationGroupControl$1.voidControl;
      if (l2 && (r2.index = 0, r2.position = a3, r2.entry = a3 !== t18 ? t18 : void 0), s2 && "function" == typeof e2) {
        if (u2 = e2(r2), null == u2) return AnimationGroupControl$1.voidControl;
        if (!isObject$1(u2)) throw new TypeError("AnimationGroupAPI.to error: 'toData' callback function failed to return an object.");
      }
      if (c2 && "function" == typeof n2) {
        if (p2 = n2(r2), null == p2) return AnimationGroupControl$1.voidControl;
        if (!isObject$1(p2)) throw new TypeError("AnimationGroupAPI.to error: 'options' callback function failed to return an object.");
      }
      const d2 = AnimationScheduler$1.to(a3, u2, p2, i2);
      d2 && o2.add(d2);
    }
    return new AnimationGroupControl$1(o2);
  }
  static quickTo(t18, e2, n2) {
    if (!isIterable$1(e2)) throw new TypeError("AnimationGroupAPI.quickTo error: 'keys' is not an iterable list.");
    if (void 0 !== n2 && !isObject$1(n2) && "function" != typeof n2) throw new TypeError("AnimationGroupAPI.quickTo error: 'options' is not an object or function.");
    const o2 = [];
    let i2 = -1;
    const r2 = "function" == typeof n2, a2 = { index: i2, position: void 0, entry: void 0 };
    let s2 = isObject$1(n2) ? n2 : void 0;
    if (isIterable$1(t18)) for (const c3 of t18) {
      i2++;
      const t19 = this.#St(c3);
      if (t19) {
        if (a2.index = i2, a2.position = t19, a2.entry = t19 !== c3 ? c3 : void 0, r2 && "function" == typeof n2) {
          if (s2 = n2(a2), null == s2) continue;
          if (!isObject$1(s2)) throw new TypeError(`AnimationGroupAPI.quickTo error: 'options' callback function iteration(${i2}) failed to return an object.`);
        }
        o2.push(t19.animate.quickTo(e2, s2));
      } else console.warn(`AnimationGroupAPI.quickTo warning: No TJSPosition instance found at index: ${i2}.`);
    }
    else {
      const i3 = this.#St(t18);
      if (!i3) return void console.warn("AnimationGroupAPI.quickTo warning: No TJSPosition instance found.");
      if (a2.index = 0, a2.position = i3, a2.entry = i3 !== t18 ? t18 : void 0, r2 && "function" == typeof n2) {
        if (s2 = n2(a2), null == s2) return;
        if (!isObject$1(s2)) throw new TypeError("AnimationGroupAPI.quickTo error: 'options' callback function failed to return an object.");
      }
      o2.push(i3.animate.quickTo(e2, s2));
    }
    const c2 = [...e2];
    Object.freeze(c2);
    const l2 = (...e3) => {
      if (0 !== e3.length) if ("function" == typeof e3[0]) {
        const n3 = e3[0];
        i2 = -1;
        let r3 = 0;
        if (isIterable$1(t18)) for (const e4 of t18) {
          i2++;
          const t19 = this.#St(e4);
          if (!t19) continue;
          a2.index = i2, a2.position = t19, a2.entry = t19 !== e4 ? e4 : void 0;
          const s3 = n3(a2);
          if (null == s3) continue;
          const c3 = isIterable$1(s3);
          if (!Number.isFinite(s3) && !c3 && !isObject$1(s3)) throw new TypeError(`AnimationGroupAPI.quickTo error: 'toData' callback function iteration(${i2}) failed to return a finite number, iterable list, or object.`);
          c3 ? o2[r3++](...s3) : o2[r3++](s3);
        }
        else {
          const e4 = this.#St(t18);
          if (!e4) return;
          a2.index = 0, a2.position = e4, a2.entry = e4 !== t18 ? t18 : void 0;
          const s3 = n3(a2);
          if (null == s3) return;
          const c3 = isIterable$1(s3);
          if (!Number.isFinite(s3) && !c3 && !isObject$1(s3)) throw new TypeError(`AnimationGroupAPI.quickTo error: 'toData' callback function iteration(${i2}) failed to return a finite number, iterable list, or object.`);
          c3 ? o2[r3++](...s3) : o2[r3++](s3);
        }
      } else for (let t19 = o2.length; --t19 >= 0; ) o2[t19](...e3);
    };
    return Object.defineProperty(l2, "keys", { value: c2, writable: false, configurable: false }), Object.defineProperty(l2, "options", { value: (t19) => {
      if (void 0 !== t19 && !isObject$1(t19)) throw new TypeError("AnimationGroupAPI.quickTo error: 'options' is not an object.");
      if (isObject$1(t19)) for (let e3 = o2.length; --e3 >= 0; ) o2[e3].options(t19);
      return l2;
    }, writable: false, configurable: false }), l2;
  }
};
Object.seal(AnimationGroupAPIImpl$1);
let PositionStateAPI$1 = class {
  #it;
  #Tt = /* @__PURE__ */ new Map();
  #vt;
  #kt;
  constructor(t18, e2, n2) {
    this.#vt = t18, this.#it = e2, this.#kt = n2, Object.seal(this);
  }
  clear() {
    for (const t18 of this.#Tt.keys()) "#defaultData" !== t18 && this.#Tt.delete(t18);
  }
  get({ name: t18 }) {
    if ("string" != typeof t18) throw new TypeError("TJSPosition - get error: 'name' is not a string.");
    return this.#Tt.get(t18);
  }
  getDefault() {
    return this.#Tt.get("#defaultData");
  }
  keys() {
    return this.#Tt.keys();
  }
  remove({ name: t18 }) {
    if ("string" != typeof t18) throw new TypeError("TJSPosition - remove: 'name' is not a string.");
    const e2 = this.#Tt.get(t18);
    return this.#Tt.delete(t18), e2;
  }
  reset({ keepZIndex: t18 = false, invokeSet: e2 = true } = {}) {
    const n2 = this.#Tt.get("#defaultData");
    if (!isObject$1(n2)) return false;
    this.#vt.animate.isScheduled && this.#vt.animate.cancel();
    const o2 = this.#vt.zIndex, i2 = Object.assign({}, n2);
    t18 && (i2.zIndex = o2), this.#kt.reset(i2);
    const r2 = this.#vt.parent;
    return r2?.reactive?.minimized && r2?.maximize?.({ animate: false, duration: 0 }), e2 && setTimeout(() => this.#vt.set(i2), 0), true;
  }
  restore({ name: t18, remove: e2 = false, properties: n2, silent: o2 = false, async: i2 = false, animateTo: r2 = false, duration: a2 = 0.1, ease: s2 = "linear" }) {
    if ("string" != typeof t18) throw new TypeError("TJSPosition - restore error: 'name' is not a string.");
    const c2 = this.#Tt.get(t18);
    if (c2) {
      e2 && this.#Tt.delete(t18);
      let l2 = c2;
      if (isIterable$1(n2)) {
        l2 = {};
        for (const t19 of n2) l2[t19] = c2[t19];
      }
      if (o2) {
        for (const t19 in l2) t19 in this.#it && (this.#it[t19] = l2[t19]);
        return c2;
      }
      if (r2) {
        if (l2.transformOrigin !== this.#vt.transformOrigin && (this.#vt.transformOrigin = l2.transformOrigin), i2) return this.#vt.animate.to(l2, { duration: a2, ease: s2 }).finished.then(() => c2);
        this.#vt.animate.to(l2, { duration: a2, ease: s2 });
      } else this.#vt.set(l2);
    }
    return i2 ? Promise.resolve(c2) : c2;
  }
  save({ name: t18, ...e2 }, n2) {
    if ("string" != typeof t18) throw new TypeError("TJSPosition - save error: 'name' is not a string.");
    const o2 = this.#vt.get(e2, n2);
    return this.#Tt.set(t18, o2), o2;
  }
  set({ name: t18, ...e2 }) {
    if ("string" != typeof t18) throw new TypeError("TJSPosition - set error: 'name' is not a string.");
    this.#Tt.set(t18, e2);
  }
}, SystemBase$1 = class {
  #xt;
  #Et;
  #Ot;
  #At;
  #Ct;
  #C = [];
  #Mt;
  constructor({ constrain: t18 = true, element: e2, enabled: n2 = true, lock: o2 = false, width: i2, height: r2 } = {}) {
    this.#xt = true, this.#Ot = true, this.constrain = t18, this.element = e2, this.enabled = n2, this.width = i2, this.height = r2, this.#Ct = "boolean" == typeof o2 && o2;
  }
  get constrain() {
    return this.#xt;
  }
  get element() {
    return this.#Et;
  }
  get enabled() {
    return this.#Ot;
  }
  get height() {
    return this.#At;
  }
  get locked() {
    return this.#Ct;
  }
  get width() {
    return this.#Mt;
  }
  set constrain(t18) {
    if (!this.#Ct) {
      if ("boolean" != typeof t18) throw new TypeError("'constrain' is not a boolean.");
      this.#xt = t18, this.#M();
    }
  }
  set element(t18) {
    if (!this.#Ct) {
      if (null != t18 && !A11yHelper$1.isFocusTarget(t18)) throw new TypeError("'element' is not a HTMLElement, undefined, or null.");
      this.#Et = t18, this.#M();
    }
  }
  set enabled(t18) {
    if (!this.#Ct) {
      if ("boolean" != typeof t18) throw new TypeError("'enabled' is not a boolean.");
      this.#Ot = t18, this.#M();
    }
  }
  set height(t18) {
    if (!this.#Ct) {
      if (void 0 !== t18 && !Number.isFinite(t18)) throw new TypeError("'height' is not a finite number or undefined.");
      this.#At = t18, this.#M();
    }
  }
  set width(t18) {
    if (!this.#Ct) {
      if (void 0 !== t18 && !Number.isFinite(t18)) throw new TypeError("'width' is not a finite number or undefined.");
      this.#Mt = t18, this.#M();
    }
  }
  setDimension(t18, e2) {
    if (!this.#Ct) {
      if (void 0 !== t18 && !Number.isFinite(t18)) throw new TypeError("'width' is not a finite number or undefined.");
      if (this.#Mt = t18, void 0 !== e2 && !Number.isFinite(e2)) throw new TypeError("'height' is not a finite number or undefined.");
      this.#At = e2, this.#M();
    }
  }
  subscribe(t18) {
    return -1 === this.#C.findIndex((e2) => e2 === t18) && (this.#C.push(t18), t18(this)), () => {
      const e2 = this.#C.findIndex((e3) => e3 === t18);
      -1 !== e2 && this.#C.splice(e2, 1);
    };
  }
  #M() {
    for (let t18 = 0; t18 < this.#C.length; t18++) this.#C[t18](this);
  }
}, Centered$1 = class extends SystemBase$1 {
  getLeft(t18) {
    return ((this.width ?? this.element?.offsetWidth ?? globalThis.innerWidth) - t18) / 2;
  }
  getTop(t18) {
    return ((this.height ?? this.element?.offsetHeight ?? globalThis.innerHeight) - t18) / 2;
  }
}, AdapterValidators$1 = class t11 {
  #Ot = true;
  #It;
  #Nt = /* @__PURE__ */ new Map();
  #Pt;
  static create(e2) {
    const n2 = new t11(e2);
    return [n2, n2.#It];
  }
  constructor(t18) {
    this.#It = [], this.#Pt = t18, Object.seal(this);
  }
  get enabled() {
    return this.#Ot;
  }
  get length() {
    return this.#It.length;
  }
  set enabled(t18) {
    if ("boolean" != typeof t18) throw new TypeError("'enabled' is not a boolean.");
    this.#Ot = t18;
  }
  *[Symbol.iterator]() {
    if (0 !== this.#It.length) for (const t18 of this.#It) yield { ...t18 };
  }
  add(...t18) {
    let e2 = 0;
    for (const n2 of t18) {
      const t19 = typeof n2;
      if ("function" !== t19 && "object" !== t19 || null === n2) throw new TypeError("AdapterValidator error: 'validator' is not a function or object.");
      let o2, i2;
      switch (t19) {
        case "function":
          o2 = { id: void 0, validate: n2, weight: 1 }, i2 = n2.subscribe;
          break;
        case "object":
          if (!("validate" in n2)) throw new TypeError("AdapterValidator error: 'validate' attribute is not a function.");
          if ("function" != typeof n2.validate) throw new TypeError("AdapterValidator error: 'validate' attribute is not a function.");
          if (void 0 !== n2.weight && "number" != typeof n2.weight || n2?.weight < 0 || n2?.weight > 1) throw new TypeError("AdapterValidator error: 'weight' attribute is not a number between '0 - 1' inclusive.");
          o2 = { id: void 0 !== n2.id ? n2.id : void 0, validate: n2.validate.bind(n2), weight: n2.weight || 1 }, i2 = n2.validate.subscribe ?? n2.subscribe;
      }
      const r2 = this.#It.findIndex((t20) => o2.weight < t20.weight);
      if (r2 >= 0 ? this.#It.splice(r2, 0, o2) : this.#It.push(o2), "function" == typeof i2) {
        const t20 = i2.call(n2, this.#Pt);
        if ("function" != typeof t20) throw new TypeError("AdapterValidator error: Validator has subscribe function, but no unsubscribe function is returned.");
        if (this.#Nt.has(o2.validate)) throw new Error("AdapterValidator error: Validator added already has an unsubscribe function registered.");
        this.#Nt.set(o2.validate, t20), e2++;
      }
    }
    e2 < t18.length && this.#Pt();
  }
  clear() {
    this.#It.length = 0;
    for (const t18 of this.#Nt.values()) t18();
    this.#Nt.clear(), this.#Pt();
  }
  remove(...t18) {
    const e2 = this.#It.length;
    if (0 !== e2) {
      for (const e3 of t18) {
        const t19 = "function" == typeof e3 ? e3 : isObject$1(e3) ? e3.validate : void 0;
        if (t19) {
          for (let e4 = this.#It.length; --e4 >= 0; ) if (this.#It[e4].validate === t19) {
            let n2;
            this.#It.splice(e4, 1), "function" == typeof (n2 = this.#Nt.get(t19)) && (n2(), this.#Nt.delete(t19));
          }
        }
      }
      e2 !== this.#It.length && this.#Pt();
    }
  }
  removeBy(t18) {
    const e2 = this.#It.length;
    if (0 !== e2) {
      if ("function" != typeof t18) throw new TypeError("AdapterValidator error: 'callback' is not a function.");
      this.#It = this.#It.filter((e3) => {
        const n2 = t18.call(t18, { ...e3 });
        if (n2) {
          let t19;
          "function" == typeof (t19 = this.#Nt.get(e3.validate)) && (t19(), this.#Nt.delete(e3.validate));
        }
        return !n2;
      }), e2 !== this.#It.length && this.#Pt();
    }
  }
  removeById(...t18) {
    const e2 = this.#It.length;
    0 !== e2 && (this.#It = this.#It.filter((e3) => {
      let n2 = false;
      for (const o2 of t18) n2 ||= e3.id === o2;
      if (n2) {
        let t19;
        "function" == typeof (t19 = this.#Nt.get(e3.validate)) && (t19(), this.#Nt.delete(e3.validate));
      }
      return !n2;
    }), e2 !== this.#It.length && this.#Pt());
  }
}, TransformBounds$1 = class t12 extends SystemBase$1 {
  static #Dt = new TJSTransformData$1();
  validate(e2) {
    if (!this.enabled) return e2.position;
    const n2 = this.width ?? this.element?.offsetWidth ?? globalThis.innerWidth, o2 = this.height ?? this.element?.offsetHeight ?? globalThis.innerHeight;
    if ("number" == typeof e2.position.width) {
      const t18 = e2.maxWidth ?? (this.constrain ? n2 : Number.MAX_SAFE_INTEGER);
      e2.position.width = clamp$1(e2.width, e2.minWidth, t18);
    }
    if ("number" == typeof e2.position.height) {
      const t18 = e2.maxHeight ?? (this.constrain ? o2 : Number.MAX_SAFE_INTEGER);
      e2.position.height = clamp$1(e2.height, e2.minHeight, t18);
    }
    const i2 = e2.transforms.getData(e2.position, t12.#Dt, e2), r2 = i2.boundingRect.x, a2 = i2.boundingRect.y, s2 = e2.marginTop ?? 0, c2 = e2.marginLeft ?? 0;
    return i2.boundingRect.bottom + s2 > o2 && (i2.boundingRect.y += o2 - i2.boundingRect.bottom - s2), i2.boundingRect.right + c2 > n2 && (i2.boundingRect.x += n2 - i2.boundingRect.right - c2), i2.boundingRect.top - s2 < 0 && (i2.boundingRect.y += Math.abs(i2.boundingRect.top - s2)), i2.boundingRect.left - c2 < 0 && (i2.boundingRect.x += Math.abs(i2.boundingRect.left - c2)), e2.position.left -= r2 - i2.boundingRect.x, e2.position.top -= a2 - i2.boundingRect.y, e2.position;
  }
}, PositionChangeSet$1 = class {
  left;
  top;
  width;
  height;
  maxHeight;
  maxWidth;
  minHeight;
  minWidth;
  zIndex;
  transform;
  transformOrigin;
  constructor() {
    this.left = false, this.top = false, this.width = false, this.height = false, this.maxHeight = false, this.maxWidth = false, this.minHeight = false, this.minWidth = false, this.zIndex = false, this.transform = false, this.transformOrigin = false;
  }
  hasChange() {
    return this.left || this.top || this.width || this.height || this.maxHeight || this.maxWidth || this.minHeight || this.minWidth || this.zIndex || this.transform || this.transformOrigin;
  }
  set(t18) {
    this.left = t18, this.top = t18, this.width = t18, this.height = t18, this.maxHeight = t18, this.maxWidth = t18, this.minHeight = t18, this.minWidth = t18, this.zIndex = t18, this.transform = t18, this.transformOrigin = t18;
  }
}, UpdateElementData$1 = class {
  changeSet;
  data;
  dataSubscribers;
  dimensionData;
  options;
  queued;
  storeDimension;
  storeTransform;
  styleCache;
  subscribers;
  transforms;
  transformData;
  constructor(t18, e2, n2, o2, i2, r2) {
    this.changeSet = t18, this.data = e2, this.dataSubscribers = Object.seal(new TJSPositionData$1()), this.dimensionData = Object.seal({ width: 0, height: 0 }), this.options = n2, this.queued = false, this.styleCache = o2, this.storeDimension = writable(this.dimensionData), this.subscribers = i2, this.transforms = r2, this.transformData = new TJSTransformData$1(), this.storeTransform = writable(this.transformData, () => (this.options.transformSubscribed = true, () => this.options.transformSubscribed = false));
  }
}, UpdateElementManager$1 = class t13 {
  static list = [];
  static listCntr = 0;
  static updatePromise;
  static add(t18, e2) {
    if (this.listCntr < this.list.length) {
      const n2 = this.list[this.listCntr];
      n2[0] = t18, n2[1] = e2;
    } else this.list.push([t18, e2]);
    return this.listCntr++, e2.queued = true, this.updatePromise || (this.updatePromise = this.wait()), this.updatePromise;
  }
  static async wait() {
    const e2 = await nextAnimationFrame$1();
    this.updatePromise = void 0;
    for (let e3 = this.listCntr; --e3 >= 0; ) {
      const n2 = this.list[e3], o2 = n2[0], i2 = n2[1];
      n2[0] = void 0, n2[1] = void 0, i2.queued = false, o2.isConnected && (i2.options.ortho ? t13.#jt(o2, i2) : t13.#Ft(o2, i2), (i2.options.calculateTransform || i2.options.transformSubscribed) && t13.#Lt(i2), this.updateSubscribers(i2));
    }
    return this.listCntr = 0, e2;
  }
  static immediate(e2, n2) {
    e2.isConnected && (n2.options.ortho ? t13.#jt(e2, n2) : t13.#Ft(e2, n2), (n2.options.calculateTransform || n2.options.transformSubscribed) && t13.#Lt(n2), this.updateSubscribers(n2));
  }
  static updateSubscribers(t18) {
    const e2 = t18.data, n2 = t18.changeSet;
    if (!n2.hasChange()) return;
    const o2 = TJSPositionDataUtil$1.copyData(e2, t18.dataSubscribers), i2 = t18.subscribers;
    if (i2.length > 0) for (let t19 = 0; t19 < i2.length; t19++) i2[t19](o2);
    (n2.width || n2.height) && (t18.dimensionData.width = e2.width, t18.dimensionData.height = e2.height, t18.storeDimension.set(t18.dimensionData)), n2.set(false);
  }
  static #Rt = Object.seal({ height: 0, width: 0, marginLeft: 0, marginTop: 0 });
  static #Ft(t18, e2) {
    const n2 = e2.changeSet, o2 = e2.data;
    n2.left && (t18.style.left = `${o2.left}px`), n2.top && (t18.style.top = `${o2.top}px`), n2.zIndex && (t18.style.zIndex = "number" == typeof o2.zIndex ? `${o2.zIndex}` : ""), n2.width && (t18.style.width = "number" == typeof o2.width ? `${o2.width}px` : o2.width), n2.height && (t18.style.height = "number" == typeof o2.height ? `${o2.height}px` : o2.height), n2.transformOrigin && (t18.style.transformOrigin = o2.transformOrigin), n2.transform && (t18.style.transform = e2.transforms.isActive ? e2.transforms.getCSS() : "");
  }
  static #jt(t18, e2) {
    const n2 = e2.changeSet, o2 = e2.data;
    n2.zIndex && (t18.style.zIndex = "number" == typeof o2.zIndex ? `${o2.zIndex}` : ""), n2.width && (t18.style.width = "number" == typeof o2.width ? `${o2.width}px` : o2.width), n2.height && (t18.style.height = "number" == typeof o2.height ? `${o2.height}px` : o2.height), n2.transformOrigin && (t18.style.transformOrigin = o2.transformOrigin), (n2.left || n2.top || n2.transform) && (t18.style.transform = e2.transforms.getCSSOrtho(o2));
  }
  static #Lt(t18) {
    const e2 = this.#Rt;
    e2.height = "auto" !== t18.data.height && "inherit" !== t18.data.height ? t18.data.height : t18.styleCache.offsetHeight, e2.width = "auto" !== t18.data.width && "inherit" !== t18.data.width ? t18.data.width : t18.styleCache.offsetWidth, e2.marginLeft = t18.styleCache.marginLeft, e2.marginTop = t18.styleCache.marginTop, t18.transforms.getData(t18.data, t18.transformData, e2), t18.storeTransform.set(t18.transformData);
  }
};
var _a$2;
let TJSPosition$1 = class {
  static #zt = Object.freeze({ browserCentered: new Centered$1({ lock: true }), Centered: Centered$1 });
  static #Ht = Object.freeze({ TransformBounds: TransformBounds$1, transformWindow: new TransformBounds$1({ lock: true }) });
  #it = Object.seal(new TJSPositionData$1());
  #Wt = new AnimationAPIImpl$1(this, this.#it);
  #Ot = true;
  #Ut = { calculateTransform: false, initial: void 0, ortho: true, transformSubscribed: false };
  #qt;
  #Gt = new PositionChangeSet$1();
  #Bt = false;
  #l;
  #Jt;
  #C = [];
  #kt = new TJSTransforms$1();
  #Yt;
  #Xt;
  #Vt;
  #It;
  #Kt = new PositionStateAPI$1(this, this.#it, this.#kt);
  static get Animate() {
    return AnimationGroupAPIImpl$1;
  }
  static get Data() {
    return TJSPositionData$1;
  }
  static get Initial() {
    return this.#zt;
  }
  static get SystemBase() {
    return SystemBase$1;
  }
  static get TransformData() {
    return TJSTransformData$1;
  }
  static get Validators() {
    return this.#Ht;
  }
  static get transformOrigins() {
    return TJSTransforms$1.transformOrigins;
  }
  static copyData(t18, e2) {
    return TJSPositionDataUtil$1.copyData(t18, e2);
  }
  static duplicate(t18, e2 = {}) {
    if (!(t18 instanceof _a$2)) throw new TypeError("'position' is not an instance of TJSPosition.");
    const n2 = new _a$2(e2);
    return n2.#Ut = Object.assign({}, t18.#Ut, e2), n2.#Vt.add(...t18.#Vt), n2.set(t18.#it), n2;
  }
  constructor(t18, e2) {
    isPlainObject$1(t18) ? e2 = t18 : this.#qt = t18, this.#Jt = new TJSPositionStyleCache$1();
    const n2 = new UpdateElementData$1(this.#Gt, this.#it, this.#Ut, this.#Jt, this.#C, this.#kt);
    if (this.#Yt = n2, "boolean" == typeof e2?.calculateTransform && (this.#Ut.calculateTransform = e2.calculateTransform), "boolean" == typeof e2?.ortho && (this.#Ut.ortho = e2.ortho), this.#l = Object.freeze({ height: propertyStore$1(this, "height"), left: propertyStore$1(this, "left"), rotateX: propertyStore$1(this, "rotateX"), rotateY: propertyStore$1(this, "rotateY"), rotateZ: propertyStore$1(this, "rotateZ"), scale: propertyStore$1(this, "scale"), top: propertyStore$1(this, "top"), transformOrigin: propertyStore$1(this, "transformOrigin"), translateX: propertyStore$1(this, "translateX"), translateY: propertyStore$1(this, "translateY"), translateZ: propertyStore$1(this, "translateZ"), width: propertyStore$1(this, "width"), zIndex: propertyStore$1(this, "zIndex"), maxHeight: propertyStore$1(this, "maxHeight"), maxWidth: propertyStore$1(this, "maxWidth"), minHeight: propertyStore$1(this, "minHeight"), minWidth: propertyStore$1(this, "minWidth"), dimension: { subscribe: n2.storeDimension.subscribe }, element: { subscribe: this.#Jt.stores.element.subscribe }, resizeContentHeight: { subscribe: this.#Jt.stores.resizeContentHeight.subscribe }, resizeContentWidth: { subscribe: this.#Jt.stores.resizeContentWidth.subscribe }, resizeObservable: { subscribe: this.#Jt.stores.resizeObservable.subscribe }, resizeOffsetHeight: { subscribe: this.#Jt.stores.resizeOffsetHeight.subscribe }, resizeOffsetWidth: { subscribe: this.#Jt.stores.resizeOffsetWidth.subscribe }, transform: { subscribe: n2.storeTransform.subscribe }, resizeObserved: this.#Jt.stores.resizeObserved }), Object.defineProperty(this.#l.transformOrigin, "values", { get: () => _a$2.transformOrigins }), subscribeIgnoreFirst$1(this.#l.resizeObserved, (t19) => {
      const e3 = this.#qt, n3 = A11yHelper$1.isFocusTarget(e3) ? e3 : e3?.elementTarget;
      A11yHelper$1.isFocusTarget(n3) && Number.isFinite(t19?.offsetWidth) && Number.isFinite(t19?.offsetHeight) && this.set();
    }), [this.#Vt, this.#It] = AdapterValidators$1.create(() => this.set()), e2?.initial) {
      const t19 = e2.initial;
      if ("function" != typeof t19?.getLeft || "function" != typeof t19?.getTop) throw new Error("'options.initial' position helper does not contain 'getLeft' and / or 'getTop' functions.");
      this.#Ut.initial = t19;
    }
    if (e2?.validator) if (isIterable$1(e2?.validator)) this.validators.add(...e2.validator);
    else {
      const t19 = e2.validator;
      this.validators.add(t19);
    }
    Object.seal(this), isObject$1(e2) && this.set(e2);
  }
  get animate() {
    return this.#Wt;
  }
  get dimension() {
    return this.#Yt.dimensionData;
  }
  get enabled() {
    return this.#Ot;
  }
  get element() {
    return this.#Jt.el;
  }
  get elementUpdated() {
    return this.#Xt;
  }
  get parent() {
    return this.#qt;
  }
  get state() {
    return this.#Kt;
  }
  get stores() {
    return this.#l;
  }
  get transform() {
    return this.#Yt.transformData;
  }
  get validators() {
    return this.#Vt;
  }
  set enabled(t18) {
    if ("boolean" != typeof t18) throw new TypeError("'enabled' is not a boolean.");
    this.#Ot = t18;
  }
  set parent(t18) {
    if (void 0 !== t18 && !A11yHelper$1.isFocusTarget(t18) && !isObject$1(t18)) throw new TypeError("'parent' is not an HTMLElement, object, or undefined.");
    this.#qt = t18, this.#Kt.remove({ name: "#defaultData" }), this.#Jt.reset(), t18 && this.set(this.#it);
  }
  get height() {
    return this.#it.height;
  }
  get left() {
    return this.#it.left;
  }
  get maxHeight() {
    return this.#it.maxHeight;
  }
  get maxWidth() {
    return this.#it.maxWidth;
  }
  get minHeight() {
    return this.#it.minHeight;
  }
  get minWidth() {
    return this.#it.minWidth;
  }
  get rotateX() {
    return this.#it.rotateX;
  }
  get rotateY() {
    return this.#it.rotateY;
  }
  get rotateZ() {
    return this.#it.rotateZ;
  }
  get rotation() {
    return this.#it.rotateZ;
  }
  get scale() {
    return this.#it.scale;
  }
  get top() {
    return this.#it.top;
  }
  get transformOrigin() {
    return this.#it.transformOrigin;
  }
  get translateX() {
    return this.#it.translateX;
  }
  get translateY() {
    return this.#it.translateY;
  }
  get translateZ() {
    return this.#it.translateZ;
  }
  get width() {
    return this.#it.width;
  }
  get zIndex() {
    return this.#it.zIndex;
  }
  set height(t18) {
    this.#l.height.set(t18);
  }
  set left(t18) {
    this.#l.left.set(t18);
  }
  set maxHeight(t18) {
    this.#l.maxHeight.set(t18);
  }
  set maxWidth(t18) {
    this.#l.maxWidth.set(t18);
  }
  set minHeight(t18) {
    this.#l.minHeight.set(t18);
  }
  set minWidth(t18) {
    this.#l.minWidth.set(t18);
  }
  set rotateX(t18) {
    this.#l.rotateX.set(t18);
  }
  set rotateY(t18) {
    this.#l.rotateY.set(t18);
  }
  set rotateZ(t18) {
    this.#l.rotateZ.set(t18);
  }
  set rotation(t18) {
    this.#l.rotateZ.set(t18);
  }
  set scale(t18) {
    this.#l.scale.set(t18);
  }
  set top(t18) {
    this.#l.top.set(t18);
  }
  set transformOrigin(t18) {
    TJSTransforms$1.transformOrigins.includes(t18) && this.#l.transformOrigin.set(t18);
  }
  set translateX(t18) {
    this.#l.translateX.set(t18);
  }
  set translateY(t18) {
    this.#l.translateY.set(t18);
  }
  set translateZ(t18) {
    this.#l.translateZ.set(t18);
  }
  set width(t18) {
    this.#l.width.set(t18);
  }
  set zIndex(t18) {
    this.#l.zIndex.set(t18);
  }
  get(t18 = {}, e2 = {}) {
    const n2 = e2?.keys, o2 = e2?.exclude, i2 = e2?.nullable ?? true, r2 = e2?.numeric ?? false;
    if (isIterable$1(n2)) {
      for (const e3 of n2) t18[e3] = r2 ? TJSPositionDataUtil$1.getDataOrDefault(this, e3) : this[e3], i2 || null !== t18[e3] || delete t18[e3];
      if (isIterable$1(o2)) for (const e3 of o2) delete t18[e3];
      return t18;
    }
    if (t18 = Object.assign(t18, this.#it), isIterable$1(o2)) for (const e3 of o2) delete t18[e3];
    if (r2 && TJSPositionDataUtil$1.setNumericDefaults(t18), !i2) for (const e3 in t18) null === t18[e3] && delete t18[e3];
    return t18;
  }
  toJSON() {
    return Object.assign({}, this.#it);
  }
  set(t18 = {}, e2 = {}) {
    if (!isObject$1(t18)) throw new TypeError("TJSPosition - set error: 'position' is not an object.");
    const n2 = this.#qt;
    if (!this.#Ot) return this;
    if (void 0 !== n2 && "boolean" == typeof n2?.options?.positionable && !n2?.options?.positionable) return this;
    const o2 = e2?.immediateElementUpdate ?? false, i2 = this.#it, r2 = this.#kt, a2 = A11yHelper$1.isFocusTarget(n2) ? n2 : n2?.elementTarget, s2 = A11yHelper$1.isFocusTarget(a2) && a2.isConnected ? a2 : void 0, c2 = this.#Gt, l2 = this.#Jt;
    if (s2 && (l2.hasData(s2) || (l2.update(s2), l2.hasWillChange, c2.set(true), this.#Yt.queued = false), ConvertStringData$1.process(t18, this.#it, s2), null === (t18 = this.#Zt(t18, n2, s2, l2)))) return this;
    NumberGuard$1.isFinite(t18.left) && (t18.left = Math.round(t18.left), i2.left !== t18.left && (i2.left = t18.left, c2.left = true)), NumberGuard$1.isFinite(t18.top) && (t18.top = Math.round(t18.top), i2.top !== t18.top && (i2.top = t18.top, c2.top = true)), NumberGuard$1.isFiniteOrNull(t18.maxHeight) && (t18.maxHeight = "number" == typeof t18.maxHeight ? Math.round(t18.maxHeight) : null, i2.maxHeight !== t18.maxHeight && (i2.maxHeight = t18.maxHeight, c2.maxHeight = true)), NumberGuard$1.isFiniteOrNull(t18.maxWidth) && (t18.maxWidth = "number" == typeof t18.maxWidth ? Math.round(t18.maxWidth) : null, i2.maxWidth !== t18.maxWidth && (i2.maxWidth = t18.maxWidth, c2.maxWidth = true)), NumberGuard$1.isFiniteOrNull(t18.minHeight) && (t18.minHeight = "number" == typeof t18.minHeight ? Math.round(t18.minHeight) : null, i2.minHeight !== t18.minHeight && (i2.minHeight = t18.minHeight, c2.minHeight = true)), NumberGuard$1.isFiniteOrNull(t18.minWidth) && (t18.minWidth = "number" == typeof t18.minWidth ? Math.round(t18.minWidth) : null, i2.minWidth !== t18.minWidth && (i2.minWidth = t18.minWidth, c2.minWidth = true)), NumberGuard$1.isFiniteOrNull(t18.rotateX) && i2.rotateX !== t18.rotateX && (i2.rotateX = r2.rotateX = t18.rotateX, c2.transform = true), NumberGuard$1.isFiniteOrNull(t18.rotateY) && i2.rotateY !== t18.rotateY && (i2.rotateY = r2.rotateY = t18.rotateY, c2.transform = true), NumberGuard$1.isFiniteOrNull(t18.rotateZ) && i2.rotateZ !== t18.rotateZ && (i2.rotateZ = r2.rotateZ = t18.rotateZ, c2.transform = true), NumberGuard$1.isFiniteOrNull(t18.scale) && (t18.scale = "number" == typeof t18.scale ? clamp$1(t18.scale, 0, 1e3) : null, i2.scale !== t18.scale && (i2.scale = r2.scale = t18.scale, c2.transform = true)), ("string" == typeof t18.transformOrigin && TJSTransforms$1.transformOrigins.includes(t18.transformOrigin) || null === t18.transformOrigin) && i2.transformOrigin !== t18.transformOrigin && (i2.transformOrigin = t18.transformOrigin, c2.transformOrigin = true), NumberGuard$1.isFiniteOrNull(t18.translateX) && i2.translateX !== t18.translateX && (i2.translateX = r2.translateX = t18.translateX, c2.transform = true), NumberGuard$1.isFiniteOrNull(t18.translateY) && i2.translateY !== t18.translateY && (i2.translateY = r2.translateY = t18.translateY, c2.transform = true), NumberGuard$1.isFiniteOrNull(t18.translateZ) && i2.translateZ !== t18.translateZ && (i2.translateZ = r2.translateZ = t18.translateZ, c2.transform = true), NumberGuard$1.isFinite(t18.zIndex) && (t18.zIndex = Math.round(t18.zIndex), i2.zIndex !== t18.zIndex && (i2.zIndex = t18.zIndex, c2.zIndex = true));
    const u2 = "auto" === t18.width || "inherit" === t18.width;
    (NumberGuard$1.isFiniteOrNull(t18.width) || u2) && (t18.width = "number" == typeof t18.width ? Math.round(t18.width) : t18.width, i2.width !== t18.width && (i2.width = t18.width, c2.width = true));
    const p2 = "auto" === t18.height || "inherit" === t18.height;
    (NumberGuard$1.isFiniteOrNull(t18.height) || p2) && (t18.height = "number" == typeof t18.height ? Math.round(t18.height) : t18.height, i2.height !== t18.height && (i2.height = t18.height, c2.height = true));
    const d2 = u2 || p2;
    if (this.#Bt !== d2 && (this.#Bt = d2, this.#Jt.stores.resizeObservable.set(d2)), s2) {
      isObject$1(this.#Kt.getDefault()) || this.#Kt.save({ name: "#defaultData", ...Object.assign({}, i2) }), o2 ? (UpdateElementManager$1.immediate(s2, this.#Yt), this.#Xt = Promise.resolve(globalThis.performance.now())) : this.#Yt.queued || (this.#Xt = UpdateElementManager$1.add(s2, this.#Yt));
    } else UpdateElementManager$1.updateSubscribers(this.#Yt);
    return this;
  }
  subscribe(t18) {
    return -1 === this.#C.findIndex((e2) => e2 === t18) && (this.#C.push(t18), t18(Object.assign({}, this.#it))), () => {
      const e2 = this.#C.findIndex((e3) => e3 === t18);
      -1 !== e2 && this.#C.splice(e2, 1);
    };
  }
  update(t18) {
    const e2 = t18(this.get());
    if (!isObject$1(e2)) throw new TypeError("'result' of 'updater' is not an object.");
    this.set(e2);
  }
  static #Qt = Object.seal(new TJSPositionData$1());
  static #Rt = Object.seal({ position: void 0, parent: void 0, el: void 0, computed: void 0, transforms: void 0, height: void 0, width: void 0, marginLeft: void 0, marginTop: void 0, maxHeight: void 0, maxWidth: void 0, minHeight: void 0, minWidth: void 0, rest: void 0 });
  #Zt({ left: t18, top: e2, maxWidth: n2, maxHeight: o2, minWidth: i2, minHeight: r2, width: a2, height: s2, rotateX: c2, rotateY: l2, rotateZ: u2, scale: p2, transformOrigin: d2, translateX: m2, translateY: f2, translateZ: h2, zIndex: g2, rotation: _, ...$2 }, b2, y2, v2) {
    let w2 = TJSPositionDataUtil$1.copyData(this.#it, _a$2.#Qt);
    if (void 0 !== a2 || "" === y2.style.width) {
      const t19 = null === a2 || Number.isFinite(a2);
      if ("auto" === a2 || "auto" === w2.width && !t19) w2.width = "auto", a2 = v2.offsetWidth;
      else if ("inherit" === a2 || "inherit" === w2.width && !t19) w2.width = "inherit", a2 = v2.offsetWidth;
      else {
        const t20 = NumberGuard$1.isFinite(a2) ? a2 : w2.width;
        w2.width = a2 = NumberGuard$1.isFinite(t20) ? Math.round(t20) : v2.offsetWidth;
      }
    } else a2 = Number.isFinite(w2.width) ? w2.width : v2.offsetWidth;
    if (void 0 !== s2 || "" === y2.style.height) {
      const t19 = null === s2 || Number.isFinite(s2);
      if ("auto" === s2 || "auto" === w2.height && !t19) w2.height = "auto", s2 = v2.offsetHeight;
      else if ("inherit" === s2 || "inherit" === w2.height && !t19) w2.height = "inherit", s2 = v2.offsetHeight;
      else {
        const t20 = NumberGuard$1.isFinite(s2) ? s2 : w2.height;
        w2.height = s2 = NumberGuard$1.isFinite(t20) ? Math.round(t20) : v2.offsetHeight;
      }
    } else s2 = Number.isFinite(w2.height) ? w2.height : v2.offsetHeight;
    NumberGuard$1.isFinite(t18) ? w2.left = t18 : Number.isFinite(w2.left) || (w2.left = "function" == typeof this.#Ut?.initial?.getLeft ? this.#Ut.initial.getLeft(a2) : 0), Number.isFinite(e2) ? w2.top = e2 : Number.isFinite(w2.top) || (w2.top = "function" == typeof this.#Ut?.initial?.getTop ? this.#Ut.initial.getTop(s2) : 0), NumberGuard$1.isFiniteOrNull(o2) && (w2.maxHeight = NumberGuard$1.isFinite(o2) ? Math.round(o2) : null), NumberGuard$1.isFiniteOrNull(n2) && (w2.maxWidth = NumberGuard$1.isFinite(n2) ? Math.round(n2) : null), NumberGuard$1.isFiniteOrNull(r2) && (w2.minHeight = NumberGuard$1.isFinite(r2) ? Math.round(r2) : null), NumberGuard$1.isFiniteOrNull(i2) && (w2.minWidth = NumberGuard$1.isFinite(i2) ? Math.round(i2) : null), NumberGuard$1.isFiniteOrNull(c2) && (w2.rotateX = c2), NumberGuard$1.isFiniteOrNull(l2) && (w2.rotateY = l2), u2 !== w2.rotateZ && NumberGuard$1.isFiniteOrNull(u2) ? w2.rotateZ = u2 : _ !== w2.rotateZ && NumberGuard$1.isFiniteOrNull(_) && (w2.rotateZ = _), NumberGuard$1.isFiniteOrNull(m2) && (w2.translateX = m2), NumberGuard$1.isFiniteOrNull(f2) && (w2.translateY = f2), NumberGuard$1.isFiniteOrNull(h2) && (w2.translateZ = h2), NumberGuard$1.isFiniteOrNull(p2) && (w2.scale = "number" == typeof p2 ? clamp$1(p2, 0, 1e3) : null), "string" != typeof d2 && null !== d2 || (w2.transformOrigin = TJSTransforms$1.transformOrigins.includes(d2) ? d2 : null), NumberGuard$1.isFiniteOrNull(g2) && (w2.zIndex = "number" == typeof g2 ? Math.round(g2) : g2);
    const S2 = this.#It;
    if (this.#Vt.enabled && S2.length) {
      const t19 = _a$2.#Rt;
      t19.parent = b2, t19.el = y2, t19.computed = v2.computed, t19.transforms = this.#kt, t19.height = s2, t19.width = a2, t19.marginLeft = v2.marginLeft, t19.marginTop = v2.marginTop, t19.maxHeight = v2.maxHeight ?? w2.maxHeight, t19.maxWidth = v2.maxWidth ?? w2.maxWidth;
      const e3 = b2?.reactive?.minimized ?? false;
      t19.minHeight = e3 ? w2.minHeight ?? 0 : v2.minHeight || (w2.minHeight ?? 0), t19.minWidth = e3 ? w2.minWidth ?? 0 : v2.minWidth || (w2.minWidth ?? 0);
      for (let e4 = 0; e4 < S2.length; e4++) if (t19.position = w2, t19.rest = $2, w2 = S2[e4].validate(t19), null === w2) return null;
    }
    return w2;
  }
};
function fade(t18, { delay: e2 = 0, duration: n2 = 400, easing: o2 = identity } = {}) {
  const i2 = +getComputedStyle(t18).opacity;
  return { delay: e2, duration: n2, easing: o2, css: (t19) => "opacity: " + t19 * i2 };
}
function slide(t18, { delay: e2 = 0, duration: n2 = 400, easing: o2 = cubicOut, axis: i2 = "y" } = {}) {
  const r2 = getComputedStyle(t18), a2 = +r2.opacity, s2 = "y" === i2 ? "height" : "width", c2 = parseFloat(r2[s2]), l2 = "y" === i2 ? ["top", "bottom"] : ["left", "right"], u2 = l2.map((t19) => `${t19[0].toUpperCase()}${t19.slice(1)}`), p2 = parseFloat(r2[`padding${u2[0]}`]), d2 = parseFloat(r2[`padding${u2[1]}`]), m2 = parseFloat(r2[`margin${u2[0]}`]), f2 = parseFloat(r2[`margin${u2[1]}`]), h2 = parseFloat(r2[`border${u2[0]}Width`]), g2 = parseFloat(r2[`border${u2[1]}Width`]);
  return { delay: e2, duration: n2, easing: o2, css: (t19) => `overflow: hidden;opacity: ${Math.min(20 * t19, 1) * a2};${s2}: ${t19 * c2}px;padding-${l2[0]}: ${t19 * p2}px;padding-${l2[1]}: ${t19 * d2}px;margin-${l2[0]}: ${t19 * m2}px;margin-${l2[1]}: ${t19 * f2}px;border-${l2[0]}-width: ${t19 * h2}px;border-${l2[1]}-width: ${t19 * g2}px;` };
}
_a$2 = TJSPosition$1, "undefined" != typeof window && (window.__svelte || (window.__svelte = { v: /* @__PURE__ */ new Set() })).v.add(PUBLIC_VERSION);
const cssVariables$1 = new TJSStyleManager$1({ docKey: "#__trl-root-styles", version: 1 });
let ResizeObserverManager$1 = class t14 {
  #te = /* @__PURE__ */ new Map();
  #ee;
  static #ne = Object.freeze({ none: 0, attribute: 1, function: 2, resizeObserved: 3, setContentBounds: 4, setDimension: 5, storeObject: 6, storesObject: 7 });
  constructor() {
    this.#ee = new ResizeObserver((e2) => {
      for (const n2 of e2) {
        const e3 = this.#te.get(n2?.target);
        if (Array.isArray(e3)) {
          const o2 = n2.contentRect.width, i2 = n2.contentRect.height;
          for (const n3 of e3) t14.#oe(n3, o2, i2);
        }
      }
    });
  }
  add(e2, n2) {
    if (!CrossWindow$1.isHTMLElement(e2)) throw new TypeError("ResizeObserverManager.add error: 'el' is not a HTMLElement.");
    if (this.#ie(e2, n2)) return;
    const o2 = t14.#re(n2);
    if (0 === o2) throw new Error("ResizeObserverManager.add error: 'target' is not a valid ResizeObserverManager target.");
    const i2 = globalThis.getComputedStyle(e2), r2 = StyleParse$1.pixels(e2.style.borderBottom) ?? StyleParse$1.pixels(i2.borderBottom) ?? 0, a2 = StyleParse$1.pixels(e2.style.borderLeft) ?? StyleParse$1.pixels(i2.borderLeft) ?? 0, s2 = StyleParse$1.pixels(e2.style.borderRight) ?? StyleParse$1.pixels(i2.borderRight) ?? 0, c2 = StyleParse$1.pixels(e2.style.borderTop) ?? StyleParse$1.pixels(i2.borderTop) ?? 0, l2 = StyleParse$1.pixels(e2.style.paddingBottom) ?? StyleParse$1.pixels(i2.paddingBottom) ?? 0, u2 = { updateType: o2, target: n2, contentWidth: 0, contentHeight: 0, styles: { additionalWidth: a2 + s2 + (StyleParse$1.pixels(e2.style.paddingLeft) ?? StyleParse$1.pixels(i2.paddingLeft) ?? 0) + (StyleParse$1.pixels(e2.style.paddingRight) ?? StyleParse$1.pixels(i2.paddingRight) ?? 0), additionalHeight: c2 + r2 + (StyleParse$1.pixels(e2.style.paddingTop) ?? StyleParse$1.pixels(i2.paddingTop) ?? 0) + l2 } };
    if (this.#te.has(e2)) {
      this.#te.get(e2).push(u2);
    } else this.#te.set(e2, [u2]);
    this.#ee.observe(e2);
  }
  clear() {
    for (const t18 of this.#te.keys()) this.#ee.unobserve(t18);
    this.#te.clear();
  }
  remove(t18, e2 = void 0) {
    const n2 = this.#te.get(t18);
    if (Array.isArray(n2)) {
      if (void 0 !== e2) {
        const t19 = n2.findIndex((t20) => t20.target === e2);
        t19 >= 0 && n2.splice(t19, 1);
      } else n2.length = 0;
      0 === n2.length && (this.#te.delete(t18), this.#ee.unobserve(t18));
    }
  }
  updateCache(e2) {
    const n2 = this.#te.get(e2);
    if (Array.isArray(n2)) {
      const o2 = globalThis.getComputedStyle(e2), i2 = StyleParse$1.pixels(e2.style.borderBottom) ?? StyleParse$1.pixels(o2.borderBottom) ?? 0, r2 = StyleParse$1.pixels(e2.style.borderLeft) ?? StyleParse$1.pixels(o2.borderLeft) ?? 0, a2 = StyleParse$1.pixels(e2.style.borderRight) ?? StyleParse$1.pixels(o2.borderRight) ?? 0, s2 = StyleParse$1.pixels(e2.style.borderTop) ?? StyleParse$1.pixels(o2.borderTop) ?? 0, c2 = StyleParse$1.pixels(e2.style.paddingBottom) ?? StyleParse$1.pixels(o2.paddingBottom) ?? 0, l2 = r2 + a2 + (StyleParse$1.pixels(e2.style.paddingLeft) ?? StyleParse$1.pixels(o2.paddingLeft) ?? 0) + (StyleParse$1.pixels(e2.style.paddingRight) ?? StyleParse$1.pixels(o2.paddingRight) ?? 0), u2 = s2 + i2 + (StyleParse$1.pixels(e2.style.paddingTop) ?? StyleParse$1.pixels(o2.paddingTop) ?? 0) + c2;
      for (const e3 of n2) e3.styles.additionalWidth = l2, e3.styles.additionalHeight = u2, t14.#oe(e3, e3.contentWidth, e3.contentHeight);
    }
  }
  static #re(t18) {
    if ("function" == typeof t18?.resizeObserved) return this.#ne.resizeObserved;
    if ("function" == typeof t18?.setDimension) return this.#ne.setDimension;
    if ("function" == typeof t18?.setContentBounds) return this.#ne.setContentBounds;
    const e2 = typeof t18;
    if (null !== e2 && ("object" === e2 || "function" === e2)) {
      if (isWritableStore$1(t18.resizeObserved)) return this.#ne.storeObject;
      const e3 = t18?.stores;
      if ((isObject$1(e3) || "function" == typeof e3) && isWritableStore$1(e3.resizeObserved)) return this.#ne.storesObject;
    }
    return null !== e2 && "object" === e2 ? this.#ne.attribute : "function" === e2 ? this.#ne.function : this.#ne.none;
  }
  #ie(t18, e2) {
    if (null == e2) return false;
    const n2 = this.#te.get(t18);
    return !!Array.isArray(n2) && n2.findIndex((t19) => t19.target === e2) >= 0;
  }
  static #oe(t18, e2, n2) {
    const o2 = t18.styles;
    t18.contentWidth = e2, t18.contentHeight = n2;
    const i2 = Number.isFinite(e2) ? e2 + o2.additionalWidth : void 0, r2 = Number.isFinite(n2) ? n2 + o2.additionalHeight : void 0, a2 = t18.target;
    switch (t18.updateType) {
      case this.#ne.attribute:
        a2.contentWidth = e2, a2.contentHeight = n2, a2.offsetWidth = i2, a2.offsetHeight = r2;
        break;
      case this.#ne.function:
        a2?.(i2, r2, e2, n2);
        break;
      case this.#ne.resizeObserved:
        a2.resizeObserved?.(i2, r2, e2, n2);
        break;
      case this.#ne.setContentBounds:
        a2.setContentBounds?.(e2, n2);
        break;
      case this.#ne.setDimension:
        a2.setDimension?.(i2, r2);
        break;
      case this.#ne.storeObject:
        a2.resizeObserved.update((t19) => (t19.contentHeight = n2, t19.contentWidth = e2, t19.offsetHeight = r2, t19.offsetWidth = i2, t19));
        break;
      case this.#ne.storesObject:
        a2.stores.resizeObserved.update((t19) => (t19.contentHeight = n2, t19.contentWidth = e2, t19.offsetHeight = r2, t19.offsetWidth = i2, t19));
    }
  }
};
const resizeObserverActionManager$1 = new ResizeObserverManager$1();
function resizeObserver$1(t18, e2) {
  return resizeObserverActionManager$1.add(t18, e2), { update: (n2) => {
    resizeObserverActionManager$1.remove(t18, e2), e2 = n2, resizeObserverActionManager$1.add(t18, e2);
  }, destroy: () => {
    resizeObserverActionManager$1.remove(t18, e2);
  } };
}
function applyStyles$1(t18, e2) {
  function n2() {
    if (isObject$1(e2)) for (const n3 of Object.keys(e2)) t18.style.setProperty(`${n3}`, e2[n3]);
  }
  return n2(), { update: (t19) => {
    e2 = t19, n2();
  } };
}
function dynamicAction$1(t18, { action: e2, data: n2 } = {}) {
  let o2;
  return "function" == typeof e2 && (o2 = e2(t18, n2)), { update: (i2) => {
    if (!isObject$1(i2)) return o2?.destroy?.(), e2 = void 0, void (n2 = void 0);
    const { action: r2, data: a2 } = i2;
    if ("function" != typeof r2) return void console.warn("dynamicAction.update warning: Aborting as 'action' is not a function.");
    const s2 = a2 !== n2;
    s2 && (n2 = a2), r2 !== e2 ? (o2?.destroy?.(), o2 = (e2 = r2)(t18, n2)) : s2 && o2?.update?.(n2);
  }, destroy: () => {
    o2?.destroy?.(), e2 = void 0, n2 = void 0, o2 = void 0;
  } };
}
resizeObserver$1.updateCache = function(t18) {
  resizeObserverActionManager$1.updateCache(t18);
};
let TJSDefaultTransition$1 = class {
  static #Ut = {};
  static #ae = () => {
  };
  static get default() {
    return this.#ae;
  }
  static get options() {
    return this.#Ut;
  }
}, AppShellContextInternal$1 = class {
  #l;
  constructor() {
    this.#l = { elementContent: writable(void 0), elementRoot: writable(void 0) }, Object.freeze(this.#l), Object.seal(this);
  }
  get stores() {
    return this.#l;
  }
};
function localize$1(t18, e2) {
  const n2 = isObject$1(e2) ? globalThis.game.i18n.format(t18, e2) : globalThis.game.i18n.localize(t18);
  return void 0 !== n2 ? n2 : "";
}
function create_if_block$1F(t18) {
  let e2, n2;
  return { c() {
    e2 = element("span"), n2 = text(t18[3]), attr(e2, "class", "svelte-mobile-companion-a5e-038vch56tr3-acci"), toggle_class(e2, "has-icon", void 0 !== t18[4]);
  }, m(t19, o2) {
    insert(t19, e2, o2), append(e2, n2);
  }, p(t19, o2) {
    8 & o2 && set_data(n2, t19[3]), 16 & o2 && toggle_class(e2, "has-icon", void 0 !== t19[4]);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_fragment$2Q(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2 = t18[3] && create_if_block$1F(t18);
  return { c() {
    e2 = element("a"), n2 = new HtmlTag(false), o2 = empty(), c2 && c2.c(), n2.a = o2, attr(e2, "class", i2 = "header-button " + t18[0].class + " svelte-mobile-companion-a5e-038vch56tr3-acci"), attr(e2, "aria-label", t18[3]), attr(e2, "tabindex", "0"), attr(e2, "role", "button"), toggle_class(e2, "keep-minimized", t18[2]);
  }, m(i3, l2) {
    insert(i3, e2, l2), n2.m(t18[4], e2), append(e2, o2), c2 && c2.m(e2, null), a2 || (s2 = [listen(e2, "click", stop_propagation(prevent_default(t18[5]))), listen(e2, "contextmenu", stop_propagation(prevent_default(t18[6]))), listen(e2, "keydown", t18[7]), listen(e2, "keyup", t18[8]), action_destroyer(r2 = applyStyles$1.call(null, e2, t18[1]))], a2 = true);
  }, p(t19, [o3]) {
    16 & o3 && n2.p(t19[4]), t19[3] ? c2 ? c2.p(t19, o3) : (c2 = create_if_block$1F(t19), c2.c(), c2.m(e2, null)) : c2 && (c2.d(1), c2 = null), 1 & o3 && i2 !== (i2 = "header-button " + t19[0].class + " svelte-mobile-companion-a5e-038vch56tr3-acci") && attr(e2, "class", i2), 8 & o3 && attr(e2, "aria-label", t19[3]), r2 && is_function(r2.update) && 2 & o3 && r2.update.call(null, t19[1]), 5 & o3 && toggle_class(e2, "keep-minimized", t19[2]);
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2), c2 && c2.d(), a2 = false, run_all(s2);
  } };
}
const s_REGEX_HTML$1 = /^\s*<.*>$/;
function instance$2R(t18, e2, n2) {
  let o2, i2, r2, a2, s2, c2, { button: l2 } = e2;
  return t18.$$set = (t19) => {
    "button" in t19 && n2(0, l2 = t19.button);
  }, t18.$$.update = () => {
    1 & t18.$$.dirty && n2(9, o2 = isObject$1(l2) && "string" == typeof l2.title ? localize$1(l2.title) : ""), 513 & t18.$$.dirty && n2(4, i2 = isObject$1(l2) && "string" != typeof l2.icon ? void 0 : s_REGEX_HTML$1.test(l2.icon) ? l2.icon : `<i class="${l2.icon}" title="${o2}"></i>`), 1 & t18.$$.dirty && n2(3, r2 = isObject$1(l2) && "string" == typeof l2.label ? localize$1(l2.label) : void 0), 1 & t18.$$.dirty && n2(2, a2 = !(!isObject$1(l2) || "boolean" != typeof l2.keepMinimized) && l2.keepMinimized), 1 & t18.$$.dirty && (s2 = isObject$1(l2) && "string" == typeof l2.keyCode ? l2.keyCode : "Enter"), 1 & t18.$$.dirty && n2(1, c2 = isObject$1(l2) && isObject$1(l2.styles) ? l2.styles : void 0);
  }, [l2, c2, a2, r2, i2, function(t19) {
    const e3 = l2?.onPress ?? l2?.onclick;
    "function" == typeof e3 && (e3({ button: l2, event: t19 }), n2(0, l2));
  }, function(t19) {
    "function" === l2?.onContextMenu && (l2.onContextMenu({ button: l2, event: t19 }), n2(0, l2));
  }, function(t19) {
    t19.code === s2 && (t19.preventDefault(), t19.stopPropagation());
  }, function(t19) {
    if (t19.code === s2) {
      const e3 = l2.onPress ?? l2.onclick;
      "function" == typeof e3 && (e3({ button: l2, event: t19 }), n2(0, l2)), t19.preventDefault(), t19.stopPropagation();
    }
  }, o2];
}
let TJSHeaderButton$1 = class extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2R, create_fragment$2Q, safe_not_equal, { button: 0 });
  }
  get button() {
    return this.$$.ctx[0];
  }
  set button(t18) {
    this.$$set({ button: t18 }), flush();
  }
};
function get_each_context$Q(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[31] = e2[n2], o2;
}
function get_each_context_1$3(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[31] = e2[n2], o2;
}
function create_if_block$1E(t18) {
  let e2, n2;
  return { c() {
    e2 = element("img"), attr(e2, "class", "tjs-app-icon keep-minimized svelte-mobile-companion-a5e-038vch56tr3-5lh4qo"), src_url_equal(e2.src, n2 = t18[6]) || attr(e2, "src", n2), attr(e2, "alt", "icon");
  }, m(t19, n3) {
    insert(t19, e2, n3);
  }, p(t19, o2) {
    64 & o2[0] && !src_url_equal(e2.src, n2 = t19[6]) && attr(e2, "src", n2);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_each_block_1$3(t18) {
  let e2, n2, o2;
  const i2 = [t18[31].props];
  var r2 = t18[31].class;
  function a2(t19, e3) {
    let n3 = {};
    for (let t20 = 0; t20 < i2.length; t20 += 1) n3 = assign(n3, i2[t20]);
    return void 0 !== e3 && 2 & e3[0] && (n3 = assign(n3, get_spread_update(i2, [get_spread_object(t19[31].props)]))), { props: n3 };
  }
  return r2 && (e2 = construct_svelte_component(r2, a2(t18))), { c() {
    e2 && create_component(e2.$$.fragment), n2 = empty();
  }, m(t19, i3) {
    e2 && mount_component(e2, t19, i3), insert(t19, n2, i3), o2 = true;
  }, p(t19, o3) {
    if (2 & o3[0] && r2 !== (r2 = t19[31].class)) {
      if (e2) {
        group_outros();
        const t20 = e2;
        transition_out(t20.$$.fragment, 1, 0, () => {
          destroy_component(t20, 1);
        }), check_outros();
      }
      r2 ? (e2 = construct_svelte_component(r2, a2(t19, o3)), create_component(e2.$$.fragment), transition_in(e2.$$.fragment, 1), mount_component(e2, n2.parentNode, n2)) : e2 = null;
    } else if (r2) {
      const n3 = 2 & o3[0] ? get_spread_update(i2, [get_spread_object(t19[31].props)]) : {};
      e2.$set(n3);
    }
  }, i(t19) {
    o2 || (e2 && transition_in(e2.$$.fragment, t19), o2 = true);
  }, o(t19) {
    e2 && transition_out(e2.$$.fragment, t19), o2 = false;
  }, d(t19) {
    t19 && detach(n2), e2 && destroy_component(e2, t19);
  } };
}
function create_each_block$Q(t18) {
  let e2, n2, o2;
  const i2 = [t18[31].props];
  var r2 = t18[31].class;
  function a2(t19, e3) {
    let n3 = {};
    for (let t20 = 0; t20 < i2.length; t20 += 1) n3 = assign(n3, i2[t20]);
    return void 0 !== e3 && 4 & e3[0] && (n3 = assign(n3, get_spread_update(i2, [get_spread_object(t19[31].props)]))), { props: n3 };
  }
  return r2 && (e2 = construct_svelte_component(r2, a2(t18))), { c() {
    e2 && create_component(e2.$$.fragment), n2 = empty();
  }, m(t19, i3) {
    e2 && mount_component(e2, t19, i3), insert(t19, n2, i3), o2 = true;
  }, p(t19, o3) {
    if (4 & o3[0] && r2 !== (r2 = t19[31].class)) {
      if (e2) {
        group_outros();
        const t20 = e2;
        transition_out(t20.$$.fragment, 1, 0, () => {
          destroy_component(t20, 1);
        }), check_outros();
      }
      r2 ? (e2 = construct_svelte_component(r2, a2(t19, o3)), create_component(e2.$$.fragment), transition_in(e2.$$.fragment, 1), mount_component(e2, n2.parentNode, n2)) : e2 = null;
    } else if (r2) {
      const n3 = 4 & o3[0] ? get_spread_update(i2, [get_spread_object(t19[31].props)]) : {};
      e2.$set(n3);
    }
  }, i(t19) {
    o2 || (e2 && transition_in(e2.$$.fragment, t19), o2 = true);
  }, o(t19) {
    e2 && transition_out(e2.$$.fragment, t19), o2 = false;
  }, d(t19) {
    t19 && detach(n2), e2 && destroy_component(e2, t19);
  } };
}
function create_key_block$7(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, m2, f2 = localize$1(t18[7]) + "", h2 = "string" == typeof t18[6] && create_if_block$1E(t18), g2 = ensure_array_like(t18[1]), _ = [];
  for (let e3 = 0; e3 < g2.length; e3 += 1) _[e3] = create_each_block_1$3(get_each_context_1$3(t18, g2, e3));
  const $2 = (t19) => transition_out(_[t19], 1, 1, () => {
    _[t19] = null;
  });
  let b2 = ensure_array_like(t18[2]), y2 = [];
  for (let e3 = 0; e3 < b2.length; e3 += 1) y2[e3] = create_each_block$Q(get_each_context$Q(t18, b2, e3));
  const v2 = (t19) => transition_out(y2[t19], 1, 1, () => {
    y2[t19] = null;
  });
  return { c() {
    e2 = element("header"), h2 && h2.c(), n2 = space(), o2 = element("h4"), i2 = text(f2), r2 = space();
    for (let t19 = 0; t19 < _.length; t19 += 1) _[t19].c();
    a2 = space(), s2 = element("span"), c2 = space();
    for (let t19 = 0; t19 < y2.length; t19 += 1) y2[t19].c();
    attr(o2, "class", "window-title svelte-mobile-companion-a5e-038vch56tr3-5lh4qo"), set_style(o2, "display", t18[4]), attr(s2, "class", "tjs-window-header-spacer keep-minimized svelte-mobile-companion-a5e-038vch56tr3-5lh4qo"), attr(e2, "class", "window-header flexrow svelte-mobile-companion-a5e-038vch56tr3-5lh4qo");
  }, m(f3, g3) {
    insert(f3, e2, g3), h2 && h2.m(e2, null), append(e2, n2), append(e2, o2), append(o2, i2), append(e2, r2);
    for (let t19 = 0; t19 < _.length; t19 += 1) _[t19] && _[t19].m(e2, null);
    append(e2, a2), append(e2, s2), append(e2, c2);
    for (let t19 = 0; t19 < y2.length; t19 += 1) y2[t19] && y2[t19].m(e2, null);
    p2 = true, d2 || (m2 = [listen(e2, "pointerdown", t18[19]), action_destroyer(l2 = t18[0].call(null, e2, t18[3])), action_destroyer(u2 = t18[18].call(null, e2, t18[5]))], d2 = true);
  }, p(t19, r3) {
    if ("string" == typeof t19[6] ? h2 ? h2.p(t19, r3) : (h2 = create_if_block$1E(t19), h2.c(), h2.m(e2, n2)) : h2 && (h2.d(1), h2 = null), (!p2 || 128 & r3[0]) && f2 !== (f2 = localize$1(t19[7]) + "") && set_data(i2, f2), 16 & r3[0] && set_style(o2, "display", t19[4]), 2 & r3[0]) {
      let n3;
      for (g2 = ensure_array_like(t19[1]), n3 = 0; n3 < g2.length; n3 += 1) {
        const o3 = get_each_context_1$3(t19, g2, n3);
        _[n3] ? (_[n3].p(o3, r3), transition_in(_[n3], 1)) : (_[n3] = create_each_block_1$3(o3), _[n3].c(), transition_in(_[n3], 1), _[n3].m(e2, a2));
      }
      for (group_outros(), n3 = g2.length; n3 < _.length; n3 += 1) $2(n3);
      check_outros();
    }
    if (4 & r3[0]) {
      let n3;
      for (b2 = ensure_array_like(t19[2]), n3 = 0; n3 < b2.length; n3 += 1) {
        const o3 = get_each_context$Q(t19, b2, n3);
        y2[n3] ? (y2[n3].p(o3, r3), transition_in(y2[n3], 1)) : (y2[n3] = create_each_block$Q(o3), y2[n3].c(), transition_in(y2[n3], 1), y2[n3].m(e2, null));
      }
      for (group_outros(), n3 = b2.length; n3 < y2.length; n3 += 1) v2(n3);
      check_outros();
    }
    l2 && is_function(l2.update) && 8 & r3[0] && l2.update.call(null, t19[3]), u2 && is_function(u2.update) && 32 & r3[0] && u2.update.call(null, t19[5]);
  }, i(t19) {
    if (!p2) {
      for (let t20 = 0; t20 < g2.length; t20 += 1) transition_in(_[t20]);
      for (let t20 = 0; t20 < b2.length; t20 += 1) transition_in(y2[t20]);
      p2 = true;
    }
  }, o(t19) {
    _ = _.filter(Boolean);
    for (let t20 = 0; t20 < _.length; t20 += 1) transition_out(_[t20]);
    y2 = y2.filter(Boolean);
    for (let t20 = 0; t20 < y2.length; t20 += 1) transition_out(y2[t20]);
    p2 = false;
  }, d(t19) {
    t19 && detach(e2), h2 && h2.d(), destroy_each(_, t19), destroy_each(y2, t19), d2 = false, run_all(m2);
  } };
}
function create_fragment$2P(t18) {
  let e2, n2, o2 = t18[0], i2 = create_key_block$7(t18);
  return { c() {
    i2.c(), e2 = empty();
  }, m(t19, o3) {
    i2.m(t19, o3), insert(t19, e2, o3), n2 = true;
  }, p(t19, n3) {
    1 & n3[0] && safe_not_equal(o2, o2 = t19[0]) ? (group_outros(), transition_out(i2, 1, 1, noop$4), check_outros(), i2 = create_key_block$7(t19), i2.c(), transition_in(i2, 1), i2.m(e2.parentNode, e2)) : i2.p(t19, n3);
  }, i(t19) {
    n2 || (transition_in(i2), n2 = true);
  }, o(t19) {
    transition_out(i2), n2 = false;
  }, d(t19) {
    t19 && detach(e2), i2.d(t19);
  } };
}
function instance$2Q(t18, e2, n2) {
  let o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, { draggable: m2 } = e2, { draggableOptions: f2 } = e2;
  const h2 = getContext("#external")?.application, { focusAuto: g2, focusKeep: _ } = h2.reactive.storeAppOptions;
  component_subscribe(t18, g2, (t19) => n2(26, i2 = t19)), component_subscribe(t18, _, (t19) => n2(25, o2 = t19));
  const { elementRoot: $2 } = getContext("#internal").stores;
  component_subscribe(t18, $2, (t19) => n2(27, r2 = t19));
  const b2 = h2.reactive.storeAppOptions.title;
  component_subscribe(t18, b2, (t19) => n2(7, d2 = t19));
  const y2 = h2.reactive.storeAppOptions.draggable;
  component_subscribe(t18, y2, (t19) => n2(24, l2 = t19));
  const v2 = h2.reactive.storeUIState.dragging, w2 = h2.reactive.storeUIState.headerButtons;
  component_subscribe(t18, w2, (t19) => n2(21, a2 = t19));
  const S2 = h2.reactive.storeAppOptions.headerIcon;
  component_subscribe(t18, S2, (t19) => n2(6, p2 = t19));
  const T2 = h2.reactive.storeAppOptions.headerNoTitleMinimized;
  component_subscribe(t18, T2, (t19) => n2(23, c2 = t19));
  const k2 = h2.reactive.storeAppOptions.minimizable;
  component_subscribe(t18, k2, (t19) => n2(5, u2 = t19));
  const x2 = h2.reactive.storeUIState.minimized;
  component_subscribe(t18, x2, (t19) => n2(22, s2 = t19));
  const E = Object.freeze(["tjs-app-icon", "tjs-window-header-spacer", "window-header", "window-title"]);
  let O2, A2, C2, M;
  return t18.$$set = (t19) => {
    "draggable" in t19 && n2(0, m2 = t19.draggable), "draggableOptions" in t19 && n2(20, f2 = t19.draggableOptions);
  }, t18.$$.update = () => {
    if (1 & t18.$$.dirty[0] && n2(0, m2 = "function" == typeof m2 ? m2 : draggable$1), 17825792 & t18.$$.dirty[0] && n2(3, O2 = Object.assign({}, { tween: true, tweenOptions: { duration: 0.06, ease: "cubicOut" } }, isObject$1(f2) ? f2 : {}, { position: h2.position, enabled: l2, storeDragging: v2, hasTargetClassList: E })), 12582912 & t18.$$.dirty[0] && n2(4, A2 = c2 && s2 ? "none" : null), 2097158 & t18.$$.dirty[0]) {
      n2(1, C2 = []), n2(2, M = []);
      for (const t19 of a2) {
        ("boolean" == typeof t19?.alignLeft && t19?.alignLeft ? C2 : M).push(TJSSvelte$1.config.isConfigEmbed(t19?.svelte) ? { ...t19.svelte } : { class: TJSHeaderButton$1, props: { button: t19 } });
      }
    }
  }, [m2, C2, M, O2, A2, u2, p2, d2, g2, _, $2, b2, y2, w2, S2, T2, k2, x2, function(t19, e3) {
    const n3 = (t20) => {
      (t20.target.classList.contains("window-title") || t20.target.classList.contains("window-header") || t20.target.classList.contains("keep-minimized")) && h2._onToggleMinimize(t20);
    };
    function o3() {
      t19.addEventListener("dblclick", n3);
    }
    function i3() {
      t19.removeEventListener("dblclick", n3);
    }
    return e3 && o3(), { update: (t20) => {
      t20 ? o3() : i3();
    }, destroy: () => i3() };
  }, function(t19) {
    const e3 = r2;
    if (h2.position.animate.cancel(), i2 && A11yHelper$1.isFocusTarget(e3) && e3?.isConnected) if (o2) {
      const n3 = h2.reactive.activeWindow;
      A11yHelper$1.isFocusTarget(n3.document.activeElement) && !e3.contains(n3.document.activeElement) ? e3.focus() : t19.preventDefault();
    } else e3.focus();
  }, f2, a2, s2, c2, l2];
}
let TJSApplicationHeader$1 = class extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2Q, create_fragment$2P, safe_not_equal, { draggable: 0, draggableOptions: 20 }, null, [-1, -1]);
  }
}, ResizeHandleTransform$1 = class {
  static #se = new Mat4$1();
  static #ce = new Vec3$1();
  static #le = new Vec3$1();
  static #ue = new Vec3$1();
  static #pe = new Vec3$1();
  static #de = new Vec3$1();
  static computeDelta(t18, e2, n2, o2, i2) {
    return Mat4$1.invert(this.#se, t18), this.#pe[0] = e2, this.#pe[1] = n2, this.#de[0] = o2, this.#de[1] = i2, Vec3$1.transformMat4(this.#le, this.#pe, this.#se), Vec3$1.transformMat4(this.#ue, this.#de, this.#se), this.#ce[0] = this.#ue[0] - this.#le[0], this.#ce[1] = this.#ue[1] - this.#le[1], this.#ce;
  }
};
function create_fragment$2O(t18) {
  let e2, n2, o2, i2;
  return { c() {
    e2 = element("div"), e2.innerHTML = '<i class="fas fa-arrows-alt-h svelte-mobile-companion-a5e-038vch56tr3-gtiiil"></i>', attr(e2, "class", "window-resizable-handle svelte-mobile-companion-a5e-038vch56tr3-gtiiil");
  }, m(r2, a2) {
    insert(r2, e2, a2), t18[11](e2), o2 || (i2 = [listen(e2, "pointerdown", t18[6]), action_destroyer(n2 = t18[7].call(null, e2, { active: t18[1], storeResizing: t18[5] }))], o2 = true);
  }, p(t19, [e3]) {
    n2 && is_function(n2.update) && 2 & e3 && n2.update.call(null, { active: t19[1], storeResizing: t19[5] });
  }, i: noop$4, o: noop$4, d(n3) {
    n3 && detach(e2), t18[11](null), o2 = false, run_all(i2);
  } };
}
function instance$2P(t18, e2, n2) {
  let o2, i2, r2, { isResizable: a2 = false } = e2;
  const s2 = getContext("#external")?.application, c2 = getContext("#internal").stores.elementRoot;
  component_subscribe(t18, c2, (t19) => n2(9, o2 = t19));
  const l2 = s2.reactive.storeAppOptions.resizable;
  component_subscribe(t18, l2, (t19) => n2(1, r2 = t19));
  const u2 = s2.reactive.storeUIState.minimized;
  component_subscribe(t18, u2, (t19) => n2(10, i2 = t19));
  const p2 = s2.reactive.storeUIState.resizing;
  let d2;
  return t18.$$set = (t19) => {
    "isResizable" in t19 && n2(8, a2 = t19.isResizable);
  }, t18.$$.update = () => {
    if (1793 & t18.$$.dirty && d2) {
      n2(0, d2.style.display = a2 && !i2 ? "block" : "none", d2);
      o2 && o2.classList[a2 ? "add" : "remove"]("resizable");
    }
  }, [d2, r2, c2, l2, u2, p2, function() {
    s2.position.animate.cancel();
  }, function(t19, { active: e3 = true, storeResizing: i3 } = {}) {
    let r3 = null, c3 = false, l3 = 0, u3 = 0;
    const p3 = { resizeDown: ["pointerdown", (e4) => function(e5) {
      e5.preventDefault(), c3 = false, r3 = s2.position.get(), "auto" === r3.height && (r3.height = o2.clientHeight);
      "auto" === r3.width && (r3.width = o2.clientWidth);
      l3 = e5.clientX, u3 = e5.clientY, t19.addEventListener(...p3.resizeMove), t19.addEventListener(...p3.resizeUp), t19.setPointerCapture(e5.pointerId);
    }(e4), false], resizeMove: ["pointermove", (t20) => function(t21) {
      t21.preventDefault(), c3 || "function" != typeof i3?.set || (c3 = true, i3.set(true));
      const e4 = ResizeHandleTransform$1.computeDelta(s2.position.transform.mat4, l3, u3, t21.clientX, t21.clientY);
      s2.position.set({ width: r3.width + e4[0], height: r3.height + e4[1] });
    }(t20), false], resizeUp: ["pointerup", (e4) => function(e5) {
      c3 = false, "function" == typeof i3?.set && i3.set(false);
      e5.preventDefault(), t19.removeEventListener(...p3.resizeMove), t19.removeEventListener(...p3.resizeUp), s2?._onResize?.(e5);
    }(e4), false] };
    function d3() {
      t19.addEventListener(...p3.resizeDown), n2(8, a2 = true), t19.style.display = "block";
    }
    function m2() {
      "function" == typeof i3?.set && i3.set(false), t19.removeEventListener(...p3.resizeDown), t19.removeEventListener(...p3.resizeMove), t19.removeEventListener(...p3.resizeUp), t19.style.display = "none", n2(8, a2 = false);
    }
    return e3 ? d3() : t19.style.display = "none", { update: ({ active: t20 }) => {
      t20 ? d3() : m2();
    }, destroy: () => m2() };
  }, a2, o2, i2, function(t19) {
    binding_callbacks[t19 ? "unshift" : "push"](() => {
      d2 = t19, n2(0, d2), n2(8, a2), n2(10, i2), n2(9, o2);
    });
  }];
}
let ResizableHandle$1 = class extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2P, create_fragment$2O, safe_not_equal, { isResizable: 8 });
  }
};
function create_fragment$2N(t18) {
  let e2, n2, o2;
  return { c() {
    e2 = element("div"), attr(e2, "class", "tjs-focus-wrap svelte-mobile-companion-a5e-038vch56tr3-kjcljd"), attr(e2, "tabindex", "0");
  }, m(i2, r2) {
    insert(i2, e2, r2), t18[4](e2), n2 || (o2 = listen(e2, "focus", t18[1]), n2 = true);
  }, p: noop$4, i: noop$4, o: noop$4, d(i2) {
    i2 && detach(e2), t18[4](null), n2 = false, o2();
  } };
}
function instance$2O(t18, e2, n2) {
  let o2, i2, { elementRoot: r2 } = e2, { enabled: a2 = true } = e2;
  return t18.$$set = (t19) => {
    "elementRoot" in t19 && n2(2, r2 = t19.elementRoot), "enabled" in t19 && n2(3, a2 = t19.enabled);
  }, t18.$$.update = () => {
    1 & t18.$$.dirty && i2 && (o2 = /* @__PURE__ */ new Set([i2]));
  }, [i2, function() {
    if (a2 && A11yHelper$1.isFocusTarget(r2)) {
      const t19 = A11yHelper$1.getFirstFocusableElement(r2, o2);
      A11yHelper$1.isFocusTarget(t19) && t19 !== i2 ? t19.focus() : r2.focus();
    }
  }, r2, a2, function(t19) {
    binding_callbacks[t19 ? "unshift" : "push"](() => {
      i2 = t19, n2(0, i2);
    });
  }];
}
let TJSFocusWrap$1 = class extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2O, create_fragment$2N, safe_not_equal, { elementRoot: 2, enabled: 3 });
  }
};
function create_else_block$g(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, m2, f2, h2, g2, _;
  n2 = new TJSApplicationHeader$1({ props: { draggable: t18[6], draggableOptions: t18[7] } });
  const $2 = t18[37].default, b2 = create_slot($2, t18, t18[36], null);
  return s2 = new ResizableHandle$1({}), l2 = new TJSFocusWrap$1({ props: { elementRoot: t18[1], enabled: t18[11] } }), { c() {
    e2 = element("div"), create_component(n2.$$.fragment), o2 = space(), i2 = element("section"), b2 && b2.c(), a2 = space(), create_component(s2.$$.fragment), c2 = space(), create_component(l2.$$.fragment), attr(i2, "class", "window-content svelte-mobile-companion-a5e-038vch56tr3-90z1oq"), attr(i2, "tabindex", "-1"), attr(e2, "id", u2 = t18[10].id), attr(e2, "class", p2 = "app window-app " + t18[10].options.classes.join(" ") + " svelte-mobile-companion-a5e-038vch56tr3-90z1oq"), attr(e2, "data-appid", d2 = t18[10].appId), attr(e2, "role", "application"), attr(e2, "tabindex", "-1");
  }, m(u3, p3) {
    insert(u3, e2, p3), mount_component(n2, e2, null), append(e2, o2), append(e2, i2), b2 && b2.m(i2, null), t18[40](i2), append(e2, a2), mount_component(s2, e2, null), append(e2, c2), mount_component(l2, e2, null), t18[41](e2), h2 = true, g2 || (_ = [listen(i2, "pointerdown", t18[22]), action_destroyer(r2 = applyStyles$1.call(null, i2, t18[9])), action_destroyer(t18[18].call(null, i2, t18[23])), listen(e2, "close:popup", stop_propagation(prevent_default(t18[19]))), listen(e2, "keydown", t18[20]), listen(e2, "pointerdown", t18[21], true), action_destroyer(m2 = applyStyles$1.call(null, e2, t18[8])), action_destroyer(f2 = dynamicAction$1.call(null, e2, t18[12]))], g2 = true);
  }, p(t19, o3) {
    const i3 = {};
    64 & o3[0] && (i3.draggable = t19[6]), 128 & o3[0] && (i3.draggableOptions = t19[7]), n2.$set(i3), b2 && b2.p && (!h2 || 32 & o3[1]) && update_slot_base(b2, $2, t19, t19[36], h2 ? get_slot_changes($2, t19[36], o3, null) : get_all_dirty_from_scope(t19[36]), null), r2 && is_function(r2.update) && 512 & o3[0] && r2.update.call(null, t19[9]);
    const a3 = {};
    2 & o3[0] && (a3.elementRoot = t19[1]), 2048 & o3[0] && (a3.enabled = t19[11]), l2.$set(a3), (!h2 || 1024 & o3[0] && u2 !== (u2 = t19[10].id)) && attr(e2, "id", u2), (!h2 || 1024 & o3[0] && p2 !== (p2 = "app window-app " + t19[10].options.classes.join(" ") + " svelte-mobile-companion-a5e-038vch56tr3-90z1oq")) && attr(e2, "class", p2), (!h2 || 1024 & o3[0] && d2 !== (d2 = t19[10].appId)) && attr(e2, "data-appid", d2), m2 && is_function(m2.update) && 256 & o3[0] && m2.update.call(null, t19[8]), f2 && is_function(f2.update) && 4096 & o3[0] && f2.update.call(null, t19[12]);
  }, i(t19) {
    h2 || (transition_in(n2.$$.fragment, t19), transition_in(b2, t19), transition_in(s2.$$.fragment, t19), transition_in(l2.$$.fragment, t19), h2 = true);
  }, o(t19) {
    transition_out(n2.$$.fragment, t19), transition_out(b2, t19), transition_out(s2.$$.fragment, t19), transition_out(l2.$$.fragment, t19), h2 = false;
  }, d(o3) {
    o3 && detach(e2), destroy_component(n2), b2 && b2.d(o3), t18[40](null), destroy_component(s2), destroy_component(l2), t18[41](null), g2 = false, run_all(_);
  } };
}
function create_if_block$1D(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, m2, f2, h2, g2, _, $2, b2;
  n2 = new TJSApplicationHeader$1({ props: { draggable: t18[6], draggableOptions: t18[7] } });
  const y2 = t18[37].default, v2 = create_slot(y2, t18, t18[36], null);
  return s2 = new ResizableHandle$1({}), l2 = new TJSFocusWrap$1({ props: { elementRoot: t18[1] } }), { c() {
    e2 = element("div"), create_component(n2.$$.fragment), o2 = space(), i2 = element("section"), v2 && v2.c(), a2 = space(), create_component(s2.$$.fragment), c2 = space(), create_component(l2.$$.fragment), attr(i2, "class", "window-content svelte-mobile-companion-a5e-038vch56tr3-90z1oq"), attr(i2, "tabindex", "-1"), attr(e2, "id", u2 = t18[10].id), attr(e2, "class", p2 = "app window-app " + t18[10].options.classes.join(" ") + " svelte-mobile-companion-a5e-038vch56tr3-90z1oq"), attr(e2, "data-appid", d2 = t18[10].appId), attr(e2, "role", "application"), attr(e2, "tabindex", "-1");
  }, m(u3, p3) {
    insert(u3, e2, p3), mount_component(n2, e2, null), append(e2, o2), append(e2, i2), v2 && v2.m(i2, null), t18[38](i2), append(e2, a2), mount_component(s2, e2, null), append(e2, c2), mount_component(l2, e2, null), t18[39](e2), _ = true, $2 || (b2 = [listen(i2, "pointerdown", t18[22]), action_destroyer(r2 = applyStyles$1.call(null, i2, t18[9])), action_destroyer(t18[18].call(null, i2, t18[23])), listen(e2, "close:popup", stop_propagation(prevent_default(t18[19]))), listen(e2, "keydown", t18[20]), listen(e2, "pointerdown", t18[21], true), action_destroyer(m2 = applyStyles$1.call(null, e2, t18[8])), action_destroyer(f2 = dynamicAction$1.call(null, e2, t18[12]))], $2 = true);
  }, p(o3, i3) {
    t18 = o3;
    const a3 = {};
    64 & i3[0] && (a3.draggable = t18[6]), 128 & i3[0] && (a3.draggableOptions = t18[7]), n2.$set(a3), v2 && v2.p && (!_ || 32 & i3[1]) && update_slot_base(v2, y2, t18, t18[36], _ ? get_slot_changes(y2, t18[36], i3, null) : get_all_dirty_from_scope(t18[36]), null), r2 && is_function(r2.update) && 512 & i3[0] && r2.update.call(null, t18[9]);
    const s3 = {};
    2 & i3[0] && (s3.elementRoot = t18[1]), l2.$set(s3), (!_ || 1024 & i3[0] && u2 !== (u2 = t18[10].id)) && attr(e2, "id", u2), (!_ || 1024 & i3[0] && p2 !== (p2 = "app window-app " + t18[10].options.classes.join(" ") + " svelte-mobile-companion-a5e-038vch56tr3-90z1oq")) && attr(e2, "class", p2), (!_ || 1024 & i3[0] && d2 !== (d2 = t18[10].appId)) && attr(e2, "data-appid", d2), m2 && is_function(m2.update) && 256 & i3[0] && m2.update.call(null, t18[8]), f2 && is_function(f2.update) && 4096 & i3[0] && f2.update.call(null, t18[12]);
  }, i(o3) {
    _ || (transition_in(n2.$$.fragment, o3), transition_in(v2, o3), transition_in(s2.$$.fragment, o3), transition_in(l2.$$.fragment, o3), add_render_callback(() => {
      _ && (g2 && g2.end(1), h2 = create_in_transition(e2, t18[2], t18[4]), h2.start());
    }), _ = true);
  }, o(o3) {
    transition_out(n2.$$.fragment, o3), transition_out(v2, o3), transition_out(s2.$$.fragment, o3), transition_out(l2.$$.fragment, o3), h2 && h2.invalidate(), g2 = create_out_transition(e2, t18[3], t18[5]), _ = false;
  }, d(o3) {
    o3 && detach(e2), destroy_component(n2), v2 && v2.d(o3), t18[38](null), destroy_component(s2), destroy_component(l2), t18[39](null), o3 && g2 && g2.end(), $2 = false, run_all(b2);
  } };
}
function create_fragment$2M(t18) {
  let e2, n2, o2, i2;
  const r2 = [create_if_block$1D, create_else_block$g], a2 = [];
  function s2(t19, e3) {
    return t19[2] !== TJSDefaultTransition$1.default || t19[3] !== TJSDefaultTransition$1.default ? 0 : 1;
  }
  return e2 = s2(t18), n2 = a2[e2] = r2[e2](t18), { c() {
    n2.c(), o2 = empty();
  }, m(t19, n3) {
    a2[e2].m(t19, n3), insert(t19, o2, n3), i2 = true;
  }, p(t19, i3) {
    let c2 = e2;
    e2 = s2(t19), e2 === c2 ? a2[e2].p(t19, i3) : (group_outros(), transition_out(a2[c2], 1, 1, () => {
      a2[c2] = null;
    }), check_outros(), n2 = a2[e2], n2 ? n2.p(t19, i3) : (n2 = a2[e2] = r2[e2](t19), n2.c()), transition_in(n2, 1), n2.m(o2.parentNode, o2));
  }, i(t19) {
    i2 || (transition_in(n2), i2 = true);
  }, o(t19) {
    transition_out(n2), i2 = false;
  }, d(t19) {
    t19 && detach(o2), a2[e2].d(t19);
  } };
}
function instance$2N(t18, e2, n2) {
  let o2, i2, r2, a2, s2, c2, { $$slots: l2 = {}, $$scope: u2 } = e2, { elementContent: p2 } = e2, { elementRoot: d2 } = e2, { draggable: m2 } = e2, { draggableOptions: f2 } = e2, { stylesApp: h2 } = e2, { stylesContent: g2 } = e2;
  const _ = getContext("#external")?.application, { focusAuto: $2, focusKeep: b2, focusTrap: y2 } = _.reactive.storeAppOptions;
  component_subscribe(t18, $2, (t19) => n2(32, r2 = t19)), component_subscribe(t18, b2, (t19) => n2(42, i2 = t19)), component_subscribe(t18, y2, (t19) => n2(34, s2 = t19));
  const { minimized: v2 } = _.reactive.storeUIState;
  component_subscribe(t18, v2, (t19) => n2(33, a2 = t19));
  const { resizeObservable: w2 } = _.position.stores;
  component_subscribe(t18, w2, (t19) => n2(35, c2 = t19));
  let { appOffsetHeight: S2 = false } = e2, { appOffsetWidth: T2 = false } = e2;
  const k2 = !!S2 || !!T2;
  let { contentOffsetHeight: x2 = false } = e2, { contentOffsetWidth: E = false } = e2;
  const O2 = x2 || E ? resizeObserver$1 : () => null, A2 = new AppShellContextInternal$1(), C2 = { ignoreClasses: ["tjs-focus-wrap"] };
  let M;
  setContext("#internal", A2);
  let I2, { transition: N2 = TJSDefaultTransition$1.default } = e2, { inTransition: P2 = TJSDefaultTransition$1.default } = e2, { outTransition: D2 = TJSDefaultTransition$1.default } = e2, { transitionOptions: j2 } = e2, { inTransitionOptions: F2 = TJSDefaultTransition$1.options } = e2, { outTransitionOptions: L2 = TJSDefaultTransition$1.options } = e2, R = TJSDefaultTransition$1.default;
  function z2(t19, e3, o3, i3) {
    _.position.stores.resizeObserved.update((n3) => (n3.contentWidth = o3, n3.contentHeight = i3, n3.offsetWidth = t19, n3.offsetHeight = e3, n3)), n2(24, S2 = e3), n2(25, T2 = t19);
  }
  return onMount(() => d2.focus()), t18.$$set = (t19) => {
    "elementContent" in t19 && n2(0, p2 = t19.elementContent), "elementRoot" in t19 && n2(1, d2 = t19.elementRoot), "draggable" in t19 && n2(6, m2 = t19.draggable), "draggableOptions" in t19 && n2(7, f2 = t19.draggableOptions), "stylesApp" in t19 && n2(8, h2 = t19.stylesApp), "stylesContent" in t19 && n2(9, g2 = t19.stylesContent), "appOffsetHeight" in t19 && n2(24, S2 = t19.appOffsetHeight), "appOffsetWidth" in t19 && n2(25, T2 = t19.appOffsetWidth), "contentOffsetHeight" in t19 && n2(26, x2 = t19.contentOffsetHeight), "contentOffsetWidth" in t19 && n2(27, E = t19.contentOffsetWidth), "transition" in t19 && n2(28, N2 = t19.transition), "inTransition" in t19 && n2(2, P2 = t19.inTransition), "outTransition" in t19 && n2(3, D2 = t19.outTransition), "transitionOptions" in t19 && n2(29, j2 = t19.transitionOptions), "inTransitionOptions" in t19 && n2(4, F2 = t19.inTransitionOptions), "outTransitionOptions" in t19 && n2(5, L2 = t19.outTransitionOptions), "$$scope" in t19 && n2(36, u2 = t19.$$scope);
  }, t18.$$.update = () => {
    if (16 & t18.$$.dirty[1] && n2(12, o2 = k2 || c2 ? { action: resizeObserver$1, data: z2 } : void 0), 1 & t18.$$.dirty[0] && null != p2 && getContext("#internal").stores.elementContent.set(p2), 2 & t18.$$.dirty[0] && null != d2 && getContext("#internal").stores.elementRoot.set(d2), 14 & t18.$$.dirty[1] && n2(11, M = r2 && s2 && !a2), 1342177280 & t18.$$.dirty[0] && R !== N2) {
      const t19 = "function" == typeof N2 ? N2 : TJSDefaultTransition$1.default;
      n2(2, P2 = t19), n2(3, D2 = t19), n2(30, R = t19);
    }
    if (536870912 & t18.$$.dirty[0] | 1 & t18.$$.dirty[1] && I2 !== j2) {
      const t19 = j2 !== TJSDefaultTransition$1.options && isObject$1(j2) ? j2 : TJSDefaultTransition$1.options;
      n2(4, F2 = t19), n2(5, L2 = t19), n2(31, I2 = t19);
    }
    if (4 & t18.$$.dirty[0] && "function" != typeof P2 && n2(2, P2 = TJSDefaultTransition$1.default), 1032 & t18.$$.dirty[0]) {
      "function" != typeof D2 && n2(3, D2 = TJSDefaultTransition$1.default);
      const t19 = _?.options?.defaultCloseAnimation;
      "boolean" == typeof t19 && t19 && D2 !== TJSDefaultTransition$1.default && n2(10, _.options.defaultCloseAnimation = false, _);
    }
    16 & t18.$$.dirty[0] && (isObject$1(F2) || n2(4, F2 = TJSDefaultTransition$1.options)), 32 & t18.$$.dirty[0] && (isObject$1(L2) || n2(5, L2 = TJSDefaultTransition$1.options));
  }, [p2, d2, P2, D2, F2, L2, m2, f2, h2, g2, _, M, o2, $2, b2, y2, v2, w2, O2, function(t19) {
    if (!r2) return;
    const e3 = t19?.detail?.target;
    if (!A11yHelper$1.isFocusTarget(e3)) return;
    if (A11yHelper$1.isFocusable(e3)) return;
    const n3 = d2.contains(e3);
    e3 === d2 ? d2.focus() : e3 === p2 ? p2.focus() : n3 && (p2.contains(e3) ? p2.focus() : d2.focus());
  }, function(t19) {
    if (t19.target !== d2 && t19.target !== p2 || !KeyboardManager || !KeyboardManager?._getMatchingActions?.(KeyboardManager?.getKeyboardEventContext?.(t19))?.length) {
      if (M && t19.shiftKey && "Tab" === t19.code) {
        const e3 = A11yHelper$1.getFocusableElements(d2, C2), n3 = e3.length > 0 ? e3[0] : void 0, o3 = e3.length > 0 ? e3[e3.length - 1] : void 0, i3 = _.reactive.activeWindow;
        d2 !== i3.document.activeElement && n3 !== i3.document.activeElement || (A11yHelper$1.isFocusTarget(o3) && n3 !== o3 && o3.focus(), t19.preventDefault(), t19.stopPropagation());
      }
      "boolean" == typeof _?.options?.popOut && _.options.popOut && _ !== globalThis.ui?.activeWindow && _.bringToTop.call(_);
    } else t19.target?.blur();
  }, function() {
    "boolean" == typeof _?.options?.popOut && _.options.popOut && _ !== globalThis.ui?.activeWindow && _.bringToTop.call(_);
  }, function(t19) {
    if (!A11yHelper$1.isFocusable(t19.target) && r2) if (i2) {
      const e3 = _.reactive.activeWindow;
      !d2.contains(e3.document.activeElement) ? p2.focus() : t19.preventDefault();
    } else p2.focus();
  }, function(t19, e3) {
    n2(27, E = t19), n2(26, x2 = e3);
  }, S2, T2, x2, E, N2, j2, R, I2, r2, a2, s2, c2, u2, l2, function(t19) {
    binding_callbacks[t19 ? "unshift" : "push"](() => {
      p2 = t19, n2(0, p2);
    });
  }, function(t19) {
    binding_callbacks[t19 ? "unshift" : "push"](() => {
      d2 = t19, n2(1, d2);
    });
  }, function(t19) {
    binding_callbacks[t19 ? "unshift" : "push"](() => {
      p2 = t19, n2(0, p2);
    });
  }, function(t19) {
    binding_callbacks[t19 ? "unshift" : "push"](() => {
      d2 = t19, n2(1, d2);
    });
  }];
}
let ApplicationShell$1 = class extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2N, create_fragment$2M, safe_not_equal, { elementContent: 0, elementRoot: 1, draggable: 6, draggableOptions: 7, stylesApp: 8, stylesContent: 9, appOffsetHeight: 24, appOffsetWidth: 25, contentOffsetHeight: 26, contentOffsetWidth: 27, transition: 28, inTransition: 2, outTransition: 3, transitionOptions: 29, inTransitionOptions: 4, outTransitionOptions: 5 }, null, [-1, -1]);
  }
  get elementContent() {
    return this.$$.ctx[0];
  }
  set elementContent(t18) {
    this.$$set({ elementContent: t18 }), flush();
  }
  get elementRoot() {
    return this.$$.ctx[1];
  }
  set elementRoot(t18) {
    this.$$set({ elementRoot: t18 }), flush();
  }
  get draggable() {
    return this.$$.ctx[6];
  }
  set draggable(t18) {
    this.$$set({ draggable: t18 }), flush();
  }
  get draggableOptions() {
    return this.$$.ctx[7];
  }
  set draggableOptions(t18) {
    this.$$set({ draggableOptions: t18 }), flush();
  }
  get stylesApp() {
    return this.$$.ctx[8];
  }
  set stylesApp(t18) {
    this.$$set({ stylesApp: t18 }), flush();
  }
  get stylesContent() {
    return this.$$.ctx[9];
  }
  set stylesContent(t18) {
    this.$$set({ stylesContent: t18 }), flush();
  }
  get appOffsetHeight() {
    return this.$$.ctx[24];
  }
  set appOffsetHeight(t18) {
    this.$$set({ appOffsetHeight: t18 }), flush();
  }
  get appOffsetWidth() {
    return this.$$.ctx[25];
  }
  set appOffsetWidth(t18) {
    this.$$set({ appOffsetWidth: t18 }), flush();
  }
  get contentOffsetHeight() {
    return this.$$.ctx[26];
  }
  set contentOffsetHeight(t18) {
    this.$$set({ contentOffsetHeight: t18 }), flush();
  }
  get contentOffsetWidth() {
    return this.$$.ctx[27];
  }
  set contentOffsetWidth(t18) {
    this.$$set({ contentOffsetWidth: t18 }), flush();
  }
  get transition() {
    return this.$$.ctx[28];
  }
  set transition(t18) {
    this.$$set({ transition: t18 }), flush();
  }
  get inTransition() {
    return this.$$.ctx[2];
  }
  set inTransition(t18) {
    this.$$set({ inTransition: t18 }), flush();
  }
  get outTransition() {
    return this.$$.ctx[3];
  }
  set outTransition(t18) {
    this.$$set({ outTransition: t18 }), flush();
  }
  get transitionOptions() {
    return this.$$.ctx[29];
  }
  set transitionOptions(t18) {
    this.$$set({ transitionOptions: t18 }), flush();
  }
  get inTransitionOptions() {
    return this.$$.ctx[4];
  }
  set inTransitionOptions(t18) {
    this.$$set({ inTransitionOptions: t18 }), flush();
  }
  get outTransitionOptions() {
    return this.$$.ctx[5];
  }
  set outTransitionOptions(t18) {
    this.$$set({ outTransitionOptions: t18 }), flush();
  }
};
cssVariables$1.setProperties({ "--tjs-default-text-shadow-focus-hover": "0 0 8px var(--color-shadow-primary)", "--tjs-app-background": `url("${globalThis.foundry.utils.getRoute("/ui/denim075.png")}")` }, false);
let ApplicationState$1 = class {
  #me;
  #fe;
  #Tt = /* @__PURE__ */ new Map();
  constructor(t18) {
    this.#me = t18, Object.seal(this);
  }
  clear() {
    this.#Tt.clear();
  }
  current(t18 = {}) {
    return Object.assign(t18, { position: this.#me?.position?.get(), beforeMinimized: this.#me?.position?.state.get({ name: "#beforeMinimized" }), options: this.#me?.reactive?.toJSON(), ui: { minimized: this.#me?.reactive?.minimized } });
  }
  get({ name: t18 }) {
    if ("string" != typeof t18) throw new TypeError("[SvelteApp.state.get] error: 'name' is not a string.");
    return this.#Tt.get(t18);
  }
  keys() {
    return this.#Tt.keys();
  }
  remove({ name: t18 }) {
    if ("string" != typeof t18) throw new TypeError("[SvelteApp.state.remove] error: 'name' is not a string.");
    const e2 = this.#Tt.get(t18);
    return this.#Tt.delete(t18), e2;
  }
  restore({ name: t18, remove: e2 = false, animateTo: n2 = false, duration: o2 = 0.1, ease: i2 = "linear" }) {
    if ("string" != typeof t18) throw new TypeError("[SvelteApp.state.restore] error: 'name' is not a string.");
    const r2 = this.#Tt.get(t18);
    return r2 && (e2 && this.#Tt.delete(t18), n2 && t18 !== this.#fe && (this.#fe = t18, this.#he(r2, { animateTo: n2, async: true, duration: o2, ease: i2 }).then(() => {
      t18 === this.#fe && (this.#fe = void 0);
    }))), r2;
  }
  save({ name: t18, ...e2 }) {
    if ("string" != typeof t18) throw new TypeError("[SvelteApp.state.save] error: 'name' is not a string.");
    const n2 = this.current(e2);
    return this.#Tt.set(t18, n2), n2;
  }
  set(t18, e2 = {}) {
    this.#he(t18, { ...e2, async: false });
  }
  #he(t18, { async: e2 = false, animateTo: n2 = false, duration: o2 = 0.1, ease: i2 = "linear" } = {}) {
    if (!isObject$1(t18)) throw new TypeError("[SvelteApp.state.set] error: 'data' is not an object.");
    const r2 = this.#me;
    if (!isObject$1(t18?.position)) return void console.warn("[SvelteApp.state.set] warning: 'data.position' is not an object.");
    const a2 = r2.rendered;
    if (n2) {
      if (!a2) return void console.warn("[SvelteApp.state.set] warning: application is not rendered and 'animateTo' is true.");
      if (t18.position.transformOrigin !== r2.position.transformOrigin && (r2.position.transformOrigin = t18.position.transformOrigin), isObject$1(t18?.ui)) {
        const e3 = "boolean" == typeof t18.ui?.minimized && t18.ui.minimized;
        r2?.reactive?.minimized && !e3 && r2.maximize({ animate: false, duration: 0 });
      }
      const n3 = r2.position.animate.to(t18.position, { duration: o2, ease: i2, strategy: "cancelAll" }).finished.then(({ cancelled: e3 }) => {
        if (!e3) {
          if (isObject$1(t18?.options) && r2?.reactive.mergeOptions(t18.options), isObject$1(t18?.ui)) {
            const e4 = "boolean" == typeof t18.ui?.minimized && t18.ui.minimized;
            !r2?.reactive?.minimized && e4 && r2.minimize({ animate: false, duration: 0 });
          }
          isObject$1(t18?.beforeMinimized) && r2.position.state.set({ name: "#beforeMinimized", ...t18.beforeMinimized });
        }
      });
      if (e2) return n3;
    } else if (a2) {
      if (isObject$1(t18?.options) && r2?.reactive.mergeOptions(t18.options), isObject$1(t18?.ui)) {
        const e3 = "boolean" == typeof t18.ui?.minimized && t18.ui.minimized;
        r2?.reactive?.minimized && !e3 ? r2.maximize({ animate: false, duration: 0 }) : !r2?.reactive?.minimized && e3 && r2.minimize({ animate: false, duration: o2 });
      }
      isObject$1(t18?.beforeMinimized) && r2.position.state.set({ name: "#beforeMinimized", ...t18.beforeMinimized }), r2.position.set(t18.position);
    } else {
      let e3 = t18.position;
      isObject$1(t18.beforeMinimized) && (e3 = t18.beforeMinimized, e3.left = t18.position.left, e3.top = t18.position.top), r2.position.set(e3);
    }
  }
}, GetSvelteData$1 = class {
  #ge;
  #_e;
  constructor(t18, e2) {
    this.#ge = t18, this.#_e = e2;
  }
  get appShell() {
    return this.#ge[0];
  }
  get applicationShell() {
    return this.#ge[0];
  }
  get appShellData() {
    return this.#_e[0];
  }
}, SvelteReactive$1 = class {
  #me;
  #$e = false;
  #be;
  #ye;
  #ve;
  #we;
  #Se;
  #Te;
  #ke = [];
  constructor(t18) {
    this.#me = t18;
    const e2 = t18?.options?.sessionStorage;
    if (void 0 !== e2 && !(e2 instanceof TJSWebStorage$1)) throw new TypeError("'options.sessionStorage' is not an instance of TJSWebStorage.");
    this.#be = void 0 !== e2 ? e2 : new TJSSessionStorage$1();
  }
  initialize() {
    if (!this.#$e) return this.#$e = true, this.#xe(), { appOptionsUpdate: this.#ve, uiStateUpdate: this.#Te, subscribe: this.#Ee.bind(this), unsubscribe: this.#Oe.bind(this) };
  }
  get sessionStorage() {
    return this.#be;
  }
  get storeAppOptions() {
    return this.#ye;
  }
  get storeUIState() {
    return this.#Se;
  }
  get activeWindow() {
    return this.#we.activeWindow ?? globalThis;
  }
  get dragging() {
    return this.#we.dragging;
  }
  get minimized() {
    return this.#we.minimized;
  }
  get resizing() {
    return this.#we.resizing;
  }
  set activeWindow(t18) {
    null != t18 && "[object Window]" !== Object.prototype.toString.call(t18) || this.#Te((e2) => deepMerge$1(e2, { activeWindow: t18 ?? globalThis }));
  }
  get draggable() {
    return this.#me?.options?.draggable;
  }
  get focusAuto() {
    return this.#me?.options?.focusAuto;
  }
  get focusKeep() {
    return this.#me?.options?.focusKeep;
  }
  get focusTrap() {
    return this.#me?.options?.focusTrap;
  }
  get headerButtonNoClose() {
    return this.#me?.options?.headerButtonNoClose;
  }
  get headerButtonNoLabel() {
    return this.#me?.options?.headerButtonNoLabel;
  }
  get headerIcon() {
    return this.#me?.options?.headerIcon;
  }
  get headerNoTitleMinimized() {
    return this.#me?.options?.headerNoTitleMinimized;
  }
  get minimizable() {
    return this.#me?.options?.minimizable;
  }
  get popOut() {
    return this.#me.popOut;
  }
  get positionable() {
    return this.#me?.options?.positionable;
  }
  get resizable() {
    return this.#me?.options?.resizable;
  }
  get title() {
    return this.#me.title;
  }
  set draggable(t18) {
    "boolean" == typeof t18 && this.setOptions("draggable", t18);
  }
  set focusAuto(t18) {
    "boolean" == typeof t18 && this.setOptions("focusAuto", t18);
  }
  set focusKeep(t18) {
    "boolean" == typeof t18 && this.setOptions("focusKeep", t18);
  }
  set focusTrap(t18) {
    "boolean" == typeof t18 && this.setOptions("focusTrap", t18);
  }
  set headerButtonNoClose(t18) {
    "boolean" == typeof t18 && this.setOptions("headerButtonNoClose", t18);
  }
  set headerButtonNoLabel(t18) {
    "boolean" == typeof t18 && this.setOptions("headerButtonNoLabel", t18);
  }
  set headerIcon(t18) {
    void 0 !== t18 && "string" != typeof t18 || this.setOptions("headerIcon", t18);
  }
  set headerNoTitleMinimized(t18) {
    "boolean" == typeof t18 && this.setOptions("headerNoTitleMinimized", t18);
  }
  set minimizable(t18) {
    "boolean" == typeof t18 && this.setOptions("minimizable", t18);
  }
  set popOut(t18) {
    "boolean" == typeof t18 && this.setOptions("popOut", t18);
  }
  set positionable(t18) {
    "boolean" == typeof t18 && this.setOptions("positionable", t18);
  }
  set resizable(t18) {
    "boolean" == typeof t18 && this.setOptions("resizable", t18);
  }
  set title(t18) {
    "string" == typeof t18 ? this.setOptions("title", t18) : null == t18 && this.setOptions("title", "");
  }
  getOptions(t18, e2) {
    return safeAccess$1(this.#me.options, t18, e2);
  }
  mergeOptions(t18) {
    this.#ve((e2) => deepMerge$1(e2, t18));
  }
  setOptions(t18, e2) {
    safeSet$1(this.#me.options, t18, e2, { createMissing: true }) && this.#ve(() => this.#me.options);
  }
  toJSON() {
    return { draggable: this.#me?.options?.draggable ?? true, focusAuto: this.#me?.options?.focusAuto ?? true, focusKeep: this.#me?.options?.focusKeep ?? false, focusTrap: this.#me?.options?.focusTrap ?? true, headerButtonNoClose: this.#me?.options?.headerButtonNoClose ?? false, headerButtonNoLabel: this.#me?.options?.headerButtonNoLabel ?? false, headerNoTitleMinimized: this.#me?.options?.headerNoTitleMinimized ?? false, minimizable: this.#me?.options?.minimizable ?? true, positionable: this.#me?.options?.positionable ?? true, resizable: this.#me?.options?.resizable ?? true };
  }
  updateHeaderButtons({ headerButtonNoClose: t18 = this.#me.options.headerButtonNoClose, headerButtonNoLabel: e2 = this.#me.options.headerButtonNoLabel } = {}) {
    let n2 = this.#me._getHeaderButtons();
    if ("boolean" == typeof t18 && t18 && (n2 = n2.filter((t19) => "close" !== t19.class)), "boolean" == typeof e2 && e2) for (const t19 of n2) t19.label = void 0;
    this.#Te((t19) => (t19.headerButtons = n2, t19));
  }
  #xe() {
    const t18 = writable(this.#me.options);
    this.#ve = t18.update;
    const e2 = { subscribe: t18.subscribe, draggable: propertyStore$1(t18, "draggable"), focusAuto: propertyStore$1(t18, "focusAuto"), focusKeep: propertyStore$1(t18, "focusKeep"), focusTrap: propertyStore$1(t18, "focusTrap"), headerButtonNoClose: propertyStore$1(t18, "headerButtonNoClose"), headerButtonNoLabel: propertyStore$1(t18, "headerButtonNoLabel"), headerIcon: propertyStore$1(t18, "headerIcon"), headerNoTitleMinimized: propertyStore$1(t18, "headerNoTitleMinimized"), minimizable: propertyStore$1(t18, "minimizable"), popOut: propertyStore$1(t18, "popOut"), positionable: propertyStore$1(t18, "positionable"), resizable: propertyStore$1(t18, "resizable"), title: propertyStore$1(t18, "title") };
    Object.freeze(e2), this.#ye = e2, this.#we = { activeWindow: globalThis, dragging: false, headerButtons: [], minimized: this.#me._minimized, resizing: false };
    const n2 = writable(this.#we);
    this.#Te = n2.update;
    const o2 = { subscribe: n2.subscribe, activeWindow: derived(n2, (t19, e3) => e3(t19.activeWindow)), dragging: propertyStore$1(n2, "dragging"), headerButtons: derived(n2, (t19, e3) => e3(t19.headerButtons)), minimized: derived(n2, (t19, e3) => e3(t19.minimized)), resizing: propertyStore$1(n2, "resizing") };
    Object.freeze(o2), this.#Se = o2;
  }
  #Ee() {
    this.#ke.push(subscribeIgnoreFirst$1(this.#ye.headerButtonNoClose, (t18) => {
      this.updateHeaderButtons({ headerButtonNoClose: t18 });
    })), this.#ke.push(subscribeIgnoreFirst$1(this.#ye.headerButtonNoLabel, (t18) => {
      this.updateHeaderButtons({ headerButtonNoLabel: t18 });
    })), this.#ke.push(subscribeIgnoreFirst$1(this.#ye.popOut, (t18) => {
      t18 && this.#me.rendered ? globalThis.ui.windows[this.#me.appId] = this.#me : delete globalThis.ui.windows[this.#me.appId];
    }));
  }
  #Oe() {
    this.#ke.forEach((t18) => t18()), this.#ke = [];
  }
};
const applicationShellContract$1 = ["elementRoot"];
function isApplicationShell$1(t18) {
  if (null == t18) return false;
  let e2 = true, n2 = true;
  for (const n3 of applicationShellContract$1) {
    const o3 = Object.getOwnPropertyDescriptor(t18, n3);
    void 0 !== o3 && void 0 !== o3.get && void 0 !== o3.set || (e2 = false);
  }
  const o2 = Object.getPrototypeOf(t18);
  for (const t19 of applicationShellContract$1) {
    const e3 = Object.getOwnPropertyDescriptor(o2, t19);
    void 0 !== e3 && void 0 !== e3.get && void 0 !== e3.set || (n2 = false);
  }
  return e2 || n2;
}
function loadSvelteConfig$1({ app: t18, config: e2, elementRootUpdate: n2 } = {}) {
  let o2;
  if (CrossWindow$1.isHTMLElement(e2.target)) o2 = e2.target;
  else if ("string" == typeof e2.target) {
    const n3 = t18?.reactive?.activeWindow;
    o2 = n3?.document?.querySelector(e2.target);
  }
  if (!CrossWindow$1.isHTMLElement(o2)) throw e2.target, new Error();
  const i2 = e2.class, r2 = TJSSvelte$1.config.parseConfig({ ...e2, target: o2 }, { contextExternal: true, thisArg: t18 }), a2 = r2.context.get("#external");
  let s2;
  a2.application = t18, a2.elementRootUpdate = n2, a2.sessionStorage = t18.reactive.sessionStorage, isObject$1(t18._eventbus) && "function" == typeof t18._eventbus.createProxy && (s2 = t18._eventbus.createProxy(), a2.eventbus = s2), Object.seal(a2);
  const c2 = new i2(r2);
  let l2;
  if (r2.eventbus = s2, isApplicationShell$1(c2) && (l2 = c2.elementRoot), !CrossWindow$1.isHTMLElement(l2)) throw new Error();
  return { config: r2, component: c2, element: l2 };
}
Object.freeze(applicationShellContract$1);
let TJSAppIndex$1 = class {
  static #Ae = /* @__PURE__ */ new Map();
  static add(t18) {
    this.#Ae.set(t18.id, t18);
  }
  static delete(t18) {
    this.#Ae.delete(t18.id);
  }
  static get(t18) {
    return this.#Ae.get(t18);
  }
  static has(t18) {
    return this.#Ae.has(t18);
  }
  static keys() {
    return this.#Ae.keys();
  }
  static values() {
    return this.#Ae.values();
  }
}, SvelteApp$1 = class extends Application {
  #ge = [null];
  #Ce;
  #Me = null;
  #Ie = null;
  #Ne = false;
  #Pe = 95;
  #De = false;
  #vt;
  #je;
  #_e = [null];
  #Fe = new GetSvelteData$1(this.#ge, this.#_e);
  #l;
  constructor(t18 = {}) {
    if (super(t18), !isObject$1(this.options.svelte)) throw new Error("SvelteApp - constructor - No Svelte configuration object found in 'options'.");
    this.#Ce = new ApplicationState$1(this), this.#vt = new TJSPosition$1(this, { ...this.position, ...this.options, initial: this.options.positionInitial, ortho: this.options.positionOrtho, validator: this.options.positionValidator }), delete this.position, Object.defineProperty(this, "position", { get: () => this.#vt, set: (t19) => {
      isObject$1(t19) && this.#vt.set(t19);
    } }), this.#je = new SvelteReactive$1(this), this.#l = this.#je.initialize();
  }
  static get defaultOptions() {
    return deepMerge$1(super.defaultOptions, { defaultCloseAnimation: true, draggable: true, focusAuto: true, focusKeep: false, focusSource: void 0, focusTrap: true, headerButtonNoClose: false, headerButtonNoLabel: false, headerIcon: void 0, headerNoTitleMinimized: false, minHeight: MIN_WINDOW_HEIGHT, minWidth: MIN_WINDOW_WIDTH, positionable: true, positionInitial: TJSPosition$1.Initial.browserCentered, positionOrtho: true, positionValidator: TJSPosition$1.Validators.transformWindow, sessionStorage: void 0, svelte: void 0, transformOrigin: "top left" });
  }
  get elementContent() {
    return this.#Ie;
  }
  get elementTarget() {
    return this.#Me;
  }
  get reactive() {
    return this.#je;
  }
  get state() {
    return this.#Ce;
  }
  get svelte() {
    return this.#Fe;
  }
  _activateCoreListeners(t18) {
    super._activateCoreListeners("string" == typeof this.options.template ? t18 : [this.popOut ? this.#Me?.firstChild : this.#Me]);
  }
  bringToTop({ focus: t18 = true, force: e2 = false } = {}) {
    if (this.reactive.activeWindow !== globalThis) return;
    (e2 || this.popOut) && super.bringToTop();
    const n2 = this.elementTarget, o2 = document.activeElement;
    t18 && n2 && o2 !== n2 && !n2?.contains(o2) && (A11yHelper$1.isFocusTarget(o2) && o2.blur(), n2?.focus()), globalThis.ui.activeWindow = this;
  }
  async close(t18 = {}) {
    const e2 = Application.RENDER_STATES;
    if (!t18.force && ![e2.RENDERED, e2.ERROR].includes(this._state)) return;
    const n2 = this.#Me;
    if (!n2) return void (this._state = e2.CLOSED);
    if (CrossWindow$1.getWindow(n2, { throws: false }) !== globalThis) return;
    this._state = e2.CLOSING, this.#l.unsubscribe();
    const o2 = n2.querySelector(".window-content");
    if (o2) {
      o2.style.overflow = "hidden";
      for (let t19 = o2.children.length; --t19 >= 0; ) o2.children[t19].style.overflow = "hidden";
    }
    for (const t19 of this.constructor._getInheritanceChain()) Hooks.call(`close${t19.name}`, this, $(n2));
    if ("boolean" != typeof this.options.defaultCloseAnimation || this.options.defaultCloseAnimation) {
      n2.style.minHeight = "0";
      const { paddingBottom: t19, paddingTop: e3 } = globalThis.getComputedStyle(n2);
      await n2.animate([{ maxHeight: `${n2.clientHeight}px`, paddingTop: e3, paddingBottom: t19 }, { maxHeight: 0, paddingTop: 0, paddingBottom: 0 }], { duration: 250, easing: "ease-in", fill: "forwards" }).finished;
    }
    const i2 = [];
    for (const t19 of this.#_e) {
      if (!isObject$1(t19)) continue;
      i2.push(TJSSvelte$1.util.outroAndDestroy(t19.component));
      const e3 = t19.config.eventbus;
      isObject$1(e3) && "function" == typeof e3.off && (e3.off(), t19.config.eventbus = void 0);
    }
    await Promise.allSettled(i2), TJSAppIndex$1.delete(this), this.#_e[0] = null, n2.remove(), this.position.state.restore({ name: "#beforeMinimized", properties: ["width", "height"], silent: true, remove: true }), this.#ge[0] = null, this._element = null, this.#Ie = null, this.#Me = null, delete globalThis.ui.windows[this.appId], this._minimized = false, this._scrollPositions = null, this._state = e2.CLOSED, this.#De = false, this.#l.uiStateUpdate((t19) => deepMerge$1(t19, { minimized: this._minimized })), A11yHelper$1.applyFocusSource(this.options.focusSource), delete this.options.focusSource;
  }
  _getHeaderButtons() {
    return super._getHeaderButtons();
  }
  _injectHTML() {
    this.reactive.updateHeaderButtons();
    if (!isObject$1(this.options.svelte)) throw new Error("SvelteApp - _injectHTML - No Svelte configuration object found in 'options'.");
    const t18 = loadSvelteConfig$1({ app: this, config: this.options.svelte, elementRootUpdate: () => {
      let t19 = 0;
      return (e2) => null != e2 && t19++ > 0 && (this.#Le(), true);
    } });
    if (null !== this.svelte.appShell) throw new Error(`SvelteApp - _injectHTML - An application shell is already mounted; offending config:
${JSON.stringify(this.options.svelte)}`);
    this.#ge[0] = t18.component, TJSSvelte$1.util.isHMRProxy(t18.component) && Array.isArray(t18.component?.$$?.on_hmr) && t18.component.$$.on_hmr.push(() => () => this.#Le()), this.#_e[0] = t18, this._element = $(this.svelte.appShell.elementRoot), this.#Ie = hasGetter$1(this.svelte.appShell, "elementContent") ? this.svelte.appShell.elementContent : null, this.#Me = hasGetter$1(this.svelte.appShell, "elementTarget") ? this.svelte.appShell.elementTarget : this.svelte.appShell.elementRoot, "boolean" == typeof this.options.positionable && this.options.positionable && (this.#Me.style.zIndex = "number" == typeof this.options.zIndex ? this.options.zIndex : this.#Pe ?? 95), this.#l.subscribe();
  }
  async maximize({ animate: t18 = true, duration: e2 = 0.1 } = {}) {
    if (!this.popOut || [false, null].includes(this._minimized)) return;
    this._minimized = null;
    const n2 = 1e3 * e2, o2 = this.elementTarget, i2 = o2.querySelector(".window-header"), r2 = o2.querySelector(".window-content"), a2 = this.position.state.get({ name: "#beforeMinimized" });
    t18 && await this.position.state.restore({ name: "#beforeMinimized", async: true, animateTo: true, properties: ["width"], duration: 0.1 }), o2.classList.remove("minimized");
    for (let t19 = i2.children.length; --t19 >= 0; ) i2.children[t19].style.display = null;
    let s2;
    r2.style.display = null, { constraints: s2 } = t18 ? this.position.state.restore({ name: "#beforeMinimized", animateTo: true, properties: ["height"], remove: true, duration: e2 }) : this.position.state.remove({ name: "#beforeMinimized" }), await r2.animate([{ maxHeight: 0, paddingTop: 0, paddingBottom: 0, offset: 0 }, { ...s2, offset: 1 }, { maxHeight: "100%", offset: 1 }], { duration: n2, fill: "forwards" }).finished, this.position.set({ minHeight: a2.minHeight ?? this.options?.minHeight ?? MIN_WINDOW_HEIGHT, minWidth: a2.minWidth ?? this.options?.minWidth ?? MIN_WINDOW_WIDTH }), o2.style.minWidth = null, o2.style.minHeight = null, this._minimized = false, setTimeout(() => {
      r2.style.overflow = null;
      for (let t19 = r2.children.length; --t19 >= 0; ) r2.children[t19].style.overflow = null;
    }, 50), this.#l.uiStateUpdate((t19) => deepMerge$1(t19, { minimized: false }));
  }
  async minimize({ animate: t18 = true, duration: e2 = 0.1 } = {}) {
    if (!this.rendered || !this.popOut || [true, null].includes(this._minimized)) return;
    this.#l.uiStateUpdate((t19) => deepMerge$1(t19, { minimized: true })), this._minimized = null;
    const n2 = 1e3 * e2, o2 = this.elementTarget, i2 = o2.querySelector(".window-header"), r2 = o2.querySelector(".window-content"), a2 = this.position.minWidth, s2 = this.position.minHeight;
    if (this.position.set({ minWidth: 100, minHeight: 30 }), o2.style.minWidth = "100px", o2.style.minHeight = "30px", r2) {
      r2.style.overflow = "hidden";
      for (let t19 = r2.children.length; --t19 >= 0; ) r2.children[t19].style.overflow = "hidden";
    }
    const { paddingBottom: c2, paddingTop: l2 } = globalThis.getComputedStyle(r2), u2 = { maxHeight: `${r2.clientHeight}px`, paddingTop: l2, paddingBottom: c2 };
    if (t18) {
      r2.animate([u2, { maxHeight: 0, paddingTop: 0, paddingBottom: 0 }], { duration: n2, fill: "forwards" }).finished.then(() => r2.style.display = "none");
    } else setTimeout(() => r2.style.display = "none", n2);
    const p2 = this.position.state.save({ name: "#beforeMinimized", constraints: u2 });
    p2.minWidth = a2, p2.minHeight = s2;
    const d2 = i2.offsetHeight;
    this.position.minHeight = d2, t18 && await this.position.animate.to({ height: d2 }, { duration: e2 }).finished;
    for (let t19 = i2.children.length; --t19 >= 0; ) {
      const e3 = i2.children[t19].className;
      e3.includes("window-title") || e3.includes("close") || (e3.includes("keep-minimized") ? i2.children[t19].style.display = "block" : i2.children[t19].style.display = "none");
    }
    t18 && await this.position.animate.to({ width: MIN_WINDOW_WIDTH }, { duration: 0.1 }).finished, o2.classList.add("minimized"), this._minimized = true;
  }
  onSvelteMount() {
  }
  onSvelteRemount() {
  }
  _replaceHTML(t18, e2) {
    t18.length && this.reactive.updateHeaderButtons();
  }
  async _render(t18 = false, e2 = {}) {
    isObject$1(e2?.focusSource) && (this.options.focusSource = e2.focusSource);
    const n2 = this.reactive.activeWindow;
    try {
      if (this._state === Application.RENDER_STATES.NONE && A11yHelper$1.isFocusTarget(n2.document.querySelector(`#${this.id}`))) return void console.warn(`SvelteApp - _render: A DOM element already exists for CSS ID '${this.id}'. Cancelling initial render for new application with appId '${this.appId}'.`);
    } catch (t19) {
      return void console.warn(`SvelteApp - _render: Potentially malformed application ID '${this.id}'. Cancelling initial render for new application with appId '${this.appId}'.`);
    }
    this.#Ne = true, await super._render(t18, e2), this.#Ne = false, [Application.RENDER_STATES.CLOSING, Application.RENDER_STATES.RENDERING].includes(this._state) || !t18 && this._state <= Application.RENDER_STATES.NONE || (this._minimized || this.#vt.set({ left: "string" == typeof this.options?.left ? this.options.left : void 0, height: "string" == typeof this.options?.height ? this.options.height : void 0, maxHeight: "string" == typeof this.options?.maxHeight ? this.options.maxHeight : void 0, maxWidth: "string" == typeof this.options?.maxWidth ? this.options.maxWidth : void 0, minHeight: "string" == typeof this.options?.minHeight ? this.options.minHeight : void 0, minWidth: "string" == typeof this.options?.minWidth ? this.options.minWidth : void 0, rotateX: "string" == typeof this.options?.rotateX ? this.options.rotateX : void 0, rotateY: "string" == typeof this.options?.rotateY ? this.options.rotateY : void 0, rotateZ: "string" == typeof this.options?.rotateZ ? this.options.rotateZ : void 0, rotation: "string" == typeof this.options?.rotation ? this.options.rotation : void 0, top: "string" == typeof this.options?.top ? this.options.top : void 0, width: "string" == typeof this.options?.width ? this.options.width : void 0, ...e2 }), this.#De || (TJSAppIndex$1.add(this), this.onSvelteMount(), this.#De = true));
  }
  async _renderInner() {
    const t18 = this.reactive.activeWindow.document.createDocumentFragment();
    return $(t18);
  }
  async _renderOuter() {
    const t18 = await super._renderOuter();
    return this.#Pe = t18[0].style.zIndex, t18;
  }
  setPosition(t18) {
    return this.#Ne ? this.position : this.position.set(t18);
  }
  #Le() {
    const t18 = this.svelte.appShell;
    null !== t18 && (this._element = $(t18.elementRoot), this.#Ie = hasGetter$1(t18, "elementContent") ? t18.elementContent : null, this.#Me = hasGetter$1(t18, "elementTarget") ? t18.elementTarget : null, null === this.#Me && (this.#Me = "string" == typeof this.options.selectorTarget ? this._element[0].querySelector(this.options.selectorTarget) : this._element[0]), "boolean" == typeof this.options.positionable && this.options.positionable && (this.#Me.style.zIndex = "number" == typeof this.options.zIndex ? this.options.zIndex : this.#Pe ?? 95, super.bringToTop(), this.position.set(this.position.get())), super._activateCoreListeners([this.popOut ? this.#Me?.firstChild : this.#Me]), this.onSvelteRemount());
  }
}, PopoutSupport$1 = class {
  static initialize() {
    Hooks.on("PopOut:loading", (t18, e2) => {
      t18 instanceof SvelteApp$1 && (t18.position.enabled = false, t18.state.save({ name: "#beforePopout", headerButtonNoClose: t18.reactive.headerButtonNoClose }), t18.reactive.activeWindow = e2, t18.reactive.headerButtonNoClose = true);
    }), Hooks.on("PopOut:popin", (t18) => this.#Re(t18)), Hooks.on("PopOut:close", (t18) => this.#Re(t18));
  }
  static #Re(t18) {
    if (t18 instanceof SvelteApp$1) {
      t18.position.enabled = true;
      const e2 = t18.state.remove({ name: "#beforePopout" });
      e2 && (t18.reactive.headerButtonNoClose = e2?.headerButtonNoClose ?? false), t18.reactive.activeWindow = void 0;
    }
  }
};
function get_each_context$P(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[9] = e2[n2], o2[10] = e2, o2[11] = n2, o2;
}
function create_each_block$P(t18, e2) {
  let n2, o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, m2, f2, h2, g2 = e2[9].name + "";
  function _() {
    e2[4].call(c2, e2[10], e2[11]);
  }
  function $2() {
    e2[5].call(p2, e2[10], e2[11]);
  }
  return { key: t18, first: null, c() {
    n2 = element("li"), o2 = element("div"), i2 = element("h4"), r2 = text(g2), a2 = space(), s2 = element("div"), c2 = element("input"), l2 = space(), u2 = element("div"), p2 = element("input"), m2 = space(), attr(c2, "type", "checkbox"), attr(p2, "type", "number"), p2.disabled = d2 = !e2[9].enabled, attr(n2, "class", "item svelte-mobile-companion-a5e-038vch56tr3-1jj7tri"), attr(n2, "data-item-id", this.id), this.first = n2;
  }, m(t19, d3) {
    insert(t19, n2, d3), append(n2, o2), append(o2, i2), append(i2, r2), append(n2, a2), append(n2, s2), append(s2, c2), c2.checked = e2[9].enabled, append(n2, l2), append(n2, u2), append(u2, p2), set_input_value(p2, e2[9].screenWidth), append(n2, m2), f2 || (h2 = [listen(c2, "change", _), listen(p2, "input", $2)], f2 = true);
  }, p(t19, n3) {
    e2 = t19, 2 & n3 && g2 !== (g2 = e2[9].name + "") && set_data(r2, g2), 2 & n3 && (c2.checked = e2[9].enabled), 2 & n3 && d2 !== (d2 = !e2[9].enabled) && (p2.disabled = d2), 2 & n3 && to_number(p2.value) !== e2[9].screenWidth && set_input_value(p2, e2[9].screenWidth);
  }, d(t19) {
    t19 && detach(n2), f2 = false, run_all(h2);
  } };
}
function create_default_slot$s(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, m2 = [], f2 = /* @__PURE__ */ new Map(), h2 = ensure_array_like(t18[1]);
  const g2 = (t19) => t19[9].id;
  for (let e3 = 0; e3 < h2.length; e3 += 1) {
    let n3 = get_each_context$P(t18, h2, e3), o3 = g2(n3);
    f2.set(o3, m2[e3] = create_each_block$P(o3, n3));
  }
  return { c() {
    e2 = element("form"), n2 = element("div"), o2 = element("ol"), i2 = element("li"), i2.innerHTML = "<div>Player</div> <div>Enable</div> <div>Activation screen width</div>", r2 = space(), a2 = element("ol");
    for (let t19 = 0; t19 < m2.length; t19 += 1) m2[t19].c();
    s2 = space(), c2 = element("button"), c2.textContent = "Save", l2 = space(), u2 = element("button"), u2.textContent = "Cancel", attr(i2, "class", "table-header svelte-mobile-companion-a5e-038vch56tr3-1jj7tri"), attr(a2, "class", "item-list svelte-mobile-companion-a5e-038vch56tr3-1jj7tri"), attr(o2, "class", "svelte-mobile-companion-a5e-038vch56tr3-1jj7tri"), attr(n2, "class", "settings svelte-mobile-companion-a5e-038vch56tr3-1jj7tri"), attr(u2, "type", "reset"), set_style(e2, "height", "100%"), attr(e2, "class", "svelte-mobile-companion-a5e-038vch56tr3-1jj7tri");
  }, m(f3, h3) {
    insert(f3, e2, h3), append(e2, n2), append(n2, o2), append(o2, i2), append(o2, r2), append(o2, a2);
    for (let t19 = 0; t19 < m2.length; t19 += 1) m2[t19] && m2[t19].m(a2, null);
    append(e2, s2), append(e2, c2), append(e2, l2), append(e2, u2), p2 || (d2 = [listen(c2, "click", prevent_default(t18[3])), listen(u2, "click", prevent_default(t18[6]))], p2 = true);
  }, p(t19, e3) {
    2 & e3 && (h2 = ensure_array_like(t19[1]), m2 = update_keyed_each(m2, e3, g2, 1, t19, h2, f2, a2, destroy_block, create_each_block$P, null, get_each_context$P));
  }, d(t19) {
    t19 && detach(e2);
    for (let t20 = 0; t20 < m2.length; t20 += 1) m2[t20].d();
    p2 = false, run_all(d2);
  } };
}
function create_fragment$2L(t18) {
  let e2, n2, o2;
  function i2(e3) {
    t18[7](e3);
  }
  let r2 = { $$slots: { default: [create_default_slot$s] }, $$scope: { ctx: t18 } };
  return void 0 !== t18[0] && (r2.elementRoot = t18[0]), e2 = new ApplicationShell$1({ props: r2 }), binding_callbacks.push(() => bind(e2, "elementRoot", i2)), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, n3) {
    mount_component(e2, t19, n3), o2 = true;
  }, p(t19, [o3]) {
    const i3 = {};
    4098 & o3 && (i3.$$scope = { dirty: o3, ctx: t19 }), !n2 && 1 & o3 && (n2 = true, i3.elementRoot = t19[0], add_flush_callback(() => n2 = false)), e2.$set(i3);
  }, i(t19) {
    o2 || (transition_in(e2.$$.fragment, t19), o2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), o2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function instance$2M(t18, e2, n2) {
  let { elementRoot: o2 } = e2;
  const { application: i2 } = getContext("#external"), r2 = game.settings.get(getFullModuleId$1(), settings$1.users);
  let a2 = game.users.filter((t19) => t19.role !== FoundryUserRoles$1.GAMEMASTER.valueOf()).map((t19) => {
    let e3 = r2[t19.id] || {};
    return foundry.utils.isNewerVersion(game.version, "12") ? foundry.utils.mergeObject({ id: t19.id, name: t19.name, enabled: false, screenWidth: 0 }, e3) : mergeObject({ id: t19.id, name: t19.name, enabled: false, screenWidth: 0 }, e3);
  });
  return t18.$$set = (t19) => {
    "elementRoot" in t19 && n2(0, o2 = t19.elementRoot);
  }, [o2, a2, i2, function() {
    a2.forEach((t19) => {
      let e3 = r2[t19.id] || {};
      e3.enabled = t19.enabled, e3.screenWidth = t19.screenWidth || 0, r2[t19.id] = e3;
    }), game.settings.set(getFullModuleId$1(), settings$1.users, r2), i2.close();
  }, function(t19, e3) {
    t19[e3].enabled = this.checked, n2(1, a2);
  }, function(t19, e3) {
    t19[e3].screenWidth = to_number(this.value), n2(1, a2);
  }, () => i2.close(), function(t19) {
    o2 = t19, n2(0, o2);
  }];
}
PopoutSupport$1.initialize();
let UserSetupShell$1 = class extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2M, create_fragment$2L, safe_not_equal, { elementRoot: 0 });
  }
  get elementRoot() {
    return this.$$.ctx[0];
  }
  set elementRoot(t18) {
    this.$$set({ elementRoot: t18 }), flush();
  }
};
class UserSetupShell extends SvelteApp$1 {
  static get defaultOptions() {
    return foundry.utils.mergeObject(super.defaultOptions, { title: "Settings", width: "auto", height: "auto", resizable: false, svelte: { class: UserSetupShell$1, target: document.body } });
  }
}
class SettingsUser extends FormApplication {
  static #ze;
  static showSettings() {
    return this.#ze = this.#ze ? this.#ze : new UserSetupShell(), this.#ze.render(true, { focus: true }), this.#ze;
  }
  constructor(t18 = {}) {
    super({}, t18), SettingsUser.showSettings();
  }
  async _updateObject(t18, e2) {
    await super._updateObject(t18, e2);
  }
  render() {
    this.close();
  }
}
function i18n(t18) {
  return game.i18n.localize(t18);
}
function myi18n(t18) {
  return i18n("Mobile-Companion.".concat(t18));
}
async function enrichText(t18, e2 = []) {
  let n2 = t18;
  for (const t19 of e2) {
    const e3 = new RegExp(t19.find, "g");
    n2 = n2.replace(e3, t19.replace);
  }
  return n2 = foundry.utils.isNewerVersion(game.version, "12.343") ? await foundry.applications.ux.TextEditor.implementation.enrichHTML(n2) : await TextEditor.enrichHTML(n2), n2;
}
function isMinimalWritableStore(t18) {
  if (null == t18) return false;
  switch (typeof t18) {
    case "function":
    case "object":
      return "function" == typeof t18.subscribe && "function" == typeof t18.set;
  }
  return false;
}
function isWritableStore(t18) {
  if (null == t18) return false;
  switch (typeof t18) {
    case "function":
    case "object":
      return "function" == typeof t18.subscribe && "function" == typeof t18.set && "function" == typeof t18.update;
  }
  return false;
}
function subscribeIgnoreFirst(t18, e2) {
  let n2 = false;
  return t18.subscribe((t19) => {
    n2 ? e2(t19) : n2 = true;
  });
}
function deepMerge(t18, ...e2) {
  if ("[object Object]" !== Object.prototype.toString.call(t18)) throw new TypeError("deepMerge error: 'target' is not an object.");
  if (0 === e2.length) throw new TypeError("deepMerge error: 'sourceObj' is not an object.");
  for (let t19 = 0; t19 < e2.length; t19++) if ("[object Object]" !== Object.prototype.toString.call(e2[t19])) throw new TypeError(`deepMerge error: 'sourceObj[${t19}]' is not an object.`);
  if (1 === e2.length) {
    const n2 = [];
    for (const o2 of e2) n2.push({ target: t18, source: o2 });
    for (; n2.length > 0; ) {
      const { target: t19, source: e3 } = n2.pop();
      for (const o2 in e3) if (Object.hasOwn(e3, o2)) {
        const i2 = e3[o2], r2 = t19[o2];
        Object.hasOwn(t19, o2) && r2?.constructor === Object && i2?.constructor === Object ? n2.push({ target: r2, source: i2 }) : t19[o2] = i2;
      }
    }
  } else {
    const n2 = [{ target: t18, sources: e2 }];
    for (; n2.length > 0; ) {
      const { target: t19, sources: e3 } = n2.pop();
      for (const o2 of e3) for (const e4 in o2) if (Object.hasOwn(o2, e4)) {
        const i2 = o2[e4], r2 = t19[e4];
        Object.hasOwn(t19, e4) && r2?.constructor === Object && i2?.constructor === Object ? (t19[e4] = Object.assign({}, r2), n2.push({ target: t19[e4], sources: [i2] })) : t19[e4] = i2;
      }
    }
  }
  return t18;
}
function hasGetter(t18, e2) {
  if ("object" != typeof t18 || null == t18) return false;
  const n2 = Object.getOwnPropertyDescriptor(t18, e2);
  if (void 0 !== n2 && void 0 !== n2.get) return true;
  for (let n3 = Object.getPrototypeOf(t18); n3; n3 = Object.getPrototypeOf(n3)) {
    const t19 = Object.getOwnPropertyDescriptor(n3, e2);
    if (void 0 !== t19 && void 0 !== t19.get) return true;
  }
  return false;
}
function isIterable(t18) {
  return null != t18 && "object" == typeof t18 && Symbol.iterator in t18;
}
function isObject(t18) {
  return null !== t18 && "object" == typeof t18 && !Array.isArray(t18);
}
function isPlainObject(t18) {
  if ("[object Object]" !== Object.prototype.toString.call(t18)) return false;
  const e2 = Object.getPrototypeOf(t18);
  return null === e2 || e2 === Object.prototype;
}
function safeAccess(t18, e2, n2) {
  if ("object" != typeof t18 || null === t18) return n2;
  if ("string" != typeof e2) return n2;
  const o2 = e2.split(".");
  let i2 = t18;
  for (let t19 = 0; t19 < o2.length; t19++) {
    if (void 0 === i2[o2[t19]] || null === i2[o2[t19]]) return n2;
    i2 = i2[o2[t19]];
  }
  return i2;
}
function safeSet(t18, e2, n2, { operation: o2 = "set", createMissing: i2 = false } = {}) {
  if ("object" != typeof t18 || null === t18) throw new TypeError("safeSet error: 'data' is not an object.");
  if ("string" != typeof e2) throw new TypeError("safeSet error: 'accessor' is not a string.");
  if ("string" != typeof o2) throw new TypeError("safeSet error: 'options.operation' is not a string.");
  if ("add" !== o2 && "div" !== o2 && "mult" !== o2 && "set" !== o2 && "set-undefined" !== o2 && "sub" !== o2) throw new Error("safeSet error: Unknown 'options.operation'.");
  if ("boolean" != typeof i2) throw new TypeError("safeSet error: 'options.createMissing' is not a boolean.");
  const r2 = e2.split(".");
  let a2 = false;
  if (1 === r2.length && !i2 && !(r2[0] in t18)) return false;
  for (let e3 = 0; e3 < r2.length; e3++) {
    if (Array.isArray(t18)) {
      const t19 = +r2[e3];
      if (!Number.isInteger(t19) || t19 < 0) return false;
    }
    if (e3 === r2.length - 1) switch (o2) {
      case "add":
        t18[r2[e3]] += n2, a2 = true;
        break;
      case "div":
        t18[r2[e3]] /= n2, a2 = true;
        break;
      case "mult":
        t18[r2[e3]] *= n2, a2 = true;
        break;
      case "set":
        t18[r2[e3]] = n2, a2 = true;
        break;
      case "set-undefined":
        void 0 === t18[r2[e3]] && (t18[r2[e3]] = n2), a2 = true;
        break;
      case "sub":
        t18[r2[e3]] -= n2, a2 = true;
    }
    else {
      if (i2 && void 0 === t18[r2[e3]] && (t18[r2[e3]] = {}), null === t18[r2[e3]] || "object" != typeof t18[r2[e3]]) return false;
      t18 = t18[r2[e3]];
    }
  }
  return a2;
}
class CrossWindow {
  constructor() {
  }
  static #t = ["HTMLAnchorElement", "HTMLButtonElement", "HTMLDetailsElement", "HTMLEmbedElement", "HTMLIFrameElement", "HTMLInputElement", "HTMLObjectElement", "HTMLSelectElement", "HTMLTextAreaElement"];
  static #e = /* @__PURE__ */ new Set([Node.ELEMENT_NODE, Node.TEXT_NODE, Node.COMMENT_NODE, Node.DOCUMENT_FRAGMENT_NODE]);
  static #n = /* @__PURE__ */ new Set(["MouseEvent", "PointerEvent"]);
  static #o = /* @__PURE__ */ new Set(["UIEvent", "FocusEvent", "MouseEvent", "WheelEvent", "KeyboardEvent", "PointerEvent", "TouchEvent", "InputEvent", "CompositionEvent", "DragEvent"]);
  static #i = /* @__PURE__ */ new Set(["KeyboardEvent", "MouseEvent", "PointerEvent"]);
  static #r = { throws: false };
  static getActiveElement(t18, { throws: e2 = true } = {}) {
    if (this.#e.has(t18?.nodeType)) return t18?.ownerDocument?.activeElement ?? null;
    if (this.isUIEvent(t18) && isObject(t18?.view)) return t18?.view?.document?.activeElement ?? null;
    if (isObject(t18?.defaultView)) return t18?.activeElement ?? null;
    if (isObject(t18?.document) && isObject(t18?.location)) return t18?.document?.activeElement ?? null;
    if (e2) throw new TypeError("'target' must be a DOM Node / Element, Document, UIEvent, or Window.");
  }
  static getDocument(t18, { throws: e2 = true } = {}) {
    if (this.#e.has(t18?.nodeType)) return t18?.ownerDocument;
    if (this.isUIEvent(t18) && isObject(t18?.view)) return t18?.view?.document;
    if (isObject(t18?.defaultView)) return t18;
    if (isObject(t18?.document) && isObject(t18?.location)) return t18?.document;
    if (e2) throw new TypeError("'target' must be a DOM Node / Element, Document, UIEvent, or Window.");
  }
  static getWindow(t18, { throws: e2 = true } = {}) {
    if (this.#e.has(t18?.nodeType)) return t18.ownerDocument?.defaultView ?? globalThis;
    if (this.isUIEvent(t18) && isObject(t18?.view)) return t18.view ?? globalThis;
    if (isObject(t18?.defaultView)) return t18.defaultView ?? globalThis;
    if (isObject(t18?.document) && isObject(t18?.location)) return t18;
    if (e2) throw new TypeError("'target' must be a DOM Node / Element, Document, UIEvent, or Window.");
  }
  static isDocument(t18) {
    return isObject(t18) && "[object Document]" === Object.prototype.toString.call(t18);
  }
  static isMap(t18) {
    return isObject(t18) && "[object Map]" === Object.prototype.toString.call(t18);
  }
  static isPromise(t18) {
    return isObject(t18) && "[object Promise]" === Object.prototype.toString.call(t18);
  }
  static isRegExp(t18) {
    return isObject(t18) && "[object RegExp]" === Object.prototype.toString.call(t18);
  }
  static isSet(t18) {
    return isObject(t18) && "[object Set]" === Object.prototype.toString.call(t18);
  }
  static isURL(t18) {
    return isObject(t18) && "[object URL]" === Object.prototype.toString.call(t18);
  }
  static isWindow(t18) {
    return isObject(t18) && "[object Window]" === Object.prototype.toString.call(t18);
  }
  static isFocusableHTMLElement(t18) {
    for (let e2 = this.#t.length; --e2 >= 0; ) if (this.#a(t18, Node.ELEMENT_NODE, this.#t[e2])) return true;
    return false;
  }
  static isDocumentFragment(t18) {
    return this.#a(t18, Node.DOCUMENT_FRAGMENT_NODE, "DocumentFragment");
  }
  static isElement(t18) {
    return this.#a(t18, Node.ELEMENT_NODE, "Element");
  }
  static isHTMLAnchorElement(t18) {
    return this.#a(t18, Node.ELEMENT_NODE, "HTMLAnchorElement");
  }
  static isHTMLElement(t18) {
    return this.#a(t18, Node.ELEMENT_NODE, "HTMLElement");
  }
  static isNode(t18) {
    if ("number" != typeof t18?.nodeType) return false;
    if (t18 instanceof globalThis.Node) return true;
    const e2 = this.getWindow(t18, this.#r), n2 = e2?.Node;
    return n2 && t18 instanceof n2;
  }
  static isShadowRoot(t18) {
    return this.#a(t18, Node.DOCUMENT_FRAGMENT_NODE, "ShadowRoot");
  }
  static isSVGElement(t18) {
    return this.#a(t18, Node.ELEMENT_NODE, "SVGElement");
  }
  static isEvent(t18, e2) {
    return "string" == typeof t18?.type && "boolean" == typeof t18?.defaultPrevented && "function" == typeof t18?.stopPropagation && (void 0 === e2 || this.isCtorName(t18, e2));
  }
  static isPointerEvent(t18) {
    return this.isEvent(t18, this.#n);
  }
  static isUIEvent(t18) {
    return this.isEvent(t18, this.#o);
  }
  static isUserInputEvent(t18) {
    return this.isEvent(t18, this.#i);
  }
  static isCtorName(t18, e2) {
    return !!isObject(t18) && ("string" == typeof e2 && t18?.constructor?.name === e2 || !!e2?.has(t18?.constructor?.name));
  }
  static #a(t18, e2, n2) {
    if (!isObject(t18)) return false;
    if (t18.nodeType !== e2) return false;
    const o2 = globalThis[n2];
    if (o2 && t18 instanceof o2) return true;
    const i2 = this.#e.has(t18.nodeType) ? t18?.ownerDocument?.defaultView : this.getWindow(t18, this.#r), r2 = i2?.[n2];
    return r2 && t18 instanceof r2;
  }
}
var _a$1;
class TJSGameSettings {
  #s;
  #c = [];
  #l = /* @__PURE__ */ new Map();
  constructor(t18) {
    if ("string" != typeof t18) throw new TypeError("'namespace' is not a string.");
    this.#s = t18;
  }
  static #u(t18) {
    return writable(t18);
  }
  get namespace() {
    return this.#s;
  }
  #p(t18, e2) {
    let n2 = this.#l.get(t18);
    return void 0 === n2 && (n2 = _a$1.#u(e2), this.#l.set(t18, n2)), n2;
  }
  getReadableStore(t18) {
    if (!this.#l.has(t18)) return void console.warn(`TJSGameSettings - getReadableStore: '${t18}' is not a registered setting.`);
    return { subscribe: this.#p(t18).subscribe };
  }
  getStore(t18) {
    return this.getWritableStore(t18);
  }
  getWritableStore(t18) {
    if (this.#l.has(t18)) return this.#p(t18);
    console.warn(`TJSGameSettings - getWritableStore: '${t18}' is not a registered setting.`);
  }
  register(t18, e2 = true) {
    if (!isObject(t18)) throw new TypeError("TJSGameSettings - register: setting is not an object.");
    if (!isObject(t18.options)) throw new TypeError("TJSGameSettings - register: 'setting.options' attribute is not an object.");
    if ("boolean" != typeof e2) throw new TypeError("TJSGameSettings - register: 'coreConfig' is not an boolean.");
    if (void 0 !== t18.store && !isMinimalWritableStore(t18.store)) throw new TypeError("TJSGameSettings - register: 'setting.store' attribute is not a minimal writable store.");
    const n2 = t18.namespace ?? this.#s, o2 = t18.key, i2 = !!e2 && (t18.options.config ?? true);
    if ("string" != typeof n2) throw new TypeError("TJSGameSettings - register: 'namespace' attribute is not a string.");
    if ("string" != typeof o2) throw new TypeError("TJSGameSettings - register: 'key' attribute is not a string.");
    const r2 = t18.store, a2 = t18.options, s2 = [];
    let c2 = false;
    if (s2.push((t19) => {
      const e3 = this.#p(o2);
      e3 && !c2 && (c2 = true, e3.set(t19), c2 = false);
    }), isIterable(a2?.onChange)) for (const t19 of a2.onChange) "function" == typeof t19 && s2.push(t19);
    else "function" == typeof a2.onChange && s2.push(a2.onChange);
    globalThis.game.settings.register(n2, o2, { ...a2, config: i2, onChange: (t19) => {
      for (const e3 of s2) e3(t19);
    } });
    const l2 = r2 || this.#p(o2, globalThis.game.settings.get(n2, o2));
    r2 && (this.#l.set(o2, l2), r2.set(globalThis.game.settings.get(n2, o2)));
    subscribeIgnoreFirst(l2, async (t19) => {
      c2 || (c2 = true, await globalThis.game.settings.set(n2, o2, t19)), c2 = false;
    });
    {
      const { store: e3, ...i3 } = t18, r3 = Object.assign({}, i3, { namespace: n2, key: o2, options: a2 });
      Object.freeze(r3), this.#c.push(r3);
    }
  }
  registerAll(t18, e2) {
    if (!isIterable(t18)) throw new TypeError("TJSGameSettings - registerAll: settings is not iterable.");
    for (const n2 of t18) {
      if (!isObject(n2)) throw new TypeError("TJSGameSettings - registerAll: entry in settings is not an object.");
      if ("string" != typeof n2.namespace) throw new TypeError("TJSGameSettings - registerAll: entry in settings missing 'namespace' attribute.");
      if ("string" != typeof n2.key) throw new TypeError("TJSGameSettings - registerAll: entry in settings missing 'key' attribute.");
      if (!isObject(n2.options)) throw new TypeError("TJSGameSettings - registerAll: entry in settings missing 'options' attribute.");
      this.register(n2, e2);
    }
  }
  *data(t18 = void 0) {
    if (void 0 !== t18 && !CrossWindow.isRegExp(t18)) throw new TypeError("'regex' is not a RegExp");
    if (this.#c.length) if (t18) for (const e2 of this.#c) t18.test(e2.key) && (yield e2);
    else for (const t19 of this.#c) yield t19;
  }
  *entries(t18 = void 0) {
    if (void 0 !== t18 && !CrossWindow.isRegExp(t18)) throw new TypeError("'regex' is not a RegExp");
    if (this.#l.size) if (t18) for (const e2 of this.#l.keys()) t18.test(e2) && (yield [e2, this.getStore(e2)]);
    else for (const t19 of this.#l.keys()) yield [t19, this.getStore(t19)];
  }
  *keys(t18 = void 0) {
    if (void 0 !== t18 && !CrossWindow.isRegExp(t18)) throw new TypeError("'regex' is not a RegExp");
    if (this.#l.size) if (t18) for (const e2 of this.#l.keys()) t18.test(e2) && (yield e2);
    else for (const t19 of this.#l.keys()) yield t19;
  }
  *stores(t18 = void 0) {
    if (void 0 !== t18 && !CrossWindow.isRegExp(t18)) throw new TypeError("'regex' is not a RegExp");
    if (this.#l.size) if (t18) for (const e2 of this.#l.keys()) t18.test(e2) && (yield this.getStore(e2));
    else for (const t19 of this.#l.keys()) yield this.getStore(t19);
  }
}
_a$1 = TJSGameSettings;
const settings = { users: "users", usersMenu: "usersMenu", gmCompanionUser: "gmCompanionUsers", gmCompanionMenu: "gmCompanionMenu", lastActorId: "lastActorId" };
var FoundryUserRoles = ((t18) => (t18[t18.NONE = 0] = "NONE", t18[t18.PLAYER = 1] = "PLAYER", t18[t18.TRUSTED_PLAYER = 2] = "TRUSTED_PLAYER", t18[t18.ASSISTANT_GM = 3] = "ASSISTANT_GM", t18[t18.GAMEMASTER = 4] = "GAMEMASTER", t18))(FoundryUserRoles || {});
function storeGenerator({ storage: t18, serialize: e2 = JSON.stringify, deserialize: n2 = JSON.parse }) {
  function o2(t19, e3, n3) {
    return { subscribe: i2(t19, e3, n3).subscribe };
  }
  function i2(o3, i3, r2) {
    if (t18) {
      const r3 = t18.getItem(o3);
      try {
        r3 && (i3 = n2(r3));
      } catch (t19) {
      }
      t18.setItem(o3, e2(i3));
    }
    const a2 = writable(i3, r2 ? function(n3) {
      return r2(function(i4) {
        return t18 && t18.setItem(o3, e2(i4)), n3(i4);
      }, function(t19) {
        s2(t19(get_store_value(a2)));
      });
    } : void 0);
    function s2(n3) {
      t18 && t18.setItem(o3, e2(n3)), a2.set(n3);
    }
    return { set: s2, update: function(t19) {
      s2(t19(get_store_value(a2)));
    }, subscribe: function(t19, e3) {
      return a2.subscribe(t19, e3);
    } };
  }
  return { readable: o2, writable: i2, derived: function(e3, i3, r2, a2) {
    const s2 = !Array.isArray(i3), c2 = s2 ? [i3] : i3;
    if (t18 && t18.getItem(e3)) try {
      a2 = n2(t18.getItem(e3));
    } catch (t19) {
    }
    return o2(e3, a2, (t19, e4) => {
      let n3 = false;
      const o3 = [];
      let i4, a3 = 0;
      const l2 = () => {
        if (a3) return;
        i4?.();
        const n4 = s2 ? o3[0] : o3;
        if (r2.length < 2) t19(r2(n4));
        else {
          const o4 = r2(n4, t19, e4);
          "function" == typeof o4 && (i4 = o4);
        }
      }, u2 = c2.map((t20, e5) => t20.subscribe((t21) => {
        o3[e5] = t21, a3 &= ~(1 << e5), n3 && l2();
      }, () => {
        a3 |= 1 << e5;
      }));
      return n3 = true, l2(), function() {
        u2.forEach((t20) => t20()), i4?.();
      };
    });
  }, storage: t18, serialize: e2, deserialize: n2 };
}
const sessionStores = storeGenerator({ storage: globalThis?.sessionStorage });
class TJSWebStorage {
  #d;
  #l = /* @__PURE__ */ new Map();
  constructor(t18) {
    this.#d = t18;
  }
  #u(t18, e2 = void 0, n2) {
    try {
      const o2 = this.#d.storage.getItem(t18);
      if (null !== o2) {
        e2 = (n2?.deserialize ?? this.#d.deserialize)(o2);
      }
    } catch (t19) {
    }
    return (n2?.writable ?? this.#d.writable)(t18, e2);
  }
  #m(t18) {
    return this.#l.get(t18)?.deserialize ?? this.#d.deserialize;
  }
  #f(t18) {
    return this.#l.get(t18)?.serialize ?? this.#d.serialize;
  }
  #p(t18, e2 = void 0, n2) {
    const o2 = this.#l.get(t18);
    if (o2) return o2.store;
    const i2 = this.#u(t18, e2, n2);
    return this.#l.set(t18, { store: i2, deserialize: n2?.deserialize, serialize: n2?.serialize }), i2;
  }
  getItem(t18, e2) {
    let n2 = e2;
    const o2 = this.#d.storage.getItem(t18);
    if (null !== o2) try {
      n2 = this.#m(t18)(o2);
    } catch (t19) {
      n2 = e2;
    }
    else if (void 0 !== e2) try {
      const n3 = this.#f(t18)(e2);
      this.#d.storage.setItem(t18, n3);
    } catch (t19) {
    }
    return n2;
  }
  getStore(t18, e2, n2) {
    return this.#p(t18, e2, n2);
  }
  hasStore(t18) {
    return this.#l.has(t18);
  }
  setItem(t18, e2) {
    this.#p(t18).set(e2);
  }
  swapItemBoolean(t18, e2) {
    const n2 = this.#p(t18, e2);
    let o2 = false;
    try {
      o2 = !!this.#m(t18)(this.#d.storage.getItem(t18));
    } catch (t19) {
    }
    const i2 = "boolean" == typeof o2 && !o2;
    return n2.set(i2), i2;
  }
  *entries(t18 = void 0) {
    if (void 0 !== t18 && !CrossWindow.isRegExp(t18)) throw new TypeError("'regex' is not a RegExp");
    if (this.#l.size) if (t18) for (const e2 of this.#l.keys()) t18.test(e2) && (yield [e2, this.getStore(e2)]);
    else for (const t19 of this.#l.keys()) yield [t19, this.getStore(t19)];
  }
  *keys(t18 = void 0) {
    if (void 0 !== t18 && !CrossWindow.isRegExp(t18)) throw new TypeError("'regex' is not a RegExp");
    if (this.#l.size) if (t18) for (const e2 of this.#l.keys()) t18.test(e2) && (yield e2);
    else for (const t19 of this.#l.keys()) yield t19;
  }
  *stores(t18 = void 0) {
    if (void 0 !== t18 && !CrossWindow.isRegExp(t18)) throw new TypeError("'regex' is not a RegExp");
    if (this.#l.size) if (t18) for (const e2 of this.#l.keys()) t18.test(e2) && (yield this.getStore(e2));
    else for (const t19 of this.#l.keys()) yield this.getStore(t19);
  }
}
class TJSSessionStorage extends TJSWebStorage {
  constructor() {
    super(sessionStores);
  }
}
function writableDerived(t18, e2, n2, o2) {
  var i2, r2, a2 = false, s2 = n2.length >= 2, c2 = derived(t18, (t19, n3, o3) => {
    if (i2 = n3, s2 && (r2 = t19), !a2) {
      let i3 = e2(t19, n3, o3);
      if (!(e2.length < 2)) return i3;
      n3(i3);
    }
    a2 = false;
  }, o2), l2 = !Array.isArray(t18);
  var u2 = false;
  function p2(e3) {
    var o3, s3, p3, d2;
    if (u2) return d2 = e3(get_store_value(c2)), void i2(d2);
    var m2, f2 = c2.subscribe((t19) => {
      u2 ? o3 ? s3 = true : o3 = true : p3 = t19;
    });
    d2 = e3(p3), u2 = true, i2(d2), f2(), u2 = false, s3 && (d2 = get_store_value(c2)), o3 && (m2 = n2(d2, r2), l2 ? (a2 = true, t18.set(m2)) : m2.forEach((e4, n3) => {
      a2 = true, t18[n3].set(e4);
    }), a2 = false);
  }
  return { subscribe: c2.subscribe, set(t19) {
    p2(() => t19);
  }, update: p2 };
}
function propertyStore(t18, e2) {
  if (Array.isArray(e2)) {
    let n2 = e2.concat();
    return writableDerived(t18, (t19) => {
      for (let e3 = 0; e3 < n2.length; ++e3) t19 = t19[n2[e3]];
      return t19;
    }, (t19, e3) => {
      let o2 = e3;
      for (let t20 = 0; t20 < n2.length - 1; ++t20) o2 = o2[n2[t20]];
      return o2[n2[n2.length - 1]] = t19, e3;
    });
  }
  return writableDerived(t18, (t19) => t19[e2], (t19, n2) => (n2[e2] = t19, n2));
}
class APIConfig {
  constructor() {
  }
  static isConfig(t18, { raiseException: e2 = false } = {}) {
    if (!isObject(t18)) {
      if (e2) throw new TypeError("TJSSvelte.config.isConfig error: 'config' is not an object.");
      return false;
    }
    if (!TJSSvelte.util.isComponent(t18.class)) {
      if (e2) throw new TypeError("TJSSvelte.config.isConfig error: 'config.class' is not a Svelte component constructor.");
      return false;
    }
    return true;
  }
  static isConfigEmbed(t18, { raiseException: e2 = false } = {}) {
    if (!isObject(t18)) {
      if (e2) throw new TypeError("TJSSvelte.config.isConfigEmbed error: 'config' is not an object.");
      return false;
    }
    if (!TJSSvelte.util.isComponent(t18.class)) {
      if (e2) throw new TypeError("TJSSvelte.config.isConfigEmbed error: 'config.class' is not a Svelte component constructor.");
      return false;
    }
    if (void 0 !== t18.props && !isObject(t18.props)) {
      if (e2) throw new TypeError("TJSSvelte.config.isConfigEmbed error: 'config.props' is not an object.");
      return false;
    }
    return true;
  }
  static parseConfig(t18, { contextExternal: e2 = false, thisArg: n2 } = {}) {
    if (!isObject(t18)) throw new TypeError(`TJSSvelte.config.parseConfig - 'config' is not an object:
${JSON.stringify(t18)}.`);
    if (!TJSSvelte.util.isComponent(t18.class)) throw new TypeError(`TJSSvelte.config.parseConfig - 'class' is not a Svelte component constructor for config:
${JSON.stringify(t18)}.`);
    if (void 0 !== t18.hydrate && "boolean" != typeof t18.hydrate) throw new TypeError(`TJSSvelte.config.parseConfig - 'hydrate' is not a boolean for config:
${JSON.stringify(t18)}.`);
    if (void 0 !== t18.intro && "boolean" != typeof t18.intro) throw new TypeError(`TJSSvelte.config.parseConfig - 'intro' is not a boolean for config:
${JSON.stringify(t18)}.`);
    if (void 0 !== t18.target && !CrossWindow.isElement(t18.target) && !CrossWindow.isShadowRoot(t18.target) && !CrossWindow.isDocumentFragment(t18.target)) throw new TypeError(`TJSSvelte.config.parseConfig - 'target' is not a Element, ShadowRoot, or DocumentFragment for config:
${JSON.stringify(t18)}.`);
    if (void 0 !== t18.anchor && !CrossWindow.isElement(t18.anchor) && !CrossWindow.isShadowRoot(t18.anchor) && !CrossWindow.isDocumentFragment(t18.anchor)) throw new TypeError(`TJSSvelte.config.parseConfig - 'anchor' is not a string, Element for config:
${JSON.stringify(t18)}.`);
    if (void 0 !== t18.context && "function" != typeof t18.context && !isObject(t18.context)) throw new TypeError(`TJSSvelte.config.parseConfig - 'context' is not a function or object for config:
${JSON.stringify(t18)}.`);
    const o2 = { ...t18 };
    let i2 = {};
    if ("function" == typeof o2.context) {
      const e3 = o2.context;
      delete o2.context;
      const r2 = e3.call(n2);
      if (!isObject(r2)) throw new Error(`TJSSvelte.config.parseConfig - 'context' is a function that did not return an object for config:
${JSON.stringify(t18)}`);
      i2 = { ...r2 };
    } else isObject(o2.context) && (i2 = o2.context, delete o2.context);
    return o2.props = this.#h(o2.props, n2, t18), e2 ? (o2.context = /* @__PURE__ */ new Map(), o2.context.set("#external", i2)) : o2.context = new Map(Object.entries(i2)), o2;
  }
  static #h(t18, e2, n2) {
    if ("function" == typeof t18) {
      const o2 = t18.call(e2);
      if (isObject(o2)) return o2;
      throw new Error(`TJSSvelte.config.parseConfig - 'props' is a function that did not return an object for config:
${JSON.stringify(n2)}`);
    }
    if (isObject(t18)) return t18;
    if (void 0 !== t18) throw new Error(`TJSSvelte.config.parseConfig - 'props' is not a function or an object for config:
${JSON.stringify(n2)}`);
    return {};
  }
}
Object.seal(APIConfig);
class APIUtil {
  constructor() {
  }
  static isComponent(t18) {
    if (null == t18 || "function" != typeof t18) return false;
    const e2 = t18?.prototype?.constructor?.name;
    return !("string" != typeof e2 || !e2.startsWith("Proxy<") && "ProxyComponent" !== e2) || ("undefined" != typeof window ? "function" == typeof t18?.prototype?.$destroy && "function" == typeof t18?.prototype?.$on : "function" == typeof t18?.prototype?.render);
  }
  static isHMRProxy(t18) {
    const e2 = t18?.constructor?.name;
    if ("string" == typeof e2 && (e2.startsWith("Proxy<") || "ProxyComponent" === e2)) return true;
    const n2 = t18?.prototype?.constructor?.name;
    return "string" == typeof n2 && (n2.startsWith("Proxy<") || "ProxyComponent" === n2);
  }
  static async outroAndDestroy(t18) {
    return null == t18 ? Promise.resolve() : new Promise((e2) => {
      t18?.$$?.fragment && t18?.$$?.fragment?.o ? (group_outros(), transition_out(t18.$$.fragment, 0, 0, () => {
        t18?.$destroy?.(), e2();
      }), check_outros()) : (t18?.$destroy?.(), e2());
    });
  }
}
Object.seal(APIUtil);
class TJSSvelte {
  constructor() {
  }
  static get config() {
    return APIConfig;
  }
  static get util() {
    return APIUtil;
  }
}
Object.seal(TJSSvelte);
const easingFunc = svelteEasingFunc;
function getEasingFunc(t18, e2) {
  if ("function" == typeof t18) return t18;
  const n2 = easingFunc[t18];
  return n2 || easingFunc[e2?.default ?? "linear"];
}
class A11yHelper {
  static #g = false;
  static get debug() {
    return this.#g;
  }
  static set debug(t18) {
    if ("boolean" != typeof t18) throw new TypeError("'debug' is not a boolean.");
    this.#g = t18;
  }
  static get prefersReducedMotion() {
    return globalThis?.matchMedia("(prefers-reduced-motion: reduce)")?.matches ?? false;
  }
  static applyFocusSource(t18) {
    if (!isObject(t18)) return;
    const e2 = isObject(t18?.focusSource) ? t18.focusSource : t18;
    setTimeout(() => {
      const t19 = "boolean" == typeof e2.debug ? this.debug || e2.debug : this.debug;
      if (isIterable(e2.focusEl)) {
        t19 && e2.focusEl;
        for (const t20 of e2.focusEl) {
          if (t20?.nodeType === Node.ELEMENT_NODE && t20?.isConnected) {
            t20?.focus();
            break;
          }
          if ("string" == typeof t20) {
            const e3 = document.querySelector(t20);
            if (e3?.nodeType === Node.ELEMENT_NODE && e3?.isConnected) {
              e3?.focus();
              break;
            }
          }
        }
      }
    }, 0);
  }
  static getFirstFocusableElement(t18 = document, e2) {
    const n2 = this.getFocusableElements(t18, e2);
    return n2.length > 0 ? n2[0] : void 0;
  }
  static getFocusableElements(t18 = document, { anchorHref: e2 = true, ignoreClasses: n2, ignoreElements: o2, parentHidden: i2 = false, selectors: r2 } = {}) {
    if (t18?.nodeType !== Node.ELEMENT_NODE && t18?.nodeType !== Node.DOCUMENT_NODE) throw new TypeError("'element' is not a HTMLElement, SVGElement, or Document instance.");
    if ("boolean" != typeof e2) throw new TypeError("'anchorHref' is not a boolean.");
    if (void 0 !== n2 && !isIterable(n2)) throw new TypeError("'ignoreClasses' is not an iterable list.");
    if (void 0 !== o2 && !CrossWindow.isSet(o2)) throw new TypeError("'ignoreElements' is not a Set.");
    if (void 0 !== r2 && "string" != typeof r2) throw new TypeError("'selectors' is not a string.");
    const a2 = r2 ?? this.#_(e2);
    let s2 = [...t18.querySelectorAll(a2)];
    return s2 = o2 && n2 ? s2.filter((t19) => {
      let e3 = false;
      for (const o3 of n2) if (t19.classList.contains(o3)) {
        e3 = true;
        break;
      }
      return !(e3 || o2.has(t19) || "none" === t19.style.display || "hidden" === t19.style.visibility || t19.hasAttribute("disabled") || t19.hasAttribute("inert") || "true" === t19.getAttribute("aria-hidden"));
    }) : n2 ? s2.filter((t19) => {
      let e3 = false;
      for (const o3 of n2) if (t19.classList.contains(o3)) {
        e3 = true;
        break;
      }
      return !e3 && "none" !== t19.style.display && "hidden" !== t19.style.visibility && !t19.hasAttribute("disabled") && !t19.hasAttribute("inert") && "true" !== t19.getAttribute("aria-hidden");
    }) : o2 ? s2.filter((t19) => !o2.has(t19) && "none" !== t19.style.display && "hidden" !== t19.style.visibility && !t19.hasAttribute("disabled") && !t19.hasAttribute("inert") && "true" !== t19.getAttribute("aria-hidden")) : s2.filter((t19) => "none" !== t19.style.display && "hidden" !== t19.style.visibility && !t19.hasAttribute("disabled") && !t19.hasAttribute("inert") && "true" !== t19.getAttribute("aria-hidden")), i2 && (s2 = s2.filter((e3) => !this.isParentHidden(e3, t18))), s2;
  }
  static #_(t18 = true) {
    return `button, [contenteditable=""], [contenteditable="true"], details summary:not([tabindex="-1"]), embed, a${t18 ? "[href]" : ""}, iframe, object, input:not([type=hidden]), select, textarea, [tabindex]:not([tabindex="-1"])`;
  }
  static getFocusSource({ event: t18, x: e2, y: n2, focusEl: o2, debug: i2 = false }) {
    if (void 0 !== o2 && !this.isFocusSource(o2)) throw new TypeError("A11yHelper.getFocusSource error: 'focusEl' is not a HTMLElement, SVGElement, or string.");
    if (void 0 !== i2 && "boolean" != typeof i2) throw new TypeError("A11yHelper.getFocusSource error: 'debug' is not a boolean.");
    const r2 = "boolean" == typeof i2 ? this.debug || i2 : this.debug;
    if (void 0 === t18) {
      if ("number" != typeof e2) throw new TypeError("A11yHelper.getFocusSource error: 'event' not defined and 'x' is not a number.");
      if ("number" != typeof n2) throw new TypeError("A11yHelper.getFocusSource error: 'event' not defined and 'y' is not a number.");
      const t19 = { debug: i2, focusEl: void 0 !== o2 ? [o2] : void 0, x: e2, y: n2 };
      return t19;
    }
    if (void 0 !== t18 && !CrossWindow.isUserInputEvent(t18)) throw new TypeError("A11yHelper.getFocusSource error: 'event' is not a KeyboardEvent, MouseEvent, or PointerEvent.");
    if (void 0 !== e2 && !Number.isInteger(e2)) throw new TypeError("A11yHelper.getFocusSource error: 'x' is not a number.");
    if (void 0 !== n2 && !Number.isInteger(n2)) throw new TypeError("A11yHelper.getFocusSource error: 'y' is not a number.");
    let a2;
    if (t18 && (A11yHelper.isFocusable(t18.target) ? a2 = t18.target : A11yHelper.isFocusable(t18.currentTarget) ? a2 = t18.currentTarget : r2 && (t18.target, t18.currentTarget), a2 && a2?.nodeType !== Node.ELEMENT_NODE && "function" != typeof a2?.focus)) throw new TypeError("A11yHelper.getFocusSource error: 'targetEl' is not an HTMLElement or SVGElement.");
    const s2 = { debug: i2 };
    if (CrossWindow.isPointerEvent(t18)) if (2 !== t18?.button && "contextmenu" === t18.type) {
      const i3 = (a2 ?? t18.target).getBoundingClientRect();
      s2.source = "keyboard", s2.x = e2 ?? i3.left + i3.width / 2, s2.y = n2 ?? i3.top + i3.height / 2, s2.focusEl = a2 ? [a2] : [], o2 && s2.focusEl.push(o2);
    } else s2.source = "pointer", s2.x = e2 ?? t18.pageX, s2.y = n2 ?? t18.pageY, s2.focusEl = a2 ? [a2] : [], o2 && s2.focusEl.push(o2);
    else {
      const i3 = a2 ?? t18?.target;
      if (i3) {
        const t19 = i3.getBoundingClientRect();
        s2.source = "keyboard", s2.x = e2 ?? t19.left + t19.width / 2, s2.y = n2 ?? t19.top + t19.height / 2, s2.focusEl = a2 ? [a2] : [];
      }
      o2 && s2.focusEl.push(o2);
    }
    return s2;
  }
  static getLastFocusableElement(t18 = document, e2) {
    const n2 = this.getFocusableElements(t18, e2);
    return n2.length > 0 ? n2[n2.length - 1] : void 0;
  }
  static isFocusable(t18, { anchorHref: e2 = true, ignoreClasses: n2 } = {}) {
    if (null == t18 || t18?.hidden || !t18?.isConnected || t18?.nodeType !== Node.ELEMENT_NODE || "function" != typeof t18?.focus) return false;
    if ("boolean" != typeof e2) throw new TypeError("'anchorHref' is not a boolean.");
    if (void 0 !== n2 && !isIterable(n2)) throw new TypeError("'ignoreClasses' is not an iterable list.");
    const o2 = t18.getAttribute("contenteditable"), i2 = "string" == typeof o2 && ("" === o2 || "true" === o2), r2 = globalThis.parseInt(t18.getAttribute("tabindex")), a2 = Number.isInteger(r2) && r2 >= 0;
    return !!(i2 || a2 || CrossWindow.isFocusableHTMLElement(t18)) && (!(e2 && !a2 && CrossWindow.isHTMLAnchorElement(t18) && "string" != typeof t18.getAttribute("href")) && ("none" !== t18.style.display && "hidden" !== t18.style.visibility && !t18.hasAttribute("disabled") && !t18.hasAttribute("inert") && "true" !== t18.getAttribute("aria-hidden")));
  }
  static isFocusSource(t18) {
    return "string" == typeof t18 || t18?.nodeType === Node.ELEMENT_NODE && "function" == typeof t18?.focus;
  }
  static isFocusTarget(t18) {
    return null != t18 && t18?.nodeType === Node.ELEMENT_NODE && "function" == typeof t18?.focus;
  }
  static isFocusWithin(t18) {
    if (!isObject(t18) || t18?.hidden || !t18?.isConnected) return false;
    let e2 = CrossWindow.getActiveElement(t18);
    if (!e2) return false;
    for (; e2; ) {
      if (e2 === t18) return true;
      e2 = e2.parentElement;
    }
    return false;
  }
  static isParentHidden(t18, e2) {
    if (!CrossWindow.isElement(t18)) throw new TypeError("'element' is not an Element.");
    if (e2 = e2 ?? CrossWindow.getDocument(t18)?.body, !CrossWindow.isElement(e2)) throw new TypeError("'stopElement' must be an Element.");
    let n2 = t18.parentElement;
    for (; n2 && n2 !== e2; ) {
      if (0 === n2.offsetWidth && 0 === n2.offsetHeight) return true;
      n2 = n2.parentElement;
    }
    return false;
  }
}
function clamp(t18 = 0, e2 = 0, n2 = 0) {
  return Math.min(Math.max(t18, e2), n2);
}
function degToRad(t18) {
  return t18 * (Math.PI / 180);
}
function radToDeg(t18) {
  return t18 * (180 / Math.PI);
}
function lerp(t18, e2, n2) {
  return (1 - n2) * t18 + n2 * e2;
}
var GLM_EPSILON = 1e-6, Mat4 = class t15 extends Float32Array {
  static #$ = new Float32Array([1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1]);
  static #b = new Float32Array(3);
  constructor(...e2) {
    switch (e2.length) {
      case 16:
        super(e2);
        break;
      case 2:
        super(e2[0], e2[1], 16);
        break;
      case 1:
        const n2 = e2[0];
        "number" == typeof n2 ? super([n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2, n2]) : super(n2, 0, 16);
        break;
      default:
        super(t15.#$);
    }
  }
  get str() {
    return t15.str(this);
  }
  copy(t18) {
    return this.set(t18), this;
  }
  identity() {
    return this.set(t15.#$), this;
  }
  multiply(e2) {
    return t15.multiply(this, this, e2);
  }
  mul(t18) {
    return this;
  }
  transpose() {
    return t15.transpose(this, this);
  }
  invert() {
    return t15.invert(this, this);
  }
  translate(e2) {
    return t15.translate(this, this, e2);
  }
  rotate(e2, n2) {
    return t15.rotate(this, this, e2, n2);
  }
  scale(e2) {
    return t15.scale(this, this, e2);
  }
  rotateX(e2) {
    return t15.rotateX(this, this, e2);
  }
  rotateY(e2) {
    return t15.rotateY(this, this, e2);
  }
  rotateZ(e2) {
    return t15.rotateZ(this, this, e2);
  }
  perspectiveNO(e2, n2, o2, i2) {
    return t15.perspectiveNO(this, e2, n2, o2, i2);
  }
  perspectiveZO(e2, n2, o2, i2) {
    return t15.perspectiveZO(this, e2, n2, o2, i2);
  }
  orthoNO(e2, n2, o2, i2, r2, a2) {
    return t15.orthoNO(this, e2, n2, o2, i2, r2, a2);
  }
  orthoZO(e2, n2, o2, i2, r2, a2) {
    return t15.orthoZO(this, e2, n2, o2, i2, r2, a2);
  }
  static get BYTE_LENGTH() {
    return 16 * Float32Array.BYTES_PER_ELEMENT;
  }
  static create() {
    return new t15();
  }
  static clone(e2) {
    return new t15(e2);
  }
  static copy(t18, e2) {
    return t18[0] = e2[0], t18[1] = e2[1], t18[2] = e2[2], t18[3] = e2[3], t18[4] = e2[4], t18[5] = e2[5], t18[6] = e2[6], t18[7] = e2[7], t18[8] = e2[8], t18[9] = e2[9], t18[10] = e2[10], t18[11] = e2[11], t18[12] = e2[12], t18[13] = e2[13], t18[14] = e2[14], t18[15] = e2[15], t18;
  }
  static fromValues(...e2) {
    return new t15(...e2);
  }
  static set(t18, ...e2) {
    return t18[0] = e2[0], t18[1] = e2[1], t18[2] = e2[2], t18[3] = e2[3], t18[4] = e2[4], t18[5] = e2[5], t18[6] = e2[6], t18[7] = e2[7], t18[8] = e2[8], t18[9] = e2[9], t18[10] = e2[10], t18[11] = e2[11], t18[12] = e2[12], t18[13] = e2[13], t18[14] = e2[14], t18[15] = e2[15], t18;
  }
  static identity(t18) {
    return t18[0] = 1, t18[1] = 0, t18[2] = 0, t18[3] = 0, t18[4] = 0, t18[5] = 1, t18[6] = 0, t18[7] = 0, t18[8] = 0, t18[9] = 0, t18[10] = 1, t18[11] = 0, t18[12] = 0, t18[13] = 0, t18[14] = 0, t18[15] = 1, t18;
  }
  static transpose(t18, e2) {
    if (t18 === e2) {
      const n2 = e2[1], o2 = e2[2], i2 = e2[3], r2 = e2[6], a2 = e2[7], s2 = e2[11];
      t18[1] = e2[4], t18[2] = e2[8], t18[3] = e2[12], t18[4] = n2, t18[6] = e2[9], t18[7] = e2[13], t18[8] = o2, t18[9] = r2, t18[11] = e2[14], t18[12] = i2, t18[13] = a2, t18[14] = s2;
    } else t18[0] = e2[0], t18[1] = e2[4], t18[2] = e2[8], t18[3] = e2[12], t18[4] = e2[1], t18[5] = e2[5], t18[6] = e2[9], t18[7] = e2[13], t18[8] = e2[2], t18[9] = e2[6], t18[10] = e2[10], t18[11] = e2[14], t18[12] = e2[3], t18[13] = e2[7], t18[14] = e2[11], t18[15] = e2[15];
    return t18;
  }
  static invert(t18, e2) {
    const n2 = e2[0], o2 = e2[1], i2 = e2[2], r2 = e2[3], a2 = e2[4], s2 = e2[5], c2 = e2[6], l2 = e2[7], u2 = e2[8], p2 = e2[9], d2 = e2[10], m2 = e2[11], f2 = e2[12], h2 = e2[13], g2 = e2[14], _ = e2[15], $2 = n2 * s2 - o2 * a2, b2 = n2 * c2 - i2 * a2, y2 = n2 * l2 - r2 * a2, v2 = o2 * c2 - i2 * s2, w2 = o2 * l2 - r2 * s2, S2 = i2 * l2 - r2 * c2, T2 = u2 * h2 - p2 * f2, k2 = u2 * g2 - d2 * f2, x2 = u2 * _ - m2 * f2, E = p2 * g2 - d2 * h2, O2 = p2 * _ - m2 * h2, A2 = d2 * _ - m2 * g2;
    let C2 = $2 * A2 - b2 * O2 + y2 * E + v2 * x2 - w2 * k2 + S2 * T2;
    return C2 ? (C2 = 1 / C2, t18[0] = (s2 * A2 - c2 * O2 + l2 * E) * C2, t18[1] = (i2 * O2 - o2 * A2 - r2 * E) * C2, t18[2] = (h2 * S2 - g2 * w2 + _ * v2) * C2, t18[3] = (d2 * w2 - p2 * S2 - m2 * v2) * C2, t18[4] = (c2 * x2 - a2 * A2 - l2 * k2) * C2, t18[5] = (n2 * A2 - i2 * x2 + r2 * k2) * C2, t18[6] = (g2 * y2 - f2 * S2 - _ * b2) * C2, t18[7] = (u2 * S2 - d2 * y2 + m2 * b2) * C2, t18[8] = (a2 * O2 - s2 * x2 + l2 * T2) * C2, t18[9] = (o2 * x2 - n2 * O2 - r2 * T2) * C2, t18[10] = (f2 * w2 - h2 * y2 + _ * $2) * C2, t18[11] = (p2 * y2 - u2 * w2 - m2 * $2) * C2, t18[12] = (s2 * k2 - a2 * E - c2 * T2) * C2, t18[13] = (n2 * E - o2 * k2 + i2 * T2) * C2, t18[14] = (h2 * b2 - f2 * v2 - g2 * $2) * C2, t18[15] = (u2 * v2 - p2 * b2 + d2 * $2) * C2, t18) : null;
  }
  static adjoint(t18, e2) {
    const n2 = e2[0], o2 = e2[1], i2 = e2[2], r2 = e2[3], a2 = e2[4], s2 = e2[5], c2 = e2[6], l2 = e2[7], u2 = e2[8], p2 = e2[9], d2 = e2[10], m2 = e2[11], f2 = e2[12], h2 = e2[13], g2 = e2[14], _ = e2[15], $2 = n2 * s2 - o2 * a2, b2 = n2 * c2 - i2 * a2, y2 = n2 * l2 - r2 * a2, v2 = o2 * c2 - i2 * s2, w2 = o2 * l2 - r2 * s2, S2 = i2 * l2 - r2 * c2, T2 = u2 * h2 - p2 * f2, k2 = u2 * g2 - d2 * f2, x2 = u2 * _ - m2 * f2, E = p2 * g2 - d2 * h2, O2 = p2 * _ - m2 * h2, A2 = d2 * _ - m2 * g2;
    return t18[0] = s2 * A2 - c2 * O2 + l2 * E, t18[1] = i2 * O2 - o2 * A2 - r2 * E, t18[2] = h2 * S2 - g2 * w2 + _ * v2, t18[3] = d2 * w2 - p2 * S2 - m2 * v2, t18[4] = c2 * x2 - a2 * A2 - l2 * k2, t18[5] = n2 * A2 - i2 * x2 + r2 * k2, t18[6] = g2 * y2 - f2 * S2 - _ * b2, t18[7] = u2 * S2 - d2 * y2 + m2 * b2, t18[8] = a2 * O2 - s2 * x2 + l2 * T2, t18[9] = o2 * x2 - n2 * O2 - r2 * T2, t18[10] = f2 * w2 - h2 * y2 + _ * $2, t18[11] = p2 * y2 - u2 * w2 - m2 * $2, t18[12] = s2 * k2 - a2 * E - c2 * T2, t18[13] = n2 * E - o2 * k2 + i2 * T2, t18[14] = h2 * b2 - f2 * v2 - g2 * $2, t18[15] = u2 * v2 - p2 * b2 + d2 * $2, t18;
  }
  static determinant(t18) {
    const e2 = t18[0], n2 = t18[1], o2 = t18[2], i2 = t18[3], r2 = t18[4], a2 = t18[5], s2 = t18[6], c2 = t18[7], l2 = t18[8], u2 = t18[9], p2 = t18[10], d2 = t18[11], m2 = t18[12], f2 = t18[13], h2 = t18[14], g2 = e2 * a2 - n2 * r2, _ = e2 * s2 - o2 * r2, $2 = n2 * s2 - o2 * a2, b2 = l2 * f2 - u2 * m2, y2 = l2 * h2 - p2 * m2, v2 = u2 * h2 - p2 * f2;
    return c2 * (e2 * v2 - n2 * y2 + o2 * b2) - i2 * (r2 * v2 - a2 * y2 + s2 * b2) + t18[15] * (l2 * $2 - u2 * _ + p2 * g2) - d2 * (m2 * $2 - f2 * _ + h2 * g2);
  }
  static multiply(t18, e2, n2) {
    const o2 = e2[0], i2 = e2[1], r2 = e2[2], a2 = e2[3], s2 = e2[4], c2 = e2[5], l2 = e2[6], u2 = e2[7], p2 = e2[8], d2 = e2[9], m2 = e2[10], f2 = e2[11], h2 = e2[12], g2 = e2[13], _ = e2[14], $2 = e2[15];
    let b2 = n2[0], y2 = n2[1], v2 = n2[2], w2 = n2[3];
    return t18[0] = b2 * o2 + y2 * s2 + v2 * p2 + w2 * h2, t18[1] = b2 * i2 + y2 * c2 + v2 * d2 + w2 * g2, t18[2] = b2 * r2 + y2 * l2 + v2 * m2 + w2 * _, t18[3] = b2 * a2 + y2 * u2 + v2 * f2 + w2 * $2, b2 = n2[4], y2 = n2[5], v2 = n2[6], w2 = n2[7], t18[4] = b2 * o2 + y2 * s2 + v2 * p2 + w2 * h2, t18[5] = b2 * i2 + y2 * c2 + v2 * d2 + w2 * g2, t18[6] = b2 * r2 + y2 * l2 + v2 * m2 + w2 * _, t18[7] = b2 * a2 + y2 * u2 + v2 * f2 + w2 * $2, b2 = n2[8], y2 = n2[9], v2 = n2[10], w2 = n2[11], t18[8] = b2 * o2 + y2 * s2 + v2 * p2 + w2 * h2, t18[9] = b2 * i2 + y2 * c2 + v2 * d2 + w2 * g2, t18[10] = b2 * r2 + y2 * l2 + v2 * m2 + w2 * _, t18[11] = b2 * a2 + y2 * u2 + v2 * f2 + w2 * $2, b2 = n2[12], y2 = n2[13], v2 = n2[14], w2 = n2[15], t18[12] = b2 * o2 + y2 * s2 + v2 * p2 + w2 * h2, t18[13] = b2 * i2 + y2 * c2 + v2 * d2 + w2 * g2, t18[14] = b2 * r2 + y2 * l2 + v2 * m2 + w2 * _, t18[15] = b2 * a2 + y2 * u2 + v2 * f2 + w2 * $2, t18;
  }
  static mul(t18, e2, n2) {
    return t18;
  }
  static translate(t18, e2, n2) {
    const o2 = n2[0], i2 = n2[1], r2 = n2[2];
    if (e2 === t18) t18[12] = e2[0] * o2 + e2[4] * i2 + e2[8] * r2 + e2[12], t18[13] = e2[1] * o2 + e2[5] * i2 + e2[9] * r2 + e2[13], t18[14] = e2[2] * o2 + e2[6] * i2 + e2[10] * r2 + e2[14], t18[15] = e2[3] * o2 + e2[7] * i2 + e2[11] * r2 + e2[15];
    else {
      const n3 = e2[0], a2 = e2[1], s2 = e2[2], c2 = e2[3], l2 = e2[4], u2 = e2[5], p2 = e2[6], d2 = e2[7], m2 = e2[8], f2 = e2[9], h2 = e2[10], g2 = e2[11];
      t18[0] = n3, t18[1] = a2, t18[2] = s2, t18[3] = c2, t18[4] = l2, t18[5] = u2, t18[6] = p2, t18[7] = d2, t18[8] = m2, t18[9] = f2, t18[10] = h2, t18[11] = g2, t18[12] = n3 * o2 + l2 * i2 + m2 * r2 + e2[12], t18[13] = a2 * o2 + u2 * i2 + f2 * r2 + e2[13], t18[14] = s2 * o2 + p2 * i2 + h2 * r2 + e2[14], t18[15] = c2 * o2 + d2 * i2 + g2 * r2 + e2[15];
    }
    return t18;
  }
  static scale(t18, e2, n2) {
    const o2 = n2[0], i2 = n2[1], r2 = n2[2];
    return t18[0] = e2[0] * o2, t18[1] = e2[1] * o2, t18[2] = e2[2] * o2, t18[3] = e2[3] * o2, t18[4] = e2[4] * i2, t18[5] = e2[5] * i2, t18[6] = e2[6] * i2, t18[7] = e2[7] * i2, t18[8] = e2[8] * r2, t18[9] = e2[9] * r2, t18[10] = e2[10] * r2, t18[11] = e2[11] * r2, t18[12] = e2[12], t18[13] = e2[13], t18[14] = e2[14], t18[15] = e2[15], t18;
  }
  static rotate(t18, e2, n2, o2) {
    let i2 = o2[0], r2 = o2[1], a2 = o2[2], s2 = Math.sqrt(i2 * i2 + r2 * r2 + a2 * a2);
    if (s2 < GLM_EPSILON) return null;
    s2 = 1 / s2, i2 *= s2, r2 *= s2, a2 *= s2;
    const c2 = Math.sin(n2), l2 = Math.cos(n2), u2 = 1 - l2, p2 = e2[0], d2 = e2[1], m2 = e2[2], f2 = e2[3], h2 = e2[4], g2 = e2[5], _ = e2[6], $2 = e2[7], b2 = e2[8], y2 = e2[9], v2 = e2[10], w2 = e2[11], S2 = i2 * i2 * u2 + l2, T2 = r2 * i2 * u2 + a2 * c2, k2 = a2 * i2 * u2 - r2 * c2, x2 = i2 * r2 * u2 - a2 * c2, E = r2 * r2 * u2 + l2, O2 = a2 * r2 * u2 + i2 * c2, A2 = i2 * a2 * u2 + r2 * c2, C2 = r2 * a2 * u2 - i2 * c2, M = a2 * a2 * u2 + l2;
    return t18[0] = p2 * S2 + h2 * T2 + b2 * k2, t18[1] = d2 * S2 + g2 * T2 + y2 * k2, t18[2] = m2 * S2 + _ * T2 + v2 * k2, t18[3] = f2 * S2 + $2 * T2 + w2 * k2, t18[4] = p2 * x2 + h2 * E + b2 * O2, t18[5] = d2 * x2 + g2 * E + y2 * O2, t18[6] = m2 * x2 + _ * E + v2 * O2, t18[7] = f2 * x2 + $2 * E + w2 * O2, t18[8] = p2 * A2 + h2 * C2 + b2 * M, t18[9] = d2 * A2 + g2 * C2 + y2 * M, t18[10] = m2 * A2 + _ * C2 + v2 * M, t18[11] = f2 * A2 + $2 * C2 + w2 * M, e2 !== t18 && (t18[12] = e2[12], t18[13] = e2[13], t18[14] = e2[14], t18[15] = e2[15]), t18;
  }
  static rotateX(t18, e2, n2) {
    const o2 = Math.sin(n2), i2 = Math.cos(n2), r2 = e2[4], a2 = e2[5], s2 = e2[6], c2 = e2[7], l2 = e2[8], u2 = e2[9], p2 = e2[10], d2 = e2[11];
    return e2 !== t18 && (t18[0] = e2[0], t18[1] = e2[1], t18[2] = e2[2], t18[3] = e2[3], t18[12] = e2[12], t18[13] = e2[13], t18[14] = e2[14], t18[15] = e2[15]), t18[4] = r2 * i2 + l2 * o2, t18[5] = a2 * i2 + u2 * o2, t18[6] = s2 * i2 + p2 * o2, t18[7] = c2 * i2 + d2 * o2, t18[8] = l2 * i2 - r2 * o2, t18[9] = u2 * i2 - a2 * o2, t18[10] = p2 * i2 - s2 * o2, t18[11] = d2 * i2 - c2 * o2, t18;
  }
  static rotateY(t18, e2, n2) {
    const o2 = Math.sin(n2), i2 = Math.cos(n2), r2 = e2[0], a2 = e2[1], s2 = e2[2], c2 = e2[3], l2 = e2[8], u2 = e2[9], p2 = e2[10], d2 = e2[11];
    return e2 !== t18 && (t18[4] = e2[4], t18[5] = e2[5], t18[6] = e2[6], t18[7] = e2[7], t18[12] = e2[12], t18[13] = e2[13], t18[14] = e2[14], t18[15] = e2[15]), t18[0] = r2 * i2 - l2 * o2, t18[1] = a2 * i2 - u2 * o2, t18[2] = s2 * i2 - p2 * o2, t18[3] = c2 * i2 - d2 * o2, t18[8] = r2 * o2 + l2 * i2, t18[9] = a2 * o2 + u2 * i2, t18[10] = s2 * o2 + p2 * i2, t18[11] = c2 * o2 + d2 * i2, t18;
  }
  static rotateZ(t18, e2, n2) {
    const o2 = Math.sin(n2), i2 = Math.cos(n2), r2 = e2[0], a2 = e2[1], s2 = e2[2], c2 = e2[3], l2 = e2[4], u2 = e2[5], p2 = e2[6], d2 = e2[7];
    return e2 !== t18 && (t18[8] = e2[8], t18[9] = e2[9], t18[10] = e2[10], t18[11] = e2[11], t18[12] = e2[12], t18[13] = e2[13], t18[14] = e2[14], t18[15] = e2[15]), t18[0] = r2 * i2 + l2 * o2, t18[1] = a2 * i2 + u2 * o2, t18[2] = s2 * i2 + p2 * o2, t18[3] = c2 * i2 + d2 * o2, t18[4] = l2 * i2 - r2 * o2, t18[5] = u2 * i2 - a2 * o2, t18[6] = p2 * i2 - s2 * o2, t18[7] = d2 * i2 - c2 * o2, t18;
  }
  static fromTranslation(t18, e2) {
    return t18[0] = 1, t18[1] = 0, t18[2] = 0, t18[3] = 0, t18[4] = 0, t18[5] = 1, t18[6] = 0, t18[7] = 0, t18[8] = 0, t18[9] = 0, t18[10] = 1, t18[11] = 0, t18[12] = e2[0], t18[13] = e2[1], t18[14] = e2[2], t18[15] = 1, t18;
  }
  static fromScaling(t18, e2) {
    return t18[0] = e2[0], t18[1] = 0, t18[2] = 0, t18[3] = 0, t18[4] = 0, t18[5] = e2[1], t18[6] = 0, t18[7] = 0, t18[8] = 0, t18[9] = 0, t18[10] = e2[2], t18[11] = 0, t18[12] = 0, t18[13] = 0, t18[14] = 0, t18[15] = 1, t18;
  }
  static fromRotation(t18, e2, n2) {
    let o2 = n2[0], i2 = n2[1], r2 = n2[2], a2 = Math.sqrt(o2 * o2 + i2 * i2 + r2 * r2);
    if (a2 < GLM_EPSILON) return null;
    a2 = 1 / a2, o2 *= a2, i2 *= a2, r2 *= a2;
    const s2 = Math.sin(e2), c2 = Math.cos(e2), l2 = 1 - c2;
    return t18[0] = o2 * o2 * l2 + c2, t18[1] = i2 * o2 * l2 + r2 * s2, t18[2] = r2 * o2 * l2 - i2 * s2, t18[3] = 0, t18[4] = o2 * i2 * l2 - r2 * s2, t18[5] = i2 * i2 * l2 + c2, t18[6] = r2 * i2 * l2 + o2 * s2, t18[7] = 0, t18[8] = o2 * r2 * l2 + i2 * s2, t18[9] = i2 * r2 * l2 - o2 * s2, t18[10] = r2 * r2 * l2 + c2, t18[11] = 0, t18[12] = 0, t18[13] = 0, t18[14] = 0, t18[15] = 1, t18;
  }
  static fromXRotation(t18, e2) {
    const n2 = Math.sin(e2), o2 = Math.cos(e2);
    return t18[0] = 1, t18[1] = 0, t18[2] = 0, t18[3] = 0, t18[4] = 0, t18[5] = o2, t18[6] = n2, t18[7] = 0, t18[8] = 0, t18[9] = -n2, t18[10] = o2, t18[11] = 0, t18[12] = 0, t18[13] = 0, t18[14] = 0, t18[15] = 1, t18;
  }
  static fromYRotation(t18, e2) {
    const n2 = Math.sin(e2), o2 = Math.cos(e2);
    return t18[0] = o2, t18[1] = 0, t18[2] = -n2, t18[3] = 0, t18[4] = 0, t18[5] = 1, t18[6] = 0, t18[7] = 0, t18[8] = n2, t18[9] = 0, t18[10] = o2, t18[11] = 0, t18[12] = 0, t18[13] = 0, t18[14] = 0, t18[15] = 1, t18;
  }
  static fromZRotation(t18, e2) {
    const n2 = Math.sin(e2), o2 = Math.cos(e2);
    return t18[0] = o2, t18[1] = n2, t18[2] = 0, t18[3] = 0, t18[4] = -n2, t18[5] = o2, t18[6] = 0, t18[7] = 0, t18[8] = 0, t18[9] = 0, t18[10] = 1, t18[11] = 0, t18[12] = 0, t18[13] = 0, t18[14] = 0, t18[15] = 1, t18;
  }
  static fromRotationTranslation(t18, e2, n2) {
    const o2 = e2[0], i2 = e2[1], r2 = e2[2], a2 = e2[3], s2 = o2 + o2, c2 = i2 + i2, l2 = r2 + r2, u2 = o2 * s2, p2 = o2 * c2, d2 = o2 * l2, m2 = i2 * c2, f2 = i2 * l2, h2 = r2 * l2, g2 = a2 * s2, _ = a2 * c2, $2 = a2 * l2;
    return t18[0] = 1 - (m2 + h2), t18[1] = p2 + $2, t18[2] = d2 - _, t18[3] = 0, t18[4] = p2 - $2, t18[5] = 1 - (u2 + h2), t18[6] = f2 + g2, t18[7] = 0, t18[8] = d2 + _, t18[9] = f2 - g2, t18[10] = 1 - (u2 + m2), t18[11] = 0, t18[12] = n2[0], t18[13] = n2[1], t18[14] = n2[2], t18[15] = 1, t18;
  }
  static fromQuat2(e2, n2) {
    const o2 = -n2[0], i2 = -n2[1], r2 = -n2[2], a2 = n2[3], s2 = n2[4], c2 = n2[5], l2 = n2[6], u2 = n2[7], p2 = o2 * o2 + i2 * i2 + r2 * r2 + a2 * a2;
    return p2 > 0 ? (t15.#b[0] = 2 * (s2 * a2 + u2 * o2 + c2 * r2 - l2 * i2) / p2, t15.#b[1] = 2 * (c2 * a2 + u2 * i2 + l2 * o2 - s2 * r2) / p2, t15.#b[2] = 2 * (l2 * a2 + u2 * r2 + s2 * i2 - c2 * o2) / p2) : (t15.#b[0] = 2 * (s2 * a2 + u2 * o2 + c2 * r2 - l2 * i2), t15.#b[1] = 2 * (c2 * a2 + u2 * i2 + l2 * o2 - s2 * r2), t15.#b[2] = 2 * (l2 * a2 + u2 * r2 + s2 * i2 - c2 * o2)), t15.fromRotationTranslation(e2, n2, t15.#b), e2;
  }
  static normalFromMat4(t18, e2) {
    const n2 = e2[0], o2 = e2[1], i2 = e2[2], r2 = e2[3], a2 = e2[4], s2 = e2[5], c2 = e2[6], l2 = e2[7], u2 = e2[8], p2 = e2[9], d2 = e2[10], m2 = e2[11], f2 = e2[12], h2 = e2[13], g2 = e2[14], _ = e2[15], $2 = n2 * s2 - o2 * a2, b2 = n2 * c2 - i2 * a2, y2 = n2 * l2 - r2 * a2, v2 = o2 * c2 - i2 * s2, w2 = o2 * l2 - r2 * s2, S2 = i2 * l2 - r2 * c2, T2 = u2 * h2 - p2 * f2, k2 = u2 * g2 - d2 * f2, x2 = u2 * _ - m2 * f2, E = p2 * g2 - d2 * h2, O2 = p2 * _ - m2 * h2, A2 = d2 * _ - m2 * g2;
    let C2 = $2 * A2 - b2 * O2 + y2 * E + v2 * x2 - w2 * k2 + S2 * T2;
    return C2 ? (C2 = 1 / C2, t18[0] = (s2 * A2 - c2 * O2 + l2 * E) * C2, t18[1] = (c2 * x2 - a2 * A2 - l2 * k2) * C2, t18[2] = (a2 * O2 - s2 * x2 + l2 * T2) * C2, t18[3] = 0, t18[4] = (i2 * O2 - o2 * A2 - r2 * E) * C2, t18[5] = (n2 * A2 - i2 * x2 + r2 * k2) * C2, t18[6] = (o2 * x2 - n2 * O2 - r2 * T2) * C2, t18[7] = 0, t18[8] = (h2 * S2 - g2 * w2 + _ * v2) * C2, t18[9] = (g2 * y2 - f2 * S2 - _ * b2) * C2, t18[10] = (f2 * w2 - h2 * y2 + _ * $2) * C2, t18[11] = 0, t18[12] = 0, t18[13] = 0, t18[14] = 0, t18[15] = 1, t18) : null;
  }
  static normalFromMat4Fast(t18, e2) {
    const n2 = e2[0], o2 = e2[1], i2 = e2[2], r2 = e2[4], a2 = e2[5], s2 = e2[6], c2 = e2[8], l2 = e2[9], u2 = e2[10];
    return t18[0] = a2 * u2 - u2 * l2, t18[1] = s2 * c2 - c2 * u2, t18[2] = r2 * l2 - l2 * c2, t18[3] = 0, t18[4] = l2 * i2 - u2 * o2, t18[5] = u2 * n2 - c2 * i2, t18[6] = c2 * o2 - l2 * n2, t18[7] = 0, t18[8] = o2 * s2 - i2 * a2, t18[9] = i2 * r2 - n2 * s2, t18[10] = n2 * a2 - o2 * r2, t18[11] = 0, t18[12] = 0, t18[13] = 0, t18[14] = 0, t18[15] = 1, t18;
  }
  static getTranslation(t18, e2) {
    return t18[0] = e2[12], t18[1] = e2[13], t18[2] = e2[14], t18;
  }
  static getScaling(t18, e2) {
    const n2 = e2[0], o2 = e2[1], i2 = e2[2], r2 = e2[4], a2 = e2[5], s2 = e2[6], c2 = e2[8], l2 = e2[9], u2 = e2[10];
    return t18[0] = Math.sqrt(n2 * n2 + o2 * o2 + i2 * i2), t18[1] = Math.sqrt(r2 * r2 + a2 * a2 + s2 * s2), t18[2] = Math.sqrt(c2 * c2 + l2 * l2 + u2 * u2), t18;
  }
  static getRotation(e2, n2) {
    t15.getScaling(t15.#b, n2);
    const o2 = 1 / t15.#b[0], i2 = 1 / t15.#b[1], r2 = 1 / t15.#b[2], a2 = n2[0] * o2, s2 = n2[1] * i2, c2 = n2[2] * r2, l2 = n2[4] * o2, u2 = n2[5] * i2, p2 = n2[6] * r2, d2 = n2[8] * o2, m2 = n2[9] * i2, f2 = n2[10] * r2, h2 = a2 + u2 + f2;
    let g2 = 0;
    return h2 > 0 ? (g2 = 2 * Math.sqrt(h2 + 1), e2[3] = 0.25 * g2, e2[0] = (p2 - m2) / g2, e2[1] = (d2 - c2) / g2, e2[2] = (s2 - l2) / g2) : a2 > u2 && a2 > f2 ? (g2 = 2 * Math.sqrt(1 + a2 - u2 - f2), e2[3] = (p2 - m2) / g2, e2[0] = 0.25 * g2, e2[1] = (s2 + l2) / g2, e2[2] = (d2 + c2) / g2) : u2 > f2 ? (g2 = 2 * Math.sqrt(1 + u2 - a2 - f2), e2[3] = (d2 - c2) / g2, e2[0] = (s2 + l2) / g2, e2[1] = 0.25 * g2, e2[2] = (p2 + m2) / g2) : (g2 = 2 * Math.sqrt(1 + f2 - a2 - u2), e2[3] = (s2 - l2) / g2, e2[0] = (d2 + c2) / g2, e2[1] = (p2 + m2) / g2, e2[2] = 0.25 * g2), e2;
  }
  static decompose(t18, e2, n2, o2) {
    e2[0] = o2[12], e2[1] = o2[13], e2[2] = o2[14];
    const i2 = o2[0], r2 = o2[1], a2 = o2[2], s2 = o2[4], c2 = o2[5], l2 = o2[6], u2 = o2[8], p2 = o2[9], d2 = o2[10];
    n2[0] = Math.sqrt(i2 * i2 + r2 * r2 + a2 * a2), n2[1] = Math.sqrt(s2 * s2 + c2 * c2 + l2 * l2), n2[2] = Math.sqrt(u2 * u2 + p2 * p2 + d2 * d2);
    const m2 = 1 / n2[0], f2 = 1 / n2[1], h2 = 1 / n2[2], g2 = i2 * m2, _ = r2 * f2, $2 = a2 * h2, b2 = s2 * m2, y2 = c2 * f2, v2 = l2 * h2, w2 = u2 * m2, S2 = p2 * f2, T2 = d2 * h2, k2 = g2 + y2 + T2;
    let x2 = 0;
    return k2 > 0 ? (x2 = 2 * Math.sqrt(k2 + 1), t18[3] = 0.25 * x2, t18[0] = (v2 - S2) / x2, t18[1] = (w2 - $2) / x2, t18[2] = (_ - b2) / x2) : g2 > y2 && g2 > T2 ? (x2 = 2 * Math.sqrt(1 + g2 - y2 - T2), t18[3] = (v2 - S2) / x2, t18[0] = 0.25 * x2, t18[1] = (_ + b2) / x2, t18[2] = (w2 + $2) / x2) : y2 > T2 ? (x2 = 2 * Math.sqrt(1 + y2 - g2 - T2), t18[3] = (w2 - $2) / x2, t18[0] = (_ + b2) / x2, t18[1] = 0.25 * x2, t18[2] = (v2 + S2) / x2) : (x2 = 2 * Math.sqrt(1 + T2 - g2 - y2), t18[3] = (_ - b2) / x2, t18[0] = (w2 + $2) / x2, t18[1] = (v2 + S2) / x2, t18[2] = 0.25 * x2), t18;
  }
  static fromRotationTranslationScale(t18, e2, n2, o2) {
    const i2 = e2[0], r2 = e2[1], a2 = e2[2], s2 = e2[3], c2 = i2 + i2, l2 = r2 + r2, u2 = a2 + a2, p2 = i2 * c2, d2 = i2 * l2, m2 = i2 * u2, f2 = r2 * l2, h2 = r2 * u2, g2 = a2 * u2, _ = s2 * c2, $2 = s2 * l2, b2 = s2 * u2, y2 = o2[0], v2 = o2[1], w2 = o2[2];
    return t18[0] = (1 - (f2 + g2)) * y2, t18[1] = (d2 + b2) * y2, t18[2] = (m2 - $2) * y2, t18[3] = 0, t18[4] = (d2 - b2) * v2, t18[5] = (1 - (p2 + g2)) * v2, t18[6] = (h2 + _) * v2, t18[7] = 0, t18[8] = (m2 + $2) * w2, t18[9] = (h2 - _) * w2, t18[10] = (1 - (p2 + f2)) * w2, t18[11] = 0, t18[12] = n2[0], t18[13] = n2[1], t18[14] = n2[2], t18[15] = 1, t18;
  }
  static fromRotationTranslationScaleOrigin(t18, e2, n2, o2, i2) {
    const r2 = e2[0], a2 = e2[1], s2 = e2[2], c2 = e2[3], l2 = r2 + r2, u2 = a2 + a2, p2 = s2 + s2, d2 = r2 * l2, m2 = r2 * u2, f2 = r2 * p2, h2 = a2 * u2, g2 = a2 * p2, _ = s2 * p2, $2 = c2 * l2, b2 = c2 * u2, y2 = c2 * p2, v2 = o2[0], w2 = o2[1], S2 = o2[2], T2 = i2[0], k2 = i2[1], x2 = i2[2], E = (1 - (h2 + _)) * v2, O2 = (m2 + y2) * v2, A2 = (f2 - b2) * v2, C2 = (m2 - y2) * w2, M = (1 - (d2 + _)) * w2, I2 = (g2 + $2) * w2, N2 = (f2 + b2) * S2, P2 = (g2 - $2) * S2, D2 = (1 - (d2 + h2)) * S2;
    return t18[0] = E, t18[1] = O2, t18[2] = A2, t18[3] = 0, t18[4] = C2, t18[5] = M, t18[6] = I2, t18[7] = 0, t18[8] = N2, t18[9] = P2, t18[10] = D2, t18[11] = 0, t18[12] = n2[0] + T2 - (E * T2 + C2 * k2 + N2 * x2), t18[13] = n2[1] + k2 - (O2 * T2 + M * k2 + P2 * x2), t18[14] = n2[2] + x2 - (A2 * T2 + I2 * k2 + D2 * x2), t18[15] = 1, t18;
  }
  static fromQuat(t18, e2) {
    const n2 = e2[0], o2 = e2[1], i2 = e2[2], r2 = e2[3], a2 = n2 + n2, s2 = o2 + o2, c2 = i2 + i2, l2 = n2 * a2, u2 = o2 * a2, p2 = o2 * s2, d2 = i2 * a2, m2 = i2 * s2, f2 = i2 * c2, h2 = r2 * a2, g2 = r2 * s2, _ = r2 * c2;
    return t18[0] = 1 - p2 - f2, t18[1] = u2 + _, t18[2] = d2 - g2, t18[3] = 0, t18[4] = u2 - _, t18[5] = 1 - l2 - f2, t18[6] = m2 + h2, t18[7] = 0, t18[8] = d2 + g2, t18[9] = m2 - h2, t18[10] = 1 - l2 - p2, t18[11] = 0, t18[12] = 0, t18[13] = 0, t18[14] = 0, t18[15] = 1, t18;
  }
  static frustumNO(t18, e2, n2, o2, i2, r2, a2 = 1 / 0) {
    const s2 = 1 / (n2 - e2), c2 = 1 / (i2 - o2);
    if (t18[0] = 2 * r2 * s2, t18[1] = 0, t18[2] = 0, t18[3] = 0, t18[4] = 0, t18[5] = 2 * r2 * c2, t18[6] = 0, t18[7] = 0, t18[8] = (n2 + e2) * s2, t18[9] = (i2 + o2) * c2, t18[11] = -1, t18[12] = 0, t18[13] = 0, t18[15] = 0, null != a2 && a2 !== 1 / 0) {
      const e3 = 1 / (r2 - a2);
      t18[10] = (a2 + r2) * e3, t18[14] = 2 * a2 * r2 * e3;
    } else t18[10] = -1, t18[14] = -2 * r2;
    return t18;
  }
  static frustum(t18, e2, n2, o2, i2, r2, a2 = 1 / 0) {
    return t18;
  }
  static frustumZO(t18, e2, n2, o2, i2, r2, a2 = 1 / 0) {
    const s2 = 1 / (n2 - e2), c2 = 1 / (i2 - o2);
    if (t18[0] = 2 * r2 * s2, t18[1] = 0, t18[2] = 0, t18[3] = 0, t18[4] = 0, t18[5] = 2 * r2 * c2, t18[6] = 0, t18[7] = 0, t18[8] = (n2 + e2) * s2, t18[9] = (i2 + o2) * c2, t18[11] = -1, t18[12] = 0, t18[13] = 0, t18[15] = 0, null != a2 && a2 !== 1 / 0) {
      const e3 = 1 / (r2 - a2);
      t18[10] = a2 * e3, t18[14] = a2 * r2 * e3;
    } else t18[10] = -1, t18[14] = -r2;
    return t18;
  }
  static perspectiveNO(t18, e2, n2, o2, i2 = 1 / 0) {
    const r2 = 1 / Math.tan(e2 / 2);
    if (t18[0] = r2 / n2, t18[1] = 0, t18[2] = 0, t18[3] = 0, t18[4] = 0, t18[5] = r2, t18[6] = 0, t18[7] = 0, t18[8] = 0, t18[9] = 0, t18[11] = -1, t18[12] = 0, t18[13] = 0, t18[15] = 0, null != i2 && i2 !== 1 / 0) {
      const e3 = 1 / (o2 - i2);
      t18[10] = (i2 + o2) * e3, t18[14] = 2 * i2 * o2 * e3;
    } else t18[10] = -1, t18[14] = -2 * o2;
    return t18;
  }
  static perspective(t18, e2, n2, o2, i2 = 1 / 0) {
    return t18;
  }
  static perspectiveZO(t18, e2, n2, o2, i2 = 1 / 0) {
    const r2 = 1 / Math.tan(e2 / 2);
    if (t18[0] = r2 / n2, t18[1] = 0, t18[2] = 0, t18[3] = 0, t18[4] = 0, t18[5] = r2, t18[6] = 0, t18[7] = 0, t18[8] = 0, t18[9] = 0, t18[11] = -1, t18[12] = 0, t18[13] = 0, t18[15] = 0, null != i2 && i2 !== 1 / 0) {
      const e3 = 1 / (o2 - i2);
      t18[10] = i2 * e3, t18[14] = i2 * o2 * e3;
    } else t18[10] = -1, t18[14] = -o2;
    return t18;
  }
  static perspectiveFromFieldOfView(t18, e2, n2, o2) {
    const i2 = Math.tan(e2.upDegrees * Math.PI / 180), r2 = Math.tan(e2.downDegrees * Math.PI / 180), a2 = Math.tan(e2.leftDegrees * Math.PI / 180), s2 = Math.tan(e2.rightDegrees * Math.PI / 180), c2 = 2 / (a2 + s2), l2 = 2 / (i2 + r2);
    return t18[0] = c2, t18[1] = 0, t18[2] = 0, t18[3] = 0, t18[4] = 0, t18[5] = l2, t18[6] = 0, t18[7] = 0, t18[8] = -(a2 - s2) * c2 * 0.5, t18[9] = (i2 - r2) * l2 * 0.5, t18[10] = o2 / (n2 - o2), t18[11] = -1, t18[12] = 0, t18[13] = 0, t18[14] = o2 * n2 / (n2 - o2), t18[15] = 0, t18;
  }
  static orthoNO(t18, e2, n2, o2, i2, r2, a2) {
    const s2 = 1 / (e2 - n2), c2 = 1 / (o2 - i2), l2 = 1 / (r2 - a2);
    return t18[0] = -2 * s2, t18[1] = 0, t18[2] = 0, t18[3] = 0, t18[4] = 0, t18[5] = -2 * c2, t18[6] = 0, t18[7] = 0, t18[8] = 0, t18[9] = 0, t18[10] = 2 * l2, t18[11] = 0, t18[12] = (e2 + n2) * s2, t18[13] = (i2 + o2) * c2, t18[14] = (a2 + r2) * l2, t18[15] = 1, t18;
  }
  static ortho(t18, e2, n2, o2, i2, r2, a2) {
    return t18;
  }
  static orthoZO(t18, e2, n2, o2, i2, r2, a2) {
    const s2 = 1 / (e2 - n2), c2 = 1 / (o2 - i2), l2 = 1 / (r2 - a2);
    return t18[0] = -2 * s2, t18[1] = 0, t18[2] = 0, t18[3] = 0, t18[4] = 0, t18[5] = -2 * c2, t18[6] = 0, t18[7] = 0, t18[8] = 0, t18[9] = 0, t18[10] = l2, t18[11] = 0, t18[12] = (e2 + n2) * s2, t18[13] = (i2 + o2) * c2, t18[14] = r2 * l2, t18[15] = 1, t18;
  }
  static lookAt(e2, n2, o2, i2) {
    const r2 = n2[0], a2 = n2[1], s2 = n2[2], c2 = i2[0], l2 = i2[1], u2 = i2[2], p2 = o2[0], d2 = o2[1], m2 = o2[2];
    if (Math.abs(r2 - p2) < GLM_EPSILON && Math.abs(a2 - d2) < GLM_EPSILON && Math.abs(s2 - m2) < GLM_EPSILON) return t15.identity(e2);
    let f2 = r2 - p2, h2 = a2 - d2, g2 = s2 - m2, _ = 1 / Math.sqrt(f2 * f2 + h2 * h2 + g2 * g2);
    f2 *= _, h2 *= _, g2 *= _;
    let $2 = l2 * g2 - u2 * h2, b2 = u2 * f2 - c2 * g2, y2 = c2 * h2 - l2 * f2;
    _ = Math.sqrt($2 * $2 + b2 * b2 + y2 * y2), _ ? (_ = 1 / _, $2 *= _, b2 *= _, y2 *= _) : ($2 = 0, b2 = 0, y2 = 0);
    let v2 = h2 * y2 - g2 * b2, w2 = g2 * $2 - f2 * y2, S2 = f2 * b2 - h2 * $2;
    return _ = Math.sqrt(v2 * v2 + w2 * w2 + S2 * S2), _ ? (_ = 1 / _, v2 *= _, w2 *= _, S2 *= _) : (v2 = 0, w2 = 0, S2 = 0), e2[0] = $2, e2[1] = v2, e2[2] = f2, e2[3] = 0, e2[4] = b2, e2[5] = w2, e2[6] = h2, e2[7] = 0, e2[8] = y2, e2[9] = S2, e2[10] = g2, e2[11] = 0, e2[12] = -($2 * r2 + b2 * a2 + y2 * s2), e2[13] = -(v2 * r2 + w2 * a2 + S2 * s2), e2[14] = -(f2 * r2 + h2 * a2 + g2 * s2), e2[15] = 1, e2;
  }
  static targetTo(t18, e2, n2, o2) {
    const i2 = e2[0], r2 = e2[1], a2 = e2[2], s2 = o2[0], c2 = o2[1], l2 = o2[2];
    let u2 = i2 - n2[0], p2 = r2 - n2[1], d2 = a2 - n2[2], m2 = u2 * u2 + p2 * p2 + d2 * d2;
    m2 > 0 && (m2 = 1 / Math.sqrt(m2), u2 *= m2, p2 *= m2, d2 *= m2);
    let f2 = c2 * d2 - l2 * p2, h2 = l2 * u2 - s2 * d2, g2 = s2 * p2 - c2 * u2;
    return m2 = f2 * f2 + h2 * h2 + g2 * g2, m2 > 0 && (m2 = 1 / Math.sqrt(m2), f2 *= m2, h2 *= m2, g2 *= m2), t18[0] = f2, t18[1] = h2, t18[2] = g2, t18[3] = 0, t18[4] = p2 * g2 - d2 * h2, t18[5] = d2 * f2 - u2 * g2, t18[6] = u2 * h2 - p2 * f2, t18[7] = 0, t18[8] = u2, t18[9] = p2, t18[10] = d2, t18[11] = 0, t18[12] = i2, t18[13] = r2, t18[14] = a2, t18[15] = 1, t18;
  }
  static frob(t18) {
    return Math.sqrt(t18[0] * t18[0] + t18[1] * t18[1] + t18[2] * t18[2] + t18[3] * t18[3] + t18[4] * t18[4] + t18[5] * t18[5] + t18[6] * t18[6] + t18[7] * t18[7] + t18[8] * t18[8] + t18[9] * t18[9] + t18[10] * t18[10] + t18[11] * t18[11] + t18[12] * t18[12] + t18[13] * t18[13] + t18[14] * t18[14] + t18[15] * t18[15]);
  }
  static add(t18, e2, n2) {
    return t18[0] = e2[0] + n2[0], t18[1] = e2[1] + n2[1], t18[2] = e2[2] + n2[2], t18[3] = e2[3] + n2[3], t18[4] = e2[4] + n2[4], t18[5] = e2[5] + n2[5], t18[6] = e2[6] + n2[6], t18[7] = e2[7] + n2[7], t18[8] = e2[8] + n2[8], t18[9] = e2[9] + n2[9], t18[10] = e2[10] + n2[10], t18[11] = e2[11] + n2[11], t18[12] = e2[12] + n2[12], t18[13] = e2[13] + n2[13], t18[14] = e2[14] + n2[14], t18[15] = e2[15] + n2[15], t18;
  }
  static subtract(t18, e2, n2) {
    return t18[0] = e2[0] - n2[0], t18[1] = e2[1] - n2[1], t18[2] = e2[2] - n2[2], t18[3] = e2[3] - n2[3], t18[4] = e2[4] - n2[4], t18[5] = e2[5] - n2[5], t18[6] = e2[6] - n2[6], t18[7] = e2[7] - n2[7], t18[8] = e2[8] - n2[8], t18[9] = e2[9] - n2[9], t18[10] = e2[10] - n2[10], t18[11] = e2[11] - n2[11], t18[12] = e2[12] - n2[12], t18[13] = e2[13] - n2[13], t18[14] = e2[14] - n2[14], t18[15] = e2[15] - n2[15], t18;
  }
  static sub(t18, e2, n2) {
    return t18;
  }
  static multiplyScalar(t18, e2, n2) {
    return t18[0] = e2[0] * n2, t18[1] = e2[1] * n2, t18[2] = e2[2] * n2, t18[3] = e2[3] * n2, t18[4] = e2[4] * n2, t18[5] = e2[5] * n2, t18[6] = e2[6] * n2, t18[7] = e2[7] * n2, t18[8] = e2[8] * n2, t18[9] = e2[9] * n2, t18[10] = e2[10] * n2, t18[11] = e2[11] * n2, t18[12] = e2[12] * n2, t18[13] = e2[13] * n2, t18[14] = e2[14] * n2, t18[15] = e2[15] * n2, t18;
  }
  static multiplyScalarAndAdd(t18, e2, n2, o2) {
    return t18[0] = e2[0] + n2[0] * o2, t18[1] = e2[1] + n2[1] * o2, t18[2] = e2[2] + n2[2] * o2, t18[3] = e2[3] + n2[3] * o2, t18[4] = e2[4] + n2[4] * o2, t18[5] = e2[5] + n2[5] * o2, t18[6] = e2[6] + n2[6] * o2, t18[7] = e2[7] + n2[7] * o2, t18[8] = e2[8] + n2[8] * o2, t18[9] = e2[9] + n2[9] * o2, t18[10] = e2[10] + n2[10] * o2, t18[11] = e2[11] + n2[11] * o2, t18[12] = e2[12] + n2[12] * o2, t18[13] = e2[13] + n2[13] * o2, t18[14] = e2[14] + n2[14] * o2, t18[15] = e2[15] + n2[15] * o2, t18;
  }
  static exactEquals(t18, e2) {
    return t18[0] === e2[0] && t18[1] === e2[1] && t18[2] === e2[2] && t18[3] === e2[3] && t18[4] === e2[4] && t18[5] === e2[5] && t18[6] === e2[6] && t18[7] === e2[7] && t18[8] === e2[8] && t18[9] === e2[9] && t18[10] === e2[10] && t18[11] === e2[11] && t18[12] === e2[12] && t18[13] === e2[13] && t18[14] === e2[14] && t18[15] === e2[15];
  }
  static equals(t18, e2) {
    const n2 = t18[0], o2 = t18[1], i2 = t18[2], r2 = t18[3], a2 = t18[4], s2 = t18[5], c2 = t18[6], l2 = t18[7], u2 = t18[8], p2 = t18[9], d2 = t18[10], m2 = t18[11], f2 = t18[12], h2 = t18[13], g2 = t18[14], _ = t18[15], $2 = e2[0], b2 = e2[1], y2 = e2[2], v2 = e2[3], w2 = e2[4], S2 = e2[5], T2 = e2[6], k2 = e2[7], x2 = e2[8], E = e2[9], O2 = e2[10], A2 = e2[11], C2 = e2[12], M = e2[13], I2 = e2[14], N2 = e2[15];
    return Math.abs(n2 - $2) <= GLM_EPSILON * Math.max(1, Math.abs(n2), Math.abs($2)) && Math.abs(o2 - b2) <= GLM_EPSILON * Math.max(1, Math.abs(o2), Math.abs(b2)) && Math.abs(i2 - y2) <= GLM_EPSILON * Math.max(1, Math.abs(i2), Math.abs(y2)) && Math.abs(r2 - v2) <= GLM_EPSILON * Math.max(1, Math.abs(r2), Math.abs(v2)) && Math.abs(a2 - w2) <= GLM_EPSILON * Math.max(1, Math.abs(a2), Math.abs(w2)) && Math.abs(s2 - S2) <= GLM_EPSILON * Math.max(1, Math.abs(s2), Math.abs(S2)) && Math.abs(c2 - T2) <= GLM_EPSILON * Math.max(1, Math.abs(c2), Math.abs(T2)) && Math.abs(l2 - k2) <= GLM_EPSILON * Math.max(1, Math.abs(l2), Math.abs(k2)) && Math.abs(u2 - x2) <= GLM_EPSILON * Math.max(1, Math.abs(u2), Math.abs(x2)) && Math.abs(p2 - E) <= GLM_EPSILON * Math.max(1, Math.abs(p2), Math.abs(E)) && Math.abs(d2 - O2) <= GLM_EPSILON * Math.max(1, Math.abs(d2), Math.abs(O2)) && Math.abs(m2 - A2) <= GLM_EPSILON * Math.max(1, Math.abs(m2), Math.abs(A2)) && Math.abs(f2 - C2) <= GLM_EPSILON * Math.max(1, Math.abs(f2), Math.abs(C2)) && Math.abs(h2 - M) <= GLM_EPSILON * Math.max(1, Math.abs(h2), Math.abs(M)) && Math.abs(g2 - I2) <= GLM_EPSILON * Math.max(1, Math.abs(g2), Math.abs(I2)) && Math.abs(_ - N2) <= GLM_EPSILON * Math.max(1, Math.abs(_), Math.abs(N2));
  }
  static str(t18) {
    return `Mat4(${t18.join(", ")})`;
  }
};
Mat4.prototype.mul = Mat4.prototype.multiply, Mat4.sub = Mat4.subtract, Mat4.mul = Mat4.multiply, Mat4.frustum = Mat4.frustumNO, Mat4.perspective = Mat4.perspectiveNO, Mat4.ortho = Mat4.orthoNO;
var Vec3 = class t16 extends Float32Array {
  constructor(...t18) {
    switch (t18.length) {
      case 3:
        super(t18);
        break;
      case 2:
        super(t18[0], t18[1], 3);
        break;
      case 1: {
        const e2 = t18[0];
        "number" == typeof e2 ? super([e2, e2, e2]) : super(e2, 0, 3);
        break;
      }
      default:
        super(3);
    }
  }
  get x() {
    return this[0];
  }
  set x(t18) {
    this[0] = t18;
  }
  get y() {
    return this[1];
  }
  set y(t18) {
    this[1] = t18;
  }
  get z() {
    return this[2];
  }
  set z(t18) {
    this[2] = t18;
  }
  get r() {
    return this[0];
  }
  set r(t18) {
    this[0] = t18;
  }
  get g() {
    return this[1];
  }
  set g(t18) {
    this[1] = t18;
  }
  get b() {
    return this[2];
  }
  set b(t18) {
    this[2] = t18;
  }
  get magnitude() {
    const t18 = this[0], e2 = this[1], n2 = this[2];
    return Math.sqrt(t18 * t18 + e2 * e2 + n2 * n2);
  }
  get mag() {
    return this.magnitude;
  }
  get squaredMagnitude() {
    const t18 = this[0], e2 = this[1], n2 = this[2];
    return t18 * t18 + e2 * e2 + n2 * n2;
  }
  get sqrMag() {
    return this.squaredMagnitude;
  }
  get str() {
    return t16.str(this);
  }
  copy(t18) {
    return this.set(t18), this;
  }
  add(t18) {
    return this[0] += t18[0], this[1] += t18[1], this[2] += t18[2], this;
  }
  subtract(t18) {
    return this[0] -= t18[0], this[1] -= t18[1], this[2] -= t18[2], this;
  }
  sub(t18) {
    return this;
  }
  multiply(t18) {
    return this[0] *= t18[0], this[1] *= t18[1], this[2] *= t18[2], this;
  }
  mul(t18) {
    return this;
  }
  divide(t18) {
    return this[0] /= t18[0], this[1] /= t18[1], this[2] /= t18[2], this;
  }
  div(t18) {
    return this;
  }
  scale(t18) {
    return this[0] *= t18, this[1] *= t18, this[2] *= t18, this;
  }
  scaleAndAdd(t18, e2) {
    return this[0] += t18[0] * e2, this[1] += t18[1] * e2, this[2] += t18[2] * e2, this;
  }
  distance(e2) {
    return t16.distance(this, e2);
  }
  dist(t18) {
    return 0;
  }
  squaredDistance(e2) {
    return t16.squaredDistance(this, e2);
  }
  sqrDist(t18) {
    return 0;
  }
  negate() {
    return this[0] *= -1, this[1] *= -1, this[2] *= -1, this;
  }
  invert() {
    return this[0] = 1 / this[0], this[1] = 1 / this[1], this[2] = 1 / this[2], this;
  }
  abs() {
    return this[0] = Math.abs(this[0]), this[1] = Math.abs(this[1]), this[2] = Math.abs(this[2]), this;
  }
  dot(t18) {
    return this[0] * t18[0] + this[1] * t18[1] + this[2] * t18[2];
  }
  normalize() {
    return t16.normalize(this, this);
  }
  static get BYTE_LENGTH() {
    return 3 * Float32Array.BYTES_PER_ELEMENT;
  }
  static create() {
    return new t16();
  }
  static clone(e2) {
    return new t16(e2);
  }
  static magnitude(t18) {
    const e2 = t18[0], n2 = t18[1], o2 = t18[2];
    return Math.sqrt(e2 * e2 + n2 * n2 + o2 * o2);
  }
  static mag(t18) {
    return 0;
  }
  static length(t18) {
    return 0;
  }
  static len(t18) {
    return 0;
  }
  static fromValues(e2, n2, o2) {
    return new t16(e2, n2, o2);
  }
  static copy(t18, e2) {
    return t18[0] = e2[0], t18[1] = e2[1], t18[2] = e2[2], t18;
  }
  static set(t18, e2, n2, o2) {
    return t18[0] = e2, t18[1] = n2, t18[2] = o2, t18;
  }
  static add(t18, e2, n2) {
    return t18[0] = e2[0] + n2[0], t18[1] = e2[1] + n2[1], t18[2] = e2[2] + n2[2], t18;
  }
  static subtract(t18, e2, n2) {
    return t18[0] = e2[0] - n2[0], t18[1] = e2[1] - n2[1], t18[2] = e2[2] - n2[2], t18;
  }
  static sub(t18, e2, n2) {
    return [0, 0, 0];
  }
  static multiply(t18, e2, n2) {
    return t18[0] = e2[0] * n2[0], t18[1] = e2[1] * n2[1], t18[2] = e2[2] * n2[2], t18;
  }
  static mul(t18, e2, n2) {
    return [0, 0, 0];
  }
  static divide(t18, e2, n2) {
    return t18[0] = e2[0] / n2[0], t18[1] = e2[1] / n2[1], t18[2] = e2[2] / n2[2], t18;
  }
  static div(t18, e2, n2) {
    return [0, 0, 0];
  }
  static ceil(t18, e2) {
    return t18[0] = Math.ceil(e2[0]), t18[1] = Math.ceil(e2[1]), t18[2] = Math.ceil(e2[2]), t18;
  }
  static floor(t18, e2) {
    return t18[0] = Math.floor(e2[0]), t18[1] = Math.floor(e2[1]), t18[2] = Math.floor(e2[2]), t18;
  }
  static min(t18, e2, n2) {
    return t18[0] = Math.min(e2[0], n2[0]), t18[1] = Math.min(e2[1], n2[1]), t18[2] = Math.min(e2[2], n2[2]), t18;
  }
  static max(t18, e2, n2) {
    return t18[0] = Math.max(e2[0], n2[0]), t18[1] = Math.max(e2[1], n2[1]), t18[2] = Math.max(e2[2], n2[2]), t18;
  }
  static scale(t18, e2, n2) {
    return t18[0] = e2[0] * n2, t18[1] = e2[1] * n2, t18[2] = e2[2] * n2, t18;
  }
  static scaleAndAdd(t18, e2, n2, o2) {
    return t18[0] = e2[0] + n2[0] * o2, t18[1] = e2[1] + n2[1] * o2, t18[2] = e2[2] + n2[2] * o2, t18;
  }
  static distance(t18, e2) {
    const n2 = e2[0] - t18[0], o2 = e2[1] - t18[1], i2 = e2[2] - t18[2];
    return Math.sqrt(n2 * n2 + o2 * o2 + i2 * i2);
  }
  static dist(t18, e2) {
    return 0;
  }
  static squaredDistance(t18, e2) {
    const n2 = e2[0] - t18[0], o2 = e2[1] - t18[1], i2 = e2[2] - t18[2];
    return n2 * n2 + o2 * o2 + i2 * i2;
  }
  static sqrDist(t18, e2) {
    return 0;
  }
  static squaredLength(t18) {
    const e2 = t18[0], n2 = t18[1], o2 = t18[2];
    return e2 * e2 + n2 * n2 + o2 * o2;
  }
  static sqrLen(t18, e2) {
    return 0;
  }
  static negate(t18, e2) {
    return t18[0] = -e2[0], t18[1] = -e2[1], t18[2] = -e2[2], t18;
  }
  static inverse(t18, e2) {
    return t18[0] = 1 / e2[0], t18[1] = 1 / e2[1], t18[2] = 1 / e2[2], t18;
  }
  static abs(t18, e2) {
    return t18[0] = Math.abs(e2[0]), t18[1] = Math.abs(e2[1]), t18[2] = Math.abs(e2[2]), t18;
  }
  static normalize(t18, e2) {
    const n2 = e2[0], o2 = e2[1], i2 = e2[2];
    let r2 = n2 * n2 + o2 * o2 + i2 * i2;
    return r2 > 0 && (r2 = 1 / Math.sqrt(r2)), t18[0] = e2[0] * r2, t18[1] = e2[1] * r2, t18[2] = e2[2] * r2, t18;
  }
  static dot(t18, e2) {
    return t18[0] * e2[0] + t18[1] * e2[1] + t18[2] * e2[2];
  }
  static cross(t18, e2, n2) {
    const o2 = e2[0], i2 = e2[1], r2 = e2[2], a2 = n2[0], s2 = n2[1], c2 = n2[2];
    return t18[0] = i2 * c2 - r2 * s2, t18[1] = r2 * a2 - o2 * c2, t18[2] = o2 * s2 - i2 * a2, t18;
  }
  static lerp(t18, e2, n2, o2) {
    const i2 = e2[0], r2 = e2[1], a2 = e2[2];
    return t18[0] = i2 + o2 * (n2[0] - i2), t18[1] = r2 + o2 * (n2[1] - r2), t18[2] = a2 + o2 * (n2[2] - a2), t18;
  }
  static slerp(e2, n2, o2, i2) {
    const r2 = Math.acos(Math.min(Math.max(t16.dot(n2, o2), -1), 1)), a2 = Math.sin(r2), s2 = Math.sin((1 - i2) * r2) / a2, c2 = Math.sin(i2 * r2) / a2;
    return e2[0] = s2 * n2[0] + c2 * o2[0], e2[1] = s2 * n2[1] + c2 * o2[1], e2[2] = s2 * n2[2] + c2 * o2[2], e2;
  }
  static hermite(t18, e2, n2, o2, i2, r2) {
    const a2 = r2 * r2, s2 = a2 * (2 * r2 - 3) + 1, c2 = a2 * (r2 - 2) + r2, l2 = a2 * (r2 - 1), u2 = a2 * (3 - 2 * r2);
    return t18[0] = e2[0] * s2 + n2[0] * c2 + o2[0] * l2 + i2[0] * u2, t18[1] = e2[1] * s2 + n2[1] * c2 + o2[1] * l2 + i2[1] * u2, t18[2] = e2[2] * s2 + n2[2] * c2 + o2[2] * l2 + i2[2] * u2, t18;
  }
  static bezier(t18, e2, n2, o2, i2, r2) {
    const a2 = 1 - r2, s2 = a2 * a2, c2 = r2 * r2, l2 = s2 * a2, u2 = 3 * r2 * s2, p2 = 3 * c2 * a2, d2 = c2 * r2;
    return t18[0] = e2[0] * l2 + n2[0] * u2 + o2[0] * p2 + i2[0] * d2, t18[1] = e2[1] * l2 + n2[1] * u2 + o2[1] * p2 + i2[1] * d2, t18[2] = e2[2] * l2 + n2[2] * u2 + o2[2] * p2 + i2[2] * d2, t18;
  }
  static transformMat4(t18, e2, n2) {
    const o2 = e2[0], i2 = e2[1], r2 = e2[2], a2 = n2[3] * o2 + n2[7] * i2 + n2[11] * r2 + n2[15] || 1;
    return t18[0] = (n2[0] * o2 + n2[4] * i2 + n2[8] * r2 + n2[12]) / a2, t18[1] = (n2[1] * o2 + n2[5] * i2 + n2[9] * r2 + n2[13]) / a2, t18[2] = (n2[2] * o2 + n2[6] * i2 + n2[10] * r2 + n2[14]) / a2, t18;
  }
  static transformMat3(t18, e2, n2) {
    const o2 = e2[0], i2 = e2[1], r2 = e2[2];
    return t18[0] = o2 * n2[0] + i2 * n2[3] + r2 * n2[6], t18[1] = o2 * n2[1] + i2 * n2[4] + r2 * n2[7], t18[2] = o2 * n2[2] + i2 * n2[5] + r2 * n2[8], t18;
  }
  static transformQuat(t18, e2, n2) {
    const o2 = n2[0], i2 = n2[1], r2 = n2[2], a2 = 2 * n2[3], s2 = e2[0], c2 = e2[1], l2 = e2[2], u2 = i2 * l2 - r2 * c2, p2 = r2 * s2 - o2 * l2, d2 = o2 * c2 - i2 * s2, m2 = 2 * (i2 * d2 - r2 * p2), f2 = 2 * (r2 * u2 - o2 * d2), h2 = 2 * (o2 * p2 - i2 * u2);
    return t18[0] = s2 + u2 * a2 + m2, t18[1] = c2 + p2 * a2 + f2, t18[2] = l2 + d2 * a2 + h2, t18;
  }
  static rotateX(t18, e2, n2, o2) {
    const i2 = n2[1], r2 = n2[2], a2 = e2[1] - i2, s2 = e2[2] - r2;
    return t18[0] = e2[0], t18[1] = a2 * Math.cos(o2) - s2 * Math.sin(o2) + i2, t18[2] = a2 * Math.sin(o2) + s2 * Math.cos(o2) + r2, t18;
  }
  static rotateY(t18, e2, n2, o2) {
    const i2 = n2[0], r2 = n2[2], a2 = e2[0] - i2, s2 = e2[2] - r2;
    return t18[0] = s2 * Math.sin(o2) + a2 * Math.cos(o2) + i2, t18[1] = e2[1], t18[2] = s2 * Math.cos(o2) - a2 * Math.sin(o2) + r2, t18;
  }
  static rotateZ(t18, e2, n2, o2) {
    const i2 = n2[0], r2 = n2[1], a2 = e2[0] - i2, s2 = e2[1] - r2;
    return t18[0] = a2 * Math.cos(o2) - s2 * Math.sin(o2) + i2, t18[1] = a2 * Math.sin(o2) + s2 * Math.cos(o2) + r2, t18[2] = n2[2], t18;
  }
  static angle(e2, n2) {
    const o2 = e2[0], i2 = e2[1], r2 = e2[2], a2 = n2[0], s2 = n2[1], c2 = n2[2], l2 = Math.sqrt((o2 * o2 + i2 * i2 + r2 * r2) * (a2 * a2 + s2 * s2 + c2 * c2)), u2 = l2 && t16.dot(e2, n2) / l2;
    return Math.acos(Math.min(Math.max(u2, -1), 1));
  }
  static zero(t18) {
    return t18[0] = 0, t18[1] = 0, t18[2] = 0, t18;
  }
  static str(t18) {
    return `Vec3(${t18.join(", ")})`;
  }
  static exactEquals(t18, e2) {
    return t18[0] === e2[0] && t18[1] === e2[1] && t18[2] === e2[2];
  }
  static equals(t18, e2) {
    const n2 = t18[0], o2 = t18[1], i2 = t18[2], r2 = e2[0], a2 = e2[1], s2 = e2[2];
    return Math.abs(n2 - r2) <= GLM_EPSILON * Math.max(1, Math.abs(n2), Math.abs(r2)) && Math.abs(o2 - a2) <= GLM_EPSILON * Math.max(1, Math.abs(o2), Math.abs(a2)) && Math.abs(i2 - s2) <= GLM_EPSILON * Math.max(1, Math.abs(i2), Math.abs(s2));
  }
}, _a;
Vec3.prototype.sub = Vec3.prototype.subtract, Vec3.prototype.mul = Vec3.prototype.multiply, Vec3.prototype.div = Vec3.prototype.divide, Vec3.prototype.dist = Vec3.prototype.distance, Vec3.prototype.sqrDist = Vec3.prototype.squaredDistance, Vec3.sub = Vec3.subtract, Vec3.mul = Vec3.multiply, Vec3.div = Vec3.divide, Vec3.dist = Vec3.distance, Vec3.sqrDist = Vec3.squaredDistance, Vec3.sqrLen = Vec3.squaredLength, Vec3.mag = Vec3.magnitude, Vec3.length = Vec3.magnitude, Vec3.len = Vec3.magnitude;
class StyleParse {
  static #y = /(\d+)\s*px/;
  static pixels(t18) {
    if ("string" != typeof t18) return;
    const e2 = this.#y.test(t18), n2 = parseInt(t18);
    return e2 && Number.isFinite(n2) ? n2 : void 0;
  }
  static remPixels(t18 = 1, { targetDocument: e2 = document } = {}) {
    return e2?.documentElement ? t18 * parseFloat(globalThis.getComputedStyle(e2.documentElement).fontSize) : void 0;
  }
}
class TJSStyleManager {
  #v;
  #w;
  #S;
  #T;
  #k;
  constructor({ docKey: t18, selector: e2 = ":root", document: n2 = globalThis.document, version: o2 } = {}) {
    if ("string" != typeof t18) throw new TypeError("StyleManager error: 'docKey' is not a string.");
    if ("[object HTMLDocument]" !== Object.prototype.toString.call(n2)) throw new TypeError("TJSStyleManager error: 'document' is not an instance of HTMLDocument.");
    if ("string" != typeof e2) throw new TypeError("StyleManager error: 'selector' is not a string.");
    if (void 0 !== o2 && !Number.isSafeInteger(o2) && o2 < 1) throw new TypeError("StyleManager error: 'version' is defined and is not a positive integer >= 1.");
    if (this.#S = e2, this.#w = t18, this.#k = o2, void 0 === n2[this.#w]) this.#T = n2.createElement("style"), n2.head.append(this.#T), this.#T._STYLE_MANAGER_VERSION = o2, this.#T.sheet.insertRule(`${e2} {}`, 0), this.#v = this.#T.sheet.cssRules[0], n2[t18] = this.#T;
    else if (this.#T = n2[t18], this.#v = this.#T.sheet.cssRules[0], o2) {
      o2 > (this.#T._STYLE_MANAGER_VERSION ?? 0) && (this.#v.style.cssText = "");
    }
  }
  get cssText() {
    return this.#v.style.cssText;
  }
  get version() {
    return this.#k;
  }
  clone(t18 = globalThis.document) {
    const e2 = new TJSStyleManager({ selector: this.#S, docKey: this.#w, document: t18, version: this.#k });
    return e2.#v.style.cssText = this.#v.style.cssText, e2;
  }
  get() {
    const t18 = this.#v.style.cssText, e2 = {};
    if ("" !== t18) {
      for (const n2 of t18.split(";")) if ("" !== n2) {
        const t19 = n2.split(":");
        e2[t19[0].trim()] = t19[1];
      }
    }
    return e2;
  }
  getProperty(t18) {
    if ("string" != typeof t18) throw new TypeError("StyleManager error: 'key' is not a string.");
    return this.#v.style.getPropertyValue(t18);
  }
  setProperties(t18, e2 = true) {
    if (!isObject(t18)) throw new TypeError("StyleManager error: 'rules' is not an object.");
    if ("boolean" != typeof e2) throw new TypeError("StyleManager error: 'overwrite' is not a boolean.");
    if (e2) for (const [e3, n2] of Object.entries(t18)) this.#v.style.setProperty(e3, n2);
    else for (const [e3, n2] of Object.entries(t18)) "" === this.#v.style.getPropertyValue(e3) && this.#v.style.setProperty(e3, n2);
  }
  setProperty(t18, e2, n2 = true) {
    if ("string" != typeof t18) throw new TypeError("StyleManager error: 'key' is not a string.");
    if ("string" != typeof e2) throw new TypeError("StyleManager error: 'value' is not a string.");
    if ("boolean" != typeof n2) throw new TypeError("StyleManager error: 'overwrite' is not a boolean.");
    (n2 || "" === this.#v.style.getPropertyValue(t18)) && this.#v.style.setProperty(t18, e2);
  }
  removeProperties(t18) {
    if (!isIterable(t18)) throw new TypeError("StyleManager error: 'keys' is not an iterable list.");
    for (const e2 of t18) "string" == typeof e2 && this.#v.style.removeProperty(e2);
  }
  removeProperty(t18) {
    if ("string" != typeof t18) throw new TypeError("StyleManager error: 'key' is not a string.");
    return this.#v.style.removeProperty(t18);
  }
}
async function nextAnimationFrame(t18 = 1) {
  if (!Number.isInteger(t18) || t18 < 1) throw new TypeError("nextAnimationFrame error: 'cntr' must be a positive integer greater than 0.");
  let e2;
  for (; --t18 >= 0; ) e2 = await new Promise((t19) => requestAnimationFrame(t19));
  return e2;
}
function draggable(t18, { position: e2, enabled: n2 = true, button: o2 = 0, storeDragging: i2, tween: r2 = false, tweenOptions: a2 = { duration: 1, ease: "cubicOut" }, hasTargetClassList: s2, ignoreTargetClassList: c2 }) {
  if (void 0 !== s2 && !isIterable(s2)) throw new TypeError("'hasTargetClassList' is not iterable.");
  if (void 0 !== c2 && !isIterable(c2)) throw new TypeError("'ignoreTargetClassList' is not iterable.");
  const l2 = { left: 0, top: 0 };
  let u2 = e2?.position ?? e2, p2 = null, d2 = { x: 0, y: 0 }, m2 = false, f2 = u2.animate.quickTo(["top", "left"], a2);
  const h2 = { dragDown: ["pointerdown", function(e3) {
    if (e3.button !== o2 || !e3.isPrimary) return;
    if (!u2.enabled) return;
    if (void 0 !== c2 && A11yHelper.isFocusTarget(e3.target)) {
      for (const t19 of c2) if (e3.target.classList.contains(t19)) return;
    }
    if (void 0 !== s2 && A11yHelper.isFocusTarget(e3.target)) {
      let t19 = false;
      for (const n3 of s2) if (e3.target.classList.contains(n3)) {
        t19 = true;
        break;
      }
      if (!t19) return;
    }
    e3.preventDefault(), m2 = false, p2 = u2.get(), d2 = { x: e3.clientX, y: e3.clientY }, t18.addEventListener(...h2.dragMove), t18.addEventListener(...h2.dragUp), t18.setPointerCapture(e3.pointerId);
  }, false], dragMove: ["pointermove", function(t19) {
    if (!(1 & t19.buttons)) return void $2(t19);
    if (-1 !== t19.button || !t19.isPrimary) return;
    t19.preventDefault(), m2 || "function" != typeof i2?.set || (m2 = true, i2.set(true));
    const e3 = p2?.left + (t19.clientX - d2.x), n3 = p2?.top + (t19.clientY - d2.y);
    r2 ? f2(n3, e3) : (l2.left = e3, l2.top = n3, u2.set(l2));
  }, false], dragUp: ["pointerup", $2, false] };
  function g2() {
    t18.addEventListener(...h2.dragDown), t18.classList.add("draggable");
  }
  function _() {
    "function" == typeof i2?.set && i2.set(false), t18.removeEventListener(...h2.dragDown), t18.removeEventListener(...h2.dragMove), t18.removeEventListener(...h2.dragUp), t18.classList.remove("draggable");
  }
  function $2(e3) {
    e3.preventDefault(), m2 = false, "function" == typeof i2?.set && i2.set(false), t18.removeEventListener(...h2.dragMove), t18.removeEventListener(...h2.dragUp);
  }
  return n2 && g2(), { update: (t19) => {
    if (void 0 !== t19.position) {
      const e3 = t19.position?.position ?? t19.position;
      e3 !== u2 && (u2 = e3, f2 = u2.animate.quickTo(["top", "left"], a2));
    }
    if ("boolean" == typeof t19.enabled && ((n2 = t19.enabled) ? g2() : _()), "number" == typeof t19.button && (o2 = t19.button), "boolean" == typeof t19.tween && (r2 = t19.tween), isObject(t19.tweenOptions) && (a2 = t19.tweenOptions, f2.options(a2)), void 0 !== t19.hasTargetClassList) {
      if (!isIterable(t19.hasTargetClassList)) throw new TypeError("'hasTargetClassList' is not iterable.");
      s2 = t19.hasTargetClassList;
    }
    if (void 0 !== t19.ignoreTargetClassList) {
      if (!isIterable(t19.ignoreTargetClassList)) throw new TypeError("'ignoreTargetClassList' is not iterable.");
      c2 = t19.ignoreTargetClassList;
    }
  }, destroy: () => _() };
}
class DraggableOptionsStore {
  tween;
  tweenOptions;
  #x;
  #E;
  #O = false;
  #A = { duration: 1, ease: "cubicOut" };
  #C = [];
  constructor({ tween: t18 = false, tweenOptions: e2 } = {}) {
    Object.defineProperty(this, "tween", { get: () => this.#O, set: (t19) => {
      if ("boolean" != typeof t19) throw new TypeError("'tween' is not a boolean.");
      this.#O = t19, this.#M();
    }, enumerable: true }), Object.defineProperty(this, "tweenOptions", { get: () => this.#A, set: (t19) => {
      if (!isObject(t19)) throw new TypeError("'tweenOptions' is not an object.");
      if (void 0 !== t19.duration) {
        if (!Number.isFinite(t19.duration)) throw new TypeError("'tweenOptions.duration' is not a finite number.");
        t19.duration < 0 ? this.#A.duration = 0 : this.#A.duration = t19.duration;
      }
      if (void 0 !== t19.ease) {
        if ("function" != typeof getEasingFunc(t19.ease)) throw new TypeError("'tweenOptions.ease' is not a function or Svelte easing function name.");
        this.#A.ease = t19.ease;
      }
      this.#M();
    }, enumerable: true }), void 0 !== t18 && (this.tween = t18), void 0 !== e2 && (this.tweenOptions = e2), this.#x = this.#O, this.#E = Object.assign({}, this.#A);
  }
  get tweenDuration() {
    return this.#A.duration;
  }
  get tweenEase() {
    return this.#A.ease;
  }
  set tweenDuration(t18) {
    if (!Number.isFinite(t18)) throw new TypeError("'duration' is not a finite number.");
    t18 < 0 && (t18 = 0), this.#A.duration = t18, this.#M();
  }
  set tweenEase(t18) {
    if ("function" != typeof getEasingFunc(t18)) throw new TypeError("'ease' is not a function or Svelte easing function name.");
    this.#A.ease = t18, this.#M();
  }
  reset() {
    this.#O = this.#x, this.#A = Object.assign({}, this.#E), this.#M();
  }
  resetTween() {
    this.#O = this.#x, this.#M();
  }
  resetTweenOptions() {
    this.#A = Object.assign({}, this.#E), this.#M();
  }
  subscribe(t18) {
    return -1 === this.#C.findIndex((e2) => e2 === t18) && (this.#C.push(t18), t18(this)), () => {
      const e2 = this.#C.findIndex((e3) => e3 === t18);
      -1 !== e2 && this.#C.splice(e2, 1);
    };
  }
  #M() {
    const t18 = this.#C;
    if (t18.length > 0) for (let e2 = 0; e2 < t18.length; e2++) t18[e2](this);
  }
}
draggable.options = (t18) => new DraggableOptionsStore(t18);
class AnimationControl {
  #I;
  #N;
  #P;
  static #D = new AnimationControl(null);
  static get voidControl() {
    return this.#D;
  }
  constructor(t18, e2 = false) {
    this.#I = t18, this.#P = e2, isObject(t18) && (t18.control = this);
  }
  get finished() {
    return CrossWindow.isPromise(this.#N) || (this.#N = this.#P ? new Promise((t18) => this.#I.resolve = t18) : Promise.resolve({ cancelled: false })), this.#N;
  }
  get isActive() {
    return this.#I?.active ?? false;
  }
  get isFinished() {
    return this.#I?.finished ?? true;
  }
  cancel() {
    const t18 = this.#I;
    null != t18 && (t18.cancelled = true);
  }
}
class AnimationManager {
  static cancelFn = (t18) => true !== t18?.quickTo;
  static cancelAllFn = () => true;
  static #j = Object.freeze({ immediateElementUpdate: true });
  static #F = [];
  static #L = (t18) => this.animate(t18);
  static #R = [];
  static #z = false;
  static #H;
  static #W;
  static get timeFrame() {
    return this.#H;
  }
  static get timeNow() {
    return this.#W;
  }
  static add(t18) {
    t18.cancelled ? this.#U(t18) : (AnimationManager.#R.push(t18), AnimationManager.#z || (AnimationManager.#z = true, globalThis.requestAnimationFrame(this.#L)));
  }
  static animate(t18) {
    if (AnimationManager.#z = false, AnimationManager.#W = globalThis.performance.now(), AnimationManager.#H = t18, 0 !== AnimationManager.#F.length || 0 !== AnimationManager.#R.length) {
      if (AnimationManager.#R.length) for (let t19 = AnimationManager.#R.length; --t19 >= 0; ) {
        const e2 = AnimationManager.#R[t19];
        (e2.cancelled || void 0 !== e2.el && !e2.el.isConnected) && (AnimationManager.#R.splice(t19, 1), this.#U(e2)), e2.active && (e2.transformOrigin && e2.position.set({ transformOrigin: e2.transformOrigin }), e2.start = AnimationManager.#H, AnimationManager.#R.splice(t19, 1), AnimationManager.#F.push(e2));
      }
      for (let e2 = AnimationManager.#F.length; --e2 >= 0; ) {
        const n2 = AnimationManager.#F[e2];
        if (n2.cancelled || void 0 !== n2.el && !n2.el.isConnected) {
          AnimationManager.#F.splice(e2, 1), this.#U(n2);
          continue;
        }
        if (n2.current = t18 - n2.start, n2.current >= n2.duration) {
          for (let t19 = n2.keys.length; --t19 >= 0; ) {
            const e3 = n2.keys[t19];
            n2.newData[e3] = n2.destination[e3];
          }
          n2.position.set(n2.newData, AnimationManager.#j), AnimationManager.#F.splice(e2, 1), this.#U(n2);
          continue;
        }
        const o2 = n2.ease(n2.current / n2.duration);
        for (let t19 = n2.keys.length; --t19 >= 0; ) {
          const e3 = n2.keys[t19];
          n2.newData[e3] = n2.interpolate(n2.initial[e3], n2.destination[e3], o2);
        }
        n2.position.set(n2.newData, AnimationManager.#j);
      }
      globalThis.requestAnimationFrame(this.#L);
    }
  }
  static cancel(t18, e2 = AnimationManager.cancelFn) {
    for (let n2 = AnimationManager.#F.length; --n2 >= 0; ) {
      const o2 = AnimationManager.#F[n2];
      o2.position === t18 && e2(o2) && (AnimationManager.#F.splice(n2, 1), o2.cancelled = true, this.#U(o2));
    }
    for (let n2 = AnimationManager.#R.length; --n2 >= 0; ) {
      const o2 = AnimationManager.#R[n2];
      o2.position === t18 && e2(o2) && (AnimationManager.#R.splice(n2, 1), o2.cancelled = true, this.#U(o2));
    }
  }
  static cancelAll() {
    for (let t18 = AnimationManager.#F.length; --t18 >= 0; ) {
      const e2 = AnimationManager.#F[t18];
      e2.cancelled = true, this.#U(e2);
    }
    for (let t18 = AnimationManager.#R.length; --t18 >= 0; ) {
      const e2 = AnimationManager.#R[t18];
      e2.cancelled = true, this.#U(e2);
    }
    AnimationManager.#F.length = 0, AnimationManager.#R.length = 0;
  }
  static #U(t18) {
    t18.active = false, t18.finished = true, t18.transformOriginInitial && t18.position.set({ transformOrigin: t18.transformOriginInitial }), "function" == typeof t18.cleanup && t18.cleanup(t18), "function" == typeof t18.resolve && t18.resolve({ cancelled: t18.cancelled }), t18.quickTo || (t18.cleanup = void 0, t18.control = void 0, t18.destination = void 0, t18.el = void 0, t18.ease = void 0, t18.initial = void 0, t18.interpolate = void 0, t18.keys = void 0, t18.newData = void 0, t18.position = void 0, t18.resolve = void 0);
  }
  static getScheduled(t18) {
    const e2 = [];
    for (let n2 = AnimationManager.#F.length; --n2 >= 0; ) {
      const o2 = AnimationManager.#F[n2];
      o2.position === t18 && o2.control && e2.push(o2.control);
    }
    for (let n2 = AnimationManager.#R.length; --n2 >= 0; ) {
      const o2 = AnimationManager.#R[n2];
      o2.position === t18 && o2.control && e2.push(o2.control);
    }
    return e2;
  }
  static isScheduled(t18, { active: e2 = true, pending: n2 = true } = {}) {
    if (e2) {
      for (let e3 = AnimationManager.#F.length; --e3 >= 0; ) if (AnimationManager.#F[e3].position === t18) return true;
    }
    if (n2) {
      for (let e3 = AnimationManager.#R.length; --e3 >= 0; ) if (AnimationManager.#R[e3].position === t18) return true;
    }
    return false;
  }
}
class TJSPositionData {
  height;
  left;
  maxHeight;
  maxWidth;
  minHeight;
  minWidth;
  rotateX;
  rotateY;
  rotateZ;
  scale;
  top;
  transformOrigin;
  translateX;
  translateY;
  translateZ;
  width;
  zIndex;
  constructor({ height: t18 = null, left: e2 = null, maxHeight: n2 = null, maxWidth: o2 = null, minHeight: i2 = null, minWidth: r2 = null, rotateX: a2 = null, rotateY: s2 = null, rotateZ: c2 = null, scale: l2 = null, translateX: u2 = null, translateY: p2 = null, translateZ: d2 = null, top: m2 = null, transformOrigin: f2 = null, width: h2 = null, zIndex: g2 = null } = {}) {
    this.height = t18, this.left = e2, this.maxHeight = n2, this.maxWidth = o2, this.minHeight = i2, this.minWidth = r2, this.rotateX = a2, this.rotateY = s2, this.rotateZ = c2, this.scale = l2, this.top = m2, this.transformOrigin = f2, this.translateX = u2, this.translateY = p2, this.translateZ = d2, this.width = h2, this.zIndex = g2;
  }
}
class TJSPositionDataUtil {
  static #q = Object.freeze(/* @__PURE__ */ new Set(["left", "top", "maxWidth", "maxHeight", "minWidth", "minHeight", "width", "height", "rotateX", "rotateY", "rotateZ", "scale", "translateX", "translateY", "translateZ", "zIndex", "rotation"]));
  static #G = Object.freeze(/* @__PURE__ */ new Map([["rotation", "rotateZ"]]));
  static #B = Object.freeze({ height: 0, left: 0, maxHeight: null, maxWidth: null, minHeight: null, minWidth: null, top: 0, transformOrigin: null, width: 0, zIndex: null, rotateX: 0, rotateY: 0, rotateZ: 0, scale: 1, translateX: 0, translateY: 0, translateZ: 0 });
  static copyData(t18, e2 = new TJSPositionData()) {
    return e2.height = t18.height ?? null, e2.left = t18.left ?? null, e2.maxHeight = t18.maxHeight ?? null, e2.maxWidth = t18.maxWidth ?? null, e2.minHeight = t18.minHeight ?? null, e2.minWidth = t18.minWidth ?? null, e2.rotateX = t18.rotateX ?? null, e2.rotateY = t18.rotateY ?? null, e2.rotateZ = t18.rotateZ ?? null, e2.scale = t18.scale ?? null, e2.top = t18.top ?? null, e2.transformOrigin = t18.transformOrigin ?? null, e2.translateX = t18.translateX ?? null, e2.translateY = t18.translateY ?? null, e2.translateZ = t18.translateZ ?? null, e2.width = t18.width ?? null, e2.zIndex = t18.zIndex ?? null, e2;
  }
  static getAnimationKey(t18) {
    return this.#G.get(t18) ?? t18;
  }
  static getDataOrDefault(t18, e2) {
    return t18[e2 = this.#G.get(e2) ?? e2] ?? this.#B[e2];
  }
  static isAnimationKey(t18) {
    return this.#q.has(t18);
  }
  static setNumericDefaults(t18) {
    null === t18.rotateX && (t18.rotateX = 0), null === t18.rotateY && (t18.rotateY = 0), null === t18.rotateZ && (t18.rotateZ = 0), null === t18.translateX && (t18.translateX = 0), null === t18.translateY && (t18.translateY = 0), null === t18.translateZ && (t18.translateZ = 0), null === t18.scale && (t18.scale = 1);
  }
}
class ConvertStringData {
  static #J = { numPx: Object.freeze(/* @__PURE__ */ new Set(["left", "top", "maxWidth", "maxHeight", "minWidth", "minHeight", "width", "height", "translateX", "translateY", "translateZ"])), percentParent: Object.freeze(/* @__PURE__ */ new Set(["left", "top", "maxWidth", "maxHeight", "minWidth", "minHeight", "width", "height"])), rotationRadTurn: Object.freeze(/* @__PURE__ */ new Set(["rotateX", "rotateY", "rotateZ", "rotation"])) };
  static #Y = /^(?<operation>[-+*]=)?(?<value>-?\d*\.?\d+)(?<unit>%|%~|px|rad|turn)?$/;
  static #X = Object.seal({ operation: void 0, value: 0, unit: void 0 });
  static process(t18, e2, n2) {
    let o2 = Number.NaN, i2 = Number.NaN;
    for (const r2 in t18) if (TJSPositionDataUtil.isAnimationKey(r2)) {
      const a2 = t18[r2];
      if ("string" != typeof a2) continue;
      if ("auto" === a2 || "inherit" === a2) continue;
      const s2 = r2, c2 = this.#Y.exec(a2);
      let l2 = false;
      if (c2 && c2.groups) {
        const u2 = this.#X;
        u2.operation = c2.groups.operation, u2.value = parseFloat(c2.groups.value), u2.unit = c2.groups.unit;
        const p2 = TJSPositionDataUtil.getDataOrDefault(e2, r2);
        switch (u2.unit) {
          case "%":
            if (this.#J.percentParent.has(r2) && (Number.isNaN(o2) || Number.isNaN(i2))) {
              if (!n2?.parentElement?.isConnected) {
                o2 = 0, i2 = 0, console.warn(`TJSPosition - ConvertStringData warning: could not determine parent constraints for key '${r2}' with value '${a2}'.`), t18[r2] = void 0;
                continue;
              }
              o2 = n2.parentElement.clientHeight, i2 = n2.parentElement.clientWidth;
            }
            l2 = this.#V(s2, p2, t18, u2, o2, i2);
            break;
          case "%~":
            l2 = this.#K(s2, p2, t18, u2);
            break;
          case "px":
            l2 = !!this.#J.numPx.has(r2) && this.#Z(s2, p2, t18, u2);
            break;
          case "rad":
          case "turn":
            l2 = !!this.#J.rotationRadTurn.has(r2) && this.#Q(s2, p2, t18, u2);
            break;
          default:
            l2 = this.#Z(s2, p2, t18, u2);
        }
      }
      c2 && l2 || (console.warn(`TJSPosition - ConvertStringData warning: malformed key '${r2}' with value '${a2}'.`), t18[r2] = void 0);
    }
    return t18;
  }
  static #Z(t18, e2, n2, o2) {
    if (!o2.operation) return n2[t18] = o2.value, true;
    switch (o2.operation) {
      case "-=":
        n2[t18] = e2 - o2.value;
        break;
      case "+=":
        n2[t18] = e2 + o2.value;
        break;
      case "*=":
        n2[t18] = e2 * o2.value;
        break;
      default:
        return false;
    }
    return true;
  }
  static #V(t18, e2, n2, o2, i2, r2) {
    switch (t18) {
      case "left":
      case "maxWidth":
      case "minWidth":
      case "width":
      case "translateX":
        o2.value = r2 * (o2.value / 100);
        break;
      case "top":
      case "maxHeight":
      case "minHeight":
      case "height":
      case "translateY":
        o2.value = i2 * (o2.value / 100);
        break;
      case "rotateX":
      case "rotateY":
      case "rotateZ":
      case "rotation":
        o2.value = o2.value / 100 * 360;
        break;
      default:
        return false;
    }
    return this.#Z(t18, e2, n2, o2);
  }
  static #K(t18, e2, n2, o2) {
    if (o2.value = o2.value / 100, !o2.operation) return n2[t18] = e2 * o2.value, true;
    switch (o2.operation) {
      case "-=":
        n2[t18] = e2 - e2 * o2.value;
        break;
      case "+=":
        n2[t18] = e2 + e2 * o2.value;
        break;
      case "*=":
        n2[t18] = e2 * (e2 * o2.value);
        break;
      default:
        return false;
    }
    return true;
  }
  static #Q(t18, e2, n2, o2) {
    switch (o2.unit) {
      case "rad":
        o2.value = radToDeg(o2.value);
        break;
      case "turn":
        o2.value = 360 * o2.value;
    }
    return this.#Z(t18, e2, n2, o2);
  }
}
class TJSTransformData {
  constructor() {
    Object.seal(this);
  }
  #tt = new DOMRect();
  #et = [new Vec3(), new Vec3(), new Vec3(), new Vec3()];
  #nt = new Mat4();
  #ot = [new Mat4(), new Mat4()];
  get boundingRect() {
    return this.#tt;
  }
  get corners() {
    return this.#et;
  }
  get css() {
    return `matrix3d(${this.mat4.join(",")})`;
  }
  get mat4() {
    return this.#nt;
  }
  get originTranslations() {
    return this.#ot;
  }
}
class NumberGuard {
  constructor() {
  }
  static isFinite(t18) {
    return "number" == typeof t18 && Number.isFinite(t18);
  }
  static isFiniteOrNull(t18) {
    return null === t18 || "number" == typeof t18 && Number.isFinite(t18);
  }
}
class TJSPositionStyleCache {
  el;
  computed;
  marginLeft;
  marginTop;
  maxHeight;
  maxWidth;
  minHeight;
  minWidth;
  hasWillChange;
  stores;
  resizeObserved;
  constructor() {
    this.el = void 0, this.computed = void 0, this.marginLeft = void 0, this.marginTop = void 0, this.maxHeight = void 0, this.maxWidth = void 0, this.minHeight = void 0, this.minWidth = void 0, this.hasWillChange = false, this.resizeObserved = Object.seal({ contentHeight: void 0, contentWidth: void 0, offsetHeight: void 0, offsetWidth: void 0 });
    const t18 = writable(this.resizeObserved);
    this.stores = { element: writable(this.el), resizeContentHeight: propertyStore(t18, "contentHeight"), resizeContentWidth: propertyStore(t18, "contentWidth"), resizeObserved: t18, resizeObservable: writable(false), resizeOffsetHeight: propertyStore(t18, "offsetHeight"), resizeOffsetWidth: propertyStore(t18, "offsetWidth") };
  }
  get offsetHeight() {
    if (void 0 !== this.el && A11yHelper.isFocusTarget(this.el)) return void 0 !== this.resizeObserved.offsetHeight ? this.resizeObserved.offsetHeight : this.el.offsetHeight;
    throw new Error("TJSPositionStyleCache - get offsetHeight error: no element assigned.");
  }
  get offsetWidth() {
    if (void 0 !== this.el && A11yHelper.isFocusTarget(this.el)) return void 0 !== this.resizeObserved.offsetWidth ? this.resizeObserved.offsetWidth : this.el.offsetWidth;
    throw new Error("TJSPositionStyleCache - get offsetWidth error: no element assigned.");
  }
  hasData(t18) {
    return this.el === t18;
  }
  reset() {
    void 0 !== this.el && A11yHelper.isFocusTarget(this.el) && this.el.isConnected && !this.hasWillChange && (this.el.style.willChange = ""), this.el = void 0, this.computed = void 0, this.marginLeft = void 0, this.marginTop = void 0, this.maxHeight = void 0, this.maxWidth = void 0, this.minHeight = void 0, this.minWidth = void 0, this.hasWillChange = false, this.resizeObserved.contentHeight = void 0, this.resizeObserved.contentWidth = void 0, this.resizeObserved.offsetHeight = void 0, this.resizeObserved.offsetWidth = void 0, this.stores.element.set(void 0);
  }
  update(t18) {
    this.el = t18, this.computed = globalThis.getComputedStyle(t18), this.marginLeft = StyleParse.pixels(t18.style.marginLeft) ?? StyleParse.pixels(this.computed.marginLeft), this.marginTop = StyleParse.pixels(t18.style.marginTop) ?? StyleParse.pixels(this.computed.marginTop), this.maxHeight = StyleParse.pixels(t18.style.maxHeight) ?? StyleParse.pixels(this.computed.maxHeight), this.maxWidth = StyleParse.pixels(t18.style.maxWidth) ?? StyleParse.pixels(this.computed.maxWidth), this.minHeight = StyleParse.pixels(t18.style.minHeight) ?? StyleParse.pixels(this.computed.minHeight), this.minWidth = StyleParse.pixels(t18.style.minWidth) ?? StyleParse.pixels(this.computed.minWidth);
    const e2 = "" !== t18.style.willChange ? t18.style.willChange : this.computed.willChange ?? "";
    this.hasWillChange = "" !== e2 && "auto" !== e2, this.stores.element.set(t18);
  }
}
class TJSTransforms {
  #it = {};
  #rt = [];
  static #at = Object.freeze(["rotateX", "rotateY", "rotateZ", "scale", "translateX", "translateY", "translateZ"]);
  static #st(t18) {
    return this.#at.includes(t18);
  }
  static #ct = Object.freeze({ rotateX: 1, rotateY: 2, rotateZ: 4, scale: 8, translateX: 16, translateY: 32, translateZ: 64 });
  static #lt = "top left";
  static #ut = Object.freeze(["top left", "top center", "top right", "center left", "center", "center right", "bottom left", "bottom center", "bottom right"]);
  static #pt = Object.freeze(new Set(this.#ut));
  static #dt = new Mat4();
  static #mt = new Mat4();
  static #ft = new Vec3();
  static #ht = [1, 1, 1];
  static #gt = [0, 0, 0];
  static get transformOrigins() {
    return this.#ut;
  }
  static isTransformOrigin(t18) {
    return this.#pt.has(t18);
  }
  get isActive() {
    return this.#rt.length > 0;
  }
  get rotateX() {
    return this.#it.rotateX;
  }
  get rotateY() {
    return this.#it.rotateY;
  }
  get rotateZ() {
    return this.#it.rotateZ;
  }
  get scale() {
    return this.#it.scale;
  }
  get translateX() {
    return this.#it.translateX;
  }
  get translateY() {
    return this.#it.translateY;
  }
  get translateZ() {
    return this.#it.translateZ;
  }
  set rotateX(t18) {
    if (Number.isFinite(t18)) void 0 === this.#it.rotateX && this.#rt.push("rotateX"), this.#it.rotateX = t18;
    else {
      if (void 0 !== this.#it.rotateX) {
        const t19 = this.#rt.findIndex((t20) => "rotateX" === t20);
        t19 >= 0 && this.#rt.splice(t19, 1);
      }
      delete this.#it.rotateX;
    }
  }
  set rotateY(t18) {
    if (Number.isFinite(t18)) void 0 === this.#it.rotateY && this.#rt.push("rotateY"), this.#it.rotateY = t18;
    else {
      if (void 0 !== this.#it.rotateY) {
        const t19 = this.#rt.findIndex((t20) => "rotateY" === t20);
        t19 >= 0 && this.#rt.splice(t19, 1);
      }
      delete this.#it.rotateY;
    }
  }
  set rotateZ(t18) {
    if (Number.isFinite(t18)) void 0 === this.#it.rotateZ && this.#rt.push("rotateZ"), this.#it.rotateZ = t18;
    else {
      if (void 0 !== this.#it.rotateZ) {
        const t19 = this.#rt.findIndex((t20) => "rotateZ" === t20);
        t19 >= 0 && this.#rt.splice(t19, 1);
      }
      delete this.#it.rotateZ;
    }
  }
  set scale(t18) {
    if (Number.isFinite(t18)) void 0 === this.#it.scale && this.#rt.push("scale"), this.#it.scale = t18;
    else {
      if (void 0 !== this.#it.scale) {
        const t19 = this.#rt.findIndex((t20) => "scale" === t20);
        t19 >= 0 && this.#rt.splice(t19, 1);
      }
      delete this.#it.scale;
    }
  }
  set translateX(t18) {
    if (Number.isFinite(t18)) void 0 === this.#it.translateX && this.#rt.push("translateX"), this.#it.translateX = t18;
    else {
      if (void 0 !== this.#it.translateX) {
        const t19 = this.#rt.findIndex((t20) => "translateX" === t20);
        t19 >= 0 && this.#rt.splice(t19, 1);
      }
      delete this.#it.translateX;
    }
  }
  set translateY(t18) {
    if (Number.isFinite(t18)) void 0 === this.#it.translateY && this.#rt.push("translateY"), this.#it.translateY = t18;
    else {
      if (void 0 !== this.#it.translateY) {
        const t19 = this.#rt.findIndex((t20) => "translateY" === t20);
        t19 >= 0 && this.#rt.splice(t19, 1);
      }
      delete this.#it.translateY;
    }
  }
  set translateZ(t18) {
    if (Number.isFinite(t18)) void 0 === this.#it.translateZ && this.#rt.push("translateZ"), this.#it.translateZ = t18;
    else {
      if (void 0 !== this.#it.translateZ) {
        const t19 = this.#rt.findIndex((t20) => "translateZ" === t20);
        t19 >= 0 && this.#rt.splice(t19, 1);
      }
      delete this.#it.translateZ;
    }
  }
  getCSS(t18 = this.#it) {
    return `matrix3d(${this.getMat4(t18, TJSTransforms.#dt).join(",")})`;
  }
  getCSSOrtho(t18 = this.#it) {
    return `matrix3d(${this.getMat4Ortho(t18, TJSTransforms.#dt).join(",")})`;
  }
  getData(t18, e2 = new TJSTransformData(), n2) {
    const o2 = n2?.width ?? 0, i2 = n2?.height ?? 0, r2 = n2?.offsetTop ?? n2?.marginTop ?? 0, a2 = n2?.offsetLeft ?? n2?.marginLeft ?? 0;
    t18.top += r2, t18.left += a2;
    const s2 = NumberGuard.isFinite(t18.width) ? t18.width : o2, c2 = NumberGuard.isFinite(t18.height) ? t18.height : i2, l2 = e2.corners;
    if (this.hasTransform(t18)) {
      l2[0][0] = l2[0][1] = l2[0][2] = 0, l2[1][0] = s2, l2[1][1] = l2[1][2] = 0, l2[2][0] = s2, l2[2][1] = c2, l2[2][2] = 0, l2[3][0] = 0, l2[3][1] = c2, l2[3][2] = 0;
      const n3 = this.getMat4(t18, e2.mat4), o3 = TJSTransforms.#_t(t18.transformOrigin, s2, c2, e2.originTranslations);
      TJSTransforms.#lt === t18.transformOrigin ? (Vec3.transformMat4(l2[0], l2[0], n3), Vec3.transformMat4(l2[1], l2[1], n3), Vec3.transformMat4(l2[2], l2[2], n3), Vec3.transformMat4(l2[3], l2[3], n3)) : (Vec3.transformMat4(l2[0], l2[0], o3[0]), Vec3.transformMat4(l2[0], l2[0], n3), Vec3.transformMat4(l2[0], l2[0], o3[1]), Vec3.transformMat4(l2[1], l2[1], o3[0]), Vec3.transformMat4(l2[1], l2[1], n3), Vec3.transformMat4(l2[1], l2[1], o3[1]), Vec3.transformMat4(l2[2], l2[2], o3[0]), Vec3.transformMat4(l2[2], l2[2], n3), Vec3.transformMat4(l2[2], l2[2], o3[1]), Vec3.transformMat4(l2[3], l2[3], o3[0]), Vec3.transformMat4(l2[3], l2[3], n3), Vec3.transformMat4(l2[3], l2[3], o3[1])), l2[0][0] = t18.left + l2[0][0], l2[0][1] = t18.top + l2[0][1], l2[1][0] = t18.left + l2[1][0], l2[1][1] = t18.top + l2[1][1], l2[2][0] = t18.left + l2[2][0], l2[2][1] = t18.top + l2[2][1], l2[3][0] = t18.left + l2[3][0], l2[3][1] = t18.top + l2[3][1];
    } else l2[0][0] = t18.left, l2[0][1] = t18.top, l2[1][0] = t18.left + s2, l2[1][1] = t18.top, l2[2][0] = t18.left + s2, l2[2][1] = t18.top + c2, l2[3][0] = t18.left, l2[3][1] = t18.top + c2, Mat4.identity(e2.mat4);
    let u2 = Number.MIN_SAFE_INTEGER, p2 = Number.MIN_SAFE_INTEGER, d2 = Number.MAX_SAFE_INTEGER, m2 = Number.MAX_SAFE_INTEGER;
    for (let t19 = 4; --t19 >= 0; ) l2[t19][0] > u2 && (u2 = l2[t19][0]), l2[t19][0] < d2 && (d2 = l2[t19][0]), l2[t19][1] > p2 && (p2 = l2[t19][1]), l2[t19][1] < m2 && (m2 = l2[t19][1]);
    const f2 = e2.boundingRect;
    return f2.x = d2, f2.y = m2, f2.width = u2 - d2, f2.height = p2 - m2, t18.top -= r2, t18.left -= a2, e2;
  }
  getMat4(t18 = this.#it, e2 = new Mat4()) {
    const n2 = Mat4.identity(e2);
    let o2 = 0;
    const i2 = this.#rt;
    for (let e3 = 0; e3 < i2.length; e3++) {
      const r2 = i2[e3];
      switch (r2) {
        case "rotateX":
          o2 |= TJSTransforms.#ct.rotateX, Mat4.multiply(n2, n2, Mat4.fromXRotation(TJSTransforms.#mt, degToRad(t18[r2] ?? 0)));
          break;
        case "rotateY":
          o2 |= TJSTransforms.#ct.rotateY, Mat4.multiply(n2, n2, Mat4.fromYRotation(TJSTransforms.#mt, degToRad(t18[r2] ?? 0)));
          break;
        case "rotateZ":
          o2 |= TJSTransforms.#ct.rotateZ, Mat4.multiply(n2, n2, Mat4.fromZRotation(TJSTransforms.#mt, degToRad(t18[r2] ?? 0)));
          break;
        case "scale":
          o2 |= TJSTransforms.#ct.scale, TJSTransforms.#ht[0] = TJSTransforms.#ht[1] = t18[r2] ?? 0, Mat4.multiply(n2, n2, Mat4.fromScaling(TJSTransforms.#mt, TJSTransforms.#ht));
          break;
        case "translateX":
          o2 |= TJSTransforms.#ct.translateX, TJSTransforms.#gt[0] = t18.translateX ?? 0, TJSTransforms.#gt[1] = 0, TJSTransforms.#gt[2] = 0, Mat4.multiply(n2, n2, Mat4.fromTranslation(TJSTransforms.#mt, TJSTransforms.#gt));
          break;
        case "translateY":
          o2 |= TJSTransforms.#ct.translateY, TJSTransforms.#gt[0] = 0, TJSTransforms.#gt[1] = t18.translateY ?? 0, TJSTransforms.#gt[2] = 0, Mat4.multiply(n2, n2, Mat4.fromTranslation(TJSTransforms.#mt, TJSTransforms.#gt));
          break;
        case "translateZ":
          o2 |= TJSTransforms.#ct.translateZ, TJSTransforms.#gt[0] = 0, TJSTransforms.#gt[1] = 0, TJSTransforms.#gt[2] = t18.translateZ ?? 0, Mat4.multiply(n2, n2, Mat4.fromTranslation(TJSTransforms.#mt, TJSTransforms.#gt));
      }
    }
    if (t18 !== this.#it) for (let e3 = 0; e3 < TJSTransforms.#at.length; e3++) {
      const i3 = TJSTransforms.#at[e3];
      if (null === t18[i3] || (o2 & TJSTransforms.#ct[i3]) > 0) continue;
      const r2 = t18[i3];
      switch (i3) {
        case "rotateX":
          Mat4.multiply(n2, n2, Mat4.fromXRotation(TJSTransforms.#mt, degToRad(r2)));
          break;
        case "rotateY":
          Mat4.multiply(n2, n2, Mat4.fromYRotation(TJSTransforms.#mt, degToRad(r2)));
          break;
        case "rotateZ":
          Mat4.multiply(n2, n2, Mat4.fromZRotation(TJSTransforms.#mt, degToRad(r2)));
          break;
        case "scale":
          TJSTransforms.#ht[0] = TJSTransforms.#ht[1] = r2, Mat4.multiply(n2, n2, Mat4.fromScaling(TJSTransforms.#mt, TJSTransforms.#ht));
          break;
        case "translateX":
          TJSTransforms.#gt[0] = r2, TJSTransforms.#gt[1] = 0, TJSTransforms.#gt[2] = 0, Mat4.multiply(n2, n2, Mat4.fromTranslation(TJSTransforms.#mt, TJSTransforms.#gt));
          break;
        case "translateY":
          TJSTransforms.#gt[0] = 0, TJSTransforms.#gt[1] = r2, TJSTransforms.#gt[2] = 0, Mat4.multiply(n2, n2, Mat4.fromTranslation(TJSTransforms.#mt, TJSTransforms.#gt));
          break;
        case "translateZ":
          TJSTransforms.#gt[0] = 0, TJSTransforms.#gt[1] = 0, TJSTransforms.#gt[2] = r2, Mat4.multiply(n2, n2, Mat4.fromTranslation(TJSTransforms.#mt, TJSTransforms.#gt));
      }
    }
    return n2;
  }
  getMat4Ortho(t18 = this.#it, e2 = new Mat4()) {
    const n2 = Mat4.identity(e2);
    if (TJSTransforms.#gt[0] = (t18.left ?? 0) + (t18.translateX ?? 0), TJSTransforms.#gt[1] = (t18.top ?? 0) + (t18.translateY ?? 0), TJSTransforms.#gt[2] = t18.translateZ ?? 0, Mat4.multiply(n2, n2, Mat4.fromTranslation(TJSTransforms.#mt, TJSTransforms.#gt)), null !== t18.scale && void 0 !== t18.scale && (TJSTransforms.#ht[0] = TJSTransforms.#ht[1] = t18.scale, Mat4.multiply(n2, n2, Mat4.fromScaling(TJSTransforms.#mt, TJSTransforms.#ht))), null === t18.rotateX && null === t18.rotateY && null === t18.rotateZ) return n2;
    let o2 = 0;
    const i2 = this.#rt;
    for (let e3 = 0; e3 < i2.length; e3++) {
      const r2 = i2[e3];
      switch (r2) {
        case "rotateX":
          o2 |= TJSTransforms.#ct.rotateX, Mat4.multiply(n2, n2, Mat4.fromXRotation(TJSTransforms.#mt, degToRad(t18[r2] ?? 0)));
          break;
        case "rotateY":
          o2 |= TJSTransforms.#ct.rotateY, Mat4.multiply(n2, n2, Mat4.fromYRotation(TJSTransforms.#mt, degToRad(t18[r2] ?? 0)));
          break;
        case "rotateZ":
          o2 |= TJSTransforms.#ct.rotateZ, Mat4.multiply(n2, n2, Mat4.fromZRotation(TJSTransforms.#mt, degToRad(t18[r2] ?? 0)));
      }
    }
    if (t18 !== this.#it) for (let e3 = 0; e3 < TJSTransforms.#at.length; e3++) {
      const i3 = TJSTransforms.#at[e3];
      if (!(null === t18[i3] || (o2 & TJSTransforms.#ct[i3]) > 0)) switch (i3) {
        case "rotateX":
          Mat4.multiply(n2, n2, Mat4.fromXRotation(TJSTransforms.#mt, degToRad(t18[i3] ?? 0)));
          break;
        case "rotateY":
          Mat4.multiply(n2, n2, Mat4.fromYRotation(TJSTransforms.#mt, degToRad(t18[i3] ?? 0)));
          break;
        case "rotateZ":
          Mat4.multiply(n2, n2, Mat4.fromZRotation(TJSTransforms.#mt, degToRad(t18[i3] ?? 0)));
      }
    }
    return n2;
  }
  hasTransform(t18) {
    for (const e2 of TJSTransforms.#at) if (Number.isFinite(t18[e2])) return true;
    return false;
  }
  reset(t18) {
    for (const e2 in t18) if (TJSTransforms.#st(e2)) {
      const n2 = t18[e2];
      if (NumberGuard.isFinite(n2)) this.#it[e2] = n2;
      else {
        const t19 = this.#rt.findIndex((t20) => t20 === e2);
        t19 >= 0 && this.#rt.splice(t19, 1), delete this.#it[e2];
      }
    }
  }
  static #_t(t18, e2, n2, o2) {
    const i2 = TJSTransforms.#ft;
    switch (t18) {
      case "top left":
        i2[0] = i2[1] = 0, Mat4.fromTranslation(o2[0], i2), Mat4.fromTranslation(o2[1], i2);
        break;
      case "top center":
        i2[0] = 0.5 * -e2, i2[1] = 0, Mat4.fromTranslation(o2[0], i2), i2[0] = 0.5 * e2, Mat4.fromTranslation(o2[1], i2);
        break;
      case "top right":
        i2[0] = -e2, i2[1] = 0, Mat4.fromTranslation(o2[0], i2), i2[0] = e2, Mat4.fromTranslation(o2[1], i2);
        break;
      case "center left":
        i2[0] = 0, i2[1] = 0.5 * -n2, Mat4.fromTranslation(o2[0], i2), i2[1] = 0.5 * n2, Mat4.fromTranslation(o2[1], i2);
        break;
      case null:
      case "center":
        i2[0] = 0.5 * -e2, i2[1] = 0.5 * -n2, Mat4.fromTranslation(o2[0], i2), i2[0] = 0.5 * e2, i2[1] = 0.5 * n2, Mat4.fromTranslation(o2[1], i2);
        break;
      case "center right":
        i2[0] = -e2, i2[1] = 0.5 * -n2, Mat4.fromTranslation(o2[0], i2), i2[0] = e2, i2[1] = 0.5 * n2, Mat4.fromTranslation(o2[1], i2);
        break;
      case "bottom left":
        i2[0] = 0, i2[1] = -n2, Mat4.fromTranslation(o2[0], i2), i2[1] = n2, Mat4.fromTranslation(o2[1], i2);
        break;
      case "bottom center":
        i2[0] = 0.5 * -e2, i2[1] = -n2, Mat4.fromTranslation(o2[0], i2), i2[0] = 0.5 * e2, i2[1] = n2, Mat4.fromTranslation(o2[1], i2);
        break;
      case "bottom right":
        i2[0] = -e2, i2[1] = -n2, Mat4.fromTranslation(o2[0], i2), i2[0] = e2, i2[1] = n2, Mat4.fromTranslation(o2[1], i2);
        break;
      default:
        Mat4.identity(o2[0]), Mat4.identity(o2[1]);
    }
    return o2;
  }
}
class AnimationScheduler {
  static #it = {};
  static #$t = Object.freeze({ default: false });
  static #bt(t18, e2, n2, o2, i2, r2, a2, s2 = lerp, c2, l2, u2) {
    TJSPositionDataUtil.setNumericDefaults(e2), TJSPositionDataUtil.setNumericDefaults(n2);
    for (const t19 in e2) Number.isFinite(e2[t19]) || delete e2[t19];
    const p2 = Object.keys(e2), d2 = Object.assign({}, e2);
    if (0 === p2.length) return null;
    const m2 = { active: true, cleanup: u2, cancelled: false, control: void 0, current: 0, destination: n2, duration: 1e3 * o2, ease: a2, el: i2, finished: false, initial: e2, interpolate: s2, keys: p2, newData: d2, position: t18, resolve: void 0, start: void 0, transformOrigin: c2, transformOriginInitial: l2, quickTo: false };
    return r2 > 0 && (m2.active = false, setTimeout(() => m2.active = true, 1e3 * r2)), AnimationManager.add(m2), new AnimationControl(m2, true);
  }
  static from(t18, e2, n2 = {}, o2) {
    if (!isObject(e2)) throw new TypeError("AnimationAPI.from error: 'fromData' is not an object.");
    const i2 = t18.parent;
    if (void 0 !== i2 && "boolean" == typeof i2?.options?.positionable && !i2?.options?.positionable) return null;
    let { delay: r2 = 0, duration: a2 = 1, ease: s2 = "cubicOut", strategy: c2, transformOrigin: l2 } = n2;
    if (void 0 !== c2 && null === this.#yt(t18, c2)) return null;
    const u2 = A11yHelper.isFocusTarget(i2) ? i2 : i2?.elementTarget, p2 = A11yHelper.isFocusTarget(u2) && u2.isConnected ? u2 : void 0;
    if (!Number.isFinite(r2) || r2 < 0) throw new TypeError("AnimationScheduler.from error: 'delay' is not a positive number.");
    if (!Number.isFinite(a2) || a2 < 0) throw new TypeError("AnimationScheduler.from error: 'duration' is not a positive number.");
    if (s2 = getEasingFunc(s2, this.#$t), "function" != typeof s2) throw new TypeError("AnimationScheduler.from error: 'ease' is not a function or valid Svelte easing function name.");
    const d2 = {}, m2 = {};
    t18.get(this.#it), l2 = TJSTransforms.isTransformOrigin(l2) ? l2 : void 0;
    const f2 = void 0 !== l2 ? this.#it.transformOrigin : void 0;
    for (const t19 in e2) {
      const n3 = TJSPositionDataUtil.getAnimationKey(t19);
      void 0 !== this.#it[n3] && e2[t19] !== this.#it[n3] && (d2[t19] = e2[t19], m2[t19] = this.#it[n3]);
    }
    return ConvertStringData.process(d2, this.#it, p2), this.#bt(t18, d2, m2, a2, p2, r2, s2, lerp, l2, f2, o2);
  }
  static fromTo(t18, e2, n2, o2 = {}, i2) {
    if (!isObject(e2)) throw new TypeError("AnimationScheduler.fromTo error: 'fromData' is not an object.");
    if (!isObject(n2)) throw new TypeError("AnimationScheduler.fromTo error: 'toData' is not an object.");
    const r2 = t18.parent;
    if (void 0 !== r2 && "boolean" == typeof r2?.options?.positionable && !r2?.options?.positionable) return null;
    let { delay: a2 = 0, duration: s2 = 1, ease: c2 = "cubicOut", strategy: l2, transformOrigin: u2 } = o2;
    if (void 0 !== l2 && null === this.#yt(t18, l2)) return null;
    const p2 = A11yHelper.isFocusTarget(r2) ? r2 : r2?.elementTarget, d2 = A11yHelper.isFocusTarget(p2) && p2.isConnected ? p2 : void 0;
    if (!Number.isFinite(a2) || a2 < 0) throw new TypeError("AnimationScheduler.fromTo error: 'delay' is not a positive number.");
    if (!Number.isFinite(s2) || s2 < 0) throw new TypeError("AnimationScheduler.fromTo error: 'duration' is not a positive number.");
    if (c2 = getEasingFunc(c2, this.#$t), "function" != typeof c2) throw new TypeError("AnimationScheduler.fromTo error: 'ease' is not a function or valid Svelte easing function name.");
    const m2 = {}, f2 = {};
    t18.get(this.#it), u2 = TJSTransforms.isTransformOrigin(u2) ? u2 : void 0;
    const h2 = void 0 !== u2 ? this.#it.transformOrigin : void 0;
    for (const t19 in e2) {
      if (void 0 === n2[t19]) {
        console.warn(`AnimationScheduler.fromTo warning: skipping key ('${t19}') from 'fromData' as it is missing in 'toData'.`);
        continue;
      }
      const o3 = TJSPositionDataUtil.getAnimationKey(t19);
      void 0 !== this.#it[o3] && (m2[t19] = e2[t19], f2[t19] = n2[t19]);
    }
    return ConvertStringData.process(m2, this.#it, d2), ConvertStringData.process(f2, this.#it, d2), this.#bt(t18, m2, f2, s2, d2, a2, c2, lerp, u2, h2, i2);
  }
  static to(t18, e2, n2, o2) {
    if (!isObject(e2)) throw new TypeError("AnimationScheduler.to error: 'toData' is not an object.");
    const i2 = t18.parent;
    if (void 0 !== i2 && "boolean" == typeof i2?.options?.positionable && !i2?.options?.positionable) return null;
    let { delay: r2 = 0, duration: a2 = 1, ease: s2 = "cubicOut", strategy: c2, transformOrigin: l2 } = n2;
    if (void 0 !== c2 && null === this.#yt(t18, c2)) return null;
    const u2 = A11yHelper.isFocusTarget(i2) ? i2 : i2?.elementTarget, p2 = A11yHelper.isFocusTarget(u2) && u2.isConnected ? u2 : void 0;
    if (!Number.isFinite(r2) || r2 < 0) throw new TypeError("AnimationScheduler.to error: 'delay' is not a positive number.");
    if (!Number.isFinite(a2) || a2 < 0) throw new TypeError("AnimationScheduler.to error: 'duration' is not a positive number.");
    if (s2 = getEasingFunc(s2, this.#$t), "function" != typeof s2) throw new TypeError("AnimationScheduler.to error: 'ease' is not a function or valid Svelte easing function name.");
    const d2 = {}, m2 = {};
    t18.get(this.#it), l2 = TJSTransforms.isTransformOrigin(l2) ? l2 : void 0;
    const f2 = void 0 !== l2 ? this.#it.transformOrigin : void 0;
    for (const t19 in e2) {
      const n3 = TJSPositionDataUtil.getAnimationKey(t19);
      void 0 !== this.#it[n3] && e2[t19] !== this.#it[n3] && (m2[t19] = e2[t19], d2[t19] = this.#it[n3]);
    }
    return ConvertStringData.process(m2, this.#it, p2), this.#bt(t18, d2, m2, a2, p2, r2, s2, lerp, l2, f2, o2);
  }
  static #yt(t18, e2) {
    switch (e2) {
      case "cancel":
        AnimationManager.isScheduled(t18) && AnimationManager.cancel(t18);
        break;
      case "cancelAll":
        AnimationManager.isScheduled(t18) && AnimationManager.cancel(t18, AnimationManager.cancelAllFn);
        break;
      case "exclusive":
        if (AnimationManager.isScheduled(t18)) return null;
        break;
      default:
        return console.warn("AnimationScheduler error: 'strategy' is not 'cancel', 'cancelAll', or 'exclusive'."), null;
    }
  }
}
class AnimationAPIImpl {
  static #$t = Object.freeze({ default: false });
  #it;
  #vt;
  constructor(t18, e2) {
    this.#vt = t18, this.#it = e2, Object.seal(this);
  }
  get isScheduled() {
    return AnimationManager.isScheduled(this.#vt);
  }
  cancel() {
    AnimationManager.cancel(this.#vt, AnimationManager.cancelAllFn);
  }
  getScheduled() {
    return AnimationManager.getScheduled(this.#vt);
  }
  from(t18, e2) {
    const n2 = AnimationScheduler.from(this.#vt, t18, e2);
    return n2 || AnimationControl.voidControl;
  }
  fromTo(t18, e2, n2) {
    const o2 = AnimationScheduler.fromTo(this.#vt, t18, e2, n2);
    return o2 || AnimationControl.voidControl;
  }
  to(t18, e2) {
    const n2 = AnimationScheduler.to(this.#vt, t18, e2);
    return n2 || AnimationControl.voidControl;
  }
  quickTo(t18, e2 = {}) {
    if (!isIterable(t18)) throw new TypeError("AnimationAPI.quickTo error: 'keys' is not an iterable list.");
    const n2 = this.#vt.parent;
    if (void 0 !== n2 && "boolean" == typeof n2?.options?.positionable && !n2?.options?.positionable) throw new Error("AnimationAPI.quickTo error: 'parent' is not positionable.");
    let { duration: o2 = 1, ease: i2 = "cubicOut" } = e2;
    if (!Number.isFinite(o2) || o2 < 0) throw new TypeError("AnimationAPI.quickTo error: 'duration' is not a positive number.");
    if (i2 = getEasingFunc(i2, AnimationAPIImpl.#$t), "function" != typeof i2) throw new TypeError("AnimationAPI.quickTo error: 'ease' is not a function or valid Svelte easing function name.");
    const r2 = {}, a2 = {}, s2 = this.#it;
    for (const e3 of t18) {
      if ("string" != typeof e3) throw new TypeError(`AnimationAPI.quickTo error: key ('${e3}') is not a string.`);
      if (!TJSPositionDataUtil.isAnimationKey(e3)) throw new Error(`AnimationAPI.quickTo error: key ('${e3}') is not animatable.`);
      const t19 = TJSPositionDataUtil.getDataOrDefault(s2, e3);
      null !== t19 && (a2[e3] = t19, r2[e3] = t19);
    }
    const c2 = [...t18];
    Object.freeze(c2);
    const l2 = Object.assign({}, r2), u2 = { active: true, cancelled: false, control: void 0, current: 0, destination: a2, duration: 1e3 * o2, ease: i2, el: void 0, finished: true, initial: r2, interpolate: lerp, keys: c2, newData: l2, position: this.#vt, resolve: void 0, start: 0, quickTo: true }, p2 = (...t19) => {
      const e3 = t19.length;
      if (0 === e3) return;
      for (let t20 = c2.length; --t20 >= 0; ) {
        const e4 = c2[t20], n3 = TJSPositionDataUtil.getAnimationKey(e4);
        void 0 !== s2[n3] && (r2[e4] = s2[n3]);
      }
      if (isObject(t19[0])) {
        const e4 = t19[0];
        for (const t20 in e4) void 0 !== a2[t20] && (a2[t20] = e4[t20]);
      } else for (let n3 = 0; n3 < e3 && n3 < c2.length; n3++) {
        const e4 = c2[n3];
        void 0 !== a2[e4] && (a2[e4] = t19[n3]);
      }
      TJSPositionDataUtil.setNumericDefaults(r2), TJSPositionDataUtil.setNumericDefaults(a2);
      const o3 = A11yHelper.isFocusTarget(n2) ? n2 : n2?.elementTarget;
      if (u2.el = A11yHelper.isFocusTarget(o3) && o3.isConnected ? o3 : void 0, ConvertStringData.process(a2, s2, u2.el), u2.finished) u2.cancelled = false, u2.finished = false, u2.active = true, u2.current = 0, AnimationManager.add(u2);
      else {
        const t20 = globalThis.performance.now();
        u2.cancelled = false, u2.current = 0, u2.start = t20 + (AnimationManager.timeNow - t20);
      }
    };
    return Object.defineProperty(p2, "keys", { value: c2, writable: false, configurable: false }), Object.defineProperty(p2, "options", { value: (t19) => {
      let { duration: e3, ease: n3 } = t19;
      if (void 0 !== e3 && (!Number.isFinite(e3) || e3 < 0)) throw new TypeError("AnimationAPI.quickTo.options error: 'duration' is not a positive number.");
      if (n3 = getEasingFunc(n3, AnimationAPIImpl.#$t), void 0 !== n3 && "function" != typeof n3) throw new TypeError("AnimationAPI.quickTo.options error: 'ease' is not a function or valid Svelte easing function name.");
      return NumberGuard.isFinite(e3) && e3 >= 0 && (u2.duration = 1e3 * e3), n3 && (u2.ease = n3), p2;
    }, writable: false, configurable: false }), p2;
  }
}
class AnimationGroupControl {
  #wt;
  #N;
  static #D = new AnimationGroupControl(null);
  static get voidControl() {
    return this.#D;
  }
  constructor(t18) {
    this.#wt = t18;
  }
  get finished() {
    const t18 = this.#wt;
    if (!CrossWindow.isPromise(this.#N)) if (null == t18 || 0 === t18.size) this.#N = Promise.resolve({ cancelled: false });
    else {
      const e2 = [];
      for (const n2 of t18) e2.push(n2.finished);
      this.#N = Promise.allSettled(e2).then((t19) => ({ cancelled: t19.some((t20) => "rejected" === t20.status || "fulfilled" === t20.status && t20.value.cancelled) }));
    }
    return this.#N;
  }
  get isActive() {
    const t18 = this.#wt;
    if (null == t18 || 0 === t18.size) return false;
    for (const e2 of t18) if (e2.isActive) return true;
    return false;
  }
  get isFinished() {
    const t18 = this.#wt;
    if (null == t18 || 0 === t18.size) return true;
    for (const e2 of t18) if (!e2.isFinished) return false;
    return true;
  }
  cancel() {
    const t18 = this.#wt;
    if (null != t18 && 0 !== t18.size) for (const e2 of t18) e2.cancel();
  }
}
class AnimationGroupAPIImpl {
  constructor() {
  }
  static #St(t18) {
    return isObject(t18) ? t18.animate instanceof AnimationAPIImpl ? t18 : t18.position?.animate instanceof AnimationAPIImpl ? t18.position : null : null;
  }
  static cancel(t18) {
    if (isIterable(t18)) {
      let e2 = -1;
      for (const n2 of t18) {
        e2++;
        const t19 = this.#St(n2);
        t19 ? AnimationManager.cancel(t19) : console.warn(`AnimationGroupAPI.cancel warning: No TJSPosition instance found at index: ${e2}.`);
      }
    } else {
      const e2 = this.#St(t18);
      if (!e2) return void console.warn("AnimationGroupAPI.cancel warning: No TJSPosition instance found.");
      AnimationManager.cancel(e2);
    }
  }
  static cancelAll() {
    AnimationManager.cancelAll();
  }
  static getScheduled(t18) {
    const e2 = [];
    if (isIterable(t18)) {
      let n2 = -1;
      for (const o2 of t18) {
        n2++;
        const t19 = this.#St(o2);
        if (!t19) {
          console.warn(`AnimationGroupAPI.getScheduled warning: No TJSPosition instance found at index: ${n2}.`);
          continue;
        }
        const i2 = AnimationManager.getScheduled(t19);
        e2.push({ position: t19, entry: t19 !== o2 ? o2 : void 0, controls: i2 });
      }
    } else {
      const n2 = this.#St(t18);
      if (!n2) return console.warn("AnimationGroupAPI.getScheduled warning: No TJSPosition instance found."), e2;
      const o2 = AnimationManager.getScheduled(n2);
      e2.push({ position: n2, entry: n2 !== t18 ? t18 : void 0, controls: o2 });
    }
    return e2;
  }
  static isAnimationKey(t18) {
    return TJSPositionDataUtil.isAnimationKey(t18);
  }
  static isScheduled(t18, e2) {
    if (isIterable(t18)) {
      let n2 = -1;
      for (const o2 of t18) {
        n2++;
        const t19 = this.#St(o2);
        if (t19) {
          if (!AnimationManager.isScheduled(t19, e2)) return false;
        } else console.warn(`AnimationGroupAPI.isScheduled warning: No TJSPosition instance found at index: ${n2}.`);
      }
    } else {
      const n2 = this.#St(t18);
      if (!n2) return console.warn("AnimationGroupAPI.isScheduled warning: No TJSPosition instance found."), false;
      if (!AnimationManager.isScheduled(n2, e2)) return false;
    }
    return true;
  }
  static from(t18, e2, n2) {
    if (!isObject(e2) && "function" != typeof e2) throw new TypeError("AnimationGroupAPI.from error: 'fromData' is not an object or function.");
    if (void 0 !== n2 && !isObject(n2) && "function" != typeof n2) throw new TypeError("AnimationGroupAPI.from error: 'options' is not an object or function.");
    const o2 = /* @__PURE__ */ new Set(), i2 = (t19) => o2.delete(t19.control);
    let r2, a2 = -1;
    const s2 = "function" == typeof e2, c2 = "function" == typeof n2, l2 = s2 || c2;
    l2 && (r2 = { index: a2, position: void 0, entry: void 0 });
    let u2 = e2, p2 = isObject(n2) ? n2 : void 0;
    if (isIterable(t18)) for (const d2 of t18) {
      a2++;
      const t19 = this.#St(d2);
      if (!t19) {
        console.warn(`AnimationGroupAPI.from warning: No TJSPosition instance found at index: ${a2}.`);
        continue;
      }
      if (l2 && (r2.index = a2, r2.position = t19, r2.entry = t19 !== d2 ? d2 : void 0), s2 && "function" == typeof e2) {
        if (u2 = e2(r2), null == u2) continue;
        if (!isObject(u2)) throw new TypeError(`AnimationGroupAPI.from error: 'fromData' callback function iteration(${a2}) failed to return an object.`);
      }
      if (c2 && "function" == typeof n2) {
        if (p2 = n2(r2), null == p2) continue;
        if (!isObject(p2)) throw new TypeError(`AnimationGroupAPI.from error: 'options' callback function iteration(${a2}) failed to return an object.`);
      }
      const m2 = AnimationScheduler.from(t19, u2, p2, i2);
      m2 && o2.add(m2);
    }
    else {
      const a3 = this.#St(t18);
      if (!a3) return console.warn("AnimationGroupAPI.from warning: No TJSPosition instance found."), AnimationGroupControl.voidControl;
      if (l2 && (r2.index = 0, r2.position = a3, r2.entry = a3 !== t18 ? t18 : void 0), s2 && "function" == typeof e2) {
        if (u2 = e2(r2), null == u2) return AnimationGroupControl.voidControl;
        if (!isObject(u2)) throw new TypeError("AnimationGroupAPI.from error: 'fromData' callback function failed to return an object.");
      }
      if (c2 && "function" == typeof n2) {
        if (p2 = n2(r2), null == p2) return AnimationGroupControl.voidControl;
        if (!isObject(p2)) throw new TypeError("AnimationGroupAPI.from error: 'options' callback function failed to return an object.");
      }
      const d2 = AnimationScheduler.from(a3, u2, p2, i2);
      d2 && o2.add(d2);
    }
    return new AnimationGroupControl(o2);
  }
  static fromTo(t18, e2, n2, o2) {
    if (!isObject(e2) && "function" != typeof e2) throw new TypeError("AnimationGroupAPI.fromTo error: 'fromData' is not an object or function.");
    if (!isObject(n2) && "function" != typeof n2) throw new TypeError("AnimationGroupAPI.fromTo error: 'toData' is not an object or function.");
    if (void 0 !== o2 && !isObject(o2) && "function" != typeof o2) throw new TypeError("AnimationGroupAPI.fromTo error: 'options' is not an object or function.");
    const i2 = /* @__PURE__ */ new Set(), r2 = (t19) => i2.delete(t19.control);
    let a2, s2 = -1;
    const c2 = "function" == typeof e2, l2 = "function" == typeof n2, u2 = "function" == typeof o2, p2 = c2 || l2 || u2;
    p2 && (a2 = { index: s2, position: void 0, entry: void 0 });
    let d2 = e2, m2 = n2, f2 = isObject(o2) ? o2 : void 0;
    if (isIterable(t18)) for (const h2 of t18) {
      s2++;
      const t19 = this.#St(h2);
      if (!t19) {
        console.warn(`AnimationGroupAPI.fromTo warning: No TJSPosition instance found at index: ${s2}.`);
        continue;
      }
      if (p2 && (a2.index = s2, a2.position = t19, a2.entry = t19 !== h2 ? h2 : void 0), c2 && "function" == typeof e2) {
        if (d2 = e2(a2), null == d2) continue;
        if (!isObject(d2)) throw new TypeError(`AnimationGroupAPI.fromTo error: 'fromData' callback function iteration(${s2}) failed to return an object.`);
      }
      if (l2 && "function" == typeof n2) {
        if (m2 = n2(a2), null == m2) continue;
        if (!isObject(m2)) throw new TypeError(`AnimationGroupAPI.fromTo error: 'toData' callback function iteration(${s2}) failed to return an object.`);
      }
      if (u2 && "function" == typeof o2) {
        if (f2 = o2(a2), null == f2) continue;
        if (!isObject(f2)) throw new TypeError(`AnimationGroupAPI.fromTo error: 'options' callback function iteration(${s2}) failed to return an object.`);
      }
      const g2 = AnimationScheduler.fromTo(t19, d2, m2, f2, r2);
      g2 && i2.add(g2);
    }
    else {
      const s3 = this.#St(t18);
      if (!s3) return console.warn("AnimationGroupAPI.fromTo warning: No TJSPosition instance found."), AnimationGroupControl.voidControl;
      if (p2 && (a2.index = 0, a2.position = s3, a2.entry = s3 !== t18 ? t18 : void 0), c2 && "function" == typeof e2) {
        if (d2 = e2(a2), null == d2) return AnimationGroupControl.voidControl;
        if (!isObject(d2)) throw new TypeError("AnimationGroupAPI.fromTo error: 'fromData' callback function failed to return an object.");
      }
      if (l2 && "function" == typeof n2) {
        if (m2 = n2(a2), null == m2) return AnimationGroupControl.voidControl;
        if (!isObject(m2)) throw new TypeError("AnimationGroupAPI.fromTo error: 'toData' callback function failed to return an object.");
      }
      if (u2 && "function" == typeof o2) {
        if (f2 = o2(a2), null == f2) return AnimationGroupControl.voidControl;
        if (!isObject(f2)) throw new TypeError("AnimationGroupAPI.fromTo error: 'options' callback function failed to return an object.");
      }
      const h2 = AnimationScheduler.fromTo(s3, d2, m2, f2, r2);
      h2 && i2.add(h2);
    }
    return new AnimationGroupControl(i2);
  }
  static to(t18, e2, n2) {
    if (!isObject(e2) && "function" != typeof e2) throw new TypeError("AnimationGroupAPI.to error: 'toData' is not an object or function.");
    if (void 0 !== n2 && !isObject(n2) && "function" != typeof n2) throw new TypeError("AnimationGroupAPI.to error: 'options' is not an object or function.");
    const o2 = /* @__PURE__ */ new Set(), i2 = (t19) => o2.delete(t19.control);
    let r2, a2 = -1;
    const s2 = "function" == typeof e2, c2 = "function" == typeof n2, l2 = s2 || c2;
    l2 && (r2 = { index: a2, position: void 0, entry: void 0 });
    let u2 = e2, p2 = isObject(n2) ? n2 : void 0;
    if (isIterable(t18)) for (const d2 of t18) {
      a2++;
      const t19 = this.#St(d2);
      if (!t19) {
        console.warn(`AnimationGroupAPI.to warning: No TJSPosition instance found at index: ${a2}.`);
        continue;
      }
      if (l2 && (r2.index = a2, r2.position = t19, r2.entry = t19 !== d2 ? d2 : void 0), s2 && "function" == typeof e2) {
        if (u2 = e2(r2), null == u2) continue;
        if (!isObject(u2)) throw new TypeError(`AnimationGroupAPI.to error: 'toData' callback function iteration(${a2}) failed to return an object.`);
      }
      if (c2 && "function" == typeof n2) {
        if (p2 = n2(r2), null == p2) continue;
        if (!isObject(p2)) throw new TypeError(`AnimationGroupAPI.to error: 'options' callback function iteration(${a2}) failed to return an object.`);
      }
      const m2 = AnimationScheduler.to(t19, u2, p2, i2);
      m2 && o2.add(m2);
    }
    else {
      const a3 = this.#St(t18);
      if (!a3) return console.warn("AnimationGroupAPI.to warning: No TJSPosition instance found."), AnimationGroupControl.voidControl;
      if (l2 && (r2.index = 0, r2.position = a3, r2.entry = a3 !== t18 ? t18 : void 0), s2 && "function" == typeof e2) {
        if (u2 = e2(r2), null == u2) return AnimationGroupControl.voidControl;
        if (!isObject(u2)) throw new TypeError("AnimationGroupAPI.to error: 'toData' callback function failed to return an object.");
      }
      if (c2 && "function" == typeof n2) {
        if (p2 = n2(r2), null == p2) return AnimationGroupControl.voidControl;
        if (!isObject(p2)) throw new TypeError("AnimationGroupAPI.to error: 'options' callback function failed to return an object.");
      }
      const d2 = AnimationScheduler.to(a3, u2, p2, i2);
      d2 && o2.add(d2);
    }
    return new AnimationGroupControl(o2);
  }
  static quickTo(t18, e2, n2) {
    if (!isIterable(e2)) throw new TypeError("AnimationGroupAPI.quickTo error: 'keys' is not an iterable list.");
    if (void 0 !== n2 && !isObject(n2) && "function" != typeof n2) throw new TypeError("AnimationGroupAPI.quickTo error: 'options' is not an object or function.");
    const o2 = [];
    let i2 = -1;
    const r2 = "function" == typeof n2, a2 = { index: i2, position: void 0, entry: void 0 };
    let s2 = isObject(n2) ? n2 : void 0;
    if (isIterable(t18)) for (const c3 of t18) {
      i2++;
      const t19 = this.#St(c3);
      if (t19) {
        if (a2.index = i2, a2.position = t19, a2.entry = t19 !== c3 ? c3 : void 0, r2 && "function" == typeof n2) {
          if (s2 = n2(a2), null == s2) continue;
          if (!isObject(s2)) throw new TypeError(`AnimationGroupAPI.quickTo error: 'options' callback function iteration(${i2}) failed to return an object.`);
        }
        o2.push(t19.animate.quickTo(e2, s2));
      } else console.warn(`AnimationGroupAPI.quickTo warning: No TJSPosition instance found at index: ${i2}.`);
    }
    else {
      const i3 = this.#St(t18);
      if (!i3) return void console.warn("AnimationGroupAPI.quickTo warning: No TJSPosition instance found.");
      if (a2.index = 0, a2.position = i3, a2.entry = i3 !== t18 ? t18 : void 0, r2 && "function" == typeof n2) {
        if (s2 = n2(a2), null == s2) return;
        if (!isObject(s2)) throw new TypeError("AnimationGroupAPI.quickTo error: 'options' callback function failed to return an object.");
      }
      o2.push(i3.animate.quickTo(e2, s2));
    }
    const c2 = [...e2];
    Object.freeze(c2);
    const l2 = (...e3) => {
      if (0 !== e3.length) if ("function" == typeof e3[0]) {
        const n3 = e3[0];
        i2 = -1;
        let r3 = 0;
        if (isIterable(t18)) for (const e4 of t18) {
          i2++;
          const t19 = this.#St(e4);
          if (!t19) continue;
          a2.index = i2, a2.position = t19, a2.entry = t19 !== e4 ? e4 : void 0;
          const s3 = n3(a2);
          if (null == s3) continue;
          const c3 = isIterable(s3);
          if (!Number.isFinite(s3) && !c3 && !isObject(s3)) throw new TypeError(`AnimationGroupAPI.quickTo error: 'toData' callback function iteration(${i2}) failed to return a finite number, iterable list, or object.`);
          c3 ? o2[r3++](...s3) : o2[r3++](s3);
        }
        else {
          const e4 = this.#St(t18);
          if (!e4) return;
          a2.index = 0, a2.position = e4, a2.entry = e4 !== t18 ? t18 : void 0;
          const s3 = n3(a2);
          if (null == s3) return;
          const c3 = isIterable(s3);
          if (!Number.isFinite(s3) && !c3 && !isObject(s3)) throw new TypeError(`AnimationGroupAPI.quickTo error: 'toData' callback function iteration(${i2}) failed to return a finite number, iterable list, or object.`);
          c3 ? o2[r3++](...s3) : o2[r3++](s3);
        }
      } else for (let t19 = o2.length; --t19 >= 0; ) o2[t19](...e3);
    };
    return Object.defineProperty(l2, "keys", { value: c2, writable: false, configurable: false }), Object.defineProperty(l2, "options", { value: (t19) => {
      if (void 0 !== t19 && !isObject(t19)) throw new TypeError("AnimationGroupAPI.quickTo error: 'options' is not an object.");
      if (isObject(t19)) for (let e3 = o2.length; --e3 >= 0; ) o2[e3].options(t19);
      return l2;
    }, writable: false, configurable: false }), l2;
  }
}
Object.seal(AnimationGroupAPIImpl);
class PositionStateAPI {
  #it;
  #Tt = /* @__PURE__ */ new Map();
  #vt;
  #kt;
  constructor(t18, e2, n2) {
    this.#vt = t18, this.#it = e2, this.#kt = n2, Object.seal(this);
  }
  clear() {
    for (const t18 of this.#Tt.keys()) "#defaultData" !== t18 && this.#Tt.delete(t18);
  }
  get({ name: t18 }) {
    if ("string" != typeof t18) throw new TypeError("TJSPosition - get error: 'name' is not a string.");
    return this.#Tt.get(t18);
  }
  getDefault() {
    return this.#Tt.get("#defaultData");
  }
  keys() {
    return this.#Tt.keys();
  }
  remove({ name: t18 }) {
    if ("string" != typeof t18) throw new TypeError("TJSPosition - remove: 'name' is not a string.");
    const e2 = this.#Tt.get(t18);
    return this.#Tt.delete(t18), e2;
  }
  reset({ keepZIndex: t18 = false, invokeSet: e2 = true } = {}) {
    const n2 = this.#Tt.get("#defaultData");
    if (!isObject(n2)) return false;
    this.#vt.animate.isScheduled && this.#vt.animate.cancel();
    const o2 = this.#vt.zIndex, i2 = Object.assign({}, n2);
    t18 && (i2.zIndex = o2), this.#kt.reset(i2);
    const r2 = this.#vt.parent;
    return r2?.reactive?.minimized && r2?.maximize?.({ animate: false, duration: 0 }), e2 && setTimeout(() => this.#vt.set(i2), 0), true;
  }
  restore({ name: t18, remove: e2 = false, properties: n2, silent: o2 = false, async: i2 = false, animateTo: r2 = false, duration: a2 = 0.1, ease: s2 = "linear" }) {
    if ("string" != typeof t18) throw new TypeError("TJSPosition - restore error: 'name' is not a string.");
    const c2 = this.#Tt.get(t18);
    if (c2) {
      e2 && this.#Tt.delete(t18);
      let l2 = c2;
      if (isIterable(n2)) {
        l2 = {};
        for (const t19 of n2) l2[t19] = c2[t19];
      }
      if (o2) {
        for (const t19 in l2) t19 in this.#it && (this.#it[t19] = l2[t19]);
        return c2;
      }
      if (r2) {
        if (l2.transformOrigin !== this.#vt.transformOrigin && (this.#vt.transformOrigin = l2.transformOrigin), i2) return this.#vt.animate.to(l2, { duration: a2, ease: s2 }).finished.then(() => c2);
        this.#vt.animate.to(l2, { duration: a2, ease: s2 });
      } else this.#vt.set(l2);
    }
    return i2 ? Promise.resolve(c2) : c2;
  }
  save({ name: t18, ...e2 }, n2) {
    if ("string" != typeof t18) throw new TypeError("TJSPosition - save error: 'name' is not a string.");
    const o2 = this.#vt.get(e2, n2);
    return this.#Tt.set(t18, o2), o2;
  }
  set({ name: t18, ...e2 }) {
    if ("string" != typeof t18) throw new TypeError("TJSPosition - set error: 'name' is not a string.");
    this.#Tt.set(t18, e2);
  }
}
class SystemBase {
  #xt;
  #Et;
  #Ot;
  #At;
  #Ct;
  #C = [];
  #Mt;
  constructor({ constrain: t18 = true, element: e2, enabled: n2 = true, lock: o2 = false, width: i2, height: r2 } = {}) {
    this.#xt = true, this.#Ot = true, this.constrain = t18, this.element = e2, this.enabled = n2, this.width = i2, this.height = r2, this.#Ct = "boolean" == typeof o2 && o2;
  }
  get constrain() {
    return this.#xt;
  }
  get element() {
    return this.#Et;
  }
  get enabled() {
    return this.#Ot;
  }
  get height() {
    return this.#At;
  }
  get locked() {
    return this.#Ct;
  }
  get width() {
    return this.#Mt;
  }
  set constrain(t18) {
    if (!this.#Ct) {
      if ("boolean" != typeof t18) throw new TypeError("'constrain' is not a boolean.");
      this.#xt = t18, this.#M();
    }
  }
  set element(t18) {
    if (!this.#Ct) {
      if (null != t18 && !A11yHelper.isFocusTarget(t18)) throw new TypeError("'element' is not a HTMLElement, undefined, or null.");
      this.#Et = t18, this.#M();
    }
  }
  set enabled(t18) {
    if (!this.#Ct) {
      if ("boolean" != typeof t18) throw new TypeError("'enabled' is not a boolean.");
      this.#Ot = t18, this.#M();
    }
  }
  set height(t18) {
    if (!this.#Ct) {
      if (void 0 !== t18 && !Number.isFinite(t18)) throw new TypeError("'height' is not a finite number or undefined.");
      this.#At = t18, this.#M();
    }
  }
  set width(t18) {
    if (!this.#Ct) {
      if (void 0 !== t18 && !Number.isFinite(t18)) throw new TypeError("'width' is not a finite number or undefined.");
      this.#Mt = t18, this.#M();
    }
  }
  setDimension(t18, e2) {
    if (!this.#Ct) {
      if (void 0 !== t18 && !Number.isFinite(t18)) throw new TypeError("'width' is not a finite number or undefined.");
      if (this.#Mt = t18, void 0 !== e2 && !Number.isFinite(e2)) throw new TypeError("'height' is not a finite number or undefined.");
      this.#At = e2, this.#M();
    }
  }
  subscribe(t18) {
    return -1 === this.#C.findIndex((e2) => e2 === t18) && (this.#C.push(t18), t18(this)), () => {
      const e2 = this.#C.findIndex((e3) => e3 === t18);
      -1 !== e2 && this.#C.splice(e2, 1);
    };
  }
  #M() {
    for (let t18 = 0; t18 < this.#C.length; t18++) this.#C[t18](this);
  }
}
class Centered extends SystemBase {
  getLeft(t18) {
    return ((this.width ?? this.element?.offsetWidth ?? globalThis.innerWidth) - t18) / 2;
  }
  getTop(t18) {
    return ((this.height ?? this.element?.offsetHeight ?? globalThis.innerHeight) - t18) / 2;
  }
}
class AdapterValidators {
  #Ot = true;
  #It;
  #Nt = /* @__PURE__ */ new Map();
  #Pt;
  static create(t18) {
    const e2 = new AdapterValidators(t18);
    return [e2, e2.#It];
  }
  constructor(t18) {
    this.#It = [], this.#Pt = t18, Object.seal(this);
  }
  get enabled() {
    return this.#Ot;
  }
  get length() {
    return this.#It.length;
  }
  set enabled(t18) {
    if ("boolean" != typeof t18) throw new TypeError("'enabled' is not a boolean.");
    this.#Ot = t18;
  }
  *[Symbol.iterator]() {
    if (0 !== this.#It.length) for (const t18 of this.#It) yield { ...t18 };
  }
  add(...t18) {
    let e2 = 0;
    for (const n2 of t18) {
      const t19 = typeof n2;
      if ("function" !== t19 && "object" !== t19 || null === n2) throw new TypeError("AdapterValidator error: 'validator' is not a function or object.");
      let o2, i2;
      switch (t19) {
        case "function":
          o2 = { id: void 0, validate: n2, weight: 1 }, i2 = n2.subscribe;
          break;
        case "object":
          if (!("validate" in n2)) throw new TypeError("AdapterValidator error: 'validate' attribute is not a function.");
          if ("function" != typeof n2.validate) throw new TypeError("AdapterValidator error: 'validate' attribute is not a function.");
          if (void 0 !== n2.weight && "number" != typeof n2.weight || n2?.weight < 0 || n2?.weight > 1) throw new TypeError("AdapterValidator error: 'weight' attribute is not a number between '0 - 1' inclusive.");
          o2 = { id: void 0 !== n2.id ? n2.id : void 0, validate: n2.validate.bind(n2), weight: n2.weight || 1 }, i2 = n2.validate.subscribe ?? n2.subscribe;
      }
      const r2 = this.#It.findIndex((t20) => o2.weight < t20.weight);
      if (r2 >= 0 ? this.#It.splice(r2, 0, o2) : this.#It.push(o2), "function" == typeof i2) {
        const t20 = i2.call(n2, this.#Pt);
        if ("function" != typeof t20) throw new TypeError("AdapterValidator error: Validator has subscribe function, but no unsubscribe function is returned.");
        if (this.#Nt.has(o2.validate)) throw new Error("AdapterValidator error: Validator added already has an unsubscribe function registered.");
        this.#Nt.set(o2.validate, t20), e2++;
      }
    }
    e2 < t18.length && this.#Pt();
  }
  clear() {
    this.#It.length = 0;
    for (const t18 of this.#Nt.values()) t18();
    this.#Nt.clear(), this.#Pt();
  }
  remove(...t18) {
    const e2 = this.#It.length;
    if (0 !== e2) {
      for (const e3 of t18) {
        const t19 = "function" == typeof e3 ? e3 : isObject(e3) ? e3.validate : void 0;
        if (t19) {
          for (let e4 = this.#It.length; --e4 >= 0; ) if (this.#It[e4].validate === t19) {
            let n2;
            this.#It.splice(e4, 1), "function" == typeof (n2 = this.#Nt.get(t19)) && (n2(), this.#Nt.delete(t19));
          }
        }
      }
      e2 !== this.#It.length && this.#Pt();
    }
  }
  removeBy(t18) {
    const e2 = this.#It.length;
    if (0 !== e2) {
      if ("function" != typeof t18) throw new TypeError("AdapterValidator error: 'callback' is not a function.");
      this.#It = this.#It.filter((e3) => {
        const n2 = t18.call(t18, { ...e3 });
        if (n2) {
          let t19;
          "function" == typeof (t19 = this.#Nt.get(e3.validate)) && (t19(), this.#Nt.delete(e3.validate));
        }
        return !n2;
      }), e2 !== this.#It.length && this.#Pt();
    }
  }
  removeById(...t18) {
    const e2 = this.#It.length;
    0 !== e2 && (this.#It = this.#It.filter((e3) => {
      let n2 = false;
      for (const o2 of t18) n2 ||= e3.id === o2;
      if (n2) {
        let t19;
        "function" == typeof (t19 = this.#Nt.get(e3.validate)) && (t19(), this.#Nt.delete(e3.validate));
      }
      return !n2;
    }), e2 !== this.#It.length && this.#Pt());
  }
}
class TransformBounds extends SystemBase {
  static #Dt = new TJSTransformData();
  validate(t18) {
    if (!this.enabled) return t18.position;
    const e2 = this.width ?? this.element?.offsetWidth ?? globalThis.innerWidth, n2 = this.height ?? this.element?.offsetHeight ?? globalThis.innerHeight;
    if ("number" == typeof t18.position.width) {
      const n3 = t18.maxWidth ?? (this.constrain ? e2 : Number.MAX_SAFE_INTEGER);
      t18.position.width = clamp(t18.width, t18.minWidth, n3);
    }
    if ("number" == typeof t18.position.height) {
      const e3 = t18.maxHeight ?? (this.constrain ? n2 : Number.MAX_SAFE_INTEGER);
      t18.position.height = clamp(t18.height, t18.minHeight, e3);
    }
    const o2 = t18.transforms.getData(t18.position, TransformBounds.#Dt, t18), i2 = o2.boundingRect.x, r2 = o2.boundingRect.y, a2 = t18.marginTop ?? 0, s2 = t18.marginLeft ?? 0;
    return o2.boundingRect.bottom + a2 > n2 && (o2.boundingRect.y += n2 - o2.boundingRect.bottom - a2), o2.boundingRect.right + s2 > e2 && (o2.boundingRect.x += e2 - o2.boundingRect.right - s2), o2.boundingRect.top - a2 < 0 && (o2.boundingRect.y += Math.abs(o2.boundingRect.top - a2)), o2.boundingRect.left - s2 < 0 && (o2.boundingRect.x += Math.abs(o2.boundingRect.left - s2)), t18.position.left -= i2 - o2.boundingRect.x, t18.position.top -= r2 - o2.boundingRect.y, t18.position;
  }
}
class PositionChangeSet {
  left;
  top;
  width;
  height;
  maxHeight;
  maxWidth;
  minHeight;
  minWidth;
  zIndex;
  transform;
  transformOrigin;
  constructor() {
    this.left = false, this.top = false, this.width = false, this.height = false, this.maxHeight = false, this.maxWidth = false, this.minHeight = false, this.minWidth = false, this.zIndex = false, this.transform = false, this.transformOrigin = false;
  }
  hasChange() {
    return this.left || this.top || this.width || this.height || this.maxHeight || this.maxWidth || this.minHeight || this.minWidth || this.zIndex || this.transform || this.transformOrigin;
  }
  set(t18) {
    this.left = t18, this.top = t18, this.width = t18, this.height = t18, this.maxHeight = t18, this.maxWidth = t18, this.minHeight = t18, this.minWidth = t18, this.zIndex = t18, this.transform = t18, this.transformOrigin = t18;
  }
}
class UpdateElementData {
  changeSet;
  data;
  dataSubscribers;
  dimensionData;
  options;
  queued;
  storeDimension;
  storeTransform;
  styleCache;
  subscribers;
  transforms;
  transformData;
  constructor(t18, e2, n2, o2, i2, r2) {
    this.changeSet = t18, this.data = e2, this.dataSubscribers = Object.seal(new TJSPositionData()), this.dimensionData = Object.seal({ width: 0, height: 0 }), this.options = n2, this.queued = false, this.styleCache = o2, this.storeDimension = writable(this.dimensionData), this.subscribers = i2, this.transforms = r2, this.transformData = new TJSTransformData(), this.storeTransform = writable(this.transformData, () => (this.options.transformSubscribed = true, () => this.options.transformSubscribed = false));
  }
}
class UpdateElementManager {
  static list = [];
  static listCntr = 0;
  static updatePromise;
  static add(t18, e2) {
    if (this.listCntr < this.list.length) {
      const n2 = this.list[this.listCntr];
      n2[0] = t18, n2[1] = e2;
    } else this.list.push([t18, e2]);
    return this.listCntr++, e2.queued = true, this.updatePromise || (this.updatePromise = this.wait()), this.updatePromise;
  }
  static async wait() {
    const t18 = await nextAnimationFrame();
    this.updatePromise = void 0;
    for (let t19 = this.listCntr; --t19 >= 0; ) {
      const e2 = this.list[t19], n2 = e2[0], o2 = e2[1];
      e2[0] = void 0, e2[1] = void 0, o2.queued = false, n2.isConnected && (o2.options.ortho ? UpdateElementManager.#jt(n2, o2) : UpdateElementManager.#Ft(n2, o2), (o2.options.calculateTransform || o2.options.transformSubscribed) && UpdateElementManager.#Lt(o2), this.updateSubscribers(o2));
    }
    return this.listCntr = 0, t18;
  }
  static immediate(t18, e2) {
    t18.isConnected && (e2.options.ortho ? UpdateElementManager.#jt(t18, e2) : UpdateElementManager.#Ft(t18, e2), (e2.options.calculateTransform || e2.options.transformSubscribed) && UpdateElementManager.#Lt(e2), this.updateSubscribers(e2));
  }
  static updateSubscribers(t18) {
    const e2 = t18.data, n2 = t18.changeSet;
    if (!n2.hasChange()) return;
    const o2 = TJSPositionDataUtil.copyData(e2, t18.dataSubscribers), i2 = t18.subscribers;
    if (i2.length > 0) for (let t19 = 0; t19 < i2.length; t19++) i2[t19](o2);
    (n2.width || n2.height) && (t18.dimensionData.width = e2.width, t18.dimensionData.height = e2.height, t18.storeDimension.set(t18.dimensionData)), n2.set(false);
  }
  static #Rt = Object.seal({ height: 0, width: 0, marginLeft: 0, marginTop: 0 });
  static #Ft(t18, e2) {
    const n2 = e2.changeSet, o2 = e2.data;
    n2.left && (t18.style.left = `${o2.left}px`), n2.top && (t18.style.top = `${o2.top}px`), n2.zIndex && (t18.style.zIndex = "number" == typeof o2.zIndex ? `${o2.zIndex}` : ""), n2.width && (t18.style.width = "number" == typeof o2.width ? `${o2.width}px` : o2.width), n2.height && (t18.style.height = "number" == typeof o2.height ? `${o2.height}px` : o2.height), n2.transformOrigin && (t18.style.transformOrigin = o2.transformOrigin), n2.transform && (t18.style.transform = e2.transforms.isActive ? e2.transforms.getCSS() : "");
  }
  static #jt(t18, e2) {
    const n2 = e2.changeSet, o2 = e2.data;
    n2.zIndex && (t18.style.zIndex = "number" == typeof o2.zIndex ? `${o2.zIndex}` : ""), n2.width && (t18.style.width = "number" == typeof o2.width ? `${o2.width}px` : o2.width), n2.height && (t18.style.height = "number" == typeof o2.height ? `${o2.height}px` : o2.height), n2.transformOrigin && (t18.style.transformOrigin = o2.transformOrigin), (n2.left || n2.top || n2.transform) && (t18.style.transform = e2.transforms.getCSSOrtho(o2));
  }
  static #Lt(t18) {
    const e2 = this.#Rt;
    e2.height = "auto" !== t18.data.height && "inherit" !== t18.data.height ? t18.data.height : t18.styleCache.offsetHeight, e2.width = "auto" !== t18.data.width && "inherit" !== t18.data.width ? t18.data.width : t18.styleCache.offsetWidth, e2.marginLeft = t18.styleCache.marginLeft, e2.marginTop = t18.styleCache.marginTop, t18.transforms.getData(t18.data, t18.transformData, e2), t18.storeTransform.set(t18.transformData);
  }
}
class TJSPosition {
  static #zt = Object.freeze({ browserCentered: new Centered({ lock: true }), Centered });
  static #Ht = Object.freeze({ TransformBounds, transformWindow: new TransformBounds({ lock: true }) });
  #it = Object.seal(new TJSPositionData());
  #Wt = new AnimationAPIImpl(this, this.#it);
  #Ot = true;
  #Ut = { calculateTransform: false, initial: void 0, ortho: true, transformSubscribed: false };
  #qt;
  #Gt = new PositionChangeSet();
  #Bt = false;
  #l;
  #Jt;
  #C = [];
  #kt = new TJSTransforms();
  #Yt;
  #Xt;
  #Vt;
  #It;
  #Kt = new PositionStateAPI(this, this.#it, this.#kt);
  static get Animate() {
    return AnimationGroupAPIImpl;
  }
  static get Data() {
    return TJSPositionData;
  }
  static get Initial() {
    return this.#zt;
  }
  static get SystemBase() {
    return SystemBase;
  }
  static get TransformData() {
    return TJSTransformData;
  }
  static get Validators() {
    return this.#Ht;
  }
  static get transformOrigins() {
    return TJSTransforms.transformOrigins;
  }
  static copyData(t18, e2) {
    return TJSPositionDataUtil.copyData(t18, e2);
  }
  static duplicate(t18, e2 = {}) {
    if (!(t18 instanceof _a)) throw new TypeError("'position' is not an instance of TJSPosition.");
    const n2 = new _a(e2);
    return n2.#Ut = Object.assign({}, t18.#Ut, e2), n2.#Vt.add(...t18.#Vt), n2.set(t18.#it), n2;
  }
  constructor(t18, e2) {
    isPlainObject(t18) ? e2 = t18 : this.#qt = t18, this.#Jt = new TJSPositionStyleCache();
    const n2 = new UpdateElementData(this.#Gt, this.#it, this.#Ut, this.#Jt, this.#C, this.#kt);
    if (this.#Yt = n2, "boolean" == typeof e2?.calculateTransform && (this.#Ut.calculateTransform = e2.calculateTransform), "boolean" == typeof e2?.ortho && (this.#Ut.ortho = e2.ortho), this.#l = Object.freeze({ height: propertyStore(this, "height"), left: propertyStore(this, "left"), rotateX: propertyStore(this, "rotateX"), rotateY: propertyStore(this, "rotateY"), rotateZ: propertyStore(this, "rotateZ"), scale: propertyStore(this, "scale"), top: propertyStore(this, "top"), transformOrigin: propertyStore(this, "transformOrigin"), translateX: propertyStore(this, "translateX"), translateY: propertyStore(this, "translateY"), translateZ: propertyStore(this, "translateZ"), width: propertyStore(this, "width"), zIndex: propertyStore(this, "zIndex"), maxHeight: propertyStore(this, "maxHeight"), maxWidth: propertyStore(this, "maxWidth"), minHeight: propertyStore(this, "minHeight"), minWidth: propertyStore(this, "minWidth"), dimension: { subscribe: n2.storeDimension.subscribe }, element: { subscribe: this.#Jt.stores.element.subscribe }, resizeContentHeight: { subscribe: this.#Jt.stores.resizeContentHeight.subscribe }, resizeContentWidth: { subscribe: this.#Jt.stores.resizeContentWidth.subscribe }, resizeObservable: { subscribe: this.#Jt.stores.resizeObservable.subscribe }, resizeOffsetHeight: { subscribe: this.#Jt.stores.resizeOffsetHeight.subscribe }, resizeOffsetWidth: { subscribe: this.#Jt.stores.resizeOffsetWidth.subscribe }, transform: { subscribe: n2.storeTransform.subscribe }, resizeObserved: this.#Jt.stores.resizeObserved }), Object.defineProperty(this.#l.transformOrigin, "values", { get: () => _a.transformOrigins }), subscribeIgnoreFirst(this.#l.resizeObserved, (t19) => {
      const e3 = this.#qt, n3 = A11yHelper.isFocusTarget(e3) ? e3 : e3?.elementTarget;
      A11yHelper.isFocusTarget(n3) && Number.isFinite(t19?.offsetWidth) && Number.isFinite(t19?.offsetHeight) && this.set();
    }), [this.#Vt, this.#It] = AdapterValidators.create(() => this.set()), e2?.initial) {
      const t19 = e2.initial;
      if ("function" != typeof t19?.getLeft || "function" != typeof t19?.getTop) throw new Error("'options.initial' position helper does not contain 'getLeft' and / or 'getTop' functions.");
      this.#Ut.initial = t19;
    }
    if (e2?.validator) if (isIterable(e2?.validator)) this.validators.add(...e2.validator);
    else {
      const t19 = e2.validator;
      this.validators.add(t19);
    }
    Object.seal(this), isObject(e2) && this.set(e2);
  }
  get animate() {
    return this.#Wt;
  }
  get dimension() {
    return this.#Yt.dimensionData;
  }
  get enabled() {
    return this.#Ot;
  }
  get element() {
    return this.#Jt.el;
  }
  get elementUpdated() {
    return this.#Xt;
  }
  get parent() {
    return this.#qt;
  }
  get state() {
    return this.#Kt;
  }
  get stores() {
    return this.#l;
  }
  get transform() {
    return this.#Yt.transformData;
  }
  get validators() {
    return this.#Vt;
  }
  set enabled(t18) {
    if ("boolean" != typeof t18) throw new TypeError("'enabled' is not a boolean.");
    this.#Ot = t18;
  }
  set parent(t18) {
    if (void 0 !== t18 && !A11yHelper.isFocusTarget(t18) && !isObject(t18)) throw new TypeError("'parent' is not an HTMLElement, object, or undefined.");
    this.#qt = t18, this.#Kt.remove({ name: "#defaultData" }), this.#Jt.reset(), t18 && this.set(this.#it);
  }
  get height() {
    return this.#it.height;
  }
  get left() {
    return this.#it.left;
  }
  get maxHeight() {
    return this.#it.maxHeight;
  }
  get maxWidth() {
    return this.#it.maxWidth;
  }
  get minHeight() {
    return this.#it.minHeight;
  }
  get minWidth() {
    return this.#it.minWidth;
  }
  get rotateX() {
    return this.#it.rotateX;
  }
  get rotateY() {
    return this.#it.rotateY;
  }
  get rotateZ() {
    return this.#it.rotateZ;
  }
  get rotation() {
    return this.#it.rotateZ;
  }
  get scale() {
    return this.#it.scale;
  }
  get top() {
    return this.#it.top;
  }
  get transformOrigin() {
    return this.#it.transformOrigin;
  }
  get translateX() {
    return this.#it.translateX;
  }
  get translateY() {
    return this.#it.translateY;
  }
  get translateZ() {
    return this.#it.translateZ;
  }
  get width() {
    return this.#it.width;
  }
  get zIndex() {
    return this.#it.zIndex;
  }
  set height(t18) {
    this.#l.height.set(t18);
  }
  set left(t18) {
    this.#l.left.set(t18);
  }
  set maxHeight(t18) {
    this.#l.maxHeight.set(t18);
  }
  set maxWidth(t18) {
    this.#l.maxWidth.set(t18);
  }
  set minHeight(t18) {
    this.#l.minHeight.set(t18);
  }
  set minWidth(t18) {
    this.#l.minWidth.set(t18);
  }
  set rotateX(t18) {
    this.#l.rotateX.set(t18);
  }
  set rotateY(t18) {
    this.#l.rotateY.set(t18);
  }
  set rotateZ(t18) {
    this.#l.rotateZ.set(t18);
  }
  set rotation(t18) {
    this.#l.rotateZ.set(t18);
  }
  set scale(t18) {
    this.#l.scale.set(t18);
  }
  set top(t18) {
    this.#l.top.set(t18);
  }
  set transformOrigin(t18) {
    TJSTransforms.transformOrigins.includes(t18) && this.#l.transformOrigin.set(t18);
  }
  set translateX(t18) {
    this.#l.translateX.set(t18);
  }
  set translateY(t18) {
    this.#l.translateY.set(t18);
  }
  set translateZ(t18) {
    this.#l.translateZ.set(t18);
  }
  set width(t18) {
    this.#l.width.set(t18);
  }
  set zIndex(t18) {
    this.#l.zIndex.set(t18);
  }
  get(t18 = {}, e2 = {}) {
    const n2 = e2?.keys, o2 = e2?.exclude, i2 = e2?.nullable ?? true, r2 = e2?.numeric ?? false;
    if (isIterable(n2)) {
      for (const e3 of n2) t18[e3] = r2 ? TJSPositionDataUtil.getDataOrDefault(this, e3) : this[e3], i2 || null !== t18[e3] || delete t18[e3];
      if (isIterable(o2)) for (const e3 of o2) delete t18[e3];
      return t18;
    }
    if (t18 = Object.assign(t18, this.#it), isIterable(o2)) for (const e3 of o2) delete t18[e3];
    if (r2 && TJSPositionDataUtil.setNumericDefaults(t18), !i2) for (const e3 in t18) null === t18[e3] && delete t18[e3];
    return t18;
  }
  toJSON() {
    return Object.assign({}, this.#it);
  }
  set(t18 = {}, e2 = {}) {
    if (!isObject(t18)) throw new TypeError("TJSPosition - set error: 'position' is not an object.");
    const n2 = this.#qt;
    if (!this.#Ot) return this;
    if (void 0 !== n2 && "boolean" == typeof n2?.options?.positionable && !n2?.options?.positionable) return this;
    const o2 = e2?.immediateElementUpdate ?? false, i2 = this.#it, r2 = this.#kt, a2 = A11yHelper.isFocusTarget(n2) ? n2 : n2?.elementTarget, s2 = A11yHelper.isFocusTarget(a2) && a2.isConnected ? a2 : void 0, c2 = this.#Gt, l2 = this.#Jt;
    if (s2 && (l2.hasData(s2) || (l2.update(s2), l2.hasWillChange, c2.set(true), this.#Yt.queued = false), ConvertStringData.process(t18, this.#it, s2), null === (t18 = this.#Zt(t18, n2, s2, l2)))) return this;
    NumberGuard.isFinite(t18.left) && (t18.left = Math.round(t18.left), i2.left !== t18.left && (i2.left = t18.left, c2.left = true)), NumberGuard.isFinite(t18.top) && (t18.top = Math.round(t18.top), i2.top !== t18.top && (i2.top = t18.top, c2.top = true)), NumberGuard.isFiniteOrNull(t18.maxHeight) && (t18.maxHeight = "number" == typeof t18.maxHeight ? Math.round(t18.maxHeight) : null, i2.maxHeight !== t18.maxHeight && (i2.maxHeight = t18.maxHeight, c2.maxHeight = true)), NumberGuard.isFiniteOrNull(t18.maxWidth) && (t18.maxWidth = "number" == typeof t18.maxWidth ? Math.round(t18.maxWidth) : null, i2.maxWidth !== t18.maxWidth && (i2.maxWidth = t18.maxWidth, c2.maxWidth = true)), NumberGuard.isFiniteOrNull(t18.minHeight) && (t18.minHeight = "number" == typeof t18.minHeight ? Math.round(t18.minHeight) : null, i2.minHeight !== t18.minHeight && (i2.minHeight = t18.minHeight, c2.minHeight = true)), NumberGuard.isFiniteOrNull(t18.minWidth) && (t18.minWidth = "number" == typeof t18.minWidth ? Math.round(t18.minWidth) : null, i2.minWidth !== t18.minWidth && (i2.minWidth = t18.minWidth, c2.minWidth = true)), NumberGuard.isFiniteOrNull(t18.rotateX) && i2.rotateX !== t18.rotateX && (i2.rotateX = r2.rotateX = t18.rotateX, c2.transform = true), NumberGuard.isFiniteOrNull(t18.rotateY) && i2.rotateY !== t18.rotateY && (i2.rotateY = r2.rotateY = t18.rotateY, c2.transform = true), NumberGuard.isFiniteOrNull(t18.rotateZ) && i2.rotateZ !== t18.rotateZ && (i2.rotateZ = r2.rotateZ = t18.rotateZ, c2.transform = true), NumberGuard.isFiniteOrNull(t18.scale) && (t18.scale = "number" == typeof t18.scale ? clamp(t18.scale, 0, 1e3) : null, i2.scale !== t18.scale && (i2.scale = r2.scale = t18.scale, c2.transform = true)), ("string" == typeof t18.transformOrigin && TJSTransforms.transformOrigins.includes(t18.transformOrigin) || null === t18.transformOrigin) && i2.transformOrigin !== t18.transformOrigin && (i2.transformOrigin = t18.transformOrigin, c2.transformOrigin = true), NumberGuard.isFiniteOrNull(t18.translateX) && i2.translateX !== t18.translateX && (i2.translateX = r2.translateX = t18.translateX, c2.transform = true), NumberGuard.isFiniteOrNull(t18.translateY) && i2.translateY !== t18.translateY && (i2.translateY = r2.translateY = t18.translateY, c2.transform = true), NumberGuard.isFiniteOrNull(t18.translateZ) && i2.translateZ !== t18.translateZ && (i2.translateZ = r2.translateZ = t18.translateZ, c2.transform = true), NumberGuard.isFinite(t18.zIndex) && (t18.zIndex = Math.round(t18.zIndex), i2.zIndex !== t18.zIndex && (i2.zIndex = t18.zIndex, c2.zIndex = true));
    const u2 = "auto" === t18.width || "inherit" === t18.width;
    (NumberGuard.isFiniteOrNull(t18.width) || u2) && (t18.width = "number" == typeof t18.width ? Math.round(t18.width) : t18.width, i2.width !== t18.width && (i2.width = t18.width, c2.width = true));
    const p2 = "auto" === t18.height || "inherit" === t18.height;
    (NumberGuard.isFiniteOrNull(t18.height) || p2) && (t18.height = "number" == typeof t18.height ? Math.round(t18.height) : t18.height, i2.height !== t18.height && (i2.height = t18.height, c2.height = true));
    const d2 = u2 || p2;
    if (this.#Bt !== d2 && (this.#Bt = d2, this.#Jt.stores.resizeObservable.set(d2)), s2) {
      isObject(this.#Kt.getDefault()) || this.#Kt.save({ name: "#defaultData", ...Object.assign({}, i2) }), o2 ? (UpdateElementManager.immediate(s2, this.#Yt), this.#Xt = Promise.resolve(globalThis.performance.now())) : this.#Yt.queued || (this.#Xt = UpdateElementManager.add(s2, this.#Yt));
    } else UpdateElementManager.updateSubscribers(this.#Yt);
    return this;
  }
  subscribe(t18) {
    return -1 === this.#C.findIndex((e2) => e2 === t18) && (this.#C.push(t18), t18(Object.assign({}, this.#it))), () => {
      const e2 = this.#C.findIndex((e3) => e3 === t18);
      -1 !== e2 && this.#C.splice(e2, 1);
    };
  }
  update(t18) {
    const e2 = t18(this.get());
    if (!isObject(e2)) throw new TypeError("'result' of 'updater' is not an object.");
    this.set(e2);
  }
  static #Qt = Object.seal(new TJSPositionData());
  static #Rt = Object.seal({ position: void 0, parent: void 0, el: void 0, computed: void 0, transforms: void 0, height: void 0, width: void 0, marginLeft: void 0, marginTop: void 0, maxHeight: void 0, maxWidth: void 0, minHeight: void 0, minWidth: void 0, rest: void 0 });
  #Zt({ left: t18, top: e2, maxWidth: n2, maxHeight: o2, minWidth: i2, minHeight: r2, width: a2, height: s2, rotateX: c2, rotateY: l2, rotateZ: u2, scale: p2, transformOrigin: d2, translateX: m2, translateY: f2, translateZ: h2, zIndex: g2, rotation: _, ...$2 }, b2, y2, v2) {
    let w2 = TJSPositionDataUtil.copyData(this.#it, _a.#Qt);
    if (void 0 !== a2 || "" === y2.style.width) {
      const t19 = null === a2 || Number.isFinite(a2);
      if ("auto" === a2 || "auto" === w2.width && !t19) w2.width = "auto", a2 = v2.offsetWidth;
      else if ("inherit" === a2 || "inherit" === w2.width && !t19) w2.width = "inherit", a2 = v2.offsetWidth;
      else {
        const t20 = NumberGuard.isFinite(a2) ? a2 : w2.width;
        w2.width = a2 = NumberGuard.isFinite(t20) ? Math.round(t20) : v2.offsetWidth;
      }
    } else a2 = Number.isFinite(w2.width) ? w2.width : v2.offsetWidth;
    if (void 0 !== s2 || "" === y2.style.height) {
      const t19 = null === s2 || Number.isFinite(s2);
      if ("auto" === s2 || "auto" === w2.height && !t19) w2.height = "auto", s2 = v2.offsetHeight;
      else if ("inherit" === s2 || "inherit" === w2.height && !t19) w2.height = "inherit", s2 = v2.offsetHeight;
      else {
        const t20 = NumberGuard.isFinite(s2) ? s2 : w2.height;
        w2.height = s2 = NumberGuard.isFinite(t20) ? Math.round(t20) : v2.offsetHeight;
      }
    } else s2 = Number.isFinite(w2.height) ? w2.height : v2.offsetHeight;
    NumberGuard.isFinite(t18) ? w2.left = t18 : Number.isFinite(w2.left) || (w2.left = "function" == typeof this.#Ut?.initial?.getLeft ? this.#Ut.initial.getLeft(a2) : 0), Number.isFinite(e2) ? w2.top = e2 : Number.isFinite(w2.top) || (w2.top = "function" == typeof this.#Ut?.initial?.getTop ? this.#Ut.initial.getTop(s2) : 0), NumberGuard.isFiniteOrNull(o2) && (w2.maxHeight = NumberGuard.isFinite(o2) ? Math.round(o2) : null), NumberGuard.isFiniteOrNull(n2) && (w2.maxWidth = NumberGuard.isFinite(n2) ? Math.round(n2) : null), NumberGuard.isFiniteOrNull(r2) && (w2.minHeight = NumberGuard.isFinite(r2) ? Math.round(r2) : null), NumberGuard.isFiniteOrNull(i2) && (w2.minWidth = NumberGuard.isFinite(i2) ? Math.round(i2) : null), NumberGuard.isFiniteOrNull(c2) && (w2.rotateX = c2), NumberGuard.isFiniteOrNull(l2) && (w2.rotateY = l2), u2 !== w2.rotateZ && NumberGuard.isFiniteOrNull(u2) ? w2.rotateZ = u2 : _ !== w2.rotateZ && NumberGuard.isFiniteOrNull(_) && (w2.rotateZ = _), NumberGuard.isFiniteOrNull(m2) && (w2.translateX = m2), NumberGuard.isFiniteOrNull(f2) && (w2.translateY = f2), NumberGuard.isFiniteOrNull(h2) && (w2.translateZ = h2), NumberGuard.isFiniteOrNull(p2) && (w2.scale = "number" == typeof p2 ? clamp(p2, 0, 1e3) : null), "string" != typeof d2 && null !== d2 || (w2.transformOrigin = TJSTransforms.transformOrigins.includes(d2) ? d2 : null), NumberGuard.isFiniteOrNull(g2) && (w2.zIndex = "number" == typeof g2 ? Math.round(g2) : g2);
    const S2 = this.#It;
    if (this.#Vt.enabled && S2.length) {
      const t19 = _a.#Rt;
      t19.parent = b2, t19.el = y2, t19.computed = v2.computed, t19.transforms = this.#kt, t19.height = s2, t19.width = a2, t19.marginLeft = v2.marginLeft, t19.marginTop = v2.marginTop, t19.maxHeight = v2.maxHeight ?? w2.maxHeight, t19.maxWidth = v2.maxWidth ?? w2.maxWidth;
      const e3 = b2?.reactive?.minimized ?? false;
      t19.minHeight = e3 ? w2.minHeight ?? 0 : v2.minHeight || (w2.minHeight ?? 0), t19.minWidth = e3 ? w2.minWidth ?? 0 : v2.minWidth || (w2.minWidth ?? 0);
      for (let e4 = 0; e4 < S2.length; e4++) if (t19.position = w2, t19.rest = $2, w2 = S2[e4].validate(t19), null === w2) return null;
    }
    return w2;
  }
}
_a = TJSPosition;
const cssVariables = new TJSStyleManager({ docKey: "#__trl-root-styles", version: 1 });
class ResizeObserverManager {
  #te = /* @__PURE__ */ new Map();
  #ee;
  static #ne = Object.freeze({ none: 0, attribute: 1, function: 2, resizeObserved: 3, setContentBounds: 4, setDimension: 5, storeObject: 6, storesObject: 7 });
  constructor() {
    this.#ee = new ResizeObserver((t18) => {
      for (const e2 of t18) {
        const t19 = this.#te.get(e2?.target);
        if (Array.isArray(t19)) {
          const n2 = e2.contentRect.width, o2 = e2.contentRect.height;
          for (const e3 of t19) ResizeObserverManager.#oe(e3, n2, o2);
        }
      }
    });
  }
  add(t18, e2) {
    if (!CrossWindow.isHTMLElement(t18)) throw new TypeError("ResizeObserverManager.add error: 'el' is not a HTMLElement.");
    if (this.#ie(t18, e2)) return;
    const n2 = ResizeObserverManager.#re(e2);
    if (0 === n2) throw new Error("ResizeObserverManager.add error: 'target' is not a valid ResizeObserverManager target.");
    const o2 = globalThis.getComputedStyle(t18), i2 = StyleParse.pixels(t18.style.borderBottom) ?? StyleParse.pixels(o2.borderBottom) ?? 0, r2 = StyleParse.pixels(t18.style.borderLeft) ?? StyleParse.pixels(o2.borderLeft) ?? 0, a2 = StyleParse.pixels(t18.style.borderRight) ?? StyleParse.pixels(o2.borderRight) ?? 0, s2 = StyleParse.pixels(t18.style.borderTop) ?? StyleParse.pixels(o2.borderTop) ?? 0, c2 = StyleParse.pixels(t18.style.paddingBottom) ?? StyleParse.pixels(o2.paddingBottom) ?? 0, l2 = { updateType: n2, target: e2, contentWidth: 0, contentHeight: 0, styles: { additionalWidth: r2 + a2 + (StyleParse.pixels(t18.style.paddingLeft) ?? StyleParse.pixels(o2.paddingLeft) ?? 0) + (StyleParse.pixels(t18.style.paddingRight) ?? StyleParse.pixels(o2.paddingRight) ?? 0), additionalHeight: s2 + i2 + (StyleParse.pixels(t18.style.paddingTop) ?? StyleParse.pixels(o2.paddingTop) ?? 0) + c2 } };
    if (this.#te.has(t18)) {
      this.#te.get(t18).push(l2);
    } else this.#te.set(t18, [l2]);
    this.#ee.observe(t18);
  }
  clear() {
    for (const t18 of this.#te.keys()) this.#ee.unobserve(t18);
    this.#te.clear();
  }
  remove(t18, e2 = void 0) {
    const n2 = this.#te.get(t18);
    if (Array.isArray(n2)) {
      if (void 0 !== e2) {
        const t19 = n2.findIndex((t20) => t20.target === e2);
        t19 >= 0 && n2.splice(t19, 1);
      } else n2.length = 0;
      0 === n2.length && (this.#te.delete(t18), this.#ee.unobserve(t18));
    }
  }
  updateCache(t18) {
    const e2 = this.#te.get(t18);
    if (Array.isArray(e2)) {
      const n2 = globalThis.getComputedStyle(t18), o2 = StyleParse.pixels(t18.style.borderBottom) ?? StyleParse.pixels(n2.borderBottom) ?? 0, i2 = StyleParse.pixels(t18.style.borderLeft) ?? StyleParse.pixels(n2.borderLeft) ?? 0, r2 = StyleParse.pixels(t18.style.borderRight) ?? StyleParse.pixels(n2.borderRight) ?? 0, a2 = StyleParse.pixels(t18.style.borderTop) ?? StyleParse.pixels(n2.borderTop) ?? 0, s2 = StyleParse.pixels(t18.style.paddingBottom) ?? StyleParse.pixels(n2.paddingBottom) ?? 0, c2 = i2 + r2 + (StyleParse.pixels(t18.style.paddingLeft) ?? StyleParse.pixels(n2.paddingLeft) ?? 0) + (StyleParse.pixels(t18.style.paddingRight) ?? StyleParse.pixels(n2.paddingRight) ?? 0), l2 = a2 + o2 + (StyleParse.pixels(t18.style.paddingTop) ?? StyleParse.pixels(n2.paddingTop) ?? 0) + s2;
      for (const t19 of e2) t19.styles.additionalWidth = c2, t19.styles.additionalHeight = l2, ResizeObserverManager.#oe(t19, t19.contentWidth, t19.contentHeight);
    }
  }
  static #re(t18) {
    if ("function" == typeof t18?.resizeObserved) return this.#ne.resizeObserved;
    if ("function" == typeof t18?.setDimension) return this.#ne.setDimension;
    if ("function" == typeof t18?.setContentBounds) return this.#ne.setContentBounds;
    const e2 = typeof t18;
    if (null !== e2 && ("object" === e2 || "function" === e2)) {
      if (isWritableStore(t18.resizeObserved)) return this.#ne.storeObject;
      const e3 = t18?.stores;
      if ((isObject(e3) || "function" == typeof e3) && isWritableStore(e3.resizeObserved)) return this.#ne.storesObject;
    }
    return null !== e2 && "object" === e2 ? this.#ne.attribute : "function" === e2 ? this.#ne.function : this.#ne.none;
  }
  #ie(t18, e2) {
    if (null == e2) return false;
    const n2 = this.#te.get(t18);
    return !!Array.isArray(n2) && n2.findIndex((t19) => t19.target === e2) >= 0;
  }
  static #oe(t18, e2, n2) {
    const o2 = t18.styles;
    t18.contentWidth = e2, t18.contentHeight = n2;
    const i2 = Number.isFinite(e2) ? e2 + o2.additionalWidth : void 0, r2 = Number.isFinite(n2) ? n2 + o2.additionalHeight : void 0, a2 = t18.target;
    switch (t18.updateType) {
      case this.#ne.attribute:
        a2.contentWidth = e2, a2.contentHeight = n2, a2.offsetWidth = i2, a2.offsetHeight = r2;
        break;
      case this.#ne.function:
        a2?.(i2, r2, e2, n2);
        break;
      case this.#ne.resizeObserved:
        a2.resizeObserved?.(i2, r2, e2, n2);
        break;
      case this.#ne.setContentBounds:
        a2.setContentBounds?.(e2, n2);
        break;
      case this.#ne.setDimension:
        a2.setDimension?.(i2, r2);
        break;
      case this.#ne.storeObject:
        a2.resizeObserved.update((t19) => (t19.contentHeight = n2, t19.contentWidth = e2, t19.offsetHeight = r2, t19.offsetWidth = i2, t19));
        break;
      case this.#ne.storesObject:
        a2.stores.resizeObserved.update((t19) => (t19.contentHeight = n2, t19.contentWidth = e2, t19.offsetHeight = r2, t19.offsetWidth = i2, t19));
    }
  }
}
const resizeObserverActionManager = new ResizeObserverManager();
function resizeObserver(t18, e2) {
  return resizeObserverActionManager.add(t18, e2), { update: (n2) => {
    resizeObserverActionManager.remove(t18, e2), e2 = n2, resizeObserverActionManager.add(t18, e2);
  }, destroy: () => {
    resizeObserverActionManager.remove(t18, e2);
  } };
}
function applyStyles(t18, e2) {
  function n2() {
    if (isObject(e2)) for (const n3 of Object.keys(e2)) t18.style.setProperty(`${n3}`, e2[n3]);
  }
  return n2(), { update: (t19) => {
    e2 = t19, n2();
  } };
}
function dynamicAction(t18, { action: e2, data: n2 } = {}) {
  let o2;
  return "function" == typeof e2 && (o2 = e2(t18, n2)), { update: (i2) => {
    if (!isObject(i2)) return o2?.destroy?.(), e2 = void 0, void (n2 = void 0);
    const { action: r2, data: a2 } = i2;
    if ("function" != typeof r2) return void console.warn("dynamicAction.update warning: Aborting as 'action' is not a function.");
    const s2 = a2 !== n2;
    s2 && (n2 = a2), r2 !== e2 ? (o2?.destroy?.(), o2 = (e2 = r2)(t18, n2)) : s2 && o2?.update?.(n2);
  }, destroy: () => {
    o2?.destroy?.(), e2 = void 0, n2 = void 0, o2 = void 0;
  } };
}
resizeObserver.updateCache = function(t18) {
  resizeObserverActionManager.updateCache(t18);
};
class TJSDefaultTransition {
  static #Ut = {};
  static #ae = () => {
  };
  static get default() {
    return this.#ae;
  }
  static get options() {
    return this.#Ut;
  }
}
class AppShellContextInternal {
  #l;
  constructor() {
    this.#l = { elementContent: writable(void 0), elementRoot: writable(void 0) }, Object.freeze(this.#l), Object.seal(this);
  }
  get stores() {
    return this.#l;
  }
}
function localize(t18, e2) {
  const n2 = isObject(e2) ? globalThis.game.i18n.format(t18, e2) : globalThis.game.i18n.localize(t18);
  return void 0 !== n2 ? n2 : "";
}
function create_if_block$1C(t18) {
  let e2, n2;
  return { c() {
    e2 = element("span"), n2 = text(t18[3]), attr(e2, "class", "svelte-mobile-companion-a5e-038vch56tr3-acci"), toggle_class(e2, "has-icon", void 0 !== t18[4]);
  }, m(t19, o2) {
    insert(t19, e2, o2), append(e2, n2);
  }, p(t19, o2) {
    8 & o2 && set_data(n2, t19[3]), 16 & o2 && toggle_class(e2, "has-icon", void 0 !== t19[4]);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_fragment$2K(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2 = t18[3] && create_if_block$1C(t18);
  return { c() {
    e2 = element("a"), n2 = new HtmlTag(false), o2 = empty(), c2 && c2.c(), n2.a = o2, attr(e2, "class", i2 = "header-button " + t18[0].class + " svelte-mobile-companion-a5e-038vch56tr3-acci"), attr(e2, "aria-label", t18[3]), attr(e2, "tabindex", "0"), attr(e2, "role", "button"), toggle_class(e2, "keep-minimized", t18[2]);
  }, m(i3, l2) {
    insert(i3, e2, l2), n2.m(t18[4], e2), append(e2, o2), c2 && c2.m(e2, null), a2 || (s2 = [listen(e2, "click", stop_propagation(prevent_default(t18[5]))), listen(e2, "contextmenu", stop_propagation(prevent_default(t18[6]))), listen(e2, "keydown", t18[7]), listen(e2, "keyup", t18[8]), action_destroyer(r2 = applyStyles.call(null, e2, t18[1]))], a2 = true);
  }, p(t19, [o3]) {
    16 & o3 && n2.p(t19[4]), t19[3] ? c2 ? c2.p(t19, o3) : (c2 = create_if_block$1C(t19), c2.c(), c2.m(e2, null)) : c2 && (c2.d(1), c2 = null), 1 & o3 && i2 !== (i2 = "header-button " + t19[0].class + " svelte-mobile-companion-a5e-038vch56tr3-acci") && attr(e2, "class", i2), 8 & o3 && attr(e2, "aria-label", t19[3]), r2 && is_function(r2.update) && 2 & o3 && r2.update.call(null, t19[1]), 5 & o3 && toggle_class(e2, "keep-minimized", t19[2]);
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2), c2 && c2.d(), a2 = false, run_all(s2);
  } };
}
const s_REGEX_HTML = /^\s*<.*>$/;
function instance$2L(t18, e2, n2) {
  let o2, i2, r2, a2, s2, c2, { button: l2 } = e2;
  return t18.$$set = (t19) => {
    "button" in t19 && n2(0, l2 = t19.button);
  }, t18.$$.update = () => {
    1 & t18.$$.dirty && n2(9, o2 = isObject(l2) && "string" == typeof l2.title ? localize(l2.title) : ""), 513 & t18.$$.dirty && n2(4, i2 = isObject(l2) && "string" != typeof l2.icon ? void 0 : s_REGEX_HTML.test(l2.icon) ? l2.icon : `<i class="${l2.icon}" title="${o2}"></i>`), 1 & t18.$$.dirty && n2(3, r2 = isObject(l2) && "string" == typeof l2.label ? localize(l2.label) : void 0), 1 & t18.$$.dirty && n2(2, a2 = !(!isObject(l2) || "boolean" != typeof l2.keepMinimized) && l2.keepMinimized), 1 & t18.$$.dirty && (s2 = isObject(l2) && "string" == typeof l2.keyCode ? l2.keyCode : "Enter"), 1 & t18.$$.dirty && n2(1, c2 = isObject(l2) && isObject(l2.styles) ? l2.styles : void 0);
  }, [l2, c2, a2, r2, i2, function(t19) {
    const e3 = l2?.onPress ?? l2?.onclick;
    "function" == typeof e3 && (e3({ button: l2, event: t19 }), n2(0, l2));
  }, function(t19) {
    "function" === l2?.onContextMenu && (l2.onContextMenu({ button: l2, event: t19 }), n2(0, l2));
  }, function(t19) {
    t19.code === s2 && (t19.preventDefault(), t19.stopPropagation());
  }, function(t19) {
    if (t19.code === s2) {
      const e3 = l2.onPress ?? l2.onclick;
      "function" == typeof e3 && (e3({ button: l2, event: t19 }), n2(0, l2)), t19.preventDefault(), t19.stopPropagation();
    }
  }, o2];
}
class TJSHeaderButton extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2L, create_fragment$2K, safe_not_equal, { button: 0 });
  }
  get button() {
    return this.$$.ctx[0];
  }
  set button(t18) {
    this.$$set({ button: t18 }), flush();
  }
}
function get_each_context$O(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[31] = e2[n2], o2;
}
function get_each_context_1$2(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[31] = e2[n2], o2;
}
function create_if_block$1B(t18) {
  let e2, n2;
  return { c() {
    e2 = element("img"), attr(e2, "class", "tjs-app-icon keep-minimized svelte-mobile-companion-a5e-038vch56tr3-5lh4qo"), src_url_equal(e2.src, n2 = t18[6]) || attr(e2, "src", n2), attr(e2, "alt", "icon");
  }, m(t19, n3) {
    insert(t19, e2, n3);
  }, p(t19, o2) {
    64 & o2[0] && !src_url_equal(e2.src, n2 = t19[6]) && attr(e2, "src", n2);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_each_block_1$2(t18) {
  let e2, n2, o2;
  const i2 = [t18[31].props];
  var r2 = t18[31].class;
  function a2(t19, e3) {
    let n3 = {};
    for (let t20 = 0; t20 < i2.length; t20 += 1) n3 = assign(n3, i2[t20]);
    return void 0 !== e3 && 2 & e3[0] && (n3 = assign(n3, get_spread_update(i2, [get_spread_object(t19[31].props)]))), { props: n3 };
  }
  return r2 && (e2 = construct_svelte_component(r2, a2(t18))), { c() {
    e2 && create_component(e2.$$.fragment), n2 = empty();
  }, m(t19, i3) {
    e2 && mount_component(e2, t19, i3), insert(t19, n2, i3), o2 = true;
  }, p(t19, o3) {
    if (2 & o3[0] && r2 !== (r2 = t19[31].class)) {
      if (e2) {
        group_outros();
        const t20 = e2;
        transition_out(t20.$$.fragment, 1, 0, () => {
          destroy_component(t20, 1);
        }), check_outros();
      }
      r2 ? (e2 = construct_svelte_component(r2, a2(t19, o3)), create_component(e2.$$.fragment), transition_in(e2.$$.fragment, 1), mount_component(e2, n2.parentNode, n2)) : e2 = null;
    } else if (r2) {
      const n3 = 2 & o3[0] ? get_spread_update(i2, [get_spread_object(t19[31].props)]) : {};
      e2.$set(n3);
    }
  }, i(t19) {
    o2 || (e2 && transition_in(e2.$$.fragment, t19), o2 = true);
  }, o(t19) {
    e2 && transition_out(e2.$$.fragment, t19), o2 = false;
  }, d(t19) {
    t19 && detach(n2), e2 && destroy_component(e2, t19);
  } };
}
function create_each_block$O(t18) {
  let e2, n2, o2;
  const i2 = [t18[31].props];
  var r2 = t18[31].class;
  function a2(t19, e3) {
    let n3 = {};
    for (let t20 = 0; t20 < i2.length; t20 += 1) n3 = assign(n3, i2[t20]);
    return void 0 !== e3 && 4 & e3[0] && (n3 = assign(n3, get_spread_update(i2, [get_spread_object(t19[31].props)]))), { props: n3 };
  }
  return r2 && (e2 = construct_svelte_component(r2, a2(t18))), { c() {
    e2 && create_component(e2.$$.fragment), n2 = empty();
  }, m(t19, i3) {
    e2 && mount_component(e2, t19, i3), insert(t19, n2, i3), o2 = true;
  }, p(t19, o3) {
    if (4 & o3[0] && r2 !== (r2 = t19[31].class)) {
      if (e2) {
        group_outros();
        const t20 = e2;
        transition_out(t20.$$.fragment, 1, 0, () => {
          destroy_component(t20, 1);
        }), check_outros();
      }
      r2 ? (e2 = construct_svelte_component(r2, a2(t19, o3)), create_component(e2.$$.fragment), transition_in(e2.$$.fragment, 1), mount_component(e2, n2.parentNode, n2)) : e2 = null;
    } else if (r2) {
      const n3 = 4 & o3[0] ? get_spread_update(i2, [get_spread_object(t19[31].props)]) : {};
      e2.$set(n3);
    }
  }, i(t19) {
    o2 || (e2 && transition_in(e2.$$.fragment, t19), o2 = true);
  }, o(t19) {
    e2 && transition_out(e2.$$.fragment, t19), o2 = false;
  }, d(t19) {
    t19 && detach(n2), e2 && destroy_component(e2, t19);
  } };
}
function create_key_block$6(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, m2, f2 = localize(t18[7]) + "", h2 = "string" == typeof t18[6] && create_if_block$1B(t18), g2 = ensure_array_like(t18[1]), _ = [];
  for (let e3 = 0; e3 < g2.length; e3 += 1) _[e3] = create_each_block_1$2(get_each_context_1$2(t18, g2, e3));
  const $2 = (t19) => transition_out(_[t19], 1, 1, () => {
    _[t19] = null;
  });
  let b2 = ensure_array_like(t18[2]), y2 = [];
  for (let e3 = 0; e3 < b2.length; e3 += 1) y2[e3] = create_each_block$O(get_each_context$O(t18, b2, e3));
  const v2 = (t19) => transition_out(y2[t19], 1, 1, () => {
    y2[t19] = null;
  });
  return { c() {
    e2 = element("header"), h2 && h2.c(), n2 = space(), o2 = element("h4"), i2 = text(f2), r2 = space();
    for (let t19 = 0; t19 < _.length; t19 += 1) _[t19].c();
    a2 = space(), s2 = element("span"), c2 = space();
    for (let t19 = 0; t19 < y2.length; t19 += 1) y2[t19].c();
    attr(o2, "class", "window-title svelte-mobile-companion-a5e-038vch56tr3-5lh4qo"), set_style(o2, "display", t18[4]), attr(s2, "class", "tjs-window-header-spacer keep-minimized svelte-mobile-companion-a5e-038vch56tr3-5lh4qo"), attr(e2, "class", "window-header flexrow svelte-mobile-companion-a5e-038vch56tr3-5lh4qo");
  }, m(f3, g3) {
    insert(f3, e2, g3), h2 && h2.m(e2, null), append(e2, n2), append(e2, o2), append(o2, i2), append(e2, r2);
    for (let t19 = 0; t19 < _.length; t19 += 1) _[t19] && _[t19].m(e2, null);
    append(e2, a2), append(e2, s2), append(e2, c2);
    for (let t19 = 0; t19 < y2.length; t19 += 1) y2[t19] && y2[t19].m(e2, null);
    p2 = true, d2 || (m2 = [listen(e2, "pointerdown", t18[19]), action_destroyer(l2 = t18[0].call(null, e2, t18[3])), action_destroyer(u2 = t18[18].call(null, e2, t18[5]))], d2 = true);
  }, p(t19, r3) {
    if ("string" == typeof t19[6] ? h2 ? h2.p(t19, r3) : (h2 = create_if_block$1B(t19), h2.c(), h2.m(e2, n2)) : h2 && (h2.d(1), h2 = null), (!p2 || 128 & r3[0]) && f2 !== (f2 = localize(t19[7]) + "") && set_data(i2, f2), 16 & r3[0] && set_style(o2, "display", t19[4]), 2 & r3[0]) {
      let n3;
      for (g2 = ensure_array_like(t19[1]), n3 = 0; n3 < g2.length; n3 += 1) {
        const o3 = get_each_context_1$2(t19, g2, n3);
        _[n3] ? (_[n3].p(o3, r3), transition_in(_[n3], 1)) : (_[n3] = create_each_block_1$2(o3), _[n3].c(), transition_in(_[n3], 1), _[n3].m(e2, a2));
      }
      for (group_outros(), n3 = g2.length; n3 < _.length; n3 += 1) $2(n3);
      check_outros();
    }
    if (4 & r3[0]) {
      let n3;
      for (b2 = ensure_array_like(t19[2]), n3 = 0; n3 < b2.length; n3 += 1) {
        const o3 = get_each_context$O(t19, b2, n3);
        y2[n3] ? (y2[n3].p(o3, r3), transition_in(y2[n3], 1)) : (y2[n3] = create_each_block$O(o3), y2[n3].c(), transition_in(y2[n3], 1), y2[n3].m(e2, null));
      }
      for (group_outros(), n3 = b2.length; n3 < y2.length; n3 += 1) v2(n3);
      check_outros();
    }
    l2 && is_function(l2.update) && 8 & r3[0] && l2.update.call(null, t19[3]), u2 && is_function(u2.update) && 32 & r3[0] && u2.update.call(null, t19[5]);
  }, i(t19) {
    if (!p2) {
      for (let t20 = 0; t20 < g2.length; t20 += 1) transition_in(_[t20]);
      for (let t20 = 0; t20 < b2.length; t20 += 1) transition_in(y2[t20]);
      p2 = true;
    }
  }, o(t19) {
    _ = _.filter(Boolean);
    for (let t20 = 0; t20 < _.length; t20 += 1) transition_out(_[t20]);
    y2 = y2.filter(Boolean);
    for (let t20 = 0; t20 < y2.length; t20 += 1) transition_out(y2[t20]);
    p2 = false;
  }, d(t19) {
    t19 && detach(e2), h2 && h2.d(), destroy_each(_, t19), destroy_each(y2, t19), d2 = false, run_all(m2);
  } };
}
function create_fragment$2J(t18) {
  let e2, n2, o2 = t18[0], i2 = create_key_block$6(t18);
  return { c() {
    i2.c(), e2 = empty();
  }, m(t19, o3) {
    i2.m(t19, o3), insert(t19, e2, o3), n2 = true;
  }, p(t19, n3) {
    1 & n3[0] && safe_not_equal(o2, o2 = t19[0]) ? (group_outros(), transition_out(i2, 1, 1, noop$4), check_outros(), i2 = create_key_block$6(t19), i2.c(), transition_in(i2, 1), i2.m(e2.parentNode, e2)) : i2.p(t19, n3);
  }, i(t19) {
    n2 || (transition_in(i2), n2 = true);
  }, o(t19) {
    transition_out(i2), n2 = false;
  }, d(t19) {
    t19 && detach(e2), i2.d(t19);
  } };
}
function instance$2K(t18, e2, n2) {
  let o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, { draggable: m2 } = e2, { draggableOptions: f2 } = e2;
  const h2 = getContext("#external")?.application, { focusAuto: g2, focusKeep: _ } = h2.reactive.storeAppOptions;
  component_subscribe(t18, g2, (t19) => n2(26, i2 = t19)), component_subscribe(t18, _, (t19) => n2(25, o2 = t19));
  const { elementRoot: $2 } = getContext("#internal").stores;
  component_subscribe(t18, $2, (t19) => n2(27, r2 = t19));
  const b2 = h2.reactive.storeAppOptions.title;
  component_subscribe(t18, b2, (t19) => n2(7, d2 = t19));
  const y2 = h2.reactive.storeAppOptions.draggable;
  component_subscribe(t18, y2, (t19) => n2(24, l2 = t19));
  const v2 = h2.reactive.storeUIState.dragging, w2 = h2.reactive.storeUIState.headerButtons;
  component_subscribe(t18, w2, (t19) => n2(21, a2 = t19));
  const S2 = h2.reactive.storeAppOptions.headerIcon;
  component_subscribe(t18, S2, (t19) => n2(6, p2 = t19));
  const T2 = h2.reactive.storeAppOptions.headerNoTitleMinimized;
  component_subscribe(t18, T2, (t19) => n2(23, c2 = t19));
  const k2 = h2.reactive.storeAppOptions.minimizable;
  component_subscribe(t18, k2, (t19) => n2(5, u2 = t19));
  const x2 = h2.reactive.storeUIState.minimized;
  component_subscribe(t18, x2, (t19) => n2(22, s2 = t19));
  const E = Object.freeze(["tjs-app-icon", "tjs-window-header-spacer", "window-header", "window-title"]);
  let O2, A2, C2, M;
  return t18.$$set = (t19) => {
    "draggable" in t19 && n2(0, m2 = t19.draggable), "draggableOptions" in t19 && n2(20, f2 = t19.draggableOptions);
  }, t18.$$.update = () => {
    if (1 & t18.$$.dirty[0] && n2(0, m2 = "function" == typeof m2 ? m2 : draggable), 17825792 & t18.$$.dirty[0] && n2(3, O2 = Object.assign({}, { tween: true, tweenOptions: { duration: 0.06, ease: "cubicOut" } }, isObject(f2) ? f2 : {}, { position: h2.position, enabled: l2, storeDragging: v2, hasTargetClassList: E })), 12582912 & t18.$$.dirty[0] && n2(4, A2 = c2 && s2 ? "none" : null), 2097158 & t18.$$.dirty[0]) {
      n2(1, C2 = []), n2(2, M = []);
      for (const t19 of a2) {
        ("boolean" == typeof t19?.alignLeft && t19?.alignLeft ? C2 : M).push(TJSSvelte.config.isConfigEmbed(t19?.svelte) ? { ...t19.svelte } : { class: TJSHeaderButton, props: { button: t19 } });
      }
    }
  }, [m2, C2, M, O2, A2, u2, p2, d2, g2, _, $2, b2, y2, w2, S2, T2, k2, x2, function(t19, e3) {
    const n3 = (t20) => {
      (t20.target.classList.contains("window-title") || t20.target.classList.contains("window-header") || t20.target.classList.contains("keep-minimized")) && h2._onToggleMinimize(t20);
    };
    function o3() {
      t19.addEventListener("dblclick", n3);
    }
    function i3() {
      t19.removeEventListener("dblclick", n3);
    }
    return e3 && o3(), { update: (t20) => {
      t20 ? o3() : i3();
    }, destroy: () => i3() };
  }, function(t19) {
    const e3 = r2;
    if (h2.position.animate.cancel(), i2 && A11yHelper.isFocusTarget(e3) && e3?.isConnected) if (o2) {
      const n3 = h2.reactive.activeWindow;
      A11yHelper.isFocusTarget(n3.document.activeElement) && !e3.contains(n3.document.activeElement) ? e3.focus() : t19.preventDefault();
    } else e3.focus();
  }, f2, a2, s2, c2, l2];
}
class TJSApplicationHeader extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2K, create_fragment$2J, safe_not_equal, { draggable: 0, draggableOptions: 20 }, null, [-1, -1]);
  }
}
class ResizeHandleTransform {
  static #se = new Mat4();
  static #ce = new Vec3();
  static #le = new Vec3();
  static #ue = new Vec3();
  static #pe = new Vec3();
  static #de = new Vec3();
  static computeDelta(t18, e2, n2, o2, i2) {
    return Mat4.invert(this.#se, t18), this.#pe[0] = e2, this.#pe[1] = n2, this.#de[0] = o2, this.#de[1] = i2, Vec3.transformMat4(this.#le, this.#pe, this.#se), Vec3.transformMat4(this.#ue, this.#de, this.#se), this.#ce[0] = this.#ue[0] - this.#le[0], this.#ce[1] = this.#ue[1] - this.#le[1], this.#ce;
  }
}
function create_fragment$2I(t18) {
  let e2, n2, o2, i2;
  return { c() {
    e2 = element("div"), e2.innerHTML = '<i class="fas fa-arrows-alt-h svelte-mobile-companion-a5e-038vch56tr3-gtiiil"></i>', attr(e2, "class", "window-resizable-handle svelte-mobile-companion-a5e-038vch56tr3-gtiiil");
  }, m(r2, a2) {
    insert(r2, e2, a2), t18[11](e2), o2 || (i2 = [listen(e2, "pointerdown", t18[6]), action_destroyer(n2 = t18[7].call(null, e2, { active: t18[1], storeResizing: t18[5] }))], o2 = true);
  }, p(t19, [e3]) {
    n2 && is_function(n2.update) && 2 & e3 && n2.update.call(null, { active: t19[1], storeResizing: t19[5] });
  }, i: noop$4, o: noop$4, d(n3) {
    n3 && detach(e2), t18[11](null), o2 = false, run_all(i2);
  } };
}
function instance$2J(t18, e2, n2) {
  let o2, i2, r2, { isResizable: a2 = false } = e2;
  const s2 = getContext("#external")?.application, c2 = getContext("#internal").stores.elementRoot;
  component_subscribe(t18, c2, (t19) => n2(9, o2 = t19));
  const l2 = s2.reactive.storeAppOptions.resizable;
  component_subscribe(t18, l2, (t19) => n2(1, r2 = t19));
  const u2 = s2.reactive.storeUIState.minimized;
  component_subscribe(t18, u2, (t19) => n2(10, i2 = t19));
  const p2 = s2.reactive.storeUIState.resizing;
  let d2;
  return t18.$$set = (t19) => {
    "isResizable" in t19 && n2(8, a2 = t19.isResizable);
  }, t18.$$.update = () => {
    if (1793 & t18.$$.dirty && d2) {
      n2(0, d2.style.display = a2 && !i2 ? "block" : "none", d2);
      o2 && o2.classList[a2 ? "add" : "remove"]("resizable");
    }
  }, [d2, r2, c2, l2, u2, p2, function() {
    s2.position.animate.cancel();
  }, function(t19, { active: e3 = true, storeResizing: i3 } = {}) {
    let r3 = null, c3 = false, l3 = 0, u3 = 0;
    const p3 = { resizeDown: ["pointerdown", (e4) => function(e5) {
      e5.preventDefault(), c3 = false, r3 = s2.position.get(), "auto" === r3.height && (r3.height = o2.clientHeight);
      "auto" === r3.width && (r3.width = o2.clientWidth);
      l3 = e5.clientX, u3 = e5.clientY, t19.addEventListener(...p3.resizeMove), t19.addEventListener(...p3.resizeUp), t19.setPointerCapture(e5.pointerId);
    }(e4), false], resizeMove: ["pointermove", (t20) => function(t21) {
      t21.preventDefault(), c3 || "function" != typeof i3?.set || (c3 = true, i3.set(true));
      const e4 = ResizeHandleTransform.computeDelta(s2.position.transform.mat4, l3, u3, t21.clientX, t21.clientY);
      s2.position.set({ width: r3.width + e4[0], height: r3.height + e4[1] });
    }(t20), false], resizeUp: ["pointerup", (e4) => function(e5) {
      c3 = false, "function" == typeof i3?.set && i3.set(false);
      e5.preventDefault(), t19.removeEventListener(...p3.resizeMove), t19.removeEventListener(...p3.resizeUp), s2?._onResize?.(e5);
    }(e4), false] };
    function d3() {
      t19.addEventListener(...p3.resizeDown), n2(8, a2 = true), t19.style.display = "block";
    }
    function m2() {
      "function" == typeof i3?.set && i3.set(false), t19.removeEventListener(...p3.resizeDown), t19.removeEventListener(...p3.resizeMove), t19.removeEventListener(...p3.resizeUp), t19.style.display = "none", n2(8, a2 = false);
    }
    return e3 ? d3() : t19.style.display = "none", { update: ({ active: t20 }) => {
      t20 ? d3() : m2();
    }, destroy: () => m2() };
  }, a2, o2, i2, function(t19) {
    binding_callbacks[t19 ? "unshift" : "push"](() => {
      d2 = t19, n2(0, d2), n2(8, a2), n2(10, i2), n2(9, o2);
    });
  }];
}
class ResizableHandle extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2J, create_fragment$2I, safe_not_equal, { isResizable: 8 });
  }
}
function create_fragment$2H(t18) {
  let e2, n2, o2;
  return { c() {
    e2 = element("div"), attr(e2, "class", "tjs-focus-wrap svelte-mobile-companion-a5e-038vch56tr3-kjcljd"), attr(e2, "tabindex", "0");
  }, m(i2, r2) {
    insert(i2, e2, r2), t18[4](e2), n2 || (o2 = listen(e2, "focus", t18[1]), n2 = true);
  }, p: noop$4, i: noop$4, o: noop$4, d(i2) {
    i2 && detach(e2), t18[4](null), n2 = false, o2();
  } };
}
function instance$2I(t18, e2, n2) {
  let o2, i2, { elementRoot: r2 } = e2, { enabled: a2 = true } = e2;
  return t18.$$set = (t19) => {
    "elementRoot" in t19 && n2(2, r2 = t19.elementRoot), "enabled" in t19 && n2(3, a2 = t19.enabled);
  }, t18.$$.update = () => {
    1 & t18.$$.dirty && i2 && (o2 = /* @__PURE__ */ new Set([i2]));
  }, [i2, function() {
    if (a2 && A11yHelper.isFocusTarget(r2)) {
      const t19 = A11yHelper.getFirstFocusableElement(r2, o2);
      A11yHelper.isFocusTarget(t19) && t19 !== i2 ? t19.focus() : r2.focus();
    }
  }, r2, a2, function(t19) {
    binding_callbacks[t19 ? "unshift" : "push"](() => {
      i2 = t19, n2(0, i2);
    });
  }];
}
class TJSFocusWrap extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2I, create_fragment$2H, safe_not_equal, { elementRoot: 2, enabled: 3 });
  }
}
function create_else_block$f(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, m2, f2, h2, g2, _;
  n2 = new TJSApplicationHeader({ props: { draggable: t18[6], draggableOptions: t18[7] } });
  const $2 = t18[37].default, b2 = create_slot($2, t18, t18[36], null);
  return s2 = new ResizableHandle({}), l2 = new TJSFocusWrap({ props: { elementRoot: t18[1], enabled: t18[11] } }), { c() {
    e2 = element("div"), create_component(n2.$$.fragment), o2 = space(), i2 = element("section"), b2 && b2.c(), a2 = space(), create_component(s2.$$.fragment), c2 = space(), create_component(l2.$$.fragment), attr(i2, "class", "window-content svelte-mobile-companion-a5e-038vch56tr3-90z1oq"), attr(i2, "tabindex", "-1"), attr(e2, "id", u2 = t18[10].id), attr(e2, "class", p2 = "app window-app " + t18[10].options.classes.join(" ") + " svelte-mobile-companion-a5e-038vch56tr3-90z1oq"), attr(e2, "data-appid", d2 = t18[10].appId), attr(e2, "role", "application"), attr(e2, "tabindex", "-1");
  }, m(u3, p3) {
    insert(u3, e2, p3), mount_component(n2, e2, null), append(e2, o2), append(e2, i2), b2 && b2.m(i2, null), t18[40](i2), append(e2, a2), mount_component(s2, e2, null), append(e2, c2), mount_component(l2, e2, null), t18[41](e2), h2 = true, g2 || (_ = [listen(i2, "pointerdown", t18[22]), action_destroyer(r2 = applyStyles.call(null, i2, t18[9])), action_destroyer(t18[18].call(null, i2, t18[23])), listen(e2, "close:popup", stop_propagation(prevent_default(t18[19]))), listen(e2, "keydown", t18[20]), listen(e2, "pointerdown", t18[21], true), action_destroyer(m2 = applyStyles.call(null, e2, t18[8])), action_destroyer(f2 = dynamicAction.call(null, e2, t18[12]))], g2 = true);
  }, p(t19, o3) {
    const i3 = {};
    64 & o3[0] && (i3.draggable = t19[6]), 128 & o3[0] && (i3.draggableOptions = t19[7]), n2.$set(i3), b2 && b2.p && (!h2 || 32 & o3[1]) && update_slot_base(b2, $2, t19, t19[36], h2 ? get_slot_changes($2, t19[36], o3, null) : get_all_dirty_from_scope(t19[36]), null), r2 && is_function(r2.update) && 512 & o3[0] && r2.update.call(null, t19[9]);
    const a3 = {};
    2 & o3[0] && (a3.elementRoot = t19[1]), 2048 & o3[0] && (a3.enabled = t19[11]), l2.$set(a3), (!h2 || 1024 & o3[0] && u2 !== (u2 = t19[10].id)) && attr(e2, "id", u2), (!h2 || 1024 & o3[0] && p2 !== (p2 = "app window-app " + t19[10].options.classes.join(" ") + " svelte-mobile-companion-a5e-038vch56tr3-90z1oq")) && attr(e2, "class", p2), (!h2 || 1024 & o3[0] && d2 !== (d2 = t19[10].appId)) && attr(e2, "data-appid", d2), m2 && is_function(m2.update) && 256 & o3[0] && m2.update.call(null, t19[8]), f2 && is_function(f2.update) && 4096 & o3[0] && f2.update.call(null, t19[12]);
  }, i(t19) {
    h2 || (transition_in(n2.$$.fragment, t19), transition_in(b2, t19), transition_in(s2.$$.fragment, t19), transition_in(l2.$$.fragment, t19), h2 = true);
  }, o(t19) {
    transition_out(n2.$$.fragment, t19), transition_out(b2, t19), transition_out(s2.$$.fragment, t19), transition_out(l2.$$.fragment, t19), h2 = false;
  }, d(o3) {
    o3 && detach(e2), destroy_component(n2), b2 && b2.d(o3), t18[40](null), destroy_component(s2), destroy_component(l2), t18[41](null), g2 = false, run_all(_);
  } };
}
function create_if_block$1A(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, m2, f2, h2, g2, _, $2, b2;
  n2 = new TJSApplicationHeader({ props: { draggable: t18[6], draggableOptions: t18[7] } });
  const y2 = t18[37].default, v2 = create_slot(y2, t18, t18[36], null);
  return s2 = new ResizableHandle({}), l2 = new TJSFocusWrap({ props: { elementRoot: t18[1] } }), { c() {
    e2 = element("div"), create_component(n2.$$.fragment), o2 = space(), i2 = element("section"), v2 && v2.c(), a2 = space(), create_component(s2.$$.fragment), c2 = space(), create_component(l2.$$.fragment), attr(i2, "class", "window-content svelte-mobile-companion-a5e-038vch56tr3-90z1oq"), attr(i2, "tabindex", "-1"), attr(e2, "id", u2 = t18[10].id), attr(e2, "class", p2 = "app window-app " + t18[10].options.classes.join(" ") + " svelte-mobile-companion-a5e-038vch56tr3-90z1oq"), attr(e2, "data-appid", d2 = t18[10].appId), attr(e2, "role", "application"), attr(e2, "tabindex", "-1");
  }, m(u3, p3) {
    insert(u3, e2, p3), mount_component(n2, e2, null), append(e2, o2), append(e2, i2), v2 && v2.m(i2, null), t18[38](i2), append(e2, a2), mount_component(s2, e2, null), append(e2, c2), mount_component(l2, e2, null), t18[39](e2), _ = true, $2 || (b2 = [listen(i2, "pointerdown", t18[22]), action_destroyer(r2 = applyStyles.call(null, i2, t18[9])), action_destroyer(t18[18].call(null, i2, t18[23])), listen(e2, "close:popup", stop_propagation(prevent_default(t18[19]))), listen(e2, "keydown", t18[20]), listen(e2, "pointerdown", t18[21], true), action_destroyer(m2 = applyStyles.call(null, e2, t18[8])), action_destroyer(f2 = dynamicAction.call(null, e2, t18[12]))], $2 = true);
  }, p(o3, i3) {
    t18 = o3;
    const a3 = {};
    64 & i3[0] && (a3.draggable = t18[6]), 128 & i3[0] && (a3.draggableOptions = t18[7]), n2.$set(a3), v2 && v2.p && (!_ || 32 & i3[1]) && update_slot_base(v2, y2, t18, t18[36], _ ? get_slot_changes(y2, t18[36], i3, null) : get_all_dirty_from_scope(t18[36]), null), r2 && is_function(r2.update) && 512 & i3[0] && r2.update.call(null, t18[9]);
    const s3 = {};
    2 & i3[0] && (s3.elementRoot = t18[1]), l2.$set(s3), (!_ || 1024 & i3[0] && u2 !== (u2 = t18[10].id)) && attr(e2, "id", u2), (!_ || 1024 & i3[0] && p2 !== (p2 = "app window-app " + t18[10].options.classes.join(" ") + " svelte-mobile-companion-a5e-038vch56tr3-90z1oq")) && attr(e2, "class", p2), (!_ || 1024 & i3[0] && d2 !== (d2 = t18[10].appId)) && attr(e2, "data-appid", d2), m2 && is_function(m2.update) && 256 & i3[0] && m2.update.call(null, t18[8]), f2 && is_function(f2.update) && 4096 & i3[0] && f2.update.call(null, t18[12]);
  }, i(o3) {
    _ || (transition_in(n2.$$.fragment, o3), transition_in(v2, o3), transition_in(s2.$$.fragment, o3), transition_in(l2.$$.fragment, o3), add_render_callback(() => {
      _ && (g2 && g2.end(1), h2 = create_in_transition(e2, t18[2], t18[4]), h2.start());
    }), _ = true);
  }, o(o3) {
    transition_out(n2.$$.fragment, o3), transition_out(v2, o3), transition_out(s2.$$.fragment, o3), transition_out(l2.$$.fragment, o3), h2 && h2.invalidate(), g2 = create_out_transition(e2, t18[3], t18[5]), _ = false;
  }, d(o3) {
    o3 && detach(e2), destroy_component(n2), v2 && v2.d(o3), t18[38](null), destroy_component(s2), destroy_component(l2), t18[39](null), o3 && g2 && g2.end(), $2 = false, run_all(b2);
  } };
}
function create_fragment$2G(t18) {
  let e2, n2, o2, i2;
  const r2 = [create_if_block$1A, create_else_block$f], a2 = [];
  function s2(t19, e3) {
    return t19[2] !== TJSDefaultTransition.default || t19[3] !== TJSDefaultTransition.default ? 0 : 1;
  }
  return e2 = s2(t18), n2 = a2[e2] = r2[e2](t18), { c() {
    n2.c(), o2 = empty();
  }, m(t19, n3) {
    a2[e2].m(t19, n3), insert(t19, o2, n3), i2 = true;
  }, p(t19, i3) {
    let c2 = e2;
    e2 = s2(t19), e2 === c2 ? a2[e2].p(t19, i3) : (group_outros(), transition_out(a2[c2], 1, 1, () => {
      a2[c2] = null;
    }), check_outros(), n2 = a2[e2], n2 ? n2.p(t19, i3) : (n2 = a2[e2] = r2[e2](t19), n2.c()), transition_in(n2, 1), n2.m(o2.parentNode, o2));
  }, i(t19) {
    i2 || (transition_in(n2), i2 = true);
  }, o(t19) {
    transition_out(n2), i2 = false;
  }, d(t19) {
    t19 && detach(o2), a2[e2].d(t19);
  } };
}
function instance$2H(t18, e2, n2) {
  let o2, i2, r2, a2, s2, c2, { $$slots: l2 = {}, $$scope: u2 } = e2, { elementContent: p2 } = e2, { elementRoot: d2 } = e2, { draggable: m2 } = e2, { draggableOptions: f2 } = e2, { stylesApp: h2 } = e2, { stylesContent: g2 } = e2;
  const _ = getContext("#external")?.application, { focusAuto: $2, focusKeep: b2, focusTrap: y2 } = _.reactive.storeAppOptions;
  component_subscribe(t18, $2, (t19) => n2(32, r2 = t19)), component_subscribe(t18, b2, (t19) => n2(42, i2 = t19)), component_subscribe(t18, y2, (t19) => n2(34, s2 = t19));
  const { minimized: v2 } = _.reactive.storeUIState;
  component_subscribe(t18, v2, (t19) => n2(33, a2 = t19));
  const { resizeObservable: w2 } = _.position.stores;
  component_subscribe(t18, w2, (t19) => n2(35, c2 = t19));
  let { appOffsetHeight: S2 = false } = e2, { appOffsetWidth: T2 = false } = e2;
  const k2 = !!S2 || !!T2;
  let { contentOffsetHeight: x2 = false } = e2, { contentOffsetWidth: E = false } = e2;
  const O2 = x2 || E ? resizeObserver : () => null, A2 = new AppShellContextInternal(), C2 = { ignoreClasses: ["tjs-focus-wrap"] };
  let M;
  setContext("#internal", A2);
  let I2, { transition: N2 = TJSDefaultTransition.default } = e2, { inTransition: P2 = TJSDefaultTransition.default } = e2, { outTransition: D2 = TJSDefaultTransition.default } = e2, { transitionOptions: j2 } = e2, { inTransitionOptions: F2 = TJSDefaultTransition.options } = e2, { outTransitionOptions: L2 = TJSDefaultTransition.options } = e2, R = TJSDefaultTransition.default;
  function z2(t19, e3, o3, i3) {
    _.position.stores.resizeObserved.update((n3) => (n3.contentWidth = o3, n3.contentHeight = i3, n3.offsetWidth = t19, n3.offsetHeight = e3, n3)), n2(24, S2 = e3), n2(25, T2 = t19);
  }
  return onMount(() => d2.focus()), t18.$$set = (t19) => {
    "elementContent" in t19 && n2(0, p2 = t19.elementContent), "elementRoot" in t19 && n2(1, d2 = t19.elementRoot), "draggable" in t19 && n2(6, m2 = t19.draggable), "draggableOptions" in t19 && n2(7, f2 = t19.draggableOptions), "stylesApp" in t19 && n2(8, h2 = t19.stylesApp), "stylesContent" in t19 && n2(9, g2 = t19.stylesContent), "appOffsetHeight" in t19 && n2(24, S2 = t19.appOffsetHeight), "appOffsetWidth" in t19 && n2(25, T2 = t19.appOffsetWidth), "contentOffsetHeight" in t19 && n2(26, x2 = t19.contentOffsetHeight), "contentOffsetWidth" in t19 && n2(27, E = t19.contentOffsetWidth), "transition" in t19 && n2(28, N2 = t19.transition), "inTransition" in t19 && n2(2, P2 = t19.inTransition), "outTransition" in t19 && n2(3, D2 = t19.outTransition), "transitionOptions" in t19 && n2(29, j2 = t19.transitionOptions), "inTransitionOptions" in t19 && n2(4, F2 = t19.inTransitionOptions), "outTransitionOptions" in t19 && n2(5, L2 = t19.outTransitionOptions), "$$scope" in t19 && n2(36, u2 = t19.$$scope);
  }, t18.$$.update = () => {
    if (16 & t18.$$.dirty[1] && n2(12, o2 = k2 || c2 ? { action: resizeObserver, data: z2 } : void 0), 1 & t18.$$.dirty[0] && null != p2 && getContext("#internal").stores.elementContent.set(p2), 2 & t18.$$.dirty[0] && null != d2 && getContext("#internal").stores.elementRoot.set(d2), 14 & t18.$$.dirty[1] && n2(11, M = r2 && s2 && !a2), 1342177280 & t18.$$.dirty[0] && R !== N2) {
      const t19 = "function" == typeof N2 ? N2 : TJSDefaultTransition.default;
      n2(2, P2 = t19), n2(3, D2 = t19), n2(30, R = t19);
    }
    if (536870912 & t18.$$.dirty[0] | 1 & t18.$$.dirty[1] && I2 !== j2) {
      const t19 = j2 !== TJSDefaultTransition.options && isObject(j2) ? j2 : TJSDefaultTransition.options;
      n2(4, F2 = t19), n2(5, L2 = t19), n2(31, I2 = t19);
    }
    if (4 & t18.$$.dirty[0] && "function" != typeof P2 && n2(2, P2 = TJSDefaultTransition.default), 1032 & t18.$$.dirty[0]) {
      "function" != typeof D2 && n2(3, D2 = TJSDefaultTransition.default);
      const t19 = _?.options?.defaultCloseAnimation;
      "boolean" == typeof t19 && t19 && D2 !== TJSDefaultTransition.default && n2(10, _.options.defaultCloseAnimation = false, _);
    }
    16 & t18.$$.dirty[0] && (isObject(F2) || n2(4, F2 = TJSDefaultTransition.options)), 32 & t18.$$.dirty[0] && (isObject(L2) || n2(5, L2 = TJSDefaultTransition.options));
  }, [p2, d2, P2, D2, F2, L2, m2, f2, h2, g2, _, M, o2, $2, b2, y2, v2, w2, O2, function(t19) {
    if (!r2) return;
    const e3 = t19?.detail?.target;
    if (!A11yHelper.isFocusTarget(e3)) return;
    if (A11yHelper.isFocusable(e3)) return;
    const n3 = d2.contains(e3);
    e3 === d2 ? d2.focus() : e3 === p2 ? p2.focus() : n3 && (p2.contains(e3) ? p2.focus() : d2.focus());
  }, function(t19) {
    if (t19.target !== d2 && t19.target !== p2 || !KeyboardManager || !KeyboardManager?._getMatchingActions?.(KeyboardManager?.getKeyboardEventContext?.(t19))?.length) {
      if (M && t19.shiftKey && "Tab" === t19.code) {
        const e3 = A11yHelper.getFocusableElements(d2, C2), n3 = e3.length > 0 ? e3[0] : void 0, o3 = e3.length > 0 ? e3[e3.length - 1] : void 0, i3 = _.reactive.activeWindow;
        d2 !== i3.document.activeElement && n3 !== i3.document.activeElement || (A11yHelper.isFocusTarget(o3) && n3 !== o3 && o3.focus(), t19.preventDefault(), t19.stopPropagation());
      }
      "boolean" == typeof _?.options?.popOut && _.options.popOut && _ !== globalThis.ui?.activeWindow && _.bringToTop.call(_);
    } else t19.target?.blur();
  }, function() {
    "boolean" == typeof _?.options?.popOut && _.options.popOut && _ !== globalThis.ui?.activeWindow && _.bringToTop.call(_);
  }, function(t19) {
    if (!A11yHelper.isFocusable(t19.target) && r2) if (i2) {
      const e3 = _.reactive.activeWindow;
      !d2.contains(e3.document.activeElement) ? p2.focus() : t19.preventDefault();
    } else p2.focus();
  }, function(t19, e3) {
    n2(27, E = t19), n2(26, x2 = e3);
  }, S2, T2, x2, E, N2, j2, R, I2, r2, a2, s2, c2, u2, l2, function(t19) {
    binding_callbacks[t19 ? "unshift" : "push"](() => {
      p2 = t19, n2(0, p2);
    });
  }, function(t19) {
    binding_callbacks[t19 ? "unshift" : "push"](() => {
      d2 = t19, n2(1, d2);
    });
  }, function(t19) {
    binding_callbacks[t19 ? "unshift" : "push"](() => {
      p2 = t19, n2(0, p2);
    });
  }, function(t19) {
    binding_callbacks[t19 ? "unshift" : "push"](() => {
      d2 = t19, n2(1, d2);
    });
  }];
}
class ApplicationShell extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2H, create_fragment$2G, safe_not_equal, { elementContent: 0, elementRoot: 1, draggable: 6, draggableOptions: 7, stylesApp: 8, stylesContent: 9, appOffsetHeight: 24, appOffsetWidth: 25, contentOffsetHeight: 26, contentOffsetWidth: 27, transition: 28, inTransition: 2, outTransition: 3, transitionOptions: 29, inTransitionOptions: 4, outTransitionOptions: 5 }, null, [-1, -1]);
  }
  get elementContent() {
    return this.$$.ctx[0];
  }
  set elementContent(t18) {
    this.$$set({ elementContent: t18 }), flush();
  }
  get elementRoot() {
    return this.$$.ctx[1];
  }
  set elementRoot(t18) {
    this.$$set({ elementRoot: t18 }), flush();
  }
  get draggable() {
    return this.$$.ctx[6];
  }
  set draggable(t18) {
    this.$$set({ draggable: t18 }), flush();
  }
  get draggableOptions() {
    return this.$$.ctx[7];
  }
  set draggableOptions(t18) {
    this.$$set({ draggableOptions: t18 }), flush();
  }
  get stylesApp() {
    return this.$$.ctx[8];
  }
  set stylesApp(t18) {
    this.$$set({ stylesApp: t18 }), flush();
  }
  get stylesContent() {
    return this.$$.ctx[9];
  }
  set stylesContent(t18) {
    this.$$set({ stylesContent: t18 }), flush();
  }
  get appOffsetHeight() {
    return this.$$.ctx[24];
  }
  set appOffsetHeight(t18) {
    this.$$set({ appOffsetHeight: t18 }), flush();
  }
  get appOffsetWidth() {
    return this.$$.ctx[25];
  }
  set appOffsetWidth(t18) {
    this.$$set({ appOffsetWidth: t18 }), flush();
  }
  get contentOffsetHeight() {
    return this.$$.ctx[26];
  }
  set contentOffsetHeight(t18) {
    this.$$set({ contentOffsetHeight: t18 }), flush();
  }
  get contentOffsetWidth() {
    return this.$$.ctx[27];
  }
  set contentOffsetWidth(t18) {
    this.$$set({ contentOffsetWidth: t18 }), flush();
  }
  get transition() {
    return this.$$.ctx[28];
  }
  set transition(t18) {
    this.$$set({ transition: t18 }), flush();
  }
  get inTransition() {
    return this.$$.ctx[2];
  }
  set inTransition(t18) {
    this.$$set({ inTransition: t18 }), flush();
  }
  get outTransition() {
    return this.$$.ctx[3];
  }
  set outTransition(t18) {
    this.$$set({ outTransition: t18 }), flush();
  }
  get transitionOptions() {
    return this.$$.ctx[29];
  }
  set transitionOptions(t18) {
    this.$$set({ transitionOptions: t18 }), flush();
  }
  get inTransitionOptions() {
    return this.$$.ctx[4];
  }
  set inTransitionOptions(t18) {
    this.$$set({ inTransitionOptions: t18 }), flush();
  }
  get outTransitionOptions() {
    return this.$$.ctx[5];
  }
  set outTransitionOptions(t18) {
    this.$$set({ outTransitionOptions: t18 }), flush();
  }
}
cssVariables.setProperties({ "--tjs-default-text-shadow-focus-hover": "0 0 8px var(--color-shadow-primary)", "--tjs-app-background": `url("${globalThis.foundry.utils.getRoute("/ui/denim075.png")}")` }, false);
class ApplicationState {
  #me;
  #fe;
  #Tt = /* @__PURE__ */ new Map();
  constructor(t18) {
    this.#me = t18, Object.seal(this);
  }
  clear() {
    this.#Tt.clear();
  }
  current(t18 = {}) {
    return Object.assign(t18, { position: this.#me?.position?.get(), beforeMinimized: this.#me?.position?.state.get({ name: "#beforeMinimized" }), options: this.#me?.reactive?.toJSON(), ui: { minimized: this.#me?.reactive?.minimized } });
  }
  get({ name: t18 }) {
    if ("string" != typeof t18) throw new TypeError("[SvelteApp.state.get] error: 'name' is not a string.");
    return this.#Tt.get(t18);
  }
  keys() {
    return this.#Tt.keys();
  }
  remove({ name: t18 }) {
    if ("string" != typeof t18) throw new TypeError("[SvelteApp.state.remove] error: 'name' is not a string.");
    const e2 = this.#Tt.get(t18);
    return this.#Tt.delete(t18), e2;
  }
  restore({ name: t18, remove: e2 = false, animateTo: n2 = false, duration: o2 = 0.1, ease: i2 = "linear" }) {
    if ("string" != typeof t18) throw new TypeError("[SvelteApp.state.restore] error: 'name' is not a string.");
    const r2 = this.#Tt.get(t18);
    return r2 && (e2 && this.#Tt.delete(t18), n2 && t18 !== this.#fe && (this.#fe = t18, this.#he(r2, { animateTo: n2, async: true, duration: o2, ease: i2 }).then(() => {
      t18 === this.#fe && (this.#fe = void 0);
    }))), r2;
  }
  save({ name: t18, ...e2 }) {
    if ("string" != typeof t18) throw new TypeError("[SvelteApp.state.save] error: 'name' is not a string.");
    const n2 = this.current(e2);
    return this.#Tt.set(t18, n2), n2;
  }
  set(t18, e2 = {}) {
    this.#he(t18, { ...e2, async: false });
  }
  #he(t18, { async: e2 = false, animateTo: n2 = false, duration: o2 = 0.1, ease: i2 = "linear" } = {}) {
    if (!isObject(t18)) throw new TypeError("[SvelteApp.state.set] error: 'data' is not an object.");
    const r2 = this.#me;
    if (!isObject(t18?.position)) return void console.warn("[SvelteApp.state.set] warning: 'data.position' is not an object.");
    const a2 = r2.rendered;
    if (n2) {
      if (!a2) return void console.warn("[SvelteApp.state.set] warning: application is not rendered and 'animateTo' is true.");
      if (t18.position.transformOrigin !== r2.position.transformOrigin && (r2.position.transformOrigin = t18.position.transformOrigin), isObject(t18?.ui)) {
        const e3 = "boolean" == typeof t18.ui?.minimized && t18.ui.minimized;
        r2?.reactive?.minimized && !e3 && r2.maximize({ animate: false, duration: 0 });
      }
      const n3 = r2.position.animate.to(t18.position, { duration: o2, ease: i2, strategy: "cancelAll" }).finished.then(({ cancelled: e3 }) => {
        if (!e3) {
          if (isObject(t18?.options) && r2?.reactive.mergeOptions(t18.options), isObject(t18?.ui)) {
            const e4 = "boolean" == typeof t18.ui?.minimized && t18.ui.minimized;
            !r2?.reactive?.minimized && e4 && r2.minimize({ animate: false, duration: 0 });
          }
          isObject(t18?.beforeMinimized) && r2.position.state.set({ name: "#beforeMinimized", ...t18.beforeMinimized });
        }
      });
      if (e2) return n3;
    } else if (a2) {
      if (isObject(t18?.options) && r2?.reactive.mergeOptions(t18.options), isObject(t18?.ui)) {
        const e3 = "boolean" == typeof t18.ui?.minimized && t18.ui.minimized;
        r2?.reactive?.minimized && !e3 ? r2.maximize({ animate: false, duration: 0 }) : !r2?.reactive?.minimized && e3 && r2.minimize({ animate: false, duration: o2 });
      }
      isObject(t18?.beforeMinimized) && r2.position.state.set({ name: "#beforeMinimized", ...t18.beforeMinimized }), r2.position.set(t18.position);
    } else {
      let e3 = t18.position;
      isObject(t18.beforeMinimized) && (e3 = t18.beforeMinimized, e3.left = t18.position.left, e3.top = t18.position.top), r2.position.set(e3);
    }
  }
}
class GetSvelteData {
  #ge;
  #_e;
  constructor(t18, e2) {
    this.#ge = t18, this.#_e = e2;
  }
  get appShell() {
    return this.#ge[0];
  }
  get applicationShell() {
    return this.#ge[0];
  }
  get appShellData() {
    return this.#_e[0];
  }
}
class SvelteReactive {
  #me;
  #$e = false;
  #be;
  #ye;
  #ve;
  #we;
  #Se;
  #Te;
  #ke = [];
  constructor(t18) {
    this.#me = t18;
    const e2 = t18?.options?.sessionStorage;
    if (void 0 !== e2 && !(e2 instanceof TJSWebStorage)) throw new TypeError("'options.sessionStorage' is not an instance of TJSWebStorage.");
    this.#be = void 0 !== e2 ? e2 : new TJSSessionStorage();
  }
  initialize() {
    if (!this.#$e) return this.#$e = true, this.#xe(), { appOptionsUpdate: this.#ve, uiStateUpdate: this.#Te, subscribe: this.#Ee.bind(this), unsubscribe: this.#Oe.bind(this) };
  }
  get sessionStorage() {
    return this.#be;
  }
  get storeAppOptions() {
    return this.#ye;
  }
  get storeUIState() {
    return this.#Se;
  }
  get activeWindow() {
    return this.#we.activeWindow ?? globalThis;
  }
  get dragging() {
    return this.#we.dragging;
  }
  get minimized() {
    return this.#we.minimized;
  }
  get resizing() {
    return this.#we.resizing;
  }
  set activeWindow(t18) {
    null != t18 && "[object Window]" !== Object.prototype.toString.call(t18) || this.#Te((e2) => deepMerge(e2, { activeWindow: t18 ?? globalThis }));
  }
  get draggable() {
    return this.#me?.options?.draggable;
  }
  get focusAuto() {
    return this.#me?.options?.focusAuto;
  }
  get focusKeep() {
    return this.#me?.options?.focusKeep;
  }
  get focusTrap() {
    return this.#me?.options?.focusTrap;
  }
  get headerButtonNoClose() {
    return this.#me?.options?.headerButtonNoClose;
  }
  get headerButtonNoLabel() {
    return this.#me?.options?.headerButtonNoLabel;
  }
  get headerIcon() {
    return this.#me?.options?.headerIcon;
  }
  get headerNoTitleMinimized() {
    return this.#me?.options?.headerNoTitleMinimized;
  }
  get minimizable() {
    return this.#me?.options?.minimizable;
  }
  get popOut() {
    return this.#me.popOut;
  }
  get positionable() {
    return this.#me?.options?.positionable;
  }
  get resizable() {
    return this.#me?.options?.resizable;
  }
  get title() {
    return this.#me.title;
  }
  set draggable(t18) {
    "boolean" == typeof t18 && this.setOptions("draggable", t18);
  }
  set focusAuto(t18) {
    "boolean" == typeof t18 && this.setOptions("focusAuto", t18);
  }
  set focusKeep(t18) {
    "boolean" == typeof t18 && this.setOptions("focusKeep", t18);
  }
  set focusTrap(t18) {
    "boolean" == typeof t18 && this.setOptions("focusTrap", t18);
  }
  set headerButtonNoClose(t18) {
    "boolean" == typeof t18 && this.setOptions("headerButtonNoClose", t18);
  }
  set headerButtonNoLabel(t18) {
    "boolean" == typeof t18 && this.setOptions("headerButtonNoLabel", t18);
  }
  set headerIcon(t18) {
    void 0 !== t18 && "string" != typeof t18 || this.setOptions("headerIcon", t18);
  }
  set headerNoTitleMinimized(t18) {
    "boolean" == typeof t18 && this.setOptions("headerNoTitleMinimized", t18);
  }
  set minimizable(t18) {
    "boolean" == typeof t18 && this.setOptions("minimizable", t18);
  }
  set popOut(t18) {
    "boolean" == typeof t18 && this.setOptions("popOut", t18);
  }
  set positionable(t18) {
    "boolean" == typeof t18 && this.setOptions("positionable", t18);
  }
  set resizable(t18) {
    "boolean" == typeof t18 && this.setOptions("resizable", t18);
  }
  set title(t18) {
    "string" == typeof t18 ? this.setOptions("title", t18) : null == t18 && this.setOptions("title", "");
  }
  getOptions(t18, e2) {
    return safeAccess(this.#me.options, t18, e2);
  }
  mergeOptions(t18) {
    this.#ve((e2) => deepMerge(e2, t18));
  }
  setOptions(t18, e2) {
    safeSet(this.#me.options, t18, e2, { createMissing: true }) && this.#ve(() => this.#me.options);
  }
  toJSON() {
    return { draggable: this.#me?.options?.draggable ?? true, focusAuto: this.#me?.options?.focusAuto ?? true, focusKeep: this.#me?.options?.focusKeep ?? false, focusTrap: this.#me?.options?.focusTrap ?? true, headerButtonNoClose: this.#me?.options?.headerButtonNoClose ?? false, headerButtonNoLabel: this.#me?.options?.headerButtonNoLabel ?? false, headerNoTitleMinimized: this.#me?.options?.headerNoTitleMinimized ?? false, minimizable: this.#me?.options?.minimizable ?? true, positionable: this.#me?.options?.positionable ?? true, resizable: this.#me?.options?.resizable ?? true };
  }
  updateHeaderButtons({ headerButtonNoClose: t18 = this.#me.options.headerButtonNoClose, headerButtonNoLabel: e2 = this.#me.options.headerButtonNoLabel } = {}) {
    let n2 = this.#me._getHeaderButtons();
    if ("boolean" == typeof t18 && t18 && (n2 = n2.filter((t19) => "close" !== t19.class)), "boolean" == typeof e2 && e2) for (const t19 of n2) t19.label = void 0;
    this.#Te((t19) => (t19.headerButtons = n2, t19));
  }
  #xe() {
    const t18 = writable(this.#me.options);
    this.#ve = t18.update;
    const e2 = { subscribe: t18.subscribe, draggable: propertyStore(t18, "draggable"), focusAuto: propertyStore(t18, "focusAuto"), focusKeep: propertyStore(t18, "focusKeep"), focusTrap: propertyStore(t18, "focusTrap"), headerButtonNoClose: propertyStore(t18, "headerButtonNoClose"), headerButtonNoLabel: propertyStore(t18, "headerButtonNoLabel"), headerIcon: propertyStore(t18, "headerIcon"), headerNoTitleMinimized: propertyStore(t18, "headerNoTitleMinimized"), minimizable: propertyStore(t18, "minimizable"), popOut: propertyStore(t18, "popOut"), positionable: propertyStore(t18, "positionable"), resizable: propertyStore(t18, "resizable"), title: propertyStore(t18, "title") };
    Object.freeze(e2), this.#ye = e2, this.#we = { activeWindow: globalThis, dragging: false, headerButtons: [], minimized: this.#me._minimized, resizing: false };
    const n2 = writable(this.#we);
    this.#Te = n2.update;
    const o2 = { subscribe: n2.subscribe, activeWindow: derived(n2, (t19, e3) => e3(t19.activeWindow)), dragging: propertyStore(n2, "dragging"), headerButtons: derived(n2, (t19, e3) => e3(t19.headerButtons)), minimized: derived(n2, (t19, e3) => e3(t19.minimized)), resizing: propertyStore(n2, "resizing") };
    Object.freeze(o2), this.#Se = o2;
  }
  #Ee() {
    this.#ke.push(subscribeIgnoreFirst(this.#ye.headerButtonNoClose, (t18) => {
      this.updateHeaderButtons({ headerButtonNoClose: t18 });
    })), this.#ke.push(subscribeIgnoreFirst(this.#ye.headerButtonNoLabel, (t18) => {
      this.updateHeaderButtons({ headerButtonNoLabel: t18 });
    })), this.#ke.push(subscribeIgnoreFirst(this.#ye.popOut, (t18) => {
      t18 && this.#me.rendered ? globalThis.ui.windows[this.#me.appId] = this.#me : delete globalThis.ui.windows[this.#me.appId];
    }));
  }
  #Oe() {
    this.#ke.forEach((t18) => t18()), this.#ke = [];
  }
}
const applicationShellContract = ["elementRoot"];
function isApplicationShell(t18) {
  if (null == t18) return false;
  let e2 = true, n2 = true;
  for (const n3 of applicationShellContract) {
    const o3 = Object.getOwnPropertyDescriptor(t18, n3);
    void 0 !== o3 && void 0 !== o3.get && void 0 !== o3.set || (e2 = false);
  }
  const o2 = Object.getPrototypeOf(t18);
  for (const t19 of applicationShellContract) {
    const e3 = Object.getOwnPropertyDescriptor(o2, t19);
    void 0 !== e3 && void 0 !== e3.get && void 0 !== e3.set || (n2 = false);
  }
  return e2 || n2;
}
function loadSvelteConfig({ app: t18, config: e2, elementRootUpdate: n2 } = {}) {
  let o2;
  if (CrossWindow.isHTMLElement(e2.target)) o2 = e2.target;
  else if ("string" == typeof e2.target) {
    const n3 = t18?.reactive?.activeWindow;
    o2 = n3?.document?.querySelector(e2.target);
  }
  if (!CrossWindow.isHTMLElement(o2)) throw e2.target, new Error();
  const i2 = e2.class, r2 = TJSSvelte.config.parseConfig({ ...e2, target: o2 }, { contextExternal: true, thisArg: t18 }), a2 = r2.context.get("#external");
  let s2;
  a2.application = t18, a2.elementRootUpdate = n2, a2.sessionStorage = t18.reactive.sessionStorage, isObject(t18._eventbus) && "function" == typeof t18._eventbus.createProxy && (s2 = t18._eventbus.createProxy(), a2.eventbus = s2), Object.seal(a2);
  const c2 = new i2(r2);
  let l2;
  if (r2.eventbus = s2, isApplicationShell(c2) && (l2 = c2.elementRoot), !CrossWindow.isHTMLElement(l2)) throw new Error();
  return { config: r2, component: c2, element: l2 };
}
Object.freeze(applicationShellContract);
class TJSAppIndex {
  static #Ae = /* @__PURE__ */ new Map();
  static add(t18) {
    this.#Ae.set(t18.id, t18);
  }
  static delete(t18) {
    this.#Ae.delete(t18.id);
  }
  static get(t18) {
    return this.#Ae.get(t18);
  }
  static has(t18) {
    return this.#Ae.has(t18);
  }
  static keys() {
    return this.#Ae.keys();
  }
  static values() {
    return this.#Ae.values();
  }
}
class SvelteApp extends Application {
  #ge = [null];
  #Ce;
  #Me = null;
  #Ie = null;
  #Ne = false;
  #Pe = 95;
  #De = false;
  #vt;
  #je;
  #_e = [null];
  #Fe = new GetSvelteData(this.#ge, this.#_e);
  #l;
  constructor(t18 = {}) {
    if (super(t18), !isObject(this.options.svelte)) throw new Error("SvelteApp - constructor - No Svelte configuration object found in 'options'.");
    this.#Ce = new ApplicationState(this), this.#vt = new TJSPosition(this, { ...this.position, ...this.options, initial: this.options.positionInitial, ortho: this.options.positionOrtho, validator: this.options.positionValidator }), delete this.position, Object.defineProperty(this, "position", { get: () => this.#vt, set: (t19) => {
      isObject(t19) && this.#vt.set(t19);
    } }), this.#je = new SvelteReactive(this), this.#l = this.#je.initialize();
  }
  static get defaultOptions() {
    return deepMerge(super.defaultOptions, { defaultCloseAnimation: true, draggable: true, focusAuto: true, focusKeep: false, focusSource: void 0, focusTrap: true, headerButtonNoClose: false, headerButtonNoLabel: false, headerIcon: void 0, headerNoTitleMinimized: false, minHeight: MIN_WINDOW_HEIGHT, minWidth: MIN_WINDOW_WIDTH, positionable: true, positionInitial: TJSPosition.Initial.browserCentered, positionOrtho: true, positionValidator: TJSPosition.Validators.transformWindow, sessionStorage: void 0, svelte: void 0, transformOrigin: "top left" });
  }
  get elementContent() {
    return this.#Ie;
  }
  get elementTarget() {
    return this.#Me;
  }
  get reactive() {
    return this.#je;
  }
  get state() {
    return this.#Ce;
  }
  get svelte() {
    return this.#Fe;
  }
  _activateCoreListeners(t18) {
    super._activateCoreListeners("string" == typeof this.options.template ? t18 : [this.popOut ? this.#Me?.firstChild : this.#Me]);
  }
  bringToTop({ focus: t18 = true, force: e2 = false } = {}) {
    if (this.reactive.activeWindow !== globalThis) return;
    (e2 || this.popOut) && super.bringToTop();
    const n2 = this.elementTarget, o2 = document.activeElement;
    t18 && n2 && o2 !== n2 && !n2?.contains(o2) && (A11yHelper.isFocusTarget(o2) && o2.blur(), n2?.focus()), globalThis.ui.activeWindow = this;
  }
  async close(t18 = {}) {
    const e2 = Application.RENDER_STATES;
    if (!t18.force && ![e2.RENDERED, e2.ERROR].includes(this._state)) return;
    const n2 = this.#Me;
    if (!n2) return void (this._state = e2.CLOSED);
    if (CrossWindow.getWindow(n2, { throws: false }) !== globalThis) return;
    this._state = e2.CLOSING, this.#l.unsubscribe();
    const o2 = n2.querySelector(".window-content");
    if (o2) {
      o2.style.overflow = "hidden";
      for (let t19 = o2.children.length; --t19 >= 0; ) o2.children[t19].style.overflow = "hidden";
    }
    for (const t19 of this.constructor._getInheritanceChain()) Hooks.call(`close${t19.name}`, this, $(n2));
    if ("boolean" != typeof this.options.defaultCloseAnimation || this.options.defaultCloseAnimation) {
      n2.style.minHeight = "0";
      const { paddingBottom: t19, paddingTop: e3 } = globalThis.getComputedStyle(n2);
      await n2.animate([{ maxHeight: `${n2.clientHeight}px`, paddingTop: e3, paddingBottom: t19 }, { maxHeight: 0, paddingTop: 0, paddingBottom: 0 }], { duration: 250, easing: "ease-in", fill: "forwards" }).finished;
    }
    const i2 = [];
    for (const t19 of this.#_e) {
      if (!isObject(t19)) continue;
      i2.push(TJSSvelte.util.outroAndDestroy(t19.component));
      const e3 = t19.config.eventbus;
      isObject(e3) && "function" == typeof e3.off && (e3.off(), t19.config.eventbus = void 0);
    }
    await Promise.allSettled(i2), TJSAppIndex.delete(this), this.#_e[0] = null, n2.remove(), this.position.state.restore({ name: "#beforeMinimized", properties: ["width", "height"], silent: true, remove: true }), this.#ge[0] = null, this._element = null, this.#Ie = null, this.#Me = null, delete globalThis.ui.windows[this.appId], this._minimized = false, this._scrollPositions = null, this._state = e2.CLOSED, this.#De = false, this.#l.uiStateUpdate((t19) => deepMerge(t19, { minimized: this._minimized })), A11yHelper.applyFocusSource(this.options.focusSource), delete this.options.focusSource;
  }
  _getHeaderButtons() {
    return super._getHeaderButtons();
  }
  _injectHTML() {
    this.reactive.updateHeaderButtons();
    if (!isObject(this.options.svelte)) throw new Error("SvelteApp - _injectHTML - No Svelte configuration object found in 'options'.");
    const t18 = loadSvelteConfig({ app: this, config: this.options.svelte, elementRootUpdate: () => {
      let t19 = 0;
      return (e2) => null != e2 && t19++ > 0 && (this.#Le(), true);
    } });
    if (null !== this.svelte.appShell) throw new Error(`SvelteApp - _injectHTML - An application shell is already mounted; offending config:
${JSON.stringify(this.options.svelte)}`);
    this.#ge[0] = t18.component, TJSSvelte.util.isHMRProxy(t18.component) && Array.isArray(t18.component?.$$?.on_hmr) && t18.component.$$.on_hmr.push(() => () => this.#Le()), this.#_e[0] = t18, this._element = $(this.svelte.appShell.elementRoot), this.#Ie = hasGetter(this.svelte.appShell, "elementContent") ? this.svelte.appShell.elementContent : null, this.#Me = hasGetter(this.svelte.appShell, "elementTarget") ? this.svelte.appShell.elementTarget : this.svelte.appShell.elementRoot, "boolean" == typeof this.options.positionable && this.options.positionable && (this.#Me.style.zIndex = "number" == typeof this.options.zIndex ? this.options.zIndex : this.#Pe ?? 95), this.#l.subscribe();
  }
  async maximize({ animate: t18 = true, duration: e2 = 0.1 } = {}) {
    if (!this.popOut || [false, null].includes(this._minimized)) return;
    this._minimized = null;
    const n2 = 1e3 * e2, o2 = this.elementTarget, i2 = o2.querySelector(".window-header"), r2 = o2.querySelector(".window-content"), a2 = this.position.state.get({ name: "#beforeMinimized" });
    t18 && await this.position.state.restore({ name: "#beforeMinimized", async: true, animateTo: true, properties: ["width"], duration: 0.1 }), o2.classList.remove("minimized");
    for (let t19 = i2.children.length; --t19 >= 0; ) i2.children[t19].style.display = null;
    let s2;
    r2.style.display = null, { constraints: s2 } = t18 ? this.position.state.restore({ name: "#beforeMinimized", animateTo: true, properties: ["height"], remove: true, duration: e2 }) : this.position.state.remove({ name: "#beforeMinimized" }), await r2.animate([{ maxHeight: 0, paddingTop: 0, paddingBottom: 0, offset: 0 }, { ...s2, offset: 1 }, { maxHeight: "100%", offset: 1 }], { duration: n2, fill: "forwards" }).finished, this.position.set({ minHeight: a2.minHeight ?? this.options?.minHeight ?? MIN_WINDOW_HEIGHT, minWidth: a2.minWidth ?? this.options?.minWidth ?? MIN_WINDOW_WIDTH }), o2.style.minWidth = null, o2.style.minHeight = null, this._minimized = false, setTimeout(() => {
      r2.style.overflow = null;
      for (let t19 = r2.children.length; --t19 >= 0; ) r2.children[t19].style.overflow = null;
    }, 50), this.#l.uiStateUpdate((t19) => deepMerge(t19, { minimized: false }));
  }
  async minimize({ animate: t18 = true, duration: e2 = 0.1 } = {}) {
    if (!this.rendered || !this.popOut || [true, null].includes(this._minimized)) return;
    this.#l.uiStateUpdate((t19) => deepMerge(t19, { minimized: true })), this._minimized = null;
    const n2 = 1e3 * e2, o2 = this.elementTarget, i2 = o2.querySelector(".window-header"), r2 = o2.querySelector(".window-content"), a2 = this.position.minWidth, s2 = this.position.minHeight;
    if (this.position.set({ minWidth: 100, minHeight: 30 }), o2.style.minWidth = "100px", o2.style.minHeight = "30px", r2) {
      r2.style.overflow = "hidden";
      for (let t19 = r2.children.length; --t19 >= 0; ) r2.children[t19].style.overflow = "hidden";
    }
    const { paddingBottom: c2, paddingTop: l2 } = globalThis.getComputedStyle(r2), u2 = { maxHeight: `${r2.clientHeight}px`, paddingTop: l2, paddingBottom: c2 };
    if (t18) {
      r2.animate([u2, { maxHeight: 0, paddingTop: 0, paddingBottom: 0 }], { duration: n2, fill: "forwards" }).finished.then(() => r2.style.display = "none");
    } else setTimeout(() => r2.style.display = "none", n2);
    const p2 = this.position.state.save({ name: "#beforeMinimized", constraints: u2 });
    p2.minWidth = a2, p2.minHeight = s2;
    const d2 = i2.offsetHeight;
    this.position.minHeight = d2, t18 && await this.position.animate.to({ height: d2 }, { duration: e2 }).finished;
    for (let t19 = i2.children.length; --t19 >= 0; ) {
      const e3 = i2.children[t19].className;
      e3.includes("window-title") || e3.includes("close") || (e3.includes("keep-minimized") ? i2.children[t19].style.display = "block" : i2.children[t19].style.display = "none");
    }
    t18 && await this.position.animate.to({ width: MIN_WINDOW_WIDTH }, { duration: 0.1 }).finished, o2.classList.add("minimized"), this._minimized = true;
  }
  onSvelteMount() {
  }
  onSvelteRemount() {
  }
  _replaceHTML(t18, e2) {
    t18.length && this.reactive.updateHeaderButtons();
  }
  async _render(t18 = false, e2 = {}) {
    isObject(e2?.focusSource) && (this.options.focusSource = e2.focusSource);
    const n2 = this.reactive.activeWindow;
    try {
      if (this._state === Application.RENDER_STATES.NONE && A11yHelper.isFocusTarget(n2.document.querySelector(`#${this.id}`))) return void console.warn(`SvelteApp - _render: A DOM element already exists for CSS ID '${this.id}'. Cancelling initial render for new application with appId '${this.appId}'.`);
    } catch (t19) {
      return void console.warn(`SvelteApp - _render: Potentially malformed application ID '${this.id}'. Cancelling initial render for new application with appId '${this.appId}'.`);
    }
    this.#Ne = true, await super._render(t18, e2), this.#Ne = false, [Application.RENDER_STATES.CLOSING, Application.RENDER_STATES.RENDERING].includes(this._state) || !t18 && this._state <= Application.RENDER_STATES.NONE || (this._minimized || this.#vt.set({ left: "string" == typeof this.options?.left ? this.options.left : void 0, height: "string" == typeof this.options?.height ? this.options.height : void 0, maxHeight: "string" == typeof this.options?.maxHeight ? this.options.maxHeight : void 0, maxWidth: "string" == typeof this.options?.maxWidth ? this.options.maxWidth : void 0, minHeight: "string" == typeof this.options?.minHeight ? this.options.minHeight : void 0, minWidth: "string" == typeof this.options?.minWidth ? this.options.minWidth : void 0, rotateX: "string" == typeof this.options?.rotateX ? this.options.rotateX : void 0, rotateY: "string" == typeof this.options?.rotateY ? this.options.rotateY : void 0, rotateZ: "string" == typeof this.options?.rotateZ ? this.options.rotateZ : void 0, rotation: "string" == typeof this.options?.rotation ? this.options.rotation : void 0, top: "string" == typeof this.options?.top ? this.options.top : void 0, width: "string" == typeof this.options?.width ? this.options.width : void 0, ...e2 }), this.#De || (TJSAppIndex.add(this), this.onSvelteMount(), this.#De = true));
  }
  async _renderInner() {
    const t18 = this.reactive.activeWindow.document.createDocumentFragment();
    return $(t18);
  }
  async _renderOuter() {
    const t18 = await super._renderOuter();
    return this.#Pe = t18[0].style.zIndex, t18;
  }
  setPosition(t18) {
    return this.#Ne ? this.position : this.position.set(t18);
  }
  #Le() {
    const t18 = this.svelte.appShell;
    null !== t18 && (this._element = $(t18.elementRoot), this.#Ie = hasGetter(t18, "elementContent") ? t18.elementContent : null, this.#Me = hasGetter(t18, "elementTarget") ? t18.elementTarget : null, null === this.#Me && (this.#Me = "string" == typeof this.options.selectorTarget ? this._element[0].querySelector(this.options.selectorTarget) : this._element[0]), "boolean" == typeof this.options.positionable && this.options.positionable && (this.#Me.style.zIndex = "number" == typeof this.options.zIndex ? this.options.zIndex : this.#Pe ?? 95, super.bringToTop(), this.position.set(this.position.get())), super._activateCoreListeners([this.popOut ? this.#Me?.firstChild : this.#Me]), this.onSvelteRemount());
  }
}
class PopoutSupport {
  static initialize() {
    Hooks.on("PopOut:loading", (t18, e2) => {
      t18 instanceof SvelteApp && (t18.position.enabled = false, t18.state.save({ name: "#beforePopout", headerButtonNoClose: t18.reactive.headerButtonNoClose }), t18.reactive.activeWindow = e2, t18.reactive.headerButtonNoClose = true);
    }), Hooks.on("PopOut:popin", (t18) => this.#Re(t18)), Hooks.on("PopOut:close", (t18) => this.#Re(t18));
  }
  static #Re(t18) {
    if (t18 instanceof SvelteApp) {
      t18.position.enabled = true;
      const e2 = t18.state.remove({ name: "#beforePopout" });
      e2 && (t18.reactive.headerButtonNoClose = e2?.headerButtonNoClose ?? false), t18.reactive.activeWindow = void 0;
    }
  }
}
PopoutSupport.initialize();
let subModuleId = "";
function getFullModuleId() {
  return "mobile-companion-" + subModuleId;
}
function getBaseModuleId() {
  return "mobile-companion";
}
const CONTEXT$1 = { WIDGET_STORE: "widgetStore", DISPLAYED_IN_WIDGET: "displayedInWidget", EDIT_MODE: "editMode", LOADED_APP: "loadedApp" };
function create_if_block$1z(t18) {
  let e2, n2, o2;
  const i2 = [t18[0].widget.props];
  var r2 = t18[0].widget.component;
  function a2(t19, e3) {
    let n3 = {};
    for (let t20 = 0; t20 < i2.length; t20 += 1) n3 = assign(n3, i2[t20]);
    return void 0 !== e3 && 1 & e3 && (n3 = assign(n3, get_spread_update(i2, [get_spread_object(t19[0].widget.props)]))), { props: n3 };
  }
  return r2 && (n2 = construct_svelte_component(r2, a2(t18))), { c() {
    e2 = element("div"), n2 && create_component(n2.$$.fragment), attr(e2, "class", "widget-container svelte-mobile-companion-a5e-038vch56tr3-1fqkpt2");
  }, m(t19, i3) {
    insert(t19, e2, i3), n2 && mount_component(n2, e2, null), o2 = true;
  }, p(t19, o3) {
    if (1 & o3 && r2 !== (r2 = t19[0].widget.component)) {
      if (n2) {
        group_outros();
        const t20 = n2;
        transition_out(t20.$$.fragment, 1, 0, () => {
          destroy_component(t20, 1);
        }), check_outros();
      }
      r2 ? (n2 = construct_svelte_component(r2, a2(t19, o3)), create_component(n2.$$.fragment), transition_in(n2.$$.fragment, 1), mount_component(n2, e2, null)) : n2 = null;
    } else if (r2) {
      const e3 = 1 & o3 ? get_spread_update(i2, [get_spread_object(t19[0].widget.props)]) : {};
      n2.$set(e3);
    }
  }, i(t19) {
    o2 || (n2 && transition_in(n2.$$.fragment, t19), o2 = true);
  }, o(t19) {
    n2 && transition_out(n2.$$.fragment, t19), o2 = false;
  }, d(t19) {
    t19 && detach(e2), n2 && destroy_component(n2);
  } };
}
function create_fragment$2F(t18) {
  let e2, n2, o2 = t18[0].widget && create_if_block$1z(t18);
  return { c() {
    e2 = element("div"), o2 && o2.c(), attr(e2, "class", "cell svelte-mobile-companion-a5e-038vch56tr3-1fqkpt2"), attr(e2, "data-grid-name", "main-cell"), set_style(e2, "grid-row", t18[0].row + 1 + " / span " + t18[0].rowSpan), set_style(e2, "grid-column", t18[0].col + 1 + " / span " + t18[0].colSpan);
  }, m(t19, i2) {
    insert(t19, e2, i2), o2 && o2.m(e2, null), n2 = true;
  }, p(t19, [i2]) {
    t19[0].widget ? o2 ? (o2.p(t19, i2), 1 & i2 && transition_in(o2, 1)) : (o2 = create_if_block$1z(t19), o2.c(), transition_in(o2, 1), o2.m(e2, null)) : o2 && (group_outros(), transition_out(o2, 1, 1, () => {
      o2 = null;
    }), check_outros()), (!n2 || 1 & i2) && set_style(e2, "grid-row", t19[0].row + 1 + " / span " + t19[0].rowSpan), (!n2 || 1 & i2) && set_style(e2, "grid-column", t19[0].col + 1 + " / span " + t19[0].colSpan);
  }, i(t19) {
    n2 || (transition_in(o2), n2 = true);
  }, o(t19) {
    transition_out(o2), n2 = false;
  }, d(t19) {
    t19 && detach(e2), o2 && o2.d();
  } };
}
function instance$2G(t18, e2, n2) {
  let { cell: o2 } = e2;
  return t18.$$set = (t19) => {
    "cell" in t19 && n2(0, o2 = t19.cell);
  }, [o2];
}
class WidgetCell extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2G, create_fragment$2F, safe_not_equal, { cell: 0 });
  }
}
const faBan$1 = { prefix: "fas", iconName: "ban", icon: [512, 512, [128683, "cancel"], "f05e", "M367.2 412.5L99.5 144.8C77.1 176.1 64 214.5 64 256c0 106 86 192 192 192c41.5 0 79.9-13.1 111.2-35.5zm45.3-45.3C434.9 335.9 448 297.5 448 256c0-106-86-192-192-192c-41.5 0-79.9 13.1-111.2 35.5L412.5 367.2zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256z"] }, faCancel$1 = faBan$1, faGripLinesVertical = { prefix: "fas", iconName: "grip-lines-vertical", icon: [192, 512, [], "f7a5", "M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 448c0 17.7 14.3 32 32 32s32-14.3 32-32L64 64zm128 0c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 384c0 17.7 14.3 32 32 32s32-14.3 32-32l0-384z"] }, faArrowRight = { prefix: "fas", iconName: "arrow-right", icon: [448, 512, [8594], "f061", "M438.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L338.8 224 32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l306.7 0L233.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160z"] }, faFloppyDisk = { prefix: "fas", iconName: "floppy-disk", icon: [448, 512, [128190, 128426, "save"], "f0c7", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-242.7c0-17-6.7-33.3-18.7-45.3L352 50.7C340 38.7 323.7 32 306.7 32L64 32zm0 96c0-17.7 14.3-32 32-32l192 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32L96 224c-17.7 0-32-14.3-32-32l0-64zM224 288a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"] }, faSave = faFloppyDisk, faTrash = { prefix: "fas", iconName: "trash", icon: [448, 512, [], "f1f8", "M135.2 17.7L128 32 32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0-7.2-14.3C307.4 6.8 296.3 0 284.2 0L163.8 0c-12.1 0-23.2 6.8-28.6 17.7zM416 128L32 128 53.2 467c1.6 25.3 22.6 45 47.9 45l245.8 0c25.3 0 46.3-19.7 47.9-45L416 128z"] }, faArrowLeft = { prefix: "fas", iconName: "arrow-left", icon: [448, 512, [8592], "f060", "M9.4 233.4c-12.5 12.5-12.5 32.8 0 45.3l160 160c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L109.2 288 416 288c17.7 0 32-14.3 32-32s-14.3-32-32-32l-306.7 0L214.6 118.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-160 160z"] }, faGripLines = { prefix: "fas", iconName: "grip-lines", icon: [448, 512, [], "f7a4", "M32 288c-17.7 0-32 14.3-32 32s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 288zm0-128c-17.7 0-32 14.3-32 32s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 160z"] }, faArrowDown = { prefix: "fas", iconName: "arrow-down", icon: [384, 512, [8595], "f063", "M169.4 470.6c12.5 12.5 32.8 12.5 45.3 0l160-160c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L224 370.8 224 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 306.7L54.6 265.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l160 160z"] }, faLink = { prefix: "fas", iconName: "link", icon: [640, 512, [128279, "chain"], "f0c1", "M579.8 267.7c56.5-56.5 56.5-148 0-204.5c-50-50-128.8-56.5-186.3-15.4l-1.6 1.1c-14.4 10.3-17.7 30.3-7.4 44.6s30.3 17.7 44.6 7.4l1.6-1.1c32.1-22.9 76-19.3 103.8 8.6c31.5 31.5 31.5 82.5 0 114L422.3 334.8c-31.5 31.5-82.5 31.5-114 0c-27.9-27.9-31.5-71.8-8.6-103.8l1.1-1.6c10.3-14.4 6.9-34.4-7.4-44.6s-34.4-6.9-44.6 7.4l-1.1 1.6C206.5 251.2 213 330 263 380c56.5 56.5 148 56.5 204.5 0L579.8 267.7zM60.2 244.3c-56.5 56.5-56.5 148 0 204.5c50 50 128.8 56.5 186.3 15.4l1.6-1.1c14.4-10.3 17.7-30.3 7.4-44.6s-30.3-17.7-44.6-7.4l-1.6 1.1c-32.1 22.9-76 19.3-103.8-8.6C74 372 74 321 105.5 289.5L217.7 177.2c31.5-31.5 82.5-31.5 114 0c27.9 27.9 31.5 71.8 8.6 103.9l-1.1 1.6c-10.3 14.4-6.9 34.4 7.4 44.6s34.4 6.9 44.6-7.4l1.1-1.6C433.5 260.8 427 182 377 132c-56.5-56.5-148-56.5-204.5 0L60.2 244.3z"] }, faChain = faLink, faArrowUp = { prefix: "fas", iconName: "arrow-up", icon: [384, 512, [8593], "f062", "M214.6 41.4c-12.5-12.5-32.8-12.5-45.3 0l-160 160c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L160 141.2 160 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-306.7L329.4 246.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-160-160z"] }, faPlus = { prefix: "fas", iconName: "plus", icon: [448, 512, [10133, 61543, "add"], "2b", "M256 80c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 144L48 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l144 0 0 144c0 17.7 14.3 32 32 32s32-14.3 32-32l0-144 144 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-144 0 0-144z"] }, faRotate = { prefix: "fas", iconName: "rotate", icon: [512, 512, [128260, "sync-alt"], "f2f1", "M142.9 142.9c-17.5 17.5-30.1 38-37.8 59.8c-5.9 16.7-24.2 25.4-40.8 19.5s-25.4-24.2-19.5-40.8C55.6 150.7 73.2 122 97.6 97.6c87.2-87.2 228.3-87.5 315.8-1L455 55c6.9-6.9 17.2-8.9 26.2-5.2s14.8 12.5 14.8 22.2l0 128c0 13.3-10.7 24-24 24l-8.4 0c0 0 0 0 0 0L344 224c-9.7 0-18.5-5.8-22.2-14.8s-1.7-19.3 5.2-26.2l41.1-41.1c-62.6-61.5-163.1-61.2-225.3 1zM16 312c0-13.3 10.7-24 24-24l7.6 0 .7 0L168 288c9.7 0 18.5 5.8 22.2 14.8s1.7 19.3-5.2 26.2l-41.1 41.1c62.6 61.5 163.1 61.2 225.3-1c17.5-17.5 30.1-38 37.8-59.8c5.9-16.7 24.2-25.4 40.8-19.5s25.4 24.2 19.5 40.8c-10.8 30.6-28.4 59.3-52.9 83.8c-87.2 87.2-228.3 87.5-315.8 1L57 457c-6.9 6.9-17.2 8.9-26.2 5.2S16 449.7 16 440l0-119.6 0-.7 0-7.6z"] };
function classList$1(t18) {
  const { beat: e2, fade: n2, beatFade: o2, bounce: i2, shake: r2, flash: a2, spin: s2, spinPulse: c2, spinReverse: l2, pulse: u2, fixedWidth: p2, inverse: d2, border: m2, listItem: f2, flip: h2, size: g2, rotation: _, pull: $2 } = t18, b2 = { "fa-beat": e2, "fa-fade": n2, "fa-beat-fade": o2, "fa-bounce": i2, "fa-shake": r2, "fa-flash": a2, "fa-spin": s2, "fa-spin-reverse": l2, "fa-spin-pulse": c2, "fa-pulse": u2, "fa-fw": p2, "fa-inverse": d2, "fa-border": m2, "fa-li": f2, "fa-flip": true === h2, "fa-flip-horizontal": "horizontal" === h2 || "both" === h2, "fa-flip-vertical": "vertical" === h2 || "both" === h2, [`fa-${g2}`]: null != g2, [`fa-rotate-${_}`]: null != _ && 0 !== _, [`fa-pull-${$2}`]: null != $2, "fa-swap-opacity": t18.swapOpacity };
  return Object.keys(b2).map((t19) => b2[t19] ? t19 : null).filter((t19) => t19);
}
function _isNumerical$1(t18) {
  return (t18 -= 0) == t18;
}
function camelize$1(t18) {
  return _isNumerical$1(t18) ? t18 : (t18 = t18.replace(/[\-_\s]+(.)?/g, function(t19, e2) {
    return e2 ? e2.toUpperCase() : "";
  })).substr(0, 1).toLowerCase() + t18.substr(1);
}
function styleToString$1(t18) {
  return "string" == typeof t18 ? t18 : Object.keys(t18).reduce((e2, n2) => e2 + n2.split(/(?=[A-Z])/).join("-").toLowerCase() + ":" + t18[n2] + ";", "");
}
function convert$1(t18, e2, n2 = {}) {
  if ("string" == typeof e2) return e2;
  const o2 = (e2.children || []).map((e3) => convert$1(t18, e3)), i2 = Object.keys(e2.attributes || {}).reduce((t19, n3) => {
    const o3 = e2.attributes[n3];
    return "style" === n3 ? t19.attrs.style = styleToString$1(o3) : 0 === n3.indexOf("aria-") || 0 === n3.indexOf("data-") ? t19.attrs[n3.toLowerCase()] = o3 : t19.attrs[camelize$1(n3)] = o3, t19;
  }, { attrs: {} });
  return t18(e2.tag, { ...i2.attrs }, o2);
}
function _arrayLikeToArray(t18, e2) {
  (null == e2 || e2 > t18.length) && (e2 = t18.length);
  for (var n2 = 0, o2 = Array(e2); n2 < e2; n2++) o2[n2] = t18[n2];
  return o2;
}
function _arrayWithHoles(t18) {
  if (Array.isArray(t18)) return t18;
}
function _arrayWithoutHoles(t18) {
  if (Array.isArray(t18)) return _arrayLikeToArray(t18);
}
function _classCallCheck(t18, e2) {
  if (!(t18 instanceof e2)) throw new TypeError("Cannot call a class as a function");
}
function _defineProperties(t18, e2) {
  for (var n2 = 0; n2 < e2.length; n2++) {
    var o2 = e2[n2];
    o2.enumerable = o2.enumerable || false, o2.configurable = true, "value" in o2 && (o2.writable = true), Object.defineProperty(t18, _toPropertyKey$1(o2.key), o2);
  }
}
function _createClass(t18, e2, n2) {
  return e2 && _defineProperties(t18.prototype, e2), Object.defineProperty(t18, "prototype", { writable: false }), t18;
}
function _createForOfIteratorHelper(t18, e2) {
  var n2 = "undefined" != typeof Symbol && t18[Symbol.iterator] || t18["@@iterator"];
  if (!n2) {
    if (Array.isArray(t18) || (n2 = _unsupportedIterableToArray(t18)) || e2) {
      n2 && (t18 = n2);
      var o2 = 0, i2 = function() {
      };
      return { s: i2, n: function() {
        return o2 >= t18.length ? { done: true } : { done: false, value: t18[o2++] };
      }, e: function(t19) {
        throw t19;
      }, f: i2 };
    }
    throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
  }
  var r2, a2 = true, s2 = false;
  return { s: function() {
    n2 = n2.call(t18);
  }, n: function() {
    var t19 = n2.next();
    return a2 = t19.done, t19;
  }, e: function(t19) {
    s2 = true, r2 = t19;
  }, f: function() {
    try {
      a2 || null == n2.return || n2.return();
    } finally {
      if (s2) throw r2;
    }
  } };
}
function _defineProperty$1(t18, e2, n2) {
  return (e2 = _toPropertyKey$1(e2)) in t18 ? Object.defineProperty(t18, e2, { value: n2, enumerable: true, configurable: true, writable: true }) : t18[e2] = n2, t18;
}
function _iterableToArray(t18) {
  if ("undefined" != typeof Symbol && null != t18[Symbol.iterator] || null != t18["@@iterator"]) return Array.from(t18);
}
function _iterableToArrayLimit(t18, e2) {
  var n2 = null == t18 ? null : "undefined" != typeof Symbol && t18[Symbol.iterator] || t18["@@iterator"];
  if (null != n2) {
    var o2, i2, r2, a2, s2 = [], c2 = true, l2 = false;
    try {
      if (r2 = (n2 = n2.call(t18)).next, 0 === e2) {
        if (Object(n2) !== n2) return;
        c2 = false;
      } else for (; !(c2 = (o2 = r2.call(n2)).done) && (s2.push(o2.value), s2.length !== e2); c2 = true) ;
    } catch (t19) {
      l2 = true, i2 = t19;
    } finally {
      try {
        if (!c2 && null != n2.return && (a2 = n2.return(), Object(a2) !== a2)) return;
      } finally {
        if (l2) throw i2;
      }
    }
    return s2;
  }
}
function _nonIterableRest() {
  throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
}
function ownKeys$1(t18, e2) {
  var n2 = Object.keys(t18);
  if (Object.getOwnPropertySymbols) {
    var o2 = Object.getOwnPropertySymbols(t18);
    e2 && (o2 = o2.filter(function(e3) {
      return Object.getOwnPropertyDescriptor(t18, e3).enumerable;
    })), n2.push.apply(n2, o2);
  }
  return n2;
}
function _objectSpread2$1(t18) {
  for (var e2 = 1; e2 < arguments.length; e2++) {
    var n2 = null != arguments[e2] ? arguments[e2] : {};
    e2 % 2 ? ownKeys$1(Object(n2), true).forEach(function(e3) {
      _defineProperty$1(t18, e3, n2[e3]);
    }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(t18, Object.getOwnPropertyDescriptors(n2)) : ownKeys$1(Object(n2)).forEach(function(e3) {
      Object.defineProperty(t18, e3, Object.getOwnPropertyDescriptor(n2, e3));
    });
  }
  return t18;
}
function _slicedToArray(t18, e2) {
  return _arrayWithHoles(t18) || _iterableToArrayLimit(t18, e2) || _unsupportedIterableToArray(t18, e2) || _nonIterableRest();
}
function _toConsumableArray(t18) {
  return _arrayWithoutHoles(t18) || _iterableToArray(t18) || _unsupportedIterableToArray(t18) || _nonIterableSpread();
}
function _toPrimitive$1(t18, e2) {
  if ("object" != typeof t18 || !t18) return t18;
  var n2 = t18[Symbol.toPrimitive];
  if (void 0 !== n2) {
    var o2 = n2.call(t18, e2 || "default");
    if ("object" != typeof o2) return o2;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return ("string" === e2 ? String : Number)(t18);
}
function _toPropertyKey$1(t18) {
  var e2 = _toPrimitive$1(t18, "string");
  return "symbol" == typeof e2 ? e2 : e2 + "";
}
function _typeof(t18) {
  return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(t19) {
    return typeof t19;
  } : function(t19) {
    return t19 && "function" == typeof Symbol && t19.constructor === Symbol && t19 !== Symbol.prototype ? "symbol" : typeof t19;
  }, _typeof(t18);
}
function _unsupportedIterableToArray(t18, e2) {
  if (t18) {
    if ("string" == typeof t18) return _arrayLikeToArray(t18, e2);
    var n2 = {}.toString.call(t18).slice(8, -1);
    return "Object" === n2 && t18.constructor && (n2 = t18.constructor.name), "Map" === n2 || "Set" === n2 ? Array.from(t18) : "Arguments" === n2 || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n2) ? _arrayLikeToArray(t18, e2) : void 0;
  }
}
var noop$3 = function() {
}, _WINDOW$1 = {}, _DOCUMENT$1 = {}, _MUTATION_OBSERVER$1 = null, _PERFORMANCE$1 = { mark: noop$3, measure: noop$3 };
try {
  "undefined" != typeof window && (_WINDOW$1 = window), "undefined" != typeof document && (_DOCUMENT$1 = document), "undefined" != typeof MutationObserver && (_MUTATION_OBSERVER$1 = MutationObserver), "undefined" != typeof performance && (_PERFORMANCE$1 = performance);
} catch (e2) {
}
var _ref = _WINDOW$1.navigator || {}, _ref$userAgent = _ref.userAgent, userAgent$1 = void 0 === _ref$userAgent ? "" : _ref$userAgent, WINDOW$1 = _WINDOW$1, DOCUMENT$1 = _DOCUMENT$1, MUTATION_OBSERVER$1 = _MUTATION_OBSERVER$1, PERFORMANCE$1 = _PERFORMANCE$1;
WINDOW$1.document;
var IS_DOM$1 = !!DOCUMENT$1.documentElement && !!DOCUMENT$1.head && "function" == typeof DOCUMENT$1.addEventListener && "function" == typeof DOCUMENT$1.createElement, IS_IE$1 = ~userAgent$1.indexOf("MSIE") || ~userAgent$1.indexOf("Trident/"), _so, K = /fa(k|kd|s|r|l|t|d|dr|dl|dt|b|slr|slpr|wsb|tl|ns|nds|es|jr|jfr|jdr|cr|ss|sr|sl|st|sds|sdr|sdl|sdt)?[\-\ ]/, W = /Font ?Awesome ?([567 ]*)(Solid|Regular|Light|Thin|Duotone|Brands|Free|Pro|Sharp Duotone|Sharp|Kit|Notdog Duo|Notdog|Chisel|Etch|Thumbprint|Jelly Fill|Jelly Duo|Jelly|Slab Press|Slab|Whiteboard)?.*/i, z = { classic: { fa: "solid", fas: "solid", "fa-solid": "solid", far: "regular", "fa-regular": "regular", fal: "light", "fa-light": "light", fat: "thin", "fa-thin": "thin", fab: "brands", "fa-brands": "brands" }, duotone: { fa: "solid", fad: "solid", "fa-solid": "solid", "fa-duotone": "solid", fadr: "regular", "fa-regular": "regular", fadl: "light", "fa-light": "light", fadt: "thin", "fa-thin": "thin" }, sharp: { fa: "solid", fass: "solid", "fa-solid": "solid", fasr: "regular", "fa-regular": "regular", fasl: "light", "fa-light": "light", fast: "thin", "fa-thin": "thin" }, "sharp-duotone": { fa: "solid", fasds: "solid", "fa-solid": "solid", fasdr: "regular", "fa-regular": "regular", fasdl: "light", "fa-light": "light", fasdt: "thin", "fa-thin": "thin" }, slab: { "fa-regular": "regular", faslr: "regular" }, "slab-press": { "fa-regular": "regular", faslpr: "regular" }, thumbprint: { "fa-light": "light", fatl: "light" }, whiteboard: { "fa-semibold": "semibold", fawsb: "semibold" }, notdog: { "fa-solid": "solid", fans: "solid" }, "notdog-duo": { "fa-solid": "solid", fands: "solid" }, etch: { "fa-solid": "solid", faes: "solid" }, jelly: { "fa-regular": "regular", fajr: "regular" }, "jelly-fill": { "fa-regular": "regular", fajfr: "regular" }, "jelly-duo": { "fa-regular": "regular", fajdr: "regular" }, chisel: { "fa-regular": "regular", facr: "regular" } }, O = { GROUP: "duotone-group", SWAP_OPACITY: "swap-opacity", PRIMARY: "primary", SECONDARY: "secondary" }, G$1 = ["fa-classic", "fa-duotone", "fa-sharp", "fa-sharp-duotone", "fa-thumbprint", "fa-whiteboard", "fa-notdog", "fa-notdog-duo", "fa-chisel", "fa-etch", "fa-jelly", "fa-jelly-fill", "fa-jelly-duo", "fa-slab", "fa-slab-press"], a = "classic", o$1 = "duotone", d = "sharp", t$2 = "sharp-duotone", i = "chisel", n = "etch", h = "jelly", s$1 = "jelly-duo", f = "jelly-fill", g$1 = "notdog", l = "notdog-duo", u = "slab", p$1 = "slab-press", e = "thumbprint", w$1 = "whiteboard", m = "Classic", y = "Duotone", x$1 = "Sharp", c = "Sharp Duotone", I = "Chisel", b = "Etch", F = "Jelly", v = "Jelly Duo", S$1 = "Jelly Fill", A$1 = "Notdog", P$1 = "Notdog Duo", j = "Slab", B = "Slab Press", N = "Thumbprint", k = "Whiteboard", oo = [a, o$1, d, t$2, i, n, h, s$1, f, g$1, l, u, p$1, e, w$1];
_so = {}, _defineProperty$1(_defineProperty$1(_defineProperty$1(_defineProperty$1(_defineProperty$1(_defineProperty$1(_defineProperty$1(_defineProperty$1(_defineProperty$1(_defineProperty$1(_so, a, m), o$1, y), d, x$1), t$2, c), i, I), n, b), h, F), s$1, v), f, S$1), g$1, A$1), _defineProperty$1(_defineProperty$1(_defineProperty$1(_defineProperty$1(_defineProperty$1(_so, l, P$1), u, j), p$1, B), e, N), w$1, k);
var io = { classic: { 900: "fas", 400: "far", normal: "far", 300: "fal", 100: "fat" }, duotone: { 900: "fad", 400: "fadr", 300: "fadl", 100: "fadt" }, sharp: { 900: "fass", 400: "fasr", 300: "fasl", 100: "fast" }, "sharp-duotone": { 900: "fasds", 400: "fasdr", 300: "fasdl", 100: "fasdt" }, slab: { 400: "faslr" }, "slab-press": { 400: "faslpr" }, whiteboard: { 600: "fawsb" }, thumbprint: { 300: "fatl" }, notdog: { 900: "fans" }, "notdog-duo": { 900: "fands" }, etch: { 900: "faes" }, chisel: { 400: "facr" }, jelly: { 400: "fajr" }, "jelly-fill": { 400: "fajfr" }, "jelly-duo": { 400: "fajdr" } }, Bo = { "Font Awesome 7 Free": { 900: "fas", 400: "far" }, "Font Awesome 7 Pro": { 900: "fas", 400: "far", normal: "far", 300: "fal", 100: "fat" }, "Font Awesome 7 Brands": { 400: "fab", normal: "fab" }, "Font Awesome 7 Duotone": { 900: "fad", 400: "fadr", normal: "fadr", 300: "fadl", 100: "fadt" }, "Font Awesome 7 Sharp": { 900: "fass", 400: "fasr", normal: "fasr", 300: "fasl", 100: "fast" }, "Font Awesome 7 Sharp Duotone": { 900: "fasds", 400: "fasdr", normal: "fasdr", 300: "fasdl", 100: "fasdt" }, "Font Awesome 7 Jelly": { 400: "fajr", normal: "fajr" }, "Font Awesome 7 Jelly Fill": { 400: "fajfr", normal: "fajfr" }, "Font Awesome 7 Jelly Duo": { 400: "fajdr", normal: "fajdr" }, "Font Awesome 7 Slab": { 400: "faslr", normal: "faslr" }, "Font Awesome 7 Slab Press": { 400: "faslpr", normal: "faslpr" }, "Font Awesome 7 Thumbprint": { 300: "fatl", normal: "fatl" }, "Font Awesome 7 Notdog": { 900: "fans", normal: "fans" }, "Font Awesome 7 Notdog Duo": { 900: "fands", normal: "fands" }, "Font Awesome 7 Etch": { 900: "faes", normal: "faes" }, "Font Awesome 7 Chisel": { 400: "facr", normal: "facr" }, "Font Awesome 7 Whiteboard": { 600: "fawsb", normal: "fawsb" } }, Co = /* @__PURE__ */ new Map([["classic", { defaultShortPrefixId: "fas", defaultStyleId: "solid", styleIds: ["solid", "regular", "light", "thin", "brands"], futureStyleIds: [], defaultFontWeight: 900 }], ["duotone", { defaultShortPrefixId: "fad", defaultStyleId: "solid", styleIds: ["solid", "regular", "light", "thin"], futureStyleIds: [], defaultFontWeight: 900 }], ["sharp", { defaultShortPrefixId: "fass", defaultStyleId: "solid", styleIds: ["solid", "regular", "light", "thin"], futureStyleIds: [], defaultFontWeight: 900 }], ["sharp-duotone", { defaultShortPrefixId: "fasds", defaultStyleId: "solid", styleIds: ["solid", "regular", "light", "thin"], futureStyleIds: [], defaultFontWeight: 900 }], ["chisel", { defaultShortPrefixId: "facr", defaultStyleId: "regular", styleIds: ["regular"], futureStyleIds: [], defaultFontWeight: 400 }], ["etch", { defaultShortPrefixId: "faes", defaultStyleId: "solid", styleIds: ["solid"], futureStyleIds: [], defaultFontWeight: 900 }], ["jelly", { defaultShortPrefixId: "fajr", defaultStyleId: "regular", styleIds: ["regular"], futureStyleIds: [], defaultFontWeight: 400 }], ["jelly-duo", { defaultShortPrefixId: "fajdr", defaultStyleId: "regular", styleIds: ["regular"], futureStyleIds: [], defaultFontWeight: 400 }], ["jelly-fill", { defaultShortPrefixId: "fajfr", defaultStyleId: "regular", styleIds: ["regular"], futureStyleIds: [], defaultFontWeight: 400 }], ["notdog", { defaultShortPrefixId: "fans", defaultStyleId: "solid", styleIds: ["solid"], futureStyleIds: [], defaultFontWeight: 900 }], ["notdog-duo", { defaultShortPrefixId: "fands", defaultStyleId: "solid", styleIds: ["solid"], futureStyleIds: [], defaultFontWeight: 900 }], ["slab", { defaultShortPrefixId: "faslr", defaultStyleId: "regular", styleIds: ["regular"], futureStyleIds: [], defaultFontWeight: 400 }], ["slab-press", { defaultShortPrefixId: "faslpr", defaultStyleId: "regular", styleIds: ["regular"], futureStyleIds: [], defaultFontWeight: 400 }], ["thumbprint", { defaultShortPrefixId: "fatl", defaultStyleId: "light", styleIds: ["light"], futureStyleIds: [], defaultFontWeight: 300 }], ["whiteboard", { defaultShortPrefixId: "fawsb", defaultStyleId: "semibold", styleIds: ["semibold"], futureStyleIds: [], defaultFontWeight: 600 }]]), Ro = { chisel: { regular: "facr" }, classic: { brands: "fab", light: "fal", regular: "far", solid: "fas", thin: "fat" }, duotone: { light: "fadl", regular: "fadr", solid: "fad", thin: "fadt" }, etch: { solid: "faes" }, jelly: { regular: "fajr" }, "jelly-duo": { regular: "fajdr" }, "jelly-fill": { regular: "fajfr" }, notdog: { solid: "fans" }, "notdog-duo": { solid: "fands" }, sharp: { light: "fasl", regular: "fasr", solid: "fass", thin: "fast" }, "sharp-duotone": { light: "fasdl", regular: "fasdr", solid: "fasds", thin: "fasdt" }, slab: { regular: "faslr" }, "slab-press": { regular: "faslpr" }, thumbprint: { light: "fatl" }, whiteboard: { semibold: "fawsb" } }, zo = ["fak", "fa-kit", "fakd", "fa-kit-duotone"], Oo = { kit: { fak: "kit", "fa-kit": "kit" }, "kit-duotone": { fakd: "kit-duotone", "fa-kit-duotone": "kit-duotone" } }, Go = ["kit"], D = "kit", r$2 = "kit-duotone", T = "Kit", C = "Kit Duotone";
_defineProperty$1(_defineProperty$1({}, D, T), r$2, C);
var Xo = { kit: { "fa-kit": "fak" }, "kit-duotone": { "fa-kit-duotone": "fakd" } }, lt$1 = { "Font Awesome Kit": { 400: "fak", normal: "fak" }, "Font Awesome Kit Duotone": { 400: "fakd", normal: "fakd" } }, et = { kit: { fak: "fa-kit" }, "kit-duotone": { fakd: "fa-kit-duotone" } }, dt = { kit: { kit: "fak" }, "kit-duotone": { "kit-duotone": "fakd" } }, _fl, l$1 = { GROUP: "duotone-group", SWAP_OPACITY: "swap-opacity", PRIMARY: "primary", SECONDARY: "secondary" }, i$1 = ["fa-classic", "fa-duotone", "fa-sharp", "fa-sharp-duotone", "fa-thumbprint", "fa-whiteboard", "fa-notdog", "fa-notdog-duo", "fa-chisel", "fa-etch", "fa-jelly", "fa-jelly-fill", "fa-jelly-duo", "fa-slab", "fa-slab-press"], f$1 = "classic", a$1 = "duotone", n$1 = "sharp", t$1$1 = "sharp-duotone", h$1 = "chisel", g$1$1 = "etch", u$1 = "jelly", s$1$1 = "jelly-duo", p$1$1 = "jelly-fill", y$1 = "notdog", e$1 = "notdog-duo", m$1$1 = "slab", c$1$1 = "slab-press", r$1$1 = "thumbprint", w$1$1 = "whiteboard", x$1$1 = "Classic", I$1$1 = "Duotone", b$1 = "Sharp", F$1$1 = "Sharp Duotone", v$1 = "Chisel", S$1$1 = "Etch", A$1$1 = "Jelly", j$1 = "Jelly Duo", P$1$1 = "Jelly Fill", B$1 = "Notdog", k$1 = "Notdog Duo", N$1 = "Slab", D$1 = "Slab Press", C$1 = "Thumbprint", T$1 = "Whiteboard";
_fl = {}, _defineProperty$1(_defineProperty$1(_defineProperty$1(_defineProperty$1(_defineProperty$1(_defineProperty$1(_defineProperty$1(_defineProperty$1(_defineProperty$1(_defineProperty$1(_fl, f$1, x$1$1), a$1, I$1$1), n$1, b$1), t$1$1, F$1$1), h$1, v$1), g$1$1, S$1$1), u$1, A$1$1), s$1$1, j$1), p$1$1, P$1$1), y$1, B$1), _defineProperty$1(_defineProperty$1(_defineProperty$1(_defineProperty$1(_defineProperty$1(_fl, e$1, k$1), m$1$1, N$1), c$1$1, D$1), r$1$1, C$1), w$1$1, T$1);
var L$1 = "kit", d$1 = "kit-duotone", R$1 = "Kit", W$1 = "Kit Duotone";
_defineProperty$1(_defineProperty$1({}, L$1, R$1), d$1, W$1);
var zo$1 = { classic: { "fa-brands": "fab", "fa-duotone": "fad", "fa-light": "fal", "fa-regular": "far", "fa-solid": "fas", "fa-thin": "fat" }, duotone: { "fa-regular": "fadr", "fa-light": "fadl", "fa-thin": "fadt" }, sharp: { "fa-solid": "fass", "fa-regular": "fasr", "fa-light": "fasl", "fa-thin": "fast" }, "sharp-duotone": { "fa-solid": "fasds", "fa-regular": "fasdr", "fa-light": "fasdl", "fa-thin": "fasdt" }, slab: { "fa-regular": "faslr" }, "slab-press": { "fa-regular": "faslpr" }, whiteboard: { "fa-semibold": "fawsb" }, thumbprint: { "fa-light": "fatl" }, notdog: { "fa-solid": "fans" }, "notdog-duo": { "fa-solid": "fands" }, etch: { "fa-solid": "faes" }, jelly: { "fa-regular": "fajr" }, "jelly-fill": { "fa-regular": "fajfr" }, "jelly-duo": { "fa-regular": "fajdr" }, chisel: { "fa-regular": "facr" } }, J$1 = { classic: ["fas", "far", "fal", "fat", "fad"], duotone: ["fadr", "fadl", "fadt"], sharp: ["fass", "fasr", "fasl", "fast"], "sharp-duotone": ["fasds", "fasdr", "fasdl", "fasdt"], slab: ["faslr"], "slab-press": ["faslpr"], whiteboard: ["fawsb"], thumbprint: ["fatl"], notdog: ["fans"], "notdog-duo": ["fands"], etch: ["faes"], jelly: ["fajr"], "jelly-fill": ["fajfr"], "jelly-duo": ["fajdr"], chisel: ["facr"] }, Go$1 = { classic: { fab: "fa-brands", fad: "fa-duotone", fal: "fa-light", far: "fa-regular", fas: "fa-solid", fat: "fa-thin" }, duotone: { fadr: "fa-regular", fadl: "fa-light", fadt: "fa-thin" }, sharp: { fass: "fa-solid", fasr: "fa-regular", fasl: "fa-light", fast: "fa-thin" }, "sharp-duotone": { fasds: "fa-solid", fasdr: "fa-regular", fasdl: "fa-light", fasdt: "fa-thin" }, slab: { faslr: "fa-regular" }, "slab-press": { faslpr: "fa-regular" }, whiteboard: { fawsb: "fa-semibold" }, thumbprint: { fatl: "fa-light" }, notdog: { fans: "fa-solid" }, "notdog-duo": { fands: "fa-solid" }, etch: { faes: "fa-solid" }, jelly: { fajr: "fa-regular" }, "jelly-fill": { fajfr: "fa-regular" }, "jelly-duo": { fajdr: "fa-regular" }, chisel: { facr: "fa-regular" } }, E$1 = ["fa-solid", "fa-regular", "fa-light", "fa-thin", "fa-duotone", "fa-brands", "fa-semibold"], $o$1 = ["fa", "fas", "far", "fal", "fat", "fad", "fadr", "fadl", "fadt", "fab", "fass", "fasr", "fasl", "fast", "fasds", "fasdr", "fasdl", "fasdt", "faslr", "faslpr", "fawsb", "fatl", "fans", "fands", "faes", "fajr", "fajfr", "fajdr", "facr"].concat(i$1, E$1), _$1 = ["solid", "regular", "light", "thin", "duotone", "brands", "semibold"], K$1 = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10], M$1 = K$1.concat([11, 12, 13, 14, 15, 16, 17, 18, 19, 20]), O$1 = ["aw", "fw", "pull-left", "pull-right"], Ho$1 = [].concat(_toConsumableArray(Object.keys(J$1)), _$1, O$1, ["2xs", "xs", "sm", "lg", "xl", "2xl", "beat", "border", "fade", "beat-fade", "bounce", "flip-both", "flip-horizontal", "flip-vertical", "flip", "inverse", "layers", "layers-bottom-left", "layers-bottom-right", "layers-counter", "layers-text", "layers-top-left", "layers-top-right", "li", "pull-end", "pull-start", "pulse", "rotate-180", "rotate-270", "rotate-90", "rotate-by", "shake", "spin-pulse", "spin-reverse", "spin", "stack-1x", "stack-2x", "stack", "ul", "width-auto", "width-fixed", l$1.GROUP, l$1.SWAP_OPACITY, l$1.PRIMARY, l$1.SECONDARY]).concat(K$1.map(function(t18) {
  return "".concat(t18, "x");
})).concat(M$1.map(function(t18) {
  return "w-".concat(t18);
})), oa = { "Font Awesome 5 Free": { 900: "fas", 400: "far" }, "Font Awesome 5 Pro": { 900: "fas", 400: "far", normal: "far", 300: "fal" }, "Font Awesome 5 Brands": { 400: "fab", normal: "fab" }, "Font Awesome 5 Duotone": { 900: "fad" } }, NAMESPACE_IDENTIFIER$1 = "___FONT_AWESOME___", UNITS_IN_GRID$1 = 16, DEFAULT_CSS_PREFIX$1 = "fa", DEFAULT_REPLACEMENT_CLASS$1 = "svg-inline--fa", DATA_FA_I2SVG$1 = "data-fa-i2svg", DATA_FA_PSEUDO_ELEMENT$1 = "data-fa-pseudo-element", DATA_FA_PSEUDO_ELEMENT_PENDING$1 = "data-fa-pseudo-element-pending", DATA_PREFIX$1 = "data-prefix", DATA_ICON$1 = "data-icon", HTML_CLASS_I2SVG_BASE_CLASS$1 = "fontawesome-i2svg", MUTATION_APPROACH_ASYNC$1 = "async", TAGNAMES_TO_SKIP_FOR_PSEUDOELEMENTS$1 = ["HTML", "HEAD", "STYLE", "SCRIPT"], PSEUDO_ELEMENTS = ["::before", "::after", ":before", ":after"], PRODUCTION$3 = function() {
  try {
    return "production" === process.env.NODE_ENV;
  } catch (t18) {
    return false;
  }
}();
function familyProxy$1(t18) {
  return new Proxy(t18, { get: function(t19, e2) {
    return e2 in t19 ? t19[e2] : t19[a];
  } });
}
var _PREFIX_TO_STYLE$1 = _objectSpread2$1({}, z);
_PREFIX_TO_STYLE$1[a] = _objectSpread2$1(_objectSpread2$1(_objectSpread2$1(_objectSpread2$1({}, { "fa-duotone": "duotone" }), z[a]), Oo.kit), Oo["kit-duotone"]);
var PREFIX_TO_STYLE$1 = familyProxy$1(_PREFIX_TO_STYLE$1), _STYLE_TO_PREFIX$1 = _objectSpread2$1({}, Ro);
_STYLE_TO_PREFIX$1[a] = _objectSpread2$1(_objectSpread2$1(_objectSpread2$1(_objectSpread2$1({}, { duotone: "fad" }), _STYLE_TO_PREFIX$1[a]), dt.kit), dt["kit-duotone"]);
var STYLE_TO_PREFIX$1 = familyProxy$1(_STYLE_TO_PREFIX$1), _PREFIX_TO_LONG_STYLE$1 = _objectSpread2$1({}, Go$1);
_PREFIX_TO_LONG_STYLE$1[a] = _objectSpread2$1(_objectSpread2$1({}, _PREFIX_TO_LONG_STYLE$1[a]), et.kit);
var PREFIX_TO_LONG_STYLE$1 = familyProxy$1(_PREFIX_TO_LONG_STYLE$1), _LONG_STYLE_TO_PREFIX$1 = _objectSpread2$1({}, zo$1);
_LONG_STYLE_TO_PREFIX$1[a] = _objectSpread2$1(_objectSpread2$1({}, _LONG_STYLE_TO_PREFIX$1[a]), Xo.kit), familyProxy$1(_LONG_STYLE_TO_PREFIX$1);
var ICON_SELECTION_SYNTAX_PATTERN$1 = K, LAYERS_TEXT_CLASSNAME$1 = "fa-layers-text", FONT_FAMILY_PATTERN$1 = W, _FONT_WEIGHT_TO_PREFIX$1 = _objectSpread2$1({}, io);
familyProxy$1(_FONT_WEIGHT_TO_PREFIX$1);
var ATTRIBUTES_WATCHED_FOR_MUTATION$1 = ["class", "data-prefix", "data-icon", "data-fa-transform", "data-fa-mask"], DUOTONE_CLASSES$1 = O, RESERVED_CLASSES$1 = [].concat(_toConsumableArray(Go), _toConsumableArray(Ho$1)), initial$1 = WINDOW$1.FontAwesomeConfig || {};
function getAttrConfig$1(t18) {
  var e2 = DOCUMENT$1.querySelector("script[" + t18 + "]");
  if (e2) return e2.getAttribute(t18);
}
function coerce$1(t18) {
  return "" === t18 || "false" !== t18 && ("true" === t18 || t18);
}
if (DOCUMENT$1 && "function" == typeof DOCUMENT$1.querySelector) {
  var attrs = [["data-family-prefix", "familyPrefix"], ["data-css-prefix", "cssPrefix"], ["data-family-default", "familyDefault"], ["data-style-default", "styleDefault"], ["data-replacement-class", "replacementClass"], ["data-auto-replace-svg", "autoReplaceSvg"], ["data-auto-add-css", "autoAddCss"], ["data-search-pseudo-elements", "searchPseudoElements"], ["data-search-pseudo-elements-warnings", "searchPseudoElementsWarnings"], ["data-search-pseudo-elements-full-scan", "searchPseudoElementsFullScan"], ["data-observe-mutations", "observeMutations"], ["data-mutate-approach", "mutateApproach"], ["data-keep-original-source", "keepOriginalSource"], ["data-measure-performance", "measurePerformance"], ["data-show-missing-icons", "showMissingIcons"]];
  attrs.forEach(function(t18) {
    var e2 = _slicedToArray(t18, 2), n2 = e2[0], o2 = e2[1], i2 = coerce$1(getAttrConfig$1(n2));
    null != i2 && (initial$1[o2] = i2);
  });
}
var _default$1 = { styleDefault: "solid", familyDefault: a, cssPrefix: DEFAULT_CSS_PREFIX$1, replacementClass: DEFAULT_REPLACEMENT_CLASS$1, autoReplaceSvg: true, autoAddCss: true, searchPseudoElements: false, searchPseudoElementsWarnings: true, searchPseudoElementsFullScan: false, observeMutations: true, mutateApproach: "async", keepOriginalSource: true, measurePerformance: false, showMissingIcons: true };
initial$1.familyPrefix && (initial$1.cssPrefix = initial$1.familyPrefix);
var _config$1 = _objectSpread2$1(_objectSpread2$1({}, _default$1), initial$1);
_config$1.autoReplaceSvg || (_config$1.observeMutations = false);
var config$1 = {};
Object.keys(_default$1).forEach(function(t18) {
  Object.defineProperty(config$1, t18, { enumerable: true, set: function(e2) {
    _config$1[t18] = e2, _onChangeCb$1.forEach(function(t19) {
      return t19(config$1);
    });
  }, get: function() {
    return _config$1[t18];
  } });
}), Object.defineProperty(config$1, "familyPrefix", { enumerable: true, set: function(t18) {
  _config$1.cssPrefix = t18, _onChangeCb$1.forEach(function(t19) {
    return t19(config$1);
  });
}, get: function() {
  return _config$1.cssPrefix;
} }), WINDOW$1.FontAwesomeConfig = config$1;
var _onChangeCb$1 = [];
function onChange$1(t18) {
  return _onChangeCb$1.push(t18), function() {
    _onChangeCb$1.splice(_onChangeCb$1.indexOf(t18), 1);
  };
}
var d$2$1 = UNITS_IN_GRID$1, meaninglessTransform$1 = { size: 16, x: 0, y: 0, rotate: 0, flipX: false, flipY: false };
function insertCss$1(t18) {
  if (t18 && IS_DOM$1) {
    var e2 = DOCUMENT$1.createElement("style");
    e2.setAttribute("type", "text/css"), e2.innerHTML = t18;
    for (var n2 = DOCUMENT$1.head.childNodes, o2 = null, i2 = n2.length - 1; i2 > -1; i2--) {
      var r2 = n2[i2], a2 = (r2.tagName || "").toUpperCase();
      ["STYLE", "LINK"].indexOf(a2) > -1 && (o2 = r2);
    }
    return DOCUMENT$1.head.insertBefore(e2, o2), t18;
  }
}
var idPool$1 = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
function nextUniqueId$1() {
  for (var t18 = 12, e2 = ""; t18-- > 0; ) e2 += idPool$1[62 * Math.random() | 0];
  return e2;
}
function toArray$1(t18) {
  for (var e2 = [], n2 = (t18 || []).length >>> 0; n2--; ) e2[n2] = t18[n2];
  return e2;
}
function classArray$1(t18) {
  return t18.classList ? toArray$1(t18.classList) : (t18.getAttribute("class") || "").split(" ").filter(function(t19) {
    return t19;
  });
}
function htmlEscape$1(t18) {
  return "".concat(t18).replace(/&/g, "&amp;").replace(/"/g, "&quot;").replace(/'/g, "&#39;").replace(/</g, "&lt;").replace(/>/g, "&gt;");
}
function joinAttributes$1(t18) {
  return Object.keys(t18 || {}).reduce(function(e2, n2) {
    return e2 + "".concat(n2, '="').concat(htmlEscape$1(t18[n2]), '" ');
  }, "").trim();
}
function joinStyles$1(t18) {
  return Object.keys(t18 || {}).reduce(function(e2, n2) {
    return e2 + "".concat(n2, ": ").concat(t18[n2].trim(), ";");
  }, "");
}
function transformIsMeaningful$1(t18) {
  return t18.size !== meaninglessTransform$1.size || t18.x !== meaninglessTransform$1.x || t18.y !== meaninglessTransform$1.y || t18.rotate !== meaninglessTransform$1.rotate || t18.flipX || t18.flipY;
}
function transformForSvg$1(t18) {
  var e2 = t18.transform, n2 = t18.containerWidth, o2 = t18.iconWidth, i2 = { transform: "translate(".concat(n2 / 2, " 256)") }, r2 = "translate(".concat(32 * e2.x, ", ").concat(32 * e2.y, ") "), a2 = "scale(".concat(e2.size / 16 * (e2.flipX ? -1 : 1), ", ").concat(e2.size / 16 * (e2.flipY ? -1 : 1), ") "), s2 = "rotate(".concat(e2.rotate, " 0 0)");
  return { outer: i2, inner: { transform: "".concat(r2, " ").concat(a2, " ").concat(s2) }, path: { transform: "translate(".concat(o2 / 2 * -1, " -256)") } };
}
function transformForCss$1(t18) {
  var e2 = t18.transform, n2 = t18.width, o2 = void 0 === n2 ? UNITS_IN_GRID$1 : n2, i2 = t18.height, r2 = void 0 === i2 ? UNITS_IN_GRID$1 : i2, a2 = t18.startCentered, s2 = void 0 !== a2 && a2, c2 = "";
  return c2 += s2 && IS_IE$1 ? "translate(".concat(e2.x / d$2$1 - o2 / 2, "em, ").concat(e2.y / d$2$1 - r2 / 2, "em) ") : s2 ? "translate(calc(-50% + ".concat(e2.x / d$2$1, "em), calc(-50% + ").concat(e2.y / d$2$1, "em)) ") : "translate(".concat(e2.x / d$2$1, "em, ").concat(e2.y / d$2$1, "em) "), c2 += "scale(".concat(e2.size / d$2$1 * (e2.flipX ? -1 : 1), ", ").concat(e2.size / d$2$1 * (e2.flipY ? -1 : 1), ") "), c2 += "rotate(".concat(e2.rotate, "deg) ");
}
var baseStyles$1 = `:root, :host {
  --fa-font-solid: normal 900 1em/1 "Font Awesome 7 Free";
  --fa-font-regular: normal 400 1em/1 "Font Awesome 7 Free";
  --fa-font-light: normal 300 1em/1 "Font Awesome 7 Pro";
  --fa-font-thin: normal 100 1em/1 "Font Awesome 7 Pro";
  --fa-font-duotone: normal 900 1em/1 "Font Awesome 7 Duotone";
  --fa-font-duotone-regular: normal 400 1em/1 "Font Awesome 7 Duotone";
  --fa-font-duotone-light: normal 300 1em/1 "Font Awesome 7 Duotone";
  --fa-font-duotone-thin: normal 100 1em/1 "Font Awesome 7 Duotone";
  --fa-font-brands: normal 400 1em/1 "Font Awesome 7 Brands";
  --fa-font-sharp-solid: normal 900 1em/1 "Font Awesome 7 Sharp";
  --fa-font-sharp-regular: normal 400 1em/1 "Font Awesome 7 Sharp";
  --fa-font-sharp-light: normal 300 1em/1 "Font Awesome 7 Sharp";
  --fa-font-sharp-thin: normal 100 1em/1 "Font Awesome 7 Sharp";
  --fa-font-sharp-duotone-solid: normal 900 1em/1 "Font Awesome 7 Sharp Duotone";
  --fa-font-sharp-duotone-regular: normal 400 1em/1 "Font Awesome 7 Sharp Duotone";
  --fa-font-sharp-duotone-light: normal 300 1em/1 "Font Awesome 7 Sharp Duotone";
  --fa-font-sharp-duotone-thin: normal 100 1em/1 "Font Awesome 7 Sharp Duotone";
  --fa-font-slab-regular: normal 400 1em/1 "Font Awesome 7 Slab";
  --fa-font-slab-press-regular: normal 400 1em/1 "Font Awesome 7 Slab Press";
  --fa-font-whiteboard-semibold: normal 600 1em/1 "Font Awesome 7 Whiteboard";
  --fa-font-thumbprint-light: normal 300 1em/1 "Font Awesome 7 Thumbprint";
  --fa-font-notdog-solid: normal 900 1em/1 "Font Awesome 7 Notdog";
  --fa-font-notdog-duo-solid: normal 900 1em/1 "Font Awesome 7 Notdog Duo";
  --fa-font-etch-solid: normal 900 1em/1 "Font Awesome 7 Etch";
  --fa-font-jelly-regular: normal 400 1em/1 "Font Awesome 7 Jelly";
  --fa-font-jelly-fill-regular: normal 400 1em/1 "Font Awesome 7 Jelly Fill";
  --fa-font-jelly-duo-regular: normal 400 1em/1 "Font Awesome 7 Jelly Duo";
  --fa-font-chisel-regular: normal 400 1em/1 "Font Awesome 7 Chisel";
}

.svg-inline--fa {
  box-sizing: content-box;
  display: var(--fa-display, inline-block);
  height: 1em;
  overflow: visible;
  vertical-align: -0.125em;
  width: var(--fa-width, 1.25em);
}
.svg-inline--fa.fa-2xs {
  vertical-align: 0.1em;
}
.svg-inline--fa.fa-xs {
  vertical-align: 0em;
}
.svg-inline--fa.fa-sm {
  vertical-align: -0.0714285714em;
}
.svg-inline--fa.fa-lg {
  vertical-align: -0.2em;
}
.svg-inline--fa.fa-xl {
  vertical-align: -0.25em;
}
.svg-inline--fa.fa-2xl {
  vertical-align: -0.3125em;
}
.svg-inline--fa.fa-pull-left,
.svg-inline--fa .fa-pull-start {
  float: inline-start;
  margin-inline-end: var(--fa-pull-margin, 0.3em);
}
.svg-inline--fa.fa-pull-right,
.svg-inline--fa .fa-pull-end {
  float: inline-end;
  margin-inline-start: var(--fa-pull-margin, 0.3em);
}
.svg-inline--fa.fa-li {
  width: var(--fa-li-width, 2em);
  inset-inline-start: calc(-1 * var(--fa-li-width, 2em));
  inset-block-start: 0.25em; /* syncing vertical alignment with Web Font rendering */
}

.fa-layers-counter, .fa-layers-text {
  display: inline-block;
  position: absolute;
  text-align: center;
}

.fa-layers {
  display: inline-block;
  height: 1em;
  position: relative;
  text-align: center;
  vertical-align: -0.125em;
  width: var(--fa-width, 1.25em);
}
.fa-layers .svg-inline--fa {
  inset: 0;
  margin: auto;
  position: absolute;
  transform-origin: center center;
}

.fa-layers-text {
  left: 50%;
  top: 50%;
  transform: translate(-50%, -50%);
  transform-origin: center center;
}

.fa-layers-counter {
  background-color: var(--fa-counter-background-color, #ff253a);
  border-radius: var(--fa-counter-border-radius, 1em);
  box-sizing: border-box;
  color: var(--fa-inverse, #fff);
  line-height: var(--fa-counter-line-height, 1);
  max-width: var(--fa-counter-max-width, 5em);
  min-width: var(--fa-counter-min-width, 1.5em);
  overflow: hidden;
  padding: var(--fa-counter-padding, 0.25em 0.5em);
  right: var(--fa-right, 0);
  text-overflow: ellipsis;
  top: var(--fa-top, 0);
  transform: scale(var(--fa-counter-scale, 0.25));
  transform-origin: top right;
}

.fa-layers-bottom-right {
  bottom: var(--fa-bottom, 0);
  right: var(--fa-right, 0);
  top: auto;
  transform: scale(var(--fa-layers-scale, 0.25));
  transform-origin: bottom right;
}

.fa-layers-bottom-left {
  bottom: var(--fa-bottom, 0);
  left: var(--fa-left, 0);
  right: auto;
  top: auto;
  transform: scale(var(--fa-layers-scale, 0.25));
  transform-origin: bottom left;
}

.fa-layers-top-right {
  top: var(--fa-top, 0);
  right: var(--fa-right, 0);
  transform: scale(var(--fa-layers-scale, 0.25));
  transform-origin: top right;
}

.fa-layers-top-left {
  left: var(--fa-left, 0);
  right: auto;
  top: var(--fa-top, 0);
  transform: scale(var(--fa-layers-scale, 0.25));
  transform-origin: top left;
}

.fa-1x {
  font-size: 1em;
}

.fa-2x {
  font-size: 2em;
}

.fa-3x {
  font-size: 3em;
}

.fa-4x {
  font-size: 4em;
}

.fa-5x {
  font-size: 5em;
}

.fa-6x {
  font-size: 6em;
}

.fa-7x {
  font-size: 7em;
}

.fa-8x {
  font-size: 8em;
}

.fa-9x {
  font-size: 9em;
}

.fa-10x {
  font-size: 10em;
}

.fa-2xs {
  font-size: calc(10 / 16 * 1em); /* converts a 10px size into an em-based value that's relative to the scale's 16px base */
  line-height: calc(1 / 10 * 1em); /* sets the line-height of the icon back to that of it's parent */
  vertical-align: calc((6 / 10 - 0.375) * 1em); /* vertically centers the icon taking into account the surrounding text's descender */
}

.fa-xs {
  font-size: calc(12 / 16 * 1em); /* converts a 12px size into an em-based value that's relative to the scale's 16px base */
  line-height: calc(1 / 12 * 1em); /* sets the line-height of the icon back to that of it's parent */
  vertical-align: calc((6 / 12 - 0.375) * 1em); /* vertically centers the icon taking into account the surrounding text's descender */
}

.fa-sm {
  font-size: calc(14 / 16 * 1em); /* converts a 14px size into an em-based value that's relative to the scale's 16px base */
  line-height: calc(1 / 14 * 1em); /* sets the line-height of the icon back to that of it's parent */
  vertical-align: calc((6 / 14 - 0.375) * 1em); /* vertically centers the icon taking into account the surrounding text's descender */
}

.fa-lg {
  font-size: calc(20 / 16 * 1em); /* converts a 20px size into an em-based value that's relative to the scale's 16px base */
  line-height: calc(1 / 20 * 1em); /* sets the line-height of the icon back to that of it's parent */
  vertical-align: calc((6 / 20 - 0.375) * 1em); /* vertically centers the icon taking into account the surrounding text's descender */
}

.fa-xl {
  font-size: calc(24 / 16 * 1em); /* converts a 24px size into an em-based value that's relative to the scale's 16px base */
  line-height: calc(1 / 24 * 1em); /* sets the line-height of the icon back to that of it's parent */
  vertical-align: calc((6 / 24 - 0.375) * 1em); /* vertically centers the icon taking into account the surrounding text's descender */
}

.fa-2xl {
  font-size: calc(32 / 16 * 1em); /* converts a 32px size into an em-based value that's relative to the scale's 16px base */
  line-height: calc(1 / 32 * 1em); /* sets the line-height of the icon back to that of it's parent */
  vertical-align: calc((6 / 32 - 0.375) * 1em); /* vertically centers the icon taking into account the surrounding text's descender */
}

.fa-width-auto {
  --fa-width: auto;
}

.fa-fw,
.fa-width-fixed {
  --fa-width: 1.25em;
}

.fa-ul {
  list-style-type: none;
  margin-inline-start: var(--fa-li-margin, 2.5em);
  padding-inline-start: 0;
}
.fa-ul > li {
  position: relative;
}

.fa-li {
  inset-inline-start: calc(-1 * var(--fa-li-width, 2em));
  position: absolute;
  text-align: center;
  width: var(--fa-li-width, 2em);
  line-height: inherit;
}

/* Heads Up: Bordered Icons will not be supported in the future!
  - This feature will be deprecated in the next major release of Font Awesome (v8)!
  - You may continue to use it in this version *v7), but it will not be supported in Font Awesome v8.
*/
/* Notes:
* --@{v.$css-prefix}-border-width = 1/16 by default (to render as ~1px based on a 16px default font-size)
* --@{v.$css-prefix}-border-padding =
  ** 3/16 for vertical padding (to give ~2px of vertical whitespace around an icon considering it's vertical alignment)
  ** 4/16 for horizontal padding (to give ~4px of horizontal whitespace around an icon)
*/
.fa-border {
  border-color: var(--fa-border-color, #eee);
  border-radius: var(--fa-border-radius, 0.1em);
  border-style: var(--fa-border-style, solid);
  border-width: var(--fa-border-width, 0.0625em);
  box-sizing: var(--fa-border-box-sizing, content-box);
  padding: var(--fa-border-padding, 0.1875em 0.25em);
}

.fa-pull-left,
.fa-pull-start {
  float: inline-start;
  margin-inline-end: var(--fa-pull-margin, 0.3em);
}

.fa-pull-right,
.fa-pull-end {
  float: inline-end;
  margin-inline-start: var(--fa-pull-margin, 0.3em);
}

.fa-beat {
  animation-name: fa-beat;
  animation-delay: var(--fa-animation-delay, 0s);
  animation-direction: var(--fa-animation-direction, normal);
  animation-duration: var(--fa-animation-duration, 1s);
  animation-iteration-count: var(--fa-animation-iteration-count, infinite);
  animation-timing-function: var(--fa-animation-timing, ease-in-out);
}

.fa-bounce {
  animation-name: fa-bounce;
  animation-delay: var(--fa-animation-delay, 0s);
  animation-direction: var(--fa-animation-direction, normal);
  animation-duration: var(--fa-animation-duration, 1s);
  animation-iteration-count: var(--fa-animation-iteration-count, infinite);
  animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.28, 0.84, 0.42, 1));
}

.fa-fade {
  animation-name: fa-fade;
  animation-delay: var(--fa-animation-delay, 0s);
  animation-direction: var(--fa-animation-direction, normal);
  animation-duration: var(--fa-animation-duration, 1s);
  animation-iteration-count: var(--fa-animation-iteration-count, infinite);
  animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.4, 0, 0.6, 1));
}

.fa-beat-fade {
  animation-name: fa-beat-fade;
  animation-delay: var(--fa-animation-delay, 0s);
  animation-direction: var(--fa-animation-direction, normal);
  animation-duration: var(--fa-animation-duration, 1s);
  animation-iteration-count: var(--fa-animation-iteration-count, infinite);
  animation-timing-function: var(--fa-animation-timing, cubic-bezier(0.4, 0, 0.6, 1));
}

.fa-flip {
  animation-name: fa-flip;
  animation-delay: var(--fa-animation-delay, 0s);
  animation-direction: var(--fa-animation-direction, normal);
  animation-duration: var(--fa-animation-duration, 1s);
  animation-iteration-count: var(--fa-animation-iteration-count, infinite);
  animation-timing-function: var(--fa-animation-timing, ease-in-out);
}

.fa-shake {
  animation-name: fa-shake;
  animation-delay: var(--fa-animation-delay, 0s);
  animation-direction: var(--fa-animation-direction, normal);
  animation-duration: var(--fa-animation-duration, 1s);
  animation-iteration-count: var(--fa-animation-iteration-count, infinite);
  animation-timing-function: var(--fa-animation-timing, linear);
}

.fa-spin {
  animation-name: fa-spin;
  animation-delay: var(--fa-animation-delay, 0s);
  animation-direction: var(--fa-animation-direction, normal);
  animation-duration: var(--fa-animation-duration, 2s);
  animation-iteration-count: var(--fa-animation-iteration-count, infinite);
  animation-timing-function: var(--fa-animation-timing, linear);
}

.fa-spin-reverse {
  --fa-animation-direction: reverse;
}

.fa-pulse,
.fa-spin-pulse {
  animation-name: fa-spin;
  animation-direction: var(--fa-animation-direction, normal);
  animation-duration: var(--fa-animation-duration, 1s);
  animation-iteration-count: var(--fa-animation-iteration-count, infinite);
  animation-timing-function: var(--fa-animation-timing, steps(8));
}

@media (prefers-reduced-motion: reduce) {
  .fa-beat,
  .fa-bounce,
  .fa-fade,
  .fa-beat-fade,
  .fa-flip,
  .fa-pulse,
  .fa-shake,
  .fa-spin,
  .fa-spin-pulse {
    animation: none !important;
    transition: none !important;
  }
}
@keyframes fa-beat {
  0%, 90% {
    transform: scale(1);
  }
  45% {
    transform: scale(var(--fa-beat-scale, 1.25));
  }
}
@keyframes fa-bounce {
  0% {
    transform: scale(1, 1) translateY(0);
  }
  10% {
    transform: scale(var(--fa-bounce-start-scale-x, 1.1), var(--fa-bounce-start-scale-y, 0.9)) translateY(0);
  }
  30% {
    transform: scale(var(--fa-bounce-jump-scale-x, 0.9), var(--fa-bounce-jump-scale-y, 1.1)) translateY(var(--fa-bounce-height, -0.5em));
  }
  50% {
    transform: scale(var(--fa-bounce-land-scale-x, 1.05), var(--fa-bounce-land-scale-y, 0.95)) translateY(0);
  }
  57% {
    transform: scale(1, 1) translateY(var(--fa-bounce-rebound, -0.125em));
  }
  64% {
    transform: scale(1, 1) translateY(0);
  }
  100% {
    transform: scale(1, 1) translateY(0);
  }
}
@keyframes fa-fade {
  50% {
    opacity: var(--fa-fade-opacity, 0.4);
  }
}
@keyframes fa-beat-fade {
  0%, 100% {
    opacity: var(--fa-beat-fade-opacity, 0.4);
    transform: scale(1);
  }
  50% {
    opacity: 1;
    transform: scale(var(--fa-beat-fade-scale, 1.125));
  }
}
@keyframes fa-flip {
  50% {
    transform: rotate3d(var(--fa-flip-x, 0), var(--fa-flip-y, 1), var(--fa-flip-z, 0), var(--fa-flip-angle, -180deg));
  }
}
@keyframes fa-shake {
  0% {
    transform: rotate(-15deg);
  }
  4% {
    transform: rotate(15deg);
  }
  8%, 24% {
    transform: rotate(-18deg);
  }
  12%, 28% {
    transform: rotate(18deg);
  }
  16% {
    transform: rotate(-22deg);
  }
  20% {
    transform: rotate(22deg);
  }
  32% {
    transform: rotate(-12deg);
  }
  36% {
    transform: rotate(12deg);
  }
  40%, 100% {
    transform: rotate(0deg);
  }
}
@keyframes fa-spin {
  0% {
    transform: rotate(0deg);
  }
  100% {
    transform: rotate(360deg);
  }
}
.fa-rotate-90 {
  transform: rotate(90deg);
}

.fa-rotate-180 {
  transform: rotate(180deg);
}

.fa-rotate-270 {
  transform: rotate(270deg);
}

.fa-flip-horizontal {
  transform: scale(-1, 1);
}

.fa-flip-vertical {
  transform: scale(1, -1);
}

.fa-flip-both,
.fa-flip-horizontal.fa-flip-vertical {
  transform: scale(-1, -1);
}

.fa-rotate-by {
  transform: rotate(var(--fa-rotate-angle, 0));
}

.svg-inline--fa .fa-primary {
  fill: var(--fa-primary-color, currentColor);
  opacity: var(--fa-primary-opacity, 1);
}

.svg-inline--fa .fa-secondary {
  fill: var(--fa-secondary-color, currentColor);
  opacity: var(--fa-secondary-opacity, 0.4);
}

.svg-inline--fa.fa-swap-opacity .fa-primary {
  opacity: var(--fa-secondary-opacity, 0.4);
}

.svg-inline--fa.fa-swap-opacity .fa-secondary {
  opacity: var(--fa-primary-opacity, 1);
}

.svg-inline--fa mask .fa-primary,
.svg-inline--fa mask .fa-secondary {
  fill: black;
}

.svg-inline--fa.fa-inverse {
  fill: var(--fa-inverse, #fff);
}

.fa-stack {
  display: inline-block;
  height: 2em;
  line-height: 2em;
  position: relative;
  vertical-align: middle;
  width: 2.5em;
}

.fa-inverse {
  color: var(--fa-inverse, #fff);
}

.svg-inline--fa.fa-stack-1x {
  --fa-width: 1.25em;
  height: 1em;
  width: var(--fa-width);
}
.svg-inline--fa.fa-stack-2x {
  --fa-width: 2.5em;
  height: 2em;
  width: var(--fa-width);
}

.fa-stack-1x,
.fa-stack-2x {
  inset: 0;
  margin: auto;
  position: absolute;
  z-index: var(--fa-stack-z-index, auto);
}`;
function css$1() {
  var t18 = DEFAULT_CSS_PREFIX$1, e2 = DEFAULT_REPLACEMENT_CLASS$1, n2 = config$1.cssPrefix, o2 = config$1.replacementClass, i2 = baseStyles$1;
  if (n2 !== t18 || o2 !== e2) {
    var r2 = new RegExp("\\.".concat(t18, "\\-"), "g"), a2 = new RegExp("\\--".concat(t18, "\\-"), "g"), s2 = new RegExp("\\.".concat(e2), "g");
    i2 = i2.replace(r2, ".".concat(n2, "-")).replace(a2, "--".concat(n2, "-")).replace(s2, ".".concat(o2));
  }
  return i2;
}
var _cssInserted$1 = false;
function ensureCss$1() {
  config$1.autoAddCss && !_cssInserted$1 && (insertCss$1(css$1()), _cssInserted$1 = true);
}
var InjectCSS$1 = { mixout: function() {
  return { dom: { css: css$1, insertCss: ensureCss$1 } };
}, hooks: function() {
  return { beforeDOMElementCreation: function() {
    ensureCss$1();
  }, beforeI2svg: function() {
    ensureCss$1();
  } };
} }, w$2 = WINDOW$1 || {};
w$2[NAMESPACE_IDENTIFIER$1] || (w$2[NAMESPACE_IDENTIFIER$1] = {}), w$2[NAMESPACE_IDENTIFIER$1].styles || (w$2[NAMESPACE_IDENTIFIER$1].styles = {}), w$2[NAMESPACE_IDENTIFIER$1].hooks || (w$2[NAMESPACE_IDENTIFIER$1].hooks = {}), w$2[NAMESPACE_IDENTIFIER$1].shims || (w$2[NAMESPACE_IDENTIFIER$1].shims = []);
var namespace$1 = w$2[NAMESPACE_IDENTIFIER$1], functions$1 = [], _listener = function() {
  DOCUMENT$1.removeEventListener("DOMContentLoaded", _listener), loaded$1 = 1, functions$1.map(function(t18) {
    return t18();
  });
}, loaded$1 = false;
function domready$1(t18) {
  IS_DOM$1 && (loaded$1 ? setTimeout(t18, 0) : functions$1.push(t18));
}
function toHtml$1(t18) {
  var e2 = t18.tag, n2 = t18.attributes, o2 = void 0 === n2 ? {} : n2, i2 = t18.children, r2 = void 0 === i2 ? [] : i2;
  return "string" == typeof t18 ? htmlEscape$1(t18) : "<".concat(e2, " ").concat(joinAttributes$1(o2), ">").concat(r2.map(toHtml$1).join(""), "</").concat(e2, ">");
}
function iconFromMapping$1(t18, e2, n2) {
  if (t18 && t18[e2] && t18[e2][n2]) return { prefix: e2, iconName: n2, icon: t18[e2][n2] };
}
IS_DOM$1 && (loaded$1 = (DOCUMENT$1.documentElement.doScroll ? /^loaded|^c/ : /^loaded|^i|^c/).test(DOCUMENT$1.readyState), loaded$1 || DOCUMENT$1.addEventListener("DOMContentLoaded", _listener));
var reduce$1 = function(t18, e2, n2, o2) {
  var i2, r2, a2, s2 = Object.keys(t18), c2 = s2.length, l2 = e2;
  for (void 0 === n2 ? (i2 = 1, a2 = t18[s2[0]]) : (i2 = 0, a2 = n2); i2 < c2; i2++) a2 = l2(a2, t18[r2 = s2[i2]], r2, t18);
  return a2;
};
function toHex$1(t18) {
  return 1 !== _toConsumableArray(t18).length ? null : t18.codePointAt(0).toString(16);
}
function normalizeIcons$1(t18) {
  return Object.keys(t18).reduce(function(e2, n2) {
    var o2 = t18[n2];
    return !!o2.icon ? e2[o2.iconName] = o2.icon : e2[n2] = o2, e2;
  }, {});
}
function defineIcons$1(t18, e2) {
  var n2 = (arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {}).skipHooks, o2 = void 0 !== n2 && n2, i2 = normalizeIcons$1(e2);
  "function" != typeof namespace$1.hooks.addPack || o2 ? namespace$1.styles[t18] = _objectSpread2$1(_objectSpread2$1({}, namespace$1.styles[t18] || {}), i2) : namespace$1.hooks.addPack(t18, normalizeIcons$1(e2)), "fas" === t18 && defineIcons$1("fa", e2);
}
var styles$3 = namespace$1.styles, shims$1 = namespace$1.shims, FAMILY_NAMES$1 = Object.keys(PREFIX_TO_LONG_STYLE$1), PREFIXES_FOR_FAMILY$1 = FAMILY_NAMES$1.reduce(function(t18, e2) {
  return t18[e2] = Object.keys(PREFIX_TO_LONG_STYLE$1[e2]), t18;
}, {}), _defaultUsablePrefix$1 = null, _byUnicode$1 = {}, _byLigature$1 = {}, _byOldName$1 = {}, _byOldUnicode$1 = {}, _byAlias$1 = {};
function isReserved$1(t18) {
  return ~RESERVED_CLASSES$1.indexOf(t18);
}
function getIconName$1(t18, e2) {
  var n2 = e2.split("-"), o2 = n2[0], i2 = n2.slice(1).join("-");
  return o2 !== t18 || "" === i2 || isReserved$1(i2) ? null : i2;
}
var build$1 = function() {
  var t18 = function(t19) {
    return reduce$1(styles$3, function(e3, n3, o2) {
      return e3[o2] = reduce$1(n3, t19, {}), e3;
    }, {});
  };
  _byUnicode$1 = t18(function(t19, e3, n3) {
    (e3[3] && (t19[e3[3]] = n3), e3[2]) && e3[2].filter(function(t20) {
      return "number" == typeof t20;
    }).forEach(function(e4) {
      t19[e4.toString(16)] = n3;
    });
    return t19;
  }), _byLigature$1 = t18(function(t19, e3, n3) {
    (t19[n3] = n3, e3[2]) && e3[2].filter(function(t20) {
      return "string" == typeof t20;
    }).forEach(function(e4) {
      t19[e4] = n3;
    });
    return t19;
  }), _byAlias$1 = t18(function(t19, e3, n3) {
    var o2 = e3[2];
    return t19[n3] = n3, o2.forEach(function(e4) {
      t19[e4] = n3;
    }), t19;
  });
  var e2 = "far" in styles$3 || config$1.autoFetchSvg, n2 = reduce$1(shims$1, function(t19, n3) {
    var o2 = n3[0], i2 = n3[1], r2 = n3[2];
    return "far" !== i2 || e2 || (i2 = "fas"), "string" == typeof o2 && (t19.names[o2] = { prefix: i2, iconName: r2 }), "number" == typeof o2 && (t19.unicodes[o2.toString(16)] = { prefix: i2, iconName: r2 }), t19;
  }, { names: {}, unicodes: {} });
  _byOldName$1 = n2.names, _byOldUnicode$1 = n2.unicodes, _defaultUsablePrefix$1 = getCanonicalPrefix$1(config$1.styleDefault, { family: config$1.familyDefault });
};
function byUnicode$1(t18, e2) {
  return (_byUnicode$1[t18] || {})[e2];
}
function byLigature$1(t18, e2) {
  return (_byLigature$1[t18] || {})[e2];
}
function byAlias$1(t18, e2) {
  return (_byAlias$1[t18] || {})[e2];
}
function byOldName$1(t18) {
  return _byOldName$1[t18] || { prefix: null, iconName: null };
}
function byOldUnicode$1(t18) {
  var e2 = _byOldUnicode$1[t18], n2 = byUnicode$1("fas", t18);
  return e2 || (n2 ? { prefix: "fas", iconName: n2 } : null) || { prefix: null, iconName: null };
}
function getDefaultUsablePrefix$1() {
  return _defaultUsablePrefix$1;
}
onChange$1(function(t18) {
  _defaultUsablePrefix$1 = getCanonicalPrefix$1(t18.styleDefault, { family: config$1.familyDefault });
}), build$1();
var emptyCanonicalIcon$1 = function() {
  return { prefix: null, iconName: null, rest: [] };
};
function getFamilyId$1(t18) {
  var e2 = a, n2 = FAMILY_NAMES$1.reduce(function(t19, e3) {
    return t19[e3] = "".concat(config$1.cssPrefix, "-").concat(e3), t19;
  }, {});
  return oo.forEach(function(o2) {
    (t18.includes(n2[o2]) || t18.some(function(t19) {
      return PREFIXES_FOR_FAMILY$1[o2].includes(t19);
    })) && (e2 = o2);
  }), e2;
}
function getCanonicalPrefix$1(t18) {
  var e2 = (arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {}).family, n2 = void 0 === e2 ? a : e2, o2 = PREFIX_TO_STYLE$1[n2][t18];
  if (n2 === o$1 && !t18) return "fad";
  var i2 = STYLE_TO_PREFIX$1[n2][t18] || STYLE_TO_PREFIX$1[n2][o2], r2 = t18 in namespace$1.styles ? t18 : null;
  return i2 || r2 || null;
}
function moveNonFaClassesToRest$1(t18) {
  var e2 = [], n2 = null;
  return t18.forEach(function(t19) {
    var o2 = getIconName$1(config$1.cssPrefix, t19);
    o2 ? n2 = o2 : t19 && e2.push(t19);
  }), { iconName: n2, rest: e2 };
}
function sortedUniqueValues$1(t18) {
  return t18.sort().filter(function(t19, e2, n2) {
    return n2.indexOf(t19) === e2;
  });
}
var _faCombinedClasses = $o$1.concat(zo);
function getCanonicalIcon$1(t18) {
  var e2 = (arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {}).skipLookups, n2 = void 0 !== e2 && e2, o2 = null, i2 = sortedUniqueValues$1(t18.filter(function(t19) {
    return _faCombinedClasses.includes(t19);
  })), r2 = sortedUniqueValues$1(t18.filter(function(t19) {
    return !_faCombinedClasses.includes(t19);
  })), a2 = _slicedToArray(i2.filter(function(t19) {
    return o2 = t19, !G$1.includes(t19);
  }), 1)[0], s2 = void 0 === a2 ? null : a2, c2 = getFamilyId$1(i2), l2 = _objectSpread2$1(_objectSpread2$1({}, moveNonFaClassesToRest$1(r2)), {}, { prefix: getCanonicalPrefix$1(s2, { family: c2 }) });
  return _objectSpread2$1(_objectSpread2$1(_objectSpread2$1({}, l2), getDefaultCanonicalPrefix$1({ values: t18, family: c2, styles: styles$3, config: config$1, canonical: l2, givenPrefix: o2 })), applyShimAndAlias$1(n2, o2, l2));
}
function applyShimAndAlias$1(t18, e2, n2) {
  var o2 = n2.prefix, i2 = n2.iconName;
  if (t18 || !o2 || !i2) return { prefix: o2, iconName: i2 };
  var r2 = "fa" === e2 ? byOldName$1(i2) : {}, a2 = byAlias$1(o2, i2);
  return i2 = r2.iconName || a2 || i2, "far" !== (o2 = r2.prefix || o2) || styles$3.far || !styles$3.fas || config$1.autoFetchSvg || (o2 = "fas"), { prefix: o2, iconName: i2 };
}
var newCanonicalFamilies$1 = oo.filter(function(t18) {
  return t18 !== a || t18 !== o$1;
}), newCanonicalStyles$1 = Object.keys(Go$1).filter(function(t18) {
  return t18 !== a;
}).map(function(t18) {
  return Object.keys(Go$1[t18]);
}).flat();
function getDefaultCanonicalPrefix$1(t18) {
  var e2 = t18.values, n2 = t18.family, o2 = t18.canonical, i2 = t18.givenPrefix, r2 = void 0 === i2 ? "" : i2, a2 = t18.styles, s2 = void 0 === a2 ? {} : a2, c2 = t18.config, l2 = void 0 === c2 ? {} : c2, u2 = n2 === o$1, p2 = e2.includes("fa-duotone") || e2.includes("fad"), d2 = "duotone" === l2.familyDefault, m2 = "fad" === o2.prefix || "fa-duotone" === o2.prefix;
  if ((!u2 && (p2 || d2 || m2) && (o2.prefix = "fad"), (e2.includes("fa-brands") || e2.includes("fab")) && (o2.prefix = "fab"), !o2.prefix && newCanonicalFamilies$1.includes(n2)) && (Object.keys(s2).find(function(t19) {
    return newCanonicalStyles$1.includes(t19);
  }) || l2.autoFetchSvg)) {
    var f2 = Co.get(n2).defaultShortPrefixId;
    o2.prefix = f2, o2.iconName = byAlias$1(o2.prefix, o2.iconName) || o2.iconName;
  }
  return "fa" !== o2.prefix && "fa" !== r2 || (o2.prefix = getDefaultUsablePrefix$1() || "fas"), o2;
}
var Library$1 = function() {
  return _createClass(function t18() {
    _classCallCheck(this, t18), this.definitions = {};
  }, [{ key: "add", value: function() {
    for (var t18 = this, e2 = arguments.length, n2 = new Array(e2), o2 = 0; o2 < e2; o2++) n2[o2] = arguments[o2];
    var i2 = n2.reduce(this._pullDefinitions, {});
    Object.keys(i2).forEach(function(e3) {
      t18.definitions[e3] = _objectSpread2$1(_objectSpread2$1({}, t18.definitions[e3] || {}), i2[e3]), defineIcons$1(e3, i2[e3]);
      var n3 = PREFIX_TO_LONG_STYLE$1[a][e3];
      n3 && defineIcons$1(n3, i2[e3]), build$1();
    });
  } }, { key: "reset", value: function() {
    this.definitions = {};
  } }, { key: "_pullDefinitions", value: function(t18, e2) {
    var n2 = e2.prefix && e2.iconName && e2.icon ? { 0: e2 } : e2;
    return Object.keys(n2).map(function(e3) {
      var o2 = n2[e3], i2 = o2.prefix, r2 = o2.iconName, a2 = o2.icon, s2 = a2[2];
      t18[i2] || (t18[i2] = {}), s2.length > 0 && s2.forEach(function(e4) {
        "string" == typeof e4 && (t18[i2][e4] = a2);
      }), t18[i2][r2] = a2;
    }), t18;
  } }]);
}(), _plugins$1 = [], _hooks$1 = {}, providers$1 = {}, defaultProviderKeys$1 = Object.keys(providers$1);
function registerPlugins$1(t18, e2) {
  var n2 = e2.mixoutsTo;
  return _plugins$1 = t18, _hooks$1 = {}, Object.keys(providers$1).forEach(function(t19) {
    -1 === defaultProviderKeys$1.indexOf(t19) && delete providers$1[t19];
  }), _plugins$1.forEach(function(t19) {
    var e3 = t19.mixout ? t19.mixout() : {};
    if (Object.keys(e3).forEach(function(t20) {
      "function" == typeof e3[t20] && (n2[t20] = e3[t20]), "object" === _typeof(e3[t20]) && Object.keys(e3[t20]).forEach(function(o3) {
        n2[t20] || (n2[t20] = {}), n2[t20][o3] = e3[t20][o3];
      });
    }), t19.hooks) {
      var o2 = t19.hooks();
      Object.keys(o2).forEach(function(t20) {
        _hooks$1[t20] || (_hooks$1[t20] = []), _hooks$1[t20].push(o2[t20]);
      });
    }
    t19.provides && t19.provides(providers$1);
  }), n2;
}
function chainHooks$1(t18, e2) {
  for (var n2 = arguments.length, o2 = new Array(n2 > 2 ? n2 - 2 : 0), i2 = 2; i2 < n2; i2++) o2[i2 - 2] = arguments[i2];
  return (_hooks$1[t18] || []).forEach(function(t19) {
    e2 = t19.apply(null, [e2].concat(o2));
  }), e2;
}
function callHooks$1(t18) {
  for (var e2 = arguments.length, n2 = new Array(e2 > 1 ? e2 - 1 : 0), o2 = 1; o2 < e2; o2++) n2[o2 - 1] = arguments[o2];
  (_hooks$1[t18] || []).forEach(function(t19) {
    t19.apply(null, n2);
  });
}
function callProvided$1() {
  var t18 = arguments[0], e2 = Array.prototype.slice.call(arguments, 1);
  return providers$1[t18] ? providers$1[t18].apply(null, e2) : void 0;
}
function findIconDefinition$1(t18) {
  "fa" === t18.prefix && (t18.prefix = "fas");
  var e2 = t18.iconName, n2 = t18.prefix || getDefaultUsablePrefix$1();
  if (e2) return e2 = byAlias$1(n2, e2) || e2, iconFromMapping$1(library$1.definitions, n2, e2) || iconFromMapping$1(namespace$1.styles, n2, e2);
}
var library$1 = new Library$1(), noAuto$1 = function() {
  config$1.autoReplaceSvg = false, config$1.observeMutations = false, callHooks$1("noAuto");
}, dom$1 = { i2svg: function() {
  var t18 = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {};
  return IS_DOM$1 ? (callHooks$1("beforeI2svg", t18), callProvided$1("pseudoElements2svg", t18), callProvided$1("i2svg", t18)) : Promise.reject(new Error("Operation requires a DOM of some kind."));
}, watch: function() {
  var t18 = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {}, e2 = t18.autoReplaceSvgRoot;
  false === config$1.autoReplaceSvg && (config$1.autoReplaceSvg = true), config$1.observeMutations = true, domready$1(function() {
    autoReplace$1({ autoReplaceSvgRoot: e2 }), callHooks$1("watch", t18);
  });
} }, parse$2 = { icon: function(t18) {
  if (null === t18) return null;
  if ("object" === _typeof(t18) && t18.prefix && t18.iconName) return { prefix: t18.prefix, iconName: byAlias$1(t18.prefix, t18.iconName) || t18.iconName };
  if (Array.isArray(t18) && 2 === t18.length) {
    var e2 = 0 === t18[1].indexOf("fa-") ? t18[1].slice(3) : t18[1], n2 = getCanonicalPrefix$1(t18[0]);
    return { prefix: n2, iconName: byAlias$1(n2, e2) || e2 };
  }
  if ("string" == typeof t18 && (t18.indexOf("".concat(config$1.cssPrefix, "-")) > -1 || t18.match(ICON_SELECTION_SYNTAX_PATTERN$1))) {
    var o2 = getCanonicalIcon$1(t18.split(" "), { skipLookups: true });
    return { prefix: o2.prefix || getDefaultUsablePrefix$1(), iconName: byAlias$1(o2.prefix, o2.iconName) || o2.iconName };
  }
  if ("string" == typeof t18) {
    var i2 = getDefaultUsablePrefix$1();
    return { prefix: i2, iconName: byAlias$1(i2, t18) || t18 };
  }
} }, api$1 = { noAuto: noAuto$1, config: config$1, dom: dom$1, parse: parse$2, library: library$1, findIconDefinition: findIconDefinition$1, toHtml: toHtml$1 }, autoReplace$1 = function() {
  var t18 = (arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : {}).autoReplaceSvgRoot, e2 = void 0 === t18 ? DOCUMENT$1 : t18;
  (Object.keys(namespace$1.styles).length > 0 || config$1.autoFetchSvg) && IS_DOM$1 && config$1.autoReplaceSvg && api$1.dom.i2svg({ node: e2 });
};
function domVariants$1(t18, e2) {
  return Object.defineProperty(t18, "abstract", { get: e2 }), Object.defineProperty(t18, "html", { get: function() {
    return t18.abstract.map(function(t19) {
      return toHtml$1(t19);
    });
  } }), Object.defineProperty(t18, "node", { get: function() {
    if (IS_DOM$1) {
      var e3 = DOCUMENT$1.createElement("div");
      return e3.innerHTML = t18.html, e3.children;
    }
  } }), t18;
}
function asIcon$1(t18) {
  var e2 = t18.children, n2 = t18.main, o2 = t18.mask, i2 = t18.attributes, r2 = t18.styles, a2 = t18.transform;
  if (transformIsMeaningful$1(a2) && n2.found && !o2.found) {
    var s2 = { x: n2.width / n2.height / 2, y: 0.5 };
    i2.style = joinStyles$1(_objectSpread2$1(_objectSpread2$1({}, r2), {}, { "transform-origin": "".concat(s2.x + a2.x / 16, "em ").concat(s2.y + a2.y / 16, "em") }));
  }
  return [{ tag: "svg", attributes: i2, children: e2 }];
}
function asSymbol$1(t18) {
  var e2 = t18.prefix, n2 = t18.iconName, o2 = t18.children, i2 = t18.attributes, r2 = t18.symbol, a2 = true === r2 ? "".concat(e2, "-").concat(config$1.cssPrefix, "-").concat(n2) : r2;
  return [{ tag: "svg", attributes: { style: "display: none;" }, children: [{ tag: "symbol", attributes: _objectSpread2$1(_objectSpread2$1({}, i2), {}, { id: a2 }), children: o2 }] }];
}
function isLabeled(t18) {
  return ["aria-label", "aria-labelledby", "title", "role"].some(function(e2) {
    return e2 in t18;
  });
}
function makeInlineSvgAbstract$1(t18) {
  var e2 = t18.icons, n2 = e2.main, o2 = e2.mask, i2 = t18.prefix, r2 = t18.iconName, a2 = t18.transform, s2 = t18.symbol, c2 = t18.maskId, l2 = t18.extra, u2 = t18.watchable, p2 = void 0 !== u2 && u2, d2 = o2.found ? o2 : n2, m2 = d2.width, f2 = d2.height, h2 = [config$1.replacementClass, r2 ? "".concat(config$1.cssPrefix, "-").concat(r2) : ""].filter(function(t19) {
    return -1 === l2.classes.indexOf(t19);
  }).filter(function(t19) {
    return "" !== t19 || !!t19;
  }).concat(l2.classes).join(" "), g2 = { children: [], attributes: _objectSpread2$1(_objectSpread2$1({}, l2.attributes), {}, { "data-prefix": i2, "data-icon": r2, class: h2, role: l2.attributes.role || "img", viewBox: "0 0 ".concat(m2, " ").concat(f2) }) };
  isLabeled(l2.attributes) || l2.attributes["aria-hidden"] || (g2.attributes["aria-hidden"] = "true"), p2 && (g2.attributes[DATA_FA_I2SVG$1] = "");
  var _ = _objectSpread2$1(_objectSpread2$1({}, g2), {}, { prefix: i2, iconName: r2, main: n2, mask: o2, maskId: c2, transform: a2, symbol: s2, styles: _objectSpread2$1({}, l2.styles) }), $2 = o2.found && n2.found ? callProvided$1("generateAbstractMask", _) || { children: [], attributes: {} } : callProvided$1("generateAbstractIcon", _) || { children: [], attributes: {} }, b2 = $2.children, y2 = $2.attributes;
  return _.children = b2, _.attributes = y2, s2 ? asSymbol$1(_) : asIcon$1(_);
}
function makeLayersTextAbstract$1(t18) {
  var e2 = t18.content, n2 = t18.width, o2 = t18.height, i2 = t18.transform, r2 = t18.extra, a2 = t18.watchable, s2 = void 0 !== a2 && a2, c2 = _objectSpread2$1(_objectSpread2$1({}, r2.attributes), {}, { class: r2.classes.join(" ") });
  s2 && (c2[DATA_FA_I2SVG$1] = "");
  var l2 = _objectSpread2$1({}, r2.styles);
  transformIsMeaningful$1(i2) && (l2.transform = transformForCss$1({ transform: i2, startCentered: true, width: n2, height: o2 }), l2["-webkit-transform"] = l2.transform);
  var u2 = joinStyles$1(l2);
  u2.length > 0 && (c2.style = u2);
  var p2 = [];
  return p2.push({ tag: "span", attributes: c2, children: [e2] }), p2;
}
function makeLayersCounterAbstract$1(t18) {
  var e2 = t18.content, n2 = t18.extra, o2 = _objectSpread2$1(_objectSpread2$1({}, n2.attributes), {}, { class: n2.classes.join(" ") }), i2 = joinStyles$1(n2.styles);
  i2.length > 0 && (o2.style = i2);
  var r2 = [];
  return r2.push({ tag: "span", attributes: o2, children: [e2] }), r2;
}
var styles$1$1 = namespace$1.styles;
function asFoundIcon$1(t18) {
  var e2 = t18[0], n2 = t18[1], o2 = _slicedToArray(t18.slice(4), 1)[0];
  return { found: true, width: e2, height: n2, icon: Array.isArray(o2) ? { tag: "g", attributes: { class: "".concat(config$1.cssPrefix, "-").concat(DUOTONE_CLASSES$1.GROUP) }, children: [{ tag: "path", attributes: { class: "".concat(config$1.cssPrefix, "-").concat(DUOTONE_CLASSES$1.SECONDARY), fill: "currentColor", d: o2[0] } }, { tag: "path", attributes: { class: "".concat(config$1.cssPrefix, "-").concat(DUOTONE_CLASSES$1.PRIMARY), fill: "currentColor", d: o2[1] } }] } : { tag: "path", attributes: { fill: "currentColor", d: o2 } } };
}
var missingIconResolutionMixin$1 = { found: false, width: 512, height: 512 };
function maybeNotifyMissing$1(t18, e2) {
  PRODUCTION$3 || config$1.showMissingIcons || !t18 || console.error('Icon with name "'.concat(t18, '" and prefix "').concat(e2, '" is missing.'));
}
function findIcon$1(t18, e2) {
  var n2 = e2;
  return "fa" === e2 && null !== config$1.styleDefault && (e2 = getDefaultUsablePrefix$1()), new Promise(function(o2, i2) {
    if ("fa" === n2) {
      var r2 = byOldName$1(t18) || {};
      t18 = r2.iconName || t18, e2 = r2.prefix || e2;
    }
    if (t18 && e2 && styles$1$1[e2] && styles$1$1[e2][t18]) return o2(asFoundIcon$1(styles$1$1[e2][t18]));
    maybeNotifyMissing$1(t18, e2), o2(_objectSpread2$1(_objectSpread2$1({}, missingIconResolutionMixin$1), {}, { icon: config$1.showMissingIcons && t18 && callProvided$1("missingIconAbstract") || {} }));
  });
}
var noop$1$1 = function() {
}, p$2$1 = config$1.measurePerformance && PERFORMANCE$1 && PERFORMANCE$1.mark && PERFORMANCE$1.measure ? PERFORMANCE$1 : { mark: noop$1$1, measure: noop$1$1 }, preamble$1 = 'FA "7.0.1"', begin$1 = function(t18) {
  return p$2$1.mark("".concat(preamble$1, " ").concat(t18, " begins")), function() {
    return end$1(t18);
  };
}, end$1 = function(t18) {
  p$2$1.mark("".concat(preamble$1, " ").concat(t18, " ends")), p$2$1.measure("".concat(preamble$1, " ").concat(t18), "".concat(preamble$1, " ").concat(t18, " begins"), "".concat(preamble$1, " ").concat(t18, " ends"));
}, perf$1 = { begin: begin$1, end: end$1 }, noop$2$1 = function() {
};
function isWatched$1(t18) {
  return "string" == typeof (t18.getAttribute ? t18.getAttribute(DATA_FA_I2SVG$1) : null);
}
function hasPrefixAndIcon$1(t18) {
  var e2 = t18.getAttribute ? t18.getAttribute(DATA_PREFIX$1) : null, n2 = t18.getAttribute ? t18.getAttribute(DATA_ICON$1) : null;
  return e2 && n2;
}
function hasBeenReplaced$1(t18) {
  return t18 && t18.classList && t18.classList.contains && t18.classList.contains(config$1.replacementClass);
}
function getMutator$1() {
  return true === config$1.autoReplaceSvg ? mutators$1.replace : mutators$1[config$1.autoReplaceSvg] || mutators$1.replace;
}
function createElementNS$1(t18) {
  return DOCUMENT$1.createElementNS("http://www.w3.org/2000/svg", t18);
}
function createElement$1(t18) {
  return DOCUMENT$1.createElement(t18);
}
function convertSVG$1(t18) {
  var e2 = (arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {}).ceFn, n2 = void 0 === e2 ? "svg" === t18.tag ? createElementNS$1 : createElement$1 : e2;
  if ("string" == typeof t18) return DOCUMENT$1.createTextNode(t18);
  var o2 = n2(t18.tag);
  return Object.keys(t18.attributes || []).forEach(function(e3) {
    o2.setAttribute(e3, t18.attributes[e3]);
  }), (t18.children || []).forEach(function(t19) {
    o2.appendChild(convertSVG$1(t19, { ceFn: n2 }));
  }), o2;
}
function nodeAsComment$1(t18) {
  var e2 = " ".concat(t18.outerHTML, " ");
  return e2 = "".concat(e2, "Font Awesome fontawesome.com ");
}
var mutators$1 = { replace: function(t18) {
  var e2 = t18[0];
  if (e2.parentNode) if (t18[1].forEach(function(t19) {
    e2.parentNode.insertBefore(convertSVG$1(t19), e2);
  }), null === e2.getAttribute(DATA_FA_I2SVG$1) && config$1.keepOriginalSource) {
    var n2 = DOCUMENT$1.createComment(nodeAsComment$1(e2));
    e2.parentNode.replaceChild(n2, e2);
  } else e2.remove();
}, nest: function(t18) {
  var e2 = t18[0], n2 = t18[1];
  if (~classArray$1(e2).indexOf(config$1.replacementClass)) return mutators$1.replace(t18);
  var o2 = new RegExp("".concat(config$1.cssPrefix, "-.*"));
  if (delete n2[0].attributes.id, n2[0].attributes.class) {
    var i2 = n2[0].attributes.class.split(" ").reduce(function(t19, e3) {
      return e3 === config$1.replacementClass || e3.match(o2) ? t19.toSvg.push(e3) : t19.toNode.push(e3), t19;
    }, { toNode: [], toSvg: [] });
    n2[0].attributes.class = i2.toSvg.join(" "), 0 === i2.toNode.length ? e2.removeAttribute("class") : e2.setAttribute("class", i2.toNode.join(" "));
  }
  var r2 = n2.map(function(t19) {
    return toHtml$1(t19);
  }).join("\n");
  e2.setAttribute(DATA_FA_I2SVG$1, ""), e2.innerHTML = r2;
} };
function performOperationSync$1(t18) {
  t18();
}
function perform$1(t18, e2) {
  var n2 = "function" == typeof e2 ? e2 : noop$2$1;
  if (0 === t18.length) n2();
  else {
    var o2 = performOperationSync$1;
    config$1.mutateApproach === MUTATION_APPROACH_ASYNC$1 && (o2 = WINDOW$1.requestAnimationFrame || performOperationSync$1), o2(function() {
      var e3 = getMutator$1(), o3 = perf$1.begin("mutate");
      t18.map(e3), o3(), n2();
    });
  }
}
var disabled$1 = false;
function disableObservation$1() {
  disabled$1 = true;
}
function enableObservation$1() {
  disabled$1 = false;
}
var mo = null;
function observe$1(t18) {
  if (MUTATION_OBSERVER$1 && config$1.observeMutations) {
    var e2 = t18.treeCallback, n2 = void 0 === e2 ? noop$2$1 : e2, o2 = t18.nodeCallback, i2 = void 0 === o2 ? noop$2$1 : o2, r2 = t18.pseudoElementsCallback, a2 = void 0 === r2 ? noop$2$1 : r2, s2 = t18.observeMutationsRoot, c2 = void 0 === s2 ? DOCUMENT$1 : s2;
    mo = new MUTATION_OBSERVER$1(function(t19) {
      if (!disabled$1) {
        var e3 = getDefaultUsablePrefix$1();
        toArray$1(t19).forEach(function(t20) {
          if ("childList" === t20.type && t20.addedNodes.length > 0 && !isWatched$1(t20.addedNodes[0]) && (config$1.searchPseudoElements && a2(t20.target), n2(t20.target)), "attributes" === t20.type && t20.target.parentNode && config$1.searchPseudoElements && a2([t20.target], true), "attributes" === t20.type && isWatched$1(t20.target) && ~ATTRIBUTES_WATCHED_FOR_MUTATION$1.indexOf(t20.attributeName)) if ("class" === t20.attributeName && hasPrefixAndIcon$1(t20.target)) {
            var o3 = getCanonicalIcon$1(classArray$1(t20.target)), r3 = o3.prefix, s3 = o3.iconName;
            t20.target.setAttribute(DATA_PREFIX$1, r3 || e3), s3 && t20.target.setAttribute(DATA_ICON$1, s3);
          } else hasBeenReplaced$1(t20.target) && i2(t20.target);
        });
      }
    }), IS_DOM$1 && mo.observe(c2, { childList: true, attributes: true, characterData: true, subtree: true });
  }
}
function disconnect$1() {
  mo && mo.disconnect();
}
function styleParser$1(t18) {
  var e2 = t18.getAttribute("style"), n2 = [];
  return e2 && (n2 = e2.split(";").reduce(function(t19, e3) {
    var n3 = e3.split(":"), o2 = n3[0], i2 = n3.slice(1);
    return o2 && i2.length > 0 && (t19[o2] = i2.join(":").trim()), t19;
  }, {})), n2;
}
function classParser$1(t18) {
  var e2 = t18.getAttribute("data-prefix"), n2 = t18.getAttribute("data-icon"), o2 = void 0 !== t18.innerText ? t18.innerText.trim() : "", i2 = getCanonicalIcon$1(classArray$1(t18));
  return i2.prefix || (i2.prefix = getDefaultUsablePrefix$1()), e2 && n2 && (i2.prefix = e2, i2.iconName = n2), i2.iconName && i2.prefix || (i2.prefix && o2.length > 0 && (i2.iconName = byLigature$1(i2.prefix, t18.innerText) || byUnicode$1(i2.prefix, toHex$1(t18.innerText))), !i2.iconName && config$1.autoFetchSvg && t18.firstChild && t18.firstChild.nodeType === Node.TEXT_NODE && (i2.iconName = t18.firstChild.data)), i2;
}
function attributesParser$1(t18) {
  var e2 = toArray$1(t18.attributes).reduce(function(t19, e3) {
    return "class" !== t19.name && "style" !== t19.name && (t19[e3.name] = e3.value), t19;
  }, {});
  return e2;
}
function blankMeta$1() {
  return { iconName: null, prefix: null, transform: meaninglessTransform$1, symbol: false, mask: { iconName: null, prefix: null, rest: [] }, maskId: null, extra: { classes: [], styles: {}, attributes: {} } };
}
function parseMeta$1(t18) {
  var e2 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : { styleParser: true }, n2 = classParser$1(t18), o2 = n2.iconName, i2 = n2.prefix, r2 = n2.rest, a2 = attributesParser$1(t18), s2 = chainHooks$1("parseNodeAttributes", {}, t18), c2 = e2.styleParser ? styleParser$1(t18) : [];
  return _objectSpread2$1({ iconName: o2, prefix: i2, transform: meaninglessTransform$1, mask: { iconName: null, prefix: null, rest: [] }, maskId: null, symbol: false, extra: { classes: r2, styles: c2, attributes: a2 } }, s2);
}
var styles$2$1 = namespace$1.styles;
function generateMutation$1(t18) {
  var e2 = "nest" === config$1.autoReplaceSvg ? parseMeta$1(t18, { styleParser: false }) : parseMeta$1(t18);
  return ~e2.extra.classes.indexOf(LAYERS_TEXT_CLASSNAME$1) ? callProvided$1("generateLayersText", t18, e2) : callProvided$1("generateSvgReplacementMutation", t18, e2);
}
function getKnownPrefixes$1() {
  return [].concat(_toConsumableArray(zo), _toConsumableArray($o$1));
}
function onTree$1(t18) {
  var e2 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : null;
  if (!IS_DOM$1) return Promise.resolve();
  var n2 = DOCUMENT$1.documentElement.classList, o2 = function(t19) {
    return n2.add("".concat(HTML_CLASS_I2SVG_BASE_CLASS$1, "-").concat(t19));
  }, i2 = function(t19) {
    return n2.remove("".concat(HTML_CLASS_I2SVG_BASE_CLASS$1, "-").concat(t19));
  }, r2 = config$1.autoFetchSvg ? getKnownPrefixes$1() : G$1.concat(Object.keys(styles$2$1));
  r2.includes("fa") || r2.push("fa");
  var a2 = [".".concat(LAYERS_TEXT_CLASSNAME$1, ":not([").concat(DATA_FA_I2SVG$1, "])")].concat(r2.map(function(t19) {
    return ".".concat(t19, ":not([").concat(DATA_FA_I2SVG$1, "])");
  })).join(", ");
  if (0 === a2.length) return Promise.resolve();
  var s2 = [];
  try {
    s2 = toArray$1(t18.querySelectorAll(a2));
  } catch (t19) {
  }
  if (!(s2.length > 0)) return Promise.resolve();
  o2("pending"), i2("complete");
  var c2 = perf$1.begin("onTree"), l2 = s2.reduce(function(t19, e3) {
    try {
      var n3 = generateMutation$1(e3);
      n3 && t19.push(n3);
    } catch (t20) {
      PRODUCTION$3 || "MissingIcon" === t20.name && console.error(t20);
    }
    return t19;
  }, []);
  return new Promise(function(t19, n3) {
    Promise.all(l2).then(function(n4) {
      perform$1(n4, function() {
        o2("active"), o2("complete"), i2("pending"), "function" == typeof e2 && e2(), c2(), t19();
      });
    }).catch(function(t20) {
      c2(), n3(t20);
    });
  });
}
function onNode$1(t18) {
  var e2 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : null;
  generateMutation$1(t18).then(function(t19) {
    t19 && perform$1([t19], e2);
  });
}
function resolveIcons$1(t18) {
  return function(e2) {
    var n2 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {}, o2 = (e2 || {}).icon ? e2 : findIconDefinition$1(e2 || {}), i2 = n2.mask;
    return i2 && (i2 = (i2 || {}).icon ? i2 : findIconDefinition$1(i2 || {})), t18(o2, _objectSpread2$1(_objectSpread2$1({}, n2), {}, { mask: i2 }));
  };
}
var render$1 = function(t18) {
  var e2 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {}, n2 = e2.transform, o2 = void 0 === n2 ? meaninglessTransform$1 : n2, i2 = e2.symbol, r2 = void 0 !== i2 && i2, a2 = e2.mask, s2 = void 0 === a2 ? null : a2, c2 = e2.maskId, l2 = void 0 === c2 ? null : c2, u2 = e2.classes, p2 = void 0 === u2 ? [] : u2, d2 = e2.attributes, m2 = void 0 === d2 ? {} : d2, f2 = e2.styles, h2 = void 0 === f2 ? {} : f2;
  if (t18) {
    var g2 = t18.prefix, _ = t18.iconName, $2 = t18.icon;
    return domVariants$1(_objectSpread2$1({ type: "icon" }, t18), function() {
      return callHooks$1("beforeDOMElementCreation", { iconDefinition: t18, params: e2 }), makeInlineSvgAbstract$1({ icons: { main: asFoundIcon$1($2), mask: s2 ? asFoundIcon$1(s2.icon) : { found: false, width: null, height: null, icon: {} } }, prefix: g2, iconName: _, transform: _objectSpread2$1(_objectSpread2$1({}, meaninglessTransform$1), o2), symbol: r2, maskId: l2, extra: { attributes: m2, styles: h2, classes: p2 } });
    });
  }
}, ReplaceElements$1 = { mixout: function() {
  return { icon: resolveIcons$1(render$1) };
}, hooks: function() {
  return { mutationObserverCallbacks: function(t18) {
    return t18.treeCallback = onTree$1, t18.nodeCallback = onNode$1, t18;
  } };
}, provides: function(t18) {
  t18.i2svg = function(t19) {
    var e2 = t19.node, n2 = void 0 === e2 ? DOCUMENT$1 : e2, o2 = t19.callback;
    return onTree$1(n2, void 0 === o2 ? function() {
    } : o2);
  }, t18.generateSvgReplacementMutation = function(t19, e2) {
    var n2 = e2.iconName, o2 = e2.prefix, i2 = e2.transform, r2 = e2.symbol, a2 = e2.mask, s2 = e2.maskId, c2 = e2.extra;
    return new Promise(function(e3, l2) {
      Promise.all([findIcon$1(n2, o2), a2.iconName ? findIcon$1(a2.iconName, a2.prefix) : Promise.resolve({ found: false, width: 512, height: 512, icon: {} })]).then(function(a3) {
        var l3 = _slicedToArray(a3, 2), u2 = l3[0], p2 = l3[1];
        e3([t19, makeInlineSvgAbstract$1({ icons: { main: u2, mask: p2 }, prefix: o2, iconName: n2, transform: i2, symbol: r2, maskId: s2, extra: c2, watchable: true })]);
      }).catch(l2);
    });
  }, t18.generateAbstractIcon = function(t19) {
    var e2, n2 = t19.children, o2 = t19.attributes, i2 = t19.main, r2 = t19.transform, a2 = joinStyles$1(t19.styles);
    return a2.length > 0 && (o2.style = a2), transformIsMeaningful$1(r2) && (e2 = callProvided$1("generateAbstractTransformGrouping", { main: i2, transform: r2, containerWidth: i2.width, iconWidth: i2.width })), n2.push(e2 || i2.icon), { children: n2, attributes: o2 };
  };
} }, Layers$1 = { mixout: function() {
  return { layer: function(t18) {
    var e2 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {}, n2 = e2.classes, o2 = void 0 === n2 ? [] : n2;
    return domVariants$1({ type: "layer" }, function() {
      callHooks$1("beforeDOMElementCreation", { assembler: t18, params: e2 });
      var n3 = [];
      return t18(function(t19) {
        Array.isArray(t19) ? t19.map(function(t20) {
          n3 = n3.concat(t20.abstract);
        }) : n3 = n3.concat(t19.abstract);
      }), [{ tag: "span", attributes: { class: ["".concat(config$1.cssPrefix, "-layers")].concat(_toConsumableArray(o2)).join(" ") }, children: n3 }];
    });
  } };
} }, LayersCounter$1 = { mixout: function() {
  return { counter: function(t18) {
    var e2 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {}, n2 = e2.title, o2 = void 0 === n2 ? null : n2, i2 = e2.classes, r2 = void 0 === i2 ? [] : i2, a2 = e2.attributes, s2 = void 0 === a2 ? {} : a2, c2 = e2.styles, l2 = void 0 === c2 ? {} : c2;
    return domVariants$1({ type: "counter", content: t18 }, function() {
      return callHooks$1("beforeDOMElementCreation", { content: t18, params: e2 }), makeLayersCounterAbstract$1({ content: t18.toString(), title: o2, extra: { attributes: s2, styles: l2, classes: ["".concat(config$1.cssPrefix, "-layers-counter")].concat(_toConsumableArray(r2)) } });
    });
  } };
} }, LayersText$1 = { mixout: function() {
  return { text: function(t18) {
    var e2 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {}, n2 = e2.transform, o2 = void 0 === n2 ? meaninglessTransform$1 : n2, i2 = e2.classes, r2 = void 0 === i2 ? [] : i2, a2 = e2.attributes, s2 = void 0 === a2 ? {} : a2, c2 = e2.styles, l2 = void 0 === c2 ? {} : c2;
    return domVariants$1({ type: "text", content: t18 }, function() {
      return callHooks$1("beforeDOMElementCreation", { content: t18, params: e2 }), makeLayersTextAbstract$1({ content: t18, transform: _objectSpread2$1(_objectSpread2$1({}, meaninglessTransform$1), o2), extra: { attributes: s2, styles: l2, classes: ["".concat(config$1.cssPrefix, "-layers-text")].concat(_toConsumableArray(r2)) } });
    });
  } };
}, provides: function(t18) {
  t18.generateLayersText = function(t19, e2) {
    var n2 = e2.transform, o2 = e2.extra, i2 = null, r2 = null;
    if (IS_IE$1) {
      var a2 = parseInt(getComputedStyle(t19).fontSize, 10), s2 = t19.getBoundingClientRect();
      i2 = s2.width / a2, r2 = s2.height / a2;
    }
    return Promise.resolve([t19, makeLayersTextAbstract$1({ content: t19.innerHTML, width: i2, height: r2, transform: n2, extra: o2, watchable: true })]);
  };
} }, CLEAN_CONTENT_PATTERN$1 = new RegExp('"', "ug"), SECONDARY_UNICODE_RANGE$1 = [1105920, 1112319], _FONT_FAMILY_WEIGHT_TO_PREFIX$1 = _objectSpread2$1(_objectSpread2$1(_objectSpread2$1(_objectSpread2$1({}, { FontAwesome: { normal: "fas", 400: "fas" } }), Bo), oa), lt$1), FONT_FAMILY_WEIGHT_TO_PREFIX$1 = Object.keys(_FONT_FAMILY_WEIGHT_TO_PREFIX$1).reduce(function(t18, e2) {
  return t18[e2.toLowerCase()] = _FONT_FAMILY_WEIGHT_TO_PREFIX$1[e2], t18;
}, {}), FONT_FAMILY_WEIGHT_FALLBACK$1 = Object.keys(FONT_FAMILY_WEIGHT_TO_PREFIX$1).reduce(function(t18, e2) {
  var n2 = FONT_FAMILY_WEIGHT_TO_PREFIX$1[e2];
  return t18[e2] = n2[900] || _toConsumableArray(Object.entries(n2))[0][1], t18;
}, {});
function hexValueFromContent$1(t18) {
  return toHex$1(_toConsumableArray(t18.replace(CLEAN_CONTENT_PATTERN$1, ""))[0] || "");
}
function isSecondaryLayer(t18) {
  var e2 = t18.getPropertyValue("font-feature-settings").includes("ss01"), n2 = t18.getPropertyValue("content").replace(CLEAN_CONTENT_PATTERN$1, ""), o2 = n2.codePointAt(0), i2 = o2 >= SECONDARY_UNICODE_RANGE$1[0] && o2 <= SECONDARY_UNICODE_RANGE$1[1], r2 = 2 === n2.length && n2[0] === n2[1];
  return i2 || r2 || e2;
}
function getPrefix$1(t18, e2) {
  var n2 = t18.replace(/^['"]|['"]$/g, "").toLowerCase(), o2 = parseInt(e2), i2 = isNaN(o2) ? "normal" : o2;
  return (FONT_FAMILY_WEIGHT_TO_PREFIX$1[n2] || {})[i2] || FONT_FAMILY_WEIGHT_FALLBACK$1[n2];
}
function replaceForPosition$1(t18, e2) {
  var n2 = "".concat(DATA_FA_PSEUDO_ELEMENT_PENDING$1).concat(e2.replace(":", "-"));
  return new Promise(function(o2, i2) {
    if (null !== t18.getAttribute(n2)) return o2();
    var r2 = toArray$1(t18.children).filter(function(t19) {
      return t19.getAttribute(DATA_FA_PSEUDO_ELEMENT$1) === e2;
    })[0], a2 = WINDOW$1.getComputedStyle(t18, e2), s2 = a2.getPropertyValue("font-family"), c2 = s2.match(FONT_FAMILY_PATTERN$1), l2 = a2.getPropertyValue("font-weight"), u2 = a2.getPropertyValue("content");
    if (r2 && !c2) return t18.removeChild(r2), o2();
    if (c2 && "none" !== u2 && "" !== u2) {
      var p2 = a2.getPropertyValue("content"), d2 = getPrefix$1(s2, l2), m2 = hexValueFromContent$1(p2), f2 = c2[0].startsWith("FontAwesome"), h2 = isSecondaryLayer(a2), g2 = byUnicode$1(d2, m2), _ = g2;
      if (f2) {
        var $2 = byOldUnicode$1(m2);
        $2.iconName && $2.prefix && (g2 = $2.iconName, d2 = $2.prefix);
      }
      if (!g2 || h2 || r2 && r2.getAttribute(DATA_PREFIX$1) === d2 && r2.getAttribute(DATA_ICON$1) === _) o2();
      else {
        t18.setAttribute(n2, _), r2 && t18.removeChild(r2);
        var b2 = blankMeta$1(), y2 = b2.extra;
        y2.attributes[DATA_FA_PSEUDO_ELEMENT$1] = e2, findIcon$1(g2, d2).then(function(i3) {
          var r3 = makeInlineSvgAbstract$1(_objectSpread2$1(_objectSpread2$1({}, b2), {}, { icons: { main: i3, mask: emptyCanonicalIcon$1() }, prefix: d2, iconName: _, extra: y2, watchable: true })), a3 = DOCUMENT$1.createElementNS("http://www.w3.org/2000/svg", "svg");
          "::before" === e2 ? t18.insertBefore(a3, t18.firstChild) : t18.appendChild(a3), a3.outerHTML = r3.map(function(t19) {
            return toHtml$1(t19);
          }).join("\n"), t18.removeAttribute(n2), o2();
        }).catch(i2);
      }
    } else o2();
  });
}
function replace$1(t18) {
  return Promise.all([replaceForPosition$1(t18, "::before"), replaceForPosition$1(t18, "::after")]);
}
function processable$1(t18) {
  return !(t18.parentNode === document.head || ~TAGNAMES_TO_SKIP_FOR_PSEUDOELEMENTS$1.indexOf(t18.tagName.toUpperCase()) || t18.getAttribute(DATA_FA_PSEUDO_ELEMENT$1) || t18.parentNode && "svg" === t18.parentNode.tagName);
}
var hasPseudoElement = function(t18) {
  return !!t18 && PSEUDO_ELEMENTS.some(function(e2) {
    return t18.includes(e2);
  });
}, parseCSSRuleForPseudos = function(t18) {
  if (!t18) return [];
  var e2 = /* @__PURE__ */ new Set(), n2 = t18.split(/,(?![^()]*\))/).map(function(t19) {
    return t19.trim();
  });
  n2 = n2.flatMap(function(t19) {
    return t19.includes("(") ? t19 : t19.split(",").map(function(t20) {
      return t20.trim();
    });
  });
  var o2, i2 = _createForOfIteratorHelper(n2);
  try {
    for (i2.s(); !(o2 = i2.n()).done; ) {
      var r2 = o2.value;
      if (hasPseudoElement(r2)) {
        var a2 = PSEUDO_ELEMENTS.reduce(function(t19, e3) {
          return t19.replace(e3, "");
        }, r2);
        "" !== a2 && "*" !== a2 && e2.add(a2);
      }
    }
  } catch (t19) {
    i2.e(t19);
  } finally {
    i2.f();
  }
  return e2;
};
function searchPseudoElements$1(t18) {
  if (IS_DOM$1) {
    var e2;
    if (arguments.length > 1 && void 0 !== arguments[1] && arguments[1]) e2 = t18;
    else if (config$1.searchPseudoElementsFullScan) e2 = t18.querySelectorAll("*");
    else {
      var n2, o2 = /* @__PURE__ */ new Set(), i2 = _createForOfIteratorHelper(document.styleSheets);
      try {
        for (i2.s(); !(n2 = i2.n()).done; ) {
          var r2 = n2.value;
          try {
            var a2, s2 = _createForOfIteratorHelper(r2.cssRules);
            try {
              for (s2.s(); !(a2 = s2.n()).done; ) {
                var c2, l2 = a2.value, u2 = _createForOfIteratorHelper(parseCSSRuleForPseudos(l2.selectorText));
                try {
                  for (u2.s(); !(c2 = u2.n()).done; ) {
                    var p2 = c2.value;
                    o2.add(p2);
                  }
                } catch (t19) {
                  u2.e(t19);
                } finally {
                  u2.f();
                }
              }
            } catch (t19) {
              s2.e(t19);
            } finally {
              s2.f();
            }
          } catch (t19) {
            config$1.searchPseudoElementsWarnings && console.warn("Font Awesome: cannot parse stylesheet: ".concat(r2.href, " (").concat(t19.message, ')\nIf it declares any Font Awesome CSS pseudo-elements, they will not be rendered as SVG icons. Add crossorigin="anonymous" to the <link>, enable searchPseudoElementsFullScan for slower but more thorough DOM parsing, or suppress this warning by setting searchPseudoElementsWarnings to false.'));
          }
        }
      } catch (t19) {
        i2.e(t19);
      } finally {
        i2.f();
      }
      if (!o2.size) return;
      var d2 = Array.from(o2).join(", ");
      try {
        e2 = t18.querySelectorAll(d2);
      } catch (t19) {
      }
    }
    return new Promise(function(t19, n3) {
      var o3 = toArray$1(e2).filter(processable$1).map(replace$1), i3 = perf$1.begin("searchPseudoElements");
      disableObservation$1(), Promise.all(o3).then(function() {
        i3(), enableObservation$1(), t19();
      }).catch(function() {
        i3(), enableObservation$1(), n3();
      });
    });
  }
}
var PseudoElements$1 = { hooks: function() {
  return { mutationObserverCallbacks: function(t18) {
    return t18.pseudoElementsCallback = searchPseudoElements$1, t18;
  } };
}, provides: function(t18) {
  t18.pseudoElements2svg = function(t19) {
    var e2 = t19.node, n2 = void 0 === e2 ? DOCUMENT$1 : e2;
    config$1.searchPseudoElements && searchPseudoElements$1(n2);
  };
} }, _unwatched$1 = false, MutationObserver$1$1 = { mixout: function() {
  return { dom: { unwatch: function() {
    disableObservation$1(), _unwatched$1 = true;
  } } };
}, hooks: function() {
  return { bootstrap: function() {
    observe$1(chainHooks$1("mutationObserverCallbacks", {}));
  }, noAuto: function() {
    disconnect$1();
  }, watch: function(t18) {
    var e2 = t18.observeMutationsRoot;
    _unwatched$1 ? enableObservation$1() : observe$1(chainHooks$1("mutationObserverCallbacks", { observeMutationsRoot: e2 }));
  } };
} }, parseTransformString$1 = function(t18) {
  return t18.toLowerCase().split(" ").reduce(function(t19, e2) {
    var n2 = e2.toLowerCase().split("-"), o2 = n2[0], i2 = n2.slice(1).join("-");
    if (o2 && "h" === i2) return t19.flipX = true, t19;
    if (o2 && "v" === i2) return t19.flipY = true, t19;
    if (i2 = parseFloat(i2), isNaN(i2)) return t19;
    switch (o2) {
      case "grow":
        t19.size = t19.size + i2;
        break;
      case "shrink":
        t19.size = t19.size - i2;
        break;
      case "left":
        t19.x = t19.x - i2;
        break;
      case "right":
        t19.x = t19.x + i2;
        break;
      case "up":
        t19.y = t19.y - i2;
        break;
      case "down":
        t19.y = t19.y + i2;
        break;
      case "rotate":
        t19.rotate = t19.rotate + i2;
    }
    return t19;
  }, { size: 16, x: 0, y: 0, flipX: false, flipY: false, rotate: 0 });
}, PowerTransforms$1 = { mixout: function() {
  return { parse: { transform: function(t18) {
    return parseTransformString$1(t18);
  } } };
}, hooks: function() {
  return { parseNodeAttributes: function(t18, e2) {
    var n2 = e2.getAttribute("data-fa-transform");
    return n2 && (t18.transform = parseTransformString$1(n2)), t18;
  } };
}, provides: function(t18) {
  t18.generateAbstractTransformGrouping = function(t19) {
    var e2 = t19.main, n2 = t19.transform, o2 = t19.containerWidth, i2 = t19.iconWidth, r2 = { transform: "translate(".concat(o2 / 2, " 256)") }, a2 = "translate(".concat(32 * n2.x, ", ").concat(32 * n2.y, ") "), s2 = "scale(".concat(n2.size / 16 * (n2.flipX ? -1 : 1), ", ").concat(n2.size / 16 * (n2.flipY ? -1 : 1), ") "), c2 = "rotate(".concat(n2.rotate, " 0 0)"), l2 = { outer: r2, inner: { transform: "".concat(a2, " ").concat(s2, " ").concat(c2) }, path: { transform: "translate(".concat(i2 / 2 * -1, " -256)") } };
    return { tag: "g", attributes: _objectSpread2$1({}, l2.outer), children: [{ tag: "g", attributes: _objectSpread2$1({}, l2.inner), children: [{ tag: e2.icon.tag, children: e2.icon.children, attributes: _objectSpread2$1(_objectSpread2$1({}, e2.icon.attributes), l2.path) }] }] };
  };
} }, ALL_SPACE$1 = { x: 0, y: 0, width: "100%", height: "100%" };
function fillBlack$1(t18) {
  var e2 = !(arguments.length > 1 && void 0 !== arguments[1]) || arguments[1];
  return t18.attributes && (t18.attributes.fill || e2) && (t18.attributes.fill = "black"), t18;
}
function deGroup$1(t18) {
  return "g" === t18.tag ? t18.children : [t18];
}
var Masks$1 = { hooks: function() {
  return { parseNodeAttributes: function(t18, e2) {
    var n2 = e2.getAttribute("data-fa-mask"), o2 = n2 ? getCanonicalIcon$1(n2.split(" ").map(function(t19) {
      return t19.trim();
    })) : emptyCanonicalIcon$1();
    return o2.prefix || (o2.prefix = getDefaultUsablePrefix$1()), t18.mask = o2, t18.maskId = e2.getAttribute("data-fa-mask-id"), t18;
  } };
}, provides: function(t18) {
  t18.generateAbstractMask = function(t19) {
    var e2 = t19.children, n2 = t19.attributes, o2 = t19.main, i2 = t19.mask, r2 = t19.maskId, a2 = t19.transform, s2 = o2.width, c2 = o2.icon, l2 = i2.width, u2 = i2.icon, p2 = transformForSvg$1({ transform: a2, containerWidth: l2, iconWidth: s2 }), d2 = { tag: "rect", attributes: _objectSpread2$1(_objectSpread2$1({}, ALL_SPACE$1), {}, { fill: "white" }) }, m2 = c2.children ? { children: c2.children.map(fillBlack$1) } : {}, f2 = { tag: "g", attributes: _objectSpread2$1({}, p2.inner), children: [fillBlack$1(_objectSpread2$1({ tag: c2.tag, attributes: _objectSpread2$1(_objectSpread2$1({}, c2.attributes), p2.path) }, m2))] }, h2 = { tag: "g", attributes: _objectSpread2$1({}, p2.outer), children: [f2] }, g2 = "mask-".concat(r2 || nextUniqueId$1()), _ = "clip-".concat(r2 || nextUniqueId$1()), $2 = { tag: "mask", attributes: _objectSpread2$1(_objectSpread2$1({}, ALL_SPACE$1), {}, { id: g2, maskUnits: "userSpaceOnUse", maskContentUnits: "userSpaceOnUse" }), children: [d2, h2] }, b2 = { tag: "defs", children: [{ tag: "clipPath", attributes: { id: _ }, children: deGroup$1(u2) }, $2] };
    return e2.push(b2, { tag: "rect", attributes: _objectSpread2$1({ fill: "currentColor", "clip-path": "url(#".concat(_, ")"), mask: "url(#".concat(g2, ")") }, ALL_SPACE$1) }), { children: e2, attributes: n2 };
  };
} }, MissingIconIndicator$1 = { provides: function(t18) {
  var e2 = false;
  WINDOW$1.matchMedia && (e2 = WINDOW$1.matchMedia("(prefers-reduced-motion: reduce)").matches), t18.missingIconAbstract = function() {
    var t19 = [], n2 = { fill: "currentColor" }, o2 = { attributeType: "XML", repeatCount: "indefinite", dur: "2s" };
    t19.push({ tag: "path", attributes: _objectSpread2$1(_objectSpread2$1({}, n2), {}, { d: "M156.5,447.7l-12.6,29.5c-18.7-9.5-35.9-21.2-51.5-34.9l22.7-22.7C127.6,430.5,141.5,440,156.5,447.7z M40.6,272H8.5 c1.4,21.2,5.4,41.7,11.7,61.1L50,321.2C45.1,305.5,41.8,289,40.6,272z M40.6,240c1.4-18.8,5.2-37,11.1-54.1l-29.5-12.6 C14.7,194.3,10,216.7,8.5,240H40.6z M64.3,156.5c7.8-14.9,17.2-28.8,28.1-41.5L69.7,92.3c-13.7,15.6-25.5,32.8-34.9,51.5 L64.3,156.5z M397,419.6c-13.9,12-29.4,22.3-46.1,30.4l11.9,29.8c20.7-9.9,39.8-22.6,56.9-37.6L397,419.6z M115,92.4 c13.9-12,29.4-22.3,46.1-30.4l-11.9-29.8c-20.7,9.9-39.8,22.6-56.8,37.6L115,92.4z M447.7,355.5c-7.8,14.9-17.2,28.8-28.1,41.5 l22.7,22.7c13.7-15.6,25.5-32.9,34.9-51.5L447.7,355.5z M471.4,272c-1.4,18.8-5.2,37-11.1,54.1l29.5,12.6 c7.5-21.1,12.2-43.5,13.6-66.8H471.4z M321.2,462c-15.7,5-32.2,8.2-49.2,9.4v32.1c21.2-1.4,41.7-5.4,61.1-11.7L321.2,462z M240,471.4c-18.8-1.4-37-5.2-54.1-11.1l-12.6,29.5c21.1,7.5,43.5,12.2,66.8,13.6V471.4z M462,190.8c5,15.7,8.2,32.2,9.4,49.2h32.1 c-1.4-21.2-5.4-41.7-11.7-61.1L462,190.8z M92.4,397c-12-13.9-22.3-29.4-30.4-46.1l-29.8,11.9c9.9,20.7,22.6,39.8,37.6,56.9 L92.4,397z M272,40.6c18.8,1.4,36.9,5.2,54.1,11.1l12.6-29.5C317.7,14.7,295.3,10,272,8.5V40.6z M190.8,50 c15.7-5,32.2-8.2,49.2-9.4V8.5c-21.2,1.4-41.7,5.4-61.1,11.7L190.8,50z M442.3,92.3L419.6,115c12,13.9,22.3,29.4,30.5,46.1 l29.8-11.9C470,128.5,457.3,109.4,442.3,92.3z M397,92.4l22.7-22.7c-15.6-13.7-32.8-25.5-51.5-34.9l-12.6,29.5 C370.4,72.1,384.4,81.5,397,92.4z" }) });
    var i2 = _objectSpread2$1(_objectSpread2$1({}, o2), {}, { attributeName: "opacity" }), r2 = { tag: "circle", attributes: _objectSpread2$1(_objectSpread2$1({}, n2), {}, { cx: "256", cy: "364", r: "28" }), children: [] };
    return e2 || r2.children.push({ tag: "animate", attributes: _objectSpread2$1(_objectSpread2$1({}, o2), {}, { attributeName: "r", values: "28;14;28;28;14;28;" }) }, { tag: "animate", attributes: _objectSpread2$1(_objectSpread2$1({}, i2), {}, { values: "1;0;1;1;0;1;" }) }), t19.push(r2), t19.push({ tag: "path", attributes: _objectSpread2$1(_objectSpread2$1({}, n2), {}, { opacity: "1", d: "M263.7,312h-16c-6.6,0-12-5.4-12-12c0-71,77.4-63.9,77.4-107.8c0-20-17.8-40.2-57.4-40.2c-29.1,0-44.3,9.6-59.2,28.7 c-3.9,5-11.1,6-16.2,2.4l-13.1-9.2c-5.6-3.9-6.9-11.8-2.6-17.2c21.2-27.2,46.4-44.7,91.2-44.7c52.3,0,97.4,29.8,97.4,80.2 c0,67.6-77.4,63.5-77.4,107.8C275.7,306.6,270.3,312,263.7,312z" }), children: e2 ? [] : [{ tag: "animate", attributes: _objectSpread2$1(_objectSpread2$1({}, i2), {}, { values: "1;0;0;0;0;1;" }) }] }), e2 || t19.push({ tag: "path", attributes: _objectSpread2$1(_objectSpread2$1({}, n2), {}, { opacity: "0", d: "M232.5,134.5l7,168c0.3,6.4,5.6,11.5,12,11.5h9c6.4,0,11.7-5.1,12-11.5l7-168c0.3-6.8-5.2-12.5-12-12.5h-23 C237.7,122,232.2,127.7,232.5,134.5z" }), children: [{ tag: "animate", attributes: _objectSpread2$1(_objectSpread2$1({}, i2), {}, { values: "0;0;1;1;0;0;" }) }] }), { tag: "g", attributes: { class: "missing" }, children: t19 };
  };
} }, SvgSymbols$1 = { hooks: function() {
  return { parseNodeAttributes: function(t18, e2) {
    var n2 = e2.getAttribute("data-fa-symbol"), o2 = null !== n2 && ("" === n2 || n2);
    return t18.symbol = o2, t18;
  } };
} }, plugins$1 = [InjectCSS$1, ReplaceElements$1, Layers$1, LayersCounter$1, LayersText$1, PseudoElements$1, MutationObserver$1$1, PowerTransforms$1, Masks$1, MissingIconIndicator$1, SvgSymbols$1];
registerPlugins$1(plugins$1, { mixoutsTo: api$1 }), api$1.noAuto, api$1.config, api$1.library, api$1.dom;
var parse$1$1 = api$1.parse;
api$1.findIconDefinition, api$1.toHtml;
var icon$1 = api$1.icon;
api$1.layer, api$1.text, api$1.counter;
let PRODUCTION$2 = false;
try {
  PRODUCTION$2 = "production" === process.env.NODE_ENV;
} catch (e2) {
}
function log$1(...t18) {
  !PRODUCTION$2 && console && "function" == typeof console.error && console.error(...t18);
}
function normalizeIconArgs$1(t18) {
  return t18 && "object" == typeof t18 && t18.prefix && t18.iconName && t18.icon ? t18 : parse$1$1.icon ? parse$1$1.icon(t18) : null === t18 ? null : t18 && "object" == typeof t18 && t18.prefix && t18.iconName ? t18 : Array.isArray(t18) && 2 === t18.length ? { prefix: t18[0], iconName: t18[1] } : "string" == typeof t18 ? { prefix: "fas", iconName: t18 } : void 0;
}
function objectWithKey$1(t18, e2) {
  return Array.isArray(e2) && e2.length > 0 || !Array.isArray(e2) && e2 ? { [t18]: e2 } : {};
}
function create_fragment$2E(t18) {
  let e2, n2 = [t18[2]], o2 = {};
  for (let t19 = 0; t19 < n2.length; t19 += 1) o2 = assign(o2, n2[t19]);
  return { c() {
    e2 = svg_element("svg"), set_svg_attributes(e2, o2);
  }, m(n3, o3) {
    insert(n3, e2, o3), e2.innerHTML = t18[1], t18[7](e2);
  }, p: noop$4, i: noop$4, o: noop$4, d(n3) {
    n3 && detach(e2), t18[7](null);
  } };
}
function instance$2F(t18, e2, n2) {
  let { tag: o2 } = e2, { props: i2 } = e2, { children: r2 } = e2, { style: a2 = null } = e2, { ref: s2 = null } = e2;
  if ("svg" !== o2) throw new Error('SvgElement requires a tag of "svg"');
  function c2(t19) {
    return t19?.reduce((t20, e3) => t20 + (e3.tag ? function({ tag: t21, props: e4, children: n3 }) {
      const o3 = Object.keys(e4).map((t22) => `${t22}="${e4[t22]}"`).join(" ");
      return `<${t21} ${o3}>${c2(n3)}</${t21}>`;
    }(e3) : e3), "") || "";
  }
  const l2 = c2(r2), u2 = i2?.style ? `${i2.style}${a2 || ""}` : a2, p2 = { ...i2, style: u2 };
  return t18.$$set = (t19) => {
    "tag" in t19 && n2(3, o2 = t19.tag), "props" in t19 && n2(4, i2 = t19.props), "children" in t19 && n2(5, r2 = t19.children), "style" in t19 && n2(6, a2 = t19.style), "ref" in t19 && n2(0, s2 = t19.ref);
  }, [s2, l2, p2, o2, i2, r2, a2, function(t19) {
    binding_callbacks[t19 ? "unshift" : "push"](() => {
      s2 = t19, n2(0, s2);
    });
  }];
}
let SvgElement$1 = class extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2F, create_fragment$2E, safe_not_equal, { tag: 3, props: 4, children: 5, style: 6, ref: 0 });
  }
};
function create_if_block$1y(t18) {
  let e2, n2, o2;
  const i2 = [t18[2], { style: t18[1] }];
  function r2(e3) {
    t18[28](e3);
  }
  let a2 = {};
  for (let t19 = 0; t19 < i2.length; t19 += 1) a2 = assign(a2, i2[t19]);
  return void 0 !== t18[0] && (a2.ref = t18[0]), e2 = new SvgElement$1({ props: a2 }), binding_callbacks.push(() => bind(e2, "ref", r2)), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, n3) {
    mount_component(e2, t19, n3), o2 = true;
  }, p(t19, o3) {
    const r3 = 6 & o3[0] ? get_spread_update(i2, [4 & o3[0] && get_spread_object(t19[2]), 2 & o3[0] && { style: t19[1] }]) : {};
    !n2 && 1 & o3[0] && (n2 = true, r3.ref = t19[0], add_flush_callback(() => n2 = false)), e2.$set(r3);
  }, i(t19) {
    o2 || (transition_in(e2.$$.fragment, t19), o2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), o2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_fragment$2D(t18) {
  let e2, n2, o2 = t18[2] && create_if_block$1y(t18);
  return { c() {
    o2 && o2.c(), e2 = empty();
  }, m(t19, i2) {
    o2 && o2.m(t19, i2), insert(t19, e2, i2), n2 = true;
  }, p(t19, n3) {
    t19[2] ? o2 ? (o2.p(t19, n3), 4 & n3[0] && transition_in(o2, 1)) : (o2 = create_if_block$1y(t19), o2.c(), transition_in(o2, 1), o2.m(e2.parentNode, e2)) : o2 && (group_outros(), transition_out(o2, 1, 1, () => {
      o2 = null;
    }), check_outros());
  }, i(t19) {
    n2 || (transition_in(o2), n2 = true);
  }, o(t19) {
    transition_out(o2), n2 = false;
  }, d(t19) {
    t19 && detach(e2), o2 && o2.d(t19);
  } };
}
function instance$2E(t18, e2, n2) {
  const o2 = ["border", "mask", "maskId", "fixedWidth", "inverse", "flip", "icon", "listItem", "pull", "pulse", "rotation", "size", "spin", "spinPulse", "spinReverse", "beat", "fade", "beatFade", "bounce", "shake", "symbol", "title", "titleId", "transform", "swapOpacity", "ref", "style"];
  let i2 = compute_rest_props(e2, o2), { border: r2 = false } = e2, { mask: a2 = null } = e2, { maskId: s2 = null } = e2, { fixedWidth: c2 = false } = e2, { inverse: l2 = false } = e2, { flip: u2 = false } = e2, { icon: p2 = null } = e2, { listItem: d2 = false } = e2, { pull: m2 = null } = e2, { pulse: f2 = false } = e2, { rotation: h2 = null } = e2, { size: g2 = null } = e2, { spin: _ = false } = e2, { spinPulse: $2 = false } = e2, { spinReverse: b2 = false } = e2, { beat: y2 = false } = e2, { fade: v2 = false } = e2, { beatFade: w2 = false } = e2, { bounce: S2 = false } = e2, { shake: T2 = false } = e2, { symbol: k2 = false } = e2, { title: x2 = "" } = e2, { titleId: E = null } = e2, { transform: O2 = null } = e2, { swapOpacity: A2 = false } = e2, { ref: C2 = null } = e2, { style: M = null } = e2;
  const I2 = normalizeIconArgs$1(p2), N2 = objectWithKey$1("classes", [...classList$1(e2), ...(e2.class || "").split(" ")]), P2 = objectWithKey$1("transform", "string" == typeof O2 ? parse$1$1.transform(O2) : O2), D2 = objectWithKey$1("mask", normalizeIconArgs$1(a2)), j2 = icon$1(I2, { ...N2, ...P2, ...D2, symbol: k2, title: x2, titleId: E, maskId: s2 });
  let F2 = null;
  if (j2) {
    const { abstract: t19 } = j2;
    F2 = convert$1((t20, e3, n3) => ({ tag: t20, props: e3, children: n3 }), t19[0], i2);
  } else log$1("Could not find icon", I2);
  return t18.$$set = (t19) => {
    n2(35, e2 = assign(assign({}, e2), exclude_internal_props(t19))), n2(34, i2 = compute_rest_props(e2, o2)), "border" in t19 && n2(3, r2 = t19.border), "mask" in t19 && n2(4, a2 = t19.mask), "maskId" in t19 && n2(5, s2 = t19.maskId), "fixedWidth" in t19 && n2(6, c2 = t19.fixedWidth), "inverse" in t19 && n2(7, l2 = t19.inverse), "flip" in t19 && n2(8, u2 = t19.flip), "icon" in t19 && n2(9, p2 = t19.icon), "listItem" in t19 && n2(10, d2 = t19.listItem), "pull" in t19 && n2(11, m2 = t19.pull), "pulse" in t19 && n2(12, f2 = t19.pulse), "rotation" in t19 && n2(13, h2 = t19.rotation), "size" in t19 && n2(14, g2 = t19.size), "spin" in t19 && n2(15, _ = t19.spin), "spinPulse" in t19 && n2(16, $2 = t19.spinPulse), "spinReverse" in t19 && n2(17, b2 = t19.spinReverse), "beat" in t19 && n2(18, y2 = t19.beat), "fade" in t19 && n2(19, v2 = t19.fade), "beatFade" in t19 && n2(20, w2 = t19.beatFade), "bounce" in t19 && n2(21, S2 = t19.bounce), "shake" in t19 && n2(22, T2 = t19.shake), "symbol" in t19 && n2(23, k2 = t19.symbol), "title" in t19 && n2(24, x2 = t19.title), "titleId" in t19 && n2(25, E = t19.titleId), "transform" in t19 && n2(26, O2 = t19.transform), "swapOpacity" in t19 && n2(27, A2 = t19.swapOpacity), "ref" in t19 && n2(0, C2 = t19.ref), "style" in t19 && n2(1, M = t19.style);
  }, e2 = exclude_internal_props(e2), [C2, M, F2, r2, a2, s2, c2, l2, u2, p2, d2, m2, f2, h2, g2, _, $2, b2, y2, v2, w2, S2, T2, k2, x2, E, O2, A2, function(t19) {
    C2 = t19, n2(0, C2);
  }];
}
let FontAwesomeIcon$1 = class extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2E, create_fragment$2D, safe_not_equal, { border: 3, mask: 4, maskId: 5, fixedWidth: 6, inverse: 7, flip: 8, icon: 9, listItem: 10, pull: 11, pulse: 12, rotation: 13, size: 14, spin: 15, spinPulse: 16, spinReverse: 17, beat: 18, fade: 19, beatFade: 20, bounce: 21, shake: 22, symbol: 23, title: 24, titleId: 25, transform: 26, swapOpacity: 27, ref: 0, style: 1 }, null, [-1, -1]);
  }
};
function canMergeUpwards(t18, e2) {
  if (t18.row <= 0) return false;
  return !!e2.find((e3) => e3.row + e3.rowSpan - 1 == t18.row - 1 && e3.col === t18.col && e3.colSpan === t18.colSpan);
}
function canMergeDownwards(t18, e2, n2) {
  if (t18.row + t18.rowSpan >= n2) return false;
  return !!e2.find((e3) => e3.row === t18.row + t18.rowSpan && e3.col === t18.col && e3.colSpan === t18.colSpan);
}
function canMergeRight(t18, e2, n2) {
  if (t18.col + t18.colSpan >= n2) return false;
  return !!e2.find((e3) => e3.col === t18.col + t18.colSpan && e3.row === t18.row && e3.rowSpan === t18.rowSpan);
}
function canMergeLeft(t18, e2) {
  if (t18.col <= 0) return false;
  return !!e2.find((e3) => e3.col + e3.colSpan - 1 == t18.col - 1 && e3.row === t18.row && e3.rowSpan === t18.rowSpan);
}
class CellMover {
  static isBetween(t18, e2, n2) {
    return t18 >= e2 && t18 <= n2;
  }
  static moveCell(t18, e2, n2, o2, i2) {
    const r2 = { ...e2 };
    switch (t18) {
      case "up":
        if (e2.row <= 0) return;
        r2.row = e2.row - 1;
        break;
      case "down":
        if (e2.row + e2.rowSpan >= o2) return;
        r2.row = e2.row + 1;
        break;
      case "left":
        if (e2.col <= 0) return;
        r2.col = e2.col - 1;
        break;
      case "right":
        if (e2.col + e2.colSpan >= i2) return;
        r2.col = e2.col + 1;
    }
    const a2 = n2.filter((t19) => {
      if (t19 === e2) return false;
      let n3 = this.isBetween(r2.col, t19.col, t19.col + t19.colSpan - 1), o3 = this.isBetween(t19.col, r2.col, r2.col + r2.colSpan - 1);
      const i3 = n3 || o3, a3 = this.isBetween(r2.row, t19.row, t19.row + t19.rowSpan - 1);
      let s2 = this.isBetween(t19.row, r2.row, r2.row + r2.rowSpan - 1);
      return i3 && (a3 || s2);
    });
    return n2.map((n3) => {
      if (n3 === e2) return { ...n3, row: r2.row, col: r2.col };
      if (a2.includes(n3)) {
        const e3 = "up" === t18 || "down" === t18 ? "up" === t18 ? r2.rowSpan : -1 * r2.rowSpan : "left" === t18 ? r2.colSpan : -1 * r2.colSpan;
        return { ...n3, row: "up" === t18 || "down" === t18 ? n3.row + e3 : n3.row, col: "left" === t18 || "right" === t18 ? n3.col + e3 : n3.col };
      }
      return n3;
    });
  }
}
class CellMerger {
  static mergeCells(t18, e2, n2) {
    const o2 = n2.find((n3) => n3 !== e2 && ("down" === t18 ? n3.row === e2.row + e2.rowSpan && n3.col === e2.col && n3.colSpan === e2.colSpan : "right" === t18 ? n3.col === e2.col + e2.colSpan && n3.row === e2.row && n3.rowSpan === e2.rowSpan : "left" === t18 ? n3.col + n3.colSpan === e2.col && n3.row === e2.row && n3.rowSpan === e2.rowSpan : "up" === t18 ? n3.row + n3.rowSpan === e2.row && n3.col === e2.col && n3.colSpan === e2.colSpan : void 0));
    if (o2) return n2.map((n3) => n3 === e2 ? { ...n3, rowSpan: "down" === t18 || "up" === t18 ? e2.rowSpan + o2.rowSpan : e2.rowSpan, colSpan: "right" === t18 || "left" === t18 ? e2.colSpan + o2.colSpan : e2.colSpan, row: "up" === t18 ? o2.row : e2.row, col: "left" === t18 ? o2.col : e2.col } : n3).filter((t19) => t19 !== o2);
  }
}
class CellSplitter {
  static splitCell(t18, e2, n2) {
    if ("vertically" === t18 && 1 === e2.colSpan || "horizontally" === t18 && 1 === e2.rowSpan) return;
    const o2 = { ...e2, widget: void 0 };
    if ("vertically" === t18) {
      const t19 = Math.floor(e2.colSpan / 2);
      o2.col = e2.col + t19, o2.colSpan = e2.colSpan - t19, o2.rowSpan = e2.rowSpan;
    } else {
      const t19 = Math.floor(e2.rowSpan / 2);
      o2.row = e2.row + t19, o2.rowSpan = e2.rowSpan - t19, o2.colSpan = e2.colSpan;
    }
    const i2 = n2.map((n3) => n3 === e2 ? "vertically" === t18 ? { ...e2, colSpan: Math.floor(e2.colSpan / 2) } : { ...e2, rowSpan: Math.floor(e2.rowSpan / 2) } : n3);
    return i2.push(o2), i2;
  }
}
function portal$1(t18, e2 = "body") {
  let n2;
  async function o2(o3) {
    if ("string" == typeof (e2 = o3)) {
      if (n2 = document.querySelector(e2), null === n2 && (await tick(), n2 = document.querySelector(e2)), null === n2) throw new Error(`No element found matching css selector: "${e2}"`);
    } else {
      if (!(e2 instanceof HTMLElement)) throw new TypeError(`Unknown portal target type: ${null === e2 ? "null" : typeof e2}. Allowed types: string (CSS selector) or HTMLElement.`);
      n2 = e2;
    }
    n2.appendChild(t18), t18.hidden = false;
  }
  return o2(e2), { update: o2, destroy: function() {
    t18.parentNode && t18.parentNode.removeChild(t18);
  } };
}
function create_if_block$1x(t18) {
  let e2, n2, o2;
  return { c() {
    e2 = element("span"), e2.innerHTML = '<i class="fas fa-xmark"></i>', attr(e2, "class", "close-button svelte-mobile-companion-a5e-038vch56tr3-1o1o9z3"), attr(e2, "aria-hidden", "true");
  }, m(i2, r2) {
    insert(i2, e2, r2), n2 || (o2 = listen(e2, "click", t18[4]), n2 = true);
  }, p: noop$4, d(t19) {
    t19 && detach(e2), n2 = false, o2();
  } };
}
function create_fragment$2C(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2 = t18[2] && create_if_block$1x(t18);
  const u2 = t18[6].default, p2 = create_slot(u2, t18, t18[5], null);
  return { c() {
    e2 = element("div"), n2 = element("div"), l2 && l2.c(), o2 = space(), p2 && p2.c(), attr(n2, "class", "modal svelte-mobile-companion-a5e-038vch56tr3-1o1o9z3"), attr(n2, "style", i2 = t18[0].join(" ")), attr(e2, "class", "backdrop svelte-mobile-companion-a5e-038vch56tr3-1o1o9z3"), attr(e2, "style", r2 = t18[1].join(" ")), attr(e2, "role", "presentation");
  }, m(i3, r3) {
    insert(i3, e2, r3), append(e2, n2), l2 && l2.m(n2, null), append(n2, o2), p2 && p2.m(n2, null), a2 = true, s2 || (c2 = [listen(e2, "click", t18[3]), action_destroyer(portal$1.call(null, e2, "#mobile-companion"))], s2 = true);
  }, p(t19, [s3]) {
    t19[2] ? l2 ? l2.p(t19, s3) : (l2 = create_if_block$1x(t19), l2.c(), l2.m(n2, o2)) : l2 && (l2.d(1), l2 = null), p2 && p2.p && (!a2 || 32 & s3) && update_slot_base(p2, u2, t19, t19[5], a2 ? get_slot_changes(u2, t19[5], s3, null) : get_all_dirty_from_scope(t19[5]), null), (!a2 || 1 & s3 && i2 !== (i2 = t19[0].join(" "))) && attr(n2, "style", i2), (!a2 || 2 & s3 && r2 !== (r2 = t19[1].join(" "))) && attr(e2, "style", r2);
  }, i(t19) {
    a2 || (transition_in(p2, t19), a2 = true);
  }, o(t19) {
    transition_out(p2, t19), a2 = false;
  }, d(t19) {
    t19 && detach(e2), l2 && l2.d(), p2 && p2.d(t19), s2 = false, run_all(c2);
  } };
}
function instance$2D(t18, e2, n2) {
  let { $$slots: o2 = {}, $$scope: i2 } = e2, { modalStyle: r2 = [] } = e2, { backdropStyle: a2 = [] } = e2, { showCloseButton: s2 = true } = e2;
  const c2 = createEventDispatcher();
  function l2() {
    c2("close");
  }
  return t18.$$set = (t19) => {
    "modalStyle" in t19 && n2(0, r2 = t19.modalStyle), "backdropStyle" in t19 && n2(1, a2 = t19.backdropStyle), "showCloseButton" in t19 && n2(2, s2 = t19.showCloseButton), "$$scope" in t19 && n2(5, i2 = t19.$$scope);
  }, [r2, a2, s2, function(t19) {
    t19.target === t19.currentTarget && l2();
  }, l2, i2, o2];
}
let GenericModal$1 = class extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2D, create_fragment$2C, safe_not_equal, { modalStyle: 0, backdropStyle: 1, showCloseButton: 2 });
  }
};
function create_fragment$2B(t18) {
  let e2, n2, o2, i2, r2, a2;
  const s2 = t18[5].default, c2 = create_slot(s2, t18, t18[4], null);
  return { c() {
    e2 = element("button"), c2 && c2.c(), attr(e2, "class", n2 = null_to_empty("no-hover-focus-effect " + t18[2]) + " svelte-mobile-companion-a5e-038vch56tr3-16lus5v"), attr(e2, "style", o2 = t18[0].join(" ")), toggle_class(e2, "secondary", t18[1]);
  }, m(n3, o3) {
    insert(n3, e2, o3), c2 && c2.m(e2, null), i2 = true, r2 || (a2 = listen(e2, "click", t18[3]), r2 = true);
  }, p(t19, [r3]) {
    c2 && c2.p && (!i2 || 16 & r3) && update_slot_base(c2, s2, t19, t19[4], i2 ? get_slot_changes(s2, t19[4], r3, null) : get_all_dirty_from_scope(t19[4]), null), (!i2 || 4 & r3 && n2 !== (n2 = null_to_empty("no-hover-focus-effect " + t19[2]) + " svelte-mobile-companion-a5e-038vch56tr3-16lus5v")) && attr(e2, "class", n2), (!i2 || 1 & r3 && o2 !== (o2 = t19[0].join(" "))) && attr(e2, "style", o2), (!i2 || 6 & r3) && toggle_class(e2, "secondary", t19[1]);
  }, i(t19) {
    i2 || (transition_in(c2, t19), i2 = true);
  }, o(t19) {
    transition_out(c2, t19), i2 = false;
  }, d(t19) {
    t19 && detach(e2), c2 && c2.d(t19), r2 = false, a2();
  } };
}
function instance$2C(t18, e2, n2) {
  let { $$slots: o2 = {}, $$scope: i2 } = e2, { styles: r2 = [] } = e2, { secondary: a2 = false } = e2, { additionalClasses: s2 = "" } = e2;
  const c2 = createEventDispatcher();
  return t18.$$set = (t19) => {
    "styles" in t19 && n2(0, r2 = t19.styles), "secondary" in t19 && n2(1, a2 = t19.secondary), "additionalClasses" in t19 && n2(2, s2 = t19.additionalClasses), "$$scope" in t19 && n2(4, i2 = t19.$$scope);
  }, [r2, a2, s2, function() {
    c2("click");
  }, i2, o2];
}
class DefaultButton extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2C, create_fragment$2B, safe_not_equal, { styles: 0, secondary: 1, additionalClasses: 2 });
  }
}
class WidgetRegistry {
  static {
    this.widgets = /* @__PURE__ */ new Map();
  }
  static register(t18, e2) {
    this.widgets.set(t18, e2);
  }
  static get(t18) {
    return this.widgets.get(t18);
  }
}
class WidgetPickerRegistry {
  static {
    this.widgets = [];
  }
  static register(t18) {
    this.widgets.push(t18);
  }
  static get() {
    return this.widgets;
  }
}
function get_each_context$N(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[6] = e2[n2], o2;
}
function create_each_block$N(t18) {
  let e2, n2, o2;
  var i2 = t18[6];
  return i2 && (e2 = construct_svelte_component(i2, {}), e2.$on("add", t18[1])), { c() {
    e2 && create_component(e2.$$.fragment), n2 = empty();
  }, m(t19, i3) {
    e2 && mount_component(e2, t19, i3), insert(t19, n2, i3), o2 = true;
  }, p(t19, o3) {
    if (i2 !== (i2 = t19[6])) {
      if (e2) {
        group_outros();
        const t20 = e2;
        transition_out(t20.$$.fragment, 1, 0, () => {
          destroy_component(t20, 1);
        }), check_outros();
      }
      i2 ? (e2 = construct_svelte_component(i2, {}), e2.$on("add", t19[1]), create_component(e2.$$.fragment), transition_in(e2.$$.fragment, 1), mount_component(e2, n2.parentNode, n2)) : e2 = null;
    }
  }, i(t19) {
    o2 || (e2 && transition_in(e2.$$.fragment, t19), o2 = true);
  }, o(t19) {
    e2 && transition_out(e2.$$.fragment, t19), o2 = false;
  }, d(t19) {
    t19 && detach(n2), e2 && destroy_component(e2, t19);
  } };
}
function create_if_block$1w(t18) {
  let e2, n2;
  return e2 = new DefaultButton({ props: { $$slots: { default: [create_default_slot_1$4] }, $$scope: { ctx: t18 } } }), e2.$on("click", t18[2]), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    512 & n3 && (o2.$$scope = { dirty: n3, ctx: t19 }), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_default_slot_1$4(t18) {
  let e2;
  return { c() {
    e2 = text("Clear slot");
  }, m(t19, n2) {
    insert(t19, e2, n2);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_default_slot$r(t18) {
  let e2, n2, o2, i2, r2, a2 = ensure_array_like(WidgetPickerRegistry.get()), s2 = [];
  for (let e3 = 0; e3 < a2.length; e3 += 1) s2[e3] = create_each_block$N(get_each_context$N(t18, a2, e3));
  const c2 = (t19) => transition_out(s2[t19], 1, 1, () => {
    s2[t19] = null;
  });
  let l2 = t18[0].widget && create_if_block$1w(t18);
  return { c() {
    e2 = element("div"), n2 = element("div");
    for (let t19 = 0; t19 < s2.length; t19 += 1) s2[t19].c();
    o2 = space(), i2 = element("footer"), l2 && l2.c(), attr(n2, "class", "picker-list svelte-mobile-companion-a5e-038vch56tr3-1vmkux6"), attr(i2, "class", "picker-footer svelte-mobile-companion-a5e-038vch56tr3-1vmkux6"), attr(e2, "class", "widget-picker-list svelte-mobile-companion-a5e-038vch56tr3-1vmkux6");
  }, m(t19, a3) {
    insert(t19, e2, a3), append(e2, n2);
    for (let t20 = 0; t20 < s2.length; t20 += 1) s2[t20] && s2[t20].m(n2, null);
    append(e2, o2), append(e2, i2), l2 && l2.m(i2, null), r2 = true;
  }, p(t19, e3) {
    if (2 & e3) {
      let o3;
      for (a2 = ensure_array_like(WidgetPickerRegistry.get()), o3 = 0; o3 < a2.length; o3 += 1) {
        const i3 = get_each_context$N(t19, a2, o3);
        s2[o3] ? (s2[o3].p(i3, e3), transition_in(s2[o3], 1)) : (s2[o3] = create_each_block$N(i3), s2[o3].c(), transition_in(s2[o3], 1), s2[o3].m(n2, null));
      }
      for (group_outros(), o3 = a2.length; o3 < s2.length; o3 += 1) c2(o3);
      check_outros();
    }
    t19[0].widget ? l2 ? (l2.p(t19, e3), 1 & e3 && transition_in(l2, 1)) : (l2 = create_if_block$1w(t19), l2.c(), transition_in(l2, 1), l2.m(i2, null)) : l2 && (group_outros(), transition_out(l2, 1, 1, () => {
      l2 = null;
    }), check_outros());
  }, i(t19) {
    if (!r2) {
      for (let t20 = 0; t20 < a2.length; t20 += 1) transition_in(s2[t20]);
      transition_in(l2), r2 = true;
    }
  }, o(t19) {
    s2 = s2.filter(Boolean);
    for (let t20 = 0; t20 < s2.length; t20 += 1) transition_out(s2[t20]);
    transition_out(l2), r2 = false;
  }, d(t19) {
    t19 && detach(e2), destroy_each(s2, t19), l2 && l2.d();
  } };
}
function create_fragment$2A(t18) {
  let e2, n2;
  return e2 = new GenericModal$1({ props: { $$slots: { default: [create_default_slot$r] }, $$scope: { ctx: t18 } } }), e2.$on("close", t18[3]), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, [n3]) {
    const o2 = {};
    513 & n3 && (o2.$$scope = { dirty: n3, ctx: t19 }), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function instance$2B(t18, e2, n2) {
  let { cell: o2 } = e2;
  const i2 = getContext(CONTEXT$1.WIDGET_STORE), r2 = createEventDispatcher();
  function a2() {
    r2("close");
  }
  return t18.$$set = (t19) => {
    "cell" in t19 && n2(0, o2 = t19.cell);
  }, [o2, function(t19) {
    n2(0, o2.widget = t19.detail, o2), i2.update((t20) => t20.map((t21) => {
      var e3, n3;
      return (null === (e3 = t21.widget) || void 0 === e3 ? void 0 : e3.id) === (null === (n3 = o2.widget) || void 0 === n3 ? void 0 : n3.id) && (t21.widget = o2.widget), t21;
    })), a2();
  }, function() {
    o2.widget && (i2.update((t19) => t19.map((t20) => {
      var e3, n3;
      return (null === (e3 = t20.widget) || void 0 === e3 ? void 0 : e3.id) === (null === (n3 = o2.widget) || void 0 === n3 ? void 0 : n3.id) && (t20.widget = void 0), t20;
    })), a2());
  }, a2];
}
class WidgetPicker extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2B, create_fragment$2A, safe_not_equal, { cell: 0 });
  }
}
function create_if_block_1$A(t18) {
  let e2, n2;
  return e2 = new WidgetPicker({ props: { cell: t18[0] } }), e2.$on("close", t18[12]), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1 & n3 && (o2.cell = t19[0]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_else_block$e(t18) {
  let e2, n2, o2, i2, r2;
  return n2 = new FontAwesomeIcon$1({ props: { icon: faPlus } }), { c() {
    e2 = element("button"), create_component(n2.$$.fragment), attr(e2, "class", "no-hover-focus-effect svelte-mobile-companion-a5e-038vch56tr3-1r6fylt");
  }, m(a2, s2) {
    insert(a2, e2, s2), mount_component(n2, e2, null), o2 = true, i2 || (r2 = listen(e2, "click", t18[8]), i2 = true);
  }, p: noop$4, i(t19) {
    o2 || (transition_in(n2.$$.fragment, t19), o2 = true);
  }, o(t19) {
    transition_out(n2.$$.fragment, t19), o2 = false;
  }, d(t19) {
    t19 && detach(e2), destroy_component(n2), i2 = false, r2();
  } };
}
function create_if_block$1v(t18) {
  let e2, n2, o2, i2, r2;
  return n2 = new FontAwesomeIcon$1({ props: { icon: faRotate } }), { c() {
    e2 = element("button"), create_component(n2.$$.fragment), attr(e2, "class", "no-hover-focus-effect svelte-mobile-companion-a5e-038vch56tr3-1r6fylt");
  }, m(a2, s2) {
    insert(a2, e2, s2), mount_component(n2, e2, null), o2 = true, i2 || (r2 = listen(e2, "click", t18[8]), i2 = true);
  }, p: noop$4, i(t19) {
    o2 || (transition_in(n2.$$.fragment, t19), o2 = true);
  }, o(t19) {
    transition_out(n2.$$.fragment, t19), o2 = false;
  }, d(t19) {
    t19 && detach(e2), destroy_component(n2), i2 = false, r2();
  } };
}
function create_fragment$2z(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, m2, f2, h2, g2, _, $2, b2, y2, v2, w2, S2, T2, k2, x2, E, O2, A2, C2, M, I2, N2, P2, D2, j2, F2, L2, R, z2, H, W2, U, q, G2, B2, J, Y, X, V, K2, Z, Q, tt, et2, nt, ot, it, rt, at, st, ct = t18[1] && create_if_block_1$A(t18);
  s2 = new FontAwesomeIcon$1({ props: { icon: faArrowUp } }), p2 = new FontAwesomeIcon$1({ props: { icon: faChain } }), $2 = new FontAwesomeIcon$1({ props: { icon: faArrowLeft } }), w2 = new FontAwesomeIcon$1({ props: { icon: faChain } });
  const lt2 = [create_if_block$1v, create_else_block$e], ut = [];
  function pt2(t19, e3) {
    return t19[0].widget ? 0 : 1;
  }
  return x2 = pt2(t18), E = ut[x2] = lt2[x2](t18), M = new FontAwesomeIcon$1({ props: { icon: faGripLinesVertical } }), D2 = new FontAwesomeIcon$1({ props: { icon: faGripLines } }), z2 = new FontAwesomeIcon$1({ props: { icon: faArrowRight } }), q = new FontAwesomeIcon$1({ props: { icon: faChain } }), K2 = new FontAwesomeIcon$1({ props: { icon: faArrowDown } }), et2 = new FontAwesomeIcon$1({ props: { icon: faChain } }), { c() {
    ct && ct.c(), e2 = space(), n2 = element("div"), o2 = element("div"), i2 = space(), r2 = element("div"), a2 = element("button"), create_component(s2.$$.fragment), l2 = space(), u2 = element("button"), create_component(p2.$$.fragment), m2 = space(), f2 = element("div"), h2 = space(), g2 = element("div"), _ = element("button"), create_component($2.$$.fragment), y2 = space(), v2 = element("button"), create_component(w2.$$.fragment), T2 = space(), k2 = element("div"), E.c(), O2 = space(), A2 = element("div"), C2 = element("button"), create_component(M.$$.fragment), N2 = space(), P2 = element("button"), create_component(D2.$$.fragment), F2 = space(), L2 = element("div"), R = element("button"), create_component(z2.$$.fragment), W2 = space(), U = element("button"), create_component(q.$$.fragment), B2 = space(), J = element("div"), Y = space(), X = element("div"), V = element("button"), create_component(K2.$$.fragment), Q = space(), tt = element("button"), create_component(et2.$$.fragment), ot = space(), it = element("div"), attr(o2, "class", "spacer corner-tl svelte-mobile-companion-a5e-038vch56tr3-1r6fylt"), attr(a2, "class", "no-hover-focus-effect svelte-mobile-companion-a5e-038vch56tr3-1r6fylt"), a2.disabled = c2 = !t18[3](t18[0])?.up, attr(a2, "aria-label", "Move up"), attr(u2, "class", "no-hover-focus-effect svelte-mobile-companion-a5e-038vch56tr3-1r6fylt"), u2.disabled = d2 = !t18[3](t18[0])?.up, attr(r2, "class", "controls up svelte-mobile-companion-a5e-038vch56tr3-1r6fylt"), attr(f2, "class", "spacer corner-tr svelte-mobile-companion-a5e-038vch56tr3-1r6fylt"), attr(_, "class", "no-hover-focus-effect svelte-mobile-companion-a5e-038vch56tr3-1r6fylt"), _.disabled = b2 = !t18[3](t18[0])?.left, attr(_, "aria-label", "Move left"), attr(v2, "class", "no-hover-focus-effect svelte-mobile-companion-a5e-038vch56tr3-1r6fylt"), v2.disabled = S2 = !t18[3](t18[0])?.left, attr(g2, "class", "controls left svelte-mobile-companion-a5e-038vch56tr3-1r6fylt"), attr(C2, "class", "no-hover-focus-effect svelte-mobile-companion-a5e-038vch56tr3-1r6fylt"), C2.disabled = I2 = !t18[2](t18[0])?.vertically, attr(P2, "class", "no-hover-focus-effect svelte-mobile-companion-a5e-038vch56tr3-1r6fylt"), P2.disabled = j2 = !t18[2](t18[0])?.horizontally, attr(A2, "class", "split-buttons svelte-mobile-companion-a5e-038vch56tr3-1r6fylt"), attr(k2, "class", "center-area svelte-mobile-companion-a5e-038vch56tr3-1r6fylt"), attr(R, "class", "no-hover-focus-effect svelte-mobile-companion-a5e-038vch56tr3-1r6fylt"), R.disabled = H = !t18[3](t18[0])?.right, attr(R, "aria-label", "Move right"), attr(U, "class", "no-hover-focus-effect svelte-mobile-companion-a5e-038vch56tr3-1r6fylt"), U.disabled = G2 = !t18[3](t18[0])?.right, attr(L2, "class", "controls right svelte-mobile-companion-a5e-038vch56tr3-1r6fylt"), attr(J, "class", "spacer corner-bl svelte-mobile-companion-a5e-038vch56tr3-1r6fylt"), attr(V, "class", "no-hover-focus-effect svelte-mobile-companion-a5e-038vch56tr3-1r6fylt"), V.disabled = Z = !t18[3](t18[0])?.down, attr(V, "aria-label", "Move down"), attr(tt, "class", "no-hover-focus-effect svelte-mobile-companion-a5e-038vch56tr3-1r6fylt"), tt.disabled = nt = !t18[3](t18[0])?.down, attr(X, "class", "controls down svelte-mobile-companion-a5e-038vch56tr3-1r6fylt"), attr(it, "class", "spacer corner-br svelte-mobile-companion-a5e-038vch56tr3-1r6fylt"), attr(n2, "class", "edit-overlay svelte-mobile-companion-a5e-038vch56tr3-1r6fylt");
  }, m(c3, d3) {
    ct && ct.m(c3, d3), insert(c3, e2, d3), insert(c3, n2, d3), append(n2, o2), append(n2, i2), append(n2, r2), append(r2, a2), mount_component(s2, a2, null), append(r2, l2), append(r2, u2), mount_component(p2, u2, null), append(n2, m2), append(n2, f2), append(n2, h2), append(n2, g2), append(g2, _), mount_component($2, _, null), append(g2, y2), append(g2, v2), mount_component(w2, v2, null), append(n2, T2), append(n2, k2), ut[x2].m(k2, null), append(k2, O2), append(k2, A2), append(A2, C2), mount_component(M, C2, null), append(A2, N2), append(A2, P2), mount_component(D2, P2, null), append(n2, F2), append(n2, L2), append(L2, R), mount_component(z2, R, null), append(L2, W2), append(L2, U), mount_component(q, U, null), append(n2, B2), append(n2, J), append(n2, Y), append(n2, X), append(X, V), mount_component(K2, V, null), append(X, Q), append(X, tt), mount_component(et2, tt, null), append(n2, ot), append(n2, it), rt = true, at || (st = [listen(a2, "click", t18[13]), listen(u2, "click", t18[14]), listen(_, "click", t18[15]), listen(v2, "click", t18[16]), listen(C2, "click", t18[17]), listen(P2, "click", t18[18]), listen(R, "click", t18[19]), listen(U, "click", t18[20]), listen(V, "click", t18[21]), listen(tt, "click", t18[22])], at = true);
  }, p(t19, [n3]) {
    t19[1] ? ct ? (ct.p(t19, n3), 2 & n3 && transition_in(ct, 1)) : (ct = create_if_block_1$A(t19), ct.c(), transition_in(ct, 1), ct.m(e2.parentNode, e2)) : ct && (group_outros(), transition_out(ct, 1, 1, () => {
      ct = null;
    }), check_outros()), (!rt || 9 & n3 && c2 !== (c2 = !t19[3](t19[0])?.up)) && (a2.disabled = c2), (!rt || 9 & n3 && d2 !== (d2 = !t19[3](t19[0])?.up)) && (u2.disabled = d2), (!rt || 9 & n3 && b2 !== (b2 = !t19[3](t19[0])?.left)) && (_.disabled = b2), (!rt || 9 & n3 && S2 !== (S2 = !t19[3](t19[0])?.left)) && (v2.disabled = S2);
    let o3 = x2;
    x2 = pt2(t19), x2 === o3 ? ut[x2].p(t19, n3) : (group_outros(), transition_out(ut[o3], 1, 1, () => {
      ut[o3] = null;
    }), check_outros(), E = ut[x2], E ? E.p(t19, n3) : (E = ut[x2] = lt2[x2](t19), E.c()), transition_in(E, 1), E.m(k2, O2)), (!rt || 5 & n3 && I2 !== (I2 = !t19[2](t19[0])?.vertically)) && (C2.disabled = I2), (!rt || 5 & n3 && j2 !== (j2 = !t19[2](t19[0])?.horizontally)) && (P2.disabled = j2), (!rt || 9 & n3 && H !== (H = !t19[3](t19[0])?.right)) && (R.disabled = H), (!rt || 9 & n3 && G2 !== (G2 = !t19[3](t19[0])?.right)) && (U.disabled = G2), (!rt || 9 & n3 && Z !== (Z = !t19[3](t19[0])?.down)) && (V.disabled = Z), (!rt || 9 & n3 && nt !== (nt = !t19[3](t19[0])?.down)) && (tt.disabled = nt);
  }, i(t19) {
    rt || (transition_in(ct), transition_in(s2.$$.fragment, t19), transition_in(p2.$$.fragment, t19), transition_in($2.$$.fragment, t19), transition_in(w2.$$.fragment, t19), transition_in(E), transition_in(M.$$.fragment, t19), transition_in(D2.$$.fragment, t19), transition_in(z2.$$.fragment, t19), transition_in(q.$$.fragment, t19), transition_in(K2.$$.fragment, t19), transition_in(et2.$$.fragment, t19), rt = true);
  }, o(t19) {
    transition_out(ct), transition_out(s2.$$.fragment, t19), transition_out(p2.$$.fragment, t19), transition_out($2.$$.fragment, t19), transition_out(w2.$$.fragment, t19), transition_out(E), transition_out(M.$$.fragment, t19), transition_out(D2.$$.fragment, t19), transition_out(z2.$$.fragment, t19), transition_out(q.$$.fragment, t19), transition_out(K2.$$.fragment, t19), transition_out(et2.$$.fragment, t19), rt = false;
  }, d(t19) {
    t19 && (detach(e2), detach(n2)), ct && ct.d(t19), destroy_component(s2), destroy_component(p2), destroy_component($2), destroy_component(w2), ut[x2].d(), destroy_component(M), destroy_component(D2), destroy_component(z2), destroy_component(q), destroy_component(K2), destroy_component(et2), at = false, run_all(st);
  } };
}
function instance$2A(t18, e2, n2) {
  let o2, i2, r2, { rows: a2 } = e2, { columns: s2 } = e2, { cell: c2 } = e2;
  const l2 = getContext(CONTEXT$1.WIDGET_STORE);
  function u2(t19) {
    const e3 = CellMover.moveCell(t19, c2, r2, a2, s2);
    e3 && l2.set(e3);
  }
  function p2(t19) {
    const e3 = CellMerger.mergeCells(t19, c2, r2);
    e3 && l2.set(e3);
  }
  function d2(t19) {
    const e3 = CellSplitter.splitCell(t19, c2, r2);
    e3 && l2.set(e3);
  }
  component_subscribe(t18, l2, (t19) => n2(11, r2 = t19));
  let m2 = false;
  return t18.$$set = (t19) => {
    "rows" in t19 && n2(9, a2 = t19.rows), "columns" in t19 && n2(10, s2 = t19.columns), "cell" in t19 && n2(0, c2 = t19.cell);
  }, t18.$$.update = () => {
    3584 & t18.$$.dirty && n2(3, o2 = (t19) => ({ up: canMergeUpwards(t19, r2), down: canMergeDownwards(t19, r2, a2), left: canMergeLeft(t19, r2), right: canMergeRight(t19, r2, s2) }));
  }, n2(2, i2 = (t19) => ({ vertically: t19.colSpan > 1, horizontally: t19.rowSpan > 1 })), [c2, m2, i2, o2, l2, u2, p2, d2, function() {
    n2(1, m2 = true);
  }, a2, s2, r2, () => n2(1, m2 = false), () => u2("up"), () => p2("up"), () => u2("left"), () => p2("left"), () => d2("vertically"), () => d2("horizontally"), () => u2("right"), () => p2("right"), () => u2("down"), () => p2("down")];
}
class EditOverlay extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2A, create_fragment$2z, safe_not_equal, { rows: 9, columns: 10, cell: 0 });
  }
}
function create_fragment$2y(t18) {
  let e2, n2, o2, i2, r2;
  return n2 = new WidgetCell({ props: { cell: t18[0] } }), i2 = new EditOverlay({ props: { cell: t18[0], rows: t18[1], columns: t18[2] } }), { c() {
    e2 = element("div"), create_component(n2.$$.fragment), o2 = space(), create_component(i2.$$.fragment), attr(e2, "class", "edit-container svelte-mobile-companion-a5e-038vch56tr3-1wyc0m0"), set_style(e2, "grid-row", t18[0].row + 1 + " / span " + t18[0].rowSpan), set_style(e2, "grid-column", t18[0].col + 1 + " / span " + t18[0].colSpan);
  }, m(t19, a2) {
    insert(t19, e2, a2), mount_component(n2, e2, null), append(e2, o2), mount_component(i2, e2, null), r2 = true;
  }, p(t19, [o3]) {
    const a2 = {};
    1 & o3 && (a2.cell = t19[0]), n2.$set(a2);
    const s2 = {};
    1 & o3 && (s2.cell = t19[0]), 2 & o3 && (s2.rows = t19[1]), 4 & o3 && (s2.columns = t19[2]), i2.$set(s2), (!r2 || 1 & o3) && set_style(e2, "grid-row", t19[0].row + 1 + " / span " + t19[0].rowSpan), (!r2 || 1 & o3) && set_style(e2, "grid-column", t19[0].col + 1 + " / span " + t19[0].colSpan);
  }, i(t19) {
    r2 || (transition_in(n2.$$.fragment, t19), transition_in(i2.$$.fragment, t19), r2 = true);
  }, o(t19) {
    transition_out(n2.$$.fragment, t19), transition_out(i2.$$.fragment, t19), r2 = false;
  }, d(t19) {
    t19 && detach(e2), destroy_component(n2), destroy_component(i2);
  } };
}
function instance$2z(t18, e2, n2) {
  let { cell: o2 } = e2, { rows: i2 } = e2, { columns: r2 } = e2;
  return t18.$$set = (t19) => {
    "cell" in t19 && n2(0, o2 = t19.cell), "rows" in t19 && n2(1, i2 = t19.rows), "columns" in t19 && n2(2, r2 = t19.columns);
  }, [o2, i2, r2];
}
class EditGrid extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2z, create_fragment$2y, safe_not_equal, { cell: 0, rows: 1, columns: 2 });
  }
}
function get_each_context$M(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[6] = e2[n2], o2;
}
function create_if_block$1u(t18) {
  let e2, n2, o2, i2;
  const r2 = [create_if_block_1$z, create_else_block$d], a2 = [];
  function s2(t19, e3) {
    return t19[2] ? 0 : 1;
  }
  return e2 = s2(t18), n2 = a2[e2] = r2[e2](t18), { c() {
    n2.c(), o2 = empty();
  }, m(t19, n3) {
    a2[e2].m(t19, n3), insert(t19, o2, n3), i2 = true;
  }, p(t19, i3) {
    let c2 = e2;
    e2 = s2(t19), e2 === c2 ? a2[e2].p(t19, i3) : (group_outros(), transition_out(a2[c2], 1, 1, () => {
      a2[c2] = null;
    }), check_outros(), n2 = a2[e2], n2 ? n2.p(t19, i3) : (n2 = a2[e2] = r2[e2](t19), n2.c()), transition_in(n2, 1), n2.m(o2.parentNode, o2));
  }, i(t19) {
    i2 || (transition_in(n2), i2 = true);
  }, o(t19) {
    transition_out(n2), i2 = false;
  }, d(t19) {
    t19 && detach(o2), a2[e2].d(t19);
  } };
}
function create_else_block$d(t18) {
  let e2, n2;
  return e2 = new WidgetCell({ props: { cell: t18[6] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    16 & n3 && (o2.cell = t19[6]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_if_block_1$z(t18) {
  let e2, n2;
  return e2 = new EditGrid({ props: { rows: t18[0], columns: t18[1], cell: t18[6] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1 & n3 && (o2.rows = t19[0]), 2 & n3 && (o2.columns = t19[1]), 16 & n3 && (o2.cell = t19[6]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_each_block$M(t18, e2) {
  let n2, o2, i2, r2 = e2[0] > e2[6].row && e2[1] > e2[6].col && create_if_block$1u(e2);
  return { key: t18, first: null, c() {
    n2 = empty(), r2 && r2.c(), o2 = empty(), this.first = n2;
  }, m(t19, e3) {
    insert(t19, n2, e3), r2 && r2.m(t19, e3), insert(t19, o2, e3), i2 = true;
  }, p(t19, n3) {
    (e2 = t19)[0] > e2[6].row && e2[1] > e2[6].col ? r2 ? (r2.p(e2, n3), 19 & n3 && transition_in(r2, 1)) : (r2 = create_if_block$1u(e2), r2.c(), transition_in(r2, 1), r2.m(o2.parentNode, o2)) : r2 && (group_outros(), transition_out(r2, 1, 1, () => {
      r2 = null;
    }), check_outros());
  }, i(t19) {
    i2 || (transition_in(r2), i2 = true);
  }, o(t19) {
    transition_out(r2), i2 = false;
  }, d(t19) {
    t19 && (detach(n2), detach(o2)), r2 && r2.d(t19);
  } };
}
function create_fragment$2x(t18) {
  let e2, n2, o2 = [], i2 = /* @__PURE__ */ new Map(), r2 = ensure_array_like(t18[4]);
  const a2 = (t19) => t19[6].row + "-" + t19[6].col;
  for (let e3 = 0; e3 < r2.length; e3 += 1) {
    let n3 = get_each_context$M(t18, r2, e3), s2 = a2(n3);
    i2.set(s2, o2[e3] = create_each_block$M(s2, n3));
  }
  return { c() {
    e2 = element("div");
    for (let t19 = 0; t19 < o2.length; t19 += 1) o2[t19].c();
    attr(e2, "class", "grid svelte-mobile-companion-a5e-038vch56tr3-2bjc25"), attr(e2, "style", t18[3]);
  }, m(t19, i3) {
    insert(t19, e2, i3);
    for (let t20 = 0; t20 < o2.length; t20 += 1) o2[t20] && o2[t20].m(e2, null);
    n2 = true;
  }, p(t19, [s2]) {
    23 & s2 && (r2 = ensure_array_like(t19[4]), group_outros(), o2 = update_keyed_each(o2, s2, a2, 1, t19, r2, i2, e2, outro_and_destroy_block, create_each_block$M, null, get_each_context$M), check_outros()), (!n2 || 8 & s2) && attr(e2, "style", t19[3]);
  }, i(t19) {
    if (!n2) {
      for (let t20 = 0; t20 < r2.length; t20 += 1) transition_in(o2[t20]);
      n2 = true;
    }
  }, o(t19) {
    for (let t20 = 0; t20 < o2.length; t20 += 1) transition_out(o2[t20]);
    n2 = false;
  }, d(t19) {
    t19 && detach(e2);
    for (let t20 = 0; t20 < o2.length; t20 += 1) o2[t20].d();
  } };
}
function instance$2y(t18, e2, n2) {
  let o2, i2, { rows: r2 } = e2, { columns: a2 } = e2, { editMode: s2 = false } = e2;
  const c2 = getContext(CONTEXT$1.WIDGET_STORE);
  return component_subscribe(t18, c2, (t19) => n2(4, i2 = t19)), t18.$$set = (t19) => {
    "rows" in t19 && n2(0, r2 = t19.rows), "columns" in t19 && n2(1, a2 = t19.columns), "editMode" in t19 && n2(2, s2 = t19.editMode);
  }, t18.$$.update = () => {
    3 & t18.$$.dirty && n2(3, o2 = `--columns: ${a2}; --rows: ${r2};`);
  }, [r2, a2, s2, o2, i2, c2];
}
class WidgetGrid extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2y, create_fragment$2x, safe_not_equal, { rows: 0, columns: 1, editMode: 2 });
  }
}
function create_if_block_1$y(t18) {
  let e2, n2;
  return e2 = new GenericModal$1({ props: { showCloseButton: false, $$slots: { default: [create_default_slot_3$1] }, $$scope: { ctx: t18 } } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    4194316 & n3 && (o2.$$scope = { dirty: n3, ctx: t19 }), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_default_slot_5(t18) {
  let e2;
  return { c() {
    e2 = text("Yes");
  }, m(t19, n2) {
    insert(t19, e2, n2);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_default_slot_4(t18) {
  let e2;
  return { c() {
    e2 = text("No");
  }, m(t19, n2) {
    insert(t19, e2, n2);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_default_slot_3$1(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, m2, f2 = t18[2].name + "";
  return u2 = new DefaultButton({ props: { $$slots: { default: [create_default_slot_5] }, $$scope: { ctx: t18 } } }), u2.$on("click", t18[10]), d2 = new DefaultButton({ props: { $$slots: { default: [create_default_slot_4] }, $$scope: { ctx: t18 } } }), d2.$on("click", t18[11]), { c() {
    e2 = element("section"), n2 = element("h2"), o2 = text("Delete "), i2 = text(f2), r2 = text("?"), a2 = space(), s2 = element("p"), s2.textContent = "Do you want to delete this grid?", c2 = space(), l2 = element("div"), create_component(u2.$$.fragment), p2 = space(), create_component(d2.$$.fragment), attr(n2, "class", "svelte-mobile-companion-a5e-038vch56tr3-1f8ze4q"), attr(l2, "class", "buttons svelte-mobile-companion-a5e-038vch56tr3-1f8ze4q"), attr(e2, "class", "deleteDialog svelte-mobile-companion-a5e-038vch56tr3-1f8ze4q");
  }, m(t19, f3) {
    insert(t19, e2, f3), append(e2, n2), append(n2, o2), append(n2, i2), append(n2, r2), append(e2, a2), append(e2, s2), append(e2, c2), append(e2, l2), mount_component(u2, l2, null), append(l2, p2), mount_component(d2, l2, null), m2 = true;
  }, p(t19, e3) {
    (!m2 || 4 & e3) && f2 !== (f2 = t19[2].name + "") && set_data(i2, f2);
    const n3 = {};
    4194304 & e3 && (n3.$$scope = { dirty: e3, ctx: t19 }), u2.$set(n3);
    const o3 = {};
    4194304 & e3 && (o3.$$scope = { dirty: e3, ctx: t19 }), d2.$set(o3);
  }, i(t19) {
    m2 || (transition_in(u2.$$.fragment, t19), transition_in(d2.$$.fragment, t19), m2 = true);
  }, o(t19) {
    transition_out(u2.$$.fragment, t19), transition_out(d2.$$.fragment, t19), m2 = false;
  }, d(t19) {
    t19 && detach(e2), destroy_component(u2), destroy_component(d2);
  } };
}
function create_if_block$1t(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, m2, f2, h2, g2, _, $2, b2, y2;
  return m2 = new DefaultButton({ props: { styles: ["width: 10rem;"], $$slots: { default: [create_default_slot_2$1] }, $$scope: { ctx: t18 } } }), m2.$on("click", t18[8]), h2 = new DefaultButton({ props: { styles: ["width: 10rem;"], $$slots: { default: [create_default_slot_1$3] }, $$scope: { ctx: t18 } } }), h2.$on("click", t18[9]), _ = new DefaultButton({ props: { styles: ["background-color: var(--a5e-color-error);", "width: 10rem;"], $$slots: { default: [create_default_slot$q] }, $$scope: { ctx: t18 } } }), _.$on("click", t18[15]), { c() {
    e2 = element("label"), e2.textContent = "Label", n2 = space(), o2 = element("input"), i2 = space(), r2 = element("label"), r2.textContent = "Rows", a2 = space(), s2 = element("input"), c2 = space(), l2 = element("label"), l2.textContent = "Columns", u2 = space(), p2 = element("input"), d2 = space(), create_component(m2.$$.fragment), f2 = space(), create_component(h2.$$.fragment), g2 = space(), create_component(_.$$.fragment), attr(e2, "for", "label"), attr(o2, "id", "label"), attr(o2, "class", "label-input svelte-mobile-companion-a5e-038vch56tr3-1f8ze4q"), attr(o2, "type", "text"), attr(o2, "placeholder", "Grid Label"), attr(r2, "for", "rows"), attr(s2, "id", "rows"), attr(s2, "class", "number-input svelte-mobile-companion-a5e-038vch56tr3-1f8ze4q"), attr(s2, "type", "number"), attr(l2, "for", "columns"), attr(p2, "id", "columns"), attr(p2, "class", "number-input svelte-mobile-companion-a5e-038vch56tr3-1f8ze4q"), attr(p2, "type", "number");
  }, m(v2, w2) {
    insert(v2, e2, w2), insert(v2, n2, w2), insert(v2, o2, w2), set_input_value(o2, t18[2].name), insert(v2, i2, w2), insert(v2, r2, w2), insert(v2, a2, w2), insert(v2, s2, w2), set_input_value(s2, t18[0]), insert(v2, c2, w2), insert(v2, l2, w2), insert(v2, u2, w2), insert(v2, p2, w2), set_input_value(p2, t18[1]), insert(v2, d2, w2), mount_component(m2, v2, w2), insert(v2, f2, w2), mount_component(h2, v2, w2), insert(v2, g2, w2), mount_component(_, v2, w2), $2 = true, b2 || (y2 = [listen(o2, "input", t18[12]), listen(s2, "input", t18[13]), listen(p2, "input", t18[14])], b2 = true);
  }, p(t19, e3) {
    4 & e3 && o2.value !== t19[2].name && set_input_value(o2, t19[2].name), 1 & e3 && to_number(s2.value) !== t19[0] && set_input_value(s2, t19[0]), 2 & e3 && to_number(p2.value) !== t19[1] && set_input_value(p2, t19[1]);
    const n3 = {};
    4194304 & e3 && (n3.$$scope = { dirty: e3, ctx: t19 }), m2.$set(n3);
    const i3 = {};
    4194304 & e3 && (i3.$$scope = { dirty: e3, ctx: t19 }), h2.$set(i3);
    const r3 = {};
    4194304 & e3 && (r3.$$scope = { dirty: e3, ctx: t19 }), _.$set(r3);
  }, i(t19) {
    $2 || (transition_in(m2.$$.fragment, t19), transition_in(h2.$$.fragment, t19), transition_in(_.$$.fragment, t19), $2 = true);
  }, o(t19) {
    transition_out(m2.$$.fragment, t19), transition_out(h2.$$.fragment, t19), transition_out(_.$$.fragment, t19), $2 = false;
  }, d(t19) {
    t19 && (detach(e2), detach(n2), detach(o2), detach(i2), detach(r2), detach(a2), detach(s2), detach(c2), detach(l2), detach(u2), detach(p2), detach(d2), detach(f2), detach(g2)), destroy_component(m2, t19), destroy_component(h2, t19), destroy_component(_, t19), b2 = false, run_all(y2);
  } };
}
function create_default_slot_2$1(t18) {
  let e2, n2;
  return e2 = new FontAwesomeIcon$1({ props: { icon: faSave } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p: noop$4, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_default_slot_1$3(t18) {
  let e2, n2;
  return e2 = new FontAwesomeIcon$1({ props: { icon: faCancel$1 } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p: noop$4, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_default_slot$q(t18) {
  let e2, n2;
  return e2 = new FontAwesomeIcon$1({ props: { icon: faTrash } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p: noop$4, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_fragment$2w(t18) {
  let e2, n2, o2, i2, r2, a2 = t18[3] && create_if_block_1$y(t18), s2 = t18[4] && create_if_block$1t(t18);
  return i2 = new WidgetGrid({ props: { rows: t18[0], columns: t18[1], editMode: t18[4] } }), { c() {
    a2 && a2.c(), e2 = space(), n2 = element("div"), s2 && s2.c(), o2 = space(), create_component(i2.$$.fragment), attr(n2, "class", "input svelte-mobile-companion-a5e-038vch56tr3-1f8ze4q");
  }, m(t19, c2) {
    a2 && a2.m(t19, c2), insert(t19, e2, c2), insert(t19, n2, c2), s2 && s2.m(n2, null), insert(t19, o2, c2), mount_component(i2, t19, c2), r2 = true;
  }, p(t19, [o3]) {
    t19[3] ? a2 ? (a2.p(t19, o3), 8 & o3 && transition_in(a2, 1)) : (a2 = create_if_block_1$y(t19), a2.c(), transition_in(a2, 1), a2.m(e2.parentNode, e2)) : a2 && (group_outros(), transition_out(a2, 1, 1, () => {
      a2 = null;
    }), check_outros()), t19[4] ? s2 ? (s2.p(t19, o3), 16 & o3 && transition_in(s2, 1)) : (s2 = create_if_block$1t(t19), s2.c(), transition_in(s2, 1), s2.m(n2, null)) : s2 && (group_outros(), transition_out(s2, 1, 1, () => {
      s2 = null;
    }), check_outros());
    const r3 = {};
    1 & o3 && (r3.rows = t19[0]), 2 & o3 && (r3.columns = t19[1]), 16 & o3 && (r3.editMode = t19[4]), i2.$set(r3);
  }, i(t19) {
    r2 || (transition_in(a2), transition_in(s2), transition_in(i2.$$.fragment, t19), r2 = true);
  }, o(t19) {
    transition_out(a2), transition_out(s2), transition_out(i2.$$.fragment, t19), r2 = false;
  }, d(t19) {
    t19 && (detach(e2), detach(n2), detach(o2)), a2 && a2.d(t19), s2 && s2.d(), destroy_component(i2, t19);
  } };
}
function getWidgetSettingsFromStore(t18) {
  return t18.map((t19) => {
    var e2;
    return { row: t19.row, col: t19.col, rowSpan: t19.rowSpan, colSpan: t19.colSpan, widget: t19.widget ? { key: t19.widget.key, props: null === (e2 = t19.widget) || void 0 === e2 ? void 0 : e2.props } : void 0 };
  });
}
function instance$2x(t18, e2, n2) {
  let o2, i2, r2;
  const a2 = getContext(CONTEXT$1.LOADED_APP);
  component_subscribe(t18, a2, (t19) => n2(2, o2 = t19));
  const s2 = writable([]);
  component_subscribe(t18, s2, (t19) => n2(16, r2 = t19)), setContext(CONTEXT$1.WIDGET_STORE, s2), setContext(CONTEXT$1.DISPLAYED_IN_WIDGET, true);
  const c2 = getContext(CONTEXT$1.EDIT_MODE);
  component_subscribe(t18, c2, (t19) => n2(4, i2 = t19));
  const l2 = createEventDispatcher();
  let u2 = 0, p2 = 0;
  function d2() {
    s2.set([]), o2.gridStoreDef || console.error("gridStoreDef is not set."), n2(0, u2 = o2.gridStoreDef.rows), n2(1, p2 = o2.gridStoreDef.columns), m2();
  }
  function m2() {
    const t19 = [], e3 = /* @__PURE__ */ new Set();
    for (let n3 = 0; n3 < u2; n3++) for (let o3 = 0; o3 < p2; o3++) {
      const i3 = `${n3}-${o3}`;
      if (e3.has(i3)) continue;
      const r3 = f2(n3, o3), a3 = { row: n3, col: o3, rowSpan: r3.rowSpan, colSpan: r3.colSpan, widget: h2(n3, o3) };
      t19.push(a3);
      for (let t20 = n3; t20 < n3 + a3.rowSpan; t20++) for (let n4 = o3; n4 < o3 + a3.colSpan; n4++) e3.add(`${t20}-${n4}`);
    }
    s2.set(t19);
  }
  function f2(t19, e3) {
    var n3;
    if (c2) {
      const n4 = r2.filter((n5) => n5.row === t19 && n5.col === e3);
      if (n4 && n4.length > 0) return { colSpan: n4[0].colSpan, rowSpan: n4[0].rowSpan };
    }
    let i3 = null === (n3 = o2.gridStoreDef.widgets) || void 0 === n3 ? void 0 : n3.filter((n4) => n4.row === t19 && n4.col === e3);
    return i3 && i3.length > 0 ? { colSpan: i3[0].colSpan, rowSpan: i3[0].rowSpan } : { colSpan: 1, rowSpan: 1 };
  }
  function h2(t19, e3) {
    var n3, i3, a3, s3;
    if (c2) {
      const n4 = r2.filter((n5) => n5.row === t19 && n5.col === e3);
      if (n4 && n4.length > 0) return n4[0].widget;
    }
    if (!((null === (n3 = o2.gridStoreDef) || void 0 === n3 ? void 0 : n3.widgets) && (null === (i3 = o2.gridStoreDef) || void 0 === i3 ? void 0 : i3.widgets) instanceof Array)) return;
    const l3 = null === (s3 = null === (a3 = o2.gridStoreDef) || void 0 === a3 ? void 0 : a3.widgets) || void 0 === s3 ? void 0 : s3.filter((n4) => n4.row === t19 && n4.col === e3);
    if (!l3 || 0 === l3.length || !l3[0].widget) return;
    let u3 = l3[0];
    if (u3.widget.key && WidgetRegistry.get(u3.widget.key)) {
      return { id: foundry.utils.randomID(), key: u3.widget.key, props: u3.widget.props, component: WidgetRegistry.get(u3.widget.key) };
    }
  }
  let g2 = false;
  return t18.$$.update = () => {
    3 & t18.$$.dirty && c2 && u2 > 0 && p2 > 0 && m2(), 4 & t18.$$.dirty && (null == o2 ? void 0 : o2.id) && d2();
  }, [u2, p2, o2, g2, i2, a2, s2, c2, function() {
    set_store_value(a2, o2.gridStoreDef = { rows: u2, columns: p2, widgets: getWidgetSettingsFromStore(r2) }, o2), l2("update", o2), d2(), set_store_value(c2, i2 = false, i2);
  }, function() {
    d2(), set_store_value(c2, i2 = false, i2);
  }, function() {
    l2("delete", o2), n2(3, g2 = false);
  }, () => n2(3, g2 = false), function() {
    o2.name = this.value, a2.set(o2);
  }, function() {
    u2 = to_number(this.value), n2(0, u2);
  }, function() {
    p2 = to_number(this.value), n2(1, p2);
  }, () => n2(3, g2 = true)];
}
class GridWrapper extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2x, create_fragment$2w, safe_not_equal, {});
  }
}
function enable$1() {
  const t18 = document.body, e2 = t18.requestFullscreen || t18.webkitRequestFullscreen || t18.mozRequestFullScreen || t18.msRequestFullscreen;
  if (e2) e2.call(t18);
  else if (void 0 !== window.ActiveXObject) {
    const t19 = new ActiveXObject("WScript.Shell");
    null !== t19 && t19.SendKeys("{F11}");
  }
}
function disable$1() {
  const t18 = document, e2 = t18.exitFullscreen || t18.webkitExitFullscreen || t18.mozCancelFullScreen || t18.msExitFullscreen;
  if (e2) e2.call(document);
  else if (void 0 !== window.ActiveXObject) {
    const t19 = new ActiveXObject("WScript.Shell");
    null !== t19 && t19.SendKeys("{F11}");
  }
}
function toggleFullscreen$1() {
  const t18 = document;
  t18.fullscreenElement || t18.webkitFullscreenElement || t18.mozFullScreenElement || t18.msFullscreenElement ? disable$1() : enable$1();
}
function create_fragment$2v(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2;
  return { c() {
    e2 = element("div"), n2 = element("div"), n2.innerHTML = '<i class="fas fa-maximize"></i>Fullscreen', o2 = space(), i2 = element("div"), i2.innerHTML = '<i class="fas fa-gears"></i>Settings', r2 = space(), a2 = element("div"), a2.innerHTML = '<i class="fas fa-sign-out-alt"></i>Logout', attr(n2, "class", "menu-button svelte-mobile-companion-a5e-038vch56tr3-47f88c"), attr(n2, "aria-hidden", "true"), attr(i2, "class", "menu-button svelte-mobile-companion-a5e-038vch56tr3-47f88c"), attr(i2, "aria-hidden", "true"), attr(a2, "class", "menu-button svelte-mobile-companion-a5e-038vch56tr3-47f88c"), attr(a2, "aria-hidden", "true"), attr(e2, "class", "context-menu svelte-mobile-companion-a5e-038vch56tr3-47f88c"), set_style(e2, "top", t18[0].top + "px"), set_style(e2, "left", t18[0].left + "px");
  }, m(s3, p2) {
    insert(s3, e2, p2), append(e2, n2), append(e2, o2), append(e2, i2), append(e2, r2), append(e2, a2), c2 = true, l2 || (u2 = [listen(n2, "click", toggleFullscreen$1), listen(i2, "click", t18[1]), listen(a2, "click", handleLogout$1)], l2 = true);
  }, p(t19, [n3]) {
    (!c2 || 1 & n3) && set_style(e2, "top", t19[0].top + "px"), (!c2 || 1 & n3) && set_style(e2, "left", t19[0].left + "px");
  }, i(t19) {
    c2 || (t19 && add_render_callback(() => {
      c2 && (s2 || (s2 = create_bidirectional_transition(e2, slide, {}, true)), s2.run(1));
    }), c2 = true);
  }, o(t19) {
    t19 && (s2 || (s2 = create_bidirectional_transition(e2, slide, {}, false)), s2.run(0)), c2 = false;
  }, d(t19) {
    t19 && detach(e2), t19 && s2 && s2.end(), l2 = false, run_all(u2);
  } };
}
function handleLogout$1() {
  ui.menu.items.logout.onClick();
}
function instance$2w(t18, e2, n2) {
  let { menuPosition: o2 } = e2;
  const i2 = createEventDispatcher();
  return t18.$$set = (t19) => {
    "menuPosition" in t19 && n2(0, o2 = t19.menuPosition);
  }, [o2, function(t19) {
    t19.stopPropagation(), game.settings.sheet && game.settings.sheet.close(), i2("closeContextMenu"), game.settings.sheet.render(true, { focus: true });
  }];
}
class ContextMenu extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2w, create_fragment$2v, safe_not_equal, { menuPosition: 0 });
  }
}
function get_each_context$L(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[12] = e2[n2], o2;
}
function create_each_block$L(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2 = t18[12].label + "";
  function l2() {
    return t18[9](t18[12]);
  }
  return { c() {
    e2 = element("button"), n2 = text(c2), o2 = space(), attr(e2, "class", i2 = "text-button " + t18[12].buttonClass + " svelte-mobile-companion-a5e-038vch56tr3-1e6ru65"), attr(e2, "aria-label", r2 = t18[12].label ? t18[12].label : null), toggle_class(e2, "active", t18[12].id.includes(t18[3]));
  }, m(t19, i3) {
    insert(t19, e2, i3), append(e2, n2), append(e2, o2), a2 || (s2 = listen(e2, "click", prevent_default(l2)), a2 = true);
  }, p(o3, a3) {
    t18 = o3, 1 & a3 && c2 !== (c2 = t18[12].label + "") && set_data(n2, c2), 1 & a3 && i2 !== (i2 = "text-button " + t18[12].buttonClass + " svelte-mobile-companion-a5e-038vch56tr3-1e6ru65") && attr(e2, "class", i2), 1 & a3 && r2 !== (r2 = t18[12].label ? t18[12].label : null) && attr(e2, "aria-label", r2), 9 & a3 && toggle_class(e2, "active", t18[12].id.includes(t18[3]));
  }, d(t19) {
    t19 && detach(e2), a2 = false, s2();
  } };
}
function create_if_block$1s(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2 = t18[5] && create_if_block_1$x(t18);
  return { c() {
    e2 = element("div"), n2 = element("button"), n2.innerHTML = '<i class="fa-solid fa-bars svelte-mobile-companion-a5e-038vch56tr3-1e6ru65" aria-hidden="true"></i>', o2 = space(), c2 && c2.c(), i2 = empty(), attr(n2, "class", "round-button svelte-mobile-companion-a5e-038vch56tr3-1e6ru65"), attr(n2, "aria-label", "Menu"), attr(e2, "class", "menu-buttons svelte-mobile-companion-a5e-038vch56tr3-1e6ru65");
  }, m(l2, u2) {
    insert(l2, e2, u2), append(e2, n2), insert(l2, o2, u2), c2 && c2.m(l2, u2), insert(l2, i2, u2), r2 = true, a2 || (s2 = listen(n2, "click", t18[8]), a2 = true);
  }, p(t19, e3) {
    t19[5] ? c2 ? (c2.p(t19, e3), 32 & e3 && transition_in(c2, 1)) : (c2 = create_if_block_1$x(t19), c2.c(), transition_in(c2, 1), c2.m(i2.parentNode, i2)) : c2 && (group_outros(), transition_out(c2, 1, 1, () => {
      c2 = null;
    }), check_outros());
  }, i(t19) {
    r2 || (transition_in(c2), r2 = true);
  }, o(t19) {
    transition_out(c2), r2 = false;
  }, d(t19) {
    t19 && (detach(e2), detach(o2), detach(i2)), c2 && c2.d(t19), a2 = false, s2();
  } };
}
function create_if_block_1$x(t18) {
  let e2, n2;
  return e2 = new ContextMenu({ props: { menuPosition: t18[6] } }), e2.$on("closeContextMenu", t18[11]), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    64 & n3 && (o2.menuPosition = t19[6]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_fragment$2u(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2, p2 = ensure_array_like(t18[0]), d2 = [];
  for (let e3 = 0; e3 < p2.length; e3 += 1) d2[e3] = create_each_block$L(get_each_context$L(t18, p2, e3));
  let m2 = t18[2] && create_if_block$1s(t18);
  return { c() {
    e2 = space(), n2 = element("header"), o2 = element("div");
    for (let t19 = 0; t19 < d2.length; t19 += 1) d2[t19].c();
    i2 = space(), r2 = element("button"), r2.innerHTML = '<i class="fas fa-plus svelte-mobile-companion-a5e-038vch56tr3-1e6ru65"></i>', a2 = space(), m2 && m2.c(), attr(r2, "class", "round-button svelte-mobile-companion-a5e-038vch56tr3-1e6ru65"), attr(o2, "class", "custom-buttons svelte-mobile-companion-a5e-038vch56tr3-1e6ru65"), attr(n2, "class", "header svelte-mobile-companion-a5e-038vch56tr3-1e6ru65"), attr(n2, "style", s2 = t18[4].join(" "));
  }, m(s3, p3) {
    insert(s3, e2, p3), insert(s3, n2, p3), append(n2, o2);
    for (let t19 = 0; t19 < d2.length; t19 += 1) d2[t19] && d2[t19].m(o2, null);
    append(o2, i2), append(o2, r2), append(n2, a2), m2 && m2.m(n2, null), c2 = true, l2 || (u2 = [listen(document.body, "click", t18[7]), listen(r2, "click", prevent_default(t18[10]))], l2 = true);
  }, p(t19, [e3]) {
    if (9 & e3) {
      let n3;
      for (p2 = ensure_array_like(t19[0]), n3 = 0; n3 < p2.length; n3 += 1) {
        const r3 = get_each_context$L(t19, p2, n3);
        d2[n3] ? d2[n3].p(r3, e3) : (d2[n3] = create_each_block$L(r3), d2[n3].c(), d2[n3].m(o2, i2));
      }
      for (; n3 < d2.length; n3 += 1) d2[n3].d(1);
      d2.length = p2.length;
    }
    t19[2] ? m2 ? (m2.p(t19, e3), 4 & e3 && transition_in(m2, 1)) : (m2 = create_if_block$1s(t19), m2.c(), transition_in(m2, 1), m2.m(n2, null)) : m2 && (group_outros(), transition_out(m2, 1, 1, () => {
      m2 = null;
    }), check_outros()), (!c2 || 16 & e3 && s2 !== (s2 = t19[4].join(" "))) && attr(n2, "style", s2);
  }, i(t19) {
    c2 || (transition_in(m2), c2 = true);
  }, o(t19) {
    transition_out(m2), c2 = false;
  }, d(t19) {
    t19 && (detach(e2), detach(n2)), destroy_each(d2, t19), m2 && m2.d(), l2 = false, run_all(u2);
  } };
}
function handleButtonClick$1(t18) {
  t18.onClick();
}
function instance$2v(t18, e2, n2) {
  let o2, { customButtons: i2 = [] } = e2, { addButton: r2 } = e2, { menuButtons: a2 } = e2, { activeFilter: s2 } = e2, { headerStyle: c2 = [] } = e2, l2 = false;
  return t18.$$set = (t19) => {
    "customButtons" in t19 && n2(0, i2 = t19.customButtons), "addButton" in t19 && n2(1, r2 = t19.addButton), "menuButtons" in t19 && n2(2, a2 = t19.menuButtons), "activeFilter" in t19 && n2(3, s2 = t19.activeFilter), "headerStyle" in t19 && n2(4, c2 = t19.headerStyle);
  }, [i2, r2, a2, s2, c2, l2, o2, function() {
    l2 && n2(5, l2 = false);
  }, function(t19) {
    if (t19.stopPropagation(), n2(5, l2 = !l2), l2) {
      const e3 = t19.target.getBoundingClientRect(), i3 = -15, r3 = -100;
      n2(6, o2 = { top: e3.bottom + window.scrollY + i3, left: e3.left + window.scrollX + r3 });
    }
  }, (t19) => handleButtonClick$1(t19), () => handleButtonClick$1(r2), () => n2(5, l2 = false)];
}
let Header$1 = class extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2v, create_fragment$2u, safe_not_equal, { customButtons: 0, addButton: 1, menuButtons: 2, activeFilter: 3, headerStyle: 4 });
  }
};
function create_else_block$c(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2;
  return i2 = new FontAwesomeIcon$1({ props: { icon: faPlus } }), { c() {
    e2 = element("button"), n2 = text("Click the here or the "), o2 = element("span"), create_component(i2.$$.fragment), r2 = text(" icon to add a new grid"), attr(e2, "class", "noAppText svelte-mobile-companion-a5e-038vch56tr3-135q56d");
  }, m(l2, u2) {
    insert(l2, e2, u2), append(e2, n2), append(e2, o2), mount_component(i2, o2, null), append(e2, r2), a2 = true, s2 || (c2 = listen(e2, "click", t18[10]), s2 = true);
  }, p: noop$4, i(t19) {
    a2 || (transition_in(i2.$$.fragment, t19), a2 = true);
  }, o(t19) {
    transition_out(i2.$$.fragment, t19), a2 = false;
  }, d(t19) {
    t19 && detach(e2), destroy_component(i2), s2 = false, c2();
  } };
}
function create_if_block$1r(t18) {
  let e2, n2;
  return e2 = new GridWrapper({}), e2.$on("update", t18[11]), e2.$on("delete", t18[12]), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p: noop$4, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_default_slot$p(t18) {
  let e2, n2, o2, i2, r2, a2;
  n2 = new Header$1({ props: { customButtons: t18[2], addButton: t18[9], activeFilter: t18[3], menuButtons: t18[1] ? void 0 : t18[5] } });
  const s2 = [create_if_block$1r, create_else_block$c], c2 = [];
  function l2(t19, e3) {
    return t19[4] ? 0 : 1;
  }
  return i2 = l2(t18), r2 = c2[i2] = s2[i2](t18), { c() {
    e2 = element("main"), create_component(n2.$$.fragment), o2 = space(), r2.c(), attr(e2, "class", "pd-8 svelte-mobile-companion-a5e-038vch56tr3-135q56d"), toggle_class(e2, "isWindowed", t18[1]);
  }, m(t19, r3) {
    insert(t19, e2, r3), mount_component(n2, e2, null), append(e2, o2), c2[i2].m(e2, null), a2 = true;
  }, p(t19, o3) {
    const u2 = {};
    4 & o3 && (u2.customButtons = t19[2]), 8 & o3 && (u2.activeFilter = t19[3]), 2 & o3 && (u2.menuButtons = t19[1] ? void 0 : t19[5]), n2.$set(u2);
    let p2 = i2;
    i2 = l2(t19), i2 === p2 ? c2[i2].p(t19, o3) : (group_outros(), transition_out(c2[p2], 1, 1, () => {
      c2[p2] = null;
    }), check_outros(), r2 = c2[i2], r2 ? r2.p(t19, o3) : (r2 = c2[i2] = s2[i2](t19), r2.c()), transition_in(r2, 1), r2.m(e2, null)), (!a2 || 2 & o3) && toggle_class(e2, "isWindowed", t19[1]);
  }, i(t19) {
    a2 || (transition_in(n2.$$.fragment, t19), transition_in(r2), a2 = true);
  }, o(t19) {
    transition_out(n2.$$.fragment, t19), transition_out(r2), a2 = false;
  }, d(t19) {
    t19 && detach(e2), destroy_component(n2), c2[i2].d();
  } };
}
function create_fragment$2t(t18) {
  let e2, n2, o2;
  function i2(e3) {
    t18[14](e3);
  }
  let r2 = { $$slots: { default: [create_default_slot$p] }, $$scope: { ctx: t18 } };
  return void 0 !== t18[0] && (r2.elementRoot = t18[0]), e2 = new ApplicationShell({ props: r2 }), binding_callbacks.push(() => bind(e2, "elementRoot", i2)), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, n3) {
    mount_component(e2, t19, n3), o2 = true;
  }, p(t19, [o3]) {
    const i3 = {};
    524318 & o3 && (i3.$$scope = { dirty: o3, ctx: t19 }), !n2 && 1 & o3 && (n2 = true, i3.elementRoot = t19[0], add_flush_callback(() => n2 = false)), e2.$set(i3);
  }, i(t19) {
    o2 || (transition_in(e2.$$.fragment, t19), o2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), o2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function instance$2u(t18, e2, n2) {
  let o2, i2, r2, { elementRoot: a2 } = e2, { isWindowed: s2 = false } = e2;
  const c2 = gmCompanionSettings.getWritableStore(GM_COMPANION_DATA);
  component_subscribe(t18, c2, (t19) => n2(13, o2 = t19));
  const l2 = writable(false);
  component_subscribe(t18, l2, (t19) => n2(15, i2 = t19)), setContext(CONTEXT$1.EDIT_MODE, l2);
  const u2 = writable(void 0);
  component_subscribe(t18, u2, (t19) => n2(4, r2 = t19)), setContext(CONTEXT$1.LOADED_APP, u2);
  const p2 = { id: ["addNew"], iconClass: "fas fa-plus", buttonClass: "", label: "Add", onClick: () => {
    f2();
  } };
  let d2, m2 = [];
  function f2() {
    const t19 = { id: foundry.utils.randomID(), type: "actor", name: "New Grid", gridStoreDef: { rows: 2, columns: 2, widgets: [] } };
    c2.update((e3) => Object.assign(Object.assign({}, e3), { [t19.id]: t19 })), h2(t19);
  }
  function h2(t19) {
    d2 === t19.id ? l2.set(true) : i2 || (n2(3, d2 = t19.id), u2.set(t19));
  }
  function g2() {
    m2.length > 0 && h2(Object.values(o2)[0]);
  }
  return onMount(() => {
    g2();
  }), t18.$$set = (t19) => {
    "elementRoot" in t19 && n2(0, a2 = t19.elementRoot), "isWindowed" in t19 && n2(1, s2 = t19.isWindowed);
  }, t18.$$.update = () => {
    8192 & t18.$$.dirty && o2 && n2(2, m2 = function(t19) {
      const e3 = [];
      return Object.values(t19).forEach((t20) => {
        e3.push({ id: [t20.id], iconClass: "", buttonClass: "", label: t20.name, onClick: () => h2(t20) });
      }), e3;
    }(o2));
  }, [a2, s2, m2, d2, r2, { buttonClass: "", iconClass: "a5e-nav-item" }, c2, l2, u2, p2, f2, function(t19) {
    const e3 = t19.detail;
    c2.update((t20) => Object.assign(Object.assign({}, t20), { [e3.id]: e3 }));
  }, function(t19) {
    const e3 = t19.detail;
    u2.set(void 0), c2.update((t20) => {
      const n3 = Object.assign({}, t20);
      return delete n3[e3.id], n3;
    }), m2.splice(m2.findIndex((t20) => t20.id[0] === e3.id), 1), set_store_value(l2, i2 = false, i2), g2();
  }, o2, function(t19) {
    a2 = t19, n2(0, a2);
  }];
}
let GMCompanionShell$1 = class extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2u, create_fragment$2t, safe_not_equal, { elementRoot: 0, isWindowed: 1 });
  }
  get elementRoot() {
    return this.$$.ctx[0];
  }
  set elementRoot(t18) {
    this.$$set({ elementRoot: t18 }), flush();
  }
  get isWindowed() {
    return this.$$.ctx[1];
  }
  set isWindowed(t18) {
    this.$$set({ isWindowed: t18 }), flush();
  }
};
class GMCompanionShell extends SvelteApp {
  constructor(t18) {
    super(), this.options.svelte.props = { ...this.options.svelte.props, ...t18 };
  }
  static get defaultOptions() {
    return foundry.utils.mergeObject(super.defaultOptions, { title: "Gamemaster Companion A5e", id: getBaseModuleId(), classes: [getBaseModuleId(), "windowed"], width: 1e3, height: 800, resizable: true, svelte: { class: GMCompanionShell$1, target: document.body, props: { isWindowed: true } } });
  }
}
function get_each_context$K(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[10] = e2[n2], o2[11] = e2, o2[12] = n2, o2;
}
function create_if_block$1q(t18) {
  let e2;
  return { c() {
    e2 = element("p"), e2.textContent = "You don't have a dedicated user with GM role. You can not set the current user as a\r\n                            companion!";
  }, m(t19, n2) {
    insert(t19, e2, n2);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_each_block$K(t18, e2) {
  let n2, o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, m2, f2, h2, g2 = e2[10].name + "";
  function _() {
    e2[5].call(c2, e2[11], e2[12]);
  }
  function $2() {
    e2[6].call(p2, e2[11], e2[12]);
  }
  return { key: t18, first: null, c() {
    n2 = element("li"), o2 = element("div"), i2 = element("h4"), r2 = text(g2), a2 = space(), s2 = element("div"), c2 = element("input"), l2 = space(), u2 = element("div"), p2 = element("input"), m2 = space(), attr(c2, "type", "checkbox"), attr(p2, "type", "number"), p2.disabled = d2 = !e2[10].enabled, attr(n2, "class", "item svelte-mobile-companion-a5e-038vch56tr3-1ui4rzp"), attr(n2, "data-item-id", this.id), this.first = n2;
  }, m(t19, d3) {
    insert(t19, n2, d3), append(n2, o2), append(o2, i2), append(i2, r2), append(n2, a2), append(n2, s2), append(s2, c2), c2.checked = e2[10].enabled, append(n2, l2), append(n2, u2), append(u2, p2), set_input_value(p2, e2[10].screenWidth), append(n2, m2), f2 || (h2 = [listen(c2, "change", _), listen(p2, "input", $2)], f2 = true);
  }, p(t19, n3) {
    e2 = t19, 2 & n3 && g2 !== (g2 = e2[10].name + "") && set_data(r2, g2), 2 & n3 && (c2.checked = e2[10].enabled), 2 & n3 && d2 !== (d2 = !e2[10].enabled) && (p2.disabled = d2), 2 & n3 && to_number(p2.value) !== e2[10].screenWidth && set_input_value(p2, e2[10].screenWidth);
  }, d(t19) {
    t19 && detach(n2), f2 = false, run_all(h2);
  } };
}
function create_default_slot$o(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, m2, f2, h2, g2, _ = [], $2 = /* @__PURE__ */ new Map(), b2 = 0 === t18[1]?.length && create_if_block$1q(), y2 = ensure_array_like(t18[1]);
  const v2 = (t19) => t19[10].id;
  for (let e3 = 0; e3 < y2.length; e3 += 1) {
    let n3 = get_each_context$K(t18, y2, e3), o3 = v2(n3);
    $2.set(o3, _[e3] = create_each_block$K(o3, n3));
  }
  return { c() {
    e2 = element("form"), n2 = element("div"), o2 = element("ol"), i2 = element("li"), i2.innerHTML = "<div>GM-User</div> <div>Enable</div> <div>Activation screen width</div>", r2 = space(), a2 = element("ol"), b2 && b2.c(), s2 = space();
    for (let t19 = 0; t19 < _.length; t19 += 1) _[t19].c();
    c2 = space(), l2 = element("div"), u2 = element("button"), u2.textContent = "Save", p2 = space(), d2 = element("button"), d2.textContent = "Cancel", m2 = space(), f2 = element("button"), f2.textContent = "Open Companion Editor", attr(i2, "class", "table-header svelte-mobile-companion-a5e-038vch56tr3-1ui4rzp"), attr(a2, "class", "item-list svelte-mobile-companion-a5e-038vch56tr3-1ui4rzp"), attr(o2, "class", "svelte-mobile-companion-a5e-038vch56tr3-1ui4rzp"), attr(n2, "class", "settings svelte-mobile-companion-a5e-038vch56tr3-1ui4rzp"), attr(d2, "type", "reset"), attr(l2, "class", "save-cancel-button svelte-mobile-companion-a5e-038vch56tr3-1ui4rzp"), set_style(e2, "height", "100%"), attr(e2, "class", "svelte-mobile-companion-a5e-038vch56tr3-1ui4rzp");
  }, m($3, y3) {
    insert($3, e2, y3), append(e2, n2), append(n2, o2), append(o2, i2), append(o2, r2), append(o2, a2), b2 && b2.m(a2, null), append(a2, s2);
    for (let t19 = 0; t19 < _.length; t19 += 1) _[t19] && _[t19].m(a2, null);
    append(e2, c2), append(e2, l2), append(l2, u2), append(l2, p2), append(l2, d2), append(e2, m2), append(e2, f2), h2 || (g2 = [listen(u2, "click", prevent_default(t18[3])), listen(d2, "click", prevent_default(t18[7])), listen(f2, "click", prevent_default(t18[4]))], h2 = true);
  }, p(t19, e3) {
    0 === t19[1]?.length ? b2 || (b2 = create_if_block$1q(), b2.c(), b2.m(a2, s2)) : b2 && (b2.d(1), b2 = null), 2 & e3 && (y2 = ensure_array_like(t19[1]), _ = update_keyed_each(_, e3, v2, 1, t19, y2, $2, a2, destroy_block, create_each_block$K, null, get_each_context$K));
  }, d(t19) {
    t19 && detach(e2), b2 && b2.d();
    for (let t20 = 0; t20 < _.length; t20 += 1) _[t20].d();
    h2 = false, run_all(g2);
  } };
}
function create_fragment$2s(t18) {
  let e2, n2, o2;
  function i2(e3) {
    t18[8](e3);
  }
  let r2 = { $$slots: { default: [create_default_slot$o] }, $$scope: { ctx: t18 } };
  return void 0 !== t18[0] && (r2.elementRoot = t18[0]), e2 = new ApplicationShell({ props: r2 }), binding_callbacks.push(() => bind(e2, "elementRoot", i2)), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, n3) {
    mount_component(e2, t19, n3), o2 = true;
  }, p(t19, [o3]) {
    const i3 = {};
    8194 & o3 && (i3.$$scope = { dirty: o3, ctx: t19 }), !n2 && 1 & o3 && (n2 = true, i3.elementRoot = t19[0], add_flush_callback(() => n2 = false)), e2.$set(i3);
  }, i(t19) {
    o2 || (transition_in(e2.$$.fragment, t19), o2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), o2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function instance$2t(t18, e2, n2) {
  let { elementRoot: o2 } = e2;
  const { application: i2 } = getContext("#external"), r2 = game.settings.get(getFullModuleId(), settings.gmCompanionUser);
  let a2 = game.users.filter((t19) => {
    const e3 = t19.uuid === game.user.uuid, n3 = t19.role === FoundryUserRoles.GAMEMASTER.valueOf(), o3 = t19.role === FoundryUserRoles.ASSISTANT_GM.valueOf();
    return !e3 && (n3 || o3);
  }).map((t19) => {
    let e3 = r2[t19.id] || {};
    return foundry.utils.isNewerVersion(game.version, "12") ? foundry.utils.mergeObject({ id: t19.id, name: t19.name, enabled: false, screenWidth: 0 }, e3) : mergeObject({ id: t19.id, name: t19.name, enabled: false, screenWidth: 0 }, e3);
  });
  return t18.$$set = (t19) => {
    "elementRoot" in t19 && n2(0, o2 = t19.elementRoot);
  }, [o2, a2, i2, function() {
    a2.forEach((t19) => {
      let e3 = r2[t19.id] || {};
      e3.enabled = t19.enabled, e3.screenWidth = t19.screenWidth || 0, r2[t19.id] = e3;
    }), game.settings.set(getFullModuleId(), settings.gmCompanionUser, r2), i2.close();
  }, function() {
    new GMCompanionShell().render(true);
  }, function(t19, e3) {
    t19[e3].enabled = this.checked, n2(1, a2);
  }, function(t19, e3) {
    t19[e3].screenWidth = to_number(this.value), n2(1, a2);
  }, () => i2.close(), function(t19) {
    o2 = t19, n2(0, o2);
  }];
}
let GMCompanionSetupShell$1 = class extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2t, create_fragment$2s, safe_not_equal, { elementRoot: 0 });
  }
  get elementRoot() {
    return this.$$.ctx[0];
  }
  set elementRoot(t18) {
    this.$$set({ elementRoot: t18 }), flush();
  }
};
class GMCompanionSetupShell extends SvelteApp {
  static get defaultOptions() {
    return foundry.utils.mergeObject(super.defaultOptions, { title: "Settings", width: "auto", height: "auto", resizable: false, svelte: { class: GMCompanionSetupShell$1, target: document.body } });
  }
}
class SettingsGMCompanion extends FormApplication {
  static #ze;
  static showSettings() {
    return this.#ze = this.#ze ? this.#ze : new GMCompanionSetupShell(), this.#ze.render(true, { focus: true }), this.#ze;
  }
  constructor(t18 = {}) {
    super({}, t18), SettingsGMCompanion.showSettings();
  }
  async _updateObject(t18, e2) {
    await super._updateObject(t18, e2);
  }
  render() {
    this.close();
  }
}
const GM_COMPANION_DATA = "gmCompanionData", scope$1 = { client: "client", world: "world" };
class GMCompanionGameSettings extends TJSGameSettings {
  constructor(t18) {
    super(t18);
  }
  getWritableStore(t18) {
    return super.getWritableStore(t18);
  }
  init(t18) {
    super.registerAll(getWorldSettings$1(t18), true);
  }
}
function initGMCompanionSettings(t18) {
  gmCompanionSettings = new GMCompanionGameSettings(t18), gmCompanionSettings.init(t18);
}
function setupGMCompanion(t18, e2) {
  e2.push({ namespace: t18, key: settings.gmCompanionUser, options: { scope: scope$1.world, config: false, default: {}, type: Object } }), e2.push({ namespace: t18, key: GM_COMPANION_DATA, options: { scope: scope$1.world, config: false, type: Object, default: [] } });
}
function getWorldSettings$1(t18) {
  const e2 = [];
  return setupGMCompanion(t18, e2), e2;
}
let gmCompanionSettings;
const USE_CURRENCY = "useCurrency", USE_CURRENCY_WEIGHT = "useCurrencyWeight", USE_ENCUMBRANCE = "useEncumbrance", USE_CONTAINER = "useContainer", SHOW_MOD_NAMES = "showModNames", LOG_USER_CHANGES = "logUserChanges", SHOW_DEATH_PULSING = "showDeathPulsing", SPLITSCREEN_ENABLED = "splitscreenEnabled", VERIFIED = "verified", scope = { client: "client", world: "world" };
class MobileCompanionGameSettings extends TJSGameSettings$1 {
  constructor() {
    setSubModuleId(() => "a5e"), super("mobile-companion-a5e");
  }
  getWritableStore(t18) {
    return super.getWritableStore(t18);
  }
  init() {
    const t18 = getFullModuleId$1();
    initGMCompanionSettings(t18), super.registerAll(getWorldSettings(t18), true), super.registerAll(getClientSettings(t18), true), super.registerAll(getCommonSettings(t18, mobileCompanionGameSettings), true);
  }
}
function getWorldSettings(t18) {
  const e2 = [];
  return setupUserMenu(t18, e2), e2.push({ namespace: t18, key: USE_CURRENCY_WEIGHT, options: { name: myi18n("Settings.UseCurrencyWeight.Name"), hint: myi18n("Settings.UseCurrencyWeight.Hint"), scope: scope.world, config: true, type: Boolean, default: true } }), e2.push({ namespace: t18, key: USE_ENCUMBRANCE, options: { name: myi18n("Settings.UseEncumbrance.Name"), hint: myi18n("Settings.UseEncumbrance.Hint"), scope: scope.world, config: true, type: Boolean, default: true } }), e2;
}
function getClientSettings(t18) {
  const e2 = [];
  return e2.push({ namespace: t18, key: USE_CURRENCY, options: { name: myi18n("Settings.UseCurrency.Name"), hint: myi18n("Settings.UseCurrency.Hint"), scope: scope.client, config: true, type: Boolean, default: true } }), e2.push({ namespace: t18, key: LOG_USER_CHANGES, options: { name: myi18n("Settings.LogUserChanged.Name"), hint: myi18n("Settings.LogUserChanged.Hint"), scope: scope.world, config: true, type: Boolean, default: false } }), e2.push({ namespace: t18, key: USE_CONTAINER, options: { name: myi18n("Settings.UseContainer.Name"), hint: myi18n("Settings.UseContainer.Hint"), scope: scope.client, config: true, type: Boolean, default: true } }), e2.push({ namespace: t18, key: SHOW_MOD_NAMES, options: { name: myi18n("Settings.ShowAttackModifierNames.Name"), hint: myi18n("Settings.ShowAttackModifierNames.Hint"), scope: scope.client, config: true, type: Boolean, default: false } }), e2.push({ namespace: t18, key: "lastActorId", options: { scope: scope.client, config: false, type: String, default: "" } }), e2.push({ namespace: t18, key: VERIFIED, options: { scope: "world", config: false, type: String, default: "" } }), e2.push({ namespace: t18, key: SHOW_DEATH_PULSING, options: { name: myi18n("Settings.ShowDeathPulsing.Name"), hint: myi18n("Settings.ShowDeathPulsing.Hint"), scope: scope.client, config: true, type: Boolean, default: true } }), e2.push({ namespace: t18, key: SPLITSCREEN_ENABLED, options: { name: myi18n("Settings.Splitscreen.Name"), hint: myi18n("Settings.Splitscreen.Hint"), scope: "client", config: true, type: Boolean, default: false } }), e2;
}
function setupUserMenu(t18, e2) {
  game.settings.registerMenu(t18, settings$1.usersMenu, { name: "Set users", label: "Users", hint: "Set up users who use mobile companion", type: SettingsUser, icon: "fas fa-users", restricted: true }), e2.push({ namespace: t18, key: settings$1.users, options: { scope: scope.world, config: false, default: {}, type: Object } });
}
const mobileCompanionGameSettings = new MobileCompanionGameSettings();
function isFull() {
  return false;
}
const now = Date.now();
class InvalidTokenError extends Error {
}
function b64DecodeUnicode(t18) {
  return decodeURIComponent(atob(t18).replace(/(.)/g, (t19, e2) => {
    let n2 = e2.charCodeAt(0).toString(16).toUpperCase();
    return n2.length < 2 && (n2 = "0" + n2), "%" + n2;
  }));
}
function base64UrlDecode(t18) {
  let e2 = t18.replace(/-/g, "+").replace(/_/g, "/");
  switch (e2.length % 4) {
    case 0:
      break;
    case 2:
      e2 += "==";
      break;
    case 3:
      e2 += "=";
      break;
    default:
      throw new Error("base64 string is not of the correct length");
  }
  try {
    return b64DecodeUnicode(e2);
  } catch (t19) {
    return atob(e2);
  }
}
function jwtDecode(t18, e2) {
  if ("string" != typeof t18) throw new InvalidTokenError("Invalid token specified: must be a string");
  e2 || (e2 = {});
  const n2 = true === e2.header ? 0 : 1, o2 = t18.split(".")[n2];
  if ("string" != typeof o2) throw new InvalidTokenError(`Invalid token specified: missing part #${n2 + 1}`);
  let i2;
  try {
    i2 = base64UrlDecode(o2);
  } catch (t19) {
    throw new InvalidTokenError(`Invalid token specified: invalid base64 for part #${n2 + 1} (${t19.message})`);
  }
  try {
    return JSON.parse(i2);
  } catch (t19) {
    throw new InvalidTokenError(`Invalid token specified: invalid json for part #${n2 + 1} (${t19.message})`);
  }
}
InvalidTokenError.prototype.name = "InvalidTokenError";
var Filters = ((t18) => (t18.Character = "character", t18.Skills = "skills", t18.Features = "features", t18.Maneuvers = "maneuvers", t18.Object = "object", t18.Spell = "spell", t18.Traits = "traits", t18.CharacterSelect = "characterSelect", t18.TradeWindow = "tradeWindow", t18))(Filters || {});
const ActorFlags = { concentration: "concentratingOnSpell" };
function handleUpdate(t18, e2, n2) {
  const { triggeringActor: o2, changes: i2, item: r2, user: a2 } = t18;
  let s2 = get_store_value(e2);
  r2?.parent?.id === s2.id && (sendChatMessage(o2?.parent?.name, i2, r2.name, a2), s2 = game.actors.find((t19) => t19.id === s2.id), e2.set(s2), n2());
}
function handleActorUpdate(t18, e2, n2) {
  let { changedActor: o2, changes: i2, user: r2 } = t18, a2 = get_store_value(e2);
  a2.id === o2.id && (sendChatMessage(o2.name, i2, o2.name, r2), a2 = o2, e2.set(a2), n2());
}
function handleCreateEffect(t18, e2, n2) {
  let o2 = get_store_value(e2);
  const i2 = "Concentration" === t18.name;
  if (t18.parent.id === o2.id) {
    if (i2) {
      if (o2.getFlag(getFullModuleId$1(), ActorFlags.concentration)) return;
      o2.setFlag(getFullModuleId$1(), ActorFlags.concentration, "a spell");
    }
    e2.set(o2), n2();
  }
}
function handleDeleteEffect(t18, e2, n2) {
  let o2 = get_store_value(e2);
  const i2 = "Concentration" === t18.name;
  t18.parent.id === o2.id && (i2 && o2.unsetFlag(getFullModuleId$1(), ActorFlags.concentration), e2.set(o2), n2());
}
function sendChatMessage(t18, e2, n2, o2) {
  if (!game.settings.get(getFullModuleId$1(), LOG_USER_CHANGES)) return;
  const { _id: i2, _stats: r2, flags: a2, ...s2 } = e2;
  fromUuid(`User.${o2}`).then((e3) => {
    if (!e3.isGM) return ChatMessage.create({ content: `${t18} changed ${n2}: ${JSON.stringify(s2)}` });
  });
}
const HOOKS = { OPEN_TRADE: "mcOpenTradeApp", CLOSE_TRADE: "mcCloseTradeApp", UPDATE_TRADE: "mcUpdateTrade", ITEM_MARK_TAKEN: "mcItemTaken", UNDO_MARK_TAKEN: "mcUndoItemTaken", ITEM_MARK_BUY: "mcItemBuy", UNDO_ITEM_BUY: "mcUndoItemBuy", CURRENCY_TAKEN: "mcCurrencyTaken" };
class FoundryProxy {
  constructor(t18) {
    this.original = t18, this.gameSystem = game.system.id;
  }
  get img() {
    return this.original.img;
  }
  get name() {
    return this.original.name;
  }
  get uuid() {
    return this.original.uuid;
  }
  getFlag(t18, e2) {
    return this.original.getFlag(t18, e2);
  }
  setFlag(t18, e2, n2) {
    return this.original.setFlag(t18, e2, n2);
  }
  async update(t18) {
    return this.original.update(t18);
  }
  get sheet() {
    return this.original.sheet;
  }
  createEmbeddedDocuments(t18, e2) {
    this.original.createEmbeddedDocuments(t18, e2);
  }
  isA5e() {
    return "a5e" === this.gameSystem;
  }
  isDND5e() {
    return "dnd5e" === this.gameSystem;
  }
}
class ItemProxy extends FoundryProxy {
  constructor(t18) {
    super(t18), this.original = t18;
  }
  get quantity() {
    if (this.isA5e()) return this.original.system.quantity;
    if (this.isDND5e()) return this.original.system.quantity;
    throw new Error("Unsupported System");
  }
  get price() {
    if (this.isA5e()) return this.original.system.price;
    if (this.isDND5e()) {
      let t18 = this.original.system.price;
      return t18.value + " " + t18.denomination;
    }
    throw new Error("Unsupported System");
  }
  get description() {
    if (this.isA5e()) return this.original.system.description;
    if (this.isDND5e()) return this.original.system.description.value ? this.original.system.description.value : this.original.system.description ? this.original.system.description : "";
    throw new Error("Unsupported System");
  }
  async updateQuantity(t18) {
    if (this.isA5e()) return this.update({ system: { quantity: t18 } });
    if (this.isDND5e()) return this.update({ system: { quantity: t18 } });
    throw new Error("Unsupported System");
  }
  getQuantityPath() {
    if (this.isA5e()) return "quantity";
    if (this.isDND5e()) return "quantity";
    throw new Error("Unsupported System");
  }
  getPricePath() {
    if (this.isA5e()) return "price";
    if (this.isDND5e()) return "price";
    throw new Error("Unsupported System");
  }
}
class ProviderItem {
  constructor(t18, e2) {
    this.item = new ItemProxy(fromUuidSync(t18)), this.quantityTaken = e2;
  }
  getAmountItemsLeft() {
    return Math.max(this.item.quantity - this.quantityTaken, 0);
  }
  toJSON() {
    return { itemUuid: this.item.uuid, itemsTaken: this.quantityTaken };
  }
}
const MY_PILES = { MODULE: getFullModuleId$1(), DATA: "data", ITEM: "item" }, copperMap = /* @__PURE__ */ new Map([["cp", 1], ["sp", 10], ["ep", 50], ["gp", 100], ["pp", 1e3]]);
function convertToCopper(t18) {
  let e2 = 0;
  for (const [n2, o2] of copperMap.entries()) e2 += (t18[n2] || 0) * o2;
  return e2;
}
function convertFromCopper(t18) {
  const e2 = new Currency$1();
  let n2 = t18;
  return e2.pp = Math.floor(n2 / 1e3), n2 -= 1e3 * e2.pp, e2.gp = Math.floor(n2 / 100), n2 -= 100 * e2.gp, e2.ep = Math.floor(n2 / 50), n2 -= 50 * e2.ep, e2.sp = Math.floor(n2 / 10), n2 -= 10 * e2.sp, e2.cp = n2, e2;
}
let Currency$1 = class t17 {
  constructor() {
    this.cp = 0, this.sp = 0, this.ep = 0, this.gp = 0, this.pp = 0;
  }
  static empty() {
    return new t17();
  }
  static fromPriceString(e2) {
    const n2 = new t17(), { cp: o2, ep: i2, gp: r2, pp: a2, sp: s2 } = t17.convertPriceToCurrency(e2);
    return n2.cp = o2, n2.sp = s2, n2.ep = i2, n2.gp = r2, n2.pp = a2, n2;
  }
  static fromJSON(e2) {
    const n2 = new t17();
    return n2.cp = e2.cp ?? 0, n2.sp = e2.sp ?? 0, n2.ep = e2.ep ?? 0, n2.gp = e2.gp ?? 0, n2.pp = e2.pp ?? 0, n2;
  }
  static convertPriceToCurrency(e2) {
    let n2 = new t17();
    const o2 = e2.trim().toLowerCase();
    if (!o2) return n2;
    const i2 = /([\d,]+(?:\.\d+)?)\s*(pp|gp|ep|sp|cp)/g;
    let r2;
    for (; null !== (r2 = i2.exec(o2)); ) {
      const t18 = parseFloat(r2[1].replace(/,/g, "")), e3 = r2[2];
      isNaN(t18) || (n2[e3] = t18);
    }
    return n2;
  }
  clone() {
    const e2 = new t17();
    return e2.cp = this.cp, e2.sp = this.sp, e2.ep = this.ep, e2.gp = this.gp, e2.pp = this.pp, e2;
  }
  toJSON() {
    return { cp: this.cp, sp: this.sp, ep: this.ep, gp: this.gp, pp: this.pp };
  }
  subtract(e2) {
    const n2 = new t17();
    return n2.cp = this.cp - e2.cp, n2.sp = this.sp - e2.sp, n2.ep = this.ep - e2.ep, n2.gp = this.gp - e2.gp, n2.pp = this.pp - e2.pp, n2;
  }
  add(e2) {
    const n2 = new t17();
    return n2.cp = this.cp + e2.cp, n2.sp = this.sp + e2.sp, n2.ep = this.ep + e2.ep, n2.gp = this.gp + e2.gp, n2.pp = this.pp + e2.pp, n2;
  }
  divideBy(e2) {
    const n2 = new t17();
    return n2.pp = Math.floor(this.pp / e2), n2.gp = Math.floor(this.gp / e2), n2.ep = Math.floor(this.ep / e2), n2.sp = Math.floor(this.sp / e2), n2.cp = Math.floor(this.cp / e2), n2;
  }
  multiplyBy(e2) {
    let n2 = new t17(), o2 = 0;
    const i2 = ["pp", "gp", "ep", "sp", "cp"];
    for (const t18 of i2) {
      const i3 = this[t18] || 0, r3 = copperMap.get(t18), a2 = i3 * e2;
      n2[t18] = Math.floor(a2);
      const s2 = a2 - n2[t18];
      o2 += Math.round(s2 * r3);
    }
    const r2 = convertFromCopper(o2);
    return n2.add(r2);
  }
  toPriceString() {
    let t18 = "";
    return 0 !== this.pp && (t18 += `${this.pp} pp `), 0 !== this.gp && (t18 += `${this.gp} gp `), 0 !== this.ep && (t18 += `${this.ep} ep `), 0 !== this.sp && (t18 += `${this.sp} sp `), 0 !== this.cp && (t18 += `${this.cp} cp `), t18.trim() ? t18.trim() : "Free";
  }
};
function getItemPilesItemFlag(t18) {
}
class MerchantItem extends ProviderItem {
  constructor(t18, e2 = 0, n2 = 1) {
    super(t18, e2), this.originalPrice = Currency$1.fromPriceString(this.item.price), this.currentPrice = this.originalPrice.multiplyBy(n2);
  }
  get isHidden() {
    const t18 = getItemPilesItemFlag(this.item);
    if (t18) return t18.hidden ?? false;
    const e2 = this.item.getFlag(MY_PILES.MODULE, MY_PILES.ITEM);
    return e2?.hidden ?? false;
  }
  get notForSale() {
    const t18 = getItemPilesItemFlag(this.item);
    if (t18) return t18.notForSale ?? false;
    const e2 = this.item.getFlag(MY_PILES.MODULE, MY_PILES.ITEM);
    return e2?.notForSale ?? false;
  }
  static fromJSON(t18) {
    let { itemUuid: e2, itemsTaken: n2 } = t18;
    return new MerchantItem(e2, n2, 1);
  }
  toJSON() {
    return { ...super.toJSON(), currentPrice: this.currentPrice, originalPrice: this.originalPrice };
  }
  toggleHidden() {
    this.item.setFlag(MY_PILES.MODULE, MY_PILES.ITEM, { hidden: !this.isHidden });
  }
  toggleNotForSale() {
    this.item.setFlag(MY_PILES.MODULE, MY_PILES.ITEM, { notForSale: !this.notForSale });
  }
}
var CharacterPermission = ((t18) => (t18[t18.None = 0] = "None", t18[t18.Limited = 1] = "Limited", t18[t18.Observer = 2] = "Observer", t18[t18.Owner = 3] = "Owner", t18))(CharacterPermission || {});
class ActorProxy extends FoundryProxy {
  constructor(t18) {
    super(t18), this.original = t18;
  }
  get type() {
    return this.original.type;
  }
  get img() {
    return this.original.img;
  }
  get name() {
    return this.original.name;
  }
  get uuid() {
    return this.original.uuid;
  }
  get inventory() {
    if (this.isA5e()) {
      return this.original.itemTypes.object.map((t18) => new ItemProxy(t18));
    }
    if (this.isDND5e()) {
      const t18 = this.original;
      return [...t18.itemTypes.consumable, ...t18.itemTypes.container, ...t18.itemTypes.equipment, ...t18.itemTypes.loot, ...t18.itemTypes.tool, ...t18.itemTypes.weapon].map((t19) => new ItemProxy(t19));
    }
    throw new Error("Unsupported System");
  }
  get currency() {
    if (this.isA5e()) return this.original.system.currency;
    if (this.isDND5e()) return this.original.system.currency;
    throw new Error("Unsupported System");
  }
  async updateCurrency(t18) {
    if (this.isA5e()) return this.update({ system: { currency: t18 } });
    if (this.isDND5e()) return this.update({ system: { currency: t18 } });
    throw new Error("Unsupported System");
  }
}
var TradePartnerType = ((t18) => (t18.merchant = "merchant", t18.pile = "pile", t18.container = "container", t18.vault = "vault", t18.unknown = "unknown", t18))(TradePartnerType || {});
class ItemProvider {
  constructor(t18) {
    this.inventory = /* @__PURE__ */ new Map(), this.providerUuid = t18, this.provider = new ActorProxy(fromUuidSync(t18)), this.mapInventory();
  }
  setType(t18) {
    this.provider.setFlag(MY_PILES.MODULE, MY_PILES.DATA, { type: t18 });
  }
  toJSON() {
    return { type: this.getType(), providerUuid: this.provider.uuid };
  }
  takeItem(t18, e2 = 1) {
    const n2 = this.inventory.get(t18.item.uuid);
    n2 && n2.getAmountItemsLeft() >= e2 && (n2.quantityTaken += t18.quantityTaken);
  }
  mapInventory() {
    this.provider.inventory.forEach((t18) => this.inventory.set(t18.uuid, new MerchantItem(t18.uuid)));
  }
}
function calculateTotalCost(t18) {
  let e2 = Currency$1.empty();
  return t18.forEach((t19) => e2 = e2.add(t19.currentPrice)), e2;
}
function emitTradeUpdate(t18) {
  getFullModuleId$1(), HOOKS.UPDATE_TRADE, game.socket.emit("module." + getFullModuleId$1(), { type: HOOKS.UPDATE_TRADE, data: t18.toJSON() });
}
function emitUpdateAsGM() {
  const t18 = get_store_value(tradeStore);
  emitTradeUpdate(t18), Hooks.callAll(HOOKS.UPDATE_TRADE, t18);
}
function objectEquals(t18, e2) {
  t18.name, e2.name, t18.price, e2.price, t18.description, e2.description;
  const n2 = t18.name === e2.name, o2 = t18.price === e2.price, i2 = t18.description === e2.description;
  return n2 && o2 && i2;
}
class LootItem extends ProviderItem {
  constructor(t18, e2 = 0) {
    super(t18, e2);
  }
}
class LootChest extends ItemProvider {
  constructor(t18) {
    super(t18), this.itemsTakenBy = /* @__PURE__ */ new Map(), this.currencyTakenBy = /* @__PURE__ */ new Map();
  }
  static fromJSON(t18) {
    const e2 = new LootChest(t18.providerUuid);
    return e2.itemsTakenBy = /* @__PURE__ */ new Map(), Object.entries(t18.itemsTakenBy).forEach(([t19, n2]) => {
      n2.forEach((n3) => {
        e2.inventory.get(n3.itemUuid) && e2.takeItemFromLootChest(t19, n3.itemUuid, n3.itemsTaken);
      });
    }), Object.entries(t18.currencyTakenBy).forEach(([t19, n2]) => {
      const o2 = Currency$1.fromJSON(n2);
      e2.currencyTakenBy.set(t19, o2);
    }), e2;
  }
  toJSON() {
    const t18 = {}, e2 = {};
    return this.itemsTakenBy.forEach((e3, n2) => {
      t18[n2] = e3.map((t19) => t19.toJSON());
    }), this.currencyTakenBy.forEach((t19, n2) => {
      e2[n2] = t19.toJSON();
    }), { ...super.toJSON(), itemsTakenBy: t18, currencyTakenBy: e2 };
  }
  getItemsTakenBy(t18) {
    return this.itemsTakenBy.get(t18) ?? [];
  }
  getItemQuantityTakenByPlayer(t18, e2) {
    const n2 = this.getItemsTakenBy(t18);
    if (!n2) return 0;
    const o2 = n2.find((t19) => t19.item.uuid === e2.item.uuid);
    return o2?.quantityTaken ?? 0;
  }
  getCurrencyTakenBy(t18) {
    return this.currencyTakenBy.get(t18) ?? Currency$1.empty();
  }
  getType() {
    return TradePartnerType.pile;
  }
  resetPlayerData(t18) {
    this.resetItemsTakenByPlayer(t18.uuid);
  }
  resetItemsTakenByPlayer(t18) {
    this.itemsTakenBy.delete(t18), this.currencyTakenBy.delete(t18);
  }
  getProviderCurrency() {
    return Currency$1.fromJSON(this.provider.currency);
  }
  getProviderCurrencyLeft() {
    let t18 = this.getProviderCurrency();
    return Array.from(this.currencyTakenBy.values()).forEach((e2) => {
      t18 = t18.subtract(e2);
    }), t18;
  }
  confirmTrade(t18) {
    const e2 = fromUuid(t18);
    e2 ? e2.then((e3) => {
      const n2 = new ActorProxy(e3);
      this.getItemsTakenBy(t18).filter((t19) => t19.getAmountItemsLeft() >= 0).forEach((t19) => {
        addItemToPlayerInventory(n2, t19.item, t19.quantityTaken), this.reduceItemFromChest(t19.item, t19.quantityTaken);
      });
      const o2 = this.getCurrencyTakenBy(t18), i2 = Currency$1.fromJSON(n2.currency);
      n2.updateCurrency(i2.add(o2));
      const r2 = Currency$1.fromJSON(this.provider.currency);
      this.provider.updateCurrency(r2.subtract(o2)), this.resetItemsTakenByPlayer(t18);
    }) : console.error("Actor " + t18 + " not found");
  }
  returnAllItemsAndCurrency(t18) {
    (this.itemsTakenBy.get(t18) ?? []).forEach((e2) => {
      const n2 = this.inventory.get(e2.item.uuid);
      n2 && this.returnItemToLootChest(t18, n2.item.uuid, e2.quantityTaken);
    }), this.itemsTakenBy.set(t18, []), this.currencyTakenBy.set(t18, Currency$1.empty()), emitUpdateAsGM();
  }
  takeItemFromLootChest(t18, e2, n2 = 1) {
    if (!this.inventory.has(e2)) return;
    let o2 = this.inventory.get(e2);
    const i2 = Math.min(o2.getAmountItemsLeft(), n2), r2 = new LootItem(e2, i2);
    if (this.itemsTakenBy.has(t18)) {
      const n3 = this.itemsTakenBy.get(t18) ?? [];
      if (0 === n3.length) n3.push(r2);
      else {
        const t19 = n3?.find((t20) => t20.item.uuid === e2);
        t19 ? t19.quantityTaken += i2 : n3.push(r2);
      }
    } else this.itemsTakenBy.set(t18, [r2]);
    super.takeItem(r2, i2);
  }
  returnItemToLootChest(t18, e2, n2 = 1) {
    this.takeItemFromLootChest(t18, e2, -1 * n2), this.removeZeroQtyItems(t18);
  }
  takeCurrencyFromLootChest(t18, e2) {
    this.currencyTakenBy.set(t18, e2);
  }
  getSettings() {
    if (this.provider) {
      const t18 = this.provider.getFlag(MY_PILES.MODULE, MY_PILES.DATA);
      if (t18) return { enabled: t18.enabled ?? true, type: TradePartnerType.pile };
    }
    return { enabled: true, type: TradePartnerType.pile };
  }
  saveSettings(t18) {
    this.provider && (this.provider.setFlag(MY_PILES.MODULE, MY_PILES.DATA, t18), emitUpdateAsGM());
  }
  removeZeroQtyItems(t18) {
    const e2 = this.itemsTakenBy.get(t18);
    if (e2) {
      const n2 = e2.filter((t19) => 0 !== t19.quantityTaken);
      this.itemsTakenBy.set(t18, n2);
    }
  }
  reduceItemFromChest(t18, e2) {
    const n2 = this.inventory.get(t18.uuid);
    n2 && (n2.quantityTaken -= e2), t18.updateQuantity(t18.quantity - e2);
  }
}
function addItemToPlayerInventory(t18, e2, n2) {
  const o2 = t18.inventory.find((t19) => objectEquals(t19, e2));
  if (o2) o2.updateQuantity(o2.quantity + n2);
  else {
    const o3 = { ...e2.original, system: { ...e2.original.system, [e2.getQuantityPath()]: n2 } };
    t18.createEmbeddedDocuments("Item", [o3]);
  }
}
function calculatePayment(t18, e2) {
  const n2 = convertToCopper(t18), o2 = convertToCopper(e2);
  if (n2 < o2) throw new Error(`Insufficient funds. Player has ${n2} cp, but needs ${o2} cp`);
  const i2 = new Currency$1();
  let r2 = 0, a2 = o2;
  const s2 = Array.from(copperMap.entries()).sort((t19, e3) => e3[1] - t19[1]);
  for (const [e3, n3] of s2) {
    const o3 = t18[e3], s3 = Math.floor(a2 / n3), c2 = Math.min(o3, s3);
    i2[e3] = c2, r2 += c2 * n3, a2 -= c2 * n3;
  }
  if (a2 > 0) for (const [e3, n3] of s2) {
    const o3 = t18[e3], s3 = i2[e3], c2 = o3 - s3;
    if (c2 > 0) {
      const t19 = Math.ceil(a2 / n3), o4 = Math.min(c2, t19);
      if (i2[e3] = s3 + o4, r2 += o4 * n3, a2 -= o4 * n3, a2 <= 0) break;
    }
  }
  return { payment: i2, change: convertFromCopper(r2 - o2) };
}
const DEFAULT_BUY_MOD = 0.5, DEFAULT_SELL_MOD = 1;
class Merchant extends ItemProvider {
  constructor(t18) {
    super(t18), this.itemsBoughtBy = /* @__PURE__ */ new Map(), this.buyModifier = DEFAULT_BUY_MOD, this.sellModifier = 1, this.setup();
  }
  static fromJSON(t18) {
    const e2 = new Merchant(t18.providerUuid);
    return e2.itemsBoughtBy = /* @__PURE__ */ new Map(), Object.entries(t18.itemsBoughtBy).forEach(([t19, n2]) => {
      n2.forEach((n3) => {
        const o2 = e2.inventory.get(n3.itemUuid);
        o2 && e2.buyItem(t19, o2.item.uuid, n3.itemsTaken);
      });
    }), e2;
  }
  getProviderCurrency() {
    return Currency$1.fromJSON(this.provider.currency) ?? Currency$1.empty();
  }
  getCurrencyAPlayerHasToPay(t18) {
    return this.getItemsBoughtBy(t18).reduce((t19, e2) => t19.add(e2.currentPrice.multiplyBy(e2.quantityTaken)), Currency$1.empty());
  }
  getItemQuantityTakenByPlayer(t18, e2) {
    const n2 = this.getItemsBoughtBy(t18);
    if (!n2) return 0;
    const o2 = n2.find((t19) => t19.item.uuid === e2.item.uuid);
    return o2?.quantityTaken ?? 0;
  }
  buyItem(t18, e2, n2 = 1) {
    if (!this.inventory.has(e2)) return;
    let o2 = this.inventory.get(e2);
    const i2 = Math.min(o2.getAmountItemsLeft(), n2), r2 = new MerchantItem(e2, i2, this.sellModifier);
    if (this.itemsBoughtBy.has(t18)) {
      const n3 = this.itemsBoughtBy.get(t18) ?? [];
      if (0 === n3.length) n3.push(r2);
      else {
        const t19 = n3?.find((t20) => t20.item.uuid === e2);
        t19 ? t19.quantityTaken += i2 : n3.push(r2);
      }
    } else this.itemsBoughtBy.set(t18, [r2]);
    super.takeItem(r2, i2);
  }
  returnItem(t18, e2, n2 = 1) {
    this.buyItem(t18, e2, -1 * n2), this.removeZeroQtyItems(t18);
  }
  confirmTrade(t18) {
    fromUuid(t18).then((e2) => {
      if (e2) {
        const n2 = new ActorProxy(e2), o2 = this.getItemsBoughtBy(t18).filter((t19) => t19.getAmountItemsLeft() >= 0);
        if (0 === o2.length) return;
        const i2 = Currency$1.fromJSON(n2.currency), r2 = calculateTotalCost(o2);
        n2.name, this.provider.name;
        let { change: a2, payment: s2 } = calculatePayment(i2, r2);
        n2.updateCurrency(i2.subtract(s2).add(a2));
        const c2 = this.getProviderCurrency();
        this.provider.updateCurrency(c2.add(s2).subtract(a2)), o2.forEach((t19) => {
          fromUuid(t19.item.uuid).then((e3) => {
            if (e3) {
              const o3 = new ItemProxy(e3);
              addItemToPlayerInventory(n2, o3, t19.quantityTaken), this.getSettings().infiniteQty || o3.updateQuantity(o3.quantity - t19.quantityTaken);
            }
          });
        }), this.resetItemsBoughtBy(t18);
      }
    });
  }
  getItemsBoughtBy(t18) {
    return this.itemsBoughtBy.get(t18) ?? [];
  }
  getType() {
    return TradePartnerType.merchant;
  }
  resetItemsBoughtBy(t18) {
    this.itemsBoughtBy.set(t18, []);
  }
  returnAllItemsAndCurrency(t18) {
    (this.itemsBoughtBy.get(t18) ?? []).forEach((e2) => {
      const n2 = this.inventory.get(e2.item.uuid);
      n2 && this.returnItem(t18, n2.item.uuid, e2.quantityTaken);
    }), this.itemsBoughtBy.set(t18, []), emitUpdateAsGM();
  }
  resetPlayerData(t18) {
    this.resetItemsBoughtBy(t18.uuid);
  }
  toJSON() {
    const t18 = {};
    return this.itemsBoughtBy.forEach((e2, n2) => {
      t18[n2] = e2.map((t19) => t19.toJSON());
    }), { ...super.toJSON(), itemsBoughtBy: t18 };
  }
  getSettings() {
    if (this.provider) {
      const t18 = this.provider.getFlag(MY_PILES.MODULE, MY_PILES.DATA);
      if (t18) return { buyModifier: t18.buyModifier ?? 0.5, buysItems: t18.buysItems ?? false, enabled: t18.enabled ?? true, infiniteMoney: t18.infiniteMoney ?? false, infiniteQty: t18.infiniteQty ?? false, sellModifier: t18.sellModifier ?? 1, type: TradePartnerType.merchant };
    }
    return { buyModifier: 0.5, buysItems: false, enabled: true, infiniteMoney: false, infiniteQty: false, sellModifier: 1, type: TradePartnerType.merchant };
  }
  saveSettings(t18) {
    this.provider && (this.provider.setFlag(MY_PILES.MODULE, MY_PILES.DATA, t18), t18.sellModifier !== this.sellModifier && (this.sellModifier = t18.sellModifier ?? 1, this.updateSellItemPrices(), emitUpdateAsGM()));
  }
  setup() {
    const t18 = this.getSettings();
    this.buyModifier = t18.buyModifier ?? DEFAULT_BUY_MOD, this.sellModifier = t18.sellModifier ?? DEFAULT_SELL_MOD, this.updateSellItemPrices();
  }
  updateSellItemPrices() {
    const t18 = Array.from(this.itemsBoughtBy.values()).flat();
    t18.push(...Array.from(this.inventory.values())), t18.forEach((t19) => {
      const e2 = t19;
      1 === this.sellModifier ? e2.currentPrice = e2.originalPrice : e2.currentPrice = e2.originalPrice.multiplyBy(this.sellModifier);
    });
  }
  removeZeroQtyItems(t18) {
    const e2 = this.itemsBoughtBy.get(t18);
    if (e2) {
      const n2 = e2.filter((t19) => 0 !== t19.quantityTaken);
      this.itemsBoughtBy.set(t18, n2);
    }
  }
  canPlayerAfford(t18, e2) {
    const n2 = this.getCurrencyAPlayerHasToPay(t18), o2 = this.inventory.get(e2)?.item.price, i2 = fromUuidSync(t18);
    if (i2 && o2) {
      const t19 = convertToCopper(Currency$1.fromPriceString(o2)), e3 = convertToCopper(n2) + t19;
      return convertToCopper(Currency$1.fromJSON(new ActorProxy(i2).currency)) >= e3;
    }
    return false;
  }
}
class ItemExchange {
  constructor() {
    this.players = /* @__PURE__ */ new Map();
  }
  static fromJSON(t18) {
    const e2 = new ItemExchange();
    if (t18.playerUuids.forEach((t19) => {
      const n2 = new ActorProxy(fromUuidSync(t19));
      e2.addPlayer(n2);
    }), t18.provider) if (t18.provider.type === TradePartnerType.merchant) {
      const n2 = Merchant.fromJSON(t18.provider);
      e2.setItemProvider(n2);
    } else {
      const n2 = LootChest.fromJSON(t18.provider);
      e2.setItemProvider(n2);
    }
    return e2;
  }
  addPlayer(t18) {
    this.players.set(t18.uuid, t18);
  }
  setItemProvider(t18) {
    this.itemProvider = t18;
  }
  removePlayer(t18) {
    this.players.delete(t18.uuid), this.itemProvider?.resetPlayerData(t18);
  }
  toJSON() {
    return { provider: this.itemProvider?.toJSON(), playerUuids: Array.from(this.players.keys()) };
  }
}
const tradeStore = writable(), tradeOpen = writable(), tradePlayer = writable();
function setTradePlayer(t18) {
  tradePlayer.set(new ActorProxy(t18));
}
class ClientHooks {
  static onTradeWindowOpen(t18, e2) {
    const n2 = t18.playerUuids, o2 = this.getCharactersWithMinimumPermission(CharacterPermission.Owner), i2 = o2?.filter((t19) => n2?.includes(t19.uuid)) ?? [], r2 = i2.findIndex((t19) => t19.uuid === game.user.character?.uuid);
    if (i2.length > 0) {
      const n3 = i2[r2 >= 0 ? r2 : 0];
      if (setTradePlayer(n3), !t18.provider) throw new Error("Failed to load trade partner:" + t18);
      tradeOpen.set(true), tradeStore.set(ItemExchange.fromJSON(t18)), e2(n3);
    }
  }
  static onTradeWindowClose(t18) {
    tradeOpen.set(false), t18();
  }
  static onTradeUpdate(t18, e2) {
    t18.playerUuids?.includes(e2) && t18.provider && tradeStore.set(ItemExchange.fromJSON(t18));
  }
  static getCharactersWithMinimumPermission(t18) {
    return game.actors.contents.filter((e2) => e2.ownership[game.user.id] >= t18);
  }
}
const actorStore$1 = writable({}), activeFilterStore$1 = writable(Filters.Character);
let currentFilter$1 = Filters.Character;
function initRight(t18) {
  actorStore$1.set(t18), activeFilterStore$1.subscribe((t19) => {
    currentFilter$1 = t19;
  });
}
const onHandleUpdate$1 = async (t18, e2, n2, o2) => {
  handleUpdate({ triggeringActor: n2, changes: e2, user: o2, item: t18 }, actorStore$1, () => switchFilter$1(get_store_value(activeFilterStore$1)));
}, onHandleActorUpdate$1 = async (t18, e2, n2, o2) => {
  handleActorUpdate({ changedActor: t18, changes: e2, user: o2 }, actorStore$1, () => switchFilter$1(get_store_value(activeFilterStore$1)));
}, onHandleCreateEffect$1 = async (t18, e2, n2) => {
  handleCreateEffect(t18, actorStore$1, () => switchFilter$1(get_store_value(activeFilterStore$1)));
}, onHandleDeleteEffect$1 = async (t18, e2, n2) => {
  handleDeleteEffect(t18, actorStore$1, () => switchFilter$1(get_store_value(activeFilterStore$1)));
}, onTradeWindowOpen = (t18) => {
  ClientHooks.onTradeWindowOpen(t18, (t19) => {
    actorStore$1.set(t19), switchFilter$1(Filters.TradeWindow);
  });
}, onTradeWindowClose = () => {
  ClientHooks.onTradeWindowClose(() => switchFilter$1(Filters.Character));
}, onTradeUpdate = (t18) => {
  ClientHooks.onTradeUpdate(t18, get_store_value(actorStore$1).uuid);
};
function handleOnMount$1() {
  Hooks.on("createActiveEffect", onHandleCreateEffect$1), Hooks.on("deleteActiveEffect", onHandleDeleteEffect$1), Hooks.on("createItem", onHandleUpdate$1), Hooks.on("deleteItem", onHandleUpdate$1), Hooks.on("updateItem", onHandleUpdate$1), Hooks.on("updateActor", onHandleActorUpdate$1), Hooks.on(HOOKS.OPEN_TRADE, onTradeWindowOpen), Hooks.on(HOOKS.CLOSE_TRADE, onTradeWindowClose), Hooks.on(HOOKS.UPDATE_TRADE, onTradeUpdate), switchFilter$1(get_store_value(activeFilterStore$1));
}
function handleOnDestroy$1() {
  Hooks.off("createActiveEffect", onHandleCreateEffect$1), Hooks.off("deleteActiveEffect", onHandleDeleteEffect$1), Hooks.off("createItem", onHandleUpdate$1), Hooks.off("deleteItem", onHandleUpdate$1), Hooks.off("updateItem", onHandleUpdate$1), Hooks.off("updateActor", onHandleActorUpdate$1), Hooks.off(HOOKS.OPEN_TRADE, onTradeWindowOpen), Hooks.off(HOOKS.CLOSE_TRADE, onTradeWindowClose), Hooks.off(HOOKS.UPDATE_TRADE, onTradeUpdate);
}
function switchFilter$1(t18) {
  activeFilterStore$1.set(t18);
}
function getCurrentFilterRight() {
  return currentFilter$1;
}
function enable() {
  const t18 = document.body, e2 = t18.requestFullscreen || t18.webkitRequestFullscreen || t18.mozRequestFullScreen || t18.msRequestFullscreen;
  if (e2) e2.call(t18);
  else if (void 0 !== window.ActiveXObject) {
    const t19 = new ActiveXObject("WScript.Shell");
    null !== t19 && t19.SendKeys("{F11}");
  }
}
function disable() {
  const t18 = document, e2 = t18.exitFullscreen || t18.webkitExitFullscreen || t18.mozCancelFullScreen || t18.msExitFullscreen;
  if (e2) e2.call(document);
  else if (void 0 !== window.ActiveXObject) {
    const t19 = new ActiveXObject("WScript.Shell");
    null !== t19 && t19.SendKeys("{F11}");
  }
}
function toggleFullscreen() {
  const t18 = document;
  t18.fullscreenElement || t18.webkitFullscreenElement || t18.mozFullScreenElement || t18.msFullscreenElement ? disable() : enable();
}
function get_each_context$J(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[10] = e2[n2], o2;
}
function create_each_block$J(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2;
  function l2() {
    return t18[9](t18[10]);
  }
  return { c() {
    e2 = element("button"), n2 = element("i"), i2 = space(), attr(n2, "class", o2 = null_to_empty(t18[10].iconClass) + " svelte-mobile-companion-a5e-038vch56tr3-v7dqul"), attr(n2, "aria-hidden", "true"), toggle_class(n2, "active", t18[10].id.includes(t18[2])), attr(e2, "class", r2 = "icon-button " + t18[10].buttonClass + " svelte-mobile-companion-a5e-038vch56tr3-v7dqul"), attr(e2, "aria-label", a2 = t18[10].label ? t18[10].label : null), toggle_class(e2, "active", t18[10].id.includes(t18[2]));
  }, m(t19, o3) {
    insert(t19, e2, o3), append(e2, n2), append(e2, i2), s2 || (c2 = listen(e2, "click", prevent_default(l2)), s2 = true);
  }, p(i3, s3) {
    t18 = i3, 1 & s3 && o2 !== (o2 = null_to_empty(t18[10].iconClass) + " svelte-mobile-companion-a5e-038vch56tr3-v7dqul") && attr(n2, "class", o2), 5 & s3 && toggle_class(n2, "active", t18[10].id.includes(t18[2])), 1 & s3 && r2 !== (r2 = "icon-button " + t18[10].buttonClass + " svelte-mobile-companion-a5e-038vch56tr3-v7dqul") && attr(e2, "class", r2), 1 & s3 && a2 !== (a2 = t18[10].label ? t18[10].label : null) && attr(e2, "aria-label", a2), 5 & s3 && toggle_class(e2, "active", t18[10].id.includes(t18[2]));
  }, d(t19) {
    t19 && detach(e2), s2 = false, c2();
  } };
}
function create_if_block$1p(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2 = t18[4] && create_if_block_1$w(t18);
  return { c() {
    e2 = element("div"), n2 = element("button"), o2 = element("i"), a2 = space(), u2 && u2.c(), s2 = empty(), attr(o2, "class", i2 = "fa-solid fa-bars " + t18[1]?.iconClass + " svelte-mobile-companion-a5e-038vch56tr3-v7dqul"), attr(o2, "aria-hidden", "true"), attr(n2, "class", r2 = "icon-button " + t18[1]?.buttonClass + " svelte-mobile-companion-a5e-038vch56tr3-v7dqul"), attr(n2, "aria-label", "Menu"), attr(e2, "class", "main-buttons svelte-mobile-companion-a5e-038vch56tr3-v7dqul");
  }, m(i3, r3) {
    insert(i3, e2, r3), append(e2, n2), append(n2, o2), insert(i3, a2, r3), u2 && u2.m(i3, r3), insert(i3, s2, r3), c2 || (l2 = listen(n2, "click", t18[7]), c2 = true);
  }, p(t19, e3) {
    2 & e3 && i2 !== (i2 = "fa-solid fa-bars " + t19[1]?.iconClass + " svelte-mobile-companion-a5e-038vch56tr3-v7dqul") && attr(o2, "class", i2), 2 & e3 && r2 !== (r2 = "icon-button " + t19[1]?.buttonClass + " svelte-mobile-companion-a5e-038vch56tr3-v7dqul") && attr(n2, "class", r2), t19[4] ? u2 ? (u2.p(t19, e3), 16 & e3 && transition_in(u2, 1)) : (u2 = create_if_block_1$w(t19), u2.c(), transition_in(u2, 1), u2.m(s2.parentNode, s2)) : u2 && (group_outros(), transition_out(u2, 1, 1, () => {
      u2 = null;
    }), check_outros());
  }, d(t19) {
    t19 && (detach(e2), detach(a2), detach(s2)), u2 && u2.d(t19), c2 = false, l2();
  } };
}
function create_if_block_1$w(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2;
  return { c() {
    e2 = element("div"), n2 = element("div"), n2.innerHTML = '<i class="fas fa-maximize"></i>Fullscreen', o2 = space(), i2 = element("div"), i2.innerHTML = '<i class="fas fa-gears"></i>Settings', r2 = space(), a2 = element("div"), a2.innerHTML = '<i class="fas fa-sign-out-alt"></i>Logout', attr(n2, "class", "menu-button svelte-mobile-companion-a5e-038vch56tr3-v7dqul"), attr(n2, "aria-hidden", "true"), attr(i2, "class", "menu-button svelte-mobile-companion-a5e-038vch56tr3-v7dqul"), attr(i2, "aria-hidden", "true"), attr(a2, "class", "menu-button svelte-mobile-companion-a5e-038vch56tr3-v7dqul"), attr(a2, "aria-hidden", "true"), attr(e2, "class", "context-menu svelte-mobile-companion-a5e-038vch56tr3-v7dqul"), set_style(e2, "top", t18[5].top + "px"), set_style(e2, "left", t18[5].left + "px");
  }, m(s3, p2) {
    insert(s3, e2, p2), append(e2, n2), append(e2, o2), append(e2, i2), append(e2, r2), append(e2, a2), c2 = true, l2 || (u2 = [listen(n2, "click", toggleFullscreen), listen(i2, "click", t18[8]), listen(a2, "click", handleLogout)], l2 = true);
  }, p(t19, n3) {
    (!c2 || 32 & n3) && set_style(e2, "top", t19[5].top + "px"), (!c2 || 32 & n3) && set_style(e2, "left", t19[5].left + "px");
  }, i(t19) {
    c2 || (t19 && add_render_callback(() => {
      c2 && (s2 || (s2 = create_bidirectional_transition(e2, slide, {}, true)), s2.run(1));
    }), c2 = true);
  }, o(t19) {
    t19 && (s2 || (s2 = create_bidirectional_transition(e2, slide, {}, false)), s2.run(0)), c2 = false;
  }, d(t19) {
    t19 && detach(e2), t19 && s2 && s2.end(), l2 = false, run_all(u2);
  } };
}
function create_fragment$2r(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2 = ensure_array_like(t18[0]), l2 = [];
  for (let e3 = 0; e3 < c2.length; e3 += 1) l2[e3] = create_each_block$J(get_each_context$J(t18, c2, e3));
  let u2 = t18[1] && create_if_block$1p(t18);
  return { c() {
    e2 = space(), n2 = element("header"), o2 = element("div");
    for (let t19 = 0; t19 < l2.length; t19 += 1) l2[t19].c();
    i2 = space(), u2 && u2.c(), attr(o2, "class", "custom-buttons svelte-mobile-companion-a5e-038vch56tr3-v7dqul"), attr(n2, "class", "header svelte-mobile-companion-a5e-038vch56tr3-v7dqul"), attr(n2, "style", r2 = t18[3].join(" "));
  }, m(r3, c3) {
    insert(r3, e2, c3), insert(r3, n2, c3), append(n2, o2);
    for (let t19 = 0; t19 < l2.length; t19 += 1) l2[t19] && l2[t19].m(o2, null);
    append(n2, i2), u2 && u2.m(n2, null), a2 || (s2 = listen(document.body, "click", t18[6]), a2 = true);
  }, p(t19, [e3]) {
    if (5 & e3) {
      let n3;
      for (c2 = ensure_array_like(t19[0]), n3 = 0; n3 < c2.length; n3 += 1) {
        const i3 = get_each_context$J(t19, c2, n3);
        l2[n3] ? l2[n3].p(i3, e3) : (l2[n3] = create_each_block$J(i3), l2[n3].c(), l2[n3].m(o2, null));
      }
      for (; n3 < l2.length; n3 += 1) l2[n3].d(1);
      l2.length = c2.length;
    }
    t19[1] ? u2 ? u2.p(t19, e3) : (u2 = create_if_block$1p(t19), u2.c(), u2.m(n2, null)) : u2 && (u2.d(1), u2 = null), 8 & e3 && r2 !== (r2 = t19[3].join(" ")) && attr(n2, "style", r2);
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && (detach(e2), detach(n2)), destroy_each(l2, t19), u2 && u2.d(), a2 = false, s2();
  } };
}
function handleLogout() {
  ui.menu.items.logout.onClick();
}
function handleButtonClick(t18) {
  t18.onClick();
}
function instance$2s(t18, e2, n2) {
  let { customButtons: o2 = [] } = e2, { menuButtons: i2 } = e2, { activeFilter: r2 } = e2, { headerStyle: a2 = [] } = e2, s2 = false, c2 = { top: 0, left: 0 };
  return t18.$$set = (t19) => {
    "customButtons" in t19 && n2(0, o2 = t19.customButtons), "menuButtons" in t19 && n2(1, i2 = t19.menuButtons), "activeFilter" in t19 && n2(2, r2 = t19.activeFilter), "headerStyle" in t19 && n2(3, a2 = t19.headerStyle);
  }, [o2, i2, r2, a2, s2, c2, function() {
    s2 && n2(4, s2 = false);
  }, function(t19) {
    if (t19.stopPropagation(), n2(4, s2 = !s2), s2) {
      const e3 = t19.target.getBoundingClientRect(), o3 = -15, i3 = -100;
      n2(5, c2 = { top: e3.bottom + window.scrollY + o3, left: e3.left + window.scrollX + i3 });
    }
  }, function(t19) {
    t19.stopPropagation(), game.settings.sheet && game.settings.sheet.close(), n2(4, s2 = false), game.settings.sheet.render(true, { focus: true });
  }, (t19) => handleButtonClick(t19)];
}
class Header extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2s, create_fragment$2r, safe_not_equal, { customButtons: 0, menuButtons: 1, activeFilter: 2, headerStyle: 3 });
  }
}
var RollType = ((t18) => (t18.attack = "attack", t18.damage = "damage", t18.healing = "healing", t18.generic = "generic", t18.savingThrow = "savingThrow", t18.skillCheck = "skillCheck", t18.toolCheck = "toolCheck", t18))(RollType || {}), PreparedLevel = ((t18) => (t18[t18.NotPrepared = 0] = "NotPrepared", t18[t18.Prepared = 1] = "Prepared", t18[t18.AlwaysPrepared = 2] = "AlwaysPrepared", t18))(PreparedLevel || {}), ObjectType = ((t18) => (t18.Weapon = "weapon", t18.Armor = "armor", t18.Helm = "helm", t18.Shield = "shield", t18.Ammunition = "ammunition", t18.Clothing = "clothing", t18.Consumable = "consumable", t18.Container = "container", t18.Jewelry = "jewelry", t18.Miscellaneous = "miscellaneous", t18.Tool = "tool", t18))(ObjectType || {}), EquippedState = ((t18) => (t18[t18.NOT_CARRIED = 0] = "NOT_CARRIED", t18[t18.CARRIED = 1] = "CARRIED", t18[t18.EQUIPPED = 2] = "EQUIPPED", t18))(EquippedState || {}), DamageState = ((t18) => (t18[t18.INTACT = 0] = "INTACT", t18[t18.DAMAGED = 1] = "DAMAGED", t18[t18.BROKEN = 2] = "BROKEN", t18))(DamageState || {});
function create_else_block$b(t18) {
  let e2, n2, o2, i2, r2, a2;
  function s2(t19, e3) {
    return t19[0] <= 0 && t19[3] ? create_if_block_1$v : create_else_block_1$2;
  }
  let c2 = s2(t18), l2 = c2(t18);
  return { c() {
    l2.c(), e2 = space(), n2 = element("input"), o2 = space(), i2 = element("button"), i2.innerHTML = '<i class="fas fa-plus"></i>', attr(n2, "class", "input svelte-mobile-companion-a5e-038vch56tr3-7x0de1"), attr(n2, "type", "text"), n2.value = t18[0], attr(n2, "placeholder", "0"), attr(n2, "inputmode", "numeric"), attr(n2, "pattern", "[0-9+=\\-]*"), set_style(n2, "font-family", t18[1]), attr(n2, "min", "0"), attr(i2, "class", "adjustment-button svelte-mobile-companion-a5e-038vch56tr3-7x0de1");
  }, m(s3, c3) {
    l2.m(s3, c3), insert(s3, e2, c3), insert(s3, n2, c3), insert(s3, o2, c3), insert(s3, i2, c3), r2 || (a2 = [listen(n2, "input", t18[6]), listen(i2, "click", t18[4])], r2 = true);
  }, p(t19, o3) {
    c2 === (c2 = s2(t19)) && l2 ? l2.p(t19, o3) : (l2.d(1), l2 = c2(t19), l2 && (l2.c(), l2.m(e2.parentNode, e2))), 1 & o3 && n2.value !== t19[0] && (n2.value = t19[0]), 2 & o3 && set_style(n2, "font-family", t19[1]);
  }, d(t19) {
    t19 && (detach(e2), detach(n2), detach(o2), detach(i2)), l2.d(t19), r2 = false, run_all(a2);
  } };
}
function create_if_block$1o(t18) {
  let e2, n2;
  return { c() {
    e2 = element("div"), n2 = text(t18[0]), attr(e2, "class", "input");
  }, m(t19, o2) {
    insert(t19, e2, o2), append(e2, n2);
  }, p(t19, e3) {
    1 & e3 && set_data(n2, t19[0]);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_else_block_1$2(t18) {
  let e2, n2, o2;
  return { c() {
    e2 = element("button"), e2.innerHTML = '<i class="fas fa-minus"></i>', attr(e2, "class", "adjustment-button svelte-mobile-companion-a5e-038vch56tr3-7x0de1");
  }, m(i2, r2) {
    insert(i2, e2, r2), n2 || (o2 = listen(e2, "click", t18[5]), n2 = true);
  }, p: noop$4, d(t19) {
    t19 && detach(e2), n2 = false, o2();
  } };
}
function create_if_block_1$v(t18) {
  let e2, n2, o2;
  return { c() {
    e2 = element("button"), e2.innerHTML = '<i class="fas fa-trash"></i>', attr(e2, "class", "adjustment-button svelte-mobile-companion-a5e-038vch56tr3-7x0de1");
  }, m(i2, r2) {
    insert(i2, e2, r2), n2 || (o2 = listen(e2, "click", t18[7]), n2 = true);
  }, p: noop$4, d(t19) {
    t19 && detach(e2), n2 = false, o2();
  } };
}
function create_fragment$2q(t18) {
  let e2;
  function n2(t19, e3) {
    return t19[2] ? create_if_block$1o : create_else_block$b;
  }
  let o2 = n2(t18), i2 = o2(t18);
  return { c() {
    e2 = element("div"), i2.c(), attr(e2, "class", "item-quantity svelte-mobile-companion-a5e-038vch56tr3-7x0de1");
  }, m(t19, n3) {
    insert(t19, e2, n3), i2.m(e2, null);
  }, p(t19, [r2]) {
    o2 === (o2 = n2(t19)) && i2 ? i2.p(t19, r2) : (i2.d(1), i2 = o2(t19), i2 && (i2.c(), i2.m(e2, null)));
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2), i2.d();
  } };
}
function instance$2r(t18, e2, n2) {
  let { quantity: o2 = 0 } = e2, { fontFamily: i2 = "monospace" } = e2, { readOnly: r2 = false } = e2, { removeWhenZero: a2 = false } = e2;
  const s2 = createEventDispatcher();
  return t18.$$set = (t19) => {
    "quantity" in t19 && n2(0, o2 = t19.quantity), "fontFamily" in t19 && n2(1, i2 = t19.fontFamily), "readOnly" in t19 && n2(2, r2 = t19.readOnly), "removeWhenZero" in t19 && n2(3, a2 = t19.removeWhenZero);
  }, [o2, i2, r2, a2, function() {
    n2(0, o2++, o2), s2("onQtyChange", { newValue: o2 });
  }, function() {
    o2 > 0 && (n2(0, o2--, o2), s2("onQtyChange", { newValue: o2 }));
  }, function(t19) {
    n2(0, o2 = parseInt(t19.target.value || "0")), s2("onQtyChange", { newValue: o2 });
  }, function() {
    s2("remove");
  }];
}
class Quantity extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2r, create_fragment$2q, safe_not_equal, { quantity: 0, fontFamily: 1, readOnly: 2, removeWhenZero: 3 });
  }
}
function create_fragment$2p(t18) {
  let e2, n2, o2;
  return { c() {
    e2 = element("button"), attr(e2, "class", "action-button fa-star svelte-mobile-companion-a5e-038vch56tr3-4ofmct"), toggle_class(e2, "fas", t18[1]), toggle_class(e2, "active", t18[1]), toggle_class(e2, "fa-regular", !t18[1]);
  }, m(i2, r2) {
    insert(i2, e2, r2), n2 || (o2 = listen(e2, "click", stop_propagation(t18[2])), n2 = true);
  }, p(t19, [n3]) {
    2 & n3 && toggle_class(e2, "fas", t19[1]), 2 & n3 && toggle_class(e2, "active", t19[1]), 2 & n3 && toggle_class(e2, "fa-regular", !t19[1]);
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2), n2 = false, o2();
  } };
}
function instance$2q(t18, e2, n2) {
  let o2, { item: i2 } = e2;
  return t18.$$set = (t19) => {
    "item" in t19 && n2(0, i2 = t19.item);
  }, t18.$$.update = () => {
    1 & t18.$$.dirty && n2(1, o2 = i2.system.favorite);
  }, [i2, o2, () => i2.toggleFavorite()];
}
class ToggleFavoriteButton extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2q, create_fragment$2p, safe_not_equal, { item: 0 });
  }
}
const onRenderItemSheetStore = writable(void 0), readOnlyActor = writable(void 0), worldTimeStore = writable(0);
function isReadOnlyActor(t18) {
  return get_store_value(readOnlyActor)?.id === t18.id;
}
function create_if_block$1n(t18) {
  let e2, n2, o2, i2, r2, a2;
  const s2 = t18[4].default, c2 = create_slot(s2, t18, t18[3], null);
  return { c() {
    e2 = element("div"), n2 = element("span"), o2 = element("b"), o2.textContent = `${myi18n("A5E.StateToggle")}:`, i2 = space(), r2 = element("div"), c2 && c2.c(), attr(r2, "class", "button-wrapper svelte-mobile-companion-a5e-038vch56tr3-bd9x08"), attr(e2, "class", "state-toggle svelte-mobile-companion-a5e-038vch56tr3-bd9x08");
  }, m(t19, s3) {
    insert(t19, e2, s3), append(e2, n2), append(n2, o2), append(e2, i2), append(e2, r2), c2 && c2.m(r2, null), a2 = true;
  }, p(t19, e3) {
    c2 && c2.p && (!a2 || 8 & e3) && update_slot_base(c2, s2, t19, t19[3], a2 ? get_slot_changes(s2, t19[3], e3, null) : get_all_dirty_from_scope(t19[3]), null);
  }, i(t19) {
    a2 || (transition_in(c2, t19), a2 = true);
  }, o(t19) {
    transition_out(c2, t19), a2 = false;
  }, d(t19) {
    t19 && detach(e2), c2 && c2.d(t19);
  } };
}
function create_fragment$2o(t18) {
  let e2, n2, o2 = !t18[0] && create_if_block$1n(t18);
  return { c() {
    o2 && o2.c(), e2 = empty();
  }, m(t19, i2) {
    o2 && o2.m(t19, i2), insert(t19, e2, i2), n2 = true;
  }, p(t19, [n3]) {
    t19[0] ? o2 && (group_outros(), transition_out(o2, 1, 1, () => {
      o2 = null;
    }), check_outros()) : o2 ? (o2.p(t19, n3), 1 & n3 && transition_in(o2, 1)) : (o2 = create_if_block$1n(t19), o2.c(), transition_in(o2, 1), o2.m(e2.parentNode, e2));
  }, i(t19) {
    n2 || (transition_in(o2), n2 = true);
  }, o(t19) {
    transition_out(o2), n2 = false;
  }, d(t19) {
    t19 && detach(e2), o2 && o2.d(t19);
  } };
}
function instance$2p(t18, e2, n2) {
  let o2, i2, { $$slots: r2 = {}, $$scope: a2 } = e2;
  const s2 = getContext("actorStore");
  return component_subscribe(t18, s2, (t19) => n2(2, i2 = t19)), t18.$$set = (t19) => {
    "$$scope" in t19 && n2(3, a2 = t19.$$scope);
  }, t18.$$.update = () => {
    4 & t18.$$.dirty && n2(0, o2 = isReadOnlyActor(i2) || getContext("readOnly"));
  }, [o2, s2, i2, a2, r2];
}
readOnlyActor.subscribe((t18) => {
  t18 && (actorStore$1.set(t18), switchFilter$1(Filters.Character));
});
class StateButtons extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2p, create_fragment$2o, safe_not_equal, {});
  }
}
function create_if_block_1$u(t18) {
  let e2, n2, o2;
  return { c() {
    e2 = element("button"), attr(e2, "class", "action-button fas fa-link svelte-mobile-companion-a5e-038vch56tr3-16dadvl"), toggle_class(e2, "active", t18[5]);
  }, m(i2, r2) {
    insert(i2, e2, r2), n2 || (o2 = listen(e2, "click", stop_propagation(t18[6])), n2 = true);
  }, p(t19, n3) {
    32 & n3 && toggle_class(e2, "active", t19[5]);
  }, d(t19) {
    t19 && detach(e2), n2 = false, o2();
  } };
}
function create_if_block$1m(t18) {
  let e2, n2, o2;
  return { c() {
    e2 = element("button"), attr(e2, "class", "action-button fas svelte-mobile-companion-a5e-038vch56tr3-16dadvl"), toggle_class(e2, "fa-shield-alt", t18[4] === EquippedState.EQUIPPED), toggle_class(e2, "fa-person-carry-box", t18[4] === EquippedState.CARRIED), toggle_class(e2, "fa-tents", t18[4] === EquippedState.NOT_CARRIED), toggle_class(e2, "active", [EquippedState.EQUIPPED, EquippedState.CARRIED].includes(t18[4]));
  }, m(i2, r2) {
    insert(i2, e2, r2), n2 || (o2 = listen(e2, "click", stop_propagation(t18[7])), n2 = true);
  }, p(t19, n3) {
    16 & n3 && toggle_class(e2, "fa-shield-alt", t19[4] === EquippedState.EQUIPPED), 16 & n3 && toggle_class(e2, "fa-person-carry-box", t19[4] === EquippedState.CARRIED), 16 & n3 && toggle_class(e2, "fa-tents", t19[4] === EquippedState.NOT_CARRIED), 16 & n3 && toggle_class(e2, "active", [EquippedState.EQUIPPED, EquippedState.CARRIED].includes(t19[4]));
  }, d(t19) {
    t19 && detach(e2), n2 = false, o2();
  } };
}
function create_default_slot$n(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2;
  e2 = new ToggleFavoriteButton({ props: { item: t18[0] } });
  let l2 = t18[1].requiresAttunement && create_if_block_1$u(t18), u2 = !t18[2] && create_if_block$1m(t18);
  return { c() {
    create_component(e2.$$.fragment), n2 = space(), l2 && l2.c(), o2 = space(), u2 && u2.c(), i2 = space(), r2 = element("button"), attr(r2, "class", "action-button fas no-hover-focus-effect svelte-mobile-companion-a5e-038vch56tr3-16dadvl"), toggle_class(r2, "fa-heart", t18[3] === DamageState.INTACT), toggle_class(r2, "fa-heart-crack", t18[3] === DamageState.DAMAGED), toggle_class(r2, "fa-heart-pulse", t18[3] === DamageState.BROKEN), toggle_class(r2, "active", [DamageState.DAMAGED, DamageState.BROKEN].includes(t18[3]));
  }, m(p2, d2) {
    mount_component(e2, p2, d2), insert(p2, n2, d2), l2 && l2.m(p2, d2), insert(p2, o2, d2), u2 && u2.m(p2, d2), insert(p2, i2, d2), insert(p2, r2, d2), a2 = true, s2 || (c2 = listen(r2, "click", stop_propagation(t18[8])), s2 = true);
  }, p(t19, n3) {
    const s3 = {};
    1 & n3 && (s3.item = t19[0]), e2.$set(s3), t19[1].requiresAttunement ? l2 ? l2.p(t19, n3) : (l2 = create_if_block_1$u(t19), l2.c(), l2.m(o2.parentNode, o2)) : l2 && (l2.d(1), l2 = null), t19[2] ? u2 && (u2.d(1), u2 = null) : u2 ? u2.p(t19, n3) : (u2 = create_if_block$1m(t19), u2.c(), u2.m(i2.parentNode, i2)), (!a2 || 8 & n3) && toggle_class(r2, "fa-heart", t19[3] === DamageState.INTACT), (!a2 || 8 & n3) && toggle_class(r2, "fa-heart-crack", t19[3] === DamageState.DAMAGED), (!a2 || 8 & n3) && toggle_class(r2, "fa-heart-pulse", t19[3] === DamageState.BROKEN), (!a2 || 8 & n3) && toggle_class(r2, "active", [DamageState.DAMAGED, DamageState.BROKEN].includes(t19[3]));
  }, i(t19) {
    a2 || (transition_in(e2.$$.fragment, t19), a2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), a2 = false;
  }, d(t19) {
    t19 && (detach(n2), detach(o2), detach(i2), detach(r2)), destroy_component(e2, t19), l2 && l2.d(t19), u2 && u2.d(t19), s2 = false, c2();
  } };
}
function create_fragment$2n(t18) {
  let e2, n2;
  return e2 = new StateButtons({ props: { $$slots: { default: [create_default_slot$n] }, $$scope: { ctx: t18 } } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, [n3]) {
    const o2 = {};
    1087 & n3 && (o2.$$scope = { dirty: n3, ctx: t19 }), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function instance$2o(t18, e2, n2) {
  let o2, i2, r2, a2, s2, { item: c2 } = e2;
  return t18.$$set = (t19) => {
    "item" in t19 && n2(0, c2 = t19.item);
  }, t18.$$.update = () => {
    1 & t18.$$.dirty && n2(1, o2 = c2.system), 2 & t18.$$.dirty && o2.favorite, 2 & t18.$$.dirty && n2(5, i2 = o2.attuned), 2 & t18.$$.dirty && n2(4, r2 = o2.equippedState), 2 & t18.$$.dirty && n2(3, a2 = o2.damagedState), 1 & t18.$$.dirty && n2(2, s2 = !!c2.system.containerId);
  }, [c2, o2, s2, a2, r2, i2, () => c2.toggleAttunement(), () => c2.toggleEquippedState(), () => c2.toggleDamagedState()];
}
class ObjectStateToggles extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2o, create_fragment$2n, safe_not_equal, { item: 0 });
  }
}
function create_if_block_1$t(t18) {
  let e2;
  return { c() {
    e2 = element("div"), attr(e2, "class", "item-icon fas fa-xs fa-link svelte-mobile-companion-a5e-038vch56tr3-ppq0nm"), toggle_class(e2, "active", t18[4]);
  }, m(t19, n2) {
    insert(t19, e2, n2);
  }, p(t19, n2) {
    16 & n2 && toggle_class(e2, "active", t19[4]);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_if_block$1l(t18) {
  let e2;
  return { c() {
    e2 = element("div"), attr(e2, "class", "item-icon fas fa-xs svelte-mobile-companion-a5e-038vch56tr3-ppq0nm"), toggle_class(e2, "fa-shield-alt", t18[3] === EquippedState.EQUIPPED), toggle_class(e2, "fa-person-carry-box", t18[3] === EquippedState.CARRIED), toggle_class(e2, "fa-tents", t18[3] === EquippedState.NOT_CARRIED), toggle_class(e2, "active", [EquippedState.EQUIPPED, EquippedState.CARRIED].includes(t18[3]));
  }, m(t19, n2) {
    insert(t19, e2, n2);
  }, p(t19, n2) {
    8 & n2 && toggle_class(e2, "fa-shield-alt", t19[3] === EquippedState.EQUIPPED), 8 & n2 && toggle_class(e2, "fa-person-carry-box", t19[3] === EquippedState.CARRIED), 8 & n2 && toggle_class(e2, "fa-tents", t19[3] === EquippedState.NOT_CARRIED), 8 & n2 && toggle_class(e2, "active", [EquippedState.EQUIPPED, EquippedState.CARRIED].includes(t19[3]));
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_fragment$2m(t18) {
  let e2, n2, o2, i2, r2 = t18[0].requiresAttunement && create_if_block_1$t(t18), a2 = !t18[1] && create_if_block$1l(t18);
  return { c() {
    e2 = element("div"), r2 && r2.c(), n2 = space(), a2 && a2.c(), o2 = space(), i2 = element("div"), attr(i2, "class", "item-icon fas fa-xs svelte-mobile-companion-a5e-038vch56tr3-ppq0nm"), toggle_class(i2, "fa-heart", t18[2] === DamageState.INTACT), toggle_class(i2, "fa-heart-crack", t18[2] === DamageState.DAMAGED), toggle_class(i2, "fa-heart-pulse", t18[2] === DamageState.BROKEN), toggle_class(i2, "active", [DamageState.DAMAGED, DamageState.BROKEN].includes(t18[2])), attr(e2, "class", "icon-wrapper svelte-mobile-companion-a5e-038vch56tr3-ppq0nm");
  }, m(t19, s2) {
    insert(t19, e2, s2), r2 && r2.m(e2, null), append(e2, n2), a2 && a2.m(e2, null), append(e2, o2), append(e2, i2);
  }, p(t19, [s2]) {
    t19[0].requiresAttunement ? r2 ? r2.p(t19, s2) : (r2 = create_if_block_1$t(t19), r2.c(), r2.m(e2, n2)) : r2 && (r2.d(1), r2 = null), t19[1] ? a2 && (a2.d(1), a2 = null) : a2 ? a2.p(t19, s2) : (a2 = create_if_block$1l(t19), a2.c(), a2.m(e2, o2)), 4 & s2 && toggle_class(i2, "fa-heart", t19[2] === DamageState.INTACT), 4 & s2 && toggle_class(i2, "fa-heart-crack", t19[2] === DamageState.DAMAGED), 4 & s2 && toggle_class(i2, "fa-heart-pulse", t19[2] === DamageState.BROKEN), 4 & s2 && toggle_class(i2, "active", [DamageState.DAMAGED, DamageState.BROKEN].includes(t19[2]));
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2), r2 && r2.d(), a2 && a2.d();
  } };
}
function instance$2n(t18, e2, n2) {
  let o2, i2, r2, a2, s2, { item: c2 } = e2;
  return t18.$$set = (t19) => {
    "item" in t19 && n2(5, c2 = t19.item);
  }, t18.$$.update = () => {
    32 & t18.$$.dirty && n2(0, o2 = c2.system), 1 & t18.$$.dirty && o2.favorite, 1 & t18.$$.dirty && n2(4, i2 = o2.attuned), 1 & t18.$$.dirty && n2(3, r2 = o2.equippedState), 1 & t18.$$.dirty && n2(2, a2 = o2.damagedState), 32 & t18.$$.dirty && n2(1, s2 = !!c2.system.containerId);
  }, [o2, s2, a2, r2, i2, c2];
}
class ObjectStatesDisplay extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2n, create_fragment$2m, safe_not_equal, { item: 5 });
  }
}
function get_each_context$I(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[11] = e2[n2], o2;
}
function create_if_block$1k(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2 = [], p2 = /* @__PURE__ */ new Map(), d2 = ensure_array_like(t18[1]);
  const m2 = (t19) => t19[11].id;
  for (let e3 = 0; e3 < d2.length; e3 += 1) {
    let n3 = get_each_context$I(t18, d2, e3), o3 = m2(n3);
    p2.set(o3, u2[e3] = create_each_block$I(o3, n3));
  }
  return { c() {
    e2 = element("div"), n2 = element("div"), o2 = element("span"), i2 = text("Transfer to\r\n            "), r2 = element("select");
    for (let t19 = 0; t19 < u2.length; t19 += 1) u2[t19].c();
    a2 = space(), s2 = element("button"), s2.innerHTML = '<i class="fa-solid fa-right-left"></i>', attr(r2, "class", "svelte-mobile-companion-a5e-038vch56tr3-jnqbyu"), void 0 === t18[0] && add_render_callback(() => t18[6].call(r2)), attr(s2, "class", "svelte-mobile-companion-a5e-038vch56tr3-jnqbyu"), attr(n2, "class", "transfer svelte-mobile-companion-a5e-038vch56tr3-jnqbyu"), attr(e2, "class", "transfer-container svelte-mobile-companion-a5e-038vch56tr3-jnqbyu");
  }, m(p3, d3) {
    insert(p3, e2, d3), append(e2, n2), append(n2, o2), append(o2, i2), append(o2, r2);
    for (let t19 = 0; t19 < u2.length; t19 += 1) u2[t19] && u2[t19].m(r2, null);
    select_option(r2, t18[0], true), append(n2, a2), append(n2, s2), c2 || (l2 = [listen(r2, "change", t18[6]), listen(s2, "click", t18[3])], c2 = true);
  }, p(t19, e3) {
    2 & e3 && (d2 = ensure_array_like(t19[1]), u2 = update_keyed_each(u2, e3, m2, 1, t19, d2, p2, r2, destroy_block, create_each_block$I, null, get_each_context$I)), 3 & e3 && select_option(r2, t19[0]);
  }, d(t19) {
    t19 && detach(e2);
    for (let t20 = 0; t20 < u2.length; t20 += 1) u2[t20].d();
    c2 = false, run_all(l2);
  } };
}
function create_each_block$I(t18, e2) {
  let n2, o2, i2, r2 = e2[11].name + "";
  return { key: t18, first: null, c() {
    n2 = element("option"), o2 = text(r2), n2.__value = i2 = e2[11], set_input_value(n2, n2.__value), this.first = n2;
  }, m(t19, e3) {
    insert(t19, n2, e3), append(n2, o2);
  }, p(t19, a2) {
    e2 = t19, 2 & a2 && r2 !== (r2 = e2[11].name + "") && set_data(o2, r2), 2 & a2 && i2 !== (i2 = e2[11]) && (n2.__value = i2, set_input_value(n2, n2.__value));
  }, d(t19) {
    t19 && detach(n2);
  } };
}
function create_fragment$2l(t18) {
  let e2, n2 = "container" !== t18[2].objectType && create_if_block$1k(t18);
  return { c() {
    n2 && n2.c(), e2 = empty();
  }, m(t19, o2) {
    n2 && n2.m(t19, o2), insert(t19, e2, o2);
  }, p(t19, [e3]) {
    "container" !== t19[2].objectType && n2.p(t19, e3);
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2), n2 && n2.d(t19);
  } };
}
function instance$2m(t18, e2, n2) {
  var o2, i2 = this && this.__awaiter || function(t19, e3, n3, o3) {
    return new (n3 || (n3 = Promise))(function(i3, r3) {
      function a3(t20) {
        try {
          c3(o3.next(t20));
        } catch (t21) {
          r3(t21);
        }
      }
      function s3(t20) {
        try {
          c3(o3.throw(t20));
        } catch (t21) {
          r3(t21);
        }
      }
      function c3(t20) {
        var e4;
        t20.done ? i3(t20.value) : (e4 = t20.value, e4 instanceof n3 ? e4 : new n3(function(t21) {
          t21(e4);
        })).then(a3, s3);
      }
      c3((o3 = o3.apply(t19, e3 || [])).next());
    });
  };
  let r2, { actor: a2 } = e2, { item: s2 } = e2, c2 = s2.system;
  const l2 = { id: a2.id, name: a2.name, isActor: true };
  let u2 = c2.containerId ? { id: c2.containerId, name: "CONTAINER NAME", isActor: false } : l2, p2 = a2.itemTypes.object.filter((t19) => t19.system.objectType === ObjectType.Container).filter((t19) => !u2.id.includes(t19.id)).map((t19) => ({ id: t19.id, name: t19.name, isActor: false }));
  return (null === (o2 = c2.containerId) || void 0 === o2 ? void 0 : o2.length) > 0 && (p2 = [l2, ...p2]), t18.$$set = (t19) => {
    "actor" in t19 && n2(4, a2 = t19.actor), "item" in t19 && n2(5, s2 = t19.item);
  }, [r2, p2, c2, function() {
    return i2(this, void 0, void 0, function* () {
      var t19, e3;
      const n3 = yield fromUuid(c2.containerId);
      if (r2.isActor) return yield null === (t19 = n3.containerItems) || void 0 === t19 ? void 0 : t19.remove(s2.uuid), void s2.update({ "system.containerId": "" });
      {
        const t20 = a2.itemTypes.object.find((t21) => t21.system.objectType === ObjectType.Container && t21.id === r2.id);
        if (!t20) return void console.error("Selected container was not found", r2.id);
        yield null === (e3 = t20.containerItems) || void 0 === e3 ? void 0 : e3.add(s2.uuid), (null == n3 ? void 0 : n3.containerItems) && (yield n3.containerItems.remove(s2.uuid)), s2.update({ "system.containerId": t20.uuid });
      }
    });
  }, a2, s2, function() {
    r2 = select_value(this), n2(0, r2), n2(1, p2);
  }];
}
class ItemTransfer extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2m, create_fragment$2l, safe_not_equal, { actor: 4, item: 5 });
  }
}
function create_fragment$2k(t18) {
  let e2, n2, o2;
  return { c() {
    e2 = element("input"), attr(e2, "class", t18[3]), attr(e2, "style", t18[7]), attr(e2, "min", t18[4]), attr(e2, "max", t18[5]), attr(e2, "id", t18[1]), attr(e2, "name", t18[2]), attr(e2, "inputmode", t18[6]), attr(e2, "pattern", "[0-9+\\-]*");
  }, m(i2, r2) {
    insert(i2, e2, r2), set_input_value(e2, t18[0]), n2 || (o2 = [listen(e2, "change", t18[8]), listen(e2, "input", restrictInput), listen(e2, "input", t18[10])], n2 = true);
  }, p(t19, [n3]) {
    8 & n3 && attr(e2, "class", t19[3]), 16 & n3 && attr(e2, "min", t19[4]), 32 & n3 && attr(e2, "max", t19[5]), 2 & n3 && attr(e2, "id", t19[1]), 4 & n3 && attr(e2, "name", t19[2]), 64 & n3 && attr(e2, "inputmode", t19[6]), 1 & n3 && e2.value !== t19[0] && set_input_value(e2, t19[0]);
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2), n2 = false, run_all(o2);
  } };
}
function restrictInput(t18) {
  const e2 = t18.target;
  e2.value = e2.value.replace(/[^0-9+\-]/g, "");
}
function instance$2l($$self, $$props, $$invalidate) {
  let { value = 0 } = $$props, { id = "" } = $$props, { name = "" } = $$props, { styleClass = "" } = $$props, { min } = $$props, { max } = $$props, { styles } = $$props, { inputMode = "text" } = $$props;
  const style = styles ? Object.entries(styles).map(([t18, e2]) => `${t18}: ${e2}`).join(";") : "";
  let previousValue = value;
  const dispatch = createEventDispatcher();
  function handleInputChange(event) {
    const target = event.target;
    let newValue = target.value;
    try {
      /^[+\-]/.test(newValue) && (newValue = `${previousValue}${newValue}`);
      let result = Math.floor(eval(newValue));
      void 0 !== max && (result = Math.min(result, max)), void 0 !== min && (result = Math.max(result, min)), previousValue = result, $$invalidate(0, value = result), dispatch("change", { value: result, name });
    } catch (t18) {
    }
  }
  function input_input_handler() {
    value = this.value, $$invalidate(0, value);
  }
  return $$self.$$set = (t18) => {
    "value" in t18 && $$invalidate(0, value = t18.value), "id" in t18 && $$invalidate(1, id = t18.id), "name" in t18 && $$invalidate(2, name = t18.name), "styleClass" in t18 && $$invalidate(3, styleClass = t18.styleClass), "min" in t18 && $$invalidate(4, min = t18.min), "max" in t18 && $$invalidate(5, max = t18.max), "styles" in t18 && $$invalidate(9, styles = t18.styles), "inputMode" in t18 && $$invalidate(6, inputMode = t18.inputMode);
  }, $$self.$$.update = () => {
    1 & $$self.$$.dirty && $$invalidate(0, value);
  }, [value, id, name, styleClass, min, max, inputMode, style, handleInputChange, styles, input_input_handler];
}
class EvaluatingInput extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2l, create_fragment$2k, safe_not_equal, { value: 0, id: 1, name: 2, styleClass: 3, min: 4, max: 5, styles: 9, inputMode: 6 });
  }
}
function create_if_block$1j(t18) {
  let e2, n2, o2, i2;
  return e2 = new EvaluatingInput({ props: { value: t18[0].value, id: "uses.value", name: "uses.value", styleClass: "number-input", min: 0, max: t18[0].max } }), e2.$on("change", t18[3]), { c() {
    create_component(e2.$$.fragment), n2 = space(), o2 = element("span"), o2.textContent = "/";
  }, m(t19, r2) {
    mount_component(e2, t19, r2), insert(t19, n2, r2), insert(t19, o2, r2), i2 = true;
  }, p(t19, n3) {
    const o3 = {};
    1 & n3 && (o3.value = t19[0].value), 1 & n3 && (o3.max = t19[0].max), e2.$set(o3);
  }, i(t19) {
    i2 || (transition_in(e2.$$.fragment, t19), i2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), i2 = false;
  }, d(t19) {
    t19 && (detach(n2), detach(o2)), destroy_component(e2, t19);
  } };
}
function create_fragment$2j(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2 = !t18[1] && create_if_block$1j(t18);
  return { c() {
    e2 = element("div"), n2 = element("span"), o2 = element("b"), o2.textContent = `${i18n("A5E.consumers.uses.title")}:`, i2 = space(), r2 = element("div"), u2 && u2.c(), a2 = space(), s2 = element("input"), attr(s2, "class", "number-input svelte-mobile-companion-a5e-038vch56tr3-11oe3py"), attr(s2, "type", "number"), s2.value = c2 = t18[0].max, s2.disabled = true, attr(r2, "class", "uses-inputs svelte-mobile-companion-a5e-038vch56tr3-11oe3py"), attr(e2, "class", "uses svelte-mobile-companion-a5e-038vch56tr3-11oe3py");
  }, m(t19, c3) {
    insert(t19, e2, c3), append(e2, n2), append(n2, o2), append(e2, i2), append(e2, r2), u2 && u2.m(r2, null), append(r2, a2), append(r2, s2), l2 = true;
  }, p(t19, [e3]) {
    t19[1] ? u2 && (group_outros(), transition_out(u2, 1, 1, () => {
      u2 = null;
    }), check_outros()) : u2 ? (u2.p(t19, e3), 2 & e3 && transition_in(u2, 1)) : (u2 = create_if_block$1j(t19), u2.c(), transition_in(u2, 1), u2.m(r2, a2)), (!l2 || 1 & e3 && c2 !== (c2 = t19[0].max) && s2.value !== c2) && (s2.value = c2);
  }, i(t19) {
    l2 || (transition_in(u2), l2 = true);
  }, o(t19) {
    transition_out(u2), l2 = false;
  }, d(t19) {
    t19 && detach(e2), u2 && u2.d();
  } };
}
function instance$2k(t18, e2, n2) {
  let o2, i2, r2, a2, { item: s2 } = e2;
  const c2 = getContext("actorStore");
  return component_subscribe(t18, c2, (t19) => n2(6, a2 = t19)), t18.$$set = (t19) => {
    "item" in t19 && n2(4, s2 = t19.item);
  }, t18.$$.update = () => {
    64 & t18.$$.dirty && n2(1, o2 = isReadOnlyActor(a2) || getContext("readOnly")), 16 & t18.$$.dirty && n2(5, i2 = s2.system), 32 & t18.$$.dirty && n2(0, r2 = i2.uses);
  }, [r2, o2, c2, function(t19) {
    t19.preventDefault();
    const e3 = +t19.detail.value;
    s2.update({ "system.uses.value": e3 });
  }, s2, i2, a2];
}
class ObjectUse extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2k, create_fragment$2j, safe_not_equal, { item: 4 });
  }
}
class ImageCache {
  constructor() {
    this.cache = /* @__PURE__ */ new Map(), this.pendingRequests = /* @__PURE__ */ new Map();
  }
  getImage(t18) {
    if (this.cache.has(t18)) return this.cache.get(t18);
    if (!this.pendingRequests.has(t18)) {
      const e2 = (async () => {
        try {
          const e3 = await fetch(t18), n2 = await e3.blob(), o2 = URL.createObjectURL(n2);
          this.cache.set(t18, o2);
        } catch (t19) {
          console.warn("Failed to cache image:", t19);
        } finally {
          this.pendingRequests.delete(t18);
        }
      })();
      this.pendingRequests.set(t18, e2);
    }
    return t18;
  }
  clear() {
    this.cache.forEach((t18) => URL.revokeObjectURL(t18)), this.cache.clear(), this.pendingRequests.clear();
  }
}
const imageCache = new ImageCache(), get_details_slot_changes = (t18) => ({}), get_details_slot_context = (t18) => ({}), get_right_content_slot_changes = (t18) => ({}), get_right_content_slot_context = (t18) => ({}), get_name_badge_slot_changes = (t18) => ({}), get_name_badge_slot_context = (t18) => ({}), get_overlay_slot_changes = (t18) => ({}), get_overlay_slot_context = (t18) => ({});
function create_if_block_1$s(t18) {
  let e2, n2, o2, i2, r2 = t18[2] && create_if_block_2$h();
  return { c() {
    e2 = element("div"), n2 = element("img"), i2 = space(), r2 && r2.c(), attr(n2, "class", "item-image svelte-mobile-companion-a5e-038vch56tr3-u15ss9"), src_url_equal(n2.src, o2 = t18[5]) || attr(n2, "src", o2), attr(n2, "alt", t18[0]), attr(n2, "style", t18[3]), attr(e2, "class", "image-container svelte-mobile-companion-a5e-038vch56tr3-u15ss9");
  }, m(t19, o3) {
    insert(t19, e2, o3), append(e2, n2), append(e2, i2), r2 && r2.m(e2, null);
  }, p(t19, i3) {
    32 & i3 && !src_url_equal(n2.src, o2 = t19[5]) && attr(n2, "src", o2), 1 & i3 && attr(n2, "alt", t19[0]), 8 & i3 && attr(n2, "style", t19[3]), t19[2] ? r2 || (r2 = create_if_block_2$h(), r2.c(), r2.m(e2, null)) : r2 && (r2.d(1), r2 = null);
  }, d(t19) {
    t19 && detach(e2), r2 && r2.d();
  } };
}
function create_if_block_2$h(t18) {
  let e2;
  return { c() {
    e2 = element("i"), attr(e2, "class", "fa-solid fa-star svelte-mobile-companion-a5e-038vch56tr3-u15ss9");
  }, m(t19, n2) {
    insert(t19, e2, n2);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_if_block$1i(t18) {
  let e2, n2, o2;
  const i2 = t18[9].details, r2 = create_slot(i2, t18, t18[8], get_details_slot_context);
  return { c() {
    e2 = element("div"), r2 && r2.c(), attr(e2, "class", "details svelte-mobile-companion-a5e-038vch56tr3-u15ss9");
  }, m(t19, n3) {
    insert(t19, e2, n3), r2 && r2.m(e2, null), o2 = true;
  }, p(t19, e3) {
    r2 && r2.p && (!o2 || 256 & e3) && update_slot_base(r2, i2, t19, t19[8], o2 ? get_slot_changes(i2, t19[8], e3, get_details_slot_changes) : get_all_dirty_from_scope(t19[8]), get_details_slot_context);
  }, i(t19) {
    o2 || (transition_in(r2, t19), t19 && add_render_callback(() => {
      o2 && (n2 || (n2 = create_bidirectional_transition(e2, slide, { duration: 200, easing: identity, axis: "y" }, true)), n2.run(1));
    }), o2 = true);
  }, o(t19) {
    transition_out(r2, t19), t19 && (n2 || (n2 = create_bidirectional_transition(e2, slide, { duration: 200, easing: identity, axis: "y" }, false)), n2.run(0)), o2 = false;
  }, d(t19) {
    t19 && detach(e2), r2 && r2.d(t19), t19 && n2 && n2.end();
  } };
}
function create_fragment$2i(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, m2;
  const f2 = t18[9].overlay, h2 = create_slot(f2, t18, t18[8], get_overlay_slot_context);
  let g2 = t18[5] && create_if_block_1$s(t18);
  const _ = t18[9]["name-badge"], $2 = create_slot(_, t18, t18[8], get_name_badge_slot_context), b2 = t18[9]["right-content"], y2 = create_slot(b2, t18, t18[8], get_right_content_slot_context);
  let v2 = t18[1] && t18[4] && create_if_block$1i(t18);
  return { c() {
    e2 = element("li"), n2 = element("div"), h2 && h2.c(), o2 = space(), i2 = element("div"), g2 && g2.c(), r2 = space(), a2 = element("div"), s2 = text(t18[0]), c2 = space(), $2 && $2.c(), l2 = space(), y2 && y2.c(), u2 = space(), v2 && v2.c(), attr(a2, "class", "name svelte-mobile-companion-a5e-038vch56tr3-u15ss9"), attr(a2, "aria-hidden", "true"), attr(i2, "class", "img-and-name svelte-mobile-companion-a5e-038vch56tr3-u15ss9"), attr(n2, "class", "item svelte-mobile-companion-a5e-038vch56tr3-u15ss9"), attr(e2, "class", "svelte-mobile-companion-a5e-038vch56tr3-u15ss9");
  }, m(f3, _2) {
    insert(f3, e2, _2), append(e2, n2), h2 && h2.m(n2, null), append(n2, o2), append(n2, i2), g2 && g2.m(i2, null), append(i2, r2), append(i2, a2), append(a2, s2), append(a2, c2), $2 && $2.m(a2, null), append(n2, l2), y2 && y2.m(n2, null), append(e2, u2), v2 && v2.m(e2, null), p2 = true, d2 || (m2 = listen(a2, "click", t18[6]), d2 = true);
  }, p(t19, [n3]) {
    h2 && h2.p && (!p2 || 256 & n3) && update_slot_base(h2, f2, t19, t19[8], p2 ? get_slot_changes(f2, t19[8], n3, get_overlay_slot_changes) : get_all_dirty_from_scope(t19[8]), get_overlay_slot_context), t19[5] ? g2 ? g2.p(t19, n3) : (g2 = create_if_block_1$s(t19), g2.c(), g2.m(i2, r2)) : g2 && (g2.d(1), g2 = null), (!p2 || 1 & n3) && set_data(s2, t19[0]), $2 && $2.p && (!p2 || 256 & n3) && update_slot_base($2, _, t19, t19[8], p2 ? get_slot_changes(_, t19[8], n3, get_name_badge_slot_changes) : get_all_dirty_from_scope(t19[8]), get_name_badge_slot_context), y2 && y2.p && (!p2 || 256 & n3) && update_slot_base(y2, b2, t19, t19[8], p2 ? get_slot_changes(b2, t19[8], n3, get_right_content_slot_changes) : get_all_dirty_from_scope(t19[8]), get_right_content_slot_context), t19[1] && t19[4] ? v2 ? (v2.p(t19, n3), 18 & n3 && transition_in(v2, 1)) : (v2 = create_if_block$1i(t19), v2.c(), transition_in(v2, 1), v2.m(e2, null)) : v2 && (group_outros(), transition_out(v2, 1, 1, () => {
      v2 = null;
    }), check_outros());
  }, i(t19) {
    p2 || (transition_in(h2, t19), transition_in($2, t19), transition_in(y2, t19), transition_in(v2), p2 = true);
  }, o(t19) {
    transition_out(h2, t19), transition_out($2, t19), transition_out(y2, t19), transition_out(v2), p2 = false;
  }, d(t19) {
    t19 && detach(e2), h2 && h2.d(t19), g2 && g2.d(), $2 && $2.d(t19), y2 && y2.d(t19), v2 && v2.d(), d2 = false, m2();
  } };
}
function instance$2j(t18, e2, n2) {
  let { $$slots: o2 = {}, $$scope: i2 } = e2;
  var r2 = this && this.__awaiter || function(t19, e3, n3, o3) {
    return new (n3 || (n3 = Promise))(function(i3, r3) {
      function a3(t20) {
        try {
          c3(o3.next(t20));
        } catch (t21) {
          r3(t21);
        }
      }
      function s3(t20) {
        try {
          c3(o3.throw(t20));
        } catch (t21) {
          r3(t21);
        }
      }
      function c3(t20) {
        var e4;
        t20.done ? i3(t20.value) : (e4 = t20.value, e4 instanceof n3 ? e4 : new n3(function(t21) {
          t21(e4);
        })).then(a3, s3);
      }
      c3((o3 = o3.apply(t19, e3 || [])).next());
    });
  };
  let { name: a2 } = e2, { imageSrc: s2 } = e2, { hasDetails: c2 = true } = e2, { isFavorite: l2 = false } = e2, { imageStyle: u2 } = e2, p2 = false, d2 = s2;
  return onMount(() => r2(void 0, void 0, void 0, function* () {
    s2 && n2(5, d2 = imageCache.getImage(s2));
  })), t18.$$set = (t19) => {
    "name" in t19 && n2(0, a2 = t19.name), "imageSrc" in t19 && n2(7, s2 = t19.imageSrc), "hasDetails" in t19 && n2(1, c2 = t19.hasDetails), "isFavorite" in t19 && n2(2, l2 = t19.isFavorite), "imageStyle" in t19 && n2(3, u2 = t19.imageStyle), "$$scope" in t19 && n2(8, i2 = t19.$$scope);
  }, [a2, c2, l2, u2, p2, d2, function() {
    n2(4, p2 = !p2);
  }, s2, i2, o2];
}
class ToggleableListEntry extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2j, create_fragment$2i, safe_not_equal, { name: 0, imageSrc: 7, hasDetails: 1, isFavorite: 2, imageStyle: 3 });
  }
}
function portal(t18, e2 = "body") {
  let n2;
  async function o2(o3) {
    if ("string" == typeof (e2 = o3)) {
      if (n2 = document.querySelector(e2), null === n2 && (await tick(), n2 = document.querySelector(e2)), null === n2) throw new Error(`No element found matching css selector: "${e2}"`);
    } else {
      if (!(e2 instanceof HTMLElement)) throw new TypeError(`Unknown portal target type: ${null === e2 ? "null" : typeof e2}. Allowed types: string (CSS selector) or HTMLElement.`);
      n2 = e2;
    }
    n2.appendChild(t18), t18.hidden = false;
  }
  return o2(e2), { update: o2, destroy: function() {
    t18.parentNode && t18.parentNode.removeChild(t18);
  } };
}
function create_if_block$1h(t18) {
  let e2, n2, o2;
  return { c() {
    e2 = element("span"), e2.innerHTML = '<i class="fas fa-xmark"></i>', attr(e2, "class", "close-button svelte-mobile-companion-a5e-038vch56tr3-176nwps"), attr(e2, "aria-hidden", "true");
  }, m(i2, r2) {
    insert(i2, e2, r2), n2 || (o2 = listen(e2, "click", t18[5]), n2 = true);
  }, p: noop$4, d(t19) {
    t19 && detach(e2), n2 = false, o2();
  } };
}
function create_fragment$2h(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2 = t18[2] && create_if_block$1h(t18);
  const p2 = t18[7].default, d2 = create_slot(p2, t18, t18[6], null);
  return { c() {
    e2 = element("div"), n2 = element("div"), u2 && u2.c(), o2 = space(), d2 && d2.c(), attr(n2, "class", "modal svelte-mobile-companion-a5e-038vch56tr3-176nwps"), attr(n2, "style", i2 = t18[0].join(" ")), attr(e2, "class", "mc-backdrop svelte-mobile-companion-a5e-038vch56tr3-176nwps"), attr(e2, "style", r2 = t18[1].join(" ")), attr(e2, "role", "presentation");
  }, m(i3, r3) {
    insert(i3, e2, r3), append(e2, n2), u2 && u2.m(n2, null), append(n2, o2), d2 && d2.m(n2, null), s2 = true, c2 || (l2 = [listen(e2, "click", t18[4]), action_destroyer(a2 = portal.call(null, e2, t18[3]))], c2 = true);
  }, p(t19, [c3]) {
    t19[2] ? u2 ? u2.p(t19, c3) : (u2 = create_if_block$1h(t19), u2.c(), u2.m(n2, o2)) : u2 && (u2.d(1), u2 = null), d2 && d2.p && (!s2 || 64 & c3) && update_slot_base(d2, p2, t19, t19[6], s2 ? get_slot_changes(p2, t19[6], c3, null) : get_all_dirty_from_scope(t19[6]), null), (!s2 || 1 & c3 && i2 !== (i2 = t19[0].join(" "))) && attr(n2, "style", i2), (!s2 || 2 & c3 && r2 !== (r2 = t19[1].join(" "))) && attr(e2, "style", r2), a2 && is_function(a2.update) && 8 & c3 && a2.update.call(null, t19[3]);
  }, i(t19) {
    s2 || (transition_in(d2, t19), s2 = true);
  }, o(t19) {
    transition_out(d2, t19), s2 = false;
  }, d(t19) {
    t19 && detach(e2), u2 && u2.d(), d2 && d2.d(t19), c2 = false, run_all(l2);
  } };
}
function instance$2i(t18, e2, n2) {
  let { $$slots: o2 = {}, $$scope: i2 } = e2, { modalStyle: r2 = [] } = e2, { backdropStyle: a2 = [] } = e2, { showCloseButton: s2 = true } = e2, { portalTarget: c2 = "#mobile-companion" } = e2;
  const l2 = createEventDispatcher();
  function u2() {
    l2("close");
  }
  return t18.$$set = (t19) => {
    "modalStyle" in t19 && n2(0, r2 = t19.modalStyle), "backdropStyle" in t19 && n2(1, a2 = t19.backdropStyle), "showCloseButton" in t19 && n2(2, s2 = t19.showCloseButton), "portalTarget" in t19 && n2(3, c2 = t19.portalTarget), "$$scope" in t19 && n2(6, i2 = t19.$$scope);
  }, [r2, a2, s2, c2, function(t19) {
    t19.target === t19.currentTarget && u2();
  }, u2, i2, o2];
}
class GenericModal extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2i, create_fragment$2h, safe_not_equal, { modalStyle: 0, backdropStyle: 1, showCloseButton: 2, portalTarget: 3 });
  }
}
function create_default_slot$m(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, m2, f2, h2, g2, _, $2, b2, y2 = t18[0].name + "";
  return { c() {
    e2 = element("h2"), e2.textContent = "Are you sure?", n2 = space(), o2 = element("p"), i2 = text("Do you want to delete "), r2 = element("b"), a2 = text(y2), s2 = text("?"), c2 = space(), l2 = element("div"), u2 = element("img"), m2 = space(), f2 = element("div"), h2 = element("button"), h2.textContent = "Yes", g2 = space(), _ = element("button"), _.textContent = "No", attr(e2, "class", "svelte-mobile-companion-a5e-038vch56tr3-1uvh0ty"), attr(o2, "class", "svelte-mobile-companion-a5e-038vch56tr3-1uvh0ty"), src_url_equal(u2.src, p2 = t18[0].img) || attr(u2, "src", p2), attr(u2, "alt", d2 = t18[0].name), attr(u2, "class", "svelte-mobile-companion-a5e-038vch56tr3-1uvh0ty"), attr(l2, "class", "image-wrapper svelte-mobile-companion-a5e-038vch56tr3-1uvh0ty"), attr(h2, "class", "roboto-condensed-upper svelte-mobile-companion-a5e-038vch56tr3-1uvh0ty"), attr(_, "class", "roboto-condensed-upper svelte-mobile-companion-a5e-038vch56tr3-1uvh0ty"), attr(f2, "class", "buttons svelte-mobile-companion-a5e-038vch56tr3-1uvh0ty");
  }, m(p3, d3) {
    insert(p3, e2, d3), insert(p3, n2, d3), insert(p3, o2, d3), append(o2, i2), append(o2, r2), append(r2, a2), append(o2, s2), insert(p3, c2, d3), insert(p3, l2, d3), append(l2, u2), insert(p3, m2, d3), insert(p3, f2, d3), append(f2, h2), append(f2, g2), append(f2, _), $2 || (b2 = [listen(h2, "click", t18[1]), listen(_, "click", t18[2])], $2 = true);
  }, p(t19, e3) {
    1 & e3 && y2 !== (y2 = t19[0].name + "") && set_data(a2, y2), 1 & e3 && !src_url_equal(u2.src, p2 = t19[0].img) && attr(u2, "src", p2), 1 & e3 && d2 !== (d2 = t19[0].name) && attr(u2, "alt", d2);
  }, d(t19) {
    t19 && (detach(e2), detach(n2), detach(o2), detach(c2), detach(l2), detach(m2), detach(f2)), $2 = false, run_all(b2);
  } };
}
function create_fragment$2g(t18) {
  let e2, n2;
  return e2 = new GenericModal({ props: { showCloseButton: false, $$slots: { default: [create_default_slot$m] }, $$scope: { ctx: t18 } } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, [n3]) {
    const o2 = {};
    17 & n3 && (o2.$$scope = { dirty: n3, ctx: t19 }), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function instance$2h(t18, e2, n2) {
  let { item: o2 } = e2;
  const i2 = createEventDispatcher();
  function r2() {
    i2("close");
  }
  return t18.$$set = (t19) => {
    "item" in t19 && n2(0, o2 = t19.item);
  }, [o2, function() {
    o2.delete(), r2();
  }, r2];
}
class DeleteDialog extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2h, create_fragment$2g, safe_not_equal, { item: 0 });
  }
}
function create_fragment$2f(t18) {
  let e2, n2, o2, i2;
  return { c() {
    e2 = element("span"), n2 = element("i"), attr(n2, "class", o2 = null_to_empty(t18[0]) + " svelte-mobile-companion-a5e-038vch56tr3-j2jqgm"), attr(e2, "class", "dice-burst svelte-mobile-companion-a5e-038vch56tr3-j2jqgm"), attr(e2, "aria-hidden", "true"), attr(e2, "style", i2 = "position: " + t18[6] + "; z-index: " + t18[9] + "; " + (null !== t18[7] ? `left:${t18[7]}px; transform: translate(-50%, -50%);` : "left:50%; transform: translate(-50%, -50%);") + " " + (null !== t18[8] ? `top:${t18[8]}px;` : "top:50%;") + " --duration: " + t18[1] + "ms; --start-scale: " + t18[2] + "; --end-scale: " + t18[3] + "; --start-rot: " + t18[4] + "deg; --end-rot: " + t18[5] + "deg;"), toggle_class(e2, "active", t18[10]);
  }, m(t19, o3) {
    insert(t19, e2, o3), append(e2, n2);
  }, p(t19, [r2]) {
    1 & r2 && o2 !== (o2 = null_to_empty(t19[0]) + " svelte-mobile-companion-a5e-038vch56tr3-j2jqgm") && attr(n2, "class", o2), 1022 & r2 && i2 !== (i2 = "position: " + t19[6] + "; z-index: " + t19[9] + "; " + (null !== t19[7] ? `left:${t19[7]}px; transform: translate(-50%, -50%);` : "left:50%; transform: translate(-50%, -50%);") + " " + (null !== t19[8] ? `top:${t19[8]}px;` : "top:50%;") + " --duration: " + t19[1] + "ms; --start-scale: " + t19[2] + "; --end-scale: " + t19[3] + "; --start-rot: " + t19[4] + "deg; --end-rot: " + t19[5] + "deg;") && attr(e2, "style", i2), 1024 & r2 && toggle_class(e2, "active", t19[10]);
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2);
  } };
}
function instance$2g(t18, e2, n2) {
  let { iconClass: o2 = "fa-solid fa-dice-d20 fa-2xl" } = e2, { duration: i2 = 1e3 } = e2, { startScale: r2 = 1 } = e2, { endScale: a2 = 20 } = e2, { startRotation: s2 = 0 } = e2, { endRotation: c2 = 180 } = e2, { position: l2 = "fixed" } = e2, { x: u2 = null } = e2, { y: p2 = null } = e2, { zIndex: d2 = 1e3 } = e2, m2 = false;
  const f2 = createEventDispatcher();
  return t18.$$set = (t19) => {
    "iconClass" in t19 && n2(0, o2 = t19.iconClass), "duration" in t19 && n2(1, i2 = t19.duration), "startScale" in t19 && n2(2, r2 = t19.startScale), "endScale" in t19 && n2(3, a2 = t19.endScale), "startRotation" in t19 && n2(4, s2 = t19.startRotation), "endRotation" in t19 && n2(5, c2 = t19.endRotation), "position" in t19 && n2(6, l2 = t19.position), "x" in t19 && n2(7, u2 = t19.x), "y" in t19 && n2(8, p2 = t19.y), "zIndex" in t19 && n2(9, d2 = t19.zIndex);
  }, [o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, m2, function() {
    if (m2) return;
    n2(10, m2 = true), f2("start");
    const t19 = setTimeout(() => {
      n2(10, m2 = false), f2("end"), clearTimeout(t19);
    }, i2);
  }];
}
class DiceBurst extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2g, create_fragment$2f, safe_not_equal, { iconClass: 0, duration: 1, startScale: 2, endScale: 3, startRotation: 4, endRotation: 5, position: 6, x: 7, y: 8, zIndex: 9, trigger: 11 });
  }
  get trigger() {
    return this.$$.ctx[11];
  }
}
function getExistingEffect(t18, e2) {
  return e2.effects.find((e3) => e3.origin === t18.origin);
}
function applyEffectToActor(t18, e2) {
  const n2 = getExistingEffect(t18, e2);
  if (n2) {
    const e3 = { ...t18.constructor.getInitialDuration(), disabled: false };
    n2.update(e3);
  } else t18.transferEffect(e2);
}
function create_fragment$2e(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2;
  return e2 = new DiceBurst({ props: { duration: 1e3 } }), t18[7](e2), { c() {
    create_component(e2.$$.fragment), n2 = space(), o2 = element("b"), o2.textContent = "Effect:", i2 = space(), r2 = element("button"), a2 = text(t18[2]), attr(r2, "class", "no-hover-focus-effect svelte-mobile-companion-a5e-038vch56tr3-ilidjf"), r2.disabled = t18[1];
  }, m(u2, p2) {
    mount_component(e2, u2, p2), insert(u2, n2, p2), insert(u2, o2, p2), insert(u2, i2, p2), insert(u2, r2, p2), append(r2, a2), s2 = true, c2 || (l2 = listen(r2, "click", prevent_default(t18[4])), c2 = true);
  }, p(t19, [n3]) {
    e2.$set({}), (!s2 || 4 & n3) && set_data(a2, t19[2]), (!s2 || 2 & n3) && (r2.disabled = t19[1]);
  }, i(t19) {
    s2 || (transition_in(e2.$$.fragment, t19), s2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), s2 = false;
  }, d(a3) {
    a3 && (detach(n2), detach(o2), detach(i2), detach(r2)), t18[7](null), destroy_component(e2, a3), c2 = false, l2();
  } };
}
function instance$2f(t18, e2, n2) {
  let o2, { effect: i2 } = e2;
  const r2 = getContext("actorStore");
  let a2;
  component_subscribe(t18, r2, (t19) => n2(6, o2 = t19));
  let s2 = false, c2 = i18n("A5E.effects.applyToSelf");
  return t18.$$set = (t19) => {
    "effect" in t19 && n2(5, i2 = t19.effect);
  }, t18.$$.update = () => {
    96 & t18.$$.dirty && getExistingEffect(i2, o2) && n2(2, c2 = "Renew effect");
  }, [a2, s2, c2, r2, function() {
    applyEffectToActor(i2, o2), n2(1, s2 = true), a2.trigger(), setTimeout(() => {
      n2(1, s2 = false);
    }, 1e3);
  }, i2, o2, function(t19) {
    binding_callbacks[t19 ? "unshift" : "push"](() => {
      a2 = t19, n2(0, a2);
    });
  }];
}
class ApplyEffect extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2f, create_fragment$2e, safe_not_equal, { effect: 5 });
  }
}
function get_each_context$H(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[3] = e2[n2], o2;
}
function create_if_block$1g(t18) {
  let e2, n2, o2 = ensure_array_like(t18[0]), i2 = [];
  for (let e3 = 0; e3 < o2.length; e3 += 1) i2[e3] = create_each_block$H(get_each_context$H(t18, o2, e3));
  const r2 = (t19) => transition_out(i2[t19], 1, 1, () => {
    i2[t19] = null;
  });
  return { c() {
    e2 = element("div");
    for (let t19 = 0; t19 < i2.length; t19 += 1) i2[t19].c();
  }, m(t19, o3) {
    insert(t19, e2, o3);
    for (let t20 = 0; t20 < i2.length; t20 += 1) i2[t20] && i2[t20].m(e2, null);
    n2 = true;
  }, p(t19, n3) {
    if (1 & n3) {
      let a2;
      for (o2 = ensure_array_like(t19[0]), a2 = 0; a2 < o2.length; a2 += 1) {
        const r3 = get_each_context$H(t19, o2, a2);
        i2[a2] ? (i2[a2].p(r3, n3), transition_in(i2[a2], 1)) : (i2[a2] = create_each_block$H(r3), i2[a2].c(), transition_in(i2[a2], 1), i2[a2].m(e2, null));
      }
      for (group_outros(), a2 = o2.length; a2 < i2.length; a2 += 1) r2(a2);
      check_outros();
    }
  }, i(t19) {
    if (!n2) {
      for (let t20 = 0; t20 < o2.length; t20 += 1) transition_in(i2[t20]);
      n2 = true;
    }
  }, o(t19) {
    i2 = i2.filter(Boolean);
    for (let t20 = 0; t20 < i2.length; t20 += 1) transition_out(i2[t20]);
    n2 = false;
  }, d(t19) {
    t19 && detach(e2), destroy_each(i2, t19);
  } };
}
function create_each_block$H(t18) {
  let e2, n2;
  return e2 = new ApplyEffect({ props: { effect: t18[3] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1 & n3 && (o2.effect = t19[3]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_fragment$2d(t18) {
  let e2, n2, o2 = t18[0] && create_if_block$1g(t18);
  return { c() {
    o2 && o2.c(), e2 = empty();
  }, m(t19, i2) {
    o2 && o2.m(t19, i2), insert(t19, e2, i2), n2 = true;
  }, p(t19, [n3]) {
    t19[0] ? o2 ? (o2.p(t19, n3), 1 & n3 && transition_in(o2, 1)) : (o2 = create_if_block$1g(t19), o2.c(), transition_in(o2, 1), o2.m(e2.parentNode, e2)) : o2 && (group_outros(), transition_out(o2, 1, 1, () => {
      o2 = null;
    }), check_outros());
  }, i(t19) {
    n2 || (transition_in(o2), n2 = true);
  }, o(t19) {
    transition_out(o2), n2 = false;
  }, d(t19) {
    t19 && detach(e2), o2 && o2.d(t19);
  } };
}
function instance$2e(t18, e2, n2) {
  let o2;
  var i2;
  let { item: r2 } = e2;
  return t18.$$set = (t19) => {
    "item" in t19 && n2(1, r2 = t19.item);
  }, t18.$$.update = () => {
    6 & t18.$$.dirty && n2(0, o2 = null === n2(2, i2 = null == r2 ? void 0 : r2.effects) || void 0 === i2 ? void 0 : i2.contents);
  }, [o2, r2, i2];
}
class Effects extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2e, create_fragment$2d, safe_not_equal, { item: 1 });
  }
}
function create_if_block_7$3(t18) {
  let e2, n2, o2, i2, r2, a2 = t18[5].itemRarity[t18[0].rarity] + "", s2 = t18[0].requiresAttunement ? ` (${i18n("A5E.attument.headings.requiredPrompt")})` : "";
  return { c() {
    e2 = element("p"), n2 = element("b"), n2.textContent = `${i18n("A5E.objects.rarity")}`, o2 = space(), i2 = text(a2), r2 = text(s2);
  }, m(t19, a3) {
    insert(t19, e2, a3), append(e2, n2), append(e2, o2), append(e2, i2), append(e2, r2);
  }, p(t19, e3) {
    1 & e3 && a2 !== (a2 = t19[5].itemRarity[t19[0].rarity] + "") && set_data(i2, a2), 1 & e3 && s2 !== (s2 = t19[0].requiresAttunement ? ` (${i18n("A5E.attument.headings.requiredPrompt")})` : "") && set_data(r2, s2);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_if_block_5$5(t18) {
  let e2, n2, o2, i2, r2, a2 = t18[5].armor[t18[0].armorCategory] + "", s2 = t18[4] && create_if_block_6$4(t18);
  return { c() {
    e2 = element("p"), n2 = element("b"), n2.textContent = `${i18n("A5E.armorClass.headings.properties")}:`, o2 = space(), i2 = text(a2), r2 = space(), s2 && s2.c();
  }, m(t19, a3) {
    insert(t19, e2, a3), append(e2, n2), append(e2, o2), append(e2, i2), append(e2, r2), s2 && s2.m(e2, null);
  }, p(t19, n3) {
    1 & n3 && a2 !== (a2 = t19[5].armor[t19[0].armorCategory] + "") && set_data(i2, a2), t19[4] ? s2 ? s2.p(t19, n3) : (s2 = create_if_block_6$4(t19), s2.c(), s2.m(e2, null)) : s2 && (s2.d(1), s2 = null);
  }, d(t19) {
    t19 && detach(e2), s2 && s2.d();
  } };
}
function create_if_block_6$4(t18) {
  let e2, n2, o2;
  return { c() {
    e2 = text("("), n2 = text(t18[4]), o2 = text(")");
  }, m(t19, i2) {
    insert(t19, e2, i2), insert(t19, n2, i2), insert(t19, o2, i2);
  }, p(t19, e3) {
    16 & e3 && set_data(n2, t19[4]);
  }, d(t19) {
    t19 && (detach(e2), detach(n2), detach(o2));
  } };
}
function create_if_block_3$a(t18) {
  let e2, n2, o2, i2, r2, a2 = t18[5].shieldTypes[t18[0].shieldCategory] + "", s2 = t18[1] && create_if_block_4$7(t18);
  return { c() {
    e2 = element("p"), n2 = element("b"), n2.textContent = `${i18n("A5E.ShieldProperties")}:`, o2 = space(), i2 = text(a2), r2 = space(), s2 && s2.c();
  }, m(t19, a3) {
    insert(t19, e2, a3), append(e2, n2), append(e2, o2), append(e2, i2), append(e2, r2), s2 && s2.m(e2, null);
  }, p(t19, n3) {
    1 & n3 && a2 !== (a2 = t19[5].shieldTypes[t19[0].shieldCategory] + "") && set_data(i2, a2), t19[1] ? s2 ? s2.p(t19, n3) : (s2 = create_if_block_4$7(t19), s2.c(), s2.m(e2, null)) : s2 && (s2.d(1), s2 = null);
  }, d(t19) {
    t19 && detach(e2), s2 && s2.d();
  } };
}
function create_if_block_4$7(t18) {
  let e2, n2, o2;
  return { c() {
    e2 = text("("), n2 = text(t18[1]), o2 = text(")");
  }, m(t19, i2) {
    insert(t19, e2, i2), insert(t19, n2, i2), insert(t19, o2, i2);
  }, p(t19, e3) {
    2 & e3 && set_data(n2, t19[1]);
  }, d(t19) {
    t19 && (detach(e2), detach(n2), detach(o2));
  } };
}
function create_if_block_2$g(t18) {
  let e2, n2, o2, i2;
  return { c() {
    e2 = element("p"), n2 = element("b"), n2.textContent = `${i18n("A5E.tabs.weaponProperties")}:`, o2 = space(), i2 = text(t18[3]);
  }, m(t19, r2) {
    insert(t19, e2, r2), append(e2, n2), append(e2, o2), append(e2, i2);
  }, p(t19, e3) {
    8 & e3 && set_data(i2, t19[3]);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_if_block_1$r(t18) {
  let e2, n2, o2, i2;
  return { c() {
    e2 = element("p"), n2 = element("b"), n2.textContent = `${i18n("A5E.objects.materialProperties")}:`, o2 = space(), i2 = text(t18[2]);
  }, m(t19, r2) {
    insert(t19, e2, r2), append(e2, n2), append(e2, o2), append(e2, i2);
  }, p(t19, e3) {
    4 & e3 && set_data(i2, t19[2]);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_if_block$1f(t18) {
  let e2, n2, o2, i2, r2 = t18[0].craftingComponents + "";
  return { c() {
    e2 = element("p"), n2 = element("b"), n2.textContent = `${i18n("A5E.objects.craftingComponents")}:`, o2 = space(), i2 = text(r2);
  }, m(t19, r3) {
    insert(t19, e2, r3), append(e2, n2), append(e2, o2), append(e2, i2);
  }, p(t19, e3) {
    1 & e3 && r2 !== (r2 = t19[0].craftingComponents + "") && set_data(i2, r2);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_fragment$2c(t18) {
  let e2, n2, o2, i2, r2, a2, s2 = t18[0].rarity && create_if_block_7$3(t18), c2 = t18[0].armorCategory && create_if_block_5$5(t18), l2 = t18[0].shieldCategory && create_if_block_3$a(t18), u2 = t18[3] && create_if_block_2$g(t18), p2 = t18[2] && create_if_block_1$r(t18), d2 = t18[0].craftingComponents && create_if_block$1f(t18);
  return { c() {
    s2 && s2.c(), e2 = space(), c2 && c2.c(), n2 = space(), l2 && l2.c(), o2 = space(), u2 && u2.c(), i2 = space(), p2 && p2.c(), r2 = space(), d2 && d2.c(), a2 = empty();
  }, m(t19, m2) {
    s2 && s2.m(t19, m2), insert(t19, e2, m2), c2 && c2.m(t19, m2), insert(t19, n2, m2), l2 && l2.m(t19, m2), insert(t19, o2, m2), u2 && u2.m(t19, m2), insert(t19, i2, m2), p2 && p2.m(t19, m2), insert(t19, r2, m2), d2 && d2.m(t19, m2), insert(t19, a2, m2);
  }, p(t19, [m2]) {
    t19[0].rarity ? s2 ? s2.p(t19, m2) : (s2 = create_if_block_7$3(t19), s2.c(), s2.m(e2.parentNode, e2)) : s2 && (s2.d(1), s2 = null), t19[0].armorCategory ? c2 ? c2.p(t19, m2) : (c2 = create_if_block_5$5(t19), c2.c(), c2.m(n2.parentNode, n2)) : c2 && (c2.d(1), c2 = null), t19[0].shieldCategory ? l2 ? l2.p(t19, m2) : (l2 = create_if_block_3$a(t19), l2.c(), l2.m(o2.parentNode, o2)) : l2 && (l2.d(1), l2 = null), t19[3] ? u2 ? u2.p(t19, m2) : (u2 = create_if_block_2$g(t19), u2.c(), u2.m(i2.parentNode, i2)) : u2 && (u2.d(1), u2 = null), t19[2] ? p2 ? p2.p(t19, m2) : (p2 = create_if_block_1$r(t19), p2.c(), p2.m(r2.parentNode, r2)) : p2 && (p2.d(1), p2 = null), t19[0].craftingComponents ? d2 ? d2.p(t19, m2) : (d2 = create_if_block$1f(t19), d2.c(), d2.m(a2.parentNode, a2)) : d2 && (d2.d(1), d2 = null);
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && (detach(e2), detach(n2), detach(o2), detach(i2), detach(r2), detach(a2)), s2 && s2.d(t19), c2 && c2.d(t19), l2 && l2.d(t19), u2 && u2.d(t19), p2 && p2.d(t19), d2 && d2.d(t19);
  } };
}
function instance$2d(t18, e2, n2) {
  let o2, i2, r2, a2, { itemData: s2 } = e2;
  const c2 = CONFIG.A5E;
  return t18.$$set = (t19) => {
    "itemData" in t19 && n2(0, s2 = t19.itemData);
  }, t18.$$.update = () => {
    1 & t18.$$.dirty && s2.rarity, 1 & t18.$$.dirty && n2(4, o2 = s2.armorProperties.map((t19) => c2.armorProperties[t19]).join(", ")), 1 & t18.$$.dirty && n2(3, i2 = s2.weaponProperties.map((t19) => c2.weaponProperties[t19]).join(", ")), 1 & t18.$$.dirty && s2.breakerProperties.map((t19) => c2.breakerProperties[t19]).join(", "), 1 & t18.$$.dirty && s2.flaws.map((t19) => c2.flaws[t19]).join(", "), 1 & t18.$$.dirty && n2(2, r2 = s2.materialProperties.map((t19) => c2.materialProperties[t19]).join(", ")), 1 & t18.$$.dirty && n2(1, a2 = s2.shieldProperties.map((t19) => c2.shieldProperties[t19]).join(", "));
  }, [s2, a2, r2, i2, o2, c2];
}
class ObjectProperties extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2d, create_fragment$2c, safe_not_equal, { itemData: 0 });
  }
}
async function evaluateTotal(t18, e2) {
  let n2;
  return n2 = e2 ? new Roll(t18, e2) : new Roll(t18), await n2.evaluate(), n2.total;
}
function evaluateAsFormula(t18, e2) {
  let n2;
  n2 = e2 ? new Roll(t18, e2) : new Roll(t18);
  let o2 = n2.formula;
  return o2 = matchMin(o2), o2 = matchMax(o2), o2 = removeZeroes(o2), o2 = removePlusMinus(o2), o2;
}
function evaluateDiceExpression(t18) {
  const e2 = t18.split(" "), n2 = [];
  let o2, i2 = 0;
  function r2() {
    i2 > 0 ? (n2.push("+"), n2.push(String(i2)), i2 = 0) : i2 < 0 && (n2.push("-"), n2.push(String(i2)), i2 = 0);
  }
  for (let t19 = 0; t19 < e2.length; t19++) {
    const a3 = e2[t19];
    if ("+" === a3 || "-" === a3) o2 = a3;
    else if (isNaN(+a3)) r2(), o2 && (n2.push(o2), o2 = void 0), n2.push(a3);
    else if (o2) switch (o2) {
      case "+":
        i2 += +a3;
        break;
      case "-":
        i2 -= +a3;
    }
    else i2 += +a3;
  }
  r2();
  const a2 = n2.join(" ");
  return a2.startsWith("+ ") || a2.startsWith("- ") ? a2.slice(2) : a2;
}
function matchMin(t18) {
  return t18.replace(/min\(([^)]+)\)/g, (t19, e2) => {
    const n2 = e2.split(",").map(Number);
    return Math.min(...n2).toString();
  });
}
function matchMax(t18) {
  return t18.replace(/max\(([^)]+)\)/g, (t19, e2) => {
    const n2 = e2.split(",").map(Number);
    return Math.max(...n2).toString();
  });
}
function removeZeroes(t18) {
  return t18.replace(/\s[-+]\s0/g, "");
}
function removePlusMinus(t18) {
  return t18.replace(/\+\s*-\s*/g, "- ");
}
function create_catch_block$3(t18) {
  return { c: noop$4, m: noop$4, p: noop$4, d: noop$4 };
}
function create_then_block$3(t18) {
  let e2, n2 = t18[3] + "";
  return { c() {
    e2 = text(n2);
  }, m(t19, n3) {
    insert(t19, e2, n3);
  }, p: noop$4, d(t19) {
    t19 && detach(e2);
  } };
}
function create_pending_block$3(t18) {
  return { c: noop$4, m: noop$4, p: noop$4, d: noop$4 };
}
function create_fragment$2b(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, m2, f2, h2, g2, _ = t18[0].maxDex + "", $2 = t18[0].minStr + "", b2 = { ctx: t18, current: null, token: null, hasCatch: false, pending: create_pending_block$3, then: create_then_block$3, catch: create_catch_block$3, value: 3 };
  return handle_promise(t18[1], b2), { c() {
    e2 = element("section"), n2 = element("hr"), o2 = space(), i2 = element("p"), r2 = element("b"), r2.textContent = `${i18n("A5E.effects.groups.ac")}`, a2 = text(":\r\n        "), b2.block.c(), s2 = space(), c2 = element("p"), l2 = element("b"), l2.textContent = `${i18n("A5E.armorClass.maxDex")}`, u2 = text(": "), p2 = text(_), d2 = space(), m2 = element("p"), f2 = element("b"), f2.textContent = `${i18n("A5E.armorClass.minStr")}`, h2 = text(": "), g2 = text($2);
  }, m(t19, _2) {
    insert(t19, e2, _2), append(e2, n2), append(e2, o2), append(e2, i2), append(i2, r2), append(i2, a2), b2.block.m(i2, b2.anchor = null), b2.mount = () => i2, b2.anchor = null, append(e2, s2), append(e2, c2), append(c2, l2), append(c2, u2), append(c2, p2), append(e2, d2), append(e2, m2), append(m2, f2), append(m2, h2), append(m2, g2);
  }, p(e3, [n3]) {
    update_await_block_branch(b2, t18 = e3, n3), 1 & n3 && _ !== (_ = t18[0].maxDex + "") && set_data(p2, _), 1 & n3 && $2 !== ($2 = t18[0].minStr + "") && set_data(g2, $2);
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2), b2.block.d(), b2.token = null, b2 = null;
  } };
}
function instance$2c(t18, e2, n2) {
  let { ac: o2 } = e2, { rollData: i2 } = e2, r2 = evaluateTotal(o2.formula, i2);
  return t18.$$set = (t19) => {
    "ac" in t19 && n2(0, o2 = t19.ac), "rollData" in t19 && n2(2, i2 = t19.rollData);
  }, [o2, r2, i2];
}
class ObjectAc extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2c, create_fragment$2b, safe_not_equal, { ac: 0, rollData: 2 });
  }
}
function create_if_block$1e(t18) {
  let e2, n2, o2, i2, r2, a2, s2 = t18[0].target.quantity + "", c2 = (t18[1].targetTypesPlural[t18[0].target.type] ?? "") + "";
  return { c() {
    e2 = element("p"), n2 = element("b"), n2.textContent = `${i18n("A5E.actions.labels.targetPlural")}:`, o2 = space(), i2 = text(s2), r2 = space(), a2 = text(c2);
  }, m(t19, s3) {
    insert(t19, e2, s3), append(e2, n2), append(e2, o2), append(e2, i2), append(e2, r2), append(e2, a2);
  }, p(t19, e3) {
    1 & e3 && s2 !== (s2 = t19[0].target.quantity + "") && set_data(i2, s2), 1 & e3 && c2 !== (c2 = (t19[1].targetTypesPlural[t19[0].target.type] ?? "") + "") && set_data(a2, c2);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_fragment$2a(t18) {
  let e2, n2 = t18[0].target.quantity > 0 && create_if_block$1e(t18);
  return { c() {
    n2 && n2.c(), e2 = empty();
  }, m(t19, o2) {
    n2 && n2.m(t19, o2), insert(t19, e2, o2);
  }, p(t19, [o2]) {
    t19[0].target.quantity > 0 ? n2 ? n2.p(t19, o2) : (n2 = create_if_block$1e(t19), n2.c(), n2.m(e2.parentNode, e2)) : n2 && (n2.d(1), n2 = null);
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2), n2 && n2.d(t19);
  } };
}
function instance$2b(t18, e2, n2) {
  let { action: o2 } = e2;
  const i2 = CONFIG.A5E;
  return t18.$$set = (t19) => {
    "action" in t19 && n2(0, o2 = t19.action);
  }, [o2, i2];
}
class Target extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2b, create_fragment$2a, safe_not_equal, { action: 0 });
  }
}
function create_if_block$1d(t18) {
  let e2, n2, o2, i2, r2, a2, s2 = t18[0].activation.cost + "";
  return { c() {
    e2 = element("p"), n2 = element("b"), n2.textContent = `${i18n("A5E.filterLabels.activationCost")}:`, o2 = space(), i2 = text(s2), r2 = space(), a2 = text(t18[1]);
  }, m(t19, s3) {
    insert(t19, e2, s3), append(e2, n2), append(e2, o2), append(e2, i2), append(e2, r2), append(e2, a2);
  }, p(t19, e3) {
    1 & e3 && s2 !== (s2 = t19[0].activation.cost + "") && set_data(i2, s2);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_fragment$29(t18) {
  let e2, n2 = t18[1] && create_if_block$1d(t18);
  return { c() {
    n2 && n2.c(), e2 = empty();
  }, m(t19, o2) {
    n2 && n2.m(t19, o2), insert(t19, e2, o2);
  }, p(t19, [e3]) {
    t19[1] && n2.p(t19, e3);
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2), n2 && n2.d(t19);
  } };
}
function instance$2a(t18, e2, n2) {
  let { action: o2 } = e2;
  const i2 = CONFIG.A5E.abilityActivationTypes[o2.activation.type];
  return t18.$$set = (t19) => {
    "action" in t19 && n2(0, o2 = t19.action);
  }, [o2, i2];
}
class ActivationCost extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$2a, create_fragment$29, safe_not_equal, { action: 0 });
  }
}
function create_else_block_1$1(t18) {
  let e2, n2, o2, i2, r2 = t18[1].timePeriods[t18[0].duration.unit] + "";
  return { c() {
    e2 = element("p"), n2 = element("b"), n2.textContent = `${i18n("A5E.actions.headings.duration")}
        :`, o2 = space(), i2 = text(r2);
  }, m(t19, r3) {
    insert(t19, e2, r3), append(e2, n2), append(e2, o2), append(e2, i2);
  }, p(t19, e3) {
    1 & e3 && r2 !== (r2 = t19[1].timePeriods[t19[0].duration.unit] + "") && set_data(i2, r2);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_if_block$1c(t18) {
  let e2;
  function n2(t19, e3) {
    return t19[0].duration.value > 1 ? create_if_block_1$q : create_else_block$a;
  }
  let o2 = n2(t18), i2 = o2(t18);
  return { c() {
    i2.c(), e2 = empty();
  }, m(t19, n3) {
    i2.m(t19, n3), insert(t19, e2, n3);
  }, p(t19, r2) {
    o2 === (o2 = n2(t19)) && i2 ? i2.p(t19, r2) : (i2.d(1), i2 = o2(t19), i2 && (i2.c(), i2.m(e2.parentNode, e2)));
  }, d(t19) {
    t19 && detach(e2), i2.d(t19);
  } };
}
function create_else_block$a(t18) {
  let e2, n2, o2, i2, r2, a2, s2 = t18[0].duration.value + "", c2 = t18[1].timePeriods[t18[0].duration.unit] + "";
  return { c() {
    e2 = element("p"), n2 = element("b"), n2.textContent = `${i18n("A5E.actions.headings.duration")}:`, o2 = space(), i2 = text(s2), r2 = space(), a2 = text(c2);
  }, m(t19, s3) {
    insert(t19, e2, s3), append(e2, n2), append(e2, o2), append(e2, i2), append(e2, r2), append(e2, a2);
  }, p(t19, e3) {
    1 & e3 && s2 !== (s2 = t19[0].duration.value + "") && set_data(i2, s2), 1 & e3 && c2 !== (c2 = t19[1].timePeriods[t19[0].duration.unit] + "") && set_data(a2, c2);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_if_block_1$q(t18) {
  let e2, n2, o2, i2, r2, a2, s2 = t18[0].duration.value + "", c2 = t18[1].timePeriodsPlural[t18[0].duration.unit] + "";
  return { c() {
    e2 = element("p"), n2 = element("b"), n2.textContent = `${i18n("A5E.actions.headings.duration")}:`, o2 = space(), i2 = text(s2), r2 = space(), a2 = text(c2);
  }, m(t19, s3) {
    insert(t19, e2, s3), append(e2, n2), append(e2, o2), append(e2, i2), append(e2, r2), append(e2, a2);
  }, p(t19, e3) {
    1 & e3 && s2 !== (s2 = t19[0].duration.value + "") && set_data(i2, s2), 1 & e3 && c2 !== (c2 = t19[1].timePeriodsPlural[t19[0].duration.unit] + "") && set_data(a2, c2);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_fragment$28(t18) {
  let e2;
  function n2(t19, e3) {
    return t19[0].duration.value ? create_if_block$1c : create_else_block_1$1;
  }
  let o2 = n2(t18), i2 = o2(t18);
  return { c() {
    i2.c(), e2 = empty();
  }, m(t19, n3) {
    i2.m(t19, n3), insert(t19, e2, n3);
  }, p(t19, [r2]) {
    o2 === (o2 = n2(t19)) && i2 ? i2.p(t19, r2) : (i2.d(1), i2 = o2(t19), i2 && (i2.c(), i2.m(e2.parentNode, e2)));
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2), i2.d(t19);
  } };
}
function instance$29(t18, e2, n2) {
  let { action: o2 } = e2;
  const i2 = CONFIG.A5E;
  return t18.$$set = (t19) => {
    "action" in t19 && n2(0, o2 = t19.action);
  }, [o2, i2];
}
class Duration extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$29, create_fragment$28, safe_not_equal, { action: 0 });
  }
}
function create_fragment$27(t18) {
  let e2, n2, o2, i2;
  return { c() {
    e2 = element("p"), n2 = element("b"), n2.textContent = `${i18n("A5E.weapons.properties.range")}:`, o2 = space(), i2 = text(t18[0]);
  }, m(t19, r2) {
    insert(t19, e2, r2), append(e2, n2), append(e2, o2), append(e2, i2);
  }, p: noop$4, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2);
  } };
}
function instance$28(t18, e2, n2) {
  let { action: o2 } = e2;
  const i2 = CONFIG.A5E, r2 = { self: i2.rangeDescriptors.self, touch: i2.rangeDescriptors.touch, fiveFeet: i2.rangeDescriptors.fiveFeet, other: i2.rangeDescriptors.other, short: "30 ft.", medium: "60 ft.", long: "120 ft." };
  const a2 = Object.values(o2.ranges).map(function(t19) {
    if ("number" == typeof t19.range) return t19.range + " " + t19.unit;
    {
      const e3 = r2[t19.range];
      return e3 || (console.warn("MC: Unknown range: " + t19.range), t19.range);
    }
  }).join(" / ");
  return t18.$$set = (t19) => {
    "action" in t19 && n2(1, o2 = t19.action);
  }, [a2, o2];
}
class Range extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$28, create_fragment$27, safe_not_equal, { action: 1 });
  }
}
function get_each_context$G(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[3] = e2[n2], o2[5] = n2, o2;
}
function create_if_block$1b(t18) {
  let e2, n2, o2, i2, r2, a2 = t18[2](t18[3]) + "";
  return { c() {
    e2 = element("p"), n2 = element("b"), n2.textContent = `${t18[1].rollTypes.savingThrow}:`, o2 = space(), i2 = text(a2), r2 = space();
  }, m(t19, a3) {
    insert(t19, e2, a3), append(e2, n2), append(e2, o2), append(e2, i2), append(e2, r2);
  }, p(t19, e3) {
    1 & e3 && a2 !== (a2 = t19[2](t19[3]) + "") && set_data(i2, a2);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_each_block$G(t18, e2) {
  let n2, o2, i2 = "savingThrow" === e2[3].type && create_if_block$1b(e2);
  return { key: t18, first: null, c() {
    n2 = empty(), i2 && i2.c(), o2 = empty(), this.first = n2;
  }, m(t19, e3) {
    insert(t19, n2, e3), i2 && i2.m(t19, e3), insert(t19, o2, e3);
  }, p(t19, n3) {
    "savingThrow" === (e2 = t19)[3].type ? i2 ? i2.p(e2, n3) : (i2 = create_if_block$1b(e2), i2.c(), i2.m(o2.parentNode, o2)) : i2 && (i2.d(1), i2 = null);
  }, d(t19) {
    t19 && (detach(n2), detach(o2)), i2 && i2.d(t19);
  } };
}
function create_fragment$26(t18) {
  let e2, n2 = [], o2 = /* @__PURE__ */ new Map(), i2 = ensure_array_like(Object.values(t18[0].prompts));
  const r2 = (t19) => t19[5];
  for (let e3 = 0; e3 < i2.length; e3 += 1) {
    let a2 = get_each_context$G(t18, i2, e3), s2 = r2(a2);
    o2.set(s2, n2[e3] = create_each_block$G(s2, a2));
  }
  return { c() {
    for (let t19 = 0; t19 < n2.length; t19 += 1) n2[t19].c();
    e2 = empty();
  }, m(t19, o3) {
    for (let e3 = 0; e3 < n2.length; e3 += 1) n2[e3] && n2[e3].m(t19, o3);
    insert(t19, e2, o3);
  }, p(t19, [a2]) {
    7 & a2 && (i2 = ensure_array_like(Object.values(t19[0].prompts)), n2 = update_keyed_each(n2, a2, r2, 1, t19, i2, o2, e2.parentNode, destroy_block, create_each_block$G, e2, get_each_context$G));
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2);
    for (let e3 = 0; e3 < n2.length; e3 += 1) n2[e3].d(t19);
  } };
}
function instance$27(t18, e2, n2) {
  let { action: o2 } = e2;
  const i2 = CONFIG.A5E;
  return t18.$$set = (t19) => {
    "action" in t19 && n2(0, o2 = t19.action);
  }, [o2, i2, function(t19) {
    let e3 = i2.saveDCOptions[t19.ability];
    return t19.onSave && (e3 += ", " + t19.onSave), e3;
  }];
}
class Prompts extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$27, create_fragment$26, safe_not_equal, { action: 0 });
  }
}
function create_fragment$25(t18) {
  let e2, n2, o2, i2, r2 = t18[1](t18[0]) + "";
  return { c() {
    e2 = element("p"), n2 = element("b"), n2.textContent = `${i18n("A5E.targets.area")}:`, o2 = space(), i2 = text(r2);
  }, m(t19, r3) {
    insert(t19, e2, r3), append(e2, n2), append(e2, o2), append(e2, i2);
  }, p(t19, [e3]) {
    1 & e3 && r2 !== (r2 = t19[1](t19[0]) + "") && set_data(i2, r2);
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2);
  } };
}
function instance$26(t18, e2, n2) {
  let { action: o2 } = e2;
  const i2 = CONFIG.A5E;
  return t18.$$set = (t19) => {
    "action" in t19 && n2(0, o2 = t19.action);
  }, [o2, function(t19) {
    var e3;
    const n3 = t19.area, o3 = n3.shape, r2 = i2.areaTypes[o3];
    switch (o3) {
      case "sphere":
      case "circle":
      case "cylinder":
      case "emanation":
        return n3.radius + " ft. " + r2;
      case "cube":
      case "square":
        return n3.width + " ft. " + r2;
      case "cone":
        return n3.length + " ft. " + r2;
      case "line":
        return null !== (e3 = n3.width) && void 0 !== e3 ? e3 : "5 ft. wide and " + n3.length + " ft. " + r2;
    }
    return o3;
  }];
}
class Area extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$26, create_fragment$25, safe_not_equal, { action: 0 });
  }
}
function create_else_block$9(t18) {
  let e2;
  return { c() {
    e2 = element("p"), e2.textContent = "This is a Patreon Feature.", attr(e2, "class", "svelte-mobile-companion-a5e-038vch56tr3-1e7pih");
  }, m(t19, n2) {
    insert(t19, e2, n2);
  }, p: noop$4, d(t19) {
    t19 && detach(e2);
  } };
}
function create_if_block$1a(t18) {
  let e2, n2, o2, i2;
  return { c() {
    e2 = element("p"), n2 = element("b"), o2 = text(t18[0]), i2 = text(" is a Patreon Feature."), attr(e2, "class", "svelte-mobile-companion-a5e-038vch56tr3-1e7pih");
  }, m(t19, r2) {
    insert(t19, e2, r2), append(e2, n2), append(n2, o2), append(e2, i2);
  }, p(t19, e3) {
    1 & e3 && set_data(o2, t19[0]);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_fragment$24(t18) {
  let e2, n2, o2, i2, r2, a2, s2;
  function c2(t19, e3) {
    return t19[0] ? create_if_block$1a : create_else_block$9;
  }
  let l2 = c2(t18), u2 = l2(t18);
  return { c() {
    e2 = element("div"), n2 = element("h1"), n2.textContent = "Patreon Feature", o2 = space(), u2.c(), i2 = space(), r2 = element("p"), r2.innerHTML = 'You can download it as a <span class="pledge-type svelte-mobile-companion-a5e-038vch56tr3-1e7pih">Copper Coin Collector</span> at <a href="https://www.patreon.com/SyriousWorkshop/membership" target="_blank">Syrious&#39; Workshop</a>', a2 = space(), s2 = element("p"), s2.textContent = "Your contribution will help immensely further developing this module.", attr(n2, "class", "title svelte-mobile-companion-a5e-038vch56tr3-1e7pih"), attr(r2, "class", "svelte-mobile-companion-a5e-038vch56tr3-1e7pih"), attr(s2, "class", "svelte-mobile-companion-a5e-038vch56tr3-1e7pih"), attr(e2, "class", "information svelte-mobile-companion-a5e-038vch56tr3-1e7pih");
  }, m(t19, c3) {
    insert(t19, e2, c3), append(e2, n2), append(e2, o2), u2.m(e2, null), append(e2, i2), append(e2, r2), append(e2, a2), append(e2, s2);
  }, p(t19, [n3]) {
    l2 === (l2 = c2(t19)) && u2 ? u2.p(t19, n3) : (u2.d(1), u2 = l2(t19), u2 && (u2.c(), u2.m(e2, i2)));
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2), u2.d();
  } };
}
function instance$25(t18, e2, n2) {
  let { subject: o2 } = e2;
  return t18.$$set = (t19) => {
    "subject" in t19 && n2(0, o2 = t19.subject);
  }, [o2];
}
class Patreon extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$25, create_fragment$24, safe_not_equal, { subject: 0 });
  }
}
function create_if_block$19(t18) {
  let e2, n2, o2, i2;
  const r2 = [create_if_block_1$p, create_else_block$8], a2 = [];
  return e2 = function(t19) {
    return t19[8] ? 0 : 1;
  }(t18), n2 = a2[e2] = r2[e2](t18), { c() {
    n2.c(), o2 = empty();
  }, m(t19, n3) {
    a2[e2].m(t19, n3), insert(t19, o2, n3), i2 = true;
  }, p(t19, e3) {
    n2.p(t19, e3);
  }, i(t19) {
    i2 || (transition_in(n2), i2 = true);
  }, o(t19) {
    transition_out(n2), i2 = false;
  }, d(t19) {
    t19 && detach(o2), a2[e2].d(t19);
  } };
}
function create_else_block$8(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2;
  i2 = new DiceBurst({ props: { duration: 1e3 } }), t18[15](i2);
  let l2 = t18[2] && create_if_block_2$f(t18);
  return { c() {
    e2 = element("div"), n2 = element("i"), o2 = space(), create_component(i2.$$.fragment), r2 = space(), l2 && l2.c(), attr(n2, "class", "fa-solid fa-dice-d20 fa-lg svelte-mobile-companion-a5e-038vch56tr3-stgnhm"), attr(n2, "aria-hidden", "true"), toggle_class(n2, "usable", t18[0] >= t18[1]), toggle_class(n2, "isPressed", t18[5] > 0), toggle_class(n2, "effectTriggered", t18[6]), attr(e2, "class", "uses-container svelte-mobile-companion-a5e-038vch56tr3-stgnhm"), set_style(e2, "--progress", t18[5] / maxHoldTime * 100 + "%");
  }, m(u2, p2) {
    insert(u2, e2, p2), append(e2, n2), append(e2, o2), mount_component(i2, e2, null), append(e2, r2), l2 && l2.m(e2, null), a2 = true, s2 || (c2 = [listen(n2, "mousedown", t18[10]), listen(n2, "mouseup", t18[11]), listen(n2, "mouseleave", t18[11]), listen(n2, "touchstart", t18[10], { passive: true }), listen(n2, "touchend", t18[11], { passive: true })], s2 = true);
  }, p(t19, o3) {
    (!a2 || 3 & o3) && toggle_class(n2, "usable", t19[0] >= t19[1]), (!a2 || 32 & o3) && toggle_class(n2, "isPressed", t19[5] > 0), (!a2 || 64 & o3) && toggle_class(n2, "effectTriggered", t19[6]);
    i2.$set({}), t19[2] ? l2 ? (l2.p(t19, o3), 4 & o3 && transition_in(l2, 1)) : (l2 = create_if_block_2$f(t19), l2.c(), transition_in(l2, 1), l2.m(e2, null)) : l2 && (group_outros(), transition_out(l2, 1, 1, () => {
      l2 = null;
    }), check_outros()), (!a2 || 32 & o3) && set_style(e2, "--progress", t19[5] / maxHoldTime * 100 + "%");
  }, i(t19) {
    a2 || (transition_in(i2.$$.fragment, t19), transition_in(l2), a2 = true);
  }, o(t19) {
    transition_out(i2.$$.fragment, t19), transition_out(l2), a2 = false;
  }, d(n3) {
    n3 && detach(e2), t18[15](null), destroy_component(i2), l2 && l2.d(), s2 = false, run_all(c2);
  } };
}
function create_if_block_1$p(t18) {
  let e2, n2, o2;
  return { c() {
    e2 = element("div"), n2 = element("p"), o2 = text(t18[3]), attr(e2, "class", "number-only svelte-mobile-companion-a5e-038vch56tr3-stgnhm");
  }, m(t19, i2) {
    insert(t19, e2, i2), append(e2, n2), append(n2, o2);
  }, p(t19, e3) {
    8 & e3 && set_data(o2, t19[3]);
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2);
  } };
}
function create_if_block_2$f(t18) {
  let e2, n2, o2, i2, r2, a2, s2;
  return n2 = new EvaluatingInput({ props: { value: t18[0], id: "uses.value", name: "uses.value", styleClass: "number-input", min: 0, max: t18[3] } }), n2.$on("change", t18[9]), { c() {
    e2 = element("div"), create_component(n2.$$.fragment), o2 = space(), i2 = element("span"), i2.textContent = "|", r2 = space(), a2 = element("input"), attr(i2, "class", "separator svelte-mobile-companion-a5e-038vch56tr3-stgnhm"), attr(a2, "class", "number-input svelte-mobile-companion-a5e-038vch56tr3-stgnhm"), attr(a2, "type", "number"), a2.disabled = true, a2.value = t18[3], attr(e2, "class", "uses-input svelte-mobile-companion-a5e-038vch56tr3-stgnhm");
  }, m(t19, c2) {
    insert(t19, e2, c2), mount_component(n2, e2, null), append(e2, o2), append(e2, i2), append(e2, r2), append(e2, a2), s2 = true;
  }, p(t19, e3) {
    const o3 = {};
    1 & e3 && (o3.value = t19[0]), 8 & e3 && (o3.max = t19[3]), n2.$set(o3), (!s2 || 8 & e3 && a2.value !== t19[3]) && (a2.value = t19[3]);
  }, i(t19) {
    s2 || (transition_in(n2.$$.fragment, t19), s2 = true);
  }, o(t19) {
    transition_out(n2.$$.fragment, t19), s2 = false;
  }, d(t19) {
    t19 && detach(e2), destroy_component(n2);
  } };
}
function create_fragment$23(t18) {
  let e2, n2, o2 = t18[3] && create_if_block$19(t18);
  return { c() {
    o2 && o2.c(), e2 = empty();
  }, m(t19, i2) {
    o2 && o2.m(t19, i2), insert(t19, e2, i2), n2 = true;
  }, p(t19, [n3]) {
    t19[3] ? o2 ? (o2.p(t19, n3), 8 & n3 && transition_in(o2, 1)) : (o2 = create_if_block$19(t19), o2.c(), transition_in(o2, 1), o2.m(e2.parentNode, e2)) : o2 && (group_outros(), transition_out(o2, 1, 1, () => {
      o2 = null;
    }), check_outros());
  }, i(t19) {
    n2 || (transition_in(o2), n2 = true);
  }, o(t19) {
    transition_out(o2), n2 = false;
  }, d(t19) {
    t19 && detach(e2), o2 && o2.d(t19);
  } };
}
const maxHoldTime = 1500;
function instance$24(t18, e2, n2) {
  let o2, { value: i2 } = e2, { max: r2 } = e2, { costsPerUse: a2 = 1 } = e2, { rollData: s2 } = e2, { evaluateMaximumFromRollData: c2 = true } = e2, { showNumbers: l2 = true } = e2;
  const u2 = getContext("actorStore");
  component_subscribe(t18, u2, (t19) => n2(17, o2 = t19));
  const p2 = isReadOnlyActor(o2) || getContext("readOnly");
  let d2, m2 = 0;
  const f2 = createEventDispatcher();
  function h2(t19, e3) {
    f2("update", { oldValue: t19, newValue: e3 });
  }
  function g2() {
    i2 >= a2 && (h2(i2, i2 - a2), setTimeout(() => {
      n2(6, b2 = false);
    }, 1e3), d2.trigger());
  }
  let _, $2 = 0;
  let b2 = false;
  function y2() {
    clearInterval(_), n2(5, $2 = 0);
  }
  return t18.$$set = (t19) => {
    "value" in t19 && n2(0, i2 = t19.value), "max" in t19 && n2(12, r2 = t19.max), "costsPerUse" in t19 && n2(1, a2 = t19.costsPerUse), "rollData" in t19 && n2(13, s2 = t19.rollData), "evaluateMaximumFromRollData" in t19 && n2(14, c2 = t19.evaluateMaximumFromRollData), "showNumbers" in t19 && n2(2, l2 = t19.showNumbers);
  }, t18.$$.update = () => {
    28672 & t18.$$.dirty && (c2 && "string" == typeof r2 && r2.length > 0 ? evaluateTotal(r2, s2).then((t19) => {
      n2(3, m2 = null != t19 ? t19 : 0);
    }) : n2(3, m2 = r2));
  }, [i2, a2, l2, m2, d2, $2, b2, u2, p2, function(t19) {
    let e3 = t19.detail.value;
    h2(i2, e3);
  }, function() {
    i2 < a2 || b2 || (n2(5, $2 = 0), _ = setInterval(() => {
      n2(5, $2 += 50), $2 >= maxHoldTime && (n2(5, $2 = maxHoldTime), g2(), y2());
    }, 50));
  }, y2, r2, s2, c2, function(t19) {
    binding_callbacks[t19 ? "unshift" : "push"](() => {
      d2 = t19, n2(4, d2);
    });
  }];
}
class UseButton extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$24, create_fragment$23, safe_not_equal, { value: 0, max: 12, costsPerUse: 1, rollData: 13, evaluateMaximumFromRollData: 14, showNumbers: 2 });
  }
}
function create_else_block$7(t18) {
  let e2, n2;
  return e2 = new UseButton({ props: { value: t18[2].value, max: t18[2].max, costsPerUse: 1, rollData: t18[1].getRollData() } }), e2.$on("update", t18[4]), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    4 & n3 && (o2.value = t19[2].value), 4 & n3 && (o2.max = t19[2].max), 2 & n3 && (o2.rollData = t19[1].getRollData()), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_if_block$18(t18) {
  let e2, n2 = t18[2].max + "";
  return { c() {
    e2 = text(n2);
  }, m(t19, n3) {
    insert(t19, e2, n3);
  }, p(t19, o2) {
    4 & o2 && n2 !== (n2 = t19[2].max + "") && set_data(e2, n2);
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2);
  } };
}
function create_fragment$22(t18) {
  let e2, n2, o2, i2, r2, a2, s2;
  const c2 = [create_if_block$18, create_else_block$7], l2 = [];
  function u2(t19, e3) {
    return t19[0] ? 0 : 1;
  }
  return r2 = u2(t18), a2 = l2[r2] = c2[r2](t18), { c() {
    e2 = element("div"), n2 = element("span"), o2 = element("b"), o2.textContent = `${i18n("A5E.consumers.uses.title")}:`, i2 = space(), a2.c(), attr(e2, "class", "uses svelte-mobile-companion-a5e-038vch56tr3-mcoqju");
  }, m(t19, a3) {
    insert(t19, e2, a3), append(e2, n2), append(n2, o2), append(e2, i2), l2[r2].m(e2, null), s2 = true;
  }, p(t19, [n3]) {
    let o3 = r2;
    r2 = u2(t19), r2 === o3 ? l2[r2].p(t19, n3) : (group_outros(), transition_out(l2[o3], 1, 1, () => {
      l2[o3] = null;
    }), check_outros(), a2 = l2[r2], a2 ? a2.p(t19, n3) : (a2 = l2[r2] = c2[r2](t19), a2.c()), transition_in(a2, 1), a2.m(e2, null));
  }, i(t19) {
    s2 || (transition_in(a2), s2 = true);
  }, o(t19) {
    transition_out(a2), s2 = false;
  }, d(t19) {
    t19 && detach(e2), l2[r2].d();
  } };
}
function instance$23(t18, e2, n2) {
  let o2, i2, r2, a2, s2;
  var c2;
  let { action: l2 } = e2, { actionId: u2 } = e2;
  const p2 = getContext("actorStore");
  return component_subscribe(t18, p2, (t19) => n2(8, s2 = t19)), t18.$$set = (t19) => {
    "action" in t19 && n2(5, l2 = t19.action), "actionId" in t19 && n2(6, u2 = t19.actionId);
  }, t18.$$.update = () => {
    32 & t18.$$.dirty && n2(2, o2 = l2.uses), 160 & t18.$$.dirty && (i2 = null === n2(7, c2 = l2.parent) || void 0 === c2 ? void 0 : c2.parent), 256 & t18.$$.dirty && n2(1, r2 = s2), 256 & t18.$$.dirty && n2(0, a2 = isReadOnlyActor(s2) || getContext("readOnly"));
  }, [a2, r2, o2, p2, function(t19) {
    t19.preventDefault();
    const e3 = t19.detail.newValue;
    i2.update({ [`system.actions.${u2}.uses.value`]: e3 });
  }, l2, u2, c2, s2];
}
class ActionUses extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$23, create_fragment$22, safe_not_equal, { action: 5, actionId: 6 });
  }
}
function getFormulaForAttack(t18, e2, n2, o2) {
  if (!(e2 && t18 && n2 && o2)) return "Invalid Data";
  const i2 = game.a5e.managers.RollPreparationManager.prepareAttackRollData(t18, e2, n2), r2 = i2?.formula;
  if (!r2) return getFormulaForAttackFallback(e2.system, n2, o2);
  let a2 = r2;
  return game.settings.get(getFullModuleId$1(), SHOW_MOD_NAMES) || (a2 = r2.replace(/\[\w+(?:\s*\w+)*]/g, "")), evaluateDiceExpression(a2);
}
function getFormulaForAttackFallback(t18, e2, n2) {
  let o2 = "1d20";
  return e2.formula && (o2 += " + " + e2.formula), e2.bonus && (o2 += " + " + e2.bonus), t18?.weaponProperties?.some((t19) => "finesse" === t19) ? o2 += " + @finesse.mod" : "rangedWeaponAttack" === e2.attackType ? o2 += " + @dex.mod" : "meleeWeaponAttack" === e2.attackType ? o2 += " + @str.mod" : "rangedSpellAttack" !== e2.attackType && "meleeSpellAttack" !== e2.attackType || (o2 += " +" + n2.spell?.mod), e2.proficient && (o2 += " + @prof"), evaluateDiceExpression(evaluateAsFormula(o2, n2));
}
function get_each_context$F(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[8] = e2[n2], o2[10] = n2, o2;
}
function create_if_block_4$6(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2 = t18[3].attackTypes[t18[8].attackType] + "", l2 = getRollLabel(t18[8]) + "";
  return { c() {
    e2 = element("p"), n2 = element("b"), n2.textContent = `${i18n("A5E.contexts.attackType")}:`, o2 = space(), i2 = text(c2), r2 = space(), a2 = element("i"), s2 = text(l2);
  }, m(t19, c3) {
    insert(t19, e2, c3), append(e2, n2), append(e2, o2), append(e2, i2), append(e2, r2), append(e2, a2), append(a2, s2);
  }, p(t19, e3) {
    1 & e3 && c2 !== (c2 = t19[3].attackTypes[t19[8].attackType] + "") && set_data(i2, c2), 1 & e3 && l2 !== (l2 = getRollLabel(t19[8]) + "") && set_data(s2, l2);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_else_block$6(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2, p2 = t18[8].type + "", d2 = t18[8].formula ? `${evaluateAsFormula(t18[8].formula, t18[1])}` : "", m2 = getRollLabel(t18[8]) + "";
  return { c() {
    e2 = element("p"), n2 = element("b"), o2 = text(p2), i2 = text(":"), r2 = space(), a2 = text(d2), s2 = space(), c2 = element("i"), l2 = text(m2), u2 = space();
  }, m(t19, p3) {
    insert(t19, e2, p3), append(e2, n2), append(n2, o2), append(n2, i2), append(e2, r2), append(e2, a2), append(e2, s2), append(e2, c2), append(c2, l2), append(e2, u2);
  }, p(t19, e3) {
    1 & e3 && p2 !== (p2 = t19[8].type + "") && set_data(o2, p2), 3 & e3 && d2 !== (d2 = t19[8].formula ? `${evaluateAsFormula(t19[8].formula, t19[1])}` : "") && set_data(a2, d2), 1 & e3 && m2 !== (m2 = getRollLabel(t19[8]) + "") && set_data(l2, m2);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_if_block_3$9(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2 = t18[8].formula ? `${evaluateAsFormula(t18[8].formula, t18[1])}` : "", u2 = getRollLabel(t18[8]) + "";
  return { c() {
    e2 = element("p"), n2 = element("b"), n2.textContent = `${i18n("A5E.rollLabels.generic")}:`, o2 = space(), i2 = text(l2), r2 = space(), a2 = element("i"), s2 = text(u2), c2 = space();
  }, m(t19, l3) {
    insert(t19, e2, l3), append(e2, n2), append(e2, o2), append(e2, i2), append(e2, r2), append(e2, a2), append(a2, s2), insert(t19, c2, l3);
  }, p(t19, e3) {
    3 & e3 && l2 !== (l2 = t19[8].formula ? `${evaluateAsFormula(t19[8].formula, t19[1])}` : "") && set_data(i2, l2), 1 & e3 && u2 !== (u2 = getRollLabel(t19[8]) + "") && set_data(s2, u2);
  }, d(t19) {
    t19 && (detach(e2), detach(c2));
  } };
}
function create_if_block_2$e(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2 = t18[8].formula ? `${evaluateAsFormula(t18[8].formula, t18[1])}` : "", u2 = getRollLabel(t18[8]) + "";
  return { c() {
    e2 = element("p"), n2 = element("b"), n2.textContent = `${i18n("A5E.actions.headings.options.healing")}:`, o2 = space(), i2 = text(l2), r2 = space(), a2 = element("i"), s2 = text(u2), c2 = space();
  }, m(t19, l3) {
    insert(t19, e2, l3), append(e2, n2), append(e2, o2), append(e2, i2), append(e2, r2), append(e2, a2), append(a2, s2), insert(t19, c2, l3);
  }, p(t19, e3) {
    3 & e3 && l2 !== (l2 = t19[8].formula ? `${evaluateAsFormula(t19[8].formula, t19[1])}` : "") && set_data(i2, l2), 1 & e3 && u2 !== (u2 = getRollLabel(t19[8]) + "") && set_data(s2, u2);
  }, d(t19) {
    t19 && (detach(e2), detach(c2));
  } };
}
function create_if_block_1$o(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2, p2 = t18[8].formula ? `${evaluateAsFormula(t18[8].formula, t18[1])}` : "", d2 = (t18[8].damageType ? t18[3].damageTypes[t18[8].damageType] : "") + "", m2 = getRollLabel(t18[8]) + "";
  return { c() {
    e2 = element("p"), n2 = element("b"), n2.textContent = `${i18n("A5E.actions.headings.options.damage")}:`, o2 = space(), i2 = text(p2), r2 = space(), a2 = text(d2), s2 = space(), c2 = element("i"), l2 = text(m2), u2 = space();
  }, m(t19, p3) {
    insert(t19, e2, p3), append(e2, n2), append(e2, o2), append(e2, i2), append(e2, r2), append(e2, a2), append(e2, s2), append(e2, c2), append(c2, l2), insert(t19, u2, p3);
  }, p(t19, e3) {
    3 & e3 && p2 !== (p2 = t19[8].formula ? `${evaluateAsFormula(t19[8].formula, t19[1])}` : "") && set_data(i2, p2), 1 & e3 && d2 !== (d2 = (t19[8].damageType ? t19[3].damageTypes[t19[8].damageType] : "") + "") && set_data(a2, d2), 1 & e3 && m2 !== (m2 = getRollLabel(t19[8]) + "") && set_data(l2, m2);
  }, d(t19) {
    t19 && (detach(e2), detach(u2));
  } };
}
function create_if_block$17(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2 = getFormulaForAttack(t18[4], t18[5], t18[8], t18[1]) + "", u2 = getRollLabel(t18[8]) + "";
  return { c() {
    e2 = element("p"), n2 = element("b"), n2.textContent = `${i18n("A5E.actions.headings.options.attack")}:`, o2 = space(), i2 = text(l2), r2 = space(), a2 = element("i"), s2 = text(u2), c2 = space();
  }, m(t19, l3) {
    insert(t19, e2, l3), append(e2, n2), append(e2, o2), append(e2, i2), append(e2, r2), append(e2, a2), append(a2, s2), insert(t19, c2, l3);
  }, p(t19, e3) {
    3 & e3 && l2 !== (l2 = getFormulaForAttack(t19[4], t19[5], t19[8], t19[1]) + "") && set_data(i2, l2), 1 & e3 && u2 !== (u2 = getRollLabel(t19[8]) + "") && set_data(s2, u2);
  }, d(t19) {
    t19 && (detach(e2), detach(c2));
  } };
}
function create_each_block$F(t18, e2) {
  let n2, o2, i2, r2 = e2[8].attackType && create_if_block_4$6(e2);
  function a2(t19, e3) {
    return t19[8].type === RollType.attack ? create_if_block$17 : t19[8].type === RollType.damage ? create_if_block_1$o : t19[8].type === RollType.healing ? create_if_block_2$e : t19[8].type === RollType.generic ? create_if_block_3$9 : create_else_block$6;
  }
  let s2 = a2(e2), c2 = s2(e2);
  return { key: t18, first: null, c() {
    n2 = empty(), r2 && r2.c(), o2 = space(), c2.c(), i2 = empty(), this.first = n2;
  }, m(t19, e3) {
    insert(t19, n2, e3), r2 && r2.m(t19, e3), insert(t19, o2, e3), c2.m(t19, e3), insert(t19, i2, e3);
  }, p(t19, n3) {
    (e2 = t19)[8].attackType ? r2 ? r2.p(e2, n3) : (r2 = create_if_block_4$6(e2), r2.c(), r2.m(o2.parentNode, o2)) : r2 && (r2.d(1), r2 = null), s2 === (s2 = a2(e2)) && c2 ? c2.p(e2, n3) : (c2.d(1), c2 = s2(e2), c2 && (c2.c(), c2.m(i2.parentNode, i2)));
  }, d(t19) {
    t19 && (detach(n2), detach(o2), detach(i2)), r2 && r2.d(t19), c2.d(t19);
  } };
}
function create_fragment$21(t18) {
  let e2, n2 = [], o2 = /* @__PURE__ */ new Map(), i2 = ensure_array_like(Object.values(t18[0].rolls));
  const r2 = (t19) => t19[10];
  for (let e3 = 0; e3 < i2.length; e3 += 1) {
    let a2 = get_each_context$F(t18, i2, e3), s2 = r2(a2);
    o2.set(s2, n2[e3] = create_each_block$F(s2, a2));
  }
  return { c() {
    for (let t19 = 0; t19 < n2.length; t19 += 1) n2[t19].c();
    e2 = empty();
  }, m(t19, o3) {
    for (let e3 = 0; e3 < n2.length; e3 += 1) n2[e3] && n2[e3].m(t19, o3);
    insert(t19, e2, o3);
  }, p(t19, [a2]) {
    59 & a2 && (i2 = ensure_array_like(Object.values(t19[0].rolls)), n2 = update_keyed_each(n2, a2, r2, 1, t19, i2, o2, e2.parentNode, destroy_block, create_each_block$F, e2, get_each_context$F));
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2);
    for (let e3 = 0; e3 < n2.length; e3 += 1) n2[e3].d(t19);
  } };
}
function getRollLabel(t18) {
  return t18.label ? `(${t18.label})` : "";
}
function instance$22(t18, e2, n2) {
  let o2;
  var i2;
  let { action: r2 } = e2, { rollData: a2 } = e2;
  const s2 = getContext("actorStore");
  component_subscribe(t18, s2, (t19) => n2(7, o2 = t19));
  const c2 = CONFIG.A5E, l2 = o2, u2 = null === (i2 = r2.parent) || void 0 === i2 ? void 0 : i2.parent;
  return t18.$$set = (t19) => {
    "action" in t19 && n2(0, r2 = t19.action), "rollData" in t19 && n2(1, a2 = t19.rollData);
  }, [r2, a2, s2, c2, l2, u2];
}
class ActionRolls extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$22, create_fragment$21, safe_not_equal, { action: 0, rollData: 1 });
  }
}
const CONTEXT = { ACTOR_STORE: "actorStore", ACTIVE_FILTER_STORE: "activeFilterStore", SWITCH_FILTER: "switchFilter", GET_CURRENT_FILTER: "getCurrentFilter", INNER_APP_WIDTH_STORE: "innerAppWidthStore", SIDE: "side", READ_ONLY: "readOnly", OPENED_DETAILS_STORE: "openedDetails", WIDGET_STORE: "widgetStore", DISPLAYED_IN_WIDGET: "displayedInWidget" };
function create_if_block_8$2(t18) {
  let e2, n2, o2, i2, r2 = t18[0].name + "", a2 = !t18[4] && create_if_block_9$2(t18);
  return { c() {
    e2 = element("div"), a2 && a2.c(), n2 = space(), o2 = element("h3"), i2 = text(r2), attr(o2, "class", "svelte-mobile-companion-a5e-038vch56tr3-nwrmw4"), attr(e2, "class", "action-name svelte-mobile-companion-a5e-038vch56tr3-nwrmw4");
  }, m(t19, r3) {
    insert(t19, e2, r3), a2 && a2.m(e2, null), append(e2, n2), append(e2, o2), append(o2, i2);
  }, p(t19, e3) {
    t19[4] || a2.p(t19, e3), 1 & e3 && r2 !== (r2 = t19[0].name + "") && set_data(i2, r2);
  }, d(t19) {
    t19 && detach(e2), a2 && a2.d();
  } };
}
function create_if_block_9$2(t18) {
  let e2, n2, o2;
  return { c() {
    e2 = element("img"), attr(e2, "class", "action-img svelte-mobile-companion-a5e-038vch56tr3-nwrmw4"), src_url_equal(e2.src, n2 = t18[0].img) || attr(e2, "src", n2), attr(e2, "alt", o2 = t18[0].name);
  }, m(t19, n3) {
    insert(t19, e2, n3);
  }, p(t19, i2) {
    1 & i2 && !src_url_equal(e2.src, n2 = t19[0].img) && attr(e2, "src", n2), 1 & i2 && o2 !== (o2 = t19[0].name) && attr(e2, "alt", o2);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_if_block_7$2(t18) {
  let e2, n2;
  return e2 = new ActionUses({ props: { action: t18[0], actionId: t18[1] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1 & n3 && (o2.action = t19[0]), 2 & n3 && (o2.actionId = t19[1]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_if_block_6$3(t18) {
  let e2, n2;
  return e2 = new ActionRolls({ props: { action: t18[0], rollData: t18[2] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1 & n3 && (o2.action = t19[0]), 4 & n3 && (o2.rollData = t19[2]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_if_block_5$4(t18) {
  let e2, n2;
  return e2 = new ActivationCost({ props: { action: t18[0] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1 & n3 && (o2.action = t19[0]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_if_block_4$5(t18) {
  let e2, n2;
  return e2 = new Range({ props: { action: t18[0] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1 & n3 && (o2.action = t19[0]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_if_block_3$8(t18) {
  let e2, n2;
  return e2 = new Target({ props: { action: t18[0] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1 & n3 && (o2.action = t19[0]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_if_block_2$d(t18) {
  let e2, n2;
  return e2 = new Duration({ props: { action: t18[0] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1 & n3 && (o2.action = t19[0]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_if_block_1$n(t18) {
  let e2, n2;
  return e2 = new Area({ props: { action: t18[0] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1 & n3 && (o2.action = t19[0]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_if_block$16(t18) {
  let e2, n2;
  return e2 = new Prompts({ props: { action: t18[0] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1 & n3 && (o2.action = t19[0]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_fragment$20(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2, p2 = t18[0].ranges && Object.keys(t18[0].ranges).length > 0, d2 = t18[3] && create_if_block_8$2(t18), m2 = t18[0].uses?.max && create_if_block_7$2(t18), f2 = t18[0].rolls && create_if_block_6$3(t18), h2 = t18[0].activation?.cost && create_if_block_5$4(t18), g2 = p2 && create_if_block_4$5(t18), _ = t18[0].target?.type && create_if_block_3$8(t18), $2 = t18[0].duration?.unit && create_if_block_2$d(t18), b2 = t18[0].area?.shape && create_if_block_1$n(t18), y2 = t18[0].prompts && create_if_block$16(t18);
  return { c() {
    e2 = element("div"), d2 && d2.c(), n2 = space(), m2 && m2.c(), o2 = space(), f2 && f2.c(), i2 = space(), h2 && h2.c(), r2 = space(), g2 && g2.c(), a2 = space(), _ && _.c(), s2 = space(), $2 && $2.c(), c2 = space(), b2 && b2.c(), l2 = space(), y2 && y2.c(), attr(e2, "class", "item-action svelte-mobile-companion-a5e-038vch56tr3-nwrmw4");
  }, m(t19, p3) {
    insert(t19, e2, p3), d2 && d2.m(e2, null), append(e2, n2), m2 && m2.m(e2, null), append(e2, o2), f2 && f2.m(e2, null), append(e2, i2), h2 && h2.m(e2, null), append(e2, r2), g2 && g2.m(e2, null), append(e2, a2), _ && _.m(e2, null), append(e2, s2), $2 && $2.m(e2, null), append(e2, c2), b2 && b2.m(e2, null), append(e2, l2), y2 && y2.m(e2, null), u2 = true;
  }, p(t19, [u3]) {
    t19[3] ? d2 ? d2.p(t19, u3) : (d2 = create_if_block_8$2(t19), d2.c(), d2.m(e2, n2)) : d2 && (d2.d(1), d2 = null), t19[0].uses?.max ? m2 ? (m2.p(t19, u3), 1 & u3 && transition_in(m2, 1)) : (m2 = create_if_block_7$2(t19), m2.c(), transition_in(m2, 1), m2.m(e2, o2)) : m2 && (group_outros(), transition_out(m2, 1, 1, () => {
      m2 = null;
    }), check_outros()), t19[0].rolls ? f2 ? (f2.p(t19, u3), 1 & u3 && transition_in(f2, 1)) : (f2 = create_if_block_6$3(t19), f2.c(), transition_in(f2, 1), f2.m(e2, i2)) : f2 && (group_outros(), transition_out(f2, 1, 1, () => {
      f2 = null;
    }), check_outros()), t19[0].activation?.cost ? h2 ? (h2.p(t19, u3), 1 & u3 && transition_in(h2, 1)) : (h2 = create_if_block_5$4(t19), h2.c(), transition_in(h2, 1), h2.m(e2, r2)) : h2 && (group_outros(), transition_out(h2, 1, 1, () => {
      h2 = null;
    }), check_outros()), 1 & u3 && (p2 = t19[0].ranges && Object.keys(t19[0].ranges).length > 0), p2 ? g2 ? (g2.p(t19, u3), 1 & u3 && transition_in(g2, 1)) : (g2 = create_if_block_4$5(t19), g2.c(), transition_in(g2, 1), g2.m(e2, a2)) : g2 && (group_outros(), transition_out(g2, 1, 1, () => {
      g2 = null;
    }), check_outros()), t19[0].target?.type ? _ ? (_.p(t19, u3), 1 & u3 && transition_in(_, 1)) : (_ = create_if_block_3$8(t19), _.c(), transition_in(_, 1), _.m(e2, s2)) : _ && (group_outros(), transition_out(_, 1, 1, () => {
      _ = null;
    }), check_outros()), t19[0].duration?.unit ? $2 ? ($2.p(t19, u3), 1 & u3 && transition_in($2, 1)) : ($2 = create_if_block_2$d(t19), $2.c(), transition_in($2, 1), $2.m(e2, c2)) : $2 && (group_outros(), transition_out($2, 1, 1, () => {
      $2 = null;
    }), check_outros()), t19[0].area?.shape ? b2 ? (b2.p(t19, u3), 1 & u3 && transition_in(b2, 1)) : (b2 = create_if_block_1$n(t19), b2.c(), transition_in(b2, 1), b2.m(e2, l2)) : b2 && (group_outros(), transition_out(b2, 1, 1, () => {
      b2 = null;
    }), check_outros()), t19[0].prompts ? y2 ? (y2.p(t19, u3), 1 & u3 && transition_in(y2, 1)) : (y2 = create_if_block$16(t19), y2.c(), transition_in(y2, 1), y2.m(e2, null)) : y2 && (group_outros(), transition_out(y2, 1, 1, () => {
      y2 = null;
    }), check_outros());
  }, i(t19) {
    u2 || (transition_in(m2), transition_in(f2), transition_in(h2), transition_in(g2), transition_in(_), transition_in($2), transition_in(b2), transition_in(y2), u2 = true);
  }, o(t19) {
    transition_out(m2), transition_out(f2), transition_out(h2), transition_out(g2), transition_out(_), transition_out($2), transition_out(b2), transition_out(y2), u2 = false;
  }, d(t19) {
    t19 && detach(e2), d2 && d2.d(), m2 && m2.d(), f2 && f2.d(), h2 && h2.d(), g2 && g2.d(), _ && _.d(), $2 && $2.d(), b2 && b2.d(), y2 && y2.d();
  } };
}
function instance$21(t18, e2, n2) {
  let { action: o2 } = e2, { actionId: i2 } = e2, { rollData: r2 } = e2, { displayActionName: a2 = true } = e2;
  const s2 = getContext(CONTEXT.DISPLAYED_IN_WIDGET);
  return t18.$$set = (t19) => {
    "action" in t19 && n2(0, o2 = t19.action), "actionId" in t19 && n2(1, i2 = t19.actionId), "rollData" in t19 && n2(2, r2 = t19.rollData), "displayActionName" in t19 && n2(3, a2 = t19.displayActionName);
  }, [o2, i2, r2, a2, s2];
}
class Action extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$21, create_fragment$20, safe_not_equal, { action: 0, actionId: 1, rollData: 2, displayActionName: 3 });
  }
}
function create_if_block$15(t18) {
  let e2, n2, o2 = { ctx: t18, current: null, token: null, hasCatch: true, pending: create_pending_block$2, then: create_then_block$2, catch: create_catch_block$2, value: 1, error: 2 };
  return handle_promise(n2 = enrichText(t18[0]), o2), { c() {
    e2 = empty(), o2.block.c();
  }, m(t19, n3) {
    insert(t19, e2, n3), o2.block.m(t19, o2.anchor = n3), o2.mount = () => e2.parentNode, o2.anchor = e2;
  }, p(e3, i2) {
    t18 = e3, o2.ctx = t18, 1 & i2 && n2 !== (n2 = enrichText(t18[0])) && handle_promise(n2, o2) || update_await_block_branch(o2, t18, i2);
  }, d(t19) {
    t19 && detach(e2), o2.block.d(t19), o2.token = null, o2 = null;
  } };
}
function create_catch_block$2(t18) {
  let e2, n2 = console.error("(There was an error:", t18[2].message) + "";
  return { c() {
    e2 = text(n2);
  }, m(t19, n3) {
    insert(t19, e2, n3);
  }, p(t19, o2) {
    1 & o2 && n2 !== (n2 = console.error("(There was an error:", t19[2].message) + "") && set_data(e2, n2);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_then_block$2(t18) {
  let e2, n2 = t18[1] + "";
  return { c() {
    e2 = element("p");
  }, m(t19, o2) {
    insert(t19, e2, o2), e2.innerHTML = n2;
  }, p(t19, o2) {
    1 & o2 && n2 !== (n2 = t19[1] + "") && (e2.innerHTML = n2);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_pending_block$2(t18) {
  return { c: noop$4, m: noop$4, p: noop$4, d: noop$4 };
}
function create_fragment$1$(t18) {
  let e2, n2 = t18[0] && create_if_block$15(t18);
  return { c() {
    n2 && n2.c(), e2 = empty();
  }, m(t19, o2) {
    n2 && n2.m(t19, o2), insert(t19, e2, o2);
  }, p(t19, [o2]) {
    t19[0] ? n2 ? n2.p(t19, o2) : (n2 = create_if_block$15(t19), n2.c(), n2.m(e2.parentNode, e2)) : n2 && (n2.d(1), n2 = null);
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2), n2 && n2.d(t19);
  } };
}
function instance$20(t18, e2, n2) {
  let { description: o2 } = e2;
  return t18.$$set = (t19) => {
    "description" in t19 && n2(0, o2 = t19.description);
  }, [o2];
}
class Description extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$20, create_fragment$1$, safe_not_equal, { description: 0 });
  }
}
function create_if_block_1$m(t18) {
  let e2, n2, o2, i2, r2 = t18[0].price + "";
  return { c() {
    e2 = element("p"), n2 = element("b"), n2.textContent = `${t18[2]}`, o2 = text(": "), i2 = text(r2);
  }, m(t19, r3) {
    insert(t19, e2, r3), append(e2, n2), append(e2, o2), append(e2, i2);
  }, p(t19, e3) {
    1 & e3 && r2 !== (r2 = t19[0].price + "") && set_data(i2, r2);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_if_block$14(t18) {
  let e2, n2, o2, i2, r2, a2, s2 = t18[0].weight + "";
  return { c() {
    e2 = element("p"), n2 = element("b"), n2.textContent = `${t18[3]}`, o2 = text(": "), i2 = text(s2), r2 = space(), a2 = text(t18[4]);
  }, m(t19, s3) {
    insert(t19, e2, s3), append(e2, n2), append(e2, o2), append(e2, i2), append(e2, r2), append(e2, a2);
  }, p(t19, e3) {
    1 & e3 && s2 !== (s2 = t19[0].weight + "") && set_data(i2, s2);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_fragment$1_(t18) {
  let e2, n2, o2, i2, r2, a2 = t18[0].price && create_if_block_1$m(t18), s2 = t18[0].weight && create_if_block$14(t18);
  return i2 = new Description({ props: { description: t18[1] } }), { c() {
    e2 = element("section"), a2 && a2.c(), n2 = space(), s2 && s2.c(), o2 = space(), create_component(i2.$$.fragment);
  }, m(t19, c2) {
    insert(t19, e2, c2), a2 && a2.m(e2, null), append(e2, n2), s2 && s2.m(e2, null), append(e2, o2), mount_component(i2, e2, null), r2 = true;
  }, p(t19, [r3]) {
    t19[0].price ? a2 ? a2.p(t19, r3) : (a2 = create_if_block_1$m(t19), a2.c(), a2.m(e2, n2)) : a2 && (a2.d(1), a2 = null), t19[0].weight ? s2 ? s2.p(t19, r3) : (s2 = create_if_block$14(t19), s2.c(), s2.m(e2, o2)) : s2 && (s2.d(1), s2 = null);
    const c2 = {};
    2 & r3 && (c2.description = t19[1]), i2.$set(c2);
  }, i(t19) {
    r2 || (transition_in(i2.$$.fragment, t19), r2 = true);
  }, o(t19) {
    transition_out(i2.$$.fragment, t19), r2 = false;
  }, d(t19) {
    t19 && detach(e2), a2 && a2.d(), s2 && s2.d(), destroy_component(i2);
  } };
}
function instance$1$(t18, e2, n2) {
  var o2;
  let { itemData: i2 } = e2;
  const r2 = i18n("A5E.objects.price"), a2 = i18n("A5E.objects.weight"), s2 = i18n("A5E.objects.weightLbs");
  let c2 = i2.description;
  return i2.unidentified && (c2 = 0 !== (null === (o2 = i2.unidentifiedDescription) || void 0 === o2 ? void 0 : o2.length) ? i2.unidentifiedDescription : i18n("A5E.objects.unidentified")), t18.$$set = (t19) => {
    "itemData" in t19 && n2(0, i2 = t19.itemData);
  }, [i2, c2, r2, a2, s2];
}
class ObjectDescription extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1$, create_fragment$1_, safe_not_equal, { itemData: 0 });
  }
}
function get_each_context$E(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[7] = e2[n2][0], o2[8] = e2[n2][1], o2[10] = n2, o2;
}
function create_if_block_2$c(t18) {
  let e2, n2;
  return e2 = new ObjectAc({ props: { ac: t18[2], rollData: t18[4] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    4 & n3 && (o2.ac = t19[2]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_if_block_1$l(t18) {
  let e2, n2, o2 = [], i2 = /* @__PURE__ */ new Map(), r2 = ensure_array_like(t18[1]);
  const a2 = (t19) => t19[7];
  for (let e3 = 0; e3 < r2.length; e3 += 1) {
    let n3 = get_each_context$E(t18, r2, e3), s2 = a2(n3);
    i2.set(s2, o2[e3] = create_each_block$E(s2, n3));
  }
  return { c() {
    e2 = element("section");
    for (let t19 = 0; t19 < o2.length; t19 += 1) o2[t19].c();
    attr(e2, "class", "action-section");
  }, m(t19, i3) {
    insert(t19, e2, i3);
    for (let t20 = 0; t20 < o2.length; t20 += 1) o2[t20] && o2[t20].m(e2, null);
    n2 = true;
  }, p(t19, n3) {
    18 & n3 && (r2 = ensure_array_like(t19[1]), group_outros(), o2 = update_keyed_each(o2, n3, a2, 1, t19, r2, i2, e2, outro_and_destroy_block, create_each_block$E, null, get_each_context$E), check_outros());
  }, i(t19) {
    if (!n2) {
      for (let t20 = 0; t20 < r2.length; t20 += 1) transition_in(o2[t20]);
      n2 = true;
    }
  }, o(t19) {
    for (let t20 = 0; t20 < o2.length; t20 += 1) transition_out(o2[t20]);
    n2 = false;
  }, d(t19) {
    t19 && detach(e2);
    for (let t20 = 0; t20 < o2.length; t20 += 1) o2[t20].d();
  } };
}
function create_each_block$E(t18, e2) {
  let n2, o2, i2;
  return o2 = new Action({ props: { action: e2[8], actionId: e2[7], rollData: e2[4] } }), { key: t18, first: null, c() {
    n2 = empty(), create_component(o2.$$.fragment), this.first = n2;
  }, m(t19, e3) {
    insert(t19, n2, e3), mount_component(o2, t19, e3), i2 = true;
  }, p(t19, n3) {
    e2 = t19;
    const i3 = {};
    2 & n3 && (i3.action = e2[8]), 2 & n3 && (i3.actionId = e2[7]), o2.$set(i3);
  }, i(t19) {
    i2 || (transition_in(o2.$$.fragment, t19), i2 = true);
  }, o(t19) {
    transition_out(o2.$$.fragment, t19), i2 = false;
  }, d(t19) {
    t19 && detach(n2), destroy_component(o2, t19);
  } };
}
function create_if_block$13(t18) {
  let e2, n2;
  return e2 = new ObjectDescription({ props: { itemData: t18[0] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1 & n3 && (o2.itemData = t19[0]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_fragment$1Z(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2 = t18[2]?.formula && create_if_block_2$c(t18);
  o2 = new ObjectProperties({ props: { itemData: t18[0] } });
  let u2 = t18[1]?.length > 0 && create_if_block_1$l(t18), p2 = (t18[0].description || t18[0].unidentifiedDescription || t18[0].price || t18[0].weight) && create_if_block$13(t18);
  return { c() {
    e2 = element("div"), l2 && l2.c(), n2 = space(), create_component(o2.$$.fragment), i2 = space(), u2 && u2.c(), r2 = space(), a2 = element("hr"), s2 = space(), p2 && p2.c();
  }, m(t19, d2) {
    insert(t19, e2, d2), l2 && l2.m(e2, null), append(e2, n2), mount_component(o2, e2, null), append(e2, i2), u2 && u2.m(e2, null), append(e2, r2), append(e2, a2), append(e2, s2), p2 && p2.m(e2, null), c2 = true;
  }, p(t19, [i3]) {
    t19[2]?.formula ? l2 ? (l2.p(t19, i3), 4 & i3 && transition_in(l2, 1)) : (l2 = create_if_block_2$c(t19), l2.c(), transition_in(l2, 1), l2.m(e2, n2)) : l2 && (group_outros(), transition_out(l2, 1, 1, () => {
      l2 = null;
    }), check_outros());
    const a3 = {};
    1 & i3 && (a3.itemData = t19[0]), o2.$set(a3), t19[1]?.length > 0 ? u2 ? (u2.p(t19, i3), 2 & i3 && transition_in(u2, 1)) : (u2 = create_if_block_1$l(t19), u2.c(), transition_in(u2, 1), u2.m(e2, r2)) : u2 && (group_outros(), transition_out(u2, 1, 1, () => {
      u2 = null;
    }), check_outros()), t19[0].description || t19[0].unidentifiedDescription || t19[0].price || t19[0].weight ? p2 ? (p2.p(t19, i3), 1 & i3 && transition_in(p2, 1)) : (p2 = create_if_block$13(t19), p2.c(), transition_in(p2, 1), p2.m(e2, null)) : p2 && (group_outros(), transition_out(p2, 1, 1, () => {
      p2 = null;
    }), check_outros());
  }, i(t19) {
    c2 || (transition_in(l2), transition_in(o2.$$.fragment, t19), transition_in(u2), transition_in(p2), c2 = true);
  }, o(t19) {
    transition_out(l2), transition_out(o2.$$.fragment, t19), transition_out(u2), transition_out(p2), c2 = false;
  }, d(t19) {
    t19 && detach(e2), l2 && l2.d(), destroy_component(o2), u2 && u2.d(), p2 && p2.d();
  } };
}
function instance$1_(t18, e2, n2) {
  let o2, i2, r2, a2, { item: s2 } = e2;
  const c2 = getContext("actorStore");
  component_subscribe(t18, c2, (t19) => n2(6, a2 = t19));
  const l2 = a2.getRollData(s2);
  return t18.$$set = (t19) => {
    "item" in t19 && n2(5, s2 = t19.item);
  }, t18.$$.update = () => {
    32 & t18.$$.dirty && n2(0, o2 = s2.system), 1 & t18.$$.dirty && n2(2, i2 = o2.ac), 1 & t18.$$.dirty && n2(1, r2 = Object.entries(o2.actions));
  }, [o2, r2, i2, c2, l2, s2];
}
class ObjectBaseInfo extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1_, create_fragment$1Z, safe_not_equal, { item: 5 });
  }
}
function create_fragment$1Y(t18) {
  let e2, n2, o2, i2;
  return e2 = new Effects({ props: { item: t18[0] } }), o2 = new ObjectBaseInfo({ props: { item: t18[0] } }), { c() {
    create_component(e2.$$.fragment), n2 = space(), create_component(o2.$$.fragment);
  }, m(t19, r2) {
    mount_component(e2, t19, r2), insert(t19, n2, r2), mount_component(o2, t19, r2), i2 = true;
  }, p(t19, [n3]) {
    const i3 = {};
    1 & n3 && (i3.item = t19[0]), e2.$set(i3);
    const r2 = {};
    1 & n3 && (r2.item = t19[0]), o2.$set(r2);
  }, i(t19) {
    i2 || (transition_in(e2.$$.fragment, t19), transition_in(o2.$$.fragment, t19), i2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), transition_out(o2.$$.fragment, t19), i2 = false;
  }, d(t19) {
    t19 && detach(n2), destroy_component(e2, t19), destroy_component(o2, t19);
  } };
}
function instance$1Z(t18, e2, n2) {
  let { item: o2 } = e2;
  return t18.$$set = (t19) => {
    "item" in t19 && n2(0, o2 = t19.item);
  }, [o2];
}
class ObjectDetails extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1Z, create_fragment$1Y, safe_not_equal, { item: 0 });
  }
}
function create_if_block_3$7(t18) {
  let e2, n2;
  return e2 = new DeleteDialog({ props: { item: t18[0] } }), e2.$on("close", t18[10]), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1 & n3 && (o2.item = t19[0]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_if_block_2$b(t18) {
  let e2, n2, o2;
  return { c() {
    e2 = element("span"), attr(e2, "class", "overlay equipped svelte-mobile-companion-a5e-038vch56tr3-1x3yeeg");
  }, m(t19, n3) {
    insert(t19, e2, n3), o2 = true;
  }, i(t19) {
    o2 || (t19 && add_render_callback(() => {
      o2 && (n2 || (n2 = create_bidirectional_transition(e2, slide, { axis: "x", easing: circOut }, true)), n2.run(1));
    }), o2 = true);
  }, o(t19) {
    t19 && (n2 || (n2 = create_bidirectional_transition(e2, slide, { axis: "x", easing: circOut }, false)), n2.run(0)), o2 = false;
  }, d(t19) {
    t19 && detach(e2), t19 && n2 && n2.end();
  } };
}
function create_overlay_slot$1(t18) {
  let e2, n2 = t18[2].equippedState === EquippedState.EQUIPPED && create_if_block_2$b();
  return { c() {
    e2 = element("div"), n2 && n2.c(), attr(e2, "slot", "overlay");
  }, m(t19, o2) {
    insert(t19, e2, o2), n2 && n2.m(e2, null);
  }, p(t19, o2) {
    t19[2].equippedState === EquippedState.EQUIPPED ? n2 ? 4 & o2 && transition_in(n2, 1) : (n2 = create_if_block_2$b(), n2.c(), transition_in(n2, 1), n2.m(e2, null)) : n2 && (group_outros(), transition_out(n2, 1, 1, () => {
      n2 = null;
    }), check_outros());
  }, d(t19) {
    t19 && detach(e2), n2 && n2.d();
  } };
}
function create_right_content_slot$5(t18) {
  let e2, n2, o2, i2, r2, a2, s2;
  return o2 = new ObjectStatesDisplay({ props: { item: t18[0] } }), a2 = new Quantity({ props: { quantity: t18[2].quantity, fontFamily: "var(--a5e-font-serif)", removeWhenZero: true } }), a2.$on("onQtyChange", t18[6]), a2.$on("remove", t18[7]), { c() {
    e2 = element("div"), n2 = element("div"), create_component(o2.$$.fragment), r2 = space(), create_component(a2.$$.fragment), attr(e2, "class", "item-content svelte-mobile-companion-a5e-038vch56tr3-1x3yeeg"), attr(e2, "slot", "right-content");
  }, m(t19, i3) {
    insert(t19, e2, i3), append(e2, n2), mount_component(o2, n2, null), append(e2, r2), mount_component(a2, e2, null), s2 = true;
  }, p(t19, e3) {
    const n3 = {};
    1 & e3 && (n3.item = t19[0]), o2.$set(n3);
    const i3 = {};
    4 & e3 && (i3.quantity = t19[2].quantity), a2.$set(i3);
  }, i(t19) {
    s2 || (transition_in(o2.$$.fragment, t19), t19 && add_render_callback(() => {
      s2 && (i2 || (i2 = create_bidirectional_transition(n2, fade, { duration: 200 }, true)), i2.run(1));
    }), transition_in(a2.$$.fragment, t19), s2 = true);
  }, o(t19) {
    transition_out(o2.$$.fragment, t19), t19 && (i2 || (i2 = create_bidirectional_transition(n2, fade, { duration: 200 }, false)), i2.run(0)), transition_out(a2.$$.fragment, t19), s2 = false;
  }, d(t19) {
    t19 && detach(e2), destroy_component(o2), t19 && i2 && i2.end(), destroy_component(a2);
  } };
}
function create_if_block_1$k(t18) {
  let e2, n2;
  return e2 = new ObjectUse({ props: { item: t18[0] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1 & n3 && (o2.item = t19[0]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_if_block$12(t18) {
  let e2, n2;
  return e2 = new ItemTransfer({ props: { actor: t18[1], item: t18[0] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    2 & n3 && (o2.actor = t19[1]), 1 & n3 && (o2.item = t19[0]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_details_slot$6(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2 = isFull();
  n2 = new ObjectStateToggles({ props: { item: t18[0] } });
  let l2 = t18[2].uses?.max && create_if_block_1$k(t18);
  r2 = new ObjectDetails({ props: { item: t18[0] } });
  let u2 = c2 && create_if_block$12(t18);
  return { c() {
    e2 = element("div"), create_component(n2.$$.fragment), o2 = space(), l2 && l2.c(), i2 = space(), create_component(r2.$$.fragment), a2 = space(), u2 && u2.c(), attr(e2, "slot", "details");
  }, m(t19, c3) {
    insert(t19, e2, c3), mount_component(n2, e2, null), append(e2, o2), l2 && l2.m(e2, null), append(e2, i2), mount_component(r2, e2, null), append(e2, a2), u2 && u2.m(e2, null), s2 = true;
  }, p(t19, o3) {
    const a3 = {};
    1 & o3 && (a3.item = t19[0]), n2.$set(a3), t19[2].uses?.max ? l2 ? (l2.p(t19, o3), 4 & o3 && transition_in(l2, 1)) : (l2 = create_if_block_1$k(t19), l2.c(), transition_in(l2, 1), l2.m(e2, i2)) : l2 && (group_outros(), transition_out(l2, 1, 1, () => {
      l2 = null;
    }), check_outros());
    const s3 = {};
    1 & o3 && (s3.item = t19[0]), r2.$set(s3), 16 & o3 && (c2 = isFull()), c2 ? u2 ? (u2.p(t19, o3), 16 & o3 && transition_in(u2, 1)) : (u2 = create_if_block$12(t19), u2.c(), transition_in(u2, 1), u2.m(e2, null)) : u2 && (group_outros(), transition_out(u2, 1, 1, () => {
      u2 = null;
    }), check_outros());
  }, i(t19) {
    s2 || (transition_in(n2.$$.fragment, t19), transition_in(l2), transition_in(r2.$$.fragment, t19), transition_in(u2), s2 = true);
  }, o(t19) {
    transition_out(n2.$$.fragment, t19), transition_out(l2), transition_out(r2.$$.fragment, t19), transition_out(u2), s2 = false;
  }, d(t19) {
    t19 && detach(e2), destroy_component(n2), l2 && l2.d(), destroy_component(r2), u2 && u2.d();
  } };
}
function create_fragment$1X(t18) {
  let e2, n2, o2, i2 = t18[5] && create_if_block_3$7(t18);
  return n2 = new ToggleableListEntry({ props: { name: t18[3], imageSrc: t18[0].img, isFavorite: t18[2].favorite, $$slots: { details: [create_details_slot$6], "right-content": [create_right_content_slot$5], overlay: [create_overlay_slot$1] }, $$scope: { ctx: t18 } } }), { c() {
    i2 && i2.c(), e2 = space(), create_component(n2.$$.fragment);
  }, m(t19, r2) {
    i2 && i2.m(t19, r2), insert(t19, e2, r2), mount_component(n2, t19, r2), o2 = true;
  }, p(t19, [o3]) {
    t19[5] ? i2 ? (i2.p(t19, o3), 32 & o3 && transition_in(i2, 1)) : (i2 = create_if_block_3$7(t19), i2.c(), transition_in(i2, 1), i2.m(e2.parentNode, e2)) : i2 && (group_outros(), transition_out(i2, 1, 1, () => {
      i2 = null;
    }), check_outros());
    const r2 = {};
    8 & o3 && (r2.name = t19[3]), 1 & o3 && (r2.imageSrc = t19[0].img), 4 & o3 && (r2.isFavorite = t19[2].favorite), 8215 & o3 && (r2.$$scope = { dirty: o3, ctx: t19 }), n2.$set(r2);
  }, i(t19) {
    o2 || (transition_in(i2), transition_in(n2.$$.fragment, t19), o2 = true);
  }, o(t19) {
    transition_out(i2), transition_out(n2.$$.fragment, t19), o2 = false;
  }, d(t19) {
    t19 && detach(e2), i2 && i2.d(t19), destroy_component(n2, t19);
  } };
}
function instance$1Y(t18, e2, n2) {
  let o2;
  var i2, r2;
  let { item: a2 } = e2, { actor: s2 } = e2;
  const c2 = CONFIG.A5E;
  let l2, u2;
  const p2 = mobileCompanionGameSettings.getWritableStore(USE_CONTAINER).subscribe((t19) => {
    n2(4, u2 = t19);
  });
  onDestroy(() => {
    p2();
  });
  let d2 = false;
  return t18.$$set = (t19) => {
    "item" in t19 && n2(0, a2 = t19.item), "actor" in t19 && n2(1, s2 = t19.actor);
  }, t18.$$.update = () => {
    if (1 & t18.$$.dirty && n2(2, o2 = a2.system), 773 & t18.$$.dirty && (n2(3, l2 = a2.name), o2.unidentified)) {
      const t19 = null !== n2(8, i2 = c2.objectTypes[o2.objectType]) && void 0 !== i2 ? i2 : i18n("TYPES.Item.object");
      n2(3, l2 = 0 !== (null === n2(9, r2 = o2.unidentifiedName) || void 0 === r2 ? void 0 : r2.length) ? o2.unidentifiedName : i18n("A5E.objects.unidentified") + " " + t19);
    }
  }, [a2, s2, o2, l2, u2, d2, function(t19) {
    const e3 = { system: { quantity: t19.detail.newValue } };
    a2.update(e3);
  }, function() {
    n2(5, d2 = true);
  }, i2, r2, () => n2(5, d2 = false)];
}
let Object$1 = class extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1Y, create_fragment$1X, safe_not_equal, { item: 0, actor: 1 });
  }
};
function create_if_block$11(t18) {
  let e2, n2;
  return { c() {
    e2 = element("h2"), n2 = text(t18[0]), attr(e2, "class", "roboto-condensed-upper svelte-mobile-companion-a5e-038vch56tr3-18zxjod");
  }, m(t19, o2) {
    insert(t19, e2, o2), append(e2, n2);
  }, p(t19, e3) {
    1 & e3 && set_data(n2, t19[0]);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_default_slot$l(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, m2, f2, h2, g2, _, $2, b2, y2, v2, w2, S2, T2, k2, x2, E, O2, A2, C2 = t18[0] && create_if_block$11(t18);
  function M(e3) {
    t18[9](e3);
  }
  let I2 = { styleClass: "global-number-input-with-button-value" };
  return void 0 !== t18[1] && (I2.value = t18[1]), p2 = new EvaluatingInput({ props: I2 }), binding_callbacks.push(() => bind(p2, "value", M)), { c() {
    e2 = element("div"), C2 && C2.c(), n2 = space(), o2 = element("div"), i2 = element("div"), r2 = element("button"), r2.innerHTML = '<i class="fa-solid fa-minus"></i>', a2 = space(), s2 = element("button"), s2.innerHTML = '<i class="fa-solid fa-minus"></i> <i class="fa-solid fa-minus"></i>', c2 = space(), l2 = element("button"), l2.innerHTML = '<i class="fa-solid fa-minus"></i> <i class="fa-solid fa-minus"></i> <i class="fa-solid fa-minus"></i>', u2 = space(), create_component(p2.$$.fragment), m2 = space(), f2 = element("div"), h2 = element("button"), h2.innerHTML = '<i class="fa-solid fa-plus"></i>', g2 = space(), _ = element("button"), _.innerHTML = '<i class="fa-solid fa-plus"></i> <i class="fa-solid fa-plus"></i>', $2 = space(), b2 = element("button"), b2.innerHTML = '<i class="fa-solid fa-plus"></i> <i class="fa-solid fa-plus"></i> <i class="fa-solid fa-plus"></i>', y2 = space(), v2 = element("div"), w2 = element("button"), w2.textContent = `${myi18n("Input.Change")}`, S2 = space(), T2 = element("p"), T2.textContent = "- OR -", k2 = space(), x2 = element("button"), x2.textContent = `${myi18n("Input.Set")}`, attr(i2, "class", "vertical"), attr(f2, "class", "vertical"), attr(o2, "class", "input-group svelte-mobile-companion-a5e-038vch56tr3-18zxjod"), attr(w2, "class", "roboto-condensed-upper"), attr(x2, "class", "roboto-condensed-upper"), attr(v2, "class", "change-or-set svelte-mobile-companion-a5e-038vch56tr3-18zxjod"), attr(e2, "class", "modal-content svelte-mobile-companion-a5e-038vch56tr3-18zxjod");
  }, m(d3, M2) {
    insert(d3, e2, M2), C2 && C2.m(e2, null), append(e2, n2), append(e2, o2), append(o2, i2), append(i2, r2), append(i2, a2), append(i2, s2), append(i2, c2), append(i2, l2), append(o2, u2), mount_component(p2, o2, null), append(o2, m2), append(o2, f2), append(f2, h2), append(f2, g2), append(f2, _), append(f2, $2), append(f2, b2), append(e2, y2), append(e2, v2), append(v2, w2), append(v2, S2), append(v2, T2), append(v2, k2), append(v2, x2), E = true, O2 || (A2 = [listen(r2, "click", t18[6]), listen(s2, "click", t18[7]), listen(l2, "click", t18[8]), listen(h2, "click", t18[10]), listen(_, "click", t18[11]), listen(b2, "click", t18[12]), listen(w2, "click", t18[13]), listen(x2, "click", t18[14])], O2 = true);
  }, p(t19, o3) {
    t19[0] ? C2 ? C2.p(t19, o3) : (C2 = create_if_block$11(t19), C2.c(), C2.m(e2, n2)) : C2 && (C2.d(1), C2 = null);
    const i3 = {};
    !d2 && 2 & o3 && (d2 = true, i3.value = t19[1], add_flush_callback(() => d2 = false)), p2.$set(i3);
  }, i(t19) {
    E || (transition_in(p2.$$.fragment, t19), E = true);
  }, o(t19) {
    transition_out(p2.$$.fragment, t19), E = false;
  }, d(t19) {
    t19 && detach(e2), C2 && C2.d(), destroy_component(p2), O2 = false, run_all(A2);
  } };
}
function create_fragment$1W(t18) {
  let e2, n2;
  return e2 = new GenericModal({ props: { $$slots: { default: [create_default_slot$l] }, $$scope: { ctx: t18 } } }), e2.$on("close", t18[5]), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, [n3]) {
    const o2 = {};
    65539 & n3 && (o2.$$scope = { dirty: n3, ctx: t19 }), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function instance$1X(t18, e2, n2) {
  let { title: o2 } = e2;
  const i2 = createEventDispatcher();
  let r2 = 0;
  function a2(t19 = 1) {
    n2(1, r2 += t19);
  }
  function s2(t19 = 1) {
    n2(1, r2 -= t19);
  }
  function c2(t19) {
    i2("saveValue", { action: t19, value: r2 });
  }
  return t18.$$set = (t19) => {
    "title" in t19 && n2(0, o2 = t19.title);
  }, [o2, r2, a2, s2, c2, function() {
    i2("close");
  }, () => s2(), () => s2(10), () => s2(100), function(t19) {
    r2 = t19, n2(1, r2);
  }, () => a2(), () => a2(10), () => a2(100), () => c2("add"), () => c2("set")];
}
class NumberInputWithButtons extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1X, create_fragment$1W, safe_not_equal, { title: 0 });
  }
}
function create_if_block$10(t18) {
  let e2, n2;
  return e2 = new NumberInputWithButtons({ props: { title: t18[3] } }), e2.$on("close", t18[6]), e2.$on("saveValue", function() {
    is_function(t18[2]) && t18[2].apply(this, arguments);
  }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(n3, o2) {
    t18 = n3;
    const i2 = {};
    8 & o2 && (i2.title = t18[3]), e2.$set(i2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_fragment$1V(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, m2, f2, h2, g2, _, $2, b2, y2, v2, w2, S2, T2, k2, x2, E, O2, A2, C2, M, I2, N2, P2, D2, j2 = t18[0].cp + "", F2 = t18[0].sp + "", L2 = t18[0].ep + "", R = t18[0].gp + "", z2 = t18[0].pp + "", H = t18[1] && create_if_block$10(t18);
  return { c() {
    e2 = element("div"), H && H.c(), n2 = space(), o2 = element("ol"), i2 = element("li"), r2 = element("label"), r2.textContent = "cp", a2 = space(), s2 = element("div"), c2 = text(j2), l2 = space(), u2 = element("li"), p2 = element("label"), p2.textContent = "sp", d2 = space(), m2 = element("div"), f2 = text(F2), h2 = space(), g2 = element("li"), _ = element("label"), _.textContent = "ep", $2 = space(), b2 = element("div"), y2 = text(L2), v2 = space(), w2 = element("li"), S2 = element("label"), S2.textContent = "gp", T2 = space(), k2 = element("div"), x2 = text(R), E = space(), O2 = element("li"), A2 = element("label"), A2.textContent = "pp", C2 = space(), M = element("div"), I2 = text(z2), attr(r2, "class", "currency-label svelte-mobile-companion-a5e-038vch56tr3-1asw938"), attr(r2, "for", "currency-cp"), attr(s2, "class", "currency-input svelte-mobile-companion-a5e-038vch56tr3-1asw938"), attr(i2, "class", "currency-item svelte-mobile-companion-a5e-038vch56tr3-1asw938"), attr(i2, "aria-hidden", "true"), attr(p2, "class", "currency-label svelte-mobile-companion-a5e-038vch56tr3-1asw938"), attr(p2, "for", "currency-sp"), attr(m2, "class", "currency-input svelte-mobile-companion-a5e-038vch56tr3-1asw938"), attr(u2, "class", "currency-item svelte-mobile-companion-a5e-038vch56tr3-1asw938"), attr(u2, "aria-hidden", "true"), attr(_, "class", "currency-label svelte-mobile-companion-a5e-038vch56tr3-1asw938"), attr(_, "for", "currency-ep"), attr(b2, "class", "currency-input svelte-mobile-companion-a5e-038vch56tr3-1asw938"), attr(g2, "class", "currency-item svelte-mobile-companion-a5e-038vch56tr3-1asw938"), attr(g2, "aria-hidden", "true"), attr(S2, "class", "currency-label svelte-mobile-companion-a5e-038vch56tr3-1asw938"), attr(S2, "for", "currency-gp"), attr(k2, "class", "currency-input svelte-mobile-companion-a5e-038vch56tr3-1asw938"), attr(w2, "class", "currency-item svelte-mobile-companion-a5e-038vch56tr3-1asw938"), attr(w2, "aria-hidden", "true"), attr(A2, "class", "currency-label svelte-mobile-companion-a5e-038vch56tr3-1asw938"), attr(A2, "for", "currency-pp"), attr(M, "class", "currency-input svelte-mobile-companion-a5e-038vch56tr3-1asw938"), attr(O2, "class", "currency-item svelte-mobile-companion-a5e-038vch56tr3-1asw938"), attr(O2, "aria-hidden", "true"), attr(o2, "class", "currency-list svelte-mobile-companion-a5e-038vch56tr3-1asw938");
  }, m(j3, F3) {
    insert(j3, e2, F3), H && H.m(e2, null), insert(j3, n2, F3), insert(j3, o2, F3), append(o2, i2), append(i2, r2), append(i2, a2), append(i2, s2), append(s2, c2), append(o2, l2), append(o2, u2), append(u2, p2), append(u2, d2), append(u2, m2), append(m2, f2), append(o2, h2), append(o2, g2), append(g2, _), append(g2, $2), append(g2, b2), append(b2, y2), append(o2, v2), append(o2, w2), append(w2, S2), append(w2, T2), append(w2, k2), append(k2, x2), append(w2, E), append(o2, O2), append(O2, A2), append(O2, C2), append(O2, M), append(M, I2), N2 = true, P2 || (D2 = [listen(i2, "click", t18[7]), listen(u2, "click", t18[8]), listen(g2, "click", t18[9]), listen(w2, "click", t18[10]), listen(O2, "click", t18[11])], P2 = true);
  }, p(t19, [n3]) {
    t19[1] ? H ? (H.p(t19, n3), 2 & n3 && transition_in(H, 1)) : (H = create_if_block$10(t19), H.c(), transition_in(H, 1), H.m(e2, null)) : H && (group_outros(), transition_out(H, 1, 1, () => {
      H = null;
    }), check_outros()), (!N2 || 1 & n3) && j2 !== (j2 = t19[0].cp + "") && set_data(c2, j2), (!N2 || 1 & n3) && F2 !== (F2 = t19[0].sp + "") && set_data(f2, F2), (!N2 || 1 & n3) && L2 !== (L2 = t19[0].ep + "") && set_data(y2, L2), (!N2 || 1 & n3) && R !== (R = t19[0].gp + "") && set_data(x2, R), (!N2 || 1 & n3) && z2 !== (z2 = t19[0].pp + "") && set_data(I2, z2);
  }, i(t19) {
    N2 || (transition_in(H), N2 = true);
  }, o(t19) {
    transition_out(H), N2 = false;
  }, d(t19) {
    t19 && (detach(e2), detach(n2), detach(o2)), H && H.d(), P2 = false, run_all(D2);
  } };
}
function instance$1W(t18, e2, n2) {
  let { actor: o2 } = e2, i2 = o2.system.currency;
  function r2(t19, e3) {
    n2(0, i2[e3] = t19, i2), o2.update({ system: { currency: i2 } });
  }
  let a2, s2, c2 = false;
  function l2(t19) {
    isReadOnlyActor(o2) || (n2(1, c2 = true), n2(3, s2 = i18n("A5E.effects.keys.currency." + t19)), n2(2, a2 = (e3) => {
      let o3 = e3.detail.value;
      "add" === e3.detail.action && (o3 += i2[t19]), r2(o3, t19), n2(1, c2 = false);
    }));
  }
  return t18.$$set = (t19) => {
    "actor" in t19 && n2(5, o2 = t19.actor);
  }, t18.$$.update = () => {
    32 & t18.$$.dirty && n2(0, i2 = o2.system.currency);
  }, [i2, c2, a2, s2, l2, o2, () => n2(1, c2 = false), () => l2("cp"), () => l2("sp"), () => l2("ep"), () => l2("gp"), () => l2("pp")];
}
class Currency extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1W, create_fragment$1V, safe_not_equal, { actor: 5 });
  }
}
function a5eCalculateCarryCapacity(t18) {
  const e2 = t18.system.abilities.str.value, n2 = t18.system.traits.size || "med";
  return e2 * CONFIG.A5E.carryCapacityMultiplier[n2 || "med"] * (t18.flags.a5e?.doubleCarryCapacity ? 2 : 1) * 15;
}
function a5eCalculateInventoryWeight(t18) {
  const { EQUIPPED_STATES: e2 } = CONFIG.A5E, n2 = t18.system, o2 = t18.items.map((t19) => t19), i2 = o2.reduce((t19, n3) => {
    let i3 = null;
    const r3 = n3.system;
    if (r3.containerId && (i3 = o2.find((t20) => t20.uuid === r3.containerId), !i3)) return t19;
    if (![e2.EQUIPPED, e2.CARRIED].includes(r3.equippedState) && !i3) return t19;
    if (i3 && i3.system.equippedState === e2.NOT_CARRIED) return t19;
    const { quantity: a3 } = r3, s2 = parseFloat(r3.weight || 0, 10) ?? 0;
    return t19 + (a3 ? s2 * a3 : s2);
  }, 0), r2 = Object.values(n2.currency).reduce((t19, e3) => t19 + Number(e3), 0), a2 = 2 * Math.abs(Math.min(n2.abilities.str.value - (n2.supply ?? 0), 0));
  return t18.flags?.a5e?.trackCurrencyWeight ?? game.settings.get(getFullModuleId$1(), USE_CURRENCY_WEIGHT) ? i2 + a2 + 0.02 * r2 : i2 + a2;
}
function create_if_block$$(t18) {
  let e2;
  return { c() {
    e2 = element("span"), e2.textContent = `${i18n("A5E.conditions.encumbered")}`;
  }, m(t19, n2) {
    insert(t19, e2, n2);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_fragment$1U(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, m2, f2 = t18[0]?.toFixed(1) + "", h2 = i18n("A5E.objects.weightLbs") + "", g2 = i18n("A5E.objects.weightLbs") + "", _ = 100 === t18[2] && create_if_block$$();
  return { c() {
    e2 = element("div"), n2 = element("div"), o2 = element("div"), i2 = element("span"), r2 = text(f2), a2 = space(), s2 = text(h2), c2 = text("\r\n            /\r\n            "), l2 = element("span"), u2 = text(t18[1]), p2 = space(), d2 = text(g2), m2 = space(), _ && _.c(), attr(o2, "class", "weight-text svelte-mobile-companion-a5e-038vch56tr3-1d8nqfm"), attr(n2, "class", "weight-bar svelte-mobile-companion-a5e-038vch56tr3-1d8nqfm"), set_style(n2, "background-color", 100 === t18[2] ? "#b40a0a" : "#0b5a2f"), set_style(n2, "width", `${t18[2]}%`), attr(e2, "class", "weight-container svelte-mobile-companion-a5e-038vch56tr3-1d8nqfm"), set_style(e2, "background-color", "#a9a594");
  }, m(t19, f3) {
    insert(t19, e2, f3), append(e2, n2), append(n2, o2), append(o2, i2), append(i2, r2), append(i2, a2), append(i2, s2), append(o2, c2), append(o2, l2), append(l2, u2), append(l2, p2), append(l2, d2), append(o2, m2), _ && _.m(o2, null);
  }, p(t19, [e3]) {
    1 & e3 && f2 !== (f2 = t19[0]?.toFixed(1) + "") && set_data(r2, f2), 2 & e3 && set_data(u2, t19[1]), 100 === t19[2] ? _ || (_ = create_if_block$$(), _.c(), _.m(o2, null)) : _ && (_.d(1), _ = null), 4 & e3 && set_style(n2, "background-color", 100 === t19[2] ? "#b40a0a" : "#0b5a2f"), 4 & e3 && set_style(n2, "width", `${t19[2]}%`);
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2), _ && _.d();
  } };
}
function instance$1V(t18, e2, n2) {
  var o2;
  let i2, r2, a2, { actor: s2 } = e2, { selectedContainer: c2 } = e2;
  return t18.$$set = (t19) => {
    "actor" in t19 && n2(3, s2 = t19.actor), "selectedContainer" in t19 && n2(4, c2 = t19.selectedContainer);
  }, t18.$$.update = () => {
    if (59 & t18.$$.dirty) if (c2) {
      const t19 = s2.itemTypes.object.find((t20) => t20.system.objectType === ObjectType.Container && t20.id === c2);
      t19.containerItems ? (n2(0, i2 = t19.containerItems.weight), n2(1, r2 = null === n2(5, o2 = t19.system.capacity) || void 0 === o2 ? void 0 : o2.value), n2(2, a2 = r2 > 0 ? Math.min(i2 / r2 * 100, 100) : 0)) : console.error("Selected container does not have object 'containerItems'", c2);
    } else n2(0, i2 = a5eCalculateInventoryWeight(s2)), n2(1, r2 = a5eCalculateCarryCapacity(s2)), n2(2, a2 = Math.min(i2 / r2 * 100, 100));
  }, [i2, r2, a2, s2, c2, o2];
}
class Weight extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1V, create_fragment$1U, safe_not_equal, { actor: 3, selectedContainer: 4 });
  }
}
function create_if_block$_(t18) {
  let e2, n2;
  return e2 = new NumberInputWithButtons({ props: { title: t18[5] } }), e2.$on("close", t18[9]), e2.$on("saveValue", t18[4]), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p: noop$4, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_fragment$1T(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, m2, f2, h2, g2, _, $2, b2, y2, v2, w2, S2, T2, k2, x2 = t18[0] && create_if_block$_(t18);
  return { c() {
    e2 = element("div"), x2 && x2.c(), n2 = space(), o2 = element("ol"), i2 = element("li"), r2 = element("h3"), r2.textContent = "Attunement", a2 = space(), s2 = element("span"), c2 = text(t18[3]), l2 = text(" / "), u2 = element("span"), u2.textContent = "3", p2 = space(), d2 = element("li"), m2 = element("h3"), m2.textContent = "Bulky Items", f2 = space(), h2 = element("span"), g2 = text(t18[2]), _ = space(), $2 = element("li"), b2 = element("h3"), b2.textContent = "Supplies", y2 = space(), v2 = element("div"), w2 = text(t18[1]), attr(r2, "class", "additional-inventory-info-header svelte-mobile-companion-a5e-038vch56tr3-oz9a1u"), attr(s2, "class", "attunement-value svelte-mobile-companion-a5e-038vch56tr3-oz9a1u"), set_style(s2, "background-color", t18[3] > 3 ? "#b40a0a" : ""), attr(u2, "class", "attunement-value svelte-mobile-companion-a5e-038vch56tr3-oz9a1u"), attr(i2, "class", "additional-inventory-info-container svelte-mobile-companion-a5e-038vch56tr3-oz9a1u"), attr(m2, "class", "additional-inventory-info-header svelte-mobile-companion-a5e-038vch56tr3-oz9a1u"), attr(h2, "class", "bulky-value svelte-mobile-companion-a5e-038vch56tr3-oz9a1u"), attr(d2, "class", "additional-inventory-info-container svelte-mobile-companion-a5e-038vch56tr3-oz9a1u"), attr(b2, "class", "additional-inventory-info-header svelte-mobile-companion-a5e-038vch56tr3-oz9a1u"), attr(v2, "class", "supply-input svelte-mobile-companion-a5e-038vch56tr3-oz9a1u"), attr($2, "class", "additional-inventory-info-container svelte-mobile-companion-a5e-038vch56tr3-oz9a1u"), attr($2, "aria-hidden", "true"), attr(o2, "class", "svelte-mobile-companion-a5e-038vch56tr3-oz9a1u");
  }, m(E, O2) {
    insert(E, e2, O2), x2 && x2.m(e2, null), insert(E, n2, O2), insert(E, o2, O2), append(o2, i2), append(i2, r2), append(i2, a2), append(i2, s2), append(s2, c2), append(i2, l2), append(i2, u2), append(o2, p2), append(o2, d2), append(d2, m2), append(d2, f2), append(d2, h2), append(h2, g2), append(o2, _), append(o2, $2), append($2, b2), append($2, y2), append($2, v2), append(v2, w2), S2 = true, T2 || (k2 = listen($2, "click", t18[10]), T2 = true);
  }, p(t19, [n3]) {
    t19[0] ? x2 ? (x2.p(t19, n3), 1 & n3 && transition_in(x2, 1)) : (x2 = create_if_block$_(t19), x2.c(), transition_in(x2, 1), x2.m(e2, null)) : x2 && (group_outros(), transition_out(x2, 1, 1, () => {
      x2 = null;
    }), check_outros()), (!S2 || 8 & n3) && set_data(c2, t19[3]), 8 & n3 && set_style(s2, "background-color", t19[3] > 3 ? "#b40a0a" : ""), (!S2 || 4 & n3) && set_data(g2, t19[2]), (!S2 || 2 & n3) && set_data(w2, t19[1]);
  }, i(t19) {
    S2 || (transition_in(x2), S2 = true);
  }, o(t19) {
    transition_out(x2), S2 = false;
  }, d(t19) {
    t19 && (detach(e2), detach(n2), detach(o2)), x2 && x2.d(), T2 = false, k2();
  } };
}
function instance$1U(t18, e2, n2) {
  let o2, i2, r2;
  var a2;
  let { actor: s2 } = e2;
  let c2 = false, l2 = i18n("A5E.effects.keys.supply");
  function u2() {
    isReadOnlyActor(s2) || n2(0, c2 = true);
  }
  return t18.$$set = (t19) => {
    "actor" in t19 && n2(7, s2 = t19.actor);
  }, t18.$$.update = () => {
    128 & t18.$$.dirty && n2(3, o2 = s2.itemTypes.object.reduce((t19, e3) => e3.system.attuned ? t19 + 1 : t19, 0)), 128 & t18.$$.dirty && n2(2, i2 = s2.itemTypes.object.reduce((t19, e3) => {
      const n3 = e3.system;
      return n3.bulky && n3.equippedState >= EquippedState.CARRIED ? t19 + n3.quantity : t19;
    }, 0)), 384 & t18.$$.dirty && n2(1, r2 = null !== n2(8, a2 = s2.system.supply) && void 0 !== a2 ? a2 : 0);
  }, [c2, r2, i2, o2, function(t19) {
    let e3 = t19.detail.value;
    "add" === t19.detail.action && (e3 += r2), s2.update({ system: { supply: e3 } }), n2(0, c2 = false);
  }, l2, u2, s2, a2, () => n2(0, c2 = false), () => u2()];
}
class AdditionalInventoryInfo extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1U, create_fragment$1T, safe_not_equal, { actor: 7 });
  }
}
function get_each_context$D(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[6] = e2[n2], o2;
}
function create_if_block$Z(t18) {
  let e2;
  return { c() {
    e2 = element("div"), e2.innerHTML = "<p>Pro version</p>", attr(e2, "class", "overlay svelte-mobile-companion-a5e-038vch56tr3-1lk33mc");
  }, m(t19, n2) {
    insert(t19, e2, n2);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_each_block$D(t18, e2) {
  let n2, o2, i2, r2, a2, s2, c2, l2, u2 = create_if_block$Z();
  function p2() {
    return e2[4](e2[6]);
  }
  return { key: t18, first: null, c() {
    n2 = element("button"), o2 = element("img"), a2 = space(), u2 && u2.c(), s2 = space(), src_url_equal(o2.src, i2 = imageCache.getImage(e2[6].img)) || attr(o2, "src", i2), attr(o2, "alt", r2 = e2[6].name), attr(o2, "class", "svelte-mobile-companion-a5e-038vch56tr3-1lk33mc"), attr(n2, "class", "image-container no-hover-focus-effect svelte-mobile-companion-a5e-038vch56tr3-1lk33mc"), toggle_class(n2, "active", e2[0] === e2[6].id), this.first = n2;
  }, m(t19, e3) {
    insert(t19, n2, e3), append(n2, o2), append(n2, a2), u2 && u2.m(n2, null), append(n2, s2), c2 || (l2 = listen(n2, "click", p2), c2 = true);
  }, p(t19, a3) {
    e2 = t19, 2 & a3 && !src_url_equal(o2.src, i2 = imageCache.getImage(e2[6].img)) && attr(o2, "src", i2), 2 & a3 && r2 !== (r2 = e2[6].name) && attr(o2, "alt", r2), 3 & a3 && toggle_class(n2, "active", e2[0] === e2[6].id);
  }, d(t19) {
    t19 && detach(n2), u2 && u2.d(), c2 = false, l2();
  } };
}
function create_fragment$1S(t18) {
  let e2, n2 = [], o2 = /* @__PURE__ */ new Map(), i2 = ensure_array_like(t18[1]);
  const r2 = (t19) => t19[6].id;
  for (let e3 = 0; e3 < i2.length; e3 += 1) {
    let a2 = get_each_context$D(t18, i2, e3), s2 = r2(a2);
    o2.set(s2, n2[e3] = create_each_block$D(s2, a2));
  }
  return { c() {
    e2 = element("section");
    for (let t19 = 0; t19 < n2.length; t19 += 1) n2[t19].c();
    attr(e2, "class", "svelte-mobile-companion-a5e-038vch56tr3-1lk33mc");
  }, m(t19, o3) {
    insert(t19, e2, o3);
    for (let t20 = 0; t20 < n2.length; t20 += 1) n2[t20] && n2[t20].m(e2, null);
  }, p(t19, [a2]) {
    7 & a2 && (i2 = ensure_array_like(t19[1]), n2 = update_keyed_each(n2, a2, r2, 1, t19, i2, o2, e2, destroy_block, create_each_block$D, null, get_each_context$D));
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2);
    for (let t20 = 0; t20 < n2.length; t20 += 1) n2[t20].d();
  } };
}
function instance$1T(t18, e2, n2) {
  let o2, { actor: i2 } = e2;
  function r2(t19) {
  }
  createEventDispatcher();
  return t18.$$set = (t19) => {
    "actor" in t19 && n2(3, i2 = t19.actor);
  }, t18.$$.update = () => {
    8 & t18.$$.dirty && n2(1, o2 = i2.itemTypes.object.filter((t19) => "container" === t19.system.objectType));
  }, [void 0, o2, r2, i2, (t19) => {
    t19.id;
  }];
}
class Container extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1T, create_fragment$1S, safe_not_equal, { actor: 3 });
  }
}
const get_header_addons_slot_changes$1 = (t18) => ({}), get_header_addons_slot_context$1 = (t18) => ({});
function create_fragment$1R(t18) {
  let e2, n2, o2, i2, r2, a2;
  const s2 = t18[3]["header-addons"], c2 = create_slot(s2, t18, t18[2], get_header_addons_slot_context$1);
  return { c() {
    e2 = element("header"), n2 = element("span"), o2 = text(t18[0]), i2 = space(), c2 && c2.c(), attr(n2, "class", "svelte-mobile-companion-a5e-038vch56tr3-1k4lyrc"), attr(e2, "class", "header svelte-mobile-companion-a5e-038vch56tr3-1k4lyrc"), attr(e2, "style", r2 = t18[1].join(" "));
  }, m(t19, r3) {
    insert(t19, e2, r3), append(e2, n2), append(n2, o2), append(e2, i2), c2 && c2.m(e2, null), a2 = true;
  }, p(t19, [n3]) {
    (!a2 || 1 & n3) && set_data(o2, t19[0]), c2 && c2.p && (!a2 || 4 & n3) && update_slot_base(c2, s2, t19, t19[2], a2 ? get_slot_changes(s2, t19[2], n3, get_header_addons_slot_changes$1) : get_all_dirty_from_scope(t19[2]), get_header_addons_slot_context$1), (!a2 || 2 & n3 && r2 !== (r2 = t19[1].join(" "))) && attr(e2, "style", r2);
  }, i(t19) {
    a2 || (transition_in(c2, t19), a2 = true);
  }, o(t19) {
    transition_out(c2, t19), a2 = false;
  }, d(t19) {
    t19 && detach(e2), c2 && c2.d(t19);
  } };
}
function instance$1S(t18, e2, n2) {
  let { $$slots: o2 = {}, $$scope: i2 } = e2, { title: r2 } = e2, { styles: a2 = [] } = e2;
  return t18.$$set = (t19) => {
    "title" in t19 && n2(0, r2 = t19.title), "styles" in t19 && n2(1, a2 = t19.styles), "$$scope" in t19 && n2(2, i2 = t19.$$scope);
  }, [r2, a2, i2, o2];
}
class CategoryHeader extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1S, create_fragment$1R, safe_not_equal, { title: 0, styles: 1 });
  }
}
const get_section_content_slot_changes = (t18) => ({}), get_section_content_slot_context = (t18) => ({}), get_header_addons_slot_changes = (t18) => ({}), get_header_addons_slot_context = (t18) => ({ slot: "header-addons" });
function create_header_addons_slot$3(t18) {
  let e2;
  const n2 = t18[1]["header-addons"], o2 = create_slot(n2, t18, t18[2], get_header_addons_slot_context);
  return { c() {
    o2 && o2.c();
  }, m(t19, n3) {
    o2 && o2.m(t19, n3), e2 = true;
  }, p(t19, i2) {
    o2 && o2.p && (!e2 || 4 & i2) && update_slot_base(o2, n2, t19, t19[2], e2 ? get_slot_changes(n2, t19[2], i2, get_header_addons_slot_changes) : get_all_dirty_from_scope(t19[2]), get_header_addons_slot_context);
  }, i(t19) {
    e2 || (transition_in(o2, t19), e2 = true);
  }, o(t19) {
    transition_out(o2, t19), e2 = false;
  }, d(t19) {
    o2 && o2.d(t19);
  } };
}
function create_fragment$1Q(t18) {
  let e2, n2, o2, i2, r2, a2;
  n2 = new CategoryHeader({ props: { title: t18[0], $$slots: { "header-addons": [create_header_addons_slot$3] }, $$scope: { ctx: t18 } } });
  const s2 = t18[1]["section-content"], c2 = create_slot(s2, t18, t18[2], get_section_content_slot_context), l2 = t18[1].default, u2 = create_slot(l2, t18, t18[2], null);
  return { c() {
    e2 = element("section"), create_component(n2.$$.fragment), o2 = space(), i2 = element("ol"), c2 && c2.c(), r2 = space(), u2 && u2.c(), attr(i2, "class", "content svelte-mobile-companion-a5e-038vch56tr3-9a0pyi"), attr(e2, "class", "category");
  }, m(t19, s3) {
    insert(t19, e2, s3), mount_component(n2, e2, null), append(e2, o2), append(e2, i2), c2 && c2.m(i2, null), append(i2, r2), u2 && u2.m(i2, null), a2 = true;
  }, p(t19, [e3]) {
    const o3 = {};
    1 & e3 && (o3.title = t19[0]), 4 & e3 && (o3.$$scope = { dirty: e3, ctx: t19 }), n2.$set(o3), c2 && c2.p && (!a2 || 4 & e3) && update_slot_base(c2, s2, t19, t19[2], a2 ? get_slot_changes(s2, t19[2], e3, get_section_content_slot_changes) : get_all_dirty_from_scope(t19[2]), get_section_content_slot_context), u2 && u2.p && (!a2 || 4 & e3) && update_slot_base(u2, l2, t19, t19[2], a2 ? get_slot_changes(l2, t19[2], e3, null) : get_all_dirty_from_scope(t19[2]), null);
  }, i(t19) {
    a2 || (transition_in(n2.$$.fragment, t19), transition_in(c2, t19), transition_in(u2, t19), a2 = true);
  }, o(t19) {
    transition_out(n2.$$.fragment, t19), transition_out(c2, t19), transition_out(u2, t19), a2 = false;
  }, d(t19) {
    t19 && detach(e2), destroy_component(n2), c2 && c2.d(t19), u2 && u2.d(t19);
  } };
}
function instance$1R(t18, e2, n2) {
  let { $$slots: o2 = {}, $$scope: i2 } = e2, { title: r2 } = e2;
  return t18.$$set = (t19) => {
    "title" in t19 && n2(0, r2 = t19.title), "$$scope" in t19 && n2(2, i2 = t19.$$scope);
  }, [r2, o2, i2];
}
class Category extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1R, create_fragment$1Q, safe_not_equal, { title: 0 });
  }
}
function get_each_context$C(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[32] = e2[n2], o2;
}
function get_each_context_1$1(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[32] = e2[n2], o2;
}
function get_each_context_2(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[32] = e2[n2], o2;
}
function get_each_context_3(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[32] = e2[n2], o2;
}
function get_each_context_4(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[32] = e2[n2], o2;
}
function get_each_context_5(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[32] = e2[n2], o2;
}
function get_each_context_6(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[32] = e2[n2], o2;
}
function get_each_context_7(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[32] = e2[n2], o2;
}
function get_each_context_8(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[32] = e2[n2], o2;
}
function create_if_block_11(t18) {
  let e2, n2;
  return e2 = new Container({ props: { actor: t18[0] } }), e2.$on("onContainerChange", t18[15]), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1 & n3[0] && (o2.actor = t19[0]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_if_block_10(t18) {
  let e2, n2;
  return e2 = new Currency({ props: { actor: t18[0] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1 & n3[0] && (o2.actor = t19[0]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_if_block_9$1(t18) {
  let e2, n2;
  return e2 = new Weight({ props: { actor: t18[0], selectedContainer: t18[1] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1 & n3[0] && (o2.actor = t19[0]), 2 & n3[0] && (o2.selectedContainer = t19[1]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_if_block_8$1(t18) {
  let e2, n2;
  return e2 = new Category({ props: { title: t18[14].objectTypesPlural.weapon, $$slots: { "section-content": [create_section_content_slot_8] }, $$scope: { ctx: t18 } } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    5 & n3[0] | 1048576 & n3[1] && (o2.$$scope = { dirty: n3, ctx: t19 }), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_each_block_8(t18, e2) {
  let n2, o2, i2;
  return o2 = new Object$1({ props: { actor: e2[0], item: e2[32] } }), { key: t18, first: null, c() {
    n2 = empty(), create_component(o2.$$.fragment), this.first = n2;
  }, m(t19, e3) {
    insert(t19, n2, e3), mount_component(o2, t19, e3), i2 = true;
  }, p(t19, n3) {
    e2 = t19;
    const i3 = {};
    1 & n3[0] && (i3.actor = e2[0]), 4 & n3[0] && (i3.item = e2[32]), o2.$set(i3);
  }, i(t19) {
    i2 || (transition_in(o2.$$.fragment, t19), i2 = true);
  }, o(t19) {
    transition_out(o2.$$.fragment, t19), i2 = false;
  }, d(t19) {
    t19 && detach(n2), destroy_component(o2, t19);
  } };
}
function create_section_content_slot_8(t18) {
  let e2, n2, o2 = [], i2 = /* @__PURE__ */ new Map(), r2 = ensure_array_like(t18[2]);
  const a2 = (t19) => t19[32].id;
  for (let e3 = 0; e3 < r2.length; e3 += 1) {
    let n3 = get_each_context_8(t18, r2, e3), s2 = a2(n3);
    i2.set(s2, o2[e3] = create_each_block_8(s2, n3));
  }
  return { c() {
    e2 = element("div");
    for (let t19 = 0; t19 < o2.length; t19 += 1) o2[t19].c();
    attr(e2, "slot", "section-content");
  }, m(t19, i3) {
    insert(t19, e2, i3);
    for (let t20 = 0; t20 < o2.length; t20 += 1) o2[t20] && o2[t20].m(e2, null);
    n2 = true;
  }, p(t19, n3) {
    5 & n3[0] && (r2 = ensure_array_like(t19[2]), group_outros(), o2 = update_keyed_each(o2, n3, a2, 1, t19, r2, i2, e2, outro_and_destroy_block, create_each_block_8, null, get_each_context_8), check_outros());
  }, i(t19) {
    if (!n2) {
      for (let t20 = 0; t20 < r2.length; t20 += 1) transition_in(o2[t20]);
      n2 = true;
    }
  }, o(t19) {
    for (let t20 = 0; t20 < o2.length; t20 += 1) transition_out(o2[t20]);
    n2 = false;
  }, d(t19) {
    t19 && detach(e2);
    for (let t20 = 0; t20 < o2.length; t20 += 1) o2[t20].d();
  } };
}
function create_if_block_7$1(t18) {
  let e2, n2;
  return e2 = new Category({ props: { title: t18[14].objectTypesPlural.armor, $$slots: { "section-content": [create_section_content_slot_7] }, $$scope: { ctx: t18 } } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    9 & n3[0] | 1048576 & n3[1] && (o2.$$scope = { dirty: n3, ctx: t19 }), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_each_block_7(t18, e2) {
  let n2, o2, i2;
  return o2 = new Object$1({ props: { actor: e2[0], item: e2[32] } }), { key: t18, first: null, c() {
    n2 = empty(), create_component(o2.$$.fragment), this.first = n2;
  }, m(t19, e3) {
    insert(t19, n2, e3), mount_component(o2, t19, e3), i2 = true;
  }, p(t19, n3) {
    e2 = t19;
    const i3 = {};
    1 & n3[0] && (i3.actor = e2[0]), 8 & n3[0] && (i3.item = e2[32]), o2.$set(i3);
  }, i(t19) {
    i2 || (transition_in(o2.$$.fragment, t19), i2 = true);
  }, o(t19) {
    transition_out(o2.$$.fragment, t19), i2 = false;
  }, d(t19) {
    t19 && detach(n2), destroy_component(o2, t19);
  } };
}
function create_section_content_slot_7(t18) {
  let e2, n2, o2 = [], i2 = /* @__PURE__ */ new Map(), r2 = ensure_array_like(t18[3]);
  const a2 = (t19) => t19[32].id;
  for (let e3 = 0; e3 < r2.length; e3 += 1) {
    let n3 = get_each_context_7(t18, r2, e3), s2 = a2(n3);
    i2.set(s2, o2[e3] = create_each_block_7(s2, n3));
  }
  return { c() {
    e2 = element("div");
    for (let t19 = 0; t19 < o2.length; t19 += 1) o2[t19].c();
    attr(e2, "slot", "section-content");
  }, m(t19, i3) {
    insert(t19, e2, i3);
    for (let t20 = 0; t20 < o2.length; t20 += 1) o2[t20] && o2[t20].m(e2, null);
    n2 = true;
  }, p(t19, n3) {
    9 & n3[0] && (r2 = ensure_array_like(t19[3]), group_outros(), o2 = update_keyed_each(o2, n3, a2, 1, t19, r2, i2, e2, outro_and_destroy_block, create_each_block_7, null, get_each_context_7), check_outros());
  }, i(t19) {
    if (!n2) {
      for (let t20 = 0; t20 < r2.length; t20 += 1) transition_in(o2[t20]);
      n2 = true;
    }
  }, o(t19) {
    for (let t20 = 0; t20 < o2.length; t20 += 1) transition_out(o2[t20]);
    n2 = false;
  }, d(t19) {
    t19 && detach(e2);
    for (let t20 = 0; t20 < o2.length; t20 += 1) o2[t20].d();
  } };
}
function create_if_block_6$2(t18) {
  let e2, n2;
  return e2 = new Category({ props: { title: t18[14].objectTypesPlural.ammunition, $$slots: { "section-content": [create_section_content_slot_6] }, $$scope: { ctx: t18 } } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    17 & n3[0] | 1048576 & n3[1] && (o2.$$scope = { dirty: n3, ctx: t19 }), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_each_block_6(t18, e2) {
  let n2, o2, i2;
  return o2 = new Object$1({ props: { actor: e2[0], item: e2[32] } }), { key: t18, first: null, c() {
    n2 = empty(), create_component(o2.$$.fragment), this.first = n2;
  }, m(t19, e3) {
    insert(t19, n2, e3), mount_component(o2, t19, e3), i2 = true;
  }, p(t19, n3) {
    e2 = t19;
    const i3 = {};
    1 & n3[0] && (i3.actor = e2[0]), 16 & n3[0] && (i3.item = e2[32]), o2.$set(i3);
  }, i(t19) {
    i2 || (transition_in(o2.$$.fragment, t19), i2 = true);
  }, o(t19) {
    transition_out(o2.$$.fragment, t19), i2 = false;
  }, d(t19) {
    t19 && detach(n2), destroy_component(o2, t19);
  } };
}
function create_section_content_slot_6(t18) {
  let e2, n2, o2 = [], i2 = /* @__PURE__ */ new Map(), r2 = ensure_array_like(t18[4]);
  const a2 = (t19) => t19[32].id;
  for (let e3 = 0; e3 < r2.length; e3 += 1) {
    let n3 = get_each_context_6(t18, r2, e3), s2 = a2(n3);
    i2.set(s2, o2[e3] = create_each_block_6(s2, n3));
  }
  return { c() {
    e2 = element("div");
    for (let t19 = 0; t19 < o2.length; t19 += 1) o2[t19].c();
    attr(e2, "slot", "section-content");
  }, m(t19, i3) {
    insert(t19, e2, i3);
    for (let t20 = 0; t20 < o2.length; t20 += 1) o2[t20] && o2[t20].m(e2, null);
    n2 = true;
  }, p(t19, n3) {
    17 & n3[0] && (r2 = ensure_array_like(t19[4]), group_outros(), o2 = update_keyed_each(o2, n3, a2, 1, t19, r2, i2, e2, outro_and_destroy_block, create_each_block_6, null, get_each_context_6), check_outros());
  }, i(t19) {
    if (!n2) {
      for (let t20 = 0; t20 < r2.length; t20 += 1) transition_in(o2[t20]);
      n2 = true;
    }
  }, o(t19) {
    for (let t20 = 0; t20 < o2.length; t20 += 1) transition_out(o2[t20]);
    n2 = false;
  }, d(t19) {
    t19 && detach(e2);
    for (let t20 = 0; t20 < o2.length; t20 += 1) o2[t20].d();
  } };
}
function create_if_block_5$3(t18) {
  let e2, n2;
  return e2 = new Category({ props: { title: t18[14].objectTypesPlural.consumable, $$slots: { "section-content": [create_section_content_slot_5] }, $$scope: { ctx: t18 } } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    65 & n3[0] | 1048576 & n3[1] && (o2.$$scope = { dirty: n3, ctx: t19 }), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_each_block_5(t18, e2) {
  let n2, o2, i2;
  return o2 = new Object$1({ props: { actor: e2[0], item: e2[32] } }), { key: t18, first: null, c() {
    n2 = empty(), create_component(o2.$$.fragment), this.first = n2;
  }, m(t19, e3) {
    insert(t19, n2, e3), mount_component(o2, t19, e3), i2 = true;
  }, p(t19, n3) {
    e2 = t19;
    const i3 = {};
    1 & n3[0] && (i3.actor = e2[0]), 64 & n3[0] && (i3.item = e2[32]), o2.$set(i3);
  }, i(t19) {
    i2 || (transition_in(o2.$$.fragment, t19), i2 = true);
  }, o(t19) {
    transition_out(o2.$$.fragment, t19), i2 = false;
  }, d(t19) {
    t19 && detach(n2), destroy_component(o2, t19);
  } };
}
function create_section_content_slot_5(t18) {
  let e2, n2, o2 = [], i2 = /* @__PURE__ */ new Map(), r2 = ensure_array_like(t18[6]);
  const a2 = (t19) => t19[32].id;
  for (let e3 = 0; e3 < r2.length; e3 += 1) {
    let n3 = get_each_context_5(t18, r2, e3), s2 = a2(n3);
    i2.set(s2, o2[e3] = create_each_block_5(s2, n3));
  }
  return { c() {
    e2 = element("div");
    for (let t19 = 0; t19 < o2.length; t19 += 1) o2[t19].c();
    attr(e2, "slot", "section-content");
  }, m(t19, i3) {
    insert(t19, e2, i3);
    for (let t20 = 0; t20 < o2.length; t20 += 1) o2[t20] && o2[t20].m(e2, null);
    n2 = true;
  }, p(t19, n3) {
    65 & n3[0] && (r2 = ensure_array_like(t19[6]), group_outros(), o2 = update_keyed_each(o2, n3, a2, 1, t19, r2, i2, e2, outro_and_destroy_block, create_each_block_5, null, get_each_context_5), check_outros());
  }, i(t19) {
    if (!n2) {
      for (let t20 = 0; t20 < r2.length; t20 += 1) transition_in(o2[t20]);
      n2 = true;
    }
  }, o(t19) {
    for (let t20 = 0; t20 < o2.length; t20 += 1) transition_out(o2[t20]);
    n2 = false;
  }, d(t19) {
    t19 && detach(e2);
    for (let t20 = 0; t20 < o2.length; t20 += 1) o2[t20].d();
  } };
}
function create_if_block_4$4(t18) {
  let e2, n2;
  return e2 = new Category({ props: { title: t18[14].objectTypesPlural.tool, $$slots: { "section-content": [create_section_content_slot_4] }, $$scope: { ctx: t18 } } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    129 & n3[0] | 1048576 & n3[1] && (o2.$$scope = { dirty: n3, ctx: t19 }), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_each_block_4(t18, e2) {
  let n2, o2, i2;
  return o2 = new Object$1({ props: { actor: e2[0], item: e2[32] } }), { key: t18, first: null, c() {
    n2 = empty(), create_component(o2.$$.fragment), this.first = n2;
  }, m(t19, e3) {
    insert(t19, n2, e3), mount_component(o2, t19, e3), i2 = true;
  }, p(t19, n3) {
    e2 = t19;
    const i3 = {};
    1 & n3[0] && (i3.actor = e2[0]), 128 & n3[0] && (i3.item = e2[32]), o2.$set(i3);
  }, i(t19) {
    i2 || (transition_in(o2.$$.fragment, t19), i2 = true);
  }, o(t19) {
    transition_out(o2.$$.fragment, t19), i2 = false;
  }, d(t19) {
    t19 && detach(n2), destroy_component(o2, t19);
  } };
}
function create_section_content_slot_4(t18) {
  let e2, n2, o2 = [], i2 = /* @__PURE__ */ new Map(), r2 = ensure_array_like(t18[7]);
  const a2 = (t19) => t19[32].id;
  for (let e3 = 0; e3 < r2.length; e3 += 1) {
    let n3 = get_each_context_4(t18, r2, e3), s2 = a2(n3);
    i2.set(s2, o2[e3] = create_each_block_4(s2, n3));
  }
  return { c() {
    e2 = element("div");
    for (let t19 = 0; t19 < o2.length; t19 += 1) o2[t19].c();
    attr(e2, "slot", "section-content");
  }, m(t19, i3) {
    insert(t19, e2, i3);
    for (let t20 = 0; t20 < o2.length; t20 += 1) o2[t20] && o2[t20].m(e2, null);
    n2 = true;
  }, p(t19, n3) {
    129 & n3[0] && (r2 = ensure_array_like(t19[7]), group_outros(), o2 = update_keyed_each(o2, n3, a2, 1, t19, r2, i2, e2, outro_and_destroy_block, create_each_block_4, null, get_each_context_4), check_outros());
  }, i(t19) {
    if (!n2) {
      for (let t20 = 0; t20 < r2.length; t20 += 1) transition_in(o2[t20]);
      n2 = true;
    }
  }, o(t19) {
    for (let t20 = 0; t20 < o2.length; t20 += 1) transition_out(o2[t20]);
    n2 = false;
  }, d(t19) {
    t19 && detach(e2);
    for (let t20 = 0; t20 < o2.length; t20 += 1) o2[t20].d();
  } };
}
function create_if_block_3$6(t18) {
  let e2, n2;
  return e2 = new Category({ props: { title: t18[14].objectTypesPlural.jewelry, $$slots: { "section-content": [create_section_content_slot_3] }, $$scope: { ctx: t18 } } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    257 & n3[0] | 1048576 & n3[1] && (o2.$$scope = { dirty: n3, ctx: t19 }), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_each_block_3(t18, e2) {
  let n2, o2, i2;
  return o2 = new Object$1({ props: { actor: e2[0], item: e2[32] } }), { key: t18, first: null, c() {
    n2 = empty(), create_component(o2.$$.fragment), this.first = n2;
  }, m(t19, e3) {
    insert(t19, n2, e3), mount_component(o2, t19, e3), i2 = true;
  }, p(t19, n3) {
    e2 = t19;
    const i3 = {};
    1 & n3[0] && (i3.actor = e2[0]), 256 & n3[0] && (i3.item = e2[32]), o2.$set(i3);
  }, i(t19) {
    i2 || (transition_in(o2.$$.fragment, t19), i2 = true);
  }, o(t19) {
    transition_out(o2.$$.fragment, t19), i2 = false;
  }, d(t19) {
    t19 && detach(n2), destroy_component(o2, t19);
  } };
}
function create_section_content_slot_3(t18) {
  let e2, n2, o2 = [], i2 = /* @__PURE__ */ new Map(), r2 = ensure_array_like(t18[8]);
  const a2 = (t19) => t19[32].id;
  for (let e3 = 0; e3 < r2.length; e3 += 1) {
    let n3 = get_each_context_3(t18, r2, e3), s2 = a2(n3);
    i2.set(s2, o2[e3] = create_each_block_3(s2, n3));
  }
  return { c() {
    e2 = element("div");
    for (let t19 = 0; t19 < o2.length; t19 += 1) o2[t19].c();
    attr(e2, "slot", "section-content");
  }, m(t19, i3) {
    insert(t19, e2, i3);
    for (let t20 = 0; t20 < o2.length; t20 += 1) o2[t20] && o2[t20].m(e2, null);
    n2 = true;
  }, p(t19, n3) {
    257 & n3[0] && (r2 = ensure_array_like(t19[8]), group_outros(), o2 = update_keyed_each(o2, n3, a2, 1, t19, r2, i2, e2, outro_and_destroy_block, create_each_block_3, null, get_each_context_3), check_outros());
  }, i(t19) {
    if (!n2) {
      for (let t20 = 0; t20 < r2.length; t20 += 1) transition_in(o2[t20]);
      n2 = true;
    }
  }, o(t19) {
    for (let t20 = 0; t20 < o2.length; t20 += 1) transition_out(o2[t20]);
    n2 = false;
  }, d(t19) {
    t19 && detach(e2);
    for (let t20 = 0; t20 < o2.length; t20 += 1) o2[t20].d();
  } };
}
function create_if_block_2$a(t18) {
  let e2, n2;
  return e2 = new Category({ props: { title: t18[14].objectTypesPlural.clothing, $$slots: { "section-content": [create_section_content_slot_2] }, $$scope: { ctx: t18 } } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    513 & n3[0] | 1048576 & n3[1] && (o2.$$scope = { dirty: n3, ctx: t19 }), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_each_block_2(t18, e2) {
  let n2, o2, i2;
  return o2 = new Object$1({ props: { actor: e2[0], item: e2[32] } }), { key: t18, first: null, c() {
    n2 = empty(), create_component(o2.$$.fragment), this.first = n2;
  }, m(t19, e3) {
    insert(t19, n2, e3), mount_component(o2, t19, e3), i2 = true;
  }, p(t19, n3) {
    e2 = t19;
    const i3 = {};
    1 & n3[0] && (i3.actor = e2[0]), 512 & n3[0] && (i3.item = e2[32]), o2.$set(i3);
  }, i(t19) {
    i2 || (transition_in(o2.$$.fragment, t19), i2 = true);
  }, o(t19) {
    transition_out(o2.$$.fragment, t19), i2 = false;
  }, d(t19) {
    t19 && detach(n2), destroy_component(o2, t19);
  } };
}
function create_section_content_slot_2(t18) {
  let e2, n2, o2 = [], i2 = /* @__PURE__ */ new Map(), r2 = ensure_array_like(t18[9]);
  const a2 = (t19) => t19[32].id;
  for (let e3 = 0; e3 < r2.length; e3 += 1) {
    let n3 = get_each_context_2(t18, r2, e3), s2 = a2(n3);
    i2.set(s2, o2[e3] = create_each_block_2(s2, n3));
  }
  return { c() {
    e2 = element("div");
    for (let t19 = 0; t19 < o2.length; t19 += 1) o2[t19].c();
    attr(e2, "slot", "section-content");
  }, m(t19, i3) {
    insert(t19, e2, i3);
    for (let t20 = 0; t20 < o2.length; t20 += 1) o2[t20] && o2[t20].m(e2, null);
    n2 = true;
  }, p(t19, n3) {
    513 & n3[0] && (r2 = ensure_array_like(t19[9]), group_outros(), o2 = update_keyed_each(o2, n3, a2, 1, t19, r2, i2, e2, outro_and_destroy_block, create_each_block_2, null, get_each_context_2), check_outros());
  }, i(t19) {
    if (!n2) {
      for (let t20 = 0; t20 < r2.length; t20 += 1) transition_in(o2[t20]);
      n2 = true;
    }
  }, o(t19) {
    for (let t20 = 0; t20 < o2.length; t20 += 1) transition_out(o2[t20]);
    n2 = false;
  }, d(t19) {
    t19 && detach(e2);
    for (let t20 = 0; t20 < o2.length; t20 += 1) o2[t20].d();
  } };
}
function create_if_block_1$j(t18) {
  let e2, n2;
  return e2 = new Category({ props: { title: t18[14].objectTypesPlural.miscellaneous, $$slots: { "section-content": [create_section_content_slot_1] }, $$scope: { ctx: t18 } } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1025 & n3[0] | 1048576 & n3[1] && (o2.$$scope = { dirty: n3, ctx: t19 }), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_each_block_1$1(t18, e2) {
  let n2, o2, i2;
  return o2 = new Object$1({ props: { actor: e2[0], item: e2[32] } }), { key: t18, first: null, c() {
    n2 = empty(), create_component(o2.$$.fragment), this.first = n2;
  }, m(t19, e3) {
    insert(t19, n2, e3), mount_component(o2, t19, e3), i2 = true;
  }, p(t19, n3) {
    e2 = t19;
    const i3 = {};
    1 & n3[0] && (i3.actor = e2[0]), 1024 & n3[0] && (i3.item = e2[32]), o2.$set(i3);
  }, i(t19) {
    i2 || (transition_in(o2.$$.fragment, t19), i2 = true);
  }, o(t19) {
    transition_out(o2.$$.fragment, t19), i2 = false;
  }, d(t19) {
    t19 && detach(n2), destroy_component(o2, t19);
  } };
}
function create_section_content_slot_1(t18) {
  let e2, n2, o2 = [], i2 = /* @__PURE__ */ new Map(), r2 = ensure_array_like(t18[10]);
  const a2 = (t19) => t19[32].id;
  for (let e3 = 0; e3 < r2.length; e3 += 1) {
    let n3 = get_each_context_1$1(t18, r2, e3), s2 = a2(n3);
    i2.set(s2, o2[e3] = create_each_block_1$1(s2, n3));
  }
  return { c() {
    e2 = element("div");
    for (let t19 = 0; t19 < o2.length; t19 += 1) o2[t19].c();
    attr(e2, "slot", "section-content");
  }, m(t19, i3) {
    insert(t19, e2, i3);
    for (let t20 = 0; t20 < o2.length; t20 += 1) o2[t20] && o2[t20].m(e2, null);
    n2 = true;
  }, p(t19, n3) {
    1025 & n3[0] && (r2 = ensure_array_like(t19[10]), group_outros(), o2 = update_keyed_each(o2, n3, a2, 1, t19, r2, i2, e2, outro_and_destroy_block, create_each_block_1$1, null, get_each_context_1$1), check_outros());
  }, i(t19) {
    if (!n2) {
      for (let t20 = 0; t20 < r2.length; t20 += 1) transition_in(o2[t20]);
      n2 = true;
    }
  }, o(t19) {
    for (let t20 = 0; t20 < o2.length; t20 += 1) transition_out(o2[t20]);
    n2 = false;
  }, d(t19) {
    t19 && detach(e2);
    for (let t20 = 0; t20 < o2.length; t20 += 1) o2[t20].d();
  } };
}
function create_if_block$Y(t18) {
  let e2, n2;
  return e2 = new Category({ props: { title: t18[14].objectTypesPlural.container, $$slots: { "section-content": [create_section_content_slot$k] }, $$scope: { ctx: t18 } } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    33 & n3[0] | 1048576 & n3[1] && (o2.$$scope = { dirty: n3, ctx: t19 }), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_each_block$C(t18, e2) {
  let n2, o2, i2;
  return o2 = new Object$1({ props: { actor: e2[0], item: e2[32] } }), { key: t18, first: null, c() {
    n2 = empty(), create_component(o2.$$.fragment), this.first = n2;
  }, m(t19, e3) {
    insert(t19, n2, e3), mount_component(o2, t19, e3), i2 = true;
  }, p(t19, n3) {
    e2 = t19;
    const i3 = {};
    1 & n3[0] && (i3.actor = e2[0]), 32 & n3[0] && (i3.item = e2[32]), o2.$set(i3);
  }, i(t19) {
    i2 || (transition_in(o2.$$.fragment, t19), i2 = true);
  }, o(t19) {
    transition_out(o2.$$.fragment, t19), i2 = false;
  }, d(t19) {
    t19 && detach(n2), destroy_component(o2, t19);
  } };
}
function create_section_content_slot$k(t18) {
  let e2, n2, o2 = [], i2 = /* @__PURE__ */ new Map(), r2 = ensure_array_like(t18[5]);
  const a2 = (t19) => t19[32].id;
  for (let e3 = 0; e3 < r2.length; e3 += 1) {
    let n3 = get_each_context$C(t18, r2, e3), s2 = a2(n3);
    i2.set(s2, o2[e3] = create_each_block$C(s2, n3));
  }
  return { c() {
    e2 = element("div");
    for (let t19 = 0; t19 < o2.length; t19 += 1) o2[t19].c();
    attr(e2, "slot", "section-content");
  }, m(t19, i3) {
    insert(t19, e2, i3);
    for (let t20 = 0; t20 < o2.length; t20 += 1) o2[t20] && o2[t20].m(e2, null);
    n2 = true;
  }, p(t19, n3) {
    33 & n3[0] && (r2 = ensure_array_like(t19[5]), group_outros(), o2 = update_keyed_each(o2, n3, a2, 1, t19, r2, i2, e2, outro_and_destroy_block, create_each_block$C, null, get_each_context$C), check_outros());
  }, i(t19) {
    if (!n2) {
      for (let t20 = 0; t20 < r2.length; t20 += 1) transition_in(o2[t20]);
      n2 = true;
    }
  }, o(t19) {
    for (let t20 = 0; t20 < o2.length; t20 += 1) transition_out(o2[t20]);
    n2 = false;
  }, d(t19) {
    t19 && detach(e2);
    for (let t20 = 0; t20 < o2.length; t20 += 1) o2[t20].d();
  } };
}
function create_fragment$1P(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, m2, f2, h2, g2, _, $2 = t18[13] && create_if_block_11(t18), b2 = t18[11] && create_if_block_10(t18);
  r2 = new AdditionalInventoryInfo({ props: { actor: t18[0] } });
  let y2 = t18[12] && create_if_block_9$1(t18), v2 = t18[2].length > 0 && create_if_block_8$1(t18), w2 = t18[3].length > 0 && create_if_block_7$1(t18), S2 = t18[4].length > 0 && create_if_block_6$2(t18), T2 = t18[6].length > 0 && create_if_block_5$3(t18), k2 = t18[7].length > 0 && create_if_block_4$4(t18), x2 = t18[8].length > 0 && create_if_block_3$6(t18), E = t18[9].length > 0 && create_if_block_2$a(t18), O2 = t18[10].length > 0 && create_if_block_1$j(t18), A2 = t18[5].length > 0 && create_if_block$Y(t18);
  return { c() {
    e2 = element("section"), $2 && $2.c(), n2 = space(), o2 = element("div"), b2 && b2.c(), i2 = space(), create_component(r2.$$.fragment), a2 = space(), y2 && y2.c(), s2 = space(), c2 = element("div"), v2 && v2.c(), l2 = space(), w2 && w2.c(), u2 = space(), S2 && S2.c(), p2 = space(), T2 && T2.c(), d2 = space(), k2 && k2.c(), m2 = space(), x2 && x2.c(), f2 = space(), E && E.c(), h2 = space(), O2 && O2.c(), g2 = space(), A2 && A2.c(), attr(o2, "class", "weight-and-additional svelte-mobile-companion-a5e-038vch56tr3-1er0s5g"), attr(c2, "class", "content-scroll-list"), attr(e2, "class", "category-content");
  }, m(t19, C2) {
    insert(t19, e2, C2), $2 && $2.m(e2, null), append(e2, n2), append(e2, o2), b2 && b2.m(o2, null), append(o2, i2), mount_component(r2, o2, null), append(o2, a2), y2 && y2.m(o2, null), append(e2, s2), append(e2, c2), v2 && v2.m(c2, null), append(c2, l2), w2 && w2.m(c2, null), append(c2, u2), S2 && S2.m(c2, null), append(c2, p2), T2 && T2.m(c2, null), append(c2, d2), k2 && k2.m(c2, null), append(c2, m2), x2 && x2.m(c2, null), append(c2, f2), E && E.m(c2, null), append(c2, h2), O2 && O2.m(c2, null), append(c2, g2), A2 && A2.m(c2, null), _ = true;
  }, p(t19, a3) {
    t19[13] ? $2 ? ($2.p(t19, a3), 8192 & a3[0] && transition_in($2, 1)) : ($2 = create_if_block_11(t19), $2.c(), transition_in($2, 1), $2.m(e2, n2)) : $2 && (group_outros(), transition_out($2, 1, 1, () => {
      $2 = null;
    }), check_outros()), t19[11] ? b2 ? (b2.p(t19, a3), 2048 & a3[0] && transition_in(b2, 1)) : (b2 = create_if_block_10(t19), b2.c(), transition_in(b2, 1), b2.m(o2, i2)) : b2 && (group_outros(), transition_out(b2, 1, 1, () => {
      b2 = null;
    }), check_outros());
    const s3 = {};
    1 & a3[0] && (s3.actor = t19[0]), r2.$set(s3), t19[12] ? y2 ? (y2.p(t19, a3), 4096 & a3[0] && transition_in(y2, 1)) : (y2 = create_if_block_9$1(t19), y2.c(), transition_in(y2, 1), y2.m(o2, null)) : y2 && (group_outros(), transition_out(y2, 1, 1, () => {
      y2 = null;
    }), check_outros()), t19[2].length > 0 ? v2 ? (v2.p(t19, a3), 4 & a3[0] && transition_in(v2, 1)) : (v2 = create_if_block_8$1(t19), v2.c(), transition_in(v2, 1), v2.m(c2, l2)) : v2 && (group_outros(), transition_out(v2, 1, 1, () => {
      v2 = null;
    }), check_outros()), t19[3].length > 0 ? w2 ? (w2.p(t19, a3), 8 & a3[0] && transition_in(w2, 1)) : (w2 = create_if_block_7$1(t19), w2.c(), transition_in(w2, 1), w2.m(c2, u2)) : w2 && (group_outros(), transition_out(w2, 1, 1, () => {
      w2 = null;
    }), check_outros()), t19[4].length > 0 ? S2 ? (S2.p(t19, a3), 16 & a3[0] && transition_in(S2, 1)) : (S2 = create_if_block_6$2(t19), S2.c(), transition_in(S2, 1), S2.m(c2, p2)) : S2 && (group_outros(), transition_out(S2, 1, 1, () => {
      S2 = null;
    }), check_outros()), t19[6].length > 0 ? T2 ? (T2.p(t19, a3), 64 & a3[0] && transition_in(T2, 1)) : (T2 = create_if_block_5$3(t19), T2.c(), transition_in(T2, 1), T2.m(c2, d2)) : T2 && (group_outros(), transition_out(T2, 1, 1, () => {
      T2 = null;
    }), check_outros()), t19[7].length > 0 ? k2 ? (k2.p(t19, a3), 128 & a3[0] && transition_in(k2, 1)) : (k2 = create_if_block_4$4(t19), k2.c(), transition_in(k2, 1), k2.m(c2, m2)) : k2 && (group_outros(), transition_out(k2, 1, 1, () => {
      k2 = null;
    }), check_outros()), t19[8].length > 0 ? x2 ? (x2.p(t19, a3), 256 & a3[0] && transition_in(x2, 1)) : (x2 = create_if_block_3$6(t19), x2.c(), transition_in(x2, 1), x2.m(c2, f2)) : x2 && (group_outros(), transition_out(x2, 1, 1, () => {
      x2 = null;
    }), check_outros()), t19[9].length > 0 ? E ? (E.p(t19, a3), 512 & a3[0] && transition_in(E, 1)) : (E = create_if_block_2$a(t19), E.c(), transition_in(E, 1), E.m(c2, h2)) : E && (group_outros(), transition_out(E, 1, 1, () => {
      E = null;
    }), check_outros()), t19[10].length > 0 ? O2 ? (O2.p(t19, a3), 1024 & a3[0] && transition_in(O2, 1)) : (O2 = create_if_block_1$j(t19), O2.c(), transition_in(O2, 1), O2.m(c2, g2)) : O2 && (group_outros(), transition_out(O2, 1, 1, () => {
      O2 = null;
    }), check_outros()), t19[5].length > 0 ? A2 ? (A2.p(t19, a3), 32 & a3[0] && transition_in(A2, 1)) : (A2 = create_if_block$Y(t19), A2.c(), transition_in(A2, 1), A2.m(c2, null)) : A2 && (group_outros(), transition_out(A2, 1, 1, () => {
      A2 = null;
    }), check_outros());
  }, i(t19) {
    _ || (transition_in($2), transition_in(b2), transition_in(r2.$$.fragment, t19), transition_in(y2), transition_in(v2), transition_in(w2), transition_in(S2), transition_in(T2), transition_in(k2), transition_in(x2), transition_in(E), transition_in(O2), transition_in(A2), _ = true);
  }, o(t19) {
    transition_out($2), transition_out(b2), transition_out(r2.$$.fragment, t19), transition_out(y2), transition_out(v2), transition_out(w2), transition_out(S2), transition_out(T2), transition_out(k2), transition_out(x2), transition_out(E), transition_out(O2), transition_out(A2), _ = false;
  }, d(t19) {
    t19 && detach(e2), $2 && $2.d(), b2 && b2.d(), destroy_component(r2), y2 && y2.d(), v2 && v2.d(), w2 && w2.d(), S2 && S2.d(), T2 && T2.d(), k2 && k2.d(), x2 && x2.d(), E && E.d(), O2 && O2.d(), A2 && A2.d();
  } };
}
function instance$1Q(t18, e2, n2) {
  var o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, m2;
  let { actor: f2 } = e2;
  const h2 = CONFIG.A5E;
  let g2, _ = f2.itemTypes.object, $2 = [], b2 = [], y2 = [], v2 = [], w2 = [], S2 = [], T2 = [], k2 = [], x2 = [], E = false;
  const O2 = mobileCompanionGameSettings.getWritableStore(USE_CURRENCY).subscribe((t19) => {
    n2(11, E = t19);
  });
  let A2 = false;
  const C2 = mobileCompanionGameSettings.getWritableStore(USE_ENCUMBRANCE).subscribe((t19) => {
    n2(12, A2 = t19);
  });
  let M;
  const I2 = mobileCompanionGameSettings.getWritableStore(USE_CONTAINER).subscribe((t19) => {
    n2(13, M = t19);
  });
  return onDestroy(() => {
    O2(), C2(), I2();
  }), t18.$$set = (t19) => {
    "actor" in t19 && n2(0, f2 = t19.actor);
  }, t18.$$.update = () => {
    if (268371967 & t18.$$.dirty[0]) {
      n2(27, _ = function(t20, e4) {
        if (e4) {
          const n3 = t20.find((t21) => {
            const n4 = t21.system.objectType === ObjectType.Container, o3 = t21.id === e4;
            return n4 && o3;
          });
          return n3 ? n3.contents.filter((t21) => null !== t21) : [];
        }
        return t20.filter((t21) => {
          const e5 = t21.system, n3 = e5.containerId, o3 = n3 && fromUuidSync(e5.containerId);
          return !n3 || !o3;
        });
      }(f2.itemTypes.object, g2));
      let t19 = _.reduce((t20, e4) => {
        var n3;
        if (null == e4 ? void 0 : e4.system) {
          let o3 = e4.system.objectType;
          Object.values(ObjectType).includes(o3) || (o3 = ObjectType.Miscellaneous), t20[o3] || (t20[o3] = []), null === (n3 = t20[o3]) || void 0 === n3 || n3.push(e4);
        } else console.error("Object has no system data", e4);
        return t20;
      }, {});
      n2(2, $2 = null !== n2(16, o2 = t19[ObjectType.Weapon]) && void 0 !== o2 ? o2 : []), $2.sort((t20, e4) => t20.name.localeCompare(e4.name)), n2(3, b2 = null !== n2(17, i2 = t19[ObjectType.Armor]) && void 0 !== i2 ? i2 : []);
      const e3 = null !== n2(18, r2 = t19[ObjectType.Helm]) && void 0 !== r2 ? r2 : [], h3 = null !== n2(19, a2 = t19[ObjectType.Shield]) && void 0 !== a2 ? a2 : [];
      b2.push(...e3, ...h3), b2.sort((t20, e4) => t20.name.localeCompare(e4.name)), n2(4, y2 = null !== n2(20, s2 = t19[ObjectType.Ammunition]) && void 0 !== s2 ? s2 : []), y2.sort((t20, e4) => t20.name.localeCompare(e4.name)), n2(5, v2 = null !== n2(21, c2 = t19[ObjectType.Container]) && void 0 !== c2 ? c2 : []), v2.sort((t20, e4) => t20.name.localeCompare(e4.name)), n2(6, w2 = null !== n2(22, l2 = t19[ObjectType.Consumable]) && void 0 !== l2 ? l2 : []), w2.sort((t20, e4) => t20.name.localeCompare(e4.name)), n2(7, S2 = null !== n2(23, u2 = t19[ObjectType.Tool]) && void 0 !== u2 ? u2 : []), S2.sort((t20, e4) => t20.name.localeCompare(e4.name)), n2(8, T2 = null !== n2(24, p2 = t19[ObjectType.Jewelry]) && void 0 !== p2 ? p2 : []), T2.sort((t20, e4) => t20.name.localeCompare(e4.name)), n2(9, k2 = null !== n2(25, d2 = t19[ObjectType.Clothing]) && void 0 !== d2 ? d2 : []), k2.sort((t20, e4) => t20.name.localeCompare(e4.name)), n2(10, x2 = null !== n2(26, m2 = t19[ObjectType.Miscellaneous]) && void 0 !== m2 ? m2 : []), x2.sort((t20, e4) => t20.name.localeCompare(e4.name));
    }
  }, [f2, g2, $2, b2, y2, v2, w2, S2, T2, k2, x2, E, A2, M, h2, function(t19) {
    n2(1, g2 = t19.detail);
  }, o2, i2, r2, a2, s2, c2, l2, u2, p2, d2, m2, _];
}
class Inventory extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1Q, create_fragment$1P, safe_not_equal, { actor: 0 }, null, [-1, -1]);
  }
}
function create_fragment$1O(t18) {
  let e2, n2, o2, i2, r2;
  return { c() {
    e2 = element("div"), n2 = element("button"), attr(n2, "class", o2 = null_to_empty("no-hover-focus-effect action-button fas " + t18[1]) + " svelte-mobile-companion-a5e-038vch56tr3-1edm1hl"), toggle_class(n2, "active", t18[0]);
  }, m(o3, a2) {
    insert(o3, e2, a2), append(e2, n2), i2 || (r2 = listen(n2, "click", t18[2]), i2 = true);
  }, p(t19, [e3]) {
    2 & e3 && o2 !== (o2 = null_to_empty("no-hover-focus-effect action-button fas " + t19[1]) + " svelte-mobile-companion-a5e-038vch56tr3-1edm1hl") && attr(n2, "class", o2), 3 & e3 && toggle_class(n2, "active", t19[0]);
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2), i2 = false, r2();
  } };
}
function instance$1P(t18, e2, n2) {
  let o2, i2, { spell: r2 } = e2;
  return t18.$$set = (t19) => {
    "spell" in t19 && n2(3, r2 = t19.spell);
  }, t18.$$.update = () => {
    8 & t18.$$.dirty && n2(1, o2 = r2.system.prepared === PreparedLevel.AlwaysPrepared ? "fa-book-sparkles" : "fa-book"), 8 & t18.$$.dirty && n2(0, i2 = r2.system.prepared !== PreparedLevel.NotPrepared);
  }, [i2, o2, function() {
    if (r2.system.prepared === PreparedLevel.AlwaysPrepared) return;
    let t19 = r2.system.prepared === PreparedLevel.Prepared ? PreparedLevel.NotPrepared : PreparedLevel.Prepared;
    r2.update({ system: { prepared: t19 } });
  }, r2];
}
class SpellPreparedState extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1P, create_fragment$1O, safe_not_equal, { spell: 3 });
  }
}
function create_if_block_1$i(t18) {
  let e2, n2, o2;
  return { c() {
    e2 = element("button"), e2.textContent = `${concentration}`, attr(e2, "class", "global-badge no-hover-focus-effect svelte-mobile-companion-a5e-038vch56tr3-1r90tdm"), toggle_class(e2, "active", t18[1]);
  }, m(i2, r2) {
    insert(i2, e2, r2), n2 || (o2 = listen(e2, "click", t18[3]), n2 = true);
  }, p(t19, n3) {
    2 & n3 && toggle_class(e2, "active", t19[1]);
  }, d(t19) {
    t19 && detach(e2), n2 = false, o2();
  } };
}
function create_if_block$X(t18) {
  let e2;
  return { c() {
    e2 = element("span"), e2.textContent = `${ritual}`, attr(e2, "class", "global-badge");
  }, m(t19, n2) {
    insert(t19, e2, n2);
  }, p: noop$4, d(t19) {
    t19 && detach(e2);
  } };
}
function create_fragment$1N(t18) {
  let e2, n2, o2 = t18[0].system.concentration && create_if_block_1$i(t18), i2 = t18[0].system.ritual && create_if_block$X();
  return { c() {
    e2 = element("div"), o2 && o2.c(), n2 = space(), i2 && i2.c(), attr(e2, "class", "tags svelte-mobile-companion-a5e-038vch56tr3-1r90tdm");
  }, m(t19, r2) {
    insert(t19, e2, r2), o2 && o2.m(e2, null), append(e2, n2), i2 && i2.m(e2, null);
  }, p(t19, [r2]) {
    t19[0].system.concentration ? o2 ? o2.p(t19, r2) : (o2 = create_if_block_1$i(t19), o2.c(), o2.m(e2, n2)) : o2 && (o2.d(1), o2 = null), t19[0].system.ritual ? i2 ? i2.p(t19, r2) : (i2 = create_if_block$X(), i2.c(), i2.m(e2, null)) : i2 && (i2.d(1), i2 = null);
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2), o2 && o2.d(), i2 && i2.d();
  } };
}
const concentration = "C", ritual = "R";
function instance$1O(t18, e2, n2) {
  let o2, i2;
  var r2;
  let { spell: a2 } = e2;
  const s2 = getContext("actorStore");
  return component_subscribe(t18, s2, (t19) => n2(5, i2 = t19)), t18.$$set = (t19) => {
    "spell" in t19 && n2(0, a2 = t19.spell);
  }, t18.$$.update = () => {
    48 & t18.$$.dirty && n2(1, o2 = null !== n2(4, r2 = null == i2 ? void 0 : i2.getFlag(getFullModuleId$1(), ActorFlags.concentration)) && void 0 !== r2 && r2);
  }, [a2, o2, s2, function(t19) {
    t19.preventDefault(), t19.stopPropagation(), i2 && (i2.setFlag(getFullModuleId$1(), ActorFlags.concentration, a2.name), i2.toggleStatusEffect("concentration", { active: true }));
  }, r2, i2];
}
class SpellTags extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1O, create_fragment$1N, safe_not_equal, { spell: 0 });
  }
}
function create_if_block$W(t18) {
  let e2, n2;
  return { c() {
    e2 = element("div"), n2 = text(t18[1]), attr(e2, "class", "global-badge svelte-mobile-companion-a5e-038vch56tr3-1fkayd7"), toggle_class(e2, "alwaysPrepared", t18[0] === PreparedLevel.AlwaysPrepared), toggle_class(e2, "prepared", t18[0] === PreparedLevel.Prepared);
  }, m(t19, o2) {
    insert(t19, e2, o2), append(e2, n2);
  }, p(t19, o2) {
    2 & o2 && set_data(n2, t19[1]), 1 & o2 && toggle_class(e2, "alwaysPrepared", t19[0] === PreparedLevel.AlwaysPrepared), 1 & o2 && toggle_class(e2, "prepared", t19[0] === PreparedLevel.Prepared);
  }, d(t19) {
    t19 && detach(e2);
  } };
}
function create_fragment$1M(t18) {
  let e2, n2 = t18[1] && create_if_block$W(t18);
  return { c() {
    n2 && n2.c(), e2 = empty();
  }, m(t19, o2) {
    n2 && n2.m(t19, o2), insert(t19, e2, o2);
  }, p(t19, [o2]) {
    t19[1] ? n2 ? n2.p(t19, o2) : (n2 = create_if_block$W(t19), n2.c(), n2.m(e2.parentNode, e2)) : n2 && (n2.d(1), n2 = null);
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2), n2 && n2.d(t19);
  } };
}
function getCost(t18) {
  var e2, n2, o2, i2;
  return "string" == typeof t18 ? t18 : null !== (i2 = null === (o2 = null === (n2 = null === (e2 = null == t18 ? void 0 : t18.activation) || void 0 === e2 ? void 0 : e2.type) || void 0 === n2 ? void 0 : n2.charAt(0)) || void 0 === o2 ? void 0 : o2.toUpperCase()) && void 0 !== i2 ? i2 : "";
}
function instance$1N(t18, e2, n2) {
  let o2, { action: i2 } = e2, { prepared: r2 } = e2;
  return o2 = Array.isArray(i2) ? i2.map((t19) => getCost(t19)).join(", ") : getCost(i2), t18.$$set = (t19) => {
    "action" in t19 && n2(2, i2 = t19.action), "prepared" in t19 && n2(0, r2 = t19.prepared);
  }, [r2, o2, i2];
}
class ActivationCostBadge extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1N, create_fragment$1M, safe_not_equal, { action: 2, prepared: 0 });
  }
}
function create_fragment$1L(t18) {
  let e2, n2, o2, i2, r2;
  return i2 = new Description({ props: { description: t18[0].description } }), { c() {
    e2 = element("section"), n2 = element("hr"), o2 = space(), create_component(i2.$$.fragment);
  }, m(t19, a2) {
    insert(t19, e2, a2), append(e2, n2), append(e2, o2), mount_component(i2, e2, null), r2 = true;
  }, p(t19, [e3]) {
    const n3 = {};
    1 & e3 && (n3.description = t19[0].description), i2.$set(n3);
  }, i(t19) {
    r2 || (transition_in(i2.$$.fragment, t19), r2 = true);
  }, o(t19) {
    transition_out(i2.$$.fragment, t19), r2 = false;
  }, d(t19) {
    t19 && detach(e2), destroy_component(i2);
  } };
}
function instance$1M(t18, e2, n2) {
  let { system: o2 } = e2;
  return t18.$$set = (t19) => {
    "system" in t19 && n2(0, o2 = t19.system);
  }, [o2];
}
class SpellDescription extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1M, create_fragment$1L, safe_not_equal, { system: 0 });
  }
}
function create_fragment$1K(t18) {
  let e2, n2, o2, i2, r2 = t18[0].join(", ") + "";
  return { c() {
    e2 = element("p"), n2 = element("b"), n2.textContent = `${i18n("A5E.details.classPlural")}:`, o2 = space(), i2 = text(r2);
  }, m(t19, r3) {
    insert(t19, e2, r3), append(e2, n2), append(e2, o2), append(e2, i2);
  }, p: noop$4, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2);
  } };
}
function instance$1L(t18, e2, n2) {
  let { system: o2 } = e2;
  const i2 = CONFIG.A5E, r2 = o2.classes.map((t19) => i2.classSpellLists[t19]);
  return t18.$$set = (t19) => {
    "system" in t19 && n2(1, o2 = t19.system);
  }, [r2, o2];
}
class SpellClasses extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1L, create_fragment$1K, safe_not_equal, { system: 1 });
  }
}
const { Map: Map_1$2 } = globals;
function get_each_context$B(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[4] = e2[n2][0], o2[5] = e2[n2][1], o2;
}
function create_each_block$B(t18, e2) {
  let n2, o2, i2;
  return o2 = new Action({ props: { action: e2[5], actionId: e2[4], rollData: e2[0], displayActionName: e2[2] } }), { key: t18, first: null, c() {
    n2 = empty(), create_component(o2.$$.fragment), this.first = n2;
  }, m(t19, e3) {
    insert(t19, n2, e3), mount_component(o2, t19, e3), i2 = true;
  }, p(t19, n3) {
    e2 = t19;
    const i3 = {};
    1 & n3 && (i3.rollData = e2[0]), o2.$set(i3);
  }, i(t19) {
    i2 || (transition_in(o2.$$.fragment, t19), i2 = true);
  }, o(t19) {
    transition_out(o2.$$.fragment, t19), i2 = false;
  }, d(t19) {
    t19 && detach(n2), destroy_component(o2, t19);
  } };
}
function create_fragment$1J(t18) {
  let e2, n2, o2 = [], i2 = new Map_1$2(), r2 = ensure_array_like([...t18[1]]);
  const a2 = (t19) => t19[5].name;
  for (let e3 = 0; e3 < r2.length; e3 += 1) {
    let n3 = get_each_context$B(t18, r2, e3), s2 = a2(n3);
    i2.set(s2, o2[e3] = create_each_block$B(s2, n3));
  }
  return { c() {
    e2 = element("section");
    for (let t19 = 0; t19 < o2.length; t19 += 1) o2[t19].c();
  }, m(t19, i3) {
    insert(t19, e2, i3);
    for (let t20 = 0; t20 < o2.length; t20 += 1) o2[t20] && o2[t20].m(e2, null);
    n2 = true;
  }, p(t19, [n3]) {
    7 & n3 && (r2 = ensure_array_like([...t19[1]]), group_outros(), o2 = update_keyed_each(o2, n3, a2, 1, t19, r2, i2, e2, outro_and_destroy_block, create_each_block$B, null, get_each_context$B), check_outros());
  }, i(t19) {
    if (!n2) {
      for (let t20 = 0; t20 < r2.length; t20 += 1) transition_in(o2[t20]);
      n2 = true;
    }
  }, o(t19) {
    for (let t20 = 0; t20 < o2.length; t20 += 1) transition_out(o2[t20]);
    n2 = false;
  }, d(t19) {
    t19 && detach(e2);
    for (let t20 = 0; t20 < o2.length; t20 += 1) o2[t20].d();
  } };
}
function instance$1K(t18, e2, n2) {
  let { actions: o2 } = e2, { rollData: i2 } = e2;
  const r2 = /* @__PURE__ */ new Map();
  o2.forEach((t19) => r2.set(t19.id, t19));
  const a2 = o2.length > 1;
  return t18.$$set = (t19) => {
    "actions" in t19 && n2(3, o2 = t19.actions), "rollData" in t19 && n2(0, i2 = t19.rollData);
  }, [i2, r2, a2, o2];
}
class SpellActions extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1K, create_fragment$1J, safe_not_equal, { actions: 3, rollData: 0 });
  }
}
function create_fragment$1I(t18) {
  let e2, n2, o2, i2, r2 = t18[0]() + "";
  return { c() {
    e2 = element("p"), n2 = element("b"), n2.textContent = `${i18n("A5E.filterLabels.spellComponents")}:`, o2 = space(), i2 = text(r2);
  }, m(t19, r3) {
    insert(t19, e2, r3), append(e2, n2), append(e2, o2), append(e2, i2);
  }, p: noop$4, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2);
  } };
}
function instance$1J(t18, e2, n2) {
  let { system: o2 } = e2;
  return t18.$$set = (t19) => {
    "system" in t19 && n2(1, o2 = t19.system);
  }, [function() {
    let t19 = [];
    return o2.components.vocalized && t19.push("V"), o2.components.seen && t19.push("S"), o2.components.material && (o2.materials ? t19.push(`M (${o2.materials})`) : t19.push("M")), t19.join(", ");
  }, o2];
}
class SpellComponents extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1J, create_fragment$1I, safe_not_equal, { system: 1 });
  }
}
function create_if_block_2$9(t18) {
  let e2, n2;
  return e2 = new SpellComponents({ props: { system: t18[2] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p: noop$4, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_if_block_1$h(t18) {
  let e2, n2;
  return e2 = new SpellActions({ props: { actions: t18[1], rollData: t18[0] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    2 & n3 && (o2.actions = t19[1]), 1 & n3 && (o2.rollData = t19[0]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_if_block$V(t18) {
  let e2, n2;
  return e2 = new SpellDescription({ props: { system: t18[2] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p: noop$4, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_fragment$1H(t18) {
  let e2, n2, o2, i2, r2, a2, s2;
  n2 = new SpellClasses({ props: { system: t18[2] } });
  let c2 = t18[2].components && create_if_block_2$9(t18), l2 = t18[1]?.length > 0 && create_if_block_1$h(t18), u2 = t18[2].description && create_if_block$V(t18);
  return { c() {
    e2 = element("section"), create_component(n2.$$.fragment), o2 = space(), c2 && c2.c(), i2 = space(), l2 && l2.c(), r2 = space(), u2 && u2.c(), a2 = empty();
  }, m(t19, p2) {
    insert(t19, e2, p2), mount_component(n2, e2, null), append(e2, o2), c2 && c2.m(e2, null), append(e2, i2), l2 && l2.m(e2, null), insert(t19, r2, p2), u2 && u2.m(t19, p2), insert(t19, a2, p2), s2 = true;
  }, p(t19, [n3]) {
    t19[2].components && c2.p(t19, n3), t19[1]?.length > 0 ? l2 ? (l2.p(t19, n3), 2 & n3 && transition_in(l2, 1)) : (l2 = create_if_block_1$h(t19), l2.c(), transition_in(l2, 1), l2.m(e2, null)) : l2 && (group_outros(), transition_out(l2, 1, 1, () => {
      l2 = null;
    }), check_outros()), t19[2].description && u2.p(t19, n3);
  }, i(t19) {
    s2 || (transition_in(n2.$$.fragment, t19), transition_in(c2), transition_in(l2), transition_in(u2), s2 = true);
  }, o(t19) {
    transition_out(n2.$$.fragment, t19), transition_out(c2), transition_out(l2), transition_out(u2), s2 = false;
  }, d(t19) {
    t19 && (detach(e2), detach(r2), detach(a2)), destroy_component(n2), c2 && c2.d(), l2 && l2.d(), u2 && u2.d(t19);
  } };
}
function instance$1I(t18, e2, n2) {
  let o2, i2, r2, a2, { spell: s2 } = e2, c2 = s2.system, l2 = getContext("actorStore");
  return component_subscribe(t18, l2, (t19) => n2(6, a2 = t19)), t18.$$set = (t19) => {
    "spell" in t19 && n2(4, s2 = t19.spell);
  }, t18.$$.update = () => {
    64 & t18.$$.dirty && n2(5, i2 = a2), 48 & t18.$$.dirty && n2(0, r2 = i2.getRollData(s2));
  }, n2(1, o2 = Object.values(c2.actions)), [r2, o2, c2, l2, s2, i2, a2];
}
class SpellBaseInfo extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1I, create_fragment$1H, safe_not_equal, { spell: 4 });
  }
}
function create_fragment$1G(t18) {
  let e2, n2, o2, i2;
  return e2 = new Effects({ props: { item: t18[0] } }), o2 = new SpellBaseInfo({ props: { spell: t18[0] } }), { c() {
    create_component(e2.$$.fragment), n2 = space(), create_component(o2.$$.fragment);
  }, m(t19, r2) {
    mount_component(e2, t19, r2), insert(t19, n2, r2), mount_component(o2, t19, r2), i2 = true;
  }, p(t19, [n3]) {
    const i3 = {};
    1 & n3 && (i3.item = t19[0]), e2.$set(i3);
    const r2 = {};
    1 & n3 && (r2.spell = t19[0]), o2.$set(r2);
  }, i(t19) {
    i2 || (transition_in(e2.$$.fragment, t19), transition_in(o2.$$.fragment, t19), i2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), transition_out(o2.$$.fragment, t19), i2 = false;
  }, d(t19) {
    t19 && detach(n2), destroy_component(e2, t19), destroy_component(o2, t19);
  } };
}
function instance$1H(t18, e2, n2) {
  let { spell: o2 } = e2;
  return t18.$$set = (t19) => {
    "spell" in t19 && n2(0, o2 = t19.spell);
  }, [o2];
}
class SpellDetails extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1H, create_fragment$1G, safe_not_equal, { spell: 0 });
  }
}
function create_if_block_3$5(t18) {
  let e2, n2, o2;
  return { c() {
    e2 = element("div"), attr(e2, "class", "overlay prepared svelte-mobile-companion-a5e-038vch56tr3-1781xj2");
  }, m(t19, n3) {
    insert(t19, e2, n3), o2 = true;
  }, i(t19) {
    o2 || (t19 && add_render_callback(() => {
      o2 && (n2 || (n2 = create_bidirectional_transition(e2, slide, { axis: "x", easing: circOut }, true)), n2.run(1));
    }), o2 = true);
  }, o(t19) {
    t19 && (n2 || (n2 = create_bidirectional_transition(e2, slide, { axis: "x", easing: circOut }, false)), n2.run(0)), o2 = false;
  }, d(t19) {
    t19 && detach(e2), t19 && n2 && n2.end();
  } };
}
function create_if_block_2$8(t18) {
  let e2, n2, o2;
  return { c() {
    e2 = element("div"), attr(e2, "class", "overlay alwaysPrepared svelte-mobile-companion-a5e-038vch56tr3-1781xj2");
  }, m(t19, n3) {
    insert(t19, e2, n3), o2 = true;
  }, i(t19) {
    o2 || (t19 && add_render_callback(() => {
      o2 && (n2 || (n2 = create_bidirectional_transition(e2, slide, { axis: "x", easing: circOut }, true)), n2.run(1));
    }), o2 = true);
  }, o(t19) {
    t19 && (n2 || (n2 = create_bidirectional_transition(e2, slide, { axis: "x", easing: circOut }, false)), n2.run(0)), o2 = false;
  }, d(t19) {
    t19 && detach(e2), t19 && n2 && n2.end();
  } };
}
function create_overlay_slot(t18) {
  let e2, n2, o2;
  const i2 = [create_if_block_2$8, create_if_block_3$5], r2 = [];
  function a2(t19, e3) {
    return t19[1].prepared === PreparedLevel.AlwaysPrepared ? 0 : t19[1].prepared === PreparedLevel.Prepared ? 1 : -1;
  }
  return ~(n2 = a2(t18)) && (o2 = r2[n2] = i2[n2](t18)), { c() {
    e2 = element("div"), o2 && o2.c(), attr(e2, "slot", "overlay");
  }, m(t19, o3) {
    insert(t19, e2, o3), ~n2 && r2[n2].m(e2, null);
  }, p(t19, s2) {
    let c2 = n2;
    n2 = a2(t19), n2 !== c2 && (o2 && (group_outros(), transition_out(r2[c2], 1, 1, () => {
      r2[c2] = null;
    }), check_outros()), ~n2 ? (o2 = r2[n2], o2 || (o2 = r2[n2] = i2[n2](t19), o2.c()), transition_in(o2, 1), o2.m(e2, null)) : o2 = null);
  }, d(t19) {
    t19 && detach(e2), ~n2 && r2[n2].d();
  } };
}
function create_if_block_1$g(t18) {
  let e2, n2;
  return e2 = new ActivationCostBadge({ props: { action: t18[2], prepared: t18[1].prepared } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    4 & n3 && (o2.action = t19[2]), 2 & n3 && (o2.prepared = t19[1].prepared), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_name_badge_slot$3(t18) {
  let e2, n2, o2 = t18[2] && create_if_block_1$g(t18);
  return { c() {
    e2 = element("div"), o2 && o2.c(), attr(e2, "slot", "name-badge");
  }, m(t19, i2) {
    insert(t19, e2, i2), o2 && o2.m(e2, null), n2 = true;
  }, p(t19, n3) {
    t19[2] ? o2 ? (o2.p(t19, n3), 4 & n3 && transition_in(o2, 1)) : (o2 = create_if_block_1$g(t19), o2.c(), transition_in(o2, 1), o2.m(e2, null)) : o2 && (group_outros(), transition_out(o2, 1, 1, () => {
      o2 = null;
    }), check_outros());
  }, i(t19) {
    n2 || (transition_in(o2), n2 = true);
  }, o(t19) {
    transition_out(o2), n2 = false;
  }, d(t19) {
    t19 && detach(e2), o2 && o2.d();
  } };
}
function create_right_content_slot$4(t18) {
  let e2, n2, o2, i2, r2;
  return n2 = new SpellTags({ props: { spell: t18[0] } }), i2 = new SpellPreparedState({ props: { spell: t18[0] } }), { c() {
    e2 = element("div"), create_component(n2.$$.fragment), o2 = space(), create_component(i2.$$.fragment), attr(e2, "class", "item-content svelte-mobile-companion-a5e-038vch56tr3-1781xj2"), attr(e2, "slot", "right-content");
  }, m(t19, a2) {
    insert(t19, e2, a2), mount_component(n2, e2, null), append(e2, o2), mount_component(i2, e2, null), r2 = true;
  }, p(t19, e3) {
    const o3 = {};
    1 & e3 && (o3.spell = t19[0]), n2.$set(o3);
    const r3 = {};
    1 & e3 && (r3.spell = t19[0]), i2.$set(r3);
  }, i(t19) {
    r2 || (transition_in(n2.$$.fragment, t19), transition_in(i2.$$.fragment, t19), r2 = true);
  }, o(t19) {
    transition_out(n2.$$.fragment, t19), transition_out(i2.$$.fragment, t19), r2 = false;
  }, d(t19) {
    t19 && detach(e2), destroy_component(n2), destroy_component(i2);
  } };
}
function create_else_block$5(t18) {
  let e2, n2;
  return e2 = new Patreon({ props: { subject: "Spells above 2nd level" } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p: noop$4, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_if_block$U(t18) {
  let e2, n2, o2, i2;
  return e2 = new StateButtons({ props: { $$slots: { default: [create_default_slot$k] }, $$scope: { ctx: t18 } } }), o2 = new SpellDetails({ props: { spell: t18[0] } }), { c() {
    create_component(e2.$$.fragment), n2 = space(), create_component(o2.$$.fragment);
  }, m(t19, r2) {
    mount_component(e2, t19, r2), insert(t19, n2, r2), mount_component(o2, t19, r2), i2 = true;
  }, p(t19, n3) {
    const i3 = {};
    33 & n3 && (i3.$$scope = { dirty: n3, ctx: t19 }), e2.$set(i3);
    const r2 = {};
    1 & n3 && (r2.spell = t19[0]), o2.$set(r2);
  }, i(t19) {
    i2 || (transition_in(e2.$$.fragment, t19), transition_in(o2.$$.fragment, t19), i2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), transition_out(o2.$$.fragment, t19), i2 = false;
  }, d(t19) {
    t19 && detach(n2), destroy_component(e2, t19), destroy_component(o2, t19);
  } };
}
function create_default_slot$k(t18) {
  let e2, n2;
  return e2 = new ToggleFavoriteButton({ props: { item: t18[0] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1 & n3 && (o2.item = t19[0]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_details_slot$5(t18) {
  let e2, n2, o2, i2;
  const r2 = [create_if_block$U, create_else_block$5], a2 = [];
  return n2 = function(t19) {
    return t19[3] ? 0 : 1;
  }(t18), o2 = a2[n2] = r2[n2](t18), { c() {
    e2 = element("div"), o2.c(), attr(e2, "slot", "details");
  }, m(t19, o3) {
    insert(t19, e2, o3), a2[n2].m(e2, null), i2 = true;
  }, p(t19, e3) {
    o2.p(t19, e3);
  }, i(t19) {
    i2 || (transition_in(o2), i2 = true);
  }, o(t19) {
    transition_out(o2), i2 = false;
  }, d(t19) {
    t19 && detach(e2), a2[n2].d();
  } };
}
function create_fragment$1F(t18) {
  let e2, n2;
  return e2 = new ToggleableListEntry({ props: { name: t18[0].name, imageSrc: t18[0].img, isFavorite: t18[0].system.favorite, $$slots: { details: [create_details_slot$5], "right-content": [create_right_content_slot$4], "name-badge": [create_name_badge_slot$3], overlay: [create_overlay_slot] }, $$scope: { ctx: t18 } } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, [n3]) {
    const o2 = {};
    1 & n3 && (o2.name = t19[0].name), 1 & n3 && (o2.imageSrc = t19[0].img), 1 & n3 && (o2.isFavorite = t19[0].system.favorite), 39 & n3 && (o2.$$scope = { dirty: n3, ctx: t19 }), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function instance$1G(t18, e2, n2) {
  let o2, i2, r2, { spell: a2 } = e2;
  const s2 = a2.system.level <= 2;
  return t18.$$set = (t19) => {
    "spell" in t19 && n2(0, a2 = t19.spell);
  }, t18.$$.update = () => {
    1 & t18.$$.dirty && n2(1, o2 = a2.system), 2 & t18.$$.dirty && n2(4, i2 = Object.values(o2.actions)), 16 & t18.$$.dirty && n2(2, r2 = i2.length > 1 ? null : i2[0]);
  }, [a2, o2, r2, s2, i2];
}
class Spell extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1G, create_fragment$1F, safe_not_equal, { spell: 0 });
  }
}
function get_each_context$A(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[9] = e2[n2], o2[11] = n2, o2;
}
function get_each_context_1(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[9] = e2[n2], o2[11] = n2, o2;
}
function create_each_block_1(t18) {
  let e2, n2, o2;
  function i2() {
    return t18[7](t18[11]);
  }
  return { c() {
    e2 = element("button"), e2.innerHTML = '<i class="icon fa-solid fa-star svelte-mobile-companion-a5e-038vch56tr3-lfb500"></i>', attr(e2, "class", "svelte-mobile-companion-a5e-038vch56tr3-lfb500");
  }, m(t19, r2) {
    insert(t19, e2, r2), n2 || (o2 = listen(e2, "click", i2), n2 = true);
  }, p(e3, n3) {
    t18 = e3;
  }, d(t19) {
    t19 && detach(e2), n2 = false, o2();
  } };
}
function create_each_block$A(t18) {
  let e2, n2, o2;
  function i2() {
    return t18[8](t18[11]);
  }
  return { c() {
    e2 = element("button"), e2.innerHTML = '<i class="icon fa-solid fa-star svelte-mobile-companion-a5e-038vch56tr3-lfb500"></i> ', attr(e2, "class", "expended svelte-mobile-companion-a5e-038vch56tr3-lfb500");
  }, m(t19, r2) {
    insert(t19, e2, r2), n2 || (o2 = listen(e2, "click", i2), n2 = true);
  }, p(e3, n3) {
    t18 = e3;
  }, d(t19) {
    t19 && detach(e2), n2 = false, o2();
  } };
}
function create_fragment$1E(t18) {
  let e2, n2, o2 = ensure_array_like(Array(t18[1])), i2 = [];
  for (let e3 = 0; e3 < o2.length; e3 += 1) i2[e3] = create_each_block_1(get_each_context_1(t18, o2, e3));
  let r2 = ensure_array_like(Array(t18[0] - t18[1])), a2 = [];
  for (let e3 = 0; e3 < r2.length; e3 += 1) a2[e3] = create_each_block$A(get_each_context$A(t18, r2, e3));
  return { c() {
    e2 = element("div");
    for (let t19 = 0; t19 < i2.length; t19 += 1) i2[t19].c();
    n2 = space();
    for (let t19 = 0; t19 < a2.length; t19 += 1) a2[t19].c();
    attr(e2, "class", "svelte-mobile-companion-a5e-038vch56tr3-lfb500");
  }, m(t19, o3) {
    insert(t19, e2, o3);
    for (let t20 = 0; t20 < i2.length; t20 += 1) i2[t20] && i2[t20].m(e2, null);
    append(e2, n2);
    for (let t20 = 0; t20 < a2.length; t20 += 1) a2[t20] && a2[t20].m(e2, null);
  }, p(t19, [s2]) {
    if (6 & s2) {
      let r3;
      for (o2 = ensure_array_like(Array(t19[1])), r3 = 0; r3 < o2.length; r3 += 1) {
        const a3 = get_each_context_1(t19, o2, r3);
        i2[r3] ? i2[r3].p(a3, s2) : (i2[r3] = create_each_block_1(a3), i2[r3].c(), i2[r3].m(e2, n2));
      }
      for (; r3 < i2.length; r3 += 1) i2[r3].d(1);
      i2.length = o2.length;
    }
    if (7 & s2) {
      let n3;
      for (r2 = ensure_array_like(Array(t19[0] - t19[1])), n3 = 0; n3 < r2.length; n3 += 1) {
        const o3 = get_each_context$A(t19, r2, n3);
        a2[n3] ? a2[n3].p(o3, s2) : (a2[n3] = create_each_block$A(o3), a2[n3].c(), a2[n3].m(e2, null));
      }
      for (; n3 < a2.length; n3 += 1) a2[n3].d(1);
      a2.length = r2.length;
    }
  }, i: noop$4, o: noop$4, d(t19) {
    t19 && detach(e2), destroy_each(i2, t19), destroy_each(a2, t19);
  } };
}
function instance$1F(t18, e2, n2) {
  var o2, i2;
  let r2, a2, { actor: s2 } = e2, { level: c2 } = e2;
  function l2(t19) {
    let e3 = a2;
    t19 < a2 ? a2 > 0 && (e3 = a2 - 1) : a2 < r2 && (e3 = a2 + 1), s2.update({ [`system.spellResources.slots.${c2}.current`]: e3 });
  }
  return t18.$$set = (t19) => {
    "actor" in t19 && n2(3, s2 = t19.actor), "level" in t19 && n2(4, c2 = t19.level);
  }, t18.$$.update = () => {
    56 & t18.$$.dirty && n2(0, r2 = null === n2(5, o2 = s2.system.spellResources.slots[c2]) || void 0 === o2 ? void 0 : o2.max), 88 & t18.$$.dirty && n2(1, a2 = null === n2(6, i2 = s2.system.spellResources.slots[c2]) || void 0 === i2 ? void 0 : i2.current);
  }, [r2, a2, l2, s2, c2, o2, i2, (t19) => l2(t19), (t19) => l2(a2 + t19)];
}
class SpellSlots extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1F, create_fragment$1E, safe_not_equal, { actor: 3, level: 4 });
  }
}
function get_each_context$z(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[4] = e2[n2], o2;
}
function create_if_block$T(t18) {
  let e2, n2;
  return e2 = new Category({ props: { title: t18[3].spellLevels[t18[2]], $$slots: { "section-content": [create_section_content_slot$j], "header-addons": [create_header_addons_slot$2] }, $$scope: { ctx: t18 } } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    4 & n3 && (o2.title = t19[3].spellLevels[t19[2]]), 135 & n3 && (o2.$$scope = { dirty: n3, ctx: t19 }), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_if_block_2$7(t18) {
  let e2, n2;
  return e2 = new SpellSlots({ props: { actor: t18[0], level: t18[2] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1 & n3 && (o2.actor = t19[0]), 4 & n3 && (o2.level = t19[2]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_header_addons_slot$2(t18) {
  let e2, n2, o2 = 0 !== t18[2] && create_if_block_2$7(t18);
  return { c() {
    e2 = element("span"), o2 && o2.c(), attr(e2, "slot", "header-addons");
  }, m(t19, i2) {
    insert(t19, e2, i2), o2 && o2.m(e2, null), n2 = true;
  }, p(t19, n3) {
    0 !== t19[2] ? o2 ? (o2.p(t19, n3), 4 & n3 && transition_in(o2, 1)) : (o2 = create_if_block_2$7(t19), o2.c(), transition_in(o2, 1), o2.m(e2, null)) : o2 && (group_outros(), transition_out(o2, 1, 1, () => {
      o2 = null;
    }), check_outros());
  }, i(t19) {
    n2 || (transition_in(o2), n2 = true);
  }, o(t19) {
    transition_out(o2), n2 = false;
  }, d(t19) {
    t19 && detach(e2), o2 && o2.d();
  } };
}
function create_if_block_1$f(t18) {
  let e2, n2, o2 = [], i2 = /* @__PURE__ */ new Map(), r2 = ensure_array_like(t18[1]);
  const a2 = (t19) => t19[4].id;
  for (let e3 = 0; e3 < r2.length; e3 += 1) {
    let n3 = get_each_context$z(t18, r2, e3), s2 = a2(n3);
    i2.set(s2, o2[e3] = create_each_block$z(s2, n3));
  }
  return { c() {
    for (let t19 = 0; t19 < o2.length; t19 += 1) o2[t19].c();
    e2 = empty();
  }, m(t19, i3) {
    for (let e3 = 0; e3 < o2.length; e3 += 1) o2[e3] && o2[e3].m(t19, i3);
    insert(t19, e2, i3), n2 = true;
  }, p(t19, n3) {
    2 & n3 && (r2 = ensure_array_like(t19[1]), group_outros(), o2 = update_keyed_each(o2, n3, a2, 1, t19, r2, i2, e2.parentNode, outro_and_destroy_block, create_each_block$z, e2, get_each_context$z), check_outros());
  }, i(t19) {
    if (!n2) {
      for (let t20 = 0; t20 < r2.length; t20 += 1) transition_in(o2[t20]);
      n2 = true;
    }
  }, o(t19) {
    for (let t20 = 0; t20 < o2.length; t20 += 1) transition_out(o2[t20]);
    n2 = false;
  }, d(t19) {
    t19 && detach(e2);
    for (let e3 = 0; e3 < o2.length; e3 += 1) o2[e3].d(t19);
  } };
}
function create_each_block$z(t18, e2) {
  let n2, o2, i2;
  return o2 = new Spell({ props: { spell: e2[4] } }), { key: t18, first: null, c() {
    n2 = empty(), create_component(o2.$$.fragment), this.first = n2;
  }, m(t19, e3) {
    insert(t19, n2, e3), mount_component(o2, t19, e3), i2 = true;
  }, p(t19, n3) {
    e2 = t19;
    const i3 = {};
    2 & n3 && (i3.spell = e2[4]), o2.$set(i3);
  }, i(t19) {
    i2 || (transition_in(o2.$$.fragment, t19), i2 = true);
  }, o(t19) {
    transition_out(o2.$$.fragment, t19), i2 = false;
  }, d(t19) {
    t19 && detach(n2), destroy_component(o2, t19);
  } };
}
function create_section_content_slot$j(t18) {
  let e2, n2, o2 = t18[1] && create_if_block_1$f(t18);
  return { c() {
    e2 = element("div"), o2 && o2.c(), attr(e2, "slot", "section-content");
  }, m(t19, i2) {
    insert(t19, e2, i2), o2 && o2.m(e2, null), n2 = true;
  }, p(t19, n3) {
    t19[1] ? o2 ? (o2.p(t19, n3), 2 & n3 && transition_in(o2, 1)) : (o2 = create_if_block_1$f(t19), o2.c(), transition_in(o2, 1), o2.m(e2, null)) : o2 && (group_outros(), transition_out(o2, 1, 1, () => {
      o2 = null;
    }), check_outros());
  }, i(t19) {
    n2 || (transition_in(o2), n2 = true);
  }, o(t19) {
    transition_out(o2), n2 = false;
  }, d(t19) {
    t19 && detach(e2), o2 && o2.d();
  } };
}
function create_fragment$1D(t18) {
  let e2, n2, o2 = t18[1]?.length > 0 && create_if_block$T(t18);
  return { c() {
    o2 && o2.c(), e2 = empty();
  }, m(t19, i2) {
    o2 && o2.m(t19, i2), insert(t19, e2, i2), n2 = true;
  }, p(t19, [n3]) {
    t19[1]?.length > 0 ? o2 ? (o2.p(t19, n3), 2 & n3 && transition_in(o2, 1)) : (o2 = create_if_block$T(t19), o2.c(), transition_in(o2, 1), o2.m(e2.parentNode, e2)) : o2 && (group_outros(), transition_out(o2, 1, 1, () => {
      o2 = null;
    }), check_outros());
  }, i(t19) {
    n2 || (transition_in(o2), n2 = true);
  }, o(t19) {
    transition_out(o2), n2 = false;
  }, d(t19) {
    t19 && detach(e2), o2 && o2.d(t19);
  } };
}
function instance$1E(t18, e2, n2) {
  let { actor: o2 } = e2, { spells: i2 } = e2, { level: r2 } = e2;
  const a2 = CONFIG.A5E;
  return t18.$$set = (t19) => {
    "actor" in t19 && n2(0, o2 = t19.actor), "spells" in t19 && n2(1, i2 = t19.spells), "level" in t19 && n2(2, r2 = t19.level);
  }, [o2, i2, r2, a2];
}
class SpellLevelCard extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1E, create_fragment$1D, safe_not_equal, { actor: 0, spells: 1, level: 2 });
  }
}
function create_fragment$1C(t18) {
  let e2, n2, o2, i2, r2, a2, s2, c2, l2, u2;
  const p2 = t18[6].default, d2 = create_slot(p2, t18, t18[5], null);
  return { c() {
    e2 = element("div"), n2 = element("h4"), o2 = text(t18[0]), i2 = space(), r2 = element("div"), a2 = text(t18[1]), s2 = space(), d2 && d2.c(), attr(n2, "class", "details-box-label svelte-mobile-companion-a5e-038vch56tr3-18y0aav"), attr(r2, "class", "details-box-input svelte-mobile-companion-a5e-038vch56tr3-18y0aav"), toggle_class(r2, "highlight", t18[2]), attr(e2, "class", "details-box svelte-mobile-companion-a5e-038vch56tr3-18y0aav"), attr(e2, "aria-hidden", "true"), toggle_class(e2, "outline", t18[4]);
  }, m(p3, m2) {
    insert(p3, e2, m2), append(e2, n2), append(n2, o2), append(e2, i2), append(e2, r2), append(r2, a2), append(r2, s2), d2 && d2.m(r2, null), c2 = true, l2 || (u2 = listen(e2, "click", function() {
      is_function(t18[3]) && t18[3].apply(this, arguments);
    }), l2 = true);
  }, p(n3, [i3]) {
    t18 = n3, (!c2 || 1 & i3) && set_data(o2, t18[0]), (!c2 || 2 & i3) && set_data(a2, t18[1]), d2 && d2.p && (!c2 || 32 & i3) && update_slot_base(d2, p2, t18, t18[5], c2 ? get_slot_changes(p2, t18[5], i3, null) : get_all_dirty_from_scope(t18[5]), null), (!c2 || 4 & i3) && toggle_class(r2, "highlight", t18[2]), (!c2 || 16 & i3) && toggle_class(e2, "outline", t18[4]);
  }, i(t19) {
    c2 || (transition_in(d2, t19), c2 = true);
  }, o(t19) {
    transition_out(d2, t19), c2 = false;
  }, d(t19) {
    t19 && detach(e2), d2 && d2.d(t19), l2 = false, u2();
  } };
}
function instance$1D(t18, e2, n2) {
  let { $$slots: o2 = {}, $$scope: i2 } = e2, { title: r2 } = e2, { value: a2 } = e2, { highlightValue: s2 = true } = e2, { onclick: c2 = () => {
  } } = e2, { isActive: l2 = false } = e2;
  return t18.$$set = (t19) => {
    "title" in t19 && n2(0, r2 = t19.title), "value" in t19 && n2(1, a2 = t19.value), "highlightValue" in t19 && n2(2, s2 = t19.highlightValue), "onclick" in t19 && n2(3, c2 = t19.onclick), "isActive" in t19 && n2(4, l2 = t19.isActive), "$$scope" in t19 && n2(5, i2 = t19.$$scope);
  }, [r2, a2, s2, c2, l2, i2, o2];
}
class DetailsBox extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1D, create_fragment$1C, safe_not_equal, { title: 0, value: 1, highlightValue: 2, onclick: 3, isActive: 4 });
  }
}
function get_each_context$y(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[10] = e2[n2], o2;
}
function create_if_block_1$e(t18) {
  let e2, n2, o2 = [], i2 = /* @__PURE__ */ new Map(), r2 = ensure_array_like(t18[1]);
  const a2 = (t19) => t19[10];
  for (let e3 = 0; e3 < r2.length; e3 += 1) {
    let n3 = get_each_context$y(t18, r2, e3), s2 = a2(n3);
    i2.set(s2, o2[e3] = create_each_block$y(s2, n3));
  }
  return { c() {
    for (let t19 = 0; t19 < o2.length; t19 += 1) o2[t19].c();
    e2 = empty();
  }, m(t19, i3) {
    for (let e3 = 0; e3 < o2.length; e3 += 1) o2[e3] && o2[e3].m(t19, i3);
    insert(t19, e2, i3), n2 = true;
  }, p(t19, n3) {
    2 & n3 && (r2 = ensure_array_like(t19[1]), group_outros(), o2 = update_keyed_each(o2, n3, a2, 1, t19, r2, i2, e2.parentNode, outro_and_destroy_block, create_each_block$y, e2, get_each_context$y), check_outros());
  }, i(t19) {
    if (!n2) {
      for (let t20 = 0; t20 < r2.length; t20 += 1) transition_in(o2[t20]);
      n2 = true;
    }
  }, o(t19) {
    for (let t20 = 0; t20 < o2.length; t20 += 1) transition_out(o2[t20]);
    n2 = false;
  }, d(t19) {
    t19 && detach(e2);
    for (let e3 = 0; e3 < o2.length; e3 += 1) o2[e3].d(t19);
  } };
}
function create_each_block$y(t18, e2) {
  let n2, o2, i2;
  return o2 = new DetailsBox({ props: { title: i18n("A5E.spells.dc"), value: e2[10] } }), { key: t18, first: null, c() {
    n2 = empty(), create_component(o2.$$.fragment), this.first = n2;
  }, m(t19, e3) {
    insert(t19, n2, e3), mount_component(o2, t19, e3), i2 = true;
  }, p(t19, n3) {
    e2 = t19;
    const i3 = {};
    2 & n3 && (i3.value = e2[10]), o2.$set(i3);
  }, i(t19) {
    i2 || (transition_in(o2.$$.fragment, t19), i2 = true);
  }, o(t19) {
    transition_out(o2.$$.fragment, t19), i2 = false;
  }, d(t19) {
    t19 && detach(n2), destroy_component(o2, t19);
  } };
}
function create_if_block$S(t18) {
  let e2, n2;
  return e2 = new DetailsBox({ props: { title: "Concentrating", value: t18[3], onclick: t18[4], highlightValue: true } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    8 & n3 && (o2.value = t19[3]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_fragment$1B(t18) {
  let e2, n2, o2, i2, r2, a2 = t18[1]?.length > 0 && create_if_block_1$e(t18);
  o2 = new DetailsBox({ props: { title: i18n("A5E.spells.prepared"), value: t18[2], onclick: t18[5], highlightValue: true, isActive: t18[0] } });
  let s2 = t18[3] && create_if_block$S(t18);
  return { c() {
    e2 = element("section"), a2 && a2.c(), n2 = space(), create_component(o2.$$.fragment), i2 = space(), s2 && s2.c(), attr(e2, "class", "stats-header svelte-mobile-companion-a5e-038vch56tr3-1lfrtvo");
  }, m(t19, c2) {
    insert(t19, e2, c2), a2 && a2.m(e2, null), append(e2, n2), mount_component(o2, e2, null), append(e2, i2), s2 && s2.m(e2, null), r2 = true;
  }, p(t19, [i3]) {
    t19[1]?.length > 0 ? a2 ? (a2.p(t19, i3), 2 & i3 && transition_in(a2, 1)) : (a2 = create_if_block_1$e(t19), a2.c(), transition_in(a2, 1), a2.m(e2, n2)) : a2 && (group_outros(), transition_out(a2, 1, 1, () => {
      a2 = null;
    }), check_outros());
    const r3 = {};
    4 & i3 && (r3.value = t19[2]), 1 & i3 && (r3.isActive = t19[0]), o2.$set(r3), t19[3] ? s2 ? (s2.p(t19, i3), 8 & i3 && transition_in(s2, 1)) : (s2 = create_if_block$S(t19), s2.c(), transition_in(s2, 1), s2.m(e2, null)) : s2 && (group_outros(), transition_out(s2, 1, 1, () => {
      s2 = null;
    }), check_outros());
  }, i(t19) {
    r2 || (transition_in(a2), transition_in(o2.$$.fragment, t19), transition_in(s2), r2 = true);
  }, o(t19) {
    transition_out(a2), transition_out(o2.$$.fragment, t19), transition_out(s2), r2 = false;
  }, d(t19) {
    t19 && detach(e2), a2 && a2.d(), destroy_component(o2), s2 && s2.d();
  } };
}
function instance$1C(t18, e2, n2) {
  let o2, i2;
  var r2;
  let { spells: a2 } = e2, { filterOnlyPrepared: s2 = false } = e2, { actor: c2 } = e2;
  const l2 = createEventDispatcher();
  let u2 = [];
  return t18.$$set = (t19) => {
    "spells" in t19 && n2(6, a2 = t19.spells), "filterOnlyPrepared" in t19 && n2(0, s2 = t19.filterOnlyPrepared), "actor" in t19 && n2(7, c2 = t19.actor);
  }, t18.$$.update = () => {
    if (128 & t18.$$.dirty && n2(3, o2 = c2.getFlag(getFullModuleId$1(), ActorFlags.concentration)), 320 & t18.$$.dirty && n2(2, i2 = null === n2(8, r2 = a2.filter((t19) => t19.system.prepared === PreparedLevel.Prepared)) || void 0 === r2 ? void 0 : r2.length), 128 & t18.$$.dirty && c2.system.spellBooks) {
      let t19 = [];
      Object.values(c2.system.spellBooks).forEach((e3) => t19.push(e3.stats.dc)), n2(1, u2 = t19);
    }
  }, [s2, u2, i2, o2, function() {
    c2.unsetFlag(getFullModuleId$1(), ActorFlags.concentration), c2.toggleStatusEffect("concentration", { active: false });
  }, function() {
    l2("togglePreparedSpells");
  }, a2, c2, r2];
}
class SpellsHeader extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1C, create_fragment$1B, safe_not_equal, { spells: 6, filterOnlyPrepared: 0, actor: 7 });
  }
}
function get_each_context$x(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[7] = e2[n2], o2;
}
function create_each_block$x(t18) {
  let e2, n2;
  return e2 = new SpellLevelCard({ props: { actor: t18[0], spells: t18[1][t18[7]], level: t18[7] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1 & n3 && (o2.actor = t19[0]), 6 & n3 && (o2.spells = t19[1][t19[7]]), 4 & n3 && (o2.level = t19[7]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_fragment$1A(t18) {
  let e2, n2, o2, i2, r2;
  n2 = new SpellsHeader({ props: { actor: t18[0], spells: t18[4], filterOnlyPrepared: t18[3] } }), n2.$on("togglePreparedSpells", t18[5]);
  let a2 = ensure_array_like(t18[2]), s2 = [];
  for (let e3 = 0; e3 < a2.length; e3 += 1) s2[e3] = create_each_block$x(get_each_context$x(t18, a2, e3));
  const c2 = (t19) => transition_out(s2[t19], 1, 1, () => {
    s2[t19] = null;
  });
  return { c() {
    e2 = element("section"), create_component(n2.$$.fragment), o2 = space(), i2 = element("section");
    for (let t19 = 0; t19 < s2.length; t19 += 1) s2[t19].c();
    attr(i2, "class", "content-scroll-list"), set_style(i2, "position", "relative"), attr(e2, "class", "category-content");
  }, m(t19, a3) {
    insert(t19, e2, a3), mount_component(n2, e2, null), append(e2, o2), append(e2, i2);
    for (let t20 = 0; t20 < s2.length; t20 += 1) s2[t20] && s2[t20].m(i2, null);
    r2 = true;
  }, p(t19, [e3]) {
    const o3 = {};
    if (1 & e3 && (o3.actor = t19[0]), 16 & e3 && (o3.spells = t19[4]), 8 & e3 && (o3.filterOnlyPrepared = t19[3]), n2.$set(o3), 7 & e3) {
      let n3;
      for (a2 = ensure_array_like(t19[2]), n3 = 0; n3 < a2.length; n3 += 1) {
        const o4 = get_each_context$x(t19, a2, n3);
        s2[n3] ? (s2[n3].p(o4, e3), transition_in(s2[n3], 1)) : (s2[n3] = create_each_block$x(o4), s2[n3].c(), transition_in(s2[n3], 1), s2[n3].m(i2, null));
      }
      for (group_outros(), n3 = a2.length; n3 < s2.length; n3 += 1) c2(n3);
      check_outros();
    }
  }, i(t19) {
    if (!r2) {
      transition_in(n2.$$.fragment, t19);
      for (let t20 = 0; t20 < a2.length; t20 += 1) transition_in(s2[t20]);
      r2 = true;
    }
  }, o(t19) {
    transition_out(n2.$$.fragment, t19), s2 = s2.filter(Boolean);
    for (let t20 = 0; t20 < s2.length; t20 += 1) transition_out(s2[t20]);
    r2 = false;
  }, d(t19) {
    t19 && detach(e2), destroy_component(n2), destroy_each(s2, t19);
  } };
}
function instance$1B(t18, e2, n2) {
  let o2, i2, r2, a2, { actor: s2 } = e2, c2 = [];
  return t18.$$set = (t19) => {
    "actor" in t19 && n2(0, s2 = t19.actor);
  }, t18.$$.update = () => {
    if (1 & t18.$$.dirty && n2(4, o2 = s2.itemTypes.spell), 16 & t18.$$.dirty && n2(6, i2 = o2.filter((t19) => t19.system.prepared !== PreparedLevel.NotPrepared)), 88 & t18.$$.dirty) {
      n2(1, a2 = (r2 ? i2 : o2).reduce((t19, e3) => {
        let n3 = e3.system.level;
        return t19[n3] || (t19[n3] = []), t19[n3].push(e3), t19;
      }, {}));
    }
    if (6 & t18.$$.dirty) {
      n2(2, c2 = []);
      for (const t19 in a2) a2[t19].sort((t20, e3) => t20.name.localeCompare(e3.name)), c2.push(parseInt(t19));
    }
  }, n2(3, r2 = "true" === sessionStorage.getItem("a5e.useOnlyPreparedSpells")), [s2, a2, c2, r2, o2, function() {
    n2(3, r2 = !r2), sessionStorage.setItem("a5e.useOnlyPreparedSpells", r2.toString());
  }, i2];
}
class Spells extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1B, create_fragment$1A, safe_not_equal, { actor: 0 });
  }
}
function create_fragment$1z(t18) {
  let e2, n2;
  return e2 = new UseButton({ props: { value: t18[1], max: t18[0], rollData: t18[2].getRollData() } }), e2.$on("update", t18[4]), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, [n3]) {
    const o2 = {};
    2 & n3 && (o2.value = t19[1]), 1 & n3 && (o2.max = t19[0]), 4 & n3 && (o2.rollData = t19[2].getRollData()), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function instance$1A(t18, e2, n2) {
  let o2, i2;
  var r2, a2;
  let { feature: s2 } = e2;
  const c2 = getContext("actorStore");
  let l2;
  return component_subscribe(t18, c2, (t19) => n2(2, i2 = t19)), (null === (a2 = s2.system.uses) || void 0 === a2 ? void 0 : a2.max) && evaluateTotal(s2.system.uses.max, s2.actor.getRollData()).then((t19) => n2(0, l2 = t19)), t18.$$set = (t19) => {
    "feature" in t19 && n2(5, s2 = t19.feature);
  }, t18.$$.update = () => {
    96 & t18.$$.dirty && n2(1, o2 = null === n2(6, r2 = s2.system.uses) || void 0 === r2 ? void 0 : r2.value);
  }, [l2, o2, i2, c2, function(t19) {
    s2.update({ "system.uses.value": t19.detail.newValue });
  }, s2, r2];
}
class FeatureUse extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1A, create_fragment$1z, safe_not_equal, { feature: 5 });
  }
}
function get_each_context$w(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[4] = e2[n2][0], o2[5] = e2[n2][1], o2;
}
function create_if_block$R(t18) {
  let e2, n2, o2 = [], i2 = /* @__PURE__ */ new Map(), r2 = ensure_array_like([...t18[0].actions]);
  const a2 = (t19) => t19[4];
  for (let e3 = 0; e3 < r2.length; e3 += 1) {
    let n3 = get_each_context$w(t18, r2, e3), s2 = a2(n3);
    i2.set(s2, o2[e3] = create_each_block$w(s2, n3));
  }
  return { c() {
    for (let t19 = 0; t19 < o2.length; t19 += 1) o2[t19].c();
    e2 = empty();
  }, m(t19, i3) {
    for (let e3 = 0; e3 < o2.length; e3 += 1) o2[e3] && o2[e3].m(t19, i3);
    insert(t19, e2, i3), n2 = true;
  }, p(t19, n3) {
    3 & n3 && (r2 = ensure_array_like([...t19[0].actions]), group_outros(), o2 = update_keyed_each(o2, n3, a2, 1, t19, r2, i2, e2.parentNode, outro_and_destroy_block, create_each_block$w, e2, get_each_context$w), check_outros());
  }, i(t19) {
    if (!n2) {
      for (let t20 = 0; t20 < r2.length; t20 += 1) transition_in(o2[t20]);
      n2 = true;
    }
  }, o(t19) {
    for (let t20 = 0; t20 < o2.length; t20 += 1) transition_out(o2[t20]);
    n2 = false;
  }, d(t19) {
    t19 && detach(e2);
    for (let e3 = 0; e3 < o2.length; e3 += 1) o2[e3].d(t19);
  } };
}
function create_each_block$w(t18, e2) {
  let n2, o2, i2;
  return o2 = new Action({ props: { action: e2[5], actionId: e2[4], rollData: e2[1] } }), { key: t18, first: null, c() {
    n2 = empty(), create_component(o2.$$.fragment), this.first = n2;
  }, m(t19, e3) {
    insert(t19, n2, e3), mount_component(o2, t19, e3), i2 = true;
  }, p(t19, n3) {
    e2 = t19;
    const i3 = {};
    1 & n3 && (i3.action = e2[5]), 1 & n3 && (i3.actionId = e2[4]), o2.$set(i3);
  }, i(t19) {
    i2 || (transition_in(o2.$$.fragment, t19), i2 = true);
  }, o(t19) {
    transition_out(o2.$$.fragment, t19), i2 = false;
  }, d(t19) {
    t19 && detach(n2), destroy_component(o2, t19);
  } };
}
function create_fragment$1y(t18) {
  let e2, n2, o2, i2 = t18[3]?.size > 0 && create_if_block$R(t18);
  return n2 = new Description({ props: { description: t18[2] } }), { c() {
    i2 && i2.c(), e2 = space(), create_component(n2.$$.fragment);
  }, m(t19, r2) {
    i2 && i2.m(t19, r2), insert(t19, e2, r2), mount_component(n2, t19, r2), o2 = true;
  }, p(t19, [e3]) {
    t19[3]?.size > 0 && i2.p(t19, e3);
  }, i(t19) {
    o2 || (transition_in(i2), transition_in(n2.$$.fragment, t19), o2 = true);
  }, o(t19) {
    transition_out(i2), transition_out(n2.$$.fragment, t19), o2 = false;
  }, d(t19) {
    t19 && detach(e2), i2 && i2.d(t19), destroy_component(n2, t19);
  } };
}
function instance$1z(t18, e2, n2) {
  let { feature: o2 } = e2;
  const i2 = o2.getRollData(), r2 = o2.system.description;
  let a2 = o2.actions;
  return t18.$$set = (t19) => {
    "feature" in t19 && n2(0, o2 = t19.feature);
  }, [o2, i2, r2, a2];
}
class FeatureBaseInfo extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1z, create_fragment$1y, safe_not_equal, { feature: 0 });
  }
}
function create_fragment$1x(t18) {
  let e2, n2, o2, i2;
  return e2 = new Effects({ props: { item: t18[0] } }), o2 = new FeatureBaseInfo({ props: { feature: t18[0] } }), { c() {
    create_component(e2.$$.fragment), n2 = space(), create_component(o2.$$.fragment);
  }, m(t19, r2) {
    mount_component(e2, t19, r2), insert(t19, n2, r2), mount_component(o2, t19, r2), i2 = true;
  }, p(t19, [n3]) {
    const i3 = {};
    1 & n3 && (i3.item = t19[0]), e2.$set(i3);
    const r2 = {};
    1 & n3 && (r2.feature = t19[0]), o2.$set(r2);
  }, i(t19) {
    i2 || (transition_in(e2.$$.fragment, t19), transition_in(o2.$$.fragment, t19), i2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), transition_out(o2.$$.fragment, t19), i2 = false;
  }, d(t19) {
    t19 && detach(n2), destroy_component(e2, t19), destroy_component(o2, t19);
  } };
}
function instance$1y(t18, e2, n2) {
  let { feature: o2 } = e2;
  return t18.$$set = (t19) => {
    "feature" in t19 && n2(0, o2 = t19.feature);
  }, [o2];
}
class FeatureDetails extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1y, create_fragment$1x, safe_not_equal, { feature: 0 });
  }
}
function create_right_content_slot$3(t18) {
  let e2, n2, o2;
  return n2 = new FeatureUse({ props: { feature: t18[0] } }), { c() {
    e2 = element("div"), create_component(n2.$$.fragment), attr(e2, "class", "right svelte-mobile-companion-a5e-038vch56tr3-1wa3gju"), attr(e2, "slot", "right-content");
  }, m(t19, i2) {
    insert(t19, e2, i2), mount_component(n2, e2, null), o2 = true;
  }, p(t19, e3) {
    const o3 = {};
    1 & e3 && (o3.feature = t19[0]), n2.$set(o3);
  }, i(t19) {
    o2 || (transition_in(n2.$$.fragment, t19), o2 = true);
  }, o(t19) {
    transition_out(n2.$$.fragment, t19), o2 = false;
  }, d(t19) {
    t19 && detach(e2), destroy_component(n2);
  } };
}
function create_if_block$Q(t18) {
  let e2, n2;
  return e2 = new ActivationCostBadge({ props: { action: t18[1] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p: noop$4, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_name_badge_slot$2(t18) {
  let e2, n2, o2 = t18[1] && create_if_block$Q(t18);
  return { c() {
    e2 = element("div"), o2 && o2.c(), attr(e2, "slot", "name-badge");
  }, m(t19, i2) {
    insert(t19, e2, i2), o2 && o2.m(e2, null), n2 = true;
  }, p(t19, e3) {
    t19[1] && o2.p(t19, e3);
  }, i(t19) {
    n2 || (transition_in(o2), n2 = true);
  }, o(t19) {
    transition_out(o2), n2 = false;
  }, d(t19) {
    t19 && detach(e2), o2 && o2.d();
  } };
}
function create_default_slot$j(t18) {
  let e2, n2;
  return e2 = new ToggleFavoriteButton({ props: { item: t18[0] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1 & n3 && (o2.item = t19[0]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_details_slot$4(t18) {
  let e2, n2, o2, i2, r2;
  return n2 = new StateButtons({ props: { $$slots: { default: [create_default_slot$j] }, $$scope: { ctx: t18 } } }), i2 = new FeatureDetails({ props: { feature: t18[0] } }), { c() {
    e2 = element("div"), create_component(n2.$$.fragment), o2 = space(), create_component(i2.$$.fragment), attr(e2, "slot", "details");
  }, m(t19, a2) {
    insert(t19, e2, a2), mount_component(n2, e2, null), append(e2, o2), mount_component(i2, e2, null), r2 = true;
  }, p(t19, e3) {
    const o3 = {};
    9 & e3 && (o3.$$scope = { dirty: e3, ctx: t19 }), n2.$set(o3);
    const r3 = {};
    1 & e3 && (r3.feature = t19[0]), i2.$set(r3);
  }, i(t19) {
    r2 || (transition_in(n2.$$.fragment, t19), transition_in(i2.$$.fragment, t19), r2 = true);
  }, o(t19) {
    transition_out(n2.$$.fragment, t19), transition_out(i2.$$.fragment, t19), r2 = false;
  }, d(t19) {
    t19 && detach(e2), destroy_component(n2), destroy_component(i2);
  } };
}
function create_fragment$1w(t18) {
  let e2, n2;
  return e2 = new ToggleableListEntry({ props: { name: t18[0].name, imageSrc: t18[0].img, isFavorite: t18[0].system.favorite, $$slots: { details: [create_details_slot$4], "name-badge": [create_name_badge_slot$2], "right-content": [create_right_content_slot$3] }, $$scope: { ctx: t18 } } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, [n3]) {
    const o2 = {};
    1 & n3 && (o2.name = t19[0].name), 1 & n3 && (o2.imageSrc = t19[0].img), 1 & n3 && (o2.isFavorite = t19[0].system.favorite), 9 & n3 && (o2.$$scope = { dirty: n3, ctx: t19 }), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function instance$1x(t18, e2, n2) {
  var o2;
  let { feature: i2 } = e2;
  const r2 = null === (o2 = i2.actions) || void 0 === o2 ? void 0 : o2.default;
  return t18.$$set = (t19) => {
    "feature" in t19 && n2(0, i2 = t19.feature);
  }, [i2, r2];
}
class Feature extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1x, create_fragment$1w, safe_not_equal, { feature: 0 });
  }
}
function get_each_context$v(t18, e2, n2) {
  const o2 = t18.slice();
  return o2[2] = e2[n2], o2;
}
function create_header_addons_slot$1(t18) {
  let e2;
  return { c() {
    e2 = element("span"), e2.textContent = `${i18n("A5E.consumers.uses.title")}`, attr(e2, "slot", "header-addons"), attr(e2, "class", "section-header-uses svelte-mobile-companion-a5e-038vch56tr3-1xhy2l5");
  }, m(t19, n2) {
    insert(t19, e2, n2);
  }, p: noop$4, d(t19) {
    t19 && detach(e2);
  } };
}
function create_each_block$v(t18) {
  let e2, n2;
  return e2 = new Feature({ props: { feature: t18[2] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    2 & n3 && (o2.feature = t19[2]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_section_content_slot$i(t18) {
  let e2, n2, o2 = ensure_array_like(t18[1]), i2 = [];
  for (let e3 = 0; e3 < o2.length; e3 += 1) i2[e3] = create_each_block$v(get_each_context$v(t18, o2, e3));
  const r2 = (t19) => transition_out(i2[t19], 1, 1, () => {
    i2[t19] = null;
  });
  return { c() {
    e2 = element("div");
    for (let t19 = 0; t19 < i2.length; t19 += 1) i2[t19].c();
    attr(e2, "slot", "section-content");
  }, m(t19, o3) {
    insert(t19, e2, o3);
    for (let t20 = 0; t20 < i2.length; t20 += 1) i2[t20] && i2[t20].m(e2, null);
    n2 = true;
  }, p(t19, n3) {
    if (2 & n3) {
      let a2;
      for (o2 = ensure_array_like(t19[1]), a2 = 0; a2 < o2.length; a2 += 1) {
        const r3 = get_each_context$v(t19, o2, a2);
        i2[a2] ? (i2[a2].p(r3, n3), transition_in(i2[a2], 1)) : (i2[a2] = create_each_block$v(r3), i2[a2].c(), transition_in(i2[a2], 1), i2[a2].m(e2, null));
      }
      for (group_outros(), a2 = o2.length; a2 < i2.length; a2 += 1) r2(a2);
      check_outros();
    }
  }, i(t19) {
    if (!n2) {
      for (let t20 = 0; t20 < o2.length; t20 += 1) transition_in(i2[t20]);
      n2 = true;
    }
  }, o(t19) {
    i2 = i2.filter(Boolean);
    for (let t20 = 0; t20 < i2.length; t20 += 1) transition_out(i2[t20]);
    n2 = false;
  }, d(t19) {
    t19 && detach(e2), destroy_each(i2, t19);
  } };
}
function create_fragment$1v(t18) {
  let e2, n2;
  return e2 = new Category({ props: { title: t18[0], $$slots: { "section-content": [create_section_content_slot$i], "header-addons": [create_header_addons_slot$1] }, $$scope: { ctx: t18 } } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, [n3]) {
    const o2 = {};
    1 & n3 && (o2.title = t19[0]), 34 & n3 && (o2.$$scope = { dirty: n3, ctx: t19 }), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function instance$1w(t18, e2, n2) {
  let { sectionName: o2 } = e2, { features: i2 } = e2;
  return t18.$$set = (t19) => {
    "sectionName" in t19 && n2(0, o2 = t19.sectionName), "features" in t19 && n2(1, i2 = t19.features);
  }, [o2, i2];
}
class FeaturesContainer extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1w, create_fragment$1v, safe_not_equal, { sectionName: 0, features: 1 });
  }
}
function create_if_block$P(t18) {
  let e2, n2;
  return e2 = new FeaturesContainer({ props: { sectionName: i18n("A5E.features.types.class"), features: t18[0] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1 & n3 && (o2.features = t19[0]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_fragment$1u(t18) {
  let e2, n2, o2 = t18[0]?.length > 0 && create_if_block$P(t18);
  return { c() {
    o2 && o2.c(), e2 = empty();
  }, m(t19, i2) {
    o2 && o2.m(t19, i2), insert(t19, e2, i2), n2 = true;
  }, p(t19, [n3]) {
    t19[0]?.length > 0 ? o2 ? (o2.p(t19, n3), 1 & n3 && transition_in(o2, 1)) : (o2 = create_if_block$P(t19), o2.c(), transition_in(o2, 1), o2.m(e2.parentNode, e2)) : o2 && (group_outros(), transition_out(o2, 1, 1, () => {
      o2 = null;
    }), check_outros());
  }, i(t19) {
    n2 || (transition_in(o2), n2 = true);
  }, o(t19) {
    transition_out(o2), n2 = false;
  }, d(t19) {
    t19 && detach(e2), o2 && o2.d(t19);
  } };
}
function instance$1v(t18, e2, n2) {
  let o2, { actor: i2 } = e2;
  return t18.$$set = (t19) => {
    "actor" in t19 && n2(1, i2 = t19.actor);
  }, t18.$$.update = () => {
    if (2 & t18.$$.dirty) {
      const t19 = [];
      t19.push(...i2.itemTypes.class), t19.push(...i2.itemTypes.archetype);
      const e3 = i2.itemTypes.feature.filter((t20) => "class" === t20.system.featureType);
      t19.push(...e3), t19.sort((t20, e4) => t20.name.localeCompare(e4.name)), n2(0, o2 = t19);
    }
  }, [o2, i2];
}
class ClassFeatures extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1v, create_fragment$1u, safe_not_equal, { actor: 1 });
  }
}
function create_if_block$O(t18) {
  let e2, n2;
  return e2 = new FeaturesContainer({ props: { sectionName: i18n("A5E.features.types.heritage"), features: t18[0] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1 & n3 && (o2.features = t19[0]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_fragment$1t(t18) {
  let e2, n2, o2 = t18[0]?.length > 0 && create_if_block$O(t18);
  return { c() {
    o2 && o2.c(), e2 = empty();
  }, m(t19, i2) {
    o2 && o2.m(t19, i2), insert(t19, e2, i2), n2 = true;
  }, p(t19, [n3]) {
    t19[0]?.length > 0 ? o2 ? (o2.p(t19, n3), 1 & n3 && transition_in(o2, 1)) : (o2 = create_if_block$O(t19), o2.c(), transition_in(o2, 1), o2.m(e2.parentNode, e2)) : o2 && (group_outros(), transition_out(o2, 1, 1, () => {
      o2 = null;
    }), check_outros());
  }, i(t19) {
    n2 || (transition_in(o2), n2 = true);
  }, o(t19) {
    transition_out(o2), n2 = false;
  }, d(t19) {
    t19 && detach(e2), o2 && o2.d(t19);
  } };
}
function instance$1u(t18, e2, n2) {
  let o2, { actor: i2 } = e2;
  return t18.$$set = (t19) => {
    "actor" in t19 && n2(1, i2 = t19.actor);
  }, t18.$$.update = () => {
    if (2 & t18.$$.dirty) {
      const t19 = [];
      t19.push(...i2.itemTypes.heritage);
      const e3 = i2.itemTypes.feature.filter((t20) => "heritage" === t20.system.featureType);
      t19.push(...e3), t19.sort((t20, e4) => t20.name.localeCompare(e4.name)), n2(0, o2 = t19);
    }
  }, [o2, i2];
}
class HeritageFeatures extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1u, create_fragment$1t, safe_not_equal, { actor: 1 });
  }
}
function create_if_block$N(t18) {
  let e2, n2;
  return e2 = new FeaturesContainer({ props: { sectionName: i18n("A5E.features.types.culture"), features: t18[0] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1 & n3 && (o2.features = t19[0]), e2.$set(o2);
  }, i(t19) {
    n2 || (transition_in(e2.$$.fragment, t19), n2 = true);
  }, o(t19) {
    transition_out(e2.$$.fragment, t19), n2 = false;
  }, d(t19) {
    destroy_component(e2, t19);
  } };
}
function create_fragment$1s(t18) {
  let e2, n2, o2 = t18[0]?.length > 0 && create_if_block$N(t18);
  return { c() {
    o2 && o2.c(), e2 = empty();
  }, m(t19, i2) {
    o2 && o2.m(t19, i2), insert(t19, e2, i2), n2 = true;
  }, p(t19, [n3]) {
    t19[0]?.length > 0 ? o2 ? (o2.p(t19, n3), 1 & n3 && transition_in(o2, 1)) : (o2 = create_if_block$N(t19), o2.c(), transition_in(o2, 1), o2.m(e2.parentNode, e2)) : o2 && (group_outros(), transition_out(o2, 1, 1, () => {
      o2 = null;
    }), check_outros());
  }, i(t19) {
    n2 || (transition_in(o2), n2 = true);
  }, o(t19) {
    transition_out(o2), n2 = false;
  }, d(t19) {
    t19 && detach(e2), o2 && o2.d(t19);
  } };
}
function instance$1t(t18, e2, n2) {
  let o2, { actor: i2 } = e2;
  return t18.$$set = (t19) => {
    "actor" in t19 && n2(1, i2 = t19.actor);
  }, t18.$$.update = () => {
    if (2 & t18.$$.dirty) {
      const t19 = [];
      t19.push(...i2.itemTypes.culture);
      const e3 = i2.itemTypes.feature.filter((t20) => "culture" === t20.system.featureType);
      t19.push(...e3), t19.sort((t20, e4) => t20.name.localeCompare(e4.name)), n2(0, o2 = t19);
    }
  }, [o2, i2];
}
class CultureFeatures extends SvelteComponent {
  constructor(t18) {
    super(), init(this, t18, instance$1t, create_fragment$1s, safe_not_equal, { actor: 1 });
  }
}
function create_if_block$M(t18) {
  let e2, n2;
  return e2 = new FeaturesContainer({ props: { sectionName: i18n("A5E.features.types.background"), features: t18[0] } }), { c() {
    create_component(e2.$$.fragment);
  }, m(t19, o2) {
    mount_component(e2, t19, o2), n2 = true;
  }, p(t19, n3) {
    const o2 = {};
    1 & n3 && (o2.features 