function noop() {
}
const identity = (t3) => t3;
function assign(t3, e) {
  for (const n in e) t3[n] = e[n];
  return t3;
}
function is_promise(t3) {
  return !!t3 && ("object" == typeof t3 || "function" == typeof t3) && "function" == typeof t3.then;
}
function run(t3) {
  return t3();
}
function blank_object() {
  return /* @__PURE__ */ Object.create(null);
}
function run_all(t3) {
  t3.forEach(run);
}
function is_function(t3) {
  return "function" == typeof t3;
}
function safe_not_equal(t3, e) {
  return t3 != t3 ? e == e : t3 !== e || t3 && "object" == typeof t3 || "function" == typeof t3;
}
let src_url_equal_anchor;
function src_url_equal(t3, e) {
  return t3 === e || (src_url_equal_anchor || (src_url_equal_anchor = document.createElement("a")), src_url_equal_anchor.href = e, t3 === src_url_equal_anchor.href);
}
function is_empty(t3) {
  return 0 === Object.keys(t3).length;
}
function subscribe(t3, ...e) {
  if (null == t3) {
    for (const t4 of e) t4(void 0);
    return noop;
  }
  const n = t3.subscribe(...e);
  return n.unsubscribe ? () => n.unsubscribe() : n;
}
function get_store_value(t3) {
  let e;
  return subscribe(t3, (t4) => e = t4)(), e;
}
function component_subscribe(t3, e, n) {
  t3.$$.on_destroy.push(subscribe(e, n));
}
function create_slot(t3, e, n, i) {
  if (t3) {
    const o = get_slot_context(t3, e, n, i);
    return t3[0](o);
  }
}
function get_slot_context(t3, e, n, i) {
  return t3[1] && i ? assign(n.ctx.slice(), t3[1](i(e))) : n.ctx;
}
function get_slot_changes(t3, e, n, i) {
  if (t3[2] && i) {
    const o = t3[2](i(n));
    if (void 0 === e.dirty) return o;
    if ("object" == typeof o) {
      const t4 = [], n2 = Math.max(e.dirty.length, o.length);
      for (let i2 = 0; i2 < n2; i2 += 1) t4[i2] = e.dirty[i2] | o[i2];
      return t4;
    }
    return e.dirty | o;
  }
  return e.dirty;
}
function update_slot_base(t3, e, n, i, o, r) {
  if (o) {
    const s = get_slot_context(e, n, i, r);
    t3.p(s, o);
  }
}
function get_all_dirty_from_scope(t3) {
  if (t3.ctx.length > 32) {
    const e = [], n = t3.ctx.length / 32;
    for (let t4 = 0; t4 < n; t4++) e[t4] = -1;
    return e;
  }
  return -1;
}
function null_to_empty(t3) {
  return null == t3 ? "" : t3;
}
function action_destroyer(t3) {
  return t3 && is_function(t3.destroy) ? t3.destroy : noop;
}
const is_client = "undefined" != typeof window;
let now = is_client ? () => window.performance.now() : () => Date.now(), raf = is_client ? (t3) => requestAnimationFrame(t3) : noop;
const tasks = /* @__PURE__ */ new Set();
function run_tasks(t3) {
  tasks.forEach((e) => {
    e.c(t3) || (tasks.delete(e), e.f());
  }), 0 !== tasks.size && raf(run_tasks);
}
function loop(t3) {
  let e;
  return 0 === tasks.size && raf(run_tasks), { promise: new Promise((n) => {
    tasks.add(e = { c: t3, f: n });
  }), abort() {
    tasks.delete(e);
  } };
}
function append(t3, e) {
  t3.appendChild(e);
}
function get_root_for_style(t3) {
  if (!t3) return document;
  const e = t3.getRootNode ? t3.getRootNode() : t3.ownerDocument;
  return e && e.host ? e : t3.ownerDocument;
}
function append_empty_stylesheet(t3) {
  const e = element("style");
  return e.textContent = "/* empty */", append_stylesheet(get_root_for_style(t3), e), e.sheet;
}
function append_stylesheet(t3, e) {
  return append(t3.head || t3, e), e.sheet;
}
function insert(t3, e, n) {
  t3.insertBefore(e, n || null);
}
function detach(t3) {
  t3.parentNode && t3.parentNode.removeChild(t3);
}
function destroy_each(t3, e) {
  for (let n = 0; n < t3.length; n += 1) t3[n] && t3[n].d(e);
}
function element(t3) {
  return document.createElement(t3);
}
function svg_element(t3) {
  return document.createElementNS("http://www.w3.org/2000/svg", t3);
}
function text(t3) {
  return document.createTextNode(t3);
}
function space() {
  return text(" ");
}
function empty() {
  return text("");
}
function listen(t3, e, n, i) {
  return t3.addEventListener(e, n, i), () => t3.removeEventListener(e, n, i);
}
function prevent_default(t3) {
  return function(e) {
    return e.preventDefault(), t3.call(this, e);
  };
}
function stop_propagation(t3) {
  return function(e) {
    return e.stopPropagation(), t3.call(this, e);
  };
}
function attr(t3, e, n) {
  null == n ? t3.removeAttribute(e) : t3.getAttribute(e) !== n && t3.setAttribute(e, n);
}
function to_number(t3) {
  return "" === t3 ? null : +t3;
}
function children(t3) {
  return Array.from(t3.childNodes);
}
function set_data(t3, e) {
  e = "" + e, t3.data !== e && (t3.data = e);
}
function set_input_value(t3, e) {
  t3.value = null == e ? "" : e;
}
function set_style(t3, e, n, i) {
  null == n ? t3.style.removeProperty(e) : t3.style.setProperty(e, n, "");
}
function toggle_class(t3, e, n) {
  t3.classList.toggle(e, !!n);
}
function custom_event(t3, e, { bubbles: n = false, cancelable: i = false } = {}) {
  return new CustomEvent(t3, { detail: e, bubbles: n, cancelable: i });
}
class HtmlTag {
  is_svg = false;
  e = void 0;
  n = void 0;
  t = void 0;
  a = void 0;
  constructor(t3 = false) {
    this.is_svg = t3, this.e = this.n = null;
  }
  c(t3) {
    this.h(t3);
  }
  m(t3, e, n = null) {
    this.e || (this.is_svg ? this.e = svg_element(e.nodeName) : this.e = element(11 === e.nodeType ? "TEMPLATE" : e.nodeName), this.t = "TEMPLATE" !== e.tagName ? e : e.content, this.c(t3)), this.i(n);
  }
  h(t3) {
    this.e.innerHTML = t3, this.n = Array.from("TEMPLATE" === this.e.nodeName ? this.e.content.childNodes : this.e.childNodes);
  }
  i(t3) {
    for (let e = 0; e < this.n.length; e += 1) insert(this.t, this.n[e], t3);
  }
  p(t3) {
    this.d(), this.h(t3), this.i(this.a);
  }
  d() {
    this.n.forEach(detach);
  }
}
function construct_svelte_component(t3, e) {
  return new t3(e);
}
const managed_styles = /* @__PURE__ */ new Map();
let active = 0, current_component;
function hash(t3) {
  let e = 5381, n = t3.length;
  for (; n--; ) e = (e << 5) - e ^ t3.charCodeAt(n);
  return e >>> 0;
}
function create_style_information(t3, e) {
  const n = { stylesheet: append_empty_stylesheet(e), rules: {} };
  return managed_styles.set(t3, n), n;
}
function create_rule(t3, e, n, i, o, r, s, a = 0) {
  const c = 16.666 / i;
  let l = "{\n";
  for (let t4 = 0; t4 <= 1; t4 += c) {
    const i2 = e + (n - e) * r(t4);
    l += 100 * t4 + `%{${s(i2, 1 - i2)}}
`;
  }
  const p = l + `100% {${s(n, 1 - n)}}
}`, u = `__svelte_${hash(p)}_${a}`, d = get_root_for_style(t3), { stylesheet: m, rules: h } = managed_styles.get(d) || create_style_information(d, t3);
  h[u] || (h[u] = true, m.insertRule(`@keyframes ${u} ${p}`, m.cssRules.length));
  const f = t3.style.animation || "";
  return t3.style.animation = `${f ? `${f}, ` : ""}${u} ${i}ms linear ${o}ms 1 both`, active += 1, u;
}
function delete_rule(t3, e) {
  const n = (t3.style.animation || "").split(", "), i = n.filter(e ? (t4) => t4.indexOf(e) < 0 : (t4) => -1 === t4.indexOf("__svelte")), o = n.length - i.length;
  o && (t3.style.animation = i.join(", "), active -= o, active || clear_rules());
}
function clear_rules() {
  raf(() => {
    active || (managed_styles.forEach((t3) => {
      const { ownerNode: e } = t3.stylesheet;
      e && detach(e);
    }), managed_styles.clear());
  });
}
function set_current_component(t3) {
  current_component = t3;
}
function get_current_component() {
  if (!current_component) throw new Error("Function called outside component initialization");
  return current_component;
}
function onMount(t3) {
  get_current_component().$$.on_mount.push(t3);
}
function onDestroy(t3) {
  get_current_component().$$.on_destroy.push(t3);
}
function createEventDispatcher() {
  const t3 = get_current_component();
  return (e, n, { cancelable: i = false } = {}) => {
    const o = t3.$$.callbacks[e];
    if (o) {
      const r = custom_event(e, n, { cancelable: i });
      return o.slice().forEach((e2) => {
        e2.call(t3, r);
      }), !r.defaultPrevented;
    }
    return true;
  };
}
function setContext(t3, e) {
  return get_current_component().$$.context.set(t3, e), e;
}
function getContext(t3) {
  return get_current_component().$$.context.get(t3);
}
const dirty_components = [], binding_callbacks = [];
let render_callbacks = [];
const flush_callbacks = [], resolved_promise = Promise.resolve();
let update_scheduled = false;
function schedule_update() {
  update_scheduled || (update_scheduled = true, resolved_promise.then(flush));
}
function add_render_callback(t3) {
  render_callbacks.push(t3);
}
function add_flush_callback(t3) {
  flush_callbacks.push(t3);
}
const seen_callbacks = /* @__PURE__ */ new Set();
let flushidx = 0, promise;
function flush() {
  if (0 !== flushidx) return;
  const t3 = current_component;
  do {
    try {
      for (; flushidx < dirty_components.length; ) {
        const t4 = dirty_components[flushidx];
        flushidx++, set_current_component(t4), update(t4.$$);
      }
    } catch (t4) {
      throw dirty_components.length = 0, flushidx = 0, t4;
    }
    for (set_current_component(null), dirty_components.length = 0, flushidx = 0; binding_callbacks.length; ) binding_callbacks.pop()();
    for (let t4 = 0; t4 < render_callbacks.length; t4 += 1) {
      const e = render_callbacks[t4];
      seen_callbacks.has(e) || (seen_callbacks.add(e), e());
    }
    render_callbacks.length = 0;
  } while (dirty_components.length);
  for (; flush_callbacks.length; ) flush_callbacks.pop()();
  update_scheduled = false, seen_callbacks.clear(), set_current_component(t3);
}
function update(t3) {
  if (null !== t3.fragment) {
    t3.update(), run_all(t3.before_update);
    const e = t3.dirty;
    t3.dirty = [-1], t3.fragment && t3.fragment.p(t3.ctx, e), t3.after_update.forEach(add_render_callback);
  }
}
function flush_render_callbacks(t3) {
  const e = [], n = [];
  render_callbacks.forEach((i) => -1 === t3.indexOf(i) ? e.push(i) : n.push(i)), n.forEach((t4) => t4()), render_callbacks = e;
}
function wait() {
  return promise || (promise = Promise.resolve(), promise.then(() => {
    promise = null;
  })), promise;
}
function dispatch(t3, e, n) {
  t3.dispatchEvent(custom_event(`${e ? "intro" : "outro"}${n}`));
}
const outroing = /* @__PURE__ */ new Set();
let outros;
function group_outros() {
  outros = { r: 0, c: [], p: outros };
}
function check_outros() {
  outros.r || run_all(outros.c), outros = outros.p;
}
function transition_in(t3, e) {
  t3 && t3.i && (outroing.delete(t3), t3.i(e));
}
function transition_out(t3, e, n, i) {
  if (t3 && t3.o) {
    if (outroing.has(t3)) return;
    outroing.add(t3), outros.c.push(() => {
      outroing.delete(t3), i && (n && t3.d(1), i());
    }), t3.o(e);
  } else i && i();
}
const null_transition = { duration: 0 };
function create_in_transition(t3, e, n) {
  const i = { direction: "in" };
  let o, r, s = e(t3, n, i), a = false, c = 0;
  function l() {
    o && delete_rule(t3, o);
  }
  function p() {
    const { delay: e2 = 0, duration: n2 = 300, easing: i2 = identity, tick: p2 = noop, css: u2 } = s || null_transition;
    u2 && (o = create_rule(t3, 0, 1, n2, e2, i2, u2, c++)), p2(0, 1);
    const d = now() + e2, m = d + n2;
    r && r.abort(), a = true, add_render_callback(() => dispatch(t3, true, "start")), r = loop((e3) => {
      if (a) {
        if (e3 >= m) return p2(1, 0), dispatch(t3, true, "end"), l(), a = false;
        if (e3 >= d) {
          const t4 = i2((e3 - d) / n2);
          p2(t4, 1 - t4);
        }
      }
      return a;
    });
  }
  let u = false;
  return { start() {
    u || (u = true, delete_rule(t3), is_function(s) ? (s = s(i), wait().then(p)) : p());
  }, invalidate() {
    u = false;
  }, end() {
    a && (l(), a = false);
  } };
}
function create_out_transition(t3, e, n) {
  const i = { direction: "out" };
  let o, r = e(t3, n, i), s = true;
  const a = outros;
  let c;
  function l() {
    const { delay: e2 = 0, duration: n2 = 300, easing: i2 = identity, tick: l2 = noop, css: p } = r || null_transition;
    p && (o = create_rule(t3, 1, 0, n2, e2, i2, p));
    const u = now() + e2, d = u + n2;
    add_render_callback(() => dispatch(t3, false, "start")), "inert" in t3 && (c = t3.inert, t3.inert = true), loop((e3) => {
      if (s) {
        if (e3 >= d) return l2(0, 1), dispatch(t3, false, "end"), --a.r || run_all(a.c), false;
        if (e3 >= u) {
          const t4 = i2((e3 - u) / n2);
          l2(1 - t4, t4);
        }
      }
      return s;
    });
  }
  return a.r += 1, is_function(r) ? wait().then(() => {
    r = r(i), l();
  }) : l(), { end(e2) {
    e2 && "inert" in t3 && (t3.inert = c), e2 && r.tick && r.tick(1, 0), s && (o && delete_rule(t3, o), s = false);
  } };
}
function create_bidirectional_transition(t3, e, n, i) {
  let o, r = e(t3, n, { direction: "both" }), s = i ? 0 : 1, a = null, c = null, l = null;
  function p() {
    l && delete_rule(t3, l);
  }
  function u(t4, e2) {
    const n2 = t4.b - s;
    return e2 *= Math.abs(n2), { a: s, b: t4.b, d: n2, duration: e2, start: t4.start, end: t4.start + e2, group: t4.group };
  }
  function d(e2) {
    const { delay: n2 = 0, duration: i2 = 300, easing: d2 = identity, tick: m = noop, css: h } = r || null_transition, f = { start: now() + n2, b: e2 };
    e2 || (f.group = outros, outros.r += 1), "inert" in t3 && (e2 ? void 0 !== o && (t3.inert = o) : (o = t3.inert, t3.inert = true)), a || c ? c = f : (h && (p(), l = create_rule(t3, s, e2, i2, n2, d2, h)), e2 && m(0, 1), a = u(f, i2), add_render_callback(() => dispatch(t3, e2, "start")), loop((e3) => {
      if (c && e3 > c.start && (a = u(c, i2), c = null, dispatch(t3, a.b, "start"), h && (p(), l = create_rule(t3, s, a.b, a.duration, 0, d2, r.css))), a) {
        if (e3 >= a.end) m(s = a.b, 1 - s), dispatch(t3, a.b, "end"), c || (a.b ? p() : --a.group.r || run_all(a.group.c)), a = null;
        else if (e3 >= a.start) {
          const t4 = e3 - a.start;
          s = a.a + a.d * d2(t4 / a.duration), m(s, 1 - s);
        }
      }
      return !(!a && !c);
    }));
  }
  return { run(t4) {
    is_function(r) ? wait().then(() => {
      r = r({ direction: t4 ? "in" : "out" }), d(t4);
    }) : d(t4);
  }, end() {
    p(), a = c = null;
  } };
}
function handle_promise(t3, e) {
  const n = e.token = {};
  function i(t4, i2, o, r) {
    if (e.token !== n) return;
    e.resolved = r;
    let s = e.ctx;
    void 0 !== o && (s = s.slice(), s[o] = r);
    const a = t4 && (e.current = t4)(s);
    let c = false;
    e.block && (e.blocks ? e.blocks.forEach((t5, n2) => {
      n2 !== i2 && t5 && (group_outros(), transition_out(t5, 1, 1, () => {
        e.blocks[n2] === t5 && (e.blocks[n2] = null);
      }), check_outros());
    }) : e.block.d(1), a.c(), transition_in(a, 1), a.m(e.mount(), e.anchor), c = true), e.block = a, e.blocks && (e.blocks[i2] = a), c && flush();
  }
  if (is_promise(t3)) {
    const n2 = get_current_component();
    if (t3.then((t4) => {
      set_current_component(n2), i(e.then, 1, e.value, t4), set_current_component(null);
    }, (t4) => {
      if (set_current_component(n2), i(e.catch, 2, e.error, t4), set_current_component(null), !e.hasCatch) throw t4;
    }), e.current !== e.pending) return i(e.pending, 0), true;
  } else {
    if (e.current !== e.then) return i(e.then, 1, e.value, t3), true;
    e.resolved = t3;
  }
}
function update_await_block_branch(t3, e, n) {
  const i = e.slice(), { resolved: o } = t3;
  t3.current === t3.then && (i[t3.value] = o), t3.current === t3.catch && (i[t3.error] = o), t3.block.p(i, n);
}
function ensure_array_like(t3) {
  return void 0 !== t3?.length ? t3 : Array.from(t3);
}
function destroy_block(t3, e) {
  t3.d(1), e.delete(t3.key);
}
function outro_and_destroy_block(t3, e) {
  transition_out(t3, 1, 1, () => {
    e.delete(t3.key);
  });
}
function update_keyed_each(t3, e, n, i, o, r, s, a, c, l, p, u) {
  let d = t3.length, m = r.length, h = d;
  const f = {};
  for (; h--; ) f[t3[h].key] = h;
  const g = [], _ = /* @__PURE__ */ new Map(), b = /* @__PURE__ */ new Map(), y = [];
  for (h = m; h--; ) {
    const t4 = u(o, r, h), i2 = n(t4);
    let a2 = s.get(i2);
    a2 ? y.push(() => a2.p(t4, e)) : (a2 = l(i2, t4), a2.c()), _.set(i2, g[h] = a2), i2 in f && b.set(i2, Math.abs(h - f[i2]));
  }
  const v = /* @__PURE__ */ new Set(), $2 = /* @__PURE__ */ new Set();
  function T(t4) {
    transition_in(t4, 1), t4.m(a, p), s.set(t4.key, t4), p = t4.first, m--;
  }
  for (; d && m; ) {
    const e2 = g[m - 1], n2 = t3[d - 1], i2 = e2.key, o2 = n2.key;
    e2 === n2 ? (p = e2.first, d--, m--) : _.has(o2) ? !s.has(i2) || v.has(i2) ? T(e2) : $2.has(o2) ? d-- : b.get(i2) > b.get(o2) ? ($2.add(i2), T(e2)) : (v.add(o2), d--) : (c(n2, s), d--);
  }
  for (; d--; ) {
    const e2 = t3[d];
    _.has(e2.key) || c(e2, s);
  }
  for (; m; ) T(g[m - 1]);
  return run_all(y), g;
}
function get_spread_update(t3, e) {
  const n = {}, i = {}, o = { $$scope: 1 };
  let r = t3.length;
  for (; r--; ) {
    const s = t3[r], a = e[r];
    if (a) {
      for (const t4 in s) t4 in a || (i[t4] = 1);
      for (const t4 in a) o[t4] || (n[t4] = a[t4], o[t4] = 1);
      t3[r] = a;
    } else for (const t4 in s) o[t4] = 1;
  }
  for (const t4 in i) t4 in n || (n[t4] = void 0);
  return n;
}
function get_spread_object(t3) {
  return "object" == typeof t3 && null !== t3 ? t3 : {};
}
function bind(t3, e, n) {
  const i = t3.$$.props[e];
  void 0 !== i && (t3.$$.bound[i] = n, n(t3.$$.ctx[i]));
}
function create_component(t3) {
  t3 && t3.c();
}
function mount_component(t3, e, n) {
  const { fragment: i, after_update: o } = t3.$$;
  i && i.m(e, n), add_render_callback(() => {
    const e2 = t3.$$.on_mount.map(run).filter(is_function);
    t3.$$.on_destroy ? t3.$$.on_destroy.push(...e2) : run_all(e2), t3.$$.on_mount = [];
  }), o.forEach(add_render_callback);
}
function destroy_component(t3, e) {
  const n = t3.$$;
  null !== n.fragment && (flush_render_callbacks(n.after_update), run_all(n.on_destroy), n.fragment && n.fragment.d(e), n.on_destroy = n.fragment = null, n.ctx = []);
}
function make_dirty(t3, e) {
  -1 === t3.$$.dirty[0] && (dirty_components.push(t3), schedule_update(), t3.$$.dirty.fill(0)), t3.$$.dirty[e / 31 | 0] |= 1 << e % 31;
}
function init$1(t3, e, n, i, o, r, s = null, a = [-1]) {
  const c = current_component;
  set_current_component(t3);
  const l = t3.$$ = { fragment: null, ctx: [], props: r, update: noop, not_equal: o, bound: blank_object(), on_mount: [], on_destroy: [], on_disconnect: [], before_update: [], after_update: [], context: new Map(e.context || (c ? c.$$.context : [])), callbacks: blank_object(), dirty: a, skip_bound: false, root: e.target || c.$$.root };
  s && s(l.root);
  let p = false;
  if (l.ctx = n ? n(t3, e.props || {}, (e2, n2, ...i2) => {
    const r2 = i2.length ? i2[0] : n2;
    return l.ctx && o(l.ctx[e2], l.ctx[e2] = r2) && (!l.skip_bound && l.bound[e2] && l.bound[e2](r2), p && make_dirty(t3, e2)), n2;
  }) : [], l.update(), p = true, run_all(l.before_update), l.fragment = !!i && i(l.ctx), e.target) {
    if (e.hydrate) {
      const t4 = children(e.target);
      l.fragment && l.fragment.l(t4), t4.forEach(detach);
    } else l.fragment && l.fragment.c();
    e.intro && transition_in(t3.$$.fragment), mount_component(t3, e.target, e.anchor), flush();
  }
  set_current_component(c);
}
class SvelteComponent {
  $$ = void 0;
  $$set = void 0;
  $destroy() {
    destroy_component(this, 1), this.$destroy = noop;
  }
  $on(t3, e) {
    if (!is_function(e)) return noop;
    const n = this.$$.callbacks[t3] || (this.$$.callbacks[t3] = []);
    return n.push(e), () => {
      const t4 = n.indexOf(e);
      -1 !== t4 && n.splice(t4, 1);
    };
  }
  $set(t3) {
    this.$$set && !is_empty(t3) && (this.$$.skip_bound = true, this.$$set(t3), this.$$.skip_bound = false);
  }
}
const PUBLIC_VERSION = "4", subscriber_queue = [];
function readable(t3, e) {
  return { subscribe: writable(t3, e).subscribe };
}
function writable(t3, e = noop) {
  let n;
  const i = /* @__PURE__ */ new Set();
  function o(e2) {
    if (safe_not_equal(t3, e2) && (t3 = e2, n)) {
      const e3 = !subscriber_queue.length;
      for (const e4 of i) e4[1](), subscriber_queue.push(e4, t3);
      if (e3) {
        for (let t4 = 0; t4 < subscriber_queue.length; t4 += 2) subscriber_queue[t4][0](subscriber_queue[t4 + 1]);
        subscriber_queue.length = 0;
      }
    }
  }
  function r(e2) {
    o(e2(t3));
  }
  return { set: o, update: r, subscribe: function(s, a = noop) {
    const c = [s, a];
    return i.add(c), 1 === i.size && (n = e(o, r) || noop), s(t3), () => {
      i.delete(c), 0 === i.size && n && (n(), n = null);
    };
  } };
}
function derived(t3, e, n) {
  const i = !Array.isArray(t3), o = i ? [t3] : t3;
  if (!o.every(Boolean)) throw new Error("derived() expects stores as input, got a falsy value");
  const r = e.length < 2;
  return readable(n, (t4, n2) => {
    let s = false;
    const a = [];
    let c = 0, l = noop;
    const p = () => {
      if (c) return;
      l();
      const o2 = e(i ? a[0] : a, t4, n2);
      r ? t4(o2) : l = is_function(o2) ? o2 : noop;
    }, u = o.map((t5, e2) => subscribe(t5, (t6) => {
      a[e2] = t6, c &= ~(1 << e2), s && p();
    }, () => {
      c |= 1 << e2;
    }));
    return s = true, p(), function() {
      run_all(u), l(), s = false;
    };
  });
}
function isMinimalWritableStore(t3) {
  if (null == t3) return false;
  switch (typeof t3) {
    case "function":
    case "object":
      return "function" == typeof t3.subscribe && "function" == typeof t3.set;
  }
  return false;
}
function isWritableStore(t3) {
  if (null == t3) return false;
  switch (typeof t3) {
    case "function":
    case "object":
      return "function" == typeof t3.subscribe && "function" == typeof t3.set && "function" == typeof t3.update;
  }
  return false;
}
function subscribeIgnoreFirst(t3, e) {
  let n = false;
  return t3.subscribe((t4) => {
    n ? e(t4) : n = true;
  });
}
function deepMerge(t3, ...e) {
  if ("[object Object]" !== Object.prototype.toString.call(t3)) throw new TypeError("deepMerge error: 'target' is not an object.");
  if (0 === e.length) throw new TypeError("deepMerge error: 'sourceObj' is not an object.");
  for (let t4 = 0; t4 < e.length; t4++) if ("[object Object]" !== Object.prototype.toString.call(e[t4])) throw new TypeError(`deepMerge error: 'sourceObj[${t4}]' is not an object.`);
  if (1 === e.length) {
    const n = [];
    for (const i of e) n.push({ target: t3, source: i });
    for (; n.length > 0; ) {
      const { target: t4, source: e2 } = n.pop();
      for (const i in e2) if (Object.hasOwn(e2, i)) {
        const o = e2[i], r = t4[i];
        Object.hasOwn(t4, i) && r?.constructor === Object && o?.constructor === Object ? n.push({ target: r, source: o }) : t4[i] = o;
      }
    }
  } else {
    const n = [{ target: t3, sources: e }];
    for (; n.length > 0; ) {
      const { target: t4, sources: e2 } = n.pop();
      for (const i of e2) for (const e3 in i) if (Object.hasOwn(i, e3)) {
        const o = i[e3], r = t4[e3];
        Object.hasOwn(t4, e3) && r?.constructor === Object && o?.constructor === Object ? (t4[e3] = Object.assign({}, r), n.push({ target: t4[e3], sources: [o] })) : t4[e3] = o;
      }
    }
  }
  return t3;
}
function hasGetter(t3, e) {
  if ("object" != typeof t3 || null == t3) return false;
  const n = Object.getOwnPropertyDescriptor(t3, e);
  if (void 0 !== n && void 0 !== n.get) return true;
  for (let n2 = Object.getPrototypeOf(t3); n2; n2 = Object.getPrototypeOf(n2)) {
    const t4 = Object.getOwnPropertyDescriptor(n2, e);
    if (void 0 !== t4 && void 0 !== t4.get) return true;
  }
  return false;
}
function isIterable(t3) {
  return null != t3 && "object" == typeof t3 && Symbol.iterator in t3;
}
function isObject(t3) {
  return null !== t3 && "object" == typeof t3 && !Array.isArray(t3);
}
function isPlainObject(t3) {
  if ("[object Object]" !== Object.prototype.toString.call(t3)) return false;
  const e = Object.getPrototypeOf(t3);
  return null === e || e === Object.prototype;
}
function safeAccess(t3, e, n) {
  if ("object" != typeof t3 || null === t3) return n;
  if ("string" != typeof e) return n;
  const i = e.split(".");
  let o = t3;
  for (let t4 = 0; t4 < i.length; t4++) {
    if (void 0 === o[i[t4]] || null === o[i[t4]]) return n;
    o = o[i[t4]];
  }
  return o;
}
function safeSet(t3, e, n, { operation: i = "set", createMissing: o = false } = {}) {
  if ("object" != typeof t3 || null === t3) throw new TypeError("safeSet error: 'data' is not an object.");
  if ("string" != typeof e) throw new TypeError("safeSet error: 'accessor' is not a string.");
  if ("string" != typeof i) throw new TypeError("safeSet error: 'options.operation' is not a string.");
  if ("add" !== i && "div" !== i && "mult" !== i && "set" !== i && "set-undefined" !== i && "sub" !== i) throw new Error("safeSet error: Unknown 'options.operation'.");
  if ("boolean" != typeof o) throw new TypeError("safeSet error: 'options.createMissing' is not a boolean.");
  const r = e.split(".");
  let s = false;
  if (1 === r.length && !o && !(r[0] in t3)) return false;
  for (let e2 = 0; e2 < r.length; e2++) {
    if (Array.isArray(t3)) {
      const t4 = +r[e2];
      if (!Number.isInteger(t4) || t4 < 0) return false;
    }
    if (e2 === r.length - 1) switch (i) {
      case "add":
        t3[r[e2]] += n, s = true;
        break;
      case "div":
        t3[r[e2]] /= n, s = true;
        break;
      case "mult":
        t3[r[e2]] *= n, s = true;
        break;
      case "set":
        t3[r[e2]] = n, s = true;
        break;
      case "set-undefined":
        void 0 === t3[r[e2]] && (t3[r[e2]] = n), s = true;
        break;
      case "sub":
        t3[r[e2]] -= n, s = true;
    }
    else {
      if (o && void 0 === t3[r[e2]] && (t3[r[e2]] = {}), null === t3[r[e2]] || "object" != typeof t3[r[e2]]) return false;
      t3 = t3[r[e2]];
    }
  }
  return s;
}
class CrossWindow {
  constructor() {
  }
  static #t = ["HTMLAnchorElement", "HTMLButtonElement", "HTMLDetailsElement", "HTMLEmbedElement", "HTMLIFrameElement", "HTMLInputElement", "HTMLObjectElement", "HTMLSelectElement", "HTMLTextAreaElement"];
  static #e = /* @__PURE__ */ new Set([Node.ELEMENT_NODE, Node.TEXT_NODE, Node.COMMENT_NODE, Node.DOCUMENT_FRAGMENT_NODE]);
  static #n = /* @__PURE__ */ new Set(["MouseEvent", "PointerEvent"]);
  static #i = /* @__PURE__ */ new Set(["UIEvent", "FocusEvent", "MouseEvent", "WheelEvent", "KeyboardEvent", "PointerEvent", "TouchEvent", "InputEvent", "CompositionEvent", "DragEvent"]);
  static #o = /* @__PURE__ */ new Set(["KeyboardEvent", "MouseEvent", "PointerEvent"]);
  static #r = { throws: false };
  static getActiveElement(t3, { throws: e = true } = {}) {
    if (this.#e.has(t3?.nodeType)) return t3?.ownerDocument?.activeElement ?? null;
    if (this.isUIEvent(t3) && isObject(t3?.view)) return t3?.view?.document?.activeElement ?? null;
    if (isObject(t3?.defaultView)) return t3?.activeElement ?? null;
    if (isObject(t3?.document) && isObject(t3?.location)) return t3?.document?.activeElement ?? null;
    if (e) throw new TypeError("'target' must be a DOM Node / Element, Document, UIEvent, or Window.");
  }
  static getDocument(t3, { throws: e = true } = {}) {
    if (this.#e.has(t3?.nodeType)) return t3?.ownerDocument;
    if (this.isUIEvent(t3) && isObject(t3?.view)) return t3?.view?.document;
    if (isObject(t3?.defaultView)) return t3;
    if (isObject(t3?.document) && isObject(t3?.location)) return t3?.document;
    if (e) throw new TypeError("'target' must be a DOM Node / Element, Document, UIEvent, or Window.");
  }
  static getWindow(t3, { throws: e = true } = {}) {
    if (this.#e.has(t3?.nodeType)) return t3.ownerDocument?.defaultView ?? globalThis;
    if (this.isUIEvent(t3) && isObject(t3?.view)) return t3.view ?? globalThis;
    if (isObject(t3?.defaultView)) return t3.defaultView ?? globalThis;
    if (isObject(t3?.document) && isObject(t3?.location)) return t3;
    if (e) throw new TypeError("'target' must be a DOM Node / Element, Document, UIEvent, or Window.");
  }
  static isDocument(t3) {
    return isObject(t3) && "[object Document]" === Object.prototype.toString.call(t3);
  }
  static isMap(t3) {
    return isObject(t3) && "[object Map]" === Object.prototype.toString.call(t3);
  }
  static isPromise(t3) {
    return isObject(t3) && "[object Promise]" === Object.prototype.toString.call(t3);
  }
  static isRegExp(t3) {
    return isObject(t3) && "[object RegExp]" === Object.prototype.toString.call(t3);
  }
  static isSet(t3) {
    return isObject(t3) && "[object Set]" === Object.prototype.toString.call(t3);
  }
  static isURL(t3) {
    return isObject(t3) && "[object URL]" === Object.prototype.toString.call(t3);
  }
  static isWindow(t3) {
    return isObject(t3) && "[object Window]" === Object.prototype.toString.call(t3);
  }
  static isFocusableHTMLElement(t3) {
    for (let e = this.#t.length; --e >= 0; ) if (this.#s(t3, Node.ELEMENT_NODE, this.#t[e])) return true;
    return false;
  }
  static isDocumentFragment(t3) {
    return this.#s(t3, Node.DOCUMENT_FRAGMENT_NODE, "DocumentFragment");
  }
  static isElement(t3) {
    return this.#s(t3, Node.ELEMENT_NODE, "Element");
  }
  static isHTMLAnchorElement(t3) {
    return this.#s(t3, Node.ELEMENT_NODE, "HTMLAnchorElement");
  }
  static isHTMLElement(t3) {
    return this.#s(t3, Node.ELEMENT_NODE, "HTMLElement");
  }
  static isNode(t3) {
    if ("number" != typeof t3?.nodeType) return false;
    if (t3 instanceof globalThis.Node) return true;
    const e = this.getWindow(t3, this.#r), n = e?.Node;
    return n && t3 instanceof n;
  }
  static isShadowRoot(t3) {
    return this.#s(t3, Node.DOCUMENT_FRAGMENT_NODE, "ShadowRoot");
  }
  static isSVGElement(t3) {
    return this.#s(t3, Node.ELEMENT_NODE, "SVGElement");
  }
  static isEvent(t3, e) {
    return "string" == typeof t3?.type && "boolean" == typeof t3?.defaultPrevented && "function" == typeof t3?.stopPropagation && (void 0 === e || this.isCtorName(t3, e));
  }
  static isPointerEvent(t3) {
    return this.isEvent(t3, this.#n);
  }
  static isUIEvent(t3) {
    return this.isEvent(t3, this.#i);
  }
  static isUserInputEvent(t3) {
    return this.isEvent(t3, this.#o);
  }
  static isCtorName(t3, e) {
    return !!isObject(t3) && ("string" == typeof e && t3?.constructor?.name === e || !!e?.has(t3?.constructor?.name));
  }
  static #s(t3, e, n) {
    if (!isObject(t3)) return false;
    if (t3.nodeType !== e) return false;
    const i = globalThis[n];
    if (i && t3 instanceof i) return true;
    const o = this.#e.has(t3.nodeType) ? t3?.ownerDocument?.defaultView : this.getWindow(t3, this.#r), r = o?.[n];
    return r && t3 instanceof r;
  }
}
var _a$1;
class TJSGameSettings {
  #a;
  #c = [];
  #l = /* @__PURE__ */ new Map();
  constructor(t3) {
    if ("string" != typeof t3) throw new TypeError("'namespace' is not a string.");
    this.#a = t3;
  }
  static #p(t3) {
    return writable(t3);
  }
  get namespace() {
    return this.#a;
  }
  #u(t3, e) {
    let n = this.#l.get(t3);
    return void 0 === n && (n = _a$1.#p(e), this.#l.set(t3, n)), n;
  }
  getReadableStore(t3) {
    if (!this.#l.has(t3)) return void console.warn(`TJSGameSettings - getReadableStore: '${t3}' is not a registered setting.`);
    return { subscribe: this.#u(t3).subscribe };
  }
  getStore(t3) {
    return this.getWritableStore(t3);
  }
  getWritableStore(t3) {
    if (this.#l.has(t3)) return this.#u(t3);
    console.warn(`TJSGameSettings - getWritableStore: '${t3}' is not a registered setting.`);
  }
  register(t3, e = true) {
    if (!isObject(t3)) throw new TypeError("TJSGameSettings - register: setting is not an object.");
    if (!isObject(t3.options)) throw new TypeError("TJSGameSettings - register: 'setting.options' attribute is not an object.");
    if ("boolean" != typeof e) throw new TypeError("TJSGameSettings - register: 'coreConfig' is not an boolean.");
    if (void 0 !== t3.store && !isMinimalWritableStore(t3.store)) throw new TypeError("TJSGameSettings - register: 'setting.store' attribute is not a minimal writable store.");
    const n = t3.namespace ?? this.#a, i = t3.key, o = !!e && (t3.options.config ?? true);
    if ("string" != typeof n) throw new TypeError("TJSGameSettings - register: 'namespace' attribute is not a string.");
    if ("string" != typeof i) throw new TypeError("TJSGameSettings - register: 'key' attribute is not a string.");
    const r = t3.store, s = t3.options, a = [];
    let c = false;
    if (a.push((t4) => {
      const e2 = this.#u(i);
      e2 && !c && (c = true, e2.set(t4), c = false);
    }), isIterable(s?.onChange)) for (const t4 of s.onChange) "function" == typeof t4 && a.push(t4);
    else "function" == typeof s.onChange && a.push(s.onChange);
    globalThis.game.settings.register(n, i, { ...s, config: o, onChange: (t4) => {
      for (const e2 of a) e2(t4);
    } });
    const l = r || this.#u(i, globalThis.game.settings.get(n, i));
    r && (this.#l.set(i, l), r.set(globalThis.game.settings.get(n, i)));
    subscribeIgnoreFirst(l, async (t4) => {
      c || (c = true, await globalThis.game.settings.set(n, i, t4)), c = false;
    });
    {
      const { store: e2, ...o2 } = t3, r2 = Object.assign({}, o2, { namespace: n, key: i, options: s });
      Object.freeze(r2), this.#c.push(r2);
    }
  }
  registerAll(t3, e) {
    if (!isIterable(t3)) throw new TypeError("TJSGameSettings - registerAll: settings is not iterable.");
    for (const n of t3) {
      if (!isObject(n)) throw new TypeError("TJSGameSettings - registerAll: entry in settings is not an object.");
      if ("string" != typeof n.namespace) throw new TypeError("TJSGameSettings - registerAll: entry in settings missing 'namespace' attribute.");
      if ("string" != typeof n.key) throw new TypeError("TJSGameSettings - registerAll: entry in settings missing 'key' attribute.");
      if (!isObject(n.options)) throw new TypeError("TJSGameSettings - registerAll: entry in settings missing 'options' attribute.");
      this.register(n, e);
    }
  }
  *data(t3 = void 0) {
    if (void 0 !== t3 && !CrossWindow.isRegExp(t3)) throw new TypeError("'regex' is not a RegExp");
    if (this.#c.length) if (t3) for (const e of this.#c) t3.test(e.key) && (yield e);
    else for (const t4 of this.#c) yield t4;
  }
  *entries(t3 = void 0) {
    if (void 0 !== t3 && !CrossWindow.isRegExp(t3)) throw new TypeError("'regex' is not a RegExp");
    if (this.#l.size) if (t3) for (const e of this.#l.keys()) t3.test(e) && (yield [e, this.getStore(e)]);
    else for (const t4 of this.#l.keys()) yield [t4, this.getStore(t4)];
  }
  *keys(t3 = void 0) {
    if (void 0 !== t3 && !CrossWindow.isRegExp(t3)) throw new TypeError("'regex' is not a RegExp");
    if (this.#l.size) if (t3) for (const e of this.#l.keys()) t3.test(e) && (yield e);
    else for (const t4 of this.#l.keys()) yield t4;
  }
  *stores(t3 = void 0) {
    if (void 0 !== t3 && !CrossWindow.isRegExp(t3)) throw new TypeError("'regex' is not a RegExp");
    if (this.#l.size) if (t3) for (const e of this.#l.keys()) t3.test(e) && (yield this.getStore(e));
    else for (const t4 of this.#l.keys()) yield this.getStore(t4);
  }
}
_a$1 = TJSGameSettings;
const foundryContextId = "foundryContextId", settings = { users: "users", usersMenu: "usersMenu", lastActorId: "lastActorId" };
var FoundryUserRoles = ((t3) => (t3[t3.NONE = 0] = "NONE", t3[t3.PLAYER = 1] = "PLAYER", t3[t3.TRUSTED_PLAYER = 2] = "TRUSTED_PLAYER", t3[t3.ASSISTANT_GM = 3] = "ASSISTANT_GM", t3[t3.GAMEMASTER = 4] = "GAMEMASTER", t3))(FoundryUserRoles || {});
function storeGenerator({ storage: t3, serialize: e = JSON.stringify, deserialize: n = JSON.parse }) {
  function i(t4, e2, n2) {
    return { subscribe: o(t4, e2, n2).subscribe };
  }
  function o(i2, o2, r) {
    if (t3) {
      const r2 = t3.getItem(i2);
      try {
        r2 && (o2 = n(r2));
      } catch (t4) {
      }
      t3.setItem(i2, e(o2));
    }
    const s = writable(o2, r ? function(n2) {
      return r(function(o3) {
        return t3 && t3.setItem(i2, e(o3)), n2(o3);
      }, function(t4) {
        a(t4(get_store_value(s)));
      });
    } : void 0);
    function a(n2) {
      t3 && t3.setItem(i2, e(n2)), s.set(n2);
    }
    return { set: a, update: function(t4) {
      a(t4(get_store_value(s)));
    }, subscribe: function(t4, e2) {
      return s.subscribe(t4, e2);
    } };
  }
  return { readable: i, writable: o, derived: function(e2, o2, r, s) {
    const a = !Array.isArray(o2), c = a ? [o2] : o2;
    if (t3 && t3.getItem(e2)) try {
      s = n(t3.getItem(e2));
    } catch (t4) {
    }
    return i(e2, s, (t4, e3) => {
      let n2 = false;
      const i2 = [];
      let o3, s2 = 0;
      const l = () => {
        if (s2) return;
        o3?.();
        const n3 = a ? i2[0] : i2;
        if (r.length < 2) t4(r(n3));
        else {
          const i3 = r(n3, t4, e3);
          "function" == typeof i3 && (o3 = i3);
        }
      }, p = c.map((t5, e4) => t5.subscribe((t6) => {
        i2[e4] = t6, s2 &= ~(1 << e4), n2 && l();
      }, () => {
        s2 |= 1 << e4;
      }));
      return n2 = true, l(), function() {
        p.forEach((t5) => t5()), o3?.();
      };
    });
  }, storage: t3, serialize: e, deserialize: n };
}
const sessionStores = storeGenerator({ storage: globalThis?.sessionStorage });
class TJSWebStorage {
  #d;
  #l = /* @__PURE__ */ new Map();
  constructor(t3) {
    this.#d = t3;
  }
  #p(t3, e = void 0, n) {
    try {
      const i = this.#d.storage.getItem(t3);
      if (null !== i) {
        e = (n?.deserialize ?? this.#d.deserialize)(i);
      }
    } catch (t4) {
    }
    return (n?.writable ?? this.#d.writable)(t3, e);
  }
  #m(t3) {
    return this.#l.get(t3)?.deserialize ?? this.#d.deserialize;
  }
  #h(t3) {
    return this.#l.get(t3)?.serialize ?? this.#d.serialize;
  }
  #u(t3, e = void 0, n) {
    const i = this.#l.get(t3);
    if (i) return i.store;
    const o = this.#p(t3, e, n);
    return this.#l.set(t3, { store: o, deserialize: n?.deserialize, serialize: n?.serialize }), o;
  }
  getItem(t3, e) {
    let n = e;
    const i = this.#d.storage.getItem(t3);
    if (null !== i) try {
      n = this.#m(t3)(i);
    } catch (t4) {
      n = e;
    }
    else if (void 0 !== e) try {
      const n2 = this.#h(t3)(e);
      this.#d.storage.setItem(t3, n2);
    } catch (t4) {
    }
    return n;
  }
  getStore(t3, e, n) {
    return this.#u(t3, e, n);
  }
  hasStore(t3) {
    return this.#l.has(t3);
  }
  setItem(t3, e) {
    this.#u(t3).set(e);
  }
  swapItemBoolean(t3, e) {
    const n = this.#u(t3, e);
    let i = false;
    try {
      i = !!this.#m(t3)(this.#d.storage.getItem(t3));
    } catch (t4) {
    }
    const o = "boolean" == typeof i && !i;
    return n.set(o), o;
  }
  *entries(t3 = void 0) {
    if (void 0 !== t3 && !CrossWindow.isRegExp(t3)) throw new TypeError("'regex' is not a RegExp");
    if (this.#l.size) if (t3) for (const e of this.#l.keys()) t3.test(e) && (yield [e, this.getStore(e)]);
    else for (const t4 of this.#l.keys()) yield [t4, this.getStore(t4)];
  }
  *keys(t3 = void 0) {
    if (void 0 !== t3 && !CrossWindow.isRegExp(t3)) throw new TypeError("'regex' is not a RegExp");
    if (this.#l.size) if (t3) for (const e of this.#l.keys()) t3.test(e) && (yield e);
    else for (const t4 of this.#l.keys()) yield t4;
  }
  *stores(t3 = void 0) {
    if (void 0 !== t3 && !CrossWindow.isRegExp(t3)) throw new TypeError("'regex' is not a RegExp");
    if (this.#l.size) if (t3) for (const e of this.#l.keys()) t3.test(e) && (yield this.getStore(e));
    else for (const t4 of this.#l.keys()) yield this.getStore(t4);
  }
}
class TJSSessionStorage extends TJSWebStorage {
  constructor() {
    super(sessionStores);
  }
}
function writableDerived(t3, e, n, i) {
  var o, r, s = false, a = n.length >= 2, c = derived(t3, (t4, n2, i2) => {
    if (o = n2, a && (r = t4), !s) {
      let o2 = e(t4, n2, i2);
      if (!(e.length < 2)) return o2;
      n2(o2);
    }
    s = false;
  }, i), l = !Array.isArray(t3);
  var p = false;
  function u(e2) {
    var i2, a2, u2, d;
    if (p) return d = e2(get_store_value(c)), void o(d);
    var m, h = c.subscribe((t4) => {
      p ? i2 ? a2 = true : i2 = true : u2 = t4;
    });
    d = e2(u2), p = true, o(d), h(), p = false, a2 && (d = get_store_value(c)), i2 && (m = n(d, r), l ? (s = true, t3.set(m)) : m.forEach((e3, n2) => {
      s = true, t3[n2].set(e3);
    }), s = false);
  }
  return { subscribe: c.subscribe, set(t4) {
    u(() => t4);
  }, update: u };
}
function propertyStore(t3, e) {
  if (Array.isArray(e)) {
    let n = e.concat();
    return writableDerived(t3, (t4) => {
      for (let e2 = 0; e2 < n.length; ++e2) t4 = t4[n[e2]];
      return t4;
    }, (t4, e2) => {
      let i = e2;
      for (let t5 = 0; t5 < n.length - 1; ++t5) i = i[n[t5]];
      return i[n[n.length - 1]] = t4, e2;
    });
  }
  return writableDerived(t3, (t4) => t4[e], (t4, n) => (n[e] = t4, n));
}
class APIConfig {
  constructor() {
  }
  static isConfig(t3, { raiseException: e = false } = {}) {
    if (!isObject(t3)) {
      if (e) throw new TypeError("TJSSvelte.config.isConfig error: 'config' is not an object.");
      return false;
    }
    if (!TJSSvelte.util.isComponent(t3.class)) {
      if (e) throw new TypeError("TJSSvelte.config.isConfig error: 'config.class' is not a Svelte component constructor.");
      return false;
    }
    return true;
  }
  static isConfigEmbed(t3, { raiseException: e = false } = {}) {
    if (!isObject(t3)) {
      if (e) throw new TypeError("TJSSvelte.config.isConfigEmbed error: 'config' is not an object.");
      return false;
    }
    if (!TJSSvelte.util.isComponent(t3.class)) {
      if (e) throw new TypeError("TJSSvelte.config.isConfigEmbed error: 'config.class' is not a Svelte component constructor.");
      return false;
    }
    if (void 0 !== t3.props && !isObject(t3.props)) {
      if (e) throw new TypeError("TJSSvelte.config.isConfigEmbed error: 'config.props' is not an object.");
      return false;
    }
    return true;
  }
  static parseConfig(t3, { contextExternal: e = false, thisArg: n } = {}) {
    if (!isObject(t3)) throw new TypeError(`TJSSvelte.config.parseConfig - 'config' is not an object:
${JSON.stringify(t3)}.`);
    if (!TJSSvelte.util.isComponent(t3.class)) throw new TypeError(`TJSSvelte.config.parseConfig - 'class' is not a Svelte component constructor for config:
${JSON.stringify(t3)}.`);
    if (void 0 !== t3.hydrate && "boolean" != typeof t3.hydrate) throw new TypeError(`TJSSvelte.config.parseConfig - 'hydrate' is not a boolean for config:
${JSON.stringify(t3)}.`);
    if (void 0 !== t3.intro && "boolean" != typeof t3.intro) throw new TypeError(`TJSSvelte.config.parseConfig - 'intro' is not a boolean for config:
${JSON.stringify(t3)}.`);
    if (void 0 !== t3.target && !CrossWindow.isElement(t3.target) && !CrossWindow.isShadowRoot(t3.target) && !CrossWindow.isDocumentFragment(t3.target)) throw new TypeError(`TJSSvelte.config.parseConfig - 'target' is not a Element, ShadowRoot, or DocumentFragment for config:
${JSON.stringify(t3)}.`);
    if (void 0 !== t3.anchor && !CrossWindow.isElement(t3.anchor) && !CrossWindow.isShadowRoot(t3.anchor) && !CrossWindow.isDocumentFragment(t3.anchor)) throw new TypeError(`TJSSvelte.config.parseConfig - 'anchor' is not a string, Element for config:
${JSON.stringify(t3)}.`);
    if (void 0 !== t3.context && "function" != typeof t3.context && !isObject(t3.context)) throw new TypeError(`TJSSvelte.config.parseConfig - 'context' is not a function or object for config:
${JSON.stringify(t3)}.`);
    const i = { ...t3 };
    let o = {};
    if ("function" == typeof i.context) {
      const e2 = i.context;
      delete i.context;
      const r = e2.call(n);
      if (!isObject(r)) throw new Error(`TJSSvelte.config.parseConfig - 'context' is a function that did not return an object for config:
${JSON.stringify(t3)}`);
      o = { ...r };
    } else isObject(i.context) && (o = i.context, delete i.context);
    return i.props = this.#f(i.props, n, t3), e ? (i.context = /* @__PURE__ */ new Map(), i.context.set("#external", o)) : i.context = new Map(Object.entries(o)), i;
  }
  static #f(t3, e, n) {
    if ("function" == typeof t3) {
      const i = t3.call(e);
      if (isObject(i)) return i;
      throw new Error(`TJSSvelte.config.parseConfig - 'props' is a function that did not return an object for config:
${JSON.stringify(n)}`);
    }
    if (isObject(t3)) return t3;
    if (void 0 !== t3) throw new Error(`TJSSvelte.config.parseConfig - 'props' is not a function or an object for config:
${JSON.stringify(n)}`);
    return {};
  }
}
Object.seal(APIConfig);
class APIUtil {
  constructor() {
  }
  static isComponent(t3) {
    if (null == t3 || "function" != typeof t3) return false;
    const e = t3?.prototype?.constructor?.name;
    return !("string" != typeof e || !e.startsWith("Proxy<") && "ProxyComponent" !== e) || ("undefined" != typeof window ? "function" == typeof t3?.prototype?.$destroy && "function" == typeof t3?.prototype?.$on : "function" == typeof t3?.prototype?.render);
  }
  static isHMRProxy(t3) {
    const e = t3?.constructor?.name;
    if ("string" == typeof e && (e.startsWith("Proxy<") || "ProxyComponent" === e)) return true;
    const n = t3?.prototype?.constructor?.name;
    return "string" == typeof n && (n.startsWith("Proxy<") || "ProxyComponent" === n);
  }
  static async outroAndDestroy(t3) {
    return null == t3 ? Promise.resolve() : new Promise((e) => {
      t3?.$$?.fragment && t3?.$$?.fragment?.o ? (group_outros(), transition_out(t3.$$.fragment, 0, 0, () => {
        t3?.$destroy?.(), e();
      }), check_outros()) : (t3?.$destroy?.(), e());
    });
  }
}
Object.seal(APIUtil);
class TJSSvelte {
  constructor() {
  }
  static get config() {
    return APIConfig;
  }
  static get util() {
    return APIUtil;
  }
}
function backInOut(t3) {
  const e = 2.5949095;
  return (t3 *= 2) < 1 ? t3 * t3 * ((e + 1) * t3 - e) * 0.5 : 0.5 * ((t3 -= 2) * t3 * ((e + 1) * t3 + e) + 2);
}
function backIn(t3) {
  const e = 1.70158;
  return t3 * t3 * ((e + 1) * t3 - e);
}
function backOut(t3) {
  const e = 1.70158;
  return --t3 * t3 * ((e + 1) * t3 + e) + 1;
}
function bounceOut(t3) {
  const e = t3 * t3;
  return t3 < 4 / 11 ? 7.5625 * e : t3 < 8 / 11 ? 9.075 * e - 9.9 * t3 + 3.4 : t3 < 0.9 ? 4356 / 361 * e - 35442 / 1805 * t3 + 16061 / 1805 : 10.8 * t3 * t3 - 20.52 * t3 + 10.72;
}
function bounceInOut(t3) {
  return t3 < 0.5 ? 0.5 * (1 - bounceOut(1 - 2 * t3)) : 0.5 * bounceOut(2 * t3 - 1) + 0.5;
}
function bounceIn(t3) {
  return 1 - bounceOut(1 - t3);
}
function circInOut(t3) {
  return (t3 *= 2) < 1 ? -0.5 * (Math.sqrt(1 - t3 * t3) - 1) : 0.5 * (Math.sqrt(1 - (t3 -= 2) * t3) + 1);
}
function circIn(t3) {
  return 1 - Math.sqrt(1 - t3 * t3);
}
function circOut(t3) {
  return Math.sqrt(1 - --t3 * t3);
}
function cubicInOut(t3) {
  return t3 < 0.5 ? 4 * t3 * t3 * t3 : 0.5 * Math.pow(2 * t3 - 2, 3) + 1;
}
function cubicIn(t3) {
  return t3 * t3 * t3;
}
function cubicOut(t3) {
  const e = t3 - 1;
  return e * e * e + 1;
}
function elasticInOut(t3) {
  return t3 < 0.5 ? 0.5 * Math.sin(13 * Math.PI / 2 * 2 * t3) * Math.pow(2, 10 * (2 * t3 - 1)) : 0.5 * Math.sin(-13 * Math.PI / 2 * (2 * t3 - 1 + 1)) * Math.pow(2, -10 * (2 * t3 - 1)) + 1;
}
function elasticIn(t3) {
  return Math.sin(13 * t3 * Math.PI / 2) * Math.pow(2, 10 * (t3 - 1));
}
function elasticOut(t3) {
  return Math.sin(-13 * (t3 + 1) * Math.PI / 2) * Math.pow(2, -10 * t3) + 1;
}
function expoInOut(t3) {
  return 0 === t3 || 1 === t3 ? t3 : t3 < 0.5 ? 0.5 * Math.pow(2, 20 * t3 - 10) : -0.5 * Math.pow(2, 10 - 20 * t3) + 1;
}
function expoIn(t3) {
  return 0 === t3 ? t3 : Math.pow(2, 10 * (t3 - 1));
}
function expoOut(t3) {
  return 1 === t3 ? t3 : 1 - Math.pow(2, -10 * t3);
}
function quadInOut(t3) {
  return (t3 /= 0.5) < 1 ? 0.5 * t3 * t3 : -0.5 * (--t3 * (t3 - 2) - 1);
}
function quadIn(t3) {
  return t3 * t3;
}
function quadOut(t3) {
  return -t3 * (t3 - 2);
}
function quartInOut(t3) {
  return t3 < 0.5 ? 8 * Math.pow(t3, 4) : -8 * Math.pow(t3 - 1, 4) + 1;
}
function quartIn(t3) {
  return Math.pow(t3, 4);
}
function quartOut(t3) {
  return Math.pow(t3 - 1, 3) * (1 - t3) + 1;
}
function quintInOut(t3) {
  return (t3 *= 2) < 1 ? 0.5 * t3 * t3 * t3 * t3 * t3 : 0.5 * ((t3 -= 2) * t3 * t3 * t3 * t3 + 2);
}
function quintIn(t3) {
  return t3 * t3 * t3 * t3 * t3;
}
function quintOut(t3) {
  return --t3 * t3 * t3 * t3 * t3 + 1;
}
function sineInOut(t3) {
  return -0.5 * (Math.cos(Math.PI * t3) - 1);
}
function sineIn(t3) {
  const e = Math.cos(t3 * Math.PI * 0.5);
  return Math.abs(e) < 1e-14 ? 1 : 1 - e;
}
function sineOut(t3) {
  return Math.sin(t3 * Math.PI / 2);
}
Object.seal(TJSSvelte);
const svelteEasingFunc = Object.freeze(Object.defineProperty({ __proto__: null, backIn, backInOut, backOut, bounceIn, bounceInOut, bounceOut, circIn, circInOut, circOut, cubicIn, cubicInOut, cubicOut, elasticIn, elasticInOut, elasticOut, expoIn, expoInOut, expoOut, linear: identity, quadIn, quadInOut, quadOut, quartIn, quartInOut, quartOut, quintIn, quintInOut, quintOut, sineIn, sineInOut, sineOut }, Symbol.toStringTag, { value: "Module" })), easingFunc = svelteEasingFunc;
function getEasingFunc(t3, e) {
  if ("function" == typeof t3) return t3;
  const n = easingFunc[t3];
  return n || easingFunc[e?.default ?? "linear"];
}
class A11yHelper {
  static #g = false;
  static get debug() {
    return this.#g;
  }
  static set debug(t3) {
    if ("boolean" != typeof t3) throw new TypeError("'debug' is not a boolean.");
    this.#g = t3;
  }
  static get prefersReducedMotion() {
    return globalThis?.matchMedia("(prefers-reduced-motion: reduce)")?.matches ?? false;
  }
  static applyFocusSource(t3) {
    if (!isObject(t3)) return;
    const e = isObject(t3?.focusSource) ? t3.focusSource : t3;
    setTimeout(() => {
      const t4 = "boolean" == typeof e.debug ? this.debug || e.debug : this.debug;
      if (isIterable(e.focusEl)) {
        t4 && e.focusEl;
        for (const t5 of e.focusEl) {
          if (t5?.nodeType === Node.ELEMENT_NODE && t5?.isConnected) {
            t5?.focus();
            break;
          }
          if ("string" == typeof t5) {
            const e2 = document.querySelector(t5);
            if (e2?.nodeType === Node.ELEMENT_NODE && e2?.isConnected) {
              e2?.focus();
              break;
            }
          }
        }
      }
    }, 0);
  }
  static getFirstFocusableElement(t3 = document, e) {
    const n = this.getFocusableElements(t3, e);
    return n.length > 0 ? n[0] : void 0;
  }
  static getFocusableElements(t3 = document, { anchorHref: e = true, ignoreClasses: n, ignoreElements: i, parentHidden: o = false, selectors: r } = {}) {
    if (t3?.nodeType !== Node.ELEMENT_NODE && t3?.nodeType !== Node.DOCUMENT_NODE) throw new TypeError("'element' is not a HTMLElement, SVGElement, or Document instance.");
    if ("boolean" != typeof e) throw new TypeError("'anchorHref' is not a boolean.");
    if (void 0 !== n && !isIterable(n)) throw new TypeError("'ignoreClasses' is not an iterable list.");
    if (void 0 !== i && !CrossWindow.isSet(i)) throw new TypeError("'ignoreElements' is not a Set.");
    if (void 0 !== r && "string" != typeof r) throw new TypeError("'selectors' is not a string.");
    const s = r ?? this.#_(e);
    let a = [...t3.querySelectorAll(s)];
    return a = i && n ? a.filter((t4) => {
      let e2 = false;
      for (const i2 of n) if (t4.classList.contains(i2)) {
        e2 = true;
        break;
      }
      return !(e2 || i.has(t4) || "none" === t4.style.display || "hidden" === t4.style.visibility || t4.hasAttribute("disabled") || t4.hasAttribute("inert") || "true" === t4.getAttribute("aria-hidden"));
    }) : n ? a.filter((t4) => {
      let e2 = false;
      for (const i2 of n) if (t4.classList.contains(i2)) {
        e2 = true;
        break;
      }
      return !e2 && "none" !== t4.style.display && "hidden" !== t4.style.visibility && !t4.hasAttribute("disabled") && !t4.hasAttribute("inert") && "true" !== t4.getAttribute("aria-hidden");
    }) : i ? a.filter((t4) => !i.has(t4) && "none" !== t4.style.display && "hidden" !== t4.style.visibility && !t4.hasAttribute("disabled") && !t4.hasAttribute("inert") && "true" !== t4.getAttribute("aria-hidden")) : a.filter((t4) => "none" !== t4.style.display && "hidden" !== t4.style.visibility && !t4.hasAttribute("disabled") && !t4.hasAttribute("inert") && "true" !== t4.getAttribute("aria-hidden")), o && (a = a.filter((e2) => !this.isParentHidden(e2, t3))), a;
  }
  static #_(t3 = true) {
    return `button, [contenteditable=""], [contenteditable="true"], details summary:not([tabindex="-1"]), embed, a${t3 ? "[href]" : ""}, iframe, object, input:not([type=hidden]), select, textarea, [tabindex]:not([tabindex="-1"])`;
  }
  static getFocusSource({ event: t3, x: e, y: n, focusEl: i, debug: o = false }) {
    if (void 0 !== i && !this.isFocusSource(i)) throw new TypeError("A11yHelper.getFocusSource error: 'focusEl' is not a HTMLElement, SVGElement, or string.");
    if (void 0 !== o && "boolean" != typeof o) throw new TypeError("A11yHelper.getFocusSource error: 'debug' is not a boolean.");
    const r = "boolean" == typeof o ? this.debug || o : this.debug;
    if (void 0 === t3) {
      if ("number" != typeof e) throw new TypeError("A11yHelper.getFocusSource error: 'event' not defined and 'x' is not a number.");
      if ("number" != typeof n) throw new TypeError("A11yHelper.getFocusSource error: 'event' not defined and 'y' is not a number.");
      const t4 = { debug: o, focusEl: void 0 !== i ? [i] : void 0, x: e, y: n };
      return t4;
    }
    if (void 0 !== t3 && !CrossWindow.isUserInputEvent(t3)) throw new TypeError("A11yHelper.getFocusSource error: 'event' is not a KeyboardEvent, MouseEvent, or PointerEvent.");
    if (void 0 !== e && !Number.isInteger(e)) throw new TypeError("A11yHelper.getFocusSource error: 'x' is not a number.");
    if (void 0 !== n && !Number.isInteger(n)) throw new TypeError("A11yHelper.getFocusSource error: 'y' is not a number.");
    let s;
    if (t3 && (A11yHelper.isFocusable(t3.target) ? s = t3.target : A11yHelper.isFocusable(t3.currentTarget) ? s = t3.currentTarget : r && (t3.target, t3.currentTarget), s && s?.nodeType !== Node.ELEMENT_NODE && "function" != typeof s?.focus)) throw new TypeError("A11yHelper.getFocusSource error: 'targetEl' is not an HTMLElement or SVGElement.");
    const a = { debug: o };
    if (CrossWindow.isPointerEvent(t3)) if (2 !== t3?.button && "contextmenu" === t3.type) {
      const o2 = (s ?? t3.target).getBoundingClientRect();
      a.source = "keyboard", a.x = e ?? o2.left + o2.width / 2, a.y = n ?? o2.top + o2.height / 2, a.focusEl = s ? [s] : [], i && a.focusEl.push(i);
    } else a.source = "pointer", a.x = e ?? t3.pageX, a.y = n ?? t3.pageY, a.focusEl = s ? [s] : [], i && a.focusEl.push(i);
    else {
      const o2 = s ?? t3?.target;
      if (o2) {
        const t4 = o2.getBoundingClientRect();
        a.source = "keyboard", a.x = e ?? t4.left + t4.width / 2, a.y = n ?? t4.top + t4.height / 2, a.focusEl = s ? [s] : [];
      }
      i && a.focusEl.push(i);
    }
    return a;
  }
  static getLastFocusableElement(t3 = document, e) {
    const n = this.getFocusableElements(t3, e);
    return n.length > 0 ? n[n.length - 1] : void 0;
  }
  static isFocusable(t3, { anchorHref: e = true, ignoreClasses: n } = {}) {
    if (null == t3 || t3?.hidden || !t3?.isConnected || t3?.nodeType !== Node.ELEMENT_NODE || "function" != typeof t3?.focus) return false;
    if ("boolean" != typeof e) throw new TypeError("'anchorHref' is not a boolean.");
    if (void 0 !== n && !isIterable(n)) throw new TypeError("'ignoreClasses' is not an iterable list.");
    const i = t3.getAttribute("contenteditable"), o = "string" == typeof i && ("" === i || "true" === i), r = globalThis.parseInt(t3.getAttribute("tabindex")), s = Number.isInteger(r) && r >= 0;
    return !!(o || s || CrossWindow.isFocusableHTMLElement(t3)) && (!(e && !s && CrossWindow.isHTMLAnchorElement(t3) && "string" != typeof t3.getAttribute("href")) && ("none" !== t3.style.display && "hidden" !== t3.style.visibility && !t3.hasAttribute("disabled") && !t3.hasAttribute("inert") && "true" !== t3.getAttribute("aria-hidden")));
  }
  static isFocusSource(t3) {
    return "string" == typeof t3 || t3?.nodeType === Node.ELEMENT_NODE && "function" == typeof t3?.focus;
  }
  static isFocusTarget(t3) {
    return null != t3 && t3?.nodeType === Node.ELEMENT_NODE && "function" == typeof t3?.focus;
  }
  static isFocusWithin(t3) {
    if (!isObject(t3) || t3?.hidden || !t3?.isConnected) return false;
    let e = CrossWindow.getActiveElement(t3);
    if (!e) return false;
    for (; e; ) {
      if (e === t3) return true;
      e = e.parentElement;
    }
    return false;
  }
  static isParentHidden(t3, e) {
    if (!CrossWindow.isElement(t3)) throw new TypeError("'element' is not an Element.");
    if (e = e ?? CrossWindow.getDocument(t3)?.body, !CrossWindow.isElement(e)) throw new TypeError("'stopElement' must be an Element.");
    let n = t3.parentElement;
    for (; n && n !== e; ) {
      if (0 === n.offsetWidth && 0 === n.offsetHeight) return true;
      n = n.parentElement;
    }
    return false;
  }
}
function clamp(t3 = 0, e = 0, n = 0) {
  return Math.min(Math.max(t3, e), n);
}
function degToRad(t3) {
  return t3 * (Math.PI / 180);
}
function radToDeg(t3) {
  return t3 * (180 / Math.PI);
}
function lerp(t3, e, n) {
  return (1 - n) * t3 + n * e;
}
var GLM_EPSILON = 1e-6, Mat4 = class t extends Float32Array {
  static #b = new Float32Array([1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1]);
  static #y = new Float32Array(3);
  constructor(...e) {
    switch (e.length) {
      case 16:
        super(e);
        break;
      case 2:
        super(e[0], e[1], 16);
        break;
      case 1:
        const n = e[0];
        "number" == typeof n ? super([n, n, n, n, n, n, n, n, n, n, n, n, n, n, n, n]) : super(n, 0, 16);
        break;
      default:
        super(t.#b);
    }
  }
  get str() {
    return t.str(this);
  }
  copy(t3) {
    return this.set(t3), this;
  }
  identity() {
    return this.set(t.#b), this;
  }
  multiply(e) {
    return t.multiply(this, this, e);
  }
  mul(t3) {
    return this;
  }
  transpose() {
    return t.transpose(this, this);
  }
  invert() {
    return t.invert(this, this);
  }
  translate(e) {
    return t.translate(this, this, e);
  }
  rotate(e, n) {
    return t.rotate(this, this, e, n);
  }
  scale(e) {
    return t.scale(this, this, e);
  }
  rotateX(e) {
    return t.rotateX(this, this, e);
  }
  rotateY(e) {
    return t.rotateY(this, this, e);
  }
  rotateZ(e) {
    return t.rotateZ(this, this, e);
  }
  perspectiveNO(e, n, i, o) {
    return t.perspectiveNO(this, e, n, i, o);
  }
  perspectiveZO(e, n, i, o) {
    return t.perspectiveZO(this, e, n, i, o);
  }
  orthoNO(e, n, i, o, r, s) {
    return t.orthoNO(this, e, n, i, o, r, s);
  }
  orthoZO(e, n, i, o, r, s) {
    return t.orthoZO(this, e, n, i, o, r, s);
  }
  static get BYTE_LENGTH() {
    return 16 * Float32Array.BYTES_PER_ELEMENT;
  }
  static create() {
    return new t();
  }
  static clone(e) {
    return new t(e);
  }
  static copy(t3, e) {
    return t3[0] = e[0], t3[1] = e[1], t3[2] = e[2], t3[3] = e[3], t3[4] = e[4], t3[5] = e[5], t3[6] = e[6], t3[7] = e[7], t3[8] = e[8], t3[9] = e[9], t3[10] = e[10], t3[11] = e[11], t3[12] = e[12], t3[13] = e[13], t3[14] = e[14], t3[15] = e[15], t3;
  }
  static fromValues(...e) {
    return new t(...e);
  }
  static set(t3, ...e) {
    return t3[0] = e[0], t3[1] = e[1], t3[2] = e[2], t3[3] = e[3], t3[4] = e[4], t3[5] = e[5], t3[6] = e[6], t3[7] = e[7], t3[8] = e[8], t3[9] = e[9], t3[10] = e[10], t3[11] = e[11], t3[12] = e[12], t3[13] = e[13], t3[14] = e[14], t3[15] = e[15], t3;
  }
  static identity(t3) {
    return t3[0] = 1, t3[1] = 0, t3[2] = 0, t3[3] = 0, t3[4] = 0, t3[5] = 1, t3[6] = 0, t3[7] = 0, t3[8] = 0, t3[9] = 0, t3[10] = 1, t3[11] = 0, t3[12] = 0, t3[13] = 0, t3[14] = 0, t3[15] = 1, t3;
  }
  static transpose(t3, e) {
    if (t3 === e) {
      const n = e[1], i = e[2], o = e[3], r = e[6], s = e[7], a = e[11];
      t3[1] = e[4], t3[2] = e[8], t3[3] = e[12], t3[4] = n, t3[6] = e[9], t3[7] = e[13], t3[8] = i, t3[9] = r, t3[11] = e[14], t3[12] = o, t3[13] = s, t3[14] = a;
    } else t3[0] = e[0], t3[1] = e[4], t3[2] = e[8], t3[3] = e[12], t3[4] = e[1], t3[5] = e[5], t3[6] = e[9], t3[7] = e[13], t3[8] = e[2], t3[9] = e[6], t3[10] = e[10], t3[11] = e[14], t3[12] = e[3], t3[13] = e[7], t3[14] = e[11], t3[15] = e[15];
    return t3;
  }
  static invert(t3, e) {
    const n = e[0], i = e[1], o = e[2], r = e[3], s = e[4], a = e[5], c = e[6], l = e[7], p = e[8], u = e[9], d = e[10], m = e[11], h = e[12], f = e[13], g = e[14], _ = e[15], b = n * a - i * s, y = n * c - o * s, v = n * l - r * s, $2 = i * c - o * a, T = i * l - r * a, w = o * l - r * c, S = p * f - u * h, k = p * g - d * h, O = p * _ - m * h, x = u * g - d * f, E = u * _ - m * f, M = d * _ - m * g;
    let A = b * M - y * E + v * x + $2 * O - T * k + w * S;
    return A ? (A = 1 / A, t3[0] = (a * M - c * E + l * x) * A, t3[1] = (o * E - i * M - r * x) * A, t3[2] = (f * w - g * T + _ * $2) * A, t3[3] = (d * T - u * w - m * $2) * A, t3[4] = (c * O - s * M - l * k) * A, t3[5] = (n * M - o * O + r * k) * A, t3[6] = (g * v - h * w - _ * y) * A, t3[7] = (p * w - d * v + m * y) * A, t3[8] = (s * E - a * O + l * S) * A, t3[9] = (i * O - n * E - r * S) * A, t3[10] = (h * T - f * v + _ * b) * A, t3[11] = (u * v - p * T - m * b) * A, t3[12] = (a * k - s * x - c * S) * A, t3[13] = (n * x - i * k + o * S) * A, t3[14] = (f * y - h * $2 - g * b) * A, t3[15] = (p * $2 - u * y + d * b) * A, t3) : null;
  }
  static adjoint(t3, e) {
    const n = e[0], i = e[1], o = e[2], r = e[3], s = e[4], a = e[5], c = e[6], l = e[7], p = e[8], u = e[9], d = e[10], m = e[11], h = e[12], f = e[13], g = e[14], _ = e[15], b = n * a - i * s, y = n * c - o * s, v = n * l - r * s, $2 = i * c - o * a, T = i * l - r * a, w = o * l - r * c, S = p * f - u * h, k = p * g - d * h, O = p * _ - m * h, x = u * g - d * f, E = u * _ - m * f, M = d * _ - m * g;
    return t3[0] = a * M - c * E + l * x, t3[1] = o * E - i * M - r * x, t3[2] = f * w - g * T + _ * $2, t3[3] = d * T - u * w - m * $2, t3[4] = c * O - s * M - l * k, t3[5] = n * M - o * O + r * k, t3[6] = g * v - h * w - _ * y, t3[7] = p * w - d * v + m * y, t3[8] = s * E - a * O + l * S, t3[9] = i * O - n * E - r * S, t3[10] = h * T - f * v + _ * b, t3[11] = u * v - p * T - m * b, t3[12] = a * k - s * x - c * S, t3[13] = n * x - i * k + o * S, t3[14] = f * y - h * $2 - g * b, t3[15] = p * $2 - u * y + d * b, t3;
  }
  static determinant(t3) {
    const e = t3[0], n = t3[1], i = t3[2], o = t3[3], r = t3[4], s = t3[5], a = t3[6], c = t3[7], l = t3[8], p = t3[9], u = t3[10], d = t3[11], m = t3[12], h = t3[13], f = t3[14], g = e * s - n * r, _ = e * a - i * r, b = n * a - i * s, y = l * h - p * m, v = l * f - u * m, $2 = p * f - u * h;
    return c * (e * $2 - n * v + i * y) - o * (r * $2 - s * v + a * y) + t3[15] * (l * b - p * _ + u * g) - d * (m * b - h * _ + f * g);
  }
  static multiply(t3, e, n) {
    const i = e[0], o = e[1], r = e[2], s = e[3], a = e[4], c = e[5], l = e[6], p = e[7], u = e[8], d = e[9], m = e[10], h = e[11], f = e[12], g = e[13], _ = e[14], b = e[15];
    let y = n[0], v = n[1], $2 = n[2], T = n[3];
    return t3[0] = y * i + v * a + $2 * u + T * f, t3[1] = y * o + v * c + $2 * d + T * g, t3[2] = y * r + v * l + $2 * m + T * _, t3[3] = y * s + v * p + $2 * h + T * b, y = n[4], v = n[5], $2 = n[6], T = n[7], t3[4] = y * i + v * a + $2 * u + T * f, t3[5] = y * o + v * c + $2 * d + T * g, t3[6] = y * r + v * l + $2 * m + T * _, t3[7] = y * s + v * p + $2 * h + T * b, y = n[8], v = n[9], $2 = n[10], T = n[11], t3[8] = y * i + v * a + $2 * u + T * f, t3[9] = y * o + v * c + $2 * d + T * g, t3[10] = y * r + v * l + $2 * m + T * _, t3[11] = y * s + v * p + $2 * h + T * b, y = n[12], v = n[13], $2 = n[14], T = n[15], t3[12] = y * i + v * a + $2 * u + T * f, t3[13] = y * o + v * c + $2 * d + T * g, t3[14] = y * r + v * l + $2 * m + T * _, t3[15] = y * s + v * p + $2 * h + T * b, t3;
  }
  static mul(t3, e, n) {
    return t3;
  }
  static translate(t3, e, n) {
    const i = n[0], o = n[1], r = n[2];
    if (e === t3) t3[12] = e[0] * i + e[4] * o + e[8] * r + e[12], t3[13] = e[1] * i + e[5] * o + e[9] * r + e[13], t3[14] = e[2] * i + e[6] * o + e[10] * r + e[14], t3[15] = e[3] * i + e[7] * o + e[11] * r + e[15];
    else {
      const n2 = e[0], s = e[1], a = e[2], c = e[3], l = e[4], p = e[5], u = e[6], d = e[7], m = e[8], h = e[9], f = e[10], g = e[11];
      t3[0] = n2, t3[1] = s, t3[2] = a, t3[3] = c, t3[4] = l, t3[5] = p, t3[6] = u, t3[7] = d, t3[8] = m, t3[9] = h, t3[10] = f, t3[11] = g, t3[12] = n2 * i + l * o + m * r + e[12], t3[13] = s * i + p * o + h * r + e[13], t3[14] = a * i + u * o + f * r + e[14], t3[15] = c * i + d * o + g * r + e[15];
    }
    return t3;
  }
  static scale(t3, e, n) {
    const i = n[0], o = n[1], r = n[2];
    return t3[0] = e[0] * i, t3[1] = e[1] * i, t3[2] = e[2] * i, t3[3] = e[3] * i, t3[4] = e[4] * o, t3[5] = e[5] * o, t3[6] = e[6] * o, t3[7] = e[7] * o, t3[8] = e[8] * r, t3[9] = e[9] * r, t3[10] = e[10] * r, t3[11] = e[11] * r, t3[12] = e[12], t3[13] = e[13], t3[14] = e[14], t3[15] = e[15], t3;
  }
  static rotate(t3, e, n, i) {
    let o = i[0], r = i[1], s = i[2], a = Math.sqrt(o * o + r * r + s * s);
    if (a < GLM_EPSILON) return null;
    a = 1 / a, o *= a, r *= a, s *= a;
    const c = Math.sin(n), l = Math.cos(n), p = 1 - l, u = e[0], d = e[1], m = e[2], h = e[3], f = e[4], g = e[5], _ = e[6], b = e[7], y = e[8], v = e[9], $2 = e[10], T = e[11], w = o * o * p + l, S = r * o * p + s * c, k = s * o * p - r * c, O = o * r * p - s * c, x = r * r * p + l, E = s * r * p + o * c, M = o * s * p + r * c, A = r * s * p - o * c, C = s * s * p + l;
    return t3[0] = u * w + f * S + y * k, t3[1] = d * w + g * S + v * k, t3[2] = m * w + _ * S + $2 * k, t3[3] = h * w + b * S + T * k, t3[4] = u * O + f * x + y * E, t3[5] = d * O + g * x + v * E, t3[6] = m * O + _ * x + $2 * E, t3[7] = h * O + b * x + T * E, t3[8] = u * M + f * A + y * C, t3[9] = d * M + g * A + v * C, t3[10] = m * M + _ * A + $2 * C, t3[11] = h * M + b * A + T * C, e !== t3 && (t3[12] = e[12], t3[13] = e[13], t3[14] = e[14], t3[15] = e[15]), t3;
  }
  static rotateX(t3, e, n) {
    const i = Math.sin(n), o = Math.cos(n), r = e[4], s = e[5], a = e[6], c = e[7], l = e[8], p = e[9], u = e[10], d = e[11];
    return e !== t3 && (t3[0] = e[0], t3[1] = e[1], t3[2] = e[2], t3[3] = e[3], t3[12] = e[12], t3[13] = e[13], t3[14] = e[14], t3[15] = e[15]), t3[4] = r * o + l * i, t3[5] = s * o + p * i, t3[6] = a * o + u * i, t3[7] = c * o + d * i, t3[8] = l * o - r * i, t3[9] = p * o - s * i, t3[10] = u * o - a * i, t3[11] = d * o - c * i, t3;
  }
  static rotateY(t3, e, n) {
    const i = Math.sin(n), o = Math.cos(n), r = e[0], s = e[1], a = e[2], c = e[3], l = e[8], p = e[9], u = e[10], d = e[11];
    return e !== t3 && (t3[4] = e[4], t3[5] = e[5], t3[6] = e[6], t3[7] = e[7], t3[12] = e[12], t3[13] = e[13], t3[14] = e[14], t3[15] = e[15]), t3[0] = r * o - l * i, t3[1] = s * o - p * i, t3[2] = a * o - u * i, t3[3] = c * o - d * i, t3[8] = r * i + l * o, t3[9] = s * i + p * o, t3[10] = a * i + u * o, t3[11] = c * i + d * o, t3;
  }
  static rotateZ(t3, e, n) {
    const i = Math.sin(n), o = Math.cos(n), r = e[0], s = e[1], a = e[2], c = e[3], l = e[4], p = e[5], u = e[6], d = e[7];
    return e !== t3 && (t3[8] = e[8], t3[9] = e[9], t3[10] = e[10], t3[11] = e[11], t3[12] = e[12], t3[13] = e[13], t3[14] = e[14], t3[15] = e[15]), t3[0] = r * o + l * i, t3[1] = s * o + p * i, t3[2] = a * o + u * i, t3[3] = c * o + d * i, t3[4] = l * o - r * i, t3[5] = p * o - s * i, t3[6] = u * o - a * i, t3[7] = d * o - c * i, t3;
  }
  static fromTranslation(t3, e) {
    return t3[0] = 1, t3[1] = 0, t3[2] = 0, t3[3] = 0, t3[4] = 0, t3[5] = 1, t3[6] = 0, t3[7] = 0, t3[8] = 0, t3[9] = 0, t3[10] = 1, t3[11] = 0, t3[12] = e[0], t3[13] = e[1], t3[14] = e[2], t3[15] = 1, t3;
  }
  static fromScaling(t3, e) {
    return t3[0] = e[0], t3[1] = 0, t3[2] = 0, t3[3] = 0, t3[4] = 0, t3[5] = e[1], t3[6] = 0, t3[7] = 0, t3[8] = 0, t3[9] = 0, t3[10] = e[2], t3[11] = 0, t3[12] = 0, t3[13] = 0, t3[14] = 0, t3[15] = 1, t3;
  }
  static fromRotation(t3, e, n) {
    let i = n[0], o = n[1], r = n[2], s = Math.sqrt(i * i + o * o + r * r);
    if (s < GLM_EPSILON) return null;
    s = 1 / s, i *= s, o *= s, r *= s;
    const a = Math.sin(e), c = Math.cos(e), l = 1 - c;
    return t3[0] = i * i * l + c, t3[1] = o * i * l + r * a, t3[2] = r * i * l - o * a, t3[3] = 0, t3[4] = i * o * l - r * a, t3[5] = o * o * l + c, t3[6] = r * o * l + i * a, t3[7] = 0, t3[8] = i * r * l + o * a, t3[9] = o * r * l - i * a, t3[10] = r * r * l + c, t3[11] = 0, t3[12] = 0, t3[13] = 0, t3[14] = 0, t3[15] = 1, t3;
  }
  static fromXRotation(t3, e) {
    const n = Math.sin(e), i = Math.cos(e);
    return t3[0] = 1, t3[1] = 0, t3[2] = 0, t3[3] = 0, t3[4] = 0, t3[5] = i, t3[6] = n, t3[7] = 0, t3[8] = 0, t3[9] = -n, t3[10] = i, t3[11] = 0, t3[12] = 0, t3[13] = 0, t3[14] = 0, t3[15] = 1, t3;
  }
  static fromYRotation(t3, e) {
    const n = Math.sin(e), i = Math.cos(e);
    return t3[0] = i, t3[1] = 0, t3[2] = -n, t3[3] = 0, t3[4] = 0, t3[5] = 1, t3[6] = 0, t3[7] = 0, t3[8] = n, t3[9] = 0, t3[10] = i, t3[11] = 0, t3[12] = 0, t3[13] = 0, t3[14] = 0, t3[15] = 1, t3;
  }
  static fromZRotation(t3, e) {
    const n = Math.sin(e), i = Math.cos(e);
    return t3[0] = i, t3[1] = n, t3[2] = 0, t3[3] = 0, t3[4] = -n, t3[5] = i, t3[6] = 0, t3[7] = 0, t3[8] = 0, t3[9] = 0, t3[10] = 1, t3[11] = 0, t3[12] = 0, t3[13] = 0, t3[14] = 0, t3[15] = 1, t3;
  }
  static fromRotationTranslation(t3, e, n) {
    const i = e[0], o = e[1], r = e[2], s = e[3], a = i + i, c = o + o, l = r + r, p = i * a, u = i * c, d = i * l, m = o * c, h = o * l, f = r * l, g = s * a, _ = s * c, b = s * l;
    return t3[0] = 1 - (m + f), t3[1] = u + b, t3[2] = d - _, t3[3] = 0, t3[4] = u - b, t3[5] = 1 - (p + f), t3[6] = h + g, t3[7] = 0, t3[8] = d + _, t3[9] = h - g, t3[10] = 1 - (p + m), t3[11] = 0, t3[12] = n[0], t3[13] = n[1], t3[14] = n[2], t3[15] = 1, t3;
  }
  static fromQuat2(e, n) {
    const i = -n[0], o = -n[1], r = -n[2], s = n[3], a = n[4], c = n[5], l = n[6], p = n[7], u = i * i + o * o + r * r + s * s;
    return u > 0 ? (t.#y[0] = 2 * (a * s + p * i + c * r - l * o) / u, t.#y[1] = 2 * (c * s + p * o + l * i - a * r) / u, t.#y[2] = 2 * (l * s + p * r + a * o - c * i) / u) : (t.#y[0] = 2 * (a * s + p * i + c * r - l * o), t.#y[1] = 2 * (c * s + p * o + l * i - a * r), t.#y[2] = 2 * (l * s + p * r + a * o - c * i)), t.fromRotationTranslation(e, n, t.#y), e;
  }
  static normalFromMat4(t3, e) {
    const n = e[0], i = e[1], o = e[2], r = e[3], s = e[4], a = e[5], c = e[6], l = e[7], p = e[8], u = e[9], d = e[10], m = e[11], h = e[12], f = e[13], g = e[14], _ = e[15], b = n * a - i * s, y = n * c - o * s, v = n * l - r * s, $2 = i * c - o * a, T = i * l - r * a, w = o * l - r * c, S = p * f - u * h, k = p * g - d * h, O = p * _ - m * h, x = u * g - d * f, E = u * _ - m * f, M = d * _ - m * g;
    let A = b * M - y * E + v * x + $2 * O - T * k + w * S;
    return A ? (A = 1 / A, t3[0] = (a * M - c * E + l * x) * A, t3[1] = (c * O - s * M - l * k) * A, t3[2] = (s * E - a * O + l * S) * A, t3[3] = 0, t3[4] = (o * E - i * M - r * x) * A, t3[5] = (n * M - o * O + r * k) * A, t3[6] = (i * O - n * E - r * S) * A, t3[7] = 0, t3[8] = (f * w - g * T + _ * $2) * A, t3[9] = (g * v - h * w - _ * y) * A, t3[10] = (h * T - f * v + _ * b) * A, t3[11] = 0, t3[12] = 0, t3[13] = 0, t3[14] = 0, t3[15] = 1, t3) : null;
  }
  static normalFromMat4Fast(t3, e) {
    const n = e[0], i = e[1], o = e[2], r = e[4], s = e[5], a = e[6], c = e[8], l = e[9], p = e[10];
    return t3[0] = s * p - p * l, t3[1] = a * c - c * p, t3[2] = r * l - l * c, t3[3] = 0, t3[4] = l * o - p * i, t3[5] = p * n - c * o, t3[6] = c * i - l * n, t3[7] = 0, t3[8] = i * a - o * s, t3[9] = o * r - n * a, t3[10] = n * s - i * r, t3[11] = 0, t3[12] = 0, t3[13] = 0, t3[14] = 0, t3[15] = 1, t3;
  }
  static getTranslation(t3, e) {
    return t3[0] = e[12], t3[1] = e[13], t3[2] = e[14], t3;
  }
  static getScaling(t3, e) {
    const n = e[0], i = e[1], o = e[2], r = e[4], s = e[5], a = e[6], c = e[8], l = e[9], p = e[10];
    return t3[0] = Math.sqrt(n * n + i * i + o * o), t3[1] = Math.sqrt(r * r + s * s + a * a), t3[2] = Math.sqrt(c * c + l * l + p * p), t3;
  }
  static getRotation(e, n) {
    t.getScaling(t.#y, n);
    const i = 1 / t.#y[0], o = 1 / t.#y[1], r = 1 / t.#y[2], s = n[0] * i, a = n[1] * o, c = n[2] * r, l = n[4] * i, p = n[5] * o, u = n[6] * r, d = n[8] * i, m = n[9] * o, h = n[10] * r, f = s + p + h;
    let g = 0;
    return f > 0 ? (g = 2 * Math.sqrt(f + 1), e[3] = 0.25 * g, e[0] = (u - m) / g, e[1] = (d - c) / g, e[2] = (a - l) / g) : s > p && s > h ? (g = 2 * Math.sqrt(1 + s - p - h), e[3] = (u - m) / g, e[0] = 0.25 * g, e[1] = (a + l) / g, e[2] = (d + c) / g) : p > h ? (g = 2 * Math.sqrt(1 + p - s - h), e[3] = (d - c) / g, e[0] = (a + l) / g, e[1] = 0.25 * g, e[2] = (u + m) / g) : (g = 2 * Math.sqrt(1 + h - s - p), e[3] = (a - l) / g, e[0] = (d + c) / g, e[1] = (u + m) / g, e[2] = 0.25 * g), e;
  }
  static decompose(t3, e, n, i) {
    e[0] = i[12], e[1] = i[13], e[2] = i[14];
    const o = i[0], r = i[1], s = i[2], a = i[4], c = i[5], l = i[6], p = i[8], u = i[9], d = i[10];
    n[0] = Math.sqrt(o * o + r * r + s * s), n[1] = Math.sqrt(a * a + c * c + l * l), n[2] = Math.sqrt(p * p + u * u + d * d);
    const m = 1 / n[0], h = 1 / n[1], f = 1 / n[2], g = o * m, _ = r * h, b = s * f, y = a * m, v = c * h, $2 = l * f, T = p * m, w = u * h, S = d * f, k = g + v + S;
    let O = 0;
    return k > 0 ? (O = 2 * Math.sqrt(k + 1), t3[3] = 0.25 * O, t3[0] = ($2 - w) / O, t3[1] = (T - b) / O, t3[2] = (_ - y) / O) : g > v && g > S ? (O = 2 * Math.sqrt(1 + g - v - S), t3[3] = ($2 - w) / O, t3[0] = 0.25 * O, t3[1] = (_ + y) / O, t3[2] = (T + b) / O) : v > S ? (O = 2 * Math.sqrt(1 + v - g - S), t3[3] = (T - b) / O, t3[0] = (_ + y) / O, t3[1] = 0.25 * O, t3[2] = ($2 + w) / O) : (O = 2 * Math.sqrt(1 + S - g - v), t3[3] = (_ - y) / O, t3[0] = (T + b) / O, t3[1] = ($2 + w) / O, t3[2] = 0.25 * O), t3;
  }
  static fromRotationTranslationScale(t3, e, n, i) {
    const o = e[0], r = e[1], s = e[2], a = e[3], c = o + o, l = r + r, p = s + s, u = o * c, d = o * l, m = o * p, h = r * l, f = r * p, g = s * p, _ = a * c, b = a * l, y = a * p, v = i[0], $2 = i[1], T = i[2];
    return t3[0] = (1 - (h + g)) * v, t3[1] = (d + y) * v, t3[2] = (m - b) * v, t3[3] = 0, t3[4] = (d - y) * $2, t3[5] = (1 - (u + g)) * $2, t3[6] = (f + _) * $2, t3[7] = 0, t3[8] = (m + b) * T, t3[9] = (f - _) * T, t3[10] = (1 - (u + h)) * T, t3[11] = 0, t3[12] = n[0], t3[13] = n[1], t3[14] = n[2], t3[15] = 1, t3;
  }
  static fromRotationTranslationScaleOrigin(t3, e, n, i, o) {
    const r = e[0], s = e[1], a = e[2], c = e[3], l = r + r, p = s + s, u = a + a, d = r * l, m = r * p, h = r * u, f = s * p, g = s * u, _ = a * u, b = c * l, y = c * p, v = c * u, $2 = i[0], T = i[1], w = i[2], S = o[0], k = o[1], O = o[2], x = (1 - (f + _)) * $2, E = (m + v) * $2, M = (h - y) * $2, A = (m - v) * T, C = (1 - (d + _)) * T, I = (g + b) * T, P = (h + y) * w, D = (g - b) * w, N = (1 - (d + f)) * w;
    return t3[0] = x, t3[1] = E, t3[2] = M, t3[3] = 0, t3[4] = A, t3[5] = C, t3[6] = I, t3[7] = 0, t3[8] = P, t3[9] = D, t3[10] = N, t3[11] = 0, t3[12] = n[0] + S - (x * S + A * k + P * O), t3[13] = n[1] + k - (E * S + C * k + D * O), t3[14] = n[2] + O - (M * S + I * k + N * O), t3[15] = 1, t3;
  }
  static fromQuat(t3, e) {
    const n = e[0], i = e[1], o = e[2], r = e[3], s = n + n, a = i + i, c = o + o, l = n * s, p = i * s, u = i * a, d = o * s, m = o * a, h = o * c, f = r * s, g = r * a, _ = r * c;
    return t3[0] = 1 - u - h, t3[1] = p + _, t3[2] = d - g, t3[3] = 0, t3[4] = p - _, t3[5] = 1 - l - h, t3[6] = m + f, t3[7] = 0, t3[8] = d + g, t3[9] = m - f, t3[10] = 1 - l - u, t3[11] = 0, t3[12] = 0, t3[13] = 0, t3[14] = 0, t3[15] = 1, t3;
  }
  static frustumNO(t3, e, n, i, o, r, s = 1 / 0) {
    const a = 1 / (n - e), c = 1 / (o - i);
    if (t3[0] = 2 * r * a, t3[1] = 0, t3[2] = 0, t3[3] = 0, t3[4] = 0, t3[5] = 2 * r * c, t3[6] = 0, t3[7] = 0, t3[8] = (n + e) * a, t3[9] = (o + i) * c, t3[11] = -1, t3[12] = 0, t3[13] = 0, t3[15] = 0, null != s && s !== 1 / 0) {
      const e2 = 1 / (r - s);
      t3[10] = (s + r) * e2, t3[14] = 2 * s * r * e2;
    } else t3[10] = -1, t3[14] = -2 * r;
    return t3;
  }
  static frustum(t3, e, n, i, o, r, s = 1 / 0) {
    return t3;
  }
  static frustumZO(t3, e, n, i, o, r, s = 1 / 0) {
    const a = 1 / (n - e), c = 1 / (o - i);
    if (t3[0] = 2 * r * a, t3[1] = 0, t3[2] = 0, t3[3] = 0, t3[4] = 0, t3[5] = 2 * r * c, t3[6] = 0, t3[7] = 0, t3[8] = (n + e) * a, t3[9] = (o + i) * c, t3[11] = -1, t3[12] = 0, t3[13] = 0, t3[15] = 0, null != s && s !== 1 / 0) {
      const e2 = 1 / (r - s);
      t3[10] = s * e2, t3[14] = s * r * e2;
    } else t3[10] = -1, t3[14] = -r;
    return t3;
  }
  static perspectiveNO(t3, e, n, i, o = 1 / 0) {
    const r = 1 / Math.tan(e / 2);
    if (t3[0] = r / n, t3[1] = 0, t3[2] = 0, t3[3] = 0, t3[4] = 0, t3[5] = r, t3[6] = 0, t3[7] = 0, t3[8] = 0, t3[9] = 0, t3[11] = -1, t3[12] = 0, t3[13] = 0, t3[15] = 0, null != o && o !== 1 / 0) {
      const e2 = 1 / (i - o);
      t3[10] = (o + i) * e2, t3[14] = 2 * o * i * e2;
    } else t3[10] = -1, t3[14] = -2 * i;
    return t3;
  }
  static perspective(t3, e, n, i, o = 1 / 0) {
    return t3;
  }
  static perspectiveZO(t3, e, n, i, o = 1 / 0) {
    const r = 1 / Math.tan(e / 2);
    if (t3[0] = r / n, t3[1] = 0, t3[2] = 0, t3[3] = 0, t3[4] = 0, t3[5] = r, t3[6] = 0, t3[7] = 0, t3[8] = 0, t3[9] = 0, t3[11] = -1, t3[12] = 0, t3[13] = 0, t3[15] = 0, null != o && o !== 1 / 0) {
      const e2 = 1 / (i - o);
      t3[10] = o * e2, t3[14] = o * i * e2;
    } else t3[10] = -1, t3[14] = -i;
    return t3;
  }
  static perspectiveFromFieldOfView(t3, e, n, i) {
    const o = Math.tan(e.upDegrees * Math.PI / 180), r = Math.tan(e.downDegrees * Math.PI / 180), s = Math.tan(e.leftDegrees * Math.PI / 180), a = Math.tan(e.rightDegrees * Math.PI / 180), c = 2 / (s + a), l = 2 / (o + r);
    return t3[0] = c, t3[1] = 0, t3[2] = 0, t3[3] = 0, t3[4] = 0, t3[5] = l, t3[6] = 0, t3[7] = 0, t3[8] = -(s - a) * c * 0.5, t3[9] = (o - r) * l * 0.5, t3[10] = i / (n - i), t3[11] = -1, t3[12] = 0, t3[13] = 0, t3[14] = i * n / (n - i), t3[15] = 0, t3;
  }
  static orthoNO(t3, e, n, i, o, r, s) {
    const a = 1 / (e - n), c = 1 / (i - o), l = 1 / (r - s);
    return t3[0] = -2 * a, t3[1] = 0, t3[2] = 0, t3[3] = 0, t3[4] = 0, t3[5] = -2 * c, t3[6] = 0, t3[7] = 0, t3[8] = 0, t3[9] = 0, t3[10] = 2 * l, t3[11] = 0, t3[12] = (e + n) * a, t3[13] = (o + i) * c, t3[14] = (s + r) * l, t3[15] = 1, t3;
  }
  static ortho(t3, e, n, i, o, r, s) {
    return t3;
  }
  static orthoZO(t3, e, n, i, o, r, s) {
    const a = 1 / (e - n), c = 1 / (i - o), l = 1 / (r - s);
    return t3[0] = -2 * a, t3[1] = 0, t3[2] = 0, t3[3] = 0, t3[4] = 0, t3[5] = -2 * c, t3[6] = 0, t3[7] = 0, t3[8] = 0, t3[9] = 0, t3[10] = l, t3[11] = 0, t3[12] = (e + n) * a, t3[13] = (o + i) * c, t3[14] = r * l, t3[15] = 1, t3;
  }
  static lookAt(e, n, i, o) {
    const r = n[0], s = n[1], a = n[2], c = o[0], l = o[1], p = o[2], u = i[0], d = i[1], m = i[2];
    if (Math.abs(r - u) < GLM_EPSILON && Math.abs(s - d) < GLM_EPSILON && Math.abs(a - m) < GLM_EPSILON) return t.identity(e);
    let h = r - u, f = s - d, g = a - m, _ = 1 / Math.sqrt(h * h + f * f + g * g);
    h *= _, f *= _, g *= _;
    let b = l * g - p * f, y = p * h - c * g, v = c * f - l * h;
    _ = Math.sqrt(b * b + y * y + v * v), _ ? (_ = 1 / _, b *= _, y *= _, v *= _) : (b = 0, y = 0, v = 0);
    let $2 = f * v - g * y, T = g * b - h * v, w = h * y - f * b;
    return _ = Math.sqrt($2 * $2 + T * T + w * w), _ ? (_ = 1 / _, $2 *= _, T *= _, w *= _) : ($2 = 0, T = 0, w = 0), e[0] = b, e[1] = $2, e[2] = h, e[3] = 0, e[4] = y, e[5] = T, e[6] = f, e[7] = 0, e[8] = v, e[9] = w, e[10] = g, e[11] = 0, e[12] = -(b * r + y * s + v * a), e[13] = -($2 * r + T * s + w * a), e[14] = -(h * r + f * s + g * a), e[15] = 1, e;
  }
  static targetTo(t3, e, n, i) {
    const o = e[0], r = e[1], s = e[2], a = i[0], c = i[1], l = i[2];
    let p = o - n[0], u = r - n[1], d = s - n[2], m = p * p + u * u + d * d;
    m > 0 && (m = 1 / Math.sqrt(m), p *= m, u *= m, d *= m);
    let h = c * d - l * u, f = l * p - a * d, g = a * u - c * p;
    return m = h * h + f * f + g * g, m > 0 && (m = 1 / Math.sqrt(m), h *= m, f *= m, g *= m), t3[0] = h, t3[1] = f, t3[2] = g, t3[3] = 0, t3[4] = u * g - d * f, t3[5] = d * h - p * g, t3[6] = p * f - u * h, t3[7] = 0, t3[8] = p, t3[9] = u, t3[10] = d, t3[11] = 0, t3[12] = o, t3[13] = r, t3[14] = s, t3[15] = 1, t3;
  }
  static frob(t3) {
    return Math.sqrt(t3[0] * t3[0] + t3[1] * t3[1] + t3[2] * t3[2] + t3[3] * t3[3] + t3[4] * t3[4] + t3[5] * t3[5] + t3[6] * t3[6] + t3[7] * t3[7] + t3[8] * t3[8] + t3[9] * t3[9] + t3[10] * t3[10] + t3[11] * t3[11] + t3[12] * t3[12] + t3[13] * t3[13] + t3[14] * t3[14] + t3[15] * t3[15]);
  }
  static add(t3, e, n) {
    return t3[0] = e[0] + n[0], t3[1] = e[1] + n[1], t3[2] = e[2] + n[2], t3[3] = e[3] + n[3], t3[4] = e[4] + n[4], t3[5] = e[5] + n[5], t3[6] = e[6] + n[6], t3[7] = e[7] + n[7], t3[8] = e[8] + n[8], t3[9] = e[9] + n[9], t3[10] = e[10] + n[10], t3[11] = e[11] + n[11], t3[12] = e[12] + n[12], t3[13] = e[13] + n[13], t3[14] = e[14] + n[14], t3[15] = e[15] + n[15], t3;
  }
  static subtract(t3, e, n) {
    return t3[0] = e[0] - n[0], t3[1] = e[1] - n[1], t3[2] = e[2] - n[2], t3[3] = e[3] - n[3], t3[4] = e[4] - n[4], t3[5] = e[5] - n[5], t3[6] = e[6] - n[6], t3[7] = e[7] - n[7], t3[8] = e[8] - n[8], t3[9] = e[9] - n[9], t3[10] = e[10] - n[10], t3[11] = e[11] - n[11], t3[12] = e[12] - n[12], t3[13] = e[13] - n[13], t3[14] = e[14] - n[14], t3[15] = e[15] - n[15], t3;
  }
  static sub(t3, e, n) {
    return t3;
  }
  static multiplyScalar(t3, e, n) {
    return t3[0] = e[0] * n, t3[1] = e[1] * n, t3[2] = e[2] * n, t3[3] = e[3] * n, t3[4] = e[4] * n, t3[5] = e[5] * n, t3[6] = e[6] * n, t3[7] = e[7] * n, t3[8] = e[8] * n, t3[9] = e[9] * n, t3[10] = e[10] * n, t3[11] = e[11] * n, t3[12] = e[12] * n, t3[13] = e[13] * n, t3[14] = e[14] * n, t3[15] = e[15] * n, t3;
  }
  static multiplyScalarAndAdd(t3, e, n, i) {
    return t3[0] = e[0] + n[0] * i, t3[1] = e[1] + n[1] * i, t3[2] = e[2] + n[2] * i, t3[3] = e[3] + n[3] * i, t3[4] = e[4] + n[4] * i, t3[5] = e[5] + n[5] * i, t3[6] = e[6] + n[6] * i, t3[7] = e[7] + n[7] * i, t3[8] = e[8] + n[8] * i, t3[9] = e[9] + n[9] * i, t3[10] = e[10] + n[10] * i, t3[11] = e[11] + n[11] * i, t3[12] = e[12] + n[12] * i, t3[13] = e[13] + n[13] * i, t3[14] = e[14] + n[14] * i, t3[15] = e[15] + n[15] * i, t3;
  }
  static exactEquals(t3, e) {
    return t3[0] === e[0] && t3[1] === e[1] && t3[2] === e[2] && t3[3] === e[3] && t3[4] === e[4] && t3[5] === e[5] && t3[6] === e[6] && t3[7] === e[7] && t3[8] === e[8] && t3[9] === e[9] && t3[10] === e[10] && t3[11] === e[11] && t3[12] === e[12] && t3[13] === e[13] && t3[14] === e[14] && t3[15] === e[15];
  }
  static equals(t3, e) {
    const n = t3[0], i = t3[1], o = t3[2], r = t3[3], s = t3[4], a = t3[5], c = t3[6], l = t3[7], p = t3[8], u = t3[9], d = t3[10], m = t3[11], h = t3[12], f = t3[13], g = t3[14], _ = t3[15], b = e[0], y = e[1], v = e[2], $2 = e[3], T = e[4], w = e[5], S = e[6], k = e[7], O = e[8], x = e[9], E = e[10], M = e[11], A = e[12], C = e[13], I = e[14], P = e[15];
    return Math.abs(n - b) <= GLM_EPSILON * Math.max(1, Math.abs(n), Math.abs(b)) && Math.abs(i - y) <= GLM_EPSILON * Math.max(1, Math.abs(i), Math.abs(y)) && Math.abs(o - v) <= GLM_EPSILON * Math.max(1, Math.abs(o), Math.abs(v)) && Math.abs(r - $2) <= GLM_EPSILON * Math.max(1, Math.abs(r), Math.abs($2)) && Math.abs(s - T) <= GLM_EPSILON * Math.max(1, Math.abs(s), Math.abs(T)) && Math.abs(a - w) <= GLM_EPSILON * Math.max(1, Math.abs(a), Math.abs(w)) && Math.abs(c - S) <= GLM_EPSILON * Math.max(1, Math.abs(c), Math.abs(S)) && Math.abs(l - k) <= GLM_EPSILON * Math.max(1, Math.abs(l), Math.abs(k)) && Math.abs(p - O) <= GLM_EPSILON * Math.max(1, Math.abs(p), Math.abs(O)) && Math.abs(u - x) <= GLM_EPSILON * Math.max(1, Math.abs(u), Math.abs(x)) && Math.abs(d - E) <= GLM_EPSILON * Math.max(1, Math.abs(d), Math.abs(E)) && Math.abs(m - M) <= GLM_EPSILON * Math.max(1, Math.abs(m), Math.abs(M)) && Math.abs(h - A) <= GLM_EPSILON * Math.max(1, Math.abs(h), Math.abs(A)) && Math.abs(f - C) <= GLM_EPSILON * Math.max(1, Math.abs(f), Math.abs(C)) && Math.abs(g - I) <= GLM_EPSILON * Math.max(1, Math.abs(g), Math.abs(I)) && Math.abs(_ - P) <= GLM_EPSILON * Math.max(1, Math.abs(_), Math.abs(P));
  }
  static str(t3) {
    return `Mat4(${t3.join(", ")})`;
  }
};
Mat4.prototype.mul = Mat4.prototype.multiply, Mat4.sub = Mat4.subtract, Mat4.mul = Mat4.multiply, Mat4.frustum = Mat4.frustumNO, Mat4.perspective = Mat4.perspectiveNO, Mat4.ortho = Mat4.orthoNO;
var Vec3 = class t2 extends Float32Array {
  constructor(...t3) {
    switch (t3.length) {
      case 3:
        super(t3);
        break;
      case 2:
        super(t3[0], t3[1], 3);
        break;
      case 1: {
        const e = t3[0];
        "number" == typeof e ? super([e, e, e]) : super(e, 0, 3);
        break;
      }
      default:
        super(3);
    }
  }
  get x() {
    return this[0];
  }
  set x(t3) {
    this[0] = t3;
  }
  get y() {
    return this[1];
  }
  set y(t3) {
    this[1] = t3;
  }
  get z() {
    return this[2];
  }
  set z(t3) {
    this[2] = t3;
  }
  get r() {
    return this[0];
  }
  set r(t3) {
    this[0] = t3;
  }
  get g() {
    return this[1];
  }
  set g(t3) {
    this[1] = t3;
  }
  get b() {
    return this[2];
  }
  set b(t3) {
    this[2] = t3;
  }
  get magnitude() {
    const t3 = this[0], e = this[1], n = this[2];
    return Math.sqrt(t3 * t3 + e * e + n * n);
  }
  get mag() {
    return this.magnitude;
  }
  get squaredMagnitude() {
    const t3 = this[0], e = this[1], n = this[2];
    return t3 * t3 + e * e + n * n;
  }
  get sqrMag() {
    return this.squaredMagnitude;
  }
  get str() {
    return t2.str(this);
  }
  copy(t3) {
    return this.set(t3), this;
  }
  add(t3) {
    return this[0] += t3[0], this[1] += t3[1], this[2] += t3[2], this;
  }
  subtract(t3) {
    return this[0] -= t3[0], this[1] -= t3[1], this[2] -= t3[2], this;
  }
  sub(t3) {
    return this;
  }
  multiply(t3) {
    return this[0] *= t3[0], this[1] *= t3[1], this[2] *= t3[2], this;
  }
  mul(t3) {
    return this;
  }
  divide(t3) {
    return this[0] /= t3[0], this[1] /= t3[1], this[2] /= t3[2], this;
  }
  div(t3) {
    return this;
  }
  scale(t3) {
    return this[0] *= t3, this[1] *= t3, this[2] *= t3, this;
  }
  scaleAndAdd(t3, e) {
    return this[0] += t3[0] * e, this[1] += t3[1] * e, this[2] += t3[2] * e, this;
  }
  distance(e) {
    return t2.distance(this, e);
  }
  dist(t3) {
    return 0;
  }
  squaredDistance(e) {
    return t2.squaredDistance(this, e);
  }
  sqrDist(t3) {
    return 0;
  }
  negate() {
    return this[0] *= -1, this[1] *= -1, this[2] *= -1, this;
  }
  invert() {
    return this[0] = 1 / this[0], this[1] = 1 / this[1], this[2] = 1 / this[2], this;
  }
  abs() {
    return this[0] = Math.abs(this[0]), this[1] = Math.abs(this[1]), this[2] = Math.abs(this[2]), this;
  }
  dot(t3) {
    return this[0] * t3[0] + this[1] * t3[1] + this[2] * t3[2];
  }
  normalize() {
    return t2.normalize(this, this);
  }
  static get BYTE_LENGTH() {
    return 3 * Float32Array.BYTES_PER_ELEMENT;
  }
  static create() {
    return new t2();
  }
  static clone(e) {
    return new t2(e);
  }
  static magnitude(t3) {
    const e = t3[0], n = t3[1], i = t3[2];
    return Math.sqrt(e * e + n * n + i * i);
  }
  static mag(t3) {
    return 0;
  }
  static length(t3) {
    return 0;
  }
  static len(t3) {
    return 0;
  }
  static fromValues(e, n, i) {
    return new t2(e, n, i);
  }
  static copy(t3, e) {
    return t3[0] = e[0], t3[1] = e[1], t3[2] = e[2], t3;
  }
  static set(t3, e, n, i) {
    return t3[0] = e, t3[1] = n, t3[2] = i, t3;
  }
  static add(t3, e, n) {
    return t3[0] = e[0] + n[0], t3[1] = e[1] + n[1], t3[2] = e[2] + n[2], t3;
  }
  static subtract(t3, e, n) {
    return t3[0] = e[0] - n[0], t3[1] = e[1] - n[1], t3[2] = e[2] - n[2], t3;
  }
  static sub(t3, e, n) {
    return [0, 0, 0];
  }
  static multiply(t3, e, n) {
    return t3[0] = e[0] * n[0], t3[1] = e[1] * n[1], t3[2] = e[2] * n[2], t3;
  }
  static mul(t3, e, n) {
    return [0, 0, 0];
  }
  static divide(t3, e, n) {
    return t3[0] = e[0] / n[0], t3[1] = e[1] / n[1], t3[2] = e[2] / n[2], t3;
  }
  static div(t3, e, n) {
    return [0, 0, 0];
  }
  static ceil(t3, e) {
    return t3[0] = Math.ceil(e[0]), t3[1] = Math.ceil(e[1]), t3[2] = Math.ceil(e[2]), t3;
  }
  static floor(t3, e) {
    return t3[0] = Math.floor(e[0]), t3[1] = Math.floor(e[1]), t3[2] = Math.floor(e[2]), t3;
  }
  static min(t3, e, n) {
    return t3[0] = Math.min(e[0], n[0]), t3[1] = Math.min(e[1], n[1]), t3[2] = Math.min(e[2], n[2]), t3;
  }
  static max(t3, e, n) {
    return t3[0] = Math.max(e[0], n[0]), t3[1] = Math.max(e[1], n[1]), t3[2] = Math.max(e[2], n[2]), t3;
  }
  static scale(t3, e, n) {
    return t3[0] = e[0] * n, t3[1] = e[1] * n, t3[2] = e[2] * n, t3;
  }
  static scaleAndAdd(t3, e, n, i) {
    return t3[0] = e[0] + n[0] * i, t3[1] = e[1] + n[1] * i, t3[2] = e[2] + n[2] * i, t3;
  }
  static distance(t3, e) {
    const n = e[0] - t3[0], i = e[1] - t3[1], o = e[2] - t3[2];
    return Math.sqrt(n * n + i * i + o * o);
  }
  static dist(t3, e) {
    return 0;
  }
  static squaredDistance(t3, e) {
    const n = e[0] - t3[0], i = e[1] - t3[1], o = e[2] - t3[2];
    return n * n + i * i + o * o;
  }
  static sqrDist(t3, e) {
    return 0;
  }
  static squaredLength(t3) {
    const e = t3[0], n = t3[1], i = t3[2];
    return e * e + n * n + i * i;
  }
  static sqrLen(t3, e) {
    return 0;
  }
  static negate(t3, e) {
    return t3[0] = -e[0], t3[1] = -e[1], t3[2] = -e[2], t3;
  }
  static inverse(t3, e) {
    return t3[0] = 1 / e[0], t3[1] = 1 / e[1], t3[2] = 1 / e[2], t3;
  }
  static abs(t3, e) {
    return t3[0] = Math.abs(e[0]), t3[1] = Math.abs(e[1]), t3[2] = Math.abs(e[2]), t3;
  }
  static normalize(t3, e) {
    const n = e[0], i = e[1], o = e[2];
    let r = n * n + i * i + o * o;
    return r > 0 && (r = 1 / Math.sqrt(r)), t3[0] = e[0] * r, t3[1] = e[1] * r, t3[2] = e[2] * r, t3;
  }
  static dot(t3, e) {
    return t3[0] * e[0] + t3[1] * e[1] + t3[2] * e[2];
  }
  static cross(t3, e, n) {
    const i = e[0], o = e[1], r = e[2], s = n[0], a = n[1], c = n[2];
    return t3[0] = o * c - r * a, t3[1] = r * s - i * c, t3[2] = i * a - o * s, t3;
  }
  static lerp(t3, e, n, i) {
    const o = e[0], r = e[1], s = e[2];
    return t3[0] = o + i * (n[0] - o), t3[1] = r + i * (n[1] - r), t3[2] = s + i * (n[2] - s), t3;
  }
  static slerp(e, n, i, o) {
    const r = Math.acos(Math.min(Math.max(t2.dot(n, i), -1), 1)), s = Math.sin(r), a = Math.sin((1 - o) * r) / s, c = Math.sin(o * r) / s;
    return e[0] = a * n[0] + c * i[0], e[1] = a * n[1] + c * i[1], e[2] = a * n[2] + c * i[2], e;
  }
  static hermite(t3, e, n, i, o, r) {
    const s = r * r, a = s * (2 * r - 3) + 1, c = s * (r - 2) + r, l = s * (r - 1), p = s * (3 - 2 * r);
    return t3[0] = e[0] * a + n[0] * c + i[0] * l + o[0] * p, t3[1] = e[1] * a + n[1] * c + i[1] * l + o[1] * p, t3[2] = e[2] * a + n[2] * c + i[2] * l + o[2] * p, t3;
  }
  static bezier(t3, e, n, i, o, r) {
    const s = 1 - r, a = s * s, c = r * r, l = a * s, p = 3 * r * a, u = 3 * c * s, d = c * r;
    return t3[0] = e[0] * l + n[0] * p + i[0] * u + o[0] * d, t3[1] = e[1] * l + n[1] * p + i[1] * u + o[1] * d, t3[2] = e[2] * l + n[2] * p + i[2] * u + o[2] * d, t3;
  }
  static transformMat4(t3, e, n) {
    const i = e[0], o = e[1], r = e[2], s = n[3] * i + n[7] * o + n[11] * r + n[15] || 1;
    return t3[0] = (n[0] * i + n[4] * o + n[8] * r + n[12]) / s, t3[1] = (n[1] * i + n[5] * o + n[9] * r + n[13]) / s, t3[2] = (n[2] * i + n[6] * o + n[10] * r + n[14]) / s, t3;
  }
  static transformMat3(t3, e, n) {
    const i = e[0], o = e[1], r = e[2];
    return t3[0] = i * n[0] + o * n[3] + r * n[6], t3[1] = i * n[1] + o * n[4] + r * n[7], t3[2] = i * n[2] + o * n[5] + r * n[8], t3;
  }
  static transformQuat(t3, e, n) {
    const i = n[0], o = n[1], r = n[2], s = 2 * n[3], a = e[0], c = e[1], l = e[2], p = o * l - r * c, u = r * a - i * l, d = i * c - o * a, m = 2 * (o * d - r * u), h = 2 * (r * p - i * d), f = 2 * (i * u - o * p);
    return t3[0] = a + p * s + m, t3[1] = c + u * s + h, t3[2] = l + d * s + f, t3;
  }
  static rotateX(t3, e, n, i) {
    const o = n[1], r = n[2], s = e[1] - o, a = e[2] - r;
    return t3[0] = e[0], t3[1] = s * Math.cos(i) - a * Math.sin(i) + o, t3[2] = s * Math.sin(i) + a * Math.cos(i) + r, t3;
  }
  static rotateY(t3, e, n, i) {
    const o = n[0], r = n[2], s = e[0] - o, a = e[2] - r;
    return t3[0] = a * Math.sin(i) + s * Math.cos(i) + o, t3[1] = e[1], t3[2] = a * Math.cos(i) - s * Math.sin(i) + r, t3;
  }
  static rotateZ(t3, e, n, i) {
    const o = n[0], r = n[1], s = e[0] - o, a = e[1] - r;
    return t3[0] = s * Math.cos(i) - a * Math.sin(i) + o, t3[1] = s * Math.sin(i) + a * Math.cos(i) + r, t3[2] = n[2], t3;
  }
  static angle(e, n) {
    const i = e[0], o = e[1], r = e[2], s = n[0], a = n[1], c = n[2], l = Math.sqrt((i * i + o * o + r * r) * (s * s + a * a + c * c)), p = l && t2.dot(e, n) / l;
    return Math.acos(Math.min(Math.max(p, -1), 1));
  }
  static zero(t3) {
    return t3[0] = 0, t3[1] = 0, t3[2] = 0, t3;
  }
  static str(t3) {
    return `Vec3(${t3.join(", ")})`;
  }
  static exactEquals(t3, e) {
    return t3[0] === e[0] && t3[1] === e[1] && t3[2] === e[2];
  }
  static equals(t3, e) {
    const n = t3[0], i = t3[1], o = t3[2], r = e[0], s = e[1], a = e[2];
    return Math.abs(n - r) <= GLM_EPSILON * Math.max(1, Math.abs(n), Math.abs(r)) && Math.abs(i - s) <= GLM_EPSILON * Math.max(1, Math.abs(i), Math.abs(s)) && Math.abs(o - a) <= GLM_EPSILON * Math.max(1, Math.abs(o), Math.abs(a));
  }
}, _a;
Vec3.prototype.sub = Vec3.prototype.subtract, Vec3.prototype.mul = Vec3.prototype.multiply, Vec3.prototype.div = Vec3.prototype.divide, Vec3.prototype.dist = Vec3.prototype.distance, Vec3.prototype.sqrDist = Vec3.prototype.squaredDistance, Vec3.sub = Vec3.subtract, Vec3.mul = Vec3.multiply, Vec3.div = Vec3.divide, Vec3.dist = Vec3.distance, Vec3.sqrDist = Vec3.squaredDistance, Vec3.sqrLen = Vec3.squaredLength, Vec3.mag = Vec3.magnitude, Vec3.length = Vec3.magnitude, Vec3.len = Vec3.magnitude;
class StyleParse {
  static #v = /(\d+)\s*px/;
  static pixels(t3) {
    if ("string" != typeof t3) return;
    const e = this.#v.test(t3), n = parseInt(t3);
    return e && Number.isFinite(n) ? n : void 0;
  }
  static remPixels(t3 = 1, { targetDocument: e = document } = {}) {
    return e?.documentElement ? t3 * parseFloat(globalThis.getComputedStyle(e.documentElement).fontSize) : void 0;
  }
}
class TJSStyleManager {
  #$;
  #T;
  #w;
  #S;
  #k;
  constructor({ docKey: t3, selector: e = ":root", document: n = globalThis.document, version: i } = {}) {
    if ("string" != typeof t3) throw new TypeError("StyleManager error: 'docKey' is not a string.");
    if ("[object HTMLDocument]" !== Object.prototype.toString.call(n)) throw new TypeError("TJSStyleManager error: 'document' is not an instance of HTMLDocument.");
    if ("string" != typeof e) throw new TypeError("StyleManager error: 'selector' is not a string.");
    if (void 0 !== i && !Number.isSafeInteger(i) && i < 1) throw new TypeError("StyleManager error: 'version' is defined and is not a positive integer >= 1.");
    if (this.#w = e, this.#T = t3, this.#k = i, void 0 === n[this.#T]) this.#S = n.createElement("style"), n.head.append(this.#S), this.#S._STYLE_MANAGER_VERSION = i, this.#S.sheet.insertRule(`${e} {}`, 0), this.#$ = this.#S.sheet.cssRules[0], n[t3] = this.#S;
    else if (this.#S = n[t3], this.#$ = this.#S.sheet.cssRules[0], i) {
      i > (this.#S._STYLE_MANAGER_VERSION ?? 0) && (this.#$.style.cssText = "");
    }
  }
  get cssText() {
    return this.#$.style.cssText;
  }
  get version() {
    return this.#k;
  }
  clone(t3 = globalThis.document) {
    const e = new TJSStyleManager({ selector: this.#w, docKey: this.#T, document: t3, version: this.#k });
    return e.#$.style.cssText = this.#$.style.cssText, e;
  }
  get() {
    const t3 = this.#$.style.cssText, e = {};
    if ("" !== t3) {
      for (const n of t3.split(";")) if ("" !== n) {
        const t4 = n.split(":");
        e[t4[0].trim()] = t4[1];
      }
    }
    return e;
  }
  getProperty(t3) {
    if ("string" != typeof t3) throw new TypeError("StyleManager error: 'key' is not a string.");
    return this.#$.style.getPropertyValue(t3);
  }
  setProperties(t3, e = true) {
    if (!isObject(t3)) throw new TypeError("StyleManager error: 'rules' is not an object.");
    if ("boolean" != typeof e) throw new TypeError("StyleManager error: 'overwrite' is not a boolean.");
    if (e) for (const [e2, n] of Object.entries(t3)) this.#$.style.setProperty(e2, n);
    else for (const [e2, n] of Object.entries(t3)) "" === this.#$.style.getPropertyValue(e2) && this.#$.style.setProperty(e2, n);
  }
  setProperty(t3, e, n = true) {
    if ("string" != typeof t3) throw new TypeError("StyleManager error: 'key' is not a string.");
    if ("string" != typeof e) throw new TypeError("StyleManager error: 'value' is not a string.");
    if ("boolean" != typeof n) throw new TypeError("StyleManager error: 'overwrite' is not a boolean.");
    (n || "" === this.#$.style.getPropertyValue(t3)) && this.#$.style.setProperty(t3, e);
  }
  removeProperties(t3) {
    if (!isIterable(t3)) throw new TypeError("StyleManager error: 'keys' is not an iterable list.");
    for (const e of t3) "string" == typeof e && this.#$.style.removeProperty(e);
  }
  removeProperty(t3) {
    if ("string" != typeof t3) throw new TypeError("StyleManager error: 'key' is not a string.");
    return this.#$.style.removeProperty(t3);
  }
}
async function nextAnimationFrame(t3 = 1) {
  if (!Number.isInteger(t3) || t3 < 1) throw new TypeError("nextAnimationFrame error: 'cntr' must be a positive integer greater than 0.");
  let e;
  for (; --t3 >= 0; ) e = await new Promise((t4) => requestAnimationFrame(t4));
  return e;
}
function draggable(t3, { position: e, enabled: n = true, button: i = 0, storeDragging: o, tween: r = false, tweenOptions: s = { duration: 1, ease: "cubicOut" }, hasTargetClassList: a, ignoreTargetClassList: c }) {
  if (void 0 !== a && !isIterable(a)) throw new TypeError("'hasTargetClassList' is not iterable.");
  if (void 0 !== c && !isIterable(c)) throw new TypeError("'ignoreTargetClassList' is not iterable.");
  const l = { left: 0, top: 0 };
  let p = e?.position ?? e, u = null, d = { x: 0, y: 0 }, m = false, h = p.animate.quickTo(["top", "left"], s);
  const f = { dragDown: ["pointerdown", function(e2) {
    if (e2.button !== i || !e2.isPrimary) return;
    if (!p.enabled) return;
    if (void 0 !== c && A11yHelper.isFocusTarget(e2.target)) {
      for (const t4 of c) if (e2.target.classList.contains(t4)) return;
    }
    if (void 0 !== a && A11yHelper.isFocusTarget(e2.target)) {
      let t4 = false;
      for (const n2 of a) if (e2.target.classList.contains(n2)) {
        t4 = true;
        break;
      }
      if (!t4) return;
    }
    e2.preventDefault(), m = false, u = p.get(), d = { x: e2.clientX, y: e2.clientY }, t3.addEventListener(...f.dragMove), t3.addEventListener(...f.dragUp), t3.setPointerCapture(e2.pointerId);
  }, false], dragMove: ["pointermove", function(t4) {
    if (!(1 & t4.buttons)) return void b(t4);
    if (-1 !== t4.button || !t4.isPrimary) return;
    t4.preventDefault(), m || "function" != typeof o?.set || (m = true, o.set(true));
    const e2 = u?.left + (t4.clientX - d.x), n2 = u?.top + (t4.clientY - d.y);
    r ? h(n2, e2) : (l.left = e2, l.top = n2, p.set(l));
  }, false], dragUp: ["pointerup", b, false] };
  function g() {
    t3.addEventListener(...f.dragDown), t3.classList.add("draggable");
  }
  function _() {
    "function" == typeof o?.set && o.set(false), t3.removeEventListener(...f.dragDown), t3.removeEventListener(...f.dragMove), t3.removeEventListener(...f.dragUp), t3.classList.remove("draggable");
  }
  function b(e2) {
    e2.preventDefault(), m = false, "function" == typeof o?.set && o.set(false), t3.removeEventListener(...f.dragMove), t3.removeEventListener(...f.dragUp);
  }
  return n && g(), { update: (t4) => {
    if (void 0 !== t4.position) {
      const e2 = t4.position?.position ?? t4.position;
      e2 !== p && (p = e2, h = p.animate.quickTo(["top", "left"], s));
    }
    if ("boolean" == typeof t4.enabled && ((n = t4.enabled) ? g() : _()), "number" == typeof t4.button && (i = t4.button), "boolean" == typeof t4.tween && (r = t4.tween), isObject(t4.tweenOptions) && (s = t4.tweenOptions, h.options(s)), void 0 !== t4.hasTargetClassList) {
      if (!isIterable(t4.hasTargetClassList)) throw new TypeError("'hasTargetClassList' is not iterable.");
      a = t4.hasTargetClassList;
    }
    if (void 0 !== t4.ignoreTargetClassList) {
      if (!isIterable(t4.ignoreTargetClassList)) throw new TypeError("'ignoreTargetClassList' is not iterable.");
      c = t4.ignoreTargetClassList;
    }
  }, destroy: () => _() };
}
class DraggableOptionsStore {
  tween;
  tweenOptions;
  #O;
  #x;
  #E = false;
  #M = { duration: 1, ease: "cubicOut" };
  #A = [];
  constructor({ tween: t3 = false, tweenOptions: e } = {}) {
    Object.defineProperty(this, "tween", { get: () => this.#E, set: (t4) => {
      if ("boolean" != typeof t4) throw new TypeError("'tween' is not a boolean.");
      this.#E = t4, this.#C();
    }, enumerable: true }), Object.defineProperty(this, "tweenOptions", { get: () => this.#M, set: (t4) => {
      if (!isObject(t4)) throw new TypeError("'tweenOptions' is not an object.");
      if (void 0 !== t4.duration) {
        if (!Number.isFinite(t4.duration)) throw new TypeError("'tweenOptions.duration' is not a finite number.");
        t4.duration < 0 ? this.#M.duration = 0 : this.#M.duration = t4.duration;
      }
      if (void 0 !== t4.ease) {
        if ("function" != typeof getEasingFunc(t4.ease)) throw new TypeError("'tweenOptions.ease' is not a function or Svelte easing function name.");
        this.#M.ease = t4.ease;
      }
      this.#C();
    }, enumerable: true }), void 0 !== t3 && (this.tween = t3), void 0 !== e && (this.tweenOptions = e), this.#O = this.#E, this.#x = Object.assign({}, this.#M);
  }
  get tweenDuration() {
    return this.#M.duration;
  }
  get tweenEase() {
    return this.#M.ease;
  }
  set tweenDuration(t3) {
    if (!Number.isFinite(t3)) throw new TypeError("'duration' is not a finite number.");
    t3 < 0 && (t3 = 0), this.#M.duration = t3, this.#C();
  }
  set tweenEase(t3) {
    if ("function" != typeof getEasingFunc(t3)) throw new TypeError("'ease' is not a function or Svelte easing function name.");
    this.#M.ease = t3, this.#C();
  }
  reset() {
    this.#E = this.#O, this.#M = Object.assign({}, this.#x), this.#C();
  }
  resetTween() {
    this.#E = this.#O, this.#C();
  }
  resetTweenOptions() {
    this.#M = Object.assign({}, this.#x), this.#C();
  }
  subscribe(t3) {
    return -1 === this.#A.findIndex((e) => e === t3) && (this.#A.push(t3), t3(this)), () => {
      const e = this.#A.findIndex((e2) => e2 === t3);
      -1 !== e && this.#A.splice(e, 1);
    };
  }
  #C() {
    const t3 = this.#A;
    if (t3.length > 0) for (let e = 0; e < t3.length; e++) t3[e](this);
  }
}
draggable.options = (t3) => new DraggableOptionsStore(t3);
class AnimationControl {
  #I;
  #P;
  #D;
  static #N = new AnimationControl(null);
  static get voidControl() {
    return this.#N;
  }
  constructor(t3, e = false) {
    this.#I = t3, this.#D = e, isObject(t3) && (t3.control = this);
  }
  get finished() {
    return CrossWindow.isPromise(this.#P) || (this.#P = this.#D ? new Promise((t3) => this.#I.resolve = t3) : Promise.resolve({ cancelled: false })), this.#P;
  }
  get isActive() {
    return this.#I?.active ?? false;
  }
  get isFinished() {
    return this.#I?.finished ?? true;
  }
  cancel() {
    const t3 = this.#I;
    null != t3 && (t3.cancelled = true);
  }
}
class AnimationManager {
  static cancelFn = (t3) => true !== t3?.quickTo;
  static cancelAllFn = () => true;
  static #j = Object.freeze({ immediateElementUpdate: true });
  static #L = [];
  static #F = (t3) => this.animate(t3);
  static #z = [];
  static #R = false;
  static #H;
  static #W;
  static get timeFrame() {
    return this.#H;
  }
  static get timeNow() {
    return this.#W;
  }
  static add(t3) {
    t3.cancelled ? this.#q(t3) : (AnimationManager.#z.push(t3), AnimationManager.#R || (AnimationManager.#R = true, globalThis.requestAnimationFrame(this.#F)));
  }
  static animate(t3) {
    if (AnimationManager.#R = false, AnimationManager.#W = globalThis.performance.now(), AnimationManager.#H = t3, 0 !== AnimationManager.#L.length || 0 !== AnimationManager.#z.length) {
      if (AnimationManager.#z.length) for (let t4 = AnimationManager.#z.length; --t4 >= 0; ) {
        const e = AnimationManager.#z[t4];
        (e.cancelled || void 0 !== e.el && !e.el.isConnected) && (AnimationManager.#z.splice(t4, 1), this.#q(e)), e.active && (e.transformOrigin && e.position.set({ transformOrigin: e.transformOrigin }), e.start = AnimationManager.#H, AnimationManager.#z.splice(t4, 1), AnimationManager.#L.push(e));
      }
      for (let e = AnimationManager.#L.length; --e >= 0; ) {
        const n = AnimationManager.#L[e];
        if (n.cancelled || void 0 !== n.el && !n.el.isConnected) {
          AnimationManager.#L.splice(e, 1), this.#q(n);
          continue;
        }
        if (n.current = t3 - n.start, n.current >= n.duration) {
          for (let t4 = n.keys.length; --t4 >= 0; ) {
            const e2 = n.keys[t4];
            n.newData[e2] = n.destination[e2];
          }
          n.position.set(n.newData, AnimationManager.#j), AnimationManager.#L.splice(e, 1), this.#q(n);
          continue;
        }
        const i = n.ease(n.current / n.duration);
        for (let t4 = n.keys.length; --t4 >= 0; ) {
          const e2 = n.keys[t4];
          n.newData[e2] = n.interpolate(n.initial[e2], n.destination[e2], i);
        }
        n.position.set(n.newData, AnimationManager.#j);
      }
      globalThis.requestAnimationFrame(this.#F);
    }
  }
  static cancel(t3, e = AnimationManager.cancelFn) {
    for (let n = AnimationManager.#L.length; --n >= 0; ) {
      const i = AnimationManager.#L[n];
      i.position === t3 && e(i) && (AnimationManager.#L.splice(n, 1), i.cancelled = true, this.#q(i));
    }
    for (let n = AnimationManager.#z.length; --n >= 0; ) {
      const i = AnimationManager.#z[n];
      i.position === t3 && e(i) && (AnimationManager.#z.splice(n, 1), i.cancelled = true, this.#q(i));
    }
  }
  static cancelAll() {
    for (let t3 = AnimationManager.#L.length; --t3 >= 0; ) {
      const e = AnimationManager.#L[t3];
      e.cancelled = true, this.#q(e);
    }
    for (let t3 = AnimationManager.#z.length; --t3 >= 0; ) {
      const e = AnimationManager.#z[t3];
      e.cancelled = true, this.#q(e);
    }
    AnimationManager.#L.length = 0, AnimationManager.#z.length = 0;
  }
  static #q(t3) {
    t3.active = false, t3.finished = true, t3.transformOriginInitial && t3.position.set({ transformOrigin: t3.transformOriginInitial }), "function" == typeof t3.cleanup && t3.cleanup(t3), "function" == typeof t3.resolve && t3.resolve({ cancelled: t3.cancelled }), t3.quickTo || (t3.cleanup = void 0, t3.control = void 0, t3.destination = void 0, t3.el = void 0, t3.ease = void 0, t3.initial = void 0, t3.interpolate = void 0, t3.keys = void 0, t3.newData = void 0, t3.position = void 0, t3.resolve = void 0);
  }
  static getScheduled(t3) {
    const e = [];
    for (let n = AnimationManager.#L.length; --n >= 0; ) {
      const i = AnimationManager.#L[n];
      i.position === t3 && i.control && e.push(i.control);
    }
    for (let n = AnimationManager.#z.length; --n >= 0; ) {
      const i = AnimationManager.#z[n];
      i.position === t3 && i.control && e.push(i.control);
    }
    return e;
  }
  static isScheduled(t3, { active: e = true, pending: n = true } = {}) {
    if (e) {
      for (let e2 = AnimationManager.#L.length; --e2 >= 0; ) if (AnimationManager.#L[e2].position === t3) return true;
    }
    if (n) {
      for (let e2 = AnimationManager.#z.length; --e2 >= 0; ) if (AnimationManager.#z[e2].position === t3) return true;
    }
    return false;
  }
}
class TJSPositionData {
  height;
  left;
  maxHeight;
  maxWidth;
  minHeight;
  minWidth;
  rotateX;
  rotateY;
  rotateZ;
  scale;
  top;
  transformOrigin;
  translateX;
  translateY;
  translateZ;
  width;
  zIndex;
  constructor({ height: t3 = null, left: e = null, maxHeight: n = null, maxWidth: i = null, minHeight: o = null, minWidth: r = null, rotateX: s = null, rotateY: a = null, rotateZ: c = null, scale: l = null, translateX: p = null, translateY: u = null, translateZ: d = null, top: m = null, transformOrigin: h = null, width: f = null, zIndex: g = null } = {}) {
    this.height = t3, this.left = e, this.maxHeight = n, this.maxWidth = i, this.minHeight = o, this.minWidth = r, this.rotateX = s, this.rotateY = a, this.rotateZ = c, this.scale = l, this.top = m, this.transformOrigin = h, this.translateX = p, this.translateY = u, this.translateZ = d, this.width = f, this.zIndex = g;
  }
}
class TJSPositionDataUtil {
  static #J = Object.freeze(/* @__PURE__ */ new Set(["left", "top", "maxWidth", "maxHeight", "minWidth", "minHeight", "width", "height", "rotateX", "rotateY", "rotateZ", "scale", "translateX", "translateY", "translateZ", "zIndex", "rotation"]));
  static #G = Object.freeze(/* @__PURE__ */ new Map([["rotation", "rotateZ"]]));
  static #U = Object.freeze({ height: 0, left: 0, maxHeight: null, maxWidth: null, minHeight: null, minWidth: null, top: 0, transformOrigin: null, width: 0, zIndex: null, rotateX: 0, rotateY: 0, rotateZ: 0, scale: 1, translateX: 0, translateY: 0, translateZ: 0 });
  static copyData(t3, e = new TJSPositionData()) {
    return e.height = t3.height ?? null, e.left = t3.left ?? null, e.maxHeight = t3.maxHeight ?? null, e.maxWidth = t3.maxWidth ?? null, e.minHeight = t3.minHeight ?? null, e.minWidth = t3.minWidth ?? null, e.rotateX = t3.rotateX ?? null, e.rotateY = t3.rotateY ?? null, e.rotateZ = t3.rotateZ ?? null, e.scale = t3.scale ?? null, e.top = t3.top ?? null, e.transformOrigin = t3.transformOrigin ?? null, e.translateX = t3.translateX ?? null, e.translateY = t3.translateY ?? null, e.translateZ = t3.translateZ ?? null, e.width = t3.width ?? null, e.zIndex = t3.zIndex ?? null, e;
  }
  static getAnimationKey(t3) {
    return this.#G.get(t3) ?? t3;
  }
  static getDataOrDefault(t3, e) {
    return t3[e = this.#G.get(e) ?? e] ?? this.#U[e];
  }
  static isAnimationKey(t3) {
    return this.#J.has(t3);
  }
  static setNumericDefaults(t3) {
    null === t3.rotateX && (t3.rotateX = 0), null === t3.rotateY && (t3.rotateY = 0), null === t3.rotateZ && (t3.rotateZ = 0), null === t3.translateX && (t3.translateX = 0), null === t3.translateY && (t3.translateY = 0), null === t3.translateZ && (t3.translateZ = 0), null === t3.scale && (t3.scale = 1);
  }
}
class ConvertStringData {
  static #B = { numPx: Object.freeze(/* @__PURE__ */ new Set(["left", "top", "maxWidth", "maxHeight", "minWidth", "minHeight", "width", "height", "translateX", "translateY", "translateZ"])), percentParent: Object.freeze(/* @__PURE__ */ new Set(["left", "top", "maxWidth", "maxHeight", "minWidth", "minHeight", "width", "height"])), rotationRadTurn: Object.freeze(/* @__PURE__ */ new Set(["rotateX", "rotateY", "rotateZ", "rotation"])) };
  static #V = /^(?<operation>[-+*]=)?(?<value>-?\d*\.?\d+)(?<unit>%|%~|px|rad|turn)?$/;
  static #Y = Object.seal({ operation: void 0, value: 0, unit: void 0 });
  static process(t3, e, n) {
    let i = Number.NaN, o = Number.NaN;
    for (const r in t3) if (TJSPositionDataUtil.isAnimationKey(r)) {
      const s = t3[r];
      if ("string" != typeof s) continue;
      if ("auto" === s || "inherit" === s) continue;
      const a = r, c = this.#V.exec(s);
      let l = false;
      if (c && c.groups) {
        const p = this.#Y;
        p.operation = c.groups.operation, p.value = parseFloat(c.groups.value), p.unit = c.groups.unit;
        const u = TJSPositionDataUtil.getDataOrDefault(e, r);
        switch (p.unit) {
          case "%":
            if (this.#B.percentParent.has(r) && (Number.isNaN(i) || Number.isNaN(o))) {
              if (!n?.parentElement?.isConnected) {
                i = 0, o = 0, console.warn(`TJSPosition - ConvertStringData warning: could not determine parent constraints for key '${r}' with value '${s}'.`), t3[r] = void 0;
                continue;
              }
              i = n.parentElement.clientHeight, o = n.parentElement.clientWidth;
            }
            l = this.#X(a, u, t3, p, i, o);
            break;
          case "%~":
            l = this.#Z(a, u, t3, p);
            break;
          case "px":
            l = !!this.#B.numPx.has(r) && this.#K(a, u, t3, p);
            break;
          case "rad":
          case "turn":
            l = !!this.#B.rotationRadTurn.has(r) && this.#Q(a, u, t3, p);
            break;
          default:
            l = this.#K(a, u, t3, p);
        }
      }
      c && l || (console.warn(`TJSPosition - ConvertStringData warning: malformed key '${r}' with value '${s}'.`), t3[r] = void 0);
    }
    return t3;
  }
  static #K(t3, e, n, i) {
    if (!i.operation) return n[t3] = i.value, true;
    switch (i.operation) {
      case "-=":
        n[t3] = e - i.value;
        break;
      case "+=":
        n[t3] = e + i.value;
        break;
      case "*=":
        n[t3] = e * i.value;
        break;
      default:
        return false;
    }
    return true;
  }
  static #X(t3, e, n, i, o, r) {
    switch (t3) {
      case "left":
      case "maxWidth":
      case "minWidth":
      case "width":
      case "translateX":
        i.value = r * (i.value / 100);
        break;
      case "top":
      case "maxHeight":
      case "minHeight":
      case "height":
      case "translateY":
        i.value = o * (i.value / 100);
        break;
      case "rotateX":
      case "rotateY":
      case "rotateZ":
      case "rotation":
        i.value = i.value / 100 * 360;
        break;
      default:
        return false;
    }
    return this.#K(t3, e, n, i);
  }
  static #Z(t3, e, n, i) {
    if (i.value = i.value / 100, !i.operation) return n[t3] = e * i.value, true;
    switch (i.operation) {
      case "-=":
        n[t3] = e - e * i.value;
        break;
      case "+=":
        n[t3] = e + e * i.value;
        break;
      case "*=":
        n[t3] = e * (e * i.value);
        break;
      default:
        return false;
    }
    return true;
  }
  static #Q(t3, e, n, i) {
    switch (i.unit) {
      case "rad":
        i.value = radToDeg(i.value);
        break;
      case "turn":
        i.value = 360 * i.value;
    }
    return this.#K(t3, e, n, i);
  }
}
class TJSTransformData {
  constructor() {
    Object.seal(this);
  }
  #tt = new DOMRect();
  #et = [new Vec3(), new Vec3(), new Vec3(), new Vec3()];
  #nt = new Mat4();
  #it = [new Mat4(), new Mat4()];
  get boundingRect() {
    return this.#tt;
  }
  get corners() {
    return this.#et;
  }
  get css() {
    return `matrix3d(${this.mat4.join(",")})`;
  }
  get mat4() {
    return this.#nt;
  }
  get originTranslations() {
    return this.#it;
  }
}
class NumberGuard {
  constructor() {
  }
  static isFinite(t3) {
    return "number" == typeof t3 && Number.isFinite(t3);
  }
  static isFiniteOrNull(t3) {
    return null === t3 || "number" == typeof t3 && Number.isFinite(t3);
  }
}
class TJSPositionStyleCache {
  el;
  computed;
  marginLeft;
  marginTop;
  maxHeight;
  maxWidth;
  minHeight;
  minWidth;
  hasWillChange;
  stores;
  resizeObserved;
  constructor() {
    this.el = void 0, this.computed = void 0, this.marginLeft = void 0, this.marginTop = void 0, this.maxHeight = void 0, this.maxWidth = void 0, this.minHeight = void 0, this.minWidth = void 0, this.hasWillChange = false, this.resizeObserved = Object.seal({ contentHeight: void 0, contentWidth: void 0, offsetHeight: void 0, offsetWidth: void 0 });
    const t3 = writable(this.resizeObserved);
    this.stores = { element: writable(this.el), resizeContentHeight: propertyStore(t3, "contentHeight"), resizeContentWidth: propertyStore(t3, "contentWidth"), resizeObserved: t3, resizeObservable: writable(false), resizeOffsetHeight: propertyStore(t3, "offsetHeight"), resizeOffsetWidth: propertyStore(t3, "offsetWidth") };
  }
  get offsetHeight() {
    if (void 0 !== this.el && A11yHelper.isFocusTarget(this.el)) return void 0 !== this.resizeObserved.offsetHeight ? this.resizeObserved.offsetHeight : this.el.offsetHeight;
    throw new Error("TJSPositionStyleCache - get offsetHeight error: no element assigned.");
  }
  get offsetWidth() {
    if (void 0 !== this.el && A11yHelper.isFocusTarget(this.el)) return void 0 !== this.resizeObserved.offsetWidth ? this.resizeObserved.offsetWidth : this.el.offsetWidth;
    throw new Error("TJSPositionStyleCache - get offsetWidth error: no element assigned.");
  }
  hasData(t3) {
    return this.el === t3;
  }
  reset() {
    void 0 !== this.el && A11yHelper.isFocusTarget(this.el) && this.el.isConnected && !this.hasWillChange && (this.el.style.willChange = ""), this.el = void 0, this.computed = void 0, this.marginLeft = void 0, this.marginTop = void 0, this.maxHeight = void 0, this.maxWidth = void 0, this.minHeight = void 0, this.minWidth = void 0, this.hasWillChange = false, this.resizeObserved.contentHeight = void 0, this.resizeObserved.contentWidth = void 0, this.resizeObserved.offsetHeight = void 0, this.resizeObserved.offsetWidth = void 0, this.stores.element.set(void 0);
  }
  update(t3) {
    this.el = t3, this.computed = globalThis.getComputedStyle(t3), this.marginLeft = StyleParse.pixels(t3.style.marginLeft) ?? StyleParse.pixels(this.computed.marginLeft), this.marginTop = StyleParse.pixels(t3.style.marginTop) ?? StyleParse.pixels(this.computed.marginTop), this.maxHeight = StyleParse.pixels(t3.style.maxHeight) ?? StyleParse.pixels(this.computed.maxHeight), this.maxWidth = StyleParse.pixels(t3.style.maxWidth) ?? StyleParse.pixels(this.computed.maxWidth), this.minHeight = StyleParse.pixels(t3.style.minHeight) ?? StyleParse.pixels(this.computed.minHeight), this.minWidth = StyleParse.pixels(t3.style.minWidth) ?? StyleParse.pixels(this.computed.minWidth);
    const e = "" !== t3.style.willChange ? t3.style.willChange : this.computed.willChange ?? "";
    this.hasWillChange = "" !== e && "auto" !== e, this.stores.element.set(t3);
  }
}
class TJSTransforms {
  #ot = {};
  #rt = [];
  static #st = Object.freeze(["rotateX", "rotateY", "rotateZ", "scale", "translateX", "translateY", "translateZ"]);
  static #at(t3) {
    return this.#st.includes(t3);
  }
  static #ct = Object.freeze({ rotateX: 1, rotateY: 2, rotateZ: 4, scale: 8, translateX: 16, translateY: 32, translateZ: 64 });
  static #lt = "top left";
  static #pt = Object.freeze(["top left", "top center", "top right", "center left", "center", "center right", "bottom left", "bottom center", "bottom right"]);
  static #ut = Object.freeze(new Set(this.#pt));
  static #dt = new Mat4();
  static #mt = new Mat4();
  static #ht = new Vec3();
  static #ft = [1, 1, 1];
  static #gt = [0, 0, 0];
  static get transformOrigins() {
    return this.#pt;
  }
  static isTransformOrigin(t3) {
    return this.#ut.has(t3);
  }
  get isActive() {
    return this.#rt.length > 0;
  }
  get rotateX() {
    return this.#ot.rotateX;
  }
  get rotateY() {
    return this.#ot.rotateY;
  }
  get rotateZ() {
    return this.#ot.rotateZ;
  }
  get scale() {
    return this.#ot.scale;
  }
  get translateX() {
    return this.#ot.translateX;
  }
  get translateY() {
    return this.#ot.translateY;
  }
  get translateZ() {
    return this.#ot.translateZ;
  }
  set rotateX(t3) {
    if (Number.isFinite(t3)) void 0 === this.#ot.rotateX && this.#rt.push("rotateX"), this.#ot.rotateX = t3;
    else {
      if (void 0 !== this.#ot.rotateX) {
        const t4 = this.#rt.findIndex((t5) => "rotateX" === t5);
        t4 >= 0 && this.#rt.splice(t4, 1);
      }
      delete this.#ot.rotateX;
    }
  }
  set rotateY(t3) {
    if (Number.isFinite(t3)) void 0 === this.#ot.rotateY && this.#rt.push("rotateY"), this.#ot.rotateY = t3;
    else {
      if (void 0 !== this.#ot.rotateY) {
        const t4 = this.#rt.findIndex((t5) => "rotateY" === t5);
        t4 >= 0 && this.#rt.splice(t4, 1);
      }
      delete this.#ot.rotateY;
    }
  }
  set rotateZ(t3) {
    if (Number.isFinite(t3)) void 0 === this.#ot.rotateZ && this.#rt.push("rotateZ"), this.#ot.rotateZ = t3;
    else {
      if (void 0 !== this.#ot.rotateZ) {
        const t4 = this.#rt.findIndex((t5) => "rotateZ" === t5);
        t4 >= 0 && this.#rt.splice(t4, 1);
      }
      delete this.#ot.rotateZ;
    }
  }
  set scale(t3) {
    if (Number.isFinite(t3)) void 0 === this.#ot.scale && this.#rt.push("scale"), this.#ot.scale = t3;
    else {
      if (void 0 !== this.#ot.scale) {
        const t4 = this.#rt.findIndex((t5) => "scale" === t5);
        t4 >= 0 && this.#rt.splice(t4, 1);
      }
      delete this.#ot.scale;
    }
  }
  set translateX(t3) {
    if (Number.isFinite(t3)) void 0 === this.#ot.translateX && this.#rt.push("translateX"), this.#ot.translateX = t3;
    else {
      if (void 0 !== this.#ot.translateX) {
        const t4 = this.#rt.findIndex((t5) => "translateX" === t5);
        t4 >= 0 && this.#rt.splice(t4, 1);
      }
      delete this.#ot.translateX;
    }
  }
  set translateY(t3) {
    if (Number.isFinite(t3)) void 0 === this.#ot.translateY && this.#rt.push("translateY"), this.#ot.translateY = t3;
    else {
      if (void 0 !== this.#ot.translateY) {
        const t4 = this.#rt.findIndex((t5) => "translateY" === t5);
        t4 >= 0 && this.#rt.splice(t4, 1);
      }
      delete this.#ot.translateY;
    }
  }
  set translateZ(t3) {
    if (Number.isFinite(t3)) void 0 === this.#ot.translateZ && this.#rt.push("translateZ"), this.#ot.translateZ = t3;
    else {
      if (void 0 !== this.#ot.translateZ) {
        const t4 = this.#rt.findIndex((t5) => "translateZ" === t5);
        t4 >= 0 && this.#rt.splice(t4, 1);
      }
      delete this.#ot.translateZ;
    }
  }
  getCSS(t3 = this.#ot) {
    return `matrix3d(${this.getMat4(t3, TJSTransforms.#dt).join(",")})`;
  }
  getCSSOrtho(t3 = this.#ot) {
    return `matrix3d(${this.getMat4Ortho(t3, TJSTransforms.#dt).join(",")})`;
  }
  getData(t3, e = new TJSTransformData(), n) {
    const i = n?.width ?? 0, o = n?.height ?? 0, r = n?.offsetTop ?? n?.marginTop ?? 0, s = n?.offsetLeft ?? n?.marginLeft ?? 0;
    t3.top += r, t3.left += s;
    const a = NumberGuard.isFinite(t3.width) ? t3.width : i, c = NumberGuard.isFinite(t3.height) ? t3.height : o, l = e.corners;
    if (this.hasTransform(t3)) {
      l[0][0] = l[0][1] = l[0][2] = 0, l[1][0] = a, l[1][1] = l[1][2] = 0, l[2][0] = a, l[2][1] = c, l[2][2] = 0, l[3][0] = 0, l[3][1] = c, l[3][2] = 0;
      const n2 = this.getMat4(t3, e.mat4), i2 = TJSTransforms.#_t(t3.transformOrigin, a, c, e.originTranslations);
      TJSTransforms.#lt === t3.transformOrigin ? (Vec3.transformMat4(l[0], l[0], n2), Vec3.transformMat4(l[1], l[1], n2), Vec3.transformMat4(l[2], l[2], n2), Vec3.transformMat4(l[3], l[3], n2)) : (Vec3.transformMat4(l[0], l[0], i2[0]), Vec3.transformMat4(l[0], l[0], n2), Vec3.transformMat4(l[0], l[0], i2[1]), Vec3.transformMat4(l[1], l[1], i2[0]), Vec3.transformMat4(l[1], l[1], n2), Vec3.transformMat4(l[1], l[1], i2[1]), Vec3.transformMat4(l[2], l[2], i2[0]), Vec3.transformMat4(l[2], l[2], n2), Vec3.transformMat4(l[2], l[2], i2[1]), Vec3.transformMat4(l[3], l[3], i2[0]), Vec3.transformMat4(l[3], l[3], n2), Vec3.transformMat4(l[3], l[3], i2[1])), l[0][0] = t3.left + l[0][0], l[0][1] = t3.top + l[0][1], l[1][0] = t3.left + l[1][0], l[1][1] = t3.top + l[1][1], l[2][0] = t3.left + l[2][0], l[2][1] = t3.top + l[2][1], l[3][0] = t3.left + l[3][0], l[3][1] = t3.top + l[3][1];
    } else l[0][0] = t3.left, l[0][1] = t3.top, l[1][0] = t3.left + a, l[1][1] = t3.top, l[2][0] = t3.left + a, l[2][1] = t3.top + c, l[3][0] = t3.left, l[3][1] = t3.top + c, Mat4.identity(e.mat4);
    let p = Number.MIN_SAFE_INTEGER, u = Number.MIN_SAFE_INTEGER, d = Number.MAX_SAFE_INTEGER, m = Number.MAX_SAFE_INTEGER;
    for (let t4 = 4; --t4 >= 0; ) l[t4][0] > p && (p = l[t4][0]), l[t4][0] < d && (d = l[t4][0]), l[t4][1] > u && (u = l[t4][1]), l[t4][1] < m && (m = l[t4][1]);
    const h = e.boundingRect;
    return h.x = d, h.y = m, h.width = p - d, h.height = u - m, t3.top -= r, t3.left -= s, e;
  }
  getMat4(t3 = this.#ot, e = new Mat4()) {
    const n = Mat4.identity(e);
    let i = 0;
    const o = this.#rt;
    for (let e2 = 0; e2 < o.length; e2++) {
      const r = o[e2];
      switch (r) {
        case "rotateX":
          i |= TJSTransforms.#ct.rotateX, Mat4.multiply(n, n, Mat4.fromXRotation(TJSTransforms.#mt, degToRad(t3[r] ?? 0)));
          break;
        case "rotateY":
          i |= TJSTransforms.#ct.rotateY, Mat4.multiply(n, n, Mat4.fromYRotation(TJSTransforms.#mt, degToRad(t3[r] ?? 0)));
          break;
        case "rotateZ":
          i |= TJSTransforms.#ct.rotateZ, Mat4.multiply(n, n, Mat4.fromZRotation(TJSTransforms.#mt, degToRad(t3[r] ?? 0)));
          break;
        case "scale":
          i |= TJSTransforms.#ct.scale, TJSTransforms.#ft[0] = TJSTransforms.#ft[1] = t3[r] ?? 0, Mat4.multiply(n, n, Mat4.fromScaling(TJSTransforms.#mt, TJSTransforms.#ft));
          break;
        case "translateX":
          i |= TJSTransforms.#ct.translateX, TJSTransforms.#gt[0] = t3.translateX ?? 0, TJSTransforms.#gt[1] = 0, TJSTransforms.#gt[2] = 0, Mat4.multiply(n, n, Mat4.fromTranslation(TJSTransforms.#mt, TJSTransforms.#gt));
          break;
        case "translateY":
          i |= TJSTransforms.#ct.translateY, TJSTransforms.#gt[0] = 0, TJSTransforms.#gt[1] = t3.translateY ?? 0, TJSTransforms.#gt[2] = 0, Mat4.multiply(n, n, Mat4.fromTranslation(TJSTransforms.#mt, TJSTransforms.#gt));
          break;
        case "translateZ":
          i |= TJSTransforms.#ct.translateZ, TJSTransforms.#gt[0] = 0, TJSTransforms.#gt[1] = 0, TJSTransforms.#gt[2] = t3.translateZ ?? 0, Mat4.multiply(n, n, Mat4.fromTranslation(TJSTransforms.#mt, TJSTransforms.#gt));
      }
    }
    if (t3 !== this.#ot) for (let e2 = 0; e2 < TJSTransforms.#st.length; e2++) {
      const o2 = TJSTransforms.#st[e2];
      if (null === t3[o2] || (i & TJSTransforms.#ct[o2]) > 0) continue;
      const r = t3[o2];
      switch (o2) {
        case "rotateX":
          Mat4.multiply(n, n, Mat4.fromXRotation(TJSTransforms.#mt, degToRad(r)));
          break;
        case "rotateY":
          Mat4.multiply(n, n, Mat4.fromYRotation(TJSTransforms.#mt, degToRad(r)));
          break;
        case "rotateZ":
          Mat4.multiply(n, n, Mat4.fromZRotation(TJSTransforms.#mt, degToRad(r)));
          break;
        case "scale":
          TJSTransforms.#ft[0] = TJSTransforms.#ft[1] = r, Mat4.multiply(n, n, Mat4.fromScaling(TJSTransforms.#mt, TJSTransforms.#ft));
          break;
        case "translateX":
          TJSTransforms.#gt[0] = r, TJSTransforms.#gt[1] = 0, TJSTransforms.#gt[2] = 0, Mat4.multiply(n, n, Mat4.fromTranslation(TJSTransforms.#mt, TJSTransforms.#gt));
          break;
        case "translateY":
          TJSTransforms.#gt[0] = 0, TJSTransforms.#gt[1] = r, TJSTransforms.#gt[2] = 0, Mat4.multiply(n, n, Mat4.fromTranslation(TJSTransforms.#mt, TJSTransforms.#gt));
          break;
        case "translateZ":
          TJSTransforms.#gt[0] = 0, TJSTransforms.#gt[1] = 0, TJSTransforms.#gt[2] = r, Mat4.multiply(n, n, Mat4.fromTranslation(TJSTransforms.#mt, TJSTransforms.#gt));
      }
    }
    return n;
  }
  getMat4Ortho(t3 = this.#ot, e = new Mat4()) {
    const n = Mat4.identity(e);
    if (TJSTransforms.#gt[0] = (t3.left ?? 0) + (t3.translateX ?? 0), TJSTransforms.#gt[1] = (t3.top ?? 0) + (t3.translateY ?? 0), TJSTransforms.#gt[2] = t3.translateZ ?? 0, Mat4.multiply(n, n, Mat4.fromTranslation(TJSTransforms.#mt, TJSTransforms.#gt)), null !== t3.scale && void 0 !== t3.scale && (TJSTransforms.#ft[0] = TJSTransforms.#ft[1] = t3.scale, Mat4.multiply(n, n, Mat4.fromScaling(TJSTransforms.#mt, TJSTransforms.#ft))), null === t3.rotateX && null === t3.rotateY && null === t3.rotateZ) return n;
    let i = 0;
    const o = this.#rt;
    for (let e2 = 0; e2 < o.length; e2++) {
      const r = o[e2];
      switch (r) {
        case "rotateX":
          i |= TJSTransforms.#ct.rotateX, Mat4.multiply(n, n, Mat4.fromXRotation(TJSTransforms.#mt, degToRad(t3[r] ?? 0)));
          break;
        case "rotateY":
          i |= TJSTransforms.#ct.rotateY, Mat4.multiply(n, n, Mat4.fromYRotation(TJSTransforms.#mt, degToRad(t3[r] ?? 0)));
          break;
        case "rotateZ":
          i |= TJSTransforms.#ct.rotateZ, Mat4.multiply(n, n, Mat4.fromZRotation(TJSTransforms.#mt, degToRad(t3[r] ?? 0)));
      }
    }
    if (t3 !== this.#ot) for (let e2 = 0; e2 < TJSTransforms.#st.length; e2++) {
      const o2 = TJSTransforms.#st[e2];
      if (!(null === t3[o2] || (i & TJSTransforms.#ct[o2]) > 0)) switch (o2) {
        case "rotateX":
          Mat4.multiply(n, n, Mat4.fromXRotation(TJSTransforms.#mt, degToRad(t3[o2] ?? 0)));
          break;
        case "rotateY":
          Mat4.multiply(n, n, Mat4.fromYRotation(TJSTransforms.#mt, degToRad(t3[o2] ?? 0)));
          break;
        case "rotateZ":
          Mat4.multiply(n, n, Mat4.fromZRotation(TJSTransforms.#mt, degToRad(t3[o2] ?? 0)));
      }
    }
    return n;
  }
  hasTransform(t3) {
    for (const e of TJSTransforms.#st) if (Number.isFinite(t3[e])) return true;
    return false;
  }
  reset(t3) {
    for (const e in t3) if (TJSTransforms.#at(e)) {
      const n = t3[e];
      if (NumberGuard.isFinite(n)) this.#ot[e] = n;
      else {
        const t4 = this.#rt.findIndex((t5) => t5 === e);
        t4 >= 0 && this.#rt.splice(t4, 1), delete this.#ot[e];
      }
    }
  }
  static #_t(t3, e, n, i) {
    const o = TJSTransforms.#ht;
    switch (t3) {
      case "top left":
        o[0] = o[1] = 0, Mat4.fromTranslation(i[0], o), Mat4.fromTranslation(i[1], o);
        break;
      case "top center":
        o[0] = 0.5 * -e, o[1] = 0, Mat4.fromTranslation(i[0], o), o[0] = 0.5 * e, Mat4.fromTranslation(i[1], o);
        break;
      case "top right":
        o[0] = -e, o[1] = 0, Mat4.fromTranslation(i[0], o), o[0] = e, Mat4.fromTranslation(i[1], o);
        break;
      case "center left":
        o[0] = 0, o[1] = 0.5 * -n, Mat4.fromTranslation(i[0], o), o[1] = 0.5 * n, Mat4.fromTranslation(i[1], o);
        break;
      case null:
      case "center":
        o[0] = 0.5 * -e, o[1] = 0.5 * -n, Mat4.fromTranslation(i[0], o), o[0] = 0.5 * e, o[1] = 0.5 * n, Mat4.fromTranslation(i[1], o);
        break;
      case "center right":
        o[0] = -e, o[1] = 0.5 * -n, Mat4.fromTranslation(i[0], o), o[0] = e, o[1] = 0.5 * n, Mat4.fromTranslation(i[1], o);
        break;
      case "bottom left":
        o[0] = 0, o[1] = -n, Mat4.fromTranslation(i[0], o), o[1] = n, Mat4.fromTranslation(i[1], o);
        break;
      case "bottom center":
        o[0] = 0.5 * -e, o[1] = -n, Mat4.fromTranslation(i[0], o), o[0] = 0.5 * e, o[1] = n, Mat4.fromTranslation(i[1], o);
        break;
      case "bottom right":
        o[0] = -e, o[1] = -n, Mat4.fromTranslation(i[0], o), o[0] = e, o[1] = n, Mat4.fromTranslation(i[1], o);
        break;
      default:
        Mat4.identity(i[0]), Mat4.identity(i[1]);
    }
    return i;
  }
}
class AnimationScheduler {
  static #ot = {};
  static #bt = Object.freeze({ default: false });
  static #yt(t3, e, n, i, o, r, s, a = lerp, c, l, p) {
    TJSPositionDataUtil.setNumericDefaults(e), TJSPositionDataUtil.setNumericDefaults(n);
    for (const t4 in e) Number.isFinite(e[t4]) || delete e[t4];
    const u = Object.keys(e), d = Object.assign({}, e);
    if (0 === u.length) return null;
    const m = { active: true, cleanup: p, cancelled: false, control: void 0, current: 0, destination: n, duration: 1e3 * i, ease: s, el: o, finished: false, initial: e, interpolate: a, keys: u, newData: d, position: t3, resolve: void 0, start: void 0, transformOrigin: c, transformOriginInitial: l, quickTo: false };
    return r > 0 && (m.active = false, setTimeout(() => m.active = true, 1e3 * r)), AnimationManager.add(m), new AnimationControl(m, true);
  }
  static from(t3, e, n = {}, i) {
    if (!isObject(e)) throw new TypeError("AnimationAPI.from error: 'fromData' is not an object.");
    const o = t3.parent;
    if (void 0 !== o && "boolean" == typeof o?.options?.positionable && !o?.options?.positionable) return null;
    let { delay: r = 0, duration: s = 1, ease: a = "cubicOut", strategy: c, transformOrigin: l } = n;
    if (void 0 !== c && null === this.#vt(t3, c)) return null;
    const p = A11yHelper.isFocusTarget(o) ? o : o?.elementTarget, u = A11yHelper.isFocusTarget(p) && p.isConnected ? p : void 0;
    if (!Number.isFinite(r) || r < 0) throw new TypeError("AnimationScheduler.from error: 'delay' is not a positive number.");
    if (!Number.isFinite(s) || s < 0) throw new TypeError("AnimationScheduler.from error: 'duration' is not a positive number.");
    if (a = getEasingFunc(a, this.#bt), "function" != typeof a) throw new TypeError("AnimationScheduler.from error: 'ease' is not a function or valid Svelte easing function name.");
    const d = {}, m = {};
    t3.get(this.#ot), l = TJSTransforms.isTransformOrigin(l) ? l : void 0;
    const h = void 0 !== l ? this.#ot.transformOrigin : void 0;
    for (const t4 in e) {
      const n2 = TJSPositionDataUtil.getAnimationKey(t4);
      void 0 !== this.#ot[n2] && e[t4] !== this.#ot[n2] && (d[t4] = e[t4], m[t4] = this.#ot[n2]);
    }
    return ConvertStringData.process(d, this.#ot, u), this.#yt(t3, d, m, s, u, r, a, lerp, l, h, i);
  }
  static fromTo(t3, e, n, i = {}, o) {
    if (!isObject(e)) throw new TypeError("AnimationScheduler.fromTo error: 'fromData' is not an object.");
    if (!isObject(n)) throw new TypeError("AnimationScheduler.fromTo error: 'toData' is not an object.");
    const r = t3.parent;
    if (void 0 !== r && "boolean" == typeof r?.options?.positionable && !r?.options?.positionable) return null;
    let { delay: s = 0, duration: a = 1, ease: c = "cubicOut", strategy: l, transformOrigin: p } = i;
    if (void 0 !== l && null === this.#vt(t3, l)) return null;
    const u = A11yHelper.isFocusTarget(r) ? r : r?.elementTarget, d = A11yHelper.isFocusTarget(u) && u.isConnected ? u : void 0;
    if (!Number.isFinite(s) || s < 0) throw new TypeError("AnimationScheduler.fromTo error: 'delay' is not a positive number.");
    if (!Number.isFinite(a) || a < 0) throw new TypeError("AnimationScheduler.fromTo error: 'duration' is not a positive number.");
    if (c = getEasingFunc(c, this.#bt), "function" != typeof c) throw new TypeError("AnimationScheduler.fromTo error: 'ease' is not a function or valid Svelte easing function name.");
    const m = {}, h = {};
    t3.get(this.#ot), p = TJSTransforms.isTransformOrigin(p) ? p : void 0;
    const f = void 0 !== p ? this.#ot.transformOrigin : void 0;
    for (const t4 in e) {
      if (void 0 === n[t4]) {
        console.warn(`AnimationScheduler.fromTo warning: skipping key ('${t4}') from 'fromData' as it is missing in 'toData'.`);
        continue;
      }
      const i2 = TJSPositionDataUtil.getAnimationKey(t4);
      void 0 !== this.#ot[i2] && (m[t4] = e[t4], h[t4] = n[t4]);
    }
    return ConvertStringData.process(m, this.#ot, d), ConvertStringData.process(h, this.#ot, d), this.#yt(t3, m, h, a, d, s, c, lerp, p, f, o);
  }
  static to(t3, e, n, i) {
    if (!isObject(e)) throw new TypeError("AnimationScheduler.to error: 'toData' is not an object.");
    const o = t3.parent;
    if (void 0 !== o && "boolean" == typeof o?.options?.positionable && !o?.options?.positionable) return null;
    let { delay: r = 0, duration: s = 1, ease: a = "cubicOut", strategy: c, transformOrigin: l } = n;
    if (void 0 !== c && null === this.#vt(t3, c)) return null;
    const p = A11yHelper.isFocusTarget(o) ? o : o?.elementTarget, u = A11yHelper.isFocusTarget(p) && p.isConnected ? p : void 0;
    if (!Number.isFinite(r) || r < 0) throw new TypeError("AnimationScheduler.to error: 'delay' is not a positive number.");
    if (!Number.isFinite(s) || s < 0) throw new TypeError("AnimationScheduler.to error: 'duration' is not a positive number.");
    if (a = getEasingFunc(a, this.#bt), "function" != typeof a) throw new TypeError("AnimationScheduler.to error: 'ease' is not a function or valid Svelte easing function name.");
    const d = {}, m = {};
    t3.get(this.#ot), l = TJSTransforms.isTransformOrigin(l) ? l : void 0;
    const h = void 0 !== l ? this.#ot.transformOrigin : void 0;
    for (const t4 in e) {
      const n2 = TJSPositionDataUtil.getAnimationKey(t4);
      void 0 !== this.#ot[n2] && e[t4] !== this.#ot[n2] && (m[t4] = e[t4], d[t4] = this.#ot[n2]);
    }
    return ConvertStringData.process(m, this.#ot, u), this.#yt(t3, d, m, s, u, r, a, lerp, l, h, i);
  }
  static #vt(t3, e) {
    switch (e) {
      case "cancel":
        AnimationManager.isScheduled(t3) && AnimationManager.cancel(t3);
        break;
      case "cancelAll":
        AnimationManager.isScheduled(t3) && AnimationManager.cancel(t3, AnimationManager.cancelAllFn);
        break;
      case "exclusive":
        if (AnimationManager.isScheduled(t3)) return null;
        break;
      default:
        return console.warn("AnimationScheduler error: 'strategy' is not 'cancel', 'cancelAll', or 'exclusive'."), null;
    }
  }
}
class AnimationAPIImpl {
  static #bt = Object.freeze({ default: false });
  #ot;
  #$t;
  constructor(t3, e) {
    this.#$t = t3, this.#ot = e, Object.seal(this);
  }
  get isScheduled() {
    return AnimationManager.isScheduled(this.#$t);
  }
  cancel() {
    AnimationManager.cancel(this.#$t, AnimationManager.cancelAllFn);
  }
  getScheduled() {
    return AnimationManager.getScheduled(this.#$t);
  }
  from(t3, e) {
    const n = AnimationScheduler.from(this.#$t, t3, e);
    return n || AnimationControl.voidControl;
  }
  fromTo(t3, e, n) {
    const i = AnimationScheduler.fromTo(this.#$t, t3, e, n);
    return i || AnimationControl.voidControl;
  }
  to(t3, e) {
    const n = AnimationScheduler.to(this.#$t, t3, e);
    return n || AnimationControl.voidControl;
  }
  quickTo(t3, e = {}) {
    if (!isIterable(t3)) throw new TypeError("AnimationAPI.quickTo error: 'keys' is not an iterable list.");
    const n = this.#$t.parent;
    if (void 0 !== n && "boolean" == typeof n?.options?.positionable && !n?.options?.positionable) throw new Error("AnimationAPI.quickTo error: 'parent' is not positionable.");
    let { duration: i = 1, ease: o = "cubicOut" } = e;
    if (!Number.isFinite(i) || i < 0) throw new TypeError("AnimationAPI.quickTo error: 'duration' is not a positive number.");
    if (o = getEasingFunc(o, AnimationAPIImpl.#bt), "function" != typeof o) throw new TypeError("AnimationAPI.quickTo error: 'ease' is not a function or valid Svelte easing function name.");
    const r = {}, s = {}, a = this.#ot;
    for (const e2 of t3) {
      if ("string" != typeof e2) throw new TypeError(`AnimationAPI.quickTo error: key ('${e2}') is not a string.`);
      if (!TJSPositionDataUtil.isAnimationKey(e2)) throw new Error(`AnimationAPI.quickTo error: key ('${e2}') is not animatable.`);
      const t4 = TJSPositionDataUtil.getDataOrDefault(a, e2);
      null !== t4 && (s[e2] = t4, r[e2] = t4);
    }
    const c = [...t3];
    Object.freeze(c);
    const l = Object.assign({}, r), p = { active: true, cancelled: false, control: void 0, current: 0, destination: s, duration: 1e3 * i, ease: o, el: void 0, finished: true, initial: r, interpolate: lerp, keys: c, newData: l, position: this.#$t, resolve: void 0, start: 0, quickTo: true }, u = (...t4) => {
      const e2 = t4.length;
      if (0 === e2) return;
      for (let t5 = c.length; --t5 >= 0; ) {
        const e3 = c[t5], n2 = TJSPositionDataUtil.getAnimationKey(e3);
        void 0 !== a[n2] && (r[e3] = a[n2]);
      }
      if (isObject(t4[0])) {
        const e3 = t4[0];
        for (const t5 in e3) void 0 !== s[t5] && (s[t5] = e3[t5]);
      } else for (let n2 = 0; n2 < e2 && n2 < c.length; n2++) {
        const e3 = c[n2];
        void 0 !== s[e3] && (s[e3] = t4[n2]);
      }
      TJSPositionDataUtil.setNumericDefaults(r), TJSPositionDataUtil.setNumericDefaults(s);
      const i2 = A11yHelper.isFocusTarget(n) ? n : n?.elementTarget;
      if (p.el = A11yHelper.isFocusTarget(i2) && i2.isConnected ? i2 : void 0, ConvertStringData.process(s, a, p.el), p.finished) p.cancelled = false, p.finished = false, p.active = true, p.current = 0, AnimationManager.add(p);
      else {
        const t5 = globalThis.performance.now();
        p.cancelled = false, p.current = 0, p.start = t5 + (AnimationManager.timeNow - t5);
      }
    };
    return Object.defineProperty(u, "keys", { value: c, writable: false, configurable: false }), Object.defineProperty(u, "options", { value: (t4) => {
      let { duration: e2, ease: n2 } = t4;
      if (void 0 !== e2 && (!Number.isFinite(e2) || e2 < 0)) throw new TypeError("AnimationAPI.quickTo.options error: 'duration' is not a positive number.");
      if (n2 = getEasingFunc(n2, AnimationAPIImpl.#bt), void 0 !== n2 && "function" != typeof n2) throw new TypeError("AnimationAPI.quickTo.options error: 'ease' is not a function or valid Svelte easing function name.");
      return NumberGuard.isFinite(e2) && e2 >= 0 && (p.duration = 1e3 * e2), n2 && (p.ease = n2), u;
    }, writable: false, configurable: false }), u;
  }
}
class AnimationGroupControl {
  #Tt;
  #P;
  static #N = new AnimationGroupControl(null);
  static get voidControl() {
    return this.#N;
  }
  constructor(t3) {
    this.#Tt = t3;
  }
  get finished() {
    const t3 = this.#Tt;
    if (!CrossWindow.isPromise(this.#P)) if (null == t3 || 0 === t3.size) this.#P = Promise.resolve({ cancelled: false });
    else {
      const e = [];
      for (const n of t3) e.push(n.finished);
      this.#P = Promise.allSettled(e).then((t4) => ({ cancelled: t4.some((t5) => "rejected" === t5.status || "fulfilled" === t5.status && t5.value.cancelled) }));
    }
    return this.#P;
  }
  get isActive() {
    const t3 = this.#Tt;
    if (null == t3 || 0 === t3.size) return false;
    for (const e of t3) if (e.isActive) return true;
    return false;
  }
  get isFinished() {
    const t3 = this.#Tt;
    if (null == t3 || 0 === t3.size) return true;
    for (const e of t3) if (!e.isFinished) return false;
    return true;
  }
  cancel() {
    const t3 = this.#Tt;
    if (null != t3 && 0 !== t3.size) for (const e of t3) e.cancel();
  }
}
class AnimationGroupAPIImpl {
  constructor() {
  }
  static #wt(t3) {
    return isObject(t3) ? t3.animate instanceof AnimationAPIImpl ? t3 : t3.position?.animate instanceof AnimationAPIImpl ? t3.position : null : null;
  }
  static cancel(t3) {
    if (isIterable(t3)) {
      let e = -1;
      for (const n of t3) {
        e++;
        const t4 = this.#wt(n);
        t4 ? AnimationManager.cancel(t4) : console.warn(`AnimationGroupAPI.cancel warning: No TJSPosition instance found at index: ${e}.`);
      }
    } else {
      const e = this.#wt(t3);
      if (!e) return void console.warn("AnimationGroupAPI.cancel warning: No TJSPosition instance found.");
      AnimationManager.cancel(e);
    }
  }
  static cancelAll() {
    AnimationManager.cancelAll();
  }
  static getScheduled(t3) {
    const e = [];
    if (isIterable(t3)) {
      let n = -1;
      for (const i of t3) {
        n++;
        const t4 = this.#wt(i);
        if (!t4) {
          console.warn(`AnimationGroupAPI.getScheduled warning: No TJSPosition instance found at index: ${n}.`);
          continue;
        }
        const o = AnimationManager.getScheduled(t4);
        e.push({ position: t4, entry: t4 !== i ? i : void 0, controls: o });
      }
    } else {
      const n = this.#wt(t3);
      if (!n) return console.warn("AnimationGroupAPI.getScheduled warning: No TJSPosition instance found."), e;
      const i = AnimationManager.getScheduled(n);
      e.push({ position: n, entry: n !== t3 ? t3 : void 0, controls: i });
    }
    return e;
  }
  static isAnimationKey(t3) {
    return TJSPositionDataUtil.isAnimationKey(t3);
  }
  static isScheduled(t3, e) {
    if (isIterable(t3)) {
      let n = -1;
      for (const i of t3) {
        n++;
        const t4 = this.#wt(i);
        if (t4) {
          if (!AnimationManager.isScheduled(t4, e)) return false;
        } else console.warn(`AnimationGroupAPI.isScheduled warning: No TJSPosition instance found at index: ${n}.`);
      }
    } else {
      const n = this.#wt(t3);
      if (!n) return console.warn("AnimationGroupAPI.isScheduled warning: No TJSPosition instance found."), false;
      if (!AnimationManager.isScheduled(n, e)) return false;
    }
    return true;
  }
  static from(t3, e, n) {
    if (!isObject(e) && "function" != typeof e) throw new TypeError("AnimationGroupAPI.from error: 'fromData' is not an object or function.");
    if (void 0 !== n && !isObject(n) && "function" != typeof n) throw new TypeError("AnimationGroupAPI.from error: 'options' is not an object or function.");
    const i = /* @__PURE__ */ new Set(), o = (t4) => i.delete(t4.control);
    let r, s = -1;
    const a = "function" == typeof e, c = "function" == typeof n, l = a || c;
    l && (r = { index: s, position: void 0, entry: void 0 });
    let p = e, u = isObject(n) ? n : void 0;
    if (isIterable(t3)) for (const d of t3) {
      s++;
      const t4 = this.#wt(d);
      if (!t4) {
        console.warn(`AnimationGroupAPI.from warning: No TJSPosition instance found at index: ${s}.`);
        continue;
      }
      if (l && (r.index = s, r.position = t4, r.entry = t4 !== d ? d : void 0), a && "function" == typeof e) {
        if (p = e(r), null == p) continue;
        if (!isObject(p)) throw new TypeError(`AnimationGroupAPI.from error: 'fromData' callback function iteration(${s}) failed to return an object.`);
      }
      if (c && "function" == typeof n) {
        if (u = n(r), null == u) continue;
        if (!isObject(u)) throw new TypeError(`AnimationGroupAPI.from error: 'options' callback function iteration(${s}) failed to return an object.`);
      }
      const m = AnimationScheduler.from(t4, p, u, o);
      m && i.add(m);
    }
    else {
      const s2 = this.#wt(t3);
      if (!s2) return console.warn("AnimationGroupAPI.from warning: No TJSPosition instance found."), AnimationGroupControl.voidControl;
      if (l && (r.index = 0, r.position = s2, r.entry = s2 !== t3 ? t3 : void 0), a && "function" == typeof e) {
        if (p = e(r), null == p) return AnimationGroupControl.voidControl;
        if (!isObject(p)) throw new TypeError("AnimationGroupAPI.from error: 'fromData' callback function failed to return an object.");
      }
      if (c && "function" == typeof n) {
        if (u = n(r), null == u) return AnimationGroupControl.voidControl;
        if (!isObject(u)) throw new TypeError("AnimationGroupAPI.from error: 'options' callback function failed to return an object.");
      }
      const d = AnimationScheduler.from(s2, p, u, o);
      d && i.add(d);
    }
    return new AnimationGroupControl(i);
  }
  static fromTo(t3, e, n, i) {
    if (!isObject(e) && "function" != typeof e) throw new TypeError("AnimationGroupAPI.fromTo error: 'fromData' is not an object or function.");
    if (!isObject(n) && "function" != typeof n) throw new TypeError("AnimationGroupAPI.fromTo error: 'toData' is not an object or function.");
    if (void 0 !== i && !isObject(i) && "function" != typeof i) throw new TypeError("AnimationGroupAPI.fromTo error: 'options' is not an object or function.");
    const o = /* @__PURE__ */ new Set(), r = (t4) => o.delete(t4.control);
    let s, a = -1;
    const c = "function" == typeof e, l = "function" == typeof n, p = "function" == typeof i, u = c || l || p;
    u && (s = { index: a, position: void 0, entry: void 0 });
    let d = e, m = n, h = isObject(i) ? i : void 0;
    if (isIterable(t3)) for (const f of t3) {
      a++;
      const t4 = this.#wt(f);
      if (!t4) {
        console.warn(`AnimationGroupAPI.fromTo warning: No TJSPosition instance found at index: ${a}.`);
        continue;
      }
      if (u && (s.index = a, s.position = t4, s.entry = t4 !== f ? f : void 0), c && "function" == typeof e) {
        if (d = e(s), null == d) continue;
        if (!isObject(d)) throw new TypeError(`AnimationGroupAPI.fromTo error: 'fromData' callback function iteration(${a}) failed to return an object.`);
      }
      if (l && "function" == typeof n) {
        if (m = n(s), null == m) continue;
        if (!isObject(m)) throw new TypeError(`AnimationGroupAPI.fromTo error: 'toData' callback function iteration(${a}) failed to return an object.`);
      }
      if (p && "function" == typeof i) {
        if (h = i(s), null == h) continue;
        if (!isObject(h)) throw new TypeError(`AnimationGroupAPI.fromTo error: 'options' callback function iteration(${a}) failed to return an object.`);
      }
      const g = AnimationScheduler.fromTo(t4, d, m, h, r);
      g && o.add(g);
    }
    else {
      const a2 = this.#wt(t3);
      if (!a2) return console.warn("AnimationGroupAPI.fromTo warning: No TJSPosition instance found."), AnimationGroupControl.voidControl;
      if (u && (s.index = 0, s.position = a2, s.entry = a2 !== t3 ? t3 : void 0), c && "function" == typeof e) {
        if (d = e(s), null == d) return AnimationGroupControl.voidControl;
        if (!isObject(d)) throw new TypeError("AnimationGroupAPI.fromTo error: 'fromData' callback function failed to return an object.");
      }
      if (l && "function" == typeof n) {
        if (m = n(s), null == m) return AnimationGroupControl.voidControl;
        if (!isObject(m)) throw new TypeError("AnimationGroupAPI.fromTo error: 'toData' callback function failed to return an object.");
      }
      if (p && "function" == typeof i) {
        if (h = i(s), null == h) return AnimationGroupControl.voidControl;
        if (!isObject(h)) throw new TypeError("AnimationGroupAPI.fromTo error: 'options' callback function failed to return an object.");
      }
      const f = AnimationScheduler.fromTo(a2, d, m, h, r);
      f && o.add(f);
    }
    return new AnimationGroupControl(o);
  }
  static to(t3, e, n) {
    if (!isObject(e) && "function" != typeof e) throw new TypeError("AnimationGroupAPI.to error: 'toData' is not an object or function.");
    if (void 0 !== n && !isObject(n) && "function" != typeof n) throw new TypeError("AnimationGroupAPI.to error: 'options' is not an object or function.");
    const i = /* @__PURE__ */ new Set(), o = (t4) => i.delete(t4.control);
    let r, s = -1;
    const a = "function" == typeof e, c = "function" == typeof n, l = a || c;
    l && (r = { index: s, position: void 0, entry: void 0 });
    let p = e, u = isObject(n) ? n : void 0;
    if (isIterable(t3)) for (const d of t3) {
      s++;
      const t4 = this.#wt(d);
      if (!t4) {
        console.warn(`AnimationGroupAPI.to warning: No TJSPosition instance found at index: ${s}.`);
        continue;
      }
      if (l && (r.index = s, r.position = t4, r.entry = t4 !== d ? d : void 0), a && "function" == typeof e) {
        if (p = e(r), null == p) continue;
        if (!isObject(p)) throw new TypeError(`AnimationGroupAPI.to error: 'toData' callback function iteration(${s}) failed to return an object.`);
      }
      if (c && "function" == typeof n) {
        if (u = n(r), null == u) continue;
        if (!isObject(u)) throw new TypeError(`AnimationGroupAPI.to error: 'options' callback function iteration(${s}) failed to return an object.`);
      }
      const m = AnimationScheduler.to(t4, p, u, o);
      m && i.add(m);
    }
    else {
      const s2 = this.#wt(t3);
      if (!s2) return console.warn("AnimationGroupAPI.to warning: No TJSPosition instance found."), AnimationGroupControl.voidControl;
      if (l && (r.index = 0, r.position = s2, r.entry = s2 !== t3 ? t3 : void 0), a && "function" == typeof e) {
        if (p = e(r), null == p) return AnimationGroupControl.voidControl;
        if (!isObject(p)) throw new TypeError("AnimationGroupAPI.to error: 'toData' callback function failed to return an object.");
      }
      if (c && "function" == typeof n) {
        if (u = n(r), null == u) return AnimationGroupControl.voidControl;
        if (!isObject(u)) throw new TypeError("AnimationGroupAPI.to error: 'options' callback function failed to return an object.");
      }
      const d = AnimationScheduler.to(s2, p, u, o);
      d && i.add(d);
    }
    return new AnimationGroupControl(i);
  }
  static quickTo(t3, e, n) {
    if (!isIterable(e)) throw new TypeError("AnimationGroupAPI.quickTo error: 'keys' is not an iterable list.");
    if (void 0 !== n && !isObject(n) && "function" != typeof n) throw new TypeError("AnimationGroupAPI.quickTo error: 'options' is not an object or function.");
    const i = [];
    let o = -1;
    const r = "function" == typeof n, s = { index: o, position: void 0, entry: void 0 };
    let a = isObject(n) ? n : void 0;
    if (isIterable(t3)) for (const c2 of t3) {
      o++;
      const t4 = this.#wt(c2);
      if (t4) {
        if (s.index = o, s.position = t4, s.entry = t4 !== c2 ? c2 : void 0, r && "function" == typeof n) {
          if (a = n(s), null == a) continue;
          if (!isObject(a)) throw new TypeError(`AnimationGroupAPI.quickTo error: 'options' callback function iteration(${o}) failed to return an object.`);
        }
        i.push(t4.animate.quickTo(e, a));
      } else console.warn(`AnimationGroupAPI.quickTo warning: No TJSPosition instance found at index: ${o}.`);
    }
    else {
      const o2 = this.#wt(t3);
      if (!o2) return void console.warn("AnimationGroupAPI.quickTo warning: No TJSPosition instance found.");
      if (s.index = 0, s.position = o2, s.entry = o2 !== t3 ? t3 : void 0, r && "function" == typeof n) {
        if (a = n(s), null == a) return;
        if (!isObject(a)) throw new TypeError("AnimationGroupAPI.quickTo error: 'options' callback function failed to return an object.");
      }
      i.push(o2.animate.quickTo(e, a));
    }
    const c = [...e];
    Object.freeze(c);
    const l = (...e2) => {
      if (0 !== e2.length) if ("function" == typeof e2[0]) {
        const n2 = e2[0];
        o = -1;
        let r2 = 0;
        if (isIterable(t3)) for (const e3 of t3) {
          o++;
          const t4 = this.#wt(e3);
          if (!t4) continue;
          s.index = o, s.position = t4, s.entry = t4 !== e3 ? e3 : void 0;
          const a2 = n2(s);
          if (null == a2) continue;
          const c2 = isIterable(a2);
          if (!Number.isFinite(a2) && !c2 && !isObject(a2)) throw new TypeError(`AnimationGroupAPI.quickTo error: 'toData' callback function iteration(${o}) failed to return a finite number, iterable list, or object.`);
          c2 ? i[r2++](...a2) : i[r2++](a2);
        }
        else {
          const e3 = this.#wt(t3);
          if (!e3) return;
          s.index = 0, s.position = e3, s.entry = e3 !== t3 ? t3 : void 0;
          const a2 = n2(s);
          if (null == a2) return;
          const c2 = isIterable(a2);
          if (!Number.isFinite(a2) && !c2 && !isObject(a2)) throw new TypeError(`AnimationGroupAPI.quickTo error: 'toData' callback function iteration(${o}) failed to return a finite number, iterable list, or object.`);
          c2 ? i[r2++](...a2) : i[r2++](a2);
        }
      } else for (let t4 = i.length; --t4 >= 0; ) i[t4](...e2);
    };
    return Object.defineProperty(l, "keys", { value: c, writable: false, configurable: false }), Object.defineProperty(l, "options", { value: (t4) => {
      if (void 0 !== t4 && !isObject(t4)) throw new TypeError("AnimationGroupAPI.quickTo error: 'options' is not an object.");
      if (isObject(t4)) for (let e2 = i.length; --e2 >= 0; ) i[e2].options(t4);
      return l;
    }, writable: false, configurable: false }), l;
  }
}
Object.seal(AnimationGroupAPIImpl);
class PositionStateAPI {
  #ot;
  #St = /* @__PURE__ */ new Map();
  #$t;
  #kt;
  constructor(t3, e, n) {
    this.#$t = t3, this.#ot = e, this.#kt = n, Object.seal(this);
  }
  clear() {
    for (const t3 of this.#St.keys()) "#defaultData" !== t3 && this.#St.delete(t3);
  }
  get({ name: t3 }) {
    if ("string" != typeof t3) throw new TypeError("TJSPosition - get error: 'name' is not a string.");
    return this.#St.get(t3);
  }
  getDefault() {
    return this.#St.get("#defaultData");
  }
  keys() {
    return this.#St.keys();
  }
  remove({ name: t3 }) {
    if ("string" != typeof t3) throw new TypeError("TJSPosition - remove: 'name' is not a string.");
    const e = this.#St.get(t3);
    return this.#St.delete(t3), e;
  }
  reset({ keepZIndex: t3 = false, invokeSet: e = true } = {}) {
    const n = this.#St.get("#defaultData");
    if (!isObject(n)) return false;
    this.#$t.animate.isScheduled && this.#$t.animate.cancel();
    const i = this.#$t.zIndex, o = Object.assign({}, n);
    t3 && (o.zIndex = i), this.#kt.reset(o);
    const r = this.#$t.parent;
    return r?.reactive?.minimized && r?.maximize?.({ animate: false, duration: 0 }), e && setTimeout(() => this.#$t.set(o), 0), true;
  }
  restore({ name: t3, remove: e = false, properties: n, silent: i = false, async: o = false, animateTo: r = false, duration: s = 0.1, ease: a = "linear" }) {
    if ("string" != typeof t3) throw new TypeError("TJSPosition - restore error: 'name' is not a string.");
    const c = this.#St.get(t3);
    if (c) {
      e && this.#St.delete(t3);
      let l = c;
      if (isIterable(n)) {
        l = {};
        for (const t4 of n) l[t4] = c[t4];
      }
      if (i) {
        for (const t4 in l) t4 in this.#ot && (this.#ot[t4] = l[t4]);
        return c;
      }
      if (r) {
        if (l.transformOrigin !== this.#$t.transformOrigin && (this.#$t.transformOrigin = l.transformOrigin), o) return this.#$t.animate.to(l, { duration: s, ease: a }).finished.then(() => c);
        this.#$t.animate.to(l, { duration: s, ease: a });
      } else this.#$t.set(l);
    }
    return o ? Promise.resolve(c) : c;
  }
  save({ name: t3, ...e }, n) {
    if ("string" != typeof t3) throw new TypeError("TJSPosition - save error: 'name' is not a string.");
    const i = this.#$t.get(e, n);
    return this.#St.set(t3, i), i;
  }
  set({ name: t3, ...e }) {
    if ("string" != typeof t3) throw new TypeError("TJSPosition - set error: 'name' is not a string.");
    this.#St.set(t3, e);
  }
}
class SystemBase {
  #Ot;
  #xt;
  #Et;
  #Mt;
  #At;
  #A = [];
  #Ct;
  constructor({ constrain: t3 = true, element: e, enabled: n = true, lock: i = false, width: o, height: r } = {}) {
    this.#Ot = true, this.#Et = true, this.constrain = t3, this.element = e, this.enabled = n, this.width = o, this.height = r, this.#At = "boolean" == typeof i && i;
  }
  get constrain() {
    return this.#Ot;
  }
  get element() {
    return this.#xt;
  }
  get enabled() {
    return this.#Et;
  }
  get height() {
    return this.#Mt;
  }
  get locked() {
    return this.#At;
  }
  get width() {
    return this.#Ct;
  }
  set constrain(t3) {
    if (!this.#At) {
      if ("boolean" != typeof t3) throw new TypeError("'constrain' is not a boolean.");
      this.#Ot = t3, this.#C();
    }
  }
  set element(t3) {
    if (!this.#At) {
      if (null != t3 && !A11yHelper.isFocusTarget(t3)) throw new TypeError("'element' is not a HTMLElement, undefined, or null.");
      this.#xt = t3, this.#C();
    }
  }
  set enabled(t3) {
    if (!this.#At) {
      if ("boolean" != typeof t3) throw new TypeError("'enabled' is not a boolean.");
      this.#Et = t3, this.#C();
    }
  }
  set height(t3) {
    if (!this.#At) {
      if (void 0 !== t3 && !Number.isFinite(t3)) throw new TypeError("'height' is not a finite number or undefined.");
      this.#Mt = t3, this.#C();
    }
  }
  set width(t3) {
    if (!this.#At) {
      if (void 0 !== t3 && !Number.isFinite(t3)) throw new TypeError("'width' is not a finite number or undefined.");
      this.#Ct = t3, this.#C();
    }
  }
  setDimension(t3, e) {
    if (!this.#At) {
      if (void 0 !== t3 && !Number.isFinite(t3)) throw new TypeError("'width' is not a finite number or undefined.");
      if (this.#Ct = t3, void 0 !== e && !Number.isFinite(e)) throw new TypeError("'height' is not a finite number or undefined.");
      this.#Mt = e, this.#C();
    }
  }
  subscribe(t3) {
    return -1 === this.#A.findIndex((e) => e === t3) && (this.#A.push(t3), t3(this)), () => {
      const e = this.#A.findIndex((e2) => e2 === t3);
      -1 !== e && this.#A.splice(e, 1);
    };
  }
  #C() {
    for (let t3 = 0; t3 < this.#A.length; t3++) this.#A[t3](this);
  }
}
class Centered extends SystemBase {
  getLeft(t3) {
    return ((this.width ?? this.element?.offsetWidth ?? globalThis.innerWidth) - t3) / 2;
  }
  getTop(t3) {
    return ((this.height ?? this.element?.offsetHeight ?? globalThis.innerHeight) - t3) / 2;
  }
}
class AdapterValidators {
  #Et = true;
  #It;
  #Pt = /* @__PURE__ */ new Map();
  #Dt;
  static create(t3) {
    const e = new AdapterValidators(t3);
    return [e, e.#It];
  }
  constructor(t3) {
    this.#It = [], this.#Dt = t3, Object.seal(this);
  }
  get enabled() {
    return this.#Et;
  }
  get length() {
    return this.#It.length;
  }
  set enabled(t3) {
    if ("boolean" != typeof t3) throw new TypeError("'enabled' is not a boolean.");
    this.#Et = t3;
  }
  *[Symbol.iterator]() {
    if (0 !== this.#It.length) for (const t3 of this.#It) yield { ...t3 };
  }
  add(...t3) {
    let e = 0;
    for (const n of t3) {
      const t4 = typeof n;
      if ("function" !== t4 && "object" !== t4 || null === n) throw new TypeError("AdapterValidator error: 'validator' is not a function or object.");
      let i, o;
      switch (t4) {
        case "function":
          i = { id: void 0, validate: n, weight: 1 }, o = n.subscribe;
          break;
        case "object":
          if (!("validate" in n)) throw new TypeError("AdapterValidator error: 'validate' attribute is not a function.");
          if ("function" != typeof n.validate) throw new TypeError("AdapterValidator error: 'validate' attribute is not a function.");
          if (void 0 !== n.weight && "number" != typeof n.weight || n?.weight < 0 || n?.weight > 1) throw new TypeError("AdapterValidator error: 'weight' attribute is not a number between '0 - 1' inclusive.");
          i = { id: void 0 !== n.id ? n.id : void 0, validate: n.validate.bind(n), weight: n.weight || 1 }, o = n.validate.subscribe ?? n.subscribe;
      }
      const r = this.#It.findIndex((t5) => i.weight < t5.weight);
      if (r >= 0 ? this.#It.splice(r, 0, i) : this.#It.push(i), "function" == typeof o) {
        const t5 = o.call(n, this.#Dt);
        if ("function" != typeof t5) throw new TypeError("AdapterValidator error: Validator has subscribe function, but no unsubscribe function is returned.");
        if (this.#Pt.has(i.validate)) throw new Error("AdapterValidator error: Validator added already has an unsubscribe function registered.");
        this.#Pt.set(i.validate, t5), e++;
      }
    }
    e < t3.length && this.#Dt();
  }
  clear() {
    this.#It.length = 0;
    for (const t3 of this.#Pt.values()) t3();
    this.#Pt.clear(), this.#Dt();
  }
  remove(...t3) {
    const e = this.#It.length;
    if (0 !== e) {
      for (const e2 of t3) {
        const t4 = "function" == typeof e2 ? e2 : isObject(e2) ? e2.validate : void 0;
        if (t4) {
          for (let e3 = this.#It.length; --e3 >= 0; ) if (this.#It[e3].validate === t4) {
            let n;
            this.#It.splice(e3, 1), "function" == typeof (n = this.#Pt.get(t4)) && (n(), this.#Pt.delete(t4));
          }
        }
      }
      e !== this.#It.length && this.#Dt();
    }
  }
  removeBy(t3) {
    const e = this.#It.length;
    if (0 !== e) {
      if ("function" != typeof t3) throw new TypeError("AdapterValidator error: 'callback' is not a function.");
      this.#It = this.#It.filter((e2) => {
        const n = t3.call(t3, { ...e2 });
        if (n) {
          let t4;
          "function" == typeof (t4 = this.#Pt.get(e2.validate)) && (t4(), this.#Pt.delete(e2.validate));
        }
        return !n;
      }), e !== this.#It.length && this.#Dt();
    }
  }
  removeById(...t3) {
    const e = this.#It.length;
    0 !== e && (this.#It = this.#It.filter((e2) => {
      let n = false;
      for (const i of t3) n ||= e2.id === i;
      if (n) {
        let t4;
        "function" == typeof (t4 = this.#Pt.get(e2.validate)) && (t4(), this.#Pt.delete(e2.validate));
      }
      return !n;
    }), e !== this.#It.length && this.#Dt());
  }
}
class TransformBounds extends SystemBase {
  static #Nt = new TJSTransformData();
  validate(t3) {
    if (!this.enabled) return t3.position;
    const e = this.width ?? this.element?.offsetWidth ?? globalThis.innerWidth, n = this.height ?? this.element?.offsetHeight ?? globalThis.innerHeight;
    if ("number" == typeof t3.position.width) {
      const n2 = t3.maxWidth ?? (this.constrain ? e : Number.MAX_SAFE_INTEGER);
      t3.position.width = clamp(t3.width, t3.minWidth, n2);
    }
    if ("number" == typeof t3.position.height) {
      const e2 = t3.maxHeight ?? (this.constrain ? n : Number.MAX_SAFE_INTEGER);
      t3.position.height = clamp(t3.height, t3.minHeight, e2);
    }
    const i = t3.transforms.getData(t3.position, TransformBounds.#Nt, t3), o = i.boundingRect.x, r = i.boundingRect.y, s = t3.marginTop ?? 0, a = t3.marginLeft ?? 0;
    return i.boundingRect.bottom + s > n && (i.boundingRect.y += n - i.boundingRect.bottom - s), i.boundingRect.right + a > e && (i.boundingRect.x += e - i.boundingRect.right - a), i.boundingRect.top - s < 0 && (i.boundingRect.y += Math.abs(i.boundingRect.top - s)), i.boundingRect.left - a < 0 && (i.boundingRect.x += Math.abs(i.boundingRect.left - a)), t3.position.left -= o - i.boundingRect.x, t3.position.top -= r - i.boundingRect.y, t3.position;
  }
}
class PositionChangeSet {
  left;
  top;
  width;
  height;
  maxHeight;
  maxWidth;
  minHeight;
  minWidth;
  zIndex;
  transform;
  transformOrigin;
  constructor() {
    this.left = false, this.top = false, this.width = false, this.height = false, this.maxHeight = false, this.maxWidth = false, this.minHeight = false, this.minWidth = false, this.zIndex = false, this.transform = false, this.transformOrigin = false;
  }
  hasChange() {
    return this.left || this.top || this.width || this.height || this.maxHeight || this.maxWidth || this.minHeight || this.minWidth || this.zIndex || this.transform || this.transformOrigin;
  }
  set(t3) {
    this.left = t3, this.top = t3, this.width = t3, this.height = t3, this.maxHeight = t3, this.maxWidth = t3, this.minHeight = t3, this.minWidth = t3, this.zIndex = t3, this.transform = t3, this.transformOrigin = t3;
  }
}
class UpdateElementData {
  changeSet;
  data;
  dataSubscribers;
  dimensionData;
  options;
  queued;
  storeDimension;
  storeTransform;
  styleCache;
  subscribers;
  transforms;
  transformData;
  constructor(t3, e, n, i, o, r) {
    this.changeSet = t3, this.data = e, this.dataSubscribers = Object.seal(new TJSPositionData()), this.dimensionData = Object.seal({ width: 0, height: 0 }), this.options = n, this.queued = false, this.styleCache = i, this.storeDimension = writable(this.dimensionData), this.subscribers = o, this.transforms = r, this.transformData = new TJSTransformData(), this.storeTransform = writable(this.transformData, () => (this.options.transformSubscribed = true, () => this.options.transformSubscribed = false));
  }
}
class UpdateElementManager {
  static list = [];
  static listCntr = 0;
  static updatePromise;
  static add(t3, e) {
    if (this.listCntr < this.list.length) {
      const n = this.list[this.listCntr];
      n[0] = t3, n[1] = e;
    } else this.list.push([t3, e]);
    return this.listCntr++, e.queued = true, this.updatePromise || (this.updatePromise = this.wait()), this.updatePromise;
  }
  static async wait() {
    const t3 = await nextAnimationFrame();
    this.updatePromise = void 0;
    for (let t4 = this.listCntr; --t4 >= 0; ) {
      const e = this.list[t4], n = e[0], i = e[1];
      e[0] = void 0, e[1] = void 0, i.queued = false, n.isConnected && (i.options.ortho ? UpdateElementManager.#jt(n, i) : UpdateElementManager.#Lt(n, i), (i.options.calculateTransform || i.options.transformSubscribed) && UpdateElementManager.#Ft(i), this.updateSubscribers(i));
    }
    return this.listCntr = 0, t3;
  }
  static immediate(t3, e) {
    t3.isConnected && (e.options.ortho ? UpdateElementManager.#jt(t3, e) : UpdateElementManager.#Lt(t3, e), (e.options.calculateTransform || e.options.transformSubscribed) && UpdateElementManager.#Ft(e), this.updateSubscribers(e));
  }
  static updateSubscribers(t3) {
    const e = t3.data, n = t3.changeSet;
    if (!n.hasChange()) return;
    const i = TJSPositionDataUtil.copyData(e, t3.dataSubscribers), o = t3.subscribers;
    if (o.length > 0) for (let t4 = 0; t4 < o.length; t4++) o[t4](i);
    (n.width || n.height) && (t3.dimensionData.width = e.width, t3.dimensionData.height = e.height, t3.storeDimension.set(t3.dimensionData)), n.set(false);
  }
  static #zt = Object.seal({ height: 0, width: 0, marginLeft: 0, marginTop: 0 });
  static #Lt(t3, e) {
    const n = e.changeSet, i = e.data;
    n.left && (t3.style.left = `${i.left}px`), n.top && (t3.style.top = `${i.top}px`), n.zIndex && (t3.style.zIndex = "number" == typeof i.zIndex ? `${i.zIndex}` : ""), n.width && (t3.style.width = "number" == typeof i.width ? `${i.width}px` : i.width), n.height && (t3.style.height = "number" == typeof i.height ? `${i.height}px` : i.height), n.transformOrigin && (t3.style.transformOrigin = i.transformOrigin), n.transform && (t3.style.transform = e.transforms.isActive ? e.transforms.getCSS() : "");
  }
  static #jt(t3, e) {
    const n = e.changeSet, i = e.data;
    n.zIndex && (t3.style.zIndex = "number" == typeof i.zIndex ? `${i.zIndex}` : ""), n.width && (t3.style.width = "number" == typeof i.width ? `${i.width}px` : i.width), n.height && (t3.style.height = "number" == typeof i.height ? `${i.height}px` : i.height), n.transformOrigin && (t3.style.transformOrigin = i.transformOrigin), (n.left || n.top || n.transform) && (t3.style.transform = e.transforms.getCSSOrtho(i));
  }
  static #Ft(t3) {
    const e = this.#zt;
    e.height = "auto" !== t3.data.height && "inherit" !== t3.data.height ? t3.data.height : t3.styleCache.offsetHeight, e.width = "auto" !== t3.data.width && "inherit" !== t3.data.width ? t3.data.width : t3.styleCache.offsetWidth, e.marginLeft = t3.styleCache.marginLeft, e.marginTop = t3.styleCache.marginTop, t3.transforms.getData(t3.data, t3.transformData, e), t3.storeTransform.set(t3.transformData);
  }
}
class TJSPosition {
  static #Rt = Object.freeze({ browserCentered: new Centered({ lock: true }), Centered });
  static #Ht = Object.freeze({ TransformBounds, transformWindow: new TransformBounds({ lock: true }) });
  #ot = Object.seal(new TJSPositionData());
  #Wt = new AnimationAPIImpl(this, this.#ot);
  #Et = true;
  #qt = { calculateTransform: false, initial: void 0, ortho: true, transformSubscribed: false };
  #Jt;
  #Gt = new PositionChangeSet();
  #Ut = false;
  #l;
  #Bt;
  #A = [];
  #kt = new TJSTransforms();
  #Vt;
  #Yt;
  #Xt;
  #It;
  #Zt = new PositionStateAPI(this, this.#ot, this.#kt);
  static get Animate() {
    return AnimationGroupAPIImpl;
  }
  static get Data() {
    return TJSPositionData;
  }
  static get Initial() {
    return this.#Rt;
  }
  static get SystemBase() {
    return SystemBase;
  }
  static get TransformData() {
    return TJSTransformData;
  }
  static get Validators() {
    return this.#Ht;
  }
  static get transformOrigins() {
    return TJSTransforms.transformOrigins;
  }
  static copyData(t3, e) {
    return TJSPositionDataUtil.copyData(t3, e);
  }
  static duplicate(t3, e = {}) {
    if (!(t3 instanceof _a)) throw new TypeError("'position' is not an instance of TJSPosition.");
    const n = new _a(e);
    return n.#qt = Object.assign({}, t3.#qt, e), n.#Xt.add(...t3.#Xt), n.set(t3.#ot), n;
  }
  constructor(t3, e) {
    isPlainObject(t3) ? e = t3 : this.#Jt = t3, this.#Bt = new TJSPositionStyleCache();
    const n = new UpdateElementData(this.#Gt, this.#ot, this.#qt, this.#Bt, this.#A, this.#kt);
    if (this.#Vt = n, "boolean" == typeof e?.calculateTransform && (this.#qt.calculateTransform = e.calculateTransform), "boolean" == typeof e?.ortho && (this.#qt.ortho = e.ortho), this.#l = Object.freeze({ height: propertyStore(this, "height"), left: propertyStore(this, "left"), rotateX: propertyStore(this, "rotateX"), rotateY: propertyStore(this, "rotateY"), rotateZ: propertyStore(this, "rotateZ"), scale: propertyStore(this, "scale"), top: propertyStore(this, "top"), transformOrigin: propertyStore(this, "transformOrigin"), translateX: propertyStore(this, "translateX"), translateY: propertyStore(this, "translateY"), translateZ: propertyStore(this, "translateZ"), width: propertyStore(this, "width"), zIndex: propertyStore(this, "zIndex"), maxHeight: propertyStore(this, "maxHeight"), maxWidth: propertyStore(this, "maxWidth"), minHeight: propertyStore(this, "minHeight"), minWidth: propertyStore(this, "minWidth"), dimension: { subscribe: n.storeDimension.subscribe }, element: { subscribe: this.#Bt.stores.element.subscribe }, resizeContentHeight: { subscribe: this.#Bt.stores.resizeContentHeight.subscribe }, resizeContentWidth: { subscribe: this.#Bt.stores.resizeContentWidth.subscribe }, resizeObservable: { subscribe: this.#Bt.stores.resizeObservable.subscribe }, resizeOffsetHeight: { subscribe: this.#Bt.stores.resizeOffsetHeight.subscribe }, resizeOffsetWidth: { subscribe: this.#Bt.stores.resizeOffsetWidth.subscribe }, transform: { subscribe: n.storeTransform.subscribe }, resizeObserved: this.#Bt.stores.resizeObserved }), Object.defineProperty(this.#l.transformOrigin, "values", { get: () => _a.transformOrigins }), subscribeIgnoreFirst(this.#l.resizeObserved, (t4) => {
      const e2 = this.#Jt, n2 = A11yHelper.isFocusTarget(e2) ? e2 : e2?.elementTarget;
      A11yHelper.isFocusTarget(n2) && Number.isFinite(t4?.offsetWidth) && Number.isFinite(t4?.offsetHeight) && this.set();
    }), [this.#Xt, this.#It] = AdapterValidators.create(() => this.set()), e?.initial) {
      const t4 = e.initial;
      if ("function" != typeof t4?.getLeft || "function" != typeof t4?.getTop) throw new Error("'options.initial' position helper does not contain 'getLeft' and / or 'getTop' functions.");
      this.#qt.initial = t4;
    }
    if (e?.validator) if (isIterable(e?.validator)) this.validators.add(...e.validator);
    else {
      const t4 = e.validator;
      this.validators.add(t4);
    }
    Object.seal(this), isObject(e) && this.set(e);
  }
  get animate() {
    return this.#Wt;
  }
  get dimension() {
    return this.#Vt.dimensionData;
  }
  get enabled() {
    return this.#Et;
  }
  get element() {
    return this.#Bt.el;
  }
  get elementUpdated() {
    return this.#Yt;
  }
  get parent() {
    return this.#Jt;
  }
  get state() {
    return this.#Zt;
  }
  get stores() {
    return this.#l;
  }
  get transform() {
    return this.#Vt.transformData;
  }
  get validators() {
    return this.#Xt;
  }
  set enabled(t3) {
    if ("boolean" != typeof t3) throw new TypeError("'enabled' is not a boolean.");
    this.#Et = t3;
  }
  set parent(t3) {
    if (void 0 !== t3 && !A11yHelper.isFocusTarget(t3) && !isObject(t3)) throw new TypeError("'parent' is not an HTMLElement, object, or undefined.");
    this.#Jt = t3, this.#Zt.remove({ name: "#defaultData" }), this.#Bt.reset(), t3 && this.set(this.#ot);
  }
  get height() {
    return this.#ot.height;
  }
  get left() {
    return this.#ot.left;
  }
  get maxHeight() {
    return this.#ot.maxHeight;
  }
  get maxWidth() {
    return this.#ot.maxWidth;
  }
  get minHeight() {
    return this.#ot.minHeight;
  }
  get minWidth() {
    return this.#ot.minWidth;
  }
  get rotateX() {
    return this.#ot.rotateX;
  }
  get rotateY() {
    return this.#ot.rotateY;
  }
  get rotateZ() {
    return this.#ot.rotateZ;
  }
  get rotation() {
    return this.#ot.rotateZ;
  }
  get scale() {
    return this.#ot.scale;
  }
  get top() {
    return this.#ot.top;
  }
  get transformOrigin() {
    return this.#ot.transformOrigin;
  }
  get translateX() {
    return this.#ot.translateX;
  }
  get translateY() {
    return this.#ot.translateY;
  }
  get translateZ() {
    return this.#ot.translateZ;
  }
  get width() {
    return this.#ot.width;
  }
  get zIndex() {
    return this.#ot.zIndex;
  }
  set height(t3) {
    this.#l.height.set(t3);
  }
  set left(t3) {
    this.#l.left.set(t3);
  }
  set maxHeight(t3) {
    this.#l.maxHeight.set(t3);
  }
  set maxWidth(t3) {
    this.#l.maxWidth.set(t3);
  }
  set minHeight(t3) {
    this.#l.minHeight.set(t3);
  }
  set minWidth(t3) {
    this.#l.minWidth.set(t3);
  }
  set rotateX(t3) {
    this.#l.rotateX.set(t3);
  }
  set rotateY(t3) {
    this.#l.rotateY.set(t3);
  }
  set rotateZ(t3) {
    this.#l.rotateZ.set(t3);
  }
  set rotation(t3) {
    this.#l.rotateZ.set(t3);
  }
  set scale(t3) {
    this.#l.scale.set(t3);
  }
  set top(t3) {
    this.#l.top.set(t3);
  }
  set transformOrigin(t3) {
    TJSTransforms.transformOrigins.includes(t3) && this.#l.transformOrigin.set(t3);
  }
  set translateX(t3) {
    this.#l.translateX.set(t3);
  }
  set translateY(t3) {
    this.#l.translateY.set(t3);
  }
  set translateZ(t3) {
    this.#l.translateZ.set(t3);
  }
  set width(t3) {
    this.#l.width.set(t3);
  }
  set zIndex(t3) {
    this.#l.zIndex.set(t3);
  }
  get(t3 = {}, e = {}) {
    const n = e?.keys, i = e?.exclude, o = e?.nullable ?? true, r = e?.numeric ?? false;
    if (isIterable(n)) {
      for (const e2 of n) t3[e2] = r ? TJSPositionDataUtil.getDataOrDefault(this, e2) : this[e2], o || null !== t3[e2] || delete t3[e2];
      if (isIterable(i)) for (const e2 of i) delete t3[e2];
      return t3;
    }
    if (t3 = Object.assign(t3, this.#ot), isIterable(i)) for (const e2 of i) delete t3[e2];
    if (r && TJSPositionDataUtil.setNumericDefaults(t3), !o) for (const e2 in t3) null === t3[e2] && delete t3[e2];
    return t3;
  }
  toJSON() {
    return Object.assign({}, this.#ot);
  }
  set(t3 = {}, e = {}) {
    if (!isObject(t3)) throw new TypeError("TJSPosition - set error: 'position' is not an object.");
    const n = this.#Jt;
    if (!this.#Et) return this;
    if (void 0 !== n && "boolean" == typeof n?.options?.positionable && !n?.options?.positionable) return this;
    const i = e?.immediateElementUpdate ?? false, o = this.#ot, r = this.#kt, s = A11yHelper.isFocusTarget(n) ? n : n?.elementTarget, a = A11yHelper.isFocusTarget(s) && s.isConnected ? s : void 0, c = this.#Gt, l = this.#Bt;
    if (a && (l.hasData(a) || (l.update(a), l.hasWillChange, c.set(true), this.#Vt.queued = false), ConvertStringData.process(t3, this.#ot, a), null === (t3 = this.#Kt(t3, n, a, l)))) return this;
    NumberGuard.isFinite(t3.left) && (t3.left = Math.round(t3.left), o.left !== t3.left && (o.left = t3.left, c.left = true)), NumberGuard.isFinite(t3.top) && (t3.top = Math.round(t3.top), o.top !== t3.top && (o.top = t3.top, c.top = true)), NumberGuard.isFiniteOrNull(t3.maxHeight) && (t3.maxHeight = "number" == typeof t3.maxHeight ? Math.round(t3.maxHeight) : null, o.maxHeight !== t3.maxHeight && (o.maxHeight = t3.maxHeight, c.maxHeight = true)), NumberGuard.isFiniteOrNull(t3.maxWidth) && (t3.maxWidth = "number" == typeof t3.maxWidth ? Math.round(t3.maxWidth) : null, o.maxWidth !== t3.maxWidth && (o.maxWidth = t3.maxWidth, c.maxWidth = true)), NumberGuard.isFiniteOrNull(t3.minHeight) && (t3.minHeight = "number" == typeof t3.minHeight ? Math.round(t3.minHeight) : null, o.minHeight !== t3.minHeight && (o.minHeight = t3.minHeight, c.minHeight = true)), NumberGuard.isFiniteOrNull(t3.minWidth) && (t3.minWidth = "number" == typeof t3.minWidth ? Math.round(t3.minWidth) : null, o.minWidth !== t3.minWidth && (o.minWidth = t3.minWidth, c.minWidth = true)), NumberGuard.isFiniteOrNull(t3.rotateX) && o.rotateX !== t3.rotateX && (o.rotateX = r.rotateX = t3.rotateX, c.transform = true), NumberGuard.isFiniteOrNull(t3.rotateY) && o.rotateY !== t3.rotateY && (o.rotateY = r.rotateY = t3.rotateY, c.transform = true), NumberGuard.isFiniteOrNull(t3.rotateZ) && o.rotateZ !== t3.rotateZ && (o.rotateZ = r.rotateZ = t3.rotateZ, c.transform = true), NumberGuard.isFiniteOrNull(t3.scale) && (t3.scale = "number" == typeof t3.scale ? clamp(t3.scale, 0, 1e3) : null, o.scale !== t3.scale && (o.scale = r.scale = t3.scale, c.transform = true)), ("string" == typeof t3.transformOrigin && TJSTransforms.transformOrigins.includes(t3.transformOrigin) || null === t3.transformOrigin) && o.transformOrigin !== t3.transformOrigin && (o.transformOrigin = t3.transformOrigin, c.transformOrigin = true), NumberGuard.isFiniteOrNull(t3.translateX) && o.translateX !== t3.translateX && (o.translateX = r.translateX = t3.translateX, c.transform = true), NumberGuard.isFiniteOrNull(t3.translateY) && o.translateY !== t3.translateY && (o.translateY = r.translateY = t3.translateY, c.transform = true), NumberGuard.isFiniteOrNull(t3.translateZ) && o.translateZ !== t3.translateZ && (o.translateZ = r.translateZ = t3.translateZ, c.transform = true), NumberGuard.isFinite(t3.zIndex) && (t3.zIndex = Math.round(t3.zIndex), o.zIndex !== t3.zIndex && (o.zIndex = t3.zIndex, c.zIndex = true));
    const p = "auto" === t3.width || "inherit" === t3.width;
    (NumberGuard.isFiniteOrNull(t3.width) || p) && (t3.width = "number" == typeof t3.width ? Math.round(t3.width) : t3.width, o.width !== t3.width && (o.width = t3.width, c.width = true));
    const u = "auto" === t3.height || "inherit" === t3.height;
    (NumberGuard.isFiniteOrNull(t3.height) || u) && (t3.height = "number" == typeof t3.height ? Math.round(t3.height) : t3.height, o.height !== t3.height && (o.height = t3.height, c.height = true));
    const d = p || u;
    if (this.#Ut !== d && (this.#Ut = d, this.#Bt.stores.resizeObservable.set(d)), a) {
      isObject(this.#Zt.getDefault()) || this.#Zt.save({ name: "#defaultData", ...Object.assign({}, o) }), i ? (UpdateElementManager.immediate(a, this.#Vt), this.#Yt = Promise.resolve(globalThis.performance.now())) : this.#Vt.queued || (this.#Yt = UpdateElementManager.add(a, this.#Vt));
    } else UpdateElementManager.updateSubscribers(this.#Vt);
    return this;
  }
  subscribe(t3) {
    return -1 === this.#A.findIndex((e) => e === t3) && (this.#A.push(t3), t3(Object.assign({}, this.#ot))), () => {
      const e = this.#A.findIndex((e2) => e2 === t3);
      -1 !== e && this.#A.splice(e, 1);
    };
  }
  update(t3) {
    const e = t3(this.get());
    if (!isObject(e)) throw new TypeError("'result' of 'updater' is not an object.");
    this.set(e);
  }
  static #Qt = Object.seal(new TJSPositionData());
  static #zt = Object.seal({ position: void 0, parent: void 0, el: void 0, computed: void 0, transforms: void 0, height: void 0, width: void 0, marginLeft: void 0, marginTop: void 0, maxHeight: void 0, maxWidth: void 0, minHeight: void 0, minWidth: void 0, rest: void 0 });
  #Kt({ left: t3, top: e, maxWidth: n, maxHeight: i, minWidth: o, minHeight: r, width: s, height: a, rotateX: c, rotateY: l, rotateZ: p, scale: u, transformOrigin: d, translateX: m, translateY: h, translateZ: f, zIndex: g, rotation: _, ...b }, y, v, $2) {
    let T = TJSPositionDataUtil.copyData(this.#ot, _a.#Qt);
    if (void 0 !== s || "" === v.style.width) {
      const t4 = null === s || Number.isFinite(s);
      if ("auto" === s || "auto" === T.width && !t4) T.width = "auto", s = $2.offsetWidth;
      else if ("inherit" === s || "inherit" === T.width && !t4) T.width = "inherit", s = $2.offsetWidth;
      else {
        const t5 = NumberGuard.isFinite(s) ? s : T.width;
        T.width = s = NumberGuard.isFinite(t5) ? Math.round(t5) : $2.offsetWidth;
      }
    } else s = Number.isFinite(T.width) ? T.width : $2.offsetWidth;
    if (void 0 !== a || "" === v.style.height) {
      const t4 = null === a || Number.isFinite(a);
      if ("auto" === a || "auto" === T.height && !t4) T.height = "auto", a = $2.offsetHeight;
      else if ("inherit" === a || "inherit" === T.height && !t4) T.height = "inherit", a = $2.offsetHeight;
      else {
        const t5 = NumberGuard.isFinite(a) ? a : T.height;
        T.height = a = NumberGuard.isFinite(t5) ? Math.round(t5) : $2.offsetHeight;
      }
    } else a = Number.isFinite(T.height) ? T.height : $2.offsetHeight;
    NumberGuard.isFinite(t3) ? T.left = t3 : Number.isFinite(T.left) || (T.left = "function" == typeof this.#qt?.initial?.getLeft ? this.#qt.initial.getLeft(s) : 0), Number.isFinite(e) ? T.top = e : Number.isFinite(T.top) || (T.top = "function" == typeof this.#qt?.initial?.getTop ? this.#qt.initial.getTop(a) : 0), NumberGuard.isFiniteOrNull(i) && (T.maxHeight = NumberGuard.isFinite(i) ? Math.round(i) : null), NumberGuard.isFiniteOrNull(n) && (T.maxWidth = NumberGuard.isFinite(n) ? Math.round(n) : null), NumberGuard.isFiniteOrNull(r) && (T.minHeight = NumberGuard.isFinite(r) ? Math.round(r) : null), NumberGuard.isFiniteOrNull(o) && (T.minWidth = NumberGuard.isFinite(o) ? Math.round(o) : null), NumberGuard.isFiniteOrNull(c) && (T.rotateX = c), NumberGuard.isFiniteOrNull(l) && (T.rotateY = l), p !== T.rotateZ && NumberGuard.isFiniteOrNull(p) ? T.rotateZ = p : _ !== T.rotateZ && NumberGuard.isFiniteOrNull(_) && (T.rotateZ = _), NumberGuard.isFiniteOrNull(m) && (T.translateX = m), NumberGuard.isFiniteOrNull(h) && (T.translateY = h), NumberGuard.isFiniteOrNull(f) && (T.translateZ = f), NumberGuard.isFiniteOrNull(u) && (T.scale = "number" == typeof u ? clamp(u, 0, 1e3) : null), "string" != typeof d && null !== d || (T.transformOrigin = TJSTransforms.transformOrigins.includes(d) ? d : null), NumberGuard.isFiniteOrNull(g) && (T.zIndex = "number" == typeof g ? Math.round(g) : g);
    const w = this.#It;
    if (this.#Xt.enabled && w.length) {
      const t4 = _a.#zt;
      t4.parent = y, t4.el = v, t4.computed = $2.computed, t4.transforms = this.#kt, t4.height = a, t4.width = s, t4.marginLeft = $2.marginLeft, t4.marginTop = $2.marginTop, t4.maxHeight = $2.maxHeight ?? T.maxHeight, t4.maxWidth = $2.maxWidth ?? T.maxWidth;
      const e2 = y?.reactive?.minimized ?? false;
      t4.minHeight = e2 ? T.minHeight ?? 0 : $2.minHeight || (T.minHeight ?? 0), t4.minWidth = e2 ? T.minWidth ?? 0 : $2.minWidth || (T.minWidth ?? 0);
      for (let e3 = 0; e3 < w.length; e3++) if (t4.position = T, t4.rest = b, T = w[e3].validate(t4), null === T) return null;
    }
    return T;
  }
}
function fade(t3, { delay: e = 0, duration: n = 400, easing: i = identity } = {}) {
  const o = +getComputedStyle(t3).opacity;
  return { delay: e, duration: n, easing: i, css: (t4) => "opacity: " + t4 * o };
}
function slide(t3, { delay: e = 0, duration: n = 400, easing: i = cubicOut, axis: o = "y" } = {}) {
  const r = getComputedStyle(t3), s = +r.opacity, a = "y" === o ? "height" : "width", c = parseFloat(r[a]), l = "y" === o ? ["top", "bottom"] : ["left", "right"], p = l.map((t4) => `${t4[0].toUpperCase()}${t4.slice(1)}`), u = parseFloat(r[`padding${p[0]}`]), d = parseFloat(r[`padding${p[1]}`]), m = parseFloat(r[`margin${p[0]}`]), h = parseFloat(r[`margin${p[1]}`]), f = parseFloat(r[`border${p[0]}Width`]), g = parseFloat(r[`border${p[1]}Width`]);
  return { delay: e, duration: n, easing: i, css: (t4) => `overflow: hidden;opacity: ${Math.min(20 * t4, 1) * s};${a}: ${t4 * c}px;padding-${l[0]}: ${t4 * u}px;padding-${l[1]}: ${t4 * d}px;margin-${l[0]}: ${t4 * m}px;margin-${l[1]}: ${t4 * h}px;border-${l[0]}-width: ${t4 * f}px;border-${l[1]}-width: ${t4 * g}px;` };
}
_a = TJSPosition, "undefined" != typeof window && (window.__svelte || (window.__svelte = { v: /* @__PURE__ */ new Set() })).v.add(PUBLIC_VERSION);
const cssVariables = new TJSStyleManager({ docKey: "#__trl-root-styles", version: 1 });
class ResizeObserverManager {
  #te = /* @__PURE__ */ new Map();
  #ee;
  static #ne = Object.freeze({ none: 0, attribute: 1, function: 2, resizeObserved: 3, setContentBounds: 4, setDimension: 5, storeObject: 6, storesObject: 7 });
  constructor() {
    this.#ee = new ResizeObserver((t3) => {
      for (const e of t3) {
        const t4 = this.#te.get(e?.target);
        if (Array.isArray(t4)) {
          const n = e.contentRect.width, i = e.contentRect.height;
          for (const e2 of t4) ResizeObserverManager.#ie(e2, n, i);
        }
      }
    });
  }
  add(t3, e) {
    if (!CrossWindow.isHTMLElement(t3)) throw new TypeError("ResizeObserverManager.add error: 'el' is not a HTMLElement.");
    if (this.#oe(t3, e)) return;
    const n = ResizeObserverManager.#re(e);
    if (0 === n) throw new Error("ResizeObserverManager.add error: 'target' is not a valid ResizeObserverManager target.");
    const i = globalThis.getComputedStyle(t3), o = StyleParse.pixels(t3.style.borderBottom) ?? StyleParse.pixels(i.borderBottom) ?? 0, r = StyleParse.pixels(t3.style.borderLeft) ?? StyleParse.pixels(i.borderLeft) ?? 0, s = StyleParse.pixels(t3.style.borderRight) ?? StyleParse.pixels(i.borderRight) ?? 0, a = StyleParse.pixels(t3.style.borderTop) ?? StyleParse.pixels(i.borderTop) ?? 0, c = StyleParse.pixels(t3.style.paddingBottom) ?? StyleParse.pixels(i.paddingBottom) ?? 0, l = { updateType: n, target: e, contentWidth: 0, contentHeight: 0, styles: { additionalWidth: r + s + (StyleParse.pixels(t3.style.paddingLeft) ?? StyleParse.pixels(i.paddingLeft) ?? 0) + (StyleParse.pixels(t3.style.paddingRight) ?? StyleParse.pixels(i.paddingRight) ?? 0), additionalHeight: a + o + (StyleParse.pixels(t3.style.paddingTop) ?? StyleParse.pixels(i.paddingTop) ?? 0) + c } };
    if (this.#te.has(t3)) {
      this.#te.get(t3).push(l);
    } else this.#te.set(t3, [l]);
    this.#ee.observe(t3);
  }
  clear() {
    for (const t3 of this.#te.keys()) this.#ee.unobserve(t3);
    this.#te.clear();
  }
  remove(t3, e = void 0) {
    const n = this.#te.get(t3);
    if (Array.isArray(n)) {
      if (void 0 !== e) {
        const t4 = n.findIndex((t5) => t5.target === e);
        t4 >= 0 && n.splice(t4, 1);
      } else n.length = 0;
      0 === n.length && (this.#te.delete(t3), this.#ee.unobserve(t3));
    }
  }
  updateCache(t3) {
    const e = this.#te.get(t3);
    if (Array.isArray(e)) {
      const n = globalThis.getComputedStyle(t3), i = StyleParse.pixels(t3.style.borderBottom) ?? StyleParse.pixels(n.borderBottom) ?? 0, o = StyleParse.pixels(t3.style.borderLeft) ?? StyleParse.pixels(n.borderLeft) ?? 0, r = StyleParse.pixels(t3.style.borderRight) ?? StyleParse.pixels(n.borderRight) ?? 0, s = StyleParse.pixels(t3.style.borderTop) ?? StyleParse.pixels(n.borderTop) ?? 0, a = StyleParse.pixels(t3.style.paddingBottom) ?? StyleParse.pixels(n.paddingBottom) ?? 0, c = o + r + (StyleParse.pixels(t3.style.paddingLeft) ?? StyleParse.pixels(n.paddingLeft) ?? 0) + (StyleParse.pixels(t3.style.paddingRight) ?? StyleParse.pixels(n.paddingRight) ?? 0), l = s + i + (StyleParse.pixels(t3.style.paddingTop) ?? StyleParse.pixels(n.paddingTop) ?? 0) + a;
      for (const t4 of e) t4.styles.additionalWidth = c, t4.styles.additionalHeight = l, ResizeObserverManager.#ie(t4, t4.contentWidth, t4.contentHeight);
    }
  }
  static #re(t3) {
    if ("function" == typeof t3?.resizeObserved) return this.#ne.resizeObserved;
    if ("function" == typeof t3?.setDimension) return this.#ne.setDimension;
    if ("function" == typeof t3?.setContentBounds) return this.#ne.setContentBounds;
    const e = typeof t3;
    if (null !== e && ("object" === e || "function" === e)) {
      if (isWritableStore(t3.resizeObserved)) return this.#ne.storeObject;
      const e2 = t3?.stores;
      if ((isObject(e2) || "function" == typeof e2) && isWritableStore(e2.resizeObserved)) return this.#ne.storesObject;
    }
    return null !== e && "object" === e ? this.#ne.attribute : "function" === e ? this.#ne.function : this.#ne.none;
  }
  #oe(t3, e) {
    if (null == e) return false;
    const n = this.#te.get(t3);
    return !!Array.isArray(n) && n.findIndex((t4) => t4.target === e) >= 0;
  }
  static #ie(t3, e, n) {
    const i = t3.styles;
    t3.contentWidth = e, t3.contentHeight = n;
    const o = Number.isFinite(e) ? e + i.additionalWidth : void 0, r = Number.isFinite(n) ? n + i.additionalHeight : void 0, s = t3.target;
    switch (t3.updateType) {
      case this.#ne.attribute:
        s.contentWidth = e, s.contentHeight = n, s.offsetWidth = o, s.offsetHeight = r;
        break;
      case this.#ne.function:
        s?.(o, r, e, n);
        break;
      case this.#ne.resizeObserved:
        s.resizeObserved?.(o, r, e, n);
        break;
      case this.#ne.setContentBounds:
        s.setContentBounds?.(e, n);
        break;
      case this.#ne.setDimension:
        s.setDimension?.(o, r);
        break;
      case this.#ne.storeObject:
        s.resizeObserved.update((t4) => (t4.contentHeight = n, t4.contentWidth = e, t4.offsetHeight = r, t4.offsetWidth = o, t4));
        break;
      case this.#ne.storesObject:
        s.stores.resizeObserved.update((t4) => (t4.contentHeight = n, t4.contentWidth = e, t4.offsetHeight = r, t4.offsetWidth = o, t4));
    }
  }
}
const resizeObserverActionManager = new ResizeObserverManager();
function resizeObserver(t3, e) {
  return resizeObserverActionManager.add(t3, e), { update: (n) => {
    resizeObserverActionManager.remove(t3, e), e = n, resizeObserverActionManager.add(t3, e);
  }, destroy: () => {
    resizeObserverActionManager.remove(t3, e);
  } };
}
function applyStyles(t3, e) {
  function n() {
    if (isObject(e)) for (const n2 of Object.keys(e)) t3.style.setProperty(`${n2}`, e[n2]);
  }
  return n(), { update: (t4) => {
    e = t4, n();
  } };
}
function dynamicAction(t3, { action: e, data: n } = {}) {
  let i;
  return "function" == typeof e && (i = e(t3, n)), { update: (o) => {
    if (!isObject(o)) return i?.destroy?.(), e = void 0, void (n = void 0);
    const { action: r, data: s } = o;
    if ("function" != typeof r) return void console.warn("dynamicAction.update warning: Aborting as 'action' is not a function.");
    const a = s !== n;
    a && (n = s), r !== e ? (i?.destroy?.(), i = (e = r)(t3, n)) : a && i?.update?.(n);
  }, destroy: () => {
    i?.destroy?.(), e = void 0, n = void 0, i = void 0;
  } };
}
resizeObserver.updateCache = function(t3) {
  resizeObserverActionManager.updateCache(t3);
};
class TJSDefaultTransition {
  static #qt = {};
  static #se = () => {
  };
  static get default() {
    return this.#se;
  }
  static get options() {
    return this.#qt;
  }
}
class AppShellContextInternal {
  #l;
  constructor() {
    this.#l = { elementContent: writable(void 0), elementRoot: writable(void 0) }, Object.freeze(this.#l), Object.seal(this);
  }
  get stores() {
    return this.#l;
  }
}
function localize(t3, e) {
  const n = isObject(e) ? globalThis.game.i18n.format(t3, e) : globalThis.game.i18n.localize(t3);
  return void 0 !== n ? n : "";
}
function create_if_block$m(t3) {
  let e, n;
  return { c() {
    e = element("span"), n = text(t3[3]), attr(e, "class", "svelte-mobile-companion-pf2e-v340n8-acci"), toggle_class(e, "has-icon", void 0 !== t3[4]);
  }, m(t4, i) {
    insert(t4, e, i), append(e, n);
  }, p(t4, i) {
    8 & i && set_data(n, t4[3]), 16 & i && toggle_class(e, "has-icon", void 0 !== t4[4]);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_fragment$E(t3) {
  let e, n, i, o, r, s, a, c = t3[3] && create_if_block$m(t3);
  return { c() {
    e = element("a"), n = new HtmlTag(false), i = empty(), c && c.c(), n.a = i, attr(e, "class", o = "header-button " + t3[0].class + " svelte-mobile-companion-pf2e-v340n8-acci"), attr(e, "aria-label", t3[3]), attr(e, "tabindex", "0"), attr(e, "role", "button"), toggle_class(e, "keep-minimized", t3[2]);
  }, m(o2, l) {
    insert(o2, e, l), n.m(t3[4], e), append(e, i), c && c.m(e, null), s || (a = [listen(e, "click", stop_propagation(prevent_default(t3[5]))), listen(e, "contextmenu", stop_propagation(prevent_default(t3[6]))), listen(e, "keydown", t3[7]), listen(e, "keyup", t3[8]), action_destroyer(r = applyStyles.call(null, e, t3[1]))], s = true);
  }, p(t4, [i2]) {
    16 & i2 && n.p(t4[4]), t4[3] ? c ? c.p(t4, i2) : (c = create_if_block$m(t4), c.c(), c.m(e, null)) : c && (c.d(1), c = null), 1 & i2 && o !== (o = "header-button " + t4[0].class + " svelte-mobile-companion-pf2e-v340n8-acci") && attr(e, "class", o), 8 & i2 && attr(e, "aria-label", t4[3]), r && is_function(r.update) && 2 & i2 && r.update.call(null, t4[1]), 5 & i2 && toggle_class(e, "keep-minimized", t4[2]);
  }, i: noop, o: noop, d(t4) {
    t4 && detach(e), c && c.d(), s = false, run_all(a);
  } };
}
const s_REGEX_HTML = /^\s*<.*>$/;
function instance$E(t3, e, n) {
  let i, o, r, s, a, c, { button: l } = e;
  return t3.$$set = (t4) => {
    "button" in t4 && n(0, l = t4.button);
  }, t3.$$.update = () => {
    1 & t3.$$.dirty && n(9, i = isObject(l) && "string" == typeof l.title ? localize(l.title) : ""), 513 & t3.$$.dirty && n(4, o = isObject(l) && "string" != typeof l.icon ? void 0 : s_REGEX_HTML.test(l.icon) ? l.icon : `<i class="${l.icon}" title="${i}"></i>`), 1 & t3.$$.dirty && n(3, r = isObject(l) && "string" == typeof l.label ? localize(l.label) : void 0), 1 & t3.$$.dirty && n(2, s = !(!isObject(l) || "boolean" != typeof l.keepMinimized) && l.keepMinimized), 1 & t3.$$.dirty && (a = isObject(l) && "string" == typeof l.keyCode ? l.keyCode : "Enter"), 1 & t3.$$.dirty && n(1, c = isObject(l) && isObject(l.styles) ? l.styles : void 0);
  }, [l, c, s, r, o, function(t4) {
    const e2 = l?.onPress ?? l?.onclick;
    "function" == typeof e2 && (e2({ button: l, event: t4 }), n(0, l));
  }, function(t4) {
    "function" === l?.onContextMenu && (l.onContextMenu({ button: l, event: t4 }), n(0, l));
  }, function(t4) {
    t4.code === a && (t4.preventDefault(), t4.stopPropagation());
  }, function(t4) {
    if (t4.code === a) {
      const e2 = l.onPress ?? l.onclick;
      "function" == typeof e2 && (e2({ button: l, event: t4 }), n(0, l)), t4.preventDefault(), t4.stopPropagation();
    }
  }, i];
}
class TJSHeaderButton extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$E, create_fragment$E, safe_not_equal, { button: 0 });
  }
  get button() {
    return this.$$.ctx[0];
  }
  set button(t3) {
    this.$$set({ button: t3 }), flush();
  }
}
function get_each_context$d(t3, e, n) {
  const i = t3.slice();
  return i[31] = e[n], i;
}
function get_each_context_1$6(t3, e, n) {
  const i = t3.slice();
  return i[31] = e[n], i;
}
function create_if_block$l(t3) {
  let e, n;
  return { c() {
    e = element("img"), attr(e, "class", "tjs-app-icon keep-minimized svelte-mobile-companion-pf2e-v340n8-5lh4qo"), src_url_equal(e.src, n = t3[6]) || attr(e, "src", n), attr(e, "alt", "icon");
  }, m(t4, n2) {
    insert(t4, e, n2);
  }, p(t4, i) {
    64 & i[0] && !src_url_equal(e.src, n = t4[6]) && attr(e, "src", n);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_each_block_1$6(t3) {
  let e, n, i;
  const o = [t3[31].props];
  var r = t3[31].class;
  function s(t4, e2) {
    let n2 = {};
    for (let t5 = 0; t5 < o.length; t5 += 1) n2 = assign(n2, o[t5]);
    return void 0 !== e2 && 2 & e2[0] && (n2 = assign(n2, get_spread_update(o, [get_spread_object(t4[31].props)]))), { props: n2 };
  }
  return r && (e = construct_svelte_component(r, s(t3))), { c() {
    e && create_component(e.$$.fragment), n = empty();
  }, m(t4, o2) {
    e && mount_component(e, t4, o2), insert(t4, n, o2), i = true;
  }, p(t4, i2) {
    if (2 & i2[0] && r !== (r = t4[31].class)) {
      if (e) {
        group_outros();
        const t5 = e;
        transition_out(t5.$$.fragment, 1, 0, () => {
          destroy_component(t5, 1);
        }), check_outros();
      }
      r ? (e = construct_svelte_component(r, s(t4, i2)), create_component(e.$$.fragment), transition_in(e.$$.fragment, 1), mount_component(e, n.parentNode, n)) : e = null;
    } else if (r) {
      const n2 = 2 & i2[0] ? get_spread_update(o, [get_spread_object(t4[31].props)]) : {};
      e.$set(n2);
    }
  }, i(t4) {
    i || (e && transition_in(e.$$.fragment, t4), i = true);
  }, o(t4) {
    e && transition_out(e.$$.fragment, t4), i = false;
  }, d(t4) {
    t4 && detach(n), e && destroy_component(e, t4);
  } };
}
function create_each_block$d(t3) {
  let e, n, i;
  const o = [t3[31].props];
  var r = t3[31].class;
  function s(t4, e2) {
    let n2 = {};
    for (let t5 = 0; t5 < o.length; t5 += 1) n2 = assign(n2, o[t5]);
    return void 0 !== e2 && 4 & e2[0] && (n2 = assign(n2, get_spread_update(o, [get_spread_object(t4[31].props)]))), { props: n2 };
  }
  return r && (e = construct_svelte_component(r, s(t3))), { c() {
    e && create_component(e.$$.fragment), n = empty();
  }, m(t4, o2) {
    e && mount_component(e, t4, o2), insert(t4, n, o2), i = true;
  }, p(t4, i2) {
    if (4 & i2[0] && r !== (r = t4[31].class)) {
      if (e) {
        group_outros();
        const t5 = e;
        transition_out(t5.$$.fragment, 1, 0, () => {
          destroy_component(t5, 1);
        }), check_outros();
      }
      r ? (e = construct_svelte_component(r, s(t4, i2)), create_component(e.$$.fragment), transition_in(e.$$.fragment, 1), mount_component(e, n.parentNode, n)) : e = null;
    } else if (r) {
      const n2 = 4 & i2[0] ? get_spread_update(o, [get_spread_object(t4[31].props)]) : {};
      e.$set(n2);
    }
  }, i(t4) {
    i || (e && transition_in(e.$$.fragment, t4), i = true);
  }, o(t4) {
    e && transition_out(e.$$.fragment, t4), i = false;
  }, d(t4) {
    t4 && detach(n), e && destroy_component(e, t4);
  } };
}
function create_key_block$2(t3) {
  let e, n, i, o, r, s, a, c, l, p, u, d, m, h = localize(t3[7]) + "", f = "string" == typeof t3[6] && create_if_block$l(t3), g = ensure_array_like(t3[1]), _ = [];
  for (let e2 = 0; e2 < g.length; e2 += 1) _[e2] = create_each_block_1$6(get_each_context_1$6(t3, g, e2));
  const b = (t4) => transition_out(_[t4], 1, 1, () => {
    _[t4] = null;
  });
  let y = ensure_array_like(t3[2]), v = [];
  for (let e2 = 0; e2 < y.length; e2 += 1) v[e2] = create_each_block$d(get_each_context$d(t3, y, e2));
  const $2 = (t4) => transition_out(v[t4], 1, 1, () => {
    v[t4] = null;
  });
  return { c() {
    e = element("header"), f && f.c(), n = space(), i = element("h4"), o = text(h), r = space();
    for (let t4 = 0; t4 < _.length; t4 += 1) _[t4].c();
    s = space(), a = element("span"), c = space();
    for (let t4 = 0; t4 < v.length; t4 += 1) v[t4].c();
    attr(i, "class", "window-title svelte-mobile-companion-pf2e-v340n8-5lh4qo"), set_style(i, "display", t3[4]), attr(a, "class", "tjs-window-header-spacer keep-minimized svelte-mobile-companion-pf2e-v340n8-5lh4qo"), attr(e, "class", "window-header flexrow svelte-mobile-companion-pf2e-v340n8-5lh4qo");
  }, m(h2, g2) {
    insert(h2, e, g2), f && f.m(e, null), append(e, n), append(e, i), append(i, o), append(e, r);
    for (let t4 = 0; t4 < _.length; t4 += 1) _[t4] && _[t4].m(e, null);
    append(e, s), append(e, a), append(e, c);
    for (let t4 = 0; t4 < v.length; t4 += 1) v[t4] && v[t4].m(e, null);
    u = true, d || (m = [listen(e, "pointerdown", t3[19]), action_destroyer(l = t3[0].call(null, e, t3[3])), action_destroyer(p = t3[18].call(null, e, t3[5]))], d = true);
  }, p(t4, r2) {
    if ("string" == typeof t4[6] ? f ? f.p(t4, r2) : (f = create_if_block$l(t4), f.c(), f.m(e, n)) : f && (f.d(1), f = null), (!u || 128 & r2[0]) && h !== (h = localize(t4[7]) + "") && set_data(o, h), 16 & r2[0] && set_style(i, "display", t4[4]), 2 & r2[0]) {
      let n2;
      for (g = ensure_array_like(t4[1]), n2 = 0; n2 < g.length; n2 += 1) {
        const i2 = get_each_context_1$6(t4, g, n2);
        _[n2] ? (_[n2].p(i2, r2), transition_in(_[n2], 1)) : (_[n2] = create_each_block_1$6(i2), _[n2].c(), transition_in(_[n2], 1), _[n2].m(e, s));
      }
      for (group_outros(), n2 = g.length; n2 < _.length; n2 += 1) b(n2);
      check_outros();
    }
    if (4 & r2[0]) {
      let n2;
      for (y = ensure_array_like(t4[2]), n2 = 0; n2 < y.length; n2 += 1) {
        const i2 = get_each_context$d(t4, y, n2);
        v[n2] ? (v[n2].p(i2, r2), transition_in(v[n2], 1)) : (v[n2] = create_each_block$d(i2), v[n2].c(), transition_in(v[n2], 1), v[n2].m(e, null));
      }
      for (group_outros(), n2 = y.length; n2 < v.length; n2 += 1) $2(n2);
      check_outros();
    }
    l && is_function(l.update) && 8 & r2[0] && l.update.call(null, t4[3]), p && is_function(p.update) && 32 & r2[0] && p.update.call(null, t4[5]);
  }, i(t4) {
    if (!u) {
      for (let t5 = 0; t5 < g.length; t5 += 1) transition_in(_[t5]);
      for (let t5 = 0; t5 < y.length; t5 += 1) transition_in(v[t5]);
      u = true;
    }
  }, o(t4) {
    _ = _.filter(Boolean);
    for (let t5 = 0; t5 < _.length; t5 += 1) transition_out(_[t5]);
    v = v.filter(Boolean);
    for (let t5 = 0; t5 < v.length; t5 += 1) transition_out(v[t5]);
    u = false;
  }, d(t4) {
    t4 && detach(e), f && f.d(), destroy_each(_, t4), destroy_each(v, t4), d = false, run_all(m);
  } };
}
function create_fragment$D(t3) {
  let e, n, i = t3[0], o = create_key_block$2(t3);
  return { c() {
    o.c(), e = empty();
  }, m(t4, i2) {
    o.m(t4, i2), insert(t4, e, i2), n = true;
  }, p(t4, n2) {
    1 & n2[0] && safe_not_equal(i, i = t4[0]) ? (group_outros(), transition_out(o, 1, 1, noop), check_outros(), o = create_key_block$2(t4), o.c(), transition_in(o, 1), o.m(e.parentNode, e)) : o.p(t4, n2);
  }, i(t4) {
    n || (transition_in(o), n = true);
  }, o(t4) {
    transition_out(o), n = false;
  }, d(t4) {
    t4 && detach(e), o.d(t4);
  } };
}
function instance$D(t3, e, n) {
  let i, o, r, s, a, c, l, p, u, d, { draggable: m } = e, { draggableOptions: h } = e;
  const f = getContext("#external")?.application, { focusAuto: g, focusKeep: _ } = f.reactive.storeAppOptions;
  component_subscribe(t3, g, (t4) => n(26, o = t4)), component_subscribe(t3, _, (t4) => n(25, i = t4));
  const { elementRoot: b } = getContext("#internal").stores;
  component_subscribe(t3, b, (t4) => n(27, r = t4));
  const y = f.reactive.storeAppOptions.title;
  component_subscribe(t3, y, (t4) => n(7, d = t4));
  const v = f.reactive.storeAppOptions.draggable;
  component_subscribe(t3, v, (t4) => n(24, l = t4));
  const $2 = f.reactive.storeUIState.dragging, T = f.reactive.storeUIState.headerButtons;
  component_subscribe(t3, T, (t4) => n(21, s = t4));
  const w = f.reactive.storeAppOptions.headerIcon;
  component_subscribe(t3, w, (t4) => n(6, u = t4));
  const S = f.reactive.storeAppOptions.headerNoTitleMinimized;
  component_subscribe(t3, S, (t4) => n(23, c = t4));
  const k = f.reactive.storeAppOptions.minimizable;
  component_subscribe(t3, k, (t4) => n(5, p = t4));
  const O = f.reactive.storeUIState.minimized;
  component_subscribe(t3, O, (t4) => n(22, a = t4));
  const x = Object.freeze(["tjs-app-icon", "tjs-window-header-spacer", "window-header", "window-title"]);
  let E, M, A, C;
  return t3.$$set = (t4) => {
    "draggable" in t4 && n(0, m = t4.draggable), "draggableOptions" in t4 && n(20, h = t4.draggableOptions);
  }, t3.$$.update = () => {
    if (1 & t3.$$.dirty[0] && n(0, m = "function" == typeof m ? m : draggable), 17825792 & t3.$$.dirty[0] && n(3, E = Object.assign({}, { tween: true, tweenOptions: { duration: 0.06, ease: "cubicOut" } }, isObject(h) ? h : {}, { position: f.position, enabled: l, storeDragging: $2, hasTargetClassList: x })), 12582912 & t3.$$.dirty[0] && n(4, M = c && a ? "none" : null), 2097158 & t3.$$.dirty[0]) {
      n(1, A = []), n(2, C = []);
      for (const t4 of s) {
        ("boolean" == typeof t4?.alignLeft && t4?.alignLeft ? A : C).push(TJSSvelte.config.isConfigEmbed(t4?.svelte) ? { ...t4.svelte } : { class: TJSHeaderButton, props: { button: t4 } });
      }
    }
  }, [m, A, C, E, M, p, u, d, g, _, b, y, v, T, w, S, k, O, function(t4, e2) {
    const n2 = (t5) => {
      (t5.target.classList.contains("window-title") || t5.target.classList.contains("window-header") || t5.target.classList.contains("keep-minimized")) && f._onToggleMinimize(t5);
    };
    function i2() {
      t4.addEventListener("dblclick", n2);
    }
    function o2() {
      t4.removeEventListener("dblclick", n2);
    }
    return e2 && i2(), { update: (t5) => {
      t5 ? i2() : o2();
    }, destroy: () => o2() };
  }, function(t4) {
    const e2 = r;
    if (f.position.animate.cancel(), o && A11yHelper.isFocusTarget(e2) && e2?.isConnected) if (i) {
      const n2 = f.reactive.activeWindow;
      A11yHelper.isFocusTarget(n2.document.activeElement) && !e2.contains(n2.document.activeElement) ? e2.focus() : t4.preventDefault();
    } else e2.focus();
  }, h, s, a, c, l];
}
class TJSApplicationHeader extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$D, create_fragment$D, safe_not_equal, { draggable: 0, draggableOptions: 20 }, null, [-1, -1]);
  }
}
class ResizeHandleTransform {
  static #ae = new Mat4();
  static #ce = new Vec3();
  static #le = new Vec3();
  static #pe = new Vec3();
  static #ue = new Vec3();
  static #de = new Vec3();
  static computeDelta(t3, e, n, i, o) {
    return Mat4.invert(this.#ae, t3), this.#ue[0] = e, this.#ue[1] = n, this.#de[0] = i, this.#de[1] = o, Vec3.transformMat4(this.#le, this.#ue, this.#ae), Vec3.transformMat4(this.#pe, this.#de, this.#ae), this.#ce[0] = this.#pe[0] - this.#le[0], this.#ce[1] = this.#pe[1] - this.#le[1], this.#ce;
  }
}
function create_fragment$C(t3) {
  let e, n, i, o;
  return { c() {
    e = element("div"), e.innerHTML = '<i class="fas fa-arrows-alt-h svelte-mobile-companion-pf2e-v340n8-gtiiil"></i>', attr(e, "class", "window-resizable-handle svelte-mobile-companion-pf2e-v340n8-gtiiil");
  }, m(r, s) {
    insert(r, e, s), t3[11](e), i || (o = [listen(e, "pointerdown", t3[6]), action_destroyer(n = t3[7].call(null, e, { active: t3[1], storeResizing: t3[5] }))], i = true);
  }, p(t4, [e2]) {
    n && is_function(n.update) && 2 & e2 && n.update.call(null, { active: t4[1], storeResizing: t4[5] });
  }, i: noop, o: noop, d(n2) {
    n2 && detach(e), t3[11](null), i = false, run_all(o);
  } };
}
function instance$C(t3, e, n) {
  let i, o, r, { isResizable: s = false } = e;
  const a = getContext("#external")?.application, c = getContext("#internal").stores.elementRoot;
  component_subscribe(t3, c, (t4) => n(9, i = t4));
  const l = a.reactive.storeAppOptions.resizable;
  component_subscribe(t3, l, (t4) => n(1, r = t4));
  const p = a.reactive.storeUIState.minimized;
  component_subscribe(t3, p, (t4) => n(10, o = t4));
  const u = a.reactive.storeUIState.resizing;
  let d;
  return t3.$$set = (t4) => {
    "isResizable" in t4 && n(8, s = t4.isResizable);
  }, t3.$$.update = () => {
    if (1793 & t3.$$.dirty && d) {
      n(0, d.style.display = s && !o ? "block" : "none", d);
      i && i.classList[s ? "add" : "remove"]("resizable");
    }
  }, [d, r, c, l, p, u, function() {
    a.position.animate.cancel();
  }, function(t4, { active: e2 = true, storeResizing: o2 } = {}) {
    let r2 = null, c2 = false, l2 = 0, p2 = 0;
    const u2 = { resizeDown: ["pointerdown", (e3) => function(e4) {
      e4.preventDefault(), c2 = false, r2 = a.position.get(), "auto" === r2.height && (r2.height = i.clientHeight);
      "auto" === r2.width && (r2.width = i.clientWidth);
      l2 = e4.clientX, p2 = e4.clientY, t4.addEventListener(...u2.resizeMove), t4.addEventListener(...u2.resizeUp), t4.setPointerCapture(e4.pointerId);
    }(e3), false], resizeMove: ["pointermove", (t5) => function(t6) {
      t6.preventDefault(), c2 || "function" != typeof o2?.set || (c2 = true, o2.set(true));
      const e3 = ResizeHandleTransform.computeDelta(a.position.transform.mat4, l2, p2, t6.clientX, t6.clientY);
      a.position.set({ width: r2.width + e3[0], height: r2.height + e3[1] });
    }(t5), false], resizeUp: ["pointerup", (e3) => function(e4) {
      c2 = false, "function" == typeof o2?.set && o2.set(false);
      e4.preventDefault(), t4.removeEventListener(...u2.resizeMove), t4.removeEventListener(...u2.resizeUp), a?._onResize?.(e4);
    }(e3), false] };
    function d2() {
      t4.addEventListener(...u2.resizeDown), n(8, s = true), t4.style.display = "block";
    }
    function m() {
      "function" == typeof o2?.set && o2.set(false), t4.removeEventListener(...u2.resizeDown), t4.removeEventListener(...u2.resizeMove), t4.removeEventListener(...u2.resizeUp), t4.style.display = "none", n(8, s = false);
    }
    return e2 ? d2() : t4.style.display = "none", { update: ({ active: t5 }) => {
      t5 ? d2() : m();
    }, destroy: () => m() };
  }, s, i, o, function(t4) {
    binding_callbacks[t4 ? "unshift" : "push"](() => {
      d = t4, n(0, d), n(8, s), n(10, o), n(9, i);
    });
  }];
}
class ResizableHandle extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$C, create_fragment$C, safe_not_equal, { isResizable: 8 });
  }
}
function create_fragment$B(t3) {
  let e, n, i;
  return { c() {
    e = element("div"), attr(e, "class", "tjs-focus-wrap svelte-mobile-companion-pf2e-v340n8-kjcljd"), attr(e, "tabindex", "0");
  }, m(o, r) {
    insert(o, e, r), t3[4](e), n || (i = listen(e, "focus", t3[1]), n = true);
  }, p: noop, i: noop, o: noop, d(o) {
    o && detach(e), t3[4](null), n = false, i();
  } };
}
function instance$B(t3, e, n) {
  let i, o, { elementRoot: r } = e, { enabled: s = true } = e;
  return t3.$$set = (t4) => {
    "elementRoot" in t4 && n(2, r = t4.elementRoot), "enabled" in t4 && n(3, s = t4.enabled);
  }, t3.$$.update = () => {
    1 & t3.$$.dirty && o && (i = /* @__PURE__ */ new Set([o]));
  }, [o, function() {
    if (s && A11yHelper.isFocusTarget(r)) {
      const t4 = A11yHelper.getFirstFocusableElement(r, i);
      A11yHelper.isFocusTarget(t4) && t4 !== o ? t4.focus() : r.focus();
    }
  }, r, s, function(t4) {
    binding_callbacks[t4 ? "unshift" : "push"](() => {
      o = t4, n(0, o);
    });
  }];
}
class TJSFocusWrap extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$B, create_fragment$B, safe_not_equal, { elementRoot: 2, enabled: 3 });
  }
}
function create_else_block$6(t3) {
  let e, n, i, o, r, s, a, c, l, p, u, d, m, h, f, g, _;
  n = new TJSApplicationHeader({ props: { draggable: t3[6], draggableOptions: t3[7] } });
  const b = t3[37].default, y = create_slot(b, t3, t3[36], null);
  return a = new ResizableHandle({}), l = new TJSFocusWrap({ props: { elementRoot: t3[1], enabled: t3[11] } }), { c() {
    e = element("div"), create_component(n.$$.fragment), i = space(), o = element("section"), y && y.c(), s = space(), create_component(a.$$.fragment), c = space(), create_component(l.$$.fragment), attr(o, "class", "window-content svelte-mobile-companion-pf2e-v340n8-90z1oq"), attr(o, "tabindex", "-1"), attr(e, "id", p = t3[10].id), attr(e, "class", u = "app window-app " + t3[10].options.classes.join(" ") + " svelte-mobile-companion-pf2e-v340n8-90z1oq"), attr(e, "data-appid", d = t3[10].appId), attr(e, "role", "application"), attr(e, "tabindex", "-1");
  }, m(p2, u2) {
    insert(p2, e, u2), mount_component(n, e, null), append(e, i), append(e, o), y && y.m(o, null), t3[40](o), append(e, s), mount_component(a, e, null), append(e, c), mount_component(l, e, null), t3[41](e), f = true, g || (_ = [listen(o, "pointerdown", t3[22]), action_destroyer(r = applyStyles.call(null, o, t3[9])), action_destroyer(t3[18].call(null, o, t3[23])), listen(e, "close:popup", stop_propagation(prevent_default(t3[19]))), listen(e, "keydown", t3[20]), listen(e, "pointerdown", t3[21], true), action_destroyer(m = applyStyles.call(null, e, t3[8])), action_destroyer(h = dynamicAction.call(null, e, t3[12]))], g = true);
  }, p(t4, i2) {
    const o2 = {};
    64 & i2[0] && (o2.draggable = t4[6]), 128 & i2[0] && (o2.draggableOptions = t4[7]), n.$set(o2), y && y.p && (!f || 32 & i2[1]) && update_slot_base(y, b, t4, t4[36], f ? get_slot_changes(b, t4[36], i2, null) : get_all_dirty_from_scope(t4[36]), null), r && is_function(r.update) && 512 & i2[0] && r.update.call(null, t4[9]);
    const s2 = {};
    2 & i2[0] && (s2.elementRoot = t4[1]), 2048 & i2[0] && (s2.enabled = t4[11]), l.$set(s2), (!f || 1024 & i2[0] && p !== (p = t4[10].id)) && attr(e, "id", p), (!f || 1024 & i2[0] && u !== (u = "app window-app " + t4[10].options.classes.join(" ") + " svelte-mobile-companion-pf2e-v340n8-90z1oq")) && attr(e, "class", u), (!f || 1024 & i2[0] && d !== (d = t4[10].appId)) && attr(e, "data-appid", d), m && is_function(m.update) && 256 & i2[0] && m.update.call(null, t4[8]), h && is_function(h.update) && 4096 & i2[0] && h.update.call(null, t4[12]);
  }, i(t4) {
    f || (transition_in(n.$$.fragment, t4), transition_in(y, t4), transition_in(a.$$.fragment, t4), transition_in(l.$$.fragment, t4), f = true);
  }, o(t4) {
    transition_out(n.$$.fragment, t4), transition_out(y, t4), transition_out(a.$$.fragment, t4), transition_out(l.$$.fragment, t4), f = false;
  }, d(i2) {
    i2 && detach(e), destroy_component(n), y && y.d(i2), t3[40](null), destroy_component(a), destroy_component(l), t3[41](null), g = false, run_all(_);
  } };
}
function create_if_block$k(t3) {
  let e, n, i, o, r, s, a, c, l, p, u, d, m, h, f, g, _, b, y;
  n = new TJSApplicationHeader({ props: { draggable: t3[6], draggableOptions: t3[7] } });
  const v = t3[37].default, $2 = create_slot(v, t3, t3[36], null);
  return a = new ResizableHandle({}), l = new TJSFocusWrap({ props: { elementRoot: t3[1] } }), { c() {
    e = element("div"), create_component(n.$$.fragment), i = space(), o = element("section"), $2 && $2.c(), s = space(), create_component(a.$$.fragment), c = space(), create_component(l.$$.fragment), attr(o, "class", "window-content svelte-mobile-companion-pf2e-v340n8-90z1oq"), attr(o, "tabindex", "-1"), attr(e, "id", p = t3[10].id), attr(e, "class", u = "app window-app " + t3[10].options.classes.join(" ") + " svelte-mobile-companion-pf2e-v340n8-90z1oq"), attr(e, "data-appid", d = t3[10].appId), attr(e, "role", "application"), attr(e, "tabindex", "-1");
  }, m(p2, u2) {
    insert(p2, e, u2), mount_component(n, e, null), append(e, i), append(e, o), $2 && $2.m(o, null), t3[38](o), append(e, s), mount_component(a, e, null), append(e, c), mount_component(l, e, null), t3[39](e), _ = true, b || (y = [listen(o, "pointerdown", t3[22]), action_destroyer(r = applyStyles.call(null, o, t3[9])), action_destroyer(t3[18].call(null, o, t3[23])), listen(e, "close:popup", stop_propagation(prevent_default(t3[19]))), listen(e, "keydown", t3[20]), listen(e, "pointerdown", t3[21], true), action_destroyer(m = applyStyles.call(null, e, t3[8])), action_destroyer(h = dynamicAction.call(null, e, t3[12]))], b = true);
  }, p(i2, o2) {
    t3 = i2;
    const s2 = {};
    64 & o2[0] && (s2.draggable = t3[6]), 128 & o2[0] && (s2.draggableOptions = t3[7]), n.$set(s2), $2 && $2.p && (!_ || 32 & o2[1]) && update_slot_base($2, v, t3, t3[36], _ ? get_slot_changes(v, t3[36], o2, null) : get_all_dirty_from_scope(t3[36]), null), r && is_function(r.update) && 512 & o2[0] && r.update.call(null, t3[9]);
    const a2 = {};
    2 & o2[0] && (a2.elementRoot = t3[1]), l.$set(a2), (!_ || 1024 & o2[0] && p !== (p = t3[10].id)) && attr(e, "id", p), (!_ || 1024 & o2[0] && u !== (u = "app window-app " + t3[10].options.classes.join(" ") + " svelte-mobile-companion-pf2e-v340n8-90z1oq")) && attr(e, "class", u), (!_ || 1024 & o2[0] && d !== (d = t3[10].appId)) && attr(e, "data-appid", d), m && is_function(m.update) && 256 & o2[0] && m.update.call(null, t3[8]), h && is_function(h.update) && 4096 & o2[0] && h.update.call(null, t3[12]);
  }, i(i2) {
    _ || (transition_in(n.$$.fragment, i2), transition_in($2, i2), transition_in(a.$$.fragment, i2), transition_in(l.$$.fragment, i2), add_render_callback(() => {
      _ && (g && g.end(1), f = create_in_transition(e, t3[2], t3[4]), f.start());
    }), _ = true);
  }, o(i2) {
    transition_out(n.$$.fragment, i2), transition_out($2, i2), transition_out(a.$$.fragment, i2), transition_out(l.$$.fragment, i2), f && f.invalidate(), g = create_out_transition(e, t3[3], t3[5]), _ = false;
  }, d(i2) {
    i2 && detach(e), destroy_component(n), $2 && $2.d(i2), t3[38](null), destroy_component(a), destroy_component(l), t3[39](null), i2 && g && g.end(), b = false, run_all(y);
  } };
}
function create_fragment$A(t3) {
  let e, n, i, o;
  const r = [create_if_block$k, create_else_block$6], s = [];
  function a(t4, e2) {
    return t4[2] !== TJSDefaultTransition.default || t4[3] !== TJSDefaultTransition.default ? 0 : 1;
  }
  return e = a(t3), n = s[e] = r[e](t3), { c() {
    n.c(), i = empty();
  }, m(t4, n2) {
    s[e].m(t4, n2), insert(t4, i, n2), o = true;
  }, p(t4, o2) {
    let c = e;
    e = a(t4), e === c ? s[e].p(t4, o2) : (group_outros(), transition_out(s[c], 1, 1, () => {
      s[c] = null;
    }), check_outros(), n = s[e], n ? n.p(t4, o2) : (n = s[e] = r[e](t4), n.c()), transition_in(n, 1), n.m(i.parentNode, i));
  }, i(t4) {
    o || (transition_in(n), o = true);
  }, o(t4) {
    transition_out(n), o = false;
  }, d(t4) {
    t4 && detach(i), s[e].d(t4);
  } };
}
function instance$A(t3, e, n) {
  let i, o, r, s, a, c, { $$slots: l = {}, $$scope: p } = e, { elementContent: u } = e, { elementRoot: d } = e, { draggable: m } = e, { draggableOptions: h } = e, { stylesApp: f } = e, { stylesContent: g } = e;
  const _ = getContext("#external")?.application, { focusAuto: b, focusKeep: y, focusTrap: v } = _.reactive.storeAppOptions;
  component_subscribe(t3, b, (t4) => n(32, r = t4)), component_subscribe(t3, y, (t4) => n(42, o = t4)), component_subscribe(t3, v, (t4) => n(34, a = t4));
  const { minimized: $2 } = _.reactive.storeUIState;
  component_subscribe(t3, $2, (t4) => n(33, s = t4));
  const { resizeObservable: T } = _.position.stores;
  component_subscribe(t3, T, (t4) => n(35, c = t4));
  let { appOffsetHeight: w = false } = e, { appOffsetWidth: S = false } = e;
  const k = !!w || !!S;
  let { contentOffsetHeight: O = false } = e, { contentOffsetWidth: x = false } = e;
  const E = O || x ? resizeObserver : () => null, M = new AppShellContextInternal(), A = { ignoreClasses: ["tjs-focus-wrap"] };
  let C;
  setContext("#internal", M);
  let I, { transition: P = TJSDefaultTransition.default } = e, { inTransition: D = TJSDefaultTransition.default } = e, { outTransition: N = TJSDefaultTransition.default } = e, { transitionOptions: j } = e, { inTransitionOptions: L = TJSDefaultTransition.options } = e, { outTransitionOptions: F = TJSDefaultTransition.options } = e, z = TJSDefaultTransition.default;
  function R(t4, e2, i2, o2) {
    _.position.stores.resizeObserved.update((n2) => (n2.contentWidth = i2, n2.contentHeight = o2, n2.offsetWidth = t4, n2.offsetHeight = e2, n2)), n(24, w = e2), n(25, S = t4);
  }
  return onMount(() => d.focus()), t3.$$set = (t4) => {
    "elementContent" in t4 && n(0, u = t4.elementContent), "elementRoot" in t4 && n(1, d = t4.elementRoot), "draggable" in t4 && n(6, m = t4.draggable), "draggableOptions" in t4 && n(7, h = t4.draggableOptions), "stylesApp" in t4 && n(8, f = t4.stylesApp), "stylesContent" in t4 && n(9, g = t4.stylesContent), "appOffsetHeight" in t4 && n(24, w = t4.appOffsetHeight), "appOffsetWidth" in t4 && n(25, S = t4.appOffsetWidth), "contentOffsetHeight" in t4 && n(26, O = t4.contentOffsetHeight), "contentOffsetWidth" in t4 && n(27, x = t4.contentOffsetWidth), "transition" in t4 && n(28, P = t4.transition), "inTransition" in t4 && n(2, D = t4.inTransition), "outTransition" in t4 && n(3, N = t4.outTransition), "transitionOptions" in t4 && n(29, j = t4.transitionOptions), "inTransitionOptions" in t4 && n(4, L = t4.inTransitionOptions), "outTransitionOptions" in t4 && n(5, F = t4.outTransitionOptions), "$$scope" in t4 && n(36, p = t4.$$scope);
  }, t3.$$.update = () => {
    if (16 & t3.$$.dirty[1] && n(12, i = k || c ? { action: resizeObserver, data: R } : void 0), 1 & t3.$$.dirty[0] && null != u && getContext("#internal").stores.elementContent.set(u), 2 & t3.$$.dirty[0] && null != d && getContext("#internal").stores.elementRoot.set(d), 14 & t3.$$.dirty[1] && n(11, C = r && a && !s), 1342177280 & t3.$$.dirty[0] && z !== P) {
      const t4 = "function" == typeof P ? P : TJSDefaultTransition.default;
      n(2, D = t4), n(3, N = t4), n(30, z = t4);
    }
    if (536870912 & t3.$$.dirty[0] | 1 & t3.$$.dirty[1] && I !== j) {
      const t4 = j !== TJSDefaultTransition.options && isObject(j) ? j : TJSDefaultTransition.options;
      n(4, L = t4), n(5, F = t4), n(31, I = t4);
    }
    if (4 & t3.$$.dirty[0] && "function" != typeof D && n(2, D = TJSDefaultTransition.default), 1032 & t3.$$.dirty[0]) {
      "function" != typeof N && n(3, N = TJSDefaultTransition.default);
      const t4 = _?.options?.defaultCloseAnimation;
      "boolean" == typeof t4 && t4 && N !== TJSDefaultTransition.default && n(10, _.options.defaultCloseAnimation = false, _);
    }
    16 & t3.$$.dirty[0] && (isObject(L) || n(4, L = TJSDefaultTransition.options)), 32 & t3.$$.dirty[0] && (isObject(F) || n(5, F = TJSDefaultTransition.options));
  }, [u, d, D, N, L, F, m, h, f, g, _, C, i, b, y, v, $2, T, E, function(t4) {
    if (!r) return;
    const e2 = t4?.detail?.target;
    if (!A11yHelper.isFocusTarget(e2)) return;
    if (A11yHelper.isFocusable(e2)) return;
    const n2 = d.contains(e2);
    e2 === d ? d.focus() : e2 === u ? u.focus() : n2 && (u.contains(e2) ? u.focus() : d.focus());
  }, function(t4) {
    if (t4.target !== d && t4.target !== u || !KeyboardManager || !KeyboardManager?._getMatchingActions?.(KeyboardManager?.getKeyboardEventContext?.(t4))?.length) {
      if (C && t4.shiftKey && "Tab" === t4.code) {
        const e2 = A11yHelper.getFocusableElements(d, A), n2 = e2.length > 0 ? e2[0] : void 0, i2 = e2.length > 0 ? e2[e2.length - 1] : void 0, o2 = _.reactive.activeWindow;
        d !== o2.document.activeElement && n2 !== o2.document.activeElement || (A11yHelper.isFocusTarget(i2) && n2 !== i2 && i2.focus(), t4.preventDefault(), t4.stopPropagation());
      }
      "boolean" == typeof _?.options?.popOut && _.options.popOut && _ !== globalThis.ui?.activeWindow && _.bringToTop.call(_);
    } else t4.target?.blur();
  }, function() {
    "boolean" == typeof _?.options?.popOut && _.options.popOut && _ !== globalThis.ui?.activeWindow && _.bringToTop.call(_);
  }, function(t4) {
    if (!A11yHelper.isFocusable(t4.target) && r) if (o) {
      const e2 = _.reactive.activeWindow;
      !d.contains(e2.document.activeElement) ? u.focus() : t4.preventDefault();
    } else u.focus();
  }, function(t4, e2) {
    n(27, x = t4), n(26, O = e2);
  }, w, S, O, x, P, j, z, I, r, s, a, c, p, l, function(t4) {
    binding_callbacks[t4 ? "unshift" : "push"](() => {
      u = t4, n(0, u);
    });
  }, function(t4) {
    binding_callbacks[t4 ? "unshift" : "push"](() => {
      d = t4, n(1, d);
    });
  }, function(t4) {
    binding_callbacks[t4 ? "unshift" : "push"](() => {
      u = t4, n(0, u);
    });
  }, function(t4) {
    binding_callbacks[t4 ? "unshift" : "push"](() => {
      d = t4, n(1, d);
    });
  }];
}
class ApplicationShell extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$A, create_fragment$A, safe_not_equal, { elementContent: 0, elementRoot: 1, draggable: 6, draggableOptions: 7, stylesApp: 8, stylesContent: 9, appOffsetHeight: 24, appOffsetWidth: 25, contentOffsetHeight: 26, contentOffsetWidth: 27, transition: 28, inTransition: 2, outTransition: 3, transitionOptions: 29, inTransitionOptions: 4, outTransitionOptions: 5 }, null, [-1, -1]);
  }
  get elementContent() {
    return this.$$.ctx[0];
  }
  set elementContent(t3) {
    this.$$set({ elementContent: t3 }), flush();
  }
  get elementRoot() {
    return this.$$.ctx[1];
  }
  set elementRoot(t3) {
    this.$$set({ elementRoot: t3 }), flush();
  }
  get draggable() {
    return this.$$.ctx[6];
  }
  set draggable(t3) {
    this.$$set({ draggable: t3 }), flush();
  }
  get draggableOptions() {
    return this.$$.ctx[7];
  }
  set draggableOptions(t3) {
    this.$$set({ draggableOptions: t3 }), flush();
  }
  get stylesApp() {
    return this.$$.ctx[8];
  }
  set stylesApp(t3) {
    this.$$set({ stylesApp: t3 }), flush();
  }
  get stylesContent() {
    return this.$$.ctx[9];
  }
  set stylesContent(t3) {
    this.$$set({ stylesContent: t3 }), flush();
  }
  get appOffsetHeight() {
    return this.$$.ctx[24];
  }
  set appOffsetHeight(t3) {
    this.$$set({ appOffsetHeight: t3 }), flush();
  }
  get appOffsetWidth() {
    return this.$$.ctx[25];
  }
  set appOffsetWidth(t3) {
    this.$$set({ appOffsetWidth: t3 }), flush();
  }
  get contentOffsetHeight() {
    return this.$$.ctx[26];
  }
  set contentOffsetHeight(t3) {
    this.$$set({ contentOffsetHeight: t3 }), flush();
  }
  get contentOffsetWidth() {
    return this.$$.ctx[27];
  }
  set contentOffsetWidth(t3) {
    this.$$set({ contentOffsetWidth: t3 }), flush();
  }
  get transition() {
    return this.$$.ctx[28];
  }
  set transition(t3) {
    this.$$set({ transition: t3 }), flush();
  }
  get inTransition() {
    return this.$$.ctx[2];
  }
  set inTransition(t3) {
    this.$$set({ inTransition: t3 }), flush();
  }
  get outTransition() {
    return this.$$.ctx[3];
  }
  set outTransition(t3) {
    this.$$set({ outTransition: t3 }), flush();
  }
  get transitionOptions() {
    return this.$$.ctx[29];
  }
  set transitionOptions(t3) {
    this.$$set({ transitionOptions: t3 }), flush();
  }
  get inTransitionOptions() {
    return this.$$.ctx[4];
  }
  set inTransitionOptions(t3) {
    this.$$set({ inTransitionOptions: t3 }), flush();
  }
  get outTransitionOptions() {
    return this.$$.ctx[5];
  }
  set outTransitionOptions(t3) {
    this.$$set({ outTransitionOptions: t3 }), flush();
  }
}
cssVariables.setProperties({ "--tjs-default-text-shadow-focus-hover": "0 0 8px var(--color-shadow-primary)", "--tjs-app-background": `url("${globalThis.foundry.utils.getRoute("/ui/denim075.png")}")` }, false);
class ApplicationState {
  #me;
  #he;
  #St = /* @__PURE__ */ new Map();
  constructor(t3) {
    this.#me = t3, Object.seal(this);
  }
  clear() {
    this.#St.clear();
  }
  current(t3 = {}) {
    return Object.assign(t3, { position: this.#me?.position?.get(), beforeMinimized: this.#me?.position?.state.get({ name: "#beforeMinimized" }), options: this.#me?.reactive?.toJSON(), ui: { minimized: this.#me?.reactive?.minimized } });
  }
  get({ name: t3 }) {
    if ("string" != typeof t3) throw new TypeError("[SvelteApp.state.get] error: 'name' is not a string.");
    return this.#St.get(t3);
  }
  keys() {
    return this.#St.keys();
  }
  remove({ name: t3 }) {
    if ("string" != typeof t3) throw new TypeError("[SvelteApp.state.remove] error: 'name' is not a string.");
    const e = this.#St.get(t3);
    return this.#St.delete(t3), e;
  }
  restore({ name: t3, remove: e = false, animateTo: n = false, duration: i = 0.1, ease: o = "linear" }) {
    if ("string" != typeof t3) throw new TypeError("[SvelteApp.state.restore] error: 'name' is not a string.");
    const r = this.#St.get(t3);
    return r && (e && this.#St.delete(t3), n && t3 !== this.#he && (this.#he = t3, this.#fe(r, { animateTo: n, async: true, duration: i, ease: o }).then(() => {
      t3 === this.#he && (this.#he = void 0);
    }))), r;
  }
  save({ name: t3, ...e }) {
    if ("string" != typeof t3) throw new TypeError("[SvelteApp.state.save] error: 'name' is not a string.");
    const n = this.current(e);
    return this.#St.set(t3, n), n;
  }
  set(t3, e = {}) {
    this.#fe(t3, { ...e, async: false });
  }
  #fe(t3, { async: e = false, animateTo: n = false, duration: i = 0.1, ease: o = "linear" } = {}) {
    if (!isObject(t3)) throw new TypeError("[SvelteApp.state.set] error: 'data' is not an object.");
    const r = this.#me;
    if (!isObject(t3?.position)) return void console.warn("[SvelteApp.state.set] warning: 'data.position' is not an object.");
    const s = r.rendered;
    if (n) {
      if (!s) return void console.warn("[SvelteApp.state.set] warning: application is not rendered and 'animateTo' is true.");
      if (t3.position.transformOrigin !== r.position.transformOrigin && (r.position.transformOrigin = t3.position.transformOrigin), isObject(t3?.ui)) {
        const e2 = "boolean" == typeof t3.ui?.minimized && t3.ui.minimized;
        r?.reactive?.minimized && !e2 && r.maximize({ animate: false, duration: 0 });
      }
      const n2 = r.position.animate.to(t3.position, { duration: i, ease: o, strategy: "cancelAll" }).finished.then(({ cancelled: e2 }) => {
        if (!e2) {
          if (isObject(t3?.options) && r?.reactive.mergeOptions(t3.options), isObject(t3?.ui)) {
            const e3 = "boolean" == typeof t3.ui?.minimized && t3.ui.minimized;
            !r?.reactive?.minimized && e3 && r.minimize({ animate: false, duration: 0 });
          }
          isObject(t3?.beforeMinimized) && r.position.state.set({ name: "#beforeMinimized", ...t3.beforeMinimized });
        }
      });
      if (e) return n2;
    } else if (s) {
      if (isObject(t3?.options) && r?.reactive.mergeOptions(t3.options), isObject(t3?.ui)) {
        const e2 = "boolean" == typeof t3.ui?.minimized && t3.ui.minimized;
        r?.reactive?.minimized && !e2 ? r.maximize({ animate: false, duration: 0 }) : !r?.reactive?.minimized && e2 && r.minimize({ animate: false, duration: i });
      }
      isObject(t3?.beforeMinimized) && r.position.state.set({ name: "#beforeMinimized", ...t3.beforeMinimized }), r.position.set(t3.position);
    } else {
      let e2 = t3.position;
      isObject(t3.beforeMinimized) && (e2 = t3.beforeMinimized, e2.left = t3.position.left, e2.top = t3.position.top), r.position.set(e2);
    }
  }
}
class GetSvelteData {
  #ge;
  #_e;
  constructor(t3, e) {
    this.#ge = t3, this.#_e = e;
  }
  get appShell() {
    return this.#ge[0];
  }
  get applicationShell() {
    return this.#ge[0];
  }
  get appShellData() {
    return this.#_e[0];
  }
}
class SvelteReactive {
  #me;
  #be = false;
  #ye;
  #ve;
  #$e;
  #Te;
  #we;
  #Se;
  #ke = [];
  constructor(t3) {
    this.#me = t3;
    const e = t3?.options?.sessionStorage;
    if (void 0 !== e && !(e instanceof TJSWebStorage)) throw new TypeError("'options.sessionStorage' is not an instance of TJSWebStorage.");
    this.#ye = void 0 !== e ? e : new TJSSessionStorage();
  }
  initialize() {
    if (!this.#be) return this.#be = true, this.#Oe(), { appOptionsUpdate: this.#$e, uiStateUpdate: this.#Se, subscribe: this.#xe.bind(this), unsubscribe: this.#Ee.bind(this) };
  }
  get sessionStorage() {
    return this.#ye;
  }
  get storeAppOptions() {
    return this.#ve;
  }
  get storeUIState() {
    return this.#we;
  }
  get activeWindow() {
    return this.#Te.activeWindow ?? globalThis;
  }
  get dragging() {
    return this.#Te.dragging;
  }
  get minimized() {
    return this.#Te.minimized;
  }
  get resizing() {
    return this.#Te.resizing;
  }
  set activeWindow(t3) {
    null != t3 && "[object Window]" !== Object.prototype.toString.call(t3) || this.#Se((e) => deepMerge(e, { activeWindow: t3 ?? globalThis }));
  }
  get draggable() {
    return this.#me?.options?.draggable;
  }
  get focusAuto() {
    return this.#me?.options?.focusAuto;
  }
  get focusKeep() {
    return this.#me?.options?.focusKeep;
  }
  get focusTrap() {
    return this.#me?.options?.focusTrap;
  }
  get headerButtonNoClose() {
    return this.#me?.options?.headerButtonNoClose;
  }
  get headerButtonNoLabel() {
    return this.#me?.options?.headerButtonNoLabel;
  }
  get headerIcon() {
    return this.#me?.options?.headerIcon;
  }
  get headerNoTitleMinimized() {
    return this.#me?.options?.headerNoTitleMinimized;
  }
  get minimizable() {
    return this.#me?.options?.minimizable;
  }
  get popOut() {
    return this.#me.popOut;
  }
  get positionable() {
    return this.#me?.options?.positionable;
  }
  get resizable() {
    return this.#me?.options?.resizable;
  }
  get title() {
    return this.#me.title;
  }
  set draggable(t3) {
    "boolean" == typeof t3 && this.setOptions("draggable", t3);
  }
  set focusAuto(t3) {
    "boolean" == typeof t3 && this.setOptions("focusAuto", t3);
  }
  set focusKeep(t3) {
    "boolean" == typeof t3 && this.setOptions("focusKeep", t3);
  }
  set focusTrap(t3) {
    "boolean" == typeof t3 && this.setOptions("focusTrap", t3);
  }
  set headerButtonNoClose(t3) {
    "boolean" == typeof t3 && this.setOptions("headerButtonNoClose", t3);
  }
  set headerButtonNoLabel(t3) {
    "boolean" == typeof t3 && this.setOptions("headerButtonNoLabel", t3);
  }
  set headerIcon(t3) {
    void 0 !== t3 && "string" != typeof t3 || this.setOptions("headerIcon", t3);
  }
  set headerNoTitleMinimized(t3) {
    "boolean" == typeof t3 && this.setOptions("headerNoTitleMinimized", t3);
  }
  set minimizable(t3) {
    "boolean" == typeof t3 && this.setOptions("minimizable", t3);
  }
  set popOut(t3) {
    "boolean" == typeof t3 && this.setOptions("popOut", t3);
  }
  set positionable(t3) {
    "boolean" == typeof t3 && this.setOptions("positionable", t3);
  }
  set resizable(t3) {
    "boolean" == typeof t3 && this.setOptions("resizable", t3);
  }
  set title(t3) {
    "string" == typeof t3 ? this.setOptions("title", t3) : null == t3 && this.setOptions("title", "");
  }
  getOptions(t3, e) {
    return safeAccess(this.#me.options, t3, e);
  }
  mergeOptions(t3) {
    this.#$e((e) => deepMerge(e, t3));
  }
  setOptions(t3, e) {
    safeSet(this.#me.options, t3, e, { createMissing: true }) && this.#$e(() => this.#me.options);
  }
  toJSON() {
    return { draggable: this.#me?.options?.draggable ?? true, focusAuto: this.#me?.options?.focusAuto ?? true, focusKeep: this.#me?.options?.focusKeep ?? false, focusTrap: this.#me?.options?.focusTrap ?? true, headerButtonNoClose: this.#me?.options?.headerButtonNoClose ?? false, headerButtonNoLabel: this.#me?.options?.headerButtonNoLabel ?? false, headerNoTitleMinimized: this.#me?.options?.headerNoTitleMinimized ?? false, minimizable: this.#me?.options?.minimizable ?? true, positionable: this.#me?.options?.positionable ?? true, resizable: this.#me?.options?.resizable ?? true };
  }
  updateHeaderButtons({ headerButtonNoClose: t3 = this.#me.options.headerButtonNoClose, headerButtonNoLabel: e = this.#me.options.headerButtonNoLabel } = {}) {
    let n = this.#me._getHeaderButtons();
    if ("boolean" == typeof t3 && t3 && (n = n.filter((t4) => "close" !== t4.class)), "boolean" == typeof e && e) for (const t4 of n) t4.label = void 0;
    this.#Se((t4) => (t4.headerButtons = n, t4));
  }
  #Oe() {
    const t3 = writable(this.#me.options);
    this.#$e = t3.update;
    const e = { subscribe: t3.subscribe, draggable: propertyStore(t3, "draggable"), focusAuto: propertyStore(t3, "focusAuto"), focusKeep: propertyStore(t3, "focusKeep"), focusTrap: propertyStore(t3, "focusTrap"), headerButtonNoClose: propertyStore(t3, "headerButtonNoClose"), headerButtonNoLabel: propertyStore(t3, "headerButtonNoLabel"), headerIcon: propertyStore(t3, "headerIcon"), headerNoTitleMinimized: propertyStore(t3, "headerNoTitleMinimized"), minimizable: propertyStore(t3, "minimizable"), popOut: propertyStore(t3, "popOut"), positionable: propertyStore(t3, "positionable"), resizable: propertyStore(t3, "resizable"), title: propertyStore(t3, "title") };
    Object.freeze(e), this.#ve = e, this.#Te = { activeWindow: globalThis, dragging: false, headerButtons: [], minimized: this.#me._minimized, resizing: false };
    const n = writable(this.#Te);
    this.#Se = n.update;
    const i = { subscribe: n.subscribe, activeWindow: derived(n, (t4, e2) => e2(t4.activeWindow)), dragging: propertyStore(n, "dragging"), headerButtons: derived(n, (t4, e2) => e2(t4.headerButtons)), minimized: derived(n, (t4, e2) => e2(t4.minimized)), resizing: propertyStore(n, "resizing") };
    Object.freeze(i), this.#we = i;
  }
  #xe() {
    this.#ke.push(subscribeIgnoreFirst(this.#ve.headerButtonNoClose, (t3) => {
      this.updateHeaderButtons({ headerButtonNoClose: t3 });
    })), this.#ke.push(subscribeIgnoreFirst(this.#ve.headerButtonNoLabel, (t3) => {
      this.updateHeaderButtons({ headerButtonNoLabel: t3 });
    })), this.#ke.push(subscribeIgnoreFirst(this.#ve.popOut, (t3) => {
      t3 && this.#me.rendered ? globalThis.ui.windows[this.#me.appId] = this.#me : delete globalThis.ui.windows[this.#me.appId];
    }));
  }
  #Ee() {
    this.#ke.forEach((t3) => t3()), this.#ke = [];
  }
}
const applicationShellContract = ["elementRoot"];
function isApplicationShell(t3) {
  if (null == t3) return false;
  let e = true, n = true;
  for (const n2 of applicationShellContract) {
    const i2 = Object.getOwnPropertyDescriptor(t3, n2);
    void 0 !== i2 && void 0 !== i2.get && void 0 !== i2.set || (e = false);
  }
  const i = Object.getPrototypeOf(t3);
  for (const t4 of applicationShellContract) {
    const e2 = Object.getOwnPropertyDescriptor(i, t4);
    void 0 !== e2 && void 0 !== e2.get && void 0 !== e2.set || (n = false);
  }
  return e || n;
}
function loadSvelteConfig({ app: t3, config: e, elementRootUpdate: n } = {}) {
  let i;
  if (CrossWindow.isHTMLElement(e.target)) i = e.target;
  else if ("string" == typeof e.target) {
    const n2 = t3?.reactive?.activeWindow;
    i = n2?.document?.querySelector(e.target);
  }
  if (!CrossWindow.isHTMLElement(i)) throw e.target, new Error();
  const o = e.class, r = TJSSvelte.config.parseConfig({ ...e, target: i }, { contextExternal: true, thisArg: t3 }), s = r.context.get("#external");
  let a;
  s.application = t3, s.elementRootUpdate = n, s.sessionStorage = t3.reactive.sessionStorage, isObject(t3._eventbus) && "function" == typeof t3._eventbus.createProxy && (a = t3._eventbus.createProxy(), s.eventbus = a), Object.seal(s);
  const c = new o(r);
  let l;
  if (r.eventbus = a, isApplicationShell(c) && (l = c.elementRoot), !CrossWindow.isHTMLElement(l)) throw new Error();
  return { config: r, component: c, element: l };
}
Object.freeze(applicationShellContract);
class TJSAppIndex {
  static #Me = /* @__PURE__ */ new Map();
  static add(t3) {
    this.#Me.set(t3.id, t3);
  }
  static delete(t3) {
    this.#Me.delete(t3.id);
  }
  static get(t3) {
    return this.#Me.get(t3);
  }
  static has(t3) {
    return this.#Me.has(t3);
  }
  static keys() {
    return this.#Me.keys();
  }
  static values() {
    return this.#Me.values();
  }
}
class SvelteApp extends Application {
  #ge = [null];
  #Ae;
  #Ce = null;
  #Ie = null;
  #Pe = false;
  #De = 95;
  #Ne = false;
  #$t;
  #je;
  #_e = [null];
  #Le = new GetSvelteData(this.#ge, this.#_e);
  #l;
  constructor(t3 = {}) {
    if (super(t3), !isObject(this.options.svelte)) throw new Error("SvelteApp - constructor - No Svelte configuration object found in 'options'.");
    this.#Ae = new ApplicationState(this), this.#$t = new TJSPosition(this, { ...this.position, ...this.options, initial: this.options.positionInitial, ortho: this.options.positionOrtho, validator: this.options.positionValidator }), delete this.position, Object.defineProperty(this, "position", { get: () => this.#$t, set: (t4) => {
      isObject(t4) && this.#$t.set(t4);
    } }), this.#je = new SvelteReactive(this), this.#l = this.#je.initialize();
  }
  static get defaultOptions() {
    return deepMerge(super.defaultOptions, { defaultCloseAnimation: true, draggable: true, focusAuto: true, focusKeep: false, focusSource: void 0, focusTrap: true, headerButtonNoClose: false, headerButtonNoLabel: false, headerIcon: void 0, headerNoTitleMinimized: false, minHeight: MIN_WINDOW_HEIGHT, minWidth: MIN_WINDOW_WIDTH, positionable: true, positionInitial: TJSPosition.Initial.browserCentered, positionOrtho: true, positionValidator: TJSPosition.Validators.transformWindow, sessionStorage: void 0, svelte: void 0, transformOrigin: "top left" });
  }
  get elementContent() {
    return this.#Ie;
  }
  get elementTarget() {
    return this.#Ce;
  }
  get reactive() {
    return this.#je;
  }
  get state() {
    return this.#Ae;
  }
  get svelte() {
    return this.#Le;
  }
  _activateCoreListeners(t3) {
    super._activateCoreListeners("string" == typeof this.options.template ? t3 : [this.popOut ? this.#Ce?.firstChild : this.#Ce]);
  }
  bringToTop({ focus: t3 = true, force: e = false } = {}) {
    if (this.reactive.activeWindow !== globalThis) return;
    (e || this.popOut) && super.bringToTop();
    const n = this.elementTarget, i = document.activeElement;
    t3 && n && i !== n && !n?.contains(i) && (A11yHelper.isFocusTarget(i) && i.blur(), n?.focus()), globalThis.ui.activeWindow = this;
  }
  async close(t3 = {}) {
    const e = Application.RENDER_STATES;
    if (!t3.force && ![e.RENDERED, e.ERROR].includes(this._state)) return;
    const n = this.#Ce;
    if (!n) return void (this._state = e.CLOSED);
    if (CrossWindow.getWindow(n, { throws: false }) !== globalThis) return;
    this._state = e.CLOSING, this.#l.unsubscribe();
    const i = n.querySelector(".window-content");
    if (i) {
      i.style.overflow = "hidden";
      for (let t4 = i.children.length; --t4 >= 0; ) i.children[t4].style.overflow = "hidden";
    }
    for (const t4 of this.constructor._getInheritanceChain()) Hooks.call(`close${t4.name}`, this, $(n));
    if ("boolean" != typeof this.options.defaultCloseAnimation || this.options.defaultCloseAnimation) {
      n.style.minHeight = "0";
      const { paddingBottom: t4, paddingTop: e2 } = globalThis.getComputedStyle(n);
      await n.animate([{ maxHeight: `${n.clientHeight}px`, paddingTop: e2, paddingBottom: t4 }, { maxHeight: 0, paddingTop: 0, paddingBottom: 0 }], { duration: 250, easing: "ease-in", fill: "forwards" }).finished;
    }
    const o = [];
    for (const t4 of this.#_e) {
      if (!isObject(t4)) continue;
      o.push(TJSSvelte.util.outroAndDestroy(t4.component));
      const e2 = t4.config.eventbus;
      isObject(e2) && "function" == typeof e2.off && (e2.off(), t4.config.eventbus = void 0);
    }
    await Promise.allSettled(o), TJSAppIndex.delete(this), this.#_e[0] = null, n.remove(), this.position.state.restore({ name: "#beforeMinimized", properties: ["width", "height"], silent: true, remove: true }), this.#ge[0] = null, this._element = null, this.#Ie = null, this.#Ce = null, delete globalThis.ui.windows[this.appId], this._minimized = false, this._scrollPositions = null, this._state = e.CLOSED, this.#Ne = false, this.#l.uiStateUpdate((t4) => deepMerge(t4, { minimized: this._minimized })), A11yHelper.applyFocusSource(this.options.focusSource), delete this.options.focusSource;
  }
  _getHeaderButtons() {
    return super._getHeaderButtons();
  }
  _injectHTML() {
    this.reactive.updateHeaderButtons();
    if (!isObject(this.options.svelte)) throw new Error("SvelteApp - _injectHTML - No Svelte configuration object found in 'options'.");
    const t3 = loadSvelteConfig({ app: this, config: this.options.svelte, elementRootUpdate: () => {
      let t4 = 0;
      return (e) => null != e && t4++ > 0 && (this.#Fe(), true);
    } });
    if (null !== this.svelte.appShell) throw new Error(`SvelteApp - _injectHTML - An application shell is already mounted; offending config:
${JSON.stringify(this.options.svelte)}`);
    this.#ge[0] = t3.component, TJSSvelte.util.isHMRProxy(t3.component) && Array.isArray(t3.component?.$$?.on_hmr) && t3.component.$$.on_hmr.push(() => () => this.#Fe()), this.#_e[0] = t3, this._element = $(this.svelte.appShell.elementRoot), this.#Ie = hasGetter(this.svelte.appShell, "elementContent") ? this.svelte.appShell.elementContent : null, this.#Ce = hasGetter(this.svelte.appShell, "elementTarget") ? this.svelte.appShell.elementTarget : this.svelte.appShell.elementRoot, "boolean" == typeof this.options.positionable && this.options.positionable && (this.#Ce.style.zIndex = "number" == typeof this.options.zIndex ? this.options.zIndex : this.#De ?? 95), this.#l.subscribe();
  }
  async maximize({ animate: t3 = true, duration: e = 0.1 } = {}) {
    if (!this.popOut || [false, null].includes(this._minimized)) return;
    this._minimized = null;
    const n = 1e3 * e, i = this.elementTarget, o = i.querySelector(".window-header"), r = i.querySelector(".window-content"), s = this.position.state.get({ name: "#beforeMinimized" });
    t3 && await this.position.state.restore({ name: "#beforeMinimized", async: true, animateTo: true, properties: ["width"], duration: 0.1 }), i.classList.remove("minimized");
    for (let t4 = o.children.length; --t4 >= 0; ) o.children[t4].style.display = null;
    let a;
    r.style.display = null, { constraints: a } = t3 ? this.position.state.restore({ name: "#beforeMinimized", animateTo: true, properties: ["height"], remove: true, duration: e }) : this.position.state.remove({ name: "#beforeMinimized" }), await r.animate([{ maxHeight: 0, paddingTop: 0, paddingBottom: 0, offset: 0 }, { ...a, offset: 1 }, { maxHeight: "100%", offset: 1 }], { duration: n, fill: "forwards" }).finished, this.position.set({ minHeight: s.minHeight ?? this.options?.minHeight ?? MIN_WINDOW_HEIGHT, minWidth: s.minWidth ?? this.options?.minWidth ?? MIN_WINDOW_WIDTH }), i.style.minWidth = null, i.style.minHeight = null, this._minimized = false, setTimeout(() => {
      r.style.overflow = null;
      for (let t4 = r.children.length; --t4 >= 0; ) r.children[t4].style.overflow = null;
    }, 50), this.#l.uiStateUpdate((t4) => deepMerge(t4, { minimized: false }));
  }
  async minimize({ animate: t3 = true, duration: e = 0.1 } = {}) {
    if (!this.rendered || !this.popOut || [true, null].includes(this._minimized)) return;
    this.#l.uiStateUpdate((t4) => deepMerge(t4, { minimized: true })), this._minimized = null;
    const n = 1e3 * e, i = this.elementTarget, o = i.querySelector(".window-header"), r = i.querySelector(".window-content"), s = this.position.minWidth, a = this.position.minHeight;
    if (this.position.set({ minWidth: 100, minHeight: 30 }), i.style.minWidth = "100px", i.style.minHeight = "30px", r) {
      r.style.overflow = "hidden";
      for (let t4 = r.children.length; --t4 >= 0; ) r.children[t4].style.overflow = "hidden";
    }
    const { paddingBottom: c, paddingTop: l } = globalThis.getComputedStyle(r), p = { maxHeight: `${r.clientHeight}px`, paddingTop: l, paddingBottom: c };
    if (t3) {
      r.animate([p, { maxHeight: 0, paddingTop: 0, paddingBottom: 0 }], { duration: n, fill: "forwards" }).finished.then(() => r.style.display = "none");
    } else setTimeout(() => r.style.display = "none", n);
    const u = this.position.state.save({ name: "#beforeMinimized", constraints: p });
    u.minWidth = s, u.minHeight = a;
    const d = o.offsetHeight;
    this.position.minHeight = d, t3 && await this.position.animate.to({ height: d }, { duration: e }).finished;
    for (let t4 = o.children.length; --t4 >= 0; ) {
      const e2 = o.children[t4].className;
      e2.includes("window-title") || e2.includes("close") || (e2.includes("keep-minimized") ? o.children[t4].style.display = "block" : o.children[t4].style.display = "none");
    }
    t3 && await this.position.animate.to({ width: MIN_WINDOW_WIDTH }, { duration: 0.1 }).finished, i.classList.add("minimized"), this._minimized = true;
  }
  onSvelteMount() {
  }
  onSvelteRemount() {
  }
  _replaceHTML(t3, e) {
    t3.length && this.reactive.updateHeaderButtons();
  }
  async _render(t3 = false, e = {}) {
    isObject(e?.focusSource) && (this.options.focusSource = e.focusSource);
    const n = this.reactive.activeWindow;
    try {
      if (this._state === Application.RENDER_STATES.NONE && A11yHelper.isFocusTarget(n.document.querySelector(`#${this.id}`))) return void console.warn(`SvelteApp - _render: A DOM element already exists for CSS ID '${this.id}'. Cancelling initial render for new application with appId '${this.appId}'.`);
    } catch (t4) {
      return void console.warn(`SvelteApp - _render: Potentially malformed application ID '${this.id}'. Cancelling initial render for new application with appId '${this.appId}'.`);
    }
    this.#Pe = true, await super._render(t3, e), this.#Pe = false, [Application.RENDER_STATES.CLOSING, Application.RENDER_STATES.RENDERING].includes(this._state) || !t3 && this._state <= Application.RENDER_STATES.NONE || (this._minimized || this.#$t.set({ left: "string" == typeof this.options?.left ? this.options.left : void 0, height: "string" == typeof this.options?.height ? this.options.height : void 0, maxHeight: "string" == typeof this.options?.maxHeight ? this.options.maxHeight : void 0, maxWidth: "string" == typeof this.options?.maxWidth ? this.options.maxWidth : void 0, minHeight: "string" == typeof this.options?.minHeight ? this.options.minHeight : void 0, minWidth: "string" == typeof this.options?.minWidth ? this.options.minWidth : void 0, rotateX: "string" == typeof this.options?.rotateX ? this.options.rotateX : void 0, rotateY: "string" == typeof this.options?.rotateY ? this.options.rotateY : void 0, rotateZ: "string" == typeof this.options?.rotateZ ? this.options.rotateZ : void 0, rotation: "string" == typeof this.options?.rotation ? this.options.rotation : void 0, top: "string" == typeof this.options?.top ? this.options.top : void 0, width: "string" == typeof this.options?.width ? this.options.width : void 0, ...e }), this.#Ne || (TJSAppIndex.add(this), this.onSvelteMount(), this.#Ne = true));
  }
  async _renderInner() {
    const t3 = this.reactive.activeWindow.document.createDocumentFragment();
    return $(t3);
  }
  async _renderOuter() {
    const t3 = await super._renderOuter();
    return this.#De = t3[0].style.zIndex, t3;
  }
  setPosition(t3) {
    return this.#Pe ? this.position : this.position.set(t3);
  }
  #Fe() {
    const t3 = this.svelte.appShell;
    null !== t3 && (this._element = $(t3.elementRoot), this.#Ie = hasGetter(t3, "elementContent") ? t3.elementContent : null, this.#Ce = hasGetter(t3, "elementTarget") ? t3.elementTarget : null, null === this.#Ce && (this.#Ce = "string" == typeof this.options.selectorTarget ? this._element[0].querySelector(this.options.selectorTarget) : this._element[0]), "boolean" == typeof this.options.positionable && this.options.positionable && (this.#Ce.style.zIndex = "number" == typeof this.options.zIndex ? this.options.zIndex : this.#De ?? 95, super.bringToTop(), this.position.set(this.position.get())), super._activateCoreListeners([this.popOut ? this.#Ce?.firstChild : this.#Ce]), this.onSvelteRemount());
  }
}
class PopoutSupport {
  static initialize() {
    Hooks.on("PopOut:loading", (t3, e) => {
      t3 instanceof SvelteApp && (t3.position.enabled = false, t3.state.save({ name: "#beforePopout", headerButtonNoClose: t3.reactive.headerButtonNoClose }), t3.reactive.activeWindow = e, t3.reactive.headerButtonNoClose = true);
    }), Hooks.on("PopOut:popin", (t3) => this.#ze(t3)), Hooks.on("PopOut:close", (t3) => this.#ze(t3));
  }
  static #ze(t3) {
    if (t3 instanceof SvelteApp) {
      t3.position.enabled = true;
      const e = t3.state.remove({ name: "#beforePopout" });
      e && (t3.reactive.headerButtonNoClose = e?.headerButtonNoClose ?? false), t3.reactive.activeWindow = void 0;
    }
  }
}
PopoutSupport.initialize();
let subModuleId = "";
function setSubModuleId(t3) {
  subModuleId = t3;
}
function getFullModuleId() {
  return "mobile-companion-" + subModuleId;
}
function getBaseModuleId() {
  return "mobile-companion";
}
function get_each_context$c(t3, e, n) {
  const i = t3.slice();
  return i[9] = e[n], i[10] = e, i[11] = n, i;
}
function create_each_block$c(t3, e) {
  let n, i, o, r, s, a, c, l, p, u, d, m, h, f, g = e[9].name + "";
  function _() {
    e[4].call(c, e[10], e[11]);
  }
  function b() {
    e[5].call(u, e[10], e[11]);
  }
  return { key: t3, first: null, c() {
    n = element("li"), i = element("div"), o = element("h4"), r = text(g), s = space(), a = element("div"), c = element("input"), l = space(), p = element("div"), u = element("input"), m = space(), attr(c, "type", "checkbox"), attr(u, "type", "number"), u.disabled = d = !e[9].enabled, attr(n, "class", "item svelte-mobile-companion-pf2e-v340n8-1jj7tri"), attr(n, "data-item-id", this.id), this.first = n;
  }, m(t4, d2) {
    insert(t4, n, d2), append(n, i), append(i, o), append(o, r), append(n, s), append(n, a), append(a, c), c.checked = e[9].enabled, append(n, l), append(n, p), append(p, u), set_input_value(u, e[9].screenWidth), append(n, m), h || (f = [listen(c, "change", _), listen(u, "input", b)], h = true);
  }, p(t4, n2) {
    e = t4, 2 & n2 && g !== (g = e[9].name + "") && set_data(r, g), 2 & n2 && (c.checked = e[9].enabled), 2 & n2 && d !== (d = !e[9].enabled) && (u.disabled = d), 2 & n2 && to_number(u.value) !== e[9].screenWidth && set_input_value(u, e[9].screenWidth);
  }, d(t4) {
    t4 && detach(n), h = false, run_all(f);
  } };
}
function create_default_slot$6(t3) {
  let e, n, i, o, r, s, a, c, l, p, u, d, m = [], h = /* @__PURE__ */ new Map(), f = ensure_array_like(t3[1]);
  const g = (t4) => t4[9].id;
  for (let e2 = 0; e2 < f.length; e2 += 1) {
    let n2 = get_each_context$c(t3, f, e2), i2 = g(n2);
    h.set(i2, m[e2] = create_each_block$c(i2, n2));
  }
  return { c() {
    e = element("form"), n = element("div"), i = element("ol"), o = element("li"), o.innerHTML = "<div>Player</div> <div>Enable</div> <div>Activation screen width</div>", r = space(), s = element("ol");
    for (let t4 = 0; t4 < m.length; t4 += 1) m[t4].c();
    a = space(), c = element("button"), c.textContent = "Save", l = space(), p = element("button"), p.textContent = "Cancel", attr(o, "class", "table-header svelte-mobile-companion-pf2e-v340n8-1jj7tri"), attr(s, "class", "item-list svelte-mobile-companion-pf2e-v340n8-1jj7tri"), attr(i, "class", "svelte-mobile-companion-pf2e-v340n8-1jj7tri"), attr(n, "class", "settings svelte-mobile-companion-pf2e-v340n8-1jj7tri"), attr(p, "type", "reset"), set_style(e, "height", "100%"), attr(e, "class", "svelte-mobile-companion-pf2e-v340n8-1jj7tri");
  }, m(h2, f2) {
    insert(h2, e, f2), append(e, n), append(n, i), append(i, o), append(i, r), append(i, s);
    for (let t4 = 0; t4 < m.length; t4 += 1) m[t4] && m[t4].m(s, null);
    append(e, a), append(e, c), append(e, l), append(e, p), u || (d = [listen(c, "click", prevent_default(t3[3])), listen(p, "click", prevent_default(t3[6]))], u = true);
  }, p(t4, e2) {
    2 & e2 && (f = ensure_array_like(t4[1]), m = update_keyed_each(m, e2, g, 1, t4, f, h, s, destroy_block, create_each_block$c, null, get_each_context$c));
  }, d(t4) {
    t4 && detach(e);
    for (let t5 = 0; t5 < m.length; t5 += 1) m[t5].d();
    u = false, run_all(d);
  } };
}
function create_fragment$z(t3) {
  let e, n, i;
  function o(e2) {
    t3[7](e2);
  }
  let r = { $$slots: { default: [create_default_slot$6] }, $$scope: { ctx: t3 } };
  return void 0 !== t3[0] && (r.elementRoot = t3[0]), e = new ApplicationShell({ props: r }), binding_callbacks.push(() => bind(e, "elementRoot", o)), { c() {
    create_component(e.$$.fragment);
  }, m(t4, n2) {
    mount_component(e, t4, n2), i = true;
  }, p(t4, [i2]) {
    const o2 = {};
    4098 & i2 && (o2.$$scope = { dirty: i2, ctx: t4 }), !n && 1 & i2 && (n = true, o2.elementRoot = t4[0], add_flush_callback(() => n = false)), e.$set(o2);
  }, i(t4) {
    i || (transition_in(e.$$.fragment, t4), i = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), i = false;
  }, d(t4) {
    destroy_component(e, t4);
  } };
}
function instance$z(t3, e, n) {
  let { elementRoot: i } = e;
  const { application: o } = getContext("#external"), r = game.settings.get(getFullModuleId(), settings.users);
  let s = game.users.filter((t4) => t4.role !== FoundryUserRoles.GAMEMASTER.valueOf()).map((t4) => {
    let e2 = r[t4.id] || {};
    return foundry.utils.isNewerVersion(game.version, "12") ? foundry.utils.mergeObject({ id: t4.id, name: t4.name, enabled: false, screenWidth: 0 }, e2) : mergeObject({ id: t4.id, name: t4.name, enabled: false, screenWidth: 0 }, e2);
  });
  return t3.$$set = (t4) => {
    "elementRoot" in t4 && n(0, i = t4.elementRoot);
  }, [i, s, o, function() {
    s.forEach((t4) => {
      let e2 = r[t4.id] || {};
      e2.enabled = t4.enabled, e2.screenWidth = t4.screenWidth || 0, r[t4.id] = e2;
    }), game.settings.set(getFullModuleId(), settings.users, r), o.close();
  }, function(t4, e2) {
    t4[e2].enabled = this.checked, n(1, s);
  }, function(t4, e2) {
    t4[e2].screenWidth = to_number(this.value), n(1, s);
  }, () => o.close(), function(t4) {
    i = t4, n(0, i);
  }];
}
let UserSetupShell$1 = class extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$z, create_fragment$z, safe_not_equal, { elementRoot: 0 });
  }
  get elementRoot() {
    return this.$$.ctx[0];
  }
  set elementRoot(t3) {
    this.$$set({ elementRoot: t3 }), flush();
  }
};
class UserSetupShell extends SvelteApp {
  static get defaultOptions() {
    return foundry.utils.mergeObject(super.defaultOptions, { title: "Settings", width: "auto", height: "auto", resizable: false, svelte: { class: UserSetupShell$1, target: document.body } });
  }
}
class SettingsUser extends FormApplication {
  static #Re;
  static showSettings() {
    return this.#Re = this.#Re ? this.#Re : new UserSetupShell(), this.#Re.render(true, { focus: true }), this.#Re;
  }
  constructor(t3 = {}) {
    super({}, t3), SettingsUser.showSettings();
  }
  async _updateObject(t3, e) {
    await super._updateObject(t3, e);
  }
  render() {
    this.close();
  }
}
function i18n(t3) {
  return game.i18n.localize(t3);
}
function myi18n(t3) {
  return i18n("Mobile-Companion.".concat(t3));
}
function i18nFormat(t3, e) {
  return game.i18n.format(t3, e);
}
async function enrichText(t3, e = []) {
  let n = t3;
  for (const t4 of e) {
    const e2 = new RegExp(t4.find, "g");
    n = n.replace(e2, t4.replace);
  }
  return n = foundry.utils.isNewerVersion(game.version, "12.343") ? await foundry.applications.ux.TextEditor.implementation.enrichHTML(n) : await TextEditor.enrichHTML(n), n;
}
const DOM_REMOVE = "dom-remove-or-hide", MAIN_WIDTH = "main-width", BACKGROUND_IMG = "background-img";
function getCommonSettings(t3, e) {
  const n = [];
  return n.push({ namespace: t3, key: DOM_REMOVE, options: { name: "Debug: Hide instead of remove DOM elements", hint: "Hides instead of removes non-mobile-companion DOM elements.", scope: "world", config: true, type: Boolean, default: false } }), n.push({ namespace: t3, key: "main-width", options: { name: "App Width", hint: "Determines the width in percent of the app. If you are using quite a large device you might prefer the app not stretching the full display width.", scope: "client", range: { min: 0, max: 100, step: 1 }, config: true, type: Number, default: 100, onChange: (t4) => {
    e.getWritableStore(MAIN_WIDTH)?.set(t4);
  } } }), n.push({ namespace: t3, key: "background-img", options: { name: "Background Image", hint: "(Pro Feature) Set an URL to an image (animated gifs work, too) which will be displayed behind the app. Only use this if you set the app width smaller than 100.", scope: "client", config: true, type: String, onChange: (t4) => {
    e.getWritableStore(BACKGROUND_IMG)?.set(t4);
  } } }), n;
}
const USE_CURRENCY = "useCurrency", USE_ENCUMBRANCE = "useEncumbrance", LAST_ACTOR_ID = "lastActorId";
class MobileCompanionGameSettings extends TJSGameSettings {
  constructor() {
    super(getFullModuleId());
  }
  getWritableStore(t3) {
    return super.getWritableStore(t3);
  }
  init() {
    const t3 = getFullModuleId();
    game.settings.registerMenu(t3, settings.usersMenu, { name: "Set users", label: "Users", hint: "Set up users who use mobile companion", type: SettingsUser, icon: "fas fa-users", restricted: true }), game.settings.register(t3, settings.users, { scope: "world", config: false, default: {}, type: Object }), game.settings.register(t3, LAST_ACTOR_ID, { scope: "client", config: false, type: String, default: "" }), super.registerAll(getPf2eSettings(t3), true), super.registerAll(getCommonSettings(t3, mobileCompanionGameSettings));
  }
}
function getPf2eSettings(t3) {
  const e = [];
  return e.push({ namespace: t3, key: USE_CURRENCY, options: { name: myi18n("Settings.UseCurrency.Name"), hint: myi18n("Settings.UseCurrency.Hint"), scope: "client", config: true, type: Boolean, default: true } }), e.push({ namespace: t3, key: USE_ENCUMBRANCE, options: { name: myi18n("Settings.UseEncumbrance.Name"), hint: myi18n("Settings.UseEncumbrance.Hint"), scope: "client", config: true, type: Boolean, default: true } }), e;
}
const mobileCompanionGameSettings = new MobileCompanionGameSettings();
function saveLastActorId(t3) {
  game.settings.set(getFullModuleId(), settings.lastActorId, t3);
}
function getLastActorId() {
  return game.settings.get(getFullModuleId(), settings.lastActorId);
}
function isMobileCompanion() {
  const t3 = game.settings.get(getFullModuleId(), settings.users)[game.user.id];
  if (t3) {
    if (t3.enabled) {
      const e = t3.screenWidth;
      if (e <= 0) return true;
      if (screen.width < e) return true;
    }
  }
  return false;
}
let hideInsteadOfRemove = false;
function hideAllElements() {
  hideInsteadOfRemove = game.settings.get(getFullModuleId(), DOM_REMOVE);
  [50, 500, 1e3].forEach((t3) => {
    setTimeout(hideOtherElements, t3);
  }), startObserver();
}
function startObserver() {
  setTimeout(() => {
    const t3 = new MutationObserver((t4) => {
      for (const e of t4) "childList" === e.type && e.addedNodes.forEach((t5) => {
        if (t5.nodeType === Node.ELEMENT_NODE) {
          const e2 = t5;
          let n = e2.classList.contains("window-app"), i = "mobile-companion" === e2.id, o = "client-settings" === e2.id, r = e2.classList.contains("mobile-companion");
          !n || i || o || r || hideOrRemoveElement(e2);
        }
      });
    });
    t3.observe(document.body, { childList: true, subtree: false });
  }, 1e3);
}
function disableSounds() {
  game.settings.set("core", "globalPlaylistVolume", 0), game.settings.set("core", "globalAmbientVolume", 0), game.settings.set("core", "globalInterfaceVolume", 0);
}
function hideOtherElements() {
  Array.from(document.body.children).forEach((t3) => {
    if (t3.id !== getBaseModuleId()) {
      hideOrRemoveElement(t3);
    }
  });
}
function hideOrRemoveElement(t3) {
  hideInsteadOfRemove ? t3.style.display = "none" : (t3.remove(), reapplyDummyElements());
}
function reapplyDummyElements() {
  if (!document.getElementById("navigation")) {
    const t3 = document.createElement("nav");
    t3.id = "navigation", t3.textContent = "This is an empty dummy navigation bar to prevent Foundry error", t3.style.display = "none", document.body.appendChild(t3);
  }
  if (!document.getElementById("loading")) {
    const t3 = document.createElement("div");
    t3.id = "loading", t3.textContent = "This is an empty dummy loading bar bar to prevent Foundry error", t3.style.display = "none", document.body.appendChild(t3);
  }
}
const largeScreen = writable(false);
window.MIN_WINDOW_WIDTH = 200, window.MIN_WINDOW_HEIGHT = 50;
const LARGE_SCREEN_WIDTH = 600;
function onReady(t3) {
  isMobileCompanion() && (hideAllElements(), disableSounds(), window.addEventListener("resize", updateScreenWidth), t3());
}
function getIsLargeScreen() {
  return window.innerWidth >= LARGE_SCREEN_WIDTH;
}
const updateScreenWidth = () => {
  largeScreen.set(getIsLargeScreen());
};
function onRenderItemSheet(t3) {
  isMobileCompanion() && (t3.element.addClass(getBaseModuleId() + " full-size-sheet"), t3.setPosition({ top: 0, left: 0 }));
}
async function setupPerformanceSettings() {
  await game.settings.set("core", "noCanvas", true), await game.settings.set("core", "pixelRatioResolutionScaling", false), await game.settings.set("core", "visionAnimation", false), await game.settings.set("core", "mipmap", false), await game.settings.set("core", "performanceMode", CONST.CANVAS_PERFORMANCE_MODES.LOW), await game.settings.set("core", "maxFPS", 10);
}
function create_default_slot$5(t3) {
  let e, n, i, o, r, s, a;
  return { c() {
    e = element("div"), n = element("h2"), n.textContent = "An error occurred", i = space(), o = element("strong"), o.textContent = "Mobile-Companion encountered an error:", r = space(), s = element("p"), a = text(t3[1]), attr(n, "class", "svelte-mobile-companion-pf2e-v340n8-5mhrnj"), attr(e, "class", "container svelte-mobile-companion-pf2e-v340n8-5mhrnj");
  }, m(t4, c) {
    insert(t4, e, c), append(e, n), append(e, i), append(e, o), append(e, r), append(e, s), append(s, a);
  }, p(t4, e2) {
    2 & e2 && set_data(a, t4[1]);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_fragment$y(t3) {
  let e, n, i;
  function o(e2) {
    t3[2](e2);
  }
  let r = { $$slots: { default: [create_default_slot$5] }, $$scope: { ctx: t3 } };
  return void 0 !== t3[0] && (r.elementRoot = t3[0]), e = new ApplicationShell({ props: r }), binding_callbacks.push(() => bind(e, "elementRoot", o)), { c() {
    create_component(e.$$.fragment);
  }, m(t4, n2) {
    mount_component(e, t4, n2), i = true;
  }, p(t4, [i2]) {
    const o2 = {};
    10 & i2 && (o2.$$scope = { dirty: i2, ctx: t4 }), !n && 1 & i2 && (n = true, o2.elementRoot = t4[0], add_flush_callback(() => n = false)), e.$set(o2);
  }, i(t4) {
    i || (transition_in(e.$$.fragment, t4), i = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), i = false;
  }, d(t4) {
    destroy_component(e, t4);
  } };
}
function instance$y(t3, e, n) {
  let { elementRoot: i } = e, { error: o } = e;
  return t3.$$set = (t4) => {
    "elementRoot" in t4 && n(0, i = t4.elementRoot), "error" in t4 && n(1, o = t4.error);
  }, [i, o, function(t4) {
    i = t4, n(0, i);
  }];
}
let ErrorShell$1 = class extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$y, create_fragment$y, safe_not_equal, { elementRoot: 0, error: 1 });
  }
  get elementRoot() {
    return this.$$.ctx[0];
  }
  set elementRoot(t3) {
    this.$$set({ elementRoot: t3 }), flush();
  }
  get error() {
    return this.$$.ctx[1];
  }
  set error(t3) {
    this.$$set({ error: t3 }), flush();
  }
}, currentSheet, factory;
class ErrorShell extends SvelteApp {
  constructor(t3) {
    super(), this.options.svelte.props.error = t3;
  }
  static get defaultOptions() {
    return foundry.utils.mergeObject(super.defaultOptions, { title: "Error", id: getBaseModuleId(), classes: ["error-shell"], width: "400px", height: "300px", zIndex: 99999, resizable: false, svelte: { class: ErrorShell$1, target: document.body, props: {} } });
  }
}
function activateSheet(t3) {
  factory = t3, checkCanvas(), popupSheet(), addEventListener("resize", onResize);
}
function onResize() {
  currentSheet?.element.css({ width: window.innerWidth, height: window.innerHeight });
}
function checkCanvas() {
  game.settings.get("core", "noCanvas") || game.settings.set("core", "noCanvas", true);
}
function popupSheet() {
  const t3 = getOwnedActors(), e = getLastActorId();
  if (e) {
    const n = game.actors.get(e), i = t3.some((t4) => t4.id === e);
    if (n && (i || game.user.isGM)) return void switchToActor(n);
  }
  if (!(t3?.length > 0)) throw console.error("No actor for user found."), new NoActorFoundError("No actor found!. You are not the owner of any actor. Please ask your GM to get access to the actor.");
  switchToActor(t3[0]);
}
class NoActorFoundError extends Error {
  constructor(t3 = "No actor found") {
    super(t3), this.name = "NoActorFoundError";
  }
}
function getOwnedActors() {
  return game.user.isGM ? game.actors.contents : game.actors.filter((t3) => isActorOwnedByUser(t3));
}
function isActorOwnedByUser(t3) {
  return 3 === t3.ownership[game.user.id];
}
function switchToActor(t3) {
  currentSheet && currentSheet.close(), openMobileCompanion(t3), saveLastActorId(t3.id);
}
function openMobileCompanion(t3) {
  currentSheet = factory(t3), currentSheet ? currentSheet.render(true, { focus: true }) : console.error("Mobile-Companion does not support this system. Please disable Mobile-Companion.");
}
var Filters = ((t3) => (t3.Object = "object", t3.Spell = "spell", t3))(Filters || {});
const actorStore = writable({}), activeFilterStore = writable("object");
function init(t3) {
  actorStore.set(t3);
}
const updateInventory = async (t3) => {
  let e = get_store_value(actorStore);
  t3.parent?.id === e.id && (e = game.actors.find((t4) => t4.id === e.id), actorStore.set(e), switchFilter(get_store_value(activeFilterStore)));
}, updateActor = async (t3) => {
  let e = get_store_value(actorStore);
  e.id === t3.id && (e = t3, actorStore.set(e), switchFilter(get_store_value(activeFilterStore)));
};
function handleOnMount() {
  Hooks.on("createItem", updateInventory), Hooks.on("deleteItem", updateInventory), Hooks.on("updateItem", updateInventory), Hooks.on("updateActor", updateActor), switchFilter(get_store_value(activeFilterStore));
}
function handleOnDestroy() {
  Hooks.off("createItem", updateInventory), Hooks.off("deleteItem", updateInventory), Hooks.off("updateItem", updateInventory), Hooks.off("updateActor", updateActor);
}
const headerButtons = [{ id: "object", iconClass: "pf2e-nav-item fas fa-box-open", buttonClass: "", label: "Inventory", onClick: () => switchFilter("object") }, { id: "spell", iconClass: "pf2e-nav-item fas fa-wand-sparkles", buttonClass: "", label: "Spells", onClick: () => switchFilter("spell") }], menuButtons = { buttonClass: "", iconClass: "pf2e-nav-item" };
function switchFilter(t3) {
  activeFilterStore.set(t3);
}
var CarryType = ((t3) => (t3.ATTACHED = "attached", t3.DROPPED = "dropped", t3.HELD = "held", t3.STOWED = "stowed", t3.WORN = "worn", t3))(CarryType || {}), ItemType = ((t3) => (t3.weapon = "weapon", t3.armor = "armor", t3.shield = "shield", t3.equipment = "equipment", t3.consumable = "consumable", t3.treasure = "treasure", t3.backpack = "backpack", t3))(ItemType || {}), SpellcastingTabType = ((t3) => (t3.KNOWN = "Known Spells", t3.RITUAL = "Rituals", t3.ACTIVATION = "Activations", t3))(SpellcastingTabType || {});
function create_catch_block$1(t3) {
  let e, n = console.error("(There was an error:", t3[3].message) + "";
  return { c() {
    e = text(n);
  }, m(t4, n2) {
    insert(t4, e, n2);
  }, p: noop, d(t4) {
    t4 && detach(e);
  } };
}
function create_then_block$1(t3) {
  let e, n, i, o, r = t3[1] + "";
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("PF2E.DamageLabel")}:`, i = space(), o = text(r);
  }, m(t4, r2) {
    insert(t4, e, r2), append(e, n), append(e, i), append(e, o);
  }, p: noop, d(t4) {
    t4 && detach(e);
  } };
}
function create_pending_block$1(t3) {
  return { c: noop, m: noop, p: noop, d: noop };
}
function create_fragment$x(t3) {
  let e, n, i, o, r, s, a = { ctx: t3, current: null, token: null, hasCatch: true, pending: create_pending_block$1, then: create_then_block$1, catch: create_catch_block$1, value: 1, error: 3 };
  return handle_promise(t3[1], a), { c() {
    e = element("section"), n = element("p"), i = element("b"), i.textContent = `${i18n("PF2E.AttackLabel")}:`, o = text("\r\n        1d20 + "), r = text(t3[0]), s = space(), a.block.c();
  }, m(t4, c) {
    insert(t4, e, c), append(e, n), append(n, i), append(n, o), append(n, r), append(e, s), a.block.m(e, a.anchor = null), a.mount = () => e, a.anchor = null;
  }, p(e2, [n2]) {
    update_await_block_branch(a, t3 = e2, n2);
  }, i: noop, o: noop, d(t4) {
    t4 && detach(e), a.block.d(), a.token = null, a = null;
  } };
}
function instance$x(t3, e, n) {
  let { action: i } = e;
  const o = i.totalModifier, r = i.damage({ getFormula: true, createMessage: false });
  return t3.$$set = (t4) => {
    "action" in t4 && n(2, i = t4.action);
  }, [o, r, i];
}
class Pf2eAction extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$x, create_fragment$x, safe_not_equal, { action: 2 });
  }
}
function create_if_block_3$6(t3) {
  let e, n, i, o, r = i18n(t3[2].rarityTraits[t3[0].traits.rarity]) + "";
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("PF2E.Rarity")}:`, i = space(), o = text(r);
  }, m(t4, r2) {
    insert(t4, e, r2), append(e, n), append(e, i), append(e, o);
  }, p(t4, e2) {
    1 & e2 && r !== (r = i18n(t4[2].rarityTraits[t4[0].traits.rarity]) + "") && set_data(o, r);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_if_block_2$7(t3) {
  let e, n, i, o, r = t3[0].level.value + "";
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("PF2E.ItemTitle")}:`, i = space(), o = text(r);
  }, m(t4, r2) {
    insert(t4, e, r2), append(e, n), append(e, i), append(e, o);
  }, p(t4, e2) {
    1 & e2 && r !== (r = t4[0].level.value + "") && set_data(o, r);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_if_block_1$b(t3) {
  let e, n, i, o, r = t3[0].bulk.value + "";
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("PF2E.Weight")}:`, i = space(), o = text(r);
  }, m(t4, r2) {
    insert(t4, e, r2), append(e, n), append(e, i), append(e, o);
  }, p(t4, e2) {
    1 & e2 && r !== (r = t4[0].bulk.value + "") && set_data(o, r);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_if_block$j(t3) {
  let e, n, i, o;
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("PF2E.PriceLabel")}:`, i = space(), o = text(t3[1]);
  }, m(t4, r) {
    insert(t4, e, r), append(e, n), append(e, i), append(e, o);
  }, p(t4, e2) {
    2 & e2 && set_data(o, t4[1]);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_catch_block(t3) {
  let e, n = console.error("(There was an error:", t3[5].message) + "";
  return { c() {
    e = text(n);
  }, m(t4, n2) {
    insert(t4, e, n2);
  }, p: noop, d(t4) {
    t4 && detach(e);
  } };
}
function create_then_block(t3) {
  let e, n = t3[4] + "";
  return { c() {
    e = element("p");
  }, m(t4, i) {
    insert(t4, e, i), e.innerHTML = n;
  }, p: noop, d(t4) {
    t4 && detach(e);
  } };
}
function create_pending_block(t3) {
  return { c: noop, m: noop, p: noop, d: noop };
}
function create_fragment$w(t3) {
  let e, n, i, o, r, s = t3[0].traits.rarity && create_if_block_3$6(t3), a = t3[0].level && create_if_block_2$7(t3), c = t3[0].bulk?.value && create_if_block_1$b(t3), l = t3[1].length > 0 && create_if_block$j(t3), p = { ctx: t3, current: null, token: null, hasCatch: true, pending: create_pending_block, then: create_then_block, catch: create_catch_block, value: 4, error: 5 };
  return handle_promise(t3[3], p), { c() {
    s && s.c(), e = space(), a && a.c(), n = space(), c && c.c(), i = space(), l && l.c(), o = space(), r = empty(), p.block.c();
  }, m(t4, u) {
    s && s.m(t4, u), insert(t4, e, u), a && a.m(t4, u), insert(t4, n, u), c && c.m(t4, u), insert(t4, i, u), l && l.m(t4, u), insert(t4, o, u), insert(t4, r, u), p.block.m(t4, p.anchor = u), p.mount = () => r.parentNode, p.anchor = r;
  }, p(r2, [u]) {
    (t3 = r2)[0].traits.rarity ? s ? s.p(t3, u) : (s = create_if_block_3$6(t3), s.c(), s.m(e.parentNode, e)) : s && (s.d(1), s = null), t3[0].level ? a ? a.p(t3, u) : (a = create_if_block_2$7(t3), a.c(), a.m(n.parentNode, n)) : a && (a.d(1), a = null), t3[0].bulk?.value ? c ? c.p(t3, u) : (c = create_if_block_1$b(t3), c.c(), c.m(i.parentNode, i)) : c && (c.d(1), c = null), t3[1].length > 0 ? l ? l.p(t3, u) : (l = create_if_block$j(t3), l.c(), l.m(o.parentNode, o)) : l && (l.d(1), l = null), update_await_block_branch(p, t3, u);
  }, i: noop, o: noop, d(t4) {
    t4 && (detach(e), detach(n), detach(i), detach(o), detach(r)), s && s.d(t4), a && a.d(t4), c && c.d(t4), l && l.d(t4), p.block.d(t4), p.token = null, p = null;
  } };
}
function instance$w(t3, e, n) {
  let { itemData: i } = e;
  const o = CONFIG.PF2E;
  let r;
  const s = TextEditor.enrichHTML(i.description.value);
  return t3.$$set = (t4) => {
    "itemData" in t4 && n(0, i = t4.itemData);
  }, t3.$$.update = () => {
    if (1 & t3.$$.dirty) {
      let t4 = [];
      i.price.value.cp > 0 && t4.push(i.price.value.cp + " cp"), i.price.value.sp > 0 && t4.push(i.price.value.sp + " sp"), i.price.value.gp > 0 && t4.push(i.price.value.gp + " gp"), i.price.value.pp > 0 && t4.push(i.price.value.pp + " pp"), n(1, r = t4.join(" "));
    }
  }, [i, r, o, s];
}
class Pf2eDescription extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$w, create_fragment$w, safe_not_equal, { itemData: 0 });
  }
}
function get_each_context$b(t3, e, n) {
  const i = t3.slice();
  return i[4] = e[n], i;
}
function create_each_block$b(t3, e) {
  let n;
  return { key: t3, first: null, c() {
    n = element("span"), n.textContent = `${i18n(e[1].armorTraits[e[4]])}`, attr(n, "class", "tag"), this.first = n;
  }, m(t4, e2) {
    insert(t4, n, e2);
  }, p(t4, n2) {
    e = t4;
  }, d(t4) {
    t4 && detach(n);
  } };
}
function create_if_block_5$3(t3) {
  let e, n, i, o, r, s = t3[0].acBonus + "", a = i18n("PF2E.ArmorArmorLabel") + "";
  return { c() {
    e = element("span"), n = text("+"), i = text(s), o = space(), r = text(a), attr(e, "class", "tag-light");
  }, m(t4, s2) {
    insert(t4, e, s2), append(e, n), append(e, i), append(e, o), append(e, r);
  }, p(t4, e2) {
    1 & e2 && s !== (s = t4[0].acBonus + "") && set_data(i, s);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_if_block_4$4(t3) {
  let e, n, i = i18n(t3[1].armorCategories[t3[0].category]) + "";
  return { c() {
    e = element("span"), n = text(i), attr(e, "class", "tag-light");
  }, m(t4, i2) {
    insert(t4, e, i2), append(e, n);
  }, p(t4, e2) {
    1 & e2 && i !== (i = i18n(t4[1].armorCategories[t4[0].category]) + "") && set_data(n, i);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_if_block_3$5(t3) {
  let e, n, i, o, r = (t3[0].dexCap > 0 ? `+${t3[0].dexCap}` : t3[0].dexCap) + "", s = i18n("PF2E.ArmorDexLabel") + "";
  return { c() {
    e = element("span"), n = text(r), i = space(), o = text(s), attr(e, "class", "tag-light");
  }, m(t4, r2) {
    insert(t4, e, r2), append(e, n), append(e, i), append(e, o);
  }, p(t4, e2) {
    1 & e2 && r !== (r = (t4[0].dexCap > 0 ? `+${t4[0].dexCap}` : t4[0].dexCap) + "") && set_data(n, r);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_if_block_2$6(t3) {
  let e, n, i, o, r = (t3[0].checkPenalty > 0 ? `+${t3[0].checkPenalty}` : t3[0].checkPenalty) + "", s = i18n("PF2E.ArmorCheckLabel") + "";
  return { c() {
    e = element("span"), n = text(r), i = space(), o = text(s), attr(e, "class", "tag-light");
  }, m(t4, r2) {
    insert(t4, e, r2), append(e, n), append(e, i), append(e, o);
  }, p(t4, e2) {
    1 & e2 && r !== (r = (t4[0].checkPenalty > 0 ? `+${t4[0].checkPenalty}` : t4[0].checkPenalty) + "") && set_data(n, r);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_if_block_1$a(t3) {
  let e, n, i, o, r = (t3[0].speedPenalty > 0 ? `+${t3[0].speedPenalty}` : t3[0].speedPenalty) + "", s = i18n("PF2E.ArmorSpeedLabel") + "";
  return { c() {
    e = element("span"), n = text(r), i = space(), o = text(s), attr(e, "class", "tag-light");
  }, m(t4, r2) {
    insert(t4, e, r2), append(e, n), append(e, i), append(e, o);
  }, p(t4, e2) {
    1 & e2 && r !== (r = (t4[0].speedPenalty > 0 ? `+${t4[0].speedPenalty}` : t4[0].speedPenalty) + "") && set_data(n, r);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_if_block$i(t3) {
  let e, n, i, o, r = i18n("PF2E.ArmorStrengthLabel") + "", s = t3[0].strength + "";
  return { c() {
    e = element("span"), n = text(r), i = space(), o = text(s), attr(e, "class", "tag-light");
  }, m(t4, r2) {
    insert(t4, e, r2), append(e, n), append(e, i), append(e, o);
  }, p(t4, e2) {
    1 & e2 && s !== (s = t4[0].strength + "") && set_data(o, s);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_fragment$v(t3) {
  let e, n, i, o, r, s, a, c = [], l = /* @__PURE__ */ new Map(), p = ensure_array_like(t3[2]);
  const u = (t4) => t4[4];
  for (let e2 = 0; e2 < p.length; e2 += 1) {
    let n2 = get_each_context$b(t3, p, e2), i2 = u(n2);
    l.set(i2, c[e2] = create_each_block$b(i2, n2));
  }
  let d = t3[0].acBonus && create_if_block_5$3(t3), m = t3[0].category && create_if_block_4$4(t3), h = t3[0].dexCap && create_if_block_3$5(t3), f = t3[0].checkPenalty && create_if_block_2$6(t3), g = t3[0].speedPenalty && create_if_block_1$a(t3), _ = t3[0].strength > 0 && create_if_block$i(t3);
  return { c() {
    e = element("section");
    for (let t4 = 0; t4 < c.length; t4 += 1) c[t4].c();
    n = space(), d && d.c(), i = space(), m && m.c(), o = space(), h && h.c(), r = space(), f && f.c(), s = space(), g && g.c(), a = space(), _ && _.c(), attr(e, "class", "properties");
  }, m(t4, l2) {
    insert(t4, e, l2);
    for (let t5 = 0; t5 < c.length; t5 += 1) c[t5] && c[t5].m(e, null);
    append(e, n), d && d.m(e, null), append(e, i), m && m.m(e, null), append(e, o), h && h.m(e, null), append(e, r), f && f.m(e, null), append(e, s), g && g.m(e, null), append(e, a), _ && _.m(e, null);
  }, p(t4, [b]) {
    6 & b && (p = ensure_array_like(t4[2]), c = update_keyed_each(c, b, u, 1, t4, p, l, e, destroy_block, create_each_block$b, n, get_each_context$b)), t4[0].acBonus ? d ? d.p(t4, b) : (d = create_if_block_5$3(t4), d.c(), d.m(e, i)) : d && (d.d(1), d = null), t4[0].category ? m ? m.p(t4, b) : (m = create_if_block_4$4(t4), m.c(), m.m(e, o)) : m && (m.d(1), m = null), t4[0].dexCap ? h ? h.p(t4, b) : (h = create_if_block_3$5(t4), h.c(), h.m(e, r)) : h && (h.d(1), h = null), t4[0].checkPenalty ? f ? f.p(t4, b) : (f = create_if_block_2$6(t4), f.c(), f.m(e, s)) : f && (f.d(1), f = null), t4[0].speedPenalty ? g ? g.p(t4, b) : (g = create_if_block_1$a(t4), g.c(), g.m(e, a)) : g && (g.d(1), g = null), t4[0].strength > 0 ? _ ? _.p(t4, b) : (_ = create_if_block$i(t4), _.c(), _.m(e, null)) : _ && (_.d(1), _ = null);
  }, i: noop, o: noop, d(t4) {
    t4 && detach(e);
    for (let t5 = 0; t5 < c.length; t5 += 1) c[t5].d();
    d && d.d(), m && m.d(), h && h.d(), f && f.d(), g && g.d(), _ && _.d();
  } };
}
function instance$v(t3, e, n) {
  var i;
  let { itemData: o } = e;
  const r = CONFIG.PF2E, s = null === (i = o.traits) || void 0 === i ? void 0 : i.value;
  return t3.$$set = (t4) => {
    "itemData" in t4 && n(0, o = t4.itemData);
  }, [o, r, s];
}
class Pf2eArmorProperties extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$v, create_fragment$v, safe_not_equal, { itemData: 0 });
  }
}
function get_each_context$a(t3, e, n) {
  const i = t3.slice();
  return i[4] = e[n], i;
}
function create_each_block$a(t3, e) {
  let n;
  return { key: t3, first: null, c() {
    n = element("span"), n.textContent = `${i18n(e[2].weaponTraits[e[4]])}`, attr(n, "class", "tag"), this.first = n;
  }, m(t4, e2) {
    insert(t4, n, e2);
  }, p(t4, n2) {
    e = t4;
  }, d(t4) {
    t4 && detach(n);
  } };
}
function create_if_block_2$5(t3) {
  let e, n, i = i18n(t3[2].npcAttackTraits["range-increment-" + t3[0].range]) + "";
  return { c() {
    e = element("span"), n = text(i), attr(e, "class", "tag-light");
  }, m(t4, i2) {
    insert(t4, e, i2), append(e, n);
  }, p(t4, e2) {
    1 & e2 && i !== (i = i18n(t4[2].npcAttackTraits["range-increment-" + t4[0].range]) + "") && set_data(n, i);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_if_block_1$9(t3) {
  let e, n, i = i18n(t3[2].weaponCategories[t3[0].category]) + "";
  return { c() {
    e = element("span"), n = text(i), attr(e, "class", "tag-light");
  }, m(t4, i2) {
    insert(t4, e, i2), append(e, n);
  }, p(t4, e2) {
    1 & e2 && i !== (i = i18n(t4[2].weaponCategories[t4[0].category]) + "") && set_data(n, i);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_if_block$h(t3) {
  let e, n, i = t3[0].reload.label + "";
  return { c() {
    e = element("span"), n = text(i), attr(e, "class", "tag-light");
  }, m(t4, i2) {
    insert(t4, e, i2), append(e, n);
  }, p(t4, e2) {
    1 & e2 && i !== (i = t4[0].reload.label + "") && set_data(n, i);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_fragment$u(t3) {
  let e, n, i, o, r = [], s = /* @__PURE__ */ new Map(), a = ensure_array_like(t3[1]);
  const c = (t4) => t4[4];
  for (let e2 = 0; e2 < a.length; e2 += 1) {
    let n2 = get_each_context$a(t3, a, e2), i2 = c(n2);
    s.set(i2, r[e2] = create_each_block$a(i2, n2));
  }
  let l = t3[0].range && create_if_block_2$5(t3), p = t3[0].category && create_if_block_1$9(t3), u = t3[0].reload && create_if_block$h(t3);
  return { c() {
    e = element("section");
    for (let t4 = 0; t4 < r.length; t4 += 1) r[t4].c();
    n = space(), l && l.c(), i = space(), p && p.c(), o = space(), u && u.c(), attr(e, "class", "properties");
  }, m(t4, s2) {
    insert(t4, e, s2);
    for (let t5 = 0; t5 < r.length; t5 += 1) r[t5] && r[t5].m(e, null);
    append(e, n), l && l.m(e, null), append(e, i), p && p.m(e, null), append(e, o), u && u.m(e, null);
  }, p(t4, [d]) {
    6 & d && (a = ensure_array_like(t4[1]), r = update_keyed_each(r, d, c, 1, t4, a, s, e, destroy_block, create_each_block$a, n, get_each_context$a)), t4[0].range ? l ? l.p(t4, d) : (l = create_if_block_2$5(t4), l.c(), l.m(e, i)) : l && (l.d(1), l = null), t4[0].category ? p ? p.p(t4, d) : (p = create_if_block_1$9(t4), p.c(), p.m(e, o)) : p && (p.d(1), p = null), t4[0].reload ? u ? u.p(t4, d) : (u = create_if_block$h(t4), u.c(), u.m(e, null)) : u && (u.d(1), u = null);
  }, i: noop, o: noop, d(t4) {
    t4 && detach(e);
    for (let t5 = 0; t5 < r.length; t5 += 1) r[t5].d();
    l && l.d(), p && p.d(), u && u.d();
  } };
}
function instance$u(t3, e, n) {
  var i;
  let { itemData: o } = e;
  const r = null === (i = o.traits) || void 0 === i ? void 0 : i.value, s = CONFIG.PF2E;
  return t3.$$set = (t4) => {
    "itemData" in t4 && n(0, o = t4.itemData);
  }, [o, r, s];
}
class Pf2eWeaponProperties extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$u, create_fragment$u, safe_not_equal, { itemData: 0 });
  }
}
function get_each_context$9(t3, e, n) {
  const i = t3.slice();
  return i[4] = e[n], i;
}
function create_each_block$9(t3, e) {
  let n;
  return { key: t3, first: null, c() {
    n = element("span"), n.textContent = `${i18n(e[1].consumableTraits[e[4]])}`, attr(n, "class", "tag"), this.first = n;
  }, m(t4, e2) {
    insert(t4, n, e2);
  }, p(t4, n2) {
    e = t4;
  }, d(t4) {
    t4 && detach(n);
  } };
}
function create_if_block_3$4(t3) {
  let e, n, i = i18n(t3[1].consumableCategories[t3[0].category]) + "";
  return { c() {
    e = element("span"), n = text(i), attr(e, "class", "tag-light");
  }, m(t4, i2) {
    insert(t4, e, i2), append(e, n);
  }, p(t4, e2) {
    1 & e2 && i !== (i = i18n(t4[1].consumableCategories[t4[0].category]) + "") && set_data(n, i);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_if_block$g(t3) {
  let e, n, i, o, r, s = t3[0].damage.formula + "", a = i18n(t3[1].damageTypes[t3[0].damage.type]) + "";
  function c(t4, e2) {
    return "damage" === t4[0].damage.kind ? create_if_block_1$8 : "healing" === t4[0].damage.kind ? create_if_block_2$4 : create_else_block$5;
  }
  let l = c(t3), p = l(t3);
  return { c() {
    e = element("p"), p.c(), n = space(), i = text(s), o = space(), r = text(a);
  }, m(t4, s2) {
    insert(t4, e, s2), p.m(e, null), append(e, n), append(e, i), append(e, o), append(e, r);
  }, p(t4, o2) {
    l !== (l = c(t4)) && (p.d(1), p = l(t4), p && (p.c(), p.m(e, n))), 1 & o2 && s !== (s = t4[0].damage.formula + "") && set_data(i, s), 1 & o2 && a !== (a = i18n(t4[1].damageTypes[t4[0].damage.type]) + "") && set_data(r, a);
  }, d(t4) {
    t4 && detach(e), p.d();
  } };
}
function create_else_block$5(t3) {
  let e;
  return { c() {
    e = element("b"), e.textContent = `${i18n("TYPES.Item.effect")}:`;
  }, m(t4, n) {
    insert(t4, e, n);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_if_block_2$4(t3) {
  let e;
  return { c() {
    e = element("b"), e.textContent = `${i18n("PF2E.TraitHealing")}:`;
  }, m(t4, n) {
    insert(t4, e, n);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_if_block_1$8(t3) {
  let e;
  return { c() {
    e = element("b"), e.textContent = `${i18n("PF2E.DamageLabel")}:`;
  }, m(t4, n) {
    insert(t4, e, n);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_fragment$t(t3) {
  let e, n, i, o, r = [], s = /* @__PURE__ */ new Map(), a = ensure_array_like(t3[2]);
  const c = (t4) => t4[4];
  for (let e2 = 0; e2 < a.length; e2 += 1) {
    let n2 = get_each_context$9(t3, a, e2), i2 = c(n2);
    s.set(i2, r[e2] = create_each_block$9(i2, n2));
  }
  let l = t3[0].category && create_if_block_3$4(t3), p = t3[0].damage?.formula && create_if_block$g(t3);
  return { c() {
    e = element("section");
    for (let t4 = 0; t4 < r.length; t4 += 1) r[t4].c();
    n = space(), l && l.c(), i = space(), p && p.c(), o = empty(), attr(e, "class", "properties");
  }, m(t4, s2) {
    insert(t4, e, s2);
    for (let t5 = 0; t5 < r.length; t5 += 1) r[t5] && r[t5].m(e, null);
    append(e, n), l && l.m(e, null), insert(t4, i, s2), p && p.m(t4, s2), insert(t4, o, s2);
  }, p(t4, [i2]) {
    6 & i2 && (a = ensure_array_like(t4[2]), r = update_keyed_each(r, i2, c, 1, t4, a, s, e, destroy_block, create_each_block$9, n, get_each_context$9)), t4[0].category ? l ? l.p(t4, i2) : (l = create_if_block_3$4(t4), l.c(), l.m(e, null)) : l && (l.d(1), l = null), t4[0].damage?.formula ? p ? p.p(t4, i2) : (p = create_if_block$g(t4), p.c(), p.m(o.parentNode, o)) : p && (p.d(1), p = null);
  }, i: noop, o: noop, d(t4) {
    t4 && (detach(e), detach(i), detach(o));
    for (let t5 = 0; t5 < r.length; t5 += 1) r[t5].d();
    l && l.d(), p && p.d(t4);
  } };
}
function instance$t(t3, e, n) {
  var i;
  let { itemData: o } = e;
  const r = CONFIG.PF2E, s = null === (i = o.traits) || void 0 === i ? void 0 : i.value;
  return t3.$$set = (t4) => {
    "itemData" in t4 && n(0, o = t4.itemData);
  }, [o, r, s];
}
class Pf2eConsumableProperties extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$t, create_fragment$t, safe_not_equal, { itemData: 0 });
  }
}
function create_else_block$4(t3) {
  let e, n;
  return { c() {
    e = element("i"), attr(e, "class", n = null_to_empty("fa-solid " + t3[1]) + " svelte-mobile-companion-pf2e-v340n8-sumfqy");
  }, m(t4, n2) {
    insert(t4, e, n2);
  }, p(t4, i) {
    2 & i && n !== (n = null_to_empty("fa-solid " + t4[1]) + " svelte-mobile-companion-pf2e-v340n8-sumfqy") && attr(e, "class", n);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_if_block$f(t3) {
  let e, n, i, o, r = t3[2] && create_if_block_1$7(t3);
  return { c() {
    e = element("span"), n = element("i"), o = space(), r && r.c(), attr(n, "class", i = null_to_empty("fa-solid " + t3[1]) + " svelte-mobile-companion-pf2e-v340n8-sumfqy"), attr(e, "class", "fa-stack fa-fw fa-2xs svelte-mobile-companion-pf2e-v340n8-sumfqy");
  }, m(t4, i2) {
    insert(t4, e, i2), append(e, n), append(e, o), r && r.m(e, null);
  }, p(t4, o2) {
    2 & o2 && i !== (i = null_to_empty("fa-solid " + t4[1]) + " svelte-mobile-companion-pf2e-v340n8-sumfqy") && attr(n, "class", i), t4[2] ? r ? r.p(t4, o2) : (r = create_if_block_1$7(t4), r.c(), r.m(e, null)) : r && (r.d(1), r = null);
  }, d(t4) {
    t4 && detach(e), r && r.d();
  } };
}
function create_if_block_1$7(t3) {
  let e, n;
  return { c() {
    e = element("i"), attr(e, "class", n = null_to_empty("fa-solid " + t3[2]) + " svelte-mobile-companion-pf2e-v340n8-sumfqy");
  }, m(t4, n2) {
    insert(t4, e, n2);
  }, p(t4, i) {
    4 & i && n !== (n = null_to_empty("fa-solid " + t4[2]) + " svelte-mobile-companion-pf2e-v340n8-sumfqy") && attr(e, "class", n);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_fragment$s(t3) {
  let e;
  function n(t4, e2) {
    return t4[0] === CarryType.HELD ? create_if_block$f : create_else_block$4;
  }
  let i = n(t3), o = i(t3);
  return { c() {
    e = element("span"), o.c(), attr(e, "class", "item-carry-type svelte-mobile-companion-pf2e-v340n8-sumfqy");
  }, m(t4, n2) {
    insert(t4, e, n2), o.m(e, null);
  }, p(t4, [r]) {
    i === (i = n(t4)) && o ? o.p(t4, r) : (o.d(1), o = i(t4), o && (o.c(), o.m(e, null)));
  }, i: noop, o: noop, d(t4) {
    t4 && detach(e), o.d();
  } };
}
function instance$s(t3, e, n) {
  let i, o, r, s, { item: a } = e;
  return t3.$$set = (t4) => {
    "item" in t4 && n(3, a = t4.item);
  }, t3.$$.update = () => {
    if (8 & t3.$$.dirty && n(0, i = a.system.equipped.carryType), 8 & t3.$$.dirty && n(4, o = a.system.equipped.handsHeld), 17 & t3.$$.dirty) switch (i) {
      case CarryType.HELD:
        n(1, r = "fa-hand-back-fist fa-stack-2x"), n(2, s = 1 === o ? "fa-1 fa-inverse fa-stack-1x" : "fa-2 fa-inverse fa-stack-1x");
        break;
      case CarryType.WORN:
        n(1, r = "fa-tshirt fa-fw");
        break;
      case CarryType.STOWED:
        n(1, r = "fa-box fa-fw");
        break;
      case CarryType.DROPPED:
        n(1, r = "fa-grip-lines fa-fw");
        break;
      case CarryType.ATTACHED:
        n(1, r = "fa-paperclip fa-fw");
    }
  }, [i, r, s, a, o];
}
class Pf2eCarryTypeIcon extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$s, create_fragment$s, safe_not_equal, { item: 3 });
  }
}
function create_if_block$e(t3) {
  let e, n, i, o, r = t3[0].hands + "";
  return { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("PF2E.Item.Weapon.HandsLabel")}:`, i = space(), o = text(r);
  }, m(t4, r2) {
    insert(t4, e, r2), append(e, n), append(e, i), append(e, o);
  }, p(t4, e2) {
    1 & e2 && r !== (r = t4[0].hands + "") && set_data(o, r);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_fragment$r(t3) {
  let e, n, i, o, r, s, a, c, l, p, u, d, m = i18n("PF2E.CarryType." + t3[1]) + "";
  s = new Pf2eCarryTypeIcon({ props: { item: t3[0] } });
  let h = t3[0].hands && create_if_block$e(t3);
  return { c() {
    e = element("div"), n = element("div"), i = element("b"), i.textContent = `${i18n("PF2E.Actor.Inventory.CarryType.OpenMenu")}:`, o = space(), r = element("span"), create_component(s.$$.fragment), a = space(), c = text(m), l = space(), h && h.c(), attr(r, "aria-hidden", "true"), attr(n, "class", "carry-type svelte-mobile-companion-pf2e-v340n8-e20up");
  }, m(m2, f) {
    insert(m2, e, f), append(e, n), append(n, i), append(n, o), append(n, r), mount_component(s, r, null), append(r, a), append(r, c), append(e, l), h && h.m(e, null), p = true, u || (d = listen(r, "click", prevent_default(t3[2])), u = true);
  }, p(t4, [n2]) {
    const i2 = {};
    1 & n2 && (i2.item = t4[0]), s.$set(i2), (!p || 2 & n2) && m !== (m = i18n("PF2E.CarryType." + t4[1]) + "") && set_data(c, m), t4[0].hands ? h ? h.p(t4, n2) : (h = create_if_block$e(t4), h.c(), h.m(e, null)) : h && (h.d(1), h = null);
  }, i(t4) {
    p || (transition_in(s.$$.fragment, t4), p = true);
  }, o(t4) {
    transition_out(s.$$.fragment, t4), p = false;
  }, d(t4) {
    t4 && detach(e), destroy_component(s), h && h.d(), u = false, d();
  } };
}
function instance$r(t3, e, n) {
  let i, o, r, { item: s } = e;
  const a = [{ carryType: CarryType.HELD, handsHeld: 1, inSlot: true }, { carryType: CarryType.HELD, handsHeld: 2, inSlot: true }, { carryType: CarryType.STOWED, handsHeld: 0, inSlot: true }, { carryType: CarryType.DROPPED, handsHeld: 0, inSlot: true }, { carryType: CarryType.WORN, handsHeld: 0, inSlot: true }];
  return s.isAttachable, t3.$$set = (t4) => {
    "item" in t4 && n(0, s = t4.item);
  }, t3.$$.update = () => {
    1 & t3.$$.dirty && n(4, i = s.system.equipped.carryType), 1 & t3.$$.dirty && n(3, o = s.system.equipped.handsHeld), 24 & t3.$$.dirty && n(1, r = o > 0 ? i + o : i);
  }, [s, r, function() {
    const t4 = function() {
      const t5 = (a.findIndex((t6) => t6.carryType === i && t6.handsHeld === o) + 1) % a.length;
      return a[t5];
    }();
    s.actor.changeCarryType(s, t4);
  }, o, i];
}
class Pf2eCarryType extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$r, create_fragment$r, safe_not_equal, { item: 0 });
  }
}
function create_fragment$q(t3) {
  let e;
  return { c() {
    e = element("i"), attr(e, "class", "fa-solid fa-gem fa-fw icon svelte-mobile-companion-pf2e-v340n8-jx0jgx"), toggle_class(e, "active", t3[0]);
  }, m(t4, n) {
    insert(t4, e, n);
  }, p(t4, [n]) {
    1 & n && toggle_class(e, "active", t4[0]);
  }, i: noop, o: noop, d(t4) {
    t4 && detach(e);
  } };
}
function instance$q(t3, e, n) {
  let { isInvested: i } = e;
  return t3.$$set = (t4) => {
    "isInvested" in t4 && n(0, i = t4.isInvested);
  }, [i];
}
class Pf2eInvestedIcon extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$q, create_fragment$q, safe_not_equal, { isInvested: 0 });
  }
}
function create_fragment$p(t3) {
  let e, n, i, o, r, s, a, c;
  return r = new Pf2eInvestedIcon({ props: { isInvested: t3[0].isInvested } }), { c() {
    e = element("p"), n = element("b"), n.textContent = `${i18n("PF2E.ui.equipmentInvested")}:`, i = space(), o = element("span"), create_component(r.$$.fragment), attr(o, "aria-hidden", "true");
  }, m(l, p) {
    insert(l, e, p), append(e, n), append(e, i), append(e, o), mount_component(r, o, null), s = true, a || (c = listen(o, "click", prevent_default(t3[1])), a = true);
  }, p(t4, [e2]) {
    const n2 = {};
    1 & e2 && (n2.isInvested = t4[0].isInvested), r.$set(n2);
  }, i(t4) {
    s || (transition_in(r.$$.fragment, t4), s = true);
  }, o(t4) {
    transition_out(r.$$.fragment, t4), s = false;
  }, d(t4) {
    t4 && detach(e), destroy_component(r), a = false, c();
  } };
}
function instance$p(t3, e, n) {
  let { item: i } = e;
  return t3.$$set = (t4) => {
    "item" in t4 && n(0, i = t4.item);
  }, [i, function() {
    i.actor.toggleInvested(i.id);
  }];
}
class Pf2eInvestment extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$p, create_fragment$p, safe_not_equal, { item: 0 });
  }
}
function get_each_context$8(t3, e, n) {
  const i = t3.slice();
  return i[4] = e[n], i;
}
function create_each_block$8(t3, e) {
  let n;
  return { key: t3, first: null, c() {
    n = element("span"), n.textContent = `${i18n(e[0].equipmentTraits[e[4]])}`, attr(n, "class", "tag"), this.first = n;
  }, m(t4, e2) {
    insert(t4, n, e2);
  }, p(t4, n2) {
    e = t4;
  }, d(t4) {
    t4 && detach(n);
  } };
}
function create_fragment$o(t3) {
  let e, n = [], i = /* @__PURE__ */ new Map(), o = ensure_array_like(t3[1]);
  const r = (t4) => t4[4];
  for (let e2 = 0; e2 < o.length; e2 += 1) {
    let s = get_each_context$8(t3, o, e2), a = r(s);
    i.set(a, n[e2] = create_each_block$8(a, s));
  }
  return { c() {
    e = element("section");
    for (let t4 = 0; t4 < n.length; t4 += 1) n[t4].c();
    attr(e, "class", "properties");
  }, m(t4, i2) {
    insert(t4, e, i2);
    for (let t5 = 0; t5 < n.length; t5 += 1) n[t5] && n[t5].m(e, null);
  }, p(t4, [s]) {
    3 & s && (o = ensure_array_like(t4[1]), n = update_keyed_each(n, s, r, 1, t4, o, i, e, destroy_block, create_each_block$8, null, get_each_context$8));
  }, i: noop, o: noop, d(t4) {
    t4 && detach(e);
    for (let t5 = 0; t5 < n.length; t5 += 1) n[t5].d();
  } };
}
function instance$o(t3, e, n) {
  var i;
  let { itemData: o } = e;
  const r = CONFIG.PF2E, s = null === (i = o.traits) || void 0 === i ? void 0 : i.value;
  return t3.$$set = (t4) => {
    "itemData" in t4 && n(2, o = t4.itemData);
  }, [r, s, o];
}
class Pf2eEquipmentProperties extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$o, create_fragment$o, safe_not_equal, { itemData: 2 });
  }
}
function get_each_context$7(t3, e, n) {
  const i = t3.slice();
  return i[4] = e[n], i;
}
function create_each_block$7(t3, e) {
  let n;
  return { key: t3, first: null, c() {
    n = element("span"), n.textContent = `${i18n(e[1].shieldTraits[e[4]])}`, attr(n, "class", "tag"), this.first = n;
  }, m(t4, e2) {
    insert(t4, n, e2);
  }, p(t4, n2) {
    e = t4;
  }, d(t4) {
    t4 && detach(n);
  } };
}
function create_if_block$d(t3) {
  let e, n, i, o, r, s = t3[0].acBonus + "", a = i18n("PF2E.ArmorArmorLabel") + "";
  return { c() {
    e = element("span"), n = text("+"), i = text(s), o = space(), r = text(a), attr(e, "class", "tag-light");
  }, m(t4, s2) {
    insert(t4, e, s2), append(e, n), append(e, i), append(e, o), append(e, r);
  }, p(t4, e2) {
    1 & e2 && s !== (s = t4[0].acBonus + "") && set_data(i, s);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_fragment$n(t3) {
  let e, n, i = [], o = /* @__PURE__ */ new Map(), r = ensure_array_like(t3[2]);
  const s = (t4) => t4[4];
  for (let e2 = 0; e2 < r.length; e2 += 1) {
    let n2 = get_each_context$7(t3, r, e2), a2 = s(n2);
    o.set(a2, i[e2] = create_each_block$7(a2, n2));
  }
  let a = t3[0].acBonus && create_if_block$d(t3);
  return { c() {
    e = element("section");
    for (let t4 = 0; t4 < i.length; t4 += 1) i[t4].c();
    n = space(), a && a.c(), attr(e, "class", "properties");
  }, m(t4, o2) {
    insert(t4, e, o2);
    for (let t5 = 0; t5 < i.length; t5 += 1) i[t5] && i[t5].m(e, null);
    append(e, n), a && a.m(e, null);
  }, p(t4, [c]) {
    6 & c && (r = ensure_array_like(t4[2]), i = update_keyed_each(i, c, s, 1, t4, r, o, e, destroy_block, create_each_block$7, n, get_each_context$7)), t4[0].acBonus ? a ? a.p(t4, c) : (a = create_if_block$d(t4), a.c(), a.m(e, null)) : a && (a.d(1), a = null);
  }, i: noop, o: noop, d(t4) {
    t4 && detach(e);
    for (let t5 = 0; t5 < i.length; t5 += 1) i[t5].d();
    a && a.d();
  } };
}
function instance$n(t3, e, n) {
  var i;
  let { itemData: o } = e;
  const r = CONFIG.PF2E, s = null === (i = o.traits) || void 0 === i ? void 0 : i.value;
  return t3.$$set = (t4) => {
    "itemData" in t4 && n(0, o = t4.itemData);
  }, [o, r, s];
}
class Pf2eShieldProperties extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$n, create_fragment$n, safe_not_equal, { itemData: 0 });
  }
}
function create_fragment$m(t3) {
  let e, n, i;
  return { c() {
    e = element("input"), attr(e, "class", t3[3]), attr(e, "min", t3[4]), attr(e, "max", t3[5]), attr(e, "id", t3[1]), attr(e, "name", t3[2]), attr(e, "inputmode", "text"), attr(e, "pattern", "[0-9+\\-]*");
  }, m(o, r) {
    insert(o, e, r), set_input_value(e, t3[0]), n || (i = [listen(e, "change", t3[6]), listen(e, "input", restrictInput), listen(e, "input", t3[7])], n = true);
  }, p(t4, [n2]) {
    8 & n2 && attr(e, "class", t4[3]), 16 & n2 && attr(e, "min", t4[4]), 32 & n2 && attr(e, "max", t4[5]), 2 & n2 && attr(e, "id", t4[1]), 4 & n2 && attr(e, "name", t4[2]), 1 & n2 && e.value !== t4[0] && set_input_value(e, t4[0]);
  }, i: noop, o: noop, d(t4) {
    t4 && detach(e), n = false, run_all(i);
  } };
}
function restrictInput(t3) {
  const e = t3.target;
  e.value = e.value.replace(/[^0-9+\-]/g, "");
}
function instance$m($$self, $$props, $$invalidate) {
  let { value = 0 } = $$props, { id = "" } = $$props, { name = "" } = $$props, { styleClass = "" } = $$props, { min } = $$props, { max } = $$props, previousValue = value;
  const dispatch = createEventDispatcher();
  function handleInputChange(event) {
    const target = event.target;
    let newValue = target.value;
    try {
      /^[+\-]/.test(newValue) && (newValue = `${previousValue}${newValue}`);
      let result = Math.floor(eval(newValue));
      void 0 !== max && (result = Math.min(result, max)), void 0 !== min && (result = Math.max(result, min)), previousValue = result, $$invalidate(0, value = result), dispatch("change", { value: result, name });
    } catch (t3) {
    }
  }
  function input_input_handler() {
    value = this.value, $$invalidate(0, value);
  }
  return $$self.$$set = (t3) => {
    "value" in t3 && $$invalidate(0, value = t3.value), "id" in t3 && $$invalidate(1, id = t3.id), "name" in t3 && $$invalidate(2, name = t3.name), "styleClass" in t3 && $$invalidate(3, styleClass = t3.styleClass), "min" in t3 && $$invalidate(4, min = t3.min), "max" in t3 && $$invalidate(5, max = t3.max);
  }, $$self.$$.update = () => {
    1 & $$self.$$.dirty && $$invalidate(0, value);
  }, [value, id, name, styleClass, min, max, handleInputChange, input_input_handler];
}
class EvaluatingInput extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$m, create_fragment$m, safe_not_equal, { value: 0, id: 1, name: 2, styleClass: 3, min: 4, max: 5 });
  }
}
function enable() {
  const t3 = document.body, e = t3.requestFullscreen || t3.webkitRequestFullscreen || t3.mozRequestFullScreen || t3.msRequestFullscreen;
  if (e) e.call(t3);
  else if (void 0 !== window.ActiveXObject) {
    const t4 = new ActiveXObject("WScript.Shell");
    null !== t4 && t4.SendKeys("{F11}");
  }
}
function disable() {
  const t3 = document, e = t3.exitFullscreen || t3.webkitExitFullscreen || t3.mozCancelFullScreen || t3.msExitFullscreen;
  if (e) e.call(document);
  else if (void 0 !== window.ActiveXObject) {
    const t4 = new ActiveXObject("WScript.Shell");
    null !== t4 && t4.SendKeys("{F11}");
  }
}
function toggleFullscreen() {
  const t3 = document;
  t3.fullscreenElement || t3.webkitFullscreenElement || t3.mozFullScreenElement || t3.msFullscreenElement ? disable() : enable();
}
function get_each_context$6(t3, e, n) {
  const i = t3.slice();
  return i[9] = e[n], i;
}
function create_each_block$6(t3) {
  let e, n, i, o, r, s, a, c;
  function l() {
    return t3[8](t3[9]);
  }
  return { c() {
    e = element("button"), n = element("i"), o = space(), attr(n, "class", i = null_to_empty(t3[9].iconClass) + " svelte-mobile-companion-pf2e-v340n8-v7dqul"), attr(n, "aria-hidden", "true"), toggle_class(n, "active", t3[9].id.includes(t3[2])), attr(e, "class", r = "icon-button " + t3[9].buttonClass + " svelte-mobile-companion-pf2e-v340n8-v7dqul"), attr(e, "aria-label", s = t3[9].label ? t3[9].label : null), toggle_class(e, "active", t3[9].id.includes(t3[2]));
  }, m(t4, i2) {
    insert(t4, e, i2), append(e, n), append(e, o), a || (c = listen(e, "click", prevent_default(l)), a = true);
  }, p(o2, a2) {
    t3 = o2, 1 & a2 && i !== (i = null_to_empty(t3[9].iconClass) + " svelte-mobile-companion-pf2e-v340n8-v7dqul") && attr(n, "class", i), 5 & a2 && toggle_class(n, "active", t3[9].id.includes(t3[2])), 1 & a2 && r !== (r = "icon-button " + t3[9].buttonClass + " svelte-mobile-companion-pf2e-v340n8-v7dqul") && attr(e, "class", r), 1 & a2 && s !== (s = t3[9].label ? t3[9].label : null) && attr(e, "aria-label", s), 5 & a2 && toggle_class(e, "active", t3[9].id.includes(t3[2]));
  }, d(t4) {
    t4 && detach(e), a = false, c();
  } };
}
function create_if_block$c(t3) {
  let e, n, i, o, r, s, a, c, l, p = t3[3] && create_if_block_1$6(t3);
  return { c() {
    e = element("div"), n = element("button"), i = element("i"), s = space(), p && p.c(), a = empty(), attr(i, "class", o = "fa-solid fa-bars " + t3[1]?.iconClass + " svelte-mobile-companion-pf2e-v340n8-v7dqul"), attr(i, "aria-hidden", "true"), attr(n, "class", r = "icon-button " + t3[1]?.buttonClass + " svelte-mobile-companion-pf2e-v340n8-v7dqul"), attr(n, "aria-label", "Menu"), attr(e, "class", "main-buttons svelte-mobile-companion-pf2e-v340n8-v7dqul");
  }, m(o2, r2) {
    insert(o2, e, r2), append(e, n), append(n, i), insert(o2, s, r2), p && p.m(o2, r2), insert(o2, a, r2), c || (l = listen(n, "click", t3[6]), c = true);
  }, p(t4, e2) {
    2 & e2 && o !== (o = "fa-solid fa-bars " + t4[1]?.iconClass + " svelte-mobile-companion-pf2e-v340n8-v7dqul") && attr(i, "class", o), 2 & e2 && r !== (r = "icon-button " + t4[1]?.buttonClass + " svelte-mobile-companion-pf2e-v340n8-v7dqul") && attr(n, "class", r), t4[3] ? p ? (p.p(t4, e2), 8 & e2 && transition_in(p, 1)) : (p = create_if_block_1$6(t4), p.c(), transition_in(p, 1), p.m(a.parentNode, a)) : p && (group_outros(), transition_out(p, 1, 1, () => {
      p = null;
    }), check_outros());
  }, d(t4) {
    t4 && (detach(e), detach(s), detach(a)), p && p.d(t4), c = false, l();
  } };
}
function create_if_block_1$6(t3) {
  let e, n, i, o, r, s, a, c, l, p;
  return { c() {
    e = element("div"), n = element("div"), n.innerHTML = '<i class="fas fa-maximize"></i>Fullscreen', i = space(), o = element("div"), o.innerHTML = '<i class="fas fa-gears"></i>Settings', r = space(), s = element("div"), s.innerHTML = '<i class="fas fa-sign-out-alt"></i>Logout', attr(n, "class", "menu-button svelte-mobile-companion-pf2e-v340n8-v7dqul"), attr(n, "aria-hidden", "true"), attr(o, "class", "menu-button svelte-mobile-companion-pf2e-v340n8-v7dqul"), attr(o, "aria-hidden", "true"), attr(s, "class", "menu-button svelte-mobile-companion-pf2e-v340n8-v7dqul"), attr(s, "aria-hidden", "true"), attr(e, "class", "context-menu svelte-mobile-companion-pf2e-v340n8-v7dqul"), set_style(e, "top", t3[4].top + "px"), set_style(e, "left", t3[4].left + "px");
  }, m(a2, u) {
    insert(a2, e, u), append(e, n), append(e, i), append(e, o), append(e, r), append(e, s), c = true, l || (p = [listen(n, "click", toggleFullscreen), listen(o, "click", t3[7]), listen(s, "click", handleLogout)], l = true);
  }, p(t4, n2) {
    (!c || 16 & n2) && set_style(e, "top", t4[4].top + "px"), (!c || 16 & n2) && set_style(e, "left", t4[4].left + "px");
  }, i(t4) {
    c || (t4 && add_render_callback(() => {
      c && (a || (a = create_bidirectional_transition(e, slide, {}, true)), a.run(1));
    }), c = true);
  }, o(t4) {
    t4 && (a || (a = create_bidirectional_transition(e, slide, {}, false)), a.run(0)), c = false;
  }, d(t4) {
    t4 && detach(e), t4 && a && a.end(), l = false, run_all(p);
  } };
}
function create_fragment$l(t3) {
  let e, n, i, o, r, s, a = ensure_array_like(t3[0]), c = [];
  for (let e2 = 0; e2 < a.length; e2 += 1) c[e2] = create_each_block$6(get_each_context$6(t3, a, e2));
  let l = t3[1] && create_if_block$c(t3);
  return { c() {
    e = space(), n = element("header"), i = element("div");
    for (let t4 = 0; t4 < c.length; t4 += 1) c[t4].c();
    o = space(), l && l.c(), attr(i, "class", "custom-buttons svelte-mobile-companion-pf2e-v340n8-v7dqul"), attr(n, "class", "header svelte-mobile-companion-pf2e-v340n8-v7dqul");
  }, m(a2, p) {
    insert(a2, e, p), insert(a2, n, p), append(n, i);
    for (let t4 = 0; t4 < c.length; t4 += 1) c[t4] && c[t4].m(i, null);
    append(n, o), l && l.m(n, null), r || (s = listen(document.body, "click", t3[5]), r = true);
  }, p(t4, [e2]) {
    if (5 & e2) {
      let n2;
      for (a = ensure_array_like(t4[0]), n2 = 0; n2 < a.length; n2 += 1) {
        const o2 = get_each_context$6(t4, a, n2);
        c[n2] ? c[n2].p(o2, e2) : (c[n2] = create_each_block$6(o2), c[n2].c(), c[n2].m(i, null));
      }
      for (; n2 < c.length; n2 += 1) c[n2].d(1);
      c.length = a.length;
    }
    t4[1] ? l ? l.p(t4, e2) : (l = create_if_block$c(t4), l.c(), l.m(n, null)) : l && (l.d(1), l = null);
  }, i: noop, o: noop, d(t4) {
    t4 && (detach(e), detach(n)), destroy_each(c, t4), l && l.d(), r = false, s();
  } };
}
function handleLogout() {
  ui.menu.items.logout.onClick();
}
function handleButtonClick(t3) {
  t3.onClick();
}
function instance$l(t3, e, n) {
  let { customButtons: i = [] } = e, { menuButtons: o } = e, { activeFilter: r } = e, s = false, a = { top: 0, left: 0 };
  return t3.$$set = (t4) => {
    "customButtons" in t4 && n(0, i = t4.customButtons), "menuButtons" in t4 && n(1, o = t4.menuButtons), "activeFilter" in t4 && n(2, r = t4.activeFilter);
  }, [i, o, r, s, a, function() {
    s && n(3, s = false);
  }, function(t4) {
    if (t4.stopPropagation(), n(3, s = !s), s) {
      const e2 = t4.target.getBoundingClientRect(), i2 = -15, o2 = -100;
      n(4, a = { top: e2.bottom + window.scrollY + i2, left: e2.left + window.scrollX + o2 });
    }
  }, function(t4) {
    t4.stopPropagation(), game.settings.sheet && game.settings.sheet.close(), n(3, s = false), game.settings.sheet.render(true, { focus: true });
  }, (t4) => handleButtonClick(t4)];
}
class Header extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$l, create_fragment$l, safe_not_equal, { customButtons: 0, menuButtons: 1, activeFilter: 2 });
  }
}
function create_fragment$k(t3) {
  let e, n, i, o, r;
  const s = t3[5].default, a = create_slot(s, t3, t3[4], null);
  return { c() {
    e = element("button"), a && a.c(), attr(e, "class", n = null_to_empty(`mobile-companion-button ${t3[2]}`) + " svelte-mobile-companion-pf2e-v340n8-14hjf38"), attr(e, "type", t3[0]), e.disabled = t3[1];
  }, m(n2, s2) {
    insert(n2, e, s2), a && a.m(e, null), i = true, o || (r = listen(e, "click", t3[3]), o = true);
  }, p(t4, [o2]) {
    a && a.p && (!i || 16 & o2) && update_slot_base(a, s, t4, t4[4], i ? get_slot_changes(s, t4[4], o2, null) : get_all_dirty_from_scope(t4[4]), null), (!i || 4 & o2 && n !== (n = null_to_empty(`mobile-companion-button ${t4[2]}`) + " svelte-mobile-companion-pf2e-v340n8-14hjf38")) && attr(e, "class", n), (!i || 1 & o2) && attr(e, "type", t4[0]), (!i || 2 & o2) && (e.disabled = t4[1]);
  }, i(t4) {
    i || (transition_in(a, t4), i = true);
  }, o(t4) {
    transition_out(a, t4), i = false;
  }, d(t4) {
    t4 && detach(e), a && a.d(t4), o = false, r();
  } };
}
function instance$k(t3, e, n) {
  let { $$slots: i = {}, $$scope: o } = e, { type: r = "button" } = e, { disabled: s = false } = e, { customClass: a = "" } = e;
  const c = createEventDispatcher();
  return t3.$$set = (t4) => {
    "type" in t4 && n(0, r = t4.type), "disabled" in t4 && n(1, s = t4.disabled), "customClass" in t4 && n(2, a = t4.customClass), "$$scope" in t4 && n(4, o = t4.$$scope);
  }, [r, s, a, function(t4) {
    c("click", t4);
  }, o, i];
}
class MCButton extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$k, create_fragment$k, safe_not_equal, { type: 0, disabled: 1, customClass: 2 });
  }
}
function create_fragment$j(t3) {
  let e;
  return { c() {
    e = element("div"), e.innerHTML = '<div class="text-box svelte-mobile-companion-pf2e-v340n8-17yd3t9"><p class="svelte-mobile-companion-pf2e-v340n8-17yd3t9"><b>Available in pro version.</b></p> <p class="svelte-mobile-companion-pf2e-v340n8-17yd3t9">Please visit <a href="https://www.patreon.com/SyriousWorkshop" target="_blank">Syrious&#39;\n            Workshop</a></p></div>', attr(e, "class", "svelte-mobile-companion-pf2e-v340n8-17yd3t9"), toggle_class(e, "overlay", t3[0]);
  }, m(t4, n) {
    insert(t4, e, n);
  }, p(t4, [n]) {
    1 & n && toggle_class(e, "overlay", t4[0]);
  }, i: noop, o: noop, d(t4) {
    t4 && detach(e);
  } };
}
function instance$j(t3, e, n) {
  let { useOverlay: i = true } = e;
  return t3.$$set = (t4) => {
    "useOverlay" in t4 && n(0, i = t4.useOverlay);
  }, [i];
}
class ProOverlay extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$j, create_fragment$j, safe_not_equal, { useOverlay: 0 });
  }
}
function create_fragment$i(t3) {
  let e, n, i, o, r, s, a, c;
  return { c() {
    e = element("div"), n = element("button"), n.innerHTML = '<i class="fas fa-minus"></i>', i = space(), o = element("input"), r = space(), s = element("button"), s.innerHTML = '<i class="fas fa-plus"></i>', attr(n, "class", "adjustment-button svelte-mobile-companion-pf2e-v340n8-7x0de1"), attr(o, "class", "input svelte-mobile-companion-pf2e-v340n8-7x0de1"), attr(o, "type", "text"), o.value = t3[0], attr(o, "placeholder", "0"), attr(o, "inputmode", "numeric"), attr(o, "pattern", "[0-9+=\\-]*"), set_style(o, "font-family", t3[1]), attr(o, "min", "0"), attr(s, "class", "adjustment-button svelte-mobile-companion-pf2e-v340n8-7x0de1"), attr(e, "class", "item-quantity svelte-mobile-companion-pf2e-v340n8-7x0de1");
  }, m(l, p) {
    insert(l, e, p), append(e, n), append(e, i), append(e, o), append(e, r), append(e, s), a || (c = [listen(n, "click", t3[3]), listen(o, "input", t3[4]), listen(s, "click", t3[2])], a = true);
  }, p(t4, [e2]) {
    1 & e2 && o.value !== t4[0] && (o.value = t4[0]), 2 & e2 && set_style(o, "font-family", t4[1]);
  }, i: noop, o: noop, d(t4) {
    t4 && detach(e), a = false, run_all(c);
  } };
}
function instance$i(t3, e, n) {
  let { quantity: i = 0 } = e, { fontFamily: o = "monospace" } = e;
  const r = createEventDispatcher();
  return t3.$$set = (t4) => {
    "quantity" in t4 && n(0, i = t4.quantity), "fontFamily" in t4 && n(1, o = t4.fontFamily);
  }, [i, o, function() {
    n(0, i++, i), r("onQtyChange", { newValue: i });
  }, function() {
    i > 0 && (n(0, i--, i), r("onQtyChange", { newValue: i }));
  }, function(t4) {
    n(0, i = parseInt(t4.target.value || "0")), r("onQtyChange", { newValue: i });
  }];
}
class Quantity extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$i, create_fragment$i, safe_not_equal, { quantity: 0, fontFamily: 1 });
  }
}
function create_if_block_8$1(t3) {
  let e, n, i, o, r, s = t3[0].traits.has("invested");
  n = new Pf2eCarryTypeIcon({ props: { item: t3[0] } });
  let a = s && create_if_block_9$1(t3);
  return { c() {
    e = element("div"), create_component(n.$$.fragment), i = space(), a && a.c();
  }, m(t4, o2) {
    insert(t4, e, o2), mount_component(n, e, null), append(e, i), a && a.m(e, null), r = true;
  }, p(t4, i2) {
    const o2 = {};
    1 & i2 && (o2.item = t4[0]), n.$set(o2), 1 & i2 && (s = t4[0].traits.has("invested")), s ? a ? (a.p(t4, i2), 1 & i2 && transition_in(a, 1)) : (a = create_if_block_9$1(t4), a.c(), transition_in(a, 1), a.m(e, null)) : a && (group_outros(), transition_out(a, 1, 1, () => {
      a = null;
    }), check_outros());
  }, i(t4) {
    r || (transition_in(n.$$.fragment, t4), transition_in(a), t4 && add_render_callback(() => {
      r && (o || (o = create_bidirectional_transition(e, fade, { duration: 200 }, true)), o.run(1));
    }), r = true);
  }, o(t4) {
    transition_out(n.$$.fragment, t4), transition_out(a), t4 && (o || (o = create_bidirectional_transition(e, fade, { duration: 200 }, false)), o.run(0)), r = false;
  }, d(t4) {
    t4 && detach(e), destroy_component(n), a && a.d(), t4 && o && o.end();
  } };
}
function create_if_block_9$1(t3) {
  let e, n;
  return e = new Pf2eInvestedIcon({ props: { isInvested: t3[0].isInvested } }), { c() {
    create_component(e.$$.fragment);
  }, m(t4, i) {
    mount_component(e, t4, i), n = true;
  }, p(t4, n2) {
    const i = {};
    1 & n2 && (i.isInvested = t4[0].isInvested), e.$set(i);
  }, i(t4) {
    n || (transition_in(e.$$.fragment, t4), n = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), n = false;
  }, d(t4) {
    destroy_component(e, t4);
  } };
}
function create_if_block$b(t3) {
  let e, n, i, o, r, s, a, c, l, p, u, d, m, h = t3[0].traits.has("invested"), f = t3[0].type === ItemType.weapon && create_if_block_7$2(t3), g = t3[0].type === ItemType.shield && create_if_block_6$2(t3), _ = t3[0].type === ItemType.armor && create_if_block_5$2(t3), b = t3[0].type === ItemType.equipment && create_if_block_4$3(t3), y = t3[0].type === ItemType.consumable && create_if_block_3$3(t3);
  a = new Pf2eCarryType({ props: { item: t3[0] } });
  let v = h && create_if_block_2$3(t3), $2 = t3[5] && create_if_block_1$5(t3);
  return u = new Pf2eDescription({ props: { itemData: t3[2] } }), { c() {
    e = element("div"), f && f.c(), n = space(), g && g.c(), i = space(), _ && _.c(), o = space(), b && b.c(), r = space(), y && y.c(), s = space(), create_component(a.$$.fragment), c = space(), v && v.c(), l = space(), $2 && $2.c(), p = space(), create_component(u.$$.fragment);
  }, m(t4, d2) {
    insert(t4, e, d2), f && f.m(e, null), append(e, n), g && g.m(e, null), append(e, i), _ && _.m(e, null), append(e, o), b && b.m(e, null), append(e, r), y && y.m(e, null), append(e, s), mount_component(a, e, null), append(e, c), v && v.m(e, null), append(e, l), $2 && $2.m(e, null), append(e, p), mount_component(u, e, null), m = true;
  }, p(t4, c2) {
    t4[0].type === ItemType.weapon ? f ? (f.p(t4, c2), 1 & c2 && transition_in(f, 1)) : (f = create_if_block_7$2(t4), f.c(), transition_in(f, 1), f.m(e, n)) : f && (group_outros(), transition_out(f, 1, 1, () => {
      f = null;
    }), check_outros()), t4[0].type === ItemType.shield ? g ? (g.p(t4, c2), 1 & c2 && transition_in(g, 1)) : (g = create_if_block_6$2(t4), g.c(), transition_in(g, 1), g.m(e, i)) : g && (group_outros(), transition_out(g, 1, 1, () => {
      g = null;
    }), check_outros()), t4[0].type === ItemType.armor ? _ ? (_.p(t4, c2), 1 & c2 && transition_in(_, 1)) : (_ = create_if_block_5$2(t4), _.c(), transition_in(_, 1), _.m(e, o)) : _ && (group_outros(), transition_out(_, 1, 1, () => {
      _ = null;
    }), check_outros()), t4[0].type === ItemType.equipment ? b ? (b.p(t4, c2), 1 & c2 && transition_in(b, 1)) : (b = create_if_block_4$3(t4), b.c(), transition_in(b, 1), b.m(e, r)) : b && (group_outros(), transition_out(b, 1, 1, () => {
      b = null;
    }), check_outros()), t4[0].type === ItemType.consumable ? y ? (y.p(t4, c2), 1 & c2 && transition_in(y, 1)) : (y = create_if_block_3$3(t4), y.c(), transition_in(y, 1), y.m(e, s)) : y && (group_outros(), transition_out(y, 1, 1, () => {
      y = null;
    }), check_outros());
    const d2 = {};
    1 & c2 && (d2.item = t4[0]), a.$set(d2), 1 & c2 && (h = t4[0].traits.has("invested")), h ? v ? (v.p(t4, c2), 1 & c2 && transition_in(v, 1)) : (v = create_if_block_2$3(t4), v.c(), transition_in(v, 1), v.m(e, l)) : v && (group_outros(), transition_out(v, 1, 1, () => {
      v = null;
    }), check_outros()), t4[5] ? $2 ? ($2.p(t4, c2), 32 & c2 && transition_in($2, 1)) : ($2 = create_if_block_1$5(t4), $2.c(), transition_in($2, 1), $2.m(e, p)) : $2 && (group_outros(), transition_out($2, 1, 1, () => {
      $2 = null;
    }), check_outros());
    const m2 = {};
    4 & c2 && (m2.itemData = t4[2]), u.$set(m2);
  }, i(t4) {
    m || (transition_in(f), transition_in(g), transition_in(_), transition_in(b), transition_in(y), transition_in(a.$$.fragment, t4), transition_in(v), transition_in($2), transition_in(u.$$.fragment, t4), t4 && add_render_callback(() => {
      m && (d || (d = create_bidirectional_transition(e, slide, { duration: 200, easing: identity, axis: "y" }, true)), d.run(1));
    }), m = true);
  }, o(t4) {
    transition_out(f), transition_out(g), transition_out(_), transition_out(b), transition_out(y), transition_out(a.$$.fragment, t4), transition_out(v), transition_out($2), transition_out(u.$$.fragment, t4), t4 && (d || (d = create_bidirectional_transition(e, slide, { duration: 200, easing: identity, axis: "y" }, false)), d.run(0)), m = false;
  }, d(t4) {
    t4 && detach(e), f && f.d(), g && g.d(), _ && _.d(), b && b.d(), y && y.d(), destroy_component(a), v && v.d(), $2 && $2.d(), destroy_component(u), t4 && d && d.end();
  } };
}
function create_if_block_7$2(t3) {
  let e, n;
  return e = new Pf2eWeaponProperties({ props: { itemData: t3[2] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t4, i) {
    mount_component(e, t4, i), n = true;
  }, p(t4, n2) {
    const i = {};
    4 & n2 && (i.itemData = t4[2]), e.$set(i);
  }, i(t4) {
    n || (transition_in(e.$$.fragment, t4), n = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), n = false;
  }, d(t4) {
    destroy_component(e, t4);
  } };
}
function create_if_block_6$2(t3) {
  let e, n;
  return e = new Pf2eShieldProperties({ props: { itemData: t3[2] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t4, i) {
    mount_component(e, t4, i), n = true;
  }, p(t4, n2) {
    const i = {};
    4 & n2 && (i.itemData = t4[2]), e.$set(i);
  }, i(t4) {
    n || (transition_in(e.$$.fragment, t4), n = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), n = false;
  }, d(t4) {
    destroy_component(e, t4);
  } };
}
function create_if_block_5$2(t3) {
  let e, n;
  return e = new Pf2eArmorProperties({ props: { itemData: t3[2] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t4, i) {
    mount_component(e, t4, i), n = true;
  }, p(t4, n2) {
    const i = {};
    4 & n2 && (i.itemData = t4[2]), e.$set(i);
  }, i(t4) {
    n || (transition_in(e.$$.fragment, t4), n = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), n = false;
  }, d(t4) {
    destroy_component(e, t4);
  } };
}
function create_if_block_4$3(t3) {
  let e, n;
  return e = new Pf2eEquipmentProperties({ props: { itemData: t3[2] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t4, i) {
    mount_component(e, t4, i), n = true;
  }, p(t4, n2) {
    const i = {};
    4 & n2 && (i.itemData = t4[2]), e.$set(i);
  }, i(t4) {
    n || (transition_in(e.$$.fragment, t4), n = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), n = false;
  }, d(t4) {
    destroy_component(e, t4);
  } };
}
function create_if_block_3$3(t3) {
  let e, n;
  return e = new Pf2eConsumableProperties({ props: { itemData: t3[2] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t4, i) {
    mount_component(e, t4, i), n = true;
  }, p(t4, n2) {
    const i = {};
    4 & n2 && (i.itemData = t4[2]), e.$set(i);
  }, i(t4) {
    n || (transition_in(e.$$.fragment, t4), n = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), n = false;
  }, d(t4) {
    destroy_component(e, t4);
  } };
}
function create_if_block_2$3(t3) {
  let e, n;
  return e = new Pf2eInvestment({ props: { item: t3[0] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t4, i) {
    mount_component(e, t4, i), n = true;
  }, p(t4, n2) {
    const i = {};
    1 & n2 && (i.item = t4[0]), e.$set(i);
  }, i(t4) {
    n || (transition_in(e.$$.fragment, t4), n = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), n = false;
  }, d(t4) {
    destroy_component(e, t4);
  } };
}
function create_if_block_1$5(t3) {
  let e, n;
  return e = new Pf2eAction({ props: { action: t3[5] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t4, i) {
    mount_component(e, t4, i), n = true;
  }, p(t4, n2) {
    const i = {};
    32 & n2 && (i.action = t4[5]), e.$set(i);
  }, i(t4) {
    n || (transition_in(e.$$.fragment, t4), n = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), n = false;
  }, d(t4) {
    destroy_component(e, t4);
  } };
}
function create_fragment$h(t3) {
  let e, n, i, o, r, s, a, c, l, p, u, d, m, h, f, g, _ = !t3[3] && create_if_block_8$1(t3);
  d = new Quantity({ props: { quantity: t3[2].quantity, fontFamily: "var(--a5e-font-serif)" } }), d.$on("onQtyChange", t3[7]);
  let b = t3[3] && create_if_block$b(t3);
  return { c() {
    e = element("section"), n = element("div"), i = element("div"), o = element("img"), s = space(), a = element("span"), c = text(t3[4]), l = space(), p = element("div"), _ && _.c(), u = space(), create_component(d.$$.fragment), m = space(), b && b.c(), src_url_equal(o.src, r = t3[0].img) || attr(o, "src", r), attr(o, "alt", t3[4]), attr(o, "class", "item-icon svelte-mobile-companion-pf2e-v340n8-zxz8kj"), attr(i, "class", "item svelte-mobile-companion-pf2e-v340n8-zxz8kj"), attr(i, "aria-hidden", "true"), attr(p, "class", "states-and-qty svelte-mobile-companion-pf2e-v340n8-zxz8kj"), attr(n, "class", "item-name-and-qty svelte-mobile-companion-pf2e-v340n8-zxz8kj"), attr(e, "class", "svelte-mobile-companion-pf2e-v340n8-zxz8kj"), toggle_class(e, "odd", t3[1]);
  }, m(r2, y) {
    insert(r2, e, y), append(e, n), append(n, i), append(i, o), append(i, s), append(i, a), append(a, c), append(n, l), append(n, p), _ && _.m(p, null), append(p, u), mount_component(d, p, null), append(e, m), b && b.m(e, null), h = true, f || (g = listen(i, "click", t3[6]), f = true);
  }, p(t4, [n2]) {
    (!h || 1 & n2 && !src_url_equal(o.src, r = t4[0].img)) && attr(o, "src", r), (!h || 16 & n2) && attr(o, "alt", t4[4]), (!h || 16 & n2) && set_data(c, t4[4]), t4[3] ? _ && (group_outros(), transition_out(_, 1, 1, () => {
      _ = null;
    }), check_outros()) : _ ? (_.p(t4, n2), 8 & n2 && transition_in(_, 1)) : (_ = create_if_block_8$1(t4), _.c(), transition_in(_, 1), _.m(p, u));
    const i2 = {};
    4 & n2 && (i2.quantity = t4[2].quantity), d.$set(i2), t4[3] ? b ? (b.p(t4, n2), 8 & n2 && transition_in(b, 1)) : (b = create_if_block$b(t4), b.c(), transition_in(b, 1), b.m(e, null)) : b && (group_outros(), transition_out(b, 1, 1, () => {
      b = null;
    }), check_outros()), (!h || 2 & n2) && toggle_class(e, "odd", t4[1]);
  }, i(t4) {
    h || (transition_in(_), transition_in(d.$$.fragment, t4), transition_in(b), h = true);
  }, o(t4) {
    transition_out(_), transition_out(d.$$.fragment, t4), transition_out(b), h = false;
  }, d(t4) {
    t4 && detach(e), _ && _.d(), destroy_component(d), b && b.d(), f = false, g();
  } };
}
function instance$h(t3, e, n) {
  let i, o, r, { actor: s } = e, { item: a } = e, { isOddLine: c } = e, l = false;
  return t3.$$set = (t4) => {
    "actor" in t4 && n(8, s = t4.actor), "item" in t4 && n(0, a = t4.item), "isOddLine" in t4 && n(1, c = t4.isOddLine);
  }, t3.$$.update = () => {
    1 & t3.$$.dirty && n(2, i = a.system), 260 & t3.$$.dirty && n(5, o = s.system.actions.find((t4) => t4.slug === i.slug)), 1 & t3.$$.dirty && n(4, r = a.name);
  }, [a, c, i, l, r, o, function() {
    n(3, l = !l);
  }, function(t4) {
    const e2 = { system: { quantity: t4.detail.newValue } };
    a.update(e2);
  }, s];
}
class Pf2eObject extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$h, create_fragment$h, safe_not_equal, { actor: 8, item: 0, isOddLine: 1 });
  }
}
function create_fragment$g(t3) {
  let e, n, i, o, r, s, a, c, l, p, u, d, m, h, f, g, _, b, y, v, $2;
  return r = new EvaluatingInput({ props: { value: t3[0].pp, styleClass: "coin-input", id: "currency-pp", name: "pp" } }), r.$on("change", t3[1]), p = new EvaluatingInput({ props: { value: t3[0].gp, styleClass: "coin-input", id: "currency-gp", name: "gp" } }), p.$on("change", t3[1]), f = new EvaluatingInput({ props: { value: t3[0].sp, styleClass: "coin-input", id: "currency-sp", name: "sp" } }), f.$on("change", t3[1]), v = new EvaluatingInput({ props: { value: t3[0].cp, styleClass: "coin-input", id: "currency-cp", name: "cp" } }), v.$on("change", t3[1]), { c() {
    e = element("ol"), n = element("li"), i = element("div"), o = space(), create_component(r.$$.fragment), s = space(), a = element("li"), c = element("div"), l = space(), create_component(p.$$.fragment), u = space(), d = element("li"), m = element("div"), h = space(), create_component(f.$$.fragment), g = space(), _ = element("li"), b = element("div"), y = space(), create_component(v.$$.fragment), attr(i, "class", "coin-image pp svelte-mobile-companion-pf2e-v340n8-17paqud"), attr(n, "class", "coin-item svelte-mobile-companion-pf2e-v340n8-17paqud"), attr(c, "class", "coin-image gp svelte-mobile-companion-pf2e-v340n8-17paqud"), attr(a, "class", "coin-item svelte-mobile-companion-pf2e-v340n8-17paqud"), attr(m, "class", "coin-image sp svelte-mobile-companion-pf2e-v340n8-17paqud"), attr(d, "class", "coin-item svelte-mobile-companion-pf2e-v340n8-17paqud"), attr(b, "class", "coin-image cp svelte-mobile-companion-pf2e-v340n8-17paqud"), attr(_, "class", "coin-item svelte-mobile-companion-pf2e-v340n8-17paqud"), attr(e, "class", "currency-list svelte-mobile-companion-pf2e-v340n8-17paqud");
  }, m(t4, T) {
    insert(t4, e, T), append(e, n), append(n, i), append(n, o), mount_component(r, n, null), append(e, s), append(e, a), append(a, c), append(a, l), mount_component(p, a, null), append(e, u), append(e, d), append(d, m), append(d, h), mount_component(f, d, null), append(e, g), append(e, _), append(_, b), append(_, y), mount_component(v, _, null), $2 = true;
  }, p(t4, [e2]) {
    const n2 = {};
    1 & e2 && (n2.value = t4[0].pp), r.$set(n2);
    const i2 = {};
    1 & e2 && (i2.value = t4[0].gp), p.$set(i2);
    const o2 = {};
    1 & e2 && (o2.value = t4[0].sp), f.$set(o2);
    const s2 = {};
    1 & e2 && (s2.value = t4[0].cp), v.$set(s2);
  }, i(t4) {
    $2 || (transition_in(r.$$.fragment, t4), transition_in(p.$$.fragment, t4), transition_in(f.$$.fragment, t4), transition_in(v.$$.fragment, t4), $2 = true);
  }, o(t4) {
    transition_out(r.$$.fragment, t4), transition_out(p.$$.fragment, t4), transition_out(f.$$.fragment, t4), transition_out(v.$$.fragment, t4), $2 = false;
  }, d(t4) {
    t4 && detach(e), destroy_component(r), destroy_component(p), destroy_component(f), destroy_component(v);
  } };
}
function instance$g(t3, e, n) {
  let i, { actor: o } = e;
  return t3.$$set = (t4) => {
    "actor" in t4 && n(2, o = t4.actor);
  }, t3.$$.update = () => {
    4 & t3.$$.dirty && n(0, i = o.inventory.coins);
  }, [i, function(t4) {
    var e2;
    const { value: n2, name: r } = t4.detail, s = r, a = n2 - (null !== (e2 = i[s]) && void 0 !== e2 ? e2 : 0), c = { [s]: a };
    a > 0 ? o.inventory.addCoins(c, { combineStacks: true }) : o.inventory.removeCoins(c, { byValue: false });
  }, o];
}
class Pf2eCurrency extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$g, create_fragment$g, safe_not_equal, { actor: 2 });
  }
}
function create_fragment$f(t3) {
  let e, n, i, o, r, s, a, c, l, p, u, d, m, h, f, g, _, b, y, v, $2, T, w, S, k, O = i18n("PF2E.Item.Physical.Bulk.Label") + "", x = t3[0].value.normal + "", E = t3[0].value.light + "", M = i18n("PF2E.condition.encumbered.name") + "", A = t3[0].encumberedAfter + "", C = i18n("PF2E.BulkMaxLabel") + "", I = t3[0].max + "";
  return { c() {
    e = element("div"), n = element("img"), o = space(), r = element("span"), s = space(), a = element("div"), c = element("span"), l = text(O), p = text(": "), u = text(x), d = text(", "), m = text(E), h = text(" L /\r\n            "), f = element("span"), g = text(M), _ = text(": "), b = text(A), y = space(), v = element("span"), $2 = text(C), T = text(": "), w = text(I), S = space(), k = element("span"), src_url_equal(n.src, i = "icons/containers/bags/pack-leather-white-tan.webp") || attr(n, "src", "icons/containers/bags/pack-leather-white-tan.webp"), attr(n, "alt", "Encumbrance"), attr(r, "class", "encumbrance-bar svelte-mobile-companion-pf2e-v340n8-a1ieu5"), set_style(r, "width", Math.min(t3[0].maxPercentage, 100) + "%"), toggle_class(r, "encumbered", t3[0].isEncumbered), toggle_class(r, "over-limit", t3[0].isOverMax), attr(a, "class", "encumbrance-label svelte-mobile-companion-pf2e-v340n8-a1ieu5"), attr(k, "class", "bar-bg svelte-mobile-companion-pf2e-v340n8-a1ieu5"), attr(e, "class", "encumbrance svelte-mobile-companion-pf2e-v340n8-a1ieu5");
  }, m(t4, i2) {
    insert(t4, e, i2), append(e, n), append(e, o), append(e, r), append(e, s), append(e, a), append(a, c), append(c, l), append(c, p), append(c, u), append(c, d), append(c, m), append(c, h), append(c, f), append(f, g), append(f, _), append(f, b), append(a, y), append(a, v), append(v, $2), append(v, T), append(v, w), append(e, S), append(e, k);
  }, p(t4, [e2]) {
    1 & e2 && set_style(r, "width", Math.min(t4[0].maxPercentage, 100) + "%"), 1 & e2 && toggle_class(r, "encumbered", t4[0].isEncumbered), 1 & e2 && toggle_class(r, "over-limit", t4[0].isOverMax), 1 & e2 && x !== (x = t4[0].value.normal + "") && set_data(u, x), 1 & e2 && E !== (E = t4[0].value.light + "") && set_data(m, E), 1 & e2 && A !== (A = t4[0].encumberedAfter + "") && set_data(b, A), 1 & e2 && I !== (I = t4[0].max + "") && set_data(w, I);
  }, i: noop, o: noop, d(t4) {
    t4 && detach(e);
  } };
}
function instance$f(t3, e, n) {
  let i, { actor: o } = e;
  return t3.$$set = (t4) => {
    "actor" in t4 && n(1, o = t4.actor);
  }, t3.$$.update = () => {
    2 & t3.$$.dirty && n(0, i = o.inventory.bulk);
  }, [i, o];
}
class Pf2eWeight extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$f, create_fragment$f, safe_not_equal, { actor: 1 });
  }
}
function get_each_context$5(t3, e, n) {
  const i = t3.slice();
  return i[9] = e[n], i[11] = n, i;
}
function get_each_context_1$5(t3, e, n) {
  const i = t3.slice();
  return i[12] = e[n], i[11] = n, i;
}
function get_each_context_2$3(t3, e, n) {
  const i = t3.slice();
  return i[14] = e[n], i[11] = n, i;
}
function get_each_context_3(t3, e, n) {
  const i = t3.slice();
  return i[16] = e[n], i[11] = n, i;
}
function get_each_context_4(t3, e, n) {
  const i = t3.slice();
  return i[18] = e[n], i[11] = n, i;
}
function get_each_context_5(t3, e, n) {
  const i = t3.slice();
  return i[20] = e[n], i[11] = n, i;
}
function create_if_block_7$1(t3) {
  let e, n;
  return e = new Pf2eCurrency({ props: { actor: t3[0] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t4, i) {
    mount_component(e, t4, i), n = true;
  }, p(t4, n2) {
    const i = {};
    1 & n2 && (i.actor = t4[0]), e.$set(i);
  }, i(t4) {
    n || (transition_in(e.$$.fragment, t4), n = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), n = false;
  }, d(t4) {
    destroy_component(e, t4);
  } };
}
function create_if_block_6$1(t3) {
  let e, n;
  return e = new Pf2eWeight({ props: { actor: t3[0] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t4, i) {
    mount_component(e, t4, i), n = true;
  }, p(t4, n2) {
    const i = {};
    1 & n2 && (i.actor = t4[0]), e.$set(i);
  }, i(t4) {
    n || (transition_in(e.$$.fragment, t4), n = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), n = false;
  }, d(t4) {
    destroy_component(e, t4);
  } };
}
function create_if_block_5$1(t3) {
  let e, n, i, o, r, s = [], a = /* @__PURE__ */ new Map(), c = ensure_array_like(t3[2]);
  const l = (t4) => t4[20].id;
  for (let e2 = 0; e2 < c.length; e2 += 1) {
    let n2 = get_each_context_5(t3, c, e2), i2 = l(n2);
    a.set(i2, s[e2] = create_each_block_5(i2, n2));
  }
  return { c() {
    e = element("div"), n = element("h3"), n.textContent = `${i18n("PF2E.Actor.Inventory.Section.WeaponsAndShields")}`, i = space();
    for (let t4 = 0; t4 < s.length; t4 += 1) s[t4].c();
    o = empty(), attr(n, "class", "header-name svelte-mobile-companion-pf2e-v340n8-fhfcrr"), attr(e, "class", "pf2e-item-header svelte-mobile-companion-pf2e-v340n8-fhfcrr");
  }, m(t4, a2) {
    insert(t4, e, a2), append(e, n), insert(t4, i, a2);
    for (let e2 = 0; e2 < s.length; e2 += 1) s[e2] && s[e2].m(t4, a2);
    insert(t4, o, a2), r = true;
  }, p(t4, e2) {
    5 & e2 && (c = ensure_array_like(t4[2]), group_outros(), s = update_keyed_each(s, e2, l, 1, t4, c, a, o.parentNode, outro_and_destroy_block, create_each_block_5, o, get_each_context_5), check_outros());
  }, i(t4) {
    if (!r) {
      for (let t5 = 0; t5 < c.length; t5 += 1) transition_in(s[t5]);
      r = true;
    }
  }, o(t4) {
    for (let t5 = 0; t5 < s.length; t5 += 1) transition_out(s[t5]);
    r = false;
  }, d(t4) {
    t4 && (detach(e), detach(i), detach(o));
    for (let e2 = 0; e2 < s.length; e2 += 1) s[e2].d(t4);
  } };
}
function create_each_block_5(t3, e) {
  let n, i, o;
  return i = new Pf2eObject({ props: { actor: e[0], item: e[20], isOddLine: e[11] % 2 != 0 } }), { key: t3, first: null, c() {
    n = empty(), create_component(i.$$.fragment), this.first = n;
  }, m(t4, e2) {
    insert(t4, n, e2), mount_component(i, t4, e2), o = true;
  }, p(t4, n2) {
    e = t4;
    const o2 = {};
    1 & n2 && (o2.actor = e[0]), 4 & n2 && (o2.item = e[20]), 4 & n2 && (o2.isOddLine = e[11] % 2 != 0), i.$set(o2);
  }, i(t4) {
    o || (transition_in(i.$$.fragment, t4), o = true);
  }, o(t4) {
    transition_out(i.$$.fragment, t4), o = false;
  }, d(t4) {
    t4 && detach(n), destroy_component(i, t4);
  } };
}
function create_if_block_4$2(t3) {
  let e, n, i, o, r, s = [], a = /* @__PURE__ */ new Map(), c = ensure_array_like(t3[1][ItemType.armor]);
  const l = (t4) => t4[18].id;
  for (let e2 = 0; e2 < c.length; e2 += 1) {
    let n2 = get_each_context_4(t3, c, e2), i2 = l(n2);
    a.set(i2, s[e2] = create_each_block_4(i2, n2));
  }
  return { c() {
    e = element("div"), n = element("h3"), n.textContent = `${i18n("TYPES.Item.armor")}`, i = space();
    for (let t4 = 0; t4 < s.length; t4 += 1) s[t4].c();
    o = empty(), attr(n, "class", "header-name svelte-mobile-companion-pf2e-v340n8-fhfcrr"), attr(e, "class", "pf2e-item-header svelte-mobile-companion-pf2e-v340n8-fhfcrr");
  }, m(t4, a2) {
    insert(t4, e, a2), append(e, n), insert(t4, i, a2);
    for (let e2 = 0; e2 < s.length; e2 += 1) s[e2] && s[e2].m(t4, a2);
    insert(t4, o, a2), r = true;
  }, p(t4, e2) {
    3 & e2 && (c = ensure_array_like(t4[1][ItemType.armor]), group_outros(), s = update_keyed_each(s, e2, l, 1, t4, c, a, o.parentNode, outro_and_destroy_block, create_each_block_4, o, get_each_context_4), check_outros());
  }, i(t4) {
    if (!r) {
      for (let t5 = 0; t5 < c.length; t5 += 1) transition_in(s[t5]);
      r = true;
    }
  }, o(t4) {
    for (let t5 = 0; t5 < s.length; t5 += 1) transition_out(s[t5]);
    r = false;
  }, d(t4) {
    t4 && (detach(e), detach(i), detach(o));
    for (let e2 = 0; e2 < s.length; e2 += 1) s[e2].d(t4);
  } };
}
function create_each_block_4(t3, e) {
  let n, i, o;
  return i = new Pf2eObject({ props: { actor: e[0], item: e[18], isOddLine: e[11] % 2 != 0 } }), { key: t3, first: null, c() {
    n = empty(), create_component(i.$$.fragment), this.first = n;
  }, m(t4, e2) {
    insert(t4, n, e2), mount_component(i, t4, e2), o = true;
  }, p(t4, n2) {
    e = t4;
    const o2 = {};
    1 & n2 && (o2.actor = e[0]), 2 & n2 && (o2.item = e[18]), 2 & n2 && (o2.isOddLine = e[11] % 2 != 0), i.$set(o2);
  }, i(t4) {
    o || (transition_in(i.$$.fragment, t4), o = true);
  }, o(t4) {
    transition_out(i.$$.fragment, t4), o = false;
  }, d(t4) {
    t4 && detach(n), destroy_component(i, t4);
  } };
}
function create_if_block_3$2(t3) {
  let e, n, i, o, r, s, a, c, l, p, u, d, m, h = i18n("PF2E.InvestedLabel") + "", f = t3[0].inventory.invested.value + "", g = t3[0].inventory.invested.max + "", _ = [], b = /* @__PURE__ */ new Map(), y = ensure_array_like(t3[1][ItemType.equipment]);
  const v = (t4) => t4[16].id;
  for (let e2 = 0; e2 < y.length; e2 += 1) {
    let n2 = get_each_context_3(t3, y, e2), i2 = v(n2);
    b.set(i2, _[e2] = create_each_block_3(i2, n2));
  }
  return { c() {
    e = element("div"), n = element("h3"), n.textContent = `${i18n("TYPES.Item.equipment")}`, i = space(), o = element("span"), r = text(h), s = text(" ("), a = text(f), c = text("/"), l = text(g), p = text(")"), u = space();
    for (let t4 = 0; t4 < _.length; t4 += 1) _[t4].c();
    d = empty(), attr(n, "class", "header-name svelte-mobile-companion-pf2e-v340n8-fhfcrr"), attr(o, "class", "item-invested-total"), attr(e, "class", "pf2e-item-header svelte-mobile-companion-pf2e-v340n8-fhfcrr");
  }, m(t4, h2) {
    insert(t4, e, h2), append(e, n), append(e, i), append(e, o), append(o, r), append(o, s), append(o, a), append(o, c), append(o, l), append(o, p), insert(t4, u, h2);
    for (let e2 = 0; e2 < _.length; e2 += 1) _[e2] && _[e2].m(t4, h2);
    insert(t4, d, h2), m = true;
  }, p(t4, e2) {
    (!m || 1 & e2) && f !== (f = t4[0].inventory.invested.value + "") && set_data(a, f), (!m || 1 & e2) && g !== (g = t4[0].inventory.invested.max + "") && set_data(l, g), 3 & e2 && (y = ensure_array_like(t4[1][ItemType.equipment]), group_outros(), _ = update_keyed_each(_, e2, v, 1, t4, y, b, d.parentNode, outro_and_destroy_block, create_each_block_3, d, get_each_context_3), check_outros());
  }, i(t4) {
    if (!m) {
      for (let t5 = 0; t5 < y.length; t5 += 1) transition_in(_[t5]);
      m = true;
    }
  }, o(t4) {
    for (let t5 = 0; t5 < _.length; t5 += 1) transition_out(_[t5]);
    m = false;
  }, d(t4) {
    t4 && (detach(e), detach(u), detach(d));
    for (let e2 = 0; e2 < _.length; e2 += 1) _[e2].d(t4);
  } };
}
function create_each_block_3(t3, e) {
  let n, i, o;
  return i = new Pf2eObject({ props: { actor: e[0], item: e[16], isOddLine: e[11] % 2 != 0 } }), { key: t3, first: null, c() {
    n = empty(), create_component(i.$$.fragment), this.first = n;
  }, m(t4, e2) {
    insert(t4, n, e2), mount_component(i, t4, e2), o = true;
  }, p(t4, n2) {
    e = t4;
    const o2 = {};
    1 & n2 && (o2.actor = e[0]), 2 & n2 && (o2.item = e[16]), 2 & n2 && (o2.isOddLine = e[11] % 2 != 0), i.$set(o2);
  }, i(t4) {
    o || (transition_in(i.$$.fragment, t4), o = true);
  }, o(t4) {
    transition_out(i.$$.fragment, t4), o = false;
  }, d(t4) {
    t4 && detach(n), destroy_component(i, t4);
  } };
}
function create_if_block_2$2(t3) {
  let e, n, i, o, r, s = [], a = /* @__PURE__ */ new Map(), c = ensure_array_like(t3[1][ItemType.consumable]);
  const l = (t4) => t4[14].id;
  for (let e2 = 0; e2 < c.length; e2 += 1) {
    let n2 = get_each_context_2$3(t3, c, e2), i2 = l(n2);
    a.set(i2, s[e2] = create_each_block_2$3(i2, n2));
  }
  return { c() {
    e = element("div"), n = element("h3"), n.textContent = `${i18n("TYPES.Item.consumable")}`, i = space();
    for (let t4 = 0; t4 < s.length; t4 += 1) s[t4].c();
    o = empty(), attr(n, "class", "header-name svelte-mobile-companion-pf2e-v340n8-fhfcrr"), attr(e, "class", "pf2e-item-header svelte-mobile-companion-pf2e-v340n8-fhfcrr");
  }, m(t4, a2) {
    insert(t4, e, a2), append(e, n), insert(t4, i, a2);
    for (let e2 = 0; e2 < s.length; e2 += 1) s[e2] && s[e2].m(t4, a2);
    insert(t4, o, a2), r = true;
  }, p(t4, e2) {
    3 & e2 && (c = ensure_array_like(t4[1][ItemType.consumable]), group_outros(), s = update_keyed_each(s, e2, l, 1, t4, c, a, o.parentNode, outro_and_destroy_block, create_each_block_2$3, o, get_each_context_2$3), check_outros());
  }, i(t4) {
    if (!r) {
      for (let t5 = 0; t5 < c.length; t5 += 1) transition_in(s[t5]);
      r = true;
    }
  }, o(t4) {
    for (let t5 = 0; t5 < s.length; t5 += 1) transition_out(s[t5]);
    r = false;
  }, d(t4) {
    t4 && (detach(e), detach(i), detach(o));
    for (let e2 = 0; e2 < s.length; e2 += 1) s[e2].d(t4);
  } };
}
function create_each_block_2$3(t3, e) {
  let n, i, o;
  return i = new Pf2eObject({ props: { actor: e[0], item: e[14], isOddLine: e[11] % 2 != 0 } }), { key: t3, first: null, c() {
    n = empty(), create_component(i.$$.fragment), this.first = n;
  }, m(t4, e2) {
    insert(t4, n, e2), mount_component(i, t4, e2), o = true;
  }, p(t4, n2) {
    e = t4;
    const o2 = {};
    1 & n2 && (o2.actor = e[0]), 2 & n2 && (o2.item = e[14]), 2 & n2 && (o2.isOddLine = e[11] % 2 != 0), i.$set(o2);
  }, i(t4) {
    o || (transition_in(i.$$.fragment, t4), o = true);
  }, o(t4) {
    transition_out(i.$$.fragment, t4), o = false;
  }, d(t4) {
    t4 && detach(n), destroy_component(i, t4);
  } };
}
function create_if_block_1$4(t3) {
  let e, n, i, o, r, s = [], a = /* @__PURE__ */ new Map(), c = ensure_array_like(t3[1][ItemType.treasure]);
  const l = (t4) => t4[12].id;
  for (let e2 = 0; e2 < c.length; e2 += 1) {
    let n2 = get_each_context_1$5(t3, c, e2), i2 = l(n2);
    a.set(i2, s[e2] = create_each_block_1$5(i2, n2));
  }
  return { c() {
    e = element("div"), n = element("h3"), n.textContent = `${i18n("TYPES.Item.treasure")}`, i = space();
    for (let t4 = 0; t4 < s.length; t4 += 1) s[t4].c();
    o = empty(), attr(n, "class", "header-name svelte-mobile-companion-pf2e-v340n8-fhfcrr"), attr(e, "class", "pf2e-item-header svelte-mobile-companion-pf2e-v340n8-fhfcrr");
  }, m(t4, a2) {
    insert(t4, e, a2), append(e, n), insert(t4, i, a2);
    for (let e2 = 0; e2 < s.length; e2 += 1) s[e2] && s[e2].m(t4, a2);
    insert(t4, o, a2), r = true;
  }, p(t4, e2) {
    3 & e2 && (c = ensure_array_like(t4[1][ItemType.treasure]), group_outros(), s = update_keyed_each(s, e2, l, 1, t4, c, a, o.parentNode, outro_and_destroy_block, create_each_block_1$5, o, get_each_context_1$5), check_outros());
  }, i(t4) {
    if (!r) {
      for (let t5 = 0; t5 < c.length; t5 += 1) transition_in(s[t5]);
      r = true;
    }
  }, o(t4) {
    for (let t5 = 0; t5 < s.length; t5 += 1) transition_out(s[t5]);
    r = false;
  }, d(t4) {
    t4 && (detach(e), detach(i), detach(o));
    for (let e2 = 0; e2 < s.length; e2 += 1) s[e2].d(t4);
  } };
}
function create_each_block_1$5(t3, e) {
  let n, i, o;
  return i = new Pf2eObject({ props: { actor: e[0], item: e[12], isOddLine: e[11] % 2 != 0 } }), { key: t3, first: null, c() {
    n = empty(), create_component(i.$$.fragment), this.first = n;
  }, m(t4, e2) {
    insert(t4, n, e2), mount_component(i, t4, e2), o = true;
  }, p(t4, n2) {
    e = t4;
    const o2 = {};
    1 & n2 && (o2.actor = e[0]), 2 & n2 && (o2.item = e[12]), 2 & n2 && (o2.isOddLine = e[11] % 2 != 0), i.$set(o2);
  }, i(t4) {
    o || (transition_in(i.$$.fragment, t4), o = true);
  }, o(t4) {
    transition_out(i.$$.fragment, t4), o = false;
  }, d(t4) {
    t4 && detach(n), destroy_component(i, t4);
  } };
}
function create_if_block$a(t3) {
  let e, n, i, o, r, s = [], a = /* @__PURE__ */ new Map(), c = ensure_array_like(t3[1][ItemType.backpack]);
  const l = (t4) => t4[9].id;
  for (let e2 = 0; e2 < c.length; e2 += 1) {
    let n2 = get_each_context$5(t3, c, e2), i2 = l(n2);
    a.set(i2, s[e2] = create_each_block$5(i2, n2));
  }
  return { c() {
    e = element("div"), n = element("h3"), n.textContent = `${i18n("TYPES.Item.backpack")}`, i = space();
    for (let t4 = 0; t4 < s.length; t4 += 1) s[t4].c();
    o = empty(), attr(n, "class", "header-name svelte-mobile-companion-pf2e-v340n8-fhfcrr"), attr(e, "class", "pf2e-item-header svelte-mobile-companion-pf2e-v340n8-fhfcrr");
  }, m(t4, a2) {
    insert(t4, e, a2), append(e, n), insert(t4, i, a2);
    for (let e2 = 0; e2 < s.length; e2 += 1) s[e2] && s[e2].m(t4, a2);
    insert(t4, o, a2), r = true;
  }, p(t4, e2) {
    3 & e2 && (c = ensure_array_like(t4[1][ItemType.backpack]), group_outros(), s = update_keyed_each(s, e2, l, 1, t4, c, a, o.parentNode, outro_and_destroy_block, create_each_block$5, o, get_each_context$5), check_outros());
  }, i(t4) {
    if (!r) {
      for (let t5 = 0; t5 < c.length; t5 += 1) transition_in(s[t5]);
      r = true;
    }
  }, o(t4) {
    for (let t5 = 0; t5 < s.length; t5 += 1) transition_out(s[t5]);
    r = false;
  }, d(t4) {
    t4 && (detach(e), detach(i), detach(o));
    for (let e2 = 0; e2 < s.length; e2 += 1) s[e2].d(t4);
  } };
}
function create_each_block$5(t3, e) {
  let n, i, o;
  return i = new Pf2eObject({ props: { actor: e[0], item: e[9], isOddLine: e[11] % 2 != 0 } }), { key: t3, first: null, c() {
    n = empty(), create_component(i.$$.fragment), this.first = n;
  }, m(t4, e2) {
    insert(t4, n, e2), mount_component(i, t4, e2), o = true;
  }, p(t4, n2) {
    e = t4;
    const o2 = {};
    1 & n2 && (o2.actor = e[0]), 2 & n2 && (o2.item = e[9]), 2 & n2 && (o2.isOddLine = e[11] % 2 != 0), i.$set(o2);
  }, i(t4) {
    o || (transition_in(i.$$.fragment, t4), o = true);
  }, o(t4) {
    transition_out(i.$$.fragment, t4), o = false;
  }, d(t4) {
    t4 && detach(n), destroy_component(i, t4);
  } };
}
function create_fragment$e(t3) {
  let e, n, i, o, r, s, a, c, l, p, u, d = t3[4] && create_if_block_7$1(t3), m = t3[6] && create_if_block_6$1(t3), h = (t3[1][ItemType.weapon]?.length > 0 || t3[1][ItemType.shield]?.length > 0) && create_if_block_5$1(t3), f = t3[1][ItemType.armor]?.length > 0 && create_if_block_4$2(t3), g = t3[1][ItemType.equipment]?.length > 0 && create_if_block_3$2(t3), _ = t3[1][ItemType.consumable]?.length > 0 && create_if_block_2$2(t3), b = t3[1][ItemType.treasure]?.length > 0 && create_if_block_1$4(t3), y = t3[1][ItemType.backpack]?.length > 0 && create_if_block$a(t3);
  return { c() {
    e = element("section"), n = element("div"), d && d.c(), i = space(), m && m.c(), o = space(), r = element("div"), h && h.c(), s = space(), f && f.c(), a = space(), g && g.c(), c = space(), _ && _.c(), l = space(), b && b.c(), p = space(), y && y.c(), attr(n, "class", "currency-weight svelte-mobile-companion-pf2e-v340n8-fhfcrr"), attr(r, "class", "content-scroll-list"), attr(e, "class", "category-content");
  }, m(t4, v) {
    insert(t4, e, v), append(e, n), d && d.m(n, null), append(n, i), m && m.m(n, null), append(e, o), append(e, r), h && h.m(r, null), append(r, s), f && f.m(r, null), append(r, a), g && g.m(r, null), append(r, c), _ && _.m(r, null), append(r, l), b && b.m(r, null), append(r, p), y && y.m(r, null), u = true;
  }, p(t4, [e2]) {
    t4[4] && d.p(t4, e2), t4[6] && m.p(t4, e2), t4[1][ItemType.weapon]?.length > 0 || t4[1][ItemType.shield]?.length > 0 ? h ? (h.p(t4, e2), 2 & e2 && transition_in(h, 1)) : (h = create_if_block_5$1(t4), h.c(), transition_in(h, 1), h.m(r, s)) : h && (group_outros(), transition_out(h, 1, 1, () => {
      h = null;
    }), check_outros()), t4[1][ItemType.armor]?.length > 0 ? f ? (f.p(t4, e2), 2 & e2 && transition_in(f, 1)) : (f = create_if_block_4$2(t4), f.c(), transition_in(f, 1), f.m(r, a)) : f && (group_outros(), transition_out(f, 1, 1, () => {
      f = null;
    }), check_outros()), t4[1][ItemType.equipment]?.length > 0 ? g ? (g.p(t4, e2), 2 & e2 && transition_in(g, 1)) : (g = create_if_block_3$2(t4), g.c(), transition_in(g, 1), g.m(r, c)) : g && (group_outros(), transition_out(g, 1, 1, () => {
      g = null;
    }), check_outros()), t4[1][ItemType.consumable]?.length > 0 ? _ ? (_.p(t4, e2), 2 & e2 && transition_in(_, 1)) : (_ = create_if_block_2$2(t4), _.c(), transition_in(_, 1), _.m(r, l)) : _ && (group_outros(), transition_out(_, 1, 1, () => {
      _ = null;
    }), check_outros()), t4[1][ItemType.treasure]?.length > 0 ? b ? (b.p(t4, e2), 2 & e2 && transition_in(b, 1)) : (b = create_if_block_1$4(t4), b.c(), transition_in(b, 1), b.m(r, p)) : b && (group_outros(), transition_out(b, 1, 1, () => {
      b = null;
    }), check_outros()), t4[1][ItemType.backpack]?.length > 0 ? y ? (y.p(t4, e2), 2 & e2 && transition_in(y, 1)) : (y = create_if_block$a(t4), y.c(), transition_in(y, 1), y.m(r, null)) : y && (group_outros(), transition_out(y, 1, 1, () => {
      y = null;
    }), check_outros());
  }, i(t4) {
    u || (transition_in(d), transition_in(m), transition_in(h), transition_in(f), transition_in(g), transition_in(_), transition_in(b), transition_in(y), u = true);
  }, o(t4) {
    transition_out(d), transition_out(m), transition_out(h), transition_out(f), transition_out(g), transition_out(_), transition_out(b), transition_out(y), u = false;
  }, d(t4) {
    t4 && detach(e), d && d.d(), m && m.d(), h && h.d(), f && f.d(), g && g.d(), _ && _.d(), b && b.d(), y && y.d();
  } };
}
function instance$e(t3, e, n) {
  let i, o, r, { actor: s } = e, a = {};
  const c = mobileCompanionGameSettings.getWritableStore(USE_CURRENCY);
  component_subscribe(t3, c, (t4) => n(8, o = t4));
  let l = o;
  const p = mobileCompanionGameSettings.getWritableStore(USE_ENCUMBRANCE);
  component_subscribe(t3, p, (t4) => n(7, i = t4));
  let u = i;
  return t3.$$set = (t4) => {
    "actor" in t4 && n(0, s = t4.actor);
  }, t3.$$.update = () => {
    3 & t3.$$.dirty && (n(1, a = s.inventory.contents.reduce((t4, e2) => {
      const n2 = e2.type;
      return t4[n2] = t4[n2] ? [...t4[n2], e2] : [e2], t4;
    }, {})), Object.keys(a).forEach((t4) => {
      a[t4].sort((t5, e2) => t5.name.localeCompare(e2.name));
    }), a[ItemType.shield] && n(2, r = [...a[ItemType.shield]]), a[ItemType.weapon] && n(2, r = [...a[ItemType.weapon]]));
  }, [s, a, r, c, l, p, u];
}
class Pf2eInventory extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$e, create_fragment$e, safe_not_equal, { actor: 0 });
  }
}
function create_default_slot_2(t3) {
  let e;
  return { c() {
    e = text("Known");
  }, m(t4, n) {
    insert(t4, e, n);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_default_slot_1(t3) {
  let e;
  return { c() {
    e = text("Rituals");
  }, m(t4, n) {
    insert(t4, e, n);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_default_slot$4(t3) {
  let e;
  return { c() {
    e = text("Items");
  }, m(t4, n) {
    insert(t4, e, n);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_fragment$d(t3) {
  let e, n, i, o, r, s, a;
  return n = new MCButton({ props: { customClass: "spell-category " + (t3[0] === SpellcastingTabType.KNOWN ? "active" : ""), type: "button", $$slots: { default: [create_default_slot_2] }, $$scope: { ctx: t3 } } }), n.$on("click", t3[2]), o = new MCButton({ props: { customClass: "spell-category " + (t3[0] === SpellcastingTabType.RITUAL ? "active" : ""), type: "button", $$slots: { default: [create_default_slot_1] }, $$scope: { ctx: t3 } } }), o.$on("click", t3[3]), s = new MCButton({ props: { customClass: "spell-category " + (t3[0] === SpellcastingTabType.ACTIVATION ? "active" : ""), type: "button", $$slots: { default: [create_default_slot$4] }, $$scope: { ctx: t3 } } }), s.$on("click", t3[4]), { c() {
    e = element("nav"), create_component(n.$$.fragment), i = space(), create_component(o.$$.fragment), r = space(), create_component(s.$$.fragment), attr(e, "class", "spell-category-nav svelte-mobile-companion-pf2e-v340n8-lnt70u"), attr(e, "data-group", "spell-collections");
  }, m(t4, c) {
    insert(t4, e, c), mount_component(n, e, null), append(e, i), mount_component(o, e, null), append(e, r), mount_component(s, e, null), a = true;
  }, p(t4, [e2]) {
    const i2 = {};
    1 & e2 && (i2.customClass = "spell-category " + (t4[0] === SpellcastingTabType.KNOWN ? "active" : "")), 64 & e2 && (i2.$$scope = { dirty: e2, ctx: t4 }), n.$set(i2);
    const r2 = {};
    1 & e2 && (r2.customClass = "spell-category " + (t4[0] === SpellcastingTabType.RITUAL ? "active" : "")), 64 & e2 && (r2.$$scope = { dirty: e2, ctx: t4 }), o.$set(r2);
    const a2 = {};
    1 & e2 && (a2.customClass = "spell-category " + (t4[0] === SpellcastingTabType.ACTIVATION ? "active" : "")), 64 & e2 && (a2.$$scope = { dirty: e2, ctx: t4 }), s.$set(a2);
  }, i(t4) {
    a || (transition_in(n.$$.fragment, t4), transition_in(o.$$.fragment, t4), transition_in(s.$$.fragment, t4), a = true);
  }, o(t4) {
    transition_out(n.$$.fragment, t4), transition_out(o.$$.fragment, t4), transition_out(s.$$.fragment, t4), a = false;
  }, d(t4) {
    t4 && detach(e), destroy_component(n), destroy_component(o), destroy_component(s);
  } };
}
function instance$d(t3, e, n) {
  let { activeTab: i = SpellcastingTabType.KNOWN } = e;
  const o = createEventDispatcher();
  function r(t4) {
    o("categoryChange", t4);
  }
  return t3.$$set = (t4) => {
    "activeTab" in t4 && n(0, i = t4.activeTab);
  }, [i, r, () => r(SpellcastingTabType.KNOWN), () => r(SpellcastingTabType.RITUAL), () => r(SpellcastingTabType.ACTIVATION)];
}
class Pf2eSpellsHeader extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$d, create_fragment$d, safe_not_equal, { activeTab: 0 });
  }
}
function create_fragment$c(t3) {
  let e, n, i, o, r;
  const s = t3[2].default, a = create_slot(s, t3, t3[1], null);
  return { c() {
    e = element("div"), n = element("h2"), i = text(t3[0]), o = space(), a && a.c(), attr(n, "class", "svelte-mobile-companion-pf2e-v340n8-15wxezu"), attr(e, "class", "action-header svelte-mobile-companion-pf2e-v340n8-15wxezu");
  }, m(t4, s2) {
    insert(t4, e, s2), append(e, n), append(n, i), append(e, o), a && a.m(e, null), r = true;
  }, p(t4, [e2]) {
    (!r || 1 & e2) && set_data(i, t4[0]), a && a.p && (!r || 2 & e2) && update_slot_base(a, s, t4, t4[1], r ? get_slot_changes(s, t4[1], e2, null) : get_all_dirty_from_scope(t4[1]), null);
  }, i(t4) {
    r || (transition_in(a, t4), r = true);
  }, o(t4) {
    transition_out(a, t4), r = false;
  }, d(t4) {
    t4 && detach(e), a && a.d(t4);
  } };
}
function instance$c(t3, e, n) {
  let { $$slots: i = {}, $$scope: o } = e, { title: r } = e;
  return t3.$$set = (t4) => {
    "title" in t4 && n(0, r = t4.title), "$$scope" in t4 && n(1, o = t4.$$scope);
  }, [r, o, i];
}
class Pf2eSpellActionHeader extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$c, create_fragment$c, safe_not_equal, { title: 0 });
  }
}
function create_fragment$b(t3) {
  let e, n, i, o, r, s, a, c, l, p, u, d, m, h, f, g, _, b, y, v, $2, T, w = t3[0].statistic.dc.value + "", S = t3[0].statistic.check.mod + "", k = t3[0].statistic.label + "", O = i18n(`PF2E.ProficiencyLevel${t3[0].statistic.rank}`) + "";
  return { c() {
    e = element("div"), n = element("div"), i = element("section"), o = element("span"), r = text(w), s = space(), a = element("h4"), a.textContent = `${i18n("PF2E.Actor.Creature.Spellcasting.DC")}`, c = space(), l = element("section"), p = element("span"), u = text("+"), d = text(S), m = space(), h = element("h4"), h.textContent = `${i18n("PF2E.SpellAttackLabel")}`, f = space(), g = element("section"), _ = element("span"), b = text(k), y = space(), v = element("div"), $2 = element("span"), T = text(O), attr(o, "class", "skill-score svelte-mobile-companion-pf2e-v340n8-gftt24"), attr(a, "class", "svelte-mobile-companion-pf2e-v340n8-gftt24"), attr(i, "class", "skill-data svelte-mobile-companion-pf2e-v340n8-gftt24"), attr(i, "data-tooltip", "Base DC 10, Intelligence +3, Trained +3"), attr(p, "class", "skill-score svelte-mobile-companion-pf2e-v340n8-gftt24"), attr(h, "class", "spell-check-label svelte-mobile-companion-pf2e-v340n8-gftt24"), attr(l, "class", "skill-data svelte-mobile-companion-pf2e-v340n8-gftt24"), attr(n, "class", "statistic-values svelte-mobile-companion-pf2e-v340n8-gftt24"), attr(_, "class", "spell-tradition svelte-mobile-companion-pf2e-v340n8-gftt24"), attr($2, "class", "pf-rank svelte-mobile-companion-pf2e-v340n8-gftt24"), attr(v, "class", "spellcasting-prof"), attr(g, "class", "spell-ability svelte-mobile-companion-pf2e-v340n8-gftt24"), attr(e, "class", "spell-ability-data svelte-mobile-companion-pf2e-v340n8-gftt24");
  }, m(t4, w2) {
    insert(t4, e, w2), append(e, n), append(n, i), append(i, o), append(o, r), append(i, s), append(i, a), append(n, c), append(n, l), append(l, p), append(p, u), append(p, d), append(l, m), append(l, h), append(e, f), append(e, g), append(g, _), append(_, b), append(g, y), append(g, v), append(v, $2), append($2, T);
  }, p(t4, [e2]) {
    1 & e2 && w !== (w = t4[0].statistic.dc.value + "") && set_data(r, w), 1 & e2 && S !== (S = t4[0].statistic.check.mod + "") && set_data(d, S), 1 & e2 && k !== (k = t4[0].statistic.label + "") && set_data(b, k), 1 & e2 && O !== (O = i18n(`PF2E.ProficiencyLevel${t4[0].statistic.rank}`) + "") && set_data(T, O);
  }, i: noop, o: noop, d(t4) {
    t4 && detach(e);
  } };
}
function instance$b(t3, e, n) {
  let { spellCategory: i } = e;
  return t3.$$set = (t4) => {
    "spellCategory" in t4 && n(0, i = t4.spellCategory);
  }, [i];
}
class Pf2eSpellAbilityData extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$b, create_fragment$b, safe_not_equal, { spellCategory: 0 });
  }
}
function create_fragment$a(t3) {
  let e, n, i, o, r, s, a, c;
  return { c() {
    e = element("div"), n = element("div"), i = element("h3"), o = text(t3[0]), r = space(), s = element("div"), s.textContent = "Defense", a = space(), c = element("div"), c.textContent = "Range", attr(i, "class", "svelte-mobile-companion-pf2e-v340n8-1g4f2cn"), attr(n, "class", "item-name svelte-mobile-companion-pf2e-v340n8-1g4f2cn"), attr(s, "class", "defense svelte-mobile-companion-pf2e-v340n8-1g4f2cn"), attr(c, "class", "range svelte-mobile-companion-pf2e-v340n8-1g4f2cn"), attr(e, "class", "category-header svelte-mobile-companion-pf2e-v340n8-1g4f2cn");
  }, m(t4, l) {
    insert(t4, e, l), append(e, n), append(n, i), append(i, o), append(e, r), append(e, s), append(e, a), append(e, c);
  }, p(t4, [e2]) {
    1 & e2 && set_data(o, t4[0]);
  }, i: noop, o: noop, d(t4) {
    t4 && detach(e);
  } };
}
function instance$a(t3, e, n) {
  let { spellGroupLabel: i } = e;
  return t3.$$set = (t4) => {
    "spellGroupLabel" in t4 && n(0, i = t4.spellGroupLabel);
  }, [i];
}
class Pf2eSpellCategoryHeader extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$a, create_fragment$a, safe_not_equal, { spellGroupLabel: 0 });
  }
}
const spellPrepViewStore = writable(null);
function create_else_block$3(t3) {
  let e, n, i, o;
  return { c() {
    e = element("div"), n = element("div"), i = space(), o = element("h4"), o.textContent = `${myi18n("PF2E.SpellSlotEmpty")}`, attr(n, "class", "item-image framed svelte-mobile-companion-pf2e-v340n8-31t3hm"), attr(o, "class", "svelte-mobile-companion-pf2e-v340n8-31t3hm"), attr(e, "class", "item-name empty svelte-mobile-companion-pf2e-v340n8-31t3hm");
  }, m(t4, r) {
    insert(t4, e, r), append(e, n), append(e, i), append(e, o);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_if_block$9(t3) {
  let e, n, i, o;
  return { c() {
    e = element("div"), n = element("div"), i = space(), o = element("h4"), o.textContent = `${myi18n("PF2E.SpellSlotEmptyClick")}`, attr(n, "class", "item-image framed svelte-mobile-companion-pf2e-v340n8-31t3hm"), attr(o, "class", "svelte-mobile-companion-pf2e-v340n8-31t3hm"), attr(e, "class", "item-name empty svelte-mobile-companion-pf2e-v340n8-31t3hm");
  }, m(t4, r) {
    insert(t4, e, r), append(e, n), append(e, i), append(e, o);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_fragment$9(t3) {
  let e, n, i;
  let o = function(t4) {
    return t4[0] ? create_if_block$9 : create_else_block$3;
  }(t3), r = o(t3);
  return { c() {
    e = element("li"), r.c(), attr(e, "class", "spell svelte-mobile-companion-pf2e-v340n8-31t3hm");
  }, m(o2, s) {
    insert(o2, e, s), r.m(e, null), n || (i = listen(e, "click", t3[1]), n = true);
  }, p: noop, i: noop, o: noop, d(t4) {
    t4 && detach(e), r.d(), n = false, i();
  } };
}
function instance$9(t3, e, n) {
  let { collectionAndSheet: i } = e, { clickedGroupId: o } = e, { clickedSlot: r } = e, s = i.spellCollection.actor.items.get(i.spellCollection.id, { strict: true });
  const a = s.isPrepared;
  return t3.$$set = (t4) => {
    "collectionAndSheet" in t4 && n(2, i = t4.collectionAndSheet), "clickedGroupId" in t4 && n(3, o = t4.clickedGroupId), "clickedSlot" in t4 && n(4, r = t4.clickedSlot);
  }, [a, function() {
    if (a) {
      const t4 = { collectionAndSheet: Object.assign(Object.assign({}, i), { spellCollection: s }), clickedGroupId: o, clickedSlot: r };
      spellPrepViewStore.set(t4);
    }
  }, i, o, r];
}
class Pf2eEmptySpellSlot extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$9, create_fragment$9, safe_not_equal, { collectionAndSheet: 2, clickedGroupId: 3, clickedSlot: 4 });
  }
}
function getTraditions(t3) {
  return t3.system.traits.traditions.map((t4) => game.i18n.localize(CONFIG.PF2E.magicTraditions[t4]).toLocaleLowerCase(game.i18n.lang)).sort((t4, e) => t4.localeCompare(e, game.i18n.lang)).join(", ");
}
function getDefenseLabel(t3) {
  const e = t3.system.defense;
  if (!e) return null;
  const n = e.passive ? getPassiveDefenseLabel(e.passive.statistic, { localize: true }) : null, i = e.save ? game.i18n.localize(CONFIG.PF2E.saves[e.save.statistic]) : null, o = i && e.save?.basic ? i18nFormat("PF2E.Item.Spell.Defense.BasicDefense", { save: i }) : i;
  return n && o ? i18nFormat("PF2E.ListPartsAnd.two", { first: n, second: o }) : n ?? o;
}
function getPassiveDefenseLabel(t3, { localize: e = false } = {}) {
  const n = (() => {
    switch (t3) {
      case "ac":
        return "PF2E.Check.DC.Specific.armor";
      case "fortitude-dc":
        return "PF2E.Check.DC.Specific.fortitude";
      case "reflex-dc":
        return "PF2E.Check.DC.Specific.reflex";
      case "will-dc":
        return "PF2E.Check.DC.Specific.will";
      default:
        return null;
    }
  })();
  return n && e ? game.i18n.localize(n) : n;
}
function getDurationLabel(t3) {
  const e = t3.system.duration, n = e.value.trim();
  if (e.sustained) {
    const t4 = localizer("PF2E.Item.Spell.Sustained"), e2 = "" === n ? t4("Label") : t4("Duration", { maximum: n });
    return "de" === game.i18n.lang ? e2 : e2.toLocaleLowerCase(game.i18n.lang);
  }
  return n || null;
}
function localizer(t3) {
  return (...[e, n]) => n ? i18nFormat(`${t3}.${e}`, n) : game.i18n.localize(`${t3}.${e}`);
}
const get_unprepare_slot_changes = (t3) => ({}), get_unprepare_slot_context = (t3) => ({});
function get_each_context$4(t3, e, n) {
  const i = t3.slice();
  return i[23] = e[n], i[25] = n, i;
}
function get_each_context_1$4(t3, e, n) {
  const i = t3.slice();
  return i[26] = e[n], i[25] = n, i;
}
function create_else_block$2(t3) {
  let e, n;
  return e = new ProOverlay({ props: { useOverlay: false } }), { c() {
    create_component(e.$$.fragment);
  }, m(t4, i) {
    mount_component(e, t4, i), n = true;
  }, p: noop, i(t4) {
    n || (transition_in(e.$$.fragment, t4), n = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), n = false;
  }, d(t4) {
    destroy_component(e, t4);
  } };
}
function create_if_block$8(t3) {
  let e, n, i, o, r, s, a, c, l, p, u, d, m, h, f, g, _, b = [], y = /* @__PURE__ */ new Map(), v = [], $2 = /* @__PURE__ */ new Map(), T = ensure_array_like(t3[4].traits);
  const w = (t4) => t4[25];
  for (let e2 = 0; e2 < T.length; e2 += 1) {
    let n2 = get_each_context_1$4(t3, T, e2), i2 = w(n2);
    y.set(i2, b[e2] = create_each_block_1$4(i2, n2));
  }
  let S = ensure_array_like(t3[3]);
  const k = (t4) => t4[25];
  for (let e2 = 0; e2 < S.length; e2 += 1) {
    let n2 = get_each_context$4(t3, S, e2), i2 = k(n2);
    $2.set(i2, v[e2] = create_each_block$4(i2, n2));
  }
  let O = t3[13] && "common" !== t3[13] && create_if_block_15(t3);
  const x = t3[18].default, E = create_slot(x, t3, t3[17], null);
  let M = t3[5] && create_if_block_14(t3), A = t3[6] && create_if_block_13(t3), C = (t3[7] || t3[8] || t3[9]) && create_if_block_8(t3), I = (t3[10] || t3[11]) && create_if_block_4$1(t3), P = t3[2] && create_if_block_3$1(t3), D = (t3[5] || t3[6] || t3[7] || t3[8] || t3[9] || t3[10] || t3[11]) && create_if_block_2$1(), N = t3[0] && create_if_block_1$3(t3);
  return { c() {
    e = element("div"), n = element("div");
    for (let t4 = 0; t4 < b.length; t4 += 1) b[t4].c();
    i = space();
    for (let t4 = 0; t4 < v.length; t4 += 1) v[t4].c();
    o = space(), O && O.c(), r = space(), E && E.c(), s = space(), a = element("section"), M && M.c(), c = space(), A && A.c(), l = space(), C && C.c(), p = space(), I && I.c(), u = space(), P && P.c(), d = space(), D && D.c(), m = space(), h = element("p"), f = space(), N && N.c(), g = empty(), attr(n, "class", "tags paizo-style"), attr(e, "class", "traits-and-control svelte-mobile-companion-pf2e-v340n8-176zcx4"), attr(a, "class", "info-block svelte-mobile-companion-pf2e-v340n8-176zcx4"), attr(h, "class", "description svelte-mobile-companion-pf2e-v340n8-176zcx4");
  }, m(y2, $3) {
    insert(y2, e, $3), append(e, n);
    for (let t4 = 0; t4 < b.length; t4 += 1) b[t4] && b[t4].m(n, null);
    append(n, i);
    for (let t4 = 0; t4 < v.length; t4 += 1) v[t4] && v[t4].m(n, null);
    append(n, o), O && O.m(n, null), append(e, r), E && E.m(e, null), insert(y2, s, $3), insert(y2, a, $3), M && M.m(a, null), append(a, c), A && A.m(a, null), append(a, l), C && C.m(a, null), append(a, p), I && I.m(a, null), append(a, u), P && P.m(a, null), append(a, d), D && D.m(a, null), insert(y2, m, $3), insert(y2, h, $3), h.innerHTML = t3[1], insert(y2, f, $3), N && N.m(y2, $3), insert(y2, g, $3), _ = true;
  }, p(t4, e2) {
    16 & e2 && (T = ensure_array_like(t4[4].traits), b = update_keyed_each(b, e2, w, 1, t4, T, y, n, destroy_block, create_each_block_1$4, i, get_each_context_1$4)), 8 & e2 && (S = ensure_array_like(t4[3]), v = update_keyed_each(v, e2, k, 1, t4, S, $2, n, destroy_block, create_each_block$4, o, get_each_context$4)), t4[13] && "common" !== t4[13] && O.p(t4, e2), E && E.p && (!_ || 131072 & e2) && update_slot_base(E, x, t4, t4[17], _ ? get_slot_changes(x, t4[17], e2, null) : get_all_dirty_from_scope(t4[17]), null), t4[5] && M.p(t4, e2), t4[6] && A.p(t4, e2), (t4[7] || t4[8] || t4[9]) && C.p(t4, e2), (t4[10] || t4[11]) && I.p(t4, e2), t4[2] ? P ? P.p(t4, e2) : (P = create_if_block_3$1(t4), P.c(), P.m(a, d)) : P && (P.d(1), P = null), (!_ || 2 & e2) && (h.innerHTML = t4[1]), t4[0] ? N ? (N.p(t4, e2), 1 & e2 && transition_in(N, 1)) : (N = create_if_block_1$3(t4), N.c(), transition_in(N, 1), N.m(g.parentNode, g)) : N && (group_outros(), transition_out(N, 1, 1, () => {
      N = null;
    }), check_outros());
  }, i(t4) {
    _ || (transition_in(E, t4), transition_in(N), _ = true);
  }, o(t4) {
    transition_out(E, t4), transition_out(N), _ = false;
  }, d(t4) {
    t4 && (detach(e), detach(s), detach(a), detach(m), detach(h), detach(f), detach(g));
    for (let t5 = 0; t5 < b.length; t5 += 1) b[t5].d();
    for (let t5 = 0; t5 < v.length; t5 += 1) v[t5].d();
    O && O.d(), E && E.d(t4), M && M.d(), A && A.d(), C && C.d(), I && I.d(), P && P.d(), D && D.d(), N && N.d(t4);
  } };
}
function create_each_block_1$4(t3, e) {
  let n;
  return { key: t3, first: null, c() {
    n = element("span"), n.textContent = `${e[26]}`, attr(n, "class", "tag svelte-mobile-companion-pf2e-v340n8-176zcx4"), this.first = n;
  }, m(t4, e2) {
    insert(t4, n, e2);
  }, p(t4, n2) {
    e = t4;
  }, d(t4) {
    t4 && detach(n);
  } };
}
function create_each_block$4(t3, e) {
  let n, i, o = e[23] + "";
  return { key: t3, first: null, c() {
    n = element("span"), i = text(o), attr(n, "class", "tag light property svelte-mobile-companion-pf2e-v340n8-176zcx4"), this.first = n;
  }, m(t4, e2) {
    insert(t4, n, e2), append(n, i);
  }, p(t4, n2) {
    e = t4, 8 & n2 && o !== (o = e[23] + "") && set_data(i, o);
  }, d(t4) {
    t4 && detach(n);
  } };
}
function create_if_block_15(t3) {
  let e;
  return { c() {
    e = element("span"), e.textContent = `${t3[13]}`, attr(e, "class", "tag svelte-mobile-companion-pf2e-v340n8-176zcx4");
  }, m(t4, n) {
    insert(t4, e, n);
  }, p: noop, d(t4) {
    t4 && detach(e);
  } };
}
function create_if_block_14(t3) {
  let e, n, i, o;
  return { c() {
    e = element("p"), n = element("strong"), n.textContent = `${i18n("PF2E.SpellTraditionsLabel")}`, i = space(), o = text(t3[5]), attr(e, "class", "svelte-mobile-companion-pf2e-v340n8-176zcx4");
  }, m(t4, r) {
    insert(t4, e, r), append(e, n), append(e, i), append(e, o);
  }, p: noop, d(t4) {
    t4 && detach(e);
  } };
}
function create_if_block_13(t3) {
  let e, n, i, o;
  return { c() {
    e = element("p"), n = element("strong"), n.textContent = `${i18n("PF2E.Item.Spell.Cast")}`, i = space(), o = element("span"), o.textContent = `${t3[4].actionGlyph ? null : t3[4].system.time.value || null}`, attr(e, "class", "item-block-line svelte-mobile-companion-pf2e-v340n8-176zcx4");
  }, m(t4, r) {
    insert(t4, e, r), append(e, n), append(e, i), append(e, o);
  }, p: noop, d(t4) {
    t4 && detach(e);
  } };
}
function create_if_block_8(t3) {
  let e, n, i, o = t3[7] && create_if_block_11(t3), r = t3[9] && create_if_block_10(t3), s = t3[8] && create_if_block_9(t3);
  return { c() {
    e = element("p"), o && o.c(), n = space(), r && r.c(), i = space(), s && s.c(), attr(e, "class", "item-block-line svelte-mobile-companion-pf2e-v340n8-176zcx4"), toggle_class(e, "last", !(t3[10] || t3[11]));
  }, m(t4, a) {
    insert(t4, e, a), o && o.m(e, null), append(e, n), r && r.m(e, null), append(e, i), s && s.m(e, null);
  }, p(t4, e2) {
    t4[7] && o.p(t4, e2), t4[9] && r.p(t4, e2), t4[8] && s.p(t4, e2);
  }, d(t4) {
    t4 && detach(e), o && o.d(), r && r.d(), s && s.d();
  } };
}
function create_if_block_11(t3) {
  let e, n, i, o, r = (t3[9] || t3[8]) && create_if_block_12();
  return { c() {
    e = element("span"), n = element("strong"), n.textContent = `${i18n("PF2E.TraitRange")}`, i = space(), o = text(t3[7]), r && r.c();
  }, m(t4, s) {
    insert(t4, e, s), append(e, n), append(e, i), append(e, o), r && r.m(e, null);
  }, p: noop, d(t4) {
    t4 && detach(e), r && r.d();
  } };
}
function create_if_block_12(t3) {
  let e, n = i18n("PF2E.Item.Spell.LineSplit") + "";
  return { c() {
    e = text(n);
  }, m(t4, n2) {
    insert(t4, e, n2);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_if_block_10(t3) {
  let e, n, i, o;
  return { c() {
    e = element("span"), n = element("strong"), n.textContent = `${i18n("PF2E.Area.Label")}`, i = space(), o = text(t3[9]);
  }, m(t4, r) {
    insert(t4, e, r), append(e, n), append(e, i), append(e, o);
  }, p: noop, d(t4) {
    t4 && detach(e);
  } };
}
function create_if_block_9(t3) {
  let e, n, i, o;
  return { c() {
    e = element("span"), n = element("strong"), n.textContent = `${i18n("PF2E.SpellTargetLabel")}`, i = space(), o = text(t3[8]);
  }, m(t4, r) {
    insert(t4, e, r), append(e, n), append(e, i), append(e, o);
  }, p: noop, d(t4) {
    t4 && detach(e);
  } };
}
function create_if_block_4$1(t3) {
  let e, n, i = t3[10] && create_if_block_6(t3), o = t3[11] && create_if_block_5(t3);
  return { c() {
    e = element("p"), i && i.c(), n = space(), o && o.c(), attr(e, "class", "item-block-line svelte-mobile-companion-pf2e-v340n8-176zcx4");
  }, m(t4, r) {
    insert(t4, e, r), i && i.m(e, null), append(e, n), o && o.m(e, null);
  }, p(t4, e2) {
    t4[10] && i.p(t4, e2), t4[11] && o.p(t4, e2);
  }, d(t4) {
    t4 && detach(e), i && i.d(), o && o.d();
  } };
}
function create_if_block_6(t3) {
  let e, n, i, o, r, s, a, c = t3[11] && create_if_block_7();
  return { c() {
    e = element("strong"), e.textContent = `${i18n("PF2E.Item.Spell.Defense.Label")}`, n = space(), i = text(t3[10]), o = text(" (DC "), r = text(t3[12]), s = text(")"), c && c.c(), a = empty();
  }, m(t4, l) {
    insert(t4, e, l), insert(t4, n, l), insert(t4, i, l), insert(t4, o, l), insert(t4, r, l), insert(t4, s, l), c && c.m(t4, l), insert(t4, a, l);
  }, p: noop, d(t4) {
    t4 && (detach(e), detach(n), detach(i), detach(o), detach(r), detach(s), detach(a)), c && c.d(t4);
  } };
}
function create_if_block_7(t3) {
  let e, n = i18n("PF2E.Item.Spell.LineSplit") + "";
  return { c() {
    e = text(n);
  }, m(t4, n2) {
    insert(t4, e, n2);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_if_block_5(t3) {
  let e, n, i;
  return { c() {
    e = element("strong"), e.textContent = `${i18n("PF2E.Time.Duration")}`, n = space(), i = text(t3[11]);
  }, m(t4, o) {
    insert(t4, e, o), insert(t4, n, o), insert(t4, i, o);
  }, p: noop, d(t4) {
    t4 && (detach(e), detach(n), detach(i));
  } };
}
function create_if_block_3$1(t3) {
  let e, n, i;
  return { c() {
    e = element("strong"), e.textContent = `${i18n("PF2E.Actions.EncouragingWords.Damage")}`, n = space(), i = text(t3[2]);
  }, m(t4, o) {
    insert(t4, e, o), insert(t4, n, o), insert(t4, i, o);
  }, p(t4, e2) {
    4 & e2 && set_data(i, t4[2]);
  }, d(t4) {
    t4 && (detach(e), detach(n), detach(i));
  } };
}
function create_if_block_2$1(t3) {
  let e;
  return { c() {
    e = element("hr"), attr(e, "class", "item-block-divider svelte-mobile-companion-pf2e-v340n8-176zcx4");
  }, m(t4, n) {
    insert(t4, e, n);
  }, d(t4) {
    t4 && detach(e);
  } };
}
function create_if_block_1$3(t3) {
  let e;
  const n = t3[18].unprepare, i = create_slot(n, t3, t3[17], get_unprepare_slot_context);
  return { c() {
    i && i.c();
  }, m(t4, n2) {
    i && i.m(t4, n2), e = true;
  }, p(t4, o) {
    i && i.p && (!e || 131072 & o) && update_slot_base(i, n, t4, t4[17], e ? get_slot_changes(n, t4[17], o, get_unprepare_slot_changes) : get_all_dirty_from_scope(t4[17]), get_unprepare_slot_context);
  }, i(t4) {
    e || (transition_in(i, t4), e = true);
  }, o(t4) {
    transition_out(i, t4), e = false;
  }, d(t4) {
    i && i.d(t4);
  } };
}
function create_fragment$8(t3) {
  let e, n, i, o, r;
  const s = [create_if_block$8, create_else_block$2], a = [];
  return n = function(t4) {
    return t4[14] ? 0 : 1;
  }(t3), i = a[n] = s[n](t3), { c() {
    e = element("section"), i.c(), attr(e, "class", "item-summary svelte-mobile-companion-pf2e-v340n8-176zcx4");
  }, m(t4, i2) {
    insert(t4, e, i2), a[n].m(e, null), r = true;
  }, p(t4, [e2]) {
    i.p(t4, e2);
  }, i(t4) {
    r || (transition_in(i), t4 && add_render_callback(() => {
      r && (o || (o = create_bidirectional_transition(e, slide, { duration: 200, easing: identity, axis: "y" }, true)), o.run(1));
    }), r = true);
  }, o(t4) {
    transition_out(i), t4 && (o || (o = create_bidirectional_transition(e, slide, { duration: 200, easing: identity, axis: "y" }, false)), o.run(0)), r = false;
  }, d(t4) {
    t4 && detach(e), a[n].d(), t4 && o && o.end();
  } };
}
function instance$8(t3, e, n) {
  let { $$slots: i = {}, $$scope: o } = e;
  var r, s, a, c;
  let { spell: l } = e, { showUnpreparedButton: p = true } = e, { castRank: u } = e;
  const d = l.getRollData({ castRank: u }).item, m = getTraditions(d), h = d.actionGlyph ? null : d.system.time.value || null, f = d.system.range.value.trim() || null, g = d.system.target.value.trim() || null, _ = null !== (s = null === (r = d.area) || void 0 === r ? void 0 : r.label) && void 0 !== s ? s : null, b = getDefenseLabel(d), y = getDurationLabel(d), v = null === (c = null === (a = d.spellcasting.statistic) || void 0 === a ? void 0 : a.dc) || void 0 === c ? void 0 : c.value, $2 = d.rarity, T = d.isCantrip || d.isRitual || u < 3;
  let w, S = "";
  enrichText(d.description).then((t4) => {
    n(1, S = t4);
  }).catch((t4) => {
    console.error("(There was an error:", t4.message);
  });
  let k = [];
  return d.getChatData().then((t4) => {
    t4.hasDamage && (n(2, w = t4.formula), n(3, k = t4.properties));
  }), t3.$$set = (t4) => {
    "spell" in t4 && n(15, l = t4.spell), "showUnpreparedButton" in t4 && n(0, p = t4.showUnpreparedButton), "castRank" in t4 && n(16, u = t4.castRank), "$$scope" in t4 && n(17, o = t4.$$scope);
  }, [p, S, w, k, d, m, h, f, g, _, b, y, v, $2, T, l, u, o, i];
}
class Pf2eSpellDescription extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$8, create_fragment$8, safe_not_equal, { spell: 15, showUnpreparedButton: 0, castRank: 16 });
  }
}
function create_if_block$7(t3) {
  let e, n;
  return e = new Pf2eSpellDescription({ props: { spell: t3[0], showUnpreparedButton: t3[2], castRank: t3[3], $$slots: { unprepare: [create_unprepare_slot], default: [create_default_slot$3] }, $$scope: { ctx: t3 } } }), { c() {
    create_component(e.$$.fragment);
  }, m(t4, i) {
    mount_component(e, t4, i), n = true;
  }, p(t4, n2) {
    const i = {};
    1 & n2 && (i.spell = t4[0]), 4 & n2 && (i.showUnpreparedButton = t4[2]), 8 & n2 && (i.castRank = t4[3]), 256 & n2 && (i.$$scope = { dirty: n2, ctx: t4 }), e.$set(i);
  }, i(t4) {
    n || (transition_in(e.$$.fragment, t4), n = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), n = false;
  }, d(t4) {
    destroy_component(e, t4);
  } };
}
function create_default_slot$3(t3) {
  let e;
  const n = t3[7].default, i = create_slot(n, t3, t3[8], null);
  return { c() {
    i && i.c();
  }, m(t4, n2) {
    i && i.m(t4, n2), e = true;
  }, p(t4, o) {
    i && i.p && (!e || 256 & o) && update_slot_base(i, n, t4, t4[8], e ? get_slot_changes(n, t4[8], o, null) : get_all_dirty_from_scope(t4[8]), null);
  }, i(t4) {
    e || (transition_in(i, t4), e = true);
  }, o(t4) {
    transition_out(i, t4), e = false;
  }, d(t4) {
    i && i.d(t4);
  } };
}
function create_unprepare_slot(t3) {
  let e, n, i, o;
  return { c() {
    e = element("div"), n = element("button"), n.textContent = `${myi18n("PF2E.Unprepare")}`, attr(n, "class", "svelte-mobile-companion-pf2e-v340n8-1spwcg0"), attr(e, "slot", "unprepare"), attr(e, "class", "unprepare-container svelte-mobile-companion-pf2e-v340n8-1spwcg0");
  }, m(r, s) {
    insert(r, e, s), append(e, n), i || (o = listen(n, "click", t3[6]), i = true);
  }, p: noop, d(t4) {
    t4 && detach(e), i = false, o();
  } };
}
function create_fragment$7(t3) {
  let e, n, i, o, r, s, a, c, l, p, u, d, m, h, f, g, _, b, y, v, $2, T, w, S = t3[0].name + "", k = (t3[0].actionGlyph ?? "") + "", O = (t3[0].defense ? t3[0].defense.label : "") + "", x = t3[0].system.range.value + "", E = t3[4] && create_if_block$7(t3);
  return { c() {
    e = element("li"), n = element("div"), i = element("div"), o = element("img"), a = space(), c = element("div"), l = element("p"), p = text(S), u = space(), d = element("span"), m = text(k), h = space(), f = element("div"), g = text(O), _ = space(), b = element("div"), y = text(x), v = space(), E && E.c(), attr(o, "class", "item-icon svelte-mobile-companion-pf2e-v340n8-1spwcg0"), src_url_equal(o.src, r = t3[0].img) || attr(o, "src", r), attr(o, "alt", s = t3[0].name), attr(i, "class", "item-image svelte-mobile-companion-pf2e-v340n8-1spwcg0"), toggle_class(i, "expended", t3[1]), attr(l, "class", "svelte-mobile-companion-pf2e-v340n8-1spwcg0"), attr(d, "class", "action-glyph svelte-mobile-companion-pf2e-v340n8-1spwcg0"), attr(c, "class", "name svelte-mobile-companion-pf2e-v340n8-1spwcg0"), toggle_class(c, "expended", t3[1]), attr(n, "class", "item-name svelte-mobile-companion-pf2e-v340n8-1spwcg0"), attr(n, "role", "button"), attr(n, "tabindex", "0"), attr(f, "class", "defense svelte-mobile-companion-pf2e-v340n8-1spwcg0"), attr(b, "class", "range svelte-mobile-companion-pf2e-v340n8-1spwcg0"), attr(e, "class", "spell svelte-mobile-companion-pf2e-v340n8-1spwcg0");
  }, m(r2, s2) {
    insert(r2, e, s2), append(e, n), append(n, i), append(i, o), append(n, a), append(n, c), append(c, l), append(l, p), append(c, u), append(c, d), append(d, m), append(e, h), append(e, f), append(f, g), append(e, _), append(e, b), append(b, y), append(e, v), E && E.m(e, null), $2 = true, T || (w = [listen(n, "click", stop_propagation(prevent_default(t3[5]))), listen(n, "keypress", t3[5])], T = true);
  }, p(t4, [n2]) {
    (!$2 || 1 & n2 && !src_url_equal(o.src, r = t4[0].img)) && attr(o, "src", r), (!$2 || 1 & n2 && s !== (s = t4[0].name)) && attr(o, "alt", s), (!$2 || 2 & n2) && toggle_class(i, "expended", t4[1]), (!$2 || 1 & n2) && S !== (S = t4[0].name + "") && set_data(p, S), (!$2 || 1 & n2) && k !== (k = (t4[0].actionGlyph ?? "") + "") && set_data(m, k), (!$2 || 2 & n2) && toggle_class(c, "expended", t4[1]), (!$2 || 1 & n2) && O !== (O = (t4[0].defense ? t4[0].defense.label : "") + "") && set_data(g, O), (!$2 || 1 & n2) && x !== (x = t4[0].system.range.value + "") && set_data(y, x), t4[4] ? E ? (E.p(t4, n2), 16 & n2 && transition_in(E, 1)) : (E = create_if_block$7(t4), E.c(), transition_in(E, 1), E.m(e, null)) : E && (group_outros(), transition_out(E, 1, 1, () => {
      E = null;
    }), check_outros());
  }, i(t4) {
    $2 || (transition_in(E), $2 = true);
  }, o(t4) {
    transition_out(E), $2 = false;
  }, d(t4) {
    t4 && detach(e), E && E.d(), T = false, run_all(w);
  } };
}
function instance$7(t3, e, n) {
  let { $$slots: i = {}, $$scope: o } = e, { spell: r } = e, { isExpended: s = false } = e, { showUnpreparedButton: a = !r.parentItem && !r.isRitual } = e, { castRank: c } = e;
  const l = createEventDispatcher();
  let p = false;
  return t3.$$set = (t4) => {
    "spell" in t4 && n(0, r = t4.spell), "isExpended" in t4 && n(1, s = t4.isExpended), "showUnpreparedButton" in t4 && n(2, a = t4.showUnpreparedButton), "castRank" in t4 && n(3, c = t4.castRank), "$$scope" in t4 && n(8, o = t4.$$scope);
  }, [r, s, a, c, p, function() {
    n(4, p = !p);
  }, function() {
    l("unprepare");
  }, i, o];
}
class Pf2eSpell extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$7, create_fragment$7, safe_not_equal, { spell: 0, isExpended: 1, showUnpreparedButton: 2, castRank: 3 });
  }
}
function create_if_block$6(t3) {
  let e, n, i, o, r;
  return { c() {
    e = element("div"), n = element("button"), i = text(t3[2]), attr(n, "type", "button"), attr(n, "class", "cast-spell svelte-mobile-companion-pf2e-v340n8-1gycuez"), toggle_class(n, "blue", !t3[0].expended), attr(e, "class", "cast-restore svelte-mobile-companion-pf2e-v340n8-1gycuez");
  }, m(s, a) {
    insert(s, e, a), append(e, n), append(n, i), o || (r = listen(n, "click", t3[4]), o = true);
  }, p(t4, e2) {
    4 & e2 && set_data(i, t4[2]), 1 & e2 && toggle_class(n, "blue", !t4[0].expended);
  }, d(t4) {
    t4 && detach(e), o = false, r();
  } };
}
function create_default_slot$2(t3) {
  let e, n = !t3[3].isCantrip && create_if_block$6(t3);
  return { c() {
    n && n.c(), e = empty();
  }, m(t4, i) {
    n && n.m(t4, i), insert(t4, e, i);
  }, p(t4, e2) {
    t4[3].isCantrip || n.p(t4, e2);
  }, d(t4) {
    t4 && detach(e), n && n.d(t4);
  } };
}
function create_fragment$6(t3) {
  let e, n;
  return e = new Pf2eSpell({ props: { spell: t3[3], isExpended: t3[0].expended, castRank: t3[1], $$slots: { default: [create_default_slot$2] }, $$scope: { ctx: t3 } } }), e.$on("unprepare", t3[5]), { c() {
    create_component(e.$$.fragment);
  }, m(t4, i) {
    mount_component(e, t4, i), n = true;
  }, p(t4, [n2]) {
    const i = {};
    1 & n2 && (i.isExpended = t4[0].expended), 2 & n2 && (i.castRank = t4[1]), 261 & n2 && (i.$$scope = { dirty: n2, ctx: t4 }), e.$set(i);
  }, i(t4) {
    n || (transition_in(e.$$.fragment, t4), n = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), n = false;
  }, d(t4) {
    destroy_component(e, t4);
  } };
}
function instance$6(t3, e, n) {
  let { activeSpell: i } = e, { castRank: o } = e;
  const r = createEventDispatcher();
  let s = i.spell;
  const a = s.parentItem;
  let c;
  return t3.$$set = (t4) => {
    "activeSpell" in t4 && n(0, i = t4.activeSpell), "castRank" in t4 && n(1, o = t4.castRank);
  }, t3.$$.update = () => {
    1 & t3.$$.dirty && n(2, c = a ? i18n("PF2E.CastLabel") : i.expended ? myi18n("PF2E.Restore") : i18n("PF2E.CastLabel"));
  }, [i, o, c, s, function() {
    r("castSpell", i.expended);
  }, function() {
    r("unprepare");
  }];
}
class Pf2eActiveSpell extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$6, create_fragment$6, safe_not_equal, { activeSpell: 0, castRank: 1 });
  }
}
function get_each_context$3(t3, e, n) {
  const i = t3.slice();
  return i[6] = e[n], i[8] = n, i;
}
function get_each_context_1$3(t3, e, n) {
  const i = t3.slice();
  return i[9] = e[n], i;
}
function get_each_context_2$2(t3, e, n) {
  const i = t3.slice();
  return i[12] = e[n], i[8] = n, i;
}
function create_if_block$5(t3) {
  let e, n, i = [], o = /* @__PURE__ */ new Map(), r = ensure_array_like(t3[0]);
  const s = (t4) => t4[8];
  for (let e2 = 0; e2 < r.length; e2 += 1) {
    let n2 = get_each_context$3(t3, r, e2), a = s(n2);
    o.set(a, i[e2] = create_each_block$3(a, n2));
  }
  return { c() {
    e = element("section");
    for (let t4 = 0; t4 < i.length; t4 += 1) i[t4].c();
  }, m(t4, o2) {
    insert(t4, e, o2);
    for (let t5 = 0; t5 < i.length; t5 += 1) i[t5] && i[t5].m(e, null);
    n = true;
  }, p(t4, n2) {
    7 & n2 && (r = ensure_array_like(t4[0]), group_outros(), i = update_keyed_each(i, n2, s, 1, t4, r, o, e, outro_and_destroy_block, create_each_block$3, null, get_each_context$3), check_outros());
  }, i(t4) {
    if (!n) {
      for (let t5 = 0; t5 < r.length; t5 += 1) transition_in(i[t5]);
      n = true;
    }
  }, o(t4) {
    for (let t5 = 0; t5 < i.length; t5 += 1) transition_out(i[t5]);
    n = false;
  }, d(t4) {
    t4 && detach(e);
    for (let t5 = 0; t5 < i.length; t5 += 1) i[t5].d();
  } };
}
function create_else_block$1(t3) {
  let e, n;
  return e = new Pf2eEmptySpellSlot({ props: { collectionAndSheet: t3[6], clickedGroupId: t3[9].id, clickedSlot: t3[8] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t4, i) {
    mount_component(e, t4, i), n = true;
  }, p(t4, n2) {
    const i = {};
    1 & n2 && (i.collectionAndSheet = t4[6]), 1 & n2 && (i.clickedGroupId = t4[9].id), 1 & n2 && (i.clickedSlot = t4[8]), e.$set(i);
  }, i(t4) {
    n || (transition_in(e.$$.fragment, t4), n = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), n = false;
  }, d(t4) {
    destroy_component(e, t4);
  } };
}
function create_if_block_1$2(t3) {
  let e, n;
  return e = new Pf2eActiveSpell({ props: { activeSpell: t3[12], castRank: t3[9].id } }), e.$on("castSpell", function(...e2) {
    return t3[3](t3[12], t3[8], t3[9], t3[6], ...e2);
  }), e.$on("unprepare", function() {
    return t3[4](t3[6], t3[9], t3[8]);
  }), { c() {
    create_component(e.$$.fragment);
  }, m(t4, i) {
    mount_component(e, t4, i), n = true;
  }, p(n2, i) {
    t3 = n2;
    const o = {};
    1 & i && (o.activeSpell = t3[12]), 1 & i && (o.castRank = t3[9].id), e.$set(o);
  }, i(t4) {
    n || (transition_in(e.$$.fragment, t4), n = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), n = false;
  }, d(t4) {
    destroy_component(e, t4);
  } };
}
function create_each_block_2$2(t3, e) {
  let n, i, o, r, s;
  const a = [create_if_block_1$2, create_else_block$1], c = [];
  function l(t4, e2) {
    return t4[12] ? 0 : 1;
  }
  return i = l(e), o = c[i] = a[i](e), { key: t3, first: null, c() {
    n = empty(), o.c(), r = empty(), this.first = n;
  }, m(t4, e2) {
    insert(t4, n, e2), c[i].m(t4, e2), insert(t4, r, e2), s = true;
  }, p(t4, n2) {
    let s2 = i;
    i = l(e = t4), i === s2 ? c[i].p(e, n2) : (group_outros(), transition_out(c[s2], 1, 1, () => {
      c[s2] = null;
    }), check_outros(), o = c[i], o ? o.p(e, n2) : (o = c[i] = a[i](e), o.c()), transition_in(o, 1), o.m(r.parentNode, r));
  }, i(t4) {
    s || (transition_in(o), s = true);
  }, o(t4) {
    transition_out(o), s = false;
  }, d(t4) {
    t4 && (detach(n), detach(r)), c[i].d(t4);
  } };
}
function create_key_block$1(t3) {
  let e, n, i = [], o = /* @__PURE__ */ new Map(), r = ensure_array_like(t3[9].active);
  const s = (t4) => t4[8];
  for (let e2 = 0; e2 < r.length; e2 += 1) {
    let n2 = get_each_context_2$2(t3, r, e2), a = s(n2);
    o.set(a, i[e2] = create_each_block_2$2(a, n2));
  }
  return { c() {
    e = element("ol");
    for (let t4 = 0; t4 < i.length; t4 += 1) i[t4].c();
    attr(e, "class", "svelte-mobile-companion-pf2e-v340n8-1y2g42t");
  }, m(t4, o2) {
    insert(t4, e, o2);
    for (let t5 = 0; t5 < i.length; t5 += 1) i[t5] && i[t5].m(e, null);
    n = true;
  }, p(t4, n2) {
    5 & n2 && (r = ensure_array_like(t4[9].active), group_outros(), i = update_keyed_each(i, n2, s, 1, t4, r, o, e, outro_and_destroy_block, create_each_block_2$2, null, get_each_context_2$2), check_outros());
  }, i(t4) {
    if (!n) {
      for (let t5 = 0; t5 < r.length; t5 += 1) transition_in(i[t5]);
      n = true;
    }
  }, o(t4) {
    for (let t5 = 0; t5 < i.length; t5 += 1) transition_out(i[t5]);
    n = false;
  }, d(t4) {
    t4 && detach(e);
    for (let t5 = 0; t5 < i.length; t5 += 1) i[t5].d();
  } };
}
function create_each_block_1$3(t3, e) {
  let n, i, o, r, s = e[1];
  i = new Pf2eSpellCategoryHeader({ props: { spellGroupLabel: i18n(e[9].label) } });
  let a = create_key_block$1(e);
  return { key: t3, first: null, c() {
    n = element("section"), create_component(i.$$.fragment), o = space(), a.c(), this.first = n;
  }, m(t4, e2) {
    insert(t4, n, e2), mount_component(i, n, null), append(n, o), a.m(n, null), r = true;
  }, p(t4, o2) {
    e = t4;
    const r2 = {};
    1 & o2 && (r2.spellGroupLabel = i18n(e[9].label)), i.$set(r2), 2 & o2 && safe_not_equal(s, s = e[1]) ? (group_outros(), transition_out(a, 1, 1, noop), check_outros(), a = create_key_block$1(e), a.c(), transition_in(a, 1), a.m(n, null)) : a.p(e, o2);
  }, i(t4) {
    r || (transition_in(i.$$.fragment, t4), transition_in(a), r = true);
  }, o(t4) {
    transition_out(i.$$.fragment, t4), transition_out(a), r = false;
  }, d(t4) {
    t4 && detach(n), destroy_component(i), a.d(t4);
  } };
}
function create_each_block$3(t3, e) {
  let n, i, o, r, s, a, c, l = [], p = /* @__PURE__ */ new Map();
  i = new Pf2eSpellActionHeader({ props: { title: e[6].sheetData.name } }), r = new Pf2eSpellAbilityData({ props: { spellCategory: e[6].sheetData } });
  let u = ensure_array_like(e[6].sheetData.groups);
  const d = (t4) => t4[9].id;
  for (let t4 = 0; t4 < u.length; t4 += 1) {
    let n2 = get_each_context_1$3(e, u, t4), i2 = d(n2);
    p.set(i2, l[t4] = create_each_block_1$3(i2, n2));
  }
  return { key: t3, first: null, c() {
    n = element("section"), create_component(i.$$.fragment), o = space(), create_component(r.$$.fragment), s = space();
    for (let t4 = 0; t4 < l.length; t4 += 1) l[t4].c();
    a = space(), this.first = n;
  }, m(t4, e2) {
    insert(t4, n, e2), mount_component(i, n, null), append(n, o), mount_component(r, n, null), append(n, s);
    for (let t5 = 0; t5 < l.length; t5 += 1) l[t5] && l[t5].m(n, null);
    append(n, a), c = true;
  }, p(t4, o2) {
    e = t4;
    const s2 = {};
    1 & o2 && (s2.title = e[6].sheetData.name), i.$set(s2);
    const c2 = {};
    1 & o2 && (c2.spellCategory = e[6].sheetData), r.$set(c2), 7 & o2 && (u = ensure_array_like(e[6].sheetData.groups), group_outros(), l = update_keyed_each(l, o2, d, 1, e, u, p, n, outro_and_destroy_block, create_each_block_1$3, a, get_each_context_1$3), check_outros());
  }, i(t4) {
    if (!c) {
      transition_in(i.$$.fragment, t4), transition_in(r.$$.fragment, t4);
      for (let t5 = 0; t5 < u.length; t5 += 1) transition_in(l[t5]);
      c = true;
    }
  }, o(t4) {
    transition_out(i.$$.fragment, t4), transition_out(r.$$.fragment, t4);
    for (let t5 = 0; t5 < l.length; t5 += 1) transition_out(l[t5]);
    c = false;
  }, d(t4) {
    t4 && detach(n), destroy_component(i), destroy_component(r);
    for (let t5 = 0; t5 < l.length; t5 += 1) l[t5].d();
  } };
}
function create_fragment$5(t3) {
  let e, n, i = t3[0] && create_if_block$5(t3);
  return { c() {
    i && i.c(), e = empty();
  }, m(t4, o) {
    i && i.m(t4, o), insert(t4, e, o), n = true;
  }, p(t4, [n2]) {
    t4[0] ? i ? (i.p(t4, n2), 1 & n2 && transition_in(i, 1)) : (i = create_if_block$5(t4), i.c(), transition_in(i, 1), i.m(e.parentNode, e)) : i && (group_outros(), transition_out(i, 1, 1, () => {
      i = null;
    }), check_outros());
  }, i(t4) {
    n || (transition_in(i), n = true);
  }, o(t4) {
    transition_out(i), n = false;
  }, d(t4) {
    t4 && detach(e), i && i.d(t4);
  } };
}
function unprepare(t3, e, n) {
  foundry.utils.isNewerVersion(game.system.version, "6.11.2") ? t3.spellCollection.prepareSpell(null, e.id, n) : t3.spellCollection.unprepareSpell(e.id, n);
}
function instance$5(t3, e, n) {
  var i = this && this.__awaiter || function(t4, e2, n2, i2) {
    return new (n2 || (n2 = Promise))(function(o2, r2) {
      function s2(t5) {
        try {
          c(i2.next(t5));
        } catch (t6) {
          r2(t6);
        }
      }
      function a(t5) {
        try {
          c(i2.throw(t5));
        } catch (t6) {
          r2(t6);
        }
      }
      function c(t5) {
        var e3;
        t5.done ? o2(t5.value) : (e3 = t5.value, e3 instanceof n2 ? e3 : new n2(function(t6) {
          t6(e3);
        })).then(s2, a);
      }
      c((i2 = i2.apply(t4, e2 || [])).next());
    });
  };
  let { spellCollectionAndSheetData: o } = e, r = 0;
  function s(t4, e2, n2, o2, r2) {
    return i(this, void 0, void 0, function* () {
      if (t4.detail) yield r2.setSlotExpendedState(o2, n2, false);
      else {
        const t5 = e2.spellcasting;
        yield t5.consume(e2, e2.rank, n2);
      }
    });
  }
  return t3.$$set = (t4) => {
    "spellCollectionAndSheetData" in t4 && n(0, o = t4.spellCollectionAndSheetData);
  }, t3.$$.update = () => {
    1 & t3.$$.dirty && n(1, r = (null == o ? void 0 : o.length) > 0 ? Math.random() : 0);
  }, [o, r, s, (t4, e2, n2, i2, o2) => s(o2, t4.spell, e2, n2.id, i2.spellCollection), (t4, e2, n2) => unprepare(t4, e2, n2)];
}
class Pf2eKnownSpells extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$5, create_fragment$5, safe_not_equal, { spellCollectionAndSheetData: 0 });
  }
}
function get_each_context$2(t3, e, n) {
  const i = t3.slice();
  return i[1] = e[n], i[3] = n, i;
}
function get_each_context_1$2(t3, e, n) {
  const i = t3.slice();
  return i[4] = e[n], i;
}
function get_each_context_2$1(t3, e, n) {
  const i = t3.slice();
  return i[7] = e[n], i[3] = n, i;
}
function create_if_block$4(t3) {
  let e, n;
  return e = new Pf2eSpell({ props: { spell: t3[7].spell } }), { c() {
    create_component(e.$$.fragment);
  }, m(t4, i) {
    mount_component(e, t4, i), n = true;
  }, p(t4, n2) {
    const i = {};
    1 & n2 && (i.spell = t4[7].spell), e.$set(i);
  }, i(t4) {
    n || (transition_in(e.$$.fragment, t4), n = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), n = false;
  }, d(t4) {
    destroy_component(e, t4);
  } };
}
function create_each_block_2$1(t3, e) {
  let n, i, o, r = e[7] && create_if_block$4(e);
  return { key: t3, first: null, c() {
    n = empty(), r && r.c(), i = empty(), this.first = n;
  }, m(t4, e2) {
    insert(t4, n, e2), r && r.m(t4, e2), insert(t4, i, e2), o = true;
  }, p(t4, n2) {
    (e = t4)[7] ? r ? (r.p(e, n2), 1 & n2 && transition_in(r, 1)) : (r = create_if_block$4(e), r.c(), transition_in(r, 1), r.m(i.parentNode, i)) : r && (group_outros(), transition_out(r, 1, 1, () => {
      r = null;
    }), check_outros());
  }, i(t4) {
    o || (transition_in(r), o = true);
  }, o(t4) {
    transition_out(r), o = false;
  }, d(t4) {
    t4 && (detach(n), detach(i)), r && r.d(t4);
  } };
}
function create_each_block_1$2(t3, e) {
  let n, i, o, r, s, a = [], c = /* @__PURE__ */ new Map();
  i = new Pf2eSpellCategoryHeader({ props: { spellGroupLabel: i18n(e[4].label) } });
  let l = ensure_array_like(e[4].active);
  const p = (t4) => t4[3];
  for (let t4 = 0; t4 < l.length; t4 += 1) {
    let n2 = get_each_context_2$1(e, l, t4), i2 = p(n2);
    c.set(i2, a[t4] = create_each_block_2$1(i2, n2));
  }
  return { key: t3, first: null, c() {
    n = element("section"), create_component(i.$$.fragment), o = space(), r = element("ol");
    for (let t4 = 0; t4 < a.length; t4 += 1) a[t4].c();
    attr(r, "class", "svelte-mobile-companion-pf2e-v340n8-1y2g42t"), this.first = n;
  }, m(t4, e2) {
    insert(t4, n, e2), mount_component(i, n, null), append(n, o), append(n, r);
    for (let t5 = 0; t5 < a.length; t5 += 1) a[t5] && a[t5].m(r, null);
    s = true;
  }, p(t4, n2) {
    e = t4;
    const o2 = {};
    1 & n2 && (o2.spellGroupLabel = i18n(e[4].label)), i.$set(o2), 1 & n2 && (l = ensure_array_like(e[4].active), group_outros(), a = update_keyed_each(a, n2, p, 1, e, l, c, r, outro_and_destroy_block, create_each_block_2$1, null, get_each_context_2$1), check_outros());
  }, i(t4) {
    if (!s) {
      transition_in(i.$$.fragment, t4);
      for (let t5 = 0; t5 < l.length; t5 += 1) transition_in(a[t5]);
      s = true;
    }
  }, o(t4) {
    transition_out(i.$$.fragment, t4);
    for (let t5 = 0; t5 < a.length; t5 += 1) transition_out(a[t5]);
    s = false;
  }, d(t4) {
    t4 && detach(n), destroy_component(i);
    for (let t5 = 0; t5 < a.length; t5 += 1) a[t5].d();
  } };
}
function create_each_block$2(t3, e) {
  let n, i, o, r, s, a, c = [], l = /* @__PURE__ */ new Map();
  i = new Pf2eSpellActionHeader({ props: { title: e[1].sheetData.name } });
  let p = ensure_array_like(e[1].sheetData.groups);
  const u = (t4) => t4[4].id;
  for (let t4 = 0; t4 < p.length; t4 += 1) {
    let n2 = get_each_context_1$2(e, p, t4), i2 = u(n2);
    l.set(i2, c[t4] = create_each_block_1$2(i2, n2));
  }
  return { key: t3, first: null, c() {
    n = empty(), create_component(i.$$.fragment), o = space(), r = element("section");
    for (let t4 = 0; t4 < c.length; t4 += 1) c[t4].c();
    s = space(), this.first = n;
  }, m(t4, e2) {
    insert(t4, n, e2), mount_component(i, t4, e2), insert(t4, o, e2), insert(t4, r, e2);
    for (let t5 = 0; t5 < c.length; t5 += 1) c[t5] && c[t5].m(r, null);
    append(r, s), a = true;
  }, p(t4, n2) {
    e = t4;
    const o2 = {};
    1 & n2 && (o2.title = e[1].sheetData.name), i.$set(o2), 1 & n2 && (p = ensure_array_like(e[1].sheetData.groups), group_outros(), c = update_keyed_each(c, n2, u, 1, e, p, l, r, outro_and_destroy_block, create_each_block_1$2, s, get_each_context_1$2), check_outros());
  }, i(t4) {
    if (!a) {
      transition_in(i.$$.fragment, t4);
      for (let t5 = 0; t5 < p.length; t5 += 1) transition_in(c[t5]);
      a = true;
    }
  }, o(t4) {
    transition_out(i.$$.fragment, t4);
    for (let t5 = 0; t5 < c.length; t5 += 1) transition_out(c[t5]);
    a = false;
  }, d(t4) {
    t4 && (detach(n), detach(o), detach(r)), destroy_component(i, t4);
    for (let t5 = 0; t5 < c.length; t5 += 1) c[t5].d();
  } };
}
function create_fragment$4(t3) {
  let e, n, i = [], o = /* @__PURE__ */ new Map(), r = ensure_array_like(t3[0]);
  const s = (t4) => t4[3];
  for (let e2 = 0; e2 < r.length; e2 += 1) {
    let n2 = get_each_context$2(t3, r, e2), a = s(n2);
    o.set(a, i[e2] = create_each_block$2(a, n2));
  }
  return { c() {
    e = element("section");
    for (let t4 = 0; t4 < i.length; t4 += 1) i[t4].c();
  }, m(t4, o2) {
    insert(t4, e, o2);
    for (let t5 = 0; t5 < i.length; t5 += 1) i[t5] && i[t5].m(e, null);
    n = true;
  }, p(t4, [n2]) {
    1 & n2 && (r = ensure_array_like(t4[0]), group_outros(), i = update_keyed_each(i, n2, s, 1, t4, r, o, e, outro_and_destroy_block, create_each_block$2, null, get_each_context$2), check_outros());
  }, i(t4) {
    if (!n) {
      for (let t5 = 0; t5 < r.length; t5 += 1) transition_in(i[t5]);
      n = true;
    }
  }, o(t4) {
    for (let t5 = 0; t5 < i.length; t5 += 1) transition_out(i[t5]);
    n = false;
  }, d(t4) {
    t4 && detach(e);
    for (let t5 = 0; t5 < i.length; t5 += 1) i[t5].d();
  } };
}
function instance$4(t3, e, n) {
  let { spellCollectionAndSheetData: i } = e;
  return t3.$$set = (t4) => {
    "spellCollectionAndSheetData" in t4 && n(0, i = t4.spellCollectionAndSheetData);
  }, [i];
}
class Pf2eRituals extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$4, create_fragment$4, safe_not_equal, { spellCollectionAndSheetData: 0 });
  }
}
function get_each_context$1(t3, e, n) {
  const i = t3.slice();
  return i[4] = e[n], i[6] = n, i;
}
function get_each_context_1$1(t3, e, n) {
  const i = t3.slice();
  return i[7] = e[n], i;
}
function get_each_context_2(t3, e, n) {
  const i = t3.slice();
  return i[10] = e[n], i[6] = n, i;
}
function create_if_block$3(t3) {
  let e, n;
  return e = new Pf2eActiveSpell({ props: { activeSpell: t3[10] } }), e.$on("castSpell", function() {
    return t3[2](t3[10]);
  }), { c() {
    create_component(e.$$.fragment);
  }, m(t4, i) {
    mount_component(e, t4, i), n = true;
  }, p(n2, i) {
    t3 = n2;
    const o = {};
    1 & i && (o.activeSpell = t3[10]), e.$set(o);
  }, i(t4) {
    n || (transition_in(e.$$.fragment, t4), n = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), n = false;
  }, d(t4) {
    destroy_component(e, t4);
  } };
}
function create_each_block_2(t3, e) {
  let n, i, o, r = e[10] && create_if_block$3(e);
  return { key: t3, first: null, c() {
    n = empty(), r && r.c(), i = empty(), this.first = n;
  }, m(t4, e2) {
    insert(t4, n, e2), r && r.m(t4, e2), insert(t4, i, e2), o = true;
  }, p(t4, n2) {
    (e = t4)[10] ? r ? (r.p(e, n2), 1 & n2 && transition_in(r, 1)) : (r = create_if_block$3(e), r.c(), transition_in(r, 1), r.m(i.parentNode, i)) : r && (group_outros(), transition_out(r, 1, 1, () => {
      r = null;
    }), check_outros());
  }, i(t4) {
    o || (transition_in(r), o = true);
  }, o(t4) {
    transition_out(r), o = false;
  }, d(t4) {
    t4 && (detach(n), detach(i)), r && r.d(t4);
  } };
}
function create_each_block_1$1(t3, e) {
  let n, i, o, r, s, a = [], c = /* @__PURE__ */ new Map();
  i = new Pf2eSpellCategoryHeader({ props: { spellGroupLabel: i18n(e[7].label) } });
  let l = ensure_array_like(e[7].active);
  const p = (t4) => t4[6];
  for (let t4 = 0; t4 < l.length; t4 += 1) {
    let n2 = get_each_context_2(e, l, t4), i2 = p(n2);
    c.set(i2, a[t4] = create_each_block_2(i2, n2));
  }
  return { key: t3, first: null, c() {
    n = element("section"), create_component(i.$$.fragment), o = space(), r = element("ol");
    for (let t4 = 0; t4 < a.length; t4 += 1) a[t4].c();
    attr(r, "class", "svelte-mobile-companion-pf2e-v340n8-1y2g42t"), this.first = n;
  }, m(t4, e2) {
    insert(t4, n, e2), mount_component(i, n, null), append(n, o), append(n, r);
    for (let t5 = 0; t5 < a.length; t5 += 1) a[t5] && a[t5].m(r, null);
    s = true;
  }, p(t4, n2) {
    e = t4;
    const o2 = {};
    1 & n2 && (o2.spellGroupLabel = i18n(e[7].label)), i.$set(o2), 3 & n2 && (l = ensure_array_like(e[7].active), group_outros(), a = update_keyed_each(a, n2, p, 1, e, l, c, r, outro_and_destroy_block, create_each_block_2, null, get_each_context_2), check_outros());
  }, i(t4) {
    if (!s) {
      transition_in(i.$$.fragment, t4);
      for (let t5 = 0; t5 < l.length; t5 += 1) transition_in(a[t5]);
      s = true;
    }
  }, o(t4) {
    transition_out(i.$$.fragment, t4);
    for (let t5 = 0; t5 < a.length; t5 += 1) transition_out(a[t5]);
    s = false;
  }, d(t4) {
    t4 && detach(n), destroy_component(i);
    for (let t5 = 0; t5 < a.length; t5 += 1) a[t5].d();
  } };
}
function create_each_block$1(t3, e) {
  let n, i, o, r, s, a, c, l = [], p = /* @__PURE__ */ new Map();
  i = new Pf2eSpellActionHeader({ props: { title: e[4].sheetData.name } }), r = new Pf2eSpellAbilityData({ props: { spellCategory: e[4].sheetData } });
  let u = ensure_array_like(e[4].sheetData.groups);
  const d = (t4) => t4[7].id;
  for (let t4 = 0; t4 < u.length; t4 += 1) {
    let n2 = get_each_context_1$1(e, u, t4), i2 = d(n2);
    p.set(i2, l[t4] = create_each_block_1$1(i2, n2));
  }
  return { key: t3, first: null, c() {
    n = element("section"), create_component(i.$$.fragment), o = space(), create_component(r.$$.fragment), s = space();
    for (let t4 = 0; t4 < l.length; t4 += 1) l[t4].c();
    a = space(), this.first = n;
  }, m(t4, e2) {
    insert(t4, n, e2), mount_component(i, n, null), append(n, o), mount_component(r, n, null), append(n, s);
    for (let t5 = 0; t5 < l.length; t5 += 1) l[t5] && l[t5].m(n, null);
    append(n, a), c = true;
  }, p(t4, o2) {
    e = t4;
    const s2 = {};
    1 & o2 && (s2.title = e[4].sheetData.name), i.$set(s2);
    const c2 = {};
    1 & o2 && (c2.spellCategory = e[4].sheetData), r.$set(c2), 3 & o2 && (u = ensure_array_like(e[4].sheetData.groups), group_outros(), l = update_keyed_each(l, o2, d, 1, e, u, p, n, outro_and_destroy_block, create_each_block_1$1, a, get_each_context_1$1), check_outros());
  }, i(t4) {
    if (!c) {
      transition_in(i.$$.fragment, t4), transition_in(r.$$.fragment, t4);
      for (let t5 = 0; t5 < u.length; t5 += 1) transition_in(l[t5]);
      c = true;
    }
  }, o(t4) {
    transition_out(i.$$.fragment, t4), transition_out(r.$$.fragment, t4);
    for (let t5 = 0; t5 < l.length; t5 += 1) transition_out(l[t5]);
    c = false;
  }, d(t4) {
    t4 && detach(n), destroy_component(i), destroy_component(r);
    for (let t5 = 0; t5 < l.length; t5 += 1) l[t5].d();
  } };
}
function create_fragment$3(t3) {
  let e, n, i = [], o = /* @__PURE__ */ new Map(), r = ensure_array_like(t3[0]);
  const s = (t4) => t4[6];
  for (let e2 = 0; e2 < r.length; e2 += 1) {
    let n2 = get_each_context$1(t3, r, e2), a = s(n2);
    o.set(a, i[e2] = create_each_block$1(a, n2));
  }
  return { c() {
    e = element("section");
    for (let t4 = 0; t4 < i.length; t4 += 1) i[t4].c();
  }, m(t4, o2) {
    insert(t4, e, o2);
    for (let t5 = 0; t5 < i.length; t5 += 1) i[t5] && i[t5].m(e, null);
    n = true;
  }, p(t4, [n2]) {
    3 & n2 && (r = ensure_array_like(t4[0]), group_outros(), i = update_keyed_each(i, n2, s, 1, t4, r, o, e, outro_and_destroy_block, create_each_block$1, null, get_each_context$1), check_outros());
  }, i(t4) {
    if (!n) {
      for (let t5 = 0; t5 < r.length; t5 += 1) transition_in(i[t5]);
      n = true;
    }
  }, o(t4) {
    for (let t5 = 0; t5 < i.length; t5 += 1) transition_out(i[t5]);
    n = false;
  }, d(t4) {
    t4 && detach(e);
    for (let t5 = 0; t5 < i.length; t5 += 1) i[t5].d();
  } };
}
function instance$3(t3, e, n) {
  var i = this && this.__awaiter || function(t4, e2, n2, i2) {
    return new (n2 || (n2 = Promise))(function(o2, r2) {
      function s(t5) {
        try {
          c(i2.next(t5));
        } catch (t6) {
          r2(t6);
        }
      }
      function a(t5) {
        try {
          c(i2.throw(t5));
        } catch (t6) {
          r2(t6);
        }
      }
      function c(t5) {
        var e3;
        t5.done ? o2(t5.value) : (e3 = t5.value, e3 instanceof n2 ? e3 : new n2(function(t6) {
          t6(e3);
        })).then(s, a);
      }
      c((i2 = i2.apply(t4, e2 || [])).next());
    });
  };
  let { spellCollectionAndSheetData: o } = e;
  function r(t4) {
    return i(this, void 0, void 0, function* () {
      t4.parentItem ? yield t4.parentItem.consume() : console.warn("Expected parent item to be consumed but spell has no parent item");
    });
  }
  return t3.$$set = (t4) => {
    "spellCollectionAndSheetData" in t4 && n(0, o = t4.spellCollectionAndSheetData);
  }, [o, r, (t4) => r(t4.spell)];
}
class Pf2eItemSpell extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$3, create_fragment$3, safe_not_equal, { spellCollectionAndSheetData: 0 });
  }
}
function getRankLabel(t3) {
  switch (t3) {
    case "0":
      return i18n("PF2E.Actor.Creature.Spellcasting.Cantrips");
    case "1":
      return i18nFormat("PF2E.Item.Spell.Rank.Ordinal", { rank: "1st" });
    case "2":
      return i18nFormat("PF2E.Item.Spell.Rank.Ordinal", { rank: "2nd" });
    case "3":
      return i18nFormat("PF2E.Item.Spell.Rank.Ordinal", { rank: "3rd" });
    case "4":
      return i18nFormat("PF2E.Item.Spell.Rank.Ordinal", { rank: "4th" });
    case "5":
      return i18nFormat("PF2E.Item.Spell.Rank.Ordinal", { rank: "5th" });
    case "6":
      return i18nFormat("PF2E.Item.Spell.Rank.Ordinal", { rank: "6th" });
    case "7":
      return i18nFormat("PF2E.Item.Spell.Rank.Ordinal", { rank: "7th" });
    case "8":
      return i18nFormat("PF2E.Item.Spell.Rank.Ordinal", { rank: "8th" });
    case "9":
      return i18nFormat("PF2E.Item.Spell.Rank.Ordinal", { rank: "9th" });
    case "10":
      return i18nFormat("PF2E.Item.Spell.Rank.Ordinal", { rank: "10th" });
    default:
      return t3;
  }
}
function get_each_context(t3, e, n) {
  const i = t3.slice();
  return i[11] = e[n][0], i[12] = e[n][1], i;
}
function get_each_context_1(t3, e, n) {
  const i = t3.slice();
  return i[15] = e[n], i[17] = n, i;
}
function create_if_block$2(t3) {
  let e, n, i, o, r, s, a;
  return { c() {
    e = element("div"), n = element("h2"), i = text(t3[0]), attr(n, "class", "svelte-mobile-companion-pf2e-v340n8-3tgfh6"), attr(e, "class", "error svelte-mobile-companion-pf2e-v340n8-3tgfh6");
  }, m(o2, c) {
    insert(o2, e, c), append(e, n), append(n, i), r = true, s || (a = listen(e, "click", t3[7]), s = true);
  }, p(t4, e2) {
    (!r || 1 & e2) && set_data(i, t4[0]);
  }, i(t4) {
    r || (t4 && add_render_callback(() => {
      r && (o || (o = create_bidirectional_transition(e, slide, { duration: 200, easing: identity, axis: "y" }, true)), o.run(1));
    }), r = true);
  }, o(t4) {
    t4 && (o || (o = create_bidirectional_transition(e, slide, { duration: 200, easing: identity, axis: "y" }, false)), o.run(0)), r = false;
  }, d(t4) {
    t4 && detach(e), t4 && o && o.end(), s = false, a();
  } };
}
function create_default_slot$1(t3) {
  let e, n, i, o, r;
  function s() {
    return t3[8](t3[15]);
  }
  return { c() {
    e = element("div"), n = element("button"), n.textContent = `${i18n("PF2E.AddSpellTitle")}`, i = space(), attr(n, "class", "add-spell svelte-mobile-companion-pf2e-v340n8-3tgfh6"), attr(e, "class", "button-container svelte-mobile-companion-pf2e-v340n8-3tgfh6");
  }, m(t4, a) {
    insert(t4, e, a), append(e, n), insert(t4, i, a), o || (r = listen(n, "click", s), o = true);
  }, p(e2, n2) {
    t3 = e2;
  }, d(t4) {
    t4 && (detach(e), detach(i)), o = false, r();
  } };
}
function create_each_block_1(t3, e) {
  let n, i, o;
  return i = new Pf2eSpell({ props: { spell: e[15], showUnpreparedButton: false, castRank: e[11], $$slots: { default: [create_default_slot$1] }, $$scope: { ctx: e } } }), { key: t3, first: null, c() {
    n = empty(), create_component(i.$$.fragment), this.first = n;
  }, m(t4, e2) {
    insert(t4, n, e2), mount_component(i, t4, e2), o = true;
  }, p(t4, n2) {
    e = t4;
    const o2 = {};
    2 & n2 && (o2.spell = e[15]), 2 & n2 && (o2.castRank = e[11]), 262146 & n2 && (o2.$$scope = { dirty: n2, ctx: e }), i.$set(o2);
  }, i(t4) {
    o || (transition_in(i.$$.fragment, t4), o = true);
  }, o(t4) {
    transition_out(i.$$.fragment, t4), o = false;
  }, d(t4) {
    t4 && detach(n), destroy_component(i, t4);
  } };
}
function create_each_block(t3) {
  let e, n, i, o, r, s, a = [], c = /* @__PURE__ */ new Map();
  n = new Pf2eSpellCategoryHeader({ props: { spellGroupLabel: getRankLabel(t3[11]) } });
  let l = ensure_array_like(t3[12]);
  const p = (t4) => t4[17];
  for (let e2 = 0; e2 < l.length; e2 += 1) {
    let n2 = get_each_context_1(t3, l, e2), i2 = p(n2);
    c.set(i2, a[e2] = create_each_block_1(i2, n2));
  }
  return { c() {
    e = element("section"), create_component(n.$$.fragment), i = space(), o = element("ol");
    for (let t4 = 0; t4 < a.length; t4 += 1) a[t4].c();
    r = space(), attr(o, "class", "svelte-mobile-companion-pf2e-v340n8-3tgfh6");
  }, m(t4, c2) {
    insert(t4, e, c2), mount_component(n, e, null), append(e, i), append(e, o);
    for (let t5 = 0; t5 < a.length; t5 += 1) a[t5] && a[t5].m(o, null);
    append(e, r), s = true;
  }, p(t4, e2) {
    const i2 = {};
    2 & e2 && (i2.spellGroupLabel = getRankLabel(t4[11])), n.$set(i2), 10 & e2 && (l = ensure_array_like(t4[12]), group_outros(), a = update_keyed_each(a, e2, p, 1, t4, l, c, o, outro_and_destroy_block, create_each_block_1, null, get_each_context_1), check_outros());
  }, i(t4) {
    if (!s) {
      transition_in(n.$$.fragment, t4);
      for (let t5 = 0; t5 < l.length; t5 += 1) transition_in(a[t5]);
      s = true;
    }
  }, o(t4) {
    transition_out(n.$$.fragment, t4);
    for (let t5 = 0; t5 < a.length; t5 += 1) transition_out(a[t5]);
    s = false;
  }, d(t4) {
    t4 && detach(e), destroy_component(n);
    for (let t5 = 0; t5 < a.length; t5 += 1) a[t5].d();
  } };
}
function create_fragment$2(t3) {
  let e, n, i, o, r, s, a, c, l, p, u, d = t3[0] && "" !== t3[0] && create_if_block$2(t3), m = ensure_array_like(t3[1]), h = [];
  for (let e2 = 0; e2 < m.length; e2 += 1) h[e2] = create_each_block(get_each_context(t3, m, e2));
  const f = (t4) => transition_out(h[t4], 1, 1, () => {
    h[t4] = null;
  });
  return { c() {
    e = element("section"), d && d.c(), n = space(), i = element("header"), i.innerHTML = '<h1 class="svelte-mobile-companion-pf2e-v340n8-3tgfh6">Arcane Prepared Spells</h1>', o = space(), r = element("section");
    for (let t4 = 0; t4 < h.length; t4 += 1) h[t4].c();
    s = space(), a = element("button"), a.textContent = `${i18n("PF2E.Item.Rules.Close")}`, attr(i, "class", "sheet-header svelte-mobile-companion-pf2e-v340n8-3tgfh6"), attr(r, "class", "sheet-content svelte-mobile-companion-pf2e-v340n8-3tgfh6"), attr(e, "class", "spell-preparation svelte-mobile-companion-pf2e-v340n8-3tgfh6");
  }, m(c2, m2) {
    insert(c2, e, m2), d && d.m(e, null), append(e, n), append(e, i), append(e, o), append(e, r);
    for (let t4 = 0; t4 < h.length; t4 += 1) h[t4] && h[t4].m(r, null);
    append(e, s), append(e, a), l = true, p || (u = [listen(a, "click", t3[2]), listen(e, "click", stopPropagation)], p = true);
  }, p(t4, [i2]) {
    if (t4[0] && "" !== t4[0] ? d ? (d.p(t4, i2), 1 & i2 && transition_in(d, 1)) : (d = create_if_block$2(t4), d.c(), transition_in(d, 1), d.m(e, n)) : d && (group_outros(), transition_out(d, 1, 1, () => {
      d = null;
    }), check_outros()), 10 & i2) {
      let e2;
      for (m = ensure_array_like(t4[1]), e2 = 0; e2 < m.length; e2 += 1) {
        const n2 = get_each_context(t4, m, e2);
        h[e2] ? (h[e2].p(n2, i2), transition_in(h[e2], 1)) : (h[e2] = create_each_block(n2), h[e2].c(), transition_in(h[e2], 1), h[e2].m(r, null));
      }
      for (group_outros(), e2 = m.length; e2 < h.length; e2 += 1) f(e2);
      check_outros();
    }
  }, i(t4) {
    if (!l) {
      transition_in(d);
      for (let t5 = 0; t5 < m.length; t5 += 1) transition_in(h[t5]);
      t4 && add_render_callback(() => {
        l && (c || (c = create_bidirectional_transition(e, slide, { duration: 200, easing: identity, axis: "x" }, true)), c.run(1));
      }), l = true;
    }
  }, o(t4) {
    transition_out(d), h = h.filter(Boolean);
    for (let t5 = 0; t5 < h.length; t5 += 1) transition_out(h[t5]);
    t4 && (c || (c = create_bidirectional_transition(e, slide, { duration: 200, easing: identity, axis: "x" }, false)), c.run(0)), l = false;
  }, d(t4) {
    t4 && detach(e), d && d.d(), destroy_each(h, t4), t4 && c && c.end(), p = false, run_all(u);
  } };
}
function stopPropagation(t3) {
  t3.stopPropagation();
}
function instance$2(t3, e, n) {
  var i = this && this.__awaiter || function(t4, e2, n2, i2) {
    return new (n2 || (n2 = Promise))(function(o2, r2) {
      function s2(t5) {
        try {
          c2(i2.next(t5));
        } catch (t6) {
          r2(t6);
        }
      }
      function a2(t5) {
        try {
          c2(i2.throw(t5));
        } catch (t6) {
          r2(t6);
        }
      }
      function c2(t5) {
        var e3;
        t5.done ? o2(t5.value) : (e3 = t5.value, e3 instanceof n2 ? e3 : new n2(function(t6) {
          t6(e3);
        })).then(s2, a2);
      }
      c2((i2 = i2.apply(t4, e2 || [])).next());
    });
  };
  let o, r, { collectionAndSheet: s } = e, { clickedGroupId: a } = e, { clickedSlot: c } = e;
  function l() {
    spellPrepViewStore.set(null);
  }
  function p(t4) {
    return i(this, void 0, void 0, function* () {
      const e2 = s.spellCollection, i2 = yield e2.addSpell(t4, a);
      let r2;
      i2 && (r2 = yield e2.prepareSpell(i2, a, c)), r2 ? l() : (n(0, o = "Can't squeeze this spell into that slot"), setTimeout(() => {
        n(0, o = "");
      }, 4e3));
    });
  }
  return t3.$$set = (t4) => {
    "collectionAndSheet" in t4 && n(4, s = t4.collectionAndSheet), "clickedGroupId" in t4 && n(5, a = t4.clickedGroupId), "clickedSlot" in t4 && n(6, c = t4.clickedSlot);
  }, t3.$$.update = () => {
    if (16 & t3.$$.dirty) {
      const t4 = s.spellCollection.spells.contents;
      t4.sort((t5, e3) => t5.name.localeCompare(e3.name));
      const e2 = t4.reduce((t5, e3) => {
        const n2 = e3.isCantrip ? "0" : e3.rank;
        return t5[n2] || (t5[n2] = []), t5[n2].push(e3), t5;
      }, {});
      n(1, r = Object.entries(e2));
    }
  }, [o, r, l, p, s, a, c, () => n(0, o = ""), (t4) => p(t4)];
}
class Pf2eSpellPreparation extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$2, create_fragment$2, safe_not_equal, { collectionAndSheet: 4, clickedGroupId: 5, clickedSlot: 6 });
  }
}
function create_else_block(t3) {
  let e, n, i, o;
  e = new Pf2eSpellsHeader({ props: { activeTab: t3[0] } }), e.$on("categoryChange", t3[3]);
  let r = t3[1] && create_if_block_1$1(t3);
  return { c() {
    create_component(e.$$.fragment), n = space(), i = element("section"), r && r.c(), attr(i, "class", "content-scroll-list");
  }, m(t4, s) {
    mount_component(e, t4, s), insert(t4, n, s), insert(t4, i, s), r && r.m(i, null), o = true;
  }, p(t4, n2) {
    const o2 = {};
    1 & n2 && (o2.activeTab = t4[0]), e.$set(o2), t4[1] ? r ? (r.p(t4, n2), 2 & n2 && transition_in(r, 1)) : (r = create_if_block_1$1(t4), r.c(), transition_in(r, 1), r.m(i, null)) : r && (group_outros(), transition_out(r, 1, 1, () => {
      r = null;
    }), check_outros());
  }, i(t4) {
    o || (transition_in(e.$$.fragment, t4), transition_in(r), o = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), transition_out(r), o = false;
  }, d(t4) {
    t4 && (detach(n), detach(i)), destroy_component(e, t4), r && r.d();
  } };
}
function create_if_block$1(t3) {
  let e, n;
  return e = new Pf2eSpellPreparation({ props: { collectionAndSheet: t3[2].collectionAndSheet, clickedGroupId: t3[2].clickedGroupId, clickedSlot: t3[2].clickedSlot } }), e.$on("close-modal", close_modal_handler), { c() {
    create_component(e.$$.fragment);
  }, m(t4, i) {
    mount_component(e, t4, i), n = true;
  }, p(t4, n2) {
    const i = {};
    4 & n2 && (i.collectionAndSheet = t4[2].collectionAndSheet), 4 & n2 && (i.clickedGroupId = t4[2].clickedGroupId), 4 & n2 && (i.clickedSlot = t4[2].clickedSlot), e.$set(i);
  }, i(t4) {
    n || (transition_in(e.$$.fragment, t4), n = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), n = false;
  }, d(t4) {
    destroy_component(e, t4);
  } };
}
function create_if_block_1$1(t3) {
  let e, n, i = t3[0], o = create_key_block(t3);
  return { c() {
    o.c(), e = empty();
  }, m(t4, i2) {
    o.m(t4, i2), insert(t4, e, i2), n = true;
  }, p(t4, n2) {
    1 & n2 && safe_not_equal(i, i = t4[0]) ? (group_outros(), transition_out(o, 1, 1, noop), check_outros(), o = create_key_block(t4), o.c(), transition_in(o, 1), o.m(e.parentNode, e)) : o.p(t4, n2);
  }, i(t4) {
    n || (transition_in(o), n = true);
  }, o(t4) {
    transition_out(o), n = false;
  }, d(t4) {
    t4 && detach(e), o.d(t4);
  } };
}
function create_if_block_4(t3) {
  let e, n;
  return e = new Pf2eItemSpell({ props: { spellCollectionAndSheetData: t3[1].items } }), { c() {
    create_component(e.$$.fragment);
  }, m(t4, i) {
    mount_component(e, t4, i), n = true;
  }, p(t4, n2) {
    const i = {};
    2 & n2 && (i.spellCollectionAndSheetData = t4[1].items), e.$set(i);
  }, i(t4) {
    n || (transition_in(e.$$.fragment, t4), n = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), n = false;
  }, d(t4) {
    destroy_component(e, t4);
  } };
}
function create_if_block_3(t3) {
  let e, n;
  return e = new Pf2eRituals({ props: { spellCollectionAndSheetData: t3[1].ritual } }), { c() {
    create_component(e.$$.fragment);
  }, m(t4, i) {
    mount_component(e, t4, i), n = true;
  }, p(t4, n2) {
    const i = {};
    2 & n2 && (i.spellCollectionAndSheetData = t4[1].ritual), e.$set(i);
  }, i(t4) {
    n || (transition_in(e.$$.fragment, t4), n = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), n = false;
  }, d(t4) {
    destroy_component(e, t4);
  } };
}
function create_if_block_2(t3) {
  let e, n, i, o, r, s, a, c;
  return e = new Pf2eKnownSpells({ props: { spellCollectionAndSheetData: t3[1].prepared } }), i = new Pf2eKnownSpells({ props: { spellCollectionAndSheetData: t3[1].focus } }), r = new Pf2eKnownSpells({ props: { spellCollectionAndSheetData: t3[1].innate } }), a = new Pf2eKnownSpells({ props: { spellCollectionAndSheetData: t3[1].spontaneous } }), { c() {
    create_component(e.$$.fragment), n = space(), create_component(i.$$.fragment), o = space(), create_component(r.$$.fragment), s = space(), create_component(a.$$.fragment);
  }, m(t4, l) {
    mount_component(e, t4, l), insert(t4, n, l), mount_component(i, t4, l), insert(t4, o, l), mount_component(r, t4, l), insert(t4, s, l), mount_component(a, t4, l), c = true;
  }, p(t4, n2) {
    const o2 = {};
    2 & n2 && (o2.spellCollectionAndSheetData = t4[1].prepared), e.$set(o2);
    const s2 = {};
    2 & n2 && (s2.spellCollectionAndSheetData = t4[1].focus), i.$set(s2);
    const c2 = {};
    2 & n2 && (c2.spellCollectionAndSheetData = t4[1].innate), r.$set(c2);
    const l = {};
    2 & n2 && (l.spellCollectionAndSheetData = t4[1].spontaneous), a.$set(l);
  }, i(t4) {
    c || (transition_in(e.$$.fragment, t4), transition_in(i.$$.fragment, t4), transition_in(r.$$.fragment, t4), transition_in(a.$$.fragment, t4), c = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), transition_out(i.$$.fragment, t4), transition_out(r.$$.fragment, t4), transition_out(a.$$.fragment, t4), c = false;
  }, d(t4) {
    t4 && (detach(n), detach(o), detach(s)), destroy_component(e, t4), destroy_component(i, t4), destroy_component(r, t4), destroy_component(a, t4);
  } };
}
function create_key_block(t3) {
  let e, n, i, o;
  const r = [create_if_block_2, create_if_block_3, create_if_block_4], s = [];
  function a(t4, e2) {
    return t4[0] === SpellcastingTabType.KNOWN ? 0 : t4[0] === SpellcastingTabType.RITUAL ? 1 : t4[0] === SpellcastingTabType.ACTIVATION ? 2 : -1;
  }
  return ~(e = a(t3)) && (n = s[e] = r[e](t3)), { c() {
    n && n.c(), i = empty();
  }, m(t4, n2) {
    ~e && s[e].m(t4, n2), insert(t4, i, n2), o = true;
  }, p(t4, o2) {
    let c = e;
    e = a(t4), e === c ? ~e && s[e].p(t4, o2) : (n && (group_outros(), transition_out(s[c], 1, 1, () => {
      s[c] = null;
    }), check_outros()), ~e ? (n = s[e], n ? n.p(t4, o2) : (n = s[e] = r[e](t4), n.c()), transition_in(n, 1), n.m(i.parentNode, i)) : n = null);
  }, i(t4) {
    o || (transition_in(n), o = true);
  }, o(t4) {
    transition_out(n), o = false;
  }, d(t4) {
    t4 && detach(i), ~e && s[e].d(t4);
  } };
}
function create_fragment$1(t3) {
  let e, n, i, o;
  const r = [create_if_block$1, create_else_block], s = [];
  function a(t4, e2) {
    return t4[2] ? 0 : 1;
  }
  return n = a(t3), i = s[n] = r[n](t3), { c() {
    e = element("section"), i.c(), attr(e, "class", "category-content");
  }, m(t4, i2) {
    insert(t4, e, i2), s[n].m(e, null), o = true;
  }, p(t4, [o2]) {
    let c = n;
    n = a(t4), n === c ? s[n].p(t4, o2) : (group_outros(), transition_out(s[c], 1, 1, () => {
      s[c] = null;
    }), check_outros(), i = s[n], i ? i.p(t4, o2) : (i = s[n] = r[n](t4), i.c()), transition_in(i, 1), i.m(e, null));
  }, i(t4) {
    o || (transition_in(i), o = true);
  }, o(t4) {
    transition_out(i), o = false;
  }, d(t4) {
    t4 && detach(e), s[n].d();
  } };
}
const close_modal_handler = () => {
};
function instance$1(t3, e, n) {
  var i = this && this.__awaiter || function(t4, e2, n2, i2) {
    return new (n2 || (n2 = Promise))(function(o2, r2) {
      function s2(t5) {
        try {
          c2(i2.next(t5));
        } catch (t6) {
          r2(t6);
        }
      }
      function a2(t5) {
        try {
          c2(i2.throw(t5));
        } catch (t6) {
          r2(t6);
        }
      }
      function c2(t5) {
        var e3;
        t5.done ? o2(t5.value) : (e3 = t5.value, e3 instanceof n2 ? e3 : new n2(function(t6) {
          t6(e3);
        })).then(s2, a2);
      }
      c2((i2 = i2.apply(t4, e2 || [])).next());
    });
  };
  let o, r, { actor: s } = e, a = SpellcastingTabType.KNOWN;
  const c = spellPrepViewStore.subscribe((t4) => {
    n(2, r = t4);
  });
  return onDestroy(() => {
    c();
  }), t3.$$set = (t4) => {
    "actor" in t4 && n(4, s = t4.actor);
  }, t3.$$.update = () => {
    16 & t3.$$.dirty && function(t4) {
      i(this, void 0, void 0, function* () {
        var e2, i2;
        let r2 = { prepared: [], focus: [], ritual: [], items: [], spontaneous: [], innate: [] };
        if (null === (e2 = t4.spellcasting) || void 0 === e2 ? void 0 : e2.collections) for (const e3 of t4.spellcasting.collections) {
          const t5 = yield e3.entry.getSheetData({ spells: e3 }), n2 = { spellCollection: e3, sheetData: t5 };
          null === (i2 = r2[t5.category]) || void 0 === i2 || i2.push(n2);
        }
        n(1, o = r2);
      });
    }(s);
  }, [a, o, r, function(t4) {
    n(0, a = t4.detail);
  }, s];
}
class Pf2eSpells extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance$1, create_fragment$1, safe_not_equal, { actor: 4 });
  }
}
function create_if_block_1(t3) {
  let e, n;
  return e = new Pf2eSpells({ props: { actor: t3[1] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t4, i) {
    mount_component(e, t4, i), n = true;
  }, p(t4, n2) {
    const i = {};
    2 & n2 && (i.actor = t4[1]), e.$set(i);
  }, i(t4) {
    n || (transition_in(e.$$.fragment, t4), n = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), n = false;
  }, d(t4) {
    destroy_component(e, t4);
  } };
}
function create_if_block(t3) {
  let e, n;
  return e = new Pf2eInventory({ props: { actor: t3[1] } }), { c() {
    create_component(e.$$.fragment);
  }, m(t4, i) {
    mount_component(e, t4, i), n = true;
  }, p(t4, n2) {
    const i = {};
    2 & n2 && (i.actor = t4[1]), e.$set(i);
  }, i(t4) {
    n || (transition_in(e.$$.fragment, t4), n = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), n = false;
  }, d(t4) {
    destroy_component(e, t4);
  } };
}
function create_default_slot(t3) {
  let e, n, i, o, r, s;
  n = new Header({ props: { customButtons: headerButtons, menuButtons, activeFilter: t3[2] } });
  const a = [create_if_block, create_if_block_1], c = [];
  function l(t4, e2) {
    return t4[2] === Filters.Object ? 0 : t4[2] === Filters.Spell ? 1 : -1;
  }
  return ~(o = l(t3)) && (r = c[o] = a[o](t3)), { c() {
    e = element("main"), create_component(n.$$.fragment), i = space(), r && r.c(), attr(e, "class", "pd-8 pf2e-container svelte-mobile-companion-pf2e-v340n8-1maswyz");
  }, m(t4, r2) {
    insert(t4, e, r2), mount_component(n, e, null), append(e, i), ~o && c[o].m(e, null), s = true;
  }, p(t4, i2) {
    const s2 = {};
    4 & i2 && (s2.activeFilter = t4[2]), n.$set(s2);
    let p = o;
    o = l(t4), o === p ? ~o && c[o].p(t4, i2) : (r && (group_outros(), transition_out(c[p], 1, 1, () => {
      c[p] = null;
    }), check_outros()), ~o ? (r = c[o], r ? r.p(t4, i2) : (r = c[o] = a[o](t4), r.c()), transition_in(r, 1), r.m(e, null)) : r = null);
  }, i(t4) {
    s || (transition_in(n.$$.fragment, t4), transition_in(r), s = true);
  }, o(t4) {
    transition_out(n.$$.fragment, t4), transition_out(r), s = false;
  }, d(t4) {
    t4 && detach(e), destroy_component(n), ~o && c[o].d();
  } };
}
function create_fragment(t3) {
  let e, n, i;
  function o(e2) {
    t3[4](e2);
  }
  let r = { $$slots: { default: [create_default_slot] }, $$scope: { ctx: t3 } };
  return void 0 !== t3[0] && (r.elementRoot = t3[0]), e = new ApplicationShell({ props: r }), binding_callbacks.push(() => bind(e, "elementRoot", o)), { c() {
    create_component(e.$$.fragment);
  }, m(t4, n2) {
    mount_component(e, t4, n2), i = true;
  }, p(t4, [i2]) {
    const o2 = {};
    134 & i2 && (o2.$$scope = { dirty: i2, ctx: t4 }), !n && 1 & i2 && (n = true, o2.elementRoot = t4[0], add_flush_callback(() => n = false)), e.$set(o2);
  }, i(t4) {
    i || (transition_in(e.$$.fragment, t4), i = true);
  }, o(t4) {
    transition_out(e.$$.fragment, t4), i = false;
  }, d(t4) {
    destroy_component(e, t4);
  } };
}
function instance(t3, e, n) {
  let { elementRoot: i } = e, { props: o } = e;
  setContext(foundryContextId, getFullModuleId()), init(o);
  let r = o, s = Filters.Object;
  const a = actorStore.subscribe((t4) => {
    n(1, r = t4);
  }), c = activeFilterStore.subscribe((t4) => {
    n(2, s = t4);
  });
  return onMount(handleOnMount), onDestroy(() => {
    a(), c(), handleOnDestroy();
  }), t3.$$set = (t4) => {
    "elementRoot" in t4 && n(0, i = t4.elementRoot), "props" in t4 && n(3, o = t4.props);
  }, [i, r, s, o, function(t4) {
    i = t4, n(0, i);
  }];
}
let Pf2eAppShell$1 = class extends SvelteComponent {
  constructor(t3) {
    super(), init$1(this, t3, instance, create_fragment, safe_not_equal, { elementRoot: 0, props: 3 });
  }
  get elementRoot() {
    return this.$$.ctx[0];
  }
  set elementRoot(t3) {
    this.$$set({ elementRoot: t3 }), flush();
  }
  get props() {
    return this.$$.ctx[3];
  }
  set props(t3) {
    this.$$set({ props: t3 }), flush();
  }
};
class Pf2eAppShell extends SvelteApp {
  constructor(t3) {
    super(), this.options.svelte.props = t3;
  }
  static get defaultOptions() {
    return foundry.utils.mergeObject(super.defaultOptions, { title: "Mobile Companion Pf2e", id: getBaseModuleId(), width: window.innerWidth, height: window.innerHeight, zIndex: 99999, resizable: false, svelte: { class: Pf2eAppShell$1, target: document.body, props: {} } });
  }
}
function loadSheet() {
  try {
    activateSheet((t3) => new Pf2eAppShell({ props: t3 }));
  } catch (t3) {
    console.error(t3), new ErrorShell(t3.message).render(true);
  }
}
Hooks.once("init", async () => {
}), Hooks.once("setup", async () => {
  setSubModuleId("pf2e"), mobileCompanionGameSettings.init(), isMobileCompanion() && await setupPerformanceSettings();
}), Hooks.once("ready", () => {
  onReady(() => {
    loadSheet();
  });
}), Hooks.on("renderItemSheet", (t3) => {
  onRenderItemSheet(t3);
});
