import { MODULE_ID } from "./main.js";

export function registerSettings() {
    const settings = {
        "zoomLevel": {
            scope: "client",
            config: false,
            type: Number,
            default: 1,
        },
    };

    registerSettingsArray(settings);
}

export function getSetting(key) {
    return game.settings.get(MODULE_ID, key);
}

export async function setSetting(key, value) {
    return await game.settings.set(MODULE_ID, key, value);
}

function registerSettingsArray(settings) {
    for(const [key, value] of Object.entries(settings)) {
        game.settings.register(MODULE_ID, key, value);
    }
}