# LANCER: PPG Structure Rules
Implementations of One Stress for All and @_valkyrion's Structuring houserules, intended for use with the Prototype Pattern Groups LCP

### One Stress for All
This rule is from @Stormtalus's house rules discussed on Pilot Net. Replace the rules for Overheating and Reactor Stress with the following:

    "All characters with a HEAT CAP – PC or NPC – only have 1 STRESS and cannot gain more. When a character would take Heat that would put them over their HEAT CAP, they become EXPOSED and OVERHEATED. Any Heat they take beyond their HEAT CAP is instead taken as energy damage that cannot be reduced."

This change removes the potential for a reactor meltdown, but unifies the rules for multi-Stress and single-Stress characters in a way that prevents outright heatgunning from killing a PC or NPC. Mechs generally have twice as much HP than their Heat Cap, and safety from "overheating damage" is a single Stabilize away, so this ensures that inflicting Heat is more of a control effect (through Overheated and encouraging Stabilize) than just a second health bar for both PCs and NPCs.

### Low Variance Structure
Replace the rules for Structure Damage with the following:

    "When a character takes structure damage, instead of making a structure damage check, the affected character chooses to either be DAZED until the end of their next turn, or to suffer the System Trauma effect from the STRUCTURE DAMAGE TABLE (Lancer, p. 80)."

Structure damage in Lancer is a strange mechanic that feels more at home among Old-School Revival-style Wound Tables than a modern tactical RPG. Most of the time, it's not the NPCs that are killing PCs, but the Structure Damage table! On the NPCs' side, if they don't die outright to a Direct Hit, System Trauma may instead ruin their entire gameplan as the Artillery's singular gun breaks. All that said, I have a soft spot in my heart for System Trauma and the aesthetic of mech parts getting blown off. So, I offer a compromise: Remove all chances of instant death, and instead offer a choice between long term loss of action quality (System Trauma) or short term loss of action quantity (Dazed). This lets players feel badass as they power through the loss of a system anyway, and allows NPCs to keep essential pieces of their kit while still suffering a penalty for losing Structure. Bonus points: No complicated nested table results to worry about!
