import { MODULE_ID } from "./main.js";

export function registerSettings() {
    const settings = {
        "theme": {
            name: `${MODULE_ID}.settings.theme.name`,
            hint: `${MODULE_ID}.settings.theme.hint`,
            scope: "world",
            config: true,
            type: String,
            choices: {
                "default": `${MODULE_ID}.settings.theme.choices.default`,
                "dark-fantasy": `${MODULE_ID}.settings.theme.choices.dark-fantasy`,
                "sci-fi": `${MODULE_ID}.settings.theme.choices.sci-fi`,
                "retro": `${MODULE_ID}.settings.theme.choices.retro`,
                "modern": `${MODULE_ID}.settings.theme.choices.modern`,
            },
            default: "dark-fantasy",
        },
        "addTitle": {
            name: `${MODULE_ID}.settings.addTitle.name`,
            hint: `${MODULE_ID}.settings.addTitle.hint`,
            scope: "world",
            config: true,
            type: Boolean,
            default: true,
        },
        "autoTooltips": {
            name: `${MODULE_ID}.settings.autoTooltips.name`,
            hint: `${MODULE_ID}.settings.autoTooltips.hint`,
            scope: "world",
            config: true,
            type: Boolean,
            default: true,
            requiresReload: true,
        },
        "useImageBackground": {
            name: `${MODULE_ID}.settings.useImageBackground.name`,
            hint: `${MODULE_ID}.settings.useImageBackground.hint`,
            scope: "world",
            config: true,
            type: Boolean,
            default: true,
        },
    };

    registerSettingsArray(settings);
}

export function getSetting(key) {
    return game.settings.get(MODULE_ID, key);
}

export async function setSetting(key, value) {
    return await game.settings.set(MODULE_ID, key, value);
}

function registerSettingsArray(settings) {
    for(const [key, value] of Object.entries(settings)) {
        game.settings.register(MODULE_ID, key, value);
    }
}