export const MODULE_ID = "ripper-premium-dice";

Hooks.on("init", () => {
    registerDice();
});

function registerDice() {
    Hooks.once("diceSoNiceReady", async (dice3d) => {
        for (const def of TEXTURE_DEFINITIONS) {
            await dice3d.addTexture(def.id, { name: def.name, source: def.source, composite: "source-over" });
        }

        COLORSETS.forEach((colorset) => dice3d.addColorset(colorset, "default"));

        const standardSystem = dice3d.getLoadedDiceSystems().get("standard");

        standardSystem.registerBeforeShaderCompileCallback((shader, material, diceType, appearance) => {
            const texId = material.userData?.materialData?.texture?.name;
            if (!texId) return;
            const isSpecialDice = SPECIAL_DICE.some((d) => texId == d.id);
            if (!isSpecialDice) return;
            shader.fragmentShader = shader.fragmentShader.replace("#include <map_fragment>", SHADERS[SPECIAL_DICE.find((d) => texId == d.id).shader].fragment);
            const colorBG = new PIXI.Color(material.userData?.materialData?.background || "#ffffff");
            const rgbBG = [colorBG.red, colorBG.green, colorBG.blue];
            shader.uniforms.time = game.dice3d.uniforms.time;
            shader.uniforms.uColor = { value: rgbBG };
            shader.fragmentShader = `uniform float time;\nuniform vec3 uColor;\n` + shader.fragmentShader;

            if (SPECIAL_DICE.find((d) => texId == d.id).shader.includes("WORLD")) {
                shader.fragmentShader = `varying vec3 sWorldPos;\n` + shader.fragmentShader;
                shader.uniforms.sWorldPos = { value: [0, 0, 0] };
                shader.vertexShader = `varying vec3 sWorldPos;\n` + shader.vertexShader;
                shader.vertexShader = shader.vertexShader.replace(
                    "#include <begin_vertex>",
                    `
                    #include <begin_vertex>
                    sWorldPos = (modelMatrix * vec4( position , 1.0 )).xyz;
                    `,
                );
            }
        });
    });
}

const SHADERS = {
    PATTERN_WAVE: {
        fragment: `
        #include <map_fragment>
        vec2 uv = vMapUv * 10.0;
        float time_speed = time * 0.2;
        diffuseColor.rgb *= uColor;

        vec4 v1 = vec4(.1,.4,.222,0) + time_speed + atan(uv.y, uv.x);
        vec4 v2 = vec4(v1.x, v1.y, v1.z, v1.w) + vec4(0.0,1.0,2.0,3.0);


        v1 = cos( sin(uv.x)-cos(uv.y) + v1 ),
        v2 = sin( v1*uv.x*uv.y - uv.y + v2 );
    
        v1 =  abs(v2*v2-v1*v1);
    
        vec4 final = 1.6 * pow(1.0 -v1+v1*v1,  16.0+v1-v1);
        float intensity = (final.r + final.g + final.b) / 3.0;
        intensity = pow(0.5 + 0.5 * intensity, 2.0);
        diffuseColor.rgb *= intensity;
        `,
    },
    PATTERN_WAVE_DARK: {
        fragment: `
        #include <map_fragment>
        vec2 uv = vMapUv * 10.0;
        float time_speed = time * 0.2;

        vec4 v1 = vec4(.1,.4,.222,0) + time_speed + atan(uv.y, uv.x);
        vec4 v2 = vec4(v1.x, v1.y, v1.z, v1.w) + vec4(0.0,1.0,2.0,3.0);


        v1 = cos( sin(uv.x)-cos(uv.y) + v1 ),
        v2 = sin( v1*uv.x*uv.y - uv.y + v2 );
    
        v1 =  abs(v2*v2-v1*v1);
    
        vec4 final = 1.6 * pow(1.0 -v1+v1*v1,  16.0+v1-v1);
        float intensity = (final.r + final.g + final.b) / 3.0;
        intensity = pow(0.5 + 0.5 * intensity, 2.0);
        float totalDiffuseColor = (diffuseColor.r + diffuseColor.g + diffuseColor.b) / 3.0;
        if(totalDiffuseColor < 0.1){
            diffuseColor.rgb += uColor * clamp(pow(intensity, 5.0), 0.0, 1.0);
        }
        `,
    },
};

const SPECIAL_DICE = [
    {
        id: "ripper-premium-dice-waves",
        shader: "PATTERN_WAVE",
    },
    {
        id: "ripper-premium-dice-darkwaves",
        shader: "PATTERN_WAVE_DARK",
    },
];

const COLORSETS = [];

const TEXTURE_DEFINITIONS = [
    {
        id: "ripper-premium-dice-waves",
        name: "Waves (The Ripper Premium Dice)",
        source: `modules/${MODULE_ID}/assets/blank.jpg`,
    },
    {
        id: "ripper-premium-dice-darkwaves",
        name: "Waves Dark (The Ripper Premium Dice)",
        source: `modules/${MODULE_ID}/assets/black.jpg`,
    },
];
