import {initConfig} from "./config.js";
import {registerSettings} from "./settings.js";
import {Tidbits} from "./tidbits.js";

export const MODULE_ID = "tidbits";

Hooks.on("init", async () => {
    registerSettings();
    initConfig();
});

Hooks.on("ready", () => {
    ui.tidbits = new Tidbits();
    ui.tidbits.loadSources();
});

Hooks.on("pauseGame", (paused) => {
    if (paused) {
        setTimeout(() => {
            ui.tidbits.setPausedText();
        }, 1);
    }
})