const n={ID:"token-action-hud-core",NAME:"Token Action HUD"},A=`modules/${n.ID}/templates`,k={action:`${A}/action.hbs`,customStyleForm:`${A}/custom-style-form.hbs`,group:`${A}/group.hbs`,hud:`${A}/hud.hbs`,listSubgroup:`${A}/list-subgroup.hbs`,settings:`${A}/settings.hbs`,tabSubgroup:`${A}/tab-subgroup.hbs`,tagifyAppHud:`${A}/tag-dialog-hud.hbs`,tagifyAppGroup:`${A}/tag-dialog-group.hbs`,tagifyAppSubgroup:`${A}/tag-dialog-subgroup.hbs`},C="|",O={compendiumEntry:"tokenActionHud.compendiumEntry",compendiumMacro:"tokenActionHud.compendiumMacro",compendiumPlaylist:"tokenActionHud.compendiumPlaylist",macro:"tokenActionHud.macro"},L=["JournalEntry","Macro","RollTable"],U={foundryVTT:{class:"tah-style-foundry-vtt-dark",file:"tah-foundry-vtt-dark",moduleId:n.ID,name:"Foundry VTT Dark",primaryColor:"#dddddd",secondaryColor:"#dddddd80",tertiaryColor:"#ff6400"},compact:{class:"tah-style-foundry-vtt-dark-compact",file:"tah-foundry-vtt-dark-compact",moduleId:n.ID,name:"Foundry VTT Dark Compact",primaryColor:"#dddddd",secondaryColor:"#dddddd80",tertiaryColor:"#ff6400"},dockedLeft:{class:"tah-style-docked-left",file:"tah-docked-left",moduleId:n.ID,name:"Foundry VTT Dark Docked Left",primaryColor:"#dddddd",secondaryColor:"#dddddd80",tertiaryColor:"#ff6400",isDocked:!0,dockPosition:"left"},dockedCenterRight:{class:"tah-style-docked-right",file:"tah-docked-right",moduleId:n.ID,name:"Foundry VTT Dark Docked Center-Right",primaryColor:"#dddddd",secondaryColor:"#dddddd80",tertiaryColor:"#ff6400",collapseIcon:"fa-caret-right",expandIcon:"fa-caret-left",isDocked:!0,dockPosition:"center-right"},dockedRight:{class:"tah-style-docked-right",file:"tah-docked-right",moduleId:n.ID,name:"Foundry VTT Dark Docked Right",primaryColor:"#dddddd",secondaryColor:"#dddddd80",tertiaryColor:"#ff6400",collapseIcon:"fa-caret-right",expandIcon:"fa-caret-left",isDocked:!0,dockPosition:"right"},foundryVttLight:{class:"tah-style-foundry-vtt-light",file:"tah-foundry-vtt-light",moduleId:n.ID,name:"Foundry VTT Light",primaryColor:"#dddddd",secondaryColor:"#dddddd80",tertiaryColor:"#ff6400"},pathfinder:{class:"tah-style-pathfinder",file:"tah-pathfinder",moduleId:n.ID,name:"Pathfinder"},highContrast:{class:"tah-style-high-contrast",file:"tah-high-contrast",moduleId:n.ID,name:"High Contrast",primaryColor:"#ffff00",secondaryColor:"#ffff00",tertiaryColor:"#0C7BDC"},custom:{class:"tah-style-custom",file:"tah-custom",moduleId:n.ID,name:"Custom"}},_={backgroundColor:{cssProperty:"--tah-background-color",type:String,default:"#00000000"},buttonHeight:{cssProperty:"--tah-button-height-editable",type:Number,default:32},buttonBackgroundColor:{cssProperty:"--tah-button-background-color-editable",type:String,default:"#000000b3"},buttonBorderPrimaryColor:{cssProperty:"--tah-button-border-primary-color-editable",type:String,default:"#0C0C0CFF"},buttonBorderSecondaryColor:{cssProperty:"--tah-button-border-secondary-color-editable",type:String,default:"#060606FF"},buttonTextColor:{cssProperty:"--tah-button-text-color-editable",type:String,default:"#DDDDDDFF"},buttonHoverBorderPrimaryColor:{cssProperty:"--tah-button-hover-border-primary-color-editable",type:String,default:"#FF6400FF"},buttonHoverBorderSecondaryColor:{cssProperty:"--tah-button-hover-border-secondary-color-editable",type:String,default:"#FF0000FF"},buttonHoverBackgroundColor:{cssProperty:"--tah-button-hover-background-color-editable",type:String,default:"#000000B3"},buttonHoverTextColor:{cssProperty:"--tah-button-hover-text-color-editable",type:String,default:"#FFFFFFFF"},buttonToggleActiveBackgroundColor:{cssProperty:"--tah-button-toggle-active-background-color-editable",type:String,default:"#3C0078BF"},buttonToggleActiveBorderPrimaryColor:{cssProperty:"--tah-button-toggle-active-border-primary-color-editable",type:String,default:"#9B8DFFFF"},buttonToggleActiveBorderSecondaryColor:{cssProperty:"--tah-button-toggle-active-border-secondary-color-editable",type:String,default:"#9B8DFFFF"},buttonToggleActiveTextColor:{cssProperty:"--tah-button-toggle-active-text-color-editable",type:String,default:"#FFFFFFFF"},buttonToggleHoverBackgroundColor:{cssProperty:"--tah-button-toggle-hover-background-color-editable",type:String,default:"#3C0078BF"},buttonToggleHoverBorderPrimaryColor:{cssProperty:"--tah-button-toggle-hover-border-primary-color-editable",type:String,default:"#9B8DFFFF"},buttonToggleHoverBorderSecondaryColor:{cssProperty:"--tah-button-toggle-hover-secondary-color-editable",type:String,default:"#9B8DFFFF"},buttonToggleHoverTextColor:{cssProperty:"--tah-button-toggle-hover-text-color-editable",type:String,default:"#FFFFFFFF"},textPrimaryColor:{cssProperty:"--tah-text-primary-color-editable",type:String,default:"#DDDDDDFF"},textSecondaryColor:{cssProperty:"--tah-text-secondary-color-editable",type:String,default:"#DDDDDD80"},textTertiaryColor:{cssProperty:"--tah-text-tertiary-color-editable",type:String,default:"#FF6400FF"},textHoverPrimaryColor:{cssProperty:"--tah-text-hover-primary-color-editable",type:String,default:"#DDDDDDFF"},textHoverSecondaryColor:{cssProperty:"--tah-text-hover-secondary-color-editable",type:String,default:"#DDDDDD80"},textHoverTertiaryColor:{cssProperty:"--tah-text-tertiary-color-editable",type:String,default:"#FF6400FF"}},j={COMPENDIUM:"compendium",CUSTOM:"custom",SYSTEM:"system",SYSTEM_DERIVED:"system-derived"},Y={DEFAULT_HEIGHT:200,DEFAULT_WIDTH:20,DEFAULT_LEFT_POS:150,DEFAULT_TOP_POS:80,DEFAULT_SCALE:1,DEFAULT_ZINDEX:100},Q={ICON:"fas fa-sd-card",TOOLTIP:"Item Macro"},Z={customLayout:{hint:"tokenActionHud.settings.customLayout.hint",name:"tokenActionHud.settings.customLayout.name",inputType:"filePicker",filePickerType:"json",dtype:"String",scope:"world"},userCustomLayout:{hint:"tokenActionHud.settings.userCustomLayout.hint",name:"tokenActionHud.settings.userCustomLayout.name",inputType:"filePicker",filePickerType:"json",dtype:"String",scope:"user"},exportLayout:{hint:"tokenActionHud.settings.exportLayout.hint",label:"tokenActionHud.settings.exportLayout.label",name:"tokenActionHud.settings.exportLayout.name",inputType:"button",icon:"fa-solid fa-file-export",action:"exportLayout"},resetLayout:{hint:"tokenActionHud.settings.resetLayout.hint",label:"tokenActionHud.settings.resetLayout.label",name:"tokenActionHud.settings.resetLayout.name",inputType:"button",icon:"fa-solid fa-arrow-rotate-left",action:"resetLayout",scope:"client"},resetAllLayouts:{hint:"tokenActionHud.settings.resetAllLayouts.hint",label:"tokenActionHud.settings.resetAllLayouts.label",name:"tokenActionHud.settings.resetAllLayouts.name",inputType:"button",icon:"fa-solid fa-bomb",action:"resetAllLayouts",scope:"world"}},tt={activeCssAsText:{classes:["TokenActionHud"],cache:!0},allow:{classes:["TokenActionHud"],cache:!0},alwaysShowHud:{classes:["TokenActionHud"],cache:!0},backgroundColor:{},buttonBackgroundColor:{},buttonBorderPrimaryColor:{},buttonBorderSecondaryColor:{},buttonHeight:{},buttonHoverBorderPrimaryColor:{},buttonHoverBorderSecondaryColor:{},buttonHoverBackgroundColor:{},buttonHoverTextColor:{},buttonTextColor:{},buttonToggleActiveBackgroundColor:{},buttonToggleActiveBorderPrimaryColor:{},buttonToggleActiveBorderSecondaryColor:{},buttonToggleActiveTextColor:{},buttonToggleHoverBackgroundColor:{},buttonToggleHoverBorderPrimaryColor:{},buttonToggleHoverBorderSecondaryColor:{},buttonToggleHoverTextColor:{},clickOpenCategory:{classes:["TokenActionHud"],cache:!0},customLayout:{classes:["ActionHandler"],cache:!0},customStyle:{},debug:{classes:["TokenActionHud"],cache:!0},direction:{classes:["TokenActionHud"],cache:!0},displayCharacterName:{classes:["TokenActionHud"],cache:!0},displayIcons:{classes:["TokenActionHud"],cache:!0},drag:{classes:["TokenActionHud"],cache:!0},enable:{classes:["TokenActionHud"],cache:!0},enableCustomization:{classes:["ActionHandler","TokenActionHud"],cache:!0},grid:{classes:["TokenActionHud"],cache:!0},itemMacro:{},migrationVersion:{},reset:{},renderItemOnRightClick:{},rollHandler:{default:"core"},scale:{classes:["TokenActionHud"],cache:!0},sortActions:{classes:["ActionHandler"],cache:!0},startup:{},style:{classes:["TokenActionHud"],cache:!0},tooltips:{classes:["ActionHandler"],cache:!0},textPrimaryColor:{},textSecondaryColor:{},textTertiaryColor:{},textHoverPrimaryColor:{},textHoverSecondaryColor:{},textHoverTertiaryColor:{},userCustomLayout:{classes:["ActionHandler"],cache:!0}};let et=class Logger{static info(n,A=!1){A?ui.notifications.info(`Token Action HUD | ${n}`):console.log(`Token Action HUD Info | ${n}`)}static error(n,A=!1){A?ui.notifications.error(`Token Action HUD | ${n}`,{permanent:!0}):console.error(`Token Action HUD Error | ${n}`)}static debug(n,A=null){const k=game.tokenActionHud?.setting?.debug??Utils.getSetting("debug");if(k){if(!A)return void console.log(`Token Action HUD Debug | ${n}`);const k=Utils.deepClone(A);console.log(`Token Action HUD Debug | ${n}`,k)}}};class Timer{constructor(n){this.milliseconds=n,this.timer=null}async start(){return this.timer&&this.abort(),new Promise((n=>{this.timer=setTimeout((()=>{n()}),this.milliseconds??100)}))}async abort(){clearTimeout(this.timer),this.timer=null}}class Utils{static checkAllow(n,A){return n>=A}static capitalize(n){return n.replace(/\w\S*/g,(n=>n.charAt(0).toUpperCase()+n.substring(1).toLowerCase()))}static deepClone(n,A){return foundry.utils.deepClone(n,A)}static getActor(n,A){let k=null;return A&&(k=canvas.tokens.placeables.find((n=>n.id===A))),k?k.actor:game.actors.get(n)}static getClosestGroupElement(n){return n?n.target.closest('[data-part="subgroup"]')||n.target.closest('[data-part="group"]'):null}static getControlledActors(){const n=game.canvas.tokens?.controlled??[];return n.map((n=>n.actor))}static getStatusEffect(n,A){return n.effects.find((n=>n.statuses.every((n=>n===A))))}static getImage(n,A=[]){A.push("icons/svg/mystery-man.svg");let k="";return game.tokenActionHud?.setting?.displayIcons&&(k="string"==typeof n?n:n?.img??n?.icon??""),A.includes(k)?"":k}static getItem(n,A){return n.items.get(A)}static getToken(n){return canvas.tokens.placeables.find((A=>A.id===n))}static getControlledTokens(){return game.canvas.tokens?.controlled??[]}static getFirstControlledToken(){const n=game.canvas.tokens.controlled[0];if(n)return n;const A=game.user?.character;return A?canvas.tokens.placeables.find((n=>n.actor?.id===A.id)):null}static getSetting(A,k=null){let C=k??null;try{C=game.settings.get(n.ID,A)}catch{et.debug(`Setting '${A}' not found`)}return C}static async setSetting(A,k){game.settings.settings.get(`${n.ID}.${A}`)?(await game.settings.set(n.ID,A,k),et.debug(`Setting '${A}' set to '${k}'`)):"debug"!==A&&et.debug(`Setting '${A}' not found`)}static getActorFlag(A){return game.tokenActionHud.actor.getFlag(n.ID,A)}static async setActorFlag(A,k){await game.tokenActionHud.actor.setFlag(n.ID,A,k)}static async unsetActorFlag(A){await game.tokenActionHud.actor.unsetFlag(n.ID,A)}static getUserFlag(A){return game.user.getFlag(n.ID,A)}static async setUserFlag(A,k){await game.user.setFlag(n.ID,A,k)}static async unsetUserFlag(A){await game.user.unsetFlag(n.ID,A)}static i18n(n){return game.i18n.localize(n)}static isGmActive(){return game.users.some((n=>n.isGM&&n.active))}static isModuleActive(n){const A=game.modules.get(n);return A&&A.active}static getModuleTitle(n){return game.modules.get(n)?.title??""}static getModuleVersion(n){return game.modules.get(n)?.version??""}static humanizeBinding(A){const k=foundry?.helpers?.interaction?.KeyboardManager??KeyboardManager,C=game.keybindings.get(n.ID,A);if(!C)return"";const O=C[0].modifiers.reduce(((n,A)=>(k.MODIFIER_CODES[A]?.includes(C[0].key)||n.unshift(k.getKeycodeDisplayString(A)),n)),[k.getKeycodeDisplayString(C[0].key)]);return O.join(" + ")}static median(n){const A=Math.floor(n.length/2),k=[...n].sort(((n,A)=>n-A));return n.length%2!=0?k[A]:(k[A-1]+k[A])/2}static getUpperQuartileAverage(n){const A=n.slice().sort(((n,A)=>n-A)),k=A.length,C=Math.ceil(.75*k),O=k-1;let L=0,U=0;for(let n=C;n<=O;n++)L+=A[n],U++;const _=L/U;return _}static getModifier(n){if(!n&&0!==n)return"";const A=n>=0?"+":"";return`${A}${n}`}static sortItems(n){return new Map([...n.entries()].sort(((n,A)=>n[1].sort.localeCompare(A[1].sort))))}static sortItemsByName(n){return new Map([...n.entries()].sort(((n,A)=>n[1].name.localeCompare(A[1].name))))}static switchCSS(n){const A=document.querySelector("#token-action-hud-app");if(A){const k=foundry.utils.isNewerVersion(game.version,"12.999")&&["dockedLeft","dockedCenterRight","dockedRight"].includes(n)?`${U[n].class}-v13`:U[n].class;if(A.classList.contains(k))return;const C=[...A.classList].filter((n=>"tah-expanded"!==n));C.length&&A.classList.remove(C),A.classList.add(k)}}static registerHandlebars(){Handlebars.registerHelper("tokenActionHudCoreCap",(function(n){return!n||n.length<1?"":n[0].toUpperCase()+n.slice(1)}));const reduceOp=function(n,A){n=Array.from(n),n.pop();const k=n.shift();return n.reduce(A,k)};Handlebars.registerHelper({tokenActionHudCoreTrue:function(){return reduceOp(arguments,(n=>n))}}),Handlebars.registerHelper("tokenActionHudCoreActiveText",(function(n){return game.tokenActionHud?.setting?.activeCssAsText?n.fn(this):n.inverse(this)}))}static getModuleVersionParts(n){if(!n)return et.debug("Module version not retrieved",{trigger:"getModuleVersionParts"}),null;const A=n.split(".");return{major:A[0],minor:A[1],patch:A[2]}}static isSystemModuleCompatible(A){if(!A)return!0;const k=this.getModuleVersionParts(A),C=this.getModuleVersionParts(game.modules.get(n.ID).version);if(C.major!==k.major||C.minor!==k.minor||k.patch&&C.patch!==k.patch){const A=`${k.major}.${k.minor}.${k.patch??"X"}`,C=game.modules.get(n.ID).version;return ui.notifications.error(`The installed Token Action HUD system module requires Token Action HUD Core module version ${A}, but version ${C} is installed. Install Token Action HUD Core module version ${A} to continue using Token Action HUD. Earlier versions of Token Action HUD Core are available on the module's package page on the Foundry VTT site.`,{permanent:!0}),!1}return!0}static getNestedGroups(n,A={}){let k=0;if(!n)return null;const C=A?.id,O=A?.type;n=Array.isArray(n)?n:Object.values(n);const L={};for(const U of n){if(!(C&&U.id!==C||O&&U.type!==O)){k++;const n=U.nestId.split("_").length;L[U.nestId]={...U,order:k,level:n}}if(U.groups?.length>0){const n=this.getNestedGroups(U.groups,A);n&&Object.assign(L,n)}}return Object.keys(L).length>0?L:null}static async getGroupByNestId(n,A={}){const k="string"==typeof A?A:A?.nestId,C=A?.type;if(!k)return null;const O=k.split("_");return await findGroup(n,O);async function findGroup(n,A){if(!n)return null;n=Array.isArray(n)?n:Object.values(n);for(const k of n)if(k.id===A[0]){if(1===A.length)return k.type&&C&&k.type!==C?void 0:k;if(A.shift(),!k.groups)continue;for(const n of Object.values(k.groups)){if(0===n.length)continue;const k=await findGroup(n,A);if(k)return k}}}}static async deleteGroupByNestId(n,A={}){const k="string"==typeof A?A:A?.nestId;if(!k)return;const C=k.split("_");await findAndDeleteGroup(n,C)}static async findAndDeleteGroup(n,A){n=Array.isArray(n)?n:Object.values(n);for(const[k,C]of n.entries())if(C.id===A[0]){if(1===A.length)return void n.splice(k,1);if(0===C.groups.length)return;A.shift();const O=await findAndDeleteGroup(C.groups,A);if(O)return}}static async deleteGroupsById(n,A={}){const k="string"==typeof A?A:A?.id;if(k)for(let C=n.length-1;C>=0;C--)n[C].id===k?n.splice(C,1):n[C].groups?.length>0&&deleteGroupsById(n[C].groups,A)}}const it=foundry?.applications?.apps?.FilePicker?.implementation??FilePicker;class DataHandler{constructor(n){this.socket=n}async init(){await this.#t(),await Promise.all([this.private=await this.isPrivate(),this.fileMap=await this.getFilePathsAsGm()])}get isPersistentStorage(){return foundry.utils.isNewerVersion(game.version,"11.305")&&"undefined"==typeof ForgeVTT}async#t(){if(!game.user.isGM||!Utils.getSetting("enableCustomization"))return;const A="data",k=this.isPersistentStorage?`modules/${n.ID}/storage`:n.ID,C=[k,`${k}/${game.world.id}`,`${k}/${game.world.id}/actor`,`${k}/${game.world.id}/user`];for(const n of C)await it.browse(A,n).catch((async k=>{await it.createDirectory(A,n,{})||et.debug(`Failed to create directory: ${n}`)}))}get path(){return this.isPersistentStorage?`modules/${n.ID}/storage/${game.world.id}/`:`${n.ID}/${game.world.id}/`}getFileParts(n){const A=n.split("/"),k=A.pop(),C=A.join("/"),O=k.split(".")[0];return{folder:C,filename:k,id:O}}async isPrivate(){if(game.user.isGM)return!1;if(game.user.hasPermission("FILES_BROWSE"))try{return await it.browse("data",this.path),!1}catch{return!0}return!0}async getFilePathsAsGm(){if((!game.user.hasPermission("FILES_BROWSE")||this.private)&&!Utils.isGmActive())return et.info("Cannot get file paths without a GM present",!1),new Map;const n=game.user.hasPermission("FILES_BROWSE")&&!this.private?await this.getFilePaths():await this.socket.executeAsGM("getFilePaths");return new Map(n.map((n=>{const{id:A}=this.getFileParts(n);return[A,n]})))}static async getFilePathsWithSocket(){return await(game.tokenActionHud?.dataHandler?.getFilePaths())??[]}async getFilePaths(){const[n,A]=await Promise.all([it.browse("data",`${this.path}actor/`),it.browse("data",`${this.path}user/`)]);return[...n?.files??[],...A?.files??[]]}get canSaveData(){return game.user.hasPermission("FILES_UPLOAD")&&!this.private||Utils.isGmActive()}async saveDataAsGm(n,A,k){game.user.hasPermission("FILES_UPLOAD")&&!this.private&&await this.saveData(n,A,k),Utils.isGmActive()?await this.socket.executeAsGM("saveData",n,A,k):et.info("Cannot save data without a GM present",!1)}static async saveDataWithSocket(n,A,k){return await game.tokenActionHud.dataHandler.saveData(n,A,k)}async saveData(n,A,k){try{const C=`${this.path}${n}`,O=encodeURI(`${A}.json`),L=new File([JSON.stringify(k,null,"")],O,{type:"application/json"}),U=await it.upload("data",C,L,{},{notify:!1});U.path?this.fileMap.has(A)||this.fileMap.set(A,U.path):et.debug(`Failed to save data to: ${O}\nReason: ${U.error||"Unknown error"}`)}catch(n){et.error(`An error occurred while saving data for ${A}.json: ${n.message}`)}}get canGetData(){return game.user.hasPermission("FILES_BROWSE")&&!this.private||Utils.isGmActive()}async getDataAsGm(n){try{if((!game.user.hasPermission("FILES_BROWSE")||this.private)&&!Utils.isGmActive())return void et.info("Cannot get data without a GM present",!1);const A=game.user.hasPermission("FILES_BROWSE")?await this.getData(n):await this.socket.executeAsGM("getData",n);return A}catch(n){return et.error(`An error occurred while getting data: ${n.message}`),null}}static async getDataWithSocket(n){return await game.tokenActionHud.dataHandler.getData(n)}async getData(n){const{id:A,file:k}=n;let C=this.fileMap.get(A)??null;if(!C){if(!k)return null;const{folder:n,filename:A}=this.getFileParts(k),O=await it.browse("data",n);if(C=O.files.find((n=>n.endsWith(A))),!C)return null}try{const n=Date.now(),A=await fetch(`${C}?ms=${n}`);if(A.ok){const n=await A.json();return n}return null}catch(n){return console.error(n),null}}async getDataMigrate(A,k){const C=`${n.ID}/${game.world.id}/${A}`,O=encodeURI(`${k}.json`);try{const n=await it.browse("data",C),A=n.files.find((n=>n.endsWith(O)));if(A){const n=Date.now();return await fetch(`${A}?ms=${n}`).then((n=>n.ok?n.json():null)).catch((n=>{console.error(n)}))}return null}catch{return null}}}class MigrationManager{constructor(n,A){this.dataHandler=n,this.socket=A}async init(){if(!game.user.isGM)return;const A=game.modules.get(n.ID).version,k=Utils.getSetting("migrationVersion");if(A===k)return;let C=!0;C=!(!k||foundry.utils.isNewerVersion("1.4.10",k))||await this.#e(),C=!(this.dataHandler.isPersistentStorage&&(!k||foundry.utils.isNewerVersion("1.4.11",k)))||await this.#i(),C&&Utils.setSetting("migrationVersion",A)}async#e(){try{const A=game.users.filter((A=>A.getFlag(n.ID,"categories")));for(const k of A)k.unsetFlag(n.ID,"categories"),k.unsetFlag(n.ID,"defaults");const k=game.actors.filter((A=>A.getFlag(n.ID,"categories")));for(const A of k)A.unsetFlag(n.ID,"categories");const C=game.canvas.tokens.objects.children.filter((A=>A.actor?.getFlag(n.ID,"categories")));for(const A of C)A.actor?.unsetFlag(n.ID,"categories");for(const A of game.scenes){const k=A.tokens.filter((A=>A.actor?.getFlag(n.ID,"categories")));for(const A of k)A.actor?.unsetFlag(n.ID,"categories")}return!0}catch(n){return et.debug(n.message,n),!1}}async#i(){try{et.info("Migrating files to persistent storage...",!0);for(const n of game.users){const A=await this.dataHandler.getDataMigrate("user",n.id);A&&await this.dataHandler.saveData("user",n.id,A)}for(const n of game.actors){const A=await this.dataHandler.getDataMigrate("actor",n.id);A&&await this.dataHandler.saveData("actor",n.id,A)}return et.info("Successfully migrated files to persistent storage",!0),!0}catch{return et.info("Failed to migrate files to persistent storage",!0),!1}}}class CharacterHandler{constructor(n){this.hudManager=n,this.groupHandler=n.groupHandler,this.actionHandler=n.actionHandler,this.rollHandler=n.rollHandler}init(){this.previousActorId=this.actor?.id,this.setCharacter()}get isCharacter(){return this.actor||this.isMultipleTokens}get isMultipleTokens(){const n=Utils.getControlledTokens();return n.length>1&&!this.actor}get isSameActor(){return this.previousActorId!==this.actor?.id}setCharacter(){this.resetCharacter();const n=Utils.getControlledTokens();n.length>1?this.#s(n):this.#n(n)}resetCharacter(){this.token=null,this.actor=null,this.tokens=[],this.actors=[]}#s(n){this.characterName=game.i18n.localize("tokenActionHud.multiple"),this.token=null,this.actor=null,this.tokens=n,this.actors=Utils.getControlledActors()}#n(n){const A={token:null,actor:null};1===n.length&&this.#o(n[0])?(A.token=n[0],A.actor=A.token?.actor):0===n.length&&game.user.character&&Utils.getSetting("alwaysShowHud")&&(A.actor=game.user.character,A.token=canvas.tokens?.placeables.find((n=>n.actor?.id===A.actor.id))??null),A.actor&&(this.characterName=A.token?.name??A.actor.name,this.token=A.token,this.actor=A.actor,this.tokens=[A.token],this.actors=[A.actor])}#o(n={}){return game.user.isGM||n.actor?.testUserPermission(game.user,"OWNER")}}class LayoutHandler{constructor(n,A){this.systemManager=n,this.dataHandler=A,this.defaultLayout=null,this.customLayout=null}async init(){await Promise.all([this.#a(),this.#r()])}softReset(){this.defaultLayout=null}hardReset(){this.softReset(),this.customLayout=null}async#a(){if(this.defaultLayout)return;const n=this.systemManager.defaults?.layout;this.defaultLayout=n?await Utils.getNestedGroups(n):null}async#r(){if(this.customLayout)return;const n=Utils.getUserFlag("userCustomLayout")||Utils.getSetting("customLayout")||null;this.customLayout=n?await this.dataHandler.getDataAsGm({file:n}):null}async exportLayout(){const n=await this.dataHandler.getDataAsGm({type:"user",id:game.userId})??this.customLayout??this.defaultLayout;n&&saveDataToFile(JSON.stringify(n,null,2),"text/json","token-action-hud-layout.json")}get layout(){return this.customLayout??this.defaultLayout}}function getTooltip(n,A){const k=game.tokenActionHud?.setting?.tooltips??Utils.getSetting("tooltips");if("none"===k)return null;if("nameOnly"===k||!n)return A;"object"!=typeof n&&(n={content:n}),n.content.includes("tah-tooltip-wrapper")||(n.content=`<div class="tah-tooltip-wrapper">${n.content}</div>`);let C="RIGHT";if(n.direction)C=n.direction;else{const n=game.tokenActionHud.systemManager.styles[game.tokenActionHud.setting.style];["center-right","right"].includes(n.dockPosition)&&(C="LEFT")}return n.direction=C,n}class GroupHandler{constructor(n,A,k,C){this.hudManager=n,this.systemManager=A,this.dataHandler=k,this.layoutHandler=C,this.defaultGroups={},this.groups={},this.actorGroups={},this.userGroups={}}get actor(){return this.hudManager?.actor}get actors(){return this.hudManager?.actors}get token(){return this.hudManager?.token}get tokens(){return this.hudManager?.tokens}async init(){this.#l(),await Promise.all([this.#c(),this.#d()])}softReset(){this.defaultGroups={},this.groups=null,this.groups={}}hardReset(){this.softReset(),this.actorGroups={},this.userGroups={}}#l(){const n=this.systemManager.defaults?.groups;if(n)for(const A of n)this.defaultGroups[A.id]=A}async#c(){if(!this.actor)return;if(!Utils.getSetting("enableCustomization"))return void(this.actorGroups={});if(this.isSameActor&&Object.entries(this.actorGroups).length)return;if(!this.dataHandler.canGetData)return void(this.actorGroups={});et.debug("Retrieving groups from actor...",{actor:this.actor}),this.actorGroups={};const n=await this.dataHandler.getDataAsGm({type:"actor",id:this.actor.id})??null;if(n){for(const A of Object.entries(n))A[1].nestId=A[0];this.actorGroups=n,et.debug("Groups from actor retrieved",{actorGroups:this.actorGroups,actor:this.actor})}}async#d(){const n=game.user,A=this.layoutHandler.layout,getUserGroups=n=>{const k=Object.keys(n).length?n:A;for(const n of Object.entries(k))n[1].nestId=n[0];return k};if(!Utils.getSetting("enableCustomization"))return void(this.userGroups=getUserGroups(A));if(Object.entries(this.userGroups).length)return;if(!this.dataHandler.canGetData)return void(this.userGroups=getUserGroups(A));et.debug("Retrieving groups from user...",{user:n}),this.userGroups={};const k=await this.dataHandler.getDataAsGm({type:"user",id:n.id})??{};this.userGroups=getUserGroups(k),et.debug("Groups retrieved from user",{userGroups:this.userGroups,user:n})}async prepareGroups(n){if(Object.keys(this.userGroups).length){const A=this.getUserGroups();for(const k of A)if(1===k.level){const A=this.createGroup(k);n.groups.push(A),this.groups[A.nestId]=A}else{const A=k.nestId.split("_",k.level-1).join("_"),C=await Utils.getGroupByNestId(n.groups,{nestId:A});if(C){const n=this.createGroup(k);"tab"===n.settings.style?C.groups.tabs.push(n):C.groups.lists.push(n),this.groups[n.nestId]=n}}}if(Object.keys(this.actorGroups).length){const A=this.getActorGroups();for(const k of A){const A=k.nestId.split("_",k.level-1).join("_"),C=await Utils.getGroupByNestId(n.groups,{nestId:k.nestId});if(C)k.actions?.length&&(C.actions=k.actions);else{const C=await Utils.getGroupByNestId(n.groups,{nestId:A});if(C&&"system-derived"===k.type){C.groups||(C.groups={lists:[],tabs:[]});const n=this.createGroup(k,!0);k.actions?.length&&(n.actions=k.actions),"tab"===n.settings.style?C.groups.tabs.push(n):C.groups.lists.push(n),this.groups[n.nestId]=n}}}}return this.groups}getGroup({nestId:n,id:A,level:k,type:C}={}){return n?this.groups[n]:Object.values(this.groups).find((n=>!(A&&n.id!==A||k&&n.level!==k||C&&n.type!==C)))}getGroups({nestId:n,id:A,level:k,type:C,selected:O}={}){return Object.values(this.groups).filter((L=>(!n||L.nestId.startsWith(n))&&(!A||L.id===A)&&(!k||L.level===k)&&(!C||L.type===C)&&(!O||L.selected===O)))}getActorGroups({nestId:n,id:A,level:k,type:C}={}){return Object.values(this.actorGroups).filter((O=>(!n||O.nestId.startsWith(n))&&(!A||O.id===A)&&(!k||O.level===k)&&(!C||O.type===C))).sort(((n,A)=>n.level-A.level||n.order-A.order))}getUserGroups({nestId:n,id:A,level:k,type:C}={}){return Object.values(this.userGroups).filter((O=>(!n||O.nestId.startsWith(n))&&(!A||O.id===A)&&(!k||O.level===k)&&(!C||O.type===C))).sort(((n,A)=>n.level-A.level||n.order-A.order))}getGroupIds(){return Object.values(this.groups).map((n=>n.id))}getGroupSettings(n={}){return this.getGroup(n)?.settings??null}createGroup(n,A=!1){const k=Utils.deepClone(n),C=n.nestId.split("_"),O=C.length??1,L=getTooltip(n?.tooltip,k?.name);A||(k.actions=[],k.groups={lists:[],tabs:[]});const U={showTitle:!0,style:1===O?"tab":"list"},_=k.settings||{};_.showTitle??=U.showTitle,_.style??=U.style,k.subtitleClass=_.showTitle?"":"tah-hidden";const Y=k.system||{},Q={actions:k.actions,class:k.class||k.cssClass||"",groups:k.groups,id:k.id,info1:k.info1||"",info2:k.info2||"",info3:k.info3||"",level:k.level||O||1,listName:k.listName||k.name,name:k.name,nestId:k.nestId||k.id,order:k.order,selected:k.selected??k.isSelected??k.defaultSelected??!0,settings:_,system:Y,tooltip:L,type:k.type||j.CUSTOM};return O>1&&(Q.subtitleClass=k.subtitleClass||""),Q}updateGroups(n,A){Array.isArray(n)||(n=[n]);const k=(A?.level??0)+1,C={level:k};A?.nestId&&(C.nestId=A.nestId);const O=this.getGroups(C);for(const A of O)"system-derived"===A.type?(A.selected=!1,A.order=999):n.find((n=>n.id===A.id))||delete this.groups[A.nestId];let L=0;for(const k of n){k.nestId=A?.nestId?`${A.nestId}_${k.id}`:k.id,k.selected=k.selected??!0,k.order=L;const n=this.getGroup(k);if(n)Object.assign(n,k);else{const n=this.createGroup(k);this.groups[k.nestId]=n}L++}if(A?.settings){const n=this.getGroup(A);n&&(n.settings=A.settings)}}saveGroupSettings(n){const A=this.getGroup(n);A.settings={...A.settings,...n.settings},this.saveGroups({saveActor:!0,saveUser:!0})}async saveGroups(n={saveActor:!1,saveUser:!1}){Utils.getSetting("enableCustomization")&&(et.debug("Saving groups..."),n?.saveActor&&await this.saveActorGroups(),n?.saveUser&&await this.saveUserGroups(),et.debug("Groups saved",{groups:this.groups}))}async saveActorGroups(){if(!this.actor||!Object.keys(this.groups).length)return;et.debug("Saving actor groups...");const n={};this.actorGroups={};for(const A of Object.values(this.groups))this.actorGroups[A.nestId]=A,n[A.nestId]=this.#u(A,!0);this.dataHandler.canSaveData?(await this.dataHandler.saveDataAsGm("actor",this.actor.id,n),et.debug("Actor groups saved",{actorGroups:n})):et.debug("Actor groups not saved as no GM present")}async saveUserGroups(){if(!Object.keys(this.groups).length)return;et.debug("Saving user groups...");const n={};this.userGroups={};for(const A of Object.values(this.groups))"system-derived"!==A.type&&(this.userGroups[A.nestId]=A,n[A.nestId]=this.#u(A,!1));this.dataHandler.canSaveData?(await this.dataHandler.saveDataAsGm("user",game.userId,n),et.debug("User groups saved",{userGroups:n})):et.debug("User groups not saved as no GM present")}#u({id:n,name:A,listName:k,level:C,order:O,selected:L,settings:U,type:_,actions:j},Y=!1){const Q={id:n,name:A,listName:k,level:C,order:O,selected:L,settings:U,type:_};return Y&&(Q.actions=j.map((({id:n,isPreset:A,userSelected:k})=>({id:n,isPreset:A,userSelected:k})))),Q}getSelectedGroupsAsTags(n={}){n.selected=!0,n.level=(n.level||0)+1;const A=this.getGroups(n);return A?.map((n=>this.#g(n)))??[]}async getAvailableGroupAsTags(n){const A=await this.#h(n),k=await this.#p(),C=await this.#m(),O=await this.#f();return[...A,...k,...C,...O]}#h({nestId:n}){const A=this.getGroups({nestId:n,type:j.SYSTEM_DERIVED});return A?.map((n=>this.#g(n)))??[]}#p(){return Object.values(this.defaultGroups).map((n=>this.#g(n)))}#m(){const n=game.packs.filter((n=>L.includes(n.documentName)&&(foundry.utils.isNewerVersion(game.version,"10")?n.visible:!n.private||game.user.isGM))),A=n.map((n=>({id:n.metadata.id.replace(".","-"),listName:`${game.i18n.localize("tokenActionHud.group")}: ${n.metadata.label}`,name:n.metadata.label,type:"core"})));return A.map((n=>this.#g(n)))}#f(){return[this.#g({id:"macros",listName:`${game.i18n.localize("tokenActionHud.group")}: ${game.i18n.localize("tokenActionHud.macros")}`,name:game.i18n.localize("tokenActionHud.macros"),type:"core"})]}addGroup(n,A,k=!1){if(n.type=n?.type??"system-derived",n.style=n?.style??"list",!A?.id&&!A?.nestId)return;const C=this.getGroups(A);if(C?.length)for(const A of C){const C=`${A.nestId}_${n.id}`,O=this.getGroups({...n,nestId:C});if(O.length)if(k)for(const A of O)n.info&&(Object.assign(n,{...n.info}),delete n.info),Object.assign(A,this.createGroup({...A,...n},!0));else for(const A of O){const k=getTooltip(n.tooltip,A.name);Object.assign(A,{tooltip:k})}else{const k=this.createGroup({...n,nestId:C});A.groups||(A.groups={lists:[],tabs:[]}),"tab"===k.settings.style?A.groups.tabs.push(k):A.groups.lists.push(k),this.groups[k.nestId]=k}}}updateGroup(n,A=null){n.type=n?.type??"system-derived";const updateExistingGroups=A=>{for(const k of A)n.info&&(Object.assign(n,{...n.info}),delete n.info),Object.assign(k,this.createGroup({...k,...n},!0))};if(A){const k=this.getGroups(A);for(const A of k){const k=`${A.nestId}_${n.id}`,C=this.getGroups({...n,nestId:k});updateExistingGroups(C)}}else{const A=this.getGroups(n);updateExistingGroups(A)}}removeGroup(n){!n?.nestId&&n?.id&&Utils.deleteGroupsById(this.hud.groups,n.id);const A=this.getGroups(n);if(A?.length)for(const k of A)delete this.groups[k.nestId],n?.nestId&&Utils.deleteGroupByNestId(this.hud.groups,k.nestId)}addGroupInfo(n){const A=n?.id,k=n?.info;if(!A||!k)return;const C=this.getGroups(n);C.forEach((n=>{n.info1=k.info1,n.info2=k.info2,n.info3=k.info3}))}setHasActions(){Object.values(this.groups).forEach((n=>{n.actions.some((n=>n.selected))?n.hasActions=!0:n.hasActions=!1}))}#g(n){const{id:A,name:k,type:C,listName:O}=n;return{id:A,name:k,type:C,value:O??k}}}class HudManager{constructor(n,A,k,C){this.tokenActionHud=n,this.dataHandler=k,this.socket=C,this.layoutHandler=new LayoutHandler(A,k),this.groupHandler=new GroupHandler(this,A,k,this.layoutHandler),this.actionHandler=A.getActionHandlerCore(this,this.dataHandler,this.groupHandler),this.rollHandler=A.getRollHandlerCore(this),this.characterHandler=new CharacterHandler(this)}async init(n){if(this.characterHandler.init(),!this.characterHandler.isCharacter||!this.isHudEnabled)return!1;const A="controlToken"===n&&this.characterHandler.isSameActor?{saveActor:!0}:{};return await this.#y(A),!0}softResetHud(){this.hud=null,this.hud=[],this.groupHandler.softReset(),this.layoutHandler.softReset(),this.actionHandler.softReset()}hardResetHud(){this.softResetHud(),this.groupHandler.hardReset(),this.layoutHandler.hardReset()}async#y(n){et.debug("Building HUD...",{actor:this.actor,token:this.token}),this.previousActor?.id===this.actor?.id?this.isSameActor=!0:(this.previousActor=this.actor,this.isSameActor=!1),this.softResetHud(),await this.layoutHandler.init(),await this.groupHandler.init(),this.dataHandler.canGetData||this.isGmInactiveUserNotified||(et.info("Cannot retrieve HUD layout without GM present",!0),this.isGmInactiveUserNotified=!0),this.hud=await this.#v(),await this.actionHandler.buildActionsCore(),this.groupHandler.setHasActions(),await this.groupHandler.saveGroups(n),et.debug("HUD built",{hud:this.hud,actor:this.actor,token:this.token})}async#v(){et.debug("Preparing HUD...",{actor:this.actor,token:this.token});const n=Utils.getSetting("displayCharacterName")?this.characterHandler.characterName??game.i18n.localize("tokenActionHud.multiple"):"",A=this.actor?.id??"multi",k=this.token?.id??"multi",C={name:n,tokenId:k,actorId:A,groups:[]},O=await this.groupHandler.prepareGroups(C);return this.actionHandler.prepareActions(O),et.debug("HUD prepared",{hud:C,actor:this.actor,token:this.token}),C}handleHudEvent(n,A){const k=["groupClick"].includes(n)?this.getGroup(A):null,C=["clickAction","hoverAction"].includes(n)?this.getAction(A):null;this.#b(A),this.#A(A);try{switch(n){case"groupClick":this.rollHandler.handleGroupClickCore(A,k);break;case"clickAction":this.rollHandler.handleActionClickCore(A,C,this.actionHandler);break;case"hoverAction":this.rollHandler.handleActionHoverCore(A,C)}}catch(n){et.error(A)}}#b(n){this.#w(n),this.#T(n),this.#k(n),this.#H(n)}#w(n){const A=n?.originalEvent?.button||n.button;this.isRightClick=2===A}#T(n){const A=foundry?.helpers?.interaction?.KeyboardManager??KeyboardManager,k=game.keyboard.isModifierActive(A.MODIFIER_KEYS.ALT);n.altKey&&!k?(et.debug("Emulating LEFT ALT key press"),A.emulateKeypress(!1,"AltLeft",{altKey:!0,force:!0}),game.keyboard.downKeys.add("AltLeft"),this.isAlt=!0):this.isAlt=k}#k(n){const A=foundry?.helpers?.interaction?.KeyboardManager??KeyboardManager,k=game.keyboard.isModifierActive(A.MODIFIER_KEYS.CONTROL);n.ctrlKey&&!k?(et.debug("Emulating LEFT CTRL key press"),A.emulateKeypress(!1,"ControlLeft",{ctrlKey:!0,force:!0}),game.keyboard.downKeys.add("ControlLeft"),this.isCtrl=!0):this.isCtrl=k}#H(n){const A=foundry?.helpers?.interaction?.KeyboardManager??KeyboardManager,k=game.keyboard.isModifierActive(A.MODIFIER_KEYS.SHIFT);n.shiftKey&&!k?(et.debug("Emulating LEFT SHIFT key press"),A.emulateKeypress(!1,"ShiftLeft",{shiftKey:!0,force:!0}),game.keyboard.downKeys.add("ShiftLeft"),this.isShift=!0):this.isShift=k}#A(n){this.isHover=["mouseenter","mouseover","pointerenter"].includes(n.type)}getGroup(n){const A=Utils.getClosestGroupElement(n),k=A?.dataset?.nestId;return this.groupHandler.getGroup({nestId:k})??null}getAction(n){if(!n)return{};const A=n.target.closest('[data-part="actionButton"]')??n.target.querySelector('[data-part="actionButton"]'),k=A?.dataset?.actionId;return k&&this.actionHandler.availableActions.get(k)||{}}get isHudEnabled(){return!!Utils.getSetting("enable")&&(!!game.user.isGM||Utils.checkAllow(game.user.role,Utils.getSetting("allow")))}get characterName(){return this.characterHandler?.characterName}get actor(){return this.characterHandler?.actor}set actor(n){this.characterHandler.actor=n}get actors(){return this.characterHandler?.actors}set actors(n){this.characterHandler.actors=n}get token(){return this.characterHandler?.token}set token(n){this.characterHandler.token=n}get tokens(){return this.characterHandler?.tokens}set tokens(n){this.characterHandler.tokens=n}}"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self&&self;function getDefaultExportFromCjs(n){return n&&n.__esModule&&Object.prototype.hasOwnProperty.call(n,"default")?n.default:n}var st,nt={exports:{}};st=nt,function(n,A){var k=k||{};"function"==typeof k&&k.amd?k([],A):st.exports=A()}(0,(function(){var n,A=0,k={},C={},O=(n=window.MutationObserver||window.WebKitMutationObserver,function(A,k){A&&1===A.nodeType&&(n?new n((function(n,A){k(n)})).observe(A,{childList:!0,subtree:!1}):window.addEventListener&&A.addEventListener("DOMNodeInserted",k,!1))});function a(n,A){if(!n)return this;A=A||{},this.parentElm=n,this.uid=A.uid,this.settings={selector:"*",callbacks:{}},Object.assign(this.settings,A),this.setup(),O(this.parentElm,this.setup.bind(this)),this.bindEvents()}return a.prototype={namespace:"dragsort",setup(){[...this.parentElm.childNodes].forEach((n=>{if(1!=n.nodeType)return n.parentNode.removeChild(n);n.matches(this.settings.selector)&&(n.draggable=!0)})),this.gap=this.getItemsGap(this.parentElm.firstElementChild)},throttle(n,A){var k=!1,C=this;return function(O){k||(n.call(C,O),k=!0,setTimeout((()=>k=!1),A))}},getDraggableElm(n){if(!n.closest)return null;var A=n.closest('[draggable="true"]');return this.uid==k.uid?A:null},dragstart(n,A){k=this;var C,O=this.getDraggableElm(A);O?(this.saveInitialStyles(),this.source=this.getInitialState(),this.target=this.getInitialState(),C=O.getBoundingClientRect(),this.source.elm=O,this.source.idx=this.getNodeIndex(O),this.source.size.width=C.width,this.source.size.height=C.height,n.dataTransfer.effectAllowed="move",this.settings.callbacks.dragStart&&this.settings.callbacks.dragStart(this.source.elm,n),setTimeout(this.afterDragStart.bind(this))):k={}},afterDragStart(){var n="vertical"==this.settings.mode?"height":"width";this.parentElm.classList.add(`${this.namespace}--dragStart`),this.source.elm.style[n]=this.source.size[n]+"px",this.source.elm.classList.add(`${this.namespace}--dragElem`)},dragover(n){n.preventDefault(),n.stopPropagation();var A=n.target;if((A=this.getDraggableElm(A))&&this.target){var k=this.target.elm,C=this.target.hoverDirection;n.dataTransfer.dropEffect="move",this.target.hoverDirection=this.getTargetDirection(n),k==A&&C==this.target.hoverDirection||this.directionAwareDragEnter(n,A)}},dragenter(n,A){(A=this.getDraggableElm(A))&&this.target&&this.isValidElm(A)&&this.source.elm!=A&&this.source.elm&&(this.target.bounding=A.getBoundingClientRect())},directionAwareDragEnter(n,A){var k;n.preventDefault(),n.stopPropagation(),n.dataTransfer.dropEffect="none",this.isValidElm(A)&&this.source.elm!=A&&this.source.elm&&(n.dataTransfer.dropEffect="move",this.cleanupLastTarget(),this.target.elm=A,this.target.idx=this.getNodeIndex(A),A.classList.add("over"),k=Math.abs(this.target.idx-this.source.idx),this.source.elm.classList.toggle(`${this.namespace}--hide`,k>0),"vertical"==this.settings.mode?this.target.elm.style[this.target.hoverDirection?"marginBottom":"marginTop"]=this.source.size.height+this.gap+"px":this.target.elm.style[this.target.hoverDirection?"marginRight":"marginLeft"]=this.source.size.width+this.gap+"px")},dragend(n){if(clearTimeout(this.dragoverTimeout),this.dragoverTimeout=null,this.parentElm.classList.remove(`${this.namespace}--dragStart`),!this.isValidElm(this.target.elm))return this.cleanup();var A=this.target.hoverDirection?this.target.elm.nextElementSibling:this.target.elm;return this.source.elm!=this.target.elm&&this.target.elm&&(this.target.elm.classList.add(`${this.namespace}--noAnim`),this.cleanup(),this.parentElm.insertBefore(this.source.elm,A)),this.source.elm&&this.source.elm.classList.remove(`${this.namespace}--dragElem`,`${this.namespace}--hide`),this.settings.callbacks.dragEnd&&this.settings.callbacks.dragEnd(this.source.elm),this},isTargetLastChild(){return this.parentElm.lastElementChild==this.target.elm},getTargetDirection(n){if(this.target.bounding)return"vertical"==this.settings.mode?n.pageY>this.target.bounding.top+this.target.bounding.height/2?1:0:n.pageX>this.target.bounding.left+this.target.bounding.width/2?1:0},getNodeIndex(n){for(var A=0;n=n.previousSibling;)3==n.nodeType&&/^\s*$/.test(n.data)||A++;return A},isValidElm(n){return n&&n.nodeType&&n.parentNode==this.parentElm},saveInitialStyles(){[...this.parentElm.children].forEach((n=>{n.setAttribute("dragsort-initial-style",n.getAttribute("style"))}))},cleanup(){k={},[...this.parentElm.children].forEach((n=>{n.style=n.getAttribute("dragsort-initial-style"),n.removeAttribute("dragsort-initial-style"),setTimeout((()=>{n.classList.remove(`${this.namespace}--over`,`${this.namespace}--noAnim`,`${this.namespace}--dragElem`)}),50)}))},cleanupLastTarget(){const{elm:n}=this.target;n&&(n.classList.remove(`${this.namespace}--hide`,`${this.namespace}--over`),n.style=n.getAttribute("dragsort-initial-style"))},getInitialState:()=>({elm:null,size:{}}),getItemsGap(n){var A=getComputedStyle(n),k=getComputedStyle(n.parentNode),C="vertical"==this.settings.mode,O=parseInt(k.gap)||0;return parseInt(A["margin"+(C?"Top":"Left")])+parseInt(A["margin"+(C?"Bottom":"Right")])+O},bindEvents(n){for(var A in this.listeners=this.listeners||{dragstart:n=>this.dragstart(n,n.target),dragenter:n=>this.dragenter(n,n.target),dragend:n=>this.dragend(n,n.target),dragover:this.throttle(this.dragover,350)},this.listeners)this.parentElm[n?"removeEventListener":"addEventListener"](A,this.listeners[A])},destroy(){this.cleanup(),this.bindEvents(!0),delete C[this.uid]}},function(n,k){return C[++A]=n.DragSort?C[n.DragSort]:new a(n,{...k,uid:A}),n.DragSort=A,C[A]}}));var ot=nt.exports;const at=getDefaultExportFromCjs(ot);var rt="&#8203;";function e(n,A){(null==A||A>n.length)&&(A=n.length);for(var k=0,C=new Array(A);k<A;k++)C[k]=n[k];return C}function i(n){return function(n){if(Array.isArray(n))return e(n)}(n)||function(n){if("undefined"!=typeof Symbol&&null!=n[Symbol.iterator]||null!=n["@@iterator"])return Array.from(n)}(n)||function(n,A){if(n){if("string"==typeof n)return e(n,A);var k=Object.prototype.toString.call(n).slice(8,-1);return"Object"===k&&n.constructor&&(k=n.constructor.name),"Map"===k||"Set"===k?Array.from(k):"Arguments"===k||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(k)?e(n,A):void 0}}(n)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}var lt={isEnabled:function(){var n;return null===(n=window.TAGIFY_DEBUG)||void 0===n||n},log:function(){for(var n=arguments.length,A=new Array(n),k=0;k<n;k++)A[k]=arguments[k];var C;this.isEnabled()&&(C=console).log.apply(C,["[Tagify]:"].concat(i(A)))},warn:function(){for(var n=arguments.length,A=new Array(n),k=0;k<n;k++)A[k]=arguments[k];var C;this.isEnabled()&&(C=console).warn.apply(C,["[Tagify]:"].concat(i(A)))}},s=function(n,A,k,C){return n=""+n,A=""+A,C&&(n=n.trim(),A=A.trim()),k?n==A:n.toLowerCase()==A.toLowerCase()},a=function(n,A){return n&&Array.isArray(n)&&n.map((function(n){return o(n,A)}))};function o(n,A){var k,C={};for(k in n)A.indexOf(k)<0&&(C[k]=n[k]);return C}function r(n){return(new DOMParser).parseFromString(n.trim(),"text/html").body.firstElementChild}function l(n,A){for(A=A||"previous";n=n[A+"Sibling"];)if(3==n.nodeType)return n}function d(n){return"string"==typeof n?n.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/`|'/g,"&#039;"):n}function c(n){var A=Object.prototype.toString.call(n).split(" ")[1].slice(0,-1);return n===Object(n)&&"Array"!=A&&"Function"!=A&&"RegExp"!=A&&"HTMLUnknownElement"!=A}function u(n,A,k){var C,O;function a(n,A){for(var k in A)if(A.hasOwnProperty(k)){if(c(A[k])){c(n[k])?a(n[k],A[k]):n[k]=Object.assign({},A[k]);continue}if(Array.isArray(A[k])){n[k]=Object.assign([],A[k]);continue}n[k]=A[k]}}return C=n,(null!=(O=Object)&&"undefined"!=typeof Symbol&&O[Symbol.hasInstance]?O[Symbol.hasInstance](C):C instanceof O)||(n={}),a(n,A),k&&a(n,k),n}function g(){var n=[],A={},k=!0,C=!1,O=void 0;try{for(var L,U=arguments[Symbol.iterator]();!(k=(L=U.next()).done);k=!0){var _=L.value,j=!0,Y=!1,Q=void 0;try{for(var Z,tt=_[Symbol.iterator]();!(j=(Z=tt.next()).done);j=!0){var et=Z.value;c(et)?A[et.value]||(n.push(et),A[et.value]=1):n.includes(et)||n.push(et)}}catch(n){Y=!0,Q=n}finally{try{j||null==tt.return||tt.return()}finally{if(Y)throw Q}}}}catch(n){C=!0,O=n}finally{try{k||null==U.return||U.return()}finally{if(C)throw O}}return n}function h(n){return String.prototype.normalize?"string"==typeof n?n.normalize("NFD").replace(/[\u0300-\u036f]/g,""):void 0:n}var p=function(){return/(?=.*chrome)(?=.*android)/i.test(navigator.userAgent)};function f(){return([1e7]+-1e3+-4e3+-8e3+-1e11).replace(/[018]/g,(function(n){return(n^crypto.getRandomValues(new Uint8Array(1))[0]&15>>n/4).toString(16)}))}function m(n){return n&&n.classList&&n.classList.contains(this.settings.classNames.tag)}function v(n){return n&&n.closest(this.settings.classNames.tagSelector)}function b(n,A){var k=window.getSelection();return A=A||k.getRangeAt(0),"string"==typeof n&&(n=document.createTextNode(n)),A&&(A.deleteContents(),A.insertNode(n)),n}function w(n,A,k){return n?(A&&(n.__tagifyTagData=k?A:u({},n.__tagifyTagData||{},A)),n.__tagifyTagData):(lt.warn("tag element doesn't exist",{tagElm:n,data:A}),A)}function y(n){if(n&&n.parentNode){var A=n,k=window.getSelection(),C=k.getRangeAt(0);k.rangeCount&&(C.setStartAfter(A),C.collapse(!0),k.removeAllRanges(),k.addRange(C))}}function T(n,A){n.forEach((function(n){if(w(n.previousSibling)||!n.previousSibling){var k=document.createTextNode("​");n.before(k),A&&y(k)}}))}var ct={delimiters:",",pattern:null,tagTextProp:"value",maxTags:1/0,callbacks:{},addTagOnBlur:!0,addTagOn:["blur","tab","enter"],onChangeAfterBlur:!0,duplicates:!1,whitelist:[],blacklist:[],enforceWhitelist:!1,userInput:!0,focusable:!0,keepInvalidTags:!1,createInvalidTags:!0,mixTagsAllowedAfter:/,|\.|\:|\s/,mixTagsInterpolator:["[[","]]"],backspace:!0,skipInvalid:!1,pasteAsTags:!0,editTags:{clicks:2,keepInvalid:!0},transformTag:function(){},trim:!0,a11y:{focusableTags:!1},mixMode:{insertAfterTag:" "},autoComplete:{enabled:!0,rightKey:!1,tabKey:!1},classNames:{namespace:"tagify",mixMode:"tagify--mix",selectMode:"tagify--select",input:"tagify__input",focus:"tagify--focus",tagNoAnimation:"tagify--noAnim",tagInvalid:"tagify--invalid",tagNotAllowed:"tagify--notAllowed",scopeLoading:"tagify--loading",hasMaxTags:"tagify--hasMaxTags",hasNoTags:"tagify--noTags",empty:"tagify--empty",inputInvalid:"tagify__input--invalid",dropdown:"tagify__dropdown",dropdownWrapper:"tagify__dropdown__wrapper",dropdownHeader:"tagify__dropdown__header",dropdownFooter:"tagify__dropdown__footer",dropdownItem:"tagify__dropdown__item",dropdownItemActive:"tagify__dropdown__item--active",dropdownItemHidden:"tagify__dropdown__item--hidden",dropdownItemSelected:"tagify__dropdown__item--selected",dropdownInital:"tagify__dropdown--initial",tag:"tagify__tag",tagText:"tagify__tag-text",tagX:"tagify__tag__removeBtn",tagLoading:"tagify__tag--loading",tagEditing:"tagify__tag--editable",tagFlash:"tagify__tag--flash",tagHide:"tagify__tag--hide"},dropdown:{classname:"",enabled:2,maxItems:10,searchKeys:["value","searchBy"],fuzzySearch:!0,caseSensitive:!1,accentedSearch:!0,includeSelectedTags:!1,escapeHTML:!0,highlightFirst:!0,closeOnSelect:!0,clearOnSelect:!0,position:"all",appendTarget:null},hooks:{beforeRemoveTag:function(){return Promise.resolve()},beforePaste:function(){return Promise.resolve()},suggestionClick:function(){return Promise.resolve()},beforeKeyDown:function(){return Promise.resolve()}}};function x(n,A,k){return A in n?Object.defineProperty(n,A,{value:k,enumerable:!0,configurable:!0,writable:!0}):n[A]=k,n}function D(n){for(var A=1;A<arguments.length;A++){var k=null!=arguments[A]?arguments[A]:{},C=Object.keys(k);"function"==typeof Object.getOwnPropertySymbols&&(C=C.concat(Object.getOwnPropertySymbols(k).filter((function(n){return Object.getOwnPropertyDescriptor(k,n).enumerable})))),C.forEach((function(A){x(n,A,k[A])}))}return n}function I(n,A){return A=null!=A?A:{},Object.getOwnPropertyDescriptors?Object.defineProperties(n,Object.getOwnPropertyDescriptors(A)):function(n,A){var k=Object.keys(n);if(Object.getOwnPropertySymbols){var C=Object.getOwnPropertySymbols(n);A&&(C=C.filter((function(A){return Object.getOwnPropertyDescriptor(n,A).enumerable}))),k.push.apply(k,C)}return k}(Object(A)).forEach((function(k){Object.defineProperty(n,k,Object.getOwnPropertyDescriptor(A,k))})),n}function S(n,A){(null==A||A>n.length)&&(A=n.length);for(var k=0,C=new Array(A);k<A;k++)C[k]=n[k];return C}function E(n,A,k){return A in n?Object.defineProperty(n,A,{value:k,enumerable:!0,configurable:!0,writable:!0}):n[A]=k,n}function M(n){return function(n){if(Array.isArray(n))return S(n)}(n)||function(n){if("undefined"!=typeof Symbol&&null!=n[Symbol.iterator]||null!=n["@@iterator"])return Array.from(n)}(n)||function(n,A){if(n){if("string"==typeof n)return S(n,A);var k=Object.prototype.toString.call(n).slice(8,-1);return"Object"===k&&n.constructor&&(k=n.constructor.name),"Map"===k||"Set"===k?Array.from(k):"Arguments"===k||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(k)?S(n,A):void 0}}(n)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function N(){for(var n in this.dropdown={},this._dropdown)this.dropdown[n]="function"==typeof this._dropdown[n]?this._dropdown[n].bind(this):this._dropdown[n];this.dropdown.refs(),this.DOM.dropdown.__tagify=this}var dt,ut,gt=(dt=function(n){for(var A=1;A<arguments.length;A++){var k=null!=arguments[A]?arguments[A]:{},C=Object.keys(k);"function"==typeof Object.getOwnPropertySymbols&&(C=C.concat(Object.getOwnPropertySymbols(k).filter((function(n){return Object.getOwnPropertyDescriptor(k,n).enumerable})))),C.forEach((function(A){E(n,A,k[A])}))}return n}({},{events:{binding:function(){var n=!(arguments.length>0&&void 0!==arguments[0])||arguments[0],A=this.dropdown.events.callbacks,k=this.listeners.dropdown=this.listeners.dropdown||{position:this.dropdown.position.bind(this,null),onKeyDown:A.onKeyDown.bind(this),onMouseOver:A.onMouseOver.bind(this),onMouseLeave:A.onMouseLeave.bind(this),onClick:A.onClick.bind(this),onScroll:A.onScroll.bind(this)},C=n?"addEventListener":"removeEventListener";"manual"!=this.settings.dropdown.position&&(document[C]("scroll",k.position,!0),window[C]("resize",k.position),window[C]("keydown",k.onKeyDown)),this.DOM.dropdown[C]("mouseover",k.onMouseOver),this.DOM.dropdown[C]("mouseleave",k.onMouseLeave),this.DOM.dropdown[C]("mousedown",k.onClick),this.DOM.dropdown.content[C]("scroll",k.onScroll)},callbacks:{onKeyDown:function(n){var A=this;if(this.state.hasFocus&&!this.state.composing){var k=this.settings,C=this.DOM.dropdown.querySelector(k.classNames.dropdownItemActiveSelector),O=this.dropdown.getSuggestionDataByNode(C),L="mix"==k.mode,U="select"==k.mode;k.hooks.beforeKeyDown(n,{tagify:this}).then((function(_){switch(n.key){case"ArrowDown":case"ArrowUp":case"Down":case"Up":n.preventDefault();var j=A.dropdown.getAllSuggestionsRefs(),Y="ArrowUp"==n.key||"Up"==n.key;C&&(C=A.dropdown.getNextOrPrevOption(C,!Y)),C&&C.matches(k.classNames.dropdownItemSelector)||(C=j[Y?j.length-1:0]),A.dropdown.highlightOption(C,!0);break;case"Escape":case"Esc":A.dropdown.hide();break;case"ArrowRight":if(A.state.actions.ArrowLeft||k.autoComplete.rightKey)return;case"Tab":var Q=!k.autoComplete.rightKey||!k.autoComplete.tabKey;if(!L&&!U&&C&&Q&&!A.state.editing&&O){n.preventDefault();var Z=A.dropdown.getMappedValue(O);return A.input.autocomplete.set.call(A,Z),!1}return!0;case"Enter":n.preventDefault(),k.hooks.suggestionClick(n,{tagify:A,tagData:O,suggestionElm:C}).then((function(){if(C)return A.dropdown.selectOption(C),C=A.dropdown.getNextOrPrevOption(C,!Y),void A.dropdown.highlightOption(C);A.dropdown.hide(),L||A.addTags(A.state.inputText.trim(),!0)})).catch((function(n){return lt.warn(n)}));break;case"Backspace":if(L||A.state.editing.scope)return;var tt=A.input.raw.call(A);""!=tt&&8203!=tt.charCodeAt(0)||(!0===k.backspace?A.removeTags():"edit"==k.backspace&&setTimeout(A.editTag.bind(A),0))}}))}},onMouseOver:function(n){var A=n.target.closest(this.settings.classNames.dropdownItemSelector);this.dropdown.highlightOption(A)},onMouseLeave:function(n){this.dropdown.highlightOption()},onClick:function(n){var A=this;if(0==n.button&&n.target!=this.DOM.dropdown&&n.target!=this.DOM.dropdown.content){var k=n.target.closest(this.settings.classNames.dropdownItemSelector),C=this.dropdown.getSuggestionDataByNode(k);this.state.actions.selectOption=!0,setTimeout((function(){return A.state.actions.selectOption=!1}),50),this.settings.hooks.suggestionClick(n,{tagify:this,tagData:C,suggestionElm:k}).then((function(){k?A.dropdown.selectOption(k,n):A.dropdown.hide()})).catch((function(n){return lt.warn(n)}))}},onScroll:function(n){var A=n.target,k=A.scrollTop/(A.scrollHeight-A.parentNode.clientHeight)*100;this.trigger("dropdown:scroll",{percentage:Math.round(k)})}}},refilter:function(n){n=n||this.state.dropdown.query||"",this.suggestedListItems=this.dropdown.filterListItems(n),this.dropdown.fill(),this.suggestedListItems.length||this.dropdown.hide(),this.trigger("dropdown:updated",this.DOM.dropdown)},getSuggestionDataByNode:function(n){for(var A,k=n&&n.getAttribute("value"),C=this.suggestedListItems.length;C--;){if(c(A=this.suggestedListItems[C])&&A.value==k)return A;if(A==k)return{value:A}}},getNextOrPrevOption:function(n){var A=!(arguments.length>1&&void 0!==arguments[1])||arguments[1],k=this.dropdown.getAllSuggestionsRefs(),C=k.findIndex((function(A){return A===n}));return A?k[C+1]:k[C-1]},highlightOption:function(n,A){var k,C=this.settings.classNames.dropdownItemActive;if(this.state.ddItemElm&&(this.state.ddItemElm.classList.remove(C),this.state.ddItemElm.removeAttribute("aria-selected")),!n)return this.state.ddItemData=null,this.state.ddItemElm=null,void this.input.autocomplete.suggest.call(this);k=this.dropdown.getSuggestionDataByNode(n),this.state.ddItemData=k,this.state.ddItemElm=n,n.classList.add(C),n.setAttribute("aria-selected",!0),A&&(n.parentNode.scrollTop=n.clientHeight+n.offsetTop-n.parentNode.clientHeight),this.settings.autoComplete&&(this.input.autocomplete.suggest.call(this,k),this.dropdown.position())},selectOption:function(n,A){var k=this,C=this.settings,O=C.dropdown,L=O.clearOnSelect,U=O.closeOnSelect;if(!n)return this.addTags(this.state.inputText,!0),void(U&&this.dropdown.hide());A=A||{};var _=n.getAttribute("value"),j="noMatch"==_,Y="mix"==C.mode,Q=this.suggestedListItems.find((function(n){var A;return(null!==(A=n.value)&&void 0!==A?A:n)==_}));if(this.trigger("dropdown:select",{data:Q,elm:n,event:A}),Q||j){if(this.state.editing){var Z=this.normalizeTags([Q])[0];Q=C.transformTag.call(this,Z)||Z,this.onEditTagDone(null,u({__isValid:!0},Q))}else this[Y?"addMixTags":"addTags"]([Q||this.input.raw.call(this)],L);(Y||this.DOM.input.parentNode)&&(setTimeout((function(){k.DOM.input.focus(),k.toggleFocusClass(!0)})),U&&setTimeout(this.dropdown.hide.bind(this)),n.addEventListener("transitionend",(function(){k.dropdown.fillHeaderFooter(),setTimeout((function(){n.remove(),k.dropdown.refilter()}),100)}),{once:!0}),n.classList.add(this.settings.classNames.dropdownItemHidden))}else U&&setTimeout(this.dropdown.hide.bind(this))},selectAll:function(n){this.suggestedListItems.length=0,this.dropdown.hide(),this.dropdown.filterListItems("");var A=this.dropdown.filterListItems("");return n||(A=this.state.dropdown.suggestions),this.addTags(A,!0),this},filterListItems:function(n,A){var k,C,O,L,U,_,l=function(){var n,j,Y=void 0,it=void 0;n=et[ot],C=(null!=(j=Object)&&"undefined"!=typeof Symbol&&j[Symbol.hasInstance]?j[Symbol.hasInstance](n):n instanceof j)?et[ot]:{value:et[ot]};var st,at=Object.keys(C).some((function(n){return nt.includes(n)}))?nt:["value"];Q.fuzzySearch&&!A.exact?(L=at.reduce((function(n,A){return n+" "+(C[A]||"")}),"").toLowerCase().trim(),Q.accentedSearch&&(L=h(L),_=h(_)),Y=0==L.indexOf(_),it=L===_,st=L,O=_.toLowerCase().split(" ").every((function(n){return st.includes(n.toLowerCase())}))):(Y=!0,O=at.some((function(n){var k=""+(C[n]||"");return Q.accentedSearch&&(k=h(k),_=h(_)),Q.caseSensitive||(k=k.toLowerCase()),it=k===_,A.exact?k===_:0==k.indexOf(_)}))),U=!Q.includeSelectedTags&&k.isTagDuplicate(c(C)?C.value:C),O&&!U&&(it&&Y?tt.push(C):"startsWith"==Q.sortby&&Y?Z.unshift(C):Z.push(C))},j=this,Y=this.settings,Q=Y.dropdown,Z=(A=A||{},[]),tt=[],et=Y.whitelist,it=Q.maxItems>=0?Q.maxItems:1/0,st=Q.includeSelectedTags||"select"==Y.mode,nt=Q.searchKeys,ot=0;if(!(n="select"==Y.mode&&this.value.length&&this.value[0][Y.tagTextProp]==n?"":n)||!nt.length)return Z=st?et:et.filter((function(n){return!j.isTagDuplicate(c(n)?n.value:n)})),this.state.dropdown.suggestions=Z,Z.slice(0,it);for(_=Q.caseSensitive?""+n:(""+n).toLowerCase();ot<et.length;ot++)k=this,l();return this.state.dropdown.suggestions=tt.concat(Z),"function"==typeof Q.sortby?Q.sortby(tt.concat(Z),_):tt.concat(Z).slice(0,it)},getMappedValue:function(n){var A=this.settings.dropdown.mapValueTo;return A?"function"==typeof A?A(n):n[A]||n.value:n.value},createListHTML:function(n){var A=this;return u([],n).map((function(n,k){"string"!=typeof n&&"number"!=typeof n||(n={value:n});var C=A.dropdown.getMappedValue(n);return C="string"==typeof C&&A.settings.dropdown.escapeHTML?d(C):C,A.settings.templates.dropdownItem.apply(A,[I(D({},n),{mappedValue:C}),A])})).join("")}}),ut=null!=(ut={refs:function(){this.DOM.dropdown=this.parseTemplate("dropdown",[this.settings]),this.DOM.dropdown.content=this.DOM.dropdown.querySelector("[data-selector='tagify-suggestions-wrapper']")},getHeaderRef:function(){return this.DOM.dropdown.querySelector("[data-selector='tagify-suggestions-header']")},getFooterRef:function(){return this.DOM.dropdown.querySelector("[data-selector='tagify-suggestions-footer']")},getAllSuggestionsRefs:function(){return M(this.DOM.dropdown.content.querySelectorAll(this.settings.classNames.dropdownItemSelector))},show:function(n){var A,k,C,O=this,L=this.settings,U="mix"==L.mode&&!L.enforceWhitelist,_=!L.whitelist||!L.whitelist.length,j="manual"==L.dropdown.position;if(n=void 0===n?this.state.inputText:n,!(_&&!U&&!L.templates.dropdownItemNoMatch||!1===L.dropdown.enable||this.state.isLoading||this.settings.readonly)){if(clearTimeout(this.dropdownHide__bindEventsTimeout),this.suggestedListItems=this.dropdown.filterListItems(n),n&&!this.suggestedListItems.length&&(this.trigger("dropdown:noMatch",n),L.templates.dropdownItemNoMatch&&(C=L.templates.dropdownItemNoMatch.call(this,{value:n}))),!C){if(this.suggestedListItems.length)n&&U&&!this.state.editing.scope&&!s(this.suggestedListItems[0].value,n)&&this.suggestedListItems.unshift({value:n});else{if(!n||!U||this.state.editing.scope)return this.input.autocomplete.suggest.call(this),void this.dropdown.hide();this.suggestedListItems=[{value:n}]}k=""+(c(A=this.suggestedListItems[0])?A.value:A),L.autoComplete&&k&&0==k.indexOf(n)&&this.input.autocomplete.suggest.call(this,A)}this.dropdown.fill(C),L.dropdown.highlightFirst&&this.dropdown.highlightOption(this.DOM.dropdown.content.querySelector(L.classNames.dropdownItemSelector)),this.state.dropdown.visible||setTimeout(this.dropdown.events.binding.bind(this)),this.state.dropdown.visible=n||!0,this.state.dropdown.query=n,this.setStateSelection(),j||setTimeout((function(){O.dropdown.position(),O.dropdown.render()})),setTimeout((function(){O.trigger("dropdown:show",O.DOM.dropdown)}))}},hide:function(n){var A=this,k=this.DOM,C=k.scope,O=k.dropdown,L="manual"==this.settings.dropdown.position&&!n;if(O&&document.body.contains(O)&&!L)return window.removeEventListener("resize",this.dropdown.position),this.dropdown.events.binding.call(this,!1),C.setAttribute("aria-expanded",!1),O.parentNode.removeChild(O),setTimeout((function(){A.state.dropdown.visible=!1}),100),this.state.dropdown.query=this.state.ddItemData=this.state.ddItemElm=this.state.selection=null,this.state.tag&&this.state.tag.value.length&&(this.state.flaggedTags[this.state.tag.baseOffset]=this.state.tag),this.trigger("dropdown:hide",O),this},toggle:function(n){this.dropdown[this.state.dropdown.visible&&!n?"hide":"show"]()},getAppendTarget:function(){var n=this.settings.dropdown;return"function"==typeof n.appendTarget?n.appendTarget():n.appendTarget},render:function(){var n,A,k,C=this,O=(n=this.DOM.dropdown,(k=n.cloneNode(!0)).style.cssText="position:fixed; top:-9999px; opacity:0",document.body.appendChild(k),A=k.clientHeight,k.parentNode.removeChild(k),A),L=this.settings,U=this.dropdown.getAppendTarget();return!1===L.dropdown.enabled||(this.DOM.scope.setAttribute("aria-expanded",!0),document.body.contains(this.DOM.dropdown)||(this.DOM.dropdown.classList.add(L.classNames.dropdownInital),this.dropdown.position(O),U.appendChild(this.DOM.dropdown),setTimeout((function(){return C.DOM.dropdown.classList.remove(L.classNames.dropdownInital)})))),this},fill:function(n){n="string"==typeof n?n:this.dropdown.createListHTML(n||this.suggestedListItems);var A,k=this.settings.templates.dropdownContent.call(this,n);this.DOM.dropdown.content.innerHTML=(A=k)?A.replace(/\>[\r\n ]+\</g,"><").split(/>\s+</).join("><").trim():""},fillHeaderFooter:function(){var n=this.dropdown.filterListItems(this.state.dropdown.query),A=this.parseTemplate("dropdownHeader",[n]),k=this.parseTemplate("dropdownFooter",[n]),C=this.dropdown.getHeaderRef(),O=this.dropdown.getFooterRef();A&&(null==C||C.parentNode.replaceChild(A,C)),k&&(null==O||O.parentNode.replaceChild(k,O))},position:function(n){var A=this.settings.dropdown,k=this.dropdown.getAppendTarget();if("manual"!=A.position&&k){var C,O,L,U,_,j,Y,Q,Z,tt=this.DOM.dropdown,et=A.RTL,it=k===document.body,st=k===this.DOM.scope,nt=it?window.pageYOffset:k.scrollTop,ot=document.fullscreenElement||document.webkitFullscreenElement||document.documentElement,at=ot.clientHeight,rt=Math.max(ot.clientWidth||0,window.innerWidth||0)>480?A.position:"all",lt=this.DOM["input"==rt?"input":"scope"];if(n=n||tt.clientHeight,this.state.dropdown.visible){if("text"==rt?(L=(C=function(){var n=document.getSelection();if(n.rangeCount){var A,k,C=n.getRangeAt(0),O=C.startContainer,L=C.startOffset;if(L>0)return(k=document.createRange()).setStart(O,L-1),k.setEnd(O,L),{left:(A=k.getBoundingClientRect()).right,top:A.top,bottom:A.bottom};if(O.getBoundingClientRect)return O.getBoundingClientRect()}return{left:-9999,top:-9999}}()).bottom,O=C.top,U=C.left,_="auto"):(j=function(n){var A=0,k=0;for(n=n.parentNode;n&&n!=ot;)A+=n.offsetTop||0,k+=n.offsetLeft||0,n=n.parentNode;return{top:A,left:k}}(k),C=lt.getBoundingClientRect(),O=st?-1:C.top-j.top,L=(st?C.height:C.bottom-j.top)-1,U=st?-1:C.left-j.left,_=C.width+"px"),!it){var ct=function(){for(var n=0,k=A.appendTarget.parentNode;k;)n+=k.scrollTop||0,k=k.parentNode;return n}();O+=ct,L+=ct}var dt;O=Math.floor(O),L=Math.ceil(L),Q=((Y=null!==(dt=A.placeAbove)&&void 0!==dt?dt:at-C.bottom<n)?O:L)+nt,Z="left: ".concat(U+(et&&C.width||0)+window.pageXOffset,"px;"),tt.style.cssText="".concat(Z,"; top: ").concat(Q,"px; min-width: ").concat(_,"; max-width: ").concat(_),tt.setAttribute("placement",Y?"top":"bottom"),tt.setAttribute("position",rt)}}}})?ut:{},Object.getOwnPropertyDescriptors?Object.defineProperties(dt,Object.getOwnPropertyDescriptors(ut)):function(n,A){var k=Object.keys(n);if(Object.getOwnPropertySymbols){var C=Object.getOwnPropertySymbols(n);A&&(C=C.filter((function(A){return Object.getOwnPropertyDescriptor(n,A).enumerable}))),k.push.apply(k,C)}return k}(Object(ut)).forEach((function(n){Object.defineProperty(dt,n,Object.getOwnPropertyDescriptor(ut,n))})),dt),ht="@yaireo/tagify/",pt={empty:"empty",exceed:"number of tags exceeded",pattern:"pattern mismatch",duplicate:"already exists",notAllowed:"not allowed"},mt={wrapper:function(n,A){return'<tags class="'.concat(A.classNames.namespace," ").concat(A.mode?"".concat(A.classNames[A.mode+"Mode"]):""," ").concat(n.className,'"\n                    ').concat(A.readonly?"readonly":"","\n                    ").concat(A.disabled?"disabled":"","\n                    ").concat(A.required?"required":"","\n                    ").concat("select"===A.mode?"spellcheck='false'":"",'\n                    tabIndex="-1">\n                    ').concat(this.settings.templates.input.call(this),"\n                ").concat(rt,"\n        </tags>")},input:function(){var n=this.settings,A=n.placeholder||rt;return"<span ".concat(!n.readonly&&n.userInput?"contenteditable":"",' tabIndex="0" data-placeholder="').concat(A,'" aria-placeholder="').concat(n.placeholder||"",'"\n                    class="').concat(n.classNames.input,'"\n                    role="textbox"\n                    autocapitalize="false"\n                    autocorrect="off"\n                    spellcheck="false"\n                    aria-autocomplete="both"\n                    aria-multiline="').concat("mix"==n.mode,'"></span>')},tag:function(n,A){var k=A.settings;return'<tag title="'.concat(n.title||n.value,"\"\n                    contenteditable='false'\n                    tabIndex=\"").concat(k.a11y.focusableTags?0:-1,'"\n                    class="').concat(k.classNames.tag," ").concat(n.class||"",'"\n                    ').concat(this.getAttributes(n),">\n            <x title='' tabIndex=\"").concat(k.a11y.focusableTags?0:-1,'" class="').concat(k.classNames.tagX,"\" role='button' aria-label='remove tag'></x>\n            <div>\n                <span ").concat("select"===k.mode&&k.userInput?"contenteditable='true'":"",' autocapitalize="false" autocorrect="off" spellcheck=\'false\' class="').concat(k.classNames.tagText,'">').concat(n[k.tagTextProp]||n.value,"</span>\n            </div>\n        </tag>")},dropdown:function(n){var A=n.dropdown,k="manual"==A.position;return'<div class="'.concat(k?"":n.classNames.dropdown," ").concat(A.classname,'" role="listbox" aria-labelledby="dropdown" dir="').concat(A.RTL?"rtl":"","\">\n                    <div data-selector='tagify-suggestions-wrapper' class=\"").concat(n.classNames.dropdownWrapper,'"></div>\n                </div>')},dropdownContent:function(n){var A=this.settings.templates,k=this.state.dropdown.suggestions;return"\n            ".concat(A.dropdownHeader.call(this,k),"\n            ").concat(n,"\n            ").concat(A.dropdownFooter.call(this,k),"\n        ")},dropdownItem:function(n){return"<div ".concat(this.getAttributes(n),"\n                    class='").concat(this.settings.classNames.dropdownItem," ").concat(this.isTagDuplicate(n.value)?this.settings.classNames.dropdownItemSelected:""," ").concat(n.class||"",'\'\n                    tabindex="0"\n                    role="option">').concat(n.mappedValue||n.value,"</div>")},dropdownHeader:function(n){return"<header data-selector='tagify-suggestions-header' class=\"".concat(this.settings.classNames.dropdownHeader,'"></header>')},dropdownFooter:function(n){var A=n.length-this.settings.dropdown.maxItems;return A>0?"<footer data-selector='tagify-suggestions-footer' class=\"".concat(this.settings.classNames.dropdownFooter,'">\n                ').concat(A," more items. Refine your search.\n            </footer>"):""},dropdownItemNoMatch:null};function P(n,A){(null==A||A>n.length)&&(A=n.length);for(var k=0,C=new Array(A);k<A;k++)C[k]=n[k];return C}function V(n,A){return null!=A&&"undefined"!=typeof Symbol&&A[Symbol.hasInstance]?!!A[Symbol.hasInstance](n):n instanceof A}function F(n,A){return function(n){if(Array.isArray(n))return n}(n)||function(n,A){var k=null==n?null:"undefined"!=typeof Symbol&&n[Symbol.iterator]||n["@@iterator"];if(null!=k){var C,O,L=[],U=!0,_=!1;try{for(k=k.call(n);!(U=(C=k.next()).done)&&(L.push(C.value),!A||L.length!==A);U=!0);}catch(n){_=!0,O=n}finally{try{U||null==k.return||k.return()}finally{if(_)throw O}}return L}}(n,A)||function(n,A){if(n){if("string"==typeof n)return P(n,A);var k=Object.prototype.toString.call(n).slice(8,-1);return"Object"===k&&n.constructor&&(k=n.constructor.name),"Map"===k||"Set"===k?Array.from(k):"Arguments"===k||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(k)?P(n,A):void 0}}(n,A)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function R(n,A){(null==A||A>n.length)&&(A=n.length);for(var k=0,C=new Array(A);k<A;k++)C[k]=n[k];return C}function H(n,A,k){return A in n?Object.defineProperty(n,A,{value:k,enumerable:!0,configurable:!0,writable:!0}):n[A]=k,n}function B(n,A){return null!=A&&"undefined"!=typeof Symbol&&A[Symbol.hasInstance]?!!A[Symbol.hasInstance](n):n instanceof A}function W(n,A){return A=null!=A?A:{},Object.getOwnPropertyDescriptors?Object.defineProperties(n,Object.getOwnPropertyDescriptors(A)):function(n,A){var k=Object.keys(n);if(Object.getOwnPropertySymbols){var C=Object.getOwnPropertySymbols(n);A&&(C=C.filter((function(A){return Object.getOwnPropertyDescriptor(n,A).enumerable}))),k.push.apply(k,C)}return k}(Object(A)).forEach((function(k){Object.defineProperty(n,k,Object.getOwnPropertyDescriptor(A,k))})),n}function K(n){return function(n){if(Array.isArray(n))return R(n)}(n)||function(n){if("undefined"!=typeof Symbol&&null!=n[Symbol.iterator]||null!=n["@@iterator"])return Array.from(n)}(n)||function(n,A){if(n){if("string"==typeof n)return R(n,A);var k=Object.prototype.toString.call(n).slice(8,-1);return"Object"===k&&n.constructor&&(k=n.constructor.name),"Map"===k||"Set"===k?Array.from(k):"Arguments"===k||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(k)?R(n,A):void 0}}(n)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}var ft={customBinding:function(){var n=this;this.customEventsList.forEach((function(A){n.on(A,n.settings.callbacks[A])}))},binding:function(){var n,A=!(arguments.length>0&&void 0!==arguments[0])||arguments[0],k=this.settings,C=this.events.callbacks,O=A?"addEventListener":"removeEventListener";if(!this.state.mainEvents||!A){for(var L in this.state.mainEvents=A,A&&!this.listeners.main&&(this.events.bindGlobal.call(this),this.settings.isJQueryPlugin&&jQuery(this.DOM.originalInput).on("tagify.removeAllTags",this.removeAllTags.bind(this))),n=this.listeners.main=this.listeners.main||{keydown:["input",C.onKeydown.bind(this)],click:["scope",C.onClickScope.bind(this)],dblclick:"select"!=k.mode&&["scope",C.onDoubleClickScope.bind(this)],paste:["input",C.onPaste.bind(this)],drop:["input",C.onDrop.bind(this)],compositionstart:["input",C.onCompositionStart.bind(this)],compositionend:["input",C.onCompositionEnd.bind(this)]})n[L]&&this.DOM[n[L][0]][O](L,n[L][1]);var U=this.listeners.main.inputMutationObserver||new MutationObserver(C.onInputDOMChange.bind(this));U.disconnect(),"mix"==k.mode&&U.observe(this.DOM.input,{childList:!0}),this.events.bindOriginaInputListener.call(this)}},bindOriginaInputListener:function(n){var A=(n||0)+500;this.listeners.main&&(clearInterval(this.listeners.main.originalInputValueObserverInterval),this.listeners.main.originalInputValueObserverInterval=setInterval(this.events.callbacks.observeOriginalInputValue.bind(this),A))},bindGlobal:function(n){var A,k=this.events.callbacks,C=n?"removeEventListener":"addEventListener";if(this.listeners&&(n||!this.listeners.global)){this.listeners.global=this.listeners.global||[{type:this.isIE?"keydown":"input",target:this.DOM.input,cb:k[this.isIE?"onInputIE":"onInput"].bind(this)},{type:"keydown",target:window,cb:k.onWindowKeyDown.bind(this)},{type:"focusin",target:this.DOM.scope,cb:k.onFocusBlur.bind(this)},{type:"focusout",target:this.DOM.scope,cb:k.onFocusBlur.bind(this)},{type:"click",target:document,cb:k.onClickAnywhere.bind(this),useCapture:!0}];var O=!0,L=!1,U=void 0;try{for(var _,j=this.listeners.global[Symbol.iterator]();!(O=(_=j.next()).done);O=!0)(A=_.value).target[C](A.type,A.cb,!!A.useCapture)}catch(n){L=!0,U=n}finally{try{O||null==j.return||j.return()}finally{if(L)throw U}}}},unbindGlobal:function(){this.events.bindGlobal.call(this,!0)},callbacks:{onFocusBlur:function(n){var A,k,C=this.settings,O=v.call(this,n.target),L=m.call(this,n.target),U=n.target.classList.contains(C.classNames.tagX),_="focusin"==n.type,j="focusout"==n.type;O&&_&&!L&&!U&&this.toggleFocusClass(this.state.hasFocus=+new Date);var Y=n.target?this.trim(this.DOM.input.textContent):"",Q=null===(k=this.value)||void 0===k||null===(A=k[0])||void 0===A?void 0:A[C.tagTextProp],Z=C.dropdown.enabled>=0,tt={relatedTarget:n.relatedTarget},et=this.state.actions.selectOption&&(Z||!C.dropdown.closeOnSelect),it=this.state.actions.addNew&&Z;if(j){if(n.relatedTarget===this.DOM.scope)return this.dropdown.hide(),void this.DOM.input.focus();this.postUpdate(),C.onChangeAfterBlur&&this.triggerChangeEvent()}if(!(et||it||U))if(_||O?(this.state.hasFocus=+new Date,this.toggleFocusClass(this.state.hasFocus)):this.state.hasFocus=!1,"mix"!=C.mode){if(_){if(!C.focusable)return;var st=0===C.dropdown.enabled&&!this.state.dropdown.visible,nt=!L||"select"===C.mode;return this.toggleFocusClass(!0),this.trigger("focus",tt),void(st&&nt&&this.dropdown.show(this.value.length?"":void 0))}if(j){if(this.trigger("blur",tt),this.loading(!1),"select"==C.mode){if(this.value.length){var ot=this.getTagElms()[0];Y=this.trim(ot.textContent)}Q===Y&&(Y="")}Y&&!this.state.actions.selectOption&&C.addTagOnBlur&&C.addTagOn.includes("blur")&&this.addTags(Y,!0)}O||(this.DOM.input.removeAttribute("style"),this.dropdown.hide())}else _?this.trigger("focus",tt):j&&(this.trigger("blur",tt),this.loading(!1),this.dropdown.hide(),this.state.dropdown.visible=void 0,this.setStateSelection())},onCompositionStart:function(n){this.state.composing=!0},onCompositionEnd:function(n){this.state.composing=!1},onWindowKeyDown:function(n){var A,k=this.settings,C=document.activeElement,O=v.call(this,C)&&this.DOM.scope.contains(document.activeElement),L=O&&C.hasAttribute("readonly");if(this.state.hasFocus||O&&!L){A=C.nextElementSibling;var U=n.target.classList.contains(k.classNames.tagX);switch(n.key){case"Backspace":k.readonly||this.state.editing||(this.removeTags(C),(A||this.DOM.input).focus());break;case"Enter":if(U)return void this.removeTags(n.target.parentNode);k.a11y.focusableTags&&m.call(this,C)&&setTimeout(this.editTag.bind(this),0,C);break;case"ArrowDown":this.state.dropdown.visible||"mix"==k.mode||this.dropdown.show()}}},onKeydown:function(n){var A=this,k=this.settings;if(!this.state.composing&&k.userInput){"select"==k.mode&&k.enforceWhitelist&&this.value.length&&"Tab"!=n.key&&n.preventDefault();var C=this.trim(n.target.textContent);this.trigger("keydown",{event:n}),k.hooks.beforeKeyDown(n,{tagify:this}).then((function(O){if("mix"==k.mode){switch(n.key){case"Left":case"ArrowLeft":A.state.actions.ArrowLeft=!0;break;case"Delete":case"Backspace":if(A.state.editing)return;var L=document.getSelection(),U="Delete"==n.key&&L.anchorOffset==(L.anchorNode.length||0),_=L.anchorNode.previousSibling,j=1==L.anchorNode.nodeType||!L.anchorOffset&&_&&1==_.nodeType&&L.anchorNode.previousSibling;!function(n){var A=document.createElement("div");n.replace(/\&#?[0-9a-z]+;/gi,(function(n){return A.innerHTML=n,A.innerText}))}(A.DOM.input.innerHTML);var Y,Q,Z,tt=A.getTagElms(),et=1===L.anchorNode.length&&L.anchorNode.nodeValue==String.fromCharCode(8203);if("edit"==k.backspace&&j)return Y=1==L.anchorNode.nodeType?null:L.anchorNode.previousElementSibling,setTimeout(A.editTag.bind(A),0,Y),void n.preventDefault();if(p()&&B(j,Element))return Z=l(j),j.hasAttribute("readonly")||j.remove(),A.DOM.input.focus(),void setTimeout((function(){y(Z),A.DOM.input.click()}));if("BR"==L.anchorNode.nodeName)return;if((U||j)&&1==L.anchorNode.nodeType?Q=0==L.anchorOffset?U?tt[0]:null:tt[Math.min(tt.length,L.anchorOffset)-1]:U?Q=L.anchorNode.nextElementSibling:B(j,Element)&&(Q=j),3==L.anchorNode.nodeType&&!L.anchorNode.nodeValue&&L.anchorNode.previousElementSibling&&n.preventDefault(),(j||U)&&!k.backspace)return void n.preventDefault();if("Range"!=L.type&&!L.anchorOffset&&L.anchorNode==A.DOM.input&&"Delete"!=n.key)return void n.preventDefault();if("Range"!=L.type&&Q&&Q.hasAttribute("readonly"))return void y(l(Q));"Delete"==n.key&&et&&w(L.anchorNode.nextSibling)&&A.removeTags(L.anchorNode.nextSibling)}return!0}var it="manual"==k.dropdown.position;switch(n.key){case"Backspace":"select"==k.mode&&k.enforceWhitelist&&A.value.length?A.removeTags():A.state.dropdown.visible&&"manual"!=k.dropdown.position||""!=n.target.textContent&&8203!=C.charCodeAt(0)||(!0===k.backspace?A.removeTags():"edit"==k.backspace&&setTimeout(A.editTag.bind(A),0));break;case"Esc":case"Escape":if(A.state.dropdown.visible)return;n.target.blur();break;case"Down":case"ArrowDown":A.state.dropdown.visible||A.dropdown.show();break;case"ArrowRight":var st=A.state.inputSuggestion||A.state.ddItemData;if(st&&k.autoComplete.rightKey)return void A.addTags([st],!0);break;case"Tab":var nt="select"==k.mode;if(!C||nt)return!0;n.preventDefault();case"Enter":if(A.state.dropdown.visible&&!it)return;n.preventDefault(),setTimeout((function(){A.state.dropdown.visible&&!it||A.state.actions.selectOption||!k.addTagOn.includes(n.key.toLowerCase())||A.addTags(C,!0)}))}})).catch((function(n){return n}))}},onInput:function(n){this.postUpdate();var A=this.settings;if("mix"==A.mode)return this.events.callbacks.onMixTagsInput.call(this,n);var k=this.input.normalize.call(this,void 0,{trim:!1}),C=k.length>=A.dropdown.enabled,O={value:k,inputElm:this.DOM.input},L=this.validateTag({value:k});"select"==A.mode&&this.toggleScopeValidation(L),O.isValid=L,this.state.inputText!=k&&(this.input.set.call(this,k,!1),-1!=k.search(A.delimiters)?this.addTags(k)&&this.input.set.call(this):A.dropdown.enabled>=0&&this.dropdown[C?"show":"hide"](k),this.trigger("input",O))},onMixTagsInput:function(n){var A,k,C,O,L,U,_,j,Y=this,Q=this.settings,Z=this.value.length,tt=this.getTagElms(),et=document.createDocumentFragment(),it=window.getSelection().getRangeAt(0),st=[].map.call(tt,(function(n){return w(n).value}));if("deleteContentBackward"==n.inputType&&p()&&this.events.callbacks.onKeydown.call(this,{target:n.target,key:"Backspace"}),T(this.getTagElms()),this.value.slice().forEach((function(n){n.readonly&&!st.includes(n.value)&&et.appendChild(Y.createTagElem(n))})),et.childNodes.length&&(it.insertNode(et),this.setRangeAtStartEnd(!1,et.lastChild)),tt.length!=Z)return this.value=[].map.call(this.getTagElms(),(function(n){return w(n)})),void this.update({withoutChangeEvent:!0});if(this.hasMaxTags())return!0;if(window.getSelection&&(U=window.getSelection()).rangeCount>0&&3==U.anchorNode.nodeType){if((it=U.getRangeAt(0).cloneRange()).collapse(!0),it.setStart(U.focusNode,0),C=(A=it.toString().slice(0,it.endOffset)).split(Q.pattern).length-1,(k=A.match(Q.pattern))&&(O=A.slice(A.lastIndexOf(k[k.length-1]))),O){if(this.state.actions.ArrowLeft=!1,this.state.tag={prefix:O.match(Q.pattern)[0],value:O.replace(Q.pattern,"")},this.state.tag.baseOffset=U.baseOffset-this.state.tag.value.length,j=this.state.tag.value.match(Q.delimiters))return this.state.tag.value=this.state.tag.value.replace(Q.delimiters,""),this.state.tag.delimiters=j[0],this.addTags(this.state.tag.value,Q.dropdown.clearOnSelect),void this.dropdown.hide();L=this.state.tag.value.length>=Q.dropdown.enabled;try{_=(_=this.state.flaggedTags[this.state.tag.baseOffset]).prefix==this.state.tag.prefix&&_.value[0]==this.state.tag.value[0],this.state.flaggedTags[this.state.tag.baseOffset]&&!this.state.tag.value&&delete this.state.flaggedTags[this.state.tag.baseOffset]}catch(n){}(_||C<this.state.mixMode.matchedPatternCount)&&(L=!1)}else this.state.flaggedTags={};this.state.mixMode.matchedPatternCount=C}setTimeout((function(){Y.update({withoutChangeEvent:!0}),Y.trigger("input",u({},Y.state.tag,{textContent:Y.DOM.input.textContent})),Y.state.tag&&Y.dropdown[L?"show":"hide"](Y.state.tag.value)}),10)},onInputIE:function(n){var A=this;setTimeout((function(){A.events.callbacks.onInput.call(A,n)}))},observeOriginalInputValue:function(){this.DOM.originalInput.parentNode||this.destroy(),this.DOM.originalInput.value!=this.DOM.originalInput.tagifyValue&&this.loadOriginalValues()},onClickAnywhere:function(n){n.target==this.DOM.scope||this.DOM.scope.contains(n.target)||(this.toggleFocusClass(!1),this.state.hasFocus=!1,n.target.closest(".tagify__dropdown")&&n.target.closest(".tagify__dropdown").__tagify!=this&&this.dropdown.hide())},onClickScope:function(n){var A=this.settings,k=n.target.closest("."+A.classNames.tag),C=n.target===this.DOM.scope,O=+new Date-this.state.hasFocus;if(C&&"select"!=A.mode)this.DOM.input.focus();else{if(!n.target.classList.contains(A.classNames.tagX))return k&&!this.state.editing?(this.trigger("click",{tag:k,index:this.getNodeIndex(k),data:w(k),event:n}),void(1!==A.editTags&&1!==A.editTags.clicks&&"select"!=A.mode||this.events.callbacks.onDoubleClickScope.call(this,n))):void(n.target==this.DOM.input&&("mix"==A.mode&&this.fixFirefoxLastTagNoCaret(),O>500||!A.focusable)?this.state.dropdown.visible?this.dropdown.hide():0===A.dropdown.enabled&&"mix"!=A.mode&&this.dropdown.show(this.value.length?"":void 0):"select"!=A.mode||0!==A.dropdown.enabled||this.state.dropdown.visible||(this.events.callbacks.onDoubleClickScope.call(this,W(function(n){for(var A=1;A<arguments.length;A++){var k=null!=arguments[A]?arguments[A]:{},C=Object.keys(k);"function"==typeof Object.getOwnPropertySymbols&&(C=C.concat(Object.getOwnPropertySymbols(k).filter((function(n){return Object.getOwnPropertyDescriptor(k,n).enumerable})))),C.forEach((function(A){H(n,A,k[A])}))}return n}({},n),{target:this.getTagElms()[0]})),!A.userInput&&this.dropdown.show()));this.removeTags(n.target.parentNode)}},onPaste:function(n){var A=this;n.preventDefault();var k,C,O,L=this.settings;if("select"==L.mode&&L.enforceWhitelist||!L.userInput)return!1;L.readonly||(C=n.clipboardData||window.clipboardData,O=C.getData("Text"),L.hooks.beforePaste(n,{tagify:this,pastedText:O,clipboardData:C}).then((function(L){void 0===L&&(L=O),L&&(A.injectAtCaret(L,window.getSelection().getRangeAt(0)),"mix"==A.settings.mode?A.events.callbacks.onMixTagsInput.call(A,n):A.settings.pasteAsTags?k=A.addTags(A.state.inputText+L,!0):(A.state.inputText=L,A.dropdown.show(L))),A.trigger("paste",{event:n,pastedText:O,clipboardData:C,tagsElems:k})})).catch((function(n){return n})))},onDrop:function(n){n.preventDefault()},onEditTagInput:function(n,A){var k,C=n.closest("."+this.settings.classNames.tag),O=this.getNodeIndex(C),L=w(C),U=this.input.normalize.call(this,n),_=(H(k={},this.settings.tagTextProp,U),H(k,"__tagId",L.__tagId),k),j=this.validateTag(_);this.editTagChangeDetected(u(L,_))||!0!==n.originalIsValid||(j=!0),C.classList.toggle(this.settings.classNames.tagInvalid,!0!==j),L.__isValid=j,C.title=!0===j?L.title||L.value:j,U.length>=this.settings.dropdown.enabled&&(this.state.editing&&(this.state.editing.value=U),this.dropdown.show(U)),this.trigger("edit:input",{tag:C,index:O,data:u({},this.value[O],{newValue:U}),event:A})},onEditTagPaste:function(n,A){var k=(A.clipboardData||window.clipboardData).getData("Text");A.preventDefault();var C=b(k);this.setRangeAtStartEnd(!1,C)},onEditTagClick:function(n,A){this.events.callbacks.onClickScope.call(this,A)},onEditTagFocus:function(n){this.state.editing={scope:n,input:n.querySelector("[contenteditable]")}},onEditTagBlur:function(n,A){var k=m.call(this,A.relatedTarget);if("select"==this.settings.mode&&k&&A.relatedTarget.contains(A.target))this.dropdown.hide();else if(this.state.editing&&(this.state.hasFocus||this.toggleFocusClass(),this.DOM.scope.contains(n))){var C,O,L,U=this.settings,_=n.closest("."+U.classNames.tag),j=w(_),Y=this.input.normalize.call(this,n),Q=(H(C={},U.tagTextProp,Y),H(C,"__tagId",j.__tagId),C),Z=j.__originalData,tt=this.editTagChangeDetected(u(j,Q)),et=this.validateTag(Q);if(Y)if(tt){var it;if(O=this.hasMaxTags(),L=u({},Z,(H(it={},U.tagTextProp,this.trim(Y)),H(it,"__isValid",et),it)),U.transformTag.call(this,L,Z),!0!==(et=(!O||!0===Z.__isValid)&&this.validateTag(L))){if(this.trigger("invalid",{data:L,tag:_,message:et}),U.editTags.keepInvalid)return;U.keepInvalidTags?L.__isValid=et:L=Z}else U.keepInvalidTags&&(delete L.title,delete L["aria-invalid"],delete L.class);this.onEditTagDone(_,L)}else this.onEditTagDone(_,Z);else this.onEditTagDone(_)}},onEditTagkeydown:function(n,A){if(!this.state.composing)switch(this.trigger("edit:keydown",{event:n}),n.key){case"Esc":case"Escape":this.state.editing=!1,A.__tagifyTagData.__originalData.value?A.parentNode.replaceChild(A.__tagifyTagData.__originalHTML,A):A.remove();break;case"Enter":case"Tab":n.preventDefault(),setTimeout((function(){return n.target.blur()}),0)}},onDoubleClickScope:function(n){var A,k,C=n.target.closest("."+this.settings.classNames.tag),O=w(C),L=this.settings;C&&!1!==O.editable&&(A=C.classList.contains(this.settings.classNames.tagEditing),k=C.hasAttribute("readonly"),L.readonly||A||k||!this.settings.editTags||!L.userInput||(this.events.callbacks.onEditTagFocus.call(this,C),this.editTag(C)),this.toggleFocusClass(!0),"select"!=L.mode&&this.trigger("dblclick",{tag:C,index:this.getNodeIndex(C),data:w(C)}))},onInputDOMChange:function(n){var A=this;n.forEach((function(n){n.addedNodes.forEach((function(n){if("<div><br></div>"==n.outerHTML)n.replaceWith(document.createElement("br"));else if(1==n.nodeType&&n.querySelector(A.settings.classNames.tagSelector)){var k,C=document.createTextNode("");3==n.childNodes[0].nodeType&&"BR"!=n.previousSibling.nodeName&&(C=document.createTextNode("\n")),(k=n).replaceWith.apply(k,K([C].concat(K(K(n.childNodes).slice(0,-1))))),y(C)}else if(m.call(A,n)){var O;if(3!=(null===(O=n.previousSibling)||void 0===O?void 0:O.nodeType)||n.previousSibling.textContent||n.previousSibling.remove(),n.previousSibling&&"BR"==n.previousSibling.nodeName){n.previousSibling.replaceWith("\n​");for(var L=n.nextSibling,U="";L;)U+=L.textContent,L=L.nextSibling;U.trim()&&y(n.previousSibling)}else n.previousSibling&&!w(n.previousSibling)||n.before("​")}})),n.removedNodes.forEach((function(n){n&&"BR"==n.nodeName&&m.call(A,k)&&(A.removeTags(k),A.fixFirefoxLastTagNoCaret())}))}));var k=this.DOM.input.lastChild;k&&""==k.nodeValue&&k.remove(),k&&"BR"==k.nodeName||this.DOM.input.appendChild(document.createElement("br"))}}};function q(n,A){(null==A||A>n.length)&&(A=n.length);for(var k=0,C=new Array(A);k<A;k++)C[k]=n[k];return C}function z(n,A,k){return A in n?Object.defineProperty(n,A,{value:k,enumerable:!0,configurable:!0,writable:!0}):n[A]=k,n}function X(n,A){return null!=A&&"undefined"!=typeof Symbol&&A[Symbol.hasInstance]?!!A[Symbol.hasInstance](n):n instanceof A}function J(n){for(var A=1;A<arguments.length;A++){var k=null!=arguments[A]?arguments[A]:{},C=Object.keys(k);"function"==typeof Object.getOwnPropertySymbols&&(C=C.concat(Object.getOwnPropertySymbols(k).filter((function(n){return Object.getOwnPropertyDescriptor(k,n).enumerable})))),C.forEach((function(A){z(n,A,k[A])}))}return n}function G(n){return function(n){if(Array.isArray(n))return q(n)}(n)||function(n){if("undefined"!=typeof Symbol&&null!=n[Symbol.iterator]||null!=n["@@iterator"])return Array.from(n)}(n)||function(n,A){if(n){if("string"==typeof n)return q(n,A);var k=Object.prototype.toString.call(n).slice(8,-1);return"Object"===k&&n.constructor&&(k=n.constructor.name),"Map"===k||"Set"===k?Array.from(k):"Arguments"===k||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(k)?q(n,A):void 0}}(n)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function $(n,A){if(!n){lt.warn("input element not found",n);var k=new Proxy(this,{get:function(){return function(){return k}}});return k}if(n.__tagify)return lt.warn("input element is already Tagified - Same instance is returned.",n),n.__tagify;var C;u(this,function(n){var A=document.createTextNode(""),k={};function s(n,k,C){C&&k.split(/\s+/g).forEach((function(k){return A[n+"EventListener"].call(A,k,C)}))}return{removeAllCustomListeners:function(){Object.entries(k).forEach((function(n){var A=F(n,2),k=A[0];A[1].forEach((function(n){return s("remove",k,n)}))})),k={}},off:function(n,A){return n&&(A?s("remove",n,A):n.split(/\s+/g).forEach((function(n){var A;null===(A=k[n])||void 0===A||A.forEach((function(A){return s("remove",n,A)})),delete k[n]}))),this},on:function(n,A){return A&&"function"==typeof A&&(n.split(/\s+/g).forEach((function(n){Array.isArray(k[n])?k[n].push(A):k[n]=[A]})),s("add",n,A)),this},trigger:function(k,C,O){var L;if(O=O||{cloneData:!0},k)if(n.settings.isJQueryPlugin)"remove"==k&&(k="removeTag"),jQuery(n.DOM.originalInput).triggerHandler(k,[C]);else{try{var U="object"==typeof C?C:{value:C};if((U=O.cloneData?u({},U):U).tagify=this,C.event&&(U.event=this.cloneEvent(C.event)),V(C,Object))for(var _ in C)V(C[_],HTMLElement)&&(U[_]=C[_]);L=new CustomEvent(k,{detail:U})}catch(n){lt.warn(n)}A.dispatchEvent(L)}}}}(this)),this.isFirefox=/firefox|fxios/i.test(navigator.userAgent)&&!/seamonkey/i.test(navigator.userAgent),this.isIE=window.document.documentMode,A=A||{},this.getPersistedData=(C=A.id,function(n){var A,k="/"+n;if(1==localStorage.getItem(ht+C+"/v",1))try{A=JSON.parse(localStorage[ht+C+k])}catch(n){}return A}),this.setPersistedData=function(n){return n?(localStorage.setItem(ht+n+"/v",1),function(A,k){var C="/"+k,O=JSON.stringify(A);A&&k&&(localStorage.setItem(ht+n+C,O),dispatchEvent(new Event("storage")))}):function(){}}(A.id),this.clearPersistedData=function(n){return function(A){var k=ht+"/"+n+"/";if(A)localStorage.removeItem(k+A);else for(var C in localStorage)C.includes(k)&&localStorage.removeItem(C)}}(A.id),this.applySettings(n,A),this.state={inputText:"",editing:!1,composing:!1,actions:{},mixMode:{},dropdown:{},flaggedTags:{}},this.value=[],this.listeners={},this.DOM={},this.build(n),N.call(this),this.getCSSVars(),this.loadOriginalValues(),this.events.customBinding.call(this),this.events.binding.call(this),n.autofocus&&this.DOM.input.focus(),n.__tagify=this}$.prototype={_dropdown:gt,placeCaretAfterNode:y,getSetTagData:w,helpers:{sameStr:s,removeCollectionProp:a,omit:o,isObject:c,parseHTML:r,escapeHTML:d,extend:u,concatWithoutDups:g,getUID:f,isNodeTag:m},customEventsList:["change","add","remove","invalid","input","paste","click","keydown","focus","blur","edit:input","edit:beforeUpdate","edit:updated","edit:start","edit:keydown","dropdown:show","dropdown:hide","dropdown:select","dropdown:updated","dropdown:noMatch","dropdown:scroll"],dataProps:["__isValid","__removed","__originalData","__originalHTML","__tagId"],trim:function(n){return this.settings.trim&&n&&"string"==typeof n?n.trim():n},parseHTML:r,templates:mt,parseTemplate:function(n,A){return r((n=this.settings.templates[n]||n).apply(this,A))},set whitelist(n){var A=n&&Array.isArray(n);this.settings.whitelist=A?n:[],this.setPersistedData(A?n:[],"whitelist")},get whitelist(){return this.settings.whitelist},set userInput(n){this.settings.userInput=!!n,this.setContentEditable(!!n)},get userInput(){return this.settings.userInput},generateClassSelectors:function(n){var e=function(A){var k=A;Object.defineProperty(n,k+"Selector",{get:function(){return"."+this[k].split(" ")[0]}})};for(var A in n)e(A)},applySettings:function(n,A){var k,C;ct.templates=this.templates;var O=u({},ct,"mix"==A.mode?{dropdown:{position:"text"}}:{}),L=this.settings=u({},O,A);if(L.disabled=n.hasAttribute("disabled"),L.readonly=L.readonly||n.hasAttribute("readonly"),L.placeholder=d(n.getAttribute("placeholder")||L.placeholder||""),L.required=n.hasAttribute("required"),this.generateClassSelectors(L.classNames),void 0===L.dropdown.includeSelectedTags&&(L.dropdown.includeSelectedTags=L.duplicates),this.isIE&&(L.autoComplete=!1),["whitelist","blacklist"].forEach((function(A){var k=n.getAttribute("data-"+A);k&&X(k=k.split(L.delimiters),Array)&&(L[A]=k)})),"autoComplete"in A&&!c(A.autoComplete)&&(L.autoComplete=ct.autoComplete,L.autoComplete.enabled=A.autoComplete),"mix"==L.mode&&(L.pattern=L.pattern||/@/,L.autoComplete.rightKey=!0,L.delimiters=A.delimiters||null,L.tagTextProp&&!L.dropdown.searchKeys.includes(L.tagTextProp)&&L.dropdown.searchKeys.push(L.tagTextProp)),n.pattern)try{L.pattern=new RegExp(n.pattern)}catch(n){}if(L.delimiters){L._delimiters=L.delimiters;try{L.delimiters=new RegExp(this.settings.delimiters,"g")}catch(n){}}L.disabled&&(L.userInput=!1),this.TEXTS=J({},pt,L.texts||{}),("select"!=L.mode||(null===(k=A.dropdown)||void 0===k?void 0:k.enabled))&&L.userInput||(L.dropdown.enabled=0),L.dropdown.appendTarget=(null===(C=A.dropdown)||void 0===C?void 0:C.appendTarget)||document.body;var U=this.getPersistedData("whitelist");Array.isArray(U)&&(this.whitelist=Array.isArray(L.whitelist)?g(L.whitelist,U):U)},getAttributes:function(n){var A,k=this.getCustomAttributes(n),C="";for(A in k)C+=" "+A+(void 0!==n[A]?'="'.concat(k[A],'"'):"");return C},getCustomAttributes:function(n){if(!c(n))return"";var A,k={};for(A in n)"__"!=A.slice(0,2)&&"class"!=A&&n.hasOwnProperty(A)&&void 0!==n[A]&&(k[A]=d(n[A]));return k},setStateSelection:function(){var n=window.getSelection(),A={anchorOffset:n.anchorOffset,anchorNode:n.anchorNode,range:n.getRangeAt&&n.rangeCount&&n.getRangeAt(0)};return this.state.selection=A,A},getCSSVars:function(){var n,A,k,C=getComputedStyle(this.DOM.scope,null);this.CSSVars={tagHideTransition:(n=function(n){if(!n)return{};var A=(n=n.trim().split(" ")[0]).split(/\d+/g).filter((function(n){return n})).pop().trim();return{value:+n.split(A).filter((function(n){return n}))[0].trim(),unit:A}}((k="tag-hide-transition",C.getPropertyValue("--"+k))),A=n.value,"s"==n.unit?1e3*A:A)}},build:function(n){var A=this.DOM,k=n.closest("label");this.settings.mixMode.integrated?(A.originalInput=null,A.scope=n,A.input=n):(A.originalInput=n,A.originalInput_tabIndex=n.tabIndex,A.scope=this.parseTemplate("wrapper",[n,this.settings]),A.input=A.scope.querySelector(this.settings.classNames.inputSelector),n.parentNode.insertBefore(A.scope,n),n.tabIndex=-1),k&&k.setAttribute("for","")},destroy:function(){this.events.unbindGlobal.call(this),this.DOM.scope.parentNode.removeChild(this.DOM.scope),this.DOM.originalInput.tabIndex=this.DOM.originalInput_tabIndex,delete this.DOM.originalInput.__tagify,this.dropdown.hide(!0),this.removeAllCustomListeners(),clearTimeout(this.dropdownHide__bindEventsTimeout),clearInterval(this.listeners.main.originalInputValueObserverInterval)},loadOriginalValues:function(n){var A,k=this.settings;if(this.state.blockChangeEvent=!0,void 0===n){var C=this.getPersistedData("value");n=C&&!this.DOM.originalInput.value?C:k.mixMode.integrated?this.DOM.input.textContent:this.DOM.originalInput.value}if(this.removeAllTags(),n)if("mix"==k.mode)this.parseMixTags(n),(A=this.DOM.input.lastChild)&&"BR"==A.tagName||this.DOM.input.insertAdjacentHTML("beforeend","<br>");else{try{X(JSON.parse(n),Array)&&(n=JSON.parse(n))}catch(n){}this.addTags(n,!0).forEach((function(n){return n&&n.classList.add(k.classNames.tagNoAnimation)}))}else this.postUpdate();this.state.lastOriginalValueReported=k.mixMode.integrated?"":this.DOM.originalInput.value},cloneEvent:function(n){var A={};for(var k in n)"path"!=k&&(A[k]=n[k]);return A},loading:function(n){return this.state.isLoading=n,this.DOM.scope.classList[n?"add":"remove"](this.settings.classNames.scopeLoading),this},tagLoading:function(n,A){return n&&n.classList[A?"add":"remove"](this.settings.classNames.tagLoading),this},toggleClass:function(n,A){"string"==typeof n&&this.DOM.scope.classList.toggle(n,A)},toggleScopeValidation:function(n){var A=!0===n||void 0===n;!this.settings.required&&n&&n===this.TEXTS.empty&&(A=!0),this.toggleClass(this.settings.classNames.tagInvalid,!A),this.DOM.scope.title=A?"":n},toggleFocusClass:function(n){this.toggleClass(this.settings.classNames.focus,!!n)},setPlaceholder:function(n){var A=this;["data","aria"].forEach((function(k){return A.DOM.input.setAttribute("".concat(k,"-placeholder"),n)}))},triggerChangeEvent:function(){if(!this.settings.mixMode.integrated){var n=this.DOM.originalInput,A=this.state.lastOriginalValueReported!==n.value,k=new CustomEvent("change",{bubbles:!0});A&&(this.state.lastOriginalValueReported=n.value,k.simulated=!0,n._valueTracker&&n._valueTracker.setValue(Math.random()),n.dispatchEvent(k),this.trigger("change",this.state.lastOriginalValueReported),n.value=this.state.lastOriginalValueReported)}},events:ft,fixFirefoxLastTagNoCaret:function(){},setRangeAtStartEnd:function(n,A){if(A){n="number"==typeof n?n:!!n,A=A.lastChild||A;var k=document.getSelection();if(X(k.focusNode,Element)&&!this.DOM.input.contains(k.focusNode))return!0;try{k.rangeCount>=1&&["Start","End"].forEach((function(C){return k.getRangeAt(0)["set"+C](A,n||A.length)}))}catch(n){console.warn(n)}}},insertAfterTag:function(n,A){if(A=A||this.settings.mixMode.insertAfterTag,n&&n.parentNode&&A)return A="string"==typeof A?document.createTextNode(A):A,n.parentNode.insertBefore(A,n.nextSibling),A},editTagChangeDetected:function(n){var A=n.__originalData;for(var k in A)if(!this.dataProps.includes(k)&&n[k]!=A[k])return!0;return!1},getTagTextNode:function(n){return n.querySelector(this.settings.classNames.tagTextSelector)},setTagTextNode:function(n,A){this.getTagTextNode(n).innerHTML=d(A)},editTag:function(n,A){var k=this;n=n||this.getLastTag(),A=A||{};var C=this.settings,O=this.getTagTextNode(n),L=this.getNodeIndex(n),U=w(n),_=this.events.callbacks,j=!0,Y="select"==C.mode;if(!Y&&this.dropdown.hide(),O){if(!X(U,Object)||!("editable"in U)||U.editable)return U=w(n,{__originalData:u({},U),__originalHTML:n.cloneNode(!0)}),w(U.__originalHTML,U.__originalData),O.setAttribute("contenteditable",!0),n.classList.add(C.classNames.tagEditing),this.events.callbacks.onEditTagFocus.call(this,n),O.addEventListener("click",_.onEditTagClick.bind(this,n)),O.addEventListener("blur",_.onEditTagBlur.bind(this,this.getTagTextNode(n))),O.addEventListener("input",_.onEditTagInput.bind(this,O)),O.addEventListener("paste",_.onEditTagPaste.bind(this,O)),O.addEventListener("keydown",(function(A){return _.onEditTagkeydown.call(k,A,n)})),O.addEventListener("compositionstart",_.onCompositionStart.bind(this)),O.addEventListener("compositionend",_.onCompositionEnd.bind(this)),A.skipValidation||(j=this.editTagToggleValidity(n)),O.originalIsValid=j,this.trigger("edit:start",{tag:n,index:L,data:U,isValid:j}),O.focus(),!Y&&this.setRangeAtStartEnd(!1,O),0===C.dropdown.enabled&&!Y&&this.dropdown.show(),this.state.hasFocus=!0,this}else lt.warn("Cannot find element in Tag template: .",C.classNames.tagTextSelector)},editTagToggleValidity:function(n,A){var k;if(A=A||w(n))return(k=!("__isValid"in A)||!0===A.__isValid)||this.removeTagsFromValue(n),this.update(),n.classList.toggle(this.settings.classNames.tagNotAllowed,!k),A.__isValid=k,A.__isValid;lt.warn("tag has no data: ",n,A)},onEditTagDone:function(n,A){n=n||this.state.editing.scope,A=A||{};var k,C,O={tag:n,index:this.getNodeIndex(n),previousData:w(n),data:A},L=this.settings;this.trigger("edit:beforeUpdate",O,{cloneData:!1}),this.state.editing=!1,delete A.__originalData,delete A.__originalHTML,n&&(void 0!==(C=A[L.tagTextProp])?null===(k=(C+="").trim)||void 0===k?void 0:k.call(C):L.tagTextProp in A?void 0:A.value)?(n=this.replaceTag(n,A),this.editTagToggleValidity(n,A),L.a11y.focusableTags?n.focus():"select"!=L.mode&&y(n)):n&&this.removeTags(n),this.trigger("edit:updated",O),this.dropdown.hide(),this.settings.keepInvalidTags&&this.reCheckInvalidTags()},replaceTag:function(n,A){A&&""!==A.value&&void 0!==A.value||(A=n.__tagifyTagData),A.__isValid&&1!=A.__isValid&&u(A,this.getInvalidTagAttrs(A,A.__isValid));var k=this.createTagElem(A);return n.parentNode.replaceChild(k,n),this.updateValueByDOMTags(),k},updateValueByDOMTags:function(){var n=this;this.value.length=0;var A=this.settings.classNames,k=[A.tagNotAllowed.split(" ")[0],A.tagHide];[].forEach.call(this.getTagElms(),(function(A){G(A.classList).some((function(n){return k.includes(n)}))||n.value.push(w(A))})),this.update()},injectAtCaret:function(n,A){var k;if(A=A||(null===(k=this.state.selection)||void 0===k?void 0:k.range),"string"==typeof n&&(n=document.createTextNode(n)),!A&&n)return this.appendMixTags(n),this;var C=b(n,A);return this.setRangeAtStartEnd(!1,C),this.updateValueByDOMTags(),this.update(),this},input:{set:function(){var n=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"",A=!(arguments.length>1&&void 0!==arguments[1])||arguments[1],k=this.settings,C=k.dropdown.closeOnSelect;this.state.inputText=n,A&&(this.DOM.input.innerHTML=d(""+n),n&&this.toggleClass(k.classNames.empty,!this.DOM.input.innerHTML)),!n&&C&&this.dropdown.hide.bind(this),this.input.autocomplete.suggest.call(this),this.input.validate.call(this)},raw:function(){return this.DOM.input.textContent},validate:function(){var n=!this.state.inputText||!0===this.validateTag({value:this.state.inputText});return this.DOM.input.classList.toggle(this.settings.classNames.inputInvalid,!n),n},normalize:function(n,A){var k=n||this.DOM.input,C=[];k.childNodes.forEach((function(n){return 3==n.nodeType&&C.push(n.nodeValue)})),C=C.join("\n");try{C=C.replace(/(?:\r\n|\r|\n)/g,this.settings.delimiters.source.charAt(0))}catch(n){}return C=C.replace(/\s/g," "),(null==A?void 0:A.trim)?this.trim(C):C},autocomplete:{suggest:function(n){if(this.settings.autoComplete.enabled){"object"!=typeof(n=n||{value:""})&&(n={value:n});var A=this.dropdown.getMappedValue(n);if("number"!=typeof A){var k=this.state.inputText.toLowerCase(),C=A.substr(0,this.state.inputText.length).toLowerCase(),O=A.substring(this.state.inputText.length);A&&this.state.inputText&&C==k?(this.DOM.input.setAttribute("data-suggest",O),this.state.inputSuggestion=n):(this.DOM.input.removeAttribute("data-suggest"),delete this.state.inputSuggestion)}}},set:function(n){var A=this.DOM.input.getAttribute("data-suggest"),k=n||(A?this.state.inputText+A:null);return!!k&&("mix"==this.settings.mode?this.replaceTextWithNode(document.createTextNode(this.state.tag.prefix+k)):(this.input.set.call(this,k),this.setRangeAtStartEnd(!1,this.DOM.input)),this.input.autocomplete.suggest.call(this),this.dropdown.hide(),!0)}}},getTagIdx:function(n){return this.value.findIndex((function(A){return A.__tagId==(n||{}).__tagId}))},getNodeIndex:function(n){var A=0;if(n)for(;n=n.previousElementSibling;)A++;return A},getTagElms:function(){for(var n=arguments.length,A=new Array(n),k=0;k<n;k++)A[k]=arguments[k];var C="."+G(this.settings.classNames.tag.split(" ")).concat(G(A)).join(".");return[].slice.call(this.DOM.scope.querySelectorAll(C))},getLastTag:function(){var n=this.settings.classNames,A=this.DOM.scope.querySelectorAll("".concat(n.tagSelector,":not(.").concat(n.tagHide,"):not([readonly])"));return A[A.length-1]},isTagDuplicate:function(n,A,k){var C=0,O=!0,L=!1,U=void 0;try{for(var _,j=this.value[Symbol.iterator]();!(O=(_=j.next()).done);O=!0){var Y=_.value;s(this.trim(""+n),Y.value,A)&&k!=Y.__tagId&&C++}}catch(n){L=!0,U=n}finally{try{O||null==j.return||j.return()}finally{if(L)throw U}}return C},getTagIndexByValue:function(n){var A=this,k=[],C=this.settings.dropdown.caseSensitive;return this.getTagElms().forEach((function(O,L){O.__tagifyTagData&&s(A.trim(O.__tagifyTagData.value),n,C)&&k.push(L)})),k},getTagElmByValue:function(n){var A=this.getTagIndexByValue(n)[0];return this.getTagElms()[A]},flashTag:function(n){var A=this;n&&(n.classList.add(this.settings.classNames.tagFlash),setTimeout((function(){n.classList.remove(A.settings.classNames.tagFlash)}),100))},isTagBlacklisted:function(n){return n=this.trim(n.toLowerCase()),this.settings.blacklist.filter((function(A){return(""+A).toLowerCase()==n})).length},isTagWhitelisted:function(n){return!!this.getWhitelistItem(n)},getWhitelistItem:function(n,A,k){A=A||"value";var C,O=this.settings;return(k=k||O.whitelist).some((function(k){var L="object"==typeof k?k[A]||k.value:k;if(s(L,n,O.dropdown.caseSensitive,O.trim))return C="object"==typeof k?k:{value:k},!0})),C||"value"!=A||"value"==O.tagTextProp||(C=this.getWhitelistItem(n,O.tagTextProp,k)),C},validateTag:function(n){var A=this.settings,k="value"in n?"value":A.tagTextProp,C=this.trim(n[k]+"");return(n[k]+"").trim()?"mix"!=A.mode&&A.pattern&&X(A.pattern,RegExp)&&!A.pattern.test(C)?this.TEXTS.pattern:!A.duplicates&&this.isTagDuplicate(C,A.dropdown.caseSensitive,n.__tagId)?this.TEXTS.duplicate:this.isTagBlacklisted(C)||A.enforceWhitelist&&!this.isTagWhitelisted(C)?this.TEXTS.notAllowed:!A.validate||A.validate(n):this.TEXTS.empty},getInvalidTagAttrs:function(n,A){return{"aria-invalid":!0,class:"".concat(n.class||""," ").concat(this.settings.classNames.tagNotAllowed).trim(),title:A}},hasMaxTags:function(){return this.value.length>=this.settings.maxTags&&this.TEXTS.exceed},setReadonly:function(n,A){var k=this.settings;this.DOM.scope.contains(document.activeElement)&&document.activeElement.blur(),k[A||"readonly"]=n,this.DOM.scope[(n?"set":"remove")+"Attribute"](A||"readonly",!0),this.settings.userInput=!0,this.setContentEditable(!n)},setContentEditable:function(n){this.DOM.input.contentEditable=n,this.DOM.input.tabIndex=n?0:-1},setDisabled:function(n){this.setReadonly(n,"disabled")},normalizeTags:function(n){var A=this,k=this.settings,C=k.whitelist,O=k.delimiters,L=k.mode,U=k.tagTextProp,_=[],j=!!C&&X(C[0],Object),Y=Array.isArray(n),Q=Y&&n[0].value,h=function(n){return(n+"").split(O).reduce((function(n,k){var C,O=A.trim(k);return O&&n.push((z(C={},U,O),z(C,"value",O),C)),n}),[])};if("number"==typeof n&&(n=n.toString()),"string"==typeof n){if(!n.trim())return[];n=h(n)}else Y&&(n=n.reduce((function(n,k){if(c(k)){var C=u({},k);U in C||(U="value"),C[U]=A.trim(C[U]),(C[U]||0===C[U])&&n.push(C)}else if(k){var O;(O=n).push.apply(O,G(h(k)))}return n}),[]));return j&&!Q&&(n.forEach((function(n){var k=_.map((function(n){return n.value})),C=A.dropdown.filterListItems.call(A,n[U],{exact:!0});A.settings.duplicates||(C=C.filter((function(n){return!k.includes(n.value)})));var O=C.length>1?A.getWhitelistItem(n[U],U,C):C[0];O&&X(O,Object)?_.push(O):"mix"!=L&&(null==n.value&&(n.value=n[U]),_.push(n))})),_.length&&(n=_)),n},parseMixTags:function(n){var A=this,k=this.settings,C=k.mixTagsInterpolator,O=k.duplicates,L=k.transformTag,U=k.enforceWhitelist,_=k.maxTags,j=k.tagTextProp,Y=[];n=n.split(C[0]).map((function(n,k){var Q,Z,tt,et=n.split(C[1]),it=et[0],st=Y.length==_;try{if(it==+it)throw Error;Z=JSON.parse(it)}catch(n){Z=A.normalizeTags(it)[0]||{value:it}}if(L.call(A,Z),st||!(et.length>1)||U&&!A.isTagWhitelisted(Z.value)||!O&&A.isTagDuplicate(Z.value)){if(n)return k?C[0]+n:n}else Z[Q=Z[j]?j:"value"]=A.trim(Z[Q]),tt=A.createTagElem(Z),Y.push(Z),tt.classList.add(A.settings.classNames.tagNoAnimation),et[0]=tt.outerHTML,A.value.push(Z);return et.join("")})).join(""),this.DOM.input.innerHTML=n,this.DOM.input.appendChild(document.createTextNode("")),this.DOM.input.normalize();var Q=this.getTagElms();return Q.forEach((function(n,A){return w(n,Y[A])})),this.update({withoutChangeEvent:!0}),T(Q,this.state.hasFocus),n},replaceTextWithNode:function(n,A){if(this.state.tag||A){A=A||this.state.tag.prefix+this.state.tag.value;var k,C,O=this.state.selection||window.getSelection(),L=O.anchorNode,U=this.state.tag.delimiters?this.state.tag.delimiters.length:0;return L.splitText(O.anchorOffset-U),-1==(k=L.nodeValue.lastIndexOf(A))||(C=L.splitText(k),n&&L.parentNode.replaceChild(n,C)),!0}},prepareNewTagNode:function(n,A){A=A||{};var k=this.settings,C=[],O={},L=Object.assign({},n,{value:n.value+""});if(n=Object.assign({},L),k.transformTag.call(this,n),n.__isValid=this.hasMaxTags()||this.validateTag(n),!0!==n.__isValid){if(A.skipInvalid)return;if(u(O,this.getInvalidTagAttrs(n,n.__isValid),{__preInvalidData:L}),n.__isValid==this.TEXTS.duplicate&&this.flashTag(this.getTagElmByValue(n.value)),!k.createInvalidTags)return void C.push(n.value)}return"readonly"in n&&(n.readonly?O["aria-readonly"]=!0:delete n.readonly),{tagElm:this.createTagElem(n,O),tagData:n,aggregatedInvalidInput:C}},postProcessNewTagNode:function(n,A){var k=this,C=this.settings,O=A.__isValid;O&&!0===O?this.value.push(A):(this.trigger("invalid",{data:A,index:this.value.length,tag:n,message:O}),C.keepInvalidTags||setTimeout((function(){return k.removeTags(n,!0)}),1e3)),this.dropdown.position()},selectTag:function(n,A){var k=this;if(!this.settings.enforceWhitelist||this.isTagWhitelisted(A.value)){this.state.actions.selectOption&&setTimeout((function(){return k.setRangeAtStartEnd(!1,k.DOM.input)}));var C=this.getLastTag();return C?this.replaceTag(C,A):this.appendTag(n),this.value[0]=A,this.update(),this.trigger("add",{tag:n,data:A}),[n]}},addEmptyTag:function(n){var A=u({value:""},n||{}),k=this.createTagElem(A);w(k,A),this.appendTag(k),this.editTag(k,{skipValidation:!0}),this.toggleFocusClass(!0)},addTags:function(n,A,k){var C=this,O=[],L=this.settings,U=[],_=document.createDocumentFragment(),j=[];if(!n||0==n.length)return O;switch(n=this.normalizeTags(n),L.mode){case"mix":return this.addMixTags(n);case"select":A=!1,this.removeAllTags()}return this.DOM.input.removeAttribute("style"),n.forEach((function(n){var A=C.prepareNewTagNode(n,{skipInvalid:k||L.skipInvalid});if(A){var Y=A.tagElm;if(n=A.tagData,U=A.aggregatedInvalidInput,O.push(Y),"select"==L.mode)return C.selectTag(Y,n);_.appendChild(Y),C.postProcessNewTagNode(Y,n),j.push({tagElm:Y,tagData:n})}})),this.appendTag(_),j.forEach((function(n){var A=n.tagElm,k=n.tagData;return C.trigger("add",{tag:A,index:C.getTagIdx(k),data:k})})),this.update(),n.length&&A&&(this.input.set.call(this,L.createInvalidTags?"":U.join(L._delimiters)),this.setRangeAtStartEnd(!1,this.DOM.input)),this.dropdown.refilter(),O},addMixTags:function(n){var A=this;if((n=this.normalizeTags(n))[0].prefix||this.state.tag)return this.prefixedTextToTag(n[0]);var k=document.createDocumentFragment();return n.forEach((function(n){var C=A.prepareNewTagNode(n);k.appendChild(C.tagElm),A.insertAfterTag(C.tagElm),A.postProcessNewTagNode(C.tagElm,C.tagData)})),this.appendMixTags(k),k.children},appendMixTags:function(n){var A=!!this.state.selection;A?this.injectAtCaret(n):(this.DOM.input.focus(),(A=this.setStateSelection()).range.setStart(this.DOM.input,A.range.endOffset),A.range.setEnd(this.DOM.input,A.range.endOffset),this.DOM.input.appendChild(n),this.updateValueByDOMTags(),this.update())},prefixedTextToTag:function(n){var A,k,C,O=this,L=this.settings,U=null===(A=this.state.tag)||void 0===A?void 0:A.delimiters;if(n.prefix=n.prefix||this.state.tag?this.state.tag.prefix:(L.pattern.source||L.pattern)[0],C=this.prepareNewTagNode(n),k=C.tagElm,this.replaceTextWithNode(k)||this.DOM.input.appendChild(k),setTimeout((function(){return k.classList.add(O.settings.classNames.tagNoAnimation)}),300),this.update(),!U){var _=this.insertAfterTag(k)||k;setTimeout(y,0,_)}return this.state.tag=null,this.postProcessNewTagNode(k,C.tagData),k},appendTag:function(n){var A=this.DOM,k=A.input;A.scope.insertBefore(n,k)},createTagElem:function(n,A){n.__tagId=f();var k,C=u({},n,J({value:d(n.value+"")},A));return function(n){for(var A,k=document.createNodeIterator(n,NodeFilter.SHOW_TEXT,null,!1);A=k.nextNode();)A.textContent.trim()||A.parentNode.removeChild(A)}(k=this.parseTemplate("tag",[C,this])),w(k,n),k},reCheckInvalidTags:function(){var n=this,A=this.settings;this.getTagElms(A.classNames.tagNotAllowed).forEach((function(k,C){var O=w(k),L=n.hasMaxTags(),U=n.validateTag(O),_=!0===U&&!L;if("select"==A.mode&&n.toggleScopeValidation(U),_)return O=O.__preInvalidData?O.__preInvalidData:{value:O.value},n.replaceTag(k,O);k.title=L||U}))},removeTags:function(n,A,k){var C,O=this,L=this.settings;if(n=n&&X(n,HTMLElement)?[n]:X(n,Array)?n:n?[n]:[this.getLastTag()].filter((function(n){return n})),C=n.reduce((function(n,A){A&&"string"==typeof A&&(A=O.getTagElmByValue(A));var k=w(A);return A&&k&&!k.readonly&&n.push({node:A,idx:O.getTagIdx(k),data:w(A,{__removed:!0})}),n}),[]),k="number"==typeof k?k:this.CSSVars.tagHideTransition,"select"==L.mode&&(k=0,this.input.set.call(this)),1==C.length&&"select"!=L.mode&&C[0].node.classList.contains(L.classNames.tagNotAllowed)&&(A=!0),C.length)return L.hooks.beforeRemoveTag(C,{tagify:this}).then((function(){var t=function(n){n.node.parentNode&&(n.node.parentNode.removeChild(n.node),A?L.keepInvalidTags&&this.trigger("remove",{tag:n.node,index:n.idx}):(this.trigger("remove",{tag:n.node,index:n.idx,data:n.data}),this.dropdown.refilter(),this.dropdown.position(),this.DOM.input.normalize(),L.keepInvalidTags&&this.reCheckInvalidTags()))};k&&k>10&&1==C.length?function(n){n.node.style.width=parseFloat(window.getComputedStyle(n.node).width)+"px",document.body.clientTop,n.node.classList.add(L.classNames.tagHide),setTimeout(t.bind(this),k,n)}.call(O,C[0]):C.forEach(t.bind(O)),A||(O.removeTagsFromValue(C.map((function(n){return n.node}))),O.update(),"select"==L.mode&&L.userInput&&O.setContentEditable(!0))})).catch((function(n){}))},removeTagsFromDOM:function(){this.getTagElms().forEach((function(n){return n.remove()}))},removeTagsFromValue:function(n){var A=this;(n=Array.isArray(n)?n:[n]).forEach((function(n){var k=w(n),C=A.getTagIdx(k);C>-1&&A.value.splice(C,1)}))},removeAllTags:function(n){var A=this;n=n||{},this.value=[],"mix"==this.settings.mode?this.DOM.input.innerHTML="":this.removeTagsFromDOM(),this.dropdown.refilter(),this.dropdown.position(),this.state.dropdown.visible&&setTimeout((function(){A.DOM.input.focus()})),"select"==this.settings.mode&&(this.input.set.call(this),this.settings.userInput&&this.setContentEditable(!0)),this.update(n)},postUpdate:function(){this.state.blockChangeEvent=!1;var n,A,k=this.settings,C=k.classNames,O="mix"==k.mode?k.mixMode.integrated?this.DOM.input.textContent:this.DOM.originalInput.value.trim():this.value.length+this.input.raw.call(this).length;this.toggleClass(C.hasMaxTags,this.value.length>=k.maxTags),this.toggleClass(C.hasNoTags,!this.value.length),this.toggleClass(C.empty,!O),"select"==k.mode&&this.toggleScopeValidation(null===(A=this.value)||void 0===A||null===(n=A[0])||void 0===n?void 0:n.__isValid)},setOriginalInputValue:function(n){var A=this.DOM.originalInput;this.settings.mixMode.integrated||(A.value=n,A.tagifyValue=A.value,this.setPersistedData(n,"value"))},update:function(n){clearTimeout(this.debouncedUpdateTimeout),this.debouncedUpdateTimeout=setTimeout(function(){var A=this.getInputValue();this.setOriginalInputValue(A),this.settings.onChangeAfterBlur&&(n||{}).withoutChangeEvent||this.state.blockChangeEvent||this.triggerChangeEvent(),this.postUpdate()}.bind(this),100),this.events.bindOriginaInputListener.call(this,100)},getInputValue:function(){var n=this.getCleanValue();return"mix"==this.settings.mode?this.getMixedTagsAsString(n):n.length?this.settings.originalInputValueFormat?this.settings.originalInputValueFormat(n):JSON.stringify(n):""},getCleanValue:function(n){return a(n||this.value,this.dataProps)},getMixedTagsAsString:function(){var n="",A=this,k=this.settings,C=k.originalInputValueFormat||JSON.stringify,O=k.mixTagsInterpolator;return function i(k){k.childNodes.forEach((function(k){if(1==k.nodeType){var L=w(k);if("BR"==k.tagName&&(n+="\r\n"),L&&m.call(A,k)){if(L.__removed)return;n+=O[0]+C(o(L,A.dataProps))+O[1]}else k.getAttribute("style")||["B","I","U"].includes(k.tagName)?n+=k.textContent:"DIV"!=k.tagName&&"P"!=k.tagName||(n+="\r\n",i(k))}else n+=k.textContent}))}(this.DOM.input),n}},$.prototype.removeTag=$.prototype.removeTags;const{ApplicationV2:yt,HandlebarsApplicationMixin:vt}=foundry.applications.api;class TagifyApp extends(vt(yt)){constructor(n){super(n),this.tagify=null,this.dragSort=null,this.content=n.content,this.submit=n.submit,this.categoryId=null,this.subcategoryId=null,this.options.window.title=n.title}static DEFAULT_OPTIONS={actions:{resetActions:TagifyApp.resetActions,unselectAllTags:TagifyApp.unselectAllTags},classes:[`${n.ID}-app`,"tah-dialog","sheet"],id:"token-action-hud-dialog",form:{closeOnSubmit:!0,handler:TagifyApp.submit},position:{width:600,height:800},tag:"form",window:{minimizable:!0,resizable:!0}};async _prepareContext(){return this.content}static open(n,A,k,C,O){this.nestId=A,TagifyApp.#S(k);const L={title:C.title,content:C.content,submit:O};let U;switch(n){case"hud":U=new TagifyAppHud(L);break;case"topLevelGroup":U=new TagifyAppGroup(L);break;case"group":U=new TagifyAppSubgroup(L)}U.render(!0)}static#S(n){Hooks.once("renderTagifyApp",((A,k,C)=>{const O=k.querySelector('input[class="tah-dialog-tagify"]');if(O){const L={delimiters:";",maxTags:"Infinity",dropdown:{position:"manual",maxItems:1/0,classname:"tah-dialog-tags-dropdown",enabled:0},templates:{dropdownItemNoMatch:()=>"<div class='empty'>Nothing Found</div>"}};function onDragEnd(){TagifyApp.tagify.updateValueByDOMTags()}n.available&&(L.whitelist=n.available),TagifyApp.tagify=new $(O,L),n.selected&&TagifyApp.tagify.addTags(n.selected),TagifyApp.dragSort=new at(TagifyApp.tagify.DOM.scope,{selector:`.${TagifyApp.tagify.settings.classNames.tag}`,callbacks:{dragEnd:onDragEnd}});const U=k.querySelector(".tagify__input");if(U&&U.addEventListener("keydown",(n=>{"Enter"===n.key&&(n.preventDefault(),TagifyApp.tagify.addTags(TagifyApp.tagify.state.inputText,!0))})),"TagifyAppHud"===A.constructor.name)return;TagifyApp.tagify.dropdown.show();const _=document.createElement("div");_.classList.add("tah-dialog-label"),_.innerHTML=game.i18n.localize("tokenActionHud.form.hud.availableItems"),TagifyApp.tagify.DOM.scope.parentNode.appendChild(_),TagifyApp.tagify.DOM.scope.parentNode.appendChild(TagifyApp.tagify.DOM.dropdown)}}))}static async resetActions(){await foundry.applications.api.DialogV2.confirm({window:{title:game.i18n.localize("tokenActionHud.dialog.resetActions.title")},content:`<p>${game.i18n.localize("tokenActionHud.dialog.resetActions.content")}</p>`,modal:!0,yes:{label:game.i18n.localize("tokenActionHud.dialog.button.yes"),callback:async()=>{await game.tokenActionHud.resetActorData(),et.info("Actions reset",!0)}},no:{label:game.i18n.localize("tokenActionHud.dialog.button.no")}})}static unselectAllTags(){TagifyApp.tagify.removeAllTags()}_onKeyDown(n){if("Escape"===n.key&&!n.target.className.includes("tagify"))return n.preventDefault(),n.stopPropagation(),this.close();if("Enter"===n.key&&this.data.default&&!n.target.className.includes("tagify")){n.preventDefault(),n.stopPropagation();const A=this.data.buttons[this.data.default];return this.submit(A)}}static async submit(n,A,k){const C=TagifyApp.tagify.value.map((n=>(n.id=n.id??n.value.slugify({replacement:"-",strict:!0}),{id:n.id,listName:n.value,name:n.name??n.value,type:n.type})));await this.submit(C,k.object)}}class TagifyAppHud extends TagifyApp{static PARTS={form:{template:k.tagifyAppHud}}}class TagifyAppGroup extends TagifyApp{static PARTS={form:{template:k.tagifyAppGroup}}}class TagifyAppSubgroup extends TagifyApp{static PARTS={form:{template:k.tagifyAppSubgroup}}}class TagifyAppHelper{static async openEditHudApp(n){const A={available:[]};A.selected=await n.getSelectedGroupsAsTags();const k=await Utils.getSetting("grid"),C={title:game.i18n.localize("tokenActionHud.form.hud.hudTitle"),content:{topLabel:game.i18n.localize("tokenActionHud.form.hud.hudDetail"),placeholder:game.i18n.localize("tokenActionHud.form.hud.tagPlaceholder"),settings:{grid:k}}},dialogSubmit=async(A,k)=>{const C=k?.grid;await n.updateGroups(A,{level:0}),await n.saveGroups({saveActor:!0,saveUser:!0}),await Utils.setSetting("grid",C),Hooks.callAll("forceUpdateTokenActionHud")};TagifyApp.open("hud",null,A,C,dialogSubmit)}static async openEditGroupApp(n,A){const{nestId:k,name:C,level:O}=A,L={};L.available=await n.getAvailableGroupAsTags({nestId:k,level:O}),L.selected=await n.getSelectedGroupsAsTags({nestId:k,level:O});const U={title:`${game.i18n.localize("tokenActionHud.form.hud.groupTitle")}: ${C}`,content:{topLabel:game.i18n.localize("tokenActionHud.form.hud.groupDetail"),placeholder:game.i18n.localize("tokenActionHud.form.hud.tagPlaceholder"),settings:await n.getGroupSettings(A)}},dialogSubmit=async(k,C)=>{k=k.map((n=>(n.id=n.id??n.name.slugify({replacement:"-",strict:!0}),n.type=n.type??"custom",{id:n.id,listName:n.listName,name:n.name,type:n.type})));const O=C?.characterCount,L=C?.customWidth,U=C?.grid,_=C?.image,j=C?.showTitle,Y=C?.sort;A.settings={characterCount:O,customWidth:L,grid:U,image:_,showTitle:j,sort:Y},await n.updateGroups(k,A),await n.saveGroups({saveActor:!0,saveUser:!0}),Hooks.callAll("forceUpdateTokenActionHud")};TagifyApp.open("topLevelGroup",k,L,U,dialogSubmit)}static async openEditSubgroupApp(n,A,k){const{nestId:C,name:O,level:L}=k,U={},_=await A.getAvailableActionsAsTags(k),j=await n.getAvailableGroupAsTags({nestId:C,level:L});U.available=[..._,...j];const Y=await A.getSelectedActionsAsTags(k),Q=await n.getSelectedGroupsAsTags({nestId:C,level:L});U.selected=[...Y,...Q];const Z={title:`${game.i18n.localize("tokenActionHud.form.hud.groupTitle")}: ${O} `,content:{topLabel:game.i18n.localize("tokenActionHud.form.hud.groupDetail"),placeholder:game.i18n.localize("tokenActionHud.form.hud.tagPlaceholder"),settings:await n.getGroupSettings(k)}},dialogSubmit=async(C,O)=>{const L=[],U=[];for(const n of C)"action"===n.type?U.push(n):L.push(n);const _=O?.characterCount,j=O?.collapse,Y=O?.customWidth,Q=O?.grid,Z=O?.image,tt=O?.showTitle,et=O?.sort,it=O?._style;k.settings={characterCount:_,collapse:j,customWidth:Y,grid:Q,image:Z,showTitle:tt,sort:et,style:it},await n.updateGroups(L,k),await A.updateActions(U,k),await n.saveGroups({saveActor:!0,saveUser:!0}),Hooks.callAll("forceUpdateTokenActionHud")};TagifyApp.open("group",C,U,Z,dialogSubmit)}}class GroupResizer{constructor(n,A){this.tokenActionHud=n,this.hudManager=A,this.groupHandler=A.groupHandler,this.minCols=3,this.isCustomWidth=!1,this.settings=null,this.spacing=10}async resizeGroup(n){n&&(await this.#C(n),this.subgroupsElement&&(this.tokenActionHud.isDocked||await this.#D(),await this.#I(),this.#E()))}async#C(n){this.#E(),this.groupElement=n,await this.#x(),this.subgroupsElement&&(this.#M(),this.#O())}#E(){this.actionsElements=null,this.availableHeight=null,this.availableWidth=null,this.gridWidth=null,this.groupElement=null,this.subgroupElementArr=null,this.subgroupsElement=null,this.subgroupsElementPadding=null,this.subgroupsElementRect=null,this.isCustomWidth=!1,this.minCols=3,this.settings=null,this.spacing=10}#M(){const n=this.groupElement.closest('[data-part="group"]'),A=n.querySelectorAll(".tah-subgroups"),k={maxHeight:"",overflowY:""};this.#L(A,k)}async#P(){const n={display:"",gridTemplateColumns:"",width:""};await this.#L(this.actionsElements,n);const A=[],k=[];for(const n of this.actionsElements){const C=n.querySelectorAll(".tah-action:not(.shrink)");for(const n of C){const C=n.getBoundingClientRect(),O=Math.round(parseFloat(C.width)+1||0),L=n.querySelector(".tah-action-button-text"),U=L?.getBoundingClientRect(),_=Math.round(parseFloat(U?.width)||0);k.push(O),A.push({actionWidth:O,actionButtonTextWidth:_})}}let C=Math.ceil(Utils.getUpperQuartileAverage(k));const O=30;for(const n of A){const A=C-(n.actionWidth-n.actionButtonTextWidth);A<O&&(C=C-A+O)}this.gridWidth=C}async#N(n,A){if(!n)return;const k={display:"",gridTemplateColumns:"",width:""};await this.#F(n,k);const C=n.querySelectorAll(".tah-action"),O=Math.ceil(Math.sqrt(C.length)),L=A??this.availableWidth,U=Math.floor(L/this.gridWidth),_=O>U||A?U:C.length<=this.minCols?C.length:O,j={display:"grid",gridTemplateColumns:`repeat(${_}, ${this.gridWidth}px)`};await this.#F(n,j)}async#U(n,A){if(!n)return;let k=500;if(this.isCustomWidth)k=this.availableWidth;else if(A)k=A;else{const A=n.querySelectorAll(".tah-action");if(!A.length)return;const C=Math.ceil(Math.sqrt(A.length));let O=1,L=0,U=0;A.length>0&&A.forEach(((n,k)=>{(k+1)/C>O&&(U-=5,L=U>L?U:L,U=0,O++);const _=n.getBoundingClientRect(),j=Math.ceil(parseFloat(_.width)+1||0);U+=j,k+1===A.length&&(U-=5,L=U>L?U:L)})),L+=this.subgroupsElementPadding,k=L<this.availableWidth&&A.length>3?L:this.availableWidth,k<200&&(k=200)}const C={maxWidth:`${k}px`};await this.#F(n,C)}#G(){const n=this.settings?.customWidth;if(n)return this.isCustomWidth=!0,n;const A=canvas.screenDimensions[0]||window.innerWidth,k=this.subgroupsElementRect.left,C=document.querySelector("#ui-right"),O=C.clientWidth;return Math.floor((O>0?A-O:A)-this.spacing-k)}async#x(){this.subgroupsElement=this.groupElement.querySelector('[data-part="subgroups"]'),this.subgroupsElement&&(this.subgroupsElementRect=this.subgroupsElement.getBoundingClientRect(),this.subgroupsElementComputed=getComputedStyle(this.subgroupsElement),this.subgroupsElementPadding=Math.ceil(parseFloat(this.subgroupsElementComputed.paddingLeft)||0)+Math.ceil(parseFloat(this.subgroupsElementComputed.paddingRight)||0))}#O(){this.subgroupElementArr=this.groupElement.querySelectorAll('[data-part="subgroup"]'),0===this.subgroupElementArr.length&&(this.subgroupElementArr=[this.groupElement])}async#D(){if(this.actionsElements=this.groupElement.querySelectorAll('[data-part="actions"]'),0===this.actionsElements.length)return;const n=this.groupElement.dataset.nestId;this.settings=await this.groupHandler.getGroupSettings({nestId:n,level:1}),this.availableWidth=this.#G();let A=!1;for(const n of this.subgroupElementArr){const k=n.querySelector('[data-part="actions"]');if(!k)continue;const C=n.dataset.nestId,O=await this.groupHandler.getGroupSettings({nestId:C}),L=O.customWidth,U=Utils.getSetting("grid")||this.settings?.grid||O?.grid||k.style.display;U?(A||(await this.#P(),A=!0),await this.#N(k,L)):await this.#U(k,L)}}async#I(){await new Promise((n=>{requestAnimationFrame((()=>{this.availableHeight=this.#_();const A={maxHeight:`${this.availableHeight}px`,overflowY:"auto"};Object.assign(this.subgroupsElement.style,A),n()}))}))}#_(){const n=canvas.screenDimensions[1]||window.innerHeight,A=this.subgroupsElementRect.bottom,k=this.subgroupsElementRect.top;let C=null;if(this.tokenActionHud.isDocked){let A=0,C=this.groupElement.nextElementSibling;if(C){const n=[C];for(;C;)C=C.nextElementSibling,C&&n.push(C);for(const k of n){const n=k.getBoundingClientRect().height;A+=n??0}}return Math.max(n-k-A-this.spacing,100)}C="down"===this.tokenActionHud.direction?foundry.utils.isNewerVersion(game.version,"12.999")?document.querySelector("#hotbar"):document.querySelector("#ui-bottom"):foundry.utils.isNewerVersion(game.version,"12.999")?document.querySelector("scene-navigation-active"):document.querySelector("#ui-top");const O=C?.offsetHeight??0,L="down"===this.tokenActionHud.direction?n-k-O-this.spacing:A-O-this.spacing;return Math.max(L,100)}async#F(n,A){n&&requestAnimationFrame((()=>{Object.assign(n.style,A)}))}async#L(n,A){for(const k of n)Object.assign(k.style,A)}}const{ApplicationV2:bt,HandlebarsApplicationMixin:At}=foundry.applications.api;class TokenActionHud extends(At(bt)){constructor(n,A,k){super(),this.systemManager=n,this.dataHandler=A,this.hudManager=new HudManager(this,n,A,k),this.socket=k,this.openGroups=new Set,this.updatePendingTimer=new Timer(10),this.updateTimer=new Timer(10),this.closeTimer=null,this.renderTimer=null,this.setting={}}static DEFAULT_OPTIONS={actions:{clickGroup:{buttons:[0,2],handler:TokenActionHud.clickGroup},clickSubgroup:{buttons:[0,2],handler:TokenActionHud.clickSubgroup},clickAction:{buttons:[0,2],handler:TokenActionHud.clickAction},collapseHud:TokenActionHud.collapseHud,expandHud:TokenActionHud.expandHud,lockHud:TokenActionHud.lockHud,unlockHud:TokenActionHud.unlockHud,editHud:TokenActionHud.editHud},background:"none",id:"token-action-hud-app",position:{width:Y.DEFAULT_WIDTH,height:Y.DEFAULT_HEIGHT,left:Y.DEFAULT_LEFT_POS,top:Y.DEFAULT_TOP_POS,scale:Y.DEFAULT_SCALE,zIndex:Y.DEFAULT_ZINDEX},window:{frame:!1,title:"token-action-hud"}};static PARTS={form:{template:k.hud}};async _prepareContext(){const n=this.systemManager.styles[this.setting.style],A=foundry.utils.isNewerVersion(game.version,"12.999")&&["dockedLeft","dockedCenterRight","dockedRight"].includes(this.setting.style)?`${n.class}-v13`:n.class,k={hud:this.hudManager.hud,id:"token-action-hud",style:A??"",scale:this.scale,background:"#00000000",collapseIcon:n.collapseIcon??"fa-caret-left",expandIcon:n.expandIcon??"fa-caret-right",collapsibleSubgroups:Utils.getSetting("collapsibleSubgroups")};return et.debug("Application context",{context:k}),k}async init(){this.#R()}#R(){Object.entries(tt).forEach((([n,A])=>{A.cache&&(this.setting[n]=Utils.getSetting(n))}))}async updateCachedSettings(n,A=null){if(this.updateSettingsPending||(this.updateSettingsPending=!0,et.debug("Updating settings...")),tt[n]&&tt[n].cache)switch(this.setting[n]=A,n){case"customLayout":case"userCustomLayout":this.hudManager.layoutHandler.customLayout=null;break;case"rollHandler":this.hudManager.rollHandler=this.systemManager.getRollHandlerCore(this.hudManager.actionHandler);break;case"style":this.setPosition()}}_onRender(n,A){super._onRender(n,A),this.element.classList.remove("tah-closed"),Utils.switchCSS(this.setting.style),clearTimeout(this.closeTimer),clearTimeout(this.renderTimer),this.#B(),this.#z(),this.#j(this.elements)}#B(){this.elements={characterName:this.element.querySelector('[data-part="characterName"]'),actionArr:this.element.querySelectorAll('[data-part="action"]'),buttons:this.element.querySelector('[data-part="buttons"]'),tabSubgroupArr:this.element.querySelectorAll('[data-group-type="tab"]'),groups:this.element.querySelector('[data-part="groups"]'),editHudButton:this.element.querySelector('[data-part="editHudButton"]'),listSubgroupsArr:this.element.querySelectorAll('[data-part="listSubgroups"]'),subgroupsContainerArr:this.element.querySelectorAll('[data-part="subgroupsContainer"]'),subgroupArr:this.element.querySelectorAll('[data-part="subgroup"]'),listSubgroupTitleArr:this.element.querySelectorAll('[data-part="listSubgroupTitle"]'),groupButtonArr:this.element.querySelectorAll('[data-part="groupButton"]'),collapseExpandContainer:this.element.querySelector('[data-part="collapseExpandContainer"]'),collapseHudButton:this.element.querySelector('[data-part="collapseHudButton"]'),expandHudButton:this.element.querySelector('[data-part="expandHudButton"]'),unlockButton:this.element.querySelector('[data-part="unlockHudButton"]'),lockButton:this.element.querySelector('[data-part="lockHudButton"]')}}#z(){this.isCollapsed&&TokenActionHud.collapseHud.call(this),Utils.getSetting("enableCustomization")?this.isUnlocked?TokenActionHud.unlockHud.call(this):TokenActionHud.lockHud.call(this):(TokenActionHud.lockHud.call(this),this.elements.unlockButton.classList.add("tah-hidden"))}#j(n){Utils.getSetting("clickOpenCategory")||n.tabSubgroupArr.forEach((n=>{n.addEventListener("touchstart",this.toggleGroup.bind(this),{passive:!0}),n.addEventListener("pointerenter",this.toggleGroup.bind(this)),n.addEventListener("pointerleave",this.toggleGroup.bind(this))})),this.isDocked||n.groupButtonArr.forEach((n=>{n.addEventListener("mousedown",this.#V.bind(this)),n.addEventListener("touchstart",this.#V.bind(this),{passive:!0})})),n.actionArr.forEach((n=>{n.addEventListener("pointerenter",this.handleActionHover.bind(this)),n.addEventListener("pointerleave",this.handleActionHover.bind(this))}))}postRender(){this.rendering=!1,this.#$(),this.#q(),this.isCollapsed||(this.renderTimer=setTimeout((()=>{requestAnimationFrame((()=>{this.element?.classList?.add("tah-expanded")}))}),25))}#$(){if(this.isDocked)return;const{characterName:n,subgroupsContainerArr:A}=this.elements;"up"===this.direction?(n?.classList?.add("tah-hidden"),A.forEach((n=>{n.classList.remove("expand-down"),n.classList.add("expand-up")}))):(this.isCollapsed||n?.classList?.remove("tah-hidden"),A.forEach((n=>{n.classList.add("expand-down"),n.classList.remove("expand-up")})))}#q(){this.openGroups.size&&this.openGroups.forEach((n=>{const A=this.element.querySelector(`#${n}`);A&&this.toggleGroup(null,A)}))}static editHud(){TagifyAppHelper.openEditHudApp(this.hudManager.groupHandler)}async toggleHudEnable(){const n=Utils.humanizeBinding("enableDisableHud"),A=this.isEnabled?"disabled":"enabled";this.isEnabled?this.#W():Hooks.callAll("forceUpdateTokenActionHud"),await Utils.setSetting("enable",!this.isEnabled),et.info(game.i18n.format(`tokenActionHud.keybinding.toggleHud.${A}`,{binding:n}),!0)}static collapseHud(){this.toggleHudCollapse("collapse")}static expandHud(){this.toggleHudCollapse("expand")}toggleHudCollapse(n){n=n??(this.isCollapsed?"expand":"collapse");const A="collapse"===n,{characterName:k,collapseHudButton:C,expandHudButton:O,groups:L,buttons:U}=this.elements;C.classList.toggle("tah-hidden",A),O.classList.toggle("tah-hidden",!A),this.isDocked?this.element.classList.toggle("tah-expanded",!A):("down"===this.direction&&k.classList.toggle("tah-hidden",A),L.classList.toggle("tah-hidden",A),U.classList.toggle("tah-hidden",A)),this.isCollapsed=A}static async unlockHud(n=null){this.toggleHudLock("unlock",n)}static async lockHud(n=null){this.toggleHudLock("lock",n)}toggleHudLock(n,A=null){A&&A.preventDefault();const k="unlock"===n,{unlockButton:C,lockButton:O,editHudButton:L,subgroupArr:U,groupButtonArr:_,groups:j,listSubgroupsArr:Y,tabSubgroupArr:Q,listSubgroupTitleArr:Z}=this.elements;C.classList.toggle("tah-hidden",k),O.classList.toggle("tah-hidden",!k),L.classList.toggle("tah-hidden",!k),j.classList.toggle("tah-unlocked",k);const toggleElements=(n,A,k)=>{n.forEach((n=>n.classList.toggle(A,k)))};if(toggleElements(_,"disable-edit",!k),toggleElements(Z,"disable-edit",!k),k)toggleElements(U,"tah-hidden",!k),toggleElements(Y,"tah-hidden",!k),toggleElements(Q,"tah-hidden",!k),toggleElements(Z,"tah-hidden",!k);else{const hideIfEmpty=n=>{n.forEach((n=>{const A=n.querySelectorAll(".tah-action").length>0;A||n.classList.add("tah-hidden")}))};hideIfEmpty(Q),hideIfEmpty(U),hideIfEmpty(Y),Z.forEach((n=>{const A=n.closest(".tah-subgroup");"false"===A.dataset?.showTitle&&n.classList.add("tah-hidden")}))}this.isUnlocked=k}static clickGroup(n){this.bringToFront(),n.currentTarget.blur(),"contextmenu"===n.type?this.isUnlocked?this.openEditGroupApp(n):this.handleGroupClick(n):Utils.getSetting("clickOpenCategory")&&this.toggleGroup(n)}static clickSubgroup(n){if("contextmenu"===n.type)this.isUnlocked?this.openEditGroupApp(n):this.handleGroupClick(n);else{const A=Utils.getClosestGroupElement(n);"tab"===A.dataset?.groupType?this.toggleGroup(n,A):this.collapseExpandSubgroup(n)}}toggleGroup(n=null,A=null){A=A||Utils.getClosestGroupElement(n);const k=A.classList.contains("hover"),C=!k;if(!(k&&"pointerenter"===n?.type||!k&&"pointerleave"===n?.type)){if(A.classList.toggle("hover",C),C){this.#K(A);const n=new GroupResizer(this,this.hudManager);n.resizeGroup(A),this.openGroups.add(A.id)}else this.openGroups.delete(A.id);n&&n.currentTarget.blur()}}#K(n){this.openGroups.size&&this.openGroups.forEach((A=>{if(A===n.id)return;const k=this.element.querySelector(`#${A}`);k||this.openGroups.delete(A);const C=k.querySelector(`#${n.id}`);k&&!C&&this.toggleGroup(null,k)}))}collapseExpandSubgroup(n){if(!Utils.getSetting("collapsibleSubgroups"))return;const A=n.target.closest('[data-part="listSubgroupTitle"]'),k=Utils.getClosestGroupElement(n),C=k?.dataset?.nestId,O=A.closest(".tah-tab-subgroup.hover"),L=k?.querySelector('[data-part="subgroups"]'),U=A.querySelector(".tah-collapse-icon"),_=A.querySelector(".tah-expand-icon"),j=k.querySelector(".tah-list-image"),toggleGroupVisibility=()=>{L?.classList.toggle("tah-hidden"),U?.classList.toggle("tah-hidden"),_?.classList.toggle("tah-hidden"),j?.classList.toggle("tah-hidden")},saveGroupSettings=n=>{Utils.getSetting("enableCustomization")&&this.hudManager.groupHandler.saveGroupSettings({nestId:C,settings:{collapse:n}})};if(L?.classList.contains("tah-hidden")){toggleGroupVisibility(),saveGroupSettings(!1);const n=new GroupResizer(this,this.hudManager);n.resizeGroup(O)}else toggleGroupVisibility(),saveGroupSettings(!0)}handleGroupClick(n){this.hudManager.handleHudEvent("groupClick",n)}openEditGroupApp(n){const A=Utils.getClosestGroupElement(n),{nestId:k,level:C,type:O}=A.dataset;if(!k)return;const L=this.hudManager.groupHandler.groups[k].name,U=parseInt(C,10)||null;1===U?TagifyAppHelper.openEditGroupApp(this.hudManager.groupHandler,{nestId:k,name:L,level:U,type:O}):TagifyAppHelper.openEditSubgroupApp(this.hudManager.groupHandler,this.hudManager.actionHandler,{nestId:k,name:L,level:U,type:O})}static clickAction(n){n.preventDefault(),this.hudManager.handleHudEvent("clickAction",n),n.currentTarget.blur()}handleActionHover(n){this.hudManager.handleHudEvent("hoverAction",n)}#V(n){if(!this.isDraggable)return;const A=this.element,k=n.clientX??n.changedTouches[0].clientX,C=n.clientY??n.changedTouches[0].clientY;let O=0,L=0,U=k,_=C;const j=A.offsetTop,Y=A.offsetLeft;let Q=j,Z=Y;const mouseMoveEvent=n=>{const k=n.clientX??n.changedTouches[0].clientX,C=n.clientY??n.changedTouches[0].clientY;O=U-k,L=_-C,U=k,_=C,O===U&&L===_||(Q-=L,Z-=O,this.topPos=Q,requestAnimationFrame((()=>{Object.assign(A.style,{left:`${Z}px`,top:`${Q}px`})})))},mouseUpEvent=()=>{document.onmousemove=null,A.ontouchmove=null,document.onmouseup=null,A.ontouchend=null,Q===j&&Z===Y||(this.topPos=Q,this.#$(),this.hudPosition={top:Q,left:Z})};document.onmousemove=mouseMoveEvent,A.ontouchmove=mouseMoveEvent,document.onmouseup=mouseUpEvent,A.ontouchend=mouseUpEvent}setPosition(){this.hudManager.hud&&(this.isDocked?this.#X():this.#Y())}#X(){this.element.style.top=0,this.element.style.left=0;const n=document.querySelector("#interface"),A=this.systemManager.styles[this.setting.style]?.dockPosition,k=foundry.utils.isNewerVersion(game.version,"12.999");switch(A){case"right":if(k){const n=document.querySelector("#sidebar");n.prepend(this.element)}else n.appendChild(this.element);break;case"center-right":const A=n.querySelector("#ui-right");k?A.prepend(this.element):n.insertBefore(this.element,A);break;case"left":const C=n.querySelector("#ui-left");k?C.prepend(this.element):n.insertBefore(this.element,C)}}#Y(){document.body.appendChild(this.element),this.#J(),this.#$()}#J(){return this.hudPosition?new Promise((n=>{const check=()=>{this.element?(this.element.style.bottom=null,this.topPos=this.hudPosition.top<5||this.hudPosition.top>window.innerHeight+5?Y.DEFAULT_TOP_POS:this.hudPosition.top??Y.DEFAULT_TOP_POS,this.leftPos=this.hudPosition.left<5||this.hudPosition.left>window.innerWidth+5?Y.DEFAULT_LEFT_POS:this.hudPosition.left??Y.DEFAULT_LEFT_POS,this.element.style.top=`${this.topPos}px`,this.element.style.left=`${this.leftPos}px`,n()):setTimeout(check,10)};check()})):(this.element.style.top=`${Y.DEFAULT_TOP_POS}px`,void(this.element.style.left=`${Y.DEFAULT_LEFT_POS}px`))}get direction(){const n=Utils.getSetting("direction");return"up"===n||"auto"===n&&this.topPos>window.innerHeight/2?"up":"down"}get hudPosition(){return Utils.getUserFlag("position")}set hudPosition(n){Utils.setUserFlag("position",n),et.debug(`Position set to x: ${n.top}px, y: ${n.left}px`)}get isEnabled(){return Utils.getSetting("enable")}set isEnabled(n){Utils.setSetting("enable",n)}get isCollapsed(){return Utils.getUserFlag("isCollapsed")}set isCollapsed(n){Utils.setUserFlag("isCollapsed",n)}get isDocked(){const n=this.systemManager.styles[this.setting.style];return n.isDocked||n.dockPosition}get isUnlocked(){return Utils.getUserFlag("isUnlocked")}set isUnlocked(n){Utils.setUserFlag("isUnlocked",n)}get isDraggable(){const n=Utils.getSetting("drag");return"always"===n||"whenUnlocked"===n&&this.isUnlocked}get scale(){if(this.isDocked)return 1;const n=parseFloat(Utils.getSetting("scale"))||1;return Math.min(Math.max(n,.5),2)}async resetPosition(){et.debug("Resetting position..."),this.hudPosition={top:Y.DEFAULT_TOP_POS,left:Y.DEFAULT_LEFT_POS}}async copy(n,A){await this.#Q(n,A)}async#Q(n,A){if(!game.user.isGM)return void et.info("Copy failed: User is not a GM",!0);if(!n||!A.length)return void et.info("Copy failed: Parameters missing",!0);et.debug("Copying user data to users...");const k=await this.dataHandler.getDataAsGm({type:"user",id:n});if("string"==typeof A)await this.dataHandler.saveDataAsGm("user",A,k);else if(Array.isArray(A))for(const n of A)await this.dataHandler.saveDataAsGm("user",n,k);et.debug("User data copied to users")}static async resetLayoutWithSocket(){game?.tokenActionHud?.resetLayout()}async resetLayout(){et.debug("Resetting layout..."),await this.resetUserAndActorData(),this.resetPosition(),et.debug("Layout reset")}async resetActorData(){et.debug("Resetting actor data..."),await this.dataHandler.saveDataAsGm("actor",this.hudManager.actor.id,{}),et.debug("Actor data reset"),this.hudManager.hardResetHud();const n={trigger:{type:"method",name:"TokenActionHud#resetActorData"}};this.update(n)}async resetAllActorData(){et.debug("Resetting all actor data...");for(const n of game.actors)et.debug(`Resetting flags for actor [${n.id}]`,{actor:n}),await this.dataHandler.saveDataAsGm("actor",n.id,{});et.debug("All actor data reset"),this.hudManager.hardResetHud();const n={trigger:{type:"method",name:"TokenActionHud#resetAllActorData"}};this.update(n)}async resetUserData(){et.debug("Resetting user data..."),await this.dataHandler.saveDataAsGm("user",game.userId,{}),et.debug("User data reset"),this.hudManager.hardResetHud();const n={trigger:{type:"method",name:"TokenActionHud#resetUserData"}};this.update(n)}async resetAllUserData(){et.debug("Resetting all user data...");for(const n of game.users)await this.dataHandler.saveDataAsGm("user",n.id,{});et.debug("All user data reset"),this.hudManager.hardResetHud();const n={trigger:{type:"method",name:"TokenActionHud#resetAllUserData"}};this.update(n)}async resetUserAndActorData(){et.debug("Resetting user data..."),await this.dataHandler.saveDataAsGm("user",game.userId,{}),et.debug("User data reset"),et.debug("Resetting actor data..."),await this.dataHandler.saveDataAsGm("actor",this.hudManager.actor.id,{}),et.debug("Actor data reset"),this.hudManager.hardResetHud();const n={trigger:{type:"method",name:"TokenActionHud#resetUserAndActorData"}};this.update(n)}async update(n=null){if("closeSettingsConfig"===n?.name){if(!this.updateSettingsPending)return;this.updateSettingsPending=!1,et.debug("Settings updated")}await this.#Z(),await this.#tt(n)}async#Z(){this.isUpdatePending&&this.updatePendingTimer.abort(),this.isUpdatePending=!0,await this.updatePendingTimer.start(),this.isUpdatePending=!1;const waitForUpdateCompletion=async()=>{const n=5e3,A=10,k=n/A;let C=0;for(;C<k&&this.isUpdating;)await this.updateTimer.start(),C++;return!this.isUpdating};if(this.isUpdating){const n=await waitForUpdateCompletion();n||et.debug("Update took too long. Aborting...")}}async#tt(A){this.isUpdating=!0,et.debug("Updating HUD...",A);const k=await this.hudManager.init(A);k?(this.rendering=!0,this.render({force:!0,position:{}}),ui.windows[n.ID]||(ui.windows[n.ID]=this),this.isUpdating=!1,Hooks.callAll("tokenActionHudCoreHudUpdated",n),et.debug("HUD updated")):this.#et()}#et(){this.#W(),et.debug("HUD update aborted as no character(s) found or HUD is disabled"),this.isUpdating=!1}closeHud(){this.#W()}#W(){requestAnimationFrame((()=>{this.element?.classList?.remove("tah-expanded"),this.element?.classList?.add("tah-closed")})),this.openGroups=new Set,this.closeTimer=setTimeout((()=>{this.close({animate:!1})}),500),delete ui.windows[n.ID]}isValidTokenChange(n,A=null){return!A.flags&&(this.#it(n)||Utils.getSetting("alwaysShowHud")&&n.actorId===game.user.character?.id)}#it(n){const A=Utils.getControlledTokens();return A?.some((A=>A.id===n.id))||!A?.length&&canvas?.tokens?.placeables?.some((n=>n.id===this.hudManager.token?.id))}isControlledActor(n){return n?.id===this.hudManager.actor?.id}isValidActorOrItemUpdate(n,A){return n?this.isControlledActor(n)?(et.debug("Same actor; updating HUD",{actor:n,data:A}),!0):(et.debug("Different actor; skipping HUD update",{actor:n,data:A}),!1):(et.debug("No actor; updating HUD",{data:A}),!0)}}let wt;function registerSocket(){wt=socketlib.registerModule(n.ID),wt.register("getFilePaths",DataHandler.getFilePathsWithSocket),wt.register("getData",DataHandler.getDataWithSocket),wt.register("saveData",DataHandler.saveDataWithSocket),wt.register("reset",TokenActionHud.resetLayoutWithSocket)}function isSocketlibActive(){return!!game.modules.get("socketlib")?.active||(Logger.error("This module requires the 'socketlib' module to be installed and enabled.",!0),!1)}function getSocket(){return wt}class GenericActionHandler{constructor(n){this.actionHandler=n,this.actor=n.actor,this.token=n.token}buildActions(){this.#st()}#st(){this.actor?this.#nt():this.#ot()}#nt(){if(!this.token)return;const n=[],A="toggleCombat",k=this.token?.inCombat?game.i18n.localize("tokenActionHud.removeFromCombat"):game.i18n.localize("tokenActionHud.addToCombat"),C={id:A,name:k,onClick:async()=>{const n=Utils.getFirstControlledToken();n.document.toggleCombatant()}};if(n.push(C),game.user.isGM){const A="toggleVisibility",k=this.token?.document?.hidden?game.i18n.localize("tokenActionHud.makeVisible"):game.i18n.localize("tokenActionHud.makeInvisible"),C={id:A,name:k,onClick:async()=>{const n=Utils.getFirstControlledToken(),A=n.document.hidden;await n.document.update({hidden:!A})}};n.push(C)}const O={id:"token",type:j.SYSTEM};this.actionHandler.addActions(n,O)}#ot(){const n=Utils.getControlledTokens(),A=[],k="toggleCombat",C=n.every((n=>n.inCombat))?game.i18n.localize("tokenActionHud.removeFromCombat"):game.i18n.localize("tokenActionHud.addToCombat"),O={id:k,name:C,onClick:async()=>{const n=Utils.getControlledTokens();for(const A of n)await A.document.toggleCombatant()}};if(A.push(O),game.user.isGM){const k="toggleVisibility",C=n.every((n=>n.document?.hidden))?game.i18n.localize("tokenActionHud.makeVisible"):game.i18n.localize("tokenActionHud.makeInvisible"),O={id:k,name:C,onClick:async()=>{const n=Utils.getControlledTokens();for(const A of n){const n=A.document.hidden;await A.document.update({hidden:!n})}}};A.push(O)}const L={id:"token",type:j.SYSTEM};this.actionHandler.addActions(A,L)}}class CompendiumActionHandler{actionHandler;compendiumActions;packIds;constructor(n){this.actionHandler=n,this.compendiumActions=new Map,this.packIds=[]}async buildActions(){if(Utils.getSetting("enableCompendiumActions")){if(0===this.compendiumActions.size){if(this.packIds=game.packs.filter((n=>L.includes(n.documentName)&&(foundry.utils.isNewerVersion(game.version,"10")?n.visible:!n.private||game.user.isGM))).map((n=>n.metadata.id)),0===this.packIds.length)return;await Promise.all(this.packIds.map((n=>this.#at(n))))}for(const n of this.compendiumActions.values())this.actionHandler.addActions(n.actions,n.groupData)}}async#at(n){const A=game.packs.get(n),k=A?A.index.size>0?A.index:await A.getIndex():null;if(!k)return;const C=this.#rt(A?.documentName);if(!C)return;const L=k.map((n=>this.actionHandler.createAction({id:n._id,name:n.name,listName:`${game.i18n.localize(O[C])}: ${n.name}`,img:Utils.getImage(n),onClick:this.#lt(C,A,n._id)}))),U={id:this.#ct(n),type:"core"};this.compendiumActions.set(n,{actions:L,groupData:U})}#rt(n){return"Macro"===n?"compendiumMacro":"compendiumEntry"}#lt(n,A,k){return"compendiumMacro"===n?this.#dt(A,k):this.#ut(A,k)}#ut(n,A){return async()=>{const k=await n.getDocument(A);k.sheet.render(!0)}}#dt(n,A){return async()=>{await n.getDocument(A).then((n=>n.execute()))}}#ct(n){return n.replace(".","-")}isLinkedCompendium(n){return!!this.packIds.length&&this.packIds?.includes(n)}}class MacroActionHandler{constructor(n){this.actionHandler=n}clearCache(){this.macroActions=null}async buildActions(){Utils.getSetting("enableMacroActions")&&(this.macroActions||(this.macroActions={actions:await this.#gt(),groupData:{id:"macros",type:"core"}}),this.actionHandler.addActions(this.macroActions.actions,this.macroActions.groupData))}async#gt(){const n="macro",A=game.macros.filter((n=>this.#ht(n)));return A.map((A=>this.actionHandler.createAction({id:A.id,name:A.name,listName:this.#pt(n,A.name),img:Utils.getImage(A),onClick:()=>{game.macros.get(A.id).execute()}})))}#ht(n){const{ownership:A}=n;return A[game.userId]?A[game.userId]>0:A.default>0}#pt(n,A){const k=`${game.i18n.localize(O[n])}: `??"";return`${k}${A}`}}class ActionHandler{constructor(){this.hudManager={},this.groupHandler={},this.genericActionHandler=new GenericActionHandler(this),this.compendiumActionHandler=new CompendiumActionHandler(this),this.macroActionHandler=new MacroActionHandler(this),this.actions=[],this.availableActions=new Map,this.delimiter=C,this.actionHandlerExtenders=[]}softReset(){this.genericActionHandler=new GenericActionHandler(this),this.actions=[],this.availableActions=new Map}prepareActions(n){for(const A of Object.values(n))if(A.actions?.length){this.actions.push(...A.actions);for(const n of A.actions)n.selected=!1}}async buildActionsCore(){await Promise.all([this.#mt(),this.#ft(),this.#yt(),this.#vt()]),await this.#bt(),this.#At(),this.#wt()}async#mt(){et.debug("Building system actions...",{actor:this.actor,token:this.token});const n=this.groupHandler.getGroupIds();await this.buildSystemActions(n),et.debug("System actions built",{hud:this.hud,actor:this.actor,token:this.token})}async buildSystemActions(n){}async#yt(){et.debug("Building compendium actions..."),await this.compendiumActionHandler.buildActions(),et.debug("Compendium actions built",{hud:this.hud})}#ft(){et.debug("Building generic actions...",{actor:this.actor,token:this.token}),this.genericActionHandler.buildActions(),et.debug("Generic actions built",{hud:this.hud,actor:this.actor,token:this.token})}async#vt(){et.debug("Building macro actions..."),await this.macroActionHandler.buildActions(),et.debug("Macro actions built",{hud:this.hud})}async#bt(){await Promise.all(this.actionHandlerExtenders.map((async n=>await n.extendActionHandler())))}#At(){const n=this.actions.filter((n=>!n?.isPreset));for(const A of n){const n=this.availableActions.get(A.id);if(n){const k=n.systemSelected??A.systemSelected,C=A.userSelected??n.userSelected;Object.assign(A,this.createAction({...n,systemSelected:k,userSelected:C}))}}}#wt(){const n=this.groupHandler.getGroups({level:1});for(const A of n){const n=A?.settings?.characterCount,k=this.groupHandler.getGroups({nestId:A.nestId});for(const A of k){const k=A.actions;if(!k?.length)continue;const C=A?.settings?.characterCount,O=C>=0?n:C;if(!(!O&&0!==O||O<0))for(const n of k)n.name.length<=O||(n.name=0!==O?n.name.split(" ").map((n=>n.slice(0,O))).join(" "):"")}}}getActions(n){return this.actions.filter((A=>A.id===n.id))}createAction(n){const A=n.fullName??n.name,k=getTooltip(n.tooltip,A),infoProps=n=>n?{...n.class&&{class:n.class},...n.icon&&{icon:n.icon},...n.text&&{text:n.text},...n.title&&{title:n.title}}:{};return{id:n.id,name:n.name,fullName:A,listName:n.listName||n.name,...n.onClick&&{onClick:n.onClick},...n.onHover&&{onClick:n.onHover},...n.encodedValue&&{encodedValue:n.encodedValue},...n.cssClass&&{cssClass:n.cssClass},icons:n.icons||{},...n.icon1&&{icon1:n.icon1},...n.icon2&&{icon2:n.icon2},...n.icon3&&{icon3:n.icon3},...n.img&&{img:n.img},info1:infoProps(n.info1),info2:infoProps(n.info2),info3:infoProps(n.info3),system:n.system||{},isAction:!0,...n.isItem&&{isItem:n.isItem},...n.isPreset&&{isPreset:n.isPreset},userSelected:n.userSelected??!0,systemSelected:n.systemSelected??!0,selected:!!n.systemSelected&&(n.userSelected??n.systemSelected??!0),tooltip:k,...n.useRawHtmlName&&{useRawHtmlName:n.useRawHtmlName}}}addActions(n,A){if(!n.length)return;const k=new Map(n.map((n=>[n.id,n.isAction?n:this.createAction(n)])));if(this.#Tt(k),!A?.id)return;A?.type||(A.type="system");const C=this.groupHandler.getGroups(A);if(C.length)for(const n of C){const C=new Map(n.actions.map((n=>[n.id,n]))),O=[];C.forEach(((n,A)=>{const C=k.get(A);if(C){const A=C.systemSelected??n.systemSelected,k=n.userSelected??C.userSelected,O=!!A&&(k??A??!0);Object.assign(n,{...C,isPreset:!0,selected:O,systemSelected:A,userSelected:k})}else if(!n.selected&&n.isPreset){const A=!1;Object.assign(n,this.createAction({...n,systemSelected:A}))}})),k.forEach(((n,A)=>{const k=C.get(A);k||O.push(this.createAction({...n,isPreset:!0}))})),(A?.settings?.sort||void 0===A?.settings?.sort&&Utils.getSetting("sortActions"))&&O.sort(((n,A)=>n.name.localeCompare(A.name))),n.actions.push(...O)}}updateActions(n,A){const k=this.groupHandler.getGroup(A),C=k.actions,O=[];for(const A of n){if(A.id.includes("itemMacro"))continue;const n=k.actions.find((n=>n.id===A.id));if(n){const A={...n,userSelected:!0};O.push(A)}else{const n=this.availableActions.get(A.id);if(n){const A={...n,userSelected:!0};O.push(A)}}}for(const A of C){if(!A.id||A?.id.includes("itemMacro"))continue;const k=n.find((n=>n.id===A.id));if(!k&&A.isPreset){const n={...A,userSelected:!1};O.push(n)}}(A?.settings?.sort||void 0===A?.settings?.sort&&Utils.getSetting("sortActions"))&&O.sort(((n,A)=>n.name.localeCompare(A.name))),k.actions=O}#Tt(n){for(const[A,k]of n)this.availableActions.has(A)||this.availableActions.set(A,k)}getAvailableActionsAsTags(){return[...this.availableActions.values()].map((n=>this.#g(n))).sort(((n,A)=>n.value.localeCompare(A.value)))}getSelectedActionsAsTags(n){const A=this.groupHandler.getGroup(n);return A?A.actions.filter((n=>!0===n.selected)).map((n=>this.#g(n))):[]}addActionHandlerExtender(n){et.debug("Adding action handler extender...",{actionHandlerExtender:n}),n.hudManager=this.hudManager,n.groupHandler=this.groupHandler,n.actionHandler=this,this.actionHandlerExtenders.push(n)}#g(n){const{id:A,name:k,listName:C}=n;return{id:A,name:k,type:"action",value:C??k}}get characterName(){return this.hudManager?.characterName}get actor(){return this.hudManager?.actor}set actor(n){this.hudManager.actor=n}get actors(){return this.hudManager?.actors}set actors(n){this.hudManager.actors=n}get token(){return this.hudManager?.token}set token(n){this.hudManager.token=n}get tokens(){return this.hudManager?.tokens}set tokens(n){this.hudManager.tokens=n}get isRightClick(){return this.hudManager?.isRightClick}get isAlt(){return this.hudManager?.isAlt}get isCtrl(){return this.hudManager?.isCtrl}get isShift(){return this.hudManager?.isShift}get isHover(){return this.hudManager?.isHover}}class ActionHandlerExtender extends ActionHandler{constructor(){super()}extendActionHandler(){}}class RollHandler{constructor(){this.hudManager=null,this.delimiter=C,this.preRollHandlers=[],this.rollHandlerExtenders=[]}throwInvalidValueErr(n){throw new Error(`Error handling button click: ${n}`)}addRollHandlerExtender(n){et.debug("Adding roll handler extender...",{rollHandlerExtender:n}),this.rollHandlerExtenders.push(n)}async handleActionClickCore(n,A,k){try{if(et.debug("Handling action click event",{event:n}),this.action=A,"function"==typeof A?.onClick)return A.onClick(),void Hooks.callAll("forceUpdateTokenActionHud");const C=this.#kt(n);for(let A of this.rollHandlerExtenders)if(A.action=this.action,A.prehandleActionEvent(n,C,k))return;for(let A of this.preRollHandlers)if(A.action=this.action,A.prehandleActionEvent(n,C,k))return;for(let A of this.rollHandlerExtenders)if(A.action=this.action,A.handleActionClick(n,C,k))return;this.handleActionClick(n,C)}catch(k){et.error("Error handling action click event",{error:k,event:n,action:A})}}handleActionClick(n,A){}async handleActionHoverCore(n,A){if(et.debug("Handling action hover event",{event:n}),this.action=A,"function"==typeof A?.onHover)return void A.onHover();const k=this.#kt(n);this.handleActionHover(n,k)}handleActionHover(n,A){}async handleGroupClickCore(n,A){et.debug(`Handling click event for group [${A.name}]`,{event:n}),this.handleGroupClick(n,A)}handleGroupClick(n,A){}addPreRollHandler(n){et.debug(`Adding pre-roll handler ${n.constructor.name}`),this.preRollHandlers.push(n)}#kt(n){if(!n)return null;const A=n.target.querySelector(".tah-action-button")??n.target.closest(".tah-action-button");return A?.value||null}renderItem(n,A){n||(n=this.actor);const k=Utils.getItem(n,A);return!!k&&(k.sheet.render(!0),!0)}isRenderItem(){return this.isRightClick&&!(this.isAlt||this.isCtrl||this.isShift)}get actor(){return this.hudManager?.actor}get actors(){return this.hudManager?.actors}get token(){return this.hudManager?.token}get tokens(){return this.hudManager?.tokens}get isRightClick(){return this.hudManager.isRightClick}get isAlt(){return this.hudManager.isAlt}get isCtrl(){return this.hudManager.isCtrl}get isShift(){return this.hudManager.isShift}get isHover(){return this.hudManager?.isHover}}class PreRollHandler extends RollHandler{prehandleActionEvent(n,A,k){return!1}}class RollHandlerExtender extends RollHandler{constructor(){super()}prehandleActionEvent(n,A,k){return!1}handleActionClick(n,A,k){return!1}}const{ApplicationV2:Tt,HandlebarsApplicationMixin:kt}=foundry.applications.api;class CustomStyleForm extends(kt(Tt)){constructor(...n){super(n)}static DEFAULT_OPTIONS={actions:{reset:CustomStyleForm.reset},classes:[`${n.ID}-app`,"sheet"],id:"token-action-hud-core-settings",form:{closeOnSubmit:!0,handler:CustomStyleForm.submit},position:{width:600,height:680},tag:"form",window:{minimizable:!0,resizable:!0,title:"tokenActionHud.settings.customStyle.form.title"}};static PARTS={form:{template:k.customStyleForm}};async _prepareContext(){return this.context={backgroundColor:Utils.getSetting("backgroundColor",_.backgroundColor.default),buttonHeight:Utils.getSetting("buttonHeight",_.buttonHeight.default),buttonBackgroundColor:Utils.getSetting("buttonBackgroundColor",_.buttonBackgroundColor.default),buttonHoverBackgroundColor:Utils.getSetting("buttonHoverBackgroundColor",_.buttonHoverBackgroundColor.default),buttonToggleActiveBackgroundColor:Utils.getSetting("buttonToggleActiveBackgroundColor",_.buttonToggleActiveBackgroundColor.default),buttonToggleHoverBackgroundColor:Utils.getSetting("buttonToggleHoverBackgroundColor",_.buttonToggleHoverBackgroundColor.default),buttonTextColor:Utils.getSetting("buttonTextColor",_.buttonTextColor.default),buttonHoverTextColor:Utils.getSetting("buttonHoverTextColor",_.buttonHoverTextColor.default),buttonToggleActiveTextColor:Utils.getSetting("buttonToggleActiveTextColor",_.buttonToggleActiveTextColor.default),buttonToggleHoverTextColor:Utils.getSetting("buttonToggleHoverTextColor",_.buttonToggleHoverTextColor.default),buttonBorderPrimaryColor:Utils.getSetting("buttonBorderPrimaryColor",_.buttonBorderPrimaryColor.default),buttonBorderSecondaryColor:Utils.getSetting("buttonBorderSecondaryColor",_.buttonBorderSecondaryColor.default),buttonHoverBorderPrimaryColor:Utils.getSetting("buttonHoverBorderPrimaryColor",_.buttonHoverBorderPrimaryColor.default),buttonHoverBorderSecondaryColor:Utils.getSetting("buttonHoverBorderSecondaryColor",_.buttonHoverBorderSecondaryColor.default),buttonToggleActiveBorderPrimaryColor:Utils.getSetting("buttonToggleActiveBorderPrimaryColor",_.buttonToggleActiveBorderPrimaryColor.default),buttonToggleActiveBorderSecondaryColor:Utils.getSetting("buttonToggleActiveBorderSecondaryColor",_.buttonToggleActiveBorderSecondaryColor.default),buttonToggleHoverBorderPrimaryColor:Utils.getSetting("buttonToggleHoverBorderPrimaryColor",_.buttonToggleHoverBorderPrimaryColor.default),buttonToggleHoverBorderSecondaryColor:Utils.getSetting("buttonToggleHoverBorderSecondaryColor",_.buttonToggleHoverBorderSecondaryColor.default),textPrimaryColor:Utils.getSetting("textPrimaryColor",_.textPrimaryColor.default),textSecondaryColor:Utils.getSetting("textSecondaryColor",_.textSecondaryColor.default),textTertiaryColor:Utils.getSetting("textTertiaryColor",_.textTertiaryColor.default),textHoverPrimaryColor:Utils.getSetting("textHoverPrimaryColor",_.textHoverPrimaryColor.default),textHoverSecondaryColor:Utils.getSetting("textHoverSecondaryColor",_.textHoverSecondaryColor.default),textHoverTertiaryColor:Utils.getSetting("textHoverTertiaryColor",_.textHoverTertiaryColor.default)},this.context}_onRender(n,A){super._onRender(n,A),"undefined"!=typeof ColorPicker&&ColorPicker.install()}static async reset(){for(const[n,A]of Object.entries(_))Utils.setSetting(n,A.default),document.querySelector(":root").style.setProperty(A.cssProperty,A.default);this.render(!0)}static async submit(n,A,k){const C="custom"===Utils.getSetting("style");for(const[n,A]of Object.entries(k.object)){const k=_[n];A!==this.context[n]&&(Utils.setSetting(n,A),C&&document.querySelector(":root").style.setProperty(k.cssProperty,A))}}}async function resetLayoutDialog(){await foundry.applications.api.DialogV2.confirm({window:{title:game.i18n.localize("tokenActionHud.dialog.resetLayout.title")},content:`<p>${game.i18n.localize("tokenActionHud.dialog.resetLayout.content")}</p>`,modal:!0,yes:{label:game.i18n.localize("tokenActionHud.dialog.button.yes"),callback:async()=>resetLayout()},no:{label:game.i18n.localize("tokenActionHud.dialog.button.no")}})}async function resetLayout(){if(!game?.tokenActionHud)return;const n=document.querySelector("#token-action-hud-core-settings input[name=customLayout]");n&&(await game.tokenActionHud.updateCachedSettings("customLayout",n?.value??""),await Utils.setSetting("customLayout",n?.value??""));const A=document.querySelector("#token-action-hud-core-settings input[name=userCustomLayout]");A&&(await game.tokenActionHud.updateCachedSettings("userCustomLayout",A?.value??""),await Utils.setUserFlag("userCustomLayout",A?.value??"")),await game.tokenActionHud.resetLayout(),et.info("Layout reset",!0)}async function resetAllLayoutsDialog(){await foundry.applications.api.DialogV2.confirm({window:{title:game.i18n.localize("tokenActionHud.dialog.resetAllLayouts.title")},content:`<p>${game.i18n.localize("tokenActionHud.dialog.resetAllLayouts.content")}</p>`,modal:!0,yes:{label:game.i18n.localize("tokenActionHud.dialog.button.yes"),callback:async()=>resetAllLayouts()},no:{label:game.i18n.localize("tokenActionHud.dialog.button.no")}})}async function resetAllLayouts(){if(!game.tokenActionHud)return;const n=document.querySelector("#token-action-hud-core-settings input[name=customLayout]");n&&await Utils.setSetting("customLayout",n?.value??"");const A=document.querySelector("#token-action-hud-core-settings input[name=userCustomLayout]");A&&await Utils.setUserFlag("userCustomLayout",A?.value??""),await game.tokenActionHud.socket.executeForEveryone("reset"),et.info("All layouts reset",!0)}const{ApplicationV2:Ht,HandlebarsApplicationMixin:St}=foundry.applications.api;class TahSettingsForm extends(St(Ht)){constructor(...n){super(n),this.settings={}}static DEFAULT_OPTIONS={actions:{exportLayout:TahSettingsForm.exportLayout,resetLayout:resetLayoutDialog,resetAllLayouts:resetAllLayoutsDialog,reset:TahSettingsForm.reset},classes:[`${n.ID}-app`,"sheet"],id:"token-action-hud-core-settings",form:{closeOnSubmit:!0,handler:TahSettingsForm.submit},position:{width:600,height:800},tag:"form",window:{minimizable:!0,resizable:!0}};static PARTS={form:{template:k.settings}};async _prepareContext(){const n=[],A={settings:n};for(const[A,k]of Object.entries(this.settings)){const{scope:C,hint:O,icon:L,label:U,name:_,type:j,inputType:Y,range:Q,choices:Z,action:tt}=k;if("world"===C&&!game.user.isGM)continue;const et=k?.scope?"user"===C?await Utils.getUserFlag(A):await Utils.getSetting(A):"",it=j instanceof Function?j.name:"String",st="button"===Y,nt="checkbox"===Y,ot="filePicker"===Y,at="filePicker"===Y?it??"any":"",rt="number"===Y,lt="range"===Y&&Q,ct=void 0!==Z;n.push({id:A,hint:game.i18n.localize(O),icon:L,label:game.i18n.localize(U),name:game.i18n.localize(_),value:et,type:j,isButton:st,action:tt,isCheckbox:nt,isFilePicker:ot,filePickerType:at,isNumber:rt,isRange:lt,isSelect:ct})}return A}static exportLayout(){game.tokenActionHud&&game.tokenActionHud.hudManager.layoutHandler.exportLayout()}static async submit(n,A,k){for(const[n,A]of Object.entries(k.object)){switch(this.settings[n].scope){case"client":case"world":await Utils.setSetting(n,A);break;case"user":await Utils.setUserFlag(n,A)}await game.tokenActionHud.updateCachedSettings(n,A)}game.tokenActionHud.update()}}class TahSettingsFormLayout extends TahSettingsForm{constructor(){super(),this.settings=Z}static DEFAULT_OPTIONS={window:{title:"tokenActionHud.settings.layout.form.title"}}}function onChangeFunction(n,A){game.tokenActionHud&&game.tokenActionHud.updateCachedSettings(n,A)}Hooks.on("init",(async()=>{game.keybindings.register(n.ID,"enableDisableHud",{name:game.i18n.localize("tokenActionHud.enableDisableHud"),editable:[],onDown:()=>{game.tokenActionHud&&game.tokenActionHud.toggleHudEnable()}}),game.keybindings.register(n.ID,"collapseExpandHud",{name:game.i18n.localize("tokenActionHud.collapseExpandHud"),editable:[],onDown:()=>{game.tokenActionHud&&game.tokenActionHud.toggleHudCollapse()}})}));const registerSettingsCore=function(A,k,C){game.settings.registerMenu(n.ID,"customStyle",{hint:game.i18n.localize("tokenActionHud.settings.customStyle.hint"),label:game.i18n.localize("tokenActionHud.settings.customStyle.label"),name:game.i18n.localize("tokenActionHud.settings.customStyle.name"),icon:"fas fa-palette",type:CustomStyleForm,restricted:!1,scope:"client"}),game.settings.registerMenu(n.ID,"layout",{hint:game.i18n.localize("tokenActionHud.settings.layout.hint"),label:game.i18n.localize("tokenActionHud.settings.layout.label"),name:game.i18n.localize("tokenActionHud.settings.layout.name"),icon:"fas fa-table-layout",type:TahSettingsFormLayout,restricted:!1,scope:"client"}),game.settings.register(n.ID,"startup",{name:"One-Time Startup Prompt",scope:"world",config:!1,type:Boolean,default:!1}),game.settings.register(n.ID,"migrationVersion",{name:"Migration Version",scope:"world",config:!1,type:String,default:"0.0"}),game.settings.register(n.ID,"enable",{name:game.i18n.localize("tokenActionHud.settings.enable.name"),hint:game.i18n.localize("tokenActionHud.settings.enable.hint"),scope:"client",config:!0,type:Boolean,default:!0,onChange:n=>{onChangeFunction("enable",n)}}),game.settings.register(n.ID,"rollHandler",{name:game.i18n.localize("tokenActionHud.settings.rollHandler.name"),hint:game.i18n.localize("tokenActionHud.settings.rollHandler.hint"),scope:"world",config:!0,type:String,choices:k,default:"core",onChange:n=>{onChangeFunction("rollHandler",n)}});const O=Object.fromEntries(Object.entries(C).map((([n,A])=>[n,A.name])));game.settings.register(n.ID,"style",{name:game.i18n.localize("tokenActionHud.settings.style.name"),hint:game.i18n.localize("tokenActionHud.settings.style.hint"),scope:"client",config:!0,type:String,default:"foundryVTT",choices:O,onChange:n=>{Utils.switchCSS(n),onChangeFunction("style",n)}}),game.settings.register(n.ID,"customLayout",{name:game.i18n.localize("tokenActionHud.settings.customLayout.name"),hint:game.i18n.localize("tokenActionHud.settings.customLayout.hint"),scope:"world",config:!1,type:String}),game.settings.register(n.ID,"userCustomLayout",{name:game.i18n.localize("tokenActionHud.settings.userCustomLayout.name"),hint:game.i18n.localize("tokenActionHud.settings.userCustomLayout.hint"),scope:"client",config:!1,type:String}),game.settings.register(n.ID,"allow",{name:game.i18n.localize("tokenActionHud.settings.allow.name"),hint:game.i18n.localize("tokenActionHud.settings.allow.hint"),scope:"world",config:!0,type:String,choices:{4:game.i18n.localize("tokenActionHud.settings.allow.choice.4"),3:game.i18n.localize("tokenActionHud.settings.allow.choice.3"),2:game.i18n.localize("tokenActionHud.settings.allow.choice.2"),1:game.i18n.localize("tokenActionHud.settings.allow.choice.1")},default:1,requiresReload:!0}),game.settings.register(n.ID,"enableCustomization",{name:game.i18n.localize("tokenActionHud.settings.enableCustomization.name"),hint:game.i18n.localize("tokenActionHud.settings.enableCustomization.hint"),scope:"world",config:!0,type:Boolean,default:!0,onChange:n=>{onChangeFunction("enableCustomization",n)}}),game.settings.register(n.ID,"enableCompendiumActions",{name:game.i18n.localize("tokenActionHud.settings.enableCompendiumActions.name"),hint:game.i18n.localize("tokenActionHud.settings.enableCompendiumActions.hint"),scope:"world",config:!0,type:Boolean,default:!0,onChange:n=>{onChangeFunction("enableCompendiumActions",n)}}),game.settings.register(n.ID,"enableMacroActions",{name:game.i18n.localize("tokenActionHud.settings.enableMacroActions.name"),hint:game.i18n.localize("tokenActionHud.settings.enableMacroActions.hint"),scope:"world",config:!0,type:Boolean,default:!0,onChange:n=>{onChangeFunction("enableMacroActions",n)}}),game.settings.register(n.ID,"direction",{name:game.i18n.localize("tokenActionHud.settings.direction.name"),hint:game.i18n.localize("tokenActionHud.settings.direction.hint"),scope:"client",config:!0,type:String,default:"auto",choices:{auto:game.i18n.localize("tokenActionHud.settings.direction.choice.auto"),up:game.i18n.localize("tokenActionHud.settings.direction.choice.up"),down:game.i18n.localize("tokenActionHud.settings.direction.choice.down")},onChange:n=>{onChangeFunction("direction",n)}}),game.settings.register(n.ID,"grid",{name:game.i18n.localize("tokenActionHud.settings.grid.name"),hint:game.i18n.localize("tokenActionHud.settings.grid.hint"),scope:"client",config:!0,type:Boolean,default:!1,onChange:n=>{onChangeFunction("grid",n)}}),game.settings.register(n.ID,"scale",{name:game.i18n.localize("tokenActionHud.settings.scale.name"),hint:game.i18n.localize("tokenActionHud.settings.scale.hint"),scope:"client",config:!0,type:Number,range:{min:.5,max:2,step:.05},default:1,onChange:n=>{onChangeFunction("scale",n)}}),game.settings.register(n.ID,"drag",{name:game.i18n.localize("tokenActionHud.settings.drag.name"),hint:game.i18n.localize("tokenActionHud.settings.drag.hint"),scope:"client",config:!0,type:String,default:"whenUnlocked",choices:{always:game.i18n.localize("tokenActionHud.settings.drag.choices.always"),whenUnlocked:game.i18n.localize("tokenActionHud.settings.drag.choices.whenUnlocked"),never:game.i18n.localize("tokenActionHud.settings.drag.choices.never")},onChange:n=>{onChangeFunction("drag",n)}}),game.settings.register(n.ID,"alwaysShowHud",{name:game.i18n.localize("tokenActionHud.settings.alwaysShowHud.name"),hint:game.i18n.localize("tokenActionHud.settings.alwaysShowHud.hint"),scope:"client",config:!0,type:Boolean,default:!0,onChange:n=>{onChangeFunction("alwaysShowHud",n)}}),game.settings.register(n.ID,"clickOpenCategory",{name:game.i18n.localize("tokenActionHud.settings.clickOpenCategory.name"),hint:game.i18n.localize("tokenActionHud.settings.clickOpenCategory.hint"),scope:"client",config:!0,type:Boolean,default:!1,onChange:n=>{onChangeFunction("clickOpenCategory",n)}}),game.settings.register(n.ID,"collapsibleSubgroups",{name:game.i18n.localize("tokenActionHud.settings.collapsibleSubgroups.name"),hint:game.i18n.localize("tokenActionHud.settings.collapsibleSubgroups.hint"),scope:"client",config:!0,type:Boolean,default:!0,onChange:n=>{onChangeFunction("collapsibleSubgroups",n)}}),game.settings.register(n.ID,"displayCharacterName",{name:game.i18n.localize("tokenActionHud.settings.displayCharacterName.name"),hint:game.i18n.localize("tokenActionHud.settings.displayCharacterName.hint"),scope:"client",config:!0,type:Boolean,default:!0,onChange:n=>{onChangeFunction("displayCharacterName",n)}}),game.settings.register(n.ID,"sortActions",{name:game.i18n.localize("tokenActionHud.settings.sortActions.name"),hint:game.i18n.localize("tokenActionHud.settings.sortActions.hint"),scope:"client",config:!0,type:Boolean,default:!1,onChange:n=>{onChangeFunction("sortActions",n)}}),game.settings.register(n.ID,"displayIcons",{name:game.i18n.localize("tokenActionHud.settings.displayIcons.name"),hint:game.i18n.localize("tokenActionHud.settings.displayIcons.hint"),scope:"client",config:!0,type:Boolean,default:!0,onChange:n=>{onChangeFunction("displayIcons",n)}}),game.settings.register(n.ID,"tooltips",{name:game.i18n.localize("tokenActionHud.settings.tooltips.name"),hint:game.i18n.localize("tokenActionHud.settings.tooltips.hint"),scope:"client",config:!0,type:String,default:"full",choices:{full:game.i18n.localize("tokenActionHud.settings.tooltips.choices.full"),nameOnly:game.i18n.localize("tokenActionHud.settings.tooltips.choices.nameOnly"),none:game.i18n.localize("tokenActionHud.settings.tooltips.choices.none")},onChange:n=>{onChangeFunction("tooltips",n)}}),game.settings.register(n.ID,"tooltipDelay",{name:game.i18n.localize("tokenActionHud.settings.tooltipDelay.name"),hint:game.i18n.localize("tokenActionHud.settings.tooltipDelay.hint"),scope:"client",config:!0,type:Number,default:1500,onChange:n=>{setTooltipDelay(n)}});const L=Utils.getSetting("tooltipDelay")||1500;function setTooltipDelay(n){const A=document.querySelector(":root");A.style.setProperty("--tah-tooltip-delay",`${n}ms`)}setTooltipDelay(L),Utils.isModuleActive("itemacro")&&!Utils.isModuleActive("midi-qol")&&game.settings.register(n.ID,"itemMacro",{name:game.i18n.localize("tokenActionHud.settings.itemMacro.name"),hint:game.i18n.localize("tokenActionHud.settings.itemMacro.hint"),scope:"client",config:!0,type:String,choices:{both:game.i18n.localize("tokenActionHud.settings.itemMacro.choices.both"),itemMacro:game.i18n.localize("tokenActionHud.settings.itemMacro.choices.itemMacro"),original:game.i18n.localize("tokenActionHud.settings.itemMacro.choices.original")},default:"both",onChange:n=>{onChangeFunction("itemMacro",n)}}),game.settings.register(n.ID,"activeCssAsText",{name:game.i18n.localize("tokenActionHud.settings.activeCssAsText.name"),hint:game.i18n.localize("tokenActionHud.settings.activeCssAsText.hint"),scope:"client",config:!0,type:Boolean,default:!1,onChange:n=>{onChangeFunction("activeCssAsText",n)}}),game.settings.register(n.ID,"debug",{name:game.i18n.localize("tokenActionHud.settings.debug.name"),hint:game.i18n.localize("tokenActionHud.settings.debug.hint"),scope:"client",config:!0,type:Boolean,default:!1,onChange:n=>{onChangeFunction("debug",n)}}),registerCustomStyleSettings(),A.registerSettings(onChangeFunction),et.debug("Available roll handlers",{rollHandlers:k})};function registerCustomStyleSettings(){for(const[A,k]of Object.entries(_))game.settings.register(n.ID,A,{scope:"client",config:!1,type:k.type,default:k.default})}class ItemMacroActionHandlerExtender extends ActionHandlerExtender{constructor(){super()}extendActionHandler(){if(!this.actor)return;const n=this.actor.items.filter((n=>n.flags?.itemacro?.macro?.command));if(!n?.length)return;const A=Utils.getSetting("itemMacro");if("original"===A)return;const k="itemMacro"===A;Object.values(this.groupHandler.groups).forEach((A=>{this.#Ht(n,A,k)}))}#Ht(n,A,k){if(!A?.actions?.length)return;const C=[];for(const O of A.actions){const L=n.find((n=>n.id===O.id));if(!L)continue;const U=A.actions.find((n=>n.id===`itemMacro+${O.id}`)),_=U??O;U&&(k=!0);const j=this.#St(L,O,_,k);k||C.push(j),this.actionHandler.availableActions.has(j.id)||this.actionHandler.availableActions.set(j.id,j)}this.#Ct(C,A)}#St(n,A,k,O){const L=O?k:Utils.deepClone(A);return L.encodedValue=`itemMacro${A.encodedValue?.substr(A.encodedValue.indexOf(C))}`,L.id=`itemMacro+${A.id}`,L.fullName=A.fullName,L.listName=`Item Macro: ${A.fullName}`,L.name=A.name,L.img=A.img,L.itemMacroIcon=`<i class="${Q.ICON}" data-tooltip="${Q.TOOLTIP}"></i>`,L.selected=A.userSelected??A.systemSelected,L.onClick=()=>{try{n.executeMacro()}catch(n){return Logger.debug("ItemMacro Error",n),!1}},L}#Ct(n,A){n.forEach((n=>{const k=A.actions.findIndex((A=>A.id===n.id))+1;A.actions.splice(k,0,n)}))}}class SystemManager{constructor(){this.coreModuleId=n.ID,this.defaults=[],this.styles=null}getActionHandler(){}getRollHandler(n){return!1}getAvailableRollHandlers(){}registerSettings(n){}async registerDefaults(){}registerStyles(){}async init(){await this.#Dt(),this.#It(),this.#Et()}async#Dt(){const n=await this.registerDefaults()??[];Hooks.callAll("tokenActionHudCoreRegisterDefaults",n),n&&(this.defaults=n)}#It(){const n=this.registerStyles()??{};this.styles=foundry.utils.mergeObject(U,n),Hooks.callAll("tokenActionHudCoreRegisterStyles",this.styles)}#Et(){const n=this.getAvailableRollHandlers();registerSettingsCore(this,n,this.styles)}getActionHandlerCore(n){const A=this.getActionHandler();A.systemManager=this;const{dataHandler:k,groupHandler:C}=n;return A.hudManager=n,A.dataHandler=k,A.groupHandler=C,A.addGroup=C.addGroup.bind(C),A.addGroupInfo=C.addGroupInfo.bind(C),this.#xt(C,A),Hooks.callAll("tokenActionHudCoreAddActionHandler",A),A}#xt(n,A){Utils.isModuleActive("itemacro")&&!Utils.isModuleActive("midi-qol")&&A.addActionHandlerExtender(new ItemMacroActionHandlerExtender(n,A)),Hooks.callAll("tokenActionHudCoreAddActionHandlerExtenders",A)}getRollHandlerCore(n){let A=Utils.getSetting("rollHandler");"core"===A||Utils.isModuleActive(A)||(et.error(A,game.i18n.localize("tokenActionHud.handlerNotFound")),A="core",Utils.setSetting("rollHandler",A));const k=this.getRollHandler(A)??new RollHandler;return k.hudManager=n,this.#Mt(k),Hooks.callAll("tokenActionHudCoreAddRollHandler",k),k}#Mt(n){Hooks.callAll("tokenActionHudCoreAddRollHandlerExtenders",n)}static addHandler(n,A){if(Utils.isModuleActive(A)){const k=Utils.getModuleTitle(A);foundry.utils.mergeObject(n,{[A]:k})}}}function registerApi(){const A=game.modules.get(n.ID);A.api={ActionHandlerExtender:ActionHandlerExtender,ActionHandler:ActionHandler,DataHandler:DataHandler,Logger:et,PreRollHandler:PreRollHandler,RollHandler:RollHandler,RollHandlerExtender:RollHandlerExtender,SystemManager:SystemManager,Timer:Timer,Utils:Utils},Hooks.callAll("tokenActionHudCoreApiReady",A)}let Ct;async function registerCoreModule(A){Utils.isSystemModuleCompatible(A.api?.requiredCoreModuleVersion)&&isSocketlibActive()&&(Ct=new A.api.SystemManager(n.ID),await Ct.init(),Utils.registerHandlebars(),foundry.utils.isNewerVersion(game.version,"12.9999")?foundry.applications.handlebars.loadTemplates(Object.values(k)):loadTemplates(Object.values(k)),Hooks.callAll("tokenActionHudCoreReady"))}async function registerHud(){const n=getSocket(),A=new DataHandler(n);await A.init();const k=new MigrationManager(A,n);await k.init(),checkColorPicker(),registerHudHooks(),game.tokenActionHud=new TokenActionHud(Ct,A,n),await game.tokenActionHud.init(),Hooks.callAll("tokenActionHudReady"),game.tokenActionHud.update({type:"hook",name:"tokenActionHudCoreReady"})}function checkColorPicker(){game.user.isGM&&!game.modules.get("color-picker")?.active&&!1===Utils.getSetting("startup")&&(et.info("To enable color pickers, install the 'Color Picker' module.",!0),Utils.setSetting("startup",!0))}function registerHudHooks(){Hooks.on("renderTokenActionHud",(()=>game.tokenActionHud.postRender()));const n=["deleteActor","updateActor","createActiveEffect","deleteActiveEffect","createCombat","deleteCombat","updateCombat","updateCombatant","deleteCompendium","updateCompendium","createItem","deleteItem","updateItem","createMacro","deleteMacro","updateMacro","controlToken","deleteToken","updateToken","closeSettingsConfig","forceUpdateTokenActionHud"];n.forEach((n=>Hooks.on(n,((...A)=>handleHookEvent({...A},n)))))}function handleHookEvent(n,A){validateHookData(n,A)&&game.tokenActionHud.update({type:"hook",name:A,data:n})}function validateHookData(n,A){if(!game.tokenActionHud)return!1;switch(A){case"deleteActor":case"updateActor":return game.tokenActionHud.isValidActorOrItemUpdate(n[0],n[1]);case"createActiveEffect":case"deleteActiveEffect":return game.tokenActionHud.isControlledActor(n[0]?.parent);case"createCombatant":case"updateCombatant":return game.tokenActionHud.isControlledActor(n[0]?.actor);case"deleteCompendium":case"updateCompendium":return validateCompendium(n.source?.metadata?.id);case"createItem":case"deleteItem":case"updateItem":return game.tokenActionHud.isValidActorOrItemUpdate(n[0]?.actor);case"createMacro":case"deleteMacro":case"updateMacro":return game.tokenActionHud.hudManager.actionHandler.macroActionHandler.clearCache(),!0;case"updateToken":return Object.hasOwn(n[1],"hidden")&&game.tokenActionHud.isValidTokenChange(n[0],n[1]);default:return!0}}function validateCompendium(n){const A=game.tokenActionHud.hudManager.actionHandler.compendiumActionHandler;return!!A.isLinkedCompendium(n)&&(A.compendiumActions=new Map,!0)}function addContextMenuListener(n,A){const k=n[0]??n,C=k.querySelector(A);C&&C.addEventListener("contextmenu",sendHudToBottom)}function sendHudToBottom(){game.tokenActionHud?.element&&(game.tokenActionHud.element.style.zIndex=20)}Hooks.once("socketlib.ready",registerSocket),Hooks.on("ready",registerApi),Hooks.on("tokenActionHudSystemReady",registerCoreModule),Hooks.on("tokenActionHudCoreReady",registerHud),Hooks.on("renderHotbar",((n,A)=>addContextMenuListener(A,foundry.utils.isNewerVersion(game.version,"12.999")?"li.slot":"li.macro"))),Hooks.on("renderSceneNavigation",((n,A)=>addContextMenuListener(A,foundry.utils.isNewerVersion(game.version,"12.999")?"li.ui-control":"li.scene.nav-item")));
//# sourceMappingURL=token-action-hud-core.min.mjs.map
