import { MODULE_ID } from "./main.js";
import { TokenNotes } from "./app/TokenNotes.js";
import {getSetting} from "./settings.js";
import {l} from "./lib/utils.js";

export function initConfig() {
    Hooks.on("controlToken", (token, controlled) => {
        if (!getSetting("autoopen")) return;
        if (!TokenNotes.checkPermission(token)) return;
        if (controlled) {
            ui.TokenNotes.bind(token);
        } else {
            setTimeout(() => {
                if (!canvas.tokens.controlled.length) ui.TokenNotes.bind(null)
            }, 100);
        }
    });

    Hooks.on("renderTokenHUD", (app, html) => {
        const token = app.object;
        if (!TokenNotes.checkPermission(token)) return;
        const isNotesVisible = ui.TokenNotes.object === token;
        html = html[0] ?? html;
        const colLeft = html.querySelector(".left");
        const buttonHTML = `
    <div class="control-icon ${isNotesVisible ? "active" : ""}" id="toggle-token-notes">
        <img src="icons/svg/book.svg" width="36" height="36" title="${l("tokennotes.togglenotes")}">
        </div>
    `;
        colLeft.insertAdjacentHTML("beforeend", buttonHTML);
        const button = html.querySelector("#toggle-token-notes");
        button.addEventListener("click", (e) => {
            button.classList.toggle("active");
            const isBtnActive = button.classList.contains("active");
            isBtnActive ? ui.TokenNotes.bind(token) : ui.TokenNotes.close();
        });
    });
}
