import {MODULE_ID} from "./main.js";

const SETTING_CACHE = {};
const DEFAULT_CACHE = false;

export function registerSettings() {
    const settings = {
        autoopen: {
            name: "tokennotes.settings.autoopen.name",
            hint: "tokennotes.settings.autoopen.hint",
            scope: "client",
            config: true,
            type: Boolean,
            default: true,
        },
        allowplayers: {
            name: "tokennotes.settings.allowplayers.name",
            hint: "tokennotes.settings.allowplayers.hint",
            scope: "world",
            config: true,
            type: Number,
            choices: {
                  0: "tokennotes.settings.allowplayers.options.none",
                  1: "tokennotes.settings.allowplayers.options.readonly",
                  2: "tokennotes.settings.allowplayers.options.readwrite",
              },
            default: 0,
        },
        position: {
            name: "tokennotes.settings.position.name",
            hint: "tokennotes.settings.position.hint",
            scope: "world",
            config: true,
            type: String,
            choices: {
              "token-notes-bottom-left" : "tokennotes.settings.position.options.bottomleft",
              "token-notes-bottom-right" : "tokennotes.settings.position.options.bottomright",
              "token-notes-top-left" : "tokennotes.settings.position.options.topleft",
              "token-notes-top-right" : "tokennotes.settings.position.options.topright",
            },
            default: "token-notes-bottom-left",
            onChange: () => {
              ui.TokenNotes.setPosition();
            }
        },
    };

    registerSettingsArray(settings);
}

export function getSetting(key) {
    return SETTING_CACHE[key] ?? game.settings.get(MODULE_ID, key);
}

export async function setSetting(key, value) {
    return await game.settings.set(MODULE_ID, key, value);
}

function registerSettingsArray(settings) {
    for (const [key, value] of Object.entries(settings)) {
        if (!value.name) value.name = `${MODULE_ID}.settings.${key}.name`
        if (!value.hint) value.hint = `${MODULE_ID}.settings.${key}.hint`
        if (value.useCache === undefined) value.useCache = DEFAULT_CACHE;
        if (value.useCache) {
            const unwrappedOnChange = value.onChange;
            if (value.onChange) value.onChange = (value) => {
                SETTING_CACHE[key] = value;
                if (unwrappedOnChange) unwrappedOnChange(value);
            }
        }
        game.settings.register(MODULE_ID, key, value);
        if(value.useCache) SETTING_CACHE[key] = getSetting(key);
    }
}