import { MODULE_ID } from "./main.js";
import {flip} from "./Flip.js";
import {AUTO_FLIP} from "./app/tokenFlipConfig.js";
import {getSetting} from "./settings.js";

export function setupHooks() {
    if (!game.user.isGM) return;
    if(!getSetting("enableAutoFlip")) return;
    Hooks.on("updateActor", processAutoFlipMacro);
    Hooks.on("updateToken", processAutoFlipMacro);
    Hooks.on("updateItem", processAutoFlipMacro);
    Hooks.on("createItem", processAutoFlipMacro);
    Hooks.on("deleteItem", processAutoFlipMacro);

    Hooks.on("combatStart", (combat) => { processAutoFlip(combat, true); });
    Hooks.on("deleteCombat", (combat) => {processAutoFlip(combat, false);});
    Hooks.on("canvasReady", (canvas) => {
        if(!game.combat || game.combat.scene !== canvas.scene) return;
        processAutoFlip(game.combat, game.combat.started);
    });
}

async function processAutoFlip(combat, inCombat) {
    if(!game.users.activeGM.isSelf) return;
    const scene = combat.scene;
    if(!scene) return;
    const tokenDocuments = Array.from(scene.tokens);
    for (const tokenDocument of tokenDocuments) {
        const hasAutoFlip = tokenDocument.flags.tokenflip?.tokenfaces?.some((f) => f.autoFlip);
        if (!hasAutoFlip) continue;
        const currentFaceId = tokenDocument.flags.tokenflip?.currentId;
        for (const face of tokenDocument.flags.tokenflip.tokenfaces) {
            if (face.id === currentFaceId || !face.autoFlip) continue;
            const autoFlip = face.autoFlip;
            if (autoFlip === AUTO_FLIP.IN_COMBAT && inCombat) await flip(tokenDocument, face.id);
            if (autoFlip === AUTO_FLIP.OUT_OF_COMBAT && !inCombat) await flip(tokenDocument, face.id);
        }
    }
}

async function processAutoFlipMacro(...args) {
    const document = args[0];
    if (!game.users.activeGM.isSelf) return;
    const tokenDocument = extractTokenDocument(document);
    if (!tokenDocument) return;
    const hasAutoFlip = tokenDocument.flags.tokenflip?.tokenfaces?.some((f) => f.autoFlipMacro);
    if (!hasAutoFlip) return;
    const currentFaceId = tokenDocument.flags.tokenflip?.currentId;
    for (const face of tokenDocument.flags.tokenflip.tokenfaces) {
        if (face.id === currentFaceId || !face.autoFlipMacro) continue;
        const macro = fromUuidSync(face.autoFlipMacro);
        if (!macro) continue;
        const result = await macro.execute({tokenDocument, event: [this.hook, ...args]});
        if (result === true) {
            await flip(tokenDocument, face.id);
            return;
        }
    }
}

function extractTokenDocument(document) {
    if (document instanceof TokenDocument) return document;
    if (document.token) return document.token;
    if (document.parent?.token) return document.parent.token;
    return null;
}