import { MODULE_ID } from "./main.js";
import { TokenFlipConfig } from "./app/tokenFlipConfig.js";
import { FlipMenu } from "./app/flipMenu.js";
import { flip } from "./Flip.js";

export function initConfig() {
    Hooks.on("renderTokenConfig", (app, html, data) => {
        html = html[0];
        const configureTokenFlipBtn = document.createElement("button");
        configureTokenFlipBtn.classList.add("configure-tokenflip-btn");
        configureTokenFlipBtn.innerHTML = `<i class="fas fa-redo-alt"></i> ${game.i18n.localize("tokenflip.token-flip-config.title")}`;
        const wrapper = document.createElement("div");
        wrapper.classList.add("form-group");
        const label = document.createElement("label");
        label.innerHTML = game.i18n.localize("tokenflip.token-flip-config.title");
        wrapper.appendChild(label);
        wrapper.appendChild(configureTokenFlipBtn);
        html.querySelector(`[name="alpha"]`).closest(".form-group").after(wrapper);
        configureTokenFlipBtn.addEventListener("click", (e) => {
            e.preventDefault();
            const config = new TokenFlipConfig(app.token, app);
            config.render(true);
        });
        app.setPosition({ height: "auto" });
    });

    Hooks.on("renderTokenHUD", (app, html, data) => {
        const faces = app.object.document.getFlag("tokenflip", "tokenfaces") ?? [];
        if (!faces.length || faces.length < 2) return;
        html = html[0];
        const colRight = html.querySelector(".col.right");
        const tokenFlipBtn = document.createElement("div");
        tokenFlipBtn.classList.add("control-icon");
        tokenFlipBtn.dataset.action = "tokenflip";
        tokenFlipBtn.innerHTML = `<img src="icons/svg/daze.svg" width="36" height="36" title="${game.i18n.localize("tokenflip.token-flip-config.flip")}">`;

        let useMenu = false;
        let flipped = false;

        tokenFlipBtn.addEventListener("mousedown", (e) => {
            e.preventDefault();
            flipped = false;
            setTimeout(() => {
                if (!flipped) {
                    useMenu = true;
                    const menu = new FlipMenu(app.object, html);
                    menu.render(true);
                    flipped = false;
                } else {
                    useMenu = false;
                }
            }, 200);
        });
        tokenFlipBtn.addEventListener("mouseup", (e) => {
            if (useMenu) return (useMenu = false);
            flipped = true;
            flip(app.object);
        });

        colRight.appendChild(tokenFlipBtn);
    });
}
