## Version 2.20.2

### Bug Fixes

-   (stwlam) Restore "weapon:oversized" roll option on strikes
-   (stwlam) When under battle form effect, suppress damage roll notes not originating from form
-   (stwlam) Fix speed label-rendering issue on PC sheets

### Core System Improvements

-   (stwlam) Make death overlay always available from token HUD

### Data Updates

-   (Abaddon) Brushup Bestiary 1 copper, gold, and silver dragons
-   (Abaddon) Add wing deflection rules for blue dragons
-   (Abaddon) Fix white dragon aura formatting
-   (stwlam) Fix jaws label and deadly trait on Tyrannosaurus effect, foot attack type on Triceratops effect
-   (stwlam) Correct "reach" trait on fauchards
-   (Tikael) Fix some instances of incorrect resist all on NPCs
-   (Tikael) Remove unnecessary symbols from descriptions
-   (Tikael) Correct the poison label in spell traits
-   (Tikael) Correct range of Leshy and sprite ancestry strikes

## Version.2.20.1

### Bug Fixes

-   (stwlam) Fix setting of system token defaults
-   (stwlam) Restore compatibility with TokenHUD feature of Monk's Little Details module
-   (stwlam) Actually save selected actorsDeadAtZero setting
-   (stwlam) Fix drag/drop used from undocked tracker
-   (stwlam) Limit deference to Combat Enhancements module to just drag/drop
-   (Supe) Fix rest for the night for flexible spellcasting

## Version.2.20.0

### New Features

-   (stwlam) Significant update to the Encounter Tracker:
    -   Drag & drop initiative ordering, deferring to the Combat Enhancements module if found active
    -   Support for CTRL-clicking (blind) of initiative roll buttons
    -   Fully remove non-integer initiative values
    -   Tracker settings:
        -   Automatically mark NPCs as dead/defeated upon reaching 0 HP. Will be expanded in a future update to also cover PCs.
        -   Change the overlay icon used to mark dead/defeated tokens
-   (stwlam) Add support for module-registered homebrew elements
-   (stwlam) Add Metagame Knowledge setting to link visibility of token names in tracker and chat messages to player-visibility of token nameplates

### Bug Fixes

-   (Drental) Remove setting a default DC when no DC is supplied in an inline roll
-   (Drental) Allow to add property runes with ABP as fundamental runes
-   (In3luki) Fix NPC attack effects being removed when the actor has no source item
-   (stwlam) Fix issue causing Hefty Hauler and Lifting Belt to give double bonuses
-   (stwlam) Prevent sheet from rerendering twice when PC level is reduced
-   (stwlam) Refrain from fading back in the scene darkness adjuster when it's already rendered
-   (stwlam) Fix issue causing strikes that use alternative abilities from not being affected by conditions that penalties all checks based on those abilities
-   (stwlam) Fix styling bug causing text in tagify input fields to appear outside element
-   (stwlam) Refrain from showing damage buttons on rolls hidden from the user (typically blind or private GM)
-   (stwlam) Unequip items on loot actors so that rule elements aren't initialized

### Core System Improvements

-   (SoldierC4) Add creature table to XP macro
-   (stwlam) Add support for indicating that a strike on a PC (e.g., many Monk stance attacks) replace all other strikes
-   (stwlam) Adjust "ability"-type FlatModifier REs to require the specification of an ability
-   (stwlam) Show new darkness level on adjuster when changed via other than moving the slider thumb
-   (stwlam) Add a `toggleCondition` method to ActorPF2e
-   (stwlam) Have ChoiceSet RE accept an empty string as a selection
-   (stwlam) Add support for data references to the damageType property on FlatModifier rule elements
-   (stwlam) Have sense labels on PCs and familiar sheets show range and acuity when appropriate
-   (Supe) Show breakdown for spell save buttons if the user is an owner or GM

### Data Updates

-   (Abaddon) @Template - remove damaging option
-   (Abaddon) Add spellcaster variants for blue dragons
-   (Abaddon) Brushup blue, brass, bronze, green, red, white dragons
-   (Abaddon) Refactor @template inline buttons
-   (ArthurTrumpet) Add spell effect links to Nature Incarnate spells
-   (Bennyty) Add Alternate Nyarlathotep
-   (Bennyty) Correct area of Spray of Stars spell
-   (Bennyty) Fix areas and traits for Oracle spells
-   (Bolt) Correct category of Energized Cartridge
-   (cepvep) Correct Blood Ward to not be a Cantrip
-   (cepvep) Add the Master Abilities for Familiars
-   (Crusufix) Correct rarity of Ring of Discretion
-   (Drental) Add missing hazards from PFS season 1
-   (Friz) Correct Description of Xulgath Abilities
-   (Friz) Update description of Xulgath Demon Caller abilities
-   (LebombJames) Change "1 to 3" actions glyph to be more clear
-   (rectulo) Add prerequisite in Sniper's Aim
-   (rectulo) Add the sentence for the effects of each type of Clockwork Goggles
-   (rectulo) Correct a link in the Deflecting Shot feat description
-   (rectulo) Fix formatting of Black Powder Boost, Friendly Toss, Hair Trigger, Immaculate Holsters, Power Slide feats
-   (rectulo) Re-ordering sentences in the Pistolero's Challenge feat
-   (rectulo) Fill in description of Elemental Bulwark feat
-   (SoldierC4) Correct actions for the Gunner's Bandolier
-   (SoldierC4) Add formula and description to hero point deck
-   (SoldierC4) Fix XP macro reward and rating values, localize
-   (SpartanCPA) Standardize distance format of Aura abilities
-   (SpartanCPA) Remove duplicate copy of Gunslinger "Incredible Senses"
-   (SpartanCPA) Normalize speed types on old NPCs
-   (SpartanCPA) Normalize old spellcastingEntry items in NPCs
-   (SpartanCPA) Lock stances to one strike where appropriate
-   (SpartanCPA) Get rid of Foundry default "Mystery Man" icons in packs
-   (SpartanCPA) Fix typo in range of "Lose the Path"
-   (SpartanCPA) Fix some formatting issues in Bon Mot
-   (SpartanCPA) Fill in speed details field where appropriate on NPC sheets
-   (SpartanCPA) Ensure that Persistent Damage is properly typed
-   (SpartanCPA) Ensure new lines in NPC text where needed
-   (SpartanCPA) Ensure Effect is on a new line from Trigger/Requirement
-   (SpartanCPA) Correct traits of "Energized Cartridge"
-   (SpartanCPA) Correct the traits of the Fire Mephit
-   (SpartanCPA) Correct the name of "Shooter's Camouflage"
-   (SpartanCPA) Correct the book source for Rituals
-   (SpartanCPA) Correct the action cost for "Skip Between"
-   (SpartanCPA) Correct range on "Crushing Despair"
-   (SpartanCPA) Correct predicates of "+1 Saves vs Magic" features
-   (SpartanCPA) Correct persistent bleed on Extinction Curse monster
-   (SpartanCPA) Audit the Dullahan
-   (SpartanCPA) Audit Belcorra Haruvex
-   (SpartanCPA) Add a strike rule element to Lion's Shield
-   (SpartanCPA) Add rollable touch damage to the Mantle spells
-   (stwlam) Set appropriate consumable types according to traits
-   (stwlam) Ensure that initial size of Animal Form spell effects is medium until level 4
-   (stwlam) Add range to Wind Crash attack
-   (stwlam) Add license covering all Rexard icons
-   (Tikael) Finish Age of Ashes 4 Brushup
-   (Tikael) Correct description of Channel Life Force hero point card
-   (Tikael) Correct damage type of Harmona Gun
-   (Tikael) Correct and update Flaming Star descriptions
-   (Tikael) Brushup Age of Ashes book 3
-   (Tikael) Add missing creature from Troubles in Otari adventure
-   (Tikael) Add automation for Scales of the Dragon feat
-   (VestOfHolding) Add most missing spell and ancestry trait descriptions

## Version 2.19.3

### Bug Fixes

-   (stwlam) Fix rerolling checks from chat messages
-   (stwlam) Fix rolling initiative from encounter tracker excluding roll options
-   (stwlam) Restore target roll options on strikes

## Version 2.19.2

### Bug Fixes

-   (stwlam) Fix initiative rolls not persisting when rolling for multiple actors
-   (stwlam) Fix compendium browser not finding weapons by category or group
-   (Supe) Fix chat messages for spell attack rolls not having references to their originating items

### Content Updates

-   (Abaddon) Brushup blue dragons in Bestiary 1
-   (rectulo) Correct level of the Eagle Eye and Firearm Expert feat
-   (SpartanCPA) Fix dedication resiliency feats

### Core System Improvements

-   (tropic) Add source field to item sheets

## Version 2.19.1

### Bug Fixes

-   (Supe) Fix spell attack rolls not displaying target AC
-   (stwlam) Fix actor sheets being ostensibly editable in locked compendia
-   (stwlam) Fix update path to hero points when rerolling from chat cards
-   (stwlam) Fix typo in @Localize syntax on Scarlet Triad Agent
-   (stwlam) Fix renamed attack effects appearing as slugs on NPC sheets

### Content Updates

-   (rectulo) Fix rain of bolts feat prerequisites
-   (rectulo) Fix formatting of arcane slam feat
-   (rectulo) Fix formatting of the core cannon feat
-   (SpartanCPA) Update Erinys and the variants in AV Book 2
-   (stwlam) Fix typo in Caligni Vanguard's Death Blaze ability

### Core System Improvements

-   (Bolt) Make Strike RE assume melee when range not specified
-   (stwlam) Add self: and origin: contextual roll options for use by rules elements
-   (stwlam) Tidy up Strike rule element, have it accommodate invalid/omitted range properties

## Version 2.19.0

### New Features

-   (stwlam) Add a scene-darkness adjuster to lighting controls
-   (stwlam) Add a `LinkedProficiency` rules element and add to all weapon-familiarity ancestry feats
-   (stwlam) Add a `ChoiceSet` rules element and reference implementation with Canny Acumen
-   (stwlam) Add a means of selecting a skill for NPC initiative rolling
-   (stwlam) Set a `tiebreakPriority` in initiative data, boost priority via certain items
-   (stwlam) Add support for physical-item homebrew traits

### Bug Fixes

-   (stwlam) Fix thrown dart-group weapons requiring ammunition
-   (stwlam) Refrain from treating ability modifiers like bonuses or penalties
-   (stwlam) Fix "take item" links sometimes having duplicate click listeners in compendium browser
-   (stwlam) Fix bug causing reversion of token condition icon theme on reload
-   (stwlam) Fix bug causing reroll options to appear in damage message context menu
-   (stwlam) Fix migrations of items on synthetic actors
-   (stwlam) Have BattleForm rule elements suppress Striking rule elements
-   (Supe) Fix elite/weak level endlessly updating for legacy npc sheet

### Content Updates

-   (Cora, Kyle S, Dods, ae4355, xdy, and Tikael) Add remaining Guns & Gears and LO: Grand Bazaar items
-   (Abaddon) Bestiary 1- Brush up Golems
-   (Abaddon) Update to sense selector: styling and acuity support
-   (Abaddon) Brush up monsters in Bestiary 1 (D-E)
-   (Abaddon) Bestiary 1: general brushup of chromatic and metallic dragons
-   (Abaddon) Add range increment 75ft for elemental hurricane
-   (ArthurTrumpet) Added Nature Incarnate spell effects
-   (ArthurTrumpet) Update Dragon forms to use rule element type battleform
-   (cepvep) Add IWR to Spells F-H
-   (Cora) Add the SoT3 items and their effects
-   (Drental) Add the Actors and Hazards from PFS Scenario 3-02
-   (Drental) Fix subtypes offirst-level consumables
-   (Drental) Add automation to Megaton Strike feat
-   (Drental) Fix a typo in Giant Animated Statue
-   (Flash Granola) Add several physical-item descriptions
-   (Friz) Fix save button on Retributive Pain spell
-   (Friz) Update Commanding Lash spell to fix issue with save button
-   (Friz) Update items missing Incapacitation traits in the inline roll buttons
-   (Friz) Fix spelling error in Vrykolakas pestilential aura
-   (fryguy) Add radiation damage trait
-   (fryguy) Change avatar cast time to 2 actions
-   (fryguy) Add missing coven spells to named hags
-   (fryguy) Replace hard-coded hefty hauler/lifting belt code with an AE-Like rules elements
-   (rectulo) Add content from Threshold of Knowledge
-   (rectulo) Fix Breath Blaster activation (2 actions) and delete the activate sentence without automation
-   (rectulo) Fix a typo in cold-comfort-lesser
-   (rectulo) Correct the level of the Big Rock Bullet (Major)
-   (rectulo) Fix a typo in the Greater Deed of The Way of the Drifter
-   (rectulo) Fix formatting of deeds in the way of the spellshot
-   (rectulo) Fix formatting of mudrock snare description
-   (rectulo) Fix format for Alchemical Shot feat
-   (rectulo) Fix the level of the crushing (greater) rune
-   (SpartanCPA) Add the new Archetype feats, spells, and spell effects from SoT book 3
-   (SpartanCPA) Add AdjustDegreeOfSuccess to Forlorn
-   (SpartanCPA) Add new traits for SoT 5
-   (SpartanCPA) Add crosslinks to SoT4
-   (SpartanCPA) Correct the flavor text of the Winter Patron
-   (SpartanCPA) Add Poison to spell traits
-   (SpartanCPA) Remove the extra blank line in Red-Rib Gill Mask
-   (SpartanCPA) Add new weapons, spells, effects, and traits from SoT book 4
-   (SpartanCPA) Add sources where NPC were missing them
-   (SpartanCPA) SoT 5 - Add equipment and spells
-   (SpartanCPA) Change Phylactery to Soul Cage
-   (SpartanCPA) Add Formian and Ikeshti languages
-   (SpartanCPA) Correct minor issues with Creature Family abilities
-   (SpartanCPA) Add Vampire, Vrykolakas, Worm That Walks and Ravener template abilities
-   (SpartanCPA) Add NPCs from SoT5
-   (SpartanCPA) Add archetype feats for SoT4
-   (SpartanCPA) Add items from Summit & Sundry
-   (SpartanCPA) Add swamp stride to movement details of Boggards
-   (SpartanCPA) Add items from Tesyovensku’s Warehouse
-   (SpartanCPA) Correct name of "Directed Poison"
-   (SpartanCPA) Add new NPCs from Bounty 16
-   (SpartanCPA) Fix the source of the `Geas` spell
-   (SpartanCPA) Re-standardize save inline button text format
-   (stwlam) Automate Monastic Weaponry
-   (stwlam) Add a fly speed to the Witchfire Warden
-   (stwlam) Migrate spells to clamp level between 1 and 10
-   (stwlam) Add an inventor class icon
-   (stwlam) Set price of Conflagration Club
-   (stwlam) Fix change mode of Magic Warrior Aspect and Magic Warrior Transformation
-   (stwlam) Remove extra focus point included in Wave Order, tune other Druid Order FP REs
-   (stwlam) Add will-save proficiency increase to the Stubborn class feature
-   (stwlam) Correct default vehicle immunities
-   (stwlam) Add several icons for new equipment and spells
-   (Tikael) Add action macro for Whirling Throw feat
-   (Tikael) Add automation for Scales of the Dragon feat
-   (Tikael) Correct price of Genius Diadem
-   (Tikael) Add area to Astral Labyrinth spell
-   (Tikael) Add Air, Water, and Clockwork armor traits, Aura consumable trait, Steam hazard trait
-   (Tikael) Add missing translation string and firearm usage
-   (Tikael) Add hazards and vehicles from Guns & Gears
-   (Tikael) Add all remaining usages from Guns & Gears
-   (Tikael) Add rule elements to SoT 4 feats
-   (Tikael) Normalize source for Guns & Gears
-   (Tikael) Add effects for Relic & Rememberence equipment
-   (Tikael) Add automation for gunslinger class DC advances
-   (Tikael) Add effect for Distracting Feint feat
-   (Tikael) Allow for word wrap of resistances with long exceptions
-   (Tikael) Automate noqual and spellguard shields
-   (Tikael) Add equipment from Pathfinder: Fumbus comic book
-   (Tikael) Correct actions for Fulminating Shot
-   (Tikael) Add items from "The Rune Room" shop in LO:GB
-   (Tikael) Add Skyrider Sword
-   (Tikael) Add "Unscathed Blade" items from Grand Bazaar
-   (Tikael) Add "Resplendent Rose" and "Urban Garden" from Grand Bazaar
-   (Tikael) Add Hero Point Deck journals and rolltable.
-   (Tikael) Add actors for PFS Scenario 3-05
-   (Tikael) Correct class DC for Way of the Spellshot
-   (TMun) Add the Pathfinder:Fumbus! comic to the license file
-   (VestOfHolding) Adding equipment from Morhen's Mobility Apparel
-   (VestOfHolding) Adding everything from the Reclaimed Paradise Wares shop
-   (VestOfHolding) Adding nonmagical attacks immunity
-   (VestOfHolding) Adding equipment from Relics & Rememberance Wares
-   (xdy) Clean up deity journal entries, add a handful of missing entries for deities and pantheons

### Core System Improvements

-   (Abaddon) Add "speed details" text field to NPC sheet
-   (Drental) Allow use of CTRL/META and SHIFT on recovery checks
-   (Drental) Allow import of forge image links
-   (Drental) Move loot/merchant information into tooltip on loot-actor sheets
-   (Eddie) Add Proficiency Without Level support to Formula DCs
-   (Eddie) Add Crafting Entry, which are drawn from class features and feats
-   (Friz) Add roll note to actions/spells with the incapacitation trait to make it more obvious for GMs
-   (stwlam) Instead of hiding scene settings managed by rules-based vision, show them disabled a message
-   (stwlam) Tidy up markup, css, and event listener of Effects Panel
-   (stwlam) Ensure presence of traits array on combo weapon melee-usage properties
-   (stwlam) Localize title of popped out Encounter Tracker
-   (stwlam) Tweak styling of pf2e-theme journal-entry tables
-   (stwlam) Add base items to weapon attack & damage selectors
-   (stwlam) Show level and price tooltips for weapons adjusted by materials and runes
-   (stwlam) Add adjustment and comparison methods to actor-size code
-   (stwlam) Formally end support for Active Effects in the system
-   (stwlam) Add a dedicated record of vehicle traits (just one!)
-   (stwlam) Link proficiencies among equivalent base weapons (e.g., longbow and composite longbow)
-   (stwlam) Automate the Kickback trait
-   (stwlam) Change default setting of "Experimental damage formatting" back to disabled
-   (stwlam) Remove ability property from weapon data, tie some traits to ranged or melee weapons
-   (stwlam) Skip preparing strikes for weapons with a quantity of zero
-   (stwlam) Disable the roll-initiative button if there is no active encounter
-   (stwlam) Expand and align weapon & armor item cards
-   (Supe) Make spellcasting attack rolls and DCs selectable by rules elements
-   (Supe) Remove all code support for defaultRollOptions

## Version 2.18.3

### Bug Fixes

-   (stwlam) Fix attack rolling from weapon icons on PC actions tab
-   (stwlam) Fix changing proficiency of lore skills on PC sheet

## Version 2.18.2

### Bug Fixes

-   (stwlam) Remove player-visibility of price and other properties from mystified items
-   (stwlam) Restore presence of traits inherited from a PC's ancestry
-   (stwlam) Fix generation of malformed data causing breakage of some combination weapons
-   (stwlam) Fix display of NPC/Battle Form attack traits

### Content Updates

-   (Abaddon) Brush up monster A-C in Bestiary 1
-   (cepvep) Update immunities/weaknesses/resistances on battle form spells A-E
-   (Flash Granola) Updated Kyra iconics to add Scimitar proficiency
-   (rectulo) Fix description of the Rampart Shield
-   (rectulo) Correct the description of the static snare
-   (SpartanCPA) Add "Structure" trait and "Affixed to Headgear" worn option
-   (SpartanCPA) Add "Worn Bracelet" equipping option
-   (SpartanCPA) Add action cost to Steal Shadow
-   (SpartanCPA) Correct Alghollthu language on several NPCs
-   (SpartanCPA) Remove duplicate "Tremorsense" sense
-   (SpartanCPA) Fix Sources incorrectly pointing to Bestiaries
-   (SpartanCPA) Move monsters from Little Trouble in Big Absalom into the One Shot Bestiary
-   (SpartanCPA) Add the Magic Items from Strength of Thousands book 4
-   (stwlam) Remove token icons from PFS mentor boons
-   (Tikael) Remove extraneous properties from Oozemorph rule elements
-   (Tikael) Add Gears character backgrounds

### Core System Improvements

-   (SkepticRobot) Reduce minimum height of PC-sheet biography fields and remove capitalize transform from personality field
-   (stwlam) Always allow casting from innate NPC entries with 0 max slots
-   (stwlam) Have the BattleForm rule element disable Automatic Bonus Progression

## Version 2.18.1

### Bug Fixes

-   (Abaddon) Fix localization of NPC skills
-   (stwlam) Fix editing NPC skills from a compendium
-   (stwlam) Fix localization of homebrew attack proficiencies on PC sheet
-   (stwlam) Fix bug preventing item level from being editable on feat and spell sheets
-   (stwlam) Fix damage and critical button tooltips on PC sheet

### Content Updates

-   (ArthurTrumpet) Update Plant Form spell effects to use BattleForm rule element
-   (Drental🤖) add ability score automation to all apex items
-   (InfamousSky) Add missing trigger reaction to Sand Whirlwind Hazard
-   (InfamousSky) Add area to Tangling Creepers spell
-   (InfamousSky) Add link to Wronged Monk's Wrath spell in corresponding feat
-   (InfamousSky) Fix will saves and attack traits in Arms of Balance
-   (Neginea) Add journal entries for Beast Gunner and Bullet Dancer archetypes
-   (rectulo) Fix a typo in Inventor class
-   (rectulo) Fix formatting of the Poppet ancestry description
-   (SpartanCPA) Italicize several hundred links to spells in item descriptions
-   (Supe) Add negative damage and area size to Eclipse Burst

### Core System Improvements

-   (Abaddon) Improve type definitions of PC sheet

## Version 2.18.0

### New Features

-   (stwlam) Add basic support for defining and using combination weapons
-   (stwlam) Track tradition proficiencies on new PCs throughout leveling
-   (stwlam) Update the EffectTarget rule element to be a prompt with a definable set of choices

### Bug Fixes

-   (SpartanCPA) Correct bulk calculation for 5 round increments
-   (stwlam) Fix functionality of land speeds created by the BaseSpeed rule element
-   (stwlam) Fix inability to change fundamental runes of specific magic weapons

### Content Updates

-   (Abaddon) Bestiary 1: Brush up Bunyip, Eels and Apes
-   (ArthurTrumpet) Update Monstrosity Form effects with BattleForm rule element
-   (Drental) Add a bonus toggle to the Ten Paces class feature
-   (Drental) Fix save label and add aura/inline save to frightful presence
-   (fryguy) Rename Agents of Edgewatch NPCs to match style guide
-   (kageru) Fix typo in precious munitions name
-   (Neginea) Add journal entry for artillerist archetype
-   (Neginea) Fix spelling of "Cannon Corner Shot" feat name
-   (rectulo) Correct prerequisites of Expert Magus Spellcasting
-   (rectulo) Fix formatting in Aberrant Form spell, Trapsmith Dedication prerequisties, and Duskwalker heritage
-   (rectulo) Remove uneeded HTML entities in Wyrwood Sneak description
-   (rectulo) Correct typos and formatting in Rainfall Orc ancestry feature
-   (redeux) Add Actors for PFS 3-04 and B15. Audit of Iron Command reaction
-   (redeux) Correct Biloko Veteran's longspear attack as printed in LO: Mwangi Expanse and PFS 3-03
-   (SpartanCPA) Add the two remaining "Cobbled" guns
-   (SpartanCPA) Add Combination Weapons from Guns and Gears
-   (SpartanCPA) Ensure there are no empty labels in save buttons
-   (SpartanCPA) Add ammo to the One Shot Pregens
-   (SpartanCPA) Remove Herexen from One-Shot Bestiary
-   (stwlam) Add rounds for every firearm
-   (stwlam) Fill in icons for several Guns & Gears items
-   (Tikael) Correct typo in Gunslinger description
-   (TMun) Audit creatures used in PFS Bounties 13 and 14
-   (TMun) Add copyright notices for PFS 3-04 to 3-08 and Bounties 15 to 17, as well as missed free adventures
-   (VestOfHolding) Add items from The Grand Bazaar's Merrygleam shop
-   (xdy) Normalize languages on NPCs

### Core System Improvements

-   (SpartanCPA) Sum bulk from multiple firearm ammunition stacks
-   (SpartanCPA) Update Zakzak for One-Shot 3 errata
-   (stwlam) Check well-formedness of "roll-option" property on FlatModifier rule elements
-   (stwlam) Exclude minions from initiative rolling
-   (stwlam) Add a system of "other tags" to weapons
-   (stwlam) Remove overflowing behavior of sidebar on PC sheet
-   (stwlam) Skip removing class feats when removing a class from a PC
-   (stwlam) Add tooltips to item, spell, and strike traits appearing in chat cards
-   (Supe) Show "Item X" label in the item sheet for physical items, feats, and spells

## Version 2.17.1

### Bug Fixes

-   (SkepticRobot) Fix bulk calculation for tiny PCs
-   (stwlam) Fix display of NPC attack effects coming from inventory items
-   (stwlam) Fix display of AC details on the NPC sheet
-   (stwlam) Fix darkvision and speed-increasing familiar abilities
-   (stwlam) Fix paths of hover d20 icons for when Foundry is served from a URL path lower than root
-   (stwlam) Ensure explicitly-marked damage rolls total to at least 1

### Content Updates

-   (SpartanCPA) Adjust the "Quadruped" feat to override Speed rather than add
-   (SpartanCPA) Fix damage types in several inline damage-roll links
-   (SpartanCPA) Add sources to equipment with a blank source field
-   (SpartanCPA) Add One Shot #3: Head-Shot the Rot
-   (SpartanCPA) Make a variant of the Throwing Knife to account for differences in publications
-   (SpartanCPA) Correct typo in name of "Portrait of Spite"
-   (SpartanCPA) Add emanation templates to all Auras
-   (SpartanCPA) Utilize @Localize for the remaining glossaried NPC abilites
-   (TMun) Correct damage die size for Reflective Ripple Stance effect
-   (TMun) Correct Buzzsaw Axe displayed save type from Fortitude to Reflex
-   (TMun) Fix spelling of "propulsion" in Arcane Propulsion feat
-   (TMun) Correct physical resistance amount in Pest Form spell effect
-   (TMun) Fix several data and description errors in Night of Gray Death NPCs
-   (Tikael) Change Bellflower Tiller speed bonus to status
-   (Tikael) Add Guns & Gears accessories from tables 4-4 and 4-5
-   (Tikael) Add Guns & Gears mundane and magical ammunition
-   (TofuSlicer) Add Grand Bazaar base weapons from pages 105-107, aside from Switchscythe
-   (fryguy) Fix data spellcasting data structure of Agents of Edgewatch NPCs
-   (InfamousSky) Correct save types of abilities belonging to the Mage of Many Styles
-   (redeux) Add Fulu images contributed by artist Shakespar to equipment.db
-   (rectulo) Fix a typo in a rollable button of the "Summon Kaiju" spell
-   (rectulo) Fix formatting of Elemental Gift spell description
-   (Abaddon) Brush up Bestiary 1 giants
-   (ArthurTrumpet) Update Insect Form effects with BattleForm rule element
-   (VestOfHolding) Update Aberrant Form effects with BattleForm rule element
-   (SkepticRobot) Fill in missing abilities and other data among Bestiary 1 vampires
-   (Sasmira) Replace deity icons with fresh copies and less-lossy compression
-   (stwlam) Add more icons to newer weapons, replace some older ones

### Core System Improvements

-   (Tikael) Add "Fey" to the list of options for consumable traits
-   (Chup) Fix vehicle inventory styling
-   (Chup) Adjust NPC sheet styling (header and notes)

## Version 2.17.0

### Bug Fixes

-   (stwlam) Fix displaying and editing monster level for weak and elite monsters
-   (stwlam) Fix display of traits on melee-item sheet
-   (stwlam) Fix armor dexterity cap when armor check penalty is zero. Closes #1806
-   (In3luki) Fix rerolls using disabled modifiers (again)
-   (Tikael) Prevent fatal aim trait from being interpreted as fatal. Closes #1795
-   (Chup) Fix hazard sheet rarity
-   (fryguy) Fix immunities not being grayed out on the NPC sheet if they are empty
-   (nikolaj-a) Fix armor check penalty for skill checks done as initiative

### New Features

-   (Abaddon) Add support for `@Template` syntax in most texts
-   (Tikael) Add partial support for the dual class variant rule, by opening up feat slots
-   (stwlam) Add support for predicated Sense rule elements
-   (SkepticRobot) Expand the biography section with missing fields from official character sheet. Closes #1083
-   (SkepticRobot) Add a limited NPC sheet, as well as an option to specific a small blurb for the NPC. Closes #1125 and #1716

### Content Changes

-   (SpartanCPA) Remove monsters from Little Trouble in Big Absalom compendium that are unchanged from the Bestiaries
-   (SpartanCPA) Give template monsters from Agents of Edgewatch generic names
-   (SpartanCPA) Capitalize Gigavolt feat name. Closes #1792
-   (SpartanCPA) Fix formatting of witch description
-   (SpartanCPA) Remove unnecessary roll options from rule elements
-   (SpartanCPA) Use `@Localize` for descriptions of common abilities, plus a few other things like at-will spells
-   (SpartanCPA) Brush up of Bestiary 1 barghests
-   (SpartanCPA) Italicize spell links in class, equipment, and spell descriptions, as well as monsters from Bestiary 1 through 3
-   (SpartanCPA) Correct the horizontal line in _control weather_ ritual description
-   (SpartanCPA) Fix Blade Ally: Disrupting Rune to target only undead enemies. Closes #1420
-   (SpartanCPA) Remove bad formatting made by copy paste from Paizo PDFs
-   (SpartanCPA) Add ghost creature abilities from Abomination Vaults book 3
-   (SpartanCPA) Add new graveknight abilities from Strength of Thousands book 4
-   (SpartanCPA) Add creature abilities for visitant from Extinction Curse book 2
-   (rectulo) Fix typo in grim sandglass, greater grim sandglass, and greater blade of four energies descriptions
-   (rectulo) Fix formatting for underworld dragon breath, clockwork cloak, staff of nature's cunning, and _zero gravity_ descriptions
-   (rectulo) Fix damage roll format for _concordant choir_ spell
-   (rectulo) Remove trained proficiency in arcana from Summoner
-   (Bolt) Fix skill selection for backgrounds with multiple options
-   (Tikael) Brush up of Age of Ashes book 4 NPCs
-   (Tikael) Add poppet and automaton heritages
-   (Tikael) Add missing ancestry features from Guns & Gears
-   (Tikael) Add the firearm bonus to singular expertise
-   (Tikael) Add automation for twitchy feat
-   (Tikael) Add versatile fire and fix versatile positive weapon traits
-   (InfamousSky) Add icons to Gunslinger features
-   (InfamousSky) Add icons to Inventor class features
-   (cepvep) Brush up _collective transposition_ and _triple time_ spells
-   (cepvep) Add automation for remaining orc ancestry feats
-   (cepvep) Add immunity/weakness/resistance rule elements on effects for spells starting with A through E
-   (TMun) Correct _pillar of water_ to primal instead of occult spell. Closes #1791
-   (TMun) Remove roll options to fix panache and vivacious speed. Closes #1787
-   (TMun) Remove roll options from Barbarian to fix fast movement feat
-   (TMun) Correct typo of Ghostly Portal Paint. Closes #1783
-   (TMun) Correct spelling of _nature's reprisal_ spell and links. Closes #1793
-   (TMun) Add NPCs from Strength of Thousands book 3 and 4
-   (stwlam) Remove any use of the "Giant" language and replace with "Jotun"
-   (stwlam) Convert rations to a consumable with seven uses
-   (stwlam) Add icons for the poppet and automaton ancestries
-   (stwlam) Add icons to some weapons from Guns and Gears
-   (stwlam) Clean up reference implementation of darkvision conditional on ancestral low-light vision
-   (xdy) Fix table styling for a lot of compendium entries
-   (n1xx1) Remove cantrips and level suffix from NPC spell entries
-   (Abaddon) Brush up of Bestiary 1 arboreals and aeons
-   (Abaddon) Update all caligni and add call to blood effect
-   (VestOfHolding) Add automation to sylph and tiefling
-   (VestOfHolding) Update Weapon Tricks feature. Closes #1797
-   (VestOfHolding) Add inventor weapon expertise automation. Closes #1788
-   (VestOfHolding) Add an effect for Dread Marshal Stance. Closes #1704
-   (Drental) Add hazard and NPC from Pathfinder Society season 3 bounty 14
-   (nikolaj-a) Set result of treat wounds check to be visible for all users
-   (TofuSlicer) Fix reflective ripple damage type
-   (SkepticRobot) Add resistance rules to ancestries and heritages
-   (ArthurTrumpet) Change _animal form_ spell effects to use BattleForm rule elements
-   (ArthurTrumpet) Change _aerial form_ spell effects to use Battleform rule elements
-   (redeux) Add formation training hobgoblin ancestry feat effect

### Core System Improvements

-   (stwlam) Add setting to disable token autoscaling
-   (stwlam) Swap out absolute path to UPW logo for relative path
-   (stwlam) Accommodate very long alternate-token filenames in the token sheet
-   (stwlam) Expand weapon-hands coverage to new weapons
-   (stwlam) Add an extra note for boons in Pathfinder Society play in support of the United Paizo Workers
-   (stwlam) Fill out damage dice of brilliant and greater brilliant runes
-   (stwlam) Allow FlatModifier rule elements on familiars
-   (Supe) NPC actions are now enriched with roll data, including the item's name
-   (Supe) Construct localized Spell Scaling Interval label using formatting instead of lookup
-   (Drental) Add fields to the sheet to edit the source information of NPCs
-   (Friz) Fix to NPC spell-attack-roll to show target, degree of succes, and DC. Closes #1732
-   (Chup) Remove hover effect of character sheet ability score label
-   (Chup) Slight adjustment of proficiency colors to improve differentiation
-   (In3luki) Add "Use" button to NPC attack effects from consumables
-   (nikolaj-a) Hide empty ammunition option groups in actions tab
-   (nikolaj-a) Re-align icon on the triple damage button
-   (nikolaj-a) Add weapon group as an option to strike attack and damage rolls
-   (nikolaj-a) Consolidate weapon property rune information, and allow expansion by modules

## Version 2.16.4

### Announcement: United Paizo Workers

Redmond, WA (October 14th, 2021) — Today, the workers at Paizo, Inc – publisher of the Pathfinder and Starfinder roleplaying games – are announcing their formation of the United Paizo Workers union (UPW), with the Communication Workers of America’s CODE-CWA project. This union is the first of its kind in the tabletop roleplaying games industry.

[https://unitedpaizoworkers.org](https://unitedpaizoworkers.org/)

## Version 2.16.3

### Bug Fixes

-   (Supe) Fix error when opening token configuration dialog
-   (Supe) Fix display of traits in action sheet
-   (Chup) Fix styling of item and hazard traits if more than two lines are displayed
-   (stwlam) Fix rendering of homebrew traits on actor sheets

### Content Changes

-   (n1xx1) Remove duplicate `concussive` trait description

## Version 2.16.2

### Bug Fixes

-   (Chup) Fix to CSS for PC inventory sheet so floating shield icon shows up. Closes #1782

### New Features

-   (stwlam) Impose an equipped shield's speed penalty, if any
-   (Supe) Weapons can be equipped and unequipped from the strike list on PCs

### Content Changes

-   (TMun, Tikael, stwlam, VestOfHolding, SpartanCPA, fryguy) Content from newly released books:
    -   Guns & Gears: Archetypes, classes, class features, feats, equipment
    -   Lost Omens: Grand Bazaar: Ancestry, archetypes, equipment, and vehicles
    -   Strength of Thousands book 3 and 4: NPCs
    -   Night of the Gray Death: Equipment, NPCs, and spells
-   (TMun, VestOfHolding, Tikael, stwlam) Adds runes and missing traits for Guns & Gears and Lost Omens: Grand Bazaar
-   (SpartanCPA) Add healing type to Healer's Gloves roll buttons
-   (SpartanCPA) Make NPC Rage a `RollOption` element
-   (SpartanCPA) Move Goblin Scuttle and Wind Up to Creature Family Ability Glossary
-   (SpartanCPA) Brush up of viper swarm
-   (SpartanCPA) Add a variant icon for Immunity to Guidance
-   (SpartanCPA) `@Localize` Attack of Opportunity
-   (rectulo) Fix formatting of _power word kill_ and _lose the path_ spell descriptions
-   (rectulo) Fix typo in _spray of stars_ spell description
-   (rectulo) Add missing sentence to greater retrieval prism description
-   (InfamousSky) Fix area, change to attack type, and add inline damage to _black tentacles_ spell. Closes #1778
-   (InfamousSky) Add icons to Secrets of Magic Elementalist focus spells
-   (InfamousSky) Add icons to summoner class features
-   (Zaquariah) Add _pocket library_ spell effect
-   (Zaquariah) Ensure existing battleform effects don't benefit from Automatic Bonus Progression
-   (stwlam) Add base gun weapon types
-   (stwlam) Set hands/usage types for weapons
-   (xdy) Add source to equipment, remaining Strength of Thousands hazards, Malevolence NPCs
-   (TMun) Add a note regarding conflux spells to all magus focus spells. Closes #1738
-   (cepvep) Add automation for orc ancestry feats levels 1 through 5
-   (Shakespar) Add a pair of fulu icons

### Core System Improvements

-   (SpartanCPA) Update Bestiary Ability Glossary with `@Localize`
-   (Tikael) Allow line templates to be made wider than 5 ft
-   (stwlam) Separate out NPC attack traits from weapon traits
-   (stwlam) Refrain from including NPC attack effects as damage traits
-   (stwlam) Save item UUID instead of source ID to a formula to allow for derivative-item crafting
-   (stwlam) Enforce minimum batch sizes for crafting
-   (Supe) Ammo consumption message can be localized, new messages for partial consumption and exhausted
-   (Supe) Improve support for ranged weapons with the `repeating` trait

## Version 2.15.2

### Bug Fixes

-   (stwlam) Fix rule element stat references with erroneous `data` prefix
-   (stwlam) Fix AC bonus on runed explorer's clothing
-   (stwlam) Merge JSON actor/item import data with latest system model
-   (stwlam) Replace items containing AE-based flat modifiers with latest versions (tough, toughness, and mountain's stoutness)
-   (stwlam) Fix setting of defaults for BattleForm rule elements
-   (stwlam) Ensure newly created owned physical items are unequipped
-   (stwlam) Ensure already-deleted items aren't re-deleted during a migration
-   (Supe) Delay ammo consumption until _after_ the attack roll is made, not before

## Version 2.15.1

### Bug Fixes

-   (stwlam) Fix item transfers between actors
-   (stwlam) Separate Risky Surgery slashing damage from Treat Wounds healing roll

## Version 2.15.0

### Bug Fixes

-   (r2roberts) All NPC skills and perception should send their DCs to the roll method. Closes #1749
-   (stwlam) Prevent dumping of kit contents from altering source items. Closes #1675
-   (stwlam) Fix bug in Rest for the Night macro causing focus pool size to increase
-   (stwlam) Make the "add" button in the check dialog not cause a reload of the Foundry client
-   (stwlam) Fix application of multiple immunity/weakness/resistance rule elements
-   (stwlam) Ensure world clock's year, month, and day of month are all pulled from the same source year. Closes #1772
-   (stwlam) Fix bug causing items to occasionally drop off from unlinked tokens
-   (Chup) Fix action icons inside journal entries

### New Features

-   (stwlam) Automatically remove class features when a PC's level is reduced
-   (stwlam) Add support for predication against compound statements
-   (Eddie) New crafting tab

### Content Changes

-   (SpartanCPA) Fix ability description of Catfolk Pouncer
-   (SpartanCPA) Consolidate all NPCs to one Rage effect
-   (SpartanCPA) Add "Time" weapon trait
-   (SpartanCPA) Add "Seugathi" creature trait
-   (SpartanCPA) Second pass of NPC Gallery: Courtiers, Criminals, Devotees
-   (SpartanCPA) Brush up of some NPCs from Lost Omens: Character Guide
-   (SpartanCPA) Fix shears damage dice
-   (Tikael) Add all magic schools as options for immunities
-   (Tikael) Brush up of Age of Ashes book 4 (part 5)
-   (Tikael) Fix Dueling Parry and Dance to not give NaN AC stat
-   (Tikael) Add area to _phantasmal calamity_ spell
-   (Tikael) Prepare Scarlet Triad Mage's spells
-   (Tikael) Add _mind blank_ spell effect
-   (Tikael) Add base Arcane Cascade effect
-   (InfamousSky) Add icons to Magus focus spells
-   (InfamousSky) Changed _force fang_ from spell attack type to utility. Closes #1739
-   (InfamousSky) Brush up for first few Abomination Vaults book 3 actors
-   (Zaquariah) Add _zealous conviction_ spell effect
-   (rectulo) Add missing sentence to lesser thunderbird tuft
-   (rectulo) Fix typo in _gale blast_ spell description
-   (rectulo) Remove extraneous letter from Urgathoa - Major Curse description
-   (rectulo) Fix formatting of _mystic carriage_, _inevitable disaster_, and _battlefield persistence_ spell descriptions
-   (rectulo) Fix typo in _petal storm_ spell range
-   (rectulo) Add missing heightening text for _chromatic armor_ spell description
-   (xdy) Fix some format errors in content sources
-   (VestOfHolding) Add automation to Undine features and feats
-   (VestOfHolding) Add missing spell areas for _control water_ and _spirit song_ spells
-   (VestOfHolding) Add traits from Guns & Gears and Grand Bazaar
-   (stwlam) Remove patron theme and witch lessons as witch class-feature items
-   (stwlam) Add rule element to Unbreakable-er Goblin feat. Closes #1765
-   (stwlam) Add "Kobold" to consumable traits
-   (Supe) Fix _pet cache_ spell, and add persistent damage to _phantom pain_ spell
-   (TMun) Add 15 and 30 foot cone to _dazzling flash_ spell. Closes #1766
-   (TMun) Add fifth doctrine placeholder class feature to cleric. Closes #1764
-   (TMun) Corrects _blessing of defiance_ (fortitude) spell effect rule element. Closes #1761
-   (TMun) Split arcane spellcasting into two versions and update magus and wizard for new class feature. Closes #1746
-   (TMun) Switch repeating hand crossbow from Str to Dex based. Closes #1768
-   (Abaddon) Brush up Bestiary 1 alghollthu, ankhravs, cave worms, and elephants
-   (telekenunes) Replace familiar ability flat modifier rule elements with ActiveEffect-Like rule elements
-   (telekenunes) Add Sense rules for Gloomseer and Darkseer human ancestry feats

### Core System Improvements

-   (Chup) Keep expanded strike summaries open after toggling a weapon trait
-   (stwlam) Always show rule element source data from rules tab on item sheets
-   (stwlam) Maintain a sort order for attack and defense proficiencies on the PC sheet
-   (stwlam) Accommodate localization of non-English spellcasting entry names
-   (stwlam) Update data preparation to have familiar abilities be updated by AE-likes
-   (stwlam) Disable the scale range input when linkToActorSize is enabled. Closes #1758
-   (stwlam) Remove stored "base" properties from NPC statistics. Closes #1751
-   (stwlam) Wrap "NPCs are lootable" toggle in a GM check
-   (stwlam) Log changes made to actor statistics via AE-like rule elements, ancestries, and classes
-   (stwlam) Fully implement noisy penalty and armored stealth rule. Closes #1750
-   (stwlam) Remove bulwark rule elements in favor of handling in data preparation, add rule element to Mighty Bulwalk
-   (stwlam) Make homebrew tag IDs stable instead of randomly generated to make them more portable across worlds
-   (stwlam) Default rules-based vision to enabled for new worlds
-   (stwlam) Require a domain for the RollOption rule element
-   (stwlam) Provide numeric weapon and armor rune data for use by rule elements
-   (stwlam) Add a `fromUUIDs` utility function to get multiple documents with a single server request
-   (Supe) Move effects tab to before biography so actions and inventory are now adjacent
-   (Supe) The compendium browser can now filter by consumable type
-   (Supe) Add slight fading to non-ready strikes, for example from unequipped weapons
-   (Abaddon) Add support for `@Localize` syntax in enriched text
-   (Abaddon) Add NPC glossary abilities to localization files for easier reuse
-   (Tikael) Allow inline templates to pass traits
-   (Tikael) Allows inline skill checks to use a roller's level based DC
-   (Tikael) Add roll option for raised shield and automate glamorous buckler without an effect
-   (Chup) Fix styling of Fortune/Misfortune in strike chat cards
-   (Chup) Fix TinyMCE editor fonts and system specific stylings
-   (nikolaj-a) Add rule element for adding a known crafting formula
-   (nikolaj-a) Add chat message flags to suppress damage formatting
-   (nikolaj-a) Add outcome as optional callback parameter for checks
-   (nikolaj-a) Make PC sheet slightly wider to make better room for two column skills
-   (nikolaj-a) Add craft action macro

## Version 2.14.4

### Bug Fixes

-   (stwlam) Fix experimental damage card formatting given a roll formula of all constants

## Version 2.14.3

### Bug Fixes

-   (stwlam) Fix drawing from rollable tables while experimental damage cards are enabled
-   (stwlam) Fix rendering of item sheets when returning to previously visited tab in compendium browser. Closes #1741
-   (stwlam) Skip checking for available spell slots when casting a ritual

### Content Changes

-   (InfamousSky) Assign icons to Secrets of Magic spells which were missing them

## Version 2.14.2

### Bug Fixes

-   (stwlam) Exclude fate dice and coin rolls from damage formatting
-   (stwlam) Fix display of weaknesses and resistances on hazard sheet

## Version 2.14.1

### Bug Fixes

-   (stwlam) Fix crit and fumble cards not rendering correctly with some combinations of settings
-   (stwlam) Fix functionality of flexible armor trait

## Version 2.14.0

### Bug Fixes

-   (In3luki) Fix check roll dialog radio buttons when multiple dialogs are open
-   (In3luki) Fix attack effects displaying slug instead of item name in chat card
-   (In3luki) Fix compendium browser loading all packs regardless of the current settings
-   (stwlam) Apply temporary fix to critical strikes with splash damage. Closes #1687
-   (stwlam) Remove dependency on presence of slug to generate magical weapon names
-   (stwlam) Fix calculation of hazard XP in XP macro
-   (stwlam) Fix legacy NPC strikes
-   (n1xx1) Use grid units in measure tool

### Content Changes

-   (InfamousSky) Add speed rule elements to Sylph feats. Closes #1700
-   (InfamousSky) Brush up of corrupted priest from Extinction Curse. Closes #1713
-   (InfamousSky) Fix the amount of additional skills of some classes. Closes #1721
-   (InfamousSky) Add missing traditions to the _blazing dive_ spell
-   (InfamousSky) Add icons for the remaining Secrets of Magic spells
-   (InfamousSky) Fix inline save label of _chromatic ray_ spell. Closes #1712
-   (InfamousSky) Brush up nightmare and greater nightmare
-   (InfamousSky) Add question mark icon for class features requiring choice to be made
-   (InfamousSky) Add _boost eidolon_ spell effects for damage dice scaling
-   (InfamousSky) Fix double `@Compendium` in kobold breath, and add inline templates and scaling damage. Closes #1737
-   (InfamousSky) Add missing equipment from Agents of Edgewatch book 5
-   (InfamousSky) Correct typos in Celestial Peach (Rejuvenation) and Ring of Maniacal Devices (Greater). Closes #1742 and #1743
-   (InfamousSky) Fix typo in "Form of the Fiend" Feats. Closes #1744
-   (InfamousSky) Correct level and runes of Invisible Chain Shirt, and add compendium links in the description. Closes #1745
-   (SpartanCPA) Fix the name of the I'iko Dragon
-   (SpartanCPA) A new Rage effect for NPC actors
-   (SpartanCPA) Fix size of the Xulgath Spinesnapper. Closes #1715
-   (SpartanCPA) Correct typo in senses of the Stegosaurus. Closes #1717
-   (SpartanCPA) Add link to _guidance_ immunity effect in the spell description
-   (SpartanCPA) Ensure degrees of success is separated from ability text by `<hr />`
-   (SpartanCPA) Make NPC ability triggers GM-only text
-   (SpartanCPA) Add Swarm Mind to spider swarm
-   (SpartanCPA) Add rule elements to Canny Acumen variants
-   (SpartanCPA) Consolidate NPC Rages into one effect
-   (SpartanCPA) Update source book and action categories for NPC Gallery entries
-   (SpartanCPA) Formating fix for the Invigorating Fear action
-   (SpartanCPA) Fix icons for reactions still using the default `mystery man` icon
-   (SpartanCPA) Brush up Abomination Vaults barbazu variants
-   (SpartanCPA) Fix damage rolls placed in attack effects
-   (SpartanCPA) Fix necrotic bomb. Closes #1733
-   (SpartanCPA) Fix Eidolon Breath Weapon damage. Closes #1722
-   (SpartanCPA) Remove unneeded custom attack effect in Agents of Edgewatch book 1
-   (SpartanCPA) Ensure all effects have token effect icon enabled
-   (SpartanCPA) Add source to equipment
-   (SpartanCPA) Brush up of NPC Gallery creatures: mystics, officers, performers, publicans, scholars, seafarers, tradespeople, villains
-   (SpartanCPA) Add evil damage to _hellfire plume_
-   (SpartanCPA) Add injury and poison to feat traits and add aquatic to hazard traits
-   (xdy) Add source book to:
    -   Heritages in the ancestryfeatures pack
    -   All classes
    -   All ancestries, including those from Secrets of Magic
    -   All hazard
    -   PFS guide feats
    -   Mwangi expanse feats
    -   World Guide feats
    -   All adventure path feats
    -   Character guide feats
    -   All spells
    -   All backgrounds
    -   Advanced Player's Guide feats
    -   Lost Omens: Ancestry Guide feats
    -   Most of the actions
    -   All weapons
    -   Feats from various smaller books
    -   Most of the treasure
    -   Core Rulebook feats
-   (rectulo) Add level to Terrain Shield geomancer archetype feat
-   (rectulo) Correct `Sheltering Cave` from bonus feat to druid class feat
-   (rectulo) Correct `Wind-Tossed Spell` from bonus feat to elementalist dedication archetype feat
-   (rectulo) Clean up links of Surge Investigator
-   (rectulo) Change trait of formula book
-   (rectulo) Brush up magus description
-   (rectulo) Fix typo in requirements of cascade countermeasure feat
-   (rectulo) Fix type in the Spell Swipe feat description
-   (rectulo) Add the additional text regarding Draconic Bloodline to the Claws of the Dragon feat
-   (TMun) Add hardness 14 to poisoned dart trap. Closes #1718
-   (TMun) Add class features for class archetypes, including automation for runelord focus spells and polearm proficiency. Closes #1719
-   (TMun) Add spell daily tables to magus and summoner
-   (TMun) Add NPCs from Pathfinder Society S2-19
-   (TMun) Update NPCs from Pathfinder Society S2-21. Add unkillable zombie shambler
-   (TMun) Add light and medium armor proficiency to Kyra
-   (stwlam) Fix rule elements on Cat Animal Instinct class feature
-   (stwlam) Update _elemental form_ spell effects with BattleForm rule elements
-   (stwlam) Update _dinosaur form_ spell effects with BattleForm rule elements
-   (stwlam) Fix Druidic Orders link and rule elements related to focus points on flame and stone orders
-   (stwlam) Fix _element embodied (earth)_ spell effect
-   (stwlam) Remove unnecessary roll options fields from some FlatModifier rule elements in pack JSON
-   (stwlam) Mark all specific magic weapons as such
-   (stwlam) Fix permission of Toggle Mountain Stance macro
-   (stwlam) Remove Amurrun from Lizardfolk default languages
-   (stwlam) Move "Effect: Hybrid Form" to correct compendium
-   (Abaddon) Update _retributive strike_ on all NPCs to show the actual damage reduction it grants
-   (Abaddon) Brush up of Bestiary 1 spiders
-   (Abaddon) Brush up of Bestiary 1 bears
-   (Abaddon) Brush up of Bestiary 1 wendigo
-   (Abaddon) Brush up of Bestiary 1 catfolk pouncer
-   (Abaddon) Brush up of Bestiary 1 lantern archon gestalt
-   (Abaddon) Brush up of Bestiary 1 merfolk
-   (Abaddon) Fix NPC special attack effects
-   (Dmitry) Fix Sun Wheel item
-   (skulbuny) Brush up Otari Ilvashti
-   (Drental) Add cactus leshy spine strike
-   (Tikael) Part 4 of brush up of Age of Ashes book 4
-   (Tikael) Correct price of fauchard
-   (Tikael) Clean up animal and dragon instincts
-   (Tikael) Correct Sneak Attack damage for rogue dedication
-   (Tikael) Add Stoked Flame Stance
-   (kageru) Fix damage type of daikyu
-   (kageru) Remove incorrectly copied traits from creatures
-   (kageru) Fix skill proficiencies in class descriptions
-   (Friz) Fix investigator's stratagem feat level
-   (Cora) Fix rarity and add missing rule elements on some of the Age of Ashes paragon feats
-   (Zaquariah) Add missing text to phase familiar description. Closes #1196
-   (Vindico) Add flowing wave strike rule element and disarm/swim/trip modifier rule elements to the reflective ripple stance effect. Closes #1724

### Core System Improvements

-   (stwlam) Move metagame settings to a menu
-   (stwlam) Set appropriate usage for equipment and mark certain containers as being for stowing
-   (stwlam) Prevent adding PC-only items to NPCs
-   (stwlam) Add negative healing indicator to creature hit point data and recoverym ultiplier to PC hit point data
-   (stwlam) Scale tokens belonging to small actors down to 0.8
-   (stwlam) Fix hard-coded localization and storage of weakness/resistance values as strings. Closes #1697
-   (stwlam) Replace rule-element based armor speed penalties with actor-data preparation. Closes #1699
-   (stwlam) If a world has actors but no stored schema version, store as low as recommended safe version
-   (stwlam) Add predicates to disrupting and alignment-damage runes
-   (stwlam) Move prepareSpeed method to CreaturePF2e, call from subclasses
-   (stwlam) Update BattleForm and RollNote rule elements to accommodate Elemental Form spell effects
-   (stwlam) Adapt BattleForm rule element to work with _pest form_ spell effects
-   (stwlam) Set better defaults in BattleForm rule element
-   (stwlam) Add a _wild shape_ spell effect that alters battle forms
-   (stwlam) Validate actor types from rule elements via overridable static property
-   (stwlam) Allow finer cone-rotation increments
-   (stwlam) Do not apply Pathfinder effect-area rules to templates when a square grid isn't in use
-   (stwlam) Only show the troubleshooting button to GMs
-   (stwlam) Show weapon level in a tooltip when adjusted by materials and runes
-   (stwlam) Have BattleForm validation be a little more forgiving
-   (stwlam) Set invalid proficiency ranks to untrained or legendary instead of sending an error message
-   (stwlam) Set a class:<class-slug> roll option, mainly for homebrew use
-   (stwlam) Remove experimental perception automation toggle
-   (stwlam) Set a roll option stating whether an actor is armored
-   (stwlam) Add a RollOption rule element, use with Unburdened Iron and Armored Stealth feats
-   (stwlam) Prevent "custom" getting added as a trait when a custom trait is entered
-   (stwlam) Move ancestry vision features from independent items to system data on ancestry items
-   (stwlam) Add automatic detection of spellcasting targets for superstition instinct
-   (stwlam) Fill out sense and trait automation for Fungus Leshy heritage
-   (stwlam) Remove PC-only items from non-PCs
-   (stwlam) Reorganize familiar sheet
-   (stwlam) Allow a rule element to declare that it does not require its parent item to be invested
-   (stwlam) Fix predication of creature speed modifiers
-   (stwlam) Allow users to retract time in the World Clock via holding down the ctrl key
-   (stwlam) Sort class features by level on PC sheet
-   (skulbuny) Polish stamina/resolve design in the sidebar
-   (Supe) Signature spells at other levels no longer have remove/edit buttons and have a tint
-   (Supe) NPCs can now set signature spells
-   (Supe) Add activation time getters to feat/actions. If passive returns null
-   (Supe) Add cast level and heighten to roll data
-   (Supe) Ensure expended has a value for prepared slots
-   (Supe) Remove spellcasting entry header visibility toggle for edit controls
-   (Supe) Make spell "Cast" button post the spell to chat
-   (Supe) Spells support damage card formatting when the automation flag is enabled
-   (Supe) Add bottom gap to feats list
-   (Supe) Allow roll data to be used for deferred inline rolls, and fix a bug from Foundry Core
-   (In3luki) API Change: Separate `CheckPF2e.roll` and `CheckModifiersDialog`
-   (In3luki) Add consumables to available NPC attack effect choices
-   (In3luki) Add "Consumable" label and the remaining quantity to NPC attack effects from consumables
-   (Chup) Remove unused CSS from legacy styles
-   (Chup) More CSS tag refactors
-   (Chup) Fix character navigation hover color. Closes #1329
-   (Chup) Fix styling of PFS player and character numbers
-   (Chup) Refactor CSS for details labels in character and vehicle sheet
-   (Chup) Ensure unique IDs for specific UI elements across sheets for different actors
-   (Cerapter) Add ability to hide slotless levels in Spellbooks
-   (n1xx1) Add a checkbox in the NPC sheet to make it lootable on death
-   (Tikael) Add mental trait to feat trait list
-   (Tikael) Add thrown 25 and 50 traits
-   (xdy) Add source filtering to most tabs on the compendium browser
-   (nikolaj-a) Experimental damage roll chat card format
-   (nikolaj-a) Use default roll options for modifiers

## Version 2.13.5

### Bug Fixes

-   (stwlam) Fix duplicated modifiers to NPC damage on multiple rolls
-   (Chup) Fix Class DC modifier tooltip

## Version 2.13.4

### Bug Fixes

-   (In3luki) Fix NPC weak adjustment setting the wrong hit point values. Closes #1673
-   (stwlam) Fix speed recalculation in battle form rule element
-   (stwlam) Fix token effect icons sometimes not appearing on unlinked tokens
-   (skulbuny) Fix issue with resolve not showing in sheet sidebar. Closes #1692

### New Features

-   (stwlam) Add a Migration Summary application to guide users post-migration

### Content Changes

-   (TMun) Add more content from Strength of Thousands book 2
-   (TMun) Fix typo in possession trait
-   (TMun) Add Akitonian as a language for 3-99
-   (TMun) Add Shobhad as a creature trait and a language
-   (TMun) Update license with 3-99 for languages and traits
-   (TMun) Add trigger to paladin reaction in class feature. Partially addresses #1707
-   (stwlam) Fix usage and icon of _handwraps of mighty blows_
-   (stwlam) Add icon for _shadow signet_
-   (Abaddon) Brush up of Bestiary 1 boggards and dinosaurs
-   (Abaddon) Brush up of Bestiary 3 animated objects (for real this time!)
-   (Abaddon) Change compendium items and actors to use short form for rule element keys (flat modifiers, damage dice, notes, toggles, base speed)
-   (Abaddon) Correct grab and push in the NPC special attack effects
-   (InfamousSky) Add icons to Secrets of Magic spells start with A through M
-   (InfamousSky) Add icons to Magus class features and feats, fix feat types and categories. Closes #1706
-   (InfamousSky) Remove "Animal" trait from Revenant, add inline template button
-   (InfamousSky) Add "worn" usage to rings. Add "worn ring" for \_ring of discretion. Closes #1708
-   (InfamousSky) Add missing note rule element to _angel form_ spell effect
-   (Surles) Add rule elements for Furious Strike
-   (amnesicpachyderm) Add 30 foot cone "area" data to _vampiric exsanguination_

### Core System Improvements

-   (stwlam) Clamp creature hit points before updating
-   (stwlam) Prevent creating formula items outside dev mode and sort item types in create item dialog
-   (stwlam) Add a Troubleshooting button to the settings sidebar
-   (stwlam) Add a means for rule elements to exclude any damage modifier or dice, which is used in the battle form rule element
-   (Chup) Rename damage chat card label 'Full' to 'Damage' to make its function more clear

## Version 2.13.3

### Bug Fixes

-   (stwlam) Fix token image rule element
-   (Supe) Fix damage for spells with only a flat modifier, add damage formula to _daze_

### Content Changes

-   (Abaddon) Brush up archons, add automation for Lantern of Hope ability
-   (Abaddon) Link _infectious aura_ effect in ability description
-   (Abaddon) Fix range increments for Bestiary 1 monsters
-   (TMun) Add bestiaries for Pathfinder Society Introductions and Pathfinder Society season 3. Add PFS Intro 1, Intro 2 and S3-01 NPCs
-   (TMun) Add new ritual, archetypes, items, and corresponding actions and effects from Strength of Thousands book 2. Add worn crown as a usage trait
-   (rectulo) Fix persistent damage of corrosive ammunition
-   (stwlam) Update Spell Effect: Dragon Form (Red) with battle form rule element
-   (stwlam) Update Spell Effect: Dinosaur Form (Ankylosaurus and Triceratops) to use the battle form rule elements
-   (Tikael) Add _ooze form_ spell effects
-   (Tikael) Correct AC while raging for barbarian dedication
-   (Tikael) Add new form spell effects start with C through E. Correct _fey form_
-   (VestOfHolding) Add _angel form_ spell effects
-   (InfamousSky) Secrets of Magic elementalism focus spell fixes

## Version 2.13.2

### Bug Fixes

-   (stwlam) Fix initiative becoming NaN on dying PCs
-   (stwlam) Fix condition token icons getting applied properly

### Content Changes

-   (TMun) Changes oracle for additional skills from 4 to 3. Closes #1694
-   (InfamousSky) Fix a few mistakes in some Secret of Magic spells
-   (InfamousSky) Add strike rule elements for holy water and unholy water. Closes #1677
-   (InfamousSky) Add correct traits to _Mirror of Sorshen inline saves and linked \_dominate_ spell in description. Closes #1683
-   (Abaddon) Brush up of Bestiary 3 animated objects
-   (Abaddon) Brush up of Bestiary 1 daemons
-   (Abaddon) Add `Volley 20 ft.` and `Volley 50 ft.` attack traits
-   (Abaddon) Brush up reload, versatile and volley attack traits on Bestiary 1 monsters
-   (SpartanCPA) Standardize formatting for versatile, range, reload, and thrown traits
-   (SpartanCPA) Standardize formatting of single quotes for Secret of Magic items
-   (SpartanCPA) Add type traits to all Dragon's Breath potions
-   (SpartanCPA) Brush up of Extinction Curse book 6/Bestiary 1 creatures

## Version 2.13.1

### Bug Fixes

-   (stwlam) Use ModifierPF2e#clone instead of duplicate to preserve properties
-   (stwlam) Adjust spell damage migration to handle mixed states of spell-damage data
-   (stwlam) Fix NPC phantom token bug

### Content Changes

-   (TMun) Relink summoner class features to class for drag and drop
-   (TMun) Add Secrets of Magic missing archetype actions, archetype dedications and feats, archetype equipment, archetype spells, and archetype druid orders
-   (TMun) Add cross-linking to new Secret of Magic items, like druidic orders to class feature, shadow spells to granting feats, and manifest action to soulforged feat
-   (TMun) Adds diease as a trait for weapons. Closes #1689
-   (TMun) Add class to feat traits
-   (TMun) Correct data entry errors in pernicious poltergeist and warriors regret. Closes #1690
-   (kageru) Fix duration of adult and ancient gold dragon’s weakening gas
-   (stwlam) Add an icon for Spell Effect: Fey Form
-   (SpartanCPA) Update thrown and range increment traits across packs
-   (SpartanCPA) Update death effects and nonlethal attacks across all packs
-   (InfamousSky) Fix a few mistakes in the arcane Secret of Magic spells

### Core System Improvements

-   (Abaddon) Change spell naming to "<tradition> <preparation> Spells" to align with NPC stat block entries. Closes #1688

## Version 2.13.0

### Bug Fixes

-   (Manuel Hegner) Fix that damage rolls were posted as selected token instead of actor. Closes #1012
-   (stwlam) Fix action description expands in Actions tab for new actions
-   (stwlam) Work around Foundry bug causing bad linked-condition references on synthetic actors
-   (Arthana) Fix display of crit & fumble card draw buttons on attack rolls. Closes #1662
-   (Supe) Fix item summary expanded state preservation for prepared spell lists and signature spells
-   (Drental) Fix DC replacement on inline roll reposts for non-English languages with different grammar, like French
-   (Friz) Fix for the identify item send to chat when other tables are visible on the screen

### New Features

-   (TMun) Secrets of Magic content

### Content Changes

-   (Abaddon) Update for animated objects, eagles, skeletons, and bloodseeker
-   (Abaddon & SpartanCPA) Update Change Shape monster ability description to link to the Impersonate action
-   (SpartanCPA) Add monsters and hazards from Extinction Curse book 6
-   (SpartanCPA) Review the hazards in Extinction Curse book 1
-   (SpartanCPA) Audit Shanrigol Behemoth. Closes #1655
-   (SpartanCPA) Add the two missing Secrets of Magic traits
-   (SpartanCPA) Add `Clockwork` to weapon and equipment traits
-   (SpartanCPA) Make Sturdy Satchel a container. Closes #1666
-   (SpartanCPA) Ravithra and Naga domain spells
-   (SpartanCPA) Fix condition links with values (adventure path bestiaries, boons, feats, equipment, game mastery guide, core bestiaries, Pathfinder Society, iconics, and pre-generated characters)
-   (SpartanCPA) Standardize formatting: Align single quotes from ’ to ', align double quotes from HTML entity codes to escaped quotes, ensure paragraph tags for flavor text
-   (SpartanCPA) Audit Black Dragons, and add tail lash effect
-   (SpartanCPA) Fix weird `<em>` tag on Bracers of Armor
-   (SpartanCPA) Add rule element to Undaunted feat. Closes #1668
-   (SpartanCPA) Add Black Dragon spellcaster variants
-   (SpartanCPA) Reorder Skeleton Guard weapons to match stat block
-   (SpartanCPA) Correct damage type and scaling of _finger of death_
-   (SpartanCPA) Add flavor text to several monsters missing information. Closes #1669
-   (Drental) Add inline Fortitude saving throws to constrict monster abilities
-   (Drental) Add inline Reflex saving throws to trample monster abilities
-   (stwlam) Fix monk starting unarmored proficiency
-   (stwlam) Add new property runes from Secrets of Magic
-   (stwlam) Fix ability on the NPC Gallery necromancer's spellcasting entries
-   (Tikael) Default effect icon to on for _righteous might_
-   (InfamousSky) Add Fungal Armor from Agents of Edgewatch. Closes #1319
-   (InfamousSky) Fix ability description in Stinkweed Shambler
-   (InfamousSky) Add source to Succubus and Balisse. Closes #1356
-   (InfamousSky) Add heightening to _elemental motion_ spell effects
-   (InfamousSky) Fix level of Damurdiel's Vengance from Age of Ashes. Closes #1670
-   (rectulo) Correct the persistent piercing damage of the barbed vest
-   (rectulo) Correct interact and frequency on _whispering reeds_
-   (rectulo) Consolidate disrupting greater rune
-   (kageru) Set Magus class feat levels as numbers instead of text

### Core System Improvements

-   (stwlam) Retire SetProperty rule element in favor of AE-likes
-   (stwlam) More actor import from JSON more resilient by doing a single document update rather than two
-   (stwlam) Default not linkinking token size to actor size for hazards, vehicles, and loot actors. Closes #1667
-   (stwlam) Add some blending to overlapping light sources
-   (stwlam) Remove Perfect Vision compatibility warning
-   (stwlam) Show magic school and magic tradition as traits on spell chat cards
-   (stwlam) Add a basic Immunity rule element
-   (stwlam) Enable inline rolls on item sheets
-   (stwlam) Add icons for bsttle form attacks
-   (stwlam) Fix dimensions of Magus class icon
-   (stwlam) Add a BattleForm rule element
-   (stwlam) Preserve numeric values when updating from the tag selector
-   (stwlam) Add a traits filter to the compendium browser feat section
-   (stwlam) Numify vehicle dimensions, correctly translate to token dimensions
-   (Manuel Hegner) Prevent layout change on journal title hover
-   (Supe) Show upscaled damage in summary
-   (Supe) Expand trait selector to work with more field types
-   (Supe) Support Focus spell component
-   (Supe) For Elite/Weak templates, apply +2/-2 instead for cantrips
-   (Supe) Add rudimentary support for flexible casting
-   (Supe) Make strike and damage buttons in spell/strike chat cards only visible for owners, and allow all owners of the actor to roll from chat card
-   (Supe) Pass data properties to summary chat data. Fix heightened damage formula labels for prepared casters
-   (Chup) Start consolidating CSS for tags like traits or senses
-   (Chup) Improve styling of spell components in spell list

## Version 2.12.5

### Bug Fixes

-   (stwlam) Work around foundry server bug to ensure presence of document schema record
-   (stwlam) Ensure saves are displayed in a fixed order on the PC sheet

### Content Changes

-   (stwlam) Remove focus-point rule elements accidentally added to feats with "bloodline" in the slug

### Core System Improvements

-   (Supe) Add method to create a measued template without placing it, and add certain flags to the template from the origin item

## Version 2.12.4

### Bug Fixes

-   (stwlam) Remove brightening of unexplored areas of a map

## Version 2.12.3

### Bug Fixes

-   (stwlam) Fix homebrew settings cleanup migration
-   (Arthana) Fix compendium browser dragging item icon. Closes #1659

### Content Changes

-   (SpartanCPA) Add sources to Extinction Curse Player's Guide backgrounds
-   (SpartanCPA) Add sources, fix speeds in Extinction Curse book 1 through 5. Remove Living Graffiti, as it was reprinted in Bestiary 3
-   (SpartanCPA) Re-apply correct icon of familiar abilities
-   (SpartanCPA) Correct rule element key on Dire Warning effect
-   (stwlam) Normalize treasure usage and sluggify owned coins in pack JSON for stackability
-   (stwlam) Fix scaling of the _spirit song_ spell
-   (rectulo) Add clarification text for wyrmblessed and draconic bloodlines
-   (TMun) Update wounding rune to state bleed damage and corrects poisoners staff level. Closes #1654 and #1658
-   (TMun) Add St. Alkitrem's Eye necklace from Extinction Curse book 2
-   (Tikael) Correct Goliath Beetle size and traits

### Core System Improvements

-   (stwlam) Make darkness shading/coloration a little more appropriate for basic use
-   (stwlam) Add token config option to decouple token dimensions from actor size
-   (Supe) Right align checkboxes in item sheets and scale select control

## Version 2.12.2

### Bug Fixes

-   (Chup) Fix visibility of + and - buttons for items in containers
-   (stwlam) Fix visibility of + and - buttons for items in vehicle sheet
-   (stwlam) Calculate saving throw proficiency ranks instead of pulling information from old stored data
-   (stwlam) Temporarily restore ability to manually adjust perception and save proficiencies
-   (Drental) Show icons correctly in the journal entries

### Core System Improvements

-   (Drental) Remove repost button from check element on repost by players

## Version 2.12.1

### Bug Fixes

-   (stwlam) Fix rendering of the Compendium Browser's settings tab
-   (stwlam) Ensure presence of rules array on item system data, to prevent crashing the creature token size migration
-   (stwlam) Restore presence of inventory quantity-adjustment buttons on PC sheet

### Content Changes

-   (TMun) Correct dragonhide shield tables
-   (TMun) Remove AoE Skinstitch (duplicate of Bestiary 3)
-   (stwlam) Have Druidic Order start with one focus point, and increase focus pool by one for the following:
    -   Additional Shadow Magic
    -   Basic Bloodline Spell
    -   Blessed One Dedication
    -   Breath of the Dragon
    -   Crystal Ward Spells
    -   Domain Initiate
    -   Expanded Domain Initiate
    -   Gravity Weapon
    -   Heal Companion
    -   Leaf Order
    -   Magic Warrior Aspect
    -   Magic Warrior Transformation
    -   Shadow Illusion
    -   Storm Order
    -   Wings of the Dragon

### Core System Improvements

-   (stwlam) Migrate actor and item on JSON importing
-   (stwlam) Clear invalid character-size data

## Version 2.12.0

### Bug Fixes

-   (stwlam) Ensure strike modifiers applied in the roll dialog are temporary
-   (stwlam) Fix ABC item-embedding for non-compendium items
-   (stwlam) Fix triple-damage application from ChatMessage context menu
-   (stwlam) Work around Foundry bug making `Actors#tokens` unusable. Closes #1637
-   (stwlam) Override LightingLayer#hasGlobalIllumination to fix upstream bug (https://gitlab.com/foundrynet/foundryvtt/-/issues/5741)
-   (Drental) Fix repost inline links functionality
-   (In3luki) Skip evaluation of modifer options for rerolled checks
-   (Trollderim) Fix wrong hp adjustment on elite and weak adjustment. Closes #1633
-   (Bluesatin) Fixed WIP PF2e theme toolbar spacing problem. Closes #1648

### Content Changes

-   (TMun) Update duergars from Bounty 1 for Quest 13
-   (TMun) Add hazards and unique NPCs for Bounty 6 through 10
-   (TMun) Add or update NPCs from Bounty 3 through Bounty 5
-   (TMun) Add S and V components to _disrupt undead_. Closes #1634
-   (TMun) Add missing ability to Yianyin. Closes #1629
-   (TMun) Add Mahwek language
-   (TMun) Update Otyugh and Sewer Ooze formatting from Bestiary 1
-   (TMun) Add NPCs and Hazards from Quest 10
-   (TMun) Add summon trait for spells
-   (TMun) Add Bounty 12 unique hazard and linked cleanup
-   (TMun) Update Pathfinder Society S1-00 NPCs and Hazards
-   (TMun) Update NPCs from Pathfinder Society S2-02, S2-04, S2-05, S2-08, and S2-16
-   (TMun) Add missing or update NPCs and Hazards in Pathfinder Society S1-25. Closes #1625 and #1626
-   (TMun) Update warg and wolves from Bestiary 1 to new data standard
-   (TMun) Re-add accidentally removed text when spell link was added to equipment. Closes #1642
-   (TMun) Add new NPCs from Pathfinder Society S2-23
-   (TMun) Update Sea Drake in Bestiary 2
-   (TMun) Convert resistance/weakness/immunity types to traits to deduplicate the translations
-   (TMun) Add Russian as an uncommon language in PF2e
-   (TMun) Add passive for no MAP and note to scythe strike. Closes #1643
-   (TMun) Remove Jorogumo from Agents of Edgewatch (identical to Bestiary 3 entry)
-   (fryguy) Add +1 striking dagger to Agents of Edgewatch 4 NPC. Closes #1154
-   (stwlam) Set base item for explorer's clothing and variants
-   (stwlam) Add and set new base weapon types from Fists of the Ruby Phoenix
-   (stwlam) Fix spelling of Versatile heritage on Feiya
-   (stwlam) Clean up hex spell traits
-   (stwlam) Add svg icons for a few newer ancestries
-   (SpartanCPA) Correct actionCategory of Light Blindness in Compendium
-   (SpartanCPA) Batch change icon of spellcasting entries
-   (SpartanCPA) Batch change icon of hazards, NPCs, and prebuilts still using mystery man
-   (SpartanCPA) Batch change icon of Familiar Abilities
-   (SpartanCPA) Batch change icon of melee items
-   (SpartanCPA) Batch change passive action icons
-   (SpartanCPA) Correct traits for Gnagrif and Umbo in Strength of Thousands. Closes #1627
-   (SpartanCPA) Correct damage of Worm's Repast in Abomination Vaults
-   (SpartanCPA) Add rollable formulas to the Ghoul/Ghast stock abilities
-   (SpartanCPA) Have _inspire courage_ give a bonus to all fear-based saving throws, not just Will saves
-   (SpartanCPA) Add effect for Immunity to Guidance
-   (SpartanCPA) Brush up of Abomination Vaults level 3 creatures
-   (SpartanCPA) Add creature family abilities for Graveknight, Lich, Vampire, Werecreature, Zombie, and others
-   (SpartanCPA) Correct roll button on Buck
-   (SpartanCPA) Add `healing` trait to Antidote and Antiplague
-   (Drental) Change fane's escape to a skill feat
-   (Drental) Brush up labels and flavor text for inline damage rolls
-   (Tikael) Correct level of sand whirlwind hazard
-   (Tikael) Correct daikyu ability. Closes #1631
-   (Tikael) Link steel your resolve macro from steel your resolve feat description
-   (Tikael) Correct Belt of Regeneration details
-   (Tikael) Fix Forest Endemic Herb effect
-   (Tikael) Automate Crunch feat
-   (Tikael) Correct Anitoli's reflex save
-   (Tikael) Fix bonus to saving throws vs magic monster ability
-   (Tikael) Correct actions for _prismatic wall_ spell
-   (Tikael) Part 2 of brushup of Age of Ashes book 4
-   (Tikael) Add _divine vessel_ spell effects
-   (Tikael) Add base spell effect for _righteous might_
-   (kageru) Fix demonblood frenzy prerequisites
-   (kageru) Remove obsolete inline styling in some class descriptions
-   (Trent) Add "area" information to _field of life_ spell
-   (InfamousSky) Brush up of some Extinction Curse NPCs

### Core System Improvements

-   (stwlam) Fix Strike rule element for NPCs
-   (stwlam) Add "cursed" to mystified traits
-   (stwlam) Attempt to migrate existing feats, class features etc to correctly calculate the focus pool size
-   (stwlam) Set several character proficiencies from class data and remove ability to directly edit
-   (stwlam) Remove active effects from classes, convert active effects on several item types to AE-like rule elements
-   (stwlam) Set a default permission of limited for newly-created PCs and familiars
-   (stwlam) Change "Combat" and "Combatant" language in Combat Tracker to "Encounter" and "Participant"
-   (stwlam) Add coin management buttons to NPC sheet
-   (stwlam) Add creature-size rule element, start tracking natural reach
-   (stwlam) Visually indicate that a hero point was used on a reroll
-   (stwlam) Only show class DC on PC sheet if actually present
-   (stwlam) Fix chat-log auto-scrolling issue when a damage roll is the last message
-   (stwlam) Set initial background skill rank from background
-   (stwlam) Retire TokenSize rule element in favor of CreatureSize rule element
-   (stwlam) Make data migrations faster and more resilient
-   (stwlam) Prevent input of negative spell slot values for PC spellcasting entries
-   (stwlam) Add more deadly-trait variants in config.ts and consolidate descriptions
-   (stwlam) Actor-sheet and journal-sheet styling cleanup
-   (stwlam) Remove gap beneath damage cards and restore auto-send-to-bottom of messages
-   (stwlam) Make check rolls async
-   (Tikael) Automate incredible investiture general feat
-   (Tikael) Fix area label in spell details
-   (Tikael) Simplify input of basic templates, change coarse rotation angle
-   (Tikael) Fix empty line in loot actor inventory
-   (Supe) Clean up old spell preparation property
-   (Supe) Update focus spell organization and styling, and fix sorting for focus cantrips
-   (Supe) Remove halcyon from traditions, spellTraditions constant removed in favor of magicTraditions
-   (Supe) Remove gaps in smaller character sheet header stroke for better readability
-   (Supe) Move magical traditions from individual spellcasting entries to actor data
-   (Supe) Innate spells sync to the highest spellcasting proficiency
-   (Supe) Spellcasting ability set in dialog, show tradition next to proficiency
-   (Supe) Partially standardize action header in character sheet, fixes deity boons item controls
-   (Supe) NPC sheet restructuring:
    -   Move Recall Knowledge and Languages to the main npc tab
    -   Remove NPC toggles section header to save space
-   (Supe) Make NPC sheet controls always visible, and reorganize strikes
-   (Supe) Fix NPC sheet inventory item summary and lack of border bottom bugs
-   (Supe) Focus and Halcyon migration tweaks
-   (Chup) Change proficiency level adjustment from clicking to dropdowns in Proficiency tab
-   (Chup) Adjusted styling for very small text elements to make them more legible
-   (Chup) Add button to settings tab to show legal notices, like the Paizo Community Use Policy, and remove the license text from the sheets
-   (Chup) Show message if set proficiency rank is below minimum set by features
-   (Chup) Remove "add" buttons on sheet for observers
-   (Chup) Fix vehicle tag selection
-   (kageru) Use numbers for action count in feats

## Version 2.11.1

### Bug Fixes

-   (stwlam) Fix sporadic error where a token would not have access to its data when determining vision
-   (Supe) Only migrate focus points for entries of type focus, make category migration set rituals to the empty tradition

### Content Changes

-   (SpartanCPA) Add a compendium for Creature Family Optional Abilities

## Version 2.11.0

### Bug Fixes

-   (xdy) Fix copy/paste error in Make an Impression action outcome notes
-   (In3luki) Fix hangup sometimes happening when loading scenes
-   (In3luki) Fix semi-rare error in effect data preparation
-   (stwlam) Add migration to fix malformed senses data in PC actors
-   (stwlam) Fix issue causing token image rule elements to not immediately reflect on all clients
-   (stwlam) Work around occasionally-triggered Foundry bug with token redrawing
-   (stwlam) Preserve token size and image in drag preview
-   (stwlam) Work around Foundry bug preventing item cards from being popout-able
-   (stwlam) Fix dexterity cap rule element
-   (Supe) Fix deleting spellcasting entries on legacy npc sheet
-   (Supe) Fix clipping issue for shield max hp when 3 digits long
-   (Supe) Fix error that can occur when viewing sheet with observer permissions
-   (Tikael) Fix display of unspecific lore
-   (Tikael) Allow NPCs to have negative skill modifiers

### Content Changes

-   (SpartanCPA) Change the default image of Bestiary Passives
-   (SpartanCPA) Brush-up of Abomination Vaults level 2 monsters and hazards
-   (SpartanCPA) Add a +1 to Saves vs Magic to Bestiary Ability Glossary
-   (Tikael) Candlaron's Echo update
-   (Tikael) Archetype automation A through Z
-   (Tikael) Background automation: Add skill proficiency rule element to backgrounds, change auto added assurance feats for the specific skill versions, add automation for backgrounds with special bonuses
-   (Tikael) Age of Ashes 4 brushup part 1. 4/26 actors done
-   (Tikael) Automate Brutal Critical
-   (TMun) Correct spelling of fortuitous shift feat. Closes #1612
-   (TMun) Add new dragon breaths from Mwangi expanse. Convert links to new style. Add to table on generic dragons breath. Closes #1609
-   (TMun) Correct Volluk Azinrae's strike. Rename Rusty Grave Pit to Rusty Grate Pit. Closes #1613.
-   (TMun) Update Pathfinder Society Season 1 Bestiary for NPCs from Quest 8
-   (TMun) Correct hazards and update/add new NPCs from Quest 9
-   (TMun) Update zombie flesh golems(Quest 12) and add modified ruffian (Quest 11)
-   (TMun) Updates NPCs for Pathfinder Society 2-01
-   (TMun) Set equipped flag to true for backpacks by default
-   (TMun) Add Strength of Thousands Player's Guide
-   (TMun) Add constrict damage and DC to black pudding. Closes #1616
-   (TMun) Fix ruffian Snagging Strike missing action count
-   (TMun) Correct a typo in superstition instinct. Closes #1620
-   (TMun) Fix Triceretops trample and adds vicious gore rule elements. Closes #1619
-   (TMun) Add Pathfinder Society season 2 hazards. Move Ssalarn from season 1 to season 2
-   (TMun) Update Chupacabra with bonus to leap
-   (TMun) Add NPCs, equipment, spells, actions, backgrounds and spell effects for Strength of Thousands
-   (Shandyan) Automation for the conrasu
-   (Shandyan) Automation for changelings
-   (Drental) Set ranged strikes from rule elements to use Dexterity for attack rolls
-   (Drental) Fix DC of Elder Wyrmwraith breath weapon
-   (Friz) More persistent damage edits to bring things up to standards, including Bestiary 1
-   (Friz) Fix typo in rod of wonder dice roll
-   (Friz) Correct bulk of Force Shield
-   (Friz) Add reflex save button to necklace of fireballs
-   (tslawler) Correct the damage of Nolly Peltry's strike

### Core System Improvements

-   (putty) Allow untyped damage in damage calculation
-   (In3luki) Reroll checks with the original modifiers instead of replacing flavor elements
-   (Supe) Re-arranged spell details to be more like the stat block
-   (Supe) Easier drag/drop for preparing/heightening/resorting spells
-   (Supe) Traits are easier to toggle. Input element smaller on senses/speed dialogs
-   (Supe) Focus Points is now stored directly in the actor data instead of incorrectly on each focus spellcasting entry
-   (Supe) Spellcasting slots/attack/DC no longer writes erroneous actor data
-   (Supe) Spellcasting traditions can now be changed after creation
-   (stwlam) Clean up display of numeric inputs on NPC sheet
-   (stwlam) Back to circle.svg for character focus pool size. Closes #1611
-   (stwlam) Remove chat-message migrations as those could potentially take a _very_ long time to finish with minimal gains for users
-   (stwlam) Remove unused invested property from consumables and treasure
-   (stwlam) Prevent extended token data preparation prior to initialization
-   (stwlam) Limit application of inline-roll listeners to sheets, dialogs, journal entries, and chat messages
-   (stwlam) Skip application of resilient rune bonuses on uninvested armor
-   (stwlam) Prevent rule element initialization from breaking actors
-   (stwlam) Ensure a weapon always has a category
-   (stwlam) Ensure cone area effect angles always divide 45°
-   (Tikael) Add recall knowledge pop up to new NPC sheet
-   (Tikael) Fix floating parenthesis on limited sheet
-   (Tikael) Add rarity tag to hazard sheets
-   (Tikael) Add place template button to spell chat card
-   (Drental) Add bon mot action macro

## Version 2.10.1

You will need to drag in new copies of any effect macros previously created by dragging an effect to the hotbar.

### Bug Fixes

-   (stwlam) Add sanity check before calling Token#refresh
-   (stwlam) Apply token overrides before rules-based vision check
-   (stwlam) Allow rule elements to execute right after active effects are applied, which should fix the miscalculated ability modifiers
-   (stwlam) Update createToggleEffectMacro to meet Foundry 0.8 standards
-   (Tikael) Fix hazard DC display in the sheet

## Version 2.10.0

### Bug Fixes

-   (stwlam) Fix issue preventing sense updating on characters when no scene is active
-   (stwlam) Fix display of hazard level on the non-edit sheet
-   (stwlam) Fix Fixed Proficiency rule element when used with skills
-   (stwlam) Fix Token Image and Token Size rule elements so they properly update when the containing effect is removed
-   (stwlam) Initialize homebrew elements in the game setup phase. Closes #1607
-   (stwlam) Add LoseHitPoints rule element, apply to Drained condition. Closes #1134
-   (stwlam) Fix bug in which tokens in darkness disappear too early during animated light changes
-   (stwlam) Prevent attempts to delete stale effects in EffectTracker#removeExpired. Closes #1573
-   (xdy) Show feat level in item sheet sidebar again. Closes #1415
-   (In3luki) Fix various language, trait, and immunity popup window titles. Closes #1605
-   (In3luki) Fix degree of success adjustment on reroll
-   (Supe) Fix sorting of spells
-   (nikolaj-a) Omit armor check penalty on skill checks with the attack trait

### Content Changes

-   (SpartanCPA) Brush up of NPC Gallery (Mercenaries)
-   (SpartanCPA) Add source to Fists of the Ruby Phoenix and One-Shot compendium entries
-   (SpartanCPA) Correct source for NPC Gallery compendium entries
-   (SpartanCPA) Simulacra is plural of Simulacrum
-   (SpartanCPA) Brush up One-Shot monster entries
-   (SpartanCPA) Correct prerequisites for Beneath Notice. Closes #1597
-   (SpartanCPA) Correct Bone Skipper Swarm inline saving throws. Closes #1385
-   (SpartanCPA) Add Polymorph as an immunity type
-   (SpartanCPA) Brush up weak spider swarm from Pathfinder Society 1-08
-   (SpartanCPA) Add reach-0 trait
-   (vidspark) Update to correct spell details for Sudden Blight
-   (vidspark) Add spell effect for Fleet Step
-   (rectulo) Update damage formula for quill spray shisk ancestry feat
-   (rectulo) Remove extraneous styling from rampaging ferocity orc ancestry feat description
-   (rectulo) Remove extraneous styling from squirrel swarm description
-   (rectulo) Remove extraneous styling from squirming swill flavor text
-   (rectulo) Fix feat type for fountain of secrets shisk ancestry feat
-   (rectulo) Fix typo in cantrip expansion spontaneous class feat description
-   (rectulo) Add emphasis for heightened label in wronged monk's wrath monk focus spell description
-   (rectulo) Layout the electric counter monk class feat description
-   (rectulo) Layout the all the time in the world investigator class feat description
-   (rectulo) Layout the sever space fighter class feat description
-   (rectulo) Layout the ruby resurrection sorcerer class feat description
-   (rectulo) Layout the plum deluge alchemist class feat description
-   (rectulo) Layout the everdistant defense champion class feat description
-   (rectulo) Layout the vivacious afterimage swashbuckler class feat description
-   (rectulo) Layout the scapegoat parallel self oracle class feat description
-   (rectulo) Layout the dance of intercession cleric class feat description
-   (rectulo) Add missing sentence to impossible volley eldritch archer archetype feat description
-   (rectulo) Remove "see above" reference in splint mail item description that only makes sense in the book
-   (rectulo) Fix typos in simulacrum ritual primary and secondary checks
-   (rectulo) Fix typo in levitate spell target description
-   (rectulo) Remove redundant area and target information in fey glamour sorcerer focus spell description
-   (rectulo) Fix secondary check text for heartbond ritual
-   (rectulo) Properly set condition value in basilisk action description
-   (stwlam) Correct number of damage dice added to the level 5 ankylosaurus attacks
-   (Drental) Shorten PFS token names
-   (Drental) Add inline roll links to skill and flat checks on NPCs and hazards
-   (Drental) Convert affliction saving throws to inline roll syntax
-   (Tikael) Correct various mistakes in Fists of the Ruby Phoenix bestiary
-   (Tikael) Add missing PFS 2-01 hazard. Closes #1580
-   (Tikael) Dragon Disciple automation. Closes #1568
-   (Tikael) Add Gamemastery Guide and Fists of the Ruby Phoenix vehicles to the system
-   (Tikael) Bellflower Tiller automation
-   (Tikael) Add missing adjust degree of success rule elements to Bravery and Indomitable Will class features
-   (Tikael) Add Extradimensional Stash equipment. Closes #1592
-   (Tikael) Correct the size of the weretiger and automate Moon Frenzy ability / adds inline save. Closes #1596
-   (Tikael) Add automation to acrobat and archeologist archetype feats
-   (Tikael) Fix Wyrmblessed description and move bloodline effects
-   (Tikael) Swap unburdened iron to new ActiveEffect-like rule element
-   (Tikael) Correct gnome ancestry languages
-   (Tikael) Barbarian Dedication automation
-   (Tikael) Brush-up of Age of Ashes book 5 and 6
-   (Tikael) Remaining multiclass archetype automation (without the extra class DCs, since that's not supported by the system). Closes #1498
-   (Tikael) Add remaining ancestry and heritage strikes
-   (TMun) Correct gnoll lore feat level from 0 to 1 and type from bonus to ancestry. Closes #1585
-   (TMun) Rename Artus Redriven to Arts Rodriven in Fists of the Ruby Phoenix bestiary. Closes #1589
-   (TMun) Correct encouraging word macro damage. Closes #1588
-   (TMun) Correct Sabotage as class feat instead of bonus feat. Correct Dig Up secrets to be level 1, ancestry and tagged with Shisk. Correct spelling of halcyon spellcasting intiate feat. Closes #1587, #475, #1586, and #1583
-   (TMun) Brush up Steal the Sky spell. Remove extraneous text, add link to levitate, add air trait. Closes #1561
-   (TMun) Correct Mummy Shambler stats. Closes #1529
-   (TMun) Correct spelling of Mouth of Tchekuth
-   (TMun) Recreate sleeves of storage as containers. Closes #1389
-   (TMun) Update muse phantom data per bug report and EC2 book. Closes #1398
-   (TMun) Add missing descriptions and clean up data entry to new standards for ball python, choral, fire mephit and graveknight. Closes #1379
-   (TMun) Add Pathfinder Society 2-21 NPCs to Season 2 Bestiary
-   (TMun) Add nereid description and change level 5 spell slots to 4/4. Closes #1370
-   (TMun) Fix Ahrkinos and Muraxi at levels 3-4 for Pathfinder Society quest 5. Add trap at 3-4 and all entries at levels 5-6. Closes #1293
-   (TMun) Correct spelling mistake in diviners sight target
-   (TMun) Correct level of Anugobu Wondercrafter. Closes #1599
-   (TMun) Fix Animal Skin AC bonuses
-   (TMun) Set Korokai's HP to Max instead of 15 HP in compendium
-   (TMun) Fix for Bestiary 1 NPCs, Pathefinder Society season 1 bestiary NPCs and hazards from Quest 1
-   (TMun) Add missing hazards from Quest 2 and Quest 3 and updates NPCs from Quest 2 and Quest 3
-   (TMun) Add Quest 4 hazards and update Quest 4 NPCs. Addresses part of #1496
-   (TMun) Update Quest 6 and 7 NPCs
-   (TMun) Add unique hazards and update unique monsters from PFS S2-03, update automation for Bestiary 2 monsters in Pathfinder Society S2-03. Closes #1496
-   (TMun) Hook sword is now more advanced to use. Closes #1602
-   (TMun) Add flavour text for missing B2 monsters and hail of arrows snare. Closes #1310
-   (TMun) Fix diacritics and level on MoT in Malevolence
-   (TMun) Add followers of fate deity entry from Bestiary 2. Closes #1332
-   (TMun) Add Tengu Feather Fan, Pilgrim's Token and Spare Wax Cylinder items. Closes #1488
-   (TMun) Correct spelling of Rejuvenating Flames. Closes #1604
-   (TMun) Correct typo for effect area in sepulchral mask
-   (Shandyan) Azarketi automation part 2 (finishing up part 1 from 2.5.0)
-   (Shandyan) Anadi feats and features tidy up
-   (Shandyan) Beastkin feats, plus last azarketi linking
-   (Shandyan) Oracle Dedication feats and class features
-   (Shandyan) Catfolk feats and heritages automation
-   (Friz) Clean up a bunch of notation for persistent damage in feats to make them compatible with the persistent damage module

### Core System Improvements

-   (Friz & stwlam) Add roll vs DC difference next to result on cards
-   (stwlam) Address subtle perceived-light edge cases and reduce flickering
-   (stwlam) Allow setting of light emission angle in rules-based vision
-   (stwlam) Add level data to all actor types, bring hazard level structure in line with the rest
-   (stwlam) Allow adding custom potency modifiers when ABP is enabled
-   (stwlam) Add origin flag to standard item card messages
-   (stwlam) Filter out invalid character sense data until the property can be migrated
-   (stwlam) Limit the scope of font emboldening to chat messages and system sheets
-   (stwlam) Remove Nodesto font from system
-   (stwlam) Add warning to confirmation dialog of compendium import-all feature
-   (stwlam) Skip setting NPC token disposition on creation if the create data is sourced
-   (stwlam) Add an ActiveEffect-like rule element
-   (stwlam) Use better icons and add labels to damage buttons. Closes #1460
-   (stwlam) Allow shorter key names for rule elements
-   (stwlam) Replace combat-turn hooks with method overrides
-   (Drental) Move links to wiki and changelog out of the PC sheet
-   (Drental) Add repost functionality for inline rolls in chat
-   (Tikael) Consolidate inline checks into `data-pf2-check`
-   (Tikael) Pass options to inline flat checks
-   (Tikael) Inline effect area templates
-   (xdy) Add localization for untranslatable mystification UI fields. Closes #1560
-   (xdy) Improve localization of the familiar sheet. Closes #1569
-   (xdy) Show a 'triple damage' button on damage chat cards if the critFumbleButtons setting is on. Closes #1552
-   (xdy) Add roll notes to all actions that didn't already have them. Closes #1530
-   (xdy) Add setting to hide the world clock button. Closes #1365
-   (xdy) Enable translation for creature initiative changed and damage roll flavor text in chat cards
-   (xdy) Better support for localization in the roll dialog
-   (In3luki) Add importer API for ancestry/background/class item creation at 'game.pf2e.importer.actor'
-   (In3luki) Add highlighting of the speaker's token when a chat message is hovered. Add the ability to left-click the sender's name select or release token
-   (Supe) Pull Item/Actor for chat buttons from flags instead
-   (Supe) Spellcasting ability modifier is now in roll data as `mod`
-   (Supe) Update legacy spellcasting to new structure and fix spell drag and drop
-   (Supe) Spells can now be dropped at any level without either polluting the actor data with orphaned spell, or end up in the wrong level
-   (Supe) Focus and ritual are now spellcasting types, not traditions
-   (Supe) Reuse spell mod roll data instead of recalculating it

## Version 2.9.1

### Bug Fixes

-   (stwlam) Fix toggling core "death" token overlay

### Content Changes

-   (nikolaj-a) Fix demonblood frenzy prerequisites format
-   (Drental) Fix token sizes for some Fists of the Ruby Phoenix monsters

### Core System Improvements

-   (stwlam) Allow NPC-looting if its token is marked as defeated

## Version 2.9.0

### Bug Fixes

-   (stwlam) Decouple the World Clock's synchronize-darkness feature from Unrestricted Global Vision. Closes #1098
-   (stwlam) Fix template-partial reference on NPC sheet, ensure hit points never fall below zero. Closes #1577
-   (stwlam) Fix clamping current hit points from NPC and character sheets
-   (stwlam) Ensure presence of value in a Check DC label when a value is included
-   (Tikael) Add clear filter button to feat tab in compendium browser. Closes #1575

### Content Changes

-   (rectulo) Remove extraneous styling from taloned tengu ancestry feature description
-   (rectulo) Remove extraneous styling from wyrmblessed bloodline sorcerer class feature description
-   (rectulo) Fix damage die for toxic skin grippli reaction description
-   (rectulo) Adjust frightful goloma heritage description
-   (rectulo) Add missing work in bristle feat effect description
-   (rectulo) Moved prerequisites for demonblood frenzy orc ancestry feat to the item sheet sidebar
-   (Tikael) Fix number of abilities granted by Enhanced Familiar
-   (Tikael) Automate Martial Artist dedication. Closes #1459
-   (Tikael) Add new bloodlines to the Bloodline class feature description. Closes #1578
-   (Tikael) Add Vehicle subsystem actions
-   (Tikael) Add no-prep character Gristleburst
-   (Tikael) Add missing conrasu heritage and its call to axis action
-   (Tikael) Set correct type for some mislabeled heritages
-   (Tikael) Fix up animated dragonstorm. Closes #1574
-   (SpartanCPA) Abomination Vaults - Floor 1 Monster Audit
-   (TMun) Incorporate Lost Omens errata changes

### Core System Improvements

-   (stwlam) Add setting to opt out of the system's JournalEntry theme
-   (stwlam) Set a maximum perceived darkness level of 0.925 for basic usability
-   (stwlam) Remove automatic setting of prototype token name to actor name
-   (Supe) Pass roll data to item chat descriptions
-   (Drental) Use assigned character as effect macro fallback when no tokens are selected
-   (Tikael) Add flat check inline buttons

## Version 2.8.1

### Bug Fixes

-   (stwlam) Fix setting token brightSight to a radius larger than Foundry will allow
-   (stwlam) Restore perceived brightness of sourced lights
-   (stwlam) Set initial schema version on newly-created owned items
-   (Supe) Fix regression with roll syntax values rule element referencing item data

### Content Changes

-   (TMun) Update conrasu so they aren't immortal. Closes #1571
-   (rectulo) Remove extraneous styling from stormtossed tengu heritage description
-   (rectulo) Remove extraneous styling from mountainkeeper tengu heritage description

### Core System Improvements

-   (Tikael) Add collision fields to vehicle data and vehicle sheet

## Version 2.8.0

This release features most of the new content from Lost Omens: Mwangi Expanse, Malevolence, and all three books of Fists of the Ruby Phoenix.

### Bug Fixes

-   (Chup) Fix trait descriptions in player character strikes. Closes #1553
-   (stwlam) Bring limited PC sheet up to date with passed sheet data
-   (stwlam) Fix adjustment of perceived brightness from sourced lighting. Closes #1559
-   (stwlam) Fix management of conditions from character sheet
-   (Supe) Fix spell item summary width when there is no description

### Content Changes

-   (SpartanCPA) Correct Kyra (Beginner Box) spellcasting stat from Cha to Wis. Closes #1555
-   (SpartanCPA) Rename creatures from Age of Ashes that are re-printed in Mwangi Expanse
-   (TMun) Add fulu as a consumable trait (Fists of the Ruby Phoenix book 2)
-   (TMun) Add adjustment trait to equipment list for Mwangi expanse
-   (TMun) Add reach-50 and versatile positive traits. Add virulent to feat traits. Add troop to actor traits
-   (TMun) Add Fists of the Ruby Phoenix book 3 missing traits (Kaiju, Primal for Hazard, concentrate)
-   (TMun) Add air as an immunity for Fists of the Ruby Phoenix book 3
-   (TMun) Add area data to cataclysm. Closes #1563
-   (TMun) Add splendid skull mask item. Link skull creeper feat to mask item. Closes #1564
-   (TMun & SpartanCPA & Tikael) Content from Lost Omens: Mwangi Expanse, Malevolence, and all three books of Fists of the Ruby Phoenix, including traits, actions, deities, bestiary effects, equipment effects, feat effects, spell effects, spells, equipment, ancestry features, ancestries, sorcerer bloodlines, archetypes, and bestiary entries
    Completes build of LO:ME, FotRP 1-3 and Malevolence
-   (rectulo) Remove extraneous styling from invoke the crimson oath focus spell description
-   (rectulo) Remove extraneous styling from consecrate ritual description
-   (rectulo) Remove extraneous styling from pillar of water spell description
-   (rectulo) Remove extraneous styling from resurrect ritual description
-   (rectulo) Remove extraneous styling from curse of death witch focus spell description
-   (rectulo) Remove extraneous styling from stasis cleric focus spell description
-   (rectulo) Remove extraneous line breaks from soul siphon oracle focus description
-   (rectulo) Remove extraneous line breaks from life link oracle focus spell description
-   (rectulo) Fix typo in abyssal wrath sorcerer focus spell description
-   (rectulo) Add proper styling to the heightened heading for heal animal druid focus spell description
-   (rectulo) Fix wording for dazzled duration in splash of art cleric focus spell description
-   (Friz) Brush up rule elements for tanglefoot bombs
-   (Friz) Update bombs with persistent damage to add notes with critical effects. Also include persistent damage note for fire poi

### Core System Improvements

-   (stwlam) Add a client-side permission check for updating tokens
-   (stwlam) Add compendium browser lookup. Closes #1550
-   (stwlam) Track schema version of actors and items
-   (stwlam) When necessary, migrate actors and items as they're created
-   (stwlam) Do not show a skill feat slot if no such options are configured for the selected background
-   (stwlam) Sort tag-selector options according to localized labels
-   (stwlam) Load the Compendium Browser earlier in the ready hook
-   (stwlam) Include item uuid and type in attack and damage roll messages. Closes #1283
-   (Supe) Add getters to SpellcastingEntry/Spell. SpellcastingEntry now has a spells collection
-   (Supe) Update Player and NPC Sheet spell list
-   (In3luki) Sort class features created by the ABCManager by level and name

## Version 2.7.1

### Bug Fixes

-   (stwlam) Add back Con-modifier to hit points

### Content Changes

-   (stwlam & Tikael) Remove prices and descriptions from bandoliers, belt pouches, satchels, scroll cases, sheaths, and vials

## Version 2.7.0

### Bug Fixes

-   (stwlam) Always show marked signature spells at their base level despite lack of slots. Closes #1545
-   (stwlam) Restore ancestryhp and classhp properties to character attributes
-   (Supe) Fix translation of currency label
-   (nikolaj-a) Fix weapon toggle traits for strikes

### Content Changes

-   (Drental) Add inline saving throw links to some of the equipment, like alchemical items
-   (TMun) Add Mwangi Languages and updates OpenGameLicense.md
-   (TMun) Add traits and languages from Mwangi Expanse and Fists of the Ruby Phoenix
-   (TMun) Add cone size to cone of cold spell
-   (TMun) Add explicit variants for assurance for all non-lore skills
-   (TMun) Fix Android lore to use \n instead of /n for newline breaks
-   (Supe) Old NPC innate spells are now re-orderable, for newly imported actors
-   (rectulo) Correct description text for feeblemind spell
-   (rectulo) Fix a typo in the pied piping spell description
-   (rectulo) Remove extraneous newline in ancestral touch spell description
-   (rectulo) Remove second linking of hidden condition from dim the light spell description
-   (rectulo) Remove extraneous newlines in tempest touch spell description
-   (rectulo) Remove extraneous styling from charged javelin spell description
-   (SpartanCPA) Tweaks to morlocks

### Core System Improvements

-   (stwlam) Fix token vision updates during movement
-   (stwlam) Add damage-roll option to combine roll terms, enable for spellcasting
-   (stwlam) Record the originating item uuid and item type on RuleElementPF2e instances
-   (stwlam) Add strike damage formula tooltips to damage buttons on character sheets
-   (stwlam) Removed unused browser-settings.html template file
-   (stwlam) Migrate embedded spells on scrolls and wands
-   (stwlam) Migrate precious material value of "sovereign steel"
-   (Friz) Added text to shift-click damage/heal dialog to make it more obvious what sign modifier to use
-   (Friz) Add button to misidentify/identify dialog that allows GM to send skill rolls to chat
-   (Supe) Show casting time action glyph in the spell sheet sidebar

## Version 2.6.0

This release might break some of the action macros if you're using a language module due to a change in the structure of the translation data. The authors of all known language modules have been notified and should update the modules for the new structure very quickly.

### Bug Fixes

-   (stwlam) Fix issue with the compendium browser where Bestiaries wouldn't properly load if Hazards had been opened first

### Content Changes

-   (SpartanCPA) Tweak Ki Strike duration and token icon
-   (Tikael) Add automation to Grievous Blow feat
-   (Tikael) Add a default sneak attack rule element to the bestiary feature
-   (Tikael) Correct size of Xotani
-   (Bolt) Brush up morlocks
-   (rectulo & Njini) Add heightening effect description to synesthesia
-   (stwlam) Prune unused data from old NPC compendium entries

### Core System Improvements

-   (stwlam) Adjust light emitted by other tokens according to rules-based vision. Closes #1547
-   (stwlam) Move perceived-light management from tokens to the user
-   (In3luki) Ensure all required fields are present when processing a compendium index
-   (In3luki) Add null check to feat prerequisite preparation in the compendium browser
-   (nikolaj-a) Add pick a lock action macro
-   (nikolaj-a) Add outcome notes to create a distraction, seek and sense motive action macros

## Version 2.5.3

### Content Changes

-   (SpartanCPA) Agents of Edgewatch Book 6 (Final)
-   (SpartanCPA) Add Auditory as an attack trait
-   (SLATE) Fix name and rule elements for Eye of the Night dhampir ancestry feat

### Core System Improvements

-   (In3luki) Greatly improves the loading times of the compendium browser. Closes #1546
-   (stwlam) Ensure each compendium browser tab can only load packs with the correct type of items or actors
-   (stwlam) Sort packs in settings menu of compendium browser
-   (stwlam) Refresh lights when a character's senses are updated

## Version 2.5.2

### Bug Fixes

-   (stwlam) Remove risk of stack overflow during lighting refresh

### Content Changes

-   (stwlam) Add Darkvision spell effects

### Core System Improvements

-   (nikolaj-a) Add outcome notes to climb, disarm, force open, grapple, high jump, long jump, shove, and swim action macros

## Version 2.5.1

### Bug Fixes

-   (In3luki) Fix sorting of class features not working on the first drop
-   (stwlam) Fix cantrip filter in compendium browser, organize spell traits better
-   (stwlam) Fix GM info for unidentified items
-   (stwlam) Prevent rarer and higher-level weapons from reverting to common and zero
-   (stwlam) Ensure ABC items take their features with them when deleted. Closes #1541
-   (stwlam) Fix bug triggered by check against non-existent `invested` property
-   (stwlam) Remove "text-transform: capitalize" styling from journal entry headers. Closes #1542
-   (stwlam) Fix loading of compendium browser settings. Closes #1544
-   (stwlam) Fill localization gaps for weapons with potency and property but no striking runes
-   (stwlam) Fix newly-created items not appearing in the item directory until sheet is closed
-   (stwlam) Make compendium browser's spell-category filtering mutually exclusive between "cantrip" and "spell"

### Content Changes

-   (SpartanCPA) Add more deadly dice presets: 4d8, 4d10, 4d12
-   (SpartanCPA) Correct levels of Bard cantrips
-   (SpartanCPA & Peenicks) Agents of Edgewatch Book 6 - Items & Spells
-   (SpartanCPA & Peenicks) Agents of Edgewatch Book 6 - Missing NPCs (Part 1 & 2)
-   (stwlam) Add size active effect to Wisp Fetchling heritage. Closes #1515
-   (Tikael) Add finesse trait to Dragon Claws spell effect strikes
-   (Drental) Add bon mot, veil of dreams, and incredible improviser effects and rule elements
-   (TMun) Brush up Treerazer for 0.8.8/2.5.0. Closes #1429
-   (Bolt) Brush up Troll
-   (Bolt) Fix note order for Aasimar Redeemer

### Core System Improvements

-   (stwlam) Increase dim light on placed lighting to bright for tokens with low-light/darkvision
-   (stwlam) Set token-source dimSight and brightSight to 0 if rules-based vision is enabled
-   (nikolaj-a) Support capping spell auto-heighten level (mostly relevant for dealing with some NPC corner cases)
-   (nikolaj-a) Make new effects have unlimited duration by default
-   (nikolaj-a) Add outcome notes to balance, maneuver in flight, squeeze, and tumble through action macros

## Version 2.5.0

### Bug Fixes

-   (stwlam) Fix bug causing derived traits on armor to be wiped. Closes #1521
-   (stwlam) Fix tokens becoming unhidden when not in hidden-when-empty mode. Closes #1526
-   (stwlam) Reduce memory consumption of compendium browser and add some features (resizeable window, choose sort direction, sorting by equipment price), ability to drop an actor or item directly beneath the compendium browser window. Closes #625, #1375, #1325
-   (stwlam) Fix sortability of items within a container. Closes #1533
-   (stwlam) Safely interpolate action names during macro creation. Closes #1536
-   (stwlam) Fix the default permission of the Raise a Shield macro. Closes #1525
-   (stwlam) Fix dropping conditions on tokenless actors
-   (Drental) Fix +-4 modifier to spell dc/attack from elite/weak adjustment. Closes #1424
-   (In3luki) Fix rollMode setting not working for rerolls
-   (In3luki) Fix class feats being added multiple times when character level is decreased and then increased again

### Content Changes

-   (rectulo) Delete page reference from legendary sneak general skill feat description
-   (rectulo) Delete page reference from hidden condition description
-   (rectulo) Remove extraneous HTML from steal the sky archetype feat description
-   (rectulo) Clean up excessive line breaks in combat reading bard class feat description
-   (rectulo) Add missing requirements to cross the final horizon archetype feat
-   (rectulo & Njini) Fix guiding chisel description text to include missing sentences for Activate, Frequency, and Effect
-   (rectulo & Njini) Correct link to _see invisibility_ in robe of eyes description
-   (TMun) Update auldegrund grimcarver so he does fire, not fifire damage
-   (TMun) Corrects dragon claws spell effect duration from 1 round to 1 minute. Closes #1534
-   (TMun) Add Ganzi Skillful tail feat
-   (Drental) Remove page references
-   (SpartanCPA) Correct NPC lore descriptions
-   (SpartanCPA) Split Cantrip Expansion into two feats for prepared vs. spontaneous
-   (SpartanCPA) NPC Gallery Audit (Devotees, Downtrodden, Explorers, Healers, Laborers, Magistrates, Poacher)
-   (SpartanCPA) Traits needed for Agents of Edgewatch Book 6
-   (SpartanCPA) Add source to Bestiary 3, PFS NPCs, April Fool's Bestiary, Pathfinder Blog Bestiary, Beginner Box, Age of Ashes book 5, Extinction Curse book 3, The Fall of Plaguestone, Little Trouble in Big Absalom, Troubles in Otari, and The Slithering compendium entries, for proper filtering in the compendium browser
-   (SpartanCPA) Add missing entries from Menace Under Otari, removed filth fever from giant rat in Beginner Box
-   (Tikael) Fix Ancient White Dragon Ground Slam DC. Closes #1522
-   (Tikael) Add new no-prep character Wendlyn
-   (Tikael) Change familiar abilities to unlimited duration
-   (Tikael) Add instructions for making specific scrolls and wands to the generic items
-   (Tikael) Fix broken links in the alchemist class features preventing proper automation. Closes #1535
-   (mathmanpi) Fix Piranha Swarm bludgeoning resistance
-   (Shandyan) Add automation to aphorite versatile heritage and feats (axiomatic lore, intuitive crafting, lemma of vision)
-   (Shandyan) Azarketi automation part 1

### Core System Improvements

-   (Tikael) Stop striking and weapon potency from warning about values of zero
-   (Friz) Add separate option to allow GM to control visibility of both DC and results
-   (BoMbY) Make recovery DC/result always visible to players
-   (In3luki) Create new conditions in a single database transaction, which should improve speed and reliability when applying conditions
-   (In3luki) Add 'two-degrees-better' and 'two-degrees-worse' to DC modifiers
-   (In3luki) Refactor ABC item creation for better reliability on character creation and level-up
-   (stwlam) Finish cleaning up display of traits on item sheets
-   (stwlam) Initial implementation of material and rune-base weapon names, prices, etc.
-   (stwlam) Make item cards and summaries fancier
-   (stwlam) Remove attack and damage buttons from weapon chat cards
-   (Supe) Show final heightened spell level in chat card title
-   (Supe) Spells with cantrip trait are always cantrips (unless ritual)
-   (Supe) Cantrips can no longer be 0th level, and will now show the heightened level in the chat card
-   (Supe) Updated spell editor arrangement
-   (Tikael) Add skills and perception to the inline button options
-   (nikolaj-a) Add weapon base item value to attack and damage selectors
-   (nikolaj-a) Increase line height slightly for the compact roll notes
-   (nikolaj-a) Add notes for outcome of the trip action

## Version 2.4.0

### Bug Fixes

-   (Drental) Fix NPC damage rolls with non-dice values
-   (Drental) Fix light bulk label for armor and treasure
-   (stwlam) Fix consumption of wands
-   (Chup) Fixed actions and inventory of vehicle sheet. Closes #1167 and #1494
-   (nikolaj-a) Make rules tab in item sheet less temperamental on syntax error

### Content Changes

-   (SpartanCPA) NPC Gallery Audit (Criminals)
-   (SpartanCPA) Remove page references to the Core Rulebook
-   (SpartanCPA) Add action category definitions where needed to NPCs in Extinction Curse
-   (Shandyan) Ranger and Rogue Critical Specialisation, plus Ruffian Sneak Attack
-   (Shandyan) Update Giant Instinct to use new `weapon:oversized` predicate
-   (Shandyan) Add automation for aasimar heritage and ancestry feats (angelkin, blessed blood, call of elysium, celestial eyes, celestial lore, celestial strikes, celestial wings, divine countermeasures, emberkin, enforced order, eternal wings, garuda's squall, idyllkin, lawbringer, musetouched, plumekith, truespeech)
-   (Shandyan) Add automation for android ancestry features (constructed, emotionally unaware), heritages (artisan, impersonator, laborer, and warrior android), and feats (android lore, emotionless, nanite surge, nightvision adaptation, offensive subroutine, protective subroutine, and proximity alert)
-   (TMun) Convert impossible volley into three versions
-   (TMun) Add 45, 75 and 90 foot options to support emanations with +15 foot per level heightening for NPCs
-   (TMun) Correct spells for Quelaunt. Closes #1508
-   (TMun) Lionlodge compendium additions
-   (rectulo) Clean up reflecting riposte fighter class feat description text
-   (rectulo) Clean up prescient planner general feat description text
-   (rectulo) Clean up bargain hunter general skill feat description text
-   (rectulo) Fix typo in terrified retreat feat prerequisite
-   (rectulo) Remove page reference from foil senses general skill feat
-   (rectulo) Correct level for eldritch researcher feat
-   (Drental) Fix Take Cover macro to properly add the cover effect on NPC actors
-   (Drental) Fix perception and stealth for selected tokens macros
-   (Tikael) Add default weapon potency and striking rule elements to handwraps

### Core System Improvements

-   (In3luki) Update AdjustDegreeOfSuccess rule element to support attack rolls
-   (Drental) Clarify the text for the standard flatfooted toggle
-   (stwlam) Make console error for multiple feats in same slot a debug message
-   (stwlam) Move Rest for the Night macro to typescript, fix for 0.8. Closes #1510
-   (Tikael) Add min and max properties to flat modifier
-   (Tikael) Change WeaponPotency and Striking rule elements to use the values from the item

## Version 2.3.0

### Bug Fixes

-   (stwlam) Prevent error during localization of custom attributes and other properties
-   (stwlam) Prevent distortion of smaller loot actor icons. Closes #1504
-   (stwlam) Fix decrementing consumable quantities
-   (stwlam) Fix bug causing extra "0" entry to get added to item data
-   (stwlam) Fix Raise a Shield macro
-   (nikolaj-a) Fix PC strike options for damage rolls
-   (nikolaj-a) Fix show target AC in strike chat card

### New Features

-   (stwlam) Implement basic rules-based vision mechanics. This feature is still experimental and has been included for user feedback

### Content Changes

-   (SpartanCPA) Add "Splash 10 ft" trait
-   (SpartanCPA) Rename Wizard and Witch Spell Effects
-   (SpartanCPA) Correct base item of Spiritsight Crossbow
-   (SpartanCPA) Add Damage Dice override to Crossbow Ace. Closes #1509
-   (SpartanCPA) Extinction Curse Book 5 - Adventure Toolbox Monsters
-   (Drental) Fix skinsaw murderer weapon damage
-   (rectulo) Clean up the verdant presence druid feat description text
-   (rectulo) Clean up tenacious blood sorcerer class feat description text
-   (rectulo) Correct formatting of Cloak of Immolation description
-   (rectulo) Add prerequisites for denier of destruction cleric class feat
-   (Friz) Add rule elements for persistent damage and other notes to alchemical bombs

### Core System Improvements

-   (stwlam) Move automation settings to a menu
-   (stwlam) Fix journal-entry styling with tables
-   (stwlam) Call a `pf2e.systemReady` hook to help modules know when it is safe to access system-specific applications
-   (stwlam) Add ability to hide a loot token when its inventory is empty
-   (stwlam) Remove previously applied monkey patch for exporting a folder to compendium, since the fix was now included in core Foundry
-   (stwlam) Allow drag and drop of folders with sub-folders of items to an actor
-   (Drental) Add DC visibility to metagame settings
-   (Supe) Capture spell level for drag data
-   (nikolaj-a) Set level of effect when dragged from spell chat card
-   (nikolaj-a) Add support for the Defy Death orc feat
-   (nikolaj-a) Allow "none" as an option for check DC visibility in the chat cards
-   (nikolaj-a) Add support for targeting and DC resolving for action macros
-   (nikolaj-a) Add built-in action and associated macro for hide, sense motive, and sneak

## Version 2.2.0

### Bug Fixes

-   (stwlam) Restore functionality of "Skip Defeated" in combat tracker. Closes #1493
-   (stwlam) Fix version displayed in migration messages
-   (stwlam) Fix application of active effects modifying properties set by ABC items
-   (stwlam) Fix Tough familiar ability
-   (stwlam) Fix bulk adjustments according to creature and item sizes
-   (stwlam) Issue a warning about orphaned spells instead of blocking the data preparation
-   (nikolaj-a) Fix NPC sidebar effect rendering

### Content Changes

-   (rectulo) Change azaersis roads from class feat to hobgoblin ancestry feat
-   (rectulo) Remove unused styling from the reckless abandon barbarian feat
-   (rectulo) Remove page reference from auspicious mount champion feat
-   (Friz) Add roll notes to the Burn It! feat to remind of the extra damage for alchemical items
-   (Friz) Fix blight bomb damage so the persistent damage component is in a roll note. Closes #1479
-   (Shandyan) Alchemist feature formatting
-   (SpartanCPA) Fix Persistent Damage. Closes #1487

### Core System Improvements

-   (stwlam) Work around Foundry 0.8.6 bug by overriding Folder#exportToCompendium
-   (stwlam) Remove all deprecated objects attached to the global namespace
-   (stwlam) Remove Calendar/Weather integration for World Clock
-   (In3luki) Add special styling for elements that are only visible to the GM. Closes #1481
-   (In3luki) Add even more checks to the crit card buttons
-   (Drental) Add macro to open compendium browser
-   (Supe) Maintain actor sheet scroll position and expanded item summaries
-   (BoMbY) Convert recovery check to roll with DC and notes
-   (nikolaj-a) Flag to disable ABP for individual actors
-   (nikolaj-a) Add weapon category option to PC strikes
-   (nikolaj-a) Add weapon size options to PC strikes

## Version 2.1.1

### Content Changes

-   (SpartanCPA) Remove Rule Element from the Bestiary "Low-Light Vision" ability
-   (nikolaj-a) Fix misspelled flat modifier rule elements for hamatula, hellcat, hezrou, and hound archon

## Version 2.1.0

### Bug Fixes

-   (stwlam) Fix updating tokens from NPC attitudes
-   (stwlam) Purge martial items, set any weapon with a martial item's ID as a category to "simple"
-   (stwlam) Fix setting of non-default token image
-   (stwlam) Fix updating spontaneous spell slot value on character sheet
-   (stwlam) Get intended changes of numeric values on actor sheets despite modification via data preparation (fixes the broken animal companions)
-   (stwlam) Ensure derived traits are not unintentionally saved
-   (In3luki) Fix the degree of success for rerolled checks not applying the modifier
-   (In3luki) Fix attack rolls not displaying the degree of success against targeted tokens for NPCs
-   (In3luki) Fix derived data being saved for weak or elite NPCs
-   (In3luki) Fix critical card drawing for spell attacks
-   (In3luki) Remove the attack buttons from the chat card if the weapon is not on a creature
-   (In3luki) Fix chat damage buttons not applying damage to shields
-   (In3luki) Adjust the level of elite or weak NPCs by 1. Closes #1426
-   (nikolaj-a) Fix available scroll and wand heightening levels

### Content Changes

-   (TMun) Add cursebound trait to Brain Drain Oracle Focus Spell. Closes #1454
-   (TMun) Add 15 foot cone to Cry of Destruction Spell. Closes #1464
-   (TMun) Add rule element for Razor Claws lizardfolk feat. Closes #1449
-   (TMun) Correct Gorilla Stance modifiers. Closes #1443
-   (TMun) Correct bomb snare craft requirements. Closes #1440
-   (TMun) Add ranger tag to the three masterful hunter class features. Closes #1437
-   (TMun) Add text on focus points to Oracle Class. Closes #1428
-   (TMun) Correct damage from 1d6 to 1d10 for taw launche, and change default from strength to dexterity for modifier. Closes #1422
-   (TMun) Correct Gibtas Bounder from AV bestiary. Add missing passives. Correct attack traits and damage. Correct descriptions of attacks. Correct flags on attacks for range. Closes #1401
-   (TMun) Corrects level of pearly white aeon stone from 35 to 3. Closes #1474
-   (TMun) Add ringmaster's introduction from Extinction Curse book 6. Closes #1476
-   (TMun) Add Pathfinder Society mentor boon automation. Closes #1458
-   (TMun) Update to Lizardfolk Defender
-   (TMun) Add hazards for both tiers of quest 9 of Pathfinder Society. Add Aeon Nexus, Automatic Fire Suppression, and Grasping Limbs. Closes #1448
-   (TMun) Correct Level for Malarunk. Closes #1478
-   (TMun) Add pregens from Lionlodge (One-Shot 2)
-   (Shandyan) Formatting for alchemist feats to add links to conditions, pre-req feats, features, items etc. Add placeholder features for research field-specific features to add to alchemist class item
-   (Shandyan) Rogue automation, including some formatting, effects, and feats. Analyze weakness, brutal beating, bullseye, deadly poison weapon, improved poison weapon, nimble dodge, nimble roll, poison weapon, predictable!, sly striker, you're next. Added duration tracker for debilitating strike and enduring debilitations
-   (Shandyan) Sorcerer automation, including spell effects, feat formatting, and rule elements for bloodline resistance, diverting vortex, entreat with forebears
    -   Feats: anoint ally, bloodline resistance, diverting vortex, entreat with forebears
    -   Spells: angelic wings, arcane countermeasures, celestial brand, diabolic edict, dragon claws, dragon wings, elemental motion, glutton's jaw, nymph's token, unusual anatomy
-   (Shandyan) Swashbuckler automation, including effects. Formatting of actions, features and feats. Rule elements and effect links for Charmed Life, Flamboyant Cruelty, Swaggering Initiative, and Vivacious Bravado
-   (Shandyan) Witch automation, including effects
    -   Feats: Eldritch Nails, Living Hair, and Witch's Cauldron
    -   Spells: Blood Ward, Discern Secrets, Nudge Fate, and Stoke the Heart
-   (Shandyan) Wizard automation, including effects
    -   Spells: Augment Summoning, Physical Boost, and Shifting Form
-   (Shandyan) Correct areas and other details for sorcerer focus spells
-   (Shandya) Rules elements to upgrade saving throws from class features
-   (stwlam) Add token size active effect to Spell Effect: Pest Form
-   (stwlam) Several Abomination Vaults and a single Pathfinder Society NPC were missing their image
-   (SpartanCPA) Add active effect support to Ancestral Weapon Familiarity feats
-   (SpartanCPA) Add rollable button to Dragon's Rage Breath feat to properly roll dice based on character level
-   (SpartanCPA) Add "Thrown 15 ft." weapon trait
-   (SpartanCPA) NPC Gallery brush-up
-   (SpartanCPA) Reformat tables in equipment descriptions
-   (SpartanCPA) Correct typo in Grunka and change description for both Grunka and Pelmo from Agents of Edgewatch book 1
-   (SpartanCPA) Brush-up of goblins, hobgoblins, and goblin dog from Bestiary 1
-   (rectulo & In3luki) Update enforce oath with prerequisites
-   (rectulo) Clarify reactive transformation prerequisites
-   (rectulo) Clean up guiding finish description
-   (rectulo) Add requirements to tangled forest rake description
-   (rectulo) Update tourmaline sphere aeon stone description
-   (bapacibl) Add positive trait to healing potions. Closes #1407
-   (SLATE) Fix Sarenrae boons and curses to her properly spelled name

### Core System Improvements

-   (stwlam) Re-arrange type declarations to speed up load times
-   (stwlam) Propagate AEs modifying actors' prototype tokens to the corresponding tokens on the canvas
-   (stwlam) Remove setting to treat coin stacks in different containers separately for bulk calculation, as this was deprecated by the bulk errata
-   (stwlam) Prevent character importers from creating martial items, since these are no longer used
-   (stwlam) Normalize sidebar view between armor and weapons
-   (stwlam) Allow journal entry width to increase when resizing the window
-   (stwlam) Allow the GM to drop a spell anywhere on a loot actor to create a scroll or wand, including on the token
-   (mdizo) Isolate and improve journal entry styles
-   (In3luki) Add a rule element to adjust the degree of success of checks with a DC
-   (In3luki) Remove support for the old roll syntax for strikes and various other checks
-   (In3luki) Support RollNote outcome field for checks using any adjusted outcome
-   (In3luki) Always show RollNotes for checks without a DC
-   (In3luki) Update RollNotes on rerolled checks with a DC
-   (Supe) Expose RuleElementPF2e class as `game.pf2e.RuleElement` for use by modules
-   (Supe) Maintain scroll position when item sheet is edited
-   (nikolaj-a) Move strike targeting logic from the sheet to the actor, allowing easier usage from macros and modules (this also fixes Token Action HUD integration)

## Version 2.0.3

### Bug Fixes

-   (stwlam) Fix UPGRADE Active Effect changes on non-existent data properties
-   (stwlam) Prevent stack overflow on ammo items when looking up token attributes

### Core System Improvements

-   (stwlam) Make invalid proficiency rank errors non-fatal, to prevent the actor from disappearing completely

## Version 2.0.2

### Core System Improvements

-   (stwlam) Re-enable data migrations
-   (stwlam) Add API to manually trigger data migrations

## Version 2.0.1

### Bug Fixes

-   (nikolaj-a) Fix actor data preparation with unmatched martial proficiency category

## Version 2.0.0

This version brings support for the Foundry VTT version 0.8.x line, starting from 0.8.6.

### Bug Fixes

-   (stwlam) Fix FlatModifier rule elements for crawling hand, aerial form bird spell effect, aerial form pterosaur spell effect, and aerial form wasp spell effect
-   (stwlam) Restore editable actor description to loot sheet
-   (mdizo) Fixed current hit points alignment in the PC sidebar
-   (In3luki) Update the degree of success when a check is rerolled
-   (Trollderim) Fix focus point reduction on cantrip cast. Closes #1442
-   (nikolaj-a) Fix damage roll dice sound
-   (nikolaj-a) Fix drag and drop of toggles to the hotbar

### Content Changes

-   (Drental) Add Cunning Rune to weapon runes. Closes #1438
-   (Friz) Fix damage type of Noxious Vapors. Closes #1405
-   (Friz) Fix spelling error in description of Lifting Belt. Closes #1425
-   (SpartanCPA) Favor sheet checkbox over a rule element for applying token icon of spell effects
-   (kageru) Correct Fire Mephit spell DC
-   (stwlam) Add fear trait to Demoralize action, remove skill trait. Closes #1444

### Core System Improvements

-   (stwlam) Expose compendium browser for programmatic access at `game.pf2e.compendiumBrowser`
-   (stwlam) Add support for weapon familiarity type of feats
-   (stwlam) Base character dying/wounded/doomed status on the sheet on applied conditions. Closes #1450
-   (mdizo) Replaced the spellcasting headers and minor design fixes for the spellcasting tab
-   (mdizo) Improved default styling of journal entries
-   (abrault) Only show signature spells at levels with slots
-   (nikolaj-a) Add hooks for turn start and end
