var __defProp = Object.defineProperty;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
const dispositions = {
  [-2]: "",
  [-1]: "enemy",
  0: "neutral",
  1: "friendly",
  2: "player"
};
function handleRenderCombatCarousel(...[app, html]) {
  const { icon, deactivate } = game.settings.get(game.system.id, "combat-tracker-appearance");
  html.addClass("lancer"), html.find("li.card").each((_, e) => {
    var _a, _b;
    const combatant_id = $(e).data("combatant-id"), combatant = (_a = app.combat) == null ? void 0 : _a.getEmbeddedDocument("Combatant", combatant_id, {});
    $(e).addClass(dispositions[(combatant == null ? void 0 : combatant.disposition) ?? -2]);
    const pending = (combatant == null ? void 0 : combatant.activations.value) ?? 0, done = ((_b = combatant == null ? void 0 : combatant.combat) == null ? void 0 : _b.combatant) === combatant ? 1 : 0;
    $(e).find("div.initiative").before(
      '<div class="lancer-activate">' + `<a class="${icon} lancer-combat-control" data-control="activateCombatant"></a>`.repeat(pending) + `<i class="${deactivate} lancer-combat-control done" data-control="deactivateCombatant"></i>`.repeat(done) + "</div>"
    );
  }), html.find(".lancer-combat-control").on("click", (ev) => activateButton(app.combat, ev)), html.find("a.turn").hide(), html.find("div.initiative").hide(), html.find("a.encounter-control[data-action=rollNPC]").hide(), html.find("a.encounter-control[data-action=rollAll]").hide();
}
__name(handleRenderCombatCarousel, "handleRenderCombatCarousel");
function activateButton(combat, ev) {
  var _a;
  if (ev.preventDefault(), ev.stopPropagation(), !combat)
    return;
  const target = ev.currentTarget, combatant = (_a = target.closest(".card")) == null ? void 0 : _a.dataset.combatantId;
  if (combatant)
    switch (target.dataset.control) {
      case "activateCombatant":
        combat.activateCombatant(combatant);
        break;
      case "deactivateCombatant":
        combat.deactivateCombatant(combatant);
        break;
    }
}
__name(activateButton, "activateButton");
export {
  handleRenderCombatCarousel
};
//# sourceMappingURL=combat-carousel-c5414137.mjs.map
