# Changelog

## 4.12.9

### Bugfixes

-   (stwlam) Fix issue causing effects panel to not load when certain conditions were present on an actor

## 4.12.8

### Bugfixes

-   (stwlam) Fix creation of custom physical items on actor sheets
-   (stwlam) Include roll data in effects panel descriptions in case there are inline roll links

## 4.12.7

### System Improvements

-   (Dana) Add shorthand syntax for multiple rollable check buttons
-   (nikolaj-a) Add Aid action implementation
-   (Supe) Convert familiar abilities to the action item type, add abilities frequency display to familiar sheet
-   (xdy) Increase/decrease item quantities by 5 if shift-clicking and by 10 if ctrl-clicking

### Bugfixes

-   (Dire Weasel) Fix item:base roll option for NPC attacks with linked weapon
-   (stwlam) Fix breakdown data of NPC land speeds
-   (stwlam) Fix application of shield AC bonuses to NPCs
-   (stwlam) Fix retrieval of origin actor from inline saving throws
-   (stwlam) Restore localization of Dual Class Feats header on PC sheet
-   (Supe, stwlam) Fix damage-formula construction for formulas lacking "base" damage (affects Tallow Bomb, which only deal splash and persistent damage)
-   (Supe) Fix default action and feat frequency value
-   (Supe) Fix item-creation behavior for exploration and downtime actions
-   (Supe) Restore localization of NPC skill names

### Data Updates

-   (bucket-au) Fix success message for Wellspring Surge
-   (Demorome) Add effects for Choker-Arm Mutagen
-   (Dire Weasel) Add rule elements for Brute Strength, Trident Bully, Festrog's On All Fours, and Tallow Guardian's Melt
-   (Dire Weasel) Fix Heartripper Blade effect
-   (Dire Weasel) Fix missing extreme for Curse of Living Death and Curse of the Hero's Burden
-   (Dire Weasel) Fix spelling mistake in Pit of Toil
-   (Dire Weasel) Remove no-longer-necessary regular success note from Tallow Bombs
-   (Dire Weasel) Update rule elements for Artokus's Fire and Urbel
-   (stwlam) Correct several data fields in Acrobat's Staff
-   (Tikael) Add Affinity Ablaze actions

## 4.12.6

### System Improvements

-   (In3luki) Split Compendium Browser settings into subtabs

### Bugfixes

-   (In3luki) Fix attack roll result being labeled as "DC" instead of "AC"
-   (nikolaj-a) Fix applying ad-hoc modifiers to action checks
-   (stwlam) Fix calculation of battle form land speeds
-   (stwlam) Include roll parameters from mouse events in action macros

### Data Updates

-   (Dire Weasel) Add effect for Ichthyosis Mutagen
-   (Dire Weasel) Add rule element to Battle Medic's Baton
-   (Dire Weasel) Update descriptions and fix inline damage types of Masks of the Banshee
-   (SpartanCPA) Fix name of Benthic Reaver

## Version 4.12.5

### Bugfixes

-   (In3luki) Gracefully handle PC crafting formulas with dangling item references

### Data Updates

-   (Dire Weasel) Add healing links to Holy Prayer Beads

## Version 4.12.4

### System Improvements

-   (stwlam) Speed up loading of PC sheets with large numbers of crafting formulas

### Bugfixes

-   (Supe) Fix formula for familiar perception modifier
-   (Supe) Fix zero damage showing up in persistent damage formulas

### Data Updates

-   (Dire Weasel) Add effects for Resonating Fork - Armor
-   (Dire Weasel) Add template to Shrieker's Shriek
-   (stwlam) Add Authorized and Earthbinding to weapon rune options

## Version 4.12.3

### Bugfixes

-   (stwlam) Fix processing of AC modifier adjustments
-   (stwlam) Fix acquisition of statistics for skill-action macros
-   (stwlam) Fix display of DCs from `IdentifyItemPopup`
-   (Supe) Fix term creation for spells that deal zero damage when unheightened

### Data Updates

-   (Abaddon) Fix inline rolls in Wicked Thorns
-   (stwlam) Fix data error in Dragon's Crest item
-   (TMun) Add Stonewall feat from blog

## Version 4.12.2

### Bugfixes

-   (In3luki) Hide undo damage button if no damage was dealt
-   (stwlam) Fix application of dexterity modifier cap
-   (stwlam) Fix issue causing some predicated AC bonuses to not apply to PCs
-   (stwlam) Fix issue preventing tooltip for AC circumstance bonuses/penalties from appearing in attack roll messages

### Data Updates

-   (Dana) Remove obsolete sheath item from alchemist class kit
-   (Dire Weasel) Fix description of Divine Armageddon and add leveled damage links
-   (Dire Weasel) Fix usage of Bloodthirsty, Crushing, and Cunning runes
-   (Dire Weasel) Update description and REs of Boss Skrawng's Vengeful Anger
-   (Dire Weasel) Update Iloise's Bomb splash from Note to damage
-   (stwlam) Add rule element and effect for Holy Castigation feat
-   (stwlam) Fix Takedown Expert rule elements

## Version 4.12.1

### System Improvements

-   (Supe) Move ammo select below all alternate weapon usages

### Bugfixes

-   (In3luki) Fix crafting items at cost from crafting tab
-   (In3luki) Fix casting spell variants with Trick Magic Item
-   (MrPrimate) Restore access to system internals necessary for the Pathmuncher module
-   (stwlam) Don't send message when using Interact (Modular) action makes no change
-   (stwlam) Fix overrides of PC speeds by battle form effects
-   (stwlam) Fix handling of delta values when updating actor hit points from token HUD
-   (stwlam) Fix issue causing shield AC bonuses to not apply to armorless PCs
-   (stwlam) Fix retrieval of some skills used in inline checks
-   (stwlam) Prevent Firefox from losing its mind on Interact (Modular) select menu
-   (Supe) Fix issue causing some spells to not show damage buttons when cast
-   (Supe) Fix setting of at least trained proficiency to innate spellcasting

### Data Updates

-   (Dire Weasel) Fix description of Cunning rune

## Version 4.12.0

### New Features

-   (In3luki) Add chat-message button to undo damage applied to actors
-   (M. Siebert) Allow GM to exclude content by book source from compendium browser
-   (stwlam) Add versatile- and modular-damage toggling to PC strikes

### System Improvements

-   (Dana) Restore (homebrew) wands to max charges when resting rather than 1
-   (In3luki) Add roll-initiative button to hazard sheets
-   (stwlam) Implement damage reduction from hardness
-   (stwlam) Implement hindering and ponderous penalties
-   (stwlam) Remove the death overlay if present upon hit points being increased
-   (stwlam) Add section on level-one class features to add key ability score options
-   (stwlam) Automatically add object immunities to hazards
-   (stwlam) Don't display token floaty text when GMs update NPC hit points from sheets
-   (stwlam) Drop support for "mundane-attack" rule-element selector (use "strike-attack-roll" instead)
-   (stwlam) Reduce editability on hazard sheet when edit lock is active
-   (Supe) Show result formula for damage roll dialog
-   (Supe) Support any statistic for inline checks
-   (xdy) Show frequency for exploration actions, add month and year action frequencies
-   (xdy) Buy one item (10 for ammunition) from a merchant by default

### Bugfixes

-   (Dire Weasel) Prevent binary-operation predication statements from comparing NaNs
-   (Dire Weasel) Restore actor-sheet rerender upon setting temp HP on round start
-   (LebombJames) Add thoughtsense as a sense type
-   (stwlam) Preserve mystified names of uidentified physical items when used to generate macros
-   (stwlam) Fix edit-mode height of description editor in item sheets
-   (stwlam) Fix localization of base-type labels on armor sheet
-   (stwlam) Fix modification of NPC speeds and their display on sheets
-   (stwlam) Fix refreshing mouse-interactive bounds of unlinked tokens when resized
-   (Supe) Fix autofill options for regeneration deactivation
-   (Supe) Fix breakdown tag for weapon persistent damage
-   (Supe) Fix initiative using skills overriden by battle forms
-   (Supe) Remove incorrect message when adding intercessions to PCs, fix boon sorting
-   (xdy) Update XP budget macro to exclude minions and use actor alliance instead of actor type

### Data Updates

-   (bcronin90) Add effects for Tactical and Vicious Debilitation
-   (bcronin90) Add rule elements to Diverse Lore feat
-   (OrangeChris) Condense Evolution Surge effects
-   (Dire Weasel) Add and update REs for Blade Barrage
-   (Dire Weasel) Add aura effect for Aura of Growth
-   (Dire Weasel) Add aura effect for Fetid Fumes
-   (Dire Weasel) Add rule elements to Aerial Piledriver, Callow May, Grit and Tenacity, Lekmek's False Retreat, Planar Sidestep, Unexpected Shift, Voice of Authority
-   (Dire Weasel) Add damage overlay to Positive Attunement
-   (Dire Weasel) Add effect and leveled damage link for Incendiary Aura
-   (Dire Weasel) Add effects for Champion's Resistance, Energy Shot, Fulminating Shot, Harden Flesh, Hunter's Brooch, Inscrutable Mask, Sanguine Rain, Shock Zombie's Lightning Powered, Bloom Regeneration, Zinba Restoration, Incendiary Ashes, Numbing Tonic, Soul Crush, Soul Lock, Pest Haven
-   (Dire Weasel) Add glass to weakness types
-   (Dire Weasel) Add Noxious Smog aura effect
-   (Dire Weasel) Add persistent damage links to Ancient Dust, Grim Tendrils, Phantom Pain, Savor the Sting, Withering Grasp, and Brutal Critical
-   (Dire Weasel) Add regeneration rule element to Effect: Bully the Departed
-   (Dire Weasel) Add fast healing and regeneration rule elements to several NPCs
-   (Dire Weasel) Add Sneak Attack rule elements for Barrel Launcher, Clockwork Chopper, Clockwork Injector
-   (Dire Weasel) Add spell effect for Hymn of Healing, Magic Stone
-   (Dire Weasel) Add toggle for Warped Fulu
-   (Dire Weasel) Add token light and automation to Flame Tongue and Flame Tongue (Greater).
-   (Dire Weasel) Automate Misery Siktempora's Slash the Suffering, Deinonychus' Predator's Advantage
-   (Dire Weasel) Add rule elements for NPC Surprise Attack abilities
-   (Dire Weasel) Automate Skinstitch Flay damage
-   (Dire Weasel) Correct traits and bulk of Monkey's Fist
-   (Dire Weasel) Fix Animal Instinct Frog jaws attack to be bludgeoning
-   (Dire Weasel) Fix ChoiceSet flag on Effect: Vicious Debilitations to be camelCase
-   (Dire Weasel) Fix Flamboyant Athlete to be passive and add base speed REs
-   (Dire Weasel) Fix inline roll for Facetbound Nullifier Defensive Dispel
-   (Dire Weasel) Fix level of Weapon Mastery in Swashbuckler description
-   (Dire Weasel) Fix Mechanical Torch label
-   (Dire Weasel) Fix name of Spell Effect: Mirror Image
-   (Dire Weasel) Fix reach on Wild Morph Long Vines
-   (Dire Weasel) Fix selectors for Extra Squishy, Fluid Contortionist, Slither, Gruhastha
-   (Dire Weasel) Fix text formatting for Insight Coffee Pumpkin Spice
-   (Dire Weasel) Fix usage of Earthbinding rune
-   (Dire Weasel) Fix Vazgorlu creature level
-   (Dire Weasel) Fix Wellspring Mage Initiative localized string
-   (Dire Weasel) Make some NPC cooldown rolls blind
-   (Dire Weasel) Mark NPC regeneration abilities as deathNote
-   (Dire Weasel) Predicate Flamboyant Athlete base speed REs on Panache
-   (Dire Weasel) Standardize Oracle curse names
-   (Drental) Fix enriched html in kingmaker statblocks
-   (InfamousSky) Add some weapon icons
-   (Manuel Hegner) Fix traits of Shield Warden feat
-   (Mira Mechtley) Fix predicate of energizing lattice
-   (rectulo) Fix alignment of The Rakshasa harrow card
-   (rectulo) Fix formatting of Harrow Bloodline link
-   (rectulo) Fix intro of the harrower archetype
-   (rectulo) Fix level and price of Armory bracelet (Major)
-   (rectulo) Fix shield-throw range of meteor shield
-   (rectulo) Fix the traits of the harrow bloodline
-   (reyzor1991) Add slugs to Anadi fangs, jaws strikes, tail attacks, and some NPC reactions
-   (SpartanCPA) Assign Ancestry icons to non-human pregens
-   (SpartanCPA) Correct the scaling of the Primal Dragon's Cantrips
-   (SpartanCPA) Fix errant token names
-   (stwlam) Add Fast Healing effect to Field of Undeath auras
-   (stwlam) Add inline checks to Ventriloquist's Rings
-   (stwlam) Add rule elements to Urgathoa's Minor Boon
-   (stwlam) Add rule elements to Adopted Ancestry
-   (stwlam) Fix rule elements on Virtuosic Performer
-   (stwlam) Remove dragon-type restriction for non-draconic sorcerers on Dragon Disciple Dedication
-   (Tikael) Add hazards for PFS Scenario 4-12
-   (Tikael) Add spell effects for several Psychic cantrips
-   (Tikael) Add variants to Lay on Hands and Touch of Corruption
-   (Tikael) Automate Lifeblood's Call, Ghost Eater Dedication
-   (Tikael) Brush up automation of Gloom Blade
-   (Tikael) Change treasure keys to equipment
-   (Tikael) Clean up and localize several NPC skill variants
-   (Tikael) Condense Divine Vessel effects
-   (Tikael) Fix focus points added by Psychic Dedication
-   (Tikael) Fix typos in Thrill Seeker background, Eerie Flicker
-   (Tikael) Improve Resonant Reflection automation
-   (Tikael) Standardize lighting roll options
-   (Tikael) Add Paizo blog apex items
-   (TMun) Add NPCs from PFS Quest 14
-   (xdy) Link conditions in descriptions where missing

## Version 4.11.2

### Bugfixes

-   (stwlam) Fix issue causing some actors' prototype token configs to be unopenable
-   (stwlam) Fix issue preventing property runes from being added to unowned armor when ABP is enabled

### Data Updates

-   (Dire Weasel) Clean up description of Acid Splash and add leveled persistent damage link
-   (Dire Weasel) Fix malformed predicate in Tashlock Banyan
-   (LebombJames) Update One Inch Punch to use RollOption suboptions
-   (rectulo) Add "sorcerer" trait to Harrow bloodline
-   (rectulo) Fix formatting of Harrow Bloodline link
-   (stwlam) Fix polytool damage type
-   (stwlam) Fix resolution of feat choices for Ancient Elf heritage
-   (Tikael) Add spell effects for several Psychic cantrips

## Version 4.11.1

### Bugfixes

-   (stwlam) Fix target resolution of spell attack rolls
-   (stwlam) Fix CSS file path passed to TinyMCE editor

### Data Updates

-   (Cerapter) Fix rule elements on Keen Recollection
-   (Chas) Add correct uses to Drain Bonded Item
-   (OrangeChris) Create effects for the spell Wish-Twisted Form
-   (OrangeChris) Fix Advanced Undead Benefits
-   (OrangeChris) Condense Blessing of Defiance effects
-   (Dire Weasel) Add Note RE for Distracting Feint
-   (Dire Weasel) Disable Precise Strike Finisher toggle when Panache effect is not present
-   (Dire Weasel) Add skill variants for some NPCs
-   (Dire Weasel) Fix Night Hag's Nightmare Rider link
-   (Dire Weasel) Remove malformed HTML from Uniila
-   (LebombJames) Fix level and description of Ashen Wind
-   (pedrogrullada) Add some Firebrands and Knights of Lastwall feats to archetypes journals
-   (SpartanCPA) Correct the description of Smoke Curtain
-   (Tikael) Automate Underwater Marauder

## Version 4.11.0

### System Improvements

-   (Dire Weasel) Add "area-effect" to spell RollOptions
-   (In3luki) Improve inventory drag/drop sorting UI
-   (JellyfishJail) Add ability to delete Ancestry/Heritage/Class/Background/Deity from PC sheet
-   (LebombJames) Allow actor img on limited sheet to expand to fit
-   (stwlam) Show reload value in strike and weapon summaries on PC sheet
-   (stwlam) Nag about active sub-V10 modules
-   (stwlam) Use language closer to CRB text for creature identification info on NPC sheet
-   (stwlam) Add support for ephemeral effects on damage application
-   (stwlam) Conditionally count peachwood as darkwood for IWR purposes
-   (stwlam) Include document UUIDs in migration error console messages
-   (stwlam, Supe) Adjust spell damage for elite and weak NPCs
-   (Tikael) Add tint and alpha overrides to TokenImage RE

### Bugfixes

-   (asuffield) Fix stray Misfortune title on legacy D20 rolls
-   (asuffield) Restore check for melee attacks when applying flanking
-   (Cerapter) Allow AdjustDegreeOfSuccess RE to adjust to a specific degree of success
-   (Cerapter) Fix some pre-filtering quirks when opening feat browser from PC sheet
-   (OrangeChris) Hide NPC names on Loot Sheets
-   (Dire Weasel) Fix declining a pick from a ChoiceSet defaulting to first item
-   (stwlam) Show toggle suboptions on NPC sheet
-   (stwlam) Sort ritual levels on actor sheets
-   (stwlam) Exclude rolls with coins from being treated as damage rolls
-   (stwlam) Have `resizeEquipment` option of CreatureSize RE treat small as medium
-   (stwlam) Improve accuracy of warning message when failing to resolve rule element formulas
-   (stwlam) Fix nedb query in choice set of Multitalented feat
-   (stwlam) Fix several issues with battle forms
-   (Supe) Fix heightening for signature spells and when sent to chat
-   (Supe) Fix application of bonuses to initiative rolls predicated on statistic used

### Data Updates

-   (asuffield) Add rule elements to Skill Mastery (Investigator)
-   (OrangeChris) Fix damage on Eidolon breath weapons
-   (OrangeChris) Implement drawbacks to Cognitive Mutagens
-   (Dire Weasel) Add arcane theses links to Wizard
-   (Dire Weasel) Add Assimilate Lava effect
-   (Dire Weasel) Add automation for Accurate Swing
-   (Dire Weasel) Add automation to Reliable Squire
-   (Dire Weasel) Add bonus to Perception DCs against Lie to Straveika
-   (Dire Weasel) Add brawling trait and icon to Lavasoul Magma Spike, localize labels
-   (Dire Weasel) Add damage and spell links to Fiery Body
-   (Dire Weasel) Add effect for Anadi Venom and Note rule element for Disorienting Venom
-   (Dire Weasel) Add effect for Blast Suit
-   (Dire Weasel) Add effect for Elementalist Dedication
-   (Dire Weasel) Add effects for Dread Aura and adjust onDeleteActions for fear auras
-   (Dire Weasel) Add Entangle spell effect
-   (Dire Weasel) Add fast healing rule elements to Crimson Worm, Ofalth, Skeleton Corporal
-   (Dire Weasel) Add materials rule elements to Awakened Shot
-   (Dire Weasel) Add Puff of Poison persistent damage
-   (Dire Weasel) Add Resistance rule elements to Cobra and Rain of Embers Stance
-   (Dire Weasel) Add save link to Fling Magic and remove unleveled damage link
-   (Dire Weasel) Add saving throw links to Spellstriker Staff
-   (Dire Weasel) Add Sickened link to BB Xulgath's Stench
-   (Dire Weasel) Add slashing damage link to Envenom
-   (Dire Weasel) Add strength damage to Hurtling Stone
-   (Dire Weasel) Add temp HP link to Glutton's Jaw and remove brawling
-   (Dire Weasel) Add template to Pyronite Ooze Split
-   (Dire Weasel) Add TokenLight rule element to Candlecap
-   (Dire Weasel) Add tokenlight to Scarecrow Baleful Glow
-   (Dire Weasel) Add trait descriptions for Evolution and Tandem
-   (Dire Weasel) Add unified Effect: Energizing Rune and migrate old links
-   (Dire Weasel) Automate Ash curse
-   (Dire Weasel) Automate Bebilith's Penetrating Strike
-   (Dire Weasel) Automate Piercing Quills bleed damage
-   (Dire Weasel) Automatically grant Flat-Footed for Armor Tampered effect
-   (Dire Weasel) Brush up battle form spell effects
-   (Dire Weasel) Brushup Leshy seedpod strikes
-   (Dire Weasel) Clean up Pest Form description and remove brawling from Shifting Form (Claws)
-   (Dire Weasel) Fix description of Necklace of Fireballs
-   (Dire Weasel) Fix Enfeebled value for Spiritual Epidemic Critical Failure
-   (Dire Weasel) Fix Ezren (Beginner Box) to have 8 gold pieces
-   (Dire Weasel) Fix healing roll for Fruit Leshy
-   (Dire Weasel) Fix heightened level of Phoenix Form fire damage
-   (Dire Weasel) Fix Kundal's level
-   (Dire Weasel) Fix malformed rolls in Briar and Ovinrbaane
-   (Dire Weasel) Fix name of Wand of Traitorous Thoughts
-   (Dire Weasel) Fix perception bonus for Ring of the Tiger (Greater)
-   (Dire Weasel) Fix predicates on Complex Simplicity
-   (Dire Weasel) Fix price of Alchemist's Haversack
-   (Dire Weasel) Fix radius of Horagnamon's Death Throes
-   (Dire Weasel) Fix rarity of Blightburn Bomb
-   (Dire Weasel) Fix rule elements and description of Wildwood Ink
-   (Dire Weasel) Fix Sanguine Fang (Major) spell DC description
-   (Dire Weasel) Fix Trap Finder perception bonus
-   (Dire Weasel) Remove brawling group and unneeded labels from some unarmed attacks
-   (Dire Weasel) Remove Technic Zombie Voltaic Surge roll note
-   (Dire Weasel) Set Corrosive Body DamageDice die size and localize notes
-   (Dire Weasel) Update descriptions of Beast Staff and remove extraneous frost rune
-   (Dire Weasel) Update Fire Poi Note RE to DamageDice
-   (Dire Weasel) Update Flames Curse to grant Concealed and add reminder aura
-   (Dire Weasel) Update Legion Archon from Note to DamageDice
-   (Dire Weasel) Update several Note rule elements to DamageDice
-   (Dire Weasel) Update rule elements for Gluttonworm Sand Armor
-   (Dire Weasel) Convert some spell effects from Notes to DamageDice
-   (Dire Weasel) Update source of Energy and Stone Body Mutagens
-   (InfamousSky) Add Lyzerium to Lyzerius
-   (LebombJames) Brushup automation on Living Monolith
-   (Mason) Add automation to Crossbow Crack Shot feat
-   (MSAbaddon) Remove incorrect sourceId from Popcorn
-   (rectulo) Delete adjustment trait of portable hole item
-   (rectulo) Fix description of greater boulder seed
-   (Roxim) Fix an erroneous at will spell on Quelaunt
-   (stwlam) Add "animal" to hazard traits, include in Sportlebore traits
-   (Tabitha) Add Introspection Domain
-   (Tikael) Add content from the Stolen Fate Player's Guide
-   (Tikael) Fix action cost of Interweave Dispel
-   (Tikael) Localize Hunt Prey ability of Bounty Hunter
-   (TMun) Add radiant wayfinder PFS boon
-   (TMun) Fix heightening for Frightful Feast
-   (TMun) Fix Marrmora spell list

## Version 4.10.4

### Bugfixes

-   (Dire Weasel) Include orichalcum in material damage effects
-   (stwlam) Fix expansion of item summaries on PC effects tab
-   (Supe) Fix perception label in modifiers dialog

### Data Updates

-   (Dire Weasel) Fix name of Devrin's Dazzling Diversion
-   (Dire Weasel) Fix selectors on several Sense rule elements for low-light vision
-   (MrVauxs) Add Deadly D4 trait
-   (stwlam) Fix Dread Marshal Stance effect to apply to all damage rolls

## Version 4.10.3

### Bugfixes

-   (stwlam) Fix generation of magic weapon names

## Version 4.10.2

### Bugfixes

-   (stwlam) Fix setting homebrew base weapon types in weapon sheet
-   (stwlam) Fix toggling of "dead" overlay from status effects HUD

### Data Updates

-   (Dire Weasel) Update Tiger's Claw Note RE to DamageDice
-   (Dire Weasel) Add Note RE to Wolf Drag
-   (Dire Weasel) Add damage type to Sparkblade lightning
-   (InfamousSky) Add labeled counter to Vital Beacon effect
-   (Roxim) Remove bestiary ability link from Reflection of Life
-   (TMun) Add NPCs and items from PFS 4-11
-   (zachjb) Adjust Formulated Sunlight quantity and charges to match rations

## Version 4.10.1

### System Improvements

-   (In3luki) Add `extraRollNotes` and `label` as optional parameters of `StatisticCheck#roll`

### Bugfixes

-   (nikolaj-a) Fix roll substitutions and degree-of-success adjustments in action macros
-   (stwlam) Fix price input on treasure item sheet

### Data Updates

-   (Dire Weasel) Fix Dread Marshal Stance extra damage to only be on strike damage
-   (Dire Weasel) Fix instances of NPCs adding damage dice of type "precision"
-   (Dire Weasel) Add Note to Freezing Ammunition
-   (stwlam) Fix level of Percussive Impact spell
-   (Tikael) Fix functionality of Swashbuckler's Combination Finisher

## Version 4.10.0

### System Improvements

-   (Chup) Add confirmation dialog when selling treasure from inventory
-   (Dire Weasel) Include damage type of persistent damage conditions and NPCs' attacks in roll options
-   (In3luki) Speed up adding event listeners to large numbers of damage chat cards
-   (JellyfishJail) Show effect descriptions in effects panel, add button to send to chat
-   (Rory) Add pre-filtering to action compendium browser
-   (stwlam) Adjust derived equipment prices for size
-   (stwlam) Highlight row of encounter tracker's active turn with alliance color
-   (stwlam) Indicate which users are targeting combatants in Encounter Tracker, add targeting toggle
-   (stwlam) Apply clumsy condition to PCs wielding oversized weapons
-   (Supe) Allow rolling of lore skills for initiative

### Bugfixes

-   (In3luki) Fix several issues with certain types of spell variants
-   (JDCalvert) Propagate auras' levels to the levels of their effects
-   (Rory) Prevent image blurring on sidebar of resized character sheets
-   (stwlam) Fix appearance of duplicate ability modifiers in roll dialog
-   (stwlam) Fix display of rarity in consumable chat cards
-   (stwlam) Inflate kit contents to correspond with its owning actor's size
-   (stwlam) Always show token name as speaker for check messages
-   (stwlam) Automatically add immunities to non-PC creatures with construct trait
-   (Supe) Fix Encouraging Words macro
-   (Supe) Show roll inspector to GM regardless of RE player access

### Data Updates

-   (Dire Weasel) Add Note rule elements to Antler Arrow, Exsanguinating Ammunition, Meteor Shot
-   (Dire Weasel) Add REs and damage links for Crushing Grab, Deadly Strikes, Deflect Arrow, Inner Fire (Monk)
-   (Dire Weasel) Add additional automation to Anjelique Loveless
-   (Dire Weasel) Add bleed damage to Grim Tendrils, clean up description of Phantom Pain
-   (Dire Weasel) Add effects for Conduct Energy, Shining Ammunition, Stoneskin
-   (Dire Weasel) Add leveled damage link to Holy Cascade and Shocking Grasp
-   (Dire Weasel) Add rule elements to Hamatula/Sea Devil Bloodletting, Hit the Dirt!, Infernal Wound, Lawbringer's Lasso, Scalding Spit, Steady Balance, Shanrigol's Shred Flesh, Terror Bird's Tearing Clutch, and Torch Goblin
-   (Dire Weasel) Add toggle for Sunburst Corpse Blinding Aura. Remove duplicate Constrict ability.
-   (Dire Weasel) Automate Bloody Sneak Attack application of Flat-Footed
-   (Dire Weasel) Fix Linzi (Level 1)'s and Tristian (Level 10)'s spellcasting ability, Merisiel (Beginner Box)'s proficiency in Medicine
-   (Dire Weasel) Fix RollOption rule element for Wolf Drag
-   (Dire Weasel) Fix action count of Lekmek's Bark Command
-   (Dire Weasel) Fix damage type in Explosive Ammunition and add Note RE
-   (Dire Weasel) Fix details of Lashing Rope
-   (Dire Weasel) Fix duration in description of Camouflage Dye (Greater)
-   (Dire Weasel) Fix resistance type of Invulnerable Juggernaut and Unstoppable Juggernaut
-   (Dire Weasel) Fix some TokenLight brightness and radius
-   (Dire Weasel) Fix spell slots of Terwa Star Reader
-   (Dire Weasel) Move Yshula's key details to GM note
-   (Dire Weasel) Refresh Harm, Heal, and Searing Light spells on all compendium actors
-   (Dire Weasel) Remove damaging roll option from Meteor Shot emanation
-   (Dire Weasel) Update description of Fighter Weapon Mastery class feature
-   (dogstarrb, Tikael, TMun) Add content from Lost Omens: Firebrands
-   (InfamousSky) Add icon to Belittling Boast
-   (Manni) Fix actions of Topple Crates
-   (MySurvive) Update Sixth Pillar feats to Ruby Phoenix reprint
-   (Rapida) Add stances for Inspiring Marshal Stance and Dread Marshal Stance
-   (stwlam) Add light and heavy barding
-   (stwlam) Add/correct bonuses to save DCs on several feats
-   (Tikael) Add Wyrmblessed bloodline dragon choices to Dragon Disciple
-   (Tikael) Add skill selection to Skilled Heritage
-   (Tikael) Grant actions from Time Traveler background, Unexpected Sharpshooter Dedication feat
-   (Tikael) Add missing traits to fulcrum lens
-   (Tikael) Allow Elemental Bloodline Sorcerer to select an Elemental Type
-   (Tikael) Automate the skill selection of Marshal Dedication
-   (Tikael) Brushup Barbarian class feats
-   (Tikael) Data Entry World changes for March
-   (Tikael) Fix Frog Animal Instinct's tongue strike
-   (Tikael) Fix rage damage of Animal Instinct given Greater Weapon Specialization
-   (Tikael) Fix strike details on Gatewalkers actors
-   (Tikael) Fix rule elements on Combination Finisher feat, Tempest mystery
-   (Tikael) Tone down Lantern light REs
-   (tyrielv) Fix rule element on Dragon's Presence

## Version 4.9.3

### Bugfixes

-   (In3luki) Fix trait pre-filtering from character sheet's feats tab
-   (stwlam) Fix setting of primary class DC's key ability when in manual-entry mode
-   (stwlam) Fix issue causing error in effects tracker when world time changes
-   (Supe) Fix vehicle action drag drop and resorting

### Data Updates

-   (Dire Weasel) Add leveled persistent damage links to Acid Arrow, Gouging Claw
-   (Dire Weasel) Add Society bonus to Vengeful Arm
-   (Dire Weasel) Allow handwraps for talismans and spellhearts
-   (Dire Weasel) Fix Regeneration details on Isqulug and Water Yai.
-   (Dire Weasel) Fix some Gatewalkers sources
-   (Dire Weasel) Include Lesson of Bargains in Witch Major Lesson choices
-   (Dire Weasel) Fix rarity of some Treasure Vault items
-   (Dire Weasel) Update some feats to use DamageDice rule elements rather than Note rule elements
-   (JDCalvert) Set the effect level for protective ward aura
-   (LebombJames) Fix damage types on thunderburst
-   (stwlam) Add frying pan training to Halfling Weapon Familiarity
-   (Tikael) Begin moving localized persistent damage to inline rolls
-   (Tikael) Fix the predicates of the Trap Finder feat
-   (TMun) Add regeneration glossary ability to Precentor
-   (TMun) Update license file for upcoming announced releases

## Version 4.9.2

### System Improvements

-   (stwlam) Style effects panel icons originating from auras as glowing circles
-   (Supe) Show price per N (e.g., "10 sp / 100") on loot sheet where applicable

### Bugfixes

-   (stwlam) Fix drag & drop of roll-option toggles
-   (stwlam) Fix retrieval of ritual spell summaries
-   (stwlam) Remove redundant appending of values to condition names in messages
-   (stwlam) Prevent auras from applying effects to loot actors

### Data Updates

-   (avagdu) Add Persistent Poison Crit Damage to Poisonous Dagger
-   (Dire Weasel) Add leveled damage links to Kobold Breath and effect to Tail Toxin
-   (Dire Weasel) Fix some incorrect removeAfterRoll values in RollTwice rule elements
-   (Dire Weasel) Add auras to additional NPCs
-   (Dire Weasel) Add leveled persistent fire damage link to Produce Flame description
-   (Dire Weasel) Add class features for Breakthrough Weapon Modifications
-   (stwlam) Add aura effect for Protective Ward
-   (stwlam) Add better icon for Chromatic Armor
-   (TikaelSol) Fix typos in GM screen
-   (TikaelSol) Add aura to Tempest Curse effect
-   (TMun) Correct minor typographic errors in Blood Lords and PFS Introductions

## Version 4.9.1

### System Improvements

-   (stwlam) Run aura effect UUIDs and AdjustModifier predicates through `resolveInjectedProperties`

### Bugfixes

-   (stwlam) Add deprecation paths for properties and methods used by the old Token Action HUD

### Data Updates

-   (stwlam) Add new rule elements to existing Surprise Attack and Dread Striker items

## Version 4.9.0

### New Features

-   (stwlam) Add Ephemeral Effect rule element: push an effect onto a target or attacker just for that attack/damage roll

### System Improvements

-   (In3luki) Improve UI of character sheet crafting tab
-   (nikolaj-a) Add Escape action macro
-   (nikolaj-a) Allow non-attack-roll checks to be sources of damage rolls (e.g., Treat Wounds)
-   (nikolaj-a) Expand damage roll options for strikes with ammunition details
-   (stwlam) Remove ritual spellcasting entries: one will appear when the first ritual is added to a creature
-   (stwlam) Have weapons automatically pull rule elements from link ammunition
-   (stwlam) Add ability to track items from Grant Item rule element: a flag and roll options will be created for the granted item, even if it's not equipped
-   (stwlam) Add support for suboptions to toggleable roll option: a select menu will appear alongside a toggle's checkbox
-   (stwlam) Hide fields on armor sheet irrelevant to shields
-   (stwlam) Exclude "artifact" and "cursed" traits from generated NPC attacks
-   (stwlam) Change Rule Element UI setting to one that controls player access
-   (Supe) Don't increase value of existing conditions when dragging new ones
-   (Supe) Show persistent damage dialog when dragging a condition link

### Bugfixes

-   (cuyima) Override damage type of deadly dice when main damage type is changed
-   (Kyle Sakai) Hide "Set Initiative" button for blind rolls
-   (In3luki) Fix issue in spell browser causing remove filters to linger
-   (In3luki) Fix creation of damage instances for fixed heightened overlays
-   (In3luki) Fix resetting of spell slots and display of signature spell button
-   (In3luki) Prevent GM notes button from appearing on variant spell sheets
-   (nikolaj-a) Fix issue causing some roll notes to display for multiple degrees of success
-   (stwlam) Add separate untyped damage against "non-damaging" weaknesses
-   (stwlam) Create tiny items when crafted by tiny PCs
-   (stwlam) Fix display of range increment in weapon summaries
-   (stwlam) Fix display of rarity in armor and equipment chat cards
-   (stwlam) Fix display of roll mode in check dialog
-   (stwlam) Fix blind/GM initiative rolling when done from encounter tracker
-   (Supe) Fix issue causing item-sheet traits to not be checked against whitelists
-   (Supe) Fix sorting tagified item traits
-   (Supe) Fix unlocked lower value conditions being prioritized over higher-value ones
-   (Supe) Restore hiding of mystified item traits and prices

### Data Updates

-   (Dire Weasel) Add rule elements to Eroding Bullet
-   (Dire Weasel) Add Returning and Shifting to Blade Ally choices
-   (Dire Weasel) Add aura rule element to Undying Conviction
-   (Dire Weasel) Add aura effect for Silent Stalker
-   (Dire Weasel) Add description to Spell Effect: Ghostly Weapon
-   (Dire Weasel) Add effects for Wyrm Claw
-   (Dire Weasel) Add icons to and localize names of monk stance Strikes
-   (Dire Weasel) Add some missing damage rule elements to actors
-   (Dire Weasel) Add splash damage link to Scarlet Mist
-   (Dire Weasel) Create effects for Phantasmal Doorknob, Rime Crystal, Sanguine Fang
-   (Dire Weasel) Fix Frost's Touch to be a cantrip. Remove extraneous emphasis.
-   (Dire Weasel) Fix Skeletal Woolly Rhinoceros' Rhinoceros Charge ability
-   (Dire Weasel) Fix activations of Pickled Demon Tongue and Polished Demon Horn.
-   (Dire Weasel) Fix level for Unending Itch
-   (Dire Weasel) Fix localized string for Slayer's Presence, condition sidebar duration, shield deflecting traits
-   (Dire Weasel) Fix name of Gunslinger deed Break Them Down
-   (Dire Weasel) Fix roll formatting in Elemental Ammunition
-   (Dire Weasel) Fix several incorrectly formatted activations
-   (Dire Weasel) Fix spell level in Wand of Overflowing Life description
-   (Dire Weasel) Fix the descriptions of the Major Codas
-   (Dire Weasel) Fix the type of Corpsecaller Round
-   (Dire Weasel) Link Mindshift trait to its description
-   (Dire Weasel) Rebuild Popcorn pregen PC
-   (Dire Weasel) Remove alignment trait description text indicating alignment restrictions
-   (Dire Weasel) Remove extraneous word from Constricting Hall Lose Form description
-   (Dire Weasel) Update Ambrost Mugland's Eroding Bullet inventory item
-   (Dire Weasel) Update Necrohusk rule elements
-   (Dire Weasel) Update triceratops Vicious Gore from Note rule element to DamageDice one
-   (Dire Weasel) Fix inline damage roll in Barbed Quills action
-   (Dwim) Fix Order Explorer automation
-   (Manuel Hegner) Automate Armor Specialist feat
-   (rectulo) Fix Purging in Elder seed
-   (redeux) Update Jellyfish Stance to FotRP Hardcover changes
-   (Roxim) Fix the ChoiceSet flag syntax on "Effect:Resonance"
-   (SpartanCPA) Add Automation to the Raptor Guard Wight
-   (SpartanCPA) Add an effect for Ghostly Weapon
-   (SpartanCPA) Add rule elements to NPCs with Fast Healing
-   (SpartanCPA) Allow Mummy Dedication to Grant Basic Undead Benefits
-   (stwlam) Add GrantItem rule element to Corpse Stitcher background
-   (stwlam) Add class features for Inventor's initial weapon modifications
-   (stwlam) Add description of Artifact trait
-   (stwlam) Add potency rune to compendium handwraps
-   (stwlam) Add rule element to Surprise Attack class feature
-   (stwlam) Fix usage of Swim Fins
-   (stwlam) Grant Commune with Nature from Read the Land feat
-   (stwlam) Prune invalid traits from actors and items
-   (stwlam) Set icon for Energy Beam, add persistent damage
-   (Tikael) Add Bullet Dancer Stance effect
-   (Tikael) Add Ghost Touch rune rule element to Ghost Dedication
-   (Tikael) Add missing LO Absalom feat
-   (Tikael) Add missing Stance effects
-   (Tikael) Automate Expert Backstabber feat
-   (Tikael) Brushup Barbarian Rage automation
-   (Tikael) Fix rule elements on Virtuosic Performer
-   (Tikael) Fix inline roll in sunlight Healing
-   (Tikael) Fix typo in Brightness Seeker
-   (Tikael) Move cleric doctrine data to enable homebrew

## Version 4.8.3

### Data Updates

-   (Dana) Add +3 option to Dancing Shield spell effect (for Fortress Shield)
-   (Dire Weasel) Add effect to Lazurite-Infused Stone Golem aura
-   (Dire Weasel) Fix some malformed predicates on equipment and feats
-   (Manni) Fix damage type on Lazurite-Infused Stone Golem
-   (rectulo) Fix DC of Animal Repellent (Moderate)
-   (stwlam) Have Way of the Spellshot grant Spellshot Dedication at level 2

## Version 4.8.2

### Bugfixes

-   (In3luki) Highlight grid area of `MeasuredTemplatePF2e` previews
-   (stwlam) Fix mousewheel rotation of non-cone measured templates
-   (stwlam) Restore display of special languages on NPC sheet
-   (stwlam) Show spontaneous/flexible slots as expended when appropriate
-   (stwlam) Fix issue with setting of max range of some Strike rule elements (Foxfire, etc.)
-   (Supe) Fix NPC action summary expand/collapse behavior
-   (Supe) Restore repeating ammo icon in actions tab

### Data Updates

-   (Abaddon) Fix shield throw trait localization
-   (Dire Weasel) Add Healing Hands REs to Lisavet, Plague Doctor, Priest of Pharasma; update Heal spells
-   (Dire Weasel) Create effects for Ghostcaller's Planchette, Jyoti's Feather
-   (Dire Weasel) Fix Devoted Guardian to be one action rather than passive
-   (Dire Weasel) Fix malformed silver exception in Devil Form spell effects
-   (Dire Weasel) Fix price for Sandals of the Stag
-   (Dire Weasel) Fix some incorrect "death-effects" predicates
-   (Dire Weasel) Fix usage for some recently-added oils
-   (Zullock) Fix incorrect icon in hazards and a malformed check in PFS Season 1 creatures
-   (avagdu) Fix usages for some Fulus
-   (rectulo) Add missing sentence in Colorful Coating (yellow)

## Version 4.8.1

### System Improvements

-   (stwlam) Add support for Demolishing weapon rune

### Bugfixes

-   (Drental) Fix issue with distance measurement in 2D space caused by fix of issue with distance measurement in 3D space
-   (nikolaj-a) Fix DC label for action checks
-   (stwlam) Restore inclusion of full PC weapon-damage selectors in roll inspector
-   (stwlam) Treat propulsive weapon damage as strength-based for the purpose of bonuses and penalties
-   (stwlam) Categorize bleed damage as physical
-   (stwlam) Prevent GM notes button from appearing if item sheet isn't editable
-   (stwlam) Prevent effect sheet from submitting on change of badge-type select element
-   (Supe) Fix expanding summaries for nested feats
-   (Supe) Fix spell damage dice overrides not predicating

### Data Updates

-   (Abaddon) Fix Ganzi Martial Artist abilities
-   (David Bass) Fix details of some Kingmaker NPCs
-   (Dilly) Draw 25 new icons for spells
-   (Dire Weasel) Add Clumsy condition to Entangling Slime effect
-   (Dire Weasel) Add effects for Beastmaster's Sigil, Desolation Locket, and Jolt Coil
-   (Dire Weasel) Add Subtle Presence toggle to Mummy Valet
-   (Dire Weasel) Fix Fly action link in Time Jump
-   (Dire Weasel) Fix levels of some alchemical ammunition
-   (Dire Weasel) Correct Major Cloister Robe to have a greater resilient rune
-   (Dire Weasel) Fix name of Contagion Metabolizer
-   (Dire Weasel) Fix strength requirement of Rite of Reinforcement Exoskeleton
-   (Dire Weasel) Fix typo in Astrolabe of Falling Stars
-   (Dire Weasel) Fix usage of Treasure Vault shields and Injection Spear
-   (Dire Weasel) Remove blood siphon toggle from vampiric mist in favor of effect, add Quickened to effect
-   (Dire Weasel) Fix spelling of "aberration" trait in several predicates
-   (In3luki) Fix localization of unidentified consumable types
-   (M. Siebert) Fix Blasting Beams damage rolls
-   (Roxim) Fix missing Spell DC and Attack Modifier on Doblagub
-   (SpartanCPA) Add NPCs for PFS scenarios 4-9 and 4-10
-   (SpartanCPA) Correct the HP value of the Aiudara Wraith
-   (Tikael) Fix the damage of the Falcata
-   (avagdu) Add PFS Clarifications to Treasure Vault Equipment
-   (avagdu) Add Value to Clumsy Condition from Slurk's Entangling Slime effect
-   (rectulo) Add description for the Processed trait
-   (stwlam) Add Aberration to hazard traits
-   (stwlam) Fix unannotated shield traits added from Treasure Vault

## Version 4.8.0

### New Features

-   (nikolaj-a) Add a secret GM notes field on items, accessible from item sheets' description panel

### System Improvements

-   (dev7355608) Enable hearing range tests to improve compatibility with the Perfect Vision module
-   (Dire Weasel) Allow splash damage in DamageDice rule element
-   (In3luki) Unify UI for compendium browser traits filtering, allow filtering to include all or any of the inputted traits
-   (nikolaj-a) Add action macros for Administer First Aid and Create Forgery
-   (stwlam) Expand critical specialization support to NPC attacks with linked weapons
-   (stwlam) Expand modifier adjustments to fully support Unburdened Iron
-   (stwlam) Flip default of "lootableNPCs" setting (NPCs are now lootable by default)
-   (stwlam) Add support for adjusting weapon traits of NPC attacks
-   (stwlam) Allow item slugs to be set from rule element panel on item sheets
-   (stwlam) Have status-effects panel operate on all controlled tokens
-   (Supe) Change left click effect panel functionality for persistent to roll damage
-   (Supe) Improve behavior of item/action summaries on actor sheets
-   (Tikael) Allow combination weapons to be of any group

### Bugfixes

-   (Drental) Fix token distance measurement in 3D space
-   (In3luki) Fix macros for strikes when more than one weapon of the same base type is held
-   (stwlam) Restore display of formulas to NPC & Hazard damage buttons
-   (stwlam) Fix display and processing of halved persistent damage
-   (stwlam) Have sovereign steel weapons count as cold iron for IWR processing
-   (stwlam) Make undead PCs be unaffected by bleed damage
-   (stwlam) Make theater-of-the-mind toggles a world setting
-   (stwlam) Set weapons to be magical if affected by WeaponPotency rule elements
-   (stwlam) Fix issue with DamageDice rule element that affected Arcane Cascade's "Weapon Damage" option

### Data Updates

-   (Abaddon) Fix elder wyrmwraith temporary hit points, sky dragon breath weapons
-   (avagdu) Add Trained rank to Crafting to Munitions Crafter feat
-   (avagdu) Add correct Lores to Yamaraj
-   (avagdu) Automate Order Explorer Feat
-   (avagdu, Dire Weasel, Dogstarrb, Flameslicer, SpartanCPA, Tikael, TMun) Add and QA content from Treasure Vault
-   (David Bass) Fix details of several Kingmaker NPCs
-   (DawidIzydor) Fixed stealth for Breath of Depair
-   (Dire Weasel) Add additional feats section to Wrestler journal. Clean up journal formatting.
-   (Dire Weasel) Add regeneration rule element to hydra heads effect. Make hooktongue hydra regeneration immutable.
-   (Dire Weasel) Add skill list to Recall Knowledge in GM Screen journal entry
-   (Dire Weasel) Add spell effect for Thermal Stasis
-   (Dire Weasel) Automate some NPC critical specialization
-   (Dire Weasel) Fix Bralani inventory
-   (Dire Weasel) Fix Hadrinnex effects
-   (Dire Weasel) Fix Tumble Through macro strings
-   (Dire Weasel) Fix black whale guard inventory
-   (Dire Weasel) Fix damage of Boastful Hunter
-   (Dire Weasel) Fix dragon deviant storming breath escape and wraith deviant ghostly grab
-   (Dire Weasel) Fix name of Aerial Piledriver feat
-   (Dire Weasel) Fix name of Umonlee mental save bonus
-   (Dire Weasel) Link NPC attacks to weapons where appropriate
-   (Dire Weasel) Migrate inline splash damage and multipart damage to current standard
-   (Dire Weasel) Migrate khakkara to khakkhara, wind and fire wheel to feng huo lun
-   (Dire Weasel) Update Dewey Daystar's Heal, Magic Fang, and Wand of Healing
-   (Dire Weasel) Update Meteor Swarm description to include burst templates and leveled fire damage
-   (Drental) Fix bulk of Mithral Waffle Iron
-   (Drental) Fix typo in brevic noble background
-   (Dwim) Automate Verdant Metamorphosis impact on Actor Traits
-   (Dwim) Fix Intimidation skill label for Xulgath Stoneliege
-   (InfamousSky) Add icon to mystic carriage, portrait of spite
-   (InfamousSky) Fix Hydra stealth label
-   (InfamousSky) Fix Overdrive Imentesh Warpwave Strike DC
-   (InfamousSky) Make Hydra Regeneration Immutable
-   (InfamousSky) Set Hydra Heads effect counter default to 1
-   (KSops) Add cold iron blanch equipment effects
-   (KSops) Add rule elements for wing deflection reaction
-   (KSops) Add silversheen equipment effect
-   (Kuroni) Remove two control codes in GM screen
-   (LebombJames) Correct folk dowsing level
-   (Manni) Fix target of levitate spell in carbuncle to Self only
-   (MrVauxs) Add a note for Shared Stratagem
-   (MrVauxs) Add missing Inline Template to Horizon Thunder Sphere
-   (rectulo) Add prerequisites to Reset the Past
-   (rectulo) Fix Alkenstar agent typos in archetypes journal entry
-   (rectulo) Fix source of Dessicating Inhalation save DC
-   (rectulo) Fix levels of Advanced Thoughtform, Basic Psychic Spellcasting, Duel Spell Advantage, and Space Time Shift
-   (Roxim) Remove deprecated Blade Ally effects and broken links
-   (SpartanCPA) Correct Source of Anima Invocation
-   (SpartanCPA) Rename Phuthi to a generic statblock name
-   (stwlam) Add roll notes informing swashbucklers when they gain panache
-   (stwlam) Add focus component to Plane Shift and Song of the Fallen spells
-   (stwlam) Add rule elements to Elf Atavism and Chosen of Lamashtu feats
-   (stwlam) Add slots for Swashbuckler's Stylish Tricks feats
-   (stwlam) Add spell effect for Anticipate Peril
-   (stwlam) Fix Kurshkin's level
-   (stwlam) Localize label of shark-instinct jaws attack, add image and base type
-   (stwlam) Correct details of Soul Chain in equipement compendium and on Forge-Spurned
-   (Supe) Prepare vehicle hp, run ae-likes, and enable usage of certain REs in vehicles/hazards
-   (Supe) Remove some defunct bulk methods
-   (Supe) Show condition summary and render item summary in template
-   (TMun) Move hardness from several NPCs from HP details text to `hardness` property
-   (Tikael) Add basic pet shop equipment
-   (Tikael) Add spell effect for Battlefield Persistence
-   (Tikael) Brush up several high level druid feats
-   (Tikael) Fix the name of the Greater Fanged rune
-   (Tikael) Improve ChoiceSet of Specialty Crafting
-   (Tikael) Localize divine vessel strike
-   (Zullock) Change incorrect usage in some tattoos

## Version 4.7.4

### Bugfixes

-   (stwlam) Fix inclusion of item bonuses from weapon potency runes

## Version 4.7.3

### System Improvements

-   (Dire Weasel) Include target roll options in spell damage rolls, allow use of use "{item|id}-damage" selector for rule elements stored on spells
-   (nikolaj-a) Add action macros for Conceal an Object, Palm and Object, and Steal
-   (stwlam) Don't render enemy visual/auditory auras to players
-   (stwlam) Sort strikes on PC sheet alphabetically, force basic unarmed attack to bottom of readied strikes
-   (Trent) Add range increment display to strike action summaries

### Bugfixes

-   (nikolaj-a) Refine action macro degree of success roll notes
-   (Supe) Avoid persisting synthetic NPC traits
-   (stwlam) Fix issue causing sheets of new heritage items to become unopenable
-   (stwlam) Fix application of "deadAtZero" setting
-   (stwlam) Restore inclusion of homebrew base weapon types to weapon sheet
-   (Trent) Allow ranged battle-form strikes

### Data Updates

-   (Abaddon) Update abomination vaults Galudu
-   (Abaddon) Update age of ashes spell exceptions
-   (Dire Weasel) Add persistent damage to more NPC attacks
-   (Dire Weasel) Change Fire Mephit Breath Weapon to unique id
-   (Dire Weasel) Fix several Strike rule element damageTypes
-   (Dire Weasel) Fix blowgun damage on NPC inventory items
-   (Dire Weasel) Fix damage of Enervation, Fungal Infestation, and Vampiric Maiden spells
-   (Dire Weasel) Fix some persistent damage that were skipped by migration due to data errors
-   (Dire Weasel) Update Mysterious Breadth feat description and its journal page
-   (Dire Weasel) Update holy water splash note
-   (Dire Weasel) Automate Searing Light good damage
-   (Dwim) Fix localization issues with NPC attack effects in Abomination Vaults
-   (InfamousSky) Fix Virtuous Defender shield hardness
-   (Manni) Fix typos in Master Magus Spellcasting feat description
-   (nikolaj-a) Add roll notes to Scoundrel Racket for successful Feints
-   (Roxim) Add a Blade Ally effect with new AdjustStrike rule elements
-   (SpartanCPA) De-Pluralize name of Giant Joro Spider
-   (stwlam) Remove errant grant from Mithbreath Azarketi heritage
-   (stwlam) Fix rule elements on Zombie Dedication and Numb feats, add Deteriorated effect
-   (Tikael) Fix strike rule element in Deer Instinct
-   (Trent) Make Green Man's battle form thorns ranged, fix label on localized Thorns strikes

## Version 4.7.2

### System Improvements

-   (Supe) Allow NPC melee categorized partial without matching base

### Bugfixes

-   (stwlam) Fix issue causing cloned actors to lose their items
-   (stwlam) Wrap long summings of damage instance totals in chat

### Data Updates

-   (Abaddon) Fix energy mutagen effect descriptions
-   (Abaddon) Update NPC spells for Bestiary 1
-   (Dire Weasel) Add missing feats from Impossible Lands
-   (Dire Weasel) Add persistent damage to some NPC attacks
-   (Dire Weasel) Fix Captivating Intensity journal entry
-   (KSops) Fix inline roll warning message
-   (KSops) Normalize skill action traits
-   (rectulo) Fix terminate bloodline ritual details
-   (stwlam) Add icons for class archetype features
-   (Trent) Localize NPC critical specialization notes

## Version 4.7.1

## Bugfixes

-   (stwlam) Fix issue causing some target-situational modifiers to fail to surface

## Version 4.7.0

### System Improvements

-   (Dire Weasel) Display icon next to passive abilities with the aura trait
-   (Dire Weasel) Add includesSelf option to Aura rule elements
-   (Flame) Prevent focus spells from being added to non-focus spellcasting entries
-   (LebombJames) Display item levels in item directory
-   (LebombJames) Add effects tab to vehicle sheet
-   (nikolaj) Add Decipher Writing, Disable Device, Perform, and Subsist action macros
-   (stwlam) Add means of retrieving effects' originating actors
-   (stwlam) Add support for AdjustStrike adding/removing weapon property runes
-   (stwlam) Add support for categorizing NPC damage as persistent, precision, or splash
-   (stwlam) Add support for condition/effect alterations from GrantItem REs
-   (stwlam) Improve automation of grievous rune for picks and darts
-   (stwlam) Brighten darker scene default colors for basic usability
-   (stwlam) Handle immunity to auditory, emotional, fear, mental, and visual effects
-   (stwlam) Enable simple enemy- and all-affecting auras, add support for predicating each effect in Aura REs
-   (stwlam) Add support for shorthand Strike RE data to create standard fist attack
-   (Supe) Add full DamageDice RE support to spells
-   (Supe) Add manual persistent damage roll to editor dialog
-   (Supe) Add autocomplete key options based on schema in rule element editor
-   (Supe) Add support for labeled effect counters and formula badges
-   (Supe) Integrate vehicles into attack-roll target automation
-   (Supe) Implement broken reduction for vehicle AC and fortitude saves
-   (Supe) Implement rolling persistent damage recovery from effect panel
-   (Supe) Open persistent damage dialog when left clicking Effects Panel icon

### Bugfixes

-   (Dana) Fix "item:damage-dice:N" roll options being set according to the number of faces rather than dice
-   (In3luki) Improve performance of very large auras in scenes with large numbers of walls
-   (In3luki, stwlam) Fix issue causing user-configured roll modes to be ignored for rolls made from sheets
-   (JDCalvert) Fix AdjustStrike trait upgrading for annotated traits (deadly, fatal, etc.)
-   (Kendall Rundquist) Fix placement of save button in compendium browser settings on resizing
-   (LebombJames) Allow for decimal scales in TokenImage
-   (stwlam) Fix ABP not being ignored when requested by actors
-   (stwlam) Fix display of custom critical damage types on weapon sheet
-   (stwlam) Fix parsing of damage formulas with `MathTerm`s
-   (stwlam) Fix rule elements on Mystic Strikes class feature
-   (stwlam) Obscure damage recipient names when "tokenSetsNameVisibility" is enabled
-   (stwlam) Restore functionality of critical damage dice doubling setting
-   (Supe) Fix newly created kits erroring on sheet open
-   (Supe) Fix spell variant levels not being able to heighten downwards
-   (Supe) Keep tabs from shifting in item sheet when changing to rules tab

### Data Updates

-   (AFigureOfBlue) Fix typo in blurb of Tulvak's stat block
-   (AFigureOfBlue) Have Diverse Weapon Expert upgrade advanced weapon proficiency to trained
-   (Abaddon) Fix black dragon draconic frenzy, bronze dragon breath weapons
-   (Abaddon) Rebuild iconics, one-shot pregens
-   (Abaddon) Refresh Abomination Vaults and Age of Ashes NPC spells
-   (Abaddon) Update several spell descriptions for NPCs
-   (Avagdu) Add missing Actions from BotD
-   (Avagdu) Update Parry trait description
-   (Avery) Improve Alchemist Research Field Homebrew Support
-   (Dire Weasel) Add Aura rule elements to many NPCs
-   (Dire Weasel) Add Fly spell effect, Furious Possession effect
-   (Dire Weasel) Add Resistance rule elements to tattoos
-   (Dire Weasel) Add effect for Despair, Stink Sap, Utter Despair
-   (Dire Weasel) Add emanation to Horrific Visage
-   (Dire Weasel) Add persistent damage to many NPC attacks
-   (Dire Weasel) Add rule elements for Amorphous Aspect
-   (Dire Weasel) Add second open ability boost to Harrow-Led and raised by Belief backgrounds
-   (Dire Weasel) Add token light to Candle, Mechanical Torch, Lantern of Empty Light, Queasy Lantern, and Chromatic Armor effect
-   (Dire Weasel) Automate Hound of Tindalos vulnerability
-   (Dire Weasel) Clean up description of Graylok artillerist Throw Bomb
-   (Dire Weasel) Fix Brilliant Crafter giving expert in Inventor class DC at level 15
-   (Dire Weasel) Fix Iridescent Elephant's Glowing Bones details
-   (Dire Weasel) Fix Reinforced Surcoat usage
-   (Dire Weasel) Fix spelling of Tristian's name
-   (Dire Weasel) Fix localization of Needling Stairs, Incorporeal TotM toggle
-   (Dire Weasel) Improve automation of Double Slice
-   (Dire Weasel) Replace Abendego Jailer mancatcher with a longspear variant
-   (Dire Weasel) Update "Spell Ambush" rules in night hag variants
-   (Drental) add deathNote to Verdant Burst
-   (Dwim) Fix localization issues with many NPC attack effects
-   (InfamousSky) Fix Clockwork Rifler
-   (InfamousSky) January data review
-   (jdip) Add missing traits from items
-   (jdip) Fix Rune item usages
-   (Kuroni) Remove a unicode in Deities-Urgathoa's description
-   (KSops) Add resistance rule element to Fire Resistance feat
-   (KSops) Allow cantrip deck creation from spell
-   (LebombJames) Fix spell type of Shadow Jump
-   (rectulo) Fix Grendel Tooth grind ability
-   (rectulo) Fix Prerequisites in Bounty Hunter archetype journal
-   (rectulo) Fix heightening text of Rejuvenating flames
-   (rectulo) Fix prerequisites of Keep Pace (bounty hunter), Opportunistic Grapple, Posse, Tools of the Trade
-   (rectulo) Fix typos in Bioluminescence Bomb
-   (redeux) Rebuild iconic actor feats and features, refresh, alchemical bombs owned by iconics and pregen
-   (RobertBeilich) Add RollOption and automation for Agile Shield Grip
-   (Roxim) Add missing spell effect for Touch of Corruption
-   (Roxim) Adjust Marilith Ability Effects
-   (Roxim) Fix inline roll syntax for Electromuscular Stimulator
-   (Roxim) Remove toggle on Marilith
-   (Roxim) Review EC book 6 NPCs
-   (Roxim) Update The Slithering NPCs
-   (stwlam) Add rule elements to Advantageous Assault
-   (stwlam) Add immunities to deafened/blinded conditions
-   (stwlam) Fix rule elements on Chirurgeon's field discovery
-   (TMun) Add NPCs from PFS 4-08
-   (Tikael) Add Silence spell effect
-   (Tikael) Add a "mounted" effect
-   (Tikael) Add automation to the Orc Warmask feat, Vital Shot action
-   (Tikael) Grant conditions from Oracle curses
-   (Tikael) Add inline damage rolls to Divine Smite and automate Paladin's smite
-   (Tikael) Add missing automation to Goloma Courage
-   (Tikael) Add missing text in Order Explorer feat
-   (Tikael) Add range increment to Headless Rustler's strike
-   (Tikael) Automate Cathartic Mage Dedication, Deviant Abilities, Entity's Resurgence
-   (Tikael) Fix Drained condition when applied to level 0 and -1 creatures
-   (Tikael) Fix details of several ranged strikes
-   (Tikael) Fix equipment on Blaanlool
-   (Tikael) Fix predicates on Giant Instinct resistance
-   (Tikael) Fix several BaseSpeed REs
-   (Tikael) Fix typo in Warhammer descriptions
-   (Tikael) Improve automation of One Inch Punch
-   (Tikael) Move the elementalist spell list to the archetype journal
-   (Tikael) Simplify inline bleed damage rolls
-   (Tikael) Improve automation of Trap Finder
-   (Tikael) Localize and fix traits for save note of Stunning Fist
-   (Trent) Replace deprecated Foundry API usage in pair of macros
-   (xdy) Add more critical hit deck effects

## Version 4.6.8

### Bugfixes

-   (stwlam) Fix issue causing button listeners to fail on some damage chat messages
-   (stwlam) Fix application of resistances/weaknesses following crit immunity
-   (stwlam) Fix adding base weapon types from homebrew elements
-   (Supe) Prevent flat checks acquiring bonuses and penalties

### Data Updates

-   (Dire Weasel) Add Aura rule elements to additional NPCs
-   (TiloBuechsenschuss) Fix Tzitzimitl spellcasting DC for innate spells

## Version 4.6.7

### Bugfixes

-   (stwlam) Fix click listeners of persistent damage application buttons
-   (stwlam) Fix visibility of persistent-damage recovery button
-   (stwlam) Have damage-formula parser accept dice expressions with no leading number

### Data Updates

-   (Dire Weasel) Add Aura rule elements to additional NPCs
-   (Dire Weasel) Add hyphen to long-term rest action name
-   (Dire Weasel) Added Curse of Stone to Stone Sister's attacks
-   (Dire Weasel) Update augnagar to new bleed format
-   (stwlam) Add negative healing to Basic Undead Benefits and Revenant background
-   (stwlam) Fix rule element on Expanded Splash
-   (stwlam) Have Aquatic Combat effect grant Flat-Footed condition
-   (stwlam) Remove (Kingmaker) Amiri's extra Intimidating Glare feat
-   (TMun) Correct will save modifier of Tarrasque
-   (Tikael) Add missing source details to critical hit deck effect
-   (Tikael) Fix feat type of Fey Influence
-   (xdy) Add flat-footed Critical Deck effect

## Version 4.6.6

### System Improvements

-   (Dire Weasel) Add splash damage to weapons with Scatter trait
-   (stwlam) Add IWR support for unarmed attacks
-   (stwlam) Add resistance-ignoring to applicable weapon runes
-   (stwlam) Add support for setting reach from CreatureSize rule elements
-   (stwlam) Allow strike attack-roll methods to skip ammo consumption
-   (Supe) Add persistent recovery button and auto-recover on success

### Bugfixes

-   (Jamz) Add more specificity to the CSS selectors for Critical Hit/Fumble Journals
-   (Roxim) Remove Serrating Critical Success Note
-   (stwlam) Fix application of persistent damage when IWR setting is disabled
-   (stwlam) Fix automatic inclusion of mental immunity for mindless creatures
-   (stwlam) Fix localization of hazard traits outside edit mode
-   (stwlam) Fix name adjustments of nested feats with choice sets

### Data Updates

-   (Abaddon) Localize actions tab on hazard sheet
-   (Dire Weasel) Add "Conrasu" trait to Conrasu Lore
-   (Dire Weasel) Add AdjustDegreeOfSuccess rule element to Effect: Bravo's Brew (Greater)
-   (Dire Weasel) Add several inert Aura rule elements to NPCs for visual reference
-   (Dire Weasel) Add Effect: Dragon's Rage Wings
-   (Dire Weasel) Add TokenLight rule elements for "Glow" abilities
-   (Dire Weasel) Add effects for Perfect Droplet - Armor
-   (Dire Weasel) Add metal resistance to Rust Ooze
-   (Dire Weasel) Restore missing note for flaming rune critical
-   (Dire Weasel) Add representative image to Apricot of Bestial Might strike
-   (Dire Weasel) Add resistance rule elements to several abilities
-   (Dire Weasel) Add splash trait to Alignment Ampoule
-   (Dire Weasel) Added resistance rule elements to Perfect Resistance
-   (Dire Weasel) Fix Jakaki's Mindfog Aura to be passive. Add Aura RE to Mindfog Aura.
-   (Dire Weasel) Fix D'ziriak language tag
-   (Dire Weasel) Fix description of maximum damage for Bottled Sunlight (Moderate)
-   (Dire Weasel) Fix formatting of several aura descriptions
-   (Dire Weasel) Update Brighite Herexen to new Harm spell
-   (InfamousSky) Fix zombie rival necromancer hit points
-   (squirrelkiller) Correct gun sword's weapon category
-   (Roxim) Add Missing Immunity on Derghodaemon
-   (SpartanCPA) Add Imeckus Stroon
-   (SpartanCPA) Remove redundant Elk and Megaloceros from Kingmaker Compendium
-   (rectulo) Fix a typo in Divine evolution
-   (stwlam) Add rule element to Calculated Splash feat
-   (stwlam) Add class DC training to applicable multiclass dedications
-   (stwlam) Add resistance rule elements to Armor Expertise class feature
-   (stwlam) Add weapon base type to claws from two heritages
-   (stwlam) Fix flag mismatch in Effect: Elemental Assault rule elements
-   (stwlam) Fix Slag May claw's cold-iron material
-   (Surge) Fix Grazing Deer hazard disable checks typo
-   (Tikael) Add inline damage rolls to Bottled Sunlight
-   (Tikael) Add missing human heritages from the Beginner Box
-   (Tikael) Add rule elements to Bomb Launcher
-   (Tikael) Fix actions of Thunder Helm
-   (Tikael) Fix granted feat of Musical Prodigy
-   (Tikael) Fix item grants of Molten Wit feat

## Version 4.6.5

### New Features

-   (Supe) Add support for CRB 4th printing Voluntary Flaws

### Bugfixes

-   (In3luki) Re-evaluate degree of success adjustments on reroll
-   (stwlam) Fix processing of positive damage against living targets
-   (stwlam) Fix manual adjustments of damage rolls with multiple instances
-   (stwlam) Fix craft and repair macros
-   (stwlam) Fix rolling damage from consumables

### Data Updates

-   (Cora) Restore the variant Devourer and Bog Mummy from AV
-   (Dire Weasel) Add Breeg's Traps
-   (Dire Weasel) Add effect for Goo Grenade
-   (Dire Weasel) Add persistent damage to alchemical bombs
-   (Dire Weasel) Fix Bottled Sunlight to be martial weapons and have a range of 20 feet
-   (Dire Weasel) Fix Brevic Noble Garess to grant crafting rather than arcana
-   (Dire Weasel) Fix Fang Sharpener upgrading Razortooth jaws damage dice, and add critical bleed
-   (Dire Weasel) Fix formatting of several spell links
-   (Dire Weasel) Fix link in Spell Effect: Prismatic Armor
-   (MrVauxs) Add missing range localization keys
-   (rectulo) Fix level of Soulspark candle
-   (stwlam) Add resistance rule element to Reinforce Eidolon effect
-   (stwlam) Update Burn It! to add status bonuses to persistent damage
-   (stwlam) Link Beastkin's Change Shape effect from action item, update icon

## Version 4.6.4

### New Features

-   (Supe) Add support for alternate ancestry boosts

### System Improvements

-   (stwlam) Add processing of area damage weaknesses/resistance, axe vulnerability, and arrow vulnerability
-   (stwlam) Add ability to include persistent damage directly in weapon data
-   (stwlam) Create persistent damage conditions when applying damage

### Bugfixes

-   (stwlam) Hide damage-instance breakdown from private damage rolls
-   (stwlam) Fix context menu applying triple damage when double damage is selected
-   (stwlam) Only increase weapon dice number from striking/ABP if originally 1 (excludes higher-level bombs)
-   (stwlam) Ensure damage rolls always total to at least 1
-   (stwlam) Loosen overly-strict damage-roll recognition
-   (Supe) Fix bracket row deletion in flat modifier form always deleting the first row
-   (Supe) Fix overflow in effect panel from longer badges

### Data Updates

-   (Abaddon) Update damage-roll formulas in bomb notes to reflect new standard
-   (Abaddon) Fix shark diver's Electrify ability
-   (Abaddon) Fix various sources
-   (Cheps) Fix Anadi Elder, Anadi Sage, and Daemonic Infector spellcasting entries
-   (Cora) Add new key item icons
-   (Cora) Update and remove spoilers of items on some of the unique AV NPCs
-   (Dire Weasel) Add Gouging Claw damage variants
-   (Dire Weasel) Add persistent damage to Acid Flask
-   (Dire Weasel) Add stench auras to xulgaths
-   (Dire Weasel) Correct some sources in AP 185 and 186
-   (Dire Weasel) Correct spelling of "Rejuvenation" in some NPC stat blocks
-   (Dire Weasel) Fix Galudu's inventory
-   (Dire Weasel) Fix Grab on Minchgorm
-   (Dire Weasel) Fix Lomok's Oath of the Burning Mammoths
-   (Dire Weasel) Fix battle form spell effects to use "cold-iron" rather than "coldiron"
-   (Dire Weasel) Fix capitalization of actions
-   (Dire Weasel) Fix case of Telekinetic Projectile variant names
-   (Dire Weasel) Fix book sources of several items
-   (Dire Weasel) Fix name of Hamstringing Strike and add effect
-   (Dire Weasel) Fix prompt for Giant Instinct Barbarian
-   (Dire Weasel) Fix inventories and strike details of several Strength of Thousands NPC
-   (Dire Weasel) Touch up equipment on PFS actors
-   (Dwim) Fix Clawsong versatile spell effect
-   (Dwim) Fix deadly variant of Clawsong spell effect
-   (LebombJames) Add variants for Shadow Blast save types
-   (Lunar Requiem) Correct spelling of Woolly Rhinoceros
-   (MrVauxs) Add missing range traits to selectable values
-   (Roxim) Add missing GrantItem to Psychic Dedication
-   (Roxim) Revise CRB Errata 4 Changes
-   (SpartanCPA) Add an effect for Nyktera's Righteous Fury
-   (stwlam) Add ghost touch rule element to Blade Ally effect
-   (stwlam) Refine rule elements on Twitchy feat
-   (stwlam) Add persistent damage to Alchemist's Fire
-   (TMun) Remove duplicate weapons master entry from Shraen Graveknight NPC
-   (xdy) Add Spell Effect: Prismatic Armor

## Version 4.6.3

### Bugfixes

-   (stwlam) Fix functionality of healing buttons on damage messages

### Data Updates

-   (TMun) Make content changes reflecting Pathfinder Core Rulebook Errata (4th Printing)

## Version 4.6.2

### System Improvements

-   (stwlam) Add IWR support for conditions, critical hits, spell schools, elemental traits, ghost-touch runes, and (non-)magical attacks
-   (Supe) Add support for homebrew damage types existing as immunities/weaknesses/resistances

### Bugfixes

-   (Dire Weasel) Restore support for bracketed values in TokenImage rule element
-   (stwlam) Apply immunities/weaknesses/resistances after manual multipliers and addends
-   (stwlam) Prevent ABP from applying Devastating Attacks to battle form attacks
-   (stwlam) Fix handling of damage formulas with math function
-   (stwlam) Ensure all undead NPCs have negative healing
-   (stwlam) Fix issue preventing desired roll mode from being used when set from chat log
-   (stwlam) Restore application of stacking rulings to spell-damage bonuses and penalties

### Data Updates

-   (Abaddon) Remove unneeded html styling from Sixth Pillar Archetype entry
-   (Blue) Fixes ancestors oracle curse effect
-   (Dire Weasel) Add aura to gibbering mouther
-   (Dire Weasel) Fix Veshumirix Breath Weapon recharge
-   (Dire Weasel) Fix alignment ampoules to be martial weapons.
-   (rectulo) Fix actions of Heal companion spell
-   (rectulo) Fix actions of Wild morph spell
-   (SpartanCPA) Define Organsight damage as precision damage
-   (SpartanCPA) Fix some pf2-icon styling in several items
-   (SpartanCPA) Fix splash-damage formula in acid splash's description
-   (Tikael) Add preselection to Deep Orc item grant

## Version 4.6.1

### System Improvements

-   (Supe) Include spell materials (when present) in message headers

### Bugfixes

-   (In3luki) Fix AELike rule elements' handling of arrays
-   (In3luki) Fix issue causing validation to incorrectly fail for Weakness and Resistance rule elements
-   (In3luki) Update Hazard sheet sidebar template to new IWR format
-   (stwlam) Exclude rule-element-added IWR from IWR editor form submission
-   (stwlam) Fix errant exclusion of negative modifiers in damage rolls
-   (stwlam) Restore presence of triple-damage buttons when setting is enabled
-   (Supe) Fix dragging persistent inline rolls from actor item summaries
-   (Supe) Fix first-level daze with negative modifier
-   (Supe) Fix sheet crashes caused by invalid spell formulas
-   (Supe) Fix structural issues in some spell data

### Data Updates

-   (Abaddon) Fix adamantine golem resistance exception
-   (Abaddon) Update baomal's shell rake damage
-   (Tikael) Change a few feats from using DamageDice REs to AdjustStrike ones
-   (Tikael) Fix automation of Time and Ash oracle curses

## Version 4.6.0

## New Features

-   (stwlam) Reimplement creation, parsing, and rendering of damage roll formulas
-   (stwlam) Add basic processing of immunities, weaknesses, and resistances
-   (Supe) Add system support for persistent damage
-   (Supe) Add support for homebrew damage types

## System Improvements

-   (In3luki) Replace empty action icon in Compendium Browser spell tab with a new icon for longer actions
-   (stwlam) Add support for AE-like subtractions/array-element removals
-   (Supe) Added support for spell damage traits, modifier breakdown, and damage instances
-   (Supe) Implement RE form for fast healing and regeneration
-   (Supe) Include damage modifiers and dice in roll inspector

### Bugfixes

-   (Dana) Fix tokens with animated art disappearing on reload/scene switch
-   (Dire Weasel) Fix torch item not adding its "improvised tag"
-   (stwlam) Avoid double application of modifiers to speeds derived from land speed
-   (stwlam) Fix errant natural 1 or 20 highlighting when TMun rolls 2d20
-   (stwlam) Fix issue causing actor sheets to become unviewable when canvas is disabled

### Data Updates

-   (Cerapter) Localise MarkToken RE's cancel notification
-   (Dire Weasel) Add choice localized strings
-   (Dire Weasel) Fix source of Shadow Leydroth
-   (Dire Weasel) Localize Muse choice labels
-   (Dire Weasel) Remove extraneous spell tradition from traits
-   (Dire Weasel) Update NPC Searing Light descriptions to include inline good roll
-   (InfamousSky) Add icons to all Dark Archive, Book of the Dead and Grand Bazaar equipment
-   (Jamz) Update Critical Hit & Fumble Decks with links and new look
-   (xdy) Add variants to Imaginary Weapon and Malicious Shadow.
-   (xdy) Add variants to the spells Astral Rain, Brain Drain, Divine Decree and Divine Lance.
-   (xdy) Adds variants to the spells Abyssal Wrath, Divine Wrath and Draconic Barrage
-   (xdy) Fixes spelling of the Blade of the Black Sovereign
-   (xdy) Makes all three damage rolls in Enchanting Arrow clickable.
-   (Manni) Fix inline save on Fire Box
-   (Manni) Fix several basic inline saves
-   (Op" Philip Flarsheim) Add Automation to Energy Barrier and Soaring Armor
-   (rectulo) Fix a typo in Entrancing Eyes duration
-   (rectulo) Fix prerequisites of Spellmaster's tenacity
-   (Roxim) Brushup EC Book 5 NPCs
-   (SpartanCPA) Correct Localized Persistent and Splash Formulas
-   (SpartanCPA) Standardize Titles for Regeneration
-   (stwlam) Add REs to Fang Sharpener feat
-   (stwlam) Update Scalpel's Point to deal bleed damage
-   (Supe) Add silver/coldiron to certain spells
-   (TMun) Add new or missing license sources for end 2022/start 2023
-   (TMun) Correct the spell list for Dream of Doom in PFS 4-07
-   (TMun) Fix inventory of Ingnovim's assistant
-   (Telekenunes) Automate Raging Resistance, consolidate duplicate feats, and add miscellaneous missing automation
-   (Tikael) Add label to Hunter Automaton toggle
-   (Tikael) Add some missing localizations of ranges
-   (Tikael) Add some needed localization keys
-   (Tikael) Automate Automaton enhancements
-   (Tikael) Finish automation possible Raging Resistances
-   (Tikael) Fix formatting in several rune localizations
-   (Tikael) Fix using own modifier for battle form skills

## Version 4.5.1

### Bugfixes

-   (stwlam) Ensure presence of school and tradition traits on spell variants
-   (stwlam) Restore predication testing of degree-of-success adjustments

### Data Updates

-   (Athenos) Add Rule Elements to Bull's Eye Lantern
-   (Avery) Condense flat modifiers for bestiary effects
-   (Avery) Improve localization of GM screen journals
-   (Dire Weasel) Add resistance rule elements to glass and sand sentries
-   (Dire Weasel) Fix localized name and icon of Crown of the Saumen Kar horns attack
-   (dogstarrb) Update deities to match Impossible Lands entries
-   (rectulo) Fix feat type of Lesson of Bargains
-   (rectulo) Fix traits of Lesson of Favors feat
-   (Tikael) Fix automation of Automaton Chassis
-   (Tikael) Fix sources of items from Blood Lords book 6
-   (TMun) Add actors from PFS 4-07 and Bounty 21

## Version 4.5.0

### System Improvements

-   (Dire Weasel) Allow injected selectors in BaseSpeed rule element
-   (LebombJames) Allow injected selectors in RollTwice rule element
-   (stwlam) Add support for setting a scale in TokenImage rule element
-   (stwlam) Automatically adjust degree of success when appropriate given presence of Incapacitation trait
-   (stwlam) Reduce CPU load of hearing detection
-   (Supe) Touch up styling of loot actor sheet
-   (Supe) Add roll inspector support for casted spells
-   (Supe) Add support for proficiency modifier adjustments
-   (Tikael) Replace hard-coded fetchling color darkvision with an actor flag

### Bugfixes

-   (Salmon) Fix level not showing on first actor(s) in folders
-   (stwlam) Re-render effects panel when world time changes
-   (Supe) Fix placement of background-granted skill feats on PC sheet
-   (Supe) Fix spell level in roll options
-   (Supe) Fix variant spells for consumable items
-   (Supe) Open separate sheet for spell variants

### Data Updates

-   (Abaddon) Finish reviewing creatures from bestiary 3
-   (Abaddon) Add Hadrinnex effects
-   (Abaddon) Fix cobbleswarm, sturzstromer, and tzitzimitl senses
-   (Abaddon) Fix love siktempora's inspire courage, triumph siktempora regeneration
-   (Abaddon) Fix hardness value of Tupilaq
-   (avagdu) Fix localization key of Vishkanya trait
-   (cepvep) Fix predicate on Vetalarana Emergent
-   (Dire Weasel) Improve localization access to many rule element labels
-   (Dire Weasel) Condense several rule elements using recently-added syntax
-   (Dire Weasel) Add Effect: Shield Immunity
-   (Dire Weasel) Add Perfect Resistance, Perfect Ki Expert, Perfect Ki Exemplar, Perfect Ki Grandmaster archetype feats
-   (Dire Weasel) Add Sparkling Targe Defending checkbox label
-   (Dire Weasel) Add Unbreaking Wave Barrier, Unbreaking Wave Containment, Unbreaking Wave Vapor focus spells
-   (Dire Weasel) Add Unfolding Wind Blitz, Unfolding Wind Buffet, Unfolding Wind Crash focus spells
-   (Dire Weasel) Add Untwisting Iron Augmentation, Untwisting Iron Pillar, Untwisting Iron Roots focus spells
-   (Dire Weasel) Add effects for Flaming Star, Grim Sandglass, and Trinity Geode
-   (Dire Weasel) Add emanation to Noxious Vapors
-   (Dire Weasel) Add link from Treat Wounds to immunity
-   (Dire Weasel) Add healing rolls to Oil of Unlife
-   (Dire Weasel) Adjust formatting of Perfect Droplet
-   (Dire Weasel) Brush up Alchemist Aspirant's inventory
-   (Dire Weasel) Change hazard routines from action symbols to words
-   (Dire Weasel) Change the Hydra Heads effect to use a counter instead of ChoiceSet
-   (Dire Weasel) Change vermlek Unsettling Movement to passive
-   (Dire Weasel) Correct localized name of simple hazard checkbox in compendium browser
-   (Dire Weasel) Fix Drusilla's good luck effect to last 1 day
-   (Dire Weasel) Fix Mulventok's fear immunity
-   (Dire Weasel) Fix arrow weakness for Barking Stag
-   (Dire Weasel) Fix aura effect on Foras
-   (Dire Weasel) Fix damage type on Smite Good feat
-   (Dire Weasel) Fix incorrect languages and traits on several creatures
-   (Dire Weasel) Fix link to Effect: Applereed Mutagen (Moderate)
-   (Dire Weasel) Fix range on Swarming Wasp Stings
-   (Dire Weasel) Fix resistance effects for Ring of Torag and Tallowheart Mass
-   (Dire Weasel) Fix spelling of Bizarre in pair of feats
-   (Dire Weasel) Fix type of level from string to number
-   (Dire Weasel) Standardize formatting of Five-Feather Wreath
-   (Dire Weasel) Update Jalmeri Heavenseeker to Impossible Lands versions
-   (Dorako) Tweak style of inline check prompts with repost buttons
-   (Geliogabalus) Fix ancestry requirement of Elfbane Hobgoblin heritage
-   (InfamousSky) Add icons to Grand Bazaar items
-   (Kuroni) Change Kitsune Change Shape's name for added clarity
-   (Kuroni) Remove several errant linebreaks from item descriptions
-   (LebombJames) Add speed penalty to Ashes curse
-   (rectulo) Add frequency in Planar sidestep
-   (rectulo) Fix inline roll in Siabrae
-   (rectulo) Fix level of champion archetype's healing touch feat in archetypes journal
-   (rectulo) Fix prerequisites in Fey transcendence
-   (rectulo) Fix prerequisites of Glamour (Fey influence)
-   (rectulo) Fix level of Amber Sphere aeon stone
-   (rectulo) Fix typo in Flower Magic name
-   (rectulo) Update Fey influence with Impossible Lands printing
-   (redeux) Add/Update Heal Animal to Lini iconic PCs
-   (Roxim) Continue brushup of Extinction Curse NPCs
-   (stwlam) Fix predicate on Night Hag, Wight Cultist ability rule elements
-   (stwlam) Fix description of Raging Athlete feat
-   (stwlam) Add trained proficiency in alchemical bombs to Alchemist Dedication feat
-   (stwlam) Add trained proficiency in rogue class DC to Rogue Dedication feat
-   (stwlam) Add special prone-condition option to Cover effect
-   (TMun) Add NPCs from PFS 4-06 and correct name of overtaxed vrisk from PFS 4-05
-   (TMun) Add lesson of bargains major lesson for pact witch
-   (TMun) Update Dreshkan needle spray save from Hardcover errata
-   (Tikael) Add Gatewalkers Player's Guide Backgrounds
-   (Tikael) Fix name of Solar Rejuvenation
-   (Tikael) Fix sources of several NPCs
-   (Tikael) Fix traits of Nightstick
-   (TiloBuechsenschuss) Fix innate spells of Bugul Noz
-   (Tim Ayers) Refine the attack note of Battle Cry

## Version 4.4.2

### Bugfixes

-   (stwlam) Fix expired effect deletion when out of combat

### Data Updates

-   (Abaddon) Continue reviewing creatures from Bestiary 3
-   (Dire Weasel) Add Unblinking Flame Aura, Unblinking Flame Emblem, Unblinking Flame Ignition focus spells
-   (Drental) Fix Hidden Thorn's weapon group
-   (Roxim) Add Renewed Vigor effect
-   (Roxim) Add missing trait to Tricky Pick
-   (Roxim) Continue reviewing Extinction Curse book 4 NPCs
-   (stwlam) Have Assassin Dedication feat grant Mark for Death action
-   (Tikael) Grant Powerful Fist feature with Monk Dedication

## Version 4.4.1

### System Improvements

-   (LebombJames) Add Action cost glyphs to feat and class feature sheet headers

### Bugfixes

-   (stwlam) Fix functionality of effect expiration settings
-   (stwlam) Prevent double name adjustments from ChoiceSets when transfering physical items
-   (Tikael) Fix selector lookup for AdjustStrike REs

### Data Updates

-   (Abaddon) Continue reviewing creatures from Bestiary 3
-   (Dire Weasel) Add Perfect Weaponry archetype feat
-   (Dire Weasel) Fix FlatModifier selector for Brevic Outcast
-   (Dire Weasel) Fix Cognitive Mutagen effect descriptions
-   (LebombJames) Create new base weapon type for injection spear
-   (LebombJames) Set Skill Training AE-like to upgrade
-   (rectulo) Fix typo in Soul Chain in description, formatting in Azarim and Grasp of Droskar descriptions
-   (Roxim) Brushup EC Book 4 NPCs
-   (Tikael) Add PFS level bump effect for NPCs
-   (Tikael) Add effect to track Spined Shield spines
-   (Tikael) Automate Fearsome Brute
-   (Tikael) Fix selector on Fast Recovery
-   (Tikael) Update AV spells to hardcover versions

## Version 4.4.0

### System Improvements

-   (KSops) Allow roll substitutions for initiative rolls
-   (Idle) Allow the use of ALT key to add an unidentified effect to an actor
-   (stwlam) Adjust default reach of NPC attacks to use lower end of CRB Table 9-1 (overridable by reach traits)
-   (stwlam) Change all "weapon:\*" predication statements to "item:\*" ones
-   (stwlam) Clarify type of transaction in MoveLootPopup prompt
-   (stwlam) Render auras when GMs are logged in alone
-   (Supe) Convert metagame visibility settings to booleans
-   (Supe) Use `rollMode` instead of `secret` for roll functions
-   (Tikael) Allow effect badge counters to be set on drag

### Bugfixes

-   (Friz) Show incapacitation note for all checks with the trait
-   (Idle) Hide floaty text for unidentified effects
-   (In3luki) Fix issue causing damage buttons to disappear following reroll of attack rolls
-   (In3luki) Fix actor sidebar showing the actor level to users that lack permission
-   (In3luki) Fix shield HP updates not being reflected in token resource bars
-   (LebombJames) Visibly distinguish secret inline checks
-   (stwlam) Implement "shoddy" tag for physical items
-   (stwlam) Clean up encounter roll options, refresh each turn
-   (stwlam) Exclude troops from being flankable
-   (stwlam) Immediately re-initialize vision when PC senses are directly updated
-   (stwlam) Redraw token auras if scene is activated while being viewed
-   (Supe) Restore spell traits in spell summaries

### Data Updates

-   (Abaddon) Continue reviewing creatures from Bestiary 3
-   (Avagdu, Dogstarrb, Tikael) Add content from Lost Omens: Impossible Lands
-   (Dire Weasel) Add Runic Resistance effect to Spellscar Sky Marauder
-   (Dire Weasel) Add link from Battle Medicine to immunity
-   (Dire Weasel) Add trigger text to No Escape description
-   (Dire Weasel) Correct spelling of Toxic Furnace
-   (Dire Weasel) Fix Bark Orders Effect rule element
-   (Dire Weasel) Move heightened description for Zealous Conviction from effect to spell
-   (dogstarrb) Add heightening to Spirit Blast
-   (dogstarrb) Add missing multiclass archetypes to journal, missing journal links in dedication feats
-   (dogstarrb) Correct tradition proficiency for Master Psychic Spellcasting
-   (kageru) Fix CHA modifier of tallow guardian
-   (xdy) Fix copy and paste error in Hellknight Dedication
-   (JDCalvert) Add Reflection of Life recovery multiplier increase
-   (KSops) Add automation to chronoskimmer, roll substitutions to initiative
-   (KSops) Fix Inner Radiance Torrent Heightening
-   (KSops) Fix rule elements on Quick Alchemy feat
-   (LebombJames) Automated some Oracle Curses
-   (Pinktiger74) Clean up GM screen journal
-   (Roxim) Brushup EC Book 3 NPCs
-   (Roxim) Brushup EC Book 4 NPCs part 1
-   (Roxim) Fix Torch description
-   (SkepticRobot) Fix Strength of Thousands backgrounds
-   (SkepticRobot) Fix Spellscar Marauder's talon strike
-   (SpartanCPA) Compendium replace items and spells from EC Books
-   (SpartanCPA) Delete Bone Croupier from EC compendium
-   (stwlam) Fix Hand of the Apprentice being excluded from Universalist's free feat
-   (stwlam) Remove duplicate Recall Knowledge action items
-   (Tikael) Automate Aolaz Roll ability
-   (Tikael) Convert roll options to kebab case
-   (Tikael) Fix localization in some ChoiceSet REs
-   (Tikael) Fix pluralized NPC names in compendium
-   (Tikael) Fix rule elements on Necklace of Knives
-   (Tikael) Remove diseases entered as equipment

## Version 4.3.4

### System Improvements

-   (Cerapter) Allow effects to be hidden from players

### Bugfixes

-   (In3luki) Localize skill names in Compendium Browser filter
-   (stwlam) Fix crafting check rolls reporting incorrect degree of success
-   (stwlam) Restore DC adjustments to inline checks from elite/weak NPCs
-   (Supe) Fix damage rolls from heightened spells
-   (Supe) Fix issue causing some hazard sheets to not be openable

### Data Updates

-   (Abaddon) Fix unique swords from Book of the Dead
-   (Abaddon) Review Blood Hag, Winter Hag, and Moon Hag, House Spirits, Huldra, Hyakume, Incutilis, Jorogumo, Kami, Kangaroo, Kappa, Kirin, Kishi, Kitsune Trickster, Kokogiak, Kongamato, and Kovintus Geomancer
-   (Abaddon) Add android infiltrator automation
-   (dogstarrb) Add missing Archetypes from DA, QftFF, NotGD, OoA, and BotD to Archetype Journal
-   (dogstarrb) Adds links from dedication feats to archetype journal
-   (MrVauxs) Correct typo in "Magic Warrior Dedication"
-   (Tikael) Automate Wellspring Magic feature

## Version 4.3.3

### System Improvements

-   (Forgent) Improve rotation behavior of measured template previews on hex grids
-   (KSops) Add "herbal" as a consumable tag, integrate with Herbalist archetype

### Bugfixes

-   (stwlam) Fix item grants being duplicated given `reevaluateOnUpdate`
-   (stwlam) Default no-crowbar penalty to disabled
-   (Supe) Fix spell heightening for non-casted spell messages
-   (Supe) Correctly heighten spells retrieved from chat messages

### Data Updates

-   (Manni) Fix targets of Swarming Wasp Stings spell
-   (rectulo) Fix the format of Phantasmal protagonist
-   (Dire Weasel) Fix Staff Nexus source
-   (TMun) Correct errors following statistical outlier review
-   (TMun) Correct reference and text for spiked pit damage
-   (Tikael) Remove old individual archetype journals
-   (xdy) Add variants for bludgeoning, piercing and slashing damage to Telekinetic Projectile

## Version 4.3.2

### Bugfixes

-   (stwlam) Fix upgrading existing weaknesses and resistances
-   (stwlam) Fix issue causing Theather of the Mind toggles to appear when setting is disabled

### Data Updates

-   (Far2Casual) Fix inline check of Acidic Poison Cloud Trap
-   (Dire Weasel) Fix Peryton Heart Ripper ability
-   (stwlam) Add TotM toggle for Flying Blade
-   (Tikael) Fix REs and prerequisites on Hellknight Armiger Dedication
-   (Tikael) Fully automate Hellknight Signifier Dedication
-   (TMun) Correct action cost of Thylacine's Hunting Cry
-   (TMun) Correct duration of Time Beacon
-   (TMun) Correct CON modifier for Aecora Silverfire

## Version 4.3.1

### System Improvements

-   (xdy) Add pf2e flags with sourceId, uuid and type to consumable-usage chat messages

### Bugfixes

-   (Supe) Increase reliability of rule source lookup in grant item
-   (Supe) No longer return damage dice from rule element if damage type resolving fails
-   (Supe) Fix issue causing weapon item to not be retrievable from strike damage messages
-   (In3luki) Fix measured template rotation triggering the browser zoom in Firefox and Edge
-   (xdy) Adjust context.outcome based on result of reroll

### Data Updates

-   (Abaddon) Localize Risky Surgery toggle and Dragon Claws spell effect
-   (dogstarrb) Fix some details in NPCs Agents of Edgewatch 1
-   (stwlam) Remove disabling of damage-doubling on crit for dragon claws effect
-   (SkepticRobot) Add star grenades
-   (SkepticRobot) Automate Skilled Familiar ability
-   (Tikael) Add damage to Sea Surge spell
-   (Tikael) Fix formulas in Phlogistonic Regulator
-   (Tikael) Set Psyche trait description

## Version 4.3.0

### System Improvements

-   (LebombJames) Remove double borders from some image frames
-   (stwlam) Move flat-footed toggle to relevant features, add "Theater of the Mind Toggles" setting to show/hide
-   (Supe) Add roll-inspector support for strike damage rolls
-   (Supe) Add roll mode param to cast() function
-   (Supe) Put top-level roll options at top in roll inspector

### Bugfixes

-   (In3luki) Fix default width of line measured templates created from some workflows
-   (KSops) Fix close button for rules editing
-   (stwlam) Restore death-note icon for actions on NPC sheets

### Data Updates

-   (Abaddon) Add journal page for Mummy archetype
-   (Abaddon) Fix 8th level permanent items rollable table
-   (Abaddon) Localize Treat Wounds macro
-   (Fin) Removed outdated duplicate README.md file, Update CONTRIBUTING.md to direct contributors to the pf2e foundry discord server
-   (LebombJames) Correct Greater Nosoi Charm, and touch up REs
-   (LebombJames) Correct Rebounding Barrier Requirement to Trigger
-   (rectulo) Add basic Reflex save in acid storm
-   (rectulo) Fix key for Android trait description
-   (SpartanCPA, Tikael, TMun) Add content from Kingmaker adventure path
-   (stwlam) Add effect for Calculate Threats action
-   (stwlam) Add inventor's innovation class features, initial armor modifications
-   (stwlam) Default pregen PCs to be in party alliance
-   (TMun) Add Psychic multiclass dedication feat as an option for Eldritch Trickster Rogue
-   (TMun) Add variant effect to PFS earplugs and correct links between effects and items
-   (TMun) Fix issue causing Eternal Wings to receive double bonuses and penalties
-   (TMun) Correct aura from 5 to 10 feet for Elemental Avalanche
-   (TMun) Standardize predicates for Virtuosic Performer rule elements
-   (TMun) Update sly striker rule elements to function in V10
-   (TMun) Add NPCs from PFS 4-05
-   (Tikael) Add localization keys for some equipment effects
-   (Tikael) Automate Life Oracle curse effects
-   (Tikael) Fix and standardize precision damage REs
-   (Tikael) Fix quantity of sacks
-   (VestOfHolding) Add NPCs and player options from Crown of the Kobold King

## Version 4.2.6

### Bugfixes

-   (Drental) Accommodate macros ending with single-line comments
-   (stwlam) Fix aura colors getting inverted
-   (stwlam) Restore setting self:condition roll options
-   (stwlam) Refrain from highlighting measured templates invisible to players
-   (stwlam) Fix issue causing some auras to fall behind in rendering
-   (Supe) Fix double weak/elite adjustments on statistic rolls
-   (Supe) Fix issue preventing modifier adjustments from applying via spellcasting attack and DC selectors

### Data Updates

-   (dogstarrb) Add missing automation to Inventor Weapon Mastery
-   (MySurvive) Remove some unnecessary labels from REs on equipment
-   (redeux1) Updated Iconics/Pregens to use action-based Heal/Harm spell
-   (Tikael) Fix rule elements on Elemental Assault effect

## Version 4.2.5

### Bugfixes

-   (stwlam) Work around upstream issue introduced in 10.287 preventing execution of some macros
-   (stwlam) Fix TokenImage rule element for unlinked tokens
-   (stwlam) Fix issue causing multiple ability modifiers to stack for some damage rolls
-   (stwlam) Restore re-rendering token HUD after mouse interactions
-   (Supe) Fix predication for spell/class/save dc modifiers
-   (Supe) Restore ability-based domains for spellcasting
-   (Supe) Fix flat modifier editor adding critical: false to newly added rules

### Data Updates

-   (JDCalvert) Automate Sentinel Dedication feat
-   (stwlam) Add toggle for Ostovite's bone chariotR

## Version 4.2.4

### System Improvements

-   (stwlam) Add lighting control tool to toggle GM vision
-   (Supe) Add critical field to FlatModifier form

### Bugfixes

-   (stwlam) Fix issue causing TokenImage rule element to fail
-   (stwlam) Re-render actor directory when world actors' levels are changed
-   (Supe) Fix issue causing duplicate feats/features to be created from ancestry/background/class items under certain circumstances
-   (Supe) Fix strike macros

### Data Updates

-   (LebombJames) Fix Mountain Quake requirement
-   (Tikael) Fix usage of Crown of the Companion

## Version 4.2.3

### System Improvements

-   (stwlam) Improve performance when moving multiple tokens with vision
-   (Supe) Only show FlatModifier damage row for damage selectors in form

### Bugfixes

-   (JDCalvert) Fix damage dice validation for damageType and dieSize overrides
-   (stwlam) Prevent browser-defined default actions for CTRL-G keypress

### Data Updates

-   (LebombJames) Fix Battle Oracle Curse Effect predicates
-   (redeux) Fix minor errors in Iconic sheets
-   (Tikael) Link Treat Wounds macro in Treat Wounds action
-   (TMun) Add Damaj's Gloves

## Version 4.2.2

### New Features

-   (stwlam) Add GM Vision (keybinding defaults to CTRL-G) as means of brightening dark scenes

### System Improvements

-   (xdy) Show players the total bulk for Loot actors they own
-   (xdy) Toggle defeated state for npcs when healed to above 0 hp when defeated

### Bugfixes

-   (stwlam) Prevent multiple conditions of the same type from being created from token HUD
-   (stwlam) Defer validation of damage dice overrides
-   (stwlam) Fix display of level in actor directory for level-zero actors
-   (Supe) Restore modifier acquisition for spell attack modifiers and DCs
-   (Supe) Fix display of drag gap and mystified name in encounter view popouts
-   (Supe) Fix start of turn status message

### Data Updates

-   (Manni) Localize label for Pack Attack
-   (rectulo) Fix prereq format in psychic duelist dedication
-   (stwlam) Set range of Spined Azerketi's unarmed attack
-   (stwlam) Have wild shape effect grant battle form effect
-   (Surge) Remove incorrect label from Death Ward spell effect
-   (Tikael) Add Hispanic Heritage Month Paizo blog items
-   (Tikael) Fix inline check in Psi Burst

## Version 4.2.1

### Bugfixes

-   (stwlam) Fix dropping conditions on tokens and actor sheets
-   (Supe) Restore raw note functionality to `CheckPF2e`

### Data Updates

-   (Abaddon) Fix nosferatu ability typo
-   (stwlam) Fix predicate of RE on Orc Weapon Carnage
-   (stwlam) Default toggle in Unleash Psyche effect to true

## Version 4.2.0

### System Improvements

-   (Cerapter) Add support for strike attack roll substitutions
-   (Forgent) Add logic to snap templates to 30 degree instead of 45 on hex grids
-   (GravenImageRD) Show level in inventory item summaries and for actors in actor directory
-   (GravenImageRD) Add rarity colors to player inventory items
-   (stwlam) Optimize CPU usage of hearing checks
-   (stwlam) Allow sound emission to be overridable for creatures via ActiveEffect-like rule elements
-   (stwlam) Convert predicates to arrays (wiki will be updated with more information)
-   (stwlam) Allow FlatModifier rule elements to only apply to critical damage
-   (stwlam) Make GrantItem `onDelete` actions configurable
-   (stwlam) Set hex-grid-suitable cone rotation increments and default angle
-   (stwlam) Show scrolling text from aura-granted effects only during encounters
-   (Supe) Add ability to restrict item spellcasting to scrolls only
-   (Supe) Add support for class dc proficiencies for spellcasting entries
-   (Supe) Allow choice-less choice sets that support homebrew items
-   (Supe) Always show invest button, and equip the item to the correct slot when investing

### Bugfixes

-   (In3luki) Fix rarity tag height in the Compendium Browser
-   (Supe) Fix display of item uses in inventory
-   (Supe) Fix inline rolls for class dcs
-   (Supe) Show resistance exceptions in hazard IWR
-   (Supe) Fix drag/drop of feats sometimes preventing sheet summary from opening
-   (stwlam) Fix AE-likes modifying crafting entries
-   (stwlam) Fix Proficiency without Level variant not reflecting untrained proficiency penalties
-   (stwlam) Restore inclusion of `critical` property from DamageDice REs
-   (stwlam) Work around upstream issue affecting item creation on synthetic actors
-   (stwlam) Prevent duplicate fatal traits from being added to fatal-aim weapons
-   (tyrielv) Fix overflow for long tag elements

### Data Updates

-   (Abaddon) Add Living Graffiti variants: blood, chalk, and ink
-   (Abaddon) Add clockwork creature malfunction abilities
-   (Abaddon) Add sea skull swarm variants
-   (Abaddon) Fix details of forsaken deities
-   (Abaddon) Localize resistance exceptions from rule elements
-   (Abaddon) Remove damaging-effect from marut's fists of thunder and lightning
-   (Abaddon) Review Bestiary 3 NPCs: living graffiti oil, owb & owb prophet, skull swarms
-   (Abaddon) localize resistance exceptions in B3 rule elements
-   (avagdu) Audit Crystal Dragons
-   (avagdu) Fix description of True Staff of Healing
-   (avagdu) Fix weapon descriptions for BB Skeleton Warrior
-   (Dana) Improve implementation of fatal dice from Student of the Staff
-   (InfamousSky) Add icons to Thaumaturge class features as well as Dark Archive & Blood Lords spells
-   (LebombJames) Fix Greater Thundering Rune description
-   (LebombJames) Fix enervation damage
-   (Manni) Correct action cost of tentacle cannon
-   (Manni) Fix description of Animate Dreamer
-   (rectulo) Fix the range of sturzstromer tremorsense ability
-   (SpartanCPA) Add Rollable button to Gorget of the Primal Roar
-   (SpartanCPA) Add feats for the Psychic Duelist Dedication
-   (stwlam) Fix size of scythe embedded in cow
-   (stwlam) Add rule elements to and update description of cloistered cleric's 4th doctrine
-   (stwlam) Move Pilgrim Token's `tieBreakPriority` override to feat
-   (Tikael) Add Kingmaker backgrounds
-   (Tikael) Add missing Dark Archive and Grand Bazaar equipment
-   (Tikael) Add missing item from Strength of Thousands 4
-   (Tikael) Brushup spell effect REs A-C
-   (Tikael) Fix rule elements on Celestial Armor
-   (Tikael) Fix the title of the Fearsome rune note
-   (Tikael) Fix token name of Gold Tank Broker
-   (TMun) Add NPCs from PFS 4-04

## Version 4.1.3

### Bugfixes

-   (stwlam) Fix issue causing migration failures on very old actors

## Version 4.1.2

### Bugfixes

-   (stwlam) Fix issue causing old speed data to prevent some PC sheets from opening

### Data Updates

-   (Tikael) Fix several NPC save values that were stored as strings

## Version 4.1.1

### Bugfixes

-   (stwlam) Fix extraction of predicated damage dice
-   (stwlam) Fix localization of non-land speeds
-   (Supe) Fix detection of highest level for spell collection

### Data Updates

-   (stwlam) Restore iconics' prototype tokens
-   (stwlam) Fix language known by Uthuls (bestiary 1)

## Version 4.1.0

### System Improvements

-   (In3luki) Update Compendium Browser text search to utilize `MiniSearch`
-   (sturteva) Add spiritsense to available creature sense types
-   (stwlam) Add limited support for DamageDice REs in spells (reflected in Healing/Harming Hands feats)
-   (stwlam) Add support for hearing through walls that don't block sound (thanks to dev8675309 for assistance!)
-   (stwlam) Incorporate V10 tremorsense detection mode
-   (stwlam) Add undetected condition to token HUD
-   (stwlam) Lower enforced PC ability score cap to 1 while in manual-entry mode
-   (Supe) Add structured form for editing FlatModifier rule elements

### Bugfixes

-   (stwlam) Fix token mirroring when scale is locked
-   (stwlam) Fix issue causing secret text in journal entry text pages to become visible to players

### Data Updates

-   (InfamousSky) Add Glass Skin feat
-   (InfamousSky) Add cauldron of flying
-   (itamarcu) Fix Blaze effect
-   (SpartanCPA) Add a rollable save to Dragon's Rage Breath
-   (SpartanCPA) Audit Age of Ashes book 1
-   (SpartanCPA) Audit Doblagub (Extinction Curse)
-   (SpartanCPA) Fix name of Legacy of the Hammer background
-   (stwlam) Add critical specialization to Ruffian class feature
-   (stwlam) Fix description of Fatal Aim trait
-   (stwlam) Fix predicate on Precise Strike's damage dice RE
-   (Supe) Add Scroll Trickster bonus to trick magic item

## Version 4.0.6

### System Improvements

-   (stwlam) Skip module nags for modules with no `esmodules` or `scripts`

### Bugfixes

-   (In3luki) Fix Compendium Browser order-by values getting defaulted to name
-   (In3luki) Fix display of class features in the class item sheet details tab
-   (stwlam) Fix issue causing predicated new movement types to always be applied to a PC
-   (stwlam) Fix damage roll notes getting dropped from chat cards
-   (stwlam) Fix item-drop handling on kit sheets
-   (stwlam) Fix issue preventing JSON imports from V9 actors

### Data Updates

-   (LebombJames) Brushup witch features and feats
-   (LebombJames) Correct "Feat/Feature" in Feat Sheet Header
-   (Shandyan) Automate tiefling feats
-   (Shandyan) Correct Crunch feat, Runelord Specialization and remove Form of the Fiend variants
-   (SkepticRobot) Add missing Dark Archive backgrounds
-   (Tikael) Fix Cover effect

## Version 4.0.5

### Bugfixes

-   (In3luki) Fix metagame information being stripped from message flavor before the chat message is created
-   (stwlam) Work around upstream issue affecting Foundry users upgrading from V9 to 10.285
-   (stwlam) Fix issue causing inline rollable links to wrongly omit repost buttons
-   (stwlam) Restore aura rechecking on embedded item changes

### Data Updates

-   (LebombJames) Remove outdated critical text from Wounding rune

## Version 4.0.4

### System Improvements

-   (stwlam) Hide damage buttons for not-damaging weapons (e.g., Tanglefoot Bag)
-   (Supe) Have ChatMessage#item return the strike weapon if available (for module usage)

### Bugfixes

-   (In3luki) Fix distribute coin popup
-   (stwlam) Prevent context menu from appearing on right click in status effects menu for some OS/browser combinations
-   (stwlam) Include journal entries in compendium search
-   (stwlam) Fix issue causing post-to-chat button to not appear for @Check expressions in journal entry pages
-   (stwlam) Migrate weapon and spell resolvables in rule elements for V10 compatibility
-   (stwlam) Fix persistent damage icon path
-   (stwlam) Fix multiple issues causing roll notes to display with superfluous line breaks
-   (stwlam) Fix obscuring sender names on chat messages when feature is enabled
-   (stwlam) Fix functionality of greater darkvision with no standard darkvision

### Data Updates

-   (avagdu) Update Advanced Synergy to be takable multiple times
-   (Dods) Add rule elements to Skill Mastery (Rogue archetype)
-   (Friz) Brushup Doblagub
-   (Friz) Fix rule elements on Terrified Retreat, Feverish Enzymes, and Hellknight Dedication feats
-   (SpartanCPA) Add book source citations to more feats and effects missing them
-   (stwlam) Restore Fledgling Flight feat
-   (Tikael) Add missing Dread runes
-   (Timingila) Updated Despair aura of Khisisi
-   (Xdy) Fix All-Around Vision on several NPCs

## Version 4.0.3

### Bugfixes

-   (stwlam) Fix darkness adjuster rendering on scene view
-   (stwlam) Update in-Foundry changelog URL to point to V10 release branch

### Data Updates

-   (SpartanCPA) Fill in (book) sources on items missing them
-   (TMun) Correct perception and missing darkvision on spellskein

## Version 4.0.2

### Bugfixes

-   (stwlam) Work around upstream issue causing erratic canvas-rendering behavior

## Version 4.0.1

### System Improvements

-   (stwlam) Add support for item drops on familiar tokens
-   (stwlam) Add a basic hearing detection mode
-   (stwlam) Only show repost buttons on chat messages to message owners
-   (stwlam) Consolidate shallow/deep search in compendium sidebar
-   (stwlam) Change default order-by for most compendium browser tabs to level

### Bugfixes

-   (GravenImageRD) Show the correct item name in parentheses when mystified
-   (In3luki) Fix Compendium Browser pack selection not being saved
-   (stwlam) Fix removal of basic unarmed attack causing strike-index mismatching
-   (stwlam) Fix composite longbows/shortbows sometimes not being recognized as equivalent to standard longbows/shortbows
-   (stwlam) Fix strike drops on hotbar
-   (stwlam) Fix pair of rendering issues with darkness adjuster when viewed scene is changed
-   (stwlam) Fix showing limited NPCs with `actorLink`s in actor directory
-   (stwlam) Fix stack overflow sometimes triggered when closing token config
-   (stwlam) Fix add/remove attack proficiencies on PC sheet
-   (stwlam) Update Earn Income macro to function in V10
-   (stwlam) Fix grid highlighting of measured templates
-   (Supe) Fix ammo not getting consumed
-   (Supe) Fix display of repeating ammo on PC sheet
-   (Supe) Fix error sometimes thrown on NPCs with empty descriptions
-   (Supe) Fix hazard attack and damage rolls

### Data Updates

-   (GravenImageRD) Add missing traits to Peachwood Talisman
-   (Kuroni) Fix source of Undead Scourge equipment
-   (Shandyan) Automate tengu feats
-   (SpartanCPA) Add references to Coerce and buttons to Intimidation Feats
-   (stwlam) Add REs to handle Flying Blade feat
-   (stwlam) Remove `applyMod` from two-action Harm spell variant
-   (Tikael) Fix localization of Sprite strikes
-   (Tikael) Add Dark Archive Web Supplement content

## Version 4.0.0 (Beta 3)

### System Improvements

-   (LebombJames) Clear search bar in compendium browser when filters are cleared

### Bugfixes

-   (stwlam) Restore damage types to spell sheet
-   (stwlam) Fix race condition causing kits to inflate with incorrect item quantities
-   (stwlam) Fix issue causing advanced alchemy formulas to not be removable
-   (stwlam) Fix compendium browser pre-filter for ancestry feats on PC sheet
-   (stwlam) Disable vision options in prototype token config if RBV is enabled
-   (Supe) Fix removing Elite/Weak adjustments

## Version 4.0.0 (Beta 2)

### Bugfixes

-   (stwlam) Fix issue causing auras to not appear until after their source is removed
-   (stwlam) Fix issue causing some AE-like rule elements to not apply
-   (stwlam, Supe) Fix vision and detection modes not functioning when rules-based vision is disabled
-   (Supe) Fix display and deprecation warnings in vehicle biography tab
-   (Supe) Fix display of scrollbars in hazard sheet
-   (Supe) Fix UI error thrown when editing hazard traits

### Data Updates

-   (Dooplan) Fix level of Icewyrm
-   (Shandyan) Automate strix feats

## Version 4.0.0 (Beta 1)

### New Features

-   (Supe) Add "view art" button to NPC sheet for easier sharing with players
-   (Supe) Render temp hp above health bar

### System Improvements

-   (In3luki, stwlam, Supe) Support Foundry V10
-   (LebombJames) Set compendium search box to input type "search"
-   (stwlam) Move management of system user settings to user config
-   (stwlam) Change default condition icons to full-color, remove legacy option
-   (Supe) Retire legacy hazard sheet
-   (Supe) Use tagify for editing NPC, hazard, and item traits
-   (Supe) Hide sidebar on rules tab of item sheets
-   (Supe) Add selector list support to FlatModifier rules element
-   (Supe) Fade out combatant names in encounter if mystified
-   (Supe) Improve visibility of spell preparation button for preparared casters
-   (Supe) Add weapon-sheet-style material selection to armor
-   (Supe) Implement Brutal trait for PCs
-   (Supe) Remove "system style" journal sheet
-   (Supe, Mats) Update character proficiency tab to new headers
-   (Supe) Have compendium sidebar content search also match compendium names
-   (Supe) Organize item types in new item dialog into groups

### Bugfixes

-   (Cheps) Fix the timefilter select behavior in the spell compendium browser
-   (Eddie) Allow ability score boosts at level 0
-   (stwlam) Suppress fundamental runes on armor if ABP is enabled
-   (stwlam) Calculate aura coverage in three dimensions
-   (stwlam) Fix application of dexterity modifier cap when AC is zero

### Data Updates

-   (Abaddon) Review Bestiary 3: harmona, hellwasp swarm, herexen, house drake, storm hag
-   (Abaddon) Standardize capitalization of hyphenated creatures in Bestiary 3
-   (avagdu) Fix localization of REs on Draconic and Wyrmblessed Bloodlines
-   (avagdu) Remove Nudge Fate spell effect
-   (Brandon Maier) Fix spelling of Infectious Melody, Weapon of Judgment, and Construct Mindscape spells
-   (kageru) Fix several roll expressions and remove unused translation key
-   (Kuroni) Fix Clockwork Macuahuitl description
-   (Kuroni) Remove several errant line breaks and other formatting from item descriptions
-   (rectulo) Fix feat type of Space-Time Shift
-   (Shandyan) Automate suli, sylph, and undine feats
-   (Shandyan) Convert Deep Backgrounds to new journal format, move Deck of Many Things text to roll tables
-   (SpartanCPA) Add a link to Detect Magic in the Arcane Sense feat
-   (SpartanCPA) Add inline rollable buttons for Perception, Saving Throws, Scare to Death, Disable a Device checks
-   (SpartanCPA) Correct roll note for Jiang-Shi Minister of Tumult
-   (SpartanCPA) Make Flat Checks rollable across packs
-   (SpartanCPA) Make Thievery Checks on Handcuffs and Manacles rollable
-   (SpartanCPA) Make rollable buttons across packs for remaining Skills
-   (SpartanCPA) Make rollable buttons for Athletics checks
-   (SpartanCPA) Make skill buttons rollable for Crafting, Perception, and Arcana
-   (SpartanCPA) Move Aid and Aquatic Combat effects to Other Effects
-   (SpartanCPA) Set magical tradition of NPC Change Shapes
-   (SpartanCPA) Add sources to NPCs from SoT Book 4
-   (stwlam) Fix category of two drake rifle variants
-   (stwlam, Tikael) Retire two effects compendiums and consolidate their contents
    -   "Consumable Effects" removed, contents moved to "Equipment Effects"
    -   "Feature Effects" removed, contents moved to "Feat/Feature Effects"
    -   "Exploration Effects" renamed to "Other Effects"
-   (stwlam) Exclude invalid options (philosophies) from cleric/champion deity choices
-   (stwlam) Have Hand of the Apprentice feat enlarge focus pool
-   (stwlam) Fix melee/ranged status of chakrams
-   (stwlam) Add spell effect for Wash Your Luck
-   (stwlam) Fill out REs for dogtooth tengu
-   (stwlam) Fix duration of Veil of Dreams spell effect
-   (ThunderousLeft) Add no-crowbar-penalty suppression rule elements
-   (Tikael) Fix description of Iris of the Sky item
-   (Tikael) Convert inline links in localizations to reference UUID
-   (Tikael) Clean up Oracle automation
-   (Tikael) Remove old spell effects that have been consolidated
-   (Tikael) Add Reborn Soul background
-   (Tikael) Add Slowed condition to all zombies missing it
-   (Tikael) Add automation to the Magical Experiment background.
-   (Tikael) Add duration to Air Bubble spell
-   (Tikael) Add localization for persistent force damage
-   (Tikael) Add missing creature family abilities
-   (Tikael) Add missing equipment from Knights of Lastwall
-   (Tikael) Add missing passives to Vetalarana Manipulator
-   (Tikael) Automate Sniper's Aim feat and Tripods
-   (Tikael) Begin consolidating journals, add GM screen.
-   (Tikael) Change Caterwaul Sling icon to Sling
-   (Tikael) Change usage of religious symbols to held in one hand
-   (Tikael) Fix Evangelize prerequisites
-   (Tikael) Fix bonuses and penalties that should only apply to land speed
-   (Tikael) Fix damage roll of Control Weather Spellskein
-   (Tikael) Fix details of Intensify Vulnerability feature
-   (Tikael) Fix feat type of Corpse Tender archetype feats
-   (Tikael) Fix inline damage on Violent Unleash feat
-   (Tikael) Fix inline roll in Ochre Fulcrum Lens
-   (Tikael) Fix level of Thomil Bolyrius
-   (Tikael) Fix alignment of Spirit Naga
-   (Tikael) Fix traits of Confident Finisher and Jafaki's strike
-   (TMun) Add Lost Omens: Travel Guide
-   (TMun) Add NPCs from Bounty 20
