## Version 1.15.0

### Bug Fixes

-   (stwlam) Fix invested toggle for real, uninvest on unequip
-   (stwlam) Restore width of effect icons on the NPC sheet sidebar
-   (stwlam) Make skill from the NPC legacy sheet roll more reliably when clicked
-   (stwlam) Restore draggability of effects from the PC sheet
-   (Supe) Fix effect description viewing in the character sheet by setting default chat data traits
-   (nikolaj-a) Fix skill name translation in creature identification popup

### Content Changes

-   (Shandyan) Ranger automation:
    -   Added automation for following ranger feats: crossbow ace, deadly aim, favored terrain, hazard finder, legendary monster hunter, manifold edge, masterful companion, monster hunter, monster warden, scout's warning, shared prey, superior sight, triple threat, and warden's boon
    -   Added automation for following ranger focus spells: _animal feature_, _gravity weapon_, and _magic hide_
    -   Animal companion feat has been split into ranger and druid-specific versions. Manifold edge and superior sight have also been split into specific feats to allow for automation
-   (GravenImageRD) Delete the misnamed Staff of _Ture_ Providence. Closes #1391
-   (GravenImageRD) Fix Bracelets of Dashing to be the correct Bracelet of Dashing. Closes #1374
-   (SpartanCPA) Pathfinder Society Season 1-01 bestiary brush-up
-   (SpartanCPA) Aeons in Bestiary 1 brush-up
-   (SpartanCPA) Add Murfeli and small brush-ups on Extinction Curse book 5 monsters
-   (SpartanCPA) Ensure all actors in Bestiary 1, 2 & 3 have action category defined
-   (Jaash & SpartanCPA) Add Pathfinder Society 2-15 bestiary entries
-   (TMun) Add Pathfinder Society 2-16 through 2-18 bestiary entries
-   (TMun) Update Beginner Box iconics to use new proficiencies
-   (TMun) Add agile trait to Taloned Tengu Talon attack rule element. Closes #1399
-   (TMun) Fix traits on Aberrant Whispers. Closes #1394
-   (TMun) Replace light armor proficiency with medium armor proficiency on alchemist. Closes #1323
-   (TMun) Add weapon mastery level 11 text and flag for sorcerer
-   (stwlam) Add Hex trait to _evil eye_ spell

### Core System Improvements

-   (stwlam) Try using a Google font for rendering invested diamond to ensure a more uniform look across different platforms
-   (stwlam) Add ability to set identification status back to item sheet
-   (stwlam) Scale down the World Clock application window. Closes #1403
-   (Supe) Add traits, properties, and save type to new NPC sheet spell summary
-   (Drental) Add settings for hiding chat messages for damage applied and condition reminders
-   (Zarincos) Allow event propagation for heal button
-   (nikolaj-a) Add setting for toggling effect auto-expiry
-   (nikolaj-a) Add degree of success to NPC and familiar saving throws

## Version 1.14.2

### Bug Fixes

-   (stwlam) Fix styling of items on hazard sheets
-   (stwlam) Fix display of spontaneous spell slots
-   (stwlam) Fix item identification DCs
-   (stwlam) Restore invested toggle on character sheet
-   (Drental) Add Path to Perfection generic features to serve as reminders on level up. Closes #1392
-   (nikolaj-a) Fix players being unable to end their own combat turn
-   (nikolaj-a) Update actor sheet if that actor has an effect that expires. Closes #1393

### Core System Improvements

-   (In3luki) Show traits in chat data of containers and treasure items
-   (Supe) Default action image to empty by default instead of single action, to prevent 1 minute activities look like they take one action
-   (Drental) Make immediate effects have unlimited duration, so their rule elements are not always disabled, until we come up with a real solution

## Version 1.14.1

### Workarounds for homebrew builds

-   (stwlam) Don't attempt slot-heightening in "spontaneous focus" spellcasting entries

### Bug Fixes

-   (stwlam) Fix item transfers between actors
-   (stwlam) Restore setting of abilities and saves in item sheet
-   (stwlam) Restore drag & drop of character features/feats
-   (stwlam) Fix handling of spellcasting entry proficiency rank button on character sheet. Closes #1380
-   (stwlam) Fix identify item popup to show applicable skills
-   (stwlam) Localize the Remove Combat Proficiency confirmation message. Closes #1372
-   (nikolaj-a) Fix mid-round effect expiry. Closes #1378
-   (nikolaj-a) Ensure effects consider initiative when checking expiry on world loading

### Content Changes

-   (Shandyan) Tweaks to Wolf Drag, Overwhelming Blow, and Major Bones Curse

### Core System Improvements

-   (stwlam) Hide certain traits on an item while it's not identified
-   (stwlam) Set a default ability score for new spellcasting entries
-   (stwlam) Hide NPC inventory controls from non-owners

## Version 1.14.0

### Bug Fixes

-   (stwlam) Don't add magical trait to non-magical weapons and armor. Closes #1363
-   (stwlam) Prevent unintended sheet updates when pressing enter while editing focus points
-   (stwlam) Fix Item#getChatData mutating the item's original prepared data (which was causing immediate inline rolls to always have the same result, among other issues)
-   (stwlam) Fix NPC attack effect labels
-   (stwlam) Fix spelling of the "talisman" consumable type
-   (Supe) Migrate spell saves for lowercase and empty string
-   (nikolaj-a) Apply automatic bonus progression only to PCs
-   (nikolaj-a) Ensure feat description text on PC sheet is enriched to make Foundry links work
-   (nikolaj-a) Fix individual proficiency rank when calculating damage from weapon specialization. Closes #1367
-   (nikolaj-a) Show damage dice category only when base damage type is the same, but base damage category is different
-   (nikolaj-a) Fix duplicated or missing senses. Closes #1361

### New Features

-   (stwlam & GravenImageRD) Improved item mystification and added a mystify tab in the item sheet for the GMs
-   (stwlam & nikolaj-a) Ignore rule elements from unequipped and uninvested physical items. Closes #1274 and #1355
-   (nikolaj-a) Disable rule elements on expired effects

### Content Changes

-   (SpartanCPA) Split Kobold Dragon Mage into variants based on scale color
-   (SpartanCPA) Agents of Edgewatch Book 1 bestiary brush-up
-   (SpartanCPA) Abomination Vaults Will-o'-Wisp variants
-   (SpartanCPA) Correct medicine skill typo in Priest of Pharasma
-   (Supe) Clean up spell categories in both compendia and as a migration for existing worlds
-   (Shandyan) Fix Disrupting Weapons spell effect to work properly with its own toggle
-   (Shandyan) Corrections to focus spells for classes A to M, including linking to new effects. Lunging stance set as a fighter feat, and the spell effect for black dragon form has the correct level. Closes #1364
-   (Drental) Change some mystery man icons to more specific icons for lore and NPC images
-   (Drental) Fix NPC token sizes
-   (Drental) Add inline saving throws for a number of monster afflictions
-   (Drental) Add Pathfinder Society 1-12 submerged shard. Closes #1369
-   (Drental & Symon S) Fix translations for Earn Income macro
-   (Tikael) Add a macro for Encouraging Words. Closes #388
-   (Tikael) Add die size to ki strike and change brackets to actor level
-   (Tikael) Monk critical specialization
-   (Tikael) Add an active effect to the darkvision feature to upgrade token's bright vision to 500
-   (Tikael) Add spell effect for the _illusory disguise_ spell
-   (Tikael) Add strike and note rule elements to Seedpod and Lavasoul feats
-   (TMun) Update iconic characters. Add new level 5 iconics. Closes #748 and #944
-   (TMun) Update One Shot pregenerated characters
-   (Jaash) Add Pathfinder Society 2-14 bestiary entries
-   (stwlam) Assign base item to all specific magic armors

### Core System Improvements

-   (stwlam) Combine view mode and edit mode for loot sheets
-   (stwlam) Show total coinage instead of treasure on character sheet
-   (stwlam) Attempt to stack similar items during when transferring between actors
-   (stwlam) Only count runes toward a character's armor AC bonus if the armor is invested
-   (stwlam) Prevent assistant GMs from triggering migration runs
-   (Supe) Add Spell Category filter to Compendium Browser
-   (Bluesatin) Compendium Browser performance improvements
-   (nikolaj-a) Add EffectTracker API for tracking and managing effect durations
-   (nikolaj-a) Show degree of success to the GM for saving throws from the spell chat cards

## Version 1.13.2

### Bug Fixes

-   (stwlam) Fix filtering NPCs and hazards by trait in compendium browser. Closes #1352
-   (stwlam) Fix path of "dark-tire" image in Work in Progress theme
-   (stwlam) Prevent multiple asynchronous token-icon redraw requests from throwing an error
-   (stwlam) Fix containers in containers not showing their contents
-   (stwlam) Fix localization and trait wrapping of strikes on simple NPC sheet. Closes #1358
-   (stwlam) Skip orphaned tokens in `migrateSceneToken`
-   (stwlam) Avoid uncaught exception when a buyer has insufficient funds for a merchant actor
-   (stwlam) Fix bug causing coin values to floor at 1
-   (stwlam) Fix display of loot sheet inventory for non-owners
-   (stwlam) Add `acid` to consumable traits
-   (Supe) Localize save in item description
-   (Supe) Localize spell attack rolls from focus spells

### Content Changes

-   (stwlam) Reapply 1.13.0 migrations to PFS Season 2 Bestiary
-   (Tikael) Add Zhang Yong to Paizo blog bestiary
-   (SpartanCPA) Brush-up of Bestiary 1 monsters appearing in the Slithering
-   (SpartanCPA) Agents of Edgewatch Book 3, Chapter 3 bestiary brush-up
-   (pearcebasmanm) Audit Aasimar Redeemer from Bestiary 1
-   (GravenImageRD) Audit of Bloodsiphon from Abomination Vaults Book 1
-   (GravenImageRD) Add effect for Battle Medicine
-   (Shandyan) Spell effects for _dutiful challenge_ and _ki form_

### Core System Improvements

-   (stwlam) Send notification messages instead of throwing JS errors in Steel Your Resolve and Raise a Shield macros
-   (stwlam) Add "Claw" and "Jaws" as base weapons
-   (stwlam) Add identify-item toggles to loot and NPC sheets, change invested icon from asterisk to diamond
-   (nikolaj-a) Reduce console warnings from flat modifier rule element

## Version 1.13.1

### Bug Fixes

-   (Supe) Initialize an empty striking rune in strike rule element
-   (Supe) Fix deity default image
-   (Avery) Fix automatic bonus progression attack potency for levels 2 through 9
-   (stwlam) Fix image filename extensions in work-in-progress stylesheet
-   (stwlam) Add non-null checks to migration for replacing image filename extensions
-   (stwlam) Fix trick magic item

### Content Changes

-   (SpartanCPA) Correct duration of Profane Gift

## Version 1.13.0

### Bug Fixes

-   (stwlam) Remove free-text item modifier from spellcasting entries on CRB sheet. Closes #1259
-   (stwlam) Prevent CRB h3 styling from leaking to biography text. Closes #1322
-   (stwlam) Prevent error in effect panel when an icon is repeatedly right-clicked
-   (stwlam) Normalize stack group for taws, prevent failed stack-group lookups from breaking actor sheets
-   (stwlam) Fix display of traits in action sheet sidebar. Closes #1143
-   (stwlam) Prevent errors from being thrown when sense or strike rule elements are applied to NPCs
-   (stwlam) Fix display of effects on simple NPC sheet
-   (stwlam) Numify potency runes on weapons and armor
-   (stwlam) Avoid calculating asset/financial wealth from unidentified items. Closes #1345
-   (stwlam) Fix display of double-digit ability scores on simple NPC sheet
-   (Supe) Fix last scroll bug by using existing embedded item
-   (Supe) Prevent magic traditions from expanding with all the spell traits when opening the item sheet
-   (Supe) Fix area printout in chat card, allow spell details to edit new area object
-   (Supe) Fix applying class features that don't come from a compendium
-   (Chup) Ensure inline actions and saving throws do not break lines unnecessarily, and clicking works more smoothly
-   (Ustin & In3luki) Fix editing speed on NPC sheet

### New Features

-   (stwlam) Add settings to manage homebrew traits and other elements
-   (stwlam) Update combat proficiency management to pull from the weapon-group and base-weapon lists
-   (stwlam) Allow players to loot dead NPCs
-   (Avery) Support for Automatic Bonus Progression variant rule

### Content Changes

-   (TMun) Add motionsense
-   (TMun) Abomination Vaults Bestiary Book 3
-   (TMun) Correct typo in skill feats for fighter. Closes #1324
-   (TMun) Add one shot bestiary
-   (TMun) Fix feats mislabeled as ancestry instead of general. Closes #1338
-   (TMun) Correct spelling in en.json from algollthu to alghollthu. Closes #1341
-   (TMun) Correct data entry for Terotricus in Bestiary 1. Closes #1320
-   (Tikael) Add macro for Steel Your Resolve action
-   (Tikael) Add roll notes for fighter and barbarian critical specialization
-   (Tikael) Add Rogue Debilitation roll notes
-   (Tikael) Add new Backgrounds from Ruby Phoenix Player's Guide
-   (VestOfHolding) Update all CRB classes and their feats to be in line with CRB 2nd Printing. Closes #1311 and #1337
-   (VestOfHolding) Update all CRB spells to be in line with CRB 2nd Printing
-   (VestOfHolding) Update skill actions to be in line with CRB 2nd printing
-   (stwlam) Fix feat type of Suli-Jann. Closes #1299
-   (stwlam) Reduce size of some static files to get smaller sheet assets and avatar images
-   (Shandyan) Correcting cognitive mutagens and warrior's training ring to only apply to the correct type of attacks, rather than also affecting spell attacks
-   (Shandyan) Monk automation - Effects. Formatting of monk feats & spells
-   (Shandyan) Champion Oaths
-   (Shandyan) Fixing blade of justice, and splitting champion oaths
-   (Shandyan) Correct predicates for consumable effects, and add duration to minor elixir of life
-   (Shandyan) Automation for Oracle curses, feats, and spells
-   (Drental) Update of the Mountain Stance/_mage armor_ macro
-   (Drental) Inline saving throws for:
    -   Bestiary 1, 2, and 3
    -   Hazards
    -   NPC Gallery
    -   Abomination Vaults NPCs
    -   Adventure bestiaries (The Fall of Plaguestone, Little Trouble in Big Absalom, Menace Under Otari, Troubles in Otari)
    -   Age of Ashes bestiary
    -   Agents of Edgewatch bestiary
    -   Extinction Curse bestiary
    -   Pathfinder Society bestiaries
    -   April's Fool and Paizo blog monsters
-   (Drental) Remove skill tag from Acclimatization feat
-   (kageru) Make noble's rapier deal piercing damage
-   (Jaash) Fix The Slithering hazards stealth DCs. Closes #1300
-   (Jaash) Fix Agents of Edgewatch Mother Venom. Closes #1317
-   (Jaash) Add missing hazards for PFS 1-11. Closes #1291
-   (Jaash & SpartanCPA) Add Pathfinder Society S02-13 bestiary entries
-   (SpartanCPA) The Slithering bestiary brush-up
-   (SpartanCPA) Agents of Edgewatch Book 2 bestiary brush-up
-   (SpartanCPA) Agents of Edgewatch Book 3, Chapter 1 + 2 bestiary brush-up
-   (SpartanCPA) Format the table of Draconic Exemplar
-   (SpartanCPA) Correct Tail Whip and Shed Tail Lizardfolk Feats
-   (SpartanCPA) Add the pregens from The Slithering
-   (SpartanCPA) Add `alchemical` as a hazard trait
-   (SpartanCPA) Add spell effect to _longstrider_
-   (SpartanCPA) Add inline damage rolls to the poison in the _spider sting_ spell
-   (SpartanCPA) Correct the range increment of the Sling. Closes #1336
-   (SpartanCPA) Correct Agile Feet spell effect. Closes #1339
-   (SpartanCPA) Rename the Agents of Edgewatch Cobbleswarm as a variant compared to Bestiary 3
-   (SpartanCPA) Correct spellType of Deceiver's Cloak. Closes #1348
-   (SpartanCPA) Update Succubus in Bestiary 1
-   (Ustin) Added Ammut to Extinction Curse bestiary
-   (Overdox) Equipment Icons
-   (Overdox) Added icons for the following spells: _call the blood_, _ectoplasmic expulsion_, _ephemeral tracking_, and _lift natures caul_
-   (Overdox) Added missing spells _split the tongue_ and _ordained purpose_ from Belly of the Black Whale
-   (Overdox) Replace icons with images that better represent the item
-   (Supe) Migrate tradition capitalization and wand/scroll entries

### Core System Improvements

-   (stwlam) Disable active effects if the item isn't equipped and (if applicable) invested
-   (stwlam) Update migration runner to operate on world compendia
-   (stwlam) Subclass the `Macro` class to require observer permission to view contents of `MacroDirectory`
-   (stwlam) Fix PF2E player settings flag structure and move the Effect Panel setting from a toolbar button to a user setting
-   (stwlam) Allow ancestry items to have any creature trait
-   (stwlam) Exit out of edit mode upon closing a loot sheet
-   (stwlam) Add actor-based `removeOrReduceCondition` method, use from effect panel, character sheet, and simple NPC sheet
-   (stwlam) Convert all icons and images bundled with the system to webp format
-   (stwlam) Add `tokenIcon` property to effect data
-   (stwlam) Make Powerful Fist feat lookup localization friendly
-   (In3luki) Update character sheet, hazard sheet, item sheet, NPC sheet, and vehicle sheet to use new trait selector
-   (In3luki) Use tags UI for feat prerequisites
-   (Trollderim) Add automatic subtraction of focus points on a cast click. Closes #1313
-   (Supe) Cleanup spell traits, remove wand spellcasting entries
-   (Supe) Add spell traits to spell attack roll options
-   (Supe) Move spell category to the top, group "cast" fields together near the top
-   (Supe) Sort class features in editor
-   (nikolaj-a) Support a `data-pf2-show-dc` attribute for inline checks

    ## Version 1.12.1

### Bug Fixes

-   (stwlam) Fix price on physical item sheet sidebars. Closes #1301
-   (stwlam) Fix rolling of melee items from hazard actors
-   (stwlam) Fix spell preparation on simple NPC sheet
-   (stwlam) Reduce opacity of background image on legacy NPC sheet
-   (stwlam) Fix "new spell" label on simple NPC sheet
-   (oleh.krupko) Fix "Show Status Effects in Combat". Closes #1309

### Content Changes

-   (stwlam) Add drop shadow to shoony ancestry default icon
-   (stwlam) Make _vomit swarm_ spell name on Volluk Azrinae less verbose
-   (stwlam) Fix _worm's repast_ spell on Volluk Azrinae
-   (stwlam) Fix save type of Flaming Sphere. Closes #1292
-   (SpartanCPA) Add Active Effect to Hold-Scarred Orc to update racial health. Closes #1262
-   (SpartanCPA) Ancient Sovereign Dragon is now properly 4x4 squares
-   (SpartanCPA) Add or correct variant skill rolls for Bestiary 3
-   (SpartanCPA) Correct typo in Divine Ally
-   (SpartanCPA) Remove page references from class descriptions
-   (Tikael) Add tusk attacks to Orc and Half-Orc feats
-   (TMun) Abomination Vaults Book 3 item and feat updates:
    -   Add trap trait to hazards list
    -   Add inhaled trait to respective sections for which it now applies
    -   Add repeating trait to weapons
    -   Add olfactory trait to consumables
    -   Add four new spells
    -   Update Nhimbaloth deity entry
    -   Add non-magical and magical items
    -   Add equipment effects for items
    -   Add drow shootist archetype and feats
-   (PimpWilly) Remove duplicate currency entries from the Advanced Players Guide classes. Closes #1308
-   (Ustin) Add Urdefhan Hunter, Kharostan, and Dominator to Extinction Curse Bestiary

### Core System Improvements

-   (stwlam) Change default name for new melee items to "New Attack". Closes #1303
-   (stwlam) Make NPC gallery compendium easier to find for those looking for "GMG"
-   (stwlam) Add casting ability score select menu to simple NPC sheet

## Version 1.12.0

This release includes all monsters from the Bestiary 3, thanks to the hard work of TMun, Shandyan, SpartanCPA, Jaash, and others.

### Bug Fixes

-   (Schmurf) Add tooltip for shield and healing icons in the damage chat card
-   (Schmurf) Add damage done to shield in damage chat card
-   (stwlam) Fix issue causing failure to show folders if all of one entity type is marked private
-   (stwlam) Update CompendiumDirectory ambient declarations to reflect what Foundry is serving out
-   (stwlam) Fix updating saves and perception values on simple sheet
-   (stwlam) Show rarity correctly on ancestry and background sheets. Closes #1270
-   (stwlam) Fix legacy NPC attacks with stringy melee attack modifiers. Closes #1275
-   (stwlam) Allow text for the saving throw comment in the new NPC sheet, instead of only a number
-   (stwlam) Fix drop & drop resorting of inventory items. Closes #1264
-   (In3luki) Fix damage buttons being appended to rollable table results

### Content Changes

-   (SpartanCPA) Change Storm Retribution to be a reaction
-   (SpartanCPA) Remove page references from archetypes, ancestry features, actions, backgrounds, and bestiary ability glossary compendia
-   (SpartanCPA) Correct the type of bonus and duration for Cover. Closes #1268
-   (SpartanCPA) Remove feats and backpacks from NPCs who cannot display those item types
-   (stwlam) Change icon for the _mirror image_ spell
-   (stwlam) Mark the Paizo blog bestiary as private
-   (Overdox) Icon updates for equipment, spells, wands, and staves
-   (Tikael) Add April fools 2021 monsters
-   (Tikael) Brush up a few action descriptions with correct condition linking.
-   (Jaash) Changed Forensic Medicine description to match Advanced Player's Guide. Closes #1250
-   (Jaash) PFS Season 2 Bestiary brush-up for monsters starting with F through K
-   (Schmurf) Fix Spiritbound Aluum token size 1x1 to 2x2. Closes #1247
-   (VestOfHolding) Update spells to be in line with CRB 2nd Printing
-   (VestOfHolding) Update ancestries and their feats to be in line with CRB 2nd Printing
-   (TMun) Add olfactory trait and the description
-   (TMun) Add Change Shape to Kitsune ancestry automation. Closes #1278
-   (TMun) Change text for cleric skill feat increases to start at level 2. Remove reference to Druid Class DC. Fix name of Familiar Ability Verdant Burst. Add links to Leshy Familiar Secrets feat. Closes #1285 and #1287
-   (TMun) Add additional deadly traits. Closes #966
-   (Drental) Add duration to dueling parry and add dueling dance stance effect
-   (Ustin) Add Ararda and Iffdahsil from Extinction Curse Book 5

### Core System Improvements

-   (stwlam) Make the simple sheet the default NPC sheet
-   (stwlam) Do not allow the user to create a condition or spellcasting entry from the sidebar
-   (stwlam) Mark `addDexterityModifierCap` and `removeDexterityModifierCap` as deprecated
-   (stwlam) Align item creation on simple NPC sheet
-   (stwlam) Add drop-shadow filters to default icons and utilize when creating actors/items
-   (Supe) Fix spell traits and only show ritual properties if ritual
-   (Supe) Expose RuleElements instance to allow modules to install custom rule elements
-   (nikolaj-a) Add support for inline saving throws

## Version 1.11.21

### Bug Fixes

-   (stwlam) Avoid localizing custom (lore) skills on NPCs
-   (stwlam) Ensure an NPC's hit points are adjusted when changing weak/elite adjustment. Closes #1248
-   (nikolaj-a) Fix senses selector window, so it's not always selecting all senses

### Content Changes

-   (SpartanCPA) Fix broken monsters from the Paizo blog

## Version 1.11.20

### Bug Fixes

-   (stwlam) Fix display/editing of traits, immunities, and languages on simple NPC sheet
-   (stwlam) Open and close compendium folders as necessary while searching
-   (stwlam) Fix tripping Foundry concurrent compendium-access bug in migration 611
-   (stwlam) Fix copied enfoldered compendia not appearing in directory. Closes #1253 and #1254
-   (stwlam) Match up damage icons to right buttons again
-   (In3luki) Add `expended` class to simple NPC sheet CSS. Closes #1251

### Content Changes

-   (Schmurf) Fix Xotanispawn size from 1x1 to 2x2
-   (SpartanCPA) _Animal form_ spell description missing a closing tag
-   (Tikael & SpartanCPA) Brush-up Ancient Brass Dragon and Medusa
-   (Tikael & SpartanCPA) Add Paizo blog content (Closes #1008) and updated OpenGameLicense.md to add blog sources

### Core System Improvements

-   (In3luki) Add the attack description to roll notes

## Version 1.11.19

**Warning!** Very old copies of the Toughness and Mountain's Stoutness feats might need to be replaced manually with a new version from the compendium to ensure they keep working as expected. This was necessary to make these feats work better with the translated/renamed versions.

### Bug Fixes

-   (GravenImageRD) Fix spell cards not showing when making Trick Magic Item rolls
-   (GravenImageRD) Fix issues with Trick Magic Item. Closes #1218
-   (Drental) Fix focus spellcasting entry label
-   (Drental) Fix thief racket, hefty hauler and lifting belt to work with translation
-   (Chup) Fix width of strikes description when ammo dropdown is shown
-   (stwlam) Fix setting of speaker from token in item cards
-   (In3luki) Fix NPC elite/weak adjustment being doubled for attack rolls. Closes #939 and #1103
-   (In3luki) Fix empty spell slot data being saved to a spellcasting entry
-   (Schmurf) Fix quantity shown in message when buying from lootsheet. Closes #1233
-   (nikolaj-a) Fix Trick Magic Item DC
-   (nikolaj-a) Fix failure message on recovery roll chat card

### New Features

-   (stwlam) Allow user to pick which shield to use for shield block, and prevent blocking with a broken shield. Closes #1214
-   (nikolaj-a) Add rule element for manipulating actor traits
-   (nikolaj-a) Add rule element to change recovery check DC
-   (nikolaj-a) Support rule elements for NPC spell attacks and saving throw DC

### Content Changes

-   (SpartanCPA) Bestiary 2 brush-up of monsters starting with U through Z
-   (SpartanCPA) Adjust the formatting for the Warpwaves table
-   (SpartanCPA) Reformat class tables - Alchemist, Barbarian, Bard, Champion, Cleric, Druid, Fighter, Investigator, Monk, Oracle, Ranger, Rogue, Sorceror, Swashbuckler, Witch, Wizard
-   (SpartanCPA) Reformat tables in spells starting with A through Z
-   (SpartanCPA) Reformat table and removes page references from Earn Income
-   (SpartanCPA) Fix formatting for Bear form's two attacks
-   (SpartanCPA) Change All-Around Vision to a defensive ability
-   (Tom Parker) Age of Ashes #4 Gashadokuro, updated AC, immunities, and claw strike. Closes #1234
-   (Tom Parker) Age of Ashes #1 bestiary brush-up
-   (TMun) Morlock cultist fix
-   (TMun) Changes _spirit object_ from utility to spell attack, damage type to bludgeoning
-   (TMun) Set text data in rogue class to trained for rogue weapons. Closes #1235
-   (TMun) Move compendia with character building items to dedicated folder
-   (TMun) Updated iconics:
    -   Add new art for Daji and Feiya. Removes placeholders for Daji and Feiya.
    -   Update Amiri, Ezren, Daji and Feiya.
-   (Trollderim) Fix typo in adventurers clothing slug field value. Closes #1236
-   (Jaash) PFS Season 2 Bestiary brush-up of monsters starting with C through E
-   (Jaash) Add missing text and links for Leaper's Elixirs. Closes #1238
-   (Schmurf) Add missing condition links to relevant actions for Titan wrestler, Continual Recovery, Marsh Runner, Combat Grab, and Claws. Closes #1237
-   (Schmurf) Fix Gogiteth size from huge to large. Closes #1228
-   (Schmurf) Fix Qurashith attacks traits. Closes #1244
-   (Schmurf) Changed Dangerous Sorcery feat check by slug and not name, to prevent translation from breaking the damage bonus
-   (Schmurf) Fix Vishkanyan language translation key
-   (Shandyan) Add links to effects for Dragon and Monstrosity Forms. Correct formatting of all Form spells, plus Avatar and Nature Incarnate.
-   (Shandyan) Add Investigator automation:
    -   Effects
    -   Actions (Clue In, Pursue a Lead)
    -   Class features (Investigator Expertise, Keen Recollection)
    -   Class feats (Athletic strategist, Detective's Readiness, Didactic Strike, Just One More Thing, Known Weakness, Lie Detector, Ongoing Strategy, Scapel's Point, Takedown Expert, Thorough Research, Trap Finder, and Underworld Investigator)
    -   Formatting fixes for Clue Them All In, Everyone's a Suspect, Lead Investigator and Shared Stratagem
-   (stwlam) Add size and HP overrides to the Pixie and Unbreakable Goblin heritages, respectively

### Core System Improvements

-   (stwlam) Add compendium folders
-   (stwlam) Use GM-configured pack privacy, if set, before deferring to `metadata.privacy`
-   (stwlam) Implement auto-private compendia by referencing metadata
-   (stwlam) Migrate heritage `ancestryfeature` items to `heritage` items
-   (stwlam) Always show character traits from ancestry and heritage
-   (stwlam) Make travel-speed sheet localization friendly
-   (stwlam) Make spell icons cast on simple NPC sheets, clean up spell-list styling
-   (stwlam) Add more checks to ensure the token border color patch won't crash on botched Foundry upgrades
-   (In3luki) Update simple NPC sheet input fields to show base value on focus
-   (In3luki) Change modifier colors to be more color-blind friendly
-   (nikolaj-a) Add `mundane-attack` and `mundane-damage` selectors
-   (nikolaj-a) Show calculated spell attack modifier and saving throw DC on simple NPC sheet
-   (nikolaj-a) Add dropdown to change NPC spellcasting ability. Closes #195

## Version 1.11.18

### Bug Fixes

-   (stwlam) Only create ABC features once. Closes #1198
-   (stwlam) Prevent error from being thrown when a `controlToken` hook is fired before `game.pf2e` is defined
-   (stwlam) Prevent current stamina from overflowing on CRB sheet. Closes #486
-   (stwlam) Fix display of PC hit points when in the triple digits
-   (stwlam) Fix display of NPC max hit points. Closes #1231
-   (nikolaj-a & stwlam) Fix players unintentionally unidentifying items from item sheet

## Version 1.11.17

### Bug Fixes

-   (stwlam) Fix updating modifiers via roll dialog
-   (stwlam) Remove hard-coded trap trait from hazard sheet template
-   (stwlam) Refrain from disrobing a character when a user edits their armor
-   (stwlam & In3luki) Fix simple NPC sheet HP styling. Closes #1224
-   (In3luki) Fix NPC attack damage with thrown weapons
-   (abrault) Loosen which feats can be put in an archetype slot
-   (Trollderim) Fix Crit Rule label for double dice. Closes #1223

### Content Changes

-   (TMun) Correct spellguard shield effect. Closes #1225
-   (Shandyan) Formatting corrections for form spell effects
-   (Shandyan & ArthurTrumpet) _Dragon form_ spell effects
-   (SpartanCPA) Correct formatting of descriptions for base weapons
-   (SpartanCPA) Bestiary 2 brush-up of monsters starting with T
-   (Jaash) PFS Season 2 Bestiary brush-up of monsters starting with A through B
-   (Drental) Add PFS scenario 2-12 monsters

### Core System Improvements

-   (putty) Add the possibility to specify hours per day spent traveling in travel duration macro
-   (Avery) Add semi-transparent background to the action icons to make them look better on a dark background, like the hotbar and Token Action HUD
-   (stwlam) Allow item-identification status to be set from item sheets
-   (nikolaj-a) Support modifiers for NPC maximum hit points

## Version 1.11.16

### Bug Fixes

-   (stwlam) Okay, fine, you can wear armor and hold a staff too
-   (stwlam) Close spellbook chapter on first click
-   (stwlam) Fix dragging items out of containers
-   (stwlam) Migration: Delete persisted kit items following compendium browser bug
-   (stwlam) Fix deprecated window-exposed class names (PF2ModifierType, PF2StatisticModifier, PF2CheckModifier)
-   (stwlam) Prevent raising a broken shield with the `raiseAShield` macro
-   (stwlam) Do not return early when applying damage with an orphaned token selected
-   (stwlam & GravenImageRD) Fix box shadow in CheckModifiersDialog. Closes #500
-   (GravenImageRD) Embed link to spell on consumables. Closes #1010
-   (Trollderim) Fix error in damage type localization, leading to reset damage type on edit
-   (Trollderim) Fix take from compendium button
-   (Trollderim) Fix error in skill determination within compendium browser. Closes #1191
-   (Drental) Fix earn income macro
-   (In3luki) Substantial changes to the NPC preview sheet. Closes #1170, #1022, #1034, #1042, #1059, #1096
-   (Chup) Fixed actor sheet lore rank colors
-   (nikolaj-a) Fix duplicate attack rolls
-   (nikolaj-a) Change fixed proficiency rule element to ignore untyped bonuses
-   (nikolaj-a) Filter out empty dice modifiers from damage roll tags

### New Features

-   (abrault) Add Free Archetype
-   (abrault) Ancestry Paragon support
-   (nikolaj-a) Add filter on outcome for notes on damage rolls

### Content Changes

-   (SpartanCPA) Improve formatting of spells starting with A through F
-   (SpartanCPA) Add condition links on spells starting with A through Z
-   (SpartanCPA) Bestiary 2 brush-up of monsters starting with G through S
-   (TMun) Add Reach-30 as an option due to Extinction Curse #5 monster
-   (TMun) Add Thrown 60 trait
-   (TMun) Add bounties 6-10 and PFS 2-12 through 2-22 to copyright
-   (TMun) Correct _divine wrath_ critical failure text. Closes #1183
-   (TMun) Convert shield warden to two feats. Update bastion archetype for new feat name. Closes #1091
-   (TMun) Fix wrong prerequisite structures. Closes #1092
-   (TMun) Spell adjustments: Correct minor range or area errors. Correct typo for dragons breath. Add dragons breath by colour
-   (Shandyan) Fix damage bonus to only apply to Blackaxe, rather than all attacks vs. plants. Closes #1217
-   (Shandyan) Fighter feats (effects, formatting), and automation for Agile Grace, Assisting Shot, Brutal Finish, Combat Assessment, Cut from the Air, Disarming Stance, Double Shot, Double Slice, Guardian's Deflection, Impossible Volley, Incredible Aim, Multishot Stance, Point-blank Shot, Reflexive Shield, Resounding Bravery, Triple Shot and Twin Parry
-   (Shandyan & ArthurTrumpet) Aerial, elemental, plant form spell effects
-   (Shandyan & Sanderson Tavares) Monstrosity form spell effects
-   (stwlam) Set `baseItem` field for non-base weapons
-   (stwlam) Update _shield_ spell icon
-   (GravenImageRD) Add action to Flurry of Blows class feature
-   (GravenImageRD) Add starting currency to class kits
-   (GravenImageRD) Remove bad rules effects from the _goodberry_ spell effect. Closes #1194
-   (Drental) Change Treat Wounds macro to support Mortal Healing and use correct Risky Surgery bonus
-   (Jaash) Extinction Curse bestiary - added traits for Giant Aukashungi and Xilvirek

### Core System Improvements

-   (Trollderim) Add missing localization labels
-   (Trollderim) Replace two handed trait toggle in player inventory with help for new toggle. Closes #1177
-   (Chup) Add trait descriptions to show as tooltips in strikes
-   (Chup) Changed Actions tab symbol to the more recognizable Pathfinder single action symbol
-   (stwlam) Hide sheet-config buttons unless there is more than one sheet option
-   (stwlam) Add `baseItem` to weapon sheet
-   (stwlam) Add setting to determine whether the PFS tab is shown on character sheets
-   (stwlam) Tweak styling of NPC and show fake plus signs on modifiers
-   (In3luki) Add shields to simple NPC sheet
-   (In3luki) Update simple NPC sheet spell tab to support prepared and focus spells
-   (Drental) Make Settings dialogs localizeable
-   (Supe) Chat damage buttons are localized, and the title is on the button instead of the icon
-   (nikolaj-a) Add make an impression action macro
-   (nikolaj-a) Add request action macro
-   (nikolaj-a) Add support for multiple deadly dice for monsters

## Version 1.11.15

### Bug Fixes

-   (nikolaj-a) Fix equipping any gear always unequipping the currently worn armor

## Version 1.11.14

### Bug Fixes

-   (stwlam) Restore import of TemplateLayer monkey patches. Closes #1173
-   (Trollderim) Fix counteract chat card issues. Closes #1131
-   (Trollderim) Fix ammo feature for blowguns. Closes #1155
-   (fryguy) Fix "plus X" dialog on NPC attacks from keeping its list of actions forever. Closes #302
-   (nikolaj-a) Add support for the flexible armor trait. Closes #351

### New Features

-   (nikolaj-a) Show attack roll result in strike chat card to all GMs, if a token has been targeted

### Content Changes

-   (Shandyan) Effects for druid feats and spells
-   (Shandyan) Automation added for druid feats (current spell, ferocious shape, green empathy, soaring shape), leshy familiar abilities (grasping tendrils, purify air, verdant belt), and spells (apex companion, goodberry, primal summons, stormwind flight, wild morph and wild shape)
-   (Shandyan) Active effects for armor proficiencies (armor expertise at various levels)
-   (Shandyan) Active effects for alchemist & barbarian
-   (TMun) Minor corrections to pregens
-   (TMun) Add anchor action to actions.db and convert text to action in _anchoring roots_. Closes #1171
-   (stwlam) Set `baseItem` value for all alchemical bombs, to make it interact properly with the weapon proficiencies
-   (stwlam) Fix auto-heightening of _debilitating dichotomy_ focus spell
-   (SLATE) Add the gecko potion and the potion effect
-   (Drental) Add active effects for base proficiencies of all classes
-   (Drental) Add active effects for proficiencies granted by class features
-   (Drental) Add active effects for proficiencies granted by subclasses
-   (Drental & ArthurTrumpet) Add Take Cover macro
-   (SpartanCPA) Bestiary 2 monster item brush-up (A through F)

### Core System Improvements

-   (stwlam) Allow no more than one article of armor to be equipped at a time
-   (stwlam) Derive traits on magical items
-   (stwlam) Change toggle icon to indicate whether or not a spellbook/chapter is opened
-   (nikolaj-a) Support custom modifiers to action macros
-   (nikolaj-a) Improve action macro roll dialog title
-   (nikolaj-a) Support alternative skill for action macros
-   (nikolaj-a) Replace pf2-action custom element with data attributes (the actions need to be dragged to the sheet again)
-   (nikolaj-a) Add gather information action macro

## Version 1.11.13

### Bug Fixes

-   (stwlam) Fix cantrip preparation
-   (stwlam) Hide Active Effects tab on item sheets unless in development mode
-   (Maduin) Fix issue where weapon damage always used versatile damage type. Closes #1114

### New Features

-   (stwlam) Include weapon-group proficiencies in attack-modifier calculations
-   (nikolaj-a) Automatically set roll options for attack and damage rolls from attacker and target conditions, as well as target traits

### Content Changes

-   (Shandyan) Cleric automation
    -   Align armament, defensive recovery, divine weapon, emblazon antimagic, emblazon armament, emblazon energy, heroic recovery, necrotic infusion, premonition of clarify, radiant infusion, shared avoidance, shared clarity, and shield of faith
    -   Add effects for cleric focus spells
    -   Add effects for cleric spells (adapt self, agile feet, athletic rush, competitive edge, face in the crowd, font of serneity, hyperfocus, magic's vessel, object memory, practise makes perfect, roar of the wyrm, safeguard secret, soothing words, sweet dream, take it's course, tempt fate, traveler's transit, and weapon surge cleric domain spells)
    -   Add features for each specific cleric doctrine for warpriest and cloistered cleric. The cleric class will automatically give generic 'First/Second/... Doctrine' features which contains links to the specific versions of the doctrines that need to be manually added
-   (Drental) Agents of Edgewater #6 Bestiary creatures starting with A
-   (TMun) Update to prerequisites for D through G. Fix prerequisite format and a few minor textual corrections. Addresses part of #1091
-   (TMun) Add Granny's Hedge Trimmer from Little Trouble in Big Absalom
-   (TMun) Correct dragon form breath weapon action cost from 1 action to 2. Closes #1166
-   (TMun) Adds "Trained in Medium Armor" to alchemist class description. Actual settings in class was correct according to the errata
-   (TMun) Correct Paizo Pregens for One Shot 1 and add Beginner Box Pregens
-   (SpartanCPA) Bestiary 2 Elementals brush-up
-   (SpartanCPA) Bestiary 2 Elemental Dragons brush-up
-   (SpartanCPA) Bestiary 2 brush-up of the remaining Dragons

### Core System Improvements

-   (stwlam) Use a more human-readable label when selecting actor and item sheets
-   (stwlam) Set default image for a new Active Effect to the owning item's

### Development Improvements

-   (stwlam) Rename system TypeScript classes for consistency, deprecate window-exposed TypeScript classes

## Version 1.11.12

### Bug Fixes

-   (stwlam) Restore scrolling to NPC edit-sheet sidebar. Closes #1159
-   (nikolaj-a) Fix "Single Action" selection crashing PC sheet. Closes #1163

### Content Changes

-   (Shandyan) Corrections to Malicious Shadow heightening, Precise Strike damage, and adding Mask Familiar ability. Closes issues #762 , #1001 and #1157
-   (TMun) Add warpglass material
-   (TMun) Add new compendia for non-iconic pregens. Add pregens from Slithering and first one-shot. Add monsters from Abomination Vaults #2.
-   (TMun) Story crooner and Strix Defender labels were accidentally ancestry features instead of ancestry feats. Closes #1162
-   (TMun) Remove Dracolisk from Bestiary 2 and replace it with five colors of dracolisk for immunity/weakness/resistance compatibility. Closes #1150
-   (TMun) Fix a certain hazard from Little Trouble in Big Absalom - reaction was an attack instead of an action
-   (SpartanCPA) Add air to the list of weapon traits
-   (SpartanCPA) Break out Soulbound Doll into multiple entries by alignment
-   (SpartanCPA) Break out Petitioner into multiple entries by planar origin
-   (SpartanCPA) Break out Sinspawn into multiple entries by sin
-   (nikolaj-a) Add infused to the list of traits for consumables, equipment, and weapons

### Core System Improvements

-   (stwlam) Set default token dimensions for familiars and vehicles
-   (stwlam) Add means of toggling quickD20Rolls from check-modifiers dialog
-   (nikolaj-a) Remove attack and damage buttons from PC inventory

## Version 1.11.11

### Bug Fixes

-   (stwlam) Filter out empty traits on roll cards
-   (stwlam) Fix memory leak when editing items from an actor
-   (stwlam) Fix condition removal when an actor sheet has no token
-   (stwlam) Provide more informative error messages on failure to apply conditions
-   (stwlam) Ensure worldSchemaVersion is saved on a world's first load to properly do future migrations
-   (stwlam) Fix display of size on familiar sheets. Closes #1107
-   (Trollderim) Add missing roll mode when rerolling from chat

### New Features

-   (In3luki) Add the ability to provide a numeric value in entity links. Updated spells to include the condition value
-   (Maduin) Basic support for signature spells

### Content Changes

-   (Drental) Increase clarity of the GM view on the treat wounds macro
-   (Drental) Fix _dimensional steps_ heightened text
-   (SpartanCPA) Oread Guard and Sea Snake brush-up
-   (SpartanCPA) Bestiary 2 Geniekin brush-up
-   (SpartanCPA) Bestiary 2 Oozes brush-up
-   (SpartanCPA) Bestiary 2 Elementals brush-up (first half)
-   (SpartanCPA) Bestiary 2 Sea and Shadow Drakes brush-up
-   (SpartanCPA) Bestiary 2 Giants brush-up (marsh, shadow, taiga, wood)
-   (SpartanCPA) Bestiary 2 Giant Animals brush-up
-   (SpartanCPA) Bestiary 2 errata (violet venom, yellow musk poison, ankou, basidirond, culdewen, thanadaemon, cockroach swarm, denizen of Leng, drainberry bush, dream spider, giant tick, jotund troll, ogre spider, ostiarius, skaveling, specter, stygira, two-headed troll, wereboar, weretiger, yellow musk creeper)
-   (SpartanCPA) Bestiary 2 Animals brush-up (starting with A through W)
-   (SpartanCPA) Bestiary 2 Aberrations brush-up
-   (SpartanCPA) Add Sneak Attack rule elements to monsters
-   (SpartanCPA) Add a +10 speed bonus to Scout's Speed archetype feat
-   (SpartanCPA) Add automation for Elf ancestry feats
-   (SpartanCPA) Yaashka and Zunkri in EC2 renamed to their generic Xulgath creature names
-   (SpartanCPA) Brush-up of specific, named armors, including Unburdened Iron support
-   (SpartanCPA) Correct level of Caustic Vapor hazard and Scarlet Triad Boss Shortsword. Closes #1115 and #1118
-   (SpartanCPA) Correct capitalization of conditions within the Bestiary Action Glossary, and add Greater Darkvision feature
-   (SpartanCPA) Fix luminous ward hazard data, and giant joro spider, duneshaker solifugid, oread guard, and shadow monster data for . Closes #1071, #1085, #1116, and #1117
-   (SpartanCPA) Remove AoN links from spells in compendium
-   (SpartanCPA) Add links to "Effect: Dueling Parry" within the feats
-   (TMun) Correct Fetchling base speed from 23 to 25
-   (TMun) Lost Omens Ancestry Guide fixes. Closes #1100, #1111 and #1112
-   (TMun) Web supplement for Lost Omens Ancestry Guide
-   (TMun) Change Terrifying Resistance flat modifier from +2 to +1. Closes #1123
-   (TMun) Add 'Range Increment 5' as a trait. Closes #1133
-   (TMun) Add water trait to valid attack traits. Closes #1153
-   (TMun) Add auditory to the immunities list. Closes #1137
-   (TMun) Correct Carnivorous Crystal AC. Closes #1138
-   (TMun) Abomination Vault 2 data entry. Add new spells, new archetype feats, and new equipment. Add eldritch researcher archetype, and rename bard know-it-all feat to prevent name clash
-   (TMun) Add rogue and ranger to Sense the Unseen feat. Closes #1140
-   (TMun) Fix caterwaul sling classification (simple vs martial), and fix prerequisite formatting for inspire defense feat. Closes #1142
-   (TMun) Change rarity from common to uncommon for Golden Body, Song of the Fallen, Reflecting Riposte, Enduring Debilitations and Steal Essence feats. Closes #1146, #1147, #1148 and #1149
-   (TMun & SpartanCPA) Correct EC spiked barricade trap. Fix level and accidental pluralization. Closes #1101
-   (Shandyan) Champion automation
-   (Shandyan) Add Vicious Evisceration feat
-   (Shandyan) Add link to Panache effect from the Panache class feature
-   (Shandyan & Raven) Shillelagh spell effect
-   (Shandyan & Raven) Point-Blank Shot feat automation
-   (Shandyan & Raven) Disrupting weapons automation
-   (Shandyan & putty) Add automation for rejuvenation touch, and create extra versions of Lay on Hands/Touch of Corruption for damage/healing
-   (Shandyan & Drental) Add spell effects for bane, death ward, forbidding ward, protection, ray of frost, soothe, and tanglefoot
-   (Shandyan & ArthurTrumpet) Add _pest form_ spell effect
-   (GravenImageRD) Fix Gloomseer feat having no prereq listed
-   (GravenImageRD) Add missing prereq to Dragon Spit feat
-   (GravenImageRD) Add missing skill trait to Battle Cry feat
-   (@malakani) Add fighter trait to Shield Warden. Closes #1120
-   (stwlam) Set typed default icons in adventure (path) bestiaries
-   (stwlam) Add traditions to Summon Instrument spell
-   (putty) Add Divine Ally (Blade) weapon rune effects
-   (Maduin) Parry effect

### Core System Improvements

-   (stwlam) Hide distribute-loot buttons when a loot sheet is an edit mode
-   (stwlam) Add svg ancestry icons
-   (stwlam) Make item sheets resizable
-   (stwlam) Suppress css border around item-sheet icon
-   (stwlam) Hide overflow of ancestry/background/class on CRB sheet
-   (stwlam) Tweak the CRB sheet so a vertical scrollbar does not appear on the Character tab
-   (stwlam) Add means to create active effects from item sheets
-   (stwlam) Set typed default icons in PFS bestiaries and ability glossary
-   (stwlam) Add active effects to set rank from reflex-save class features
-   (stwlam) Do not show rarity in weapon sheet tag list
-   (stwlam) Set finer default token dispositions
-   (stwlam) Help the PF2QR module find spell attack rolls until the author can properly fix it
-   (stwlam) Hide most data on familiar sheets until a master is selected
-   (Maduin) Allow spells that require a spell attack roll and a saving throw

## Version 1.11.10

### Bug Fixes

-   (stwlam) Prevent non-GMs from updating the scene after darkness animation
-   (stwlam) Allow actor-speed values to be textual until a migration and UI updates can be made
-   (stwlam) Move raise-a-shield macro to typescript codebase, send out action card on use

### Content Changes

-   (Shandyan>) Barbarian Animal Instinct and Animal Skin updates
-   (Shandyan & ArthurTrumpet) Adding Insect Form from ArthurTrumpet
-   (Shandyan & ArthurTrumpet) Added dinosaur form from ArthurTrumpet
-   (SpartanCPA) Add ToggleProperty to "Everstand Stance" feat that interacts with Shield weapons to increase damage
-   (SpartanCPA) Correct the formatting on the dagger in the compendium
-   (SpartanCPA) Fix sneak attack on Polar Bear
-   (SpartanCPA) Add Sneak Attack rule elements to the relevant NPC gallery creatures
-   (SpartanCPA) Correct Vomit Swarm targeting
-   (SpartanCPA) Add Bulwark rule element to Full Plate
-   (stwlam) Add fancy class icons
-   (TMun) Lost Omens Ancestry Guide
    -   Add 6 new ancestries
    -   Add 58 new heritages and ancestry features
    -   Add 385 new feats, renames 5 feats
    -   Add 7 new actions
    -   Add new uncommon language (Giant)
    -   Add 2 new runes
    -   Add 9 new weapons
-   (TMun) Corrects item level and price of Greater Mask of the Banshee. Closes #1099

## Version 1.11.9

### Bug Fixes

-   (stwlam) Refrain from updating worldCreatedOn setting from World-Clock settings form
-   (stwlam) Show numeric value in perception input on simple NPC sheet
-   (stwlam) Fix immunities not wrapping in default NPC sheet
-   (Trollderim) Fix missing reroll option when going through the roll dialog

### New Features

-   (nikolaj-a) Add toggles to default NPC sheet

### Content Changes

-   (TMun) Corrects investigator skill feat and skill increases (were swapped) in class item

## Version 1.11.8

### Bug Fixes

-   (fryguy) Fix feats tab not saving scroll position when making changes
-   (fryguy) Add migration to fix class item migration not filling out the levels fields correctly
-   (stwlam) Fix display of feat traits
-   (stwlam) Fix some traits for legacy damage rolls
-   (stwlam) Enforce numeric inputs on numeric input fields
-   (stwlam) Fix drag & drop of spells on an actor sheet with multiple spellcasting entries
-   (nikolaj-a) Fix missing default options parameter for measureDistances replacement method
-   (nikolaj-a) Fix health percentage calculation in limited PC sheet

### New Features

-   (fryguy) Add drag & drop slots for feats based on the class data
-   (fryguy) Add counteract button to spells
-   (stwlam) Add Calendar/Weather module compatibility mode to WorldClock application
-   (stwlam) Have perception class features upgrade perception rank
-   (Mothringer) Trick Magic Item support for scrolls and wands
-   (Trollderim) Add take from compendium button for players
-   (tchapelot) Use different icons for different types of unidentified items
-   (andriusch) Allow using ammo when shooting bows/crossbows/slings
-   (nikolaj-a) Apply custom modifiers to spell attack and spell DC for PCs

### Content Changes

-   (SLATE) Add missing enemies from PFS 1-16
-   (TMun) Add blightburn items from Extinction Curse 5 to equipment.db
-   (TMun) Add monsters from Chapter 3 of Extinction Curse 5
-   (TMun) Add greater darkvision to ancestry features. Closes #1047
-   (TMun) Add potion of Shared Memories from the APG. Closes #1088
-   (TMun) Fix feat prerequisite structure in feats starting with A, B and C, plus a few fixes of opportunity for data entry regarding formatting, as well as updates to "Eye for Treasure" and "Stonecunning"
-   (TMun) Add an empty ancestry, background and class to each compendium for drag and drop homebrew
-   (stwlam) Clean up reach, deadly, and fatal traits in NPC compendia
-   (Shandyan) Make hunters arrowhead work with hunt prey
-   (Shandyan) Instinctive Obfuscation feat added
-   (Shandyan) Fix predicate error for Hunter's Aim
-   (Shandyan) Spell effects for Bard Focus Spells
-   (Shandyan) Sorcerer Blood Magic, adding links from bloodline features
-   (Shandyan & ArthurTrumpet) Animal form spell effects
-   (SpartanCPA) Add a +5 flat untyped land speed bonus to the "Nimble Hooves" ancestry feat
-   (SpartanCPA) Remove rule elements from Clandestine Cloak base item. There is an attached effect that grants the same rules with an interact action
-   (SpartanCPA) Add Feat Effect for lvl 1 Dwarf feat "Avenge in Glory"
-   (SpartanCPA) Add compendium references and rule elements to Dwarf Ancestry feats
-   (SpartanCPA) Minor tweaks and fixes to Grendel and Polar Bear
-   (putty) Implement effect for inspiring marshal stance
-   (Drental) Macro for proper item bonus stacking in Mountain stance
-   (Drental) Add new raise a shield macro and effect

### Core System Improvements

-   (stwlam) Ctrl-click to delete items without waiting for user confirmation
-   (stwlam) Hide worldCreatedOn setting and instead provide a worldTime reset button
-   (stwlam) Have the WorldClock synchronize darkness from external time advancements
-   (stwlam) Hide expend-spell button for cantrips
-   (stwlam) Prevent "Empty Slot (drag spell here)" in CRB sheet spellbook tab from breaking onto a second line
-   (fryguy) Reorganize feats tab
-   (fryguy) Add input for hp details field on old npc-edit sheet
-   (TMun) Add wavesense as new PC sense
-   (Dmitry) Switch the color icons for blinded and dazzled conditions
-   (nikolaj-a) Add spell and magical option to spell saves

## Version 1.11.7

### Bug Fixes

-   (Trollderim) Add missing return statement for items in IdentifyPopup
-   (nikolaj-a) Fix drag and drop of effects from the item directory to the hotbar
-   (stwlam) Make spellcasting entry name input at least long enough to show default names

### Content Changes

-   (TMun) Move Grolna from Agents of Edgewatch bestiary compendium to equipment compendium

## Version 1.11.6

### Bug Fixes

-   (stwlam) Prevent error from being thrown when unnamed effects are in the token HUD status effects menu
-   (stwlam) 🐵🩹 EntityCollection class to fix Foundry bug occurring on Compendium import
-   (nikolaj-a) Ensure effects toggled from the hotbar has a source ID flag
-   (nikolaj-a) Remove duplicate action icon style from Tiny MCE. Closes #1057
-   (nikolaj-a) Initial support for NPC speed rule elements, including the `total` field for aligning with the PC structure
-   (nikolaj-a) Include roll notes for action shortcut skill checks
-   (nikolaj-a) Add the hard-coded fist strike to the brawling weapon group
-   (nikolaj-a) Add melee or ranged option to PC attack rolls

### Content Changes

-   (Drental) Update spirit instinct to use normal rage damage as an option
-   (Drental) Fix ranger precision at level 11
-   (Drental) Nature gets access to treat wounds and crafting cannot set DC
-   (Shandyan) Added toggle to dragon barbarian rage
-   (Shandyan) Make Precision Ranger easier to use
-   (Shandyan) Corrected Sticky Bombs
-   (Shandyan) Add automatic effects to the following bard feats: discordant voice, ecletic skill, educate allies, know-it-all, ritual researcher, soulsight and well-versed. Add links to focus spells to all relevant bard feats.
-   (mirkoRainer) Add Grolna
-   (SpartanCPA) Add rule elements to the Necklace of Knives item to add two Dagger attacks (melee & ranged)
-   (SpartanCPA) Add rule element to the Sharp Fangs Ancestry Feat to add the 1d8 piercing Fangs strike
-   (SpartanCPA) Added a Compendium for monsters from Little Trouble in Big Absalom
-   (TMun) Add missing spike launcher from Abomination Vault. Closes #1075
-   (TMun) Adds new traits from Lost Omens Ancestry Guide
-   (TMun) Correct action on Kralgurn from Age of Aashes. Updates with new equipment. Closes #1077
-   (stwlam) Fix drag and drop of Abomination Vaults items to the actor sheet. Closes #1068
-   (fryguy) Fix bestiary mistakes in Agents of Edgewatch

### Core System Improvements

-   (stwlam) Hide loot actors from actor directory unless a user has Observer permission
-   (stwlam) Clean up PlayerConfigPF2e, remove highlightDataUri setting
-   (stwlam) Default "Show Condition Chat Bubbles" setting to false
-   (stwlam) Add Time Convention setting to world clock
-   (stwlam) Make spellcasting entry names editable
-   (stwlam) Make item sheet form labels a darker gray
-   (In3luki) Add rule element token effect icons on token creation

## Version 1.11.5

Note that this release will change the default for the Quick Rolls client setting. This means that your setting might change if you have not previously set this explicitly.

### Bug Fixes

-   (putty) Fix negligible bulk doubling for tiny items due to rule misunderstanding
-   (putty) Fix bulk calculation for sacks
-   (stwlam) Make the token border color monkey patch more resilient to broken Foundry installations
-   (stwlam) Prevent tall portrait images from overflowing on the CRB sheet
-   (TMun) Adds 'curse' and 'magic' traits to hazards (from Abomination Vaults)

### New Features

-   (stwlam) Expand features of WorldClock application
-   (Maduin) Heighten spontaneous spells

### Content Changes

-   (TMun & rectulo) Correct entry of Calistria minor curse to point to Giant Wasp Venom instead of Giant Wasp
-   (TMun & rectulo) Remove incorrect prerequisites for quick reversal
-   (TMun) Add missing ritual from AoA book 6 and spells from EC books 5 and 6. Closes #1061
-   (TMun) Add note rule element to level 17 Resolve
-   (TMun) Correct a typographic error in the Overflowing Sorrow spell. Closes #1070
-   (Shandyan) Automating alchemist features & feats
-   (Shandyan) Automation for Investigator
-   (Shandyan) Automating barbarian feature & feats
-   (Shandyan) Adding rules elements for Hunter's Aim, based on original version by Dods
-   (Drental) Add support for Natural Medicine (only substitutes the roll), Chirurgeon (also substitutes the max rank), Risky Surgery, Magic Hands, and Medic dedication
-   (Drental) Fix Rest for the Night macro to use the proper warn notification
-   (Drental) Split the spell effects compendium into consumable, equipment, feats, features, and spell effects compendia
-   (profounddark) Fix issue with Rage damage and agile not interacting correctly

### Core System Improvements

-   (stwlam) Renamed skill tab to proficiencies and changed the icon to make it more indicative of its purpose for new players
-   (stwlam) Change Diehard feat to use an active effect
-   (stwlam) Default quickrolls in player config to 'off'
-   (stwlam) Set default permission of Limited for loot actor type
-   (fryguy) Consolidate coins & treasure information on the inventory of the PC sheet
-   (nikolaj-a) Create a macro to toggle an effect when a link to the effect is dragged to the hotbar.

## Version 1.11.4

### Bug Fixes

-   (abrault) Fix chat card for rerolls to properly show the previous result

### Content Changes

-   (putty) Fix Accursed-Forge-Spurned Token Size
-   (putty) Add enlarge and shrink spell effects
-   (TMun) Remove redundant prerequisite from text for all ghost hunter feats. Closes #1041
-   (TMun) Remove archetype from Lobbed Attack and converts prerequisites to new format. Closes #1049
-   (TMun) Remove redundant prerequisite from text for Shall not Falter, Shall not Rout feat. Closes #1050
-   (TMun) Add missing requirement statement to Endure Death's Touch feat. Closes #1051
-   (TMun) Add frequency to Tumbling Opportunist Feat. Closes #1052
-   (Shandyan) Rules elements for skill feats (Religion to Thievery) plus Treat Wounds immunity effect
-   (Shandyan) Adding automation to ranger class features for hunt prey and edges
-   (profounddark) Update swashbuckler class features with the correct action values for predicates
-   (nikolaj-a) Enhanced compendium actions with a clickable action macro for rolling a check with the proper options set:
    -   Acrobatics skill check for the Maneuver in Flight action
    -   Acrobatics skill check for the Squeeze action
    -   Acrobatics skill check for the Tumble Through action
    -   Deception skill check for the all three variants of the Create a Diversion action
    -   Deception skill check for the Impersonate action
    -   Deception skill check for the Lie action
    -   Deception skill check for the Feint action

### Core System Improvements

-   (putty) Make it possible to configure reach in feet on per ancestry basis and default to 5 feet for existing ones
-   (In3luki) Update weapon chat cards to roll strikes when possible
-   (nikolaj-a) Workaround for putting custom elements in chat cards
-   (nikolaj-a) Add an icon on action links for exploration and downtime activities
-   (nikolaj-a) Include proficiency rank as an option to various checks and rolls for PCs

### Development Improvements

-   (stwlam) Add & improve accuracy of more foundry.js types declarations
-   (Mothringer) More typing+strict mode fixes in sheets and popups

## Version 1.11.3

### Bug Fixes

-   (stwlam) Avoid rendering token effect icons if the scene isn't visible
-   (stwlam) Make actor-token image synchronization override each class's default image
-   (fryguy) Fix database error when adding multiple class features to a class at the same time
-   (Mothringer) Fix unsafe accesses caused by data that did not match the definitions
-   (nikolaj-a) Show roll notes for PC initiative rolls

### New Features

-   (In3luki) Add the ability to roll skill checks with a DC

### Content Changes

-   (TMun) Update all class features from level 0 to level 1. Adds missing alchemist, bard and barbarian generic class features. Fix Rogue and Witch. Closes #1033
-   (TMun) Correct heightening Text of Ancestral Form Spell. Remove duration text from Familiar Form Spell. Change Veil of Dreams to Saving throw from Spell Attack. Correct spelling of Calisria in boons and curses. Add hellknight orders and associated benefits as class features and bonus feats. Closes #1031, #1032, #1035, #1039, #1040
-   (TMun) Add web lurker traps from Bestiary
-   (Shandyan) Fix rounding issues with Intimidating Prowess
-   (Mothringer) Add tradition traits to existing scrolls and wands with embedded spells where missing
-   (nikolaj-a) Enhanced compendium actions with a clickable action macro for rolling a check with the proper options set:
    -   Acrobatics skill check for the Balance action
    -   Intimidation skill check for the Coerce action
    -   Intimidation skill check for the Demoralize action

### Core System Improvements

-   (stwlam) Remove token rescaling for elite/weak NPCs
-   (stwlam) Default move-loot stack quantity to max
-   (In3luki) Update actor rolls to accept an object as parameters while keeping backwards compatibility
-   (putty) Implement hustling for travel speed sheet
-   (Drental) Add callback and DC to attack rolls for PCs
-   (Mothringer) Populate the tradition traits correctly on autogenerated scrolls and wands
-   (Mothringer & nikolaj-a) Add the Pathfinder 2E action icons as a styling option in TinyMCE

### Development Improvements

-   (putty) Document rule api and remove useless but required constructors to parent class
-   (nikolaj-a) Add custom element for embedding checks for actions into descriptions and other texts

## Version 1.11.2

### Bug Fixes

-   (Ladis) Fix NPC name not changing when changing its value from the new NPC sheet
-   (Mothringer) Fix potential undefined actor when distributing coins
-   (stwlam) Prevent journal entry font outside edit mode from being overridden by body style
-   (stwlam) Wrap token-border monkey patch in Foundry version check
-   (Drental) Fix typo in item transfer chat message
-   (fryguy) Fix copy/paste error for additional skills on class item
-   (profounddark) Fixed bug with nonlethal trait crashing the damage rolls, and displayed twice
-   (nikolaj-) Include roll options by default for attack modifier calculation

### New Features

-   (stwlam) Add search bar to compendium directory
-   (Mothringer) Enable casting spells from scrolls and wands by actors with a spellcasting entry that matches the spell's traditions
-   (fryguy) Drag and drop support for classes

### Content Changes

-   (stwlam) Add Shoony ancestry default icon
-   (stwlam) Set slugs and source IDs of world and actor-owned items with a data migration
-   (stwlam) Migrate trait format to arrays in all cases
-   (stwlam) Migrate item trait arrays
-   (stwlam) Change compendium hazard mystery-man icon to new default hazard icon
-   (Shandyan) Rule elements for general feats
-   (Shandyan) Rule elements for ancestry features
-   (Shandyan) Armor speed penalty rule elements
-   (Shandyan) Rule elements for skill feats (Acrobatics through Deception)
-   (Shandyan) Rule elements for skill feats, I to P
-   (putty) Automate modifier from nimble elf
-   (putty) Fix speed for incredible movement
-   (TMun) Correct multishot stance from skill to class feat. Fixes prerequisite formatting. Closes #1016
-   (TMun) Correct or add Extinction Curse content. Correct typo on Sodden Sentinel. Add Juvenile Boar. Add hazards & creatures from book 5, chapters 1 and 2
-   (TMun) Convert classes to include the data necessary for drag and drop
-   (TMun) OGL duplicate of AoE Player's Guide removal
-   (TMun) Abomination Vaults Book 1 Data Entry
-   (rectulo) Heaven's Thunder missing prerequisite value: Jalmeri Heavenseeker Dedication
-   (rectulo) Flamboyant Athlete, correct prerequisite to expert in Athletics
-   (kageru) Remove trailing spaces from entity names
-   (nikolaj-a) Added land speed increase to the Fleet general feat
-   (nikolaj-a) Enhanced compendium actions with a clickable action macro for rolling a check with the proper options set:
    -   Athletics skill check for the Climb action
    -   Athletics skill check for the Disarm action
    -   Athletics skill check for the Force Open action
    -   Athletics skill check for the Grapple action
    -   Athletics skill check for the High Jump activity
    -   Athletics skill check for the Long Jump activity
    -   Athletics skill check for the Shove action
    -   Athletics skill check for the Swim action
    -   Athletics skill check for the Trip action
    -   Perception check for the Seek action

### Core System Improvements

-   (stwlam) Refrain from running migrations on newly-created worlds
-   (putty) Automate speed modifier for Incredible Movement
-   (putty) Implement bulk conversions for actor and item sizes
-   (Mothringer) Make rest for the night macro recharge spellcasting wands
-   (Mothringer) Hide the use item button from the expanded view of unidentified consumables
-   (mirkoRainer) Make deity input opaque to make it clearer that it's editable
-   (Darth_Apples) Add spell slot reset button for each spell level and cast buttons for each spell
-   (fryguy) Change translation text to indicate that the ancestry, background, and class items are now usable
-   (nikolaj-a) Add buttons for opening ABC compendia from player character sheet
-   (nikolaj-a) Include traits in check chat card, if available
-   (nikolaj-a) Replace option tags with strike traits in damage chat card
-   (nikolaj-a) Make modifier tags less prominent in roll chat cards

### Development Improvements

-   (Mothringer) Make addition of new strict mode violations fatal via betterer
-   (Mothringer) Fix the type signature of game.user to correctly reflect that the character
-   (Mothringer) Fix several strict mode violations in actor.ts and loot.ts
-   (Mothringer) Fix several strict mode violations in character.ts by improving typing
-   (stwlam) Fix lone implicit this, turn on noImplicitThis
-   (stwlam) Add item identification properties to physical item data & template.json
-   (stwlam) Update JS file of Rest macro, copy back to compendium macro after prettier pass
-   (stwlam) Make migration versions accessible without construction
-   (stwlam) Update travel speed sheet to not collide with core FormData class and to use PF2Actor rather than Actor
-   (stwlam) Move actor skills from common to character template in template.json
-   (stwlam) Add Actor#prepareData constituent methods to type declaration
-   (stwlam) Rename `prepareData` to `prepareDerivedData` in PF2EActors, allowing Foundry Actor class to call prepareData
-   (stwlam) Update webpack to version 5
-   (stwlam) Update compendium entity type declarations and make stricter type checks in run-migration.ts
-   (stwlam) Remove deprecated (and unused?) gitlab package
-   (stwlam) Modularize CompendiumPack class from packbuilder, move pack scripts into dedicated directory
-   (stwlam) Allow non-zero permission defaults for pack build/extract
-   (stwlam) Fix setting of sourceId on pack build
-   (nikolaj-a) Remove breakdown fields from template.json
-   (nikolaj-a) Add infrastructure for action macros

## Version 1.11.1

### Bug Fixes

-   (stwlam) Move slug property from Actor to Item in template.json
-   (stwlam) Fix warning notification call in Rest for the Night macro
-   (stwlam) Fix error for actorless tokens in migrations by skipping them
-   (Ladis) Fix some localization errors in the NPC sheet
-   (profounddark) Add description for Shoony and Leshy traits, made sure Investigator, Leshy, and Shoony traits correctly connect with their description. Correct trait spelling in the Low-Light Vision ancestry feature
-   (nikolaj & profounddark) Ensure weapon traits are included in the damage predicate tests

## Version 1.11.0

### Bug Fixes

-   (stwlam) Monkey-patch Token class to fix Foundry bug causing incorrect border colors
-   (stwlam) Prevent Distribute Coins popup from rendering if Enter is pressed on a loot sheet
-   (In3luki) Fix DistributeCoinsPopup assigning wrong platinum values
-   (In3luki) Fix drag and drop to token for all item types
-   (Mothringer) Update item identified name if it has changed even if the item has been previously identified
-   (Mothringer) Fix wand and scroll drag and drop on the new NPC sheet
-   (Trollderim) Ensure proper coloring of 1s and 20s for rerolls. Closes #980
-   (fryguy) Fix minor issues with ABC item cards
-   (nikolaj-a) Default NPC skills to untrained. Closes #938
-   (nikolaj-a) Fix chat card tag for custom damage dice
-   (nikolaj-a) Better Dice So Nice integration for damage rolls

### New Features

-   (Ladis) New NPC sheet that combines editable and non-editable mode and splits up the information into tabs
-   (Mothringer) Automatic scrolls and wands from spells dragged to the inventory
-   (Mothringer) Make spellcasting wands into non-destroying consumables
-   (stwlam) Send chat message upon loot actor transaction
-   (fryguy) Support for drag & drop ancestries
-   (fryguy) Support for drag & drop backgrounds
-   (putty) Travel speed macro
-   (nikolaj-a) Add weapon potency rule element
-   (nikolaj-a) Add striking rule element
-   (nikolaj-a) Add multiple attack penalty rule element
-   (nikolaj-a) Add effect target rule element

### Content Changes

-   (TMun) Add descriptive text to Perpetual Infusions for all alchemist fields
-   (TMun) Convert Final Sacrifice to saving throw instead of spell attack. Closes #999
-   (TMun) Correct basilisk Will save from 1 to 11. Closes #1000
-   (TMun) Correct meladaemon action and damage type (technically not per book, but likely error in book for bite attack). Closes #984
-   (TMun) Correct Cavnakash spell attack modifier to +17 per book (vice standard 14 for spell DC). Closes #977
-   (TMun) Correct failure condition for Crushing Despair
-   (TMun) Correct success condition for Maze. Closes #1004
-   (TMun) Add spell effect to shield spell
-   (TMun) Convert background compendium from journal entries to items, in preparation for drag and drop support
-   (Drental) Fix Fauchard bulk value
-   (Drental) Update treat wounds macro to use the built-in roll check
-   (stwlam) Add spell effect for Protective Ward + new image for spell/effect
-   (stwlam) Clean up derived data from compendia (`_modifiers`, `_sheetTabs`, `sourceId`, `containerId`)
-   (profounddark) Add SetProperty rule element to Panache effect
-   (Shandyan) Correct Bracers of Armor I. Closes #998
-   (Shandyan) Change naming scheme for action predicate triggers:
    -   Correct predicates for actions on items
    -   Fix up item predicates for identify, as that can come from several different skills
-   (Shandyan) Sorcerer blood magic rule elements
-   (Shandyan & nikolaj-a) Add situational monster skill modifiers for Bestiary #1
-   (nikolaj-a) Fix situational skill modifier for demonologist
-   (nikolaj-a) Add rule elements for traits on monk class features Mystic Strikes, Metal Strikes, and Adamantine Strikes
-   (nikolaj-a) Add magic weapon spell effect

### Core System Improvements

-   (SLATE) Add lifesense to list of available PC senses
-   (TMun) Adds a specific spell tradition for Halcyon spells to support Magaambya archetype. Closes #963
-   (Mothringer) Hide the invest item toggle on loot actor sheet
-   (Mothringer) Remove ability to add prepared spells to slots lower level than the spell
-   (fryguy) Refactor the migration runner code to be much easier to maintain
-   (fryguy) Add error checking for code that looks into canvas for tokens to call updates
-   (stwlam) Change badge for chained conditions in the effects panel from a padlock to a link
-   (stwlam) Add variety to default actor and item images
-   (putty) Add size to the physical items
-   (nikolaj-a) Item sheet for NPC skills so rule elements can be added to those
-   (nikolaj-a) List situational NPC skill modifiers
-   (nikolaj-a) Enable roll note rule element for NPCs
-   (nikolaj-a) Refactor weapon damage calculation in preparation for rune rule elements

### Development Improvements

-   (stwlam) Ensure proper Actor class is inferred from ActorSheet subclasses
-   (stwlam) Use the actual handlebars npm package for type definitions
-   (stwlam) Update application-, dice-, canvas-related type declarations, address remaining errors/warning
-   (stwlam) Add class and data type for effects
-   (stwlam) Pack builder: Inject slugs into item compendium data
-   (stwlam) Allow type hints to be provided to game.packs methods
-   (Mothringer) Improve typing in SpellcastingEntry class and character.ts
-   (Mothringer) Add proper types to spell.ts
-   (Mothringer) Improve typing in item.ts and update SpellData's type definition to more closely match reality

## Version 1.10.32

### Bug Fixes

-   (Mothringer) Fix charging incorrect price when part of a stack is purchased

## Version 1.10.31

### Bug Fixes

-   (nikolaj-a) Use lazy mode when doing property injection in rule elements

### New Features

-   (Mothringer) Drag and drop merchant purchasing
-   (nikolaj-a) Roll note rule element for checks and damage

### Content Changes

-   (TMun) Errata for archetypes Maagambayan Attendant, Lastwall Sentry, Weapon Improviser, and the feat Widen the Gap. Closes #986, #989, #990 and #992
-   (TMun) Correct gloves of carelessness item slot
-   (TMun) Correct attitude condition items to errata 2.0. Correct overrides for attitude conditions
-   (Shandyan) Update alchemical item effects
-   (Shandyan) Set spell effect durations
-   (Shandyan) Update item descriptions for wands
-   (Shandyan) Brushed up a few items descriptions, and removed a couple of deprecated potion effects
-   (nikolaj-a) Notes on saving throw rolls for the saving throw enhanced by class features

### Core System Improvements

-   (stwlam) Move "property1" field, representing custom weapon damage, from all magic items to just weapons
-   (stwlam) Remove "property1" from non-weapons, "property2" and "property3" from all physical items
-   (Mothringer) Prevent spells from being added without a spellcasting entry when dropped on the rest of the sheet
-   (Mothringer) Hide the value of unidentified items on a loot actor from non-GM users
-   (In3luki) Add Variant Rules submenu to the system settings
-   (nikolaj-a) Better support default attack roll options
-   (nikolaj-a) Add a CSS class for the official Pathfinder 2E action icons

### Development Improvements

-   (stwlam) Remove unused modules, update rest except webpack and plugins

## Version 1.10.30

### Bug Fixes

-   (abrault) Fix the Feats tab of the Browser with prerequisites
-   (Shandyan) Fix selector for guidance spell effect, so it properly applies to perception
-   (Mothringer) Prevent loot actors from attempting to loot a token derived from themselves
-   (Mothringer) Fix group perception and stealth macros to not break when hazards and loot actors are also selected

### Content Changes

-   (putty) Fix ash web DC

## Version 1.10.29

### Bug Fixes

-   (stwlam) Set items to unequipped and uninvested on transfer between actors
-   (profounddark) Fix feat visibility
-   (profounddark) Fix missing translation key for swashbuckler traits
-   (profounddark & nikolaj-a) Filter out empty trait names
-   (nikolaj-a) Resolve selector in fixed proficiency rule element. Closes #979
-   (nikolaj-a) Fix shortform name for performance skill to ensure rule elements are properly applied
-   (nikolaj-a) Fix item identification for unlinked tokens

### Content Changes

-   (stwlam) Fix field order for barbarian instincts
-   (stwlam) Remove usage property from non-equipment
-   (Shandyan) Item effects, completing items starting with S
-   (Shandyan) Preparation of effects for items starting with T through Z
-   (Shandyan) Items effects, for items starting with T through W (excluding wands)
-   (TMun) Split up Specialty crafting into separate feats for each type
-   (nikolaj-a) Fix typo in eldritch archer archetype name
-   (nikolaj-a) Fix formatting of hammer quake feat description

### Core System Improvements

-   (putty) Escape earn income skill and move xp calculation into core

### Development Improvements

-   (stwlam) Adjust template.json to reflect data definitions for invested items
-   (TMun) Fix line endings after updating .gitattributes

## Version 1.10.28

### Bug Fixes

-   (Trollderim) Fix chat labels for traits
-   (stwlam) Fix scrolling in loot sheet when Configure Sheet is toggled on
-   (Mothringer) Fix column misalignment issue for inventory
-   (Mothringer) Remove nonfunctional treasure buttons from non-owned loot actors for player
-   (Mothringer) Fix item duplication when dragging items from sheets to tokens
-   (nikolaj-a) Fix spell chat cards for spells without custom traits

### Content Changes

-   (Evil Slime) Add barbarian rage compendium entries and rule elements:
    -   Rage effect
    -   Animal instincts
    -   Dragon instincts
    -   Fury instinct
    -   Giant instinct
    -   Spirit instincts
-   (nikolaj-a) Add rage action from class feature, including a link to the rage effect
-   (rectulo) Update Dread Marshal Stance description formatting
-   (rectulo) Update Clear the Way feat description formatting
-   (rectulo) Update Druid Dedication description
-   (rectulo) Fix typo in Unbalancing Finisher name
-   (rectulo) Update Mysterious Breath feat description
-   (rectulo) Update Hideous Ululation prerequisites
-   (rectulo) Update Unbalancing Finisher typo on Jirelle level 5
-   (SLATE) Added boons for season 2 00, 03, 08, Age of Ashes, and Menace Under Otari.
-   (SLATE) Added Deckhand background from Menace Under Otari
-   (profounddark) Added monk stance compendium entries, including rule elements and icons:
    -   Cobra stance
    -   Crane stance
    -   Dragon stance
    -   Gorilla stance
    -   Ironblood stance
    -   Mountain stance
    -   Rain of Embers stance
    -   Stumbling stance
    -   Tangled Forest stance
    -   Tiger stance
    -   Wolf stance
-   (TMun) Correct Shroud of Darkness to use saving throw instead of spell attack. Closes #970
-   (TMun) Update Ritualist archetype description with retraining penalty. Closes #975
-   (TMun) Adds ancestries as new ancestry items. The drag and Drop has not yet been implemented, so this is informational for now
-   (TMun) Set alchemist goggle rule elements to item modifier type
-   (TMun) Correct Snarecrafter Archetype Description. Closes #978
-   (TMun) Add Knight reclaimant dedication to shall not falter feat. Closes #983
-   (stwlam) Fix Rest for the Night macro for when Stamina setting has never been toggled
-   (stwlam) Rest Macro: Boost HP recovery if the actor has the Fast Recovery and/or Dream May feats
-   (putty) Add macros to roll stealth/perception for selected tokens
-   (putty) Add earn income macro
-   (Shandyan) Added rules effects for items starting with R and S

### New Features

-   (Mothringer) Update loot actor treasure bar appearance
-   (Mothringer) Add choice of recipients when distributing coins from a loot actor
-   (Mothringer) Add coin changing functionality to distribute coins button
-   (Mothringer) Add loot NPCs button to loot actor
-   (stwlam) Drag/drop item transfers between player-observable loot and player-owned actor sheets

### Core System Improvements

-   (Aramande) Changing modifiers on rolls for disabling fortune and misfortune plus adding secret
-   (putty) Remember previous values from XP popup
-   (putty) Make line breaks in hazard text editors work properly
-   (putty) Implement earn income logic
-   (abrault) Refactor rule element synthetics to simplify signature
-   (Drental) Removed legacy warning about CUB
-   (nikolaj-a) Refine identification data
-   (nikolaj-a) Strike rule element always-on options
-   (nikolaj-a) Support label field on modifiers

### Development Improvements

-   (stwlam) Improve accuracy of duplicate and mergeObject type declarations
-   (stwlam) Catch entity names not matching their corresponding file names when extracting
-   (stwlam) Update compendium entry extract script to strip out AoN span tags and normalize entity links
-   (stwlam) Run all pack JSON files through the extract script to clean them up
-   (stwlam) Prettier pass on type declarations
-   (stwlam) Improve type definitions for better inferencing and constraints
-   (stwlam) Keep PF2E CONFIG data in its own namespace
-   (stwlam) Fill out more pixi subclasses, remove @ts-ignore in src/scripts/init.ts
-   (stwlam) Restore Foundry's self-closing tags after running pack HTML through JQuery's parser
-   (stwlam) Add PF2EPhysicalItem class with convenience methods
-   (stwlam) Update typescript, eslint, and eslint plugins to latest
-   (stwlam) Remove unused Axios dev dependency
-   (fryguy) Enable prettier on all files, and format the entire code-base
-   (Chup) Normalize line endings for .ts and .js files to LF
-   (Mothringer) Add test coverage to calculateTotalWealth in treasure.ts

## Version 1.10.27

### Bug Fixes

-   (putty) Fix issue where moving items between actors deleted the original name

### Content Changes

-   (rectulo) Update Marshal, add missing text in target of opportunity feat trigger "an opponent within your weapon's first range increment."

### Development Improvements

-   (fryguy) Refactor the actor sheet \_onDrop function to use the latest API

## Version 1.10.26

### Bug Fixes

-   (Mothringer) Fix missing weaknesses on hazard sheet
-   (Mothringer) Cleanup hazards compendium
-   (putty) Use a different attribute to look up item rarity traits
-   (putty) Fix property runes, persist the original name in case of mystify
-   (putty) When mystifying an item, edit the original name instead of the unidentified name
-   (nikolaj-a) Prevent refresh attempts of uninitialized effect panel

### New Features

-   (Mothringer) Add a button to remove coins on the PC sheet

### Content Changes

-   (SLATE) Add missing PFS s1 boons
-   (SLATE) Add infiltrators accessory
-   (stwlam) Add rules elements to the _ventriloquist's rings_
-   (stwlam) Replace HTML anchors to compendium items with compendium links
-   (TMun) Correct failure criteria for _Steal the Sky_. Closes #957
-   (TMun) Correct prerequisites for _Cross the Final Horizon_. Closes #958
-   (TMun) Correct prerequisites for _Quick Juggler_ feat. Closes #961
-   (rectulo) Update _Knight Vigilant_ description
-   (Kaiser) Fix typo in _Warbal Bumblebrasher's_ surname

### Core System Improvements

-   (Trollderim) Add attitude dropdown to the NPC sheet
-   (Trollderim) Add missing localization labels
-   (nikolaj-a) Reduce redundant entity updates
-   (nikolaj-a) Include initiative for effect duration
-   (nikolaj-a) Enable effect panel by default

### Development Improvements

-   (putty) Properly type rune code
-   (stwlam) Add missing canvas-related type declarations, fill out some others

## Version 1.10.25

### Bug Fixes

-   (abrault) Allow Strikes to be popped out
-   (putty) Default to identified for non-physical items
-   (putty) Fix identify item popup changing size
-   (nikolaj-a) Fix unlinked token updates from rule elements and dragged effects
-   (nikolaj-a) Fix familiar-master relationship on startup

### Content Changes

-   (nikolaj-a) Fix duration for bundled spell effects

### Development Improvements

-   (Mothringer) Add information to CONTRIBUTING.md about using extractPacks to update compendium json files

## Version 1.10.24

### Bug Fixes

-   (Chup) Fix sell-all-treasure button to not trigger on Enter key press
-   (putty) Fix setting Potency Runes now correctly displays the dropdowns for Property Runes again
-   (Delethor) Changed check from modifier.label (does not exist) to modifier.name (does exist)
-   (SLATE) Fix prerequisites not always shown properly. Closes #950
-   (nikolaj-a) Fix effect panel refresh for unlinked tokens
-   (nikolaj-a) Amend NPC strike base damage with flat modifiers
-   (nikolaj-a) Fix rule element callbacks for unlinked actors, so rule elements like token icons should now apply properly

### New Features

-   (putty) Implement Identify Creature rules. Knowledge DCs are now shown in the NPC sheet. Works with Proficiency Without Level rules.
-   (putty) Implement Identify Magic and Alchemy rules and UI for items. Items can now be marked as unidentified (use the question mark icon in your inventory) and the DCs to identify them are shown when trying to identify them. Works with Proficiency Without Level rules.
-   (Mothringer) Add sell all treasure button to loot actor sheet
-   (Mothringer) Add distribution coins button on loot actor sheet
-   (nikolaj-a) Register start time of effects dragged to the actor sheet or token, track their duration, and mark as expired in the effect panel

### Content Changes

-   (Overdox) Unidentified items icons
-   (putty) Compendium updates:
    -   Rename One-Eye Amnin to Scarlet Triad Bruiser
    -   Rename Thea to Scarlet Triad Agent
    -   Implement XP macro. Selecting player and/or creature/hazard tokens and clicking the macro button shows the amount of XP a creature and/or hazard would give you. Works with Proficiency Without Level rules.
    -   Automate belt of good health
-   (San) Fix Lay on Hands heightening
-   (stwlam) Update Rest macro to restore focus pool and spell slots, remove Fatigued condition, and remove/reduce the Doomed and Drained conditions
-   (fryguy) Fix missing fields on Agents of Edgewatch #2 creature
-   (TMun): Compendium updates:
    -   Adds saving throw to _Jealous Hex_ spell
    -   Fix bludgeoning exception for _Doorwarden_ in Age of Ashes
    -   Adds area data to _Vomit Swarm_
    -   Adds gem stacking group to all gems from GMG page 11
    -   Changes _Nemmia Bramblecloak_ to a prepared caster
    -   Changes _robe of the archmagi_ to be armor vice equipment
    -   Corrects immunity text for _darkside mirror_
    -   Remove AoN span tags from archetypes.db
    -   Fix _Red Mantis Assassin_ paralyze spell
-   (SLATE): Compendium updates:
    -   Make _plane shift_ uncommon
    -   Replace ligatures. Closes #942
    -   Change spell actions from "x action(s)" to "x". Closes #922
    -   Add _moldy foodstuffs_ (yum!)
    -   Add _sodden floor_ trap
    -   Add _collapsing ceiling_
    -   Add _blightburn blast_ and its corresponding _blightburn sickness_
    -   Fix spelling error of _chirurgeon_
-   (nikolaj-a) Switch Laslunn melee damage entries to properly calculate base damage dice

### Core System Improvements

-   (profounddark) Implement Untrained Improvisation and Pathfinder Agent Dedication feats using rule elements
-   (putty) Implement Difficulty Classes rules
-   (putty) Make hazard text fields use the wysiwyg editor. That way it is possible to format hazard texts properly now.
-   (Trollderim) Add current overflowing light bulk to encumbrance display
-   (Hermannm) Add diceResults to damage rollData object for use in callbacks
-   (mdizo) Hazards Sheet Cleanup
-   (mdizo) Effect Panel setup
-   (fryguy) Reorder sidebar to put Class DC farther down
-   (fryguy) Add a button for rolling secret Perception Checks from the sidebar
-   (fryguy) Replace the proficiency rank indicator for Perception and Class DC from the plaque to the blue square to make it more consistent
-   (fryguy) Add a consistent rank=color scheme for the UI (skills tab, saves, and new master/button etc)
-   (fryguy) Make the size of the skill proficiency on the tab the same as in the sidebar
-   (abrault) Normalise searches in the compendium browser

### Development Improvements

-   (stwlam) Fix packbuilder regexp catching world-item links, fix world-item links
-   (stwlam) Update packs/extractpacks.js to convert links by ID to links by name
-   (stwlam) Avoid sorting ID keys in packextractor.js
-   (stwlam) Provide default for foundryConfig arg in extractpacks.js, make last warning in packbuilder.ts fatal
-   (SLATE) Include the following in the Open Gaming License file: PFS through s2-11, all APs up to #174, which releases end of 2021, all known Adventures, Beginner Box, and PFS bounties

## Version 1.10.23

### Bug Fixes

-   (Chup) Added confirmation dialog to 'Sell all treasure' button. Closes #576
-   (Trollderim) Fix quantity consideration in total wealth calculation
-   (Hermann) Fix callbacks to weapon damage functions
-   (nikolaj-a) Fix condition chat bubble grammar errors

### New Features

-   (@nikolaj-a) Initial version of effect panel
-   (nikolaj-a) Add set property rule element

### Content Changes

-   (putty) Set items to identified by default
-   (putty) Add remaining missing NPCs, hazards, and items for Beginner Box and Troubles in Otari
-   (putty) Add blinded flag to hunter's bow, to make it work with a toggle
-   (putty) Use more generic approach to trigger smoking sword damage
-   (Shandyan) Item effects for O and P
-   (SLATE) Moved wayfinder to razmiri (from ramziri)
-   (SLATE) Fixed all typos for retaliation
-   (SLATE) Added formulated sunlight, a ration for leshys that require photosynthesis
-   (TMun) Correct values of starknife again
-   (TMun) Fixes equipment data entry errors
-   (Mothringer) Add error message to treat wounds macro when no token is selected instead of silently failing

### Core System Improvements

-   (Trollderim) Clean up UI of compendium browser
-   (nikolaj-a) Automatically advance world clock every combat round
-   (nikolaj-a) Basic world clock application
-   (nikolaj-a) Align apply damage icons with context menu
-   (nikolaj-a) Setting to disable condition chat bubbles

### Development Improvements

-   (fryguy) Hack the actor constructor so that we can have polymorphism in the future without having a million line actor class
-   (fryguy) Remove default exports from codebase, and add linter check
-   (fryguy) Make the PF2EItem generic so that it's potentially type-safe in the future.
-   (fryguy) Add the same polymorphism factory hack to Items as well as Actors
-   (fryguy) Remove character helper class
-   (fryguy) Separate PF2EActor prepareXData functions into their own subclasses instead of having it all in the same file
-   (stwlam) Add missing @type dependencies
-   (stwlam) Rename ActorData in actor-data-definitions.ts so it doesn't collide with ActorData in actor.d.ts
-   (stwlam) Remove discarded item/actor construction in favor of checking options

## Version 1.10.22

### Bug Fixes

-   (putty) Fix parsing for missing and non-conforming prices
-   (nikolaj-a) Omit breakdown of familiar abilities, if none is present on the master

## Version 1.10.21

### Bug Fixes

-   (nikolaj-a) Ensure hotbar assignment is repeatable
-   (nikolaj-a) Fix invalid ability abbreviation. Closes #849
-   (nikolaj-a) Add jaws strike for razortooth goblin. Closes #725

### New Features

-   (Trollderim) Add UI element in the inventory which sums up the total gold value of a character's inventory
-   (nikolaj-a) Add Strike rule element

### Content Changes

-   (putty) Compendium additions, changes, and fixes:
    -   Add Menace Under Otari Bestiary
    -   Use same attributes for trapmaster as Menace under Otari
    -   Add Smoking Sword and automate Spirit Strikes
    -   Fix stats and abilities for wyrmling and giant spider
-   (Kaiser) Crit and fumble deck typos fixed
-   (Shandyan) Compendium changes:
    -   Rules effects for items starting with J through N
    -   Added token effect icons to spell effects
    -   Corrections to items. Closes #920
-   (profounddark) Updated swashbuckler class features with finisher toggle
-   (SLATE) Clean up compendia, like removing trailing spaces, invalid characters etc:
    -   Cleanup pfs season 1 bestiary.db
    -   Cleanup pfs season 2 bestiary.db
    -   Cleanup spell effects.db
    -   Cleanup spells.db
    -   Cleanup the slithering bestiary.db
    -   Cleanup pathfinder society boons.db
    -   Cleanup pathfinder bestiary.db
    -   Cleanup npc gallery.db
    -   Cleanup iconics.db
    -   Cleanup gmg srd.db
    -   Cleanup fall of plaguestone.db
    -   Cleanup extinction curse bestiary.db
    -   Cleanup equipment.db
    -   Cleanup deities.db
    -   Cleanup actions.db of unicode
    -   Cleanup conditionspf2e
    -   Cleanup feats.db
-   (SLATE) Fixed some names and added missing goblin skeletons
-   (SLATE) Added Troubles in Otari bestiary and items
-   (nikolaj-a) Remove hardcoded Cinderclaw Gauntlet damage, and fix related damage dice rule element

### Core System Improvements

-   (@abrault) Add force option to Fixed Proficiency Rule Element
-   (fryguy) Initial work for supporting drag and drop ancestries, backgrounds, and classes
-   (Kaiser) Action icons recreated - old ones had compression artefacts
-   (Hermann) Add callbacks to weapon damage functions for better utilization from macros
-   (nikolaj-a) Localize actor and item types in create dialog
-   (nikolaj-a) Toggle for hiding strikes of unequipped weapons
-   (nikolaj-a) Make toggles draggable to the hotbar
-   (nikolaj-a) Support for backstabber weapon trait
-   (nikolaj-a) Injectable properties in rule element selectors

### Development Improvements

-   (@mirkoRainer) Update CONTRIBUTING.md since the pf2e-dev does not exist anymore
-   (stwlam) Tighten up the compendium assembly process:
    -   Typescript implementation of packbuilder
    -   Replace all links by ids with links by name, change over to packbuilder.ts
    -   Generate many warnings from packbuilder.ts
    -   Add system-local mystery-man.png, fix broken links to one from Foundry
    -   Fix remaining broken-image-link and missing-label warnings - Above warnings now fatal - File-system work in packbuilder.ts now synchronous
    -   Fix more pack issues, make base64-encoded image data fatal
    -   Fix all but one of the remaining broken links
-   (stwlam) Update CONTRIBUTING.md with Compendium content guidelines.
-   (nikolaj-a) Update vulnerable dependency versions
-   (nikolaj-a) Salvage use of AbilityString type

## Version 1.10.20

### Bug Fixes

-   (nikolaj-a) Fix broken actor sheet for spells with long casting time
-   (nikolaj-a) Fix broken strikes for new NPC actors
-   (nikolaj-a) Fix loading feats in the Compendium Browser

### Content Changes

-   (stwlam) Treat Wounds macro: fill in bonuses, make medicine-check message mirror skill checks
-   (SLATE) Unicode/HTML entity cleanup and fixed trailing spaces and newlines in paragraph tags
-   (SLATE) Convert all prerequisite strings to arrays for better data format compatibility
-   (nikolaj-a) Spell effect icons for example spell effects

## Version 1.10.19

### Bug Fixes

-   (nikolaj-a) Fix sheet opening bug

## Version 1.10.18

### Bug Fixes

-   (fryguy) Sort the list of damage types so that they're easier to find in the dropdown. Closes #416
-   (SLATE) Shorten usage text to prevent UI breakage. Closes #913
-   (nikolaj-a) Damage roll chat message type, for integrate better with Tabbed Chat module

### New Features

-   (nikolaj-a) Add experimental strikes to NPC sheet

### Content Changes

-   (Kaiser) Immunities of NPCs moved out of custom field for Bestiary 1, Bestiary 2, Plaguestone bestiary, Agents of Edgewatch bestiary, Extinction Curse bestiary, Age of Ashes bestiary, Slithering, and Pathfinder Society season 1 and 2
-   (Kaiser) Usage corrections for runes, aeon stones, talisman, and various worn items
-   (Shandyan) Rules effects items starting with D through I
-   (stwlam) Fill in missing data for a few focus spells
-   (stwlam) Fix/cleanup Treat Wounds macro
-   (TMun) Remove duplicate bestiary entries
-   (SLATE) Remove trailing spaces in feat names, item names, and deity names
-   (SLATE) Convert prerequisite information for the new format in item sheets
-   (SLATE) Add two creatures and hazard from PFS 1-00

### Core System Improvements

-   (SLATE) More obvious placement of prerequisites in item sheet
-   (Trollderim) Add color and cursor change for ability check hovering
-   (Trollderim) Add filtering by level for equipment, hazards, and monsters in Compendium Browser
-   (nikolaj-a) Expose roll-related classes to macros. Closes #876
-   (nikolaj-a) Popout support for specific chat cards

### Development Improvements

-   (SLATE) Added debug flag to pack builder and added commands that will enable debugging
-   (nikolaj-a) Make action icons available in actor class

## Version 1.10.17

### Bug Fixes

-   (@CarlosFdez) Fix type check in addConditionToToken
-   (@nikolaj-a) Fix non-condition token status icons (#782)

### New Features

-   (@mathmanpi) Add rule elements to count available familiar abilities
-   (@nikolaj-a) Support damage type and category for flat modifier rule element
-   (@nikolaj-a) Token effect icon rule element

### Content Changes

-   (Evil Slime) Fix ogre spider damage
-   (@TMun) Compendia content fixes:
    -   Correct waterskin text for errata 2
    -   Change the format of the Flaming Sphere Area
    -   De-pluralizes Spiritbound Aluums
    -   Delete magma dragons from AoA Bestiary
    -   Fixes One-eye Amnin club attack
    -   Corrects trick magic item feat action requirement
    -   Adds weaknesses/resistance to clockwork assassin
    -   Changes giant immunities from custom to labeled value
-   (SLATE) Cleanup compendium entries formatting, including condition links, for feats
-   (SLATE) Compendia content fixes:
    -   Fix minor NPC issues with 1-22 and fixes quotes on zombie flesh golem
    -   Fix Awesome Blow feat level
    -   Fix description of Assurance feat to indicate it can be selected multiple times
-   (@Sirrus233) Update Charm spell with proper heightening info

### Core System Improvements

-   (@profounddark) Updated initiative to improve predicate support
-   (Evil Slime and fryguy) Change gender textbox to also include pronouns. Closes #886
-   (fryguy) Remove experimental disclaimer from strikes
-   (@nikolaj-a) Tweak rule element create and delete hooks

## Version 1.10.16

### Bug Fixes

-   (@stwlam) Fix issues preventing creation and correct rendering of custom conditions
-   (@stwlam) Fix application of conditions when dropping condition items on actor sheets
-   (@stwlam) Adjust item-sheet HTML to take on intended styling
-   (@mathmanpi) Fix shield HP tooltip. Closes #455
-   (SLATE) Fixed NPC gallery not showing up in Bestiary source filter. Closes #858
-   (SLATE) Added traits to spell chat card. Closes #821

### New Features

-   (fryguy) Allow configuring the default token settings that get set
-   (SLATE) Added spell traits filter to compendium browser

### Content Changes

-   (@Sirrus233) Fix broken path to Dagger icon in Guard NPC sheet
-   (fryguy) Add Agents of Edgewatch 5 bestiary
-   (@TMun) Add missing monsters and hazards from EC1, correct Abrikandilu
-   (@TMun) Add missing EC2 monsters and hazards
-   (@TMun) Adds EC3 traps
-   (@TMun) Adds Bounty 3 NPC to PFS Season 2
-   (@TMun) Adds missing EC4 monsters and traps
-   (@TMun) Adds EC hazard traits
-   (@TMun) Adds PFS 2-05 and 2-06 monsters
-   (@TMun) Compendia content fixes:
    -   Corrects Gust of Wind, Needle of Vengeance, and Vampiric Maiden to saving throws.
        Charitable Urge was incorrectly labelled. Closes #838 and #842
    -   Standardize typography for spells up to R
    -   Fix spell text and links
    -   Fix Mohrg. Closes #859
    -   Adds Warden Spells as a Ranger Class Feature. Closes #860
    -   Fixes mending spell from #862. Numerous spell fixes. Closes #861
    -   Correct Stratagem spelling. Closes #847
    -   Fix size of Adamantine Golem and 3nd level scrool to 3rd level scroll. Closes #851
    -   Correct Minderhal spelling in icon. Closes #854
    -   Fix token default to 2x2 instead of 1x1 for Gelatinous Cube
    -   Fix backgrounds that had truncated descriptions. Closes #856
    -   Update Pummeling Rubble - move text from `area` to `areasize`
    -   Change wilding word to saving throw
-   (SLATE) Add creatures for PFS 2-07, 2-08
-   (SLATE) Added Second Chance Spell feat
-   (SLATE) Errata v2:
    -   Classes
    -   Class Features
    -   Feats
    -   Spells
    -   Actions
    -   Equipment
-   (SLATE) Cleanup compendium entries formatting, including condition links:
    -   Actions
    -   Backgrounds
    -   Classes
    -   Class Features
    -   Feats
    -   Spells
    -   Equipment
    -   Hazards
    -   Bestiary 1
    -   PFS Season 1 bestiary
    -   PFS season 2 bestiary
    -   Gamemastery Guide
    -   NPC Gallery
    -   Iconics
    -   Critical Deck
    -   Age of Ashes bestiary
    -   Agents of Edgewatch bestiary
-   (SLATE) Compendia content fixes:
    -   Fix Ward Domain spell
    -   Fix Accursed Forge-Spurned and Thea from Age of Ashes book 4. Closes #864
    -   Change Invoke Reckoning from one action to a reaction for Age of Ashes Skeletal Hellknight. Closes #865
    -   Broken condition links in Umbral Dragon. Closes #866
    -   Added `bulkcapacity` and `negatebulk` to the knapsacks. Closes #867
    -   Fix damage for Burglar from the GMG. Closes #868
    -   Fix safe passage spell area of effect. Closes #870
    -   Changed some creature names from plural to singular. Added missing Tyrroicese. Closes #872
    -   Fix range and area for Animated Assault, Fungal Infestation, Lightning Storm, Spike Stones, and Transmute Rock to Mud. Closes #874
    -   Change cursebound and hex traits from custom traits to built-in traits

### Core System Improvements

-   (@georg.doehring) Status effects chat message translatable
-   (@profounddark) Swashbuckler rule elements, Panache and Precise Strike
-   (@mathmanpi) Add item effects to items starting with D
-   (@nikolaj-a) Separate damage types on damage roll chat card

### Development Improvements

-   (fryguy) Fix some typos/documentation

## Version 1.10.15

This version of the PF2E system requires at least version of 0.7.5 of Foundry.

### Bug Fixes

-   (@abrault) Fix dice multiplication in critical rule
-   (fryguy) Remove strike class from status effect html
-   (@TMun) Corrects title of 'show status effects' and adds space to 'the actors' in system game settings
-   (@TMun) Corrected types for various entity field:
    -   Correct typing for condition value from string to int. Change doomed and slowed to be valued
    -   Changes types to string for data.property1.value, data.range.value, data.reload.value and data.MAP.value (#828)
    -   Adds field types to feat details, weapon details, and action details
    -   Remove null values from data.skill_requirement.skill.rank and data.actions.value
-   (@TMun) Coverts traits to title case in en.json. Adds clockwork and herald traits from AoE4. Alphabetize some of config.ts (#834)
-   (@nikolaj-a) Replace calls to deprecated isPC method
-   (@nikolaj-a) Familiar non-owner permission issue
-   (@nikolaj-a) Allow players to roll saving throw from spell chat card

### New Features

-   (fryguy) Add rules element for Sneak Attacker

### Content Changes

-   (fryguy) Add Agents of Edgewatch 4 bestiary
-   (@overdox) Icon updates
-   (@overdox) Remove unused test icons
-   (@TMun) Adds AoE4 spells and equipment
-   (@TMun) Icon updates
-   (@TMun) Regeneration of all item roll tables. Now only hold CRB-listed items and weighted.
-   (@TMun) Compendia issues
    -   Update flaming-sphere.json (#840)
    -   Swaps Armbands of Athleticism Greater and normal versions (#836)
    -   Corrects rollable tables, adds percentages explicitly, updates GMG SRD. Adds Deck of Many Things effects. Corrects Rod of Wonder Links (#827)
    -   Correct draconic exemplar link, update ancestry features
    -   Update conditionitems.db to use draggable links instead of compendium links. Add inline rolls for flat checks and remove duplicate links within a single entry
    -   Corrects text for panache and adds a rule element for improvised weapons
    -   Fix apostrophe's and update actions.db to 0.7.x standard. Cleanup of HTML tags and extraneous spaces. Made all entries into a common format

### Core System Improvements

-   (@georg.doehring) Use localization for "modifiers"
-   (@nikolaj-a) Change UI theme name to better reflect its actual progress
-   (@nikolaj-a) Update minimum compatible Foundry version to 0.7.5

### Development Improvements

-   (@Kevin) Add auto-docs

## Version 1.10.14

### Bug Fixes

-   (@JensChup) Added fix for wrong speaker in chatmessage when other token was selected (#813)
-   (@lotrein) Added icon padding and width rules to prevent icon shrinkage due to long titles. Added similar styles to effects/inventory/spellbook tabs (#682)
-   (@iceman) Make entire toggle clickable in check modifier dialog

### New Features

-   (@abrault) Add flag to lock proficiencies
-   (@nikolaj-a) Roll option support for flat modifier rule element, enabling support for conditional modifiers on passive stats like AC and speed
-   (fryguy) Add save button to spell saves

### Content Changes

-   (@overdox) Icon updates
-   (fryguy) Compendium updates:
    -   Add Agents of Edgewatch 1 bestiary
    -   Add Agents of Edgewatch 2 bestiary
    -   Add Agents of Edgewatch 3 bestiary
    -   Fix typos in critical hit deck
-   (fryguy) Add description for oracle and witch
-   (fryguy) NPC action category migration
-   (@TMun) Lost Omens: Pathfinder Society backgrounds, equipment, feats, and spells
-   (@TMun) Pathfinder Society
    -   PFS Season 1 bestiary
    -   PFS Season 2 bestiary
-   (@TMun) Add precious trait to alchemical items and adds 'affixed to armor' for talismans
-   (@TMun) Correct class kit armor entries for new leather armor ID
-   (@TMun) Corrects incorrect usage of apotrophe - standardizes <E2><80><99> to '
-   (@TMun) Corrections
    -   Kobold Breath link incorrect (#799)
    -   Identify Magic Traits (#800)
    -   Agents of Edgewatch 3 feats, archetype and items added (#801)
    -   Corrects name for Potion of Flying (Standard) (#820)

### Core System Improvements

-   (fryguy) Since attackEffects uses the trait selector, we need to also show "custom" effects
-   (fryguy) Remove compendium items from the NPC sheet, as they didn't work anyways
-   (fryguy) Add "Melee" or "Ranged" in front of NPC attacks to make them more like the creature statblocks. Also so that it was more clear why there were two "dagger" attack buttons on certain NPCs when they have a ranged and melee attack.
-   (fryguy) Add item quantity to the item display on NPC items
-   (fryguy) Update the npc sheet to use `data.actionCatgegory` (which is what's editable in the UI) instead of `data.pf2e_updatednpcsheet.npcActionType` (which doesn't seem to be set anywhere).
-   (fryguy) Remove the item edit buttons on the non-editable npc sheet (to make more room)
-   (fryguy) Fix lint mistake in the migration code
-   (@Kevin) Brushed up the contributing page, and moved the OGL to the files being distributed with the system

## Version 1.10.13

This is most likely the last version that will support version 0.6.6 of Foundry.

### Bug Fixes

-   (@abrault) Fix reroll menu check
-   (@abrault) Check if user can update actors before moving item

### New Features

-   (@JensChup) Added Vehicle sheet

### Content Changes

-   (@Shandyan) Rule elements for items A through C
-   (@JohnSBarden) Fixes for Enervation and Agonizing Despair (#763)
-   (@JohnSBarden) APG Spell fixes (#763)

### Development Improvements

-   (@blacksmithgu) Delete now unused conditions code
-   (@mdizo) UX: Removed hardcoded styles on chat tags
-   (@mdizo) Added Gelasio Bold

## Version 1.10.12

### Bug Fixes

-   (@nikolaj-a) Fix PFS level bump slider
-   (@nikolaj-a) Fix the creature conditions

## Version 1.10.11

### New Features

-   (@abrault) Add rule elements on tokens to change size and image
-   (@nikolaj-a) Add familiar actor type and sheet

    -   Add hit points to familiar
    -   Add custom modifier support to familiars
    -   Add armor class to familiar
    -   Add saving throws to familiar
    -   Add perception to familiar
    -   Add skills to familiar
    -   Add details to familiar
    -   Add conditions and effects to familiar
    -   Add rolls to familiar
    -   Add speeds to familiar
    -   Sense and speed tags to familiar
    -   Add Core Rulebook familiar abilities compendium
    -   Add Advanced Player's Guide familiar abilities compendium
    -   Ignore certain modifiers on familiars

-   (@mdizo) Basic styling of the familiar sheet
-   (@nikolaj-a) Toggle property rule element
-   (@nikolaj-a) Bass speed rule element
-   (@nikolaj-a) Sense rule element

### Bug Fixes

-   (@abrault) Fix logo height to prevent sidebar jumping
-   (@abrault) Fix saves from hazards
-   (@In3luki) Fix crit and fumble buttons potentially crashing the browser
-   (@In3luki) Fix spells test for the new data structure
-   (@In3luki) Fix errors for rolls with no dice
-   (@nikolaj-a) Return promise when setting roll option
-   (@nikolaj-a) Add all weapon traits as options to attack rolls from strikes

### Content Changes

-   (@overdox) Spell Icon update
-   (@overdox) Removing unused duplicate icons
-   (@Shandyan) Alchemical poison formatting
-   (@Shandyan) Compendium corrections (class features & spells)
-   (@TMun) Fixes missing details from errata and fixes class kit loadout (#769, #770)
-   (@TMun) Fixes Toughness description per errata 1 (#759)
-   (@TMun) Repackage. Closes #788, #781, #779 and #78. Corrects part of #786
-   (@TMun) Adds heightening information to Synesthesia spell
-   (@nikolaj-a) Power Attack feat rules

### Core System Improvements

-   (@JensChup) Added UnitPrice for LootSheet
-   (@TMun) Adds Focus and Ritual to Spell Traditions since they can be flagged as that for backend heightening
-   (@mdizo) Moved CSS classes for "tags" to global scope
-   (@nikolaj-a) Add a melee or ranged damage option
-   (@nikolaj-a) Add modifier system for character speeds
-   (@nikolaj-a) Dynamic toggles on character sheet
-   (@nikolaj-a) Add minion trait

### Development Improvements

-   (@In3luki) Extract individual compendium entries into separate JSON files
    -   Use NeDB to extract and build pack files
    -   Remove duplicate entries from two compendium packs
    -   Add /static/packs/ directory to .gitignore
    -   Add previously broken entry to pathfinder-bestiary-2.db
    -   Add entityIdChanged() check to pack extraction
    -   Sort extracted JSON data by its keys and extract all entities as sorted JSON

## Version 1.10.10

### New Features

-   (@nikolaj-a) Damage dice rule element

### Bug Fixes

-   (@In3luki) Fix card button click expanding roll details
-   (@In3luki) Fix fumble button drawing from crit table
-   (@In3luki) Fix initiative button on skill rolls and remove references to roll.parts

### Content Changes

-   (@Shandyan) Adding effects and cross-links to alchemical items
-   (@nikolaj-a) Add damage dice rule element to the rogue Sneak Attack class feature

### Core System Improvements

-   (@In3luki) Critical Hit and Fumble Cards improvements
    -   Add context flag to all d20 rolls and use context.type in all hooks
    -   Add context to roll flags and move flag creation inside roll.toMessage()

## Version 1.10.9

### New Features

-   (@abrault) Add rule element for Temporary Hit Points
-   (@abrault) Add rule element for Fixed Proficiency
-   (@In3luki) Add a button to attack rolls to manually draw a critical hit card
-   (@In3luki) Add item drop on tokens handler (0.7.x only)
-   (@KSops) Adding MAP to spell chat card
-   (@meditatingCybermind) Added fame and reputation tracking for pfs
-   (@nikolaj-a) Target flat-footed checkbox on actions tab
-   (@nikolaj-a) Add onAfterPrepareData hook on for rule elements
-   (@nikolaj-a) Add basic value bracketing option to rule elements
-   (@nikolaj-a) Add default label to rule elements
-   (@nikolaj-a) Dexterity modifier cap rule element
-   (@nikolaj-a) Add Guidance spell effect to compendium
-   (@nikolaj-a) Mage armor spell effect

### Bug Fixes

-   (@In3luki) Remove redundant image edit listener
-   (@lotrein) Fix for Diehard correctly increasing both wounded and doomed conditions as well as changing the max values when removed (#455)
-   (@lotrein) Fix Dangerous Sorcery feat adding damage to cantrips and focus spells (#734)

### Content Changes

-   (@olilan) Update Treat Wounds macro for feats
-   (@overdox) Fix for treasure items that had broken image names
-   (@overdox) Spell icon updates
-   (@TMun) Added base damage to all acid flasks in the bonus damage field. Replaced acid flasks on Fumbus and Quinn with updated version
-   (@TMun) Corrects voidworm damage (#745)
-   (@TMun) Relinked character sheet iconics images
-   (@TMun) Add example spell effects for magic shield, guidance and add effects for panache and dueling parry

### Core System Improvements

-   (@abrault) Find location for player settings for all versions
-   (@blacksmithgu) Add types to dice pools in weapon damage
-   (@mdizo) UX: Effects Tab - Basic Styles
-   (@mdizo) UX: Actions Tab Rework
-   (@nikolaj-a) Actions tab navigation
-   (@nikolaj-a) Non-encounter draft UI

### Development Improvements

-   (@mdizo) Updated sourceMap config

## Version 1.10.8

### New Features

-   (@In3luki) Add system setting to automatically draw a crit or fumble card
-   (@KSops) Adding treasure value to loot and character sheets
-   (@meditatingCybermind) Added fame and reputation tracking for PFS
-   (@nikolaj-a) Initial rule element framework with support for flat modifiers on all item types
-   (@nikolaj-a) Add effect as a built-in item type, which can serve as a peg for rule elements

### Bug Fixes

-   (@abrault) Fix error when pfs field is not defined on a character
-   (@abrault) Return the roll from Pf2eDice functions

### Content Changes

-   (@iceman) Improve Treat Wounds macro formatting
-   (@Shandyan) Corrections to bestiaries to add back in accidentally deleted DCs
-   (@TMun) Compendium changes:
    -   Clean up of feat traits and correction of archetype feats from class feats
    -   Adds Edgewatch Detective and Jamleri Dedications and feats
    -   Adds missing Aasimar feats
    -   Added exhale poison action
    -   Added feats from EC6
    -   Add Agents of Edgewatch Book 2 Equipment and Spells
    -   Recreate Iconics with new feats and items, correct errors, add APG Iconics, convert icons to webp (#473)
    -   Evocation school and Biresonant Wayfinder (#741, #744)
-   (@TMun) Update OpenGameLicense.md to add AoE2, PFS #2-00, #2-01, #2-02 and PFB #1
-   (@nikolaj-a) Add spell effects compendium, with an example Inspire Courage spell effect

### Core System Improvements

-   (@abrault) Replace Invest icon with sparkles
-   (@nikolaj-a) Add condition chat card
-   (@nikolaj-a) More information in limited character sheet
-   (@mdizo) Added Open Roads icon to the Pathfinder Society tab
-   (@mdizo) Improved styling of the limited character sheet
-   (@mdizo) Added style matching the character sheet to the Foundry tool menu on the left
-   (@mdizo) More space for the lore skills on the sheet to prevent long names from getting truncated

## Version 1.10.7

### New Features

-   (@nikolaj-a) Initial implementation of PFS Level Bump
-   (@nikolaj-a) Add editor for public biography
-   (@nikolaj-a) Add sheet for limited character access

### Bug Fixes

-   (@blacksmithgu) Fix loot actor dragging, and types for duplicate, container, and bulk calculation logic

### Content Changes

-   (@TMun) Add new icons from Firgof to bestiary 1 and 2

## Version 1.10.6

### New Features

-   (@BoMbY) Modifiers for Maximum HP to support Drained
-   (@In3luki) Add drag and drop sorting for spellcasting entries
-   (@In3luki) Add drag and drop sorting to spells
-   (@nikolaj-a) Custom modifiers for PC lore skills
-   (@nikolaj-a) Add organized play numbers to character sheet
-   (@nikolaj-a) Add support for hp-per-level modifier

### Bug Fixes

-   (@abrault) Restore functionality to hazard buttons
-   (@atnoslen) Fix token conditions panel highlighting for conditions applied by other conditions (#736)
-   (@nikolaj-a) Fix tab title on actor update
-   (@nikolaj-a) Fix rolls with modifiers lacking predicates

### Content Changes

-   (@Shandyan) Added back in accidentally deleted DCs and other text

### Core System Improvements

-   (@BoMbY) Remove check for untyped bonuses
-   (@blacksmithgu) Type several utility methods, improve foundry types, finish actor type definitions
-   (@nikolaj-a) Reformat character martial proficiencies

## Version 1.10.5

### New Features

-   (@atnoslen) Remove Condition button added to Effects tab in the character sheet
-   (@KSops) Add Item Investment Tracker
-   (@seanmunkel) Implement dangerous sorcery feat damage
-   (@nikolaj-a) Support for custom Dexterity modifier caps
-   (@nikolaj-a) Add Pathfinder Society tab on character sheet

### Bug Fixes

-   (@abrault) Attempted fix for the temporary db~ file error, by not calling getChatData on all items
-   (@atnoslen) Various bugfixes to make the conditions more robust
-   (@In3luki) Enforce max HP and SP values in actor sheets
-   (@Ralar) Restore player settings button in 0.6.6+
-   (@nikolaj-a) Fix hotbar skill macro to support Furnace

### Content Changes

-   (@overdox) More equipment icons
-   (@TMun) Add Ysoki Language. Removes Osirian (incorrect duplicate of Osiriani) (#723)
-   (@TMun) Equipment and spell fixes (#726, #728, #730, #731)

### Core System Improvements

-   (@In3luki) Select the text in an input field on focus in the actor sheets
-   (@blacksmithgu) A _lot_ of internal changes to improve type definitions and clean up code.

## Version 1.10.4

### Bug Fixes

-   (@abrault) Fix type of spell levels
-   (@In3luki) Fix trait selector
-   (@In3luki) Fix stamina in character sheet

### Content Changes

-   (@TMun) Corrects Divine Font and Tempest Form Entries (#721)

### Core System Improvements

-   (@mdizo) Revamped Character Sheet Navigation
-   (@nikolaj-a) Change character sheet navigation to change title on hover

## Version 1.10.3

### New Features

-   (@nikolaj-a) Add Effects tab on character sheet
-   (@In3luki) Enable drag and drop to hotbar for strike actions and skill checks

### Content Changes

-   (@TMun) Compendium updates:
    -   Update to equipment - Traits, cost, level, handedness corrected.
    -   Added 169 missing items from Lost Omen Legends, AoE and magic items from APG
-   (@TMun) Compendium corrections:
    -   Voz Lirayne does not, in fact, have a longbow (#706)
    -   Lazurite Infused Golem has wrong golem antimagic (#717)
    -   Breastplate of Command and Greater Breastplate of command have the wrong activate action (#718)
-   (@abrault) Update OGL with EC 4-6 and AoE 1

### Core System Improvements

-   (@atnoslen) Refactor of the condition manager to improve then efficiency, and work better with the token HUD.
-   (@blacksmithgu) Added missing type definitions for the creature actors.

## Version 1.10.2

### Bug Fixes

-   (@nikolaj-a) Fixed flat modifiers on damage rolls
-   (@atnoslen) Changed "Fascinated" condition to apply penalty on all skill checks instead of the individual skills in preparation for also applying to lore skills

## Version 1.10.1

### Bug Fixes

-   (@abrault and @In3luki) Fix hotbar macro drag and drop issue

## Version 1.10.0

### New Features

-   (@nikolaj-a) More capabilities to set roll mode
    -   Roll mode dropdown in check roll dialog
    -   Support secret option for rolls
-   (@nikolaj-a) Tentantive support for conditions on NPCs (attack/damage rolls still not supported)
    -   Custom modifiers for NPC armor class
    -   Custom modifiers for NPC saving throws
    -   Custom modifiers for NPC perception
    -   Custom modifiers for NPC skills
-   (@atnoslen) Custom conditions in the condition manager

### Content Changes

-   (@abrault) Add kits to Compendium Browser
-   (@TMun): Corrected entries for equipment compendium up to G

### Bug Fixes

-   (@nikolaj-a) Fix broken UI events for damage and critical damage rolls
-   (@abrault) Change title of Treat Wounds result
-   (@atnoslen) Condition manager bugfixes, including drag & drop integration
-   (@Ralar) Better support for dragging items to and from unlinked actors, which should help with the loot sheet

### Core System Improvements

-   (@abrault) Major code clean up
-   (@blacksmithgu) Better code type information for parts of the character and NPC actors
-   (@mdizo) Reworked character sheet navigation to make room for more tabs

## Version 1.9.7

### New Features

-   (@atnoslen) Added a condition manager that knows how to deal with overriding and linked conditions, and allows users to add custom conditions.

### Content Changes

-   (@overdox) Compendium changes
    -   Added more equipment icons
    -   Added more spell icons
-   (@TMun) Compendium changes
    -   Add Irori boons and curses (#690)
    -   Re-add Graveknight and Shaitan to Bestiary 1 (#688)
    -   Correct spelling of Gloomglow Mushrooms in AoA bestiary (#689)
-   (@TMun) Added several missing traits

### Bug Fixes

-   (@abrault) Catch NaN error when modifying token attribute
-   (@In3luki) Add check to FormulaPreservingRoll for Foundry 0.7.x compatibility
-   (@nikolaj-a) Fix token HUD shield resource

### Core System Improvements

-   (@abrault) Refactor kits to allow homebrew, and changed the built-in kits to use the new setup
-   (@Ralar) Loot sheet updates: clean up layout and add description field, and fix treasure value

## Version 1.9.6

### New Features

-   (@fryguy1013) Allow editing max xp (for PFS characters, and homebrew XP)

### Content Changes

-   (putty#0555) Add property runes for APG and Devil at the Dreaming Palace
-   (@overdox) Compendium updates
    -   Equipment icons
    -   Fix corrupted art objects
    -   Other icons
-   (@TMun) Compendium updates
    -   Ki Strike Spell fix and spells.db compaction (#687)
    -   Poison weapon feat chain errors (#673)
    -   Experienced Smuggler skill feat level (#674)
    -   Add Lost Omens Character Guide NPCs and change compendium name (#686)
    -   Club equiment description is misplaced (#654)
    -   Add Exquisite Sword Caneand Exquisite Sword Cane Sheath from Extinction Curse (#670)
    -   Leather armor errors (#678)
    -   Alchemical crossbow bulk error (#680)
    -   Satchel errors (#681)

### Artwork Contributions

-   (Firgof) Multiple bestiary artwork

### Bug Fixes

-   (@atnoslen) Add prone condition attack penalty
-   (@atnoslen) Fix treat wounds macro crit success/failure
-   (@baberg) Fix status icon directory (#685)

### Core System Improvements

-   (@abrault) Add highlight around embedded images
-   (@atnoslen) Added optional callback to actor roll updates.

### Development Improvements

-   (@blacksmithgu) Major cleanup of some part of the code, including removing the old character sheet and simplification of the custom modifier system.

## Version 1.9.5

### Content Changes

-   (@abrault) Assign more specific feat type to some general feats from the APG
-   (@abrault) Extract most Base64 images from compendia
-   (@abrault) Remove Base64 images from items embedded in compendium actors
-   (@overdox) Added icons to some of the equipment from the APG
-   (@TMun) Compendium updates
    -   Adds The Slithering enemies, traps and items
    -   Adds remaining non-magical items from APG (#656, #659, #662, #664, #665, #666, #667, and #668)
-   (@TMun) Added APG class equipment kits

## Version 1.9.4

### New Features

-   (@abrault) Add Hazard tab to Compendium Browser
-   (@abrault) Add context menu to reroll a check
-   (@nikolaj-a) Toggle two-hand and versatile weapon traits

### Content Changes

-   (@TMun) Compendium updates
    -   Adds Gluttondark Babau (#563)
    -   Corrects Rain of Embers Stance (#619)
    -   Adds Fire Mephit (#623)
    -   Adds all AoA Hazards and missing monsters (#624, #631)
    -   Assigns rarity for every piece of equipment (#628)
    -   Corrects reactive shield level (#634)
    -   Corrects Mukradi resistance (#637)
    -   Updates all mutagens to include missing drawbacks; standardizes entries (#638)
    -   Corrects Bee swarm weakness (#639)
    -   Corrected Mountain Stronghold chain Corrects text for silver shields Adds Snare Specialist Feat from CRB (#640)
    -   Adds Advanced Player Guide, except for Pets, Familiars and magical items equipment other than rod of cancellation
-   (@Shandyan) Adding traits, including new ones from the Advanced Player's Guide

### Bug Fixes

-   (@abrault) Fix 404 errors with color scheme settings
-   (@abrault) Fix copy-paste error in compendium browser settings
-   (@blacksmithgu) Fix minor errors in setting descriptions
-   (@blacksmithgu) Fix #651: can now add custom item traits

### Core System Improvements

-   (@abrault) Move creature-specific code out of base Actor sheet
-   (@abrault) Change the NPC's init bonus to 0.5
-   (@abrault) Use npc actions for strikes in Hazard edit mode
-   (@abrault) Add missing icons for casting time
-   (@abrault) Adjust compendium css to avoid name spillage
-   (@Delethor) Loot actor dialog: avatar uses less space, inventory uses complete width, and doesn't display equip buttons
-   (@blacksmithgu) Fix typo in 'isNonPhysicalDamage'
-   (@blacksmithgu) Add types to condition modifiers
-   (@blacksmithgu) Add types for damage category
-   (@blacksmithgu) Delete unused readonly sheet implementation
-   (@TheCraiggers) Adds rarity filters for all applicable compendium browser sections

## Version 1.9.3

### Content Changes

-   (@TMun) Add EC3 monsters, correct wizard class and update alchemical bombs for splash damage (issues #612, #596, and #613)

### Bug Fixes

-   (@nikolaj-a) Fix unarmed strike damage for thief (issue #611)
-   (putty#0555) Support the bonus damage UI for strikes
-   (putty#0555) Fixed typo in weapon specialization

### Core System Improvements

-   (putty#0555) Initial support of splash damage for strikes
-   (putty#0555) Automation Cinderclaw Gauntlet

## Version 1.9.2

### Content Changes

-   (@Shandyan) Compendium updates
    -   Shameless Request Feat Missing from Feat Compendium (issue #599)
    -   Non-Uniform formatting in the Take Cover action (issue #600)
    -   Field Discovery: Chirurgeon contains text for Field Discovery: Bomber (issue #603)
    -   Alchemist's Tools entry not up-to-date (issue #605)
    -   Uncanny Bombs feat missing from compendium (issue #607)
    -   Aura of Righteousness and Effortless Concentration is missing from compendium (issue #609)
-   (@TMun) Compendium updates
    -   Updated GMG NPC Gallery with all NPCs
    -   Corrects or adds missing entries in Actions, Bestiary 1 and Spells databases (issues #582, #597, #604, #608, #616)

### Bug Fixes

-   (@nikolaj-a) Fix internal damage dice modifier predicate

### Core System Improvements

-   (putty#0555) Simple weapon property runes, automated weapon specialization, added a few unarmed strike-related monk feats
-   (@abrault) Remove redundant spell level from spellbook
-   (@nikolaj-a) Added roll options for initiative

## Version 1.9.1

### Content Changes

-   (@TMun) Compendium updates
    -   Add backgrounds from Agents of Edgewatch Player's Guide and update OGL with players guide copyright notice
    -   Add refocus exploration activity to Actions compendium
    -   Remove Age of Ashes duplicate monsters from Bestiary 1
    -   Move Fall of Plaguestone monsters to FoP Bestiary from Bestiary 1 and remove version number from FoP compendium
    -   Correct parazylzed spelling
    -   Add Laslunn from Age of Ashes book 3 to AoA Bestiary
    -   Adds missing class features related to spellcasting
-   (@Shandyan) Compendium updates
    -   Remove Archieve of Nethys links from Archetypes, Backgrounds, Classes, and Class Features compendia
    -   Format error for Quick Alchemy
    -   Update Equipment compendium to replace action images with font symbols
-   (@overdox) The Apocalypse Prophet Equipment update
-   (@meditatingCybermind) Added rage, inspire courage, and raise shield macros to compendium

### Bug Fixes

-   (@fryguy1013) Fix a couple of copy/paste errors with ids that were causing a duplicate id warning in Chrome
-   (@fryguy1013) Refactor spell contextual data so that temporary data doesn't get permanently get stuck in the data object
-   (@nikolaj-a) Remove non-functional damage roll dialog from strikes
-   (@abrault) Remove non-functional loot sheet edit checkbox

### Core System Improvements

-   (@abrault) Double dice for Strikes if using the crit variant
-   (putty#0555) Increase/Decrease bulk limits for differently sized creatures
-   (@nikolaj-a) More custom modifier selectors
-   (@iceman76) Improve setting initiative from chat log for NPCs

### Development Process Improvements

-   (@fryguy1013) TypeScript adaptations
-   (putty#0555) TypeScript adaptations

## Version 1.9.0

### New Features

-   (@fryguy1013) Add spell attack modifier to the spell tab on the player character sheet
-   (@fryguy1013) Add recovery roll button next to dying/wounded/doomed

### Content Changes

-   (@ryansobol) Compendium typos
    -   Fix #579 Telekinetic Maneuver misspelled as Telekinetic Manuever on the Spells Compendium
    -   Fix #561 Denizen of Leng wrong damage
-   (@Shandyan) Compendium updates
    -   Fix darkvision ability traits
    -   Fix light hammer and orc knuckle dagger bulk
    -   Fix pickpocket feat type
    -   Fix typo in baomal creature name
    -   Added missing traditions to Stabilize cantrip
    -   Adding missing spells traits
    -   Fix reach spell missing traits
    -   Fix gelatinous cube size
    -   Fix capitalization for bloody blade mercenary
    -   Added Ralldar to Age of Ashes compendium
    -   Fix Emblazon Energy level
    -   Minor errata fixes
    -   Removing duplicate feats
-   (@TMun) Compendium updates
    -   Updated NPC Gallery to include all NPCs up to the downtrodden section in the GMG
    -   Add the arcane spellcaster class feat
    -   Add Shoony Ancestry Blunt Nose feat
    -   General clean up of all feats - linked to compendia, deleted trailing whitespace and removed span id tags
    -   Remove AoN and paizo.com html links and replace single action and reaction images with system copies. Strips out AoN span ID tag from actions and equipment compendia
    -   Corrects mistform elixir
    -   Fixed conditions background color, as well as some links

### Bug Fixes

-   (@fryguy1013) Change the default value of treasure items to be worth 0 gp instead of 1 pp
-   (@fryguy1013) Fix typo in templates.json for spell display levels
-   (@fryguy1013) Add rollmode parameter to DicePF2e.d20Roll so that you can blind roll from a macro
-   (@fryguy1013) Add DicePF2e to the global scope so other modules can use it
-   (@nikolaj-a) Expose status effect API to macros

### Core System Improvements

-   (@fryguy1013) Condense rows in feats section, skills section, and spellbook on "new" character sheet
-   (@fryguy1013) Remove feat attack and tool checks, as it wasn't being used (5E stuff)
-   (@fryguy1013) Refactor MAP calculations to no longer store temporary data in the item's data object
-   (@abrault) Combined compendium browsers
-   (@abrault) Improve compression of images
-   (@abrault) Disable name mangling from the prod build
-   (@ryansobol) Fix item attribute "denomitation" should be spelled "denomination"
-   (@nikolaj-a) Bump Foundry core version compatibility to 0.6.5

### Development Process Improvements

-   (@fryguy1013) Add webpack progress bar plugin so it's easier to see what's going on when doing watch builds
-   (putty#0555) Smaller typings
-   (@ryansobol) Remove gulp dev dependencies
-   (@ryansobol) Fix the foundryconfig example file to be compatible with the project's editorconfig settings
-   (@ryansobol) Fix deprecation warning with node-gyp

## Version 1.8.0

### New Features

-   (@iceman76) Add filters to Feat Browser for boons and curses.

### Content Changes

-   (@iceman76) Compendium updates
    -   Give Pathfinder Society boons the correct feat type.
    -   Remove duplicate Pathfinder Society boon.
    -   Change "Rain of Embers Stance" from class feature to class feat.

### Core System Improvements

-   (@fryguy1013) Major upgrade to the technical foundation of the project, which should help streamline the release process and help us catch some bugs earlier on. A huge thanks for all the hard work that went into this!

## Version 1.7.0

### New Features

-   (ravenmaster_001#5375) Add support for proficiency variant rules.

### Bug Fixes

-   (@nikolaj-a) Fix overflow error in roll dialog

### Core System Improvements

-   (@fryguy1013) Clean up unused code, mostly leftovers from the D&D 5E game system.
-   (@nikolaj-a) Bump Foundry core version compatibility to 0.6.4

## Version 1.6.1

### Content Changes

-   (@Shandyan) Compendium updates
    -   Update spells compendium to correct a missed set of focus spells
    -   Update deities, equipment, feats, rollable-table compendia to replace AoN links with Foundry links
-   (@meditatingCybermind) Compendium updates
    -   Updated backgrounds, feats, and PFS boons from missions
    -   Added Lost Omens backgrounds
-   (@meditatingCybermind) Updated OGL with society credits

### Bug Fixes

-   (@iceman76) Correctly calculate when shields are broken.
-   (@iceman76) Correctly highlight buttons for rolling in skills tab.
-   (@nikolaj-a) Fix untyped bonus stacking
-   (@nikolaj-a) Use the actor as speaker when rolling

### Core System Improvements

-   (@iceman76) Add search field to trait selector window & freeze Update Actor button.
-   (@nikolaj-a) Flat damage modifiers with damage type
-   (@nikolaj-a) Conditional custom modifiers
-   (@nikolaj-a) Default attack and damage roll options
-   (@nikolaj-a) Support for default roll options

## Version 1.6.0

### New Features

-   (@nikolaj-a) Added custom damage dice and damage roll options

### Content Changes

-   (@overdox) Wrong text for Animal Trainer archetype has now been corrected
-   (@cora) Added four hazards from Ages of Ashes 2 into the adventure path bestiary.
-   (@Shandyan) Compendium updates
    -   Correcting the final (??) set of item/journal links for spells, items, feats etc.
    -   Replaced Aon links in actions, backgrounds and class compendium with links to other compendiums for actions, conditions, feats, equipment, spells, etc.
    -   AoN links to skills, traits and other rules entries not in Foundry have been left in place (for now).
-   (@Shandyan) Updated spells.db to fix various errors
    -   Made corrections to spells to address issue 554
    -   Corrected text of Modify Memory spell
    -   Made sure all focus spells are correctly listed as Focus rather than Spells.
-   (luke#4754) added ability glossary
-   (TMun#1625) Updated Iconics:
    -   Inventory redone to use containers
    -   All tokens have owner hover now set to hover
    -   Vision set to 5 dim/300dim/300bright for regular/low light/darkvision
    -   All names in the prototype token have the (level x) removed
-   (@meditatingCybermind & TMun#1625) Added pfs/deity boons and curses

### Bug Fixes

-   (@mirkoRainer) Fixed Religious Text bulk (is L, not negligible).

### Core System Improvements

-   (@nikolaj-a) Added support for more custom modifier formats for attack and damage rolls, including by weapon name and weapon ID. This will allow macros to target specific weapons or weapon types with modifiers. Also added an option to target damage modifiers on proficiency, which is needed for some of the class features.
-   (@abrault) Further optimisation to the Compendium Browser improving performance
-   (@mirkoRainer) Allow a character Deity image to be edited (by clicking the image and select a new file for it).

## Version 1.5.4

### Content Changes

-   (@Shandyan) Corrected spell entries in spell compendium for:
    -   Focus spells
    -   All spells up to and including level 10
-   (@overdox) Compendium update and fixes:
    -   Fixes from #532 (closed) added
    -   Steady Spellcasting have been merged into a sigle feat, as the text is the same for all the relevant classes (Bard, Cleric, Druid, Sorcerer, Wizard)
    -   New compendium for Archetypes added (albeit wip, updates to this will be added later, so feel free to merge it for now)
    -   Added all current archetypes to the compendium, excluding multiclass dedications
    -   Added missing archetype feat 'Judgement of the Monolith'
    -   Addded materials (chunks and ingots) to the equipment.

### Bug Fixes

-   (@iceman76) Unified apostrophes in item names to fix search functionality in compendium browsers

### Core System Improvements

-   (@L4D15) When moving stacked items between actors - show a popup to ask how many items you want to move.
-   (@In3luki) Status effect combat messages improvements:
    -   Show status effect combat messages only once per combatant.
    -   Don't show the messages for defeated combatants.
    -   Reset status effect combat message filter after combat has ended
-   (@In3luki) Display area size in spell chat card properties

## Version 1.5.3

### Content Changes

-   (@overdox) General changes:
    -   Bladed scarf is now categories as a martial weapon #519 (closed)
    -   Multiple issues in the compendium is now corrected #526 (closed) thanks @Lanastara for the nicely done bug report
    -   Updated class feature names to include what categorie they belong to, ie Wizards Arcane Thesis or Arcane School, or rangers Hunter's Edge.
    -   GMG (NPC Gallery) is now named NPC Gallery (GMG)
-   (@overdox) Pathfinder Society content:
    -   Added Rain of Embers Stance feat, from Pathfinder Society Quest #2 (closed): Unforgiving Fire pg. 20
    -   Added missing feat, Fey Influence from Pathfinder Society Scenario #1-17: The Perennial Crown Part 2, The Thorned Monarch pg. 30
-   (@overdox) Swapped out or updated various icons
-   (@putt1) Rename orc ranger to gray tusk in Fall of Plaguestone compendium
-   (@Shandyan) Made corrections to the cantrips and 1st level spells to address various errors in spell details (e.g. incorrect traits, damage type, missing areas, incorrect rarities etc).

### Bug Fixes

-   (@In3luki) Fixed status effect combat messages when mutliple GMs are in a game
-   (@In3luki) Fixed pressing enter in any input field on the character or NPC sheet rolls an action or attack
-   (@nikolaj-a) Changed the damage roll die modifier for powerful strike to only affect the base fist attack instead of all unarmed strikes. Previously it inadvertently reduced the die size of the various monk stances.
-   (@FS) Fixed issue when editing items on tokens that are not linked to an actor - #193 (closed).

### Core System Improvements

-   (@kenster421) Added automated skill bonus for Untrained Improvisation
-   (@abrault) Enabled roll initiative feature on actor sheet to work with PopOut! module.
-   (@overdox) Added rarity selection to feats under details. Feat sidebar now displays the traits that are selected, as well as level, rarity and action type
-   (@hooking) Adding (temporary) support for Thundering weapon runes
-   (@hooking) Improved the UI when editing weapon details to clearly group sections and to provide additional information.
-   (@hooking) Updated custom weapons to have sensible defaults for base weapon damage.
-   (@nikolaj-a) Changed the normal pool part of the damage roll to resolve to a minimum of one damage before any multipliers or divisions.
-   (@putt1) NPCs can now have treasure

## Version 1.5.2

### Bug Fixes

-   (@nikolaj-a) Fixed a number of bugs with the damage roll modifier system:
    -   Removed damage penalty from frightened and sickened conditions that were incorrectly being applied.
    -   Reduced the number of bonus damage dice from deadly trait.
-   (@hooking) Fixed multiple status messages from showing in chat.

## Version 1.5.1

### Bug Fixes

-   (@overdox) Quickfix for undefined spells appearing in spellbook
-   (@overdox) Fixed dziriak language
-   (@nikolaj-a) Allow untyped bonuses - Removed exception when trying to create an untyped bonus, as this was not really enforced anywhere in the rules.
-   (@abrault) Fixed total treasure and gold price disappearing from the char sheet

## Version 1.5.0

### New Features

-   (@FS) Added a new compendium pack for Pathfinder Bestiary 2.

![alt text](https://gitlab.com/hooking/foundry-vtt---pathfinder-2e/uploads/0b4a4cf0083f93bce8f68c2b562e24b0/PZO2104.jpg "Pathfinder Bestiary 2")

-   (@nikolaj-a) Added new damage and critical roll buttons for strikes in the Actions tab.
    -   Basic implementation of the damage roll mechanic for strikes.
    -   It supports rudimentary stacking rules for the numeric modifiers and will adjust dice for striking rune, deadly trait, fatal trait, thief version of rogue's racket, some custom modifiers, as well as most creature conditions.

![alt text](https://gitlab.com/hooking/foundry-vtt---pathfinder-2e/uploads/7b2ba2bbda6d7a1b1a27b9499d1a6d36/image.png "Updated Damage Rolls")

-   (@L4D15) Adds a new type of actor specifically designed to store loot.
    -   Added support to move items between characters inventories (rather than copying).
    -   Future features will be coming here for shops and an optimised UI.

![alt text](https://gitlab.com/hooking/foundry-vtt---pathfinder-2e/uploads/bf8f3d841e4d0282c7de585999cbf5ca/Annotation_2020-06-08_195934.png "Loot Actor")

### Content Changes

-   (@abrault) Added Weapon Resistance for Fury Barbarian
-   (@Shandyan) Corrected links Actions, Ancestry Features & Class Features compendiums entries
-   (@putt1) Added new immunities, traits and resistances used in Pathfinder Bestiary 2
-   (@overdox) Added all deities from Pathfinder Lost Omens: Gods & Magic
-   (@overdox) Added Abadars Flawless Scale (magic item)
-   (@overdox) Added the new languages; Destrachan, D'ziriak, Jistkan, Jyoti used in Pathfinder Bestiary 2
-   (@overdox) Improvements to spells in the Spell compendium
    -   Changing some of the structure on spells to add support for secondary checks, and secondary casters,
    -   Chaning area to be input type to support for things like "1/2-mile-radius circle centered on you".
    -   Adding Focus and Rituals as spell types.
    -   Moved Ritual and Focus spells to their own category, together with regular spells type
    -   under spell-details on like 26, I have changed traditions to point to 'spellTraditions' rather than 'magicTraditions', because things like 'bludgeoning' and 'bleed' has nothing to do with the type of tradition. The list now shows only the four correct magical traditions: Arcane, Divine, Occult, Primal.
    -   Spell sidebar will now also be displaying if there are primary or secondary checks on the ritual, or if it requires secondary casters.
    -   Updated spell compendium with changes to rituals, focus cantrips and 1st level focus spells.
-   (@overdox) Added missing rituals:
    -   Planar Binding
    -   Animate Object
    -   Atone
    -   Awaken Animal
    -   Blight
    -   Commune
    -   Commune With Nature
    -   Consecrate
    -   Create Undead
    -   Freedom
    -   Imprisonment
    -   Infernal Pact
    -   Inveigle
    -   Plant Growth
    -   Primal Call
-   (@hooking) Refreshed all Bestiary compendium packs to include data improvements from spells, conditions and updates to the importer.

### Bug Fixes

-   (@overdox) Fixed broken image links on condition entries

### Core System Improvements

-   (@In3luki) Improved status effect chat message logic to hide messages for hidden actors and to provide a configuration to disable.
-   (@overdox) Added a dropdown for selecting traits on consumables
-   (@overdox) Added rarity to spells and new line for Primary Check for rituals
-   (iceman) Improve wording for compendium settings.

## Version 1.4.3

### Content Changes

-   (Athenos) Added a missing NPC (Ralldar). The lowercase "Bloody Blade Mercenary" has also been fixed.
-   (@kenster421) Added monsters for Extinction Curse 02, 03 and 04.
-   (@overdox) Added the following new items:
    -   Anchor Spear
    -   Azure Worm Repellent
    -   Blightburn Ward
    -   Bomber's Saddle
    -   Crimson Worm Repellent
    -   Green Gut
    -   Heedless Spurs
    -   Life's Last Breath
    -   Purple Worm Repellent
    -   Staff of the Black Desert
    -   Staff of the Black Desert (Greater)
    -   Spear Frog Poison
    -   Yellow Musk Vial
    -   Toad Tears
    -   Rhoka Sword
    -   Gaff
    -   Shears
-   (@overdox) Added the following new spells:
    -   Blightburn Blast
    -   Control Sand
    -   Pillars of Sand
    -   Terminate Bloodline
    -   Undeath's Blessing
    -   Ravenous Reanimation
    -   Daemonic Pact
-   (@overdox) Content fixes
    -   Moonlit Chain is now correctly set to low-grade silver
    -   Dragonplate is now correctly set to standard-grade dragon hide
    -   Crushing Despair is now named correctly #499 (closed)
    -   Soothe has gained some more experience and now does the correct amount of healing #479 (closed)
    -   The feats Sabotage & Poison Weapon is now correctly indicated as class feats #475 (closed)
    -   Sling has been 'downgraded' to simple weapons #468 (closed)
    -   Added missing feat Dragon Transformation
    -   Abyssal Plague spell has had it information updated
    -   The Bomber class feature is now correctly set to be a class feature, rather than a bonus feat.
    -   Sorcerer bloodlines are now prefixed with 'Bloodline: name of bloodline'
-   (@Shandyan) Updated errata for spells and fixed broken links

### Bug Fixes

-   (@In3luki) Fixed multiple status effect chat messages showing during combat

### Core System Improvements

-   (@abrault) Added tests to treasure selling (this helps make system development more robust)
-   (@putt1) Allow a character to set ethnicity, nationality and traits such as human, humanoid
-   (@hooking) Updated PF2eCombatTracker to better support FVTT modules

## Version 1.4.2

-   Added support for Foundry v0.6.1

## Version 1.4.1

### Bug Fixes

-   (@putt1) Fixed bomb attack and damage rolls
-   (@In3luki) Fixed conditions to not break when checking for external modules.
-   (@nikolaj-a) Fixed a bug that broke the roll saving throw functionality on the NPC sheet.
-   (@putt1) Fixed armor bulk in equipment compendium

### Core System Improvements

-   (@Shandyan) Links to conditions in the Spells and Condition compendia now point to the conditions in the compendium, and so work if the conditions haven't been imported. Also, all condition links are now foundry-only, rather than some pointing to Archives of Nethys.
-   (@putt1) Added immunity for "immune to fear" effects
-   (@putt1 and @mdizo) Improved styling of actor sheet and dialog buttons
-   (@xneoterrax) Improved styling of spellbook tab (thanks for your first contribution!!)
-   (@overdox) Added item usage selector to the equipment sidebar.
-   (@nikolaj-a) Changed the zero check modifiers to not be disabled.
-   (@nikolaj-a) Supply a default modifier name for one off modifiers added in the roll dialog, if none is specified by the user.
-   (@hooking) Updated Equipment Browser to show an items price.

## Version 1.4.0

### New Features

-   (@In3luki) Added a setting to show the conditions of the active combatant in chat for each combat turn.
-   (@In3luki) Added an API to set conditions on a token programatically or via macros
-   (@putt1) Equipping a shield now sets it's values in the sidebar and allows you to udpate it's hp.
-   (@nikolaj-a and @mdizo) Changed saving throw, perception and skill rolls to use the new roll dialog with options to exclude individual modifiers and add new ones.

![alt text](https://gitlab.com/hooking/foundry-vtt---pathfinder-2e/uploads/3aa0a08dd37f63b3f6db1a0500cf928d/chrome_EaKZDZhXCi.png "New Roll Dialog")

### Content Changes

-   (@putt1) Renamed Adamantite to Adamantine
-   (@putt1) All shields and armors now have the correct broken treshold, hp, hardness, material, grade, potency, resiliency and property runes
-   (@putt1) Corrected the rune and materials settings on all weapons (except alchemical bombs).

### Bug Fixes

-   (@nikolaj-a) Fixed the heading of the modifiers tooltip for initiative to say initiative and the relevant skill name, instead of just saying perception all the time.
-   (@In3luki) Fixed error in CUB installation check.

### Core System Improvements

-   (@putt1) Updated bulk system to correctly add +2 bulk for hefty hauler feat and +1 bulk when the lifting belt is equipped.
-   (@putt1) Added 'light' as a damage type.
-   (@nikolaj-a) Changed the label for bonus HP and SP per level from shortening 'bonus' to instead shorten 'level', which should make it a little easier to understand.
-   (@nikolaj-a) Localized the heading of the initiative section in the sidebar.
-   (@nikolaj-a) Assigned a proper check type in the context for strikes (attack-roll) and initiative. This should help modules authors easier intercept the correct checks for further decoration.

## Version 1.3.1

### Core System Improvements

-   (@mdizo) Improved styling of view modifier hover and workflow for adding custom modifiers.

## Version 1.3.0

### New Features

-   (@nikolaj-a) Added functionality to add/remove modifiers for AC, Saving Throws, Initiative, Skills and Perception in the modifiers tooltip

![alt text](https://gitlab.com/hooking/foundry-vtt---pathfinder-2e/uploads/8e2f2ba292b358e1e5a2cc98972a499a/image.png "Edit Modifier")

-   (@nicolaj-a) Added an option to apply additional modifiers to a specific check before rolling the dice (only works for new roll dialog currently used for Strike actions).

### Content Changes

### Bug Fixes

-   (@abrault) Limit the scope of the Tooltipster module to the new actor sheet (it was global previously)
-   (@putt1) Fixed issue with focus points making them visible and clickable again
-   (@nikolaj-a) Ensure that the older trait format is better supported preventing player character sheets from opening.

### Core System Improvements

-   (@nilolaj-a) Changed behaviour of clicking a Strike action to only trigger the strike description expansion to only trigger when clicking the strike action name.
-   (@nikolaj-a) Added Battlefield Surveyor fighter class feature to the temporary automation for initiative modifiers.
-   (@nikolaj-a) Introduce a context parameter to the check roll dialog, which will allow support for fate (fortune and misfortune) effects. Provide UI for supplying a fate effect before executing the roll.

## Version 1.2.0

### New Features

-   (@putt1) Implemented a way to select all fundamental runes for weapons and armors.
    -   Fixes deadly dice being doubled/trippled by attacks that have no striking rune but more than one damage die
    -   Migrates attack boni of 1, 2, 3 and 4 to the potency rune equivalents

![alt text](https://gitlab.com/hooking/foundry-vtt---pathfinder-2e/uploads/83540ffac93f3d93e244ad971b3f86f8/image.png "Fundamental rune support")

-   (@putt1 and @mdizo) Added an initiative selector to the side bar and automatically applies initiative circumstance bonuses for feats:
    -   Incredible Initiative
    -   Elven Instincts
    -   Eye of Ozem
    -   Harmlessly Cute

![alt text](https://gitlab.com/hooking/foundry-vtt---pathfinder-2e/uploads/7007eb7aacb44242d4bd0554e674c554/image.png "Initiative support")

-   (@hooking and @nikolaj-a) Automated initiative rolls to automatically update combat tracker.
-   (tushycat#5011) Bestiary art for the following creatures now included as part of the system:
    -   Goblin Pyro
    -   Goblin Warchanter
    -   Goblin Warrior
    -   Hobgoblin Archer
    -   Hobgoblin Soldier
    -   Invisible Stalker
    -   Living Hurricane
    -   Living Landslide
    -   Living Whirlwind
    -   Sod Hound
    -   Storm Lord
    -   Zephyrhawk

![alt text](https://gitlab.com/hooking/foundry-vtt---pathfinder-2e/uploads/a0809641f1497a789a7f7750da001738/image.png "Goblin Warrior")

### Content Changes

-   (@overdox) Content improvements:
    -   Fix for the broken icon link on Perpetual Infusions (Bomber) #461 (closed)
    -   Renamed the Core Rulebook SRD compendium journal to better reflect it's content #460 (closed) The new name is now Deities.
-   (@kenster421) Added Bestiary for Extinction Curse:
    -   Added Xulgath-family monsters
    -   Added NPCs from EC01: The Show Must Go On
-   (@putt1) Added plaguestone hazards

### Bug Fixes

-   (@mdizo) Fixed the inline CSS from properly rendering images containing () in their filenames on item sheets.
-   (@hooking) Fixed loading prepared spellcasting actors who have an invalid data saved into a spell slot.
-   (@putt1) Fixed price for sorcerer kit

### Core System Improvements

-   (@nikolaj-a) Added link to show AC modifier tooltip as the AC calculation breakdown is not visible anywhere, and it can be hard to keep track of the source of all modifiers.
-   (@nikolaj-a) Added naive support for finesse on strikes, without taking into consideration conditions affecting the actor.
-   (@nikolaj-a) Applied extra CSS class to check modifier roll dialog to better enable styling.
-   (@nikolaj-a) Added an optional callback function parameter to the PF2Check roll and roll dialog to allow reacting to the roll result, like setting an initiative result.
-   (@nikolaj-a) Added class DC back into sidebar
-   (@nikolaj-a) Improved the initiative chat message to show the skill used when players roll for initiative.
    ![alt text](https://gitlab.com/hooking/foundry-vtt---pathfinder-2e/uploads/a28bfcc03746f7dd5b92791e3ca87322/image.png "Initiative message now shows the skill rolled")
-   (@nikolaj-a) Updated save modifiers to use armor name as resiliency item bonus label
    ![alt text](https://gitlab.com/hooking/foundry-vtt---pathfinder-2e/uploads/f11fed405dc55ff0ab30f3b08326d64b/image.png "Resiliency item bonus to saves")
-   (@nikolaj-a) Added an expandable panel for strike action and outcome descriptions, as well as showing the strike traits.
    ![alt text](https://gitlab.com/hooking/foundry-vtt---pathfinder-2e/uploads/03087cab175ddacb1fa9a863788fe72d/image.png "Strike expandable panel")
-   (@Noires) Changed en.json structure to be easier readable, editable and compatible with i18n editor
-   (@Noires) Significantly improved the translation support for the new character sheet
-   (@mdizo) Laid some basic foundations for future responsive design work.
-   (@abrault) Significant improvements to the compendium browsers
    -   New progress bar when compendium browser is first loading data from the compendium packs
    -   New clear filters button
    -   Optimised performance and refactored code to remove duplication and inefficiencies.
    -   Converted to an ES6 module
-   (@hooking) Removed legacy weapon damage dice selection as it has been replaced by the Striking rune feature.

## Version 1.1.0

### New Features

-   (@putt1) Added support for 'kits' in equipment system - items that can be dropped on an actor and expand into their contained parts (i.e. Adventurer's Pack and class kits).
    ![alt text](img/adventurers_pack.gif "Adventurers Pack auto expands into this")
-   (@putt1) Add precious materials and runes for weapons and armors.

![alt text](img/weapon_details_runes.png "Precious materials and runes")

### Content Changes

-   (@overdox) Added class kits (available in the compendium)

![alt text](img/classkits.png "Class Kits")

-   (@overdox) Set the correct bulk on the belt pouch and the bandolier

### Bug Fixes

-   (@nikolaj-a) Properly resolve and apply any custom weapon proficiencies for weapon strike actions (closes #452)
-   (@nikolaj-a) Added a missing CSS class that prevented the correct OwnedItem id being located in the form when trying to change or delete a custom martial proficiencies (closes #441).
-   (@hooking) Fixed the issue that was significantly effecting performance when adding compendium spells to actor sheet

### Core System Improvements

-   (@mdizo) CSS Revisions to CRB sheet
-   (@In3luki) Update migration message to show the system version instead of schema version
-   (@hooking) Updated the feat browser to show the icon of the feat item rather than the generic action indicator icon.
-   (@hooking) Fixed saving the scroll position for feat, skill and actions tabs when the actor sheet is rerendered.
-   (@nikolaj-a) Make consumable max charges editable to make it more versatile, like being usable for infused reagents for alchemists.
-   (@abrault) Added unique identifier to modifiers tooltips to prevent errors when multiple character sheets are open at once

## Version 1.0.1 "There will be bugs"

-   Fixed an issue preventing chracter sheets from opening when a spell has a spellcasting entry set but it is not valid.

## Version 1.0.0 "Beta"

### New Features

-   (@mdizo) A complete revamp of the actor sheet including sidebar, all tabs, hovers and headers!!! An amazing effort and a huge amount of work put in over these last few weeks!
-   (@hooking) Ruined @mdizo's beautiful sidebar by ripping most of the functionality out until future releases :P
-   (@meditatingCybermind) Added macros for 'rest for the night' and 'take a breather'

### Content Changes

-   (@overdox) new content:
    -   Added all 18th, 19th and 20th level items
    -   Added 18th, 19th, and 20th level rollable tables for consumables and permanent items
    -   Added missing traits to consumables and equipment
    -   Expanded the bulk options all the way to 50
    -   Added icons to all new equipment types
    -   Added a set of 9 default icon types for {Armor, Weapon, Consumable, Equipment, Feats, Shield, Treasure, Backpack, Spell}
        All level 1 trough to level 28 should now have been added to the compendium
-   (@Athenos) Updated Age of Ashes Bestiary
-   (tushycat#5011) Added bestiary icons to the system (these are not yet linked to bestiary actors but it is on it's way).

### Bug Fixes

-   (@meditatingCybermind) fixed sheets breaking when adding spells with no spellcasting entries
-   (@yeroon) Fixed the automatic behaviour of feats when importing from Compendium
-   (@unindel / FS) Fixed inline roll in NPC when no number of dice specified (i.e. [[d6+4]] instead of [[1d6+4]]
-   (@unindel / FS) Fixed #427 by only preparing spellbook of spellLvl for wands, scrolls, rituals and focus 'traditions'
-   (@putt1) improvements to equipment containers
-   (@meditatingCybermind) Fixed treat wounds macro

### Core System Improvements

-   (@yeroon) Removed the title from conditions in the Token HUD, as there already is a tooltip on the top of the HUD.
-   (@unindel / FS) Add elite weak modifier buttons to read only npc sheet
-   (@unindel) / FS) Display other spell levels for editable NPC sheet and PC sheet to improve empty spell slot scenarios
-   (@putt1) Rarity, level and equipped for all physical items
-   (@putt1) Add immunities
-   (@In3luki) Trait selector improvements
-   (@nikolaj-a) Improve strikes with some UI refinements
