"use strict";
function TranscoderWorkerWrapper() {
  let basisBinding;
  const messageHandlers = {
    init: (message) => self.BASIS ? (self.BASIS({ wasmBinary: message.wasmSource }).then((basisLibrary) => {
      basisLibrary.initializeBasis(), basisBinding = basisLibrary, self.postMessage({
        type: "init",
        success: !0
      });
    }), null) : (console.warn("jsSource was not prepended?"), {
      type: "init",
      success: !1
    }),
    transcode(message) {
      const basisData = message.basisData, BASIS = basisBinding, data = basisData, basisFile = new BASIS.BasisFile(data), imageCount = basisFile.getNumImages(), basisFormat = basisFile.getHasAlpha() ? message.rgbaFormat : message.rgbFormat, basisFallbackFormat = 14, imageArray = new Array(imageCount);
      let fallbackMode = !1;
      if (!basisFile.startTranscoding())
        return basisFile.close(), basisFile.delete(), {
          type: "transcode",
          requestID: message.requestID,
          success: !1,
          imageArray: null
        };
      for (let i = 0; i < imageCount; i++) {
        const levels = basisFile.getNumLevels(i), imageResource = {
          imageID: i,
          levelArray: new Array(),
          width: null,
          height: null
        };
        for (let j = 0; j < levels; j++) {
          const format = fallbackMode ? basisFallbackFormat : basisFormat, width = basisFile.getImageWidth(i, j), height = basisFile.getImageHeight(i, j), byteSize = basisFile.getImageTranscodedSizeInBytes(i, j, format), alignedWidth = width + 3 & -4, alignedHeight = height + 3 & -4;
          j === 0 && (imageResource.width = alignedWidth, imageResource.height = alignedHeight);
          const imageBuffer = new Uint8Array(byteSize);
          if (!basisFile.transcodeImage(imageBuffer, i, j, format, !1, !1)) {
            if (fallbackMode)
              return console.error(`Basis failed to transcode image ${i}, level ${j}!`), { type: "transcode", requestID: message.requestID, success: !1 };
            console.warn(`Basis failed to transcode image ${i}, level ${j}! Retrying to an uncompressed texture format!`), i = -1, fallbackMode = !0;
            break;
          }
          imageResource.levelArray.push({
            levelID: j,
            levelWidth: width,
            levelHeight: height,
            levelBuffer: imageBuffer
          });
        }
        imageArray[i] = imageResource;
      }
      return basisFile.close(), basisFile.delete(), {
        type: "transcode",
        requestID: message.requestID,
        success: !0,
        basisFormat: fallbackMode ? basisFallbackFormat : basisFormat,
        imageArray
      };
    }
  };
  self.onmessage = (e) => {
    const msg = e.data, response = messageHandlers[msg.type](msg);
    response && self.postMessage(response);
  };
}
exports.TranscoderWorkerWrapper = TranscoderWorkerWrapper;
//# sourceMappingURL=TranscoderWorkerWrapper.js.map
