import{isNewerVersion}from"../../common/utils/helpers.mjs";import{PACKAGE_AVAILABILITY_CODES}from"../../common/constants.mjs";import{World,System,Module,PACKAGE_TYPE_MAPPING}from"./_module.mjs";import PreviewCompatibility from"./preview-compatibility.mjs";import{ReleaseData}from"../../common/config.mjs";import ProgressEmitter from"../components/progress-emitter.mjs";export async function getPackages({type:e="system"}={}){const t=PACKAGE_TYPE_MAPPING[e];if(!t)throw new Error(`Invalid package type ${e} requested`);const{packages:r,owned:a}=await t.getRepositoryPackages();return{packages:Array.from(r.values()).map((e=>e.vend())),owned:a}}export async function getPackageFromRemoteManifest({type:e="module",manifest:t=""}={}){const r=PACKAGE_TYPE_MAPPING[e];return await r.fromRemoteManifest(t)}export async function checkPackage({type:e,id:t,manifest:r,forceSidegrade:a=!1,strict:o=!0}={}){const s=PACKAGE_TYPE_MAPPING[e];if(!s)throw new Error(`Invalid package type ${e} requested`);const n=s.get(t,{strict:!1});if(!r){if(!n.manifest)throw new Error(`The ${e} ${t} has no manifest URL provided`);r=n.manifest}const i=await s.check(r,n,{strict:o}),c=i.remote;let p;if(t||=c.id,(n||a)&&(p=await s.fromRepository(t),a&&p&&c.sidegrade(c,p)),n&&p&&(!c||isNewerVersion(p.version,c.version))&&(i.trackChange=n.suggestTrackChange(p),i.trackChange&&i.error&&404===i.errorCode&&delete i.error,i.trackChange))return i;if(!c)return i;if("module"===e){i.systemCompatibility={};for(const{id:e,compatibility:t}of c.relationships?.systems??[]){const r=System.get(e,{strict:!1});r&&(i.systemCompatibility[e]={id:e,title:r.title,compatible:c.constructor.testDependencyCompatibility(t,r)&&!r.unavailable})}}if(i.isUpgrade||i.isDowngrade)return i;if(n){n.sidegrade(c,p)&&(i.hasSidegraded=!0)}return i}export async function installPackage({type:e,id:t,manifest:r,force:a=!1}){const o=PACKAGE_TYPE_MAPPING[e];if(!o)throw new Error(`Invalid package type ${e} requested`);if(!r)throw new Error("A manifest URL must be provided");const s=await checkPackage({type:e,id:t,manifest:r,forceSidegrade:!0}),n=s.remote;if(!n){let t=[`Unable to load valid ${e} manifest data from "${r}"`,s.error].filterJoin("\n");throw new Error(t)}if(t=n.id,s.isDowngrade&&!a)throw new Error(`You are currently using a more recent version of ${e} ${n.title} and may not downgrade to an older version`);const i=n.availability,c=PACKAGE_AVAILABILITY_CODES;if(!a){if(i===c.REQUIRES_CORE_DOWNGRADE)throw new Error(`${e} ${t} version ${n.version} requires an older version of the Foundry Virtual Tabletop software: ${n.compatibility.maximum} or older`);if([c.REQUIRES_CORE_UPGRADE_STABLE,c.REQUIRES_CORE_UPGRADE_UNSTABLE].includes(i))throw new Error(`${e} ${t} version ${n.version} requires a more modern version of the Foundry Virtual Tabletop software: ${n.compatibility.minimum} or newer`)}let p,l=n.download;if(n.protected){if(p=await o.getProtectedDownloadURL({type:e,id:t,version:n.version}),"error"===p.status)throw new Error(p.message);l=p.download}if(!l)throw new Error(`The ${n.title} ${e} does not provide a download URL that can be installed`);const E={};return new Promise((async(a,s)=>{let n;const{ACTIONS:i,STEPS:c}=CONST.SETUP_PACKAGE_PROGRESS,m=new ProgressEmitter(i.INSTALL_PKG,null,1,{type:e,id:r,title:t}),d={[c.DOWNLOAD]:"Downloading package",[c.INSTALL]:"Installing package"};try{const e=await o.install(t,r,l,p,{onFetched:()=>a(E),onProgress:(e,t,r)=>{e!==n&&(m.nextStep(e,r,{message:`SETUP.PackageProgress${e.titleCase()}`}),n=e),m.emit(t,{log:d[e]})},onError:(e,t)=>{if(e===c.DOWNLOAD)return s(t);m.error(t)}});if(!e)return m.error(new Error("PACKAGE.InstallFailed"),{context:{packageWarnings:{[t]:packages.warnings.toJSON()[t]}}});m.complete({context:{pkg:e.vend()}})}catch(e){m.error(e),s(e)}}))}export async function resetPackages(){return Module.resetPackages(),System.resetPackages(),World.resetPackages(),{message:"Reset package cache for all package types"}}export async function uninstallPackage({type:e,id:t}){const r=PACKAGE_TYPE_MAPPING[e];if(!r)throw new Error(`Invalid package type ${e} requested`);const a=r.uninstall(t);return a.uninstalled=!0,a}export async function lockPackage({type:e,id:t,shouldLock:r}){const a=PACKAGE_TYPE_MAPPING[e];if(!a)throw new Error(`Invalid package type ${e} requested`);return a.get(t,{strict:!1}).lock(r),{message:`Locked package ${t}`}}export async function handlePreviewCompatibility({release:e}){const t=new PreviewCompatibility(new ReleaseData(e));return await t.evaluate(),t.vend()}export function handleCreateBackups({backups:e}){const{packages:t,express:r}=global,{ACTIONS:a,STEPS:o}=CONST.SETUP_PACKAGE_PROGRESS;return t.backups.createBackups(e).catch((e=>{r.io.emit("progress",{action:a.CREATE_BACKUP,step:o.ERROR,error:e.message,stack:e.stack})})),{}}export function handleCreateSnapshot({note:e,id:t}){const{packages:r,express:a}=global,{ACTIONS:o,STEPS:s}=CONST.SETUP_PACKAGE_PROGRESS;return r.backups.createSnapshot({note:e,id:t}).catch((e=>{a.io.emit("progress",{action:o.CREATE_SNAPSHOT,steps:s.ERROR,error:e.message,stack:e.stack})})),{}}export function handleDeleteBackups({backups:e}){const{packages:t,express:r}=global,{ACTIONS:a,STEPS:o}=CONST.SETUP_PACKAGE_PROGRESS;return t.backups.deleteBackups(e).catch((e=>{r.io.emit("progress",{action:a.DELETE_BACKUP,step:o.ERROR,error:e.message,stack:e.stack})})),{}}export function handleDeleteSnapshots({snapshots:e}){const{packages:t,express:r}=global,{ACTIONS:a,STEPS:o}=CONST.SETUP_PACKAGE_PROGRESS;return t.backups.deleteSnapshots(e).catch((e=>{r.io.emit("progress",{action:a.DELETE_SNAPSHOT,step:o.ERROR,error:e.message,stack:e.stack})})),{}}export function handleRestoreBackups({backups:e}){const{packages:t,express:r}=global,{ACTIONS:a,STEPS:o}=CONST.SETUP_PACKAGE_PROGRESS;return t.backups.restoreBackups(e).catch((e=>{r.io.emit("progress",{action:a.RESTORE_BACKUP,steps:o.ERROR,error:e.message,stack:e.stack})})),{}}export function handleRestoreSnapshot({snapshotData:e}){const{packages:t,express:r}=global,{ACTIONS:a,STEPS:o}=CONST.SETUP_PACKAGE_PROGRESS;return t.backups.restoreSnapshot(e).catch((e=>{r.io.emit("progress",{action:a.RESTORE_SNAPSHOT,steps:o.ERROR,error:e.message,stack:e.stack})})),{}}